# Always prefer setuptools over distutils
from setuptools import setup, find_packages

# To use a consistent encoding
from codecs import open
import os 
from os import path

# The directory containing this file
HERE = path.abspath(path.dirname(__file__))

# Get the long description from the README file
# with open(path.join(HERE, 'README.md'), encoding='utf-8') as f:
#     long_description = f.read()

READ_ME = open(os.path.join(HERE, "README.rst"), encoding='utf-8').read()



# READ_ME="Tensorflow object detection automatically from user input."
# This call to setup() does all the work
setup(
    name="TFOD_Automatic",
    version="1.3",
    description="Automated Object detection for Beginner using python and Tensorflow",
    long_description=READ_ME,
    # long_description_content_type="text/x-markdown",
    long_description_content_type="text/x-rst",
    url="https://TFOD_Automatic.readthedocs.io/",
    author="Lohit Sundaramahalingam",
    author_email="lohit.cs19@bitsathy.ac.in",
    license="MIT License",
    classifiers=[
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        'Operating System :: Microsoft :: Windows :: Windows 10'
    ],
    packages=["TFOD_Automatic"],
    include_package_data=True,
    install_requires=["absl-py==0.12.0","apache-beam==2.33.0","argon2-cffi==21.1.0","astunparse==1.6.3","attrs==21.2.0","avro-python3==1.9.2.1","backcall==0.2.0","bleach==4.1.0","cachetools==4.2.2","certifi==2021.5.30",
        "cffi==1.14.6","charset-normalizer==2.0.4","clang==5.0","colorama==0.4.4","contextlib2==21.6.0","crcmod==1.7","cycler==0.10.0","Cython==0.29.24","debugpy==1.4.1","decorator==5.0.9","defusedxml==0.7.1",
        "dill==0.3.1.1",
        "distlib==0.3.4",
        "dm-tree==0.1.6",
        "docopt==0.6.2",
        "entrypoints==0.3",
        "fastavro==1.4.7",
        "filelock==3.4.2",
        "flatbuffers==1.12",
        "future==0.18.2",
        "gast==0.4.0",
        "gin-config==0.4.0",
        "gitdb==4.0.7",
        "GitPython==3.1.24",
        "google-api-core==2.0.1",
        "google-api-python-client==2.27.0",
        "google-auth==1.35.0",
        "google-auth-httplib2==0.1.0",
        "google-auth-oauthlib==0.4.6",
        "google-pasta==0.2.0",
        "googleapis-common-protos==1.53.0",
        "grpcio==1.39.0",
        "h5py==3.1.0",
        "hdfs==2.6.0",
        "httplib2==0.19.1",
        "idna==3.2",
        "importlib-resources==5.2.2",
        "ipykernel==6.3.1",
        "ipython==7.27.0",
        "ipython-genutils==0.2.0",
        "ipywidgets==7.6.4",
        "jedi==0.18.0",
        "Jinja2==3.0.1",
        "joblib==1.0.1",
        "jsonschema==3.2.0",
        "jupyter==1.0.0",
        "jupyter-client==7.0.2",
        "jupyter-console==6.4.0",
        "jupyter-core==4.7.1",
        "jupyterlab-pygments==0.1.2",
        "jupyterlab-widgets==1.0.1",
        "kaggle==1.5.12",
        "keras==2.6.0",
        "Keras-Preprocessing==1.1.2",
        "kiwisolver==1.3.2",
        "labelImg==1.8.5",
        "lvis==0.5.3",
        "lxml==4.6.3",
        "Markdown==3.3.4",
        "MarkupSafe==2.0.1",
        "matplotlib==3.4.3",
        "matplotlib-inline==0.1.2",
        "mistune==0.8.4",
        "nbclient==0.5.4",
        "nbconvert==6.1.0",
        "nbformat==5.1.3",
        "nest-asyncio==1.5.1",
        "notebook==6.4.3",
        "numpy==1.19.5",
        "oauth2client==4.1.3",
        "oauthlib==3.1.1",
        "opencv-python==4.5.3.56",
        "opencv-python-headless==4.5.4.58",
        "opt-einsum==3.3.0",
        "orjson==3.6.4",
        "packaging==21.0",
        "pandas==1.3.2",
        "pandocfilters==1.4.3",
        "parso==0.8.2",
        "pickleshare==0.7.5",
        "Pillow==8.3.2",
        "platformdirs==2.4.1",
        "portalocker==2.3.2",
        "prometheus-client==0.11.0",
        "promise==2.3",
        "prompt-toolkit==3.0.20",
        "protobuf==3.17.3",
        "psutil==5.8.0",
        "py-cpuinfo==8.0.0",
        "pyarrow==4.0.1",
        "pyasn1==0.4.8",
        "pyasn1-modules==0.2.8",
        "pycocotools-windows==2.0.0.2",
        "pycparser==2.20",
        "pydot==1.4.2",
        "Pygments==2.10.0",
        "pyparsing==2.4.7",
        "PyQt5==5.15.4",
        "PyQt5-Qt5==5.15.2",
        "PyQt5-sip==12.9.0",
        "pyrsistent==0.18.0",
        "python-dateutil==2.8.2",
        "python-slugify==5.0.2",
        "pytz==2021.1",
        "pywin32==301",
        "pywinpty==1.1.4",
        "PyYAML==5.4.1",
        "pyzmq==22.2.1",
        "qtconsole==5.1.1",
        "QtPy==1.11.0",
        "regex==2021.8.28",
        "requests==2.26.0",
        "requests-oauthlib==1.3.0",
        "rsa==4.7.2",
        "sacrebleu==2.0.0",
        "scikit-learn==0.24.2",
        "scipy==1.7.1",
        "Send2Trash==1.8.0",
        "sentencepiece==0.1.96",
        "seqeval==1.2.2",
        "six==1.15.0",
        "smmap==4.0.0",
        "tabulate==0.8.9",
        "tensorboard==2.6.0",
        "tensorboard-data-server==0.6.1",
        "tensorboard-plugin-wit==1.8.0",
        "tensorflow==2.6.0",
        "tensorflow-addons==0.14.0",
        "tensorflow-datasets==4.4.0",
        "tensorflow-estimator==2.6.0",
        "tensorflow-hub==0.12.0",
        "tensorflow-io==0.23.1",
        "tensorflow-io-gcs-filesystem==0.23.1",
        "tensorflow-metadata==1.2.0",
        "tensorflow-model-optimization==0.6.0",
        "tensorflow-text==2.6.0",
        "termcolor==1.1.0",
        "terminado==0.11.1",
        "testpath==0.5.0",
        "text-unidecode==1.3",
        "tf-models-official==2.6.0",
        "tf-slim==1.1.0",
        "threadpoolctl==2.2.0",
        "tornado==6.1",
        "tqdm==4.62.2",
        "traitlets==5.1.0",
        "typeguard==2.12.1",
        "typing-extensions==3.7.4.3",
        "uritemplate==3.0.1",
        "urllib3==1.26.6",
        "virtualenv==20.13.0",
        "wcwidth==0.2.5",
        "webencodings==0.5.1",
        "Werkzeug==2.0.1",
        "wget==3.2",
        "widgetsnbextension==3.5.1",
        "wincertstore==0.2",
        "wrapt==1.12.1",
        "zipp==3.5.0"
        ]
)