# -*- coding: utf-8 -*-
"""
Module estimartor_loader.py
--------------------------------------------
A Loader for estimators generated by the `c5.fit` call; 
"""
import importlib.util
import sys

def load_estimator(path:str):
    module_name = path.split('/')[-1].replace('.py', '').replace('-','_')
    spec = importlib.util.spec_from_file_location(module_name, path)
    module = importlib.util.module_from_spec(spec)
    spec.loader.exec_module(module)
    
    Estimator = getattr(module, 'Estimator')
    
    return Estimator