## Installation

`pip install volprofile`

## Volume Profile Analysis Package

This package provides functions for analyzing volume profile data using Python. 
The package includes the following functions:

## Functions

### `getVP(df: pd.DataFrame, nBins: int = 20) -> pd.DataFrame`

This function takes a Pandas DataFrame with columns price and volume, and returns a DataFrame consisting of minPrice, maxPrice, and aggregateVolume for each price bin.

### `getVPWithOHLC(df: pd.DataFrame, nBins: int = 20) -> pd.DataFrame`

This function takes a Pandas DataFrame with columns open, high, low, close, and volume, and returns a DataFrame consisting of minPrice, maxPrice, and aggregateVolume for each price bin. It uses the OHLC data to calculate more accurate price bins.

### `getKMaxBars(volprofile_result: pd.DataFrame, k: int) -> pd.DataFrame`

This function takes a DataFrame generated by getVP or getVPWithOHLC, and returns the top k price bins with the highest aggregate volume.

### `getUnusualIncreasingBars(df: pd.DataFrame, isUpward: bool) -> pd.DataFrame`

This function takes a DataFrame generated by getVP or getVPWithOHLC, and returns the price bins that have experienced unusual increases in volume. The isUpward parameter determines whether to search for upward or downward trends.

### `plot(df: pd.DataFrame, price) -> None`

This function takes a DataFrame generated by getVP or getVPWithOHLC, and a price series, and generates a plot of the volume profile.
Installation

To install the package, run:

`pip install volprofile`

## Example Usage

```python

import pandas as pd
from volprofile import getVP, plot

# Load data
df = pd.read_csv('mydata.csv')

# Calculate volume profile
vp = getVPWithOHLC(df)

# Plot volume profile
plot(vp, df['price'])
```
