#!/usr/bin/env python3

"""The setup script."""

from setuptools import setup, find_packages, Extension

with open('README.rst') as readme_file:
    readme = readme_file.read()

with open('HISTORY.rst') as history_file:
    history = history_file.read()

requirements = []

setup_requirements = ['pytest-runner', ]

test_requirements = ['pytest>=3', ]

setup(
    author="Peter Nardi",
    author_email='pete@nardi.com',
    python_requires='>=3.5',
    classifiers=[
      "Development Status :: 4 - Beta",
      "Intended Audience :: Education",
      "Intended Audience :: Developers",
      "Intended Audience :: System Administrators",
      "License :: OSI Approved :: MIT License",
      "Natural Language :: English",
      "Topic :: Education",
      "Topic :: Internet :: Log Analysis",
      "Topic :: Security",
      "Topic :: System :: Logging",
      "Topic :: System :: Systems Administration",
      "Programming Language :: Python :: 3",
      "Programming Language :: Python :: 3.5",
      "Programming Language :: Python :: 3.6",
      "Programming Language :: Python :: 3.7",
      "Programming Language :: Python :: 3.8",
      "Programming Language :: Python :: 3.9",
      "License :: OSI Approved :: MIT License",
      "Operating System :: OS Independent",
    ],
    description="Extract individual fields from lines in Apache logs.",
    install_requires=requirements,
    license="MIT license",
    long_description=readme + '\n\n' + history,
    long_description_content_type='text/x-rst',
    include_package_data=True,
    keywords='parser201 apache log parse parser scanner web server',
    name='parser201',
    packages=find_packages(include=['parser201', 'parser201.*']),
    setup_requires=setup_requirements,
    test_suite='tests',
    tests_require=test_requirements,
    url='https://github.com/geozeke/parser201',
    version='0.1.7',
    zip_safe=False,
)
