"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import abc
import collections.abc
import common.common_pb2
import deploy.serve_pb2
import google.protobuf.empty_pb2
import grpc

class ServingServiceStub:
    def __init__(self, channel: grpc.Channel) -> None: ...
    Create: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.ServingRequest,
        deploy.serve_pb2.Serving,
    ]
    """Creates a new Serving Group.
    If `.models` are specified, the Serving Group will be created with new
    `len(.models)` models.
    """
    GetServing: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.ServingRequest,
        deploy.serve_pb2.Serving,
    ]
    """Get all available info for a Serving Group. All `.models` are populated."""
    ListServings: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.ServingListRequest,
        deploy.serve_pb2.ServingListResponse,
    ]
    """Get list of Serving Grpup(s) of a user/workspace."""
    DeleteServing: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.ServingRequest,
        google.protobuf.empty_pb2.Empty,
    ]
    """Delete a Serving Group and all its models."""
    UpdateServing: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.UpdateServingRequest,
        deploy.serve_pb2.Serving,
    ]
    """Update a Serving Group. Only the fields specified in the `update_mask` are
    updated.
    """

class ServingServiceServicer(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def Create(
        self,
        request: deploy.serve_pb2.ServingRequest,
        context: grpc.ServicerContext,
    ) -> deploy.serve_pb2.Serving:
        """Creates a new Serving Group.
        If `.models` are specified, the Serving Group will be created with new
        `len(.models)` models.
        """
    @abc.abstractmethod
    def GetServing(
        self,
        request: deploy.serve_pb2.ServingRequest,
        context: grpc.ServicerContext,
    ) -> deploy.serve_pb2.Serving:
        """Get all available info for a Serving Group. All `.models` are populated."""
    @abc.abstractmethod
    def ListServings(
        self,
        request: deploy.serve_pb2.ServingListRequest,
        context: grpc.ServicerContext,
    ) -> deploy.serve_pb2.ServingListResponse:
        """Get list of Serving Grpup(s) of a user/workspace."""
    @abc.abstractmethod
    def DeleteServing(
        self,
        request: deploy.serve_pb2.ServingRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Delete a Serving Group and all its models."""
    @abc.abstractmethod
    def UpdateServing(
        self,
        request: deploy.serve_pb2.UpdateServingRequest,
        context: grpc.ServicerContext,
    ) -> deploy.serve_pb2.Serving:
        """Update a Serving Group. Only the fields specified in the `update_mask` are
        updated.
        """

def add_ServingServiceServicer_to_server(servicer: ServingServiceServicer, server: grpc.Server) -> None: ...

class ModelServiceStub:
    def __init__(self, channel: grpc.Channel) -> None: ...
    GetModel: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.ModelRequest,
        deploy.serve_pb2.Model,
    ]
    """Get all available info for a model."""
    Watch: grpc.UnaryStreamMultiCallable[
        deploy.serve_pb2.ModelRequest,
        deploy.serve_pb2.ServingStatus,
    ]
    """Watch for status update of a model in Serving Group."""
    UploadModel: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.ModelRequest,
        deploy.serve_pb2.Model,
    ]
    """Get S3 Upload URL for new/existing Model in Serving Group.
    If id is none then creates new Model with id `id` in the Serving Group.
    If model's serving_group_id is none/doesn't exist, then throws error.
    """
    Deploy: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.ModelRequest,
        deploy.serve_pb2.Model,
    ]
    """Deploy new model in Serving Group."""
    ModelLogs: grpc.UnaryStreamMultiCallable[
        deploy.serve_pb2.ModelRequest,
        common.common_pb2.Log,
    ]
    """Get logs of a model."""
    ListModels: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.ModelListRequest,
        deploy.serve_pb2.ModelListResponse,
    ]
    """Get list of models in a Serving Group."""
    DeleteModel: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.ModelRequest,
        google.protobuf.empty_pb2.Empty,
    ]
    """Delete a model in a Serving Group."""
    SetModelPin: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.ModelRequest,
        google.protobuf.empty_pb2.Empty,
    ]
    """Pinned a model of a Serving Group."""
    UpdateModel: grpc.UnaryUnaryMultiCallable[
        deploy.serve_pb2.UpdateModelRequest,
        deploy.serve_pb2.Model,
    ]
    """Update a model of a Serving Group."""

class ModelServiceServicer(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def GetModel(
        self,
        request: deploy.serve_pb2.ModelRequest,
        context: grpc.ServicerContext,
    ) -> deploy.serve_pb2.Model:
        """Get all available info for a model."""
    @abc.abstractmethod
    def Watch(
        self,
        request: deploy.serve_pb2.ModelRequest,
        context: grpc.ServicerContext,
    ) -> collections.abc.Iterator[deploy.serve_pb2.ServingStatus]:
        """Watch for status update of a model in Serving Group."""
    @abc.abstractmethod
    def UploadModel(
        self,
        request: deploy.serve_pb2.ModelRequest,
        context: grpc.ServicerContext,
    ) -> deploy.serve_pb2.Model:
        """Get S3 Upload URL for new/existing Model in Serving Group.
        If id is none then creates new Model with id `id` in the Serving Group.
        If model's serving_group_id is none/doesn't exist, then throws error.
        """
    @abc.abstractmethod
    def Deploy(
        self,
        request: deploy.serve_pb2.ModelRequest,
        context: grpc.ServicerContext,
    ) -> deploy.serve_pb2.Model:
        """Deploy new model in Serving Group."""
    @abc.abstractmethod
    def ModelLogs(
        self,
        request: deploy.serve_pb2.ModelRequest,
        context: grpc.ServicerContext,
    ) -> collections.abc.Iterator[common.common_pb2.Log]:
        """Get logs of a model."""
    @abc.abstractmethod
    def ListModels(
        self,
        request: deploy.serve_pb2.ModelListRequest,
        context: grpc.ServicerContext,
    ) -> deploy.serve_pb2.ModelListResponse:
        """Get list of models in a Serving Group."""
    @abc.abstractmethod
    def DeleteModel(
        self,
        request: deploy.serve_pb2.ModelRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Delete a model in a Serving Group."""
    @abc.abstractmethod
    def SetModelPin(
        self,
        request: deploy.serve_pb2.ModelRequest,
        context: grpc.ServicerContext,
    ) -> google.protobuf.empty_pb2.Empty:
        """Pinned a model of a Serving Group."""
    @abc.abstractmethod
    def UpdateModel(
        self,
        request: deploy.serve_pb2.UpdateModelRequest,
        context: grpc.ServicerContext,
    ) -> deploy.serve_pb2.Model:
        """Update a model of a Serving Group."""

def add_ModelServiceServicer_to_server(servicer: ModelServiceServicer, server: grpc.Server) -> None: ...
