
<img align="left" width="100" height="100" src="data:image/png;base64,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">

# oplab-client-python
[![PyPI version fury.io](https://badge.fury.io/py/oplab-client-python.svg)](https://pypi.org/project/oplab-client-python/)
<img src="https://img.shields.io/discord/701830367912656928?logo=discord"
            alt="chat on Discord"></a>


## Description
This pip package's intent is to provide a safe and easy way to interact with [Oplab's public API](https://docs.oplab.com.br). With it, you should be able to use the latest feature additions to the API as we publish them.

## Installation

`pip install oplab-client-python`

## Usage
// TODO

## Support
You can go to our Discord server and ask for some help over the **[#devtalk](https://discord.gg/xmAZzRd)** channel. You can also just open an issue asking for help. Use the `help` label.
## Roadmap
If you have ideas for releases in the future, it is a good idea to list them in the README.

## Contributing
We accept contributions. Just send us a pull request if you have some improvement to contribute!

## Authors and acknowledgment

Made with care by the oplab-team.

## License
MIT

## Project status
This project is still @ it's dawn. If you feel like contributing, or participating in any forms, just send us an issue.
