# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class AlgorithmInformation_2009:

    _name_  = u'AlgorithmInformation-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 58]
    
    _obj_ = [
        u'ParamOptions',
        u'DIGEST-ALGORITHM',
        u'SIGNATURE-ALGORITHM',
        u'PUBLIC-KEY',
        u'KEY-TRANSPORT',
        u'KEY-AGREE',
        u'KEY-WRAP',
        u'KEY-DERIVATION',
        u'MAC-ALGORITHM',
        u'CONTENT-ENCRYPTION',
        u'ALGORITHM',
        u'AlgorithmIdentifier',
        u'SMIME-CAPS',
        u'SMIMECapability',
        u'SMIMECapabilities',
        ]
    _type_ = [
        u'ParamOptions',
        u'DIGEST-ALGORITHM',
        u'SIGNATURE-ALGORITHM',
        u'PUBLIC-KEY',
        u'KEY-TRANSPORT',
        u'KEY-AGREE',
        u'KEY-WRAP',
        u'KEY-DERIVATION',
        u'MAC-ALGORITHM',
        u'CONTENT-ENCRYPTION',
        u'ALGORITHM',
        u'AlgorithmIdentifier',
        u'SMIME-CAPS',
        u'SMIMECapability',
        u'SMIMECapabilities',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        u'DIGEST-ALGORITHM',
        u'SIGNATURE-ALGORITHM',
        u'PUBLIC-KEY',
        u'KEY-TRANSPORT',
        u'KEY-AGREE',
        u'KEY-WRAP',
        u'KEY-DERIVATION',
        u'MAC-ALGORITHM',
        u'CONTENT-ENCRYPTION',
        u'ALGORITHM',
        u'SMIME-CAPS',
        ]
    _param_ = [
        u'AlgorithmIdentifier',
        u'SMIMECapability',
        u'SMIMECapabilities',
        ]
    
    #-----< ParamOptions >-----#
    ParamOptions = ENUM(name=u'ParamOptions', mode=MODE_TYPE)
    ParamOptions._cont = ASN1Dict([(u'required', 0), (u'preferredPresent', 1), (u'preferredAbsent', 2), (u'absent', 3), (u'inheritable', 4), (u'optional', 5)])
    ParamOptions._ext = []
    
    #-----< DIGEST-ALGORITHM >-----#
    DIGEST_ALGORITHM = CLASS(name=u'DIGEST-ALGORITHM', mode=MODE_TYPE)
    _DIGEST_ALGORITHM_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _DIGEST_ALGORITHM_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _DIGEST_ALGORITHM_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    DIGEST_ALGORITHM._cont = ASN1Dict([
        (u'id', _DIGEST_ALGORITHM_id),
        (u'Params', _DIGEST_ALGORITHM_Params),
        (u'paramPresence', _DIGEST_ALGORITHM_paramPresence),
        ])
    
    #-----< SIGNATURE-ALGORITHM >-----#
    SIGNATURE_ALGORITHM = CLASS(name=u'SIGNATURE-ALGORITHM', mode=MODE_TYPE)
    _SIGNATURE_ALGORITHM_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _SIGNATURE_ALGORITHM_Value = OPEN(name=u'Value', mode=MODE_TYPE, opt=True)
    _SIGNATURE_ALGORITHM_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _SIGNATURE_ALGORITHM_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _SIGNATURE_ALGORITHM_HashSet = CLASS(name=u'HashSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')), opt=True)
    _SIGNATURE_ALGORITHM_PublicKeySet = CLASS(name=u'PublicKeySet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')), opt=True)
    _SIGNATURE_ALGORITHM_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    SIGNATURE_ALGORITHM._cont = ASN1Dict([
        (u'id', _SIGNATURE_ALGORITHM_id),
        (u'Value', _SIGNATURE_ALGORITHM_Value),
        (u'Params', _SIGNATURE_ALGORITHM_Params),
        (u'paramPresence', _SIGNATURE_ALGORITHM_paramPresence),
        (u'HashSet', _SIGNATURE_ALGORITHM_HashSet),
        (u'PublicKeySet', _SIGNATURE_ALGORITHM_PublicKeySet),
        (u'smimeCaps', _SIGNATURE_ALGORITHM_smimeCaps),
        ])
    
    #-----< PUBLIC-KEY >-----#
    PUBLIC_KEY = CLASS(name=u'PUBLIC-KEY', mode=MODE_TYPE)
    _PUBLIC_KEY_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _PUBLIC_KEY_KeyValue = OPEN(name=u'KeyValue', mode=MODE_TYPE, opt=True)
    _PUBLIC_KEY_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _PUBLIC_KEY_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _PUBLIC_KEY_keyUsage = BIT_STR(name=u'keyUsage', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyUsage')), opt=True)
    _PUBLIC_KEY_PrivateKey = OPEN(name=u'PrivateKey', mode=MODE_TYPE, opt=True)
    PUBLIC_KEY._cont = ASN1Dict([
        (u'id', _PUBLIC_KEY_id),
        (u'KeyValue', _PUBLIC_KEY_KeyValue),
        (u'Params', _PUBLIC_KEY_Params),
        (u'paramPresence', _PUBLIC_KEY_paramPresence),
        (u'keyUsage', _PUBLIC_KEY_keyUsage),
        (u'PrivateKey', _PUBLIC_KEY_PrivateKey),
        ])
    
    #-----< KEY-TRANSPORT >-----#
    KEY_TRANSPORT = CLASS(name=u'KEY-TRANSPORT', mode=MODE_TYPE)
    _KEY_TRANSPORT_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _KEY_TRANSPORT_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _KEY_TRANSPORT_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _KEY_TRANSPORT_PublicKeySet = CLASS(name=u'PublicKeySet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')), opt=True)
    _KEY_TRANSPORT_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    KEY_TRANSPORT._cont = ASN1Dict([
        (u'id', _KEY_TRANSPORT_id),
        (u'Params', _KEY_TRANSPORT_Params),
        (u'paramPresence', _KEY_TRANSPORT_paramPresence),
        (u'PublicKeySet', _KEY_TRANSPORT_PublicKeySet),
        (u'smimeCaps', _KEY_TRANSPORT_smimeCaps),
        ])
    
    #-----< KEY-AGREE >-----#
    KEY_AGREE = CLASS(name=u'KEY-AGREE', mode=MODE_TYPE)
    _KEY_AGREE_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _KEY_AGREE_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _KEY_AGREE_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _KEY_AGREE_PublicKeySet = CLASS(name=u'PublicKeySet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')), opt=True)
    _KEY_AGREE_Ukm = OPEN(name=u'Ukm', mode=MODE_TYPE, opt=True)
    _KEY_AGREE_ukmPresence = ENUM(name=u'ukmPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _KEY_AGREE_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    KEY_AGREE._cont = ASN1Dict([
        (u'id', _KEY_AGREE_id),
        (u'Params', _KEY_AGREE_Params),
        (u'paramPresence', _KEY_AGREE_paramPresence),
        (u'PublicKeySet', _KEY_AGREE_PublicKeySet),
        (u'Ukm', _KEY_AGREE_Ukm),
        (u'ukmPresence', _KEY_AGREE_ukmPresence),
        (u'smimeCaps', _KEY_AGREE_smimeCaps),
        ])
    
    #-----< KEY-WRAP >-----#
    KEY_WRAP = CLASS(name=u'KEY-WRAP', mode=MODE_TYPE)
    _KEY_WRAP_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _KEY_WRAP_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _KEY_WRAP_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _KEY_WRAP_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    KEY_WRAP._cont = ASN1Dict([
        (u'id', _KEY_WRAP_id),
        (u'Params', _KEY_WRAP_Params),
        (u'paramPresence', _KEY_WRAP_paramPresence),
        (u'smimeCaps', _KEY_WRAP_smimeCaps),
        ])
    
    #-----< KEY-DERIVATION >-----#
    KEY_DERIVATION = CLASS(name=u'KEY-DERIVATION', mode=MODE_TYPE)
    _KEY_DERIVATION_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _KEY_DERIVATION_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _KEY_DERIVATION_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _KEY_DERIVATION_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    KEY_DERIVATION._cont = ASN1Dict([
        (u'id', _KEY_DERIVATION_id),
        (u'Params', _KEY_DERIVATION_Params),
        (u'paramPresence', _KEY_DERIVATION_paramPresence),
        (u'smimeCaps', _KEY_DERIVATION_smimeCaps),
        ])
    
    #-----< MAC-ALGORITHM >-----#
    MAC_ALGORITHM = CLASS(name=u'MAC-ALGORITHM', mode=MODE_TYPE)
    _MAC_ALGORITHM_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _MAC_ALGORITHM_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _MAC_ALGORITHM_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _MAC_ALGORITHM_keyed = BOOL(name=u'keyed', mode=MODE_VALUE)
    _MAC_ALGORITHM_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    MAC_ALGORITHM._cont = ASN1Dict([
        (u'id', _MAC_ALGORITHM_id),
        (u'Params', _MAC_ALGORITHM_Params),
        (u'paramPresence', _MAC_ALGORITHM_paramPresence),
        (u'keyed', _MAC_ALGORITHM_keyed),
        (u'smimeCaps', _MAC_ALGORITHM_smimeCaps),
        ])
    
    #-----< CONTENT-ENCRYPTION >-----#
    CONTENT_ENCRYPTION = CLASS(name=u'CONTENT-ENCRYPTION', mode=MODE_TYPE)
    _CONTENT_ENCRYPTION_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _CONTENT_ENCRYPTION_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _CONTENT_ENCRYPTION_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _CONTENT_ENCRYPTION_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    CONTENT_ENCRYPTION._cont = ASN1Dict([
        (u'id', _CONTENT_ENCRYPTION_id),
        (u'Params', _CONTENT_ENCRYPTION_Params),
        (u'paramPresence', _CONTENT_ENCRYPTION_paramPresence),
        (u'smimeCaps', _CONTENT_ENCRYPTION_smimeCaps),
        ])
    
    #-----< ALGORITHM >-----#
    ALGORITHM = CLASS(name=u'ALGORITHM', mode=MODE_TYPE)
    _ALGORITHM_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _ALGORITHM_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _ALGORITHM_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _ALGORITHM_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    ALGORITHM._cont = ASN1Dict([
        (u'id', _ALGORITHM_id),
        (u'Params', _ALGORITHM_Params),
        (u'paramPresence', _ALGORITHM_paramPresence),
        (u'smimeCaps', _ALGORITHM_smimeCaps),
        ])
    
    #-----< AlgorithmIdentifier >-----#
    AlgorithmIdentifier = SEQ(name=u'AlgorithmIdentifier', mode=MODE_TYPE, param=True)
    
    #-----< SMIME-CAPS >-----#
    SMIME_CAPS = CLASS(name=u'SMIME-CAPS', mode=MODE_TYPE)
    _SMIME_CAPS_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _SMIME_CAPS_Type = OPEN(name=u'Type', mode=MODE_TYPE, opt=True)
    SMIME_CAPS._cont = ASN1Dict([
        (u'id', _SMIME_CAPS_id),
        (u'Type', _SMIME_CAPS_Type),
        ])
    
    #-----< SMIMECapability >-----#
    SMIMECapability = SEQ(name=u'SMIMECapability', mode=MODE_TYPE, param=True)
    
    #-----< SMIMECapabilities >-----#
    SMIMECapabilities = SEQ_OF(name=u'SMIMECapabilities', mode=MODE_TYPE, param=True)
    
    _all_ = [
        ParamOptions,
        _DIGEST_ALGORITHM_id,
        _DIGEST_ALGORITHM_Params,
        _DIGEST_ALGORITHM_paramPresence,
        DIGEST_ALGORITHM,
        _SIGNATURE_ALGORITHM_id,
        _SIGNATURE_ALGORITHM_Value,
        _SIGNATURE_ALGORITHM_Params,
        _SIGNATURE_ALGORITHM_paramPresence,
        _SIGNATURE_ALGORITHM_HashSet,
        _SIGNATURE_ALGORITHM_PublicKeySet,
        _SIGNATURE_ALGORITHM_smimeCaps,
        SIGNATURE_ALGORITHM,
        _PUBLIC_KEY_id,
        _PUBLIC_KEY_KeyValue,
        _PUBLIC_KEY_Params,
        _PUBLIC_KEY_paramPresence,
        _PUBLIC_KEY_keyUsage,
        _PUBLIC_KEY_PrivateKey,
        PUBLIC_KEY,
        _KEY_TRANSPORT_id,
        _KEY_TRANSPORT_Params,
        _KEY_TRANSPORT_paramPresence,
        _KEY_TRANSPORT_PublicKeySet,
        _KEY_TRANSPORT_smimeCaps,
        KEY_TRANSPORT,
        _KEY_AGREE_id,
        _KEY_AGREE_Params,
        _KEY_AGREE_paramPresence,
        _KEY_AGREE_PublicKeySet,
        _KEY_AGREE_Ukm,
        _KEY_AGREE_ukmPresence,
        _KEY_AGREE_smimeCaps,
        KEY_AGREE,
        _KEY_WRAP_id,
        _KEY_WRAP_Params,
        _KEY_WRAP_paramPresence,
        _KEY_WRAP_smimeCaps,
        KEY_WRAP,
        _KEY_DERIVATION_id,
        _KEY_DERIVATION_Params,
        _KEY_DERIVATION_paramPresence,
        _KEY_DERIVATION_smimeCaps,
        KEY_DERIVATION,
        _MAC_ALGORITHM_id,
        _MAC_ALGORITHM_Params,
        _MAC_ALGORITHM_paramPresence,
        _MAC_ALGORITHM_keyed,
        _MAC_ALGORITHM_smimeCaps,
        MAC_ALGORITHM,
        _CONTENT_ENCRYPTION_id,
        _CONTENT_ENCRYPTION_Params,
        _CONTENT_ENCRYPTION_paramPresence,
        _CONTENT_ENCRYPTION_smimeCaps,
        CONTENT_ENCRYPTION,
        _ALGORITHM_id,
        _ALGORITHM_Params,
        _ALGORITHM_paramPresence,
        _ALGORITHM_smimeCaps,
        ALGORITHM,
        _SMIME_CAPS_id,
        _SMIME_CAPS_Type,
        SMIME_CAPS,
    ]

class AsymmetricKeyPackageModuleV1:

    _name_  = u'AsymmetricKeyPackageModuleV1'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 50]
    
    _obj_ = [
        u'ContentSet',
        u'ct-asymmetric-key-package',
        u'id-ct-KP-aKeyPackage',
        u'AsymmetricKeyPackage',
        u'OneAsymmetricKey',
        u'PrivateKeyInfo',
        u'Version',
        u'PrivateKeyAlgorithmIdentifier',
        u'PrivateKey',
        u'PublicKey',
        u'Attributes',
        u'OneAsymmetricKeyAttributes',
        u'EncryptedPrivateKeyInfo',
        u'EncryptionAlgorithmIdentifier',
        u'EncryptedData',
        u'PrivateKeyAlgorithms',
        u'KeyEncryptionAlgorithms',
        ]
    _type_ = [
        u'AsymmetricKeyPackage',
        u'OneAsymmetricKey',
        u'PrivateKeyInfo',
        u'Version',
        u'PrivateKeyAlgorithmIdentifier',
        u'PrivateKey',
        u'PublicKey',
        u'Attributes',
        u'EncryptedPrivateKeyInfo',
        u'EncryptionAlgorithmIdentifier',
        u'EncryptedData',
        ]
    _set_ = [
        u'ContentSet',
        u'OneAsymmetricKeyAttributes',
        u'PrivateKeyAlgorithms',
        u'KeyEncryptionAlgorithms',
        ]
    _val_ = [
        u'ct-asymmetric-key-package',
        u'id-ct-KP-aKeyPackage',
        ]
    _class_ = [
        u'ContentSet',
        u'ct-asymmetric-key-package',
        u'OneAsymmetricKeyAttributes',
        u'PrivateKeyAlgorithms',
        u'KeyEncryptionAlgorithms',
        ]
    _param_ = [
        ]
    
    #-----< ContentSet >-----#
    ContentSet = CLASS(name=u'ContentSet', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ContentSet_val_Type_0 = SEQ_OF(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'AsymmetricKeyPackage')))
    ContentSet._val = ASN1Set(rv=[dict([('Type', _ContentSet_val_Type_0), ('id', (2, 16, 840, 1, 101, 2, 1, 2, 78, 5))])], rr=[], ev=[], er=[])
    
    #-----< ct-asymmetric-key-package >-----#
    ct_asymmetric_key_package = CLASS(name=u'ct-asymmetric-key-package', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_asymmetric_key_package_val_Type = SEQ_OF(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'AsymmetricKeyPackage')))
    ct_asymmetric_key_package._val = dict([('Type', _ct_asymmetric_key_package_val_Type), ('id', (2, 16, 840, 1, 101, 2, 1, 2, 78, 5))])
    
    #-----< id-ct-KP-aKeyPackage >-----#
    id_ct_KP_aKeyPackage = OID(name=u'id-ct-KP-aKeyPackage', mode=MODE_VALUE)
    id_ct_KP_aKeyPackage._val = (2, 16, 840, 1, 101, 2, 1, 2, 78, 5)
    
    #-----< AsymmetricKeyPackage >-----#
    AsymmetricKeyPackage = SEQ_OF(name=u'AsymmetricKeyPackage', mode=MODE_TYPE)
    _AsymmetricKeyPackage__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'OneAsymmetricKey')))
    AsymmetricKeyPackage._cont = _AsymmetricKeyPackage__item_
    AsymmetricKeyPackage._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< OneAsymmetricKey >-----#
    OneAsymmetricKey = SEQ(name=u'OneAsymmetricKey', mode=MODE_TYPE)
    _OneAsymmetricKey_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'Version')))
    _OneAsymmetricKey_privateKeyAlgorithm = SEQ(name=u'privateKeyAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'PrivateKeyAlgorithmIdentifier')))
    _OneAsymmetricKey_privateKey = OCT_STR(name=u'privateKey', mode=MODE_TYPE, typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'PrivateKey')))
    _OneAsymmetricKey_attributes = SET_OF(name=u'attributes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'Attributes')), opt=True)
    _OneAsymmetricKey_publicKey = BIT_STR(name=u'publicKey', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'PublicKey')), opt=True, group=0)
    OneAsymmetricKey._cont = ASN1Dict([
        (u'version', _OneAsymmetricKey_version),
        (u'privateKeyAlgorithm', _OneAsymmetricKey_privateKeyAlgorithm),
        (u'privateKey', _OneAsymmetricKey_privateKey),
        (u'attributes', _OneAsymmetricKey_attributes),
        (u'publicKey', _OneAsymmetricKey_publicKey),
        ])
    OneAsymmetricKey._ext = [u'publicKey']
    
    #-----< PrivateKeyInfo >-----#
    PrivateKeyInfo = SEQ(name=u'PrivateKeyInfo', mode=MODE_TYPE, typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'OneAsymmetricKey')))
    
    #-----< Version >-----#
    Version = INT(name=u'Version', mode=MODE_TYPE)
    Version._cont = ASN1Dict([(u'v1', 0), (u'v2', 1)])
    Version._const_val = ASN1Set(rv=[0], rr=[], ev=[1], er=[])
    
    #-----< PrivateKeyAlgorithmIdentifier >-----#
    PrivateKeyAlgorithmIdentifier = SEQ(name=u'PrivateKeyAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _PrivateKeyAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'id']))
    __PrivateKeyAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_PUBLIC-KEY', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    __PrivateKeyAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PrivateKeyAlgorithmIdentifier_algorithm._const_tab = __PrivateKeyAlgorithmIdentifier_algorithm_tab
    _PrivateKeyAlgorithmIdentifier_algorithm._const_tab_at = None
    _PrivateKeyAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _PrivateKeyAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'Params']), opt=True)
    __PrivateKeyAlgorithmIdentifier_parameters_tab = CLASS(name='_tab_PUBLIC-KEY', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    __PrivateKeyAlgorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PrivateKeyAlgorithmIdentifier_parameters._const_tab = __PrivateKeyAlgorithmIdentifier_parameters_tab
    _PrivateKeyAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _PrivateKeyAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    PrivateKeyAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _PrivateKeyAlgorithmIdentifier_algorithm),
        (u'parameters', _PrivateKeyAlgorithmIdentifier_parameters),
        ])
    PrivateKeyAlgorithmIdentifier._ext = None
    
    #-----< PrivateKey >-----#
    PrivateKey = OCT_STR(name=u'PrivateKey', mode=MODE_TYPE)
    
    #-----< PublicKey >-----#
    PublicKey = BIT_STR(name=u'PublicKey', mode=MODE_TYPE)
    
    #-----< Attributes >-----#
    Attributes = SET_OF(name=u'Attributes', mode=MODE_TYPE)
    _Attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    __Attributes__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___Attributes__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ___Attributes__item__attrType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __Attributes__item__attrType._const_tab = ___Attributes__item__attrType_tab
    __Attributes__item__attrType._const_tab_at = None
    __Attributes__item__attrType._const_tab_id = u'id'
    __Attributes__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ___Attributes__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ____Attributes__item__attrValues__item__tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____Attributes__item__attrValues__item__tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Attributes__item__attrValues__item_._const_tab = ____Attributes__item__attrValues__item__tab
    ___Attributes__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ___Attributes__item__attrValues__item_._const_tab_id = u'Type'
    __Attributes__item__attrValues._cont = ___Attributes__item__attrValues__item_
    _Attributes__item_._cont = ASN1Dict([
        (u'attrType', __Attributes__item__attrType),
        (u'attrValues', __Attributes__item__attrValues),
        ])
    _Attributes__item_._ext = None
    Attributes._cont = _Attributes__item_
    
    #-----< OneAsymmetricKeyAttributes >-----#
    OneAsymmetricKeyAttributes = CLASS(name=u'OneAsymmetricKeyAttributes', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    OneAsymmetricKeyAttributes._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< EncryptedPrivateKeyInfo >-----#
    EncryptedPrivateKeyInfo = SEQ(name=u'EncryptedPrivateKeyInfo', mode=MODE_TYPE)
    _EncryptedPrivateKeyInfo_encryptionAlgorithm = SEQ(name=u'encryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'EncryptionAlgorithmIdentifier')))
    _EncryptedPrivateKeyInfo_encryptedData = OCT_STR(name=u'encryptedData', mode=MODE_TYPE, typeref=ASN1RefType(('AsymmetricKeyPackageModuleV1', 'EncryptedData')))
    EncryptedPrivateKeyInfo._cont = ASN1Dict([
        (u'encryptionAlgorithm', _EncryptedPrivateKeyInfo_encryptionAlgorithm),
        (u'encryptedData', _EncryptedPrivateKeyInfo_encryptedData),
        ])
    EncryptedPrivateKeyInfo._ext = None
    
    #-----< EncryptionAlgorithmIdentifier >-----#
    EncryptionAlgorithmIdentifier = SEQ(name=u'EncryptionAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _EncryptionAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION'), [u'id']))
    __EncryptionAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_CONTENT-ENCRYPTION', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    __EncryptionAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _EncryptionAlgorithmIdentifier_algorithm._const_tab = __EncryptionAlgorithmIdentifier_algorithm_tab
    _EncryptionAlgorithmIdentifier_algorithm._const_tab_at = None
    _EncryptionAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _EncryptionAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION'), [u'Params']), opt=True)
    __EncryptionAlgorithmIdentifier_parameters_tab = CLASS(name='_tab_CONTENT-ENCRYPTION', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    __EncryptionAlgorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _EncryptionAlgorithmIdentifier_parameters._const_tab = __EncryptionAlgorithmIdentifier_parameters_tab
    _EncryptionAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _EncryptionAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    EncryptionAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _EncryptionAlgorithmIdentifier_algorithm),
        (u'parameters', _EncryptionAlgorithmIdentifier_parameters),
        ])
    EncryptionAlgorithmIdentifier._ext = None
    
    #-----< EncryptedData >-----#
    EncryptedData = OCT_STR(name=u'EncryptedData', mode=MODE_TYPE)
    
    #-----< PrivateKeyAlgorithms >-----#
    PrivateKeyAlgorithms = CLASS(name=u'PrivateKeyAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    PrivateKeyAlgorithms._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< KeyEncryptionAlgorithms >-----#
    KeyEncryptionAlgorithms = CLASS(name=u'KeyEncryptionAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    KeyEncryptionAlgorithms._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    _all_ = [
        ContentSet,
        _ContentSet_val_Type_0,
        ct_asymmetric_key_package,
        _ct_asymmetric_key_package_val_Type,
        id_ct_KP_aKeyPackage,
        _AsymmetricKeyPackage__item_,
        AsymmetricKeyPackage,
        _OneAsymmetricKey_version,
        _OneAsymmetricKey_privateKeyAlgorithm,
        _OneAsymmetricKey_privateKey,
        _OneAsymmetricKey_attributes,
        _OneAsymmetricKey_publicKey,
        OneAsymmetricKey,
        PrivateKeyInfo,
        Version,
        __PrivateKeyAlgorithmIdentifier_algorithm_tab,
        _PrivateKeyAlgorithmIdentifier_algorithm,
        __PrivateKeyAlgorithmIdentifier_parameters_tab,
        _PrivateKeyAlgorithmIdentifier_parameters,
        PrivateKeyAlgorithmIdentifier,
        PrivateKey,
        PublicKey,
        ___Attributes__item__attrType_tab,
        __Attributes__item__attrType,
        ____Attributes__item__attrValues__item__tab,
        ___Attributes__item__attrValues__item_,
        __Attributes__item__attrValues,
        _Attributes__item_,
        Attributes,
        OneAsymmetricKeyAttributes,
        _EncryptedPrivateKeyInfo_encryptionAlgorithm,
        _EncryptedPrivateKeyInfo_encryptedData,
        EncryptedPrivateKeyInfo,
        __EncryptionAlgorithmIdentifier_algorithm_tab,
        _EncryptionAlgorithmIdentifier_algorithm,
        __EncryptionAlgorithmIdentifier_parameters_tab,
        _EncryptionAlgorithmIdentifier_parameters,
        EncryptionAlgorithmIdentifier,
        EncryptedData,
        PrivateKeyAlgorithms,
        KeyEncryptionAlgorithms,
    ]

class AttributeCertificateVersion1_2009:

    _name_  = u'AttributeCertificateVersion1-2009'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 49]
    
    _obj_ = [
        u'AttributeCertificateV1',
        u'AttributeCertificateInfoV1',
        u'AttCertVersionV1',
        u'AttrList',
        u'AttributeCertExtensionsV1',
        ]
    _type_ = [
        u'AttributeCertificateV1',
        u'AttributeCertificateInfoV1',
        u'AttCertVersionV1',
        ]
    _set_ = [
        u'AttrList',
        u'AttributeCertExtensionsV1',
        ]
    _val_ = [
        ]
    _class_ = [
        u'AttrList',
        u'AttributeCertExtensionsV1',
        ]
    _param_ = [
        ]
    
    #-----< AttributeCertificateV1 >-----#
    AttributeCertificateV1 = SEQ(name=u'AttributeCertificateV1', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'SIGNED')))
    _AttributeCertificateV1_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateVersion1-2009', 'AttributeCertificateInfoV1')))
    _AttributeCertificateV1_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE)
    __AttributeCertificateV1_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    __SIGNATURE_ALGORITHM_HashSet_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_3), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_4), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_5), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_6), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_7), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_8), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_9), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_10), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __AttributeCertificateV1_algorithmIdentifier_algorithm._const_tab = ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab
    __AttributeCertificateV1_algorithmIdentifier_algorithm._const_tab_at = None
    __AttributeCertificateV1_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __AttributeCertificateV1_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __AttributeCertificateV1_algorithmIdentifier_parameters._const_tab = ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab
    __AttributeCertificateV1_algorithmIdentifier_parameters._const_tab_at = ('..', '..', u'algorithmIdentifier', u'algorithm')
    __AttributeCertificateV1_algorithmIdentifier_parameters._const_tab_id = u'Params'
    _AttributeCertificateV1_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificateV1_algorithmIdentifier_algorithm),
        (u'parameters', __AttributeCertificateV1_algorithmIdentifier_parameters),
        ])
    _AttributeCertificateV1_algorithmIdentifier._ext = None
    _AttributeCertificateV1_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    __AttributeCertificateV1_signature_contain = OPEN(name='_cont_signature', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Value']))
    __AttributeCertificateV1_signature_contain._const_tab = ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab
    __AttributeCertificateV1_signature_contain._const_tab_at = ('..', u'algorithmIdentifier', u'algorithm')
    __AttributeCertificateV1_signature_contain._const_tab_id = u'Value'
    _AttributeCertificateV1_signature._const_cont = __AttributeCertificateV1_signature_contain
    AttributeCertificateV1._cont = ASN1Dict([
        (u'toBeSigned', _AttributeCertificateV1_toBeSigned),
        (u'algorithmIdentifier', _AttributeCertificateV1_algorithmIdentifier),
        (u'signature', _AttributeCertificateV1_signature),
        ])
    AttributeCertificateV1._ext = None
    
    #-----< AttributeCertificateInfoV1 >-----#
    AttributeCertificateInfoV1 = SEQ(name=u'AttributeCertificateInfoV1', mode=MODE_TYPE)
    _AttributeCertificateInfoV1_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateVersion1-2009', 'AttCertVersionV1')), default=0)
    _AttributeCertificateInfoV1_subject = CHOICE(name=u'subject', mode=MODE_TYPE)
    __AttributeCertificateInfoV1_subject_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IssuerSerial')))
    __AttributeCertificateInfoV1_subject_subjectName = SEQ_OF(name=u'subjectName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _AttributeCertificateInfoV1_subject._cont = ASN1Dict([
        (u'baseCertificateID', __AttributeCertificateInfoV1_subject_baseCertificateID),
        (u'subjectName', __AttributeCertificateInfoV1_subject_subjectName),
        ])
    _AttributeCertificateInfoV1_subject._ext = None
    _AttributeCertificateInfoV1_issuer = SEQ_OF(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _AttributeCertificateInfoV1_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __AttributeCertificateInfoV1_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___AttributeCertificateInfoV1_signature_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ___AttributeCertificateInfoV1_signature_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __AttributeCertificateInfoV1_signature_algorithm._const_tab = ___AttributeCertificateInfoV1_signature_algorithm_tab
    __AttributeCertificateInfoV1_signature_algorithm._const_tab_at = None
    __AttributeCertificateInfoV1_signature_algorithm._const_tab_id = u'id'
    __AttributeCertificateInfoV1_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    ___AttributeCertificateInfoV1_signature_parameters_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ___AttributeCertificateInfoV1_signature_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __AttributeCertificateInfoV1_signature_parameters._const_tab = ___AttributeCertificateInfoV1_signature_parameters_tab
    __AttributeCertificateInfoV1_signature_parameters._const_tab_at = ('..', u'algorithm')
    __AttributeCertificateInfoV1_signature_parameters._const_tab_id = u'Params'
    _AttributeCertificateInfoV1_signature._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificateInfoV1_signature_algorithm),
        (u'parameters', __AttributeCertificateInfoV1_signature_parameters),
        ])
    _AttributeCertificateInfoV1_signature._ext = None
    _AttributeCertificateInfoV1_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    _AttributeCertificateInfoV1_attCertValidityPeriod = SEQ(name=u'attCertValidityPeriod', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttCertValidityPeriod')))
    _AttributeCertificateInfoV1_attributes = SEQ_OF(name=u'attributes', mode=MODE_TYPE)
    __AttributeCertificateInfoV1_attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'AttributeSet')))
    ___AttributeCertificateInfoV1_attributes__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____AttributeCertificateInfoV1_attributes__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____AttributeCertificateInfoV1_attributes__item__type_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AttributeCertificateInfoV1_attributes__item__type._const_tab = ____AttributeCertificateInfoV1_attributes__item__type_tab
    ___AttributeCertificateInfoV1_attributes__item__type._const_tab_at = None
    ___AttributeCertificateInfoV1_attributes__item__type._const_tab_id = u'id'
    ___AttributeCertificateInfoV1_attributes__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AttributeCertificateInfoV1_attributes__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    _____AttributeCertificateInfoV1_attributes__item__values__item__tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____AttributeCertificateInfoV1_attributes__item__values__item__tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____AttributeCertificateInfoV1_attributes__item__values__item_._const_tab = _____AttributeCertificateInfoV1_attributes__item__values__item__tab
    ____AttributeCertificateInfoV1_attributes__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AttributeCertificateInfoV1_attributes__item__values__item_._const_tab_id = u'Type'
    ___AttributeCertificateInfoV1_attributes__item__values._cont = ____AttributeCertificateInfoV1_attributes__item__values__item_
    ___AttributeCertificateInfoV1_attributes__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AttributeCertificateInfoV1_attributes__item_._cont = ASN1Dict([
        (u'type', ___AttributeCertificateInfoV1_attributes__item__type),
        (u'values', ___AttributeCertificateInfoV1_attributes__item__values),
        ])
    __AttributeCertificateInfoV1_attributes__item_._ext = None
    _AttributeCertificateInfoV1_attributes._cont = __AttributeCertificateInfoV1_attributes__item_
    _AttributeCertificateInfoV1_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'UniqueIdentifier')), opt=True)
    _AttributeCertificateInfoV1_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True)
    __AttributeCertificateInfoV1_extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___AttributeCertificateInfoV1_extensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____AttributeCertificateInfoV1_extensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    ____AttributeCertificateInfoV1_extensions__item__extnID_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AttributeCertificateInfoV1_extensions__item__extnID._const_tab = ____AttributeCertificateInfoV1_extensions__item__extnID_tab
    ___AttributeCertificateInfoV1_extensions__item__extnID._const_tab_at = None
    ___AttributeCertificateInfoV1_extensions__item__extnID._const_tab_id = u'id'
    ___AttributeCertificateInfoV1_extensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___AttributeCertificateInfoV1_extensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____AttributeCertificateInfoV1_extensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    _____AttributeCertificateInfoV1_extensions__item__extnValue_contain_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____AttributeCertificateInfoV1_extensions__item__extnValue_contain_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____AttributeCertificateInfoV1_extensions__item__extnValue_contain._const_tab = _____AttributeCertificateInfoV1_extensions__item__extnValue_contain_tab
    ____AttributeCertificateInfoV1_extensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____AttributeCertificateInfoV1_extensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___AttributeCertificateInfoV1_extensions__item__extnValue._const_cont = ____AttributeCertificateInfoV1_extensions__item__extnValue_contain
    __AttributeCertificateInfoV1_extensions__item_._cont = ASN1Dict([
        (u'extnID', ___AttributeCertificateInfoV1_extensions__item__extnID),
        (u'critical', ___AttributeCertificateInfoV1_extensions__item__critical),
        (u'extnValue', ___AttributeCertificateInfoV1_extensions__item__extnValue),
        ])
    __AttributeCertificateInfoV1_extensions__item_._ext = None
    _AttributeCertificateInfoV1_extensions._cont = __AttributeCertificateInfoV1_extensions__item_
    _AttributeCertificateInfoV1_extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    AttributeCertificateInfoV1._cont = ASN1Dict([
        (u'version', _AttributeCertificateInfoV1_version),
        (u'subject', _AttributeCertificateInfoV1_subject),
        (u'issuer', _AttributeCertificateInfoV1_issuer),
        (u'signature', _AttributeCertificateInfoV1_signature),
        (u'serialNumber', _AttributeCertificateInfoV1_serialNumber),
        (u'attCertValidityPeriod', _AttributeCertificateInfoV1_attCertValidityPeriod),
        (u'attributes', _AttributeCertificateInfoV1_attributes),
        (u'issuerUniqueID', _AttributeCertificateInfoV1_issuerUniqueID),
        (u'extensions', _AttributeCertificateInfoV1_extensions),
        ])
    AttributeCertificateInfoV1._ext = None
    
    #-----< AttCertVersionV1 >-----#
    AttCertVersionV1 = INT(name=u'AttCertVersionV1', mode=MODE_TYPE)
    AttCertVersionV1._cont = ASN1Dict([(u'v1', 0)])
    
    #-----< AttrList >-----#
    AttrList = CLASS(name=u'AttrList', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    AttrList._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< AttributeCertExtensionsV1 >-----#
    AttributeCertExtensionsV1 = CLASS(name=u'AttributeCertExtensionsV1', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    AttributeCertExtensionsV1._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    _all_ = [
        _AttributeCertificateV1_toBeSigned,
        ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_1,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_2,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_3,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_3,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_4,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_5,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_5,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_6,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_6,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_7,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_7,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_8,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_8,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_9,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_9,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_10,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_10,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_11,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_1,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_2,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_3,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1,
        __AttributeCertificateV1_algorithmIdentifier_algorithm,
        __AttributeCertificateV1_algorithmIdentifier_parameters,
        _AttributeCertificateV1_algorithmIdentifier,
        __AttributeCertificateV1_signature_contain,
        _AttributeCertificateV1_signature,
        AttributeCertificateV1,
        _AttributeCertificateInfoV1_version,
        __AttributeCertificateInfoV1_subject_baseCertificateID,
        __AttributeCertificateInfoV1_subject_subjectName,
        _AttributeCertificateInfoV1_subject,
        _AttributeCertificateInfoV1_issuer,
        ___AttributeCertificateInfoV1_signature_algorithm_tab,
        __AttributeCertificateInfoV1_signature_algorithm,
        ___AttributeCertificateInfoV1_signature_parameters_tab,
        __AttributeCertificateInfoV1_signature_parameters,
        _AttributeCertificateInfoV1_signature,
        _AttributeCertificateInfoV1_serialNumber,
        _AttributeCertificateInfoV1_attCertValidityPeriod,
        ____AttributeCertificateInfoV1_attributes__item__type_tab,
        ___AttributeCertificateInfoV1_attributes__item__type,
        _____AttributeCertificateInfoV1_attributes__item__values__item__tab,
        ____AttributeCertificateInfoV1_attributes__item__values__item_,
        ___AttributeCertificateInfoV1_attributes__item__values,
        __AttributeCertificateInfoV1_attributes__item_,
        _AttributeCertificateInfoV1_attributes,
        _AttributeCertificateInfoV1_issuerUniqueID,
        ____AttributeCertificateInfoV1_extensions__item__extnID_tab,
        ___AttributeCertificateInfoV1_extensions__item__extnID,
        ___AttributeCertificateInfoV1_extensions__item__critical,
        _____AttributeCertificateInfoV1_extensions__item__extnValue_contain_tab,
        ____AttributeCertificateInfoV1_extensions__item__extnValue_contain,
        ___AttributeCertificateInfoV1_extensions__item__extnValue,
        __AttributeCertificateInfoV1_extensions__item_,
        _AttributeCertificateInfoV1_extensions,
        AttributeCertificateInfoV1,
        AttCertVersionV1,
        AttrList,
        AttributeCertExtensionsV1,
    ]

class CryptographicMessageSyntax_2009:

    _name_  = u'CryptographicMessageSyntax-2009'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 41]
    
    _obj_ = [
        u'CONTENT-TYPE',
        u'ContentType',
        u'ContentInfo',
        u'ContentSet',
        u'SignedData',
        u'SignerInfos',
        u'EncapsulatedContentInfo',
        u'SignerInfo',
        u'SignedAttributes',
        u'SignerIdentifier',
        u'SignedAttributesSet',
        u'UnsignedAttributes',
        u'SignatureValue',
        u'EnvelopedData',
        u'OriginatorInfo',
        u'RecipientInfos',
        u'EncryptedContentInfo',
        u'UnprotectedAttributes',
        u'RecipientInfo',
        u'EncryptedKey',
        u'KeyTransRecipientInfo',
        u'KeyTransportAlgorithmSet',
        u'RecipientIdentifier',
        u'KeyAgreeRecipientInfo',
        u'KeyAgreementAlgorithmSet',
        u'OriginatorIdentifierOrKey',
        u'OriginatorPublicKey',
        u'OriginatorKeySet',
        u'RecipientEncryptedKeys',
        u'RecipientEncryptedKey',
        u'KeyAgreeRecipientIdentifier',
        u'RecipientKeyIdentifier',
        u'SubjectKeyIdentifier',
        u'KEKRecipientInfo',
        u'KEKIdentifier',
        u'PasswordRecipientInfo',
        u'OTHER-RECIPIENT',
        u'OtherRecipientInfo',
        u'SupportedOtherRecipInfo',
        u'DigestedData',
        u'Digest',
        u'EncryptedData',
        u'AuthenticatedData',
        u'AuthAttributes',
        u'AuthAttributeSet',
        u'MessageAuthenticationCode',
        u'UnauthAttributes',
        u'UnauthAttributeSet',
        u'DigestAlgorithmIdentifier',
        u'DigestAlgorithmSet',
        u'SignatureAlgorithmIdentifier',
        u'SignatureAlgorithmSet',
        u'KeyEncryptionAlgorithmIdentifier',
        u'KeyEncryptionAlgorithmSet',
        u'ContentEncryptionAlgorithmIdentifier',
        u'ContentEncryptionAlgorithmSet',
        u'MessageAuthenticationCodeAlgorithm',
        u'MessageAuthenticationCodeAlgorithmSet',
        u'KeyDerivationAlgorithmIdentifier',
        u'RevocationInfoChoices',
        u'RevocationInfoChoice',
        u'OTHER-REVOK-INFO',
        u'OtherRevocationInfoFormat',
        u'SupportedOtherRevokInfo',
        u'CertificateChoices',
        u'AttributeCertificateV2',
        u'OTHER-CERT-FMT',
        u'OtherCertificateFormat',
        u'SupportedCertFormats',
        u'CertificateSet',
        u'IssuerAndSerialNumber',
        u'CMSVersion',
        u'UserKeyingMaterial',
        u'KEY-ATTRIBUTE',
        u'OtherKeyAttribute',
        u'SupportedKeyAttributes',
        u'id-ct-contentInfo',
        u'ct-Data',
        u'id-data',
        u'ct-SignedData',
        u'id-signedData',
        u'ct-EnvelopedData',
        u'id-envelopedData',
        u'ct-DigestedData',
        u'id-digestedData',
        u'ct-EncryptedData',
        u'id-encryptedData',
        u'ct-AuthenticatedData',
        u'id-ct-authData',
        u'MessageDigest',
        u'SigningTime',
        u'Time',
        u'Countersignature',
        u'aa-contentType',
        u'id-contentType',
        u'aa-messageDigest',
        u'id-messageDigest',
        u'aa-signingTime',
        u'id-signingTime',
        u'aa-countersignature',
        u'id-countersignature',
        u'ExtendedCertificateOrCertificate',
        u'ExtendedCertificate',
        u'ExtendedCertificateInfo',
        u'Signature',
        u'Attribute',
        u'Attributes',
        ]
    _type_ = [
        u'CONTENT-TYPE',
        u'ContentType',
        u'ContentInfo',
        u'SignedData',
        u'SignerInfos',
        u'EncapsulatedContentInfo',
        u'SignerInfo',
        u'SignedAttributes',
        u'SignerIdentifier',
        u'SignatureValue',
        u'EnvelopedData',
        u'OriginatorInfo',
        u'RecipientInfos',
        u'EncryptedContentInfo',
        u'RecipientInfo',
        u'EncryptedKey',
        u'KeyTransRecipientInfo',
        u'RecipientIdentifier',
        u'KeyAgreeRecipientInfo',
        u'OriginatorIdentifierOrKey',
        u'OriginatorPublicKey',
        u'RecipientEncryptedKeys',
        u'RecipientEncryptedKey',
        u'KeyAgreeRecipientIdentifier',
        u'RecipientKeyIdentifier',
        u'SubjectKeyIdentifier',
        u'KEKRecipientInfo',
        u'KEKIdentifier',
        u'PasswordRecipientInfo',
        u'OTHER-RECIPIENT',
        u'OtherRecipientInfo',
        u'DigestedData',
        u'Digest',
        u'EncryptedData',
        u'AuthenticatedData',
        u'AuthAttributes',
        u'MessageAuthenticationCode',
        u'UnauthAttributes',
        u'DigestAlgorithmIdentifier',
        u'SignatureAlgorithmIdentifier',
        u'KeyEncryptionAlgorithmIdentifier',
        u'ContentEncryptionAlgorithmIdentifier',
        u'MessageAuthenticationCodeAlgorithm',
        u'KeyDerivationAlgorithmIdentifier',
        u'RevocationInfoChoices',
        u'RevocationInfoChoice',
        u'OTHER-REVOK-INFO',
        u'OtherRevocationInfoFormat',
        u'CertificateChoices',
        u'AttributeCertificateV2',
        u'OTHER-CERT-FMT',
        u'OtherCertificateFormat',
        u'CertificateSet',
        u'IssuerAndSerialNumber',
        u'CMSVersion',
        u'UserKeyingMaterial',
        u'KEY-ATTRIBUTE',
        u'OtherKeyAttribute',
        u'MessageDigest',
        u'SigningTime',
        u'Time',
        u'Countersignature',
        u'ExtendedCertificateOrCertificate',
        u'ExtendedCertificate',
        u'ExtendedCertificateInfo',
        u'Signature',
        u'Attribute',
        u'Attributes',
        ]
    _set_ = [
        u'ContentSet',
        u'SignedAttributesSet',
        u'UnsignedAttributes',
        u'UnprotectedAttributes',
        u'KeyTransportAlgorithmSet',
        u'KeyAgreementAlgorithmSet',
        u'OriginatorKeySet',
        u'SupportedOtherRecipInfo',
        u'AuthAttributeSet',
        u'UnauthAttributeSet',
        u'DigestAlgorithmSet',
        u'SignatureAlgorithmSet',
        u'KeyEncryptionAlgorithmSet',
        u'ContentEncryptionAlgorithmSet',
        u'MessageAuthenticationCodeAlgorithmSet',
        u'SupportedOtherRevokInfo',
        u'SupportedCertFormats',
        u'SupportedKeyAttributes',
        ]
    _val_ = [
        u'id-ct-contentInfo',
        u'ct-Data',
        u'id-data',
        u'ct-SignedData',
        u'id-signedData',
        u'ct-EnvelopedData',
        u'id-envelopedData',
        u'ct-DigestedData',
        u'id-digestedData',
        u'ct-EncryptedData',
        u'id-encryptedData',
        u'ct-AuthenticatedData',
        u'id-ct-authData',
        u'aa-contentType',
        u'id-contentType',
        u'aa-messageDigest',
        u'id-messageDigest',
        u'aa-signingTime',
        u'id-signingTime',
        u'aa-countersignature',
        u'id-countersignature',
        ]
    _class_ = [
        u'CONTENT-TYPE',
        u'ContentSet',
        u'SignedAttributesSet',
        u'UnsignedAttributes',
        u'UnprotectedAttributes',
        u'KeyTransportAlgorithmSet',
        u'KeyAgreementAlgorithmSet',
        u'OriginatorKeySet',
        u'OTHER-RECIPIENT',
        u'SupportedOtherRecipInfo',
        u'AuthAttributeSet',
        u'UnauthAttributeSet',
        u'DigestAlgorithmSet',
        u'SignatureAlgorithmSet',
        u'KeyEncryptionAlgorithmSet',
        u'ContentEncryptionAlgorithmSet',
        u'MessageAuthenticationCodeAlgorithmSet',
        u'OTHER-REVOK-INFO',
        u'SupportedOtherRevokInfo',
        u'OTHER-CERT-FMT',
        u'SupportedCertFormats',
        u'KEY-ATTRIBUTE',
        u'SupportedKeyAttributes',
        u'ct-Data',
        u'ct-SignedData',
        u'ct-EnvelopedData',
        u'ct-DigestedData',
        u'ct-EncryptedData',
        u'ct-AuthenticatedData',
        u'aa-contentType',
        u'aa-messageDigest',
        u'aa-signingTime',
        u'aa-countersignature',
        ]
    _param_ = [
        u'Attribute',
        u'Attributes',
        ]
    
    #-----< CONTENT-TYPE >-----#
    CONTENT_TYPE = CLASS(name=u'CONTENT-TYPE', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< ContentType >-----#
    ContentType = OID(name=u'ContentType', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'id']))
    
    #-----< ContentInfo >-----#
    ContentInfo = SEQ(name=u'ContentInfo', mode=MODE_TYPE)
    _ContentInfo_contentType = OID(name=u'contentType', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'id']))
    __ContentInfo_contentType_tab = CLASS(name='_tab_CONTENT-TYPE', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    ___ContentInfo_contentType_tab_val_Type_0 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___ContentInfo_contentType_tab_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedData')))
    ___ContentInfo_contentType_tab_val_Type_2 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedData')))
    ___ContentInfo_contentType_tab_val_Type_3 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EnvelopedData')))
    ___ContentInfo_contentType_tab_val_Type_4 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthenticatedData')))
    ___ContentInfo_contentType_tab_val_Type_5 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestedData')))
    __ContentInfo_contentType_tab._val = ASN1Set(rv=[dict([('Type', ___ContentInfo_contentType_tab_val_Type_0), ('id', (1, 2, 840, 113549, 1, 7, 1))]), dict([('Type', ___ContentInfo_contentType_tab_val_Type_1), ('id', (1, 2, 840, 113549, 1, 7, 2))]), dict([('Type', ___ContentInfo_contentType_tab_val_Type_2), ('id', (1, 2, 840, 113549, 1, 7, 6))]), dict([('Type', ___ContentInfo_contentType_tab_val_Type_3), ('id', (1, 2, 840, 113549, 1, 7, 3))]), dict([('Type', ___ContentInfo_contentType_tab_val_Type_4), ('id', (1, 2, 840, 113549, 1, 9, 16, 1, 2))]), dict([('Type', ___ContentInfo_contentType_tab_val_Type_5), ('id', (1, 2, 840, 113549, 1, 7, 5))])], rr=[], ev=None, er=[])
    _ContentInfo_contentType._const_tab = __ContentInfo_contentType_tab
    _ContentInfo_contentType._const_tab_at = None
    _ContentInfo_contentType._const_tab_id = u'id'
    _ContentInfo_content = OPEN(name=u'content', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'Type']))
    _ContentInfo_content._const_tab = __ContentInfo_contentType_tab
    _ContentInfo_content._const_tab_at = ('..', u'contentType')
    _ContentInfo_content._const_tab_id = u'Type'
    ContentInfo._cont = ASN1Dict([
        (u'contentType', _ContentInfo_contentType),
        (u'content', _ContentInfo_content),
        ])
    ContentInfo._ext = None
    
    #-----< ContentSet >-----#
    ContentSet = CLASS(name=u'ContentSet', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ContentSet_val_Type_0 = OCT_STR(name='Type', mode=MODE_TYPE)
    _ContentSet_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedData')))
    _ContentSet_val_Type_2 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedData')))
    _ContentSet_val_Type_3 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EnvelopedData')))
    _ContentSet_val_Type_4 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthenticatedData')))
    _ContentSet_val_Type_5 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestedData')))
    ContentSet._val = ASN1Set(rv=[dict([('Type', _ContentSet_val_Type_0), ('id', (1, 2, 840, 113549, 1, 7, 1))]), dict([('Type', _ContentSet_val_Type_1), ('id', (1, 2, 840, 113549, 1, 7, 2))]), dict([('Type', _ContentSet_val_Type_2), ('id', (1, 2, 840, 113549, 1, 7, 6))]), dict([('Type', _ContentSet_val_Type_3), ('id', (1, 2, 840, 113549, 1, 7, 3))]), dict([('Type', _ContentSet_val_Type_4), ('id', (1, 2, 840, 113549, 1, 9, 16, 1, 2))]), dict([('Type', _ContentSet_val_Type_5), ('id', (1, 2, 840, 113549, 1, 7, 5))])], rr=[], ev=[], er=[])
    
    #-----< SignedData >-----#
    SignedData = SEQ(name=u'SignedData', mode=MODE_TYPE)
    _SignedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _SignedData_digestAlgorithms = SET_OF(name=u'digestAlgorithms', mode=MODE_TYPE)
    __SignedData_digestAlgorithms__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestAlgorithmIdentifier')))
    _SignedData_digestAlgorithms._cont = __SignedData_digestAlgorithms__item_
    _SignedData_encapContentInfo = SEQ(name=u'encapContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncapsulatedContentInfo')))
    _SignedData_certificates = SET_OF(name=u'certificates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CertificateSet')), opt=True)
    _SignedData_crls = SET_OF(name=u'crls', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RevocationInfoChoices')), opt=True)
    _SignedData_signerInfos = SET_OF(name=u'signerInfos', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignerInfos')))
    SignedData._cont = ASN1Dict([
        (u'version', _SignedData_version),
        (u'digestAlgorithms', _SignedData_digestAlgorithms),
        (u'encapContentInfo', _SignedData_encapContentInfo),
        (u'certificates', _SignedData_certificates),
        (u'crls', _SignedData_crls),
        (u'signerInfos', _SignedData_signerInfos),
        ])
    SignedData._ext = None
    
    #-----< SignerInfos >-----#
    SignerInfos = SET_OF(name=u'SignerInfos', mode=MODE_TYPE)
    _SignerInfos__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignerInfo')))
    SignerInfos._cont = _SignerInfos__item_
    
    #-----< EncapsulatedContentInfo >-----#
    EncapsulatedContentInfo = SEQ(name=u'EncapsulatedContentInfo', mode=MODE_TYPE)
    _EncapsulatedContentInfo_eContentType = OID(name=u'eContentType', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'id']))
    __EncapsulatedContentInfo_eContentType_tab = CLASS(name='_tab_CONTENT-TYPE', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_0 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedData')))
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_2 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedData')))
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_3 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EnvelopedData')))
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_4 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthenticatedData')))
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_5 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestedData')))
    __EncapsulatedContentInfo_eContentType_tab._val = ASN1Set(rv=[dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_0), ('id', (1, 2, 840, 113549, 1, 7, 1))]), dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_1), ('id', (1, 2, 840, 113549, 1, 7, 2))]), dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_2), ('id', (1, 2, 840, 113549, 1, 7, 6))]), dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_3), ('id', (1, 2, 840, 113549, 1, 7, 3))]), dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_4), ('id', (1, 2, 840, 113549, 1, 9, 16, 1, 2))]), dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_5), ('id', (1, 2, 840, 113549, 1, 7, 5))])], rr=[], ev=None, er=[])
    _EncapsulatedContentInfo_eContentType._const_tab = __EncapsulatedContentInfo_eContentType_tab
    _EncapsulatedContentInfo_eContentType._const_tab_at = None
    _EncapsulatedContentInfo_eContentType._const_tab_id = u'id'
    _EncapsulatedContentInfo_eContent = OCT_STR(name=u'eContent', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __EncapsulatedContentInfo_eContent_contain = OPEN(name='_cont_eContent', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'Type']))
    __EncapsulatedContentInfo_eContent_contain._const_tab = __EncapsulatedContentInfo_eContentType_tab
    __EncapsulatedContentInfo_eContent_contain._const_tab_at = ('..', u'eContentType')
    __EncapsulatedContentInfo_eContent_contain._const_tab_id = u'Type'
    _EncapsulatedContentInfo_eContent._const_cont = __EncapsulatedContentInfo_eContent_contain
    EncapsulatedContentInfo._cont = ASN1Dict([
        (u'eContentType', _EncapsulatedContentInfo_eContentType),
        (u'eContent', _EncapsulatedContentInfo_eContent),
        ])
    EncapsulatedContentInfo._ext = None
    
    #-----< SignerInfo >-----#
    SignerInfo = SEQ(name=u'SignerInfo', mode=MODE_TYPE)
    _SignerInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _SignerInfo_sid = CHOICE(name=u'sid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignerIdentifier')))
    _SignerInfo_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestAlgorithmIdentifier')))
    _SignerInfo_signedAttrs = SET_OF(name=u'signedAttrs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedAttributes')), opt=True)
    _SignerInfo_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignatureAlgorithmIdentifier')))
    _SignerInfo_signature = OCT_STR(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignatureValue')))
    _SignerInfo_unsignedAttrs = SET_OF(name=u'unsignedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attributes')), opt=True)
    __SignerInfo_unsignedAttrs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    ___SignerInfo_unsignedAttrs__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____SignerInfo_unsignedAttrs__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____SignerInfo_unsignedAttrs__item__attrType_tab_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Countersignature')))
    ____SignerInfo_unsignedAttrs__item__attrType_tab._val = ASN1Set(rv=[dict([(u'Type', _____SignerInfo_unsignedAttrs__item__attrType_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 6))])], rr=[], ev=None, er=[])
    ___SignerInfo_unsignedAttrs__item__attrType._const_tab = ____SignerInfo_unsignedAttrs__item__attrType_tab
    ___SignerInfo_unsignedAttrs__item__attrType._const_tab_at = None
    ___SignerInfo_unsignedAttrs__item__attrType._const_tab_id = u'id'
    ___SignerInfo_unsignedAttrs__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ____SignerInfo_unsignedAttrs__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ____SignerInfo_unsignedAttrs__item__attrValues__item_._const_tab = ____SignerInfo_unsignedAttrs__item__attrType_tab
    ____SignerInfo_unsignedAttrs__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ____SignerInfo_unsignedAttrs__item__attrValues__item_._const_tab_id = u'Type'
    ___SignerInfo_unsignedAttrs__item__attrValues._cont = ____SignerInfo_unsignedAttrs__item__attrValues__item_
    __SignerInfo_unsignedAttrs__item_._cont = ASN1Dict([
        (u'attrType', ___SignerInfo_unsignedAttrs__item__attrType),
        (u'attrValues', ___SignerInfo_unsignedAttrs__item__attrValues),
        ])
    __SignerInfo_unsignedAttrs__item_._ext = None
    _SignerInfo_unsignedAttrs._cont = __SignerInfo_unsignedAttrs__item_
    _SignerInfo_unsignedAttrs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    SignerInfo._cont = ASN1Dict([
        (u'version', _SignerInfo_version),
        (u'sid', _SignerInfo_sid),
        (u'digestAlgorithm', _SignerInfo_digestAlgorithm),
        (u'signedAttrs', _SignerInfo_signedAttrs),
        (u'signatureAlgorithm', _SignerInfo_signatureAlgorithm),
        (u'signature', _SignerInfo_signature),
        (u'unsignedAttrs', _SignerInfo_unsignedAttrs),
        ])
    SignerInfo._ext = None
    
    #-----< SignedAttributes >-----#
    SignedAttributes = SET_OF(name=u'SignedAttributes', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attributes')))
    _SignedAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    __SignedAttributes__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___SignedAttributes__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____SignedAttributes__item__attrType_tab_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SigningTime')))
    ____SignedAttributes__item__attrType_tab_val_Type_1 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageDigest')))
    ____SignedAttributes__item__attrType_tab_val_Type_2 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentType')))
    ___SignedAttributes__item__attrType_tab._val = ASN1Set(rv=[dict([(u'Type', ____SignedAttributes__item__attrType_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 5))]), dict([(u'Type', ____SignedAttributes__item__attrType_tab_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 4))]), dict([(u'Type', ____SignedAttributes__item__attrType_tab_val_Type_2), (u'id', (1, 2, 840, 113549, 1, 9, 3))])], rr=[], ev=None, er=[])
    __SignedAttributes__item__attrType._const_tab = ___SignedAttributes__item__attrType_tab
    __SignedAttributes__item__attrType._const_tab_at = None
    __SignedAttributes__item__attrType._const_tab_id = u'id'
    __SignedAttributes__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ___SignedAttributes__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ___SignedAttributes__item__attrValues__item_._const_tab = ___SignedAttributes__item__attrType_tab
    ___SignedAttributes__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ___SignedAttributes__item__attrValues__item_._const_tab_id = u'Type'
    __SignedAttributes__item__attrValues._cont = ___SignedAttributes__item__attrValues__item_
    _SignedAttributes__item_._cont = ASN1Dict([
        (u'attrType', __SignedAttributes__item__attrType),
        (u'attrValues', __SignedAttributes__item__attrValues),
        ])
    _SignedAttributes__item_._ext = None
    SignedAttributes._cont = _SignedAttributes__item_
    SignedAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< SignerIdentifier >-----#
    SignerIdentifier = CHOICE(name=u'SignerIdentifier', mode=MODE_TYPE)
    _SignerIdentifier_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    _SignerIdentifier_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SubjectKeyIdentifier')), group=0)
    SignerIdentifier._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _SignerIdentifier_issuerAndSerialNumber),
        (u'subjectKeyIdentifier', _SignerIdentifier_subjectKeyIdentifier),
        ])
    SignerIdentifier._ext = [u'subjectKeyIdentifier']
    
    #-----< SignedAttributesSet >-----#
    SignedAttributesSet = CLASS(name=u'SignedAttributesSet', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _SignedAttributesSet_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SigningTime')))
    _SignedAttributesSet_val_Type_1 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageDigest')))
    _SignedAttributesSet_val_Type_2 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentType')))
    SignedAttributesSet._val = ASN1Set(rv=[dict([(u'Type', _SignedAttributesSet_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 5))]), dict([(u'Type', _SignedAttributesSet_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 4))]), dict([(u'Type', _SignedAttributesSet_val_Type_2), (u'id', (1, 2, 840, 113549, 1, 9, 3))])], rr=[], ev=[], er=[])
    
    #-----< UnsignedAttributes >-----#
    UnsignedAttributes = CLASS(name=u'UnsignedAttributes', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _UnsignedAttributes_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Countersignature')))
    UnsignedAttributes._val = ASN1Set(rv=[dict([(u'Type', _UnsignedAttributes_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 6))])], rr=[], ev=[], er=[])
    
    #-----< SignatureValue >-----#
    SignatureValue = OCT_STR(name=u'SignatureValue', mode=MODE_TYPE)
    
    #-----< EnvelopedData >-----#
    EnvelopedData = SEQ(name=u'EnvelopedData', mode=MODE_TYPE)
    _EnvelopedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _EnvelopedData_originatorInfo = SEQ(name=u'originatorInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OriginatorInfo')), opt=True)
    _EnvelopedData_recipientInfos = SET_OF(name=u'recipientInfos', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientInfos')))
    _EnvelopedData_encryptedContentInfo = SEQ(name=u'encryptedContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedContentInfo')))
    _EnvelopedData_unprotectedAttrs = SET_OF(name=u'unprotectedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attributes')), opt=True, group=0)
    __EnvelopedData_unprotectedAttrs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    ___EnvelopedData_unprotectedAttrs__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____EnvelopedData_unprotectedAttrs__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____EnvelopedData_unprotectedAttrs__item__attrType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___EnvelopedData_unprotectedAttrs__item__attrType._const_tab = ____EnvelopedData_unprotectedAttrs__item__attrType_tab
    ___EnvelopedData_unprotectedAttrs__item__attrType._const_tab_at = None
    ___EnvelopedData_unprotectedAttrs__item__attrType._const_tab_id = u'id'
    ___EnvelopedData_unprotectedAttrs__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ____EnvelopedData_unprotectedAttrs__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    _____EnvelopedData_unprotectedAttrs__item__attrValues__item__tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____EnvelopedData_unprotectedAttrs__item__attrValues__item__tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____EnvelopedData_unprotectedAttrs__item__attrValues__item_._const_tab = _____EnvelopedData_unprotectedAttrs__item__attrValues__item__tab
    ____EnvelopedData_unprotectedAttrs__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ____EnvelopedData_unprotectedAttrs__item__attrValues__item_._const_tab_id = u'Type'
    ___EnvelopedData_unprotectedAttrs__item__attrValues._cont = ____EnvelopedData_unprotectedAttrs__item__attrValues__item_
    __EnvelopedData_unprotectedAttrs__item_._cont = ASN1Dict([
        (u'attrType', ___EnvelopedData_unprotectedAttrs__item__attrType),
        (u'attrValues', ___EnvelopedData_unprotectedAttrs__item__attrValues),
        ])
    __EnvelopedData_unprotectedAttrs__item_._ext = None
    _EnvelopedData_unprotectedAttrs._cont = __EnvelopedData_unprotectedAttrs__item_
    _EnvelopedData_unprotectedAttrs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    EnvelopedData._cont = ASN1Dict([
        (u'version', _EnvelopedData_version),
        (u'originatorInfo', _EnvelopedData_originatorInfo),
        (u'recipientInfos', _EnvelopedData_recipientInfos),
        (u'encryptedContentInfo', _EnvelopedData_encryptedContentInfo),
        (u'unprotectedAttrs', _EnvelopedData_unprotectedAttrs),
        ])
    EnvelopedData._ext = [u'unprotectedAttrs']
    
    #-----< OriginatorInfo >-----#
    OriginatorInfo = SEQ(name=u'OriginatorInfo', mode=MODE_TYPE)
    _OriginatorInfo_certs = SET_OF(name=u'certs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CertificateSet')), opt=True)
    _OriginatorInfo_crls = SET_OF(name=u'crls', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RevocationInfoChoices')), opt=True)
    OriginatorInfo._cont = ASN1Dict([
        (u'certs', _OriginatorInfo_certs),
        (u'crls', _OriginatorInfo_crls),
        ])
    OriginatorInfo._ext = None
    
    #-----< RecipientInfos >-----#
    RecipientInfos = SET_OF(name=u'RecipientInfos', mode=MODE_TYPE)
    _RecipientInfos__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientInfo')))
    RecipientInfos._cont = _RecipientInfos__item_
    RecipientInfos._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< EncryptedContentInfo >-----#
    EncryptedContentInfo = SEQ(name=u'EncryptedContentInfo', mode=MODE_TYPE)
    _EncryptedContentInfo_contentType = OID(name=u'contentType', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'id']))
    __EncryptedContentInfo_contentType_tab = CLASS(name='_tab_CONTENT-TYPE', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    ___EncryptedContentInfo_contentType_tab_val_Type_0 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___EncryptedContentInfo_contentType_tab_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedData')))
    ___EncryptedContentInfo_contentType_tab_val_Type_2 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedData')))
    ___EncryptedContentInfo_contentType_tab_val_Type_3 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EnvelopedData')))
    ___EncryptedContentInfo_contentType_tab_val_Type_4 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthenticatedData')))
    ___EncryptedContentInfo_contentType_tab_val_Type_5 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestedData')))
    __EncryptedContentInfo_contentType_tab._val = ASN1Set(rv=[dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_0), ('id', (1, 2, 840, 113549, 1, 7, 1))]), dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_1), ('id', (1, 2, 840, 113549, 1, 7, 2))]), dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_2), ('id', (1, 2, 840, 113549, 1, 7, 6))]), dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_3), ('id', (1, 2, 840, 113549, 1, 7, 3))]), dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_4), ('id', (1, 2, 840, 113549, 1, 9, 16, 1, 2))]), dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_5), ('id', (1, 2, 840, 113549, 1, 7, 5))])], rr=[], ev=None, er=[])
    _EncryptedContentInfo_contentType._const_tab = __EncryptedContentInfo_contentType_tab
    _EncryptedContentInfo_contentType._const_tab_at = None
    _EncryptedContentInfo_contentType._const_tab_id = u'id'
    _EncryptedContentInfo_contentEncryptionAlgorithm = SEQ(name=u'contentEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentEncryptionAlgorithmIdentifier')))
    _EncryptedContentInfo_encryptedContent = OCT_STR(name=u'encryptedContent', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    EncryptedContentInfo._cont = ASN1Dict([
        (u'contentType', _EncryptedContentInfo_contentType),
        (u'contentEncryptionAlgorithm', _EncryptedContentInfo_contentEncryptionAlgorithm),
        (u'encryptedContent', _EncryptedContentInfo_encryptedContent),
        ])
    EncryptedContentInfo._ext = None
    
    #-----< UnprotectedAttributes >-----#
    UnprotectedAttributes = CLASS(name=u'UnprotectedAttributes', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    UnprotectedAttributes._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RecipientInfo >-----#
    RecipientInfo = CHOICE(name=u'RecipientInfo', mode=MODE_TYPE)
    _RecipientInfo_ktri = SEQ(name=u'ktri', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyTransRecipientInfo')))
    _RecipientInfo_kari = SEQ(name=u'kari', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyAgreeRecipientInfo')), group=0)
    _RecipientInfo_kekri = SEQ(name=u'kekri', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KEKRecipientInfo')), group=1)
    _RecipientInfo_pwri = SEQ(name=u'pwri', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'PasswordRecipientInfo')), group=2)
    _RecipientInfo_ori = SEQ(name=u'ori', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OtherRecipientInfo')), group=2)
    RecipientInfo._cont = ASN1Dict([
        (u'ktri', _RecipientInfo_ktri),
        (u'kari', _RecipientInfo_kari),
        (u'kekri', _RecipientInfo_kekri),
        (u'pwri', _RecipientInfo_pwri),
        (u'ori', _RecipientInfo_ori),
        ])
    RecipientInfo._ext = [u'kari', u'kekri', u'pwri', u'ori']
    
    #-----< EncryptedKey >-----#
    EncryptedKey = OCT_STR(name=u'EncryptedKey', mode=MODE_TYPE)
    
    #-----< KeyTransRecipientInfo >-----#
    KeyTransRecipientInfo = SEQ(name=u'KeyTransRecipientInfo', mode=MODE_TYPE)
    _KeyTransRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _KeyTransRecipientInfo_rid = CHOICE(name=u'rid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientIdentifier')))
    _KeyTransRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-TRANSPORT'), [u'id']))
    ___KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab = CLASS(name='_tab_KEY-TRANSPORT', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    ____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __KEY_TRANSPORT_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'Params', ____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]))])], rr=[], ev=None, er=[])
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab = ___KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab_at = None
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab_id = u'id'
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-TRANSPORT'), [u'Params']), opt=True)
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab = ___KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab_id = u'Params'
    _KeyTransRecipientInfo_keyEncryptionAlgorithm._cont = ASN1Dict([
        (u'algorithm', __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm),
        (u'parameters', __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters),
        ])
    _KeyTransRecipientInfo_keyEncryptionAlgorithm._ext = None
    _KeyTransRecipientInfo_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedKey')))
    KeyTransRecipientInfo._cont = ASN1Dict([
        (u'version', _KeyTransRecipientInfo_version),
        (u'rid', _KeyTransRecipientInfo_rid),
        (u'keyEncryptionAlgorithm', _KeyTransRecipientInfo_keyEncryptionAlgorithm),
        (u'encryptedKey', _KeyTransRecipientInfo_encryptedKey),
        ])
    KeyTransRecipientInfo._ext = None
    
    #-----< KeyTransportAlgorithmSet >-----#
    KeyTransportAlgorithmSet = CLASS(name=u'KeyTransportAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    _KeyTransportAlgorithmSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    KeyTransportAlgorithmSet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'Params', _KeyTransportAlgorithmSet_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]))])], rr=[], ev=[], er=[])
    
    #-----< RecipientIdentifier >-----#
    RecipientIdentifier = CHOICE(name=u'RecipientIdentifier', mode=MODE_TYPE)
    _RecipientIdentifier_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    _RecipientIdentifier_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SubjectKeyIdentifier')), group=0)
    RecipientIdentifier._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _RecipientIdentifier_issuerAndSerialNumber),
        (u'subjectKeyIdentifier', _RecipientIdentifier_subjectKeyIdentifier),
        ])
    RecipientIdentifier._ext = [u'subjectKeyIdentifier']
    
    #-----< KeyAgreeRecipientInfo >-----#
    KeyAgreeRecipientInfo = SEQ(name=u'KeyAgreeRecipientInfo', mode=MODE_TYPE)
    _KeyAgreeRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _KeyAgreeRecipientInfo_originator = CHOICE(name=u'originator', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OriginatorIdentifierOrKey')))
    _KeyAgreeRecipientInfo_ukm = OCT_STR(name=u'ukm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'UserKeyingMaterial')), opt=True)
    _KeyAgreeRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-AGREE'), [u'id']))
    ___KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab = CLASS(name='_tab_KEY-AGREE', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-AGREE')))
    ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    __KEY_AGREE_PublicKeySet_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    __KEY_AGREE_PublicKeySet_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    __KEY_AGREE_smimeCaps_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    ___KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5)), (u'Params', ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', __KEY_AGREE_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_AGREE_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', __KEY_AGREE_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10)), (u'Params', ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', __KEY_AGREE_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_AGREE_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', __KEY_AGREE_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]))])], rr=[], ev=None, er=[])
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab = ___KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab_at = None
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab_id = u'id'
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-AGREE'), [u'Params']), opt=True)
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab = ___KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab_id = u'Params'
    _KeyAgreeRecipientInfo_keyEncryptionAlgorithm._cont = ASN1Dict([
        (u'algorithm', __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm),
        (u'parameters', __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters),
        ])
    _KeyAgreeRecipientInfo_keyEncryptionAlgorithm._ext = None
    _KeyAgreeRecipientInfo_recipientEncryptedKeys = SEQ_OF(name=u'recipientEncryptedKeys', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientEncryptedKeys')))
    KeyAgreeRecipientInfo._cont = ASN1Dict([
        (u'version', _KeyAgreeRecipientInfo_version),
        (u'originator', _KeyAgreeRecipientInfo_originator),
        (u'ukm', _KeyAgreeRecipientInfo_ukm),
        (u'keyEncryptionAlgorithm', _KeyAgreeRecipientInfo_keyEncryptionAlgorithm),
        (u'recipientEncryptedKeys', _KeyAgreeRecipientInfo_recipientEncryptedKeys),
        ])
    KeyAgreeRecipientInfo._ext = None
    
    #-----< KeyAgreementAlgorithmSet >-----#
    KeyAgreementAlgorithmSet = CLASS(name=u'KeyAgreementAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-AGREE')))
    _KeyAgreementAlgorithmSet_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _KeyAgreementAlgorithmSet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    KeyAgreementAlgorithmSet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5)), (u'Params', _KeyAgreementAlgorithmSet_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', __KEY_AGREE_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_AGREE_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', __KEY_AGREE_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10)), (u'Params', _KeyAgreementAlgorithmSet_val_Params_1), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', __KEY_AGREE_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_AGREE_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', __KEY_AGREE_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]))])], rr=[], ev=[], er=[])
    
    #-----< OriginatorIdentifierOrKey >-----#
    OriginatorIdentifierOrKey = CHOICE(name=u'OriginatorIdentifierOrKey', mode=MODE_TYPE)
    _OriginatorIdentifierOrKey_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    _OriginatorIdentifierOrKey_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SubjectKeyIdentifier')))
    _OriginatorIdentifierOrKey_originatorKey = SEQ(name=u'originatorKey', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OriginatorPublicKey')))
    OriginatorIdentifierOrKey._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _OriginatorIdentifierOrKey_issuerAndSerialNumber),
        (u'subjectKeyIdentifier', _OriginatorIdentifierOrKey_subjectKeyIdentifier),
        (u'originatorKey', _OriginatorIdentifierOrKey_originatorKey),
        ])
    OriginatorIdentifierOrKey._ext = None
    
    #-----< OriginatorPublicKey >-----#
    OriginatorPublicKey = SEQ(name=u'OriginatorPublicKey', mode=MODE_TYPE)
    _OriginatorPublicKey_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __OriginatorPublicKey_algorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'id']))
    ___OriginatorPublicKey_algorithm_algorithm_tab = CLASS(name='_tab_PUBLIC-KEY', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    ____OriginatorPublicKey_algorithm_algorithm_tab_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    ____OriginatorPublicKey_algorithm_algorithm_tab_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    ___OriginatorPublicKey_algorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', ____OriginatorPublicKey_algorithm_algorithm_tab_val_KeyValue_0), (u'Params', ____OriginatorPublicKey_algorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])
    __OriginatorPublicKey_algorithm_algorithm._const_tab = ___OriginatorPublicKey_algorithm_algorithm_tab
    __OriginatorPublicKey_algorithm_algorithm._const_tab_at = None
    __OriginatorPublicKey_algorithm_algorithm._const_tab_id = u'id'
    __OriginatorPublicKey_algorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'Params']), opt=True)
    __OriginatorPublicKey_algorithm_parameters._const_tab = ___OriginatorPublicKey_algorithm_algorithm_tab
    __OriginatorPublicKey_algorithm_parameters._const_tab_at = ('..', u'algorithm')
    __OriginatorPublicKey_algorithm_parameters._const_tab_id = u'Params'
    _OriginatorPublicKey_algorithm._cont = ASN1Dict([
        (u'algorithm', __OriginatorPublicKey_algorithm_algorithm),
        (u'parameters', __OriginatorPublicKey_algorithm_parameters),
        ])
    _OriginatorPublicKey_algorithm._ext = None
    _OriginatorPublicKey_publicKey = BIT_STR(name=u'publicKey', mode=MODE_TYPE)
    OriginatorPublicKey._cont = ASN1Dict([
        (u'algorithm', _OriginatorPublicKey_algorithm),
        (u'publicKey', _OriginatorPublicKey_publicKey),
        ])
    OriginatorPublicKey._ext = None
    
    #-----< OriginatorKeySet >-----#
    OriginatorKeySet = CLASS(name=u'OriginatorKeySet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _OriginatorKeySet_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _OriginatorKeySet_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    OriginatorKeySet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _OriginatorKeySet_val_KeyValue_0), (u'Params', _OriginatorKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=[], er=[])
    
    #-----< RecipientEncryptedKeys >-----#
    RecipientEncryptedKeys = SEQ_OF(name=u'RecipientEncryptedKeys', mode=MODE_TYPE)
    _RecipientEncryptedKeys__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientEncryptedKey')))
    RecipientEncryptedKeys._cont = _RecipientEncryptedKeys__item_
    
    #-----< RecipientEncryptedKey >-----#
    RecipientEncryptedKey = SEQ(name=u'RecipientEncryptedKey', mode=MODE_TYPE)
    _RecipientEncryptedKey_rid = CHOICE(name=u'rid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyAgreeRecipientIdentifier')))
    _RecipientEncryptedKey_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedKey')))
    RecipientEncryptedKey._cont = ASN1Dict([
        (u'rid', _RecipientEncryptedKey_rid),
        (u'encryptedKey', _RecipientEncryptedKey_encryptedKey),
        ])
    RecipientEncryptedKey._ext = None
    
    #-----< KeyAgreeRecipientIdentifier >-----#
    KeyAgreeRecipientIdentifier = CHOICE(name=u'KeyAgreeRecipientIdentifier', mode=MODE_TYPE)
    _KeyAgreeRecipientIdentifier_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    _KeyAgreeRecipientIdentifier_rKeyId = SEQ(name=u'rKeyId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientKeyIdentifier')))
    KeyAgreeRecipientIdentifier._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _KeyAgreeRecipientIdentifier_issuerAndSerialNumber),
        (u'rKeyId', _KeyAgreeRecipientIdentifier_rKeyId),
        ])
    KeyAgreeRecipientIdentifier._ext = None
    
    #-----< RecipientKeyIdentifier >-----#
    RecipientKeyIdentifier = SEQ(name=u'RecipientKeyIdentifier', mode=MODE_TYPE)
    _RecipientKeyIdentifier_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SubjectKeyIdentifier')))
    _RecipientKeyIdentifier_date = TIME_GEN(name=u'date', mode=MODE_TYPE, opt=True)
    _RecipientKeyIdentifier_other = SEQ(name=u'other', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OtherKeyAttribute')), opt=True)
    RecipientKeyIdentifier._cont = ASN1Dict([
        (u'subjectKeyIdentifier', _RecipientKeyIdentifier_subjectKeyIdentifier),
        (u'date', _RecipientKeyIdentifier_date),
        (u'other', _RecipientKeyIdentifier_other),
        ])
    RecipientKeyIdentifier._ext = None
    
    #-----< SubjectKeyIdentifier >-----#
    SubjectKeyIdentifier = OCT_STR(name=u'SubjectKeyIdentifier', mode=MODE_TYPE)
    
    #-----< KEKRecipientInfo >-----#
    KEKRecipientInfo = SEQ(name=u'KEKRecipientInfo', mode=MODE_TYPE)
    _KEKRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _KEKRecipientInfo_kekid = SEQ(name=u'kekid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KEKIdentifier')))
    _KEKRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyEncryptionAlgorithmIdentifier')))
    _KEKRecipientInfo_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedKey')))
    KEKRecipientInfo._cont = ASN1Dict([
        (u'version', _KEKRecipientInfo_version),
        (u'kekid', _KEKRecipientInfo_kekid),
        (u'keyEncryptionAlgorithm', _KEKRecipientInfo_keyEncryptionAlgorithm),
        (u'encryptedKey', _KEKRecipientInfo_encryptedKey),
        ])
    KEKRecipientInfo._ext = None
    
    #-----< KEKIdentifier >-----#
    KEKIdentifier = SEQ(name=u'KEKIdentifier', mode=MODE_TYPE)
    _KEKIdentifier_keyIdentifier = OCT_STR(name=u'keyIdentifier', mode=MODE_TYPE)
    _KEKIdentifier_date = TIME_GEN(name=u'date', mode=MODE_TYPE, opt=True)
    _KEKIdentifier_other = SEQ(name=u'other', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OtherKeyAttribute')), opt=True)
    KEKIdentifier._cont = ASN1Dict([
        (u'keyIdentifier', _KEKIdentifier_keyIdentifier),
        (u'date', _KEKIdentifier_date),
        (u'other', _KEKIdentifier_other),
        ])
    KEKIdentifier._ext = None
    
    #-----< PasswordRecipientInfo >-----#
    PasswordRecipientInfo = SEQ(name=u'PasswordRecipientInfo', mode=MODE_TYPE)
    _PasswordRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _PasswordRecipientInfo_keyDerivationAlgorithm = SEQ(name=u'keyDerivationAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyDerivationAlgorithmIdentifier')), opt=True)
    _PasswordRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyEncryptionAlgorithmIdentifier')))
    _PasswordRecipientInfo_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedKey')))
    PasswordRecipientInfo._cont = ASN1Dict([
        (u'version', _PasswordRecipientInfo_version),
        (u'keyDerivationAlgorithm', _PasswordRecipientInfo_keyDerivationAlgorithm),
        (u'keyEncryptionAlgorithm', _PasswordRecipientInfo_keyEncryptionAlgorithm),
        (u'encryptedKey', _PasswordRecipientInfo_encryptedKey),
        ])
    PasswordRecipientInfo._ext = None
    
    #-----< OTHER-RECIPIENT >-----#
    OTHER_RECIPIENT = CLASS(name=u'OTHER-RECIPIENT', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< OtherRecipientInfo >-----#
    OtherRecipientInfo = SEQ(name=u'OtherRecipientInfo', mode=MODE_TYPE)
    _OtherRecipientInfo_oriType = OID(name=u'oriType', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-RECIPIENT'), [u'id']))
    __OtherRecipientInfo_oriType_tab = CLASS(name='_tab_OTHER-RECIPIENT', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-RECIPIENT')))
    __OtherRecipientInfo_oriType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherRecipientInfo_oriType._const_tab = __OtherRecipientInfo_oriType_tab
    _OtherRecipientInfo_oriType._const_tab_at = None
    _OtherRecipientInfo_oriType._const_tab_id = u'id'
    _OtherRecipientInfo_oriValue = OPEN(name=u'oriValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-RECIPIENT'), [u'Type']))
    __OtherRecipientInfo_oriValue_tab = CLASS(name='_tab_OTHER-RECIPIENT', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-RECIPIENT')))
    __OtherRecipientInfo_oriValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherRecipientInfo_oriValue._const_tab = __OtherRecipientInfo_oriValue_tab
    _OtherRecipientInfo_oriValue._const_tab_at = ('..', u'oriType')
    _OtherRecipientInfo_oriValue._const_tab_id = u'Type'
    OtherRecipientInfo._cont = ASN1Dict([
        (u'oriType', _OtherRecipientInfo_oriType),
        (u'oriValue', _OtherRecipientInfo_oriValue),
        ])
    OtherRecipientInfo._ext = None
    
    #-----< SupportedOtherRecipInfo >-----#
    SupportedOtherRecipInfo = CLASS(name=u'SupportedOtherRecipInfo', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-RECIPIENT')))
    SupportedOtherRecipInfo._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DigestedData >-----#
    DigestedData = SEQ(name=u'DigestedData', mode=MODE_TYPE)
    _DigestedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _DigestedData_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestAlgorithmIdentifier')))
    _DigestedData_encapContentInfo = SEQ(name=u'encapContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncapsulatedContentInfo')))
    _DigestedData_digest = OCT_STR(name=u'digest', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Digest')))
    DigestedData._cont = ASN1Dict([
        (u'version', _DigestedData_version),
        (u'digestAlgorithm', _DigestedData_digestAlgorithm),
        (u'encapContentInfo', _DigestedData_encapContentInfo),
        (u'digest', _DigestedData_digest),
        ])
    DigestedData._ext = []
    
    #-----< Digest >-----#
    Digest = OCT_STR(name=u'Digest', mode=MODE_TYPE)
    
    #-----< EncryptedData >-----#
    EncryptedData = SEQ(name=u'EncryptedData', mode=MODE_TYPE)
    _EncryptedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _EncryptedData_encryptedContentInfo = SEQ(name=u'encryptedContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedContentInfo')))
    _EncryptedData_unprotectedAttrs = SET_OF(name=u'unprotectedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attributes')), opt=True, group=0)
    __EncryptedData_unprotectedAttrs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    ___EncryptedData_unprotectedAttrs__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____EncryptedData_unprotectedAttrs__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____EncryptedData_unprotectedAttrs__item__attrType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___EncryptedData_unprotectedAttrs__item__attrType._const_tab = ____EncryptedData_unprotectedAttrs__item__attrType_tab
    ___EncryptedData_unprotectedAttrs__item__attrType._const_tab_at = None
    ___EncryptedData_unprotectedAttrs__item__attrType._const_tab_id = u'id'
    ___EncryptedData_unprotectedAttrs__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ____EncryptedData_unprotectedAttrs__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    _____EncryptedData_unprotectedAttrs__item__attrValues__item__tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____EncryptedData_unprotectedAttrs__item__attrValues__item__tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____EncryptedData_unprotectedAttrs__item__attrValues__item_._const_tab = _____EncryptedData_unprotectedAttrs__item__attrValues__item__tab
    ____EncryptedData_unprotectedAttrs__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ____EncryptedData_unprotectedAttrs__item__attrValues__item_._const_tab_id = u'Type'
    ___EncryptedData_unprotectedAttrs__item__attrValues._cont = ____EncryptedData_unprotectedAttrs__item__attrValues__item_
    __EncryptedData_unprotectedAttrs__item_._cont = ASN1Dict([
        (u'attrType', ___EncryptedData_unprotectedAttrs__item__attrType),
        (u'attrValues', ___EncryptedData_unprotectedAttrs__item__attrValues),
        ])
    __EncryptedData_unprotectedAttrs__item_._ext = None
    _EncryptedData_unprotectedAttrs._cont = __EncryptedData_unprotectedAttrs__item_
    _EncryptedData_unprotectedAttrs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    EncryptedData._cont = ASN1Dict([
        (u'version', _EncryptedData_version),
        (u'encryptedContentInfo', _EncryptedData_encryptedContentInfo),
        (u'unprotectedAttrs', _EncryptedData_unprotectedAttrs),
        ])
    EncryptedData._ext = [u'unprotectedAttrs']
    
    #-----< AuthenticatedData >-----#
    AuthenticatedData = SEQ(name=u'AuthenticatedData', mode=MODE_TYPE)
    _AuthenticatedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _AuthenticatedData_originatorInfo = SEQ(name=u'originatorInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OriginatorInfo')), opt=True)
    _AuthenticatedData_recipientInfos = SET_OF(name=u'recipientInfos', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientInfos')))
    _AuthenticatedData_macAlgorithm = SEQ(name=u'macAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageAuthenticationCodeAlgorithm')))
    _AuthenticatedData_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestAlgorithmIdentifier')), opt=True)
    _AuthenticatedData_encapContentInfo = SEQ(name=u'encapContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncapsulatedContentInfo')))
    _AuthenticatedData_authAttrs = SET_OF(name=u'authAttrs', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthAttributes')), opt=True)
    _AuthenticatedData_mac = OCT_STR(name=u'mac', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageAuthenticationCode')))
    _AuthenticatedData_unauthAttrs = SET_OF(name=u'unauthAttrs', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'UnauthAttributes')), opt=True)
    AuthenticatedData._cont = ASN1Dict([
        (u'version', _AuthenticatedData_version),
        (u'originatorInfo', _AuthenticatedData_originatorInfo),
        (u'recipientInfos', _AuthenticatedData_recipientInfos),
        (u'macAlgorithm', _AuthenticatedData_macAlgorithm),
        (u'digestAlgorithm', _AuthenticatedData_digestAlgorithm),
        (u'encapContentInfo', _AuthenticatedData_encapContentInfo),
        (u'authAttrs', _AuthenticatedData_authAttrs),
        (u'mac', _AuthenticatedData_mac),
        (u'unauthAttrs', _AuthenticatedData_unauthAttrs),
        ])
    AuthenticatedData._ext = None
    
    #-----< AuthAttributes >-----#
    AuthAttributes = SET_OF(name=u'AuthAttributes', mode=MODE_TYPE)
    _AuthAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    __AuthAttributes__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___AuthAttributes__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____AuthAttributes__item__attrType_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentType')))
    ____AuthAttributes__item__attrType_tab_val_Type_1 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageDigest')))
    ____AuthAttributes__item__attrType_tab_val_Type_2 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SigningTime')))
    ___AuthAttributes__item__attrType_tab._val = ASN1Set(rv=[dict([(u'Type', ____AuthAttributes__item__attrType_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 3))]), dict([(u'Type', ____AuthAttributes__item__attrType_tab_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 4))]), dict([(u'Type', ____AuthAttributes__item__attrType_tab_val_Type_2), (u'id', (1, 2, 840, 113549, 1, 9, 5))])], rr=[], ev=None, er=[])
    __AuthAttributes__item__attrType._const_tab = ___AuthAttributes__item__attrType_tab
    __AuthAttributes__item__attrType._const_tab_at = None
    __AuthAttributes__item__attrType._const_tab_id = u'id'
    __AuthAttributes__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ___AuthAttributes__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ___AuthAttributes__item__attrValues__item_._const_tab = ___AuthAttributes__item__attrType_tab
    ___AuthAttributes__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ___AuthAttributes__item__attrValues__item_._const_tab_id = u'Type'
    __AuthAttributes__item__attrValues._cont = ___AuthAttributes__item__attrValues__item_
    _AuthAttributes__item_._cont = ASN1Dict([
        (u'attrType', __AuthAttributes__item__attrType),
        (u'attrValues', __AuthAttributes__item__attrValues),
        ])
    _AuthAttributes__item_._ext = None
    AuthAttributes._cont = _AuthAttributes__item_
    AuthAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< AuthAttributeSet >-----#
    AuthAttributeSet = CLASS(name=u'AuthAttributeSet', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _AuthAttributeSet_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentType')))
    _AuthAttributeSet_val_Type_1 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageDigest')))
    _AuthAttributeSet_val_Type_2 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SigningTime')))
    AuthAttributeSet._val = ASN1Set(rv=[dict([(u'Type', _AuthAttributeSet_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 3))]), dict([(u'Type', _AuthAttributeSet_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 4))]), dict([(u'Type', _AuthAttributeSet_val_Type_2), (u'id', (1, 2, 840, 113549, 1, 9, 5))])], rr=[], ev=[], er=[])
    
    #-----< MessageAuthenticationCode >-----#
    MessageAuthenticationCode = OCT_STR(name=u'MessageAuthenticationCode', mode=MODE_TYPE)
    
    #-----< UnauthAttributes >-----#
    UnauthAttributes = SET_OF(name=u'UnauthAttributes', mode=MODE_TYPE)
    _UnauthAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    __UnauthAttributes__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___UnauthAttributes__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ___UnauthAttributes__item__attrType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __UnauthAttributes__item__attrType._const_tab = ___UnauthAttributes__item__attrType_tab
    __UnauthAttributes__item__attrType._const_tab_at = None
    __UnauthAttributes__item__attrType._const_tab_id = u'id'
    __UnauthAttributes__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ___UnauthAttributes__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ____UnauthAttributes__item__attrValues__item__tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____UnauthAttributes__item__attrValues__item__tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UnauthAttributes__item__attrValues__item_._const_tab = ____UnauthAttributes__item__attrValues__item__tab
    ___UnauthAttributes__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ___UnauthAttributes__item__attrValues__item_._const_tab_id = u'Type'
    __UnauthAttributes__item__attrValues._cont = ___UnauthAttributes__item__attrValues__item_
    _UnauthAttributes__item_._cont = ASN1Dict([
        (u'attrType', __UnauthAttributes__item__attrType),
        (u'attrValues', __UnauthAttributes__item__attrValues),
        ])
    _UnauthAttributes__item_._ext = None
    UnauthAttributes._cont = _UnauthAttributes__item_
    UnauthAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< UnauthAttributeSet >-----#
    UnauthAttributeSet = CLASS(name=u'UnauthAttributeSet', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    UnauthAttributeSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DigestAlgorithmIdentifier >-----#
    DigestAlgorithmIdentifier = SEQ(name=u'DigestAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _DigestAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    __DigestAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    __DigestAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _DigestAlgorithmIdentifier_algorithm._const_tab = __DigestAlgorithmIdentifier_algorithm_tab
    _DigestAlgorithmIdentifier_algorithm._const_tab_at = None
    _DigestAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _DigestAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    __DigestAlgorithmIdentifier_parameters_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    __DigestAlgorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _DigestAlgorithmIdentifier_parameters._const_tab = __DigestAlgorithmIdentifier_parameters_tab
    _DigestAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _DigestAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    DigestAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _DigestAlgorithmIdentifier_algorithm),
        (u'parameters', _DigestAlgorithmIdentifier_parameters),
        ])
    DigestAlgorithmIdentifier._ext = None
    
    #-----< DigestAlgorithmSet >-----#
    DigestAlgorithmSet = CLASS(name=u'DigestAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    DigestAlgorithmSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< SignatureAlgorithmIdentifier >-----#
    SignatureAlgorithmIdentifier = SEQ(name=u'SignatureAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _SignatureAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    __SignatureAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    __SignatureAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _SignatureAlgorithmIdentifier_algorithm._const_tab = __SignatureAlgorithmIdentifier_algorithm_tab
    _SignatureAlgorithmIdentifier_algorithm._const_tab_at = None
    _SignatureAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _SignatureAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __SignatureAlgorithmIdentifier_parameters_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    __SignatureAlgorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _SignatureAlgorithmIdentifier_parameters._const_tab = __SignatureAlgorithmIdentifier_parameters_tab
    _SignatureAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _SignatureAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    SignatureAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _SignatureAlgorithmIdentifier_algorithm),
        (u'parameters', _SignatureAlgorithmIdentifier_parameters),
        ])
    SignatureAlgorithmIdentifier._ext = None
    
    #-----< SignatureAlgorithmSet >-----#
    SignatureAlgorithmSet = CLASS(name=u'SignatureAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    SignatureAlgorithmSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< KeyEncryptionAlgorithmIdentifier >-----#
    KeyEncryptionAlgorithmIdentifier = SEQ(name=u'KeyEncryptionAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _KeyEncryptionAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-WRAP'), [u'id']))
    __KeyEncryptionAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_KEY-WRAP', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1 = INT(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2wrapParameter')))
    __KeyEncryptionAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6)), (u'Params', ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7)), (u'Params', ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]))])], rr=[], ev=None, er=[])
    _KeyEncryptionAlgorithmIdentifier_algorithm._const_tab = __KeyEncryptionAlgorithmIdentifier_algorithm_tab
    _KeyEncryptionAlgorithmIdentifier_algorithm._const_tab_at = None
    _KeyEncryptionAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _KeyEncryptionAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-WRAP'), [u'Params']), opt=True)
    _KeyEncryptionAlgorithmIdentifier_parameters._const_tab = __KeyEncryptionAlgorithmIdentifier_algorithm_tab
    _KeyEncryptionAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _KeyEncryptionAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    KeyEncryptionAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _KeyEncryptionAlgorithmIdentifier_algorithm),
        (u'parameters', _KeyEncryptionAlgorithmIdentifier_parameters),
        ])
    KeyEncryptionAlgorithmIdentifier._ext = None
    
    #-----< KeyEncryptionAlgorithmSet >-----#
    KeyEncryptionAlgorithmSet = CLASS(name=u'KeyEncryptionAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    _KeyEncryptionAlgorithmSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _KeyEncryptionAlgorithmSet_val_Params_1 = INT(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2wrapParameter')))
    KeyEncryptionAlgorithmSet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6)), (u'Params', _KeyEncryptionAlgorithmSet_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7)), (u'Params', _KeyEncryptionAlgorithmSet_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]))])], rr=[], ev=[], er=[])
    
    #-----< ContentEncryptionAlgorithmIdentifier >-----#
    ContentEncryptionAlgorithmIdentifier = SEQ(name=u'ContentEncryptionAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _ContentEncryptionAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION'), [u'id']))
    __ContentEncryptionAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_CONTENT-ENCRYPTION', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'IV')))
    ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2CBCParameter')))
    __CONTENT_ENCRYPTION_smimeCaps_val_Type = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    __ContentEncryptionAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 3, 7)), (u'Params', ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 3, 7))]))]), dict([(u'id', (1, 2, 840, 113549, 3, 2)), (u'Params', ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'Type', __CONTENT_ENCRYPTION_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 3, 2))]))])], rr=[], ev=None, er=[])
    _ContentEncryptionAlgorithmIdentifier_algorithm._const_tab = __ContentEncryptionAlgorithmIdentifier_algorithm_tab
    _ContentEncryptionAlgorithmIdentifier_algorithm._const_tab_at = None
    _ContentEncryptionAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _ContentEncryptionAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION'), [u'Params']), opt=True)
    _ContentEncryptionAlgorithmIdentifier_parameters._const_tab = __ContentEncryptionAlgorithmIdentifier_algorithm_tab
    _ContentEncryptionAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _ContentEncryptionAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    ContentEncryptionAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _ContentEncryptionAlgorithmIdentifier_algorithm),
        (u'parameters', _ContentEncryptionAlgorithmIdentifier_parameters),
        ])
    ContentEncryptionAlgorithmIdentifier._ext = None
    
    #-----< ContentEncryptionAlgorithmSet >-----#
    ContentEncryptionAlgorithmSet = CLASS(name=u'ContentEncryptionAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    _ContentEncryptionAlgorithmSet_val_Params_0 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'IV')))
    _ContentEncryptionAlgorithmSet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2CBCParameter')))
    ContentEncryptionAlgorithmSet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 3, 7)), (u'Params', _ContentEncryptionAlgorithmSet_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 3, 7))]))]), dict([(u'id', (1, 2, 840, 113549, 3, 2)), (u'Params', _ContentEncryptionAlgorithmSet_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'Type', __CONTENT_ENCRYPTION_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 3, 2))]))])], rr=[], ev=[], er=[])
    
    #-----< MessageAuthenticationCodeAlgorithm >-----#
    MessageAuthenticationCodeAlgorithm = SEQ(name=u'MessageAuthenticationCodeAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _MessageAuthenticationCodeAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'id']))
    __MessageAuthenticationCodeAlgorithm_algorithm_tab = CLASS(name='_tab_MAC-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    ___MessageAuthenticationCodeAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __MessageAuthenticationCodeAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', ___MessageAuthenticationCodeAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=None, er=[])
    _MessageAuthenticationCodeAlgorithm_algorithm._const_tab = __MessageAuthenticationCodeAlgorithm_algorithm_tab
    _MessageAuthenticationCodeAlgorithm_algorithm._const_tab_at = None
    _MessageAuthenticationCodeAlgorithm_algorithm._const_tab_id = u'id'
    _MessageAuthenticationCodeAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'Params']), opt=True)
    _MessageAuthenticationCodeAlgorithm_parameters._const_tab = __MessageAuthenticationCodeAlgorithm_algorithm_tab
    _MessageAuthenticationCodeAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _MessageAuthenticationCodeAlgorithm_parameters._const_tab_id = u'Params'
    MessageAuthenticationCodeAlgorithm._cont = ASN1Dict([
        (u'algorithm', _MessageAuthenticationCodeAlgorithm_algorithm),
        (u'parameters', _MessageAuthenticationCodeAlgorithm_parameters),
        ])
    MessageAuthenticationCodeAlgorithm._ext = None
    
    #-----< MessageAuthenticationCodeAlgorithmSet >-----#
    MessageAuthenticationCodeAlgorithmSet = CLASS(name=u'MessageAuthenticationCodeAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    _MessageAuthenticationCodeAlgorithmSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    MessageAuthenticationCodeAlgorithmSet._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _MessageAuthenticationCodeAlgorithmSet_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=[], er=[])
    
    #-----< KeyDerivationAlgorithmIdentifier >-----#
    KeyDerivationAlgorithmIdentifier = SEQ(name=u'KeyDerivationAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _KeyDerivationAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-DERIVATION'), [u'id']))
    __KeyDerivationAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_KEY-DERIVATION', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-DERIVATION')))
    ___KeyDerivationAlgorithmIdentifier_algorithm_tab_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-params')))
    __KeyDerivationAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 5, 12)), (u'Params', ___KeyDerivationAlgorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=None, er=[])
    _KeyDerivationAlgorithmIdentifier_algorithm._const_tab = __KeyDerivationAlgorithmIdentifier_algorithm_tab
    _KeyDerivationAlgorithmIdentifier_algorithm._const_tab_at = None
    _KeyDerivationAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _KeyDerivationAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-DERIVATION'), [u'Params']), opt=True)
    _KeyDerivationAlgorithmIdentifier_parameters._const_tab = __KeyDerivationAlgorithmIdentifier_algorithm_tab
    _KeyDerivationAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _KeyDerivationAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    KeyDerivationAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _KeyDerivationAlgorithmIdentifier_algorithm),
        (u'parameters', _KeyDerivationAlgorithmIdentifier_parameters),
        ])
    KeyDerivationAlgorithmIdentifier._ext = None
    
    #-----< RevocationInfoChoices >-----#
    RevocationInfoChoices = SET_OF(name=u'RevocationInfoChoices', mode=MODE_TYPE)
    _RevocationInfoChoices__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RevocationInfoChoice')))
    RevocationInfoChoices._cont = _RevocationInfoChoices__item_
    
    #-----< RevocationInfoChoice >-----#
    RevocationInfoChoice = CHOICE(name=u'RevocationInfoChoice', mode=MODE_TYPE)
    _RevocationInfoChoice_crl = SEQ(name=u'crl', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateList')))
    _RevocationInfoChoice_other = SEQ(name=u'other', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OtherRevocationInfoFormat')), group=0)
    RevocationInfoChoice._cont = ASN1Dict([
        (u'crl', _RevocationInfoChoice_crl),
        (u'other', _RevocationInfoChoice_other),
        ])
    RevocationInfoChoice._ext = [u'other']
    
    #-----< OTHER-REVOK-INFO >-----#
    OTHER_REVOK_INFO = CLASS(name=u'OTHER-REVOK-INFO', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< OtherRevocationInfoFormat >-----#
    OtherRevocationInfoFormat = SEQ(name=u'OtherRevocationInfoFormat', mode=MODE_TYPE)
    _OtherRevocationInfoFormat_otherRevInfoFormat = OID(name=u'otherRevInfoFormat', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-REVOK-INFO'), [u'id']))
    __OtherRevocationInfoFormat_otherRevInfoFormat_tab = CLASS(name='_tab_OTHER-REVOK-INFO', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-REVOK-INFO')))
    __OtherRevocationInfoFormat_otherRevInfoFormat_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherRevocationInfoFormat_otherRevInfoFormat._const_tab = __OtherRevocationInfoFormat_otherRevInfoFormat_tab
    _OtherRevocationInfoFormat_otherRevInfoFormat._const_tab_at = None
    _OtherRevocationInfoFormat_otherRevInfoFormat._const_tab_id = u'id'
    _OtherRevocationInfoFormat_otherRevInfo = OPEN(name=u'otherRevInfo', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-REVOK-INFO'), [u'Type']))
    __OtherRevocationInfoFormat_otherRevInfo_tab = CLASS(name='_tab_OTHER-REVOK-INFO', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-REVOK-INFO')))
    __OtherRevocationInfoFormat_otherRevInfo_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherRevocationInfoFormat_otherRevInfo._const_tab = __OtherRevocationInfoFormat_otherRevInfo_tab
    _OtherRevocationInfoFormat_otherRevInfo._const_tab_at = ('..', u'otherRevInfoFormat')
    _OtherRevocationInfoFormat_otherRevInfo._const_tab_id = u'Type'
    OtherRevocationInfoFormat._cont = ASN1Dict([
        (u'otherRevInfoFormat', _OtherRevocationInfoFormat_otherRevInfoFormat),
        (u'otherRevInfo', _OtherRevocationInfoFormat_otherRevInfo),
        ])
    OtherRevocationInfoFormat._ext = None
    
    #-----< SupportedOtherRevokInfo >-----#
    SupportedOtherRevokInfo = CLASS(name=u'SupportedOtherRevokInfo', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-REVOK-INFO')))
    SupportedOtherRevokInfo._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< CertificateChoices >-----#
    CertificateChoices = CHOICE(name=u'CertificateChoices', mode=MODE_TYPE)
    _CertificateChoices_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Certificate')))
    _CertificateChoices_extendedCertificate = SEQ(name=u'extendedCertificate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ExtendedCertificate')))
    _CertificateChoices_v1AttrCert = SEQ(name=u'v1AttrCert', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateVersion1-2009', 'AttributeCertificateV1')), group=0)
    _CertificateChoices_v2AttrCert = SEQ(name=u'v2AttrCert', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AttributeCertificateV2')), group=1)
    _CertificateChoices_other = SEQ(name=u'other', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OtherCertificateFormat')), group=2)
    CertificateChoices._cont = ASN1Dict([
        (u'certificate', _CertificateChoices_certificate),
        (u'extendedCertificate', _CertificateChoices_extendedCertificate),
        (u'v1AttrCert', _CertificateChoices_v1AttrCert),
        (u'v2AttrCert', _CertificateChoices_v2AttrCert),
        (u'other', _CertificateChoices_other),
        ])
    CertificateChoices._ext = [u'v1AttrCert', u'v2AttrCert', u'other']
    
    #-----< AttributeCertificateV2 >-----#
    AttributeCertificateV2 = SEQ(name=u'AttributeCertificateV2', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttributeCertificate')))
    
    #-----< OTHER-CERT-FMT >-----#
    OTHER_CERT_FMT = CLASS(name=u'OTHER-CERT-FMT', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< OtherCertificateFormat >-----#
    OtherCertificateFormat = SEQ(name=u'OtherCertificateFormat', mode=MODE_TYPE)
    _OtherCertificateFormat_otherCertFormat = OID(name=u'otherCertFormat', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-CERT-FMT'), [u'id']))
    __OtherCertificateFormat_otherCertFormat_tab = CLASS(name='_tab_OTHER-CERT-FMT', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-CERT-FMT')))
    __OtherCertificateFormat_otherCertFormat_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherCertificateFormat_otherCertFormat._const_tab = __OtherCertificateFormat_otherCertFormat_tab
    _OtherCertificateFormat_otherCertFormat._const_tab_at = None
    _OtherCertificateFormat_otherCertFormat._const_tab_id = u'id'
    _OtherCertificateFormat_otherCert = OPEN(name=u'otherCert', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-CERT-FMT'), [u'Type']))
    __OtherCertificateFormat_otherCert_tab = CLASS(name='_tab_OTHER-CERT-FMT', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-CERT-FMT')))
    __OtherCertificateFormat_otherCert_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherCertificateFormat_otherCert._const_tab = __OtherCertificateFormat_otherCert_tab
    _OtherCertificateFormat_otherCert._const_tab_at = ('..', u'otherCertFormat')
    _OtherCertificateFormat_otherCert._const_tab_id = u'Type'
    OtherCertificateFormat._cont = ASN1Dict([
        (u'otherCertFormat', _OtherCertificateFormat_otherCertFormat),
        (u'otherCert', _OtherCertificateFormat_otherCert),
        ])
    OtherCertificateFormat._ext = None
    
    #-----< SupportedCertFormats >-----#
    SupportedCertFormats = CLASS(name=u'SupportedCertFormats', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-CERT-FMT')))
    SupportedCertFormats._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< CertificateSet >-----#
    CertificateSet = SET_OF(name=u'CertificateSet', mode=MODE_TYPE)
    _CertificateSet__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CertificateChoices')))
    CertificateSet._cont = _CertificateSet__item_
    
    #-----< IssuerAndSerialNumber >-----#
    IssuerAndSerialNumber = SEQ(name=u'IssuerAndSerialNumber', mode=MODE_TYPE)
    _IssuerAndSerialNumber_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _IssuerAndSerialNumber_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    IssuerAndSerialNumber._cont = ASN1Dict([
        (u'issuer', _IssuerAndSerialNumber_issuer),
        (u'serialNumber', _IssuerAndSerialNumber_serialNumber),
        ])
    IssuerAndSerialNumber._ext = None
    
    #-----< CMSVersion >-----#
    CMSVersion = INT(name=u'CMSVersion', mode=MODE_TYPE)
    CMSVersion._cont = ASN1Dict([(u'v0', 0), (u'v1', 1), (u'v2', 2), (u'v3', 3), (u'v4', 4), (u'v5', 5)])
    
    #-----< UserKeyingMaterial >-----#
    UserKeyingMaterial = OCT_STR(name=u'UserKeyingMaterial', mode=MODE_TYPE)
    
    #-----< KEY-ATTRIBUTE >-----#
    KEY_ATTRIBUTE = CLASS(name=u'KEY-ATTRIBUTE', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< OtherKeyAttribute >-----#
    OtherKeyAttribute = SEQ(name=u'OtherKeyAttribute', mode=MODE_TYPE)
    _OtherKeyAttribute_keyAttrId = OID(name=u'keyAttrId', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'KEY-ATTRIBUTE'), [u'id']))
    __OtherKeyAttribute_keyAttrId_tab = CLASS(name='_tab_KEY-ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KEY-ATTRIBUTE')))
    __OtherKeyAttribute_keyAttrId_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherKeyAttribute_keyAttrId._const_tab = __OtherKeyAttribute_keyAttrId_tab
    _OtherKeyAttribute_keyAttrId._const_tab_at = None
    _OtherKeyAttribute_keyAttrId._const_tab_id = u'id'
    _OtherKeyAttribute_keyAttr = OPEN(name=u'keyAttr', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'KEY-ATTRIBUTE'), [u'Type']))
    __OtherKeyAttribute_keyAttr_tab = CLASS(name='_tab_KEY-ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KEY-ATTRIBUTE')))
    __OtherKeyAttribute_keyAttr_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherKeyAttribute_keyAttr._const_tab = __OtherKeyAttribute_keyAttr_tab
    _OtherKeyAttribute_keyAttr._const_tab_at = ('..', u'keyAttrId')
    _OtherKeyAttribute_keyAttr._const_tab_id = u'Type'
    OtherKeyAttribute._cont = ASN1Dict([
        (u'keyAttrId', _OtherKeyAttribute_keyAttrId),
        (u'keyAttr', _OtherKeyAttribute_keyAttr),
        ])
    OtherKeyAttribute._ext = None
    
    #-----< SupportedKeyAttributes >-----#
    SupportedKeyAttributes = CLASS(name=u'SupportedKeyAttributes', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KEY-ATTRIBUTE')))
    SupportedKeyAttributes._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< id-ct-contentInfo >-----#
    id_ct_contentInfo = OID(name=u'id-ct-contentInfo', mode=MODE_VALUE)
    id_ct_contentInfo._val = (1, 2, 840, 113549, 1, 9, 16, 1, 6)
    
    #-----< ct-Data >-----#
    ct_Data = CLASS(name=u'ct-Data', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_Data_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    ct_Data._val = dict([('Type', _ct_Data_val_Type), ('id', (1, 2, 840, 113549, 1, 7, 1))])
    
    #-----< id-data >-----#
    id_data = OID(name=u'id-data', mode=MODE_VALUE)
    id_data._val = (1, 2, 840, 113549, 1, 7, 1)
    
    #-----< ct-SignedData >-----#
    ct_SignedData = CLASS(name=u'ct-SignedData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_SignedData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedData')))
    ct_SignedData._val = dict([('Type', _ct_SignedData_val_Type), ('id', (1, 2, 840, 113549, 1, 7, 2))])
    
    #-----< id-signedData >-----#
    id_signedData = OID(name=u'id-signedData', mode=MODE_VALUE)
    id_signedData._val = (1, 2, 840, 113549, 1, 7, 2)
    
    #-----< ct-EnvelopedData >-----#
    ct_EnvelopedData = CLASS(name=u'ct-EnvelopedData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_EnvelopedData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EnvelopedData')))
    ct_EnvelopedData._val = dict([('Type', _ct_EnvelopedData_val_Type), ('id', (1, 2, 840, 113549, 1, 7, 3))])
    
    #-----< id-envelopedData >-----#
    id_envelopedData = OID(name=u'id-envelopedData', mode=MODE_VALUE)
    id_envelopedData._val = (1, 2, 840, 113549, 1, 7, 3)
    
    #-----< ct-DigestedData >-----#
    ct_DigestedData = CLASS(name=u'ct-DigestedData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_DigestedData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestedData')))
    ct_DigestedData._val = dict([('Type', _ct_DigestedData_val_Type), ('id', (1, 2, 840, 113549, 1, 7, 5))])
    
    #-----< id-digestedData >-----#
    id_digestedData = OID(name=u'id-digestedData', mode=MODE_VALUE)
    id_digestedData._val = (1, 2, 840, 113549, 1, 7, 5)
    
    #-----< ct-EncryptedData >-----#
    ct_EncryptedData = CLASS(name=u'ct-EncryptedData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_EncryptedData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedData')))
    ct_EncryptedData._val = dict([('Type', _ct_EncryptedData_val_Type), ('id', (1, 2, 840, 113549, 1, 7, 6))])
    
    #-----< id-encryptedData >-----#
    id_encryptedData = OID(name=u'id-encryptedData', mode=MODE_VALUE)
    id_encryptedData._val = (1, 2, 840, 113549, 1, 7, 6)
    
    #-----< ct-AuthenticatedData >-----#
    ct_AuthenticatedData = CLASS(name=u'ct-AuthenticatedData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_AuthenticatedData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthenticatedData')))
    ct_AuthenticatedData._val = dict([('Type', _ct_AuthenticatedData_val_Type), ('id', (1, 2, 840, 113549, 1, 9, 16, 1, 2))])
    
    #-----< id-ct-authData >-----#
    id_ct_authData = OID(name=u'id-ct-authData', mode=MODE_VALUE)
    id_ct_authData._val = (1, 2, 840, 113549, 1, 9, 16, 1, 2)
    
    #-----< MessageDigest >-----#
    MessageDigest = OCT_STR(name=u'MessageDigest', mode=MODE_TYPE)
    
    #-----< SigningTime >-----#
    SigningTime = CHOICE(name=u'SigningTime', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Time')))
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalTime = TIME_GEN(name=u'generalTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalTime', _Time_generalTime),
        ])
    Time._ext = None
    
    #-----< Countersignature >-----#
    Countersignature = SEQ(name=u'Countersignature', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignerInfo')))
    
    #-----< aa-contentType >-----#
    aa_contentType = CLASS(name=u'aa-contentType', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_contentType_val_Type = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentType')))
    aa_contentType._val = dict([(u'Type', _aa_contentType_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 3))])
    
    #-----< id-contentType >-----#
    id_contentType = OID(name=u'id-contentType', mode=MODE_VALUE)
    id_contentType._val = (1, 2, 840, 113549, 1, 9, 3)
    
    #-----< aa-messageDigest >-----#
    aa_messageDigest = CLASS(name=u'aa-messageDigest', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_messageDigest_val_Type = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageDigest')))
    aa_messageDigest._val = dict([(u'Type', _aa_messageDigest_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 4))])
    
    #-----< id-messageDigest >-----#
    id_messageDigest = OID(name=u'id-messageDigest', mode=MODE_VALUE)
    id_messageDigest._val = (1, 2, 840, 113549, 1, 9, 4)
    
    #-----< aa-signingTime >-----#
    aa_signingTime = CLASS(name=u'aa-signingTime', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_signingTime_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SigningTime')))
    aa_signingTime._val = dict([(u'Type', _aa_signingTime_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 5))])
    
    #-----< id-signingTime >-----#
    id_signingTime = OID(name=u'id-signingTime', mode=MODE_VALUE)
    id_signingTime._val = (1, 2, 840, 113549, 1, 9, 5)
    
    #-----< aa-countersignature >-----#
    aa_countersignature = CLASS(name=u'aa-countersignature', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_countersignature_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Countersignature')))
    aa_countersignature._val = dict([(u'Type', _aa_countersignature_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 6))])
    
    #-----< id-countersignature >-----#
    id_countersignature = OID(name=u'id-countersignature', mode=MODE_VALUE)
    id_countersignature._val = (1, 2, 840, 113549, 1, 9, 6)
    
    #-----< ExtendedCertificateOrCertificate >-----#
    ExtendedCertificateOrCertificate = CHOICE(name=u'ExtendedCertificateOrCertificate', mode=MODE_TYPE)
    _ExtendedCertificateOrCertificate_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Certificate')))
    _ExtendedCertificateOrCertificate_extendedCertificate = SEQ(name=u'extendedCertificate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ExtendedCertificate')))
    ExtendedCertificateOrCertificate._cont = ASN1Dict([
        (u'certificate', _ExtendedCertificateOrCertificate_certificate),
        (u'extendedCertificate', _ExtendedCertificateOrCertificate_extendedCertificate),
        ])
    ExtendedCertificateOrCertificate._ext = None
    
    #-----< ExtendedCertificate >-----#
    ExtendedCertificate = SEQ(name=u'ExtendedCertificate', mode=MODE_TYPE)
    _ExtendedCertificate_extendedCertificateInfo = SEQ(name=u'extendedCertificateInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ExtendedCertificateInfo')))
    _ExtendedCertificate_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignatureAlgorithmIdentifier')))
    _ExtendedCertificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Signature')))
    ExtendedCertificate._cont = ASN1Dict([
        (u'extendedCertificateInfo', _ExtendedCertificate_extendedCertificateInfo),
        (u'signatureAlgorithm', _ExtendedCertificate_signatureAlgorithm),
        (u'signature', _ExtendedCertificate_signature),
        ])
    ExtendedCertificate._ext = None
    
    #-----< ExtendedCertificateInfo >-----#
    ExtendedCertificateInfo = SEQ(name=u'ExtendedCertificateInfo', mode=MODE_TYPE)
    _ExtendedCertificateInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _ExtendedCertificateInfo_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Certificate')))
    _ExtendedCertificateInfo_attributes = SET_OF(name=u'attributes', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'UnauthAttributes')))
    ExtendedCertificateInfo._cont = ASN1Dict([
        (u'version', _ExtendedCertificateInfo_version),
        (u'certificate', _ExtendedCertificateInfo_certificate),
        (u'attributes', _ExtendedCertificateInfo_attributes),
        ])
    ExtendedCertificateInfo._ext = None
    
    #-----< Signature >-----#
    Signature = BIT_STR(name=u'Signature', mode=MODE_TYPE)
    
    #-----< Attribute >-----#
    Attribute = SEQ(name=u'Attribute', mode=MODE_TYPE, param=True)
    
    #-----< Attributes >-----#
    Attributes = SET_OF(name=u'Attributes', mode=MODE_TYPE, param=True)
    
    _all_ = [
        CONTENT_TYPE,
        ContentType,
        __ContentInfo_contentType_tab,
        ___ContentInfo_contentType_tab_val_Type_0,
        ___ContentInfo_contentType_tab_val_Type_1,
        ___ContentInfo_contentType_tab_val_Type_2,
        ___ContentInfo_contentType_tab_val_Type_3,
        ___ContentInfo_contentType_tab_val_Type_4,
        ___ContentInfo_contentType_tab_val_Type_5,
        _ContentInfo_contentType,
        _ContentInfo_content,
        ContentInfo,
        ContentSet,
        _ContentSet_val_Type_0,
        _ContentSet_val_Type_1,
        _ContentSet_val_Type_2,
        _ContentSet_val_Type_3,
        _ContentSet_val_Type_4,
        _ContentSet_val_Type_5,
        _SignedData_version,
        __SignedData_digestAlgorithms__item_,
        _SignedData_digestAlgorithms,
        _SignedData_encapContentInfo,
        _SignedData_certificates,
        _SignedData_crls,
        _SignedData_signerInfos,
        SignedData,
        _SignerInfos__item_,
        SignerInfos,
        __EncapsulatedContentInfo_eContentType_tab,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_0,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_1,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_2,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_3,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_4,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_5,
        _EncapsulatedContentInfo_eContentType,
        __EncapsulatedContentInfo_eContent_contain,
        _EncapsulatedContentInfo_eContent,
        EncapsulatedContentInfo,
        _SignerInfo_version,
        _SignerInfo_sid,
        _SignerInfo_digestAlgorithm,
        _SignerInfo_signedAttrs,
        _SignerInfo_signatureAlgorithm,
        _SignerInfo_signature,
        ____SignerInfo_unsignedAttrs__item__attrType_tab,
        _____SignerInfo_unsignedAttrs__item__attrType_tab_val_Type_0,
        ___SignerInfo_unsignedAttrs__item__attrType,
        ____SignerInfo_unsignedAttrs__item__attrValues__item_,
        ___SignerInfo_unsignedAttrs__item__attrValues,
        __SignerInfo_unsignedAttrs__item_,
        _SignerInfo_unsignedAttrs,
        SignerInfo,
        ___SignedAttributes__item__attrType_tab,
        ____SignedAttributes__item__attrType_tab_val_Type_0,
        ____SignedAttributes__item__attrType_tab_val_Type_1,
        ____SignedAttributes__item__attrType_tab_val_Type_2,
        __SignedAttributes__item__attrType,
        ___SignedAttributes__item__attrValues__item_,
        __SignedAttributes__item__attrValues,
        _SignedAttributes__item_,
        SignedAttributes,
        _SignerIdentifier_issuerAndSerialNumber,
        _SignerIdentifier_subjectKeyIdentifier,
        SignerIdentifier,
        SignedAttributesSet,
        _SignedAttributesSet_val_Type_0,
        _SignedAttributesSet_val_Type_1,
        _SignedAttributesSet_val_Type_2,
        UnsignedAttributes,
        _UnsignedAttributes_val_Type_0,
        SignatureValue,
        _EnvelopedData_version,
        _EnvelopedData_originatorInfo,
        _EnvelopedData_recipientInfos,
        _EnvelopedData_encryptedContentInfo,
        ____EnvelopedData_unprotectedAttrs__item__attrType_tab,
        ___EnvelopedData_unprotectedAttrs__item__attrType,
        _____EnvelopedData_unprotectedAttrs__item__attrValues__item__tab,
        ____EnvelopedData_unprotectedAttrs__item__attrValues__item_,
        ___EnvelopedData_unprotectedAttrs__item__attrValues,
        __EnvelopedData_unprotectedAttrs__item_,
        _EnvelopedData_unprotectedAttrs,
        EnvelopedData,
        _OriginatorInfo_certs,
        _OriginatorInfo_crls,
        OriginatorInfo,
        _RecipientInfos__item_,
        RecipientInfos,
        __EncryptedContentInfo_contentType_tab,
        ___EncryptedContentInfo_contentType_tab_val_Type_0,
        ___EncryptedContentInfo_contentType_tab_val_Type_1,
        ___EncryptedContentInfo_contentType_tab_val_Type_2,
        ___EncryptedContentInfo_contentType_tab_val_Type_3,
        ___EncryptedContentInfo_contentType_tab_val_Type_4,
        ___EncryptedContentInfo_contentType_tab_val_Type_5,
        _EncryptedContentInfo_contentType,
        _EncryptedContentInfo_contentEncryptionAlgorithm,
        _EncryptedContentInfo_encryptedContent,
        EncryptedContentInfo,
        UnprotectedAttributes,
        _RecipientInfo_ktri,
        _RecipientInfo_kari,
        _RecipientInfo_kekri,
        _RecipientInfo_pwri,
        _RecipientInfo_ori,
        RecipientInfo,
        EncryptedKey,
        _KeyTransRecipientInfo_version,
        _KeyTransRecipientInfo_rid,
        ___KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab,
        ____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0,
        __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0,
        __KEY_TRANSPORT_PublicKeySet_val_Params_0,
        __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm,
        __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters,
        _KeyTransRecipientInfo_keyEncryptionAlgorithm,
        _KeyTransRecipientInfo_encryptedKey,
        KeyTransRecipientInfo,
        KeyTransportAlgorithmSet,
        _KeyTransportAlgorithmSet_val_Params_0,
        _RecipientIdentifier_issuerAndSerialNumber,
        _RecipientIdentifier_subjectKeyIdentifier,
        RecipientIdentifier,
        _KeyAgreeRecipientInfo_version,
        _KeyAgreeRecipientInfo_originator,
        _KeyAgreeRecipientInfo_ukm,
        ___KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab,
        ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0,
        __KEY_AGREE_PublicKeySet_val_KeyValue_0,
        __KEY_AGREE_PublicKeySet_val_Params_0,
        __KEY_AGREE_smimeCaps_val_Type,
        ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_1,
        __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm,
        __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters,
        _KeyAgreeRecipientInfo_keyEncryptionAlgorithm,
        _KeyAgreeRecipientInfo_recipientEncryptedKeys,
        KeyAgreeRecipientInfo,
        KeyAgreementAlgorithmSet,
        _KeyAgreementAlgorithmSet_val_Params_0,
        _KeyAgreementAlgorithmSet_val_Params_1,
        _OriginatorIdentifierOrKey_issuerAndSerialNumber,
        _OriginatorIdentifierOrKey_subjectKeyIdentifier,
        _OriginatorIdentifierOrKey_originatorKey,
        OriginatorIdentifierOrKey,
        ___OriginatorPublicKey_algorithm_algorithm_tab,
        ____OriginatorPublicKey_algorithm_algorithm_tab_val_KeyValue_0,
        ____OriginatorPublicKey_algorithm_algorithm_tab_val_Params_0,
        __OriginatorPublicKey_algorithm_algorithm,
        __OriginatorPublicKey_algorithm_parameters,
        _OriginatorPublicKey_algorithm,
        _OriginatorPublicKey_publicKey,
        OriginatorPublicKey,
        OriginatorKeySet,
        _OriginatorKeySet_val_KeyValue_0,
        _OriginatorKeySet_val_Params_0,
        _RecipientEncryptedKeys__item_,
        RecipientEncryptedKeys,
        _RecipientEncryptedKey_rid,
        _RecipientEncryptedKey_encryptedKey,
        RecipientEncryptedKey,
        _KeyAgreeRecipientIdentifier_issuerAndSerialNumber,
        _KeyAgreeRecipientIdentifier_rKeyId,
        KeyAgreeRecipientIdentifier,
        _RecipientKeyIdentifier_subjectKeyIdentifier,
        _RecipientKeyIdentifier_date,
        _RecipientKeyIdentifier_other,
        RecipientKeyIdentifier,
        SubjectKeyIdentifier,
        _KEKRecipientInfo_version,
        _KEKRecipientInfo_kekid,
        _KEKRecipientInfo_keyEncryptionAlgorithm,
        _KEKRecipientInfo_encryptedKey,
        KEKRecipientInfo,
        _KEKIdentifier_keyIdentifier,
        _KEKIdentifier_date,
        _KEKIdentifier_other,
        KEKIdentifier,
        _PasswordRecipientInfo_version,
        _PasswordRecipientInfo_keyDerivationAlgorithm,
        _PasswordRecipientInfo_keyEncryptionAlgorithm,
        _PasswordRecipientInfo_encryptedKey,
        PasswordRecipientInfo,
        OTHER_RECIPIENT,
        __OtherRecipientInfo_oriType_tab,
        _OtherRecipientInfo_oriType,
        __OtherRecipientInfo_oriValue_tab,
        _OtherRecipientInfo_oriValue,
        OtherRecipientInfo,
        SupportedOtherRecipInfo,
        _DigestedData_version,
        _DigestedData_digestAlgorithm,
        _DigestedData_encapContentInfo,
        _DigestedData_digest,
        DigestedData,
        Digest,
        _EncryptedData_version,
        _EncryptedData_encryptedContentInfo,
        ____EncryptedData_unprotectedAttrs__item__attrType_tab,
        ___EncryptedData_unprotectedAttrs__item__attrType,
        _____EncryptedData_unprotectedAttrs__item__attrValues__item__tab,
        ____EncryptedData_unprotectedAttrs__item__attrValues__item_,
        ___EncryptedData_unprotectedAttrs__item__attrValues,
        __EncryptedData_unprotectedAttrs__item_,
        _EncryptedData_unprotectedAttrs,
        EncryptedData,
        _AuthenticatedData_version,
        _AuthenticatedData_originatorInfo,
        _AuthenticatedData_recipientInfos,
        _AuthenticatedData_macAlgorithm,
        _AuthenticatedData_digestAlgorithm,
        _AuthenticatedData_encapContentInfo,
        _AuthenticatedData_authAttrs,
        _AuthenticatedData_mac,
        _AuthenticatedData_unauthAttrs,
        AuthenticatedData,
        ___AuthAttributes__item__attrType_tab,
        ____AuthAttributes__item__attrType_tab_val_Type_0,
        ____AuthAttributes__item__attrType_tab_val_Type_1,
        ____AuthAttributes__item__attrType_tab_val_Type_2,
        __AuthAttributes__item__attrType,
        ___AuthAttributes__item__attrValues__item_,
        __AuthAttributes__item__attrValues,
        _AuthAttributes__item_,
        AuthAttributes,
        AuthAttributeSet,
        _AuthAttributeSet_val_Type_0,
        _AuthAttributeSet_val_Type_1,
        _AuthAttributeSet_val_Type_2,
        MessageAuthenticationCode,
        ___UnauthAttributes__item__attrType_tab,
        __UnauthAttributes__item__attrType,
        ____UnauthAttributes__item__attrValues__item__tab,
        ___UnauthAttributes__item__attrValues__item_,
        __UnauthAttributes__item__attrValues,
        _UnauthAttributes__item_,
        UnauthAttributes,
        UnauthAttributeSet,
        __DigestAlgorithmIdentifier_algorithm_tab,
        _DigestAlgorithmIdentifier_algorithm,
        __DigestAlgorithmIdentifier_parameters_tab,
        _DigestAlgorithmIdentifier_parameters,
        DigestAlgorithmIdentifier,
        DigestAlgorithmSet,
        __SignatureAlgorithmIdentifier_algorithm_tab,
        _SignatureAlgorithmIdentifier_algorithm,
        __SignatureAlgorithmIdentifier_parameters_tab,
        _SignatureAlgorithmIdentifier_parameters,
        SignatureAlgorithmIdentifier,
        SignatureAlgorithmSet,
        __KeyEncryptionAlgorithmIdentifier_algorithm_tab,
        ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0,
        ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1,
        _KeyEncryptionAlgorithmIdentifier_algorithm,
        _KeyEncryptionAlgorithmIdentifier_parameters,
        KeyEncryptionAlgorithmIdentifier,
        KeyEncryptionAlgorithmSet,
        _KeyEncryptionAlgorithmSet_val_Params_0,
        _KeyEncryptionAlgorithmSet_val_Params_1,
        __ContentEncryptionAlgorithmIdentifier_algorithm_tab,
        ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0,
        ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1,
        __CONTENT_ENCRYPTION_smimeCaps_val_Type,
        _ContentEncryptionAlgorithmIdentifier_algorithm,
        _ContentEncryptionAlgorithmIdentifier_parameters,
        ContentEncryptionAlgorithmIdentifier,
        ContentEncryptionAlgorithmSet,
        _ContentEncryptionAlgorithmSet_val_Params_0,
        _ContentEncryptionAlgorithmSet_val_Params_1,
        __MessageAuthenticationCodeAlgorithm_algorithm_tab,
        ___MessageAuthenticationCodeAlgorithm_algorithm_tab_val_Params_0,
        _MessageAuthenticationCodeAlgorithm_algorithm,
        _MessageAuthenticationCodeAlgorithm_parameters,
        MessageAuthenticationCodeAlgorithm,
        MessageAuthenticationCodeAlgorithmSet,
        _MessageAuthenticationCodeAlgorithmSet_val_Params_0,
        __KeyDerivationAlgorithmIdentifier_algorithm_tab,
        ___KeyDerivationAlgorithmIdentifier_algorithm_tab_val_Params_0,
        _KeyDerivationAlgorithmIdentifier_algorithm,
        _KeyDerivationAlgorithmIdentifier_parameters,
        KeyDerivationAlgorithmIdentifier,
        _RevocationInfoChoices__item_,
        RevocationInfoChoices,
        _RevocationInfoChoice_crl,
        _RevocationInfoChoice_other,
        RevocationInfoChoice,
        OTHER_REVOK_INFO,
        __OtherRevocationInfoFormat_otherRevInfoFormat_tab,
        _OtherRevocationInfoFormat_otherRevInfoFormat,
        __OtherRevocationInfoFormat_otherRevInfo_tab,
        _OtherRevocationInfoFormat_otherRevInfo,
        OtherRevocationInfoFormat,
        SupportedOtherRevokInfo,
        _CertificateChoices_certificate,
        _CertificateChoices_extendedCertificate,
        _CertificateChoices_v1AttrCert,
        _CertificateChoices_v2AttrCert,
        _CertificateChoices_other,
        CertificateChoices,
        AttributeCertificateV2,
        OTHER_CERT_FMT,
        __OtherCertificateFormat_otherCertFormat_tab,
        _OtherCertificateFormat_otherCertFormat,
        __OtherCertificateFormat_otherCert_tab,
        _OtherCertificateFormat_otherCert,
        OtherCertificateFormat,
        SupportedCertFormats,
        _CertificateSet__item_,
        CertificateSet,
        _IssuerAndSerialNumber_issuer,
        _IssuerAndSerialNumber_serialNumber,
        IssuerAndSerialNumber,
        CMSVersion,
        UserKeyingMaterial,
        KEY_ATTRIBUTE,
        __OtherKeyAttribute_keyAttrId_tab,
        _OtherKeyAttribute_keyAttrId,
        __OtherKeyAttribute_keyAttr_tab,
        _OtherKeyAttribute_keyAttr,
        OtherKeyAttribute,
        SupportedKeyAttributes,
        id_ct_contentInfo,
        ct_Data,
        _ct_Data_val_Type,
        id_data,
        ct_SignedData,
        _ct_SignedData_val_Type,
        id_signedData,
        ct_EnvelopedData,
        _ct_EnvelopedData_val_Type,
        id_envelopedData,
        ct_DigestedData,
        _ct_DigestedData_val_Type,
        id_digestedData,
        ct_EncryptedData,
        _ct_EncryptedData_val_Type,
        id_encryptedData,
        ct_AuthenticatedData,
        _ct_AuthenticatedData_val_Type,
        id_ct_authData,
        MessageDigest,
        SigningTime,
        _Time_utcTime,
        _Time_generalTime,
        Time,
        Countersignature,
        aa_contentType,
        _aa_contentType_val_Type,
        id_contentType,
        aa_messageDigest,
        _aa_messageDigest_val_Type,
        id_messageDigest,
        aa_signingTime,
        _aa_signingTime_val_Type,
        id_signingTime,
        aa_countersignature,
        _aa_countersignature_val_Type,
        id_countersignature,
        _ExtendedCertificateOrCertificate_certificate,
        _ExtendedCertificateOrCertificate_extendedCertificate,
        ExtendedCertificateOrCertificate,
        _ExtendedCertificate_extendedCertificateInfo,
        _ExtendedCertificate_signatureAlgorithm,
        _ExtendedCertificate_signature,
        ExtendedCertificate,
        _ExtendedCertificateInfo_version,
        _ExtendedCertificateInfo_certificate,
        _ExtendedCertificateInfo_attributes,
        ExtendedCertificateInfo,
        Signature,
    ]

class CryptographicMessageSyntaxAlgorithms_2009:

    _name_  = u'CryptographicMessageSyntaxAlgorithms-2009'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 37]
    
    _obj_ = [
        u'MessageDigestAlgs',
        u'SignatureAlgs',
        u'KeyAgreementAlgs',
        u'KeyAgreePublicKeys',
        u'KeyTransportAlgs',
        u'KeyWrapAlgs',
        u'KeyDerivationAlgs',
        u'ContentEncryptionAlgs',
        u'MessageAuthAlgs',
        u'SMimeCaps',
        u'id-alg-ESDH',
        u'id-alg-SSDH',
        u'id-alg-CMS3DESwrap',
        u'id-alg-CMSRC2wrap',
        u'des-ede3-cbc',
        u'rc2-cbc',
        u'hMAC-SHA1',
        u'id-PBKDF2',
        u'KeyWrapAlgorithm',
        u'RC2wrapParameter',
        u'RC2ParameterVersion',
        u'CBCParameter',
        u'IV',
        u'RC2CBCParameter',
        u'maca-hMAC-SHA1',
        u'PBKDF2-PRFsAlgorithmIdentifier',
        u'alg-hMAC-SHA1',
        u'PBKDF2-PRFs',
        u'PBKDF2-SaltSources',
        u'PBKDF2-SaltSourcesAlgorithmIdentifier',
        u'defaultPBKDF2',
        u'PBKDF2-params',
        u'kaa-esdh',
        u'kaa-ssdh',
        u'dh-public-number',
        u'pk-originator-dh',
        u'kwa-3DESWrap',
        u'kwa-RC2Wrap',
        u'kda-PBKDF2',
        u'cea-3DES-cbc',
        u'cea-RC2-cbc',
        u'kt-rsa',
        u'cap-3DESwrap',
        ]
    _type_ = [
        u'KeyWrapAlgorithm',
        u'RC2wrapParameter',
        u'RC2ParameterVersion',
        u'CBCParameter',
        u'IV',
        u'RC2CBCParameter',
        u'PBKDF2-PRFsAlgorithmIdentifier',
        u'PBKDF2-SaltSourcesAlgorithmIdentifier',
        u'PBKDF2-params',
        ]
    _set_ = [
        u'MessageDigestAlgs',
        u'SignatureAlgs',
        u'KeyAgreementAlgs',
        u'KeyAgreePublicKeys',
        u'KeyTransportAlgs',
        u'KeyWrapAlgs',
        u'KeyDerivationAlgs',
        u'ContentEncryptionAlgs',
        u'MessageAuthAlgs',
        u'SMimeCaps',
        u'PBKDF2-PRFs',
        u'PBKDF2-SaltSources',
        ]
    _val_ = [
        u'id-alg-ESDH',
        u'id-alg-SSDH',
        u'id-alg-CMS3DESwrap',
        u'id-alg-CMSRC2wrap',
        u'des-ede3-cbc',
        u'rc2-cbc',
        u'hMAC-SHA1',
        u'id-PBKDF2',
        u'maca-hMAC-SHA1',
        u'alg-hMAC-SHA1',
        u'defaultPBKDF2',
        u'kaa-esdh',
        u'kaa-ssdh',
        u'dh-public-number',
        u'pk-originator-dh',
        u'kwa-3DESWrap',
        u'kwa-RC2Wrap',
        u'kda-PBKDF2',
        u'cea-3DES-cbc',
        u'cea-RC2-cbc',
        u'kt-rsa',
        u'cap-3DESwrap',
        ]
    _class_ = [
        u'MessageDigestAlgs',
        u'SignatureAlgs',
        u'KeyAgreementAlgs',
        u'KeyAgreePublicKeys',
        u'KeyTransportAlgs',
        u'KeyWrapAlgs',
        u'KeyDerivationAlgs',
        u'ContentEncryptionAlgs',
        u'MessageAuthAlgs',
        u'SMimeCaps',
        u'maca-hMAC-SHA1',
        u'alg-hMAC-SHA1',
        u'PBKDF2-PRFs',
        u'PBKDF2-SaltSources',
        u'kaa-esdh',
        u'kaa-ssdh',
        u'pk-originator-dh',
        u'kwa-3DESWrap',
        u'kwa-RC2Wrap',
        u'kda-PBKDF2',
        u'cea-3DES-cbc',
        u'cea-RC2-cbc',
        u'kt-rsa',
        u'cap-3DESwrap',
        ]
    _param_ = [
        ]
    
    #-----< MessageDigestAlgs >-----#
    MessageDigestAlgs = CLASS(name=u'MessageDigestAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    MessageDigestAlgs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< SignatureAlgs >-----#
    SignatureAlgs = CLASS(name=u'SignatureAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    SignatureAlgs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< KeyAgreementAlgs >-----#
    KeyAgreementAlgs = CLASS(name=u'KeyAgreementAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-AGREE')))
    _KeyAgreementAlgs_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    __KEY_AGREE_PublicKeySet_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    __KEY_AGREE_PublicKeySet_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    __KEY_AGREE_smimeCaps_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _KeyAgreementAlgs_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    KeyAgreementAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5)), (u'Params', _KeyAgreementAlgs_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', __KEY_AGREE_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_AGREE_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', __KEY_AGREE_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10)), (u'Params', _KeyAgreementAlgs_val_Params_1), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', __KEY_AGREE_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_AGREE_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', __KEY_AGREE_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]))])], rr=[], ev=[], er=[])
    
    #-----< KeyAgreePublicKeys >-----#
    KeyAgreePublicKeys = CLASS(name=u'KeyAgreePublicKeys', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _KeyAgreePublicKeys_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _KeyAgreePublicKeys_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    KeyAgreePublicKeys._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _KeyAgreePublicKeys_val_KeyValue_0), (u'Params', _KeyAgreePublicKeys_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=[], er=[])
    
    #-----< KeyTransportAlgs >-----#
    KeyTransportAlgs = CLASS(name=u'KeyTransportAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    _KeyTransportAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __KEY_TRANSPORT_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    KeyTransportAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'Params', _KeyTransportAlgs_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]))])], rr=[], ev=[], er=[])
    
    #-----< KeyWrapAlgs >-----#
    KeyWrapAlgs = CLASS(name=u'KeyWrapAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    _KeyWrapAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _KeyWrapAlgs_val_Params_1 = INT(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2wrapParameter')))
    KeyWrapAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6)), (u'Params', _KeyWrapAlgs_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7)), (u'Params', _KeyWrapAlgs_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]))])], rr=[], ev=[], er=[])
    
    #-----< KeyDerivationAlgs >-----#
    KeyDerivationAlgs = CLASS(name=u'KeyDerivationAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-DERIVATION')))
    _KeyDerivationAlgs_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-params')))
    KeyDerivationAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 5, 12)), (u'Params', _KeyDerivationAlgs_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=[], er=[])
    
    #-----< ContentEncryptionAlgs >-----#
    ContentEncryptionAlgs = CLASS(name=u'ContentEncryptionAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    _ContentEncryptionAlgs_val_Params_0 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'IV')))
    _ContentEncryptionAlgs_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2CBCParameter')))
    __CONTENT_ENCRYPTION_smimeCaps_val_Type = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    ContentEncryptionAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 3, 7)), (u'Params', _ContentEncryptionAlgs_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 3, 7))]))]), dict([(u'id', (1, 2, 840, 113549, 3, 2)), (u'Params', _ContentEncryptionAlgs_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'Type', __CONTENT_ENCRYPTION_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 3, 2))]))])], rr=[], ev=[], er=[])
    
    #-----< MessageAuthAlgs >-----#
    MessageAuthAlgs = CLASS(name=u'MessageAuthAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    _MessageAuthAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    MessageAuthAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _MessageAuthAlgs_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=[], er=[])
    
    #-----< SMimeCaps >-----#
    SMimeCaps = CLASS(name=u'SMimeCaps', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _SMimeCaps_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _SMimeCaps_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _SMimeCaps_val_Type_6 = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    SMimeCaps._val = ASN1Set(rv=[dict([(u'Type', _SMimeCaps_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]), dict([(u'Type', _SMimeCaps_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]), dict([(u'id', (1, 2, 840, 113549, 3, 7))]), dict([(u'Type', _SMimeCaps_val_Type_6), (u'id', (1, 2, 840, 113549, 3, 2))]), dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))])], rr=[], ev=[], er=[])
    
    #-----< id-alg-ESDH >-----#
    id_alg_ESDH = OID(name=u'id-alg-ESDH', mode=MODE_VALUE)
    id_alg_ESDH._val = (1, 2, 840, 113549, 1, 9, 16, 3, 5)
    
    #-----< id-alg-SSDH >-----#
    id_alg_SSDH = OID(name=u'id-alg-SSDH', mode=MODE_VALUE)
    id_alg_SSDH._val = (1, 2, 840, 113549, 1, 9, 16, 3, 10)
    
    #-----< id-alg-CMS3DESwrap >-----#
    id_alg_CMS3DESwrap = OID(name=u'id-alg-CMS3DESwrap', mode=MODE_VALUE)
    id_alg_CMS3DESwrap._val = (1, 2, 840, 113549, 1, 9, 16, 3, 6)
    
    #-----< id-alg-CMSRC2wrap >-----#
    id_alg_CMSRC2wrap = OID(name=u'id-alg-CMSRC2wrap', mode=MODE_VALUE)
    id_alg_CMSRC2wrap._val = (1, 2, 840, 113549, 1, 9, 16, 3, 7)
    
    #-----< des-ede3-cbc >-----#
    des_ede3_cbc = OID(name=u'des-ede3-cbc', mode=MODE_VALUE)
    des_ede3_cbc._val = (1, 2, 840, 113549, 3, 7)
    
    #-----< rc2-cbc >-----#
    rc2_cbc = OID(name=u'rc2-cbc', mode=MODE_VALUE)
    rc2_cbc._val = (1, 2, 840, 113549, 3, 2)
    
    #-----< hMAC-SHA1 >-----#
    hMAC_SHA1 = OID(name=u'hMAC-SHA1', mode=MODE_VALUE)
    hMAC_SHA1._val = (1, 3, 6, 1, 5, 5, 8, 1, 2)
    
    #-----< id-PBKDF2 >-----#
    id_PBKDF2 = OID(name=u'id-PBKDF2', mode=MODE_VALUE)
    id_PBKDF2._val = (1, 2, 840, 113549, 1, 5, 12)
    
    #-----< KeyWrapAlgorithm >-----#
    KeyWrapAlgorithm = SEQ(name=u'KeyWrapAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _KeyWrapAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-WRAP'), [u'id']))
    __KeyWrapAlgorithm_algorithm_tab = CLASS(name='_tab_KEY-WRAP', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    ___KeyWrapAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___KeyWrapAlgorithm_algorithm_tab_val_Params_1 = INT(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2wrapParameter')))
    __KeyWrapAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6)), (u'Params', ___KeyWrapAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7)), (u'Params', ___KeyWrapAlgorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]))])], rr=[], ev=None, er=[])
    _KeyWrapAlgorithm_algorithm._const_tab = __KeyWrapAlgorithm_algorithm_tab
    _KeyWrapAlgorithm_algorithm._const_tab_at = None
    _KeyWrapAlgorithm_algorithm._const_tab_id = u'id'
    _KeyWrapAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-WRAP'), [u'Params']), opt=True)
    _KeyWrapAlgorithm_parameters._const_tab = __KeyWrapAlgorithm_algorithm_tab
    _KeyWrapAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _KeyWrapAlgorithm_parameters._const_tab_id = u'Params'
    KeyWrapAlgorithm._cont = ASN1Dict([
        (u'algorithm', _KeyWrapAlgorithm_algorithm),
        (u'parameters', _KeyWrapAlgorithm_parameters),
        ])
    KeyWrapAlgorithm._ext = None
    
    #-----< RC2wrapParameter >-----#
    RC2wrapParameter = INT(name=u'RC2wrapParameter', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2ParameterVersion')))
    
    #-----< RC2ParameterVersion >-----#
    RC2ParameterVersion = INT(name=u'RC2ParameterVersion', mode=MODE_TYPE)
    
    #-----< CBCParameter >-----#
    CBCParameter = OCT_STR(name=u'CBCParameter', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'IV')))
    
    #-----< IV >-----#
    IV = OCT_STR(name=u'IV', mode=MODE_TYPE)
    
    #-----< RC2CBCParameter >-----#
    RC2CBCParameter = SEQ(name=u'RC2CBCParameter', mode=MODE_TYPE)
    _RC2CBCParameter_rc2ParameterVersion = INT(name=u'rc2ParameterVersion', mode=MODE_TYPE)
    _RC2CBCParameter_rc2ParameterVersion._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _RC2CBCParameter_iv = OCT_STR(name=u'iv', mode=MODE_TYPE)
    RC2CBCParameter._cont = ASN1Dict([
        (u'rc2ParameterVersion', _RC2CBCParameter_rc2ParameterVersion),
        (u'iv', _RC2CBCParameter_iv),
        ])
    RC2CBCParameter._ext = None
    
    #-----< maca-hMAC-SHA1 >-----#
    maca_hMAC_SHA1 = CLASS(name=u'maca-hMAC-SHA1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    _maca_hMAC_SHA1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    maca_hMAC_SHA1._val = dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _maca_hMAC_SHA1_val_Params), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])
    
    #-----< PBKDF2-PRFsAlgorithmIdentifier >-----#
    PBKDF2_PRFsAlgorithmIdentifier = SEQ(name=u'PBKDF2-PRFsAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _PBKDF2_PRFsAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'id']))
    __PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    ___PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', ___PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=None, er=[])
    _PBKDF2_PRFsAlgorithmIdentifier_algorithm._const_tab = __PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab
    _PBKDF2_PRFsAlgorithmIdentifier_algorithm._const_tab_at = None
    _PBKDF2_PRFsAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _PBKDF2_PRFsAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'Params']), opt=True)
    _PBKDF2_PRFsAlgorithmIdentifier_parameters._const_tab = __PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab
    _PBKDF2_PRFsAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _PBKDF2_PRFsAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    PBKDF2_PRFsAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _PBKDF2_PRFsAlgorithmIdentifier_algorithm),
        (u'parameters', _PBKDF2_PRFsAlgorithmIdentifier_parameters),
        ])
    PBKDF2_PRFsAlgorithmIdentifier._ext = None
    
    #-----< alg-hMAC-SHA1 >-----#
    alg_hMAC_SHA1 = CLASS(name=u'alg-hMAC-SHA1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    _alg_hMAC_SHA1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    alg_hMAC_SHA1._val = dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _alg_hMAC_SHA1_val_Params), (u'paramPresence', u'required')])
    
    #-----< PBKDF2-PRFs >-----#
    PBKDF2_PRFs = CLASS(name=u'PBKDF2-PRFs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    _PBKDF2_PRFs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    PBKDF2_PRFs._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _PBKDF2_PRFs_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=[], er=[])
    
    #-----< PBKDF2-SaltSources >-----#
    PBKDF2_SaltSources = CLASS(name=u'PBKDF2-SaltSources', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    PBKDF2_SaltSources._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< PBKDF2-SaltSourcesAlgorithmIdentifier >-----#
    PBKDF2_SaltSourcesAlgorithmIdentifier = SEQ(name=u'PBKDF2-SaltSourcesAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'id']))
    __PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    __PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm._const_tab = __PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm_tab
    _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm._const_tab_at = None
    _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'Params']), opt=True)
    __PBKDF2_SaltSourcesAlgorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    __PBKDF2_SaltSourcesAlgorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters._const_tab = __PBKDF2_SaltSourcesAlgorithmIdentifier_parameters_tab
    _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    PBKDF2_SaltSourcesAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm),
        (u'parameters', _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters),
        ])
    PBKDF2_SaltSourcesAlgorithmIdentifier._ext = None
    
    #-----< defaultPBKDF2 >-----#
    defaultPBKDF2 = SEQ(name=u'defaultPBKDF2', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-PRFsAlgorithmIdentifier')))
    _parameters_val = NULL(name=u'parameters', mode=MODE_TYPE)
    defaultPBKDF2._val = dict([(u'algorithm', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'parameters', (_parameters_val, 0))])
    
    #-----< PBKDF2-params >-----#
    PBKDF2_params = SEQ(name=u'PBKDF2-params', mode=MODE_TYPE)
    _PBKDF2_params_salt = CHOICE(name=u'salt', mode=MODE_TYPE)
    __PBKDF2_params_salt_specified = OCT_STR(name=u'specified', mode=MODE_TYPE)
    __PBKDF2_params_salt_otherSource = SEQ(name=u'otherSource', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-SaltSourcesAlgorithmIdentifier')))
    _PBKDF2_params_salt._cont = ASN1Dict([
        (u'specified', __PBKDF2_params_salt_specified),
        (u'otherSource', __PBKDF2_params_salt_otherSource),
        ])
    _PBKDF2_params_salt._ext = None
    _PBKDF2_params_iterationCount = INT(name=u'iterationCount', mode=MODE_TYPE)
    _PBKDF2_params_iterationCount._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _PBKDF2_params_keyLength = INT(name=u'keyLength', mode=MODE_TYPE, opt=True)
    _PBKDF2_params_keyLength._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _PBKDF2_params_prf = SEQ(name=u'prf', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-PRFsAlgorithmIdentifier')), default=dict([(u'algorithm', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'parameters', (_parameters_val, 0))]))
    PBKDF2_params._cont = ASN1Dict([
        (u'salt', _PBKDF2_params_salt),
        (u'iterationCount', _PBKDF2_params_iterationCount),
        (u'keyLength', _PBKDF2_params_keyLength),
        (u'prf', _PBKDF2_params_prf),
        ])
    PBKDF2_params._ext = None
    
    #-----< kaa-esdh >-----#
    kaa_esdh = CLASS(name=u'kaa-esdh', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-AGREE')))
    _kaa_esdh_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    kaa_esdh._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5)), (u'Params', _kaa_esdh_val_Params), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', __KEY_AGREE_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_AGREE_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', __KEY_AGREE_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]))])
    
    #-----< kaa-ssdh >-----#
    kaa_ssdh = CLASS(name=u'kaa-ssdh', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-AGREE')))
    _kaa_ssdh_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    kaa_ssdh._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10)), (u'Params', _kaa_ssdh_val_Params), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', __KEY_AGREE_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_AGREE_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', __KEY_AGREE_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]))])
    
    #-----< dh-public-number >-----#
    dh_public_number = OID(name=u'dh-public-number', mode=MODE_VALUE)
    dh_public_number._val = (1, 2, 840, 10046, 2, 1)
    
    #-----< pk-originator-dh >-----#
    pk_originator_dh = CLASS(name=u'pk-originator-dh', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_originator_dh_val_KeyValue = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    pk_originator_dh._val = dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _pk_originator_dh_val_KeyValue), (u'paramPresence', u'absent'), (u'keyUsage', (19, 9))])
    
    #-----< kwa-3DESWrap >-----#
    kwa_3DESWrap = CLASS(name=u'kwa-3DESWrap', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    _kwa_3DESWrap_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    kwa_3DESWrap._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6)), (u'Params', _kwa_3DESWrap_val_Params), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]))])
    
    #-----< kwa-RC2Wrap >-----#
    kwa_RC2Wrap = CLASS(name=u'kwa-RC2Wrap', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    _kwa_RC2Wrap_val_Params = INT(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2wrapParameter')))
    kwa_RC2Wrap._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7)), (u'Params', _kwa_RC2Wrap_val_Params), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]))])
    
    #-----< kda-PBKDF2 >-----#
    kda_PBKDF2 = CLASS(name=u'kda-PBKDF2', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-DERIVATION')))
    _kda_PBKDF2_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-params')))
    kda_PBKDF2._val = dict([(u'id', (1, 2, 840, 113549, 1, 5, 12)), (u'Params', _kda_PBKDF2_val_Params), (u'paramPresence', u'required')])
    
    #-----< cea-3DES-cbc >-----#
    cea_3DES_cbc = CLASS(name=u'cea-3DES-cbc', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    _cea_3DES_cbc_val_Params = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'IV')))
    cea_3DES_cbc._val = dict([(u'id', (1, 2, 840, 113549, 3, 7)), (u'Params', _cea_3DES_cbc_val_Params), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 3, 7))]))])
    
    #-----< cea-RC2-cbc >-----#
    cea_RC2_cbc = CLASS(name=u'cea-RC2-cbc', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    _cea_RC2_cbc_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2CBCParameter')))
    cea_RC2_cbc._val = dict([(u'id', (1, 2, 840, 113549, 3, 2)), (u'Params', _cea_RC2_cbc_val_Params), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'Type', __CONTENT_ENCRYPTION_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 3, 2))]))])
    
    #-----< kt-rsa >-----#
    kt_rsa = CLASS(name=u'kt-rsa', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    _kt_rsa_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    kt_rsa._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'Params', _kt_rsa_val_Params), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]))])
    
    #-----< cap-3DESwrap >-----#
    cap_3DESwrap = CLASS(name=u'cap-3DESwrap', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    cap_3DESwrap._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))])
    
    _all_ = [
        MessageDigestAlgs,
        SignatureAlgs,
        KeyAgreementAlgs,
        _KeyAgreementAlgs_val_Params_0,
        __KEY_AGREE_PublicKeySet_val_KeyValue_0,
        __KEY_AGREE_PublicKeySet_val_Params_0,
        __KEY_AGREE_smimeCaps_val_Type,
        _KeyAgreementAlgs_val_Params_1,
        KeyAgreePublicKeys,
        _KeyAgreePublicKeys_val_KeyValue_0,
        _KeyAgreePublicKeys_val_Params_0,
        KeyTransportAlgs,
        _KeyTransportAlgs_val_Params_0,
        __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0,
        __KEY_TRANSPORT_PublicKeySet_val_Params_0,
        KeyWrapAlgs,
        _KeyWrapAlgs_val_Params_0,
        _KeyWrapAlgs_val_Params_1,
        KeyDerivationAlgs,
        _KeyDerivationAlgs_val_Params_0,
        ContentEncryptionAlgs,
        _ContentEncryptionAlgs_val_Params_0,
        _ContentEncryptionAlgs_val_Params_1,
        __CONTENT_ENCRYPTION_smimeCaps_val_Type,
        MessageAuthAlgs,
        _MessageAuthAlgs_val_Params_0,
        SMimeCaps,
        _SMimeCaps_val_Type_0,
        _SMimeCaps_val_Type_1,
        _SMimeCaps_val_Type_6,
        id_alg_ESDH,
        id_alg_SSDH,
        id_alg_CMS3DESwrap,
        id_alg_CMSRC2wrap,
        des_ede3_cbc,
        rc2_cbc,
        hMAC_SHA1,
        id_PBKDF2,
        __KeyWrapAlgorithm_algorithm_tab,
        ___KeyWrapAlgorithm_algorithm_tab_val_Params_0,
        ___KeyWrapAlgorithm_algorithm_tab_val_Params_1,
        _KeyWrapAlgorithm_algorithm,
        _KeyWrapAlgorithm_parameters,
        KeyWrapAlgorithm,
        RC2wrapParameter,
        RC2ParameterVersion,
        CBCParameter,
        IV,
        _RC2CBCParameter_rc2ParameterVersion,
        _RC2CBCParameter_iv,
        RC2CBCParameter,
        maca_hMAC_SHA1,
        _maca_hMAC_SHA1_val_Params,
        __PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab,
        ___PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab_val_Params_0,
        _PBKDF2_PRFsAlgorithmIdentifier_algorithm,
        _PBKDF2_PRFsAlgorithmIdentifier_parameters,
        PBKDF2_PRFsAlgorithmIdentifier,
        alg_hMAC_SHA1,
        _alg_hMAC_SHA1_val_Params,
        PBKDF2_PRFs,
        _PBKDF2_PRFs_val_Params_0,
        PBKDF2_SaltSources,
        __PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm_tab,
        _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm,
        __PBKDF2_SaltSourcesAlgorithmIdentifier_parameters_tab,
        _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters,
        PBKDF2_SaltSourcesAlgorithmIdentifier,
        defaultPBKDF2,
        _parameters_val,
        __PBKDF2_params_salt_specified,
        __PBKDF2_params_salt_otherSource,
        _PBKDF2_params_salt,
        _PBKDF2_params_iterationCount,
        _PBKDF2_params_keyLength,
        _PBKDF2_params_prf,
        PBKDF2_params,
        kaa_esdh,
        _kaa_esdh_val_Params,
        kaa_ssdh,
        _kaa_ssdh_val_Params,
        dh_public_number,
        pk_originator_dh,
        _pk_originator_dh_val_KeyValue,
        kwa_3DESWrap,
        _kwa_3DESWrap_val_Params,
        kwa_RC2Wrap,
        _kwa_RC2Wrap_val_Params,
        kda_PBKDF2,
        _kda_PBKDF2_val_Params,
        cea_3DES_cbc,
        _cea_3DES_cbc_val_Params,
        cea_RC2_cbc,
        _cea_RC2_cbc_val_Params,
        kt_rsa,
        _kt_rsa_val_Params,
        cap_3DESwrap,
    ]

class PKIX1Explicit_2009:

    _name_  = u'PKIX1Explicit-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 51]
    
    _obj_ = [
        u'id-pkix',
        u'id-pe',
        u'id-qt',
        u'id-kp',
        u'id-ad',
        u'id-qt-cps',
        u'id-qt-unotice',
        u'id-ad-ocsp',
        u'id-ad-caIssuers',
        u'id-ad-timeStamping',
        u'id-ad-caRepository',
        u'AttributeType',
        u'id-at',
        u'id-at-name',
        u'at-name',
        u'id-at-surname',
        u'at-surname',
        u'id-at-givenName',
        u'at-givenName',
        u'id-at-initials',
        u'at-initials',
        u'id-at-generationQualifier',
        u'at-generationQualifier',
        u'DirectoryString',
        u'X520name',
        u'id-at-commonName',
        u'at-x520CommonName',
        u'X520CommonName',
        u'id-at-localityName',
        u'at-x520LocalityName',
        u'X520LocalityName',
        u'id-at-stateOrProvinceName',
        u'at-x520StateOrProvinceName',
        u'X520StateOrProvinceName',
        u'id-at-organizationName',
        u'at-x520OrganizationName',
        u'X520OrganizationName',
        u'id-at-organizationalUnitName',
        u'at-x520OrganizationalUnitName',
        u'X520OrganizationalUnitName',
        u'id-at-title',
        u'at-x520Title',
        u'id-at-dnQualifier',
        u'at-x520dnQualifier',
        u'id-at-countryName',
        u'at-x520countryName',
        u'id-at-serialNumber',
        u'at-x520SerialNumber',
        u'id-at-pseudonym',
        u'at-x520Pseudonym',
        u'id-domainComponent',
        u'at-domainComponent',
        u'pkcs-9',
        u'id-emailAddress',
        u'at-emailAddress',
        u'Name',
        u'RDNSequence',
        u'DistinguishedName',
        u'RelativeDistinguishedName',
        u'SupportedAttributes',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'Validity',
        u'Time',
        u'UniqueIdentifier',
        u'SubjectPublicKeyInfo',
        u'CertificateList',
        u'TBSCertList',
        u'SignatureAlgorithms',
        u'PublicKeyAlgorithms',
        u'ub-state-name',
        u'ub-organization-name',
        u'ub-organizational-unit-name',
        u'ub-title',
        u'ub-serial-number',
        u'ub-pseudonym',
        u'ub-emailaddress-length',
        u'ub-locality-name',
        u'ub-common-name',
        u'ub-name',
        u'SIGNED',
        ]
    _type_ = [
        u'AttributeType',
        u'DirectoryString',
        u'X520name',
        u'X520CommonName',
        u'X520LocalityName',
        u'X520StateOrProvinceName',
        u'X520OrganizationName',
        u'X520OrganizationalUnitName',
        u'Name',
        u'RDNSequence',
        u'DistinguishedName',
        u'RelativeDistinguishedName',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'Validity',
        u'Time',
        u'UniqueIdentifier',
        u'SubjectPublicKeyInfo',
        u'CertificateList',
        u'TBSCertList',
        u'SIGNED',
        ]
    _set_ = [
        u'SupportedAttributes',
        u'SignatureAlgorithms',
        u'PublicKeyAlgorithms',
        ]
    _val_ = [
        u'id-pkix',
        u'id-pe',
        u'id-qt',
        u'id-kp',
        u'id-ad',
        u'id-qt-cps',
        u'id-qt-unotice',
        u'id-ad-ocsp',
        u'id-ad-caIssuers',
        u'id-ad-timeStamping',
        u'id-ad-caRepository',
        u'id-at',
        u'id-at-name',
        u'at-name',
        u'id-at-surname',
        u'at-surname',
        u'id-at-givenName',
        u'at-givenName',
        u'id-at-initials',
        u'at-initials',
        u'id-at-generationQualifier',
        u'at-generationQualifier',
        u'id-at-commonName',
        u'at-x520CommonName',
        u'id-at-localityName',
        u'at-x520LocalityName',
        u'id-at-stateOrProvinceName',
        u'at-x520StateOrProvinceName',
        u'id-at-organizationName',
        u'at-x520OrganizationName',
        u'id-at-organizationalUnitName',
        u'at-x520OrganizationalUnitName',
        u'id-at-title',
        u'at-x520Title',
        u'id-at-dnQualifier',
        u'at-x520dnQualifier',
        u'id-at-countryName',
        u'at-x520countryName',
        u'id-at-serialNumber',
        u'at-x520SerialNumber',
        u'id-at-pseudonym',
        u'at-x520Pseudonym',
        u'id-domainComponent',
        u'at-domainComponent',
        u'pkcs-9',
        u'id-emailAddress',
        u'at-emailAddress',
        u'ub-state-name',
        u'ub-organization-name',
        u'ub-organizational-unit-name',
        u'ub-title',
        u'ub-serial-number',
        u'ub-pseudonym',
        u'ub-emailaddress-length',
        u'ub-locality-name',
        u'ub-common-name',
        u'ub-name',
        ]
    _class_ = [
        u'at-name',
        u'at-surname',
        u'at-givenName',
        u'at-initials',
        u'at-generationQualifier',
        u'at-x520CommonName',
        u'at-x520LocalityName',
        u'at-x520StateOrProvinceName',
        u'at-x520OrganizationName',
        u'at-x520OrganizationalUnitName',
        u'at-x520Title',
        u'at-x520dnQualifier',
        u'at-x520countryName',
        u'at-x520SerialNumber',
        u'at-x520Pseudonym',
        u'at-domainComponent',
        u'at-emailAddress',
        u'SupportedAttributes',
        u'SignatureAlgorithms',
        u'PublicKeyAlgorithms',
        ]
    _param_ = [
        u'DirectoryString',
        u'SIGNED',
        ]
    
    #-----< id-pkix >-----#
    id_pkix = OID(name=u'id-pkix', mode=MODE_VALUE)
    id_pkix._val = (1, 3, 6, 1, 5, 5, 7)
    
    #-----< id-pe >-----#
    id_pe = OID(name=u'id-pe', mode=MODE_VALUE)
    id_pe._val = (1, 3, 6, 1, 5, 5, 7, 1)
    
    #-----< id-qt >-----#
    id_qt = OID(name=u'id-qt', mode=MODE_VALUE)
    id_qt._val = (1, 3, 6, 1, 5, 5, 7, 2)
    
    #-----< id-kp >-----#
    id_kp = OID(name=u'id-kp', mode=MODE_VALUE)
    id_kp._val = (1, 3, 6, 1, 5, 5, 7, 3)
    
    #-----< id-ad >-----#
    id_ad = OID(name=u'id-ad', mode=MODE_VALUE)
    id_ad._val = (1, 3, 6, 1, 5, 5, 7, 48)
    
    #-----< id-qt-cps >-----#
    id_qt_cps = OID(name=u'id-qt-cps', mode=MODE_VALUE)
    id_qt_cps._val = (1, 3, 6, 1, 5, 5, 7, 2, 1)
    
    #-----< id-qt-unotice >-----#
    id_qt_unotice = OID(name=u'id-qt-unotice', mode=MODE_VALUE)
    id_qt_unotice._val = (1, 3, 6, 1, 5, 5, 7, 2, 2)
    
    #-----< id-ad-ocsp >-----#
    id_ad_ocsp = OID(name=u'id-ad-ocsp', mode=MODE_VALUE)
    id_ad_ocsp._val = (1, 3, 6, 1, 5, 5, 7, 48, 1)
    
    #-----< id-ad-caIssuers >-----#
    id_ad_caIssuers = OID(name=u'id-ad-caIssuers', mode=MODE_VALUE)
    id_ad_caIssuers._val = (1, 3, 6, 1, 5, 5, 7, 48, 2)
    
    #-----< id-ad-timeStamping >-----#
    id_ad_timeStamping = OID(name=u'id-ad-timeStamping', mode=MODE_VALUE)
    id_ad_timeStamping._val = (1, 3, 6, 1, 5, 5, 7, 48, 3)
    
    #-----< id-ad-caRepository >-----#
    id_ad_caRepository = OID(name=u'id-ad-caRepository', mode=MODE_VALUE)
    id_ad_caRepository._val = (1, 3, 6, 1, 5, 5, 7, 48, 5)
    
    #-----< AttributeType >-----#
    AttributeType = OID(name=u'AttributeType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    
    #-----< id-at >-----#
    id_at = OID(name=u'id-at', mode=MODE_VALUE)
    id_at._val = (2, 5, 4)
    
    #-----< id-at-name >-----#
    id_at_name = OID(name=u'id-at-name', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_name._val = (2, 5, 4, 41)
    
    #-----< at-name >-----#
    at_name = CLASS(name=u'at-name', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_name_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    at_name._val = dict([(u'Type', _at_name_val_Type), (u'id', (2, 5, 4, 41))])
    
    #-----< id-at-surname >-----#
    id_at_surname = OID(name=u'id-at-surname', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_surname._val = (2, 5, 4, 4)
    
    #-----< at-surname >-----#
    at_surname = CLASS(name=u'at-surname', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_surname_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    at_surname._val = dict([(u'Type', _at_surname_val_Type), (u'id', (2, 5, 4, 4))])
    
    #-----< id-at-givenName >-----#
    id_at_givenName = OID(name=u'id-at-givenName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_givenName._val = (2, 5, 4, 42)
    
    #-----< at-givenName >-----#
    at_givenName = CLASS(name=u'at-givenName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_givenName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    at_givenName._val = dict([(u'Type', _at_givenName_val_Type), (u'id', (2, 5, 4, 42))])
    
    #-----< id-at-initials >-----#
    id_at_initials = OID(name=u'id-at-initials', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_initials._val = (2, 5, 4, 43)
    
    #-----< at-initials >-----#
    at_initials = CLASS(name=u'at-initials', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_initials_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    at_initials._val = dict([(u'Type', _at_initials_val_Type), (u'id', (2, 5, 4, 43))])
    
    #-----< id-at-generationQualifier >-----#
    id_at_generationQualifier = OID(name=u'id-at-generationQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_generationQualifier._val = (2, 5, 4, 44)
    
    #-----< at-generationQualifier >-----#
    at_generationQualifier = CLASS(name=u'at-generationQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_generationQualifier_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    at_generationQualifier._val = dict([(u'Type', _at_generationQualifier_val_Type), (u'id', (2, 5, 4, 44))])
    
    #-----< DirectoryString >-----#
    DirectoryString = CHOICE(name=u'DirectoryString', mode=MODE_TYPE, param=True)
    
    #-----< X520name >-----#
    X520name = CHOICE(name=u'X520name', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520name_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520name_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520name_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520name_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520name_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520name_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    X520name._cont = ASN1Dict([
        (u'teletexString', _X520name_teletexString),
        (u'printableString', _X520name_printableString),
        (u'bmpString', _X520name_bmpString),
        (u'universalString', _X520name_universalString),
        (u'uTF8String', _X520name_uTF8String),
        ])
    X520name._ext = None
    
    #-----< id-at-commonName >-----#
    id_at_commonName = OID(name=u'id-at-commonName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_commonName._val = (2, 5, 4, 3)
    
    #-----< at-x520CommonName >-----#
    at_x520CommonName = CLASS(name=u'at-x520CommonName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520CommonName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520CommonName')))
    at_x520CommonName._val = dict([(u'Type', _at_x520CommonName_val_Type), (u'id', (2, 5, 4, 3))])
    
    #-----< X520CommonName >-----#
    X520CommonName = CHOICE(name=u'X520CommonName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520CommonName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520CommonName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520CommonName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520CommonName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520CommonName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520CommonName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520CommonName._cont = ASN1Dict([
        (u'teletexString', _X520CommonName_teletexString),
        (u'printableString', _X520CommonName_printableString),
        (u'bmpString', _X520CommonName_bmpString),
        (u'universalString', _X520CommonName_universalString),
        (u'uTF8String', _X520CommonName_uTF8String),
        ])
    X520CommonName._ext = None
    
    #-----< id-at-localityName >-----#
    id_at_localityName = OID(name=u'id-at-localityName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_localityName._val = (2, 5, 4, 7)
    
    #-----< at-x520LocalityName >-----#
    at_x520LocalityName = CLASS(name=u'at-x520LocalityName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520LocalityName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520LocalityName')))
    at_x520LocalityName._val = dict([(u'Type', _at_x520LocalityName_val_Type), (u'id', (2, 5, 4, 7))])
    
    #-----< X520LocalityName >-----#
    X520LocalityName = CHOICE(name=u'X520LocalityName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520LocalityName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520LocalityName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520LocalityName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520LocalityName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520LocalityName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520LocalityName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    X520LocalityName._cont = ASN1Dict([
        (u'teletexString', _X520LocalityName_teletexString),
        (u'printableString', _X520LocalityName_printableString),
        (u'bmpString', _X520LocalityName_bmpString),
        (u'universalString', _X520LocalityName_universalString),
        (u'uTF8String', _X520LocalityName_uTF8String),
        ])
    X520LocalityName._ext = None
    
    #-----< id-at-stateOrProvinceName >-----#
    id_at_stateOrProvinceName = OID(name=u'id-at-stateOrProvinceName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_stateOrProvinceName._val = (2, 5, 4, 8)
    
    #-----< at-x520StateOrProvinceName >-----#
    at_x520StateOrProvinceName = CLASS(name=u'at-x520StateOrProvinceName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520StateOrProvinceName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __at_x520StateOrProvinceName_val_Type_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __at_x520StateOrProvinceName_val_Type_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520StateOrProvinceName_val_Type_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __at_x520StateOrProvinceName_val_Type_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520StateOrProvinceName_val_Type_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __at_x520StateOrProvinceName_val_Type_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520StateOrProvinceName_val_Type_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __at_x520StateOrProvinceName_val_Type_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520StateOrProvinceName_val_Type_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __at_x520StateOrProvinceName_val_Type_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _at_x520StateOrProvinceName_val_Type._cont = ASN1Dict([
        (u'teletexString', __at_x520StateOrProvinceName_val_Type_teletexString),
        (u'printableString', __at_x520StateOrProvinceName_val_Type_printableString),
        (u'bmpString', __at_x520StateOrProvinceName_val_Type_bmpString),
        (u'universalString', __at_x520StateOrProvinceName_val_Type_universalString),
        (u'uTF8String', __at_x520StateOrProvinceName_val_Type_uTF8String),
        ])
    _at_x520StateOrProvinceName_val_Type._ext = None
    at_x520StateOrProvinceName._val = dict([(u'Type', _at_x520StateOrProvinceName_val_Type), (u'id', (2, 5, 4, 8))])
    
    #-----< X520StateOrProvinceName >-----#
    X520StateOrProvinceName = CHOICE(name=u'X520StateOrProvinceName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520StateOrProvinceName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520StateOrProvinceName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520StateOrProvinceName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520StateOrProvinceName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520StateOrProvinceName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520StateOrProvinceName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    X520StateOrProvinceName._cont = ASN1Dict([
        (u'teletexString', _X520StateOrProvinceName_teletexString),
        (u'printableString', _X520StateOrProvinceName_printableString),
        (u'bmpString', _X520StateOrProvinceName_bmpString),
        (u'universalString', _X520StateOrProvinceName_universalString),
        (u'uTF8String', _X520StateOrProvinceName_uTF8String),
        ])
    X520StateOrProvinceName._ext = None
    
    #-----< id-at-organizationName >-----#
    id_at_organizationName = OID(name=u'id-at-organizationName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_organizationName._val = (2, 5, 4, 10)
    
    #-----< at-x520OrganizationName >-----#
    at_x520OrganizationName = CLASS(name=u'at-x520OrganizationName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520OrganizationName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __at_x520OrganizationName_val_Type_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __at_x520OrganizationName_val_Type_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationName_val_Type_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __at_x520OrganizationName_val_Type_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationName_val_Type_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __at_x520OrganizationName_val_Type_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationName_val_Type_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __at_x520OrganizationName_val_Type_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationName_val_Type_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __at_x520OrganizationName_val_Type_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _at_x520OrganizationName_val_Type._cont = ASN1Dict([
        (u'teletexString', __at_x520OrganizationName_val_Type_teletexString),
        (u'printableString', __at_x520OrganizationName_val_Type_printableString),
        (u'bmpString', __at_x520OrganizationName_val_Type_bmpString),
        (u'universalString', __at_x520OrganizationName_val_Type_universalString),
        (u'uTF8String', __at_x520OrganizationName_val_Type_uTF8String),
        ])
    _at_x520OrganizationName_val_Type._ext = None
    at_x520OrganizationName._val = dict([(u'Type', _at_x520OrganizationName_val_Type), (u'id', (2, 5, 4, 10))])
    
    #-----< X520OrganizationName >-----#
    X520OrganizationName = CHOICE(name=u'X520OrganizationName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520OrganizationName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520OrganizationName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520OrganizationName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520OrganizationName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520OrganizationName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520OrganizationName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520OrganizationName._cont = ASN1Dict([
        (u'teletexString', _X520OrganizationName_teletexString),
        (u'printableString', _X520OrganizationName_printableString),
        (u'bmpString', _X520OrganizationName_bmpString),
        (u'universalString', _X520OrganizationName_universalString),
        (u'uTF8String', _X520OrganizationName_uTF8String),
        ])
    X520OrganizationName._ext = None
    
    #-----< id-at-organizationalUnitName >-----#
    id_at_organizationalUnitName = OID(name=u'id-at-organizationalUnitName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_organizationalUnitName._val = (2, 5, 4, 11)
    
    #-----< at-x520OrganizationalUnitName >-----#
    at_x520OrganizationalUnitName = CLASS(name=u'at-x520OrganizationalUnitName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520OrganizationalUnitName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __at_x520OrganizationalUnitName_val_Type_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __at_x520OrganizationalUnitName_val_Type_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationalUnitName_val_Type_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __at_x520OrganizationalUnitName_val_Type_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationalUnitName_val_Type_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __at_x520OrganizationalUnitName_val_Type_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationalUnitName_val_Type_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __at_x520OrganizationalUnitName_val_Type_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationalUnitName_val_Type_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __at_x520OrganizationalUnitName_val_Type_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _at_x520OrganizationalUnitName_val_Type._cont = ASN1Dict([
        (u'teletexString', __at_x520OrganizationalUnitName_val_Type_teletexString),
        (u'printableString', __at_x520OrganizationalUnitName_val_Type_printableString),
        (u'bmpString', __at_x520OrganizationalUnitName_val_Type_bmpString),
        (u'universalString', __at_x520OrganizationalUnitName_val_Type_universalString),
        (u'uTF8String', __at_x520OrganizationalUnitName_val_Type_uTF8String),
        ])
    _at_x520OrganizationalUnitName_val_Type._ext = None
    at_x520OrganizationalUnitName._val = dict([(u'Type', _at_x520OrganizationalUnitName_val_Type), (u'id', (2, 5, 4, 11))])
    
    #-----< X520OrganizationalUnitName >-----#
    X520OrganizationalUnitName = CHOICE(name=u'X520OrganizationalUnitName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520OrganizationalUnitName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520OrganizationalUnitName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520OrganizationalUnitName._cont = ASN1Dict([
        (u'teletexString', _X520OrganizationalUnitName_teletexString),
        (u'printableString', _X520OrganizationalUnitName_printableString),
        (u'bmpString', _X520OrganizationalUnitName_bmpString),
        (u'universalString', _X520OrganizationalUnitName_universalString),
        (u'uTF8String', _X520OrganizationalUnitName_uTF8String),
        ])
    X520OrganizationalUnitName._ext = None
    
    #-----< id-at-title >-----#
    id_at_title = OID(name=u'id-at-title', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_title._val = (2, 5, 4, 12)
    
    #-----< at-x520Title >-----#
    at_x520Title = CLASS(name=u'at-x520Title', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520Title_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __at_x520Title_val_Type_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __at_x520Title_val_Type_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520Title_val_Type_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __at_x520Title_val_Type_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520Title_val_Type_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __at_x520Title_val_Type_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520Title_val_Type_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __at_x520Title_val_Type_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520Title_val_Type_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __at_x520Title_val_Type_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _at_x520Title_val_Type._cont = ASN1Dict([
        (u'teletexString', __at_x520Title_val_Type_teletexString),
        (u'printableString', __at_x520Title_val_Type_printableString),
        (u'bmpString', __at_x520Title_val_Type_bmpString),
        (u'universalString', __at_x520Title_val_Type_universalString),
        (u'uTF8String', __at_x520Title_val_Type_uTF8String),
        ])
    _at_x520Title_val_Type._ext = None
    at_x520Title._val = dict([(u'Type', _at_x520Title_val_Type), (u'id', (2, 5, 4, 12))])
    
    #-----< id-at-dnQualifier >-----#
    id_at_dnQualifier = OID(name=u'id-at-dnQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_dnQualifier._val = (2, 5, 4, 46)
    
    #-----< at-x520dnQualifier >-----#
    at_x520dnQualifier = CLASS(name=u'at-x520dnQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520dnQualifier_val_Type = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    at_x520dnQualifier._val = dict([(u'Type', _at_x520dnQualifier_val_Type), (u'id', (2, 5, 4, 46))])
    
    #-----< id-at-countryName >-----#
    id_at_countryName = OID(name=u'id-at-countryName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_countryName._val = (2, 5, 4, 6)
    
    #-----< at-x520countryName >-----#
    at_x520countryName = CLASS(name=u'at-x520countryName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520countryName_val_Type = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _at_x520countryName_val_Type._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    at_x520countryName._val = dict([(u'Type', _at_x520countryName_val_Type), (u'id', (2, 5, 4, 6))])
    
    #-----< id-at-serialNumber >-----#
    id_at_serialNumber = OID(name=u'id-at-serialNumber', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_serialNumber._val = (2, 5, 4, 5)
    
    #-----< at-x520SerialNumber >-----#
    at_x520SerialNumber = CLASS(name=u'at-x520SerialNumber', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520SerialNumber_val_Type = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _at_x520SerialNumber_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    at_x520SerialNumber._val = dict([(u'Type', _at_x520SerialNumber_val_Type), (u'id', (2, 5, 4, 5))])
    
    #-----< id-at-pseudonym >-----#
    id_at_pseudonym = OID(name=u'id-at-pseudonym', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_pseudonym._val = (2, 5, 4, 65)
    
    #-----< at-x520Pseudonym >-----#
    at_x520Pseudonym = CLASS(name=u'at-x520Pseudonym', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520Pseudonym_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __at_x520Pseudonym_val_Type_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __at_x520Pseudonym_val_Type_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520Pseudonym_val_Type_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __at_x520Pseudonym_val_Type_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520Pseudonym_val_Type_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __at_x520Pseudonym_val_Type_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520Pseudonym_val_Type_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __at_x520Pseudonym_val_Type_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520Pseudonym_val_Type_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __at_x520Pseudonym_val_Type_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _at_x520Pseudonym_val_Type._cont = ASN1Dict([
        (u'teletexString', __at_x520Pseudonym_val_Type_teletexString),
        (u'printableString', __at_x520Pseudonym_val_Type_printableString),
        (u'bmpString', __at_x520Pseudonym_val_Type_bmpString),
        (u'universalString', __at_x520Pseudonym_val_Type_universalString),
        (u'uTF8String', __at_x520Pseudonym_val_Type_uTF8String),
        ])
    _at_x520Pseudonym_val_Type._ext = None
    at_x520Pseudonym._val = dict([(u'Type', _at_x520Pseudonym_val_Type), (u'id', (2, 5, 4, 65))])
    
    #-----< id-domainComponent >-----#
    id_domainComponent = OID(name=u'id-domainComponent', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_domainComponent._val = (0, 9, 2342, 19200300, 100, 1, 25)
    
    #-----< at-domainComponent >-----#
    at_domainComponent = CLASS(name=u'at-domainComponent', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_domainComponent_val_Type = STR_IA5(name=u'Type', mode=MODE_TYPE)
    at_domainComponent._val = dict([(u'Type', _at_domainComponent_val_Type), (u'id', (0, 9, 2342, 19200300, 100, 1, 25))])
    
    #-----< pkcs-9 >-----#
    pkcs_9 = OID(name=u'pkcs-9', mode=MODE_VALUE)
    pkcs_9._val = (1, 2, 840, 113549, 1, 9)
    
    #-----< id-emailAddress >-----#
    id_emailAddress = OID(name=u'id-emailAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_emailAddress._val = (1, 2, 840, 113549, 1, 9, 1)
    
    #-----< at-emailAddress >-----#
    at_emailAddress = CLASS(name=u'at-emailAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_emailAddress_val_Type = STR_IA5(name=u'Type', mode=MODE_TYPE)
    _at_emailAddress_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    at_emailAddress._val = dict([(u'Type', _at_emailAddress_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 1))])
    
    #-----< Name >-----#
    Name = CHOICE(name=u'Name', mode=MODE_TYPE)
    _Name_rdnSequence = SEQ_OF(name=u'rdnSequence', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'RDNSequence')))
    Name._cont = ASN1Dict([
        (u'rdnSequence', _Name_rdnSequence),
        ])
    Name._ext = None
    
    #-----< RDNSequence >-----#
    RDNSequence = SEQ_OF(name=u'RDNSequence', mode=MODE_TYPE)
    _RDNSequence__item_ = SET_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'RelativeDistinguishedName')))
    RDNSequence._cont = _RDNSequence__item_
    
    #-----< DistinguishedName >-----#
    DistinguishedName = SEQ_OF(name=u'DistinguishedName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'RDNSequence')))
    
    #-----< RelativeDistinguishedName >-----#
    RelativeDistinguishedName = SET_OF(name=u'RelativeDistinguishedName', mode=MODE_TYPE)
    _RelativeDistinguishedName__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SingleAttribute')))
    __RelativeDistinguishedName__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___RelativeDistinguishedName__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_1 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_2 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_3 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_4 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_5 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520CommonName')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_6 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520LocalityName')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_7 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_7._cont = ASN1Dict([
        (u'teletexString', _____RelativeDistinguishedName__item__type_tab_val_Type_7_teletexString),
        (u'printableString', _____RelativeDistinguishedName__item__type_tab_val_Type_7_printableString),
        (u'bmpString', _____RelativeDistinguishedName__item__type_tab_val_Type_7_bmpString),
        (u'universalString', _____RelativeDistinguishedName__item__type_tab_val_Type_7_universalString),
        (u'uTF8String', _____RelativeDistinguishedName__item__type_tab_val_Type_7_uTF8String),
        ])
    ____RelativeDistinguishedName__item__type_tab_val_Type_7._ext = None
    ____RelativeDistinguishedName__item__type_tab_val_Type_8 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_8._cont = ASN1Dict([
        (u'teletexString', _____RelativeDistinguishedName__item__type_tab_val_Type_8_teletexString),
        (u'printableString', _____RelativeDistinguishedName__item__type_tab_val_Type_8_printableString),
        (u'bmpString', _____RelativeDistinguishedName__item__type_tab_val_Type_8_bmpString),
        (u'universalString', _____RelativeDistinguishedName__item__type_tab_val_Type_8_universalString),
        (u'uTF8String', _____RelativeDistinguishedName__item__type_tab_val_Type_8_uTF8String),
        ])
    ____RelativeDistinguishedName__item__type_tab_val_Type_8._ext = None
    ____RelativeDistinguishedName__item__type_tab_val_Type_9 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_9._cont = ASN1Dict([
        (u'teletexString', _____RelativeDistinguishedName__item__type_tab_val_Type_9_teletexString),
        (u'printableString', _____RelativeDistinguishedName__item__type_tab_val_Type_9_printableString),
        (u'bmpString', _____RelativeDistinguishedName__item__type_tab_val_Type_9_bmpString),
        (u'universalString', _____RelativeDistinguishedName__item__type_tab_val_Type_9_universalString),
        (u'uTF8String', _____RelativeDistinguishedName__item__type_tab_val_Type_9_uTF8String),
        ])
    ____RelativeDistinguishedName__item__type_tab_val_Type_9._ext = None
    ____RelativeDistinguishedName__item__type_tab_val_Type_10 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_10._cont = ASN1Dict([
        (u'teletexString', _____RelativeDistinguishedName__item__type_tab_val_Type_10_teletexString),
        (u'printableString', _____RelativeDistinguishedName__item__type_tab_val_Type_10_printableString),
        (u'bmpString', _____RelativeDistinguishedName__item__type_tab_val_Type_10_bmpString),
        (u'universalString', _____RelativeDistinguishedName__item__type_tab_val_Type_10_universalString),
        (u'uTF8String', _____RelativeDistinguishedName__item__type_tab_val_Type_10_uTF8String),
        ])
    ____RelativeDistinguishedName__item__type_tab_val_Type_10._ext = None
    ____RelativeDistinguishedName__item__type_tab_val_Type_11 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____RelativeDistinguishedName__item__type_tab_val_Type_12 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____RelativeDistinguishedName__item__type_tab_val_Type_12._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_13 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____RelativeDistinguishedName__item__type_tab_val_Type_13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_14 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_14._cont = ASN1Dict([
        (u'teletexString', _____RelativeDistinguishedName__item__type_tab_val_Type_14_teletexString),
        (u'printableString', _____RelativeDistinguishedName__item__type_tab_val_Type_14_printableString),
        (u'bmpString', _____RelativeDistinguishedName__item__type_tab_val_Type_14_bmpString),
        (u'universalString', _____RelativeDistinguishedName__item__type_tab_val_Type_14_universalString),
        (u'uTF8String', _____RelativeDistinguishedName__item__type_tab_val_Type_14_uTF8String),
        ])
    ____RelativeDistinguishedName__item__type_tab_val_Type_14._ext = None
    ____RelativeDistinguishedName__item__type_tab_val_Type_15 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    ____RelativeDistinguishedName__item__type_tab_val_Type_16 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    ____RelativeDistinguishedName__item__type_tab_val_Type_16._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    ___RelativeDistinguishedName__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_0), (u'id', (2, 5, 4, 41))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_1), (u'id', (2, 5, 4, 4))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_2), (u'id', (2, 5, 4, 42))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_3), (u'id', (2, 5, 4, 43))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_4), (u'id', (2, 5, 4, 44))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_5), (u'id', (2, 5, 4, 3))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_6), (u'id', (2, 5, 4, 7))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_7), (u'id', (2, 5, 4, 8))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_8), (u'id', (2, 5, 4, 10))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_9), (u'id', (2, 5, 4, 11))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_10), (u'id', (2, 5, 4, 12))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_11), (u'id', (2, 5, 4, 46))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_12), (u'id', (2, 5, 4, 6))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_13), (u'id', (2, 5, 4, 5))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_14), (u'id', (2, 5, 4, 65))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_15), (u'id', (0, 9, 2342, 19200300, 100, 1, 25))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 9, 1))])], rr=[], ev=None, er=[])
    __RelativeDistinguishedName__item__type._const_tab = ___RelativeDistinguishedName__item__type_tab
    __RelativeDistinguishedName__item__type._const_tab_at = None
    __RelativeDistinguishedName__item__type._const_tab_id = u'id'
    __RelativeDistinguishedName__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    __RelativeDistinguishedName__item__value._const_tab = ___RelativeDistinguishedName__item__type_tab
    __RelativeDistinguishedName__item__value._const_tab_at = ('..', u'type')
    __RelativeDistinguishedName__item__value._const_tab_id = u'Type'
    _RelativeDistinguishedName__item_._cont = ASN1Dict([
        (u'type', __RelativeDistinguishedName__item__type),
        (u'value', __RelativeDistinguishedName__item__value),
        ])
    _RelativeDistinguishedName__item_._ext = None
    RelativeDistinguishedName._cont = _RelativeDistinguishedName__item_
    RelativeDistinguishedName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< SupportedAttributes >-----#
    SupportedAttributes = CLASS(name=u'SupportedAttributes', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _SupportedAttributes_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    _SupportedAttributes_val_Type_1 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    _SupportedAttributes_val_Type_2 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    _SupportedAttributes_val_Type_3 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    _SupportedAttributes_val_Type_4 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    _SupportedAttributes_val_Type_5 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520CommonName')))
    _SupportedAttributes_val_Type_6 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520LocalityName')))
    _SupportedAttributes_val_Type_7 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __SupportedAttributes_val_Type_7_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_7_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_7_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_7_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_7_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_7_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_7_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_7_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_7_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_7_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _SupportedAttributes_val_Type_7._cont = ASN1Dict([
        (u'teletexString', __SupportedAttributes_val_Type_7_teletexString),
        (u'printableString', __SupportedAttributes_val_Type_7_printableString),
        (u'bmpString', __SupportedAttributes_val_Type_7_bmpString),
        (u'universalString', __SupportedAttributes_val_Type_7_universalString),
        (u'uTF8String', __SupportedAttributes_val_Type_7_uTF8String),
        ])
    _SupportedAttributes_val_Type_7._ext = None
    _SupportedAttributes_val_Type_8 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __SupportedAttributes_val_Type_8_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_8_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_8_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_8_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_8_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_8_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_8_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_8_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_8_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_8_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedAttributes_val_Type_8._cont = ASN1Dict([
        (u'teletexString', __SupportedAttributes_val_Type_8_teletexString),
        (u'printableString', __SupportedAttributes_val_Type_8_printableString),
        (u'bmpString', __SupportedAttributes_val_Type_8_bmpString),
        (u'universalString', __SupportedAttributes_val_Type_8_universalString),
        (u'uTF8String', __SupportedAttributes_val_Type_8_uTF8String),
        ])
    _SupportedAttributes_val_Type_8._ext = None
    _SupportedAttributes_val_Type_9 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __SupportedAttributes_val_Type_9_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_9_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_9_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_9_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_9_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_9_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_9_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_9_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_9_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_9_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedAttributes_val_Type_9._cont = ASN1Dict([
        (u'teletexString', __SupportedAttributes_val_Type_9_teletexString),
        (u'printableString', __SupportedAttributes_val_Type_9_printableString),
        (u'bmpString', __SupportedAttributes_val_Type_9_bmpString),
        (u'universalString', __SupportedAttributes_val_Type_9_universalString),
        (u'uTF8String', __SupportedAttributes_val_Type_9_uTF8String),
        ])
    _SupportedAttributes_val_Type_9._ext = None
    _SupportedAttributes_val_Type_10 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __SupportedAttributes_val_Type_10_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_10_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_10_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_10_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_10_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_10_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_10_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_10_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_10_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_10_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedAttributes_val_Type_10._cont = ASN1Dict([
        (u'teletexString', __SupportedAttributes_val_Type_10_teletexString),
        (u'printableString', __SupportedAttributes_val_Type_10_printableString),
        (u'bmpString', __SupportedAttributes_val_Type_10_bmpString),
        (u'universalString', __SupportedAttributes_val_Type_10_universalString),
        (u'uTF8String', __SupportedAttributes_val_Type_10_uTF8String),
        ])
    _SupportedAttributes_val_Type_10._ext = None
    _SupportedAttributes_val_Type_11 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _SupportedAttributes_val_Type_12 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _SupportedAttributes_val_Type_12._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _SupportedAttributes_val_Type_13 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _SupportedAttributes_val_Type_13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedAttributes_val_Type_14 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __SupportedAttributes_val_Type_14_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_14_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_14_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_14_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_14_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_14_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_14_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_14_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_14_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_14_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _SupportedAttributes_val_Type_14._cont = ASN1Dict([
        (u'teletexString', __SupportedAttributes_val_Type_14_teletexString),
        (u'printableString', __SupportedAttributes_val_Type_14_printableString),
        (u'bmpString', __SupportedAttributes_val_Type_14_bmpString),
        (u'universalString', __SupportedAttributes_val_Type_14_universalString),
        (u'uTF8String', __SupportedAttributes_val_Type_14_uTF8String),
        ])
    _SupportedAttributes_val_Type_14._ext = None
    _SupportedAttributes_val_Type_15 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    _SupportedAttributes_val_Type_16 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    _SupportedAttributes_val_Type_16._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    SupportedAttributes._val = ASN1Set(rv=[dict([(u'Type', _SupportedAttributes_val_Type_0), (u'id', (2, 5, 4, 41))]), dict([(u'Type', _SupportedAttributes_val_Type_1), (u'id', (2, 5, 4, 4))]), dict([(u'Type', _SupportedAttributes_val_Type_2), (u'id', (2, 5, 4, 42))]), dict([(u'Type', _SupportedAttributes_val_Type_3), (u'id', (2, 5, 4, 43))]), dict([(u'Type', _SupportedAttributes_val_Type_4), (u'id', (2, 5, 4, 44))]), dict([(u'Type', _SupportedAttributes_val_Type_5), (u'id', (2, 5, 4, 3))]), dict([(u'Type', _SupportedAttributes_val_Type_6), (u'id', (2, 5, 4, 7))]), dict([(u'Type', _SupportedAttributes_val_Type_7), (u'id', (2, 5, 4, 8))]), dict([(u'Type', _SupportedAttributes_val_Type_8), (u'id', (2, 5, 4, 10))]), dict([(u'Type', _SupportedAttributes_val_Type_9), (u'id', (2, 5, 4, 11))]), dict([(u'Type', _SupportedAttributes_val_Type_10), (u'id', (2, 5, 4, 12))]), dict([(u'Type', _SupportedAttributes_val_Type_11), (u'id', (2, 5, 4, 46))]), dict([(u'Type', _SupportedAttributes_val_Type_12), (u'id', (2, 5, 4, 6))]), dict([(u'Type', _SupportedAttributes_val_Type_13), (u'id', (2, 5, 4, 5))]), dict([(u'Type', _SupportedAttributes_val_Type_14), (u'id', (2, 5, 4, 65))]), dict([(u'Type', _SupportedAttributes_val_Type_15), (u'id', (0, 9, 2342, 19200300, 100, 1, 25))]), dict([(u'Type', _SupportedAttributes_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 9, 1))])], rr=[], ev=[], er=[])
    
    #-----< Certificate >-----#
    Certificate = SEQ(name=u'Certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'SIGNED')))
    _Certificate_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'TBSCertificate')))
    _Certificate_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE)
    __Certificate_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___Certificate_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    __SIGNATURE_ALGORITHM_HashSet_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___Certificate_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_3), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_4), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_5), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_6), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_7), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_8), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_9), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_10), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __Certificate_algorithmIdentifier_algorithm._const_tab = ___Certificate_algorithmIdentifier_algorithm_tab
    __Certificate_algorithmIdentifier_algorithm._const_tab_at = None
    __Certificate_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __Certificate_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __Certificate_algorithmIdentifier_parameters._const_tab = ___Certificate_algorithmIdentifier_algorithm_tab
    __Certificate_algorithmIdentifier_parameters._const_tab_at = ('..', '..', u'algorithmIdentifier', u'algorithm')
    __Certificate_algorithmIdentifier_parameters._const_tab_id = u'Params'
    _Certificate_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __Certificate_algorithmIdentifier_algorithm),
        (u'parameters', __Certificate_algorithmIdentifier_parameters),
        ])
    _Certificate_algorithmIdentifier._ext = None
    _Certificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    __Certificate_signature_contain = OPEN(name='_cont_signature', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Value']))
    __Certificate_signature_contain._const_tab = ___Certificate_algorithmIdentifier_algorithm_tab
    __Certificate_signature_contain._const_tab_at = ('..', u'algorithmIdentifier', u'algorithm')
    __Certificate_signature_contain._const_tab_id = u'Value'
    _Certificate_signature._const_cont = __Certificate_signature_contain
    Certificate._cont = ASN1Dict([
        (u'toBeSigned', _Certificate_toBeSigned),
        (u'algorithmIdentifier', _Certificate_algorithmIdentifier),
        (u'signature', _Certificate_signature),
        ])
    Certificate._ext = None
    
    #-----< TBSCertificate >-----#
    TBSCertificate = SEQ(name=u'TBSCertificate', mode=MODE_TYPE)
    _TBSCertificate_version = INT(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'Version')), default=0)
    _TBSCertificate_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    _TBSCertificate_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __TBSCertificate_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___TBSCertificate_signature_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___TBSCertificate_signature_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_3), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_4), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_5), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_6), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_7), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_8), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_9), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_10), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __TBSCertificate_signature_algorithm._const_tab = ___TBSCertificate_signature_algorithm_tab
    __TBSCertificate_signature_algorithm._const_tab_at = None
    __TBSCertificate_signature_algorithm._const_tab_id = u'id'
    __TBSCertificate_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __TBSCertificate_signature_parameters._const_tab = ___TBSCertificate_signature_algorithm_tab
    __TBSCertificate_signature_parameters._const_tab_at = ('..', u'algorithm')
    __TBSCertificate_signature_parameters._const_tab_id = u'Params'
    _TBSCertificate_signature._cont = ASN1Dict([
        (u'algorithm', __TBSCertificate_signature_algorithm),
        (u'parameters', __TBSCertificate_signature_parameters),
        ])
    _TBSCertificate_signature._ext = None
    _TBSCertificate_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _TBSCertificate_validity = SEQ(name=u'validity', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Validity')))
    _TBSCertificate_subject = CHOICE(name=u'subject', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _TBSCertificate_subjectPublicKeyInfo = SEQ(name=u'subjectPublicKeyInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'SubjectPublicKeyInfo')))
    _TBSCertificate_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'UniqueIdentifier')), opt=True, group=0)
    _TBSCertificate_subjectUniqueID = BIT_STR(name=u'subjectUniqueID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'UniqueIdentifier')), opt=True, group=0)
    _TBSCertificate_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True, group=1)
    __TBSCertificate_extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___TBSCertificate_extensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____TBSCertificate_extensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_1 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_2 = BIT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyUsage')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_3 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PrivateKeyUsagePeriod')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_4 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertificatePolicies')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_5 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyMappings')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_6 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_7 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_8 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectDirectoryAttributes')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_9 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'BasicConstraints')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_10 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'NameConstraints')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_11 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyConstraints')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_12 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'ExtKeyUsageSyntax')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_13 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_14 = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_15 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_16 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_17 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectInfoAccessSyntax')))
    ____TBSCertificate_extensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_0), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_1), (u'id', (2, 5, 29, 14))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 15))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_3), (u'id', (2, 5, 29, 16))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_4), (u'id', (2, 5, 29, 32))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_5), (u'id', (2, 5, 29, 33))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_6), (u'id', (2, 5, 29, 17))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_7), (u'id', (2, 5, 29, 18))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_8), (u'id', (2, 5, 29, 9))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_9), (u'id', (2, 5, 29, 19))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_10), (u'id', (2, 5, 29, 30))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_11), (u'id', (2, 5, 29, 36))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_12), (u'id', (2, 5, 29, 37))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_13), (u'id', (2, 5, 29, 31))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_14), (u'id', (2, 5, 29, 54))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_15), (u'id', (2, 5, 29, 46))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_16), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_17), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 11))])], rr=[], ev=None, er=[])
    ___TBSCertificate_extensions__item__extnID._const_tab = ____TBSCertificate_extensions__item__extnID_tab
    ___TBSCertificate_extensions__item__extnID._const_tab_at = None
    ___TBSCertificate_extensions__item__extnID._const_tab_id = u'id'
    ___TBSCertificate_extensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___TBSCertificate_extensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____TBSCertificate_extensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____TBSCertificate_extensions__item__extnValue_contain._const_tab = ____TBSCertificate_extensions__item__extnID_tab
    ____TBSCertificate_extensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____TBSCertificate_extensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___TBSCertificate_extensions__item__extnValue._const_cont = ____TBSCertificate_extensions__item__extnValue_contain
    __TBSCertificate_extensions__item_._cont = ASN1Dict([
        (u'extnID', ___TBSCertificate_extensions__item__extnID),
        (u'critical', ___TBSCertificate_extensions__item__critical),
        (u'extnValue', ___TBSCertificate_extensions__item__extnValue),
        ])
    __TBSCertificate_extensions__item_._ext = None
    _TBSCertificate_extensions._cont = __TBSCertificate_extensions__item_
    _TBSCertificate_extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    TBSCertificate._cont = ASN1Dict([
        (u'version', _TBSCertificate_version),
        (u'serialNumber', _TBSCertificate_serialNumber),
        (u'signature', _TBSCertificate_signature),
        (u'issuer', _TBSCertificate_issuer),
        (u'validity', _TBSCertificate_validity),
        (u'subject', _TBSCertificate_subject),
        (u'subjectPublicKeyInfo', _TBSCertificate_subjectPublicKeyInfo),
        (u'issuerUniqueID', _TBSCertificate_issuerUniqueID),
        (u'subjectUniqueID', _TBSCertificate_subjectUniqueID),
        (u'extensions', _TBSCertificate_extensions),
        ])
    TBSCertificate._ext = [u'issuerUniqueID', u'subjectUniqueID', u'extensions']
    
    #-----< Version >-----#
    Version = INT(name=u'Version', mode=MODE_TYPE)
    Version._cont = ASN1Dict([(u'v1', 0), (u'v2', 1), (u'v3', 2)])
    
    #-----< CertificateSerialNumber >-----#
    CertificateSerialNumber = INT(name=u'CertificateSerialNumber', mode=MODE_TYPE)
    
    #-----< Validity >-----#
    Validity = SEQ(name=u'Validity', mode=MODE_TYPE)
    _Validity_notBefore = CHOICE(name=u'notBefore', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Time')))
    _Validity_notAfter = CHOICE(name=u'notAfter', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Time')))
    Validity._cont = ASN1Dict([
        (u'notBefore', _Validity_notBefore),
        (u'notAfter', _Validity_notAfter),
        ])
    Validity._ext = None
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalTime = TIME_GEN(name=u'generalTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalTime', _Time_generalTime),
        ])
    Time._ext = None
    
    #-----< UniqueIdentifier >-----#
    UniqueIdentifier = BIT_STR(name=u'UniqueIdentifier', mode=MODE_TYPE)
    
    #-----< SubjectPublicKeyInfo >-----#
    SubjectPublicKeyInfo = SEQ(name=u'SubjectPublicKeyInfo', mode=MODE_TYPE)
    _SubjectPublicKeyInfo_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __SubjectPublicKeyInfo_algorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'id']))
    ___SubjectPublicKeyInfo_algorithm_algorithm_tab = CLASS(name='_tab_PUBLIC-KEY', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_1 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_2 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_2 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_3 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'KEA-Params-Id')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_4 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_4 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_5 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_5 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_6 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_6 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_7 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_7 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_8 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_8 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    ___SubjectPublicKeyInfo_algorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_0), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_1), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_2), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_2), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))]), dict([(u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22)), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_3), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])], rr=[], ev=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_4), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_4), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))]), dict([(u'id', (1, 3, 132, 1, 12)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_5), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_5), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 3, 132, 1, 13)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_6), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_6), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_7), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_7), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_8), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_8), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], er=[])
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab = ___SubjectPublicKeyInfo_algorithm_algorithm_tab
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab_at = None
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab_id = u'id'
    __SubjectPublicKeyInfo_algorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'Params']), opt=True)
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab = ___SubjectPublicKeyInfo_algorithm_algorithm_tab
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab_at = ('..', u'algorithm')
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab_id = u'Params'
    _SubjectPublicKeyInfo_algorithm._cont = ASN1Dict([
        (u'algorithm', __SubjectPublicKeyInfo_algorithm_algorithm),
        (u'parameters', __SubjectPublicKeyInfo_algorithm_parameters),
        ])
    _SubjectPublicKeyInfo_algorithm._ext = None
    _SubjectPublicKeyInfo_subjectPublicKey = BIT_STR(name=u'subjectPublicKey', mode=MODE_TYPE)
    SubjectPublicKeyInfo._cont = ASN1Dict([
        (u'algorithm', _SubjectPublicKeyInfo_algorithm),
        (u'subjectPublicKey', _SubjectPublicKeyInfo_subjectPublicKey),
        ])
    SubjectPublicKeyInfo._ext = None
    
    #-----< CertificateList >-----#
    CertificateList = SEQ(name=u'CertificateList', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'SIGNED')))
    _CertificateList_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'TBSCertList')))
    _CertificateList_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE)
    __CertificateList_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___CertificateList_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___CertificateList_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_3), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_4), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_5), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_6), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_7), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_8), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_9), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_10), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __CertificateList_algorithmIdentifier_algorithm._const_tab = ___CertificateList_algorithmIdentifier_algorithm_tab
    __CertificateList_algorithmIdentifier_algorithm._const_tab_at = None
    __CertificateList_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __CertificateList_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __CertificateList_algorithmIdentifier_parameters._const_tab = ___CertificateList_algorithmIdentifier_algorithm_tab
    __CertificateList_algorithmIdentifier_parameters._const_tab_at = ('..', '..', u'algorithmIdentifier', u'algorithm')
    __CertificateList_algorithmIdentifier_parameters._const_tab_id = u'Params'
    _CertificateList_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __CertificateList_algorithmIdentifier_algorithm),
        (u'parameters', __CertificateList_algorithmIdentifier_parameters),
        ])
    _CertificateList_algorithmIdentifier._ext = None
    _CertificateList_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    __CertificateList_signature_contain = OPEN(name='_cont_signature', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Value']))
    __CertificateList_signature_contain._const_tab = ___CertificateList_algorithmIdentifier_algorithm_tab
    __CertificateList_signature_contain._const_tab_at = ('..', u'algorithmIdentifier', u'algorithm')
    __CertificateList_signature_contain._const_tab_id = u'Value'
    _CertificateList_signature._const_cont = __CertificateList_signature_contain
    CertificateList._cont = ASN1Dict([
        (u'toBeSigned', _CertificateList_toBeSigned),
        (u'algorithmIdentifier', _CertificateList_algorithmIdentifier),
        (u'signature', _CertificateList_signature),
        ])
    CertificateList._ext = None
    
    #-----< TBSCertList >-----#
    TBSCertList = SEQ(name=u'TBSCertList', mode=MODE_TYPE)
    _TBSCertList_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Version')), opt=True)
    _TBSCertList_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __TBSCertList_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___TBSCertList_signature_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____TBSCertList_signature_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___TBSCertList_signature_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_3), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_4), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_5), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_6), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_7), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_8), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_9), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_10), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __TBSCertList_signature_algorithm._const_tab = ___TBSCertList_signature_algorithm_tab
    __TBSCertList_signature_algorithm._const_tab_at = None
    __TBSCertList_signature_algorithm._const_tab_id = u'id'
    __TBSCertList_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __TBSCertList_signature_parameters._const_tab = ___TBSCertList_signature_algorithm_tab
    __TBSCertList_signature_parameters._const_tab_at = ('..', u'algorithm')
    __TBSCertList_signature_parameters._const_tab_id = u'Params'
    _TBSCertList_signature._cont = ASN1Dict([
        (u'algorithm', __TBSCertList_signature_algorithm),
        (u'parameters', __TBSCertList_signature_parameters),
        ])
    _TBSCertList_signature._ext = None
    _TBSCertList_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _TBSCertList_thisUpdate = CHOICE(name=u'thisUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Time')))
    _TBSCertList_nextUpdate = CHOICE(name=u'nextUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Time')), opt=True)
    _TBSCertList_revokedCertificates = SEQ_OF(name=u'revokedCertificates', mode=MODE_TYPE, opt=True)
    __TBSCertList_revokedCertificates__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ___TBSCertList_revokedCertificates__item__userCertificate = INT(name=u'userCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    ___TBSCertList_revokedCertificates__item__revocationDate = CHOICE(name=u'revocationDate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Time')))
    ___TBSCertList_revokedCertificates__item__crlEntryExtensions = SEQ_OF(name=u'crlEntryExtensions', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True, group=0)
    ____TBSCertList_revokedCertificates__item__crlEntryExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_0 = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLReason')))
    _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_2 = OID(name=u'ExtnType', mode=MODE_TYPE)
    _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_3 = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_0), (u'id', (2, 5, 29, 21))]), dict([(u'ExtnType', _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_1), (u'id', (2, 5, 29, 29))]), dict([(u'ExtnType', _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 23))]), dict([(u'ExtnType', _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_3), (u'id', (2, 5, 29, 24))])], rr=[], ev=None, er=[])
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID._const_tab = ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID._const_tab_at = None
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID._const_tab_id = u'id'
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain._const_tab = ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue._const_cont = ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain
    ____TBSCertList_revokedCertificates__item__crlEntryExtensions__item_._cont = ASN1Dict([
        (u'extnID', _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID),
        (u'critical', _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__critical),
        (u'extnValue', _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue),
        ])
    ____TBSCertList_revokedCertificates__item__crlEntryExtensions__item_._ext = None
    ___TBSCertList_revokedCertificates__item__crlEntryExtensions._cont = ____TBSCertList_revokedCertificates__item__crlEntryExtensions__item_
    ___TBSCertList_revokedCertificates__item__crlEntryExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __TBSCertList_revokedCertificates__item_._cont = ASN1Dict([
        (u'userCertificate', ___TBSCertList_revokedCertificates__item__userCertificate),
        (u'revocationDate', ___TBSCertList_revokedCertificates__item__revocationDate),
        (u'crlEntryExtensions', ___TBSCertList_revokedCertificates__item__crlEntryExtensions),
        ])
    __TBSCertList_revokedCertificates__item_._ext = [u'crlEntryExtensions']
    _TBSCertList_revokedCertificates._cont = __TBSCertList_revokedCertificates__item_
    _TBSCertList_revokedCertificates._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _TBSCertList_crlExtensions = SEQ_OF(name=u'crlExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True, group=0)
    __TBSCertList_crlExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___TBSCertList_crlExtensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____TBSCertList_crlExtensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_2 = INT(name=u'ExtnType', mode=MODE_TYPE)
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_3 = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLNumber')))
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_4 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'IssuingDistributionPoint')))
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_5 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    ____TBSCertList_crlExtensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_0), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_1), (u'id', (2, 5, 29, 18))]), dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 20))]), dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_3), (u'id', (2, 5, 29, 27))]), dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_4), (u'id', (2, 5, 29, 28))]), dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_5), (u'id', (2, 5, 29, 46))])], rr=[], ev=None, er=[])
    ___TBSCertList_crlExtensions__item__extnID._const_tab = ____TBSCertList_crlExtensions__item__extnID_tab
    ___TBSCertList_crlExtensions__item__extnID._const_tab_at = None
    ___TBSCertList_crlExtensions__item__extnID._const_tab_id = u'id'
    ___TBSCertList_crlExtensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___TBSCertList_crlExtensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____TBSCertList_crlExtensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____TBSCertList_crlExtensions__item__extnValue_contain._const_tab = ____TBSCertList_crlExtensions__item__extnID_tab
    ____TBSCertList_crlExtensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____TBSCertList_crlExtensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___TBSCertList_crlExtensions__item__extnValue._const_cont = ____TBSCertList_crlExtensions__item__extnValue_contain
    __TBSCertList_crlExtensions__item_._cont = ASN1Dict([
        (u'extnID', ___TBSCertList_crlExtensions__item__extnID),
        (u'critical', ___TBSCertList_crlExtensions__item__critical),
        (u'extnValue', ___TBSCertList_crlExtensions__item__extnValue),
        ])
    __TBSCertList_crlExtensions__item_._ext = None
    _TBSCertList_crlExtensions._cont = __TBSCertList_crlExtensions__item_
    _TBSCertList_crlExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    TBSCertList._cont = ASN1Dict([
        (u'version', _TBSCertList_version),
        (u'signature', _TBSCertList_signature),
        (u'issuer', _TBSCertList_issuer),
        (u'thisUpdate', _TBSCertList_thisUpdate),
        (u'nextUpdate', _TBSCertList_nextUpdate),
        (u'revokedCertificates', _TBSCertList_revokedCertificates),
        (u'crlExtensions', _TBSCertList_crlExtensions),
        ])
    TBSCertList._ext = [u'crlExtensions']
    
    #-----< SignatureAlgorithms >-----#
    SignatureAlgorithms = CLASS(name=u'SignatureAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _SignatureAlgorithms_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    SignatureAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', _SignatureAlgorithms_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', _SignatureAlgorithms_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', _SignatureAlgorithms_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', _SignatureAlgorithms_val_Value_3), (u'Params', _SignatureAlgorithms_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', _SignatureAlgorithms_val_Value_4), (u'Params', _SignatureAlgorithms_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', _SignatureAlgorithms_val_Value_5), (u'Params', _SignatureAlgorithms_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', _SignatureAlgorithms_val_Value_6), (u'Params', _SignatureAlgorithms_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', _SignatureAlgorithms_val_Value_7), (u'Params', _SignatureAlgorithms_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', _SignatureAlgorithms_val_Value_8), (u'Params', _SignatureAlgorithms_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', _SignatureAlgorithms_val_Value_9), (u'Params', _SignatureAlgorithms_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', _SignatureAlgorithms_val_Value_10), (u'Params', _SignatureAlgorithms_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', _SignatureAlgorithms_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    
    #-----< PublicKeyAlgorithms >-----#
    PublicKeyAlgorithms = CLASS(name=u'PublicKeyAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _PublicKeyAlgorithms_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeyAlgorithms_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _PublicKeyAlgorithms_val_KeyValue_1 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    _PublicKeyAlgorithms_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    _PublicKeyAlgorithms_val_KeyValue_2 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _PublicKeyAlgorithms_val_Params_2 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    _PublicKeyAlgorithms_val_Params_3 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'KEA-Params-Id')))
    _PublicKeyAlgorithms_val_KeyValue_4 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeyAlgorithms_val_Params_4 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _PublicKeyAlgorithms_val_KeyValue_5 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeyAlgorithms_val_Params_5 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _PublicKeyAlgorithms_val_KeyValue_6 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeyAlgorithms_val_Params_6 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _PublicKeyAlgorithms_val_KeyValue_7 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeyAlgorithms_val_Params_7 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    _PublicKeyAlgorithms_val_KeyValue_8 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeyAlgorithms_val_Params_8 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    PublicKeyAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_0), (u'Params', _PublicKeyAlgorithms_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_1), (u'Params', _PublicKeyAlgorithms_val_Params_1), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_2), (u'Params', _PublicKeyAlgorithms_val_Params_2), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))]), dict([(u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22)), (u'Params', _PublicKeyAlgorithms_val_Params_3), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])], rr=[], ev=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_4), (u'Params', _PublicKeyAlgorithms_val_Params_4), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))]), dict([(u'id', (1, 3, 132, 1, 12)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_5), (u'Params', _PublicKeyAlgorithms_val_Params_5), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 3, 132, 1, 13)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_6), (u'Params', _PublicKeyAlgorithms_val_Params_6), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_7), (u'Params', _PublicKeyAlgorithms_val_Params_7), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_8), (u'Params', _PublicKeyAlgorithms_val_Params_8), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], er=[])
    
    #-----< ub-state-name >-----#
    ub_state_name = INT(name=u'ub-state-name', mode=MODE_VALUE)
    ub_state_name._val = 128
    
    #-----< ub-organization-name >-----#
    ub_organization_name = INT(name=u'ub-organization-name', mode=MODE_VALUE)
    ub_organization_name._val = 64
    
    #-----< ub-organizational-unit-name >-----#
    ub_organizational_unit_name = INT(name=u'ub-organizational-unit-name', mode=MODE_VALUE)
    ub_organizational_unit_name._val = 64
    
    #-----< ub-title >-----#
    ub_title = INT(name=u'ub-title', mode=MODE_VALUE)
    ub_title._val = 64
    
    #-----< ub-serial-number >-----#
    ub_serial_number = INT(name=u'ub-serial-number', mode=MODE_VALUE)
    ub_serial_number._val = 64
    
    #-----< ub-pseudonym >-----#
    ub_pseudonym = INT(name=u'ub-pseudonym', mode=MODE_VALUE)
    ub_pseudonym._val = 128
    
    #-----< ub-emailaddress-length >-----#
    ub_emailaddress_length = INT(name=u'ub-emailaddress-length', mode=MODE_VALUE)
    ub_emailaddress_length._val = 255
    
    #-----< ub-locality-name >-----#
    ub_locality_name = INT(name=u'ub-locality-name', mode=MODE_VALUE)
    ub_locality_name._val = 128
    
    #-----< ub-common-name >-----#
    ub_common_name = INT(name=u'ub-common-name', mode=MODE_VALUE)
    ub_common_name._val = 64
    
    #-----< ub-name >-----#
    ub_name = INT(name=u'ub-name', mode=MODE_VALUE)
    ub_name._val = 32768
    
    #-----< SIGNED >-----#
    SIGNED = SEQ(name=u'SIGNED', mode=MODE_TYPE, param=True)
    
    _all_ = [
        id_pkix,
        id_pe,
        id_qt,
        id_kp,
        id_ad,
        id_qt_cps,
        id_qt_unotice,
        id_ad_ocsp,
        id_ad_caIssuers,
        id_ad_timeStamping,
        id_ad_caRepository,
        AttributeType,
        id_at,
        id_at_name,
        at_name,
        _at_name_val_Type,
        id_at_surname,
        at_surname,
        _at_surname_val_Type,
        id_at_givenName,
        at_givenName,
        _at_givenName_val_Type,
        id_at_initials,
        at_initials,
        _at_initials_val_Type,
        id_at_generationQualifier,
        at_generationQualifier,
        _at_generationQualifier_val_Type,
        _X520name_teletexString,
        _X520name_printableString,
        _X520name_bmpString,
        _X520name_universalString,
        _X520name_uTF8String,
        X520name,
        id_at_commonName,
        at_x520CommonName,
        _at_x520CommonName_val_Type,
        _X520CommonName_teletexString,
        _X520CommonName_printableString,
        _X520CommonName_bmpString,
        _X520CommonName_universalString,
        _X520CommonName_uTF8String,
        X520CommonName,
        id_at_localityName,
        at_x520LocalityName,
        _at_x520LocalityName_val_Type,
        _X520LocalityName_teletexString,
        _X520LocalityName_printableString,
        _X520LocalityName_bmpString,
        _X520LocalityName_universalString,
        _X520LocalityName_uTF8String,
        X520LocalityName,
        id_at_stateOrProvinceName,
        at_x520StateOrProvinceName,
        __at_x520StateOrProvinceName_val_Type_teletexString,
        __at_x520StateOrProvinceName_val_Type_printableString,
        __at_x520StateOrProvinceName_val_Type_bmpString,
        __at_x520StateOrProvinceName_val_Type_universalString,
        __at_x520StateOrProvinceName_val_Type_uTF8String,
        _at_x520StateOrProvinceName_val_Type,
        _X520StateOrProvinceName_teletexString,
        _X520StateOrProvinceName_printableString,
        _X520StateOrProvinceName_bmpString,
        _X520StateOrProvinceName_universalString,
        _X520StateOrProvinceName_uTF8String,
        X520StateOrProvinceName,
        id_at_organizationName,
        at_x520OrganizationName,
        __at_x520OrganizationName_val_Type_teletexString,
        __at_x520OrganizationName_val_Type_printableString,
        __at_x520OrganizationName_val_Type_bmpString,
        __at_x520OrganizationName_val_Type_universalString,
        __at_x520OrganizationName_val_Type_uTF8String,
        _at_x520OrganizationName_val_Type,
        _X520OrganizationName_teletexString,
        _X520OrganizationName_printableString,
        _X520OrganizationName_bmpString,
        _X520OrganizationName_universalString,
        _X520OrganizationName_uTF8String,
        X520OrganizationName,
        id_at_organizationalUnitName,
        at_x520OrganizationalUnitName,
        __at_x520OrganizationalUnitName_val_Type_teletexString,
        __at_x520OrganizationalUnitName_val_Type_printableString,
        __at_x520OrganizationalUnitName_val_Type_bmpString,
        __at_x520OrganizationalUnitName_val_Type_universalString,
        __at_x520OrganizationalUnitName_val_Type_uTF8String,
        _at_x520OrganizationalUnitName_val_Type,
        _X520OrganizationalUnitName_teletexString,
        _X520OrganizationalUnitName_printableString,
        _X520OrganizationalUnitName_bmpString,
        _X520OrganizationalUnitName_universalString,
        _X520OrganizationalUnitName_uTF8String,
        X520OrganizationalUnitName,
        id_at_title,
        at_x520Title,
        __at_x520Title_val_Type_teletexString,
        __at_x520Title_val_Type_printableString,
        __at_x520Title_val_Type_bmpString,
        __at_x520Title_val_Type_universalString,
        __at_x520Title_val_Type_uTF8String,
        _at_x520Title_val_Type,
        id_at_dnQualifier,
        at_x520dnQualifier,
        _at_x520dnQualifier_val_Type,
        id_at_countryName,
        at_x520countryName,
        _at_x520countryName_val_Type,
        id_at_serialNumber,
        at_x520SerialNumber,
        _at_x520SerialNumber_val_Type,
        id_at_pseudonym,
        at_x520Pseudonym,
        __at_x520Pseudonym_val_Type_teletexString,
        __at_x520Pseudonym_val_Type_printableString,
        __at_x520Pseudonym_val_Type_bmpString,
        __at_x520Pseudonym_val_Type_universalString,
        __at_x520Pseudonym_val_Type_uTF8String,
        _at_x520Pseudonym_val_Type,
        id_domainComponent,
        at_domainComponent,
        _at_domainComponent_val_Type,
        pkcs_9,
        id_emailAddress,
        at_emailAddress,
        _at_emailAddress_val_Type,
        _Name_rdnSequence,
        Name,
        _RDNSequence__item_,
        RDNSequence,
        DistinguishedName,
        ___RelativeDistinguishedName__item__type_tab,
        ____RelativeDistinguishedName__item__type_tab_val_Type_0,
        ____RelativeDistinguishedName__item__type_tab_val_Type_1,
        ____RelativeDistinguishedName__item__type_tab_val_Type_2,
        ____RelativeDistinguishedName__item__type_tab_val_Type_3,
        ____RelativeDistinguishedName__item__type_tab_val_Type_4,
        ____RelativeDistinguishedName__item__type_tab_val_Type_5,
        ____RelativeDistinguishedName__item__type_tab_val_Type_6,
        _____RelativeDistinguishedName__item__type_tab_val_Type_7_teletexString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_7_printableString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_7_bmpString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_7_universalString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_7_uTF8String,
        ____RelativeDistinguishedName__item__type_tab_val_Type_7,
        _____RelativeDistinguishedName__item__type_tab_val_Type_8_teletexString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_8_printableString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_8_bmpString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_8_universalString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_8_uTF8String,
        ____RelativeDistinguishedName__item__type_tab_val_Type_8,
        _____RelativeDistinguishedName__item__type_tab_val_Type_9_teletexString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_9_printableString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_9_bmpString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_9_universalString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_9_uTF8String,
        ____RelativeDistinguishedName__item__type_tab_val_Type_9,
        _____RelativeDistinguishedName__item__type_tab_val_Type_10_teletexString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_10_printableString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_10_bmpString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_10_universalString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_10_uTF8String,
        ____RelativeDistinguishedName__item__type_tab_val_Type_10,
        ____RelativeDistinguishedName__item__type_tab_val_Type_11,
        ____RelativeDistinguishedName__item__type_tab_val_Type_12,
        ____RelativeDistinguishedName__item__type_tab_val_Type_13,
        _____RelativeDistinguishedName__item__type_tab_val_Type_14_teletexString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_14_printableString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_14_bmpString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_14_universalString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_14_uTF8String,
        ____RelativeDistinguishedName__item__type_tab_val_Type_14,
        ____RelativeDistinguishedName__item__type_tab_val_Type_15,
        ____RelativeDistinguishedName__item__type_tab_val_Type_16,
        __RelativeDistinguishedName__item__type,
        __RelativeDistinguishedName__item__value,
        _RelativeDistinguishedName__item_,
        RelativeDistinguishedName,
        SupportedAttributes,
        _SupportedAttributes_val_Type_0,
        _SupportedAttributes_val_Type_1,
        _SupportedAttributes_val_Type_2,
        _SupportedAttributes_val_Type_3,
        _SupportedAttributes_val_Type_4,
        _SupportedAttributes_val_Type_5,
        _SupportedAttributes_val_Type_6,
        __SupportedAttributes_val_Type_7_teletexString,
        __SupportedAttributes_val_Type_7_printableString,
        __SupportedAttributes_val_Type_7_bmpString,
        __SupportedAttributes_val_Type_7_universalString,
        __SupportedAttributes_val_Type_7_uTF8String,
        _SupportedAttributes_val_Type_7,
        __SupportedAttributes_val_Type_8_teletexString,
        __SupportedAttributes_val_Type_8_printableString,
        __SupportedAttributes_val_Type_8_bmpString,
        __SupportedAttributes_val_Type_8_universalString,
        __SupportedAttributes_val_Type_8_uTF8String,
        _SupportedAttributes_val_Type_8,
        __SupportedAttributes_val_Type_9_teletexString,
        __SupportedAttributes_val_Type_9_printableString,
        __SupportedAttributes_val_Type_9_bmpString,
        __SupportedAttributes_val_Type_9_universalString,
        __SupportedAttributes_val_Type_9_uTF8String,
        _SupportedAttributes_val_Type_9,
        __SupportedAttributes_val_Type_10_teletexString,
        __SupportedAttributes_val_Type_10_printableString,
        __SupportedAttributes_val_Type_10_bmpString,
        __SupportedAttributes_val_Type_10_universalString,
        __SupportedAttributes_val_Type_10_uTF8String,
        _SupportedAttributes_val_Type_10,
        _SupportedAttributes_val_Type_11,
        _SupportedAttributes_val_Type_12,
        _SupportedAttributes_val_Type_13,
        __SupportedAttributes_val_Type_14_teletexString,
        __SupportedAttributes_val_Type_14_printableString,
        __SupportedAttributes_val_Type_14_bmpString,
        __SupportedAttributes_val_Type_14_universalString,
        __SupportedAttributes_val_Type_14_uTF8String,
        _SupportedAttributes_val_Type_14,
        _SupportedAttributes_val_Type_15,
        _SupportedAttributes_val_Type_16,
        _Certificate_toBeSigned,
        ___Certificate_algorithmIdentifier_algorithm_tab,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_1,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_2,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_3,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_3,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_4,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_5,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_5,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_6,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_6,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_7,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_7,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_8,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_8,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_9,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_9,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_10,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_10,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_11,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_1,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_2,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_3,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1,
        __Certificate_algorithmIdentifier_algorithm,
        __Certificate_algorithmIdentifier_parameters,
        _Certificate_algorithmIdentifier,
        __Certificate_signature_contain,
        _Certificate_signature,
        Certificate,
        _TBSCertificate_version,
        _TBSCertificate_serialNumber,
        ___TBSCertificate_signature_algorithm_tab,
        ____TBSCertificate_signature_algorithm_tab_val_Params_0,
        ____TBSCertificate_signature_algorithm_tab_val_Params_1,
        ____TBSCertificate_signature_algorithm_tab_val_Params_2,
        ____TBSCertificate_signature_algorithm_tab_val_Value_3,
        ____TBSCertificate_signature_algorithm_tab_val_Params_3,
        ____TBSCertificate_signature_algorithm_tab_val_Value_4,
        ____TBSCertificate_signature_algorithm_tab_val_Params_4,
        ____TBSCertificate_signature_algorithm_tab_val_Value_5,
        ____TBSCertificate_signature_algorithm_tab_val_Params_5,
        ____TBSCertificate_signature_algorithm_tab_val_Value_6,
        ____TBSCertificate_signature_algorithm_tab_val_Params_6,
        ____TBSCertificate_signature_algorithm_tab_val_Value_7,
        ____TBSCertificate_signature_algorithm_tab_val_Params_7,
        ____TBSCertificate_signature_algorithm_tab_val_Value_8,
        ____TBSCertificate_signature_algorithm_tab_val_Params_8,
        ____TBSCertificate_signature_algorithm_tab_val_Value_9,
        ____TBSCertificate_signature_algorithm_tab_val_Params_9,
        ____TBSCertificate_signature_algorithm_tab_val_Value_10,
        ____TBSCertificate_signature_algorithm_tab_val_Params_10,
        ____TBSCertificate_signature_algorithm_tab_val_Params_11,
        __TBSCertificate_signature_algorithm,
        __TBSCertificate_signature_parameters,
        _TBSCertificate_signature,
        _TBSCertificate_issuer,
        _TBSCertificate_validity,
        _TBSCertificate_subject,
        _TBSCertificate_subjectPublicKeyInfo,
        _TBSCertificate_issuerUniqueID,
        _TBSCertificate_subjectUniqueID,
        ____TBSCertificate_extensions__item__extnID_tab,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_0,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_1,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_2,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_3,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_4,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_5,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_6,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_7,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_8,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_9,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_10,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_11,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_12,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_13,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_14,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_15,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_16,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_17,
        ___TBSCertificate_extensions__item__extnID,
        ___TBSCertificate_extensions__item__critical,
        ____TBSCertificate_extensions__item__extnValue_contain,
        ___TBSCertificate_extensions__item__extnValue,
        __TBSCertificate_extensions__item_,
        _TBSCertificate_extensions,
        TBSCertificate,
        Version,
        CertificateSerialNumber,
        _Validity_notBefore,
        _Validity_notAfter,
        Validity,
        _Time_utcTime,
        _Time_generalTime,
        Time,
        UniqueIdentifier,
        ___SubjectPublicKeyInfo_algorithm_algorithm_tab,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_0,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_0,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_1,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_1,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_2,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_2,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_3,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_4,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_4,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_5,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_5,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_6,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_6,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_7,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_7,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_8,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_8,
        __SubjectPublicKeyInfo_algorithm_algorithm,
        __SubjectPublicKeyInfo_algorithm_parameters,
        _SubjectPublicKeyInfo_algorithm,
        _SubjectPublicKeyInfo_subjectPublicKey,
        SubjectPublicKeyInfo,
        _CertificateList_toBeSigned,
        ___CertificateList_algorithmIdentifier_algorithm_tab,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_0,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_1,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_2,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_3,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_3,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_4,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_4,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_5,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_5,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_6,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_6,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_7,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_7,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_8,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_8,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_9,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_9,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_10,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_10,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_11,
        __CertificateList_algorithmIdentifier_algorithm,
        __CertificateList_algorithmIdentifier_parameters,
        _CertificateList_algorithmIdentifier,
        __CertificateList_signature_contain,
        _CertificateList_signature,
        CertificateList,
        _TBSCertList_version,
        ___TBSCertList_signature_algorithm_tab,
        ____TBSCertList_signature_algorithm_tab_val_Params_0,
        ____TBSCertList_signature_algorithm_tab_val_Params_1,
        ____TBSCertList_signature_algorithm_tab_val_Params_2,
        ____TBSCertList_signature_algorithm_tab_val_Value_3,
        ____TBSCertList_signature_algorithm_tab_val_Params_3,
        ____TBSCertList_signature_algorithm_tab_val_Value_4,
        ____TBSCertList_signature_algorithm_tab_val_Params_4,
        ____TBSCertList_signature_algorithm_tab_val_Value_5,
        ____TBSCertList_signature_algorithm_tab_val_Params_5,
        ____TBSCertList_signature_algorithm_tab_val_Value_6,
        ____TBSCertList_signature_algorithm_tab_val_Params_6,
        ____TBSCertList_signature_algorithm_tab_val_Value_7,
        ____TBSCertList_signature_algorithm_tab_val_Params_7,
        ____TBSCertList_signature_algorithm_tab_val_Value_8,
        ____TBSCertList_signature_algorithm_tab_val_Params_8,
        ____TBSCertList_signature_algorithm_tab_val_Value_9,
        ____TBSCertList_signature_algorithm_tab_val_Params_9,
        ____TBSCertList_signature_algorithm_tab_val_Value_10,
        ____TBSCertList_signature_algorithm_tab_val_Params_10,
        ____TBSCertList_signature_algorithm_tab_val_Params_11,
        __TBSCertList_signature_algorithm,
        __TBSCertList_signature_parameters,
        _TBSCertList_signature,
        _TBSCertList_issuer,
        _TBSCertList_thisUpdate,
        _TBSCertList_nextUpdate,
        ___TBSCertList_revokedCertificates__item__userCertificate,
        ___TBSCertList_revokedCertificates__item__revocationDate,
        ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab,
        _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_0,
        _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_1,
        _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_2,
        _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_3,
        _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID,
        _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__critical,
        ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain,
        _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue,
        ____TBSCertList_revokedCertificates__item__crlEntryExtensions__item_,
        ___TBSCertList_revokedCertificates__item__crlEntryExtensions,
        __TBSCertList_revokedCertificates__item_,
        _TBSCertList_revokedCertificates,
        ____TBSCertList_crlExtensions__item__extnID_tab,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_0,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_1,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_2,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_3,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_4,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_5,
        ___TBSCertList_crlExtensions__item__extnID,
        ___TBSCertList_crlExtensions__item__critical,
        ____TBSCertList_crlExtensions__item__extnValue_contain,
        ___TBSCertList_crlExtensions__item__extnValue,
        __TBSCertList_crlExtensions__item_,
        _TBSCertList_crlExtensions,
        TBSCertList,
        SignatureAlgorithms,
        _SignatureAlgorithms_val_Params_0,
        _SignatureAlgorithms_val_Params_1,
        _SignatureAlgorithms_val_Params_2,
        _SignatureAlgorithms_val_Value_3,
        _SignatureAlgorithms_val_Params_3,
        _SignatureAlgorithms_val_Value_4,
        _SignatureAlgorithms_val_Params_4,
        _SignatureAlgorithms_val_Value_5,
        _SignatureAlgorithms_val_Params_5,
        _SignatureAlgorithms_val_Value_6,
        _SignatureAlgorithms_val_Params_6,
        _SignatureAlgorithms_val_Value_7,
        _SignatureAlgorithms_val_Params_7,
        _SignatureAlgorithms_val_Value_8,
        _SignatureAlgorithms_val_Params_8,
        _SignatureAlgorithms_val_Value_9,
        _SignatureAlgorithms_val_Params_9,
        _SignatureAlgorithms_val_Value_10,
        _SignatureAlgorithms_val_Params_10,
        _SignatureAlgorithms_val_Params_11,
        PublicKeyAlgorithms,
        _PublicKeyAlgorithms_val_KeyValue_0,
        _PublicKeyAlgorithms_val_Params_0,
        _PublicKeyAlgorithms_val_KeyValue_1,
        _PublicKeyAlgorithms_val_Params_1,
        _PublicKeyAlgorithms_val_KeyValue_2,
        _PublicKeyAlgorithms_val_Params_2,
        _PublicKeyAlgorithms_val_Params_3,
        _PublicKeyAlgorithms_val_KeyValue_4,
        _PublicKeyAlgorithms_val_Params_4,
        _PublicKeyAlgorithms_val_KeyValue_5,
        _PublicKeyAlgorithms_val_Params_5,
        _PublicKeyAlgorithms_val_KeyValue_6,
        _PublicKeyAlgorithms_val_Params_6,
        _PublicKeyAlgorithms_val_KeyValue_7,
        _PublicKeyAlgorithms_val_Params_7,
        _PublicKeyAlgorithms_val_KeyValue_8,
        _PublicKeyAlgorithms_val_Params_8,
        ub_state_name,
        ub_organization_name,
        ub_organizational_unit_name,
        ub_title,
        ub_serial_number,
        ub_pseudonym,
        ub_emailaddress_length,
        ub_locality_name,
        ub_common_name,
        ub_name,
    ]

class PKIX1Implicit_2009:

    _name_  = u'PKIX1Implicit-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 59]
    
    _obj_ = [
        u'CertExtensions',
        u'CrlExtensions',
        u'CrlEntryExtensions',
        u'id-ce',
        u'ext-AuthorityKeyIdentifier',
        u'id-ce-authorityKeyIdentifier',
        u'AuthorityKeyIdentifier',
        u'KeyIdentifier',
        u'ext-SubjectKeyIdentifier',
        u'id-ce-subjectKeyIdentifier',
        u'ext-KeyUsage',
        u'id-ce-keyUsage',
        u'KeyUsage',
        u'ext-PrivateKeyUsagePeriod',
        u'id-ce-privateKeyUsagePeriod',
        u'PrivateKeyUsagePeriod',
        u'ext-CertificatePolicies',
        u'id-ce-certificatePolicies',
        u'CertificatePolicies',
        u'PolicyInformation',
        u'CertPolicyId',
        u'CERT-POLICY-QUALIFIER',
        u'PolicyQualifierInfo',
        u'PolicyQualifierId',
        u'pqid-cps',
        u'pqid-unotice',
        u'CPSuri',
        u'UserNotice',
        u'NoticeReference',
        u'DisplayText',
        u'ext-PolicyMappings',
        u'id-ce-policyMappings',
        u'PolicyMappings',
        u'ext-SubjectAltName',
        u'id-ce-subjectAltName',
        u'GeneralNames',
        u'GeneralName',
        u'OTHER-NAME',
        u'EDIPartyName',
        u'ext-IssuerAltName',
        u'id-ce-issuerAltName',
        u'ext-SubjectDirectoryAttributes',
        u'id-ce-subjectDirectoryAttributes',
        u'SubjectDirectoryAttributes',
        u'ext-BasicConstraints',
        u'id-ce-basicConstraints',
        u'BasicConstraints',
        u'ext-NameConstraints',
        u'id-ce-nameConstraints',
        u'NameConstraints',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'ext-PolicyConstraints',
        u'id-ce-policyConstraints',
        u'PolicyConstraints',
        u'SkipCerts',
        u'ext-CRLDistributionPoints',
        u'id-ce-cRLDistributionPoints',
        u'CRLDistributionPoints',
        u'DistributionPoint',
        u'DistributionPointName',
        u'ReasonFlags',
        u'ext-ExtKeyUsage',
        u'id-ce-extKeyUsage',
        u'ExtKeyUsageSyntax',
        u'KeyPurposeId',
        u'anyExtendedKeyUsage',
        u'id-kp-serverAuth',
        u'id-kp-clientAuth',
        u'id-kp-codeSigning',
        u'id-kp-emailProtection',
        u'id-kp-timeStamping',
        u'id-kp-OCSPSigning',
        u'ext-InhibitAnyPolicy',
        u'id-ce-inhibitAnyPolicy',
        u'ext-FreshestCRL',
        u'id-ce-freshestCRL',
        u'ext-AuthorityInfoAccess',
        u'id-pe-authorityInfoAccess',
        u'AuthorityInfoAccessSyntax',
        u'AccessDescription',
        u'ext-SubjectInfoAccessSyntax',
        u'id-pe-subjectInfoAccess',
        u'SubjectInfoAccessSyntax',
        u'ext-CRLNumber',
        u'id-ce-cRLNumber',
        u'CRLNumber',
        u'ext-IssuingDistributionPoint',
        u'id-ce-issuingDistributionPoint',
        u'IssuingDistributionPoint',
        u'ext-DeltaCRLIndicator',
        u'id-ce-deltaCRLIndicator',
        u'ext-CRLReason',
        u'id-ce-cRLReasons',
        u'CRLReason',
        u'ext-CertificateIssuer',
        u'id-ce-certificateIssuer',
        u'ext-HoldInstructionCode',
        u'id-ce-holdInstructionCode',
        u'holdInstruction',
        u'id-holdinstruction-none',
        u'id-holdinstruction-callissuer',
        u'id-holdinstruction-reject',
        u'ext-InvalidityDate',
        u'id-ce-invalidityDate',
        u'ubMax',
        ]
    _type_ = [
        u'AuthorityKeyIdentifier',
        u'KeyIdentifier',
        u'KeyUsage',
        u'PrivateKeyUsagePeriod',
        u'CertificatePolicies',
        u'PolicyInformation',
        u'CertPolicyId',
        u'CERT-POLICY-QUALIFIER',
        u'PolicyQualifierInfo',
        u'CPSuri',
        u'UserNotice',
        u'NoticeReference',
        u'DisplayText',
        u'PolicyMappings',
        u'GeneralNames',
        u'GeneralName',
        u'OTHER-NAME',
        u'EDIPartyName',
        u'SubjectDirectoryAttributes',
        u'BasicConstraints',
        u'NameConstraints',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'PolicyConstraints',
        u'SkipCerts',
        u'CRLDistributionPoints',
        u'DistributionPoint',
        u'DistributionPointName',
        u'ReasonFlags',
        u'ExtKeyUsageSyntax',
        u'KeyPurposeId',
        u'AuthorityInfoAccessSyntax',
        u'AccessDescription',
        u'SubjectInfoAccessSyntax',
        u'CRLNumber',
        u'IssuingDistributionPoint',
        u'CRLReason',
        ]
    _set_ = [
        u'CertExtensions',
        u'CrlExtensions',
        u'CrlEntryExtensions',
        u'PolicyQualifierId',
        ]
    _val_ = [
        u'id-ce',
        u'ext-AuthorityKeyIdentifier',
        u'id-ce-authorityKeyIdentifier',
        u'ext-SubjectKeyIdentifier',
        u'id-ce-subjectKeyIdentifier',
        u'ext-KeyUsage',
        u'id-ce-keyUsage',
        u'ext-PrivateKeyUsagePeriod',
        u'id-ce-privateKeyUsagePeriod',
        u'ext-CertificatePolicies',
        u'id-ce-certificatePolicies',
        u'pqid-cps',
        u'pqid-unotice',
        u'ext-PolicyMappings',
        u'id-ce-policyMappings',
        u'ext-SubjectAltName',
        u'id-ce-subjectAltName',
        u'ext-IssuerAltName',
        u'id-ce-issuerAltName',
        u'ext-SubjectDirectoryAttributes',
        u'id-ce-subjectDirectoryAttributes',
        u'ext-BasicConstraints',
        u'id-ce-basicConstraints',
        u'ext-NameConstraints',
        u'id-ce-nameConstraints',
        u'ext-PolicyConstraints',
        u'id-ce-policyConstraints',
        u'ext-CRLDistributionPoints',
        u'id-ce-cRLDistributionPoints',
        u'ext-ExtKeyUsage',
        u'id-ce-extKeyUsage',
        u'anyExtendedKeyUsage',
        u'id-kp-serverAuth',
        u'id-kp-clientAuth',
        u'id-kp-codeSigning',
        u'id-kp-emailProtection',
        u'id-kp-timeStamping',
        u'id-kp-OCSPSigning',
        u'ext-InhibitAnyPolicy',
        u'id-ce-inhibitAnyPolicy',
        u'ext-FreshestCRL',
        u'id-ce-freshestCRL',
        u'ext-AuthorityInfoAccess',
        u'id-pe-authorityInfoAccess',
        u'ext-SubjectInfoAccessSyntax',
        u'id-pe-subjectInfoAccess',
        u'ext-CRLNumber',
        u'id-ce-cRLNumber',
        u'ext-IssuingDistributionPoint',
        u'id-ce-issuingDistributionPoint',
        u'ext-DeltaCRLIndicator',
        u'id-ce-deltaCRLIndicator',
        u'ext-CRLReason',
        u'id-ce-cRLReasons',
        u'ext-CertificateIssuer',
        u'id-ce-certificateIssuer',
        u'ext-HoldInstructionCode',
        u'id-ce-holdInstructionCode',
        u'holdInstruction',
        u'id-holdinstruction-none',
        u'id-holdinstruction-callissuer',
        u'id-holdinstruction-reject',
        u'ext-InvalidityDate',
        u'id-ce-invalidityDate',
        u'ubMax',
        ]
    _class_ = [
        u'CertExtensions',
        u'CrlExtensions',
        u'CrlEntryExtensions',
        u'ext-AuthorityKeyIdentifier',
        u'ext-SubjectKeyIdentifier',
        u'ext-KeyUsage',
        u'ext-PrivateKeyUsagePeriod',
        u'ext-CertificatePolicies',
        u'CERT-POLICY-QUALIFIER',
        u'PolicyQualifierId',
        u'pqid-cps',
        u'pqid-unotice',
        u'ext-PolicyMappings',
        u'ext-SubjectAltName',
        u'OTHER-NAME',
        u'ext-IssuerAltName',
        u'ext-SubjectDirectoryAttributes',
        u'ext-BasicConstraints',
        u'ext-NameConstraints',
        u'ext-PolicyConstraints',
        u'ext-CRLDistributionPoints',
        u'ext-ExtKeyUsage',
        u'ext-InhibitAnyPolicy',
        u'ext-FreshestCRL',
        u'ext-AuthorityInfoAccess',
        u'ext-SubjectInfoAccessSyntax',
        u'ext-CRLNumber',
        u'ext-IssuingDistributionPoint',
        u'ext-DeltaCRLIndicator',
        u'ext-CRLReason',
        u'ext-CertificateIssuer',
        u'ext-HoldInstructionCode',
        u'ext-InvalidityDate',
        ]
    _param_ = [
        ]
    
    #-----< CertExtensions >-----#
    CertExtensions = CLASS(name=u'CertExtensions', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _CertExtensions_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _CertExtensions_val_ExtnType_1 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')))
    _CertExtensions_val_ExtnType_2 = BIT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyUsage')))
    _CertExtensions_val_ExtnType_3 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PrivateKeyUsagePeriod')))
    _CertExtensions_val_ExtnType_4 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertificatePolicies')))
    _CertExtensions_val_ExtnType_5 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyMappings')))
    _CertExtensions_val_ExtnType_6 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _CertExtensions_val_ExtnType_7 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _CertExtensions_val_ExtnType_8 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectDirectoryAttributes')))
    _CertExtensions_val_ExtnType_9 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'BasicConstraints')))
    _CertExtensions_val_ExtnType_10 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'NameConstraints')))
    _CertExtensions_val_ExtnType_11 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyConstraints')))
    _CertExtensions_val_ExtnType_12 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'ExtKeyUsageSyntax')))
    _CertExtensions_val_ExtnType_13 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _CertExtensions_val_ExtnType_14 = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')))
    _CertExtensions_val_ExtnType_15 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _CertExtensions_val_ExtnType_16 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    _CertExtensions_val_ExtnType_17 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectInfoAccessSyntax')))
    CertExtensions._val = ASN1Set(rv=[dict([(u'ExtnType', _CertExtensions_val_ExtnType_0), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_1), (u'id', (2, 5, 29, 14))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_2), (u'id', (2, 5, 29, 15))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_3), (u'id', (2, 5, 29, 16))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_4), (u'id', (2, 5, 29, 32))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_5), (u'id', (2, 5, 29, 33))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_6), (u'id', (2, 5, 29, 17))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_7), (u'id', (2, 5, 29, 18))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_8), (u'id', (2, 5, 29, 9))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_9), (u'id', (2, 5, 29, 19))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_10), (u'id', (2, 5, 29, 30))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_11), (u'id', (2, 5, 29, 36))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_12), (u'id', (2, 5, 29, 37))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_13), (u'id', (2, 5, 29, 31))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_14), (u'id', (2, 5, 29, 54))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_15), (u'id', (2, 5, 29, 46))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_16), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_17), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 11))])], rr=[], ev=[], er=[])
    
    #-----< CrlExtensions >-----#
    CrlExtensions = CLASS(name=u'CrlExtensions', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _CrlExtensions_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _CrlExtensions_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _CrlExtensions_val_ExtnType_2 = INT(name=u'ExtnType', mode=MODE_TYPE)
    _CrlExtensions_val_ExtnType_2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _CrlExtensions_val_ExtnType_3 = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLNumber')))
    _CrlExtensions_val_ExtnType_4 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'IssuingDistributionPoint')))
    _CrlExtensions_val_ExtnType_5 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    CrlExtensions._val = ASN1Set(rv=[dict([(u'ExtnType', _CrlExtensions_val_ExtnType_0), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _CrlExtensions_val_ExtnType_1), (u'id', (2, 5, 29, 18))]), dict([(u'ExtnType', _CrlExtensions_val_ExtnType_2), (u'id', (2, 5, 29, 20))]), dict([(u'ExtnType', _CrlExtensions_val_ExtnType_3), (u'id', (2, 5, 29, 27))]), dict([(u'ExtnType', _CrlExtensions_val_ExtnType_4), (u'id', (2, 5, 29, 28))]), dict([(u'ExtnType', _CrlExtensions_val_ExtnType_5), (u'id', (2, 5, 29, 46))])], rr=[], ev=[], er=[])
    
    #-----< CrlEntryExtensions >-----#
    CrlEntryExtensions = CLASS(name=u'CrlEntryExtensions', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _CrlEntryExtensions_val_ExtnType_0 = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLReason')))
    _CrlEntryExtensions_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _CrlEntryExtensions_val_ExtnType_2 = OID(name=u'ExtnType', mode=MODE_TYPE)
    _CrlEntryExtensions_val_ExtnType_3 = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    CrlEntryExtensions._val = ASN1Set(rv=[dict([(u'ExtnType', _CrlEntryExtensions_val_ExtnType_0), (u'id', (2, 5, 29, 21))]), dict([(u'ExtnType', _CrlEntryExtensions_val_ExtnType_1), (u'id', (2, 5, 29, 29))]), dict([(u'ExtnType', _CrlEntryExtensions_val_ExtnType_2), (u'id', (2, 5, 29, 23))]), dict([(u'ExtnType', _CrlEntryExtensions_val_ExtnType_3), (u'id', (2, 5, 29, 24))])], rr=[], ev=[], er=[])
    
    #-----< id-ce >-----#
    id_ce = OID(name=u'id-ce', mode=MODE_VALUE)
    id_ce._val = (2, 5, 29)
    
    #-----< ext-AuthorityKeyIdentifier >-----#
    ext_AuthorityKeyIdentifier = CLASS(name=u'ext-AuthorityKeyIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_AuthorityKeyIdentifier_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    ext_AuthorityKeyIdentifier._val = dict([(u'ExtnType', _ext_AuthorityKeyIdentifier_val_ExtnType), (u'id', (2, 5, 29, 35))])
    
    #-----< id-ce-authorityKeyIdentifier >-----#
    id_ce_authorityKeyIdentifier = OID(name=u'id-ce-authorityKeyIdentifier', mode=MODE_VALUE)
    id_ce_authorityKeyIdentifier._val = (2, 5, 29, 35)
    
    #-----< AuthorityKeyIdentifier >-----#
    AuthorityKeyIdentifier = SEQ(name=u'AuthorityKeyIdentifier', mode=MODE_TYPE)
    _AuthorityKeyIdentifier_keyIdentifier = OCT_STR(name=u'keyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')), opt=True)
    _AuthorityKeyIdentifier_authorityCertIssuer = SEQ_OF(name=u'authorityCertIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    _AuthorityKeyIdentifier_authorityCertSerialNumber = INT(name=u'authorityCertSerialNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')), opt=True)
    AuthorityKeyIdentifier._cont = ASN1Dict([
        (u'keyIdentifier', _AuthorityKeyIdentifier_keyIdentifier),
        (u'authorityCertIssuer', _AuthorityKeyIdentifier_authorityCertIssuer),
        (u'authorityCertSerialNumber', _AuthorityKeyIdentifier_authorityCertSerialNumber),
        ])
    AuthorityKeyIdentifier._ext = None
    
    #-----< KeyIdentifier >-----#
    KeyIdentifier = OCT_STR(name=u'KeyIdentifier', mode=MODE_TYPE)
    
    #-----< ext-SubjectKeyIdentifier >-----#
    ext_SubjectKeyIdentifier = CLASS(name=u'ext-SubjectKeyIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_SubjectKeyIdentifier_val_ExtnType = OCT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')))
    ext_SubjectKeyIdentifier._val = dict([(u'ExtnType', _ext_SubjectKeyIdentifier_val_ExtnType), (u'id', (2, 5, 29, 14))])
    
    #-----< id-ce-subjectKeyIdentifier >-----#
    id_ce_subjectKeyIdentifier = OID(name=u'id-ce-subjectKeyIdentifier', mode=MODE_VALUE)
    id_ce_subjectKeyIdentifier._val = (2, 5, 29, 14)
    
    #-----< ext-KeyUsage >-----#
    ext_KeyUsage = CLASS(name=u'ext-KeyUsage', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_KeyUsage_val_ExtnType = BIT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyUsage')))
    ext_KeyUsage._val = dict([(u'ExtnType', _ext_KeyUsage_val_ExtnType), (u'id', (2, 5, 29, 15))])
    
    #-----< id-ce-keyUsage >-----#
    id_ce_keyUsage = OID(name=u'id-ce-keyUsage', mode=MODE_VALUE)
    id_ce_keyUsage._val = (2, 5, 29, 15)
    
    #-----< KeyUsage >-----#
    KeyUsage = BIT_STR(name=u'KeyUsage', mode=MODE_TYPE)
    KeyUsage._cont = ASN1Dict([(u'digitalSignature', 0), (u'nonRepudiation', 1), (u'keyEncipherment', 2), (u'dataEncipherment', 3), (u'keyAgreement', 4), (u'keyCertSign', 5), (u'cRLSign', 6), (u'encipherOnly', 7), (u'decipherOnly', 8)])
    
    #-----< ext-PrivateKeyUsagePeriod >-----#
    ext_PrivateKeyUsagePeriod = CLASS(name=u'ext-PrivateKeyUsagePeriod', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_PrivateKeyUsagePeriod_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PrivateKeyUsagePeriod')))
    ext_PrivateKeyUsagePeriod._val = dict([(u'ExtnType', _ext_PrivateKeyUsagePeriod_val_ExtnType), (u'id', (2, 5, 29, 16))])
    
    #-----< id-ce-privateKeyUsagePeriod >-----#
    id_ce_privateKeyUsagePeriod = OID(name=u'id-ce-privateKeyUsagePeriod', mode=MODE_VALUE)
    id_ce_privateKeyUsagePeriod._val = (2, 5, 29, 16)
    
    #-----< PrivateKeyUsagePeriod >-----#
    PrivateKeyUsagePeriod = SEQ(name=u'PrivateKeyUsagePeriod', mode=MODE_TYPE)
    _PrivateKeyUsagePeriod_notBefore = TIME_GEN(name=u'notBefore', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PrivateKeyUsagePeriod_notAfter = TIME_GEN(name=u'notAfter', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PrivateKeyUsagePeriod._cont = ASN1Dict([
        (u'notBefore', _PrivateKeyUsagePeriod_notBefore),
        (u'notAfter', _PrivateKeyUsagePeriod_notAfter),
        ])
    PrivateKeyUsagePeriod._ext = None
    
    #-----< ext-CertificatePolicies >-----#
    ext_CertificatePolicies = CLASS(name=u'ext-CertificatePolicies', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_CertificatePolicies_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertificatePolicies')))
    ext_CertificatePolicies._val = dict([(u'ExtnType', _ext_CertificatePolicies_val_ExtnType), (u'id', (2, 5, 29, 32))])
    
    #-----< id-ce-certificatePolicies >-----#
    id_ce_certificatePolicies = OID(name=u'id-ce-certificatePolicies', mode=MODE_VALUE)
    id_ce_certificatePolicies._val = (2, 5, 29, 32)
    
    #-----< CertificatePolicies >-----#
    CertificatePolicies = SEQ_OF(name=u'CertificatePolicies', mode=MODE_TYPE)
    _CertificatePolicies__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyInformation')))
    CertificatePolicies._cont = _CertificatePolicies__item_
    CertificatePolicies._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PolicyInformation >-----#
    PolicyInformation = SEQ(name=u'PolicyInformation', mode=MODE_TYPE)
    _PolicyInformation_policyIdentifier = OID(name=u'policyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertPolicyId')))
    _PolicyInformation_policyQualifiers = SEQ_OF(name=u'policyQualifiers', mode=MODE_TYPE, opt=True)
    __PolicyInformation_policyQualifiers__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyQualifierInfo')))
    _PolicyInformation_policyQualifiers._cont = __PolicyInformation_policyQualifiers__item_
    _PolicyInformation_policyQualifiers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PolicyInformation._cont = ASN1Dict([
        (u'policyIdentifier', _PolicyInformation_policyIdentifier),
        (u'policyQualifiers', _PolicyInformation_policyQualifiers),
        ])
    PolicyInformation._ext = None
    
    #-----< CertPolicyId >-----#
    CertPolicyId = OID(name=u'CertPolicyId', mode=MODE_TYPE)
    
    #-----< CERT-POLICY-QUALIFIER >-----#
    CERT_POLICY_QUALIFIER = CLASS(name=u'CERT-POLICY-QUALIFIER', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< PolicyQualifierInfo >-----#
    PolicyQualifierInfo = SEQ(name=u'PolicyQualifierInfo', mode=MODE_TYPE)
    _PolicyQualifierInfo_policyQualifierId = OID(name=u'policyQualifierId', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER'), [u'id']))
    __PolicyQualifierInfo_policyQualifierId_tab = CLASS(name='_tab_CERT-POLICY-QUALIFIER', mode=MODE_SET, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER')))
    ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_0 = STR_IA5(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CPSuri')))
    ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'UserNotice')))
    __PolicyQualifierInfo_policyQualifierId_tab._val = ASN1Set(rv=[dict([('Type', ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_0), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 1))]), dict([('Type', ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_1), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 2))])], rr=[], ev=None, er=[])
    _PolicyQualifierInfo_policyQualifierId._const_tab = __PolicyQualifierInfo_policyQualifierId_tab
    _PolicyQualifierInfo_policyQualifierId._const_tab_at = None
    _PolicyQualifierInfo_policyQualifierId._const_tab_id = u'id'
    _PolicyQualifierInfo_qualifier = OPEN(name=u'qualifier', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER'), [u'Type']))
    _PolicyQualifierInfo_qualifier._const_tab = __PolicyQualifierInfo_policyQualifierId_tab
    _PolicyQualifierInfo_qualifier._const_tab_at = ('..', u'policyQualifierId')
    _PolicyQualifierInfo_qualifier._const_tab_id = u'Type'
    PolicyQualifierInfo._cont = ASN1Dict([
        (u'policyQualifierId', _PolicyQualifierInfo_policyQualifierId),
        (u'qualifier', _PolicyQualifierInfo_qualifier),
        ])
    PolicyQualifierInfo._ext = None
    
    #-----< PolicyQualifierId >-----#
    PolicyQualifierId = CLASS(name=u'PolicyQualifierId', mode=MODE_SET, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER')))
    _PolicyQualifierId_val_Type_0 = STR_IA5(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CPSuri')))
    _PolicyQualifierId_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'UserNotice')))
    PolicyQualifierId._val = ASN1Set(rv=[dict([('Type', _PolicyQualifierId_val_Type_0), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 1))]), dict([('Type', _PolicyQualifierId_val_Type_1), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 2))])], rr=[], ev=[], er=[])
    
    #-----< pqid-cps >-----#
    pqid_cps = CLASS(name=u'pqid-cps', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER')))
    _pqid_cps_val_Type = STR_IA5(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CPSuri')))
    pqid_cps._val = dict([('Type', _pqid_cps_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 1))])
    
    #-----< pqid-unotice >-----#
    pqid_unotice = CLASS(name=u'pqid-unotice', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER')))
    _pqid_unotice_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'UserNotice')))
    pqid_unotice._val = dict([('Type', _pqid_unotice_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 2))])
    
    #-----< CPSuri >-----#
    CPSuri = STR_IA5(name=u'CPSuri', mode=MODE_TYPE)
    
    #-----< UserNotice >-----#
    UserNotice = SEQ(name=u'UserNotice', mode=MODE_TYPE)
    _UserNotice_noticeRef = SEQ(name=u'noticeRef', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'NoticeReference')), opt=True)
    _UserNotice_explicitText = CHOICE(name=u'explicitText', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'DisplayText')), opt=True)
    UserNotice._cont = ASN1Dict([
        (u'noticeRef', _UserNotice_noticeRef),
        (u'explicitText', _UserNotice_explicitText),
        ])
    UserNotice._ext = None
    
    #-----< NoticeReference >-----#
    NoticeReference = SEQ(name=u'NoticeReference', mode=MODE_TYPE)
    _NoticeReference_organization = CHOICE(name=u'organization', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'DisplayText')))
    _NoticeReference_noticeNumbers = SEQ_OF(name=u'noticeNumbers', mode=MODE_TYPE)
    __NoticeReference_noticeNumbers__item_ = INT(name='_item_', mode=MODE_TYPE)
    _NoticeReference_noticeNumbers._cont = __NoticeReference_noticeNumbers__item_
    NoticeReference._cont = ASN1Dict([
        (u'organization', _NoticeReference_organization),
        (u'noticeNumbers', _NoticeReference_noticeNumbers),
        ])
    NoticeReference._ext = None
    
    #-----< DisplayText >-----#
    DisplayText = CHOICE(name=u'DisplayText', mode=MODE_TYPE)
    _DisplayText_ia5String = STR_IA5(name=u'ia5String', mode=MODE_TYPE)
    _DisplayText_ia5String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    _DisplayText_visibleString = STR_VIS(name=u'visibleString', mode=MODE_TYPE)
    _DisplayText_visibleString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    _DisplayText_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _DisplayText_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    _DisplayText_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _DisplayText_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    DisplayText._cont = ASN1Dict([
        (u'ia5String', _DisplayText_ia5String),
        (u'visibleString', _DisplayText_visibleString),
        (u'bmpString', _DisplayText_bmpString),
        (u'utf8String', _DisplayText_utf8String),
        ])
    DisplayText._ext = None
    
    #-----< ext-PolicyMappings >-----#
    ext_PolicyMappings = CLASS(name=u'ext-PolicyMappings', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_PolicyMappings_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyMappings')))
    ext_PolicyMappings._val = dict([(u'ExtnType', _ext_PolicyMappings_val_ExtnType), (u'id', (2, 5, 29, 33))])
    
    #-----< id-ce-policyMappings >-----#
    id_ce_policyMappings = OID(name=u'id-ce-policyMappings', mode=MODE_VALUE)
    id_ce_policyMappings._val = (2, 5, 29, 33)
    
    #-----< PolicyMappings >-----#
    PolicyMappings = SEQ_OF(name=u'PolicyMappings', mode=MODE_TYPE)
    _PolicyMappings__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __PolicyMappings__item__issuerDomainPolicy = OID(name=u'issuerDomainPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertPolicyId')))
    __PolicyMappings__item__subjectDomainPolicy = OID(name=u'subjectDomainPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertPolicyId')))
    _PolicyMappings__item_._cont = ASN1Dict([
        (u'issuerDomainPolicy', __PolicyMappings__item__issuerDomainPolicy),
        (u'subjectDomainPolicy', __PolicyMappings__item__subjectDomainPolicy),
        ])
    _PolicyMappings__item_._ext = None
    PolicyMappings._cont = _PolicyMappings__item_
    PolicyMappings._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< ext-SubjectAltName >-----#
    ext_SubjectAltName = CLASS(name=u'ext-SubjectAltName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_SubjectAltName_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    ext_SubjectAltName._val = dict([(u'ExtnType', _ext_SubjectAltName_val_ExtnType), (u'id', (2, 5, 29, 17))])
    
    #-----< id-ce-subjectAltName >-----#
    id_ce_subjectAltName = OID(name=u'id-ce-subjectAltName', mode=MODE_VALUE)
    id_ce_subjectAltName._val = (2, 5, 29, 17)
    
    #-----< GeneralNames >-----#
    GeneralNames = SEQ_OF(name=u'GeneralNames', mode=MODE_TYPE)
    _GeneralNames__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    GeneralNames._cont = _GeneralNames__item_
    GeneralNames._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralName >-----#
    GeneralName = CHOICE(name=u'GeneralName', mode=MODE_TYPE)
    _GeneralName_otherName = SEQ(name=u'otherName', mode=MODE_TYPE)
    __GeneralName_otherName_type_id = OID(name='type-id', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX1Implicit-2009', 'OTHER-NAME'), ['id']))
    __GeneralName_otherName_value = OPEN(name='value', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PKIX1Implicit-2009', 'OTHER-NAME'), ['Type']))
    _GeneralName_otherName._cont = ASN1Dict([
        ('type-id', __GeneralName_otherName_type_id),
        ('value', __GeneralName_otherName_value),
        ])
    _GeneralName_otherName._ext = None
    _GeneralName_otherName.TAG = 8
    _GeneralName_rfc822Name = STR_IA5(name=u'rfc822Name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_dNSName = STR_IA5(name=u'dNSName', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_x400Address = SEQ(name=u'x400Address', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'ORAddress')))
    _GeneralName_directoryName = CHOICE(name=u'directoryName', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _GeneralName_ediPartyName = SEQ(name=u'ediPartyName', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'EDIPartyName')))
    _GeneralName_uniformResourceIdentifier = STR_IA5(name=u'uniformResourceIdentifier', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_iPAddress = OCT_STR(name=u'iPAddress', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_registeredID = OID(name=u'registeredID', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GeneralName._cont = ASN1Dict([
        (u'otherName', _GeneralName_otherName),
        (u'rfc822Name', _GeneralName_rfc822Name),
        (u'dNSName', _GeneralName_dNSName),
        (u'x400Address', _GeneralName_x400Address),
        (u'directoryName', _GeneralName_directoryName),
        (u'ediPartyName', _GeneralName_ediPartyName),
        (u'uniformResourceIdentifier', _GeneralName_uniformResourceIdentifier),
        (u'iPAddress', _GeneralName_iPAddress),
        (u'registeredID', _GeneralName_registeredID),
        ])
    GeneralName._ext = None
    
    #-----< OTHER-NAME >-----#
    OTHER_NAME = CLASS(name=u'OTHER-NAME', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< EDIPartyName >-----#
    EDIPartyName = SEQ(name=u'EDIPartyName', mode=MODE_TYPE)
    _EDIPartyName_nameAssigner = CHOICE(name=u'nameAssigner', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')), opt=True)
    __EDIPartyName_nameAssigner_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __EDIPartyName_nameAssigner_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_nameAssigner_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __EDIPartyName_nameAssigner_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_nameAssigner_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __EDIPartyName_nameAssigner_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_nameAssigner_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __EDIPartyName_nameAssigner_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_nameAssigner_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __EDIPartyName_nameAssigner_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _EDIPartyName_nameAssigner._cont = ASN1Dict([
        (u'teletexString', __EDIPartyName_nameAssigner_teletexString),
        (u'printableString', __EDIPartyName_nameAssigner_printableString),
        (u'bmpString', __EDIPartyName_nameAssigner_bmpString),
        (u'universalString', __EDIPartyName_nameAssigner_universalString),
        (u'uTF8String', __EDIPartyName_nameAssigner_uTF8String),
        ])
    _EDIPartyName_nameAssigner._ext = None
    _EDIPartyName_partyName = CHOICE(name=u'partyName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __EDIPartyName_partyName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __EDIPartyName_partyName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_partyName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __EDIPartyName_partyName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_partyName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __EDIPartyName_partyName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_partyName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __EDIPartyName_partyName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_partyName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __EDIPartyName_partyName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _EDIPartyName_partyName._cont = ASN1Dict([
        (u'teletexString', __EDIPartyName_partyName_teletexString),
        (u'printableString', __EDIPartyName_partyName_printableString),
        (u'bmpString', __EDIPartyName_partyName_bmpString),
        (u'universalString', __EDIPartyName_partyName_universalString),
        (u'uTF8String', __EDIPartyName_partyName_uTF8String),
        ])
    _EDIPartyName_partyName._ext = None
    EDIPartyName._cont = ASN1Dict([
        (u'nameAssigner', _EDIPartyName_nameAssigner),
        (u'partyName', _EDIPartyName_partyName),
        ])
    EDIPartyName._ext = None
    
    #-----< ext-IssuerAltName >-----#
    ext_IssuerAltName = CLASS(name=u'ext-IssuerAltName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_IssuerAltName_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    ext_IssuerAltName._val = dict([(u'ExtnType', _ext_IssuerAltName_val_ExtnType), (u'id', (2, 5, 29, 18))])
    
    #-----< id-ce-issuerAltName >-----#
    id_ce_issuerAltName = OID(name=u'id-ce-issuerAltName', mode=MODE_VALUE)
    id_ce_issuerAltName._val = (2, 5, 29, 18)
    
    #-----< ext-SubjectDirectoryAttributes >-----#
    ext_SubjectDirectoryAttributes = CLASS(name=u'ext-SubjectDirectoryAttributes', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_SubjectDirectoryAttributes_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectDirectoryAttributes')))
    ext_SubjectDirectoryAttributes._val = dict([(u'ExtnType', _ext_SubjectDirectoryAttributes_val_ExtnType), (u'id', (2, 5, 29, 9))])
    
    #-----< id-ce-subjectDirectoryAttributes >-----#
    id_ce_subjectDirectoryAttributes = OID(name=u'id-ce-subjectDirectoryAttributes', mode=MODE_VALUE)
    id_ce_subjectDirectoryAttributes._val = (2, 5, 29, 9)
    
    #-----< SubjectDirectoryAttributes >-----#
    SubjectDirectoryAttributes = SEQ_OF(name=u'SubjectDirectoryAttributes', mode=MODE_TYPE)
    _SubjectDirectoryAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'AttributeSet')))
    __SubjectDirectoryAttributes__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___SubjectDirectoryAttributes__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_1 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_2 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_3 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_4 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_5 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520CommonName')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_6 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520LocalityName')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_7 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_7._cont = ASN1Dict([
        (u'teletexString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_teletexString),
        (u'printableString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_printableString),
        (u'bmpString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_bmpString),
        (u'universalString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_universalString),
        (u'uTF8String', _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_uTF8String),
        ])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_7._ext = None
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_8 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_8._cont = ASN1Dict([
        (u'teletexString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_teletexString),
        (u'printableString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_printableString),
        (u'bmpString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_bmpString),
        (u'universalString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_universalString),
        (u'uTF8String', _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_uTF8String),
        ])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_8._ext = None
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_9 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_9._cont = ASN1Dict([
        (u'teletexString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_teletexString),
        (u'printableString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_printableString),
        (u'bmpString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_bmpString),
        (u'universalString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_universalString),
        (u'uTF8String', _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_uTF8String),
        ])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_9._ext = None
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_10 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_10._cont = ASN1Dict([
        (u'teletexString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_teletexString),
        (u'printableString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_printableString),
        (u'bmpString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_bmpString),
        (u'universalString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_universalString),
        (u'uTF8String', _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_uTF8String),
        ])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_10._ext = None
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_11 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_12 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_12._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_13 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_14 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_14._cont = ASN1Dict([
        (u'teletexString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_teletexString),
        (u'printableString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_printableString),
        (u'bmpString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_bmpString),
        (u'universalString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_universalString),
        (u'uTF8String', _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_uTF8String),
        ])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_14._ext = None
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_15 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_16 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_16._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    ___SubjectDirectoryAttributes__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_0), (u'id', (2, 5, 4, 41))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_1), (u'id', (2, 5, 4, 4))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_2), (u'id', (2, 5, 4, 42))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_3), (u'id', (2, 5, 4, 43))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_4), (u'id', (2, 5, 4, 44))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_5), (u'id', (2, 5, 4, 3))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_6), (u'id', (2, 5, 4, 7))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_7), (u'id', (2, 5, 4, 8))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_8), (u'id', (2, 5, 4, 10))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_9), (u'id', (2, 5, 4, 11))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_10), (u'id', (2, 5, 4, 12))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_11), (u'id', (2, 5, 4, 46))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_12), (u'id', (2, 5, 4, 6))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_13), (u'id', (2, 5, 4, 5))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_14), (u'id', (2, 5, 4, 65))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_15), (u'id', (0, 9, 2342, 19200300, 100, 1, 25))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 9, 1))])], rr=[], ev=None, er=[])
    __SubjectDirectoryAttributes__item__type._const_tab = ___SubjectDirectoryAttributes__item__type_tab
    __SubjectDirectoryAttributes__item__type._const_tab_at = None
    __SubjectDirectoryAttributes__item__type._const_tab_id = u'id'
    __SubjectDirectoryAttributes__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ___SubjectDirectoryAttributes__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ___SubjectDirectoryAttributes__item__values__item_._const_tab = ___SubjectDirectoryAttributes__item__type_tab
    ___SubjectDirectoryAttributes__item__values__item_._const_tab_at = ('..', '..', u'type')
    ___SubjectDirectoryAttributes__item__values__item_._const_tab_id = u'Type'
    __SubjectDirectoryAttributes__item__values._cont = ___SubjectDirectoryAttributes__item__values__item_
    __SubjectDirectoryAttributes__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _SubjectDirectoryAttributes__item_._cont = ASN1Dict([
        (u'type', __SubjectDirectoryAttributes__item__type),
        (u'values', __SubjectDirectoryAttributes__item__values),
        ])
    _SubjectDirectoryAttributes__item_._ext = None
    SubjectDirectoryAttributes._cont = _SubjectDirectoryAttributes__item_
    SubjectDirectoryAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< ext-BasicConstraints >-----#
    ext_BasicConstraints = CLASS(name=u'ext-BasicConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_BasicConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'BasicConstraints')))
    ext_BasicConstraints._val = dict([(u'ExtnType', _ext_BasicConstraints_val_ExtnType), (u'id', (2, 5, 29, 19))])
    
    #-----< id-ce-basicConstraints >-----#
    id_ce_basicConstraints = OID(name=u'id-ce-basicConstraints', mode=MODE_VALUE)
    id_ce_basicConstraints._val = (2, 5, 29, 19)
    
    #-----< BasicConstraints >-----#
    BasicConstraints = SEQ(name=u'BasicConstraints', mode=MODE_TYPE)
    _BasicConstraints_cA = BOOL(name=u'cA', mode=MODE_TYPE, default=False)
    _BasicConstraints_pathLenConstraint = INT(name=u'pathLenConstraint', mode=MODE_TYPE, opt=True)
    _BasicConstraints_pathLenConstraint._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    BasicConstraints._cont = ASN1Dict([
        (u'cA', _BasicConstraints_cA),
        (u'pathLenConstraint', _BasicConstraints_pathLenConstraint),
        ])
    BasicConstraints._ext = None
    
    #-----< ext-NameConstraints >-----#
    ext_NameConstraints = CLASS(name=u'ext-NameConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_NameConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'NameConstraints')))
    ext_NameConstraints._val = dict([(u'ExtnType', _ext_NameConstraints_val_ExtnType), (u'id', (2, 5, 29, 30))])
    
    #-----< id-ce-nameConstraints >-----#
    id_ce_nameConstraints = OID(name=u'id-ce-nameConstraints', mode=MODE_VALUE)
    id_ce_nameConstraints._val = (2, 5, 29, 30)
    
    #-----< NameConstraints >-----#
    NameConstraints = SEQ(name=u'NameConstraints', mode=MODE_TYPE)
    _NameConstraints_permittedSubtrees = SEQ_OF(name=u'permittedSubtrees', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralSubtrees')), opt=True)
    _NameConstraints_excludedSubtrees = SEQ_OF(name=u'excludedSubtrees', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralSubtrees')), opt=True)
    NameConstraints._cont = ASN1Dict([
        (u'permittedSubtrees', _NameConstraints_permittedSubtrees),
        (u'excludedSubtrees', _NameConstraints_excludedSubtrees),
        ])
    NameConstraints._ext = None
    
    #-----< GeneralSubtrees >-----#
    GeneralSubtrees = SEQ_OF(name=u'GeneralSubtrees', mode=MODE_TYPE)
    _GeneralSubtrees__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralSubtree')))
    GeneralSubtrees._cont = _GeneralSubtrees__item_
    GeneralSubtrees._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralSubtree >-----#
    GeneralSubtree = SEQ(name=u'GeneralSubtree', mode=MODE_TYPE)
    _GeneralSubtree_base = CHOICE(name=u'base', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _GeneralSubtree_minimum = INT(name=u'minimum', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'BaseDistance')), default=0)
    _GeneralSubtree_maximum = INT(name=u'maximum', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'BaseDistance')), opt=True)
    GeneralSubtree._cont = ASN1Dict([
        (u'base', _GeneralSubtree_base),
        (u'minimum', _GeneralSubtree_minimum),
        (u'maximum', _GeneralSubtree_maximum),
        ])
    GeneralSubtree._ext = None
    
    #-----< BaseDistance >-----#
    BaseDistance = INT(name=u'BaseDistance', mode=MODE_TYPE)
    BaseDistance._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< ext-PolicyConstraints >-----#
    ext_PolicyConstraints = CLASS(name=u'ext-PolicyConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_PolicyConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyConstraints')))
    ext_PolicyConstraints._val = dict([(u'ExtnType', _ext_PolicyConstraints_val_ExtnType), (u'id', (2, 5, 29, 36))])
    
    #-----< id-ce-policyConstraints >-----#
    id_ce_policyConstraints = OID(name=u'id-ce-policyConstraints', mode=MODE_VALUE)
    id_ce_policyConstraints._val = (2, 5, 29, 36)
    
    #-----< PolicyConstraints >-----#
    PolicyConstraints = SEQ(name=u'PolicyConstraints', mode=MODE_TYPE)
    _PolicyConstraints_requireExplicitPolicy = INT(name=u'requireExplicitPolicy', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')), opt=True)
    _PolicyConstraints_inhibitPolicyMapping = INT(name=u'inhibitPolicyMapping', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')), opt=True)
    PolicyConstraints._cont = ASN1Dict([
        (u'requireExplicitPolicy', _PolicyConstraints_requireExplicitPolicy),
        (u'inhibitPolicyMapping', _PolicyConstraints_inhibitPolicyMapping),
        ])
    PolicyConstraints._ext = None
    
    #-----< SkipCerts >-----#
    SkipCerts = INT(name=u'SkipCerts', mode=MODE_TYPE)
    SkipCerts._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< ext-CRLDistributionPoints >-----#
    ext_CRLDistributionPoints = CLASS(name=u'ext-CRLDistributionPoints', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_CRLDistributionPoints_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    ext_CRLDistributionPoints._val = dict([(u'ExtnType', _ext_CRLDistributionPoints_val_ExtnType), (u'id', (2, 5, 29, 31))])
    
    #-----< id-ce-cRLDistributionPoints >-----#
    id_ce_cRLDistributionPoints = OID(name=u'id-ce-cRLDistributionPoints', mode=MODE_VALUE)
    id_ce_cRLDistributionPoints._val = (2, 5, 29, 31)
    
    #-----< CRLDistributionPoints >-----#
    CRLDistributionPoints = SEQ_OF(name=u'CRLDistributionPoints', mode=MODE_TYPE)
    _CRLDistributionPoints__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'DistributionPoint')))
    CRLDistributionPoints._cont = _CRLDistributionPoints__item_
    CRLDistributionPoints._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< DistributionPoint >-----#
    DistributionPoint = SEQ(name=u'DistributionPoint', mode=MODE_TYPE)
    _DistributionPoint_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'DistributionPointName')), opt=True)
    _DistributionPoint_reasons = BIT_STR(name=u'reasons', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'ReasonFlags')), opt=True)
    _DistributionPoint_cRLIssuer = SEQ_OF(name=u'cRLIssuer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    DistributionPoint._cont = ASN1Dict([
        (u'distributionPoint', _DistributionPoint_distributionPoint),
        (u'reasons', _DistributionPoint_reasons),
        (u'cRLIssuer', _DistributionPoint_cRLIssuer),
        ])
    DistributionPoint._ext = None
    
    #-----< DistributionPointName >-----#
    DistributionPointName = CHOICE(name=u'DistributionPointName', mode=MODE_TYPE)
    _DistributionPointName_fullName = SEQ_OF(name=u'fullName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _DistributionPointName_nameRelativeToCRLIssuer = SET_OF(name=u'nameRelativeToCRLIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'RelativeDistinguishedName')))
    DistributionPointName._cont = ASN1Dict([
        (u'fullName', _DistributionPointName_fullName),
        (u'nameRelativeToCRLIssuer', _DistributionPointName_nameRelativeToCRLIssuer),
        ])
    DistributionPointName._ext = None
    
    #-----< ReasonFlags >-----#
    ReasonFlags = BIT_STR(name=u'ReasonFlags', mode=MODE_TYPE)
    ReasonFlags._cont = ASN1Dict([(u'unused', 0), (u'keyCompromise', 1), (u'cACompromise', 2), (u'affiliationChanged', 3), (u'superseded', 4), (u'cessationOfOperation', 5), (u'certificateHold', 6), (u'privilegeWithdrawn', 7), (u'aACompromise', 8)])
    
    #-----< ext-ExtKeyUsage >-----#
    ext_ExtKeyUsage = CLASS(name=u'ext-ExtKeyUsage', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_ExtKeyUsage_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'ExtKeyUsageSyntax')))
    ext_ExtKeyUsage._val = dict([(u'ExtnType', _ext_ExtKeyUsage_val_ExtnType), (u'id', (2, 5, 29, 37))])
    
    #-----< id-ce-extKeyUsage >-----#
    id_ce_extKeyUsage = OID(name=u'id-ce-extKeyUsage', mode=MODE_VALUE)
    id_ce_extKeyUsage._val = (2, 5, 29, 37)
    
    #-----< ExtKeyUsageSyntax >-----#
    ExtKeyUsageSyntax = SEQ_OF(name=u'ExtKeyUsageSyntax', mode=MODE_TYPE)
    _ExtKeyUsageSyntax__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyPurposeId')))
    ExtKeyUsageSyntax._cont = _ExtKeyUsageSyntax__item_
    ExtKeyUsageSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< KeyPurposeId >-----#
    KeyPurposeId = OID(name=u'KeyPurposeId', mode=MODE_TYPE)
    
    #-----< anyExtendedKeyUsage >-----#
    anyExtendedKeyUsage = OID(name=u'anyExtendedKeyUsage', mode=MODE_VALUE)
    anyExtendedKeyUsage._val = (2, 5, 29, 37, 0)
    
    #-----< id-kp-serverAuth >-----#
    id_kp_serverAuth = OID(name=u'id-kp-serverAuth', mode=MODE_VALUE)
    id_kp_serverAuth._val = (1, 3, 6, 1, 5, 5, 7, 3, 1)
    
    #-----< id-kp-clientAuth >-----#
    id_kp_clientAuth = OID(name=u'id-kp-clientAuth', mode=MODE_VALUE)
    id_kp_clientAuth._val = (1, 3, 6, 1, 5, 5, 7, 3, 2)
    
    #-----< id-kp-codeSigning >-----#
    id_kp_codeSigning = OID(name=u'id-kp-codeSigning', mode=MODE_VALUE)
    id_kp_codeSigning._val = (1, 3, 6, 1, 5, 5, 7, 3, 3)
    
    #-----< id-kp-emailProtection >-----#
    id_kp_emailProtection = OID(name=u'id-kp-emailProtection', mode=MODE_VALUE)
    id_kp_emailProtection._val = (1, 3, 6, 1, 5, 5, 7, 3, 4)
    
    #-----< id-kp-timeStamping >-----#
    id_kp_timeStamping = OID(name=u'id-kp-timeStamping', mode=MODE_VALUE)
    id_kp_timeStamping._val = (1, 3, 6, 1, 5, 5, 7, 3, 8)
    
    #-----< id-kp-OCSPSigning >-----#
    id_kp_OCSPSigning = OID(name=u'id-kp-OCSPSigning', mode=MODE_VALUE)
    id_kp_OCSPSigning._val = (1, 3, 6, 1, 5, 5, 7, 3, 9)
    
    #-----< ext-InhibitAnyPolicy >-----#
    ext_InhibitAnyPolicy = CLASS(name=u'ext-InhibitAnyPolicy', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_InhibitAnyPolicy_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')))
    ext_InhibitAnyPolicy._val = dict([(u'ExtnType', _ext_InhibitAnyPolicy_val_ExtnType), (u'id', (2, 5, 29, 54))])
    
    #-----< id-ce-inhibitAnyPolicy >-----#
    id_ce_inhibitAnyPolicy = OID(name=u'id-ce-inhibitAnyPolicy', mode=MODE_VALUE)
    id_ce_inhibitAnyPolicy._val = (2, 5, 29, 54)
    
    #-----< ext-FreshestCRL >-----#
    ext_FreshestCRL = CLASS(name=u'ext-FreshestCRL', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_FreshestCRL_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    ext_FreshestCRL._val = dict([(u'ExtnType', _ext_FreshestCRL_val_ExtnType), (u'id', (2, 5, 29, 46))])
    
    #-----< id-ce-freshestCRL >-----#
    id_ce_freshestCRL = OID(name=u'id-ce-freshestCRL', mode=MODE_VALUE)
    id_ce_freshestCRL._val = (2, 5, 29, 46)
    
    #-----< ext-AuthorityInfoAccess >-----#
    ext_AuthorityInfoAccess = CLASS(name=u'ext-AuthorityInfoAccess', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_AuthorityInfoAccess_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    ext_AuthorityInfoAccess._val = dict([(u'ExtnType', _ext_AuthorityInfoAccess_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))])
    
    #-----< id-pe-authorityInfoAccess >-----#
    id_pe_authorityInfoAccess = OID(name=u'id-pe-authorityInfoAccess', mode=MODE_VALUE)
    id_pe_authorityInfoAccess._val = (1, 3, 6, 1, 5, 5, 7, 1, 1)
    
    #-----< AuthorityInfoAccessSyntax >-----#
    AuthorityInfoAccessSyntax = SEQ_OF(name=u'AuthorityInfoAccessSyntax', mode=MODE_TYPE)
    _AuthorityInfoAccessSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AccessDescription')))
    AuthorityInfoAccessSyntax._cont = _AuthorityInfoAccessSyntax__item_
    AuthorityInfoAccessSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< AccessDescription >-----#
    AccessDescription = SEQ(name=u'AccessDescription', mode=MODE_TYPE)
    _AccessDescription_accessMethod = OID(name=u'accessMethod', mode=MODE_TYPE)
    _AccessDescription_accessLocation = CHOICE(name=u'accessLocation', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    AccessDescription._cont = ASN1Dict([
        (u'accessMethod', _AccessDescription_accessMethod),
        (u'accessLocation', _AccessDescription_accessLocation),
        ])
    AccessDescription._ext = None
    
    #-----< ext-SubjectInfoAccessSyntax >-----#
    ext_SubjectInfoAccessSyntax = CLASS(name=u'ext-SubjectInfoAccessSyntax', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_SubjectInfoAccessSyntax_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectInfoAccessSyntax')))
    ext_SubjectInfoAccessSyntax._val = dict([(u'ExtnType', _ext_SubjectInfoAccessSyntax_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 11))])
    
    #-----< id-pe-subjectInfoAccess >-----#
    id_pe_subjectInfoAccess = OID(name=u'id-pe-subjectInfoAccess', mode=MODE_VALUE)
    id_pe_subjectInfoAccess._val = (1, 3, 6, 1, 5, 5, 7, 1, 11)
    
    #-----< SubjectInfoAccessSyntax >-----#
    SubjectInfoAccessSyntax = SEQ_OF(name=u'SubjectInfoAccessSyntax', mode=MODE_TYPE)
    _SubjectInfoAccessSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AccessDescription')))
    SubjectInfoAccessSyntax._cont = _SubjectInfoAccessSyntax__item_
    SubjectInfoAccessSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< ext-CRLNumber >-----#
    ext_CRLNumber = CLASS(name=u'ext-CRLNumber', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_CRLNumber_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE)
    _ext_CRLNumber_val_ExtnType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ext_CRLNumber._val = dict([(u'ExtnType', _ext_CRLNumber_val_ExtnType), (u'id', (2, 5, 29, 20))])
    
    #-----< id-ce-cRLNumber >-----#
    id_ce_cRLNumber = OID(name=u'id-ce-cRLNumber', mode=MODE_VALUE)
    id_ce_cRLNumber._val = (2, 5, 29, 20)
    
    #-----< CRLNumber >-----#
    CRLNumber = INT(name=u'CRLNumber', mode=MODE_TYPE)
    CRLNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< ext-IssuingDistributionPoint >-----#
    ext_IssuingDistributionPoint = CLASS(name=u'ext-IssuingDistributionPoint', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_IssuingDistributionPoint_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'IssuingDistributionPoint')))
    ext_IssuingDistributionPoint._val = dict([(u'ExtnType', _ext_IssuingDistributionPoint_val_ExtnType), (u'id', (2, 5, 29, 28))])
    
    #-----< id-ce-issuingDistributionPoint >-----#
    id_ce_issuingDistributionPoint = OID(name=u'id-ce-issuingDistributionPoint', mode=MODE_VALUE)
    id_ce_issuingDistributionPoint._val = (2, 5, 29, 28)
    
    #-----< IssuingDistributionPoint >-----#
    IssuingDistributionPoint = SEQ(name=u'IssuingDistributionPoint', mode=MODE_TYPE)
    _IssuingDistributionPoint_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'DistributionPointName')), opt=True)
    _IssuingDistributionPoint_onlyContainsUserCerts = BOOL(name=u'onlyContainsUserCerts', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistributionPoint_onlyContainsCACerts = BOOL(name=u'onlyContainsCACerts', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistributionPoint_onlySomeReasons = BIT_STR(name=u'onlySomeReasons', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'ReasonFlags')), opt=True)
    _IssuingDistributionPoint_indirectCRL = BOOL(name=u'indirectCRL', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistributionPoint_onlyContainsAttributeCerts = BOOL(name=u'onlyContainsAttributeCerts', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    IssuingDistributionPoint._cont = ASN1Dict([
        (u'distributionPoint', _IssuingDistributionPoint_distributionPoint),
        (u'onlyContainsUserCerts', _IssuingDistributionPoint_onlyContainsUserCerts),
        (u'onlyContainsCACerts', _IssuingDistributionPoint_onlyContainsCACerts),
        (u'onlySomeReasons', _IssuingDistributionPoint_onlySomeReasons),
        (u'indirectCRL', _IssuingDistributionPoint_indirectCRL),
        (u'onlyContainsAttributeCerts', _IssuingDistributionPoint_onlyContainsAttributeCerts),
        ])
    IssuingDistributionPoint._ext = None
    
    #-----< ext-DeltaCRLIndicator >-----#
    ext_DeltaCRLIndicator = CLASS(name=u'ext-DeltaCRLIndicator', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_DeltaCRLIndicator_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLNumber')))
    ext_DeltaCRLIndicator._val = dict([(u'ExtnType', _ext_DeltaCRLIndicator_val_ExtnType), (u'id', (2, 5, 29, 27))])
    
    #-----< id-ce-deltaCRLIndicator >-----#
    id_ce_deltaCRLIndicator = OID(name=u'id-ce-deltaCRLIndicator', mode=MODE_VALUE)
    id_ce_deltaCRLIndicator._val = (2, 5, 29, 27)
    
    #-----< ext-CRLReason >-----#
    ext_CRLReason = CLASS(name=u'ext-CRLReason', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_CRLReason_val_ExtnType = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLReason')))
    ext_CRLReason._val = dict([(u'ExtnType', _ext_CRLReason_val_ExtnType), (u'id', (2, 5, 29, 21))])
    
    #-----< id-ce-cRLReasons >-----#
    id_ce_cRLReasons = OID(name=u'id-ce-cRLReasons', mode=MODE_VALUE)
    id_ce_cRLReasons._val = (2, 5, 29, 21)
    
    #-----< CRLReason >-----#
    CRLReason = ENUM(name=u'CRLReason', mode=MODE_TYPE)
    CRLReason._cont = ASN1Dict([(u'unspecified', 0), (u'keyCompromise', 1), (u'cACompromise', 2), (u'affiliationChanged', 3), (u'superseded', 4), (u'cessationOfOperation', 5), (u'certificateHold', 6), (u'removeFromCRL', 8), (u'privilegeWithdrawn', 9), (u'aACompromise', 10)])
    CRLReason._ext = None
    
    #-----< ext-CertificateIssuer >-----#
    ext_CertificateIssuer = CLASS(name=u'ext-CertificateIssuer', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_CertificateIssuer_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    ext_CertificateIssuer._val = dict([(u'ExtnType', _ext_CertificateIssuer_val_ExtnType), (u'id', (2, 5, 29, 29))])
    
    #-----< id-ce-certificateIssuer >-----#
    id_ce_certificateIssuer = OID(name=u'id-ce-certificateIssuer', mode=MODE_VALUE)
    id_ce_certificateIssuer._val = (2, 5, 29, 29)
    
    #-----< ext-HoldInstructionCode >-----#
    ext_HoldInstructionCode = CLASS(name=u'ext-HoldInstructionCode', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_HoldInstructionCode_val_ExtnType = OID(name=u'ExtnType', mode=MODE_TYPE)
    ext_HoldInstructionCode._val = dict([(u'ExtnType', _ext_HoldInstructionCode_val_ExtnType), (u'id', (2, 5, 29, 23))])
    
    #-----< id-ce-holdInstructionCode >-----#
    id_ce_holdInstructionCode = OID(name=u'id-ce-holdInstructionCode', mode=MODE_VALUE)
    id_ce_holdInstructionCode._val = (2, 5, 29, 23)
    
    #-----< holdInstruction >-----#
    holdInstruction = OID(name=u'holdInstruction', mode=MODE_VALUE)
    holdInstruction._val = (2, 2, 840, 10040, 2)
    
    #-----< id-holdinstruction-none >-----#
    id_holdinstruction_none = OID(name=u'id-holdinstruction-none', mode=MODE_VALUE)
    id_holdinstruction_none._val = (2, 2, 840, 10040, 2, 1)
    
    #-----< id-holdinstruction-callissuer >-----#
    id_holdinstruction_callissuer = OID(name=u'id-holdinstruction-callissuer', mode=MODE_VALUE)
    id_holdinstruction_callissuer._val = (2, 2, 840, 10040, 2, 2)
    
    #-----< id-holdinstruction-reject >-----#
    id_holdinstruction_reject = OID(name=u'id-holdinstruction-reject', mode=MODE_VALUE)
    id_holdinstruction_reject._val = (2, 2, 840, 10040, 2, 3)
    
    #-----< ext-InvalidityDate >-----#
    ext_InvalidityDate = CLASS(name=u'ext-InvalidityDate', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_InvalidityDate_val_ExtnType = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    ext_InvalidityDate._val = dict([(u'ExtnType', _ext_InvalidityDate_val_ExtnType), (u'id', (2, 5, 29, 24))])
    
    #-----< id-ce-invalidityDate >-----#
    id_ce_invalidityDate = OID(name=u'id-ce-invalidityDate', mode=MODE_VALUE)
    id_ce_invalidityDate._val = (2, 5, 29, 24)
    
    #-----< ubMax >-----#
    ubMax = INT(name=u'ubMax', mode=MODE_VALUE)
    ubMax._val = 32768
    
    _all_ = [
        CertExtensions,
        _CertExtensions_val_ExtnType_0,
        _CertExtensions_val_ExtnType_1,
        _CertExtensions_val_ExtnType_2,
        _CertExtensions_val_ExtnType_3,
        _CertExtensions_val_ExtnType_4,
        _CertExtensions_val_ExtnType_5,
        _CertExtensions_val_ExtnType_6,
        _CertExtensions_val_ExtnType_7,
        _CertExtensions_val_ExtnType_8,
        _CertExtensions_val_ExtnType_9,
        _CertExtensions_val_ExtnType_10,
        _CertExtensions_val_ExtnType_11,
        _CertExtensions_val_ExtnType_12,
        _CertExtensions_val_ExtnType_13,
        _CertExtensions_val_ExtnType_14,
        _CertExtensions_val_ExtnType_15,
        _CertExtensions_val_ExtnType_16,
        _CertExtensions_val_ExtnType_17,
        CrlExtensions,
        _CrlExtensions_val_ExtnType_0,
        _CrlExtensions_val_ExtnType_1,
        _CrlExtensions_val_ExtnType_2,
        _CrlExtensions_val_ExtnType_3,
        _CrlExtensions_val_ExtnType_4,
        _CrlExtensions_val_ExtnType_5,
        CrlEntryExtensions,
        _CrlEntryExtensions_val_ExtnType_0,
        _CrlEntryExtensions_val_ExtnType_1,
        _CrlEntryExtensions_val_ExtnType_2,
        _CrlEntryExtensions_val_ExtnType_3,
        id_ce,
        ext_AuthorityKeyIdentifier,
        _ext_AuthorityKeyIdentifier_val_ExtnType,
        id_ce_authorityKeyIdentifier,
        _AuthorityKeyIdentifier_keyIdentifier,
        _AuthorityKeyIdentifier_authorityCertIssuer,
        _AuthorityKeyIdentifier_authorityCertSerialNumber,
        AuthorityKeyIdentifier,
        KeyIdentifier,
        ext_SubjectKeyIdentifier,
        _ext_SubjectKeyIdentifier_val_ExtnType,
        id_ce_subjectKeyIdentifier,
        ext_KeyUsage,
        _ext_KeyUsage_val_ExtnType,
        id_ce_keyUsage,
        KeyUsage,
        ext_PrivateKeyUsagePeriod,
        _ext_PrivateKeyUsagePeriod_val_ExtnType,
        id_ce_privateKeyUsagePeriod,
        _PrivateKeyUsagePeriod_notBefore,
        _PrivateKeyUsagePeriod_notAfter,
        PrivateKeyUsagePeriod,
        ext_CertificatePolicies,
        _ext_CertificatePolicies_val_ExtnType,
        id_ce_certificatePolicies,
        _CertificatePolicies__item_,
        CertificatePolicies,
        _PolicyInformation_policyIdentifier,
        __PolicyInformation_policyQualifiers__item_,
        _PolicyInformation_policyQualifiers,
        PolicyInformation,
        CertPolicyId,
        CERT_POLICY_QUALIFIER,
        __PolicyQualifierInfo_policyQualifierId_tab,
        ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_0,
        ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_1,
        _PolicyQualifierInfo_policyQualifierId,
        _PolicyQualifierInfo_qualifier,
        PolicyQualifierInfo,
        PolicyQualifierId,
        _PolicyQualifierId_val_Type_0,
        _PolicyQualifierId_val_Type_1,
        pqid_cps,
        _pqid_cps_val_Type,
        pqid_unotice,
        _pqid_unotice_val_Type,
        CPSuri,
        _UserNotice_noticeRef,
        _UserNotice_explicitText,
        UserNotice,
        _NoticeReference_organization,
        __NoticeReference_noticeNumbers__item_,
        _NoticeReference_noticeNumbers,
        NoticeReference,
        _DisplayText_ia5String,
        _DisplayText_visibleString,
        _DisplayText_bmpString,
        _DisplayText_utf8String,
        DisplayText,
        ext_PolicyMappings,
        _ext_PolicyMappings_val_ExtnType,
        id_ce_policyMappings,
        __PolicyMappings__item__issuerDomainPolicy,
        __PolicyMappings__item__subjectDomainPolicy,
        _PolicyMappings__item_,
        PolicyMappings,
        ext_SubjectAltName,
        _ext_SubjectAltName_val_ExtnType,
        id_ce_subjectAltName,
        _GeneralNames__item_,
        GeneralNames,
        __GeneralName_otherName_type_id,
        __GeneralName_otherName_value,
        _GeneralName_otherName,
        _GeneralName_otherName,
        _GeneralName_rfc822Name,
        _GeneralName_dNSName,
        _GeneralName_x400Address,
        _GeneralName_directoryName,
        _GeneralName_ediPartyName,
        _GeneralName_uniformResourceIdentifier,
        _GeneralName_iPAddress,
        _GeneralName_registeredID,
        GeneralName,
        OTHER_NAME,
        __EDIPartyName_nameAssigner_teletexString,
        __EDIPartyName_nameAssigner_printableString,
        __EDIPartyName_nameAssigner_bmpString,
        __EDIPartyName_nameAssigner_universalString,
        __EDIPartyName_nameAssigner_uTF8String,
        _EDIPartyName_nameAssigner,
        __EDIPartyName_partyName_teletexString,
        __EDIPartyName_partyName_printableString,
        __EDIPartyName_partyName_bmpString,
        __EDIPartyName_partyName_universalString,
        __EDIPartyName_partyName_uTF8String,
        _EDIPartyName_partyName,
        EDIPartyName,
        ext_IssuerAltName,
        _ext_IssuerAltName_val_ExtnType,
        id_ce_issuerAltName,
        ext_SubjectDirectoryAttributes,
        _ext_SubjectDirectoryAttributes_val_ExtnType,
        id_ce_subjectDirectoryAttributes,
        ___SubjectDirectoryAttributes__item__type_tab,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_0,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_1,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_2,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_3,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_4,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_5,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_6,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_teletexString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_printableString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_bmpString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_universalString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_uTF8String,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_7,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_teletexString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_printableString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_bmpString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_universalString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_uTF8String,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_8,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_teletexString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_printableString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_bmpString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_universalString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_uTF8String,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_9,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_teletexString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_printableString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_bmpString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_universalString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_uTF8String,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_10,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_11,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_12,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_13,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_teletexString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_printableString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_bmpString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_universalString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_uTF8String,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_14,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_15,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_16,
        __SubjectDirectoryAttributes__item__type,
        ___SubjectDirectoryAttributes__item__values__item_,
        __SubjectDirectoryAttributes__item__values,
        _SubjectDirectoryAttributes__item_,
        SubjectDirectoryAttributes,
        ext_BasicConstraints,
        _ext_BasicConstraints_val_ExtnType,
        id_ce_basicConstraints,
        _BasicConstraints_cA,
        _BasicConstraints_pathLenConstraint,
        BasicConstraints,
        ext_NameConstraints,
        _ext_NameConstraints_val_ExtnType,
        id_ce_nameConstraints,
        _NameConstraints_permittedSubtrees,
        _NameConstraints_excludedSubtrees,
        NameConstraints,
        _GeneralSubtrees__item_,
        GeneralSubtrees,
        _GeneralSubtree_base,
        _GeneralSubtree_minimum,
        _GeneralSubtree_maximum,
        GeneralSubtree,
        BaseDistance,
        ext_PolicyConstraints,
        _ext_PolicyConstraints_val_ExtnType,
        id_ce_policyConstraints,
        _PolicyConstraints_requireExplicitPolicy,
        _PolicyConstraints_inhibitPolicyMapping,
        PolicyConstraints,
        SkipCerts,
        ext_CRLDistributionPoints,
        _ext_CRLDistributionPoints_val_ExtnType,
        id_ce_cRLDistributionPoints,
        _CRLDistributionPoints__item_,
        CRLDistributionPoints,
        _DistributionPoint_distributionPoint,
        _DistributionPoint_reasons,
        _DistributionPoint_cRLIssuer,
        DistributionPoint,
        _DistributionPointName_fullName,
        _DistributionPointName_nameRelativeToCRLIssuer,
        DistributionPointName,
        ReasonFlags,
        ext_ExtKeyUsage,
        _ext_ExtKeyUsage_val_ExtnType,
        id_ce_extKeyUsage,
        _ExtKeyUsageSyntax__item_,
        ExtKeyUsageSyntax,
        KeyPurposeId,
        anyExtendedKeyUsage,
        id_kp_serverAuth,
        id_kp_clientAuth,
        id_kp_codeSigning,
        id_kp_emailProtection,
        id_kp_timeStamping,
        id_kp_OCSPSigning,
        ext_InhibitAnyPolicy,
        _ext_InhibitAnyPolicy_val_ExtnType,
        id_ce_inhibitAnyPolicy,
        ext_FreshestCRL,
        _ext_FreshestCRL_val_ExtnType,
        id_ce_freshestCRL,
        ext_AuthorityInfoAccess,
        _ext_AuthorityInfoAccess_val_ExtnType,
        id_pe_authorityInfoAccess,
        _AuthorityInfoAccessSyntax__item_,
        AuthorityInfoAccessSyntax,
        _AccessDescription_accessMethod,
        _AccessDescription_accessLocation,
        AccessDescription,
        ext_SubjectInfoAccessSyntax,
        _ext_SubjectInfoAccessSyntax_val_ExtnType,
        id_pe_subjectInfoAccess,
        _SubjectInfoAccessSyntax__item_,
        SubjectInfoAccessSyntax,
        ext_CRLNumber,
        _ext_CRLNumber_val_ExtnType,
        id_ce_cRLNumber,
        CRLNumber,
        ext_IssuingDistributionPoint,
        _ext_IssuingDistributionPoint_val_ExtnType,
        id_ce_issuingDistributionPoint,
        _IssuingDistributionPoint_distributionPoint,
        _IssuingDistributionPoint_onlyContainsUserCerts,
        _IssuingDistributionPoint_onlyContainsCACerts,
        _IssuingDistributionPoint_onlySomeReasons,
        _IssuingDistributionPoint_indirectCRL,
        _IssuingDistributionPoint_onlyContainsAttributeCerts,
        IssuingDistributionPoint,
        ext_DeltaCRLIndicator,
        _ext_DeltaCRLIndicator_val_ExtnType,
        id_ce_deltaCRLIndicator,
        ext_CRLReason,
        _ext_CRLReason_val_ExtnType,
        id_ce_cRLReasons,
        CRLReason,
        ext_CertificateIssuer,
        _ext_CertificateIssuer_val_ExtnType,
        id_ce_certificateIssuer,
        ext_HoldInstructionCode,
        _ext_HoldInstructionCode_val_ExtnType,
        id_ce_holdInstructionCode,
        holdInstruction,
        id_holdinstruction_none,
        id_holdinstruction_callissuer,
        id_holdinstruction_reject,
        ext_InvalidityDate,
        _ext_InvalidityDate_val_ExtnType,
        id_ce_invalidityDate,
        ubMax,
    ]

class PKIX1_PSS_OAEP_Algorithms_2009:

    _name_  = u'PKIX1-PSS-OAEP-Algorithms-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 54]
    
    _obj_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'KeyTransportAlgs',
        u'HashAlgs',
        u'SMimeCaps',
        u'pk-rsaSSA-PSS',
        u'sa-rsaSSA-PSS',
        u'sa-sha224WithRSAEncryption',
        u'sha224WithRSAEncryption',
        u'sa-sha256WithRSAEncryption',
        u'sha256WithRSAEncryption',
        u'sa-sha384WithRSAEncryption',
        u'sha384WithRSAEncryption',
        u'sa-sha512WithRSAEncryption',
        u'sha512WithRSAEncryption',
        u'pk-rsaES-OAEP',
        u'kta-rsaES-OAEP',
        u'pkcs-1',
        u'id-RSAES-OAEP',
        u'id-mgf1',
        u'id-pSpecified',
        u'id-RSASSA-PSS',
        u'id-sha224',
        u'mda-sha224',
        u'id-sha256',
        u'mda-sha256',
        u'id-sha384',
        u'mda-sha384',
        u'id-sha512',
        u'mda-sha512',
        u'EncodingParameters',
        u'nullOctetString',
        u'nullParameters',
        u'HashAlgorithm',
        u'HashAlgorithms',
        u'sha1Identifier',
        u'MaskGenAlgorithm',
        u'mgf1SHA1',
        u'PKCS1MGFAlgorithms',
        u'PSourceAlgorithm',
        u'PSS-SourceAlgorithms',
        u'pSpecifiedEmpty',
        u'RSASSA-PSS-params',
        u'RSAES-OAEP-params',
        ]
    _type_ = [
        u'EncodingParameters',
        u'HashAlgorithm',
        u'MaskGenAlgorithm',
        u'PSourceAlgorithm',
        u'RSASSA-PSS-params',
        u'RSAES-OAEP-params',
        ]
    _set_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'KeyTransportAlgs',
        u'HashAlgs',
        u'SMimeCaps',
        u'HashAlgorithms',
        u'PKCS1MGFAlgorithms',
        u'PSS-SourceAlgorithms',
        ]
    _val_ = [
        u'pk-rsaSSA-PSS',
        u'sa-rsaSSA-PSS',
        u'sa-sha224WithRSAEncryption',
        u'sha224WithRSAEncryption',
        u'sa-sha256WithRSAEncryption',
        u'sha256WithRSAEncryption',
        u'sa-sha384WithRSAEncryption',
        u'sha384WithRSAEncryption',
        u'sa-sha512WithRSAEncryption',
        u'sha512WithRSAEncryption',
        u'pk-rsaES-OAEP',
        u'kta-rsaES-OAEP',
        u'pkcs-1',
        u'id-RSAES-OAEP',
        u'id-mgf1',
        u'id-pSpecified',
        u'id-RSASSA-PSS',
        u'id-sha224',
        u'mda-sha224',
        u'id-sha256',
        u'mda-sha256',
        u'id-sha384',
        u'mda-sha384',
        u'id-sha512',
        u'mda-sha512',
        u'nullOctetString',
        u'nullParameters',
        u'sha1Identifier',
        u'mgf1SHA1',
        u'pSpecifiedEmpty',
        ]
    _class_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'KeyTransportAlgs',
        u'HashAlgs',
        u'SMimeCaps',
        u'pk-rsaSSA-PSS',
        u'sa-rsaSSA-PSS',
        u'sa-sha224WithRSAEncryption',
        u'sa-sha256WithRSAEncryption',
        u'sa-sha384WithRSAEncryption',
        u'sa-sha512WithRSAEncryption',
        u'pk-rsaES-OAEP',
        u'kta-rsaES-OAEP',
        u'mda-sha224',
        u'mda-sha256',
        u'mda-sha384',
        u'mda-sha512',
        u'HashAlgorithms',
        u'PKCS1MGFAlgorithms',
        u'PSS-SourceAlgorithms',
        ]
    _param_ = [
        ]
    
    #-----< PublicKeys >-----#
    PublicKeys = CLASS(name=u'PublicKeys', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _PublicKeys_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeys_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    _PublicKeys_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeys_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    PublicKeys._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', _PublicKeys_val_KeyValue_0), (u'Params', _PublicKeys_val_Params_0), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', _PublicKeys_val_KeyValue_1), (u'Params', _PublicKeys_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], rr=[], ev=[], er=[])
    
    #-----< SignatureAlgs >-----#
    SignatureAlgs = CLASS(name=u'SignatureAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _SignatureAlgs_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    SignatureAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', _SignatureAlgs_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], rr=[], ev=[], er=[])
    
    #-----< KeyTransportAlgs >-----#
    KeyTransportAlgs = CLASS(name=u'KeyTransportAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    _KeyTransportAlgs_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __KEY_TRANSPORT_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __KEY_TRANSPORT_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __KEY_TRANSPORT_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    __KEY_TRANSPORT_smimeCaps_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    KeyTransportAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'Params', _KeyTransportAlgs_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_1), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'Type', __KEY_TRANSPORT_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 7))]))])], rr=[], ev=[], er=[])
    
    #-----< HashAlgs >-----#
    HashAlgs = CLASS(name=u'HashAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _HashAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgs_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgs_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgs_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    HashAlgs._val = ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', _HashAlgs_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', _HashAlgs_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', _HashAlgs_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', _HashAlgs_val_Params_3), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=[], er=[])
    
    #-----< SMimeCaps >-----#
    SMimeCaps = CLASS(name=u'SMimeCaps', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _SMimeCaps_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    SMimeCaps._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'Type', _SMimeCaps_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 1, 7))])], rr=[], ev=[], er=[])
    
    #-----< pk-rsaSSA-PSS >-----#
    pk_rsaSSA_PSS = CLASS(name=u'pk-rsaSSA-PSS', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_rsaSSA_PSS_val_KeyValue = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _pk_rsaSSA_PSS_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    pk_rsaSSA_PSS._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', _pk_rsaSSA_PSS_val_KeyValue), (u'Params', _pk_rsaSSA_PSS_val_Params), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])
    
    #-----< sa-rsaSSA-PSS >-----#
    sa_rsaSSA_PSS = CLASS(name=u'sa-rsaSSA-PSS', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_rsaSSA_PSS_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    sa_rsaSSA_PSS._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', _sa_rsaSSA_PSS_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])
    
    #-----< sa-sha224WithRSAEncryption >-----#
    sa_sha224WithRSAEncryption = CLASS(name=u'sa-sha224WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_sha224WithRSAEncryption_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_sha224WithRSAEncryption._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 14)), (u'Params', _sa_sha224WithRSAEncryption_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 14))]))])
    
    #-----< sha224WithRSAEncryption >-----#
    sha224WithRSAEncryption = OID(name=u'sha224WithRSAEncryption', mode=MODE_VALUE)
    sha224WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 14)
    
    #-----< sa-sha256WithRSAEncryption >-----#
    sa_sha256WithRSAEncryption = CLASS(name=u'sa-sha256WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_sha256WithRSAEncryption_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_sha256WithRSAEncryption._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 11)), (u'Params', _sa_sha256WithRSAEncryption_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 11))]))])
    
    #-----< sha256WithRSAEncryption >-----#
    sha256WithRSAEncryption = OID(name=u'sha256WithRSAEncryption', mode=MODE_VALUE)
    sha256WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 11)
    
    #-----< sa-sha384WithRSAEncryption >-----#
    sa_sha384WithRSAEncryption = CLASS(name=u'sa-sha384WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_sha384WithRSAEncryption_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_sha384WithRSAEncryption._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 12)), (u'Params', _sa_sha384WithRSAEncryption_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 12))]))])
    
    #-----< sha384WithRSAEncryption >-----#
    sha384WithRSAEncryption = OID(name=u'sha384WithRSAEncryption', mode=MODE_VALUE)
    sha384WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 12)
    
    #-----< sa-sha512WithRSAEncryption >-----#
    sa_sha512WithRSAEncryption = CLASS(name=u'sa-sha512WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_sha512WithRSAEncryption_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_sha512WithRSAEncryption._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 13)), (u'Params', _sa_sha512WithRSAEncryption_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 13))]))])
    
    #-----< sha512WithRSAEncryption >-----#
    sha512WithRSAEncryption = OID(name=u'sha512WithRSAEncryption', mode=MODE_VALUE)
    sha512WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 13)
    
    #-----< pk-rsaES-OAEP >-----#
    pk_rsaES_OAEP = CLASS(name=u'pk-rsaES-OAEP', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_rsaES_OAEP_val_KeyValue = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _pk_rsaES_OAEP_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    pk_rsaES_OAEP._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', _pk_rsaES_OAEP_val_KeyValue), (u'Params', _pk_rsaES_OAEP_val_Params), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])
    
    #-----< kta-rsaES-OAEP >-----#
    kta_rsaES_OAEP = CLASS(name=u'kta-rsaES-OAEP', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    _kta_rsaES_OAEP_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    kta_rsaES_OAEP._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'Params', _kta_rsaES_OAEP_val_Params), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_1), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'Type', __KEY_TRANSPORT_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 7))]))])
    
    #-----< pkcs-1 >-----#
    pkcs_1 = OID(name=u'pkcs-1', mode=MODE_VALUE)
    pkcs_1._val = (1, 2, 840, 113549, 1, 1)
    
    #-----< id-RSAES-OAEP >-----#
    id_RSAES_OAEP = OID(name=u'id-RSAES-OAEP', mode=MODE_VALUE)
    id_RSAES_OAEP._val = (1, 2, 840, 113549, 1, 1, 7)
    
    #-----< id-mgf1 >-----#
    id_mgf1 = OID(name=u'id-mgf1', mode=MODE_VALUE)
    id_mgf1._val = (1, 2, 840, 113549, 1, 1, 8)
    
    #-----< id-pSpecified >-----#
    id_pSpecified = OID(name=u'id-pSpecified', mode=MODE_VALUE)
    id_pSpecified._val = (1, 2, 840, 113549, 1, 1, 9)
    
    #-----< id-RSASSA-PSS >-----#
    id_RSASSA_PSS = OID(name=u'id-RSASSA-PSS', mode=MODE_VALUE)
    id_RSASSA_PSS._val = (1, 2, 840, 113549, 1, 1, 10)
    
    #-----< id-sha224 >-----#
    id_sha224 = OID(name=u'id-sha224', mode=MODE_VALUE)
    id_sha224._val = (2, 16, 840, 1, 101, 3, 4, 2, 4)
    
    #-----< mda-sha224 >-----#
    mda_sha224 = CLASS(name=u'mda-sha224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_sha224_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_sha224._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', _mda_sha224_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-sha256 >-----#
    id_sha256 = OID(name=u'id-sha256', mode=MODE_VALUE)
    id_sha256._val = (2, 16, 840, 1, 101, 3, 4, 2, 1)
    
    #-----< mda-sha256 >-----#
    mda_sha256 = CLASS(name=u'mda-sha256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_sha256_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_sha256._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', _mda_sha256_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-sha384 >-----#
    id_sha384 = OID(name=u'id-sha384', mode=MODE_VALUE)
    id_sha384._val = (2, 16, 840, 1, 101, 3, 4, 2, 2)
    
    #-----< mda-sha384 >-----#
    mda_sha384 = CLASS(name=u'mda-sha384', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_sha384_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_sha384._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', _mda_sha384_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-sha512 >-----#
    id_sha512 = OID(name=u'id-sha512', mode=MODE_VALUE)
    id_sha512._val = (2, 16, 840, 1, 101, 3, 4, 2, 3)
    
    #-----< mda-sha512 >-----#
    mda_sha512 = CLASS(name=u'mda-sha512', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_sha512_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_sha512._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', _mda_sha512_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< EncodingParameters >-----#
    EncodingParameters = OCT_STR(name=u'EncodingParameters', mode=MODE_TYPE)
    EncodingParameters._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< nullOctetString >-----#
    nullOctetString = OCT_STR(name=u'nullOctetString', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'EncodingParameters')))
    nullOctetString._val = b''
    
    #-----< nullParameters >-----#
    nullParameters = NULL(name=u'nullParameters', mode=MODE_VALUE)
    nullParameters._val = 0
    
    #-----< HashAlgorithm >-----#
    HashAlgorithm = SEQ(name=u'HashAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _HashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    __HashAlgorithm_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___HashAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___HashAlgorithm_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ___HashAlgorithm_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ___HashAlgorithm_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ___HashAlgorithm_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __HashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', ___HashAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', ___HashAlgorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', ___HashAlgorithm_algorithm_tab_val_Params_2), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', ___HashAlgorithm_algorithm_tab_val_Params_3), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', ___HashAlgorithm_algorithm_tab_val_Params_4), (u'paramPresence', u'preferredPresent')])], rr=[], ev=None, er=[])
    _HashAlgorithm_algorithm._const_tab = __HashAlgorithm_algorithm_tab
    _HashAlgorithm_algorithm._const_tab_at = None
    _HashAlgorithm_algorithm._const_tab_id = u'id'
    _HashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    _HashAlgorithm_parameters._const_tab = __HashAlgorithm_algorithm_tab
    _HashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _HashAlgorithm_parameters._const_tab_id = u'Params'
    HashAlgorithm._cont = ASN1Dict([
        (u'algorithm', _HashAlgorithm_algorithm),
        (u'parameters', _HashAlgorithm_parameters),
        ])
    HashAlgorithm._ext = None
    
    #-----< HashAlgorithms >-----#
    HashAlgorithms = CLASS(name=u'HashAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _HashAlgorithms_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgorithms_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgorithms_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgorithms_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgorithms_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    HashAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', _HashAlgorithms_val_Params_0), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', _HashAlgorithms_val_Params_1), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', _HashAlgorithms_val_Params_2), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', _HashAlgorithms_val_Params_3), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', _HashAlgorithms_val_Params_4), (u'paramPresence', u'preferredPresent')])], rr=[], ev=None, er=[])
    
    #-----< sha1Identifier >-----#
    sha1Identifier = SEQ(name=u'sha1Identifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')))
    _parameters_val = NULL(name=u'parameters', mode=MODE_TYPE)
    sha1Identifier._val = dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))])
    
    #-----< MaskGenAlgorithm >-----#
    MaskGenAlgorithm = SEQ(name=u'MaskGenAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _MaskGenAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'id']))
    __MaskGenAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    ___MaskGenAlgorithm_algorithm_tab_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')))
    __MaskGenAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 8)), (u'Params', ___MaskGenAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=None, er=[])
    _MaskGenAlgorithm_algorithm._const_tab = __MaskGenAlgorithm_algorithm_tab
    _MaskGenAlgorithm_algorithm._const_tab_at = None
    _MaskGenAlgorithm_algorithm._const_tab_id = u'id'
    _MaskGenAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'Params']), opt=True)
    _MaskGenAlgorithm_parameters._const_tab = __MaskGenAlgorithm_algorithm_tab
    _MaskGenAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _MaskGenAlgorithm_parameters._const_tab_id = u'Params'
    MaskGenAlgorithm._cont = ASN1Dict([
        (u'algorithm', _MaskGenAlgorithm_algorithm),
        (u'parameters', _MaskGenAlgorithm_parameters),
        ])
    MaskGenAlgorithm._ext = None
    
    #-----< mgf1SHA1 >-----#
    mgf1SHA1 = SEQ(name=u'mgf1SHA1', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'MaskGenAlgorithm')))
    _parameters_val_0 = SEQ(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')))
    mgf1SHA1._val = dict([(u'algorithm', (1, 2, 840, 113549, 1, 1, 8)), (u'parameters', (_parameters_val_0, dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))])))])
    
    #-----< PKCS1MGFAlgorithms >-----#
    PKCS1MGFAlgorithms = CLASS(name=u'PKCS1MGFAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    _PKCS1MGFAlgorithms_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')))
    PKCS1MGFAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 8)), (u'Params', _PKCS1MGFAlgorithms_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=[], er=[])
    
    #-----< PSourceAlgorithm >-----#
    PSourceAlgorithm = SEQ(name=u'PSourceAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _PSourceAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'id']))
    __PSourceAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    ___PSourceAlgorithm_algorithm_tab_val_Params_0 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'EncodingParameters')))
    __PSourceAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 9)), (u'Params', ___PSourceAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=None, er=[])
    _PSourceAlgorithm_algorithm._const_tab = __PSourceAlgorithm_algorithm_tab
    _PSourceAlgorithm_algorithm._const_tab_at = None
    _PSourceAlgorithm_algorithm._const_tab_id = u'id'
    _PSourceAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'Params']), opt=True)
    _PSourceAlgorithm_parameters._const_tab = __PSourceAlgorithm_algorithm_tab
    _PSourceAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _PSourceAlgorithm_parameters._const_tab_id = u'Params'
    PSourceAlgorithm._cont = ASN1Dict([
        (u'algorithm', _PSourceAlgorithm_algorithm),
        (u'parameters', _PSourceAlgorithm_parameters),
        ])
    PSourceAlgorithm._ext = None
    
    #-----< PSS-SourceAlgorithms >-----#
    PSS_SourceAlgorithms = CLASS(name=u'PSS-SourceAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    _PSS_SourceAlgorithms_val_Params_0 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'EncodingParameters')))
    PSS_SourceAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 9)), (u'Params', _PSS_SourceAlgorithms_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=[], er=[])
    
    #-----< pSpecifiedEmpty >-----#
    pSpecifiedEmpty = SEQ(name=u'pSpecifiedEmpty', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'PSourceAlgorithm')))
    _parameters_val_1 = OCT_STR(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'EncodingParameters')))
    pSpecifiedEmpty._val = dict([(u'algorithm', (1, 2, 840, 113549, 1, 1, 9)), (u'parameters', (_parameters_val_1, b''))])
    
    #-----< RSASSA-PSS-params >-----#
    RSASSA_PSS_params = SEQ(name=u'RSASSA-PSS-params', mode=MODE_TYPE)
    _RSASSA_PSS_params_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')), default=dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))]))
    _RSASSA_PSS_params_maskGenAlgorithm = SEQ(name=u'maskGenAlgorithm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'MaskGenAlgorithm')), default=dict([(u'algorithm', (1, 2, 840, 113549, 1, 1, 8)), (u'parameters', (_parameters_val_0, dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))])))]))
    _RSASSA_PSS_params_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _RSASSA_PSS_params_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    RSASSA_PSS_params._cont = ASN1Dict([
        (u'hashAlgorithm', _RSASSA_PSS_params_hashAlgorithm),
        (u'maskGenAlgorithm', _RSASSA_PSS_params_maskGenAlgorithm),
        (u'saltLength', _RSASSA_PSS_params_saltLength),
        (u'trailerField', _RSASSA_PSS_params_trailerField),
        ])
    RSASSA_PSS_params._ext = None
    
    #-----< RSAES-OAEP-params >-----#
    RSAES_OAEP_params = SEQ(name=u'RSAES-OAEP-params', mode=MODE_TYPE)
    _RSAES_OAEP_params_hashFunc = SEQ(name=u'hashFunc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')), default=dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))]))
    _RSAES_OAEP_params_maskGenFunc = SEQ(name=u'maskGenFunc', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'MaskGenAlgorithm')), default=dict([(u'algorithm', (1, 2, 840, 113549, 1, 1, 8)), (u'parameters', (_parameters_val_0, dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))])))]))
    _RSAES_OAEP_params_pSourceFunc = SEQ(name=u'pSourceFunc', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'PSourceAlgorithm')), default=dict([(u'algorithm', (1, 2, 840, 113549, 1, 1, 9)), (u'parameters', (_parameters_val_1, b''))]))
    RSAES_OAEP_params._cont = ASN1Dict([
        (u'hashFunc', _RSAES_OAEP_params_hashFunc),
        (u'maskGenFunc', _RSAES_OAEP_params_maskGenFunc),
        (u'pSourceFunc', _RSAES_OAEP_params_pSourceFunc),
        ])
    RSAES_OAEP_params._ext = None
    
    _all_ = [
        PublicKeys,
        _PublicKeys_val_KeyValue_0,
        _PublicKeys_val_Params_0,
        _PublicKeys_val_KeyValue_1,
        _PublicKeys_val_Params_1,
        SignatureAlgs,
        _SignatureAlgs_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_1,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_2,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_3,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1,
        KeyTransportAlgs,
        _KeyTransportAlgs_val_Params_0,
        __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0,
        __KEY_TRANSPORT_PublicKeySet_val_Params_0,
        __KEY_TRANSPORT_PublicKeySet_val_KeyValue_1,
        __KEY_TRANSPORT_PublicKeySet_val_Params_1,
        __KEY_TRANSPORT_smimeCaps_val_Type,
        HashAlgs,
        _HashAlgs_val_Params_0,
        _HashAlgs_val_Params_1,
        _HashAlgs_val_Params_2,
        _HashAlgs_val_Params_3,
        SMimeCaps,
        _SMimeCaps_val_Type_1,
        pk_rsaSSA_PSS,
        _pk_rsaSSA_PSS_val_KeyValue,
        _pk_rsaSSA_PSS_val_Params,
        sa_rsaSSA_PSS,
        _sa_rsaSSA_PSS_val_Params,
        sa_sha224WithRSAEncryption,
        _sa_sha224WithRSAEncryption_val_Params,
        sha224WithRSAEncryption,
        sa_sha256WithRSAEncryption,
        _sa_sha256WithRSAEncryption_val_Params,
        sha256WithRSAEncryption,
        sa_sha384WithRSAEncryption,
        _sa_sha384WithRSAEncryption_val_Params,
        sha384WithRSAEncryption,
        sa_sha512WithRSAEncryption,
        _sa_sha512WithRSAEncryption_val_Params,
        sha512WithRSAEncryption,
        pk_rsaES_OAEP,
        _pk_rsaES_OAEP_val_KeyValue,
        _pk_rsaES_OAEP_val_Params,
        kta_rsaES_OAEP,
        _kta_rsaES_OAEP_val_Params,
        pkcs_1,
        id_RSAES_OAEP,
        id_mgf1,
        id_pSpecified,
        id_RSASSA_PSS,
        id_sha224,
        mda_sha224,
        _mda_sha224_val_Params,
        id_sha256,
        mda_sha256,
        _mda_sha256_val_Params,
        id_sha384,
        mda_sha384,
        _mda_sha384_val_Params,
        id_sha512,
        mda_sha512,
        _mda_sha512_val_Params,
        EncodingParameters,
        nullOctetString,
        nullParameters,
        __HashAlgorithm_algorithm_tab,
        ___HashAlgorithm_algorithm_tab_val_Params_0,
        ___HashAlgorithm_algorithm_tab_val_Params_1,
        ___HashAlgorithm_algorithm_tab_val_Params_2,
        ___HashAlgorithm_algorithm_tab_val_Params_3,
        ___HashAlgorithm_algorithm_tab_val_Params_4,
        _HashAlgorithm_algorithm,
        _HashAlgorithm_parameters,
        HashAlgorithm,
        HashAlgorithms,
        _HashAlgorithms_val_Params_0,
        _HashAlgorithms_val_Params_1,
        _HashAlgorithms_val_Params_2,
        _HashAlgorithms_val_Params_3,
        _HashAlgorithms_val_Params_4,
        sha1Identifier,
        _parameters_val,
        __MaskGenAlgorithm_algorithm_tab,
        ___MaskGenAlgorithm_algorithm_tab_val_Params_0,
        _MaskGenAlgorithm_algorithm,
        _MaskGenAlgorithm_parameters,
        MaskGenAlgorithm,
        mgf1SHA1,
        _parameters_val_0,
        PKCS1MGFAlgorithms,
        _PKCS1MGFAlgorithms_val_Params_0,
        __PSourceAlgorithm_algorithm_tab,
        ___PSourceAlgorithm_algorithm_tab_val_Params_0,
        _PSourceAlgorithm_algorithm,
        _PSourceAlgorithm_parameters,
        PSourceAlgorithm,
        PSS_SourceAlgorithms,
        _PSS_SourceAlgorithms_val_Params_0,
        pSpecifiedEmpty,
        _parameters_val_1,
        _RSASSA_PSS_params_hashAlgorithm,
        _RSASSA_PSS_params_maskGenAlgorithm,
        _RSASSA_PSS_params_saltLength,
        _RSASSA_PSS_params_trailerField,
        RSASSA_PSS_params,
        _RSAES_OAEP_params_hashFunc,
        _RSAES_OAEP_params_maskGenFunc,
        _RSAES_OAEP_params_pSourceFunc,
        RSAES_OAEP_params,
    ]

class PKIXAlgs_2009:

    _name_  = u'PKIXAlgs-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 56]
    
    _obj_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'SMimeCaps',
        u'pk-rsa',
        u'rsaEncryption',
        u'RSAPublicKey',
        u'pk-dsa',
        u'id-dsa',
        u'DSA-Params',
        u'DSAPublicKey',
        u'pk-dh',
        u'dhpublicnumber',
        u'DomainParameters',
        u'ValidationParams',
        u'DHPublicKey',
        u'pk-kea',
        u'id-keyExchangeAlgorithm',
        u'KEA-Params-Id',
        u'pk-ec',
        u'ECPoint',
        u'id-ecPublicKey',
        u'pk-ecDH',
        u'id-ecDH',
        u'pk-ecMQV',
        u'id-ecMQV',
        u'ECParameters',
        u'CURVE',
        u'NamedCurve',
        u'secp192r1',
        u'sect163k1',
        u'sect163r2',
        u'secp224r1',
        u'sect233k1',
        u'sect233r1',
        u'secp256r1',
        u'sect283k1',
        u'sect283r1',
        u'secp384r1',
        u'sect409k1',
        u'sect409r1',
        u'secp521r1',
        u'sect571k1',
        u'sect571r1',
        u'sa-rsaWithMD2',
        u'md2WithRSAEncryption',
        u'sa-rsaWithMD5',
        u'md5WithRSAEncryption',
        u'sa-rsaWithSHA1',
        u'sha1WithRSAEncryption',
        u'sa-dsaWithSHA1',
        u'dsa-with-sha1',
        u'sa-dsaWithSHA224',
        u'dsa-with-sha224',
        u'sa-dsaWithSHA256',
        u'dsa-with-sha256',
        u'sa-ecdsaWithSHA1',
        u'ecdsa-with-SHA1',
        u'sa-ecdsaWithSHA224',
        u'ecdsa-with-SHA224',
        u'sa-ecdsaWithSHA256',
        u'ecdsa-with-SHA256',
        u'sa-ecdsaWithSHA384',
        u'ecdsa-with-SHA384',
        u'sa-ecdsaWithSHA512',
        u'ecdsa-with-SHA512',
        u'DSA-Sig-Value',
        u'ECDSA-Sig-Value',
        u'HashAlgs',
        u'mda-md2',
        u'id-md2',
        u'mda-md5',
        u'id-md5',
        u'mda-sha1',
        u'id-sha1',
        ]
    _type_ = [
        u'RSAPublicKey',
        u'DSA-Params',
        u'DSAPublicKey',
        u'DomainParameters',
        u'ValidationParams',
        u'DHPublicKey',
        u'KEA-Params-Id',
        u'ECPoint',
        u'ECParameters',
        u'CURVE',
        u'DSA-Sig-Value',
        u'ECDSA-Sig-Value',
        ]
    _set_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'SMimeCaps',
        u'NamedCurve',
        u'HashAlgs',
        ]
    _val_ = [
        u'pk-rsa',
        u'rsaEncryption',
        u'pk-dsa',
        u'id-dsa',
        u'pk-dh',
        u'dhpublicnumber',
        u'pk-kea',
        u'id-keyExchangeAlgorithm',
        u'pk-ec',
        u'id-ecPublicKey',
        u'pk-ecDH',
        u'id-ecDH',
        u'pk-ecMQV',
        u'id-ecMQV',
        u'secp192r1',
        u'sect163k1',
        u'sect163r2',
        u'secp224r1',
        u'sect233k1',
        u'sect233r1',
        u'secp256r1',
        u'sect283k1',
        u'sect283r1',
        u'secp384r1',
        u'sect409k1',
        u'sect409r1',
        u'secp521r1',
        u'sect571k1',
        u'sect571r1',
        u'sa-rsaWithMD2',
        u'md2WithRSAEncryption',
        u'sa-rsaWithMD5',
        u'md5WithRSAEncryption',
        u'sa-rsaWithSHA1',
        u'sha1WithRSAEncryption',
        u'sa-dsaWithSHA1',
        u'dsa-with-sha1',
        u'sa-dsaWithSHA224',
        u'dsa-with-sha224',
        u'sa-dsaWithSHA256',
        u'dsa-with-sha256',
        u'sa-ecdsaWithSHA1',
        u'ecdsa-with-SHA1',
        u'sa-ecdsaWithSHA224',
        u'ecdsa-with-SHA224',
        u'sa-ecdsaWithSHA256',
        u'ecdsa-with-SHA256',
        u'sa-ecdsaWithSHA384',
        u'ecdsa-with-SHA384',
        u'sa-ecdsaWithSHA512',
        u'ecdsa-with-SHA512',
        u'mda-md2',
        u'id-md2',
        u'mda-md5',
        u'id-md5',
        u'mda-sha1',
        u'id-sha1',
        ]
    _class_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'SMimeCaps',
        u'pk-rsa',
        u'pk-dsa',
        u'pk-dh',
        u'pk-kea',
        u'pk-ec',
        u'pk-ecDH',
        u'pk-ecMQV',
        u'CURVE',
        u'NamedCurve',
        u'sa-rsaWithMD2',
        u'sa-rsaWithMD5',
        u'sa-rsaWithSHA1',
        u'sa-dsaWithSHA1',
        u'sa-dsaWithSHA224',
        u'sa-dsaWithSHA256',
        u'sa-ecdsaWithSHA1',
        u'sa-ecdsaWithSHA224',
        u'sa-ecdsaWithSHA256',
        u'sa-ecdsaWithSHA384',
        u'sa-ecdsaWithSHA512',
        u'HashAlgs',
        u'mda-md2',
        u'mda-md5',
        u'mda-sha1',
        ]
    _param_ = [
        ]
    
    #-----< PublicKeys >-----#
    PublicKeys = CLASS(name=u'PublicKeys', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _PublicKeys_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeys_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _PublicKeys_val_KeyValue_1 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    _PublicKeys_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    _PublicKeys_val_KeyValue_2 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _PublicKeys_val_Params_2 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    _PublicKeys_val_Params_3 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'KEA-Params-Id')))
    _PublicKeys_val_KeyValue_4 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeys_val_Params_4 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _PublicKeys_val_KeyValue_5 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeys_val_Params_5 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _PublicKeys_val_KeyValue_6 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeys_val_Params_6 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    PublicKeys._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', _PublicKeys_val_KeyValue_0), (u'Params', _PublicKeys_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', _PublicKeys_val_KeyValue_1), (u'Params', _PublicKeys_val_Params_1), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _PublicKeys_val_KeyValue_2), (u'Params', _PublicKeys_val_Params_2), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))]), dict([(u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22)), (u'Params', _PublicKeys_val_Params_3), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])], rr=[], ev=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', _PublicKeys_val_KeyValue_4), (u'Params', _PublicKeys_val_Params_4), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))]), dict([(u'id', (1, 3, 132, 1, 12)), (u'KeyValue', _PublicKeys_val_KeyValue_5), (u'Params', _PublicKeys_val_Params_5), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 3, 132, 1, 13)), (u'KeyValue', _PublicKeys_val_KeyValue_6), (u'Params', _PublicKeys_val_Params_6), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])], er=[])
    
    #-----< SignatureAlgs >-----#
    SignatureAlgs = CLASS(name=u'SignatureAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _SignatureAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgs_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    _SignatureAlgs_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgs_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _SignatureAlgs_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgs_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgs_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgs_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgs_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgs_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgs_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    SignatureAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', _SignatureAlgs_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', _SignatureAlgs_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', _SignatureAlgs_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', _SignatureAlgs_val_Value_3), (u'Params', _SignatureAlgs_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', _SignatureAlgs_val_Value_4), (u'Params', _SignatureAlgs_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', _SignatureAlgs_val_Value_5), (u'Params', _SignatureAlgs_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', _SignatureAlgs_val_Value_6), (u'Params', _SignatureAlgs_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', _SignatureAlgs_val_Value_7), (u'Params', _SignatureAlgs_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', _SignatureAlgs_val_Value_8), (u'Params', _SignatureAlgs_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', _SignatureAlgs_val_Value_9), (u'Params', _SignatureAlgs_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', _SignatureAlgs_val_Value_10), (u'Params', _SignatureAlgs_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))])], er=[])
    
    #-----< SMimeCaps >-----#
    SMimeCaps = CLASS(name=u'SMimeCaps', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    SMimeCaps._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'id', (1, 2, 840, 10040, 4, 3))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))])], rr=[], ev=[], er=[])
    
    #-----< pk-rsa >-----#
    pk_rsa = CLASS(name=u'pk-rsa', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_rsa_val_KeyValue = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _pk_rsa_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    pk_rsa._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', _pk_rsa_val_KeyValue), (u'Params', _pk_rsa_val_Params), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])
    
    #-----< rsaEncryption >-----#
    rsaEncryption = OID(name=u'rsaEncryption', mode=MODE_VALUE)
    rsaEncryption._val = (1, 2, 840, 113549, 1, 1, 1)
    
    #-----< RSAPublicKey >-----#
    RSAPublicKey = SEQ(name=u'RSAPublicKey', mode=MODE_TYPE)
    _RSAPublicKey_modulus = INT(name=u'modulus', mode=MODE_TYPE)
    _RSAPublicKey_publicExponent = INT(name=u'publicExponent', mode=MODE_TYPE)
    RSAPublicKey._cont = ASN1Dict([
        (u'modulus', _RSAPublicKey_modulus),
        (u'publicExponent', _RSAPublicKey_publicExponent),
        ])
    RSAPublicKey._ext = None
    
    #-----< pk-dsa >-----#
    pk_dsa = CLASS(name=u'pk-dsa', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_dsa_val_KeyValue = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    _pk_dsa_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    pk_dsa._val = dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', _pk_dsa_val_KeyValue), (u'Params', _pk_dsa_val_Params), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])
    
    #-----< id-dsa >-----#
    id_dsa = OID(name=u'id-dsa', mode=MODE_VALUE)
    id_dsa._val = (1, 2, 840, 10040, 4, 1)
    
    #-----< DSA-Params >-----#
    DSA_Params = SEQ(name=u'DSA-Params', mode=MODE_TYPE)
    _DSA_Params_p = INT(name=u'p', mode=MODE_TYPE)
    _DSA_Params_q = INT(name=u'q', mode=MODE_TYPE)
    _DSA_Params_g = INT(name=u'g', mode=MODE_TYPE)
    DSA_Params._cont = ASN1Dict([
        (u'p', _DSA_Params_p),
        (u'q', _DSA_Params_q),
        (u'g', _DSA_Params_g),
        ])
    DSA_Params._ext = None
    
    #-----< DSAPublicKey >-----#
    DSAPublicKey = INT(name=u'DSAPublicKey', mode=MODE_TYPE)
    
    #-----< pk-dh >-----#
    pk_dh = CLASS(name=u'pk-dh', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_dh_val_KeyValue = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _pk_dh_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    pk_dh._val = dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _pk_dh_val_KeyValue), (u'Params', _pk_dh_val_Params), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])
    
    #-----< dhpublicnumber >-----#
    dhpublicnumber = OID(name=u'dhpublicnumber', mode=MODE_VALUE)
    dhpublicnumber._val = (1, 2, 840, 10046, 2, 1)
    
    #-----< DomainParameters >-----#
    DomainParameters = SEQ(name=u'DomainParameters', mode=MODE_TYPE)
    _DomainParameters_p = INT(name=u'p', mode=MODE_TYPE)
    _DomainParameters_g = INT(name=u'g', mode=MODE_TYPE)
    _DomainParameters_q = INT(name=u'q', mode=MODE_TYPE)
    _DomainParameters_j = INT(name=u'j', mode=MODE_TYPE, opt=True)
    _DomainParameters_validationParams = SEQ(name=u'validationParams', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ValidationParams')), opt=True)
    DomainParameters._cont = ASN1Dict([
        (u'p', _DomainParameters_p),
        (u'g', _DomainParameters_g),
        (u'q', _DomainParameters_q),
        (u'j', _DomainParameters_j),
        (u'validationParams', _DomainParameters_validationParams),
        ])
    DomainParameters._ext = None
    
    #-----< ValidationParams >-----#
    ValidationParams = SEQ(name=u'ValidationParams', mode=MODE_TYPE)
    _ValidationParams_seed = BIT_STR(name=u'seed', mode=MODE_TYPE)
    _ValidationParams_pgenCounter = INT(name=u'pgenCounter', mode=MODE_TYPE)
    ValidationParams._cont = ASN1Dict([
        (u'seed', _ValidationParams_seed),
        (u'pgenCounter', _ValidationParams_pgenCounter),
        ])
    ValidationParams._ext = None
    
    #-----< DHPublicKey >-----#
    DHPublicKey = INT(name=u'DHPublicKey', mode=MODE_TYPE)
    
    #-----< pk-kea >-----#
    pk_kea = CLASS(name=u'pk-kea', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_kea_val_Params = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'KEA-Params-Id')))
    pk_kea._val = dict([(u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22)), (u'Params', _pk_kea_val_Params), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])
    
    #-----< id-keyExchangeAlgorithm >-----#
    id_keyExchangeAlgorithm = OID(name=u'id-keyExchangeAlgorithm', mode=MODE_VALUE)
    id_keyExchangeAlgorithm._val = (2, 16, 840, 1, 101, 2, 1, 1, 22)
    
    #-----< KEA-Params-Id >-----#
    KEA_Params_Id = OCT_STR(name=u'KEA-Params-Id', mode=MODE_TYPE)
    
    #-----< pk-ec >-----#
    pk_ec = CLASS(name=u'pk-ec', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_ec_val_KeyValue = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _pk_ec_val_Params = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    pk_ec._val = dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', _pk_ec_val_KeyValue), (u'Params', _pk_ec_val_Params), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])
    
    #-----< ECPoint >-----#
    ECPoint = OCT_STR(name=u'ECPoint', mode=MODE_TYPE)
    
    #-----< id-ecPublicKey >-----#
    id_ecPublicKey = OID(name=u'id-ecPublicKey', mode=MODE_VALUE)
    id_ecPublicKey._val = (1, 2, 840, 10045, 2, 1)
    
    #-----< pk-ecDH >-----#
    pk_ecDH = CLASS(name=u'pk-ecDH', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_ecDH_val_KeyValue = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _pk_ecDH_val_Params = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    pk_ecDH._val = dict([(u'id', (1, 3, 132, 1, 12)), (u'KeyValue', _pk_ecDH_val_KeyValue), (u'Params', _pk_ecDH_val_Params), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])
    
    #-----< id-ecDH >-----#
    id_ecDH = OID(name=u'id-ecDH', mode=MODE_VALUE)
    id_ecDH._val = (1, 3, 132, 1, 12)
    
    #-----< pk-ecMQV >-----#
    pk_ecMQV = CLASS(name=u'pk-ecMQV', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_ecMQV_val_KeyValue = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _pk_ecMQV_val_Params = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    pk_ecMQV._val = dict([(u'id', (1, 3, 132, 1, 13)), (u'KeyValue', _pk_ecMQV_val_KeyValue), (u'Params', _pk_ecMQV_val_Params), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])
    
    #-----< id-ecMQV >-----#
    id_ecMQV = OID(name=u'id-ecMQV', mode=MODE_VALUE)
    id_ecMQV._val = (1, 3, 132, 1, 13)
    
    #-----< ECParameters >-----#
    ECParameters = CHOICE(name=u'ECParameters', mode=MODE_TYPE)
    _ECParameters_namedCurve = OID(name=u'namedCurve', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIXAlgs-2009', 'CURVE'), [u'id']))
    __ECParameters_namedCurve_tab = CLASS(name='_tab_CURVE', mode=MODE_SET, typeref=ASN1RefType(('PKIXAlgs-2009', 'CURVE')))
    __ECParameters_namedCurve_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 3, 1, 1))]), dict([(u'id', (1, 3, 132, 0, 1))]), dict([(u'id', (1, 3, 132, 0, 15))]), dict([(u'id', (1, 3, 132, 0, 33))]), dict([(u'id', (1, 3, 132, 0, 26))]), dict([(u'id', (1, 3, 132, 0, 27))]), dict([(u'id', (1, 2, 840, 10045, 3, 1, 7))]), dict([(u'id', (1, 3, 132, 0, 16))]), dict([(u'id', (1, 3, 132, 0, 17))]), dict([(u'id', (1, 3, 132, 0, 34))]), dict([(u'id', (1, 3, 132, 0, 36))]), dict([(u'id', (1, 3, 132, 0, 37))]), dict([(u'id', (1, 3, 132, 0, 35))]), dict([(u'id', (1, 3, 132, 0, 38))]), dict([(u'id', (1, 3, 132, 0, 39))])], rr=[], ev=None, er=[])
    _ECParameters_namedCurve._const_tab = __ECParameters_namedCurve_tab
    _ECParameters_namedCurve._const_tab_at = None
    _ECParameters_namedCurve._const_tab_id = u'id'
    ECParameters._cont = ASN1Dict([
        (u'namedCurve', _ECParameters_namedCurve),
        ])
    ECParameters._ext = None
    
    #-----< CURVE >-----#
    CURVE = CLASS(name=u'CURVE', mode=MODE_TYPE)
    _CURVE_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    CURVE._cont = ASN1Dict([
        (u'id', _CURVE_id),
        ])
    
    #-----< NamedCurve >-----#
    NamedCurve = CLASS(name=u'NamedCurve', mode=MODE_SET, typeref=ASN1RefType(('PKIXAlgs-2009', 'CURVE')))
    NamedCurve._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 3, 1, 1))]), dict([(u'id', (1, 3, 132, 0, 1))]), dict([(u'id', (1, 3, 132, 0, 15))]), dict([(u'id', (1, 3, 132, 0, 33))]), dict([(u'id', (1, 3, 132, 0, 26))]), dict([(u'id', (1, 3, 132, 0, 27))]), dict([(u'id', (1, 2, 840, 10045, 3, 1, 7))]), dict([(u'id', (1, 3, 132, 0, 16))]), dict([(u'id', (1, 3, 132, 0, 17))]), dict([(u'id', (1, 3, 132, 0, 34))]), dict([(u'id', (1, 3, 132, 0, 36))]), dict([(u'id', (1, 3, 132, 0, 37))]), dict([(u'id', (1, 3, 132, 0, 35))]), dict([(u'id', (1, 3, 132, 0, 38))]), dict([(u'id', (1, 3, 132, 0, 39))])], rr=[], ev=[], er=[])
    
    #-----< secp192r1 >-----#
    secp192r1 = OID(name=u'secp192r1', mode=MODE_VALUE)
    secp192r1._val = (1, 2, 840, 10045, 3, 1, 1)
    
    #-----< sect163k1 >-----#
    sect163k1 = OID(name=u'sect163k1', mode=MODE_VALUE)
    sect163k1._val = (1, 3, 132, 0, 1)
    
    #-----< sect163r2 >-----#
    sect163r2 = OID(name=u'sect163r2', mode=MODE_VALUE)
    sect163r2._val = (1, 3, 132, 0, 15)
    
    #-----< secp224r1 >-----#
    secp224r1 = OID(name=u'secp224r1', mode=MODE_VALUE)
    secp224r1._val = (1, 3, 132, 0, 33)
    
    #-----< sect233k1 >-----#
    sect233k1 = OID(name=u'sect233k1', mode=MODE_VALUE)
    sect233k1._val = (1, 3, 132, 0, 26)
    
    #-----< sect233r1 >-----#
    sect233r1 = OID(name=u'sect233r1', mode=MODE_VALUE)
    sect233r1._val = (1, 3, 132, 0, 27)
    
    #-----< secp256r1 >-----#
    secp256r1 = OID(name=u'secp256r1', mode=MODE_VALUE)
    secp256r1._val = (1, 2, 840, 10045, 3, 1, 7)
    
    #-----< sect283k1 >-----#
    sect283k1 = OID(name=u'sect283k1', mode=MODE_VALUE)
    sect283k1._val = (1, 3, 132, 0, 16)
    
    #-----< sect283r1 >-----#
    sect283r1 = OID(name=u'sect283r1', mode=MODE_VALUE)
    sect283r1._val = (1, 3, 132, 0, 17)
    
    #-----< secp384r1 >-----#
    secp384r1 = OID(name=u'secp384r1', mode=MODE_VALUE)
    secp384r1._val = (1, 3, 132, 0, 34)
    
    #-----< sect409k1 >-----#
    sect409k1 = OID(name=u'sect409k1', mode=MODE_VALUE)
    sect409k1._val = (1, 3, 132, 0, 36)
    
    #-----< sect409r1 >-----#
    sect409r1 = OID(name=u'sect409r1', mode=MODE_VALUE)
    sect409r1._val = (1, 3, 132, 0, 37)
    
    #-----< secp521r1 >-----#
    secp521r1 = OID(name=u'secp521r1', mode=MODE_VALUE)
    secp521r1._val = (1, 3, 132, 0, 35)
    
    #-----< sect571k1 >-----#
    sect571k1 = OID(name=u'sect571k1', mode=MODE_VALUE)
    sect571k1._val = (1, 3, 132, 0, 38)
    
    #-----< sect571r1 >-----#
    sect571r1 = OID(name=u'sect571r1', mode=MODE_VALUE)
    sect571r1._val = (1, 3, 132, 0, 39)
    
    #-----< sa-rsaWithMD2 >-----#
    sa_rsaWithMD2 = CLASS(name=u'sa-rsaWithMD2', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_rsaWithMD2_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_rsaWithMD2._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', _sa_rsaWithMD2_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))])
    
    #-----< md2WithRSAEncryption >-----#
    md2WithRSAEncryption = OID(name=u'md2WithRSAEncryption', mode=MODE_VALUE)
    md2WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 2)
    
    #-----< sa-rsaWithMD5 >-----#
    sa_rsaWithMD5 = CLASS(name=u'sa-rsaWithMD5', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_rsaWithMD5_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_rsaWithMD5._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', _sa_rsaWithMD5_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))])
    
    #-----< md5WithRSAEncryption >-----#
    md5WithRSAEncryption = OID(name=u'md5WithRSAEncryption', mode=MODE_VALUE)
    md5WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 4)
    
    #-----< sa-rsaWithSHA1 >-----#
    sa_rsaWithSHA1 = CLASS(name=u'sa-rsaWithSHA1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_rsaWithSHA1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_rsaWithSHA1._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', _sa_rsaWithSHA1_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))])
    
    #-----< sha1WithRSAEncryption >-----#
    sha1WithRSAEncryption = OID(name=u'sha1WithRSAEncryption', mode=MODE_VALUE)
    sha1WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 5)
    
    #-----< sa-dsaWithSHA1 >-----#
    sa_dsaWithSHA1 = CLASS(name=u'sa-dsaWithSHA1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_dsaWithSHA1_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _sa_dsaWithSHA1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_dsaWithSHA1._val = dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', _sa_dsaWithSHA1_val_Value), (u'Params', _sa_dsaWithSHA1_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))])
    
    #-----< dsa-with-sha1 >-----#
    dsa_with_sha1 = OID(name=u'dsa-with-sha1', mode=MODE_VALUE)
    dsa_with_sha1._val = (1, 2, 840, 10040, 4, 3)
    
    #-----< sa-dsaWithSHA224 >-----#
    sa_dsaWithSHA224 = CLASS(name=u'sa-dsaWithSHA224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_dsaWithSHA224_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _sa_dsaWithSHA224_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_dsaWithSHA224._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', _sa_dsaWithSHA224_val_Value), (u'Params', _sa_dsaWithSHA224_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))])
    
    #-----< dsa-with-sha224 >-----#
    dsa_with_sha224 = OID(name=u'dsa-with-sha224', mode=MODE_VALUE)
    dsa_with_sha224._val = (2, 16, 840, 1, 101, 3, 4, 3, 1)
    
    #-----< sa-dsaWithSHA256 >-----#
    sa_dsaWithSHA256 = CLASS(name=u'sa-dsaWithSHA256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_dsaWithSHA256_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _sa_dsaWithSHA256_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_dsaWithSHA256._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', _sa_dsaWithSHA256_val_Value), (u'Params', _sa_dsaWithSHA256_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))])
    
    #-----< dsa-with-sha256 >-----#
    dsa_with_sha256 = OID(name=u'dsa-with-sha256', mode=MODE_VALUE)
    dsa_with_sha256._val = (2, 16, 840, 1, 101, 3, 4, 3, 2)
    
    #-----< sa-ecdsaWithSHA1 >-----#
    sa_ecdsaWithSHA1 = CLASS(name=u'sa-ecdsaWithSHA1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_ecdsaWithSHA1_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _sa_ecdsaWithSHA1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_ecdsaWithSHA1._val = dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', _sa_ecdsaWithSHA1_val_Value), (u'Params', _sa_ecdsaWithSHA1_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])
    
    #-----< ecdsa-with-SHA1 >-----#
    ecdsa_with_SHA1 = OID(name=u'ecdsa-with-SHA1', mode=MODE_VALUE)
    ecdsa_with_SHA1._val = (1, 2, 840, 10045, 4, 1)
    
    #-----< sa-ecdsaWithSHA224 >-----#
    sa_ecdsaWithSHA224 = CLASS(name=u'sa-ecdsaWithSHA224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_ecdsaWithSHA224_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _sa_ecdsaWithSHA224_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_ecdsaWithSHA224._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', _sa_ecdsaWithSHA224_val_Value), (u'Params', _sa_ecdsaWithSHA224_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))])
    
    #-----< ecdsa-with-SHA224 >-----#
    ecdsa_with_SHA224 = OID(name=u'ecdsa-with-SHA224', mode=MODE_VALUE)
    ecdsa_with_SHA224._val = (1, 2, 840, 10045, 4, 3, 1)
    
    #-----< sa-ecdsaWithSHA256 >-----#
    sa_ecdsaWithSHA256 = CLASS(name=u'sa-ecdsaWithSHA256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_ecdsaWithSHA256_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _sa_ecdsaWithSHA256_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_ecdsaWithSHA256._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', _sa_ecdsaWithSHA256_val_Value), (u'Params', _sa_ecdsaWithSHA256_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))])
    
    #-----< ecdsa-with-SHA256 >-----#
    ecdsa_with_SHA256 = OID(name=u'ecdsa-with-SHA256', mode=MODE_VALUE)
    ecdsa_with_SHA256._val = (1, 2, 840, 10045, 4, 3, 2)
    
    #-----< sa-ecdsaWithSHA384 >-----#
    sa_ecdsaWithSHA384 = CLASS(name=u'sa-ecdsaWithSHA384', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_ecdsaWithSHA384_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _sa_ecdsaWithSHA384_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_ecdsaWithSHA384._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', _sa_ecdsaWithSHA384_val_Value), (u'Params', _sa_ecdsaWithSHA384_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))])
    
    #-----< ecdsa-with-SHA384 >-----#
    ecdsa_with_SHA384 = OID(name=u'ecdsa-with-SHA384', mode=MODE_VALUE)
    ecdsa_with_SHA384._val = (1, 2, 840, 10045, 4, 3, 3)
    
    #-----< sa-ecdsaWithSHA512 >-----#
    sa_ecdsaWithSHA512 = CLASS(name=u'sa-ecdsaWithSHA512', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_ecdsaWithSHA512_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _sa_ecdsaWithSHA512_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_ecdsaWithSHA512._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', _sa_ecdsaWithSHA512_val_Value), (u'Params', _sa_ecdsaWithSHA512_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))])
    
    #-----< ecdsa-with-SHA512 >-----#
    ecdsa_with_SHA512 = OID(name=u'ecdsa-with-SHA512', mode=MODE_VALUE)
    ecdsa_with_SHA512._val = (1, 2, 840, 10045, 4, 3, 4)
    
    #-----< DSA-Sig-Value >-----#
    DSA_Sig_Value = SEQ(name=u'DSA-Sig-Value', mode=MODE_TYPE)
    _DSA_Sig_Value_r = INT(name=u'r', mode=MODE_TYPE)
    _DSA_Sig_Value_s = INT(name=u's', mode=MODE_TYPE)
    DSA_Sig_Value._cont = ASN1Dict([
        (u'r', _DSA_Sig_Value_r),
        (u's', _DSA_Sig_Value_s),
        ])
    DSA_Sig_Value._ext = None
    
    #-----< ECDSA-Sig-Value >-----#
    ECDSA_Sig_Value = SEQ(name=u'ECDSA-Sig-Value', mode=MODE_TYPE)
    _ECDSA_Sig_Value_r = INT(name=u'r', mode=MODE_TYPE)
    _ECDSA_Sig_Value_s = INT(name=u's', mode=MODE_TYPE)
    ECDSA_Sig_Value._cont = ASN1Dict([
        (u'r', _ECDSA_Sig_Value_r),
        (u's', _ECDSA_Sig_Value_s),
        ])
    ECDSA_Sig_Value._ext = None
    
    #-----< HashAlgs >-----#
    HashAlgs = CLASS(name=u'HashAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _HashAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgs_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgs_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    HashAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', _HashAlgs_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', _HashAlgs_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', _HashAlgs_val_Params_2), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=[], er=[])
    
    #-----< mda-md2 >-----#
    mda_md2 = CLASS(name=u'mda-md2', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_md2_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_md2._val = dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', _mda_md2_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-md2 >-----#
    id_md2 = OID(name=u'id-md2', mode=MODE_VALUE)
    id_md2._val = (1, 2, 840, 113549, 2, 2)
    
    #-----< mda-md5 >-----#
    mda_md5 = CLASS(name=u'mda-md5', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_md5_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_md5._val = dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', _mda_md5_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-md5 >-----#
    id_md5 = OID(name=u'id-md5', mode=MODE_VALUE)
    id_md5._val = (1, 2, 840, 113549, 2, 5)
    
    #-----< mda-sha1 >-----#
    mda_sha1 = CLASS(name=u'mda-sha1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_sha1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_sha1._val = dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', _mda_sha1_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-sha1 >-----#
    id_sha1 = OID(name=u'id-sha1', mode=MODE_VALUE)
    id_sha1._val = (1, 3, 14, 3, 2, 26)
    
    _all_ = [
        PublicKeys,
        _PublicKeys_val_KeyValue_0,
        _PublicKeys_val_Params_0,
        _PublicKeys_val_KeyValue_1,
        _PublicKeys_val_Params_1,
        _PublicKeys_val_KeyValue_2,
        _PublicKeys_val_Params_2,
        _PublicKeys_val_Params_3,
        _PublicKeys_val_KeyValue_4,
        _PublicKeys_val_Params_4,
        _PublicKeys_val_KeyValue_5,
        _PublicKeys_val_Params_5,
        _PublicKeys_val_KeyValue_6,
        _PublicKeys_val_Params_6,
        SignatureAlgs,
        _SignatureAlgs_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        _SignatureAlgs_val_Params_1,
        _SignatureAlgs_val_Params_2,
        _SignatureAlgs_val_Value_3,
        _SignatureAlgs_val_Params_3,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0,
        _SignatureAlgs_val_Value_4,
        _SignatureAlgs_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1,
        _SignatureAlgs_val_Value_5,
        _SignatureAlgs_val_Params_5,
        _SignatureAlgs_val_Value_6,
        _SignatureAlgs_val_Params_6,
        _SignatureAlgs_val_Value_7,
        _SignatureAlgs_val_Params_7,
        _SignatureAlgs_val_Value_8,
        _SignatureAlgs_val_Params_8,
        _SignatureAlgs_val_Value_9,
        _SignatureAlgs_val_Params_9,
        _SignatureAlgs_val_Value_10,
        _SignatureAlgs_val_Params_10,
        SMimeCaps,
        pk_rsa,
        _pk_rsa_val_KeyValue,
        _pk_rsa_val_Params,
        rsaEncryption,
        _RSAPublicKey_modulus,
        _RSAPublicKey_publicExponent,
        RSAPublicKey,
        pk_dsa,
        _pk_dsa_val_KeyValue,
        _pk_dsa_val_Params,
        id_dsa,
        _DSA_Params_p,
        _DSA_Params_q,
        _DSA_Params_g,
        DSA_Params,
        DSAPublicKey,
        pk_dh,
        _pk_dh_val_KeyValue,
        _pk_dh_val_Params,
        dhpublicnumber,
        _DomainParameters_p,
        _DomainParameters_g,
        _DomainParameters_q,
        _DomainParameters_j,
        _DomainParameters_validationParams,
        DomainParameters,
        _ValidationParams_seed,
        _ValidationParams_pgenCounter,
        ValidationParams,
        DHPublicKey,
        pk_kea,
        _pk_kea_val_Params,
        id_keyExchangeAlgorithm,
        KEA_Params_Id,
        pk_ec,
        _pk_ec_val_KeyValue,
        _pk_ec_val_Params,
        ECPoint,
        id_ecPublicKey,
        pk_ecDH,
        _pk_ecDH_val_KeyValue,
        _pk_ecDH_val_Params,
        id_ecDH,
        pk_ecMQV,
        _pk_ecMQV_val_KeyValue,
        _pk_ecMQV_val_Params,
        id_ecMQV,
        __ECParameters_namedCurve_tab,
        _ECParameters_namedCurve,
        ECParameters,
        _CURVE_id,
        CURVE,
        NamedCurve,
        secp192r1,
        sect163k1,
        sect163r2,
        secp224r1,
        sect233k1,
        sect233r1,
        secp256r1,
        sect283k1,
        sect283r1,
        secp384r1,
        sect409k1,
        sect409r1,
        secp521r1,
        sect571k1,
        sect571r1,
        sa_rsaWithMD2,
        _sa_rsaWithMD2_val_Params,
        md2WithRSAEncryption,
        sa_rsaWithMD5,
        _sa_rsaWithMD5_val_Params,
        md5WithRSAEncryption,
        sa_rsaWithSHA1,
        _sa_rsaWithSHA1_val_Params,
        sha1WithRSAEncryption,
        sa_dsaWithSHA1,
        _sa_dsaWithSHA1_val_Value,
        _sa_dsaWithSHA1_val_Params,
        dsa_with_sha1,
        sa_dsaWithSHA224,
        _sa_dsaWithSHA224_val_Value,
        _sa_dsaWithSHA224_val_Params,
        dsa_with_sha224,
        sa_dsaWithSHA256,
        _sa_dsaWithSHA256_val_Value,
        _sa_dsaWithSHA256_val_Params,
        dsa_with_sha256,
        sa_ecdsaWithSHA1,
        _sa_ecdsaWithSHA1_val_Value,
        _sa_ecdsaWithSHA1_val_Params,
        ecdsa_with_SHA1,
        sa_ecdsaWithSHA224,
        _sa_ecdsaWithSHA224_val_Value,
        _sa_ecdsaWithSHA224_val_Params,
        ecdsa_with_SHA224,
        sa_ecdsaWithSHA256,
        _sa_ecdsaWithSHA256_val_Value,
        _sa_ecdsaWithSHA256_val_Params,
        ecdsa_with_SHA256,
        sa_ecdsaWithSHA384,
        _sa_ecdsaWithSHA384_val_Value,
        _sa_ecdsaWithSHA384_val_Params,
        ecdsa_with_SHA384,
        sa_ecdsaWithSHA512,
        _sa_ecdsaWithSHA512_val_Value,
        _sa_ecdsaWithSHA512_val_Params,
        ecdsa_with_SHA512,
        _DSA_Sig_Value_r,
        _DSA_Sig_Value_s,
        DSA_Sig_Value,
        _ECDSA_Sig_Value_r,
        _ECDSA_Sig_Value_s,
        ECDSA_Sig_Value,
        HashAlgs,
        _HashAlgs_val_Params_0,
        _HashAlgs_val_Params_1,
        _HashAlgs_val_Params_2,
        mda_md2,
        _mda_md2_val_Params,
        id_md2,
        mda_md5,
        _mda_md5_val_Params,
        id_md5,
        mda_sha1,
        _mda_sha1_val_Params,
        id_sha1,
    ]

class PKIXAttributeCertificate_2009:

    _name_  = u'PKIXAttributeCertificate-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 47]
    
    _obj_ = [
        u'AttributeCertExtensions',
        u'ext-auditIdentity',
        u'ext-targetInformation',
        u'ext-noRevAvail',
        u'ext-ac-proxying',
        u'ext-aaControls',
        u'AttributesDefined',
        u'at-authenticationInfo',
        u'at-accesIdentity',
        u'at-chargingIdentity',
        u'at-group',
        u'at-role',
        u'at-clearance',
        u'at-clearance-RFC3281',
        u'at-encAttrs',
        u'id-pe-ac-auditIdentity',
        u'id-pe-aaControls',
        u'id-pe-ac-proxying',
        u'id-ce-targetInformation',
        u'id-ce-noRevAvail',
        u'id-aca',
        u'id-aca-authenticationInfo',
        u'id-aca-accessIdentity',
        u'id-aca-chargingIdentity',
        u'id-aca-group',
        u'id-aca-encAttrs',
        u'id-at-role',
        u'id-at-clearance',
        u'id-at-clearance-rfc3281',
        u'AttributeCertificate',
        u'AttributeCertificateInfo',
        u'AttCertVersion',
        u'Holder',
        u'ObjectDigestInfo',
        u'AttCertIssuer',
        u'V2Form',
        u'IssuerSerial',
        u'AttCertValidityPeriod',
        u'Targets',
        u'Target',
        u'TargetCert',
        u'AAControls',
        u'AttrSpec',
        u'ProxyInfo',
        u'IetfAttrSyntax',
        u'SvceAuthInfo',
        u'RoleSyntax',
        u'Clearance',
        u'Clearance-rfc3281',
        u'ClassList',
        u'SupportedSecurityCategories',
        u'SecurityCategory-rfc3281',
        u'ACClearAttrs',
        ]
    _type_ = [
        u'AttributeCertificate',
        u'AttributeCertificateInfo',
        u'AttCertVersion',
        u'Holder',
        u'ObjectDigestInfo',
        u'AttCertIssuer',
        u'V2Form',
        u'IssuerSerial',
        u'AttCertValidityPeriod',
        u'Targets',
        u'Target',
        u'TargetCert',
        u'AAControls',
        u'AttrSpec',
        u'ProxyInfo',
        u'IetfAttrSyntax',
        u'SvceAuthInfo',
        u'RoleSyntax',
        u'Clearance',
        u'Clearance-rfc3281',
        u'ClassList',
        u'SecurityCategory-rfc3281',
        u'ACClearAttrs',
        ]
    _set_ = [
        u'AttributeCertExtensions',
        u'AttributesDefined',
        u'SupportedSecurityCategories',
        ]
    _val_ = [
        u'ext-auditIdentity',
        u'ext-targetInformation',
        u'ext-noRevAvail',
        u'ext-ac-proxying',
        u'ext-aaControls',
        u'at-authenticationInfo',
        u'at-accesIdentity',
        u'at-chargingIdentity',
        u'at-group',
        u'at-role',
        u'at-clearance',
        u'at-clearance-RFC3281',
        u'at-encAttrs',
        u'id-pe-ac-auditIdentity',
        u'id-pe-aaControls',
        u'id-pe-ac-proxying',
        u'id-ce-targetInformation',
        u'id-ce-noRevAvail',
        u'id-aca',
        u'id-aca-authenticationInfo',
        u'id-aca-accessIdentity',
        u'id-aca-chargingIdentity',
        u'id-aca-group',
        u'id-aca-encAttrs',
        u'id-at-role',
        u'id-at-clearance',
        u'id-at-clearance-rfc3281',
        ]
    _class_ = [
        u'AttributeCertExtensions',
        u'ext-auditIdentity',
        u'ext-targetInformation',
        u'ext-noRevAvail',
        u'ext-ac-proxying',
        u'ext-aaControls',
        u'AttributesDefined',
        u'at-authenticationInfo',
        u'at-accesIdentity',
        u'at-chargingIdentity',
        u'at-group',
        u'at-role',
        u'at-clearance',
        u'at-clearance-RFC3281',
        u'at-encAttrs',
        u'SupportedSecurityCategories',
        ]
    _param_ = [
        u'SecurityCategory-rfc3281',
        ]
    
    #-----< AttributeCertExtensions >-----#
    AttributeCertExtensions = CLASS(name=u'AttributeCertExtensions', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _AttributeCertExtensions_val_ExtnType_0 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE)
    _AttributeCertExtensions_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Targets')))
    _AttributeCertExtensions_val_ExtnType_2 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _AttributeCertExtensions_val_ExtnType_3 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    _AttributeCertExtensions_val_ExtnType_4 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _AttributeCertExtensions_val_ExtnType_5 = NULL(name=u'ExtnType', mode=MODE_TYPE)
    _AttributeCertExtensions_val_ExtnType_6 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ProxyInfo')))
    _AttributeCertExtensions_val_ExtnType_7 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AAControls')))
    AttributeCertExtensions._val = ASN1Set(rv=[dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 4))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_1), (u'id', (2, 5, 29, 55))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_2), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_3), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_4), (u'id', (2, 5, 29, 31))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_5), (u'id', (2, 5, 29, 56))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_6), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 10))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_7), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 6))])], rr=[], ev=[], er=[])
    
    #-----< ext-auditIdentity >-----#
    ext_auditIdentity = CLASS(name=u'ext-auditIdentity', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_auditIdentity_val_ExtnType = OCT_STR(name=u'ExtnType', mode=MODE_TYPE)
    ext_auditIdentity._val = dict([(u'ExtnType', _ext_auditIdentity_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 4))])
    
    #-----< ext-targetInformation >-----#
    ext_targetInformation = CLASS(name=u'ext-targetInformation', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_targetInformation_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Targets')))
    ext_targetInformation._val = dict([(u'ExtnType', _ext_targetInformation_val_ExtnType), (u'id', (2, 5, 29, 55))])
    
    #-----< ext-noRevAvail >-----#
    ext_noRevAvail = CLASS(name=u'ext-noRevAvail', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_noRevAvail_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    ext_noRevAvail._val = dict([(u'ExtnType', _ext_noRevAvail_val_ExtnType), (u'id', (2, 5, 29, 56))])
    
    #-----< ext-ac-proxying >-----#
    ext_ac_proxying = CLASS(name=u'ext-ac-proxying', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_ac_proxying_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ProxyInfo')))
    ext_ac_proxying._val = dict([(u'ExtnType', _ext_ac_proxying_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 10))])
    
    #-----< ext-aaControls >-----#
    ext_aaControls = CLASS(name=u'ext-aaControls', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_aaControls_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AAControls')))
    ext_aaControls._val = dict([(u'ExtnType', _ext_aaControls_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 6))])
    
    #-----< AttributesDefined >-----#
    AttributesDefined = CLASS(name=u'AttributesDefined', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _AttributesDefined_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _AttributesDefined_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _AttributesDefined_val_Type_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _AttributesDefined_val_Type_3 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _AttributesDefined_val_Type_4 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'RoleSyntax')))
    _AttributesDefined_val_Type_5 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Clearance')))
    _AttributesDefined_val_Type_6 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentInfo')))
    AttributesDefined._val = ASN1Set(rv=[dict([(u'Type', _AttributesDefined_val_Type_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 1))]), dict([(u'Type', _AttributesDefined_val_Type_1), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 2))]), dict([(u'Type', _AttributesDefined_val_Type_2), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 3))]), dict([(u'Type', _AttributesDefined_val_Type_3), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 4))]), dict([(u'Type', _AttributesDefined_val_Type_4), (u'id', (2, 5, 4, 72))]), dict([(u'Type', _AttributesDefined_val_Type_5), (u'id', (2, 5, 4, 55))]), dict([(u'Type', _AttributesDefined_val_Type_6), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 6))])], rr=[], ev=[], er=[])
    
    #-----< at-authenticationInfo >-----#
    at_authenticationInfo = CLASS(name=u'at-authenticationInfo', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_authenticationInfo_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    at_authenticationInfo._val = dict([(u'Type', _at_authenticationInfo_val_Type), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 1))])
    
    #-----< at-accesIdentity >-----#
    at_accesIdentity = CLASS(name=u'at-accesIdentity', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_accesIdentity_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    at_accesIdentity._val = dict([(u'Type', _at_accesIdentity_val_Type), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 2))])
    
    #-----< at-chargingIdentity >-----#
    at_chargingIdentity = CLASS(name=u'at-chargingIdentity', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_chargingIdentity_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    at_chargingIdentity._val = dict([(u'Type', _at_chargingIdentity_val_Type), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 3))])
    
    #-----< at-group >-----#
    at_group = CLASS(name=u'at-group', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_group_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    at_group._val = dict([(u'Type', _at_group_val_Type), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 4))])
    
    #-----< at-role >-----#
    at_role = CLASS(name=u'at-role', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_role_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'RoleSyntax')))
    at_role._val = dict([(u'Type', _at_role_val_Type), (u'id', (2, 5, 4, 72))])
    
    #-----< at-clearance >-----#
    at_clearance = CLASS(name=u'at-clearance', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_clearance_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Clearance')))
    at_clearance._val = dict([(u'Type', _at_clearance_val_Type), (u'id', (2, 5, 4, 55))])
    
    #-----< at-clearance-RFC3281 >-----#
    at_clearance_RFC3281 = CLASS(name=u'at-clearance-RFC3281', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_clearance_RFC3281_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Clearance-rfc3281')))
    at_clearance_RFC3281._val = dict([(u'Type', _at_clearance_RFC3281_val_Type), (u'id', (2, 5, 1, 5, 55))])
    
    #-----< at-encAttrs >-----#
    at_encAttrs = CLASS(name=u'at-encAttrs', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_encAttrs_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentInfo')))
    at_encAttrs._val = dict([(u'Type', _at_encAttrs_val_Type), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 6))])
    
    #-----< id-pe-ac-auditIdentity >-----#
    id_pe_ac_auditIdentity = OID(name=u'id-pe-ac-auditIdentity', mode=MODE_VALUE)
    id_pe_ac_auditIdentity._val = (1, 3, 6, 1, 5, 5, 7, 1, 4)
    
    #-----< id-pe-aaControls >-----#
    id_pe_aaControls = OID(name=u'id-pe-aaControls', mode=MODE_VALUE)
    id_pe_aaControls._val = (1, 3, 6, 1, 5, 5, 7, 1, 6)
    
    #-----< id-pe-ac-proxying >-----#
    id_pe_ac_proxying = OID(name=u'id-pe-ac-proxying', mode=MODE_VALUE)
    id_pe_ac_proxying._val = (1, 3, 6, 1, 5, 5, 7, 1, 10)
    
    #-----< id-ce-targetInformation >-----#
    id_ce_targetInformation = OID(name=u'id-ce-targetInformation', mode=MODE_VALUE)
    id_ce_targetInformation._val = (2, 5, 29, 55)
    
    #-----< id-ce-noRevAvail >-----#
    id_ce_noRevAvail = OID(name=u'id-ce-noRevAvail', mode=MODE_VALUE)
    id_ce_noRevAvail._val = (2, 5, 29, 56)
    
    #-----< id-aca >-----#
    id_aca = OID(name=u'id-aca', mode=MODE_VALUE)
    id_aca._val = (1, 3, 6, 1, 5, 5, 7, 10)
    
    #-----< id-aca-authenticationInfo >-----#
    id_aca_authenticationInfo = OID(name=u'id-aca-authenticationInfo', mode=MODE_VALUE)
    id_aca_authenticationInfo._val = (1, 3, 6, 1, 5, 5, 7, 10, 1)
    
    #-----< id-aca-accessIdentity >-----#
    id_aca_accessIdentity = OID(name=u'id-aca-accessIdentity', mode=MODE_VALUE)
    id_aca_accessIdentity._val = (1, 3, 6, 1, 5, 5, 7, 10, 2)
    
    #-----< id-aca-chargingIdentity >-----#
    id_aca_chargingIdentity = OID(name=u'id-aca-chargingIdentity', mode=MODE_VALUE)
    id_aca_chargingIdentity._val = (1, 3, 6, 1, 5, 5, 7, 10, 3)
    
    #-----< id-aca-group >-----#
    id_aca_group = OID(name=u'id-aca-group', mode=MODE_VALUE)
    id_aca_group._val = (1, 3, 6, 1, 5, 5, 7, 10, 4)
    
    #-----< id-aca-encAttrs >-----#
    id_aca_encAttrs = OID(name=u'id-aca-encAttrs', mode=MODE_VALUE)
    id_aca_encAttrs._val = (1, 3, 6, 1, 5, 5, 7, 10, 6)
    
    #-----< id-at-role >-----#
    id_at_role = OID(name=u'id-at-role', mode=MODE_VALUE)
    id_at_role._val = (2, 5, 4, 72)
    
    #-----< id-at-clearance >-----#
    id_at_clearance = OID(name=u'id-at-clearance', mode=MODE_VALUE)
    id_at_clearance._val = (2, 5, 4, 55)
    
    #-----< id-at-clearance-rfc3281 >-----#
    id_at_clearance_rfc3281 = OID(name=u'id-at-clearance-rfc3281', mode=MODE_VALUE)
    id_at_clearance_rfc3281._val = (2, 5, 1, 5, 55)
    
    #-----< AttributeCertificate >-----#
    AttributeCertificate = SEQ(name=u'AttributeCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'SIGNED')))
    _AttributeCertificate_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttributeCertificateInfo')))
    _AttributeCertificate_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE)
    __AttributeCertificate_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___AttributeCertificate_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    __SIGNATURE_ALGORITHM_HashSet_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___AttributeCertificate_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_3), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_4), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_5), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_6), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_7), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_8), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_9), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_10), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab = ___AttributeCertificate_algorithmIdentifier_algorithm_tab
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab_at = None
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __AttributeCertificate_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab = ___AttributeCertificate_algorithmIdentifier_algorithm_tab
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab_at = ('..', '..', u'algorithmIdentifier', u'algorithm')
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab_id = u'Params'
    _AttributeCertificate_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificate_algorithmIdentifier_algorithm),
        (u'parameters', __AttributeCertificate_algorithmIdentifier_parameters),
        ])
    _AttributeCertificate_algorithmIdentifier._ext = None
    _AttributeCertificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    __AttributeCertificate_signature_contain = OPEN(name='_cont_signature', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Value']))
    __AttributeCertificate_signature_contain._const_tab = ___AttributeCertificate_algorithmIdentifier_algorithm_tab
    __AttributeCertificate_signature_contain._const_tab_at = ('..', u'algorithmIdentifier', u'algorithm')
    __AttributeCertificate_signature_contain._const_tab_id = u'Value'
    _AttributeCertificate_signature._const_cont = __AttributeCertificate_signature_contain
    AttributeCertificate._cont = ASN1Dict([
        (u'toBeSigned', _AttributeCertificate_toBeSigned),
        (u'algorithmIdentifier', _AttributeCertificate_algorithmIdentifier),
        (u'signature', _AttributeCertificate_signature),
        ])
    AttributeCertificate._ext = None
    
    #-----< AttributeCertificateInfo >-----#
    AttributeCertificateInfo = SEQ(name=u'AttributeCertificateInfo', mode=MODE_TYPE)
    _AttributeCertificateInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttCertVersion')))
    _AttributeCertificateInfo_holder = SEQ(name=u'holder', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Holder')))
    _AttributeCertificateInfo_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttCertIssuer')))
    _AttributeCertificateInfo_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __AttributeCertificateInfo_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___AttributeCertificateInfo_signature_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___AttributeCertificateInfo_signature_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_3), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_4), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_5), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_6), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_7), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_8), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_9), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_10), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __AttributeCertificateInfo_signature_algorithm._const_tab = ___AttributeCertificateInfo_signature_algorithm_tab
    __AttributeCertificateInfo_signature_algorithm._const_tab_at = None
    __AttributeCertificateInfo_signature_algorithm._const_tab_id = u'id'
    __AttributeCertificateInfo_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __AttributeCertificateInfo_signature_parameters._const_tab = ___AttributeCertificateInfo_signature_algorithm_tab
    __AttributeCertificateInfo_signature_parameters._const_tab_at = ('..', u'algorithm')
    __AttributeCertificateInfo_signature_parameters._const_tab_id = u'Params'
    _AttributeCertificateInfo_signature._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificateInfo_signature_algorithm),
        (u'parameters', __AttributeCertificateInfo_signature_parameters),
        ])
    _AttributeCertificateInfo_signature._ext = None
    _AttributeCertificateInfo_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    _AttributeCertificateInfo_attrCertValidityPeriod = SEQ(name=u'attrCertValidityPeriod', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttCertValidityPeriod')))
    _AttributeCertificateInfo_attributes = SEQ_OF(name=u'attributes', mode=MODE_TYPE)
    __AttributeCertificateInfo_attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'AttributeSet')))
    ___AttributeCertificateInfo_attributes__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____AttributeCertificateInfo_attributes__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_3 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_4 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'RoleSyntax')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_5 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Clearance')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_6 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentInfo')))
    ____AttributeCertificateInfo_attributes__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 1))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_1), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 2))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_2), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 3))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_3), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 4))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_4), (u'id', (2, 5, 4, 72))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_5), (u'id', (2, 5, 4, 55))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_6), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 6))])], rr=[], ev=None, er=[])
    ___AttributeCertificateInfo_attributes__item__type._const_tab = ____AttributeCertificateInfo_attributes__item__type_tab
    ___AttributeCertificateInfo_attributes__item__type._const_tab_at = None
    ___AttributeCertificateInfo_attributes__item__type._const_tab_id = u'id'
    ___AttributeCertificateInfo_attributes__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AttributeCertificateInfo_attributes__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ____AttributeCertificateInfo_attributes__item__values__item_._const_tab = ____AttributeCertificateInfo_attributes__item__type_tab
    ____AttributeCertificateInfo_attributes__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AttributeCertificateInfo_attributes__item__values__item_._const_tab_id = u'Type'
    ___AttributeCertificateInfo_attributes__item__values._cont = ____AttributeCertificateInfo_attributes__item__values__item_
    ___AttributeCertificateInfo_attributes__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AttributeCertificateInfo_attributes__item_._cont = ASN1Dict([
        (u'type', ___AttributeCertificateInfo_attributes__item__type),
        (u'values', ___AttributeCertificateInfo_attributes__item__values),
        ])
    __AttributeCertificateInfo_attributes__item_._ext = None
    _AttributeCertificateInfo_attributes._cont = __AttributeCertificateInfo_attributes__item_
    _AttributeCertificateInfo_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'UniqueIdentifier')), opt=True)
    _AttributeCertificateInfo_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True)
    __AttributeCertificateInfo_extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___AttributeCertificateInfo_extensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____AttributeCertificateInfo_extensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_0 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE)
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Targets')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_2 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_3 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_4 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_5 = NULL(name=u'ExtnType', mode=MODE_TYPE)
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_6 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ProxyInfo')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_7 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AAControls')))
    ____AttributeCertificateInfo_extensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 4))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_1), (u'id', (2, 5, 29, 55))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_3), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_4), (u'id', (2, 5, 29, 31))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_5), (u'id', (2, 5, 29, 56))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_6), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 10))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_7), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 6))])], rr=[], ev=None, er=[])
    ___AttributeCertificateInfo_extensions__item__extnID._const_tab = ____AttributeCertificateInfo_extensions__item__extnID_tab
    ___AttributeCertificateInfo_extensions__item__extnID._const_tab_at = None
    ___AttributeCertificateInfo_extensions__item__extnID._const_tab_id = u'id'
    ___AttributeCertificateInfo_extensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___AttributeCertificateInfo_extensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____AttributeCertificateInfo_extensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____AttributeCertificateInfo_extensions__item__extnValue_contain._const_tab = ____AttributeCertificateInfo_extensions__item__extnID_tab
    ____AttributeCertificateInfo_extensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____AttributeCertificateInfo_extensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___AttributeCertificateInfo_extensions__item__extnValue._const_cont = ____AttributeCertificateInfo_extensions__item__extnValue_contain
    __AttributeCertificateInfo_extensions__item_._cont = ASN1Dict([
        (u'extnID', ___AttributeCertificateInfo_extensions__item__extnID),
        (u'critical', ___AttributeCertificateInfo_extensions__item__critical),
        (u'extnValue', ___AttributeCertificateInfo_extensions__item__extnValue),
        ])
    __AttributeCertificateInfo_extensions__item_._ext = None
    _AttributeCertificateInfo_extensions._cont = __AttributeCertificateInfo_extensions__item_
    _AttributeCertificateInfo_extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    AttributeCertificateInfo._cont = ASN1Dict([
        (u'version', _AttributeCertificateInfo_version),
        (u'holder', _AttributeCertificateInfo_holder),
        (u'issuer', _AttributeCertificateInfo_issuer),
        (u'signature', _AttributeCertificateInfo_signature),
        (u'serialNumber', _AttributeCertificateInfo_serialNumber),
        (u'attrCertValidityPeriod', _AttributeCertificateInfo_attrCertValidityPeriod),
        (u'attributes', _AttributeCertificateInfo_attributes),
        (u'issuerUniqueID', _AttributeCertificateInfo_issuerUniqueID),
        (u'extensions', _AttributeCertificateInfo_extensions),
        ])
    AttributeCertificateInfo._ext = None
    
    #-----< AttCertVersion >-----#
    AttCertVersion = INT(name=u'AttCertVersion', mode=MODE_TYPE)
    AttCertVersion._cont = ASN1Dict([(u'v2', 1)])
    
    #-----< Holder >-----#
    Holder = SEQ(name=u'Holder', mode=MODE_TYPE)
    _Holder_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IssuerSerial')), opt=True)
    _Holder_entityName = SEQ_OF(name=u'entityName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    _Holder_objectDigestInfo = SEQ(name=u'objectDigestInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ObjectDigestInfo')), opt=True)
    Holder._cont = ASN1Dict([
        (u'baseCertificateID', _Holder_baseCertificateID),
        (u'entityName', _Holder_entityName),
        (u'objectDigestInfo', _Holder_objectDigestInfo),
        ])
    Holder._ext = None
    
    #-----< ObjectDigestInfo >-----#
    ObjectDigestInfo = SEQ(name=u'ObjectDigestInfo', mode=MODE_TYPE)
    _ObjectDigestInfo_digestedObjectType = ENUM(name=u'digestedObjectType', mode=MODE_TYPE)
    _ObjectDigestInfo_digestedObjectType._cont = ASN1Dict([(u'publicKey', 0), (u'publicKeyCert', 1), (u'otherObjectTypes', 2)])
    _ObjectDigestInfo_digestedObjectType._ext = None
    _ObjectDigestInfo_otherObjectTypeID = OID(name=u'otherObjectTypeID', mode=MODE_TYPE, opt=True)
    _ObjectDigestInfo_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __ObjectDigestInfo_digestAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___ObjectDigestInfo_digestAlgorithm_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___ObjectDigestInfo_digestAlgorithm_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab = ___ObjectDigestInfo_digestAlgorithm_algorithm_tab
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab_at = None
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab_id = u'id'
    __ObjectDigestInfo_digestAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    ___ObjectDigestInfo_digestAlgorithm_parameters_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___ObjectDigestInfo_digestAlgorithm_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab = ___ObjectDigestInfo_digestAlgorithm_parameters_tab
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab_id = u'Params'
    _ObjectDigestInfo_digestAlgorithm._cont = ASN1Dict([
        (u'algorithm', __ObjectDigestInfo_digestAlgorithm_algorithm),
        (u'parameters', __ObjectDigestInfo_digestAlgorithm_parameters),
        ])
    _ObjectDigestInfo_digestAlgorithm._ext = None
    _ObjectDigestInfo_objectDigest = BIT_STR(name=u'objectDigest', mode=MODE_TYPE)
    ObjectDigestInfo._cont = ASN1Dict([
        (u'digestedObjectType', _ObjectDigestInfo_digestedObjectType),
        (u'otherObjectTypeID', _ObjectDigestInfo_otherObjectTypeID),
        (u'digestAlgorithm', _ObjectDigestInfo_digestAlgorithm),
        (u'objectDigest', _ObjectDigestInfo_objectDigest),
        ])
    ObjectDigestInfo._ext = None
    
    #-----< AttCertIssuer >-----#
    AttCertIssuer = CHOICE(name=u'AttCertIssuer', mode=MODE_TYPE)
    _AttCertIssuer_v1Form = SEQ_OF(name=u'v1Form', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _AttCertIssuer_v2Form = SEQ(name=u'v2Form', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'V2Form')))
    AttCertIssuer._cont = ASN1Dict([
        (u'v1Form', _AttCertIssuer_v1Form),
        (u'v2Form', _AttCertIssuer_v2Form),
        ])
    AttCertIssuer._ext = None
    
    #-----< V2Form >-----#
    V2Form = SEQ(name=u'V2Form', mode=MODE_TYPE)
    _V2Form_issuerName = SEQ_OF(name=u'issuerName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    _V2Form_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IssuerSerial')), opt=True)
    _V2Form_objectDigestInfo = SEQ(name=u'objectDigestInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ObjectDigestInfo')), opt=True)
    V2Form._cont = ASN1Dict([
        (u'issuerName', _V2Form_issuerName),
        (u'baseCertificateID', _V2Form_baseCertificateID),
        (u'objectDigestInfo', _V2Form_objectDigestInfo),
        ])
    V2Form._ext = None
    
    #-----< IssuerSerial >-----#
    IssuerSerial = SEQ(name=u'IssuerSerial', mode=MODE_TYPE)
    _IssuerSerial_issuer = SEQ_OF(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _IssuerSerial_serial = INT(name=u'serial', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    _IssuerSerial_issuerUID = BIT_STR(name=u'issuerUID', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'UniqueIdentifier')), opt=True)
    IssuerSerial._cont = ASN1Dict([
        (u'issuer', _IssuerSerial_issuer),
        (u'serial', _IssuerSerial_serial),
        (u'issuerUID', _IssuerSerial_issuerUID),
        ])
    IssuerSerial._ext = None
    
    #-----< AttCertValidityPeriod >-----#
    AttCertValidityPeriod = SEQ(name=u'AttCertValidityPeriod', mode=MODE_TYPE)
    _AttCertValidityPeriod_notBeforeTime = TIME_GEN(name=u'notBeforeTime', mode=MODE_TYPE)
    _AttCertValidityPeriod_notAfterTime = TIME_GEN(name=u'notAfterTime', mode=MODE_TYPE)
    AttCertValidityPeriod._cont = ASN1Dict([
        (u'notBeforeTime', _AttCertValidityPeriod_notBeforeTime),
        (u'notAfterTime', _AttCertValidityPeriod_notAfterTime),
        ])
    AttCertValidityPeriod._ext = None
    
    #-----< Targets >-----#
    Targets = SEQ_OF(name=u'Targets', mode=MODE_TYPE)
    _Targets__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Target')))
    Targets._cont = _Targets__item_
    
    #-----< Target >-----#
    Target = CHOICE(name=u'Target', mode=MODE_TYPE)
    _Target_targetName = CHOICE(name=u'targetName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _Target_targetGroup = CHOICE(name=u'targetGroup', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _Target_targetCert = SEQ(name=u'targetCert', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'TargetCert')))
    Target._cont = ASN1Dict([
        (u'targetName', _Target_targetName),
        (u'targetGroup', _Target_targetGroup),
        (u'targetCert', _Target_targetCert),
        ])
    Target._ext = None
    
    #-----< TargetCert >-----#
    TargetCert = SEQ(name=u'TargetCert', mode=MODE_TYPE)
    _TargetCert_targetCertificate = SEQ(name=u'targetCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IssuerSerial')))
    _TargetCert_targetName = CHOICE(name=u'targetName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')), opt=True)
    _TargetCert_certDigestInfo = SEQ(name=u'certDigestInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ObjectDigestInfo')), opt=True)
    TargetCert._cont = ASN1Dict([
        (u'targetCertificate', _TargetCert_targetCertificate),
        (u'targetName', _TargetCert_targetName),
        (u'certDigestInfo', _TargetCert_certDigestInfo),
        ])
    TargetCert._ext = None
    
    #-----< AAControls >-----#
    AAControls = SEQ(name=u'AAControls', mode=MODE_TYPE)
    _AAControls_pathLenConstraint = INT(name=u'pathLenConstraint', mode=MODE_TYPE, opt=True)
    _AAControls_pathLenConstraint._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _AAControls_permittedAttrs = SEQ_OF(name=u'permittedAttrs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttrSpec')), opt=True)
    _AAControls_excludedAttrs = SEQ_OF(name=u'excludedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttrSpec')), opt=True)
    _AAControls_permitUnSpecified = BOOL(name=u'permitUnSpecified', mode=MODE_TYPE, default=True)
    AAControls._cont = ASN1Dict([
        (u'pathLenConstraint', _AAControls_pathLenConstraint),
        (u'permittedAttrs', _AAControls_permittedAttrs),
        (u'excludedAttrs', _AAControls_excludedAttrs),
        (u'permitUnSpecified', _AAControls_permitUnSpecified),
        ])
    AAControls._ext = None
    
    #-----< AttrSpec >-----#
    AttrSpec = SEQ_OF(name=u'AttrSpec', mode=MODE_TYPE)
    _AttrSpec__item_ = OID(name='_item_', mode=MODE_TYPE)
    AttrSpec._cont = _AttrSpec__item_
    
    #-----< ProxyInfo >-----#
    ProxyInfo = SEQ_OF(name=u'ProxyInfo', mode=MODE_TYPE)
    _ProxyInfo__item_ = SEQ_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Targets')))
    ProxyInfo._cont = _ProxyInfo__item_
    
    #-----< IetfAttrSyntax >-----#
    IetfAttrSyntax = SEQ(name=u'IetfAttrSyntax', mode=MODE_TYPE)
    _IetfAttrSyntax_policyAuthority = SEQ_OF(name=u'policyAuthority', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    _IetfAttrSyntax_values = SEQ_OF(name=u'values', mode=MODE_TYPE)
    __IetfAttrSyntax_values__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ___IetfAttrSyntax_values__item__octets = OCT_STR(name=u'octets', mode=MODE_TYPE)
    ___IetfAttrSyntax_values__item__oid = OID(name=u'oid', mode=MODE_TYPE)
    ___IetfAttrSyntax_values__item__string = STR_UTF8(name=u'string', mode=MODE_TYPE)
    __IetfAttrSyntax_values__item_._cont = ASN1Dict([
        (u'octets', ___IetfAttrSyntax_values__item__octets),
        (u'oid', ___IetfAttrSyntax_values__item__oid),
        (u'string', ___IetfAttrSyntax_values__item__string),
        ])
    __IetfAttrSyntax_values__item_._ext = None
    _IetfAttrSyntax_values._cont = __IetfAttrSyntax_values__item_
    IetfAttrSyntax._cont = ASN1Dict([
        (u'policyAuthority', _IetfAttrSyntax_policyAuthority),
        (u'values', _IetfAttrSyntax_values),
        ])
    IetfAttrSyntax._ext = None
    
    #-----< SvceAuthInfo >-----#
    SvceAuthInfo = SEQ(name=u'SvceAuthInfo', mode=MODE_TYPE)
    _SvceAuthInfo_service = CHOICE(name=u'service', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _SvceAuthInfo_ident = CHOICE(name=u'ident', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _SvceAuthInfo_authInfo = OCT_STR(name=u'authInfo', mode=MODE_TYPE, opt=True)
    SvceAuthInfo._cont = ASN1Dict([
        (u'service', _SvceAuthInfo_service),
        (u'ident', _SvceAuthInfo_ident),
        (u'authInfo', _SvceAuthInfo_authInfo),
        ])
    SvceAuthInfo._ext = None
    
    #-----< RoleSyntax >-----#
    RoleSyntax = SEQ(name=u'RoleSyntax', mode=MODE_TYPE)
    _RoleSyntax_roleAuthority = SEQ_OF(name=u'roleAuthority', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    _RoleSyntax_roleName = CHOICE(name=u'roleName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    RoleSyntax._cont = ASN1Dict([
        (u'roleAuthority', _RoleSyntax_roleAuthority),
        (u'roleName', _RoleSyntax_roleName),
        ])
    RoleSyntax._ext = None
    
    #-----< Clearance >-----#
    Clearance = SEQ(name=u'Clearance', mode=MODE_TYPE)
    _Clearance_policyId = OID(name=u'policyId', mode=MODE_TYPE)
    _Clearance_classList = BIT_STR(name=u'classList', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ClassList')), default=(1, 2))
    _Clearance_securityCategories = SET_OF(name=u'securityCategories', mode=MODE_TYPE, opt=True)
    __Clearance_securityCategories__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SecurityCategory')))
    ___Clearance_securityCategories__item__type = OID(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY'), [u'id']))
    ____Clearance_securityCategories__item__type_tab = CLASS(name='_tab_SECURITY-CATEGORY', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY')))
    ____Clearance_securityCategories__item__type_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Clearance_securityCategories__item__type._const_tab = ____Clearance_securityCategories__item__type_tab
    ___Clearance_securityCategories__item__type._const_tab_at = None
    ___Clearance_securityCategories__item__type._const_tab_id = u'id'
    ___Clearance_securityCategories__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY'), [u'Type']))
    ____Clearance_securityCategories__item__value_tab = CLASS(name='_tab_SECURITY-CATEGORY', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY')))
    ____Clearance_securityCategories__item__value_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Clearance_securityCategories__item__value._const_tab = ____Clearance_securityCategories__item__value_tab
    ___Clearance_securityCategories__item__value._const_tab_at = ('..', u'type')
    ___Clearance_securityCategories__item__value._const_tab_id = u'Type'
    __Clearance_securityCategories__item_._cont = ASN1Dict([
        (u'type', ___Clearance_securityCategories__item__type),
        (u'value', ___Clearance_securityCategories__item__value),
        ])
    __Clearance_securityCategories__item_._ext = None
    _Clearance_securityCategories._cont = __Clearance_securityCategories__item_
    Clearance._cont = ASN1Dict([
        (u'policyId', _Clearance_policyId),
        (u'classList', _Clearance_classList),
        (u'securityCategories', _Clearance_securityCategories),
        ])
    Clearance._ext = None
    
    #-----< Clearance-rfc3281 >-----#
    Clearance_rfc3281 = SEQ(name=u'Clearance-rfc3281', mode=MODE_TYPE)
    _Clearance_rfc3281_policyId = OID(name=u'policyId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Clearance_rfc3281_classList = BIT_STR(name=u'classList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ClassList')), default=(1, 2))
    _Clearance_rfc3281_securityCategories = SET_OF(name=u'securityCategories', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __Clearance_rfc3281_securityCategories__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SecurityCategory-rfc3281')))
    ___Clearance_rfc3281_securityCategories__item__type = OID(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY'), [u'id']))
    ____Clearance_rfc3281_securityCategories__item__type_tab = CLASS(name='_tab_SECURITY-CATEGORY', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY')))
    ____Clearance_rfc3281_securityCategories__item__type_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Clearance_rfc3281_securityCategories__item__type._const_tab = ____Clearance_rfc3281_securityCategories__item__type_tab
    ___Clearance_rfc3281_securityCategories__item__type._const_tab_at = None
    ___Clearance_rfc3281_securityCategories__item__type._const_tab_id = u'id'
    ___Clearance_rfc3281_securityCategories__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY'), [u'Type']))
    ____Clearance_rfc3281_securityCategories__item__value_tab = CLASS(name='_tab_SECURITY-CATEGORY', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY')))
    ____Clearance_rfc3281_securityCategories__item__value_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Clearance_rfc3281_securityCategories__item__value._const_tab = ____Clearance_rfc3281_securityCategories__item__value_tab
    ___Clearance_rfc3281_securityCategories__item__value._const_tab_at = ('..', u'type')
    ___Clearance_rfc3281_securityCategories__item__value._const_tab_id = u'Type'
    __Clearance_rfc3281_securityCategories__item_._cont = ASN1Dict([
        (u'type', ___Clearance_rfc3281_securityCategories__item__type),
        (u'value', ___Clearance_rfc3281_securityCategories__item__value),
        ])
    __Clearance_rfc3281_securityCategories__item_._ext = None
    _Clearance_rfc3281_securityCategories._cont = __Clearance_rfc3281_securityCategories__item_
    Clearance_rfc3281._cont = ASN1Dict([
        (u'policyId', _Clearance_rfc3281_policyId),
        (u'classList', _Clearance_rfc3281_classList),
        (u'securityCategories', _Clearance_rfc3281_securityCategories),
        ])
    Clearance_rfc3281._ext = None
    
    #-----< ClassList >-----#
    ClassList = BIT_STR(name=u'ClassList', mode=MODE_TYPE)
    ClassList._cont = ASN1Dict([(u'unmarked', 0), (u'unclassified', 1), (u'restricted', 2), (u'confidential', 3), (u'secret', 4), (u'topSecret', 5)])
    
    #-----< SupportedSecurityCategories >-----#
    SupportedSecurityCategories = CLASS(name=u'SupportedSecurityCategories', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY')))
    SupportedSecurityCategories._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< SecurityCategory-rfc3281 >-----#
    SecurityCategory_rfc3281 = SEQ(name=u'SecurityCategory-rfc3281', mode=MODE_TYPE, param=True)
    
    #-----< ACClearAttrs >-----#
    ACClearAttrs = SEQ(name=u'ACClearAttrs', mode=MODE_TYPE)
    _ACClearAttrs_acIssuer = CHOICE(name=u'acIssuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _ACClearAttrs_acSerial = INT(name=u'acSerial', mode=MODE_TYPE)
    _ACClearAttrs_attrs = SEQ_OF(name=u'attrs', mode=MODE_TYPE)
    __ACClearAttrs_attrs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'AttributeSet')))
    ___ACClearAttrs_attrs__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____ACClearAttrs_attrs__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_3 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_4 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'RoleSyntax')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_5 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Clearance')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_6 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentInfo')))
    ____ACClearAttrs_attrs__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 1))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_1), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 2))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_2), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 3))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_3), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 4))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_4), (u'id', (2, 5, 4, 72))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_5), (u'id', (2, 5, 4, 55))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_6), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 6))])], rr=[], ev=None, er=[])
    ___ACClearAttrs_attrs__item__type._const_tab = ____ACClearAttrs_attrs__item__type_tab
    ___ACClearAttrs_attrs__item__type._const_tab_at = None
    ___ACClearAttrs_attrs__item__type._const_tab_id = u'id'
    ___ACClearAttrs_attrs__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____ACClearAttrs_attrs__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ____ACClearAttrs_attrs__item__values__item_._const_tab = ____ACClearAttrs_attrs__item__type_tab
    ____ACClearAttrs_attrs__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____ACClearAttrs_attrs__item__values__item_._const_tab_id = u'Type'
    ___ACClearAttrs_attrs__item__values._cont = ____ACClearAttrs_attrs__item__values__item_
    ___ACClearAttrs_attrs__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __ACClearAttrs_attrs__item_._cont = ASN1Dict([
        (u'type', ___ACClearAttrs_attrs__item__type),
        (u'values', ___ACClearAttrs_attrs__item__values),
        ])
    __ACClearAttrs_attrs__item_._ext = None
    _ACClearAttrs_attrs._cont = __ACClearAttrs_attrs__item_
    ACClearAttrs._cont = ASN1Dict([
        (u'acIssuer', _ACClearAttrs_acIssuer),
        (u'acSerial', _ACClearAttrs_acSerial),
        (u'attrs', _ACClearAttrs_attrs),
        ])
    ACClearAttrs._ext = None
    
    _all_ = [
        AttributeCertExtensions,
        _AttributeCertExtensions_val_ExtnType_0,
        _AttributeCertExtensions_val_ExtnType_1,
        _AttributeCertExtensions_val_ExtnType_2,
        _AttributeCertExtensions_val_ExtnType_3,
        _AttributeCertExtensions_val_ExtnType_4,
        _AttributeCertExtensions_val_ExtnType_5,
        _AttributeCertExtensions_val_ExtnType_6,
        _AttributeCertExtensions_val_ExtnType_7,
        ext_auditIdentity,
        _ext_auditIdentity_val_ExtnType,
        ext_targetInformation,
        _ext_targetInformation_val_ExtnType,
        ext_noRevAvail,
        _ext_noRevAvail_val_ExtnType,
        ext_ac_proxying,
        _ext_ac_proxying_val_ExtnType,
        ext_aaControls,
        _ext_aaControls_val_ExtnType,
        AttributesDefined,
        _AttributesDefined_val_Type_0,
        _AttributesDefined_val_Type_1,
        _AttributesDefined_val_Type_2,
        _AttributesDefined_val_Type_3,
        _AttributesDefined_val_Type_4,
        _AttributesDefined_val_Type_5,
        _AttributesDefined_val_Type_6,
        at_authenticationInfo,
        _at_authenticationInfo_val_Type,
        at_accesIdentity,
        _at_accesIdentity_val_Type,
        at_chargingIdentity,
        _at_chargingIdentity_val_Type,
        at_group,
        _at_group_val_Type,
        at_role,
        _at_role_val_Type,
        at_clearance,
        _at_clearance_val_Type,
        at_clearance_RFC3281,
        _at_clearance_RFC3281_val_Type,
        at_encAttrs,
        _at_encAttrs_val_Type,
        id_pe_ac_auditIdentity,
        id_pe_aaControls,
        id_pe_ac_proxying,
        id_ce_targetInformation,
        id_ce_noRevAvail,
        id_aca,
        id_aca_authenticationInfo,
        id_aca_accessIdentity,
        id_aca_chargingIdentity,
        id_aca_group,
        id_aca_encAttrs,
        id_at_role,
        id_at_clearance,
        id_at_clearance_rfc3281,
        _AttributeCertificate_toBeSigned,
        ___AttributeCertificate_algorithmIdentifier_algorithm_tab,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_1,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_2,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_3,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_3,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_4,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_5,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_5,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_6,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_6,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_7,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_7,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_8,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_8,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_9,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_9,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_10,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_10,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_11,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_1,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_2,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_3,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1,
        __AttributeCertificate_algorithmIdentifier_algorithm,
        __AttributeCertificate_algorithmIdentifier_parameters,
        _AttributeCertificate_algorithmIdentifier,
        __AttributeCertificate_signature_contain,
        _AttributeCertificate_signature,
        AttributeCertificate,
        _AttributeCertificateInfo_version,
        _AttributeCertificateInfo_holder,
        _AttributeCertificateInfo_issuer,
        ___AttributeCertificateInfo_signature_algorithm_tab,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_0,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_1,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_2,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_3,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_3,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_4,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_4,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_5,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_5,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_6,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_6,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_7,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_7,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_8,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_8,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_9,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_9,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_10,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_10,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_11,
        __AttributeCertificateInfo_signature_algorithm,
        __AttributeCertificateInfo_signature_parameters,
        _AttributeCertificateInfo_signature,
        _AttributeCertificateInfo_serialNumber,
        _AttributeCertificateInfo_attrCertValidityPeriod,
        ____AttributeCertificateInfo_attributes__item__type_tab,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_0,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_1,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_2,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_3,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_4,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_5,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_6,
        ___AttributeCertificateInfo_attributes__item__type,
        ____AttributeCertificateInfo_attributes__item__values__item_,
        ___AttributeCertificateInfo_attributes__item__values,
        __AttributeCertificateInfo_attributes__item_,
        _AttributeCertificateInfo_attributes,
        _AttributeCertificateInfo_issuerUniqueID,
        ____AttributeCertificateInfo_extensions__item__extnID_tab,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_0,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_1,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_2,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_3,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_4,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_5,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_6,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_7,
        ___AttributeCertificateInfo_extensions__item__extnID,
        ___AttributeCertificateInfo_extensions__item__critical,
        ____AttributeCertificateInfo_extensions__item__extnValue_contain,
        ___AttributeCertificateInfo_extensions__item__extnValue,
        __AttributeCertificateInfo_extensions__item_,
        _AttributeCertificateInfo_extensions,
        AttributeCertificateInfo,
        AttCertVersion,
        _Holder_baseCertificateID,
        _Holder_entityName,
        _Holder_objectDigestInfo,
        Holder,
        _ObjectDigestInfo_digestedObjectType,
        _ObjectDigestInfo_otherObjectTypeID,
        ___ObjectDigestInfo_digestAlgorithm_algorithm_tab,
        __ObjectDigestInfo_digestAlgorithm_algorithm,
        ___ObjectDigestInfo_digestAlgorithm_parameters_tab,
        __ObjectDigestInfo_digestAlgorithm_parameters,
        _ObjectDigestInfo_digestAlgorithm,
        _ObjectDigestInfo_objectDigest,
        ObjectDigestInfo,
        _AttCertIssuer_v1Form,
        _AttCertIssuer_v2Form,
        AttCertIssuer,
        _V2Form_issuerName,
        _V2Form_baseCertificateID,
        _V2Form_objectDigestInfo,
        V2Form,
        _IssuerSerial_issuer,
        _IssuerSerial_serial,
        _IssuerSerial_issuerUID,
        IssuerSerial,
        _AttCertValidityPeriod_notBeforeTime,
        _AttCertValidityPeriod_notAfterTime,
        AttCertValidityPeriod,
        _Targets__item_,
        Targets,
        _Target_targetName,
        _Target_targetGroup,
        _Target_targetCert,
        Target,
        _TargetCert_targetCertificate,
        _TargetCert_targetName,
        _TargetCert_certDigestInfo,
        TargetCert,
        _AAControls_pathLenConstraint,
        _AAControls_permittedAttrs,
        _AAControls_excludedAttrs,
        _AAControls_permitUnSpecified,
        AAControls,
        _AttrSpec__item_,
        AttrSpec,
        _ProxyInfo__item_,
        ProxyInfo,
        _IetfAttrSyntax_policyAuthority,
        ___IetfAttrSyntax_values__item__octets,
        ___IetfAttrSyntax_values__item__oid,
        ___IetfAttrSyntax_values__item__string,
        __IetfAttrSyntax_values__item_,
        _IetfAttrSyntax_values,
        IetfAttrSyntax,
        _SvceAuthInfo_service,
        _SvceAuthInfo_ident,
        _SvceAuthInfo_authInfo,
        SvceAuthInfo,
        _RoleSyntax_roleAuthority,
        _RoleSyntax_roleName,
        RoleSyntax,
        _Clearance_policyId,
        _Clearance_classList,
        ____Clearance_securityCategories__item__type_tab,
        ___Clearance_securityCategories__item__type,
        ____Clearance_securityCategories__item__value_tab,
        ___Clearance_securityCategories__item__value,
        __Clearance_securityCategories__item_,
        _Clearance_securityCategories,
        Clearance,
        _Clearance_rfc3281_policyId,
        _Clearance_rfc3281_classList,
        ____Clearance_rfc3281_securityCategories__item__type_tab,
        ___Clearance_rfc3281_securityCategories__item__type,
        ____Clearance_rfc3281_securityCategories__item__value_tab,
        ___Clearance_rfc3281_securityCategories__item__value,
        __Clearance_rfc3281_securityCategories__item_,
        _Clearance_rfc3281_securityCategories,
        Clearance_rfc3281,
        ClassList,
        SupportedSecurityCategories,
        _ACClearAttrs_acIssuer,
        _ACClearAttrs_acSerial,
        ____ACClearAttrs_attrs__item__type_tab,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_0,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_1,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_2,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_3,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_4,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_5,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_6,
        ___ACClearAttrs_attrs__item__type,
        ____ACClearAttrs_attrs__item__values__item_,
        ___ACClearAttrs_attrs__item__values,
        __ACClearAttrs_attrs__item_,
        _ACClearAttrs_attrs,
        ACClearAttrs,
    ]

class PKIX_CommonTypes_2009:

    _name_  = u'PKIX-CommonTypes-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 57]
    
    _obj_ = [
        u'ATTRIBUTE',
        u'MATCHING-RULE',
        u'AttributeSet',
        u'SingleAttribute',
        u'EXTENSION',
        u'Extensions',
        u'Extension',
        u'SECURITY-CATEGORY',
        u'SecurityCategory',
        ]
    _type_ = [
        u'ATTRIBUTE',
        u'MATCHING-RULE',
        u'AttributeSet',
        u'SingleAttribute',
        u'EXTENSION',
        u'Extensions',
        u'Extension',
        u'SECURITY-CATEGORY',
        u'SecurityCategory',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        u'ATTRIBUTE',
        u'MATCHING-RULE',
        u'EXTENSION',
        u'SECURITY-CATEGORY',
        ]
    _param_ = [
        u'AttributeSet',
        u'SingleAttribute',
        u'Extensions',
        u'Extension',
        u'SecurityCategory',
        ]
    
    #-----< ATTRIBUTE >-----#
    ATTRIBUTE = CLASS(name=u'ATTRIBUTE', mode=MODE_TYPE)
    _ATTRIBUTE_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _ATTRIBUTE_Type = OPEN(name=u'Type', mode=MODE_TYPE, opt=True)
    _ATTRIBUTE_equality_match = CLASS(name=u'equality-match', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'MATCHING-RULE')), opt=True)
    _ATTRIBUTE_minCount = INT(name=u'minCount', mode=MODE_VALUE, default=1)
    _ATTRIBUTE_maxCount = INT(name=u'maxCount', mode=MODE_VALUE, opt=True)
    ATTRIBUTE._cont = ASN1Dict([
        (u'id', _ATTRIBUTE_id),
        (u'Type', _ATTRIBUTE_Type),
        (u'equality-match', _ATTRIBUTE_equality_match),
        (u'minCount', _ATTRIBUTE_minCount),
        (u'maxCount', _ATTRIBUTE_maxCount),
        ])
    
    #-----< MATCHING-RULE >-----#
    MATCHING_RULE = CLASS(name=u'MATCHING-RULE', mode=MODE_TYPE)
    _MATCHING_RULE_ParentMatchingRules = CLASS(name=u'ParentMatchingRules', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'MATCHING-RULE')), opt=True)
    _MATCHING_RULE_AssertionType = OPEN(name=u'AssertionType', mode=MODE_TYPE, opt=True)
    _MATCHING_RULE_uniqueMatchIndicator = CLASS(name=u'uniqueMatchIndicator', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')), opt=True)
    _MATCHING_RULE_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    MATCHING_RULE._cont = ASN1Dict([
        (u'ParentMatchingRules', _MATCHING_RULE_ParentMatchingRules),
        (u'AssertionType', _MATCHING_RULE_AssertionType),
        (u'uniqueMatchIndicator', _MATCHING_RULE_uniqueMatchIndicator),
        (u'id', _MATCHING_RULE_id),
        ])
    
    #-----< AttributeSet >-----#
    AttributeSet = SEQ(name=u'AttributeSet', mode=MODE_TYPE, param=True)
    
    #-----< SingleAttribute >-----#
    SingleAttribute = SEQ(name=u'SingleAttribute', mode=MODE_TYPE, param=True)
    
    #-----< EXTENSION >-----#
    EXTENSION = CLASS(name=u'EXTENSION', mode=MODE_TYPE)
    _EXTENSION_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _EXTENSION_ExtnType = OPEN(name=u'ExtnType', mode=MODE_TYPE)
    _EXTENSION_Critical = BOOL(name=u'Critical', mode=MODE_SET, default=ASN1Set(rv=[True, False], rr=[], ev=None, er=[]))
    EXTENSION._cont = ASN1Dict([
        (u'id', _EXTENSION_id),
        (u'ExtnType', _EXTENSION_ExtnType),
        (u'Critical', _EXTENSION_Critical),
        ])
    
    #-----< Extensions >-----#
    Extensions = SEQ_OF(name=u'Extensions', mode=MODE_TYPE, param=True)
    
    #-----< Extension >-----#
    Extension = SEQ(name=u'Extension', mode=MODE_TYPE, param=True)
    
    #-----< SECURITY-CATEGORY >-----#
    SECURITY_CATEGORY = CLASS(name=u'SECURITY-CATEGORY', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< SecurityCategory >-----#
    SecurityCategory = SEQ(name=u'SecurityCategory', mode=MODE_TYPE, param=True)
    
    _all_ = [
        _ATTRIBUTE_id,
        _ATTRIBUTE_Type,
        _ATTRIBUTE_equality_match,
        _ATTRIBUTE_minCount,
        _ATTRIBUTE_maxCount,
        ATTRIBUTE,
        _MATCHING_RULE_ParentMatchingRules,
        _MATCHING_RULE_AssertionType,
        _MATCHING_RULE_uniqueMatchIndicator,
        _MATCHING_RULE_id,
        MATCHING_RULE,
        _EXTENSION_id,
        _EXTENSION_ExtnType,
        _EXTENSION_Critical,
        EXTENSION,
        SECURITY_CATEGORY,
    ]

class PKIX_X400Address_2009:

    _name_  = u'PKIX-X400Address-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 60]
    
    _obj_ = [
        u'ORAddress',
        u'BuiltInStandardAttributes',
        u'CountryName',
        u'AdministrationDomainName',
        u'NetworkAddress',
        u'X121Address',
        u'TerminalIdentifier',
        u'PrivateDomainName',
        u'OrganizationName',
        u'NumericUserIdentifier',
        u'PersonalName',
        u'OrganizationalUnitNames',
        u'OrganizationalUnitName',
        u'BuiltInDomainDefinedAttributes',
        u'BuiltInDomainDefinedAttribute',
        u'ExtensionAttributes',
        u'EXTENSION-ATTRIBUTE',
        u'ExtensionAttribute',
        u'SupportedExtensionAttributes',
        u'ea-commonName',
        u'ea-teletexCommonName',
        u'ea-teletexOrganizationName',
        u'ea-teletexPersonalName',
        u'ea-teletexOrganizationalUnitNames',
        u'TeletexOrganizationalUnitName',
        u'ea-pDSName',
        u'ea-physicalDeliveryCountryName',
        u'ea-postalCode',
        u'ea-physicalDeliveryOfficeName',
        u'ea-physicalDeliveryOfficeNumber',
        u'ea-extensionORAddressComponents',
        u'ea-physicalDeliveryPersonalName',
        u'ea-physicalDeliveryOrganizationName',
        u'ea-extensionPhysicalDeliveryAddressComponents',
        u'ea-unformattedPostalAddress',
        u'ea-streetAddress',
        u'ea-postOfficeBoxAddress',
        u'ea-posteRestanteAddress',
        u'ea-uniquePostalName',
        u'ea-localPostalAttributes',
        u'PDSParameter',
        u'ea-extendedNetworkAddress',
        u'PresentationAddress',
        u'ea-terminalType',
        u'ea-teletexDomainDefinedAttributes',
        u'TeletexDomainDefinedAttribute',
        u'ub-match',
        u'ub-common-name-length',
        u'ub-country-name-alpha-length',
        u'ub-country-name-numeric-length',
        u'ub-domain-defined-attributes',
        u'ub-domain-defined-attribute-type-length',
        u'ub-domain-defined-attribute-value-length',
        u'ub-domain-name-length',
        u'ub-extension-attributes',
        u'ub-e163-4-number-length',
        u'ub-e163-4-sub-address-length',
        u'ub-generation-qualifier-length',
        u'ub-given-name-length',
        u'ub-initials-length',
        u'ub-integer-options',
        u'ub-numeric-user-id-length',
        u'ub-organization-name-length',
        u'ub-organizational-unit-name-length',
        u'ub-organizational-units',
        u'ub-pds-name-length',
        u'ub-pds-parameter-length',
        u'ub-pds-physical-address-lines',
        u'ub-postal-code-length',
        u'ub-surname-length',
        u'ub-terminal-id-length',
        u'ub-unformatted-address-length',
        u'ub-x121-address-length',
        ]
    _type_ = [
        u'ORAddress',
        u'BuiltInStandardAttributes',
        u'CountryName',
        u'AdministrationDomainName',
        u'NetworkAddress',
        u'X121Address',
        u'TerminalIdentifier',
        u'PrivateDomainName',
        u'OrganizationName',
        u'NumericUserIdentifier',
        u'PersonalName',
        u'OrganizationalUnitNames',
        u'OrganizationalUnitName',
        u'BuiltInDomainDefinedAttributes',
        u'BuiltInDomainDefinedAttribute',
        u'ExtensionAttributes',
        u'EXTENSION-ATTRIBUTE',
        u'ExtensionAttribute',
        u'TeletexOrganizationalUnitName',
        u'PDSParameter',
        u'PresentationAddress',
        u'TeletexDomainDefinedAttribute',
        ]
    _set_ = [
        u'SupportedExtensionAttributes',
        ]
    _val_ = [
        u'ea-commonName',
        u'ea-teletexCommonName',
        u'ea-teletexOrganizationName',
        u'ea-teletexPersonalName',
        u'ea-teletexOrganizationalUnitNames',
        u'ea-pDSName',
        u'ea-physicalDeliveryCountryName',
        u'ea-postalCode',
        u'ea-physicalDeliveryOfficeName',
        u'ea-physicalDeliveryOfficeNumber',
        u'ea-extensionORAddressComponents',
        u'ea-physicalDeliveryPersonalName',
        u'ea-physicalDeliveryOrganizationName',
        u'ea-extensionPhysicalDeliveryAddressComponents',
        u'ea-unformattedPostalAddress',
        u'ea-streetAddress',
        u'ea-postOfficeBoxAddress',
        u'ea-posteRestanteAddress',
        u'ea-uniquePostalName',
        u'ea-localPostalAttributes',
        u'ea-extendedNetworkAddress',
        u'ea-terminalType',
        u'ea-teletexDomainDefinedAttributes',
        u'ub-match',
        u'ub-common-name-length',
        u'ub-country-name-alpha-length',
        u'ub-country-name-numeric-length',
        u'ub-domain-defined-attributes',
        u'ub-domain-defined-attribute-type-length',
        u'ub-domain-defined-attribute-value-length',
        u'ub-domain-name-length',
        u'ub-extension-attributes',
        u'ub-e163-4-number-length',
        u'ub-e163-4-sub-address-length',
        u'ub-generation-qualifier-length',
        u'ub-given-name-length',
        u'ub-initials-length',
        u'ub-integer-options',
        u'ub-numeric-user-id-length',
        u'ub-organization-name-length',
        u'ub-organizational-unit-name-length',
        u'ub-organizational-units',
        u'ub-pds-name-length',
        u'ub-pds-parameter-length',
        u'ub-pds-physical-address-lines',
        u'ub-postal-code-length',
        u'ub-surname-length',
        u'ub-terminal-id-length',
        u'ub-unformatted-address-length',
        u'ub-x121-address-length',
        ]
    _class_ = [
        u'EXTENSION-ATTRIBUTE',
        u'SupportedExtensionAttributes',
        u'ea-commonName',
        u'ea-teletexCommonName',
        u'ea-teletexOrganizationName',
        u'ea-teletexPersonalName',
        u'ea-teletexOrganizationalUnitNames',
        u'ea-pDSName',
        u'ea-physicalDeliveryCountryName',
        u'ea-postalCode',
        u'ea-physicalDeliveryOfficeName',
        u'ea-physicalDeliveryOfficeNumber',
        u'ea-extensionORAddressComponents',
        u'ea-physicalDeliveryPersonalName',
        u'ea-physicalDeliveryOrganizationName',
        u'ea-extensionPhysicalDeliveryAddressComponents',
        u'ea-unformattedPostalAddress',
        u'ea-streetAddress',
        u'ea-postOfficeBoxAddress',
        u'ea-posteRestanteAddress',
        u'ea-uniquePostalName',
        u'ea-localPostalAttributes',
        u'ea-extendedNetworkAddress',
        u'ea-terminalType',
        u'ea-teletexDomainDefinedAttributes',
        ]
    _param_ = [
        ]
    
    #-----< ORAddress >-----#
    ORAddress = SEQ(name=u'ORAddress', mode=MODE_TYPE)
    _ORAddress_built_in_standard_attributes = SEQ(name=u'built-in-standard-attributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'BuiltInStandardAttributes')))
    _ORAddress_built_in_domain_defined_attributes = SEQ_OF(name=u'built-in-domain-defined-attributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'BuiltInDomainDefinedAttributes')), opt=True)
    _ORAddress_extension_attributes = SET_OF(name=u'extension-attributes', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'ExtensionAttributes')), opt=True)
    ORAddress._cont = ASN1Dict([
        (u'built-in-standard-attributes', _ORAddress_built_in_standard_attributes),
        (u'built-in-domain-defined-attributes', _ORAddress_built_in_domain_defined_attributes),
        (u'extension-attributes', _ORAddress_extension_attributes),
        ])
    ORAddress._ext = None
    
    #-----< BuiltInStandardAttributes >-----#
    BuiltInStandardAttributes = SEQ(name=u'BuiltInStandardAttributes', mode=MODE_TYPE)
    _BuiltInStandardAttributes_country_name = CHOICE(name=u'country-name', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'CountryName')), opt=True)
    _BuiltInStandardAttributes_administration_domain_name = CHOICE(name=u'administration-domain-name', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'AdministrationDomainName')), opt=True)
    _BuiltInStandardAttributes_network_address = STR_NUM(name=u'network-address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'NetworkAddress')), opt=True)
    _BuiltInStandardAttributes_terminal_identifier = STR_PRINT(name=u'terminal-identifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'TerminalIdentifier')), opt=True)
    _BuiltInStandardAttributes_private_domain_name = CHOICE(name=u'private-domain-name', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'PrivateDomainName')), opt=True)
    _BuiltInStandardAttributes_organization_name = STR_PRINT(name=u'organization-name', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'OrganizationName')), opt=True)
    _BuiltInStandardAttributes_numeric_user_identifier = STR_NUM(name=u'numeric-user-identifier', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'NumericUserIdentifier')), opt=True)
    _BuiltInStandardAttributes_personal_name = SET(name=u'personal-name', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'PersonalName')), opt=True)
    _BuiltInStandardAttributes_organizational_unit_names = SEQ_OF(name=u'organizational-unit-names', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'OrganizationalUnitNames')), opt=True)
    BuiltInStandardAttributes._cont = ASN1Dict([
        (u'country-name', _BuiltInStandardAttributes_country_name),
        (u'administration-domain-name', _BuiltInStandardAttributes_administration_domain_name),
        (u'network-address', _BuiltInStandardAttributes_network_address),
        (u'terminal-identifier', _BuiltInStandardAttributes_terminal_identifier),
        (u'private-domain-name', _BuiltInStandardAttributes_private_domain_name),
        (u'organization-name', _BuiltInStandardAttributes_organization_name),
        (u'numeric-user-identifier', _BuiltInStandardAttributes_numeric_user_identifier),
        (u'personal-name', _BuiltInStandardAttributes_personal_name),
        (u'organizational-unit-names', _BuiltInStandardAttributes_organizational_unit_names),
        ])
    BuiltInStandardAttributes._ext = None
    
    #-----< CountryName >-----#
    CountryName = CHOICE(name=u'CountryName', mode=MODE_TYPE, tag=(1, TAG_APPLICATION, TAG_EXPLICIT))
    _CountryName_x121_dcc_code = STR_NUM(name=u'x121-dcc-code', mode=MODE_TYPE)
    _CountryName_x121_dcc_code._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    _CountryName_iso_3166_alpha2_code = STR_PRINT(name=u'iso-3166-alpha2-code', mode=MODE_TYPE)
    _CountryName_iso_3166_alpha2_code._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    CountryName._cont = ASN1Dict([
        (u'x121-dcc-code', _CountryName_x121_dcc_code),
        (u'iso-3166-alpha2-code', _CountryName_iso_3166_alpha2_code),
        ])
    CountryName._ext = None
    
    #-----< AdministrationDomainName >-----#
    AdministrationDomainName = CHOICE(name=u'AdministrationDomainName', mode=MODE_TYPE, tag=(2, TAG_APPLICATION, TAG_EXPLICIT))
    _AdministrationDomainName_numeric = STR_NUM(name=u'numeric', mode=MODE_TYPE)
    _AdministrationDomainName_numeric._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16)], ev=None, er=[])
    _AdministrationDomainName_printable = STR_PRINT(name=u'printable', mode=MODE_TYPE)
    _AdministrationDomainName_printable._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=16)], ev=None, er=[])
    AdministrationDomainName._cont = ASN1Dict([
        (u'numeric', _AdministrationDomainName_numeric),
        (u'printable', _AdministrationDomainName_printable),
        ])
    AdministrationDomainName._ext = None
    
    #-----< NetworkAddress >-----#
    NetworkAddress = STR_NUM(name=u'NetworkAddress', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'X121Address')))
    
    #-----< X121Address >-----#
    X121Address = STR_NUM(name=u'X121Address', mode=MODE_TYPE)
    X121Address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< TerminalIdentifier >-----#
    TerminalIdentifier = STR_PRINT(name=u'TerminalIdentifier', mode=MODE_TYPE)
    TerminalIdentifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=24)], ev=None, er=[])
    
    #-----< PrivateDomainName >-----#
    PrivateDomainName = CHOICE(name=u'PrivateDomainName', mode=MODE_TYPE)
    _PrivateDomainName_numeric = STR_NUM(name=u'numeric', mode=MODE_TYPE)
    _PrivateDomainName_numeric._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _PrivateDomainName_printable = STR_PRINT(name=u'printable', mode=MODE_TYPE)
    _PrivateDomainName_printable._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    PrivateDomainName._cont = ASN1Dict([
        (u'numeric', _PrivateDomainName_numeric),
        (u'printable', _PrivateDomainName_printable),
        ])
    PrivateDomainName._ext = None
    
    #-----< OrganizationName >-----#
    OrganizationName = STR_PRINT(name=u'OrganizationName', mode=MODE_TYPE)
    OrganizationName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    
    #-----< NumericUserIdentifier >-----#
    NumericUserIdentifier = STR_NUM(name=u'NumericUserIdentifier', mode=MODE_TYPE)
    NumericUserIdentifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< PersonalName >-----#
    PersonalName = SET(name=u'PersonalName', mode=MODE_TYPE)
    _PersonalName_surname = STR_PRINT(name=u'surname', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PersonalName_surname._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    _PersonalName_given_name = STR_PRINT(name=u'given-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PersonalName_given_name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _PersonalName_initials = STR_PRINT(name=u'initials', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PersonalName_initials._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    _PersonalName_generation_qualifier = STR_PRINT(name=u'generation-qualifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PersonalName_generation_qualifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    PersonalName._cont = ASN1Dict([
        (u'surname', _PersonalName_surname),
        (u'given-name', _PersonalName_given_name),
        (u'initials', _PersonalName_initials),
        (u'generation-qualifier', _PersonalName_generation_qualifier),
        ])
    PersonalName._ext = None
    
    #-----< OrganizationalUnitNames >-----#
    OrganizationalUnitNames = SEQ_OF(name=u'OrganizationalUnitNames', mode=MODE_TYPE)
    _OrganizationalUnitNames__item_ = STR_PRINT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'OrganizationalUnitName')))
    OrganizationalUnitNames._cont = _OrganizationalUnitNames__item_
    OrganizationalUnitNames._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< OrganizationalUnitName >-----#
    OrganizationalUnitName = STR_PRINT(name=u'OrganizationalUnitName', mode=MODE_TYPE)
    OrganizationalUnitName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< BuiltInDomainDefinedAttributes >-----#
    BuiltInDomainDefinedAttributes = SEQ_OF(name=u'BuiltInDomainDefinedAttributes', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'BuiltInDomainDefinedAttribute')))
    BuiltInDomainDefinedAttributes._cont = _BuiltInDomainDefinedAttributes__item_
    BuiltInDomainDefinedAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< BuiltInDomainDefinedAttribute >-----#
    BuiltInDomainDefinedAttribute = SEQ(name=u'BuiltInDomainDefinedAttribute', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttribute_type = STR_PRINT(name=u'type', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttribute_type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _BuiltInDomainDefinedAttribute_value = STR_PRINT(name=u'value', mode=MODE_TYPE)
    _BuiltInDomainDefinedAttribute_value._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    BuiltInDomainDefinedAttribute._cont = ASN1Dict([
        (u'type', _BuiltInDomainDefinedAttribute_type),
        (u'value', _BuiltInDomainDefinedAttribute_value),
        ])
    BuiltInDomainDefinedAttribute._ext = None
    
    #-----< ExtensionAttributes >-----#
    ExtensionAttributes = SET_OF(name=u'ExtensionAttributes', mode=MODE_TYPE)
    _ExtensionAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'ExtensionAttribute')))
    ExtensionAttributes._cont = _ExtensionAttributes__item_
    ExtensionAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< EXTENSION-ATTRIBUTE >-----#
    EXTENSION_ATTRIBUTE = CLASS(name=u'EXTENSION-ATTRIBUTE', mode=MODE_TYPE)
    _EXTENSION_ATTRIBUTE_id = INT(name=u'id', mode=MODE_VALUE, uniq=True)
    _EXTENSION_ATTRIBUTE_id._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=256)], ev=None, er=[])
    _EXTENSION_ATTRIBUTE_Type = OPEN(name=u'Type', mode=MODE_TYPE)
    EXTENSION_ATTRIBUTE._cont = ASN1Dict([
        (u'id', _EXTENSION_ATTRIBUTE_id),
        (u'Type', _EXTENSION_ATTRIBUTE_Type),
        ])
    
    #-----< ExtensionAttribute >-----#
    ExtensionAttribute = SEQ(name=u'ExtensionAttribute', mode=MODE_TYPE)
    _ExtensionAttribute_extension_attribute_type = INT(name=u'extension-attribute-type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE'), [u'id']))
    __ExtensionAttribute_extension_attribute_type_tab = CLASS(name='_tab_EXTENSION-ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_0 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_0._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_1 = STR_TELE(name=u'Type', mode=MODE_TYPE)
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_1._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_2 = STR_TELE(name=u'Type', mode=MODE_TYPE)
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_2._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_3 = SET(name=u'Type', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_surname = STR_TELE(name=u'surname', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_surname._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_given_name = STR_TELE(name=u'given-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_given_name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_initials = STR_TELE(name=u'initials', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_initials._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_generation_qualifier = STR_TELE(name=u'generation-qualifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_generation_qualifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_3._cont = ASN1Dict([
        (u'surname', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_surname),
        (u'given-name', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_given_name),
        (u'initials', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_initials),
        (u'generation-qualifier', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_generation_qualifier),
        ])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_3._ext = None
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_4 = SEQ_OF(name=u'Type', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_4__item_ = STR_TELE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'TeletexOrganizationalUnitName')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_4._cont = ____ExtensionAttribute_extension_attribute_type_tab_val_Type_4__item_
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_4._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_5 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_5._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_6 = CHOICE(name=u'Type', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_6_x121_dcc_code = STR_NUM(name=u'x121-dcc-code', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_6_x121_dcc_code._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_6_iso_3166_alpha2_code = STR_PRINT(name=u'iso-3166-alpha2-code', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_6_iso_3166_alpha2_code._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_6._cont = ASN1Dict([
        (u'x121-dcc-code', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_6_x121_dcc_code),
        (u'iso-3166-alpha2-code', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_6_iso_3166_alpha2_code),
        ])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_6._ext = None
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_7 = CHOICE(name=u'Type', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_7_numeric_code = STR_NUM(name=u'numeric-code', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_7_numeric_code._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_7_printable_code = STR_PRINT(name=u'printable-code', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_7_printable_code._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_7._cont = ASN1Dict([
        (u'numeric-code', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_7_numeric_code),
        (u'printable-code', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_7_printable_code),
        ])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_7._ext = None
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_8 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_9 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_10 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_11 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_12 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_13 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_14 = SET(name=u'Type', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_printable_address = SEQ_OF(name=u'printable-address', mode=MODE_TYPE, opt=True)
    _____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_printable_address__item_ = STR_PRINT(name='_item_', mode=MODE_TYPE)
    _____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_printable_address__item_._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_printable_address._cont = _____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_printable_address__item_
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_printable_address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=6)], ev=None, er=[])
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_teletex_string = STR_TELE(name=u'teletex-string', mode=MODE_TYPE, opt=True)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_teletex_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=180)], ev=None, er=[])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_14._cont = ASN1Dict([
        (u'printable-address', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_printable_address),
        (u'teletex-string', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_teletex_string),
        ])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_14._ext = None
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_15 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_16 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_17 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_18 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_19 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_20 = CHOICE(name=u'Type', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address = SEQ(name=u'e163-4-address', mode=MODE_TYPE)
    _____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address_number = STR_NUM(name=u'number', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address_number._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    _____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address_sub_address = STR_NUM(name=u'sub-address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address_sub_address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address._cont = ASN1Dict([
        (u'number', _____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address_number),
        (u'sub-address', _____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address_sub_address),
        ])
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address._ext = None
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_psap_address = SEQ(name=u'psap-address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'PresentationAddress')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_20._cont = ASN1Dict([
        (u'e163-4-address', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address),
        (u'psap-address', ____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_psap_address),
        ])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_20._ext = None
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_21 = INT(name=u'Type', mode=MODE_TYPE)
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_21._cont = ASN1Dict([(u'telex', 3), (u'teletex', 4), (u'g3-facsimile', 5), (u'g4-facsimile', 6), (u'ia5-terminal', 7), (u'videotex', 8)])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_21._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=256)], ev=None, er=[])
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_22 = SEQ_OF(name=u'Type', mode=MODE_TYPE)
    ____ExtensionAttribute_extension_attribute_type_tab_val_Type_22__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'TeletexDomainDefinedAttribute')))
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_22._cont = ____ExtensionAttribute_extension_attribute_type_tab_val_Type_22__item_
    ___ExtensionAttribute_extension_attribute_type_tab_val_Type_22._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    __ExtensionAttribute_extension_attribute_type_tab._val = ASN1Set(rv=[dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_0), (u'id', 1)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_1), (u'id', 2)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_2), (u'id', 3)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_3), (u'id', 4)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_4), (u'id', 5)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_5), (u'id', 7)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_6), (u'id', 8)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_7), (u'id', 9)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_8), (u'id', 10)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_9), (u'id', 11)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_10), (u'id', 12)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_11), (u'id', 13)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_12), (u'id', 14)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_13), (u'id', 15)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_14), (u'id', 16)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_15), (u'id', 17)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_16), (u'id', 18)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_17), (u'id', 19)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_18), (u'id', 20)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_19), (u'id', 21)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_20), (u'id', 22)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_21), (u'id', 23)]), dict([(u'Type', ___ExtensionAttribute_extension_attribute_type_tab_val_Type_22), (u'id', 6)])], rr=[], ev=None, er=[])
    _ExtensionAttribute_extension_attribute_type._const_tab = __ExtensionAttribute_extension_attribute_type_tab
    _ExtensionAttribute_extension_attribute_type._const_tab_at = None
    _ExtensionAttribute_extension_attribute_type._const_tab_id = u'id'
    _ExtensionAttribute_extension_attribute_value = OPEN(name=u'extension-attribute-value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE'), [u'Type']))
    _ExtensionAttribute_extension_attribute_value._const_tab = __ExtensionAttribute_extension_attribute_type_tab
    _ExtensionAttribute_extension_attribute_value._const_tab_at = ('..', u'extension-attribute-type')
    _ExtensionAttribute_extension_attribute_value._const_tab_id = u'Type'
    ExtensionAttribute._cont = ASN1Dict([
        (u'extension-attribute-type', _ExtensionAttribute_extension_attribute_type),
        (u'extension-attribute-value', _ExtensionAttribute_extension_attribute_value),
        ])
    ExtensionAttribute._ext = None
    
    #-----< SupportedExtensionAttributes >-----#
    SupportedExtensionAttributes = CLASS(name=u'SupportedExtensionAttributes', mode=MODE_SET, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _SupportedExtensionAttributes_val_Type_0 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _SupportedExtensionAttributes_val_Type_0._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedExtensionAttributes_val_Type_1 = STR_TELE(name=u'Type', mode=MODE_TYPE)
    _SupportedExtensionAttributes_val_Type_1._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedExtensionAttributes_val_Type_2 = STR_TELE(name=u'Type', mode=MODE_TYPE)
    _SupportedExtensionAttributes_val_Type_2._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedExtensionAttributes_val_Type_3 = SET(name=u'Type', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_3_surname = STR_TELE(name=u'surname', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __SupportedExtensionAttributes_val_Type_3_surname._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    __SupportedExtensionAttributes_val_Type_3_given_name = STR_TELE(name=u'given-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __SupportedExtensionAttributes_val_Type_3_given_name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    __SupportedExtensionAttributes_val_Type_3_initials = STR_TELE(name=u'initials', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __SupportedExtensionAttributes_val_Type_3_initials._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    __SupportedExtensionAttributes_val_Type_3_generation_qualifier = STR_TELE(name=u'generation-qualifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __SupportedExtensionAttributes_val_Type_3_generation_qualifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    _SupportedExtensionAttributes_val_Type_3._cont = ASN1Dict([
        (u'surname', __SupportedExtensionAttributes_val_Type_3_surname),
        (u'given-name', __SupportedExtensionAttributes_val_Type_3_given_name),
        (u'initials', __SupportedExtensionAttributes_val_Type_3_initials),
        (u'generation-qualifier', __SupportedExtensionAttributes_val_Type_3_generation_qualifier),
        ])
    _SupportedExtensionAttributes_val_Type_3._ext = None
    _SupportedExtensionAttributes_val_Type_4 = SEQ_OF(name=u'Type', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_4__item_ = STR_TELE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'TeletexOrganizationalUnitName')))
    _SupportedExtensionAttributes_val_Type_4._cont = __SupportedExtensionAttributes_val_Type_4__item_
    _SupportedExtensionAttributes_val_Type_4._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    _SupportedExtensionAttributes_val_Type_5 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _SupportedExtensionAttributes_val_Type_5._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _SupportedExtensionAttributes_val_Type_6 = CHOICE(name=u'Type', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_6_x121_dcc_code = STR_NUM(name=u'x121-dcc-code', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_6_x121_dcc_code._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    __SupportedExtensionAttributes_val_Type_6_iso_3166_alpha2_code = STR_PRINT(name=u'iso-3166-alpha2-code', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_6_iso_3166_alpha2_code._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _SupportedExtensionAttributes_val_Type_6._cont = ASN1Dict([
        (u'x121-dcc-code', __SupportedExtensionAttributes_val_Type_6_x121_dcc_code),
        (u'iso-3166-alpha2-code', __SupportedExtensionAttributes_val_Type_6_iso_3166_alpha2_code),
        ])
    _SupportedExtensionAttributes_val_Type_6._ext = None
    _SupportedExtensionAttributes_val_Type_7 = CHOICE(name=u'Type', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_7_numeric_code = STR_NUM(name=u'numeric-code', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_7_numeric_code._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    __SupportedExtensionAttributes_val_Type_7_printable_code = STR_PRINT(name=u'printable-code', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_7_printable_code._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _SupportedExtensionAttributes_val_Type_7._cont = ASN1Dict([
        (u'numeric-code', __SupportedExtensionAttributes_val_Type_7_numeric_code),
        (u'printable-code', __SupportedExtensionAttributes_val_Type_7_printable_code),
        ])
    _SupportedExtensionAttributes_val_Type_7._ext = None
    _SupportedExtensionAttributes_val_Type_8 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_9 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_10 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_11 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_12 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_13 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_14 = SET(name=u'Type', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_14_printable_address = SEQ_OF(name=u'printable-address', mode=MODE_TYPE, opt=True)
    ___SupportedExtensionAttributes_val_Type_14_printable_address__item_ = STR_PRINT(name='_item_', mode=MODE_TYPE)
    ___SupportedExtensionAttributes_val_Type_14_printable_address__item_._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    __SupportedExtensionAttributes_val_Type_14_printable_address._cont = ___SupportedExtensionAttributes_val_Type_14_printable_address__item_
    __SupportedExtensionAttributes_val_Type_14_printable_address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=6)], ev=None, er=[])
    __SupportedExtensionAttributes_val_Type_14_teletex_string = STR_TELE(name=u'teletex-string', mode=MODE_TYPE, opt=True)
    __SupportedExtensionAttributes_val_Type_14_teletex_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=180)], ev=None, er=[])
    _SupportedExtensionAttributes_val_Type_14._cont = ASN1Dict([
        (u'printable-address', __SupportedExtensionAttributes_val_Type_14_printable_address),
        (u'teletex-string', __SupportedExtensionAttributes_val_Type_14_teletex_string),
        ])
    _SupportedExtensionAttributes_val_Type_14._ext = None
    _SupportedExtensionAttributes_val_Type_15 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_16 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_17 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_18 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_19 = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    _SupportedExtensionAttributes_val_Type_20 = CHOICE(name=u'Type', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_20_e163_4_address = SEQ(name=u'e163-4-address', mode=MODE_TYPE)
    ___SupportedExtensionAttributes_val_Type_20_e163_4_address_number = STR_NUM(name=u'number', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___SupportedExtensionAttributes_val_Type_20_e163_4_address_number._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    ___SupportedExtensionAttributes_val_Type_20_e163_4_address_sub_address = STR_NUM(name=u'sub-address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___SupportedExtensionAttributes_val_Type_20_e163_4_address_sub_address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    __SupportedExtensionAttributes_val_Type_20_e163_4_address._cont = ASN1Dict([
        (u'number', ___SupportedExtensionAttributes_val_Type_20_e163_4_address_number),
        (u'sub-address', ___SupportedExtensionAttributes_val_Type_20_e163_4_address_sub_address),
        ])
    __SupportedExtensionAttributes_val_Type_20_e163_4_address._ext = None
    __SupportedExtensionAttributes_val_Type_20_psap_address = SEQ(name=u'psap-address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'PresentationAddress')))
    _SupportedExtensionAttributes_val_Type_20._cont = ASN1Dict([
        (u'e163-4-address', __SupportedExtensionAttributes_val_Type_20_e163_4_address),
        (u'psap-address', __SupportedExtensionAttributes_val_Type_20_psap_address),
        ])
    _SupportedExtensionAttributes_val_Type_20._ext = None
    _SupportedExtensionAttributes_val_Type_21 = INT(name=u'Type', mode=MODE_TYPE)
    _SupportedExtensionAttributes_val_Type_21._cont = ASN1Dict([(u'telex', 3), (u'teletex', 4), (u'g3-facsimile', 5), (u'g4-facsimile', 6), (u'ia5-terminal', 7), (u'videotex', 8)])
    _SupportedExtensionAttributes_val_Type_21._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=256)], ev=None, er=[])
    _SupportedExtensionAttributes_val_Type_22 = SEQ_OF(name=u'Type', mode=MODE_TYPE)
    __SupportedExtensionAttributes_val_Type_22__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'TeletexDomainDefinedAttribute')))
    _SupportedExtensionAttributes_val_Type_22._cont = __SupportedExtensionAttributes_val_Type_22__item_
    _SupportedExtensionAttributes_val_Type_22._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    SupportedExtensionAttributes._val = ASN1Set(rv=[dict([(u'Type', _SupportedExtensionAttributes_val_Type_0), (u'id', 1)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_1), (u'id', 2)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_2), (u'id', 3)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_3), (u'id', 4)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_4), (u'id', 5)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_5), (u'id', 7)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_6), (u'id', 8)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_7), (u'id', 9)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_8), (u'id', 10)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_9), (u'id', 11)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_10), (u'id', 12)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_11), (u'id', 13)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_12), (u'id', 14)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_13), (u'id', 15)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_14), (u'id', 16)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_15), (u'id', 17)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_16), (u'id', 18)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_17), (u'id', 19)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_18), (u'id', 20)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_19), (u'id', 21)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_20), (u'id', 22)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_21), (u'id', 23)]), dict([(u'Type', _SupportedExtensionAttributes_val_Type_22), (u'id', 6)])], rr=[], ev=[], er=[])
    
    #-----< ea-commonName >-----#
    ea_commonName = CLASS(name=u'ea-commonName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_commonName_val_Type = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _ea_commonName_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ea_commonName._val = dict([(u'Type', _ea_commonName_val_Type), (u'id', 1)])
    
    #-----< ea-teletexCommonName >-----#
    ea_teletexCommonName = CLASS(name=u'ea-teletexCommonName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_teletexCommonName_val_Type = STR_TELE(name=u'Type', mode=MODE_TYPE)
    _ea_teletexCommonName_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ea_teletexCommonName._val = dict([(u'Type', _ea_teletexCommonName_val_Type), (u'id', 2)])
    
    #-----< ea-teletexOrganizationName >-----#
    ea_teletexOrganizationName = CLASS(name=u'ea-teletexOrganizationName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_teletexOrganizationName_val_Type = STR_TELE(name=u'Type', mode=MODE_TYPE)
    _ea_teletexOrganizationName_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ea_teletexOrganizationName._val = dict([(u'Type', _ea_teletexOrganizationName_val_Type), (u'id', 3)])
    
    #-----< ea-teletexPersonalName >-----#
    ea_teletexPersonalName = CLASS(name=u'ea-teletexPersonalName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_teletexPersonalName_val_Type = SET(name=u'Type', mode=MODE_TYPE)
    __ea_teletexPersonalName_val_Type_surname = STR_TELE(name=u'surname', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ea_teletexPersonalName_val_Type_surname._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    __ea_teletexPersonalName_val_Type_given_name = STR_TELE(name=u'given-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ea_teletexPersonalName_val_Type_given_name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    __ea_teletexPersonalName_val_Type_initials = STR_TELE(name=u'initials', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ea_teletexPersonalName_val_Type_initials._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    __ea_teletexPersonalName_val_Type_generation_qualifier = STR_TELE(name=u'generation-qualifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ea_teletexPersonalName_val_Type_generation_qualifier._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    _ea_teletexPersonalName_val_Type._cont = ASN1Dict([
        (u'surname', __ea_teletexPersonalName_val_Type_surname),
        (u'given-name', __ea_teletexPersonalName_val_Type_given_name),
        (u'initials', __ea_teletexPersonalName_val_Type_initials),
        (u'generation-qualifier', __ea_teletexPersonalName_val_Type_generation_qualifier),
        ])
    _ea_teletexPersonalName_val_Type._ext = None
    ea_teletexPersonalName._val = dict([(u'Type', _ea_teletexPersonalName_val_Type), (u'id', 4)])
    
    #-----< ea-teletexOrganizationalUnitNames >-----#
    ea_teletexOrganizationalUnitNames = CLASS(name=u'ea-teletexOrganizationalUnitNames', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_teletexOrganizationalUnitNames_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE)
    __ea_teletexOrganizationalUnitNames_val_Type__item_ = STR_TELE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'TeletexOrganizationalUnitName')))
    _ea_teletexOrganizationalUnitNames_val_Type._cont = __ea_teletexOrganizationalUnitNames_val_Type__item_
    _ea_teletexOrganizationalUnitNames_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    ea_teletexOrganizationalUnitNames._val = dict([(u'Type', _ea_teletexOrganizationalUnitNames_val_Type), (u'id', 5)])
    
    #-----< TeletexOrganizationalUnitName >-----#
    TeletexOrganizationalUnitName = STR_TELE(name=u'TeletexOrganizationalUnitName', mode=MODE_TYPE)
    TeletexOrganizationalUnitName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< ea-pDSName >-----#
    ea_pDSName = CLASS(name=u'ea-pDSName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_pDSName_val_Type = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _ea_pDSName_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    ea_pDSName._val = dict([(u'Type', _ea_pDSName_val_Type), (u'id', 7)])
    
    #-----< ea-physicalDeliveryCountryName >-----#
    ea_physicalDeliveryCountryName = CLASS(name=u'ea-physicalDeliveryCountryName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_physicalDeliveryCountryName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE)
    __ea_physicalDeliveryCountryName_val_Type_x121_dcc_code = STR_NUM(name=u'x121-dcc-code', mode=MODE_TYPE)
    __ea_physicalDeliveryCountryName_val_Type_x121_dcc_code._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    __ea_physicalDeliveryCountryName_val_Type_iso_3166_alpha2_code = STR_PRINT(name=u'iso-3166-alpha2-code', mode=MODE_TYPE)
    __ea_physicalDeliveryCountryName_val_Type_iso_3166_alpha2_code._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _ea_physicalDeliveryCountryName_val_Type._cont = ASN1Dict([
        (u'x121-dcc-code', __ea_physicalDeliveryCountryName_val_Type_x121_dcc_code),
        (u'iso-3166-alpha2-code', __ea_physicalDeliveryCountryName_val_Type_iso_3166_alpha2_code),
        ])
    _ea_physicalDeliveryCountryName_val_Type._ext = None
    ea_physicalDeliveryCountryName._val = dict([(u'Type', _ea_physicalDeliveryCountryName_val_Type), (u'id', 8)])
    
    #-----< ea-postalCode >-----#
    ea_postalCode = CLASS(name=u'ea-postalCode', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_postalCode_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE)
    __ea_postalCode_val_Type_numeric_code = STR_NUM(name=u'numeric-code', mode=MODE_TYPE)
    __ea_postalCode_val_Type_numeric_code._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    __ea_postalCode_val_Type_printable_code = STR_PRINT(name=u'printable-code', mode=MODE_TYPE)
    __ea_postalCode_val_Type_printable_code._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    _ea_postalCode_val_Type._cont = ASN1Dict([
        (u'numeric-code', __ea_postalCode_val_Type_numeric_code),
        (u'printable-code', __ea_postalCode_val_Type_printable_code),
        ])
    _ea_postalCode_val_Type._ext = None
    ea_postalCode._val = dict([(u'Type', _ea_postalCode_val_Type), (u'id', 9)])
    
    #-----< ea-physicalDeliveryOfficeName >-----#
    ea_physicalDeliveryOfficeName = CLASS(name=u'ea-physicalDeliveryOfficeName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_physicalDeliveryOfficeName_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_physicalDeliveryOfficeName._val = dict([(u'Type', _ea_physicalDeliveryOfficeName_val_Type), (u'id', 10)])
    
    #-----< ea-physicalDeliveryOfficeNumber >-----#
    ea_physicalDeliveryOfficeNumber = CLASS(name=u'ea-physicalDeliveryOfficeNumber', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_physicalDeliveryOfficeNumber_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_physicalDeliveryOfficeNumber._val = dict([(u'Type', _ea_physicalDeliveryOfficeNumber_val_Type), (u'id', 11)])
    
    #-----< ea-extensionORAddressComponents >-----#
    ea_extensionORAddressComponents = CLASS(name=u'ea-extensionORAddressComponents', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_extensionORAddressComponents_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_extensionORAddressComponents._val = dict([(u'Type', _ea_extensionORAddressComponents_val_Type), (u'id', 12)])
    
    #-----< ea-physicalDeliveryPersonalName >-----#
    ea_physicalDeliveryPersonalName = CLASS(name=u'ea-physicalDeliveryPersonalName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_physicalDeliveryPersonalName_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_physicalDeliveryPersonalName._val = dict([(u'Type', _ea_physicalDeliveryPersonalName_val_Type), (u'id', 13)])
    
    #-----< ea-physicalDeliveryOrganizationName >-----#
    ea_physicalDeliveryOrganizationName = CLASS(name=u'ea-physicalDeliveryOrganizationName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_physicalDeliveryOrganizationName_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_physicalDeliveryOrganizationName._val = dict([(u'Type', _ea_physicalDeliveryOrganizationName_val_Type), (u'id', 14)])
    
    #-----< ea-extensionPhysicalDeliveryAddressComponents >-----#
    ea_extensionPhysicalDeliveryAddressComponents = CLASS(name=u'ea-extensionPhysicalDeliveryAddressComponents', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_extensionPhysicalDeliveryAddressComponents_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_extensionPhysicalDeliveryAddressComponents._val = dict([(u'Type', _ea_extensionPhysicalDeliveryAddressComponents_val_Type), (u'id', 15)])
    
    #-----< ea-unformattedPostalAddress >-----#
    ea_unformattedPostalAddress = CLASS(name=u'ea-unformattedPostalAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_unformattedPostalAddress_val_Type = SET(name=u'Type', mode=MODE_TYPE)
    __ea_unformattedPostalAddress_val_Type_printable_address = SEQ_OF(name=u'printable-address', mode=MODE_TYPE, opt=True)
    ___ea_unformattedPostalAddress_val_Type_printable_address__item_ = STR_PRINT(name='_item_', mode=MODE_TYPE)
    ___ea_unformattedPostalAddress_val_Type_printable_address__item_._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    __ea_unformattedPostalAddress_val_Type_printable_address._cont = ___ea_unformattedPostalAddress_val_Type_printable_address__item_
    __ea_unformattedPostalAddress_val_Type_printable_address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=6)], ev=None, er=[])
    __ea_unformattedPostalAddress_val_Type_teletex_string = STR_TELE(name=u'teletex-string', mode=MODE_TYPE, opt=True)
    __ea_unformattedPostalAddress_val_Type_teletex_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=180)], ev=None, er=[])
    _ea_unformattedPostalAddress_val_Type._cont = ASN1Dict([
        (u'printable-address', __ea_unformattedPostalAddress_val_Type_printable_address),
        (u'teletex-string', __ea_unformattedPostalAddress_val_Type_teletex_string),
        ])
    _ea_unformattedPostalAddress_val_Type._ext = None
    ea_unformattedPostalAddress._val = dict([(u'Type', _ea_unformattedPostalAddress_val_Type), (u'id', 16)])
    
    #-----< ea-streetAddress >-----#
    ea_streetAddress = CLASS(name=u'ea-streetAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_streetAddress_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_streetAddress._val = dict([(u'Type', _ea_streetAddress_val_Type), (u'id', 17)])
    
    #-----< ea-postOfficeBoxAddress >-----#
    ea_postOfficeBoxAddress = CLASS(name=u'ea-postOfficeBoxAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_postOfficeBoxAddress_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_postOfficeBoxAddress._val = dict([(u'Type', _ea_postOfficeBoxAddress_val_Type), (u'id', 18)])
    
    #-----< ea-posteRestanteAddress >-----#
    ea_posteRestanteAddress = CLASS(name=u'ea-posteRestanteAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_posteRestanteAddress_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_posteRestanteAddress._val = dict([(u'Type', _ea_posteRestanteAddress_val_Type), (u'id', 19)])
    
    #-----< ea-uniquePostalName >-----#
    ea_uniquePostalName = CLASS(name=u'ea-uniquePostalName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_uniquePostalName_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_uniquePostalName._val = dict([(u'Type', _ea_uniquePostalName_val_Type), (u'id', 20)])
    
    #-----< ea-localPostalAttributes >-----#
    ea_localPostalAttributes = CLASS(name=u'ea-localPostalAttributes', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_localPostalAttributes_val_Type = SET(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'PDSParameter')))
    ea_localPostalAttributes._val = dict([(u'Type', _ea_localPostalAttributes_val_Type), (u'id', 21)])
    
    #-----< PDSParameter >-----#
    PDSParameter = SET(name=u'PDSParameter', mode=MODE_TYPE)
    _PDSParameter_printable_string = STR_PRINT(name=u'printable-string', mode=MODE_TYPE, opt=True)
    _PDSParameter_printable_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    _PDSParameter_teletex_string = STR_TELE(name=u'teletex-string', mode=MODE_TYPE, opt=True)
    _PDSParameter_teletex_string._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    PDSParameter._cont = ASN1Dict([
        (u'printable-string', _PDSParameter_printable_string),
        (u'teletex-string', _PDSParameter_teletex_string),
        ])
    PDSParameter._ext = None
    
    #-----< ea-extendedNetworkAddress >-----#
    ea_extendedNetworkAddress = CLASS(name=u'ea-extendedNetworkAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_extendedNetworkAddress_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE)
    __ea_extendedNetworkAddress_val_Type_e163_4_address = SEQ(name=u'e163-4-address', mode=MODE_TYPE)
    ___ea_extendedNetworkAddress_val_Type_e163_4_address_number = STR_NUM(name=u'number', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___ea_extendedNetworkAddress_val_Type_e163_4_address_number._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    ___ea_extendedNetworkAddress_val_Type_e163_4_address_sub_address = STR_NUM(name=u'sub-address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ___ea_extendedNetworkAddress_val_Type_e163_4_address_sub_address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=40)], ev=None, er=[])
    __ea_extendedNetworkAddress_val_Type_e163_4_address._cont = ASN1Dict([
        (u'number', ___ea_extendedNetworkAddress_val_Type_e163_4_address_number),
        (u'sub-address', ___ea_extendedNetworkAddress_val_Type_e163_4_address_sub_address),
        ])
    __ea_extendedNetworkAddress_val_Type_e163_4_address._ext = None
    __ea_extendedNetworkAddress_val_Type_psap_address = SEQ(name=u'psap-address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'PresentationAddress')))
    _ea_extendedNetworkAddress_val_Type._cont = ASN1Dict([
        (u'e163-4-address', __ea_extendedNetworkAddress_val_Type_e163_4_address),
        (u'psap-address', __ea_extendedNetworkAddress_val_Type_psap_address),
        ])
    _ea_extendedNetworkAddress_val_Type._ext = None
    ea_extendedNetworkAddress._val = dict([(u'Type', _ea_extendedNetworkAddress_val_Type), (u'id', 22)])
    
    #-----< PresentationAddress >-----#
    PresentationAddress = SEQ(name=u'PresentationAddress', mode=MODE_TYPE)
    _PresentationAddress_pSelector = OCT_STR(name=u'pSelector', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PresentationAddress_sSelector = OCT_STR(name=u'sSelector', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PresentationAddress_tSelector = OCT_STR(name=u'tSelector', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PresentationAddress_nAddresses = SET_OF(name=u'nAddresses', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __PresentationAddress_nAddresses__item_ = OCT_STR(name='_item_', mode=MODE_TYPE)
    _PresentationAddress_nAddresses._cont = __PresentationAddress_nAddresses__item_
    _PresentationAddress_nAddresses._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PresentationAddress._cont = ASN1Dict([
        (u'pSelector', _PresentationAddress_pSelector),
        (u'sSelector', _PresentationAddress_sSelector),
        (u'tSelector', _PresentationAddress_tSelector),
        (u'nAddresses', _PresentationAddress_nAddresses),
        ])
    PresentationAddress._ext = None
    
    #-----< ea-terminalType >-----#
    ea_terminalType = CLASS(name=u'ea-terminalType', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_terminalType_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _ea_terminalType_val_Type._cont = ASN1Dict([(u'telex', 3), (u'teletex', 4), (u'g3-facsimile', 5), (u'g4-facsimile', 6), (u'ia5-terminal', 7), (u'videotex', 8)])
    _ea_terminalType_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=256)], ev=None, er=[])
    ea_terminalType._val = dict([(u'Type', _ea_terminalType_val_Type), (u'id', 23)])
    
    #-----< ea-teletexDomainDefinedAttributes >-----#
    ea_teletexDomainDefinedAttributes = CLASS(name=u'ea-teletexDomainDefinedAttributes', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'EXTENSION-ATTRIBUTE')))
    _ea_teletexDomainDefinedAttributes_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE)
    __ea_teletexDomainDefinedAttributes_val_Type__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-X400Address-2009', 'TeletexDomainDefinedAttribute')))
    _ea_teletexDomainDefinedAttributes_val_Type._cont = __ea_teletexDomainDefinedAttributes_val_Type__item_
    _ea_teletexDomainDefinedAttributes_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    ea_teletexDomainDefinedAttributes._val = dict([(u'Type', _ea_teletexDomainDefinedAttributes_val_Type), (u'id', 6)])
    
    #-----< TeletexDomainDefinedAttribute >-----#
    TeletexDomainDefinedAttribute = SEQ(name=u'TeletexDomainDefinedAttribute', mode=MODE_TYPE)
    _TeletexDomainDefinedAttribute_type = STR_TELE(name=u'type', mode=MODE_TYPE)
    _TeletexDomainDefinedAttribute_type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    _TeletexDomainDefinedAttribute_value = STR_TELE(name=u'value', mode=MODE_TYPE)
    _TeletexDomainDefinedAttribute_value._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    TeletexDomainDefinedAttribute._cont = ASN1Dict([
        (u'type', _TeletexDomainDefinedAttribute_type),
        (u'value', _TeletexDomainDefinedAttribute_value),
        ])
    TeletexDomainDefinedAttribute._ext = None
    
    #-----< ub-match >-----#
    ub_match = INT(name=u'ub-match', mode=MODE_VALUE)
    ub_match._val = 128
    
    #-----< ub-common-name-length >-----#
    ub_common_name_length = INT(name=u'ub-common-name-length', mode=MODE_VALUE)
    ub_common_name_length._val = 64
    
    #-----< ub-country-name-alpha-length >-----#
    ub_country_name_alpha_length = INT(name=u'ub-country-name-alpha-length', mode=MODE_VALUE)
    ub_country_name_alpha_length._val = 2
    
    #-----< ub-country-name-numeric-length >-----#
    ub_country_name_numeric_length = INT(name=u'ub-country-name-numeric-length', mode=MODE_VALUE)
    ub_country_name_numeric_length._val = 3
    
    #-----< ub-domain-defined-attributes >-----#
    ub_domain_defined_attributes = INT(name=u'ub-domain-defined-attributes', mode=MODE_VALUE)
    ub_domain_defined_attributes._val = 4
    
    #-----< ub-domain-defined-attribute-type-length >-----#
    ub_domain_defined_attribute_type_length = INT(name=u'ub-domain-defined-attribute-type-length', mode=MODE_VALUE)
    ub_domain_defined_attribute_type_length._val = 8
    
    #-----< ub-domain-defined-attribute-value-length >-----#
    ub_domain_defined_attribute_value_length = INT(name=u'ub-domain-defined-attribute-value-length', mode=MODE_VALUE)
    ub_domain_defined_attribute_value_length._val = 128
    
    #-----< ub-domain-name-length >-----#
    ub_domain_name_length = INT(name=u'ub-domain-name-length', mode=MODE_VALUE)
    ub_domain_name_length._val = 16
    
    #-----< ub-extension-attributes >-----#
    ub_extension_attributes = INT(name=u'ub-extension-attributes', mode=MODE_VALUE)
    ub_extension_attributes._val = 256
    
    #-----< ub-e163-4-number-length >-----#
    ub_e163_4_number_length = INT(name=u'ub-e163-4-number-length', mode=MODE_VALUE)
    ub_e163_4_number_length._val = 15
    
    #-----< ub-e163-4-sub-address-length >-----#
    ub_e163_4_sub_address_length = INT(name=u'ub-e163-4-sub-address-length', mode=MODE_VALUE)
    ub_e163_4_sub_address_length._val = 40
    
    #-----< ub-generation-qualifier-length >-----#
    ub_generation_qualifier_length = INT(name=u'ub-generation-qualifier-length', mode=MODE_VALUE)
    ub_generation_qualifier_length._val = 3
    
    #-----< ub-given-name-length >-----#
    ub_given_name_length = INT(name=u'ub-given-name-length', mode=MODE_VALUE)
    ub_given_name_length._val = 16
    
    #-----< ub-initials-length >-----#
    ub_initials_length = INT(name=u'ub-initials-length', mode=MODE_VALUE)
    ub_initials_length._val = 5
    
    #-----< ub-integer-options >-----#
    ub_integer_options = INT(name=u'ub-integer-options', mode=MODE_VALUE)
    ub_integer_options._val = 256
    
    #-----< ub-numeric-user-id-length >-----#
    ub_numeric_user_id_length = INT(name=u'ub-numeric-user-id-length', mode=MODE_VALUE)
    ub_numeric_user_id_length._val = 32
    
    #-----< ub-organization-name-length >-----#
    ub_organization_name_length = INT(name=u'ub-organization-name-length', mode=MODE_VALUE)
    ub_organization_name_length._val = 64
    
    #-----< ub-organizational-unit-name-length >-----#
    ub_organizational_unit_name_length = INT(name=u'ub-organizational-unit-name-length', mode=MODE_VALUE)
    ub_organizational_unit_name_length._val = 32
    
    #-----< ub-organizational-units >-----#
    ub_organizational_units = INT(name=u'ub-organizational-units', mode=MODE_VALUE)
    ub_organizational_units._val = 4
    
    #-----< ub-pds-name-length >-----#
    ub_pds_name_length = INT(name=u'ub-pds-name-length', mode=MODE_VALUE)
    ub_pds_name_length._val = 16
    
    #-----< ub-pds-parameter-length >-----#
    ub_pds_parameter_length = INT(name=u'ub-pds-parameter-length', mode=MODE_VALUE)
    ub_pds_parameter_length._val = 30
    
    #-----< ub-pds-physical-address-lines >-----#
    ub_pds_physical_address_lines = INT(name=u'ub-pds-physical-address-lines', mode=MODE_VALUE)
    ub_pds_physical_address_lines._val = 6
    
    #-----< ub-postal-code-length >-----#
    ub_postal_code_length = INT(name=u'ub-postal-code-length', mode=MODE_VALUE)
    ub_postal_code_length._val = 16
    
    #-----< ub-surname-length >-----#
    ub_surname_length = INT(name=u'ub-surname-length', mode=MODE_VALUE)
    ub_surname_length._val = 40
    
    #-----< ub-terminal-id-length >-----#
    ub_terminal_id_length = INT(name=u'ub-terminal-id-length', mode=MODE_VALUE)
    ub_terminal_id_length._val = 24
    
    #-----< ub-unformatted-address-length >-----#
    ub_unformatted_address_length = INT(name=u'ub-unformatted-address-length', mode=MODE_VALUE)
    ub_unformatted_address_length._val = 180
    
    #-----< ub-x121-address-length >-----#
    ub_x121_address_length = INT(name=u'ub-x121-address-length', mode=MODE_VALUE)
    ub_x121_address_length._val = 16
    
    _all_ = [
        _ORAddress_built_in_standard_attributes,
        _ORAddress_built_in_domain_defined_attributes,
        _ORAddress_extension_attributes,
        ORAddress,
        _BuiltInStandardAttributes_country_name,
        _BuiltInStandardAttributes_administration_domain_name,
        _BuiltInStandardAttributes_network_address,
        _BuiltInStandardAttributes_terminal_identifier,
        _BuiltInStandardAttributes_private_domain_name,
        _BuiltInStandardAttributes_organization_name,
        _BuiltInStandardAttributes_numeric_user_identifier,
        _BuiltInStandardAttributes_personal_name,
        _BuiltInStandardAttributes_organizational_unit_names,
        BuiltInStandardAttributes,
        _CountryName_x121_dcc_code,
        _CountryName_iso_3166_alpha2_code,
        CountryName,
        _AdministrationDomainName_numeric,
        _AdministrationDomainName_printable,
        AdministrationDomainName,
        NetworkAddress,
        X121Address,
        TerminalIdentifier,
        _PrivateDomainName_numeric,
        _PrivateDomainName_printable,
        PrivateDomainName,
        OrganizationName,
        NumericUserIdentifier,
        _PersonalName_surname,
        _PersonalName_given_name,
        _PersonalName_initials,
        _PersonalName_generation_qualifier,
        PersonalName,
        _OrganizationalUnitNames__item_,
        OrganizationalUnitNames,
        OrganizationalUnitName,
        _BuiltInDomainDefinedAttributes__item_,
        BuiltInDomainDefinedAttributes,
        _BuiltInDomainDefinedAttribute_type,
        _BuiltInDomainDefinedAttribute_value,
        BuiltInDomainDefinedAttribute,
        _ExtensionAttributes__item_,
        ExtensionAttributes,
        _EXTENSION_ATTRIBUTE_id,
        _EXTENSION_ATTRIBUTE_Type,
        EXTENSION_ATTRIBUTE,
        __ExtensionAttribute_extension_attribute_type_tab,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_0,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_1,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_2,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_surname,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_given_name,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_initials,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_3_generation_qualifier,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_3,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_4__item_,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_4,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_5,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_6_x121_dcc_code,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_6_iso_3166_alpha2_code,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_6,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_7_numeric_code,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_7_printable_code,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_7,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_8,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_9,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_10,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_11,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_12,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_13,
        _____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_printable_address__item_,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_printable_address,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_14_teletex_string,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_14,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_15,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_16,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_17,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_18,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_19,
        _____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address_number,
        _____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address_sub_address,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_e163_4_address,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_20_psap_address,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_20,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_21,
        ____ExtensionAttribute_extension_attribute_type_tab_val_Type_22__item_,
        ___ExtensionAttribute_extension_attribute_type_tab_val_Type_22,
        _ExtensionAttribute_extension_attribute_type,
        _ExtensionAttribute_extension_attribute_value,
        ExtensionAttribute,
        SupportedExtensionAttributes,
        _SupportedExtensionAttributes_val_Type_0,
        _SupportedExtensionAttributes_val_Type_1,
        _SupportedExtensionAttributes_val_Type_2,
        __SupportedExtensionAttributes_val_Type_3_surname,
        __SupportedExtensionAttributes_val_Type_3_given_name,
        __SupportedExtensionAttributes_val_Type_3_initials,
        __SupportedExtensionAttributes_val_Type_3_generation_qualifier,
        _SupportedExtensionAttributes_val_Type_3,
        __SupportedExtensionAttributes_val_Type_4__item_,
        _SupportedExtensionAttributes_val_Type_4,
        _SupportedExtensionAttributes_val_Type_5,
        __SupportedExtensionAttributes_val_Type_6_x121_dcc_code,
        __SupportedExtensionAttributes_val_Type_6_iso_3166_alpha2_code,
        _SupportedExtensionAttributes_val_Type_6,
        __SupportedExtensionAttributes_val_Type_7_numeric_code,
        __SupportedExtensionAttributes_val_Type_7_printable_code,
        _SupportedExtensionAttributes_val_Type_7,
        _SupportedExtensionAttributes_val_Type_8,
        _SupportedExtensionAttributes_val_Type_9,
        _SupportedExtensionAttributes_val_Type_10,
        _SupportedExtensionAttributes_val_Type_11,
        _SupportedExtensionAttributes_val_Type_12,
        _SupportedExtensionAttributes_val_Type_13,
        ___SupportedExtensionAttributes_val_Type_14_printable_address__item_,
        __SupportedExtensionAttributes_val_Type_14_printable_address,
        __SupportedExtensionAttributes_val_Type_14_teletex_string,
        _SupportedExtensionAttributes_val_Type_14,
        _SupportedExtensionAttributes_val_Type_15,
        _SupportedExtensionAttributes_val_Type_16,
        _SupportedExtensionAttributes_val_Type_17,
        _SupportedExtensionAttributes_val_Type_18,
        _SupportedExtensionAttributes_val_Type_19,
        ___SupportedExtensionAttributes_val_Type_20_e163_4_address_number,
        ___SupportedExtensionAttributes_val_Type_20_e163_4_address_sub_address,
        __SupportedExtensionAttributes_val_Type_20_e163_4_address,
        __SupportedExtensionAttributes_val_Type_20_psap_address,
        _SupportedExtensionAttributes_val_Type_20,
        _SupportedExtensionAttributes_val_Type_21,
        __SupportedExtensionAttributes_val_Type_22__item_,
        _SupportedExtensionAttributes_val_Type_22,
        ea_commonName,
        _ea_commonName_val_Type,
        ea_teletexCommonName,
        _ea_teletexCommonName_val_Type,
        ea_teletexOrganizationName,
        _ea_teletexOrganizationName_val_Type,
        ea_teletexPersonalName,
        __ea_teletexPersonalName_val_Type_surname,
        __ea_teletexPersonalName_val_Type_given_name,
        __ea_teletexPersonalName_val_Type_initials,
        __ea_teletexPersonalName_val_Type_generation_qualifier,
        _ea_teletexPersonalName_val_Type,
        ea_teletexOrganizationalUnitNames,
        __ea_teletexOrganizationalUnitNames_val_Type__item_,
        _ea_teletexOrganizationalUnitNames_val_Type,
        TeletexOrganizationalUnitName,
        ea_pDSName,
        _ea_pDSName_val_Type,
        ea_physicalDeliveryCountryName,
        __ea_physicalDeliveryCountryName_val_Type_x121_dcc_code,
        __ea_physicalDeliveryCountryName_val_Type_iso_3166_alpha2_code,
        _ea_physicalDeliveryCountryName_val_Type,
        ea_postalCode,
        __ea_postalCode_val_Type_numeric_code,
        __ea_postalCode_val_Type_printable_code,
        _ea_postalCode_val_Type,
        ea_physicalDeliveryOfficeName,
        _ea_physicalDeliveryOfficeName_val_Type,
        ea_physicalDeliveryOfficeNumber,
        _ea_physicalDeliveryOfficeNumber_val_Type,
        ea_extensionORAddressComponents,
        _ea_extensionORAddressComponents_val_Type,
        ea_physicalDeliveryPersonalName,
        _ea_physicalDeliveryPersonalName_val_Type,
        ea_physicalDeliveryOrganizationName,
        _ea_physicalDeliveryOrganizationName_val_Type,
        ea_extensionPhysicalDeliveryAddressComponents,
        _ea_extensionPhysicalDeliveryAddressComponents_val_Type,
        ea_unformattedPostalAddress,
        ___ea_unformattedPostalAddress_val_Type_printable_address__item_,
        __ea_unformattedPostalAddress_val_Type_printable_address,
        __ea_unformattedPostalAddress_val_Type_teletex_string,
        _ea_unformattedPostalAddress_val_Type,
        ea_streetAddress,
        _ea_streetAddress_val_Type,
        ea_postOfficeBoxAddress,
        _ea_postOfficeBoxAddress_val_Type,
        ea_posteRestanteAddress,
        _ea_posteRestanteAddress_val_Type,
        ea_uniquePostalName,
        _ea_uniquePostalName_val_Type,
        ea_localPostalAttributes,
        _ea_localPostalAttributes_val_Type,
        _PDSParameter_printable_string,
        _PDSParameter_teletex_string,
        PDSParameter,
        ea_extendedNetworkAddress,
        ___ea_extendedNetworkAddress_val_Type_e163_4_address_number,
        ___ea_extendedNetworkAddress_val_Type_e163_4_address_sub_address,
        __ea_extendedNetworkAddress_val_Type_e163_4_address,
        __ea_extendedNetworkAddress_val_Type_psap_address,
        _ea_extendedNetworkAddress_val_Type,
        _PresentationAddress_pSelector,
        _PresentationAddress_sSelector,
        _PresentationAddress_tSelector,
        __PresentationAddress_nAddresses__item_,
        _PresentationAddress_nAddresses,
        PresentationAddress,
        ea_terminalType,
        _ea_terminalType_val_Type,
        ea_teletexDomainDefinedAttributes,
        __ea_teletexDomainDefinedAttributes_val_Type__item_,
        _ea_teletexDomainDefinedAttributes_val_Type,
        _TeletexDomainDefinedAttribute_type,
        _TeletexDomainDefinedAttribute_value,
        TeletexDomainDefinedAttribute,
        ub_match,
        ub_common_name_length,
        ub_country_name_alpha_length,
        ub_country_name_numeric_length,
        ub_domain_defined_attributes,
        ub_domain_defined_attribute_type_length,
        ub_domain_defined_attribute_value_length,
        ub_domain_name_length,
        ub_extension_attributes,
        ub_e163_4_number_length,
        ub_e163_4_sub_address_length,
        ub_generation_qualifier_length,
        ub_given_name_length,
        ub_initials_length,
        ub_integer_options,
        ub_numeric_user_id_length,
        ub_organization_name_length,
        ub_organizational_unit_name_length,
        ub_organizational_units,
        ub_pds_name_length,
        ub_pds_parameter_length,
        ub_pds_physical_address_lines,
        ub_postal_code_length,
        ub_surname_length,
        ub_terminal_id_length,
        ub_unformatted_address_length,
        ub_x121_address_length,
    ]

class SecureMimeMessageV3dot1_2009:

    _name_  = u'SecureMimeMessageV3dot1-2009'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 39]
    
    _obj_ = [
        u'SMimeAttributeSet',
        u'id-aa',
        u'aa-smimeCapabilities',
        u'smimeCapabilities',
        u'SMimeCapsSet',
        u'aa-encrypKeyPref',
        u'id-aa-encrypKeyPref',
        u'SMIMEEncryptionKeyPreference',
        u'id-smime',
        u'id-cap',
        u'cap-preferBinaryInside',
        u'id-cap-preferBinaryInside',
        u'cap-RC2CBC',
        u'SMIMECapabilitiesParametersForRC2CBC',
        ]
    _type_ = [
        u'SMIMEEncryptionKeyPreference',
        u'SMIMECapabilitiesParametersForRC2CBC',
        ]
    _set_ = [
        u'SMimeAttributeSet',
        u'SMimeCapsSet',
        ]
    _val_ = [
        u'id-aa',
        u'aa-smimeCapabilities',
        u'smimeCapabilities',
        u'aa-encrypKeyPref',
        u'id-aa-encrypKeyPref',
        u'id-smime',
        u'id-cap',
        u'cap-preferBinaryInside',
        u'id-cap-preferBinaryInside',
        u'cap-RC2CBC',
        ]
    _class_ = [
        u'SMimeAttributeSet',
        u'aa-smimeCapabilities',
        u'SMimeCapsSet',
        u'aa-encrypKeyPref',
        u'cap-preferBinaryInside',
        u'cap-RC2CBC',
        ]
    _param_ = [
        ]
    
    #-----< SMimeAttributeSet >-----#
    SMimeAttributeSet = CLASS(name=u'SMimeAttributeSet', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _SMimeAttributeSet_val_Type_0 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIMECapabilities')))
    __SMimeAttributeSet_val_Type_0__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIMECapability')))
    ___SMimeAttributeSet_val_Type_0__item__capabilityID = OID(name=u'capabilityID', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SMIME-CAPS'), [u'id']))
    ____SMimeAttributeSet_val_Type_0__item__capabilityID_tab = CLASS(name='_tab_SMIME-CAPS', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_1 = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_13 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_14 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    ____SMimeAttributeSet_val_Type_0__item__capabilityID_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 11, 1))]), dict([(u'Type', _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_1), (u'id', (1, 2, 840, 113549, 3, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'id', (1, 2, 840, 10040, 4, 3))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_13), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]), dict([(u'Type', _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_14), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]), dict([(u'id', (1, 2, 840, 113549, 3, 7))]), dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'Type', _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 7))])], rr=[], ev=None, er=[])
    ___SMimeAttributeSet_val_Type_0__item__capabilityID._const_tab = ____SMimeAttributeSet_val_Type_0__item__capabilityID_tab
    ___SMimeAttributeSet_val_Type_0__item__capabilityID._const_tab_at = None
    ___SMimeAttributeSet_val_Type_0__item__capabilityID._const_tab_id = u'id'
    ___SMimeAttributeSet_val_Type_0__item__parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SMIME-CAPS'), [u'Type']), opt=True)
    ___SMimeAttributeSet_val_Type_0__item__parameters._const_tab = ____SMimeAttributeSet_val_Type_0__item__capabilityID_tab
    ___SMimeAttributeSet_val_Type_0__item__parameters._const_tab_at = ('..', u'capabilityID')
    ___SMimeAttributeSet_val_Type_0__item__parameters._const_tab_id = u'Type'
    __SMimeAttributeSet_val_Type_0__item_._cont = ASN1Dict([
        (u'capabilityID', ___SMimeAttributeSet_val_Type_0__item__capabilityID),
        (u'parameters', ___SMimeAttributeSet_val_Type_0__item__parameters),
        ])
    __SMimeAttributeSet_val_Type_0__item_._ext = None
    _SMimeAttributeSet_val_Type_0._cont = __SMimeAttributeSet_val_Type_0__item_
    _SMimeAttributeSet_val_Type_0._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _SMimeAttributeSet_val_Type_1 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMEEncryptionKeyPreference')))
    SMimeAttributeSet._val = ASN1Set(rv=[dict([(u'Type', _SMimeAttributeSet_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 15))]), dict([(u'Type', _SMimeAttributeSet_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 16, 2, 11))])], rr=[], ev=[], er=[])
    
    #-----< id-aa >-----#
    id_aa = OID(name=u'id-aa', mode=MODE_VALUE)
    id_aa._val = (1, 2, 840, 113549, 1, 9, 16, 2)
    
    #-----< aa-smimeCapabilities >-----#
    aa_smimeCapabilities = CLASS(name=u'aa-smimeCapabilities', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_smimeCapabilities_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIMECapabilities')))
    __aa_smimeCapabilities_val_Type__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIMECapability')))
    ___aa_smimeCapabilities_val_Type__item__capabilityID = OID(name=u'capabilityID', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SMIME-CAPS'), [u'id']))
    ____aa_smimeCapabilities_val_Type__item__capabilityID_tab = CLASS(name='_tab_SMIME-CAPS', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_1 = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_13 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_14 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    ____aa_smimeCapabilities_val_Type__item__capabilityID_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 11, 1))]), dict([(u'Type', _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_1), (u'id', (1, 2, 840, 113549, 3, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'id', (1, 2, 840, 10040, 4, 3))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_13), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]), dict([(u'Type', _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_14), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]), dict([(u'id', (1, 2, 840, 113549, 3, 7))]), dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'Type', _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 7))])], rr=[], ev=None, er=[])
    ___aa_smimeCapabilities_val_Type__item__capabilityID._const_tab = ____aa_smimeCapabilities_val_Type__item__capabilityID_tab
    ___aa_smimeCapabilities_val_Type__item__capabilityID._const_tab_at = None
    ___aa_smimeCapabilities_val_Type__item__capabilityID._const_tab_id = u'id'
    ___aa_smimeCapabilities_val_Type__item__parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SMIME-CAPS'), [u'Type']), opt=True)
    ___aa_smimeCapabilities_val_Type__item__parameters._const_tab = ____aa_smimeCapabilities_val_Type__item__capabilityID_tab
    ___aa_smimeCapabilities_val_Type__item__parameters._const_tab_at = ('..', u'capabilityID')
    ___aa_smimeCapabilities_val_Type__item__parameters._const_tab_id = u'Type'
    __aa_smimeCapabilities_val_Type__item_._cont = ASN1Dict([
        (u'capabilityID', ___aa_smimeCapabilities_val_Type__item__capabilityID),
        (u'parameters', ___aa_smimeCapabilities_val_Type__item__parameters),
        ])
    __aa_smimeCapabilities_val_Type__item_._ext = None
    _aa_smimeCapabilities_val_Type._cont = __aa_smimeCapabilities_val_Type__item_
    _aa_smimeCapabilities_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    aa_smimeCapabilities._val = dict([(u'Type', _aa_smimeCapabilities_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 15))])
    
    #-----< smimeCapabilities >-----#
    smimeCapabilities = OID(name=u'smimeCapabilities', mode=MODE_VALUE)
    smimeCapabilities._val = (1, 2, 840, 113549, 1, 9, 15)
    
    #-----< SMimeCapsSet >-----#
    SMimeCapsSet = CLASS(name=u'SMimeCapsSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _SMimeCapsSet_val_Type_1 = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    _SMimeCapsSet_val_Type_13 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _SMimeCapsSet_val_Type_14 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _SMimeCapsSet_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    SMimeCapsSet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 11, 1))]), dict([(u'Type', _SMimeCapsSet_val_Type_1), (u'id', (1, 2, 840, 113549, 3, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'id', (1, 2, 840, 10040, 4, 3))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _SMimeCapsSet_val_Type_13), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]), dict([(u'Type', _SMimeCapsSet_val_Type_14), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]), dict([(u'id', (1, 2, 840, 113549, 3, 7))]), dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'Type', _SMimeCapsSet_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 7))])], rr=[], ev=[], er=[])
    
    #-----< aa-encrypKeyPref >-----#
    aa_encrypKeyPref = CLASS(name=u'aa-encrypKeyPref', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_encrypKeyPref_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMEEncryptionKeyPreference')))
    aa_encrypKeyPref._val = dict([(u'Type', _aa_encrypKeyPref_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 2, 11))])
    
    #-----< id-aa-encrypKeyPref >-----#
    id_aa_encrypKeyPref = OID(name=u'id-aa-encrypKeyPref', mode=MODE_VALUE)
    id_aa_encrypKeyPref._val = (1, 2, 840, 113549, 1, 9, 16, 2, 11)
    
    #-----< SMIMEEncryptionKeyPreference >-----#
    SMIMEEncryptionKeyPreference = CHOICE(name=u'SMIMEEncryptionKeyPreference', mode=MODE_TYPE)
    _SMIMEEncryptionKeyPreference_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    _SMIMEEncryptionKeyPreference_receipentKeyId = SEQ(name=u'receipentKeyId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientKeyIdentifier')))
    _SMIMEEncryptionKeyPreference_subjectAltKeyIdentifier = OCT_STR(name=u'subjectAltKeyIdentifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SubjectKeyIdentifier')))
    SMIMEEncryptionKeyPreference._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _SMIMEEncryptionKeyPreference_issuerAndSerialNumber),
        (u'receipentKeyId', _SMIMEEncryptionKeyPreference_receipentKeyId),
        (u'subjectAltKeyIdentifier', _SMIMEEncryptionKeyPreference_subjectAltKeyIdentifier),
        ])
    SMIMEEncryptionKeyPreference._ext = None
    
    #-----< id-smime >-----#
    id_smime = OID(name=u'id-smime', mode=MODE_VALUE)
    id_smime._val = (1, 2, 840, 113549, 1, 9, 16)
    
    #-----< id-cap >-----#
    id_cap = OID(name=u'id-cap', mode=MODE_VALUE)
    id_cap._val = (1, 2, 840, 113549, 1, 9, 16, 11)
    
    #-----< cap-preferBinaryInside >-----#
    cap_preferBinaryInside = CLASS(name=u'cap-preferBinaryInside', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    cap_preferBinaryInside._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 11, 1))])
    
    #-----< id-cap-preferBinaryInside >-----#
    id_cap_preferBinaryInside = OID(name=u'id-cap-preferBinaryInside', mode=MODE_VALUE)
    id_cap_preferBinaryInside._val = (1, 2, 840, 113549, 1, 9, 16, 11, 1)
    
    #-----< cap-RC2CBC >-----#
    cap_RC2CBC = CLASS(name=u'cap-RC2CBC', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _cap_RC2CBC_val_Type = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    cap_RC2CBC._val = dict([(u'Type', _cap_RC2CBC_val_Type), (u'id', (1, 2, 840, 113549, 3, 2))])
    
    #-----< SMIMECapabilitiesParametersForRC2CBC >-----#
    SMIMECapabilitiesParametersForRC2CBC = INT(name=u'SMIMECapabilitiesParametersForRC2CBC', mode=MODE_TYPE)
    SMIMECapabilitiesParametersForRC2CBC._const_val = ASN1Set(rv=[40, 128], rr=[], ev=[], er=[])
    
    _all_ = [
        SMimeAttributeSet,
        ____SMimeAttributeSet_val_Type_0__item__capabilityID_tab,
        _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_1,
        _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_13,
        _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_14,
        _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_21,
        ___SMimeAttributeSet_val_Type_0__item__capabilityID,
        ___SMimeAttributeSet_val_Type_0__item__parameters,
        __SMimeAttributeSet_val_Type_0__item_,
        _SMimeAttributeSet_val_Type_0,
        _SMimeAttributeSet_val_Type_1,
        id_aa,
        aa_smimeCapabilities,
        ____aa_smimeCapabilities_val_Type__item__capabilityID_tab,
        _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_1,
        _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_13,
        _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_14,
        _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_21,
        ___aa_smimeCapabilities_val_Type__item__capabilityID,
        ___aa_smimeCapabilities_val_Type__item__parameters,
        __aa_smimeCapabilities_val_Type__item_,
        _aa_smimeCapabilities_val_Type,
        smimeCapabilities,
        SMimeCapsSet,
        _SMimeCapsSet_val_Type_1,
        _SMimeCapsSet_val_Type_13,
        _SMimeCapsSet_val_Type_14,
        _SMimeCapsSet_val_Type_21,
        aa_encrypKeyPref,
        _aa_encrypKeyPref_val_Type,
        id_aa_encrypKeyPref,
        _SMIMEEncryptionKeyPreference_issuerAndSerialNumber,
        _SMIMEEncryptionKeyPreference_receipentKeyId,
        _SMIMEEncryptionKeyPreference_subjectAltKeyIdentifier,
        SMIMEEncryptionKeyPreference,
        id_smime,
        id_cap,
        cap_preferBinaryInside,
        id_cap_preferBinaryInside,
        cap_RC2CBC,
        _cap_RC2CBC_val_Type,
        SMIMECapabilitiesParametersForRC2CBC,
    ]

class _IMPL_:

    _name_ = '_IMPL_'
    _oid_  = []
    _obj_  = ['REAL', 'EXTERNAL', 'EMBEDDED PDV', 'CHARACTER STRING', 'TYPE-IDENTIFIER', 'ABSTRACT-SYNTAX']
    
    #-----< REAL >-----#
    REAL = SEQ(name='REAL', mode=MODE_TYPE)
    _REAL_mantissa = INT(name='mantissa', mode=MODE_TYPE)
    _REAL_base = INT(name='base', mode=MODE_TYPE)
    _REAL_base._const_val = ASN1Set(rv=[2, 10], rr=[], ev=None, er=[])
    _REAL_exponent = INT(name='exponent', mode=MODE_TYPE)
    REAL._cont = ASN1Dict([
        ('mantissa', _REAL_mantissa),
        ('base', _REAL_base),
        ('exponent', _REAL_exponent),
        ])
    REAL._ext = None
    
    #-----< EXTERNAL >-----#
    EXTERNAL = SEQ(name='EXTERNAL', mode=MODE_TYPE)
    _EXTERNAL_identification = CHOICE(name='identification', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EXTERNAL_identification_syntaxes = SEQ(name='syntaxes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EXTERNAL_identification_syntaxes_abstract = OID(name='abstract', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EXTERNAL_identification_syntaxes_transfer = OID(name='transfer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EXTERNAL_identification_syntaxes._cont = ASN1Dict([
        ('abstract', ___EXTERNAL_identification_syntaxes_abstract),
        ('transfer', ___EXTERNAL_identification_syntaxes_transfer),
        ])
    __EXTERNAL_identification_syntaxes._ext = None
    __EXTERNAL_identification_syntax = OID(name='syntax', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EXTERNAL_identification_presentation_context_id = INT(name='presentation-context-id', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EXTERNAL_identification_context_negotiation = SEQ(name='context-negotiation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EXTERNAL_identification_context_negotiation_presentation_context_id = INT(name='presentation-context-id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EXTERNAL_identification_context_negotiation_transfer_syntax = OID(name='transfer-syntax', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EXTERNAL_identification_context_negotiation._cont = ASN1Dict([
        ('presentation-context-id', ___EXTERNAL_identification_context_negotiation_presentation_context_id),
        ('transfer-syntax', ___EXTERNAL_identification_context_negotiation_transfer_syntax),
        ])
    __EXTERNAL_identification_context_negotiation._ext = None
    __EXTERNAL_identification_transfer_syntax = OID(name='transfer-syntax', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EXTERNAL_identification_fixed = NULL(name='fixed', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _EXTERNAL_identification._cont = ASN1Dict([
        ('syntaxes', __EXTERNAL_identification_syntaxes),
        ('syntax', __EXTERNAL_identification_syntax),
        ('presentation-context-id', __EXTERNAL_identification_presentation_context_id),
        ('context-negotiation', __EXTERNAL_identification_context_negotiation),
        ('transfer-syntax', __EXTERNAL_identification_transfer_syntax),
        ('fixed', __EXTERNAL_identification_fixed),
        ])
    _EXTERNAL_identification._ext = None
    _EXTERNAL_data_value_descriptor = OBJ_DESC(name='data-value-descriptor', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _EXTERNAL_data_value = OCT_STR(name='data-value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    EXTERNAL._cont = ASN1Dict([
        ('identification', _EXTERNAL_identification),
        ('data-value-descriptor', _EXTERNAL_data_value_descriptor),
        ('data-value', _EXTERNAL_data_value),
        ])
    EXTERNAL._ext = None
    
    #-----< EMBEDDED PDV >-----#
    EMBEDDED_PDV = SEQ(name='EMBEDDED PDV', mode=MODE_TYPE)
    _EMBEDDED_PDV_identification = CHOICE(name='identification', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EMBEDDED_PDV_identification_syntaxes = SEQ(name='syntaxes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EMBEDDED_PDV_identification_syntaxes_abstract = OID(name='abstract', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EMBEDDED_PDV_identification_syntaxes_transfer = OID(name='transfer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EMBEDDED_PDV_identification_syntaxes._cont = ASN1Dict([
        ('abstract', ___EMBEDDED_PDV_identification_syntaxes_abstract),
        ('transfer', ___EMBEDDED_PDV_identification_syntaxes_transfer),
        ])
    __EMBEDDED_PDV_identification_syntaxes._ext = None
    __EMBEDDED_PDV_identification_syntax = OID(name='syntax', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EMBEDDED_PDV_identification_presentation_context_id = INT(name='presentation-context-id', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EMBEDDED_PDV_identification_context_negotiation = SEQ(name='context-negotiation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EMBEDDED_PDV_identification_context_negotiation_presentation_context_id = INT(name='presentation-context-id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EMBEDDED_PDV_identification_context_negotiation_transfer_syntax = OID(name='transfer-syntax', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EMBEDDED_PDV_identification_context_negotiation._cont = ASN1Dict([
        ('presentation-context-id', ___EMBEDDED_PDV_identification_context_negotiation_presentation_context_id),
        ('transfer-syntax', ___EMBEDDED_PDV_identification_context_negotiation_transfer_syntax),
        ])
    __EMBEDDED_PDV_identification_context_negotiation._ext = None
    __EMBEDDED_PDV_identification_transfer_syntax = OID(name='transfer-syntax', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EMBEDDED_PDV_identification_fixed = NULL(name='fixed', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _EMBEDDED_PDV_identification._cont = ASN1Dict([
        ('syntaxes', __EMBEDDED_PDV_identification_syntaxes),
        ('syntax', __EMBEDDED_PDV_identification_syntax),
        ('presentation-context-id', __EMBEDDED_PDV_identification_presentation_context_id),
        ('context-negotiation', __EMBEDDED_PDV_identification_context_negotiation),
        ('transfer-syntax', __EMBEDDED_PDV_identification_transfer_syntax),
        ('fixed', __EMBEDDED_PDV_identification_fixed),
        ])
    _EMBEDDED_PDV_identification._ext = None
    _EMBEDDED_PDV_data_value_descriptor = OBJ_DESC(name='data-value-descriptor', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _EMBEDDED_PDV_data_value = OCT_STR(name='data-value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    EMBEDDED_PDV._cont = ASN1Dict([
        ('identification', _EMBEDDED_PDV_identification),
        ('data-value-descriptor', _EMBEDDED_PDV_data_value_descriptor),
        ('data-value', _EMBEDDED_PDV_data_value),
        ])
    EMBEDDED_PDV._ext = None
    
    #-----< CHARACTER STRING >-----#
    CHARACTER_STRING = SEQ(name='CHARACTER STRING', mode=MODE_TYPE)
    _CHARACTER_STRING_identification = CHOICE(name='identification', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CHARACTER_STRING_identification_syntaxes = SEQ(name='syntaxes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___CHARACTER_STRING_identification_syntaxes_abstract = OID(name='abstract', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___CHARACTER_STRING_identification_syntaxes_transfer = OID(name='transfer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CHARACTER_STRING_identification_syntaxes._cont = ASN1Dict([
        ('abstract', ___CHARACTER_STRING_identification_syntaxes_abstract),
        ('transfer', ___CHARACTER_STRING_identification_syntaxes_transfer),
        ])
    __CHARACTER_STRING_identification_syntaxes._ext = None
    __CHARACTER_STRING_identification_syntax = OID(name='syntax', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CHARACTER_STRING_identification_presentation_context_id = INT(name='presentation-context-id', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CHARACTER_STRING_identification_context_negotiation = SEQ(name='context-negotiation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___CHARACTER_STRING_identification_context_negotiation_presentation_context_id = INT(name='presentation-context-id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___CHARACTER_STRING_identification_context_negotiation_transfer_syntax = OID(name='transfer-syntax', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CHARACTER_STRING_identification_context_negotiation._cont = ASN1Dict([
        ('presentation-context-id', ___CHARACTER_STRING_identification_context_negotiation_presentation_context_id),
        ('transfer-syntax', ___CHARACTER_STRING_identification_context_negotiation_transfer_syntax),
        ])
    __CHARACTER_STRING_identification_context_negotiation._ext = None
    __CHARACTER_STRING_identification_transfer_syntax = OID(name='transfer-syntax', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __CHARACTER_STRING_identification_fixed = NULL(name='fixed', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _CHARACTER_STRING_identification._cont = ASN1Dict([
        ('syntaxes', __CHARACTER_STRING_identification_syntaxes),
        ('syntax', __CHARACTER_STRING_identification_syntax),
        ('presentation-context-id', __CHARACTER_STRING_identification_presentation_context_id),
        ('context-negotiation', __CHARACTER_STRING_identification_context_negotiation),
        ('transfer-syntax', __CHARACTER_STRING_identification_transfer_syntax),
        ('fixed', __CHARACTER_STRING_identification_fixed),
        ])
    _CHARACTER_STRING_identification._ext = None
    _CHARACTER_STRING_string_value = OCT_STR(name='string-value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    CHARACTER_STRING._cont = ASN1Dict([
        ('identification', _CHARACTER_STRING_identification),
        ('string-value', _CHARACTER_STRING_string_value),
        ])
    CHARACTER_STRING._ext = None
    
    #-----< TYPE-IDENTIFIER >-----#
    TYPE_IDENTIFIER = CLASS(name='TYPE-IDENTIFIER', mode=MODE_TYPE)
    _TYPE_IDENTIFIER_id = OID(name='id', mode=MODE_VALUE, uniq=True)
    _TYPE_IDENTIFIER_Type = OPEN(name='Type', mode=MODE_TYPE)
    TYPE_IDENTIFIER._cont = ASN1Dict([
        ('id', _TYPE_IDENTIFIER_id),
        ('Type', _TYPE_IDENTIFIER_Type),
        ])
    
    #-----< ABSTRACT-SYNTAX >-----#
    ABSTRACT_SYNTAX = CLASS(name='ABSTRACT-SYNTAX', mode=MODE_TYPE)
    _ABSTRACT_SYNTAX_id = OID(name='id', mode=MODE_VALUE)
    _ABSTRACT_SYNTAX_Type = OPEN(name='Type', mode=MODE_TYPE)
    _ABSTRACT_SYNTAX_property = BIT_STR(name='property', mode=MODE_VALUE, default=(0, 0))
    _ABSTRACT_SYNTAX_property._cont = ASN1Dict([('handles-invalid-encodings', 0)])
    ABSTRACT_SYNTAX._cont = ASN1Dict([
        ('id', _ABSTRACT_SYNTAX_id),
        ('Type', _ABSTRACT_SYNTAX_Type),
        ('property', _ABSTRACT_SYNTAX_property),
        ])
    
    _all_ = [
        _REAL_mantissa,
        _REAL_base,
        _REAL_exponent,
        REAL,
        ___EXTERNAL_identification_syntaxes_abstract,
        ___EXTERNAL_identification_syntaxes_transfer,
        __EXTERNAL_identification_syntaxes,
        __EXTERNAL_identification_syntax,
        __EXTERNAL_identification_presentation_context_id,
        ___EXTERNAL_identification_context_negotiation_presentation_context_id,
        ___EXTERNAL_identification_context_negotiation_transfer_syntax,
        __EXTERNAL_identification_context_negotiation,
        __EXTERNAL_identification_transfer_syntax,
        __EXTERNAL_identification_fixed,
        _EXTERNAL_identification,
        _EXTERNAL_data_value_descriptor,
        _EXTERNAL_data_value,
        EXTERNAL,
        ___EMBEDDED_PDV_identification_syntaxes_abstract,
        ___EMBEDDED_PDV_identification_syntaxes_transfer,
        __EMBEDDED_PDV_identification_syntaxes,
        __EMBEDDED_PDV_identification_syntax,
        __EMBEDDED_PDV_identification_presentation_context_id,
        ___EMBEDDED_PDV_identification_context_negotiation_presentation_context_id,
        ___EMBEDDED_PDV_identification_context_negotiation_transfer_syntax,
        __EMBEDDED_PDV_identification_context_negotiation,
        __EMBEDDED_PDV_identification_transfer_syntax,
        __EMBEDDED_PDV_identification_fixed,
        _EMBEDDED_PDV_identification,
        _EMBEDDED_PDV_data_value_descriptor,
        _EMBEDDED_PDV_data_value,
        EMBEDDED_PDV,
        ___CHARACTER_STRING_identification_syntaxes_abstract,
        ___CHARACTER_STRING_identification_syntaxes_transfer,
        __CHARACTER_STRING_identification_syntaxes,
        __CHARACTER_STRING_identification_syntax,
        __CHARACTER_STRING_identification_presentation_context_id,
        ___CHARACTER_STRING_identification_context_negotiation_presentation_context_id,
        ___CHARACTER_STRING_identification_context_negotiation_transfer_syntax,
        __CHARACTER_STRING_identification_context_negotiation,
        __CHARACTER_STRING_identification_transfer_syntax,
        __CHARACTER_STRING_identification_fixed,
        _CHARACTER_STRING_identification,
        _CHARACTER_STRING_string_value,
        CHARACTER_STRING,
        _TYPE_IDENTIFIER_id,
        _TYPE_IDENTIFIER_Type,
        TYPE_IDENTIFIER,
        _ABSTRACT_SYNTAX_id,
        _ABSTRACT_SYNTAX_Type,
        _ABSTRACT_SYNTAX_property,
        ABSTRACT_SYNTAX,
    ]

init_modules(AlgorithmInformation_2009, AsymmetricKeyPackageModuleV1, AttributeCertificateVersion1_2009, CryptographicMessageSyntax_2009, CryptographicMessageSyntaxAlgorithms_2009, PKIX1Explicit_2009, PKIX1Implicit_2009, PKIX1_PSS_OAEP_Algorithms_2009, PKIXAlgs_2009, PKIXAttributeCertificate_2009, PKIX_CommonTypes_2009, PKIX_X400Address_2009, SecureMimeMessageV3dot1_2009, _IMPL_)
