# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class DialoguePDUs:

    _name_  = u'DialoguePDUs'
    _oid_   = [0, 0, 17, 773, 2, 2, 1]
    
    _obj_ = [
        u'dialogue-as-id',
        u'DialoguePDU',
        u'AARQ-apdu',
        u'AARE-apdu',
        u'RLRQ-apdu',
        u'RLRE-apdu',
        u'ABRT-apdu',
        u'ABRT-source',
        u'Associate-result',
        u'Associate-source-diagnostic',
        u'Release-request-reason',
        u'Release-response-reason',
        ]
    _type_ = [
        u'DialoguePDU',
        u'AARQ-apdu',
        u'AARE-apdu',
        u'RLRQ-apdu',
        u'RLRE-apdu',
        u'ABRT-apdu',
        u'ABRT-source',
        u'Associate-result',
        u'Associate-source-diagnostic',
        u'Release-request-reason',
        u'Release-response-reason',
        ]
    _set_ = [
        ]
    _val_ = [
        u'dialogue-as-id',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< dialogue-as-id >-----#
    dialogue_as_id = OID(name=u'dialogue-as-id', mode=MODE_VALUE)
    dialogue_as_id._val = (0, 0, 17, 773, 1, 1, 1)
    
    #-----< DialoguePDU >-----#
    DialoguePDU = CHOICE(name=u'DialoguePDU', mode=MODE_TYPE)
    _DialoguePDU_dialogueRequest = SEQ(name=u'dialogueRequest', mode=MODE_TYPE, typeref=ASN1RefType(('DialoguePDUs', 'AARQ-apdu')))
    _DialoguePDU_dialogueResponse = SEQ(name=u'dialogueResponse', mode=MODE_TYPE, typeref=ASN1RefType(('DialoguePDUs', 'AARE-apdu')))
    _DialoguePDU_dialogueAbort = SEQ(name=u'dialogueAbort', mode=MODE_TYPE, typeref=ASN1RefType(('DialoguePDUs', 'ABRT-apdu')))
    DialoguePDU._cont = ASN1Dict([
        (u'dialogueRequest', _DialoguePDU_dialogueRequest),
        (u'dialogueResponse', _DialoguePDU_dialogueResponse),
        (u'dialogueAbort', _DialoguePDU_dialogueAbort),
        ])
    DialoguePDU._ext = None
    
    #-----< AARQ-apdu >-----#
    AARQ_apdu = SEQ(name=u'AARQ-apdu', mode=MODE_TYPE, tag=(0, TAG_APPLICATION, TAG_IMPLICIT))
    _AARQ_apdu_protocol_version = BIT_STR(name=u'protocol-version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=(1, 1))
    _AARQ_apdu_protocol_version._cont = ASN1Dict([(u'version1', 0)])
    _AARQ_apdu_application_context_name = OID(name=u'application-context-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AARQ_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __AARQ_apdu_user_information__item_ = EXT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    _AARQ_apdu_user_information._cont = __AARQ_apdu_user_information__item_
    AARQ_apdu._cont = ASN1Dict([
        (u'protocol-version', _AARQ_apdu_protocol_version),
        (u'application-context-name', _AARQ_apdu_application_context_name),
        (u'user-information', _AARQ_apdu_user_information),
        ])
    AARQ_apdu._ext = None
    
    #-----< AARE-apdu >-----#
    AARE_apdu = SEQ(name=u'AARE-apdu', mode=MODE_TYPE, tag=(1, TAG_APPLICATION, TAG_IMPLICIT))
    _AARE_apdu_protocol_version = BIT_STR(name=u'protocol-version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=(1, 1))
    _AARE_apdu_protocol_version._cont = ASN1Dict([(u'version1', 0)])
    _AARE_apdu_application_context_name = OID(name=u'application-context-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AARE_apdu_result = INT(name=u'result', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DialoguePDUs', 'Associate-result')))
    _AARE_apdu_result_source_diagnostic = CHOICE(name=u'result-source-diagnostic', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DialoguePDUs', 'Associate-source-diagnostic')))
    _AARE_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __AARE_apdu_user_information__item_ = EXT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    _AARE_apdu_user_information._cont = __AARE_apdu_user_information__item_
    AARE_apdu._cont = ASN1Dict([
        (u'protocol-version', _AARE_apdu_protocol_version),
        (u'application-context-name', _AARE_apdu_application_context_name),
        (u'result', _AARE_apdu_result),
        (u'result-source-diagnostic', _AARE_apdu_result_source_diagnostic),
        (u'user-information', _AARE_apdu_user_information),
        ])
    AARE_apdu._ext = None
    
    #-----< RLRQ-apdu >-----#
    RLRQ_apdu = SEQ(name=u'RLRQ-apdu', mode=MODE_TYPE, tag=(2, TAG_APPLICATION, TAG_IMPLICIT))
    _RLRQ_apdu_reason = INT(name=u'reason', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('DialoguePDUs', 'Release-request-reason')), opt=True)
    _RLRQ_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RLRQ_apdu_user_information__item_ = EXT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    _RLRQ_apdu_user_information._cont = __RLRQ_apdu_user_information__item_
    RLRQ_apdu._cont = ASN1Dict([
        (u'reason', _RLRQ_apdu_reason),
        (u'user-information', _RLRQ_apdu_user_information),
        ])
    RLRQ_apdu._ext = None
    
    #-----< RLRE-apdu >-----#
    RLRE_apdu = SEQ(name=u'RLRE-apdu', mode=MODE_TYPE, tag=(3, TAG_APPLICATION, TAG_IMPLICIT))
    _RLRE_apdu_reason = INT(name=u'reason', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('DialoguePDUs', 'Release-response-reason')), opt=True)
    _RLRE_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __RLRE_apdu_user_information__item_ = EXT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    _RLRE_apdu_user_information._cont = __RLRE_apdu_user_information__item_
    RLRE_apdu._cont = ASN1Dict([
        (u'reason', _RLRE_apdu_reason),
        (u'user-information', _RLRE_apdu_user_information),
        ])
    RLRE_apdu._ext = None
    
    #-----< ABRT-apdu >-----#
    ABRT_apdu = SEQ(name=u'ABRT-apdu', mode=MODE_TYPE, tag=(4, TAG_APPLICATION, TAG_IMPLICIT))
    _ABRT_apdu_abort_source = INT(name=u'abort-source', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('DialoguePDUs', 'ABRT-source')))
    _ABRT_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ABRT_apdu_user_information__item_ = EXT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    _ABRT_apdu_user_information._cont = __ABRT_apdu_user_information__item_
    ABRT_apdu._cont = ASN1Dict([
        (u'abort-source', _ABRT_apdu_abort_source),
        (u'user-information', _ABRT_apdu_user_information),
        ])
    ABRT_apdu._ext = None
    
    #-----< ABRT-source >-----#
    ABRT_source = INT(name=u'ABRT-source', mode=MODE_TYPE)
    ABRT_source._cont = ASN1Dict([(u'dialogue-service-user', 0), (u'dialogue-service-provider', 1)])
    
    #-----< Associate-result >-----#
    Associate_result = INT(name=u'Associate-result', mode=MODE_TYPE)
    Associate_result._cont = ASN1Dict([(u'accepted', 0), (u'reject-permanent', 1)])
    
    #-----< Associate-source-diagnostic >-----#
    Associate_source_diagnostic = CHOICE(name=u'Associate-source-diagnostic', mode=MODE_TYPE)
    _Associate_source_diagnostic_dialogue_service_user = INT(name=u'dialogue-service-user', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _Associate_source_diagnostic_dialogue_service_user._cont = ASN1Dict([(u'null', 0), (u'no-reason-given', 1), (u'application-context-name-not-supported', 2)])
    _Associate_source_diagnostic_dialogue_service_provider = INT(name=u'dialogue-service-provider', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _Associate_source_diagnostic_dialogue_service_provider._cont = ASN1Dict([(u'null', 0), (u'no-reason-given', 1), (u'no-common-dialogue-portion', 2)])
    Associate_source_diagnostic._cont = ASN1Dict([
        (u'dialogue-service-user', _Associate_source_diagnostic_dialogue_service_user),
        (u'dialogue-service-provider', _Associate_source_diagnostic_dialogue_service_provider),
        ])
    Associate_source_diagnostic._ext = None
    
    #-----< Release-request-reason >-----#
    Release_request_reason = INT(name=u'Release-request-reason', mode=MODE_TYPE)
    Release_request_reason._cont = ASN1Dict([(u'normal', 0), (u'urgent', 1), (u'user-defined', 30)])
    
    #-----< Release-response-reason >-----#
    Release_response_reason = INT(name=u'Release-response-reason', mode=MODE_TYPE)
    Release_response_reason._cont = ASN1Dict([(u'normal', 0), (u'not-finished', 1), (u'user-defined', 30)])
    
    _all_ = [
        dialogue_as_id,
        _DialoguePDU_dialogueRequest,
        _DialoguePDU_dialogueResponse,
        _DialoguePDU_dialogueAbort,
        DialoguePDU,
        _AARQ_apdu_protocol_version,
        _AARQ_apdu_application_context_name,
        __AARQ_apdu_user_information__item_,
        _AARQ_apdu_user_information,
        AARQ_apdu,
        _AARE_apdu_protocol_version,
        _AARE_apdu_application_context_name,
        _AARE_apdu_result,
        _AARE_apdu_result_source_diagnostic,
        __AARE_apdu_user_information__item_,
        _AARE_apdu_user_information,
        AARE_apdu,
        _RLRQ_apdu_reason,
        __RLRQ_apdu_user_information__item_,
        _RLRQ_apdu_user_information,
        RLRQ_apdu,
        _RLRE_apdu_reason,
        __RLRE_apdu_user_information__item_,
        _RLRE_apdu_user_information,
        RLRE_apdu,
        _ABRT_apdu_abort_source,
        __ABRT_apdu_user_information__item_,
        _ABRT_apdu_user_information,
        ABRT_apdu,
        ABRT_source,
        Associate_result,
        _Associate_source_diagnostic_dialogue_service_user,
        _Associate_source_diagnostic_dialogue_service_provider,
        Associate_source_diagnostic,
        Release_request_reason,
        Release_response_reason,
    ]

class UnidialoguePDUs:

    _name_  = u'UnidialoguePDUs'
    _oid_   = [0, 0, 17, 773, 2, 3, 1]
    
    _obj_ = [
        u'uniDialogue-as-id',
        u'UniDialoguePDU',
        u'AUDT-apdu',
        ]
    _type_ = [
        u'UniDialoguePDU',
        u'AUDT-apdu',
        ]
    _set_ = [
        ]
    _val_ = [
        u'uniDialogue-as-id',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< uniDialogue-as-id >-----#
    uniDialogue_as_id = OID(name=u'uniDialogue-as-id', mode=MODE_VALUE)
    uniDialogue_as_id._val = (0, 0, 17, 773, 1, 2, 1)
    
    #-----< UniDialoguePDU >-----#
    UniDialoguePDU = CHOICE(name=u'UniDialoguePDU', mode=MODE_TYPE)
    _UniDialoguePDU_unidialoguePDU = SEQ(name=u'unidialoguePDU', mode=MODE_TYPE, typeref=ASN1RefType(('UnidialoguePDUs', 'AUDT-apdu')))
    UniDialoguePDU._cont = ASN1Dict([
        (u'unidialoguePDU', _UniDialoguePDU_unidialoguePDU),
        ])
    UniDialoguePDU._ext = None
    
    #-----< AUDT-apdu >-----#
    AUDT_apdu = SEQ(name=u'AUDT-apdu', mode=MODE_TYPE, tag=(0, TAG_APPLICATION, TAG_IMPLICIT))
    _AUDT_apdu_protocol_version = BIT_STR(name=u'protocol-version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=(1, 1))
    _AUDT_apdu_protocol_version._cont = ASN1Dict([(u'version1', 0)])
    _AUDT_apdu_application_context_name = OID(name=u'application-context-name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _AUDT_apdu_user_information = SEQ_OF(name=u'user-information', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __AUDT_apdu_user_information__item_ = EXT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    _AUDT_apdu_user_information._cont = __AUDT_apdu_user_information__item_
    AUDT_apdu._cont = ASN1Dict([
        (u'protocol-version', _AUDT_apdu_protocol_version),
        (u'application-context-name', _AUDT_apdu_application_context_name),
        (u'user-information', _AUDT_apdu_user_information),
        ])
    AUDT_apdu._ext = None
    
    _all_ = [
        uniDialogue_as_id,
        _UniDialoguePDU_unidialoguePDU,
        UniDialoguePDU,
        _AUDT_apdu_protocol_version,
        _AUDT_apdu_application_context_name,
        __AUDT_apdu_user_information__item_,
        _AUDT_apdu_user_information,
        AUDT_apdu,
    ]

class Remote_Operations_Information_Objects:

    _name_  = u'Remote-Operations-Information-Objects'
    _oid_   = [2, 4, 5, 0]
    
    _obj_ = [
        u'OPERATION',
        u'ERROR',
        u'OPERATION-PACKAGE',
        u'CONNECTION-PACKAGE',
        u'CONTRACT',
        u'ROS-OBJECT-CLASS',
        u'Code',
        u'Priority',
        ]
    _type_ = [
        u'OPERATION',
        u'ERROR',
        u'OPERATION-PACKAGE',
        u'CONNECTION-PACKAGE',
        u'CONTRACT',
        u'ROS-OBJECT-CLASS',
        u'Code',
        u'Priority',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        u'OPERATION',
        u'ERROR',
        u'OPERATION-PACKAGE',
        u'CONNECTION-PACKAGE',
        u'CONTRACT',
        u'ROS-OBJECT-CLASS',
        ]
    _param_ = [
        ]
    
    #-----< OPERATION >-----#
    OPERATION = CLASS(name=u'OPERATION', mode=MODE_TYPE)
    _OPERATION_ArgumentType = OPEN(name=u'ArgumentType', mode=MODE_TYPE, opt=True)
    _OPERATION_argumentTypeOptional = BOOL(name=u'argumentTypeOptional', mode=MODE_VALUE, opt=True)
    _OPERATION_returnResult = BOOL(name=u'returnResult', mode=MODE_VALUE, default=True)
    _OPERATION_ResultType = OPEN(name=u'ResultType', mode=MODE_TYPE, opt=True)
    _OPERATION_resultTypeOptional = BOOL(name=u'resultTypeOptional', mode=MODE_VALUE, opt=True)
    _OPERATION_Errors = CLASS(name=u'Errors', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')), opt=True)
    _OPERATION_Linked = CLASS(name=u'Linked', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_synchronous = BOOL(name=u'synchronous', mode=MODE_VALUE, default=False)
    _OPERATION_alwaysReturns = BOOL(name=u'alwaysReturns', mode=MODE_VALUE, default=True)
    _OPERATION_InvokePriority = INT(name=u'InvokePriority', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Priority')), opt=True)
    _OPERATION_ResultPriority = INT(name=u'ResultPriority', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Priority')), opt=True)
    _OPERATION_operationCode = CHOICE(name=u'operationCode', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')), opt=True, uniq=True)
    OPERATION._cont = ASN1Dict([
        (u'ArgumentType', _OPERATION_ArgumentType),
        (u'argumentTypeOptional', _OPERATION_argumentTypeOptional),
        (u'returnResult', _OPERATION_returnResult),
        (u'ResultType', _OPERATION_ResultType),
        (u'resultTypeOptional', _OPERATION_resultTypeOptional),
        (u'Errors', _OPERATION_Errors),
        (u'Linked', _OPERATION_Linked),
        (u'synchronous', _OPERATION_synchronous),
        (u'alwaysReturns', _OPERATION_alwaysReturns),
        (u'InvokePriority', _OPERATION_InvokePriority),
        (u'ResultPriority', _OPERATION_ResultPriority),
        (u'operationCode', _OPERATION_operationCode),
        ])
    
    #-----< ERROR >-----#
    ERROR = CLASS(name=u'ERROR', mode=MODE_TYPE)
    _ERROR_ParameterType = OPEN(name=u'ParameterType', mode=MODE_TYPE, opt=True)
    _ERROR_parameterTypeOptional = BOOL(name=u'parameterTypeOptional', mode=MODE_VALUE, opt=True)
    _ERROR_ErrorPriority = INT(name=u'ErrorPriority', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Priority')), opt=True)
    _ERROR_errorCode = CHOICE(name=u'errorCode', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')), opt=True, uniq=True)
    ERROR._cont = ASN1Dict([
        (u'ParameterType', _ERROR_ParameterType),
        (u'parameterTypeOptional', _ERROR_parameterTypeOptional),
        (u'ErrorPriority', _ERROR_ErrorPriority),
        (u'errorCode', _ERROR_errorCode),
        ])
    
    #-----< OPERATION-PACKAGE >-----#
    OPERATION_PACKAGE = CLASS(name=u'OPERATION-PACKAGE', mode=MODE_TYPE)
    _OPERATION_PACKAGE_Both = CLASS(name=u'Both', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_PACKAGE_Consumer = CLASS(name=u'Consumer', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_PACKAGE_Supplier = CLASS(name=u'Supplier', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), opt=True)
    _OPERATION_PACKAGE_id = OID(name=u'id', mode=MODE_VALUE, opt=True, uniq=True)
    OPERATION_PACKAGE._cont = ASN1Dict([
        (u'Both', _OPERATION_PACKAGE_Both),
        (u'Consumer', _OPERATION_PACKAGE_Consumer),
        (u'Supplier', _OPERATION_PACKAGE_Supplier),
        (u'id', _OPERATION_PACKAGE_id),
        ])
    
    #-----< CONNECTION-PACKAGE >-----#
    CONNECTION_PACKAGE = CLASS(name=u'CONNECTION-PACKAGE', mode=MODE_TYPE)
    _CONNECTION_PACKAGE_bind = CLASS(name=u'bind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), default=dict([(u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', -1))])], rr=[], ev=None, er=[])), (u'synchronous', True)]))
    _CONNECTION_PACKAGE_unbind = CLASS(name=u'unbind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), default=dict([(u'synchronous', True)]))
    _CONNECTION_PACKAGE_responderCanUnbind = BOOL(name=u'responderCanUnbind', mode=MODE_VALUE, default=False)
    _CONNECTION_PACKAGE_unbindCanFail = BOOL(name=u'unbindCanFail', mode=MODE_VALUE, default=False)
    _CONNECTION_PACKAGE_id = OID(name=u'id', mode=MODE_VALUE, opt=True, uniq=True)
    CONNECTION_PACKAGE._cont = ASN1Dict([
        (u'bind', _CONNECTION_PACKAGE_bind),
        (u'unbind', _CONNECTION_PACKAGE_unbind),
        (u'responderCanUnbind', _CONNECTION_PACKAGE_responderCanUnbind),
        (u'unbindCanFail', _CONNECTION_PACKAGE_unbindCanFail),
        (u'id', _CONNECTION_PACKAGE_id),
        ])
    
    #-----< CONTRACT >-----#
    CONTRACT = CLASS(name=u'CONTRACT', mode=MODE_TYPE)
    _CONTRACT_connection = CLASS(name=u'connection', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONNECTION-PACKAGE')), opt=True)
    _CONTRACT_OperationsOf = CLASS(name=u'OperationsOf', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), opt=True)
    _CONTRACT_InitiatorConsumerOf = CLASS(name=u'InitiatorConsumerOf', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), opt=True)
    _CONTRACT_InitiatorSupplierOf = CLASS(name=u'InitiatorSupplierOf', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), opt=True)
    _CONTRACT_id = OID(name=u'id', mode=MODE_VALUE, opt=True, uniq=True)
    CONTRACT._cont = ASN1Dict([
        (u'connection', _CONTRACT_connection),
        (u'OperationsOf', _CONTRACT_OperationsOf),
        (u'InitiatorConsumerOf', _CONTRACT_InitiatorConsumerOf),
        (u'InitiatorSupplierOf', _CONTRACT_InitiatorSupplierOf),
        (u'id', _CONTRACT_id),
        ])
    
    #-----< ROS-OBJECT-CLASS >-----#
    ROS_OBJECT_CLASS = CLASS(name=u'ROS-OBJECT-CLASS', mode=MODE_TYPE)
    _ROS_OBJECT_CLASS_Is = CLASS(name=u'Is', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ROS-OBJECT-CLASS')), opt=True)
    _ROS_OBJECT_CLASS_Initiates = CLASS(name=u'Initiates', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONTRACT')), opt=True)
    _ROS_OBJECT_CLASS_Responds = CLASS(name=u'Responds', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONTRACT')), opt=True)
    _ROS_OBJECT_CLASS_InitiatesAndResponds = CLASS(name=u'InitiatesAndResponds', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONTRACT')), opt=True)
    _ROS_OBJECT_CLASS_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    ROS_OBJECT_CLASS._cont = ASN1Dict([
        (u'Is', _ROS_OBJECT_CLASS_Is),
        (u'Initiates', _ROS_OBJECT_CLASS_Initiates),
        (u'Responds', _ROS_OBJECT_CLASS_Responds),
        (u'InitiatesAndResponds', _ROS_OBJECT_CLASS_InitiatesAndResponds),
        (u'id', _ROS_OBJECT_CLASS_id),
        ])
    
    #-----< Code >-----#
    Code = CHOICE(name=u'Code', mode=MODE_TYPE)
    _Code_local = INT(name=u'local', mode=MODE_TYPE)
    _Code_global_ = OID(name=u'global', mode=MODE_TYPE)
    Code._cont = ASN1Dict([
        (u'local', _Code_local),
        (u'global', _Code_global_),
        ])
    Code._ext = None
    
    #-----< Priority >-----#
    Priority = INT(name=u'Priority', mode=MODE_TYPE)
    Priority._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    _all_ = [
        _OPERATION_ArgumentType,
        _OPERATION_argumentTypeOptional,
        _OPERATION_returnResult,
        _OPERATION_ResultType,
        _OPERATION_resultTypeOptional,
        _OPERATION_Errors,
        _OPERATION_Linked,
        _OPERATION_synchronous,
        _OPERATION_alwaysReturns,
        _OPERATION_InvokePriority,
        _OPERATION_ResultPriority,
        _OPERATION_operationCode,
        OPERATION,
        _ERROR_ParameterType,
        _ERROR_parameterTypeOptional,
        _ERROR_ErrorPriority,
        _ERROR_errorCode,
        ERROR,
        _OPERATION_PACKAGE_Both,
        _OPERATION_PACKAGE_Consumer,
        _OPERATION_PACKAGE_Supplier,
        _OPERATION_PACKAGE_id,
        OPERATION_PACKAGE,
        _CONNECTION_PACKAGE_bind,
        _CONNECTION_PACKAGE_unbind,
        _CONNECTION_PACKAGE_responderCanUnbind,
        _CONNECTION_PACKAGE_unbindCanFail,
        _CONNECTION_PACKAGE_id,
        CONNECTION_PACKAGE,
        _CONTRACT_connection,
        _CONTRACT_OperationsOf,
        _CONTRACT_InitiatorConsumerOf,
        _CONTRACT_InitiatorSupplierOf,
        _CONTRACT_id,
        CONTRACT,
        _ROS_OBJECT_CLASS_Is,
        _ROS_OBJECT_CLASS_Initiates,
        _ROS_OBJECT_CLASS_Responds,
        _ROS_OBJECT_CLASS_InitiatesAndResponds,
        _ROS_OBJECT_CLASS_id,
        ROS_OBJECT_CLASS,
        _Code_local,
        _Code_global_,
        Code,
        Priority,
    ]

class Remote_Operations_Generic_ROS_PDUs:

    _name_  = u'Remote-Operations-Generic-ROS-PDUs'
    _oid_   = [2, 4, 6, 0]
    
    _obj_ = [
        u'ROS',
        u'Invoke',
        u'ReturnResult',
        u'ReturnError',
        u'Reject',
        u'GeneralProblem',
        u'InvokeProblem',
        u'ReturnResultProblem',
        u'ReturnErrorProblem',
        u'RejectProblem',
        u'InvokeId',
        u'noInvokeId',
        u'NoInvokeId',
        u'Errors',
        u'Bind',
        u'Unbind',
        ]
    _type_ = [
        u'ROS',
        u'Invoke',
        u'ReturnResult',
        u'ReturnError',
        u'Reject',
        u'GeneralProblem',
        u'InvokeProblem',
        u'ReturnResultProblem',
        u'ReturnErrorProblem',
        u'RejectProblem',
        u'InvokeId',
        u'Bind',
        u'Unbind',
        ]
    _set_ = [
        u'NoInvokeId',
        u'Errors',
        ]
    _val_ = [
        u'noInvokeId',
        ]
    _class_ = [
        u'Errors',
        ]
    _param_ = [
        u'ROS',
        u'Invoke',
        u'ReturnResult',
        u'ReturnError',
        u'Errors',
        u'Bind',
        u'Unbind',
        ]
    
    #-----< ROS >-----#
    ROS = CHOICE(name=u'ROS', mode=MODE_TYPE, param=True)
    
    #-----< Invoke >-----#
    Invoke = SEQ(name=u'Invoke', mode=MODE_TYPE, param=True)
    
    #-----< ReturnResult >-----#
    ReturnResult = SEQ(name=u'ReturnResult', mode=MODE_TYPE, param=True)
    
    #-----< ReturnError >-----#
    ReturnError = SEQ(name=u'ReturnError', mode=MODE_TYPE, param=True)
    
    #-----< Reject >-----#
    Reject = SEQ(name=u'Reject', mode=MODE_TYPE)
    _Reject_invokeId = CHOICE(name=u'invokeId', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    _Reject_problem = CHOICE(name=u'problem', mode=MODE_TYPE)
    __Reject_problem_general = INT(name=u'general', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'GeneralProblem')))
    __Reject_problem_invoke = INT(name=u'invoke', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeProblem')))
    __Reject_problem_returnResult = INT(name=u'returnResult', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnResultProblem')))
    __Reject_problem_returnError = INT(name=u'returnError', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ReturnErrorProblem')))
    _Reject_problem._cont = ASN1Dict([
        (u'general', __Reject_problem_general),
        (u'invoke', __Reject_problem_invoke),
        (u'returnResult', __Reject_problem_returnResult),
        (u'returnError', __Reject_problem_returnError),
        ])
    _Reject_problem._ext = None
    Reject._cont = ASN1Dict([
        (u'invokeId', _Reject_invokeId),
        (u'problem', _Reject_problem),
        ])
    Reject._ext = None
    
    #-----< GeneralProblem >-----#
    GeneralProblem = INT(name=u'GeneralProblem', mode=MODE_TYPE)
    GeneralProblem._cont = ASN1Dict([(u'unrecognizedPDU', 0), (u'mistypedPDU', 1), (u'badlyStructuredPDU', 2)])
    
    #-----< InvokeProblem >-----#
    InvokeProblem = INT(name=u'InvokeProblem', mode=MODE_TYPE)
    InvokeProblem._cont = ASN1Dict([(u'duplicateInvocation', 0), (u'unrecognizedOperation', 1), (u'mistypedArgument', 2), (u'resourceLimitation', 3), (u'releaseInProgress', 4), (u'unrecognizedLinkedId', 5), (u'linkedResponseUnexpected', 6), (u'unexpectedLinkedOperation', 7)])
    
    #-----< ReturnResultProblem >-----#
    ReturnResultProblem = INT(name=u'ReturnResultProblem', mode=MODE_TYPE)
    ReturnResultProblem._cont = ASN1Dict([(u'unrecognizedInvocation', 0), (u'resultResponseUnexpected', 1), (u'mistypedResult', 2)])
    
    #-----< ReturnErrorProblem >-----#
    ReturnErrorProblem = INT(name=u'ReturnErrorProblem', mode=MODE_TYPE)
    ReturnErrorProblem._cont = ASN1Dict([(u'unrecognizedInvocation', 0), (u'errorResponseUnexpected', 1), (u'unrecognizedError', 2), (u'unexpectedError', 3), (u'mistypedParameter', 4)])
    
    #-----< RejectProblem >-----#
    RejectProblem = INT(name=u'RejectProblem', mode=MODE_TYPE)
    RejectProblem._cont = ASN1Dict([(u'general-unrecognizedPDU', 0), (u'general-mistypedPDU', 1), (u'general-badlyStructuredPDU', 2), (u'invoke-duplicateInvocation', 10), (u'invoke-unrecognizedOperation', 11), (u'invoke-mistypedArgument', 12), (u'invoke-resourceLimitation', 13), (u'invoke-releaseInProgress', 14), (u'invoke-unrecognizedLinkedId', 15), (u'invoke-linkedResponseUnexpected', 16), (u'invoke-unexpectedLinkedOperation', 17), (u'returnResult-unrecognizedInvocation', 20), (u'returnResult-resultResponseUnexpected', 21), (u'returnResult-mistypedResult', 22), (u'returnError-unrecognizedInvocation', 30), (u'returnError-errorResponseUnexpected', 31), (u'returnError-unrecognizedError', 32), (u'returnError-unexpectedError', 33), (u'returnError-mistypedParameter', 34)])
    
    #-----< InvokeId >-----#
    InvokeId = CHOICE(name=u'InvokeId', mode=MODE_TYPE)
    _InvokeId_present = INT(name=u'present', mode=MODE_TYPE)
    _InvokeId_absent = NULL(name=u'absent', mode=MODE_TYPE)
    InvokeId._cont = ASN1Dict([
        (u'present', _InvokeId_present),
        (u'absent', _InvokeId_absent),
        ])
    InvokeId._ext = None
    
    #-----< noInvokeId >-----#
    noInvokeId = CHOICE(name=u'noInvokeId', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    noInvokeId._val = (u'absent', 0)
    
    #-----< NoInvokeId >-----#
    NoInvokeId = CHOICE(name=u'NoInvokeId', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    NoInvokeId._val = ASN1Set(rv=[(u'absent', 0)], rr=[], ev=None, er=[])
    
    #-----< Errors >-----#
    Errors = CLASS(name=u'Errors', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')), param=True)
    
    #-----< Bind >-----#
    Bind = CHOICE(name=u'Bind', mode=MODE_TYPE, param=True)
    
    #-----< Unbind >-----#
    Unbind = CHOICE(name=u'Unbind', mode=MODE_TYPE, param=True)
    
    _all_ = [
        _Reject_invokeId,
        __Reject_problem_general,
        __Reject_problem_invoke,
        __Reject_problem_returnResult,
        __Reject_problem_returnError,
        _Reject_problem,
        Reject,
        GeneralProblem,
        InvokeProblem,
        ReturnResultProblem,
        ReturnErrorProblem,
        RejectProblem,
        _InvokeId_present,
        _InvokeId_absent,
        InvokeId,
        noInvokeId,
        NoInvokeId,
    ]

class Remote_Operations_Useful_Definitions:

    _name_  = u'Remote-Operations-Useful-Definitions'
    _oid_   = [2, 4, 7, 0]
    
    _obj_ = [
        u'emptyBind',
        u'emptyUnbind',
        u'refuse',
        u'no-op',
        u'Forward',
        u'Reverse',
        u'ConsumerPerforms',
        u'SupplierPerforms',
        u'AllOperations',
        u'recode',
        u'switch',
        u'combine',
        u'ROS-SingleAS',
        u'ROS-ConsumerAS',
        u'ROS-SupplierAS',
        ]
    _type_ = [
        u'ROS-SingleAS',
        u'ROS-ConsumerAS',
        u'ROS-SupplierAS',
        ]
    _set_ = [
        u'Forward',
        u'Reverse',
        u'ConsumerPerforms',
        u'SupplierPerforms',
        u'AllOperations',
        ]
    _val_ = [
        u'emptyBind',
        u'emptyUnbind',
        u'refuse',
        u'no-op',
        u'recode',
        u'switch',
        u'combine',
        ]
    _class_ = [
        u'emptyBind',
        u'emptyUnbind',
        u'refuse',
        u'no-op',
        u'Forward',
        u'Reverse',
        u'ConsumerPerforms',
        u'SupplierPerforms',
        u'AllOperations',
        u'recode',
        u'switch',
        u'combine',
        ]
    _param_ = [
        u'Forward',
        u'Reverse',
        u'ConsumerPerforms',
        u'SupplierPerforms',
        u'AllOperations',
        u'recode',
        u'switch',
        u'combine',
        u'ROS-SingleAS',
        u'ROS-ConsumerAS',
        u'ROS-SupplierAS',
        ]
    
    #-----< emptyBind >-----#
    emptyBind = CLASS(name=u'emptyBind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    emptyBind._val = dict([(u'Errors', ASN1Set(rv=[dict([(u'errorCode', (u'local', -1))])], rr=[], ev=None, er=[])), (u'synchronous', True)])
    
    #-----< emptyUnbind >-----#
    emptyUnbind = CLASS(name=u'emptyUnbind', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    emptyUnbind._val = dict([(u'synchronous', True)])
    
    #-----< refuse >-----#
    refuse = CLASS(name=u'refuse', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    refuse._val = dict([(u'errorCode', (u'local', -1))])
    
    #-----< no-op >-----#
    no_op = CLASS(name=u'no-op', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')))
    no_op._val = dict([(u'alwaysReturns', False), (u'operationCode', (u'local', -1))])
    
    #-----< Forward >-----#
    Forward = CLASS(name=u'Forward', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), param=True)
    
    #-----< Reverse >-----#
    Reverse = CLASS(name=u'Reverse', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), param=True)
    
    #-----< ConsumerPerforms >-----#
    ConsumerPerforms = CLASS(name=u'ConsumerPerforms', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), param=True)
    
    #-----< SupplierPerforms >-----#
    SupplierPerforms = CLASS(name=u'SupplierPerforms', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), param=True)
    
    #-----< AllOperations >-----#
    AllOperations = CLASS(name=u'AllOperations', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), param=True)
    
    #-----< recode >-----#
    recode = CLASS(name=u'recode', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION')), param=True)
    
    #-----< switch >-----#
    switch = CLASS(name=u'switch', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), param=True)
    
    #-----< combine >-----#
    combine = CLASS(name=u'combine', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'OPERATION-PACKAGE')), param=True)
    
    #-----< ROS-SingleAS >-----#
    ROS_SingleAS = CHOICE(name=u'ROS-SingleAS', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ROS')), param=True)
    
    #-----< ROS-ConsumerAS >-----#
    ROS_ConsumerAS = CHOICE(name=u'ROS-ConsumerAS', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ROS')), param=True)
    
    #-----< ROS-SupplierAS >-----#
    ROS_SupplierAS = CHOICE(name=u'ROS-SupplierAS', mode=MODE_TYPE, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'ROS')), param=True)
    
    _all_ = [
        emptyBind,
        emptyUnbind,
        refuse,
        no_op,
    ]

class TCAPMessages:

    _name_  = u'TCAPMessages'
    _oid_   = [0, 0, 17, 773, 2, 1, 3]
    
    _obj_ = [
        u'TCMessage',
        u'Unidirectional',
        u'Begin',
        u'End',
        u'Continue',
        u'Abort',
        u'DialoguePortion',
        u'OrigTransactionID',
        u'DestTransactionID',
        u'P-AbortCause',
        u'ComponentPortion',
        u'Component',
        u'TCInvokeIdSet',
        ]
    _type_ = [
        u'TCMessage',
        u'Unidirectional',
        u'Begin',
        u'End',
        u'Continue',
        u'Abort',
        u'DialoguePortion',
        u'OrigTransactionID',
        u'DestTransactionID',
        u'P-AbortCause',
        u'ComponentPortion',
        u'Component',
        ]
    _set_ = [
        u'TCInvokeIdSet',
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        u'TCMessage',
        u'Unidirectional',
        u'Begin',
        u'End',
        u'Continue',
        u'ComponentPortion',
        u'Component',
        ]
    
    #-----< TCMessage >-----#
    TCMessage = CHOICE(name=u'TCMessage', mode=MODE_TYPE, param=True)
    
    #-----< Unidirectional >-----#
    Unidirectional = SEQ(name=u'Unidirectional', mode=MODE_TYPE, param=True)
    
    #-----< Begin >-----#
    Begin = SEQ(name=u'Begin', mode=MODE_TYPE, param=True)
    
    #-----< End >-----#
    End = SEQ(name=u'End', mode=MODE_TYPE, param=True)
    
    #-----< Continue >-----#
    Continue = SEQ(name=u'Continue', mode=MODE_TYPE, param=True)
    
    #-----< Abort >-----#
    Abort = SEQ(name=u'Abort', mode=MODE_TYPE)
    _Abort_dtid = OCT_STR(name=u'dtid', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'DestTransactionID')))
    _Abort_reason = CHOICE(name=u'reason', mode=MODE_TYPE, opt=True)
    __Abort_reason_p_abortCause = INT(name=u'p-abortCause', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'P-AbortCause')))
    __Abort_reason_u_abortCause = EXT(name=u'u-abortCause', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'DialoguePortion')))
    _Abort_reason._cont = ASN1Dict([
        (u'p-abortCause', __Abort_reason_p_abortCause),
        (u'u-abortCause', __Abort_reason_u_abortCause),
        ])
    _Abort_reason._ext = None
    Abort._cont = ASN1Dict([
        (u'dtid', _Abort_dtid),
        (u'reason', _Abort_reason),
        ])
    Abort._ext = None
    
    #-----< DialoguePortion >-----#
    DialoguePortion = EXT(name=u'DialoguePortion', mode=MODE_TYPE, tag=(11, TAG_APPLICATION, TAG_EXPLICIT), typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    
    #-----< OrigTransactionID >-----#
    OrigTransactionID = OCT_STR(name=u'OrigTransactionID', mode=MODE_TYPE, tag=(8, TAG_APPLICATION, TAG_IMPLICIT))
    OrigTransactionID._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< DestTransactionID >-----#
    DestTransactionID = OCT_STR(name=u'DestTransactionID', mode=MODE_TYPE, tag=(9, TAG_APPLICATION, TAG_IMPLICIT))
    DestTransactionID._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< P-AbortCause >-----#
    P_AbortCause = INT(name=u'P-AbortCause', mode=MODE_TYPE, tag=(10, TAG_APPLICATION, TAG_IMPLICIT))
    P_AbortCause._cont = ASN1Dict([(u'unrecognizedMessageType', 0), (u'unrecognizedTransactionID', 1), (u'badlyFormattedTransactionPortion', 2), (u'incorrectTransactionPortion', 3), (u'resourceLimitation', 4)])
    P_AbortCause._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    
    #-----< ComponentPortion >-----#
    ComponentPortion = SEQ_OF(name=u'ComponentPortion', mode=MODE_TYPE, tag=(12, TAG_APPLICATION, TAG_IMPLICIT), param=True)
    
    #-----< Component >-----#
    Component = CHOICE(name=u'Component', mode=MODE_TYPE, param=True)
    
    #-----< TCInvokeIdSet >-----#
    TCInvokeIdSet = CHOICE(name=u'TCInvokeIdSet', mode=MODE_SET, typeref=ASN1RefType(('Remote-Operations-Generic-ROS-PDUs', 'InvokeId')))
    TCInvokeIdSet._val = ASN1Set(rv=[(u'present', -128), (u'present', -127), (u'present', -126), (u'present', -125), (u'present', -124), (u'present', -123), (u'present', -122), (u'present', -121), (u'present', -120), (u'present', -119), (u'present', -118), (u'present', -117), (u'present', -116), (u'present', -115), (u'present', -114), (u'present', -113), (u'present', -112), (u'present', -111), (u'present', -110), (u'present', -109), (u'present', -108), (u'present', -107), (u'present', -106), (u'present', -105), (u'present', -104), (u'present', -103), (u'present', -102), (u'present', -101), (u'present', -100), (u'present', -99), (u'present', -98), (u'present', -97), (u'present', -96), (u'present', -95), (u'present', -94), (u'present', -93), (u'present', -92), (u'present', -91), (u'present', -90), (u'present', -89), (u'present', -88), (u'present', -87), (u'present', -86), (u'present', -85), (u'present', -84), (u'present', -83), (u'present', -82), (u'present', -81), (u'present', -80), (u'present', -79), (u'present', -78), (u'present', -77), (u'present', -76), (u'present', -75), (u'present', -74), (u'present', -73), (u'present', -72), (u'present', -71), (u'present', -70), (u'present', -69), (u'present', -68), (u'present', -67), (u'present', -66), (u'present', -65), (u'present', -64), (u'present', -63), (u'present', -62), (u'present', -61), (u'present', -60), (u'present', -59), (u'present', -58), (u'present', -57), (u'present', -56), (u'present', -55), (u'present', -54), (u'present', -53), (u'present', -52), (u'present', -51), (u'present', -50), (u'present', -49), (u'present', -48), (u'present', -47), (u'present', -46), (u'present', -45), (u'present', -44), (u'present', -43), (u'present', -42), (u'present', -41), (u'present', -40), (u'present', -39), (u'present', -38), (u'present', -37), (u'present', -36), (u'present', -35), (u'present', -34), (u'present', -33), (u'present', -32), (u'present', -31), (u'present', -30), (u'present', -29), (u'present', -28), (u'present', -27), (u'present', -26), (u'present', -25), (u'present', -24), (u'present', -23), (u'present', -22), (u'present', -21), (u'present', -20), (u'present', -19), (u'present', -18), (u'present', -17), (u'present', -16), (u'present', -15), (u'present', -14), (u'present', -13), (u'present', -12), (u'present', -11), (u'present', -10), (u'present', -9), (u'present', -8), (u'present', -7), (u'present', -6), (u'present', -5), (u'present', -4), (u'present', -3), (u'present', -2), (u'present', -1), (u'present', 0), (u'present', 1), (u'present', 2), (u'present', 3), (u'present', 4), (u'present', 5), (u'present', 6), (u'present', 7), (u'present', 8), (u'present', 9), (u'present', 10), (u'present', 11), (u'present', 12), (u'present', 13), (u'present', 14), (u'present', 15), (u'present', 16), (u'present', 17), (u'present', 18), (u'present', 19), (u'present', 20), (u'present', 21), (u'present', 22), (u'present', 23), (u'present', 24), (u'present', 25), (u'present', 26), (u'present', 27), (u'present', 28), (u'present', 29), (u'present', 30), (u'present', 31), (u'present', 32), (u'present', 33), (u'present', 34), (u'present', 35), (u'present', 36), (u'present', 37), (u'present', 38), (u'present', 39), (u'present', 40), (u'present', 41), (u'present', 42), (u'present', 43), (u'present', 44), (u'present', 45), (u'present', 46), (u'present', 47), (u'present', 48), (u'present', 49), (u'present', 50), (u'present', 51), (u'present', 52), (u'present', 53), (u'present', 54), (u'present', 55), (u'present', 56), (u'present', 57), (u'present', 58), (u'present', 59), (u'present', 60), (u'present', 61), (u'present', 62), (u'present', 63), (u'present', 64), (u'present', 65), (u'present', 66), (u'present', 67), (u'present', 68), (u'present', 69), (u'present', 70), (u'present', 71), (u'present', 72), (u'present', 73), (u'present', 74), (u'present', 75), (u'present', 76), (u'present', 77), (u'present', 78), (u'present', 79), (u'present', 80), (u'present', 81), (u'present', 82), (u'present', 83), (u'present', 84), (u'present', 85), (u'present', 86), (u'present', 87), (u'present', 88), (u'present', 89), (u'present', 90), (u'present', 91), (u'present', 92), (u'present', 93), (u'present', 94), (u'present', 95), (u'present', 96), (u'present', 97), (u'present', 98), (u'present', 99), (u'present', 100), (u'present', 101), (u'present', 102), (u'present', 103), (u'present', 104), (u'present', 105), (u'present', 106), (u'present', 107), (u'present', 108), (u'present', 109), (u'present', 110), (u'present', 111), (u'present', 112), (u'present', 113), (u'present', 114), (u'present', 115), (u'present', 116), (u'present', 117), (u'present', 118), (u'present', 119), (u'present', 120), (u'present', 121), (u'present', 122), (u'present', 123), (u'present', 124), (u'present', 125), (u'present', 126), (u'present', 127)], rr=[], ev=None, er=[])
    
    _all_ = [
        _Abort_dtid,
        __Abort_reason_p_abortCause,
        __Abort_reason_u_abortCause,
        _Abort_reason,
        Abort,
        DialoguePortion,
        OrigTransactionID,
        DestTransactionID,
        P_AbortCause,
        TCInvokeIdSet,
    ]

class TC_Notation_Extensions:

    _name_  = u'TC-Notation-Extensions'
    _oid_   = [0, 0, 17, 775, 2, 4, 1]
    
    _obj_ = [
        u'APPLICATION-CONTEXT',
        u'DialogueMode',
        u'Termination',
        u'dialogue-abstract-syntax',
        u'uniDialogue-abstract-syntax',
        u'TCSingleAS',
        u'TCConsumerAS',
        u'TCSupplierAS',
        u'ConnectionAS',
        ]
    _type_ = [
        u'APPLICATION-CONTEXT',
        u'DialogueMode',
        u'Termination',
        u'TCSingleAS',
        u'TCConsumerAS',
        u'TCSupplierAS',
        u'ConnectionAS',
        ]
    _set_ = [
        ]
    _val_ = [
        u'dialogue-abstract-syntax',
        u'uniDialogue-abstract-syntax',
        ]
    _class_ = [
        u'APPLICATION-CONTEXT',
        u'dialogue-abstract-syntax',
        u'uniDialogue-abstract-syntax',
        ]
    _param_ = [
        u'TCSingleAS',
        u'TCConsumerAS',
        u'TCSupplierAS',
        u'ConnectionAS',
        ]
    
    #-----< APPLICATION-CONTEXT >-----#
    APPLICATION_CONTEXT = CLASS(name=u'APPLICATION-CONTEXT', mode=MODE_TYPE)
    _APPLICATION_CONTEXT_associationContract = CLASS(name=u'associationContract', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'CONTRACT')))
    _APPLICATION_CONTEXT_dialogueMode = ENUM(name=u'dialogueMode', mode=MODE_VALUE, typeref=ASN1RefType(('TC-Notation-Extensions', 'DialogueMode')))
    _APPLICATION_CONTEXT_termination = ENUM(name=u'termination', mode=MODE_VALUE, typeref=ASN1RefType(('TC-Notation-Extensions', 'Termination')), opt=True)
    _APPLICATION_CONTEXT_componentGrouping = BOOL(name=u'componentGrouping', mode=MODE_VALUE, default=True)
    _APPLICATION_CONTEXT_dialogueAndComponentGrouping = BOOL(name=u'dialogueAndComponentGrouping', mode=MODE_VALUE, default=True)
    _APPLICATION_CONTEXT_AdditionalASEs = OID(name=u'AdditionalASEs', mode=MODE_SET, opt=True)
    _APPLICATION_CONTEXT_AbstractSyntaxes = CLASS(name=u'AbstractSyntaxes', mode=MODE_SET, typeref=ASN1RefType(('_IMPL_', u'ABSTRACT-SYNTAX'), []))
    _APPLICATION_CONTEXT_applicationContextName = OID(name=u'applicationContextName', mode=MODE_VALUE, uniq=True)
    APPLICATION_CONTEXT._cont = ASN1Dict([
        (u'associationContract', _APPLICATION_CONTEXT_associationContract),
        (u'dialogueMode', _APPLICATION_CONTEXT_dialogueMode),
        (u'termination', _APPLICATION_CONTEXT_termination),
        (u'componentGrouping', _APPLICATION_CONTEXT_componentGrouping),
        (u'dialogueAndComponentGrouping', _APPLICATION_CONTEXT_dialogueAndComponentGrouping),
        (u'AdditionalASEs', _APPLICATION_CONTEXT_AdditionalASEs),
        (u'AbstractSyntaxes', _APPLICATION_CONTEXT_AbstractSyntaxes),
        (u'applicationContextName', _APPLICATION_CONTEXT_applicationContextName),
        ])
    
    #-----< DialogueMode >-----#
    DialogueMode = ENUM(name=u'DialogueMode', mode=MODE_TYPE)
    DialogueMode._cont = ASN1Dict([(u'structured', 1), (u'unstructured', 2)])
    DialogueMode._ext = None
    
    #-----< Termination >-----#
    Termination = ENUM(name=u'Termination', mode=MODE_TYPE)
    Termination._cont = ASN1Dict([(u'basic', 1), (u'prearranged', 2)])
    Termination._ext = None
    
    #-----< dialogue-abstract-syntax >-----#
    dialogue_abstract_syntax = CLASS(name=u'dialogue-abstract-syntax', mode=MODE_VALUE, typeref=ASN1RefType(('_IMPL_', u'ABSTRACT-SYNTAX'), []))
    _dialogue_abstract_syntax_val_Type = CHOICE(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('DialoguePDUs', 'DialoguePDU')))
    dialogue_abstract_syntax._val = dict([('Type', _dialogue_abstract_syntax_val_Type), ('id', (0, 0, 17, 773, 1, 1, 1))])
    
    #-----< uniDialogue-abstract-syntax >-----#
    uniDialogue_abstract_syntax = CLASS(name=u'uniDialogue-abstract-syntax', mode=MODE_VALUE, typeref=ASN1RefType(('_IMPL_', u'ABSTRACT-SYNTAX'), []))
    _uniDialogue_abstract_syntax_val_Type = CHOICE(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('UnidialoguePDUs', 'UniDialoguePDU')))
    uniDialogue_abstract_syntax._val = dict([('Type', _uniDialogue_abstract_syntax_val_Type), ('id', (0, 0, 17, 773, 1, 2, 1))])
    
    #-----< TCSingleAS >-----#
    TCSingleAS = CHOICE(name=u'TCSingleAS', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'TCMessage')), param=True)
    
    #-----< TCConsumerAS >-----#
    TCConsumerAS = CHOICE(name=u'TCConsumerAS', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'TCMessage')), param=True)
    
    #-----< TCSupplierAS >-----#
    TCSupplierAS = CHOICE(name=u'TCSupplierAS', mode=MODE_TYPE, typeref=ASN1RefType(('TCAPMessages', 'TCMessage')), param=True)
    
    #-----< ConnectionAS >-----#
    ConnectionAS = CHOICE(name=u'ConnectionAS', mode=MODE_TYPE, param=True)
    
    _all_ = [
        _APPLICATION_CONTEXT_associationContract,
        _APPLICATION_CONTEXT_dialogueMode,
        _APPLICATION_CONTEXT_termination,
        _APPLICATION_CONTEXT_componentGrouping,
        _APPLICATION_CONTEXT_dialogueAndComponentGrouping,
        _APPLICATION_CONTEXT_AdditionalASEs,
        _APPLICATION_CONTEXT_AbstractSyntaxes,
        _APPLICATION_CONTEXT_applicationContextName,
        APPLICATION_CONTEXT,
        DialogueMode,
        Termination,
        dialogue_abstract_syntax,
        _dialogue_abstract_syntax_val_Type,
        uniDialogue_abstract_syntax,
        _uniDialogue_abstract_syntax_val_Type,
    ]

class CS1_DataTypes:

    _name_  = u'CS1-DataTypes'
    _oid_   = []
    
    _obj_ = [
        u'Duration',
        u'Integer4',
        u'Interval',
        u'LegID',
        u'LegType',
        u'ServiceKey',
        u'CallingPartysCategory',
        u'HighLayerCompatibility',
        u'highLayerCompatibilityLength',
        u'RedirectionInformation',
        ]
    _type_ = [
        u'Duration',
        u'Integer4',
        u'Interval',
        u'LegID',
        u'LegType',
        u'ServiceKey',
        u'CallingPartysCategory',
        u'HighLayerCompatibility',
        u'RedirectionInformation',
        ]
    _set_ = [
        ]
    _val_ = [
        u'highLayerCompatibilityLength',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< Duration >-----#
    Duration = INT(name=u'Duration', mode=MODE_TYPE)
    Duration._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-2, ub=86400)], ev=None, er=[])
    
    #-----< Integer4 >-----#
    Integer4 = INT(name=u'Integer4', mode=MODE_TYPE)
    Integer4._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2147483647)], ev=None, er=[])
    
    #-----< Interval >-----#
    Interval = INT(name=u'Interval', mode=MODE_TYPE)
    Interval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-1, ub=60000)], ev=None, er=[])
    
    #-----< LegID >-----#
    LegID = CHOICE(name=u'LegID', mode=MODE_TYPE)
    _LegID_sendingSideID = OCT_STR(name=u'sendingSideID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CS1-DataTypes', 'LegType')))
    _LegID_receivingSideID = OCT_STR(name=u'receivingSideID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CS1-DataTypes', 'LegType')))
    LegID._cont = ASN1Dict([
        (u'sendingSideID', _LegID_sendingSideID),
        (u'receivingSideID', _LegID_receivingSideID),
        ])
    LegID._ext = None
    
    #-----< LegType >-----#
    LegType = OCT_STR(name=u'LegType', mode=MODE_TYPE)
    LegType._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< ServiceKey >-----#
    ServiceKey = INT(name=u'ServiceKey', mode=MODE_TYPE, typeref=ASN1RefType(('CS1-DataTypes', 'Integer4')))
    
    #-----< CallingPartysCategory >-----#
    CallingPartysCategory = OCT_STR(name=u'CallingPartysCategory', mode=MODE_TYPE)
    CallingPartysCategory._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< HighLayerCompatibility >-----#
    HighLayerCompatibility = OCT_STR(name=u'HighLayerCompatibility', mode=MODE_TYPE)
    HighLayerCompatibility._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< highLayerCompatibilityLength >-----#
    highLayerCompatibilityLength = INT(name=u'highLayerCompatibilityLength', mode=MODE_VALUE)
    highLayerCompatibilityLength._val = 2
    
    #-----< RedirectionInformation >-----#
    RedirectionInformation = OCT_STR(name=u'RedirectionInformation', mode=MODE_TYPE)
    RedirectionInformation._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    _all_ = [
        Duration,
        Integer4,
        Interval,
        _LegID_sendingSideID,
        _LegID_receivingSideID,
        LegID,
        LegType,
        ServiceKey,
        CallingPartysCategory,
        HighLayerCompatibility,
        highLayerCompatibilityLength,
        RedirectionInformation,
    ]

class CS2_datatypes:

    _name_  = u'CS2-datatypes'
    _oid_   = []
    
    _obj_ = [
        u'CriticalityType',
        u'BothwayThroughConnectionInd',
        u'MiscCallInfo',
        ]
    _type_ = [
        u'CriticalityType',
        u'BothwayThroughConnectionInd',
        u'MiscCallInfo',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< CriticalityType >-----#
    CriticalityType = ENUM(name=u'CriticalityType', mode=MODE_TYPE)
    CriticalityType._cont = ASN1Dict([(u'ignore', 0), (u'abort', 1)])
    CriticalityType._ext = None
    
    #-----< BothwayThroughConnectionInd >-----#
    BothwayThroughConnectionInd = ENUM(name=u'BothwayThroughConnectionInd', mode=MODE_TYPE)
    BothwayThroughConnectionInd._cont = ASN1Dict([(u'bothwayPathRequired', 0), (u'bothwayPathNotRequired', 1)])
    BothwayThroughConnectionInd._ext = None
    
    #-----< MiscCallInfo >-----#
    MiscCallInfo = SEQ(name=u'MiscCallInfo', mode=MODE_TYPE)
    _MiscCallInfo_messageType = ENUM(name=u'messageType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MiscCallInfo_messageType._cont = ASN1Dict([(u'request', 0), (u'notification', 1)])
    _MiscCallInfo_messageType._ext = None
    _MiscCallInfo_dpAssignment = ENUM(name=u'dpAssignment', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MiscCallInfo_dpAssignment._cont = ASN1Dict([(u'individualLine', 0), (u'groupBased', 1), (u'officeBased', 2)])
    _MiscCallInfo_dpAssignment._ext = None
    MiscCallInfo._cont = ASN1Dict([
        (u'messageType', _MiscCallInfo_messageType),
        (u'dpAssignment', _MiscCallInfo_dpAssignment),
        ])
    MiscCallInfo._ext = None
    
    _all_ = [
        CriticalityType,
        BothwayThroughConnectionInd,
        _MiscCallInfo_messageType,
        _MiscCallInfo_dpAssignment,
        MiscCallInfo,
    ]

class MAP_TS_Code:

    _name_  = u'MAP-TS-Code'
    _oid_   = [0, 4, 0, 0, 1, 3, 19, 16]
    
    _obj_ = [
        u'TeleserviceCode',
        u'Ext-TeleserviceCode',
        u'allTeleservices',
        u'allSpeechTransmissionServices',
        u'telephony',
        u'emergencyCalls',
        u'allShortMessageServices',
        u'shortMessageMT-PP',
        u'shortMessageMO-PP',
        u'allFacsimileTransmissionServices',
        u'facsimileGroup3AndAlterSpeech',
        u'automaticFacsimileGroup3',
        u'facsimileGroup4',
        u'allDataTeleservices',
        u'allTeleservices-ExeptSMS',
        u'allVoiceGroupCallServices',
        u'voiceGroupCall',
        u'voiceBroadcastCall',
        u'allPLMN-specificTS',
        u'plmn-specificTS-1',
        u'plmn-specificTS-2',
        u'plmn-specificTS-3',
        u'plmn-specificTS-4',
        u'plmn-specificTS-5',
        u'plmn-specificTS-6',
        u'plmn-specificTS-7',
        u'plmn-specificTS-8',
        u'plmn-specificTS-9',
        u'plmn-specificTS-A',
        u'plmn-specificTS-B',
        u'plmn-specificTS-C',
        u'plmn-specificTS-D',
        u'plmn-specificTS-E',
        u'plmn-specificTS-F',
        ]
    _type_ = [
        u'TeleserviceCode',
        u'Ext-TeleserviceCode',
        ]
    _set_ = [
        ]
    _val_ = [
        u'allTeleservices',
        u'allSpeechTransmissionServices',
        u'telephony',
        u'emergencyCalls',
        u'allShortMessageServices',
        u'shortMessageMT-PP',
        u'shortMessageMO-PP',
        u'allFacsimileTransmissionServices',
        u'facsimileGroup3AndAlterSpeech',
        u'automaticFacsimileGroup3',
        u'facsimileGroup4',
        u'allDataTeleservices',
        u'allTeleservices-ExeptSMS',
        u'allVoiceGroupCallServices',
        u'voiceGroupCall',
        u'voiceBroadcastCall',
        u'allPLMN-specificTS',
        u'plmn-specificTS-1',
        u'plmn-specificTS-2',
        u'plmn-specificTS-3',
        u'plmn-specificTS-4',
        u'plmn-specificTS-5',
        u'plmn-specificTS-6',
        u'plmn-specificTS-7',
        u'plmn-specificTS-8',
        u'plmn-specificTS-9',
        u'plmn-specificTS-A',
        u'plmn-specificTS-B',
        u'plmn-specificTS-C',
        u'plmn-specificTS-D',
        u'plmn-specificTS-E',
        u'plmn-specificTS-F',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< TeleserviceCode >-----#
    TeleserviceCode = OCT_STR(name=u'TeleserviceCode', mode=MODE_TYPE)
    TeleserviceCode._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< Ext-TeleserviceCode >-----#
    Ext_TeleserviceCode = OCT_STR(name=u'Ext-TeleserviceCode', mode=MODE_TYPE)
    Ext_TeleserviceCode._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< allTeleservices >-----#
    allTeleservices = OCT_STR(name=u'allTeleservices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    allTeleservices._val = b'\x00'
    
    #-----< allSpeechTransmissionServices >-----#
    allSpeechTransmissionServices = OCT_STR(name=u'allSpeechTransmissionServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    allSpeechTransmissionServices._val = b'\x10'
    
    #-----< telephony >-----#
    telephony = OCT_STR(name=u'telephony', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    telephony._val = b'\x11'
    
    #-----< emergencyCalls >-----#
    emergencyCalls = OCT_STR(name=u'emergencyCalls', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    emergencyCalls._val = b'\x12'
    
    #-----< allShortMessageServices >-----#
    allShortMessageServices = OCT_STR(name=u'allShortMessageServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    allShortMessageServices._val = b' '
    
    #-----< shortMessageMT-PP >-----#
    shortMessageMT_PP = OCT_STR(name=u'shortMessageMT-PP', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    shortMessageMT_PP._val = b'!'
    
    #-----< shortMessageMO-PP >-----#
    shortMessageMO_PP = OCT_STR(name=u'shortMessageMO-PP', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    shortMessageMO_PP._val = b'"'
    
    #-----< allFacsimileTransmissionServices >-----#
    allFacsimileTransmissionServices = OCT_STR(name=u'allFacsimileTransmissionServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    allFacsimileTransmissionServices._val = b'`'
    
    #-----< facsimileGroup3AndAlterSpeech >-----#
    facsimileGroup3AndAlterSpeech = OCT_STR(name=u'facsimileGroup3AndAlterSpeech', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    facsimileGroup3AndAlterSpeech._val = b'a'
    
    #-----< automaticFacsimileGroup3 >-----#
    automaticFacsimileGroup3 = OCT_STR(name=u'automaticFacsimileGroup3', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    automaticFacsimileGroup3._val = b'b'
    
    #-----< facsimileGroup4 >-----#
    facsimileGroup4 = OCT_STR(name=u'facsimileGroup4', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    facsimileGroup4._val = b'c'
    
    #-----< allDataTeleservices >-----#
    allDataTeleservices = OCT_STR(name=u'allDataTeleservices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    allDataTeleservices._val = b'p'
    
    #-----< allTeleservices-ExeptSMS >-----#
    allTeleservices_ExeptSMS = OCT_STR(name=u'allTeleservices-ExeptSMS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    allTeleservices_ExeptSMS._val = b'\x80'
    
    #-----< allVoiceGroupCallServices >-----#
    allVoiceGroupCallServices = OCT_STR(name=u'allVoiceGroupCallServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    allVoiceGroupCallServices._val = b'\x90'
    
    #-----< voiceGroupCall >-----#
    voiceGroupCall = OCT_STR(name=u'voiceGroupCall', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    voiceGroupCall._val = b'\x91'
    
    #-----< voiceBroadcastCall >-----#
    voiceBroadcastCall = OCT_STR(name=u'voiceBroadcastCall', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    voiceBroadcastCall._val = b'\x92'
    
    #-----< allPLMN-specificTS >-----#
    allPLMN_specificTS = OCT_STR(name=u'allPLMN-specificTS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    allPLMN_specificTS._val = b'\xd0'
    
    #-----< plmn-specificTS-1 >-----#
    plmn_specificTS_1 = OCT_STR(name=u'plmn-specificTS-1', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_1._val = b'\xd1'
    
    #-----< plmn-specificTS-2 >-----#
    plmn_specificTS_2 = OCT_STR(name=u'plmn-specificTS-2', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_2._val = b'\xd2'
    
    #-----< plmn-specificTS-3 >-----#
    plmn_specificTS_3 = OCT_STR(name=u'plmn-specificTS-3', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_3._val = b'\xd3'
    
    #-----< plmn-specificTS-4 >-----#
    plmn_specificTS_4 = OCT_STR(name=u'plmn-specificTS-4', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_4._val = b'\xd4'
    
    #-----< plmn-specificTS-5 >-----#
    plmn_specificTS_5 = OCT_STR(name=u'plmn-specificTS-5', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_5._val = b'\xd5'
    
    #-----< plmn-specificTS-6 >-----#
    plmn_specificTS_6 = OCT_STR(name=u'plmn-specificTS-6', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_6._val = b'\xd6'
    
    #-----< plmn-specificTS-7 >-----#
    plmn_specificTS_7 = OCT_STR(name=u'plmn-specificTS-7', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_7._val = b'\xd7'
    
    #-----< plmn-specificTS-8 >-----#
    plmn_specificTS_8 = OCT_STR(name=u'plmn-specificTS-8', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_8._val = b'\xd8'
    
    #-----< plmn-specificTS-9 >-----#
    plmn_specificTS_9 = OCT_STR(name=u'plmn-specificTS-9', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_9._val = b'\xd9'
    
    #-----< plmn-specificTS-A >-----#
    plmn_specificTS_A = OCT_STR(name=u'plmn-specificTS-A', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_A._val = b'\xda'
    
    #-----< plmn-specificTS-B >-----#
    plmn_specificTS_B = OCT_STR(name=u'plmn-specificTS-B', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_B._val = b'\xdb'
    
    #-----< plmn-specificTS-C >-----#
    plmn_specificTS_C = OCT_STR(name=u'plmn-specificTS-C', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_C._val = b'\xdc'
    
    #-----< plmn-specificTS-D >-----#
    plmn_specificTS_D = OCT_STR(name=u'plmn-specificTS-D', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_D._val = b'\xdd'
    
    #-----< plmn-specificTS-E >-----#
    plmn_specificTS_E = OCT_STR(name=u'plmn-specificTS-E', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_E._val = b'\xde'
    
    #-----< plmn-specificTS-F >-----#
    plmn_specificTS_F = OCT_STR(name=u'plmn-specificTS-F', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    plmn_specificTS_F._val = b'\xdf'
    
    _all_ = [
        TeleserviceCode,
        Ext_TeleserviceCode,
        allTeleservices,
        allSpeechTransmissionServices,
        telephony,
        emergencyCalls,
        allShortMessageServices,
        shortMessageMT_PP,
        shortMessageMO_PP,
        allFacsimileTransmissionServices,
        facsimileGroup3AndAlterSpeech,
        automaticFacsimileGroup3,
        facsimileGroup4,
        allDataTeleservices,
        allTeleservices_ExeptSMS,
        allVoiceGroupCallServices,
        voiceGroupCall,
        voiceBroadcastCall,
        allPLMN_specificTS,
        plmn_specificTS_1,
        plmn_specificTS_2,
        plmn_specificTS_3,
        plmn_specificTS_4,
        plmn_specificTS_5,
        plmn_specificTS_6,
        plmn_specificTS_7,
        plmn_specificTS_8,
        plmn_specificTS_9,
        plmn_specificTS_A,
        plmn_specificTS_B,
        plmn_specificTS_C,
        plmn_specificTS_D,
        plmn_specificTS_E,
        plmn_specificTS_F,
    ]

class MAP_BS_Code:

    _name_  = u'MAP-BS-Code'
    _oid_   = [0, 4, 0, 0, 1, 3, 20, 16]
    
    _obj_ = [
        u'BearerServiceCode',
        u'Ext-BearerServiceCode',
        u'allBearerServices',
        u'allDataCDA-Services',
        u'dataCDA-300bps',
        u'dataCDA-1200bps',
        u'dataCDA-1200-75bps',
        u'dataCDA-2400bps',
        u'dataCDA-4800bps',
        u'dataCDA-9600bps',
        u'general-dataCDA',
        u'allDataCDS-Services',
        u'dataCDS-1200bps',
        u'dataCDS-2400bps',
        u'dataCDS-4800bps',
        u'dataCDS-9600bps',
        u'general-dataCDS',
        u'allPadAccessCA-Services',
        u'padAccessCA-300bps',
        u'padAccessCA-1200bps',
        u'padAccessCA-1200-75bps',
        u'padAccessCA-2400bps',
        u'padAccessCA-4800bps',
        u'padAccessCA-9600bps',
        u'general-padAccessCA',
        u'allDataPDS-Services',
        u'dataPDS-2400bps',
        u'dataPDS-4800bps',
        u'dataPDS-9600bps',
        u'general-dataPDS',
        u'allAlternateSpeech-DataCDA',
        u'allAlternateSpeech-DataCDS',
        u'allSpeechFollowedByDataCDA',
        u'allSpeechFollowedByDataCDS',
        u'allDataCircuitAsynchronous',
        u'allAsynchronousServices',
        u'allDataCircuitSynchronous',
        u'allSynchronousServices',
        u'allPLMN-specificBS',
        u'plmn-specificBS-1',
        u'plmn-specificBS-2',
        u'plmn-specificBS-3',
        u'plmn-specificBS-4',
        u'plmn-specificBS-5',
        u'plmn-specificBS-6',
        u'plmn-specificBS-7',
        u'plmn-specificBS-8',
        u'plmn-specificBS-9',
        u'plmn-specificBS-A',
        u'plmn-specificBS-B',
        u'plmn-specificBS-C',
        u'plmn-specificBS-D',
        u'plmn-specificBS-E',
        u'plmn-specificBS-F',
        ]
    _type_ = [
        u'BearerServiceCode',
        u'Ext-BearerServiceCode',
        ]
    _set_ = [
        ]
    _val_ = [
        u'allBearerServices',
        u'allDataCDA-Services',
        u'dataCDA-300bps',
        u'dataCDA-1200bps',
        u'dataCDA-1200-75bps',
        u'dataCDA-2400bps',
        u'dataCDA-4800bps',
        u'dataCDA-9600bps',
        u'general-dataCDA',
        u'allDataCDS-Services',
        u'dataCDS-1200bps',
        u'dataCDS-2400bps',
        u'dataCDS-4800bps',
        u'dataCDS-9600bps',
        u'general-dataCDS',
        u'allPadAccessCA-Services',
        u'padAccessCA-300bps',
        u'padAccessCA-1200bps',
        u'padAccessCA-1200-75bps',
        u'padAccessCA-2400bps',
        u'padAccessCA-4800bps',
        u'padAccessCA-9600bps',
        u'general-padAccessCA',
        u'allDataPDS-Services',
        u'dataPDS-2400bps',
        u'dataPDS-4800bps',
        u'dataPDS-9600bps',
        u'general-dataPDS',
        u'allAlternateSpeech-DataCDA',
        u'allAlternateSpeech-DataCDS',
        u'allSpeechFollowedByDataCDA',
        u'allSpeechFollowedByDataCDS',
        u'allDataCircuitAsynchronous',
        u'allAsynchronousServices',
        u'allDataCircuitSynchronous',
        u'allSynchronousServices',
        u'allPLMN-specificBS',
        u'plmn-specificBS-1',
        u'plmn-specificBS-2',
        u'plmn-specificBS-3',
        u'plmn-specificBS-4',
        u'plmn-specificBS-5',
        u'plmn-specificBS-6',
        u'plmn-specificBS-7',
        u'plmn-specificBS-8',
        u'plmn-specificBS-9',
        u'plmn-specificBS-A',
        u'plmn-specificBS-B',
        u'plmn-specificBS-C',
        u'plmn-specificBS-D',
        u'plmn-specificBS-E',
        u'plmn-specificBS-F',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< BearerServiceCode >-----#
    BearerServiceCode = OCT_STR(name=u'BearerServiceCode', mode=MODE_TYPE)
    BearerServiceCode._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< Ext-BearerServiceCode >-----#
    Ext_BearerServiceCode = OCT_STR(name=u'Ext-BearerServiceCode', mode=MODE_TYPE)
    Ext_BearerServiceCode._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< allBearerServices >-----#
    allBearerServices = OCT_STR(name=u'allBearerServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allBearerServices._val = b'\x00'
    
    #-----< allDataCDA-Services >-----#
    allDataCDA_Services = OCT_STR(name=u'allDataCDA-Services', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allDataCDA_Services._val = b'\x10'
    
    #-----< dataCDA-300bps >-----#
    dataCDA_300bps = OCT_STR(name=u'dataCDA-300bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataCDA_300bps._val = b'\x11'
    
    #-----< dataCDA-1200bps >-----#
    dataCDA_1200bps = OCT_STR(name=u'dataCDA-1200bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataCDA_1200bps._val = b'\x12'
    
    #-----< dataCDA-1200-75bps >-----#
    dataCDA_1200_75bps = OCT_STR(name=u'dataCDA-1200-75bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataCDA_1200_75bps._val = b'\x13'
    
    #-----< dataCDA-2400bps >-----#
    dataCDA_2400bps = OCT_STR(name=u'dataCDA-2400bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataCDA_2400bps._val = b'\x14'
    
    #-----< dataCDA-4800bps >-----#
    dataCDA_4800bps = OCT_STR(name=u'dataCDA-4800bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataCDA_4800bps._val = b'\x15'
    
    #-----< dataCDA-9600bps >-----#
    dataCDA_9600bps = OCT_STR(name=u'dataCDA-9600bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataCDA_9600bps._val = b'\x16'
    
    #-----< general-dataCDA >-----#
    general_dataCDA = OCT_STR(name=u'general-dataCDA', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    general_dataCDA._val = b'\x17'
    
    #-----< allDataCDS-Services >-----#
    allDataCDS_Services = OCT_STR(name=u'allDataCDS-Services', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allDataCDS_Services._val = b'\x18'
    
    #-----< dataCDS-1200bps >-----#
    dataCDS_1200bps = OCT_STR(name=u'dataCDS-1200bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataCDS_1200bps._val = b'\x1a'
    
    #-----< dataCDS-2400bps >-----#
    dataCDS_2400bps = OCT_STR(name=u'dataCDS-2400bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataCDS_2400bps._val = b'\x1c'
    
    #-----< dataCDS-4800bps >-----#
    dataCDS_4800bps = OCT_STR(name=u'dataCDS-4800bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataCDS_4800bps._val = b'\x1d'
    
    #-----< dataCDS-9600bps >-----#
    dataCDS_9600bps = OCT_STR(name=u'dataCDS-9600bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataCDS_9600bps._val = b'\x1e'
    
    #-----< general-dataCDS >-----#
    general_dataCDS = OCT_STR(name=u'general-dataCDS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    general_dataCDS._val = b'\x1f'
    
    #-----< allPadAccessCA-Services >-----#
    allPadAccessCA_Services = OCT_STR(name=u'allPadAccessCA-Services', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allPadAccessCA_Services._val = b' '
    
    #-----< padAccessCA-300bps >-----#
    padAccessCA_300bps = OCT_STR(name=u'padAccessCA-300bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    padAccessCA_300bps._val = b'!'
    
    #-----< padAccessCA-1200bps >-----#
    padAccessCA_1200bps = OCT_STR(name=u'padAccessCA-1200bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    padAccessCA_1200bps._val = b'"'
    
    #-----< padAccessCA-1200-75bps >-----#
    padAccessCA_1200_75bps = OCT_STR(name=u'padAccessCA-1200-75bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    padAccessCA_1200_75bps._val = b'#'
    
    #-----< padAccessCA-2400bps >-----#
    padAccessCA_2400bps = OCT_STR(name=u'padAccessCA-2400bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    padAccessCA_2400bps._val = b'$'
    
    #-----< padAccessCA-4800bps >-----#
    padAccessCA_4800bps = OCT_STR(name=u'padAccessCA-4800bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    padAccessCA_4800bps._val = b'%'
    
    #-----< padAccessCA-9600bps >-----#
    padAccessCA_9600bps = OCT_STR(name=u'padAccessCA-9600bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    padAccessCA_9600bps._val = b'&'
    
    #-----< general-padAccessCA >-----#
    general_padAccessCA = OCT_STR(name=u'general-padAccessCA', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    general_padAccessCA._val = b"'"
    
    #-----< allDataPDS-Services >-----#
    allDataPDS_Services = OCT_STR(name=u'allDataPDS-Services', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allDataPDS_Services._val = b'('
    
    #-----< dataPDS-2400bps >-----#
    dataPDS_2400bps = OCT_STR(name=u'dataPDS-2400bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataPDS_2400bps._val = b','
    
    #-----< dataPDS-4800bps >-----#
    dataPDS_4800bps = OCT_STR(name=u'dataPDS-4800bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataPDS_4800bps._val = b'-'
    
    #-----< dataPDS-9600bps >-----#
    dataPDS_9600bps = OCT_STR(name=u'dataPDS-9600bps', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    dataPDS_9600bps._val = b'.'
    
    #-----< general-dataPDS >-----#
    general_dataPDS = OCT_STR(name=u'general-dataPDS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    general_dataPDS._val = b'/'
    
    #-----< allAlternateSpeech-DataCDA >-----#
    allAlternateSpeech_DataCDA = OCT_STR(name=u'allAlternateSpeech-DataCDA', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allAlternateSpeech_DataCDA._val = b'0'
    
    #-----< allAlternateSpeech-DataCDS >-----#
    allAlternateSpeech_DataCDS = OCT_STR(name=u'allAlternateSpeech-DataCDS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allAlternateSpeech_DataCDS._val = b'8'
    
    #-----< allSpeechFollowedByDataCDA >-----#
    allSpeechFollowedByDataCDA = OCT_STR(name=u'allSpeechFollowedByDataCDA', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allSpeechFollowedByDataCDA._val = b'@'
    
    #-----< allSpeechFollowedByDataCDS >-----#
    allSpeechFollowedByDataCDS = OCT_STR(name=u'allSpeechFollowedByDataCDS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allSpeechFollowedByDataCDS._val = b'H'
    
    #-----< allDataCircuitAsynchronous >-----#
    allDataCircuitAsynchronous = OCT_STR(name=u'allDataCircuitAsynchronous', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allDataCircuitAsynchronous._val = b'P'
    
    #-----< allAsynchronousServices >-----#
    allAsynchronousServices = OCT_STR(name=u'allAsynchronousServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allAsynchronousServices._val = b'`'
    
    #-----< allDataCircuitSynchronous >-----#
    allDataCircuitSynchronous = OCT_STR(name=u'allDataCircuitSynchronous', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allDataCircuitSynchronous._val = b'X'
    
    #-----< allSynchronousServices >-----#
    allSynchronousServices = OCT_STR(name=u'allSynchronousServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allSynchronousServices._val = b'h'
    
    #-----< allPLMN-specificBS >-----#
    allPLMN_specificBS = OCT_STR(name=u'allPLMN-specificBS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    allPLMN_specificBS._val = b'\xd0'
    
    #-----< plmn-specificBS-1 >-----#
    plmn_specificBS_1 = OCT_STR(name=u'plmn-specificBS-1', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_1._val = b'\xd1'
    
    #-----< plmn-specificBS-2 >-----#
    plmn_specificBS_2 = OCT_STR(name=u'plmn-specificBS-2', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_2._val = b'\xd2'
    
    #-----< plmn-specificBS-3 >-----#
    plmn_specificBS_3 = OCT_STR(name=u'plmn-specificBS-3', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_3._val = b'\xd3'
    
    #-----< plmn-specificBS-4 >-----#
    plmn_specificBS_4 = OCT_STR(name=u'plmn-specificBS-4', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_4._val = b'\xd4'
    
    #-----< plmn-specificBS-5 >-----#
    plmn_specificBS_5 = OCT_STR(name=u'plmn-specificBS-5', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_5._val = b'\xd5'
    
    #-----< plmn-specificBS-6 >-----#
    plmn_specificBS_6 = OCT_STR(name=u'plmn-specificBS-6', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_6._val = b'\xd6'
    
    #-----< plmn-specificBS-7 >-----#
    plmn_specificBS_7 = OCT_STR(name=u'plmn-specificBS-7', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_7._val = b'\xd7'
    
    #-----< plmn-specificBS-8 >-----#
    plmn_specificBS_8 = OCT_STR(name=u'plmn-specificBS-8', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_8._val = b'\xd8'
    
    #-----< plmn-specificBS-9 >-----#
    plmn_specificBS_9 = OCT_STR(name=u'plmn-specificBS-9', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_9._val = b'\xd9'
    
    #-----< plmn-specificBS-A >-----#
    plmn_specificBS_A = OCT_STR(name=u'plmn-specificBS-A', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_A._val = b'\xda'
    
    #-----< plmn-specificBS-B >-----#
    plmn_specificBS_B = OCT_STR(name=u'plmn-specificBS-B', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_B._val = b'\xdb'
    
    #-----< plmn-specificBS-C >-----#
    plmn_specificBS_C = OCT_STR(name=u'plmn-specificBS-C', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_C._val = b'\xdc'
    
    #-----< plmn-specificBS-D >-----#
    plmn_specificBS_D = OCT_STR(name=u'plmn-specificBS-D', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_D._val = b'\xdd'
    
    #-----< plmn-specificBS-E >-----#
    plmn_specificBS_E = OCT_STR(name=u'plmn-specificBS-E', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_E._val = b'\xde'
    
    #-----< plmn-specificBS-F >-----#
    plmn_specificBS_F = OCT_STR(name=u'plmn-specificBS-F', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    plmn_specificBS_F._val = b'\xdf'
    
    _all_ = [
        BearerServiceCode,
        Ext_BearerServiceCode,
        allBearerServices,
        allDataCDA_Services,
        dataCDA_300bps,
        dataCDA_1200bps,
        dataCDA_1200_75bps,
        dataCDA_2400bps,
        dataCDA_4800bps,
        dataCDA_9600bps,
        general_dataCDA,
        allDataCDS_Services,
        dataCDS_1200bps,
        dataCDS_2400bps,
        dataCDS_4800bps,
        dataCDS_9600bps,
        general_dataCDS,
        allPadAccessCA_Services,
        padAccessCA_300bps,
        padAccessCA_1200bps,
        padAccessCA_1200_75bps,
        padAccessCA_2400bps,
        padAccessCA_4800bps,
        padAccessCA_9600bps,
        general_padAccessCA,
        allDataPDS_Services,
        dataPDS_2400bps,
        dataPDS_4800bps,
        dataPDS_9600bps,
        general_dataPDS,
        allAlternateSpeech_DataCDA,
        allAlternateSpeech_DataCDS,
        allSpeechFollowedByDataCDA,
        allSpeechFollowedByDataCDS,
        allDataCircuitAsynchronous,
        allAsynchronousServices,
        allDataCircuitSynchronous,
        allSynchronousServices,
        allPLMN_specificBS,
        plmn_specificBS_1,
        plmn_specificBS_2,
        plmn_specificBS_3,
        plmn_specificBS_4,
        plmn_specificBS_5,
        plmn_specificBS_6,
        plmn_specificBS_7,
        plmn_specificBS_8,
        plmn_specificBS_9,
        plmn_specificBS_A,
        plmn_specificBS_B,
        plmn_specificBS_C,
        plmn_specificBS_D,
        plmn_specificBS_E,
        plmn_specificBS_F,
    ]

class MAP_SS_Code:

    _name_  = u'MAP-SS-Code'
    _oid_   = [0, 4, 0, 0, 1, 3, 15, 16]
    
    _obj_ = [
        u'SS-Code',
        u'allSS',
        u'allLineIdentificationSS',
        u'clip',
        u'clir',
        u'colp',
        u'colr',
        u'mci',
        u'allNameIdentificationSS',
        u'cnap',
        u'allForwardingSS',
        u'cfu',
        u'allCondForwardingSS',
        u'cfb',
        u'cfnry',
        u'cfnrc',
        u'cd',
        u'allCallOfferingSS',
        u'ect',
        u'mah',
        u'allCallCompletionSS',
        u'cw',
        u'hold',
        u'ccbs-A',
        u'ccbs-B',
        u'mc',
        u'allMultiPartySS',
        u'multiPTY',
        u'allCommunityOfInterest-SS',
        u'cug',
        u'allChargingSS',
        u'aoci',
        u'aocc',
        u'allAdditionalInfoTransferSS',
        u'uus1',
        u'uus2',
        u'uus3',
        u'allBarringSS',
        u'barringOfOutgoingCalls',
        u'baoc',
        u'boic',
        u'boicExHC',
        u'barringOfIncomingCalls',
        u'baic',
        u'bicRoam',
        u'allPLMN-specificSS',
        u'plmn-specificSS-1',
        u'plmn-specificSS-2',
        u'plmn-specificSS-3',
        u'plmn-specificSS-4',
        u'plmn-specificSS-5',
        u'plmn-specificSS-6',
        u'plmn-specificSS-7',
        u'plmn-specificSS-8',
        u'plmn-specificSS-9',
        u'plmn-specificSS-A',
        u'plmn-specificSS-B',
        u'plmn-specificSS-C',
        u'plmn-specificSS-D',
        u'plmn-specificSS-E',
        u'plmn-specificSS-F',
        u'allCallPrioritySS',
        u'emlpp',
        u'allLCSPrivacyException',
        u'universal',
        u'callSessionRelated',
        u'callSessionUnrelated',
        u'plmnoperator',
        u'serviceType',
        u'allMOLR-SS',
        u'basicSelfLocation',
        u'autonomousSelfLocation',
        u'transferToThirdParty',
        ]
    _type_ = [
        u'SS-Code',
        ]
    _set_ = [
        ]
    _val_ = [
        u'allSS',
        u'allLineIdentificationSS',
        u'clip',
        u'clir',
        u'colp',
        u'colr',
        u'mci',
        u'allNameIdentificationSS',
        u'cnap',
        u'allForwardingSS',
        u'cfu',
        u'allCondForwardingSS',
        u'cfb',
        u'cfnry',
        u'cfnrc',
        u'cd',
        u'allCallOfferingSS',
        u'ect',
        u'mah',
        u'allCallCompletionSS',
        u'cw',
        u'hold',
        u'ccbs-A',
        u'ccbs-B',
        u'mc',
        u'allMultiPartySS',
        u'multiPTY',
        u'allCommunityOfInterest-SS',
        u'cug',
        u'allChargingSS',
        u'aoci',
        u'aocc',
        u'allAdditionalInfoTransferSS',
        u'uus1',
        u'uus2',
        u'uus3',
        u'allBarringSS',
        u'barringOfOutgoingCalls',
        u'baoc',
        u'boic',
        u'boicExHC',
        u'barringOfIncomingCalls',
        u'baic',
        u'bicRoam',
        u'allPLMN-specificSS',
        u'plmn-specificSS-1',
        u'plmn-specificSS-2',
        u'plmn-specificSS-3',
        u'plmn-specificSS-4',
        u'plmn-specificSS-5',
        u'plmn-specificSS-6',
        u'plmn-specificSS-7',
        u'plmn-specificSS-8',
        u'plmn-specificSS-9',
        u'plmn-specificSS-A',
        u'plmn-specificSS-B',
        u'plmn-specificSS-C',
        u'plmn-specificSS-D',
        u'plmn-specificSS-E',
        u'plmn-specificSS-F',
        u'allCallPrioritySS',
        u'emlpp',
        u'allLCSPrivacyException',
        u'universal',
        u'callSessionRelated',
        u'callSessionUnrelated',
        u'plmnoperator',
        u'serviceType',
        u'allMOLR-SS',
        u'basicSelfLocation',
        u'autonomousSelfLocation',
        u'transferToThirdParty',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< SS-Code >-----#
    SS_Code = OCT_STR(name=u'SS-Code', mode=MODE_TYPE)
    SS_Code._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< allSS >-----#
    allSS = OCT_STR(name=u'allSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allSS._val = b'\x00'
    
    #-----< allLineIdentificationSS >-----#
    allLineIdentificationSS = OCT_STR(name=u'allLineIdentificationSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allLineIdentificationSS._val = b'\x10'
    
    #-----< clip >-----#
    clip = OCT_STR(name=u'clip', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    clip._val = b'\x11'
    
    #-----< clir >-----#
    clir = OCT_STR(name=u'clir', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    clir._val = b'\x12'
    
    #-----< colp >-----#
    colp = OCT_STR(name=u'colp', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    colp._val = b'\x13'
    
    #-----< colr >-----#
    colr = OCT_STR(name=u'colr', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    colr._val = b'\x14'
    
    #-----< mci >-----#
    mci = OCT_STR(name=u'mci', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    mci._val = b'\x15'
    
    #-----< allNameIdentificationSS >-----#
    allNameIdentificationSS = OCT_STR(name=u'allNameIdentificationSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allNameIdentificationSS._val = b'\x18'
    
    #-----< cnap >-----#
    cnap = OCT_STR(name=u'cnap', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    cnap._val = b'\x19'
    
    #-----< allForwardingSS >-----#
    allForwardingSS = OCT_STR(name=u'allForwardingSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allForwardingSS._val = b' '
    
    #-----< cfu >-----#
    cfu = OCT_STR(name=u'cfu', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    cfu._val = b'!'
    
    #-----< allCondForwardingSS >-----#
    allCondForwardingSS = OCT_STR(name=u'allCondForwardingSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allCondForwardingSS._val = b'('
    
    #-----< cfb >-----#
    cfb = OCT_STR(name=u'cfb', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    cfb._val = b')'
    
    #-----< cfnry >-----#
    cfnry = OCT_STR(name=u'cfnry', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    cfnry._val = b'*'
    
    #-----< cfnrc >-----#
    cfnrc = OCT_STR(name=u'cfnrc', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    cfnrc._val = b'+'
    
    #-----< cd >-----#
    cd = OCT_STR(name=u'cd', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    cd._val = b'$'
    
    #-----< allCallOfferingSS >-----#
    allCallOfferingSS = OCT_STR(name=u'allCallOfferingSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allCallOfferingSS._val = b'0'
    
    #-----< ect >-----#
    ect = OCT_STR(name=u'ect', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    ect._val = b'1'
    
    #-----< mah >-----#
    mah = OCT_STR(name=u'mah', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    mah._val = b'2'
    
    #-----< allCallCompletionSS >-----#
    allCallCompletionSS = OCT_STR(name=u'allCallCompletionSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allCallCompletionSS._val = b'@'
    
    #-----< cw >-----#
    cw = OCT_STR(name=u'cw', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    cw._val = b'A'
    
    #-----< hold >-----#
    hold = OCT_STR(name=u'hold', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    hold._val = b'B'
    
    #-----< ccbs-A >-----#
    ccbs_A = OCT_STR(name=u'ccbs-A', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    ccbs_A._val = b'C'
    
    #-----< ccbs-B >-----#
    ccbs_B = OCT_STR(name=u'ccbs-B', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    ccbs_B._val = b'D'
    
    #-----< mc >-----#
    mc = OCT_STR(name=u'mc', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    mc._val = b'E'
    
    #-----< allMultiPartySS >-----#
    allMultiPartySS = OCT_STR(name=u'allMultiPartySS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allMultiPartySS._val = b'P'
    
    #-----< multiPTY >-----#
    multiPTY = OCT_STR(name=u'multiPTY', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    multiPTY._val = b'Q'
    
    #-----< allCommunityOfInterest-SS >-----#
    allCommunityOfInterest_SS = OCT_STR(name=u'allCommunityOfInterest-SS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allCommunityOfInterest_SS._val = b'`'
    
    #-----< cug >-----#
    cug = OCT_STR(name=u'cug', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    cug._val = b'a'
    
    #-----< allChargingSS >-----#
    allChargingSS = OCT_STR(name=u'allChargingSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allChargingSS._val = b'p'
    
    #-----< aoci >-----#
    aoci = OCT_STR(name=u'aoci', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    aoci._val = b'q'
    
    #-----< aocc >-----#
    aocc = OCT_STR(name=u'aocc', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    aocc._val = b'r'
    
    #-----< allAdditionalInfoTransferSS >-----#
    allAdditionalInfoTransferSS = OCT_STR(name=u'allAdditionalInfoTransferSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allAdditionalInfoTransferSS._val = b'\x80'
    
    #-----< uus1 >-----#
    uus1 = OCT_STR(name=u'uus1', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    uus1._val = b'\x81'
    
    #-----< uus2 >-----#
    uus2 = OCT_STR(name=u'uus2', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    uus2._val = b'\x82'
    
    #-----< uus3 >-----#
    uus3 = OCT_STR(name=u'uus3', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    uus3._val = b'\x83'
    
    #-----< allBarringSS >-----#
    allBarringSS = OCT_STR(name=u'allBarringSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allBarringSS._val = b'\x90'
    
    #-----< barringOfOutgoingCalls >-----#
    barringOfOutgoingCalls = OCT_STR(name=u'barringOfOutgoingCalls', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    barringOfOutgoingCalls._val = b'\x91'
    
    #-----< baoc >-----#
    baoc = OCT_STR(name=u'baoc', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    baoc._val = b'\x92'
    
    #-----< boic >-----#
    boic = OCT_STR(name=u'boic', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    boic._val = b'\x93'
    
    #-----< boicExHC >-----#
    boicExHC = OCT_STR(name=u'boicExHC', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    boicExHC._val = b'\x94'
    
    #-----< barringOfIncomingCalls >-----#
    barringOfIncomingCalls = OCT_STR(name=u'barringOfIncomingCalls', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    barringOfIncomingCalls._val = b'\x99'
    
    #-----< baic >-----#
    baic = OCT_STR(name=u'baic', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    baic._val = b'\x9a'
    
    #-----< bicRoam >-----#
    bicRoam = OCT_STR(name=u'bicRoam', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    bicRoam._val = b'\x9b'
    
    #-----< allPLMN-specificSS >-----#
    allPLMN_specificSS = OCT_STR(name=u'allPLMN-specificSS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allPLMN_specificSS._val = b'\xf0'
    
    #-----< plmn-specificSS-1 >-----#
    plmn_specificSS_1 = OCT_STR(name=u'plmn-specificSS-1', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_1._val = b'\xf1'
    
    #-----< plmn-specificSS-2 >-----#
    plmn_specificSS_2 = OCT_STR(name=u'plmn-specificSS-2', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_2._val = b'\xf2'
    
    #-----< plmn-specificSS-3 >-----#
    plmn_specificSS_3 = OCT_STR(name=u'plmn-specificSS-3', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_3._val = b'\xf3'
    
    #-----< plmn-specificSS-4 >-----#
    plmn_specificSS_4 = OCT_STR(name=u'plmn-specificSS-4', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_4._val = b'\xf4'
    
    #-----< plmn-specificSS-5 >-----#
    plmn_specificSS_5 = OCT_STR(name=u'plmn-specificSS-5', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_5._val = b'\xf5'
    
    #-----< plmn-specificSS-6 >-----#
    plmn_specificSS_6 = OCT_STR(name=u'plmn-specificSS-6', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_6._val = b'\xf6'
    
    #-----< plmn-specificSS-7 >-----#
    plmn_specificSS_7 = OCT_STR(name=u'plmn-specificSS-7', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_7._val = b'\xf7'
    
    #-----< plmn-specificSS-8 >-----#
    plmn_specificSS_8 = OCT_STR(name=u'plmn-specificSS-8', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_8._val = b'\xf8'
    
    #-----< plmn-specificSS-9 >-----#
    plmn_specificSS_9 = OCT_STR(name=u'plmn-specificSS-9', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_9._val = b'\xf9'
    
    #-----< plmn-specificSS-A >-----#
    plmn_specificSS_A = OCT_STR(name=u'plmn-specificSS-A', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_A._val = b'\xfa'
    
    #-----< plmn-specificSS-B >-----#
    plmn_specificSS_B = OCT_STR(name=u'plmn-specificSS-B', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_B._val = b'\xfb'
    
    #-----< plmn-specificSS-C >-----#
    plmn_specificSS_C = OCT_STR(name=u'plmn-specificSS-C', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_C._val = b'\xfc'
    
    #-----< plmn-specificSS-D >-----#
    plmn_specificSS_D = OCT_STR(name=u'plmn-specificSS-D', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_D._val = b'\xfd'
    
    #-----< plmn-specificSS-E >-----#
    plmn_specificSS_E = OCT_STR(name=u'plmn-specificSS-E', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_E._val = b'\xfe'
    
    #-----< plmn-specificSS-F >-----#
    plmn_specificSS_F = OCT_STR(name=u'plmn-specificSS-F', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmn_specificSS_F._val = b'\xff'
    
    #-----< allCallPrioritySS >-----#
    allCallPrioritySS = OCT_STR(name=u'allCallPrioritySS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allCallPrioritySS._val = b'\xa0'
    
    #-----< emlpp >-----#
    emlpp = OCT_STR(name=u'emlpp', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    emlpp._val = b'\xa1'
    
    #-----< allLCSPrivacyException >-----#
    allLCSPrivacyException = OCT_STR(name=u'allLCSPrivacyException', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allLCSPrivacyException._val = b'\xb0'
    
    #-----< universal >-----#
    universal = OCT_STR(name=u'universal', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    universal._val = b'\xb1'
    
    #-----< callSessionRelated >-----#
    callSessionRelated = OCT_STR(name=u'callSessionRelated', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    callSessionRelated._val = b'\xb2'
    
    #-----< callSessionUnrelated >-----#
    callSessionUnrelated = OCT_STR(name=u'callSessionUnrelated', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    callSessionUnrelated._val = b'\xb3'
    
    #-----< plmnoperator >-----#
    plmnoperator = OCT_STR(name=u'plmnoperator', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    plmnoperator._val = b'\xb4'
    
    #-----< serviceType >-----#
    serviceType = OCT_STR(name=u'serviceType', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    serviceType._val = b'\xb5'
    
    #-----< allMOLR-SS >-----#
    allMOLR_SS = OCT_STR(name=u'allMOLR-SS', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    allMOLR_SS._val = b'\xc0'
    
    #-----< basicSelfLocation >-----#
    basicSelfLocation = OCT_STR(name=u'basicSelfLocation', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    basicSelfLocation._val = b'\xc1'
    
    #-----< autonomousSelfLocation >-----#
    autonomousSelfLocation = OCT_STR(name=u'autonomousSelfLocation', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    autonomousSelfLocation._val = b'\xc2'
    
    #-----< transferToThirdParty >-----#
    transferToThirdParty = OCT_STR(name=u'transferToThirdParty', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    transferToThirdParty._val = b'\xc3'
    
    _all_ = [
        SS_Code,
        allSS,
        allLineIdentificationSS,
        clip,
        clir,
        colp,
        colr,
        mci,
        allNameIdentificationSS,
        cnap,
        allForwardingSS,
        cfu,
        allCondForwardingSS,
        cfb,
        cfnry,
        cfnrc,
        cd,
        allCallOfferingSS,
        ect,
        mah,
        allCallCompletionSS,
        cw,
        hold,
        ccbs_A,
        ccbs_B,
        mc,
        allMultiPartySS,
        multiPTY,
        allCommunityOfInterest_SS,
        cug,
        allChargingSS,
        aoci,
        aocc,
        allAdditionalInfoTransferSS,
        uus1,
        uus2,
        uus3,
        allBarringSS,
        barringOfOutgoingCalls,
        baoc,
        boic,
        boicExHC,
        barringOfIncomingCalls,
        baic,
        bicRoam,
        allPLMN_specificSS,
        plmn_specificSS_1,
        plmn_specificSS_2,
        plmn_specificSS_3,
        plmn_specificSS_4,
        plmn_specificSS_5,
        plmn_specificSS_6,
        plmn_specificSS_7,
        plmn_specificSS_8,
        plmn_specificSS_9,
        plmn_specificSS_A,
        plmn_specificSS_B,
        plmn_specificSS_C,
        plmn_specificSS_D,
        plmn_specificSS_E,
        plmn_specificSS_F,
        allCallPrioritySS,
        emlpp,
        allLCSPrivacyException,
        universal,
        callSessionRelated,
        callSessionUnrelated,
        plmnoperator,
        serviceType,
        allMOLR_SS,
        basicSelfLocation,
        autonomousSelfLocation,
        transferToThirdParty,
    ]

class MAP_CommonDataTypes:

    _name_  = u'MAP-CommonDataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 18, 16]
    
    _obj_ = [
        u'TBCD-STRING',
        u'DiameterIdentity',
        u'AddressString',
        u'maxAddressLength',
        u'ISDN-AddressString',
        u'maxISDN-AddressLength',
        u'FTN-AddressString',
        u'maxFTN-AddressLength',
        u'ISDN-SubaddressString',
        u'maxISDN-SubaddressLength',
        u'ExternalSignalInfo',
        u'SignalInfo',
        u'maxSignalInfoLength',
        u'ProtocolId',
        u'Ext-ExternalSignalInfo',
        u'Ext-ProtocolId',
        u'AccessNetworkSignalInfo',
        u'LongSignalInfo',
        u'maxLongSignalInfoLength',
        u'AccessNetworkProtocolId',
        u'AlertingPattern',
        u'alertingLevel-0',
        u'alertingLevel-1',
        u'alertingLevel-2',
        u'alertingCategory-1',
        u'alertingCategory-2',
        u'alertingCategory-3',
        u'alertingCategory-4',
        u'alertingCategory-5',
        u'GSN-Address',
        u'Time',
        u'IMSI',
        u'Identity',
        u'IMSI-WithLMSI',
        u'ASCI-CallReference',
        u'TMSI',
        u'SubscriberId',
        u'IMEI',
        u'HLR-Id',
        u'HLR-List',
        u'maxNumOfHLR-Id',
        u'LMSI',
        u'GlobalCellId',
        u'NetworkResource',
        u'AdditionalNetworkResource',
        u'NAEA-PreferredCI',
        u'NAEA-CIC',
        u'SubscriberIdentity',
        u'LCSClientExternalID',
        u'LCSClientInternalID',
        u'LCSServiceTypeID',
        u'emergencyServices',
        u'emergencyAlertServices',
        u'personTracking',
        u'fleetManagement',
        u'assetManagement',
        u'trafficCongestionReporting',
        u'roadsideAssistance',
        u'routingToNearestCommercialEnterprise',
        u'navigation',
        u'citySightseeing',
        u'localizedAdvertising',
        u'mobileYellowPages',
        u'trafficAndPublicTransportationInfo',
        u'weather',
        u'assetAndServiceFinding',
        u'gaming',
        u'findYourFriend',
        u'dating',
        u'chatting',
        u'routeFinding',
        u'whereAmI',
        u'serv64',
        u'serv65',
        u'serv66',
        u'serv67',
        u'serv68',
        u'serv69',
        u'serv70',
        u'serv71',
        u'serv72',
        u'serv73',
        u'serv74',
        u'serv75',
        u'serv76',
        u'serv77',
        u'serv78',
        u'serv79',
        u'serv80',
        u'serv81',
        u'serv82',
        u'serv83',
        u'serv84',
        u'serv85',
        u'serv86',
        u'serv87',
        u'serv88',
        u'serv89',
        u'serv90',
        u'serv91',
        u'serv92',
        u'serv93',
        u'serv94',
        u'serv95',
        u'serv96',
        u'serv97',
        u'serv98',
        u'serv99',
        u'serv100',
        u'serv101',
        u'serv102',
        u'serv103',
        u'serv104',
        u'serv105',
        u'serv106',
        u'serv107',
        u'serv108',
        u'serv109',
        u'serv110',
        u'serv111',
        u'serv112',
        u'serv113',
        u'serv114',
        u'serv115',
        u'serv116',
        u'serv117',
        u'serv118',
        u'serv119',
        u'serv120',
        u'serv121',
        u'serv122',
        u'serv123',
        u'serv124',
        u'serv125',
        u'serv126',
        u'serv127',
        u'PLMN-Id',
        u'E-UTRAN-CGI',
        u'TA-Id',
        u'RAIdentity',
        u'NetworkNodeDiameterAddress',
        u'CellGlobalIdOrServiceAreaIdOrLAI',
        u'CellGlobalIdOrServiceAreaIdFixedLength',
        u'LAIFixedLength',
        u'BasicServiceCode',
        u'Ext-BasicServiceCode',
        u'EMLPP-Info',
        u'EMLPP-Priority',
        u'priorityLevelA',
        u'priorityLevelB',
        u'priorityLevel0',
        u'priorityLevel1',
        u'priorityLevel2',
        u'priorityLevel3',
        u'priorityLevel4',
        u'MC-SS-Info',
        u'MaxMC-Bearers',
        u'MC-Bearers',
        u'maxNumOfMC-Bearers',
        u'Ext-SS-Status',
        u'AgeOfLocationInformation',
        ]
    _type_ = [
        u'TBCD-STRING',
        u'DiameterIdentity',
        u'AddressString',
        u'ISDN-AddressString',
        u'FTN-AddressString',
        u'ISDN-SubaddressString',
        u'ExternalSignalInfo',
        u'SignalInfo',
        u'ProtocolId',
        u'Ext-ExternalSignalInfo',
        u'Ext-ProtocolId',
        u'AccessNetworkSignalInfo',
        u'LongSignalInfo',
        u'AccessNetworkProtocolId',
        u'AlertingPattern',
        u'GSN-Address',
        u'Time',
        u'IMSI',
        u'Identity',
        u'IMSI-WithLMSI',
        u'ASCI-CallReference',
        u'TMSI',
        u'SubscriberId',
        u'IMEI',
        u'HLR-Id',
        u'HLR-List',
        u'LMSI',
        u'GlobalCellId',
        u'NetworkResource',
        u'AdditionalNetworkResource',
        u'NAEA-PreferredCI',
        u'NAEA-CIC',
        u'SubscriberIdentity',
        u'LCSClientExternalID',
        u'LCSClientInternalID',
        u'LCSServiceTypeID',
        u'PLMN-Id',
        u'E-UTRAN-CGI',
        u'TA-Id',
        u'RAIdentity',
        u'NetworkNodeDiameterAddress',
        u'CellGlobalIdOrServiceAreaIdOrLAI',
        u'CellGlobalIdOrServiceAreaIdFixedLength',
        u'LAIFixedLength',
        u'BasicServiceCode',
        u'Ext-BasicServiceCode',
        u'EMLPP-Info',
        u'EMLPP-Priority',
        u'MC-SS-Info',
        u'MaxMC-Bearers',
        u'MC-Bearers',
        u'Ext-SS-Status',
        u'AgeOfLocationInformation',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxAddressLength',
        u'maxISDN-AddressLength',
        u'maxFTN-AddressLength',
        u'maxISDN-SubaddressLength',
        u'maxSignalInfoLength',
        u'maxLongSignalInfoLength',
        u'alertingLevel-0',
        u'alertingLevel-1',
        u'alertingLevel-2',
        u'alertingCategory-1',
        u'alertingCategory-2',
        u'alertingCategory-3',
        u'alertingCategory-4',
        u'alertingCategory-5',
        u'maxNumOfHLR-Id',
        u'emergencyServices',
        u'emergencyAlertServices',
        u'personTracking',
        u'fleetManagement',
        u'assetManagement',
        u'trafficCongestionReporting',
        u'roadsideAssistance',
        u'routingToNearestCommercialEnterprise',
        u'navigation',
        u'citySightseeing',
        u'localizedAdvertising',
        u'mobileYellowPages',
        u'trafficAndPublicTransportationInfo',
        u'weather',
        u'assetAndServiceFinding',
        u'gaming',
        u'findYourFriend',
        u'dating',
        u'chatting',
        u'routeFinding',
        u'whereAmI',
        u'serv64',
        u'serv65',
        u'serv66',
        u'serv67',
        u'serv68',
        u'serv69',
        u'serv70',
        u'serv71',
        u'serv72',
        u'serv73',
        u'serv74',
        u'serv75',
        u'serv76',
        u'serv77',
        u'serv78',
        u'serv79',
        u'serv80',
        u'serv81',
        u'serv82',
        u'serv83',
        u'serv84',
        u'serv85',
        u'serv86',
        u'serv87',
        u'serv88',
        u'serv89',
        u'serv90',
        u'serv91',
        u'serv92',
        u'serv93',
        u'serv94',
        u'serv95',
        u'serv96',
        u'serv97',
        u'serv98',
        u'serv99',
        u'serv100',
        u'serv101',
        u'serv102',
        u'serv103',
        u'serv104',
        u'serv105',
        u'serv106',
        u'serv107',
        u'serv108',
        u'serv109',
        u'serv110',
        u'serv111',
        u'serv112',
        u'serv113',
        u'serv114',
        u'serv115',
        u'serv116',
        u'serv117',
        u'serv118',
        u'serv119',
        u'serv120',
        u'serv121',
        u'serv122',
        u'serv123',
        u'serv124',
        u'serv125',
        u'serv126',
        u'serv127',
        u'priorityLevelA',
        u'priorityLevelB',
        u'priorityLevel0',
        u'priorityLevel1',
        u'priorityLevel2',
        u'priorityLevel3',
        u'priorityLevel4',
        u'maxNumOfMC-Bearers',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< TBCD-STRING >-----#
    TBCD_STRING = OCT_STR(name=u'TBCD-STRING', mode=MODE_TYPE)
    
    #-----< DiameterIdentity >-----#
    DiameterIdentity = OCT_STR(name=u'DiameterIdentity', mode=MODE_TYPE)
    DiameterIdentity._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=9, ub=255)], ev=None, er=[])
    
    #-----< AddressString >-----#
    AddressString = OCT_STR(name=u'AddressString', mode=MODE_TYPE)
    AddressString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    
    #-----< maxAddressLength >-----#
    maxAddressLength = INT(name=u'maxAddressLength', mode=MODE_VALUE)
    maxAddressLength._val = 20
    
    #-----< ISDN-AddressString >-----#
    ISDN_AddressString = OCT_STR(name=u'ISDN-AddressString', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AddressString')))
    ISDN_AddressString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9)], ev=None, er=[])
    
    #-----< maxISDN-AddressLength >-----#
    maxISDN_AddressLength = INT(name=u'maxISDN-AddressLength', mode=MODE_VALUE)
    maxISDN_AddressLength._val = 9
    
    #-----< FTN-AddressString >-----#
    FTN_AddressString = OCT_STR(name=u'FTN-AddressString', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AddressString')))
    FTN_AddressString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    
    #-----< maxFTN-AddressLength >-----#
    maxFTN_AddressLength = INT(name=u'maxFTN-AddressLength', mode=MODE_VALUE)
    maxFTN_AddressLength._val = 15
    
    #-----< ISDN-SubaddressString >-----#
    ISDN_SubaddressString = OCT_STR(name=u'ISDN-SubaddressString', mode=MODE_TYPE)
    ISDN_SubaddressString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=21)], ev=None, er=[])
    
    #-----< maxISDN-SubaddressLength >-----#
    maxISDN_SubaddressLength = INT(name=u'maxISDN-SubaddressLength', mode=MODE_VALUE)
    maxISDN_SubaddressLength._val = 21
    
    #-----< ExternalSignalInfo >-----#
    ExternalSignalInfo = SEQ(name=u'ExternalSignalInfo', mode=MODE_TYPE)
    _ExternalSignalInfo_protocolId = ENUM(name=u'protocolId', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ProtocolId')))
    _ExternalSignalInfo_signalInfo = OCT_STR(name=u'signalInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'SignalInfo')))
    _ExternalSignalInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ExternalSignalInfo._cont = ASN1Dict([
        (u'protocolId', _ExternalSignalInfo_protocolId),
        (u'signalInfo', _ExternalSignalInfo_signalInfo),
        (u'extensionContainer', _ExternalSignalInfo_extensionContainer),
        ])
    ExternalSignalInfo._ext = []
    
    #-----< SignalInfo >-----#
    SignalInfo = OCT_STR(name=u'SignalInfo', mode=MODE_TYPE)
    SignalInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    
    #-----< maxSignalInfoLength >-----#
    maxSignalInfoLength = INT(name=u'maxSignalInfoLength', mode=MODE_VALUE)
    maxSignalInfoLength._val = 200
    
    #-----< ProtocolId >-----#
    ProtocolId = ENUM(name=u'ProtocolId', mode=MODE_TYPE)
    ProtocolId._cont = ASN1Dict([(u'gsm-0408', 1), (u'gsm-0806', 2), (u'gsm-BSSMAP', 3), (u'ets-300102-1', 4)])
    ProtocolId._ext = None
    
    #-----< Ext-ExternalSignalInfo >-----#
    Ext_ExternalSignalInfo = SEQ(name=u'Ext-ExternalSignalInfo', mode=MODE_TYPE)
    _Ext_ExternalSignalInfo_ext_ProtocolId = ENUM(name=u'ext-ProtocolId', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-ProtocolId')))
    _Ext_ExternalSignalInfo_signalInfo = OCT_STR(name=u'signalInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'SignalInfo')))
    _Ext_ExternalSignalInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    Ext_ExternalSignalInfo._cont = ASN1Dict([
        (u'ext-ProtocolId', _Ext_ExternalSignalInfo_ext_ProtocolId),
        (u'signalInfo', _Ext_ExternalSignalInfo_signalInfo),
        (u'extensionContainer', _Ext_ExternalSignalInfo_extensionContainer),
        ])
    Ext_ExternalSignalInfo._ext = []
    
    #-----< Ext-ProtocolId >-----#
    Ext_ProtocolId = ENUM(name=u'Ext-ProtocolId', mode=MODE_TYPE)
    Ext_ProtocolId._cont = ASN1Dict([(u'ets-300356', 1)])
    Ext_ProtocolId._ext = []
    
    #-----< AccessNetworkSignalInfo >-----#
    AccessNetworkSignalInfo = SEQ(name=u'AccessNetworkSignalInfo', mode=MODE_TYPE)
    _AccessNetworkSignalInfo_accessNetworkProtocolId = ENUM(name=u'accessNetworkProtocolId', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AccessNetworkProtocolId')))
    _AccessNetworkSignalInfo_signalInfo = OCT_STR(name=u'signalInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LongSignalInfo')))
    _AccessNetworkSignalInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    AccessNetworkSignalInfo._cont = ASN1Dict([
        (u'accessNetworkProtocolId', _AccessNetworkSignalInfo_accessNetworkProtocolId),
        (u'signalInfo', _AccessNetworkSignalInfo_signalInfo),
        (u'extensionContainer', _AccessNetworkSignalInfo_extensionContainer),
        ])
    AccessNetworkSignalInfo._ext = []
    
    #-----< LongSignalInfo >-----#
    LongSignalInfo = OCT_STR(name=u'LongSignalInfo', mode=MODE_TYPE)
    LongSignalInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2560)], ev=None, er=[])
    
    #-----< maxLongSignalInfoLength >-----#
    maxLongSignalInfoLength = INT(name=u'maxLongSignalInfoLength', mode=MODE_VALUE)
    maxLongSignalInfoLength._val = 2560
    
    #-----< AccessNetworkProtocolId >-----#
    AccessNetworkProtocolId = ENUM(name=u'AccessNetworkProtocolId', mode=MODE_TYPE)
    AccessNetworkProtocolId._cont = ASN1Dict([(u'ts3G-48006', 1), (u'ts3G-25413', 2)])
    AccessNetworkProtocolId._ext = []
    
    #-----< AlertingPattern >-----#
    AlertingPattern = OCT_STR(name=u'AlertingPattern', mode=MODE_TYPE)
    AlertingPattern._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< alertingLevel-0 >-----#
    alertingLevel_0 = OCT_STR(name=u'alertingLevel-0', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')))
    alertingLevel_0._val = b'\x00'
    
    #-----< alertingLevel-1 >-----#
    alertingLevel_1 = OCT_STR(name=u'alertingLevel-1', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')))
    alertingLevel_1._val = b'\x01'
    
    #-----< alertingLevel-2 >-----#
    alertingLevel_2 = OCT_STR(name=u'alertingLevel-2', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')))
    alertingLevel_2._val = b'\x02'
    
    #-----< alertingCategory-1 >-----#
    alertingCategory_1 = OCT_STR(name=u'alertingCategory-1', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')))
    alertingCategory_1._val = b'\x04'
    
    #-----< alertingCategory-2 >-----#
    alertingCategory_2 = OCT_STR(name=u'alertingCategory-2', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')))
    alertingCategory_2._val = b'\x05'
    
    #-----< alertingCategory-3 >-----#
    alertingCategory_3 = OCT_STR(name=u'alertingCategory-3', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')))
    alertingCategory_3._val = b'\x06'
    
    #-----< alertingCategory-4 >-----#
    alertingCategory_4 = OCT_STR(name=u'alertingCategory-4', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')))
    alertingCategory_4._val = b'\x07'
    
    #-----< alertingCategory-5 >-----#
    alertingCategory_5 = OCT_STR(name=u'alertingCategory-5', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')))
    alertingCategory_5._val = b'\x08'
    
    #-----< GSN-Address >-----#
    GSN_Address = OCT_STR(name=u'GSN-Address', mode=MODE_TYPE)
    GSN_Address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=5, ub=17)], ev=None, er=[])
    
    #-----< Time >-----#
    Time = OCT_STR(name=u'Time', mode=MODE_TYPE)
    Time._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< IMSI >-----#
    IMSI = OCT_STR(name=u'IMSI', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'TBCD-STRING')))
    IMSI._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=8)], ev=None, er=[])
    
    #-----< Identity >-----#
    Identity = CHOICE(name=u'Identity', mode=MODE_TYPE)
    _Identity_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _Identity_imsi_WithLMSI = SEQ(name=u'imsi-WithLMSI', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI-WithLMSI')))
    Identity._cont = ASN1Dict([
        (u'imsi', _Identity_imsi),
        (u'imsi-WithLMSI', _Identity_imsi_WithLMSI),
        ])
    Identity._ext = None
    
    #-----< IMSI-WithLMSI >-----#
    IMSI_WithLMSI = SEQ(name=u'IMSI-WithLMSI', mode=MODE_TYPE)
    _IMSI_WithLMSI_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _IMSI_WithLMSI_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LMSI')))
    IMSI_WithLMSI._cont = ASN1Dict([
        (u'imsi', _IMSI_WithLMSI_imsi),
        (u'lmsi', _IMSI_WithLMSI_lmsi),
        ])
    IMSI_WithLMSI._ext = []
    
    #-----< ASCI-CallReference >-----#
    ASCI_CallReference = OCT_STR(name=u'ASCI-CallReference', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'TBCD-STRING')))
    ASCI_CallReference._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< TMSI >-----#
    TMSI = OCT_STR(name=u'TMSI', mode=MODE_TYPE)
    TMSI._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< SubscriberId >-----#
    SubscriberId = CHOICE(name=u'SubscriberId', mode=MODE_TYPE)
    _SubscriberId_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _SubscriberId_tmsi = OCT_STR(name=u'tmsi', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'TMSI')))
    SubscriberId._cont = ASN1Dict([
        (u'imsi', _SubscriberId_imsi),
        (u'tmsi', _SubscriberId_tmsi),
        ])
    SubscriberId._ext = None
    
    #-----< IMEI >-----#
    IMEI = OCT_STR(name=u'IMEI', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'TBCD-STRING')))
    IMEI._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    
    #-----< HLR-Id >-----#
    HLR_Id = OCT_STR(name=u'HLR-Id', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    
    #-----< HLR-List >-----#
    HLR_List = SEQ_OF(name=u'HLR-List', mode=MODE_TYPE)
    _HLR_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'HLR-Id')))
    HLR_List._cont = _HLR_List__item_
    HLR_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< maxNumOfHLR-Id >-----#
    maxNumOfHLR_Id = INT(name=u'maxNumOfHLR-Id', mode=MODE_VALUE)
    maxNumOfHLR_Id._val = 50
    
    #-----< LMSI >-----#
    LMSI = OCT_STR(name=u'LMSI', mode=MODE_TYPE)
    LMSI._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< GlobalCellId >-----#
    GlobalCellId = OCT_STR(name=u'GlobalCellId', mode=MODE_TYPE)
    GlobalCellId._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=5, ub=7)], ev=None, er=[])
    
    #-----< NetworkResource >-----#
    NetworkResource = ENUM(name=u'NetworkResource', mode=MODE_TYPE)
    NetworkResource._cont = ASN1Dict([(u'plmn', 0), (u'hlr', 1), (u'vlr', 2), (u'pvlr', 3), (u'controllingMSC', 4), (u'vmsc', 5), (u'eir', 6), (u'rss', 7)])
    NetworkResource._ext = None
    
    #-----< AdditionalNetworkResource >-----#
    AdditionalNetworkResource = ENUM(name=u'AdditionalNetworkResource', mode=MODE_TYPE)
    AdditionalNetworkResource._cont = ASN1Dict([(u'sgsn', 0), (u'ggsn', 1), (u'gmlc', 2), (u'gsmSCF', 3), (u'nplr', 4), (u'auc', 5), (u'ue', 6), (u'mme', 7)])
    AdditionalNetworkResource._ext = [u'ue', u'mme']
    
    #-----< NAEA-PreferredCI >-----#
    NAEA_PreferredCI = SEQ(name=u'NAEA-PreferredCI', mode=MODE_TYPE)
    _NAEA_PreferredCI_naea_PreferredCIC = OCT_STR(name=u'naea-PreferredCIC', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'NAEA-CIC')))
    _NAEA_PreferredCI_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    NAEA_PreferredCI._cont = ASN1Dict([
        (u'naea-PreferredCIC', _NAEA_PreferredCI_naea_PreferredCIC),
        (u'extensionContainer', _NAEA_PreferredCI_extensionContainer),
        ])
    NAEA_PreferredCI._ext = []
    
    #-----< NAEA-CIC >-----#
    NAEA_CIC = OCT_STR(name=u'NAEA-CIC', mode=MODE_TYPE)
    NAEA_CIC._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< SubscriberIdentity >-----#
    SubscriberIdentity = CHOICE(name=u'SubscriberIdentity', mode=MODE_TYPE)
    _SubscriberIdentity_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _SubscriberIdentity_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    SubscriberIdentity._cont = ASN1Dict([
        (u'imsi', _SubscriberIdentity_imsi),
        (u'msisdn', _SubscriberIdentity_msisdn),
        ])
    SubscriberIdentity._ext = None
    
    #-----< LCSClientExternalID >-----#
    LCSClientExternalID = SEQ(name=u'LCSClientExternalID', mode=MODE_TYPE)
    _LCSClientExternalID_externalAddress = OCT_STR(name=u'externalAddress', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _LCSClientExternalID_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    LCSClientExternalID._cont = ASN1Dict([
        (u'externalAddress', _LCSClientExternalID_externalAddress),
        (u'extensionContainer', _LCSClientExternalID_extensionContainer),
        ])
    LCSClientExternalID._ext = []
    
    #-----< LCSClientInternalID >-----#
    LCSClientInternalID = ENUM(name=u'LCSClientInternalID', mode=MODE_TYPE)
    LCSClientInternalID._cont = ASN1Dict([(u'broadcastService', 0), (u'o-andM-HPLMN', 1), (u'o-andM-VPLMN', 2), (u'anonymousLocation', 3), (u'targetMSsubscribedService', 4)])
    LCSClientInternalID._ext = []
    
    #-----< LCSServiceTypeID >-----#
    LCSServiceTypeID = INT(name=u'LCSServiceTypeID', mode=MODE_TYPE)
    LCSServiceTypeID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=127)], ev=None, er=[])
    
    #-----< emergencyServices >-----#
    emergencyServices = INT(name=u'emergencyServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    emergencyServices._val = 0
    
    #-----< emergencyAlertServices >-----#
    emergencyAlertServices = INT(name=u'emergencyAlertServices', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    emergencyAlertServices._val = 1
    
    #-----< personTracking >-----#
    personTracking = INT(name=u'personTracking', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    personTracking._val = 2
    
    #-----< fleetManagement >-----#
    fleetManagement = INT(name=u'fleetManagement', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    fleetManagement._val = 3
    
    #-----< assetManagement >-----#
    assetManagement = INT(name=u'assetManagement', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    assetManagement._val = 4
    
    #-----< trafficCongestionReporting >-----#
    trafficCongestionReporting = INT(name=u'trafficCongestionReporting', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    trafficCongestionReporting._val = 5
    
    #-----< roadsideAssistance >-----#
    roadsideAssistance = INT(name=u'roadsideAssistance', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    roadsideAssistance._val = 6
    
    #-----< routingToNearestCommercialEnterprise >-----#
    routingToNearestCommercialEnterprise = INT(name=u'routingToNearestCommercialEnterprise', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    routingToNearestCommercialEnterprise._val = 7
    
    #-----< navigation >-----#
    navigation = INT(name=u'navigation', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    navigation._val = 8
    
    #-----< citySightseeing >-----#
    citySightseeing = INT(name=u'citySightseeing', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    citySightseeing._val = 9
    
    #-----< localizedAdvertising >-----#
    localizedAdvertising = INT(name=u'localizedAdvertising', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    localizedAdvertising._val = 10
    
    #-----< mobileYellowPages >-----#
    mobileYellowPages = INT(name=u'mobileYellowPages', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    mobileYellowPages._val = 11
    
    #-----< trafficAndPublicTransportationInfo >-----#
    trafficAndPublicTransportationInfo = INT(name=u'trafficAndPublicTransportationInfo', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    trafficAndPublicTransportationInfo._val = 12
    
    #-----< weather >-----#
    weather = INT(name=u'weather', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    weather._val = 13
    
    #-----< assetAndServiceFinding >-----#
    assetAndServiceFinding = INT(name=u'assetAndServiceFinding', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    assetAndServiceFinding._val = 14
    
    #-----< gaming >-----#
    gaming = INT(name=u'gaming', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    gaming._val = 15
    
    #-----< findYourFriend >-----#
    findYourFriend = INT(name=u'findYourFriend', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    findYourFriend._val = 16
    
    #-----< dating >-----#
    dating = INT(name=u'dating', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    dating._val = 17
    
    #-----< chatting >-----#
    chatting = INT(name=u'chatting', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    chatting._val = 18
    
    #-----< routeFinding >-----#
    routeFinding = INT(name=u'routeFinding', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    routeFinding._val = 19
    
    #-----< whereAmI >-----#
    whereAmI = INT(name=u'whereAmI', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    whereAmI._val = 20
    
    #-----< serv64 >-----#
    serv64 = INT(name=u'serv64', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv64._val = 64
    
    #-----< serv65 >-----#
    serv65 = INT(name=u'serv65', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv65._val = 65
    
    #-----< serv66 >-----#
    serv66 = INT(name=u'serv66', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv66._val = 66
    
    #-----< serv67 >-----#
    serv67 = INT(name=u'serv67', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv67._val = 67
    
    #-----< serv68 >-----#
    serv68 = INT(name=u'serv68', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv68._val = 68
    
    #-----< serv69 >-----#
    serv69 = INT(name=u'serv69', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv69._val = 69
    
    #-----< serv70 >-----#
    serv70 = INT(name=u'serv70', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv70._val = 70
    
    #-----< serv71 >-----#
    serv71 = INT(name=u'serv71', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv71._val = 71
    
    #-----< serv72 >-----#
    serv72 = INT(name=u'serv72', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv72._val = 72
    
    #-----< serv73 >-----#
    serv73 = INT(name=u'serv73', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv73._val = 73
    
    #-----< serv74 >-----#
    serv74 = INT(name=u'serv74', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv74._val = 74
    
    #-----< serv75 >-----#
    serv75 = INT(name=u'serv75', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv75._val = 75
    
    #-----< serv76 >-----#
    serv76 = INT(name=u'serv76', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv76._val = 76
    
    #-----< serv77 >-----#
    serv77 = INT(name=u'serv77', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv77._val = 77
    
    #-----< serv78 >-----#
    serv78 = INT(name=u'serv78', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv78._val = 78
    
    #-----< serv79 >-----#
    serv79 = INT(name=u'serv79', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv79._val = 79
    
    #-----< serv80 >-----#
    serv80 = INT(name=u'serv80', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv80._val = 80
    
    #-----< serv81 >-----#
    serv81 = INT(name=u'serv81', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv81._val = 81
    
    #-----< serv82 >-----#
    serv82 = INT(name=u'serv82', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv82._val = 82
    
    #-----< serv83 >-----#
    serv83 = INT(name=u'serv83', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv83._val = 83
    
    #-----< serv84 >-----#
    serv84 = INT(name=u'serv84', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv84._val = 84
    
    #-----< serv85 >-----#
    serv85 = INT(name=u'serv85', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv85._val = 85
    
    #-----< serv86 >-----#
    serv86 = INT(name=u'serv86', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv86._val = 86
    
    #-----< serv87 >-----#
    serv87 = INT(name=u'serv87', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv87._val = 87
    
    #-----< serv88 >-----#
    serv88 = INT(name=u'serv88', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv88._val = 88
    
    #-----< serv89 >-----#
    serv89 = INT(name=u'serv89', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv89._val = 89
    
    #-----< serv90 >-----#
    serv90 = INT(name=u'serv90', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv90._val = 90
    
    #-----< serv91 >-----#
    serv91 = INT(name=u'serv91', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv91._val = 91
    
    #-----< serv92 >-----#
    serv92 = INT(name=u'serv92', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv92._val = 92
    
    #-----< serv93 >-----#
    serv93 = INT(name=u'serv93', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv93._val = 93
    
    #-----< serv94 >-----#
    serv94 = INT(name=u'serv94', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv94._val = 94
    
    #-----< serv95 >-----#
    serv95 = INT(name=u'serv95', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv95._val = 95
    
    #-----< serv96 >-----#
    serv96 = INT(name=u'serv96', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv96._val = 96
    
    #-----< serv97 >-----#
    serv97 = INT(name=u'serv97', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv97._val = 97
    
    #-----< serv98 >-----#
    serv98 = INT(name=u'serv98', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv98._val = 98
    
    #-----< serv99 >-----#
    serv99 = INT(name=u'serv99', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv99._val = 99
    
    #-----< serv100 >-----#
    serv100 = INT(name=u'serv100', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv100._val = 100
    
    #-----< serv101 >-----#
    serv101 = INT(name=u'serv101', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv101._val = 101
    
    #-----< serv102 >-----#
    serv102 = INT(name=u'serv102', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv102._val = 102
    
    #-----< serv103 >-----#
    serv103 = INT(name=u'serv103', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv103._val = 103
    
    #-----< serv104 >-----#
    serv104 = INT(name=u'serv104', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv104._val = 104
    
    #-----< serv105 >-----#
    serv105 = INT(name=u'serv105', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv105._val = 105
    
    #-----< serv106 >-----#
    serv106 = INT(name=u'serv106', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv106._val = 106
    
    #-----< serv107 >-----#
    serv107 = INT(name=u'serv107', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv107._val = 107
    
    #-----< serv108 >-----#
    serv108 = INT(name=u'serv108', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv108._val = 108
    
    #-----< serv109 >-----#
    serv109 = INT(name=u'serv109', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv109._val = 109
    
    #-----< serv110 >-----#
    serv110 = INT(name=u'serv110', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv110._val = 110
    
    #-----< serv111 >-----#
    serv111 = INT(name=u'serv111', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv111._val = 111
    
    #-----< serv112 >-----#
    serv112 = INT(name=u'serv112', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv112._val = 112
    
    #-----< serv113 >-----#
    serv113 = INT(name=u'serv113', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv113._val = 113
    
    #-----< serv114 >-----#
    serv114 = INT(name=u'serv114', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv114._val = 114
    
    #-----< serv115 >-----#
    serv115 = INT(name=u'serv115', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv115._val = 115
    
    #-----< serv116 >-----#
    serv116 = INT(name=u'serv116', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv116._val = 116
    
    #-----< serv117 >-----#
    serv117 = INT(name=u'serv117', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv117._val = 117
    
    #-----< serv118 >-----#
    serv118 = INT(name=u'serv118', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv118._val = 118
    
    #-----< serv119 >-----#
    serv119 = INT(name=u'serv119', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv119._val = 119
    
    #-----< serv120 >-----#
    serv120 = INT(name=u'serv120', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv120._val = 120
    
    #-----< serv121 >-----#
    serv121 = INT(name=u'serv121', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv121._val = 121
    
    #-----< serv122 >-----#
    serv122 = INT(name=u'serv122', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv122._val = 122
    
    #-----< serv123 >-----#
    serv123 = INT(name=u'serv123', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv123._val = 123
    
    #-----< serv124 >-----#
    serv124 = INT(name=u'serv124', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv124._val = 124
    
    #-----< serv125 >-----#
    serv125 = INT(name=u'serv125', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv125._val = 125
    
    #-----< serv126 >-----#
    serv126 = INT(name=u'serv126', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv126._val = 126
    
    #-----< serv127 >-----#
    serv127 = INT(name=u'serv127', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    serv127._val = 127
    
    #-----< PLMN-Id >-----#
    PLMN_Id = OCT_STR(name=u'PLMN-Id', mode=MODE_TYPE)
    PLMN_Id._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< E-UTRAN-CGI >-----#
    E_UTRAN_CGI = OCT_STR(name=u'E-UTRAN-CGI', mode=MODE_TYPE)
    E_UTRAN_CGI._const_sz = ASN1Set(rv=[7], rr=[], ev=None, er=[])
    
    #-----< TA-Id >-----#
    TA_Id = OCT_STR(name=u'TA-Id', mode=MODE_TYPE)
    TA_Id._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    
    #-----< RAIdentity >-----#
    RAIdentity = OCT_STR(name=u'RAIdentity', mode=MODE_TYPE)
    RAIdentity._const_sz = ASN1Set(rv=[6], rr=[], ev=None, er=[])
    
    #-----< NetworkNodeDiameterAddress >-----#
    NetworkNodeDiameterAddress = SEQ(name=u'NetworkNodeDiameterAddress', mode=MODE_TYPE)
    _NetworkNodeDiameterAddress_diameter_Name = OCT_STR(name=u'diameter-Name', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'DiameterIdentity')))
    _NetworkNodeDiameterAddress_diameter_Realm = OCT_STR(name=u'diameter-Realm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'DiameterIdentity')))
    NetworkNodeDiameterAddress._cont = ASN1Dict([
        (u'diameter-Name', _NetworkNodeDiameterAddress_diameter_Name),
        (u'diameter-Realm', _NetworkNodeDiameterAddress_diameter_Realm),
        ])
    NetworkNodeDiameterAddress._ext = None
    
    #-----< CellGlobalIdOrServiceAreaIdOrLAI >-----#
    CellGlobalIdOrServiceAreaIdOrLAI = CHOICE(name=u'CellGlobalIdOrServiceAreaIdOrLAI', mode=MODE_TYPE)
    _CellGlobalIdOrServiceAreaIdOrLAI_cellGlobalIdOrServiceAreaIdFixedLength = OCT_STR(name=u'cellGlobalIdOrServiceAreaIdFixedLength', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'CellGlobalIdOrServiceAreaIdFixedLength')))
    _CellGlobalIdOrServiceAreaIdOrLAI_laiFixedLength = OCT_STR(name=u'laiFixedLength', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LAIFixedLength')))
    CellGlobalIdOrServiceAreaIdOrLAI._cont = ASN1Dict([
        (u'cellGlobalIdOrServiceAreaIdFixedLength', _CellGlobalIdOrServiceAreaIdOrLAI_cellGlobalIdOrServiceAreaIdFixedLength),
        (u'laiFixedLength', _CellGlobalIdOrServiceAreaIdOrLAI_laiFixedLength),
        ])
    CellGlobalIdOrServiceAreaIdOrLAI._ext = None
    
    #-----< CellGlobalIdOrServiceAreaIdFixedLength >-----#
    CellGlobalIdOrServiceAreaIdFixedLength = OCT_STR(name=u'CellGlobalIdOrServiceAreaIdFixedLength', mode=MODE_TYPE)
    CellGlobalIdOrServiceAreaIdFixedLength._const_sz = ASN1Set(rv=[7], rr=[], ev=None, er=[])
    
    #-----< LAIFixedLength >-----#
    LAIFixedLength = OCT_STR(name=u'LAIFixedLength', mode=MODE_TYPE)
    LAIFixedLength._const_sz = ASN1Set(rv=[5], rr=[], ev=None, er=[])
    
    #-----< BasicServiceCode >-----#
    BasicServiceCode = CHOICE(name=u'BasicServiceCode', mode=MODE_TYPE)
    _BasicServiceCode_bearerService = OCT_STR(name=u'bearerService', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-BS-Code', 'BearerServiceCode')))
    _BasicServiceCode_teleservice = OCT_STR(name=u'teleservice', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-TS-Code', 'TeleserviceCode')))
    BasicServiceCode._cont = ASN1Dict([
        (u'bearerService', _BasicServiceCode_bearerService),
        (u'teleservice', _BasicServiceCode_teleservice),
        ])
    BasicServiceCode._ext = None
    
    #-----< Ext-BasicServiceCode >-----#
    Ext_BasicServiceCode = CHOICE(name=u'Ext-BasicServiceCode', mode=MODE_TYPE)
    _Ext_BasicServiceCode_ext_BearerService = OCT_STR(name=u'ext-BearerService', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-BS-Code', 'Ext-BearerServiceCode')))
    _Ext_BasicServiceCode_ext_Teleservice = OCT_STR(name=u'ext-Teleservice', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-TS-Code', 'Ext-TeleserviceCode')))
    Ext_BasicServiceCode._cont = ASN1Dict([
        (u'ext-BearerService', _Ext_BasicServiceCode_ext_BearerService),
        (u'ext-Teleservice', _Ext_BasicServiceCode_ext_Teleservice),
        ])
    Ext_BasicServiceCode._ext = None
    
    #-----< EMLPP-Info >-----#
    EMLPP_Info = SEQ(name=u'EMLPP-Info', mode=MODE_TYPE)
    _EMLPP_Info_maximumentitledPriority = INT(name=u'maximumentitledPriority', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')))
    _EMLPP_Info_defaultPriority = INT(name=u'defaultPriority', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')))
    _EMLPP_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    EMLPP_Info._cont = ASN1Dict([
        (u'maximumentitledPriority', _EMLPP_Info_maximumentitledPriority),
        (u'defaultPriority', _EMLPP_Info_defaultPriority),
        (u'extensionContainer', _EMLPP_Info_extensionContainer),
        ])
    EMLPP_Info._ext = []
    
    #-----< EMLPP-Priority >-----#
    EMLPP_Priority = INT(name=u'EMLPP-Priority', mode=MODE_TYPE)
    EMLPP_Priority._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    
    #-----< priorityLevelA >-----#
    priorityLevelA = INT(name=u'priorityLevelA', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')))
    priorityLevelA._val = 6
    
    #-----< priorityLevelB >-----#
    priorityLevelB = INT(name=u'priorityLevelB', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')))
    priorityLevelB._val = 5
    
    #-----< priorityLevel0 >-----#
    priorityLevel0 = INT(name=u'priorityLevel0', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')))
    priorityLevel0._val = 0
    
    #-----< priorityLevel1 >-----#
    priorityLevel1 = INT(name=u'priorityLevel1', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')))
    priorityLevel1._val = 1
    
    #-----< priorityLevel2 >-----#
    priorityLevel2 = INT(name=u'priorityLevel2', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')))
    priorityLevel2._val = 2
    
    #-----< priorityLevel3 >-----#
    priorityLevel3 = INT(name=u'priorityLevel3', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')))
    priorityLevel3._val = 3
    
    #-----< priorityLevel4 >-----#
    priorityLevel4 = INT(name=u'priorityLevel4', mode=MODE_VALUE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')))
    priorityLevel4._val = 4
    
    #-----< MC-SS-Info >-----#
    MC_SS_Info = SEQ(name=u'MC-SS-Info', mode=MODE_TYPE)
    _MC_SS_Info_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _MC_SS_Info_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    _MC_SS_Info_nbrSB = INT(name=u'nbrSB', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'MaxMC-Bearers')))
    _MC_SS_Info_nbrUser = INT(name=u'nbrUser', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'MC-Bearers')))
    _MC_SS_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    MC_SS_Info._cont = ASN1Dict([
        (u'ss-Code', _MC_SS_Info_ss_Code),
        (u'ss-Status', _MC_SS_Info_ss_Status),
        (u'nbrSB', _MC_SS_Info_nbrSB),
        (u'nbrUser', _MC_SS_Info_nbrUser),
        (u'extensionContainer', _MC_SS_Info_extensionContainer),
        ])
    MC_SS_Info._ext = []
    
    #-----< MaxMC-Bearers >-----#
    MaxMC_Bearers = INT(name=u'MaxMC-Bearers', mode=MODE_TYPE)
    MaxMC_Bearers._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=7)], ev=None, er=[])
    
    #-----< MC-Bearers >-----#
    MC_Bearers = INT(name=u'MC-Bearers', mode=MODE_TYPE)
    MC_Bearers._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=7)], ev=None, er=[])
    
    #-----< maxNumOfMC-Bearers >-----#
    maxNumOfMC_Bearers = INT(name=u'maxNumOfMC-Bearers', mode=MODE_VALUE)
    maxNumOfMC_Bearers._val = 7
    
    #-----< Ext-SS-Status >-----#
    Ext_SS_Status = OCT_STR(name=u'Ext-SS-Status', mode=MODE_TYPE)
    Ext_SS_Status._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< AgeOfLocationInformation >-----#
    AgeOfLocationInformation = INT(name=u'AgeOfLocationInformation', mode=MODE_TYPE)
    AgeOfLocationInformation._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    
    _all_ = [
        TBCD_STRING,
        DiameterIdentity,
        AddressString,
        maxAddressLength,
        ISDN_AddressString,
        maxISDN_AddressLength,
        FTN_AddressString,
        maxFTN_AddressLength,
        ISDN_SubaddressString,
        maxISDN_SubaddressLength,
        _ExternalSignalInfo_protocolId,
        _ExternalSignalInfo_signalInfo,
        _ExternalSignalInfo_extensionContainer,
        ExternalSignalInfo,
        SignalInfo,
        maxSignalInfoLength,
        ProtocolId,
        _Ext_ExternalSignalInfo_ext_ProtocolId,
        _Ext_ExternalSignalInfo_signalInfo,
        _Ext_ExternalSignalInfo_extensionContainer,
        Ext_ExternalSignalInfo,
        Ext_ProtocolId,
        _AccessNetworkSignalInfo_accessNetworkProtocolId,
        _AccessNetworkSignalInfo_signalInfo,
        _AccessNetworkSignalInfo_extensionContainer,
        AccessNetworkSignalInfo,
        LongSignalInfo,
        maxLongSignalInfoLength,
        AccessNetworkProtocolId,
        AlertingPattern,
        alertingLevel_0,
        alertingLevel_1,
        alertingLevel_2,
        alertingCategory_1,
        alertingCategory_2,
        alertingCategory_3,
        alertingCategory_4,
        alertingCategory_5,
        GSN_Address,
        Time,
        IMSI,
        _Identity_imsi,
        _Identity_imsi_WithLMSI,
        Identity,
        _IMSI_WithLMSI_imsi,
        _IMSI_WithLMSI_lmsi,
        IMSI_WithLMSI,
        ASCI_CallReference,
        TMSI,
        _SubscriberId_imsi,
        _SubscriberId_tmsi,
        SubscriberId,
        IMEI,
        HLR_Id,
        _HLR_List__item_,
        HLR_List,
        maxNumOfHLR_Id,
        LMSI,
        GlobalCellId,
        NetworkResource,
        AdditionalNetworkResource,
        _NAEA_PreferredCI_naea_PreferredCIC,
        _NAEA_PreferredCI_extensionContainer,
        NAEA_PreferredCI,
        NAEA_CIC,
        _SubscriberIdentity_imsi,
        _SubscriberIdentity_msisdn,
        SubscriberIdentity,
        _LCSClientExternalID_externalAddress,
        _LCSClientExternalID_extensionContainer,
        LCSClientExternalID,
        LCSClientInternalID,
        LCSServiceTypeID,
        emergencyServices,
        emergencyAlertServices,
        personTracking,
        fleetManagement,
        assetManagement,
        trafficCongestionReporting,
        roadsideAssistance,
        routingToNearestCommercialEnterprise,
        navigation,
        citySightseeing,
        localizedAdvertising,
        mobileYellowPages,
        trafficAndPublicTransportationInfo,
        weather,
        assetAndServiceFinding,
        gaming,
        findYourFriend,
        dating,
        chatting,
        routeFinding,
        whereAmI,
        serv64,
        serv65,
        serv66,
        serv67,
        serv68,
        serv69,
        serv70,
        serv71,
        serv72,
        serv73,
        serv74,
        serv75,
        serv76,
        serv77,
        serv78,
        serv79,
        serv80,
        serv81,
        serv82,
        serv83,
        serv84,
        serv85,
        serv86,
        serv87,
        serv88,
        serv89,
        serv90,
        serv91,
        serv92,
        serv93,
        serv94,
        serv95,
        serv96,
        serv97,
        serv98,
        serv99,
        serv100,
        serv101,
        serv102,
        serv103,
        serv104,
        serv105,
        serv106,
        serv107,
        serv108,
        serv109,
        serv110,
        serv111,
        serv112,
        serv113,
        serv114,
        serv115,
        serv116,
        serv117,
        serv118,
        serv119,
        serv120,
        serv121,
        serv122,
        serv123,
        serv124,
        serv125,
        serv126,
        serv127,
        PLMN_Id,
        E_UTRAN_CGI,
        TA_Id,
        RAIdentity,
        _NetworkNodeDiameterAddress_diameter_Name,
        _NetworkNodeDiameterAddress_diameter_Realm,
        NetworkNodeDiameterAddress,
        _CellGlobalIdOrServiceAreaIdOrLAI_cellGlobalIdOrServiceAreaIdFixedLength,
        _CellGlobalIdOrServiceAreaIdOrLAI_laiFixedLength,
        CellGlobalIdOrServiceAreaIdOrLAI,
        CellGlobalIdOrServiceAreaIdFixedLength,
        LAIFixedLength,
        _BasicServiceCode_bearerService,
        _BasicServiceCode_teleservice,
        BasicServiceCode,
        _Ext_BasicServiceCode_ext_BearerService,
        _Ext_BasicServiceCode_ext_Teleservice,
        Ext_BasicServiceCode,
        _EMLPP_Info_maximumentitledPriority,
        _EMLPP_Info_defaultPriority,
        _EMLPP_Info_extensionContainer,
        EMLPP_Info,
        EMLPP_Priority,
        priorityLevelA,
        priorityLevelB,
        priorityLevel0,
        priorityLevel1,
        priorityLevel2,
        priorityLevel3,
        priorityLevel4,
        _MC_SS_Info_ss_Code,
        _MC_SS_Info_ss_Status,
        _MC_SS_Info_nbrSB,
        _MC_SS_Info_nbrUser,
        _MC_SS_Info_extensionContainer,
        MC_SS_Info,
        MaxMC_Bearers,
        MC_Bearers,
        maxNumOfMC_Bearers,
        Ext_SS_Status,
        AgeOfLocationInformation,
    ]

class MAP_ExtensionDataTypes:

    _name_  = u'MAP-ExtensionDataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 21, 16]
    
    _obj_ = [
        u'MAP-EXTENSION',
        u'ExtensionContainer',
        u'SLR-ArgExtensionContainer',
        u'PrivateExtensionList',
        u'PrivateExtension',
        u'maxNumOfPrivateExtensions',
        u'ExtensionSet',
        u'PCS-Extensions',
        u'SLR-Arg-PCS-Extensions',
        ]
    _type_ = [
        u'MAP-EXTENSION',
        u'ExtensionContainer',
        u'SLR-ArgExtensionContainer',
        u'PrivateExtensionList',
        u'PrivateExtension',
        u'PCS-Extensions',
        u'SLR-Arg-PCS-Extensions',
        ]
    _set_ = [
        u'ExtensionSet',
        ]
    _val_ = [
        u'maxNumOfPrivateExtensions',
        ]
    _class_ = [
        u'MAP-EXTENSION',
        u'ExtensionSet',
        ]
    _param_ = [
        ]
    
    #-----< MAP-EXTENSION >-----#
    MAP_EXTENSION = CLASS(name=u'MAP-EXTENSION', mode=MODE_TYPE)
    _MAP_EXTENSION_ExtensionType = OPEN(name=u'ExtensionType', mode=MODE_TYPE, opt=True)
    _MAP_EXTENSION_extensionId = OID(name=u'extensionId', mode=MODE_VALUE)
    MAP_EXTENSION._cont = ASN1Dict([
        (u'ExtensionType', _MAP_EXTENSION_ExtensionType),
        (u'extensionId', _MAP_EXTENSION_extensionId),
        ])
    
    #-----< ExtensionContainer >-----#
    ExtensionContainer = SEQ(name=u'ExtensionContainer', mode=MODE_TYPE)
    _ExtensionContainer_privateExtensionList = SEQ_OF(name=u'privateExtensionList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'PrivateExtensionList')), opt=True)
    _ExtensionContainer_pcs_Extensions = SEQ(name=u'pcs-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'PCS-Extensions')), opt=True)
    ExtensionContainer._cont = ASN1Dict([
        (u'privateExtensionList', _ExtensionContainer_privateExtensionList),
        (u'pcs-Extensions', _ExtensionContainer_pcs_Extensions),
        ])
    ExtensionContainer._ext = []
    
    #-----< SLR-ArgExtensionContainer >-----#
    SLR_ArgExtensionContainer = SEQ(name=u'SLR-ArgExtensionContainer', mode=MODE_TYPE)
    _SLR_ArgExtensionContainer_privateExtensionList = SEQ_OF(name=u'privateExtensionList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'PrivateExtensionList')), opt=True)
    _SLR_ArgExtensionContainer_slr_Arg_PCS_Extensions = SEQ(name=u'slr-Arg-PCS-Extensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'SLR-Arg-PCS-Extensions')), opt=True)
    SLR_ArgExtensionContainer._cont = ASN1Dict([
        (u'privateExtensionList', _SLR_ArgExtensionContainer_privateExtensionList),
        (u'slr-Arg-PCS-Extensions', _SLR_ArgExtensionContainer_slr_Arg_PCS_Extensions),
        ])
    SLR_ArgExtensionContainer._ext = []
    
    #-----< PrivateExtensionList >-----#
    PrivateExtensionList = SEQ_OF(name=u'PrivateExtensionList', mode=MODE_TYPE)
    _PrivateExtensionList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'PrivateExtension')))
    PrivateExtensionList._cont = _PrivateExtensionList__item_
    PrivateExtensionList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< PrivateExtension >-----#
    PrivateExtension = SEQ(name=u'PrivateExtension', mode=MODE_TYPE)
    _PrivateExtension_extId = OID(name=u'extId', mode=MODE_TYPE, typeref=ASN1RefClassField(('MAP-ExtensionDataTypes', 'MAP-EXTENSION'), [u'extensionId']))
    __PrivateExtension_extId_tab = CLASS(name='_tab_MAP-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'MAP-EXTENSION')))
    __PrivateExtension_extId_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PrivateExtension_extId._const_tab = __PrivateExtension_extId_tab
    _PrivateExtension_extId._const_tab_at = None
    _PrivateExtension_extId._const_tab_id = u'extensionId'
    _PrivateExtension_extType = OPEN(name=u'extType', mode=MODE_TYPE, typeref=ASN1RefClassField(('MAP-ExtensionDataTypes', 'MAP-EXTENSION'), [u'ExtensionType']), opt=True)
    __PrivateExtension_extType_tab = CLASS(name='_tab_MAP-EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'MAP-EXTENSION')))
    __PrivateExtension_extType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PrivateExtension_extType._const_tab = __PrivateExtension_extType_tab
    _PrivateExtension_extType._const_tab_at = ('..', u'extId')
    _PrivateExtension_extType._const_tab_id = u'ExtensionType'
    PrivateExtension._cont = ASN1Dict([
        (u'extId', _PrivateExtension_extId),
        (u'extType', _PrivateExtension_extType),
        ])
    PrivateExtension._ext = None
    
    #-----< maxNumOfPrivateExtensions >-----#
    maxNumOfPrivateExtensions = INT(name=u'maxNumOfPrivateExtensions', mode=MODE_VALUE)
    maxNumOfPrivateExtensions._val = 10
    
    #-----< ExtensionSet >-----#
    ExtensionSet = CLASS(name=u'ExtensionSet', mode=MODE_SET, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'MAP-EXTENSION')))
    ExtensionSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< PCS-Extensions >-----#
    PCS_Extensions = SEQ(name=u'PCS-Extensions', mode=MODE_TYPE)
    PCS_Extensions._cont = ASN1Dict([
        ])
    PCS_Extensions._ext = []
    
    #-----< SLR-Arg-PCS-Extensions >-----#
    SLR_Arg_PCS_Extensions = SEQ(name=u'SLR-Arg-PCS-Extensions', mode=MODE_TYPE)
    _SLR_Arg_PCS_Extensions_na_ESRK_Request = NULL(name=u'na-ESRK-Request', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    SLR_Arg_PCS_Extensions._cont = ASN1Dict([
        (u'na-ESRK-Request', _SLR_Arg_PCS_Extensions_na_ESRK_Request),
        ])
    SLR_Arg_PCS_Extensions._ext = [u'na-ESRK-Request']
    
    _all_ = [
        _MAP_EXTENSION_ExtensionType,
        _MAP_EXTENSION_extensionId,
        MAP_EXTENSION,
        _ExtensionContainer_privateExtensionList,
        _ExtensionContainer_pcs_Extensions,
        ExtensionContainer,
        _SLR_ArgExtensionContainer_privateExtensionList,
        _SLR_ArgExtensionContainer_slr_Arg_PCS_Extensions,
        SLR_ArgExtensionContainer,
        _PrivateExtensionList__item_,
        PrivateExtensionList,
        __PrivateExtension_extId_tab,
        _PrivateExtension_extId,
        __PrivateExtension_extType_tab,
        _PrivateExtension_extType,
        PrivateExtension,
        maxNumOfPrivateExtensions,
        ExtensionSet,
        PCS_Extensions,
        _SLR_Arg_PCS_Extensions_na_ESRK_Request,
        SLR_Arg_PCS_Extensions,
    ]

class MAP_MS_DataTypes:

    _name_  = u'MAP-MS-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 11, 16]
    
    _obj_ = [
        u'UpdateLocationArg',
        u'VLR-Capability',
        u'SupportedRAT-Types',
        u'SuperChargerInfo',
        u'AgeIndicator',
        u'IST-SupportIndicator',
        u'SupportedLCS-CapabilitySets',
        u'UpdateLocationRes',
        u'ADD-Info',
        u'PagingArea',
        u'LocationArea',
        u'LAC',
        u'CancelLocationArg',
        u'TypeOfUpdate',
        u'CancellationType',
        u'CancelLocationRes',
        u'PurgeMS-Arg',
        u'PurgeMS-Res',
        u'SendIdentificationArg',
        u'HopCounter',
        u'SendIdentificationRes',
        u'AuthenticationSetList',
        u'TripletList',
        u'QuintupletList',
        u'AuthenticationTriplet',
        u'AuthenticationQuintuplet',
        u'CurrentSecurityContext',
        u'GSM-SecurityContextData',
        u'UMTS-SecurityContextData',
        u'RAND',
        u'SRES',
        u'Kc',
        u'XRES',
        u'CK',
        u'IK',
        u'AUTN',
        u'AUTS',
        u'Cksn',
        u'KSI',
        u'AuthenticationFailureReportArg',
        u'AccessType',
        u'AuthenticationFailureReportRes',
        u'FailureCause',
        u'UpdateGprsLocationArg',
        u'SMSRegisterRequest',
        u'Used-RAT-Type',
        u'EPS-Info',
        u'PDN-GW-Update',
        u'ISR-Information',
        u'SGSN-Capability',
        u'SupportedFeatures',
        u'UE-SRVCC-Capability',
        u'UpdateGprsLocationRes',
        u'EPLMN-List',
        u'AdjacentPLMN-List',
        u'ForwardAccessSignalling-Arg',
        u'AllowedGSM-Algorithms',
        u'AllowedUMTS-Algorithms',
        u'PermittedIntegrityProtectionAlgorithms',
        u'maxPermittedIntegrityProtectionAlgorithmsLength',
        u'PermittedEncryptionAlgorithms',
        u'maxPermittedEncryptionAlgorithmsLength',
        u'KeyStatus',
        u'PrepareHO-Arg',
        u'LCLS-GlobalCallReference',
        u'LCLS-Negotiation',
        u'LCLS-ConfigurationPreference',
        u'BSSMAP-ServiceHandoverList',
        u'BSSMAP-ServiceHandoverInfo',
        u'maxNumOfServiceHandovers',
        u'BSSMAP-ServiceHandover',
        u'RANAP-ServiceHandover',
        u'RadioResourceList',
        u'RadioResource',
        u'maxNumOfRadioResources',
        u'PrepareHO-Res',
        u'SelectedUMTS-Algorithms',
        u'ChosenIntegrityProtectionAlgorithm',
        u'ChosenEncryptionAlgorithm',
        u'ChosenRadioResourceInformation',
        u'ChosenChannelInfo',
        u'ChosenSpeechVersion',
        u'PrepareSubsequentHO-Arg',
        u'PrepareSubsequentHO-Res',
        u'ProcessAccessSignalling-Arg',
        u'AoIPCodecsList',
        u'AoIPCodec',
        u'SupportedCodecsList',
        u'CodecList',
        u'Codec',
        u'GERAN-Classmark',
        u'SelectedGSM-Algorithm',
        u'SendEndSignal-Arg',
        u'SendEndSignal-Res',
        u'RNCId',
        u'RelocationNumberList',
        u'MulticallBearerInfo',
        u'RelocationNumber',
        u'RAB-Id',
        u'maxNrOfRABs',
        u'maxNumOfRelocationNumber',
        u'RadioResourceInformation',
        u'IntegrityProtectionInformation',
        u'maxNumOfIntegrityInfo',
        u'EncryptionInformation',
        u'maxNumOfEncryptionInfo',
        u'SendAuthenticationInfoArg',
        u'NumberOfRequestedVectors',
        u'Re-synchronisationInfo',
        u'SendAuthenticationInfoRes',
        u'EPS-AuthenticationSetList',
        u'UE-UsageType',
        u'EPC-AV',
        u'KASME',
        u'RequestingNodeType',
        u'CheckIMEI-Arg',
        u'CheckIMEI-Res',
        u'RequestedEquipmentInfo',
        u'UESBI-Iu',
        u'UESBI-IuA',
        u'UESBI-IuB',
        u'EquipmentStatus',
        u'InsertSubscriberDataArg',
        u'Group-Service-ID',
        u'Local-GroupID',
        u'IMSI-GroupIdList',
        u'IMSI-GroupId',
        u'SubscribedPeriodicRAUTAUtimer',
        u'SubscribedPeriodicLAUtimer',
        u'CSG-SubscriptionDataList',
        u'CSG-SubscriptionData',
        u'VPLMN-CSG-SubscriptionDataList',
        u'CSG-Id',
        u'LIPA-AllowedAPNList',
        u'maxNumOfLIPAAllowedAPN',
        u'EPS-SubscriptionData',
        u'APN-OI-Replacement',
        u'RFSP-ID',
        u'APN-ConfigurationProfile',
        u'EPS-DataList',
        u'maxNumOfAPN-Configurations',
        u'APN-Configuration',
        u'NIDD-Mechanism',
        u'PDN-Type',
        u'EPS-QoS-Subscribed',
        u'AMBR',
        u'SpecificAPNInfoList',
        u'maxNumOfSpecificAPNInfos',
        u'SpecificAPNInfo',
        u'Bandwidth',
        u'QoS-Class-Identifier',
        u'Allocation-Retention-Priority',
        u'PDN-GW-Identity',
        u'FQDN',
        u'PDN-GW-AllocationType',
        u'WLAN-Offloadability',
        u'WLAN-Offloadability-Indication',
        u'AccessRestrictionData',
        u'AdjacentAccessRestrictionDataList',
        u'AdjacentAccessRestrictionData',
        u'CS-AllocationRetentionPriority',
        u'IST-AlertTimerValue',
        u'LCSInformation',
        u'GMLC-List',
        u'maxNumOfGMLC',
        u'NetworkAccessMode',
        u'GPRSDataList',
        u'maxNumOfPDP-Contexts',
        u'PDP-Context',
        u'Restoration-Priority',
        u'SIPTO-Permission',
        u'SIPTO-Local-Network-Permission',
        u'LIPA-Permission',
        u'ContextId',
        u'GPRSSubscriptionData',
        u'SGSN-CAMEL-SubscriptionInfo',
        u'GPRS-CSI',
        u'GPRS-CamelTDPDataList',
        u'GPRS-CamelTDPData',
        u'DefaultGPRS-Handling',
        u'GPRS-TriggerDetectionPoint',
        u'APN',
        u'PDP-Type',
        u'Ext-PDP-Type',
        u'PDP-Address',
        u'QoS-Subscribed',
        u'Ext-QoS-Subscribed',
        u'Ext2-QoS-Subscribed',
        u'Ext3-QoS-Subscribed',
        u'Ext4-QoS-Subscribed',
        u'ChargingCharacteristics',
        u'LSAOnlyAccessIndicator',
        u'LSADataList',
        u'maxNumOfLSAs',
        u'LSAData',
        u'LSAInformation',
        u'LSAIdentity',
        u'LSAAttributes',
        u'SubscriberData',
        u'Category',
        u'SubscriberStatus',
        u'BearerServiceList',
        u'maxNumOfBearerServices',
        u'TeleserviceList',
        u'maxNumOfTeleservices',
        u'ODB-Data',
        u'ODB-GeneralData',
        u'ODB-HPLMN-Data',
        u'Ext-SS-InfoList',
        u'Ext-SS-Info',
        u'Ext-ForwInfo',
        u'Ext-ForwFeatureList',
        u'Ext-ForwFeature',
        u'Ext-ForwOptions',
        u'Ext-NoRepCondTime',
        u'Ext-CallBarInfo',
        u'Ext-CallBarFeatureList',
        u'Ext-CallBarringFeature',
        u'CUG-Info',
        u'CUG-SubscriptionList',
        u'CUG-Subscription',
        u'CUG-Index',
        u'CUG-Interlock',
        u'IntraCUG-Options',
        u'maxNumOfCUG',
        u'CUG-FeatureList',
        u'Ext-BasicServiceGroupList',
        u'maxNumOfExt-BasicServiceGroups',
        u'CUG-Feature',
        u'InterCUG-Restrictions',
        u'Ext-SS-Data',
        u'LCS-PrivacyExceptionList',
        u'maxNumOfPrivacyClass',
        u'LCS-PrivacyClass',
        u'ExternalClientList',
        u'maxNumOfExternalClient',
        u'PLMNClientList',
        u'maxNumOfPLMNClient',
        u'Ext-ExternalClientList',
        u'maxNumOfExt-ExternalClient',
        u'ExternalClient',
        u'GMLC-Restriction',
        u'NotificationToMSUser',
        u'ServiceTypeList',
        u'maxNumOfServiceType',
        u'ServiceType',
        u'MOLR-List',
        u'maxNumOfMOLR-Class',
        u'MOLR-Class',
        u'ZoneCodeList',
        u'ZoneCode',
        u'maxNumOfZoneCodes',
        u'InsertSubscriberDataRes',
        u'RegionalSubscriptionResponse',
        u'DeleteSubscriberDataArg',
        u'SpecificCSI-Withdraw',
        u'GPRSSubscriptionDataWithdraw',
        u'EPS-SubscriptionDataWithdraw',
        u'ContextIdList',
        u'LSAInformationWithdraw',
        u'LSAIdentityList',
        u'BasicServiceList',
        u'maxNumOfBasicServices',
        u'DeleteSubscriberDataRes',
        u'VlrCamelSubscriptionInfo',
        u'MT-smsCAMELTDP-CriteriaList',
        u'MT-smsCAMELTDP-Criteria',
        u'TPDU-TypeCriterion',
        u'maxNumOfTPDUTypes',
        u'MT-SMS-TPDU-Type',
        u'D-CSI',
        u'DP-AnalysedInfoCriteriaList',
        u'maxNumOfDP-AnalysedInfoCriteria',
        u'DP-AnalysedInfoCriterium',
        u'SS-CSI',
        u'SS-CamelData',
        u'SS-EventList',
        u'maxNumOfCamelSSEvents',
        u'O-CSI',
        u'O-BcsmCamelTDPDataList',
        u'maxNumOfCamelTDPData',
        u'O-BcsmCamelTDPData',
        u'ServiceKey',
        u'O-BcsmTriggerDetectionPoint',
        u'O-BcsmCamelTDPCriteriaList',
        u'T-BCSM-CAMEL-TDP-CriteriaList',
        u'O-BcsmCamelTDP-Criteria',
        u'T-BCSM-CAMEL-TDP-Criteria',
        u'DestinationNumberCriteria',
        u'DestinationNumberList',
        u'DestinationNumberLengthList',
        u'BasicServiceCriteria',
        u'maxNumOfISDN-AddressDigits',
        u'maxNumOfCamelDestinationNumbers',
        u'maxNumOfCamelDestinationNumberLengths',
        u'maxNumOfCamelBasicServiceCriteria',
        u'CallTypeCriteria',
        u'MatchType',
        u'O-CauseValueCriteria',
        u'T-CauseValueCriteria',
        u'maxNumOfCAMEL-O-CauseValueCriteria',
        u'maxNumOfCAMEL-T-CauseValueCriteria',
        u'CauseValue',
        u'DefaultCallHandling',
        u'CamelCapabilityHandling',
        u'SupportedCamelPhases',
        u'OfferedCamel4CSIs',
        u'OfferedCamel4Functionalities',
        u'SMS-CSI',
        u'SMS-CAMEL-TDP-DataList',
        u'SMS-CAMEL-TDP-Data',
        u'SMS-TriggerDetectionPoint',
        u'DefaultSMS-Handling',
        u'M-CSI',
        u'MG-CSI',
        u'MobilityTriggers',
        u'maxNumOfMobilityTriggers',
        u'MM-Code',
        u'T-CSI',
        u'T-BcsmCamelTDPDataList',
        u'T-BcsmCamelTDPData',
        u'T-BcsmTriggerDetectionPoint',
        u'SendRoutingInfoForGprsArg',
        u'SendRoutingInfoForGprsRes',
        u'FailureReportArg',
        u'FailureReportRes',
        u'NoteMsPresentForGprsArg',
        u'NoteMsPresentForGprsRes',
        u'ResetArg',
        u'SendingNode-Number',
        u'RestoreDataArg',
        u'RestoreDataRes',
        u'VBSDataList',
        u'VGCSDataList',
        u'maxNumOfVBSGroupIds',
        u'maxNumOfVGCSGroupIds',
        u'VoiceGroupCallData',
        u'AdditionalInfo',
        u'AdditionalSubscriptions',
        u'VoiceBroadcastData',
        u'GroupId',
        u'Long-GroupId',
        u'ProvideSubscriberInfoArg',
        u'ProvideSubscriberInfoRes',
        u'SubscriberInfo',
        u'IMS-VoiceOverPS-SessionsInd',
        u'TimeZone',
        u'DaylightSavingTime',
        u'MNPInfoRes',
        u'RouteingNumber',
        u'NumberPortabilityStatus',
        u'MS-Classmark2',
        u'GPRSMSClass',
        u'MSNetworkCapability',
        u'MSRadioAccessCapability',
        u'RequestedInfo',
        u'DomainType',
        u'RequestedNodes',
        u'LocationInformation',
        u'LocationInformationEPS',
        u'LocationInformationGPRS',
        u'UserCSGInformation',
        u'GeographicalInformation',
        u'GeodeticInformation',
        u'LocationNumber',
        u'SubscriberState',
        u'PS-SubscriberState',
        u'PDP-ContextInfoList',
        u'PDP-ContextInfo',
        u'NSAPI',
        u'TransactionId',
        u'TEID',
        u'GPRSChargingID',
        u'NotReachableReason',
        u'AnyTimeInterrogationArg',
        u'AnyTimeInterrogationRes',
        u'AnyTimeSubscriptionInterrogationArg',
        u'AnyTimeSubscriptionInterrogationRes',
        u'CallWaitingData',
        u'Ext-CwFeatureList',
        u'Ext-CwFeature',
        u'ClipData',
        u'ClirData',
        u'CallHoldData',
        u'EctData',
        u'RequestedSubscriptionInfo',
        u'MSISDN-BS-List',
        u'maxNumOfMSISDN',
        u'MSISDN-BS',
        u'RequestedCAMEL-SubscriptionInfo',
        u'AdditionalRequestedCAMEL-SubscriptionInfo',
        u'CallForwardingData',
        u'CallBarringData',
        u'WrongPasswordAttemptsCounter',
        u'ODB-Info',
        u'CAMEL-SubscriptionInfo',
        u'AnyTimeModificationArg',
        u'ModificationRequestFor-CW-Info',
        u'ModificationRequestFor-CH-Info',
        u'ModificationRequestFor-ECT-Info',
        u'ModificationRequestFor-CLIR-Info',
        u'ModificationRequestFor-CLIP-Info',
        u'ModificationRequestFor-CSG',
        u'RequestedServingNode',
        u'ServingNode',
        u'AnyTimeModificationRes',
        u'ModificationRequestFor-CF-Info',
        u'ModificationRequestFor-CB-Info',
        u'ModificationRequestFor-ODB-data',
        u'ModificationRequestFor-CSI',
        u'ModificationRequestFor-IP-SM-GW-Data',
        u'ModificationInstruction',
        u'NoteSubscriberDataModifiedArg',
        u'NoteSubscriberDataModifiedRes',
        u'NoteMM-EventArg',
        u'NoteMM-EventRes',
        u'Ext-SS-InfoFor-CSE',
        u'Ext-ForwardingInfoFor-CSE',
        u'Ext-CallBarringInfoFor-CSE',
        u'UpdateVcsgLocationArg',
        u'UpdateVcsgLocationRes',
        u'CancelVcsgLocationArg',
        u'CancelVcsgLocationRes',
        ]
    _type_ = [
        u'UpdateLocationArg',
        u'VLR-Capability',
        u'SupportedRAT-Types',
        u'SuperChargerInfo',
        u'AgeIndicator',
        u'IST-SupportIndicator',
        u'SupportedLCS-CapabilitySets',
        u'UpdateLocationRes',
        u'ADD-Info',
        u'PagingArea',
        u'LocationArea',
        u'LAC',
        u'CancelLocationArg',
        u'TypeOfUpdate',
        u'CancellationType',
        u'CancelLocationRes',
        u'PurgeMS-Arg',
        u'PurgeMS-Res',
        u'SendIdentificationArg',
        u'HopCounter',
        u'SendIdentificationRes',
        u'AuthenticationSetList',
        u'TripletList',
        u'QuintupletList',
        u'AuthenticationTriplet',
        u'AuthenticationQuintuplet',
        u'CurrentSecurityContext',
        u'GSM-SecurityContextData',
        u'UMTS-SecurityContextData',
        u'RAND',
        u'SRES',
        u'Kc',
        u'XRES',
        u'CK',
        u'IK',
        u'AUTN',
        u'AUTS',
        u'Cksn',
        u'KSI',
        u'AuthenticationFailureReportArg',
        u'AccessType',
        u'AuthenticationFailureReportRes',
        u'FailureCause',
        u'UpdateGprsLocationArg',
        u'SMSRegisterRequest',
        u'Used-RAT-Type',
        u'EPS-Info',
        u'PDN-GW-Update',
        u'ISR-Information',
        u'SGSN-Capability',
        u'SupportedFeatures',
        u'UE-SRVCC-Capability',
        u'UpdateGprsLocationRes',
        u'EPLMN-List',
        u'AdjacentPLMN-List',
        u'ForwardAccessSignalling-Arg',
        u'AllowedGSM-Algorithms',
        u'AllowedUMTS-Algorithms',
        u'PermittedIntegrityProtectionAlgorithms',
        u'PermittedEncryptionAlgorithms',
        u'KeyStatus',
        u'PrepareHO-Arg',
        u'LCLS-GlobalCallReference',
        u'LCLS-Negotiation',
        u'LCLS-ConfigurationPreference',
        u'BSSMAP-ServiceHandoverList',
        u'BSSMAP-ServiceHandoverInfo',
        u'BSSMAP-ServiceHandover',
        u'RANAP-ServiceHandover',
        u'RadioResourceList',
        u'RadioResource',
        u'PrepareHO-Res',
        u'SelectedUMTS-Algorithms',
        u'ChosenIntegrityProtectionAlgorithm',
        u'ChosenEncryptionAlgorithm',
        u'ChosenRadioResourceInformation',
        u'ChosenChannelInfo',
        u'ChosenSpeechVersion',
        u'PrepareSubsequentHO-Arg',
        u'PrepareSubsequentHO-Res',
        u'ProcessAccessSignalling-Arg',
        u'AoIPCodecsList',
        u'AoIPCodec',
        u'SupportedCodecsList',
        u'CodecList',
        u'Codec',
        u'GERAN-Classmark',
        u'SelectedGSM-Algorithm',
        u'SendEndSignal-Arg',
        u'SendEndSignal-Res',
        u'RNCId',
        u'RelocationNumberList',
        u'MulticallBearerInfo',
        u'RelocationNumber',
        u'RAB-Id',
        u'RadioResourceInformation',
        u'IntegrityProtectionInformation',
        u'EncryptionInformation',
        u'SendAuthenticationInfoArg',
        u'NumberOfRequestedVectors',
        u'Re-synchronisationInfo',
        u'SendAuthenticationInfoRes',
        u'EPS-AuthenticationSetList',
        u'UE-UsageType',
        u'EPC-AV',
        u'KASME',
        u'RequestingNodeType',
        u'CheckIMEI-Arg',
        u'CheckIMEI-Res',
        u'RequestedEquipmentInfo',
        u'UESBI-Iu',
        u'UESBI-IuA',
        u'UESBI-IuB',
        u'EquipmentStatus',
        u'InsertSubscriberDataArg',
        u'Group-Service-ID',
        u'Local-GroupID',
        u'IMSI-GroupIdList',
        u'IMSI-GroupId',
        u'SubscribedPeriodicRAUTAUtimer',
        u'SubscribedPeriodicLAUtimer',
        u'CSG-SubscriptionDataList',
        u'CSG-SubscriptionData',
        u'VPLMN-CSG-SubscriptionDataList',
        u'CSG-Id',
        u'LIPA-AllowedAPNList',
        u'EPS-SubscriptionData',
        u'APN-OI-Replacement',
        u'RFSP-ID',
        u'APN-ConfigurationProfile',
        u'EPS-DataList',
        u'APN-Configuration',
        u'NIDD-Mechanism',
        u'PDN-Type',
        u'EPS-QoS-Subscribed',
        u'AMBR',
        u'SpecificAPNInfoList',
        u'SpecificAPNInfo',
        u'Bandwidth',
        u'QoS-Class-Identifier',
        u'Allocation-Retention-Priority',
        u'PDN-GW-Identity',
        u'FQDN',
        u'PDN-GW-AllocationType',
        u'WLAN-Offloadability',
        u'WLAN-Offloadability-Indication',
        u'AccessRestrictionData',
        u'AdjacentAccessRestrictionDataList',
        u'AdjacentAccessRestrictionData',
        u'CS-AllocationRetentionPriority',
        u'IST-AlertTimerValue',
        u'LCSInformation',
        u'GMLC-List',
        u'NetworkAccessMode',
        u'GPRSDataList',
        u'PDP-Context',
        u'Restoration-Priority',
        u'SIPTO-Permission',
        u'SIPTO-Local-Network-Permission',
        u'LIPA-Permission',
        u'ContextId',
        u'GPRSSubscriptionData',
        u'SGSN-CAMEL-SubscriptionInfo',
        u'GPRS-CSI',
        u'GPRS-CamelTDPDataList',
        u'GPRS-CamelTDPData',
        u'DefaultGPRS-Handling',
        u'GPRS-TriggerDetectionPoint',
        u'APN',
        u'PDP-Type',
        u'Ext-PDP-Type',
        u'PDP-Address',
        u'QoS-Subscribed',
        u'Ext-QoS-Subscribed',
        u'Ext2-QoS-Subscribed',
        u'Ext3-QoS-Subscribed',
        u'Ext4-QoS-Subscribed',
        u'ChargingCharacteristics',
        u'LSAOnlyAccessIndicator',
        u'LSADataList',
        u'LSAData',
        u'LSAInformation',
        u'LSAIdentity',
        u'LSAAttributes',
        u'SubscriberData',
        u'Category',
        u'SubscriberStatus',
        u'BearerServiceList',
        u'TeleserviceList',
        u'ODB-Data',
        u'ODB-GeneralData',
        u'ODB-HPLMN-Data',
        u'Ext-SS-InfoList',
        u'Ext-SS-Info',
        u'Ext-ForwInfo',
        u'Ext-ForwFeatureList',
        u'Ext-ForwFeature',
        u'Ext-ForwOptions',
        u'Ext-NoRepCondTime',
        u'Ext-CallBarInfo',
        u'Ext-CallBarFeatureList',
        u'Ext-CallBarringFeature',
        u'CUG-Info',
        u'CUG-SubscriptionList',
        u'CUG-Subscription',
        u'CUG-Index',
        u'CUG-Interlock',
        u'IntraCUG-Options',
        u'CUG-FeatureList',
        u'Ext-BasicServiceGroupList',
        u'CUG-Feature',
        u'InterCUG-Restrictions',
        u'Ext-SS-Data',
        u'LCS-PrivacyExceptionList',
        u'LCS-PrivacyClass',
        u'ExternalClientList',
        u'PLMNClientList',
        u'Ext-ExternalClientList',
        u'ExternalClient',
        u'GMLC-Restriction',
        u'NotificationToMSUser',
        u'ServiceTypeList',
        u'ServiceType',
        u'MOLR-List',
        u'MOLR-Class',
        u'ZoneCodeList',
        u'ZoneCode',
        u'InsertSubscriberDataRes',
        u'RegionalSubscriptionResponse',
        u'DeleteSubscriberDataArg',
        u'SpecificCSI-Withdraw',
        u'GPRSSubscriptionDataWithdraw',
        u'EPS-SubscriptionDataWithdraw',
        u'ContextIdList',
        u'LSAInformationWithdraw',
        u'LSAIdentityList',
        u'BasicServiceList',
        u'DeleteSubscriberDataRes',
        u'VlrCamelSubscriptionInfo',
        u'MT-smsCAMELTDP-CriteriaList',
        u'MT-smsCAMELTDP-Criteria',
        u'TPDU-TypeCriterion',
        u'MT-SMS-TPDU-Type',
        u'D-CSI',
        u'DP-AnalysedInfoCriteriaList',
        u'DP-AnalysedInfoCriterium',
        u'SS-CSI',
        u'SS-CamelData',
        u'SS-EventList',
        u'O-CSI',
        u'O-BcsmCamelTDPDataList',
        u'O-BcsmCamelTDPData',
        u'ServiceKey',
        u'O-BcsmTriggerDetectionPoint',
        u'O-BcsmCamelTDPCriteriaList',
        u'T-BCSM-CAMEL-TDP-CriteriaList',
        u'O-BcsmCamelTDP-Criteria',
        u'T-BCSM-CAMEL-TDP-Criteria',
        u'DestinationNumberCriteria',
        u'DestinationNumberList',
        u'DestinationNumberLengthList',
        u'BasicServiceCriteria',
        u'CallTypeCriteria',
        u'MatchType',
        u'O-CauseValueCriteria',
        u'T-CauseValueCriteria',
        u'CauseValue',
        u'DefaultCallHandling',
        u'CamelCapabilityHandling',
        u'SupportedCamelPhases',
        u'OfferedCamel4CSIs',
        u'OfferedCamel4Functionalities',
        u'SMS-CSI',
        u'SMS-CAMEL-TDP-DataList',
        u'SMS-CAMEL-TDP-Data',
        u'SMS-TriggerDetectionPoint',
        u'DefaultSMS-Handling',
        u'M-CSI',
        u'MG-CSI',
        u'MobilityTriggers',
        u'MM-Code',
        u'T-CSI',
        u'T-BcsmCamelTDPDataList',
        u'T-BcsmCamelTDPData',
        u'T-BcsmTriggerDetectionPoint',
        u'SendRoutingInfoForGprsArg',
        u'SendRoutingInfoForGprsRes',
        u'FailureReportArg',
        u'FailureReportRes',
        u'NoteMsPresentForGprsArg',
        u'NoteMsPresentForGprsRes',
        u'ResetArg',
        u'SendingNode-Number',
        u'RestoreDataArg',
        u'RestoreDataRes',
        u'VBSDataList',
        u'VGCSDataList',
        u'VoiceGroupCallData',
        u'AdditionalInfo',
        u'AdditionalSubscriptions',
        u'VoiceBroadcastData',
        u'GroupId',
        u'Long-GroupId',
        u'ProvideSubscriberInfoArg',
        u'ProvideSubscriberInfoRes',
        u'SubscriberInfo',
        u'IMS-VoiceOverPS-SessionsInd',
        u'TimeZone',
        u'DaylightSavingTime',
        u'MNPInfoRes',
        u'RouteingNumber',
        u'NumberPortabilityStatus',
        u'MS-Classmark2',
        u'GPRSMSClass',
        u'MSNetworkCapability',
        u'MSRadioAccessCapability',
        u'RequestedInfo',
        u'DomainType',
        u'RequestedNodes',
        u'LocationInformation',
        u'LocationInformationEPS',
        u'LocationInformationGPRS',
        u'UserCSGInformation',
        u'GeographicalInformation',
        u'GeodeticInformation',
        u'LocationNumber',
        u'SubscriberState',
        u'PS-SubscriberState',
        u'PDP-ContextInfoList',
        u'PDP-ContextInfo',
        u'NSAPI',
        u'TransactionId',
        u'TEID',
        u'GPRSChargingID',
        u'NotReachableReason',
        u'AnyTimeInterrogationArg',
        u'AnyTimeInterrogationRes',
        u'AnyTimeSubscriptionInterrogationArg',
        u'AnyTimeSubscriptionInterrogationRes',
        u'CallWaitingData',
        u'Ext-CwFeatureList',
        u'Ext-CwFeature',
        u'ClipData',
        u'ClirData',
        u'CallHoldData',
        u'EctData',
        u'RequestedSubscriptionInfo',
        u'MSISDN-BS-List',
        u'MSISDN-BS',
        u'RequestedCAMEL-SubscriptionInfo',
        u'AdditionalRequestedCAMEL-SubscriptionInfo',
        u'CallForwardingData',
        u'CallBarringData',
        u'WrongPasswordAttemptsCounter',
        u'ODB-Info',
        u'CAMEL-SubscriptionInfo',
        u'AnyTimeModificationArg',
        u'ModificationRequestFor-CW-Info',
        u'ModificationRequestFor-CH-Info',
        u'ModificationRequestFor-ECT-Info',
        u'ModificationRequestFor-CLIR-Info',
        u'ModificationRequestFor-CLIP-Info',
        u'ModificationRequestFor-CSG',
        u'RequestedServingNode',
        u'ServingNode',
        u'AnyTimeModificationRes',
        u'ModificationRequestFor-CF-Info',
        u'ModificationRequestFor-CB-Info',
        u'ModificationRequestFor-ODB-data',
        u'ModificationRequestFor-CSI',
        u'ModificationRequestFor-IP-SM-GW-Data',
        u'ModificationInstruction',
        u'NoteSubscriberDataModifiedArg',
        u'NoteSubscriberDataModifiedRes',
        u'NoteMM-EventArg',
        u'NoteMM-EventRes',
        u'Ext-SS-InfoFor-CSE',
        u'Ext-ForwardingInfoFor-CSE',
        u'Ext-CallBarringInfoFor-CSE',
        u'UpdateVcsgLocationArg',
        u'UpdateVcsgLocationRes',
        u'CancelVcsgLocationArg',
        u'CancelVcsgLocationRes',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxPermittedIntegrityProtectionAlgorithmsLength',
        u'maxPermittedEncryptionAlgorithmsLength',
        u'maxNumOfServiceHandovers',
        u'maxNumOfRadioResources',
        u'maxNrOfRABs',
        u'maxNumOfRelocationNumber',
        u'maxNumOfIntegrityInfo',
        u'maxNumOfEncryptionInfo',
        u'maxNumOfLIPAAllowedAPN',
        u'maxNumOfAPN-Configurations',
        u'maxNumOfSpecificAPNInfos',
        u'maxNumOfGMLC',
        u'maxNumOfPDP-Contexts',
        u'maxNumOfLSAs',
        u'maxNumOfBearerServices',
        u'maxNumOfTeleservices',
        u'maxNumOfCUG',
        u'maxNumOfExt-BasicServiceGroups',
        u'maxNumOfPrivacyClass',
        u'maxNumOfExternalClient',
        u'maxNumOfPLMNClient',
        u'maxNumOfExt-ExternalClient',
        u'maxNumOfServiceType',
        u'maxNumOfMOLR-Class',
        u'maxNumOfZoneCodes',
        u'maxNumOfBasicServices',
        u'maxNumOfTPDUTypes',
        u'maxNumOfDP-AnalysedInfoCriteria',
        u'maxNumOfCamelSSEvents',
        u'maxNumOfCamelTDPData',
        u'maxNumOfISDN-AddressDigits',
        u'maxNumOfCamelDestinationNumbers',
        u'maxNumOfCamelDestinationNumberLengths',
        u'maxNumOfCamelBasicServiceCriteria',
        u'maxNumOfCAMEL-O-CauseValueCriteria',
        u'maxNumOfCAMEL-T-CauseValueCriteria',
        u'maxNumOfMobilityTriggers',
        u'maxNumOfVBSGroupIds',
        u'maxNumOfVGCSGroupIds',
        u'maxNumOfMSISDN',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< UpdateLocationArg >-----#
    UpdateLocationArg = SEQ(name=u'UpdateLocationArg', mode=MODE_TYPE)
    _UpdateLocationArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _UpdateLocationArg_msc_Number = OCT_STR(name=u'msc-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _UpdateLocationArg_vlr_Number = OCT_STR(name=u'vlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _UpdateLocationArg_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LMSI')), opt=True)
    _UpdateLocationArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _UpdateLocationArg_vlr_Capability = SEQ(name=u'vlr-Capability', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'VLR-Capability')), opt=True)
    _UpdateLocationArg_informPreviousNetworkEntity = NULL(name=u'informPreviousNetworkEntity', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateLocationArg_cs_LCS_NotSupportedByUE = NULL(name=u'cs-LCS-NotSupportedByUE', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateLocationArg_v_gmlc_Address = OCT_STR(name=u'v-gmlc-Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')), opt=True)
    _UpdateLocationArg_add_info = SEQ(name=u'add-info', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ADD-Info')), opt=True)
    _UpdateLocationArg_pagingArea = SEQ_OF(name=u'pagingArea', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PagingArea')), opt=True)
    _UpdateLocationArg_skipSubscriberDataUpdate = NULL(name=u'skipSubscriberDataUpdate', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateLocationArg_restorationIndicator = NULL(name=u'restorationIndicator', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateLocationArg_eplmn_List = SEQ_OF(name=u'eplmn-List', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EPLMN-List')), opt=True)
    _UpdateLocationArg_mme_DiameterAddress = SEQ(name=u'mme-DiameterAddress', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'NetworkNodeDiameterAddress')), opt=True)
    UpdateLocationArg._cont = ASN1Dict([
        (u'imsi', _UpdateLocationArg_imsi),
        (u'msc-Number', _UpdateLocationArg_msc_Number),
        (u'vlr-Number', _UpdateLocationArg_vlr_Number),
        (u'lmsi', _UpdateLocationArg_lmsi),
        (u'extensionContainer', _UpdateLocationArg_extensionContainer),
        (u'vlr-Capability', _UpdateLocationArg_vlr_Capability),
        (u'informPreviousNetworkEntity', _UpdateLocationArg_informPreviousNetworkEntity),
        (u'cs-LCS-NotSupportedByUE', _UpdateLocationArg_cs_LCS_NotSupportedByUE),
        (u'v-gmlc-Address', _UpdateLocationArg_v_gmlc_Address),
        (u'add-info', _UpdateLocationArg_add_info),
        (u'pagingArea', _UpdateLocationArg_pagingArea),
        (u'skipSubscriberDataUpdate', _UpdateLocationArg_skipSubscriberDataUpdate),
        (u'restorationIndicator', _UpdateLocationArg_restorationIndicator),
        (u'eplmn-List', _UpdateLocationArg_eplmn_List),
        (u'mme-DiameterAddress', _UpdateLocationArg_mme_DiameterAddress),
        ])
    UpdateLocationArg._ext = [u'vlr-Capability', u'informPreviousNetworkEntity', u'cs-LCS-NotSupportedByUE', u'v-gmlc-Address', u'add-info', u'pagingArea', u'skipSubscriberDataUpdate', u'restorationIndicator', u'eplmn-List', u'mme-DiameterAddress']
    
    #-----< VLR-Capability >-----#
    VLR_Capability = SEQ(name=u'VLR-Capability', mode=MODE_TYPE)
    _VLR_Capability_supportedCamelPhases = BIT_STR(name=u'supportedCamelPhases', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCamelPhases')), opt=True)
    _VLR_Capability_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _VLR_Capability_solsaSupportIndicator = NULL(name=u'solsaSupportIndicator', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _VLR_Capability_istSupportIndicator = ENUM(name=u'istSupportIndicator', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'IST-SupportIndicator')), opt=True)
    _VLR_Capability_superChargerSupportedInServingNetworkEntity = CHOICE(name=u'superChargerSupportedInServingNetworkEntity', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SuperChargerInfo')), opt=True)
    _VLR_Capability_longFTN_Supported = NULL(name=u'longFTN-Supported', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _VLR_Capability_supportedLCS_CapabilitySets = BIT_STR(name=u'supportedLCS-CapabilitySets', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedLCS-CapabilitySets')), opt=True)
    _VLR_Capability_offeredCamel4CSIs = BIT_STR(name=u'offeredCamel4CSIs', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'OfferedCamel4CSIs')), opt=True)
    _VLR_Capability_supportedRAT_TypesIndicator = BIT_STR(name=u'supportedRAT-TypesIndicator', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedRAT-Types')), opt=True)
    _VLR_Capability_longGroupID_Supported = NULL(name=u'longGroupID-Supported', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _VLR_Capability_mtRoamingForwardingSupported = NULL(name=u'mtRoamingForwardingSupported', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _VLR_Capability_msisdn_lessOperation_Supported = NULL(name=u'msisdn-lessOperation-Supported', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    VLR_Capability._cont = ASN1Dict([
        (u'supportedCamelPhases', _VLR_Capability_supportedCamelPhases),
        (u'extensionContainer', _VLR_Capability_extensionContainer),
        (u'solsaSupportIndicator', _VLR_Capability_solsaSupportIndicator),
        (u'istSupportIndicator', _VLR_Capability_istSupportIndicator),
        (u'superChargerSupportedInServingNetworkEntity', _VLR_Capability_superChargerSupportedInServingNetworkEntity),
        (u'longFTN-Supported', _VLR_Capability_longFTN_Supported),
        (u'supportedLCS-CapabilitySets', _VLR_Capability_supportedLCS_CapabilitySets),
        (u'offeredCamel4CSIs', _VLR_Capability_offeredCamel4CSIs),
        (u'supportedRAT-TypesIndicator', _VLR_Capability_supportedRAT_TypesIndicator),
        (u'longGroupID-Supported', _VLR_Capability_longGroupID_Supported),
        (u'mtRoamingForwardingSupported', _VLR_Capability_mtRoamingForwardingSupported),
        (u'msisdn-lessOperation-Supported', _VLR_Capability_msisdn_lessOperation_Supported),
        ])
    VLR_Capability._ext = [u'solsaSupportIndicator', u'istSupportIndicator', u'superChargerSupportedInServingNetworkEntity', u'longFTN-Supported', u'supportedLCS-CapabilitySets', u'offeredCamel4CSIs', u'supportedRAT-TypesIndicator', u'longGroupID-Supported', u'mtRoamingForwardingSupported', u'msisdn-lessOperation-Supported']
    
    #-----< SupportedRAT-Types >-----#
    SupportedRAT_Types = BIT_STR(name=u'SupportedRAT-Types', mode=MODE_TYPE)
    SupportedRAT_Types._cont = ASN1Dict([(u'utran', 0), (u'geran', 1), (u'gan', 2), (u'i-hspa-evolution', 3), (u'e-utran', 4)])
    SupportedRAT_Types._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=8)], ev=None, er=[])
    
    #-----< SuperChargerInfo >-----#
    SuperChargerInfo = CHOICE(name=u'SuperChargerInfo', mode=MODE_TYPE)
    _SuperChargerInfo_sendSubscriberData = NULL(name=u'sendSubscriberData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SuperChargerInfo_subscriberDataStored = OCT_STR(name=u'subscriberDataStored', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AgeIndicator')))
    SuperChargerInfo._cont = ASN1Dict([
        (u'sendSubscriberData', _SuperChargerInfo_sendSubscriberData),
        (u'subscriberDataStored', _SuperChargerInfo_subscriberDataStored),
        ])
    SuperChargerInfo._ext = None
    
    #-----< AgeIndicator >-----#
    AgeIndicator = OCT_STR(name=u'AgeIndicator', mode=MODE_TYPE)
    AgeIndicator._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=6)], ev=None, er=[])
    
    #-----< IST-SupportIndicator >-----#
    IST_SupportIndicator = ENUM(name=u'IST-SupportIndicator', mode=MODE_TYPE)
    IST_SupportIndicator._cont = ASN1Dict([(u'basicISTSupported', 0), (u'istCommandSupported', 1)])
    IST_SupportIndicator._ext = []
    
    #-----< SupportedLCS-CapabilitySets >-----#
    SupportedLCS_CapabilitySets = BIT_STR(name=u'SupportedLCS-CapabilitySets', mode=MODE_TYPE)
    SupportedLCS_CapabilitySets._cont = ASN1Dict([(u'lcsCapabilitySet1', 0), (u'lcsCapabilitySet2', 1), (u'lcsCapabilitySet3', 2), (u'lcsCapabilitySet4', 3), (u'lcsCapabilitySet5', 4)])
    SupportedLCS_CapabilitySets._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=16)], ev=None, er=[])
    
    #-----< UpdateLocationRes >-----#
    UpdateLocationRes = SEQ(name=u'UpdateLocationRes', mode=MODE_TYPE)
    _UpdateLocationRes_hlr_Number = OCT_STR(name=u'hlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _UpdateLocationRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _UpdateLocationRes_add_Capability = NULL(name=u'add-Capability', mode=MODE_TYPE, opt=True)
    _UpdateLocationRes_pagingArea_Capability = NULL(name=u'pagingArea-Capability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    UpdateLocationRes._cont = ASN1Dict([
        (u'hlr-Number', _UpdateLocationRes_hlr_Number),
        (u'extensionContainer', _UpdateLocationRes_extensionContainer),
        (u'add-Capability', _UpdateLocationRes_add_Capability),
        (u'pagingArea-Capability', _UpdateLocationRes_pagingArea_Capability),
        ])
    UpdateLocationRes._ext = [u'add-Capability', u'pagingArea-Capability']
    
    #-----< ADD-Info >-----#
    ADD_Info = SEQ(name=u'ADD-Info', mode=MODE_TYPE)
    _ADD_Info_imeisv = OCT_STR(name=u'imeisv', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMEI')))
    _ADD_Info_skipSubscriberDataUpdate = NULL(name=u'skipSubscriberDataUpdate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ADD_Info._cont = ASN1Dict([
        (u'imeisv', _ADD_Info_imeisv),
        (u'skipSubscriberDataUpdate', _ADD_Info_skipSubscriberDataUpdate),
        ])
    ADD_Info._ext = []
    
    #-----< PagingArea >-----#
    PagingArea = SEQ_OF(name=u'PagingArea', mode=MODE_TYPE)
    _PagingArea__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationArea')))
    PagingArea._cont = _PagingArea__item_
    PagingArea._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< LocationArea >-----#
    LocationArea = CHOICE(name=u'LocationArea', mode=MODE_TYPE)
    _LocationArea_laiFixedLength = OCT_STR(name=u'laiFixedLength', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LAIFixedLength')))
    _LocationArea_lac = OCT_STR(name=u'lac', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LAC')))
    LocationArea._cont = ASN1Dict([
        (u'laiFixedLength', _LocationArea_laiFixedLength),
        (u'lac', _LocationArea_lac),
        ])
    LocationArea._ext = None
    
    #-----< LAC >-----#
    LAC = OCT_STR(name=u'LAC', mode=MODE_TYPE)
    LAC._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< CancelLocationArg >-----#
    CancelLocationArg = SEQ(name=u'CancelLocationArg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CancelLocationArg_identity = CHOICE(name=u'identity', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Identity')))
    _CancelLocationArg_cancellationType = ENUM(name=u'cancellationType', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CancellationType')), opt=True)
    _CancelLocationArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _CancelLocationArg_typeOfUpdate = ENUM(name=u'typeOfUpdate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'TypeOfUpdate')), opt=True)
    _CancelLocationArg_mtrf_SupportedAndAuthorized = NULL(name=u'mtrf-SupportedAndAuthorized', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CancelLocationArg_mtrf_SupportedAndNotAuthorized = NULL(name=u'mtrf-SupportedAndNotAuthorized', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CancelLocationArg_newMSC_Number = OCT_STR(name=u'newMSC-Number', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _CancelLocationArg_newVLR_Number = OCT_STR(name=u'newVLR-Number', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _CancelLocationArg_new_lmsi = OCT_STR(name=u'new-lmsi', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LMSI')), opt=True)
    _CancelLocationArg_reattach_Required = NULL(name=u'reattach-Required', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    CancelLocationArg._cont = ASN1Dict([
        (u'identity', _CancelLocationArg_identity),
        (u'cancellationType', _CancelLocationArg_cancellationType),
        (u'extensionContainer', _CancelLocationArg_extensionContainer),
        (u'typeOfUpdate', _CancelLocationArg_typeOfUpdate),
        (u'mtrf-SupportedAndAuthorized', _CancelLocationArg_mtrf_SupportedAndAuthorized),
        (u'mtrf-SupportedAndNotAuthorized', _CancelLocationArg_mtrf_SupportedAndNotAuthorized),
        (u'newMSC-Number', _CancelLocationArg_newMSC_Number),
        (u'newVLR-Number', _CancelLocationArg_newVLR_Number),
        (u'new-lmsi', _CancelLocationArg_new_lmsi),
        (u'reattach-Required', _CancelLocationArg_reattach_Required),
        ])
    CancelLocationArg._ext = [u'typeOfUpdate', u'mtrf-SupportedAndAuthorized', u'mtrf-SupportedAndNotAuthorized', u'newMSC-Number', u'newVLR-Number', u'new-lmsi', u'reattach-Required']
    
    #-----< TypeOfUpdate >-----#
    TypeOfUpdate = ENUM(name=u'TypeOfUpdate', mode=MODE_TYPE)
    TypeOfUpdate._cont = ASN1Dict([(u'sgsn-change', 0), (u'mme-change', 1)])
    TypeOfUpdate._ext = []
    
    #-----< CancellationType >-----#
    CancellationType = ENUM(name=u'CancellationType', mode=MODE_TYPE)
    CancellationType._cont = ASN1Dict([(u'updateProcedure', 0), (u'subscriptionWithdraw', 1), (u'initialAttachProcedure', 2)])
    CancellationType._ext = [u'initialAttachProcedure']
    
    #-----< CancelLocationRes >-----#
    CancelLocationRes = SEQ(name=u'CancelLocationRes', mode=MODE_TYPE)
    _CancelLocationRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CancelLocationRes._cont = ASN1Dict([
        (u'extensionContainer', _CancelLocationRes_extensionContainer),
        ])
    CancelLocationRes._ext = []
    
    #-----< PurgeMS-Arg >-----#
    PurgeMS_Arg = SEQ(name=u'PurgeMS-Arg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PurgeMS_Arg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _PurgeMS_Arg_vlr_Number = OCT_STR(name=u'vlr-Number', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _PurgeMS_Arg_sgsn_Number = OCT_STR(name=u'sgsn-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _PurgeMS_Arg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _PurgeMS_Arg_locationInformation = SEQ(name=u'locationInformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationInformation')), opt=True)
    _PurgeMS_Arg_locationInformationGPRS = SEQ(name=u'locationInformationGPRS', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationInformationGPRS')), opt=True)
    _PurgeMS_Arg_locationInformationEPS = SEQ(name=u'locationInformationEPS', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationInformationEPS')), opt=True)
    PurgeMS_Arg._cont = ASN1Dict([
        (u'imsi', _PurgeMS_Arg_imsi),
        (u'vlr-Number', _PurgeMS_Arg_vlr_Number),
        (u'sgsn-Number', _PurgeMS_Arg_sgsn_Number),
        (u'extensionContainer', _PurgeMS_Arg_extensionContainer),
        (u'locationInformation', _PurgeMS_Arg_locationInformation),
        (u'locationInformationGPRS', _PurgeMS_Arg_locationInformationGPRS),
        (u'locationInformationEPS', _PurgeMS_Arg_locationInformationEPS),
        ])
    PurgeMS_Arg._ext = [u'locationInformation', u'locationInformationGPRS', u'locationInformationEPS']
    
    #-----< PurgeMS-Res >-----#
    PurgeMS_Res = SEQ(name=u'PurgeMS-Res', mode=MODE_TYPE)
    _PurgeMS_Res_freezeTMSI = NULL(name=u'freezeTMSI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PurgeMS_Res_freezeP_TMSI = NULL(name=u'freezeP-TMSI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PurgeMS_Res_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _PurgeMS_Res_freezeM_TMSI = NULL(name=u'freezeM-TMSI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PurgeMS_Res._cont = ASN1Dict([
        (u'freezeTMSI', _PurgeMS_Res_freezeTMSI),
        (u'freezeP-TMSI', _PurgeMS_Res_freezeP_TMSI),
        (u'extensionContainer', _PurgeMS_Res_extensionContainer),
        (u'freezeM-TMSI', _PurgeMS_Res_freezeM_TMSI),
        ])
    PurgeMS_Res._ext = [u'freezeM-TMSI']
    
    #-----< SendIdentificationArg >-----#
    SendIdentificationArg = SEQ(name=u'SendIdentificationArg', mode=MODE_TYPE)
    _SendIdentificationArg_tmsi = OCT_STR(name=u'tmsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'TMSI')))
    _SendIdentificationArg_numberOfRequestedVectors = INT(name=u'numberOfRequestedVectors', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'NumberOfRequestedVectors')), opt=True)
    _SendIdentificationArg_segmentationProhibited = NULL(name=u'segmentationProhibited', mode=MODE_TYPE, opt=True)
    _SendIdentificationArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SendIdentificationArg_msc_Number = OCT_STR(name=u'msc-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _SendIdentificationArg_previous_LAI = OCT_STR(name=u'previous-LAI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LAIFixedLength')), opt=True)
    _SendIdentificationArg_hopCounter = INT(name=u'hopCounter', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'HopCounter')), opt=True)
    _SendIdentificationArg_mtRoamingForwardingSupported = NULL(name=u'mtRoamingForwardingSupported', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendIdentificationArg_newVLR_Number = OCT_STR(name=u'newVLR-Number', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _SendIdentificationArg_new_lmsi = OCT_STR(name=u'new-lmsi', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LMSI')), opt=True)
    SendIdentificationArg._cont = ASN1Dict([
        (u'tmsi', _SendIdentificationArg_tmsi),
        (u'numberOfRequestedVectors', _SendIdentificationArg_numberOfRequestedVectors),
        (u'segmentationProhibited', _SendIdentificationArg_segmentationProhibited),
        (u'extensionContainer', _SendIdentificationArg_extensionContainer),
        (u'msc-Number', _SendIdentificationArg_msc_Number),
        (u'previous-LAI', _SendIdentificationArg_previous_LAI),
        (u'hopCounter', _SendIdentificationArg_hopCounter),
        (u'mtRoamingForwardingSupported', _SendIdentificationArg_mtRoamingForwardingSupported),
        (u'newVLR-Number', _SendIdentificationArg_newVLR_Number),
        (u'new-lmsi', _SendIdentificationArg_new_lmsi),
        ])
    SendIdentificationArg._ext = [u'msc-Number', u'previous-LAI', u'hopCounter', u'mtRoamingForwardingSupported', u'newVLR-Number', u'new-lmsi']
    
    #-----< HopCounter >-----#
    HopCounter = INT(name=u'HopCounter', mode=MODE_TYPE)
    HopCounter._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=3)], ev=None, er=[])
    
    #-----< SendIdentificationRes >-----#
    SendIdentificationRes = SEQ(name=u'SendIdentificationRes', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SendIdentificationRes_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    _SendIdentificationRes_authenticationSetList = CHOICE(name=u'authenticationSetList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'AuthenticationSetList')), opt=True)
    _SendIdentificationRes_currentSecurityContext = CHOICE(name=u'currentSecurityContext', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CurrentSecurityContext')), opt=True)
    _SendIdentificationRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SendIdentificationRes_lastUsedLtePLMN_Id = OCT_STR(name=u'lastUsedLtePLMN-Id', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'PLMN-Id')), opt=True)
    _SendIdentificationRes_mtCallPendingFlag = NULL(name=u'mtCallPendingFlag', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    SendIdentificationRes._cont = ASN1Dict([
        (u'imsi', _SendIdentificationRes_imsi),
        (u'authenticationSetList', _SendIdentificationRes_authenticationSetList),
        (u'currentSecurityContext', _SendIdentificationRes_currentSecurityContext),
        (u'extensionContainer', _SendIdentificationRes_extensionContainer),
        (u'lastUsedLtePLMN-Id', _SendIdentificationRes_lastUsedLtePLMN_Id),
        (u'mtCallPendingFlag', _SendIdentificationRes_mtCallPendingFlag),
        ])
    SendIdentificationRes._ext = [u'lastUsedLtePLMN-Id', u'mtCallPendingFlag']
    
    #-----< AuthenticationSetList >-----#
    AuthenticationSetList = CHOICE(name=u'AuthenticationSetList', mode=MODE_TYPE)
    _AuthenticationSetList_tripletList = SEQ_OF(name=u'tripletList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'TripletList')))
    _AuthenticationSetList_quintupletList = SEQ_OF(name=u'quintupletList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'QuintupletList')))
    AuthenticationSetList._cont = ASN1Dict([
        (u'tripletList', _AuthenticationSetList_tripletList),
        (u'quintupletList', _AuthenticationSetList_quintupletList),
        ])
    AuthenticationSetList._ext = None
    
    #-----< TripletList >-----#
    TripletList = SEQ_OF(name=u'TripletList', mode=MODE_TYPE)
    _TripletList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'AuthenticationTriplet')))
    TripletList._cont = _TripletList__item_
    TripletList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< QuintupletList >-----#
    QuintupletList = SEQ_OF(name=u'QuintupletList', mode=MODE_TYPE)
    _QuintupletList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'AuthenticationQuintuplet')))
    QuintupletList._cont = _QuintupletList__item_
    QuintupletList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< AuthenticationTriplet >-----#
    AuthenticationTriplet = SEQ(name=u'AuthenticationTriplet', mode=MODE_TYPE)
    _AuthenticationTriplet_rand = OCT_STR(name=u'rand', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAND')))
    _AuthenticationTriplet_sres = OCT_STR(name=u'sres', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'SRES')))
    _AuthenticationTriplet_kc = OCT_STR(name=u'kc', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Kc')))
    AuthenticationTriplet._cont = ASN1Dict([
        (u'rand', _AuthenticationTriplet_rand),
        (u'sres', _AuthenticationTriplet_sres),
        (u'kc', _AuthenticationTriplet_kc),
        ])
    AuthenticationTriplet._ext = []
    
    #-----< AuthenticationQuintuplet >-----#
    AuthenticationQuintuplet = SEQ(name=u'AuthenticationQuintuplet', mode=MODE_TYPE)
    _AuthenticationQuintuplet_rand = OCT_STR(name=u'rand', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAND')))
    _AuthenticationQuintuplet_xres = OCT_STR(name=u'xres', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'XRES')))
    _AuthenticationQuintuplet_ck = OCT_STR(name=u'ck', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CK')))
    _AuthenticationQuintuplet_ik = OCT_STR(name=u'ik', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'IK')))
    _AuthenticationQuintuplet_autn = OCT_STR(name=u'autn', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'AUTN')))
    AuthenticationQuintuplet._cont = ASN1Dict([
        (u'rand', _AuthenticationQuintuplet_rand),
        (u'xres', _AuthenticationQuintuplet_xres),
        (u'ck', _AuthenticationQuintuplet_ck),
        (u'ik', _AuthenticationQuintuplet_ik),
        (u'autn', _AuthenticationQuintuplet_autn),
        ])
    AuthenticationQuintuplet._ext = []
    
    #-----< CurrentSecurityContext >-----#
    CurrentSecurityContext = CHOICE(name=u'CurrentSecurityContext', mode=MODE_TYPE)
    _CurrentSecurityContext_gsm_SecurityContextData = SEQ(name=u'gsm-SecurityContextData', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GSM-SecurityContextData')))
    _CurrentSecurityContext_umts_SecurityContextData = SEQ(name=u'umts-SecurityContextData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'UMTS-SecurityContextData')))
    CurrentSecurityContext._cont = ASN1Dict([
        (u'gsm-SecurityContextData', _CurrentSecurityContext_gsm_SecurityContextData),
        (u'umts-SecurityContextData', _CurrentSecurityContext_umts_SecurityContextData),
        ])
    CurrentSecurityContext._ext = None
    
    #-----< GSM-SecurityContextData >-----#
    GSM_SecurityContextData = SEQ(name=u'GSM-SecurityContextData', mode=MODE_TYPE)
    _GSM_SecurityContextData_kc = OCT_STR(name=u'kc', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Kc')))
    _GSM_SecurityContextData_cksn = OCT_STR(name=u'cksn', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Cksn')))
    GSM_SecurityContextData._cont = ASN1Dict([
        (u'kc', _GSM_SecurityContextData_kc),
        (u'cksn', _GSM_SecurityContextData_cksn),
        ])
    GSM_SecurityContextData._ext = []
    
    #-----< UMTS-SecurityContextData >-----#
    UMTS_SecurityContextData = SEQ(name=u'UMTS-SecurityContextData', mode=MODE_TYPE)
    _UMTS_SecurityContextData_ck = OCT_STR(name=u'ck', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CK')))
    _UMTS_SecurityContextData_ik = OCT_STR(name=u'ik', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'IK')))
    _UMTS_SecurityContextData_ksi = OCT_STR(name=u'ksi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'KSI')))
    UMTS_SecurityContextData._cont = ASN1Dict([
        (u'ck', _UMTS_SecurityContextData_ck),
        (u'ik', _UMTS_SecurityContextData_ik),
        (u'ksi', _UMTS_SecurityContextData_ksi),
        ])
    UMTS_SecurityContextData._ext = []
    
    #-----< RAND >-----#
    RAND = OCT_STR(name=u'RAND', mode=MODE_TYPE)
    RAND._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< SRES >-----#
    SRES = OCT_STR(name=u'SRES', mode=MODE_TYPE)
    SRES._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< Kc >-----#
    Kc = OCT_STR(name=u'Kc', mode=MODE_TYPE)
    Kc._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    
    #-----< XRES >-----#
    XRES = OCT_STR(name=u'XRES', mode=MODE_TYPE)
    XRES._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=4, ub=16)], ev=None, er=[])
    
    #-----< CK >-----#
    CK = OCT_STR(name=u'CK', mode=MODE_TYPE)
    CK._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< IK >-----#
    IK = OCT_STR(name=u'IK', mode=MODE_TYPE)
    IK._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< AUTN >-----#
    AUTN = OCT_STR(name=u'AUTN', mode=MODE_TYPE)
    AUTN._const_sz = ASN1Set(rv=[16], rr=[], ev=None, er=[])
    
    #-----< AUTS >-----#
    AUTS = OCT_STR(name=u'AUTS', mode=MODE_TYPE)
    AUTS._const_sz = ASN1Set(rv=[14], rr=[], ev=None, er=[])
    
    #-----< Cksn >-----#
    Cksn = OCT_STR(name=u'Cksn', mode=MODE_TYPE)
    Cksn._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< KSI >-----#
    KSI = OCT_STR(name=u'KSI', mode=MODE_TYPE)
    KSI._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< AuthenticationFailureReportArg >-----#
    AuthenticationFailureReportArg = SEQ(name=u'AuthenticationFailureReportArg', mode=MODE_TYPE)
    _AuthenticationFailureReportArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _AuthenticationFailureReportArg_failureCause = ENUM(name=u'failureCause', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'FailureCause')))
    _AuthenticationFailureReportArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _AuthenticationFailureReportArg_re_attempt = BOOL(name=u're-attempt', mode=MODE_TYPE, opt=True)
    _AuthenticationFailureReportArg_accessType = ENUM(name=u'accessType', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'AccessType')), opt=True)
    _AuthenticationFailureReportArg_rand = OCT_STR(name=u'rand', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAND')), opt=True)
    _AuthenticationFailureReportArg_vlr_Number = OCT_STR(name=u'vlr-Number', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _AuthenticationFailureReportArg_sgsn_Number = OCT_STR(name=u'sgsn-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    AuthenticationFailureReportArg._cont = ASN1Dict([
        (u'imsi', _AuthenticationFailureReportArg_imsi),
        (u'failureCause', _AuthenticationFailureReportArg_failureCause),
        (u'extensionContainer', _AuthenticationFailureReportArg_extensionContainer),
        (u're-attempt', _AuthenticationFailureReportArg_re_attempt),
        (u'accessType', _AuthenticationFailureReportArg_accessType),
        (u'rand', _AuthenticationFailureReportArg_rand),
        (u'vlr-Number', _AuthenticationFailureReportArg_vlr_Number),
        (u'sgsn-Number', _AuthenticationFailureReportArg_sgsn_Number),
        ])
    AuthenticationFailureReportArg._ext = [u're-attempt', u'accessType', u'rand', u'vlr-Number', u'sgsn-Number']
    
    #-----< AccessType >-----#
    AccessType = ENUM(name=u'AccessType', mode=MODE_TYPE)
    AccessType._cont = ASN1Dict([(u'call', 0), (u'emergencyCall', 1), (u'locationUpdating', 2), (u'supplementaryService', 3), (u'shortMessage', 4), (u'gprsAttach', 5), (u'routingAreaUpdating', 6), (u'serviceRequest', 7), (u'pdpContextActivation', 8), (u'pdpContextDeactivation', 9), (u'gprsDetach', 10)])
    AccessType._ext = [u'gprsDetach']
    
    #-----< AuthenticationFailureReportRes >-----#
    AuthenticationFailureReportRes = SEQ(name=u'AuthenticationFailureReportRes', mode=MODE_TYPE)
    _AuthenticationFailureReportRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    AuthenticationFailureReportRes._cont = ASN1Dict([
        (u'extensionContainer', _AuthenticationFailureReportRes_extensionContainer),
        ])
    AuthenticationFailureReportRes._ext = []
    
    #-----< FailureCause >-----#
    FailureCause = ENUM(name=u'FailureCause', mode=MODE_TYPE)
    FailureCause._cont = ASN1Dict([(u'wrongUserResponse', 0), (u'wrongNetworkSignature', 1)])
    FailureCause._ext = None
    
    #-----< UpdateGprsLocationArg >-----#
    UpdateGprsLocationArg = SEQ(name=u'UpdateGprsLocationArg', mode=MODE_TYPE)
    _UpdateGprsLocationArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _UpdateGprsLocationArg_sgsn_Number = OCT_STR(name=u'sgsn-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _UpdateGprsLocationArg_sgsn_Address = OCT_STR(name=u'sgsn-Address', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')))
    _UpdateGprsLocationArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _UpdateGprsLocationArg_sgsn_Capability = SEQ(name=u'sgsn-Capability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SGSN-Capability')), opt=True)
    _UpdateGprsLocationArg_informPreviousNetworkEntity = NULL(name=u'informPreviousNetworkEntity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_ps_LCS_NotSupportedByUE = NULL(name=u'ps-LCS-NotSupportedByUE', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_v_gmlc_Address = OCT_STR(name=u'v-gmlc-Address', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')), opt=True)
    _UpdateGprsLocationArg_add_info = SEQ(name=u'add-info', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ADD-Info')), opt=True)
    _UpdateGprsLocationArg_eps_info = CHOICE(name=u'eps-info', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EPS-Info')), opt=True)
    _UpdateGprsLocationArg_servingNodeTypeIndicator = NULL(name=u'servingNodeTypeIndicator', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_skipSubscriberDataUpdate = NULL(name=u'skipSubscriberDataUpdate', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_usedRAT_Type = ENUM(name=u'usedRAT-Type', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Used-RAT-Type')), opt=True)
    _UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded = NULL(name=u'gprsSubscriptionDataNotNeeded', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_nodeTypeIndicator = NULL(name=u'nodeTypeIndicator', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_areaRestricted = NULL(name=u'areaRestricted', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_ue_reachableIndicator = NULL(name=u'ue-reachableIndicator', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_epsSubscriptionDataNotNeeded = NULL(name=u'epsSubscriptionDataNotNeeded', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_ue_srvcc_Capability = ENUM(name=u'ue-srvcc-Capability', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'UE-SRVCC-Capability')), opt=True)
    _UpdateGprsLocationArg_eplmn_List = SEQ_OF(name=u'eplmn-List', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EPLMN-List')), opt=True)
    _UpdateGprsLocationArg_mmeNumberforMTSMS = OCT_STR(name=u'mmeNumberforMTSMS', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _UpdateGprsLocationArg_smsRegisterRequest = ENUM(name=u'smsRegisterRequest', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMSRegisterRequest')), opt=True)
    _UpdateGprsLocationArg_sms_Only = NULL(name=u'sms-Only', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_removalofMMERegistrationforSMS = NULL(name=u'removalofMMERegistrationforSMS', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_sgsn_Name = OCT_STR(name=u'sgsn-Name', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'DiameterIdentity')), opt=True)
    _UpdateGprsLocationArg_sgsn_Realm = OCT_STR(name=u'sgsn-Realm', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'DiameterIdentity')), opt=True)
    _UpdateGprsLocationArg_lgd_supportIndicator = NULL(name=u'lgd-supportIndicator', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationArg_adjacentPLMN_List = SEQ_OF(name=u'adjacentPLMN-List', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AdjacentPLMN-List')), opt=True)
    UpdateGprsLocationArg._cont = ASN1Dict([
        (u'imsi', _UpdateGprsLocationArg_imsi),
        (u'sgsn-Number', _UpdateGprsLocationArg_sgsn_Number),
        (u'sgsn-Address', _UpdateGprsLocationArg_sgsn_Address),
        (u'extensionContainer', _UpdateGprsLocationArg_extensionContainer),
        (u'sgsn-Capability', _UpdateGprsLocationArg_sgsn_Capability),
        (u'informPreviousNetworkEntity', _UpdateGprsLocationArg_informPreviousNetworkEntity),
        (u'ps-LCS-NotSupportedByUE', _UpdateGprsLocationArg_ps_LCS_NotSupportedByUE),
        (u'v-gmlc-Address', _UpdateGprsLocationArg_v_gmlc_Address),
        (u'add-info', _UpdateGprsLocationArg_add_info),
        (u'eps-info', _UpdateGprsLocationArg_eps_info),
        (u'servingNodeTypeIndicator', _UpdateGprsLocationArg_servingNodeTypeIndicator),
        (u'skipSubscriberDataUpdate', _UpdateGprsLocationArg_skipSubscriberDataUpdate),
        (u'usedRAT-Type', _UpdateGprsLocationArg_usedRAT_Type),
        (u'gprsSubscriptionDataNotNeeded', _UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded),
        (u'nodeTypeIndicator', _UpdateGprsLocationArg_nodeTypeIndicator),
        (u'areaRestricted', _UpdateGprsLocationArg_areaRestricted),
        (u'ue-reachableIndicator', _UpdateGprsLocationArg_ue_reachableIndicator),
        (u'epsSubscriptionDataNotNeeded', _UpdateGprsLocationArg_epsSubscriptionDataNotNeeded),
        (u'ue-srvcc-Capability', _UpdateGprsLocationArg_ue_srvcc_Capability),
        (u'eplmn-List', _UpdateGprsLocationArg_eplmn_List),
        (u'mmeNumberforMTSMS', _UpdateGprsLocationArg_mmeNumberforMTSMS),
        (u'smsRegisterRequest', _UpdateGprsLocationArg_smsRegisterRequest),
        (u'sms-Only', _UpdateGprsLocationArg_sms_Only),
        (u'removalofMMERegistrationforSMS', _UpdateGprsLocationArg_removalofMMERegistrationforSMS),
        (u'sgsn-Name', _UpdateGprsLocationArg_sgsn_Name),
        (u'sgsn-Realm', _UpdateGprsLocationArg_sgsn_Realm),
        (u'lgd-supportIndicator', _UpdateGprsLocationArg_lgd_supportIndicator),
        (u'adjacentPLMN-List', _UpdateGprsLocationArg_adjacentPLMN_List),
        ])
    UpdateGprsLocationArg._ext = [u'sgsn-Capability', u'informPreviousNetworkEntity', u'ps-LCS-NotSupportedByUE', u'v-gmlc-Address', u'add-info', u'eps-info', u'servingNodeTypeIndicator', u'skipSubscriberDataUpdate', u'usedRAT-Type', u'gprsSubscriptionDataNotNeeded', u'nodeTypeIndicator', u'areaRestricted', u'ue-reachableIndicator', u'epsSubscriptionDataNotNeeded', u'ue-srvcc-Capability', u'eplmn-List', u'mmeNumberforMTSMS', u'smsRegisterRequest', u'sms-Only', u'removalofMMERegistrationforSMS', u'sgsn-Name', u'sgsn-Realm', u'lgd-supportIndicator', u'adjacentPLMN-List']
    
    #-----< SMSRegisterRequest >-----#
    SMSRegisterRequest = ENUM(name=u'SMSRegisterRequest', mode=MODE_TYPE)
    SMSRegisterRequest._cont = ASN1Dict([(u'sms-registration-required', 0), (u'sms-registration-not-preferred', 1), (u'no-preference', 2)])
    SMSRegisterRequest._ext = []
    
    #-----< Used-RAT-Type >-----#
    Used_RAT_Type = ENUM(name=u'Used-RAT-Type', mode=MODE_TYPE)
    Used_RAT_Type._cont = ASN1Dict([(u'utran', 0), (u'geran', 1), (u'gan', 2), (u'i-hspa-evolution', 3), (u'e-utran', 4)])
    Used_RAT_Type._ext = []
    
    #-----< EPS-Info >-----#
    EPS_Info = CHOICE(name=u'EPS-Info', mode=MODE_TYPE)
    _EPS_Info_pdn_gw_update = SEQ(name=u'pdn-gw-update', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDN-GW-Update')))
    _EPS_Info_isr_Information = BIT_STR(name=u'isr-Information', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ISR-Information')))
    EPS_Info._cont = ASN1Dict([
        (u'pdn-gw-update', _EPS_Info_pdn_gw_update),
        (u'isr-Information', _EPS_Info_isr_Information),
        ])
    EPS_Info._ext = None
    
    #-----< PDN-GW-Update >-----#
    PDN_GW_Update = SEQ(name=u'PDN-GW-Update', mode=MODE_TYPE)
    _PDN_GW_Update_apn = OCT_STR(name=u'apn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN')), opt=True)
    _PDN_GW_Update_pdn_gw_Identity = SEQ(name=u'pdn-gw-Identity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDN-GW-Identity')), opt=True)
    _PDN_GW_Update_contextId = INT(name=u'contextId', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ContextId')), opt=True)
    _PDN_GW_Update_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    PDN_GW_Update._cont = ASN1Dict([
        (u'apn', _PDN_GW_Update_apn),
        (u'pdn-gw-Identity', _PDN_GW_Update_pdn_gw_Identity),
        (u'contextId', _PDN_GW_Update_contextId),
        (u'extensionContainer', _PDN_GW_Update_extensionContainer),
        ])
    PDN_GW_Update._ext = []
    
    #-----< ISR-Information >-----#
    ISR_Information = BIT_STR(name=u'ISR-Information', mode=MODE_TYPE)
    ISR_Information._cont = ASN1Dict([(u'updateLocation', 0), (u'cancelSGSN', 1), (u'initialAttachIndicator', 2)])
    ISR_Information._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=8)], ev=None, er=[])
    
    #-----< SGSN-Capability >-----#
    SGSN_Capability = SEQ(name=u'SGSN-Capability', mode=MODE_TYPE)
    _SGSN_Capability_solsaSupportIndicator = NULL(name=u'solsaSupportIndicator', mode=MODE_TYPE, opt=True)
    _SGSN_Capability_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SGSN_Capability_superChargerSupportedInServingNetworkEntity = CHOICE(name=u'superChargerSupportedInServingNetworkEntity', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SuperChargerInfo')), opt=True)
    _SGSN_Capability_gprsEnhancementsSupportIndicator = NULL(name=u'gprsEnhancementsSupportIndicator', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SGSN_Capability_supportedCamelPhases = BIT_STR(name=u'supportedCamelPhases', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCamelPhases')), opt=True)
    _SGSN_Capability_supportedLCS_CapabilitySets = BIT_STR(name=u'supportedLCS-CapabilitySets', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedLCS-CapabilitySets')), opt=True)
    _SGSN_Capability_offeredCamel4CSIs = BIT_STR(name=u'offeredCamel4CSIs', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'OfferedCamel4CSIs')), opt=True)
    _SGSN_Capability_smsCallBarringSupportIndicator = NULL(name=u'smsCallBarringSupportIndicator', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SGSN_Capability_supportedRAT_TypesIndicator = BIT_STR(name=u'supportedRAT-TypesIndicator', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedRAT-Types')), opt=True)
    _SGSN_Capability_supportedFeatures = BIT_STR(name=u'supportedFeatures', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedFeatures')), opt=True)
    _SGSN_Capability_t_adsDataRetrieval = NULL(name=u't-adsDataRetrieval', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SGSN_Capability_homogeneousSupportOfIMSVoiceOverPSSessions = BOOL(name=u'homogeneousSupportOfIMSVoiceOverPSSessions', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SGSN_Capability_cancellationTypeInitialAttach = NULL(name=u'cancellationTypeInitialAttach', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SGSN_Capability_msisdn_lessOperation_Supported = NULL(name=u'msisdn-lessOperation-Supported', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SGSN_Capability_updateofHomogeneousSupportOfIMSVoiceOverPSSessions = NULL(name=u'updateofHomogeneousSupportOfIMSVoiceOverPSSessions', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    SGSN_Capability._cont = ASN1Dict([
        (u'solsaSupportIndicator', _SGSN_Capability_solsaSupportIndicator),
        (u'extensionContainer', _SGSN_Capability_extensionContainer),
        (u'superChargerSupportedInServingNetworkEntity', _SGSN_Capability_superChargerSupportedInServingNetworkEntity),
        (u'gprsEnhancementsSupportIndicator', _SGSN_Capability_gprsEnhancementsSupportIndicator),
        (u'supportedCamelPhases', _SGSN_Capability_supportedCamelPhases),
        (u'supportedLCS-CapabilitySets', _SGSN_Capability_supportedLCS_CapabilitySets),
        (u'offeredCamel4CSIs', _SGSN_Capability_offeredCamel4CSIs),
        (u'smsCallBarringSupportIndicator', _SGSN_Capability_smsCallBarringSupportIndicator),
        (u'supportedRAT-TypesIndicator', _SGSN_Capability_supportedRAT_TypesIndicator),
        (u'supportedFeatures', _SGSN_Capability_supportedFeatures),
        (u't-adsDataRetrieval', _SGSN_Capability_t_adsDataRetrieval),
        (u'homogeneousSupportOfIMSVoiceOverPSSessions', _SGSN_Capability_homogeneousSupportOfIMSVoiceOverPSSessions),
        (u'cancellationTypeInitialAttach', _SGSN_Capability_cancellationTypeInitialAttach),
        (u'msisdn-lessOperation-Supported', _SGSN_Capability_msisdn_lessOperation_Supported),
        (u'updateofHomogeneousSupportOfIMSVoiceOverPSSessions', _SGSN_Capability_updateofHomogeneousSupportOfIMSVoiceOverPSSessions),
        ])
    SGSN_Capability._ext = [u'superChargerSupportedInServingNetworkEntity', u'gprsEnhancementsSupportIndicator', u'supportedCamelPhases', u'supportedLCS-CapabilitySets', u'offeredCamel4CSIs', u'smsCallBarringSupportIndicator', u'supportedRAT-TypesIndicator', u'supportedFeatures', u't-adsDataRetrieval', u'homogeneousSupportOfIMSVoiceOverPSSessions', u'cancellationTypeInitialAttach', u'msisdn-lessOperation-Supported', u'updateofHomogeneousSupportOfIMSVoiceOverPSSessions']
    
    #-----< SupportedFeatures >-----#
    SupportedFeatures = BIT_STR(name=u'SupportedFeatures', mode=MODE_TYPE)
    SupportedFeatures._cont = ASN1Dict([(u'odb-all-apn', 0), (u'odb-HPLMN-APN', 1), (u'odb-VPLMN-APN', 2), (u'odb-all-og', 3), (u'odb-all-international-og', 4), (u'odb-all-int-og-not-to-HPLMN-country', 5), (u'odb-all-interzonal-og', 6), (u'odb-all-interzonal-og-not-to-HPLMN-country', 7), (u'odb-all-interzonal-og-and-internat-og-not-to-HPLMN-country', 8), (u'regSub', 9), (u'trace', 10), (u'lcs-all-PrivExcep', 11), (u'lcs-universal', 12), (u'lcs-CallSessionRelated', 13), (u'lcs-CallSessionUnrelated', 14), (u'lcs-PLMN-operator', 15), (u'lcs-ServiceType', 16), (u'lcs-all-MOLR-SS', 17), (u'lcs-basicSelfLocation', 18), (u'lcs-autonomousSelfLocation', 19), (u'lcs-transferToThirdParty', 20), (u'sm-mo-pp', 21), (u'barring-OutgoingCalls', 22), (u'baoc', 23), (u'boic', 24), (u'boicExHC', 25), (u'localTimeZoneRetrieval', 26), (u'additionalMsisdn', 27), (u'smsInMME', 28), (u'smsInSGSN', 29), (u'ue-Reachability-Notification', 30), (u'state-Location-Information-Retrieval', 31), (u'partialPurge', 32), (u'gddInSGSN', 33), (u'sgsnCAMELCapability', 34), (u'pcscf-Restoration', 35), (u'dedicatedCoreNetworks', 36), (u'non-IP-PDN-Type-APNs', 37)])
    SupportedFeatures._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=26, ub=40)], ev=None, er=[])
    
    #-----< UE-SRVCC-Capability >-----#
    UE_SRVCC_Capability = ENUM(name=u'UE-SRVCC-Capability', mode=MODE_TYPE)
    UE_SRVCC_Capability._cont = ASN1Dict([(u'ue-srvcc-not-supported', 0), (u'ue-srvcc-supported', 1)])
    UE_SRVCC_Capability._ext = []
    
    #-----< UpdateGprsLocationRes >-----#
    UpdateGprsLocationRes = SEQ(name=u'UpdateGprsLocationRes', mode=MODE_TYPE)
    _UpdateGprsLocationRes_hlr_Number = OCT_STR(name=u'hlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _UpdateGprsLocationRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _UpdateGprsLocationRes_add_Capability = NULL(name=u'add-Capability', mode=MODE_TYPE, opt=True)
    _UpdateGprsLocationRes_sgsn_mmeSeparationSupported = NULL(name=u'sgsn-mmeSeparationSupported', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UpdateGprsLocationRes_mmeRegisteredforSMS = NULL(name=u'mmeRegisteredforSMS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    UpdateGprsLocationRes._cont = ASN1Dict([
        (u'hlr-Number', _UpdateGprsLocationRes_hlr_Number),
        (u'extensionContainer', _UpdateGprsLocationRes_extensionContainer),
        (u'add-Capability', _UpdateGprsLocationRes_add_Capability),
        (u'sgsn-mmeSeparationSupported', _UpdateGprsLocationRes_sgsn_mmeSeparationSupported),
        (u'mmeRegisteredforSMS', _UpdateGprsLocationRes_mmeRegisteredforSMS),
        ])
    UpdateGprsLocationRes._ext = [u'add-Capability', u'sgsn-mmeSeparationSupported', u'mmeRegisteredforSMS']
    
    #-----< EPLMN-List >-----#
    EPLMN_List = SEQ_OF(name=u'EPLMN-List', mode=MODE_TYPE)
    _EPLMN_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'PLMN-Id')))
    EPLMN_List._cont = _EPLMN_List__item_
    EPLMN_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< AdjacentPLMN-List >-----#
    AdjacentPLMN_List = SEQ_OF(name=u'AdjacentPLMN-List', mode=MODE_TYPE)
    _AdjacentPLMN_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'PLMN-Id')))
    AdjacentPLMN_List._cont = _AdjacentPLMN_List__item_
    AdjacentPLMN_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< ForwardAccessSignalling-Arg >-----#
    ForwardAccessSignalling_Arg = SEQ(name=u'ForwardAccessSignalling-Arg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ForwardAccessSignalling_Arg_an_APDU = SEQ(name=u'an-APDU', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AccessNetworkSignalInfo')))
    _ForwardAccessSignalling_Arg_integrityProtectionInfo = OCT_STR(name=u'integrityProtectionInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'IntegrityProtectionInformation')), opt=True)
    _ForwardAccessSignalling_Arg_encryptionInfo = OCT_STR(name=u'encryptionInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EncryptionInformation')), opt=True)
    _ForwardAccessSignalling_Arg_keyStatus = ENUM(name=u'keyStatus', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'KeyStatus')), opt=True)
    _ForwardAccessSignalling_Arg_allowedGSM_Algorithms = OCT_STR(name=u'allowedGSM-Algorithms', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AllowedGSM-Algorithms')), opt=True)
    _ForwardAccessSignalling_Arg_allowedUMTS_Algorithms = SEQ(name=u'allowedUMTS-Algorithms', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AllowedUMTS-Algorithms')), opt=True)
    _ForwardAccessSignalling_Arg_radioResourceInformation = OCT_STR(name=u'radioResourceInformation', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RadioResourceInformation')), opt=True)
    _ForwardAccessSignalling_Arg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ForwardAccessSignalling_Arg_radioResourceList = SEQ_OF(name=u'radioResourceList', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RadioResourceList')), opt=True)
    _ForwardAccessSignalling_Arg_bssmap_ServiceHandover = OCT_STR(name=u'bssmap-ServiceHandover', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BSSMAP-ServiceHandover')), opt=True)
    _ForwardAccessSignalling_Arg_ranap_ServiceHandover = OCT_STR(name=u'ranap-ServiceHandover', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RANAP-ServiceHandover')), opt=True)
    _ForwardAccessSignalling_Arg_bssmap_ServiceHandoverList = SEQ_OF(name=u'bssmap-ServiceHandoverList', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BSSMAP-ServiceHandoverList')), opt=True)
    _ForwardAccessSignalling_Arg_currentlyUsedCodec = OCT_STR(name=u'currentlyUsedCodec', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _ForwardAccessSignalling_Arg_iuSupportedCodecsList = SEQ(name=u'iuSupportedCodecsList', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCodecsList')), opt=True)
    _ForwardAccessSignalling_Arg_rab_ConfigurationIndicator = NULL(name=u'rab-ConfigurationIndicator', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ForwardAccessSignalling_Arg_iuSelectedCodec = OCT_STR(name=u'iuSelectedCodec', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _ForwardAccessSignalling_Arg_alternativeChannelType = OCT_STR(name=u'alternativeChannelType', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RadioResourceInformation')), opt=True)
    _ForwardAccessSignalling_Arg_tracePropagationList = SEQ(name=u'tracePropagationList', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TracePropagationList')), opt=True)
    _ForwardAccessSignalling_Arg_aoipSupportedCodecsListAnchor = SEQ(name=u'aoipSupportedCodecsListAnchor', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodecsList')), opt=True)
    _ForwardAccessSignalling_Arg_aoipSelectedCodecTarget = OCT_STR(name=u'aoipSelectedCodecTarget', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')), opt=True)
    _ForwardAccessSignalling_Arg_uesbi_Iu = SEQ(name=u'uesbi-Iu', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'UESBI-Iu')), opt=True)
    _ForwardAccessSignalling_Arg_imeisv = OCT_STR(name=u'imeisv', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMEI')), opt=True)
    ForwardAccessSignalling_Arg._cont = ASN1Dict([
        (u'an-APDU', _ForwardAccessSignalling_Arg_an_APDU),
        (u'integrityProtectionInfo', _ForwardAccessSignalling_Arg_integrityProtectionInfo),
        (u'encryptionInfo', _ForwardAccessSignalling_Arg_encryptionInfo),
        (u'keyStatus', _ForwardAccessSignalling_Arg_keyStatus),
        (u'allowedGSM-Algorithms', _ForwardAccessSignalling_Arg_allowedGSM_Algorithms),
        (u'allowedUMTS-Algorithms', _ForwardAccessSignalling_Arg_allowedUMTS_Algorithms),
        (u'radioResourceInformation', _ForwardAccessSignalling_Arg_radioResourceInformation),
        (u'extensionContainer', _ForwardAccessSignalling_Arg_extensionContainer),
        (u'radioResourceList', _ForwardAccessSignalling_Arg_radioResourceList),
        (u'bssmap-ServiceHandover', _ForwardAccessSignalling_Arg_bssmap_ServiceHandover),
        (u'ranap-ServiceHandover', _ForwardAccessSignalling_Arg_ranap_ServiceHandover),
        (u'bssmap-ServiceHandoverList', _ForwardAccessSignalling_Arg_bssmap_ServiceHandoverList),
        (u'currentlyUsedCodec', _ForwardAccessSignalling_Arg_currentlyUsedCodec),
        (u'iuSupportedCodecsList', _ForwardAccessSignalling_Arg_iuSupportedCodecsList),
        (u'rab-ConfigurationIndicator', _ForwardAccessSignalling_Arg_rab_ConfigurationIndicator),
        (u'iuSelectedCodec', _ForwardAccessSignalling_Arg_iuSelectedCodec),
        (u'alternativeChannelType', _ForwardAccessSignalling_Arg_alternativeChannelType),
        (u'tracePropagationList', _ForwardAccessSignalling_Arg_tracePropagationList),
        (u'aoipSupportedCodecsListAnchor', _ForwardAccessSignalling_Arg_aoipSupportedCodecsListAnchor),
        (u'aoipSelectedCodecTarget', _ForwardAccessSignalling_Arg_aoipSelectedCodecTarget),
        (u'uesbi-Iu', _ForwardAccessSignalling_Arg_uesbi_Iu),
        (u'imeisv', _ForwardAccessSignalling_Arg_imeisv),
        ])
    ForwardAccessSignalling_Arg._ext = [u'radioResourceList', u'bssmap-ServiceHandover', u'ranap-ServiceHandover', u'bssmap-ServiceHandoverList', u'currentlyUsedCodec', u'iuSupportedCodecsList', u'rab-ConfigurationIndicator', u'iuSelectedCodec', u'alternativeChannelType', u'tracePropagationList', u'aoipSupportedCodecsListAnchor', u'aoipSelectedCodecTarget', u'uesbi-Iu', u'imeisv']
    
    #-----< AllowedGSM-Algorithms >-----#
    AllowedGSM_Algorithms = OCT_STR(name=u'AllowedGSM-Algorithms', mode=MODE_TYPE)
    AllowedGSM_Algorithms._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< AllowedUMTS-Algorithms >-----#
    AllowedUMTS_Algorithms = SEQ(name=u'AllowedUMTS-Algorithms', mode=MODE_TYPE)
    _AllowedUMTS_Algorithms_integrityProtectionAlgorithms = OCT_STR(name=u'integrityProtectionAlgorithms', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PermittedIntegrityProtectionAlgorithms')), opt=True)
    _AllowedUMTS_Algorithms_encryptionAlgorithms = OCT_STR(name=u'encryptionAlgorithms', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PermittedEncryptionAlgorithms')), opt=True)
    _AllowedUMTS_Algorithms_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    AllowedUMTS_Algorithms._cont = ASN1Dict([
        (u'integrityProtectionAlgorithms', _AllowedUMTS_Algorithms_integrityProtectionAlgorithms),
        (u'encryptionAlgorithms', _AllowedUMTS_Algorithms_encryptionAlgorithms),
        (u'extensionContainer', _AllowedUMTS_Algorithms_extensionContainer),
        ])
    AllowedUMTS_Algorithms._ext = []
    
    #-----< PermittedIntegrityProtectionAlgorithms >-----#
    PermittedIntegrityProtectionAlgorithms = OCT_STR(name=u'PermittedIntegrityProtectionAlgorithms', mode=MODE_TYPE)
    PermittedIntegrityProtectionAlgorithms._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9)], ev=None, er=[])
    
    #-----< maxPermittedIntegrityProtectionAlgorithmsLength >-----#
    maxPermittedIntegrityProtectionAlgorithmsLength = INT(name=u'maxPermittedIntegrityProtectionAlgorithmsLength', mode=MODE_VALUE)
    maxPermittedIntegrityProtectionAlgorithmsLength._val = 9
    
    #-----< PermittedEncryptionAlgorithms >-----#
    PermittedEncryptionAlgorithms = OCT_STR(name=u'PermittedEncryptionAlgorithms', mode=MODE_TYPE)
    PermittedEncryptionAlgorithms._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9)], ev=None, er=[])
    
    #-----< maxPermittedEncryptionAlgorithmsLength >-----#
    maxPermittedEncryptionAlgorithmsLength = INT(name=u'maxPermittedEncryptionAlgorithmsLength', mode=MODE_VALUE)
    maxPermittedEncryptionAlgorithmsLength._val = 9
    
    #-----< KeyStatus >-----#
    KeyStatus = ENUM(name=u'KeyStatus', mode=MODE_TYPE)
    KeyStatus._cont = ASN1Dict([(u'old', 0), (u'new', 1)])
    KeyStatus._ext = []
    
    #-----< PrepareHO-Arg >-----#
    PrepareHO_Arg = SEQ(name=u'PrepareHO-Arg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PrepareHO_Arg_targetCellId = OCT_STR(name=u'targetCellId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GlobalCellId')), opt=True)
    _PrepareHO_Arg_ho_NumberNotRequired = NULL(name=u'ho-NumberNotRequired', mode=MODE_TYPE, opt=True)
    _PrepareHO_Arg_targetRNCId = OCT_STR(name=u'targetRNCId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RNCId')), opt=True)
    _PrepareHO_Arg_an_APDU = SEQ(name=u'an-APDU', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AccessNetworkSignalInfo')), opt=True)
    _PrepareHO_Arg_multipleBearerRequested = NULL(name=u'multipleBearerRequested', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PrepareHO_Arg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    _PrepareHO_Arg_integrityProtectionInfo = OCT_STR(name=u'integrityProtectionInfo', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'IntegrityProtectionInformation')), opt=True)
    _PrepareHO_Arg_encryptionInfo = OCT_STR(name=u'encryptionInfo', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EncryptionInformation')), opt=True)
    _PrepareHO_Arg_radioResourceInformation = OCT_STR(name=u'radioResourceInformation', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RadioResourceInformation')), opt=True)
    _PrepareHO_Arg_allowedGSM_Algorithms = OCT_STR(name=u'allowedGSM-Algorithms', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AllowedGSM-Algorithms')), opt=True)
    _PrepareHO_Arg_allowedUMTS_Algorithms = SEQ(name=u'allowedUMTS-Algorithms', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AllowedUMTS-Algorithms')), opt=True)
    _PrepareHO_Arg_radioResourceList = SEQ_OF(name=u'radioResourceList', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RadioResourceList')), opt=True)
    _PrepareHO_Arg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _PrepareHO_Arg_rab_Id = INT(name=u'rab-Id', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAB-Id')), opt=True)
    _PrepareHO_Arg_bssmap_ServiceHandover = OCT_STR(name=u'bssmap-ServiceHandover', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BSSMAP-ServiceHandover')), opt=True)
    _PrepareHO_Arg_ranap_ServiceHandover = OCT_STR(name=u'ranap-ServiceHandover', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RANAP-ServiceHandover')), opt=True)
    _PrepareHO_Arg_bssmap_ServiceHandoverList = SEQ_OF(name=u'bssmap-ServiceHandoverList', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BSSMAP-ServiceHandoverList')), opt=True)
    _PrepareHO_Arg_asciCallReference = OCT_STR(name=u'asciCallReference', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ASCI-CallReference')), opt=True)
    _PrepareHO_Arg_geran_classmark = OCT_STR(name=u'geran-classmark', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GERAN-Classmark')), opt=True)
    _PrepareHO_Arg_iuCurrentlyUsedCodec = OCT_STR(name=u'iuCurrentlyUsedCodec', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _PrepareHO_Arg_iuSupportedCodecsList = SEQ(name=u'iuSupportedCodecsList', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCodecsList')), opt=True)
    _PrepareHO_Arg_rab_ConfigurationIndicator = NULL(name=u'rab-ConfigurationIndicator', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PrepareHO_Arg_uesbi_Iu = SEQ(name=u'uesbi-Iu', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'UESBI-Iu')), opt=True)
    _PrepareHO_Arg_imeisv = OCT_STR(name=u'imeisv', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMEI')), opt=True)
    _PrepareHO_Arg_alternativeChannelType = OCT_STR(name=u'alternativeChannelType', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RadioResourceInformation')), opt=True)
    _PrepareHO_Arg_tracePropagationList = SEQ(name=u'tracePropagationList', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TracePropagationList')), opt=True)
    _PrepareHO_Arg_aoipSupportedCodecsListAnchor = SEQ(name=u'aoipSupportedCodecsListAnchor', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodecsList')), opt=True)
    _PrepareHO_Arg_regionalSubscriptionData = SEQ_OF(name=u'regionalSubscriptionData', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ZoneCodeList')), opt=True)
    _PrepareHO_Arg_lclsGlobalCallReference = OCT_STR(name=u'lclsGlobalCallReference', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LCLS-GlobalCallReference')), opt=True)
    _PrepareHO_Arg_lcls_Negotiation = BIT_STR(name=u'lcls-Negotiation', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LCLS-Negotiation')), opt=True)
    _PrepareHO_Arg_lcls_Configuration_Preference = BIT_STR(name=u'lcls-Configuration-Preference', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LCLS-ConfigurationPreference')), opt=True)
    _PrepareHO_Arg_csg_SubscriptionDataList = SEQ_OF(name=u'csg-SubscriptionDataList', mode=MODE_TYPE, tag=(31, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CSG-SubscriptionDataList')), opt=True)
    PrepareHO_Arg._cont = ASN1Dict([
        (u'targetCellId', _PrepareHO_Arg_targetCellId),
        (u'ho-NumberNotRequired', _PrepareHO_Arg_ho_NumberNotRequired),
        (u'targetRNCId', _PrepareHO_Arg_targetRNCId),
        (u'an-APDU', _PrepareHO_Arg_an_APDU),
        (u'multipleBearerRequested', _PrepareHO_Arg_multipleBearerRequested),
        (u'imsi', _PrepareHO_Arg_imsi),
        (u'integrityProtectionInfo', _PrepareHO_Arg_integrityProtectionInfo),
        (u'encryptionInfo', _PrepareHO_Arg_encryptionInfo),
        (u'radioResourceInformation', _PrepareHO_Arg_radioResourceInformation),
        (u'allowedGSM-Algorithms', _PrepareHO_Arg_allowedGSM_Algorithms),
        (u'allowedUMTS-Algorithms', _PrepareHO_Arg_allowedUMTS_Algorithms),
        (u'radioResourceList', _PrepareHO_Arg_radioResourceList),
        (u'extensionContainer', _PrepareHO_Arg_extensionContainer),
        (u'rab-Id', _PrepareHO_Arg_rab_Id),
        (u'bssmap-ServiceHandover', _PrepareHO_Arg_bssmap_ServiceHandover),
        (u'ranap-ServiceHandover', _PrepareHO_Arg_ranap_ServiceHandover),
        (u'bssmap-ServiceHandoverList', _PrepareHO_Arg_bssmap_ServiceHandoverList),
        (u'asciCallReference', _PrepareHO_Arg_asciCallReference),
        (u'geran-classmark', _PrepareHO_Arg_geran_classmark),
        (u'iuCurrentlyUsedCodec', _PrepareHO_Arg_iuCurrentlyUsedCodec),
        (u'iuSupportedCodecsList', _PrepareHO_Arg_iuSupportedCodecsList),
        (u'rab-ConfigurationIndicator', _PrepareHO_Arg_rab_ConfigurationIndicator),
        (u'uesbi-Iu', _PrepareHO_Arg_uesbi_Iu),
        (u'imeisv', _PrepareHO_Arg_imeisv),
        (u'alternativeChannelType', _PrepareHO_Arg_alternativeChannelType),
        (u'tracePropagationList', _PrepareHO_Arg_tracePropagationList),
        (u'aoipSupportedCodecsListAnchor', _PrepareHO_Arg_aoipSupportedCodecsListAnchor),
        (u'regionalSubscriptionData', _PrepareHO_Arg_regionalSubscriptionData),
        (u'lclsGlobalCallReference', _PrepareHO_Arg_lclsGlobalCallReference),
        (u'lcls-Negotiation', _PrepareHO_Arg_lcls_Negotiation),
        (u'lcls-Configuration-Preference', _PrepareHO_Arg_lcls_Configuration_Preference),
        (u'csg-SubscriptionDataList', _PrepareHO_Arg_csg_SubscriptionDataList),
        ])
    PrepareHO_Arg._ext = [u'rab-Id', u'bssmap-ServiceHandover', u'ranap-ServiceHandover', u'bssmap-ServiceHandoverList', u'asciCallReference', u'geran-classmark', u'iuCurrentlyUsedCodec', u'iuSupportedCodecsList', u'rab-ConfigurationIndicator', u'uesbi-Iu', u'imeisv', u'alternativeChannelType', u'tracePropagationList', u'aoipSupportedCodecsListAnchor', u'regionalSubscriptionData', u'lclsGlobalCallReference', u'lcls-Negotiation', u'lcls-Configuration-Preference', u'csg-SubscriptionDataList']
    
    #-----< LCLS-GlobalCallReference >-----#
    LCLS_GlobalCallReference = OCT_STR(name=u'LCLS-GlobalCallReference', mode=MODE_TYPE)
    LCLS_GlobalCallReference._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=13, ub=15)], ev=None, er=[])
    
    #-----< LCLS-Negotiation >-----#
    LCLS_Negotiation = BIT_STR(name=u'LCLS-Negotiation', mode=MODE_TYPE)
    LCLS_Negotiation._cont = ASN1Dict([(u'permission-indicator-not-allowed-bit', 0), (u'permission-indicator-spare-bit', 1)])
    LCLS_Negotiation._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=8)], ev=None, er=[])
    
    #-----< LCLS-ConfigurationPreference >-----#
    LCLS_ConfigurationPreference = BIT_STR(name=u'LCLS-ConfigurationPreference', mode=MODE_TYPE)
    LCLS_ConfigurationPreference._cont = ASN1Dict([(u'forward-data-sending-indicator', 0), (u'backward-data-sending-indicator', 1), (u'forward-data-reception-indicator', 2), (u'backward-data-reception-indicator', 3)])
    LCLS_ConfigurationPreference._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=4, ub=8)], ev=None, er=[])
    
    #-----< BSSMAP-ServiceHandoverList >-----#
    BSSMAP_ServiceHandoverList = SEQ_OF(name=u'BSSMAP-ServiceHandoverList', mode=MODE_TYPE)
    _BSSMAP_ServiceHandoverList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'BSSMAP-ServiceHandoverInfo')))
    BSSMAP_ServiceHandoverList._cont = _BSSMAP_ServiceHandoverList__item_
    BSSMAP_ServiceHandoverList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=7)], ev=None, er=[])
    
    #-----< BSSMAP-ServiceHandoverInfo >-----#
    BSSMAP_ServiceHandoverInfo = SEQ(name=u'BSSMAP-ServiceHandoverInfo', mode=MODE_TYPE)
    _BSSMAP_ServiceHandoverInfo_bssmap_ServiceHandover = OCT_STR(name=u'bssmap-ServiceHandover', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'BSSMAP-ServiceHandover')))
    _BSSMAP_ServiceHandoverInfo_rab_Id = INT(name=u'rab-Id', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAB-Id')))
    BSSMAP_ServiceHandoverInfo._cont = ASN1Dict([
        (u'bssmap-ServiceHandover', _BSSMAP_ServiceHandoverInfo_bssmap_ServiceHandover),
        (u'rab-Id', _BSSMAP_ServiceHandoverInfo_rab_Id),
        ])
    BSSMAP_ServiceHandoverInfo._ext = []
    
    #-----< maxNumOfServiceHandovers >-----#
    maxNumOfServiceHandovers = INT(name=u'maxNumOfServiceHandovers', mode=MODE_VALUE)
    maxNumOfServiceHandovers._val = 7
    
    #-----< BSSMAP-ServiceHandover >-----#
    BSSMAP_ServiceHandover = OCT_STR(name=u'BSSMAP-ServiceHandover', mode=MODE_TYPE)
    BSSMAP_ServiceHandover._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< RANAP-ServiceHandover >-----#
    RANAP_ServiceHandover = OCT_STR(name=u'RANAP-ServiceHandover', mode=MODE_TYPE)
    RANAP_ServiceHandover._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< RadioResourceList >-----#
    RadioResourceList = SEQ_OF(name=u'RadioResourceList', mode=MODE_TYPE)
    _RadioResourceList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RadioResource')))
    RadioResourceList._cont = _RadioResourceList__item_
    RadioResourceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=7)], ev=None, er=[])
    
    #-----< RadioResource >-----#
    RadioResource = SEQ(name=u'RadioResource', mode=MODE_TYPE)
    _RadioResource_radioResourceInformation = OCT_STR(name=u'radioResourceInformation', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RadioResourceInformation')))
    _RadioResource_rab_Id = INT(name=u'rab-Id', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAB-Id')))
    RadioResource._cont = ASN1Dict([
        (u'radioResourceInformation', _RadioResource_radioResourceInformation),
        (u'rab-Id', _RadioResource_rab_Id),
        ])
    RadioResource._ext = []
    
    #-----< maxNumOfRadioResources >-----#
    maxNumOfRadioResources = INT(name=u'maxNumOfRadioResources', mode=MODE_VALUE)
    maxNumOfRadioResources._val = 7
    
    #-----< PrepareHO-Res >-----#
    PrepareHO_Res = SEQ(name=u'PrepareHO-Res', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PrepareHO_Res_handoverNumber = OCT_STR(name=u'handoverNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _PrepareHO_Res_relocationNumberList = SEQ_OF(name=u'relocationNumberList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RelocationNumberList')), opt=True)
    _PrepareHO_Res_an_APDU = SEQ(name=u'an-APDU', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AccessNetworkSignalInfo')), opt=True)
    _PrepareHO_Res_multicallBearerInfo = INT(name=u'multicallBearerInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MulticallBearerInfo')), opt=True)
    _PrepareHO_Res_multipleBearerNotSupported = NULL(name=u'multipleBearerNotSupported', mode=MODE_TYPE, opt=True)
    _PrepareHO_Res_selectedUMTS_Algorithms = SEQ(name=u'selectedUMTS-Algorithms', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SelectedUMTS-Algorithms')), opt=True)
    _PrepareHO_Res_chosenRadioResourceInformation = SEQ(name=u'chosenRadioResourceInformation', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ChosenRadioResourceInformation')), opt=True)
    _PrepareHO_Res_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _PrepareHO_Res_iuSelectedCodec = OCT_STR(name=u'iuSelectedCodec', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _PrepareHO_Res_iuAvailableCodecsList = SEQ(name=u'iuAvailableCodecsList', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CodecList')), opt=True)
    _PrepareHO_Res_aoipSelectedCodecTarget = OCT_STR(name=u'aoipSelectedCodecTarget', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')), opt=True)
    _PrepareHO_Res_aoipAvailableCodecsListMap = SEQ(name=u'aoipAvailableCodecsListMap', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodecsList')), opt=True)
    PrepareHO_Res._cont = ASN1Dict([
        (u'handoverNumber', _PrepareHO_Res_handoverNumber),
        (u'relocationNumberList', _PrepareHO_Res_relocationNumberList),
        (u'an-APDU', _PrepareHO_Res_an_APDU),
        (u'multicallBearerInfo', _PrepareHO_Res_multicallBearerInfo),
        (u'multipleBearerNotSupported', _PrepareHO_Res_multipleBearerNotSupported),
        (u'selectedUMTS-Algorithms', _PrepareHO_Res_selectedUMTS_Algorithms),
        (u'chosenRadioResourceInformation', _PrepareHO_Res_chosenRadioResourceInformation),
        (u'extensionContainer', _PrepareHO_Res_extensionContainer),
        (u'iuSelectedCodec', _PrepareHO_Res_iuSelectedCodec),
        (u'iuAvailableCodecsList', _PrepareHO_Res_iuAvailableCodecsList),
        (u'aoipSelectedCodecTarget', _PrepareHO_Res_aoipSelectedCodecTarget),
        (u'aoipAvailableCodecsListMap', _PrepareHO_Res_aoipAvailableCodecsListMap),
        ])
    PrepareHO_Res._ext = [u'iuSelectedCodec', u'iuAvailableCodecsList', u'aoipSelectedCodecTarget', u'aoipAvailableCodecsListMap']
    
    #-----< SelectedUMTS-Algorithms >-----#
    SelectedUMTS_Algorithms = SEQ(name=u'SelectedUMTS-Algorithms', mode=MODE_TYPE)
    _SelectedUMTS_Algorithms_integrityProtectionAlgorithm = OCT_STR(name=u'integrityProtectionAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ChosenIntegrityProtectionAlgorithm')), opt=True)
    _SelectedUMTS_Algorithms_encryptionAlgorithm = OCT_STR(name=u'encryptionAlgorithm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ChosenEncryptionAlgorithm')), opt=True)
    _SelectedUMTS_Algorithms_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SelectedUMTS_Algorithms._cont = ASN1Dict([
        (u'integrityProtectionAlgorithm', _SelectedUMTS_Algorithms_integrityProtectionAlgorithm),
        (u'encryptionAlgorithm', _SelectedUMTS_Algorithms_encryptionAlgorithm),
        (u'extensionContainer', _SelectedUMTS_Algorithms_extensionContainer),
        ])
    SelectedUMTS_Algorithms._ext = []
    
    #-----< ChosenIntegrityProtectionAlgorithm >-----#
    ChosenIntegrityProtectionAlgorithm = OCT_STR(name=u'ChosenIntegrityProtectionAlgorithm', mode=MODE_TYPE)
    ChosenIntegrityProtectionAlgorithm._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< ChosenEncryptionAlgorithm >-----#
    ChosenEncryptionAlgorithm = OCT_STR(name=u'ChosenEncryptionAlgorithm', mode=MODE_TYPE)
    ChosenEncryptionAlgorithm._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< ChosenRadioResourceInformation >-----#
    ChosenRadioResourceInformation = SEQ(name=u'ChosenRadioResourceInformation', mode=MODE_TYPE)
    _ChosenRadioResourceInformation_chosenChannelInfo = OCT_STR(name=u'chosenChannelInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ChosenChannelInfo')), opt=True)
    _ChosenRadioResourceInformation_chosenSpeechVersion = OCT_STR(name=u'chosenSpeechVersion', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ChosenSpeechVersion')), opt=True)
    ChosenRadioResourceInformation._cont = ASN1Dict([
        (u'chosenChannelInfo', _ChosenRadioResourceInformation_chosenChannelInfo),
        (u'chosenSpeechVersion', _ChosenRadioResourceInformation_chosenSpeechVersion),
        ])
    ChosenRadioResourceInformation._ext = []
    
    #-----< ChosenChannelInfo >-----#
    ChosenChannelInfo = OCT_STR(name=u'ChosenChannelInfo', mode=MODE_TYPE)
    ChosenChannelInfo._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< ChosenSpeechVersion >-----#
    ChosenSpeechVersion = OCT_STR(name=u'ChosenSpeechVersion', mode=MODE_TYPE)
    ChosenSpeechVersion._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< PrepareSubsequentHO-Arg >-----#
    PrepareSubsequentHO_Arg = SEQ(name=u'PrepareSubsequentHO-Arg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PrepareSubsequentHO_Arg_targetCellId = OCT_STR(name=u'targetCellId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GlobalCellId')), opt=True)
    _PrepareSubsequentHO_Arg_targetMSC_Number = OCT_STR(name=u'targetMSC-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _PrepareSubsequentHO_Arg_targetRNCId = OCT_STR(name=u'targetRNCId', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RNCId')), opt=True)
    _PrepareSubsequentHO_Arg_an_APDU = SEQ(name=u'an-APDU', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AccessNetworkSignalInfo')), opt=True)
    _PrepareSubsequentHO_Arg_selectedRab_Id = INT(name=u'selectedRab-Id', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAB-Id')), opt=True)
    _PrepareSubsequentHO_Arg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _PrepareSubsequentHO_Arg_geran_classmark = OCT_STR(name=u'geran-classmark', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GERAN-Classmark')), opt=True)
    _PrepareSubsequentHO_Arg_rab_ConfigurationIndicator = NULL(name=u'rab-ConfigurationIndicator', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PrepareSubsequentHO_Arg._cont = ASN1Dict([
        (u'targetCellId', _PrepareSubsequentHO_Arg_targetCellId),
        (u'targetMSC-Number', _PrepareSubsequentHO_Arg_targetMSC_Number),
        (u'targetRNCId', _PrepareSubsequentHO_Arg_targetRNCId),
        (u'an-APDU', _PrepareSubsequentHO_Arg_an_APDU),
        (u'selectedRab-Id', _PrepareSubsequentHO_Arg_selectedRab_Id),
        (u'extensionContainer', _PrepareSubsequentHO_Arg_extensionContainer),
        (u'geran-classmark', _PrepareSubsequentHO_Arg_geran_classmark),
        (u'rab-ConfigurationIndicator', _PrepareSubsequentHO_Arg_rab_ConfigurationIndicator),
        ])
    PrepareSubsequentHO_Arg._ext = [u'geran-classmark', u'rab-ConfigurationIndicator']
    
    #-----< PrepareSubsequentHO-Res >-----#
    PrepareSubsequentHO_Res = SEQ(name=u'PrepareSubsequentHO-Res', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PrepareSubsequentHO_Res_an_APDU = SEQ(name=u'an-APDU', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AccessNetworkSignalInfo')))
    _PrepareSubsequentHO_Res_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    PrepareSubsequentHO_Res._cont = ASN1Dict([
        (u'an-APDU', _PrepareSubsequentHO_Res_an_APDU),
        (u'extensionContainer', _PrepareSubsequentHO_Res_extensionContainer),
        ])
    PrepareSubsequentHO_Res._ext = []
    
    #-----< ProcessAccessSignalling-Arg >-----#
    ProcessAccessSignalling_Arg = SEQ(name=u'ProcessAccessSignalling-Arg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ProcessAccessSignalling_Arg_an_APDU = SEQ(name=u'an-APDU', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AccessNetworkSignalInfo')))
    _ProcessAccessSignalling_Arg_selectedUMTS_Algorithms = SEQ(name=u'selectedUMTS-Algorithms', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SelectedUMTS-Algorithms')), opt=True)
    _ProcessAccessSignalling_Arg_selectedGSM_Algorithm = OCT_STR(name=u'selectedGSM-Algorithm', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SelectedGSM-Algorithm')), opt=True)
    _ProcessAccessSignalling_Arg_chosenRadioResourceInformation = SEQ(name=u'chosenRadioResourceInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ChosenRadioResourceInformation')), opt=True)
    _ProcessAccessSignalling_Arg_selectedRab_Id = INT(name=u'selectedRab-Id', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAB-Id')), opt=True)
    _ProcessAccessSignalling_Arg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ProcessAccessSignalling_Arg_iUSelectedCodec = OCT_STR(name=u'iUSelectedCodec', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _ProcessAccessSignalling_Arg_iuAvailableCodecsList = SEQ(name=u'iuAvailableCodecsList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CodecList')), opt=True)
    _ProcessAccessSignalling_Arg_aoipSelectedCodecTarget = OCT_STR(name=u'aoipSelectedCodecTarget', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')), opt=True)
    _ProcessAccessSignalling_Arg_aoipAvailableCodecsListMap = SEQ(name=u'aoipAvailableCodecsListMap', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodecsList')), opt=True)
    ProcessAccessSignalling_Arg._cont = ASN1Dict([
        (u'an-APDU', _ProcessAccessSignalling_Arg_an_APDU),
        (u'selectedUMTS-Algorithms', _ProcessAccessSignalling_Arg_selectedUMTS_Algorithms),
        (u'selectedGSM-Algorithm', _ProcessAccessSignalling_Arg_selectedGSM_Algorithm),
        (u'chosenRadioResourceInformation', _ProcessAccessSignalling_Arg_chosenRadioResourceInformation),
        (u'selectedRab-Id', _ProcessAccessSignalling_Arg_selectedRab_Id),
        (u'extensionContainer', _ProcessAccessSignalling_Arg_extensionContainer),
        (u'iUSelectedCodec', _ProcessAccessSignalling_Arg_iUSelectedCodec),
        (u'iuAvailableCodecsList', _ProcessAccessSignalling_Arg_iuAvailableCodecsList),
        (u'aoipSelectedCodecTarget', _ProcessAccessSignalling_Arg_aoipSelectedCodecTarget),
        (u'aoipAvailableCodecsListMap', _ProcessAccessSignalling_Arg_aoipAvailableCodecsListMap),
        ])
    ProcessAccessSignalling_Arg._ext = [u'iUSelectedCodec', u'iuAvailableCodecsList', u'aoipSelectedCodecTarget', u'aoipAvailableCodecsListMap']
    
    #-----< AoIPCodecsList >-----#
    AoIPCodecsList = SEQ(name=u'AoIPCodecsList', mode=MODE_TYPE)
    _AoIPCodecsList_codec1 = OCT_STR(name=u'codec1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')))
    _AoIPCodecsList_codec2 = OCT_STR(name=u'codec2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')), opt=True)
    _AoIPCodecsList_codec3 = OCT_STR(name=u'codec3', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')), opt=True)
    _AoIPCodecsList_codec4 = OCT_STR(name=u'codec4', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')), opt=True)
    _AoIPCodecsList_codec5 = OCT_STR(name=u'codec5', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')), opt=True)
    _AoIPCodecsList_codec6 = OCT_STR(name=u'codec6', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')), opt=True)
    _AoIPCodecsList_codec7 = OCT_STR(name=u'codec7', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')), opt=True)
    _AoIPCodecsList_codec8 = OCT_STR(name=u'codec8', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AoIPCodec')), opt=True)
    _AoIPCodecsList_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    AoIPCodecsList._cont = ASN1Dict([
        (u'codec1', _AoIPCodecsList_codec1),
        (u'codec2', _AoIPCodecsList_codec2),
        (u'codec3', _AoIPCodecsList_codec3),
        (u'codec4', _AoIPCodecsList_codec4),
        (u'codec5', _AoIPCodecsList_codec5),
        (u'codec6', _AoIPCodecsList_codec6),
        (u'codec7', _AoIPCodecsList_codec7),
        (u'codec8', _AoIPCodecsList_codec8),
        (u'extensionContainer', _AoIPCodecsList_extensionContainer),
        ])
    AoIPCodecsList._ext = []
    
    #-----< AoIPCodec >-----#
    AoIPCodec = OCT_STR(name=u'AoIPCodec', mode=MODE_TYPE)
    AoIPCodec._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< SupportedCodecsList >-----#
    SupportedCodecsList = SEQ(name=u'SupportedCodecsList', mode=MODE_TYPE)
    _SupportedCodecsList_utranCodecList = SEQ(name=u'utranCodecList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CodecList')), opt=True)
    _SupportedCodecsList_geranCodecList = SEQ(name=u'geranCodecList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CodecList')), opt=True)
    _SupportedCodecsList_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SupportedCodecsList._cont = ASN1Dict([
        (u'utranCodecList', _SupportedCodecsList_utranCodecList),
        (u'geranCodecList', _SupportedCodecsList_geranCodecList),
        (u'extensionContainer', _SupportedCodecsList_extensionContainer),
        ])
    SupportedCodecsList._ext = []
    
    #-----< CodecList >-----#
    CodecList = SEQ(name=u'CodecList', mode=MODE_TYPE)
    _CodecList_codec1 = OCT_STR(name=u'codec1', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')))
    _CodecList_codec2 = OCT_STR(name=u'codec2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _CodecList_codec3 = OCT_STR(name=u'codec3', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _CodecList_codec4 = OCT_STR(name=u'codec4', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _CodecList_codec5 = OCT_STR(name=u'codec5', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _CodecList_codec6 = OCT_STR(name=u'codec6', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _CodecList_codec7 = OCT_STR(name=u'codec7', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _CodecList_codec8 = OCT_STR(name=u'codec8', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Codec')), opt=True)
    _CodecList_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CodecList._cont = ASN1Dict([
        (u'codec1', _CodecList_codec1),
        (u'codec2', _CodecList_codec2),
        (u'codec3', _CodecList_codec3),
        (u'codec4', _CodecList_codec4),
        (u'codec5', _CodecList_codec5),
        (u'codec6', _CodecList_codec6),
        (u'codec7', _CodecList_codec7),
        (u'codec8', _CodecList_codec8),
        (u'extensionContainer', _CodecList_extensionContainer),
        ])
    CodecList._ext = []
    
    #-----< Codec >-----#
    Codec = OCT_STR(name=u'Codec', mode=MODE_TYPE)
    Codec._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< GERAN-Classmark >-----#
    GERAN_Classmark = OCT_STR(name=u'GERAN-Classmark', mode=MODE_TYPE)
    GERAN_Classmark._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=87)], ev=None, er=[])
    
    #-----< SelectedGSM-Algorithm >-----#
    SelectedGSM_Algorithm = OCT_STR(name=u'SelectedGSM-Algorithm', mode=MODE_TYPE)
    SelectedGSM_Algorithm._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< SendEndSignal-Arg >-----#
    SendEndSignal_Arg = SEQ(name=u'SendEndSignal-Arg', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SendEndSignal_Arg_an_APDU = SEQ(name=u'an-APDU', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AccessNetworkSignalInfo')))
    _SendEndSignal_Arg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SendEndSignal_Arg._cont = ASN1Dict([
        (u'an-APDU', _SendEndSignal_Arg_an_APDU),
        (u'extensionContainer', _SendEndSignal_Arg_extensionContainer),
        ])
    SendEndSignal_Arg._ext = []
    
    #-----< SendEndSignal-Res >-----#
    SendEndSignal_Res = SEQ(name=u'SendEndSignal-Res', mode=MODE_TYPE)
    _SendEndSignal_Res_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SendEndSignal_Res._cont = ASN1Dict([
        (u'extensionContainer', _SendEndSignal_Res_extensionContainer),
        ])
    SendEndSignal_Res._ext = []
    
    #-----< RNCId >-----#
    RNCId = OCT_STR(name=u'RNCId', mode=MODE_TYPE)
    RNCId._const_sz = ASN1Set(rv=[7], rr=[], ev=None, er=[])
    
    #-----< RelocationNumberList >-----#
    RelocationNumberList = SEQ_OF(name=u'RelocationNumberList', mode=MODE_TYPE)
    _RelocationNumberList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RelocationNumber')))
    RelocationNumberList._cont = _RelocationNumberList__item_
    RelocationNumberList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=7)], ev=None, er=[])
    
    #-----< MulticallBearerInfo >-----#
    MulticallBearerInfo = INT(name=u'MulticallBearerInfo', mode=MODE_TYPE)
    MulticallBearerInfo._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=7)], ev=None, er=[])
    
    #-----< RelocationNumber >-----#
    RelocationNumber = SEQ(name=u'RelocationNumber', mode=MODE_TYPE)
    _RelocationNumber_handoverNumber = OCT_STR(name=u'handoverNumber', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _RelocationNumber_rab_Id = INT(name=u'rab-Id', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAB-Id')))
    RelocationNumber._cont = ASN1Dict([
        (u'handoverNumber', _RelocationNumber_handoverNumber),
        (u'rab-Id', _RelocationNumber_rab_Id),
        ])
    RelocationNumber._ext = []
    
    #-----< RAB-Id >-----#
    RAB_Id = INT(name=u'RAB-Id', mode=MODE_TYPE)
    RAB_Id._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    
    #-----< maxNrOfRABs >-----#
    maxNrOfRABs = INT(name=u'maxNrOfRABs', mode=MODE_VALUE)
    maxNrOfRABs._val = 255
    
    #-----< maxNumOfRelocationNumber >-----#
    maxNumOfRelocationNumber = INT(name=u'maxNumOfRelocationNumber', mode=MODE_VALUE)
    maxNumOfRelocationNumber._val = 7
    
    #-----< RadioResourceInformation >-----#
    RadioResourceInformation = OCT_STR(name=u'RadioResourceInformation', mode=MODE_TYPE)
    RadioResourceInformation._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=13)], ev=None, er=[])
    
    #-----< IntegrityProtectionInformation >-----#
    IntegrityProtectionInformation = OCT_STR(name=u'IntegrityProtectionInformation', mode=MODE_TYPE)
    IntegrityProtectionInformation._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=18, ub=100)], ev=None, er=[])
    
    #-----< maxNumOfIntegrityInfo >-----#
    maxNumOfIntegrityInfo = INT(name=u'maxNumOfIntegrityInfo', mode=MODE_VALUE)
    maxNumOfIntegrityInfo._val = 100
    
    #-----< EncryptionInformation >-----#
    EncryptionInformation = OCT_STR(name=u'EncryptionInformation', mode=MODE_TYPE)
    EncryptionInformation._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=18, ub=100)], ev=None, er=[])
    
    #-----< maxNumOfEncryptionInfo >-----#
    maxNumOfEncryptionInfo = INT(name=u'maxNumOfEncryptionInfo', mode=MODE_VALUE)
    maxNumOfEncryptionInfo._val = 100
    
    #-----< SendAuthenticationInfoArg >-----#
    SendAuthenticationInfoArg = SEQ(name=u'SendAuthenticationInfoArg', mode=MODE_TYPE)
    _SendAuthenticationInfoArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _SendAuthenticationInfoArg_numberOfRequestedVectors = INT(name=u'numberOfRequestedVectors', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'NumberOfRequestedVectors')))
    _SendAuthenticationInfoArg_segmentationProhibited = NULL(name=u'segmentationProhibited', mode=MODE_TYPE, opt=True)
    _SendAuthenticationInfoArg_immediateResponsePreferred = NULL(name=u'immediateResponsePreferred', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendAuthenticationInfoArg_re_synchronisationInfo = SEQ(name=u're-synchronisationInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Re-synchronisationInfo')), opt=True)
    _SendAuthenticationInfoArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SendAuthenticationInfoArg_requestingNodeType = ENUM(name=u'requestingNodeType', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RequestingNodeType')), opt=True)
    _SendAuthenticationInfoArg_requestingPLMN_Id = OCT_STR(name=u'requestingPLMN-Id', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'PLMN-Id')), opt=True)
    _SendAuthenticationInfoArg_numberOfRequestedAdditional_Vectors = INT(name=u'numberOfRequestedAdditional-Vectors', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'NumberOfRequestedVectors')), opt=True)
    _SendAuthenticationInfoArg_additionalVectorsAreForEPS = NULL(name=u'additionalVectorsAreForEPS', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendAuthenticationInfoArg_ueUsageTypeRequestIndication = NULL(name=u'ueUsageTypeRequestIndication', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    SendAuthenticationInfoArg._cont = ASN1Dict([
        (u'imsi', _SendAuthenticationInfoArg_imsi),
        (u'numberOfRequestedVectors', _SendAuthenticationInfoArg_numberOfRequestedVectors),
        (u'segmentationProhibited', _SendAuthenticationInfoArg_segmentationProhibited),
        (u'immediateResponsePreferred', _SendAuthenticationInfoArg_immediateResponsePreferred),
        (u're-synchronisationInfo', _SendAuthenticationInfoArg_re_synchronisationInfo),
        (u'extensionContainer', _SendAuthenticationInfoArg_extensionContainer),
        (u'requestingNodeType', _SendAuthenticationInfoArg_requestingNodeType),
        (u'requestingPLMN-Id', _SendAuthenticationInfoArg_requestingPLMN_Id),
        (u'numberOfRequestedAdditional-Vectors', _SendAuthenticationInfoArg_numberOfRequestedAdditional_Vectors),
        (u'additionalVectorsAreForEPS', _SendAuthenticationInfoArg_additionalVectorsAreForEPS),
        (u'ueUsageTypeRequestIndication', _SendAuthenticationInfoArg_ueUsageTypeRequestIndication),
        ])
    SendAuthenticationInfoArg._ext = [u'requestingNodeType', u'requestingPLMN-Id', u'numberOfRequestedAdditional-Vectors', u'additionalVectorsAreForEPS', u'ueUsageTypeRequestIndication']
    
    #-----< NumberOfRequestedVectors >-----#
    NumberOfRequestedVectors = INT(name=u'NumberOfRequestedVectors', mode=MODE_TYPE)
    NumberOfRequestedVectors._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< Re-synchronisationInfo >-----#
    Re_synchronisationInfo = SEQ(name=u'Re-synchronisationInfo', mode=MODE_TYPE)
    _Re_synchronisationInfo_rand = OCT_STR(name=u'rand', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAND')))
    _Re_synchronisationInfo_auts = OCT_STR(name=u'auts', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'AUTS')))
    Re_synchronisationInfo._cont = ASN1Dict([
        (u'rand', _Re_synchronisationInfo_rand),
        (u'auts', _Re_synchronisationInfo_auts),
        ])
    Re_synchronisationInfo._ext = []
    
    #-----< SendAuthenticationInfoRes >-----#
    SendAuthenticationInfoRes = SEQ(name=u'SendAuthenticationInfoRes', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SendAuthenticationInfoRes_authenticationSetList = CHOICE(name=u'authenticationSetList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'AuthenticationSetList')), opt=True)
    _SendAuthenticationInfoRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SendAuthenticationInfoRes_eps_AuthenticationSetList = SEQ_OF(name=u'eps-AuthenticationSetList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EPS-AuthenticationSetList')), opt=True)
    _SendAuthenticationInfoRes_ueUsageType = OCT_STR(name=u'ueUsageType', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'UE-UsageType')), opt=True)
    SendAuthenticationInfoRes._cont = ASN1Dict([
        (u'authenticationSetList', _SendAuthenticationInfoRes_authenticationSetList),
        (u'extensionContainer', _SendAuthenticationInfoRes_extensionContainer),
        (u'eps-AuthenticationSetList', _SendAuthenticationInfoRes_eps_AuthenticationSetList),
        (u'ueUsageType', _SendAuthenticationInfoRes_ueUsageType),
        ])
    SendAuthenticationInfoRes._ext = [u'eps-AuthenticationSetList', u'ueUsageType']
    
    #-----< EPS-AuthenticationSetList >-----#
    EPS_AuthenticationSetList = SEQ_OF(name=u'EPS-AuthenticationSetList', mode=MODE_TYPE)
    _EPS_AuthenticationSetList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'EPC-AV')))
    EPS_AuthenticationSetList._cont = _EPS_AuthenticationSetList__item_
    EPS_AuthenticationSetList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< UE-UsageType >-----#
    UE_UsageType = OCT_STR(name=u'UE-UsageType', mode=MODE_TYPE)
    UE_UsageType._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< EPC-AV >-----#
    EPC_AV = SEQ(name=u'EPC-AV', mode=MODE_TYPE)
    _EPC_AV_rand = OCT_STR(name=u'rand', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RAND')))
    _EPC_AV_xres = OCT_STR(name=u'xres', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'XRES')))
    _EPC_AV_autn = OCT_STR(name=u'autn', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'AUTN')))
    _EPC_AV_kasme = OCT_STR(name=u'kasme', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'KASME')))
    _EPC_AV_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    EPC_AV._cont = ASN1Dict([
        (u'rand', _EPC_AV_rand),
        (u'xres', _EPC_AV_xres),
        (u'autn', _EPC_AV_autn),
        (u'kasme', _EPC_AV_kasme),
        (u'extensionContainer', _EPC_AV_extensionContainer),
        ])
    EPC_AV._ext = []
    
    #-----< KASME >-----#
    KASME = OCT_STR(name=u'KASME', mode=MODE_TYPE)
    KASME._const_sz = ASN1Set(rv=[32], rr=[], ev=None, er=[])
    
    #-----< RequestingNodeType >-----#
    RequestingNodeType = ENUM(name=u'RequestingNodeType', mode=MODE_TYPE)
    RequestingNodeType._cont = ASN1Dict([(u'vlr', 0), (u'sgsn', 1), (u's-cscf', 2), (u'bsf', 3), (u'gan-aaa-server', 4), (u'wlan-aaa-server', 5), (u'mme', 16), (u'mme-sgsn', 17)])
    RequestingNodeType._ext = [u's-cscf', u'bsf', u'gan-aaa-server', u'wlan-aaa-server', u'mme', u'mme-sgsn']
    
    #-----< CheckIMEI-Arg >-----#
    CheckIMEI_Arg = SEQ(name=u'CheckIMEI-Arg', mode=MODE_TYPE)
    _CheckIMEI_Arg_imei = OCT_STR(name=u'imei', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMEI')))
    _CheckIMEI_Arg_requestedEquipmentInfo = BIT_STR(name=u'requestedEquipmentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'RequestedEquipmentInfo')))
    _CheckIMEI_Arg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CheckIMEI_Arg._cont = ASN1Dict([
        (u'imei', _CheckIMEI_Arg_imei),
        (u'requestedEquipmentInfo', _CheckIMEI_Arg_requestedEquipmentInfo),
        (u'extensionContainer', _CheckIMEI_Arg_extensionContainer),
        ])
    CheckIMEI_Arg._ext = []
    
    #-----< CheckIMEI-Res >-----#
    CheckIMEI_Res = SEQ(name=u'CheckIMEI-Res', mode=MODE_TYPE)
    _CheckIMEI_Res_equipmentStatus = ENUM(name=u'equipmentStatus', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'EquipmentStatus')), opt=True)
    _CheckIMEI_Res_bmuef = SEQ(name=u'bmuef', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'UESBI-Iu')), opt=True)
    _CheckIMEI_Res_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CheckIMEI_Res._cont = ASN1Dict([
        (u'equipmentStatus', _CheckIMEI_Res_equipmentStatus),
        (u'bmuef', _CheckIMEI_Res_bmuef),
        (u'extensionContainer', _CheckIMEI_Res_extensionContainer),
        ])
    CheckIMEI_Res._ext = []
    
    #-----< RequestedEquipmentInfo >-----#
    RequestedEquipmentInfo = BIT_STR(name=u'RequestedEquipmentInfo', mode=MODE_TYPE)
    RequestedEquipmentInfo._cont = ASN1Dict([(u'equipmentStatus', 0), (u'bmuef', 1)])
    RequestedEquipmentInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=8)], ev=None, er=[])
    
    #-----< UESBI-Iu >-----#
    UESBI_Iu = SEQ(name=u'UESBI-Iu', mode=MODE_TYPE)
    _UESBI_Iu_uesbi_IuA = BIT_STR(name=u'uesbi-IuA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'UESBI-IuA')), opt=True)
    _UESBI_Iu_uesbi_IuB = BIT_STR(name=u'uesbi-IuB', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'UESBI-IuB')), opt=True)
    UESBI_Iu._cont = ASN1Dict([
        (u'uesbi-IuA', _UESBI_Iu_uesbi_IuA),
        (u'uesbi-IuB', _UESBI_Iu_uesbi_IuB),
        ])
    UESBI_Iu._ext = []
    
    #-----< UESBI-IuA >-----#
    UESBI_IuA = BIT_STR(name=u'UESBI-IuA', mode=MODE_TYPE)
    UESBI_IuA._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    
    #-----< UESBI-IuB >-----#
    UESBI_IuB = BIT_STR(name=u'UESBI-IuB', mode=MODE_TYPE)
    UESBI_IuB._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    
    #-----< EquipmentStatus >-----#
    EquipmentStatus = ENUM(name=u'EquipmentStatus', mode=MODE_TYPE)
    EquipmentStatus._cont = ASN1Dict([(u'whiteListed', 0), (u'blackListed', 1), (u'greyListed', 2)])
    EquipmentStatus._ext = None
    
    #-----< InsertSubscriberDataArg >-----#
    InsertSubscriberDataArg = SEQ(name=u'InsertSubscriberDataArg', mode=MODE_TYPE)
    _InsertSubscriberDataArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    _InsertSubscriberDataArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _InsertSubscriberDataArg_category = OCT_STR(name=u'category', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Category')), opt=True)
    _InsertSubscriberDataArg_subscriberStatus = ENUM(name=u'subscriberStatus', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SubscriberStatus')), opt=True)
    _InsertSubscriberDataArg_bearerServiceList = SEQ_OF(name=u'bearerServiceList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BearerServiceList')), opt=True)
    _InsertSubscriberDataArg_teleserviceList = SEQ_OF(name=u'teleserviceList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'TeleserviceList')), opt=True)
    _InsertSubscriberDataArg_provisionedSS = SEQ_OF(name=u'provisionedSS', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-SS-InfoList')), opt=True)
    _InsertSubscriberDataArg_odb_Data = SEQ(name=u'odb-Data', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ODB-Data')), opt=True)
    _InsertSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature = NULL(name=u'roamingRestrictionDueToUnsupportedFeature', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_regionalSubscriptionData = SEQ_OF(name=u'regionalSubscriptionData', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ZoneCodeList')), opt=True)
    _InsertSubscriberDataArg_vbsSubscriptionData = SEQ_OF(name=u'vbsSubscriptionData', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'VBSDataList')), opt=True)
    _InsertSubscriberDataArg_vgcsSubscriptionData = SEQ_OF(name=u'vgcsSubscriptionData', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'VGCSDataList')), opt=True)
    _InsertSubscriberDataArg_vlrCamelSubscriptionInfo = SEQ(name=u'vlrCamelSubscriptionInfo', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'VlrCamelSubscriptionInfo')), opt=True)
    _InsertSubscriberDataArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _InsertSubscriberDataArg_naea_PreferredCI = SEQ(name=u'naea-PreferredCI', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'NAEA-PreferredCI')), opt=True)
    _InsertSubscriberDataArg_gprsSubscriptionData = SEQ(name=u'gprsSubscriptionData', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GPRSSubscriptionData')), opt=True)
    _InsertSubscriberDataArg_roamingRestrictedInSgsnDueToUnsupportedFeature = NULL(name=u'roamingRestrictedInSgsnDueToUnsupportedFeature', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_networkAccessMode = ENUM(name=u'networkAccessMode', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'NetworkAccessMode')), opt=True)
    _InsertSubscriberDataArg_lsaInformation = SEQ(name=u'lsaInformation', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAInformation')), opt=True)
    _InsertSubscriberDataArg_lmu_Indicator = NULL(name=u'lmu-Indicator', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_lcsInformation = SEQ(name=u'lcsInformation', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LCSInformation')), opt=True)
    _InsertSubscriberDataArg_istAlertTimer = INT(name=u'istAlertTimer', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'IST-AlertTimerValue')), opt=True)
    _InsertSubscriberDataArg_superChargerSupportedInHLR = OCT_STR(name=u'superChargerSupportedInHLR', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AgeIndicator')), opt=True)
    _InsertSubscriberDataArg_mc_SS_Info = SEQ(name=u'mc-SS-Info', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'MC-SS-Info')), opt=True)
    _InsertSubscriberDataArg_cs_AllocationRetentionPriority = OCT_STR(name=u'cs-AllocationRetentionPriority', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CS-AllocationRetentionPriority')), opt=True)
    _InsertSubscriberDataArg_sgsn_CAMEL_SubscriptionInfo = SEQ(name=u'sgsn-CAMEL-SubscriptionInfo', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SGSN-CAMEL-SubscriptionInfo')), opt=True)
    _InsertSubscriberDataArg_chargingCharacteristics = OCT_STR(name=u'chargingCharacteristics', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ChargingCharacteristics')), opt=True)
    _InsertSubscriberDataArg_accessRestrictionData = BIT_STR(name=u'accessRestrictionData', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AccessRestrictionData')), opt=True)
    _InsertSubscriberDataArg_ics_Indicator = BOOL(name=u'ics-Indicator', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_eps_SubscriptionData = SEQ(name=u'eps-SubscriptionData', mode=MODE_TYPE, tag=(31, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EPS-SubscriptionData')), opt=True)
    _InsertSubscriberDataArg_csg_SubscriptionDataList = SEQ_OF(name=u'csg-SubscriptionDataList', mode=MODE_TYPE, tag=(32, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CSG-SubscriptionDataList')), opt=True)
    _InsertSubscriberDataArg_ue_ReachabilityRequestIndicator = NULL(name=u'ue-ReachabilityRequestIndicator', mode=MODE_TYPE, tag=(33, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_sgsn_Number = OCT_STR(name=u'sgsn-Number', mode=MODE_TYPE, tag=(34, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _InsertSubscriberDataArg_mme_Name = OCT_STR(name=u'mme-Name', mode=MODE_TYPE, tag=(35, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'DiameterIdentity')), opt=True)
    _InsertSubscriberDataArg_subscribedPeriodicRAUTAUtimer = INT(name=u'subscribedPeriodicRAUTAUtimer', mode=MODE_TYPE, tag=(36, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SubscribedPeriodicRAUTAUtimer')), opt=True)
    _InsertSubscriberDataArg_vplmnLIPAAllowed = NULL(name=u'vplmnLIPAAllowed', mode=MODE_TYPE, tag=(37, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_mdtUserConsent = BOOL(name=u'mdtUserConsent', mode=MODE_TYPE, tag=(38, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_subscribedPeriodicLAUtimer = INT(name=u'subscribedPeriodicLAUtimer', mode=MODE_TYPE, tag=(39, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SubscribedPeriodicLAUtimer')), opt=True)
    _InsertSubscriberDataArg_vplmn_Csg_SubscriptionDataList = SEQ_OF(name=u'vplmn-Csg-SubscriptionDataList', mode=MODE_TYPE, tag=(40, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'VPLMN-CSG-SubscriptionDataList')), opt=True)
    _InsertSubscriberDataArg_additionalMSISDN = OCT_STR(name=u'additionalMSISDN', mode=MODE_TYPE, tag=(41, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _InsertSubscriberDataArg_psAndSMS_OnlyServiceProvision = NULL(name=u'psAndSMS-OnlyServiceProvision', mode=MODE_TYPE, tag=(42, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_smsInSGSNAllowed = NULL(name=u'smsInSGSNAllowed', mode=MODE_TYPE, tag=(43, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_cs_to_ps_SRVCC_Allowed_Indicator = NULL(name=u'cs-to-ps-SRVCC-Allowed-Indicator', mode=MODE_TYPE, tag=(44, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_pcscf_Restoration_Request = NULL(name=u'pcscf-Restoration-Request', mode=MODE_TYPE, tag=(45, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _InsertSubscriberDataArg_adjacentAccessRestrictionDataList = SEQ_OF(name=u'adjacentAccessRestrictionDataList', mode=MODE_TYPE, tag=(46, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AdjacentAccessRestrictionDataList')), opt=True)
    _InsertSubscriberDataArg_imsi_Group_Id_List = SEQ_OF(name=u'imsi-Group-Id-List', mode=MODE_TYPE, tag=(47, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'IMSI-GroupIdList')), opt=True)
    _InsertSubscriberDataArg_ueUsageType = OCT_STR(name=u'ueUsageType', mode=MODE_TYPE, tag=(48, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'UE-UsageType')), opt=True)
    _InsertSubscriberDataArg_userPlaneIntegrityProtectionIndicator = NULL(name=u'userPlaneIntegrityProtectionIndicator', mode=MODE_TYPE, tag=(49, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    InsertSubscriberDataArg._cont = ASN1Dict([
        (u'imsi', _InsertSubscriberDataArg_imsi),
        (u'msisdn', _InsertSubscriberDataArg_msisdn),
        (u'category', _InsertSubscriberDataArg_category),
        (u'subscriberStatus', _InsertSubscriberDataArg_subscriberStatus),
        (u'bearerServiceList', _InsertSubscriberDataArg_bearerServiceList),
        (u'teleserviceList', _InsertSubscriberDataArg_teleserviceList),
        (u'provisionedSS', _InsertSubscriberDataArg_provisionedSS),
        (u'odb-Data', _InsertSubscriberDataArg_odb_Data),
        (u'roamingRestrictionDueToUnsupportedFeature', _InsertSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature),
        (u'regionalSubscriptionData', _InsertSubscriberDataArg_regionalSubscriptionData),
        (u'vbsSubscriptionData', _InsertSubscriberDataArg_vbsSubscriptionData),
        (u'vgcsSubscriptionData', _InsertSubscriberDataArg_vgcsSubscriptionData),
        (u'vlrCamelSubscriptionInfo', _InsertSubscriberDataArg_vlrCamelSubscriptionInfo),
        (u'extensionContainer', _InsertSubscriberDataArg_extensionContainer),
        (u'naea-PreferredCI', _InsertSubscriberDataArg_naea_PreferredCI),
        (u'gprsSubscriptionData', _InsertSubscriberDataArg_gprsSubscriptionData),
        (u'roamingRestrictedInSgsnDueToUnsupportedFeature', _InsertSubscriberDataArg_roamingRestrictedInSgsnDueToUnsupportedFeature),
        (u'networkAccessMode', _InsertSubscriberDataArg_networkAccessMode),
        (u'lsaInformation', _InsertSubscriberDataArg_lsaInformation),
        (u'lmu-Indicator', _InsertSubscriberDataArg_lmu_Indicator),
        (u'lcsInformation', _InsertSubscriberDataArg_lcsInformation),
        (u'istAlertTimer', _InsertSubscriberDataArg_istAlertTimer),
        (u'superChargerSupportedInHLR', _InsertSubscriberDataArg_superChargerSupportedInHLR),
        (u'mc-SS-Info', _InsertSubscriberDataArg_mc_SS_Info),
        (u'cs-AllocationRetentionPriority', _InsertSubscriberDataArg_cs_AllocationRetentionPriority),
        (u'sgsn-CAMEL-SubscriptionInfo', _InsertSubscriberDataArg_sgsn_CAMEL_SubscriptionInfo),
        (u'chargingCharacteristics', _InsertSubscriberDataArg_chargingCharacteristics),
        (u'accessRestrictionData', _InsertSubscriberDataArg_accessRestrictionData),
        (u'ics-Indicator', _InsertSubscriberDataArg_ics_Indicator),
        (u'eps-SubscriptionData', _InsertSubscriberDataArg_eps_SubscriptionData),
        (u'csg-SubscriptionDataList', _InsertSubscriberDataArg_csg_SubscriptionDataList),
        (u'ue-ReachabilityRequestIndicator', _InsertSubscriberDataArg_ue_ReachabilityRequestIndicator),
        (u'sgsn-Number', _InsertSubscriberDataArg_sgsn_Number),
        (u'mme-Name', _InsertSubscriberDataArg_mme_Name),
        (u'subscribedPeriodicRAUTAUtimer', _InsertSubscriberDataArg_subscribedPeriodicRAUTAUtimer),
        (u'vplmnLIPAAllowed', _InsertSubscriberDataArg_vplmnLIPAAllowed),
        (u'mdtUserConsent', _InsertSubscriberDataArg_mdtUserConsent),
        (u'subscribedPeriodicLAUtimer', _InsertSubscriberDataArg_subscribedPeriodicLAUtimer),
        (u'vplmn-Csg-SubscriptionDataList', _InsertSubscriberDataArg_vplmn_Csg_SubscriptionDataList),
        (u'additionalMSISDN', _InsertSubscriberDataArg_additionalMSISDN),
        (u'psAndSMS-OnlyServiceProvision', _InsertSubscriberDataArg_psAndSMS_OnlyServiceProvision),
        (u'smsInSGSNAllowed', _InsertSubscriberDataArg_smsInSGSNAllowed),
        (u'cs-to-ps-SRVCC-Allowed-Indicator', _InsertSubscriberDataArg_cs_to_ps_SRVCC_Allowed_Indicator),
        (u'pcscf-Restoration-Request', _InsertSubscriberDataArg_pcscf_Restoration_Request),
        (u'adjacentAccessRestrictionDataList', _InsertSubscriberDataArg_adjacentAccessRestrictionDataList),
        (u'imsi-Group-Id-List', _InsertSubscriberDataArg_imsi_Group_Id_List),
        (u'ueUsageType', _InsertSubscriberDataArg_ueUsageType),
        (u'userPlaneIntegrityProtectionIndicator', _InsertSubscriberDataArg_userPlaneIntegrityProtectionIndicator),
        ])
    InsertSubscriberDataArg._ext = [u'naea-PreferredCI', u'gprsSubscriptionData', u'roamingRestrictedInSgsnDueToUnsupportedFeature', u'networkAccessMode', u'lsaInformation', u'lmu-Indicator', u'lcsInformation', u'istAlertTimer', u'superChargerSupportedInHLR', u'mc-SS-Info', u'cs-AllocationRetentionPriority', u'sgsn-CAMEL-SubscriptionInfo', u'chargingCharacteristics', u'accessRestrictionData', u'ics-Indicator', u'eps-SubscriptionData', u'csg-SubscriptionDataList', u'ue-ReachabilityRequestIndicator', u'sgsn-Number', u'mme-Name', u'subscribedPeriodicRAUTAUtimer', u'vplmnLIPAAllowed', u'mdtUserConsent', u'subscribedPeriodicLAUtimer', u'vplmn-Csg-SubscriptionDataList', u'additionalMSISDN', u'psAndSMS-OnlyServiceProvision', u'smsInSGSNAllowed', u'cs-to-ps-SRVCC-Allowed-Indicator', u'pcscf-Restoration-Request', u'adjacentAccessRestrictionDataList', u'imsi-Group-Id-List', u'ueUsageType', u'userPlaneIntegrityProtectionIndicator']
    
    #-----< Group-Service-ID >-----#
    Group_Service_ID = INT(name=u'Group-Service-ID', mode=MODE_TYPE)
    Group_Service_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    
    #-----< Local-GroupID >-----#
    Local_GroupID = OCT_STR(name=u'Local-GroupID', mode=MODE_TYPE)
    Local_GroupID._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< IMSI-GroupIdList >-----#
    IMSI_GroupIdList = SEQ_OF(name=u'IMSI-GroupIdList', mode=MODE_TYPE)
    _IMSI_GroupIdList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'IMSI-GroupId')))
    IMSI_GroupIdList._cont = _IMSI_GroupIdList__item_
    IMSI_GroupIdList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< IMSI-GroupId >-----#
    IMSI_GroupId = SEQ(name=u'IMSI-GroupId', mode=MODE_TYPE)
    _IMSI_GroupId_group_Service_Id = INT(name=u'group-Service-Id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Group-Service-ID')))
    _IMSI_GroupId_plmnId = OCT_STR(name=u'plmnId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'PLMN-Id')))
    _IMSI_GroupId_local_Group_ID = OCT_STR(name=u'local-Group-ID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Local-GroupID')))
    IMSI_GroupId._cont = ASN1Dict([
        (u'group-Service-Id', _IMSI_GroupId_group_Service_Id),
        (u'plmnId', _IMSI_GroupId_plmnId),
        (u'local-Group-ID', _IMSI_GroupId_local_Group_ID),
        ])
    IMSI_GroupId._ext = []
    
    #-----< SubscribedPeriodicRAUTAUtimer >-----#
    SubscribedPeriodicRAUTAUtimer = INT(name=u'SubscribedPeriodicRAUTAUtimer', mode=MODE_TYPE)
    SubscribedPeriodicRAUTAUtimer._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    
    #-----< SubscribedPeriodicLAUtimer >-----#
    SubscribedPeriodicLAUtimer = INT(name=u'SubscribedPeriodicLAUtimer', mode=MODE_TYPE)
    SubscribedPeriodicLAUtimer._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    
    #-----< CSG-SubscriptionDataList >-----#
    CSG_SubscriptionDataList = SEQ_OF(name=u'CSG-SubscriptionDataList', mode=MODE_TYPE)
    _CSG_SubscriptionDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CSG-SubscriptionData')))
    CSG_SubscriptionDataList._cont = _CSG_SubscriptionDataList__item_
    CSG_SubscriptionDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< CSG-SubscriptionData >-----#
    CSG_SubscriptionData = SEQ(name=u'CSG-SubscriptionData', mode=MODE_TYPE)
    _CSG_SubscriptionData_csg_Id = BIT_STR(name=u'csg-Id', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CSG-Id')))
    _CSG_SubscriptionData_expirationDate = OCT_STR(name=u'expirationDate', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Time')), opt=True)
    _CSG_SubscriptionData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _CSG_SubscriptionData_lipa_AllowedAPNList = SEQ_OF(name=u'lipa-AllowedAPNList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LIPA-AllowedAPNList')), opt=True)
    _CSG_SubscriptionData_plmn_Id = OCT_STR(name=u'plmn-Id', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'PLMN-Id')), opt=True)
    CSG_SubscriptionData._cont = ASN1Dict([
        (u'csg-Id', _CSG_SubscriptionData_csg_Id),
        (u'expirationDate', _CSG_SubscriptionData_expirationDate),
        (u'extensionContainer', _CSG_SubscriptionData_extensionContainer),
        (u'lipa-AllowedAPNList', _CSG_SubscriptionData_lipa_AllowedAPNList),
        (u'plmn-Id', _CSG_SubscriptionData_plmn_Id),
        ])
    CSG_SubscriptionData._ext = [u'lipa-AllowedAPNList', u'plmn-Id']
    
    #-----< VPLMN-CSG-SubscriptionDataList >-----#
    VPLMN_CSG_SubscriptionDataList = SEQ_OF(name=u'VPLMN-CSG-SubscriptionDataList', mode=MODE_TYPE)
    _VPLMN_CSG_SubscriptionDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CSG-SubscriptionData')))
    VPLMN_CSG_SubscriptionDataList._cont = _VPLMN_CSG_SubscriptionDataList__item_
    VPLMN_CSG_SubscriptionDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< CSG-Id >-----#
    CSG_Id = BIT_STR(name=u'CSG-Id', mode=MODE_TYPE)
    CSG_Id._const_sz = ASN1Set(rv=[27], rr=[], ev=None, er=[])
    
    #-----< LIPA-AllowedAPNList >-----#
    LIPA_AllowedAPNList = SEQ_OF(name=u'LIPA-AllowedAPNList', mode=MODE_TYPE)
    _LIPA_AllowedAPNList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN')))
    LIPA_AllowedAPNList._cont = _LIPA_AllowedAPNList__item_
    LIPA_AllowedAPNList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< maxNumOfLIPAAllowedAPN >-----#
    maxNumOfLIPAAllowedAPN = INT(name=u'maxNumOfLIPAAllowedAPN', mode=MODE_VALUE)
    maxNumOfLIPAAllowedAPN._val = 50
    
    #-----< EPS-SubscriptionData >-----#
    EPS_SubscriptionData = SEQ(name=u'EPS-SubscriptionData', mode=MODE_TYPE)
    _EPS_SubscriptionData_apn_oi_Replacement = OCT_STR(name=u'apn-oi-Replacement', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN-OI-Replacement')), opt=True)
    _EPS_SubscriptionData_rfsp_id = INT(name=u'rfsp-id', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RFSP-ID')), opt=True)
    _EPS_SubscriptionData_ambr = SEQ(name=u'ambr', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AMBR')), opt=True)
    _EPS_SubscriptionData_apn_ConfigurationProfile = SEQ(name=u'apn-ConfigurationProfile', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN-ConfigurationProfile')), opt=True)
    _EPS_SubscriptionData_stn_sr = OCT_STR(name=u'stn-sr', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _EPS_SubscriptionData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _EPS_SubscriptionData_mps_CSPriority = NULL(name=u'mps-CSPriority', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EPS_SubscriptionData_mps_EPSPriority = NULL(name=u'mps-EPSPriority', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EPS_SubscriptionData_subscribed_vsrvcc = NULL(name=u'subscribed-vsrvcc', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    EPS_SubscriptionData._cont = ASN1Dict([
        (u'apn-oi-Replacement', _EPS_SubscriptionData_apn_oi_Replacement),
        (u'rfsp-id', _EPS_SubscriptionData_rfsp_id),
        (u'ambr', _EPS_SubscriptionData_ambr),
        (u'apn-ConfigurationProfile', _EPS_SubscriptionData_apn_ConfigurationProfile),
        (u'stn-sr', _EPS_SubscriptionData_stn_sr),
        (u'extensionContainer', _EPS_SubscriptionData_extensionContainer),
        (u'mps-CSPriority', _EPS_SubscriptionData_mps_CSPriority),
        (u'mps-EPSPriority', _EPS_SubscriptionData_mps_EPSPriority),
        (u'subscribed-vsrvcc', _EPS_SubscriptionData_subscribed_vsrvcc),
        ])
    EPS_SubscriptionData._ext = [u'mps-CSPriority', u'mps-EPSPriority', u'subscribed-vsrvcc']
    
    #-----< APN-OI-Replacement >-----#
    APN_OI_Replacement = OCT_STR(name=u'APN-OI-Replacement', mode=MODE_TYPE)
    APN_OI_Replacement._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=9, ub=100)], ev=None, er=[])
    
    #-----< RFSP-ID >-----#
    RFSP_ID = INT(name=u'RFSP-ID', mode=MODE_TYPE)
    RFSP_ID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    
    #-----< APN-ConfigurationProfile >-----#
    APN_ConfigurationProfile = SEQ(name=u'APN-ConfigurationProfile', mode=MODE_TYPE)
    _APN_ConfigurationProfile_defaultContext = INT(name=u'defaultContext', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ContextId')))
    _APN_ConfigurationProfile_completeDataListIncluded = NULL(name=u'completeDataListIncluded', mode=MODE_TYPE, opt=True)
    _APN_ConfigurationProfile_epsDataList = SEQ_OF(name=u'epsDataList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EPS-DataList')))
    _APN_ConfigurationProfile_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _APN_ConfigurationProfile_additionalDefaultContext = INT(name=u'additionalDefaultContext', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ContextId')), opt=True)
    APN_ConfigurationProfile._cont = ASN1Dict([
        (u'defaultContext', _APN_ConfigurationProfile_defaultContext),
        (u'completeDataListIncluded', _APN_ConfigurationProfile_completeDataListIncluded),
        (u'epsDataList', _APN_ConfigurationProfile_epsDataList),
        (u'extensionContainer', _APN_ConfigurationProfile_extensionContainer),
        (u'additionalDefaultContext', _APN_ConfigurationProfile_additionalDefaultContext),
        ])
    APN_ConfigurationProfile._ext = [u'additionalDefaultContext']
    
    #-----< EPS-DataList >-----#
    EPS_DataList = SEQ_OF(name=u'EPS-DataList', mode=MODE_TYPE)
    _EPS_DataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN-Configuration')))
    EPS_DataList._cont = _EPS_DataList__item_
    EPS_DataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< maxNumOfAPN-Configurations >-----#
    maxNumOfAPN_Configurations = INT(name=u'maxNumOfAPN-Configurations', mode=MODE_VALUE)
    maxNumOfAPN_Configurations._val = 50
    
    #-----< APN-Configuration >-----#
    APN_Configuration = SEQ(name=u'APN-Configuration', mode=MODE_TYPE)
    _APN_Configuration_contextId = INT(name=u'contextId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ContextId')))
    _APN_Configuration_pdn_Type = OCT_STR(name=u'pdn-Type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDN-Type')))
    _APN_Configuration_servedPartyIP_IPv4_Address = OCT_STR(name=u'servedPartyIP-IPv4-Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Address')), opt=True)
    _APN_Configuration_apn = OCT_STR(name=u'apn', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN')))
    _APN_Configuration_eps_qos_Subscribed = SEQ(name=u'eps-qos-Subscribed', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EPS-QoS-Subscribed')))
    _APN_Configuration_pdn_gw_Identity = SEQ(name=u'pdn-gw-Identity', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDN-GW-Identity')), opt=True)
    _APN_Configuration_pdn_gw_AllocationType = ENUM(name=u'pdn-gw-AllocationType', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDN-GW-AllocationType')), opt=True)
    _APN_Configuration_vplmnAddressAllowed = NULL(name=u'vplmnAddressAllowed', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _APN_Configuration_chargingCharacteristics = OCT_STR(name=u'chargingCharacteristics', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ChargingCharacteristics')), opt=True)
    _APN_Configuration_ambr = SEQ(name=u'ambr', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AMBR')), opt=True)
    _APN_Configuration_specificAPNInfoList = SEQ_OF(name=u'specificAPNInfoList', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SpecificAPNInfoList')), opt=True)
    _APN_Configuration_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _APN_Configuration_servedPartyIP_IPv6_Address = OCT_STR(name=u'servedPartyIP-IPv6-Address', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Address')), opt=True)
    _APN_Configuration_apn_oi_Replacement = OCT_STR(name=u'apn-oi-Replacement', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN-OI-Replacement')), opt=True)
    _APN_Configuration_sipto_Permission = ENUM(name=u'sipto-Permission', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SIPTO-Permission')), opt=True)
    _APN_Configuration_lipa_Permission = ENUM(name=u'lipa-Permission', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LIPA-Permission')), opt=True)
    _APN_Configuration_restoration_Priority = OCT_STR(name=u'restoration-Priority', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Restoration-Priority')), opt=True)
    _APN_Configuration_sipto_local_network_Permission = ENUM(name=u'sipto-local-network-Permission', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SIPTO-Local-Network-Permission')), opt=True)
    _APN_Configuration_wlan_offloadability = SEQ(name=u'wlan-offloadability', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'WLAN-Offloadability')), opt=True)
    _APN_Configuration_non_IP_PDN_Type_Indicator = NULL(name=u'non-IP-PDN-Type-Indicator', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _APN_Configuration_nIDD_Mechanism = ENUM(name=u'nIDD-Mechanism', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'NIDD-Mechanism')), opt=True)
    _APN_Configuration_sCEF_ID = OCT_STR(name=u'sCEF-ID', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'FQDN')), opt=True)
    APN_Configuration._cont = ASN1Dict([
        (u'contextId', _APN_Configuration_contextId),
        (u'pdn-Type', _APN_Configuration_pdn_Type),
        (u'servedPartyIP-IPv4-Address', _APN_Configuration_servedPartyIP_IPv4_Address),
        (u'apn', _APN_Configuration_apn),
        (u'eps-qos-Subscribed', _APN_Configuration_eps_qos_Subscribed),
        (u'pdn-gw-Identity', _APN_Configuration_pdn_gw_Identity),
        (u'pdn-gw-AllocationType', _APN_Configuration_pdn_gw_AllocationType),
        (u'vplmnAddressAllowed', _APN_Configuration_vplmnAddressAllowed),
        (u'chargingCharacteristics', _APN_Configuration_chargingCharacteristics),
        (u'ambr', _APN_Configuration_ambr),
        (u'specificAPNInfoList', _APN_Configuration_specificAPNInfoList),
        (u'extensionContainer', _APN_Configuration_extensionContainer),
        (u'servedPartyIP-IPv6-Address', _APN_Configuration_servedPartyIP_IPv6_Address),
        (u'apn-oi-Replacement', _APN_Configuration_apn_oi_Replacement),
        (u'sipto-Permission', _APN_Configuration_sipto_Permission),
        (u'lipa-Permission', _APN_Configuration_lipa_Permission),
        (u'restoration-Priority', _APN_Configuration_restoration_Priority),
        (u'sipto-local-network-Permission', _APN_Configuration_sipto_local_network_Permission),
        (u'wlan-offloadability', _APN_Configuration_wlan_offloadability),
        (u'non-IP-PDN-Type-Indicator', _APN_Configuration_non_IP_PDN_Type_Indicator),
        (u'nIDD-Mechanism', _APN_Configuration_nIDD_Mechanism),
        (u'sCEF-ID', _APN_Configuration_sCEF_ID),
        ])
    APN_Configuration._ext = [u'apn-oi-Replacement', u'sipto-Permission', u'lipa-Permission', u'restoration-Priority', u'sipto-local-network-Permission', u'wlan-offloadability', u'non-IP-PDN-Type-Indicator', u'nIDD-Mechanism', u'sCEF-ID']
    
    #-----< NIDD-Mechanism >-----#
    NIDD_Mechanism = ENUM(name=u'NIDD-Mechanism', mode=MODE_TYPE)
    NIDD_Mechanism._cont = ASN1Dict([(u'sGi-based-data-delivery', 0), (u'sCEF-based-data-delivery', 1)])
    NIDD_Mechanism._ext = None
    
    #-----< PDN-Type >-----#
    PDN_Type = OCT_STR(name=u'PDN-Type', mode=MODE_TYPE)
    PDN_Type._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< EPS-QoS-Subscribed >-----#
    EPS_QoS_Subscribed = SEQ(name=u'EPS-QoS-Subscribed', mode=MODE_TYPE)
    _EPS_QoS_Subscribed_qos_Class_Identifier = INT(name=u'qos-Class-Identifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'QoS-Class-Identifier')))
    _EPS_QoS_Subscribed_allocation_Retention_Priority = SEQ(name=u'allocation-Retention-Priority', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Allocation-Retention-Priority')))
    _EPS_QoS_Subscribed_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    EPS_QoS_Subscribed._cont = ASN1Dict([
        (u'qos-Class-Identifier', _EPS_QoS_Subscribed_qos_Class_Identifier),
        (u'allocation-Retention-Priority', _EPS_QoS_Subscribed_allocation_Retention_Priority),
        (u'extensionContainer', _EPS_QoS_Subscribed_extensionContainer),
        ])
    EPS_QoS_Subscribed._ext = []
    
    #-----< AMBR >-----#
    AMBR = SEQ(name=u'AMBR', mode=MODE_TYPE)
    _AMBR_max_RequestedBandwidth_UL = INT(name=u'max-RequestedBandwidth-UL', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Bandwidth')))
    _AMBR_max_RequestedBandwidth_DL = INT(name=u'max-RequestedBandwidth-DL', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Bandwidth')))
    _AMBR_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    AMBR._cont = ASN1Dict([
        (u'max-RequestedBandwidth-UL', _AMBR_max_RequestedBandwidth_UL),
        (u'max-RequestedBandwidth-DL', _AMBR_max_RequestedBandwidth_DL),
        (u'extensionContainer', _AMBR_extensionContainer),
        ])
    AMBR._ext = []
    
    #-----< SpecificAPNInfoList >-----#
    SpecificAPNInfoList = SEQ_OF(name=u'SpecificAPNInfoList', mode=MODE_TYPE)
    _SpecificAPNInfoList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'SpecificAPNInfo')))
    SpecificAPNInfoList._cont = _SpecificAPNInfoList__item_
    SpecificAPNInfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< maxNumOfSpecificAPNInfos >-----#
    maxNumOfSpecificAPNInfos = INT(name=u'maxNumOfSpecificAPNInfos', mode=MODE_VALUE)
    maxNumOfSpecificAPNInfos._val = 50
    
    #-----< SpecificAPNInfo >-----#
    SpecificAPNInfo = SEQ(name=u'SpecificAPNInfo', mode=MODE_TYPE)
    _SpecificAPNInfo_apn = OCT_STR(name=u'apn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN')))
    _SpecificAPNInfo_pdn_gw_Identity = SEQ(name=u'pdn-gw-Identity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDN-GW-Identity')))
    _SpecificAPNInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SpecificAPNInfo._cont = ASN1Dict([
        (u'apn', _SpecificAPNInfo_apn),
        (u'pdn-gw-Identity', _SpecificAPNInfo_pdn_gw_Identity),
        (u'extensionContainer', _SpecificAPNInfo_extensionContainer),
        ])
    SpecificAPNInfo._ext = []
    
    #-----< Bandwidth >-----#
    Bandwidth = INT(name=u'Bandwidth', mode=MODE_TYPE)
    
    #-----< QoS-Class-Identifier >-----#
    QoS_Class_Identifier = INT(name=u'QoS-Class-Identifier', mode=MODE_TYPE)
    QoS_Class_Identifier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9)], ev=None, er=[])
    
    #-----< Allocation-Retention-Priority >-----#
    Allocation_Retention_Priority = SEQ(name=u'Allocation-Retention-Priority', mode=MODE_TYPE)
    _Allocation_Retention_Priority_priority_level = INT(name=u'priority-level', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Allocation_Retention_Priority_pre_emption_capability = BOOL(name=u'pre-emption-capability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _Allocation_Retention_Priority_pre_emption_vulnerability = BOOL(name=u'pre-emption-vulnerability', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _Allocation_Retention_Priority_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    Allocation_Retention_Priority._cont = ASN1Dict([
        (u'priority-level', _Allocation_Retention_Priority_priority_level),
        (u'pre-emption-capability', _Allocation_Retention_Priority_pre_emption_capability),
        (u'pre-emption-vulnerability', _Allocation_Retention_Priority_pre_emption_vulnerability),
        (u'extensionContainer', _Allocation_Retention_Priority_extensionContainer),
        ])
    Allocation_Retention_Priority._ext = []
    
    #-----< PDN-GW-Identity >-----#
    PDN_GW_Identity = SEQ(name=u'PDN-GW-Identity', mode=MODE_TYPE)
    _PDN_GW_Identity_pdn_gw_ipv4_Address = OCT_STR(name=u'pdn-gw-ipv4-Address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Address')), opt=True)
    _PDN_GW_Identity_pdn_gw_ipv6_Address = OCT_STR(name=u'pdn-gw-ipv6-Address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Address')), opt=True)
    _PDN_GW_Identity_pdn_gw_name = OCT_STR(name=u'pdn-gw-name', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'FQDN')), opt=True)
    _PDN_GW_Identity_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    PDN_GW_Identity._cont = ASN1Dict([
        (u'pdn-gw-ipv4-Address', _PDN_GW_Identity_pdn_gw_ipv4_Address),
        (u'pdn-gw-ipv6-Address', _PDN_GW_Identity_pdn_gw_ipv6_Address),
        (u'pdn-gw-name', _PDN_GW_Identity_pdn_gw_name),
        (u'extensionContainer', _PDN_GW_Identity_extensionContainer),
        ])
    PDN_GW_Identity._ext = []
    
    #-----< FQDN >-----#
    FQDN = OCT_STR(name=u'FQDN', mode=MODE_TYPE)
    FQDN._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=9, ub=255)], ev=None, er=[])
    
    #-----< PDN-GW-AllocationType >-----#
    PDN_GW_AllocationType = ENUM(name=u'PDN-GW-AllocationType', mode=MODE_TYPE)
    PDN_GW_AllocationType._cont = ASN1Dict([(u'static', 0), (u'dynamic', 1)])
    PDN_GW_AllocationType._ext = None
    
    #-----< WLAN-Offloadability >-----#
    WLAN_Offloadability = SEQ(name=u'WLAN-Offloadability', mode=MODE_TYPE)
    _WLAN_Offloadability_wlan_offloadability_EUTRAN = ENUM(name=u'wlan-offloadability-EUTRAN', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'WLAN-Offloadability-Indication')), opt=True)
    _WLAN_Offloadability_wlan_offloadability_UTRAN = ENUM(name=u'wlan-offloadability-UTRAN', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'WLAN-Offloadability-Indication')), opt=True)
    _WLAN_Offloadability_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    WLAN_Offloadability._cont = ASN1Dict([
        (u'wlan-offloadability-EUTRAN', _WLAN_Offloadability_wlan_offloadability_EUTRAN),
        (u'wlan-offloadability-UTRAN', _WLAN_Offloadability_wlan_offloadability_UTRAN),
        (u'extensionContainer', _WLAN_Offloadability_extensionContainer),
        ])
    WLAN_Offloadability._ext = []
    
    #-----< WLAN-Offloadability-Indication >-----#
    WLAN_Offloadability_Indication = ENUM(name=u'WLAN-Offloadability-Indication', mode=MODE_TYPE)
    WLAN_Offloadability_Indication._cont = ASN1Dict([(u'notAllowed', 0), (u'allowed', 1)])
    WLAN_Offloadability_Indication._ext = None
    
    #-----< AccessRestrictionData >-----#
    AccessRestrictionData = BIT_STR(name=u'AccessRestrictionData', mode=MODE_TYPE)
    AccessRestrictionData._cont = ASN1Dict([(u'utranNotAllowed', 0), (u'geranNotAllowed', 1), (u'ganNotAllowed', 2), (u'i-hspa-evolutionNotAllowed', 3), (u'wb-e-utranNotAllowed', 4), (u'ho-toNon3GPP-AccessNotAllowed', 5), (u'nb-iotNotAllowed', 6)])
    AccessRestrictionData._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=8)], ev=None, er=[])
    
    #-----< AdjacentAccessRestrictionDataList >-----#
    AdjacentAccessRestrictionDataList = SEQ_OF(name=u'AdjacentAccessRestrictionDataList', mode=MODE_TYPE)
    _AdjacentAccessRestrictionDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'AdjacentAccessRestrictionData')))
    AdjacentAccessRestrictionDataList._cont = _AdjacentAccessRestrictionDataList__item_
    AdjacentAccessRestrictionDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< AdjacentAccessRestrictionData >-----#
    AdjacentAccessRestrictionData = SEQ(name=u'AdjacentAccessRestrictionData', mode=MODE_TYPE)
    _AdjacentAccessRestrictionData_plmnId = OCT_STR(name=u'plmnId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'PLMN-Id')))
    _AdjacentAccessRestrictionData_accessRestrictionData = BIT_STR(name=u'accessRestrictionData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AccessRestrictionData')))
    AdjacentAccessRestrictionData._cont = ASN1Dict([
        (u'plmnId', _AdjacentAccessRestrictionData_plmnId),
        (u'accessRestrictionData', _AdjacentAccessRestrictionData_accessRestrictionData),
        ])
    AdjacentAccessRestrictionData._ext = []
    
    #-----< CS-AllocationRetentionPriority >-----#
    CS_AllocationRetentionPriority = OCT_STR(name=u'CS-AllocationRetentionPriority', mode=MODE_TYPE)
    CS_AllocationRetentionPriority._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< IST-AlertTimerValue >-----#
    IST_AlertTimerValue = INT(name=u'IST-AlertTimerValue', mode=MODE_TYPE)
    IST_AlertTimerValue._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=15, ub=255)], ev=None, er=[])
    
    #-----< LCSInformation >-----#
    LCSInformation = SEQ(name=u'LCSInformation', mode=MODE_TYPE)
    _LCSInformation_gmlc_List = SEQ_OF(name=u'gmlc-List', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GMLC-List')), opt=True)
    _LCSInformation_lcs_PrivacyExceptionList = SEQ_OF(name=u'lcs-PrivacyExceptionList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LCS-PrivacyExceptionList')), opt=True)
    _LCSInformation_molr_List = SEQ_OF(name=u'molr-List', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MOLR-List')), opt=True)
    _LCSInformation_add_lcs_PrivacyExceptionList = SEQ_OF(name=u'add-lcs-PrivacyExceptionList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LCS-PrivacyExceptionList')), opt=True)
    LCSInformation._cont = ASN1Dict([
        (u'gmlc-List', _LCSInformation_gmlc_List),
        (u'lcs-PrivacyExceptionList', _LCSInformation_lcs_PrivacyExceptionList),
        (u'molr-List', _LCSInformation_molr_List),
        (u'add-lcs-PrivacyExceptionList', _LCSInformation_add_lcs_PrivacyExceptionList),
        ])
    LCSInformation._ext = [u'add-lcs-PrivacyExceptionList']
    
    #-----< GMLC-List >-----#
    GMLC_List = SEQ_OF(name=u'GMLC-List', mode=MODE_TYPE)
    _GMLC_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    GMLC_List._cont = _GMLC_List__item_
    GMLC_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< maxNumOfGMLC >-----#
    maxNumOfGMLC = INT(name=u'maxNumOfGMLC', mode=MODE_VALUE)
    maxNumOfGMLC._val = 5
    
    #-----< NetworkAccessMode >-----#
    NetworkAccessMode = ENUM(name=u'NetworkAccessMode', mode=MODE_TYPE)
    NetworkAccessMode._cont = ASN1Dict([(u'packetAndCircuit', 0), (u'onlyCircuit', 1), (u'onlyPacket', 2)])
    NetworkAccessMode._ext = []
    
    #-----< GPRSDataList >-----#
    GPRSDataList = SEQ_OF(name=u'GPRSDataList', mode=MODE_TYPE)
    _GPRSDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Context')))
    GPRSDataList._cont = _GPRSDataList__item_
    GPRSDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< maxNumOfPDP-Contexts >-----#
    maxNumOfPDP_Contexts = INT(name=u'maxNumOfPDP-Contexts', mode=MODE_VALUE)
    maxNumOfPDP_Contexts._val = 50
    
    #-----< PDP-Context >-----#
    PDP_Context = SEQ(name=u'PDP-Context', mode=MODE_TYPE)
    _PDP_Context_pdp_ContextId = INT(name=u'pdp-ContextId', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ContextId')))
    _PDP_Context_pdp_Type = OCT_STR(name=u'pdp-Type', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Type')))
    _PDP_Context_pdp_Address = OCT_STR(name=u'pdp-Address', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Address')), opt=True)
    _PDP_Context_qos_Subscribed = OCT_STR(name=u'qos-Subscribed', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'QoS-Subscribed')))
    _PDP_Context_vplmnAddressAllowed = NULL(name=u'vplmnAddressAllowed', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PDP_Context_apn = OCT_STR(name=u'apn', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN')))
    _PDP_Context_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _PDP_Context_ext_QoS_Subscribed = OCT_STR(name=u'ext-QoS-Subscribed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-QoS-Subscribed')), opt=True)
    _PDP_Context_pdp_ChargingCharacteristics = OCT_STR(name=u'pdp-ChargingCharacteristics', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ChargingCharacteristics')), opt=True)
    _PDP_Context_ext2_QoS_Subscribed = OCT_STR(name=u'ext2-QoS-Subscribed', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext2-QoS-Subscribed')), opt=True)
    _PDP_Context_ext3_QoS_Subscribed = OCT_STR(name=u'ext3-QoS-Subscribed', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext3-QoS-Subscribed')), opt=True)
    _PDP_Context_ext4_QoS_Subscribed = OCT_STR(name=u'ext4-QoS-Subscribed', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext4-QoS-Subscribed')), opt=True)
    _PDP_Context_apn_oi_Replacement = OCT_STR(name=u'apn-oi-Replacement', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN-OI-Replacement')), opt=True)
    _PDP_Context_ext_pdp_Type = OCT_STR(name=u'ext-pdp-Type', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-PDP-Type')), opt=True)
    _PDP_Context_ext_pdp_Address = OCT_STR(name=u'ext-pdp-Address', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Address')), opt=True)
    _PDP_Context_ambr = SEQ(name=u'ambr', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AMBR')), opt=True)
    _PDP_Context_sipto_Permission = ENUM(name=u'sipto-Permission', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SIPTO-Permission')), opt=True)
    _PDP_Context_lipa_Permission = ENUM(name=u'lipa-Permission', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LIPA-Permission')), opt=True)
    _PDP_Context_restoration_Priority = OCT_STR(name=u'restoration-Priority', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Restoration-Priority')), opt=True)
    _PDP_Context_sipto_local_network_Permission = ENUM(name=u'sipto-local-network-Permission', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SIPTO-Local-Network-Permission')), opt=True)
    PDP_Context._cont = ASN1Dict([
        (u'pdp-ContextId', _PDP_Context_pdp_ContextId),
        (u'pdp-Type', _PDP_Context_pdp_Type),
        (u'pdp-Address', _PDP_Context_pdp_Address),
        (u'qos-Subscribed', _PDP_Context_qos_Subscribed),
        (u'vplmnAddressAllowed', _PDP_Context_vplmnAddressAllowed),
        (u'apn', _PDP_Context_apn),
        (u'extensionContainer', _PDP_Context_extensionContainer),
        (u'ext-QoS-Subscribed', _PDP_Context_ext_QoS_Subscribed),
        (u'pdp-ChargingCharacteristics', _PDP_Context_pdp_ChargingCharacteristics),
        (u'ext2-QoS-Subscribed', _PDP_Context_ext2_QoS_Subscribed),
        (u'ext3-QoS-Subscribed', _PDP_Context_ext3_QoS_Subscribed),
        (u'ext4-QoS-Subscribed', _PDP_Context_ext4_QoS_Subscribed),
        (u'apn-oi-Replacement', _PDP_Context_apn_oi_Replacement),
        (u'ext-pdp-Type', _PDP_Context_ext_pdp_Type),
        (u'ext-pdp-Address', _PDP_Context_ext_pdp_Address),
        (u'ambr', _PDP_Context_ambr),
        (u'sipto-Permission', _PDP_Context_sipto_Permission),
        (u'lipa-Permission', _PDP_Context_lipa_Permission),
        (u'restoration-Priority', _PDP_Context_restoration_Priority),
        (u'sipto-local-network-Permission', _PDP_Context_sipto_local_network_Permission),
        ])
    PDP_Context._ext = [u'ext-QoS-Subscribed', u'pdp-ChargingCharacteristics', u'ext2-QoS-Subscribed', u'ext3-QoS-Subscribed', u'ext4-QoS-Subscribed', u'apn-oi-Replacement', u'ext-pdp-Type', u'ext-pdp-Address', u'ambr', u'sipto-Permission', u'lipa-Permission', u'restoration-Priority', u'sipto-local-network-Permission']
    
    #-----< Restoration-Priority >-----#
    Restoration_Priority = OCT_STR(name=u'Restoration-Priority', mode=MODE_TYPE)
    Restoration_Priority._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< SIPTO-Permission >-----#
    SIPTO_Permission = ENUM(name=u'SIPTO-Permission', mode=MODE_TYPE)
    SIPTO_Permission._cont = ASN1Dict([(u'siptoAboveRanAllowed', 0), (u'siptoAboveRanNotAllowed', 1)])
    SIPTO_Permission._ext = None
    
    #-----< SIPTO-Local-Network-Permission >-----#
    SIPTO_Local_Network_Permission = ENUM(name=u'SIPTO-Local-Network-Permission', mode=MODE_TYPE)
    SIPTO_Local_Network_Permission._cont = ASN1Dict([(u'siptoAtLocalNetworkAllowed', 0), (u'siptoAtLocalNetworkNotAllowed', 1)])
    SIPTO_Local_Network_Permission._ext = None
    
    #-----< LIPA-Permission >-----#
    LIPA_Permission = ENUM(name=u'LIPA-Permission', mode=MODE_TYPE)
    LIPA_Permission._cont = ASN1Dict([(u'lipaProhibited', 0), (u'lipaOnly', 1), (u'lipaConditional', 2)])
    LIPA_Permission._ext = None
    
    #-----< ContextId >-----#
    ContextId = INT(name=u'ContextId', mode=MODE_TYPE)
    ContextId._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< GPRSSubscriptionData >-----#
    GPRSSubscriptionData = SEQ(name=u'GPRSSubscriptionData', mode=MODE_TYPE)
    _GPRSSubscriptionData_completeDataListIncluded = NULL(name=u'completeDataListIncluded', mode=MODE_TYPE, opt=True)
    _GPRSSubscriptionData_gprsDataList = SEQ_OF(name=u'gprsDataList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GPRSDataList')))
    _GPRSSubscriptionData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _GPRSSubscriptionData_apn_oi_Replacement = OCT_STR(name=u'apn-oi-Replacement', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN-OI-Replacement')), opt=True)
    GPRSSubscriptionData._cont = ASN1Dict([
        (u'completeDataListIncluded', _GPRSSubscriptionData_completeDataListIncluded),
        (u'gprsDataList', _GPRSSubscriptionData_gprsDataList),
        (u'extensionContainer', _GPRSSubscriptionData_extensionContainer),
        (u'apn-oi-Replacement', _GPRSSubscriptionData_apn_oi_Replacement),
        ])
    GPRSSubscriptionData._ext = [u'apn-oi-Replacement']
    
    #-----< SGSN-CAMEL-SubscriptionInfo >-----#
    SGSN_CAMEL_SubscriptionInfo = SEQ(name=u'SGSN-CAMEL-SubscriptionInfo', mode=MODE_TYPE)
    _SGSN_CAMEL_SubscriptionInfo_gprs_CSI = SEQ(name=u'gprs-CSI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GPRS-CSI')), opt=True)
    _SGSN_CAMEL_SubscriptionInfo_mo_sms_CSI = SEQ(name=u'mo-sms-CSI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMS-CSI')), opt=True)
    _SGSN_CAMEL_SubscriptionInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SGSN_CAMEL_SubscriptionInfo_mt_sms_CSI = SEQ(name=u'mt-sms-CSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMS-CSI')), opt=True)
    _SGSN_CAMEL_SubscriptionInfo_mt_smsCAMELTDP_CriteriaList = SEQ_OF(name=u'mt-smsCAMELTDP-CriteriaList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MT-smsCAMELTDP-CriteriaList')), opt=True)
    _SGSN_CAMEL_SubscriptionInfo_mg_csi = SEQ(name=u'mg-csi', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MG-CSI')), opt=True)
    SGSN_CAMEL_SubscriptionInfo._cont = ASN1Dict([
        (u'gprs-CSI', _SGSN_CAMEL_SubscriptionInfo_gprs_CSI),
        (u'mo-sms-CSI', _SGSN_CAMEL_SubscriptionInfo_mo_sms_CSI),
        (u'extensionContainer', _SGSN_CAMEL_SubscriptionInfo_extensionContainer),
        (u'mt-sms-CSI', _SGSN_CAMEL_SubscriptionInfo_mt_sms_CSI),
        (u'mt-smsCAMELTDP-CriteriaList', _SGSN_CAMEL_SubscriptionInfo_mt_smsCAMELTDP_CriteriaList),
        (u'mg-csi', _SGSN_CAMEL_SubscriptionInfo_mg_csi),
        ])
    SGSN_CAMEL_SubscriptionInfo._ext = [u'mt-sms-CSI', u'mt-smsCAMELTDP-CriteriaList', u'mg-csi']
    
    #-----< GPRS-CSI >-----#
    GPRS_CSI = SEQ(name=u'GPRS-CSI', mode=MODE_TYPE)
    _GPRS_CSI_gprs_CamelTDPDataList = SEQ_OF(name=u'gprs-CamelTDPDataList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GPRS-CamelTDPDataList')), opt=True)
    _GPRS_CSI_camelCapabilityHandling = INT(name=u'camelCapabilityHandling', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CamelCapabilityHandling')), opt=True)
    _GPRS_CSI_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _GPRS_CSI_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _GPRS_CSI_csi_Active = NULL(name=u'csi-Active', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    GPRS_CSI._cont = ASN1Dict([
        (u'gprs-CamelTDPDataList', _GPRS_CSI_gprs_CamelTDPDataList),
        (u'camelCapabilityHandling', _GPRS_CSI_camelCapabilityHandling),
        (u'extensionContainer', _GPRS_CSI_extensionContainer),
        (u'notificationToCSE', _GPRS_CSI_notificationToCSE),
        (u'csi-Active', _GPRS_CSI_csi_Active),
        ])
    GPRS_CSI._ext = []
    
    #-----< GPRS-CamelTDPDataList >-----#
    GPRS_CamelTDPDataList = SEQ_OF(name=u'GPRS-CamelTDPDataList', mode=MODE_TYPE)
    _GPRS_CamelTDPDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'GPRS-CamelTDPData')))
    GPRS_CamelTDPDataList._cont = _GPRS_CamelTDPDataList__item_
    GPRS_CamelTDPDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< GPRS-CamelTDPData >-----#
    GPRS_CamelTDPData = SEQ(name=u'GPRS-CamelTDPData', mode=MODE_TYPE)
    _GPRS_CamelTDPData_gprs_TriggerDetectionPoint = ENUM(name=u'gprs-TriggerDetectionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GPRS-TriggerDetectionPoint')))
    _GPRS_CamelTDPData_serviceKey = INT(name=u'serviceKey', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServiceKey')))
    _GPRS_CamelTDPData_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _GPRS_CamelTDPData_defaultSessionHandling = ENUM(name=u'defaultSessionHandling', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'DefaultGPRS-Handling')))
    _GPRS_CamelTDPData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    GPRS_CamelTDPData._cont = ASN1Dict([
        (u'gprs-TriggerDetectionPoint', _GPRS_CamelTDPData_gprs_TriggerDetectionPoint),
        (u'serviceKey', _GPRS_CamelTDPData_serviceKey),
        (u'gsmSCF-Address', _GPRS_CamelTDPData_gsmSCF_Address),
        (u'defaultSessionHandling', _GPRS_CamelTDPData_defaultSessionHandling),
        (u'extensionContainer', _GPRS_CamelTDPData_extensionContainer),
        ])
    GPRS_CamelTDPData._ext = []
    
    #-----< DefaultGPRS-Handling >-----#
    DefaultGPRS_Handling = ENUM(name=u'DefaultGPRS-Handling', mode=MODE_TYPE)
    DefaultGPRS_Handling._cont = ASN1Dict([(u'continueTransaction', 0), (u'releaseTransaction', 1)])
    DefaultGPRS_Handling._ext = []
    
    #-----< GPRS-TriggerDetectionPoint >-----#
    GPRS_TriggerDetectionPoint = ENUM(name=u'GPRS-TriggerDetectionPoint', mode=MODE_TYPE)
    GPRS_TriggerDetectionPoint._cont = ASN1Dict([(u'attach', 1), (u'attachChangeOfPosition', 2), (u'pdp-ContextEstablishment', 11), (u'pdp-ContextEstablishmentAcknowledgement', 12), (u'pdp-ContextChangeOfPosition', 14)])
    GPRS_TriggerDetectionPoint._ext = []
    
    #-----< APN >-----#
    APN = OCT_STR(name=u'APN', mode=MODE_TYPE)
    APN._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=63)], ev=None, er=[])
    
    #-----< PDP-Type >-----#
    PDP_Type = OCT_STR(name=u'PDP-Type', mode=MODE_TYPE)
    PDP_Type._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< Ext-PDP-Type >-----#
    Ext_PDP_Type = OCT_STR(name=u'Ext-PDP-Type', mode=MODE_TYPE)
    Ext_PDP_Type._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< PDP-Address >-----#
    PDP_Address = OCT_STR(name=u'PDP-Address', mode=MODE_TYPE)
    PDP_Address._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< QoS-Subscribed >-----#
    QoS_Subscribed = OCT_STR(name=u'QoS-Subscribed', mode=MODE_TYPE)
    QoS_Subscribed._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< Ext-QoS-Subscribed >-----#
    Ext_QoS_Subscribed = OCT_STR(name=u'Ext-QoS-Subscribed', mode=MODE_TYPE)
    Ext_QoS_Subscribed._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=9)], ev=None, er=[])
    
    #-----< Ext2-QoS-Subscribed >-----#
    Ext2_QoS_Subscribed = OCT_STR(name=u'Ext2-QoS-Subscribed', mode=MODE_TYPE)
    Ext2_QoS_Subscribed._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< Ext3-QoS-Subscribed >-----#
    Ext3_QoS_Subscribed = OCT_STR(name=u'Ext3-QoS-Subscribed', mode=MODE_TYPE)
    Ext3_QoS_Subscribed._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    
    #-----< Ext4-QoS-Subscribed >-----#
    Ext4_QoS_Subscribed = OCT_STR(name=u'Ext4-QoS-Subscribed', mode=MODE_TYPE)
    Ext4_QoS_Subscribed._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< ChargingCharacteristics >-----#
    ChargingCharacteristics = OCT_STR(name=u'ChargingCharacteristics', mode=MODE_TYPE)
    ChargingCharacteristics._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< LSAOnlyAccessIndicator >-----#
    LSAOnlyAccessIndicator = ENUM(name=u'LSAOnlyAccessIndicator', mode=MODE_TYPE)
    LSAOnlyAccessIndicator._cont = ASN1Dict([(u'accessOutsideLSAsAllowed', 0), (u'accessOutsideLSAsRestricted', 1)])
    LSAOnlyAccessIndicator._ext = None
    
    #-----< LSADataList >-----#
    LSADataList = SEQ_OF(name=u'LSADataList', mode=MODE_TYPE)
    _LSADataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAData')))
    LSADataList._cont = _LSADataList__item_
    LSADataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    
    #-----< maxNumOfLSAs >-----#
    maxNumOfLSAs = INT(name=u'maxNumOfLSAs', mode=MODE_VALUE)
    maxNumOfLSAs._val = 20
    
    #-----< LSAData >-----#
    LSAData = SEQ(name=u'LSAData', mode=MODE_TYPE)
    _LSAData_lsaIdentity = OCT_STR(name=u'lsaIdentity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAIdentity')))
    _LSAData_lsaAttributes = OCT_STR(name=u'lsaAttributes', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAAttributes')))
    _LSAData_lsaActiveModeIndicator = NULL(name=u'lsaActiveModeIndicator', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _LSAData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    LSAData._cont = ASN1Dict([
        (u'lsaIdentity', _LSAData_lsaIdentity),
        (u'lsaAttributes', _LSAData_lsaAttributes),
        (u'lsaActiveModeIndicator', _LSAData_lsaActiveModeIndicator),
        (u'extensionContainer', _LSAData_extensionContainer),
        ])
    LSAData._ext = []
    
    #-----< LSAInformation >-----#
    LSAInformation = SEQ(name=u'LSAInformation', mode=MODE_TYPE)
    _LSAInformation_completeDataListIncluded = NULL(name=u'completeDataListIncluded', mode=MODE_TYPE, opt=True)
    _LSAInformation_lsaOnlyAccessIndicator = ENUM(name=u'lsaOnlyAccessIndicator', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAOnlyAccessIndicator')), opt=True)
    _LSAInformation_lsaDataList = SEQ_OF(name=u'lsaDataList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSADataList')), opt=True)
    _LSAInformation_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    LSAInformation._cont = ASN1Dict([
        (u'completeDataListIncluded', _LSAInformation_completeDataListIncluded),
        (u'lsaOnlyAccessIndicator', _LSAInformation_lsaOnlyAccessIndicator),
        (u'lsaDataList', _LSAInformation_lsaDataList),
        (u'extensionContainer', _LSAInformation_extensionContainer),
        ])
    LSAInformation._ext = []
    
    #-----< LSAIdentity >-----#
    LSAIdentity = OCT_STR(name=u'LSAIdentity', mode=MODE_TYPE)
    LSAIdentity._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< LSAAttributes >-----#
    LSAAttributes = OCT_STR(name=u'LSAAttributes', mode=MODE_TYPE)
    LSAAttributes._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< SubscriberData >-----#
    SubscriberData = SEQ(name=u'SubscriberData', mode=MODE_TYPE)
    _SubscriberData_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _SubscriberData_category = OCT_STR(name=u'category', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Category')), opt=True)
    _SubscriberData_subscriberStatus = ENUM(name=u'subscriberStatus', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SubscriberStatus')), opt=True)
    _SubscriberData_bearerServiceList = SEQ_OF(name=u'bearerServiceList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BearerServiceList')), opt=True)
    _SubscriberData_teleserviceList = SEQ_OF(name=u'teleserviceList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'TeleserviceList')), opt=True)
    _SubscriberData_provisionedSS = SEQ_OF(name=u'provisionedSS', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-SS-InfoList')), opt=True)
    _SubscriberData_odb_Data = SEQ(name=u'odb-Data', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ODB-Data')), opt=True)
    _SubscriberData_roamingRestrictionDueToUnsupportedFeature = NULL(name=u'roamingRestrictionDueToUnsupportedFeature', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SubscriberData_regionalSubscriptionData = SEQ_OF(name=u'regionalSubscriptionData', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ZoneCodeList')), opt=True)
    _SubscriberData_vbsSubscriptionData = SEQ_OF(name=u'vbsSubscriptionData', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'VBSDataList')), opt=True)
    _SubscriberData_vgcsSubscriptionData = SEQ_OF(name=u'vgcsSubscriptionData', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'VGCSDataList')), opt=True)
    _SubscriberData_vlrCamelSubscriptionInfo = SEQ(name=u'vlrCamelSubscriptionInfo', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'VlrCamelSubscriptionInfo')), opt=True)
    SubscriberData._cont = ASN1Dict([
        (u'msisdn', _SubscriberData_msisdn),
        (u'category', _SubscriberData_category),
        (u'subscriberStatus', _SubscriberData_subscriberStatus),
        (u'bearerServiceList', _SubscriberData_bearerServiceList),
        (u'teleserviceList', _SubscriberData_teleserviceList),
        (u'provisionedSS', _SubscriberData_provisionedSS),
        (u'odb-Data', _SubscriberData_odb_Data),
        (u'roamingRestrictionDueToUnsupportedFeature', _SubscriberData_roamingRestrictionDueToUnsupportedFeature),
        (u'regionalSubscriptionData', _SubscriberData_regionalSubscriptionData),
        (u'vbsSubscriptionData', _SubscriberData_vbsSubscriptionData),
        (u'vgcsSubscriptionData', _SubscriberData_vgcsSubscriptionData),
        (u'vlrCamelSubscriptionInfo', _SubscriberData_vlrCamelSubscriptionInfo),
        ])
    SubscriberData._ext = None
    
    #-----< Category >-----#
    Category = OCT_STR(name=u'Category', mode=MODE_TYPE)
    Category._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< SubscriberStatus >-----#
    SubscriberStatus = ENUM(name=u'SubscriberStatus', mode=MODE_TYPE)
    SubscriberStatus._cont = ASN1Dict([(u'serviceGranted', 0), (u'operatorDeterminedBarring', 1)])
    SubscriberStatus._ext = None
    
    #-----< BearerServiceList >-----#
    BearerServiceList = SEQ_OF(name=u'BearerServiceList', mode=MODE_TYPE)
    _BearerServiceList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-BS-Code', 'Ext-BearerServiceCode')))
    BearerServiceList._cont = _BearerServiceList__item_
    BearerServiceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< maxNumOfBearerServices >-----#
    maxNumOfBearerServices = INT(name=u'maxNumOfBearerServices', mode=MODE_VALUE)
    maxNumOfBearerServices._val = 50
    
    #-----< TeleserviceList >-----#
    TeleserviceList = SEQ_OF(name=u'TeleserviceList', mode=MODE_TYPE)
    _TeleserviceList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-TS-Code', 'Ext-TeleserviceCode')))
    TeleserviceList._cont = _TeleserviceList__item_
    TeleserviceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    
    #-----< maxNumOfTeleservices >-----#
    maxNumOfTeleservices = INT(name=u'maxNumOfTeleservices', mode=MODE_VALUE)
    maxNumOfTeleservices._val = 20
    
    #-----< ODB-Data >-----#
    ODB_Data = SEQ(name=u'ODB-Data', mode=MODE_TYPE)
    _ODB_Data_odb_GeneralData = BIT_STR(name=u'odb-GeneralData', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ODB-GeneralData')))
    _ODB_Data_odb_HPLMN_Data = BIT_STR(name=u'odb-HPLMN-Data', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ODB-HPLMN-Data')), opt=True)
    _ODB_Data_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ODB_Data._cont = ASN1Dict([
        (u'odb-GeneralData', _ODB_Data_odb_GeneralData),
        (u'odb-HPLMN-Data', _ODB_Data_odb_HPLMN_Data),
        (u'extensionContainer', _ODB_Data_extensionContainer),
        ])
    ODB_Data._ext = []
    
    #-----< ODB-GeneralData >-----#
    ODB_GeneralData = BIT_STR(name=u'ODB-GeneralData', mode=MODE_TYPE)
    ODB_GeneralData._cont = ASN1Dict([(u'allOG-CallsBarred', 0), (u'internationalOGCallsBarred', 1), (u'internationalOGCallsNotToHPLMN-CountryBarred', 2), (u'interzonalOGCallsBarred', 6), (u'interzonalOGCallsNotToHPLMN-CountryBarred', 7), (u'interzonalOGCallsAndInternationalOGCallsNotToHPLMN-CountryBarred', 8), (u'premiumRateInformationOGCallsBarred', 3), (u'premiumRateEntertainementOGCallsBarred', 4), (u'ss-AccessBarred', 5), (u'allECT-Barred', 9), (u'chargeableECT-Barred', 10), (u'internationalECT-Barred', 11), (u'interzonalECT-Barred', 12), (u'doublyChargeableECT-Barred', 13), (u'multipleECT-Barred', 14), (u'allPacketOrientedServicesBarred', 15), (u'roamerAccessToHPLMN-AP-Barred', 16), (u'roamerAccessToVPLMN-AP-Barred', 17), (u'roamingOutsidePLMNOG-CallsBarred', 18), (u'allIC-CallsBarred', 19), (u'roamingOutsidePLMNIC-CallsBarred', 20), (u'roamingOutsidePLMNICountryIC-CallsBarred', 21), (u'roamingOutsidePLMN-Barred', 22), (u'roamingOutsidePLMN-CountryBarred', 23), (u'registrationAllCF-Barred', 24), (u'registrationCFNotToHPLMN-Barred', 25), (u'registrationInterzonalCF-Barred', 26), (u'registrationInterzonalCFNotToHPLMN-Barred', 27), (u'registrationInternationalCF-Barred', 28)])
    ODB_GeneralData._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=15, ub=32)], ev=None, er=[])
    
    #-----< ODB-HPLMN-Data >-----#
    ODB_HPLMN_Data = BIT_STR(name=u'ODB-HPLMN-Data', mode=MODE_TYPE)
    ODB_HPLMN_Data._cont = ASN1Dict([(u'plmn-SpecificBarringType1', 0), (u'plmn-SpecificBarringType2', 1), (u'plmn-SpecificBarringType3', 2), (u'plmn-SpecificBarringType4', 3)])
    ODB_HPLMN_Data._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=4, ub=32)], ev=None, er=[])
    
    #-----< Ext-SS-InfoList >-----#
    Ext_SS_InfoList = SEQ_OF(name=u'Ext-SS-InfoList', mode=MODE_TYPE)
    _Ext_SS_InfoList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-SS-Info')))
    Ext_SS_InfoList._cont = _Ext_SS_InfoList__item_
    Ext_SS_InfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    
    #-----< Ext-SS-Info >-----#
    Ext_SS_Info = CHOICE(name=u'Ext-SS-Info', mode=MODE_TYPE)
    _Ext_SS_Info_forwardingInfo = SEQ(name=u'forwardingInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-ForwInfo')))
    _Ext_SS_Info_callBarringInfo = SEQ(name=u'callBarringInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-CallBarInfo')))
    _Ext_SS_Info_cug_Info = SEQ(name=u'cug-Info', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CUG-Info')))
    _Ext_SS_Info_ss_Data = SEQ(name=u'ss-Data', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-SS-Data')))
    _Ext_SS_Info_emlpp_Info = SEQ(name=u'emlpp-Info', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Info')))
    Ext_SS_Info._cont = ASN1Dict([
        (u'forwardingInfo', _Ext_SS_Info_forwardingInfo),
        (u'callBarringInfo', _Ext_SS_Info_callBarringInfo),
        (u'cug-Info', _Ext_SS_Info_cug_Info),
        (u'ss-Data', _Ext_SS_Info_ss_Data),
        (u'emlpp-Info', _Ext_SS_Info_emlpp_Info),
        ])
    Ext_SS_Info._ext = None
    
    #-----< Ext-ForwInfo >-----#
    Ext_ForwInfo = SEQ(name=u'Ext-ForwInfo', mode=MODE_TYPE)
    _Ext_ForwInfo_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _Ext_ForwInfo_forwardingFeatureList = SEQ_OF(name=u'forwardingFeatureList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-ForwFeatureList')))
    _Ext_ForwInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    Ext_ForwInfo._cont = ASN1Dict([
        (u'ss-Code', _Ext_ForwInfo_ss_Code),
        (u'forwardingFeatureList', _Ext_ForwInfo_forwardingFeatureList),
        (u'extensionContainer', _Ext_ForwInfo_extensionContainer),
        ])
    Ext_ForwInfo._ext = []
    
    #-----< Ext-ForwFeatureList >-----#
    Ext_ForwFeatureList = SEQ_OF(name=u'Ext-ForwFeatureList', mode=MODE_TYPE)
    _Ext_ForwFeatureList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-ForwFeature')))
    Ext_ForwFeatureList._cont = _Ext_ForwFeatureList__item_
    Ext_ForwFeatureList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< Ext-ForwFeature >-----#
    Ext_ForwFeature = SEQ(name=u'Ext-ForwFeature', mode=MODE_TYPE)
    _Ext_ForwFeature_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _Ext_ForwFeature_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    _Ext_ForwFeature_forwardedToNumber = OCT_STR(name=u'forwardedToNumber', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _Ext_ForwFeature_forwardedToSubaddress = OCT_STR(name=u'forwardedToSubaddress', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-SubaddressString')), opt=True)
    _Ext_ForwFeature_forwardingOptions = OCT_STR(name=u'forwardingOptions', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-ForwOptions')), opt=True)
    _Ext_ForwFeature_noReplyConditionTime = INT(name=u'noReplyConditionTime', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-NoRepCondTime')), opt=True)
    _Ext_ForwFeature_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _Ext_ForwFeature_longForwardedToNumber = OCT_STR(name=u'longForwardedToNumber', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'FTN-AddressString')), opt=True)
    Ext_ForwFeature._cont = ASN1Dict([
        (u'basicService', _Ext_ForwFeature_basicService),
        (u'ss-Status', _Ext_ForwFeature_ss_Status),
        (u'forwardedToNumber', _Ext_ForwFeature_forwardedToNumber),
        (u'forwardedToSubaddress', _Ext_ForwFeature_forwardedToSubaddress),
        (u'forwardingOptions', _Ext_ForwFeature_forwardingOptions),
        (u'noReplyConditionTime', _Ext_ForwFeature_noReplyConditionTime),
        (u'extensionContainer', _Ext_ForwFeature_extensionContainer),
        (u'longForwardedToNumber', _Ext_ForwFeature_longForwardedToNumber),
        ])
    Ext_ForwFeature._ext = [u'longForwardedToNumber']
    
    #-----< Ext-ForwOptions >-----#
    Ext_ForwOptions = OCT_STR(name=u'Ext-ForwOptions', mode=MODE_TYPE)
    Ext_ForwOptions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< Ext-NoRepCondTime >-----#
    Ext_NoRepCondTime = INT(name=u'Ext-NoRepCondTime', mode=MODE_TYPE)
    Ext_NoRepCondTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=100)], ev=None, er=[])
    
    #-----< Ext-CallBarInfo >-----#
    Ext_CallBarInfo = SEQ(name=u'Ext-CallBarInfo', mode=MODE_TYPE)
    _Ext_CallBarInfo_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _Ext_CallBarInfo_callBarringFeatureList = SEQ_OF(name=u'callBarringFeatureList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-CallBarFeatureList')))
    _Ext_CallBarInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    Ext_CallBarInfo._cont = ASN1Dict([
        (u'ss-Code', _Ext_CallBarInfo_ss_Code),
        (u'callBarringFeatureList', _Ext_CallBarInfo_callBarringFeatureList),
        (u'extensionContainer', _Ext_CallBarInfo_extensionContainer),
        ])
    Ext_CallBarInfo._ext = []
    
    #-----< Ext-CallBarFeatureList >-----#
    Ext_CallBarFeatureList = SEQ_OF(name=u'Ext-CallBarFeatureList', mode=MODE_TYPE)
    _Ext_CallBarFeatureList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-CallBarringFeature')))
    Ext_CallBarFeatureList._cont = _Ext_CallBarFeatureList__item_
    Ext_CallBarFeatureList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< Ext-CallBarringFeature >-----#
    Ext_CallBarringFeature = SEQ(name=u'Ext-CallBarringFeature', mode=MODE_TYPE)
    _Ext_CallBarringFeature_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _Ext_CallBarringFeature_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    _Ext_CallBarringFeature_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    Ext_CallBarringFeature._cont = ASN1Dict([
        (u'basicService', _Ext_CallBarringFeature_basicService),
        (u'ss-Status', _Ext_CallBarringFeature_ss_Status),
        (u'extensionContainer', _Ext_CallBarringFeature_extensionContainer),
        ])
    Ext_CallBarringFeature._ext = []
    
    #-----< CUG-Info >-----#
    CUG_Info = SEQ(name=u'CUG-Info', mode=MODE_TYPE)
    _CUG_Info_cug_SubscriptionList = SEQ_OF(name=u'cug-SubscriptionList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CUG-SubscriptionList')))
    _CUG_Info_cug_FeatureList = SEQ_OF(name=u'cug-FeatureList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CUG-FeatureList')), opt=True)
    _CUG_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CUG_Info._cont = ASN1Dict([
        (u'cug-SubscriptionList', _CUG_Info_cug_SubscriptionList),
        (u'cug-FeatureList', _CUG_Info_cug_FeatureList),
        (u'extensionContainer', _CUG_Info_extensionContainer),
        ])
    CUG_Info._ext = []
    
    #-----< CUG-SubscriptionList >-----#
    CUG_SubscriptionList = SEQ_OF(name=u'CUG-SubscriptionList', mode=MODE_TYPE)
    _CUG_SubscriptionList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CUG-Subscription')))
    CUG_SubscriptionList._cont = _CUG_SubscriptionList__item_
    CUG_SubscriptionList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=10)], ev=None, er=[])
    
    #-----< CUG-Subscription >-----#
    CUG_Subscription = SEQ(name=u'CUG-Subscription', mode=MODE_TYPE)
    _CUG_Subscription_cug_Index = INT(name=u'cug-Index', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CUG-Index')))
    _CUG_Subscription_cug_Interlock = OCT_STR(name=u'cug-Interlock', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CUG-Interlock')))
    _CUG_Subscription_intraCUG_Options = ENUM(name=u'intraCUG-Options', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'IntraCUG-Options')))
    _CUG_Subscription_basicServiceGroupList = SEQ_OF(name=u'basicServiceGroupList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-BasicServiceGroupList')), opt=True)
    _CUG_Subscription_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CUG_Subscription._cont = ASN1Dict([
        (u'cug-Index', _CUG_Subscription_cug_Index),
        (u'cug-Interlock', _CUG_Subscription_cug_Interlock),
        (u'intraCUG-Options', _CUG_Subscription_intraCUG_Options),
        (u'basicServiceGroupList', _CUG_Subscription_basicServiceGroupList),
        (u'extensionContainer', _CUG_Subscription_extensionContainer),
        ])
    CUG_Subscription._ext = []
    
    #-----< CUG-Index >-----#
    CUG_Index = INT(name=u'CUG-Index', mode=MODE_TYPE)
    CUG_Index._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=32767)], ev=None, er=[])
    
    #-----< CUG-Interlock >-----#
    CUG_Interlock = OCT_STR(name=u'CUG-Interlock', mode=MODE_TYPE)
    CUG_Interlock._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< IntraCUG-Options >-----#
    IntraCUG_Options = ENUM(name=u'IntraCUG-Options', mode=MODE_TYPE)
    IntraCUG_Options._cont = ASN1Dict([(u'noCUG-Restrictions', 0), (u'cugIC-CallBarred', 1), (u'cugOG-CallBarred', 2)])
    IntraCUG_Options._ext = None
    
    #-----< maxNumOfCUG >-----#
    maxNumOfCUG = INT(name=u'maxNumOfCUG', mode=MODE_VALUE)
    maxNumOfCUG._val = 10
    
    #-----< CUG-FeatureList >-----#
    CUG_FeatureList = SEQ_OF(name=u'CUG-FeatureList', mode=MODE_TYPE)
    _CUG_FeatureList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CUG-Feature')))
    CUG_FeatureList._cont = _CUG_FeatureList__item_
    CUG_FeatureList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< Ext-BasicServiceGroupList >-----#
    Ext_BasicServiceGroupList = SEQ_OF(name=u'Ext-BasicServiceGroupList', mode=MODE_TYPE)
    _Ext_BasicServiceGroupList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')))
    Ext_BasicServiceGroupList._cont = _Ext_BasicServiceGroupList__item_
    Ext_BasicServiceGroupList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< maxNumOfExt-BasicServiceGroups >-----#
    maxNumOfExt_BasicServiceGroups = INT(name=u'maxNumOfExt-BasicServiceGroups', mode=MODE_VALUE)
    maxNumOfExt_BasicServiceGroups._val = 32
    
    #-----< CUG-Feature >-----#
    CUG_Feature = SEQ(name=u'CUG-Feature', mode=MODE_TYPE)
    _CUG_Feature_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _CUG_Feature_preferentialCUG_Indicator = INT(name=u'preferentialCUG-Indicator', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CUG-Index')), opt=True)
    _CUG_Feature_interCUG_Restrictions = OCT_STR(name=u'interCUG-Restrictions', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'InterCUG-Restrictions')))
    _CUG_Feature_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CUG_Feature._cont = ASN1Dict([
        (u'basicService', _CUG_Feature_basicService),
        (u'preferentialCUG-Indicator', _CUG_Feature_preferentialCUG_Indicator),
        (u'interCUG-Restrictions', _CUG_Feature_interCUG_Restrictions),
        (u'extensionContainer', _CUG_Feature_extensionContainer),
        ])
    CUG_Feature._ext = []
    
    #-----< InterCUG-Restrictions >-----#
    InterCUG_Restrictions = OCT_STR(name=u'InterCUG-Restrictions', mode=MODE_TYPE)
    InterCUG_Restrictions._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< Ext-SS-Data >-----#
    Ext_SS_Data = SEQ(name=u'Ext-SS-Data', mode=MODE_TYPE)
    _Ext_SS_Data_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _Ext_SS_Data_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    _Ext_SS_Data_ss_SubscriptionOption = CHOICE(name=u'ss-SubscriptionOption', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-SubscriptionOption')), opt=True)
    _Ext_SS_Data_basicServiceGroupList = SEQ_OF(name=u'basicServiceGroupList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-BasicServiceGroupList')), opt=True)
    _Ext_SS_Data_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    Ext_SS_Data._cont = ASN1Dict([
        (u'ss-Code', _Ext_SS_Data_ss_Code),
        (u'ss-Status', _Ext_SS_Data_ss_Status),
        (u'ss-SubscriptionOption', _Ext_SS_Data_ss_SubscriptionOption),
        (u'basicServiceGroupList', _Ext_SS_Data_basicServiceGroupList),
        (u'extensionContainer', _Ext_SS_Data_extensionContainer),
        ])
    Ext_SS_Data._ext = []
    
    #-----< LCS-PrivacyExceptionList >-----#
    LCS_PrivacyExceptionList = SEQ_OF(name=u'LCS-PrivacyExceptionList', mode=MODE_TYPE)
    _LCS_PrivacyExceptionList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'LCS-PrivacyClass')))
    LCS_PrivacyExceptionList._cont = _LCS_PrivacyExceptionList__item_
    LCS_PrivacyExceptionList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< maxNumOfPrivacyClass >-----#
    maxNumOfPrivacyClass = INT(name=u'maxNumOfPrivacyClass', mode=MODE_VALUE)
    maxNumOfPrivacyClass._val = 4
    
    #-----< LCS-PrivacyClass >-----#
    LCS_PrivacyClass = SEQ(name=u'LCS-PrivacyClass', mode=MODE_TYPE)
    _LCS_PrivacyClass_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _LCS_PrivacyClass_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    _LCS_PrivacyClass_notificationToMSUser = ENUM(name=u'notificationToMSUser', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'NotificationToMSUser')), opt=True)
    _LCS_PrivacyClass_externalClientList = SEQ_OF(name=u'externalClientList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ExternalClientList')), opt=True)
    _LCS_PrivacyClass_plmnClientList = SEQ_OF(name=u'plmnClientList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PLMNClientList')), opt=True)
    _LCS_PrivacyClass_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _LCS_PrivacyClass_ext_externalClientList = SEQ_OF(name=u'ext-externalClientList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-ExternalClientList')), opt=True)
    _LCS_PrivacyClass_serviceTypeList = SEQ_OF(name=u'serviceTypeList', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServiceTypeList')), opt=True)
    LCS_PrivacyClass._cont = ASN1Dict([
        (u'ss-Code', _LCS_PrivacyClass_ss_Code),
        (u'ss-Status', _LCS_PrivacyClass_ss_Status),
        (u'notificationToMSUser', _LCS_PrivacyClass_notificationToMSUser),
        (u'externalClientList', _LCS_PrivacyClass_externalClientList),
        (u'plmnClientList', _LCS_PrivacyClass_plmnClientList),
        (u'extensionContainer', _LCS_PrivacyClass_extensionContainer),
        (u'ext-externalClientList', _LCS_PrivacyClass_ext_externalClientList),
        (u'serviceTypeList', _LCS_PrivacyClass_serviceTypeList),
        ])
    LCS_PrivacyClass._ext = [u'ext-externalClientList', u'serviceTypeList']
    
    #-----< ExternalClientList >-----#
    ExternalClientList = SEQ_OF(name=u'ExternalClientList', mode=MODE_TYPE)
    _ExternalClientList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ExternalClient')))
    ExternalClientList._cont = _ExternalClientList__item_
    ExternalClientList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=5)], ev=None, er=[])
    
    #-----< maxNumOfExternalClient >-----#
    maxNumOfExternalClient = INT(name=u'maxNumOfExternalClient', mode=MODE_VALUE)
    maxNumOfExternalClient._val = 5
    
    #-----< PLMNClientList >-----#
    PLMNClientList = SEQ_OF(name=u'PLMNClientList', mode=MODE_TYPE)
    _PLMNClientList__item_ = ENUM(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSClientInternalID')))
    PLMNClientList._cont = _PLMNClientList__item_
    PLMNClientList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< maxNumOfPLMNClient >-----#
    maxNumOfPLMNClient = INT(name=u'maxNumOfPLMNClient', mode=MODE_VALUE)
    maxNumOfPLMNClient._val = 5
    
    #-----< Ext-ExternalClientList >-----#
    Ext_ExternalClientList = SEQ_OF(name=u'Ext-ExternalClientList', mode=MODE_TYPE)
    _Ext_ExternalClientList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ExternalClient')))
    Ext_ExternalClientList._cont = _Ext_ExternalClientList__item_
    Ext_ExternalClientList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=35)], ev=None, er=[])
    
    #-----< maxNumOfExt-ExternalClient >-----#
    maxNumOfExt_ExternalClient = INT(name=u'maxNumOfExt-ExternalClient', mode=MODE_VALUE)
    maxNumOfExt_ExternalClient._val = 35
    
    #-----< ExternalClient >-----#
    ExternalClient = SEQ(name=u'ExternalClient', mode=MODE_TYPE)
    _ExternalClient_clientIdentity = SEQ(name=u'clientIdentity', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSClientExternalID')))
    _ExternalClient_gmlc_Restriction = ENUM(name=u'gmlc-Restriction', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GMLC-Restriction')), opt=True)
    _ExternalClient_notificationToMSUser = ENUM(name=u'notificationToMSUser', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'NotificationToMSUser')), opt=True)
    _ExternalClient_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ExternalClient._cont = ASN1Dict([
        (u'clientIdentity', _ExternalClient_clientIdentity),
        (u'gmlc-Restriction', _ExternalClient_gmlc_Restriction),
        (u'notificationToMSUser', _ExternalClient_notificationToMSUser),
        (u'extensionContainer', _ExternalClient_extensionContainer),
        ])
    ExternalClient._ext = []
    
    #-----< GMLC-Restriction >-----#
    GMLC_Restriction = ENUM(name=u'GMLC-Restriction', mode=MODE_TYPE)
    GMLC_Restriction._cont = ASN1Dict([(u'gmlc-List', 0), (u'home-Country', 1)])
    GMLC_Restriction._ext = []
    
    #-----< NotificationToMSUser >-----#
    NotificationToMSUser = ENUM(name=u'NotificationToMSUser', mode=MODE_TYPE)
    NotificationToMSUser._cont = ASN1Dict([(u'notifyLocationAllowed', 0), (u'notifyAndVerify-LocationAllowedIfNoResponse', 1), (u'notifyAndVerify-LocationNotAllowedIfNoResponse', 2), (u'locationNotAllowed', 3)])
    NotificationToMSUser._ext = [u'locationNotAllowed']
    
    #-----< ServiceTypeList >-----#
    ServiceTypeList = SEQ_OF(name=u'ServiceTypeList', mode=MODE_TYPE)
    _ServiceTypeList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServiceType')))
    ServiceTypeList._cont = _ServiceTypeList__item_
    ServiceTypeList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< maxNumOfServiceType >-----#
    maxNumOfServiceType = INT(name=u'maxNumOfServiceType', mode=MODE_VALUE)
    maxNumOfServiceType._val = 32
    
    #-----< ServiceType >-----#
    ServiceType = SEQ(name=u'ServiceType', mode=MODE_TYPE)
    _ServiceType_serviceTypeIdentity = INT(name=u'serviceTypeIdentity', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LCSServiceTypeID')))
    _ServiceType_gmlc_Restriction = ENUM(name=u'gmlc-Restriction', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GMLC-Restriction')), opt=True)
    _ServiceType_notificationToMSUser = ENUM(name=u'notificationToMSUser', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'NotificationToMSUser')), opt=True)
    _ServiceType_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ServiceType._cont = ASN1Dict([
        (u'serviceTypeIdentity', _ServiceType_serviceTypeIdentity),
        (u'gmlc-Restriction', _ServiceType_gmlc_Restriction),
        (u'notificationToMSUser', _ServiceType_notificationToMSUser),
        (u'extensionContainer', _ServiceType_extensionContainer),
        ])
    ServiceType._ext = []
    
    #-----< MOLR-List >-----#
    MOLR_List = SEQ_OF(name=u'MOLR-List', mode=MODE_TYPE)
    _MOLR_List__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'MOLR-Class')))
    MOLR_List._cont = _MOLR_List__item_
    MOLR_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< maxNumOfMOLR-Class >-----#
    maxNumOfMOLR_Class = INT(name=u'maxNumOfMOLR-Class', mode=MODE_VALUE)
    maxNumOfMOLR_Class._val = 3
    
    #-----< MOLR-Class >-----#
    MOLR_Class = SEQ(name=u'MOLR-Class', mode=MODE_TYPE)
    _MOLR_Class_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _MOLR_Class_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    _MOLR_Class_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    MOLR_Class._cont = ASN1Dict([
        (u'ss-Code', _MOLR_Class_ss_Code),
        (u'ss-Status', _MOLR_Class_ss_Status),
        (u'extensionContainer', _MOLR_Class_extensionContainer),
        ])
    MOLR_Class._ext = []
    
    #-----< ZoneCodeList >-----#
    ZoneCodeList = SEQ_OF(name=u'ZoneCodeList', mode=MODE_TYPE)
    _ZoneCodeList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ZoneCode')))
    ZoneCodeList._cont = _ZoneCodeList__item_
    ZoneCodeList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< ZoneCode >-----#
    ZoneCode = OCT_STR(name=u'ZoneCode', mode=MODE_TYPE)
    ZoneCode._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< maxNumOfZoneCodes >-----#
    maxNumOfZoneCodes = INT(name=u'maxNumOfZoneCodes', mode=MODE_VALUE)
    maxNumOfZoneCodes._val = 10
    
    #-----< InsertSubscriberDataRes >-----#
    InsertSubscriberDataRes = SEQ(name=u'InsertSubscriberDataRes', mode=MODE_TYPE)
    _InsertSubscriberDataRes_teleserviceList = SEQ_OF(name=u'teleserviceList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'TeleserviceList')), opt=True)
    _InsertSubscriberDataRes_bearerServiceList = SEQ_OF(name=u'bearerServiceList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BearerServiceList')), opt=True)
    _InsertSubscriberDataRes_ss_List = SEQ_OF(name=u'ss-List', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-List')), opt=True)
    _InsertSubscriberDataRes_odb_GeneralData = BIT_STR(name=u'odb-GeneralData', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ODB-GeneralData')), opt=True)
    _InsertSubscriberDataRes_regionalSubscriptionResponse = ENUM(name=u'regionalSubscriptionResponse', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RegionalSubscriptionResponse')), opt=True)
    _InsertSubscriberDataRes_supportedCamelPhases = BIT_STR(name=u'supportedCamelPhases', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCamelPhases')), opt=True)
    _InsertSubscriberDataRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _InsertSubscriberDataRes_offeredCamel4CSIs = BIT_STR(name=u'offeredCamel4CSIs', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'OfferedCamel4CSIs')), opt=True)
    _InsertSubscriberDataRes_supportedFeatures = BIT_STR(name=u'supportedFeatures', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedFeatures')), opt=True)
    InsertSubscriberDataRes._cont = ASN1Dict([
        (u'teleserviceList', _InsertSubscriberDataRes_teleserviceList),
        (u'bearerServiceList', _InsertSubscriberDataRes_bearerServiceList),
        (u'ss-List', _InsertSubscriberDataRes_ss_List),
        (u'odb-GeneralData', _InsertSubscriberDataRes_odb_GeneralData),
        (u'regionalSubscriptionResponse', _InsertSubscriberDataRes_regionalSubscriptionResponse),
        (u'supportedCamelPhases', _InsertSubscriberDataRes_supportedCamelPhases),
        (u'extensionContainer', _InsertSubscriberDataRes_extensionContainer),
        (u'offeredCamel4CSIs', _InsertSubscriberDataRes_offeredCamel4CSIs),
        (u'supportedFeatures', _InsertSubscriberDataRes_supportedFeatures),
        ])
    InsertSubscriberDataRes._ext = [u'offeredCamel4CSIs', u'supportedFeatures']
    
    #-----< RegionalSubscriptionResponse >-----#
    RegionalSubscriptionResponse = ENUM(name=u'RegionalSubscriptionResponse', mode=MODE_TYPE)
    RegionalSubscriptionResponse._cont = ASN1Dict([(u'networkNode-AreaRestricted', 0), (u'tooManyZoneCodes', 1), (u'zoneCodesConflict', 2), (u'regionalSubscNotSupported', 3)])
    RegionalSubscriptionResponse._ext = None
    
    #-----< DeleteSubscriberDataArg >-----#
    DeleteSubscriberDataArg = SEQ(name=u'DeleteSubscriberDataArg', mode=MODE_TYPE)
    _DeleteSubscriberDataArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _DeleteSubscriberDataArg_basicServiceList = SEQ_OF(name=u'basicServiceList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BasicServiceList')), opt=True)
    _DeleteSubscriberDataArg_ss_List = SEQ_OF(name=u'ss-List', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-List')), opt=True)
    _DeleteSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature = NULL(name=u'roamingRestrictionDueToUnsupportedFeature', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_regionalSubscriptionIdentifier = OCT_STR(name=u'regionalSubscriptionIdentifier', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ZoneCode')), opt=True)
    _DeleteSubscriberDataArg_vbsGroupIndication = NULL(name=u'vbsGroupIndication', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_vgcsGroupIndication = NULL(name=u'vgcsGroupIndication', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_camelSubscriptionInfoWithdraw = NULL(name=u'camelSubscriptionInfoWithdraw', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _DeleteSubscriberDataArg_gprsSubscriptionDataWithdraw = CHOICE(name=u'gprsSubscriptionDataWithdraw', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GPRSSubscriptionDataWithdraw')), opt=True)
    _DeleteSubscriberDataArg_roamingRestrictedInSgsnDueToUnsuppportedFeature = NULL(name=u'roamingRestrictedInSgsnDueToUnsuppportedFeature', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_lsaInformationWithdraw = CHOICE(name=u'lsaInformationWithdraw', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAInformationWithdraw')), opt=True)
    _DeleteSubscriberDataArg_gmlc_ListWithdraw = NULL(name=u'gmlc-ListWithdraw', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_istInformationWithdraw = NULL(name=u'istInformationWithdraw', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_specificCSI_Withdraw = BIT_STR(name=u'specificCSI-Withdraw', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SpecificCSI-Withdraw')), opt=True)
    _DeleteSubscriberDataArg_chargingCharacteristicsWithdraw = NULL(name=u'chargingCharacteristicsWithdraw', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_stn_srWithdraw = NULL(name=u'stn-srWithdraw', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_epsSubscriptionDataWithdraw = CHOICE(name=u'epsSubscriptionDataWithdraw', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EPS-SubscriptionDataWithdraw')), opt=True)
    _DeleteSubscriberDataArg_apn_oi_replacementWithdraw = NULL(name=u'apn-oi-replacementWithdraw', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_csg_SubscriptionDeleted = NULL(name=u'csg-SubscriptionDeleted', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_subscribedPeriodicTAU_RAU_TimerWithdraw = NULL(name=u'subscribedPeriodicTAU-RAU-TimerWithdraw', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_subscribedPeriodicLAU_TimerWithdraw = NULL(name=u'subscribedPeriodicLAU-TimerWithdraw', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_subscribed_vsrvccWithdraw = NULL(name=u'subscribed-vsrvccWithdraw', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_vplmn_Csg_SubscriptionDeleted = NULL(name=u'vplmn-Csg-SubscriptionDeleted', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_additionalMSISDN_Withdraw = NULL(name=u'additionalMSISDN-Withdraw', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_cs_to_ps_SRVCC_Withdraw = NULL(name=u'cs-to-ps-SRVCC-Withdraw', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_imsiGroupIdList_Withdraw = NULL(name=u'imsiGroupIdList-Withdraw', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _DeleteSubscriberDataArg_userPlaneIntegrityProtectionWithdraw = NULL(name=u'userPlaneIntegrityProtectionWithdraw', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    DeleteSubscriberDataArg._cont = ASN1Dict([
        (u'imsi', _DeleteSubscriberDataArg_imsi),
        (u'basicServiceList', _DeleteSubscriberDataArg_basicServiceList),
        (u'ss-List', _DeleteSubscriberDataArg_ss_List),
        (u'roamingRestrictionDueToUnsupportedFeature', _DeleteSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature),
        (u'regionalSubscriptionIdentifier', _DeleteSubscriberDataArg_regionalSubscriptionIdentifier),
        (u'vbsGroupIndication', _DeleteSubscriberDataArg_vbsGroupIndication),
        (u'vgcsGroupIndication', _DeleteSubscriberDataArg_vgcsGroupIndication),
        (u'camelSubscriptionInfoWithdraw', _DeleteSubscriberDataArg_camelSubscriptionInfoWithdraw),
        (u'extensionContainer', _DeleteSubscriberDataArg_extensionContainer),
        (u'gprsSubscriptionDataWithdraw', _DeleteSubscriberDataArg_gprsSubscriptionDataWithdraw),
        (u'roamingRestrictedInSgsnDueToUnsuppportedFeature', _DeleteSubscriberDataArg_roamingRestrictedInSgsnDueToUnsuppportedFeature),
        (u'lsaInformationWithdraw', _DeleteSubscriberDataArg_lsaInformationWithdraw),
        (u'gmlc-ListWithdraw', _DeleteSubscriberDataArg_gmlc_ListWithdraw),
        (u'istInformationWithdraw', _DeleteSubscriberDataArg_istInformationWithdraw),
        (u'specificCSI-Withdraw', _DeleteSubscriberDataArg_specificCSI_Withdraw),
        (u'chargingCharacteristicsWithdraw', _DeleteSubscriberDataArg_chargingCharacteristicsWithdraw),
        (u'stn-srWithdraw', _DeleteSubscriberDataArg_stn_srWithdraw),
        (u'epsSubscriptionDataWithdraw', _DeleteSubscriberDataArg_epsSubscriptionDataWithdraw),
        (u'apn-oi-replacementWithdraw', _DeleteSubscriberDataArg_apn_oi_replacementWithdraw),
        (u'csg-SubscriptionDeleted', _DeleteSubscriberDataArg_csg_SubscriptionDeleted),
        (u'subscribedPeriodicTAU-RAU-TimerWithdraw', _DeleteSubscriberDataArg_subscribedPeriodicTAU_RAU_TimerWithdraw),
        (u'subscribedPeriodicLAU-TimerWithdraw', _DeleteSubscriberDataArg_subscribedPeriodicLAU_TimerWithdraw),
        (u'subscribed-vsrvccWithdraw', _DeleteSubscriberDataArg_subscribed_vsrvccWithdraw),
        (u'vplmn-Csg-SubscriptionDeleted', _DeleteSubscriberDataArg_vplmn_Csg_SubscriptionDeleted),
        (u'additionalMSISDN-Withdraw', _DeleteSubscriberDataArg_additionalMSISDN_Withdraw),
        (u'cs-to-ps-SRVCC-Withdraw', _DeleteSubscriberDataArg_cs_to_ps_SRVCC_Withdraw),
        (u'imsiGroupIdList-Withdraw', _DeleteSubscriberDataArg_imsiGroupIdList_Withdraw),
        (u'userPlaneIntegrityProtectionWithdraw', _DeleteSubscriberDataArg_userPlaneIntegrityProtectionWithdraw),
        ])
    DeleteSubscriberDataArg._ext = [u'gprsSubscriptionDataWithdraw', u'roamingRestrictedInSgsnDueToUnsuppportedFeature', u'lsaInformationWithdraw', u'gmlc-ListWithdraw', u'istInformationWithdraw', u'specificCSI-Withdraw', u'chargingCharacteristicsWithdraw', u'stn-srWithdraw', u'epsSubscriptionDataWithdraw', u'apn-oi-replacementWithdraw', u'csg-SubscriptionDeleted', u'subscribedPeriodicTAU-RAU-TimerWithdraw', u'subscribedPeriodicLAU-TimerWithdraw', u'subscribed-vsrvccWithdraw', u'vplmn-Csg-SubscriptionDeleted', u'additionalMSISDN-Withdraw', u'cs-to-ps-SRVCC-Withdraw', u'imsiGroupIdList-Withdraw', u'userPlaneIntegrityProtectionWithdraw']
    
    #-----< SpecificCSI-Withdraw >-----#
    SpecificCSI_Withdraw = BIT_STR(name=u'SpecificCSI-Withdraw', mode=MODE_TYPE)
    SpecificCSI_Withdraw._cont = ASN1Dict([(u'o-csi', 0), (u'ss-csi', 1), (u'tif-csi', 2), (u'd-csi', 3), (u'vt-csi', 4), (u'mo-sms-csi', 5), (u'm-csi', 6), (u'gprs-csi', 7), (u't-csi', 8), (u'mt-sms-csi', 9), (u'mg-csi', 10), (u'o-IM-CSI', 11), (u'd-IM-CSI', 12), (u'vt-IM-CSI', 13)])
    SpecificCSI_Withdraw._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=8, ub=32)], ev=None, er=[])
    
    #-----< GPRSSubscriptionDataWithdraw >-----#
    GPRSSubscriptionDataWithdraw = CHOICE(name=u'GPRSSubscriptionDataWithdraw', mode=MODE_TYPE)
    _GPRSSubscriptionDataWithdraw_allGPRSData = NULL(name=u'allGPRSData', mode=MODE_TYPE)
    _GPRSSubscriptionDataWithdraw_contextIdList = SEQ_OF(name=u'contextIdList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ContextIdList')))
    GPRSSubscriptionDataWithdraw._cont = ASN1Dict([
        (u'allGPRSData', _GPRSSubscriptionDataWithdraw_allGPRSData),
        (u'contextIdList', _GPRSSubscriptionDataWithdraw_contextIdList),
        ])
    GPRSSubscriptionDataWithdraw._ext = None
    
    #-----< EPS-SubscriptionDataWithdraw >-----#
    EPS_SubscriptionDataWithdraw = CHOICE(name=u'EPS-SubscriptionDataWithdraw', mode=MODE_TYPE)
    _EPS_SubscriptionDataWithdraw_allEPS_Data = NULL(name=u'allEPS-Data', mode=MODE_TYPE)
    _EPS_SubscriptionDataWithdraw_contextIdList = SEQ_OF(name=u'contextIdList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ContextIdList')))
    EPS_SubscriptionDataWithdraw._cont = ASN1Dict([
        (u'allEPS-Data', _EPS_SubscriptionDataWithdraw_allEPS_Data),
        (u'contextIdList', _EPS_SubscriptionDataWithdraw_contextIdList),
        ])
    EPS_SubscriptionDataWithdraw._ext = None
    
    #-----< ContextIdList >-----#
    ContextIdList = SEQ_OF(name=u'ContextIdList', mode=MODE_TYPE)
    _ContextIdList__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ContextId')))
    ContextIdList._cont = _ContextIdList__item_
    ContextIdList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< LSAInformationWithdraw >-----#
    LSAInformationWithdraw = CHOICE(name=u'LSAInformationWithdraw', mode=MODE_TYPE)
    _LSAInformationWithdraw_allLSAData = NULL(name=u'allLSAData', mode=MODE_TYPE)
    _LSAInformationWithdraw_lsaIdentityList = SEQ_OF(name=u'lsaIdentityList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAIdentityList')))
    LSAInformationWithdraw._cont = ASN1Dict([
        (u'allLSAData', _LSAInformationWithdraw_allLSAData),
        (u'lsaIdentityList', _LSAInformationWithdraw_lsaIdentityList),
        ])
    LSAInformationWithdraw._ext = None
    
    #-----< LSAIdentityList >-----#
    LSAIdentityList = SEQ_OF(name=u'LSAIdentityList', mode=MODE_TYPE)
    _LSAIdentityList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAIdentity')))
    LSAIdentityList._cont = _LSAIdentityList__item_
    LSAIdentityList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    
    #-----< BasicServiceList >-----#
    BasicServiceList = SEQ_OF(name=u'BasicServiceList', mode=MODE_TYPE)
    _BasicServiceList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')))
    BasicServiceList._cont = _BasicServiceList__item_
    BasicServiceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=70)], ev=None, er=[])
    
    #-----< maxNumOfBasicServices >-----#
    maxNumOfBasicServices = INT(name=u'maxNumOfBasicServices', mode=MODE_VALUE)
    maxNumOfBasicServices._val = 70
    
    #-----< DeleteSubscriberDataRes >-----#
    DeleteSubscriberDataRes = SEQ(name=u'DeleteSubscriberDataRes', mode=MODE_TYPE)
    _DeleteSubscriberDataRes_regionalSubscriptionResponse = ENUM(name=u'regionalSubscriptionResponse', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RegionalSubscriptionResponse')), opt=True)
    _DeleteSubscriberDataRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    DeleteSubscriberDataRes._cont = ASN1Dict([
        (u'regionalSubscriptionResponse', _DeleteSubscriberDataRes_regionalSubscriptionResponse),
        (u'extensionContainer', _DeleteSubscriberDataRes_extensionContainer),
        ])
    DeleteSubscriberDataRes._ext = []
    
    #-----< VlrCamelSubscriptionInfo >-----#
    VlrCamelSubscriptionInfo = SEQ(name=u'VlrCamelSubscriptionInfo', mode=MODE_TYPE)
    _VlrCamelSubscriptionInfo_o_CSI = SEQ(name=u'o-CSI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-CSI')), opt=True)
    _VlrCamelSubscriptionInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _VlrCamelSubscriptionInfo_ss_CSI = SEQ(name=u'ss-CSI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SS-CSI')), opt=True)
    _VlrCamelSubscriptionInfo_o_BcsmCamelTDP_CriteriaList = SEQ_OF(name=u'o-BcsmCamelTDP-CriteriaList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-BcsmCamelTDPCriteriaList')), opt=True)
    _VlrCamelSubscriptionInfo_tif_CSI = NULL(name=u'tif-CSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _VlrCamelSubscriptionInfo_m_CSI = SEQ(name=u'm-CSI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'M-CSI')), opt=True)
    _VlrCamelSubscriptionInfo_mo_sms_CSI = SEQ(name=u'mo-sms-CSI', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMS-CSI')), opt=True)
    _VlrCamelSubscriptionInfo_vt_CSI = SEQ(name=u'vt-CSI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-CSI')), opt=True)
    _VlrCamelSubscriptionInfo_t_BCSM_CAMEL_TDP_CriteriaList = SEQ_OF(name=u't-BCSM-CAMEL-TDP-CriteriaList', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-BCSM-CAMEL-TDP-CriteriaList')), opt=True)
    _VlrCamelSubscriptionInfo_d_CSI = SEQ(name=u'd-CSI', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'D-CSI')), opt=True)
    _VlrCamelSubscriptionInfo_mt_sms_CSI = SEQ(name=u'mt-sms-CSI', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMS-CSI')), opt=True)
    _VlrCamelSubscriptionInfo_mt_smsCAMELTDP_CriteriaList = SEQ_OF(name=u'mt-smsCAMELTDP-CriteriaList', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MT-smsCAMELTDP-CriteriaList')), opt=True)
    VlrCamelSubscriptionInfo._cont = ASN1Dict([
        (u'o-CSI', _VlrCamelSubscriptionInfo_o_CSI),
        (u'extensionContainer', _VlrCamelSubscriptionInfo_extensionContainer),
        (u'ss-CSI', _VlrCamelSubscriptionInfo_ss_CSI),
        (u'o-BcsmCamelTDP-CriteriaList', _VlrCamelSubscriptionInfo_o_BcsmCamelTDP_CriteriaList),
        (u'tif-CSI', _VlrCamelSubscriptionInfo_tif_CSI),
        (u'm-CSI', _VlrCamelSubscriptionInfo_m_CSI),
        (u'mo-sms-CSI', _VlrCamelSubscriptionInfo_mo_sms_CSI),
        (u'vt-CSI', _VlrCamelSubscriptionInfo_vt_CSI),
        (u't-BCSM-CAMEL-TDP-CriteriaList', _VlrCamelSubscriptionInfo_t_BCSM_CAMEL_TDP_CriteriaList),
        (u'd-CSI', _VlrCamelSubscriptionInfo_d_CSI),
        (u'mt-sms-CSI', _VlrCamelSubscriptionInfo_mt_sms_CSI),
        (u'mt-smsCAMELTDP-CriteriaList', _VlrCamelSubscriptionInfo_mt_smsCAMELTDP_CriteriaList),
        ])
    VlrCamelSubscriptionInfo._ext = [u'ss-CSI', u'o-BcsmCamelTDP-CriteriaList', u'tif-CSI', u'm-CSI', u'mo-sms-CSI', u'vt-CSI', u't-BCSM-CAMEL-TDP-CriteriaList', u'd-CSI', u'mt-sms-CSI', u'mt-smsCAMELTDP-CriteriaList']
    
    #-----< MT-smsCAMELTDP-CriteriaList >-----#
    MT_smsCAMELTDP_CriteriaList = SEQ_OF(name=u'MT-smsCAMELTDP-CriteriaList', mode=MODE_TYPE)
    _MT_smsCAMELTDP_CriteriaList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'MT-smsCAMELTDP-Criteria')))
    MT_smsCAMELTDP_CriteriaList._cont = _MT_smsCAMELTDP_CriteriaList__item_
    MT_smsCAMELTDP_CriteriaList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< MT-smsCAMELTDP-Criteria >-----#
    MT_smsCAMELTDP_Criteria = SEQ(name=u'MT-smsCAMELTDP-Criteria', mode=MODE_TYPE)
    _MT_smsCAMELTDP_Criteria_sms_TriggerDetectionPoint = ENUM(name=u'sms-TriggerDetectionPoint', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMS-TriggerDetectionPoint')))
    _MT_smsCAMELTDP_Criteria_tpdu_TypeCriterion = SEQ_OF(name=u'tpdu-TypeCriterion', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'TPDU-TypeCriterion')), opt=True)
    MT_smsCAMELTDP_Criteria._cont = ASN1Dict([
        (u'sms-TriggerDetectionPoint', _MT_smsCAMELTDP_Criteria_sms_TriggerDetectionPoint),
        (u'tpdu-TypeCriterion', _MT_smsCAMELTDP_Criteria_tpdu_TypeCriterion),
        ])
    MT_smsCAMELTDP_Criteria._ext = []
    
    #-----< TPDU-TypeCriterion >-----#
    TPDU_TypeCriterion = SEQ_OF(name=u'TPDU-TypeCriterion', mode=MODE_TYPE)
    _TPDU_TypeCriterion__item_ = ENUM(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'MT-SMS-TPDU-Type')))
    TPDU_TypeCriterion._cont = _TPDU_TypeCriterion__item_
    TPDU_TypeCriterion._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< maxNumOfTPDUTypes >-----#
    maxNumOfTPDUTypes = INT(name=u'maxNumOfTPDUTypes', mode=MODE_VALUE)
    maxNumOfTPDUTypes._val = 5
    
    #-----< MT-SMS-TPDU-Type >-----#
    MT_SMS_TPDU_Type = ENUM(name=u'MT-SMS-TPDU-Type', mode=MODE_TYPE)
    MT_SMS_TPDU_Type._cont = ASN1Dict([(u'sms-DELIVER', 0), (u'sms-SUBMIT-REPORT', 1), (u'sms-STATUS-REPORT', 2)])
    MT_SMS_TPDU_Type._ext = []
    
    #-----< D-CSI >-----#
    D_CSI = SEQ(name=u'D-CSI', mode=MODE_TYPE)
    _D_CSI_dp_AnalysedInfoCriteriaList = SEQ_OF(name=u'dp-AnalysedInfoCriteriaList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'DP-AnalysedInfoCriteriaList')), opt=True)
    _D_CSI_camelCapabilityHandling = INT(name=u'camelCapabilityHandling', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CamelCapabilityHandling')), opt=True)
    _D_CSI_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _D_CSI_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _D_CSI_csi_Active = NULL(name=u'csi-Active', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    D_CSI._cont = ASN1Dict([
        (u'dp-AnalysedInfoCriteriaList', _D_CSI_dp_AnalysedInfoCriteriaList),
        (u'camelCapabilityHandling', _D_CSI_camelCapabilityHandling),
        (u'extensionContainer', _D_CSI_extensionContainer),
        (u'notificationToCSE', _D_CSI_notificationToCSE),
        (u'csi-Active', _D_CSI_csi_Active),
        ])
    D_CSI._ext = []
    
    #-----< DP-AnalysedInfoCriteriaList >-----#
    DP_AnalysedInfoCriteriaList = SEQ_OF(name=u'DP-AnalysedInfoCriteriaList', mode=MODE_TYPE)
    _DP_AnalysedInfoCriteriaList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'DP-AnalysedInfoCriterium')))
    DP_AnalysedInfoCriteriaList._cont = _DP_AnalysedInfoCriteriaList__item_
    DP_AnalysedInfoCriteriaList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< maxNumOfDP-AnalysedInfoCriteria >-----#
    maxNumOfDP_AnalysedInfoCriteria = INT(name=u'maxNumOfDP-AnalysedInfoCriteria', mode=MODE_VALUE)
    maxNumOfDP_AnalysedInfoCriteria._val = 10
    
    #-----< DP-AnalysedInfoCriterium >-----#
    DP_AnalysedInfoCriterium = SEQ(name=u'DP-AnalysedInfoCriterium', mode=MODE_TYPE)
    _DP_AnalysedInfoCriterium_dialledNumber = OCT_STR(name=u'dialledNumber', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _DP_AnalysedInfoCriterium_serviceKey = INT(name=u'serviceKey', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServiceKey')))
    _DP_AnalysedInfoCriterium_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _DP_AnalysedInfoCriterium_defaultCallHandling = ENUM(name=u'defaultCallHandling', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'DefaultCallHandling')))
    _DP_AnalysedInfoCriterium_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    DP_AnalysedInfoCriterium._cont = ASN1Dict([
        (u'dialledNumber', _DP_AnalysedInfoCriterium_dialledNumber),
        (u'serviceKey', _DP_AnalysedInfoCriterium_serviceKey),
        (u'gsmSCF-Address', _DP_AnalysedInfoCriterium_gsmSCF_Address),
        (u'defaultCallHandling', _DP_AnalysedInfoCriterium_defaultCallHandling),
        (u'extensionContainer', _DP_AnalysedInfoCriterium_extensionContainer),
        ])
    DP_AnalysedInfoCriterium._ext = []
    
    #-----< SS-CSI >-----#
    SS_CSI = SEQ(name=u'SS-CSI', mode=MODE_TYPE)
    _SS_CSI_ss_CamelData = SEQ(name=u'ss-CamelData', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'SS-CamelData')))
    _SS_CSI_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SS_CSI_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SS_CSI_csi_Active = NULL(name=u'csi-Active', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    SS_CSI._cont = ASN1Dict([
        (u'ss-CamelData', _SS_CSI_ss_CamelData),
        (u'extensionContainer', _SS_CSI_extensionContainer),
        (u'notificationToCSE', _SS_CSI_notificationToCSE),
        (u'csi-Active', _SS_CSI_csi_Active),
        ])
    SS_CSI._ext = [u'notificationToCSE', u'csi-Active']
    
    #-----< SS-CamelData >-----#
    SS_CamelData = SEQ(name=u'SS-CamelData', mode=MODE_TYPE)
    _SS_CamelData_ss_EventList = SEQ_OF(name=u'ss-EventList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'SS-EventList')))
    _SS_CamelData_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _SS_CamelData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SS_CamelData._cont = ASN1Dict([
        (u'ss-EventList', _SS_CamelData_ss_EventList),
        (u'gsmSCF-Address', _SS_CamelData_gsmSCF_Address),
        (u'extensionContainer', _SS_CamelData_extensionContainer),
        ])
    SS_CamelData._ext = []
    
    #-----< SS-EventList >-----#
    SS_EventList = SEQ_OF(name=u'SS-EventList', mode=MODE_TYPE)
    _SS_EventList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    SS_EventList._cont = _SS_EventList__item_
    SS_EventList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< maxNumOfCamelSSEvents >-----#
    maxNumOfCamelSSEvents = INT(name=u'maxNumOfCamelSSEvents', mode=MODE_VALUE)
    maxNumOfCamelSSEvents._val = 10
    
    #-----< O-CSI >-----#
    O_CSI = SEQ(name=u'O-CSI', mode=MODE_TYPE)
    _O_CSI_o_BcsmCamelTDPDataList = SEQ_OF(name=u'o-BcsmCamelTDPDataList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-BcsmCamelTDPDataList')))
    _O_CSI_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _O_CSI_camelCapabilityHandling = INT(name=u'camelCapabilityHandling', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CamelCapabilityHandling')), opt=True)
    _O_CSI_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _O_CSI_csiActive = NULL(name=u'csiActive', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    O_CSI._cont = ASN1Dict([
        (u'o-BcsmCamelTDPDataList', _O_CSI_o_BcsmCamelTDPDataList),
        (u'extensionContainer', _O_CSI_extensionContainer),
        (u'camelCapabilityHandling', _O_CSI_camelCapabilityHandling),
        (u'notificationToCSE', _O_CSI_notificationToCSE),
        (u'csiActive', _O_CSI_csiActive),
        ])
    O_CSI._ext = [u'camelCapabilityHandling', u'notificationToCSE', u'csiActive']
    
    #-----< O-BcsmCamelTDPDataList >-----#
    O_BcsmCamelTDPDataList = SEQ_OF(name=u'O-BcsmCamelTDPDataList', mode=MODE_TYPE)
    _O_BcsmCamelTDPDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-BcsmCamelTDPData')))
    O_BcsmCamelTDPDataList._cont = _O_BcsmCamelTDPDataList__item_
    O_BcsmCamelTDPDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< maxNumOfCamelTDPData >-----#
    maxNumOfCamelTDPData = INT(name=u'maxNumOfCamelTDPData', mode=MODE_VALUE)
    maxNumOfCamelTDPData._val = 10
    
    #-----< O-BcsmCamelTDPData >-----#
    O_BcsmCamelTDPData = SEQ(name=u'O-BcsmCamelTDPData', mode=MODE_TYPE)
    _O_BcsmCamelTDPData_o_BcsmTriggerDetectionPoint = ENUM(name=u'o-BcsmTriggerDetectionPoint', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-BcsmTriggerDetectionPoint')))
    _O_BcsmCamelTDPData_serviceKey = INT(name=u'serviceKey', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServiceKey')))
    _O_BcsmCamelTDPData_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _O_BcsmCamelTDPData_defaultCallHandling = ENUM(name=u'defaultCallHandling', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'DefaultCallHandling')))
    _O_BcsmCamelTDPData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    O_BcsmCamelTDPData._cont = ASN1Dict([
        (u'o-BcsmTriggerDetectionPoint', _O_BcsmCamelTDPData_o_BcsmTriggerDetectionPoint),
        (u'serviceKey', _O_BcsmCamelTDPData_serviceKey),
        (u'gsmSCF-Address', _O_BcsmCamelTDPData_gsmSCF_Address),
        (u'defaultCallHandling', _O_BcsmCamelTDPData_defaultCallHandling),
        (u'extensionContainer', _O_BcsmCamelTDPData_extensionContainer),
        ])
    O_BcsmCamelTDPData._ext = []
    
    #-----< ServiceKey >-----#
    ServiceKey = INT(name=u'ServiceKey', mode=MODE_TYPE)
    ServiceKey._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2147483647)], ev=None, er=[])
    
    #-----< O-BcsmTriggerDetectionPoint >-----#
    O_BcsmTriggerDetectionPoint = ENUM(name=u'O-BcsmTriggerDetectionPoint', mode=MODE_TYPE)
    O_BcsmTriggerDetectionPoint._cont = ASN1Dict([(u'collectedInfo', 2), (u'routeSelectFailure', 4)])
    O_BcsmTriggerDetectionPoint._ext = [u'routeSelectFailure']
    
    #-----< O-BcsmCamelTDPCriteriaList >-----#
    O_BcsmCamelTDPCriteriaList = SEQ_OF(name=u'O-BcsmCamelTDPCriteriaList', mode=MODE_TYPE)
    _O_BcsmCamelTDPCriteriaList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-BcsmCamelTDP-Criteria')))
    O_BcsmCamelTDPCriteriaList._cont = _O_BcsmCamelTDPCriteriaList__item_
    O_BcsmCamelTDPCriteriaList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< T-BCSM-CAMEL-TDP-CriteriaList >-----#
    T_BCSM_CAMEL_TDP_CriteriaList = SEQ_OF(name=u'T-BCSM-CAMEL-TDP-CriteriaList', mode=MODE_TYPE)
    _T_BCSM_CAMEL_TDP_CriteriaList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-BCSM-CAMEL-TDP-Criteria')))
    T_BCSM_CAMEL_TDP_CriteriaList._cont = _T_BCSM_CAMEL_TDP_CriteriaList__item_
    T_BCSM_CAMEL_TDP_CriteriaList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< O-BcsmCamelTDP-Criteria >-----#
    O_BcsmCamelTDP_Criteria = SEQ(name=u'O-BcsmCamelTDP-Criteria', mode=MODE_TYPE)
    _O_BcsmCamelTDP_Criteria_o_BcsmTriggerDetectionPoint = ENUM(name=u'o-BcsmTriggerDetectionPoint', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-BcsmTriggerDetectionPoint')))
    _O_BcsmCamelTDP_Criteria_destinationNumberCriteria = SEQ(name=u'destinationNumberCriteria', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'DestinationNumberCriteria')), opt=True)
    _O_BcsmCamelTDP_Criteria_basicServiceCriteria = SEQ_OF(name=u'basicServiceCriteria', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BasicServiceCriteria')), opt=True)
    _O_BcsmCamelTDP_Criteria_callTypeCriteria = ENUM(name=u'callTypeCriteria', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CallTypeCriteria')), opt=True)
    _O_BcsmCamelTDP_Criteria_o_CauseValueCriteria = SEQ_OF(name=u'o-CauseValueCriteria', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-CauseValueCriteria')), opt=True)
    _O_BcsmCamelTDP_Criteria_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    O_BcsmCamelTDP_Criteria._cont = ASN1Dict([
        (u'o-BcsmTriggerDetectionPoint', _O_BcsmCamelTDP_Criteria_o_BcsmTriggerDetectionPoint),
        (u'destinationNumberCriteria', _O_BcsmCamelTDP_Criteria_destinationNumberCriteria),
        (u'basicServiceCriteria', _O_BcsmCamelTDP_Criteria_basicServiceCriteria),
        (u'callTypeCriteria', _O_BcsmCamelTDP_Criteria_callTypeCriteria),
        (u'o-CauseValueCriteria', _O_BcsmCamelTDP_Criteria_o_CauseValueCriteria),
        (u'extensionContainer', _O_BcsmCamelTDP_Criteria_extensionContainer),
        ])
    O_BcsmCamelTDP_Criteria._ext = [u'o-CauseValueCriteria', u'extensionContainer']
    
    #-----< T-BCSM-CAMEL-TDP-Criteria >-----#
    T_BCSM_CAMEL_TDP_Criteria = SEQ(name=u'T-BCSM-CAMEL-TDP-Criteria', mode=MODE_TYPE)
    _T_BCSM_CAMEL_TDP_Criteria_t_BCSM_TriggerDetectionPoint = ENUM(name=u't-BCSM-TriggerDetectionPoint', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-BcsmTriggerDetectionPoint')))
    _T_BCSM_CAMEL_TDP_Criteria_basicServiceCriteria = SEQ_OF(name=u'basicServiceCriteria', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BasicServiceCriteria')), opt=True)
    _T_BCSM_CAMEL_TDP_Criteria_t_CauseValueCriteria = SEQ_OF(name=u't-CauseValueCriteria', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-CauseValueCriteria')), opt=True)
    T_BCSM_CAMEL_TDP_Criteria._cont = ASN1Dict([
        (u't-BCSM-TriggerDetectionPoint', _T_BCSM_CAMEL_TDP_Criteria_t_BCSM_TriggerDetectionPoint),
        (u'basicServiceCriteria', _T_BCSM_CAMEL_TDP_Criteria_basicServiceCriteria),
        (u't-CauseValueCriteria', _T_BCSM_CAMEL_TDP_Criteria_t_CauseValueCriteria),
        ])
    T_BCSM_CAMEL_TDP_Criteria._ext = []
    
    #-----< DestinationNumberCriteria >-----#
    DestinationNumberCriteria = SEQ(name=u'DestinationNumberCriteria', mode=MODE_TYPE)
    _DestinationNumberCriteria_matchType = ENUM(name=u'matchType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MatchType')))
    _DestinationNumberCriteria_destinationNumberList = SEQ_OF(name=u'destinationNumberList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'DestinationNumberList')), opt=True)
    _DestinationNumberCriteria_destinationNumberLengthList = SEQ_OF(name=u'destinationNumberLengthList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'DestinationNumberLengthList')), opt=True)
    DestinationNumberCriteria._cont = ASN1Dict([
        (u'matchType', _DestinationNumberCriteria_matchType),
        (u'destinationNumberList', _DestinationNumberCriteria_destinationNumberList),
        (u'destinationNumberLengthList', _DestinationNumberCriteria_destinationNumberLengthList),
        ])
    DestinationNumberCriteria._ext = []
    
    #-----< DestinationNumberList >-----#
    DestinationNumberList = SEQ_OF(name=u'DestinationNumberList', mode=MODE_TYPE)
    _DestinationNumberList__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    DestinationNumberList._cont = _DestinationNumberList__item_
    DestinationNumberList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< DestinationNumberLengthList >-----#
    DestinationNumberLengthList = SEQ_OF(name=u'DestinationNumberLengthList', mode=MODE_TYPE)
    _DestinationNumberLengthList__item_ = INT(name='_item_', mode=MODE_TYPE)
    _DestinationNumberLengthList__item_._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=15)], ev=None, er=[])
    DestinationNumberLengthList._cont = _DestinationNumberLengthList__item_
    DestinationNumberLengthList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    
    #-----< BasicServiceCriteria >-----#
    BasicServiceCriteria = SEQ_OF(name=u'BasicServiceCriteria', mode=MODE_TYPE)
    _BasicServiceCriteria__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')))
    BasicServiceCriteria._cont = _BasicServiceCriteria__item_
    BasicServiceCriteria._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< maxNumOfISDN-AddressDigits >-----#
    maxNumOfISDN_AddressDigits = INT(name=u'maxNumOfISDN-AddressDigits', mode=MODE_VALUE)
    maxNumOfISDN_AddressDigits._val = 15
    
    #-----< maxNumOfCamelDestinationNumbers >-----#
    maxNumOfCamelDestinationNumbers = INT(name=u'maxNumOfCamelDestinationNumbers', mode=MODE_VALUE)
    maxNumOfCamelDestinationNumbers._val = 10
    
    #-----< maxNumOfCamelDestinationNumberLengths >-----#
    maxNumOfCamelDestinationNumberLengths = INT(name=u'maxNumOfCamelDestinationNumberLengths', mode=MODE_VALUE)
    maxNumOfCamelDestinationNumberLengths._val = 3
    
    #-----< maxNumOfCamelBasicServiceCriteria >-----#
    maxNumOfCamelBasicServiceCriteria = INT(name=u'maxNumOfCamelBasicServiceCriteria', mode=MODE_VALUE)
    maxNumOfCamelBasicServiceCriteria._val = 5
    
    #-----< CallTypeCriteria >-----#
    CallTypeCriteria = ENUM(name=u'CallTypeCriteria', mode=MODE_TYPE)
    CallTypeCriteria._cont = ASN1Dict([(u'forwarded', 0), (u'notForwarded', 1)])
    CallTypeCriteria._ext = None
    
    #-----< MatchType >-----#
    MatchType = ENUM(name=u'MatchType', mode=MODE_TYPE)
    MatchType._cont = ASN1Dict([(u'inhibiting', 0), (u'enabling', 1)])
    MatchType._ext = None
    
    #-----< O-CauseValueCriteria >-----#
    O_CauseValueCriteria = SEQ_OF(name=u'O-CauseValueCriteria', mode=MODE_TYPE)
    _O_CauseValueCriteria__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CauseValue')))
    O_CauseValueCriteria._cont = _O_CauseValueCriteria__item_
    O_CauseValueCriteria._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< T-CauseValueCriteria >-----#
    T_CauseValueCriteria = SEQ_OF(name=u'T-CauseValueCriteria', mode=MODE_TYPE)
    _T_CauseValueCriteria__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CauseValue')))
    T_CauseValueCriteria._cont = _T_CauseValueCriteria__item_
    T_CauseValueCriteria._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< maxNumOfCAMEL-O-CauseValueCriteria >-----#
    maxNumOfCAMEL_O_CauseValueCriteria = INT(name=u'maxNumOfCAMEL-O-CauseValueCriteria', mode=MODE_VALUE)
    maxNumOfCAMEL_O_CauseValueCriteria._val = 5
    
    #-----< maxNumOfCAMEL-T-CauseValueCriteria >-----#
    maxNumOfCAMEL_T_CauseValueCriteria = INT(name=u'maxNumOfCAMEL-T-CauseValueCriteria', mode=MODE_VALUE)
    maxNumOfCAMEL_T_CauseValueCriteria._val = 5
    
    #-----< CauseValue >-----#
    CauseValue = OCT_STR(name=u'CauseValue', mode=MODE_TYPE)
    CauseValue._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< DefaultCallHandling >-----#
    DefaultCallHandling = ENUM(name=u'DefaultCallHandling', mode=MODE_TYPE)
    DefaultCallHandling._cont = ASN1Dict([(u'continueCall', 0), (u'releaseCall', 1)])
    DefaultCallHandling._ext = []
    
    #-----< CamelCapabilityHandling >-----#
    CamelCapabilityHandling = INT(name=u'CamelCapabilityHandling', mode=MODE_TYPE)
    CamelCapabilityHandling._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< SupportedCamelPhases >-----#
    SupportedCamelPhases = BIT_STR(name=u'SupportedCamelPhases', mode=MODE_TYPE)
    SupportedCamelPhases._cont = ASN1Dict([(u'phase1', 0), (u'phase2', 1), (u'phase3', 2), (u'phase4', 3)])
    SupportedCamelPhases._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< OfferedCamel4CSIs >-----#
    OfferedCamel4CSIs = BIT_STR(name=u'OfferedCamel4CSIs', mode=MODE_TYPE)
    OfferedCamel4CSIs._cont = ASN1Dict([(u'o-csi', 0), (u'd-csi', 1), (u'vt-csi', 2), (u't-csi', 3), (u'mt-sms-csi', 4), (u'mg-csi', 5), (u'psi-enhancements', 6)])
    OfferedCamel4CSIs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=7, ub=16)], ev=None, er=[])
    
    #-----< OfferedCamel4Functionalities >-----#
    OfferedCamel4Functionalities = BIT_STR(name=u'OfferedCamel4Functionalities', mode=MODE_TYPE)
    OfferedCamel4Functionalities._cont = ASN1Dict([(u'initiateCallAttempt', 0), (u'splitLeg', 1), (u'moveLeg', 2), (u'disconnectLeg', 3), (u'entityReleased', 4), (u'dfc-WithArgument', 5), (u'playTone', 6), (u'dtmf-MidCall', 7), (u'chargingIndicator', 8), (u'alertingDP', 9), (u'locationAtAlerting', 10), (u'changeOfPositionDP', 11), (u'or-Interactions', 12), (u'warningToneEnhancements', 13), (u'cf-Enhancements', 14), (u'subscribedEnhancedDialledServices', 15), (u'servingNetworkEnhancedDialledServices', 16), (u'criteriaForChangeOfPositionDP', 17), (u'serviceChangeDP', 18), (u'collectInformation', 19)])
    OfferedCamel4Functionalities._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=15, ub=64)], ev=None, er=[])
    
    #-----< SMS-CSI >-----#
    SMS_CSI = SEQ(name=u'SMS-CSI', mode=MODE_TYPE)
    _SMS_CSI_sms_CAMEL_TDP_DataList = SEQ_OF(name=u'sms-CAMEL-TDP-DataList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMS-CAMEL-TDP-DataList')), opt=True)
    _SMS_CSI_camelCapabilityHandling = INT(name=u'camelCapabilityHandling', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CamelCapabilityHandling')), opt=True)
    _SMS_CSI_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SMS_CSI_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SMS_CSI_csi_Active = NULL(name=u'csi-Active', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    SMS_CSI._cont = ASN1Dict([
        (u'sms-CAMEL-TDP-DataList', _SMS_CSI_sms_CAMEL_TDP_DataList),
        (u'camelCapabilityHandling', _SMS_CSI_camelCapabilityHandling),
        (u'extensionContainer', _SMS_CSI_extensionContainer),
        (u'notificationToCSE', _SMS_CSI_notificationToCSE),
        (u'csi-Active', _SMS_CSI_csi_Active),
        ])
    SMS_CSI._ext = []
    
    #-----< SMS-CAMEL-TDP-DataList >-----#
    SMS_CAMEL_TDP_DataList = SEQ_OF(name=u'SMS-CAMEL-TDP-DataList', mode=MODE_TYPE)
    _SMS_CAMEL_TDP_DataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMS-CAMEL-TDP-Data')))
    SMS_CAMEL_TDP_DataList._cont = _SMS_CAMEL_TDP_DataList__item_
    SMS_CAMEL_TDP_DataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< SMS-CAMEL-TDP-Data >-----#
    SMS_CAMEL_TDP_Data = SEQ(name=u'SMS-CAMEL-TDP-Data', mode=MODE_TYPE)
    _SMS_CAMEL_TDP_Data_sms_TriggerDetectionPoint = ENUM(name=u'sms-TriggerDetectionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMS-TriggerDetectionPoint')))
    _SMS_CAMEL_TDP_Data_serviceKey = INT(name=u'serviceKey', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServiceKey')))
    _SMS_CAMEL_TDP_Data_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _SMS_CAMEL_TDP_Data_defaultSMS_Handling = ENUM(name=u'defaultSMS-Handling', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'DefaultSMS-Handling')))
    _SMS_CAMEL_TDP_Data_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SMS_CAMEL_TDP_Data._cont = ASN1Dict([
        (u'sms-TriggerDetectionPoint', _SMS_CAMEL_TDP_Data_sms_TriggerDetectionPoint),
        (u'serviceKey', _SMS_CAMEL_TDP_Data_serviceKey),
        (u'gsmSCF-Address', _SMS_CAMEL_TDP_Data_gsmSCF_Address),
        (u'defaultSMS-Handling', _SMS_CAMEL_TDP_Data_defaultSMS_Handling),
        (u'extensionContainer', _SMS_CAMEL_TDP_Data_extensionContainer),
        ])
    SMS_CAMEL_TDP_Data._ext = []
    
    #-----< SMS-TriggerDetectionPoint >-----#
    SMS_TriggerDetectionPoint = ENUM(name=u'SMS-TriggerDetectionPoint', mode=MODE_TYPE)
    SMS_TriggerDetectionPoint._cont = ASN1Dict([(u'sms-CollectedInfo', 1), (u'sms-DeliveryRequest', 2)])
    SMS_TriggerDetectionPoint._ext = [u'sms-DeliveryRequest']
    
    #-----< DefaultSMS-Handling >-----#
    DefaultSMS_Handling = ENUM(name=u'DefaultSMS-Handling', mode=MODE_TYPE)
    DefaultSMS_Handling._cont = ASN1Dict([(u'continueTransaction', 0), (u'releaseTransaction', 1)])
    DefaultSMS_Handling._ext = []
    
    #-----< M-CSI >-----#
    M_CSI = SEQ(name=u'M-CSI', mode=MODE_TYPE)
    _M_CSI_mobilityTriggers = SEQ_OF(name=u'mobilityTriggers', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'MobilityTriggers')))
    _M_CSI_serviceKey = INT(name=u'serviceKey', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServiceKey')))
    _M_CSI_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _M_CSI_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _M_CSI_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _M_CSI_csi_Active = NULL(name=u'csi-Active', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    M_CSI._cont = ASN1Dict([
        (u'mobilityTriggers', _M_CSI_mobilityTriggers),
        (u'serviceKey', _M_CSI_serviceKey),
        (u'gsmSCF-Address', _M_CSI_gsmSCF_Address),
        (u'extensionContainer', _M_CSI_extensionContainer),
        (u'notificationToCSE', _M_CSI_notificationToCSE),
        (u'csi-Active', _M_CSI_csi_Active),
        ])
    M_CSI._ext = []
    
    #-----< MG-CSI >-----#
    MG_CSI = SEQ(name=u'MG-CSI', mode=MODE_TYPE)
    _MG_CSI_mobilityTriggers = SEQ_OF(name=u'mobilityTriggers', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'MobilityTriggers')))
    _MG_CSI_serviceKey = INT(name=u'serviceKey', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServiceKey')))
    _MG_CSI_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _MG_CSI_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _MG_CSI_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MG_CSI_csi_Active = NULL(name=u'csi-Active', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    MG_CSI._cont = ASN1Dict([
        (u'mobilityTriggers', _MG_CSI_mobilityTriggers),
        (u'serviceKey', _MG_CSI_serviceKey),
        (u'gsmSCF-Address', _MG_CSI_gsmSCF_Address),
        (u'extensionContainer', _MG_CSI_extensionContainer),
        (u'notificationToCSE', _MG_CSI_notificationToCSE),
        (u'csi-Active', _MG_CSI_csi_Active),
        ])
    MG_CSI._ext = []
    
    #-----< MobilityTriggers >-----#
    MobilityTriggers = SEQ_OF(name=u'MobilityTriggers', mode=MODE_TYPE)
    _MobilityTriggers__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'MM-Code')))
    MobilityTriggers._cont = _MobilityTriggers__item_
    MobilityTriggers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< maxNumOfMobilityTriggers >-----#
    maxNumOfMobilityTriggers = INT(name=u'maxNumOfMobilityTriggers', mode=MODE_VALUE)
    maxNumOfMobilityTriggers._val = 10
    
    #-----< MM-Code >-----#
    MM_Code = OCT_STR(name=u'MM-Code', mode=MODE_TYPE)
    MM_Code._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< T-CSI >-----#
    T_CSI = SEQ(name=u'T-CSI', mode=MODE_TYPE)
    _T_CSI_t_BcsmCamelTDPDataList = SEQ_OF(name=u't-BcsmCamelTDPDataList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-BcsmCamelTDPDataList')))
    _T_CSI_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _T_CSI_camelCapabilityHandling = INT(name=u'camelCapabilityHandling', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CamelCapabilityHandling')), opt=True)
    _T_CSI_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _T_CSI_csi_Active = NULL(name=u'csi-Active', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    T_CSI._cont = ASN1Dict([
        (u't-BcsmCamelTDPDataList', _T_CSI_t_BcsmCamelTDPDataList),
        (u'extensionContainer', _T_CSI_extensionContainer),
        (u'camelCapabilityHandling', _T_CSI_camelCapabilityHandling),
        (u'notificationToCSE', _T_CSI_notificationToCSE),
        (u'csi-Active', _T_CSI_csi_Active),
        ])
    T_CSI._ext = [u'camelCapabilityHandling', u'notificationToCSE', u'csi-Active']
    
    #-----< T-BcsmCamelTDPDataList >-----#
    T_BcsmCamelTDPDataList = SEQ_OF(name=u'T-BcsmCamelTDPDataList', mode=MODE_TYPE)
    _T_BcsmCamelTDPDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-BcsmCamelTDPData')))
    T_BcsmCamelTDPDataList._cont = _T_BcsmCamelTDPDataList__item_
    T_BcsmCamelTDPDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=10)], ev=None, er=[])
    
    #-----< T-BcsmCamelTDPData >-----#
    T_BcsmCamelTDPData = SEQ(name=u'T-BcsmCamelTDPData', mode=MODE_TYPE)
    _T_BcsmCamelTDPData_t_BcsmTriggerDetectionPoint = ENUM(name=u't-BcsmTriggerDetectionPoint', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-BcsmTriggerDetectionPoint')))
    _T_BcsmCamelTDPData_serviceKey = INT(name=u'serviceKey', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServiceKey')))
    _T_BcsmCamelTDPData_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _T_BcsmCamelTDPData_defaultCallHandling = ENUM(name=u'defaultCallHandling', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'DefaultCallHandling')))
    _T_BcsmCamelTDPData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    T_BcsmCamelTDPData._cont = ASN1Dict([
        (u't-BcsmTriggerDetectionPoint', _T_BcsmCamelTDPData_t_BcsmTriggerDetectionPoint),
        (u'serviceKey', _T_BcsmCamelTDPData_serviceKey),
        (u'gsmSCF-Address', _T_BcsmCamelTDPData_gsmSCF_Address),
        (u'defaultCallHandling', _T_BcsmCamelTDPData_defaultCallHandling),
        (u'extensionContainer', _T_BcsmCamelTDPData_extensionContainer),
        ])
    T_BcsmCamelTDPData._ext = []
    
    #-----< T-BcsmTriggerDetectionPoint >-----#
    T_BcsmTriggerDetectionPoint = ENUM(name=u'T-BcsmTriggerDetectionPoint', mode=MODE_TYPE)
    T_BcsmTriggerDetectionPoint._cont = ASN1Dict([(u'termAttemptAuthorized', 12), (u'tBusy', 13), (u'tNoAnswer', 14)])
    T_BcsmTriggerDetectionPoint._ext = [u'tBusy', u'tNoAnswer']
    
    #-----< SendRoutingInfoForGprsArg >-----#
    SendRoutingInfoForGprsArg = SEQ(name=u'SendRoutingInfoForGprsArg', mode=MODE_TYPE)
    _SendRoutingInfoForGprsArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _SendRoutingInfoForGprsArg_ggsn_Address = OCT_STR(name=u'ggsn-Address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')), opt=True)
    _SendRoutingInfoForGprsArg_ggsn_Number = OCT_STR(name=u'ggsn-Number', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _SendRoutingInfoForGprsArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SendRoutingInfoForGprsArg._cont = ASN1Dict([
        (u'imsi', _SendRoutingInfoForGprsArg_imsi),
        (u'ggsn-Address', _SendRoutingInfoForGprsArg_ggsn_Address),
        (u'ggsn-Number', _SendRoutingInfoForGprsArg_ggsn_Number),
        (u'extensionContainer', _SendRoutingInfoForGprsArg_extensionContainer),
        ])
    SendRoutingInfoForGprsArg._ext = []
    
    #-----< SendRoutingInfoForGprsRes >-----#
    SendRoutingInfoForGprsRes = SEQ(name=u'SendRoutingInfoForGprsRes', mode=MODE_TYPE)
    _SendRoutingInfoForGprsRes_sgsn_Address = OCT_STR(name=u'sgsn-Address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')))
    _SendRoutingInfoForGprsRes_ggsn_Address = OCT_STR(name=u'ggsn-Address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')), opt=True)
    _SendRoutingInfoForGprsRes_mobileNotReachableReason = INT(name=u'mobileNotReachableReason', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ER-DataTypes', 'AbsentSubscriberDiagnosticSM')), opt=True)
    _SendRoutingInfoForGprsRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SendRoutingInfoForGprsRes._cont = ASN1Dict([
        (u'sgsn-Address', _SendRoutingInfoForGprsRes_sgsn_Address),
        (u'ggsn-Address', _SendRoutingInfoForGprsRes_ggsn_Address),
        (u'mobileNotReachableReason', _SendRoutingInfoForGprsRes_mobileNotReachableReason),
        (u'extensionContainer', _SendRoutingInfoForGprsRes_extensionContainer),
        ])
    SendRoutingInfoForGprsRes._ext = []
    
    #-----< FailureReportArg >-----#
    FailureReportArg = SEQ(name=u'FailureReportArg', mode=MODE_TYPE)
    _FailureReportArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _FailureReportArg_ggsn_Number = OCT_STR(name=u'ggsn-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _FailureReportArg_ggsn_Address = OCT_STR(name=u'ggsn-Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')), opt=True)
    _FailureReportArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    FailureReportArg._cont = ASN1Dict([
        (u'imsi', _FailureReportArg_imsi),
        (u'ggsn-Number', _FailureReportArg_ggsn_Number),
        (u'ggsn-Address', _FailureReportArg_ggsn_Address),
        (u'extensionContainer', _FailureReportArg_extensionContainer),
        ])
    FailureReportArg._ext = []
    
    #-----< FailureReportRes >-----#
    FailureReportRes = SEQ(name=u'FailureReportRes', mode=MODE_TYPE)
    _FailureReportRes_ggsn_Address = OCT_STR(name=u'ggsn-Address', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')), opt=True)
    _FailureReportRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    FailureReportRes._cont = ASN1Dict([
        (u'ggsn-Address', _FailureReportRes_ggsn_Address),
        (u'extensionContainer', _FailureReportRes_extensionContainer),
        ])
    FailureReportRes._ext = []
    
    #-----< NoteMsPresentForGprsArg >-----#
    NoteMsPresentForGprsArg = SEQ(name=u'NoteMsPresentForGprsArg', mode=MODE_TYPE)
    _NoteMsPresentForGprsArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _NoteMsPresentForGprsArg_sgsn_Address = OCT_STR(name=u'sgsn-Address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')))
    _NoteMsPresentForGprsArg_ggsn_Address = OCT_STR(name=u'ggsn-Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')), opt=True)
    _NoteMsPresentForGprsArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    NoteMsPresentForGprsArg._cont = ASN1Dict([
        (u'imsi', _NoteMsPresentForGprsArg_imsi),
        (u'sgsn-Address', _NoteMsPresentForGprsArg_sgsn_Address),
        (u'ggsn-Address', _NoteMsPresentForGprsArg_ggsn_Address),
        (u'extensionContainer', _NoteMsPresentForGprsArg_extensionContainer),
        ])
    NoteMsPresentForGprsArg._ext = []
    
    #-----< NoteMsPresentForGprsRes >-----#
    NoteMsPresentForGprsRes = SEQ(name=u'NoteMsPresentForGprsRes', mode=MODE_TYPE)
    _NoteMsPresentForGprsRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    NoteMsPresentForGprsRes._cont = ASN1Dict([
        (u'extensionContainer', _NoteMsPresentForGprsRes_extensionContainer),
        ])
    NoteMsPresentForGprsRes._ext = []
    
    #-----< ResetArg >-----#
    ResetArg = SEQ(name=u'ResetArg', mode=MODE_TYPE)
    _ResetArg_sendingNodenumber = CHOICE(name=u'sendingNodenumber', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'SendingNode-Number')))
    _ResetArg_hlr_List = SEQ_OF(name=u'hlr-List', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'HLR-List')), opt=True)
    _ResetArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ResetArg._cont = ASN1Dict([
        (u'sendingNodenumber', _ResetArg_sendingNodenumber),
        (u'hlr-List', _ResetArg_hlr_List),
        (u'extensionContainer', _ResetArg_extensionContainer),
        ])
    ResetArg._ext = []
    
    #-----< SendingNode-Number >-----#
    SendingNode_Number = CHOICE(name=u'SendingNode-Number', mode=MODE_TYPE)
    _SendingNode_Number_hlr_Number = OCT_STR(name=u'hlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _SendingNode_Number_css_Number = OCT_STR(name=u'css-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    SendingNode_Number._cont = ASN1Dict([
        (u'hlr-Number', _SendingNode_Number_hlr_Number),
        (u'css-Number', _SendingNode_Number_css_Number),
        ])
    SendingNode_Number._ext = None
    
    #-----< RestoreDataArg >-----#
    RestoreDataArg = SEQ(name=u'RestoreDataArg', mode=MODE_TYPE)
    _RestoreDataArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _RestoreDataArg_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LMSI')), opt=True)
    _RestoreDataArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _RestoreDataArg_vlr_Capability = SEQ(name=u'vlr-Capability', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'VLR-Capability')), opt=True)
    _RestoreDataArg_restorationIndicator = NULL(name=u'restorationIndicator', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    RestoreDataArg._cont = ASN1Dict([
        (u'imsi', _RestoreDataArg_imsi),
        (u'lmsi', _RestoreDataArg_lmsi),
        (u'extensionContainer', _RestoreDataArg_extensionContainer),
        (u'vlr-Capability', _RestoreDataArg_vlr_Capability),
        (u'restorationIndicator', _RestoreDataArg_restorationIndicator),
        ])
    RestoreDataArg._ext = [u'vlr-Capability', u'restorationIndicator']
    
    #-----< RestoreDataRes >-----#
    RestoreDataRes = SEQ(name=u'RestoreDataRes', mode=MODE_TYPE)
    _RestoreDataRes_hlr_Number = OCT_STR(name=u'hlr-Number', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _RestoreDataRes_msNotReachable = NULL(name=u'msNotReachable', mode=MODE_TYPE, opt=True)
    _RestoreDataRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    RestoreDataRes._cont = ASN1Dict([
        (u'hlr-Number', _RestoreDataRes_hlr_Number),
        (u'msNotReachable', _RestoreDataRes_msNotReachable),
        (u'extensionContainer', _RestoreDataRes_extensionContainer),
        ])
    RestoreDataRes._ext = []
    
    #-----< VBSDataList >-----#
    VBSDataList = SEQ_OF(name=u'VBSDataList', mode=MODE_TYPE)
    _VBSDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'VoiceBroadcastData')))
    VBSDataList._cont = _VBSDataList__item_
    VBSDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< VGCSDataList >-----#
    VGCSDataList = SEQ_OF(name=u'VGCSDataList', mode=MODE_TYPE)
    _VGCSDataList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'VoiceGroupCallData')))
    VGCSDataList._cont = _VGCSDataList__item_
    VGCSDataList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< maxNumOfVBSGroupIds >-----#
    maxNumOfVBSGroupIds = INT(name=u'maxNumOfVBSGroupIds', mode=MODE_VALUE)
    maxNumOfVBSGroupIds._val = 50
    
    #-----< maxNumOfVGCSGroupIds >-----#
    maxNumOfVGCSGroupIds = INT(name=u'maxNumOfVGCSGroupIds', mode=MODE_VALUE)
    maxNumOfVGCSGroupIds._val = 50
    
    #-----< VoiceGroupCallData >-----#
    VoiceGroupCallData = SEQ(name=u'VoiceGroupCallData', mode=MODE_TYPE)
    _VoiceGroupCallData_groupId = OCT_STR(name=u'groupId', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'GroupId')))
    _VoiceGroupCallData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _VoiceGroupCallData_additionalSubscriptions = BIT_STR(name=u'additionalSubscriptions', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'AdditionalSubscriptions')), opt=True)
    _VoiceGroupCallData_additionalInfo = BIT_STR(name=u'additionalInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AdditionalInfo')), opt=True)
    _VoiceGroupCallData_longGroupId = OCT_STR(name=u'longGroupId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Long-GroupId')), opt=True)
    VoiceGroupCallData._cont = ASN1Dict([
        (u'groupId', _VoiceGroupCallData_groupId),
        (u'extensionContainer', _VoiceGroupCallData_extensionContainer),
        (u'additionalSubscriptions', _VoiceGroupCallData_additionalSubscriptions),
        (u'additionalInfo', _VoiceGroupCallData_additionalInfo),
        (u'longGroupId', _VoiceGroupCallData_longGroupId),
        ])
    VoiceGroupCallData._ext = [u'additionalSubscriptions', u'additionalInfo', u'longGroupId']
    
    #-----< AdditionalInfo >-----#
    AdditionalInfo = BIT_STR(name=u'AdditionalInfo', mode=MODE_TYPE)
    AdditionalInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=136)], ev=None, er=[])
    
    #-----< AdditionalSubscriptions >-----#
    AdditionalSubscriptions = BIT_STR(name=u'AdditionalSubscriptions', mode=MODE_TYPE)
    AdditionalSubscriptions._cont = ASN1Dict([(u'privilegedUplinkRequest', 0), (u'emergencyUplinkRequest', 1), (u'emergencyReset', 2)])
    AdditionalSubscriptions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=8)], ev=None, er=[])
    
    #-----< VoiceBroadcastData >-----#
    VoiceBroadcastData = SEQ(name=u'VoiceBroadcastData', mode=MODE_TYPE)
    _VoiceBroadcastData_groupid = OCT_STR(name=u'groupid', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'GroupId')))
    _VoiceBroadcastData_broadcastInitEntitlement = NULL(name=u'broadcastInitEntitlement', mode=MODE_TYPE, opt=True)
    _VoiceBroadcastData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _VoiceBroadcastData_longGroupId = OCT_STR(name=u'longGroupId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Long-GroupId')), opt=True)
    VoiceBroadcastData._cont = ASN1Dict([
        (u'groupid', _VoiceBroadcastData_groupid),
        (u'broadcastInitEntitlement', _VoiceBroadcastData_broadcastInitEntitlement),
        (u'extensionContainer', _VoiceBroadcastData_extensionContainer),
        (u'longGroupId', _VoiceBroadcastData_longGroupId),
        ])
    VoiceBroadcastData._ext = [u'longGroupId']
    
    #-----< GroupId >-----#
    GroupId = OCT_STR(name=u'GroupId', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'TBCD-STRING')))
    GroupId._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< Long-GroupId >-----#
    Long_GroupId = OCT_STR(name=u'Long-GroupId', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'TBCD-STRING')))
    Long_GroupId._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< ProvideSubscriberInfoArg >-----#
    ProvideSubscriberInfoArg = SEQ(name=u'ProvideSubscriberInfoArg', mode=MODE_TYPE)
    _ProvideSubscriberInfoArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _ProvideSubscriberInfoArg_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LMSI')), opt=True)
    _ProvideSubscriberInfoArg_requestedInfo = SEQ(name=u'requestedInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RequestedInfo')))
    _ProvideSubscriberInfoArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ProvideSubscriberInfoArg_callPriority = INT(name=u'callPriority', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')), opt=True)
    ProvideSubscriberInfoArg._cont = ASN1Dict([
        (u'imsi', _ProvideSubscriberInfoArg_imsi),
        (u'lmsi', _ProvideSubscriberInfoArg_lmsi),
        (u'requestedInfo', _ProvideSubscriberInfoArg_requestedInfo),
        (u'extensionContainer', _ProvideSubscriberInfoArg_extensionContainer),
        (u'callPriority', _ProvideSubscriberInfoArg_callPriority),
        ])
    ProvideSubscriberInfoArg._ext = [u'callPriority']
    
    #-----< ProvideSubscriberInfoRes >-----#
    ProvideSubscriberInfoRes = SEQ(name=u'ProvideSubscriberInfoRes', mode=MODE_TYPE)
    _ProvideSubscriberInfoRes_subscriberInfo = SEQ(name=u'subscriberInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'SubscriberInfo')))
    _ProvideSubscriberInfoRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ProvideSubscriberInfoRes._cont = ASN1Dict([
        (u'subscriberInfo', _ProvideSubscriberInfoRes_subscriberInfo),
        (u'extensionContainer', _ProvideSubscriberInfoRes_extensionContainer),
        ])
    ProvideSubscriberInfoRes._ext = []
    
    #-----< SubscriberInfo >-----#
    SubscriberInfo = SEQ(name=u'SubscriberInfo', mode=MODE_TYPE)
    _SubscriberInfo_locationInformation = SEQ(name=u'locationInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationInformation')), opt=True)
    _SubscriberInfo_subscriberState = CHOICE(name=u'subscriberState', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SubscriberState')), opt=True)
    _SubscriberInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SubscriberInfo_locationInformationGPRS = SEQ(name=u'locationInformationGPRS', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationInformationGPRS')), opt=True)
    _SubscriberInfo_ps_SubscriberState = CHOICE(name=u'ps-SubscriberState', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PS-SubscriberState')), opt=True)
    _SubscriberInfo_imei = OCT_STR(name=u'imei', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMEI')), opt=True)
    _SubscriberInfo_ms_Classmark2 = OCT_STR(name=u'ms-Classmark2', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MS-Classmark2')), opt=True)
    _SubscriberInfo_gprs_MS_Class = SEQ(name=u'gprs-MS-Class', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GPRSMSClass')), opt=True)
    _SubscriberInfo_mnpInfoRes = SEQ(name=u'mnpInfoRes', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MNPInfoRes')), opt=True)
    _SubscriberInfo_imsVoiceOverPS_SessionsIndication = ENUM(name=u'imsVoiceOverPS-SessionsIndication', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'IMS-VoiceOverPS-SessionsInd')), opt=True)
    _SubscriberInfo_lastUE_ActivityTime = OCT_STR(name=u'lastUE-ActivityTime', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Time')), opt=True)
    _SubscriberInfo_lastRAT_Type = ENUM(name=u'lastRAT-Type', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Used-RAT-Type')), opt=True)
    _SubscriberInfo_eps_SubscriberState = CHOICE(name=u'eps-SubscriberState', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PS-SubscriberState')), opt=True)
    _SubscriberInfo_locationInformationEPS = SEQ(name=u'locationInformationEPS', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationInformationEPS')), opt=True)
    _SubscriberInfo_timeZone = OCT_STR(name=u'timeZone', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'TimeZone')), opt=True)
    _SubscriberInfo_daylightSavingTime = ENUM(name=u'daylightSavingTime', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'DaylightSavingTime')), opt=True)
    SubscriberInfo._cont = ASN1Dict([
        (u'locationInformation', _SubscriberInfo_locationInformation),
        (u'subscriberState', _SubscriberInfo_subscriberState),
        (u'extensionContainer', _SubscriberInfo_extensionContainer),
        (u'locationInformationGPRS', _SubscriberInfo_locationInformationGPRS),
        (u'ps-SubscriberState', _SubscriberInfo_ps_SubscriberState),
        (u'imei', _SubscriberInfo_imei),
        (u'ms-Classmark2', _SubscriberInfo_ms_Classmark2),
        (u'gprs-MS-Class', _SubscriberInfo_gprs_MS_Class),
        (u'mnpInfoRes', _SubscriberInfo_mnpInfoRes),
        (u'imsVoiceOverPS-SessionsIndication', _SubscriberInfo_imsVoiceOverPS_SessionsIndication),
        (u'lastUE-ActivityTime', _SubscriberInfo_lastUE_ActivityTime),
        (u'lastRAT-Type', _SubscriberInfo_lastRAT_Type),
        (u'eps-SubscriberState', _SubscriberInfo_eps_SubscriberState),
        (u'locationInformationEPS', _SubscriberInfo_locationInformationEPS),
        (u'timeZone', _SubscriberInfo_timeZone),
        (u'daylightSavingTime', _SubscriberInfo_daylightSavingTime),
        ])
    SubscriberInfo._ext = [u'locationInformationGPRS', u'ps-SubscriberState', u'imei', u'ms-Classmark2', u'gprs-MS-Class', u'mnpInfoRes', u'imsVoiceOverPS-SessionsIndication', u'lastUE-ActivityTime', u'lastRAT-Type', u'eps-SubscriberState', u'locationInformationEPS', u'timeZone', u'daylightSavingTime']
    
    #-----< IMS-VoiceOverPS-SessionsInd >-----#
    IMS_VoiceOverPS_SessionsInd = ENUM(name=u'IMS-VoiceOverPS-SessionsInd', mode=MODE_TYPE)
    IMS_VoiceOverPS_SessionsInd._cont = ASN1Dict([(u'imsVoiceOverPS-SessionsNotSupported', 0), (u'imsVoiceOverPS-SessionsSupported', 1), (u'unknown', 2)])
    IMS_VoiceOverPS_SessionsInd._ext = None
    
    #-----< TimeZone >-----#
    TimeZone = OCT_STR(name=u'TimeZone', mode=MODE_TYPE)
    TimeZone._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=3)], ev=None, er=[])
    
    #-----< DaylightSavingTime >-----#
    DaylightSavingTime = ENUM(name=u'DaylightSavingTime', mode=MODE_TYPE)
    DaylightSavingTime._cont = ASN1Dict([(u'noAdjustment', 0), (u'plusOneHourAdjustment', 1), (u'plusTwoHoursAdjustment', 2)])
    DaylightSavingTime._ext = None
    
    #-----< MNPInfoRes >-----#
    MNPInfoRes = SEQ(name=u'MNPInfoRes', mode=MODE_TYPE)
    _MNPInfoRes_routeingNumber = OCT_STR(name=u'routeingNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RouteingNumber')), opt=True)
    _MNPInfoRes_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    _MNPInfoRes_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _MNPInfoRes_numberPortabilityStatus = ENUM(name=u'numberPortabilityStatus', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'NumberPortabilityStatus')), opt=True)
    _MNPInfoRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    MNPInfoRes._cont = ASN1Dict([
        (u'routeingNumber', _MNPInfoRes_routeingNumber),
        (u'imsi', _MNPInfoRes_imsi),
        (u'msisdn', _MNPInfoRes_msisdn),
        (u'numberPortabilityStatus', _MNPInfoRes_numberPortabilityStatus),
        (u'extensionContainer', _MNPInfoRes_extensionContainer),
        ])
    MNPInfoRes._ext = []
    
    #-----< RouteingNumber >-----#
    RouteingNumber = OCT_STR(name=u'RouteingNumber', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'TBCD-STRING')))
    RouteingNumber._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< NumberPortabilityStatus >-----#
    NumberPortabilityStatus = ENUM(name=u'NumberPortabilityStatus', mode=MODE_TYPE)
    NumberPortabilityStatus._cont = ASN1Dict([(u'notKnownToBePorted', 0), (u'ownNumberPortedOut', 1), (u'foreignNumberPortedToForeignNetwork', 2), (u'ownNumberNotPortedOut', 4), (u'foreignNumberPortedIn', 5)])
    NumberPortabilityStatus._ext = [u'ownNumberNotPortedOut', u'foreignNumberPortedIn']
    
    #-----< MS-Classmark2 >-----#
    MS_Classmark2 = OCT_STR(name=u'MS-Classmark2', mode=MODE_TYPE)
    MS_Classmark2._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< GPRSMSClass >-----#
    GPRSMSClass = SEQ(name=u'GPRSMSClass', mode=MODE_TYPE)
    _GPRSMSClass_mSNetworkCapability = OCT_STR(name=u'mSNetworkCapability', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MSNetworkCapability')))
    _GPRSMSClass_mSRadioAccessCapability = OCT_STR(name=u'mSRadioAccessCapability', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MSRadioAccessCapability')), opt=True)
    GPRSMSClass._cont = ASN1Dict([
        (u'mSNetworkCapability', _GPRSMSClass_mSNetworkCapability),
        (u'mSRadioAccessCapability', _GPRSMSClass_mSRadioAccessCapability),
        ])
    GPRSMSClass._ext = None
    
    #-----< MSNetworkCapability >-----#
    MSNetworkCapability = OCT_STR(name=u'MSNetworkCapability', mode=MODE_TYPE)
    MSNetworkCapability._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< MSRadioAccessCapability >-----#
    MSRadioAccessCapability = OCT_STR(name=u'MSRadioAccessCapability', mode=MODE_TYPE)
    MSRadioAccessCapability._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< RequestedInfo >-----#
    RequestedInfo = SEQ(name=u'RequestedInfo', mode=MODE_TYPE)
    _RequestedInfo_locationInformation = NULL(name=u'locationInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedInfo_subscriberState = NULL(name=u'subscriberState', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _RequestedInfo_currentLocation = NULL(name=u'currentLocation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedInfo_requestedDomain = ENUM(name=u'requestedDomain', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'DomainType')), opt=True)
    _RequestedInfo_imei = NULL(name=u'imei', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedInfo_ms_classmark = NULL(name=u'ms-classmark', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedInfo_mnpRequestedInfo = NULL(name=u'mnpRequestedInfo', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedInfo_locationInformationEPS_Supported = NULL(name=u'locationInformationEPS-Supported', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedInfo_t_adsData = NULL(name=u't-adsData', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedInfo_requestedNodes = BIT_STR(name=u'requestedNodes', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RequestedNodes')), opt=True)
    _RequestedInfo_servingNodeIndication = NULL(name=u'servingNodeIndication', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedInfo_localTimeZoneRequest = NULL(name=u'localTimeZoneRequest', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    RequestedInfo._cont = ASN1Dict([
        (u'locationInformation', _RequestedInfo_locationInformation),
        (u'subscriberState', _RequestedInfo_subscriberState),
        (u'extensionContainer', _RequestedInfo_extensionContainer),
        (u'currentLocation', _RequestedInfo_currentLocation),
        (u'requestedDomain', _RequestedInfo_requestedDomain),
        (u'imei', _RequestedInfo_imei),
        (u'ms-classmark', _RequestedInfo_ms_classmark),
        (u'mnpRequestedInfo', _RequestedInfo_mnpRequestedInfo),
        (u'locationInformationEPS-Supported', _RequestedInfo_locationInformationEPS_Supported),
        (u't-adsData', _RequestedInfo_t_adsData),
        (u'requestedNodes', _RequestedInfo_requestedNodes),
        (u'servingNodeIndication', _RequestedInfo_servingNodeIndication),
        (u'localTimeZoneRequest', _RequestedInfo_localTimeZoneRequest),
        ])
    RequestedInfo._ext = [u'currentLocation', u'requestedDomain', u'imei', u'ms-classmark', u'mnpRequestedInfo', u'locationInformationEPS-Supported', u't-adsData', u'requestedNodes', u'servingNodeIndication', u'localTimeZoneRequest']
    
    #-----< DomainType >-----#
    DomainType = ENUM(name=u'DomainType', mode=MODE_TYPE)
    DomainType._cont = ASN1Dict([(u'cs-Domain', 0), (u'ps-Domain', 1)])
    DomainType._ext = []
    
    #-----< RequestedNodes >-----#
    RequestedNodes = BIT_STR(name=u'RequestedNodes', mode=MODE_TYPE)
    RequestedNodes._cont = ASN1Dict([(u'mme', 0), (u'sgsn', 1)])
    RequestedNodes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< LocationInformation >-----#
    LocationInformation = SEQ(name=u'LocationInformation', mode=MODE_TYPE)
    _LocationInformation_ageOfLocationInformation = INT(name=u'ageOfLocationInformation', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AgeOfLocationInformation')), opt=True)
    _LocationInformation_geographicalInformation = OCT_STR(name=u'geographicalInformation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GeographicalInformation')), opt=True)
    _LocationInformation_vlr_number = OCT_STR(name=u'vlr-number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _LocationInformation_locationNumber = OCT_STR(name=u'locationNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationNumber')), opt=True)
    _LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI = CHOICE(name=u'cellGlobalIdOrServiceAreaIdOrLAI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'CellGlobalIdOrServiceAreaIdOrLAI')), opt=True)
    _LocationInformation_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _LocationInformation_selectedLSA_Id = OCT_STR(name=u'selectedLSA-Id', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAIdentity')), opt=True)
    _LocationInformation_msc_Number = OCT_STR(name=u'msc-Number', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _LocationInformation_geodeticInformation = OCT_STR(name=u'geodeticInformation', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GeodeticInformation')), opt=True)
    _LocationInformation_currentLocationRetrieved = NULL(name=u'currentLocationRetrieved', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _LocationInformation_sai_Present = NULL(name=u'sai-Present', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _LocationInformation_locationInformationEPS = SEQ(name=u'locationInformationEPS', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationInformationEPS')), opt=True)
    _LocationInformation_userCSGInformation = SEQ(name=u'userCSGInformation', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'UserCSGInformation')), opt=True)
    LocationInformation._cont = ASN1Dict([
        (u'ageOfLocationInformation', _LocationInformation_ageOfLocationInformation),
        (u'geographicalInformation', _LocationInformation_geographicalInformation),
        (u'vlr-number', _LocationInformation_vlr_number),
        (u'locationNumber', _LocationInformation_locationNumber),
        (u'cellGlobalIdOrServiceAreaIdOrLAI', _LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI),
        (u'extensionContainer', _LocationInformation_extensionContainer),
        (u'selectedLSA-Id', _LocationInformation_selectedLSA_Id),
        (u'msc-Number', _LocationInformation_msc_Number),
        (u'geodeticInformation', _LocationInformation_geodeticInformation),
        (u'currentLocationRetrieved', _LocationInformation_currentLocationRetrieved),
        (u'sai-Present', _LocationInformation_sai_Present),
        (u'locationInformationEPS', _LocationInformation_locationInformationEPS),
        (u'userCSGInformation', _LocationInformation_userCSGInformation),
        ])
    LocationInformation._ext = [u'selectedLSA-Id', u'msc-Number', u'geodeticInformation', u'currentLocationRetrieved', u'sai-Present', u'locationInformationEPS', u'userCSGInformation']
    
    #-----< LocationInformationEPS >-----#
    LocationInformationEPS = SEQ(name=u'LocationInformationEPS', mode=MODE_TYPE)
    _LocationInformationEPS_e_utranCellGlobalIdentity = OCT_STR(name=u'e-utranCellGlobalIdentity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'E-UTRAN-CGI')), opt=True)
    _LocationInformationEPS_trackingAreaIdentity = OCT_STR(name=u'trackingAreaIdentity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'TA-Id')), opt=True)
    _LocationInformationEPS_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _LocationInformationEPS_geographicalInformation = OCT_STR(name=u'geographicalInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GeographicalInformation')), opt=True)
    _LocationInformationEPS_geodeticInformation = OCT_STR(name=u'geodeticInformation', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GeodeticInformation')), opt=True)
    _LocationInformationEPS_currentLocationRetrieved = NULL(name=u'currentLocationRetrieved', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _LocationInformationEPS_ageOfLocationInformation = INT(name=u'ageOfLocationInformation', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AgeOfLocationInformation')), opt=True)
    _LocationInformationEPS_mme_Name = OCT_STR(name=u'mme-Name', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'DiameterIdentity')), opt=True)
    LocationInformationEPS._cont = ASN1Dict([
        (u'e-utranCellGlobalIdentity', _LocationInformationEPS_e_utranCellGlobalIdentity),
        (u'trackingAreaIdentity', _LocationInformationEPS_trackingAreaIdentity),
        (u'extensionContainer', _LocationInformationEPS_extensionContainer),
        (u'geographicalInformation', _LocationInformationEPS_geographicalInformation),
        (u'geodeticInformation', _LocationInformationEPS_geodeticInformation),
        (u'currentLocationRetrieved', _LocationInformationEPS_currentLocationRetrieved),
        (u'ageOfLocationInformation', _LocationInformationEPS_ageOfLocationInformation),
        (u'mme-Name', _LocationInformationEPS_mme_Name),
        ])
    LocationInformationEPS._ext = [u'mme-Name']
    
    #-----< LocationInformationGPRS >-----#
    LocationInformationGPRS = SEQ(name=u'LocationInformationGPRS', mode=MODE_TYPE)
    _LocationInformationGPRS_cellGlobalIdOrServiceAreaIdOrLAI = CHOICE(name=u'cellGlobalIdOrServiceAreaIdOrLAI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'CellGlobalIdOrServiceAreaIdOrLAI')), opt=True)
    _LocationInformationGPRS_routeingAreaIdentity = OCT_STR(name=u'routeingAreaIdentity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'RAIdentity')), opt=True)
    _LocationInformationGPRS_geographicalInformation = OCT_STR(name=u'geographicalInformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GeographicalInformation')), opt=True)
    _LocationInformationGPRS_sgsn_Number = OCT_STR(name=u'sgsn-Number', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _LocationInformationGPRS_selectedLSAIdentity = OCT_STR(name=u'selectedLSAIdentity', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAIdentity')), opt=True)
    _LocationInformationGPRS_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _LocationInformationGPRS_sai_Present = NULL(name=u'sai-Present', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _LocationInformationGPRS_geodeticInformation = OCT_STR(name=u'geodeticInformation', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GeodeticInformation')), opt=True)
    _LocationInformationGPRS_currentLocationRetrieved = NULL(name=u'currentLocationRetrieved', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _LocationInformationGPRS_ageOfLocationInformation = INT(name=u'ageOfLocationInformation', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AgeOfLocationInformation')), opt=True)
    _LocationInformationGPRS_userCSGInformation = SEQ(name=u'userCSGInformation', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'UserCSGInformation')), opt=True)
    LocationInformationGPRS._cont = ASN1Dict([
        (u'cellGlobalIdOrServiceAreaIdOrLAI', _LocationInformationGPRS_cellGlobalIdOrServiceAreaIdOrLAI),
        (u'routeingAreaIdentity', _LocationInformationGPRS_routeingAreaIdentity),
        (u'geographicalInformation', _LocationInformationGPRS_geographicalInformation),
        (u'sgsn-Number', _LocationInformationGPRS_sgsn_Number),
        (u'selectedLSAIdentity', _LocationInformationGPRS_selectedLSAIdentity),
        (u'extensionContainer', _LocationInformationGPRS_extensionContainer),
        (u'sai-Present', _LocationInformationGPRS_sai_Present),
        (u'geodeticInformation', _LocationInformationGPRS_geodeticInformation),
        (u'currentLocationRetrieved', _LocationInformationGPRS_currentLocationRetrieved),
        (u'ageOfLocationInformation', _LocationInformationGPRS_ageOfLocationInformation),
        (u'userCSGInformation', _LocationInformationGPRS_userCSGInformation),
        ])
    LocationInformationGPRS._ext = [u'sai-Present', u'geodeticInformation', u'currentLocationRetrieved', u'ageOfLocationInformation', u'userCSGInformation']
    
    #-----< UserCSGInformation >-----#
    UserCSGInformation = SEQ(name=u'UserCSGInformation', mode=MODE_TYPE)
    _UserCSGInformation_csg_Id = BIT_STR(name=u'csg-Id', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CSG-Id')))
    _UserCSGInformation_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _UserCSGInformation_accessMode = OCT_STR(name=u'accessMode', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UserCSGInformation_accessMode._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _UserCSGInformation_cmi = OCT_STR(name=u'cmi', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UserCSGInformation_cmi._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    UserCSGInformation._cont = ASN1Dict([
        (u'csg-Id', _UserCSGInformation_csg_Id),
        (u'extensionContainer', _UserCSGInformation_extensionContainer),
        (u'accessMode', _UserCSGInformation_accessMode),
        (u'cmi', _UserCSGInformation_cmi),
        ])
    UserCSGInformation._ext = [u'accessMode', u'cmi']
    
    #-----< GeographicalInformation >-----#
    GeographicalInformation = OCT_STR(name=u'GeographicalInformation', mode=MODE_TYPE)
    GeographicalInformation._const_sz = ASN1Set(rv=[8], rr=[], ev=None, er=[])
    
    #-----< GeodeticInformation >-----#
    GeodeticInformation = OCT_STR(name=u'GeodeticInformation', mode=MODE_TYPE)
    GeodeticInformation._const_sz = ASN1Set(rv=[10], rr=[], ev=None, er=[])
    
    #-----< LocationNumber >-----#
    LocationNumber = OCT_STR(name=u'LocationNumber', mode=MODE_TYPE)
    LocationNumber._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=10)], ev=None, er=[])
    
    #-----< SubscriberState >-----#
    SubscriberState = CHOICE(name=u'SubscriberState', mode=MODE_TYPE)
    _SubscriberState_assumedIdle = NULL(name=u'assumedIdle', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SubscriberState_camelBusy = NULL(name=u'camelBusy', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SubscriberState_netDetNotReachable = ENUM(name=u'netDetNotReachable', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'NotReachableReason')))
    _SubscriberState_notProvidedFromVLR = NULL(name=u'notProvidedFromVLR', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    SubscriberState._cont = ASN1Dict([
        (u'assumedIdle', _SubscriberState_assumedIdle),
        (u'camelBusy', _SubscriberState_camelBusy),
        (u'netDetNotReachable', _SubscriberState_netDetNotReachable),
        (u'notProvidedFromVLR', _SubscriberState_notProvidedFromVLR),
        ])
    SubscriberState._ext = None
    
    #-----< PS-SubscriberState >-----#
    PS_SubscriberState = CHOICE(name=u'PS-SubscriberState', mode=MODE_TYPE)
    _PS_SubscriberState_notProvidedFromSGSNorMME = NULL(name=u'notProvidedFromSGSNorMME', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PS_SubscriberState_ps_Detached = NULL(name=u'ps-Detached', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PS_SubscriberState_ps_AttachedNotReachableForPaging = NULL(name=u'ps-AttachedNotReachableForPaging', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PS_SubscriberState_ps_AttachedReachableForPaging = NULL(name=u'ps-AttachedReachableForPaging', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _PS_SubscriberState_ps_PDP_ActiveNotReachableForPaging = SEQ_OF(name=u'ps-PDP-ActiveNotReachableForPaging', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-ContextInfoList')))
    _PS_SubscriberState_ps_PDP_ActiveReachableForPaging = SEQ_OF(name=u'ps-PDP-ActiveReachableForPaging', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-ContextInfoList')))
    _PS_SubscriberState_netDetNotReachable = ENUM(name=u'netDetNotReachable', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'NotReachableReason')))
    PS_SubscriberState._cont = ASN1Dict([
        (u'notProvidedFromSGSNorMME', _PS_SubscriberState_notProvidedFromSGSNorMME),
        (u'ps-Detached', _PS_SubscriberState_ps_Detached),
        (u'ps-AttachedNotReachableForPaging', _PS_SubscriberState_ps_AttachedNotReachableForPaging),
        (u'ps-AttachedReachableForPaging', _PS_SubscriberState_ps_AttachedReachableForPaging),
        (u'ps-PDP-ActiveNotReachableForPaging', _PS_SubscriberState_ps_PDP_ActiveNotReachableForPaging),
        (u'ps-PDP-ActiveReachableForPaging', _PS_SubscriberState_ps_PDP_ActiveReachableForPaging),
        (u'netDetNotReachable', _PS_SubscriberState_netDetNotReachable),
        ])
    PS_SubscriberState._ext = None
    
    #-----< PDP-ContextInfoList >-----#
    PDP_ContextInfoList = SEQ_OF(name=u'PDP-ContextInfoList', mode=MODE_TYPE)
    _PDP_ContextInfoList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-ContextInfo')))
    PDP_ContextInfoList._cont = _PDP_ContextInfoList__item_
    PDP_ContextInfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< PDP-ContextInfo >-----#
    PDP_ContextInfo = SEQ(name=u'PDP-ContextInfo', mode=MODE_TYPE)
    _PDP_ContextInfo_pdp_ContextIdentifier = INT(name=u'pdp-ContextIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ContextId')))
    _PDP_ContextInfo_pdp_ContextActive = NULL(name=u'pdp-ContextActive', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PDP_ContextInfo_pdp_Type = OCT_STR(name=u'pdp-Type', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Type')))
    _PDP_ContextInfo_pdp_Address = OCT_STR(name=u'pdp-Address', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Address')), opt=True)
    _PDP_ContextInfo_apn_Subscribed = OCT_STR(name=u'apn-Subscribed', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN')), opt=True)
    _PDP_ContextInfo_apn_InUse = OCT_STR(name=u'apn-InUse', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'APN')), opt=True)
    _PDP_ContextInfo_nsapi = INT(name=u'nsapi', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'NSAPI')), opt=True)
    _PDP_ContextInfo_transactionId = OCT_STR(name=u'transactionId', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'TransactionId')), opt=True)
    _PDP_ContextInfo_teid_ForGnAndGp = OCT_STR(name=u'teid-ForGnAndGp', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'TEID')), opt=True)
    _PDP_ContextInfo_teid_ForIu = OCT_STR(name=u'teid-ForIu', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'TEID')), opt=True)
    _PDP_ContextInfo_ggsn_Address = OCT_STR(name=u'ggsn-Address', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')), opt=True)
    _PDP_ContextInfo_qos_Subscribed = OCT_STR(name=u'qos-Subscribed', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_qos_Requested = OCT_STR(name=u'qos-Requested', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_qos_Negotiated = OCT_STR(name=u'qos-Negotiated', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_chargingId = OCT_STR(name=u'chargingId', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GPRSChargingID')), opt=True)
    _PDP_ContextInfo_chargingCharacteristics = OCT_STR(name=u'chargingCharacteristics', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ChargingCharacteristics')), opt=True)
    _PDP_ContextInfo_rnc_Address = OCT_STR(name=u'rnc-Address', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')), opt=True)
    _PDP_ContextInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _PDP_ContextInfo_qos2_Subscribed = OCT_STR(name=u'qos2-Subscribed', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext2-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_qos2_Requested = OCT_STR(name=u'qos2-Requested', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext2-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_qos2_Negotiated = OCT_STR(name=u'qos2-Negotiated', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext2-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_qos3_Subscribed = OCT_STR(name=u'qos3-Subscribed', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext3-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_qos3_Requested = OCT_STR(name=u'qos3-Requested', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext3-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_qos3_Negotiated = OCT_STR(name=u'qos3-Negotiated', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext3-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_qos4_Subscribed = OCT_STR(name=u'qos4-Subscribed', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext4-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_qos4_Requested = OCT_STR(name=u'qos4-Requested', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext4-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_qos4_Negotiated = OCT_STR(name=u'qos4-Negotiated', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext4-QoS-Subscribed')), opt=True)
    _PDP_ContextInfo_ext_pdp_Type = OCT_STR(name=u'ext-pdp-Type', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-PDP-Type')), opt=True)
    _PDP_ContextInfo_ext_pdp_Address = OCT_STR(name=u'ext-pdp-Address', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PDP-Address')), opt=True)
    PDP_ContextInfo._cont = ASN1Dict([
        (u'pdp-ContextIdentifier', _PDP_ContextInfo_pdp_ContextIdentifier),
        (u'pdp-ContextActive', _PDP_ContextInfo_pdp_ContextActive),
        (u'pdp-Type', _PDP_ContextInfo_pdp_Type),
        (u'pdp-Address', _PDP_ContextInfo_pdp_Address),
        (u'apn-Subscribed', _PDP_ContextInfo_apn_Subscribed),
        (u'apn-InUse', _PDP_ContextInfo_apn_InUse),
        (u'nsapi', _PDP_ContextInfo_nsapi),
        (u'transactionId', _PDP_ContextInfo_transactionId),
        (u'teid-ForGnAndGp', _PDP_ContextInfo_teid_ForGnAndGp),
        (u'teid-ForIu', _PDP_ContextInfo_teid_ForIu),
        (u'ggsn-Address', _PDP_ContextInfo_ggsn_Address),
        (u'qos-Subscribed', _PDP_ContextInfo_qos_Subscribed),
        (u'qos-Requested', _PDP_ContextInfo_qos_Requested),
        (u'qos-Negotiated', _PDP_ContextInfo_qos_Negotiated),
        (u'chargingId', _PDP_ContextInfo_chargingId),
        (u'chargingCharacteristics', _PDP_ContextInfo_chargingCharacteristics),
        (u'rnc-Address', _PDP_ContextInfo_rnc_Address),
        (u'extensionContainer', _PDP_ContextInfo_extensionContainer),
        (u'qos2-Subscribed', _PDP_ContextInfo_qos2_Subscribed),
        (u'qos2-Requested', _PDP_ContextInfo_qos2_Requested),
        (u'qos2-Negotiated', _PDP_ContextInfo_qos2_Negotiated),
        (u'qos3-Subscribed', _PDP_ContextInfo_qos3_Subscribed),
        (u'qos3-Requested', _PDP_ContextInfo_qos3_Requested),
        (u'qos3-Negotiated', _PDP_ContextInfo_qos3_Negotiated),
        (u'qos4-Subscribed', _PDP_ContextInfo_qos4_Subscribed),
        (u'qos4-Requested', _PDP_ContextInfo_qos4_Requested),
        (u'qos4-Negotiated', _PDP_ContextInfo_qos4_Negotiated),
        (u'ext-pdp-Type', _PDP_ContextInfo_ext_pdp_Type),
        (u'ext-pdp-Address', _PDP_ContextInfo_ext_pdp_Address),
        ])
    PDP_ContextInfo._ext = [u'qos2-Subscribed', u'qos2-Requested', u'qos2-Negotiated', u'qos3-Subscribed', u'qos3-Requested', u'qos3-Negotiated', u'qos4-Subscribed', u'qos4-Requested', u'qos4-Negotiated', u'ext-pdp-Type', u'ext-pdp-Address']
    
    #-----< NSAPI >-----#
    NSAPI = INT(name=u'NSAPI', mode=MODE_TYPE)
    NSAPI._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=15)], ev=None, er=[])
    
    #-----< TransactionId >-----#
    TransactionId = OCT_STR(name=u'TransactionId', mode=MODE_TYPE)
    TransactionId._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    
    #-----< TEID >-----#
    TEID = OCT_STR(name=u'TEID', mode=MODE_TYPE)
    TEID._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< GPRSChargingID >-----#
    GPRSChargingID = OCT_STR(name=u'GPRSChargingID', mode=MODE_TYPE)
    GPRSChargingID._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< NotReachableReason >-----#
    NotReachableReason = ENUM(name=u'NotReachableReason', mode=MODE_TYPE)
    NotReachableReason._cont = ASN1Dict([(u'msPurged', 0), (u'imsiDetached', 1), (u'restrictedArea', 2), (u'notRegistered', 3)])
    NotReachableReason._ext = None
    
    #-----< AnyTimeInterrogationArg >-----#
    AnyTimeInterrogationArg = SEQ(name=u'AnyTimeInterrogationArg', mode=MODE_TYPE)
    _AnyTimeInterrogationArg_subscriberIdentity = CHOICE(name=u'subscriberIdentity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'SubscriberIdentity')))
    _AnyTimeInterrogationArg_requestedInfo = SEQ(name=u'requestedInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RequestedInfo')))
    _AnyTimeInterrogationArg_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _AnyTimeInterrogationArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    AnyTimeInterrogationArg._cont = ASN1Dict([
        (u'subscriberIdentity', _AnyTimeInterrogationArg_subscriberIdentity),
        (u'requestedInfo', _AnyTimeInterrogationArg_requestedInfo),
        (u'gsmSCF-Address', _AnyTimeInterrogationArg_gsmSCF_Address),
        (u'extensionContainer', _AnyTimeInterrogationArg_extensionContainer),
        ])
    AnyTimeInterrogationArg._ext = []
    
    #-----< AnyTimeInterrogationRes >-----#
    AnyTimeInterrogationRes = SEQ(name=u'AnyTimeInterrogationRes', mode=MODE_TYPE)
    _AnyTimeInterrogationRes_subscriberInfo = SEQ(name=u'subscriberInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'SubscriberInfo')))
    _AnyTimeInterrogationRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    AnyTimeInterrogationRes._cont = ASN1Dict([
        (u'subscriberInfo', _AnyTimeInterrogationRes_subscriberInfo),
        (u'extensionContainer', _AnyTimeInterrogationRes_extensionContainer),
        ])
    AnyTimeInterrogationRes._ext = []
    
    #-----< AnyTimeSubscriptionInterrogationArg >-----#
    AnyTimeSubscriptionInterrogationArg = SEQ(name=u'AnyTimeSubscriptionInterrogationArg', mode=MODE_TYPE)
    _AnyTimeSubscriptionInterrogationArg_subscriberIdentity = CHOICE(name=u'subscriberIdentity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'SubscriberIdentity')))
    _AnyTimeSubscriptionInterrogationArg_requestedSubscriptionInfo = SEQ(name=u'requestedSubscriptionInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RequestedSubscriptionInfo')))
    _AnyTimeSubscriptionInterrogationArg_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _AnyTimeSubscriptionInterrogationArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _AnyTimeSubscriptionInterrogationArg_longFTN_Supported = NULL(name=u'longFTN-Supported', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    AnyTimeSubscriptionInterrogationArg._cont = ASN1Dict([
        (u'subscriberIdentity', _AnyTimeSubscriptionInterrogationArg_subscriberIdentity),
        (u'requestedSubscriptionInfo', _AnyTimeSubscriptionInterrogationArg_requestedSubscriptionInfo),
        (u'gsmSCF-Address', _AnyTimeSubscriptionInterrogationArg_gsmSCF_Address),
        (u'extensionContainer', _AnyTimeSubscriptionInterrogationArg_extensionContainer),
        (u'longFTN-Supported', _AnyTimeSubscriptionInterrogationArg_longFTN_Supported),
        ])
    AnyTimeSubscriptionInterrogationArg._ext = []
    
    #-----< AnyTimeSubscriptionInterrogationRes >-----#
    AnyTimeSubscriptionInterrogationRes = SEQ(name=u'AnyTimeSubscriptionInterrogationRes', mode=MODE_TYPE)
    _AnyTimeSubscriptionInterrogationRes_callForwardingData = SEQ(name=u'callForwardingData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CallForwardingData')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_callBarringData = SEQ(name=u'callBarringData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CallBarringData')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_odb_Info = SEQ(name=u'odb-Info', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ODB-Info')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_camel_SubscriptionInfo = SEQ(name=u'camel-SubscriptionInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CAMEL-SubscriptionInfo')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_supportedVLR_CAMEL_Phases = BIT_STR(name=u'supportedVLR-CAMEL-Phases', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCamelPhases')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_supportedSGSN_CAMEL_Phases = BIT_STR(name=u'supportedSGSN-CAMEL-Phases', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCamelPhases')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_offeredCamel4CSIsInVLR = BIT_STR(name=u'offeredCamel4CSIsInVLR', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'OfferedCamel4CSIs')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_offeredCamel4CSIsInSGSN = BIT_STR(name=u'offeredCamel4CSIsInSGSN', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'OfferedCamel4CSIs')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_msisdn_BS_List = SEQ_OF(name=u'msisdn-BS-List', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MSISDN-BS-List')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_csg_SubscriptionDataList = SEQ_OF(name=u'csg-SubscriptionDataList', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CSG-SubscriptionDataList')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_cw_Data = SEQ(name=u'cw-Data', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CallWaitingData')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_ch_Data = SEQ(name=u'ch-Data', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CallHoldData')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_clip_Data = SEQ(name=u'clip-Data', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ClipData')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_clir_Data = SEQ(name=u'clir-Data', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ClirData')), opt=True)
    _AnyTimeSubscriptionInterrogationRes_ect_data = SEQ(name=u'ect-data', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EctData')), opt=True)
    AnyTimeSubscriptionInterrogationRes._cont = ASN1Dict([
        (u'callForwardingData', _AnyTimeSubscriptionInterrogationRes_callForwardingData),
        (u'callBarringData', _AnyTimeSubscriptionInterrogationRes_callBarringData),
        (u'odb-Info', _AnyTimeSubscriptionInterrogationRes_odb_Info),
        (u'camel-SubscriptionInfo', _AnyTimeSubscriptionInterrogationRes_camel_SubscriptionInfo),
        (u'supportedVLR-CAMEL-Phases', _AnyTimeSubscriptionInterrogationRes_supportedVLR_CAMEL_Phases),
        (u'supportedSGSN-CAMEL-Phases', _AnyTimeSubscriptionInterrogationRes_supportedSGSN_CAMEL_Phases),
        (u'extensionContainer', _AnyTimeSubscriptionInterrogationRes_extensionContainer),
        (u'offeredCamel4CSIsInVLR', _AnyTimeSubscriptionInterrogationRes_offeredCamel4CSIsInVLR),
        (u'offeredCamel4CSIsInSGSN', _AnyTimeSubscriptionInterrogationRes_offeredCamel4CSIsInSGSN),
        (u'msisdn-BS-List', _AnyTimeSubscriptionInterrogationRes_msisdn_BS_List),
        (u'csg-SubscriptionDataList', _AnyTimeSubscriptionInterrogationRes_csg_SubscriptionDataList),
        (u'cw-Data', _AnyTimeSubscriptionInterrogationRes_cw_Data),
        (u'ch-Data', _AnyTimeSubscriptionInterrogationRes_ch_Data),
        (u'clip-Data', _AnyTimeSubscriptionInterrogationRes_clip_Data),
        (u'clir-Data', _AnyTimeSubscriptionInterrogationRes_clir_Data),
        (u'ect-data', _AnyTimeSubscriptionInterrogationRes_ect_data),
        ])
    AnyTimeSubscriptionInterrogationRes._ext = [u'offeredCamel4CSIsInVLR', u'offeredCamel4CSIsInSGSN', u'msisdn-BS-List', u'csg-SubscriptionDataList', u'cw-Data', u'ch-Data', u'clip-Data', u'clir-Data', u'ect-data']
    
    #-----< CallWaitingData >-----#
    CallWaitingData = SEQ(name=u'CallWaitingData', mode=MODE_TYPE)
    _CallWaitingData_cwFeatureList = SEQ_OF(name=u'cwFeatureList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-CwFeatureList')))
    _CallWaitingData_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    CallWaitingData._cont = ASN1Dict([
        (u'cwFeatureList', _CallWaitingData_cwFeatureList),
        (u'notificationToCSE', _CallWaitingData_notificationToCSE),
        ])
    CallWaitingData._ext = []
    
    #-----< Ext-CwFeatureList >-----#
    Ext_CwFeatureList = SEQ_OF(name=u'Ext-CwFeatureList', mode=MODE_TYPE)
    _Ext_CwFeatureList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-CwFeature')))
    Ext_CwFeatureList._cont = _Ext_CwFeatureList__item_
    Ext_CwFeatureList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< Ext-CwFeature >-----#
    Ext_CwFeature = SEQ(name=u'Ext-CwFeature', mode=MODE_TYPE)
    _Ext_CwFeature_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')))
    _Ext_CwFeature_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    Ext_CwFeature._cont = ASN1Dict([
        (u'basicService', _Ext_CwFeature_basicService),
        (u'ss-Status', _Ext_CwFeature_ss_Status),
        ])
    Ext_CwFeature._ext = []
    
    #-----< ClipData >-----#
    ClipData = SEQ(name=u'ClipData', mode=MODE_TYPE)
    _ClipData_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    _ClipData_overrideCategory = ENUM(name=u'overrideCategory', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'OverrideCategory')))
    _ClipData_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ClipData._cont = ASN1Dict([
        (u'ss-Status', _ClipData_ss_Status),
        (u'overrideCategory', _ClipData_overrideCategory),
        (u'notificationToCSE', _ClipData_notificationToCSE),
        ])
    ClipData._ext = []
    
    #-----< ClirData >-----#
    ClirData = SEQ(name=u'ClirData', mode=MODE_TYPE)
    _ClirData_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    _ClirData_cliRestrictionOption = ENUM(name=u'cliRestrictionOption', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CliRestrictionOption')), opt=True)
    _ClirData_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ClirData._cont = ASN1Dict([
        (u'ss-Status', _ClirData_ss_Status),
        (u'cliRestrictionOption', _ClirData_cliRestrictionOption),
        (u'notificationToCSE', _ClirData_notificationToCSE),
        ])
    ClirData._ext = []
    
    #-----< CallHoldData >-----#
    CallHoldData = SEQ(name=u'CallHoldData', mode=MODE_TYPE)
    _CallHoldData_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    _CallHoldData_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    CallHoldData._cont = ASN1Dict([
        (u'ss-Status', _CallHoldData_ss_Status),
        (u'notificationToCSE', _CallHoldData_notificationToCSE),
        ])
    CallHoldData._ext = []
    
    #-----< EctData >-----#
    EctData = SEQ(name=u'EctData', mode=MODE_TYPE)
    _EctData_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')))
    _EctData_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    EctData._cont = ASN1Dict([
        (u'ss-Status', _EctData_ss_Status),
        (u'notificationToCSE', _EctData_notificationToCSE),
        ])
    EctData._ext = []
    
    #-----< RequestedSubscriptionInfo >-----#
    RequestedSubscriptionInfo = SEQ(name=u'RequestedSubscriptionInfo', mode=MODE_TYPE)
    _RequestedSubscriptionInfo_requestedSS_Info = SEQ(name=u'requestedSS-Info', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-ForBS-Code')), opt=True)
    _RequestedSubscriptionInfo_odb = NULL(name=u'odb', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedSubscriptionInfo_requestedCAMEL_SubscriptionInfo = ENUM(name=u'requestedCAMEL-SubscriptionInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RequestedCAMEL-SubscriptionInfo')), opt=True)
    _RequestedSubscriptionInfo_supportedVLR_CAMEL_Phases = NULL(name=u'supportedVLR-CAMEL-Phases', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedSubscriptionInfo_supportedSGSN_CAMEL_Phases = NULL(name=u'supportedSGSN-CAMEL-Phases', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedSubscriptionInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _RequestedSubscriptionInfo_additionalRequestedCAMEL_SubscriptionInfo = ENUM(name=u'additionalRequestedCAMEL-SubscriptionInfo', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AdditionalRequestedCAMEL-SubscriptionInfo')), opt=True)
    _RequestedSubscriptionInfo_msisdn_BS_List = NULL(name=u'msisdn-BS-List', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedSubscriptionInfo_csg_SubscriptionDataRequested = NULL(name=u'csg-SubscriptionDataRequested', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedSubscriptionInfo_cw_Info = NULL(name=u'cw-Info', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedSubscriptionInfo_clip_Info = NULL(name=u'clip-Info', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedSubscriptionInfo_clir_Info = NULL(name=u'clir-Info', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedSubscriptionInfo_hold_Info = NULL(name=u'hold-Info', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RequestedSubscriptionInfo_ect_Info = NULL(name=u'ect-Info', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    RequestedSubscriptionInfo._cont = ASN1Dict([
        (u'requestedSS-Info', _RequestedSubscriptionInfo_requestedSS_Info),
        (u'odb', _RequestedSubscriptionInfo_odb),
        (u'requestedCAMEL-SubscriptionInfo', _RequestedSubscriptionInfo_requestedCAMEL_SubscriptionInfo),
        (u'supportedVLR-CAMEL-Phases', _RequestedSubscriptionInfo_supportedVLR_CAMEL_Phases),
        (u'supportedSGSN-CAMEL-Phases', _RequestedSubscriptionInfo_supportedSGSN_CAMEL_Phases),
        (u'extensionContainer', _RequestedSubscriptionInfo_extensionContainer),
        (u'additionalRequestedCAMEL-SubscriptionInfo', _RequestedSubscriptionInfo_additionalRequestedCAMEL_SubscriptionInfo),
        (u'msisdn-BS-List', _RequestedSubscriptionInfo_msisdn_BS_List),
        (u'csg-SubscriptionDataRequested', _RequestedSubscriptionInfo_csg_SubscriptionDataRequested),
        (u'cw-Info', _RequestedSubscriptionInfo_cw_Info),
        (u'clip-Info', _RequestedSubscriptionInfo_clip_Info),
        (u'clir-Info', _RequestedSubscriptionInfo_clir_Info),
        (u'hold-Info', _RequestedSubscriptionInfo_hold_Info),
        (u'ect-Info', _RequestedSubscriptionInfo_ect_Info),
        ])
    RequestedSubscriptionInfo._ext = [u'additionalRequestedCAMEL-SubscriptionInfo', u'msisdn-BS-List', u'csg-SubscriptionDataRequested', u'cw-Info', u'clip-Info', u'clir-Info', u'hold-Info', u'ect-Info']
    
    #-----< MSISDN-BS-List >-----#
    MSISDN_BS_List = SEQ_OF(name=u'MSISDN-BS-List', mode=MODE_TYPE)
    _MSISDN_BS_List__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'MSISDN-BS')))
    MSISDN_BS_List._cont = _MSISDN_BS_List__item_
    MSISDN_BS_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=50)], ev=None, er=[])
    
    #-----< maxNumOfMSISDN >-----#
    maxNumOfMSISDN = INT(name=u'maxNumOfMSISDN', mode=MODE_VALUE)
    maxNumOfMSISDN._val = 50
    
    #-----< MSISDN-BS >-----#
    MSISDN_BS = SEQ(name=u'MSISDN-BS', mode=MODE_TYPE)
    _MSISDN_BS_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _MSISDN_BS_basicServiceList = SEQ_OF(name=u'basicServiceList', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'BasicServiceList')), opt=True)
    _MSISDN_BS_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    MSISDN_BS._cont = ASN1Dict([
        (u'msisdn', _MSISDN_BS_msisdn),
        (u'basicServiceList', _MSISDN_BS_basicServiceList),
        (u'extensionContainer', _MSISDN_BS_extensionContainer),
        ])
    MSISDN_BS._ext = []
    
    #-----< RequestedCAMEL-SubscriptionInfo >-----#
    RequestedCAMEL_SubscriptionInfo = ENUM(name=u'RequestedCAMEL-SubscriptionInfo', mode=MODE_TYPE)
    RequestedCAMEL_SubscriptionInfo._cont = ASN1Dict([(u'o-CSI', 0), (u't-CSI', 1), (u'vt-CSI', 2), (u'tif-CSI', 3), (u'gprs-CSI', 4), (u'mo-sms-CSI', 5), (u'ss-CSI', 6), (u'm-CSI', 7), (u'd-csi', 8)])
    RequestedCAMEL_SubscriptionInfo._ext = None
    
    #-----< AdditionalRequestedCAMEL-SubscriptionInfo >-----#
    AdditionalRequestedCAMEL_SubscriptionInfo = ENUM(name=u'AdditionalRequestedCAMEL-SubscriptionInfo', mode=MODE_TYPE)
    AdditionalRequestedCAMEL_SubscriptionInfo._cont = ASN1Dict([(u'mt-sms-CSI', 0), (u'mg-csi', 1), (u'o-IM-CSI', 2), (u'd-IM-CSI', 3), (u'vt-IM-CSI', 4)])
    AdditionalRequestedCAMEL_SubscriptionInfo._ext = []
    
    #-----< CallForwardingData >-----#
    CallForwardingData = SEQ(name=u'CallForwardingData', mode=MODE_TYPE)
    _CallForwardingData_forwardingFeatureList = SEQ_OF(name=u'forwardingFeatureList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-ForwFeatureList')))
    _CallForwardingData_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, opt=True)
    _CallForwardingData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CallForwardingData._cont = ASN1Dict([
        (u'forwardingFeatureList', _CallForwardingData_forwardingFeatureList),
        (u'notificationToCSE', _CallForwardingData_notificationToCSE),
        (u'extensionContainer', _CallForwardingData_extensionContainer),
        ])
    CallForwardingData._ext = []
    
    #-----< CallBarringData >-----#
    CallBarringData = SEQ(name=u'CallBarringData', mode=MODE_TYPE)
    _CallBarringData_callBarringFeatureList = SEQ_OF(name=u'callBarringFeatureList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-CallBarFeatureList')))
    _CallBarringData_password = STR_NUM(name=u'password', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'Password')), opt=True)
    _CallBarringData_password._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    _CallBarringData_wrongPasswordAttemptsCounter = INT(name=u'wrongPasswordAttemptsCounter', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'WrongPasswordAttemptsCounter')), opt=True)
    _CallBarringData_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, opt=True)
    _CallBarringData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CallBarringData._cont = ASN1Dict([
        (u'callBarringFeatureList', _CallBarringData_callBarringFeatureList),
        (u'password', _CallBarringData_password),
        (u'wrongPasswordAttemptsCounter', _CallBarringData_wrongPasswordAttemptsCounter),
        (u'notificationToCSE', _CallBarringData_notificationToCSE),
        (u'extensionContainer', _CallBarringData_extensionContainer),
        ])
    CallBarringData._ext = []
    
    #-----< WrongPasswordAttemptsCounter >-----#
    WrongPasswordAttemptsCounter = INT(name=u'WrongPasswordAttemptsCounter', mode=MODE_TYPE)
    WrongPasswordAttemptsCounter._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4)], ev=None, er=[])
    
    #-----< ODB-Info >-----#
    ODB_Info = SEQ(name=u'ODB-Info', mode=MODE_TYPE)
    _ODB_Info_odb_Data = SEQ(name=u'odb-Data', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ODB-Data')))
    _ODB_Info_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, opt=True)
    _ODB_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ODB_Info._cont = ASN1Dict([
        (u'odb-Data', _ODB_Info_odb_Data),
        (u'notificationToCSE', _ODB_Info_notificationToCSE),
        (u'extensionContainer', _ODB_Info_extensionContainer),
        ])
    ODB_Info._ext = []
    
    #-----< CAMEL-SubscriptionInfo >-----#
    CAMEL_SubscriptionInfo = SEQ(name=u'CAMEL-SubscriptionInfo', mode=MODE_TYPE)
    _CAMEL_SubscriptionInfo_o_CSI = SEQ(name=u'o-CSI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_o_BcsmCamelTDP_CriteriaList = SEQ_OF(name=u'o-BcsmCamelTDP-CriteriaList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-BcsmCamelTDPCriteriaList')), opt=True)
    _CAMEL_SubscriptionInfo_d_CSI = SEQ(name=u'd-CSI', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'D-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_t_CSI = SEQ(name=u't-CSI', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_t_BCSM_CAMEL_TDP_CriteriaList = SEQ_OF(name=u't-BCSM-CAMEL-TDP-CriteriaList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-BCSM-CAMEL-TDP-CriteriaList')), opt=True)
    _CAMEL_SubscriptionInfo_vt_CSI = SEQ(name=u'vt-CSI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_vt_BCSM_CAMEL_TDP_CriteriaList = SEQ_OF(name=u'vt-BCSM-CAMEL-TDP-CriteriaList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-BCSM-CAMEL-TDP-CriteriaList')), opt=True)
    _CAMEL_SubscriptionInfo_tif_CSI = NULL(name=u'tif-CSI', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CAMEL_SubscriptionInfo_tif_CSI_NotificationToCSE = NULL(name=u'tif-CSI-NotificationToCSE', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CAMEL_SubscriptionInfo_gprs_CSI = SEQ(name=u'gprs-CSI', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GPRS-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_mo_sms_CSI = SEQ(name=u'mo-sms-CSI', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMS-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_ss_CSI = SEQ(name=u'ss-CSI', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SS-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_m_CSI = SEQ(name=u'm-CSI', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'M-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _CAMEL_SubscriptionInfo_specificCSIDeletedList = BIT_STR(name=u'specificCSIDeletedList', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SpecificCSI-Withdraw')), opt=True)
    _CAMEL_SubscriptionInfo_mt_sms_CSI = SEQ(name=u'mt-sms-CSI', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SMS-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_mt_smsCAMELTDP_CriteriaList = SEQ_OF(name=u'mt-smsCAMELTDP-CriteriaList', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MT-smsCAMELTDP-CriteriaList')), opt=True)
    _CAMEL_SubscriptionInfo_mg_csi = SEQ(name=u'mg-csi', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MG-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_o_IM_CSI = SEQ(name=u'o-IM-CSI', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_o_IM_BcsmCamelTDP_CriteriaList = SEQ_OF(name=u'o-IM-BcsmCamelTDP-CriteriaList', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-BcsmCamelTDPCriteriaList')), opt=True)
    _CAMEL_SubscriptionInfo_d_IM_CSI = SEQ(name=u'd-IM-CSI', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'D-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_vt_IM_CSI = SEQ(name=u'vt-IM-CSI', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-CSI')), opt=True)
    _CAMEL_SubscriptionInfo_vt_IM_BCSM_CAMEL_TDP_CriteriaList = SEQ_OF(name=u'vt-IM-BCSM-CAMEL-TDP-CriteriaList', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-BCSM-CAMEL-TDP-CriteriaList')), opt=True)
    CAMEL_SubscriptionInfo._cont = ASN1Dict([
        (u'o-CSI', _CAMEL_SubscriptionInfo_o_CSI),
        (u'o-BcsmCamelTDP-CriteriaList', _CAMEL_SubscriptionInfo_o_BcsmCamelTDP_CriteriaList),
        (u'd-CSI', _CAMEL_SubscriptionInfo_d_CSI),
        (u't-CSI', _CAMEL_SubscriptionInfo_t_CSI),
        (u't-BCSM-CAMEL-TDP-CriteriaList', _CAMEL_SubscriptionInfo_t_BCSM_CAMEL_TDP_CriteriaList),
        (u'vt-CSI', _CAMEL_SubscriptionInfo_vt_CSI),
        (u'vt-BCSM-CAMEL-TDP-CriteriaList', _CAMEL_SubscriptionInfo_vt_BCSM_CAMEL_TDP_CriteriaList),
        (u'tif-CSI', _CAMEL_SubscriptionInfo_tif_CSI),
        (u'tif-CSI-NotificationToCSE', _CAMEL_SubscriptionInfo_tif_CSI_NotificationToCSE),
        (u'gprs-CSI', _CAMEL_SubscriptionInfo_gprs_CSI),
        (u'mo-sms-CSI', _CAMEL_SubscriptionInfo_mo_sms_CSI),
        (u'ss-CSI', _CAMEL_SubscriptionInfo_ss_CSI),
        (u'm-CSI', _CAMEL_SubscriptionInfo_m_CSI),
        (u'extensionContainer', _CAMEL_SubscriptionInfo_extensionContainer),
        (u'specificCSIDeletedList', _CAMEL_SubscriptionInfo_specificCSIDeletedList),
        (u'mt-sms-CSI', _CAMEL_SubscriptionInfo_mt_sms_CSI),
        (u'mt-smsCAMELTDP-CriteriaList', _CAMEL_SubscriptionInfo_mt_smsCAMELTDP_CriteriaList),
        (u'mg-csi', _CAMEL_SubscriptionInfo_mg_csi),
        (u'o-IM-CSI', _CAMEL_SubscriptionInfo_o_IM_CSI),
        (u'o-IM-BcsmCamelTDP-CriteriaList', _CAMEL_SubscriptionInfo_o_IM_BcsmCamelTDP_CriteriaList),
        (u'd-IM-CSI', _CAMEL_SubscriptionInfo_d_IM_CSI),
        (u'vt-IM-CSI', _CAMEL_SubscriptionInfo_vt_IM_CSI),
        (u'vt-IM-BCSM-CAMEL-TDP-CriteriaList', _CAMEL_SubscriptionInfo_vt_IM_BCSM_CAMEL_TDP_CriteriaList),
        ])
    CAMEL_SubscriptionInfo._ext = [u'specificCSIDeletedList', u'mt-sms-CSI', u'mt-smsCAMELTDP-CriteriaList', u'mg-csi', u'o-IM-CSI', u'o-IM-BcsmCamelTDP-CriteriaList', u'd-IM-CSI', u'vt-IM-CSI', u'vt-IM-BCSM-CAMEL-TDP-CriteriaList']
    
    #-----< AnyTimeModificationArg >-----#
    AnyTimeModificationArg = SEQ(name=u'AnyTimeModificationArg', mode=MODE_TYPE)
    _AnyTimeModificationArg_subscriberIdentity = CHOICE(name=u'subscriberIdentity', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'SubscriberIdentity')))
    _AnyTimeModificationArg_gsmSCF_Address = OCT_STR(name=u'gsmSCF-Address', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _AnyTimeModificationArg_modificationRequestFor_CF_Info = SEQ(name=u'modificationRequestFor-CF-Info', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-CF-Info')), opt=True)
    _AnyTimeModificationArg_modificationRequestFor_CB_Info = SEQ(name=u'modificationRequestFor-CB-Info', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-CB-Info')), opt=True)
    _AnyTimeModificationArg_modificationRequestFor_CSI = SEQ(name=u'modificationRequestFor-CSI', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-CSI')), opt=True)
    _AnyTimeModificationArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _AnyTimeModificationArg_longFTN_Supported = NULL(name=u'longFTN-Supported', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _AnyTimeModificationArg_modificationRequestFor_ODB_data = SEQ(name=u'modificationRequestFor-ODB-data', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-ODB-data')), opt=True)
    _AnyTimeModificationArg_modificationRequestFor_IP_SM_GW_Data = SEQ(name=u'modificationRequestFor-IP-SM-GW-Data', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-IP-SM-GW-Data')), opt=True)
    _AnyTimeModificationArg_activationRequestForUE_reachability = BIT_STR(name=u'activationRequestForUE-reachability', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RequestedServingNode')), opt=True)
    _AnyTimeModificationArg_modificationRequestFor_CSG = SEQ(name=u'modificationRequestFor-CSG', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-CSG')), opt=True)
    _AnyTimeModificationArg_modificationRequestFor_CW_Data = SEQ(name=u'modificationRequestFor-CW-Data', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-CW-Info')), opt=True)
    _AnyTimeModificationArg_modificationRequestFor_CLIP_Data = SEQ(name=u'modificationRequestFor-CLIP-Data', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-CLIP-Info')), opt=True)
    _AnyTimeModificationArg_modificationRequestFor_CLIR_Data = SEQ(name=u'modificationRequestFor-CLIR-Data', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-CLIR-Info')), opt=True)
    _AnyTimeModificationArg_modificationRequestFor_HOLD_Data = SEQ(name=u'modificationRequestFor-HOLD-Data', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-CH-Info')), opt=True)
    _AnyTimeModificationArg_modificationRequestFor_ECT_Data = SEQ(name=u'modificationRequestFor-ECT-Data', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationRequestFor-ECT-Info')), opt=True)
    AnyTimeModificationArg._cont = ASN1Dict([
        (u'subscriberIdentity', _AnyTimeModificationArg_subscriberIdentity),
        (u'gsmSCF-Address', _AnyTimeModificationArg_gsmSCF_Address),
        (u'modificationRequestFor-CF-Info', _AnyTimeModificationArg_modificationRequestFor_CF_Info),
        (u'modificationRequestFor-CB-Info', _AnyTimeModificationArg_modificationRequestFor_CB_Info),
        (u'modificationRequestFor-CSI', _AnyTimeModificationArg_modificationRequestFor_CSI),
        (u'extensionContainer', _AnyTimeModificationArg_extensionContainer),
        (u'longFTN-Supported', _AnyTimeModificationArg_longFTN_Supported),
        (u'modificationRequestFor-ODB-data', _AnyTimeModificationArg_modificationRequestFor_ODB_data),
        (u'modificationRequestFor-IP-SM-GW-Data', _AnyTimeModificationArg_modificationRequestFor_IP_SM_GW_Data),
        (u'activationRequestForUE-reachability', _AnyTimeModificationArg_activationRequestForUE_reachability),
        (u'modificationRequestFor-CSG', _AnyTimeModificationArg_modificationRequestFor_CSG),
        (u'modificationRequestFor-CW-Data', _AnyTimeModificationArg_modificationRequestFor_CW_Data),
        (u'modificationRequestFor-CLIP-Data', _AnyTimeModificationArg_modificationRequestFor_CLIP_Data),
        (u'modificationRequestFor-CLIR-Data', _AnyTimeModificationArg_modificationRequestFor_CLIR_Data),
        (u'modificationRequestFor-HOLD-Data', _AnyTimeModificationArg_modificationRequestFor_HOLD_Data),
        (u'modificationRequestFor-ECT-Data', _AnyTimeModificationArg_modificationRequestFor_ECT_Data),
        ])
    AnyTimeModificationArg._ext = [u'modificationRequestFor-ODB-data', u'modificationRequestFor-IP-SM-GW-Data', u'activationRequestForUE-reachability', u'modificationRequestFor-CSG', u'modificationRequestFor-CW-Data', u'modificationRequestFor-CLIP-Data', u'modificationRequestFor-CLIR-Data', u'modificationRequestFor-HOLD-Data', u'modificationRequestFor-ECT-Data']
    
    #-----< ModificationRequestFor-CW-Info >-----#
    ModificationRequestFor_CW_Info = SEQ(name=u'ModificationRequestFor-CW-Info', mode=MODE_TYPE)
    _ModificationRequestFor_CW_Info_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _ModificationRequestFor_CW_Info_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')), opt=True)
    _ModificationRequestFor_CW_Info_modifyNotificationToCSE = ENUM(name=u'modifyNotificationToCSE', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_CW_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ModificationRequestFor_CW_Info._cont = ASN1Dict([
        (u'basicService', _ModificationRequestFor_CW_Info_basicService),
        (u'ss-Status', _ModificationRequestFor_CW_Info_ss_Status),
        (u'modifyNotificationToCSE', _ModificationRequestFor_CW_Info_modifyNotificationToCSE),
        (u'extensionContainer', _ModificationRequestFor_CW_Info_extensionContainer),
        ])
    ModificationRequestFor_CW_Info._ext = []
    
    #-----< ModificationRequestFor-CH-Info >-----#
    ModificationRequestFor_CH_Info = SEQ(name=u'ModificationRequestFor-CH-Info', mode=MODE_TYPE)
    _ModificationRequestFor_CH_Info_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')), opt=True)
    _ModificationRequestFor_CH_Info_modifyNotificationToCSE = ENUM(name=u'modifyNotificationToCSE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_CH_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ModificationRequestFor_CH_Info._cont = ASN1Dict([
        (u'ss-Status', _ModificationRequestFor_CH_Info_ss_Status),
        (u'modifyNotificationToCSE', _ModificationRequestFor_CH_Info_modifyNotificationToCSE),
        (u'extensionContainer', _ModificationRequestFor_CH_Info_extensionContainer),
        ])
    ModificationRequestFor_CH_Info._ext = []
    
    #-----< ModificationRequestFor-ECT-Info >-----#
    ModificationRequestFor_ECT_Info = SEQ(name=u'ModificationRequestFor-ECT-Info', mode=MODE_TYPE)
    _ModificationRequestFor_ECT_Info_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')), opt=True)
    _ModificationRequestFor_ECT_Info_modifyNotificationToCSE = ENUM(name=u'modifyNotificationToCSE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_ECT_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ModificationRequestFor_ECT_Info._cont = ASN1Dict([
        (u'ss-Status', _ModificationRequestFor_ECT_Info_ss_Status),
        (u'modifyNotificationToCSE', _ModificationRequestFor_ECT_Info_modifyNotificationToCSE),
        (u'extensionContainer', _ModificationRequestFor_ECT_Info_extensionContainer),
        ])
    ModificationRequestFor_ECT_Info._ext = []
    
    #-----< ModificationRequestFor-CLIR-Info >-----#
    ModificationRequestFor_CLIR_Info = SEQ(name=u'ModificationRequestFor-CLIR-Info', mode=MODE_TYPE)
    _ModificationRequestFor_CLIR_Info_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')), opt=True)
    _ModificationRequestFor_CLIR_Info_cliRestrictionOption = ENUM(name=u'cliRestrictionOption', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CliRestrictionOption')), opt=True)
    _ModificationRequestFor_CLIR_Info_modifyNotificationToCSE = ENUM(name=u'modifyNotificationToCSE', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_CLIR_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ModificationRequestFor_CLIR_Info._cont = ASN1Dict([
        (u'ss-Status', _ModificationRequestFor_CLIR_Info_ss_Status),
        (u'cliRestrictionOption', _ModificationRequestFor_CLIR_Info_cliRestrictionOption),
        (u'modifyNotificationToCSE', _ModificationRequestFor_CLIR_Info_modifyNotificationToCSE),
        (u'extensionContainer', _ModificationRequestFor_CLIR_Info_extensionContainer),
        ])
    ModificationRequestFor_CLIR_Info._ext = []
    
    #-----< ModificationRequestFor-CLIP-Info >-----#
    ModificationRequestFor_CLIP_Info = SEQ(name=u'ModificationRequestFor-CLIP-Info', mode=MODE_TYPE)
    _ModificationRequestFor_CLIP_Info_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')), opt=True)
    _ModificationRequestFor_CLIP_Info_overrideCategory = ENUM(name=u'overrideCategory', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'OverrideCategory')), opt=True)
    _ModificationRequestFor_CLIP_Info_modifyNotificationToCSE = ENUM(name=u'modifyNotificationToCSE', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_CLIP_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ModificationRequestFor_CLIP_Info._cont = ASN1Dict([
        (u'ss-Status', _ModificationRequestFor_CLIP_Info_ss_Status),
        (u'overrideCategory', _ModificationRequestFor_CLIP_Info_overrideCategory),
        (u'modifyNotificationToCSE', _ModificationRequestFor_CLIP_Info_modifyNotificationToCSE),
        (u'extensionContainer', _ModificationRequestFor_CLIP_Info_extensionContainer),
        ])
    ModificationRequestFor_CLIP_Info._ext = []
    
    #-----< ModificationRequestFor-CSG >-----#
    ModificationRequestFor_CSG = SEQ(name=u'ModificationRequestFor-CSG', mode=MODE_TYPE)
    _ModificationRequestFor_CSG_modifyNotificationToCSE = ENUM(name=u'modifyNotificationToCSE', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_CSG_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ModificationRequestFor_CSG._cont = ASN1Dict([
        (u'modifyNotificationToCSE', _ModificationRequestFor_CSG_modifyNotificationToCSE),
        (u'extensionContainer', _ModificationRequestFor_CSG_extensionContainer),
        ])
    ModificationRequestFor_CSG._ext = []
    
    #-----< RequestedServingNode >-----#
    RequestedServingNode = BIT_STR(name=u'RequestedServingNode', mode=MODE_TYPE)
    RequestedServingNode._cont = ASN1Dict([(u'mmeAndSgsn', 0)])
    RequestedServingNode._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< ServingNode >-----#
    ServingNode = BIT_STR(name=u'ServingNode', mode=MODE_TYPE)
    ServingNode._cont = ASN1Dict([(u'mme', 0), (u'sgsn', 1)])
    ServingNode._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=8)], ev=None, er=[])
    
    #-----< AnyTimeModificationRes >-----#
    AnyTimeModificationRes = SEQ(name=u'AnyTimeModificationRes', mode=MODE_TYPE)
    _AnyTimeModificationRes_ss_InfoFor_CSE = CHOICE(name=u'ss-InfoFor-CSE', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-SS-InfoFor-CSE')), opt=True)
    _AnyTimeModificationRes_camel_SubscriptionInfo = SEQ(name=u'camel-SubscriptionInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CAMEL-SubscriptionInfo')), opt=True)
    _AnyTimeModificationRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _AnyTimeModificationRes_odb_Info = SEQ(name=u'odb-Info', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ODB-Info')), opt=True)
    _AnyTimeModificationRes_cw_Data = SEQ(name=u'cw-Data', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CallWaitingData')), opt=True)
    _AnyTimeModificationRes_ch_Data = SEQ(name=u'ch-Data', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CallHoldData')), opt=True)
    _AnyTimeModificationRes_clip_Data = SEQ(name=u'clip-Data', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ClipData')), opt=True)
    _AnyTimeModificationRes_clir_Data = SEQ(name=u'clir-Data', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ClirData')), opt=True)
    _AnyTimeModificationRes_ect_data = SEQ(name=u'ect-data', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EctData')), opt=True)
    _AnyTimeModificationRes_serviceCentreAddress = OCT_STR(name=u'serviceCentreAddress', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AddressString')), opt=True)
    AnyTimeModificationRes._cont = ASN1Dict([
        (u'ss-InfoFor-CSE', _AnyTimeModificationRes_ss_InfoFor_CSE),
        (u'camel-SubscriptionInfo', _AnyTimeModificationRes_camel_SubscriptionInfo),
        (u'extensionContainer', _AnyTimeModificationRes_extensionContainer),
        (u'odb-Info', _AnyTimeModificationRes_odb_Info),
        (u'cw-Data', _AnyTimeModificationRes_cw_Data),
        (u'ch-Data', _AnyTimeModificationRes_ch_Data),
        (u'clip-Data', _AnyTimeModificationRes_clip_Data),
        (u'clir-Data', _AnyTimeModificationRes_clir_Data),
        (u'ect-data', _AnyTimeModificationRes_ect_data),
        (u'serviceCentreAddress', _AnyTimeModificationRes_serviceCentreAddress),
        ])
    AnyTimeModificationRes._ext = [u'odb-Info', u'cw-Data', u'ch-Data', u'clip-Data', u'clir-Data', u'ect-data', u'serviceCentreAddress']
    
    #-----< ModificationRequestFor-CF-Info >-----#
    ModificationRequestFor_CF_Info = SEQ(name=u'ModificationRequestFor-CF-Info', mode=MODE_TYPE)
    _ModificationRequestFor_CF_Info_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _ModificationRequestFor_CF_Info_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _ModificationRequestFor_CF_Info_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')), opt=True)
    _ModificationRequestFor_CF_Info_forwardedToNumber = OCT_STR(name=u'forwardedToNumber', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AddressString')), opt=True)
    _ModificationRequestFor_CF_Info_forwardedToSubaddress = OCT_STR(name=u'forwardedToSubaddress', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-SubaddressString')), opt=True)
    _ModificationRequestFor_CF_Info_noReplyConditionTime = INT(name=u'noReplyConditionTime', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-NoRepCondTime')), opt=True)
    _ModificationRequestFor_CF_Info_modifyNotificationToCSE = ENUM(name=u'modifyNotificationToCSE', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_CF_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ModificationRequestFor_CF_Info._cont = ASN1Dict([
        (u'ss-Code', _ModificationRequestFor_CF_Info_ss_Code),
        (u'basicService', _ModificationRequestFor_CF_Info_basicService),
        (u'ss-Status', _ModificationRequestFor_CF_Info_ss_Status),
        (u'forwardedToNumber', _ModificationRequestFor_CF_Info_forwardedToNumber),
        (u'forwardedToSubaddress', _ModificationRequestFor_CF_Info_forwardedToSubaddress),
        (u'noReplyConditionTime', _ModificationRequestFor_CF_Info_noReplyConditionTime),
        (u'modifyNotificationToCSE', _ModificationRequestFor_CF_Info_modifyNotificationToCSE),
        (u'extensionContainer', _ModificationRequestFor_CF_Info_extensionContainer),
        ])
    ModificationRequestFor_CF_Info._ext = []
    
    #-----< ModificationRequestFor-CB-Info >-----#
    ModificationRequestFor_CB_Info = SEQ(name=u'ModificationRequestFor-CB-Info', mode=MODE_TYPE)
    _ModificationRequestFor_CB_Info_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _ModificationRequestFor_CB_Info_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _ModificationRequestFor_CB_Info_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-SS-Status')), opt=True)
    _ModificationRequestFor_CB_Info_password = STR_NUM(name=u'password', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'Password')), opt=True)
    _ModificationRequestFor_CB_Info_password._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    _ModificationRequestFor_CB_Info_wrongPasswordAttemptsCounter = INT(name=u'wrongPasswordAttemptsCounter', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'WrongPasswordAttemptsCounter')), opt=True)
    _ModificationRequestFor_CB_Info_modifyNotificationToCSE = ENUM(name=u'modifyNotificationToCSE', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_CB_Info_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ModificationRequestFor_CB_Info._cont = ASN1Dict([
        (u'ss-Code', _ModificationRequestFor_CB_Info_ss_Code),
        (u'basicService', _ModificationRequestFor_CB_Info_basicService),
        (u'ss-Status', _ModificationRequestFor_CB_Info_ss_Status),
        (u'password', _ModificationRequestFor_CB_Info_password),
        (u'wrongPasswordAttemptsCounter', _ModificationRequestFor_CB_Info_wrongPasswordAttemptsCounter),
        (u'modifyNotificationToCSE', _ModificationRequestFor_CB_Info_modifyNotificationToCSE),
        (u'extensionContainer', _ModificationRequestFor_CB_Info_extensionContainer),
        ])
    ModificationRequestFor_CB_Info._ext = []
    
    #-----< ModificationRequestFor-ODB-data >-----#
    ModificationRequestFor_ODB_data = SEQ(name=u'ModificationRequestFor-ODB-data', mode=MODE_TYPE)
    _ModificationRequestFor_ODB_data_odb_data = SEQ(name=u'odb-data', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ODB-Data')), opt=True)
    _ModificationRequestFor_ODB_data_modifyNotificationToCSE = ENUM(name=u'modifyNotificationToCSE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_ODB_data_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ModificationRequestFor_ODB_data._cont = ASN1Dict([
        (u'odb-data', _ModificationRequestFor_ODB_data_odb_data),
        (u'modifyNotificationToCSE', _ModificationRequestFor_ODB_data_modifyNotificationToCSE),
        (u'extensionContainer', _ModificationRequestFor_ODB_data_extensionContainer),
        ])
    ModificationRequestFor_ODB_data._ext = []
    
    #-----< ModificationRequestFor-CSI >-----#
    ModificationRequestFor_CSI = SEQ(name=u'ModificationRequestFor-CSI', mode=MODE_TYPE)
    _ModificationRequestFor_CSI_requestedCamel_SubscriptionInfo = ENUM(name=u'requestedCamel-SubscriptionInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'RequestedCAMEL-SubscriptionInfo')))
    _ModificationRequestFor_CSI_modifyNotificationToCSE = ENUM(name=u'modifyNotificationToCSE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_CSI_modifyCSI_State = ENUM(name=u'modifyCSI-State', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_CSI_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ModificationRequestFor_CSI_additionalRequestedCAMEL_SubscriptionInfo = ENUM(name=u'additionalRequestedCAMEL-SubscriptionInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'AdditionalRequestedCAMEL-SubscriptionInfo')), opt=True)
    ModificationRequestFor_CSI._cont = ASN1Dict([
        (u'requestedCamel-SubscriptionInfo', _ModificationRequestFor_CSI_requestedCamel_SubscriptionInfo),
        (u'modifyNotificationToCSE', _ModificationRequestFor_CSI_modifyNotificationToCSE),
        (u'modifyCSI-State', _ModificationRequestFor_CSI_modifyCSI_State),
        (u'extensionContainer', _ModificationRequestFor_CSI_extensionContainer),
        (u'additionalRequestedCAMEL-SubscriptionInfo', _ModificationRequestFor_CSI_additionalRequestedCAMEL_SubscriptionInfo),
        ])
    ModificationRequestFor_CSI._ext = [u'additionalRequestedCAMEL-SubscriptionInfo']
    
    #-----< ModificationRequestFor-IP-SM-GW-Data >-----#
    ModificationRequestFor_IP_SM_GW_Data = SEQ(name=u'ModificationRequestFor-IP-SM-GW-Data', mode=MODE_TYPE)
    _ModificationRequestFor_IP_SM_GW_Data_modifyRegistrationStatus = ENUM(name=u'modifyRegistrationStatus', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ModificationInstruction')), opt=True)
    _ModificationRequestFor_IP_SM_GW_Data_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ModificationRequestFor_IP_SM_GW_Data_ip_sm_gw_DiameterAddress = SEQ(name=u'ip-sm-gw-DiameterAddress', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'NetworkNodeDiameterAddress')), opt=True)
    ModificationRequestFor_IP_SM_GW_Data._cont = ASN1Dict([
        (u'modifyRegistrationStatus', _ModificationRequestFor_IP_SM_GW_Data_modifyRegistrationStatus),
        (u'extensionContainer', _ModificationRequestFor_IP_SM_GW_Data_extensionContainer),
        (u'ip-sm-gw-DiameterAddress', _ModificationRequestFor_IP_SM_GW_Data_ip_sm_gw_DiameterAddress),
        ])
    ModificationRequestFor_IP_SM_GW_Data._ext = [u'ip-sm-gw-DiameterAddress']
    
    #-----< ModificationInstruction >-----#
    ModificationInstruction = ENUM(name=u'ModificationInstruction', mode=MODE_TYPE)
    ModificationInstruction._cont = ASN1Dict([(u'deactivate', 0), (u'activate', 1)])
    ModificationInstruction._ext = None
    
    #-----< NoteSubscriberDataModifiedArg >-----#
    NoteSubscriberDataModifiedArg = SEQ(name=u'NoteSubscriberDataModifiedArg', mode=MODE_TYPE)
    _NoteSubscriberDataModifiedArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _NoteSubscriberDataModifiedArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _NoteSubscriberDataModifiedArg_forwardingInfoFor_CSE = SEQ(name=u'forwardingInfoFor-CSE', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-ForwardingInfoFor-CSE')), opt=True)
    _NoteSubscriberDataModifiedArg_callBarringInfoFor_CSE = SEQ(name=u'callBarringInfoFor-CSE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-CallBarringInfoFor-CSE')), opt=True)
    _NoteSubscriberDataModifiedArg_odb_Info = SEQ(name=u'odb-Info', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ODB-Info')), opt=True)
    _NoteSubscriberDataModifiedArg_camel_SubscriptionInfo = SEQ(name=u'camel-SubscriptionInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CAMEL-SubscriptionInfo')), opt=True)
    _NoteSubscriberDataModifiedArg_allInformationSent = NULL(name=u'allInformationSent', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NoteSubscriberDataModifiedArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _NoteSubscriberDataModifiedArg_ue_reachable = BIT_STR(name=u'ue-reachable', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServingNode')), opt=True)
    _NoteSubscriberDataModifiedArg_csg_SubscriptionDataList = SEQ_OF(name=u'csg-SubscriptionDataList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CSG-SubscriptionDataList')), opt=True)
    _NoteSubscriberDataModifiedArg_cw_Data = SEQ(name=u'cw-Data', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CallWaitingData')), opt=True)
    _NoteSubscriberDataModifiedArg_ch_Data = SEQ(name=u'ch-Data', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'CallHoldData')), opt=True)
    _NoteSubscriberDataModifiedArg_clip_Data = SEQ(name=u'clip-Data', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ClipData')), opt=True)
    _NoteSubscriberDataModifiedArg_clir_Data = SEQ(name=u'clir-Data', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'ClirData')), opt=True)
    _NoteSubscriberDataModifiedArg_ect_data = SEQ(name=u'ect-data', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'EctData')), opt=True)
    NoteSubscriberDataModifiedArg._cont = ASN1Dict([
        (u'imsi', _NoteSubscriberDataModifiedArg_imsi),
        (u'msisdn', _NoteSubscriberDataModifiedArg_msisdn),
        (u'forwardingInfoFor-CSE', _NoteSubscriberDataModifiedArg_forwardingInfoFor_CSE),
        (u'callBarringInfoFor-CSE', _NoteSubscriberDataModifiedArg_callBarringInfoFor_CSE),
        (u'odb-Info', _NoteSubscriberDataModifiedArg_odb_Info),
        (u'camel-SubscriptionInfo', _NoteSubscriberDataModifiedArg_camel_SubscriptionInfo),
        (u'allInformationSent', _NoteSubscriberDataModifiedArg_allInformationSent),
        (u'extensionContainer', _NoteSubscriberDataModifiedArg_extensionContainer),
        (u'ue-reachable', _NoteSubscriberDataModifiedArg_ue_reachable),
        (u'csg-SubscriptionDataList', _NoteSubscriberDataModifiedArg_csg_SubscriptionDataList),
        (u'cw-Data', _NoteSubscriberDataModifiedArg_cw_Data),
        (u'ch-Data', _NoteSubscriberDataModifiedArg_ch_Data),
        (u'clip-Data', _NoteSubscriberDataModifiedArg_clip_Data),
        (u'clir-Data', _NoteSubscriberDataModifiedArg_clir_Data),
        (u'ect-data', _NoteSubscriberDataModifiedArg_ect_data),
        ])
    NoteSubscriberDataModifiedArg._ext = [u'ue-reachable', u'csg-SubscriptionDataList', u'cw-Data', u'ch-Data', u'clip-Data', u'clir-Data', u'ect-data']
    
    #-----< NoteSubscriberDataModifiedRes >-----#
    NoteSubscriberDataModifiedRes = SEQ(name=u'NoteSubscriberDataModifiedRes', mode=MODE_TYPE)
    _NoteSubscriberDataModifiedRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    NoteSubscriberDataModifiedRes._cont = ASN1Dict([
        (u'extensionContainer', _NoteSubscriberDataModifiedRes_extensionContainer),
        ])
    NoteSubscriberDataModifiedRes._ext = []
    
    #-----< NoteMM-EventArg >-----#
    NoteMM_EventArg = SEQ(name=u'NoteMM-EventArg', mode=MODE_TYPE)
    _NoteMM_EventArg_serviceKey = INT(name=u'serviceKey', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'ServiceKey')))
    _NoteMM_EventArg_eventMet = OCT_STR(name=u'eventMet', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'MM-Code')))
    _NoteMM_EventArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _NoteMM_EventArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _NoteMM_EventArg_locationInformation = SEQ(name=u'locationInformation', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationInformation')), opt=True)
    _NoteMM_EventArg_supportedCAMELPhases = BIT_STR(name=u'supportedCAMELPhases', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCamelPhases')), opt=True)
    _NoteMM_EventArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _NoteMM_EventArg_locationInformationGPRS = SEQ(name=u'locationInformationGPRS', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LocationInformationGPRS')), opt=True)
    _NoteMM_EventArg_offeredCamel4Functionalities = BIT_STR(name=u'offeredCamel4Functionalities', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'OfferedCamel4Functionalities')), opt=True)
    NoteMM_EventArg._cont = ASN1Dict([
        (u'serviceKey', _NoteMM_EventArg_serviceKey),
        (u'eventMet', _NoteMM_EventArg_eventMet),
        (u'imsi', _NoteMM_EventArg_imsi),
        (u'msisdn', _NoteMM_EventArg_msisdn),
        (u'locationInformation', _NoteMM_EventArg_locationInformation),
        (u'supportedCAMELPhases', _NoteMM_EventArg_supportedCAMELPhases),
        (u'extensionContainer', _NoteMM_EventArg_extensionContainer),
        (u'locationInformationGPRS', _NoteMM_EventArg_locationInformationGPRS),
        (u'offeredCamel4Functionalities', _NoteMM_EventArg_offeredCamel4Functionalities),
        ])
    NoteMM_EventArg._ext = [u'locationInformationGPRS', u'offeredCamel4Functionalities']
    
    #-----< NoteMM-EventRes >-----#
    NoteMM_EventRes = SEQ(name=u'NoteMM-EventRes', mode=MODE_TYPE)
    _NoteMM_EventRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    NoteMM_EventRes._cont = ASN1Dict([
        (u'extensionContainer', _NoteMM_EventRes_extensionContainer),
        ])
    NoteMM_EventRes._ext = []
    
    #-----< Ext-SS-InfoFor-CSE >-----#
    Ext_SS_InfoFor_CSE = CHOICE(name=u'Ext-SS-InfoFor-CSE', mode=MODE_TYPE)
    _Ext_SS_InfoFor_CSE_forwardingInfoFor_CSE = SEQ(name=u'forwardingInfoFor-CSE', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-ForwardingInfoFor-CSE')))
    _Ext_SS_InfoFor_CSE_callBarringInfoFor_CSE = SEQ(name=u'callBarringInfoFor-CSE', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-CallBarringInfoFor-CSE')))
    Ext_SS_InfoFor_CSE._cont = ASN1Dict([
        (u'forwardingInfoFor-CSE', _Ext_SS_InfoFor_CSE_forwardingInfoFor_CSE),
        (u'callBarringInfoFor-CSE', _Ext_SS_InfoFor_CSE_callBarringInfoFor_CSE),
        ])
    Ext_SS_InfoFor_CSE._ext = None
    
    #-----< Ext-ForwardingInfoFor-CSE >-----#
    Ext_ForwardingInfoFor_CSE = SEQ(name=u'Ext-ForwardingInfoFor-CSE', mode=MODE_TYPE)
    _Ext_ForwardingInfoFor_CSE_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _Ext_ForwardingInfoFor_CSE_forwardingFeatureList = SEQ_OF(name=u'forwardingFeatureList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-ForwFeatureList')))
    _Ext_ForwardingInfoFor_CSE_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _Ext_ForwardingInfoFor_CSE_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    Ext_ForwardingInfoFor_CSE._cont = ASN1Dict([
        (u'ss-Code', _Ext_ForwardingInfoFor_CSE_ss_Code),
        (u'forwardingFeatureList', _Ext_ForwardingInfoFor_CSE_forwardingFeatureList),
        (u'notificationToCSE', _Ext_ForwardingInfoFor_CSE_notificationToCSE),
        (u'extensionContainer', _Ext_ForwardingInfoFor_CSE_extensionContainer),
        ])
    Ext_ForwardingInfoFor_CSE._ext = []
    
    #-----< Ext-CallBarringInfoFor-CSE >-----#
    Ext_CallBarringInfoFor_CSE = SEQ(name=u'Ext-CallBarringInfoFor-CSE', mode=MODE_TYPE)
    _Ext_CallBarringInfoFor_CSE_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _Ext_CallBarringInfoFor_CSE_callBarringFeatureList = SEQ_OF(name=u'callBarringFeatureList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-CallBarFeatureList')))
    _Ext_CallBarringInfoFor_CSE_password = STR_NUM(name=u'password', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'Password')), opt=True)
    _Ext_CallBarringInfoFor_CSE_password._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    _Ext_CallBarringInfoFor_CSE_wrongPasswordAttemptsCounter = INT(name=u'wrongPasswordAttemptsCounter', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'WrongPasswordAttemptsCounter')), opt=True)
    _Ext_CallBarringInfoFor_CSE_notificationToCSE = NULL(name=u'notificationToCSE', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _Ext_CallBarringInfoFor_CSE_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    Ext_CallBarringInfoFor_CSE._cont = ASN1Dict([
        (u'ss-Code', _Ext_CallBarringInfoFor_CSE_ss_Code),
        (u'callBarringFeatureList', _Ext_CallBarringInfoFor_CSE_callBarringFeatureList),
        (u'password', _Ext_CallBarringInfoFor_CSE_password),
        (u'wrongPasswordAttemptsCounter', _Ext_CallBarringInfoFor_CSE_wrongPasswordAttemptsCounter),
        (u'notificationToCSE', _Ext_CallBarringInfoFor_CSE_notificationToCSE),
        (u'extensionContainer', _Ext_CallBarringInfoFor_CSE_extensionContainer),
        ])
    Ext_CallBarringInfoFor_CSE._ext = []
    
    #-----< UpdateVcsgLocationArg >-----#
    UpdateVcsgLocationArg = SEQ(name=u'UpdateVcsgLocationArg', mode=MODE_TYPE)
    _UpdateVcsgLocationArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _UpdateVcsgLocationArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _UpdateVcsgLocationArg_vlr_Number = OCT_STR(name=u'vlr-Number', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _UpdateVcsgLocationArg_sgsn_Number = OCT_STR(name=u'sgsn-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _UpdateVcsgLocationArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    UpdateVcsgLocationArg._cont = ASN1Dict([
        (u'imsi', _UpdateVcsgLocationArg_imsi),
        (u'msisdn', _UpdateVcsgLocationArg_msisdn),
        (u'vlr-Number', _UpdateVcsgLocationArg_vlr_Number),
        (u'sgsn-Number', _UpdateVcsgLocationArg_sgsn_Number),
        (u'extensionContainer', _UpdateVcsgLocationArg_extensionContainer),
        ])
    UpdateVcsgLocationArg._ext = []
    
    #-----< UpdateVcsgLocationRes >-----#
    UpdateVcsgLocationRes = SEQ(name=u'UpdateVcsgLocationRes', mode=MODE_TYPE)
    _UpdateVcsgLocationRes_temporaryEmptySubscriptiondataIndicator = NULL(name=u'temporaryEmptySubscriptiondataIndicator', mode=MODE_TYPE, opt=True)
    _UpdateVcsgLocationRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    UpdateVcsgLocationRes._cont = ASN1Dict([
        (u'temporaryEmptySubscriptiondataIndicator', _UpdateVcsgLocationRes_temporaryEmptySubscriptiondataIndicator),
        (u'extensionContainer', _UpdateVcsgLocationRes_extensionContainer),
        ])
    UpdateVcsgLocationRes._ext = []
    
    #-----< CancelVcsgLocationArg >-----#
    CancelVcsgLocationArg = SEQ(name=u'CancelVcsgLocationArg', mode=MODE_TYPE)
    _CancelVcsgLocationArg_identity = CHOICE(name=u'identity', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'Identity')))
    _CancelVcsgLocationArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CancelVcsgLocationArg._cont = ASN1Dict([
        (u'identity', _CancelVcsgLocationArg_identity),
        (u'extensionContainer', _CancelVcsgLocationArg_extensionContainer),
        ])
    CancelVcsgLocationArg._ext = []
    
    #-----< CancelVcsgLocationRes >-----#
    CancelVcsgLocationRes = SEQ(name=u'CancelVcsgLocationRes', mode=MODE_TYPE)
    _CancelVcsgLocationRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CancelVcsgLocationRes._cont = ASN1Dict([
        (u'extensionContainer', _CancelVcsgLocationRes_extensionContainer),
        ])
    CancelVcsgLocationRes._ext = []
    
    _all_ = [
        _UpdateLocationArg_imsi,
        _UpdateLocationArg_msc_Number,
        _UpdateLocationArg_vlr_Number,
        _UpdateLocationArg_lmsi,
        _UpdateLocationArg_extensionContainer,
        _UpdateLocationArg_vlr_Capability,
        _UpdateLocationArg_informPreviousNetworkEntity,
        _UpdateLocationArg_cs_LCS_NotSupportedByUE,
        _UpdateLocationArg_v_gmlc_Address,
        _UpdateLocationArg_add_info,
        _UpdateLocationArg_pagingArea,
        _UpdateLocationArg_skipSubscriberDataUpdate,
        _UpdateLocationArg_restorationIndicator,
        _UpdateLocationArg_eplmn_List,
        _UpdateLocationArg_mme_DiameterAddress,
        UpdateLocationArg,
        _VLR_Capability_supportedCamelPhases,
        _VLR_Capability_extensionContainer,
        _VLR_Capability_solsaSupportIndicator,
        _VLR_Capability_istSupportIndicator,
        _VLR_Capability_superChargerSupportedInServingNetworkEntity,
        _VLR_Capability_longFTN_Supported,
        _VLR_Capability_supportedLCS_CapabilitySets,
        _VLR_Capability_offeredCamel4CSIs,
        _VLR_Capability_supportedRAT_TypesIndicator,
        _VLR_Capability_longGroupID_Supported,
        _VLR_Capability_mtRoamingForwardingSupported,
        _VLR_Capability_msisdn_lessOperation_Supported,
        VLR_Capability,
        SupportedRAT_Types,
        _SuperChargerInfo_sendSubscriberData,
        _SuperChargerInfo_subscriberDataStored,
        SuperChargerInfo,
        AgeIndicator,
        IST_SupportIndicator,
        SupportedLCS_CapabilitySets,
        _UpdateLocationRes_hlr_Number,
        _UpdateLocationRes_extensionContainer,
        _UpdateLocationRes_add_Capability,
        _UpdateLocationRes_pagingArea_Capability,
        UpdateLocationRes,
        _ADD_Info_imeisv,
        _ADD_Info_skipSubscriberDataUpdate,
        ADD_Info,
        _PagingArea__item_,
        PagingArea,
        _LocationArea_laiFixedLength,
        _LocationArea_lac,
        LocationArea,
        LAC,
        _CancelLocationArg_identity,
        _CancelLocationArg_cancellationType,
        _CancelLocationArg_extensionContainer,
        _CancelLocationArg_typeOfUpdate,
        _CancelLocationArg_mtrf_SupportedAndAuthorized,
        _CancelLocationArg_mtrf_SupportedAndNotAuthorized,
        _CancelLocationArg_newMSC_Number,
        _CancelLocationArg_newVLR_Number,
        _CancelLocationArg_new_lmsi,
        _CancelLocationArg_reattach_Required,
        CancelLocationArg,
        TypeOfUpdate,
        CancellationType,
        _CancelLocationRes_extensionContainer,
        CancelLocationRes,
        _PurgeMS_Arg_imsi,
        _PurgeMS_Arg_vlr_Number,
        _PurgeMS_Arg_sgsn_Number,
        _PurgeMS_Arg_extensionContainer,
        _PurgeMS_Arg_locationInformation,
        _PurgeMS_Arg_locationInformationGPRS,
        _PurgeMS_Arg_locationInformationEPS,
        PurgeMS_Arg,
        _PurgeMS_Res_freezeTMSI,
        _PurgeMS_Res_freezeP_TMSI,
        _PurgeMS_Res_extensionContainer,
        _PurgeMS_Res_freezeM_TMSI,
        PurgeMS_Res,
        _SendIdentificationArg_tmsi,
        _SendIdentificationArg_numberOfRequestedVectors,
        _SendIdentificationArg_segmentationProhibited,
        _SendIdentificationArg_extensionContainer,
        _SendIdentificationArg_msc_Number,
        _SendIdentificationArg_previous_LAI,
        _SendIdentificationArg_hopCounter,
        _SendIdentificationArg_mtRoamingForwardingSupported,
        _SendIdentificationArg_newVLR_Number,
        _SendIdentificationArg_new_lmsi,
        SendIdentificationArg,
        HopCounter,
        _SendIdentificationRes_imsi,
        _SendIdentificationRes_authenticationSetList,
        _SendIdentificationRes_currentSecurityContext,
        _SendIdentificationRes_extensionContainer,
        _SendIdentificationRes_lastUsedLtePLMN_Id,
        _SendIdentificationRes_mtCallPendingFlag,
        SendIdentificationRes,
        _AuthenticationSetList_tripletList,
        _AuthenticationSetList_quintupletList,
        AuthenticationSetList,
        _TripletList__item_,
        TripletList,
        _QuintupletList__item_,
        QuintupletList,
        _AuthenticationTriplet_rand,
        _AuthenticationTriplet_sres,
        _AuthenticationTriplet_kc,
        AuthenticationTriplet,
        _AuthenticationQuintuplet_rand,
        _AuthenticationQuintuplet_xres,
        _AuthenticationQuintuplet_ck,
        _AuthenticationQuintuplet_ik,
        _AuthenticationQuintuplet_autn,
        AuthenticationQuintuplet,
        _CurrentSecurityContext_gsm_SecurityContextData,
        _CurrentSecurityContext_umts_SecurityContextData,
        CurrentSecurityContext,
        _GSM_SecurityContextData_kc,
        _GSM_SecurityContextData_cksn,
        GSM_SecurityContextData,
        _UMTS_SecurityContextData_ck,
        _UMTS_SecurityContextData_ik,
        _UMTS_SecurityContextData_ksi,
        UMTS_SecurityContextData,
        RAND,
        SRES,
        Kc,
        XRES,
        CK,
        IK,
        AUTN,
        AUTS,
        Cksn,
        KSI,
        _AuthenticationFailureReportArg_imsi,
        _AuthenticationFailureReportArg_failureCause,
        _AuthenticationFailureReportArg_extensionContainer,
        _AuthenticationFailureReportArg_re_attempt,
        _AuthenticationFailureReportArg_accessType,
        _AuthenticationFailureReportArg_rand,
        _AuthenticationFailureReportArg_vlr_Number,
        _AuthenticationFailureReportArg_sgsn_Number,
        AuthenticationFailureReportArg,
        AccessType,
        _AuthenticationFailureReportRes_extensionContainer,
        AuthenticationFailureReportRes,
        FailureCause,
        _UpdateGprsLocationArg_imsi,
        _UpdateGprsLocationArg_sgsn_Number,
        _UpdateGprsLocationArg_sgsn_Address,
        _UpdateGprsLocationArg_extensionContainer,
        _UpdateGprsLocationArg_sgsn_Capability,
        _UpdateGprsLocationArg_informPreviousNetworkEntity,
        _UpdateGprsLocationArg_ps_LCS_NotSupportedByUE,
        _UpdateGprsLocationArg_v_gmlc_Address,
        _UpdateGprsLocationArg_add_info,
        _UpdateGprsLocationArg_eps_info,
        _UpdateGprsLocationArg_servingNodeTypeIndicator,
        _UpdateGprsLocationArg_skipSubscriberDataUpdate,
        _UpdateGprsLocationArg_usedRAT_Type,
        _UpdateGprsLocationArg_gprsSubscriptionDataNotNeeded,
        _UpdateGprsLocationArg_nodeTypeIndicator,
        _UpdateGprsLocationArg_areaRestricted,
        _UpdateGprsLocationArg_ue_reachableIndicator,
        _UpdateGprsLocationArg_epsSubscriptionDataNotNeeded,
        _UpdateGprsLocationArg_ue_srvcc_Capability,
        _UpdateGprsLocationArg_eplmn_List,
        _UpdateGprsLocationArg_mmeNumberforMTSMS,
        _UpdateGprsLocationArg_smsRegisterRequest,
        _UpdateGprsLocationArg_sms_Only,
        _UpdateGprsLocationArg_removalofMMERegistrationforSMS,
        _UpdateGprsLocationArg_sgsn_Name,
        _UpdateGprsLocationArg_sgsn_Realm,
        _UpdateGprsLocationArg_lgd_supportIndicator,
        _UpdateGprsLocationArg_adjacentPLMN_List,
        UpdateGprsLocationArg,
        SMSRegisterRequest,
        Used_RAT_Type,
        _EPS_Info_pdn_gw_update,
        _EPS_Info_isr_Information,
        EPS_Info,
        _PDN_GW_Update_apn,
        _PDN_GW_Update_pdn_gw_Identity,
        _PDN_GW_Update_contextId,
        _PDN_GW_Update_extensionContainer,
        PDN_GW_Update,
        ISR_Information,
        _SGSN_Capability_solsaSupportIndicator,
        _SGSN_Capability_extensionContainer,
        _SGSN_Capability_superChargerSupportedInServingNetworkEntity,
        _SGSN_Capability_gprsEnhancementsSupportIndicator,
        _SGSN_Capability_supportedCamelPhases,
        _SGSN_Capability_supportedLCS_CapabilitySets,
        _SGSN_Capability_offeredCamel4CSIs,
        _SGSN_Capability_smsCallBarringSupportIndicator,
        _SGSN_Capability_supportedRAT_TypesIndicator,
        _SGSN_Capability_supportedFeatures,
        _SGSN_Capability_t_adsDataRetrieval,
        _SGSN_Capability_homogeneousSupportOfIMSVoiceOverPSSessions,
        _SGSN_Capability_cancellationTypeInitialAttach,
        _SGSN_Capability_msisdn_lessOperation_Supported,
        _SGSN_Capability_updateofHomogeneousSupportOfIMSVoiceOverPSSessions,
        SGSN_Capability,
        SupportedFeatures,
        UE_SRVCC_Capability,
        _UpdateGprsLocationRes_hlr_Number,
        _UpdateGprsLocationRes_extensionContainer,
        _UpdateGprsLocationRes_add_Capability,
        _UpdateGprsLocationRes_sgsn_mmeSeparationSupported,
        _UpdateGprsLocationRes_mmeRegisteredforSMS,
        UpdateGprsLocationRes,
        _EPLMN_List__item_,
        EPLMN_List,
        _AdjacentPLMN_List__item_,
        AdjacentPLMN_List,
        _ForwardAccessSignalling_Arg_an_APDU,
        _ForwardAccessSignalling_Arg_integrityProtectionInfo,
        _ForwardAccessSignalling_Arg_encryptionInfo,
        _ForwardAccessSignalling_Arg_keyStatus,
        _ForwardAccessSignalling_Arg_allowedGSM_Algorithms,
        _ForwardAccessSignalling_Arg_allowedUMTS_Algorithms,
        _ForwardAccessSignalling_Arg_radioResourceInformation,
        _ForwardAccessSignalling_Arg_extensionContainer,
        _ForwardAccessSignalling_Arg_radioResourceList,
        _ForwardAccessSignalling_Arg_bssmap_ServiceHandover,
        _ForwardAccessSignalling_Arg_ranap_ServiceHandover,
        _ForwardAccessSignalling_Arg_bssmap_ServiceHandoverList,
        _ForwardAccessSignalling_Arg_currentlyUsedCodec,
        _ForwardAccessSignalling_Arg_iuSupportedCodecsList,
        _ForwardAccessSignalling_Arg_rab_ConfigurationIndicator,
        _ForwardAccessSignalling_Arg_iuSelectedCodec,
        _ForwardAccessSignalling_Arg_alternativeChannelType,
        _ForwardAccessSignalling_Arg_tracePropagationList,
        _ForwardAccessSignalling_Arg_aoipSupportedCodecsListAnchor,
        _ForwardAccessSignalling_Arg_aoipSelectedCodecTarget,
        _ForwardAccessSignalling_Arg_uesbi_Iu,
        _ForwardAccessSignalling_Arg_imeisv,
        ForwardAccessSignalling_Arg,
        AllowedGSM_Algorithms,
        _AllowedUMTS_Algorithms_integrityProtectionAlgorithms,
        _AllowedUMTS_Algorithms_encryptionAlgorithms,
        _AllowedUMTS_Algorithms_extensionContainer,
        AllowedUMTS_Algorithms,
        PermittedIntegrityProtectionAlgorithms,
        maxPermittedIntegrityProtectionAlgorithmsLength,
        PermittedEncryptionAlgorithms,
        maxPermittedEncryptionAlgorithmsLength,
        KeyStatus,
        _PrepareHO_Arg_targetCellId,
        _PrepareHO_Arg_ho_NumberNotRequired,
        _PrepareHO_Arg_targetRNCId,
        _PrepareHO_Arg_an_APDU,
        _PrepareHO_Arg_multipleBearerRequested,
        _PrepareHO_Arg_imsi,
        _PrepareHO_Arg_integrityProtectionInfo,
        _PrepareHO_Arg_encryptionInfo,
        _PrepareHO_Arg_radioResourceInformation,
        _PrepareHO_Arg_allowedGSM_Algorithms,
        _PrepareHO_Arg_allowedUMTS_Algorithms,
        _PrepareHO_Arg_radioResourceList,
        _PrepareHO_Arg_extensionContainer,
        _PrepareHO_Arg_rab_Id,
        _PrepareHO_Arg_bssmap_ServiceHandover,
        _PrepareHO_Arg_ranap_ServiceHandover,
        _PrepareHO_Arg_bssmap_ServiceHandoverList,
        _PrepareHO_Arg_asciCallReference,
        _PrepareHO_Arg_geran_classmark,
        _PrepareHO_Arg_iuCurrentlyUsedCodec,
        _PrepareHO_Arg_iuSupportedCodecsList,
        _PrepareHO_Arg_rab_ConfigurationIndicator,
        _PrepareHO_Arg_uesbi_Iu,
        _PrepareHO_Arg_imeisv,
        _PrepareHO_Arg_alternativeChannelType,
        _PrepareHO_Arg_tracePropagationList,
        _PrepareHO_Arg_aoipSupportedCodecsListAnchor,
        _PrepareHO_Arg_regionalSubscriptionData,
        _PrepareHO_Arg_lclsGlobalCallReference,
        _PrepareHO_Arg_lcls_Negotiation,
        _PrepareHO_Arg_lcls_Configuration_Preference,
        _PrepareHO_Arg_csg_SubscriptionDataList,
        PrepareHO_Arg,
        LCLS_GlobalCallReference,
        LCLS_Negotiation,
        LCLS_ConfigurationPreference,
        _BSSMAP_ServiceHandoverList__item_,
        BSSMAP_ServiceHandoverList,
        _BSSMAP_ServiceHandoverInfo_bssmap_ServiceHandover,
        _BSSMAP_ServiceHandoverInfo_rab_Id,
        BSSMAP_ServiceHandoverInfo,
        maxNumOfServiceHandovers,
        BSSMAP_ServiceHandover,
        RANAP_ServiceHandover,
        _RadioResourceList__item_,
        RadioResourceList,
        _RadioResource_radioResourceInformation,
        _RadioResource_rab_Id,
        RadioResource,
        maxNumOfRadioResources,
        _PrepareHO_Res_handoverNumber,
        _PrepareHO_Res_relocationNumberList,
        _PrepareHO_Res_an_APDU,
        _PrepareHO_Res_multicallBearerInfo,
        _PrepareHO_Res_multipleBearerNotSupported,
        _PrepareHO_Res_selectedUMTS_Algorithms,
        _PrepareHO_Res_chosenRadioResourceInformation,
        _PrepareHO_Res_extensionContainer,
        _PrepareHO_Res_iuSelectedCodec,
        _PrepareHO_Res_iuAvailableCodecsList,
        _PrepareHO_Res_aoipSelectedCodecTarget,
        _PrepareHO_Res_aoipAvailableCodecsListMap,
        PrepareHO_Res,
        _SelectedUMTS_Algorithms_integrityProtectionAlgorithm,
        _SelectedUMTS_Algorithms_encryptionAlgorithm,
        _SelectedUMTS_Algorithms_extensionContainer,
        SelectedUMTS_Algorithms,
        ChosenIntegrityProtectionAlgorithm,
        ChosenEncryptionAlgorithm,
        _ChosenRadioResourceInformation_chosenChannelInfo,
        _ChosenRadioResourceInformation_chosenSpeechVersion,
        ChosenRadioResourceInformation,
        ChosenChannelInfo,
        ChosenSpeechVersion,
        _PrepareSubsequentHO_Arg_targetCellId,
        _PrepareSubsequentHO_Arg_targetMSC_Number,
        _PrepareSubsequentHO_Arg_targetRNCId,
        _PrepareSubsequentHO_Arg_an_APDU,
        _PrepareSubsequentHO_Arg_selectedRab_Id,
        _PrepareSubsequentHO_Arg_extensionContainer,
        _PrepareSubsequentHO_Arg_geran_classmark,
        _PrepareSubsequentHO_Arg_rab_ConfigurationIndicator,
        PrepareSubsequentHO_Arg,
        _PrepareSubsequentHO_Res_an_APDU,
        _PrepareSubsequentHO_Res_extensionContainer,
        PrepareSubsequentHO_Res,
        _ProcessAccessSignalling_Arg_an_APDU,
        _ProcessAccessSignalling_Arg_selectedUMTS_Algorithms,
        _ProcessAccessSignalling_Arg_selectedGSM_Algorithm,
        _ProcessAccessSignalling_Arg_chosenRadioResourceInformation,
        _ProcessAccessSignalling_Arg_selectedRab_Id,
        _ProcessAccessSignalling_Arg_extensionContainer,
        _ProcessAccessSignalling_Arg_iUSelectedCodec,
        _ProcessAccessSignalling_Arg_iuAvailableCodecsList,
        _ProcessAccessSignalling_Arg_aoipSelectedCodecTarget,
        _ProcessAccessSignalling_Arg_aoipAvailableCodecsListMap,
        ProcessAccessSignalling_Arg,
        _AoIPCodecsList_codec1,
        _AoIPCodecsList_codec2,
        _AoIPCodecsList_codec3,
        _AoIPCodecsList_codec4,
        _AoIPCodecsList_codec5,
        _AoIPCodecsList_codec6,
        _AoIPCodecsList_codec7,
        _AoIPCodecsList_codec8,
        _AoIPCodecsList_extensionContainer,
        AoIPCodecsList,
        AoIPCodec,
        _SupportedCodecsList_utranCodecList,
        _SupportedCodecsList_geranCodecList,
        _SupportedCodecsList_extensionContainer,
        SupportedCodecsList,
        _CodecList_codec1,
        _CodecList_codec2,
        _CodecList_codec3,
        _CodecList_codec4,
        _CodecList_codec5,
        _CodecList_codec6,
        _CodecList_codec7,
        _CodecList_codec8,
        _CodecList_extensionContainer,
        CodecList,
        Codec,
        GERAN_Classmark,
        SelectedGSM_Algorithm,
        _SendEndSignal_Arg_an_APDU,
        _SendEndSignal_Arg_extensionContainer,
        SendEndSignal_Arg,
        _SendEndSignal_Res_extensionContainer,
        SendEndSignal_Res,
        RNCId,
        _RelocationNumberList__item_,
        RelocationNumberList,
        MulticallBearerInfo,
        _RelocationNumber_handoverNumber,
        _RelocationNumber_rab_Id,
        RelocationNumber,
        RAB_Id,
        maxNrOfRABs,
        maxNumOfRelocationNumber,
        RadioResourceInformation,
        IntegrityProtectionInformation,
        maxNumOfIntegrityInfo,
        EncryptionInformation,
        maxNumOfEncryptionInfo,
        _SendAuthenticationInfoArg_imsi,
        _SendAuthenticationInfoArg_numberOfRequestedVectors,
        _SendAuthenticationInfoArg_segmentationProhibited,
        _SendAuthenticationInfoArg_immediateResponsePreferred,
        _SendAuthenticationInfoArg_re_synchronisationInfo,
        _SendAuthenticationInfoArg_extensionContainer,
        _SendAuthenticationInfoArg_requestingNodeType,
        _SendAuthenticationInfoArg_requestingPLMN_Id,
        _SendAuthenticationInfoArg_numberOfRequestedAdditional_Vectors,
        _SendAuthenticationInfoArg_additionalVectorsAreForEPS,
        _SendAuthenticationInfoArg_ueUsageTypeRequestIndication,
        SendAuthenticationInfoArg,
        NumberOfRequestedVectors,
        _Re_synchronisationInfo_rand,
        _Re_synchronisationInfo_auts,
        Re_synchronisationInfo,
        _SendAuthenticationInfoRes_authenticationSetList,
        _SendAuthenticationInfoRes_extensionContainer,
        _SendAuthenticationInfoRes_eps_AuthenticationSetList,
        _SendAuthenticationInfoRes_ueUsageType,
        SendAuthenticationInfoRes,
        _EPS_AuthenticationSetList__item_,
        EPS_AuthenticationSetList,
        UE_UsageType,
        _EPC_AV_rand,
        _EPC_AV_xres,
        _EPC_AV_autn,
        _EPC_AV_kasme,
        _EPC_AV_extensionContainer,
        EPC_AV,
        KASME,
        RequestingNodeType,
        _CheckIMEI_Arg_imei,
        _CheckIMEI_Arg_requestedEquipmentInfo,
        _CheckIMEI_Arg_extensionContainer,
        CheckIMEI_Arg,
        _CheckIMEI_Res_equipmentStatus,
        _CheckIMEI_Res_bmuef,
        _CheckIMEI_Res_extensionContainer,
        CheckIMEI_Res,
        RequestedEquipmentInfo,
        _UESBI_Iu_uesbi_IuA,
        _UESBI_Iu_uesbi_IuB,
        UESBI_Iu,
        UESBI_IuA,
        UESBI_IuB,
        EquipmentStatus,
        _InsertSubscriberDataArg_imsi,
        _InsertSubscriberDataArg_msisdn,
        _InsertSubscriberDataArg_category,
        _InsertSubscriberDataArg_subscriberStatus,
        _InsertSubscriberDataArg_bearerServiceList,
        _InsertSubscriberDataArg_teleserviceList,
        _InsertSubscriberDataArg_provisionedSS,
        _InsertSubscriberDataArg_odb_Data,
        _InsertSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature,
        _InsertSubscriberDataArg_regionalSubscriptionData,
        _InsertSubscriberDataArg_vbsSubscriptionData,
        _InsertSubscriberDataArg_vgcsSubscriptionData,
        _InsertSubscriberDataArg_vlrCamelSubscriptionInfo,
        _InsertSubscriberDataArg_extensionContainer,
        _InsertSubscriberDataArg_naea_PreferredCI,
        _InsertSubscriberDataArg_gprsSubscriptionData,
        _InsertSubscriberDataArg_roamingRestrictedInSgsnDueToUnsupportedFeature,
        _InsertSubscriberDataArg_networkAccessMode,
        _InsertSubscriberDataArg_lsaInformation,
        _InsertSubscriberDataArg_lmu_Indicator,
        _InsertSubscriberDataArg_lcsInformation,
        _InsertSubscriberDataArg_istAlertTimer,
        _InsertSubscriberDataArg_superChargerSupportedInHLR,
        _InsertSubscriberDataArg_mc_SS_Info,
        _InsertSubscriberDataArg_cs_AllocationRetentionPriority,
        _InsertSubscriberDataArg_sgsn_CAMEL_SubscriptionInfo,
        _InsertSubscriberDataArg_chargingCharacteristics,
        _InsertSubscriberDataArg_accessRestrictionData,
        _InsertSubscriberDataArg_ics_Indicator,
        _InsertSubscriberDataArg_eps_SubscriptionData,
        _InsertSubscriberDataArg_csg_SubscriptionDataList,
        _InsertSubscriberDataArg_ue_ReachabilityRequestIndicator,
        _InsertSubscriberDataArg_sgsn_Number,
        _InsertSubscriberDataArg_mme_Name,
        _InsertSubscriberDataArg_subscribedPeriodicRAUTAUtimer,
        _InsertSubscriberDataArg_vplmnLIPAAllowed,
        _InsertSubscriberDataArg_mdtUserConsent,
        _InsertSubscriberDataArg_subscribedPeriodicLAUtimer,
        _InsertSubscriberDataArg_vplmn_Csg_SubscriptionDataList,
        _InsertSubscriberDataArg_additionalMSISDN,
        _InsertSubscriberDataArg_psAndSMS_OnlyServiceProvision,
        _InsertSubscriberDataArg_smsInSGSNAllowed,
        _InsertSubscriberDataArg_cs_to_ps_SRVCC_Allowed_Indicator,
        _InsertSubscriberDataArg_pcscf_Restoration_Request,
        _InsertSubscriberDataArg_adjacentAccessRestrictionDataList,
        _InsertSubscriberDataArg_imsi_Group_Id_List,
        _InsertSubscriberDataArg_ueUsageType,
        _InsertSubscriberDataArg_userPlaneIntegrityProtectionIndicator,
        InsertSubscriberDataArg,
        Group_Service_ID,
        Local_GroupID,
        _IMSI_GroupIdList__item_,
        IMSI_GroupIdList,
        _IMSI_GroupId_group_Service_Id,
        _IMSI_GroupId_plmnId,
        _IMSI_GroupId_local_Group_ID,
        IMSI_GroupId,
        SubscribedPeriodicRAUTAUtimer,
        SubscribedPeriodicLAUtimer,
        _CSG_SubscriptionDataList__item_,
        CSG_SubscriptionDataList,
        _CSG_SubscriptionData_csg_Id,
        _CSG_SubscriptionData_expirationDate,
        _CSG_SubscriptionData_extensionContainer,
        _CSG_SubscriptionData_lipa_AllowedAPNList,
        _CSG_SubscriptionData_plmn_Id,
        CSG_SubscriptionData,
        _VPLMN_CSG_SubscriptionDataList__item_,
        VPLMN_CSG_SubscriptionDataList,
        CSG_Id,
        _LIPA_AllowedAPNList__item_,
        LIPA_AllowedAPNList,
        maxNumOfLIPAAllowedAPN,
        _EPS_SubscriptionData_apn_oi_Replacement,
        _EPS_SubscriptionData_rfsp_id,
        _EPS_SubscriptionData_ambr,
        _EPS_SubscriptionData_apn_ConfigurationProfile,
        _EPS_SubscriptionData_stn_sr,
        _EPS_SubscriptionData_extensionContainer,
        _EPS_SubscriptionData_mps_CSPriority,
        _EPS_SubscriptionData_mps_EPSPriority,
        _EPS_SubscriptionData_subscribed_vsrvcc,
        EPS_SubscriptionData,
        APN_OI_Replacement,
        RFSP_ID,
        _APN_ConfigurationProfile_defaultContext,
        _APN_ConfigurationProfile_completeDataListIncluded,
        _APN_ConfigurationProfile_epsDataList,
        _APN_ConfigurationProfile_extensionContainer,
        _APN_ConfigurationProfile_additionalDefaultContext,
        APN_ConfigurationProfile,
        _EPS_DataList__item_,
        EPS_DataList,
        maxNumOfAPN_Configurations,
        _APN_Configuration_contextId,
        _APN_Configuration_pdn_Type,
        _APN_Configuration_servedPartyIP_IPv4_Address,
        _APN_Configuration_apn,
        _APN_Configuration_eps_qos_Subscribed,
        _APN_Configuration_pdn_gw_Identity,
        _APN_Configuration_pdn_gw_AllocationType,
        _APN_Configuration_vplmnAddressAllowed,
        _APN_Configuration_chargingCharacteristics,
        _APN_Configuration_ambr,
        _APN_Configuration_specificAPNInfoList,
        _APN_Configuration_extensionContainer,
        _APN_Configuration_servedPartyIP_IPv6_Address,
        _APN_Configuration_apn_oi_Replacement,
        _APN_Configuration_sipto_Permission,
        _APN_Configuration_lipa_Permission,
        _APN_Configuration_restoration_Priority,
        _APN_Configuration_sipto_local_network_Permission,
        _APN_Configuration_wlan_offloadability,
        _APN_Configuration_non_IP_PDN_Type_Indicator,
        _APN_Configuration_nIDD_Mechanism,
        _APN_Configuration_sCEF_ID,
        APN_Configuration,
        NIDD_Mechanism,
        PDN_Type,
        _EPS_QoS_Subscribed_qos_Class_Identifier,
        _EPS_QoS_Subscribed_allocation_Retention_Priority,
        _EPS_QoS_Subscribed_extensionContainer,
        EPS_QoS_Subscribed,
        _AMBR_max_RequestedBandwidth_UL,
        _AMBR_max_RequestedBandwidth_DL,
        _AMBR_extensionContainer,
        AMBR,
        _SpecificAPNInfoList__item_,
        SpecificAPNInfoList,
        maxNumOfSpecificAPNInfos,
        _SpecificAPNInfo_apn,
        _SpecificAPNInfo_pdn_gw_Identity,
        _SpecificAPNInfo_extensionContainer,
        SpecificAPNInfo,
        Bandwidth,
        QoS_Class_Identifier,
        _Allocation_Retention_Priority_priority_level,
        _Allocation_Retention_Priority_pre_emption_capability,
        _Allocation_Retention_Priority_pre_emption_vulnerability,
        _Allocation_Retention_Priority_extensionContainer,
        Allocation_Retention_Priority,
        _PDN_GW_Identity_pdn_gw_ipv4_Address,
        _PDN_GW_Identity_pdn_gw_ipv6_Address,
        _PDN_GW_Identity_pdn_gw_name,
        _PDN_GW_Identity_extensionContainer,
        PDN_GW_Identity,
        FQDN,
        PDN_GW_AllocationType,
        _WLAN_Offloadability_wlan_offloadability_EUTRAN,
        _WLAN_Offloadability_wlan_offloadability_UTRAN,
        _WLAN_Offloadability_extensionContainer,
        WLAN_Offloadability,
        WLAN_Offloadability_Indication,
        AccessRestrictionData,
        _AdjacentAccessRestrictionDataList__item_,
        AdjacentAccessRestrictionDataList,
        _AdjacentAccessRestrictionData_plmnId,
        _AdjacentAccessRestrictionData_accessRestrictionData,
        AdjacentAccessRestrictionData,
        CS_AllocationRetentionPriority,
        IST_AlertTimerValue,
        _LCSInformation_gmlc_List,
        _LCSInformation_lcs_PrivacyExceptionList,
        _LCSInformation_molr_List,
        _LCSInformation_add_lcs_PrivacyExceptionList,
        LCSInformation,
        _GMLC_List__item_,
        GMLC_List,
        maxNumOfGMLC,
        NetworkAccessMode,
        _GPRSDataList__item_,
        GPRSDataList,
        maxNumOfPDP_Contexts,
        _PDP_Context_pdp_ContextId,
        _PDP_Context_pdp_Type,
        _PDP_Context_pdp_Address,
        _PDP_Context_qos_Subscribed,
        _PDP_Context_vplmnAddressAllowed,
        _PDP_Context_apn,
        _PDP_Context_extensionContainer,
        _PDP_Context_ext_QoS_Subscribed,
        _PDP_Context_pdp_ChargingCharacteristics,
        _PDP_Context_ext2_QoS_Subscribed,
        _PDP_Context_ext3_QoS_Subscribed,
        _PDP_Context_ext4_QoS_Subscribed,
        _PDP_Context_apn_oi_Replacement,
        _PDP_Context_ext_pdp_Type,
        _PDP_Context_ext_pdp_Address,
        _PDP_Context_ambr,
        _PDP_Context_sipto_Permission,
        _PDP_Context_lipa_Permission,
        _PDP_Context_restoration_Priority,
        _PDP_Context_sipto_local_network_Permission,
        PDP_Context,
        Restoration_Priority,
        SIPTO_Permission,
        SIPTO_Local_Network_Permission,
        LIPA_Permission,
        ContextId,
        _GPRSSubscriptionData_completeDataListIncluded,
        _GPRSSubscriptionData_gprsDataList,
        _GPRSSubscriptionData_extensionContainer,
        _GPRSSubscriptionData_apn_oi_Replacement,
        GPRSSubscriptionData,
        _SGSN_CAMEL_SubscriptionInfo_gprs_CSI,
        _SGSN_CAMEL_SubscriptionInfo_mo_sms_CSI,
        _SGSN_CAMEL_SubscriptionInfo_extensionContainer,
        _SGSN_CAMEL_SubscriptionInfo_mt_sms_CSI,
        _SGSN_CAMEL_SubscriptionInfo_mt_smsCAMELTDP_CriteriaList,
        _SGSN_CAMEL_SubscriptionInfo_mg_csi,
        SGSN_CAMEL_SubscriptionInfo,
        _GPRS_CSI_gprs_CamelTDPDataList,
        _GPRS_CSI_camelCapabilityHandling,
        _GPRS_CSI_extensionContainer,
        _GPRS_CSI_notificationToCSE,
        _GPRS_CSI_csi_Active,
        GPRS_CSI,
        _GPRS_CamelTDPDataList__item_,
        GPRS_CamelTDPDataList,
        _GPRS_CamelTDPData_gprs_TriggerDetectionPoint,
        _GPRS_CamelTDPData_serviceKey,
        _GPRS_CamelTDPData_gsmSCF_Address,
        _GPRS_CamelTDPData_defaultSessionHandling,
        _GPRS_CamelTDPData_extensionContainer,
        GPRS_CamelTDPData,
        DefaultGPRS_Handling,
        GPRS_TriggerDetectionPoint,
        APN,
        PDP_Type,
        Ext_PDP_Type,
        PDP_Address,
        QoS_Subscribed,
        Ext_QoS_Subscribed,
        Ext2_QoS_Subscribed,
        Ext3_QoS_Subscribed,
        Ext4_QoS_Subscribed,
        ChargingCharacteristics,
        LSAOnlyAccessIndicator,
        _LSADataList__item_,
        LSADataList,
        maxNumOfLSAs,
        _LSAData_lsaIdentity,
        _LSAData_lsaAttributes,
        _LSAData_lsaActiveModeIndicator,
        _LSAData_extensionContainer,
        LSAData,
        _LSAInformation_completeDataListIncluded,
        _LSAInformation_lsaOnlyAccessIndicator,
        _LSAInformation_lsaDataList,
        _LSAInformation_extensionContainer,
        LSAInformation,
        LSAIdentity,
        LSAAttributes,
        _SubscriberData_msisdn,
        _SubscriberData_category,
        _SubscriberData_subscriberStatus,
        _SubscriberData_bearerServiceList,
        _SubscriberData_teleserviceList,
        _SubscriberData_provisionedSS,
        _SubscriberData_odb_Data,
        _SubscriberData_roamingRestrictionDueToUnsupportedFeature,
        _SubscriberData_regionalSubscriptionData,
        _SubscriberData_vbsSubscriptionData,
        _SubscriberData_vgcsSubscriptionData,
        _SubscriberData_vlrCamelSubscriptionInfo,
        SubscriberData,
        Category,
        SubscriberStatus,
        _BearerServiceList__item_,
        BearerServiceList,
        maxNumOfBearerServices,
        _TeleserviceList__item_,
        TeleserviceList,
        maxNumOfTeleservices,
        _ODB_Data_odb_GeneralData,
        _ODB_Data_odb_HPLMN_Data,
        _ODB_Data_extensionContainer,
        ODB_Data,
        ODB_GeneralData,
        ODB_HPLMN_Data,
        _Ext_SS_InfoList__item_,
        Ext_SS_InfoList,
        _Ext_SS_Info_forwardingInfo,
        _Ext_SS_Info_callBarringInfo,
        _Ext_SS_Info_cug_Info,
        _Ext_SS_Info_ss_Data,
        _Ext_SS_Info_emlpp_Info,
        Ext_SS_Info,
        _Ext_ForwInfo_ss_Code,
        _Ext_ForwInfo_forwardingFeatureList,
        _Ext_ForwInfo_extensionContainer,
        Ext_ForwInfo,
        _Ext_ForwFeatureList__item_,
        Ext_ForwFeatureList,
        _Ext_ForwFeature_basicService,
        _Ext_ForwFeature_ss_Status,
        _Ext_ForwFeature_forwardedToNumber,
        _Ext_ForwFeature_forwardedToSubaddress,
        _Ext_ForwFeature_forwardingOptions,
        _Ext_ForwFeature_noReplyConditionTime,
        _Ext_ForwFeature_extensionContainer,
        _Ext_ForwFeature_longForwardedToNumber,
        Ext_ForwFeature,
        Ext_ForwOptions,
        Ext_NoRepCondTime,
        _Ext_CallBarInfo_ss_Code,
        _Ext_CallBarInfo_callBarringFeatureList,
        _Ext_CallBarInfo_extensionContainer,
        Ext_CallBarInfo,
        _Ext_CallBarFeatureList__item_,
        Ext_CallBarFeatureList,
        _Ext_CallBarringFeature_basicService,
        _Ext_CallBarringFeature_ss_Status,
        _Ext_CallBarringFeature_extensionContainer,
        Ext_CallBarringFeature,
        _CUG_Info_cug_SubscriptionList,
        _CUG_Info_cug_FeatureList,
        _CUG_Info_extensionContainer,
        CUG_Info,
        _CUG_SubscriptionList__item_,
        CUG_SubscriptionList,
        _CUG_Subscription_cug_Index,
        _CUG_Subscription_cug_Interlock,
        _CUG_Subscription_intraCUG_Options,
        _CUG_Subscription_basicServiceGroupList,
        _CUG_Subscription_extensionContainer,
        CUG_Subscription,
        CUG_Index,
        CUG_Interlock,
        IntraCUG_Options,
        maxNumOfCUG,
        _CUG_FeatureList__item_,
        CUG_FeatureList,
        _Ext_BasicServiceGroupList__item_,
        Ext_BasicServiceGroupList,
        maxNumOfExt_BasicServiceGroups,
        _CUG_Feature_basicService,
        _CUG_Feature_preferentialCUG_Indicator,
        _CUG_Feature_interCUG_Restrictions,
        _CUG_Feature_extensionContainer,
        CUG_Feature,
        InterCUG_Restrictions,
        _Ext_SS_Data_ss_Code,
        _Ext_SS_Data_ss_Status,
        _Ext_SS_Data_ss_SubscriptionOption,
        _Ext_SS_Data_basicServiceGroupList,
        _Ext_SS_Data_extensionContainer,
        Ext_SS_Data,
        _LCS_PrivacyExceptionList__item_,
        LCS_PrivacyExceptionList,
        maxNumOfPrivacyClass,
        _LCS_PrivacyClass_ss_Code,
        _LCS_PrivacyClass_ss_Status,
        _LCS_PrivacyClass_notificationToMSUser,
        _LCS_PrivacyClass_externalClientList,
        _LCS_PrivacyClass_plmnClientList,
        _LCS_PrivacyClass_extensionContainer,
        _LCS_PrivacyClass_ext_externalClientList,
        _LCS_PrivacyClass_serviceTypeList,
        LCS_PrivacyClass,
        _ExternalClientList__item_,
        ExternalClientList,
        maxNumOfExternalClient,
        _PLMNClientList__item_,
        PLMNClientList,
        maxNumOfPLMNClient,
        _Ext_ExternalClientList__item_,
        Ext_ExternalClientList,
        maxNumOfExt_ExternalClient,
        _ExternalClient_clientIdentity,
        _ExternalClient_gmlc_Restriction,
        _ExternalClient_notificationToMSUser,
        _ExternalClient_extensionContainer,
        ExternalClient,
        GMLC_Restriction,
        NotificationToMSUser,
        _ServiceTypeList__item_,
        ServiceTypeList,
        maxNumOfServiceType,
        _ServiceType_serviceTypeIdentity,
        _ServiceType_gmlc_Restriction,
        _ServiceType_notificationToMSUser,
        _ServiceType_extensionContainer,
        ServiceType,
        _MOLR_List__item_,
        MOLR_List,
        maxNumOfMOLR_Class,
        _MOLR_Class_ss_Code,
        _MOLR_Class_ss_Status,
        _MOLR_Class_extensionContainer,
        MOLR_Class,
        _ZoneCodeList__item_,
        ZoneCodeList,
        ZoneCode,
        maxNumOfZoneCodes,
        _InsertSubscriberDataRes_teleserviceList,
        _InsertSubscriberDataRes_bearerServiceList,
        _InsertSubscriberDataRes_ss_List,
        _InsertSubscriberDataRes_odb_GeneralData,
        _InsertSubscriberDataRes_regionalSubscriptionResponse,
        _InsertSubscriberDataRes_supportedCamelPhases,
        _InsertSubscriberDataRes_extensionContainer,
        _InsertSubscriberDataRes_offeredCamel4CSIs,
        _InsertSubscriberDataRes_supportedFeatures,
        InsertSubscriberDataRes,
        RegionalSubscriptionResponse,
        _DeleteSubscriberDataArg_imsi,
        _DeleteSubscriberDataArg_basicServiceList,
        _DeleteSubscriberDataArg_ss_List,
        _DeleteSubscriberDataArg_roamingRestrictionDueToUnsupportedFeature,
        _DeleteSubscriberDataArg_regionalSubscriptionIdentifier,
        _DeleteSubscriberDataArg_vbsGroupIndication,
        _DeleteSubscriberDataArg_vgcsGroupIndication,
        _DeleteSubscriberDataArg_camelSubscriptionInfoWithdraw,
        _DeleteSubscriberDataArg_extensionContainer,
        _DeleteSubscriberDataArg_gprsSubscriptionDataWithdraw,
        _DeleteSubscriberDataArg_roamingRestrictedInSgsnDueToUnsuppportedFeature,
        _DeleteSubscriberDataArg_lsaInformationWithdraw,
        _DeleteSubscriberDataArg_gmlc_ListWithdraw,
        _DeleteSubscriberDataArg_istInformationWithdraw,
        _DeleteSubscriberDataArg_specificCSI_Withdraw,
        _DeleteSubscriberDataArg_chargingCharacteristicsWithdraw,
        _DeleteSubscriberDataArg_stn_srWithdraw,
        _DeleteSubscriberDataArg_epsSubscriptionDataWithdraw,
        _DeleteSubscriberDataArg_apn_oi_replacementWithdraw,
        _DeleteSubscriberDataArg_csg_SubscriptionDeleted,
        _DeleteSubscriberDataArg_subscribedPeriodicTAU_RAU_TimerWithdraw,
        _DeleteSubscriberDataArg_subscribedPeriodicLAU_TimerWithdraw,
        _DeleteSubscriberDataArg_subscribed_vsrvccWithdraw,
        _DeleteSubscriberDataArg_vplmn_Csg_SubscriptionDeleted,
        _DeleteSubscriberDataArg_additionalMSISDN_Withdraw,
        _DeleteSubscriberDataArg_cs_to_ps_SRVCC_Withdraw,
        _DeleteSubscriberDataArg_imsiGroupIdList_Withdraw,
        _DeleteSubscriberDataArg_userPlaneIntegrityProtectionWithdraw,
        DeleteSubscriberDataArg,
        SpecificCSI_Withdraw,
        _GPRSSubscriptionDataWithdraw_allGPRSData,
        _GPRSSubscriptionDataWithdraw_contextIdList,
        GPRSSubscriptionDataWithdraw,
        _EPS_SubscriptionDataWithdraw_allEPS_Data,
        _EPS_SubscriptionDataWithdraw_contextIdList,
        EPS_SubscriptionDataWithdraw,
        _ContextIdList__item_,
        ContextIdList,
        _LSAInformationWithdraw_allLSAData,
        _LSAInformationWithdraw_lsaIdentityList,
        LSAInformationWithdraw,
        _LSAIdentityList__item_,
        LSAIdentityList,
        _BasicServiceList__item_,
        BasicServiceList,
        maxNumOfBasicServices,
        _DeleteSubscriberDataRes_regionalSubscriptionResponse,
        _DeleteSubscriberDataRes_extensionContainer,
        DeleteSubscriberDataRes,
        _VlrCamelSubscriptionInfo_o_CSI,
        _VlrCamelSubscriptionInfo_extensionContainer,
        _VlrCamelSubscriptionInfo_ss_CSI,
        _VlrCamelSubscriptionInfo_o_BcsmCamelTDP_CriteriaList,
        _VlrCamelSubscriptionInfo_tif_CSI,
        _VlrCamelSubscriptionInfo_m_CSI,
        _VlrCamelSubscriptionInfo_mo_sms_CSI,
        _VlrCamelSubscriptionInfo_vt_CSI,
        _VlrCamelSubscriptionInfo_t_BCSM_CAMEL_TDP_CriteriaList,
        _VlrCamelSubscriptionInfo_d_CSI,
        _VlrCamelSubscriptionInfo_mt_sms_CSI,
        _VlrCamelSubscriptionInfo_mt_smsCAMELTDP_CriteriaList,
        VlrCamelSubscriptionInfo,
        _MT_smsCAMELTDP_CriteriaList__item_,
        MT_smsCAMELTDP_CriteriaList,
        _MT_smsCAMELTDP_Criteria_sms_TriggerDetectionPoint,
        _MT_smsCAMELTDP_Criteria_tpdu_TypeCriterion,
        MT_smsCAMELTDP_Criteria,
        _TPDU_TypeCriterion__item_,
        TPDU_TypeCriterion,
        maxNumOfTPDUTypes,
        MT_SMS_TPDU_Type,
        _D_CSI_dp_AnalysedInfoCriteriaList,
        _D_CSI_camelCapabilityHandling,
        _D_CSI_extensionContainer,
        _D_CSI_notificationToCSE,
        _D_CSI_csi_Active,
        D_CSI,
        _DP_AnalysedInfoCriteriaList__item_,
        DP_AnalysedInfoCriteriaList,
        maxNumOfDP_AnalysedInfoCriteria,
        _DP_AnalysedInfoCriterium_dialledNumber,
        _DP_AnalysedInfoCriterium_serviceKey,
        _DP_AnalysedInfoCriterium_gsmSCF_Address,
        _DP_AnalysedInfoCriterium_defaultCallHandling,
        _DP_AnalysedInfoCriterium_extensionContainer,
        DP_AnalysedInfoCriterium,
        _SS_CSI_ss_CamelData,
        _SS_CSI_extensionContainer,
        _SS_CSI_notificationToCSE,
        _SS_CSI_csi_Active,
        SS_CSI,
        _SS_CamelData_ss_EventList,
        _SS_CamelData_gsmSCF_Address,
        _SS_CamelData_extensionContainer,
        SS_CamelData,
        _SS_EventList__item_,
        SS_EventList,
        maxNumOfCamelSSEvents,
        _O_CSI_o_BcsmCamelTDPDataList,
        _O_CSI_extensionContainer,
        _O_CSI_camelCapabilityHandling,
        _O_CSI_notificationToCSE,
        _O_CSI_csiActive,
        O_CSI,
        _O_BcsmCamelTDPDataList__item_,
        O_BcsmCamelTDPDataList,
        maxNumOfCamelTDPData,
        _O_BcsmCamelTDPData_o_BcsmTriggerDetectionPoint,
        _O_BcsmCamelTDPData_serviceKey,
        _O_BcsmCamelTDPData_gsmSCF_Address,
        _O_BcsmCamelTDPData_defaultCallHandling,
        _O_BcsmCamelTDPData_extensionContainer,
        O_BcsmCamelTDPData,
        ServiceKey,
        O_BcsmTriggerDetectionPoint,
        _O_BcsmCamelTDPCriteriaList__item_,
        O_BcsmCamelTDPCriteriaList,
        _T_BCSM_CAMEL_TDP_CriteriaList__item_,
        T_BCSM_CAMEL_TDP_CriteriaList,
        _O_BcsmCamelTDP_Criteria_o_BcsmTriggerDetectionPoint,
        _O_BcsmCamelTDP_Criteria_destinationNumberCriteria,
        _O_BcsmCamelTDP_Criteria_basicServiceCriteria,
        _O_BcsmCamelTDP_Criteria_callTypeCriteria,
        _O_BcsmCamelTDP_Criteria_o_CauseValueCriteria,
        _O_BcsmCamelTDP_Criteria_extensionContainer,
        O_BcsmCamelTDP_Criteria,
        _T_BCSM_CAMEL_TDP_Criteria_t_BCSM_TriggerDetectionPoint,
        _T_BCSM_CAMEL_TDP_Criteria_basicServiceCriteria,
        _T_BCSM_CAMEL_TDP_Criteria_t_CauseValueCriteria,
        T_BCSM_CAMEL_TDP_Criteria,
        _DestinationNumberCriteria_matchType,
        _DestinationNumberCriteria_destinationNumberList,
        _DestinationNumberCriteria_destinationNumberLengthList,
        DestinationNumberCriteria,
        _DestinationNumberList__item_,
        DestinationNumberList,
        _DestinationNumberLengthList__item_,
        DestinationNumberLengthList,
        _BasicServiceCriteria__item_,
        BasicServiceCriteria,
        maxNumOfISDN_AddressDigits,
        maxNumOfCamelDestinationNumbers,
        maxNumOfCamelDestinationNumberLengths,
        maxNumOfCamelBasicServiceCriteria,
        CallTypeCriteria,
        MatchType,
        _O_CauseValueCriteria__item_,
        O_CauseValueCriteria,
        _T_CauseValueCriteria__item_,
        T_CauseValueCriteria,
        maxNumOfCAMEL_O_CauseValueCriteria,
        maxNumOfCAMEL_T_CauseValueCriteria,
        CauseValue,
        DefaultCallHandling,
        CamelCapabilityHandling,
        SupportedCamelPhases,
        OfferedCamel4CSIs,
        OfferedCamel4Functionalities,
        _SMS_CSI_sms_CAMEL_TDP_DataList,
        _SMS_CSI_camelCapabilityHandling,
        _SMS_CSI_extensionContainer,
        _SMS_CSI_notificationToCSE,
        _SMS_CSI_csi_Active,
        SMS_CSI,
        _SMS_CAMEL_TDP_DataList__item_,
        SMS_CAMEL_TDP_DataList,
        _SMS_CAMEL_TDP_Data_sms_TriggerDetectionPoint,
        _SMS_CAMEL_TDP_Data_serviceKey,
        _SMS_CAMEL_TDP_Data_gsmSCF_Address,
        _SMS_CAMEL_TDP_Data_defaultSMS_Handling,
        _SMS_CAMEL_TDP_Data_extensionContainer,
        SMS_CAMEL_TDP_Data,
        SMS_TriggerDetectionPoint,
        DefaultSMS_Handling,
        _M_CSI_mobilityTriggers,
        _M_CSI_serviceKey,
        _M_CSI_gsmSCF_Address,
        _M_CSI_extensionContainer,
        _M_CSI_notificationToCSE,
        _M_CSI_csi_Active,
        M_CSI,
        _MG_CSI_mobilityTriggers,
        _MG_CSI_serviceKey,
        _MG_CSI_gsmSCF_Address,
        _MG_CSI_extensionContainer,
        _MG_CSI_notificationToCSE,
        _MG_CSI_csi_Active,
        MG_CSI,
        _MobilityTriggers__item_,
        MobilityTriggers,
        maxNumOfMobilityTriggers,
        MM_Code,
        _T_CSI_t_BcsmCamelTDPDataList,
        _T_CSI_extensionContainer,
        _T_CSI_camelCapabilityHandling,
        _T_CSI_notificationToCSE,
        _T_CSI_csi_Active,
        T_CSI,
        _T_BcsmCamelTDPDataList__item_,
        T_BcsmCamelTDPDataList,
        _T_BcsmCamelTDPData_t_BcsmTriggerDetectionPoint,
        _T_BcsmCamelTDPData_serviceKey,
        _T_BcsmCamelTDPData_gsmSCF_Address,
        _T_BcsmCamelTDPData_defaultCallHandling,
        _T_BcsmCamelTDPData_extensionContainer,
        T_BcsmCamelTDPData,
        T_BcsmTriggerDetectionPoint,
        _SendRoutingInfoForGprsArg_imsi,
        _SendRoutingInfoForGprsArg_ggsn_Address,
        _SendRoutingInfoForGprsArg_ggsn_Number,
        _SendRoutingInfoForGprsArg_extensionContainer,
        SendRoutingInfoForGprsArg,
        _SendRoutingInfoForGprsRes_sgsn_Address,
        _SendRoutingInfoForGprsRes_ggsn_Address,
        _SendRoutingInfoForGprsRes_mobileNotReachableReason,
        _SendRoutingInfoForGprsRes_extensionContainer,
        SendRoutingInfoForGprsRes,
        _FailureReportArg_imsi,
        _FailureReportArg_ggsn_Number,
        _FailureReportArg_ggsn_Address,
        _FailureReportArg_extensionContainer,
        FailureReportArg,
        _FailureReportRes_ggsn_Address,
        _FailureReportRes_extensionContainer,
        FailureReportRes,
        _NoteMsPresentForGprsArg_imsi,
        _NoteMsPresentForGprsArg_sgsn_Address,
        _NoteMsPresentForGprsArg_ggsn_Address,
        _NoteMsPresentForGprsArg_extensionContainer,
        NoteMsPresentForGprsArg,
        _NoteMsPresentForGprsRes_extensionContainer,
        NoteMsPresentForGprsRes,
        _ResetArg_sendingNodenumber,
        _ResetArg_hlr_List,
        _ResetArg_extensionContainer,
        ResetArg,
        _SendingNode_Number_hlr_Number,
        _SendingNode_Number_css_Number,
        SendingNode_Number,
        _RestoreDataArg_imsi,
        _RestoreDataArg_lmsi,
        _RestoreDataArg_extensionContainer,
        _RestoreDataArg_vlr_Capability,
        _RestoreDataArg_restorationIndicator,
        RestoreDataArg,
        _RestoreDataRes_hlr_Number,
        _RestoreDataRes_msNotReachable,
        _RestoreDataRes_extensionContainer,
        RestoreDataRes,
        _VBSDataList__item_,
        VBSDataList,
        _VGCSDataList__item_,
        VGCSDataList,
        maxNumOfVBSGroupIds,
        maxNumOfVGCSGroupIds,
        _VoiceGroupCallData_groupId,
        _VoiceGroupCallData_extensionContainer,
        _VoiceGroupCallData_additionalSubscriptions,
        _VoiceGroupCallData_additionalInfo,
        _VoiceGroupCallData_longGroupId,
        VoiceGroupCallData,
        AdditionalInfo,
        AdditionalSubscriptions,
        _VoiceBroadcastData_groupid,
        _VoiceBroadcastData_broadcastInitEntitlement,
        _VoiceBroadcastData_extensionContainer,
        _VoiceBroadcastData_longGroupId,
        VoiceBroadcastData,
        GroupId,
        Long_GroupId,
        _ProvideSubscriberInfoArg_imsi,
        _ProvideSubscriberInfoArg_lmsi,
        _ProvideSubscriberInfoArg_requestedInfo,
        _ProvideSubscriberInfoArg_extensionContainer,
        _ProvideSubscriberInfoArg_callPriority,
        ProvideSubscriberInfoArg,
        _ProvideSubscriberInfoRes_subscriberInfo,
        _ProvideSubscriberInfoRes_extensionContainer,
        ProvideSubscriberInfoRes,
        _SubscriberInfo_locationInformation,
        _SubscriberInfo_subscriberState,
        _SubscriberInfo_extensionContainer,
        _SubscriberInfo_locationInformationGPRS,
        _SubscriberInfo_ps_SubscriberState,
        _SubscriberInfo_imei,
        _SubscriberInfo_ms_Classmark2,
        _SubscriberInfo_gprs_MS_Class,
        _SubscriberInfo_mnpInfoRes,
        _SubscriberInfo_imsVoiceOverPS_SessionsIndication,
        _SubscriberInfo_lastUE_ActivityTime,
        _SubscriberInfo_lastRAT_Type,
        _SubscriberInfo_eps_SubscriberState,
        _SubscriberInfo_locationInformationEPS,
        _SubscriberInfo_timeZone,
        _SubscriberInfo_daylightSavingTime,
        SubscriberInfo,
        IMS_VoiceOverPS_SessionsInd,
        TimeZone,
        DaylightSavingTime,
        _MNPInfoRes_routeingNumber,
        _MNPInfoRes_imsi,
        _MNPInfoRes_msisdn,
        _MNPInfoRes_numberPortabilityStatus,
        _MNPInfoRes_extensionContainer,
        MNPInfoRes,
        RouteingNumber,
        NumberPortabilityStatus,
        MS_Classmark2,
        _GPRSMSClass_mSNetworkCapability,
        _GPRSMSClass_mSRadioAccessCapability,
        GPRSMSClass,
        MSNetworkCapability,
        MSRadioAccessCapability,
        _RequestedInfo_locationInformation,
        _RequestedInfo_subscriberState,
        _RequestedInfo_extensionContainer,
        _RequestedInfo_currentLocation,
        _RequestedInfo_requestedDomain,
        _RequestedInfo_imei,
        _RequestedInfo_ms_classmark,
        _RequestedInfo_mnpRequestedInfo,
        _RequestedInfo_locationInformationEPS_Supported,
        _RequestedInfo_t_adsData,
        _RequestedInfo_requestedNodes,
        _RequestedInfo_servingNodeIndication,
        _RequestedInfo_localTimeZoneRequest,
        RequestedInfo,
        DomainType,
        RequestedNodes,
        _LocationInformation_ageOfLocationInformation,
        _LocationInformation_geographicalInformation,
        _LocationInformation_vlr_number,
        _LocationInformation_locationNumber,
        _LocationInformation_cellGlobalIdOrServiceAreaIdOrLAI,
        _LocationInformation_extensionContainer,
        _LocationInformation_selectedLSA_Id,
        _LocationInformation_msc_Number,
        _LocationInformation_geodeticInformation,
        _LocationInformation_currentLocationRetrieved,
        _LocationInformation_sai_Present,
        _LocationInformation_locationInformationEPS,
        _LocationInformation_userCSGInformation,
        LocationInformation,
        _LocationInformationEPS_e_utranCellGlobalIdentity,
        _LocationInformationEPS_trackingAreaIdentity,
        _LocationInformationEPS_extensionContainer,
        _LocationInformationEPS_geographicalInformation,
        _LocationInformationEPS_geodeticInformation,
        _LocationInformationEPS_currentLocationRetrieved,
        _LocationInformationEPS_ageOfLocationInformation,
        _LocationInformationEPS_mme_Name,
        LocationInformationEPS,
        _LocationInformationGPRS_cellGlobalIdOrServiceAreaIdOrLAI,
        _LocationInformationGPRS_routeingAreaIdentity,
        _LocationInformationGPRS_geographicalInformation,
        _LocationInformationGPRS_sgsn_Number,
        _LocationInformationGPRS_selectedLSAIdentity,
        _LocationInformationGPRS_extensionContainer,
        _LocationInformationGPRS_sai_Present,
        _LocationInformationGPRS_geodeticInformation,
        _LocationInformationGPRS_currentLocationRetrieved,
        _LocationInformationGPRS_ageOfLocationInformation,
        _LocationInformationGPRS_userCSGInformation,
        LocationInformationGPRS,
        _UserCSGInformation_csg_Id,
        _UserCSGInformation_extensionContainer,
        _UserCSGInformation_accessMode,
        _UserCSGInformation_cmi,
        UserCSGInformation,
        GeographicalInformation,
        GeodeticInformation,
        LocationNumber,
        _SubscriberState_assumedIdle,
        _SubscriberState_camelBusy,
        _SubscriberState_netDetNotReachable,
        _SubscriberState_notProvidedFromVLR,
        SubscriberState,
        _PS_SubscriberState_notProvidedFromSGSNorMME,
        _PS_SubscriberState_ps_Detached,
        _PS_SubscriberState_ps_AttachedNotReachableForPaging,
        _PS_SubscriberState_ps_AttachedReachableForPaging,
        _PS_SubscriberState_ps_PDP_ActiveNotReachableForPaging,
        _PS_SubscriberState_ps_PDP_ActiveReachableForPaging,
        _PS_SubscriberState_netDetNotReachable,
        PS_SubscriberState,
        _PDP_ContextInfoList__item_,
        PDP_ContextInfoList,
        _PDP_ContextInfo_pdp_ContextIdentifier,
        _PDP_ContextInfo_pdp_ContextActive,
        _PDP_ContextInfo_pdp_Type,
        _PDP_ContextInfo_pdp_Address,
        _PDP_ContextInfo_apn_Subscribed,
        _PDP_ContextInfo_apn_InUse,
        _PDP_ContextInfo_nsapi,
        _PDP_ContextInfo_transactionId,
        _PDP_ContextInfo_teid_ForGnAndGp,
        _PDP_ContextInfo_teid_ForIu,
        _PDP_ContextInfo_ggsn_Address,
        _PDP_ContextInfo_qos_Subscribed,
        _PDP_ContextInfo_qos_Requested,
        _PDP_ContextInfo_qos_Negotiated,
        _PDP_ContextInfo_chargingId,
        _PDP_ContextInfo_chargingCharacteristics,
        _PDP_ContextInfo_rnc_Address,
        _PDP_ContextInfo_extensionContainer,
        _PDP_ContextInfo_qos2_Subscribed,
        _PDP_ContextInfo_qos2_Requested,
        _PDP_ContextInfo_qos2_Negotiated,
        _PDP_ContextInfo_qos3_Subscribed,
        _PDP_ContextInfo_qos3_Requested,
        _PDP_ContextInfo_qos3_Negotiated,
        _PDP_ContextInfo_qos4_Subscribed,
        _PDP_ContextInfo_qos4_Requested,
        _PDP_ContextInfo_qos4_Negotiated,
        _PDP_ContextInfo_ext_pdp_Type,
        _PDP_ContextInfo_ext_pdp_Address,
        PDP_ContextInfo,
        NSAPI,
        TransactionId,
        TEID,
        GPRSChargingID,
        NotReachableReason,
        _AnyTimeInterrogationArg_subscriberIdentity,
        _AnyTimeInterrogationArg_requestedInfo,
        _AnyTimeInterrogationArg_gsmSCF_Address,
        _AnyTimeInterrogationArg_extensionContainer,
        AnyTimeInterrogationArg,
        _AnyTimeInterrogationRes_subscriberInfo,
        _AnyTimeInterrogationRes_extensionContainer,
        AnyTimeInterrogationRes,
        _AnyTimeSubscriptionInterrogationArg_subscriberIdentity,
        _AnyTimeSubscriptionInterrogationArg_requestedSubscriptionInfo,
        _AnyTimeSubscriptionInterrogationArg_gsmSCF_Address,
        _AnyTimeSubscriptionInterrogationArg_extensionContainer,
        _AnyTimeSubscriptionInterrogationArg_longFTN_Supported,
        AnyTimeSubscriptionInterrogationArg,
        _AnyTimeSubscriptionInterrogationRes_callForwardingData,
        _AnyTimeSubscriptionInterrogationRes_callBarringData,
        _AnyTimeSubscriptionInterrogationRes_odb_Info,
        _AnyTimeSubscriptionInterrogationRes_camel_SubscriptionInfo,
        _AnyTimeSubscriptionInterrogationRes_supportedVLR_CAMEL_Phases,
        _AnyTimeSubscriptionInterrogationRes_supportedSGSN_CAMEL_Phases,
        _AnyTimeSubscriptionInterrogationRes_extensionContainer,
        _AnyTimeSubscriptionInterrogationRes_offeredCamel4CSIsInVLR,
        _AnyTimeSubscriptionInterrogationRes_offeredCamel4CSIsInSGSN,
        _AnyTimeSubscriptionInterrogationRes_msisdn_BS_List,
        _AnyTimeSubscriptionInterrogationRes_csg_SubscriptionDataList,
        _AnyTimeSubscriptionInterrogationRes_cw_Data,
        _AnyTimeSubscriptionInterrogationRes_ch_Data,
        _AnyTimeSubscriptionInterrogationRes_clip_Data,
        _AnyTimeSubscriptionInterrogationRes_clir_Data,
        _AnyTimeSubscriptionInterrogationRes_ect_data,
        AnyTimeSubscriptionInterrogationRes,
        _CallWaitingData_cwFeatureList,
        _CallWaitingData_notificationToCSE,
        CallWaitingData,
        _Ext_CwFeatureList__item_,
        Ext_CwFeatureList,
        _Ext_CwFeature_basicService,
        _Ext_CwFeature_ss_Status,
        Ext_CwFeature,
        _ClipData_ss_Status,
        _ClipData_overrideCategory,
        _ClipData_notificationToCSE,
        ClipData,
        _ClirData_ss_Status,
        _ClirData_cliRestrictionOption,
        _ClirData_notificationToCSE,
        ClirData,
        _CallHoldData_ss_Status,
        _CallHoldData_notificationToCSE,
        CallHoldData,
        _EctData_ss_Status,
        _EctData_notificationToCSE,
        EctData,
        _RequestedSubscriptionInfo_requestedSS_Info,
        _RequestedSubscriptionInfo_odb,
        _RequestedSubscriptionInfo_requestedCAMEL_SubscriptionInfo,
        _RequestedSubscriptionInfo_supportedVLR_CAMEL_Phases,
        _RequestedSubscriptionInfo_supportedSGSN_CAMEL_Phases,
        _RequestedSubscriptionInfo_extensionContainer,
        _RequestedSubscriptionInfo_additionalRequestedCAMEL_SubscriptionInfo,
        _RequestedSubscriptionInfo_msisdn_BS_List,
        _RequestedSubscriptionInfo_csg_SubscriptionDataRequested,
        _RequestedSubscriptionInfo_cw_Info,
        _RequestedSubscriptionInfo_clip_Info,
        _RequestedSubscriptionInfo_clir_Info,
        _RequestedSubscriptionInfo_hold_Info,
        _RequestedSubscriptionInfo_ect_Info,
        RequestedSubscriptionInfo,
        _MSISDN_BS_List__item_,
        MSISDN_BS_List,
        maxNumOfMSISDN,
        _MSISDN_BS_msisdn,
        _MSISDN_BS_basicServiceList,
        _MSISDN_BS_extensionContainer,
        MSISDN_BS,
        RequestedCAMEL_SubscriptionInfo,
        AdditionalRequestedCAMEL_SubscriptionInfo,
        _CallForwardingData_forwardingFeatureList,
        _CallForwardingData_notificationToCSE,
        _CallForwardingData_extensionContainer,
        CallForwardingData,
        _CallBarringData_callBarringFeatureList,
        _CallBarringData_password,
        _CallBarringData_wrongPasswordAttemptsCounter,
        _CallBarringData_notificationToCSE,
        _CallBarringData_extensionContainer,
        CallBarringData,
        WrongPasswordAttemptsCounter,
        _ODB_Info_odb_Data,
        _ODB_Info_notificationToCSE,
        _ODB_Info_extensionContainer,
        ODB_Info,
        _CAMEL_SubscriptionInfo_o_CSI,
        _CAMEL_SubscriptionInfo_o_BcsmCamelTDP_CriteriaList,
        _CAMEL_SubscriptionInfo_d_CSI,
        _CAMEL_SubscriptionInfo_t_CSI,
        _CAMEL_SubscriptionInfo_t_BCSM_CAMEL_TDP_CriteriaList,
        _CAMEL_SubscriptionInfo_vt_CSI,
        _CAMEL_SubscriptionInfo_vt_BCSM_CAMEL_TDP_CriteriaList,
        _CAMEL_SubscriptionInfo_tif_CSI,
        _CAMEL_SubscriptionInfo_tif_CSI_NotificationToCSE,
        _CAMEL_SubscriptionInfo_gprs_CSI,
        _CAMEL_SubscriptionInfo_mo_sms_CSI,
        _CAMEL_SubscriptionInfo_ss_CSI,
        _CAMEL_SubscriptionInfo_m_CSI,
        _CAMEL_SubscriptionInfo_extensionContainer,
        _CAMEL_SubscriptionInfo_specificCSIDeletedList,
        _CAMEL_SubscriptionInfo_mt_sms_CSI,
        _CAMEL_SubscriptionInfo_mt_smsCAMELTDP_CriteriaList,
        _CAMEL_SubscriptionInfo_mg_csi,
        _CAMEL_SubscriptionInfo_o_IM_CSI,
        _CAMEL_SubscriptionInfo_o_IM_BcsmCamelTDP_CriteriaList,
        _CAMEL_SubscriptionInfo_d_IM_CSI,
        _CAMEL_SubscriptionInfo_vt_IM_CSI,
        _CAMEL_SubscriptionInfo_vt_IM_BCSM_CAMEL_TDP_CriteriaList,
        CAMEL_SubscriptionInfo,
        _AnyTimeModificationArg_subscriberIdentity,
        _AnyTimeModificationArg_gsmSCF_Address,
        _AnyTimeModificationArg_modificationRequestFor_CF_Info,
        _AnyTimeModificationArg_modificationRequestFor_CB_Info,
        _AnyTimeModificationArg_modificationRequestFor_CSI,
        _AnyTimeModificationArg_extensionContainer,
        _AnyTimeModificationArg_longFTN_Supported,
        _AnyTimeModificationArg_modificationRequestFor_ODB_data,
        _AnyTimeModificationArg_modificationRequestFor_IP_SM_GW_Data,
        _AnyTimeModificationArg_activationRequestForUE_reachability,
        _AnyTimeModificationArg_modificationRequestFor_CSG,
        _AnyTimeModificationArg_modificationRequestFor_CW_Data,
        _AnyTimeModificationArg_modificationRequestFor_CLIP_Data,
        _AnyTimeModificationArg_modificationRequestFor_CLIR_Data,
        _AnyTimeModificationArg_modificationRequestFor_HOLD_Data,
        _AnyTimeModificationArg_modificationRequestFor_ECT_Data,
        AnyTimeModificationArg,
        _ModificationRequestFor_CW_Info_basicService,
        _ModificationRequestFor_CW_Info_ss_Status,
        _ModificationRequestFor_CW_Info_modifyNotificationToCSE,
        _ModificationRequestFor_CW_Info_extensionContainer,
        ModificationRequestFor_CW_Info,
        _ModificationRequestFor_CH_Info_ss_Status,
        _ModificationRequestFor_CH_Info_modifyNotificationToCSE,
        _ModificationRequestFor_CH_Info_extensionContainer,
        ModificationRequestFor_CH_Info,
        _ModificationRequestFor_ECT_Info_ss_Status,
        _ModificationRequestFor_ECT_Info_modifyNotificationToCSE,
        _ModificationRequestFor_ECT_Info_extensionContainer,
        ModificationRequestFor_ECT_Info,
        _ModificationRequestFor_CLIR_Info_ss_Status,
        _ModificationRequestFor_CLIR_Info_cliRestrictionOption,
        _ModificationRequestFor_CLIR_Info_modifyNotificationToCSE,
        _ModificationRequestFor_CLIR_Info_extensionContainer,
        ModificationRequestFor_CLIR_Info,
        _ModificationRequestFor_CLIP_Info_ss_Status,
        _ModificationRequestFor_CLIP_Info_overrideCategory,
        _ModificationRequestFor_CLIP_Info_modifyNotificationToCSE,
        _ModificationRequestFor_CLIP_Info_extensionContainer,
        ModificationRequestFor_CLIP_Info,
        _ModificationRequestFor_CSG_modifyNotificationToCSE,
        _ModificationRequestFor_CSG_extensionContainer,
        ModificationRequestFor_CSG,
        RequestedServingNode,
        ServingNode,
        _AnyTimeModificationRes_ss_InfoFor_CSE,
        _AnyTimeModificationRes_camel_SubscriptionInfo,
        _AnyTimeModificationRes_extensionContainer,
        _AnyTimeModificationRes_odb_Info,
        _AnyTimeModificationRes_cw_Data,
        _AnyTimeModificationRes_ch_Data,
        _AnyTimeModificationRes_clip_Data,
        _AnyTimeModificationRes_clir_Data,
        _AnyTimeModificationRes_ect_data,
        _AnyTimeModificationRes_serviceCentreAddress,
        AnyTimeModificationRes,
        _ModificationRequestFor_CF_Info_ss_Code,
        _ModificationRequestFor_CF_Info_basicService,
        _ModificationRequestFor_CF_Info_ss_Status,
        _ModificationRequestFor_CF_Info_forwardedToNumber,
        _ModificationRequestFor_CF_Info_forwardedToSubaddress,
        _ModificationRequestFor_CF_Info_noReplyConditionTime,
        _ModificationRequestFor_CF_Info_modifyNotificationToCSE,
        _ModificationRequestFor_CF_Info_extensionContainer,
        ModificationRequestFor_CF_Info,
        _ModificationRequestFor_CB_Info_ss_Code,
        _ModificationRequestFor_CB_Info_basicService,
        _ModificationRequestFor_CB_Info_ss_Status,
        _ModificationRequestFor_CB_Info_password,
        _ModificationRequestFor_CB_Info_wrongPasswordAttemptsCounter,
        _ModificationRequestFor_CB_Info_modifyNotificationToCSE,
        _ModificationRequestFor_CB_Info_extensionContainer,
        ModificationRequestFor_CB_Info,
        _ModificationRequestFor_ODB_data_odb_data,
        _ModificationRequestFor_ODB_data_modifyNotificationToCSE,
        _ModificationRequestFor_ODB_data_extensionContainer,
        ModificationRequestFor_ODB_data,
        _ModificationRequestFor_CSI_requestedCamel_SubscriptionInfo,
        _ModificationRequestFor_CSI_modifyNotificationToCSE,
        _ModificationRequestFor_CSI_modifyCSI_State,
        _ModificationRequestFor_CSI_extensionContainer,
        _ModificationRequestFor_CSI_additionalRequestedCAMEL_SubscriptionInfo,
        ModificationRequestFor_CSI,
        _ModificationRequestFor_IP_SM_GW_Data_modifyRegistrationStatus,
        _ModificationRequestFor_IP_SM_GW_Data_extensionContainer,
        _ModificationRequestFor_IP_SM_GW_Data_ip_sm_gw_DiameterAddress,
        ModificationRequestFor_IP_SM_GW_Data,
        ModificationInstruction,
        _NoteSubscriberDataModifiedArg_imsi,
        _NoteSubscriberDataModifiedArg_msisdn,
        _NoteSubscriberDataModifiedArg_forwardingInfoFor_CSE,
        _NoteSubscriberDataModifiedArg_callBarringInfoFor_CSE,
        _NoteSubscriberDataModifiedArg_odb_Info,
        _NoteSubscriberDataModifiedArg_camel_SubscriptionInfo,
        _NoteSubscriberDataModifiedArg_allInformationSent,
        _NoteSubscriberDataModifiedArg_extensionContainer,
        _NoteSubscriberDataModifiedArg_ue_reachable,
        _NoteSubscriberDataModifiedArg_csg_SubscriptionDataList,
        _NoteSubscriberDataModifiedArg_cw_Data,
        _NoteSubscriberDataModifiedArg_ch_Data,
        _NoteSubscriberDataModifiedArg_clip_Data,
        _NoteSubscriberDataModifiedArg_clir_Data,
        _NoteSubscriberDataModifiedArg_ect_data,
        NoteSubscriberDataModifiedArg,
        _NoteSubscriberDataModifiedRes_extensionContainer,
        NoteSubscriberDataModifiedRes,
        _NoteMM_EventArg_serviceKey,
        _NoteMM_EventArg_eventMet,
        _NoteMM_EventArg_imsi,
        _NoteMM_EventArg_msisdn,
        _NoteMM_EventArg_locationInformation,
        _NoteMM_EventArg_supportedCAMELPhases,
        _NoteMM_EventArg_extensionContainer,
        _NoteMM_EventArg_locationInformationGPRS,
        _NoteMM_EventArg_offeredCamel4Functionalities,
        NoteMM_EventArg,
        _NoteMM_EventRes_extensionContainer,
        NoteMM_EventRes,
        _Ext_SS_InfoFor_CSE_forwardingInfoFor_CSE,
        _Ext_SS_InfoFor_CSE_callBarringInfoFor_CSE,
        Ext_SS_InfoFor_CSE,
        _Ext_ForwardingInfoFor_CSE_ss_Code,
        _Ext_ForwardingInfoFor_CSE_forwardingFeatureList,
        _Ext_ForwardingInfoFor_CSE_notificationToCSE,
        _Ext_ForwardingInfoFor_CSE_extensionContainer,
        Ext_ForwardingInfoFor_CSE,
        _Ext_CallBarringInfoFor_CSE_ss_Code,
        _Ext_CallBarringInfoFor_CSE_callBarringFeatureList,
        _Ext_CallBarringInfoFor_CSE_password,
        _Ext_CallBarringInfoFor_CSE_wrongPasswordAttemptsCounter,
        _Ext_CallBarringInfoFor_CSE_notificationToCSE,
        _Ext_CallBarringInfoFor_CSE_extensionContainer,
        Ext_CallBarringInfoFor_CSE,
        _UpdateVcsgLocationArg_imsi,
        _UpdateVcsgLocationArg_msisdn,
        _UpdateVcsgLocationArg_vlr_Number,
        _UpdateVcsgLocationArg_sgsn_Number,
        _UpdateVcsgLocationArg_extensionContainer,
        UpdateVcsgLocationArg,
        _UpdateVcsgLocationRes_temporaryEmptySubscriptiondataIndicator,
        _UpdateVcsgLocationRes_extensionContainer,
        UpdateVcsgLocationRes,
        _CancelVcsgLocationArg_identity,
        _CancelVcsgLocationArg_extensionContainer,
        CancelVcsgLocationArg,
        _CancelVcsgLocationRes_extensionContainer,
        CancelVcsgLocationRes,
    ]

class MAP_OM_DataTypes:

    _name_  = u'MAP-OM-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 12, 16]
    
    _obj_ = [
        u'ActivateTraceModeArg',
        u'MDT-Configuration',
        u'MDT-Allowed-PLMNId-List',
        u'PeriodUMTS',
        u'PeriodLTE',
        u'PositioningMethod',
        u'MeasurementQuantity',
        u'EventThreshold1F',
        u'EventThreshold1I',
        u'JobType',
        u'AreaScope',
        u'CGI-List',
        u'E-UTRAN-CGI-List',
        u'RoutingAreaId-List',
        u'LocationAreaId-List',
        u'TrackingAreaId-List',
        u'ListOfMeasurements',
        u'ReportingTrigger',
        u'ReportInterval',
        u'ReportAmount',
        u'EventThresholdRSRP',
        u'EventThresholdRSRQ',
        u'LoggingInterval',
        u'LoggingDuration',
        u'TraceReference',
        u'TraceReference2',
        u'TraceRecordingSessionReference',
        u'TraceType',
        u'TraceDepthList',
        u'TraceDepth',
        u'TraceDepthExtension',
        u'TraceNE-TypeList',
        u'TraceInterfaceList',
        u'MSC-S-InterfaceList',
        u'MGW-InterfaceList',
        u'SGSN-InterfaceList',
        u'GGSN-InterfaceList',
        u'RNC-InterfaceList',
        u'BMSC-InterfaceList',
        u'MME-InterfaceList',
        u'SGW-InterfaceList',
        u'PGW-InterfaceList',
        u'ENB-InterfaceList',
        u'TraceEventList',
        u'MSC-S-EventList',
        u'MGW-EventList',
        u'SGSN-EventList',
        u'GGSN-EventList',
        u'BMSC-EventList',
        u'MME-EventList',
        u'SGW-EventList',
        u'PGW-EventList',
        u'TracePropagationList',
        u'ActivateTraceModeRes',
        u'DeactivateTraceModeArg',
        u'DeactivateTraceModeRes',
        ]
    _type_ = [
        u'ActivateTraceModeArg',
        u'MDT-Configuration',
        u'MDT-Allowed-PLMNId-List',
        u'PeriodUMTS',
        u'PeriodLTE',
        u'PositioningMethod',
        u'MeasurementQuantity',
        u'EventThreshold1F',
        u'EventThreshold1I',
        u'JobType',
        u'AreaScope',
        u'CGI-List',
        u'E-UTRAN-CGI-List',
        u'RoutingAreaId-List',
        u'LocationAreaId-List',
        u'TrackingAreaId-List',
        u'ListOfMeasurements',
        u'ReportingTrigger',
        u'ReportInterval',
        u'ReportAmount',
        u'EventThresholdRSRP',
        u'EventThresholdRSRQ',
        u'LoggingInterval',
        u'LoggingDuration',
        u'TraceReference',
        u'TraceReference2',
        u'TraceRecordingSessionReference',
        u'TraceType',
        u'TraceDepthList',
        u'TraceDepth',
        u'TraceDepthExtension',
        u'TraceNE-TypeList',
        u'TraceInterfaceList',
        u'MSC-S-InterfaceList',
        u'MGW-InterfaceList',
        u'SGSN-InterfaceList',
        u'GGSN-InterfaceList',
        u'RNC-InterfaceList',
        u'BMSC-InterfaceList',
        u'MME-InterfaceList',
        u'SGW-InterfaceList',
        u'PGW-InterfaceList',
        u'ENB-InterfaceList',
        u'TraceEventList',
        u'MSC-S-EventList',
        u'MGW-EventList',
        u'SGSN-EventList',
        u'GGSN-EventList',
        u'BMSC-EventList',
        u'MME-EventList',
        u'SGW-EventList',
        u'PGW-EventList',
        u'TracePropagationList',
        u'ActivateTraceModeRes',
        u'DeactivateTraceModeArg',
        u'DeactivateTraceModeRes',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< ActivateTraceModeArg >-----#
    ActivateTraceModeArg = SEQ(name=u'ActivateTraceModeArg', mode=MODE_TYPE)
    _ActivateTraceModeArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    _ActivateTraceModeArg_traceReference = OCT_STR(name=u'traceReference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceReference')))
    _ActivateTraceModeArg_traceType = INT(name=u'traceType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceType')))
    _ActivateTraceModeArg_omc_Id = OCT_STR(name=u'omc-Id', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AddressString')), opt=True)
    _ActivateTraceModeArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ActivateTraceModeArg_traceReference2 = OCT_STR(name=u'traceReference2', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceReference2')), opt=True)
    _ActivateTraceModeArg_traceDepthList = SEQ(name=u'traceDepthList', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthList')), opt=True)
    _ActivateTraceModeArg_traceNE_TypeList = BIT_STR(name=u'traceNE-TypeList', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceNE-TypeList')), opt=True)
    _ActivateTraceModeArg_traceInterfaceList = SEQ(name=u'traceInterfaceList', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceInterfaceList')), opt=True)
    _ActivateTraceModeArg_traceEventList = SEQ(name=u'traceEventList', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceEventList')), opt=True)
    _ActivateTraceModeArg_traceCollectionEntity = OCT_STR(name=u'traceCollectionEntity', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'GSN-Address')), opt=True)
    _ActivateTraceModeArg_mdt_Configuration = SEQ(name=u'mdt-Configuration', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MDT-Configuration')), opt=True)
    ActivateTraceModeArg._cont = ASN1Dict([
        (u'imsi', _ActivateTraceModeArg_imsi),
        (u'traceReference', _ActivateTraceModeArg_traceReference),
        (u'traceType', _ActivateTraceModeArg_traceType),
        (u'omc-Id', _ActivateTraceModeArg_omc_Id),
        (u'extensionContainer', _ActivateTraceModeArg_extensionContainer),
        (u'traceReference2', _ActivateTraceModeArg_traceReference2),
        (u'traceDepthList', _ActivateTraceModeArg_traceDepthList),
        (u'traceNE-TypeList', _ActivateTraceModeArg_traceNE_TypeList),
        (u'traceInterfaceList', _ActivateTraceModeArg_traceInterfaceList),
        (u'traceEventList', _ActivateTraceModeArg_traceEventList),
        (u'traceCollectionEntity', _ActivateTraceModeArg_traceCollectionEntity),
        (u'mdt-Configuration', _ActivateTraceModeArg_mdt_Configuration),
        ])
    ActivateTraceModeArg._ext = [u'traceReference2', u'traceDepthList', u'traceNE-TypeList', u'traceInterfaceList', u'traceEventList', u'traceCollectionEntity', u'mdt-Configuration']
    
    #-----< MDT-Configuration >-----#
    MDT_Configuration = SEQ(name=u'MDT-Configuration', mode=MODE_TYPE)
    _MDT_Configuration_jobType = ENUM(name=u'jobType', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-OM-DataTypes', 'JobType')))
    _MDT_Configuration_areaScope = SEQ(name=u'areaScope', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-OM-DataTypes', 'AreaScope')), opt=True)
    _MDT_Configuration_listOfMeasurements = OCT_STR(name=u'listOfMeasurements', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-OM-DataTypes', 'ListOfMeasurements')), opt=True)
    _MDT_Configuration_reportingTrigger = OCT_STR(name=u'reportingTrigger', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'ReportingTrigger')), opt=True)
    _MDT_Configuration_reportInterval = ENUM(name=u'reportInterval', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-OM-DataTypes', 'ReportInterval')), opt=True)
    _MDT_Configuration_reportAmount = ENUM(name=u'reportAmount', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'ReportAmount')), opt=True)
    _MDT_Configuration_eventThresholdRSRP = INT(name=u'eventThresholdRSRP', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-OM-DataTypes', 'EventThresholdRSRP')), opt=True)
    _MDT_Configuration_eventThresholdRSRQ = INT(name=u'eventThresholdRSRQ', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'EventThresholdRSRQ')), opt=True)
    _MDT_Configuration_loggingInterval = ENUM(name=u'loggingInterval', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'LoggingInterval')), opt=True)
    _MDT_Configuration_loggingDuration = ENUM(name=u'loggingDuration', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'LoggingDuration')), opt=True)
    _MDT_Configuration_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _MDT_Configuration_measurementPeriodUMTS = ENUM(name=u'measurementPeriodUMTS', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'PeriodUMTS')), opt=True)
    _MDT_Configuration_measurementPeriodLTE = ENUM(name=u'measurementPeriodLTE', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'PeriodLTE')), opt=True)
    _MDT_Configuration_collectionPeriodRRM_UMTS = ENUM(name=u'collectionPeriodRRM-UMTS', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'PeriodUMTS')), opt=True)
    _MDT_Configuration_collectionPeriodRRM_LTE = ENUM(name=u'collectionPeriodRRM-LTE', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'PeriodLTE')), opt=True)
    _MDT_Configuration_positioningMethod = OCT_STR(name=u'positioningMethod', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'PositioningMethod')), opt=True)
    _MDT_Configuration_measurementQuantity = OCT_STR(name=u'measurementQuantity', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MeasurementQuantity')), opt=True)
    _MDT_Configuration_eventThreshold1F = INT(name=u'eventThreshold1F', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'EventThreshold1F')), opt=True)
    _MDT_Configuration_eventThreshold1I = INT(name=u'eventThreshold1I', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'EventThreshold1I')), opt=True)
    _MDT_Configuration_mdt_Allowed_PLMN_List = SEQ_OF(name=u'mdt-Allowed-PLMN-List', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MDT-Allowed-PLMNId-List')), opt=True)
    MDT_Configuration._cont = ASN1Dict([
        (u'jobType', _MDT_Configuration_jobType),
        (u'areaScope', _MDT_Configuration_areaScope),
        (u'listOfMeasurements', _MDT_Configuration_listOfMeasurements),
        (u'reportingTrigger', _MDT_Configuration_reportingTrigger),
        (u'reportInterval', _MDT_Configuration_reportInterval),
        (u'reportAmount', _MDT_Configuration_reportAmount),
        (u'eventThresholdRSRP', _MDT_Configuration_eventThresholdRSRP),
        (u'eventThresholdRSRQ', _MDT_Configuration_eventThresholdRSRQ),
        (u'loggingInterval', _MDT_Configuration_loggingInterval),
        (u'loggingDuration', _MDT_Configuration_loggingDuration),
        (u'extensionContainer', _MDT_Configuration_extensionContainer),
        (u'measurementPeriodUMTS', _MDT_Configuration_measurementPeriodUMTS),
        (u'measurementPeriodLTE', _MDT_Configuration_measurementPeriodLTE),
        (u'collectionPeriodRRM-UMTS', _MDT_Configuration_collectionPeriodRRM_UMTS),
        (u'collectionPeriodRRM-LTE', _MDT_Configuration_collectionPeriodRRM_LTE),
        (u'positioningMethod', _MDT_Configuration_positioningMethod),
        (u'measurementQuantity', _MDT_Configuration_measurementQuantity),
        (u'eventThreshold1F', _MDT_Configuration_eventThreshold1F),
        (u'eventThreshold1I', _MDT_Configuration_eventThreshold1I),
        (u'mdt-Allowed-PLMN-List', _MDT_Configuration_mdt_Allowed_PLMN_List),
        ])
    MDT_Configuration._ext = [u'measurementPeriodUMTS', u'measurementPeriodLTE', u'collectionPeriodRRM-UMTS', u'collectionPeriodRRM-LTE', u'positioningMethod', u'measurementQuantity', u'eventThreshold1F', u'eventThreshold1I', u'mdt-Allowed-PLMN-List']
    
    #-----< MDT-Allowed-PLMNId-List >-----#
    MDT_Allowed_PLMNId_List = SEQ_OF(name=u'MDT-Allowed-PLMNId-List', mode=MODE_TYPE)
    _MDT_Allowed_PLMNId_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'PLMN-Id')))
    MDT_Allowed_PLMNId_List._cont = _MDT_Allowed_PLMNId_List__item_
    MDT_Allowed_PLMNId_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=16)], ev=None, er=[])
    
    #-----< PeriodUMTS >-----#
    PeriodUMTS = ENUM(name=u'PeriodUMTS', mode=MODE_TYPE)
    PeriodUMTS._cont = ASN1Dict([(u'd250ms', 0), (u'd500ms', 1), (u'd1000ms', 2), (u'd2000ms', 3), (u'd3000ms', 4), (u'd4000ms', 5), (u'd6000ms', 6), (u'd8000ms', 7), (u'd12000ms', 8), (u'd16000ms', 9), (u'd20000ms', 10), (u'd24000ms', 11), (u'd28000ms', 12), (u'd32000ms', 13), (u'd64000ms', 14)])
    PeriodUMTS._ext = None
    
    #-----< PeriodLTE >-----#
    PeriodLTE = ENUM(name=u'PeriodLTE', mode=MODE_TYPE)
    PeriodLTE._cont = ASN1Dict([(u'd1024ms', 0), (u'd1280ms', 1), (u'd2048ms', 2), (u'd2560ms', 3), (u'd5120ms', 4), (u'd10240ms', 5), (u'd1min', 6)])
    PeriodLTE._ext = None
    
    #-----< PositioningMethod >-----#
    PositioningMethod = OCT_STR(name=u'PositioningMethod', mode=MODE_TYPE)
    PositioningMethod._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< MeasurementQuantity >-----#
    MeasurementQuantity = OCT_STR(name=u'MeasurementQuantity', mode=MODE_TYPE)
    MeasurementQuantity._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< EventThreshold1F >-----#
    EventThreshold1F = INT(name=u'EventThreshold1F', mode=MODE_TYPE)
    EventThreshold1F._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-120, ub=165)], ev=None, er=[])
    
    #-----< EventThreshold1I >-----#
    EventThreshold1I = INT(name=u'EventThreshold1I', mode=MODE_TYPE)
    EventThreshold1I._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-120, ub=-25)], ev=None, er=[])
    
    #-----< JobType >-----#
    JobType = ENUM(name=u'JobType', mode=MODE_TYPE)
    JobType._cont = ASN1Dict([(u'immediate-MDT-only', 0), (u'logged-MDT-only', 1), (u'trace-only', 2), (u'immediate-MDT-and-trace', 3)])
    JobType._ext = None
    
    #-----< AreaScope >-----#
    AreaScope = SEQ(name=u'AreaScope', mode=MODE_TYPE)
    _AreaScope_cgi_List = SEQ_OF(name=u'cgi-List', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'CGI-List')), opt=True)
    _AreaScope_e_utran_cgi_List = SEQ_OF(name=u'e-utran-cgi-List', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'E-UTRAN-CGI-List')), opt=True)
    _AreaScope_routingAreaId_List = SEQ_OF(name=u'routingAreaId-List', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'RoutingAreaId-List')), opt=True)
    _AreaScope_locationAreaId_List = SEQ_OF(name=u'locationAreaId-List', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'LocationAreaId-List')), opt=True)
    _AreaScope_trackingAreaId_List = SEQ_OF(name=u'trackingAreaId-List', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TrackingAreaId-List')), opt=True)
    _AreaScope_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    AreaScope._cont = ASN1Dict([
        (u'cgi-List', _AreaScope_cgi_List),
        (u'e-utran-cgi-List', _AreaScope_e_utran_cgi_List),
        (u'routingAreaId-List', _AreaScope_routingAreaId_List),
        (u'locationAreaId-List', _AreaScope_locationAreaId_List),
        (u'trackingAreaId-List', _AreaScope_trackingAreaId_List),
        (u'extensionContainer', _AreaScope_extensionContainer),
        ])
    AreaScope._ext = []
    
    #-----< CGI-List >-----#
    CGI_List = SEQ_OF(name=u'CGI-List', mode=MODE_TYPE)
    _CGI_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'GlobalCellId')))
    CGI_List._cont = _CGI_List__item_
    CGI_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< E-UTRAN-CGI-List >-----#
    E_UTRAN_CGI_List = SEQ_OF(name=u'E-UTRAN-CGI-List', mode=MODE_TYPE)
    _E_UTRAN_CGI_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'E-UTRAN-CGI')))
    E_UTRAN_CGI_List._cont = _E_UTRAN_CGI_List__item_
    E_UTRAN_CGI_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32)], ev=None, er=[])
    
    #-----< RoutingAreaId-List >-----#
    RoutingAreaId_List = SEQ_OF(name=u'RoutingAreaId-List', mode=MODE_TYPE)
    _RoutingAreaId_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'RAIdentity')))
    RoutingAreaId_List._cont = _RoutingAreaId_List__item_
    RoutingAreaId_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< LocationAreaId-List >-----#
    LocationAreaId_List = SEQ_OF(name=u'LocationAreaId-List', mode=MODE_TYPE)
    _LocationAreaId_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'LAIFixedLength')))
    LocationAreaId_List._cont = _LocationAreaId_List__item_
    LocationAreaId_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< TrackingAreaId-List >-----#
    TrackingAreaId_List = SEQ_OF(name=u'TrackingAreaId-List', mode=MODE_TYPE)
    _TrackingAreaId_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'TA-Id')))
    TrackingAreaId_List._cont = _TrackingAreaId_List__item_
    TrackingAreaId_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< ListOfMeasurements >-----#
    ListOfMeasurements = OCT_STR(name=u'ListOfMeasurements', mode=MODE_TYPE)
    ListOfMeasurements._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< ReportingTrigger >-----#
    ReportingTrigger = OCT_STR(name=u'ReportingTrigger', mode=MODE_TYPE)
    ReportingTrigger._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< ReportInterval >-----#
    ReportInterval = ENUM(name=u'ReportInterval', mode=MODE_TYPE)
    ReportInterval._cont = ASN1Dict([(u'umts250ms', 0), (u'umts500ms', 1), (u'umts1000ms', 2), (u'umts2000ms', 3), (u'umts3000ms', 4), (u'umts4000ms', 5), (u'umts6000ms', 6), (u'umts8000ms', 7), (u'umts12000ms', 8), (u'umts16000ms', 9), (u'umts20000ms', 10), (u'umts24000ms', 11), (u'umts28000ms', 12), (u'umts32000ms', 13), (u'umts64000ms', 14), (u'lte120ms', 15), (u'lte240ms', 16), (u'lte480ms', 17), (u'lte640ms', 18), (u'lte1024ms', 19), (u'lte2048ms', 20), (u'lte5120ms', 21), (u'lte10240ms', 22), (u'lte1min', 23), (u'lte6min', 24), (u'lte12min', 25), (u'lte30min', 26), (u'lte60min', 27)])
    ReportInterval._ext = None
    
    #-----< ReportAmount >-----#
    ReportAmount = ENUM(name=u'ReportAmount', mode=MODE_TYPE)
    ReportAmount._cont = ASN1Dict([(u'd1', 0), (u'd2', 1), (u'd4', 2), (u'd8', 3), (u'd16', 4), (u'd32', 5), (u'd64', 6), (u'infinity', 7)])
    ReportAmount._ext = None
    
    #-----< EventThresholdRSRP >-----#
    EventThresholdRSRP = INT(name=u'EventThresholdRSRP', mode=MODE_TYPE)
    EventThresholdRSRP._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=97)], ev=None, er=[])
    
    #-----< EventThresholdRSRQ >-----#
    EventThresholdRSRQ = INT(name=u'EventThresholdRSRQ', mode=MODE_TYPE)
    EventThresholdRSRQ._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=34)], ev=None, er=[])
    
    #-----< LoggingInterval >-----#
    LoggingInterval = ENUM(name=u'LoggingInterval', mode=MODE_TYPE)
    LoggingInterval._cont = ASN1Dict([(u'd1dot28', 0), (u'd2dot56', 1), (u'd5dot12', 2), (u'd10dot24', 3), (u'd20dot48', 4), (u'd30dot72', 5), (u'd40dot96', 6), (u'd61dot44', 7)])
    LoggingInterval._ext = None
    
    #-----< LoggingDuration >-----#
    LoggingDuration = ENUM(name=u'LoggingDuration', mode=MODE_TYPE)
    LoggingDuration._cont = ASN1Dict([(u'd600sec', 0), (u'd1200sec', 1), (u'd2400sec', 2), (u'd3600sec', 3), (u'd5400sec', 4), (u'd7200sec', 5)])
    LoggingDuration._ext = None
    
    #-----< TraceReference >-----#
    TraceReference = OCT_STR(name=u'TraceReference', mode=MODE_TYPE)
    TraceReference._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    
    #-----< TraceReference2 >-----#
    TraceReference2 = OCT_STR(name=u'TraceReference2', mode=MODE_TYPE)
    TraceReference2._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< TraceRecordingSessionReference >-----#
    TraceRecordingSessionReference = OCT_STR(name=u'TraceRecordingSessionReference', mode=MODE_TYPE)
    TraceRecordingSessionReference._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    
    #-----< TraceType >-----#
    TraceType = INT(name=u'TraceType', mode=MODE_TYPE)
    TraceType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< TraceDepthList >-----#
    TraceDepthList = SEQ(name=u'TraceDepthList', mode=MODE_TYPE)
    _TraceDepthList_msc_s_TraceDepth = ENUM(name=u'msc-s-TraceDepth', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TraceDepthList_mgw_TraceDepth = ENUM(name=u'mgw-TraceDepth', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TraceDepthList_sgsn_TraceDepth = ENUM(name=u'sgsn-TraceDepth', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TraceDepthList_ggsn_TraceDepth = ENUM(name=u'ggsn-TraceDepth', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TraceDepthList_rnc_TraceDepth = ENUM(name=u'rnc-TraceDepth', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TraceDepthList_bmsc_TraceDepth = ENUM(name=u'bmsc-TraceDepth', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TraceDepthList_mme_TraceDepth = ENUM(name=u'mme-TraceDepth', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TraceDepthList_sgw_TraceDepth = ENUM(name=u'sgw-TraceDepth', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TraceDepthList_pgw_TraceDepth = ENUM(name=u'pgw-TraceDepth', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TraceDepthList_eNB_TraceDepth = ENUM(name=u'eNB-TraceDepth', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TraceDepthList_msc_s_TraceDepthExtension = ENUM(name=u'msc-s-TraceDepthExtension', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TraceDepthList_mgw_TraceDepthExtension = ENUM(name=u'mgw-TraceDepthExtension', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TraceDepthList_sgsn_TraceDepthExtension = ENUM(name=u'sgsn-TraceDepthExtension', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TraceDepthList_ggsn_TraceDepthExtension = ENUM(name=u'ggsn-TraceDepthExtension', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TraceDepthList_rnc_TraceDepthExtension = ENUM(name=u'rnc-TraceDepthExtension', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TraceDepthList_bmsc_TraceDepthExtension = ENUM(name=u'bmsc-TraceDepthExtension', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TraceDepthList_mme_TraceDepthExtension = ENUM(name=u'mme-TraceDepthExtension', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TraceDepthList_sgw_TraceDepthExtension = ENUM(name=u'sgw-TraceDepthExtension', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TraceDepthList_pgw_TraceDepthExtension = ENUM(name=u'pgw-TraceDepthExtension', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TraceDepthList_eNB_TraceDepthExtension = ENUM(name=u'eNB-TraceDepthExtension', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    TraceDepthList._cont = ASN1Dict([
        (u'msc-s-TraceDepth', _TraceDepthList_msc_s_TraceDepth),
        (u'mgw-TraceDepth', _TraceDepthList_mgw_TraceDepth),
        (u'sgsn-TraceDepth', _TraceDepthList_sgsn_TraceDepth),
        (u'ggsn-TraceDepth', _TraceDepthList_ggsn_TraceDepth),
        (u'rnc-TraceDepth', _TraceDepthList_rnc_TraceDepth),
        (u'bmsc-TraceDepth', _TraceDepthList_bmsc_TraceDepth),
        (u'mme-TraceDepth', _TraceDepthList_mme_TraceDepth),
        (u'sgw-TraceDepth', _TraceDepthList_sgw_TraceDepth),
        (u'pgw-TraceDepth', _TraceDepthList_pgw_TraceDepth),
        (u'eNB-TraceDepth', _TraceDepthList_eNB_TraceDepth),
        (u'msc-s-TraceDepthExtension', _TraceDepthList_msc_s_TraceDepthExtension),
        (u'mgw-TraceDepthExtension', _TraceDepthList_mgw_TraceDepthExtension),
        (u'sgsn-TraceDepthExtension', _TraceDepthList_sgsn_TraceDepthExtension),
        (u'ggsn-TraceDepthExtension', _TraceDepthList_ggsn_TraceDepthExtension),
        (u'rnc-TraceDepthExtension', _TraceDepthList_rnc_TraceDepthExtension),
        (u'bmsc-TraceDepthExtension', _TraceDepthList_bmsc_TraceDepthExtension),
        (u'mme-TraceDepthExtension', _TraceDepthList_mme_TraceDepthExtension),
        (u'sgw-TraceDepthExtension', _TraceDepthList_sgw_TraceDepthExtension),
        (u'pgw-TraceDepthExtension', _TraceDepthList_pgw_TraceDepthExtension),
        (u'eNB-TraceDepthExtension', _TraceDepthList_eNB_TraceDepthExtension),
        ])
    TraceDepthList._ext = [u'mme-TraceDepth', u'sgw-TraceDepth', u'pgw-TraceDepth', u'eNB-TraceDepth', u'msc-s-TraceDepthExtension', u'mgw-TraceDepthExtension', u'sgsn-TraceDepthExtension', u'ggsn-TraceDepthExtension', u'rnc-TraceDepthExtension', u'bmsc-TraceDepthExtension', u'mme-TraceDepthExtension', u'sgw-TraceDepthExtension', u'pgw-TraceDepthExtension', u'eNB-TraceDepthExtension']
    
    #-----< TraceDepth >-----#
    TraceDepth = ENUM(name=u'TraceDepth', mode=MODE_TYPE)
    TraceDepth._cont = ASN1Dict([(u'minimum', 0), (u'medium', 1), (u'maximum', 2)])
    TraceDepth._ext = []
    
    #-----< TraceDepthExtension >-----#
    TraceDepthExtension = ENUM(name=u'TraceDepthExtension', mode=MODE_TYPE)
    TraceDepthExtension._cont = ASN1Dict([(u'minimumWithoutVendorSpecificExtension', 0), (u'mediumWithoutVendorSpecificExtension', 1), (u'maximumWithoutVendorSpecificExtension', 2)])
    TraceDepthExtension._ext = []
    
    #-----< TraceNE-TypeList >-----#
    TraceNE_TypeList = BIT_STR(name=u'TraceNE-TypeList', mode=MODE_TYPE)
    TraceNE_TypeList._cont = ASN1Dict([(u'msc-s', 0), (u'mgw', 1), (u'sgsn', 2), (u'ggsn', 3), (u'rnc', 4), (u'bm-sc', 5), (u'mme', 6), (u'sgw', 7), (u'pgw', 8), (u'eNB', 9)])
    TraceNE_TypeList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=16)], ev=None, er=[])
    
    #-----< TraceInterfaceList >-----#
    TraceInterfaceList = SEQ(name=u'TraceInterfaceList', mode=MODE_TYPE)
    _TraceInterfaceList_msc_s_List = BIT_STR(name=u'msc-s-List', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MSC-S-InterfaceList')), opt=True)
    _TraceInterfaceList_mgw_List = BIT_STR(name=u'mgw-List', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MGW-InterfaceList')), opt=True)
    _TraceInterfaceList_sgsn_List = BIT_STR(name=u'sgsn-List', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'SGSN-InterfaceList')), opt=True)
    _TraceInterfaceList_ggsn_List = BIT_STR(name=u'ggsn-List', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'GGSN-InterfaceList')), opt=True)
    _TraceInterfaceList_rnc_List = BIT_STR(name=u'rnc-List', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'RNC-InterfaceList')), opt=True)
    _TraceInterfaceList_bmsc_List = BIT_STR(name=u'bmsc-List', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'BMSC-InterfaceList')), opt=True)
    _TraceInterfaceList_mme_List = BIT_STR(name=u'mme-List', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MME-InterfaceList')), opt=True)
    _TraceInterfaceList_sgw_List = BIT_STR(name=u'sgw-List', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'SGW-InterfaceList')), opt=True)
    _TraceInterfaceList_pgw_List = BIT_STR(name=u'pgw-List', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'PGW-InterfaceList')), opt=True)
    _TraceInterfaceList_eNB_List = BIT_STR(name=u'eNB-List', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'ENB-InterfaceList')), opt=True)
    TraceInterfaceList._cont = ASN1Dict([
        (u'msc-s-List', _TraceInterfaceList_msc_s_List),
        (u'mgw-List', _TraceInterfaceList_mgw_List),
        (u'sgsn-List', _TraceInterfaceList_sgsn_List),
        (u'ggsn-List', _TraceInterfaceList_ggsn_List),
        (u'rnc-List', _TraceInterfaceList_rnc_List),
        (u'bmsc-List', _TraceInterfaceList_bmsc_List),
        (u'mme-List', _TraceInterfaceList_mme_List),
        (u'sgw-List', _TraceInterfaceList_sgw_List),
        (u'pgw-List', _TraceInterfaceList_pgw_List),
        (u'eNB-List', _TraceInterfaceList_eNB_List),
        ])
    TraceInterfaceList._ext = [u'mme-List', u'sgw-List', u'pgw-List', u'eNB-List']
    
    #-----< MSC-S-InterfaceList >-----#
    MSC_S_InterfaceList = BIT_STR(name=u'MSC-S-InterfaceList', mode=MODE_TYPE)
    MSC_S_InterfaceList._cont = ASN1Dict([(u'a', 0), (u'iu', 1), (u'mc', 2), (u'map-g', 3), (u'map-b', 4), (u'map-e', 5), (u'map-f', 6), (u'cap', 7), (u'map-d', 8), (u'map-c', 9)])
    MSC_S_InterfaceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=10, ub=16)], ev=None, er=[])
    
    #-----< MGW-InterfaceList >-----#
    MGW_InterfaceList = BIT_STR(name=u'MGW-InterfaceList', mode=MODE_TYPE)
    MGW_InterfaceList._cont = ASN1Dict([(u'mc', 0), (u'nb-up', 1), (u'iu-up', 2)])
    MGW_InterfaceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=8)], ev=None, er=[])
    
    #-----< SGSN-InterfaceList >-----#
    SGSN_InterfaceList = BIT_STR(name=u'SGSN-InterfaceList', mode=MODE_TYPE)
    SGSN_InterfaceList._cont = ASN1Dict([(u'gb', 0), (u'iu', 1), (u'gn', 2), (u'map-gr', 3), (u'map-gd', 4), (u'map-gf', 5), (u'gs', 6), (u'ge', 7), (u's3', 8), (u's4', 9), (u's6d', 10)])
    SGSN_InterfaceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=8, ub=16)], ev=None, er=[])
    
    #-----< GGSN-InterfaceList >-----#
    GGSN_InterfaceList = BIT_STR(name=u'GGSN-InterfaceList', mode=MODE_TYPE)
    GGSN_InterfaceList._cont = ASN1Dict([(u'gn', 0), (u'gi', 1), (u'gmb', 2)])
    GGSN_InterfaceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=8)], ev=None, er=[])
    
    #-----< RNC-InterfaceList >-----#
    RNC_InterfaceList = BIT_STR(name=u'RNC-InterfaceList', mode=MODE_TYPE)
    RNC_InterfaceList._cont = ASN1Dict([(u'iu', 0), (u'iur', 1), (u'iub', 2), (u'uu', 3)])
    RNC_InterfaceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=4, ub=8)], ev=None, er=[])
    
    #-----< BMSC-InterfaceList >-----#
    BMSC_InterfaceList = BIT_STR(name=u'BMSC-InterfaceList', mode=MODE_TYPE)
    BMSC_InterfaceList._cont = ASN1Dict([(u'gmb', 0)])
    BMSC_InterfaceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< MME-InterfaceList >-----#
    MME_InterfaceList = BIT_STR(name=u'MME-InterfaceList', mode=MODE_TYPE)
    MME_InterfaceList._cont = ASN1Dict([(u's1-mme', 0), (u's3', 1), (u's6a', 2), (u's10', 3), (u's11', 4)])
    MME_InterfaceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=5, ub=8)], ev=None, er=[])
    
    #-----< SGW-InterfaceList >-----#
    SGW_InterfaceList = BIT_STR(name=u'SGW-InterfaceList', mode=MODE_TYPE)
    SGW_InterfaceList._cont = ASN1Dict([(u's4', 0), (u's5', 1), (u's8b', 2), (u's11', 3), (u'gxc', 4)])
    SGW_InterfaceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=5, ub=8)], ev=None, er=[])
    
    #-----< PGW-InterfaceList >-----#
    PGW_InterfaceList = BIT_STR(name=u'PGW-InterfaceList', mode=MODE_TYPE)
    PGW_InterfaceList._cont = ASN1Dict([(u's2a', 0), (u's2b', 1), (u's2c', 2), (u's5', 3), (u's6b', 4), (u'gx', 5), (u's8b', 6), (u'sgi', 7)])
    PGW_InterfaceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=8, ub=16)], ev=None, er=[])
    
    #-----< ENB-InterfaceList >-----#
    ENB_InterfaceList = BIT_STR(name=u'ENB-InterfaceList', mode=MODE_TYPE)
    ENB_InterfaceList._cont = ASN1Dict([(u's1-mme', 0), (u'x2', 1), (u'uu', 2)])
    ENB_InterfaceList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=8)], ev=None, er=[])
    
    #-----< TraceEventList >-----#
    TraceEventList = SEQ(name=u'TraceEventList', mode=MODE_TYPE)
    _TraceEventList_msc_s_List = BIT_STR(name=u'msc-s-List', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MSC-S-EventList')), opt=True)
    _TraceEventList_mgw_List = BIT_STR(name=u'mgw-List', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MGW-EventList')), opt=True)
    _TraceEventList_sgsn_List = BIT_STR(name=u'sgsn-List', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'SGSN-EventList')), opt=True)
    _TraceEventList_ggsn_List = BIT_STR(name=u'ggsn-List', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'GGSN-EventList')), opt=True)
    _TraceEventList_bmsc_List = BIT_STR(name=u'bmsc-List', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'BMSC-EventList')), opt=True)
    _TraceEventList_mme_List = BIT_STR(name=u'mme-List', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MME-EventList')), opt=True)
    _TraceEventList_sgw_List = BIT_STR(name=u'sgw-List', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'SGW-EventList')), opt=True)
    _TraceEventList_pgw_List = BIT_STR(name=u'pgw-List', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'PGW-EventList')), opt=True)
    TraceEventList._cont = ASN1Dict([
        (u'msc-s-List', _TraceEventList_msc_s_List),
        (u'mgw-List', _TraceEventList_mgw_List),
        (u'sgsn-List', _TraceEventList_sgsn_List),
        (u'ggsn-List', _TraceEventList_ggsn_List),
        (u'bmsc-List', _TraceEventList_bmsc_List),
        (u'mme-List', _TraceEventList_mme_List),
        (u'sgw-List', _TraceEventList_sgw_List),
        (u'pgw-List', _TraceEventList_pgw_List),
        ])
    TraceEventList._ext = [u'mme-List', u'sgw-List', u'pgw-List']
    
    #-----< MSC-S-EventList >-----#
    MSC_S_EventList = BIT_STR(name=u'MSC-S-EventList', mode=MODE_TYPE)
    MSC_S_EventList._cont = ASN1Dict([(u'mo-mtCall', 0), (u'mo-mt-sms', 1), (u'lu-imsiAttach-imsiDetach', 2), (u'handovers', 3), (u'ss', 4)])
    MSC_S_EventList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=5, ub=16)], ev=None, er=[])
    
    #-----< MGW-EventList >-----#
    MGW_EventList = BIT_STR(name=u'MGW-EventList', mode=MODE_TYPE)
    MGW_EventList._cont = ASN1Dict([(u'context', 0)])
    MGW_EventList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< SGSN-EventList >-----#
    SGSN_EventList = BIT_STR(name=u'SGSN-EventList', mode=MODE_TYPE)
    SGSN_EventList._cont = ASN1Dict([(u'pdpContext', 0), (u'mo-mt-sms', 1), (u'rau-gprsAttach-gprsDetach', 2), (u'mbmsContext', 3)])
    SGSN_EventList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=4, ub=16)], ev=None, er=[])
    
    #-----< GGSN-EventList >-----#
    GGSN_EventList = BIT_STR(name=u'GGSN-EventList', mode=MODE_TYPE)
    GGSN_EventList._cont = ASN1Dict([(u'pdpContext', 0), (u'mbmsContext', 1)])
    GGSN_EventList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=8)], ev=None, er=[])
    
    #-----< BMSC-EventList >-----#
    BMSC_EventList = BIT_STR(name=u'BMSC-EventList', mode=MODE_TYPE)
    BMSC_EventList._cont = ASN1Dict([(u'mbmsMulticastServiceActivation', 0)])
    BMSC_EventList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< MME-EventList >-----#
    MME_EventList = BIT_STR(name=u'MME-EventList', mode=MODE_TYPE)
    MME_EventList._cont = ASN1Dict([(u'ue-initiatedPDNconectivityRequest', 0), (u'serviceRequestts', 1), (u'initialAttachTrackingAreaUpdateDetach', 2), (u'ue-initiatedPDNdisconnection', 3), (u'bearerActivationModificationDeletion', 4), (u'handover', 5)])
    MME_EventList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=6, ub=8)], ev=None, er=[])
    
    #-----< SGW-EventList >-----#
    SGW_EventList = BIT_STR(name=u'SGW-EventList', mode=MODE_TYPE)
    SGW_EventList._cont = ASN1Dict([(u'pdn-connectionCreation', 0), (u'pdn-connectionTermination', 1), (u'bearerActivationModificationDeletion', 2)])
    SGW_EventList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=8)], ev=None, er=[])
    
    #-----< PGW-EventList >-----#
    PGW_EventList = BIT_STR(name=u'PGW-EventList', mode=MODE_TYPE)
    PGW_EventList._cont = ASN1Dict([(u'pdn-connectionCreation', 0), (u'pdn-connectionTermination', 1), (u'bearerActivationModificationDeletion', 2)])
    PGW_EventList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=3, ub=8)], ev=None, er=[])
    
    #-----< TracePropagationList >-----#
    TracePropagationList = SEQ(name=u'TracePropagationList', mode=MODE_TYPE)
    _TracePropagationList_traceReference = OCT_STR(name=u'traceReference', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceReference')), opt=True)
    _TracePropagationList_traceType = INT(name=u'traceType', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceType')), opt=True)
    _TracePropagationList_traceReference2 = OCT_STR(name=u'traceReference2', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceReference2')), opt=True)
    _TracePropagationList_traceRecordingSessionReference = OCT_STR(name=u'traceRecordingSessionReference', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceRecordingSessionReference')), opt=True)
    _TracePropagationList_rnc_TraceDepth = ENUM(name=u'rnc-TraceDepth', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TracePropagationList_rnc_InterfaceList = BIT_STR(name=u'rnc-InterfaceList', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'RNC-InterfaceList')), opt=True)
    _TracePropagationList_msc_s_TraceDepth = ENUM(name=u'msc-s-TraceDepth', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TracePropagationList_msc_s_InterfaceList = BIT_STR(name=u'msc-s-InterfaceList', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MSC-S-InterfaceList')), opt=True)
    _TracePropagationList_msc_s_EventList = BIT_STR(name=u'msc-s-EventList', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MSC-S-EventList')), opt=True)
    _TracePropagationList_mgw_TraceDepth = ENUM(name=u'mgw-TraceDepth', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepth')), opt=True)
    _TracePropagationList_mgw_InterfaceList = BIT_STR(name=u'mgw-InterfaceList', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MGW-InterfaceList')), opt=True)
    _TracePropagationList_mgw_EventList = BIT_STR(name=u'mgw-EventList', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'MGW-EventList')), opt=True)
    _TracePropagationList_rnc_TraceDepthExtension = ENUM(name=u'rnc-TraceDepthExtension', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TracePropagationList_msc_s_TraceDepthExtension = ENUM(name=u'msc-s-TraceDepthExtension', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    _TracePropagationList_mgw_TraceDepthExtension = ENUM(name=u'mgw-TraceDepthExtension', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceDepthExtension')), opt=True)
    TracePropagationList._cont = ASN1Dict([
        (u'traceReference', _TracePropagationList_traceReference),
        (u'traceType', _TracePropagationList_traceType),
        (u'traceReference2', _TracePropagationList_traceReference2),
        (u'traceRecordingSessionReference', _TracePropagationList_traceRecordingSessionReference),
        (u'rnc-TraceDepth', _TracePropagationList_rnc_TraceDepth),
        (u'rnc-InterfaceList', _TracePropagationList_rnc_InterfaceList),
        (u'msc-s-TraceDepth', _TracePropagationList_msc_s_TraceDepth),
        (u'msc-s-InterfaceList', _TracePropagationList_msc_s_InterfaceList),
        (u'msc-s-EventList', _TracePropagationList_msc_s_EventList),
        (u'mgw-TraceDepth', _TracePropagationList_mgw_TraceDepth),
        (u'mgw-InterfaceList', _TracePropagationList_mgw_InterfaceList),
        (u'mgw-EventList', _TracePropagationList_mgw_EventList),
        (u'rnc-TraceDepthExtension', _TracePropagationList_rnc_TraceDepthExtension),
        (u'msc-s-TraceDepthExtension', _TracePropagationList_msc_s_TraceDepthExtension),
        (u'mgw-TraceDepthExtension', _TracePropagationList_mgw_TraceDepthExtension),
        ])
    TracePropagationList._ext = [u'rnc-TraceDepthExtension', u'msc-s-TraceDepthExtension', u'mgw-TraceDepthExtension']
    
    #-----< ActivateTraceModeRes >-----#
    ActivateTraceModeRes = SEQ(name=u'ActivateTraceModeRes', mode=MODE_TYPE)
    _ActivateTraceModeRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ActivateTraceModeRes_traceSupportIndicator = NULL(name=u'traceSupportIndicator', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ActivateTraceModeRes._cont = ASN1Dict([
        (u'extensionContainer', _ActivateTraceModeRes_extensionContainer),
        (u'traceSupportIndicator', _ActivateTraceModeRes_traceSupportIndicator),
        ])
    ActivateTraceModeRes._ext = [u'traceSupportIndicator']
    
    #-----< DeactivateTraceModeArg >-----#
    DeactivateTraceModeArg = SEQ(name=u'DeactivateTraceModeArg', mode=MODE_TYPE)
    _DeactivateTraceModeArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    _DeactivateTraceModeArg_traceReference = OCT_STR(name=u'traceReference', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceReference')))
    _DeactivateTraceModeArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _DeactivateTraceModeArg_traceReference2 = OCT_STR(name=u'traceReference2', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-OM-DataTypes', 'TraceReference2')), opt=True)
    DeactivateTraceModeArg._cont = ASN1Dict([
        (u'imsi', _DeactivateTraceModeArg_imsi),
        (u'traceReference', _DeactivateTraceModeArg_traceReference),
        (u'extensionContainer', _DeactivateTraceModeArg_extensionContainer),
        (u'traceReference2', _DeactivateTraceModeArg_traceReference2),
        ])
    DeactivateTraceModeArg._ext = [u'traceReference2']
    
    #-----< DeactivateTraceModeRes >-----#
    DeactivateTraceModeRes = SEQ(name=u'DeactivateTraceModeRes', mode=MODE_TYPE)
    _DeactivateTraceModeRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    DeactivateTraceModeRes._cont = ASN1Dict([
        (u'extensionContainer', _DeactivateTraceModeRes_extensionContainer),
        ])
    DeactivateTraceModeRes._ext = []
    
    _all_ = [
        _ActivateTraceModeArg_imsi,
        _ActivateTraceModeArg_traceReference,
        _ActivateTraceModeArg_traceType,
        _ActivateTraceModeArg_omc_Id,
        _ActivateTraceModeArg_extensionContainer,
        _ActivateTraceModeArg_traceReference2,
        _ActivateTraceModeArg_traceDepthList,
        _ActivateTraceModeArg_traceNE_TypeList,
        _ActivateTraceModeArg_traceInterfaceList,
        _ActivateTraceModeArg_traceEventList,
        _ActivateTraceModeArg_traceCollectionEntity,
        _ActivateTraceModeArg_mdt_Configuration,
        ActivateTraceModeArg,
        _MDT_Configuration_jobType,
        _MDT_Configuration_areaScope,
        _MDT_Configuration_listOfMeasurements,
        _MDT_Configuration_reportingTrigger,
        _MDT_Configuration_reportInterval,
        _MDT_Configuration_reportAmount,
        _MDT_Configuration_eventThresholdRSRP,
        _MDT_Configuration_eventThresholdRSRQ,
        _MDT_Configuration_loggingInterval,
        _MDT_Configuration_loggingDuration,
        _MDT_Configuration_extensionContainer,
        _MDT_Configuration_measurementPeriodUMTS,
        _MDT_Configuration_measurementPeriodLTE,
        _MDT_Configuration_collectionPeriodRRM_UMTS,
        _MDT_Configuration_collectionPeriodRRM_LTE,
        _MDT_Configuration_positioningMethod,
        _MDT_Configuration_measurementQuantity,
        _MDT_Configuration_eventThreshold1F,
        _MDT_Configuration_eventThreshold1I,
        _MDT_Configuration_mdt_Allowed_PLMN_List,
        MDT_Configuration,
        _MDT_Allowed_PLMNId_List__item_,
        MDT_Allowed_PLMNId_List,
        PeriodUMTS,
        PeriodLTE,
        PositioningMethod,
        MeasurementQuantity,
        EventThreshold1F,
        EventThreshold1I,
        JobType,
        _AreaScope_cgi_List,
        _AreaScope_e_utran_cgi_List,
        _AreaScope_routingAreaId_List,
        _AreaScope_locationAreaId_List,
        _AreaScope_trackingAreaId_List,
        _AreaScope_extensionContainer,
        AreaScope,
        _CGI_List__item_,
        CGI_List,
        _E_UTRAN_CGI_List__item_,
        E_UTRAN_CGI_List,
        _RoutingAreaId_List__item_,
        RoutingAreaId_List,
        _LocationAreaId_List__item_,
        LocationAreaId_List,
        _TrackingAreaId_List__item_,
        TrackingAreaId_List,
        ListOfMeasurements,
        ReportingTrigger,
        ReportInterval,
        ReportAmount,
        EventThresholdRSRP,
        EventThresholdRSRQ,
        LoggingInterval,
        LoggingDuration,
        TraceReference,
        TraceReference2,
        TraceRecordingSessionReference,
        TraceType,
        _TraceDepthList_msc_s_TraceDepth,
        _TraceDepthList_mgw_TraceDepth,
        _TraceDepthList_sgsn_TraceDepth,
        _TraceDepthList_ggsn_TraceDepth,
        _TraceDepthList_rnc_TraceDepth,
        _TraceDepthList_bmsc_TraceDepth,
        _TraceDepthList_mme_TraceDepth,
        _TraceDepthList_sgw_TraceDepth,
        _TraceDepthList_pgw_TraceDepth,
        _TraceDepthList_eNB_TraceDepth,
        _TraceDepthList_msc_s_TraceDepthExtension,
        _TraceDepthList_mgw_TraceDepthExtension,
        _TraceDepthList_sgsn_TraceDepthExtension,
        _TraceDepthList_ggsn_TraceDepthExtension,
        _TraceDepthList_rnc_TraceDepthExtension,
        _TraceDepthList_bmsc_TraceDepthExtension,
        _TraceDepthList_mme_TraceDepthExtension,
        _TraceDepthList_sgw_TraceDepthExtension,
        _TraceDepthList_pgw_TraceDepthExtension,
        _TraceDepthList_eNB_TraceDepthExtension,
        TraceDepthList,
        TraceDepth,
        TraceDepthExtension,
        TraceNE_TypeList,
        _TraceInterfaceList_msc_s_List,
        _TraceInterfaceList_mgw_List,
        _TraceInterfaceList_sgsn_List,
        _TraceInterfaceList_ggsn_List,
        _TraceInterfaceList_rnc_List,
        _TraceInterfaceList_bmsc_List,
        _TraceInterfaceList_mme_List,
        _TraceInterfaceList_sgw_List,
        _TraceInterfaceList_pgw_List,
        _TraceInterfaceList_eNB_List,
        TraceInterfaceList,
        MSC_S_InterfaceList,
        MGW_InterfaceList,
        SGSN_InterfaceList,
        GGSN_InterfaceList,
        RNC_InterfaceList,
        BMSC_InterfaceList,
        MME_InterfaceList,
        SGW_InterfaceList,
        PGW_InterfaceList,
        ENB_InterfaceList,
        _TraceEventList_msc_s_List,
        _TraceEventList_mgw_List,
        _TraceEventList_sgsn_List,
        _TraceEventList_ggsn_List,
        _TraceEventList_bmsc_List,
        _TraceEventList_mme_List,
        _TraceEventList_sgw_List,
        _TraceEventList_pgw_List,
        TraceEventList,
        MSC_S_EventList,
        MGW_EventList,
        SGSN_EventList,
        GGSN_EventList,
        BMSC_EventList,
        MME_EventList,
        SGW_EventList,
        PGW_EventList,
        _TracePropagationList_traceReference,
        _TracePropagationList_traceType,
        _TracePropagationList_traceReference2,
        _TracePropagationList_traceRecordingSessionReference,
        _TracePropagationList_rnc_TraceDepth,
        _TracePropagationList_rnc_InterfaceList,
        _TracePropagationList_msc_s_TraceDepth,
        _TracePropagationList_msc_s_InterfaceList,
        _TracePropagationList_msc_s_EventList,
        _TracePropagationList_mgw_TraceDepth,
        _TracePropagationList_mgw_InterfaceList,
        _TracePropagationList_mgw_EventList,
        _TracePropagationList_rnc_TraceDepthExtension,
        _TracePropagationList_msc_s_TraceDepthExtension,
        _TracePropagationList_mgw_TraceDepthExtension,
        TracePropagationList,
        _ActivateTraceModeRes_extensionContainer,
        _ActivateTraceModeRes_traceSupportIndicator,
        ActivateTraceModeRes,
        _DeactivateTraceModeArg_imsi,
        _DeactivateTraceModeArg_traceReference,
        _DeactivateTraceModeArg_extensionContainer,
        _DeactivateTraceModeArg_traceReference2,
        DeactivateTraceModeArg,
        _DeactivateTraceModeRes_extensionContainer,
        DeactivateTraceModeRes,
    ]

class MAP_CH_DataTypes:

    _name_  = u'MAP-CH-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 13, 16]
    
    _obj_ = [
        u'CUG-CheckInfo',
        u'NumberOfForwarding',
        u'SendRoutingInfoArg',
        u'SuppressionOfAnnouncement',
        u'SuppressMTSS',
        u'InterrogationType',
        u'OR-Phase',
        u'CallReferenceNumber',
        u'ForwardingReason',
        u'SupportedCCBS-Phase',
        u'CallDiversionTreatmentIndicator',
        u'SendRoutingInfoRes',
        u'AllowedServices',
        u'UnavailabilityCause',
        u'CCBS-Indicators',
        u'RoutingInfo',
        u'ForwardingData',
        u'ProvideRoamingNumberArg',
        u'ProvideRoamingNumberRes',
        u'ResumeCallHandlingArg',
        u'UU-Data',
        u'UUIndicator',
        u'UUI',
        u'ResumeCallHandlingRes',
        u'CamelInfo',
        u'ExtendedRoutingInfo',
        u'CamelRoutingInfo',
        u'GmscCamelSubscriptionInfo',
        u'SetReportingStateArg',
        u'ReportingState',
        u'SetReportingStateRes',
        u'CCBS-SubscriberStatus',
        u'StatusReportArg',
        u'EventReportData',
        u'CallReportData',
        u'MonitoringMode',
        u'CallOutcome',
        u'StatusReportRes',
        u'RemoteUserFreeArg',
        u'RemoteUserFreeRes',
        u'RUF-Outcome',
        u'IST-AlertArg',
        u'IST-AlertRes',
        u'IST-CommandArg',
        u'IST-CommandRes',
        u'CallTerminationIndicator',
        u'ReleaseResourcesArg',
        u'ReleaseResourcesRes',
        ]
    _type_ = [
        u'CUG-CheckInfo',
        u'NumberOfForwarding',
        u'SendRoutingInfoArg',
        u'SuppressionOfAnnouncement',
        u'SuppressMTSS',
        u'InterrogationType',
        u'OR-Phase',
        u'CallReferenceNumber',
        u'ForwardingReason',
        u'SupportedCCBS-Phase',
        u'CallDiversionTreatmentIndicator',
        u'SendRoutingInfoRes',
        u'AllowedServices',
        u'UnavailabilityCause',
        u'CCBS-Indicators',
        u'RoutingInfo',
        u'ForwardingData',
        u'ProvideRoamingNumberArg',
        u'ProvideRoamingNumberRes',
        u'ResumeCallHandlingArg',
        u'UU-Data',
        u'UUIndicator',
        u'UUI',
        u'ResumeCallHandlingRes',
        u'CamelInfo',
        u'ExtendedRoutingInfo',
        u'CamelRoutingInfo',
        u'GmscCamelSubscriptionInfo',
        u'SetReportingStateArg',
        u'ReportingState',
        u'SetReportingStateRes',
        u'CCBS-SubscriberStatus',
        u'StatusReportArg',
        u'EventReportData',
        u'CallReportData',
        u'MonitoringMode',
        u'CallOutcome',
        u'StatusReportRes',
        u'RemoteUserFreeArg',
        u'RemoteUserFreeRes',
        u'RUF-Outcome',
        u'IST-AlertArg',
        u'IST-AlertRes',
        u'IST-CommandArg',
        u'IST-CommandRes',
        u'CallTerminationIndicator',
        u'ReleaseResourcesArg',
        u'ReleaseResourcesRes',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< CUG-CheckInfo >-----#
    CUG_CheckInfo = SEQ(name=u'CUG-CheckInfo', mode=MODE_TYPE)
    _CUG_CheckInfo_cug_Interlock = OCT_STR(name=u'cug-Interlock', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'CUG-Interlock')))
    _CUG_CheckInfo_cug_OutgoingAccess = NULL(name=u'cug-OutgoingAccess', mode=MODE_TYPE, opt=True)
    _CUG_CheckInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CUG_CheckInfo._cont = ASN1Dict([
        (u'cug-Interlock', _CUG_CheckInfo_cug_Interlock),
        (u'cug-OutgoingAccess', _CUG_CheckInfo_cug_OutgoingAccess),
        (u'extensionContainer', _CUG_CheckInfo_extensionContainer),
        ])
    CUG_CheckInfo._ext = []
    
    #-----< NumberOfForwarding >-----#
    NumberOfForwarding = INT(name=u'NumberOfForwarding', mode=MODE_TYPE)
    NumberOfForwarding._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< SendRoutingInfoArg >-----#
    SendRoutingInfoArg = SEQ(name=u'SendRoutingInfoArg', mode=MODE_TYPE)
    _SendRoutingInfoArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _SendRoutingInfoArg_cug_CheckInfo = SEQ(name=u'cug-CheckInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CUG-CheckInfo')), opt=True)
    _SendRoutingInfoArg_numberOfForwarding = INT(name=u'numberOfForwarding', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'NumberOfForwarding')), opt=True)
    _SendRoutingInfoArg_interrogationType = ENUM(name=u'interrogationType', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'InterrogationType')))
    _SendRoutingInfoArg_or_Interrogation = NULL(name=u'or-Interrogation', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoArg_or_Capability = INT(name=u'or-Capability', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'OR-Phase')), opt=True)
    _SendRoutingInfoArg_gmsc_OrGsmSCF_Address = OCT_STR(name=u'gmsc-OrGsmSCF-Address', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _SendRoutingInfoArg_callReferenceNumber = OCT_STR(name=u'callReferenceNumber', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CallReferenceNumber')), opt=True)
    _SendRoutingInfoArg_forwardingReason = ENUM(name=u'forwardingReason', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'ForwardingReason')), opt=True)
    _SendRoutingInfoArg_basicServiceGroup = CHOICE(name=u'basicServiceGroup', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _SendRoutingInfoArg_networkSignalInfo = SEQ(name=u'networkSignalInfo', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    _SendRoutingInfoArg_camelInfo = SEQ(name=u'camelInfo', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CamelInfo')), opt=True)
    _SendRoutingInfoArg_suppressionOfAnnouncement = NULL(name=u'suppressionOfAnnouncement', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'SuppressionOfAnnouncement')), opt=True)
    _SendRoutingInfoArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SendRoutingInfoArg_alertingPattern = OCT_STR(name=u'alertingPattern', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')), opt=True)
    _SendRoutingInfoArg_ccbs_Call = NULL(name=u'ccbs-Call', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoArg_supportedCCBS_Phase = INT(name=u'supportedCCBS-Phase', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'SupportedCCBS-Phase')), opt=True)
    _SendRoutingInfoArg_additionalSignalInfo = SEQ(name=u'additionalSignalInfo', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-ExternalSignalInfo')), opt=True)
    _SendRoutingInfoArg_istSupportIndicator = ENUM(name=u'istSupportIndicator', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'IST-SupportIndicator')), opt=True)
    _SendRoutingInfoArg_pre_pagingSupported = NULL(name=u'pre-pagingSupported', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoArg_callDiversionTreatmentIndicator = OCT_STR(name=u'callDiversionTreatmentIndicator', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CallDiversionTreatmentIndicator')), opt=True)
    _SendRoutingInfoArg_longFTN_Supported = NULL(name=u'longFTN-Supported', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoArg_suppress_VT_CSI = NULL(name=u'suppress-VT-CSI', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoArg_suppressIncomingCallBarring = NULL(name=u'suppressIncomingCallBarring', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoArg_gsmSCF_InitiatedCall = NULL(name=u'gsmSCF-InitiatedCall', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoArg_basicServiceGroup2 = CHOICE(name=u'basicServiceGroup2', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _SendRoutingInfoArg_networkSignalInfo2 = SEQ(name=u'networkSignalInfo2', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    _SendRoutingInfoArg_suppressMTSS = BIT_STR(name=u'suppressMTSS', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'SuppressMTSS')), opt=True)
    _SendRoutingInfoArg_mtRoamingRetrySupported = NULL(name=u'mtRoamingRetrySupported', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoArg_callPriority = INT(name=u'callPriority', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')), opt=True)
    SendRoutingInfoArg._cont = ASN1Dict([
        (u'msisdn', _SendRoutingInfoArg_msisdn),
        (u'cug-CheckInfo', _SendRoutingInfoArg_cug_CheckInfo),
        (u'numberOfForwarding', _SendRoutingInfoArg_numberOfForwarding),
        (u'interrogationType', _SendRoutingInfoArg_interrogationType),
        (u'or-Interrogation', _SendRoutingInfoArg_or_Interrogation),
        (u'or-Capability', _SendRoutingInfoArg_or_Capability),
        (u'gmsc-OrGsmSCF-Address', _SendRoutingInfoArg_gmsc_OrGsmSCF_Address),
        (u'callReferenceNumber', _SendRoutingInfoArg_callReferenceNumber),
        (u'forwardingReason', _SendRoutingInfoArg_forwardingReason),
        (u'basicServiceGroup', _SendRoutingInfoArg_basicServiceGroup),
        (u'networkSignalInfo', _SendRoutingInfoArg_networkSignalInfo),
        (u'camelInfo', _SendRoutingInfoArg_camelInfo),
        (u'suppressionOfAnnouncement', _SendRoutingInfoArg_suppressionOfAnnouncement),
        (u'extensionContainer', _SendRoutingInfoArg_extensionContainer),
        (u'alertingPattern', _SendRoutingInfoArg_alertingPattern),
        (u'ccbs-Call', _SendRoutingInfoArg_ccbs_Call),
        (u'supportedCCBS-Phase', _SendRoutingInfoArg_supportedCCBS_Phase),
        (u'additionalSignalInfo', _SendRoutingInfoArg_additionalSignalInfo),
        (u'istSupportIndicator', _SendRoutingInfoArg_istSupportIndicator),
        (u'pre-pagingSupported', _SendRoutingInfoArg_pre_pagingSupported),
        (u'callDiversionTreatmentIndicator', _SendRoutingInfoArg_callDiversionTreatmentIndicator),
        (u'longFTN-Supported', _SendRoutingInfoArg_longFTN_Supported),
        (u'suppress-VT-CSI', _SendRoutingInfoArg_suppress_VT_CSI),
        (u'suppressIncomingCallBarring', _SendRoutingInfoArg_suppressIncomingCallBarring),
        (u'gsmSCF-InitiatedCall', _SendRoutingInfoArg_gsmSCF_InitiatedCall),
        (u'basicServiceGroup2', _SendRoutingInfoArg_basicServiceGroup2),
        (u'networkSignalInfo2', _SendRoutingInfoArg_networkSignalInfo2),
        (u'suppressMTSS', _SendRoutingInfoArg_suppressMTSS),
        (u'mtRoamingRetrySupported', _SendRoutingInfoArg_mtRoamingRetrySupported),
        (u'callPriority', _SendRoutingInfoArg_callPriority),
        ])
    SendRoutingInfoArg._ext = [u'alertingPattern', u'ccbs-Call', u'supportedCCBS-Phase', u'additionalSignalInfo', u'istSupportIndicator', u'pre-pagingSupported', u'callDiversionTreatmentIndicator', u'longFTN-Supported', u'suppress-VT-CSI', u'suppressIncomingCallBarring', u'gsmSCF-InitiatedCall', u'basicServiceGroup2', u'networkSignalInfo2', u'suppressMTSS', u'mtRoamingRetrySupported', u'callPriority']
    
    #-----< SuppressionOfAnnouncement >-----#
    SuppressionOfAnnouncement = NULL(name=u'SuppressionOfAnnouncement', mode=MODE_TYPE)
    
    #-----< SuppressMTSS >-----#
    SuppressMTSS = BIT_STR(name=u'SuppressMTSS', mode=MODE_TYPE)
    SuppressMTSS._cont = ASN1Dict([(u'suppressCUG', 0), (u'suppressCCBS', 1)])
    SuppressMTSS._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=16)], ev=None, er=[])
    
    #-----< InterrogationType >-----#
    InterrogationType = ENUM(name=u'InterrogationType', mode=MODE_TYPE)
    InterrogationType._cont = ASN1Dict([(u'basicCall', 0), (u'forwarding', 1)])
    InterrogationType._ext = None
    
    #-----< OR-Phase >-----#
    OR_Phase = INT(name=u'OR-Phase', mode=MODE_TYPE)
    OR_Phase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=127)], ev=None, er=[])
    
    #-----< CallReferenceNumber >-----#
    CallReferenceNumber = OCT_STR(name=u'CallReferenceNumber', mode=MODE_TYPE)
    CallReferenceNumber._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=8)], ev=None, er=[])
    
    #-----< ForwardingReason >-----#
    ForwardingReason = ENUM(name=u'ForwardingReason', mode=MODE_TYPE)
    ForwardingReason._cont = ASN1Dict([(u'notReachable', 0), (u'busy', 1), (u'noReply', 2)])
    ForwardingReason._ext = None
    
    #-----< SupportedCCBS-Phase >-----#
    SupportedCCBS_Phase = INT(name=u'SupportedCCBS-Phase', mode=MODE_TYPE)
    SupportedCCBS_Phase._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=127)], ev=None, er=[])
    
    #-----< CallDiversionTreatmentIndicator >-----#
    CallDiversionTreatmentIndicator = OCT_STR(name=u'CallDiversionTreatmentIndicator', mode=MODE_TYPE)
    CallDiversionTreatmentIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< SendRoutingInfoRes >-----#
    SendRoutingInfoRes = SEQ(name=u'SendRoutingInfoRes', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _SendRoutingInfoRes_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    _SendRoutingInfoRes_extendedRoutingInfo = CHOICE(name=u'extendedRoutingInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CH-DataTypes', 'ExtendedRoutingInfo')), opt=True)
    _SendRoutingInfoRes_cug_CheckInfo = SEQ(name=u'cug-CheckInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CUG-CheckInfo')), opt=True)
    _SendRoutingInfoRes_cugSubscriptionFlag = NULL(name=u'cugSubscriptionFlag', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoRes_subscriberInfo = SEQ(name=u'subscriberInfo', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SubscriberInfo')), opt=True)
    _SendRoutingInfoRes_ss_List = SEQ_OF(name=u'ss-List', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-List')), opt=True)
    _SendRoutingInfoRes_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _SendRoutingInfoRes_forwardingInterrogationRequired = NULL(name=u'forwardingInterrogationRequired', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoRes_vmsc_Address = OCT_STR(name=u'vmsc-Address', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _SendRoutingInfoRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SendRoutingInfoRes_naea_PreferredCI = SEQ(name=u'naea-PreferredCI', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'NAEA-PreferredCI')), opt=True)
    _SendRoutingInfoRes_ccbs_Indicators = SEQ(name=u'ccbs-Indicators', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CCBS-Indicators')), opt=True)
    _SendRoutingInfoRes_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _SendRoutingInfoRes_numberPortabilityStatus = ENUM(name=u'numberPortabilityStatus', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'NumberPortabilityStatus')), opt=True)
    _SendRoutingInfoRes_istAlertTimer = INT(name=u'istAlertTimer', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'IST-AlertTimerValue')), opt=True)
    _SendRoutingInfoRes_supportedCamelPhasesInVMSC = BIT_STR(name=u'supportedCamelPhasesInVMSC', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCamelPhases')), opt=True)
    _SendRoutingInfoRes_offeredCamel4CSIsInVMSC = BIT_STR(name=u'offeredCamel4CSIsInVMSC', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'OfferedCamel4CSIs')), opt=True)
    _SendRoutingInfoRes_routingInfo2 = CHOICE(name=u'routingInfo2', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'RoutingInfo')), opt=True)
    _SendRoutingInfoRes_ss_List2 = SEQ_OF(name=u'ss-List2', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-List')), opt=True)
    _SendRoutingInfoRes_basicService2 = CHOICE(name=u'basicService2', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _SendRoutingInfoRes_allowedServices = BIT_STR(name=u'allowedServices', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'AllowedServices')), opt=True)
    _SendRoutingInfoRes_unavailabilityCause = ENUM(name=u'unavailabilityCause', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'UnavailabilityCause')), opt=True)
    _SendRoutingInfoRes_releaseResourcesSupported = NULL(name=u'releaseResourcesSupported', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _SendRoutingInfoRes_gsm_BearerCapability = SEQ(name=u'gsm-BearerCapability', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    SendRoutingInfoRes._cont = ASN1Dict([
        (u'imsi', _SendRoutingInfoRes_imsi),
        (u'extendedRoutingInfo', _SendRoutingInfoRes_extendedRoutingInfo),
        (u'cug-CheckInfo', _SendRoutingInfoRes_cug_CheckInfo),
        (u'cugSubscriptionFlag', _SendRoutingInfoRes_cugSubscriptionFlag),
        (u'subscriberInfo', _SendRoutingInfoRes_subscriberInfo),
        (u'ss-List', _SendRoutingInfoRes_ss_List),
        (u'basicService', _SendRoutingInfoRes_basicService),
        (u'forwardingInterrogationRequired', _SendRoutingInfoRes_forwardingInterrogationRequired),
        (u'vmsc-Address', _SendRoutingInfoRes_vmsc_Address),
        (u'extensionContainer', _SendRoutingInfoRes_extensionContainer),
        (u'naea-PreferredCI', _SendRoutingInfoRes_naea_PreferredCI),
        (u'ccbs-Indicators', _SendRoutingInfoRes_ccbs_Indicators),
        (u'msisdn', _SendRoutingInfoRes_msisdn),
        (u'numberPortabilityStatus', _SendRoutingInfoRes_numberPortabilityStatus),
        (u'istAlertTimer', _SendRoutingInfoRes_istAlertTimer),
        (u'supportedCamelPhasesInVMSC', _SendRoutingInfoRes_supportedCamelPhasesInVMSC),
        (u'offeredCamel4CSIsInVMSC', _SendRoutingInfoRes_offeredCamel4CSIsInVMSC),
        (u'routingInfo2', _SendRoutingInfoRes_routingInfo2),
        (u'ss-List2', _SendRoutingInfoRes_ss_List2),
        (u'basicService2', _SendRoutingInfoRes_basicService2),
        (u'allowedServices', _SendRoutingInfoRes_allowedServices),
        (u'unavailabilityCause', _SendRoutingInfoRes_unavailabilityCause),
        (u'releaseResourcesSupported', _SendRoutingInfoRes_releaseResourcesSupported),
        (u'gsm-BearerCapability', _SendRoutingInfoRes_gsm_BearerCapability),
        ])
    SendRoutingInfoRes._ext = [u'naea-PreferredCI', u'ccbs-Indicators', u'msisdn', u'numberPortabilityStatus', u'istAlertTimer', u'supportedCamelPhasesInVMSC', u'offeredCamel4CSIsInVMSC', u'routingInfo2', u'ss-List2', u'basicService2', u'allowedServices', u'unavailabilityCause', u'releaseResourcesSupported', u'gsm-BearerCapability']
    
    #-----< AllowedServices >-----#
    AllowedServices = BIT_STR(name=u'AllowedServices', mode=MODE_TYPE)
    AllowedServices._cont = ASN1Dict([(u'firstServiceAllowed', 0), (u'secondServiceAllowed', 1)])
    AllowedServices._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=8)], ev=None, er=[])
    
    #-----< UnavailabilityCause >-----#
    UnavailabilityCause = ENUM(name=u'UnavailabilityCause', mode=MODE_TYPE)
    UnavailabilityCause._cont = ASN1Dict([(u'bearerServiceNotProvisioned', 1), (u'teleserviceNotProvisioned', 2), (u'absentSubscriber', 3), (u'busySubscriber', 4), (u'callBarred', 5), (u'cug-Reject', 6)])
    UnavailabilityCause._ext = []
    
    #-----< CCBS-Indicators >-----#
    CCBS_Indicators = SEQ(name=u'CCBS-Indicators', mode=MODE_TYPE)
    _CCBS_Indicators_ccbs_Possible = NULL(name=u'ccbs-Possible', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CCBS_Indicators_keepCCBS_CallIndicator = NULL(name=u'keepCCBS-CallIndicator', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CCBS_Indicators_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CCBS_Indicators._cont = ASN1Dict([
        (u'ccbs-Possible', _CCBS_Indicators_ccbs_Possible),
        (u'keepCCBS-CallIndicator', _CCBS_Indicators_keepCCBS_CallIndicator),
        (u'extensionContainer', _CCBS_Indicators_extensionContainer),
        ])
    CCBS_Indicators._ext = []
    
    #-----< RoutingInfo >-----#
    RoutingInfo = CHOICE(name=u'RoutingInfo', mode=MODE_TYPE)
    _RoutingInfo_roamingNumber = OCT_STR(name=u'roamingNumber', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _RoutingInfo_forwardingData = SEQ(name=u'forwardingData', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CH-DataTypes', 'ForwardingData')))
    RoutingInfo._cont = ASN1Dict([
        (u'roamingNumber', _RoutingInfo_roamingNumber),
        (u'forwardingData', _RoutingInfo_forwardingData),
        ])
    RoutingInfo._ext = None
    
    #-----< ForwardingData >-----#
    ForwardingData = SEQ(name=u'ForwardingData', mode=MODE_TYPE)
    _ForwardingData_forwardedToNumber = OCT_STR(name=u'forwardedToNumber', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ForwardingData_forwardedToSubaddress = OCT_STR(name=u'forwardedToSubaddress', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-SubaddressString')), opt=True)
    _ForwardingData_forwardingOptions = OCT_STR(name=u'forwardingOptions', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'ForwardingOptions')), opt=True)
    _ForwardingData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ForwardingData_longForwardedToNumber = OCT_STR(name=u'longForwardedToNumber', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'FTN-AddressString')), opt=True)
    ForwardingData._cont = ASN1Dict([
        (u'forwardedToNumber', _ForwardingData_forwardedToNumber),
        (u'forwardedToSubaddress', _ForwardingData_forwardedToSubaddress),
        (u'forwardingOptions', _ForwardingData_forwardingOptions),
        (u'extensionContainer', _ForwardingData_extensionContainer),
        (u'longForwardedToNumber', _ForwardingData_longForwardedToNumber),
        ])
    ForwardingData._ext = [u'longForwardedToNumber']
    
    #-----< ProvideRoamingNumberArg >-----#
    ProvideRoamingNumberArg = SEQ(name=u'ProvideRoamingNumberArg', mode=MODE_TYPE)
    _ProvideRoamingNumberArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _ProvideRoamingNumberArg_msc_Number = OCT_STR(name=u'msc-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _ProvideRoamingNumberArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ProvideRoamingNumberArg_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LMSI')), opt=True)
    _ProvideRoamingNumberArg_gsm_BearerCapability = SEQ(name=u'gsm-BearerCapability', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    _ProvideRoamingNumberArg_networkSignalInfo = SEQ(name=u'networkSignalInfo', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ExternalSignalInfo')), opt=True)
    _ProvideRoamingNumberArg_suppressionOfAnnouncement = NULL(name=u'suppressionOfAnnouncement', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'SuppressionOfAnnouncement')), opt=True)
    _ProvideRoamingNumberArg_gmsc_Address = OCT_STR(name=u'gmsc-Address', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ProvideRoamingNumberArg_callReferenceNumber = OCT_STR(name=u'callReferenceNumber', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CallReferenceNumber')), opt=True)
    _ProvideRoamingNumberArg_or_Interrogation = NULL(name=u'or-Interrogation', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ProvideRoamingNumberArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ProvideRoamingNumberArg_alertingPattern = OCT_STR(name=u'alertingPattern', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')), opt=True)
    _ProvideRoamingNumberArg_ccbs_Call = NULL(name=u'ccbs-Call', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ProvideRoamingNumberArg_supportedCamelPhasesInInterrogatingNode = BIT_STR(name=u'supportedCamelPhasesInInterrogatingNode', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCamelPhases')), opt=True)
    _ProvideRoamingNumberArg_additionalSignalInfo = SEQ(name=u'additionalSignalInfo', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-ExternalSignalInfo')), opt=True)
    _ProvideRoamingNumberArg_orNotSupportedInGMSC = NULL(name=u'orNotSupportedInGMSC', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ProvideRoamingNumberArg_pre_pagingSupported = NULL(name=u'pre-pagingSupported', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ProvideRoamingNumberArg_longFTN_Supported = NULL(name=u'longFTN-Supported', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ProvideRoamingNumberArg_suppress_VT_CSI = NULL(name=u'suppress-VT-CSI', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ProvideRoamingNumberArg_offeredCamel4CSIsInInterrogatingNode = BIT_STR(name=u'offeredCamel4CSIsInInterrogatingNode', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'OfferedCamel4CSIs')), opt=True)
    _ProvideRoamingNumberArg_mtRoamingRetrySupported = NULL(name=u'mtRoamingRetrySupported', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ProvideRoamingNumberArg_pagingArea = SEQ_OF(name=u'pagingArea', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'PagingArea')), opt=True)
    _ProvideRoamingNumberArg_callPriority = INT(name=u'callPriority', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')), opt=True)
    _ProvideRoamingNumberArg_mtrf_Indicator = NULL(name=u'mtrf-Indicator', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ProvideRoamingNumberArg_oldMSC_Number = OCT_STR(name=u'oldMSC-Number', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ProvideRoamingNumberArg_lastUsedLtePLMN_Id = OCT_STR(name=u'lastUsedLtePLMN-Id', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'PLMN-Id')), opt=True)
    ProvideRoamingNumberArg._cont = ASN1Dict([
        (u'imsi', _ProvideRoamingNumberArg_imsi),
        (u'msc-Number', _ProvideRoamingNumberArg_msc_Number),
        (u'msisdn', _ProvideRoamingNumberArg_msisdn),
        (u'lmsi', _ProvideRoamingNumberArg_lmsi),
        (u'gsm-BearerCapability', _ProvideRoamingNumberArg_gsm_BearerCapability),
        (u'networkSignalInfo', _ProvideRoamingNumberArg_networkSignalInfo),
        (u'suppressionOfAnnouncement', _ProvideRoamingNumberArg_suppressionOfAnnouncement),
        (u'gmsc-Address', _ProvideRoamingNumberArg_gmsc_Address),
        (u'callReferenceNumber', _ProvideRoamingNumberArg_callReferenceNumber),
        (u'or-Interrogation', _ProvideRoamingNumberArg_or_Interrogation),
        (u'extensionContainer', _ProvideRoamingNumberArg_extensionContainer),
        (u'alertingPattern', _ProvideRoamingNumberArg_alertingPattern),
        (u'ccbs-Call', _ProvideRoamingNumberArg_ccbs_Call),
        (u'supportedCamelPhasesInInterrogatingNode', _ProvideRoamingNumberArg_supportedCamelPhasesInInterrogatingNode),
        (u'additionalSignalInfo', _ProvideRoamingNumberArg_additionalSignalInfo),
        (u'orNotSupportedInGMSC', _ProvideRoamingNumberArg_orNotSupportedInGMSC),
        (u'pre-pagingSupported', _ProvideRoamingNumberArg_pre_pagingSupported),
        (u'longFTN-Supported', _ProvideRoamingNumberArg_longFTN_Supported),
        (u'suppress-VT-CSI', _ProvideRoamingNumberArg_suppress_VT_CSI),
        (u'offeredCamel4CSIsInInterrogatingNode', _ProvideRoamingNumberArg_offeredCamel4CSIsInInterrogatingNode),
        (u'mtRoamingRetrySupported', _ProvideRoamingNumberArg_mtRoamingRetrySupported),
        (u'pagingArea', _ProvideRoamingNumberArg_pagingArea),
        (u'callPriority', _ProvideRoamingNumberArg_callPriority),
        (u'mtrf-Indicator', _ProvideRoamingNumberArg_mtrf_Indicator),
        (u'oldMSC-Number', _ProvideRoamingNumberArg_oldMSC_Number),
        (u'lastUsedLtePLMN-Id', _ProvideRoamingNumberArg_lastUsedLtePLMN_Id),
        ])
    ProvideRoamingNumberArg._ext = [u'alertingPattern', u'ccbs-Call', u'supportedCamelPhasesInInterrogatingNode', u'additionalSignalInfo', u'orNotSupportedInGMSC', u'pre-pagingSupported', u'longFTN-Supported', u'suppress-VT-CSI', u'offeredCamel4CSIsInInterrogatingNode', u'mtRoamingRetrySupported', u'pagingArea', u'callPriority', u'mtrf-Indicator', u'oldMSC-Number', u'lastUsedLtePLMN-Id']
    
    #-----< ProvideRoamingNumberRes >-----#
    ProvideRoamingNumberRes = SEQ(name=u'ProvideRoamingNumberRes', mode=MODE_TYPE)
    _ProvideRoamingNumberRes_roamingNumber = OCT_STR(name=u'roamingNumber', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _ProvideRoamingNumberRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ProvideRoamingNumberRes_releaseResourcesSupported = NULL(name=u'releaseResourcesSupported', mode=MODE_TYPE, opt=True)
    _ProvideRoamingNumberRes_vmsc_Address = OCT_STR(name=u'vmsc-Address', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    ProvideRoamingNumberRes._cont = ASN1Dict([
        (u'roamingNumber', _ProvideRoamingNumberRes_roamingNumber),
        (u'extensionContainer', _ProvideRoamingNumberRes_extensionContainer),
        (u'releaseResourcesSupported', _ProvideRoamingNumberRes_releaseResourcesSupported),
        (u'vmsc-Address', _ProvideRoamingNumberRes_vmsc_Address),
        ])
    ProvideRoamingNumberRes._ext = [u'releaseResourcesSupported', u'vmsc-Address']
    
    #-----< ResumeCallHandlingArg >-----#
    ResumeCallHandlingArg = SEQ(name=u'ResumeCallHandlingArg', mode=MODE_TYPE)
    _ResumeCallHandlingArg_callReferenceNumber = OCT_STR(name=u'callReferenceNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CallReferenceNumber')), opt=True)
    _ResumeCallHandlingArg_basicServiceGroup = CHOICE(name=u'basicServiceGroup', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _ResumeCallHandlingArg_forwardingData = SEQ(name=u'forwardingData', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'ForwardingData')), opt=True)
    _ResumeCallHandlingArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    _ResumeCallHandlingArg_cug_CheckInfo = SEQ(name=u'cug-CheckInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CUG-CheckInfo')), opt=True)
    _ResumeCallHandlingArg_o_CSI = SEQ(name=u'o-CSI', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-CSI')), opt=True)
    _ResumeCallHandlingArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ResumeCallHandlingArg_ccbs_Possible = NULL(name=u'ccbs-Possible', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ResumeCallHandlingArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ResumeCallHandlingArg_uu_Data = SEQ(name=u'uu-Data', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'UU-Data')), opt=True)
    _ResumeCallHandlingArg_allInformationSent = NULL(name=u'allInformationSent', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ResumeCallHandlingArg_d_csi = SEQ(name=u'd-csi', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'D-CSI')), opt=True)
    _ResumeCallHandlingArg_o_BcsmCamelTDPCriteriaList = SEQ_OF(name=u'o-BcsmCamelTDPCriteriaList', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-BcsmCamelTDPCriteriaList')), opt=True)
    _ResumeCallHandlingArg_basicServiceGroup2 = CHOICE(name=u'basicServiceGroup2', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Ext-BasicServiceCode')), opt=True)
    _ResumeCallHandlingArg_mtRoamingRetry = NULL(name=u'mtRoamingRetry', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ResumeCallHandlingArg._cont = ASN1Dict([
        (u'callReferenceNumber', _ResumeCallHandlingArg_callReferenceNumber),
        (u'basicServiceGroup', _ResumeCallHandlingArg_basicServiceGroup),
        (u'forwardingData', _ResumeCallHandlingArg_forwardingData),
        (u'imsi', _ResumeCallHandlingArg_imsi),
        (u'cug-CheckInfo', _ResumeCallHandlingArg_cug_CheckInfo),
        (u'o-CSI', _ResumeCallHandlingArg_o_CSI),
        (u'extensionContainer', _ResumeCallHandlingArg_extensionContainer),
        (u'ccbs-Possible', _ResumeCallHandlingArg_ccbs_Possible),
        (u'msisdn', _ResumeCallHandlingArg_msisdn),
        (u'uu-Data', _ResumeCallHandlingArg_uu_Data),
        (u'allInformationSent', _ResumeCallHandlingArg_allInformationSent),
        (u'd-csi', _ResumeCallHandlingArg_d_csi),
        (u'o-BcsmCamelTDPCriteriaList', _ResumeCallHandlingArg_o_BcsmCamelTDPCriteriaList),
        (u'basicServiceGroup2', _ResumeCallHandlingArg_basicServiceGroup2),
        (u'mtRoamingRetry', _ResumeCallHandlingArg_mtRoamingRetry),
        ])
    ResumeCallHandlingArg._ext = [u'd-csi', u'o-BcsmCamelTDPCriteriaList', u'basicServiceGroup2', u'mtRoamingRetry']
    
    #-----< UU-Data >-----#
    UU_Data = SEQ(name=u'UU-Data', mode=MODE_TYPE)
    _UU_Data_uuIndicator = OCT_STR(name=u'uuIndicator', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'UUIndicator')), opt=True)
    _UU_Data_uui = OCT_STR(name=u'uui', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'UUI')), opt=True)
    _UU_Data_uusCFInteraction = NULL(name=u'uusCFInteraction', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _UU_Data_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    UU_Data._cont = ASN1Dict([
        (u'uuIndicator', _UU_Data_uuIndicator),
        (u'uui', _UU_Data_uui),
        (u'uusCFInteraction', _UU_Data_uusCFInteraction),
        (u'extensionContainer', _UU_Data_extensionContainer),
        ])
    UU_Data._ext = []
    
    #-----< UUIndicator >-----#
    UUIndicator = OCT_STR(name=u'UUIndicator', mode=MODE_TYPE)
    UUIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< UUI >-----#
    UUI = OCT_STR(name=u'UUI', mode=MODE_TYPE)
    UUI._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=131)], ev=None, er=[])
    
    #-----< ResumeCallHandlingRes >-----#
    ResumeCallHandlingRes = SEQ(name=u'ResumeCallHandlingRes', mode=MODE_TYPE)
    _ResumeCallHandlingRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ResumeCallHandlingRes._cont = ASN1Dict([
        (u'extensionContainer', _ResumeCallHandlingRes_extensionContainer),
        ])
    ResumeCallHandlingRes._ext = []
    
    #-----< CamelInfo >-----#
    CamelInfo = SEQ(name=u'CamelInfo', mode=MODE_TYPE)
    _CamelInfo_supportedCamelPhases = BIT_STR(name=u'supportedCamelPhases', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-MS-DataTypes', 'SupportedCamelPhases')))
    _CamelInfo_suppress_T_CSI = NULL(name=u'suppress-T-CSI', mode=MODE_TYPE, opt=True)
    _CamelInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _CamelInfo_offeredCamel4CSIs = BIT_STR(name=u'offeredCamel4CSIs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'OfferedCamel4CSIs')), opt=True)
    CamelInfo._cont = ASN1Dict([
        (u'supportedCamelPhases', _CamelInfo_supportedCamelPhases),
        (u'suppress-T-CSI', _CamelInfo_suppress_T_CSI),
        (u'extensionContainer', _CamelInfo_extensionContainer),
        (u'offeredCamel4CSIs', _CamelInfo_offeredCamel4CSIs),
        ])
    CamelInfo._ext = [u'offeredCamel4CSIs']
    
    #-----< ExtendedRoutingInfo >-----#
    ExtendedRoutingInfo = CHOICE(name=u'ExtendedRoutingInfo', mode=MODE_TYPE)
    _ExtendedRoutingInfo_routingInfo = CHOICE(name=u'routingInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CH-DataTypes', 'RoutingInfo')))
    _ExtendedRoutingInfo_camelRoutingInfo = SEQ(name=u'camelRoutingInfo', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CamelRoutingInfo')))
    ExtendedRoutingInfo._cont = ASN1Dict([
        (u'routingInfo', _ExtendedRoutingInfo_routingInfo),
        (u'camelRoutingInfo', _ExtendedRoutingInfo_camelRoutingInfo),
        ])
    ExtendedRoutingInfo._ext = None
    
    #-----< CamelRoutingInfo >-----#
    CamelRoutingInfo = SEQ(name=u'CamelRoutingInfo', mode=MODE_TYPE)
    _CamelRoutingInfo_forwardingData = SEQ(name=u'forwardingData', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CH-DataTypes', 'ForwardingData')), opt=True)
    _CamelRoutingInfo_gmscCamelSubscriptionInfo = SEQ(name=u'gmscCamelSubscriptionInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'GmscCamelSubscriptionInfo')))
    _CamelRoutingInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CamelRoutingInfo._cont = ASN1Dict([
        (u'forwardingData', _CamelRoutingInfo_forwardingData),
        (u'gmscCamelSubscriptionInfo', _CamelRoutingInfo_gmscCamelSubscriptionInfo),
        (u'extensionContainer', _CamelRoutingInfo_extensionContainer),
        ])
    CamelRoutingInfo._ext = []
    
    #-----< GmscCamelSubscriptionInfo >-----#
    GmscCamelSubscriptionInfo = SEQ(name=u'GmscCamelSubscriptionInfo', mode=MODE_TYPE)
    _GmscCamelSubscriptionInfo_t_CSI = SEQ(name=u't-CSI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-CSI')), opt=True)
    _GmscCamelSubscriptionInfo_o_CSI = SEQ(name=u'o-CSI', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-CSI')), opt=True)
    _GmscCamelSubscriptionInfo_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _GmscCamelSubscriptionInfo_o_BcsmCamelTDP_CriteriaList = SEQ_OF(name=u'o-BcsmCamelTDP-CriteriaList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'O-BcsmCamelTDPCriteriaList')), opt=True)
    _GmscCamelSubscriptionInfo_t_BCSM_CAMEL_TDP_CriteriaList = SEQ_OF(name=u't-BCSM-CAMEL-TDP-CriteriaList', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'T-BCSM-CAMEL-TDP-CriteriaList')), opt=True)
    _GmscCamelSubscriptionInfo_d_csi = SEQ(name=u'd-csi', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'D-CSI')), opt=True)
    GmscCamelSubscriptionInfo._cont = ASN1Dict([
        (u't-CSI', _GmscCamelSubscriptionInfo_t_CSI),
        (u'o-CSI', _GmscCamelSubscriptionInfo_o_CSI),
        (u'extensionContainer', _GmscCamelSubscriptionInfo_extensionContainer),
        (u'o-BcsmCamelTDP-CriteriaList', _GmscCamelSubscriptionInfo_o_BcsmCamelTDP_CriteriaList),
        (u't-BCSM-CAMEL-TDP-CriteriaList', _GmscCamelSubscriptionInfo_t_BCSM_CAMEL_TDP_CriteriaList),
        (u'd-csi', _GmscCamelSubscriptionInfo_d_csi),
        ])
    GmscCamelSubscriptionInfo._ext = [u'o-BcsmCamelTDP-CriteriaList', u't-BCSM-CAMEL-TDP-CriteriaList', u'd-csi']
    
    #-----< SetReportingStateArg >-----#
    SetReportingStateArg = SEQ(name=u'SetReportingStateArg', mode=MODE_TYPE)
    _SetReportingStateArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    _SetReportingStateArg_lmsi = OCT_STR(name=u'lmsi', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LMSI')), opt=True)
    _SetReportingStateArg_ccbs_Monitoring = ENUM(name=u'ccbs-Monitoring', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'ReportingState')), opt=True)
    _SetReportingStateArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SetReportingStateArg._cont = ASN1Dict([
        (u'imsi', _SetReportingStateArg_imsi),
        (u'lmsi', _SetReportingStateArg_lmsi),
        (u'ccbs-Monitoring', _SetReportingStateArg_ccbs_Monitoring),
        (u'extensionContainer', _SetReportingStateArg_extensionContainer),
        ])
    SetReportingStateArg._ext = []
    
    #-----< ReportingState >-----#
    ReportingState = ENUM(name=u'ReportingState', mode=MODE_TYPE)
    ReportingState._cont = ASN1Dict([(u'stopMonitoring', 0), (u'startMonitoring', 1)])
    ReportingState._ext = []
    
    #-----< SetReportingStateRes >-----#
    SetReportingStateRes = SEQ(name=u'SetReportingStateRes', mode=MODE_TYPE)
    _SetReportingStateRes_ccbs_SubscriberStatus = ENUM(name=u'ccbs-SubscriberStatus', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CCBS-SubscriberStatus')), opt=True)
    _SetReportingStateRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SetReportingStateRes._cont = ASN1Dict([
        (u'ccbs-SubscriberStatus', _SetReportingStateRes_ccbs_SubscriberStatus),
        (u'extensionContainer', _SetReportingStateRes_extensionContainer),
        ])
    SetReportingStateRes._ext = []
    
    #-----< CCBS-SubscriberStatus >-----#
    CCBS_SubscriberStatus = ENUM(name=u'CCBS-SubscriberStatus', mode=MODE_TYPE)
    CCBS_SubscriberStatus._cont = ASN1Dict([(u'ccbsNotIdle', 0), (u'ccbsIdle', 1), (u'ccbsNotReachable', 2)])
    CCBS_SubscriberStatus._ext = []
    
    #-----< StatusReportArg >-----#
    StatusReportArg = SEQ(name=u'StatusReportArg', mode=MODE_TYPE)
    _StatusReportArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _StatusReportArg_eventReportData = SEQ(name=u'eventReportData', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'EventReportData')), opt=True)
    _StatusReportArg_callReportdata = SEQ(name=u'callReportdata', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CallReportData')), opt=True)
    _StatusReportArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    StatusReportArg._cont = ASN1Dict([
        (u'imsi', _StatusReportArg_imsi),
        (u'eventReportData', _StatusReportArg_eventReportData),
        (u'callReportdata', _StatusReportArg_callReportdata),
        (u'extensionContainer', _StatusReportArg_extensionContainer),
        ])
    StatusReportArg._ext = []
    
    #-----< EventReportData >-----#
    EventReportData = SEQ(name=u'EventReportData', mode=MODE_TYPE)
    _EventReportData_ccbs_SubscriberStatus = ENUM(name=u'ccbs-SubscriberStatus', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CCBS-SubscriberStatus')), opt=True)
    _EventReportData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    EventReportData._cont = ASN1Dict([
        (u'ccbs-SubscriberStatus', _EventReportData_ccbs_SubscriberStatus),
        (u'extensionContainer', _EventReportData_extensionContainer),
        ])
    EventReportData._ext = []
    
    #-----< CallReportData >-----#
    CallReportData = SEQ(name=u'CallReportData', mode=MODE_TYPE)
    _CallReportData_monitoringMode = ENUM(name=u'monitoringMode', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'MonitoringMode')), opt=True)
    _CallReportData_callOutcome = ENUM(name=u'callOutcome', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CallOutcome')), opt=True)
    _CallReportData_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CallReportData._cont = ASN1Dict([
        (u'monitoringMode', _CallReportData_monitoringMode),
        (u'callOutcome', _CallReportData_callOutcome),
        (u'extensionContainer', _CallReportData_extensionContainer),
        ])
    CallReportData._ext = []
    
    #-----< MonitoringMode >-----#
    MonitoringMode = ENUM(name=u'MonitoringMode', mode=MODE_TYPE)
    MonitoringMode._cont = ASN1Dict([(u'a-side', 0), (u'b-side', 1)])
    MonitoringMode._ext = []
    
    #-----< CallOutcome >-----#
    CallOutcome = ENUM(name=u'CallOutcome', mode=MODE_TYPE)
    CallOutcome._cont = ASN1Dict([(u'success', 0), (u'failure', 1), (u'busy', 2)])
    CallOutcome._ext = []
    
    #-----< StatusReportRes >-----#
    StatusReportRes = SEQ(name=u'StatusReportRes', mode=MODE_TYPE)
    _StatusReportRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    StatusReportRes._cont = ASN1Dict([
        (u'extensionContainer', _StatusReportRes_extensionContainer),
        ])
    StatusReportRes._ext = []
    
    #-----< RemoteUserFreeArg >-----#
    RemoteUserFreeArg = SEQ(name=u'RemoteUserFreeArg', mode=MODE_TYPE)
    _RemoteUserFreeArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _RemoteUserFreeArg_callInfo = SEQ(name=u'callInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ExternalSignalInfo')))
    _RemoteUserFreeArg_ccbs_Feature = SEQ(name=u'ccbs-Feature', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CCBS-Feature')))
    _RemoteUserFreeArg_translatedB_Number = OCT_STR(name=u'translatedB-Number', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _RemoteUserFreeArg_replaceB_Number = NULL(name=u'replaceB-Number', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RemoteUserFreeArg_alertingPattern = OCT_STR(name=u'alertingPattern', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')), opt=True)
    _RemoteUserFreeArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    RemoteUserFreeArg._cont = ASN1Dict([
        (u'imsi', _RemoteUserFreeArg_imsi),
        (u'callInfo', _RemoteUserFreeArg_callInfo),
        (u'ccbs-Feature', _RemoteUserFreeArg_ccbs_Feature),
        (u'translatedB-Number', _RemoteUserFreeArg_translatedB_Number),
        (u'replaceB-Number', _RemoteUserFreeArg_replaceB_Number),
        (u'alertingPattern', _RemoteUserFreeArg_alertingPattern),
        (u'extensionContainer', _RemoteUserFreeArg_extensionContainer),
        ])
    RemoteUserFreeArg._ext = []
    
    #-----< RemoteUserFreeRes >-----#
    RemoteUserFreeRes = SEQ(name=u'RemoteUserFreeRes', mode=MODE_TYPE)
    _RemoteUserFreeRes_ruf_Outcome = ENUM(name=u'ruf-Outcome', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'RUF-Outcome')))
    _RemoteUserFreeRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    RemoteUserFreeRes._cont = ASN1Dict([
        (u'ruf-Outcome', _RemoteUserFreeRes_ruf_Outcome),
        (u'extensionContainer', _RemoteUserFreeRes_extensionContainer),
        ])
    RemoteUserFreeRes._ext = []
    
    #-----< RUF-Outcome >-----#
    RUF_Outcome = ENUM(name=u'RUF-Outcome', mode=MODE_TYPE)
    RUF_Outcome._cont = ASN1Dict([(u'accepted', 0), (u'rejected', 1), (u'noResponseFromFreeMS', 2), (u'noResponseFromBusyMS', 3), (u'udubFromFreeMS', 4), (u'udubFromBusyMS', 5)])
    RUF_Outcome._ext = []
    
    #-----< IST-AlertArg >-----#
    IST_AlertArg = SEQ(name=u'IST-AlertArg', mode=MODE_TYPE)
    _IST_AlertArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _IST_AlertArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    IST_AlertArg._cont = ASN1Dict([
        (u'imsi', _IST_AlertArg_imsi),
        (u'extensionContainer', _IST_AlertArg_extensionContainer),
        ])
    IST_AlertArg._ext = []
    
    #-----< IST-AlertRes >-----#
    IST_AlertRes = SEQ(name=u'IST-AlertRes', mode=MODE_TYPE)
    _IST_AlertRes_istAlertTimer = INT(name=u'istAlertTimer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'IST-AlertTimerValue')), opt=True)
    _IST_AlertRes_istInformationWithdraw = NULL(name=u'istInformationWithdraw', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _IST_AlertRes_callTerminationIndicator = ENUM(name=u'callTerminationIndicator', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CH-DataTypes', 'CallTerminationIndicator')), opt=True)
    _IST_AlertRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    IST_AlertRes._cont = ASN1Dict([
        (u'istAlertTimer', _IST_AlertRes_istAlertTimer),
        (u'istInformationWithdraw', _IST_AlertRes_istInformationWithdraw),
        (u'callTerminationIndicator', _IST_AlertRes_callTerminationIndicator),
        (u'extensionContainer', _IST_AlertRes_extensionContainer),
        ])
    IST_AlertRes._ext = []
    
    #-----< IST-CommandArg >-----#
    IST_CommandArg = SEQ(name=u'IST-CommandArg', mode=MODE_TYPE)
    _IST_CommandArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _IST_CommandArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    IST_CommandArg._cont = ASN1Dict([
        (u'imsi', _IST_CommandArg_imsi),
        (u'extensionContainer', _IST_CommandArg_extensionContainer),
        ])
    IST_CommandArg._ext = []
    
    #-----< IST-CommandRes >-----#
    IST_CommandRes = SEQ(name=u'IST-CommandRes', mode=MODE_TYPE)
    _IST_CommandRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    IST_CommandRes._cont = ASN1Dict([
        (u'extensionContainer', _IST_CommandRes_extensionContainer),
        ])
    IST_CommandRes._ext = []
    
    #-----< CallTerminationIndicator >-----#
    CallTerminationIndicator = ENUM(name=u'CallTerminationIndicator', mode=MODE_TYPE)
    CallTerminationIndicator._cont = ASN1Dict([(u'terminateCallActivityReferred', 0), (u'terminateAllCallActivities', 1)])
    CallTerminationIndicator._ext = []
    
    #-----< ReleaseResourcesArg >-----#
    ReleaseResourcesArg = SEQ(name=u'ReleaseResourcesArg', mode=MODE_TYPE)
    _ReleaseResourcesArg_msrn = OCT_STR(name=u'msrn', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _ReleaseResourcesArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ReleaseResourcesArg._cont = ASN1Dict([
        (u'msrn', _ReleaseResourcesArg_msrn),
        (u'extensionContainer', _ReleaseResourcesArg_extensionContainer),
        ])
    ReleaseResourcesArg._ext = []
    
    #-----< ReleaseResourcesRes >-----#
    ReleaseResourcesRes = SEQ(name=u'ReleaseResourcesRes', mode=MODE_TYPE)
    _ReleaseResourcesRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ReleaseResourcesRes._cont = ASN1Dict([
        (u'extensionContainer', _ReleaseResourcesRes_extensionContainer),
        ])
    ReleaseResourcesRes._ext = []
    
    _all_ = [
        _CUG_CheckInfo_cug_Interlock,
        _CUG_CheckInfo_cug_OutgoingAccess,
        _CUG_CheckInfo_extensionContainer,
        CUG_CheckInfo,
        NumberOfForwarding,
        _SendRoutingInfoArg_msisdn,
        _SendRoutingInfoArg_cug_CheckInfo,
        _SendRoutingInfoArg_numberOfForwarding,
        _SendRoutingInfoArg_interrogationType,
        _SendRoutingInfoArg_or_Interrogation,
        _SendRoutingInfoArg_or_Capability,
        _SendRoutingInfoArg_gmsc_OrGsmSCF_Address,
        _SendRoutingInfoArg_callReferenceNumber,
        _SendRoutingInfoArg_forwardingReason,
        _SendRoutingInfoArg_basicServiceGroup,
        _SendRoutingInfoArg_networkSignalInfo,
        _SendRoutingInfoArg_camelInfo,
        _SendRoutingInfoArg_suppressionOfAnnouncement,
        _SendRoutingInfoArg_extensionContainer,
        _SendRoutingInfoArg_alertingPattern,
        _SendRoutingInfoArg_ccbs_Call,
        _SendRoutingInfoArg_supportedCCBS_Phase,
        _SendRoutingInfoArg_additionalSignalInfo,
        _SendRoutingInfoArg_istSupportIndicator,
        _SendRoutingInfoArg_pre_pagingSupported,
        _SendRoutingInfoArg_callDiversionTreatmentIndicator,
        _SendRoutingInfoArg_longFTN_Supported,
        _SendRoutingInfoArg_suppress_VT_CSI,
        _SendRoutingInfoArg_suppressIncomingCallBarring,
        _SendRoutingInfoArg_gsmSCF_InitiatedCall,
        _SendRoutingInfoArg_basicServiceGroup2,
        _SendRoutingInfoArg_networkSignalInfo2,
        _SendRoutingInfoArg_suppressMTSS,
        _SendRoutingInfoArg_mtRoamingRetrySupported,
        _SendRoutingInfoArg_callPriority,
        SendRoutingInfoArg,
        SuppressionOfAnnouncement,
        SuppressMTSS,
        InterrogationType,
        OR_Phase,
        CallReferenceNumber,
        ForwardingReason,
        SupportedCCBS_Phase,
        CallDiversionTreatmentIndicator,
        _SendRoutingInfoRes_imsi,
        _SendRoutingInfoRes_extendedRoutingInfo,
        _SendRoutingInfoRes_cug_CheckInfo,
        _SendRoutingInfoRes_cugSubscriptionFlag,
        _SendRoutingInfoRes_subscriberInfo,
        _SendRoutingInfoRes_ss_List,
        _SendRoutingInfoRes_basicService,
        _SendRoutingInfoRes_forwardingInterrogationRequired,
        _SendRoutingInfoRes_vmsc_Address,
        _SendRoutingInfoRes_extensionContainer,
        _SendRoutingInfoRes_naea_PreferredCI,
        _SendRoutingInfoRes_ccbs_Indicators,
        _SendRoutingInfoRes_msisdn,
        _SendRoutingInfoRes_numberPortabilityStatus,
        _SendRoutingInfoRes_istAlertTimer,
        _SendRoutingInfoRes_supportedCamelPhasesInVMSC,
        _SendRoutingInfoRes_offeredCamel4CSIsInVMSC,
        _SendRoutingInfoRes_routingInfo2,
        _SendRoutingInfoRes_ss_List2,
        _SendRoutingInfoRes_basicService2,
        _SendRoutingInfoRes_allowedServices,
        _SendRoutingInfoRes_unavailabilityCause,
        _SendRoutingInfoRes_releaseResourcesSupported,
        _SendRoutingInfoRes_gsm_BearerCapability,
        SendRoutingInfoRes,
        AllowedServices,
        UnavailabilityCause,
        _CCBS_Indicators_ccbs_Possible,
        _CCBS_Indicators_keepCCBS_CallIndicator,
        _CCBS_Indicators_extensionContainer,
        CCBS_Indicators,
        _RoutingInfo_roamingNumber,
        _RoutingInfo_forwardingData,
        RoutingInfo,
        _ForwardingData_forwardedToNumber,
        _ForwardingData_forwardedToSubaddress,
        _ForwardingData_forwardingOptions,
        _ForwardingData_extensionContainer,
        _ForwardingData_longForwardedToNumber,
        ForwardingData,
        _ProvideRoamingNumberArg_imsi,
        _ProvideRoamingNumberArg_msc_Number,
        _ProvideRoamingNumberArg_msisdn,
        _ProvideRoamingNumberArg_lmsi,
        _ProvideRoamingNumberArg_gsm_BearerCapability,
        _ProvideRoamingNumberArg_networkSignalInfo,
        _ProvideRoamingNumberArg_suppressionOfAnnouncement,
        _ProvideRoamingNumberArg_gmsc_Address,
        _ProvideRoamingNumberArg_callReferenceNumber,
        _ProvideRoamingNumberArg_or_Interrogation,
        _ProvideRoamingNumberArg_extensionContainer,
        _ProvideRoamingNumberArg_alertingPattern,
        _ProvideRoamingNumberArg_ccbs_Call,
        _ProvideRoamingNumberArg_supportedCamelPhasesInInterrogatingNode,
        _ProvideRoamingNumberArg_additionalSignalInfo,
        _ProvideRoamingNumberArg_orNotSupportedInGMSC,
        _ProvideRoamingNumberArg_pre_pagingSupported,
        _ProvideRoamingNumberArg_longFTN_Supported,
        _ProvideRoamingNumberArg_suppress_VT_CSI,
        _ProvideRoamingNumberArg_offeredCamel4CSIsInInterrogatingNode,
        _ProvideRoamingNumberArg_mtRoamingRetrySupported,
        _ProvideRoamingNumberArg_pagingArea,
        _ProvideRoamingNumberArg_callPriority,
        _ProvideRoamingNumberArg_mtrf_Indicator,
        _ProvideRoamingNumberArg_oldMSC_Number,
        _ProvideRoamingNumberArg_lastUsedLtePLMN_Id,
        ProvideRoamingNumberArg,
        _ProvideRoamingNumberRes_roamingNumber,
        _ProvideRoamingNumberRes_extensionContainer,
        _ProvideRoamingNumberRes_releaseResourcesSupported,
        _ProvideRoamingNumberRes_vmsc_Address,
        ProvideRoamingNumberRes,
        _ResumeCallHandlingArg_callReferenceNumber,
        _ResumeCallHandlingArg_basicServiceGroup,
        _ResumeCallHandlingArg_forwardingData,
        _ResumeCallHandlingArg_imsi,
        _ResumeCallHandlingArg_cug_CheckInfo,
        _ResumeCallHandlingArg_o_CSI,
        _ResumeCallHandlingArg_extensionContainer,
        _ResumeCallHandlingArg_ccbs_Possible,
        _ResumeCallHandlingArg_msisdn,
        _ResumeCallHandlingArg_uu_Data,
        _ResumeCallHandlingArg_allInformationSent,
        _ResumeCallHandlingArg_d_csi,
        _ResumeCallHandlingArg_o_BcsmCamelTDPCriteriaList,
        _ResumeCallHandlingArg_basicServiceGroup2,
        _ResumeCallHandlingArg_mtRoamingRetry,
        ResumeCallHandlingArg,
        _UU_Data_uuIndicator,
        _UU_Data_uui,
        _UU_Data_uusCFInteraction,
        _UU_Data_extensionContainer,
        UU_Data,
        UUIndicator,
        UUI,
        _ResumeCallHandlingRes_extensionContainer,
        ResumeCallHandlingRes,
        _CamelInfo_supportedCamelPhases,
        _CamelInfo_suppress_T_CSI,
        _CamelInfo_extensionContainer,
        _CamelInfo_offeredCamel4CSIs,
        CamelInfo,
        _ExtendedRoutingInfo_routingInfo,
        _ExtendedRoutingInfo_camelRoutingInfo,
        ExtendedRoutingInfo,
        _CamelRoutingInfo_forwardingData,
        _CamelRoutingInfo_gmscCamelSubscriptionInfo,
        _CamelRoutingInfo_extensionContainer,
        CamelRoutingInfo,
        _GmscCamelSubscriptionInfo_t_CSI,
        _GmscCamelSubscriptionInfo_o_CSI,
        _GmscCamelSubscriptionInfo_extensionContainer,
        _GmscCamelSubscriptionInfo_o_BcsmCamelTDP_CriteriaList,
        _GmscCamelSubscriptionInfo_t_BCSM_CAMEL_TDP_CriteriaList,
        _GmscCamelSubscriptionInfo_d_csi,
        GmscCamelSubscriptionInfo,
        _SetReportingStateArg_imsi,
        _SetReportingStateArg_lmsi,
        _SetReportingStateArg_ccbs_Monitoring,
        _SetReportingStateArg_extensionContainer,
        SetReportingStateArg,
        ReportingState,
        _SetReportingStateRes_ccbs_SubscriberStatus,
        _SetReportingStateRes_extensionContainer,
        SetReportingStateRes,
        CCBS_SubscriberStatus,
        _StatusReportArg_imsi,
        _StatusReportArg_eventReportData,
        _StatusReportArg_callReportdata,
        _StatusReportArg_extensionContainer,
        StatusReportArg,
        _EventReportData_ccbs_SubscriberStatus,
        _EventReportData_extensionContainer,
        EventReportData,
        _CallReportData_monitoringMode,
        _CallReportData_callOutcome,
        _CallReportData_extensionContainer,
        CallReportData,
        MonitoringMode,
        CallOutcome,
        _StatusReportRes_extensionContainer,
        StatusReportRes,
        _RemoteUserFreeArg_imsi,
        _RemoteUserFreeArg_callInfo,
        _RemoteUserFreeArg_ccbs_Feature,
        _RemoteUserFreeArg_translatedB_Number,
        _RemoteUserFreeArg_replaceB_Number,
        _RemoteUserFreeArg_alertingPattern,
        _RemoteUserFreeArg_extensionContainer,
        RemoteUserFreeArg,
        _RemoteUserFreeRes_ruf_Outcome,
        _RemoteUserFreeRes_extensionContainer,
        RemoteUserFreeRes,
        RUF_Outcome,
        _IST_AlertArg_imsi,
        _IST_AlertArg_extensionContainer,
        IST_AlertArg,
        _IST_AlertRes_istAlertTimer,
        _IST_AlertRes_istInformationWithdraw,
        _IST_AlertRes_callTerminationIndicator,
        _IST_AlertRes_extensionContainer,
        IST_AlertRes,
        _IST_CommandArg_imsi,
        _IST_CommandArg_extensionContainer,
        IST_CommandArg,
        _IST_CommandRes_extensionContainer,
        IST_CommandRes,
        CallTerminationIndicator,
        _ReleaseResourcesArg_msrn,
        _ReleaseResourcesArg_extensionContainer,
        ReleaseResourcesArg,
        _ReleaseResourcesRes_extensionContainer,
        ReleaseResourcesRes,
    ]

class MAP_SS_DataTypes:

    _name_  = u'MAP-SS-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 14, 16]
    
    _obj_ = [
        u'RegisterSS-Arg',
        u'NoReplyConditionTime',
        u'SS-Info',
        u'ForwardingInfo',
        u'ForwardingFeatureList',
        u'ForwardingFeature',
        u'SS-Status',
        u'ForwardingOptions',
        u'CallBarringInfo',
        u'CallBarringFeatureList',
        u'CallBarringFeature',
        u'SS-Data',
        u'SS-SubscriptionOption',
        u'CliRestrictionOption',
        u'OverrideCategory',
        u'SS-ForBS-Code',
        u'GenericServiceInfo',
        u'CCBS-FeatureList',
        u'maxNumOfCCBS-Requests',
        u'CCBS-Feature',
        u'CCBS-Index',
        u'InterrogateSS-Res',
        u'USSD-Arg',
        u'USSD-Res',
        u'USSD-DataCodingScheme',
        u'USSD-String',
        u'maxUSSD-StringLength',
        u'Password',
        u'GuidanceInfo',
        u'SS-List',
        u'maxNumOfSS',
        u'SS-InfoList',
        u'BasicServiceGroupList',
        u'maxNumOfBasicServiceGroups',
        u'SS-InvocationNotificationArg',
        u'CCBS-RequestState',
        u'SS-InvocationNotificationRes',
        u'SS-EventSpecification',
        u'maxEventSpecification',
        u'RegisterCC-EntryArg',
        u'CCBS-Data',
        u'ServiceIndicator',
        u'RegisterCC-EntryRes',
        u'EraseCC-EntryArg',
        u'EraseCC-EntryRes',
        ]
    _type_ = [
        u'RegisterSS-Arg',
        u'NoReplyConditionTime',
        u'SS-Info',
        u'ForwardingInfo',
        u'ForwardingFeatureList',
        u'ForwardingFeature',
        u'SS-Status',
        u'ForwardingOptions',
        u'CallBarringInfo',
        u'CallBarringFeatureList',
        u'CallBarringFeature',
        u'SS-Data',
        u'SS-SubscriptionOption',
        u'CliRestrictionOption',
        u'OverrideCategory',
        u'SS-ForBS-Code',
        u'GenericServiceInfo',
        u'CCBS-FeatureList',
        u'CCBS-Feature',
        u'CCBS-Index',
        u'InterrogateSS-Res',
        u'USSD-Arg',
        u'USSD-Res',
        u'USSD-DataCodingScheme',
        u'USSD-String',
        u'Password',
        u'GuidanceInfo',
        u'SS-List',
        u'SS-InfoList',
        u'BasicServiceGroupList',
        u'SS-InvocationNotificationArg',
        u'CCBS-RequestState',
        u'SS-InvocationNotificationRes',
        u'SS-EventSpecification',
        u'RegisterCC-EntryArg',
        u'CCBS-Data',
        u'ServiceIndicator',
        u'RegisterCC-EntryRes',
        u'EraseCC-EntryArg',
        u'EraseCC-EntryRes',
        ]
    _set_ = [
        ]
    _val_ = [
        u'maxNumOfCCBS-Requests',
        u'maxUSSD-StringLength',
        u'maxNumOfSS',
        u'maxNumOfBasicServiceGroups',
        u'maxEventSpecification',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< RegisterSS-Arg >-----#
    RegisterSS_Arg = SEQ(name=u'RegisterSS-Arg', mode=MODE_TYPE)
    _RegisterSS_Arg_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _RegisterSS_Arg_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'BasicServiceCode')), opt=True)
    _RegisterSS_Arg_forwardedToNumber = OCT_STR(name=u'forwardedToNumber', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AddressString')), opt=True)
    _RegisterSS_Arg_forwardedToSubaddress = OCT_STR(name=u'forwardedToSubaddress', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-SubaddressString')), opt=True)
    _RegisterSS_Arg_noReplyConditionTime = INT(name=u'noReplyConditionTime', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'NoReplyConditionTime')), opt=True)
    _RegisterSS_Arg_defaultPriority = INT(name=u'defaultPriority', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')), opt=True)
    _RegisterSS_Arg_nbrUser = INT(name=u'nbrUser', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'MC-Bearers')), opt=True)
    _RegisterSS_Arg_longFTN_Supported = NULL(name=u'longFTN-Supported', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    RegisterSS_Arg._cont = ASN1Dict([
        (u'ss-Code', _RegisterSS_Arg_ss_Code),
        (u'basicService', _RegisterSS_Arg_basicService),
        (u'forwardedToNumber', _RegisterSS_Arg_forwardedToNumber),
        (u'forwardedToSubaddress', _RegisterSS_Arg_forwardedToSubaddress),
        (u'noReplyConditionTime', _RegisterSS_Arg_noReplyConditionTime),
        (u'defaultPriority', _RegisterSS_Arg_defaultPriority),
        (u'nbrUser', _RegisterSS_Arg_nbrUser),
        (u'longFTN-Supported', _RegisterSS_Arg_longFTN_Supported),
        ])
    RegisterSS_Arg._ext = [u'defaultPriority', u'nbrUser', u'longFTN-Supported']
    
    #-----< NoReplyConditionTime >-----#
    NoReplyConditionTime = INT(name=u'NoReplyConditionTime', mode=MODE_TYPE)
    NoReplyConditionTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=5, ub=30)], ev=None, er=[])
    
    #-----< SS-Info >-----#
    SS_Info = CHOICE(name=u'SS-Info', mode=MODE_TYPE)
    _SS_Info_forwardingInfo = SEQ(name=u'forwardingInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'ForwardingInfo')))
    _SS_Info_callBarringInfo = SEQ(name=u'callBarringInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CallBarringInfo')))
    _SS_Info_ss_Data = SEQ(name=u'ss-Data', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-Data')))
    SS_Info._cont = ASN1Dict([
        (u'forwardingInfo', _SS_Info_forwardingInfo),
        (u'callBarringInfo', _SS_Info_callBarringInfo),
        (u'ss-Data', _SS_Info_ss_Data),
        ])
    SS_Info._ext = None
    
    #-----< ForwardingInfo >-----#
    ForwardingInfo = SEQ(name=u'ForwardingInfo', mode=MODE_TYPE)
    _ForwardingInfo_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')), opt=True)
    _ForwardingInfo_forwardingFeatureList = SEQ_OF(name=u'forwardingFeatureList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'ForwardingFeatureList')))
    ForwardingInfo._cont = ASN1Dict([
        (u'ss-Code', _ForwardingInfo_ss_Code),
        (u'forwardingFeatureList', _ForwardingInfo_forwardingFeatureList),
        ])
    ForwardingInfo._ext = []
    
    #-----< ForwardingFeatureList >-----#
    ForwardingFeatureList = SEQ_OF(name=u'ForwardingFeatureList', mode=MODE_TYPE)
    _ForwardingFeatureList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'ForwardingFeature')))
    ForwardingFeatureList._cont = _ForwardingFeatureList__item_
    ForwardingFeatureList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=13)], ev=None, er=[])
    
    #-----< ForwardingFeature >-----#
    ForwardingFeature = SEQ(name=u'ForwardingFeature', mode=MODE_TYPE)
    _ForwardingFeature_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'BasicServiceCode')), opt=True)
    _ForwardingFeature_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-Status')), opt=True)
    _ForwardingFeature_forwardedToNumber = OCT_STR(name=u'forwardedToNumber', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _ForwardingFeature_forwardedToSubaddress = OCT_STR(name=u'forwardedToSubaddress', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-SubaddressString')), opt=True)
    _ForwardingFeature_forwardingOptions = OCT_STR(name=u'forwardingOptions', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'ForwardingOptions')), opt=True)
    _ForwardingFeature_noReplyConditionTime = INT(name=u'noReplyConditionTime', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'NoReplyConditionTime')), opt=True)
    _ForwardingFeature_longForwardedToNumber = OCT_STR(name=u'longForwardedToNumber', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'FTN-AddressString')), opt=True)
    ForwardingFeature._cont = ASN1Dict([
        (u'basicService', _ForwardingFeature_basicService),
        (u'ss-Status', _ForwardingFeature_ss_Status),
        (u'forwardedToNumber', _ForwardingFeature_forwardedToNumber),
        (u'forwardedToSubaddress', _ForwardingFeature_forwardedToSubaddress),
        (u'forwardingOptions', _ForwardingFeature_forwardingOptions),
        (u'noReplyConditionTime', _ForwardingFeature_noReplyConditionTime),
        (u'longForwardedToNumber', _ForwardingFeature_longForwardedToNumber),
        ])
    ForwardingFeature._ext = [u'longForwardedToNumber']
    
    #-----< SS-Status >-----#
    SS_Status = OCT_STR(name=u'SS-Status', mode=MODE_TYPE)
    SS_Status._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< ForwardingOptions >-----#
    ForwardingOptions = OCT_STR(name=u'ForwardingOptions', mode=MODE_TYPE)
    ForwardingOptions._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< CallBarringInfo >-----#
    CallBarringInfo = SEQ(name=u'CallBarringInfo', mode=MODE_TYPE)
    _CallBarringInfo_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')), opt=True)
    _CallBarringInfo_callBarringFeatureList = SEQ_OF(name=u'callBarringFeatureList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'CallBarringFeatureList')))
    CallBarringInfo._cont = ASN1Dict([
        (u'ss-Code', _CallBarringInfo_ss_Code),
        (u'callBarringFeatureList', _CallBarringInfo_callBarringFeatureList),
        ])
    CallBarringInfo._ext = []
    
    #-----< CallBarringFeatureList >-----#
    CallBarringFeatureList = SEQ_OF(name=u'CallBarringFeatureList', mode=MODE_TYPE)
    _CallBarringFeatureList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'CallBarringFeature')))
    CallBarringFeatureList._cont = _CallBarringFeatureList__item_
    CallBarringFeatureList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=13)], ev=None, er=[])
    
    #-----< CallBarringFeature >-----#
    CallBarringFeature = SEQ(name=u'CallBarringFeature', mode=MODE_TYPE)
    _CallBarringFeature_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'BasicServiceCode')), opt=True)
    _CallBarringFeature_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-Status')), opt=True)
    CallBarringFeature._cont = ASN1Dict([
        (u'basicService', _CallBarringFeature_basicService),
        (u'ss-Status', _CallBarringFeature_ss_Status),
        ])
    CallBarringFeature._ext = []
    
    #-----< SS-Data >-----#
    SS_Data = SEQ(name=u'SS-Data', mode=MODE_TYPE)
    _SS_Data_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')), opt=True)
    _SS_Data_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-Status')), opt=True)
    _SS_Data_ss_SubscriptionOption = CHOICE(name=u'ss-SubscriptionOption', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-SubscriptionOption')), opt=True)
    _SS_Data_basicServiceGroupList = SEQ_OF(name=u'basicServiceGroupList', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'BasicServiceGroupList')), opt=True)
    _SS_Data_defaultPriority = INT(name=u'defaultPriority', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')), opt=True)
    _SS_Data_nbrUser = INT(name=u'nbrUser', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'MC-Bearers')), opt=True)
    SS_Data._cont = ASN1Dict([
        (u'ss-Code', _SS_Data_ss_Code),
        (u'ss-Status', _SS_Data_ss_Status),
        (u'ss-SubscriptionOption', _SS_Data_ss_SubscriptionOption),
        (u'basicServiceGroupList', _SS_Data_basicServiceGroupList),
        (u'defaultPriority', _SS_Data_defaultPriority),
        (u'nbrUser', _SS_Data_nbrUser),
        ])
    SS_Data._ext = [u'defaultPriority', u'nbrUser']
    
    #-----< SS-SubscriptionOption >-----#
    SS_SubscriptionOption = CHOICE(name=u'SS-SubscriptionOption', mode=MODE_TYPE)
    _SS_SubscriptionOption_cliRestrictionOption = ENUM(name=u'cliRestrictionOption', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CliRestrictionOption')))
    _SS_SubscriptionOption_overrideCategory = ENUM(name=u'overrideCategory', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'OverrideCategory')))
    SS_SubscriptionOption._cont = ASN1Dict([
        (u'cliRestrictionOption', _SS_SubscriptionOption_cliRestrictionOption),
        (u'overrideCategory', _SS_SubscriptionOption_overrideCategory),
        ])
    SS_SubscriptionOption._ext = None
    
    #-----< CliRestrictionOption >-----#
    CliRestrictionOption = ENUM(name=u'CliRestrictionOption', mode=MODE_TYPE)
    CliRestrictionOption._cont = ASN1Dict([(u'permanent', 0), (u'temporaryDefaultRestricted', 1), (u'temporaryDefaultAllowed', 2)])
    CliRestrictionOption._ext = None
    
    #-----< OverrideCategory >-----#
    OverrideCategory = ENUM(name=u'OverrideCategory', mode=MODE_TYPE)
    OverrideCategory._cont = ASN1Dict([(u'overrideEnabled', 0), (u'overrideDisabled', 1)])
    OverrideCategory._ext = None
    
    #-----< SS-ForBS-Code >-----#
    SS_ForBS_Code = SEQ(name=u'SS-ForBS-Code', mode=MODE_TYPE)
    _SS_ForBS_Code_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _SS_ForBS_Code_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'BasicServiceCode')), opt=True)
    _SS_ForBS_Code_longFTN_Supported = NULL(name=u'longFTN-Supported', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    SS_ForBS_Code._cont = ASN1Dict([
        (u'ss-Code', _SS_ForBS_Code_ss_Code),
        (u'basicService', _SS_ForBS_Code_basicService),
        (u'longFTN-Supported', _SS_ForBS_Code_longFTN_Supported),
        ])
    SS_ForBS_Code._ext = [u'longFTN-Supported']
    
    #-----< GenericServiceInfo >-----#
    GenericServiceInfo = SEQ(name=u'GenericServiceInfo', mode=MODE_TYPE)
    _GenericServiceInfo_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-Status')))
    _GenericServiceInfo_cliRestrictionOption = ENUM(name=u'cliRestrictionOption', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'CliRestrictionOption')), opt=True)
    _GenericServiceInfo_maximumEntitledPriority = INT(name=u'maximumEntitledPriority', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')), opt=True)
    _GenericServiceInfo_defaultPriority = INT(name=u'defaultPriority', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'EMLPP-Priority')), opt=True)
    _GenericServiceInfo_ccbs_FeatureList = SEQ_OF(name=u'ccbs-FeatureList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CCBS-FeatureList')), opt=True)
    _GenericServiceInfo_nbrSB = INT(name=u'nbrSB', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'MaxMC-Bearers')), opt=True)
    _GenericServiceInfo_nbrUser = INT(name=u'nbrUser', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'MC-Bearers')), opt=True)
    _GenericServiceInfo_nbrSN = INT(name=u'nbrSN', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'MC-Bearers')), opt=True)
    GenericServiceInfo._cont = ASN1Dict([
        (u'ss-Status', _GenericServiceInfo_ss_Status),
        (u'cliRestrictionOption', _GenericServiceInfo_cliRestrictionOption),
        (u'maximumEntitledPriority', _GenericServiceInfo_maximumEntitledPriority),
        (u'defaultPriority', _GenericServiceInfo_defaultPriority),
        (u'ccbs-FeatureList', _GenericServiceInfo_ccbs_FeatureList),
        (u'nbrSB', _GenericServiceInfo_nbrSB),
        (u'nbrUser', _GenericServiceInfo_nbrUser),
        (u'nbrSN', _GenericServiceInfo_nbrSN),
        ])
    GenericServiceInfo._ext = [u'maximumEntitledPriority', u'defaultPriority', u'ccbs-FeatureList', u'nbrSB', u'nbrUser', u'nbrSN']
    
    #-----< CCBS-FeatureList >-----#
    CCBS_FeatureList = SEQ_OF(name=u'CCBS-FeatureList', mode=MODE_TYPE)
    _CCBS_FeatureList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'CCBS-Feature')))
    CCBS_FeatureList._cont = _CCBS_FeatureList__item_
    CCBS_FeatureList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< maxNumOfCCBS-Requests >-----#
    maxNumOfCCBS_Requests = INT(name=u'maxNumOfCCBS-Requests', mode=MODE_VALUE)
    maxNumOfCCBS_Requests._val = 5
    
    #-----< CCBS-Feature >-----#
    CCBS_Feature = SEQ(name=u'CCBS-Feature', mode=MODE_TYPE)
    _CCBS_Feature_ccbs_Index = INT(name=u'ccbs-Index', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CCBS-Index')), opt=True)
    _CCBS_Feature_b_subscriberNumber = OCT_STR(name=u'b-subscriberNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _CCBS_Feature_b_subscriberSubaddress = OCT_STR(name=u'b-subscriberSubaddress', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-SubaddressString')), opt=True)
    _CCBS_Feature_basicServiceGroup = CHOICE(name=u'basicServiceGroup', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'BasicServiceCode')), opt=True)
    CCBS_Feature._cont = ASN1Dict([
        (u'ccbs-Index', _CCBS_Feature_ccbs_Index),
        (u'b-subscriberNumber', _CCBS_Feature_b_subscriberNumber),
        (u'b-subscriberSubaddress', _CCBS_Feature_b_subscriberSubaddress),
        (u'basicServiceGroup', _CCBS_Feature_basicServiceGroup),
        ])
    CCBS_Feature._ext = []
    
    #-----< CCBS-Index >-----#
    CCBS_Index = INT(name=u'CCBS-Index', mode=MODE_TYPE)
    CCBS_Index._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=5)], ev=None, er=[])
    
    #-----< InterrogateSS-Res >-----#
    InterrogateSS_Res = CHOICE(name=u'InterrogateSS-Res', mode=MODE_TYPE)
    _InterrogateSS_Res_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-Status')))
    _InterrogateSS_Res_basicServiceGroupList = SEQ_OF(name=u'basicServiceGroupList', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'BasicServiceGroupList')))
    _InterrogateSS_Res_forwardingFeatureList = SEQ_OF(name=u'forwardingFeatureList', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'ForwardingFeatureList')))
    _InterrogateSS_Res_genericServiceInfo = SEQ(name=u'genericServiceInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'GenericServiceInfo')))
    InterrogateSS_Res._cont = ASN1Dict([
        (u'ss-Status', _InterrogateSS_Res_ss_Status),
        (u'basicServiceGroupList', _InterrogateSS_Res_basicServiceGroupList),
        (u'forwardingFeatureList', _InterrogateSS_Res_forwardingFeatureList),
        (u'genericServiceInfo', _InterrogateSS_Res_genericServiceInfo),
        ])
    InterrogateSS_Res._ext = None
    
    #-----< USSD-Arg >-----#
    USSD_Arg = SEQ(name=u'USSD-Arg', mode=MODE_TYPE)
    _USSD_Arg_ussd_DataCodingScheme = OCT_STR(name=u'ussd-DataCodingScheme', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'USSD-DataCodingScheme')))
    _USSD_Arg_ussd_String = OCT_STR(name=u'ussd-String', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'USSD-String')))
    _USSD_Arg_alertingPattern = OCT_STR(name=u'alertingPattern', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AlertingPattern')), opt=True)
    _USSD_Arg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    USSD_Arg._cont = ASN1Dict([
        (u'ussd-DataCodingScheme', _USSD_Arg_ussd_DataCodingScheme),
        (u'ussd-String', _USSD_Arg_ussd_String),
        (u'alertingPattern', _USSD_Arg_alertingPattern),
        (u'msisdn', _USSD_Arg_msisdn),
        ])
    USSD_Arg._ext = [u'alertingPattern', u'msisdn']
    
    #-----< USSD-Res >-----#
    USSD_Res = SEQ(name=u'USSD-Res', mode=MODE_TYPE)
    _USSD_Res_ussd_DataCodingScheme = OCT_STR(name=u'ussd-DataCodingScheme', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'USSD-DataCodingScheme')))
    _USSD_Res_ussd_String = OCT_STR(name=u'ussd-String', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'USSD-String')))
    USSD_Res._cont = ASN1Dict([
        (u'ussd-DataCodingScheme', _USSD_Res_ussd_DataCodingScheme),
        (u'ussd-String', _USSD_Res_ussd_String),
        ])
    USSD_Res._ext = []
    
    #-----< USSD-DataCodingScheme >-----#
    USSD_DataCodingScheme = OCT_STR(name=u'USSD-DataCodingScheme', mode=MODE_TYPE)
    USSD_DataCodingScheme._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< USSD-String >-----#
    USSD_String = OCT_STR(name=u'USSD-String', mode=MODE_TYPE)
    USSD_String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=160)], ev=None, er=[])
    
    #-----< maxUSSD-StringLength >-----#
    maxUSSD_StringLength = INT(name=u'maxUSSD-StringLength', mode=MODE_VALUE)
    maxUSSD_StringLength._val = 160
    
    #-----< Password >-----#
    Password = STR_NUM(name=u'Password', mode=MODE_TYPE)
    Password._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    Password._const_alpha = ASN1Set(rv=[u'0', u'1', u'2', u'3', u'4', u'5', u'6', u'7', u'8', u'9'], rr=[], ev=None, er=[])
    
    #-----< GuidanceInfo >-----#
    GuidanceInfo = ENUM(name=u'GuidanceInfo', mode=MODE_TYPE)
    GuidanceInfo._cont = ASN1Dict([(u'enterPW', 0), (u'enterNewPW', 1), (u'enterNewPW-Again', 2)])
    GuidanceInfo._ext = None
    
    #-----< SS-List >-----#
    SS_List = SEQ_OF(name=u'SS-List', mode=MODE_TYPE)
    _SS_List__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    SS_List._cont = _SS_List__item_
    SS_List._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    
    #-----< maxNumOfSS >-----#
    maxNumOfSS = INT(name=u'maxNumOfSS', mode=MODE_VALUE)
    maxNumOfSS._val = 30
    
    #-----< SS-InfoList >-----#
    SS_InfoList = SEQ_OF(name=u'SS-InfoList', mode=MODE_TYPE)
    _SS_InfoList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-Info')))
    SS_InfoList._cont = _SS_InfoList__item_
    SS_InfoList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    
    #-----< BasicServiceGroupList >-----#
    BasicServiceGroupList = SEQ_OF(name=u'BasicServiceGroupList', mode=MODE_TYPE)
    _BasicServiceGroupList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'BasicServiceCode')))
    BasicServiceGroupList._cont = _BasicServiceGroupList__item_
    BasicServiceGroupList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=13)], ev=None, er=[])
    
    #-----< maxNumOfBasicServiceGroups >-----#
    maxNumOfBasicServiceGroups = INT(name=u'maxNumOfBasicServiceGroups', mode=MODE_VALUE)
    maxNumOfBasicServiceGroups._val = 13
    
    #-----< SS-InvocationNotificationArg >-----#
    SS_InvocationNotificationArg = SEQ(name=u'SS-InvocationNotificationArg', mode=MODE_TYPE)
    _SS_InvocationNotificationArg_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')))
    _SS_InvocationNotificationArg_msisdn = OCT_STR(name=u'msisdn', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _SS_InvocationNotificationArg_ss_Event = OCT_STR(name=u'ss-Event', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _SS_InvocationNotificationArg_ss_EventSpecification = SEQ_OF(name=u'ss-EventSpecification', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-EventSpecification')), opt=True)
    _SS_InvocationNotificationArg_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SS_InvocationNotificationArg_b_subscriberNumber = OCT_STR(name=u'b-subscriberNumber', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _SS_InvocationNotificationArg_ccbs_RequestState = ENUM(name=u'ccbs-RequestState', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CCBS-RequestState')), opt=True)
    SS_InvocationNotificationArg._cont = ASN1Dict([
        (u'imsi', _SS_InvocationNotificationArg_imsi),
        (u'msisdn', _SS_InvocationNotificationArg_msisdn),
        (u'ss-Event', _SS_InvocationNotificationArg_ss_Event),
        (u'ss-EventSpecification', _SS_InvocationNotificationArg_ss_EventSpecification),
        (u'extensionContainer', _SS_InvocationNotificationArg_extensionContainer),
        (u'b-subscriberNumber', _SS_InvocationNotificationArg_b_subscriberNumber),
        (u'ccbs-RequestState', _SS_InvocationNotificationArg_ccbs_RequestState),
        ])
    SS_InvocationNotificationArg._ext = [u'b-subscriberNumber', u'ccbs-RequestState']
    
    #-----< CCBS-RequestState >-----#
    CCBS_RequestState = ENUM(name=u'CCBS-RequestState', mode=MODE_TYPE)
    CCBS_RequestState._cont = ASN1Dict([(u'request', 0), (u'recall', 1), (u'active', 2), (u'completed', 3), (u'suspended', 4), (u'frozen', 5), (u'deleted', 6)])
    CCBS_RequestState._ext = None
    
    #-----< SS-InvocationNotificationRes >-----#
    SS_InvocationNotificationRes = SEQ(name=u'SS-InvocationNotificationRes', mode=MODE_TYPE)
    _SS_InvocationNotificationRes_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SS_InvocationNotificationRes._cont = ASN1Dict([
        (u'extensionContainer', _SS_InvocationNotificationRes_extensionContainer),
        ])
    SS_InvocationNotificationRes._ext = []
    
    #-----< SS-EventSpecification >-----#
    SS_EventSpecification = SEQ_OF(name=u'SS-EventSpecification', mode=MODE_TYPE)
    _SS_EventSpecification__item_ = OCT_STR(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AddressString')))
    SS_EventSpecification._cont = _SS_EventSpecification__item_
    SS_EventSpecification._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    
    #-----< maxEventSpecification >-----#
    maxEventSpecification = INT(name=u'maxEventSpecification', mode=MODE_VALUE)
    maxEventSpecification._val = 2
    
    #-----< RegisterCC-EntryArg >-----#
    RegisterCC_EntryArg = SEQ(name=u'RegisterCC-EntryArg', mode=MODE_TYPE)
    _RegisterCC_EntryArg_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _RegisterCC_EntryArg_ccbs_Data = SEQ(name=u'ccbs-Data', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CCBS-Data')), opt=True)
    RegisterCC_EntryArg._cont = ASN1Dict([
        (u'ss-Code', _RegisterCC_EntryArg_ss_Code),
        (u'ccbs-Data', _RegisterCC_EntryArg_ccbs_Data),
        ])
    RegisterCC_EntryArg._ext = []
    
    #-----< CCBS-Data >-----#
    CCBS_Data = SEQ(name=u'CCBS-Data', mode=MODE_TYPE)
    _CCBS_Data_ccbs_Feature = SEQ(name=u'ccbs-Feature', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CCBS-Feature')))
    _CCBS_Data_translatedB_Number = OCT_STR(name=u'translatedB-Number', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')))
    _CCBS_Data_serviceIndicator = BIT_STR(name=u'serviceIndicator', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'ServiceIndicator')), opt=True)
    _CCBS_Data_callInfo = SEQ(name=u'callInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ExternalSignalInfo')))
    _CCBS_Data_networkSignalInfo = SEQ(name=u'networkSignalInfo', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ExternalSignalInfo')))
    CCBS_Data._cont = ASN1Dict([
        (u'ccbs-Feature', _CCBS_Data_ccbs_Feature),
        (u'translatedB-Number', _CCBS_Data_translatedB_Number),
        (u'serviceIndicator', _CCBS_Data_serviceIndicator),
        (u'callInfo', _CCBS_Data_callInfo),
        (u'networkSignalInfo', _CCBS_Data_networkSignalInfo),
        ])
    CCBS_Data._ext = []
    
    #-----< ServiceIndicator >-----#
    ServiceIndicator = BIT_STR(name=u'ServiceIndicator', mode=MODE_TYPE)
    ServiceIndicator._cont = ASN1Dict([(u'clir-invoked', 0), (u'camel-invoked', 1)])
    ServiceIndicator._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=32)], ev=None, er=[])
    
    #-----< RegisterCC-EntryRes >-----#
    RegisterCC_EntryRes = SEQ(name=u'RegisterCC-EntryRes', mode=MODE_TYPE)
    _RegisterCC_EntryRes_ccbs_Feature = SEQ(name=u'ccbs-Feature', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CCBS-Feature')), opt=True)
    RegisterCC_EntryRes._cont = ASN1Dict([
        (u'ccbs-Feature', _RegisterCC_EntryRes_ccbs_Feature),
        ])
    RegisterCC_EntryRes._ext = []
    
    #-----< EraseCC-EntryArg >-----#
    EraseCC_EntryArg = SEQ(name=u'EraseCC-EntryArg', mode=MODE_TYPE)
    _EraseCC_EntryArg_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _EraseCC_EntryArg_ccbs_Index = INT(name=u'ccbs-Index', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'CCBS-Index')), opt=True)
    EraseCC_EntryArg._cont = ASN1Dict([
        (u'ss-Code', _EraseCC_EntryArg_ss_Code),
        (u'ccbs-Index', _EraseCC_EntryArg_ccbs_Index),
        ])
    EraseCC_EntryArg._ext = []
    
    #-----< EraseCC-EntryRes >-----#
    EraseCC_EntryRes = SEQ(name=u'EraseCC-EntryRes', mode=MODE_TYPE)
    _EraseCC_EntryRes_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')))
    _EraseCC_EntryRes_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-Status')), opt=True)
    EraseCC_EntryRes._cont = ASN1Dict([
        (u'ss-Code', _EraseCC_EntryRes_ss_Code),
        (u'ss-Status', _EraseCC_EntryRes_ss_Status),
        ])
    EraseCC_EntryRes._ext = []
    
    _all_ = [
        _RegisterSS_Arg_ss_Code,
        _RegisterSS_Arg_basicService,
        _RegisterSS_Arg_forwardedToNumber,
        _RegisterSS_Arg_forwardedToSubaddress,
        _RegisterSS_Arg_noReplyConditionTime,
        _RegisterSS_Arg_defaultPriority,
        _RegisterSS_Arg_nbrUser,
        _RegisterSS_Arg_longFTN_Supported,
        RegisterSS_Arg,
        NoReplyConditionTime,
        _SS_Info_forwardingInfo,
        _SS_Info_callBarringInfo,
        _SS_Info_ss_Data,
        SS_Info,
        _ForwardingInfo_ss_Code,
        _ForwardingInfo_forwardingFeatureList,
        ForwardingInfo,
        _ForwardingFeatureList__item_,
        ForwardingFeatureList,
        _ForwardingFeature_basicService,
        _ForwardingFeature_ss_Status,
        _ForwardingFeature_forwardedToNumber,
        _ForwardingFeature_forwardedToSubaddress,
        _ForwardingFeature_forwardingOptions,
        _ForwardingFeature_noReplyConditionTime,
        _ForwardingFeature_longForwardedToNumber,
        ForwardingFeature,
        SS_Status,
        ForwardingOptions,
        _CallBarringInfo_ss_Code,
        _CallBarringInfo_callBarringFeatureList,
        CallBarringInfo,
        _CallBarringFeatureList__item_,
        CallBarringFeatureList,
        _CallBarringFeature_basicService,
        _CallBarringFeature_ss_Status,
        CallBarringFeature,
        _SS_Data_ss_Code,
        _SS_Data_ss_Status,
        _SS_Data_ss_SubscriptionOption,
        _SS_Data_basicServiceGroupList,
        _SS_Data_defaultPriority,
        _SS_Data_nbrUser,
        SS_Data,
        _SS_SubscriptionOption_cliRestrictionOption,
        _SS_SubscriptionOption_overrideCategory,
        SS_SubscriptionOption,
        CliRestrictionOption,
        OverrideCategory,
        _SS_ForBS_Code_ss_Code,
        _SS_ForBS_Code_basicService,
        _SS_ForBS_Code_longFTN_Supported,
        SS_ForBS_Code,
        _GenericServiceInfo_ss_Status,
        _GenericServiceInfo_cliRestrictionOption,
        _GenericServiceInfo_maximumEntitledPriority,
        _GenericServiceInfo_defaultPriority,
        _GenericServiceInfo_ccbs_FeatureList,
        _GenericServiceInfo_nbrSB,
        _GenericServiceInfo_nbrUser,
        _GenericServiceInfo_nbrSN,
        GenericServiceInfo,
        _CCBS_FeatureList__item_,
        CCBS_FeatureList,
        maxNumOfCCBS_Requests,
        _CCBS_Feature_ccbs_Index,
        _CCBS_Feature_b_subscriberNumber,
        _CCBS_Feature_b_subscriberSubaddress,
        _CCBS_Feature_basicServiceGroup,
        CCBS_Feature,
        CCBS_Index,
        _InterrogateSS_Res_ss_Status,
        _InterrogateSS_Res_basicServiceGroupList,
        _InterrogateSS_Res_forwardingFeatureList,
        _InterrogateSS_Res_genericServiceInfo,
        InterrogateSS_Res,
        _USSD_Arg_ussd_DataCodingScheme,
        _USSD_Arg_ussd_String,
        _USSD_Arg_alertingPattern,
        _USSD_Arg_msisdn,
        USSD_Arg,
        _USSD_Res_ussd_DataCodingScheme,
        _USSD_Res_ussd_String,
        USSD_Res,
        USSD_DataCodingScheme,
        USSD_String,
        maxUSSD_StringLength,
        Password,
        GuidanceInfo,
        _SS_List__item_,
        SS_List,
        maxNumOfSS,
        _SS_InfoList__item_,
        SS_InfoList,
        _BasicServiceGroupList__item_,
        BasicServiceGroupList,
        maxNumOfBasicServiceGroups,
        _SS_InvocationNotificationArg_imsi,
        _SS_InvocationNotificationArg_msisdn,
        _SS_InvocationNotificationArg_ss_Event,
        _SS_InvocationNotificationArg_ss_EventSpecification,
        _SS_InvocationNotificationArg_extensionContainer,
        _SS_InvocationNotificationArg_b_subscriberNumber,
        _SS_InvocationNotificationArg_ccbs_RequestState,
        SS_InvocationNotificationArg,
        CCBS_RequestState,
        _SS_InvocationNotificationRes_extensionContainer,
        SS_InvocationNotificationRes,
        _SS_EventSpecification__item_,
        SS_EventSpecification,
        maxEventSpecification,
        _RegisterCC_EntryArg_ss_Code,
        _RegisterCC_EntryArg_ccbs_Data,
        RegisterCC_EntryArg,
        _CCBS_Data_ccbs_Feature,
        _CCBS_Data_translatedB_Number,
        _CCBS_Data_serviceIndicator,
        _CCBS_Data_callInfo,
        _CCBS_Data_networkSignalInfo,
        CCBS_Data,
        ServiceIndicator,
        _RegisterCC_EntryRes_ccbs_Feature,
        RegisterCC_EntryRes,
        _EraseCC_EntryArg_ss_Code,
        _EraseCC_EntryArg_ccbs_Index,
        EraseCC_EntryArg,
        _EraseCC_EntryRes_ss_Code,
        _EraseCC_EntryRes_ss_Status,
        EraseCC_EntryRes,
    ]

class MAP_ER_DataTypes:

    _name_  = u'MAP-ER-DataTypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 17, 16]
    
    _obj_ = [
        u'RoamingNotAllowedParam',
        u'AdditionalRoamingNotAllowedCause',
        u'RoamingNotAllowedCause',
        u'CallBarredParam',
        u'CallBarringCause',
        u'ExtensibleCallBarredParam',
        u'CUG-RejectParam',
        u'CUG-RejectCause',
        u'SS-IncompatibilityCause',
        u'PW-RegistrationFailureCause',
        u'SM-EnumeratedDeliveryFailureCause',
        u'SM-DeliveryFailureCause',
        u'AbsentSubscriberSM-Param',
        u'AbsentSubscriberDiagnosticSM',
        u'SystemFailureParam',
        u'ExtensibleSystemFailureParam',
        u'FailureCauseParam',
        u'DataMissingParam',
        u'UnexpectedDataParam',
        u'FacilityNotSupParam',
        u'OR-NotAllowedParam',
        u'UnknownSubscriberParam',
        u'UnknownSubscriberDiagnostic',
        u'NumberChangedParam',
        u'UnidentifiedSubParam',
        u'IllegalSubscriberParam',
        u'IllegalEquipmentParam',
        u'BearerServNotProvParam',
        u'TeleservNotProvParam',
        u'TracingBufferFullParam',
        u'NoRoamingNbParam',
        u'AbsentSubscriberParam',
        u'AbsentSubscriberReason',
        u'BusySubscriberParam',
        u'NoSubscriberReplyParam',
        u'ForwardingViolationParam',
        u'ForwardingFailedParam',
        u'ATI-NotAllowedParam',
        u'ATSI-NotAllowedParam',
        u'ATM-NotAllowedParam',
        u'IllegalSS-OperationParam',
        u'SS-NotAvailableParam',
        u'SS-SubscriptionViolationParam',
        u'InformationNotAvailableParam',
        u'SubBusyForMT-SMS-Param',
        u'MessageWaitListFullParam',
        u'ResourceLimitationParam',
        u'NoGroupCallNbParam',
        u'IncompatibleTerminalParam',
        u'ShortTermDenialParam',
        u'LongTermDenialParam',
        u'UnauthorizedRequestingNetwork-Param',
        u'UnauthorizedLCSClient-Param',
        u'UnauthorizedLCSClient-Diagnostic',
        u'PositionMethodFailure-Param',
        u'PositionMethodFailure-Diagnostic',
        u'UnknownOrUnreachableLCSClient-Param',
        u'MM-EventNotSupported-Param',
        u'TargetCellOutsideGCA-Param',
        u'OngoingGroupCallParam',
        ]
    _type_ = [
        u'RoamingNotAllowedParam',
        u'AdditionalRoamingNotAllowedCause',
        u'RoamingNotAllowedCause',
        u'CallBarredParam',
        u'CallBarringCause',
        u'ExtensibleCallBarredParam',
        u'CUG-RejectParam',
        u'CUG-RejectCause',
        u'SS-IncompatibilityCause',
        u'PW-RegistrationFailureCause',
        u'SM-EnumeratedDeliveryFailureCause',
        u'SM-DeliveryFailureCause',
        u'AbsentSubscriberSM-Param',
        u'AbsentSubscriberDiagnosticSM',
        u'SystemFailureParam',
        u'ExtensibleSystemFailureParam',
        u'FailureCauseParam',
        u'DataMissingParam',
        u'UnexpectedDataParam',
        u'FacilityNotSupParam',
        u'OR-NotAllowedParam',
        u'UnknownSubscriberParam',
        u'UnknownSubscriberDiagnostic',
        u'NumberChangedParam',
        u'UnidentifiedSubParam',
        u'IllegalSubscriberParam',
        u'IllegalEquipmentParam',
        u'BearerServNotProvParam',
        u'TeleservNotProvParam',
        u'TracingBufferFullParam',
        u'NoRoamingNbParam',
        u'AbsentSubscriberParam',
        u'AbsentSubscriberReason',
        u'BusySubscriberParam',
        u'NoSubscriberReplyParam',
        u'ForwardingViolationParam',
        u'ForwardingFailedParam',
        u'ATI-NotAllowedParam',
        u'ATSI-NotAllowedParam',
        u'ATM-NotAllowedParam',
        u'IllegalSS-OperationParam',
        u'SS-NotAvailableParam',
        u'SS-SubscriptionViolationParam',
        u'InformationNotAvailableParam',
        u'SubBusyForMT-SMS-Param',
        u'MessageWaitListFullParam',
        u'ResourceLimitationParam',
        u'NoGroupCallNbParam',
        u'IncompatibleTerminalParam',
        u'ShortTermDenialParam',
        u'LongTermDenialParam',
        u'UnauthorizedRequestingNetwork-Param',
        u'UnauthorizedLCSClient-Param',
        u'UnauthorizedLCSClient-Diagnostic',
        u'PositionMethodFailure-Param',
        u'PositionMethodFailure-Diagnostic',
        u'UnknownOrUnreachableLCSClient-Param',
        u'MM-EventNotSupported-Param',
        u'TargetCellOutsideGCA-Param',
        u'OngoingGroupCallParam',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< RoamingNotAllowedParam >-----#
    RoamingNotAllowedParam = SEQ(name=u'RoamingNotAllowedParam', mode=MODE_TYPE)
    _RoamingNotAllowedParam_roamingNotAllowedCause = ENUM(name=u'roamingNotAllowedCause', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ER-DataTypes', 'RoamingNotAllowedCause')))
    _RoamingNotAllowedParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _RoamingNotAllowedParam_additionalRoamingNotAllowedCause = ENUM(name=u'additionalRoamingNotAllowedCause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ER-DataTypes', 'AdditionalRoamingNotAllowedCause')), opt=True)
    RoamingNotAllowedParam._cont = ASN1Dict([
        (u'roamingNotAllowedCause', _RoamingNotAllowedParam_roamingNotAllowedCause),
        (u'extensionContainer', _RoamingNotAllowedParam_extensionContainer),
        (u'additionalRoamingNotAllowedCause', _RoamingNotAllowedParam_additionalRoamingNotAllowedCause),
        ])
    RoamingNotAllowedParam._ext = [u'additionalRoamingNotAllowedCause']
    
    #-----< AdditionalRoamingNotAllowedCause >-----#
    AdditionalRoamingNotAllowedCause = ENUM(name=u'AdditionalRoamingNotAllowedCause', mode=MODE_TYPE)
    AdditionalRoamingNotAllowedCause._cont = ASN1Dict([(u'supportedRAT-TypesNotAllowed', 0)])
    AdditionalRoamingNotAllowedCause._ext = []
    
    #-----< RoamingNotAllowedCause >-----#
    RoamingNotAllowedCause = ENUM(name=u'RoamingNotAllowedCause', mode=MODE_TYPE)
    RoamingNotAllowedCause._cont = ASN1Dict([(u'plmnRoamingNotAllowed', 0), (u'operatorDeterminedBarring', 3)])
    RoamingNotAllowedCause._ext = None
    
    #-----< CallBarredParam >-----#
    CallBarredParam = CHOICE(name=u'CallBarredParam', mode=MODE_TYPE)
    _CallBarredParam_callBarringCause = ENUM(name=u'callBarringCause', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ER-DataTypes', 'CallBarringCause')))
    _CallBarredParam_extensibleCallBarredParam = SEQ(name=u'extensibleCallBarredParam', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ER-DataTypes', 'ExtensibleCallBarredParam')))
    CallBarredParam._cont = ASN1Dict([
        (u'callBarringCause', _CallBarredParam_callBarringCause),
        (u'extensibleCallBarredParam', _CallBarredParam_extensibleCallBarredParam),
        ])
    CallBarredParam._ext = None
    
    #-----< CallBarringCause >-----#
    CallBarringCause = ENUM(name=u'CallBarringCause', mode=MODE_TYPE)
    CallBarringCause._cont = ASN1Dict([(u'barringServiceActive', 0), (u'operatorBarring', 1)])
    CallBarringCause._ext = None
    
    #-----< ExtensibleCallBarredParam >-----#
    ExtensibleCallBarredParam = SEQ(name=u'ExtensibleCallBarredParam', mode=MODE_TYPE)
    _ExtensibleCallBarredParam_callBarringCause = ENUM(name=u'callBarringCause', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ER-DataTypes', 'CallBarringCause')), opt=True)
    _ExtensibleCallBarredParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ExtensibleCallBarredParam_unauthorisedMessageOriginator = NULL(name=u'unauthorisedMessageOriginator', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ExtensibleCallBarredParam_anonymousCallRejection = NULL(name=u'anonymousCallRejection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    ExtensibleCallBarredParam._cont = ASN1Dict([
        (u'callBarringCause', _ExtensibleCallBarredParam_callBarringCause),
        (u'extensionContainer', _ExtensibleCallBarredParam_extensionContainer),
        (u'unauthorisedMessageOriginator', _ExtensibleCallBarredParam_unauthorisedMessageOriginator),
        (u'anonymousCallRejection', _ExtensibleCallBarredParam_anonymousCallRejection),
        ])
    ExtensibleCallBarredParam._ext = [u'unauthorisedMessageOriginator', u'anonymousCallRejection']
    
    #-----< CUG-RejectParam >-----#
    CUG_RejectParam = SEQ(name=u'CUG-RejectParam', mode=MODE_TYPE)
    _CUG_RejectParam_cug_RejectCause = ENUM(name=u'cug-RejectCause', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ER-DataTypes', 'CUG-RejectCause')), opt=True)
    _CUG_RejectParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    CUG_RejectParam._cont = ASN1Dict([
        (u'cug-RejectCause', _CUG_RejectParam_cug_RejectCause),
        (u'extensionContainer', _CUG_RejectParam_extensionContainer),
        ])
    CUG_RejectParam._ext = []
    
    #-----< CUG-RejectCause >-----#
    CUG_RejectCause = ENUM(name=u'CUG-RejectCause', mode=MODE_TYPE)
    CUG_RejectCause._cont = ASN1Dict([(u'incomingCallsBarredWithinCUG', 0), (u'subscriberNotMemberOfCUG', 1), (u'requestedBasicServiceViolatesCUG-Constraints', 5), (u'calledPartySS-InteractionViolation', 7)])
    CUG_RejectCause._ext = None
    
    #-----< SS-IncompatibilityCause >-----#
    SS_IncompatibilityCause = SEQ(name=u'SS-IncompatibilityCause', mode=MODE_TYPE)
    _SS_IncompatibilityCause_ss_Code = OCT_STR(name=u'ss-Code', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-Code', 'SS-Code')), opt=True)
    _SS_IncompatibilityCause_basicService = CHOICE(name=u'basicService', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'BasicServiceCode')), opt=True)
    _SS_IncompatibilityCause_ss_Status = OCT_STR(name=u'ss-Status', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-SS-DataTypes', 'SS-Status')), opt=True)
    SS_IncompatibilityCause._cont = ASN1Dict([
        (u'ss-Code', _SS_IncompatibilityCause_ss_Code),
        (u'basicService', _SS_IncompatibilityCause_basicService),
        (u'ss-Status', _SS_IncompatibilityCause_ss_Status),
        ])
    SS_IncompatibilityCause._ext = []
    
    #-----< PW-RegistrationFailureCause >-----#
    PW_RegistrationFailureCause = ENUM(name=u'PW-RegistrationFailureCause', mode=MODE_TYPE)
    PW_RegistrationFailureCause._cont = ASN1Dict([(u'undetermined', 0), (u'invalidFormat', 1), (u'newPasswordsMismatch', 2)])
    PW_RegistrationFailureCause._ext = None
    
    #-----< SM-EnumeratedDeliveryFailureCause >-----#
    SM_EnumeratedDeliveryFailureCause = ENUM(name=u'SM-EnumeratedDeliveryFailureCause', mode=MODE_TYPE)
    SM_EnumeratedDeliveryFailureCause._cont = ASN1Dict([(u'memoryCapacityExceeded', 0), (u'equipmentProtocolError', 1), (u'equipmentNotSM-Equipped', 2), (u'unknownServiceCentre', 3), (u'sc-Congestion', 4), (u'invalidSME-Address', 5), (u'subscriberNotSC-Subscriber', 6)])
    SM_EnumeratedDeliveryFailureCause._ext = None
    
    #-----< SM-DeliveryFailureCause >-----#
    SM_DeliveryFailureCause = SEQ(name=u'SM-DeliveryFailureCause', mode=MODE_TYPE)
    _SM_DeliveryFailureCause_sm_EnumeratedDeliveryFailureCause = ENUM(name=u'sm-EnumeratedDeliveryFailureCause', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ER-DataTypes', 'SM-EnumeratedDeliveryFailureCause')))
    _SM_DeliveryFailureCause_diagnosticInfo = OCT_STR(name=u'diagnosticInfo', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'SignalInfo')), opt=True)
    _SM_DeliveryFailureCause_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SM_DeliveryFailureCause._cont = ASN1Dict([
        (u'sm-EnumeratedDeliveryFailureCause', _SM_DeliveryFailureCause_sm_EnumeratedDeliveryFailureCause),
        (u'diagnosticInfo', _SM_DeliveryFailureCause_diagnosticInfo),
        (u'extensionContainer', _SM_DeliveryFailureCause_extensionContainer),
        ])
    SM_DeliveryFailureCause._ext = []
    
    #-----< AbsentSubscriberSM-Param >-----#
    AbsentSubscriberSM_Param = SEQ(name=u'AbsentSubscriberSM-Param', mode=MODE_TYPE)
    _AbsentSubscriberSM_Param_absentSubscriberDiagnosticSM = INT(name=u'absentSubscriberDiagnosticSM', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ER-DataTypes', 'AbsentSubscriberDiagnosticSM')), opt=True)
    _AbsentSubscriberSM_Param_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _AbsentSubscriberSM_Param_additionalAbsentSubscriberDiagnosticSM = INT(name=u'additionalAbsentSubscriberDiagnosticSM', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ER-DataTypes', 'AbsentSubscriberDiagnosticSM')), opt=True)
    _AbsentSubscriberSM_Param_imsi = OCT_STR(name=u'imsi', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    _AbsentSubscriberSM_Param_requestedRetransmissionTime = OCT_STR(name=u'requestedRetransmissionTime', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'Time')), opt=True)
    _AbsentSubscriberSM_Param_userIdentifierAlert = OCT_STR(name=u'userIdentifierAlert', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'IMSI')), opt=True)
    AbsentSubscriberSM_Param._cont = ASN1Dict([
        (u'absentSubscriberDiagnosticSM', _AbsentSubscriberSM_Param_absentSubscriberDiagnosticSM),
        (u'extensionContainer', _AbsentSubscriberSM_Param_extensionContainer),
        (u'additionalAbsentSubscriberDiagnosticSM', _AbsentSubscriberSM_Param_additionalAbsentSubscriberDiagnosticSM),
        (u'imsi', _AbsentSubscriberSM_Param_imsi),
        (u'requestedRetransmissionTime', _AbsentSubscriberSM_Param_requestedRetransmissionTime),
        (u'userIdentifierAlert', _AbsentSubscriberSM_Param_userIdentifierAlert),
        ])
    AbsentSubscriberSM_Param._ext = [u'additionalAbsentSubscriberDiagnosticSM', u'imsi', u'requestedRetransmissionTime', u'userIdentifierAlert']
    
    #-----< AbsentSubscriberDiagnosticSM >-----#
    AbsentSubscriberDiagnosticSM = INT(name=u'AbsentSubscriberDiagnosticSM', mode=MODE_TYPE)
    AbsentSubscriberDiagnosticSM._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    
    #-----< SystemFailureParam >-----#
    SystemFailureParam = CHOICE(name=u'SystemFailureParam', mode=MODE_TYPE)
    _SystemFailureParam_networkResource = ENUM(name=u'networkResource', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'NetworkResource')))
    _SystemFailureParam_extensibleSystemFailureParam = SEQ(name=u'extensibleSystemFailureParam', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ER-DataTypes', 'ExtensibleSystemFailureParam')))
    SystemFailureParam._cont = ASN1Dict([
        (u'networkResource', _SystemFailureParam_networkResource),
        (u'extensibleSystemFailureParam', _SystemFailureParam_extensibleSystemFailureParam),
        ])
    SystemFailureParam._ext = None
    
    #-----< ExtensibleSystemFailureParam >-----#
    ExtensibleSystemFailureParam = SEQ(name=u'ExtensibleSystemFailureParam', mode=MODE_TYPE)
    _ExtensibleSystemFailureParam_networkResource = ENUM(name=u'networkResource', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'NetworkResource')), opt=True)
    _ExtensibleSystemFailureParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _ExtensibleSystemFailureParam_additionalNetworkResource = ENUM(name=u'additionalNetworkResource', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'AdditionalNetworkResource')), opt=True)
    _ExtensibleSystemFailureParam_failureCauseParam = ENUM(name=u'failureCauseParam', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ER-DataTypes', 'FailureCauseParam')), opt=True)
    ExtensibleSystemFailureParam._cont = ASN1Dict([
        (u'networkResource', _ExtensibleSystemFailureParam_networkResource),
        (u'extensionContainer', _ExtensibleSystemFailureParam_extensionContainer),
        (u'additionalNetworkResource', _ExtensibleSystemFailureParam_additionalNetworkResource),
        (u'failureCauseParam', _ExtensibleSystemFailureParam_failureCauseParam),
        ])
    ExtensibleSystemFailureParam._ext = [u'additionalNetworkResource', u'failureCauseParam']
    
    #-----< FailureCauseParam >-----#
    FailureCauseParam = ENUM(name=u'FailureCauseParam', mode=MODE_TYPE)
    FailureCauseParam._cont = ASN1Dict([(u'limitReachedOnNumberOfConcurrentLocationRequests', 0)])
    FailureCauseParam._ext = []
    
    #-----< DataMissingParam >-----#
    DataMissingParam = SEQ(name=u'DataMissingParam', mode=MODE_TYPE)
    _DataMissingParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    DataMissingParam._cont = ASN1Dict([
        (u'extensionContainer', _DataMissingParam_extensionContainer),
        ])
    DataMissingParam._ext = []
    
    #-----< UnexpectedDataParam >-----#
    UnexpectedDataParam = SEQ(name=u'UnexpectedDataParam', mode=MODE_TYPE)
    _UnexpectedDataParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _UnexpectedDataParam_unexpectedSubscriber = NULL(name=u'unexpectedSubscriber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    UnexpectedDataParam._cont = ASN1Dict([
        (u'extensionContainer', _UnexpectedDataParam_extensionContainer),
        (u'unexpectedSubscriber', _UnexpectedDataParam_unexpectedSubscriber),
        ])
    UnexpectedDataParam._ext = [u'unexpectedSubscriber']
    
    #-----< FacilityNotSupParam >-----#
    FacilityNotSupParam = SEQ(name=u'FacilityNotSupParam', mode=MODE_TYPE)
    _FacilityNotSupParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _FacilityNotSupParam_shapeOfLocationEstimateNotSupported = NULL(name=u'shapeOfLocationEstimateNotSupported', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _FacilityNotSupParam_neededLcsCapabilityNotSupportedInServingNode = NULL(name=u'neededLcsCapabilityNotSupportedInServingNode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    FacilityNotSupParam._cont = ASN1Dict([
        (u'extensionContainer', _FacilityNotSupParam_extensionContainer),
        (u'shapeOfLocationEstimateNotSupported', _FacilityNotSupParam_shapeOfLocationEstimateNotSupported),
        (u'neededLcsCapabilityNotSupportedInServingNode', _FacilityNotSupParam_neededLcsCapabilityNotSupportedInServingNode),
        ])
    FacilityNotSupParam._ext = [u'shapeOfLocationEstimateNotSupported', u'neededLcsCapabilityNotSupportedInServingNode']
    
    #-----< OR-NotAllowedParam >-----#
    OR_NotAllowedParam = SEQ(name=u'OR-NotAllowedParam', mode=MODE_TYPE)
    _OR_NotAllowedParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    OR_NotAllowedParam._cont = ASN1Dict([
        (u'extensionContainer', _OR_NotAllowedParam_extensionContainer),
        ])
    OR_NotAllowedParam._ext = []
    
    #-----< UnknownSubscriberParam >-----#
    UnknownSubscriberParam = SEQ(name=u'UnknownSubscriberParam', mode=MODE_TYPE)
    _UnknownSubscriberParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _UnknownSubscriberParam_unknownSubscriberDiagnostic = ENUM(name=u'unknownSubscriberDiagnostic', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ER-DataTypes', 'UnknownSubscriberDiagnostic')), opt=True)
    UnknownSubscriberParam._cont = ASN1Dict([
        (u'extensionContainer', _UnknownSubscriberParam_extensionContainer),
        (u'unknownSubscriberDiagnostic', _UnknownSubscriberParam_unknownSubscriberDiagnostic),
        ])
    UnknownSubscriberParam._ext = [u'unknownSubscriberDiagnostic']
    
    #-----< UnknownSubscriberDiagnostic >-----#
    UnknownSubscriberDiagnostic = ENUM(name=u'UnknownSubscriberDiagnostic', mode=MODE_TYPE)
    UnknownSubscriberDiagnostic._cont = ASN1Dict([(u'imsiUnknown', 0), (u'gprs-eps-SubscriptionUnknown', 1), (u'npdbMismatch', 2)])
    UnknownSubscriberDiagnostic._ext = [u'npdbMismatch']
    
    #-----< NumberChangedParam >-----#
    NumberChangedParam = SEQ(name=u'NumberChangedParam', mode=MODE_TYPE)
    _NumberChangedParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    NumberChangedParam._cont = ASN1Dict([
        (u'extensionContainer', _NumberChangedParam_extensionContainer),
        ])
    NumberChangedParam._ext = []
    
    #-----< UnidentifiedSubParam >-----#
    UnidentifiedSubParam = SEQ(name=u'UnidentifiedSubParam', mode=MODE_TYPE)
    _UnidentifiedSubParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    UnidentifiedSubParam._cont = ASN1Dict([
        (u'extensionContainer', _UnidentifiedSubParam_extensionContainer),
        ])
    UnidentifiedSubParam._ext = []
    
    #-----< IllegalSubscriberParam >-----#
    IllegalSubscriberParam = SEQ(name=u'IllegalSubscriberParam', mode=MODE_TYPE)
    _IllegalSubscriberParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    IllegalSubscriberParam._cont = ASN1Dict([
        (u'extensionContainer', _IllegalSubscriberParam_extensionContainer),
        ])
    IllegalSubscriberParam._ext = []
    
    #-----< IllegalEquipmentParam >-----#
    IllegalEquipmentParam = SEQ(name=u'IllegalEquipmentParam', mode=MODE_TYPE)
    _IllegalEquipmentParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    IllegalEquipmentParam._cont = ASN1Dict([
        (u'extensionContainer', _IllegalEquipmentParam_extensionContainer),
        ])
    IllegalEquipmentParam._ext = []
    
    #-----< BearerServNotProvParam >-----#
    BearerServNotProvParam = SEQ(name=u'BearerServNotProvParam', mode=MODE_TYPE)
    _BearerServNotProvParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    BearerServNotProvParam._cont = ASN1Dict([
        (u'extensionContainer', _BearerServNotProvParam_extensionContainer),
        ])
    BearerServNotProvParam._ext = []
    
    #-----< TeleservNotProvParam >-----#
    TeleservNotProvParam = SEQ(name=u'TeleservNotProvParam', mode=MODE_TYPE)
    _TeleservNotProvParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    TeleservNotProvParam._cont = ASN1Dict([
        (u'extensionContainer', _TeleservNotProvParam_extensionContainer),
        ])
    TeleservNotProvParam._ext = []
    
    #-----< TracingBufferFullParam >-----#
    TracingBufferFullParam = SEQ(name=u'TracingBufferFullParam', mode=MODE_TYPE)
    _TracingBufferFullParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    TracingBufferFullParam._cont = ASN1Dict([
        (u'extensionContainer', _TracingBufferFullParam_extensionContainer),
        ])
    TracingBufferFullParam._ext = []
    
    #-----< NoRoamingNbParam >-----#
    NoRoamingNbParam = SEQ(name=u'NoRoamingNbParam', mode=MODE_TYPE)
    _NoRoamingNbParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    NoRoamingNbParam._cont = ASN1Dict([
        (u'extensionContainer', _NoRoamingNbParam_extensionContainer),
        ])
    NoRoamingNbParam._ext = []
    
    #-----< AbsentSubscriberParam >-----#
    AbsentSubscriberParam = SEQ(name=u'AbsentSubscriberParam', mode=MODE_TYPE)
    _AbsentSubscriberParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _AbsentSubscriberParam_absentSubscriberReason = ENUM(name=u'absentSubscriberReason', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ER-DataTypes', 'AbsentSubscriberReason')), opt=True)
    AbsentSubscriberParam._cont = ASN1Dict([
        (u'extensionContainer', _AbsentSubscriberParam_extensionContainer),
        (u'absentSubscriberReason', _AbsentSubscriberParam_absentSubscriberReason),
        ])
    AbsentSubscriberParam._ext = [u'absentSubscriberReason']
    
    #-----< AbsentSubscriberReason >-----#
    AbsentSubscriberReason = ENUM(name=u'AbsentSubscriberReason', mode=MODE_TYPE)
    AbsentSubscriberReason._cont = ASN1Dict([(u'imsiDetach', 0), (u'restrictedArea', 1), (u'noPageResponse', 2), (u'purgedMS', 3), (u'mtRoamingRetry', 4), (u'busySubscriber', 5)])
    AbsentSubscriberReason._ext = [u'purgedMS', u'mtRoamingRetry', u'busySubscriber']
    
    #-----< BusySubscriberParam >-----#
    BusySubscriberParam = SEQ(name=u'BusySubscriberParam', mode=MODE_TYPE)
    _BusySubscriberParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _BusySubscriberParam_ccbs_Possible = NULL(name=u'ccbs-Possible', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _BusySubscriberParam_ccbs_Busy = NULL(name=u'ccbs-Busy', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    BusySubscriberParam._cont = ASN1Dict([
        (u'extensionContainer', _BusySubscriberParam_extensionContainer),
        (u'ccbs-Possible', _BusySubscriberParam_ccbs_Possible),
        (u'ccbs-Busy', _BusySubscriberParam_ccbs_Busy),
        ])
    BusySubscriberParam._ext = [u'ccbs-Possible', u'ccbs-Busy']
    
    #-----< NoSubscriberReplyParam >-----#
    NoSubscriberReplyParam = SEQ(name=u'NoSubscriberReplyParam', mode=MODE_TYPE)
    _NoSubscriberReplyParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    NoSubscriberReplyParam._cont = ASN1Dict([
        (u'extensionContainer', _NoSubscriberReplyParam_extensionContainer),
        ])
    NoSubscriberReplyParam._ext = []
    
    #-----< ForwardingViolationParam >-----#
    ForwardingViolationParam = SEQ(name=u'ForwardingViolationParam', mode=MODE_TYPE)
    _ForwardingViolationParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ForwardingViolationParam._cont = ASN1Dict([
        (u'extensionContainer', _ForwardingViolationParam_extensionContainer),
        ])
    ForwardingViolationParam._ext = []
    
    #-----< ForwardingFailedParam >-----#
    ForwardingFailedParam = SEQ(name=u'ForwardingFailedParam', mode=MODE_TYPE)
    _ForwardingFailedParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ForwardingFailedParam._cont = ASN1Dict([
        (u'extensionContainer', _ForwardingFailedParam_extensionContainer),
        ])
    ForwardingFailedParam._ext = []
    
    #-----< ATI-NotAllowedParam >-----#
    ATI_NotAllowedParam = SEQ(name=u'ATI-NotAllowedParam', mode=MODE_TYPE)
    _ATI_NotAllowedParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ATI_NotAllowedParam._cont = ASN1Dict([
        (u'extensionContainer', _ATI_NotAllowedParam_extensionContainer),
        ])
    ATI_NotAllowedParam._ext = []
    
    #-----< ATSI-NotAllowedParam >-----#
    ATSI_NotAllowedParam = SEQ(name=u'ATSI-NotAllowedParam', mode=MODE_TYPE)
    _ATSI_NotAllowedParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ATSI_NotAllowedParam._cont = ASN1Dict([
        (u'extensionContainer', _ATSI_NotAllowedParam_extensionContainer),
        ])
    ATSI_NotAllowedParam._ext = []
    
    #-----< ATM-NotAllowedParam >-----#
    ATM_NotAllowedParam = SEQ(name=u'ATM-NotAllowedParam', mode=MODE_TYPE)
    _ATM_NotAllowedParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ATM_NotAllowedParam._cont = ASN1Dict([
        (u'extensionContainer', _ATM_NotAllowedParam_extensionContainer),
        ])
    ATM_NotAllowedParam._ext = []
    
    #-----< IllegalSS-OperationParam >-----#
    IllegalSS_OperationParam = SEQ(name=u'IllegalSS-OperationParam', mode=MODE_TYPE)
    _IllegalSS_OperationParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    IllegalSS_OperationParam._cont = ASN1Dict([
        (u'extensionContainer', _IllegalSS_OperationParam_extensionContainer),
        ])
    IllegalSS_OperationParam._ext = []
    
    #-----< SS-NotAvailableParam >-----#
    SS_NotAvailableParam = SEQ(name=u'SS-NotAvailableParam', mode=MODE_TYPE)
    _SS_NotAvailableParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SS_NotAvailableParam._cont = ASN1Dict([
        (u'extensionContainer', _SS_NotAvailableParam_extensionContainer),
        ])
    SS_NotAvailableParam._ext = []
    
    #-----< SS-SubscriptionViolationParam >-----#
    SS_SubscriptionViolationParam = SEQ(name=u'SS-SubscriptionViolationParam', mode=MODE_TYPE)
    _SS_SubscriptionViolationParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    SS_SubscriptionViolationParam._cont = ASN1Dict([
        (u'extensionContainer', _SS_SubscriptionViolationParam_extensionContainer),
        ])
    SS_SubscriptionViolationParam._ext = []
    
    #-----< InformationNotAvailableParam >-----#
    InformationNotAvailableParam = SEQ(name=u'InformationNotAvailableParam', mode=MODE_TYPE)
    _InformationNotAvailableParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    InformationNotAvailableParam._cont = ASN1Dict([
        (u'extensionContainer', _InformationNotAvailableParam_extensionContainer),
        ])
    InformationNotAvailableParam._ext = []
    
    #-----< SubBusyForMT-SMS-Param >-----#
    SubBusyForMT_SMS_Param = SEQ(name=u'SubBusyForMT-SMS-Param', mode=MODE_TYPE)
    _SubBusyForMT_SMS_Param_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _SubBusyForMT_SMS_Param_gprsConnectionSuspended = NULL(name=u'gprsConnectionSuspended', mode=MODE_TYPE, opt=True)
    SubBusyForMT_SMS_Param._cont = ASN1Dict([
        (u'extensionContainer', _SubBusyForMT_SMS_Param_extensionContainer),
        (u'gprsConnectionSuspended', _SubBusyForMT_SMS_Param_gprsConnectionSuspended),
        ])
    SubBusyForMT_SMS_Param._ext = [u'gprsConnectionSuspended']
    
    #-----< MessageWaitListFullParam >-----#
    MessageWaitListFullParam = SEQ(name=u'MessageWaitListFullParam', mode=MODE_TYPE)
    _MessageWaitListFullParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    MessageWaitListFullParam._cont = ASN1Dict([
        (u'extensionContainer', _MessageWaitListFullParam_extensionContainer),
        ])
    MessageWaitListFullParam._ext = []
    
    #-----< ResourceLimitationParam >-----#
    ResourceLimitationParam = SEQ(name=u'ResourceLimitationParam', mode=MODE_TYPE)
    _ResourceLimitationParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    ResourceLimitationParam._cont = ASN1Dict([
        (u'extensionContainer', _ResourceLimitationParam_extensionContainer),
        ])
    ResourceLimitationParam._ext = []
    
    #-----< NoGroupCallNbParam >-----#
    NoGroupCallNbParam = SEQ(name=u'NoGroupCallNbParam', mode=MODE_TYPE)
    _NoGroupCallNbParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    NoGroupCallNbParam._cont = ASN1Dict([
        (u'extensionContainer', _NoGroupCallNbParam_extensionContainer),
        ])
    NoGroupCallNbParam._ext = []
    
    #-----< IncompatibleTerminalParam >-----#
    IncompatibleTerminalParam = SEQ(name=u'IncompatibleTerminalParam', mode=MODE_TYPE)
    _IncompatibleTerminalParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    IncompatibleTerminalParam._cont = ASN1Dict([
        (u'extensionContainer', _IncompatibleTerminalParam_extensionContainer),
        ])
    IncompatibleTerminalParam._ext = []
    
    #-----< ShortTermDenialParam >-----#
    ShortTermDenialParam = SEQ(name=u'ShortTermDenialParam', mode=MODE_TYPE)
    ShortTermDenialParam._cont = ASN1Dict([
        ])
    ShortTermDenialParam._ext = []
    
    #-----< LongTermDenialParam >-----#
    LongTermDenialParam = SEQ(name=u'LongTermDenialParam', mode=MODE_TYPE)
    LongTermDenialParam._cont = ASN1Dict([
        ])
    LongTermDenialParam._ext = []
    
    #-----< UnauthorizedRequestingNetwork-Param >-----#
    UnauthorizedRequestingNetwork_Param = SEQ(name=u'UnauthorizedRequestingNetwork-Param', mode=MODE_TYPE)
    _UnauthorizedRequestingNetwork_Param_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    UnauthorizedRequestingNetwork_Param._cont = ASN1Dict([
        (u'extensionContainer', _UnauthorizedRequestingNetwork_Param_extensionContainer),
        ])
    UnauthorizedRequestingNetwork_Param._ext = []
    
    #-----< UnauthorizedLCSClient-Param >-----#
    UnauthorizedLCSClient_Param = SEQ(name=u'UnauthorizedLCSClient-Param', mode=MODE_TYPE)
    _UnauthorizedLCSClient_Param_unauthorizedLCSClient_Diagnostic = ENUM(name=u'unauthorizedLCSClient-Diagnostic', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ER-DataTypes', 'UnauthorizedLCSClient-Diagnostic')), opt=True)
    _UnauthorizedLCSClient_Param_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    UnauthorizedLCSClient_Param._cont = ASN1Dict([
        (u'unauthorizedLCSClient-Diagnostic', _UnauthorizedLCSClient_Param_unauthorizedLCSClient_Diagnostic),
        (u'extensionContainer', _UnauthorizedLCSClient_Param_extensionContainer),
        ])
    UnauthorizedLCSClient_Param._ext = []
    
    #-----< UnauthorizedLCSClient-Diagnostic >-----#
    UnauthorizedLCSClient_Diagnostic = ENUM(name=u'UnauthorizedLCSClient-Diagnostic', mode=MODE_TYPE)
    UnauthorizedLCSClient_Diagnostic._cont = ASN1Dict([(u'noAdditionalInformation', 0), (u'clientNotInMSPrivacyExceptionList', 1), (u'callToClientNotSetup', 2), (u'privacyOverrideNotApplicable', 3), (u'disallowedByLocalRegulatoryRequirements', 4), (u'unauthorizedPrivacyClass', 5), (u'unauthorizedCallSessionUnrelatedExternalClient', 6), (u'unauthorizedCallSessionRelatedExternalClient', 7)])
    UnauthorizedLCSClient_Diagnostic._ext = [u'unauthorizedPrivacyClass', u'unauthorizedCallSessionUnrelatedExternalClient', u'unauthorizedCallSessionRelatedExternalClient']
    
    #-----< PositionMethodFailure-Param >-----#
    PositionMethodFailure_Param = SEQ(name=u'PositionMethodFailure-Param', mode=MODE_TYPE)
    _PositionMethodFailure_Param_positionMethodFailure_Diagnostic = ENUM(name=u'positionMethodFailure-Diagnostic', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ER-DataTypes', 'PositionMethodFailure-Diagnostic')), opt=True)
    _PositionMethodFailure_Param_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    PositionMethodFailure_Param._cont = ASN1Dict([
        (u'positionMethodFailure-Diagnostic', _PositionMethodFailure_Param_positionMethodFailure_Diagnostic),
        (u'extensionContainer', _PositionMethodFailure_Param_extensionContainer),
        ])
    PositionMethodFailure_Param._ext = []
    
    #-----< PositionMethodFailure-Diagnostic >-----#
    PositionMethodFailure_Diagnostic = ENUM(name=u'PositionMethodFailure-Diagnostic', mode=MODE_TYPE)
    PositionMethodFailure_Diagnostic._cont = ASN1Dict([(u'congestion', 0), (u'insufficientResources', 1), (u'insufficientMeasurementData', 2), (u'inconsistentMeasurementData', 3), (u'locationProcedureNotCompleted', 4), (u'locationProcedureNotSupportedByTargetMS', 5), (u'qoSNotAttainable', 6), (u'positionMethodNotAvailableInNetwork', 7), (u'positionMethodNotAvailableInLocationArea', 8)])
    PositionMethodFailure_Diagnostic._ext = []
    
    #-----< UnknownOrUnreachableLCSClient-Param >-----#
    UnknownOrUnreachableLCSClient_Param = SEQ(name=u'UnknownOrUnreachableLCSClient-Param', mode=MODE_TYPE)
    _UnknownOrUnreachableLCSClient_Param_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    UnknownOrUnreachableLCSClient_Param._cont = ASN1Dict([
        (u'extensionContainer', _UnknownOrUnreachableLCSClient_Param_extensionContainer),
        ])
    UnknownOrUnreachableLCSClient_Param._ext = []
    
    #-----< MM-EventNotSupported-Param >-----#
    MM_EventNotSupported_Param = SEQ(name=u'MM-EventNotSupported-Param', mode=MODE_TYPE)
    _MM_EventNotSupported_Param_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    MM_EventNotSupported_Param._cont = ASN1Dict([
        (u'extensionContainer', _MM_EventNotSupported_Param_extensionContainer),
        ])
    MM_EventNotSupported_Param._ext = []
    
    #-----< TargetCellOutsideGCA-Param >-----#
    TargetCellOutsideGCA_Param = SEQ(name=u'TargetCellOutsideGCA-Param', mode=MODE_TYPE)
    _TargetCellOutsideGCA_Param_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    TargetCellOutsideGCA_Param._cont = ASN1Dict([
        (u'extensionContainer', _TargetCellOutsideGCA_Param_extensionContainer),
        ])
    TargetCellOutsideGCA_Param._ext = []
    
    #-----< OngoingGroupCallParam >-----#
    OngoingGroupCallParam = SEQ(name=u'OngoingGroupCallParam', mode=MODE_TYPE)
    _OngoingGroupCallParam_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    OngoingGroupCallParam._cont = ASN1Dict([
        (u'extensionContainer', _OngoingGroupCallParam_extensionContainer),
        ])
    OngoingGroupCallParam._ext = []
    
    _all_ = [
        _RoamingNotAllowedParam_roamingNotAllowedCause,
        _RoamingNotAllowedParam_extensionContainer,
        _RoamingNotAllowedParam_additionalRoamingNotAllowedCause,
        RoamingNotAllowedParam,
        AdditionalRoamingNotAllowedCause,
        RoamingNotAllowedCause,
        _CallBarredParam_callBarringCause,
        _CallBarredParam_extensibleCallBarredParam,
        CallBarredParam,
        CallBarringCause,
        _ExtensibleCallBarredParam_callBarringCause,
        _ExtensibleCallBarredParam_extensionContainer,
        _ExtensibleCallBarredParam_unauthorisedMessageOriginator,
        _ExtensibleCallBarredParam_anonymousCallRejection,
        ExtensibleCallBarredParam,
        _CUG_RejectParam_cug_RejectCause,
        _CUG_RejectParam_extensionContainer,
        CUG_RejectParam,
        CUG_RejectCause,
        _SS_IncompatibilityCause_ss_Code,
        _SS_IncompatibilityCause_basicService,
        _SS_IncompatibilityCause_ss_Status,
        SS_IncompatibilityCause,
        PW_RegistrationFailureCause,
        SM_EnumeratedDeliveryFailureCause,
        _SM_DeliveryFailureCause_sm_EnumeratedDeliveryFailureCause,
        _SM_DeliveryFailureCause_diagnosticInfo,
        _SM_DeliveryFailureCause_extensionContainer,
        SM_DeliveryFailureCause,
        _AbsentSubscriberSM_Param_absentSubscriberDiagnosticSM,
        _AbsentSubscriberSM_Param_extensionContainer,
        _AbsentSubscriberSM_Param_additionalAbsentSubscriberDiagnosticSM,
        _AbsentSubscriberSM_Param_imsi,
        _AbsentSubscriberSM_Param_requestedRetransmissionTime,
        _AbsentSubscriberSM_Param_userIdentifierAlert,
        AbsentSubscriberSM_Param,
        AbsentSubscriberDiagnosticSM,
        _SystemFailureParam_networkResource,
        _SystemFailureParam_extensibleSystemFailureParam,
        SystemFailureParam,
        _ExtensibleSystemFailureParam_networkResource,
        _ExtensibleSystemFailureParam_extensionContainer,
        _ExtensibleSystemFailureParam_additionalNetworkResource,
        _ExtensibleSystemFailureParam_failureCauseParam,
        ExtensibleSystemFailureParam,
        FailureCauseParam,
        _DataMissingParam_extensionContainer,
        DataMissingParam,
        _UnexpectedDataParam_extensionContainer,
        _UnexpectedDataParam_unexpectedSubscriber,
        UnexpectedDataParam,
        _FacilityNotSupParam_extensionContainer,
        _FacilityNotSupParam_shapeOfLocationEstimateNotSupported,
        _FacilityNotSupParam_neededLcsCapabilityNotSupportedInServingNode,
        FacilityNotSupParam,
        _OR_NotAllowedParam_extensionContainer,
        OR_NotAllowedParam,
        _UnknownSubscriberParam_extensionContainer,
        _UnknownSubscriberParam_unknownSubscriberDiagnostic,
        UnknownSubscriberParam,
        UnknownSubscriberDiagnostic,
        _NumberChangedParam_extensionContainer,
        NumberChangedParam,
        _UnidentifiedSubParam_extensionContainer,
        UnidentifiedSubParam,
        _IllegalSubscriberParam_extensionContainer,
        IllegalSubscriberParam,
        _IllegalEquipmentParam_extensionContainer,
        IllegalEquipmentParam,
        _BearerServNotProvParam_extensionContainer,
        BearerServNotProvParam,
        _TeleservNotProvParam_extensionContainer,
        TeleservNotProvParam,
        _TracingBufferFullParam_extensionContainer,
        TracingBufferFullParam,
        _NoRoamingNbParam_extensionContainer,
        NoRoamingNbParam,
        _AbsentSubscriberParam_extensionContainer,
        _AbsentSubscriberParam_absentSubscriberReason,
        AbsentSubscriberParam,
        AbsentSubscriberReason,
        _BusySubscriberParam_extensionContainer,
        _BusySubscriberParam_ccbs_Possible,
        _BusySubscriberParam_ccbs_Busy,
        BusySubscriberParam,
        _NoSubscriberReplyParam_extensionContainer,
        NoSubscriberReplyParam,
        _ForwardingViolationParam_extensionContainer,
        ForwardingViolationParam,
        _ForwardingFailedParam_extensionContainer,
        ForwardingFailedParam,
        _ATI_NotAllowedParam_extensionContainer,
        ATI_NotAllowedParam,
        _ATSI_NotAllowedParam_extensionContainer,
        ATSI_NotAllowedParam,
        _ATM_NotAllowedParam_extensionContainer,
        ATM_NotAllowedParam,
        _IllegalSS_OperationParam_extensionContainer,
        IllegalSS_OperationParam,
        _SS_NotAvailableParam_extensionContainer,
        SS_NotAvailableParam,
        _SS_SubscriptionViolationParam_extensionContainer,
        SS_SubscriptionViolationParam,
        _InformationNotAvailableParam_extensionContainer,
        InformationNotAvailableParam,
        _SubBusyForMT_SMS_Param_extensionContainer,
        _SubBusyForMT_SMS_Param_gprsConnectionSuspended,
        SubBusyForMT_SMS_Param,
        _MessageWaitListFullParam_extensionContainer,
        MessageWaitListFullParam,
        _ResourceLimitationParam_extensionContainer,
        ResourceLimitationParam,
        _NoGroupCallNbParam_extensionContainer,
        NoGroupCallNbParam,
        _IncompatibleTerminalParam_extensionContainer,
        IncompatibleTerminalParam,
        ShortTermDenialParam,
        LongTermDenialParam,
        _UnauthorizedRequestingNetwork_Param_extensionContainer,
        UnauthorizedRequestingNetwork_Param,
        _UnauthorizedLCSClient_Param_unauthorizedLCSClient_Diagnostic,
        _UnauthorizedLCSClient_Param_extensionContainer,
        UnauthorizedLCSClient_Param,
        UnauthorizedLCSClient_Diagnostic,
        _PositionMethodFailure_Param_positionMethodFailure_Diagnostic,
        _PositionMethodFailure_Param_extensionContainer,
        PositionMethodFailure_Param,
        PositionMethodFailure_Diagnostic,
        _UnknownOrUnreachableLCSClient_Param_extensionContainer,
        UnknownOrUnreachableLCSClient_Param,
        _MM_EventNotSupported_Param_extensionContainer,
        MM_EventNotSupported_Param,
        _TargetCellOutsideGCA_Param_extensionContainer,
        TargetCellOutsideGCA_Param,
        _OngoingGroupCallParam_extensionContainer,
        OngoingGroupCallParam,
    ]

class CAP_U_ABORT_Data:

    _name_  = u'CAP-U-ABORT-Data'
    _oid_   = [0, 4, 0, 0, 1, 3, 110, 7]
    
    _obj_ = [
        u'id-CAP-U-ABORT-Reason',
        u'cAP-U-ABORT-Reason-Abstract-Syntax',
        u'CAP-U-ABORT-REASON',
        ]
    _type_ = [
        u'CAP-U-ABORT-REASON',
        ]
    _set_ = [
        ]
    _val_ = [
        u'id-CAP-U-ABORT-Reason',
        u'cAP-U-ABORT-Reason-Abstract-Syntax',
        ]
    _class_ = [
        u'cAP-U-ABORT-Reason-Abstract-Syntax',
        ]
    _param_ = [
        ]
    
    #-----< id-CAP-U-ABORT-Reason >-----#
    id_CAP_U_ABORT_Reason = OID(name=u'id-CAP-U-ABORT-Reason', mode=MODE_VALUE)
    id_CAP_U_ABORT_Reason._val = (0, 4, 0, 0, 1, 1, 2, 2)
    
    #-----< cAP-U-ABORT-Reason-Abstract-Syntax >-----#
    cAP_U_ABORT_Reason_Abstract_Syntax = CLASS(name=u'cAP-U-ABORT-Reason-Abstract-Syntax', mode=MODE_VALUE, typeref=ASN1RefType(('_IMPL_', u'ABSTRACT-SYNTAX'), []))
    _cAP_U_ABORT_Reason_Abstract_Syntax_val_Type = ENUM(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CAP-U-ABORT-Data', 'CAP-U-ABORT-REASON')))
    cAP_U_ABORT_Reason_Abstract_Syntax._val = dict([('Type', _cAP_U_ABORT_Reason_Abstract_Syntax_val_Type), ('id', (0, 4, 0, 0, 1, 1, 2, 2))])
    
    #-----< CAP-U-ABORT-REASON >-----#
    CAP_U_ABORT_REASON = ENUM(name=u'CAP-U-ABORT-REASON', mode=MODE_TYPE)
    CAP_U_ABORT_REASON._cont = ASN1Dict([(u'no-reason-given', 1), (u'application-timer-expired', 2), (u'not-allowed-procedures', 3), (u'abnormal-processing', 4), (u'congestion', 5), (u'invalid-reference', 6), (u'missing-reference', 7), (u'overlapping-dialogue', 8)])
    CAP_U_ABORT_REASON._ext = None
    
    _all_ = [
        id_CAP_U_ABORT_Reason,
        cAP_U_ABORT_Reason_Abstract_Syntax,
        _cAP_U_ABORT_Reason_Abstract_Syntax_val_Type,
        CAP_U_ABORT_REASON,
    ]

class CAP_object_identifiers:

    _name_  = u'CAP-object-identifiers'
    _oid_   = [0, 4, 0, 0, 1, 3, 100, 7]
    
    _obj_ = [
        u'tc-Messages',
        u'tc-NotationExtensions',
        u'ros-InformationObjects',
        u'datatypes',
        u'errortypes',
        u'operationcodes',
        u'errorcodes',
        u'classes',
        u'gsmSSF-gsmSCF-Operations',
        u'gsmSSF-gsmSCF-Protocol',
        u'gsmSCF-gsmSRF-Operations',
        u'gsmSCF-gsmSRF-Protocol',
        u'sms-Operations',
        u'smsSSF-gsmSCF-Protocol',
        u'gprsSSF-gsmSCF-Operations',
        u'gprsSSF-gsmSCF-Protocol',
        u'id-CAP',
        u'id-CAP3',
        u'id-CAPOE',
        u'id-CAP3OE',
        u'id-ac',
        u'id-acE',
        u'id-ac3E',
        u'id-as',
        u'id-asE',
        u'id-rosObject',
        u'id-contract',
        u'id-contract3',
        u'id-contractE',
        u'id-package',
        u'id-packageE',
        u'id-rosObject-gsmSCF',
        u'id-rosObject-gsmSSF',
        u'id-rosObject-gsmSRF',
        u'id-rosObject-gprsSSF',
        u'id-rosObject-smsSSF-V3',
        u'id-rosObject-smsSSF-V4',
        u'id-ac-CAP-gsmSSF-scfGenericAC',
        u'id-ac-CAP-gsmSSF-scfAssistHandoffAC',
        u'id-ac-CAP-scf-gsmSSFGenericAC',
        u'id-ac-gsmSRF-gsmSCF',
        u'id-ac-CAP-gprsSSF-gsmSCF-AC',
        u'id-ac-CAP-gsmSCF-gprsSSF-AC',
        u'id-ac-cap3-sms-AC',
        u'id-ac-cap4-sms-AC',
        u'id-CAPSsfToScfGeneric',
        u'id-CAPAssistHandoffssfToScf',
        u'id-CAPScfToSsfGeneric',
        u'id-contract-gsmSRF-gsmSCF',
        u'id-capGprsSsfTogsmScf',
        u'id-capGsmScfToGprsSsf',
        u'id-cap3SmsSsfTogsmScf',
        u'id-cap4SmsSsfTogsmScf',
        u'id-package-scfActivation',
        u'id-package-gsmSRF-scfActivationOfAssist',
        u'id-package-assistConnectionEstablishment',
        u'id-package-genericDisconnectResource',
        u'id-package-nonAssistedConnectionEstablishment',
        u'id-package-connect',
        u'id-package-callHandling',
        u'id-package-bcsmEventHandling',
        u'id-package-ssfCallProcessing',
        u'id-package-scfCallInitiation',
        u'id-package-timer',
        u'id-package-billing',
        u'id-package-charging',
        u'id-package-trafficManagement',
        u'id-package-callReport',
        u'id-package-signallingControl',
        u'id-package-activityTest',
        u'id-package-cancel',
        u'id-package-cphResponse',
        u'id-package-exceptionInform',
        u'id-package-playTone',
        u'id-package-specializedResourceControl',
        u'id-package-gsmSRF-scfCancel',
        u'id-package-gprsContinue',
        u'id-package-gprsExceptionInformation',
        u'id-package-gprsScfActivation',
        u'id-package-gprsConnect',
        u'id-package-gprsRelease',
        u'id-package-gprsEventHandling',
        u'id-package-gprsTimer',
        u'id-package-gprsBilling',
        u'id-package-gprsCharging',
        u'id-package-gprsActivityTest',
        u'id-package-gprsCancel',
        u'id-package-gprsChargeAdvice',
        u'id-package-smsActivation',
        u'id-package-smsConnect',
        u'id-package-smsContinue',
        u'id-package-smsRelease',
        u'id-package-smsEventHandling',
        u'id-package-smsBilling',
        u'id-package-smsTimer',
        u'id-as-gsmSSF-scfGenericAS',
        u'id-as-assistHandoff-gsmSSF-scfAS',
        u'id-as-scf-gsmSSFGenericAS',
        u'id-as-basic-gsmSRF-gsmSCF',
        u'id-as-gprsSSF-gsmSCF-AS',
        u'id-as-gsmSCF-gprsSSF-AS',
        u'id-as-smsSSF-gsmSCF-AS',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'tc-Messages',
        u'tc-NotationExtensions',
        u'ros-InformationObjects',
        u'datatypes',
        u'errortypes',
        u'operationcodes',
        u'errorcodes',
        u'classes',
        u'gsmSSF-gsmSCF-Operations',
        u'gsmSSF-gsmSCF-Protocol',
        u'gsmSCF-gsmSRF-Operations',
        u'gsmSCF-gsmSRF-Protocol',
        u'sms-Operations',
        u'smsSSF-gsmSCF-Protocol',
        u'gprsSSF-gsmSCF-Operations',
        u'gprsSSF-gsmSCF-Protocol',
        u'id-CAP',
        u'id-CAP3',
        u'id-CAPOE',
        u'id-CAP3OE',
        u'id-ac',
        u'id-acE',
        u'id-ac3E',
        u'id-as',
        u'id-asE',
        u'id-rosObject',
        u'id-contract',
        u'id-contract3',
        u'id-contractE',
        u'id-package',
        u'id-packageE',
        u'id-rosObject-gsmSCF',
        u'id-rosObject-gsmSSF',
        u'id-rosObject-gsmSRF',
        u'id-rosObject-gprsSSF',
        u'id-rosObject-smsSSF-V3',
        u'id-rosObject-smsSSF-V4',
        u'id-ac-CAP-gsmSSF-scfGenericAC',
        u'id-ac-CAP-gsmSSF-scfAssistHandoffAC',
        u'id-ac-CAP-scf-gsmSSFGenericAC',
        u'id-ac-gsmSRF-gsmSCF',
        u'id-ac-CAP-gprsSSF-gsmSCF-AC',
        u'id-ac-CAP-gsmSCF-gprsSSF-AC',
        u'id-ac-cap3-sms-AC',
        u'id-ac-cap4-sms-AC',
        u'id-CAPSsfToScfGeneric',
        u'id-CAPAssistHandoffssfToScf',
        u'id-CAPScfToSsfGeneric',
        u'id-contract-gsmSRF-gsmSCF',
        u'id-capGprsSsfTogsmScf',
        u'id-capGsmScfToGprsSsf',
        u'id-cap3SmsSsfTogsmScf',
        u'id-cap4SmsSsfTogsmScf',
        u'id-package-scfActivation',
        u'id-package-gsmSRF-scfActivationOfAssist',
        u'id-package-assistConnectionEstablishment',
        u'id-package-genericDisconnectResource',
        u'id-package-nonAssistedConnectionEstablishment',
        u'id-package-connect',
        u'id-package-callHandling',
        u'id-package-bcsmEventHandling',
        u'id-package-ssfCallProcessing',
        u'id-package-scfCallInitiation',
        u'id-package-timer',
        u'id-package-billing',
        u'id-package-charging',
        u'id-package-trafficManagement',
        u'id-package-callReport',
        u'id-package-signallingControl',
        u'id-package-activityTest',
        u'id-package-cancel',
        u'id-package-cphResponse',
        u'id-package-exceptionInform',
        u'id-package-playTone',
        u'id-package-specializedResourceControl',
        u'id-package-gsmSRF-scfCancel',
        u'id-package-gprsContinue',
        u'id-package-gprsExceptionInformation',
        u'id-package-gprsScfActivation',
        u'id-package-gprsConnect',
        u'id-package-gprsRelease',
        u'id-package-gprsEventHandling',
        u'id-package-gprsTimer',
        u'id-package-gprsBilling',
        u'id-package-gprsCharging',
        u'id-package-gprsActivityTest',
        u'id-package-gprsCancel',
        u'id-package-gprsChargeAdvice',
        u'id-package-smsActivation',
        u'id-package-smsConnect',
        u'id-package-smsContinue',
        u'id-package-smsRelease',
        u'id-package-smsEventHandling',
        u'id-package-smsBilling',
        u'id-package-smsTimer',
        u'id-as-gsmSSF-scfGenericAS',
        u'id-as-assistHandoff-gsmSSF-scfAS',
        u'id-as-scf-gsmSSFGenericAS',
        u'id-as-basic-gsmSRF-gsmSCF',
        u'id-as-gprsSSF-gsmSCF-AS',
        u'id-as-gsmSCF-gprsSSF-AS',
        u'id-as-smsSSF-gsmSCF-AS',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< tc-Messages >-----#
    tc_Messages = OID(name=u'tc-Messages', mode=MODE_VALUE)
    tc_Messages._val = (0, 0, 17, 773, 2, 1, 3)
    
    #-----< tc-NotationExtensions >-----#
    tc_NotationExtensions = OID(name=u'tc-NotationExtensions', mode=MODE_VALUE)
    tc_NotationExtensions._val = (0, 0, 17, 775, 2, 4, 1)
    
    #-----< ros-InformationObjects >-----#
    ros_InformationObjects = OID(name=u'ros-InformationObjects', mode=MODE_VALUE)
    ros_InformationObjects._val = (2, 4, 5, 0)
    
    #-----< datatypes >-----#
    datatypes = OID(name=u'datatypes', mode=MODE_VALUE)
    datatypes._val = (0, 4, 0, 0, 1, 3, 52, 7)
    
    #-----< errortypes >-----#
    errortypes = OID(name=u'errortypes', mode=MODE_VALUE)
    errortypes._val = (0, 4, 0, 0, 1, 3, 51, 7)
    
    #-----< operationcodes >-----#
    operationcodes = OID(name=u'operationcodes', mode=MODE_VALUE)
    operationcodes._val = (0, 4, 0, 0, 1, 3, 53, 7)
    
    #-----< errorcodes >-----#
    errorcodes = OID(name=u'errorcodes', mode=MODE_VALUE)
    errorcodes._val = (0, 4, 0, 0, 1, 3, 57, 7)
    
    #-----< classes >-----#
    classes = OID(name=u'classes', mode=MODE_VALUE)
    classes._val = (0, 4, 0, 0, 1, 3, 54, 7)
    
    #-----< gsmSSF-gsmSCF-Operations >-----#
    gsmSSF_gsmSCF_Operations = OID(name=u'gsmSSF-gsmSCF-Operations', mode=MODE_VALUE)
    gsmSSF_gsmSCF_Operations._val = (0, 4, 0, 0, 1, 3, 101, 7)
    
    #-----< gsmSSF-gsmSCF-Protocol >-----#
    gsmSSF_gsmSCF_Protocol = OID(name=u'gsmSSF-gsmSCF-Protocol', mode=MODE_VALUE)
    gsmSSF_gsmSCF_Protocol._val = (0, 4, 0, 0, 1, 3, 102, 7)
    
    #-----< gsmSCF-gsmSRF-Operations >-----#
    gsmSCF_gsmSRF_Operations = OID(name=u'gsmSCF-gsmSRF-Operations', mode=MODE_VALUE)
    gsmSCF_gsmSRF_Operations._val = (0, 4, 0, 0, 1, 3, 103, 7)
    
    #-----< gsmSCF-gsmSRF-Protocol >-----#
    gsmSCF_gsmSRF_Protocol = OID(name=u'gsmSCF-gsmSRF-Protocol', mode=MODE_VALUE)
    gsmSCF_gsmSRF_Protocol._val = (0, 4, 0, 0, 1, 3, 104, 7)
    
    #-----< sms-Operations >-----#
    sms_Operations = OID(name=u'sms-Operations', mode=MODE_VALUE)
    sms_Operations._val = (0, 4, 0, 0, 1, 3, 105, 7)
    
    #-----< smsSSF-gsmSCF-Protocol >-----#
    smsSSF_gsmSCF_Protocol = OID(name=u'smsSSF-gsmSCF-Protocol', mode=MODE_VALUE)
    smsSSF_gsmSCF_Protocol._val = (0, 4, 0, 0, 1, 3, 106, 7)
    
    #-----< gprsSSF-gsmSCF-Operations >-----#
    gprsSSF_gsmSCF_Operations = OID(name=u'gprsSSF-gsmSCF-Operations', mode=MODE_VALUE)
    gprsSSF_gsmSCF_Operations._val = (0, 4, 0, 0, 1, 3, 107, 7)
    
    #-----< gprsSSF-gsmSCF-Protocol >-----#
    gprsSSF_gsmSCF_Protocol = OID(name=u'gprsSSF-gsmSCF-Protocol', mode=MODE_VALUE)
    gprsSSF_gsmSCF_Protocol._val = (0, 4, 0, 0, 1, 3, 108, 7)
    
    #-----< id-CAP >-----#
    id_CAP = OID(name=u'id-CAP', mode=MODE_VALUE)
    id_CAP._val = (0, 4, 0, 0, 1, 22)
    
    #-----< id-CAP3 >-----#
    id_CAP3 = OID(name=u'id-CAP3', mode=MODE_VALUE)
    id_CAP3._val = (0, 4, 0, 0, 1, 20)
    
    #-----< id-CAPOE >-----#
    id_CAPOE = OID(name=u'id-CAPOE', mode=MODE_VALUE)
    id_CAPOE._val = (0, 4, 0, 0, 1, 23)
    
    #-----< id-CAP3OE >-----#
    id_CAP3OE = OID(name=u'id-CAP3OE', mode=MODE_VALUE)
    id_CAP3OE._val = (0, 4, 0, 0, 1, 21)
    
    #-----< id-ac >-----#
    id_ac = OID(name=u'id-ac', mode=MODE_VALUE)
    id_ac._val = (0, 4, 0, 0, 1, 22, 3)
    
    #-----< id-acE >-----#
    id_acE = OID(name=u'id-acE', mode=MODE_VALUE)
    id_acE._val = (0, 4, 0, 0, 1, 23, 3)
    
    #-----< id-ac3E >-----#
    id_ac3E = OID(name=u'id-ac3E', mode=MODE_VALUE)
    id_ac3E._val = (0, 4, 0, 0, 1, 21, 3)
    
    #-----< id-as >-----#
    id_as = OID(name=u'id-as', mode=MODE_VALUE)
    id_as._val = (0, 4, 0, 0, 1, 22, 5)
    
    #-----< id-asE >-----#
    id_asE = OID(name=u'id-asE', mode=MODE_VALUE)
    id_asE._val = (0, 4, 0, 0, 1, 23, 5)
    
    #-----< id-rosObject >-----#
    id_rosObject = OID(name=u'id-rosObject', mode=MODE_VALUE)
    id_rosObject._val = (0, 4, 0, 0, 1, 22, 25)
    
    #-----< id-contract >-----#
    id_contract = OID(name=u'id-contract', mode=MODE_VALUE)
    id_contract._val = (0, 4, 0, 0, 1, 22, 26)
    
    #-----< id-contract3 >-----#
    id_contract3 = OID(name=u'id-contract3', mode=MODE_VALUE)
    id_contract3._val = (0, 4, 0, 0, 1, 20, 26)
    
    #-----< id-contractE >-----#
    id_contractE = OID(name=u'id-contractE', mode=MODE_VALUE)
    id_contractE._val = (0, 4, 0, 0, 1, 23, 26)
    
    #-----< id-package >-----#
    id_package = OID(name=u'id-package', mode=MODE_VALUE)
    id_package._val = (0, 4, 0, 0, 1, 22, 27)
    
    #-----< id-packageE >-----#
    id_packageE = OID(name=u'id-packageE', mode=MODE_VALUE)
    id_packageE._val = (0, 4, 0, 0, 1, 23, 27)
    
    #-----< id-rosObject-gsmSCF >-----#
    id_rosObject_gsmSCF = OID(name=u'id-rosObject-gsmSCF', mode=MODE_VALUE)
    id_rosObject_gsmSCF._val = (0, 4, 0, 0, 1, 22, 25, 4)
    
    #-----< id-rosObject-gsmSSF >-----#
    id_rosObject_gsmSSF = OID(name=u'id-rosObject-gsmSSF', mode=MODE_VALUE)
    id_rosObject_gsmSSF._val = (0, 4, 0, 0, 1, 22, 25, 5)
    
    #-----< id-rosObject-gsmSRF >-----#
    id_rosObject_gsmSRF = OID(name=u'id-rosObject-gsmSRF', mode=MODE_VALUE)
    id_rosObject_gsmSRF._val = (0, 4, 0, 0, 1, 22, 25, 6)
    
    #-----< id-rosObject-gprsSSF >-----#
    id_rosObject_gprsSSF = OID(name=u'id-rosObject-gprsSSF', mode=MODE_VALUE)
    id_rosObject_gprsSSF._val = (0, 4, 0, 0, 1, 22, 25, 7)
    
    #-----< id-rosObject-smsSSF-V3 >-----#
    id_rosObject_smsSSF_V3 = OID(name=u'id-rosObject-smsSSF-V3', mode=MODE_VALUE)
    id_rosObject_smsSSF_V3._val = (0, 4, 0, 0, 1, 22, 25, 8)
    
    #-----< id-rosObject-smsSSF-V4 >-----#
    id_rosObject_smsSSF_V4 = OID(name=u'id-rosObject-smsSSF-V4', mode=MODE_VALUE)
    id_rosObject_smsSSF_V4._val = (0, 4, 0, 0, 1, 22, 25, 9)
    
    #-----< id-ac-CAP-gsmSSF-scfGenericAC >-----#
    id_ac_CAP_gsmSSF_scfGenericAC = OID(name=u'id-ac-CAP-gsmSSF-scfGenericAC', mode=MODE_VALUE)
    id_ac_CAP_gsmSSF_scfGenericAC._val = (0, 4, 0, 0, 1, 23, 3, 4)
    
    #-----< id-ac-CAP-gsmSSF-scfAssistHandoffAC >-----#
    id_ac_CAP_gsmSSF_scfAssistHandoffAC = OID(name=u'id-ac-CAP-gsmSSF-scfAssistHandoffAC', mode=MODE_VALUE)
    id_ac_CAP_gsmSSF_scfAssistHandoffAC._val = (0, 4, 0, 0, 1, 23, 3, 6)
    
    #-----< id-ac-CAP-scf-gsmSSFGenericAC >-----#
    id_ac_CAP_scf_gsmSSFGenericAC = OID(name=u'id-ac-CAP-scf-gsmSSFGenericAC', mode=MODE_VALUE)
    id_ac_CAP_scf_gsmSSFGenericAC._val = (0, 4, 0, 0, 1, 23, 3, 8)
    
    #-----< id-ac-gsmSRF-gsmSCF >-----#
    id_ac_gsmSRF_gsmSCF = OID(name=u'id-ac-gsmSRF-gsmSCF', mode=MODE_VALUE)
    id_ac_gsmSRF_gsmSCF._val = (0, 4, 0, 0, 1, 22, 3, 14)
    
    #-----< id-ac-CAP-gprsSSF-gsmSCF-AC >-----#
    id_ac_CAP_gprsSSF_gsmSCF_AC = OID(name=u'id-ac-CAP-gprsSSF-gsmSCF-AC', mode=MODE_VALUE)
    id_ac_CAP_gprsSSF_gsmSCF_AC._val = (0, 4, 0, 0, 1, 21, 3, 50)
    
    #-----< id-ac-CAP-gsmSCF-gprsSSF-AC >-----#
    id_ac_CAP_gsmSCF_gprsSSF_AC = OID(name=u'id-ac-CAP-gsmSCF-gprsSSF-AC', mode=MODE_VALUE)
    id_ac_CAP_gsmSCF_gprsSSF_AC._val = (0, 4, 0, 0, 1, 21, 3, 51)
    
    #-----< id-ac-cap3-sms-AC >-----#
    id_ac_cap3_sms_AC = OID(name=u'id-ac-cap3-sms-AC', mode=MODE_VALUE)
    id_ac_cap3_sms_AC._val = (0, 4, 0, 0, 1, 21, 3, 61)
    
    #-----< id-ac-cap4-sms-AC >-----#
    id_ac_cap4_sms_AC = OID(name=u'id-ac-cap4-sms-AC', mode=MODE_VALUE)
    id_ac_cap4_sms_AC._val = (0, 4, 0, 0, 1, 23, 3, 61)
    
    #-----< id-CAPSsfToScfGeneric >-----#
    id_CAPSsfToScfGeneric = OID(name=u'id-CAPSsfToScfGeneric', mode=MODE_VALUE)
    id_CAPSsfToScfGeneric._val = (0, 4, 0, 0, 1, 23, 26, 3)
    
    #-----< id-CAPAssistHandoffssfToScf >-----#
    id_CAPAssistHandoffssfToScf = OID(name=u'id-CAPAssistHandoffssfToScf', mode=MODE_VALUE)
    id_CAPAssistHandoffssfToScf._val = (0, 4, 0, 0, 1, 23, 26, 5)
    
    #-----< id-CAPScfToSsfGeneric >-----#
    id_CAPScfToSsfGeneric = OID(name=u'id-CAPScfToSsfGeneric', mode=MODE_VALUE)
    id_CAPScfToSsfGeneric._val = (0, 4, 0, 0, 1, 23, 26, 6)
    
    #-----< id-contract-gsmSRF-gsmSCF >-----#
    id_contract_gsmSRF_gsmSCF = OID(name=u'id-contract-gsmSRF-gsmSCF', mode=MODE_VALUE)
    id_contract_gsmSRF_gsmSCF._val = (0, 4, 0, 0, 1, 22, 26, 13)
    
    #-----< id-capGprsSsfTogsmScf >-----#
    id_capGprsSsfTogsmScf = OID(name=u'id-capGprsSsfTogsmScf', mode=MODE_VALUE)
    id_capGprsSsfTogsmScf._val = (0, 4, 0, 0, 1, 22, 26, 14)
    
    #-----< id-capGsmScfToGprsSsf >-----#
    id_capGsmScfToGprsSsf = OID(name=u'id-capGsmScfToGprsSsf', mode=MODE_VALUE)
    id_capGsmScfToGprsSsf._val = (0, 4, 0, 0, 1, 22, 26, 15)
    
    #-----< id-cap3SmsSsfTogsmScf >-----#
    id_cap3SmsSsfTogsmScf = OID(name=u'id-cap3SmsSsfTogsmScf', mode=MODE_VALUE)
    id_cap3SmsSsfTogsmScf._val = (0, 4, 0, 0, 1, 20, 26, 16)
    
    #-----< id-cap4SmsSsfTogsmScf >-----#
    id_cap4SmsSsfTogsmScf = OID(name=u'id-cap4SmsSsfTogsmScf', mode=MODE_VALUE)
    id_cap4SmsSsfTogsmScf._val = (0, 4, 0, 0, 1, 22, 26, 16)
    
    #-----< id-package-scfActivation >-----#
    id_package_scfActivation = OID(name=u'id-package-scfActivation', mode=MODE_VALUE)
    id_package_scfActivation._val = (0, 4, 0, 0, 1, 22, 27, 11)
    
    #-----< id-package-gsmSRF-scfActivationOfAssist >-----#
    id_package_gsmSRF_scfActivationOfAssist = OID(name=u'id-package-gsmSRF-scfActivationOfAssist', mode=MODE_VALUE)
    id_package_gsmSRF_scfActivationOfAssist._val = (0, 4, 0, 0, 1, 22, 27, 15)
    
    #-----< id-package-assistConnectionEstablishment >-----#
    id_package_assistConnectionEstablishment = OID(name=u'id-package-assistConnectionEstablishment', mode=MODE_VALUE)
    id_package_assistConnectionEstablishment._val = (0, 4, 0, 0, 1, 22, 27, 16)
    
    #-----< id-package-genericDisconnectResource >-----#
    id_package_genericDisconnectResource = OID(name=u'id-package-genericDisconnectResource', mode=MODE_VALUE)
    id_package_genericDisconnectResource._val = (0, 4, 0, 0, 1, 22, 27, 17)
    
    #-----< id-package-nonAssistedConnectionEstablishment >-----#
    id_package_nonAssistedConnectionEstablishment = OID(name=u'id-package-nonAssistedConnectionEstablishment', mode=MODE_VALUE)
    id_package_nonAssistedConnectionEstablishment._val = (0, 4, 0, 0, 1, 22, 27, 18)
    
    #-----< id-package-connect >-----#
    id_package_connect = OID(name=u'id-package-connect', mode=MODE_VALUE)
    id_package_connect._val = (0, 4, 0, 0, 1, 22, 27, 19)
    
    #-----< id-package-callHandling >-----#
    id_package_callHandling = OID(name=u'id-package-callHandling', mode=MODE_VALUE)
    id_package_callHandling._val = (0, 4, 0, 0, 1, 23, 27, 20)
    
    #-----< id-package-bcsmEventHandling >-----#
    id_package_bcsmEventHandling = OID(name=u'id-package-bcsmEventHandling', mode=MODE_VALUE)
    id_package_bcsmEventHandling._val = (0, 4, 0, 0, 1, 22, 27, 21)
    
    #-----< id-package-ssfCallProcessing >-----#
    id_package_ssfCallProcessing = OID(name=u'id-package-ssfCallProcessing', mode=MODE_VALUE)
    id_package_ssfCallProcessing._val = (0, 4, 0, 0, 1, 23, 27, 24)
    
    #-----< id-package-scfCallInitiation >-----#
    id_package_scfCallInitiation = OID(name=u'id-package-scfCallInitiation', mode=MODE_VALUE)
    id_package_scfCallInitiation._val = (0, 4, 0, 0, 1, 22, 27, 25)
    
    #-----< id-package-timer >-----#
    id_package_timer = OID(name=u'id-package-timer', mode=MODE_VALUE)
    id_package_timer._val = (0, 4, 0, 0, 1, 22, 27, 26)
    
    #-----< id-package-billing >-----#
    id_package_billing = OID(name=u'id-package-billing', mode=MODE_VALUE)
    id_package_billing._val = (0, 4, 0, 0, 1, 22, 27, 27)
    
    #-----< id-package-charging >-----#
    id_package_charging = OID(name=u'id-package-charging', mode=MODE_VALUE)
    id_package_charging._val = (0, 4, 0, 0, 1, 22, 27, 28)
    
    #-----< id-package-trafficManagement >-----#
    id_package_trafficManagement = OID(name=u'id-package-trafficManagement', mode=MODE_VALUE)
    id_package_trafficManagement._val = (0, 4, 0, 0, 1, 22, 27, 29)
    
    #-----< id-package-callReport >-----#
    id_package_callReport = OID(name=u'id-package-callReport', mode=MODE_VALUE)
    id_package_callReport._val = (0, 4, 0, 0, 1, 22, 27, 32)
    
    #-----< id-package-signallingControl >-----#
    id_package_signallingControl = OID(name=u'id-package-signallingControl', mode=MODE_VALUE)
    id_package_signallingControl._val = (0, 4, 0, 0, 1, 22, 27, 33)
    
    #-----< id-package-activityTest >-----#
    id_package_activityTest = OID(name=u'id-package-activityTest', mode=MODE_VALUE)
    id_package_activityTest._val = (0, 4, 0, 0, 1, 22, 27, 34)
    
    #-----< id-package-cancel >-----#
    id_package_cancel = OID(name=u'id-package-cancel', mode=MODE_VALUE)
    id_package_cancel._val = (0, 4, 0, 0, 1, 23, 27, 36)
    
    #-----< id-package-cphResponse >-----#
    id_package_cphResponse = OID(name=u'id-package-cphResponse', mode=MODE_VALUE)
    id_package_cphResponse._val = (0, 4, 0, 0, 1, 22, 27, 37)
    
    #-----< id-package-exceptionInform >-----#
    id_package_exceptionInform = OID(name=u'id-package-exceptionInform', mode=MODE_VALUE)
    id_package_exceptionInform._val = (0, 4, 0, 0, 1, 22, 27, 38)
    
    #-----< id-package-playTone >-----#
    id_package_playTone = OID(name=u'id-package-playTone', mode=MODE_VALUE)
    id_package_playTone._val = (0, 4, 0, 0, 1, 22, 27, 39)
    
    #-----< id-package-specializedResourceControl >-----#
    id_package_specializedResourceControl = OID(name=u'id-package-specializedResourceControl', mode=MODE_VALUE)
    id_package_specializedResourceControl._val = (0, 4, 0, 0, 1, 22, 27, 42)
    
    #-----< id-package-gsmSRF-scfCancel >-----#
    id_package_gsmSRF_scfCancel = OID(name=u'id-package-gsmSRF-scfCancel', mode=MODE_VALUE)
    id_package_gsmSRF_scfCancel._val = (0, 4, 0, 0, 1, 22, 27, 43)
    
    #-----< id-package-gprsContinue >-----#
    id_package_gprsContinue = OID(name=u'id-package-gprsContinue', mode=MODE_VALUE)
    id_package_gprsContinue._val = (0, 4, 0, 0, 1, 22, 27, 49)
    
    #-----< id-package-gprsExceptionInformation >-----#
    id_package_gprsExceptionInformation = OID(name=u'id-package-gprsExceptionInformation', mode=MODE_VALUE)
    id_package_gprsExceptionInformation._val = (0, 4, 0, 0, 1, 22, 27, 50)
    
    #-----< id-package-gprsScfActivation >-----#
    id_package_gprsScfActivation = OID(name=u'id-package-gprsScfActivation', mode=MODE_VALUE)
    id_package_gprsScfActivation._val = (0, 4, 0, 0, 1, 22, 27, 51)
    
    #-----< id-package-gprsConnect >-----#
    id_package_gprsConnect = OID(name=u'id-package-gprsConnect', mode=MODE_VALUE)
    id_package_gprsConnect._val = (0, 4, 0, 0, 1, 22, 27, 52)
    
    #-----< id-package-gprsRelease >-----#
    id_package_gprsRelease = OID(name=u'id-package-gprsRelease', mode=MODE_VALUE)
    id_package_gprsRelease._val = (0, 4, 0, 0, 1, 22, 27, 53)
    
    #-----< id-package-gprsEventHandling >-----#
    id_package_gprsEventHandling = OID(name=u'id-package-gprsEventHandling', mode=MODE_VALUE)
    id_package_gprsEventHandling._val = (0, 4, 0, 0, 1, 22, 27, 54)
    
    #-----< id-package-gprsTimer >-----#
    id_package_gprsTimer = OID(name=u'id-package-gprsTimer', mode=MODE_VALUE)
    id_package_gprsTimer._val = (0, 4, 0, 0, 1, 22, 27, 55)
    
    #-----< id-package-gprsBilling >-----#
    id_package_gprsBilling = OID(name=u'id-package-gprsBilling', mode=MODE_VALUE)
    id_package_gprsBilling._val = (0, 4, 0, 0, 1, 22, 27, 56)
    
    #-----< id-package-gprsCharging >-----#
    id_package_gprsCharging = OID(name=u'id-package-gprsCharging', mode=MODE_VALUE)
    id_package_gprsCharging._val = (0, 4, 0, 0, 1, 22, 27, 57)
    
    #-----< id-package-gprsActivityTest >-----#
    id_package_gprsActivityTest = OID(name=u'id-package-gprsActivityTest', mode=MODE_VALUE)
    id_package_gprsActivityTest._val = (0, 4, 0, 0, 1, 22, 27, 58)
    
    #-----< id-package-gprsCancel >-----#
    id_package_gprsCancel = OID(name=u'id-package-gprsCancel', mode=MODE_VALUE)
    id_package_gprsCancel._val = (0, 4, 0, 0, 1, 22, 27, 59)
    
    #-----< id-package-gprsChargeAdvice >-----#
    id_package_gprsChargeAdvice = OID(name=u'id-package-gprsChargeAdvice', mode=MODE_VALUE)
    id_package_gprsChargeAdvice._val = (0, 4, 0, 0, 1, 22, 27, 60)
    
    #-----< id-package-smsActivation >-----#
    id_package_smsActivation = OID(name=u'id-package-smsActivation', mode=MODE_VALUE)
    id_package_smsActivation._val = (0, 4, 0, 0, 1, 22, 27, 61)
    
    #-----< id-package-smsConnect >-----#
    id_package_smsConnect = OID(name=u'id-package-smsConnect', mode=MODE_VALUE)
    id_package_smsConnect._val = (0, 4, 0, 0, 1, 22, 27, 62)
    
    #-----< id-package-smsContinue >-----#
    id_package_smsContinue = OID(name=u'id-package-smsContinue', mode=MODE_VALUE)
    id_package_smsContinue._val = (0, 4, 0, 0, 1, 22, 27, 63)
    
    #-----< id-package-smsRelease >-----#
    id_package_smsRelease = OID(name=u'id-package-smsRelease', mode=MODE_VALUE)
    id_package_smsRelease._val = (0, 4, 0, 0, 1, 22, 27, 64)
    
    #-----< id-package-smsEventHandling >-----#
    id_package_smsEventHandling = OID(name=u'id-package-smsEventHandling', mode=MODE_VALUE)
    id_package_smsEventHandling._val = (0, 4, 0, 0, 1, 22, 27, 65)
    
    #-----< id-package-smsBilling >-----#
    id_package_smsBilling = OID(name=u'id-package-smsBilling', mode=MODE_VALUE)
    id_package_smsBilling._val = (0, 4, 0, 0, 1, 22, 27, 66)
    
    #-----< id-package-smsTimer >-----#
    id_package_smsTimer = OID(name=u'id-package-smsTimer', mode=MODE_VALUE)
    id_package_smsTimer._val = (0, 4, 0, 0, 1, 22, 27, 67)
    
    #-----< id-as-gsmSSF-scfGenericAS >-----#
    id_as_gsmSSF_scfGenericAS = OID(name=u'id-as-gsmSSF-scfGenericAS', mode=MODE_VALUE)
    id_as_gsmSSF_scfGenericAS._val = (0, 4, 0, 0, 1, 23, 5, 4)
    
    #-----< id-as-assistHandoff-gsmSSF-scfAS >-----#
    id_as_assistHandoff_gsmSSF_scfAS = OID(name=u'id-as-assistHandoff-gsmSSF-scfAS', mode=MODE_VALUE)
    id_as_assistHandoff_gsmSSF_scfAS._val = (0, 4, 0, 0, 1, 23, 5, 6)
    
    #-----< id-as-scf-gsmSSFGenericAS >-----#
    id_as_scf_gsmSSFGenericAS = OID(name=u'id-as-scf-gsmSSFGenericAS', mode=MODE_VALUE)
    id_as_scf_gsmSSFGenericAS._val = (0, 4, 0, 0, 1, 23, 5, 7)
    
    #-----< id-as-basic-gsmSRF-gsmSCF >-----#
    id_as_basic_gsmSRF_gsmSCF = OID(name=u'id-as-basic-gsmSRF-gsmSCF', mode=MODE_VALUE)
    id_as_basic_gsmSRF_gsmSCF._val = (0, 4, 0, 0, 1, 22, 5, 14)
    
    #-----< id-as-gprsSSF-gsmSCF-AS >-----#
    id_as_gprsSSF_gsmSCF_AS = OID(name=u'id-as-gprsSSF-gsmSCF-AS', mode=MODE_VALUE)
    id_as_gprsSSF_gsmSCF_AS._val = (0, 4, 0, 0, 1, 22, 5, 50)
    
    #-----< id-as-gsmSCF-gprsSSF-AS >-----#
    id_as_gsmSCF_gprsSSF_AS = OID(name=u'id-as-gsmSCF-gprsSSF-AS', mode=MODE_VALUE)
    id_as_gsmSCF_gprsSSF_AS._val = (0, 4, 0, 0, 1, 22, 5, 51)
    
    #-----< id-as-smsSSF-gsmSCF-AS >-----#
    id_as_smsSSF_gsmSCF_AS = OID(name=u'id-as-smsSSF-gsmSCF-AS', mode=MODE_VALUE)
    id_as_smsSSF_gsmSCF_AS._val = (0, 4, 0, 0, 1, 22, 5, 61)
    
    _all_ = [
        tc_Messages,
        tc_NotationExtensions,
        ros_InformationObjects,
        datatypes,
        errortypes,
        operationcodes,
        errorcodes,
        classes,
        gsmSSF_gsmSCF_Operations,
        gsmSSF_gsmSCF_Protocol,
        gsmSCF_gsmSRF_Operations,
        gsmSCF_gsmSRF_Protocol,
        sms_Operations,
        smsSSF_gsmSCF_Protocol,
        gprsSSF_gsmSCF_Operations,
        gprsSSF_gsmSCF_Protocol,
        id_CAP,
        id_CAP3,
        id_CAPOE,
        id_CAP3OE,
        id_ac,
        id_acE,
        id_ac3E,
        id_as,
        id_asE,
        id_rosObject,
        id_contract,
        id_contract3,
        id_contractE,
        id_package,
        id_packageE,
        id_rosObject_gsmSCF,
        id_rosObject_gsmSSF,
        id_rosObject_gsmSRF,
        id_rosObject_gprsSSF,
        id_rosObject_smsSSF_V3,
        id_rosObject_smsSSF_V4,
        id_ac_CAP_gsmSSF_scfGenericAC,
        id_ac_CAP_gsmSSF_scfAssistHandoffAC,
        id_ac_CAP_scf_gsmSSFGenericAC,
        id_ac_gsmSRF_gsmSCF,
        id_ac_CAP_gprsSSF_gsmSCF_AC,
        id_ac_CAP_gsmSCF_gprsSSF_AC,
        id_ac_cap3_sms_AC,
        id_ac_cap4_sms_AC,
        id_CAPSsfToScfGeneric,
        id_CAPAssistHandoffssfToScf,
        id_CAPScfToSsfGeneric,
        id_contract_gsmSRF_gsmSCF,
        id_capGprsSsfTogsmScf,
        id_capGsmScfToGprsSsf,
        id_cap3SmsSsfTogsmScf,
        id_cap4SmsSsfTogsmScf,
        id_package_scfActivation,
        id_package_gsmSRF_scfActivationOfAssist,
        id_package_assistConnectionEstablishment,
        id_package_genericDisconnectResource,
        id_package_nonAssistedConnectionEstablishment,
        id_package_connect,
        id_package_callHandling,
        id_package_bcsmEventHandling,
        id_package_ssfCallProcessing,
        id_package_scfCallInitiation,
        id_package_timer,
        id_package_billing,
        id_package_charging,
        id_package_trafficManagement,
        id_package_callReport,
        id_package_signallingControl,
        id_package_activityTest,
        id_package_cancel,
        id_package_cphResponse,
        id_package_exceptionInform,
        id_package_playTone,
        id_package_specializedResourceControl,
        id_package_gsmSRF_scfCancel,
        id_package_gprsContinue,
        id_package_gprsExceptionInformation,
        id_package_gprsScfActivation,
        id_package_gprsConnect,
        id_package_gprsRelease,
        id_package_gprsEventHandling,
        id_package_gprsTimer,
        id_package_gprsBilling,
        id_package_gprsCharging,
        id_package_gprsActivityTest,
        id_package_gprsCancel,
        id_package_gprsChargeAdvice,
        id_package_smsActivation,
        id_package_smsConnect,
        id_package_smsContinue,
        id_package_smsRelease,
        id_package_smsEventHandling,
        id_package_smsBilling,
        id_package_smsTimer,
        id_as_gsmSSF_scfGenericAS,
        id_as_assistHandoff_gsmSSF_scfAS,
        id_as_scf_gsmSSFGenericAS,
        id_as_basic_gsmSRF_gsmSCF,
        id_as_gprsSSF_gsmSCF_AS,
        id_as_gsmSCF_gprsSSF_AS,
        id_as_smsSSF_gsmSCF_AS,
    ]

class CAP_operationcodes:

    _name_  = u'CAP-operationcodes'
    _oid_   = [0, 4, 0, 0, 1, 3, 53, 7]
    
    _obj_ = [
        u'opcode-initialDP',
        u'opcode-assistRequestInstructions',
        u'opcode-establishTemporaryConnection',
        u'opcode-disconnectForwardConnection',
        u'opcode-dFCWithArgument',
        u'opcode-connectToResource',
        u'opcode-connect',
        u'opcode-releaseCall',
        u'opcode-requestReportBCSMEvent',
        u'opcode-eventReportBCSM',
        u'opcode-collectInformation',
        u'opcode-continue',
        u'opcode-initiateCallAttempt',
        u'opcode-resetTimer',
        u'opcode-furnishChargingInformation',
        u'opcode-applyCharging',
        u'opcode-applyChargingReport',
        u'opcode-callGap',
        u'opcode-callInformationReport',
        u'opcode-callInformationRequest',
        u'opcode-sendChargingInformation',
        u'opcode-playAnnouncement',
        u'opcode-promptAndCollectUserInformation',
        u'opcode-specializedResourceReport',
        u'opcode-cancel',
        u'opcode-activityTest',
        u'opcode-continueWithArgument',
        u'opcode-disconnectLeg',
        u'opcode-moveLeg',
        u'opcode-splitLeg',
        u'opcode-entityReleased',
        u'opcode-playTone',
        u'opcode-initialDPSMS',
        u'opcode-furnishChargingInformationSMS',
        u'opcode-connectSMS',
        u'opcode-requestReportSMSEvent',
        u'opcode-eventReportSMS',
        u'opcode-continueSMS',
        u'opcode-releaseSMS',
        u'opcode-resetTimerSMS',
        u'opcode-activityTestGPRS',
        u'opcode-applyChargingGPRS',
        u'opcode-applyChargingReportGPRS',
        u'opcode-cancelGPRS',
        u'opcode-connectGPRS',
        u'opcode-continueGPRS',
        u'opcode-entityReleasedGPRS',
        u'opcode-furnishChargingInformationGPRS',
        u'opcode-initialDPGPRS',
        u'opcode-releaseGPRS',
        u'opcode-eventReportGPRS',
        u'opcode-requestReportGPRSEvent',
        u'opcode-resetTimerGPRS',
        u'opcode-sendChargingInformationGPRS',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'opcode-initialDP',
        u'opcode-assistRequestInstructions',
        u'opcode-establishTemporaryConnection',
        u'opcode-disconnectForwardConnection',
        u'opcode-dFCWithArgument',
        u'opcode-connectToResource',
        u'opcode-connect',
        u'opcode-releaseCall',
        u'opcode-requestReportBCSMEvent',
        u'opcode-eventReportBCSM',
        u'opcode-collectInformation',
        u'opcode-continue',
        u'opcode-initiateCallAttempt',
        u'opcode-resetTimer',
        u'opcode-furnishChargingInformation',
        u'opcode-applyCharging',
        u'opcode-applyChargingReport',
        u'opcode-callGap',
        u'opcode-callInformationReport',
        u'opcode-callInformationRequest',
        u'opcode-sendChargingInformation',
        u'opcode-playAnnouncement',
        u'opcode-promptAndCollectUserInformation',
        u'opcode-specializedResourceReport',
        u'opcode-cancel',
        u'opcode-activityTest',
        u'opcode-continueWithArgument',
        u'opcode-disconnectLeg',
        u'opcode-moveLeg',
        u'opcode-splitLeg',
        u'opcode-entityReleased',
        u'opcode-playTone',
        u'opcode-initialDPSMS',
        u'opcode-furnishChargingInformationSMS',
        u'opcode-connectSMS',
        u'opcode-requestReportSMSEvent',
        u'opcode-eventReportSMS',
        u'opcode-continueSMS',
        u'opcode-releaseSMS',
        u'opcode-resetTimerSMS',
        u'opcode-activityTestGPRS',
        u'opcode-applyChargingGPRS',
        u'opcode-applyChargingReportGPRS',
        u'opcode-cancelGPRS',
        u'opcode-connectGPRS',
        u'opcode-continueGPRS',
        u'opcode-entityReleasedGPRS',
        u'opcode-furnishChargingInformationGPRS',
        u'opcode-initialDPGPRS',
        u'opcode-releaseGPRS',
        u'opcode-eventReportGPRS',
        u'opcode-requestReportGPRSEvent',
        u'opcode-resetTimerGPRS',
        u'opcode-sendChargingInformationGPRS',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< opcode-initialDP >-----#
    opcode_initialDP = CHOICE(name=u'opcode-initialDP', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_initialDP._val = (u'local', 0)
    
    #-----< opcode-assistRequestInstructions >-----#
    opcode_assistRequestInstructions = CHOICE(name=u'opcode-assistRequestInstructions', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_assistRequestInstructions._val = (u'local', 16)
    
    #-----< opcode-establishTemporaryConnection >-----#
    opcode_establishTemporaryConnection = CHOICE(name=u'opcode-establishTemporaryConnection', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_establishTemporaryConnection._val = (u'local', 17)
    
    #-----< opcode-disconnectForwardConnection >-----#
    opcode_disconnectForwardConnection = CHOICE(name=u'opcode-disconnectForwardConnection', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_disconnectForwardConnection._val = (u'local', 18)
    
    #-----< opcode-dFCWithArgument >-----#
    opcode_dFCWithArgument = CHOICE(name=u'opcode-dFCWithArgument', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_dFCWithArgument._val = (u'local', 86)
    
    #-----< opcode-connectToResource >-----#
    opcode_connectToResource = CHOICE(name=u'opcode-connectToResource', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_connectToResource._val = (u'local', 19)
    
    #-----< opcode-connect >-----#
    opcode_connect = CHOICE(name=u'opcode-connect', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_connect._val = (u'local', 20)
    
    #-----< opcode-releaseCall >-----#
    opcode_releaseCall = CHOICE(name=u'opcode-releaseCall', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_releaseCall._val = (u'local', 22)
    
    #-----< opcode-requestReportBCSMEvent >-----#
    opcode_requestReportBCSMEvent = CHOICE(name=u'opcode-requestReportBCSMEvent', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_requestReportBCSMEvent._val = (u'local', 23)
    
    #-----< opcode-eventReportBCSM >-----#
    opcode_eventReportBCSM = CHOICE(name=u'opcode-eventReportBCSM', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_eventReportBCSM._val = (u'local', 24)
    
    #-----< opcode-collectInformation >-----#
    opcode_collectInformation = CHOICE(name=u'opcode-collectInformation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_collectInformation._val = (u'local', 27)
    
    #-----< opcode-continue >-----#
    opcode_continue = CHOICE(name=u'opcode-continue', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_continue._val = (u'local', 31)
    
    #-----< opcode-initiateCallAttempt >-----#
    opcode_initiateCallAttempt = CHOICE(name=u'opcode-initiateCallAttempt', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_initiateCallAttempt._val = (u'local', 32)
    
    #-----< opcode-resetTimer >-----#
    opcode_resetTimer = CHOICE(name=u'opcode-resetTimer', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_resetTimer._val = (u'local', 33)
    
    #-----< opcode-furnishChargingInformation >-----#
    opcode_furnishChargingInformation = CHOICE(name=u'opcode-furnishChargingInformation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_furnishChargingInformation._val = (u'local', 34)
    
    #-----< opcode-applyCharging >-----#
    opcode_applyCharging = CHOICE(name=u'opcode-applyCharging', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_applyCharging._val = (u'local', 35)
    
    #-----< opcode-applyChargingReport >-----#
    opcode_applyChargingReport = CHOICE(name=u'opcode-applyChargingReport', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_applyChargingReport._val = (u'local', 36)
    
    #-----< opcode-callGap >-----#
    opcode_callGap = CHOICE(name=u'opcode-callGap', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_callGap._val = (u'local', 41)
    
    #-----< opcode-callInformationReport >-----#
    opcode_callInformationReport = CHOICE(name=u'opcode-callInformationReport', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_callInformationReport._val = (u'local', 44)
    
    #-----< opcode-callInformationRequest >-----#
    opcode_callInformationRequest = CHOICE(name=u'opcode-callInformationRequest', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_callInformationRequest._val = (u'local', 45)
    
    #-----< opcode-sendChargingInformation >-----#
    opcode_sendChargingInformation = CHOICE(name=u'opcode-sendChargingInformation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_sendChargingInformation._val = (u'local', 46)
    
    #-----< opcode-playAnnouncement >-----#
    opcode_playAnnouncement = CHOICE(name=u'opcode-playAnnouncement', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_playAnnouncement._val = (u'local', 47)
    
    #-----< opcode-promptAndCollectUserInformation >-----#
    opcode_promptAndCollectUserInformation = CHOICE(name=u'opcode-promptAndCollectUserInformation', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_promptAndCollectUserInformation._val = (u'local', 48)
    
    #-----< opcode-specializedResourceReport >-----#
    opcode_specializedResourceReport = CHOICE(name=u'opcode-specializedResourceReport', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_specializedResourceReport._val = (u'local', 49)
    
    #-----< opcode-cancel >-----#
    opcode_cancel = CHOICE(name=u'opcode-cancel', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_cancel._val = (u'local', 53)
    
    #-----< opcode-activityTest >-----#
    opcode_activityTest = CHOICE(name=u'opcode-activityTest', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_activityTest._val = (u'local', 55)
    
    #-----< opcode-continueWithArgument >-----#
    opcode_continueWithArgument = CHOICE(name=u'opcode-continueWithArgument', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_continueWithArgument._val = (u'local', 88)
    
    #-----< opcode-disconnectLeg >-----#
    opcode_disconnectLeg = CHOICE(name=u'opcode-disconnectLeg', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_disconnectLeg._val = (u'local', 90)
    
    #-----< opcode-moveLeg >-----#
    opcode_moveLeg = CHOICE(name=u'opcode-moveLeg', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_moveLeg._val = (u'local', 93)
    
    #-----< opcode-splitLeg >-----#
    opcode_splitLeg = CHOICE(name=u'opcode-splitLeg', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_splitLeg._val = (u'local', 95)
    
    #-----< opcode-entityReleased >-----#
    opcode_entityReleased = CHOICE(name=u'opcode-entityReleased', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_entityReleased._val = (u'local', 96)
    
    #-----< opcode-playTone >-----#
    opcode_playTone = CHOICE(name=u'opcode-playTone', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_playTone._val = (u'local', 97)
    
    #-----< opcode-initialDPSMS >-----#
    opcode_initialDPSMS = CHOICE(name=u'opcode-initialDPSMS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_initialDPSMS._val = (u'local', 60)
    
    #-----< opcode-furnishChargingInformationSMS >-----#
    opcode_furnishChargingInformationSMS = CHOICE(name=u'opcode-furnishChargingInformationSMS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_furnishChargingInformationSMS._val = (u'local', 61)
    
    #-----< opcode-connectSMS >-----#
    opcode_connectSMS = CHOICE(name=u'opcode-connectSMS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_connectSMS._val = (u'local', 62)
    
    #-----< opcode-requestReportSMSEvent >-----#
    opcode_requestReportSMSEvent = CHOICE(name=u'opcode-requestReportSMSEvent', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_requestReportSMSEvent._val = (u'local', 63)
    
    #-----< opcode-eventReportSMS >-----#
    opcode_eventReportSMS = CHOICE(name=u'opcode-eventReportSMS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_eventReportSMS._val = (u'local', 64)
    
    #-----< opcode-continueSMS >-----#
    opcode_continueSMS = CHOICE(name=u'opcode-continueSMS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_continueSMS._val = (u'local', 65)
    
    #-----< opcode-releaseSMS >-----#
    opcode_releaseSMS = CHOICE(name=u'opcode-releaseSMS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_releaseSMS._val = (u'local', 66)
    
    #-----< opcode-resetTimerSMS >-----#
    opcode_resetTimerSMS = CHOICE(name=u'opcode-resetTimerSMS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_resetTimerSMS._val = (u'local', 67)
    
    #-----< opcode-activityTestGPRS >-----#
    opcode_activityTestGPRS = CHOICE(name=u'opcode-activityTestGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_activityTestGPRS._val = (u'local', 70)
    
    #-----< opcode-applyChargingGPRS >-----#
    opcode_applyChargingGPRS = CHOICE(name=u'opcode-applyChargingGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_applyChargingGPRS._val = (u'local', 71)
    
    #-----< opcode-applyChargingReportGPRS >-----#
    opcode_applyChargingReportGPRS = CHOICE(name=u'opcode-applyChargingReportGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_applyChargingReportGPRS._val = (u'local', 72)
    
    #-----< opcode-cancelGPRS >-----#
    opcode_cancelGPRS = CHOICE(name=u'opcode-cancelGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_cancelGPRS._val = (u'local', 73)
    
    #-----< opcode-connectGPRS >-----#
    opcode_connectGPRS = CHOICE(name=u'opcode-connectGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_connectGPRS._val = (u'local', 74)
    
    #-----< opcode-continueGPRS >-----#
    opcode_continueGPRS = CHOICE(name=u'opcode-continueGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_continueGPRS._val = (u'local', 75)
    
    #-----< opcode-entityReleasedGPRS >-----#
    opcode_entityReleasedGPRS = CHOICE(name=u'opcode-entityReleasedGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_entityReleasedGPRS._val = (u'local', 76)
    
    #-----< opcode-furnishChargingInformationGPRS >-----#
    opcode_furnishChargingInformationGPRS = CHOICE(name=u'opcode-furnishChargingInformationGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_furnishChargingInformationGPRS._val = (u'local', 77)
    
    #-----< opcode-initialDPGPRS >-----#
    opcode_initialDPGPRS = CHOICE(name=u'opcode-initialDPGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_initialDPGPRS._val = (u'local', 78)
    
    #-----< opcode-releaseGPRS >-----#
    opcode_releaseGPRS = CHOICE(name=u'opcode-releaseGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_releaseGPRS._val = (u'local', 79)
    
    #-----< opcode-eventReportGPRS >-----#
    opcode_eventReportGPRS = CHOICE(name=u'opcode-eventReportGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_eventReportGPRS._val = (u'local', 80)
    
    #-----< opcode-requestReportGPRSEvent >-----#
    opcode_requestReportGPRSEvent = CHOICE(name=u'opcode-requestReportGPRSEvent', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_requestReportGPRSEvent._val = (u'local', 81)
    
    #-----< opcode-resetTimerGPRS >-----#
    opcode_resetTimerGPRS = CHOICE(name=u'opcode-resetTimerGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_resetTimerGPRS._val = (u'local', 82)
    
    #-----< opcode-sendChargingInformationGPRS >-----#
    opcode_sendChargingInformationGPRS = CHOICE(name=u'opcode-sendChargingInformationGPRS', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    opcode_sendChargingInformationGPRS._val = (u'local', 83)
    
    _all_ = [
        opcode_initialDP,
        opcode_assistRequestInstructions,
        opcode_establishTemporaryConnection,
        opcode_disconnectForwardConnection,
        opcode_dFCWithArgument,
        opcode_connectToResource,
        opcode_connect,
        opcode_releaseCall,
        opcode_requestReportBCSMEvent,
        opcode_eventReportBCSM,
        opcode_collectInformation,
        opcode_continue,
        opcode_initiateCallAttempt,
        opcode_resetTimer,
        opcode_furnishChargingInformation,
        opcode_applyCharging,
        opcode_applyChargingReport,
        opcode_callGap,
        opcode_callInformationReport,
        opcode_callInformationRequest,
        opcode_sendChargingInformation,
        opcode_playAnnouncement,
        opcode_promptAndCollectUserInformation,
        opcode_specializedResourceReport,
        opcode_cancel,
        opcode_activityTest,
        opcode_continueWithArgument,
        opcode_disconnectLeg,
        opcode_moveLeg,
        opcode_splitLeg,
        opcode_entityReleased,
        opcode_playTone,
        opcode_initialDPSMS,
        opcode_furnishChargingInformationSMS,
        opcode_connectSMS,
        opcode_requestReportSMSEvent,
        opcode_eventReportSMS,
        opcode_continueSMS,
        opcode_releaseSMS,
        opcode_resetTimerSMS,
        opcode_activityTestGPRS,
        opcode_applyChargingGPRS,
        opcode_applyChargingReportGPRS,
        opcode_cancelGPRS,
        opcode_connectGPRS,
        opcode_continueGPRS,
        opcode_entityReleasedGPRS,
        opcode_furnishChargingInformationGPRS,
        opcode_initialDPGPRS,
        opcode_releaseGPRS,
        opcode_eventReportGPRS,
        opcode_requestReportGPRSEvent,
        opcode_resetTimerGPRS,
        opcode_sendChargingInformationGPRS,
    ]

class CAP_errorcodes:

    _name_  = u'CAP-errorcodes'
    _oid_   = [0, 4, 0, 0, 1, 3, 57, 7]
    
    _obj_ = [
        u'errcode-canceled',
        u'errcode-cancelFailed',
        u'errcode-eTCFailed',
        u'errcode-improperCallerResponse',
        u'errcode-missingCustomerRecord',
        u'errcode-missingParameter',
        u'errcode-parameterOutOfRange',
        u'errcode-requestedInfoError',
        u'errcode-systemFailure',
        u'errcode-taskRefused',
        u'errcode-unavailableResource',
        u'errcode-unexpectedComponentSequence',
        u'errcode-unexpectedDataValue',
        u'errcode-unexpectedParameter',
        u'errcode-unknownLegID',
        u'errcode-unknownPDPID',
        u'errcode-unknownCSID',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'errcode-canceled',
        u'errcode-cancelFailed',
        u'errcode-eTCFailed',
        u'errcode-improperCallerResponse',
        u'errcode-missingCustomerRecord',
        u'errcode-missingParameter',
        u'errcode-parameterOutOfRange',
        u'errcode-requestedInfoError',
        u'errcode-systemFailure',
        u'errcode-taskRefused',
        u'errcode-unavailableResource',
        u'errcode-unexpectedComponentSequence',
        u'errcode-unexpectedDataValue',
        u'errcode-unexpectedParameter',
        u'errcode-unknownLegID',
        u'errcode-unknownPDPID',
        u'errcode-unknownCSID',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< errcode-canceled >-----#
    errcode_canceled = CHOICE(name=u'errcode-canceled', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_canceled._val = (u'local', 0)
    
    #-----< errcode-cancelFailed >-----#
    errcode_cancelFailed = CHOICE(name=u'errcode-cancelFailed', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_cancelFailed._val = (u'local', 1)
    
    #-----< errcode-eTCFailed >-----#
    errcode_eTCFailed = CHOICE(name=u'errcode-eTCFailed', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_eTCFailed._val = (u'local', 3)
    
    #-----< errcode-improperCallerResponse >-----#
    errcode_improperCallerResponse = CHOICE(name=u'errcode-improperCallerResponse', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_improperCallerResponse._val = (u'local', 4)
    
    #-----< errcode-missingCustomerRecord >-----#
    errcode_missingCustomerRecord = CHOICE(name=u'errcode-missingCustomerRecord', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_missingCustomerRecord._val = (u'local', 6)
    
    #-----< errcode-missingParameter >-----#
    errcode_missingParameter = CHOICE(name=u'errcode-missingParameter', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_missingParameter._val = (u'local', 7)
    
    #-----< errcode-parameterOutOfRange >-----#
    errcode_parameterOutOfRange = CHOICE(name=u'errcode-parameterOutOfRange', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_parameterOutOfRange._val = (u'local', 8)
    
    #-----< errcode-requestedInfoError >-----#
    errcode_requestedInfoError = CHOICE(name=u'errcode-requestedInfoError', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_requestedInfoError._val = (u'local', 10)
    
    #-----< errcode-systemFailure >-----#
    errcode_systemFailure = CHOICE(name=u'errcode-systemFailure', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_systemFailure._val = (u'local', 11)
    
    #-----< errcode-taskRefused >-----#
    errcode_taskRefused = CHOICE(name=u'errcode-taskRefused', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_taskRefused._val = (u'local', 12)
    
    #-----< errcode-unavailableResource >-----#
    errcode_unavailableResource = CHOICE(name=u'errcode-unavailableResource', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_unavailableResource._val = (u'local', 13)
    
    #-----< errcode-unexpectedComponentSequence >-----#
    errcode_unexpectedComponentSequence = CHOICE(name=u'errcode-unexpectedComponentSequence', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_unexpectedComponentSequence._val = (u'local', 14)
    
    #-----< errcode-unexpectedDataValue >-----#
    errcode_unexpectedDataValue = CHOICE(name=u'errcode-unexpectedDataValue', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_unexpectedDataValue._val = (u'local', 15)
    
    #-----< errcode-unexpectedParameter >-----#
    errcode_unexpectedParameter = CHOICE(name=u'errcode-unexpectedParameter', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_unexpectedParameter._val = (u'local', 16)
    
    #-----< errcode-unknownLegID >-----#
    errcode_unknownLegID = CHOICE(name=u'errcode-unknownLegID', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_unknownLegID._val = (u'local', 17)
    
    #-----< errcode-unknownPDPID >-----#
    errcode_unknownPDPID = CHOICE(name=u'errcode-unknownPDPID', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_unknownPDPID._val = (u'local', 50)
    
    #-----< errcode-unknownCSID >-----#
    errcode_unknownCSID = CHOICE(name=u'errcode-unknownCSID', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'Code')))
    errcode_unknownCSID._val = (u'local', 51)
    
    _all_ = [
        errcode_canceled,
        errcode_cancelFailed,
        errcode_eTCFailed,
        errcode_improperCallerResponse,
        errcode_missingCustomerRecord,
        errcode_missingParameter,
        errcode_parameterOutOfRange,
        errcode_requestedInfoError,
        errcode_systemFailure,
        errcode_taskRefused,
        errcode_unavailableResource,
        errcode_unexpectedComponentSequence,
        errcode_unexpectedDataValue,
        errcode_unexpectedParameter,
        errcode_unknownLegID,
        errcode_unknownPDPID,
        errcode_unknownCSID,
    ]

class CAP_errortypes:

    _name_  = u'CAP-errortypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 51, 7]
    
    _obj_ = [
        u'canceled',
        u'cancelFailed',
        u'eTCFailed',
        u'improperCallerResponse',
        u'missingCustomerRecord',
        u'missingParameter',
        u'parameterOutOfRange',
        u'requestedInfoError',
        u'systemFailure',
        u'taskRefused',
        u'unavailableResource',
        u'unexpectedComponentSequence',
        u'unexpectedDataValue',
        u'unexpectedParameter',
        u'unknownLegID',
        u'unknownCSID',
        u'unknownPDPID',
        ]
    _type_ = [
        ]
    _set_ = [
        ]
    _val_ = [
        u'canceled',
        u'cancelFailed',
        u'eTCFailed',
        u'improperCallerResponse',
        u'missingCustomerRecord',
        u'missingParameter',
        u'parameterOutOfRange',
        u'requestedInfoError',
        u'systemFailure',
        u'taskRefused',
        u'unavailableResource',
        u'unexpectedComponentSequence',
        u'unexpectedDataValue',
        u'unexpectedParameter',
        u'unknownLegID',
        u'unknownCSID',
        u'unknownPDPID',
        ]
    _class_ = [
        u'canceled',
        u'cancelFailed',
        u'eTCFailed',
        u'improperCallerResponse',
        u'missingCustomerRecord',
        u'missingParameter',
        u'parameterOutOfRange',
        u'requestedInfoError',
        u'systemFailure',
        u'taskRefused',
        u'unavailableResource',
        u'unexpectedComponentSequence',
        u'unexpectedDataValue',
        u'unexpectedParameter',
        u'unknownLegID',
        u'unknownCSID',
        u'unknownPDPID',
        ]
    _param_ = [
        ]
    
    #-----< canceled >-----#
    canceled = CLASS(name=u'canceled', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    canceled._val = dict([(u'errorCode', (u'local', 0))])
    
    #-----< cancelFailed >-----#
    cancelFailed = CLASS(name=u'cancelFailed', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _cancelFailed_val_ParameterType = SEQ(name=u'ParameterType', mode=MODE_TYPE)
    __cancelFailed_val_ParameterType_problem = ENUM(name=u'problem', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __cancelFailed_val_ParameterType_problem._cont = ASN1Dict([(u'unknownOperation', 0), (u'tooLate', 1), (u'operationNotCancellable', 2)])
    __cancelFailed_val_ParameterType_problem._ext = None
    __cancelFailed_val_ParameterType_operation = INT(name=u'operation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'InvokeID')))
    _cancelFailed_val_ParameterType._cont = ASN1Dict([
        (u'problem', __cancelFailed_val_ParameterType_problem),
        (u'operation', __cancelFailed_val_ParameterType_operation),
        ])
    _cancelFailed_val_ParameterType._ext = []
    cancelFailed._val = dict([(u'ParameterType', _cancelFailed_val_ParameterType), (u'errorCode', (u'local', 1))])
    
    #-----< eTCFailed >-----#
    eTCFailed = CLASS(name=u'eTCFailed', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    eTCFailed._val = dict([(u'errorCode', (u'local', 3))])
    
    #-----< improperCallerResponse >-----#
    improperCallerResponse = CLASS(name=u'improperCallerResponse', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    improperCallerResponse._val = dict([(u'errorCode', (u'local', 4))])
    
    #-----< missingCustomerRecord >-----#
    missingCustomerRecord = CLASS(name=u'missingCustomerRecord', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    missingCustomerRecord._val = dict([(u'errorCode', (u'local', 6))])
    
    #-----< missingParameter >-----#
    missingParameter = CLASS(name=u'missingParameter', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    missingParameter._val = dict([(u'errorCode', (u'local', 7))])
    
    #-----< parameterOutOfRange >-----#
    parameterOutOfRange = CLASS(name=u'parameterOutOfRange', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    parameterOutOfRange._val = dict([(u'errorCode', (u'local', 8))])
    
    #-----< requestedInfoError >-----#
    requestedInfoError = CLASS(name=u'requestedInfoError', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _requestedInfoError_val_ParameterType = ENUM(name=u'ParameterType', mode=MODE_TYPE)
    _requestedInfoError_val_ParameterType._cont = ASN1Dict([(u'unknownRequestedInfo', 1), (u'requestedInfoNotAvailable', 2)])
    _requestedInfoError_val_ParameterType._ext = None
    requestedInfoError._val = dict([(u'ParameterType', _requestedInfoError_val_ParameterType), (u'errorCode', (u'local', 10))])
    
    #-----< systemFailure >-----#
    systemFailure = CLASS(name=u'systemFailure', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _systemFailure_val_ParameterType = ENUM(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('CAP-datatypes', 'UnavailableNetworkResource')))
    systemFailure._val = dict([(u'ParameterType', _systemFailure_val_ParameterType), (u'errorCode', (u'local', 11))])
    
    #-----< taskRefused >-----#
    taskRefused = CLASS(name=u'taskRefused', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    _taskRefused_val_ParameterType = ENUM(name=u'ParameterType', mode=MODE_TYPE)
    _taskRefused_val_ParameterType._cont = ASN1Dict([(u'generic', 0), (u'unobtainable', 1), (u'congestion', 2)])
    _taskRefused_val_ParameterType._ext = None
    taskRefused._val = dict([(u'ParameterType', _taskRefused_val_ParameterType), (u'errorCode', (u'local', 12))])
    
    #-----< unavailableResource >-----#
    unavailableResource = CLASS(name=u'unavailableResource', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unavailableResource._val = dict([(u'errorCode', (u'local', 13))])
    
    #-----< unexpectedComponentSequence >-----#
    unexpectedComponentSequence = CLASS(name=u'unexpectedComponentSequence', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unexpectedComponentSequence._val = dict([(u'errorCode', (u'local', 14))])
    
    #-----< unexpectedDataValue >-----#
    unexpectedDataValue = CLASS(name=u'unexpectedDataValue', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unexpectedDataValue._val = dict([(u'errorCode', (u'local', 15))])
    
    #-----< unexpectedParameter >-----#
    unexpectedParameter = CLASS(name=u'unexpectedParameter', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unexpectedParameter._val = dict([(u'errorCode', (u'local', 16))])
    
    #-----< unknownLegID >-----#
    unknownLegID = CLASS(name=u'unknownLegID', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unknownLegID._val = dict([(u'errorCode', (u'local', 17))])
    
    #-----< unknownCSID >-----#
    unknownCSID = CLASS(name=u'unknownCSID', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unknownCSID._val = dict([(u'errorCode', (u'local', 51))])
    
    #-----< unknownPDPID >-----#
    unknownPDPID = CLASS(name=u'unknownPDPID', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ERROR')))
    unknownPDPID._val = dict([(u'errorCode', (u'local', 50))])
    
    _all_ = [
        canceled,
        cancelFailed,
        __cancelFailed_val_ParameterType_problem,
        __cancelFailed_val_ParameterType_operation,
        _cancelFailed_val_ParameterType,
        eTCFailed,
        improperCallerResponse,
        missingCustomerRecord,
        missingParameter,
        parameterOutOfRange,
        requestedInfoError,
        _requestedInfoError_val_ParameterType,
        systemFailure,
        _systemFailure_val_ParameterType,
        taskRefused,
        _taskRefused_val_ParameterType,
        unavailableResource,
        unexpectedComponentSequence,
        unexpectedDataValue,
        unexpectedParameter,
        unknownLegID,
        unknownCSID,
        unknownPDPID,
    ]

class CAP_datatypes:

    _name_  = u'CAP-datatypes'
    _oid_   = [0, 4, 0, 0, 1, 3, 52, 7]
    
    _obj_ = [
        u'AccessPointName',
        u'AChBillingChargingCharacteristics',
        u'AChChargingAddress',
        u'AdditionalCallingPartyNumber',
        u'AlertingPattern',
        u'AOCBeforeAnswer',
        u'AOCGPRS',
        u'AOCSubsequent',
        u'AppendFreeFormatData',
        u'ApplicationTimer',
        u'AssistingSSPIPRoutingAddress',
        u'AudibleIndicator',
        u'BackwardServiceInteractionInd',
        u'BasicGapCriteria',
        u'BCSMEvent',
        u'BCSM-Failure',
        u'BearerCapability',
        u'Burst',
        u'BurstList',
        u'CAI-GSM0224',
        u'CalledPartyBCDNumber',
        u'CalledPartyNumber',
        u'CallingPartyNumber',
        u'CallResult',
        u'CallSegmentFailure',
        u'CallSegmentID',
        u'CallSegmentToCancel',
        u'CAMEL-AChBillingChargingCharacteristics',
        u'CAMEL-CallResult',
        u'CAMEL-FCIBillingChargingCharacteristics',
        u'CAMEL-FCIGPRSBillingChargingCharacteristics',
        u'CAMEL-FCISMSBillingChargingCharacteristics',
        u'CAMEL-SCIBillingChargingCharacteristics',
        u'CAMEL-SCIBillingChargingCharacteristicsAlt',
        u'CAMEL-SCIGPRSBillingChargingCharacteristics',
        u'Carrier',
        u'Cause',
        u'CGEncountered',
        u'ChangeOfPositionControlInfo',
        u'ChangeOfLocation',
        u'ChangeOfLocationAlt',
        u'ChargeIndicator',
        u'ChargeNumber',
        u'ChargingCharacteristics',
        u'ChargingResult',
        u'ChargingRollOver',
        u'CollectedDigits',
        u'CollectedInfo',
        u'ConnectedNumberTreatmentInd',
        u'ControlType',
        u'CompoundCriteria',
        u'CorrelationID',
        u'DateAndTime',
        u'DestinationRoutingAddress',
        u'Digits',
        u'DpSpecificCriteria',
        u'DpSpecificCriteriaAlt',
        u'DpSpecificInfoAlt',
        u'ElapsedTime',
        u'ElapsedTimeRollOver',
        u'EndUserAddress',
        u'ErrorTreatment',
        u'EventSpecificInformationBCSM',
        u'EventSpecificInformationSMS',
        u'EventTypeBCSM',
        u'EventTypeSMS',
        u'Extensions',
        u'ExtensionField',
        u'FCIBillingChargingCharacteristics',
        u'FCIGPRSBillingChargingCharacteristics',
        u'FCISMSBillingChargingCharacteristics',
        u'ForwardServiceInteractionInd',
        u'GapCriteria',
        u'GapIndicators',
        u'GapOnService',
        u'GapTreatment',
        u'GenericNumber',
        u'GenericNumbers',
        u'GPRS-QoS',
        u'GPRS-QoS-Extension',
        u'GPRSCause',
        u'GPRSEvent',
        u'GPRSEventSpecificInformation',
        u'GPRSEventType',
        u'InbandInfo',
        u'InformationToSend',
        u'InitiatingEntity',
        u'InitiatorOfServiceChange',
        u'InvokeID',
        u'IPRoutingAddress',
        u'IPSSPCapabilities',
        u'LegOrCallSegment',
        u'LegType',
        u'leg1',
        u'leg2',
        u'LocationInformationGPRS',
        u'UserCSGInformation',
        u'LocationNumber',
        u'LowLayerCompatibility',
        u'MessageID',
        u'MetDPCriteriaList',
        u'MetDPCriterion',
        u'MetDPCriterionAlt',
        u'MidCallControlInfo',
        u'MonitorMode',
        u'MO-SMSCause',
        u'MT-SMSCause',
        u'NAOliInfo',
        u'NatureOfServiceChange',
        u'NumberOfDigits',
        u'OCSIApplicable',
        u'OriginalCalledPartyID',
        u'PDPID',
        u'PDPInitiationType',
        u'QualityOfService',
        u'ReceivingSideID',
        u'RedirectingPartyID',
        u'RequestedInformationList',
        u'RequestedInformationTypeList',
        u'RequestedInformation',
        u'RequestedInformationType',
        u'RequestedInformationValue',
        u'RPCause',
        u'ScfID',
        u'SCIBillingChargingCharacteristics',
        u'SCIGPRSBillingChargingCharacteristics',
        u'SendingSideID',
        u'ServiceInteractionIndicatorsTwo',
        u'SGSNCapabilities',
        u'SMS-AddressString',
        u'maxSMS-AddressStringLength',
        u'SMSEvent',
        u'TariffSwitchInterval',
        u'TimeAndTimezone',
        u'TimeIfNoTariffSwitch',
        u'TimeIfTariffSwitch',
        u'TimeInformation',
        u'TimerID',
        u'TimerValue',
        u'Tone',
        u'TPDataCodingScheme',
        u'TPProtocolIdentifier',
        u'TPShortMessageSpecificInfo',
        u'TPValidityPeriod',
        u'TransferredVolume',
        u'TransferredVolumeRollOver',
        u'UnavailableNetworkResource',
        u'VariablePart',
        u'numOfInfoItems',
        ]
    _type_ = [
        u'AccessPointName',
        u'AChBillingChargingCharacteristics',
        u'AChChargingAddress',
        u'AdditionalCallingPartyNumber',
        u'AlertingPattern',
        u'AOCBeforeAnswer',
        u'AOCGPRS',
        u'AOCSubsequent',
        u'AppendFreeFormatData',
        u'ApplicationTimer',
        u'AssistingSSPIPRoutingAddress',
        u'AudibleIndicator',
        u'BackwardServiceInteractionInd',
        u'BasicGapCriteria',
        u'BCSMEvent',
        u'BCSM-Failure',
        u'BearerCapability',
        u'Burst',
        u'BurstList',
        u'CAI-GSM0224',
        u'CalledPartyBCDNumber',
        u'CalledPartyNumber',
        u'CallingPartyNumber',
        u'CallResult',
        u'CallSegmentFailure',
        u'CallSegmentID',
        u'CallSegmentToCancel',
        u'CAMEL-AChBillingChargingCharacteristics',
        u'CAMEL-CallResult',
        u'CAMEL-FCIBillingChargingCharacteristics',
        u'CAMEL-FCIGPRSBillingChargingCharacteristics',
        u'CAMEL-FCISMSBillingChargingCharacteristics',
        u'CAMEL-SCIBillingChargingCharacteristics',
        u'CAMEL-SCIBillingChargingCharacteristicsAlt',
        u'CAMEL-SCIGPRSBillingChargingCharacteristics',
        u'Carrier',
        u'Cause',
        u'CGEncountered',
        u'ChangeOfPositionControlInfo',
        u'ChangeOfLocation',
        u'ChangeOfLocationAlt',
        u'ChargeIndicator',
        u'ChargeNumber',
        u'ChargingCharacteristics',
        u'ChargingResult',
        u'ChargingRollOver',
        u'CollectedDigits',
        u'CollectedInfo',
        u'ConnectedNumberTreatmentInd',
        u'ControlType',
        u'CompoundCriteria',
        u'CorrelationID',
        u'DateAndTime',
        u'DestinationRoutingAddress',
        u'Digits',
        u'DpSpecificCriteria',
        u'DpSpecificCriteriaAlt',
        u'DpSpecificInfoAlt',
        u'ElapsedTime',
        u'ElapsedTimeRollOver',
        u'EndUserAddress',
        u'ErrorTreatment',
        u'EventSpecificInformationBCSM',
        u'EventSpecificInformationSMS',
        u'EventTypeBCSM',
        u'EventTypeSMS',
        u'Extensions',
        u'ExtensionField',
        u'FCIBillingChargingCharacteristics',
        u'FCIGPRSBillingChargingCharacteristics',
        u'FCISMSBillingChargingCharacteristics',
        u'ForwardServiceInteractionInd',
        u'GapCriteria',
        u'GapIndicators',
        u'GapOnService',
        u'GapTreatment',
        u'GenericNumber',
        u'GenericNumbers',
        u'GPRS-QoS',
        u'GPRS-QoS-Extension',
        u'GPRSCause',
        u'GPRSEvent',
        u'GPRSEventSpecificInformation',
        u'GPRSEventType',
        u'InbandInfo',
        u'InformationToSend',
        u'InitiatingEntity',
        u'InitiatorOfServiceChange',
        u'InvokeID',
        u'IPRoutingAddress',
        u'IPSSPCapabilities',
        u'LegOrCallSegment',
        u'LegType',
        u'LocationInformationGPRS',
        u'UserCSGInformation',
        u'LocationNumber',
        u'LowLayerCompatibility',
        u'MessageID',
        u'MetDPCriteriaList',
        u'MetDPCriterion',
        u'MetDPCriterionAlt',
        u'MidCallControlInfo',
        u'MonitorMode',
        u'MO-SMSCause',
        u'MT-SMSCause',
        u'NAOliInfo',
        u'NatureOfServiceChange',
        u'NumberOfDigits',
        u'OCSIApplicable',
        u'OriginalCalledPartyID',
        u'PDPID',
        u'PDPInitiationType',
        u'QualityOfService',
        u'ReceivingSideID',
        u'RedirectingPartyID',
        u'RequestedInformationList',
        u'RequestedInformationTypeList',
        u'RequestedInformation',
        u'RequestedInformationType',
        u'RequestedInformationValue',
        u'RPCause',
        u'ScfID',
        u'SCIBillingChargingCharacteristics',
        u'SCIGPRSBillingChargingCharacteristics',
        u'SendingSideID',
        u'ServiceInteractionIndicatorsTwo',
        u'SGSNCapabilities',
        u'SMS-AddressString',
        u'SMSEvent',
        u'TariffSwitchInterval',
        u'TimeAndTimezone',
        u'TimeIfNoTariffSwitch',
        u'TimeIfTariffSwitch',
        u'TimeInformation',
        u'TimerID',
        u'TimerValue',
        u'Tone',
        u'TPDataCodingScheme',
        u'TPProtocolIdentifier',
        u'TPShortMessageSpecificInfo',
        u'TPValidityPeriod',
        u'TransferredVolume',
        u'TransferredVolumeRollOver',
        u'UnavailableNetworkResource',
        u'VariablePart',
        ]
    _set_ = [
        ]
    _val_ = [
        u'leg1',
        u'leg2',
        u'maxSMS-AddressStringLength',
        u'numOfInfoItems',
        ]
    _class_ = [
        ]
    _param_ = [
        u'AccessPointName',
        u'AChBillingChargingCharacteristics',
        u'AChChargingAddress',
        u'AdditionalCallingPartyNumber',
        u'AssistingSSPIPRoutingAddress',
        u'BasicGapCriteria',
        u'BCSMEvent',
        u'BCSM-Failure',
        u'BearerCapability',
        u'CalledPartyBCDNumber',
        u'CalledPartyNumber',
        u'CallingPartyNumber',
        u'CallResult',
        u'CallSegmentFailure',
        u'CallSegmentID',
        u'CallSegmentToCancel',
        u'CAMEL-AChBillingChargingCharacteristics',
        u'CAMEL-CallResult',
        u'CAMEL-FCIBillingChargingCharacteristics',
        u'CAMEL-FCIGPRSBillingChargingCharacteristics',
        u'CAMEL-FCISMSBillingChargingCharacteristics',
        u'Carrier',
        u'Cause',
        u'ChangeOfPositionControlInfo',
        u'ChangeOfLocation',
        u'ChangeOfLocationAlt',
        u'ChargeNumber',
        u'CompoundCriteria',
        u'CorrelationID',
        u'DestinationRoutingAddress',
        u'Digits',
        u'DpSpecificCriteria',
        u'DpSpecificCriteriaAlt',
        u'DpSpecificInfoAlt',
        u'EndUserAddress',
        u'EventSpecificInformationBCSM',
        u'Extensions',
        u'FCIBillingChargingCharacteristics',
        u'FCIGPRSBillingChargingCharacteristics',
        u'FCISMSBillingChargingCharacteristics',
        u'GapCriteria',
        u'GapTreatment',
        u'GenericNumber',
        u'GenericNumbers',
        u'GPRSCause',
        u'GPRSEventSpecificInformation',
        u'InbandInfo',
        u'InformationToSend',
        u'IPRoutingAddress',
        u'IPSSPCapabilities',
        u'LegOrCallSegment',
        u'LocationNumber',
        u'LowLayerCompatibility',
        u'MessageID',
        u'MetDPCriteriaList',
        u'MetDPCriterion',
        u'MetDPCriterionAlt',
        u'OriginalCalledPartyID',
        u'RedirectingPartyID',
        u'RequestedInformationList',
        u'RequestedInformation',
        u'RequestedInformationValue',
        u'ScfID',
        u'SCIBillingChargingCharacteristics',
        u'SCIGPRSBillingChargingCharacteristics',
        u'TimeAndTimezone',
        u'VariablePart',
        ]
    
    #-----< AccessPointName >-----#
    AccessPointName = OCT_STR(name=u'AccessPointName', mode=MODE_TYPE, param=True)
    
    #-----< AChBillingChargingCharacteristics >-----#
    AChBillingChargingCharacteristics = OCT_STR(name=u'AChBillingChargingCharacteristics', mode=MODE_TYPE, param=True)
    
    #-----< AChChargingAddress >-----#
    AChChargingAddress = CHOICE(name=u'AChChargingAddress', mode=MODE_TYPE, param=True)
    
    #-----< AdditionalCallingPartyNumber >-----#
    AdditionalCallingPartyNumber = OCT_STR(name=u'AdditionalCallingPartyNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CAP-datatypes', 'Digits')), param=True)
    
    #-----< AlertingPattern >-----#
    AlertingPattern = OCT_STR(name=u'AlertingPattern', mode=MODE_TYPE)
    AlertingPattern._const_sz = ASN1Set(rv=[3], rr=[], ev=None, er=[])
    
    #-----< AOCBeforeAnswer >-----#
    AOCBeforeAnswer = SEQ(name=u'AOCBeforeAnswer', mode=MODE_TYPE)
    _AOCBeforeAnswer_aOCInitial = SEQ(name=u'aOCInitial', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'CAI-GSM0224')))
    _AOCBeforeAnswer_aOCSubsequent = SEQ(name=u'aOCSubsequent', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'AOCSubsequent')), opt=True)
    AOCBeforeAnswer._cont = ASN1Dict([
        (u'aOCInitial', _AOCBeforeAnswer_aOCInitial),
        (u'aOCSubsequent', _AOCBeforeAnswer_aOCSubsequent),
        ])
    AOCBeforeAnswer._ext = None
    
    #-----< AOCGPRS >-----#
    AOCGPRS = SEQ(name=u'AOCGPRS', mode=MODE_TYPE)
    _AOCGPRS_aOCInitial = SEQ(name=u'aOCInitial', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'CAI-GSM0224')))
    _AOCGPRS_aOCSubsequent = SEQ(name=u'aOCSubsequent', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'AOCSubsequent')), opt=True)
    AOCGPRS._cont = ASN1Dict([
        (u'aOCInitial', _AOCGPRS_aOCInitial),
        (u'aOCSubsequent', _AOCGPRS_aOCSubsequent),
        ])
    AOCGPRS._ext = None
    
    #-----< AOCSubsequent >-----#
    AOCSubsequent = SEQ(name=u'AOCSubsequent', mode=MODE_TYPE)
    _AOCSubsequent_cAI_GSM0224 = SEQ(name=u'cAI-GSM0224', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'CAI-GSM0224')))
    _AOCSubsequent_tariffSwitchInterval = INT(name=u'tariffSwitchInterval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _AOCSubsequent_tariffSwitchInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=86400)], ev=None, er=[])
    AOCSubsequent._cont = ASN1Dict([
        (u'cAI-GSM0224', _AOCSubsequent_cAI_GSM0224),
        (u'tariffSwitchInterval', _AOCSubsequent_tariffSwitchInterval),
        ])
    AOCSubsequent._ext = None
    
    #-----< AppendFreeFormatData >-----#
    AppendFreeFormatData = ENUM(name=u'AppendFreeFormatData', mode=MODE_TYPE)
    AppendFreeFormatData._cont = ASN1Dict([(u'overwrite', 0), (u'append', 1)])
    AppendFreeFormatData._ext = None
    
    #-----< ApplicationTimer >-----#
    ApplicationTimer = INT(name=u'ApplicationTimer', mode=MODE_TYPE)
    ApplicationTimer._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=2047)], ev=None, er=[])
    
    #-----< AssistingSSPIPRoutingAddress >-----#
    AssistingSSPIPRoutingAddress = OCT_STR(name=u'AssistingSSPIPRoutingAddress', mode=MODE_TYPE, typeref=ASN1RefType(('CAP-datatypes', 'Digits')), param=True)
    
    #-----< AudibleIndicator >-----#
    AudibleIndicator = CHOICE(name=u'AudibleIndicator', mode=MODE_TYPE)
    _AudibleIndicator_tone = BOOL(name=u'tone', mode=MODE_TYPE)
    _AudibleIndicator_burstList = SEQ(name=u'burstList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'BurstList')))
    AudibleIndicator._cont = ASN1Dict([
        (u'tone', _AudibleIndicator_tone),
        (u'burstList', _AudibleIndicator_burstList),
        ])
    AudibleIndicator._ext = None
    
    #-----< BackwardServiceInteractionInd >-----#
    BackwardServiceInteractionInd = SEQ(name=u'BackwardServiceInteractionInd', mode=MODE_TYPE)
    _BackwardServiceInteractionInd_conferenceTreatmentIndicator = OCT_STR(name=u'conferenceTreatmentIndicator', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _BackwardServiceInteractionInd_conferenceTreatmentIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _BackwardServiceInteractionInd_callCompletionTreatmentIndicator = OCT_STR(name=u'callCompletionTreatmentIndicator', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _BackwardServiceInteractionInd_callCompletionTreatmentIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    BackwardServiceInteractionInd._cont = ASN1Dict([
        (u'conferenceTreatmentIndicator', _BackwardServiceInteractionInd_conferenceTreatmentIndicator),
        (u'callCompletionTreatmentIndicator', _BackwardServiceInteractionInd_callCompletionTreatmentIndicator),
        ])
    BackwardServiceInteractionInd._ext = []
    
    #-----< BasicGapCriteria >-----#
    BasicGapCriteria = CHOICE(name=u'BasicGapCriteria', mode=MODE_TYPE, param=True)
    
    #-----< BCSMEvent >-----#
    BCSMEvent = SEQ(name=u'BCSMEvent', mode=MODE_TYPE, param=True)
    
    #-----< BCSM-Failure >-----#
    BCSM_Failure = SEQ(name=u'BCSM-Failure', mode=MODE_TYPE, param=True)
    
    #-----< BearerCapability >-----#
    BearerCapability = CHOICE(name=u'BearerCapability', mode=MODE_TYPE, param=True)
    
    #-----< Burst >-----#
    Burst = SEQ(name=u'Burst', mode=MODE_TYPE)
    _Burst_numberOfBursts = INT(name=u'numberOfBursts', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=1)
    _Burst_numberOfBursts._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    _Burst_burstInterval = INT(name=u'burstInterval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=2)
    _Burst_burstInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1200)], ev=None, er=[])
    _Burst_numberOfTonesInBurst = INT(name=u'numberOfTonesInBurst', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=3)
    _Burst_numberOfTonesInBurst._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=3)], ev=None, er=[])
    _Burst_toneDuration = INT(name=u'toneDuration', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=2)
    _Burst_toneDuration._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    _Burst_toneInterval = INT(name=u'toneInterval', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=2)
    _Burst_toneInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=None, er=[])
    Burst._cont = ASN1Dict([
        (u'numberOfBursts', _Burst_numberOfBursts),
        (u'burstInterval', _Burst_burstInterval),
        (u'numberOfTonesInBurst', _Burst_numberOfTonesInBurst),
        (u'toneDuration', _Burst_toneDuration),
        (u'toneInterval', _Burst_toneInterval),
        ])
    Burst._ext = []
    
    #-----< BurstList >-----#
    BurstList = SEQ(name=u'BurstList', mode=MODE_TYPE)
    _BurstList_warningPeriod = INT(name=u'warningPeriod', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=30)
    _BurstList_warningPeriod._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=1200)], ev=None, er=[])
    _BurstList_bursts = SEQ(name=u'bursts', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'Burst')))
    BurstList._cont = ASN1Dict([
        (u'warningPeriod', _BurstList_warningPeriod),
        (u'bursts', _BurstList_bursts),
        ])
    BurstList._ext = []
    
    #-----< CAI-GSM0224 >-----#
    CAI_GSM0224 = SEQ(name=u'CAI-GSM0224', mode=MODE_TYPE)
    _CAI_GSM0224_e1 = INT(name=u'e1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CAI_GSM0224_e1._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _CAI_GSM0224_e2 = INT(name=u'e2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CAI_GSM0224_e2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _CAI_GSM0224_e3 = INT(name=u'e3', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CAI_GSM0224_e3._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _CAI_GSM0224_e4 = INT(name=u'e4', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CAI_GSM0224_e4._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _CAI_GSM0224_e5 = INT(name=u'e5', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CAI_GSM0224_e5._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _CAI_GSM0224_e6 = INT(name=u'e6', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CAI_GSM0224_e6._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    _CAI_GSM0224_e7 = INT(name=u'e7', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CAI_GSM0224_e7._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=8191)], ev=None, er=[])
    CAI_GSM0224._cont = ASN1Dict([
        (u'e1', _CAI_GSM0224_e1),
        (u'e2', _CAI_GSM0224_e2),
        (u'e3', _CAI_GSM0224_e3),
        (u'e4', _CAI_GSM0224_e4),
        (u'e5', _CAI_GSM0224_e5),
        (u'e6', _CAI_GSM0224_e6),
        (u'e7', _CAI_GSM0224_e7),
        ])
    CAI_GSM0224._ext = None
    
    #-----< CalledPartyBCDNumber >-----#
    CalledPartyBCDNumber = OCT_STR(name=u'CalledPartyBCDNumber', mode=MODE_TYPE, param=True)
    
    #-----< CalledPartyNumber >-----#
    CalledPartyNumber = OCT_STR(name=u'CalledPartyNumber', mode=MODE_TYPE, param=True)
    
    #-----< CallingPartyNumber >-----#
    CallingPartyNumber = OCT_STR(name=u'CallingPartyNumber', mode=MODE_TYPE, param=True)
    
    #-----< CallResult >-----#
    CallResult = OCT_STR(name=u'CallResult', mode=MODE_TYPE, param=True)
    
    #-----< CallSegmentFailure >-----#
    CallSegmentFailure = SEQ(name=u'CallSegmentFailure', mode=MODE_TYPE, param=True)
    
    #-----< CallSegmentID >-----#
    CallSegmentID = INT(name=u'CallSegmentID', mode=MODE_TYPE, param=True)
    
    #-----< CallSegmentToCancel >-----#
    CallSegmentToCancel = SEQ(name=u'CallSegmentToCancel', mode=MODE_TYPE, param=True)
    
    #-----< CAMEL-AChBillingChargingCharacteristics >-----#
    CAMEL_AChBillingChargingCharacteristics = CHOICE(name=u'CAMEL-AChBillingChargingCharacteristics', mode=MODE_TYPE, param=True)
    
    #-----< CAMEL-CallResult >-----#
    CAMEL_CallResult = CHOICE(name=u'CAMEL-CallResult', mode=MODE_TYPE, param=True)
    
    #-----< CAMEL-FCIBillingChargingCharacteristics >-----#
    CAMEL_FCIBillingChargingCharacteristics = CHOICE(name=u'CAMEL-FCIBillingChargingCharacteristics', mode=MODE_TYPE, param=True)
    
    #-----< CAMEL-FCIGPRSBillingChargingCharacteristics >-----#
    CAMEL_FCIGPRSBillingChargingCharacteristics = SEQ(name=u'CAMEL-FCIGPRSBillingChargingCharacteristics', mode=MODE_TYPE, param=True)
    
    #-----< CAMEL-FCISMSBillingChargingCharacteristics >-----#
    CAMEL_FCISMSBillingChargingCharacteristics = CHOICE(name=u'CAMEL-FCISMSBillingChargingCharacteristics', mode=MODE_TYPE, param=True)
    
    #-----< CAMEL-SCIBillingChargingCharacteristics >-----#
    CAMEL_SCIBillingChargingCharacteristics = CHOICE(name=u'CAMEL-SCIBillingChargingCharacteristics', mode=MODE_TYPE)
    _CAMEL_SCIBillingChargingCharacteristics_aOCBeforeAnswer = SEQ(name=u'aOCBeforeAnswer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'AOCBeforeAnswer')))
    _CAMEL_SCIBillingChargingCharacteristics_aOCAfterAnswer = SEQ(name=u'aOCAfterAnswer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'AOCSubsequent')))
    _CAMEL_SCIBillingChargingCharacteristics_aOC_extension = SEQ(name=u'aOC-extension', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'CAMEL-SCIBillingChargingCharacteristicsAlt')))
    CAMEL_SCIBillingChargingCharacteristics._cont = ASN1Dict([
        (u'aOCBeforeAnswer', _CAMEL_SCIBillingChargingCharacteristics_aOCBeforeAnswer),
        (u'aOCAfterAnswer', _CAMEL_SCIBillingChargingCharacteristics_aOCAfterAnswer),
        (u'aOC-extension', _CAMEL_SCIBillingChargingCharacteristics_aOC_extension),
        ])
    CAMEL_SCIBillingChargingCharacteristics._ext = None
    
    #-----< CAMEL-SCIBillingChargingCharacteristicsAlt >-----#
    CAMEL_SCIBillingChargingCharacteristicsAlt = SEQ(name=u'CAMEL-SCIBillingChargingCharacteristicsAlt', mode=MODE_TYPE)
    CAMEL_SCIBillingChargingCharacteristicsAlt._cont = ASN1Dict([
        ])
    CAMEL_SCIBillingChargingCharacteristicsAlt._ext = []
    
    #-----< CAMEL-SCIGPRSBillingChargingCharacteristics >-----#
    CAMEL_SCIGPRSBillingChargingCharacteristics = SEQ(name=u'CAMEL-SCIGPRSBillingChargingCharacteristics', mode=MODE_TYPE)
    _CAMEL_SCIGPRSBillingChargingCharacteristics_aOCGPRS = SEQ(name=u'aOCGPRS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'AOCGPRS')))
    _CAMEL_SCIGPRSBillingChargingCharacteristics_pDPID = OCT_STR(name=u'pDPID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'PDPID')), opt=True)
    CAMEL_SCIGPRSBillingChargingCharacteristics._cont = ASN1Dict([
        (u'aOCGPRS', _CAMEL_SCIGPRSBillingChargingCharacteristics_aOCGPRS),
        (u'pDPID', _CAMEL_SCIGPRSBillingChargingCharacteristics_pDPID),
        ])
    CAMEL_SCIGPRSBillingChargingCharacteristics._ext = []
    
    #-----< Carrier >-----#
    Carrier = OCT_STR(name=u'Carrier', mode=MODE_TYPE, param=True)
    
    #-----< Cause >-----#
    Cause = OCT_STR(name=u'Cause', mode=MODE_TYPE, param=True)
    
    #-----< CGEncountered >-----#
    CGEncountered = ENUM(name=u'CGEncountered', mode=MODE_TYPE)
    CGEncountered._cont = ASN1Dict([(u'noCGencountered', 0), (u'manualCGencountered', 1), (u'scpOverload', 2)])
    CGEncountered._ext = None
    
    #-----< ChangeOfPositionControlInfo >-----#
    ChangeOfPositionControlInfo = SEQ_OF(name=u'ChangeOfPositionControlInfo', mode=MODE_TYPE, param=True)
    
    #-----< ChangeOfLocation >-----#
    ChangeOfLocation = CHOICE(name=u'ChangeOfLocation', mode=MODE_TYPE)
    _ChangeOfLocation_cellGlobalId = OCT_STR(name=u'cellGlobalId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'CellGlobalIdOrServiceAreaIdFixedLength')))
    _ChangeOfLocation_serviceAreaId = OCT_STR(name=u'serviceAreaId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'CellGlobalIdOrServiceAreaIdFixedLength')))
    _ChangeOfLocation_locationAreaId = OCT_STR(name=u'locationAreaId', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LAIFixedLength')))
    _ChangeOfLocation_inter_SystemHandOver = NULL(name=u'inter-SystemHandOver', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ChangeOfLocation_inter_PLMNHandOver = NULL(name=u'inter-PLMNHandOver', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ChangeOfLocation_inter_MSCHandOver = NULL(name=u'inter-MSCHandOver', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ChangeOfLocation_changeOfLocationAlt = SEQ(name=u'changeOfLocationAlt', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'ChangeOfLocationAlt')))
    _ChangeOfLocation_changeOfLocationAlt._cont = ASN1Dict([
        ])
    _ChangeOfLocation_changeOfLocationAlt._ext = []
    ChangeOfLocation._cont = ASN1Dict([
        (u'cellGlobalId', _ChangeOfLocation_cellGlobalId),
        (u'serviceAreaId', _ChangeOfLocation_serviceAreaId),
        (u'locationAreaId', _ChangeOfLocation_locationAreaId),
        (u'inter-SystemHandOver', _ChangeOfLocation_inter_SystemHandOver),
        (u'inter-PLMNHandOver', _ChangeOfLocation_inter_PLMNHandOver),
        (u'inter-MSCHandOver', _ChangeOfLocation_inter_MSCHandOver),
        (u'changeOfLocationAlt', _ChangeOfLocation_changeOfLocationAlt),
        ])
    ChangeOfLocation._ext = None
    
    #-----< ChangeOfLocationAlt >-----#
    ChangeOfLocationAlt = SEQ(name=u'ChangeOfLocationAlt', mode=MODE_TYPE)
    ChangeOfLocationAlt._cont = ASN1Dict([
        ])
    ChangeOfLocationAlt._ext = []
    
    #-----< ChargeIndicator >-----#
    ChargeIndicator = OCT_STR(name=u'ChargeIndicator', mode=MODE_TYPE)
    ChargeIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< ChargeNumber >-----#
    ChargeNumber = OCT_STR(name=u'ChargeNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CAP-datatypes', 'LocationNumber')), param=True)
    
    #-----< ChargingCharacteristics >-----#
    ChargingCharacteristics = CHOICE(name=u'ChargingCharacteristics', mode=MODE_TYPE)
    _ChargingCharacteristics_maxTransferredVolume = INT(name=u'maxTransferredVolume', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ChargingCharacteristics_maxTransferredVolume._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4294967295)], ev=None, er=[])
    _ChargingCharacteristics_maxElapsedTime = INT(name=u'maxElapsedTime', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ChargingCharacteristics_maxElapsedTime._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=86400)], ev=None, er=[])
    ChargingCharacteristics._cont = ASN1Dict([
        (u'maxTransferredVolume', _ChargingCharacteristics_maxTransferredVolume),
        (u'maxElapsedTime', _ChargingCharacteristics_maxElapsedTime),
        ])
    ChargingCharacteristics._ext = None
    
    #-----< ChargingResult >-----#
    ChargingResult = CHOICE(name=u'ChargingResult', mode=MODE_TYPE)
    _ChargingResult_transferredVolume = CHOICE(name=u'transferredVolume', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'TransferredVolume')))
    _ChargingResult_elapsedTime = CHOICE(name=u'elapsedTime', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'ElapsedTime')))
    ChargingResult._cont = ASN1Dict([
        (u'transferredVolume', _ChargingResult_transferredVolume),
        (u'elapsedTime', _ChargingResult_elapsedTime),
        ])
    ChargingResult._ext = None
    
    #-----< ChargingRollOver >-----#
    ChargingRollOver = CHOICE(name=u'ChargingRollOver', mode=MODE_TYPE)
    _ChargingRollOver_transferredVolumeRollOver = CHOICE(name=u'transferredVolumeRollOver', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'TransferredVolumeRollOver')))
    _ChargingRollOver_elapsedTimeRollOver = CHOICE(name=u'elapsedTimeRollOver', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'ElapsedTimeRollOver')))
    ChargingRollOver._cont = ASN1Dict([
        (u'transferredVolumeRollOver', _ChargingRollOver_transferredVolumeRollOver),
        (u'elapsedTimeRollOver', _ChargingRollOver_elapsedTimeRollOver),
        ])
    ChargingRollOver._ext = None
    
    #-----< CollectedDigits >-----#
    CollectedDigits = SEQ(name=u'CollectedDigits', mode=MODE_TYPE)
    _CollectedDigits_minimumNbOfDigits = INT(name=u'minimumNbOfDigits', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=1)
    _CollectedDigits_minimumNbOfDigits._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    _CollectedDigits_maximumNbOfDigits = INT(name=u'maximumNbOfDigits', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CollectedDigits_maximumNbOfDigits._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    _CollectedDigits_endOfReplyDigit = OCT_STR(name=u'endOfReplyDigit', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CollectedDigits_endOfReplyDigit._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    _CollectedDigits_cancelDigit = OCT_STR(name=u'cancelDigit', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CollectedDigits_cancelDigit._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    _CollectedDigits_startDigit = OCT_STR(name=u'startDigit', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CollectedDigits_startDigit._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    _CollectedDigits_firstDigitTimeOut = INT(name=u'firstDigitTimeOut', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CollectedDigits_firstDigitTimeOut._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=127)], ev=None, er=[])
    _CollectedDigits_interDigitTimeOut = INT(name=u'interDigitTimeOut', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CollectedDigits_interDigitTimeOut._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=127)], ev=None, er=[])
    _CollectedDigits_errorTreatment = ENUM(name=u'errorTreatment', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'ErrorTreatment')), default=u'stdErrorAndInfo')
    _CollectedDigits_interruptableAnnInd = BOOL(name=u'interruptableAnnInd', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=True)
    _CollectedDigits_voiceInformation = BOOL(name=u'voiceInformation', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _CollectedDigits_voiceBack = BOOL(name=u'voiceBack', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    CollectedDigits._cont = ASN1Dict([
        (u'minimumNbOfDigits', _CollectedDigits_minimumNbOfDigits),
        (u'maximumNbOfDigits', _CollectedDigits_maximumNbOfDigits),
        (u'endOfReplyDigit', _CollectedDigits_endOfReplyDigit),
        (u'cancelDigit', _CollectedDigits_cancelDigit),
        (u'startDigit', _CollectedDigits_startDigit),
        (u'firstDigitTimeOut', _CollectedDigits_firstDigitTimeOut),
        (u'interDigitTimeOut', _CollectedDigits_interDigitTimeOut),
        (u'errorTreatment', _CollectedDigits_errorTreatment),
        (u'interruptableAnnInd', _CollectedDigits_interruptableAnnInd),
        (u'voiceInformation', _CollectedDigits_voiceInformation),
        (u'voiceBack', _CollectedDigits_voiceBack),
        ])
    CollectedDigits._ext = None
    
    #-----< CollectedInfo >-----#
    CollectedInfo = CHOICE(name=u'CollectedInfo', mode=MODE_TYPE)
    _CollectedInfo_collectedDigits = SEQ(name=u'collectedDigits', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'CollectedDigits')))
    CollectedInfo._cont = ASN1Dict([
        (u'collectedDigits', _CollectedInfo_collectedDigits),
        ])
    CollectedInfo._ext = None
    
    #-----< ConnectedNumberTreatmentInd >-----#
    ConnectedNumberTreatmentInd = ENUM(name=u'ConnectedNumberTreatmentInd', mode=MODE_TYPE)
    ConnectedNumberTreatmentInd._cont = ASN1Dict([(u'noINImpact', 0), (u'presentationRestricted', 1), (u'presentCalledINNumber', 2), (u'presentCallINNumberRestricted', 3)])
    ConnectedNumberTreatmentInd._ext = None
    
    #-----< ControlType >-----#
    ControlType = ENUM(name=u'ControlType', mode=MODE_TYPE)
    ControlType._cont = ASN1Dict([(u'sCPOverloaded', 0), (u'manuallyInitiated', 1)])
    ControlType._ext = None
    
    #-----< CompoundCriteria >-----#
    CompoundCriteria = SEQ(name=u'CompoundCriteria', mode=MODE_TYPE, param=True)
    
    #-----< CorrelationID >-----#
    CorrelationID = OCT_STR(name=u'CorrelationID', mode=MODE_TYPE, typeref=ASN1RefType(('CAP-datatypes', 'Digits')), param=True)
    
    #-----< DateAndTime >-----#
    DateAndTime = OCT_STR(name=u'DateAndTime', mode=MODE_TYPE)
    DateAndTime._const_sz = ASN1Set(rv=[7], rr=[], ev=None, er=[])
    
    #-----< DestinationRoutingAddress >-----#
    DestinationRoutingAddress = SEQ_OF(name=u'DestinationRoutingAddress', mode=MODE_TYPE, param=True)
    
    #-----< Digits >-----#
    Digits = OCT_STR(name=u'Digits', mode=MODE_TYPE, param=True)
    
    #-----< DpSpecificCriteria >-----#
    DpSpecificCriteria = CHOICE(name=u'DpSpecificCriteria', mode=MODE_TYPE, param=True)
    
    #-----< DpSpecificCriteriaAlt >-----#
    DpSpecificCriteriaAlt = SEQ(name=u'DpSpecificCriteriaAlt', mode=MODE_TYPE, param=True)
    
    #-----< DpSpecificInfoAlt >-----#
    DpSpecificInfoAlt = SEQ(name=u'DpSpecificInfoAlt', mode=MODE_TYPE, param=True)
    
    #-----< ElapsedTime >-----#
    ElapsedTime = CHOICE(name=u'ElapsedTime', mode=MODE_TYPE)
    _ElapsedTime_timeGPRSIfNoTariffSwitch = INT(name=u'timeGPRSIfNoTariffSwitch', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ElapsedTime_timeGPRSIfNoTariffSwitch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=86400)], ev=None, er=[])
    _ElapsedTime_timeGPRSIfTariffSwitch = SEQ(name=u'timeGPRSIfTariffSwitch', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ElapsedTime_timeGPRSIfTariffSwitch_timeGPRSSinceLastTariffSwitch = INT(name=u'timeGPRSSinceLastTariffSwitch', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ElapsedTime_timeGPRSIfTariffSwitch_timeGPRSSinceLastTariffSwitch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=86400)], ev=None, er=[])
    __ElapsedTime_timeGPRSIfTariffSwitch_timeGPRSTariffSwitchInterval = INT(name=u'timeGPRSTariffSwitchInterval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ElapsedTime_timeGPRSIfTariffSwitch_timeGPRSTariffSwitchInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=86400)], ev=None, er=[])
    _ElapsedTime_timeGPRSIfTariffSwitch._cont = ASN1Dict([
        (u'timeGPRSSinceLastTariffSwitch', __ElapsedTime_timeGPRSIfTariffSwitch_timeGPRSSinceLastTariffSwitch),
        (u'timeGPRSTariffSwitchInterval', __ElapsedTime_timeGPRSIfTariffSwitch_timeGPRSTariffSwitchInterval),
        ])
    _ElapsedTime_timeGPRSIfTariffSwitch._ext = None
    ElapsedTime._cont = ASN1Dict([
        (u'timeGPRSIfNoTariffSwitch', _ElapsedTime_timeGPRSIfNoTariffSwitch),
        (u'timeGPRSIfTariffSwitch', _ElapsedTime_timeGPRSIfTariffSwitch),
        ])
    ElapsedTime._ext = None
    
    #-----< ElapsedTimeRollOver >-----#
    ElapsedTimeRollOver = CHOICE(name=u'ElapsedTimeRollOver', mode=MODE_TYPE)
    _ElapsedTimeRollOver_rO_TimeGPRSIfNoTariffSwitch = INT(name=u'rO-TimeGPRSIfNoTariffSwitch', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _ElapsedTimeRollOver_rO_TimeGPRSIfNoTariffSwitch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch = SEQ(name=u'rO-TimeGPRSIfTariffSwitch', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch_rO_TimeGPRSSinceLastTariffSwitch = INT(name=u'rO-TimeGPRSSinceLastTariffSwitch', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch_rO_TimeGPRSSinceLastTariffSwitch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    __ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch_rO_TimeGPRSTariffSwitchInterval = INT(name=u'rO-TimeGPRSTariffSwitchInterval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch_rO_TimeGPRSTariffSwitchInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch._cont = ASN1Dict([
        (u'rO-TimeGPRSSinceLastTariffSwitch', __ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch_rO_TimeGPRSSinceLastTariffSwitch),
        (u'rO-TimeGPRSTariffSwitchInterval', __ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch_rO_TimeGPRSTariffSwitchInterval),
        ])
    _ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch._ext = None
    ElapsedTimeRollOver._cont = ASN1Dict([
        (u'rO-TimeGPRSIfNoTariffSwitch', _ElapsedTimeRollOver_rO_TimeGPRSIfNoTariffSwitch),
        (u'rO-TimeGPRSIfTariffSwitch', _ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch),
        ])
    ElapsedTimeRollOver._ext = None
    
    #-----< EndUserAddress >-----#
    EndUserAddress = SEQ(name=u'EndUserAddress', mode=MODE_TYPE, param=True)
    
    #-----< ErrorTreatment >-----#
    ErrorTreatment = ENUM(name=u'ErrorTreatment', mode=MODE_TYPE)
    ErrorTreatment._cont = ASN1Dict([(u'stdErrorAndInfo', 0), (u'help', 1), (u'repeatPrompt', 2)])
    ErrorTreatment._ext = None
    
    #-----< EventSpecificInformationBCSM >-----#
    EventSpecificInformationBCSM = CHOICE(name=u'EventSpecificInformationBCSM', mode=MODE_TYPE, param=True)
    
    #-----< EventSpecificInformationSMS >-----#
    EventSpecificInformationSMS = CHOICE(name=u'EventSpecificInformationSMS', mode=MODE_TYPE)
    _EventSpecificInformationSMS_o_smsFailureSpecificInfo = SEQ(name=u'o-smsFailureSpecificInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __EventSpecificInformationSMS_o_smsFailureSpecificInfo_failureCause = ENUM(name=u'failureCause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'MO-SMSCause')), opt=True)
    _EventSpecificInformationSMS_o_smsFailureSpecificInfo._cont = ASN1Dict([
        (u'failureCause', __EventSpecificInformationSMS_o_smsFailureSpecificInfo_failureCause),
        ])
    _EventSpecificInformationSMS_o_smsFailureSpecificInfo._ext = []
    _EventSpecificInformationSMS_o_smsSubmissionSpecificInfo = SEQ(name=u'o-smsSubmissionSpecificInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EventSpecificInformationSMS_o_smsSubmissionSpecificInfo._cont = ASN1Dict([
        ])
    _EventSpecificInformationSMS_o_smsSubmissionSpecificInfo._ext = []
    _EventSpecificInformationSMS_t_smsFailureSpecificInfo = SEQ(name=u't-smsFailureSpecificInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __EventSpecificInformationSMS_t_smsFailureSpecificInfo_failureCause = OCT_STR(name=u'failureCause', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'MT-SMSCause')), opt=True)
    _EventSpecificInformationSMS_t_smsFailureSpecificInfo._cont = ASN1Dict([
        (u'failureCause', __EventSpecificInformationSMS_t_smsFailureSpecificInfo_failureCause),
        ])
    _EventSpecificInformationSMS_t_smsFailureSpecificInfo._ext = []
    _EventSpecificInformationSMS_t_smsDeliverySpecificInfo = SEQ(name=u't-smsDeliverySpecificInfo', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _EventSpecificInformationSMS_t_smsDeliverySpecificInfo._cont = ASN1Dict([
        ])
    _EventSpecificInformationSMS_t_smsDeliverySpecificInfo._ext = []
    EventSpecificInformationSMS._cont = ASN1Dict([
        (u'o-smsFailureSpecificInfo', _EventSpecificInformationSMS_o_smsFailureSpecificInfo),
        (u'o-smsSubmissionSpecificInfo', _EventSpecificInformationSMS_o_smsSubmissionSpecificInfo),
        (u't-smsFailureSpecificInfo', _EventSpecificInformationSMS_t_smsFailureSpecificInfo),
        (u't-smsDeliverySpecificInfo', _EventSpecificInformationSMS_t_smsDeliverySpecificInfo),
        ])
    EventSpecificInformationSMS._ext = None
    
    #-----< EventTypeBCSM >-----#
    EventTypeBCSM = ENUM(name=u'EventTypeBCSM', mode=MODE_TYPE)
    EventTypeBCSM._cont = ASN1Dict([(u'collectedInfo', 2), (u'analyzedInformation', 3), (u'routeSelectFailure', 4), (u'oCalledPartyBusy', 5), (u'oNoAnswer', 6), (u'oAnswer', 7), (u'oMidCall', 8), (u'oDisconnect', 9), (u'oAbandon', 10), (u'termAttemptAuthorized', 12), (u'tBusy', 13), (u'tNoAnswer', 14), (u'tAnswer', 15), (u'tMidCall', 16), (u'tDisconnect', 17), (u'tAbandon', 18), (u'oTermSeized', 19), (u'callAccepted', 27), (u'oChangeOfPosition', 50), (u'tChangeOfPosition', 51), (u'oServiceChange', 52), (u'tServiceChange', 53)])
    EventTypeBCSM._ext = [u'oServiceChange', u'tServiceChange']
    
    #-----< EventTypeSMS >-----#
    EventTypeSMS = ENUM(name=u'EventTypeSMS', mode=MODE_TYPE)
    EventTypeSMS._cont = ASN1Dict([(u'sms-CollectedInfo', 1), (u'o-smsFailure', 2), (u'o-smsSubmission', 3), (u'sms-DeliveryRequested', 11), (u't-smsFailure', 12), (u't-smsDelivery', 13)])
    EventTypeSMS._ext = None
    
    #-----< Extensions >-----#
    Extensions = SEQ_OF(name=u'Extensions', mode=MODE_TYPE, param=True)
    
    #-----< ExtensionField >-----#
    ExtensionField = SEQ(name=u'ExtensionField', mode=MODE_TYPE)
    _ExtensionField_type = CHOICE(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('CAP-classes', 'EXTENSION'), [u'id']))
    __ExtensionField_type_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('CAP-classes', 'EXTENSION')))
    ___ExtensionField_type_tab_val_ExtensionType_0 = NULL(name=u'ExtensionType', mode=MODE_TYPE)
    __ExtensionField_type_tab._val = ASN1Set(rv=[dict([(u'ExtensionType', ___ExtensionField_type_tab_val_ExtensionType_0), (u'criticality', u'ignore'), (u'id', (u'global', (0, 4, 0, 1, 2)))])], rr=[], ev=None, er=[])
    _ExtensionField_type._const_tab = __ExtensionField_type_tab
    _ExtensionField_type._const_tab_at = None
    _ExtensionField_type._const_tab_id = u'id'
    _ExtensionField_criticality = ENUM(name=u'criticality', mode=MODE_TYPE, typeref=ASN1RefType(('CS2-datatypes', 'CriticalityType')), default=u'ignore')
    _ExtensionField_value = OPEN(name=u'value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('CAP-classes', 'EXTENSION'), [u'ExtensionType']))
    _ExtensionField_value._const_tab = __ExtensionField_type_tab
    _ExtensionField_value._const_tab_at = ('..', u'type')
    _ExtensionField_value._const_tab_id = u'ExtensionType'
    ExtensionField._cont = ASN1Dict([
        (u'type', _ExtensionField_type),
        (u'criticality', _ExtensionField_criticality),
        (u'value', _ExtensionField_value),
        ])
    ExtensionField._ext = []
    
    #-----< FCIBillingChargingCharacteristics >-----#
    FCIBillingChargingCharacteristics = OCT_STR(name=u'FCIBillingChargingCharacteristics', mode=MODE_TYPE, param=True)
    
    #-----< FCIGPRSBillingChargingCharacteristics >-----#
    FCIGPRSBillingChargingCharacteristics = OCT_STR(name=u'FCIGPRSBillingChargingCharacteristics', mode=MODE_TYPE, param=True)
    
    #-----< FCISMSBillingChargingCharacteristics >-----#
    FCISMSBillingChargingCharacteristics = OCT_STR(name=u'FCISMSBillingChargingCharacteristics', mode=MODE_TYPE, param=True)
    
    #-----< ForwardServiceInteractionInd >-----#
    ForwardServiceInteractionInd = SEQ(name=u'ForwardServiceInteractionInd', mode=MODE_TYPE)
    _ForwardServiceInteractionInd_conferenceTreatmentIndicator = OCT_STR(name=u'conferenceTreatmentIndicator', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ForwardServiceInteractionInd_conferenceTreatmentIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _ForwardServiceInteractionInd_callDiversionTreatmentIndicator = OCT_STR(name=u'callDiversionTreatmentIndicator', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ForwardServiceInteractionInd_callDiversionTreatmentIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _ForwardServiceInteractionInd_callingPartyRestrictionIndicator = OCT_STR(name=u'callingPartyRestrictionIndicator', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ForwardServiceInteractionInd_callingPartyRestrictionIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    ForwardServiceInteractionInd._cont = ASN1Dict([
        (u'conferenceTreatmentIndicator', _ForwardServiceInteractionInd_conferenceTreatmentIndicator),
        (u'callDiversionTreatmentIndicator', _ForwardServiceInteractionInd_callDiversionTreatmentIndicator),
        (u'callingPartyRestrictionIndicator', _ForwardServiceInteractionInd_callingPartyRestrictionIndicator),
        ])
    ForwardServiceInteractionInd._ext = []
    
    #-----< GapCriteria >-----#
    GapCriteria = CHOICE(name=u'GapCriteria', mode=MODE_TYPE, param=True)
    
    #-----< GapIndicators >-----#
    GapIndicators = SEQ(name=u'GapIndicators', mode=MODE_TYPE)
    _GapIndicators_duration = INT(name=u'duration', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CS1-DataTypes', 'Duration')))
    _GapIndicators_gapInterval = INT(name=u'gapInterval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CS1-DataTypes', 'Interval')))
    GapIndicators._cont = ASN1Dict([
        (u'duration', _GapIndicators_duration),
        (u'gapInterval', _GapIndicators_gapInterval),
        ])
    GapIndicators._ext = []
    
    #-----< GapOnService >-----#
    GapOnService = SEQ(name=u'GapOnService', mode=MODE_TYPE)
    _GapOnService_serviceKey = INT(name=u'serviceKey', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CS1-DataTypes', 'ServiceKey')))
    GapOnService._cont = ASN1Dict([
        (u'serviceKey', _GapOnService_serviceKey),
        ])
    GapOnService._ext = []
    
    #-----< GapTreatment >-----#
    GapTreatment = CHOICE(name=u'GapTreatment', mode=MODE_TYPE, param=True)
    
    #-----< GenericNumber >-----#
    GenericNumber = OCT_STR(name=u'GenericNumber', mode=MODE_TYPE, param=True)
    
    #-----< GenericNumbers >-----#
    GenericNumbers = SET_OF(name=u'GenericNumbers', mode=MODE_TYPE, param=True)
    
    #-----< GPRS-QoS >-----#
    GPRS_QoS = CHOICE(name=u'GPRS-QoS', mode=MODE_TYPE)
    _GPRS_QoS_short_QoS_format = OCT_STR(name=u'short-QoS-format', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'QoS-Subscribed')))
    _GPRS_QoS_long_QoS_format = OCT_STR(name=u'long-QoS-format', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext-QoS-Subscribed')))
    GPRS_QoS._cont = ASN1Dict([
        (u'short-QoS-format', _GPRS_QoS_short_QoS_format),
        (u'long-QoS-format', _GPRS_QoS_long_QoS_format),
        ])
    GPRS_QoS._ext = None
    
    #-----< GPRS-QoS-Extension >-----#
    GPRS_QoS_Extension = SEQ(name=u'GPRS-QoS-Extension', mode=MODE_TYPE)
    _GPRS_QoS_Extension_supplement_to_long_QoS_format = OCT_STR(name=u'supplement-to-long-QoS-format', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext2-QoS-Subscribed')))
    _GPRS_QoS_Extension_additionalSupplement = OCT_STR(name=u'additionalSupplement', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'Ext3-QoS-Subscribed')), opt=True)
    GPRS_QoS_Extension._cont = ASN1Dict([
        (u'supplement-to-long-QoS-format', _GPRS_QoS_Extension_supplement_to_long_QoS_format),
        (u'additionalSupplement', _GPRS_QoS_Extension_additionalSupplement),
        ])
    GPRS_QoS_Extension._ext = [u'additionalSupplement']
    
    #-----< GPRSCause >-----#
    GPRSCause = OCT_STR(name=u'GPRSCause', mode=MODE_TYPE, param=True)
    
    #-----< GPRSEvent >-----#
    GPRSEvent = SEQ(name=u'GPRSEvent', mode=MODE_TYPE)
    _GPRSEvent_gPRSEventType = ENUM(name=u'gPRSEventType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'GPRSEventType')))
    _GPRSEvent_monitorMode = ENUM(name=u'monitorMode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'MonitorMode')))
    GPRSEvent._cont = ASN1Dict([
        (u'gPRSEventType', _GPRSEvent_gPRSEventType),
        (u'monitorMode', _GPRSEvent_monitorMode),
        ])
    GPRSEvent._ext = None
    
    #-----< GPRSEventSpecificInformation >-----#
    GPRSEventSpecificInformation = CHOICE(name=u'GPRSEventSpecificInformation', mode=MODE_TYPE, param=True)
    
    #-----< GPRSEventType >-----#
    GPRSEventType = ENUM(name=u'GPRSEventType', mode=MODE_TYPE)
    GPRSEventType._cont = ASN1Dict([(u'attach', 1), (u'attachChangeOfPosition', 2), (u'detached', 3), (u'pdp-ContextEstablishment', 11), (u'pdp-ContextEstablishmentAcknowledgement', 12), (u'disonnect', 13), (u'pdp-ContextChangeOfPosition', 14)])
    GPRSEventType._ext = None
    
    #-----< InbandInfo >-----#
    InbandInfo = SEQ(name=u'InbandInfo', mode=MODE_TYPE, param=True)
    
    #-----< InformationToSend >-----#
    InformationToSend = CHOICE(name=u'InformationToSend', mode=MODE_TYPE, param=True)
    
    #-----< InitiatingEntity >-----#
    InitiatingEntity = ENUM(name=u'InitiatingEntity', mode=MODE_TYPE)
    InitiatingEntity._cont = ASN1Dict([(u'mobileStation', 0), (u'sgsn', 1), (u'hlr', 2), (u'ggsn', 3)])
    InitiatingEntity._ext = None
    
    #-----< InitiatorOfServiceChange >-----#
    InitiatorOfServiceChange = ENUM(name=u'InitiatorOfServiceChange', mode=MODE_TYPE)
    InitiatorOfServiceChange._cont = ASN1Dict([(u'a-side', 0), (u'b-side', 1)])
    InitiatorOfServiceChange._ext = None
    
    #-----< InvokeID >-----#
    InvokeID = INT(name=u'InvokeID', mode=MODE_TYPE)
    InvokeID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=-128, ub=127)], ev=None, er=[])
    
    #-----< IPRoutingAddress >-----#
    IPRoutingAddress = OCT_STR(name=u'IPRoutingAddress', mode=MODE_TYPE, typeref=ASN1RefType(('CAP-datatypes', 'CalledPartyNumber')), param=True)
    
    #-----< IPSSPCapabilities >-----#
    IPSSPCapabilities = OCT_STR(name=u'IPSSPCapabilities', mode=MODE_TYPE, param=True)
    
    #-----< LegOrCallSegment >-----#
    LegOrCallSegment = CHOICE(name=u'LegOrCallSegment', mode=MODE_TYPE, param=True)
    
    #-----< LegType >-----#
    LegType = OCT_STR(name=u'LegType', mode=MODE_TYPE)
    LegType._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< leg1 >-----#
    leg1 = OCT_STR(name=u'leg1', mode=MODE_VALUE, typeref=ASN1RefType(('CAP-datatypes', 'LegType')))
    leg1._val = b'\x01'
    
    #-----< leg2 >-----#
    leg2 = OCT_STR(name=u'leg2', mode=MODE_VALUE, typeref=ASN1RefType(('CAP-datatypes', 'LegType')))
    leg2._val = b'\x02'
    
    #-----< LocationInformationGPRS >-----#
    LocationInformationGPRS = SEQ(name=u'LocationInformationGPRS', mode=MODE_TYPE)
    _LocationInformationGPRS_cellGlobalIdOrServiceAreaIdOrLAI = OCT_STR(name=u'cellGlobalIdOrServiceAreaIdOrLAI', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _LocationInformationGPRS_cellGlobalIdOrServiceAreaIdOrLAI._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=5, ub=7)], ev=None, er=[])
    _LocationInformationGPRS_routeingAreaIdentity = OCT_STR(name=u'routeingAreaIdentity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'RAIdentity')), opt=True)
    _LocationInformationGPRS_geographicalInformation = OCT_STR(name=u'geographicalInformation', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'GeographicalInformation')), opt=True)
    _LocationInformationGPRS_sgsn_Number = OCT_STR(name=u'sgsn-Number', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'ISDN-AddressString')), opt=True)
    _LocationInformationGPRS_selectedLSAIdentity = OCT_STR(name=u'selectedLSAIdentity', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-MS-DataTypes', 'LSAIdentity')), opt=True)
    _LocationInformationGPRS_extensionContainer = SEQ(name=u'extensionContainer', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-ExtensionDataTypes', 'ExtensionContainer')), opt=True)
    _LocationInformationGPRS_sai_Present = NULL(name=u'sai-Present', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _LocationInformationGPRS_userCSGInformation = OCT_STR(name=u'userCSGInformation', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'UserCSGInformation')), opt=True)
    LocationInformationGPRS._cont = ASN1Dict([
        (u'cellGlobalIdOrServiceAreaIdOrLAI', _LocationInformationGPRS_cellGlobalIdOrServiceAreaIdOrLAI),
        (u'routeingAreaIdentity', _LocationInformationGPRS_routeingAreaIdentity),
        (u'geographicalInformation', _LocationInformationGPRS_geographicalInformation),
        (u'sgsn-Number', _LocationInformationGPRS_sgsn_Number),
        (u'selectedLSAIdentity', _LocationInformationGPRS_selectedLSAIdentity),
        (u'extensionContainer', _LocationInformationGPRS_extensionContainer),
        (u'sai-Present', _LocationInformationGPRS_sai_Present),
        (u'userCSGInformation', _LocationInformationGPRS_userCSGInformation),
        ])
    LocationInformationGPRS._ext = [u'sai-Present', u'userCSGInformation']
    
    #-----< UserCSGInformation >-----#
    UserCSGInformation = OCT_STR(name=u'UserCSGInformation', mode=MODE_TYPE)
    
    #-----< LocationNumber >-----#
    LocationNumber = OCT_STR(name=u'LocationNumber', mode=MODE_TYPE, param=True)
    
    #-----< LowLayerCompatibility >-----#
    LowLayerCompatibility = OCT_STR(name=u'LowLayerCompatibility', mode=MODE_TYPE, param=True)
    
    #-----< MessageID >-----#
    MessageID = CHOICE(name=u'MessageID', mode=MODE_TYPE, param=True)
    
    #-----< MetDPCriteriaList >-----#
    MetDPCriteriaList = SEQ_OF(name=u'MetDPCriteriaList', mode=MODE_TYPE, param=True)
    
    #-----< MetDPCriterion >-----#
    MetDPCriterion = CHOICE(name=u'MetDPCriterion', mode=MODE_TYPE)
    _MetDPCriterion_enteringCellGlobalId = OCT_STR(name=u'enteringCellGlobalId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'CellGlobalIdOrServiceAreaIdFixedLength')))
    _MetDPCriterion_leavingCellGlobalId = OCT_STR(name=u'leavingCellGlobalId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'CellGlobalIdOrServiceAreaIdFixedLength')))
    _MetDPCriterion_enteringServiceAreaId = OCT_STR(name=u'enteringServiceAreaId', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'CellGlobalIdOrServiceAreaIdFixedLength')))
    _MetDPCriterion_leavingServiceAreaId = OCT_STR(name=u'leavingServiceAreaId', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'CellGlobalIdOrServiceAreaIdFixedLength')))
    _MetDPCriterion_enteringLocationAreaId = OCT_STR(name=u'enteringLocationAreaId', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LAIFixedLength')))
    _MetDPCriterion_leavingLocationAreaId = OCT_STR(name=u'leavingLocationAreaId', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MAP-CommonDataTypes', 'LAIFixedLength')))
    _MetDPCriterion_inter_SystemHandOverToUMTS = NULL(name=u'inter-SystemHandOverToUMTS', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MetDPCriterion_inter_SystemHandOverToGSM = NULL(name=u'inter-SystemHandOverToGSM', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MetDPCriterion_inter_PLMNHandOver = NULL(name=u'inter-PLMNHandOver', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MetDPCriterion_inter_MSCHandOver = NULL(name=u'inter-MSCHandOver', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _MetDPCriterion_metDPCriterionAlt = SEQ(name=u'metDPCriterionAlt', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'MetDPCriterionAlt')))
    _MetDPCriterion_metDPCriterionAlt._cont = ASN1Dict([
        ])
    _MetDPCriterion_metDPCriterionAlt._ext = []
    MetDPCriterion._cont = ASN1Dict([
        (u'enteringCellGlobalId', _MetDPCriterion_enteringCellGlobalId),
        (u'leavingCellGlobalId', _MetDPCriterion_leavingCellGlobalId),
        (u'enteringServiceAreaId', _MetDPCriterion_enteringServiceAreaId),
        (u'leavingServiceAreaId', _MetDPCriterion_leavingServiceAreaId),
        (u'enteringLocationAreaId', _MetDPCriterion_enteringLocationAreaId),
        (u'leavingLocationAreaId', _MetDPCriterion_leavingLocationAreaId),
        (u'inter-SystemHandOverToUMTS', _MetDPCriterion_inter_SystemHandOverToUMTS),
        (u'inter-SystemHandOverToGSM', _MetDPCriterion_inter_SystemHandOverToGSM),
        (u'inter-PLMNHandOver', _MetDPCriterion_inter_PLMNHandOver),
        (u'inter-MSCHandOver', _MetDPCriterion_inter_MSCHandOver),
        (u'metDPCriterionAlt', _MetDPCriterion_metDPCriterionAlt),
        ])
    MetDPCriterion._ext = None
    
    #-----< MetDPCriterionAlt >-----#
    MetDPCriterionAlt = SEQ(name=u'MetDPCriterionAlt', mode=MODE_TYPE)
    MetDPCriterionAlt._cont = ASN1Dict([
        ])
    MetDPCriterionAlt._ext = []
    
    #-----< MidCallControlInfo >-----#
    MidCallControlInfo = SEQ(name=u'MidCallControlInfo', mode=MODE_TYPE)
    _MidCallControlInfo_minimumNumberOfDigits = INT(name=u'minimumNumberOfDigits', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=1)
    _MidCallControlInfo_minimumNumberOfDigits._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    _MidCallControlInfo_maximumNumberOfDigits = INT(name=u'maximumNumberOfDigits', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=30)
    _MidCallControlInfo_maximumNumberOfDigits._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=30)], ev=None, er=[])
    _MidCallControlInfo_endOfReplyDigit = OCT_STR(name=u'endOfReplyDigit', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MidCallControlInfo_endOfReplyDigit._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    _MidCallControlInfo_cancelDigit = OCT_STR(name=u'cancelDigit', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MidCallControlInfo_cancelDigit._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    _MidCallControlInfo_startDigit = OCT_STR(name=u'startDigit', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _MidCallControlInfo_startDigit._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=2)], ev=None, er=[])
    _MidCallControlInfo_interDigitTimeout = INT(name=u'interDigitTimeout', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=10)
    _MidCallControlInfo_interDigitTimeout._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=127)], ev=None, er=[])
    MidCallControlInfo._cont = ASN1Dict([
        (u'minimumNumberOfDigits', _MidCallControlInfo_minimumNumberOfDigits),
        (u'maximumNumberOfDigits', _MidCallControlInfo_maximumNumberOfDigits),
        (u'endOfReplyDigit', _MidCallControlInfo_endOfReplyDigit),
        (u'cancelDigit', _MidCallControlInfo_cancelDigit),
        (u'startDigit', _MidCallControlInfo_startDigit),
        (u'interDigitTimeout', _MidCallControlInfo_interDigitTimeout),
        ])
    MidCallControlInfo._ext = []
    
    #-----< MonitorMode >-----#
    MonitorMode = ENUM(name=u'MonitorMode', mode=MODE_TYPE)
    MonitorMode._cont = ASN1Dict([(u'interrupted', 0), (u'notifyAndContinue', 1), (u'transparent', 2)])
    MonitorMode._ext = None
    
    #-----< MO-SMSCause >-----#
    MO_SMSCause = ENUM(name=u'MO-SMSCause', mode=MODE_TYPE)
    MO_SMSCause._cont = ASN1Dict([(u'systemFailure', 0), (u'unexpectedDataValue', 1), (u'facilityNotSupported', 2), (u'sM-DeliveryFailure', 3), (u'releaseFromRadioInterface', 4)])
    MO_SMSCause._ext = None
    
    #-----< MT-SMSCause >-----#
    MT_SMSCause = OCT_STR(name=u'MT-SMSCause', mode=MODE_TYPE)
    MT_SMSCause._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< NAOliInfo >-----#
    NAOliInfo = OCT_STR(name=u'NAOliInfo', mode=MODE_TYPE)
    NAOliInfo._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< NatureOfServiceChange >-----#
    NatureOfServiceChange = ENUM(name=u'NatureOfServiceChange', mode=MODE_TYPE)
    NatureOfServiceChange._cont = ASN1Dict([(u'userInitiated', 0), (u'networkInitiated', 1)])
    NatureOfServiceChange._ext = None
    
    #-----< NumberOfDigits >-----#
    NumberOfDigits = INT(name=u'NumberOfDigits', mode=MODE_TYPE)
    NumberOfDigits._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    
    #-----< OCSIApplicable >-----#
    OCSIApplicable = NULL(name=u'OCSIApplicable', mode=MODE_TYPE)
    
    #-----< OriginalCalledPartyID >-----#
    OriginalCalledPartyID = OCT_STR(name=u'OriginalCalledPartyID', mode=MODE_TYPE, param=True)
    
    #-----< PDPID >-----#
    PDPID = OCT_STR(name=u'PDPID', mode=MODE_TYPE)
    PDPID._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< PDPInitiationType >-----#
    PDPInitiationType = ENUM(name=u'PDPInitiationType', mode=MODE_TYPE)
    PDPInitiationType._cont = ASN1Dict([(u'mSInitiated', 0), (u'networkInitiated', 1)])
    PDPInitiationType._ext = None
    
    #-----< QualityOfService >-----#
    QualityOfService = SEQ(name=u'QualityOfService', mode=MODE_TYPE)
    _QualityOfService_requested_QoS = CHOICE(name=u'requested-QoS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'GPRS-QoS')), opt=True)
    _QualityOfService_subscribed_QoS = CHOICE(name=u'subscribed-QoS', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'GPRS-QoS')), opt=True)
    _QualityOfService_negotiated_QoS = CHOICE(name=u'negotiated-QoS', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'GPRS-QoS')), opt=True)
    _QualityOfService_requested_QoS_Extension = SEQ(name=u'requested-QoS-Extension', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'GPRS-QoS-Extension')), opt=True)
    _QualityOfService_subscribed_QoS_Extension = SEQ(name=u'subscribed-QoS-Extension', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'GPRS-QoS-Extension')), opt=True)
    _QualityOfService_negotiated_QoS_Extension = SEQ(name=u'negotiated-QoS-Extension', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'GPRS-QoS-Extension')), opt=True)
    QualityOfService._cont = ASN1Dict([
        (u'requested-QoS', _QualityOfService_requested_QoS),
        (u'subscribed-QoS', _QualityOfService_subscribed_QoS),
        (u'negotiated-QoS', _QualityOfService_negotiated_QoS),
        (u'requested-QoS-Extension', _QualityOfService_requested_QoS_Extension),
        (u'subscribed-QoS-Extension', _QualityOfService_subscribed_QoS_Extension),
        (u'negotiated-QoS-Extension', _QualityOfService_negotiated_QoS_Extension),
        ])
    QualityOfService._ext = [u'requested-QoS-Extension', u'subscribed-QoS-Extension', u'negotiated-QoS-Extension']
    
    #-----< ReceivingSideID >-----#
    ReceivingSideID = CHOICE(name=u'ReceivingSideID', mode=MODE_TYPE)
    _ReceivingSideID_receivingSideID = OCT_STR(name=u'receivingSideID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'LegType')))
    ReceivingSideID._cont = ASN1Dict([
        (u'receivingSideID', _ReceivingSideID_receivingSideID),
        ])
    ReceivingSideID._ext = None
    
    #-----< RedirectingPartyID >-----#
    RedirectingPartyID = OCT_STR(name=u'RedirectingPartyID', mode=MODE_TYPE, param=True)
    
    #-----< RequestedInformationList >-----#
    RequestedInformationList = SEQ_OF(name=u'RequestedInformationList', mode=MODE_TYPE, param=True)
    
    #-----< RequestedInformationTypeList >-----#
    RequestedInformationTypeList = SEQ_OF(name=u'RequestedInformationTypeList', mode=MODE_TYPE)
    _RequestedInformationTypeList__item_ = ENUM(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CAP-datatypes', 'RequestedInformationType')))
    RequestedInformationTypeList._cont = _RequestedInformationTypeList__item_
    RequestedInformationTypeList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=4)], ev=None, er=[])
    
    #-----< RequestedInformation >-----#
    RequestedInformation = SEQ(name=u'RequestedInformation', mode=MODE_TYPE, param=True)
    
    #-----< RequestedInformationType >-----#
    RequestedInformationType = ENUM(name=u'RequestedInformationType', mode=MODE_TYPE)
    RequestedInformationType._cont = ASN1Dict([(u'callAttemptElapsedTime', 0), (u'callStopTime', 1), (u'callConnectedElapsedTime', 2), (u'releaseCause', 30)])
    RequestedInformationType._ext = None
    
    #-----< RequestedInformationValue >-----#
    RequestedInformationValue = CHOICE(name=u'RequestedInformationValue', mode=MODE_TYPE, param=True)
    
    #-----< RPCause >-----#
    RPCause = OCT_STR(name=u'RPCause', mode=MODE_TYPE)
    RPCause._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< ScfID >-----#
    ScfID = OCT_STR(name=u'ScfID', mode=MODE_TYPE, param=True)
    
    #-----< SCIBillingChargingCharacteristics >-----#
    SCIBillingChargingCharacteristics = OCT_STR(name=u'SCIBillingChargingCharacteristics', mode=MODE_TYPE, param=True)
    
    #-----< SCIGPRSBillingChargingCharacteristics >-----#
    SCIGPRSBillingChargingCharacteristics = OCT_STR(name=u'SCIGPRSBillingChargingCharacteristics', mode=MODE_TYPE, param=True)
    
    #-----< SendingSideID >-----#
    SendingSideID = CHOICE(name=u'SendingSideID', mode=MODE_TYPE)
    _SendingSideID_sendingSideID = OCT_STR(name=u'sendingSideID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'LegType')))
    SendingSideID._cont = ASN1Dict([
        (u'sendingSideID', _SendingSideID_sendingSideID),
        ])
    SendingSideID._ext = None
    
    #-----< ServiceInteractionIndicatorsTwo >-----#
    ServiceInteractionIndicatorsTwo = SEQ(name=u'ServiceInteractionIndicatorsTwo', mode=MODE_TYPE)
    _ServiceInteractionIndicatorsTwo_forwardServiceInteractionInd = SEQ(name=u'forwardServiceInteractionInd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'ForwardServiceInteractionInd')), opt=True)
    _ServiceInteractionIndicatorsTwo_backwardServiceInteractionInd = SEQ(name=u'backwardServiceInteractionInd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'BackwardServiceInteractionInd')), opt=True)
    _ServiceInteractionIndicatorsTwo_bothwayThroughConnectionInd = ENUM(name=u'bothwayThroughConnectionInd', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CS2-datatypes', 'BothwayThroughConnectionInd')), opt=True)
    _ServiceInteractionIndicatorsTwo_connectedNumberTreatmentInd = ENUM(name=u'connectedNumberTreatmentInd', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'ConnectedNumberTreatmentInd')), opt=True)
    _ServiceInteractionIndicatorsTwo_nonCUGCall = NULL(name=u'nonCUGCall', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ServiceInteractionIndicatorsTwo_holdTreatmentIndicator = OCT_STR(name=u'holdTreatmentIndicator', mode=MODE_TYPE, tag=(50, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ServiceInteractionIndicatorsTwo_holdTreatmentIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _ServiceInteractionIndicatorsTwo_cwTreatmentIndicator = OCT_STR(name=u'cwTreatmentIndicator', mode=MODE_TYPE, tag=(51, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ServiceInteractionIndicatorsTwo_cwTreatmentIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    _ServiceInteractionIndicatorsTwo_ectTreatmentIndicator = OCT_STR(name=u'ectTreatmentIndicator', mode=MODE_TYPE, tag=(52, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _ServiceInteractionIndicatorsTwo_ectTreatmentIndicator._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    ServiceInteractionIndicatorsTwo._cont = ASN1Dict([
        (u'forwardServiceInteractionInd', _ServiceInteractionIndicatorsTwo_forwardServiceInteractionInd),
        (u'backwardServiceInteractionInd', _ServiceInteractionIndicatorsTwo_backwardServiceInteractionInd),
        (u'bothwayThroughConnectionInd', _ServiceInteractionIndicatorsTwo_bothwayThroughConnectionInd),
        (u'connectedNumberTreatmentInd', _ServiceInteractionIndicatorsTwo_connectedNumberTreatmentInd),
        (u'nonCUGCall', _ServiceInteractionIndicatorsTwo_nonCUGCall),
        (u'holdTreatmentIndicator', _ServiceInteractionIndicatorsTwo_holdTreatmentIndicator),
        (u'cwTreatmentIndicator', _ServiceInteractionIndicatorsTwo_cwTreatmentIndicator),
        (u'ectTreatmentIndicator', _ServiceInteractionIndicatorsTwo_ectTreatmentIndicator),
        ])
    ServiceInteractionIndicatorsTwo._ext = []
    
    #-----< SGSNCapabilities >-----#
    SGSNCapabilities = OCT_STR(name=u'SGSNCapabilities', mode=MODE_TYPE)
    SGSNCapabilities._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< SMS-AddressString >-----#
    SMS_AddressString = OCT_STR(name=u'SMS-AddressString', mode=MODE_TYPE, typeref=ASN1RefType(('MAP-CommonDataTypes', 'AddressString')))
    SMS_AddressString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=11)], ev=None, er=[])
    
    #-----< maxSMS-AddressStringLength >-----#
    maxSMS_AddressStringLength = INT(name=u'maxSMS-AddressStringLength', mode=MODE_VALUE)
    maxSMS_AddressStringLength._val = 11
    
    #-----< SMSEvent >-----#
    SMSEvent = SEQ(name=u'SMSEvent', mode=MODE_TYPE)
    _SMSEvent_eventTypeSMS = ENUM(name=u'eventTypeSMS', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'EventTypeSMS')))
    _SMSEvent_monitorMode = ENUM(name=u'monitorMode', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'MonitorMode')))
    SMSEvent._cont = ASN1Dict([
        (u'eventTypeSMS', _SMSEvent_eventTypeSMS),
        (u'monitorMode', _SMSEvent_monitorMode),
        ])
    SMSEvent._ext = None
    
    #-----< TariffSwitchInterval >-----#
    TariffSwitchInterval = INT(name=u'TariffSwitchInterval', mode=MODE_TYPE)
    TariffSwitchInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=86400)], ev=None, er=[])
    
    #-----< TimeAndTimezone >-----#
    TimeAndTimezone = OCT_STR(name=u'TimeAndTimezone', mode=MODE_TYPE, param=True)
    
    #-----< TimeIfNoTariffSwitch >-----#
    TimeIfNoTariffSwitch = INT(name=u'TimeIfNoTariffSwitch', mode=MODE_TYPE)
    TimeIfNoTariffSwitch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=864000)], ev=None, er=[])
    
    #-----< TimeIfTariffSwitch >-----#
    TimeIfTariffSwitch = SEQ(name=u'TimeIfTariffSwitch', mode=MODE_TYPE)
    _TimeIfTariffSwitch_timeSinceTariffSwitch = INT(name=u'timeSinceTariffSwitch', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TimeIfTariffSwitch_timeSinceTariffSwitch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=864000)], ev=None, er=[])
    _TimeIfTariffSwitch_tariffSwitchInterval = INT(name=u'tariffSwitchInterval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _TimeIfTariffSwitch_tariffSwitchInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=864000)], ev=None, er=[])
    TimeIfTariffSwitch._cont = ASN1Dict([
        (u'timeSinceTariffSwitch', _TimeIfTariffSwitch_timeSinceTariffSwitch),
        (u'tariffSwitchInterval', _TimeIfTariffSwitch_tariffSwitchInterval),
        ])
    TimeIfTariffSwitch._ext = None
    
    #-----< TimeInformation >-----#
    TimeInformation = CHOICE(name=u'TimeInformation', mode=MODE_TYPE)
    _TimeInformation_timeIfNoTariffSwitch = INT(name=u'timeIfNoTariffSwitch', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'TimeIfNoTariffSwitch')))
    _TimeInformation_timeIfTariffSwitch = SEQ(name=u'timeIfTariffSwitch', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'TimeIfTariffSwitch')))
    TimeInformation._cont = ASN1Dict([
        (u'timeIfNoTariffSwitch', _TimeInformation_timeIfNoTariffSwitch),
        (u'timeIfTariffSwitch', _TimeInformation_timeIfTariffSwitch),
        ])
    TimeInformation._ext = None
    
    #-----< TimerID >-----#
    TimerID = ENUM(name=u'TimerID', mode=MODE_TYPE)
    TimerID._cont = ASN1Dict([(u'tssf', 0)])
    TimerID._ext = None
    
    #-----< TimerValue >-----#
    TimerValue = INT(name=u'TimerValue', mode=MODE_TYPE, typeref=ASN1RefType(('CS1-DataTypes', 'Integer4')))
    
    #-----< Tone >-----#
    Tone = SEQ(name=u'Tone', mode=MODE_TYPE)
    _Tone_toneID = INT(name=u'toneID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CS1-DataTypes', 'Integer4')))
    _Tone_duration = INT(name=u'duration', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CS1-DataTypes', 'Integer4')), opt=True)
    Tone._cont = ASN1Dict([
        (u'toneID', _Tone_toneID),
        (u'duration', _Tone_duration),
        ])
    Tone._ext = []
    
    #-----< TPDataCodingScheme >-----#
    TPDataCodingScheme = OCT_STR(name=u'TPDataCodingScheme', mode=MODE_TYPE)
    TPDataCodingScheme._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< TPProtocolIdentifier >-----#
    TPProtocolIdentifier = OCT_STR(name=u'TPProtocolIdentifier', mode=MODE_TYPE)
    TPProtocolIdentifier._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< TPShortMessageSpecificInfo >-----#
    TPShortMessageSpecificInfo = OCT_STR(name=u'TPShortMessageSpecificInfo', mode=MODE_TYPE)
    TPShortMessageSpecificInfo._const_sz = ASN1Set(rv=[1], rr=[], ev=None, er=[])
    
    #-----< TPValidityPeriod >-----#
    TPValidityPeriod = OCT_STR(name=u'TPValidityPeriod', mode=MODE_TYPE)
    TPValidityPeriod._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=7)], ev=None, er=[])
    
    #-----< TransferredVolume >-----#
    TransferredVolume = CHOICE(name=u'TransferredVolume', mode=MODE_TYPE)
    _TransferredVolume_volumeIfNoTariffSwitch = INT(name=u'volumeIfNoTariffSwitch', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TransferredVolume_volumeIfNoTariffSwitch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _TransferredVolume_volumeIfTariffSwitch = SEQ(name=u'volumeIfTariffSwitch', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __TransferredVolume_volumeIfTariffSwitch_volumeSinceLastTariffSwitch = INT(name=u'volumeSinceLastTariffSwitch', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __TransferredVolume_volumeIfTariffSwitch_volumeSinceLastTariffSwitch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    __TransferredVolume_volumeIfTariffSwitch_volumeTariffSwitchInterval = INT(name=u'volumeTariffSwitchInterval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TransferredVolume_volumeIfTariffSwitch_volumeTariffSwitchInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    _TransferredVolume_volumeIfTariffSwitch._cont = ASN1Dict([
        (u'volumeSinceLastTariffSwitch', __TransferredVolume_volumeIfTariffSwitch_volumeSinceLastTariffSwitch),
        (u'volumeTariffSwitchInterval', __TransferredVolume_volumeIfTariffSwitch_volumeTariffSwitchInterval),
        ])
    _TransferredVolume_volumeIfTariffSwitch._ext = None
    TransferredVolume._cont = ASN1Dict([
        (u'volumeIfNoTariffSwitch', _TransferredVolume_volumeIfNoTariffSwitch),
        (u'volumeIfTariffSwitch', _TransferredVolume_volumeIfTariffSwitch),
        ])
    TransferredVolume._ext = None
    
    #-----< TransferredVolumeRollOver >-----#
    TransferredVolumeRollOver = CHOICE(name=u'TransferredVolumeRollOver', mode=MODE_TYPE)
    _TransferredVolumeRollOver_rO_VolumeIfNoTariffSwitch = INT(name=u'rO-VolumeIfNoTariffSwitch', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _TransferredVolumeRollOver_rO_VolumeIfNoTariffSwitch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _TransferredVolumeRollOver_rO_VolumeIfTariffSwitch = SEQ(name=u'rO-VolumeIfTariffSwitch', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __TransferredVolumeRollOver_rO_VolumeIfTariffSwitch_rO_VolumeSinceLastTariffSwitch = INT(name=u'rO-VolumeSinceLastTariffSwitch', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TransferredVolumeRollOver_rO_VolumeIfTariffSwitch_rO_VolumeSinceLastTariffSwitch._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    __TransferredVolumeRollOver_rO_VolumeIfTariffSwitch_rO_VolumeTariffSwitchInterval = INT(name=u'rO-VolumeTariffSwitchInterval', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __TransferredVolumeRollOver_rO_VolumeIfTariffSwitch_rO_VolumeTariffSwitchInterval._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=None, er=[])
    _TransferredVolumeRollOver_rO_VolumeIfTariffSwitch._cont = ASN1Dict([
        (u'rO-VolumeSinceLastTariffSwitch', __TransferredVolumeRollOver_rO_VolumeIfTariffSwitch_rO_VolumeSinceLastTariffSwitch),
        (u'rO-VolumeTariffSwitchInterval', __TransferredVolumeRollOver_rO_VolumeIfTariffSwitch_rO_VolumeTariffSwitchInterval),
        ])
    _TransferredVolumeRollOver_rO_VolumeIfTariffSwitch._ext = None
    TransferredVolumeRollOver._cont = ASN1Dict([
        (u'rO-VolumeIfNoTariffSwitch', _TransferredVolumeRollOver_rO_VolumeIfNoTariffSwitch),
        (u'rO-VolumeIfTariffSwitch', _TransferredVolumeRollOver_rO_VolumeIfTariffSwitch),
        ])
    TransferredVolumeRollOver._ext = None
    
    #-----< UnavailableNetworkResource >-----#
    UnavailableNetworkResource = ENUM(name=u'UnavailableNetworkResource', mode=MODE_TYPE)
    UnavailableNetworkResource._cont = ASN1Dict([(u'unavailableResources', 0), (u'componentFailure', 1), (u'basicCallProcessingException', 2), (u'resourceStatusFailure', 3), (u'endUserFailure', 4)])
    UnavailableNetworkResource._ext = None
    
    #-----< VariablePart >-----#
    VariablePart = CHOICE(name=u'VariablePart', mode=MODE_TYPE, param=True)
    
    #-----< numOfInfoItems >-----#
    numOfInfoItems = INT(name=u'numOfInfoItems', mode=MODE_VALUE)
    numOfInfoItems._val = 4
    
    _all_ = [
        AlertingPattern,
        _AOCBeforeAnswer_aOCInitial,
        _AOCBeforeAnswer_aOCSubsequent,
        AOCBeforeAnswer,
        _AOCGPRS_aOCInitial,
        _AOCGPRS_aOCSubsequent,
        AOCGPRS,
        _AOCSubsequent_cAI_GSM0224,
        _AOCSubsequent_tariffSwitchInterval,
        AOCSubsequent,
        AppendFreeFormatData,
        ApplicationTimer,
        _AudibleIndicator_tone,
        _AudibleIndicator_burstList,
        AudibleIndicator,
        _BackwardServiceInteractionInd_conferenceTreatmentIndicator,
        _BackwardServiceInteractionInd_callCompletionTreatmentIndicator,
        BackwardServiceInteractionInd,
        _Burst_numberOfBursts,
        _Burst_burstInterval,
        _Burst_numberOfTonesInBurst,
        _Burst_toneDuration,
        _Burst_toneInterval,
        Burst,
        _BurstList_warningPeriod,
        _BurstList_bursts,
        BurstList,
        _CAI_GSM0224_e1,
        _CAI_GSM0224_e2,
        _CAI_GSM0224_e3,
        _CAI_GSM0224_e4,
        _CAI_GSM0224_e5,
        _CAI_GSM0224_e6,
        _CAI_GSM0224_e7,
        CAI_GSM0224,
        _CAMEL_SCIBillingChargingCharacteristics_aOCBeforeAnswer,
        _CAMEL_SCIBillingChargingCharacteristics_aOCAfterAnswer,
        _CAMEL_SCIBillingChargingCharacteristics_aOC_extension,
        CAMEL_SCIBillingChargingCharacteristics,
        CAMEL_SCIBillingChargingCharacteristicsAlt,
        _CAMEL_SCIGPRSBillingChargingCharacteristics_aOCGPRS,
        _CAMEL_SCIGPRSBillingChargingCharacteristics_pDPID,
        CAMEL_SCIGPRSBillingChargingCharacteristics,
        CGEncountered,
        _ChangeOfLocation_cellGlobalId,
        _ChangeOfLocation_serviceAreaId,
        _ChangeOfLocation_locationAreaId,
        _ChangeOfLocation_inter_SystemHandOver,
        _ChangeOfLocation_inter_PLMNHandOver,
        _ChangeOfLocation_inter_MSCHandOver,
        _ChangeOfLocation_changeOfLocationAlt,
        ChangeOfLocation,
        ChangeOfLocationAlt,
        ChargeIndicator,
        _ChargingCharacteristics_maxTransferredVolume,
        _ChargingCharacteristics_maxElapsedTime,
        ChargingCharacteristics,
        _ChargingResult_transferredVolume,
        _ChargingResult_elapsedTime,
        ChargingResult,
        _ChargingRollOver_transferredVolumeRollOver,
        _ChargingRollOver_elapsedTimeRollOver,
        ChargingRollOver,
        _CollectedDigits_minimumNbOfDigits,
        _CollectedDigits_maximumNbOfDigits,
        _CollectedDigits_endOfReplyDigit,
        _CollectedDigits_cancelDigit,
        _CollectedDigits_startDigit,
        _CollectedDigits_firstDigitTimeOut,
        _CollectedDigits_interDigitTimeOut,
        _CollectedDigits_errorTreatment,
        _CollectedDigits_interruptableAnnInd,
        _CollectedDigits_voiceInformation,
        _CollectedDigits_voiceBack,
        CollectedDigits,
        _CollectedInfo_collectedDigits,
        CollectedInfo,
        ConnectedNumberTreatmentInd,
        ControlType,
        DateAndTime,
        _ElapsedTime_timeGPRSIfNoTariffSwitch,
        __ElapsedTime_timeGPRSIfTariffSwitch_timeGPRSSinceLastTariffSwitch,
        __ElapsedTime_timeGPRSIfTariffSwitch_timeGPRSTariffSwitchInterval,
        _ElapsedTime_timeGPRSIfTariffSwitch,
        ElapsedTime,
        _ElapsedTimeRollOver_rO_TimeGPRSIfNoTariffSwitch,
        __ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch_rO_TimeGPRSSinceLastTariffSwitch,
        __ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch_rO_TimeGPRSTariffSwitchInterval,
        _ElapsedTimeRollOver_rO_TimeGPRSIfTariffSwitch,
        ElapsedTimeRollOver,
        ErrorTreatment,
        __EventSpecificInformationSMS_o_smsFailureSpecificInfo_failureCause,
        _EventSpecificInformationSMS_o_smsFailureSpecificInfo,
        _EventSpecificInformationSMS_o_smsSubmissionSpecificInfo,
        __EventSpecificInformationSMS_t_smsFailureSpecificInfo_failureCause,
        _EventSpecificInformationSMS_t_smsFailureSpecificInfo,
        _EventSpecificInformationSMS_t_smsDeliverySpecificInfo,
        EventSpecificInformationSMS,
        EventTypeBCSM,
        EventTypeSMS,
        __ExtensionField_type_tab,
        ___ExtensionField_type_tab_val_ExtensionType_0,
        _ExtensionField_type,
        _ExtensionField_criticality,
        _ExtensionField_value,
        ExtensionField,
        _ForwardServiceInteractionInd_conferenceTreatmentIndicator,
        _ForwardServiceInteractionInd_callDiversionTreatmentIndicator,
        _ForwardServiceInteractionInd_callingPartyRestrictionIndicator,
        ForwardServiceInteractionInd,
        _GapIndicators_duration,
        _GapIndicators_gapInterval,
        GapIndicators,
        _GapOnService_serviceKey,
        GapOnService,
        _GPRS_QoS_short_QoS_format,
        _GPRS_QoS_long_QoS_format,
        GPRS_QoS,
        _GPRS_QoS_Extension_supplement_to_long_QoS_format,
        _GPRS_QoS_Extension_additionalSupplement,
        GPRS_QoS_Extension,
        _GPRSEvent_gPRSEventType,
        _GPRSEvent_monitorMode,
        GPRSEvent,
        GPRSEventType,
        InitiatingEntity,
        InitiatorOfServiceChange,
        InvokeID,
        LegType,
        leg1,
        leg2,
        _LocationInformationGPRS_cellGlobalIdOrServiceAreaIdOrLAI,
        _LocationInformationGPRS_routeingAreaIdentity,
        _LocationInformationGPRS_geographicalInformation,
        _LocationInformationGPRS_sgsn_Number,
        _LocationInformationGPRS_selectedLSAIdentity,
        _LocationInformationGPRS_extensionContainer,
        _LocationInformationGPRS_sai_Present,
        _LocationInformationGPRS_userCSGInformation,
        LocationInformationGPRS,
        UserCSGInformation,
        _MetDPCriterion_enteringCellGlobalId,
        _MetDPCriterion_leavingCellGlobalId,
        _MetDPCriterion_enteringServiceAreaId,
        _MetDPCriterion_leavingServiceAreaId,
        _MetDPCriterion_enteringLocationAreaId,
        _MetDPCriterion_leavingLocationAreaId,
        _MetDPCriterion_inter_SystemHandOverToUMTS,
        _MetDPCriterion_inter_SystemHandOverToGSM,
        _MetDPCriterion_inter_PLMNHandOver,
        _MetDPCriterion_inter_MSCHandOver,
        _MetDPCriterion_metDPCriterionAlt,
        MetDPCriterion,
        MetDPCriterionAlt,
        _MidCallControlInfo_minimumNumberOfDigits,
        _MidCallControlInfo_maximumNumberOfDigits,
        _MidCallControlInfo_endOfReplyDigit,
        _MidCallControlInfo_cancelDigit,
        _MidCallControlInfo_startDigit,
        _MidCallControlInfo_interDigitTimeout,
        MidCallControlInfo,
        MonitorMode,
        MO_SMSCause,
        MT_SMSCause,
        NAOliInfo,
        NatureOfServiceChange,
        NumberOfDigits,
        OCSIApplicable,
        PDPID,
        PDPInitiationType,
        _QualityOfService_requested_QoS,
        _QualityOfService_subscribed_QoS,
        _QualityOfService_negotiated_QoS,
        _QualityOfService_requested_QoS_Extension,
        _QualityOfService_subscribed_QoS_Extension,
        _QualityOfService_negotiated_QoS_Extension,
        QualityOfService,
        _ReceivingSideID_receivingSideID,
        ReceivingSideID,
        _RequestedInformationTypeList__item_,
        RequestedInformationTypeList,
        RequestedInformationType,
        RPCause,
        _SendingSideID_sendingSideID,
        SendingSideID,
        _ServiceInteractionIndicatorsTwo_forwardServiceInteractionInd,
        _ServiceInteractionIndicatorsTwo_backwardServiceInteractionInd,
        _ServiceInteractionIndicatorsTwo_bothwayThroughConnectionInd,
        _ServiceInteractionIndicatorsTwo_connectedNumberTreatmentInd,
        _ServiceInteractionIndicatorsTwo_nonCUGCall,
        _ServiceInteractionIndicatorsTwo_holdTreatmentIndicator,
        _ServiceInteractionIndicatorsTwo_cwTreatmentIndicator,
        _ServiceInteractionIndicatorsTwo_ectTreatmentIndicator,
        ServiceInteractionIndicatorsTwo,
        SGSNCapabilities,
        SMS_AddressString,
        maxSMS_AddressStringLength,
        _SMSEvent_eventTypeSMS,
        _SMSEvent_monitorMode,
        SMSEvent,
        TariffSwitchInterval,
        TimeIfNoTariffSwitch,
        _TimeIfTariffSwitch_timeSinceTariffSwitch,
        _TimeIfTariffSwitch_tariffSwitchInterval,
        TimeIfTariffSwitch,
        _TimeInformation_timeIfNoTariffSwitch,
        _TimeInformation_timeIfTariffSwitch,
        TimeInformation,
        TimerID,
        TimerValue,
        _Tone_toneID,
        _Tone_duration,
        Tone,
        TPDataCodingScheme,
        TPProtocolIdentifier,
        TPShortMessageSpecificInfo,
        TPValidityPeriod,
        _TransferredVolume_volumeIfNoTariffSwitch,
        __TransferredVolume_volumeIfTariffSwitch_volumeSinceLastTariffSwitch,
        __TransferredVolume_volumeIfTariffSwitch_volumeTariffSwitchInterval,
        _TransferredVolume_volumeIfTariffSwitch,
        TransferredVolume,
        _TransferredVolumeRollOver_rO_VolumeIfNoTariffSwitch,
        __TransferredVolumeRollOver_rO_VolumeIfTariffSwitch_rO_VolumeSinceLastTariffSwitch,
        __TransferredVolumeRollOver_rO_VolumeIfTariffSwitch_rO_VolumeTariffSwitchInterval,
        _TransferredVolumeRollOver_rO_VolumeIfTariffSwitch,
        TransferredVolumeRollOver,
        UnavailableNetworkResource,
        numOfInfoItems,
    ]

class CAP_classes:

    _name_  = u'CAP-classes'
    _oid_   = [0, 4, 0, 0, 1, 3, 54, 7]
    
    _obj_ = [
        u'gsmSSF',
        u'gsmSRF',
        u'smsSSF-V3',
        u'smsSSF-V4',
        u'gprsSSF',
        u'EXTENSION',
        u'firstExtension',
        u'SupportedExtensions',
        u'PARAMETERS-BOUND',
        u'cAPSpecificBoundSet',
        ]
    _type_ = [
        u'EXTENSION',
        u'PARAMETERS-BOUND',
        ]
    _set_ = [
        u'SupportedExtensions',
        ]
    _val_ = [
        u'gsmSSF',
        u'gsmSRF',
        u'smsSSF-V3',
        u'smsSSF-V4',
        u'gprsSSF',
        u'firstExtension',
        u'cAPSpecificBoundSet',
        ]
    _class_ = [
        u'gsmSSF',
        u'gsmSRF',
        u'smsSSF-V3',
        u'smsSSF-V4',
        u'gprsSSF',
        u'EXTENSION',
        u'firstExtension',
        u'SupportedExtensions',
        u'PARAMETERS-BOUND',
        u'cAPSpecificBoundSet',
        ]
    _param_ = [
        ]
    
    #-----< gsmSSF >-----#
    gsmSSF = CLASS(name=u'gsmSSF', mode=MODE_VALUE, typeref=ASN1RefType(('Remote-Operations-Information-Objects', 'ROS-OBJECT-CLASS')))
    __OPERATION_PACKAGE_Supplier_val_ArgumentType_0 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('CAP-gsmSSF-gsmSCF-ops-args', 'EntityReleasedArg')))
    ___OPERATION_PACKAGE_Supplier_val_ArgumentType_0_callSegmentFailure = SEQ(name=u'callSegmentFailure', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CAP-datatypes', 'CallSegmentF