# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class CryptographicMessageSyntax_2009:

    _name_  = u'CryptographicMessageSyntax-2009'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 41]
    
    _obj_ = [
        u'CONTENT-TYPE',
        u'ContentType',
        u'ContentInfo',
        u'ContentSet',
        u'SignedData',
        u'SignerInfos',
        u'EncapsulatedContentInfo',
        u'SignerInfo',
        u'SignedAttributes',
        u'SignerIdentifier',
        u'SignedAttributesSet',
        u'UnsignedAttributes',
        u'SignatureValue',
        u'EnvelopedData',
        u'OriginatorInfo',
        u'RecipientInfos',
        u'EncryptedContentInfo',
        u'UnprotectedAttributes',
        u'RecipientInfo',
        u'EncryptedKey',
        u'KeyTransRecipientInfo',
        u'KeyTransportAlgorithmSet',
        u'RecipientIdentifier',
        u'KeyAgreeRecipientInfo',
        u'KeyAgreementAlgorithmSet',
        u'OriginatorIdentifierOrKey',
        u'OriginatorPublicKey',
        u'OriginatorKeySet',
        u'RecipientEncryptedKeys',
        u'RecipientEncryptedKey',
        u'KeyAgreeRecipientIdentifier',
        u'RecipientKeyIdentifier',
        u'SubjectKeyIdentifier',
        u'KEKRecipientInfo',
        u'KEKIdentifier',
        u'PasswordRecipientInfo',
        u'OTHER-RECIPIENT',
        u'OtherRecipientInfo',
        u'SupportedOtherRecipInfo',
        u'DigestedData',
        u'Digest',
        u'EncryptedData',
        u'AuthenticatedData',
        u'AuthAttributes',
        u'AuthAttributeSet',
        u'MessageAuthenticationCode',
        u'UnauthAttributes',
        u'UnauthAttributeSet',
        u'DigestAlgorithmIdentifier',
        u'DigestAlgorithmSet',
        u'SignatureAlgorithmIdentifier',
        u'SignatureAlgorithmSet',
        u'KeyEncryptionAlgorithmIdentifier',
        u'KeyEncryptionAlgorithmSet',
        u'ContentEncryptionAlgorithmIdentifier',
        u'ContentEncryptionAlgorithmSet',
        u'MessageAuthenticationCodeAlgorithm',
        u'MessageAuthenticationCodeAlgorithmSet',
        u'KeyDerivationAlgorithmIdentifier',
        u'RevocationInfoChoices',
        u'RevocationInfoChoice',
        u'OTHER-REVOK-INFO',
        u'OtherRevocationInfoFormat',
        u'SupportedOtherRevokInfo',
        u'CertificateChoices',
        u'AttributeCertificateV2',
        u'OTHER-CERT-FMT',
        u'OtherCertificateFormat',
        u'SupportedCertFormats',
        u'CertificateSet',
        u'IssuerAndSerialNumber',
        u'CMSVersion',
        u'UserKeyingMaterial',
        u'KEY-ATTRIBUTE',
        u'OtherKeyAttribute',
        u'SupportedKeyAttributes',
        u'id-ct-contentInfo',
        u'ct-Data',
        u'id-data',
        u'ct-SignedData',
        u'id-signedData',
        u'ct-EnvelopedData',
        u'id-envelopedData',
        u'ct-DigestedData',
        u'id-digestedData',
        u'ct-EncryptedData',
        u'id-encryptedData',
        u'ct-AuthenticatedData',
        u'id-ct-authData',
        u'MessageDigest',
        u'SigningTime',
        u'Time',
        u'Countersignature',
        u'aa-contentType',
        u'id-contentType',
        u'aa-messageDigest',
        u'id-messageDigest',
        u'aa-signingTime',
        u'id-signingTime',
        u'aa-countersignature',
        u'id-countersignature',
        u'ExtendedCertificateOrCertificate',
        u'ExtendedCertificate',
        u'ExtendedCertificateInfo',
        u'Signature',
        u'Attribute',
        u'Attributes',
        ]
    _type_ = [
        u'CONTENT-TYPE',
        u'ContentType',
        u'ContentInfo',
        u'SignedData',
        u'SignerInfos',
        u'EncapsulatedContentInfo',
        u'SignerInfo',
        u'SignedAttributes',
        u'SignerIdentifier',
        u'SignatureValue',
        u'EnvelopedData',
        u'OriginatorInfo',
        u'RecipientInfos',
        u'EncryptedContentInfo',
        u'RecipientInfo',
        u'EncryptedKey',
        u'KeyTransRecipientInfo',
        u'RecipientIdentifier',
        u'KeyAgreeRecipientInfo',
        u'OriginatorIdentifierOrKey',
        u'OriginatorPublicKey',
        u'RecipientEncryptedKeys',
        u'RecipientEncryptedKey',
        u'KeyAgreeRecipientIdentifier',
        u'RecipientKeyIdentifier',
        u'SubjectKeyIdentifier',
        u'KEKRecipientInfo',
        u'KEKIdentifier',
        u'PasswordRecipientInfo',
        u'OTHER-RECIPIENT',
        u'OtherRecipientInfo',
        u'DigestedData',
        u'Digest',
        u'EncryptedData',
        u'AuthenticatedData',
        u'AuthAttributes',
        u'MessageAuthenticationCode',
        u'UnauthAttributes',
        u'DigestAlgorithmIdentifier',
        u'SignatureAlgorithmIdentifier',
        u'KeyEncryptionAlgorithmIdentifier',
        u'ContentEncryptionAlgorithmIdentifier',
        u'MessageAuthenticationCodeAlgorithm',
        u'KeyDerivationAlgorithmIdentifier',
        u'RevocationInfoChoices',
        u'RevocationInfoChoice',
        u'OTHER-REVOK-INFO',
        u'OtherRevocationInfoFormat',
        u'CertificateChoices',
        u'AttributeCertificateV2',
        u'OTHER-CERT-FMT',
        u'OtherCertificateFormat',
        u'CertificateSet',
        u'IssuerAndSerialNumber',
        u'CMSVersion',
        u'UserKeyingMaterial',
        u'KEY-ATTRIBUTE',
        u'OtherKeyAttribute',
        u'MessageDigest',
        u'SigningTime',
        u'Time',
        u'Countersignature',
        u'ExtendedCertificateOrCertificate',
        u'ExtendedCertificate',
        u'ExtendedCertificateInfo',
        u'Signature',
        u'Attribute',
        u'Attributes',
        ]
    _set_ = [
        u'ContentSet',
        u'SignedAttributesSet',
        u'UnsignedAttributes',
        u'UnprotectedAttributes',
        u'KeyTransportAlgorithmSet',
        u'KeyAgreementAlgorithmSet',
        u'OriginatorKeySet',
        u'SupportedOtherRecipInfo',
        u'AuthAttributeSet',
        u'UnauthAttributeSet',
        u'DigestAlgorithmSet',
        u'SignatureAlgorithmSet',
        u'KeyEncryptionAlgorithmSet',
        u'ContentEncryptionAlgorithmSet',
        u'MessageAuthenticationCodeAlgorithmSet',
        u'SupportedOtherRevokInfo',
        u'SupportedCertFormats',
        u'SupportedKeyAttributes',
        ]
    _val_ = [
        u'id-ct-contentInfo',
        u'ct-Data',
        u'id-data',
        u'ct-SignedData',
        u'id-signedData',
        u'ct-EnvelopedData',
        u'id-envelopedData',
        u'ct-DigestedData',
        u'id-digestedData',
        u'ct-EncryptedData',
        u'id-encryptedData',
        u'ct-AuthenticatedData',
        u'id-ct-authData',
        u'aa-contentType',
        u'id-contentType',
        u'aa-messageDigest',
        u'id-messageDigest',
        u'aa-signingTime',
        u'id-signingTime',
        u'aa-countersignature',
        u'id-countersignature',
        ]
    _class_ = [
        u'CONTENT-TYPE',
        u'ContentSet',
        u'SignedAttributesSet',
        u'UnsignedAttributes',
        u'UnprotectedAttributes',
        u'KeyTransportAlgorithmSet',
        u'KeyAgreementAlgorithmSet',
        u'OriginatorKeySet',
        u'OTHER-RECIPIENT',
        u'SupportedOtherRecipInfo',
        u'AuthAttributeSet',
        u'UnauthAttributeSet',
        u'DigestAlgorithmSet',
        u'SignatureAlgorithmSet',
        u'KeyEncryptionAlgorithmSet',
        u'ContentEncryptionAlgorithmSet',
        u'MessageAuthenticationCodeAlgorithmSet',
        u'OTHER-REVOK-INFO',
        u'SupportedOtherRevokInfo',
        u'OTHER-CERT-FMT',
        u'SupportedCertFormats',
        u'KEY-ATTRIBUTE',
        u'SupportedKeyAttributes',
        u'ct-Data',
        u'ct-SignedData',
        u'ct-EnvelopedData',
        u'ct-DigestedData',
        u'ct-EncryptedData',
        u'ct-AuthenticatedData',
        u'aa-contentType',
        u'aa-messageDigest',
        u'aa-signingTime',
        u'aa-countersignature',
        ]
    _param_ = [
        u'Attribute',
        u'Attributes',
        ]
    
    #-----< CONTENT-TYPE >-----#
    CONTENT_TYPE = CLASS(name=u'CONTENT-TYPE', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< ContentType >-----#
    ContentType = OID(name=u'ContentType', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'id']))
    
    #-----< ContentInfo >-----#
    ContentInfo = SEQ(name=u'ContentInfo', mode=MODE_TYPE)
    _ContentInfo_contentType = OID(name=u'contentType', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'id']))
    __ContentInfo_contentType_tab = CLASS(name='_tab_CONTENT-TYPE', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    ___ContentInfo_contentType_tab_val_Type_0 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___ContentInfo_contentType_tab_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedData')))
    ___ContentInfo_contentType_tab_val_Type_2 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedData')))
    ___ContentInfo_contentType_tab_val_Type_3 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EnvelopedData')))
    ___ContentInfo_contentType_tab_val_Type_4 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthenticatedData')))
    ___ContentInfo_contentType_tab_val_Type_5 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestedData')))
    __ContentInfo_contentType_tab._val = ASN1Set(rv=[dict([('Type', ___ContentInfo_contentType_tab_val_Type_0), ('id', (1, 2, 840, 113549, 1, 7, 1))]), dict([('Type', ___ContentInfo_contentType_tab_val_Type_1), ('id', (1, 2, 840, 113549, 1, 7, 2))]), dict([('Type', ___ContentInfo_contentType_tab_val_Type_2), ('id', (1, 2, 840, 113549, 1, 7, 6))]), dict([('Type', ___ContentInfo_contentType_tab_val_Type_3), ('id', (1, 2, 840, 113549, 1, 7, 3))]), dict([('Type', ___ContentInfo_contentType_tab_val_Type_4), ('id', (1, 2, 840, 113549, 1, 9, 16, 1, 2))]), dict([('Type', ___ContentInfo_contentType_tab_val_Type_5), ('id', (1, 2, 840, 113549, 1, 7, 5))])], rr=[], ev=None, er=[])
    _ContentInfo_contentType._const_tab = __ContentInfo_contentType_tab
    _ContentInfo_contentType._const_tab_at = None
    _ContentInfo_contentType._const_tab_id = u'id'
    _ContentInfo_content = OPEN(name=u'content', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'Type']))
    _ContentInfo_content._const_tab = __ContentInfo_contentType_tab
    _ContentInfo_content._const_tab_at = ('..', u'contentType')
    _ContentInfo_content._const_tab_id = u'Type'
    ContentInfo._cont = ASN1Dict([
        (u'contentType', _ContentInfo_contentType),
        (u'content', _ContentInfo_content),
        ])
    ContentInfo._ext = None
    
    #-----< ContentSet >-----#
    ContentSet = CLASS(name=u'ContentSet', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ContentSet_val_Type_0 = OCT_STR(name='Type', mode=MODE_TYPE)
    _ContentSet_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedData')))
    _ContentSet_val_Type_2 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedData')))
    _ContentSet_val_Type_3 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EnvelopedData')))
    _ContentSet_val_Type_4 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthenticatedData')))
    _ContentSet_val_Type_5 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestedData')))
    ContentSet._val = ASN1Set(rv=[dict([('Type', _ContentSet_val_Type_0), ('id', (1, 2, 840, 113549, 1, 7, 1))]), dict([('Type', _ContentSet_val_Type_1), ('id', (1, 2, 840, 113549, 1, 7, 2))]), dict([('Type', _ContentSet_val_Type_2), ('id', (1, 2, 840, 113549, 1, 7, 6))]), dict([('Type', _ContentSet_val_Type_3), ('id', (1, 2, 840, 113549, 1, 7, 3))]), dict([('Type', _ContentSet_val_Type_4), ('id', (1, 2, 840, 113549, 1, 9, 16, 1, 2))]), dict([('Type', _ContentSet_val_Type_5), ('id', (1, 2, 840, 113549, 1, 7, 5))])], rr=[], ev=[], er=[])
    
    #-----< SignedData >-----#
    SignedData = SEQ(name=u'SignedData', mode=MODE_TYPE)
    _SignedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _SignedData_digestAlgorithms = SET_OF(name=u'digestAlgorithms', mode=MODE_TYPE)
    __SignedData_digestAlgorithms__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestAlgorithmIdentifier')))
    _SignedData_digestAlgorithms._cont = __SignedData_digestAlgorithms__item_
    _SignedData_encapContentInfo = SEQ(name=u'encapContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncapsulatedContentInfo')))
    _SignedData_certificates = SET_OF(name=u'certificates', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CertificateSet')), opt=True)
    _SignedData_crls = SET_OF(name=u'crls', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RevocationInfoChoices')), opt=True)
    _SignedData_signerInfos = SET_OF(name=u'signerInfos', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignerInfos')))
    SignedData._cont = ASN1Dict([
        (u'version', _SignedData_version),
        (u'digestAlgorithms', _SignedData_digestAlgorithms),
        (u'encapContentInfo', _SignedData_encapContentInfo),
        (u'certificates', _SignedData_certificates),
        (u'crls', _SignedData_crls),
        (u'signerInfos', _SignedData_signerInfos),
        ])
    SignedData._ext = None
    
    #-----< SignerInfos >-----#
    SignerInfos = SET_OF(name=u'SignerInfos', mode=MODE_TYPE)
    _SignerInfos__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignerInfo')))
    SignerInfos._cont = _SignerInfos__item_
    
    #-----< EncapsulatedContentInfo >-----#
    EncapsulatedContentInfo = SEQ(name=u'EncapsulatedContentInfo', mode=MODE_TYPE)
    _EncapsulatedContentInfo_eContentType = OID(name=u'eContentType', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'id']))
    __EncapsulatedContentInfo_eContentType_tab = CLASS(name='_tab_CONTENT-TYPE', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_0 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedData')))
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_2 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedData')))
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_3 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EnvelopedData')))
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_4 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthenticatedData')))
    ___EncapsulatedContentInfo_eContentType_tab_val_Type_5 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestedData')))
    __EncapsulatedContentInfo_eContentType_tab._val = ASN1Set(rv=[dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_0), ('id', (1, 2, 840, 113549, 1, 7, 1))]), dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_1), ('id', (1, 2, 840, 113549, 1, 7, 2))]), dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_2), ('id', (1, 2, 840, 113549, 1, 7, 6))]), dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_3), ('id', (1, 2, 840, 113549, 1, 7, 3))]), dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_4), ('id', (1, 2, 840, 113549, 1, 9, 16, 1, 2))]), dict([('Type', ___EncapsulatedContentInfo_eContentType_tab_val_Type_5), ('id', (1, 2, 840, 113549, 1, 7, 5))])], rr=[], ev=None, er=[])
    _EncapsulatedContentInfo_eContentType._const_tab = __EncapsulatedContentInfo_eContentType_tab
    _EncapsulatedContentInfo_eContentType._const_tab_at = None
    _EncapsulatedContentInfo_eContentType._const_tab_id = u'id'
    _EncapsulatedContentInfo_eContent = OCT_STR(name=u'eContent', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __EncapsulatedContentInfo_eContent_contain = OPEN(name='_cont_eContent', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'Type']))
    __EncapsulatedContentInfo_eContent_contain._const_tab = __EncapsulatedContentInfo_eContentType_tab
    __EncapsulatedContentInfo_eContent_contain._const_tab_at = ('..', u'eContentType')
    __EncapsulatedContentInfo_eContent_contain._const_tab_id = u'Type'
    _EncapsulatedContentInfo_eContent._const_cont = __EncapsulatedContentInfo_eContent_contain
    EncapsulatedContentInfo._cont = ASN1Dict([
        (u'eContentType', _EncapsulatedContentInfo_eContentType),
        (u'eContent', _EncapsulatedContentInfo_eContent),
        ])
    EncapsulatedContentInfo._ext = None
    
    #-----< SignerInfo >-----#
    SignerInfo = SEQ(name=u'SignerInfo', mode=MODE_TYPE)
    _SignerInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _SignerInfo_sid = CHOICE(name=u'sid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignerIdentifier')))
    _SignerInfo_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestAlgorithmIdentifier')))
    _SignerInfo_signedAttrs = SET_OF(name=u'signedAttrs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedAttributes')), opt=True)
    _SignerInfo_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignatureAlgorithmIdentifier')))
    _SignerInfo_signature = OCT_STR(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignatureValue')))
    _SignerInfo_unsignedAttrs = SET_OF(name=u'unsignedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attributes')), opt=True)
    __SignerInfo_unsignedAttrs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    ___SignerInfo_unsignedAttrs__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____SignerInfo_unsignedAttrs__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____SignerInfo_unsignedAttrs__item__attrType_tab_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Countersignature')))
    ____SignerInfo_unsignedAttrs__item__attrType_tab._val = ASN1Set(rv=[dict([(u'Type', _____SignerInfo_unsignedAttrs__item__attrType_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 6))])], rr=[], ev=None, er=[])
    ___SignerInfo_unsignedAttrs__item__attrType._const_tab = ____SignerInfo_unsignedAttrs__item__attrType_tab
    ___SignerInfo_unsignedAttrs__item__attrType._const_tab_at = None
    ___SignerInfo_unsignedAttrs__item__attrType._const_tab_id = u'id'
    ___SignerInfo_unsignedAttrs__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ____SignerInfo_unsignedAttrs__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ____SignerInfo_unsignedAttrs__item__attrValues__item_._const_tab = ____SignerInfo_unsignedAttrs__item__attrType_tab
    ____SignerInfo_unsignedAttrs__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ____SignerInfo_unsignedAttrs__item__attrValues__item_._const_tab_id = u'Type'
    ___SignerInfo_unsignedAttrs__item__attrValues._cont = ____SignerInfo_unsignedAttrs__item__attrValues__item_
    __SignerInfo_unsignedAttrs__item_._cont = ASN1Dict([
        (u'attrType', ___SignerInfo_unsignedAttrs__item__attrType),
        (u'attrValues', ___SignerInfo_unsignedAttrs__item__attrValues),
        ])
    __SignerInfo_unsignedAttrs__item_._ext = None
    _SignerInfo_unsignedAttrs._cont = __SignerInfo_unsignedAttrs__item_
    _SignerInfo_unsignedAttrs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    SignerInfo._cont = ASN1Dict([
        (u'version', _SignerInfo_version),
        (u'sid', _SignerInfo_sid),
        (u'digestAlgorithm', _SignerInfo_digestAlgorithm),
        (u'signedAttrs', _SignerInfo_signedAttrs),
        (u'signatureAlgorithm', _SignerInfo_signatureAlgorithm),
        (u'signature', _SignerInfo_signature),
        (u'unsignedAttrs', _SignerInfo_unsignedAttrs),
        ])
    SignerInfo._ext = None
    
    #-----< SignedAttributes >-----#
    SignedAttributes = SET_OF(name=u'SignedAttributes', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attributes')))
    _SignedAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    __SignedAttributes__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___SignedAttributes__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____SignedAttributes__item__attrType_tab_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SigningTime')))
    ____SignedAttributes__item__attrType_tab_val_Type_1 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageDigest')))
    ____SignedAttributes__item__attrType_tab_val_Type_2 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentType')))
    ___SignedAttributes__item__attrType_tab._val = ASN1Set(rv=[dict([(u'Type', ____SignedAttributes__item__attrType_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 5))]), dict([(u'Type', ____SignedAttributes__item__attrType_tab_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 4))]), dict([(u'Type', ____SignedAttributes__item__attrType_tab_val_Type_2), (u'id', (1, 2, 840, 113549, 1, 9, 3))])], rr=[], ev=None, er=[])
    __SignedAttributes__item__attrType._const_tab = ___SignedAttributes__item__attrType_tab
    __SignedAttributes__item__attrType._const_tab_at = None
    __SignedAttributes__item__attrType._const_tab_id = u'id'
    __SignedAttributes__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ___SignedAttributes__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ___SignedAttributes__item__attrValues__item_._const_tab = ___SignedAttributes__item__attrType_tab
    ___SignedAttributes__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ___SignedAttributes__item__attrValues__item_._const_tab_id = u'Type'
    __SignedAttributes__item__attrValues._cont = ___SignedAttributes__item__attrValues__item_
    _SignedAttributes__item_._cont = ASN1Dict([
        (u'attrType', __SignedAttributes__item__attrType),
        (u'attrValues', __SignedAttributes__item__attrValues),
        ])
    _SignedAttributes__item_._ext = None
    SignedAttributes._cont = _SignedAttributes__item_
    SignedAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< SignerIdentifier >-----#
    SignerIdentifier = CHOICE(name=u'SignerIdentifier', mode=MODE_TYPE)
    _SignerIdentifier_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    _SignerIdentifier_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SubjectKeyIdentifier')), group=0)
    SignerIdentifier._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _SignerIdentifier_issuerAndSerialNumber),
        (u'subjectKeyIdentifier', _SignerIdentifier_subjectKeyIdentifier),
        ])
    SignerIdentifier._ext = [u'subjectKeyIdentifier']
    
    #-----< SignedAttributesSet >-----#
    SignedAttributesSet = CLASS(name=u'SignedAttributesSet', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _SignedAttributesSet_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SigningTime')))
    _SignedAttributesSet_val_Type_1 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageDigest')))
    _SignedAttributesSet_val_Type_2 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentType')))
    SignedAttributesSet._val = ASN1Set(rv=[dict([(u'Type', _SignedAttributesSet_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 5))]), dict([(u'Type', _SignedAttributesSet_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 4))]), dict([(u'Type', _SignedAttributesSet_val_Type_2), (u'id', (1, 2, 840, 113549, 1, 9, 3))])], rr=[], ev=[], er=[])
    
    #-----< UnsignedAttributes >-----#
    UnsignedAttributes = CLASS(name=u'UnsignedAttributes', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _UnsignedAttributes_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Countersignature')))
    UnsignedAttributes._val = ASN1Set(rv=[dict([(u'Type', _UnsignedAttributes_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 6))])], rr=[], ev=[], er=[])
    
    #-----< SignatureValue >-----#
    SignatureValue = OCT_STR(name=u'SignatureValue', mode=MODE_TYPE)
    
    #-----< EnvelopedData >-----#
    EnvelopedData = SEQ(name=u'EnvelopedData', mode=MODE_TYPE)
    _EnvelopedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _EnvelopedData_originatorInfo = SEQ(name=u'originatorInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OriginatorInfo')), opt=True)
    _EnvelopedData_recipientInfos = SET_OF(name=u'recipientInfos', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientInfos')))
    _EnvelopedData_encryptedContentInfo = SEQ(name=u'encryptedContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedContentInfo')))
    _EnvelopedData_unprotectedAttrs = SET_OF(name=u'unprotectedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attributes')), opt=True, group=0)
    __EnvelopedData_unprotectedAttrs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    ___EnvelopedData_unprotectedAttrs__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____EnvelopedData_unprotectedAttrs__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____EnvelopedData_unprotectedAttrs__item__attrType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___EnvelopedData_unprotectedAttrs__item__attrType._const_tab = ____EnvelopedData_unprotectedAttrs__item__attrType_tab
    ___EnvelopedData_unprotectedAttrs__item__attrType._const_tab_at = None
    ___EnvelopedData_unprotectedAttrs__item__attrType._const_tab_id = u'id'
    ___EnvelopedData_unprotectedAttrs__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ____EnvelopedData_unprotectedAttrs__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    _____EnvelopedData_unprotectedAttrs__item__attrValues__item__tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____EnvelopedData_unprotectedAttrs__item__attrValues__item__tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____EnvelopedData_unprotectedAttrs__item__attrValues__item_._const_tab = _____EnvelopedData_unprotectedAttrs__item__attrValues__item__tab
    ____EnvelopedData_unprotectedAttrs__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ____EnvelopedData_unprotectedAttrs__item__attrValues__item_._const_tab_id = u'Type'
    ___EnvelopedData_unprotectedAttrs__item__attrValues._cont = ____EnvelopedData_unprotectedAttrs__item__attrValues__item_
    __EnvelopedData_unprotectedAttrs__item_._cont = ASN1Dict([
        (u'attrType', ___EnvelopedData_unprotectedAttrs__item__attrType),
        (u'attrValues', ___EnvelopedData_unprotectedAttrs__item__attrValues),
        ])
    __EnvelopedData_unprotectedAttrs__item_._ext = None
    _EnvelopedData_unprotectedAttrs._cont = __EnvelopedData_unprotectedAttrs__item_
    _EnvelopedData_unprotectedAttrs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    EnvelopedData._cont = ASN1Dict([
        (u'version', _EnvelopedData_version),
        (u'originatorInfo', _EnvelopedData_originatorInfo),
        (u'recipientInfos', _EnvelopedData_recipientInfos),
        (u'encryptedContentInfo', _EnvelopedData_encryptedContentInfo),
        (u'unprotectedAttrs', _EnvelopedData_unprotectedAttrs),
        ])
    EnvelopedData._ext = [u'unprotectedAttrs']
    
    #-----< OriginatorInfo >-----#
    OriginatorInfo = SEQ(name=u'OriginatorInfo', mode=MODE_TYPE)
    _OriginatorInfo_certs = SET_OF(name=u'certs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CertificateSet')), opt=True)
    _OriginatorInfo_crls = SET_OF(name=u'crls', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RevocationInfoChoices')), opt=True)
    OriginatorInfo._cont = ASN1Dict([
        (u'certs', _OriginatorInfo_certs),
        (u'crls', _OriginatorInfo_crls),
        ])
    OriginatorInfo._ext = None
    
    #-----< RecipientInfos >-----#
    RecipientInfos = SET_OF(name=u'RecipientInfos', mode=MODE_TYPE)
    _RecipientInfos__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientInfo')))
    RecipientInfos._cont = _RecipientInfos__item_
    RecipientInfos._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< EncryptedContentInfo >-----#
    EncryptedContentInfo = SEQ(name=u'EncryptedContentInfo', mode=MODE_TYPE)
    _EncryptedContentInfo_contentType = OID(name=u'contentType', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE'), [u'id']))
    __EncryptedContentInfo_contentType_tab = CLASS(name='_tab_CONTENT-TYPE', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    ___EncryptedContentInfo_contentType_tab_val_Type_0 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___EncryptedContentInfo_contentType_tab_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedData')))
    ___EncryptedContentInfo_contentType_tab_val_Type_2 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedData')))
    ___EncryptedContentInfo_contentType_tab_val_Type_3 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EnvelopedData')))
    ___EncryptedContentInfo_contentType_tab_val_Type_4 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthenticatedData')))
    ___EncryptedContentInfo_contentType_tab_val_Type_5 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestedData')))
    __EncryptedContentInfo_contentType_tab._val = ASN1Set(rv=[dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_0), ('id', (1, 2, 840, 113549, 1, 7, 1))]), dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_1), ('id', (1, 2, 840, 113549, 1, 7, 2))]), dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_2), ('id', (1, 2, 840, 113549, 1, 7, 6))]), dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_3), ('id', (1, 2, 840, 113549, 1, 7, 3))]), dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_4), ('id', (1, 2, 840, 113549, 1, 9, 16, 1, 2))]), dict([('Type', ___EncryptedContentInfo_contentType_tab_val_Type_5), ('id', (1, 2, 840, 113549, 1, 7, 5))])], rr=[], ev=None, er=[])
    _EncryptedContentInfo_contentType._const_tab = __EncryptedContentInfo_contentType_tab
    _EncryptedContentInfo_contentType._const_tab_at = None
    _EncryptedContentInfo_contentType._const_tab_id = u'id'
    _EncryptedContentInfo_contentEncryptionAlgorithm = SEQ(name=u'contentEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentEncryptionAlgorithmIdentifier')))
    _EncryptedContentInfo_encryptedContent = OCT_STR(name=u'encryptedContent', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    EncryptedContentInfo._cont = ASN1Dict([
        (u'contentType', _EncryptedContentInfo_contentType),
        (u'contentEncryptionAlgorithm', _EncryptedContentInfo_contentEncryptionAlgorithm),
        (u'encryptedContent', _EncryptedContentInfo_encryptedContent),
        ])
    EncryptedContentInfo._ext = None
    
    #-----< UnprotectedAttributes >-----#
    UnprotectedAttributes = CLASS(name=u'UnprotectedAttributes', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    UnprotectedAttributes._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< RecipientInfo >-----#
    RecipientInfo = CHOICE(name=u'RecipientInfo', mode=MODE_TYPE)
    _RecipientInfo_ktri = SEQ(name=u'ktri', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyTransRecipientInfo')))
    _RecipientInfo_kari = SEQ(name=u'kari', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyAgreeRecipientInfo')), group=0)
    _RecipientInfo_kekri = SEQ(name=u'kekri', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KEKRecipientInfo')), group=1)
    _RecipientInfo_pwri = SEQ(name=u'pwri', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'PasswordRecipientInfo')), group=2)
    _RecipientInfo_ori = SEQ(name=u'ori', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OtherRecipientInfo')), group=2)
    RecipientInfo._cont = ASN1Dict([
        (u'ktri', _RecipientInfo_ktri),
        (u'kari', _RecipientInfo_kari),
        (u'kekri', _RecipientInfo_kekri),
        (u'pwri', _RecipientInfo_pwri),
        (u'ori', _RecipientInfo_ori),
        ])
    RecipientInfo._ext = [u'kari', u'kekri', u'pwri', u'ori']
    
    #-----< EncryptedKey >-----#
    EncryptedKey = OCT_STR(name=u'EncryptedKey', mode=MODE_TYPE)
    
    #-----< KeyTransRecipientInfo >-----#
    KeyTransRecipientInfo = SEQ(name=u'KeyTransRecipientInfo', mode=MODE_TYPE)
    _KeyTransRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _KeyTransRecipientInfo_rid = CHOICE(name=u'rid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientIdentifier')))
    _KeyTransRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-TRANSPORT'), [u'id']))
    ___KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab = CLASS(name='_tab_KEY-TRANSPORT', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    ____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'Params', ____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]))])], rr=[], ev=None, er=[])
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab = ___KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab_at = None
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab_id = u'id'
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-TRANSPORT'), [u'Params']), opt=True)
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab = ___KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab_id = u'Params'
    _KeyTransRecipientInfo_keyEncryptionAlgorithm._cont = ASN1Dict([
        (u'algorithm', __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm),
        (u'parameters', __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters),
        ])
    _KeyTransRecipientInfo_keyEncryptionAlgorithm._ext = None
    _KeyTransRecipientInfo_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedKey')))
    KeyTransRecipientInfo._cont = ASN1Dict([
        (u'version', _KeyTransRecipientInfo_version),
        (u'rid', _KeyTransRecipientInfo_rid),
        (u'keyEncryptionAlgorithm', _KeyTransRecipientInfo_keyEncryptionAlgorithm),
        (u'encryptedKey', _KeyTransRecipientInfo_encryptedKey),
        ])
    KeyTransRecipientInfo._ext = None
    
    #-----< KeyTransportAlgorithmSet >-----#
    KeyTransportAlgorithmSet = CLASS(name=u'KeyTransportAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    _KeyTransportAlgorithmSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    KeyTransportAlgorithmSet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'Params', _KeyTransportAlgorithmSet_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]))])], rr=[], ev=[], er=[])
    
    #-----< RecipientIdentifier >-----#
    RecipientIdentifier = CHOICE(name=u'RecipientIdentifier', mode=MODE_TYPE)
    _RecipientIdentifier_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    _RecipientIdentifier_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SubjectKeyIdentifier')), group=0)
    RecipientIdentifier._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _RecipientIdentifier_issuerAndSerialNumber),
        (u'subjectKeyIdentifier', _RecipientIdentifier_subjectKeyIdentifier),
        ])
    RecipientIdentifier._ext = [u'subjectKeyIdentifier']
    
    #-----< KeyAgreeRecipientInfo >-----#
    KeyAgreeRecipientInfo = SEQ(name=u'KeyAgreeRecipientInfo', mode=MODE_TYPE)
    _KeyAgreeRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _KeyAgreeRecipientInfo_originator = CHOICE(name=u'originator', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OriginatorIdentifierOrKey')))
    _KeyAgreeRecipientInfo_ukm = OCT_STR(name=u'ukm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'UserKeyingMaterial')), opt=True)
    _KeyAgreeRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-AGREE'), [u'id']))
    ___KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab = CLASS(name='_tab_KEY-AGREE', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-AGREE')))
    ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    ___KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5)), (u'Params', ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10)), (u'Params', ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]))])], rr=[], ev=None, er=[])
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab = ___KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab_at = None
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm._const_tab_id = u'id'
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-AGREE'), [u'Params']), opt=True)
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab = ___KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters._const_tab_id = u'Params'
    _KeyAgreeRecipientInfo_keyEncryptionAlgorithm._cont = ASN1Dict([
        (u'algorithm', __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm),
        (u'parameters', __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters),
        ])
    _KeyAgreeRecipientInfo_keyEncryptionAlgorithm._ext = None
    _KeyAgreeRecipientInfo_recipientEncryptedKeys = SEQ_OF(name=u'recipientEncryptedKeys', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientEncryptedKeys')))
    KeyAgreeRecipientInfo._cont = ASN1Dict([
        (u'version', _KeyAgreeRecipientInfo_version),
        (u'originator', _KeyAgreeRecipientInfo_originator),
        (u'ukm', _KeyAgreeRecipientInfo_ukm),
        (u'keyEncryptionAlgorithm', _KeyAgreeRecipientInfo_keyEncryptionAlgorithm),
        (u'recipientEncryptedKeys', _KeyAgreeRecipientInfo_recipientEncryptedKeys),
        ])
    KeyAgreeRecipientInfo._ext = None
    
    #-----< KeyAgreementAlgorithmSet >-----#
    KeyAgreementAlgorithmSet = CLASS(name=u'KeyAgreementAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-AGREE')))
    _KeyAgreementAlgorithmSet_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _KeyAgreementAlgorithmSet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    KeyAgreementAlgorithmSet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5)), (u'Params', _KeyAgreementAlgorithmSet_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10)), (u'Params', _KeyAgreementAlgorithmSet_val_Params_1), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]))])], rr=[], ev=[], er=[])
    
    #-----< OriginatorIdentifierOrKey >-----#
    OriginatorIdentifierOrKey = CHOICE(name=u'OriginatorIdentifierOrKey', mode=MODE_TYPE)
    _OriginatorIdentifierOrKey_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    _OriginatorIdentifierOrKey_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SubjectKeyIdentifier')))
    _OriginatorIdentifierOrKey_originatorKey = SEQ(name=u'originatorKey', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OriginatorPublicKey')))
    OriginatorIdentifierOrKey._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _OriginatorIdentifierOrKey_issuerAndSerialNumber),
        (u'subjectKeyIdentifier', _OriginatorIdentifierOrKey_subjectKeyIdentifier),
        (u'originatorKey', _OriginatorIdentifierOrKey_originatorKey),
        ])
    OriginatorIdentifierOrKey._ext = None
    
    #-----< OriginatorPublicKey >-----#
    OriginatorPublicKey = SEQ(name=u'OriginatorPublicKey', mode=MODE_TYPE)
    _OriginatorPublicKey_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __OriginatorPublicKey_algorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'id']))
    ___OriginatorPublicKey_algorithm_algorithm_tab = CLASS(name='_tab_PUBLIC-KEY', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    ____OriginatorPublicKey_algorithm_algorithm_tab_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    ____OriginatorPublicKey_algorithm_algorithm_tab_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    ___OriginatorPublicKey_algorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', ____OriginatorPublicKey_algorithm_algorithm_tab_val_KeyValue_0), (u'Params', ____OriginatorPublicKey_algorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])
    __OriginatorPublicKey_algorithm_algorithm._const_tab = ___OriginatorPublicKey_algorithm_algorithm_tab
    __OriginatorPublicKey_algorithm_algorithm._const_tab_at = None
    __OriginatorPublicKey_algorithm_algorithm._const_tab_id = u'id'
    __OriginatorPublicKey_algorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'Params']), opt=True)
    __OriginatorPublicKey_algorithm_parameters._const_tab = ___OriginatorPublicKey_algorithm_algorithm_tab
    __OriginatorPublicKey_algorithm_parameters._const_tab_at = ('..', u'algorithm')
    __OriginatorPublicKey_algorithm_parameters._const_tab_id = u'Params'
    _OriginatorPublicKey_algorithm._cont = ASN1Dict([
        (u'algorithm', __OriginatorPublicKey_algorithm_algorithm),
        (u'parameters', __OriginatorPublicKey_algorithm_parameters),
        ])
    _OriginatorPublicKey_algorithm._ext = None
    _OriginatorPublicKey_publicKey = BIT_STR(name=u'publicKey', mode=MODE_TYPE)
    OriginatorPublicKey._cont = ASN1Dict([
        (u'algorithm', _OriginatorPublicKey_algorithm),
        (u'publicKey', _OriginatorPublicKey_publicKey),
        ])
    OriginatorPublicKey._ext = None
    
    #-----< OriginatorKeySet >-----#
    OriginatorKeySet = CLASS(name=u'OriginatorKeySet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _OriginatorKeySet_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _OriginatorKeySet_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    OriginatorKeySet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _OriginatorKeySet_val_KeyValue_0), (u'Params', _OriginatorKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=[], er=[])
    
    #-----< RecipientEncryptedKeys >-----#
    RecipientEncryptedKeys = SEQ_OF(name=u'RecipientEncryptedKeys', mode=MODE_TYPE)
    _RecipientEncryptedKeys__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientEncryptedKey')))
    RecipientEncryptedKeys._cont = _RecipientEncryptedKeys__item_
    
    #-----< RecipientEncryptedKey >-----#
    RecipientEncryptedKey = SEQ(name=u'RecipientEncryptedKey', mode=MODE_TYPE)
    _RecipientEncryptedKey_rid = CHOICE(name=u'rid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyAgreeRecipientIdentifier')))
    _RecipientEncryptedKey_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedKey')))
    RecipientEncryptedKey._cont = ASN1Dict([
        (u'rid', _RecipientEncryptedKey_rid),
        (u'encryptedKey', _RecipientEncryptedKey_encryptedKey),
        ])
    RecipientEncryptedKey._ext = None
    
    #-----< KeyAgreeRecipientIdentifier >-----#
    KeyAgreeRecipientIdentifier = CHOICE(name=u'KeyAgreeRecipientIdentifier', mode=MODE_TYPE)
    _KeyAgreeRecipientIdentifier_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    _KeyAgreeRecipientIdentifier_rKeyId = SEQ(name=u'rKeyId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientKeyIdentifier')))
    KeyAgreeRecipientIdentifier._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _KeyAgreeRecipientIdentifier_issuerAndSerialNumber),
        (u'rKeyId', _KeyAgreeRecipientIdentifier_rKeyId),
        ])
    KeyAgreeRecipientIdentifier._ext = None
    
    #-----< RecipientKeyIdentifier >-----#
    RecipientKeyIdentifier = SEQ(name=u'RecipientKeyIdentifier', mode=MODE_TYPE)
    _RecipientKeyIdentifier_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SubjectKeyIdentifier')))
    _RecipientKeyIdentifier_date = TIME_GEN(name=u'date', mode=MODE_TYPE, opt=True)
    _RecipientKeyIdentifier_other = SEQ(name=u'other', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OtherKeyAttribute')), opt=True)
    RecipientKeyIdentifier._cont = ASN1Dict([
        (u'subjectKeyIdentifier', _RecipientKeyIdentifier_subjectKeyIdentifier),
        (u'date', _RecipientKeyIdentifier_date),
        (u'other', _RecipientKeyIdentifier_other),
        ])
    RecipientKeyIdentifier._ext = None
    
    #-----< SubjectKeyIdentifier >-----#
    SubjectKeyIdentifier = OCT_STR(name=u'SubjectKeyIdentifier', mode=MODE_TYPE)
    
    #-----< KEKRecipientInfo >-----#
    KEKRecipientInfo = SEQ(name=u'KEKRecipientInfo', mode=MODE_TYPE)
    _KEKRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _KEKRecipientInfo_kekid = SEQ(name=u'kekid', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KEKIdentifier')))
    _KEKRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyEncryptionAlgorithmIdentifier')))
    _KEKRecipientInfo_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedKey')))
    KEKRecipientInfo._cont = ASN1Dict([
        (u'version', _KEKRecipientInfo_version),
        (u'kekid', _KEKRecipientInfo_kekid),
        (u'keyEncryptionAlgorithm', _KEKRecipientInfo_keyEncryptionAlgorithm),
        (u'encryptedKey', _KEKRecipientInfo_encryptedKey),
        ])
    KEKRecipientInfo._ext = None
    
    #-----< KEKIdentifier >-----#
    KEKIdentifier = SEQ(name=u'KEKIdentifier', mode=MODE_TYPE)
    _KEKIdentifier_keyIdentifier = OCT_STR(name=u'keyIdentifier', mode=MODE_TYPE)
    _KEKIdentifier_date = TIME_GEN(name=u'date', mode=MODE_TYPE, opt=True)
    _KEKIdentifier_other = SEQ(name=u'other', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OtherKeyAttribute')), opt=True)
    KEKIdentifier._cont = ASN1Dict([
        (u'keyIdentifier', _KEKIdentifier_keyIdentifier),
        (u'date', _KEKIdentifier_date),
        (u'other', _KEKIdentifier_other),
        ])
    KEKIdentifier._ext = None
    
    #-----< PasswordRecipientInfo >-----#
    PasswordRecipientInfo = SEQ(name=u'PasswordRecipientInfo', mode=MODE_TYPE)
    _PasswordRecipientInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _PasswordRecipientInfo_keyDerivationAlgorithm = SEQ(name=u'keyDerivationAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyDerivationAlgorithmIdentifier')), opt=True)
    _PasswordRecipientInfo_keyEncryptionAlgorithm = SEQ(name=u'keyEncryptionAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KeyEncryptionAlgorithmIdentifier')))
    _PasswordRecipientInfo_encryptedKey = OCT_STR(name=u'encryptedKey', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedKey')))
    PasswordRecipientInfo._cont = ASN1Dict([
        (u'version', _PasswordRecipientInfo_version),
        (u'keyDerivationAlgorithm', _PasswordRecipientInfo_keyDerivationAlgorithm),
        (u'keyEncryptionAlgorithm', _PasswordRecipientInfo_keyEncryptionAlgorithm),
        (u'encryptedKey', _PasswordRecipientInfo_encryptedKey),
        ])
    PasswordRecipientInfo._ext = None
    
    #-----< OTHER-RECIPIENT >-----#
    OTHER_RECIPIENT = CLASS(name=u'OTHER-RECIPIENT', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< OtherRecipientInfo >-----#
    OtherRecipientInfo = SEQ(name=u'OtherRecipientInfo', mode=MODE_TYPE)
    _OtherRecipientInfo_oriType = OID(name=u'oriType', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-RECIPIENT'), [u'id']))
    __OtherRecipientInfo_oriType_tab = CLASS(name='_tab_OTHER-RECIPIENT', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-RECIPIENT')))
    __OtherRecipientInfo_oriType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherRecipientInfo_oriType._const_tab = __OtherRecipientInfo_oriType_tab
    _OtherRecipientInfo_oriType._const_tab_at = None
    _OtherRecipientInfo_oriType._const_tab_id = u'id'
    _OtherRecipientInfo_oriValue = OPEN(name=u'oriValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-RECIPIENT'), [u'Type']))
    __OtherRecipientInfo_oriValue_tab = CLASS(name='_tab_OTHER-RECIPIENT', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-RECIPIENT')))
    __OtherRecipientInfo_oriValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherRecipientInfo_oriValue._const_tab = __OtherRecipientInfo_oriValue_tab
    _OtherRecipientInfo_oriValue._const_tab_at = ('..', u'oriType')
    _OtherRecipientInfo_oriValue._const_tab_id = u'Type'
    OtherRecipientInfo._cont = ASN1Dict([
        (u'oriType', _OtherRecipientInfo_oriType),
        (u'oriValue', _OtherRecipientInfo_oriValue),
        ])
    OtherRecipientInfo._ext = None
    
    #-----< SupportedOtherRecipInfo >-----#
    SupportedOtherRecipInfo = CLASS(name=u'SupportedOtherRecipInfo', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-RECIPIENT')))
    SupportedOtherRecipInfo._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DigestedData >-----#
    DigestedData = SEQ(name=u'DigestedData', mode=MODE_TYPE)
    _DigestedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _DigestedData_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestAlgorithmIdentifier')))
    _DigestedData_encapContentInfo = SEQ(name=u'encapContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncapsulatedContentInfo')))
    _DigestedData_digest = OCT_STR(name=u'digest', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Digest')))
    DigestedData._cont = ASN1Dict([
        (u'version', _DigestedData_version),
        (u'digestAlgorithm', _DigestedData_digestAlgorithm),
        (u'encapContentInfo', _DigestedData_encapContentInfo),
        (u'digest', _DigestedData_digest),
        ])
    DigestedData._ext = []
    
    #-----< Digest >-----#
    Digest = OCT_STR(name=u'Digest', mode=MODE_TYPE)
    
    #-----< EncryptedData >-----#
    EncryptedData = SEQ(name=u'EncryptedData', mode=MODE_TYPE)
    _EncryptedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _EncryptedData_encryptedContentInfo = SEQ(name=u'encryptedContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedContentInfo')))
    _EncryptedData_unprotectedAttrs = SET_OF(name=u'unprotectedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attributes')), opt=True, group=0)
    __EncryptedData_unprotectedAttrs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    ___EncryptedData_unprotectedAttrs__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____EncryptedData_unprotectedAttrs__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____EncryptedData_unprotectedAttrs__item__attrType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___EncryptedData_unprotectedAttrs__item__attrType._const_tab = ____EncryptedData_unprotectedAttrs__item__attrType_tab
    ___EncryptedData_unprotectedAttrs__item__attrType._const_tab_at = None
    ___EncryptedData_unprotectedAttrs__item__attrType._const_tab_id = u'id'
    ___EncryptedData_unprotectedAttrs__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ____EncryptedData_unprotectedAttrs__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    _____EncryptedData_unprotectedAttrs__item__attrValues__item__tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____EncryptedData_unprotectedAttrs__item__attrValues__item__tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____EncryptedData_unprotectedAttrs__item__attrValues__item_._const_tab = _____EncryptedData_unprotectedAttrs__item__attrValues__item__tab
    ____EncryptedData_unprotectedAttrs__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ____EncryptedData_unprotectedAttrs__item__attrValues__item_._const_tab_id = u'Type'
    ___EncryptedData_unprotectedAttrs__item__attrValues._cont = ____EncryptedData_unprotectedAttrs__item__attrValues__item_
    __EncryptedData_unprotectedAttrs__item_._cont = ASN1Dict([
        (u'attrType', ___EncryptedData_unprotectedAttrs__item__attrType),
        (u'attrValues', ___EncryptedData_unprotectedAttrs__item__attrValues),
        ])
    __EncryptedData_unprotectedAttrs__item_._ext = None
    _EncryptedData_unprotectedAttrs._cont = __EncryptedData_unprotectedAttrs__item_
    _EncryptedData_unprotectedAttrs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    EncryptedData._cont = ASN1Dict([
        (u'version', _EncryptedData_version),
        (u'encryptedContentInfo', _EncryptedData_encryptedContentInfo),
        (u'unprotectedAttrs', _EncryptedData_unprotectedAttrs),
        ])
    EncryptedData._ext = [u'unprotectedAttrs']
    
    #-----< AuthenticatedData >-----#
    AuthenticatedData = SEQ(name=u'AuthenticatedData', mode=MODE_TYPE)
    _AuthenticatedData_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _AuthenticatedData_originatorInfo = SEQ(name=u'originatorInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OriginatorInfo')), opt=True)
    _AuthenticatedData_recipientInfos = SET_OF(name=u'recipientInfos', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientInfos')))
    _AuthenticatedData_macAlgorithm = SEQ(name=u'macAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageAuthenticationCodeAlgorithm')))
    _AuthenticatedData_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestAlgorithmIdentifier')), opt=True)
    _AuthenticatedData_encapContentInfo = SEQ(name=u'encapContentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncapsulatedContentInfo')))
    _AuthenticatedData_authAttrs = SET_OF(name=u'authAttrs', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthAttributes')), opt=True)
    _AuthenticatedData_mac = OCT_STR(name=u'mac', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageAuthenticationCode')))
    _AuthenticatedData_unauthAttrs = SET_OF(name=u'unauthAttrs', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'UnauthAttributes')), opt=True)
    AuthenticatedData._cont = ASN1Dict([
        (u'version', _AuthenticatedData_version),
        (u'originatorInfo', _AuthenticatedData_originatorInfo),
        (u'recipientInfos', _AuthenticatedData_recipientInfos),
        (u'macAlgorithm', _AuthenticatedData_macAlgorithm),
        (u'digestAlgorithm', _AuthenticatedData_digestAlgorithm),
        (u'encapContentInfo', _AuthenticatedData_encapContentInfo),
        (u'authAttrs', _AuthenticatedData_authAttrs),
        (u'mac', _AuthenticatedData_mac),
        (u'unauthAttrs', _AuthenticatedData_unauthAttrs),
        ])
    AuthenticatedData._ext = None
    
    #-----< AuthAttributes >-----#
    AuthAttributes = SET_OF(name=u'AuthAttributes', mode=MODE_TYPE)
    _AuthAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    __AuthAttributes__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___AuthAttributes__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____AuthAttributes__item__attrType_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentType')))
    ____AuthAttributes__item__attrType_tab_val_Type_1 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageDigest')))
    ____AuthAttributes__item__attrType_tab_val_Type_2 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SigningTime')))
    ___AuthAttributes__item__attrType_tab._val = ASN1Set(rv=[dict([(u'Type', ____AuthAttributes__item__attrType_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 3))]), dict([(u'Type', ____AuthAttributes__item__attrType_tab_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 4))]), dict([(u'Type', ____AuthAttributes__item__attrType_tab_val_Type_2), (u'id', (1, 2, 840, 113549, 1, 9, 5))])], rr=[], ev=None, er=[])
    __AuthAttributes__item__attrType._const_tab = ___AuthAttributes__item__attrType_tab
    __AuthAttributes__item__attrType._const_tab_at = None
    __AuthAttributes__item__attrType._const_tab_id = u'id'
    __AuthAttributes__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ___AuthAttributes__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ___AuthAttributes__item__attrValues__item_._const_tab = ___AuthAttributes__item__attrType_tab
    ___AuthAttributes__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ___AuthAttributes__item__attrValues__item_._const_tab_id = u'Type'
    __AuthAttributes__item__attrValues._cont = ___AuthAttributes__item__attrValues__item_
    _AuthAttributes__item_._cont = ASN1Dict([
        (u'attrType', __AuthAttributes__item__attrType),
        (u'attrValues', __AuthAttributes__item__attrValues),
        ])
    _AuthAttributes__item_._ext = None
    AuthAttributes._cont = _AuthAttributes__item_
    AuthAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< AuthAttributeSet >-----#
    AuthAttributeSet = CLASS(name=u'AuthAttributeSet', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _AuthAttributeSet_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentType')))
    _AuthAttributeSet_val_Type_1 = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageDigest')))
    _AuthAttributeSet_val_Type_2 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SigningTime')))
    AuthAttributeSet._val = ASN1Set(rv=[dict([(u'Type', _AuthAttributeSet_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 3))]), dict([(u'Type', _AuthAttributeSet_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 4))]), dict([(u'Type', _AuthAttributeSet_val_Type_2), (u'id', (1, 2, 840, 113549, 1, 9, 5))])], rr=[], ev=[], er=[])
    
    #-----< MessageAuthenticationCode >-----#
    MessageAuthenticationCode = OCT_STR(name=u'MessageAuthenticationCode', mode=MODE_TYPE)
    
    #-----< UnauthAttributes >-----#
    UnauthAttributes = SET_OF(name=u'UnauthAttributes', mode=MODE_TYPE)
    _UnauthAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Attribute')))
    __UnauthAttributes__item__attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___UnauthAttributes__item__attrType_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ___UnauthAttributes__item__attrType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __UnauthAttributes__item__attrType._const_tab = ___UnauthAttributes__item__attrType_tab
    __UnauthAttributes__item__attrType._const_tab_at = None
    __UnauthAttributes__item__attrType._const_tab_id = u'id'
    __UnauthAttributes__item__attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    ___UnauthAttributes__item__attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ____UnauthAttributes__item__attrValues__item__tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____UnauthAttributes__item__attrValues__item__tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UnauthAttributes__item__attrValues__item_._const_tab = ____UnauthAttributes__item__attrValues__item__tab
    ___UnauthAttributes__item__attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    ___UnauthAttributes__item__attrValues__item_._const_tab_id = u'Type'
    __UnauthAttributes__item__attrValues._cont = ___UnauthAttributes__item__attrValues__item_
    _UnauthAttributes__item_._cont = ASN1Dict([
        (u'attrType', __UnauthAttributes__item__attrType),
        (u'attrValues', __UnauthAttributes__item__attrValues),
        ])
    _UnauthAttributes__item_._ext = None
    UnauthAttributes._cont = _UnauthAttributes__item_
    UnauthAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< UnauthAttributeSet >-----#
    UnauthAttributeSet = CLASS(name=u'UnauthAttributeSet', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    UnauthAttributeSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< DigestAlgorithmIdentifier >-----#
    DigestAlgorithmIdentifier = SEQ(name=u'DigestAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _DigestAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    __DigestAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    __DigestAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _DigestAlgorithmIdentifier_algorithm._const_tab = __DigestAlgorithmIdentifier_algorithm_tab
    _DigestAlgorithmIdentifier_algorithm._const_tab_at = None
    _DigestAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _DigestAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    __DigestAlgorithmIdentifier_parameters_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    __DigestAlgorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _DigestAlgorithmIdentifier_parameters._const_tab = __DigestAlgorithmIdentifier_parameters_tab
    _DigestAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _DigestAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    DigestAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _DigestAlgorithmIdentifier_algorithm),
        (u'parameters', _DigestAlgorithmIdentifier_parameters),
        ])
    DigestAlgorithmIdentifier._ext = None
    
    #-----< DigestAlgorithmSet >-----#
    DigestAlgorithmSet = CLASS(name=u'DigestAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    DigestAlgorithmSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< SignatureAlgorithmIdentifier >-----#
    SignatureAlgorithmIdentifier = SEQ(name=u'SignatureAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _SignatureAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    __SignatureAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    __SignatureAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _SignatureAlgorithmIdentifier_algorithm._const_tab = __SignatureAlgorithmIdentifier_algorithm_tab
    _SignatureAlgorithmIdentifier_algorithm._const_tab_at = None
    _SignatureAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _SignatureAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __SignatureAlgorithmIdentifier_parameters_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    __SignatureAlgorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _SignatureAlgorithmIdentifier_parameters._const_tab = __SignatureAlgorithmIdentifier_parameters_tab
    _SignatureAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _SignatureAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    SignatureAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _SignatureAlgorithmIdentifier_algorithm),
        (u'parameters', _SignatureAlgorithmIdentifier_parameters),
        ])
    SignatureAlgorithmIdentifier._ext = None
    
    #-----< SignatureAlgorithmSet >-----#
    SignatureAlgorithmSet = CLASS(name=u'SignatureAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    SignatureAlgorithmSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< KeyEncryptionAlgorithmIdentifier >-----#
    KeyEncryptionAlgorithmIdentifier = SEQ(name=u'KeyEncryptionAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _KeyEncryptionAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-WRAP'), [u'id']))
    __KeyEncryptionAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_KEY-WRAP', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1 = INT(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2wrapParameter')))
    __KeyEncryptionAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6)), (u'Params', ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7)), (u'Params', ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]))])], rr=[], ev=None, er=[])
    _KeyEncryptionAlgorithmIdentifier_algorithm._const_tab = __KeyEncryptionAlgorithmIdentifier_algorithm_tab
    _KeyEncryptionAlgorithmIdentifier_algorithm._const_tab_at = None
    _KeyEncryptionAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _KeyEncryptionAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-WRAP'), [u'Params']), opt=True)
    _KeyEncryptionAlgorithmIdentifier_parameters._const_tab = __KeyEncryptionAlgorithmIdentifier_algorithm_tab
    _KeyEncryptionAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _KeyEncryptionAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    KeyEncryptionAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _KeyEncryptionAlgorithmIdentifier_algorithm),
        (u'parameters', _KeyEncryptionAlgorithmIdentifier_parameters),
        ])
    KeyEncryptionAlgorithmIdentifier._ext = None
    
    #-----< KeyEncryptionAlgorithmSet >-----#
    KeyEncryptionAlgorithmSet = CLASS(name=u'KeyEncryptionAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    _KeyEncryptionAlgorithmSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _KeyEncryptionAlgorithmSet_val_Params_1 = INT(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2wrapParameter')))
    KeyEncryptionAlgorithmSet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6)), (u'Params', _KeyEncryptionAlgorithmSet_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7)), (u'Params', _KeyEncryptionAlgorithmSet_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]))])], rr=[], ev=[], er=[])
    
    #-----< ContentEncryptionAlgorithmIdentifier >-----#
    ContentEncryptionAlgorithmIdentifier = SEQ(name=u'ContentEncryptionAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _ContentEncryptionAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION'), [u'id']))
    __ContentEncryptionAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_CONTENT-ENCRYPTION', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'IV')))
    ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2CBCParameter')))
    ____ContentEncryptionAlgorithmIdentifier_algorithm_tab_smimeCaps_val_Type = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    __ContentEncryptionAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 3, 7)), (u'Params', ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 3, 7))]))]), dict([(u'id', (1, 2, 840, 113549, 3, 2)), (u'Params', ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'Type', ____ContentEncryptionAlgorithmIdentifier_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 3, 2))]))])], rr=[], ev=None, er=[])
    _ContentEncryptionAlgorithmIdentifier_algorithm._const_tab = __ContentEncryptionAlgorithmIdentifier_algorithm_tab
    _ContentEncryptionAlgorithmIdentifier_algorithm._const_tab_at = None
    _ContentEncryptionAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _ContentEncryptionAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION'), [u'Params']), opt=True)
    _ContentEncryptionAlgorithmIdentifier_parameters._const_tab = __ContentEncryptionAlgorithmIdentifier_algorithm_tab
    _ContentEncryptionAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _ContentEncryptionAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    ContentEncryptionAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _ContentEncryptionAlgorithmIdentifier_algorithm),
        (u'parameters', _ContentEncryptionAlgorithmIdentifier_parameters),
        ])
    ContentEncryptionAlgorithmIdentifier._ext = None
    
    #-----< ContentEncryptionAlgorithmSet >-----#
    ContentEncryptionAlgorithmSet = CLASS(name=u'ContentEncryptionAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    _ContentEncryptionAlgorithmSet_val_Params_0 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'IV')))
    _ContentEncryptionAlgorithmSet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2CBCParameter')))
    ContentEncryptionAlgorithmSet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 3, 7)), (u'Params', _ContentEncryptionAlgorithmSet_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 3, 7))]))]), dict([(u'id', (1, 2, 840, 113549, 3, 2)), (u'Params', _ContentEncryptionAlgorithmSet_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'Type', ____ContentEncryptionAlgorithmIdentifier_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 3, 2))]))])], rr=[], ev=[], er=[])
    
    #-----< MessageAuthenticationCodeAlgorithm >-----#
    MessageAuthenticationCodeAlgorithm = SEQ(name=u'MessageAuthenticationCodeAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _MessageAuthenticationCodeAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'id']))
    __MessageAuthenticationCodeAlgorithm_algorithm_tab = CLASS(name='_tab_MAC-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    ___MessageAuthenticationCodeAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __MessageAuthenticationCodeAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', ___MessageAuthenticationCodeAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=None, er=[])
    _MessageAuthenticationCodeAlgorithm_algorithm._const_tab = __MessageAuthenticationCodeAlgorithm_algorithm_tab
    _MessageAuthenticationCodeAlgorithm_algorithm._const_tab_at = None
    _MessageAuthenticationCodeAlgorithm_algorithm._const_tab_id = u'id'
    _MessageAuthenticationCodeAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'Params']), opt=True)
    _MessageAuthenticationCodeAlgorithm_parameters._const_tab = __MessageAuthenticationCodeAlgorithm_algorithm_tab
    _MessageAuthenticationCodeAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _MessageAuthenticationCodeAlgorithm_parameters._const_tab_id = u'Params'
    MessageAuthenticationCodeAlgorithm._cont = ASN1Dict([
        (u'algorithm', _MessageAuthenticationCodeAlgorithm_algorithm),
        (u'parameters', _MessageAuthenticationCodeAlgorithm_parameters),
        ])
    MessageAuthenticationCodeAlgorithm._ext = None
    
    #-----< MessageAuthenticationCodeAlgorithmSet >-----#
    MessageAuthenticationCodeAlgorithmSet = CLASS(name=u'MessageAuthenticationCodeAlgorithmSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    _MessageAuthenticationCodeAlgorithmSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    MessageAuthenticationCodeAlgorithmSet._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _MessageAuthenticationCodeAlgorithmSet_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=[], er=[])
    
    #-----< KeyDerivationAlgorithmIdentifier >-----#
    KeyDerivationAlgorithmIdentifier = SEQ(name=u'KeyDerivationAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _KeyDerivationAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-DERIVATION'), [u'id']))
    __KeyDerivationAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_KEY-DERIVATION', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-DERIVATION')))
    ___KeyDerivationAlgorithmIdentifier_algorithm_tab_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-params')))
    __KeyDerivationAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 5, 12)), (u'Params', ___KeyDerivationAlgorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=None, er=[])
    _KeyDerivationAlgorithmIdentifier_algorithm._const_tab = __KeyDerivationAlgorithmIdentifier_algorithm_tab
    _KeyDerivationAlgorithmIdentifier_algorithm._const_tab_at = None
    _KeyDerivationAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _KeyDerivationAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-DERIVATION'), [u'Params']), opt=True)
    _KeyDerivationAlgorithmIdentifier_parameters._const_tab = __KeyDerivationAlgorithmIdentifier_algorithm_tab
    _KeyDerivationAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _KeyDerivationAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    KeyDerivationAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _KeyDerivationAlgorithmIdentifier_algorithm),
        (u'parameters', _KeyDerivationAlgorithmIdentifier_parameters),
        ])
    KeyDerivationAlgorithmIdentifier._ext = None
    
    #-----< RevocationInfoChoices >-----#
    RevocationInfoChoices = SET_OF(name=u'RevocationInfoChoices', mode=MODE_TYPE)
    _RevocationInfoChoices__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RevocationInfoChoice')))
    RevocationInfoChoices._cont = _RevocationInfoChoices__item_
    
    #-----< RevocationInfoChoice >-----#
    RevocationInfoChoice = CHOICE(name=u'RevocationInfoChoice', mode=MODE_TYPE)
    _RevocationInfoChoice_crl = SEQ(name=u'crl', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateList')))
    _RevocationInfoChoice_other = SEQ(name=u'other', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OtherRevocationInfoFormat')), group=0)
    RevocationInfoChoice._cont = ASN1Dict([
        (u'crl', _RevocationInfoChoice_crl),
        (u'other', _RevocationInfoChoice_other),
        ])
    RevocationInfoChoice._ext = [u'other']
    
    #-----< OTHER-REVOK-INFO >-----#
    OTHER_REVOK_INFO = CLASS(name=u'OTHER-REVOK-INFO', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< OtherRevocationInfoFormat >-----#
    OtherRevocationInfoFormat = SEQ(name=u'OtherRevocationInfoFormat', mode=MODE_TYPE)
    _OtherRevocationInfoFormat_otherRevInfoFormat = OID(name=u'otherRevInfoFormat', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-REVOK-INFO'), [u'id']))
    __OtherRevocationInfoFormat_otherRevInfoFormat_tab = CLASS(name='_tab_OTHER-REVOK-INFO', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-REVOK-INFO')))
    __OtherRevocationInfoFormat_otherRevInfoFormat_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherRevocationInfoFormat_otherRevInfoFormat._const_tab = __OtherRevocationInfoFormat_otherRevInfoFormat_tab
    _OtherRevocationInfoFormat_otherRevInfoFormat._const_tab_at = None
    _OtherRevocationInfoFormat_otherRevInfoFormat._const_tab_id = u'id'
    _OtherRevocationInfoFormat_otherRevInfo = OPEN(name=u'otherRevInfo', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-REVOK-INFO'), [u'Type']))
    __OtherRevocationInfoFormat_otherRevInfo_tab = CLASS(name='_tab_OTHER-REVOK-INFO', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-REVOK-INFO')))
    __OtherRevocationInfoFormat_otherRevInfo_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherRevocationInfoFormat_otherRevInfo._const_tab = __OtherRevocationInfoFormat_otherRevInfo_tab
    _OtherRevocationInfoFormat_otherRevInfo._const_tab_at = ('..', u'otherRevInfoFormat')
    _OtherRevocationInfoFormat_otherRevInfo._const_tab_id = u'Type'
    OtherRevocationInfoFormat._cont = ASN1Dict([
        (u'otherRevInfoFormat', _OtherRevocationInfoFormat_otherRevInfoFormat),
        (u'otherRevInfo', _OtherRevocationInfoFormat_otherRevInfo),
        ])
    OtherRevocationInfoFormat._ext = None
    
    #-----< SupportedOtherRevokInfo >-----#
    SupportedOtherRevokInfo = CLASS(name=u'SupportedOtherRevokInfo', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-REVOK-INFO')))
    SupportedOtherRevokInfo._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< CertificateChoices >-----#
    CertificateChoices = CHOICE(name=u'CertificateChoices', mode=MODE_TYPE)
    _CertificateChoices_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Certificate')))
    _CertificateChoices_extendedCertificate = SEQ(name=u'extendedCertificate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ExtendedCertificate')))
    _CertificateChoices_v1AttrCert = SEQ(name=u'v1AttrCert', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateVersion1-2009', 'AttributeCertificateV1')), group=0)
    _CertificateChoices_v2AttrCert = SEQ(name=u'v2AttrCert', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AttributeCertificateV2')), group=1)
    _CertificateChoices_other = SEQ(name=u'other', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OtherCertificateFormat')), group=2)
    CertificateChoices._cont = ASN1Dict([
        (u'certificate', _CertificateChoices_certificate),
        (u'extendedCertificate', _CertificateChoices_extendedCertificate),
        (u'v1AttrCert', _CertificateChoices_v1AttrCert),
        (u'v2AttrCert', _CertificateChoices_v2AttrCert),
        (u'other', _CertificateChoices_other),
        ])
    CertificateChoices._ext = [u'v1AttrCert', u'v2AttrCert', u'other']
    
    #-----< AttributeCertificateV2 >-----#
    AttributeCertificateV2 = SEQ(name=u'AttributeCertificateV2', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttributeCertificate')))
    
    #-----< OTHER-CERT-FMT >-----#
    OTHER_CERT_FMT = CLASS(name=u'OTHER-CERT-FMT', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< OtherCertificateFormat >-----#
    OtherCertificateFormat = SEQ(name=u'OtherCertificateFormat', mode=MODE_TYPE)
    _OtherCertificateFormat_otherCertFormat = OID(name=u'otherCertFormat', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-CERT-FMT'), [u'id']))
    __OtherCertificateFormat_otherCertFormat_tab = CLASS(name='_tab_OTHER-CERT-FMT', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-CERT-FMT')))
    __OtherCertificateFormat_otherCertFormat_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherCertificateFormat_otherCertFormat._const_tab = __OtherCertificateFormat_otherCertFormat_tab
    _OtherCertificateFormat_otherCertFormat._const_tab_at = None
    _OtherCertificateFormat_otherCertFormat._const_tab_id = u'id'
    _OtherCertificateFormat_otherCert = OPEN(name=u'otherCert', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'OTHER-CERT-FMT'), [u'Type']))
    __OtherCertificateFormat_otherCert_tab = CLASS(name='_tab_OTHER-CERT-FMT', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-CERT-FMT')))
    __OtherCertificateFormat_otherCert_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherCertificateFormat_otherCert._const_tab = __OtherCertificateFormat_otherCert_tab
    _OtherCertificateFormat_otherCert._const_tab_at = ('..', u'otherCertFormat')
    _OtherCertificateFormat_otherCert._const_tab_id = u'Type'
    OtherCertificateFormat._cont = ASN1Dict([
        (u'otherCertFormat', _OtherCertificateFormat_otherCertFormat),
        (u'otherCert', _OtherCertificateFormat_otherCert),
        ])
    OtherCertificateFormat._ext = None
    
    #-----< SupportedCertFormats >-----#
    SupportedCertFormats = CLASS(name=u'SupportedCertFormats', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'OTHER-CERT-FMT')))
    SupportedCertFormats._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< CertificateSet >-----#
    CertificateSet = SET_OF(name=u'CertificateSet', mode=MODE_TYPE)
    _CertificateSet__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CertificateChoices')))
    CertificateSet._cont = _CertificateSet__item_
    
    #-----< IssuerAndSerialNumber >-----#
    IssuerAndSerialNumber = SEQ(name=u'IssuerAndSerialNumber', mode=MODE_TYPE)
    _IssuerAndSerialNumber_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _IssuerAndSerialNumber_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    IssuerAndSerialNumber._cont = ASN1Dict([
        (u'issuer', _IssuerAndSerialNumber_issuer),
        (u'serialNumber', _IssuerAndSerialNumber_serialNumber),
        ])
    IssuerAndSerialNumber._ext = None
    
    #-----< CMSVersion >-----#
    CMSVersion = INT(name=u'CMSVersion', mode=MODE_TYPE)
    CMSVersion._cont = ASN1Dict([(u'v0', 0), (u'v1', 1), (u'v2', 2), (u'v3', 3), (u'v4', 4), (u'v5', 5)])
    
    #-----< UserKeyingMaterial >-----#
    UserKeyingMaterial = OCT_STR(name=u'UserKeyingMaterial', mode=MODE_TYPE)
    
    #-----< KEY-ATTRIBUTE >-----#
    KEY_ATTRIBUTE = CLASS(name=u'KEY-ATTRIBUTE', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< OtherKeyAttribute >-----#
    OtherKeyAttribute = SEQ(name=u'OtherKeyAttribute', mode=MODE_TYPE)
    _OtherKeyAttribute_keyAttrId = OID(name=u'keyAttrId', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'KEY-ATTRIBUTE'), [u'id']))
    __OtherKeyAttribute_keyAttrId_tab = CLASS(name='_tab_KEY-ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KEY-ATTRIBUTE')))
    __OtherKeyAttribute_keyAttrId_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherKeyAttribute_keyAttrId._const_tab = __OtherKeyAttribute_keyAttrId_tab
    _OtherKeyAttribute_keyAttrId._const_tab_at = None
    _OtherKeyAttribute_keyAttrId._const_tab_id = u'id'
    _OtherKeyAttribute_keyAttr = OPEN(name=u'keyAttr', mode=MODE_TYPE, typeref=ASN1RefClassField(('CryptographicMessageSyntax-2009', 'KEY-ATTRIBUTE'), [u'Type']))
    __OtherKeyAttribute_keyAttr_tab = CLASS(name='_tab_KEY-ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KEY-ATTRIBUTE')))
    __OtherKeyAttribute_keyAttr_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherKeyAttribute_keyAttr._const_tab = __OtherKeyAttribute_keyAttr_tab
    _OtherKeyAttribute_keyAttr._const_tab_at = ('..', u'keyAttrId')
    _OtherKeyAttribute_keyAttr._const_tab_id = u'Type'
    OtherKeyAttribute._cont = ASN1Dict([
        (u'keyAttrId', _OtherKeyAttribute_keyAttrId),
        (u'keyAttr', _OtherKeyAttribute_keyAttr),
        ])
    OtherKeyAttribute._ext = None
    
    #-----< SupportedKeyAttributes >-----#
    SupportedKeyAttributes = CLASS(name=u'SupportedKeyAttributes', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'KEY-ATTRIBUTE')))
    SupportedKeyAttributes._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< id-ct-contentInfo >-----#
    id_ct_contentInfo = OID(name=u'id-ct-contentInfo', mode=MODE_VALUE)
    id_ct_contentInfo._val = (1, 2, 840, 113549, 1, 9, 16, 1, 6)
    
    #-----< ct-Data >-----#
    ct_Data = CLASS(name=u'ct-Data', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_Data_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    ct_Data._val = dict([('Type', _ct_Data_val_Type), ('id', (1, 2, 840, 113549, 1, 7, 1))])
    
    #-----< id-data >-----#
    id_data = OID(name=u'id-data', mode=MODE_VALUE)
    id_data._val = (1, 2, 840, 113549, 1, 7, 1)
    
    #-----< ct-SignedData >-----#
    ct_SignedData = CLASS(name=u'ct-SignedData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_SignedData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignedData')))
    ct_SignedData._val = dict([('Type', _ct_SignedData_val_Type), ('id', (1, 2, 840, 113549, 1, 7, 2))])
    
    #-----< id-signedData >-----#
    id_signedData = OID(name=u'id-signedData', mode=MODE_VALUE)
    id_signedData._val = (1, 2, 840, 113549, 1, 7, 2)
    
    #-----< ct-EnvelopedData >-----#
    ct_EnvelopedData = CLASS(name=u'ct-EnvelopedData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_EnvelopedData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EnvelopedData')))
    ct_EnvelopedData._val = dict([('Type', _ct_EnvelopedData_val_Type), ('id', (1, 2, 840, 113549, 1, 7, 3))])
    
    #-----< id-envelopedData >-----#
    id_envelopedData = OID(name=u'id-envelopedData', mode=MODE_VALUE)
    id_envelopedData._val = (1, 2, 840, 113549, 1, 7, 3)
    
    #-----< ct-DigestedData >-----#
    ct_DigestedData = CLASS(name=u'ct-DigestedData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_DigestedData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'DigestedData')))
    ct_DigestedData._val = dict([('Type', _ct_DigestedData_val_Type), ('id', (1, 2, 840, 113549, 1, 7, 5))])
    
    #-----< id-digestedData >-----#
    id_digestedData = OID(name=u'id-digestedData', mode=MODE_VALUE)
    id_digestedData._val = (1, 2, 840, 113549, 1, 7, 5)
    
    #-----< ct-EncryptedData >-----#
    ct_EncryptedData = CLASS(name=u'ct-EncryptedData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_EncryptedData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'EncryptedData')))
    ct_EncryptedData._val = dict([('Type', _ct_EncryptedData_val_Type), ('id', (1, 2, 840, 113549, 1, 7, 6))])
    
    #-----< id-encryptedData >-----#
    id_encryptedData = OID(name=u'id-encryptedData', mode=MODE_VALUE)
    id_encryptedData._val = (1, 2, 840, 113549, 1, 7, 6)
    
    #-----< ct-AuthenticatedData >-----#
    ct_AuthenticatedData = CLASS(name=u'ct-AuthenticatedData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_AuthenticatedData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'AuthenticatedData')))
    ct_AuthenticatedData._val = dict([('Type', _ct_AuthenticatedData_val_Type), ('id', (1, 2, 840, 113549, 1, 9, 16, 1, 2))])
    
    #-----< id-ct-authData >-----#
    id_ct_authData = OID(name=u'id-ct-authData', mode=MODE_VALUE)
    id_ct_authData._val = (1, 2, 840, 113549, 1, 9, 16, 1, 2)
    
    #-----< MessageDigest >-----#
    MessageDigest = OCT_STR(name=u'MessageDigest', mode=MODE_TYPE)
    
    #-----< SigningTime >-----#
    SigningTime = CHOICE(name=u'SigningTime', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Time')))
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalTime = TIME_GEN(name=u'generalTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalTime', _Time_generalTime),
        ])
    Time._ext = None
    
    #-----< Countersignature >-----#
    Countersignature = SEQ(name=u'Countersignature', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignerInfo')))
    
    #-----< aa-contentType >-----#
    aa_contentType = CLASS(name=u'aa-contentType', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_contentType_val_Type = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentType')))
    aa_contentType._val = dict([(u'Type', _aa_contentType_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 3))])
    
    #-----< id-contentType >-----#
    id_contentType = OID(name=u'id-contentType', mode=MODE_VALUE)
    id_contentType._val = (1, 2, 840, 113549, 1, 9, 3)
    
    #-----< aa-messageDigest >-----#
    aa_messageDigest = CLASS(name=u'aa-messageDigest', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_messageDigest_val_Type = OCT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'MessageDigest')))
    aa_messageDigest._val = dict([(u'Type', _aa_messageDigest_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 4))])
    
    #-----< id-messageDigest >-----#
    id_messageDigest = OID(name=u'id-messageDigest', mode=MODE_VALUE)
    id_messageDigest._val = (1, 2, 840, 113549, 1, 9, 4)
    
    #-----< aa-signingTime >-----#
    aa_signingTime = CLASS(name=u'aa-signingTime', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_signingTime_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SigningTime')))
    aa_signingTime._val = dict([(u'Type', _aa_signingTime_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 5))])
    
    #-----< id-signingTime >-----#
    id_signingTime = OID(name=u'id-signingTime', mode=MODE_VALUE)
    id_signingTime._val = (1, 2, 840, 113549, 1, 9, 5)
    
    #-----< aa-countersignature >-----#
    aa_countersignature = CLASS(name=u'aa-countersignature', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_countersignature_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Countersignature')))
    aa_countersignature._val = dict([(u'Type', _aa_countersignature_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 6))])
    
    #-----< id-countersignature >-----#
    id_countersignature = OID(name=u'id-countersignature', mode=MODE_VALUE)
    id_countersignature._val = (1, 2, 840, 113549, 1, 9, 6)
    
    #-----< ExtendedCertificateOrCertificate >-----#
    ExtendedCertificateOrCertificate = CHOICE(name=u'ExtendedCertificateOrCertificate', mode=MODE_TYPE)
    _ExtendedCertificateOrCertificate_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Certificate')))
    _ExtendedCertificateOrCertificate_extendedCertificate = SEQ(name=u'extendedCertificate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ExtendedCertificate')))
    ExtendedCertificateOrCertificate._cont = ASN1Dict([
        (u'certificate', _ExtendedCertificateOrCertificate_certificate),
        (u'extendedCertificate', _ExtendedCertificateOrCertificate_extendedCertificate),
        ])
    ExtendedCertificateOrCertificate._ext = None
    
    #-----< ExtendedCertificate >-----#
    ExtendedCertificate = SEQ(name=u'ExtendedCertificate', mode=MODE_TYPE)
    _ExtendedCertificate_extendedCertificateInfo = SEQ(name=u'extendedCertificateInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ExtendedCertificateInfo')))
    _ExtendedCertificate_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SignatureAlgorithmIdentifier')))
    _ExtendedCertificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'Signature')))
    ExtendedCertificate._cont = ASN1Dict([
        (u'extendedCertificateInfo', _ExtendedCertificate_extendedCertificateInfo),
        (u'signatureAlgorithm', _ExtendedCertificate_signatureAlgorithm),
        (u'signature', _ExtendedCertificate_signature),
        ])
    ExtendedCertificate._ext = None
    
    #-----< ExtendedCertificateInfo >-----#
    ExtendedCertificateInfo = SEQ(name=u'ExtendedCertificateInfo', mode=MODE_TYPE)
    _ExtendedCertificateInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CMSVersion')))
    _ExtendedCertificateInfo_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Certificate')))
    _ExtendedCertificateInfo_attributes = SET_OF(name=u'attributes', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'UnauthAttributes')))
    ExtendedCertificateInfo._cont = ASN1Dict([
        (u'version', _ExtendedCertificateInfo_version),
        (u'certificate', _ExtendedCertificateInfo_certificate),
        (u'attributes', _ExtendedCertificateInfo_attributes),
        ])
    ExtendedCertificateInfo._ext = None
    
    #-----< Signature >-----#
    Signature = BIT_STR(name=u'Signature', mode=MODE_TYPE)
    
    #-----< Attribute >-----#
    Attribute = SEQ(name=u'Attribute', mode=MODE_TYPE, param=True)
    
    #-----< Attributes >-----#
    Attributes = SET_OF(name=u'Attributes', mode=MODE_TYPE, param=True)
    
    _all_ = [
        CONTENT_TYPE,
        ContentType,
        __ContentInfo_contentType_tab,
        ___ContentInfo_contentType_tab_val_Type_0,
        ___ContentInfo_contentType_tab_val_Type_1,
        ___ContentInfo_contentType_tab_val_Type_2,
        ___ContentInfo_contentType_tab_val_Type_3,
        ___ContentInfo_contentType_tab_val_Type_4,
        ___ContentInfo_contentType_tab_val_Type_5,
        _ContentInfo_contentType,
        _ContentInfo_content,
        ContentInfo,
        ContentSet,
        _ContentSet_val_Type_0,
        _ContentSet_val_Type_1,
        _ContentSet_val_Type_2,
        _ContentSet_val_Type_3,
        _ContentSet_val_Type_4,
        _ContentSet_val_Type_5,
        _SignedData_version,
        __SignedData_digestAlgorithms__item_,
        _SignedData_digestAlgorithms,
        _SignedData_encapContentInfo,
        _SignedData_certificates,
        _SignedData_crls,
        _SignedData_signerInfos,
        SignedData,
        _SignerInfos__item_,
        SignerInfos,
        __EncapsulatedContentInfo_eContentType_tab,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_0,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_1,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_2,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_3,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_4,
        ___EncapsulatedContentInfo_eContentType_tab_val_Type_5,
        _EncapsulatedContentInfo_eContentType,
        __EncapsulatedContentInfo_eContent_contain,
        _EncapsulatedContentInfo_eContent,
        EncapsulatedContentInfo,
        _SignerInfo_version,
        _SignerInfo_sid,
        _SignerInfo_digestAlgorithm,
        _SignerInfo_signedAttrs,
        _SignerInfo_signatureAlgorithm,
        _SignerInfo_signature,
        ____SignerInfo_unsignedAttrs__item__attrType_tab,
        _____SignerInfo_unsignedAttrs__item__attrType_tab_val_Type_0,
        ___SignerInfo_unsignedAttrs__item__attrType,
        ____SignerInfo_unsignedAttrs__item__attrValues__item_,
        ___SignerInfo_unsignedAttrs__item__attrValues,
        __SignerInfo_unsignedAttrs__item_,
        _SignerInfo_unsignedAttrs,
        SignerInfo,
        ___SignedAttributes__item__attrType_tab,
        ____SignedAttributes__item__attrType_tab_val_Type_0,
        ____SignedAttributes__item__attrType_tab_val_Type_1,
        ____SignedAttributes__item__attrType_tab_val_Type_2,
        __SignedAttributes__item__attrType,
        ___SignedAttributes__item__attrValues__item_,
        __SignedAttributes__item__attrValues,
        _SignedAttributes__item_,
        SignedAttributes,
        _SignerIdentifier_issuerAndSerialNumber,
        _SignerIdentifier_subjectKeyIdentifier,
        SignerIdentifier,
        SignedAttributesSet,
        _SignedAttributesSet_val_Type_0,
        _SignedAttributesSet_val_Type_1,
        _SignedAttributesSet_val_Type_2,
        UnsignedAttributes,
        _UnsignedAttributes_val_Type_0,
        SignatureValue,
        _EnvelopedData_version,
        _EnvelopedData_originatorInfo,
        _EnvelopedData_recipientInfos,
        _EnvelopedData_encryptedContentInfo,
        ____EnvelopedData_unprotectedAttrs__item__attrType_tab,
        ___EnvelopedData_unprotectedAttrs__item__attrType,
        _____EnvelopedData_unprotectedAttrs__item__attrValues__item__tab,
        ____EnvelopedData_unprotectedAttrs__item__attrValues__item_,
        ___EnvelopedData_unprotectedAttrs__item__attrValues,
        __EnvelopedData_unprotectedAttrs__item_,
        _EnvelopedData_unprotectedAttrs,
        EnvelopedData,
        _OriginatorInfo_certs,
        _OriginatorInfo_crls,
        OriginatorInfo,
        _RecipientInfos__item_,
        RecipientInfos,
        __EncryptedContentInfo_contentType_tab,
        ___EncryptedContentInfo_contentType_tab_val_Type_0,
        ___EncryptedContentInfo_contentType_tab_val_Type_1,
        ___EncryptedContentInfo_contentType_tab_val_Type_2,
        ___EncryptedContentInfo_contentType_tab_val_Type_3,
        ___EncryptedContentInfo_contentType_tab_val_Type_4,
        ___EncryptedContentInfo_contentType_tab_val_Type_5,
        _EncryptedContentInfo_contentType,
        _EncryptedContentInfo_contentEncryptionAlgorithm,
        _EncryptedContentInfo_encryptedContent,
        EncryptedContentInfo,
        UnprotectedAttributes,
        _RecipientInfo_ktri,
        _RecipientInfo_kari,
        _RecipientInfo_kekri,
        _RecipientInfo_pwri,
        _RecipientInfo_ori,
        RecipientInfo,
        EncryptedKey,
        _KeyTransRecipientInfo_version,
        _KeyTransRecipientInfo_rid,
        ___KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab,
        ____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0,
        _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0,
        _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0,
        __KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm,
        __KeyTransRecipientInfo_keyEncryptionAlgorithm_parameters,
        _KeyTransRecipientInfo_keyEncryptionAlgorithm,
        _KeyTransRecipientInfo_encryptedKey,
        KeyTransRecipientInfo,
        KeyTransportAlgorithmSet,
        _KeyTransportAlgorithmSet_val_Params_0,
        _RecipientIdentifier_issuerAndSerialNumber,
        _RecipientIdentifier_subjectKeyIdentifier,
        RecipientIdentifier,
        _KeyAgreeRecipientInfo_version,
        _KeyAgreeRecipientInfo_originator,
        _KeyAgreeRecipientInfo_ukm,
        ___KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab,
        ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_0,
        _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0,
        _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0,
        _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type,
        ____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_val_Params_1,
        __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm,
        __KeyAgreeRecipientInfo_keyEncryptionAlgorithm_parameters,
        _KeyAgreeRecipientInfo_keyEncryptionAlgorithm,
        _KeyAgreeRecipientInfo_recipientEncryptedKeys,
        KeyAgreeRecipientInfo,
        KeyAgreementAlgorithmSet,
        _KeyAgreementAlgorithmSet_val_Params_0,
        _KeyAgreementAlgorithmSet_val_Params_1,
        _OriginatorIdentifierOrKey_issuerAndSerialNumber,
        _OriginatorIdentifierOrKey_subjectKeyIdentifier,
        _OriginatorIdentifierOrKey_originatorKey,
        OriginatorIdentifierOrKey,
        ___OriginatorPublicKey_algorithm_algorithm_tab,
        ____OriginatorPublicKey_algorithm_algorithm_tab_val_KeyValue_0,
        ____OriginatorPublicKey_algorithm_algorithm_tab_val_Params_0,
        __OriginatorPublicKey_algorithm_algorithm,
        __OriginatorPublicKey_algorithm_parameters,
        _OriginatorPublicKey_algorithm,
        _OriginatorPublicKey_publicKey,
        OriginatorPublicKey,
        OriginatorKeySet,
        _OriginatorKeySet_val_KeyValue_0,
        _OriginatorKeySet_val_Params_0,
        _RecipientEncryptedKeys__item_,
        RecipientEncryptedKeys,
        _RecipientEncryptedKey_rid,
        _RecipientEncryptedKey_encryptedKey,
        RecipientEncryptedKey,
        _KeyAgreeRecipientIdentifier_issuerAndSerialNumber,
        _KeyAgreeRecipientIdentifier_rKeyId,
        KeyAgreeRecipientIdentifier,
        _RecipientKeyIdentifier_subjectKeyIdentifier,
        _RecipientKeyIdentifier_date,
        _RecipientKeyIdentifier_other,
        RecipientKeyIdentifier,
        SubjectKeyIdentifier,
        _KEKRecipientInfo_version,
        _KEKRecipientInfo_kekid,
        _KEKRecipientInfo_keyEncryptionAlgorithm,
        _KEKRecipientInfo_encryptedKey,
        KEKRecipientInfo,
        _KEKIdentifier_keyIdentifier,
        _KEKIdentifier_date,
        _KEKIdentifier_other,
        KEKIdentifier,
        _PasswordRecipientInfo_version,
        _PasswordRecipientInfo_keyDerivationAlgorithm,
        _PasswordRecipientInfo_keyEncryptionAlgorithm,
        _PasswordRecipientInfo_encryptedKey,
        PasswordRecipientInfo,
        OTHER_RECIPIENT,
        __OtherRecipientInfo_oriType_tab,
        _OtherRecipientInfo_oriType,
        __OtherRecipientInfo_oriValue_tab,
        _OtherRecipientInfo_oriValue,
        OtherRecipientInfo,
        SupportedOtherRecipInfo,
        _DigestedData_version,
        _DigestedData_digestAlgorithm,
        _DigestedData_encapContentInfo,
        _DigestedData_digest,
        DigestedData,
        Digest,
        _EncryptedData_version,
        _EncryptedData_encryptedContentInfo,
        ____EncryptedData_unprotectedAttrs__item__attrType_tab,
        ___EncryptedData_unprotectedAttrs__item__attrType,
        _____EncryptedData_unprotectedAttrs__item__attrValues__item__tab,
        ____EncryptedData_unprotectedAttrs__item__attrValues__item_,
        ___EncryptedData_unprotectedAttrs__item__attrValues,
        __EncryptedData_unprotectedAttrs__item_,
        _EncryptedData_unprotectedAttrs,
        EncryptedData,
        _AuthenticatedData_version,
        _AuthenticatedData_originatorInfo,
        _AuthenticatedData_recipientInfos,
        _AuthenticatedData_macAlgorithm,
        _AuthenticatedData_digestAlgorithm,
        _AuthenticatedData_encapContentInfo,
        _AuthenticatedData_authAttrs,
        _AuthenticatedData_mac,
        _AuthenticatedData_unauthAttrs,
        AuthenticatedData,
        ___AuthAttributes__item__attrType_tab,
        ____AuthAttributes__item__attrType_tab_val_Type_0,
        ____AuthAttributes__item__attrType_tab_val_Type_1,
        ____AuthAttributes__item__attrType_tab_val_Type_2,
        __AuthAttributes__item__attrType,
        ___AuthAttributes__item__attrValues__item_,
        __AuthAttributes__item__attrValues,
        _AuthAttributes__item_,
        AuthAttributes,
        AuthAttributeSet,
        _AuthAttributeSet_val_Type_0,
        _AuthAttributeSet_val_Type_1,
        _AuthAttributeSet_val_Type_2,
        MessageAuthenticationCode,
        ___UnauthAttributes__item__attrType_tab,
        __UnauthAttributes__item__attrType,
        ____UnauthAttributes__item__attrValues__item__tab,
        ___UnauthAttributes__item__attrValues__item_,
        __UnauthAttributes__item__attrValues,
        _UnauthAttributes__item_,
        UnauthAttributes,
        UnauthAttributeSet,
        __DigestAlgorithmIdentifier_algorithm_tab,
        _DigestAlgorithmIdentifier_algorithm,
        __DigestAlgorithmIdentifier_parameters_tab,
        _DigestAlgorithmIdentifier_parameters,
        DigestAlgorithmIdentifier,
        DigestAlgorithmSet,
        __SignatureAlgorithmIdentifier_algorithm_tab,
        _SignatureAlgorithmIdentifier_algorithm,
        __SignatureAlgorithmIdentifier_parameters_tab,
        _SignatureAlgorithmIdentifier_parameters,
        SignatureAlgorithmIdentifier,
        SignatureAlgorithmSet,
        __KeyEncryptionAlgorithmIdentifier_algorithm_tab,
        ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0,
        ___KeyEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1,
        _KeyEncryptionAlgorithmIdentifier_algorithm,
        _KeyEncryptionAlgorithmIdentifier_parameters,
        KeyEncryptionAlgorithmIdentifier,
        KeyEncryptionAlgorithmSet,
        _KeyEncryptionAlgorithmSet_val_Params_0,
        _KeyEncryptionAlgorithmSet_val_Params_1,
        __ContentEncryptionAlgorithmIdentifier_algorithm_tab,
        ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_0,
        ___ContentEncryptionAlgorithmIdentifier_algorithm_tab_val_Params_1,
        ____ContentEncryptionAlgorithmIdentifier_algorithm_tab_smimeCaps_val_Type,
        _ContentEncryptionAlgorithmIdentifier_algorithm,
        _ContentEncryptionAlgorithmIdentifier_parameters,
        ContentEncryptionAlgorithmIdentifier,
        ContentEncryptionAlgorithmSet,
        _ContentEncryptionAlgorithmSet_val_Params_0,
        _ContentEncryptionAlgorithmSet_val_Params_1,
        __MessageAuthenticationCodeAlgorithm_algorithm_tab,
        ___MessageAuthenticationCodeAlgorithm_algorithm_tab_val_Params_0,
        _MessageAuthenticationCodeAlgorithm_algorithm,
        _MessageAuthenticationCodeAlgorithm_parameters,
        MessageAuthenticationCodeAlgorithm,
        MessageAuthenticationCodeAlgorithmSet,
        _MessageAuthenticationCodeAlgorithmSet_val_Params_0,
        __KeyDerivationAlgorithmIdentifier_algorithm_tab,
        ___KeyDerivationAlgorithmIdentifier_algorithm_tab_val_Params_0,
        _KeyDerivationAlgorithmIdentifier_algorithm,
        _KeyDerivationAlgorithmIdentifier_parameters,
        KeyDerivationAlgorithmIdentifier,
        _RevocationInfoChoices__item_,
        RevocationInfoChoices,
        _RevocationInfoChoice_crl,
        _RevocationInfoChoice_other,
        RevocationInfoChoice,
        OTHER_REVOK_INFO,
        __OtherRevocationInfoFormat_otherRevInfoFormat_tab,
        _OtherRevocationInfoFormat_otherRevInfoFormat,
        __OtherRevocationInfoFormat_otherRevInfo_tab,
        _OtherRevocationInfoFormat_otherRevInfo,
        OtherRevocationInfoFormat,
        SupportedOtherRevokInfo,
        _CertificateChoices_certificate,
        _CertificateChoices_extendedCertificate,
        _CertificateChoices_v1AttrCert,
        _CertificateChoices_v2AttrCert,
        _CertificateChoices_other,
        CertificateChoices,
        AttributeCertificateV2,
        OTHER_CERT_FMT,
        __OtherCertificateFormat_otherCertFormat_tab,
        _OtherCertificateFormat_otherCertFormat,
        __OtherCertificateFormat_otherCert_tab,
        _OtherCertificateFormat_otherCert,
        OtherCertificateFormat,
        SupportedCertFormats,
        _CertificateSet__item_,
        CertificateSet,
        _IssuerAndSerialNumber_issuer,
        _IssuerAndSerialNumber_serialNumber,
        IssuerAndSerialNumber,
        CMSVersion,
        UserKeyingMaterial,
        KEY_ATTRIBUTE,
        __OtherKeyAttribute_keyAttrId_tab,
        _OtherKeyAttribute_keyAttrId,
        __OtherKeyAttribute_keyAttr_tab,
        _OtherKeyAttribute_keyAttr,
        OtherKeyAttribute,
        SupportedKeyAttributes,
        id_ct_contentInfo,
        ct_Data,
        _ct_Data_val_Type,
        id_data,
        ct_SignedData,
        _ct_SignedData_val_Type,
        id_signedData,
        ct_EnvelopedData,
        _ct_EnvelopedData_val_Type,
        id_envelopedData,
        ct_DigestedData,
        _ct_DigestedData_val_Type,
        id_digestedData,
        ct_EncryptedData,
        _ct_EncryptedData_val_Type,
        id_encryptedData,
        ct_AuthenticatedData,
        _ct_AuthenticatedData_val_Type,
        id_ct_authData,
        MessageDigest,
        SigningTime,
        _Time_utcTime,
        _Time_generalTime,
        Time,
        Countersignature,
        aa_contentType,
        _aa_contentType_val_Type,
        id_contentType,
        aa_messageDigest,
        _aa_messageDigest_val_Type,
        id_messageDigest,
        aa_signingTime,
        _aa_signingTime_val_Type,
        id_signingTime,
        aa_countersignature,
        _aa_countersignature_val_Type,
        id_countersignature,
        _ExtendedCertificateOrCertificate_certificate,
        _ExtendedCertificateOrCertificate_extendedCertificate,
        ExtendedCertificateOrCertificate,
        _ExtendedCertificate_extendedCertificateInfo,
        _ExtendedCertificate_signatureAlgorithm,
        _ExtendedCertificate_signature,
        ExtendedCertificate,
        _ExtendedCertificateInfo_version,
        _ExtendedCertificateInfo_certificate,
        _ExtendedCertificateInfo_attributes,
        ExtendedCertificateInfo,
        Signature,
    ]

class CryptographicMessageSyntaxAlgorithms_2009:

    _name_  = u'CryptographicMessageSyntaxAlgorithms-2009'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 37]
    
    _obj_ = [
        u'MessageDigestAlgs',
        u'SignatureAlgs',
        u'KeyAgreementAlgs',
        u'KeyAgreePublicKeys',
        u'KeyTransportAlgs',
        u'KeyWrapAlgs',
        u'KeyDerivationAlgs',
        u'ContentEncryptionAlgs',
        u'MessageAuthAlgs',
        u'SMimeCaps',
        u'id-alg-ESDH',
        u'id-alg-SSDH',
        u'id-alg-CMS3DESwrap',
        u'id-alg-CMSRC2wrap',
        u'des-ede3-cbc',
        u'rc2-cbc',
        u'hMAC-SHA1',
        u'id-PBKDF2',
        u'KeyWrapAlgorithm',
        u'RC2wrapParameter',
        u'RC2ParameterVersion',
        u'CBCParameter',
        u'IV',
        u'RC2CBCParameter',
        u'maca-hMAC-SHA1',
        u'PBKDF2-PRFsAlgorithmIdentifier',
        u'alg-hMAC-SHA1',
        u'PBKDF2-PRFs',
        u'PBKDF2-SaltSources',
        u'PBKDF2-SaltSourcesAlgorithmIdentifier',
        u'defaultPBKDF2',
        u'PBKDF2-params',
        u'kaa-esdh',
        u'kaa-ssdh',
        u'dh-public-number',
        u'pk-originator-dh',
        u'kwa-3DESWrap',
        u'kwa-RC2Wrap',
        u'kda-PBKDF2',
        u'cea-3DES-cbc',
        u'cea-RC2-cbc',
        u'kt-rsa',
        u'cap-3DESwrap',
        ]
    _type_ = [
        u'KeyWrapAlgorithm',
        u'RC2wrapParameter',
        u'RC2ParameterVersion',
        u'CBCParameter',
        u'IV',
        u'RC2CBCParameter',
        u'PBKDF2-PRFsAlgorithmIdentifier',
        u'PBKDF2-SaltSourcesAlgorithmIdentifier',
        u'PBKDF2-params',
        ]
    _set_ = [
        u'MessageDigestAlgs',
        u'SignatureAlgs',
        u'KeyAgreementAlgs',
        u'KeyAgreePublicKeys',
        u'KeyTransportAlgs',
        u'KeyWrapAlgs',
        u'KeyDerivationAlgs',
        u'ContentEncryptionAlgs',
        u'MessageAuthAlgs',
        u'SMimeCaps',
        u'PBKDF2-PRFs',
        u'PBKDF2-SaltSources',
        ]
    _val_ = [
        u'id-alg-ESDH',
        u'id-alg-SSDH',
        u'id-alg-CMS3DESwrap',
        u'id-alg-CMSRC2wrap',
        u'des-ede3-cbc',
        u'rc2-cbc',
        u'hMAC-SHA1',
        u'id-PBKDF2',
        u'maca-hMAC-SHA1',
        u'alg-hMAC-SHA1',
        u'defaultPBKDF2',
        u'kaa-esdh',
        u'kaa-ssdh',
        u'dh-public-number',
        u'pk-originator-dh',
        u'kwa-3DESWrap',
        u'kwa-RC2Wrap',
        u'kda-PBKDF2',
        u'cea-3DES-cbc',
        u'cea-RC2-cbc',
        u'kt-rsa',
        u'cap-3DESwrap',
        ]
    _class_ = [
        u'MessageDigestAlgs',
        u'SignatureAlgs',
        u'KeyAgreementAlgs',
        u'KeyAgreePublicKeys',
        u'KeyTransportAlgs',
        u'KeyWrapAlgs',
        u'KeyDerivationAlgs',
        u'ContentEncryptionAlgs',
        u'MessageAuthAlgs',
        u'SMimeCaps',
        u'maca-hMAC-SHA1',
        u'alg-hMAC-SHA1',
        u'PBKDF2-PRFs',
        u'PBKDF2-SaltSources',
        u'kaa-esdh',
        u'kaa-ssdh',
        u'pk-originator-dh',
        u'kwa-3DESWrap',
        u'kwa-RC2Wrap',
        u'kda-PBKDF2',
        u'cea-3DES-cbc',
        u'cea-RC2-cbc',
        u'kt-rsa',
        u'cap-3DESwrap',
        ]
    _param_ = [
        ]
    
    #-----< MessageDigestAlgs >-----#
    MessageDigestAlgs = CLASS(name=u'MessageDigestAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    MessageDigestAlgs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< SignatureAlgs >-----#
    SignatureAlgs = CLASS(name=u'SignatureAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    SignatureAlgs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< KeyAgreementAlgs >-----#
    KeyAgreementAlgs = CLASS(name=u'KeyAgreementAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-AGREE')))
    _KeyAgreementAlgs_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _KeyAgreementAlgs_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    KeyAgreementAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5)), (u'Params', _KeyAgreementAlgs_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10)), (u'Params', _KeyAgreementAlgs_val_Params_1), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]))])], rr=[], ev=[], er=[])
    
    #-----< KeyAgreePublicKeys >-----#
    KeyAgreePublicKeys = CLASS(name=u'KeyAgreePublicKeys', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _KeyAgreePublicKeys_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _KeyAgreePublicKeys_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    KeyAgreePublicKeys._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _KeyAgreePublicKeys_val_KeyValue_0), (u'Params', _KeyAgreePublicKeys_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=[], er=[])
    
    #-----< KeyTransportAlgs >-----#
    KeyTransportAlgs = CLASS(name=u'KeyTransportAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    _KeyTransportAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    KeyTransportAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'Params', _KeyTransportAlgs_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]))])], rr=[], ev=[], er=[])
    
    #-----< KeyWrapAlgs >-----#
    KeyWrapAlgs = CLASS(name=u'KeyWrapAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    _KeyWrapAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _KeyWrapAlgs_val_Params_1 = INT(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2wrapParameter')))
    KeyWrapAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6)), (u'Params', _KeyWrapAlgs_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7)), (u'Params', _KeyWrapAlgs_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]))])], rr=[], ev=[], er=[])
    
    #-----< KeyDerivationAlgs >-----#
    KeyDerivationAlgs = CLASS(name=u'KeyDerivationAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-DERIVATION')))
    _KeyDerivationAlgs_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-params')))
    KeyDerivationAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 5, 12)), (u'Params', _KeyDerivationAlgs_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=[], er=[])
    
    #-----< ContentEncryptionAlgs >-----#
    ContentEncryptionAlgs = CLASS(name=u'ContentEncryptionAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    _ContentEncryptionAlgs_val_Params_0 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'IV')))
    _ContentEncryptionAlgs_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2CBCParameter')))
    ____ContentEncryptionAlgorithmIdentifier_algorithm_tab_smimeCaps_val_Type = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    ContentEncryptionAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 3, 7)), (u'Params', _ContentEncryptionAlgs_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 3, 7))]))]), dict([(u'id', (1, 2, 840, 113549, 3, 2)), (u'Params', _ContentEncryptionAlgs_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'Type', ____ContentEncryptionAlgorithmIdentifier_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 3, 2))]))])], rr=[], ev=[], er=[])
    
    #-----< MessageAuthAlgs >-----#
    MessageAuthAlgs = CLASS(name=u'MessageAuthAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    _MessageAuthAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    MessageAuthAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _MessageAuthAlgs_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=[], er=[])
    
    #-----< SMimeCaps >-----#
    SMimeCaps = CLASS(name=u'SMimeCaps', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _SMimeCaps_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _SMimeCaps_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _SMimeCaps_val_Type_6 = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    SMimeCaps._val = ASN1Set(rv=[dict([(u'Type', _SMimeCaps_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]), dict([(u'Type', _SMimeCaps_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]), dict([(u'id', (1, 2, 840, 113549, 3, 7))]), dict([(u'Type', _SMimeCaps_val_Type_6), (u'id', (1, 2, 840, 113549, 3, 2))]), dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))])], rr=[], ev=[], er=[])
    
    #-----< id-alg-ESDH >-----#
    id_alg_ESDH = OID(name=u'id-alg-ESDH', mode=MODE_VALUE)
    id_alg_ESDH._val = (1, 2, 840, 113549, 1, 9, 16, 3, 5)
    
    #-----< id-alg-SSDH >-----#
    id_alg_SSDH = OID(name=u'id-alg-SSDH', mode=MODE_VALUE)
    id_alg_SSDH._val = (1, 2, 840, 113549, 1, 9, 16, 3, 10)
    
    #-----< id-alg-CMS3DESwrap >-----#
    id_alg_CMS3DESwrap = OID(name=u'id-alg-CMS3DESwrap', mode=MODE_VALUE)
    id_alg_CMS3DESwrap._val = (1, 2, 840, 113549, 1, 9, 16, 3, 6)
    
    #-----< id-alg-CMSRC2wrap >-----#
    id_alg_CMSRC2wrap = OID(name=u'id-alg-CMSRC2wrap', mode=MODE_VALUE)
    id_alg_CMSRC2wrap._val = (1, 2, 840, 113549, 1, 9, 16, 3, 7)
    
    #-----< des-ede3-cbc >-----#
    des_ede3_cbc = OID(name=u'des-ede3-cbc', mode=MODE_VALUE)
    des_ede3_cbc._val = (1, 2, 840, 113549, 3, 7)
    
    #-----< rc2-cbc >-----#
    rc2_cbc = OID(name=u'rc2-cbc', mode=MODE_VALUE)
    rc2_cbc._val = (1, 2, 840, 113549, 3, 2)
    
    #-----< hMAC-SHA1 >-----#
    hMAC_SHA1 = OID(name=u'hMAC-SHA1', mode=MODE_VALUE)
    hMAC_SHA1._val = (1, 3, 6, 1, 5, 5, 8, 1, 2)
    
    #-----< id-PBKDF2 >-----#
    id_PBKDF2 = OID(name=u'id-PBKDF2', mode=MODE_VALUE)
    id_PBKDF2._val = (1, 2, 840, 113549, 1, 5, 12)
    
    #-----< KeyWrapAlgorithm >-----#
    KeyWrapAlgorithm = SEQ(name=u'KeyWrapAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _KeyWrapAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-WRAP'), [u'id']))
    __KeyWrapAlgorithm_algorithm_tab = CLASS(name='_tab_KEY-WRAP', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    ___KeyWrapAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___KeyWrapAlgorithm_algorithm_tab_val_Params_1 = INT(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2wrapParameter')))
    __KeyWrapAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6)), (u'Params', ___KeyWrapAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7)), (u'Params', ___KeyWrapAlgorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]))])], rr=[], ev=None, er=[])
    _KeyWrapAlgorithm_algorithm._const_tab = __KeyWrapAlgorithm_algorithm_tab
    _KeyWrapAlgorithm_algorithm._const_tab_at = None
    _KeyWrapAlgorithm_algorithm._const_tab_id = u'id'
    _KeyWrapAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-WRAP'), [u'Params']), opt=True)
    _KeyWrapAlgorithm_parameters._const_tab = __KeyWrapAlgorithm_algorithm_tab
    _KeyWrapAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _KeyWrapAlgorithm_parameters._const_tab_id = u'Params'
    KeyWrapAlgorithm._cont = ASN1Dict([
        (u'algorithm', _KeyWrapAlgorithm_algorithm),
        (u'parameters', _KeyWrapAlgorithm_parameters),
        ])
    KeyWrapAlgorithm._ext = None
    
    #-----< RC2wrapParameter >-----#
    RC2wrapParameter = INT(name=u'RC2wrapParameter', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2ParameterVersion')))
    
    #-----< RC2ParameterVersion >-----#
    RC2ParameterVersion = INT(name=u'RC2ParameterVersion', mode=MODE_TYPE)
    
    #-----< CBCParameter >-----#
    CBCParameter = OCT_STR(name=u'CBCParameter', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'IV')))
    
    #-----< IV >-----#
    IV = OCT_STR(name=u'IV', mode=MODE_TYPE)
    
    #-----< RC2CBCParameter >-----#
    RC2CBCParameter = SEQ(name=u'RC2CBCParameter', mode=MODE_TYPE)
    _RC2CBCParameter_rc2ParameterVersion = INT(name=u'rc2ParameterVersion', mode=MODE_TYPE)
    _RC2CBCParameter_rc2ParameterVersion._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=256)], ev=None, er=[])
    _RC2CBCParameter_iv = OCT_STR(name=u'iv', mode=MODE_TYPE)
    RC2CBCParameter._cont = ASN1Dict([
        (u'rc2ParameterVersion', _RC2CBCParameter_rc2ParameterVersion),
        (u'iv', _RC2CBCParameter_iv),
        ])
    RC2CBCParameter._ext = None
    
    #-----< maca-hMAC-SHA1 >-----#
    maca_hMAC_SHA1 = CLASS(name=u'maca-hMAC-SHA1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    _maca_hMAC_SHA1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    maca_hMAC_SHA1._val = dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _maca_hMAC_SHA1_val_Params), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])
    
    #-----< PBKDF2-PRFsAlgorithmIdentifier >-----#
    PBKDF2_PRFsAlgorithmIdentifier = SEQ(name=u'PBKDF2-PRFsAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _PBKDF2_PRFsAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'id']))
    __PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    ___PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', ___PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=None, er=[])
    _PBKDF2_PRFsAlgorithmIdentifier_algorithm._const_tab = __PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab
    _PBKDF2_PRFsAlgorithmIdentifier_algorithm._const_tab_at = None
    _PBKDF2_PRFsAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _PBKDF2_PRFsAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'Params']), opt=True)
    _PBKDF2_PRFsAlgorithmIdentifier_parameters._const_tab = __PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab
    _PBKDF2_PRFsAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _PBKDF2_PRFsAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    PBKDF2_PRFsAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _PBKDF2_PRFsAlgorithmIdentifier_algorithm),
        (u'parameters', _PBKDF2_PRFsAlgorithmIdentifier_parameters),
        ])
    PBKDF2_PRFsAlgorithmIdentifier._ext = None
    
    #-----< alg-hMAC-SHA1 >-----#
    alg_hMAC_SHA1 = CLASS(name=u'alg-hMAC-SHA1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    _alg_hMAC_SHA1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    alg_hMAC_SHA1._val = dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _alg_hMAC_SHA1_val_Params), (u'paramPresence', u'required')])
    
    #-----< PBKDF2-PRFs >-----#
    PBKDF2_PRFs = CLASS(name=u'PBKDF2-PRFs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    _PBKDF2_PRFs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    PBKDF2_PRFs._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _PBKDF2_PRFs_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=[], er=[])
    
    #-----< PBKDF2-SaltSources >-----#
    PBKDF2_SaltSources = CLASS(name=u'PBKDF2-SaltSources', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    PBKDF2_SaltSources._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< PBKDF2-SaltSourcesAlgorithmIdentifier >-----#
    PBKDF2_SaltSourcesAlgorithmIdentifier = SEQ(name=u'PBKDF2-SaltSourcesAlgorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'id']))
    __PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    __PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm._const_tab = __PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm_tab
    _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm._const_tab_at = None
    _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm._const_tab_id = u'id'
    _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'Params']), opt=True)
    __PBKDF2_SaltSourcesAlgorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    __PBKDF2_SaltSourcesAlgorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters._const_tab = __PBKDF2_SaltSourcesAlgorithmIdentifier_parameters_tab
    _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters._const_tab_id = u'Params'
    PBKDF2_SaltSourcesAlgorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm),
        (u'parameters', _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters),
        ])
    PBKDF2_SaltSourcesAlgorithmIdentifier._ext = None
    
    #-----< defaultPBKDF2 >-----#
    defaultPBKDF2 = SEQ(name=u'defaultPBKDF2', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-PRFsAlgorithmIdentifier')))
    _parameters_val = NULL(name=u'parameters', mode=MODE_TYPE)
    defaultPBKDF2._val = dict([(u'algorithm', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'parameters', (_parameters_val, 0))])
    
    #-----< PBKDF2-params >-----#
    PBKDF2_params = SEQ(name=u'PBKDF2-params', mode=MODE_TYPE)
    _PBKDF2_params_salt = CHOICE(name=u'salt', mode=MODE_TYPE)
    __PBKDF2_params_salt_specified = OCT_STR(name=u'specified', mode=MODE_TYPE)
    __PBKDF2_params_salt_otherSource = SEQ(name=u'otherSource', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-SaltSourcesAlgorithmIdentifier')))
    _PBKDF2_params_salt._cont = ASN1Dict([
        (u'specified', __PBKDF2_params_salt_specified),
        (u'otherSource', __PBKDF2_params_salt_otherSource),
        ])
    _PBKDF2_params_salt._ext = None
    _PBKDF2_params_iterationCount = INT(name=u'iterationCount', mode=MODE_TYPE)
    _PBKDF2_params_iterationCount._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _PBKDF2_params_keyLength = INT(name=u'keyLength', mode=MODE_TYPE, opt=True)
    _PBKDF2_params_keyLength._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _PBKDF2_params_prf = SEQ(name=u'prf', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-PRFsAlgorithmIdentifier')), default=dict([(u'algorithm', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'parameters', (_parameters_val, 0))]))
    PBKDF2_params._cont = ASN1Dict([
        (u'salt', _PBKDF2_params_salt),
        (u'iterationCount', _PBKDF2_params_iterationCount),
        (u'keyLength', _PBKDF2_params_keyLength),
        (u'prf', _PBKDF2_params_prf),
        ])
    PBKDF2_params._ext = None
    
    #-----< kaa-esdh >-----#
    kaa_esdh = CLASS(name=u'kaa-esdh', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-AGREE')))
    _kaa_esdh_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    kaa_esdh._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5)), (u'Params', _kaa_esdh_val_Params), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]))])
    
    #-----< kaa-ssdh >-----#
    kaa_ssdh = CLASS(name=u'kaa-ssdh', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-AGREE')))
    _kaa_ssdh_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    kaa_ssdh._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10)), (u'Params', _kaa_ssdh_val_Params), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])], rr=[], ev=None, er=[])), (u'ukmPresence', u'optional'), (u'smimeCaps', dict([(u'Type', _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]))])
    
    #-----< dh-public-number >-----#
    dh_public_number = OID(name=u'dh-public-number', mode=MODE_VALUE)
    dh_public_number._val = (1, 2, 840, 10046, 2, 1)
    
    #-----< pk-originator-dh >-----#
    pk_originator_dh = CLASS(name=u'pk-originator-dh', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_originator_dh_val_KeyValue = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    pk_originator_dh._val = dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _pk_originator_dh_val_KeyValue), (u'paramPresence', u'absent'), (u'keyUsage', (19, 9))])
    
    #-----< kwa-3DESWrap >-----#
    kwa_3DESWrap = CLASS(name=u'kwa-3DESWrap', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    _kwa_3DESWrap_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    kwa_3DESWrap._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6)), (u'Params', _kwa_3DESWrap_val_Params), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]))])
    
    #-----< kwa-RC2Wrap >-----#
    kwa_RC2Wrap = CLASS(name=u'kwa-RC2Wrap', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-WRAP')))
    _kwa_RC2Wrap_val_Params = INT(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2wrapParameter')))
    kwa_RC2Wrap._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7)), (u'Params', _kwa_RC2Wrap_val_Params), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]))])
    
    #-----< kda-PBKDF2 >-----#
    kda_PBKDF2 = CLASS(name=u'kda-PBKDF2', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-DERIVATION')))
    _kda_PBKDF2_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-params')))
    kda_PBKDF2._val = dict([(u'id', (1, 2, 840, 113549, 1, 5, 12)), (u'Params', _kda_PBKDF2_val_Params), (u'paramPresence', u'required')])
    
    #-----< cea-3DES-cbc >-----#
    cea_3DES_cbc = CLASS(name=u'cea-3DES-cbc', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    _cea_3DES_cbc_val_Params = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'IV')))
    cea_3DES_cbc._val = dict([(u'id', (1, 2, 840, 113549, 3, 7)), (u'Params', _cea_3DES_cbc_val_Params), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 3, 7))]))])
    
    #-----< cea-RC2-cbc >-----#
    cea_RC2_cbc = CLASS(name=u'cea-RC2-cbc', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'CONTENT-ENCRYPTION')))
    _cea_RC2_cbc_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'RC2CBCParameter')))
    cea_RC2_cbc._val = dict([(u'id', (1, 2, 840, 113549, 3, 2)), (u'Params', _cea_RC2_cbc_val_Params), (u'paramPresence', u'required'), (u'smimeCaps', dict([(u'Type', ____ContentEncryptionAlgorithmIdentifier_algorithm_tab_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 3, 2))]))])
    
    #-----< kt-rsa >-----#
    kt_rsa = CLASS(name=u'kt-rsa', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    _kt_rsa_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    kt_rsa._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'Params', _kt_rsa_val_Params), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0), (u'Params', _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]))])
    
    #-----< cap-3DESwrap >-----#
    cap_3DESwrap = CLASS(name=u'cap-3DESwrap', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    cap_3DESwrap._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))])
    
    _all_ = [
        MessageDigestAlgs,
        SignatureAlgs,
        KeyAgreementAlgs,
        _KeyAgreementAlgs_val_Params_0,
        _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0,
        _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0,
        _____KeyAgreeRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_smimeCaps_val_Type,
        _KeyAgreementAlgs_val_Params_1,
        KeyAgreePublicKeys,
        _KeyAgreePublicKeys_val_KeyValue_0,
        _KeyAgreePublicKeys_val_Params_0,
        KeyTransportAlgs,
        _KeyTransportAlgs_val_Params_0,
        _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_KeyValue_0,
        _____KeyTransRecipientInfo_keyEncryptionAlgorithm_algorithm_tab_PublicKeySet_val_Params_0,
        KeyWrapAlgs,
        _KeyWrapAlgs_val_Params_0,
        _KeyWrapAlgs_val_Params_1,
        KeyDerivationAlgs,
        _KeyDerivationAlgs_val_Params_0,
        ContentEncryptionAlgs,
        _ContentEncryptionAlgs_val_Params_0,
        _ContentEncryptionAlgs_val_Params_1,
        ____ContentEncryptionAlgorithmIdentifier_algorithm_tab_smimeCaps_val_Type,
        MessageAuthAlgs,
        _MessageAuthAlgs_val_Params_0,
        SMimeCaps,
        _SMimeCaps_val_Type_0,
        _SMimeCaps_val_Type_1,
        _SMimeCaps_val_Type_6,
        id_alg_ESDH,
        id_alg_SSDH,
        id_alg_CMS3DESwrap,
        id_alg_CMSRC2wrap,
        des_ede3_cbc,
        rc2_cbc,
        hMAC_SHA1,
        id_PBKDF2,
        __KeyWrapAlgorithm_algorithm_tab,
        ___KeyWrapAlgorithm_algorithm_tab_val_Params_0,
        ___KeyWrapAlgorithm_algorithm_tab_val_Params_1,
        _KeyWrapAlgorithm_algorithm,
        _KeyWrapAlgorithm_parameters,
        KeyWrapAlgorithm,
        RC2wrapParameter,
        RC2ParameterVersion,
        CBCParameter,
        IV,
        _RC2CBCParameter_rc2ParameterVersion,
        _RC2CBCParameter_iv,
        RC2CBCParameter,
        maca_hMAC_SHA1,
        _maca_hMAC_SHA1_val_Params,
        __PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab,
        ___PBKDF2_PRFsAlgorithmIdentifier_algorithm_tab_val_Params_0,
        _PBKDF2_PRFsAlgorithmIdentifier_algorithm,
        _PBKDF2_PRFsAlgorithmIdentifier_parameters,
        PBKDF2_PRFsAlgorithmIdentifier,
        alg_hMAC_SHA1,
        _alg_hMAC_SHA1_val_Params,
        PBKDF2_PRFs,
        _PBKDF2_PRFs_val_Params_0,
        PBKDF2_SaltSources,
        __PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm_tab,
        _PBKDF2_SaltSourcesAlgorithmIdentifier_algorithm,
        __PBKDF2_SaltSourcesAlgorithmIdentifier_parameters_tab,
        _PBKDF2_SaltSourcesAlgorithmIdentifier_parameters,
        PBKDF2_SaltSourcesAlgorithmIdentifier,
        defaultPBKDF2,
        _parameters_val,
        __PBKDF2_params_salt_specified,
        __PBKDF2_params_salt_otherSource,
        _PBKDF2_params_salt,
        _PBKDF2_params_iterationCount,
        _PBKDF2_params_keyLength,
        _PBKDF2_params_prf,
        PBKDF2_params,
        kaa_esdh,
        _kaa_esdh_val_Params,
        kaa_ssdh,
        _kaa_ssdh_val_Params,
        dh_public_number,
        pk_originator_dh,
        _pk_originator_dh_val_KeyValue,
        kwa_3DESWrap,
        _kwa_3DESWrap_val_Params,
        kwa_RC2Wrap,
        _kwa_RC2Wrap_val_Params,
        kda_PBKDF2,
        _kda_PBKDF2_val_Params,
        cea_3DES_cbc,
        _cea_3DES_cbc_val_Params,
        cea_RC2_cbc,
        _cea_RC2_cbc_val_Params,
        kt_rsa,
        _kt_rsa_val_Params,
        cap_3DESwrap,
    ]

class SecureMimeMessageV3dot1_2009:

    _name_  = u'SecureMimeMessageV3dot1-2009'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 39]
    
    _obj_ = [
        u'SMimeAttributeSet',
        u'id-aa',
        u'aa-smimeCapabilities',
        u'smimeCapabilities',
        u'SMimeCapsSet',
        u'aa-encrypKeyPref',
        u'id-aa-encrypKeyPref',
        u'SMIMEEncryptionKeyPreference',
        u'id-smime',
        u'id-cap',
        u'cap-preferBinaryInside',
        u'id-cap-preferBinaryInside',
        u'cap-RC2CBC',
        u'SMIMECapabilitiesParametersForRC2CBC',
        ]
    _type_ = [
        u'SMIMEEncryptionKeyPreference',
        u'SMIMECapabilitiesParametersForRC2CBC',
        ]
    _set_ = [
        u'SMimeAttributeSet',
        u'SMimeCapsSet',
        ]
    _val_ = [
        u'id-aa',
        u'aa-smimeCapabilities',
        u'smimeCapabilities',
        u'aa-encrypKeyPref',
        u'id-aa-encrypKeyPref',
        u'id-smime',
        u'id-cap',
        u'cap-preferBinaryInside',
        u'id-cap-preferBinaryInside',
        u'cap-RC2CBC',
        ]
    _class_ = [
        u'SMimeAttributeSet',
        u'aa-smimeCapabilities',
        u'SMimeCapsSet',
        u'aa-encrypKeyPref',
        u'cap-preferBinaryInside',
        u'cap-RC2CBC',
        ]
    _param_ = [
        ]
    
    #-----< SMimeAttributeSet >-----#
    SMimeAttributeSet = CLASS(name=u'SMimeAttributeSet', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _SMimeAttributeSet_val_Type_0 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIMECapabilities')))
    __SMimeAttributeSet_val_Type_0__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIMECapability')))
    ___SMimeAttributeSet_val_Type_0__item__capabilityID = OID(name=u'capabilityID', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SMIME-CAPS'), [u'id']))
    ____SMimeAttributeSet_val_Type_0__item__capabilityID_tab = CLASS(name='_tab_SMIME-CAPS', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_1 = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_13 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_14 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    ____SMimeAttributeSet_val_Type_0__item__capabilityID_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 11, 1))]), dict([(u'Type', _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_1), (u'id', (1, 2, 840, 113549, 3, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'id', (1, 2, 840, 10040, 4, 3))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_13), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]), dict([(u'Type', _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_14), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]), dict([(u'id', (1, 2, 840, 113549, 3, 7))]), dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'Type', _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 7))])], rr=[], ev=None, er=[])
    ___SMimeAttributeSet_val_Type_0__item__capabilityID._const_tab = ____SMimeAttributeSet_val_Type_0__item__capabilityID_tab
    ___SMimeAttributeSet_val_Type_0__item__capabilityID._const_tab_at = None
    ___SMimeAttributeSet_val_Type_0__item__capabilityID._const_tab_id = u'id'
    ___SMimeAttributeSet_val_Type_0__item__parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SMIME-CAPS'), [u'Type']), opt=True)
    ___SMimeAttributeSet_val_Type_0__item__parameters._const_tab = ____SMimeAttributeSet_val_Type_0__item__capabilityID_tab
    ___SMimeAttributeSet_val_Type_0__item__parameters._const_tab_at = ('..', u'capabilityID')
    ___SMimeAttributeSet_val_Type_0__item__parameters._const_tab_id = u'Type'
    __SMimeAttributeSet_val_Type_0__item_._cont = ASN1Dict([
        (u'capabilityID', ___SMimeAttributeSet_val_Type_0__item__capabilityID),
        (u'parameters', ___SMimeAttributeSet_val_Type_0__item__parameters),
        ])
    __SMimeAttributeSet_val_Type_0__item_._ext = None
    _SMimeAttributeSet_val_Type_0._cont = __SMimeAttributeSet_val_Type_0__item_
    _SMimeAttributeSet_val_Type_0._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _SMimeAttributeSet_val_Type_1 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMEEncryptionKeyPreference')))
    SMimeAttributeSet._val = ASN1Set(rv=[dict([(u'Type', _SMimeAttributeSet_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 15))]), dict([(u'Type', _SMimeAttributeSet_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 9, 16, 2, 11))])], rr=[], ev=[], er=[])
    
    #-----< id-aa >-----#
    id_aa = OID(name=u'id-aa', mode=MODE_VALUE)
    id_aa._val = (1, 2, 840, 113549, 1, 9, 16, 2)
    
    #-----< aa-smimeCapabilities >-----#
    aa_smimeCapabilities = CLASS(name=u'aa-smimeCapabilities', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_smimeCapabilities_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIMECapabilities')))
    __aa_smimeCapabilities_val_Type__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIMECapability')))
    ___aa_smimeCapabilities_val_Type__item__capabilityID = OID(name=u'capabilityID', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SMIME-CAPS'), [u'id']))
    ____aa_smimeCapabilities_val_Type__item__capabilityID_tab = CLASS(name='_tab_SMIME-CAPS', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_1 = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_13 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_14 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    ____aa_smimeCapabilities_val_Type__item__capabilityID_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 11, 1))]), dict([(u'Type', _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_1), (u'id', (1, 2, 840, 113549, 3, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'id', (1, 2, 840, 10040, 4, 3))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_13), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]), dict([(u'Type', _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_14), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]), dict([(u'id', (1, 2, 840, 113549, 3, 7))]), dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'Type', _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 7))])], rr=[], ev=None, er=[])
    ___aa_smimeCapabilities_val_Type__item__capabilityID._const_tab = ____aa_smimeCapabilities_val_Type__item__capabilityID_tab
    ___aa_smimeCapabilities_val_Type__item__capabilityID._const_tab_at = None
    ___aa_smimeCapabilities_val_Type__item__capabilityID._const_tab_id = u'id'
    ___aa_smimeCapabilities_val_Type__item__parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SMIME-CAPS'), [u'Type']), opt=True)
    ___aa_smimeCapabilities_val_Type__item__parameters._const_tab = ____aa_smimeCapabilities_val_Type__item__capabilityID_tab
    ___aa_smimeCapabilities_val_Type__item__parameters._const_tab_at = ('..', u'capabilityID')
    ___aa_smimeCapabilities_val_Type__item__parameters._const_tab_id = u'Type'
    __aa_smimeCapabilities_val_Type__item_._cont = ASN1Dict([
        (u'capabilityID', ___aa_smimeCapabilities_val_Type__item__capabilityID),
        (u'parameters', ___aa_smimeCapabilities_val_Type__item__parameters),
        ])
    __aa_smimeCapabilities_val_Type__item_._ext = None
    _aa_smimeCapabilities_val_Type._cont = __aa_smimeCapabilities_val_Type__item_
    _aa_smimeCapabilities_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    aa_smimeCapabilities._val = dict([(u'Type', _aa_smimeCapabilities_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 15))])
    
    #-----< smimeCapabilities >-----#
    smimeCapabilities = OID(name=u'smimeCapabilities', mode=MODE_VALUE)
    smimeCapabilities._val = (1, 2, 840, 113549, 1, 9, 15)
    
    #-----< SMimeCapsSet >-----#
    SMimeCapsSet = CLASS(name=u'SMimeCapsSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _SMimeCapsSet_val_Type_1 = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    _SMimeCapsSet_val_Type_13 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _SMimeCapsSet_val_Type_14 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'KeyWrapAlgorithm')))
    _SMimeCapsSet_val_Type_21 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    SMimeCapsSet._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 11, 1))]), dict([(u'Type', _SMimeCapsSet_val_Type_1), (u'id', (1, 2, 840, 113549, 3, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'id', (1, 2, 840, 10040, 4, 3))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]), dict([(u'Type', _SMimeCapsSet_val_Type_13), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 5))]), dict([(u'Type', _SMimeCapsSet_val_Type_14), (u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 10))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 1))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 6))]), dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 3, 7))]), dict([(u'id', (1, 2, 840, 113549, 3, 7))]), dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'Type', _SMimeCapsSet_val_Type_21), (u'id', (1, 2, 840, 113549, 1, 1, 7))])], rr=[], ev=[], er=[])
    
    #-----< aa-encrypKeyPref >-----#
    aa_encrypKeyPref = CLASS(name=u'aa-encrypKeyPref', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_encrypKeyPref_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMEEncryptionKeyPreference')))
    aa_encrypKeyPref._val = dict([(u'Type', _aa_encrypKeyPref_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 2, 11))])
    
    #-----< id-aa-encrypKeyPref >-----#
    id_aa_encrypKeyPref = OID(name=u'id-aa-encrypKeyPref', mode=MODE_VALUE)
    id_aa_encrypKeyPref._val = (1, 2, 840, 113549, 1, 9, 16, 2, 11)
    
    #-----< SMIMEEncryptionKeyPreference >-----#
    SMIMEEncryptionKeyPreference = CHOICE(name=u'SMIMEEncryptionKeyPreference', mode=MODE_TYPE)
    _SMIMEEncryptionKeyPreference_issuerAndSerialNumber = SEQ(name=u'issuerAndSerialNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    _SMIMEEncryptionKeyPreference_receipentKeyId = SEQ(name=u'receipentKeyId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'RecipientKeyIdentifier')))
    _SMIMEEncryptionKeyPreference_subjectAltKeyIdentifier = OCT_STR(name=u'subjectAltKeyIdentifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'SubjectKeyIdentifier')))
    SMIMEEncryptionKeyPreference._cont = ASN1Dict([
        (u'issuerAndSerialNumber', _SMIMEEncryptionKeyPreference_issuerAndSerialNumber),
        (u'receipentKeyId', _SMIMEEncryptionKeyPreference_receipentKeyId),
        (u'subjectAltKeyIdentifier', _SMIMEEncryptionKeyPreference_subjectAltKeyIdentifier),
        ])
    SMIMEEncryptionKeyPreference._ext = None
    
    #-----< id-smime >-----#
    id_smime = OID(name=u'id-smime', mode=MODE_VALUE)
    id_smime._val = (1, 2, 840, 113549, 1, 9, 16)
    
    #-----< id-cap >-----#
    id_cap = OID(name=u'id-cap', mode=MODE_VALUE)
    id_cap._val = (1, 2, 840, 113549, 1, 9, 16, 11)
    
    #-----< cap-preferBinaryInside >-----#
    cap_preferBinaryInside = CLASS(name=u'cap-preferBinaryInside', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    cap_preferBinaryInside._val = dict([(u'id', (1, 2, 840, 113549, 1, 9, 16, 11, 1))])
    
    #-----< id-cap-preferBinaryInside >-----#
    id_cap_preferBinaryInside = OID(name=u'id-cap-preferBinaryInside', mode=MODE_VALUE)
    id_cap_preferBinaryInside._val = (1, 2, 840, 113549, 1, 9, 16, 11, 1)
    
    #-----< cap-RC2CBC >-----#
    cap_RC2CBC = CLASS(name=u'cap-RC2CBC', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _cap_RC2CBC_val_Type = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SecureMimeMessageV3dot1-2009', 'SMIMECapabilitiesParametersForRC2CBC')))
    cap_RC2CBC._val = dict([(u'Type', _cap_RC2CBC_val_Type), (u'id', (1, 2, 840, 113549, 3, 2))])
    
    #-----< SMIMECapabilitiesParametersForRC2CBC >-----#
    SMIMECapabilitiesParametersForRC2CBC = INT(name=u'SMIMECapabilitiesParametersForRC2CBC', mode=MODE_TYPE)
    SMIMECapabilitiesParametersForRC2CBC._const_val = ASN1Set(rv=[40, 128], rr=[], ev=[], er=[])
    
    _all_ = [
        SMimeAttributeSet,
        ____SMimeAttributeSet_val_Type_0__item__capabilityID_tab,
        _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_1,
        _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_13,
        _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_14,
        _____SMimeAttributeSet_val_Type_0__item__capabilityID_tab_val_Type_21,
        ___SMimeAttributeSet_val_Type_0__item__capabilityID,
        ___SMimeAttributeSet_val_Type_0__item__parameters,
        __SMimeAttributeSet_val_Type_0__item_,
        _SMimeAttributeSet_val_Type_0,
        _SMimeAttributeSet_val_Type_1,
        id_aa,
        aa_smimeCapabilities,
        ____aa_smimeCapabilities_val_Type__item__capabilityID_tab,
        _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_1,
        _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_13,
        _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_14,
        _____aa_smimeCapabilities_val_Type__item__capabilityID_tab_val_Type_21,
        ___aa_smimeCapabilities_val_Type__item__capabilityID,
        ___aa_smimeCapabilities_val_Type__item__parameters,
        __aa_smimeCapabilities_val_Type__item_,
        _aa_smimeCapabilities_val_Type,
        smimeCapabilities,
        SMimeCapsSet,
        _SMimeCapsSet_val_Type_1,
        _SMimeCapsSet_val_Type_13,
        _SMimeCapsSet_val_Type_14,
        _SMimeCapsSet_val_Type_21,
        aa_encrypKeyPref,
        _aa_encrypKeyPref_val_Type,
        id_aa_encrypKeyPref,
        _SMIMEEncryptionKeyPreference_issuerAndSerialNumber,
        _SMIMEEncryptionKeyPreference_receipentKeyId,
        _SMIMEEncryptionKeyPreference_subjectAltKeyIdentifier,
        SMIMEEncryptionKeyPreference,
        id_smime,
        id_cap,
        cap_preferBinaryInside,
        id_cap_preferBinaryInside,
        cap_RC2CBC,
        _cap_RC2CBC_val_Type,
        SMIMECapabilitiesParametersForRC2CBC,
    ]

class AlgorithmInformation_2009:

    _name_  = u'AlgorithmInformation-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 58]
    
    _obj_ = [
        u'ParamOptions',
        u'DIGEST-ALGORITHM',
        u'SIGNATURE-ALGORITHM',
        u'PUBLIC-KEY',
        u'KEY-TRANSPORT',
        u'KEY-AGREE',
        u'KEY-WRAP',
        u'KEY-DERIVATION',
        u'MAC-ALGORITHM',
        u'CONTENT-ENCRYPTION',
        u'ALGORITHM',
        u'AlgorithmIdentifier',
        u'SMIME-CAPS',
        u'SMIMECapability',
        u'SMIMECapabilities',
        ]
    _type_ = [
        u'ParamOptions',
        u'DIGEST-ALGORITHM',
        u'SIGNATURE-ALGORITHM',
        u'PUBLIC-KEY',
        u'KEY-TRANSPORT',
        u'KEY-AGREE',
        u'KEY-WRAP',
        u'KEY-DERIVATION',
        u'MAC-ALGORITHM',
        u'CONTENT-ENCRYPTION',
        u'ALGORITHM',
        u'AlgorithmIdentifier',
        u'SMIME-CAPS',
        u'SMIMECapability',
        u'SMIMECapabilities',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        u'DIGEST-ALGORITHM',
        u'SIGNATURE-ALGORITHM',
        u'PUBLIC-KEY',
        u'KEY-TRANSPORT',
        u'KEY-AGREE',
        u'KEY-WRAP',
        u'KEY-DERIVATION',
        u'MAC-ALGORITHM',
        u'CONTENT-ENCRYPTION',
        u'ALGORITHM',
        u'SMIME-CAPS',
        ]
    _param_ = [
        u'AlgorithmIdentifier',
        u'SMIMECapability',
        u'SMIMECapabilities',
        ]
    
    #-----< ParamOptions >-----#
    ParamOptions = ENUM(name=u'ParamOptions', mode=MODE_TYPE)
    ParamOptions._cont = ASN1Dict([(u'required', 0), (u'preferredPresent', 1), (u'preferredAbsent', 2), (u'absent', 3), (u'inheritable', 4), (u'optional', 5)])
    ParamOptions._ext = []
    
    #-----< DIGEST-ALGORITHM >-----#
    DIGEST_ALGORITHM = CLASS(name=u'DIGEST-ALGORITHM', mode=MODE_TYPE)
    _DIGEST_ALGORITHM_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _DIGEST_ALGORITHM_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _DIGEST_ALGORITHM_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    DIGEST_ALGORITHM._cont = ASN1Dict([
        (u'id', _DIGEST_ALGORITHM_id),
        (u'Params', _DIGEST_ALGORITHM_Params),
        (u'paramPresence', _DIGEST_ALGORITHM_paramPresence),
        ])
    
    #-----< SIGNATURE-ALGORITHM >-----#
    SIGNATURE_ALGORITHM = CLASS(name=u'SIGNATURE-ALGORITHM', mode=MODE_TYPE)
    _SIGNATURE_ALGORITHM_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _SIGNATURE_ALGORITHM_Value = OPEN(name=u'Value', mode=MODE_TYPE, opt=True)
    _SIGNATURE_ALGORITHM_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _SIGNATURE_ALGORITHM_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _SIGNATURE_ALGORITHM_HashSet = CLASS(name=u'HashSet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')), opt=True)
    _SIGNATURE_ALGORITHM_PublicKeySet = CLASS(name=u'PublicKeySet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')), opt=True)
    _SIGNATURE_ALGORITHM_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    SIGNATURE_ALGORITHM._cont = ASN1Dict([
        (u'id', _SIGNATURE_ALGORITHM_id),
        (u'Value', _SIGNATURE_ALGORITHM_Value),
        (u'Params', _SIGNATURE_ALGORITHM_Params),
        (u'paramPresence', _SIGNATURE_ALGORITHM_paramPresence),
        (u'HashSet', _SIGNATURE_ALGORITHM_HashSet),
        (u'PublicKeySet', _SIGNATURE_ALGORITHM_PublicKeySet),
        (u'smimeCaps', _SIGNATURE_ALGORITHM_smimeCaps),
        ])
    
    #-----< PUBLIC-KEY >-----#
    PUBLIC_KEY = CLASS(name=u'PUBLIC-KEY', mode=MODE_TYPE)
    _PUBLIC_KEY_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _PUBLIC_KEY_KeyValue = OPEN(name=u'KeyValue', mode=MODE_TYPE, opt=True)
    _PUBLIC_KEY_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _PUBLIC_KEY_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _PUBLIC_KEY_keyUsage = BIT_STR(name=u'keyUsage', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyUsage')), opt=True)
    _PUBLIC_KEY_PrivateKey = OPEN(name=u'PrivateKey', mode=MODE_TYPE, opt=True)
    PUBLIC_KEY._cont = ASN1Dict([
        (u'id', _PUBLIC_KEY_id),
        (u'KeyValue', _PUBLIC_KEY_KeyValue),
        (u'Params', _PUBLIC_KEY_Params),
        (u'paramPresence', _PUBLIC_KEY_paramPresence),
        (u'keyUsage', _PUBLIC_KEY_keyUsage),
        (u'PrivateKey', _PUBLIC_KEY_PrivateKey),
        ])
    
    #-----< KEY-TRANSPORT >-----#
    KEY_TRANSPORT = CLASS(name=u'KEY-TRANSPORT', mode=MODE_TYPE)
    _KEY_TRANSPORT_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _KEY_TRANSPORT_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _KEY_TRANSPORT_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _KEY_TRANSPORT_PublicKeySet = CLASS(name=u'PublicKeySet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')), opt=True)
    _KEY_TRANSPORT_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    KEY_TRANSPORT._cont = ASN1Dict([
        (u'id', _KEY_TRANSPORT_id),
        (u'Params', _KEY_TRANSPORT_Params),
        (u'paramPresence', _KEY_TRANSPORT_paramPresence),
        (u'PublicKeySet', _KEY_TRANSPORT_PublicKeySet),
        (u'smimeCaps', _KEY_TRANSPORT_smimeCaps),
        ])
    
    #-----< KEY-AGREE >-----#
    KEY_AGREE = CLASS(name=u'KEY-AGREE', mode=MODE_TYPE)
    _KEY_AGREE_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _KEY_AGREE_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _KEY_AGREE_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _KEY_AGREE_PublicKeySet = CLASS(name=u'PublicKeySet', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')), opt=True)
    _KEY_AGREE_Ukm = OPEN(name=u'Ukm', mode=MODE_TYPE, opt=True)
    _KEY_AGREE_ukmPresence = ENUM(name=u'ukmPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _KEY_AGREE_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    KEY_AGREE._cont = ASN1Dict([
        (u'id', _KEY_AGREE_id),
        (u'Params', _KEY_AGREE_Params),
        (u'paramPresence', _KEY_AGREE_paramPresence),
        (u'PublicKeySet', _KEY_AGREE_PublicKeySet),
        (u'Ukm', _KEY_AGREE_Ukm),
        (u'ukmPresence', _KEY_AGREE_ukmPresence),
        (u'smimeCaps', _KEY_AGREE_smimeCaps),
        ])
    
    #-----< KEY-WRAP >-----#
    KEY_WRAP = CLASS(name=u'KEY-WRAP', mode=MODE_TYPE)
    _KEY_WRAP_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _KEY_WRAP_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _KEY_WRAP_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _KEY_WRAP_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    KEY_WRAP._cont = ASN1Dict([
        (u'id', _KEY_WRAP_id),
        (u'Params', _KEY_WRAP_Params),
        (u'paramPresence', _KEY_WRAP_paramPresence),
        (u'smimeCaps', _KEY_WRAP_smimeCaps),
        ])
    
    #-----< KEY-DERIVATION >-----#
    KEY_DERIVATION = CLASS(name=u'KEY-DERIVATION', mode=MODE_TYPE)
    _KEY_DERIVATION_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _KEY_DERIVATION_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _KEY_DERIVATION_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _KEY_DERIVATION_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    KEY_DERIVATION._cont = ASN1Dict([
        (u'id', _KEY_DERIVATION_id),
        (u'Params', _KEY_DERIVATION_Params),
        (u'paramPresence', _KEY_DERIVATION_paramPresence),
        (u'smimeCaps', _KEY_DERIVATION_smimeCaps),
        ])
    
    #-----< MAC-ALGORITHM >-----#
    MAC_ALGORITHM = CLASS(name=u'MAC-ALGORITHM', mode=MODE_TYPE)
    _MAC_ALGORITHM_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _MAC_ALGORITHM_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _MAC_ALGORITHM_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _MAC_ALGORITHM_keyed = BOOL(name=u'keyed', mode=MODE_VALUE)
    _MAC_ALGORITHM_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    MAC_ALGORITHM._cont = ASN1Dict([
        (u'id', _MAC_ALGORITHM_id),
        (u'Params', _MAC_ALGORITHM_Params),
        (u'paramPresence', _MAC_ALGORITHM_paramPresence),
        (u'keyed', _MAC_ALGORITHM_keyed),
        (u'smimeCaps', _MAC_ALGORITHM_smimeCaps),
        ])
    
    #-----< CONTENT-ENCRYPTION >-----#
    CONTENT_ENCRYPTION = CLASS(name=u'CONTENT-ENCRYPTION', mode=MODE_TYPE)
    _CONTENT_ENCRYPTION_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _CONTENT_ENCRYPTION_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _CONTENT_ENCRYPTION_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _CONTENT_ENCRYPTION_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    CONTENT_ENCRYPTION._cont = ASN1Dict([
        (u'id', _CONTENT_ENCRYPTION_id),
        (u'Params', _CONTENT_ENCRYPTION_Params),
        (u'paramPresence', _CONTENT_ENCRYPTION_paramPresence),
        (u'smimeCaps', _CONTENT_ENCRYPTION_smimeCaps),
        ])
    
    #-----< ALGORITHM >-----#
    ALGORITHM = CLASS(name=u'ALGORITHM', mode=MODE_TYPE)
    _ALGORITHM_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _ALGORITHM_Params = OPEN(name=u'Params', mode=MODE_TYPE, opt=True)
    _ALGORITHM_paramPresence = ENUM(name=u'paramPresence', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ParamOptions')), default=u'absent')
    _ALGORITHM_smimeCaps = CLASS(name=u'smimeCaps', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')), opt=True)
    ALGORITHM._cont = ASN1Dict([
        (u'id', _ALGORITHM_id),
        (u'Params', _ALGORITHM_Params),
        (u'paramPresence', _ALGORITHM_paramPresence),
        (u'smimeCaps', _ALGORITHM_smimeCaps),
        ])
    
    #-----< AlgorithmIdentifier >-----#
    AlgorithmIdentifier = SEQ(name=u'AlgorithmIdentifier', mode=MODE_TYPE, param=True)
    
    #-----< SMIME-CAPS >-----#
    SMIME_CAPS = CLASS(name=u'SMIME-CAPS', mode=MODE_TYPE)
    _SMIME_CAPS_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _SMIME_CAPS_Type = OPEN(name=u'Type', mode=MODE_TYPE, opt=True)
    SMIME_CAPS._cont = ASN1Dict([
        (u'id', _SMIME_CAPS_id),
        (u'Type', _SMIME_CAPS_Type),
        ])
    
    #-----< SMIMECapability >-----#
    SMIMECapability = SEQ(name=u'SMIMECapability', mode=MODE_TYPE, param=True)
    
    #-----< SMIMECapabilities >-----#
    SMIMECapabilities = SEQ_OF(name=u'SMIMECapabilities', mode=MODE_TYPE, param=True)
    
    _all_ = [
        ParamOptions,
        _DIGEST_ALGORITHM_id,
        _DIGEST_ALGORITHM_Params,
        _DIGEST_ALGORITHM_paramPresence,
        DIGEST_ALGORITHM,
        _SIGNATURE_ALGORITHM_id,
        _SIGNATURE_ALGORITHM_Value,
        _SIGNATURE_ALGORITHM_Params,
        _SIGNATURE_ALGORITHM_paramPresence,
        _SIGNATURE_ALGORITHM_HashSet,
        _SIGNATURE_ALGORITHM_PublicKeySet,
        _SIGNATURE_ALGORITHM_smimeCaps,
        SIGNATURE_ALGORITHM,
        _PUBLIC_KEY_id,
        _PUBLIC_KEY_KeyValue,
        _PUBLIC_KEY_Params,
        _PUBLIC_KEY_paramPresence,
        _PUBLIC_KEY_keyUsage,
        _PUBLIC_KEY_PrivateKey,
        PUBLIC_KEY,
        _KEY_TRANSPORT_id,
        _KEY_TRANSPORT_Params,
        _KEY_TRANSPORT_paramPresence,
        _KEY_TRANSPORT_PublicKeySet,
        _KEY_TRANSPORT_smimeCaps,
        KEY_TRANSPORT,
        _KEY_AGREE_id,
        _KEY_AGREE_Params,
        _KEY_AGREE_paramPresence,
        _KEY_AGREE_PublicKeySet,
        _KEY_AGREE_Ukm,
        _KEY_AGREE_ukmPresence,
        _KEY_AGREE_smimeCaps,
        KEY_AGREE,
        _KEY_WRAP_id,
        _KEY_WRAP_Params,
        _KEY_WRAP_paramPresence,
        _KEY_WRAP_smimeCaps,
        KEY_WRAP,
        _KEY_DERIVATION_id,
        _KEY_DERIVATION_Params,
        _KEY_DERIVATION_paramPresence,
        _KEY_DERIVATION_smimeCaps,
        KEY_DERIVATION,
        _MAC_ALGORITHM_id,
        _MAC_ALGORITHM_Params,
        _MAC_ALGORITHM_paramPresence,
        _MAC_ALGORITHM_keyed,
        _MAC_ALGORITHM_smimeCaps,
        MAC_ALGORITHM,
        _CONTENT_ENCRYPTION_id,
        _CONTENT_ENCRYPTION_Params,
        _CONTENT_ENCRYPTION_paramPresence,
        _CONTENT_ENCRYPTION_smimeCaps,
        CONTENT_ENCRYPTION,
        _ALGORITHM_id,
        _ALGORITHM_Params,
        _ALGORITHM_paramPresence,
        _ALGORITHM_smimeCaps,
        ALGORITHM,
        _SMIME_CAPS_id,
        _SMIME_CAPS_Type,
        SMIME_CAPS,
    ]

class AttributeCertificateVersion1_2009:

    _name_  = u'AttributeCertificateVersion1-2009'
    _oid_   = [1, 2, 840, 113549, 1, 9, 16, 0, 49]
    
    _obj_ = [
        u'AttributeCertificateV1',
        u'AttributeCertificateInfoV1',
        u'AttCertVersionV1',
        u'AttrList',
        u'AttributeCertExtensionsV1',
        ]
    _type_ = [
        u'AttributeCertificateV1',
        u'AttributeCertificateInfoV1',
        u'AttCertVersionV1',
        ]
    _set_ = [
        u'AttrList',
        u'AttributeCertExtensionsV1',
        ]
    _val_ = [
        ]
    _class_ = [
        u'AttrList',
        u'AttributeCertExtensionsV1',
        ]
    _param_ = [
        ]
    
    #-----< AttributeCertificateV1 >-----#
    AttributeCertificateV1 = SEQ(name=u'AttributeCertificateV1', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'SIGNED')))
    _AttributeCertificateV1_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateVersion1-2009', 'AttributeCertificateInfoV1')))
    _AttributeCertificateV1_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE)
    __AttributeCertificateV1_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    __SIGNATURE_ALGORITHM_HashSet_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_3), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_4), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_5), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_6), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_7), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_8), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_9), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_10), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __AttributeCertificateV1_algorithmIdentifier_algorithm._const_tab = ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab
    __AttributeCertificateV1_algorithmIdentifier_algorithm._const_tab_at = None
    __AttributeCertificateV1_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __AttributeCertificateV1_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __AttributeCertificateV1_algorithmIdentifier_parameters._const_tab = ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab
    __AttributeCertificateV1_algorithmIdentifier_parameters._const_tab_at = ('..', '..', u'algorithmIdentifier', u'algorithm')
    __AttributeCertificateV1_algorithmIdentifier_parameters._const_tab_id = u'Params'
    _AttributeCertificateV1_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificateV1_algorithmIdentifier_algorithm),
        (u'parameters', __AttributeCertificateV1_algorithmIdentifier_parameters),
        ])
    _AttributeCertificateV1_algorithmIdentifier._ext = None
    _AttributeCertificateV1_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    __AttributeCertificateV1_signature_contain = OPEN(name='_cont_signature', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Value']))
    __AttributeCertificateV1_signature_contain._const_tab = ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab
    __AttributeCertificateV1_signature_contain._const_tab_at = ('..', u'algorithmIdentifier', u'algorithm')
    __AttributeCertificateV1_signature_contain._const_tab_id = u'Value'
    _AttributeCertificateV1_signature._const_cont = __AttributeCertificateV1_signature_contain
    AttributeCertificateV1._cont = ASN1Dict([
        (u'toBeSigned', _AttributeCertificateV1_toBeSigned),
        (u'algorithmIdentifier', _AttributeCertificateV1_algorithmIdentifier),
        (u'signature', _AttributeCertificateV1_signature),
        ])
    AttributeCertificateV1._ext = None
    
    #-----< AttributeCertificateInfoV1 >-----#
    AttributeCertificateInfoV1 = SEQ(name=u'AttributeCertificateInfoV1', mode=MODE_TYPE)
    _AttributeCertificateInfoV1_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateVersion1-2009', 'AttCertVersionV1')), default=0)
    _AttributeCertificateInfoV1_subject = CHOICE(name=u'subject', mode=MODE_TYPE)
    __AttributeCertificateInfoV1_subject_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IssuerSerial')))
    __AttributeCertificateInfoV1_subject_subjectName = SEQ_OF(name=u'subjectName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _AttributeCertificateInfoV1_subject._cont = ASN1Dict([
        (u'baseCertificateID', __AttributeCertificateInfoV1_subject_baseCertificateID),
        (u'subjectName', __AttributeCertificateInfoV1_subject_subjectName),
        ])
    _AttributeCertificateInfoV1_subject._ext = None
    _AttributeCertificateInfoV1_issuer = SEQ_OF(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _AttributeCertificateInfoV1_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __AttributeCertificateInfoV1_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___AttributeCertificateInfoV1_signature_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ___AttributeCertificateInfoV1_signature_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __AttributeCertificateInfoV1_signature_algorithm._const_tab = ___AttributeCertificateInfoV1_signature_algorithm_tab
    __AttributeCertificateInfoV1_signature_algorithm._const_tab_at = None
    __AttributeCertificateInfoV1_signature_algorithm._const_tab_id = u'id'
    __AttributeCertificateInfoV1_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    ___AttributeCertificateInfoV1_signature_parameters_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ___AttributeCertificateInfoV1_signature_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __AttributeCertificateInfoV1_signature_parameters._const_tab = ___AttributeCertificateInfoV1_signature_parameters_tab
    __AttributeCertificateInfoV1_signature_parameters._const_tab_at = ('..', u'algorithm')
    __AttributeCertificateInfoV1_signature_parameters._const_tab_id = u'Params'
    _AttributeCertificateInfoV1_signature._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificateInfoV1_signature_algorithm),
        (u'parameters', __AttributeCertificateInfoV1_signature_parameters),
        ])
    _AttributeCertificateInfoV1_signature._ext = None
    _AttributeCertificateInfoV1_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    _AttributeCertificateInfoV1_attCertValidityPeriod = SEQ(name=u'attCertValidityPeriod', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttCertValidityPeriod')))
    _AttributeCertificateInfoV1_attributes = SEQ_OF(name=u'attributes', mode=MODE_TYPE)
    __AttributeCertificateInfoV1_attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'AttributeSet')))
    ___AttributeCertificateInfoV1_attributes__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____AttributeCertificateInfoV1_attributes__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____AttributeCertificateInfoV1_attributes__item__type_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AttributeCertificateInfoV1_attributes__item__type._const_tab = ____AttributeCertificateInfoV1_attributes__item__type_tab
    ___AttributeCertificateInfoV1_attributes__item__type._const_tab_at = None
    ___AttributeCertificateInfoV1_attributes__item__type._const_tab_id = u'id'
    ___AttributeCertificateInfoV1_attributes__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AttributeCertificateInfoV1_attributes__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    _____AttributeCertificateInfoV1_attributes__item__values__item__tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____AttributeCertificateInfoV1_attributes__item__values__item__tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____AttributeCertificateInfoV1_attributes__item__values__item_._const_tab = _____AttributeCertificateInfoV1_attributes__item__values__item__tab
    ____AttributeCertificateInfoV1_attributes__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AttributeCertificateInfoV1_attributes__item__values__item_._const_tab_id = u'Type'
    ___AttributeCertificateInfoV1_attributes__item__values._cont = ____AttributeCertificateInfoV1_attributes__item__values__item_
    ___AttributeCertificateInfoV1_attributes__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AttributeCertificateInfoV1_attributes__item_._cont = ASN1Dict([
        (u'type', ___AttributeCertificateInfoV1_attributes__item__type),
        (u'values', ___AttributeCertificateInfoV1_attributes__item__values),
        ])
    __AttributeCertificateInfoV1_attributes__item_._ext = None
    _AttributeCertificateInfoV1_attributes._cont = __AttributeCertificateInfoV1_attributes__item_
    _AttributeCertificateInfoV1_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'UniqueIdentifier')), opt=True)
    _AttributeCertificateInfoV1_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True)
    __AttributeCertificateInfoV1_extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___AttributeCertificateInfoV1_extensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____AttributeCertificateInfoV1_extensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    ____AttributeCertificateInfoV1_extensions__item__extnID_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AttributeCertificateInfoV1_extensions__item__extnID._const_tab = ____AttributeCertificateInfoV1_extensions__item__extnID_tab
    ___AttributeCertificateInfoV1_extensions__item__extnID._const_tab_at = None
    ___AttributeCertificateInfoV1_extensions__item__extnID._const_tab_id = u'id'
    ___AttributeCertificateInfoV1_extensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___AttributeCertificateInfoV1_extensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____AttributeCertificateInfoV1_extensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    _____AttributeCertificateInfoV1_extensions__item__extnValue_contain_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____AttributeCertificateInfoV1_extensions__item__extnValue_contain_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____AttributeCertificateInfoV1_extensions__item__extnValue_contain._const_tab = _____AttributeCertificateInfoV1_extensions__item__extnValue_contain_tab
    ____AttributeCertificateInfoV1_extensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____AttributeCertificateInfoV1_extensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___AttributeCertificateInfoV1_extensions__item__extnValue._const_cont = ____AttributeCertificateInfoV1_extensions__item__extnValue_contain
    __AttributeCertificateInfoV1_extensions__item_._cont = ASN1Dict([
        (u'extnID', ___AttributeCertificateInfoV1_extensions__item__extnID),
        (u'critical', ___AttributeCertificateInfoV1_extensions__item__critical),
        (u'extnValue', ___AttributeCertificateInfoV1_extensions__item__extnValue),
        ])
    __AttributeCertificateInfoV1_extensions__item_._ext = None
    _AttributeCertificateInfoV1_extensions._cont = __AttributeCertificateInfoV1_extensions__item_
    _AttributeCertificateInfoV1_extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    AttributeCertificateInfoV1._cont = ASN1Dict([
        (u'version', _AttributeCertificateInfoV1_version),
        (u'subject', _AttributeCertificateInfoV1_subject),
        (u'issuer', _AttributeCertificateInfoV1_issuer),
        (u'signature', _AttributeCertificateInfoV1_signature),
        (u'serialNumber', _AttributeCertificateInfoV1_serialNumber),
        (u'attCertValidityPeriod', _AttributeCertificateInfoV1_attCertValidityPeriod),
        (u'attributes', _AttributeCertificateInfoV1_attributes),
        (u'issuerUniqueID', _AttributeCertificateInfoV1_issuerUniqueID),
        (u'extensions', _AttributeCertificateInfoV1_extensions),
        ])
    AttributeCertificateInfoV1._ext = None
    
    #-----< AttCertVersionV1 >-----#
    AttCertVersionV1 = INT(name=u'AttCertVersionV1', mode=MODE_TYPE)
    AttCertVersionV1._cont = ASN1Dict([(u'v1', 0)])
    
    #-----< AttrList >-----#
    AttrList = CLASS(name=u'AttrList', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    AttrList._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< AttributeCertExtensionsV1 >-----#
    AttributeCertExtensionsV1 = CLASS(name=u'AttributeCertExtensionsV1', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    AttributeCertExtensionsV1._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    _all_ = [
        _AttributeCertificateV1_toBeSigned,
        ___AttributeCertificateV1_algorithmIdentifier_algorithm_tab,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_1,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_2,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_3,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_3,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_4,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_5,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_5,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_6,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_6,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_7,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_7,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_8,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_8,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_9,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_9,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Value_10,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_10,
        ____AttributeCertificateV1_algorithmIdentifier_algorithm_tab_val_Params_11,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_1,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_2,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_3,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1,
        __AttributeCertificateV1_algorithmIdentifier_algorithm,
        __AttributeCertificateV1_algorithmIdentifier_parameters,
        _AttributeCertificateV1_algorithmIdentifier,
        __AttributeCertificateV1_signature_contain,
        _AttributeCertificateV1_signature,
        AttributeCertificateV1,
        _AttributeCertificateInfoV1_version,
        __AttributeCertificateInfoV1_subject_baseCertificateID,
        __AttributeCertificateInfoV1_subject_subjectName,
        _AttributeCertificateInfoV1_subject,
        _AttributeCertificateInfoV1_issuer,
        ___AttributeCertificateInfoV1_signature_algorithm_tab,
        __AttributeCertificateInfoV1_signature_algorithm,
        ___AttributeCertificateInfoV1_signature_parameters_tab,
        __AttributeCertificateInfoV1_signature_parameters,
        _AttributeCertificateInfoV1_signature,
        _AttributeCertificateInfoV1_serialNumber,
        _AttributeCertificateInfoV1_attCertValidityPeriod,
        ____AttributeCertificateInfoV1_attributes__item__type_tab,
        ___AttributeCertificateInfoV1_attributes__item__type,
        _____AttributeCertificateInfoV1_attributes__item__values__item__tab,
        ____AttributeCertificateInfoV1_attributes__item__values__item_,
        ___AttributeCertificateInfoV1_attributes__item__values,
        __AttributeCertificateInfoV1_attributes__item_,
        _AttributeCertificateInfoV1_attributes,
        _AttributeCertificateInfoV1_issuerUniqueID,
        ____AttributeCertificateInfoV1_extensions__item__extnID_tab,
        ___AttributeCertificateInfoV1_extensions__item__extnID,
        ___AttributeCertificateInfoV1_extensions__item__critical,
        _____AttributeCertificateInfoV1_extensions__item__extnValue_contain_tab,
        ____AttributeCertificateInfoV1_extensions__item__extnValue_contain,
        ___AttributeCertificateInfoV1_extensions__item__extnValue,
        __AttributeCertificateInfoV1_extensions__item_,
        _AttributeCertificateInfoV1_extensions,
        AttributeCertificateInfoV1,
        AttCertVersionV1,
        AttrList,
        AttributeCertExtensionsV1,
    ]

class EnrollmentMessageSyntax_2009:

    _name_  = u'EnrollmentMessageSyntax-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 53]
    
    _obj_ = [
        u'CMC-ContentTypes',
        u'SignatureAlgs',
        u'CMC-UnsignedAtts',
        u'id-cmc',
        u'id-cct',
        u'ct-PKIData',
        u'id-cct-PKIData',
        u'PKIData',
        u'BodyPartID',
        u'TaggedAttribute',
        u'Cmc-Control-Set',
        u'OTHER-REQUEST',
        u'OtherRequests',
        u'TaggedRequest',
        u'TaggedCertificationRequest',
        u'AttributeList',
        u'CertificationRequest',
        u'TaggedContentInfo',
        u'OTHER-MSG',
        u'OtherMsgSet',
        u'OtherMsg',
        u'ct-PKIResponse',
        u'id-cct-PKIResponse',
        u'ResponseBody',
        u'PKIResponse',
        u'CMC-CONTROL',
        u'cmc-identityProof',
        u'id-cmc-identityProof',
        u'cmc-dataReturn',
        u'id-cmc-dataReturn',
        u'cmc-regInfo',
        u'id-cmc-regInfo',
        u'cmc-responseInfo',
        u'id-cmc-responseInfo',
        u'cmc-queryPending',
        u'id-cmc-queryPending',
        u'cmc-popLinkRandom',
        u'id-cmc-popLinkRandom',
        u'cmc-popLinkWitness',
        u'id-cmc-popLinkWitness',
        u'cmc-identification',
        u'id-cmc-identification',
        u'cmc-transactionId',
        u'id-cmc-transactionId',
        u'cmc-senderNonce',
        u'id-cmc-senderNonce',
        u'cmc-recipientNonce',
        u'id-cmc-recipientNonce',
        u'cmc-statusInfo',
        u'id-cmc-statusInfo',
        u'CMCStatusInfo',
        u'PendInfo',
        u'CMCStatus',
        u'CMCFailInfo',
        u'cmc-addExtensions',
        u'id-cmc-addExtensions',
        u'AddExtensions',
        u'cmc-encryptedPOP',
        u'cmc-decryptedPOP',
        u'id-cmc-encryptedPOP',
        u'id-cmc-decryptedPOP',
        u'EncryptedPOP',
        u'POPAlgs',
        u'WitnessAlgs',
        u'DecryptedPOP',
        u'cmc-lraPOPWitness',
        u'id-cmc-lraPOPWitness',
        u'LraPopWitness',
        u'cmc-getCert',
        u'id-cmc-getCert',
        u'GetCert',
        u'cmc-getCRL',
        u'id-cmc-getCRL',
        u'GetCRL',
        u'cmc-revokeRequest',
        u'id-cmc-revokeRequest',
        u'RevokeRequest',
        u'cmc-confirmCertAcceptance',
        u'id-cmc-confirmCertAcceptance',
        u'CMCCertId',
        u'at-extension-req',
        u'id-ExtensionReq',
        u'ExtensionReq',
        u'sa-noSignature',
        u'id-alg-noSignature',
        u'NoSignatureValue',
        u'id-aa',
        u'aa-cmc-unsignedData',
        u'id-aa-cmc-unsignedData',
        u'CMCUnsignedData',
        u'cmc-statusInfoV2',
        u'id-cmc-statusInfoV2',
        u'EXTENDED-FAILURE-INFO',
        u'ExtendedFailures',
        u'CMCStatusInfoV2',
        u'BodyPartReference',
        u'BodyPartPath',
        u'cmc-trustedAnchors',
        u'id-cmc-trustedAnchors',
        u'PublishTrustAnchors',
        u'HashAlgorithms',
        u'cmc-authData',
        u'id-cmc-authData',
        u'AuthPublish',
        u'cmc-batchRequests',
        u'id-cmc-batchRequests',
        u'cmc-batchResponses',
        u'id-cmc-batchResponses',
        u'BodyPartList',
        u'cmc-publishCert',
        u'id-cmc-publishCert',
        u'CMCPublicationInfo',
        u'cmc-modCertTemplate',
        u'id-cmc-modCertTemplate',
        u'ModCertTemplate',
        u'cmc-controlProcessed',
        u'id-cmc-controlProcessed',
        u'ControlsProcessed',
        u'cmc-identityProofV2',
        u'id-cmc-identityProofV2',
        u'IdentityProofV2',
        u'cmc-popLinkWitnessV2',
        u'id-cmc-popLinkWitnessV2',
        u'PopLinkWitnessV2',
        u'KeyDevAlgs',
        ]
    _type_ = [
        u'PKIData',
        u'BodyPartID',
        u'TaggedAttribute',
        u'OTHER-REQUEST',
        u'TaggedRequest',
        u'TaggedCertificationRequest',
        u'CertificationRequest',
        u'TaggedContentInfo',
        u'OTHER-MSG',
        u'OtherMsg',
        u'ResponseBody',
        u'PKIResponse',
        u'CMC-CONTROL',
        u'CMCStatusInfo',
        u'PendInfo',
        u'CMCStatus',
        u'CMCFailInfo',
        u'AddExtensions',
        u'EncryptedPOP',
        u'DecryptedPOP',
        u'LraPopWitness',
        u'GetCert',
        u'GetCRL',
        u'RevokeRequest',
        u'CMCCertId',
        u'ExtensionReq',
        u'NoSignatureValue',
        u'CMCUnsignedData',
        u'EXTENDED-FAILURE-INFO',
        u'CMCStatusInfoV2',
        u'BodyPartReference',
        u'BodyPartPath',
        u'PublishTrustAnchors',
        u'AuthPublish',
        u'BodyPartList',
        u'CMCPublicationInfo',
        u'ModCertTemplate',
        u'ControlsProcessed',
        u'IdentityProofV2',
        u'PopLinkWitnessV2',
        ]
    _set_ = [
        u'CMC-ContentTypes',
        u'SignatureAlgs',
        u'CMC-UnsignedAtts',
        u'Cmc-Control-Set',
        u'OtherRequests',
        u'AttributeList',
        u'OtherMsgSet',
        u'POPAlgs',
        u'WitnessAlgs',
        u'ExtendedFailures',
        u'HashAlgorithms',
        u'KeyDevAlgs',
        ]
    _val_ = [
        u'id-cmc',
        u'id-cct',
        u'ct-PKIData',
        u'id-cct-PKIData',
        u'ct-PKIResponse',
        u'id-cct-PKIResponse',
        u'cmc-identityProof',
        u'id-cmc-identityProof',
        u'cmc-dataReturn',
        u'id-cmc-dataReturn',
        u'cmc-regInfo',
        u'id-cmc-regInfo',
        u'cmc-responseInfo',
        u'id-cmc-responseInfo',
        u'cmc-queryPending',
        u'id-cmc-queryPending',
        u'cmc-popLinkRandom',
        u'id-cmc-popLinkRandom',
        u'cmc-popLinkWitness',
        u'id-cmc-popLinkWitness',
        u'cmc-identification',
        u'id-cmc-identification',
        u'cmc-transactionId',
        u'id-cmc-transactionId',
        u'cmc-senderNonce',
        u'id-cmc-senderNonce',
        u'cmc-recipientNonce',
        u'id-cmc-recipientNonce',
        u'cmc-statusInfo',
        u'id-cmc-statusInfo',
        u'cmc-addExtensions',
        u'id-cmc-addExtensions',
        u'cmc-encryptedPOP',
        u'cmc-decryptedPOP',
        u'id-cmc-encryptedPOP',
        u'id-cmc-decryptedPOP',
        u'cmc-lraPOPWitness',
        u'id-cmc-lraPOPWitness',
        u'cmc-getCert',
        u'id-cmc-getCert',
        u'cmc-getCRL',
        u'id-cmc-getCRL',
        u'cmc-revokeRequest',
        u'id-cmc-revokeRequest',
        u'cmc-confirmCertAcceptance',
        u'id-cmc-confirmCertAcceptance',
        u'at-extension-req',
        u'id-ExtensionReq',
        u'sa-noSignature',
        u'id-alg-noSignature',
        u'id-aa',
        u'aa-cmc-unsignedData',
        u'id-aa-cmc-unsignedData',
        u'cmc-statusInfoV2',
        u'id-cmc-statusInfoV2',
        u'cmc-trustedAnchors',
        u'id-cmc-trustedAnchors',
        u'cmc-authData',
        u'id-cmc-authData',
        u'cmc-batchRequests',
        u'id-cmc-batchRequests',
        u'cmc-batchResponses',
        u'id-cmc-batchResponses',
        u'cmc-publishCert',
        u'id-cmc-publishCert',
        u'cmc-modCertTemplate',
        u'id-cmc-modCertTemplate',
        u'cmc-controlProcessed',
        u'id-cmc-controlProcessed',
        u'cmc-identityProofV2',
        u'id-cmc-identityProofV2',
        u'cmc-popLinkWitnessV2',
        u'id-cmc-popLinkWitnessV2',
        ]
    _class_ = [
        u'CMC-ContentTypes',
        u'SignatureAlgs',
        u'CMC-UnsignedAtts',
        u'ct-PKIData',
        u'Cmc-Control-Set',
        u'OTHER-REQUEST',
        u'OtherRequests',
        u'AttributeList',
        u'OTHER-MSG',
        u'OtherMsgSet',
        u'ct-PKIResponse',
        u'CMC-CONTROL',
        u'cmc-identityProof',
        u'cmc-dataReturn',
        u'cmc-regInfo',
        u'cmc-responseInfo',
        u'cmc-queryPending',
        u'cmc-popLinkRandom',
        u'cmc-popLinkWitness',
        u'cmc-identification',
        u'cmc-transactionId',
        u'cmc-senderNonce',
        u'cmc-recipientNonce',
        u'cmc-statusInfo',
        u'cmc-addExtensions',
        u'cmc-encryptedPOP',
        u'cmc-decryptedPOP',
        u'POPAlgs',
        u'WitnessAlgs',
        u'cmc-lraPOPWitness',
        u'cmc-getCert',
        u'cmc-getCRL',
        u'cmc-revokeRequest',
        u'cmc-confirmCertAcceptance',
        u'at-extension-req',
        u'sa-noSignature',
        u'aa-cmc-unsignedData',
        u'cmc-statusInfoV2',
        u'EXTENDED-FAILURE-INFO',
        u'ExtendedFailures',
        u'cmc-trustedAnchors',
        u'HashAlgorithms',
        u'cmc-authData',
        u'cmc-batchRequests',
        u'cmc-batchResponses',
        u'cmc-publishCert',
        u'cmc-modCertTemplate',
        u'cmc-controlProcessed',
        u'cmc-identityProofV2',
        u'cmc-popLinkWitnessV2',
        u'KeyDevAlgs',
        ]
    _param_ = [
        ]
    
    #-----< CMC-ContentTypes >-----#
    CMC_ContentTypes = CLASS(name=u'CMC-ContentTypes', mode=MODE_SET, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _CMC_ContentTypes_val_Type_0 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PKIData')))
    _CMC_ContentTypes_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PKIResponse')))
    CMC_ContentTypes._val = ASN1Set(rv=[dict([('Type', _CMC_ContentTypes_val_Type_0), ('id', (1, 3, 6, 1, 5, 5, 7, 12, 2))]), dict([('Type', _CMC_ContentTypes_val_Type_1), ('id', (1, 3, 6, 1, 5, 5, 7, 12, 3))])], rr=[], ev=[], er=[])
    
    #-----< SignatureAlgs >-----#
    SignatureAlgs = CLASS(name=u'SignatureAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _SignatureAlgs_val_Value_0 = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'NoSignatureValue')))
    _SignatureAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    SignatureAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 7, 6, 2)), (u'Value', _SignatureAlgs_val_Value_0), (u'Params', _SignatureAlgs_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[]))])], rr=[], ev=None, er=[])
    
    #-----< CMC-UnsignedAtts >-----#
    CMC_UnsignedAtts = CLASS(name=u'CMC-UnsignedAtts', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _CMC_UnsignedAtts_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCUnsignedData')))
    CMC_UnsignedAtts._val = ASN1Set(rv=[dict([(u'Type', _CMC_UnsignedAtts_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 16, 2, 34))])], rr=[], ev=None, er=[])
    
    #-----< id-cmc >-----#
    id_cmc = OID(name=u'id-cmc', mode=MODE_VALUE)
    id_cmc._val = (1, 3, 6, 1, 5, 5, 7, 7)
    
    #-----< id-cct >-----#
    id_cct = OID(name=u'id-cct', mode=MODE_VALUE)
    id_cct._val = (1, 3, 6, 1, 5, 5, 7, 12)
    
    #-----< ct-PKIData >-----#
    ct_PKIData = CLASS(name=u'ct-PKIData', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_PKIData_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PKIData')))
    ct_PKIData._val = dict([('Type', _ct_PKIData_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 12, 2))])
    
    #-----< id-cct-PKIData >-----#
    id_cct_PKIData = OID(name=u'id-cct-PKIData', mode=MODE_VALUE)
    id_cct_PKIData._val = (1, 3, 6, 1, 5, 5, 7, 12, 2)
    
    #-----< PKIData >-----#
    PKIData = SEQ(name=u'PKIData', mode=MODE_TYPE)
    _PKIData_controlSequence = SEQ_OF(name=u'controlSequence', mode=MODE_TYPE)
    __PKIData_controlSequence__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'TaggedAttribute')))
    _PKIData_controlSequence._cont = __PKIData_controlSequence__item_
    _PKIData_controlSequence._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _PKIData_reqSequence = SEQ_OF(name=u'reqSequence', mode=MODE_TYPE)
    __PKIData_reqSequence__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'TaggedRequest')))
    _PKIData_reqSequence._cont = __PKIData_reqSequence__item_
    _PKIData_reqSequence._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _PKIData_cmsSequence = SEQ_OF(name=u'cmsSequence', mode=MODE_TYPE)
    __PKIData_cmsSequence__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'TaggedContentInfo')))
    _PKIData_cmsSequence._cont = __PKIData_cmsSequence__item_
    _PKIData_cmsSequence._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _PKIData_otherMsgSequence = SEQ_OF(name=u'otherMsgSequence', mode=MODE_TYPE)
    __PKIData_otherMsgSequence__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'OtherMsg')))
    _PKIData_otherMsgSequence._cont = __PKIData_otherMsgSequence__item_
    _PKIData_otherMsgSequence._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    PKIData._cont = ASN1Dict([
        (u'controlSequence', _PKIData_controlSequence),
        (u'reqSequence', _PKIData_reqSequence),
        (u'cmsSequence', _PKIData_cmsSequence),
        (u'otherMsgSequence', _PKIData_otherMsgSequence),
        ])
    PKIData._ext = None
    
    #-----< BodyPartID >-----#
    BodyPartID = INT(name=u'BodyPartID', mode=MODE_TYPE)
    BodyPartID._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    
    #-----< TaggedAttribute >-----#
    TaggedAttribute = SEQ(name=u'TaggedAttribute', mode=MODE_TYPE)
    _TaggedAttribute_bodyPartID = INT(name=u'bodyPartID', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _TaggedAttribute_attrType = OID(name=u'attrType', mode=MODE_TYPE, typeref=ASN1RefClassField(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL'), [u'id']))
    __TaggedAttribute_attrType_tab = CLASS(name='_tab_CMC-CONTROL', mode=MODE_SET, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    ___TaggedAttribute_attrType_tab_val_Type_0 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_1 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_2 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_3 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_4 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_5 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_6 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_7 = STR_UTF8(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_8 = INT(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_9 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_10 = OCT_STR(name='Type', mode=MODE_TYPE)
    ___TaggedAttribute_attrType_tab_val_Type_11 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCStatusInfo')))
    ___TaggedAttribute_attrType_tab_val_Type_12 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'AddExtensions')))
    ___TaggedAttribute_attrType_tab_val_Type_13 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'EncryptedPOP')))
    ___TaggedAttribute_attrType_tab_val_Type_14 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'DecryptedPOP')))
    ___TaggedAttribute_attrType_tab_val_Type_15 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'LraPopWitness')))
    ___TaggedAttribute_attrType_tab_val_Type_16 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'GetCert')))
    ___TaggedAttribute_attrType_tab_val_Type_17 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'GetCRL')))
    ___TaggedAttribute_attrType_tab_val_Type_18 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'RevokeRequest')))
    ___TaggedAttribute_attrType_tab_val_Type_19 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCCertId')))
    ___TaggedAttribute_attrType_tab_val_Type_20 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCStatusInfoV2')))
    ___TaggedAttribute_attrType_tab_val_Type_21 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PublishTrustAnchors')))
    ___TaggedAttribute_attrType_tab_val_Type_22 = INT(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'AuthPublish')))
    ___TaggedAttribute_attrType_tab_val_Type_23 = SEQ_OF(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartList')))
    ___TaggedAttribute_attrType_tab_val_Type_24 = SEQ_OF(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartList')))
    ___TaggedAttribute_attrType_tab_val_Type_25 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCPublicationInfo')))
    ___TaggedAttribute_attrType_tab_val_Type_26 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'ModCertTemplate')))
    ___TaggedAttribute_attrType_tab_val_Type_27 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'ControlsProcessed')))
    ___TaggedAttribute_attrType_tab_val_Type_28 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'IdentityProofV2')))
    ___TaggedAttribute_attrType_tab_val_Type_29 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PopLinkWitnessV2')))
    __TaggedAttribute_attrType_tab._val = ASN1Set(rv=[dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_0), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 3))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_1), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 4))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_2), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 18))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_3), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 19))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_4), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 21))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_5), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 22))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_6), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 23))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_7), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 2))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_8), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 5))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_9), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 6))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_10), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 7))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_11), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 1))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_12), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 8))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_13), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 9))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_14), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 10))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_15), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 11))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_16), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 15))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_17), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 16))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_18), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 17))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_19), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 24))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_20), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 25))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_21), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 26))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_22), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 27))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_23), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 28))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_24), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 29))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_25), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 30))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_26), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 31))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_27), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 32))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_28), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 33))]), dict([('Type', ___TaggedAttribute_attrType_tab_val_Type_29), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 34))])], rr=[], ev=None, er=[])
    _TaggedAttribute_attrType._const_tab = __TaggedAttribute_attrType_tab
    _TaggedAttribute_attrType._const_tab_at = None
    _TaggedAttribute_attrType._const_tab_id = u'id'
    _TaggedAttribute_attrValues = SET_OF(name=u'attrValues', mode=MODE_TYPE)
    __TaggedAttribute_attrValues__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL'), [u'Type']))
    __TaggedAttribute_attrValues__item_._const_tab = __TaggedAttribute_attrType_tab
    __TaggedAttribute_attrValues__item_._const_tab_at = ('..', '..', u'attrType')
    __TaggedAttribute_attrValues__item_._const_tab_id = u'Type'
    _TaggedAttribute_attrValues._cont = __TaggedAttribute_attrValues__item_
    TaggedAttribute._cont = ASN1Dict([
        (u'bodyPartID', _TaggedAttribute_bodyPartID),
        (u'attrType', _TaggedAttribute_attrType),
        (u'attrValues', _TaggedAttribute_attrValues),
        ])
    TaggedAttribute._ext = None
    
    #-----< Cmc-Control-Set >-----#
    Cmc_Control_Set = CLASS(name=u'Cmc-Control-Set', mode=MODE_SET, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _Cmc_Control_Set_val_Type_0 = OCT_STR(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_1 = OCT_STR(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_2 = OCT_STR(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_3 = OCT_STR(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_4 = OCT_STR(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_5 = OCT_STR(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_6 = OCT_STR(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_7 = STR_UTF8(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_8 = INT(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_9 = OCT_STR(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_10 = OCT_STR(name='Type', mode=MODE_TYPE)
    _Cmc_Control_Set_val_Type_11 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCStatusInfo')))
    _Cmc_Control_Set_val_Type_12 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'AddExtensions')))
    _Cmc_Control_Set_val_Type_13 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'EncryptedPOP')))
    _Cmc_Control_Set_val_Type_14 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'DecryptedPOP')))
    _Cmc_Control_Set_val_Type_15 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'LraPopWitness')))
    _Cmc_Control_Set_val_Type_16 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'GetCert')))
    _Cmc_Control_Set_val_Type_17 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'GetCRL')))
    _Cmc_Control_Set_val_Type_18 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'RevokeRequest')))
    _Cmc_Control_Set_val_Type_19 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCCertId')))
    _Cmc_Control_Set_val_Type_20 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCStatusInfoV2')))
    _Cmc_Control_Set_val_Type_21 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PublishTrustAnchors')))
    _Cmc_Control_Set_val_Type_22 = INT(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'AuthPublish')))
    _Cmc_Control_Set_val_Type_23 = SEQ_OF(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartList')))
    _Cmc_Control_Set_val_Type_24 = SEQ_OF(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartList')))
    _Cmc_Control_Set_val_Type_25 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCPublicationInfo')))
    _Cmc_Control_Set_val_Type_26 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'ModCertTemplate')))
    _Cmc_Control_Set_val_Type_27 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'ControlsProcessed')))
    _Cmc_Control_Set_val_Type_28 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'IdentityProofV2')))
    _Cmc_Control_Set_val_Type_29 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PopLinkWitnessV2')))
    Cmc_Control_Set._val = ASN1Set(rv=[dict([('Type', _Cmc_Control_Set_val_Type_0), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 3))]), dict([('Type', _Cmc_Control_Set_val_Type_1), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 4))]), dict([('Type', _Cmc_Control_Set_val_Type_2), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 18))]), dict([('Type', _Cmc_Control_Set_val_Type_3), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 19))]), dict([('Type', _Cmc_Control_Set_val_Type_4), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 21))]), dict([('Type', _Cmc_Control_Set_val_Type_5), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 22))]), dict([('Type', _Cmc_Control_Set_val_Type_6), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 23))]), dict([('Type', _Cmc_Control_Set_val_Type_7), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 2))]), dict([('Type', _Cmc_Control_Set_val_Type_8), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 5))]), dict([('Type', _Cmc_Control_Set_val_Type_9), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 6))]), dict([('Type', _Cmc_Control_Set_val_Type_10), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 7))]), dict([('Type', _Cmc_Control_Set_val_Type_11), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 1))]), dict([('Type', _Cmc_Control_Set_val_Type_12), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 8))]), dict([('Type', _Cmc_Control_Set_val_Type_13), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 9))]), dict([('Type', _Cmc_Control_Set_val_Type_14), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 10))]), dict([('Type', _Cmc_Control_Set_val_Type_15), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 11))]), dict([('Type', _Cmc_Control_Set_val_Type_16), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 15))]), dict([('Type', _Cmc_Control_Set_val_Type_17), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 16))]), dict([('Type', _Cmc_Control_Set_val_Type_18), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 17))]), dict([('Type', _Cmc_Control_Set_val_Type_19), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 24))]), dict([('Type', _Cmc_Control_Set_val_Type_20), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 25))]), dict([('Type', _Cmc_Control_Set_val_Type_21), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 26))]), dict([('Type', _Cmc_Control_Set_val_Type_22), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 27))]), dict([('Type', _Cmc_Control_Set_val_Type_23), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 28))]), dict([('Type', _Cmc_Control_Set_val_Type_24), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 29))]), dict([('Type', _Cmc_Control_Set_val_Type_25), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 30))]), dict([('Type', _Cmc_Control_Set_val_Type_26), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 31))]), dict([('Type', _Cmc_Control_Set_val_Type_27), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 32))]), dict([('Type', _Cmc_Control_Set_val_Type_28), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 33))]), dict([('Type', _Cmc_Control_Set_val_Type_29), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 34))])], rr=[], ev=[], er=[])
    
    #-----< OTHER-REQUEST >-----#
    OTHER_REQUEST = CLASS(name=u'OTHER-REQUEST', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< OtherRequests >-----#
    OtherRequests = CLASS(name=u'OtherRequests', mode=MODE_SET, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'OTHER-REQUEST')))
    OtherRequests._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< TaggedRequest >-----#
    TaggedRequest = CHOICE(name=u'TaggedRequest', mode=MODE_TYPE)
    _TaggedRequest_tcr = SEQ(name=u'tcr', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'TaggedCertificationRequest')))
    _TaggedRequest_crm = SEQ(name=u'crm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXCRMF-2009', 'CertReqMsg')))
    _TaggedRequest_orm = SEQ(name=u'orm', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    __TaggedRequest_orm_bodyPartID = INT(name=u'bodyPartID', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    __TaggedRequest_orm_requestMessageType = OID(name=u'requestMessageType', mode=MODE_TYPE, typeref=ASN1RefClassField(('EnrollmentMessageSyntax-2009', 'OTHER-REQUEST'), [u'id']))
    ___TaggedRequest_orm_requestMessageType_tab = CLASS(name='_tab_OTHER-REQUEST', mode=MODE_SET, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'OTHER-REQUEST')))
    ___TaggedRequest_orm_requestMessageType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __TaggedRequest_orm_requestMessageType._const_tab = ___TaggedRequest_orm_requestMessageType_tab
    __TaggedRequest_orm_requestMessageType._const_tab_at = None
    __TaggedRequest_orm_requestMessageType._const_tab_id = u'id'
    __TaggedRequest_orm_requestMessageValue = OPEN(name=u'requestMessageValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('EnrollmentMessageSyntax-2009', 'OTHER-REQUEST'), [u'Type']))
    ___TaggedRequest_orm_requestMessageValue_tab = CLASS(name='_tab_OTHER-REQUEST', mode=MODE_SET, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'OTHER-REQUEST')))
    ___TaggedRequest_orm_requestMessageValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __TaggedRequest_orm_requestMessageValue._const_tab = ___TaggedRequest_orm_requestMessageValue_tab
    __TaggedRequest_orm_requestMessageValue._const_tab_at = ('..', u'requestMessageType')
    __TaggedRequest_orm_requestMessageValue._const_tab_id = u'Type'
    _TaggedRequest_orm._cont = ASN1Dict([
        (u'bodyPartID', __TaggedRequest_orm_bodyPartID),
        (u'requestMessageType', __TaggedRequest_orm_requestMessageType),
        (u'requestMessageValue', __TaggedRequest_orm_requestMessageValue),
        ])
    _TaggedRequest_orm._ext = None
    TaggedRequest._cont = ASN1Dict([
        (u'tcr', _TaggedRequest_tcr),
        (u'crm', _TaggedRequest_crm),
        (u'orm', _TaggedRequest_orm),
        ])
    TaggedRequest._ext = None
    
    #-----< TaggedCertificationRequest >-----#
    TaggedCertificationRequest = SEQ(name=u'TaggedCertificationRequest', mode=MODE_TYPE)
    _TaggedCertificationRequest_bodyPartID = INT(name=u'bodyPartID', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _TaggedCertificationRequest_certificationRequest = SEQ(name=u'certificationRequest', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CertificationRequest')))
    TaggedCertificationRequest._cont = ASN1Dict([
        (u'bodyPartID', _TaggedCertificationRequest_bodyPartID),
        (u'certificationRequest', _TaggedCertificationRequest_certificationRequest),
        ])
    TaggedCertificationRequest._ext = None
    
    #-----< AttributeList >-----#
    AttributeList = CLASS(name=u'AttributeList', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _AttributeList_val_Type_0 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'ExtensionReq')))
    AttributeList._val = ASN1Set(rv=[dict([(u'Type', _AttributeList_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 14))])], rr=[], ev=[], er=[])
    
    #-----< CertificationRequest >-----#
    CertificationRequest = SEQ(name=u'CertificationRequest', mode=MODE_TYPE)
    _CertificationRequest_certificationRequestInfo = SEQ(name=u'certificationRequestInfo', mode=MODE_TYPE)
    __CertificationRequest_certificationRequestInfo_version = INT(name=u'version', mode=MODE_TYPE)
    __CertificationRequest_certificationRequestInfo_subject = CHOICE(name=u'subject', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    __CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo = SEQ(name=u'subjectPublicKeyInfo', mode=MODE_TYPE)
    ___CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'id']))
    _____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab = CLASS(name='_tab_PUBLIC-KEY', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_1 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_2 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_2 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_3 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'KEA-Params-Id')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_4 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_4 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_5 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_5 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_6 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_6 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_7 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_7 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_8 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_8 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    _____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_0), (u'Params', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_1), (u'Params', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_2), (u'Params', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_2), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))]), dict([(u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22)), (u'Params', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_3), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])], rr=[], ev=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_4), (u'Params', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_4), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))]), dict([(u'id', (1, 3, 132, 1, 12)), (u'KeyValue', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_5), (u'Params', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_5), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 3, 132, 1, 13)), (u'KeyValue', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_6), (u'Params', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_6), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_7), (u'Params', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_7), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_8), (u'Params', ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_8), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], er=[])
    ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm._const_tab = _____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab
    ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm._const_tab_at = None
    ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm._const_tab_id = u'id'
    ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'Params']), opt=True)
    ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_parameters._const_tab = _____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab
    ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_parameters._const_tab_at = ('..', u'algorithm')
    ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_parameters._const_tab_id = u'Params'
    ___CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm._cont = ASN1Dict([
        (u'algorithm', ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm),
        (u'parameters', ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_parameters),
        ])
    ___CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm._ext = None
    ___CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_subjectPublicKey = BIT_STR(name=u'subjectPublicKey', mode=MODE_TYPE)
    __CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo._cont = ASN1Dict([
        (u'algorithm', ___CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm),
        (u'subjectPublicKey', ___CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_subjectPublicKey),
        ])
    __CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo._ext = None
    __CertificationRequest_certificationRequestInfo_attributes = SET_OF(name=u'attributes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___CertificationRequest_certificationRequestInfo_attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'AttributeSet')))
    ____CertificationRequest_certificationRequestInfo_attributes__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    _____CertificationRequest_certificationRequestInfo_attributes__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ______CertificationRequest_certificationRequestInfo_attributes__item__type_tab_val_Type_0 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'ExtensionReq')))
    _____CertificationRequest_certificationRequestInfo_attributes__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', ______CertificationRequest_certificationRequestInfo_attributes__item__type_tab_val_Type_0), (u'id', (1, 2, 840, 113549, 1, 9, 14))])], rr=[], ev=None, er=[])
    ____CertificationRequest_certificationRequestInfo_attributes__item__type._const_tab = _____CertificationRequest_certificationRequestInfo_attributes__item__type_tab
    ____CertificationRequest_certificationRequestInfo_attributes__item__type._const_tab_at = None
    ____CertificationRequest_certificationRequestInfo_attributes__item__type._const_tab_id = u'id'
    ____CertificationRequest_certificationRequestInfo_attributes__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    _____CertificationRequest_certificationRequestInfo_attributes__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    _____CertificationRequest_certificationRequestInfo_attributes__item__values__item_._const_tab = _____CertificationRequest_certificationRequestInfo_attributes__item__type_tab
    _____CertificationRequest_certificationRequestInfo_attributes__item__values__item_._const_tab_at = ('..', '..', u'type')
    _____CertificationRequest_certificationRequestInfo_attributes__item__values__item_._const_tab_id = u'Type'
    ____CertificationRequest_certificationRequestInfo_attributes__item__values._cont = _____CertificationRequest_certificationRequestInfo_attributes__item__values__item_
    ____CertificationRequest_certificationRequestInfo_attributes__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___CertificationRequest_certificationRequestInfo_attributes__item_._cont = ASN1Dict([
        (u'type', ____CertificationRequest_certificationRequestInfo_attributes__item__type),
        (u'values', ____CertificationRequest_certificationRequestInfo_attributes__item__values),
        ])
    ___CertificationRequest_certificationRequestInfo_attributes__item_._ext = None
    __CertificationRequest_certificationRequestInfo_attributes._cont = ___CertificationRequest_certificationRequestInfo_attributes__item_
    _CertificationRequest_certificationRequestInfo._cont = ASN1Dict([
        (u'version', __CertificationRequest_certificationRequestInfo_version),
        (u'subject', __CertificationRequest_certificationRequestInfo_subject),
        (u'subjectPublicKeyInfo', __CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo),
        (u'attributes', __CertificationRequest_certificationRequestInfo_attributes),
        ])
    _CertificationRequest_certificationRequestInfo._ext = None
    _CertificationRequest_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __CertificationRequest_signatureAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___CertificationRequest_signatureAlgorithm_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    __SIGNATURE_ALGORITHM_HashSet_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___CertificationRequest_signatureAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_3), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_4), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_5), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_6), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_7), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_8), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_9), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_10), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __CertificationRequest_signatureAlgorithm_algorithm._const_tab = ___CertificationRequest_signatureAlgorithm_algorithm_tab
    __CertificationRequest_signatureAlgorithm_algorithm._const_tab_at = None
    __CertificationRequest_signatureAlgorithm_algorithm._const_tab_id = u'id'
    __CertificationRequest_signatureAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __CertificationRequest_signatureAlgorithm_parameters._const_tab = ___CertificationRequest_signatureAlgorithm_algorithm_tab
    __CertificationRequest_signatureAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __CertificationRequest_signatureAlgorithm_parameters._const_tab_id = u'Params'
    _CertificationRequest_signatureAlgorithm._cont = ASN1Dict([
        (u'algorithm', __CertificationRequest_signatureAlgorithm_algorithm),
        (u'parameters', __CertificationRequest_signatureAlgorithm_parameters),
        ])
    _CertificationRequest_signatureAlgorithm._ext = None
    _CertificationRequest_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    CertificationRequest._cont = ASN1Dict([
        (u'certificationRequestInfo', _CertificationRequest_certificationRequestInfo),
        (u'signatureAlgorithm', _CertificationRequest_signatureAlgorithm),
        (u'signature', _CertificationRequest_signature),
        ])
    CertificationRequest._ext = None
    
    #-----< TaggedContentInfo >-----#
    TaggedContentInfo = SEQ(name=u'TaggedContentInfo', mode=MODE_TYPE)
    _TaggedContentInfo_bodyPartID = INT(name=u'bodyPartID', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _TaggedContentInfo_contentInfo = SEQ(name=u'contentInfo', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentInfo')))
    TaggedContentInfo._cont = ASN1Dict([
        (u'bodyPartID', _TaggedContentInfo_bodyPartID),
        (u'contentInfo', _TaggedContentInfo_contentInfo),
        ])
    TaggedContentInfo._ext = None
    
    #-----< OTHER-MSG >-----#
    OTHER_MSG = CLASS(name=u'OTHER-MSG', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< OtherMsgSet >-----#
    OtherMsgSet = CLASS(name=u'OtherMsgSet', mode=MODE_SET, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'OTHER-MSG')))
    OtherMsgSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< OtherMsg >-----#
    OtherMsg = SEQ(name=u'OtherMsg', mode=MODE_TYPE)
    _OtherMsg_bodyPartID = INT(name=u'bodyPartID', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _OtherMsg_otherMsgType = OID(name=u'otherMsgType', mode=MODE_TYPE, typeref=ASN1RefClassField(('EnrollmentMessageSyntax-2009', 'OTHER-MSG'), [u'id']))
    __OtherMsg_otherMsgType_tab = CLASS(name='_tab_OTHER-MSG', mode=MODE_SET, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'OTHER-MSG')))
    __OtherMsg_otherMsgType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherMsg_otherMsgType._const_tab = __OtherMsg_otherMsgType_tab
    _OtherMsg_otherMsgType._const_tab_at = None
    _OtherMsg_otherMsgType._const_tab_id = u'id'
    _OtherMsg_otherMsgValue = OPEN(name=u'otherMsgValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('EnrollmentMessageSyntax-2009', 'OTHER-MSG'), [u'Type']))
    __OtherMsg_otherMsgValue_tab = CLASS(name='_tab_OTHER-MSG', mode=MODE_SET, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'OTHER-MSG')))
    __OtherMsg_otherMsgValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _OtherMsg_otherMsgValue._const_tab = __OtherMsg_otherMsgValue_tab
    _OtherMsg_otherMsgValue._const_tab_at = ('..', u'otherMsgType')
    _OtherMsg_otherMsgValue._const_tab_id = u'Type'
    OtherMsg._cont = ASN1Dict([
        (u'bodyPartID', _OtherMsg_bodyPartID),
        (u'otherMsgType', _OtherMsg_otherMsgType),
        (u'otherMsgValue', _OtherMsg_otherMsgValue),
        ])
    OtherMsg._ext = None
    
    #-----< ct-PKIResponse >-----#
    ct_PKIResponse = CLASS(name=u'ct-PKIResponse', mode=MODE_VALUE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'CONTENT-TYPE')))
    _ct_PKIResponse_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PKIResponse')))
    ct_PKIResponse._val = dict([('Type', _ct_PKIResponse_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 12, 3))])
    
    #-----< id-cct-PKIResponse >-----#
    id_cct_PKIResponse = OID(name=u'id-cct-PKIResponse', mode=MODE_VALUE)
    id_cct_PKIResponse._val = (1, 3, 6, 1, 5, 5, 7, 12, 3)
    
    #-----< ResponseBody >-----#
    ResponseBody = SEQ(name=u'ResponseBody', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PKIResponse')))
    
    #-----< PKIResponse >-----#
    PKIResponse = SEQ(name=u'PKIResponse', mode=MODE_TYPE)
    _PKIResponse_controlSequence = SEQ_OF(name=u'controlSequence', mode=MODE_TYPE)
    __PKIResponse_controlSequence__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'TaggedAttribute')))
    _PKIResponse_controlSequence._cont = __PKIResponse_controlSequence__item_
    _PKIResponse_controlSequence._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _PKIResponse_cmsSequence = SEQ_OF(name=u'cmsSequence', mode=MODE_TYPE)
    __PKIResponse_cmsSequence__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'TaggedContentInfo')))
    _PKIResponse_cmsSequence._cont = __PKIResponse_cmsSequence__item_
    _PKIResponse_cmsSequence._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _PKIResponse_otherMsgSequence = SEQ_OF(name=u'otherMsgSequence', mode=MODE_TYPE)
    __PKIResponse_otherMsgSequence__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'OtherMsg')))
    _PKIResponse_otherMsgSequence._cont = __PKIResponse_otherMsgSequence__item_
    _PKIResponse_otherMsgSequence._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    PKIResponse._cont = ASN1Dict([
        (u'controlSequence', _PKIResponse_controlSequence),
        (u'cmsSequence', _PKIResponse_cmsSequence),
        (u'otherMsgSequence', _PKIResponse_otherMsgSequence),
        ])
    PKIResponse._ext = None
    
    #-----< CMC-CONTROL >-----#
    CMC_CONTROL = CLASS(name=u'CMC-CONTROL', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< cmc-identityProof >-----#
    cmc_identityProof = CLASS(name=u'cmc-identityProof', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_identityProof_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    cmc_identityProof._val = dict([('Type', _cmc_identityProof_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 3))])
    
    #-----< id-cmc-identityProof >-----#
    id_cmc_identityProof = OID(name=u'id-cmc-identityProof', mode=MODE_VALUE)
    id_cmc_identityProof._val = (1, 3, 6, 1, 5, 5, 7, 7, 3)
    
    #-----< cmc-dataReturn >-----#
    cmc_dataReturn = CLASS(name=u'cmc-dataReturn', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_dataReturn_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    cmc_dataReturn._val = dict([('Type', _cmc_dataReturn_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 4))])
    
    #-----< id-cmc-dataReturn >-----#
    id_cmc_dataReturn = OID(name=u'id-cmc-dataReturn', mode=MODE_VALUE)
    id_cmc_dataReturn._val = (1, 3, 6, 1, 5, 5, 7, 7, 4)
    
    #-----< cmc-regInfo >-----#
    cmc_regInfo = CLASS(name=u'cmc-regInfo', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_regInfo_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    cmc_regInfo._val = dict([('Type', _cmc_regInfo_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 18))])
    
    #-----< id-cmc-regInfo >-----#
    id_cmc_regInfo = OID(name=u'id-cmc-regInfo', mode=MODE_VALUE)
    id_cmc_regInfo._val = (1, 3, 6, 1, 5, 5, 7, 7, 18)
    
    #-----< cmc-responseInfo >-----#
    cmc_responseInfo = CLASS(name=u'cmc-responseInfo', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_responseInfo_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    cmc_responseInfo._val = dict([('Type', _cmc_responseInfo_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 19))])
    
    #-----< id-cmc-responseInfo >-----#
    id_cmc_responseInfo = OID(name=u'id-cmc-responseInfo', mode=MODE_VALUE)
    id_cmc_responseInfo._val = (1, 3, 6, 1, 5, 5, 7, 7, 19)
    
    #-----< cmc-queryPending >-----#
    cmc_queryPending = CLASS(name=u'cmc-queryPending', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_queryPending_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    cmc_queryPending._val = dict([('Type', _cmc_queryPending_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 21))])
    
    #-----< id-cmc-queryPending >-----#
    id_cmc_queryPending = OID(name=u'id-cmc-queryPending', mode=MODE_VALUE)
    id_cmc_queryPending._val = (1, 3, 6, 1, 5, 5, 7, 7, 21)
    
    #-----< cmc-popLinkRandom >-----#
    cmc_popLinkRandom = CLASS(name=u'cmc-popLinkRandom', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_popLinkRandom_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    cmc_popLinkRandom._val = dict([('Type', _cmc_popLinkRandom_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 22))])
    
    #-----< id-cmc-popLinkRandom >-----#
    id_cmc_popLinkRandom = OID(name=u'id-cmc-popLinkRandom', mode=MODE_VALUE)
    id_cmc_popLinkRandom._val = (1, 3, 6, 1, 5, 5, 7, 7, 22)
    
    #-----< cmc-popLinkWitness >-----#
    cmc_popLinkWitness = CLASS(name=u'cmc-popLinkWitness', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_popLinkWitness_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    cmc_popLinkWitness._val = dict([('Type', _cmc_popLinkWitness_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 23))])
    
    #-----< id-cmc-popLinkWitness >-----#
    id_cmc_popLinkWitness = OID(name=u'id-cmc-popLinkWitness', mode=MODE_VALUE)
    id_cmc_popLinkWitness._val = (1, 3, 6, 1, 5, 5, 7, 7, 23)
    
    #-----< cmc-identification >-----#
    cmc_identification = CLASS(name=u'cmc-identification', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_identification_val_Type = STR_UTF8(name='Type', mode=MODE_TYPE)
    cmc_identification._val = dict([('Type', _cmc_identification_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 2))])
    
    #-----< id-cmc-identification >-----#
    id_cmc_identification = OID(name=u'id-cmc-identification', mode=MODE_VALUE)
    id_cmc_identification._val = (1, 3, 6, 1, 5, 5, 7, 7, 2)
    
    #-----< cmc-transactionId >-----#
    cmc_transactionId = CLASS(name=u'cmc-transactionId', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_transactionId_val_Type = INT(name='Type', mode=MODE_TYPE)
    cmc_transactionId._val = dict([('Type', _cmc_transactionId_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 5))])
    
    #-----< id-cmc-transactionId >-----#
    id_cmc_transactionId = OID(name=u'id-cmc-transactionId', mode=MODE_VALUE)
    id_cmc_transactionId._val = (1, 3, 6, 1, 5, 5, 7, 7, 5)
    
    #-----< cmc-senderNonce >-----#
    cmc_senderNonce = CLASS(name=u'cmc-senderNonce', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_senderNonce_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    cmc_senderNonce._val = dict([('Type', _cmc_senderNonce_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 6))])
    
    #-----< id-cmc-senderNonce >-----#
    id_cmc_senderNonce = OID(name=u'id-cmc-senderNonce', mode=MODE_VALUE)
    id_cmc_senderNonce._val = (1, 3, 6, 1, 5, 5, 7, 7, 6)
    
    #-----< cmc-recipientNonce >-----#
    cmc_recipientNonce = CLASS(name=u'cmc-recipientNonce', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_recipientNonce_val_Type = OCT_STR(name='Type', mode=MODE_TYPE)
    cmc_recipientNonce._val = dict([('Type', _cmc_recipientNonce_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 7))])
    
    #-----< id-cmc-recipientNonce >-----#
    id_cmc_recipientNonce = OID(name=u'id-cmc-recipientNonce', mode=MODE_VALUE)
    id_cmc_recipientNonce._val = (1, 3, 6, 1, 5, 5, 7, 7, 7)
    
    #-----< cmc-statusInfo >-----#
    cmc_statusInfo = CLASS(name=u'cmc-statusInfo', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_statusInfo_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCStatusInfo')))
    cmc_statusInfo._val = dict([('Type', _cmc_statusInfo_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 1))])
    
    #-----< id-cmc-statusInfo >-----#
    id_cmc_statusInfo = OID(name=u'id-cmc-statusInfo', mode=MODE_VALUE)
    id_cmc_statusInfo._val = (1, 3, 6, 1, 5, 5, 7, 7, 1)
    
    #-----< CMCStatusInfo >-----#
    CMCStatusInfo = SEQ(name=u'CMCStatusInfo', mode=MODE_TYPE)
    _CMCStatusInfo_cMCStatus = INT(name=u'cMCStatus', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCStatus')))
    _CMCStatusInfo_bodyList = SEQ_OF(name=u'bodyList', mode=MODE_TYPE)
    __CMCStatusInfo_bodyList__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _CMCStatusInfo_bodyList._cont = __CMCStatusInfo_bodyList__item_
    _CMCStatusInfo_bodyList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _CMCStatusInfo_statusString = STR_UTF8(name=u'statusString', mode=MODE_TYPE, opt=True)
    _CMCStatusInfo_otherInfo = CHOICE(name=u'otherInfo', mode=MODE_TYPE, opt=True)
    __CMCStatusInfo_otherInfo_failInfo = INT(name=u'failInfo', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCFailInfo')))
    __CMCStatusInfo_otherInfo_pendInfo = SEQ(name=u'pendInfo', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PendInfo')))
    _CMCStatusInfo_otherInfo._cont = ASN1Dict([
        (u'failInfo', __CMCStatusInfo_otherInfo_failInfo),
        (u'pendInfo', __CMCStatusInfo_otherInfo_pendInfo),
        ])
    _CMCStatusInfo_otherInfo._ext = None
    CMCStatusInfo._cont = ASN1Dict([
        (u'cMCStatus', _CMCStatusInfo_cMCStatus),
        (u'bodyList', _CMCStatusInfo_bodyList),
        (u'statusString', _CMCStatusInfo_statusString),
        (u'otherInfo', _CMCStatusInfo_otherInfo),
        ])
    CMCStatusInfo._ext = None
    
    #-----< PendInfo >-----#
    PendInfo = SEQ(name=u'PendInfo', mode=MODE_TYPE)
    _PendInfo_pendToken = OCT_STR(name=u'pendToken', mode=MODE_TYPE)
    _PendInfo_pendTime = TIME_GEN(name=u'pendTime', mode=MODE_TYPE)
    PendInfo._cont = ASN1Dict([
        (u'pendToken', _PendInfo_pendToken),
        (u'pendTime', _PendInfo_pendTime),
        ])
    PendInfo._ext = None
    
    #-----< CMCStatus >-----#
    CMCStatus = INT(name=u'CMCStatus', mode=MODE_TYPE)
    CMCStatus._cont = ASN1Dict([(u'success', 0), (u'failed', 2), (u'pending', 3), (u'noSupport', 4), (u'confirmRequired', 5), (u'popRequired', 6), (u'partial', 7)])
    
    #-----< CMCFailInfo >-----#
    CMCFailInfo = INT(name=u'CMCFailInfo', mode=MODE_TYPE)
    CMCFailInfo._cont = ASN1Dict([(u'badAlg', 0), (u'badMessageCheck', 1), (u'badRequest', 2), (u'badTime', 3), (u'badCertId', 4), (u'unsuportedExt', 5), (u'mustArchiveKeys', 6), (u'badIdentity', 7), (u'popRequired', 8), (u'popFailed', 9), (u'noKeyReuse', 10), (u'internalCAError', 11), (u'tryLater', 12), (u'authDataFail', 13)])
    
    #-----< cmc-addExtensions >-----#
    cmc_addExtensions = CLASS(name=u'cmc-addExtensions', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_addExtensions_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'AddExtensions')))
    cmc_addExtensions._val = dict([('Type', _cmc_addExtensions_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 8))])
    
    #-----< id-cmc-addExtensions >-----#
    id_cmc_addExtensions = OID(name=u'id-cmc-addExtensions', mode=MODE_VALUE)
    id_cmc_addExtensions._val = (1, 3, 6, 1, 5, 5, 7, 7, 8)
    
    #-----< AddExtensions >-----#
    AddExtensions = SEQ(name=u'AddExtensions', mode=MODE_TYPE)
    _AddExtensions_pkiDataReference = INT(name=u'pkiDataReference', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _AddExtensions_certReferences = SEQ_OF(name=u'certReferences', mode=MODE_TYPE)
    __AddExtensions_certReferences__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _AddExtensions_certReferences._cont = __AddExtensions_certReferences__item_
    _AddExtensions_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE)
    __AddExtensions_extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___AddExtensions_extensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____AddExtensions_extensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_1 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_2 = BIT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyUsage')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_3 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PrivateKeyUsagePeriod')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_4 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertificatePolicies')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_5 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyMappings')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_6 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_7 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_8 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectDirectoryAttributes')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_9 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'BasicConstraints')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_10 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'NameConstraints')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_11 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyConstraints')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_12 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'ExtKeyUsageSyntax')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_13 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_14 = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_15 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_16 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_17 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectInfoAccessSyntax')))
    ____AddExtensions_extensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_0), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_1), (u'id', (2, 5, 29, 14))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 15))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_3), (u'id', (2, 5, 29, 16))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_4), (u'id', (2, 5, 29, 32))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_5), (u'id', (2, 5, 29, 33))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_6), (u'id', (2, 5, 29, 17))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_7), (u'id', (2, 5, 29, 18))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_8), (u'id', (2, 5, 29, 9))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_9), (u'id', (2, 5, 29, 19))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_10), (u'id', (2, 5, 29, 30))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_11), (u'id', (2, 5, 29, 36))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_12), (u'id', (2, 5, 29, 37))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_13), (u'id', (2, 5, 29, 31))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_14), (u'id', (2, 5, 29, 54))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_15), (u'id', (2, 5, 29, 46))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_16), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))]), dict([(u'ExtnType', _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_17), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 11))])], rr=[], ev=None, er=[])
    ___AddExtensions_extensions__item__extnID._const_tab = ____AddExtensions_extensions__item__extnID_tab
    ___AddExtensions_extensions__item__extnID._const_tab_at = None
    ___AddExtensions_extensions__item__extnID._const_tab_id = u'id'
    ___AddExtensions_extensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___AddExtensions_extensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____AddExtensions_extensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____AddExtensions_extensions__item__extnValue_contain._const_tab = ____AddExtensions_extensions__item__extnID_tab
    ____AddExtensions_extensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____AddExtensions_extensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___AddExtensions_extensions__item__extnValue._const_cont = ____AddExtensions_extensions__item__extnValue_contain
    __AddExtensions_extensions__item_._cont = ASN1Dict([
        (u'extnID', ___AddExtensions_extensions__item__extnID),
        (u'critical', ___AddExtensions_extensions__item__critical),
        (u'extnValue', ___AddExtensions_extensions__item__extnValue),
        ])
    __AddExtensions_extensions__item_._ext = None
    _AddExtensions_extensions._cont = __AddExtensions_extensions__item_
    AddExtensions._cont = ASN1Dict([
        (u'pkiDataReference', _AddExtensions_pkiDataReference),
        (u'certReferences', _AddExtensions_certReferences),
        (u'extensions', _AddExtensions_extensions),
        ])
    AddExtensions._ext = None
    
    #-----< cmc-encryptedPOP >-----#
    cmc_encryptedPOP = CLASS(name=u'cmc-encryptedPOP', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_encryptedPOP_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'EncryptedPOP')))
    cmc_encryptedPOP._val = dict([('Type', _cmc_encryptedPOP_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 9))])
    
    #-----< cmc-decryptedPOP >-----#
    cmc_decryptedPOP = CLASS(name=u'cmc-decryptedPOP', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_decryptedPOP_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'DecryptedPOP')))
    cmc_decryptedPOP._val = dict([('Type', _cmc_decryptedPOP_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 10))])
    
    #-----< id-cmc-encryptedPOP >-----#
    id_cmc_encryptedPOP = OID(name=u'id-cmc-encryptedPOP', mode=MODE_VALUE)
    id_cmc_encryptedPOP._val = (1, 3, 6, 1, 5, 5, 7, 7, 9)
    
    #-----< id-cmc-decryptedPOP >-----#
    id_cmc_decryptedPOP = OID(name=u'id-cmc-decryptedPOP', mode=MODE_VALUE)
    id_cmc_decryptedPOP._val = (1, 3, 6, 1, 5, 5, 7, 7, 10)
    
    #-----< EncryptedPOP >-----#
    EncryptedPOP = SEQ(name=u'EncryptedPOP', mode=MODE_TYPE)
    _EncryptedPOP_request = CHOICE(name=u'request', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'TaggedRequest')))
    _EncryptedPOP_cms = SEQ(name=u'cms', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentInfo')))
    _EncryptedPOP_thePOPAlgID = SEQ(name=u'thePOPAlgID', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __EncryptedPOP_thePOPAlgID_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'id']))
    ___EncryptedPOP_thePOPAlgID_algorithm_tab = CLASS(name='_tab_MAC-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    ____EncryptedPOP_thePOPAlgID_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___EncryptedPOP_thePOPAlgID_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', ____EncryptedPOP_thePOPAlgID_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=None, er=[])
    __EncryptedPOP_thePOPAlgID_algorithm._const_tab = ___EncryptedPOP_thePOPAlgID_algorithm_tab
    __EncryptedPOP_thePOPAlgID_algorithm._const_tab_at = None
    __EncryptedPOP_thePOPAlgID_algorithm._const_tab_id = u'id'
    __EncryptedPOP_thePOPAlgID_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'Params']), opt=True)
    __EncryptedPOP_thePOPAlgID_parameters._const_tab = ___EncryptedPOP_thePOPAlgID_algorithm_tab
    __EncryptedPOP_thePOPAlgID_parameters._const_tab_at = ('..', u'algorithm')
    __EncryptedPOP_thePOPAlgID_parameters._const_tab_id = u'Params'
    _EncryptedPOP_thePOPAlgID._cont = ASN1Dict([
        (u'algorithm', __EncryptedPOP_thePOPAlgID_algorithm),
        (u'parameters', __EncryptedPOP_thePOPAlgID_parameters),
        ])
    _EncryptedPOP_thePOPAlgID._ext = None
    _EncryptedPOP_witnessAlgID = SEQ(name=u'witnessAlgID', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __EncryptedPOP_witnessAlgID_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___EncryptedPOP_witnessAlgID_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ____EncryptedPOP_witnessAlgID_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___EncryptedPOP_witnessAlgID_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', ____EncryptedPOP_witnessAlgID_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])
    __EncryptedPOP_witnessAlgID_algorithm._const_tab = ___EncryptedPOP_witnessAlgID_algorithm_tab
    __EncryptedPOP_witnessAlgID_algorithm._const_tab_at = None
    __EncryptedPOP_witnessAlgID_algorithm._const_tab_id = u'id'
    __EncryptedPOP_witnessAlgID_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    __EncryptedPOP_witnessAlgID_parameters._const_tab = ___EncryptedPOP_witnessAlgID_algorithm_tab
    __EncryptedPOP_witnessAlgID_parameters._const_tab_at = ('..', u'algorithm')
    __EncryptedPOP_witnessAlgID_parameters._const_tab_id = u'Params'
    _EncryptedPOP_witnessAlgID._cont = ASN1Dict([
        (u'algorithm', __EncryptedPOP_witnessAlgID_algorithm),
        (u'parameters', __EncryptedPOP_witnessAlgID_parameters),
        ])
    _EncryptedPOP_witnessAlgID._ext = None
    _EncryptedPOP_witness = OCT_STR(name=u'witness', mode=MODE_TYPE)
    EncryptedPOP._cont = ASN1Dict([
        (u'request', _EncryptedPOP_request),
        (u'cms', _EncryptedPOP_cms),
        (u'thePOPAlgID', _EncryptedPOP_thePOPAlgID),
        (u'witnessAlgID', _EncryptedPOP_witnessAlgID),
        (u'witness', _EncryptedPOP_witness),
        ])
    EncryptedPOP._ext = None
    
    #-----< POPAlgs >-----#
    POPAlgs = CLASS(name=u'POPAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    _POPAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    POPAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', _POPAlgs_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=[], er=[])
    
    #-----< WitnessAlgs >-----#
    WitnessAlgs = CLASS(name=u'WitnessAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _WitnessAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    WitnessAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', _WitnessAlgs_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=[], er=[])
    
    #-----< DecryptedPOP >-----#
    DecryptedPOP = SEQ(name=u'DecryptedPOP', mode=MODE_TYPE)
    _DecryptedPOP_bodyPartID = INT(name=u'bodyPartID', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _DecryptedPOP_thePOPAlgID = SEQ(name=u'thePOPAlgID', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __DecryptedPOP_thePOPAlgID_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'id']))
    ___DecryptedPOP_thePOPAlgID_algorithm_tab = CLASS(name='_tab_MAC-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    ____DecryptedPOP_thePOPAlgID_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___DecryptedPOP_thePOPAlgID_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', ____DecryptedPOP_thePOPAlgID_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=None, er=[])
    __DecryptedPOP_thePOPAlgID_algorithm._const_tab = ___DecryptedPOP_thePOPAlgID_algorithm_tab
    __DecryptedPOP_thePOPAlgID_algorithm._const_tab_at = None
    __DecryptedPOP_thePOPAlgID_algorithm._const_tab_id = u'id'
    __DecryptedPOP_thePOPAlgID_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'Params']), opt=True)
    __DecryptedPOP_thePOPAlgID_parameters._const_tab = ___DecryptedPOP_thePOPAlgID_algorithm_tab
    __DecryptedPOP_thePOPAlgID_parameters._const_tab_at = ('..', u'algorithm')
    __DecryptedPOP_thePOPAlgID_parameters._const_tab_id = u'Params'
    _DecryptedPOP_thePOPAlgID._cont = ASN1Dict([
        (u'algorithm', __DecryptedPOP_thePOPAlgID_algorithm),
        (u'parameters', __DecryptedPOP_thePOPAlgID_parameters),
        ])
    _DecryptedPOP_thePOPAlgID._ext = None
    _DecryptedPOP_thePOP = OCT_STR(name=u'thePOP', mode=MODE_TYPE)
    DecryptedPOP._cont = ASN1Dict([
        (u'bodyPartID', _DecryptedPOP_bodyPartID),
        (u'thePOPAlgID', _DecryptedPOP_thePOPAlgID),
        (u'thePOP', _DecryptedPOP_thePOP),
        ])
    DecryptedPOP._ext = None
    
    #-----< cmc-lraPOPWitness >-----#
    cmc_lraPOPWitness = CLASS(name=u'cmc-lraPOPWitness', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_lraPOPWitness_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'LraPopWitness')))
    cmc_lraPOPWitness._val = dict([('Type', _cmc_lraPOPWitness_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 11))])
    
    #-----< id-cmc-lraPOPWitness >-----#
    id_cmc_lraPOPWitness = OID(name=u'id-cmc-lraPOPWitness', mode=MODE_VALUE)
    id_cmc_lraPOPWitness._val = (1, 3, 6, 1, 5, 5, 7, 7, 11)
    
    #-----< LraPopWitness >-----#
    LraPopWitness = SEQ(name=u'LraPopWitness', mode=MODE_TYPE)
    _LraPopWitness_pkiDataBodyid = INT(name=u'pkiDataBodyid', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _LraPopWitness_bodyIds = SEQ_OF(name=u'bodyIds', mode=MODE_TYPE)
    __LraPopWitness_bodyIds__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _LraPopWitness_bodyIds._cont = __LraPopWitness_bodyIds__item_
    LraPopWitness._cont = ASN1Dict([
        (u'pkiDataBodyid', _LraPopWitness_pkiDataBodyid),
        (u'bodyIds', _LraPopWitness_bodyIds),
        ])
    LraPopWitness._ext = None
    
    #-----< cmc-getCert >-----#
    cmc_getCert = CLASS(name=u'cmc-getCert', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_getCert_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'GetCert')))
    cmc_getCert._val = dict([('Type', _cmc_getCert_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 15))])
    
    #-----< id-cmc-getCert >-----#
    id_cmc_getCert = OID(name=u'id-cmc-getCert', mode=MODE_VALUE)
    id_cmc_getCert._val = (1, 3, 6, 1, 5, 5, 7, 7, 15)
    
    #-----< GetCert >-----#
    GetCert = SEQ(name=u'GetCert', mode=MODE_TYPE)
    _GetCert_issuerName = CHOICE(name=u'issuerName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _GetCert_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE)
    GetCert._cont = ASN1Dict([
        (u'issuerName', _GetCert_issuerName),
        (u'serialNumber', _GetCert_serialNumber),
        ])
    GetCert._ext = None
    
    #-----< cmc-getCRL >-----#
    cmc_getCRL = CLASS(name=u'cmc-getCRL', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_getCRL_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'GetCRL')))
    cmc_getCRL._val = dict([('Type', _cmc_getCRL_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 16))])
    
    #-----< id-cmc-getCRL >-----#
    id_cmc_getCRL = OID(name=u'id-cmc-getCRL', mode=MODE_VALUE)
    id_cmc_getCRL._val = (1, 3, 6, 1, 5, 5, 7, 7, 16)
    
    #-----< GetCRL >-----#
    GetCRL = SEQ(name=u'GetCRL', mode=MODE_TYPE)
    _GetCRL_issuerName = CHOICE(name=u'issuerName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _GetCRL_cRLName = CHOICE(name=u'cRLName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')), opt=True)
    _GetCRL_time = TIME_GEN(name=u'time', mode=MODE_TYPE, opt=True)
    _GetCRL_reasons = BIT_STR(name=u'reasons', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'ReasonFlags')), opt=True)
    GetCRL._cont = ASN1Dict([
        (u'issuerName', _GetCRL_issuerName),
        (u'cRLName', _GetCRL_cRLName),
        (u'time', _GetCRL_time),
        (u'reasons', _GetCRL_reasons),
        ])
    GetCRL._ext = None
    
    #-----< cmc-revokeRequest >-----#
    cmc_revokeRequest = CLASS(name=u'cmc-revokeRequest', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_revokeRequest_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'RevokeRequest')))
    cmc_revokeRequest._val = dict([('Type', _cmc_revokeRequest_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 17))])
    
    #-----< id-cmc-revokeRequest >-----#
    id_cmc_revokeRequest = OID(name=u'id-cmc-revokeRequest', mode=MODE_VALUE)
    id_cmc_revokeRequest._val = (1, 3, 6, 1, 5, 5, 7, 7, 17)
    
    #-----< RevokeRequest >-----#
    RevokeRequest = SEQ(name=u'RevokeRequest', mode=MODE_TYPE)
    _RevokeRequest_issuerName = CHOICE(name=u'issuerName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _RevokeRequest_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE)
    _RevokeRequest_reason = ENUM(name=u'reason', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLReason')))
    _RevokeRequest_invalidityDate = TIME_GEN(name=u'invalidityDate', mode=MODE_TYPE, opt=True)
    _RevokeRequest_passphrase = OCT_STR(name=u'passphrase', mode=MODE_TYPE, opt=True)
    _RevokeRequest_comment = STR_UTF8(name=u'comment', mode=MODE_TYPE, opt=True)
    RevokeRequest._cont = ASN1Dict([
        (u'issuerName', _RevokeRequest_issuerName),
        (u'serialNumber', _RevokeRequest_serialNumber),
        (u'reason', _RevokeRequest_reason),
        (u'invalidityDate', _RevokeRequest_invalidityDate),
        (u'passphrase', _RevokeRequest_passphrase),
        (u'comment', _RevokeRequest_comment),
        ])
    RevokeRequest._ext = None
    
    #-----< cmc-confirmCertAcceptance >-----#
    cmc_confirmCertAcceptance = CLASS(name=u'cmc-confirmCertAcceptance', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_confirmCertAcceptance_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCCertId')))
    cmc_confirmCertAcceptance._val = dict([('Type', _cmc_confirmCertAcceptance_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 24))])
    
    #-----< id-cmc-confirmCertAcceptance >-----#
    id_cmc_confirmCertAcceptance = OID(name=u'id-cmc-confirmCertAcceptance', mode=MODE_VALUE)
    id_cmc_confirmCertAcceptance._val = (1, 3, 6, 1, 5, 5, 7, 7, 24)
    
    #-----< CMCCertId >-----#
    CMCCertId = SEQ(name=u'CMCCertId', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'IssuerAndSerialNumber')))
    
    #-----< at-extension-req >-----#
    at_extension_req = CLASS(name=u'at-extension-req', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_extension_req_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'ExtensionReq')))
    at_extension_req._val = dict([(u'Type', _at_extension_req_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 14))])
    
    #-----< id-ExtensionReq >-----#
    id_ExtensionReq = OID(name=u'id-ExtensionReq', mode=MODE_VALUE)
    id_ExtensionReq._val = (1, 2, 840, 113549, 1, 9, 14)
    
    #-----< ExtensionReq >-----#
    ExtensionReq = SEQ_OF(name=u'ExtensionReq', mode=MODE_TYPE)
    _ExtensionReq__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    __ExtensionReq__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ___ExtensionReq__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_1 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_2 = BIT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyUsage')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_3 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PrivateKeyUsagePeriod')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_4 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertificatePolicies')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_5 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyMappings')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_6 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_7 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_8 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectDirectoryAttributes')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_9 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'BasicConstraints')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_10 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'NameConstraints')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_11 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyConstraints')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_12 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'ExtKeyUsageSyntax')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_13 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_14 = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_15 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_16 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    ____ExtensionReq__item__extnID_tab_val_ExtnType_17 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectInfoAccessSyntax')))
    ___ExtensionReq__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_0), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_1), (u'id', (2, 5, 29, 14))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 15))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_3), (u'id', (2, 5, 29, 16))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_4), (u'id', (2, 5, 29, 32))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_5), (u'id', (2, 5, 29, 33))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_6), (u'id', (2, 5, 29, 17))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_7), (u'id', (2, 5, 29, 18))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_8), (u'id', (2, 5, 29, 9))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_9), (u'id', (2, 5, 29, 19))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_10), (u'id', (2, 5, 29, 30))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_11), (u'id', (2, 5, 29, 36))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_12), (u'id', (2, 5, 29, 37))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_13), (u'id', (2, 5, 29, 31))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_14), (u'id', (2, 5, 29, 54))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_15), (u'id', (2, 5, 29, 46))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_16), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))]), dict([(u'ExtnType', ____ExtensionReq__item__extnID_tab_val_ExtnType_17), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 11))])], rr=[], ev=None, er=[])
    __ExtensionReq__item__extnID._const_tab = ___ExtensionReq__item__extnID_tab
    __ExtensionReq__item__extnID._const_tab_at = None
    __ExtensionReq__item__extnID._const_tab_id = u'id'
    __ExtensionReq__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    __ExtensionReq__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ___ExtensionReq__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ___ExtensionReq__item__extnValue_contain._const_tab = ___ExtensionReq__item__extnID_tab
    ___ExtensionReq__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ___ExtensionReq__item__extnValue_contain._const_tab_id = u'ExtnType'
    __ExtensionReq__item__extnValue._const_cont = ___ExtensionReq__item__extnValue_contain
    _ExtensionReq__item_._cont = ASN1Dict([
        (u'extnID', __ExtensionReq__item__extnID),
        (u'critical', __ExtensionReq__item__critical),
        (u'extnValue', __ExtensionReq__item__extnValue),
        ])
    _ExtensionReq__item_._ext = None
    ExtensionReq._cont = _ExtensionReq__item_
    ExtensionReq._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< sa-noSignature >-----#
    sa_noSignature = CLASS(name=u'sa-noSignature', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_noSignature_val_Value = OCT_STR(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'NoSignatureValue')))
    _sa_noSignature_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_noSignature._val = dict([(u'id', (1, 3, 6, 1, 5, 5, 7, 6, 2)), (u'Value', _sa_noSignature_val_Value), (u'Params', _sa_noSignature_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[]))])
    
    #-----< id-alg-noSignature >-----#
    id_alg_noSignature = OID(name=u'id-alg-noSignature', mode=MODE_VALUE)
    id_alg_noSignature._val = (1, 3, 6, 1, 5, 5, 7, 6, 2)
    
    #-----< NoSignatureValue >-----#
    NoSignatureValue = OCT_STR(name=u'NoSignatureValue', mode=MODE_TYPE)
    
    #-----< id-aa >-----#
    id_aa = OID(name=u'id-aa', mode=MODE_VALUE)
    id_aa._val = (1, 2, 840, 113549, 1, 9, 16, 2)
    
    #-----< aa-cmc-unsignedData >-----#
    aa_cmc_unsignedData = CLASS(name=u'aa-cmc-unsignedData', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _aa_cmc_unsignedData_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCUnsignedData')))
    aa_cmc_unsignedData._val = dict([(u'Type', _aa_cmc_unsignedData_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 16, 2, 34))])
    
    #-----< id-aa-cmc-unsignedData >-----#
    id_aa_cmc_unsignedData = OID(name=u'id-aa-cmc-unsignedData', mode=MODE_VALUE)
    id_aa_cmc_unsignedData._val = (1, 2, 840, 113549, 1, 9, 16, 2, 34)
    
    #-----< CMCUnsignedData >-----#
    CMCUnsignedData = SEQ(name=u'CMCUnsignedData', mode=MODE_TYPE)
    _CMCUnsignedData_bodyPartPath = SEQ_OF(name=u'bodyPartPath', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartPath')))
    _CMCUnsignedData_identifier = OID(name=u'identifier', mode=MODE_TYPE, typeref=ASN1RefClassField(('_IMPL_', u'TYPE-IDENTIFIER'), [u'id']))
    _CMCUnsignedData_content = OPEN(name=u'content', mode=MODE_TYPE, typeref=ASN1RefClassField(('_IMPL_', u'TYPE-IDENTIFIER'), [u'Type']))
    CMCUnsignedData._cont = ASN1Dict([
        (u'bodyPartPath', _CMCUnsignedData_bodyPartPath),
        (u'identifier', _CMCUnsignedData_identifier),
        (u'content', _CMCUnsignedData_content),
        ])
    CMCUnsignedData._ext = None
    
    #-----< cmc-statusInfoV2 >-----#
    cmc_statusInfoV2 = CLASS(name=u'cmc-statusInfoV2', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_statusInfoV2_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCStatusInfoV2')))
    cmc_statusInfoV2._val = dict([('Type', _cmc_statusInfoV2_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 25))])
    
    #-----< id-cmc-statusInfoV2 >-----#
    id_cmc_statusInfoV2 = OID(name=u'id-cmc-statusInfoV2', mode=MODE_VALUE)
    id_cmc_statusInfoV2._val = (1, 3, 6, 1, 5, 5, 7, 7, 25)
    
    #-----< EXTENDED-FAILURE-INFO >-----#
    EXTENDED_FAILURE_INFO = CLASS(name=u'EXTENDED-FAILURE-INFO', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< ExtendedFailures >-----#
    ExtendedFailures = CLASS(name=u'ExtendedFailures', mode=MODE_SET, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'EXTENDED-FAILURE-INFO')))
    ExtendedFailures._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< CMCStatusInfoV2 >-----#
    CMCStatusInfoV2 = SEQ(name=u'CMCStatusInfoV2', mode=MODE_TYPE)
    _CMCStatusInfoV2_cMCStatus = INT(name=u'cMCStatus', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCStatus')))
    _CMCStatusInfoV2_bodyList = SEQ_OF(name=u'bodyList', mode=MODE_TYPE)
    __CMCStatusInfoV2_bodyList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartReference')))
    _CMCStatusInfoV2_bodyList._cont = __CMCStatusInfoV2_bodyList__item_
    _CMCStatusInfoV2_bodyList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _CMCStatusInfoV2_statusString = STR_UTF8(name=u'statusString', mode=MODE_TYPE, opt=True)
    _CMCStatusInfoV2_otherInfo = CHOICE(name=u'otherInfo', mode=MODE_TYPE, opt=True)
    __CMCStatusInfoV2_otherInfo_failInfo = INT(name=u'failInfo', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCFailInfo')))
    __CMCStatusInfoV2_otherInfo_pendInfo = SEQ(name=u'pendInfo', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PendInfo')))
    __CMCStatusInfoV2_otherInfo_extendedFailInfo = SEQ(name=u'extendedFailInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID = OID(name=u'failInfoOID', mode=MODE_TYPE, typeref=ASN1RefClassField(('_IMPL_', u'TYPE-IDENTIFIER'), [u'id']))
    ____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab = CLASS(name='TYPE-IDENTIFIER', mode=MODE_SET)
    _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab_id = OID(name='id', mode=MODE_VALUE, uniq=True)
    _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab_Type = OPEN(name='Type', mode=MODE_TYPE)
    ____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab._cont = ASN1Dict([
        ('id', _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab_id),
        ('Type', _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab_Type),
        ])
    ____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID._const_tab = ____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab
    ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID._const_tab_at = None
    ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID._const_tab_id = u'id'
    ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue = OPEN(name=u'failInfoValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('_IMPL_', u'TYPE-IDENTIFIER'), [u'Type']))
    ____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab = CLASS(name='TYPE-IDENTIFIER', mode=MODE_SET)
    _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab_id = OID(name='id', mode=MODE_VALUE, uniq=True)
    _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab_Type = OPEN(name='Type', mode=MODE_TYPE)
    ____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab._cont = ASN1Dict([
        ('id', _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab_id),
        ('Type', _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab_Type),
        ])
    ____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue._const_tab = ____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab
    ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue._const_tab_at = ('..', u'failInfoOID')
    ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue._const_tab_id = u'Type'
    __CMCStatusInfoV2_otherInfo_extendedFailInfo._cont = ASN1Dict([
        (u'failInfoOID', ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID),
        (u'failInfoValue', ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue),
        ])
    __CMCStatusInfoV2_otherInfo_extendedFailInfo._ext = None
    _CMCStatusInfoV2_otherInfo._cont = ASN1Dict([
        (u'failInfo', __CMCStatusInfoV2_otherInfo_failInfo),
        (u'pendInfo', __CMCStatusInfoV2_otherInfo_pendInfo),
        (u'extendedFailInfo', __CMCStatusInfoV2_otherInfo_extendedFailInfo),
        ])
    _CMCStatusInfoV2_otherInfo._ext = None
    CMCStatusInfoV2._cont = ASN1Dict([
        (u'cMCStatus', _CMCStatusInfoV2_cMCStatus),
        (u'bodyList', _CMCStatusInfoV2_bodyList),
        (u'statusString', _CMCStatusInfoV2_statusString),
        (u'otherInfo', _CMCStatusInfoV2_otherInfo),
        ])
    CMCStatusInfoV2._ext = None
    
    #-----< BodyPartReference >-----#
    BodyPartReference = CHOICE(name=u'BodyPartReference', mode=MODE_TYPE)
    _BodyPartReference_bodyPartID = INT(name=u'bodyPartID', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    _BodyPartReference_bodyPartPath = SEQ_OF(name=u'bodyPartPath', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartPath')))
    BodyPartReference._cont = ASN1Dict([
        (u'bodyPartID', _BodyPartReference_bodyPartID),
        (u'bodyPartPath', _BodyPartReference_bodyPartPath),
        ])
    BodyPartReference._ext = None
    
    #-----< BodyPartPath >-----#
    BodyPartPath = SEQ_OF(name=u'BodyPartPath', mode=MODE_TYPE)
    _BodyPartPath__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    BodyPartPath._cont = _BodyPartPath__item_
    BodyPartPath._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< cmc-trustedAnchors >-----#
    cmc_trustedAnchors = CLASS(name=u'cmc-trustedAnchors', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_trustedAnchors_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PublishTrustAnchors')))
    cmc_trustedAnchors._val = dict([('Type', _cmc_trustedAnchors_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 26))])
    
    #-----< id-cmc-trustedAnchors >-----#
    id_cmc_trustedAnchors = OID(name=u'id-cmc-trustedAnchors', mode=MODE_VALUE)
    id_cmc_trustedAnchors._val = (1, 3, 6, 1, 5, 5, 7, 7, 26)
    
    #-----< PublishTrustAnchors >-----#
    PublishTrustAnchors = SEQ(name=u'PublishTrustAnchors', mode=MODE_TYPE)
    _PublishTrustAnchors_seqNumber = INT(name=u'seqNumber', mode=MODE_TYPE)
    _PublishTrustAnchors_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __PublishTrustAnchors_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___PublishTrustAnchors_hashAlgorithm_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ____PublishTrustAnchors_hashAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____PublishTrustAnchors_hashAlgorithm_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ___PublishTrustAnchors_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', ____PublishTrustAnchors_hashAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', ____PublishTrustAnchors_hashAlgorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])
    __PublishTrustAnchors_hashAlgorithm_algorithm._const_tab = ___PublishTrustAnchors_hashAlgorithm_algorithm_tab
    __PublishTrustAnchors_hashAlgorithm_algorithm._const_tab_at = None
    __PublishTrustAnchors_hashAlgorithm_algorithm._const_tab_id = u'id'
    __PublishTrustAnchors_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    __PublishTrustAnchors_hashAlgorithm_parameters._const_tab = ___PublishTrustAnchors_hashAlgorithm_algorithm_tab
    __PublishTrustAnchors_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __PublishTrustAnchors_hashAlgorithm_parameters._const_tab_id = u'Params'
    _PublishTrustAnchors_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', __PublishTrustAnchors_hashAlgorithm_algorithm),
        (u'parameters', __PublishTrustAnchors_hashAlgorithm_parameters),
        ])
    _PublishTrustAnchors_hashAlgorithm._ext = None
    _PublishTrustAnchors_anchorHashes = SEQ_OF(name=u'anchorHashes', mode=MODE_TYPE)
    __PublishTrustAnchors_anchorHashes__item_ = OCT_STR(name='_item_', mode=MODE_TYPE)
    _PublishTrustAnchors_anchorHashes._cont = __PublishTrustAnchors_anchorHashes__item_
    PublishTrustAnchors._cont = ASN1Dict([
        (u'seqNumber', _PublishTrustAnchors_seqNumber),
        (u'hashAlgorithm', _PublishTrustAnchors_hashAlgorithm),
        (u'anchorHashes', _PublishTrustAnchors_anchorHashes),
        ])
    PublishTrustAnchors._ext = None
    
    #-----< HashAlgorithms >-----#
    HashAlgorithms = CLASS(name=u'HashAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _HashAlgorithms_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgorithms_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    HashAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', _HashAlgorithms_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', _HashAlgorithms_val_Params_1), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=[], er=[])
    
    #-----< cmc-authData >-----#
    cmc_authData = CLASS(name=u'cmc-authData', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_authData_val_Type = INT(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'AuthPublish')))
    cmc_authData._val = dict([('Type', _cmc_authData_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 27))])
    
    #-----< id-cmc-authData >-----#
    id_cmc_authData = OID(name=u'id-cmc-authData', mode=MODE_VALUE)
    id_cmc_authData._val = (1, 3, 6, 1, 5, 5, 7, 7, 27)
    
    #-----< AuthPublish >-----#
    AuthPublish = INT(name=u'AuthPublish', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    
    #-----< cmc-batchRequests >-----#
    cmc_batchRequests = CLASS(name=u'cmc-batchRequests', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_batchRequests_val_Type = SEQ_OF(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartList')))
    cmc_batchRequests._val = dict([('Type', _cmc_batchRequests_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 28))])
    
    #-----< id-cmc-batchRequests >-----#
    id_cmc_batchRequests = OID(name=u'id-cmc-batchRequests', mode=MODE_VALUE)
    id_cmc_batchRequests._val = (1, 3, 6, 1, 5, 5, 7, 7, 28)
    
    #-----< cmc-batchResponses >-----#
    cmc_batchResponses = CLASS(name=u'cmc-batchResponses', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_batchResponses_val_Type = SEQ_OF(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartList')))
    cmc_batchResponses._val = dict([('Type', _cmc_batchResponses_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 29))])
    
    #-----< id-cmc-batchResponses >-----#
    id_cmc_batchResponses = OID(name=u'id-cmc-batchResponses', mode=MODE_VALUE)
    id_cmc_batchResponses._val = (1, 3, 6, 1, 5, 5, 7, 7, 29)
    
    #-----< BodyPartList >-----#
    BodyPartList = SEQ_OF(name=u'BodyPartList', mode=MODE_TYPE)
    _BodyPartList__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartID')))
    BodyPartList._cont = _BodyPartList__item_
    BodyPartList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< cmc-publishCert >-----#
    cmc_publishCert = CLASS(name=u'cmc-publishCert', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_publishCert_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMCPublicationInfo')))
    cmc_publishCert._val = dict([('Type', _cmc_publishCert_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 30))])
    
    #-----< id-cmc-publishCert >-----#
    id_cmc_publishCert = OID(name=u'id-cmc-publishCert', mode=MODE_VALUE)
    id_cmc_publishCert._val = (1, 3, 6, 1, 5, 5, 7, 7, 30)
    
    #-----< CMCPublicationInfo >-----#
    CMCPublicationInfo = SEQ(name=u'CMCPublicationInfo', mode=MODE_TYPE)
    _CMCPublicationInfo_hashAlg = SEQ(name=u'hashAlg', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __CMCPublicationInfo_hashAlg_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___CMCPublicationInfo_hashAlg_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ____CMCPublicationInfo_hashAlg_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CMCPublicationInfo_hashAlg_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ___CMCPublicationInfo_hashAlg_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', ____CMCPublicationInfo_hashAlg_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', ____CMCPublicationInfo_hashAlg_algorithm_tab_val_Params_1), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])
    __CMCPublicationInfo_hashAlg_algorithm._const_tab = ___CMCPublicationInfo_hashAlg_algorithm_tab
    __CMCPublicationInfo_hashAlg_algorithm._const_tab_at = None
    __CMCPublicationInfo_hashAlg_algorithm._const_tab_id = u'id'
    __CMCPublicationInfo_hashAlg_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    __CMCPublicationInfo_hashAlg_parameters._const_tab = ___CMCPublicationInfo_hashAlg_algorithm_tab
    __CMCPublicationInfo_hashAlg_parameters._const_tab_at = ('..', u'algorithm')
    __CMCPublicationInfo_hashAlg_parameters._const_tab_id = u'Params'
    _CMCPublicationInfo_hashAlg._cont = ASN1Dict([
        (u'algorithm', __CMCPublicationInfo_hashAlg_algorithm),
        (u'parameters', __CMCPublicationInfo_hashAlg_parameters),
        ])
    _CMCPublicationInfo_hashAlg._ext = None
    _CMCPublicationInfo_certHashes = SEQ_OF(name=u'certHashes', mode=MODE_TYPE)
    __CMCPublicationInfo_certHashes__item_ = OCT_STR(name='_item_', mode=MODE_TYPE)
    _CMCPublicationInfo_certHashes._cont = __CMCPublicationInfo_certHashes__item_
    _CMCPublicationInfo_pubInfo = SEQ(name=u'pubInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'PKIPublicationInfo')))
    CMCPublicationInfo._cont = ASN1Dict([
        (u'hashAlg', _CMCPublicationInfo_hashAlg),
        (u'certHashes', _CMCPublicationInfo_certHashes),
        (u'pubInfo', _CMCPublicationInfo_pubInfo),
        ])
    CMCPublicationInfo._ext = None
    
    #-----< cmc-modCertTemplate >-----#
    cmc_modCertTemplate = CLASS(name=u'cmc-modCertTemplate', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_modCertTemplate_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'ModCertTemplate')))
    cmc_modCertTemplate._val = dict([('Type', _cmc_modCertTemplate_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 31))])
    
    #-----< id-cmc-modCertTemplate >-----#
    id_cmc_modCertTemplate = OID(name=u'id-cmc-modCertTemplate', mode=MODE_VALUE)
    id_cmc_modCertTemplate._val = (1, 3, 6, 1, 5, 5, 7, 7, 31)
    
    #-----< ModCertTemplate >-----#
    ModCertTemplate = SEQ(name=u'ModCertTemplate', mode=MODE_TYPE)
    _ModCertTemplate_pkiDataReference = SEQ_OF(name=u'pkiDataReference', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartPath')))
    _ModCertTemplate_certReferences = SEQ_OF(name=u'certReferences', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartList')))
    _ModCertTemplate_replace = BOOL(name=u'replace', mode=MODE_TYPE, default=True)
    _ModCertTemplate_certTemplate = SEQ(name=u'certTemplate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'CertTemplate')))
    ModCertTemplate._cont = ASN1Dict([
        (u'pkiDataReference', _ModCertTemplate_pkiDataReference),
        (u'certReferences', _ModCertTemplate_certReferences),
        (u'replace', _ModCertTemplate_replace),
        (u'certTemplate', _ModCertTemplate_certTemplate),
        ])
    ModCertTemplate._ext = None
    
    #-----< cmc-controlProcessed >-----#
    cmc_controlProcessed = CLASS(name=u'cmc-controlProcessed', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_controlProcessed_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'ControlsProcessed')))
    cmc_controlProcessed._val = dict([('Type', _cmc_controlProcessed_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 32))])
    
    #-----< id-cmc-controlProcessed >-----#
    id_cmc_controlProcessed = OID(name=u'id-cmc-controlProcessed', mode=MODE_VALUE)
    id_cmc_controlProcessed._val = (1, 3, 6, 1, 5, 5, 7, 7, 32)
    
    #-----< ControlsProcessed >-----#
    ControlsProcessed = SEQ(name=u'ControlsProcessed', mode=MODE_TYPE)
    _ControlsProcessed_bodyList = SEQ_OF(name=u'bodyList', mode=MODE_TYPE)
    __ControlsProcessed_bodyList__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'BodyPartReference')))
    _ControlsProcessed_bodyList._cont = __ControlsProcessed_bodyList__item_
    _ControlsProcessed_bodyList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ControlsProcessed._cont = ASN1Dict([
        (u'bodyList', _ControlsProcessed_bodyList),
        ])
    ControlsProcessed._ext = None
    
    #-----< cmc-identityProofV2 >-----#
    cmc_identityProofV2 = CLASS(name=u'cmc-identityProofV2', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_identityProofV2_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'IdentityProofV2')))
    cmc_identityProofV2._val = dict([('Type', _cmc_identityProofV2_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 33))])
    
    #-----< id-cmc-identityProofV2 >-----#
    id_cmc_identityProofV2 = OID(name=u'id-cmc-identityProofV2', mode=MODE_VALUE)
    id_cmc_identityProofV2._val = (1, 3, 6, 1, 5, 5, 7, 7, 33)
    
    #-----< IdentityProofV2 >-----#
    IdentityProofV2 = SEQ(name=u'IdentityProofV2', mode=MODE_TYPE)
    _IdentityProofV2_proofAlgID = SEQ(name=u'proofAlgID', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __IdentityProofV2_proofAlgID_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___IdentityProofV2_proofAlgID_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ____IdentityProofV2_proofAlgID_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___IdentityProofV2_proofAlgID_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', ____IdentityProofV2_proofAlgID_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])
    __IdentityProofV2_proofAlgID_algorithm._const_tab = ___IdentityProofV2_proofAlgID_algorithm_tab
    __IdentityProofV2_proofAlgID_algorithm._const_tab_at = None
    __IdentityProofV2_proofAlgID_algorithm._const_tab_id = u'id'
    __IdentityProofV2_proofAlgID_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    __IdentityProofV2_proofAlgID_parameters._const_tab = ___IdentityProofV2_proofAlgID_algorithm_tab
    __IdentityProofV2_proofAlgID_parameters._const_tab_at = ('..', u'algorithm')
    __IdentityProofV2_proofAlgID_parameters._const_tab_id = u'Params'
    _IdentityProofV2_proofAlgID._cont = ASN1Dict([
        (u'algorithm', __IdentityProofV2_proofAlgID_algorithm),
        (u'parameters', __IdentityProofV2_proofAlgID_parameters),
        ])
    _IdentityProofV2_proofAlgID._ext = None
    _IdentityProofV2_macAlgId = SEQ(name=u'macAlgId', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __IdentityProofV2_macAlgId_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'id']))
    ___IdentityProofV2_macAlgId_algorithm_tab = CLASS(name='_tab_MAC-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    ____IdentityProofV2_macAlgId_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___IdentityProofV2_macAlgId_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', ____IdentityProofV2_macAlgId_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=None, er=[])
    __IdentityProofV2_macAlgId_algorithm._const_tab = ___IdentityProofV2_macAlgId_algorithm_tab
    __IdentityProofV2_macAlgId_algorithm._const_tab_at = None
    __IdentityProofV2_macAlgId_algorithm._const_tab_id = u'id'
    __IdentityProofV2_macAlgId_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'Params']), opt=True)
    __IdentityProofV2_macAlgId_parameters._const_tab = ___IdentityProofV2_macAlgId_algorithm_tab
    __IdentityProofV2_macAlgId_parameters._const_tab_at = ('..', u'algorithm')
    __IdentityProofV2_macAlgId_parameters._const_tab_id = u'Params'
    _IdentityProofV2_macAlgId._cont = ASN1Dict([
        (u'algorithm', __IdentityProofV2_macAlgId_algorithm),
        (u'parameters', __IdentityProofV2_macAlgId_parameters),
        ])
    _IdentityProofV2_macAlgId._ext = None
    _IdentityProofV2_witness = OCT_STR(name=u'witness', mode=MODE_TYPE)
    IdentityProofV2._cont = ASN1Dict([
        (u'proofAlgID', _IdentityProofV2_proofAlgID),
        (u'macAlgId', _IdentityProofV2_macAlgId),
        (u'witness', _IdentityProofV2_witness),
        ])
    IdentityProofV2._ext = None
    
    #-----< cmc-popLinkWitnessV2 >-----#
    cmc_popLinkWitnessV2 = CLASS(name=u'cmc-popLinkWitnessV2', mode=MODE_VALUE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'CMC-CONTROL')))
    _cmc_popLinkWitnessV2_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('EnrollmentMessageSyntax-2009', 'PopLinkWitnessV2')))
    cmc_popLinkWitnessV2._val = dict([('Type', _cmc_popLinkWitnessV2_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 7, 34))])
    
    #-----< id-cmc-popLinkWitnessV2 >-----#
    id_cmc_popLinkWitnessV2 = OID(name=u'id-cmc-popLinkWitnessV2', mode=MODE_VALUE)
    id_cmc_popLinkWitnessV2._val = (1, 3, 6, 1, 5, 5, 7, 7, 34)
    
    #-----< PopLinkWitnessV2 >-----#
    PopLinkWitnessV2 = SEQ(name=u'PopLinkWitnessV2', mode=MODE_TYPE)
    _PopLinkWitnessV2_keyGenAlgorithm = SEQ(name=u'keyGenAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __PopLinkWitnessV2_keyGenAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-DERIVATION'), [u'id']))
    ___PopLinkWitnessV2_keyGenAlgorithm_algorithm_tab = CLASS(name='_tab_KEY-DERIVATION', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-DERIVATION')))
    ____PopLinkWitnessV2_keyGenAlgorithm_algorithm_tab_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-params')))
    ___PopLinkWitnessV2_keyGenAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 5, 12)), (u'Params', ____PopLinkWitnessV2_keyGenAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=None, er=[])
    __PopLinkWitnessV2_keyGenAlgorithm_algorithm._const_tab = ___PopLinkWitnessV2_keyGenAlgorithm_algorithm_tab
    __PopLinkWitnessV2_keyGenAlgorithm_algorithm._const_tab_at = None
    __PopLinkWitnessV2_keyGenAlgorithm_algorithm._const_tab_id = u'id'
    __PopLinkWitnessV2_keyGenAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'KEY-DERIVATION'), [u'Params']), opt=True)
    __PopLinkWitnessV2_keyGenAlgorithm_parameters._const_tab = ___PopLinkWitnessV2_keyGenAlgorithm_algorithm_tab
    __PopLinkWitnessV2_keyGenAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __PopLinkWitnessV2_keyGenAlgorithm_parameters._const_tab_id = u'Params'
    _PopLinkWitnessV2_keyGenAlgorithm._cont = ASN1Dict([
        (u'algorithm', __PopLinkWitnessV2_keyGenAlgorithm_algorithm),
        (u'parameters', __PopLinkWitnessV2_keyGenAlgorithm_parameters),
        ])
    _PopLinkWitnessV2_keyGenAlgorithm._ext = None
    _PopLinkWitnessV2_macAlgorithm = SEQ(name=u'macAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __PopLinkWitnessV2_macAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'id']))
    ___PopLinkWitnessV2_macAlgorithm_algorithm_tab = CLASS(name='_tab_MAC-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    ____PopLinkWitnessV2_macAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___PopLinkWitnessV2_macAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2)), (u'Params', ____PopLinkWitnessV2_macAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredAbsent'), (u'keyed', True), (u'smimeCaps', dict([(u'id', (1, 3, 6, 1, 5, 5, 8, 1, 2))]))])], rr=[], ev=None, er=[])
    __PopLinkWitnessV2_macAlgorithm_algorithm._const_tab = ___PopLinkWitnessV2_macAlgorithm_algorithm_tab
    __PopLinkWitnessV2_macAlgorithm_algorithm._const_tab_at = None
    __PopLinkWitnessV2_macAlgorithm_algorithm._const_tab_id = u'id'
    __PopLinkWitnessV2_macAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'Params']), opt=True)
    __PopLinkWitnessV2_macAlgorithm_parameters._const_tab = ___PopLinkWitnessV2_macAlgorithm_algorithm_tab
    __PopLinkWitnessV2_macAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __PopLinkWitnessV2_macAlgorithm_parameters._const_tab_id = u'Params'
    _PopLinkWitnessV2_macAlgorithm._cont = ASN1Dict([
        (u'algorithm', __PopLinkWitnessV2_macAlgorithm_algorithm),
        (u'parameters', __PopLinkWitnessV2_macAlgorithm_parameters),
        ])
    _PopLinkWitnessV2_macAlgorithm._ext = None
    _PopLinkWitnessV2_witness = OCT_STR(name=u'witness', mode=MODE_TYPE)
    PopLinkWitnessV2._cont = ASN1Dict([
        (u'keyGenAlgorithm', _PopLinkWitnessV2_keyGenAlgorithm),
        (u'macAlgorithm', _PopLinkWitnessV2_macAlgorithm),
        (u'witness', _PopLinkWitnessV2_witness),
        ])
    PopLinkWitnessV2._ext = None
    
    #-----< KeyDevAlgs >-----#
    KeyDevAlgs = CLASS(name=u'KeyDevAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-DERIVATION')))
    _KeyDevAlgs_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntaxAlgorithms-2009', 'PBKDF2-params')))
    KeyDevAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 5, 12)), (u'Params', _KeyDevAlgs_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=[], er=[])
    
    _all_ = [
        CMC_ContentTypes,
        _CMC_ContentTypes_val_Type_0,
        _CMC_ContentTypes_val_Type_1,
        SignatureAlgs,
        _SignatureAlgs_val_Value_0,
        _SignatureAlgs_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        CMC_UnsignedAtts,
        _CMC_UnsignedAtts_val_Type_0,
        id_cmc,
        id_cct,
        ct_PKIData,
        _ct_PKIData_val_Type,
        id_cct_PKIData,
        __PKIData_controlSequence__item_,
        _PKIData_controlSequence,
        __PKIData_reqSequence__item_,
        _PKIData_reqSequence,
        __PKIData_cmsSequence__item_,
        _PKIData_cmsSequence,
        __PKIData_otherMsgSequence__item_,
        _PKIData_otherMsgSequence,
        PKIData,
        BodyPartID,
        _TaggedAttribute_bodyPartID,
        __TaggedAttribute_attrType_tab,
        ___TaggedAttribute_attrType_tab_val_Type_0,
        ___TaggedAttribute_attrType_tab_val_Type_1,
        ___TaggedAttribute_attrType_tab_val_Type_2,
        ___TaggedAttribute_attrType_tab_val_Type_3,
        ___TaggedAttribute_attrType_tab_val_Type_4,
        ___TaggedAttribute_attrType_tab_val_Type_5,
        ___TaggedAttribute_attrType_tab_val_Type_6,
        ___TaggedAttribute_attrType_tab_val_Type_7,
        ___TaggedAttribute_attrType_tab_val_Type_8,
        ___TaggedAttribute_attrType_tab_val_Type_9,
        ___TaggedAttribute_attrType_tab_val_Type_10,
        ___TaggedAttribute_attrType_tab_val_Type_11,
        ___TaggedAttribute_attrType_tab_val_Type_12,
        ___TaggedAttribute_attrType_tab_val_Type_13,
        ___TaggedAttribute_attrType_tab_val_Type_14,
        ___TaggedAttribute_attrType_tab_val_Type_15,
        ___TaggedAttribute_attrType_tab_val_Type_16,
        ___TaggedAttribute_attrType_tab_val_Type_17,
        ___TaggedAttribute_attrType_tab_val_Type_18,
        ___TaggedAttribute_attrType_tab_val_Type_19,
        ___TaggedAttribute_attrType_tab_val_Type_20,
        ___TaggedAttribute_attrType_tab_val_Type_21,
        ___TaggedAttribute_attrType_tab_val_Type_22,
        ___TaggedAttribute_attrType_tab_val_Type_23,
        ___TaggedAttribute_attrType_tab_val_Type_24,
        ___TaggedAttribute_attrType_tab_val_Type_25,
        ___TaggedAttribute_attrType_tab_val_Type_26,
        ___TaggedAttribute_attrType_tab_val_Type_27,
        ___TaggedAttribute_attrType_tab_val_Type_28,
        ___TaggedAttribute_attrType_tab_val_Type_29,
        _TaggedAttribute_attrType,
        __TaggedAttribute_attrValues__item_,
        _TaggedAttribute_attrValues,
        TaggedAttribute,
        Cmc_Control_Set,
        _Cmc_Control_Set_val_Type_0,
        _Cmc_Control_Set_val_Type_1,
        _Cmc_Control_Set_val_Type_2,
        _Cmc_Control_Set_val_Type_3,
        _Cmc_Control_Set_val_Type_4,
        _Cmc_Control_Set_val_Type_5,
        _Cmc_Control_Set_val_Type_6,
        _Cmc_Control_Set_val_Type_7,
        _Cmc_Control_Set_val_Type_8,
        _Cmc_Control_Set_val_Type_9,
        _Cmc_Control_Set_val_Type_10,
        _Cmc_Control_Set_val_Type_11,
        _Cmc_Control_Set_val_Type_12,
        _Cmc_Control_Set_val_Type_13,
        _Cmc_Control_Set_val_Type_14,
        _Cmc_Control_Set_val_Type_15,
        _Cmc_Control_Set_val_Type_16,
        _Cmc_Control_Set_val_Type_17,
        _Cmc_Control_Set_val_Type_18,
        _Cmc_Control_Set_val_Type_19,
        _Cmc_Control_Set_val_Type_20,
        _Cmc_Control_Set_val_Type_21,
        _Cmc_Control_Set_val_Type_22,
        _Cmc_Control_Set_val_Type_23,
        _Cmc_Control_Set_val_Type_24,
        _Cmc_Control_Set_val_Type_25,
        _Cmc_Control_Set_val_Type_26,
        _Cmc_Control_Set_val_Type_27,
        _Cmc_Control_Set_val_Type_28,
        _Cmc_Control_Set_val_Type_29,
        OTHER_REQUEST,
        OtherRequests,
        _TaggedRequest_tcr,
        _TaggedRequest_crm,
        __TaggedRequest_orm_bodyPartID,
        ___TaggedRequest_orm_requestMessageType_tab,
        __TaggedRequest_orm_requestMessageType,
        ___TaggedRequest_orm_requestMessageValue_tab,
        __TaggedRequest_orm_requestMessageValue,
        _TaggedRequest_orm,
        TaggedRequest,
        _TaggedCertificationRequest_bodyPartID,
        _TaggedCertificationRequest_certificationRequest,
        TaggedCertificationRequest,
        AttributeList,
        _AttributeList_val_Type_0,
        __CertificationRequest_certificationRequestInfo_version,
        __CertificationRequest_certificationRequestInfo_subject,
        _____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_0,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_0,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_1,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_1,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_2,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_2,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_3,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_4,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_4,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_5,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_5,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_6,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_6,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_7,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_7,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_8,
        ______CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_8,
        ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_algorithm,
        ____CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm_parameters,
        ___CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_algorithm,
        ___CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo_subjectPublicKey,
        __CertificationRequest_certificationRequestInfo_subjectPublicKeyInfo,
        _____CertificationRequest_certificationRequestInfo_attributes__item__type_tab,
        ______CertificationRequest_certificationRequestInfo_attributes__item__type_tab_val_Type_0,
        ____CertificationRequest_certificationRequestInfo_attributes__item__type,
        _____CertificationRequest_certificationRequestInfo_attributes__item__values__item_,
        ____CertificationRequest_certificationRequestInfo_attributes__item__values,
        ___CertificationRequest_certificationRequestInfo_attributes__item_,
        __CertificationRequest_certificationRequestInfo_attributes,
        _CertificationRequest_certificationRequestInfo,
        ___CertificationRequest_signatureAlgorithm_algorithm_tab,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_1,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_2,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_3,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_3,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_4,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_5,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_5,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_6,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_6,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_7,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_7,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_8,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_8,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_9,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_9,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Value_10,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_10,
        ____CertificationRequest_signatureAlgorithm_algorithm_tab_val_Params_11,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_1,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_2,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_3,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1,
        __CertificationRequest_signatureAlgorithm_algorithm,
        __CertificationRequest_signatureAlgorithm_parameters,
        _CertificationRequest_signatureAlgorithm,
        _CertificationRequest_signature,
        CertificationRequest,
        _TaggedContentInfo_bodyPartID,
        _TaggedContentInfo_contentInfo,
        TaggedContentInfo,
        OTHER_MSG,
        OtherMsgSet,
        _OtherMsg_bodyPartID,
        __OtherMsg_otherMsgType_tab,
        _OtherMsg_otherMsgType,
        __OtherMsg_otherMsgValue_tab,
        _OtherMsg_otherMsgValue,
        OtherMsg,
        ct_PKIResponse,
        _ct_PKIResponse_val_Type,
        id_cct_PKIResponse,
        ResponseBody,
        __PKIResponse_controlSequence__item_,
        _PKIResponse_controlSequence,
        __PKIResponse_cmsSequence__item_,
        _PKIResponse_cmsSequence,
        __PKIResponse_otherMsgSequence__item_,
        _PKIResponse_otherMsgSequence,
        PKIResponse,
        CMC_CONTROL,
        cmc_identityProof,
        _cmc_identityProof_val_Type,
        id_cmc_identityProof,
        cmc_dataReturn,
        _cmc_dataReturn_val_Type,
        id_cmc_dataReturn,
        cmc_regInfo,
        _cmc_regInfo_val_Type,
        id_cmc_regInfo,
        cmc_responseInfo,
        _cmc_responseInfo_val_Type,
        id_cmc_responseInfo,
        cmc_queryPending,
        _cmc_queryPending_val_Type,
        id_cmc_queryPending,
        cmc_popLinkRandom,
        _cmc_popLinkRandom_val_Type,
        id_cmc_popLinkRandom,
        cmc_popLinkWitness,
        _cmc_popLinkWitness_val_Type,
        id_cmc_popLinkWitness,
        cmc_identification,
        _cmc_identification_val_Type,
        id_cmc_identification,
        cmc_transactionId,
        _cmc_transactionId_val_Type,
        id_cmc_transactionId,
        cmc_senderNonce,
        _cmc_senderNonce_val_Type,
        id_cmc_senderNonce,
        cmc_recipientNonce,
        _cmc_recipientNonce_val_Type,
        id_cmc_recipientNonce,
        cmc_statusInfo,
        _cmc_statusInfo_val_Type,
        id_cmc_statusInfo,
        _CMCStatusInfo_cMCStatus,
        __CMCStatusInfo_bodyList__item_,
        _CMCStatusInfo_bodyList,
        _CMCStatusInfo_statusString,
        __CMCStatusInfo_otherInfo_failInfo,
        __CMCStatusInfo_otherInfo_pendInfo,
        _CMCStatusInfo_otherInfo,
        CMCStatusInfo,
        _PendInfo_pendToken,
        _PendInfo_pendTime,
        PendInfo,
        CMCStatus,
        CMCFailInfo,
        cmc_addExtensions,
        _cmc_addExtensions_val_Type,
        id_cmc_addExtensions,
        _AddExtensions_pkiDataReference,
        __AddExtensions_certReferences__item_,
        _AddExtensions_certReferences,
        ____AddExtensions_extensions__item__extnID_tab,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_0,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_1,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_2,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_3,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_4,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_5,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_6,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_7,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_8,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_9,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_10,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_11,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_12,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_13,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_14,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_15,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_16,
        _____AddExtensions_extensions__item__extnID_tab_val_ExtnType_17,
        ___AddExtensions_extensions__item__extnID,
        ___AddExtensions_extensions__item__critical,
        ____AddExtensions_extensions__item__extnValue_contain,
        ___AddExtensions_extensions__item__extnValue,
        __AddExtensions_extensions__item_,
        _AddExtensions_extensions,
        AddExtensions,
        cmc_encryptedPOP,
        _cmc_encryptedPOP_val_Type,
        cmc_decryptedPOP,
        _cmc_decryptedPOP_val_Type,
        id_cmc_encryptedPOP,
        id_cmc_decryptedPOP,
        _EncryptedPOP_request,
        _EncryptedPOP_cms,
        ___EncryptedPOP_thePOPAlgID_algorithm_tab,
        ____EncryptedPOP_thePOPAlgID_algorithm_tab_val_Params_0,
        __EncryptedPOP_thePOPAlgID_algorithm,
        __EncryptedPOP_thePOPAlgID_parameters,
        _EncryptedPOP_thePOPAlgID,
        ___EncryptedPOP_witnessAlgID_algorithm_tab,
        ____EncryptedPOP_witnessAlgID_algorithm_tab_val_Params_0,
        __EncryptedPOP_witnessAlgID_algorithm,
        __EncryptedPOP_witnessAlgID_parameters,
        _EncryptedPOP_witnessAlgID,
        _EncryptedPOP_witness,
        EncryptedPOP,
        POPAlgs,
        _POPAlgs_val_Params_0,
        WitnessAlgs,
        _WitnessAlgs_val_Params_0,
        _DecryptedPOP_bodyPartID,
        ___DecryptedPOP_thePOPAlgID_algorithm_tab,
        ____DecryptedPOP_thePOPAlgID_algorithm_tab_val_Params_0,
        __DecryptedPOP_thePOPAlgID_algorithm,
        __DecryptedPOP_thePOPAlgID_parameters,
        _DecryptedPOP_thePOPAlgID,
        _DecryptedPOP_thePOP,
        DecryptedPOP,
        cmc_lraPOPWitness,
        _cmc_lraPOPWitness_val_Type,
        id_cmc_lraPOPWitness,
        _LraPopWitness_pkiDataBodyid,
        __LraPopWitness_bodyIds__item_,
        _LraPopWitness_bodyIds,
        LraPopWitness,
        cmc_getCert,
        _cmc_getCert_val_Type,
        id_cmc_getCert,
        _GetCert_issuerName,
        _GetCert_serialNumber,
        GetCert,
        cmc_getCRL,
        _cmc_getCRL_val_Type,
        id_cmc_getCRL,
        _GetCRL_issuerName,
        _GetCRL_cRLName,
        _GetCRL_time,
        _GetCRL_reasons,
        GetCRL,
        cmc_revokeRequest,
        _cmc_revokeRequest_val_Type,
        id_cmc_revokeRequest,
        _RevokeRequest_issuerName,
        _RevokeRequest_serialNumber,
        _RevokeRequest_reason,
        _RevokeRequest_invalidityDate,
        _RevokeRequest_passphrase,
        _RevokeRequest_comment,
        RevokeRequest,
        cmc_confirmCertAcceptance,
        _cmc_confirmCertAcceptance_val_Type,
        id_cmc_confirmCertAcceptance,
        CMCCertId,
        at_extension_req,
        _at_extension_req_val_Type,
        id_ExtensionReq,
        ___ExtensionReq__item__extnID_tab,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_0,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_1,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_2,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_3,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_4,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_5,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_6,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_7,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_8,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_9,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_10,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_11,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_12,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_13,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_14,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_15,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_16,
        ____ExtensionReq__item__extnID_tab_val_ExtnType_17,
        __ExtensionReq__item__extnID,
        __ExtensionReq__item__critical,
        ___ExtensionReq__item__extnValue_contain,
        __ExtensionReq__item__extnValue,
        _ExtensionReq__item_,
        ExtensionReq,
        sa_noSignature,
        _sa_noSignature_val_Value,
        _sa_noSignature_val_Params,
        id_alg_noSignature,
        NoSignatureValue,
        id_aa,
        aa_cmc_unsignedData,
        _aa_cmc_unsignedData_val_Type,
        id_aa_cmc_unsignedData,
        _CMCUnsignedData_bodyPartPath,
        _CMCUnsignedData_identifier,
        _CMCUnsignedData_content,
        CMCUnsignedData,
        cmc_statusInfoV2,
        _cmc_statusInfoV2_val_Type,
        id_cmc_statusInfoV2,
        EXTENDED_FAILURE_INFO,
        ExtendedFailures,
        _CMCStatusInfoV2_cMCStatus,
        __CMCStatusInfoV2_bodyList__item_,
        _CMCStatusInfoV2_bodyList,
        _CMCStatusInfoV2_statusString,
        __CMCStatusInfoV2_otherInfo_failInfo,
        __CMCStatusInfoV2_otherInfo_pendInfo,
        _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab_id,
        _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab_Type,
        ____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID_tab,
        ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoOID,
        _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab_id,
        _____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab_Type,
        ____CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue_tab,
        ___CMCStatusInfoV2_otherInfo_extendedFailInfo_failInfoValue,
        __CMCStatusInfoV2_otherInfo_extendedFailInfo,
        _CMCStatusInfoV2_otherInfo,
        CMCStatusInfoV2,
        _BodyPartReference_bodyPartID,
        _BodyPartReference_bodyPartPath,
        BodyPartReference,
        _BodyPartPath__item_,
        BodyPartPath,
        cmc_trustedAnchors,
        _cmc_trustedAnchors_val_Type,
        id_cmc_trustedAnchors,
        _PublishTrustAnchors_seqNumber,
        ___PublishTrustAnchors_hashAlgorithm_algorithm_tab,
        ____PublishTrustAnchors_hashAlgorithm_algorithm_tab_val_Params_0,
        ____PublishTrustAnchors_hashAlgorithm_algorithm_tab_val_Params_1,
        __PublishTrustAnchors_hashAlgorithm_algorithm,
        __PublishTrustAnchors_hashAlgorithm_parameters,
        _PublishTrustAnchors_hashAlgorithm,
        __PublishTrustAnchors_anchorHashes__item_,
        _PublishTrustAnchors_anchorHashes,
        PublishTrustAnchors,
        HashAlgorithms,
        _HashAlgorithms_val_Params_0,
        _HashAlgorithms_val_Params_1,
        cmc_authData,
        _cmc_authData_val_Type,
        id_cmc_authData,
        AuthPublish,
        cmc_batchRequests,
        _cmc_batchRequests_val_Type,
        id_cmc_batchRequests,
        cmc_batchResponses,
        _cmc_batchResponses_val_Type,
        id_cmc_batchResponses,
        _BodyPartList__item_,
        BodyPartList,
        cmc_publishCert,
        _cmc_publishCert_val_Type,
        id_cmc_publishCert,
        ___CMCPublicationInfo_hashAlg_algorithm_tab,
        ____CMCPublicationInfo_hashAlg_algorithm_tab_val_Params_0,
        ____CMCPublicationInfo_hashAlg_algorithm_tab_val_Params_1,
        __CMCPublicationInfo_hashAlg_algorithm,
        __CMCPublicationInfo_hashAlg_parameters,
        _CMCPublicationInfo_hashAlg,
        __CMCPublicationInfo_certHashes__item_,
        _CMCPublicationInfo_certHashes,
        _CMCPublicationInfo_pubInfo,
        CMCPublicationInfo,
        cmc_modCertTemplate,
        _cmc_modCertTemplate_val_Type,
        id_cmc_modCertTemplate,
        _ModCertTemplate_pkiDataReference,
        _ModCertTemplate_certReferences,
        _ModCertTemplate_replace,
        _ModCertTemplate_certTemplate,
        ModCertTemplate,
        cmc_controlProcessed,
        _cmc_controlProcessed_val_Type,
        id_cmc_controlProcessed,
        __ControlsProcessed_bodyList__item_,
        _ControlsProcessed_bodyList,
        ControlsProcessed,
        cmc_identityProofV2,
        _cmc_identityProofV2_val_Type,
        id_cmc_identityProofV2,
        ___IdentityProofV2_proofAlgID_algorithm_tab,
        ____IdentityProofV2_proofAlgID_algorithm_tab_val_Params_0,
        __IdentityProofV2_proofAlgID_algorithm,
        __IdentityProofV2_proofAlgID_parameters,
        _IdentityProofV2_proofAlgID,
        ___IdentityProofV2_macAlgId_algorithm_tab,
        ____IdentityProofV2_macAlgId_algorithm_tab_val_Params_0,
        __IdentityProofV2_macAlgId_algorithm,
        __IdentityProofV2_macAlgId_parameters,
        _IdentityProofV2_macAlgId,
        _IdentityProofV2_witness,
        IdentityProofV2,
        cmc_popLinkWitnessV2,
        _cmc_popLinkWitnessV2_val_Type,
        id_cmc_popLinkWitnessV2,
        ___PopLinkWitnessV2_keyGenAlgorithm_algorithm_tab,
        ____PopLinkWitnessV2_keyGenAlgorithm_algorithm_tab_val_Params_0,
        __PopLinkWitnessV2_keyGenAlgorithm_algorithm,
        __PopLinkWitnessV2_keyGenAlgorithm_parameters,
        _PopLinkWitnessV2_keyGenAlgorithm,
        ___PopLinkWitnessV2_macAlgorithm_algorithm_tab,
        ____PopLinkWitnessV2_macAlgorithm_algorithm_tab_val_Params_0,
        __PopLinkWitnessV2_macAlgorithm_algorithm,
        __PopLinkWitnessV2_macAlgorithm_parameters,
        _PopLinkWitnessV2_macAlgorithm,
        _PopLinkWitnessV2_witness,
        PopLinkWitnessV2,
        KeyDevAlgs,
        _KeyDevAlgs_val_Params_0,
    ]

class OCSP_2009:

    _name_  = u'OCSP-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 48]
    
    _obj_ = [
        u'OCSPRequest',
        u'TBSRequest',
        u'Signature',
        u'Version',
        u'Request',
        u'CertID',
        u'OCSPResponse',
        u'OCSPResponseStatus',
        u'RESPONSE',
        u'ResponseSet',
        u'ResponseBytes',
        u'basicResponse',
        u'BasicOCSPResponse',
        u'ResponseData',
        u'ResponderID',
        u'KeyHash',
        u'SingleResponse',
        u'CertStatus',
        u'RevokedInfo',
        u'UnknownInfo',
        u'CRLReason',
        u'ArchiveCutoff',
        u'AcceptableResponses',
        u'ServiceLocator',
        u'CrlID',
        u're-ocsp-nonce',
        u're-ocsp-response',
        u're-ocsp-service-locator',
        u're-ocsp-crl',
        u're-ocsp-archive-cutoff',
        u'id-kp-OCSPSigning',
        u'id-pkix-ocsp',
        u'id-pkix-ocsp-basic',
        u'id-pkix-ocsp-nonce',
        u'id-pkix-ocsp-crl',
        u'id-pkix-ocsp-response',
        u'id-pkix-ocsp-nocheck',
        u'id-pkix-ocsp-archive-cutoff',
        u'id-pkix-ocsp-service-locator',
        ]
    _type_ = [
        u'OCSPRequest',
        u'TBSRequest',
        u'Signature',
        u'Version',
        u'Request',
        u'CertID',
        u'OCSPResponse',
        u'OCSPResponseStatus',
        u'RESPONSE',
        u'ResponseBytes',
        u'BasicOCSPResponse',
        u'ResponseData',
        u'ResponderID',
        u'KeyHash',
        u'SingleResponse',
        u'CertStatus',
        u'RevokedInfo',
        u'UnknownInfo',
        u'CRLReason',
        u'ArchiveCutoff',
        u'AcceptableResponses',
        u'ServiceLocator',
        u'CrlID',
        ]
    _set_ = [
        u'ResponseSet',
        ]
    _val_ = [
        u'basicResponse',
        u're-ocsp-nonce',
        u're-ocsp-response',
        u're-ocsp-service-locator',
        u're-ocsp-crl',
        u're-ocsp-archive-cutoff',
        u'id-kp-OCSPSigning',
        u'id-pkix-ocsp',
        u'id-pkix-ocsp-basic',
        u'id-pkix-ocsp-nonce',
        u'id-pkix-ocsp-crl',
        u'id-pkix-ocsp-response',
        u'id-pkix-ocsp-nocheck',
        u'id-pkix-ocsp-archive-cutoff',
        u'id-pkix-ocsp-service-locator',
        ]
    _class_ = [
        u'RESPONSE',
        u'ResponseSet',
        u'basicResponse',
        u're-ocsp-nonce',
        u're-ocsp-response',
        u're-ocsp-service-locator',
        u're-ocsp-crl',
        u're-ocsp-archive-cutoff',
        ]
    _param_ = [
        ]
    
    #-----< OCSPRequest >-----#
    OCSPRequest = SEQ(name=u'OCSPRequest', mode=MODE_TYPE)
    _OCSPRequest_tbsRequest = SEQ(name=u'tbsRequest', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'TBSRequest')))
    _OCSPRequest_optionalSignature = SEQ(name=u'optionalSignature', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OCSP-2009', 'Signature')), opt=True)
    OCSPRequest._cont = ASN1Dict([
        (u'tbsRequest', _OCSPRequest_tbsRequest),
        (u'optionalSignature', _OCSPRequest_optionalSignature),
        ])
    OCSPRequest._ext = None
    
    #-----< TBSRequest >-----#
    TBSRequest = SEQ(name=u'TBSRequest', mode=MODE_TYPE)
    _TBSRequest_version = INT(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OCSP-2009', 'Version')), default=0)
    _TBSRequest_requestorName = CHOICE(name=u'requestorName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')), opt=True)
    _TBSRequest_requestList = SEQ_OF(name=u'requestList', mode=MODE_TYPE)
    __TBSRequest_requestList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'Request')))
    _TBSRequest_requestList._cont = __TBSRequest_requestList__item_
    _TBSRequest_requestExtensions = SEQ_OF(name=u'requestExtensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True)
    __TBSRequest_requestExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___TBSRequest_requestExtensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____TBSRequest_requestExtensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____TBSRequest_requestExtensions__item__extnID_tab_val_ExtnType_0 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE)
    _____TBSRequest_requestExtensions__item__extnID_tab_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'AcceptableResponses')))
    ____TBSRequest_requestExtensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____TBSRequest_requestExtensions__item__extnID_tab_val_ExtnType_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 2))]), dict([(u'ExtnType', _____TBSRequest_requestExtensions__item__extnID_tab_val_ExtnType_1), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 4))])], rr=[], ev=None, er=[])
    ___TBSRequest_requestExtensions__item__extnID._const_tab = ____TBSRequest_requestExtensions__item__extnID_tab
    ___TBSRequest_requestExtensions__item__extnID._const_tab_at = None
    ___TBSRequest_requestExtensions__item__extnID._const_tab_id = u'id'
    ___TBSRequest_requestExtensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___TBSRequest_requestExtensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____TBSRequest_requestExtensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____TBSRequest_requestExtensions__item__extnValue_contain._const_tab = ____TBSRequest_requestExtensions__item__extnID_tab
    ____TBSRequest_requestExtensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____TBSRequest_requestExtensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___TBSRequest_requestExtensions__item__extnValue._const_cont = ____TBSRequest_requestExtensions__item__extnValue_contain
    __TBSRequest_requestExtensions__item_._cont = ASN1Dict([
        (u'extnID', ___TBSRequest_requestExtensions__item__extnID),
        (u'critical', ___TBSRequest_requestExtensions__item__critical),
        (u'extnValue', ___TBSRequest_requestExtensions__item__extnValue),
        ])
    __TBSRequest_requestExtensions__item_._ext = None
    _TBSRequest_requestExtensions._cont = __TBSRequest_requestExtensions__item_
    _TBSRequest_requestExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    TBSRequest._cont = ASN1Dict([
        (u'version', _TBSRequest_version),
        (u'requestorName', _TBSRequest_requestorName),
        (u'requestList', _TBSRequest_requestList),
        (u'requestExtensions', _TBSRequest_requestExtensions),
        ])
    TBSRequest._ext = None
    
    #-----< Signature >-----#
    Signature = SEQ(name=u'Signature', mode=MODE_TYPE)
    _Signature_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __Signature_signatureAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___Signature_signatureAlgorithm_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ___Signature_signatureAlgorithm_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __Signature_signatureAlgorithm_algorithm._const_tab = ___Signature_signatureAlgorithm_algorithm_tab
    __Signature_signatureAlgorithm_algorithm._const_tab_at = None
    __Signature_signatureAlgorithm_algorithm._const_tab_id = u'id'
    __Signature_signatureAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    ___Signature_signatureAlgorithm_parameters_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ___Signature_signatureAlgorithm_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __Signature_signatureAlgorithm_parameters._const_tab = ___Signature_signatureAlgorithm_parameters_tab
    __Signature_signatureAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __Signature_signatureAlgorithm_parameters._const_tab_id = u'Params'
    _Signature_signatureAlgorithm._cont = ASN1Dict([
        (u'algorithm', __Signature_signatureAlgorithm_algorithm),
        (u'parameters', __Signature_signatureAlgorithm_parameters),
        ])
    _Signature_signatureAlgorithm._ext = None
    _Signature_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    _Signature_certs = SEQ_OF(name=u'certs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __Signature_certs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Certificate')))
    _Signature_certs._cont = __Signature_certs__item_
    Signature._cont = ASN1Dict([
        (u'signatureAlgorithm', _Signature_signatureAlgorithm),
        (u'signature', _Signature_signature),
        (u'certs', _Signature_certs),
        ])
    Signature._ext = None
    
    #-----< Version >-----#
    Version = INT(name=u'Version', mode=MODE_TYPE)
    Version._cont = ASN1Dict([(u'v1', 0)])
    
    #-----< Request >-----#
    Request = SEQ(name=u'Request', mode=MODE_TYPE)
    _Request_reqCert = SEQ(name=u'reqCert', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'CertID')))
    _Request_singleRequestExtensions = SEQ_OF(name=u'singleRequestExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True)
    __Request_singleRequestExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___Request_singleRequestExtensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____Request_singleRequestExtensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____Request_singleRequestExtensions__item__extnID_tab_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'ServiceLocator')))
    ____Request_singleRequestExtensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____Request_singleRequestExtensions__item__extnID_tab_val_ExtnType_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 7))])], rr=[], ev=None, er=[])
    ___Request_singleRequestExtensions__item__extnID._const_tab = ____Request_singleRequestExtensions__item__extnID_tab
    ___Request_singleRequestExtensions__item__extnID._const_tab_at = None
    ___Request_singleRequestExtensions__item__extnID._const_tab_id = u'id'
    ___Request_singleRequestExtensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___Request_singleRequestExtensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____Request_singleRequestExtensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____Request_singleRequestExtensions__item__extnValue_contain._const_tab = ____Request_singleRequestExtensions__item__extnID_tab
    ____Request_singleRequestExtensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____Request_singleRequestExtensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___Request_singleRequestExtensions__item__extnValue._const_cont = ____Request_singleRequestExtensions__item__extnValue_contain
    __Request_singleRequestExtensions__item_._cont = ASN1Dict([
        (u'extnID', ___Request_singleRequestExtensions__item__extnID),
        (u'critical', ___Request_singleRequestExtensions__item__critical),
        (u'extnValue', ___Request_singleRequestExtensions__item__extnValue),
        ])
    __Request_singleRequestExtensions__item_._ext = None
    _Request_singleRequestExtensions._cont = __Request_singleRequestExtensions__item_
    _Request_singleRequestExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    Request._cont = ASN1Dict([
        (u'reqCert', _Request_reqCert),
        (u'singleRequestExtensions', _Request_singleRequestExtensions),
        ])
    Request._ext = None
    
    #-----< CertID >-----#
    CertID = SEQ(name=u'CertID', mode=MODE_TYPE)
    _CertID_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __CertID_hashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___CertID_hashAlgorithm_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___CertID_hashAlgorithm_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __CertID_hashAlgorithm_algorithm._const_tab = ___CertID_hashAlgorithm_algorithm_tab
    __CertID_hashAlgorithm_algorithm._const_tab_at = None
    __CertID_hashAlgorithm_algorithm._const_tab_id = u'id'
    __CertID_hashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    ___CertID_hashAlgorithm_parameters_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___CertID_hashAlgorithm_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __CertID_hashAlgorithm_parameters._const_tab = ___CertID_hashAlgorithm_parameters_tab
    __CertID_hashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __CertID_hashAlgorithm_parameters._const_tab_id = u'Params'
    _CertID_hashAlgorithm._cont = ASN1Dict([
        (u'algorithm', __CertID_hashAlgorithm_algorithm),
        (u'parameters', __CertID_hashAlgorithm_parameters),
        ])
    _CertID_hashAlgorithm._ext = None
    _CertID_issuerNameHash = OCT_STR(name=u'issuerNameHash', mode=MODE_TYPE)
    _CertID_issuerKeyHash = OCT_STR(name=u'issuerKeyHash', mode=MODE_TYPE)
    _CertID_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    CertID._cont = ASN1Dict([
        (u'hashAlgorithm', _CertID_hashAlgorithm),
        (u'issuerNameHash', _CertID_issuerNameHash),
        (u'issuerKeyHash', _CertID_issuerKeyHash),
        (u'serialNumber', _CertID_serialNumber),
        ])
    CertID._ext = None
    
    #-----< OCSPResponse >-----#
    OCSPResponse = SEQ(name=u'OCSPResponse', mode=MODE_TYPE)
    _OCSPResponse_responseStatus = ENUM(name=u'responseStatus', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'OCSPResponseStatus')))
    _OCSPResponse_responseBytes = SEQ(name=u'responseBytes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OCSP-2009', 'ResponseBytes')), opt=True)
    OCSPResponse._cont = ASN1Dict([
        (u'responseStatus', _OCSPResponse_responseStatus),
        (u'responseBytes', _OCSPResponse_responseBytes),
        ])
    OCSPResponse._ext = None
    
    #-----< OCSPResponseStatus >-----#
    OCSPResponseStatus = ENUM(name=u'OCSPResponseStatus', mode=MODE_TYPE)
    OCSPResponseStatus._cont = ASN1Dict([(u'successful', 0), (u'malformedRequest', 1), (u'internalError', 2), (u'tryLater', 3), (u'sigRequired', 5), (u'unauthorized', 6)])
    OCSPResponseStatus._ext = None
    
    #-----< RESPONSE >-----#
    RESPONSE = CLASS(name=u'RESPONSE', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< ResponseSet >-----#
    ResponseSet = CLASS(name=u'ResponseSet', mode=MODE_SET, typeref=ASN1RefType(('OCSP-2009', 'RESPONSE')))
    _ResponseSet_val_Type_0 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'BasicOCSPResponse')))
    ResponseSet._val = ASN1Set(rv=[dict([('Type', _ResponseSet_val_Type_0), ('id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 1))])], rr=[], ev=[], er=[])
    
    #-----< ResponseBytes >-----#
    ResponseBytes = SEQ(name=u'ResponseBytes', mode=MODE_TYPE)
    _ResponseBytes_responseType = OID(name=u'responseType', mode=MODE_TYPE, typeref=ASN1RefClassField(('OCSP-2009', 'RESPONSE'), [u'id']))
    __ResponseBytes_responseType_tab = CLASS(name='_tab_RESPONSE', mode=MODE_SET, typeref=ASN1RefType(('OCSP-2009', 'RESPONSE')))
    ___ResponseBytes_responseType_tab_val_Type_0 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'BasicOCSPResponse')))
    __ResponseBytes_responseType_tab._val = ASN1Set(rv=[dict([('Type', ___ResponseBytes_responseType_tab_val_Type_0), ('id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 1))])], rr=[], ev=None, er=[])
    _ResponseBytes_responseType._const_tab = __ResponseBytes_responseType_tab
    _ResponseBytes_responseType._const_tab_at = None
    _ResponseBytes_responseType._const_tab_id = u'id'
    _ResponseBytes_response = OCT_STR(name=u'response', mode=MODE_TYPE)
    __ResponseBytes_response_contain = OPEN(name='_cont_response', mode=MODE_TYPE, typeref=ASN1RefClassField(('OCSP-2009', 'RESPONSE'), [u'Type']))
    __ResponseBytes_response_contain._const_tab = __ResponseBytes_responseType_tab
    __ResponseBytes_response_contain._const_tab_at = ('..', u'responseType')
    __ResponseBytes_response_contain._const_tab_id = u'Type'
    _ResponseBytes_response._const_cont = __ResponseBytes_response_contain
    ResponseBytes._cont = ASN1Dict([
        (u'responseType', _ResponseBytes_responseType),
        (u'response', _ResponseBytes_response),
        ])
    ResponseBytes._ext = None
    
    #-----< basicResponse >-----#
    basicResponse = CLASS(name=u'basicResponse', mode=MODE_VALUE, typeref=ASN1RefType(('OCSP-2009', 'RESPONSE')))
    _basicResponse_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'BasicOCSPResponse')))
    basicResponse._val = dict([('Type', _basicResponse_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 1))])
    
    #-----< BasicOCSPResponse >-----#
    BasicOCSPResponse = SEQ(name=u'BasicOCSPResponse', mode=MODE_TYPE)
    _BasicOCSPResponse_tbsResponseData = SEQ(name=u'tbsResponseData', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'ResponseData')))
    _BasicOCSPResponse_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __BasicOCSPResponse_signatureAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___BasicOCSPResponse_signatureAlgorithm_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Value_0 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ___BasicOCSPResponse_signatureAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Value_0), (u'Params', ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_3), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))])], rr=[], ev=None, er=[])
    __BasicOCSPResponse_signatureAlgorithm_algorithm._const_tab = ___BasicOCSPResponse_signatureAlgorithm_algorithm_tab
    __BasicOCSPResponse_signatureAlgorithm_algorithm._const_tab_at = None
    __BasicOCSPResponse_signatureAlgorithm_algorithm._const_tab_id = u'id'
    __BasicOCSPResponse_signatureAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __BasicOCSPResponse_signatureAlgorithm_parameters._const_tab = ___BasicOCSPResponse_signatureAlgorithm_algorithm_tab
    __BasicOCSPResponse_signatureAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __BasicOCSPResponse_signatureAlgorithm_parameters._const_tab_id = u'Params'
    _BasicOCSPResponse_signatureAlgorithm._cont = ASN1Dict([
        (u'algorithm', __BasicOCSPResponse_signatureAlgorithm_algorithm),
        (u'parameters', __BasicOCSPResponse_signatureAlgorithm_parameters),
        ])
    _BasicOCSPResponse_signatureAlgorithm._ext = None
    _BasicOCSPResponse_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    _BasicOCSPResponse_certs = SEQ_OF(name=u'certs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __BasicOCSPResponse_certs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Certificate')))
    _BasicOCSPResponse_certs._cont = __BasicOCSPResponse_certs__item_
    BasicOCSPResponse._cont = ASN1Dict([
        (u'tbsResponseData', _BasicOCSPResponse_tbsResponseData),
        (u'signatureAlgorithm', _BasicOCSPResponse_signatureAlgorithm),
        (u'signature', _BasicOCSPResponse_signature),
        (u'certs', _BasicOCSPResponse_certs),
        ])
    BasicOCSPResponse._ext = None
    
    #-----< ResponseData >-----#
    ResponseData = SEQ(name=u'ResponseData', mode=MODE_TYPE)
    _ResponseData_version = INT(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OCSP-2009', 'Version')), default=0)
    _ResponseData_responderID = CHOICE(name=u'responderID', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'ResponderID')))
    _ResponseData_producedAt = TIME_GEN(name=u'producedAt', mode=MODE_TYPE)
    _ResponseData_responses = SEQ_OF(name=u'responses', mode=MODE_TYPE)
    __ResponseData_responses__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'SingleResponse')))
    _ResponseData_responses._cont = __ResponseData_responses__item_
    _ResponseData_responseExtensions = SEQ_OF(name=u'responseExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True)
    __ResponseData_responseExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___ResponseData_responseExtensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____ResponseData_responseExtensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____ResponseData_responseExtensions__item__extnID_tab_val_ExtnType_0 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE)
    ____ResponseData_responseExtensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____ResponseData_responseExtensions__item__extnID_tab_val_ExtnType_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 2))])], rr=[], ev=None, er=[])
    ___ResponseData_responseExtensions__item__extnID._const_tab = ____ResponseData_responseExtensions__item__extnID_tab
    ___ResponseData_responseExtensions__item__extnID._const_tab_at = None
    ___ResponseData_responseExtensions__item__extnID._const_tab_id = u'id'
    ___ResponseData_responseExtensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___ResponseData_responseExtensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____ResponseData_responseExtensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____ResponseData_responseExtensions__item__extnValue_contain._const_tab = ____ResponseData_responseExtensions__item__extnID_tab
    ____ResponseData_responseExtensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____ResponseData_responseExtensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___ResponseData_responseExtensions__item__extnValue._const_cont = ____ResponseData_responseExtensions__item__extnValue_contain
    __ResponseData_responseExtensions__item_._cont = ASN1Dict([
        (u'extnID', ___ResponseData_responseExtensions__item__extnID),
        (u'critical', ___ResponseData_responseExtensions__item__critical),
        (u'extnValue', ___ResponseData_responseExtensions__item__extnValue),
        ])
    __ResponseData_responseExtensions__item_._ext = None
    _ResponseData_responseExtensions._cont = __ResponseData_responseExtensions__item_
    _ResponseData_responseExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ResponseData._cont = ASN1Dict([
        (u'version', _ResponseData_version),
        (u'responderID', _ResponseData_responderID),
        (u'producedAt', _ResponseData_producedAt),
        (u'responses', _ResponseData_responses),
        (u'responseExtensions', _ResponseData_responseExtensions),
        ])
    ResponseData._ext = None
    
    #-----< ResponderID >-----#
    ResponderID = CHOICE(name=u'ResponderID', mode=MODE_TYPE)
    _ResponderID_byName = CHOICE(name=u'byName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _ResponderID_byKey = OCT_STR(name=u'byKey', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OCSP-2009', 'KeyHash')))
    ResponderID._cont = ASN1Dict([
        (u'byName', _ResponderID_byName),
        (u'byKey', _ResponderID_byKey),
        ])
    ResponderID._ext = None
    
    #-----< KeyHash >-----#
    KeyHash = OCT_STR(name=u'KeyHash', mode=MODE_TYPE)
    
    #-----< SingleResponse >-----#
    SingleResponse = SEQ(name=u'SingleResponse', mode=MODE_TYPE)
    _SingleResponse_certID = SEQ(name=u'certID', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'CertID')))
    _SingleResponse_certStatus = CHOICE(name=u'certStatus', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'CertStatus')))
    _SingleResponse_thisUpdate = TIME_GEN(name=u'thisUpdate', mode=MODE_TYPE)
    _SingleResponse_nextUpdate = TIME_GEN(name=u'nextUpdate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _SingleResponse_singleExtensions = SEQ_OF(name=u'singleExtensions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True)
    __SingleResponse_singleExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___SingleResponse_singleExtensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____SingleResponse_singleExtensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'CrlID')))
    _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_1 = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'ArchiveCutoff')))
    _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_2 = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLReason')))
    _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_3 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_4 = OID(name=u'ExtnType', mode=MODE_TYPE)
    _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_5 = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    ____SingleResponse_singleExtensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 3))]), dict([(u'ExtnType', _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_1), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 6))]), dict([(u'ExtnType', _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 21))]), dict([(u'ExtnType', _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_3), (u'id', (2, 5, 29, 29))]), dict([(u'ExtnType', _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_4), (u'id', (2, 5, 29, 23))]), dict([(u'ExtnType', _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_5), (u'id', (2, 5, 29, 24))])], rr=[], ev=None, er=[])
    ___SingleResponse_singleExtensions__item__extnID._const_tab = ____SingleResponse_singleExtensions__item__extnID_tab
    ___SingleResponse_singleExtensions__item__extnID._const_tab_at = None
    ___SingleResponse_singleExtensions__item__extnID._const_tab_id = u'id'
    ___SingleResponse_singleExtensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___SingleResponse_singleExtensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____SingleResponse_singleExtensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____SingleResponse_singleExtensions__item__extnValue_contain._const_tab = ____SingleResponse_singleExtensions__item__extnID_tab
    ____SingleResponse_singleExtensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____SingleResponse_singleExtensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___SingleResponse_singleExtensions__item__extnValue._const_cont = ____SingleResponse_singleExtensions__item__extnValue_contain
    __SingleResponse_singleExtensions__item_._cont = ASN1Dict([
        (u'extnID', ___SingleResponse_singleExtensions__item__extnID),
        (u'critical', ___SingleResponse_singleExtensions__item__critical),
        (u'extnValue', ___SingleResponse_singleExtensions__item__extnValue),
        ])
    __SingleResponse_singleExtensions__item_._ext = None
    _SingleResponse_singleExtensions._cont = __SingleResponse_singleExtensions__item_
    _SingleResponse_singleExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    SingleResponse._cont = ASN1Dict([
        (u'certID', _SingleResponse_certID),
        (u'certStatus', _SingleResponse_certStatus),
        (u'thisUpdate', _SingleResponse_thisUpdate),
        (u'nextUpdate', _SingleResponse_nextUpdate),
        (u'singleExtensions', _SingleResponse_singleExtensions),
        ])
    SingleResponse._ext = None
    
    #-----< CertStatus >-----#
    CertStatus = CHOICE(name=u'CertStatus', mode=MODE_TYPE)
    _CertStatus_good = NULL(name=u'good', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CertStatus_revoked = SEQ(name=u'revoked', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OCSP-2009', 'RevokedInfo')))
    _CertStatus_unknown = NULL(name=u'unknown', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('OCSP-2009', 'UnknownInfo')))
    CertStatus._cont = ASN1Dict([
        (u'good', _CertStatus_good),
        (u'revoked', _CertStatus_revoked),
        (u'unknown', _CertStatus_unknown),
        ])
    CertStatus._ext = None
    
    #-----< RevokedInfo >-----#
    RevokedInfo = SEQ(name=u'RevokedInfo', mode=MODE_TYPE)
    _RevokedInfo_revocationTime = TIME_GEN(name=u'revocationTime', mode=MODE_TYPE)
    _RevokedInfo_revocationReason = INT(name=u'revocationReason', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('OCSP-2009', 'CRLReason')), opt=True)
    RevokedInfo._cont = ASN1Dict([
        (u'revocationTime', _RevokedInfo_revocationTime),
        (u'revocationReason', _RevokedInfo_revocationReason),
        ])
    RevokedInfo._ext = None
    
    #-----< UnknownInfo >-----#
    UnknownInfo = NULL(name=u'UnknownInfo', mode=MODE_TYPE)
    
    #-----< CRLReason >-----#
    CRLReason = INT(name=u'CRLReason', mode=MODE_TYPE)
    
    #-----< ArchiveCutoff >-----#
    ArchiveCutoff = TIME_GEN(name=u'ArchiveCutoff', mode=MODE_TYPE)
    
    #-----< AcceptableResponses >-----#
    AcceptableResponses = SEQ_OF(name=u'AcceptableResponses', mode=MODE_TYPE)
    _AcceptableResponses__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('OCSP-2009', 'RESPONSE'), [u'id']))
    __AcceptableResponses__item__tab = CLASS(name='_tab_RESPONSE', mode=MODE_SET, typeref=ASN1RefType(('OCSP-2009', 'RESPONSE')))
    ___AcceptableResponses__item__tab_val_Type_0 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'BasicOCSPResponse')))
    __AcceptableResponses__item__tab._val = ASN1Set(rv=[dict([('Type', ___AcceptableResponses__item__tab_val_Type_0), ('id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 1))])], rr=[], ev=None, er=[])
    _AcceptableResponses__item_._const_tab = __AcceptableResponses__item__tab
    _AcceptableResponses__item_._const_tab_at = None
    _AcceptableResponses__item_._const_tab_id = u'id'
    AcceptableResponses._cont = _AcceptableResponses__item_
    
    #-----< ServiceLocator >-----#
    ServiceLocator = SEQ(name=u'ServiceLocator', mode=MODE_TYPE)
    _ServiceLocator_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _ServiceLocator_locator = SEQ_OF(name=u'locator', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    ServiceLocator._cont = ASN1Dict([
        (u'issuer', _ServiceLocator_issuer),
        (u'locator', _ServiceLocator_locator),
        ])
    ServiceLocator._ext = None
    
    #-----< CrlID >-----#
    CrlID = SEQ(name=u'CrlID', mode=MODE_TYPE)
    _CrlID_crlUrl = STR_IA5(name=u'crlUrl', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CrlID_crlNum = INT(name=u'crlNum', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CrlID_crlTime = TIME_GEN(name=u'crlTime', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    CrlID._cont = ASN1Dict([
        (u'crlUrl', _CrlID_crlUrl),
        (u'crlNum', _CrlID_crlNum),
        (u'crlTime', _CrlID_crlTime),
        ])
    CrlID._ext = None
    
    #-----< re-ocsp-nonce >-----#
    re_ocsp_nonce = CLASS(name=u're-ocsp-nonce', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _re_ocsp_nonce_val_ExtnType = OCT_STR(name=u'ExtnType', mode=MODE_TYPE)
    re_ocsp_nonce._val = dict([(u'ExtnType', _re_ocsp_nonce_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 2))])
    
    #-----< re-ocsp-response >-----#
    re_ocsp_response = CLASS(name=u're-ocsp-response', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _re_ocsp_response_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'AcceptableResponses')))
    re_ocsp_response._val = dict([(u'ExtnType', _re_ocsp_response_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 4))])
    
    #-----< re-ocsp-service-locator >-----#
    re_ocsp_service_locator = CLASS(name=u're-ocsp-service-locator', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _re_ocsp_service_locator_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'ServiceLocator')))
    re_ocsp_service_locator._val = dict([(u'ExtnType', _re_ocsp_service_locator_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 7))])
    
    #-----< re-ocsp-crl >-----#
    re_ocsp_crl = CLASS(name=u're-ocsp-crl', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _re_ocsp_crl_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'CrlID')))
    re_ocsp_crl._val = dict([(u'ExtnType', _re_ocsp_crl_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 3))])
    
    #-----< re-ocsp-archive-cutoff >-----#
    re_ocsp_archive_cutoff = CLASS(name=u're-ocsp-archive-cutoff', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _re_ocsp_archive_cutoff_val_ExtnType = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('OCSP-2009', 'ArchiveCutoff')))
    re_ocsp_archive_cutoff._val = dict([(u'ExtnType', _re_ocsp_archive_cutoff_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 48, 1, 6))])
    
    #-----< id-kp-OCSPSigning >-----#
    id_kp_OCSPSigning = OID(name=u'id-kp-OCSPSigning', mode=MODE_VALUE)
    id_kp_OCSPSigning._val = (1, 3, 6, 1, 5, 5, 7, 3, 9)
    
    #-----< id-pkix-ocsp >-----#
    id_pkix_ocsp = OID(name=u'id-pkix-ocsp', mode=MODE_VALUE)
    id_pkix_ocsp._val = (1, 3, 6, 1, 5, 5, 7, 48, 1)
    
    #-----< id-pkix-ocsp-basic >-----#
    id_pkix_ocsp_basic = OID(name=u'id-pkix-ocsp-basic', mode=MODE_VALUE)
    id_pkix_ocsp_basic._val = (1, 3, 6, 1, 5, 5, 7, 48, 1, 1)
    
    #-----< id-pkix-ocsp-nonce >-----#
    id_pkix_ocsp_nonce = OID(name=u'id-pkix-ocsp-nonce', mode=MODE_VALUE)
    id_pkix_ocsp_nonce._val = (1, 3, 6, 1, 5, 5, 7, 48, 1, 2)
    
    #-----< id-pkix-ocsp-crl >-----#
    id_pkix_ocsp_crl = OID(name=u'id-pkix-ocsp-crl', mode=MODE_VALUE)
    id_pkix_ocsp_crl._val = (1, 3, 6, 1, 5, 5, 7, 48, 1, 3)
    
    #-----< id-pkix-ocsp-response >-----#
    id_pkix_ocsp_response = OID(name=u'id-pkix-ocsp-response', mode=MODE_VALUE)
    id_pkix_ocsp_response._val = (1, 3, 6, 1, 5, 5, 7, 48, 1, 4)
    
    #-----< id-pkix-ocsp-nocheck >-----#
    id_pkix_ocsp_nocheck = OID(name=u'id-pkix-ocsp-nocheck', mode=MODE_VALUE)
    id_pkix_ocsp_nocheck._val = (1, 3, 6, 1, 5, 5, 7, 48, 1, 5)
    
    #-----< id-pkix-ocsp-archive-cutoff >-----#
    id_pkix_ocsp_archive_cutoff = OID(name=u'id-pkix-ocsp-archive-cutoff', mode=MODE_VALUE)
    id_pkix_ocsp_archive_cutoff._val = (1, 3, 6, 1, 5, 5, 7, 48, 1, 6)
    
    #-----< id-pkix-ocsp-service-locator >-----#
    id_pkix_ocsp_service_locator = OID(name=u'id-pkix-ocsp-service-locator', mode=MODE_VALUE)
    id_pkix_ocsp_service_locator._val = (1, 3, 6, 1, 5, 5, 7, 48, 1, 7)
    
    _all_ = [
        _OCSPRequest_tbsRequest,
        _OCSPRequest_optionalSignature,
        OCSPRequest,
        _TBSRequest_version,
        _TBSRequest_requestorName,
        __TBSRequest_requestList__item_,
        _TBSRequest_requestList,
        ____TBSRequest_requestExtensions__item__extnID_tab,
        _____TBSRequest_requestExtensions__item__extnID_tab_val_ExtnType_0,
        _____TBSRequest_requestExtensions__item__extnID_tab_val_ExtnType_1,
        ___TBSRequest_requestExtensions__item__extnID,
        ___TBSRequest_requestExtensions__item__critical,
        ____TBSRequest_requestExtensions__item__extnValue_contain,
        ___TBSRequest_requestExtensions__item__extnValue,
        __TBSRequest_requestExtensions__item_,
        _TBSRequest_requestExtensions,
        TBSRequest,
        ___Signature_signatureAlgorithm_algorithm_tab,
        __Signature_signatureAlgorithm_algorithm,
        ___Signature_signatureAlgorithm_parameters_tab,
        __Signature_signatureAlgorithm_parameters,
        _Signature_signatureAlgorithm,
        _Signature_signature,
        __Signature_certs__item_,
        _Signature_certs,
        Signature,
        Version,
        _Request_reqCert,
        ____Request_singleRequestExtensions__item__extnID_tab,
        _____Request_singleRequestExtensions__item__extnID_tab_val_ExtnType_0,
        ___Request_singleRequestExtensions__item__extnID,
        ___Request_singleRequestExtensions__item__critical,
        ____Request_singleRequestExtensions__item__extnValue_contain,
        ___Request_singleRequestExtensions__item__extnValue,
        __Request_singleRequestExtensions__item_,
        _Request_singleRequestExtensions,
        Request,
        ___CertID_hashAlgorithm_algorithm_tab,
        __CertID_hashAlgorithm_algorithm,
        ___CertID_hashAlgorithm_parameters_tab,
        __CertID_hashAlgorithm_parameters,
        _CertID_hashAlgorithm,
        _CertID_issuerNameHash,
        _CertID_issuerKeyHash,
        _CertID_serialNumber,
        CertID,
        _OCSPResponse_responseStatus,
        _OCSPResponse_responseBytes,
        OCSPResponse,
        OCSPResponseStatus,
        RESPONSE,
        ResponseSet,
        _ResponseSet_val_Type_0,
        __ResponseBytes_responseType_tab,
        ___ResponseBytes_responseType_tab_val_Type_0,
        _ResponseBytes_responseType,
        __ResponseBytes_response_contain,
        _ResponseBytes_response,
        ResponseBytes,
        basicResponse,
        _basicResponse_val_Type,
        _BasicOCSPResponse_tbsResponseData,
        ___BasicOCSPResponse_signatureAlgorithm_algorithm_tab,
        ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Value_0,
        ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0,
        ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_2,
        ____BasicOCSPResponse_signatureAlgorithm_algorithm_tab_val_Params_3,
        __BasicOCSPResponse_signatureAlgorithm_algorithm,
        __BasicOCSPResponse_signatureAlgorithm_parameters,
        _BasicOCSPResponse_signatureAlgorithm,
        _BasicOCSPResponse_signature,
        __BasicOCSPResponse_certs__item_,
        _BasicOCSPResponse_certs,
        BasicOCSPResponse,
        _ResponseData_version,
        _ResponseData_responderID,
        _ResponseData_producedAt,
        __ResponseData_responses__item_,
        _ResponseData_responses,
        ____ResponseData_responseExtensions__item__extnID_tab,
        _____ResponseData_responseExtensions__item__extnID_tab_val_ExtnType_0,
        ___ResponseData_responseExtensions__item__extnID,
        ___ResponseData_responseExtensions__item__critical,
        ____ResponseData_responseExtensions__item__extnValue_contain,
        ___ResponseData_responseExtensions__item__extnValue,
        __ResponseData_responseExtensions__item_,
        _ResponseData_responseExtensions,
        ResponseData,
        _ResponderID_byName,
        _ResponderID_byKey,
        ResponderID,
        KeyHash,
        _SingleResponse_certID,
        _SingleResponse_certStatus,
        _SingleResponse_thisUpdate,
        _SingleResponse_nextUpdate,
        ____SingleResponse_singleExtensions__item__extnID_tab,
        _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_0,
        _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_1,
        _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_2,
        _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_3,
        _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_4,
        _____SingleResponse_singleExtensions__item__extnID_tab_val_ExtnType_5,
        ___SingleResponse_singleExtensions__item__extnID,
        ___SingleResponse_singleExtensions__item__critical,
        ____SingleResponse_singleExtensions__item__extnValue_contain,
        ___SingleResponse_singleExtensions__item__extnValue,
        __SingleResponse_singleExtensions__item_,
        _SingleResponse_singleExtensions,
        SingleResponse,
        _CertStatus_good,
        _CertStatus_revoked,
        _CertStatus_unknown,
        CertStatus,
        _RevokedInfo_revocationTime,
        _RevokedInfo_revocationReason,
        RevokedInfo,
        UnknownInfo,
        CRLReason,
        ArchiveCutoff,
        __AcceptableResponses__item__tab,
        ___AcceptableResponses__item__tab_val_Type_0,
        _AcceptableResponses__item_,
        AcceptableResponses,
        _ServiceLocator_issuer,
        _ServiceLocator_locator,
        ServiceLocator,
        _CrlID_crlUrl,
        _CrlID_crlNum,
        _CrlID_crlTime,
        CrlID,
        re_ocsp_nonce,
        _re_ocsp_nonce_val_ExtnType,
        re_ocsp_response,
        _re_ocsp_response_val_ExtnType,
        re_ocsp_service_locator,
        _re_ocsp_service_locator_val_ExtnType,
        re_ocsp_crl,
        _re_ocsp_crl_val_ExtnType,
        re_ocsp_archive_cutoff,
        _re_ocsp_archive_cutoff_val_ExtnType,
        id_kp_OCSPSigning,
        id_pkix_ocsp,
        id_pkix_ocsp_basic,
        id_pkix_ocsp_nonce,
        id_pkix_ocsp_crl,
        id_pkix_ocsp_response,
        id_pkix_ocsp_nocheck,
        id_pkix_ocsp_archive_cutoff,
        id_pkix_ocsp_service_locator,
    ]

class PKCS_10:

    _name_  = u'PKCS-10'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 69]
    
    _obj_ = [
        u'CertificationRequestInfo',
        u'SubjectPublicKeyInfo',
        u'PKInfoAlgorithms',
        u'Attributes',
        u'CRIAttributes',
        u'Attribute',
        u'CertificationRequest',
        u'SignatureAlgorithms',
        ]
    _type_ = [
        u'CertificationRequestInfo',
        u'SubjectPublicKeyInfo',
        u'Attributes',
        u'Attribute',
        u'CertificationRequest',
        ]
    _set_ = [
        u'PKInfoAlgorithms',
        u'CRIAttributes',
        u'SignatureAlgorithms',
        ]
    _val_ = [
        ]
    _class_ = [
        u'PKInfoAlgorithms',
        u'CRIAttributes',
        u'SignatureAlgorithms',
        ]
    _param_ = [
        u'SubjectPublicKeyInfo',
        u'Attributes',
        u'Attribute',
        ]
    
    #-----< CertificationRequestInfo >-----#
    CertificationRequestInfo = SEQ(name=u'CertificationRequestInfo', mode=MODE_TYPE)
    _CertificationRequestInfo_version = INT(name=u'version', mode=MODE_TYPE)
    _CertificationRequestInfo_version._cont = ASN1Dict([(u'v1', 0)])
    _CertificationRequestInfo_version._const_val = ASN1Set(rv=[0], rr=[], ev=[], er=[])
    _CertificationRequestInfo_subject = CHOICE(name=u'subject', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _CertificationRequestInfo_subjectPKInfo = SEQ(name=u'subjectPKInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKCS-10', 'SubjectPublicKeyInfo')))
    __CertificationRequestInfo_subjectPKInfo_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    ___CertificationRequestInfo_subjectPKInfo_algorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'id']))
    ____CertificationRequestInfo_subjectPKInfo_algorithm_algorithm_tab = CLASS(name='_tab_PUBLIC-KEY', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    ____CertificationRequestInfo_subjectPKInfo_algorithm_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CertificationRequestInfo_subjectPKInfo_algorithm_algorithm._const_tab = ____CertificationRequestInfo_subjectPKInfo_algorithm_algorithm_tab
    ___CertificationRequestInfo_subjectPKInfo_algorithm_algorithm._const_tab_at = None
    ___CertificationRequestInfo_subjectPKInfo_algorithm_algorithm._const_tab_id = u'id'
    ___CertificationRequestInfo_subjectPKInfo_algorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'Params']), opt=True)
    ____CertificationRequestInfo_subjectPKInfo_algorithm_parameters_tab = CLASS(name='_tab_PUBLIC-KEY', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    ____CertificationRequestInfo_subjectPKInfo_algorithm_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CertificationRequestInfo_subjectPKInfo_algorithm_parameters._const_tab = ____CertificationRequestInfo_subjectPKInfo_algorithm_parameters_tab
    ___CertificationRequestInfo_subjectPKInfo_algorithm_parameters._const_tab_at = ('..', u'algorithm')
    ___CertificationRequestInfo_subjectPKInfo_algorithm_parameters._const_tab_id = u'Params'
    __CertificationRequestInfo_subjectPKInfo_algorithm._cont = ASN1Dict([
        (u'algorithm', ___CertificationRequestInfo_subjectPKInfo_algorithm_algorithm),
        (u'parameters', ___CertificationRequestInfo_subjectPKInfo_algorithm_parameters),
        ])
    __CertificationRequestInfo_subjectPKInfo_algorithm._ext = None
    __CertificationRequestInfo_subjectPKInfo_subjectPublicKey = BIT_STR(name=u'subjectPublicKey', mode=MODE_TYPE)
    _CertificationRequestInfo_subjectPKInfo._cont = ASN1Dict([
        (u'algorithm', __CertificationRequestInfo_subjectPKInfo_algorithm),
        (u'subjectPublicKey', __CertificationRequestInfo_subjectPKInfo_subjectPublicKey),
        ])
    _CertificationRequestInfo_subjectPKInfo._ext = None
    _CertificationRequestInfo_attributes = SET_OF(name=u'attributes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKCS-10', 'Attributes')))
    __CertificationRequestInfo_attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKCS-10', 'Attribute')))
    ___CertificationRequestInfo_attributes__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____CertificationRequestInfo_attributes__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____CertificationRequestInfo_attributes__item__type_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CertificationRequestInfo_attributes__item__type._const_tab = ____CertificationRequestInfo_attributes__item__type_tab
    ___CertificationRequestInfo_attributes__item__type._const_tab_at = None
    ___CertificationRequestInfo_attributes__item__type._const_tab_id = u'id'
    ___CertificationRequestInfo_attributes__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____CertificationRequestInfo_attributes__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    _____CertificationRequestInfo_attributes__item__values__item__tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____CertificationRequestInfo_attributes__item__values__item__tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____CertificationRequestInfo_attributes__item__values__item_._const_tab = _____CertificationRequestInfo_attributes__item__values__item__tab
    ____CertificationRequestInfo_attributes__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____CertificationRequestInfo_attributes__item__values__item_._const_tab_id = u'Type'
    ___CertificationRequestInfo_attributes__item__values._cont = ____CertificationRequestInfo_attributes__item__values__item_
    ___CertificationRequestInfo_attributes__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __CertificationRequestInfo_attributes__item_._cont = ASN1Dict([
        (u'type', ___CertificationRequestInfo_attributes__item__type),
        (u'values', ___CertificationRequestInfo_attributes__item__values),
        ])
    __CertificationRequestInfo_attributes__item_._ext = None
    _CertificationRequestInfo_attributes._cont = __CertificationRequestInfo_attributes__item_
    CertificationRequestInfo._cont = ASN1Dict([
        (u'version', _CertificationRequestInfo_version),
        (u'subject', _CertificationRequestInfo_subject),
        (u'subjectPKInfo', _CertificationRequestInfo_subjectPKInfo),
        (u'attributes', _CertificationRequestInfo_attributes),
        ])
    CertificationRequestInfo._ext = None
    
    #-----< SubjectPublicKeyInfo >-----#
    SubjectPublicKeyInfo = SEQ(name=u'SubjectPublicKeyInfo', mode=MODE_TYPE, param=True)
    
    #-----< PKInfoAlgorithms >-----#
    PKInfoAlgorithms = CLASS(name=u'PKInfoAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    PKInfoAlgorithms._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< Attributes >-----#
    Attributes = SET_OF(name=u'Attributes', mode=MODE_TYPE, param=True)
    
    #-----< CRIAttributes >-----#
    CRIAttributes = CLASS(name=u'CRIAttributes', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    CRIAttributes._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< Attribute >-----#
    Attribute = SEQ(name=u'Attribute', mode=MODE_TYPE, param=True)
    
    #-----< CertificationRequest >-----#
    CertificationRequest = SEQ(name=u'CertificationRequest', mode=MODE_TYPE)
    _CertificationRequest_certificationRequestInfo = SEQ(name=u'certificationRequestInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKCS-10', 'CertificationRequestInfo')))
    _CertificationRequest_signatureAlgorithm = SEQ(name=u'signatureAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __CertificationRequest_signatureAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___CertificationRequest_signatureAlgorithm_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ___CertificationRequest_signatureAlgorithm_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __CertificationRequest_signatureAlgorithm_algorithm._const_tab = ___CertificationRequest_signatureAlgorithm_algorithm_tab
    __CertificationRequest_signatureAlgorithm_algorithm._const_tab_at = None
    __CertificationRequest_signatureAlgorithm_algorithm._const_tab_id = u'id'
    __CertificationRequest_signatureAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    ___CertificationRequest_signatureAlgorithm_parameters_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ___CertificationRequest_signatureAlgorithm_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __CertificationRequest_signatureAlgorithm_parameters._const_tab = ___CertificationRequest_signatureAlgorithm_parameters_tab
    __CertificationRequest_signatureAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __CertificationRequest_signatureAlgorithm_parameters._const_tab_id = u'Params'
    _CertificationRequest_signatureAlgorithm._cont = ASN1Dict([
        (u'algorithm', __CertificationRequest_signatureAlgorithm_algorithm),
        (u'parameters', __CertificationRequest_signatureAlgorithm_parameters),
        ])
    _CertificationRequest_signatureAlgorithm._ext = None
    _CertificationRequest_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    CertificationRequest._cont = ASN1Dict([
        (u'certificationRequestInfo', _CertificationRequest_certificationRequestInfo),
        (u'signatureAlgorithm', _CertificationRequest_signatureAlgorithm),
        (u'signature', _CertificationRequest_signature),
        ])
    CertificationRequest._ext = None
    
    #-----< SignatureAlgorithms >-----#
    SignatureAlgorithms = CLASS(name=u'SignatureAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    SignatureAlgorithms._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    _all_ = [
        _CertificationRequestInfo_version,
        _CertificationRequestInfo_subject,
        ____CertificationRequestInfo_subjectPKInfo_algorithm_algorithm_tab,
        ___CertificationRequestInfo_subjectPKInfo_algorithm_algorithm,
        ____CertificationRequestInfo_subjectPKInfo_algorithm_parameters_tab,
        ___CertificationRequestInfo_subjectPKInfo_algorithm_parameters,
        __CertificationRequestInfo_subjectPKInfo_algorithm,
        __CertificationRequestInfo_subjectPKInfo_subjectPublicKey,
        _CertificationRequestInfo_subjectPKInfo,
        ____CertificationRequestInfo_attributes__item__type_tab,
        ___CertificationRequestInfo_attributes__item__type,
        _____CertificationRequestInfo_attributes__item__values__item__tab,
        ____CertificationRequestInfo_attributes__item__values__item_,
        ___CertificationRequestInfo_attributes__item__values,
        __CertificationRequestInfo_attributes__item_,
        _CertificationRequestInfo_attributes,
        CertificationRequestInfo,
        PKInfoAlgorithms,
        CRIAttributes,
        _CertificationRequest_certificationRequestInfo,
        ___CertificationRequest_signatureAlgorithm_algorithm_tab,
        __CertificationRequest_signatureAlgorithm_algorithm,
        ___CertificationRequest_signatureAlgorithm_parameters_tab,
        __CertificationRequest_signatureAlgorithm_parameters,
        _CertificationRequest_signatureAlgorithm,
        _CertificationRequest_signature,
        CertificationRequest,
        SignatureAlgorithms,
    ]

class PKIX1Explicit_2009:

    _name_  = u'PKIX1Explicit-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 51]
    
    _obj_ = [
        u'id-pkix',
        u'id-pe',
        u'id-qt',
        u'id-kp',
        u'id-ad',
        u'id-qt-cps',
        u'id-qt-unotice',
        u'id-ad-ocsp',
        u'id-ad-caIssuers',
        u'id-ad-timeStamping',
        u'id-ad-caRepository',
        u'AttributeType',
        u'id-at',
        u'id-at-name',
        u'at-name',
        u'id-at-surname',
        u'at-surname',
        u'id-at-givenName',
        u'at-givenName',
        u'id-at-initials',
        u'at-initials',
        u'id-at-generationQualifier',
        u'at-generationQualifier',
        u'DirectoryString',
        u'X520name',
        u'id-at-commonName',
        u'at-x520CommonName',
        u'X520CommonName',
        u'id-at-localityName',
        u'at-x520LocalityName',
        u'X520LocalityName',
        u'id-at-stateOrProvinceName',
        u'at-x520StateOrProvinceName',
        u'X520StateOrProvinceName',
        u'id-at-organizationName',
        u'at-x520OrganizationName',
        u'X520OrganizationName',
        u'id-at-organizationalUnitName',
        u'at-x520OrganizationalUnitName',
        u'X520OrganizationalUnitName',
        u'id-at-title',
        u'at-x520Title',
        u'id-at-dnQualifier',
        u'at-x520dnQualifier',
        u'id-at-countryName',
        u'at-x520countryName',
        u'id-at-serialNumber',
        u'at-x520SerialNumber',
        u'id-at-pseudonym',
        u'at-x520Pseudonym',
        u'id-domainComponent',
        u'at-domainComponent',
        u'pkcs-9',
        u'id-emailAddress',
        u'at-emailAddress',
        u'Name',
        u'RDNSequence',
        u'DistinguishedName',
        u'RelativeDistinguishedName',
        u'SupportedAttributes',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'Validity',
        u'Time',
        u'UniqueIdentifier',
        u'SubjectPublicKeyInfo',
        u'CertificateList',
        u'TBSCertList',
        u'SignatureAlgorithms',
        u'PublicKeyAlgorithms',
        u'ub-state-name',
        u'ub-organization-name',
        u'ub-organizational-unit-name',
        u'ub-title',
        u'ub-serial-number',
        u'ub-pseudonym',
        u'ub-emailaddress-length',
        u'ub-locality-name',
        u'ub-common-name',
        u'ub-name',
        u'SIGNED',
        ]
    _type_ = [
        u'AttributeType',
        u'DirectoryString',
        u'X520name',
        u'X520CommonName',
        u'X520LocalityName',
        u'X520StateOrProvinceName',
        u'X520OrganizationName',
        u'X520OrganizationalUnitName',
        u'Name',
        u'RDNSequence',
        u'DistinguishedName',
        u'RelativeDistinguishedName',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'Validity',
        u'Time',
        u'UniqueIdentifier',
        u'SubjectPublicKeyInfo',
        u'CertificateList',
        u'TBSCertList',
        u'SIGNED',
        ]
    _set_ = [
        u'SupportedAttributes',
        u'SignatureAlgorithms',
        u'PublicKeyAlgorithms',
        ]
    _val_ = [
        u'id-pkix',
        u'id-pe',
        u'id-qt',
        u'id-kp',
        u'id-ad',
        u'id-qt-cps',
        u'id-qt-unotice',
        u'id-ad-ocsp',
        u'id-ad-caIssuers',
        u'id-ad-timeStamping',
        u'id-ad-caRepository',
        u'id-at',
        u'id-at-name',
        u'at-name',
        u'id-at-surname',
        u'at-surname',
        u'id-at-givenName',
        u'at-givenName',
        u'id-at-initials',
        u'at-initials',
        u'id-at-generationQualifier',
        u'at-generationQualifier',
        u'id-at-commonName',
        u'at-x520CommonName',
        u'id-at-localityName',
        u'at-x520LocalityName',
        u'id-at-stateOrProvinceName',
        u'at-x520StateOrProvinceName',
        u'id-at-organizationName',
        u'at-x520OrganizationName',
        u'id-at-organizationalUnitName',
        u'at-x520OrganizationalUnitName',
        u'id-at-title',
        u'at-x520Title',
        u'id-at-dnQualifier',
        u'at-x520dnQualifier',
        u'id-at-countryName',
        u'at-x520countryName',
        u'id-at-serialNumber',
        u'at-x520SerialNumber',
        u'id-at-pseudonym',
        u'at-x520Pseudonym',
        u'id-domainComponent',
        u'at-domainComponent',
        u'pkcs-9',
        u'id-emailAddress',
        u'at-emailAddress',
        u'ub-state-name',
        u'ub-organization-name',
        u'ub-organizational-unit-name',
        u'ub-title',
        u'ub-serial-number',
        u'ub-pseudonym',
        u'ub-emailaddress-length',
        u'ub-locality-name',
        u'ub-common-name',
        u'ub-name',
        ]
    _class_ = [
        u'at-name',
        u'at-surname',
        u'at-givenName',
        u'at-initials',
        u'at-generationQualifier',
        u'at-x520CommonName',
        u'at-x520LocalityName',
        u'at-x520StateOrProvinceName',
        u'at-x520OrganizationName',
        u'at-x520OrganizationalUnitName',
        u'at-x520Title',
        u'at-x520dnQualifier',
        u'at-x520countryName',
        u'at-x520SerialNumber',
        u'at-x520Pseudonym',
        u'at-domainComponent',
        u'at-emailAddress',
        u'SupportedAttributes',
        u'SignatureAlgorithms',
        u'PublicKeyAlgorithms',
        ]
    _param_ = [
        u'DirectoryString',
        u'SIGNED',
        ]
    
    #-----< id-pkix >-----#
    id_pkix = OID(name=u'id-pkix', mode=MODE_VALUE)
    id_pkix._val = (1, 3, 6, 1, 5, 5, 7)
    
    #-----< id-pe >-----#
    id_pe = OID(name=u'id-pe', mode=MODE_VALUE)
    id_pe._val = (1, 3, 6, 1, 5, 5, 7, 1)
    
    #-----< id-qt >-----#
    id_qt = OID(name=u'id-qt', mode=MODE_VALUE)
    id_qt._val = (1, 3, 6, 1, 5, 5, 7, 2)
    
    #-----< id-kp >-----#
    id_kp = OID(name=u'id-kp', mode=MODE_VALUE)
    id_kp._val = (1, 3, 6, 1, 5, 5, 7, 3)
    
    #-----< id-ad >-----#
    id_ad = OID(name=u'id-ad', mode=MODE_VALUE)
    id_ad._val = (1, 3, 6, 1, 5, 5, 7, 48)
    
    #-----< id-qt-cps >-----#
    id_qt_cps = OID(name=u'id-qt-cps', mode=MODE_VALUE)
    id_qt_cps._val = (1, 3, 6, 1, 5, 5, 7, 2, 1)
    
    #-----< id-qt-unotice >-----#
    id_qt_unotice = OID(name=u'id-qt-unotice', mode=MODE_VALUE)
    id_qt_unotice._val = (1, 3, 6, 1, 5, 5, 7, 2, 2)
    
    #-----< id-ad-ocsp >-----#
    id_ad_ocsp = OID(name=u'id-ad-ocsp', mode=MODE_VALUE)
    id_ad_ocsp._val = (1, 3, 6, 1, 5, 5, 7, 48, 1)
    
    #-----< id-ad-caIssuers >-----#
    id_ad_caIssuers = OID(name=u'id-ad-caIssuers', mode=MODE_VALUE)
    id_ad_caIssuers._val = (1, 3, 6, 1, 5, 5, 7, 48, 2)
    
    #-----< id-ad-timeStamping >-----#
    id_ad_timeStamping = OID(name=u'id-ad-timeStamping', mode=MODE_VALUE)
    id_ad_timeStamping._val = (1, 3, 6, 1, 5, 5, 7, 48, 3)
    
    #-----< id-ad-caRepository >-----#
    id_ad_caRepository = OID(name=u'id-ad-caRepository', mode=MODE_VALUE)
    id_ad_caRepository._val = (1, 3, 6, 1, 5, 5, 7, 48, 5)
    
    #-----< AttributeType >-----#
    AttributeType = OID(name=u'AttributeType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    
    #-----< id-at >-----#
    id_at = OID(name=u'id-at', mode=MODE_VALUE)
    id_at._val = (2, 5, 4)
    
    #-----< id-at-name >-----#
    id_at_name = OID(name=u'id-at-name', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_name._val = (2, 5, 4, 41)
    
    #-----< at-name >-----#
    at_name = CLASS(name=u'at-name', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_name_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    at_name._val = dict([(u'Type', _at_name_val_Type), (u'id', (2, 5, 4, 41))])
    
    #-----< id-at-surname >-----#
    id_at_surname = OID(name=u'id-at-surname', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_surname._val = (2, 5, 4, 4)
    
    #-----< at-surname >-----#
    at_surname = CLASS(name=u'at-surname', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_surname_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    at_surname._val = dict([(u'Type', _at_surname_val_Type), (u'id', (2, 5, 4, 4))])
    
    #-----< id-at-givenName >-----#
    id_at_givenName = OID(name=u'id-at-givenName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_givenName._val = (2, 5, 4, 42)
    
    #-----< at-givenName >-----#
    at_givenName = CLASS(name=u'at-givenName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_givenName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    at_givenName._val = dict([(u'Type', _at_givenName_val_Type), (u'id', (2, 5, 4, 42))])
    
    #-----< id-at-initials >-----#
    id_at_initials = OID(name=u'id-at-initials', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_initials._val = (2, 5, 4, 43)
    
    #-----< at-initials >-----#
    at_initials = CLASS(name=u'at-initials', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_initials_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    at_initials._val = dict([(u'Type', _at_initials_val_Type), (u'id', (2, 5, 4, 43))])
    
    #-----< id-at-generationQualifier >-----#
    id_at_generationQualifier = OID(name=u'id-at-generationQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_generationQualifier._val = (2, 5, 4, 44)
    
    #-----< at-generationQualifier >-----#
    at_generationQualifier = CLASS(name=u'at-generationQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_generationQualifier_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    at_generationQualifier._val = dict([(u'Type', _at_generationQualifier_val_Type), (u'id', (2, 5, 4, 44))])
    
    #-----< DirectoryString >-----#
    DirectoryString = CHOICE(name=u'DirectoryString', mode=MODE_TYPE, param=True)
    
    #-----< X520name >-----#
    X520name = CHOICE(name=u'X520name', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520name_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520name_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520name_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520name_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520name_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _X520name_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520name_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    X520name._cont = ASN1Dict([
        (u'teletexString', _X520name_teletexString),
        (u'printableString', _X520name_printableString),
        (u'bmpString', _X520name_bmpString),
        (u'universalString', _X520name_universalString),
        (u'uTF8String', _X520name_uTF8String),
        ])
    X520name._ext = None
    
    #-----< id-at-commonName >-----#
    id_at_commonName = OID(name=u'id-at-commonName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_commonName._val = (2, 5, 4, 3)
    
    #-----< at-x520CommonName >-----#
    at_x520CommonName = CLASS(name=u'at-x520CommonName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520CommonName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520CommonName')))
    at_x520CommonName._val = dict([(u'Type', _at_x520CommonName_val_Type), (u'id', (2, 5, 4, 3))])
    
    #-----< X520CommonName >-----#
    X520CommonName = CHOICE(name=u'X520CommonName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520CommonName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520CommonName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520CommonName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520CommonName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520CommonName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520CommonName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520CommonName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520CommonName._cont = ASN1Dict([
        (u'teletexString', _X520CommonName_teletexString),
        (u'printableString', _X520CommonName_printableString),
        (u'bmpString', _X520CommonName_bmpString),
        (u'universalString', _X520CommonName_universalString),
        (u'uTF8String', _X520CommonName_uTF8String),
        ])
    X520CommonName._ext = None
    
    #-----< id-at-localityName >-----#
    id_at_localityName = OID(name=u'id-at-localityName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_localityName._val = (2, 5, 4, 7)
    
    #-----< at-x520LocalityName >-----#
    at_x520LocalityName = CLASS(name=u'at-x520LocalityName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520LocalityName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520LocalityName')))
    at_x520LocalityName._val = dict([(u'Type', _at_x520LocalityName_val_Type), (u'id', (2, 5, 4, 7))])
    
    #-----< X520LocalityName >-----#
    X520LocalityName = CHOICE(name=u'X520LocalityName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520LocalityName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520LocalityName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520LocalityName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520LocalityName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520LocalityName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520LocalityName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520LocalityName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    X520LocalityName._cont = ASN1Dict([
        (u'teletexString', _X520LocalityName_teletexString),
        (u'printableString', _X520LocalityName_printableString),
        (u'bmpString', _X520LocalityName_bmpString),
        (u'universalString', _X520LocalityName_universalString),
        (u'uTF8String', _X520LocalityName_uTF8String),
        ])
    X520LocalityName._ext = None
    
    #-----< id-at-stateOrProvinceName >-----#
    id_at_stateOrProvinceName = OID(name=u'id-at-stateOrProvinceName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_stateOrProvinceName._val = (2, 5, 4, 8)
    
    #-----< at-x520StateOrProvinceName >-----#
    at_x520StateOrProvinceName = CLASS(name=u'at-x520StateOrProvinceName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520StateOrProvinceName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __at_x520StateOrProvinceName_val_Type_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __at_x520StateOrProvinceName_val_Type_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520StateOrProvinceName_val_Type_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __at_x520StateOrProvinceName_val_Type_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520StateOrProvinceName_val_Type_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __at_x520StateOrProvinceName_val_Type_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520StateOrProvinceName_val_Type_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __at_x520StateOrProvinceName_val_Type_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520StateOrProvinceName_val_Type_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __at_x520StateOrProvinceName_val_Type_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _at_x520StateOrProvinceName_val_Type._cont = ASN1Dict([
        (u'teletexString', __at_x520StateOrProvinceName_val_Type_teletexString),
        (u'printableString', __at_x520StateOrProvinceName_val_Type_printableString),
        (u'bmpString', __at_x520StateOrProvinceName_val_Type_bmpString),
        (u'universalString', __at_x520StateOrProvinceName_val_Type_universalString),
        (u'uTF8String', __at_x520StateOrProvinceName_val_Type_uTF8String),
        ])
    _at_x520StateOrProvinceName_val_Type._ext = None
    at_x520StateOrProvinceName._val = dict([(u'Type', _at_x520StateOrProvinceName_val_Type), (u'id', (2, 5, 4, 8))])
    
    #-----< X520StateOrProvinceName >-----#
    X520StateOrProvinceName = CHOICE(name=u'X520StateOrProvinceName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520StateOrProvinceName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520StateOrProvinceName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520StateOrProvinceName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520StateOrProvinceName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520StateOrProvinceName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _X520StateOrProvinceName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520StateOrProvinceName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    X520StateOrProvinceName._cont = ASN1Dict([
        (u'teletexString', _X520StateOrProvinceName_teletexString),
        (u'printableString', _X520StateOrProvinceName_printableString),
        (u'bmpString', _X520StateOrProvinceName_bmpString),
        (u'universalString', _X520StateOrProvinceName_universalString),
        (u'uTF8String', _X520StateOrProvinceName_uTF8String),
        ])
    X520StateOrProvinceName._ext = None
    
    #-----< id-at-organizationName >-----#
    id_at_organizationName = OID(name=u'id-at-organizationName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_organizationName._val = (2, 5, 4, 10)
    
    #-----< at-x520OrganizationName >-----#
    at_x520OrganizationName = CLASS(name=u'at-x520OrganizationName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520OrganizationName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __at_x520OrganizationName_val_Type_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __at_x520OrganizationName_val_Type_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationName_val_Type_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __at_x520OrganizationName_val_Type_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationName_val_Type_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __at_x520OrganizationName_val_Type_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationName_val_Type_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __at_x520OrganizationName_val_Type_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationName_val_Type_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __at_x520OrganizationName_val_Type_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _at_x520OrganizationName_val_Type._cont = ASN1Dict([
        (u'teletexString', __at_x520OrganizationName_val_Type_teletexString),
        (u'printableString', __at_x520OrganizationName_val_Type_printableString),
        (u'bmpString', __at_x520OrganizationName_val_Type_bmpString),
        (u'universalString', __at_x520OrganizationName_val_Type_universalString),
        (u'uTF8String', __at_x520OrganizationName_val_Type_uTF8String),
        ])
    _at_x520OrganizationName_val_Type._ext = None
    at_x520OrganizationName._val = dict([(u'Type', _at_x520OrganizationName_val_Type), (u'id', (2, 5, 4, 10))])
    
    #-----< X520OrganizationName >-----#
    X520OrganizationName = CHOICE(name=u'X520OrganizationName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520OrganizationName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520OrganizationName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520OrganizationName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520OrganizationName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520OrganizationName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520OrganizationName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520OrganizationName._cont = ASN1Dict([
        (u'teletexString', _X520OrganizationName_teletexString),
        (u'printableString', _X520OrganizationName_printableString),
        (u'bmpString', _X520OrganizationName_bmpString),
        (u'universalString', _X520OrganizationName_universalString),
        (u'uTF8String', _X520OrganizationName_uTF8String),
        ])
    X520OrganizationName._ext = None
    
    #-----< id-at-organizationalUnitName >-----#
    id_at_organizationalUnitName = OID(name=u'id-at-organizationalUnitName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_organizationalUnitName._val = (2, 5, 4, 11)
    
    #-----< at-x520OrganizationalUnitName >-----#
    at_x520OrganizationalUnitName = CLASS(name=u'at-x520OrganizationalUnitName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520OrganizationalUnitName_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __at_x520OrganizationalUnitName_val_Type_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __at_x520OrganizationalUnitName_val_Type_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationalUnitName_val_Type_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __at_x520OrganizationalUnitName_val_Type_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationalUnitName_val_Type_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __at_x520OrganizationalUnitName_val_Type_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationalUnitName_val_Type_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __at_x520OrganizationalUnitName_val_Type_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520OrganizationalUnitName_val_Type_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __at_x520OrganizationalUnitName_val_Type_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _at_x520OrganizationalUnitName_val_Type._cont = ASN1Dict([
        (u'teletexString', __at_x520OrganizationalUnitName_val_Type_teletexString),
        (u'printableString', __at_x520OrganizationalUnitName_val_Type_printableString),
        (u'bmpString', __at_x520OrganizationalUnitName_val_Type_bmpString),
        (u'universalString', __at_x520OrganizationalUnitName_val_Type_universalString),
        (u'uTF8String', __at_x520OrganizationalUnitName_val_Type_uTF8String),
        ])
    _at_x520OrganizationalUnitName_val_Type._ext = None
    at_x520OrganizationalUnitName._val = dict([(u'Type', _at_x520OrganizationalUnitName_val_Type), (u'id', (2, 5, 4, 11))])
    
    #-----< X520OrganizationalUnitName >-----#
    X520OrganizationalUnitName = CHOICE(name=u'X520OrganizationalUnitName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _X520OrganizationalUnitName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _X520OrganizationalUnitName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _X520OrganizationalUnitName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _X520OrganizationalUnitName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    X520OrganizationalUnitName._cont = ASN1Dict([
        (u'teletexString', _X520OrganizationalUnitName_teletexString),
        (u'printableString', _X520OrganizationalUnitName_printableString),
        (u'bmpString', _X520OrganizationalUnitName_bmpString),
        (u'universalString', _X520OrganizationalUnitName_universalString),
        (u'uTF8String', _X520OrganizationalUnitName_uTF8String),
        ])
    X520OrganizationalUnitName._ext = None
    
    #-----< id-at-title >-----#
    id_at_title = OID(name=u'id-at-title', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_title._val = (2, 5, 4, 12)
    
    #-----< at-x520Title >-----#
    at_x520Title = CLASS(name=u'at-x520Title', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520Title_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __at_x520Title_val_Type_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __at_x520Title_val_Type_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520Title_val_Type_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __at_x520Title_val_Type_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520Title_val_Type_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __at_x520Title_val_Type_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520Title_val_Type_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __at_x520Title_val_Type_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __at_x520Title_val_Type_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __at_x520Title_val_Type_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _at_x520Title_val_Type._cont = ASN1Dict([
        (u'teletexString', __at_x520Title_val_Type_teletexString),
        (u'printableString', __at_x520Title_val_Type_printableString),
        (u'bmpString', __at_x520Title_val_Type_bmpString),
        (u'universalString', __at_x520Title_val_Type_universalString),
        (u'uTF8String', __at_x520Title_val_Type_uTF8String),
        ])
    _at_x520Title_val_Type._ext = None
    at_x520Title._val = dict([(u'Type', _at_x520Title_val_Type), (u'id', (2, 5, 4, 12))])
    
    #-----< id-at-dnQualifier >-----#
    id_at_dnQualifier = OID(name=u'id-at-dnQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_dnQualifier._val = (2, 5, 4, 46)
    
    #-----< at-x520dnQualifier >-----#
    at_x520dnQualifier = CLASS(name=u'at-x520dnQualifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520dnQualifier_val_Type = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    at_x520dnQualifier._val = dict([(u'Type', _at_x520dnQualifier_val_Type), (u'id', (2, 5, 4, 46))])
    
    #-----< id-at-countryName >-----#
    id_at_countryName = OID(name=u'id-at-countryName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_countryName._val = (2, 5, 4, 6)
    
    #-----< at-x520countryName >-----#
    at_x520countryName = CLASS(name=u'at-x520countryName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520countryName_val_Type = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _at_x520countryName_val_Type._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    at_x520countryName._val = dict([(u'Type', _at_x520countryName_val_Type), (u'id', (2, 5, 4, 6))])
    
    #-----< id-at-serialNumber >-----#
    id_at_serialNumber = OID(name=u'id-at-serialNumber', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_serialNumber._val = (2, 5, 4, 5)
    
    #-----< at-x520SerialNumber >-----#
    at_x520SerialNumber = CLASS(name=u'at-x520SerialNumber', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520SerialNumber_val_Type = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _at_x520SerialNumber_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    at_x520SerialNumber._val = dict([(u'Type', _at_x520SerialNumber_val_Type), (u'id', (2, 5, 4, 5))])
    
    #-----< id-at-pseudonym >-----#
    id_at_pseudonym = OID(name=u'id-at-pseudonym', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_at_pseudonym._val = (2, 5, 4, 65)
    
    #-----< at-x520Pseudonym >-----#
    at_x520Pseudonym = CLASS(name=u'at-x520Pseudonym', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_x520Pseudonym_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __at_x520Pseudonym_val_Type_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __at_x520Pseudonym_val_Type_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520Pseudonym_val_Type_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __at_x520Pseudonym_val_Type_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520Pseudonym_val_Type_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __at_x520Pseudonym_val_Type_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520Pseudonym_val_Type_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __at_x520Pseudonym_val_Type_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __at_x520Pseudonym_val_Type_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __at_x520Pseudonym_val_Type_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _at_x520Pseudonym_val_Type._cont = ASN1Dict([
        (u'teletexString', __at_x520Pseudonym_val_Type_teletexString),
        (u'printableString', __at_x520Pseudonym_val_Type_printableString),
        (u'bmpString', __at_x520Pseudonym_val_Type_bmpString),
        (u'universalString', __at_x520Pseudonym_val_Type_universalString),
        (u'uTF8String', __at_x520Pseudonym_val_Type_uTF8String),
        ])
    _at_x520Pseudonym_val_Type._ext = None
    at_x520Pseudonym._val = dict([(u'Type', _at_x520Pseudonym_val_Type), (u'id', (2, 5, 4, 65))])
    
    #-----< id-domainComponent >-----#
    id_domainComponent = OID(name=u'id-domainComponent', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_domainComponent._val = (0, 9, 2342, 19200300, 100, 1, 25)
    
    #-----< at-domainComponent >-----#
    at_domainComponent = CLASS(name=u'at-domainComponent', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_domainComponent_val_Type = STR_IA5(name=u'Type', mode=MODE_TYPE)
    at_domainComponent._val = dict([(u'Type', _at_domainComponent_val_Type), (u'id', (0, 9, 2342, 19200300, 100, 1, 25))])
    
    #-----< pkcs-9 >-----#
    pkcs_9 = OID(name=u'pkcs-9', mode=MODE_VALUE)
    pkcs_9._val = (1, 2, 840, 113549, 1, 9)
    
    #-----< id-emailAddress >-----#
    id_emailAddress = OID(name=u'id-emailAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'AttributeType')))
    id_emailAddress._val = (1, 2, 840, 113549, 1, 9, 1)
    
    #-----< at-emailAddress >-----#
    at_emailAddress = CLASS(name=u'at-emailAddress', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_emailAddress_val_Type = STR_IA5(name=u'Type', mode=MODE_TYPE)
    _at_emailAddress_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    at_emailAddress._val = dict([(u'Type', _at_emailAddress_val_Type), (u'id', (1, 2, 840, 113549, 1, 9, 1))])
    
    #-----< Name >-----#
    Name = CHOICE(name=u'Name', mode=MODE_TYPE)
    _Name_rdnSequence = SEQ_OF(name=u'rdnSequence', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'RDNSequence')))
    Name._cont = ASN1Dict([
        (u'rdnSequence', _Name_rdnSequence),
        ])
    Name._ext = None
    
    #-----< RDNSequence >-----#
    RDNSequence = SEQ_OF(name=u'RDNSequence', mode=MODE_TYPE)
    _RDNSequence__item_ = SET_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'RelativeDistinguishedName')))
    RDNSequence._cont = _RDNSequence__item_
    
    #-----< DistinguishedName >-----#
    DistinguishedName = SEQ_OF(name=u'DistinguishedName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'RDNSequence')))
    
    #-----< RelativeDistinguishedName >-----#
    RelativeDistinguishedName = SET_OF(name=u'RelativeDistinguishedName', mode=MODE_TYPE)
    _RelativeDistinguishedName__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SingleAttribute')))
    __RelativeDistinguishedName__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___RelativeDistinguishedName__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_1 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_2 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_3 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_4 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_5 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520CommonName')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_6 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520LocalityName')))
    ____RelativeDistinguishedName__item__type_tab_val_Type_7 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_7_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_7._cont = ASN1Dict([
        (u'teletexString', _____RelativeDistinguishedName__item__type_tab_val_Type_7_teletexString),
        (u'printableString', _____RelativeDistinguishedName__item__type_tab_val_Type_7_printableString),
        (u'bmpString', _____RelativeDistinguishedName__item__type_tab_val_Type_7_bmpString),
        (u'universalString', _____RelativeDistinguishedName__item__type_tab_val_Type_7_universalString),
        (u'uTF8String', _____RelativeDistinguishedName__item__type_tab_val_Type_7_uTF8String),
        ])
    ____RelativeDistinguishedName__item__type_tab_val_Type_7._ext = None
    ____RelativeDistinguishedName__item__type_tab_val_Type_8 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_8_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_8._cont = ASN1Dict([
        (u'teletexString', _____RelativeDistinguishedName__item__type_tab_val_Type_8_teletexString),
        (u'printableString', _____RelativeDistinguishedName__item__type_tab_val_Type_8_printableString),
        (u'bmpString', _____RelativeDistinguishedName__item__type_tab_val_Type_8_bmpString),
        (u'universalString', _____RelativeDistinguishedName__item__type_tab_val_Type_8_universalString),
        (u'uTF8String', _____RelativeDistinguishedName__item__type_tab_val_Type_8_uTF8String),
        ])
    ____RelativeDistinguishedName__item__type_tab_val_Type_8._ext = None
    ____RelativeDistinguishedName__item__type_tab_val_Type_9 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_9_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_9._cont = ASN1Dict([
        (u'teletexString', _____RelativeDistinguishedName__item__type_tab_val_Type_9_teletexString),
        (u'printableString', _____RelativeDistinguishedName__item__type_tab_val_Type_9_printableString),
        (u'bmpString', _____RelativeDistinguishedName__item__type_tab_val_Type_9_bmpString),
        (u'universalString', _____RelativeDistinguishedName__item__type_tab_val_Type_9_universalString),
        (u'uTF8String', _____RelativeDistinguishedName__item__type_tab_val_Type_9_uTF8String),
        ])
    ____RelativeDistinguishedName__item__type_tab_val_Type_9._ext = None
    ____RelativeDistinguishedName__item__type_tab_val_Type_10 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_10_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_10._cont = ASN1Dict([
        (u'teletexString', _____RelativeDistinguishedName__item__type_tab_val_Type_10_teletexString),
        (u'printableString', _____RelativeDistinguishedName__item__type_tab_val_Type_10_printableString),
        (u'bmpString', _____RelativeDistinguishedName__item__type_tab_val_Type_10_bmpString),
        (u'universalString', _____RelativeDistinguishedName__item__type_tab_val_Type_10_universalString),
        (u'uTF8String', _____RelativeDistinguishedName__item__type_tab_val_Type_10_uTF8String),
        ])
    ____RelativeDistinguishedName__item__type_tab_val_Type_10._ext = None
    ____RelativeDistinguishedName__item__type_tab_val_Type_11 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____RelativeDistinguishedName__item__type_tab_val_Type_12 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____RelativeDistinguishedName__item__type_tab_val_Type_12._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_13 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____RelativeDistinguishedName__item__type_tab_val_Type_13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_14 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____RelativeDistinguishedName__item__type_tab_val_Type_14_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    ____RelativeDistinguishedName__item__type_tab_val_Type_14._cont = ASN1Dict([
        (u'teletexString', _____RelativeDistinguishedName__item__type_tab_val_Type_14_teletexString),
        (u'printableString', _____RelativeDistinguishedName__item__type_tab_val_Type_14_printableString),
        (u'bmpString', _____RelativeDistinguishedName__item__type_tab_val_Type_14_bmpString),
        (u'universalString', _____RelativeDistinguishedName__item__type_tab_val_Type_14_universalString),
        (u'uTF8String', _____RelativeDistinguishedName__item__type_tab_val_Type_14_uTF8String),
        ])
    ____RelativeDistinguishedName__item__type_tab_val_Type_14._ext = None
    ____RelativeDistinguishedName__item__type_tab_val_Type_15 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    ____RelativeDistinguishedName__item__type_tab_val_Type_16 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    ____RelativeDistinguishedName__item__type_tab_val_Type_16._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    ___RelativeDistinguishedName__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_0), (u'id', (2, 5, 4, 41))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_1), (u'id', (2, 5, 4, 4))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_2), (u'id', (2, 5, 4, 42))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_3), (u'id', (2, 5, 4, 43))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_4), (u'id', (2, 5, 4, 44))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_5), (u'id', (2, 5, 4, 3))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_6), (u'id', (2, 5, 4, 7))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_7), (u'id', (2, 5, 4, 8))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_8), (u'id', (2, 5, 4, 10))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_9), (u'id', (2, 5, 4, 11))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_10), (u'id', (2, 5, 4, 12))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_11), (u'id', (2, 5, 4, 46))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_12), (u'id', (2, 5, 4, 6))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_13), (u'id', (2, 5, 4, 5))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_14), (u'id', (2, 5, 4, 65))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_15), (u'id', (0, 9, 2342, 19200300, 100, 1, 25))]), dict([(u'Type', ____RelativeDistinguishedName__item__type_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 9, 1))])], rr=[], ev=None, er=[])
    __RelativeDistinguishedName__item__type._const_tab = ___RelativeDistinguishedName__item__type_tab
    __RelativeDistinguishedName__item__type._const_tab_at = None
    __RelativeDistinguishedName__item__type._const_tab_id = u'id'
    __RelativeDistinguishedName__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    __RelativeDistinguishedName__item__value._const_tab = ___RelativeDistinguishedName__item__type_tab
    __RelativeDistinguishedName__item__value._const_tab_at = ('..', u'type')
    __RelativeDistinguishedName__item__value._const_tab_id = u'Type'
    _RelativeDistinguishedName__item_._cont = ASN1Dict([
        (u'type', __RelativeDistinguishedName__item__type),
        (u'value', __RelativeDistinguishedName__item__value),
        ])
    _RelativeDistinguishedName__item_._ext = None
    RelativeDistinguishedName._cont = _RelativeDistinguishedName__item_
    RelativeDistinguishedName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< SupportedAttributes >-----#
    SupportedAttributes = CLASS(name=u'SupportedAttributes', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _SupportedAttributes_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    _SupportedAttributes_val_Type_1 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    _SupportedAttributes_val_Type_2 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    _SupportedAttributes_val_Type_3 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    _SupportedAttributes_val_Type_4 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    _SupportedAttributes_val_Type_5 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520CommonName')))
    _SupportedAttributes_val_Type_6 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520LocalityName')))
    _SupportedAttributes_val_Type_7 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __SupportedAttributes_val_Type_7_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_7_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_7_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_7_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_7_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_7_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_7_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_7_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_7_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_7_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _SupportedAttributes_val_Type_7._cont = ASN1Dict([
        (u'teletexString', __SupportedAttributes_val_Type_7_teletexString),
        (u'printableString', __SupportedAttributes_val_Type_7_printableString),
        (u'bmpString', __SupportedAttributes_val_Type_7_bmpString),
        (u'universalString', __SupportedAttributes_val_Type_7_universalString),
        (u'uTF8String', __SupportedAttributes_val_Type_7_uTF8String),
        ])
    _SupportedAttributes_val_Type_7._ext = None
    _SupportedAttributes_val_Type_8 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __SupportedAttributes_val_Type_8_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_8_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_8_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_8_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_8_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_8_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_8_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_8_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_8_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_8_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedAttributes_val_Type_8._cont = ASN1Dict([
        (u'teletexString', __SupportedAttributes_val_Type_8_teletexString),
        (u'printableString', __SupportedAttributes_val_Type_8_printableString),
        (u'bmpString', __SupportedAttributes_val_Type_8_bmpString),
        (u'universalString', __SupportedAttributes_val_Type_8_universalString),
        (u'uTF8String', __SupportedAttributes_val_Type_8_uTF8String),
        ])
    _SupportedAttributes_val_Type_8._ext = None
    _SupportedAttributes_val_Type_9 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __SupportedAttributes_val_Type_9_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_9_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_9_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_9_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_9_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_9_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_9_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_9_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_9_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_9_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedAttributes_val_Type_9._cont = ASN1Dict([
        (u'teletexString', __SupportedAttributes_val_Type_9_teletexString),
        (u'printableString', __SupportedAttributes_val_Type_9_printableString),
        (u'bmpString', __SupportedAttributes_val_Type_9_bmpString),
        (u'universalString', __SupportedAttributes_val_Type_9_universalString),
        (u'uTF8String', __SupportedAttributes_val_Type_9_uTF8String),
        ])
    _SupportedAttributes_val_Type_9._ext = None
    _SupportedAttributes_val_Type_10 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __SupportedAttributes_val_Type_10_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_10_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_10_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_10_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_10_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_10_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_10_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_10_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    __SupportedAttributes_val_Type_10_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_10_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedAttributes_val_Type_10._cont = ASN1Dict([
        (u'teletexString', __SupportedAttributes_val_Type_10_teletexString),
        (u'printableString', __SupportedAttributes_val_Type_10_printableString),
        (u'bmpString', __SupportedAttributes_val_Type_10_bmpString),
        (u'universalString', __SupportedAttributes_val_Type_10_universalString),
        (u'uTF8String', __SupportedAttributes_val_Type_10_uTF8String),
        ])
    _SupportedAttributes_val_Type_10._ext = None
    _SupportedAttributes_val_Type_11 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _SupportedAttributes_val_Type_12 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _SupportedAttributes_val_Type_12._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    _SupportedAttributes_val_Type_13 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    _SupportedAttributes_val_Type_13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _SupportedAttributes_val_Type_14 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __SupportedAttributes_val_Type_14_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_14_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_14_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_14_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_14_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_14_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_14_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_14_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    __SupportedAttributes_val_Type_14_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SupportedAttributes_val_Type_14_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _SupportedAttributes_val_Type_14._cont = ASN1Dict([
        (u'teletexString', __SupportedAttributes_val_Type_14_teletexString),
        (u'printableString', __SupportedAttributes_val_Type_14_printableString),
        (u'bmpString', __SupportedAttributes_val_Type_14_bmpString),
        (u'universalString', __SupportedAttributes_val_Type_14_universalString),
        (u'uTF8String', __SupportedAttributes_val_Type_14_uTF8String),
        ])
    _SupportedAttributes_val_Type_14._ext = None
    _SupportedAttributes_val_Type_15 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    _SupportedAttributes_val_Type_16 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    _SupportedAttributes_val_Type_16._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    SupportedAttributes._val = ASN1Set(rv=[dict([(u'Type', _SupportedAttributes_val_Type_0), (u'id', (2, 5, 4, 41))]), dict([(u'Type', _SupportedAttributes_val_Type_1), (u'id', (2, 5, 4, 4))]), dict([(u'Type', _SupportedAttributes_val_Type_2), (u'id', (2, 5, 4, 42))]), dict([(u'Type', _SupportedAttributes_val_Type_3), (u'id', (2, 5, 4, 43))]), dict([(u'Type', _SupportedAttributes_val_Type_4), (u'id', (2, 5, 4, 44))]), dict([(u'Type', _SupportedAttributes_val_Type_5), (u'id', (2, 5, 4, 3))]), dict([(u'Type', _SupportedAttributes_val_Type_6), (u'id', (2, 5, 4, 7))]), dict([(u'Type', _SupportedAttributes_val_Type_7), (u'id', (2, 5, 4, 8))]), dict([(u'Type', _SupportedAttributes_val_Type_8), (u'id', (2, 5, 4, 10))]), dict([(u'Type', _SupportedAttributes_val_Type_9), (u'id', (2, 5, 4, 11))]), dict([(u'Type', _SupportedAttributes_val_Type_10), (u'id', (2, 5, 4, 12))]), dict([(u'Type', _SupportedAttributes_val_Type_11), (u'id', (2, 5, 4, 46))]), dict([(u'Type', _SupportedAttributes_val_Type_12), (u'id', (2, 5, 4, 6))]), dict([(u'Type', _SupportedAttributes_val_Type_13), (u'id', (2, 5, 4, 5))]), dict([(u'Type', _SupportedAttributes_val_Type_14), (u'id', (2, 5, 4, 65))]), dict([(u'Type', _SupportedAttributes_val_Type_15), (u'id', (0, 9, 2342, 19200300, 100, 1, 25))]), dict([(u'Type', _SupportedAttributes_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 9, 1))])], rr=[], ev=[], er=[])
    
    #-----< Certificate >-----#
    Certificate = SEQ(name=u'Certificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'SIGNED')))
    _Certificate_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'TBSCertificate')))
    _Certificate_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE)
    __Certificate_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___Certificate_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    __SIGNATURE_ALGORITHM_HashSet_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___Certificate_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_3), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_4), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_5), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_6), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_7), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_8), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_9), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_10), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __Certificate_algorithmIdentifier_algorithm._const_tab = ___Certificate_algorithmIdentifier_algorithm_tab
    __Certificate_algorithmIdentifier_algorithm._const_tab_at = None
    __Certificate_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __Certificate_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __Certificate_algorithmIdentifier_parameters._const_tab = ___Certificate_algorithmIdentifier_algorithm_tab
    __Certificate_algorithmIdentifier_parameters._const_tab_at = ('..', '..', u'algorithmIdentifier', u'algorithm')
    __Certificate_algorithmIdentifier_parameters._const_tab_id = u'Params'
    _Certificate_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __Certificate_algorithmIdentifier_algorithm),
        (u'parameters', __Certificate_algorithmIdentifier_parameters),
        ])
    _Certificate_algorithmIdentifier._ext = None
    _Certificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    __Certificate_signature_contain = OPEN(name='_cont_signature', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Value']))
    __Certificate_signature_contain._const_tab = ___Certificate_algorithmIdentifier_algorithm_tab
    __Certificate_signature_contain._const_tab_at = ('..', u'algorithmIdentifier', u'algorithm')
    __Certificate_signature_contain._const_tab_id = u'Value'
    _Certificate_signature._const_cont = __Certificate_signature_contain
    Certificate._cont = ASN1Dict([
        (u'toBeSigned', _Certificate_toBeSigned),
        (u'algorithmIdentifier', _Certificate_algorithmIdentifier),
        (u'signature', _Certificate_signature),
        ])
    Certificate._ext = None
    
    #-----< TBSCertificate >-----#
    TBSCertificate = SEQ(name=u'TBSCertificate', mode=MODE_TYPE)
    _TBSCertificate_version = INT(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'Version')), default=0)
    _TBSCertificate_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    _TBSCertificate_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __TBSCertificate_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___TBSCertificate_signature_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertificate_signature_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertificate_signature_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___TBSCertificate_signature_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_3), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_4), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_5), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_6), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_7), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_8), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_9), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____TBSCertificate_signature_algorithm_tab_val_Value_10), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____TBSCertificate_signature_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __TBSCertificate_signature_algorithm._const_tab = ___TBSCertificate_signature_algorithm_tab
    __TBSCertificate_signature_algorithm._const_tab_at = None
    __TBSCertificate_signature_algorithm._const_tab_id = u'id'
    __TBSCertificate_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __TBSCertificate_signature_parameters._const_tab = ___TBSCertificate_signature_algorithm_tab
    __TBSCertificate_signature_parameters._const_tab_at = ('..', u'algorithm')
    __TBSCertificate_signature_parameters._const_tab_id = u'Params'
    _TBSCertificate_signature._cont = ASN1Dict([
        (u'algorithm', __TBSCertificate_signature_algorithm),
        (u'parameters', __TBSCertificate_signature_parameters),
        ])
    _TBSCertificate_signature._ext = None
    _TBSCertificate_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _TBSCertificate_validity = SEQ(name=u'validity', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Validity')))
    _TBSCertificate_subject = CHOICE(name=u'subject', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _TBSCertificate_subjectPublicKeyInfo = SEQ(name=u'subjectPublicKeyInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'SubjectPublicKeyInfo')))
    _TBSCertificate_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'UniqueIdentifier')), opt=True, group=0)
    _TBSCertificate_subjectUniqueID = BIT_STR(name=u'subjectUniqueID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'UniqueIdentifier')), opt=True, group=0)
    _TBSCertificate_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True, group=1)
    __TBSCertificate_extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___TBSCertificate_extensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____TBSCertificate_extensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_1 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_2 = BIT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyUsage')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_3 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PrivateKeyUsagePeriod')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_4 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertificatePolicies')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_5 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyMappings')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_6 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_7 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_8 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectDirectoryAttributes')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_9 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'BasicConstraints')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_10 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'NameConstraints')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_11 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyConstraints')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_12 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'ExtKeyUsageSyntax')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_13 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_14 = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_15 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_16 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_17 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectInfoAccessSyntax')))
    ____TBSCertificate_extensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_0), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_1), (u'id', (2, 5, 29, 14))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 15))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_3), (u'id', (2, 5, 29, 16))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_4), (u'id', (2, 5, 29, 32))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_5), (u'id', (2, 5, 29, 33))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_6), (u'id', (2, 5, 29, 17))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_7), (u'id', (2, 5, 29, 18))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_8), (u'id', (2, 5, 29, 9))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_9), (u'id', (2, 5, 29, 19))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_10), (u'id', (2, 5, 29, 30))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_11), (u'id', (2, 5, 29, 36))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_12), (u'id', (2, 5, 29, 37))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_13), (u'id', (2, 5, 29, 31))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_14), (u'id', (2, 5, 29, 54))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_15), (u'id', (2, 5, 29, 46))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_16), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))]), dict([(u'ExtnType', _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_17), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 11))])], rr=[], ev=None, er=[])
    ___TBSCertificate_extensions__item__extnID._const_tab = ____TBSCertificate_extensions__item__extnID_tab
    ___TBSCertificate_extensions__item__extnID._const_tab_at = None
    ___TBSCertificate_extensions__item__extnID._const_tab_id = u'id'
    ___TBSCertificate_extensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___TBSCertificate_extensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____TBSCertificate_extensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____TBSCertificate_extensions__item__extnValue_contain._const_tab = ____TBSCertificate_extensions__item__extnID_tab
    ____TBSCertificate_extensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____TBSCertificate_extensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___TBSCertificate_extensions__item__extnValue._const_cont = ____TBSCertificate_extensions__item__extnValue_contain
    __TBSCertificate_extensions__item_._cont = ASN1Dict([
        (u'extnID', ___TBSCertificate_extensions__item__extnID),
        (u'critical', ___TBSCertificate_extensions__item__critical),
        (u'extnValue', ___TBSCertificate_extensions__item__extnValue),
        ])
    __TBSCertificate_extensions__item_._ext = None
    _TBSCertificate_extensions._cont = __TBSCertificate_extensions__item_
    _TBSCertificate_extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    TBSCertificate._cont = ASN1Dict([
        (u'version', _TBSCertificate_version),
        (u'serialNumber', _TBSCertificate_serialNumber),
        (u'signature', _TBSCertificate_signature),
        (u'issuer', _TBSCertificate_issuer),
        (u'validity', _TBSCertificate_validity),
        (u'subject', _TBSCertificate_subject),
        (u'subjectPublicKeyInfo', _TBSCertificate_subjectPublicKeyInfo),
        (u'issuerUniqueID', _TBSCertificate_issuerUniqueID),
        (u'subjectUniqueID', _TBSCertificate_subjectUniqueID),
        (u'extensions', _TBSCertificate_extensions),
        ])
    TBSCertificate._ext = [u'issuerUniqueID', u'subjectUniqueID', u'extensions']
    
    #-----< Version >-----#
    Version = INT(name=u'Version', mode=MODE_TYPE)
    Version._cont = ASN1Dict([(u'v1', 0), (u'v2', 1), (u'v3', 2)])
    
    #-----< CertificateSerialNumber >-----#
    CertificateSerialNumber = INT(name=u'CertificateSerialNumber', mode=MODE_TYPE)
    
    #-----< Validity >-----#
    Validity = SEQ(name=u'Validity', mode=MODE_TYPE)
    _Validity_notBefore = CHOICE(name=u'notBefore', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Time')))
    _Validity_notAfter = CHOICE(name=u'notAfter', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Time')))
    Validity._cont = ASN1Dict([
        (u'notBefore', _Validity_notBefore),
        (u'notAfter', _Validity_notAfter),
        ])
    Validity._ext = None
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalTime = TIME_GEN(name=u'generalTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalTime', _Time_generalTime),
        ])
    Time._ext = None
    
    #-----< UniqueIdentifier >-----#
    UniqueIdentifier = BIT_STR(name=u'UniqueIdentifier', mode=MODE_TYPE)
    
    #-----< SubjectPublicKeyInfo >-----#
    SubjectPublicKeyInfo = SEQ(name=u'SubjectPublicKeyInfo', mode=MODE_TYPE)
    _SubjectPublicKeyInfo_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __SubjectPublicKeyInfo_algorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'id']))
    ___SubjectPublicKeyInfo_algorithm_algorithm_tab = CLASS(name='_tab_PUBLIC-KEY', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_1 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_2 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_2 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_3 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'KEA-Params-Id')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_4 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_4 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_5 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_5 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_6 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_6 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_7 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_7 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_8 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_8 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    ___SubjectPublicKeyInfo_algorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_0), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_1), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_2), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_2), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))]), dict([(u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22)), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_3), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])], rr=[], ev=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_4), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_4), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))]), dict([(u'id', (1, 3, 132, 1, 12)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_5), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_5), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 3, 132, 1, 13)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_6), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_6), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_7), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_7), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_8), (u'Params', ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_8), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], er=[])
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab = ___SubjectPublicKeyInfo_algorithm_algorithm_tab
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab_at = None
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab_id = u'id'
    __SubjectPublicKeyInfo_algorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'PUBLIC-KEY'), [u'Params']), opt=True)
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab = ___SubjectPublicKeyInfo_algorithm_algorithm_tab
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab_at = ('..', u'algorithm')
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab_id = u'Params'
    _SubjectPublicKeyInfo_algorithm._cont = ASN1Dict([
        (u'algorithm', __SubjectPublicKeyInfo_algorithm_algorithm),
        (u'parameters', __SubjectPublicKeyInfo_algorithm_parameters),
        ])
    _SubjectPublicKeyInfo_algorithm._ext = None
    _SubjectPublicKeyInfo_subjectPublicKey = BIT_STR(name=u'subjectPublicKey', mode=MODE_TYPE)
    SubjectPublicKeyInfo._cont = ASN1Dict([
        (u'algorithm', _SubjectPublicKeyInfo_algorithm),
        (u'subjectPublicKey', _SubjectPublicKeyInfo_subjectPublicKey),
        ])
    SubjectPublicKeyInfo._ext = None
    
    #-----< CertificateList >-----#
    CertificateList = SEQ(name=u'CertificateList', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'SIGNED')))
    _CertificateList_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'TBSCertList')))
    _CertificateList_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE)
    __CertificateList_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___CertificateList_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___CertificateList_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_3), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_4), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_5), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_6), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_7), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_8), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_9), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_10), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __CertificateList_algorithmIdentifier_algorithm._const_tab = ___CertificateList_algorithmIdentifier_algorithm_tab
    __CertificateList_algorithmIdentifier_algorithm._const_tab_at = None
    __CertificateList_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __CertificateList_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __CertificateList_algorithmIdentifier_parameters._const_tab = ___CertificateList_algorithmIdentifier_algorithm_tab
    __CertificateList_algorithmIdentifier_parameters._const_tab_at = ('..', '..', u'algorithmIdentifier', u'algorithm')
    __CertificateList_algorithmIdentifier_parameters._const_tab_id = u'Params'
    _CertificateList_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __CertificateList_algorithmIdentifier_algorithm),
        (u'parameters', __CertificateList_algorithmIdentifier_parameters),
        ])
    _CertificateList_algorithmIdentifier._ext = None
    _CertificateList_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    __CertificateList_signature_contain = OPEN(name='_cont_signature', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Value']))
    __CertificateList_signature_contain._const_tab = ___CertificateList_algorithmIdentifier_algorithm_tab
    __CertificateList_signature_contain._const_tab_at = ('..', u'algorithmIdentifier', u'algorithm')
    __CertificateList_signature_contain._const_tab_id = u'Value'
    _CertificateList_signature._const_cont = __CertificateList_signature_contain
    CertificateList._cont = ASN1Dict([
        (u'toBeSigned', _CertificateList_toBeSigned),
        (u'algorithmIdentifier', _CertificateList_algorithmIdentifier),
        (u'signature', _CertificateList_signature),
        ])
    CertificateList._ext = None
    
    #-----< TBSCertList >-----#
    TBSCertList = SEQ(name=u'TBSCertList', mode=MODE_TYPE)
    _TBSCertList_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Version')), opt=True)
    _TBSCertList_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __TBSCertList_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___TBSCertList_signature_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____TBSCertList_signature_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____TBSCertList_signature_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____TBSCertList_signature_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___TBSCertList_signature_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_3), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_4), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_5), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_6), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_7), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_8), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_9), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____TBSCertList_signature_algorithm_tab_val_Value_10), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____TBSCertList_signature_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __TBSCertList_signature_algorithm._const_tab = ___TBSCertList_signature_algorithm_tab
    __TBSCertList_signature_algorithm._const_tab_at = None
    __TBSCertList_signature_algorithm._const_tab_id = u'id'
    __TBSCertList_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __TBSCertList_signature_parameters._const_tab = ___TBSCertList_signature_algorithm_tab
    __TBSCertList_signature_parameters._const_tab_at = ('..', u'algorithm')
    __TBSCertList_signature_parameters._const_tab_id = u'Params'
    _TBSCertList_signature._cont = ASN1Dict([
        (u'algorithm', __TBSCertList_signature_algorithm),
        (u'parameters', __TBSCertList_signature_parameters),
        ])
    _TBSCertList_signature._ext = None
    _TBSCertList_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _TBSCertList_thisUpdate = CHOICE(name=u'thisUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Time')))
    _TBSCertList_nextUpdate = CHOICE(name=u'nextUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Time')), opt=True)
    _TBSCertList_revokedCertificates = SEQ_OF(name=u'revokedCertificates', mode=MODE_TYPE, opt=True)
    __TBSCertList_revokedCertificates__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ___TBSCertList_revokedCertificates__item__userCertificate = INT(name=u'userCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    ___TBSCertList_revokedCertificates__item__revocationDate = CHOICE(name=u'revocationDate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Time')))
    ___TBSCertList_revokedCertificates__item__crlEntryExtensions = SEQ_OF(name=u'crlEntryExtensions', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True, group=0)
    ____TBSCertList_revokedCertificates__item__crlEntryExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_0 = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLReason')))
    _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_2 = OID(name=u'ExtnType', mode=MODE_TYPE)
    _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_3 = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_0), (u'id', (2, 5, 29, 21))]), dict([(u'ExtnType', _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_1), (u'id', (2, 5, 29, 29))]), dict([(u'ExtnType', _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 23))]), dict([(u'ExtnType', _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_3), (u'id', (2, 5, 29, 24))])], rr=[], ev=None, er=[])
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID._const_tab = ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID._const_tab_at = None
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID._const_tab_id = u'id'
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain._const_tab = ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue._const_cont = ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain
    ____TBSCertList_revokedCertificates__item__crlEntryExtensions__item_._cont = ASN1Dict([
        (u'extnID', _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID),
        (u'critical', _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__critical),
        (u'extnValue', _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue),
        ])
    ____TBSCertList_revokedCertificates__item__crlEntryExtensions__item_._ext = None
    ___TBSCertList_revokedCertificates__item__crlEntryExtensions._cont = ____TBSCertList_revokedCertificates__item__crlEntryExtensions__item_
    ___TBSCertList_revokedCertificates__item__crlEntryExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __TBSCertList_revokedCertificates__item_._cont = ASN1Dict([
        (u'userCertificate', ___TBSCertList_revokedCertificates__item__userCertificate),
        (u'revocationDate', ___TBSCertList_revokedCertificates__item__revocationDate),
        (u'crlEntryExtensions', ___TBSCertList_revokedCertificates__item__crlEntryExtensions),
        ])
    __TBSCertList_revokedCertificates__item_._ext = [u'crlEntryExtensions']
    _TBSCertList_revokedCertificates._cont = __TBSCertList_revokedCertificates__item_
    _TBSCertList_revokedCertificates._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _TBSCertList_crlExtensions = SEQ_OF(name=u'crlExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True, group=0)
    __TBSCertList_crlExtensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___TBSCertList_crlExtensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____TBSCertList_crlExtensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_2 = INT(name=u'ExtnType', mode=MODE_TYPE)
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_3 = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLNumber')))
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_4 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'IssuingDistributionPoint')))
    _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_5 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    ____TBSCertList_crlExtensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_0), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_1), (u'id', (2, 5, 29, 18))]), dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 20))]), dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_3), (u'id', (2, 5, 29, 27))]), dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_4), (u'id', (2, 5, 29, 28))]), dict([(u'ExtnType', _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_5), (u'id', (2, 5, 29, 46))])], rr=[], ev=None, er=[])
    ___TBSCertList_crlExtensions__item__extnID._const_tab = ____TBSCertList_crlExtensions__item__extnID_tab
    ___TBSCertList_crlExtensions__item__extnID._const_tab_at = None
    ___TBSCertList_crlExtensions__item__extnID._const_tab_id = u'id'
    ___TBSCertList_crlExtensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___TBSCertList_crlExtensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____TBSCertList_crlExtensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____TBSCertList_crlExtensions__item__extnValue_contain._const_tab = ____TBSCertList_crlExtensions__item__extnID_tab
    ____TBSCertList_crlExtensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____TBSCertList_crlExtensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___TBSCertList_crlExtensions__item__extnValue._const_cont = ____TBSCertList_crlExtensions__item__extnValue_contain
    __TBSCertList_crlExtensions__item_._cont = ASN1Dict([
        (u'extnID', ___TBSCertList_crlExtensions__item__extnID),
        (u'critical', ___TBSCertList_crlExtensions__item__critical),
        (u'extnValue', ___TBSCertList_crlExtensions__item__extnValue),
        ])
    __TBSCertList_crlExtensions__item_._ext = None
    _TBSCertList_crlExtensions._cont = __TBSCertList_crlExtensions__item_
    _TBSCertList_crlExtensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    TBSCertList._cont = ASN1Dict([
        (u'version', _TBSCertList_version),
        (u'signature', _TBSCertList_signature),
        (u'issuer', _TBSCertList_issuer),
        (u'thisUpdate', _TBSCertList_thisUpdate),
        (u'nextUpdate', _TBSCertList_nextUpdate),
        (u'revokedCertificates', _TBSCertList_revokedCertificates),
        (u'crlExtensions', _TBSCertList_crlExtensions),
        ])
    TBSCertList._ext = [u'crlExtensions']
    
    #-----< SignatureAlgorithms >-----#
    SignatureAlgorithms = CLASS(name=u'SignatureAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _SignatureAlgorithms_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgorithms_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgorithms_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    SignatureAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', _SignatureAlgorithms_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', _SignatureAlgorithms_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', _SignatureAlgorithms_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', _SignatureAlgorithms_val_Value_3), (u'Params', _SignatureAlgorithms_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', _SignatureAlgorithms_val_Value_4), (u'Params', _SignatureAlgorithms_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', _SignatureAlgorithms_val_Value_5), (u'Params', _SignatureAlgorithms_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', _SignatureAlgorithms_val_Value_6), (u'Params', _SignatureAlgorithms_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', _SignatureAlgorithms_val_Value_7), (u'Params', _SignatureAlgorithms_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', _SignatureAlgorithms_val_Value_8), (u'Params', _SignatureAlgorithms_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', _SignatureAlgorithms_val_Value_9), (u'Params', _SignatureAlgorithms_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', _SignatureAlgorithms_val_Value_10), (u'Params', _SignatureAlgorithms_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', _SignatureAlgorithms_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    
    #-----< PublicKeyAlgorithms >-----#
    PublicKeyAlgorithms = CLASS(name=u'PublicKeyAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _PublicKeyAlgorithms_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeyAlgorithms_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _PublicKeyAlgorithms_val_KeyValue_1 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    _PublicKeyAlgorithms_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    _PublicKeyAlgorithms_val_KeyValue_2 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _PublicKeyAlgorithms_val_Params_2 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    _PublicKeyAlgorithms_val_Params_3 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'KEA-Params-Id')))
    _PublicKeyAlgorithms_val_KeyValue_4 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeyAlgorithms_val_Params_4 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _PublicKeyAlgorithms_val_KeyValue_5 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeyAlgorithms_val_Params_5 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _PublicKeyAlgorithms_val_KeyValue_6 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeyAlgorithms_val_Params_6 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _PublicKeyAlgorithms_val_KeyValue_7 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeyAlgorithms_val_Params_7 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    _PublicKeyAlgorithms_val_KeyValue_8 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeyAlgorithms_val_Params_8 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    PublicKeyAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_0), (u'Params', _PublicKeyAlgorithms_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_1), (u'Params', _PublicKeyAlgorithms_val_Params_1), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_2), (u'Params', _PublicKeyAlgorithms_val_Params_2), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))]), dict([(u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22)), (u'Params', _PublicKeyAlgorithms_val_Params_3), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])], rr=[], ev=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_4), (u'Params', _PublicKeyAlgorithms_val_Params_4), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))]), dict([(u'id', (1, 3, 132, 1, 12)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_5), (u'Params', _PublicKeyAlgorithms_val_Params_5), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 3, 132, 1, 13)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_6), (u'Params', _PublicKeyAlgorithms_val_Params_6), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_7), (u'Params', _PublicKeyAlgorithms_val_Params_7), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', _PublicKeyAlgorithms_val_KeyValue_8), (u'Params', _PublicKeyAlgorithms_val_Params_8), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], er=[])
    
    #-----< ub-state-name >-----#
    ub_state_name = INT(name=u'ub-state-name', mode=MODE_VALUE)
    ub_state_name._val = 128
    
    #-----< ub-organization-name >-----#
    ub_organization_name = INT(name=u'ub-organization-name', mode=MODE_VALUE)
    ub_organization_name._val = 64
    
    #-----< ub-organizational-unit-name >-----#
    ub_organizational_unit_name = INT(name=u'ub-organizational-unit-name', mode=MODE_VALUE)
    ub_organizational_unit_name._val = 64
    
    #-----< ub-title >-----#
    ub_title = INT(name=u'ub-title', mode=MODE_VALUE)
    ub_title._val = 64
    
    #-----< ub-serial-number >-----#
    ub_serial_number = INT(name=u'ub-serial-number', mode=MODE_VALUE)
    ub_serial_number._val = 64
    
    #-----< ub-pseudonym >-----#
    ub_pseudonym = INT(name=u'ub-pseudonym', mode=MODE_VALUE)
    ub_pseudonym._val = 128
    
    #-----< ub-emailaddress-length >-----#
    ub_emailaddress_length = INT(name=u'ub-emailaddress-length', mode=MODE_VALUE)
    ub_emailaddress_length._val = 255
    
    #-----< ub-locality-name >-----#
    ub_locality_name = INT(name=u'ub-locality-name', mode=MODE_VALUE)
    ub_locality_name._val = 128
    
    #-----< ub-common-name >-----#
    ub_common_name = INT(name=u'ub-common-name', mode=MODE_VALUE)
    ub_common_name._val = 64
    
    #-----< ub-name >-----#
    ub_name = INT(name=u'ub-name', mode=MODE_VALUE)
    ub_name._val = 32768
    
    #-----< SIGNED >-----#
    SIGNED = SEQ(name=u'SIGNED', mode=MODE_TYPE, param=True)
    
    _all_ = [
        id_pkix,
        id_pe,
        id_qt,
        id_kp,
        id_ad,
        id_qt_cps,
        id_qt_unotice,
        id_ad_ocsp,
        id_ad_caIssuers,
        id_ad_timeStamping,
        id_ad_caRepository,
        AttributeType,
        id_at,
        id_at_name,
        at_name,
        _at_name_val_Type,
        id_at_surname,
        at_surname,
        _at_surname_val_Type,
        id_at_givenName,
        at_givenName,
        _at_givenName_val_Type,
        id_at_initials,
        at_initials,
        _at_initials_val_Type,
        id_at_generationQualifier,
        at_generationQualifier,
        _at_generationQualifier_val_Type,
        _X520name_teletexString,
        _X520name_printableString,
        _X520name_bmpString,
        _X520name_universalString,
        _X520name_uTF8String,
        X520name,
        id_at_commonName,
        at_x520CommonName,
        _at_x520CommonName_val_Type,
        _X520CommonName_teletexString,
        _X520CommonName_printableString,
        _X520CommonName_bmpString,
        _X520CommonName_universalString,
        _X520CommonName_uTF8String,
        X520CommonName,
        id_at_localityName,
        at_x520LocalityName,
        _at_x520LocalityName_val_Type,
        _X520LocalityName_teletexString,
        _X520LocalityName_printableString,
        _X520LocalityName_bmpString,
        _X520LocalityName_universalString,
        _X520LocalityName_uTF8String,
        X520LocalityName,
        id_at_stateOrProvinceName,
        at_x520StateOrProvinceName,
        __at_x520StateOrProvinceName_val_Type_teletexString,
        __at_x520StateOrProvinceName_val_Type_printableString,
        __at_x520StateOrProvinceName_val_Type_bmpString,
        __at_x520StateOrProvinceName_val_Type_universalString,
        __at_x520StateOrProvinceName_val_Type_uTF8String,
        _at_x520StateOrProvinceName_val_Type,
        _X520StateOrProvinceName_teletexString,
        _X520StateOrProvinceName_printableString,
        _X520StateOrProvinceName_bmpString,
        _X520StateOrProvinceName_universalString,
        _X520StateOrProvinceName_uTF8String,
        X520StateOrProvinceName,
        id_at_organizationName,
        at_x520OrganizationName,
        __at_x520OrganizationName_val_Type_teletexString,
        __at_x520OrganizationName_val_Type_printableString,
        __at_x520OrganizationName_val_Type_bmpString,
        __at_x520OrganizationName_val_Type_universalString,
        __at_x520OrganizationName_val_Type_uTF8String,
        _at_x520OrganizationName_val_Type,
        _X520OrganizationName_teletexString,
        _X520OrganizationName_printableString,
        _X520OrganizationName_bmpString,
        _X520OrganizationName_universalString,
        _X520OrganizationName_uTF8String,
        X520OrganizationName,
        id_at_organizationalUnitName,
        at_x520OrganizationalUnitName,
        __at_x520OrganizationalUnitName_val_Type_teletexString,
        __at_x520OrganizationalUnitName_val_Type_printableString,
        __at_x520OrganizationalUnitName_val_Type_bmpString,
        __at_x520OrganizationalUnitName_val_Type_universalString,
        __at_x520OrganizationalUnitName_val_Type_uTF8String,
        _at_x520OrganizationalUnitName_val_Type,
        _X520OrganizationalUnitName_teletexString,
        _X520OrganizationalUnitName_printableString,
        _X520OrganizationalUnitName_bmpString,
        _X520OrganizationalUnitName_universalString,
        _X520OrganizationalUnitName_uTF8String,
        X520OrganizationalUnitName,
        id_at_title,
        at_x520Title,
        __at_x520Title_val_Type_teletexString,
        __at_x520Title_val_Type_printableString,
        __at_x520Title_val_Type_bmpString,
        __at_x520Title_val_Type_universalString,
        __at_x520Title_val_Type_uTF8String,
        _at_x520Title_val_Type,
        id_at_dnQualifier,
        at_x520dnQualifier,
        _at_x520dnQualifier_val_Type,
        id_at_countryName,
        at_x520countryName,
        _at_x520countryName_val_Type,
        id_at_serialNumber,
        at_x520SerialNumber,
        _at_x520SerialNumber_val_Type,
        id_at_pseudonym,
        at_x520Pseudonym,
        __at_x520Pseudonym_val_Type_teletexString,
        __at_x520Pseudonym_val_Type_printableString,
        __at_x520Pseudonym_val_Type_bmpString,
        __at_x520Pseudonym_val_Type_universalString,
        __at_x520Pseudonym_val_Type_uTF8String,
        _at_x520Pseudonym_val_Type,
        id_domainComponent,
        at_domainComponent,
        _at_domainComponent_val_Type,
        pkcs_9,
        id_emailAddress,
        at_emailAddress,
        _at_emailAddress_val_Type,
        _Name_rdnSequence,
        Name,
        _RDNSequence__item_,
        RDNSequence,
        DistinguishedName,
        ___RelativeDistinguishedName__item__type_tab,
        ____RelativeDistinguishedName__item__type_tab_val_Type_0,
        ____RelativeDistinguishedName__item__type_tab_val_Type_1,
        ____RelativeDistinguishedName__item__type_tab_val_Type_2,
        ____RelativeDistinguishedName__item__type_tab_val_Type_3,
        ____RelativeDistinguishedName__item__type_tab_val_Type_4,
        ____RelativeDistinguishedName__item__type_tab_val_Type_5,
        ____RelativeDistinguishedName__item__type_tab_val_Type_6,
        _____RelativeDistinguishedName__item__type_tab_val_Type_7_teletexString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_7_printableString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_7_bmpString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_7_universalString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_7_uTF8String,
        ____RelativeDistinguishedName__item__type_tab_val_Type_7,
        _____RelativeDistinguishedName__item__type_tab_val_Type_8_teletexString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_8_printableString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_8_bmpString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_8_universalString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_8_uTF8String,
        ____RelativeDistinguishedName__item__type_tab_val_Type_8,
        _____RelativeDistinguishedName__item__type_tab_val_Type_9_teletexString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_9_printableString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_9_bmpString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_9_universalString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_9_uTF8String,
        ____RelativeDistinguishedName__item__type_tab_val_Type_9,
        _____RelativeDistinguishedName__item__type_tab_val_Type_10_teletexString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_10_printableString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_10_bmpString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_10_universalString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_10_uTF8String,
        ____RelativeDistinguishedName__item__type_tab_val_Type_10,
        ____RelativeDistinguishedName__item__type_tab_val_Type_11,
        ____RelativeDistinguishedName__item__type_tab_val_Type_12,
        ____RelativeDistinguishedName__item__type_tab_val_Type_13,
        _____RelativeDistinguishedName__item__type_tab_val_Type_14_teletexString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_14_printableString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_14_bmpString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_14_universalString,
        _____RelativeDistinguishedName__item__type_tab_val_Type_14_uTF8String,
        ____RelativeDistinguishedName__item__type_tab_val_Type_14,
        ____RelativeDistinguishedName__item__type_tab_val_Type_15,
        ____RelativeDistinguishedName__item__type_tab_val_Type_16,
        __RelativeDistinguishedName__item__type,
        __RelativeDistinguishedName__item__value,
        _RelativeDistinguishedName__item_,
        RelativeDistinguishedName,
        SupportedAttributes,
        _SupportedAttributes_val_Type_0,
        _SupportedAttributes_val_Type_1,
        _SupportedAttributes_val_Type_2,
        _SupportedAttributes_val_Type_3,
        _SupportedAttributes_val_Type_4,
        _SupportedAttributes_val_Type_5,
        _SupportedAttributes_val_Type_6,
        __SupportedAttributes_val_Type_7_teletexString,
        __SupportedAttributes_val_Type_7_printableString,
        __SupportedAttributes_val_Type_7_bmpString,
        __SupportedAttributes_val_Type_7_universalString,
        __SupportedAttributes_val_Type_7_uTF8String,
        _SupportedAttributes_val_Type_7,
        __SupportedAttributes_val_Type_8_teletexString,
        __SupportedAttributes_val_Type_8_printableString,
        __SupportedAttributes_val_Type_8_bmpString,
        __SupportedAttributes_val_Type_8_universalString,
        __SupportedAttributes_val_Type_8_uTF8String,
        _SupportedAttributes_val_Type_8,
        __SupportedAttributes_val_Type_9_teletexString,
        __SupportedAttributes_val_Type_9_printableString,
        __SupportedAttributes_val_Type_9_bmpString,
        __SupportedAttributes_val_Type_9_universalString,
        __SupportedAttributes_val_Type_9_uTF8String,
        _SupportedAttributes_val_Type_9,
        __SupportedAttributes_val_Type_10_teletexString,
        __SupportedAttributes_val_Type_10_printableString,
        __SupportedAttributes_val_Type_10_bmpString,
        __SupportedAttributes_val_Type_10_universalString,
        __SupportedAttributes_val_Type_10_uTF8String,
        _SupportedAttributes_val_Type_10,
        _SupportedAttributes_val_Type_11,
        _SupportedAttributes_val_Type_12,
        _SupportedAttributes_val_Type_13,
        __SupportedAttributes_val_Type_14_teletexString,
        __SupportedAttributes_val_Type_14_printableString,
        __SupportedAttributes_val_Type_14_bmpString,
        __SupportedAttributes_val_Type_14_universalString,
        __SupportedAttributes_val_Type_14_uTF8String,
        _SupportedAttributes_val_Type_14,
        _SupportedAttributes_val_Type_15,
        _SupportedAttributes_val_Type_16,
        _Certificate_toBeSigned,
        ___Certificate_algorithmIdentifier_algorithm_tab,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_1,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_2,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_3,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_3,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_4,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_5,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_5,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_6,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_6,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_7,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_7,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_8,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_8,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_9,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_9,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Value_10,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_10,
        ____Certificate_algorithmIdentifier_algorithm_tab_val_Params_11,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_1,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_2,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_3,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1,
        __Certificate_algorithmIdentifier_algorithm,
        __Certificate_algorithmIdentifier_parameters,
        _Certificate_algorithmIdentifier,
        __Certificate_signature_contain,
        _Certificate_signature,
        Certificate,
        _TBSCertificate_version,
        _TBSCertificate_serialNumber,
        ___TBSCertificate_signature_algorithm_tab,
        ____TBSCertificate_signature_algorithm_tab_val_Params_0,
        ____TBSCertificate_signature_algorithm_tab_val_Params_1,
        ____TBSCertificate_signature_algorithm_tab_val_Params_2,
        ____TBSCertificate_signature_algorithm_tab_val_Value_3,
        ____TBSCertificate_signature_algorithm_tab_val_Params_3,
        ____TBSCertificate_signature_algorithm_tab_val_Value_4,
        ____TBSCertificate_signature_algorithm_tab_val_Params_4,
        ____TBSCertificate_signature_algorithm_tab_val_Value_5,
        ____TBSCertificate_signature_algorithm_tab_val_Params_5,
        ____TBSCertificate_signature_algorithm_tab_val_Value_6,
        ____TBSCertificate_signature_algorithm_tab_val_Params_6,
        ____TBSCertificate_signature_algorithm_tab_val_Value_7,
        ____TBSCertificate_signature_algorithm_tab_val_Params_7,
        ____TBSCertificate_signature_algorithm_tab_val_Value_8,
        ____TBSCertificate_signature_algorithm_tab_val_Params_8,
        ____TBSCertificate_signature_algorithm_tab_val_Value_9,
        ____TBSCertificate_signature_algorithm_tab_val_Params_9,
        ____TBSCertificate_signature_algorithm_tab_val_Value_10,
        ____TBSCertificate_signature_algorithm_tab_val_Params_10,
        ____TBSCertificate_signature_algorithm_tab_val_Params_11,
        __TBSCertificate_signature_algorithm,
        __TBSCertificate_signature_parameters,
        _TBSCertificate_signature,
        _TBSCertificate_issuer,
        _TBSCertificate_validity,
        _TBSCertificate_subject,
        _TBSCertificate_subjectPublicKeyInfo,
        _TBSCertificate_issuerUniqueID,
        _TBSCertificate_subjectUniqueID,
        ____TBSCertificate_extensions__item__extnID_tab,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_0,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_1,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_2,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_3,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_4,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_5,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_6,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_7,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_8,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_9,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_10,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_11,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_12,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_13,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_14,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_15,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_16,
        _____TBSCertificate_extensions__item__extnID_tab_val_ExtnType_17,
        ___TBSCertificate_extensions__item__extnID,
        ___TBSCertificate_extensions__item__critical,
        ____TBSCertificate_extensions__item__extnValue_contain,
        ___TBSCertificate_extensions__item__extnValue,
        __TBSCertificate_extensions__item_,
        _TBSCertificate_extensions,
        TBSCertificate,
        Version,
        CertificateSerialNumber,
        _Validity_notBefore,
        _Validity_notAfter,
        Validity,
        _Time_utcTime,
        _Time_generalTime,
        Time,
        UniqueIdentifier,
        ___SubjectPublicKeyInfo_algorithm_algorithm_tab,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_0,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_0,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_1,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_1,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_2,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_2,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_3,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_4,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_4,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_5,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_5,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_6,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_6,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_7,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_7,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_KeyValue_8,
        ____SubjectPublicKeyInfo_algorithm_algorithm_tab_val_Params_8,
        __SubjectPublicKeyInfo_algorithm_algorithm,
        __SubjectPublicKeyInfo_algorithm_parameters,
        _SubjectPublicKeyInfo_algorithm,
        _SubjectPublicKeyInfo_subjectPublicKey,
        SubjectPublicKeyInfo,
        _CertificateList_toBeSigned,
        ___CertificateList_algorithmIdentifier_algorithm_tab,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_0,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_1,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_2,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_3,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_3,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_4,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_4,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_5,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_5,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_6,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_6,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_7,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_7,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_8,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_8,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_9,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_9,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Value_10,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_10,
        ____CertificateList_algorithmIdentifier_algorithm_tab_val_Params_11,
        __CertificateList_algorithmIdentifier_algorithm,
        __CertificateList_algorithmIdentifier_parameters,
        _CertificateList_algorithmIdentifier,
        __CertificateList_signature_contain,
        _CertificateList_signature,
        CertificateList,
        _TBSCertList_version,
        ___TBSCertList_signature_algorithm_tab,
        ____TBSCertList_signature_algorithm_tab_val_Params_0,
        ____TBSCertList_signature_algorithm_tab_val_Params_1,
        ____TBSCertList_signature_algorithm_tab_val_Params_2,
        ____TBSCertList_signature_algorithm_tab_val_Value_3,
        ____TBSCertList_signature_algorithm_tab_val_Params_3,
        ____TBSCertList_signature_algorithm_tab_val_Value_4,
        ____TBSCertList_signature_algorithm_tab_val_Params_4,
        ____TBSCertList_signature_algorithm_tab_val_Value_5,
        ____TBSCertList_signature_algorithm_tab_val_Params_5,
        ____TBSCertList_signature_algorithm_tab_val_Value_6,
        ____TBSCertList_signature_algorithm_tab_val_Params_6,
        ____TBSCertList_signature_algorithm_tab_val_Value_7,
        ____TBSCertList_signature_algorithm_tab_val_Params_7,
        ____TBSCertList_signature_algorithm_tab_val_Value_8,
        ____TBSCertList_signature_algorithm_tab_val_Params_8,
        ____TBSCertList_signature_algorithm_tab_val_Value_9,
        ____TBSCertList_signature_algorithm_tab_val_Params_9,
        ____TBSCertList_signature_algorithm_tab_val_Value_10,
        ____TBSCertList_signature_algorithm_tab_val_Params_10,
        ____TBSCertList_signature_algorithm_tab_val_Params_11,
        __TBSCertList_signature_algorithm,
        __TBSCertList_signature_parameters,
        _TBSCertList_signature,
        _TBSCertList_issuer,
        _TBSCertList_thisUpdate,
        _TBSCertList_nextUpdate,
        ___TBSCertList_revokedCertificates__item__userCertificate,
        ___TBSCertList_revokedCertificates__item__revocationDate,
        ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab,
        _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_0,
        _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_1,
        _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_2,
        _______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID_tab_val_ExtnType_3,
        _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnID,
        _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__critical,
        ______TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue_contain,
        _____TBSCertList_revokedCertificates__item__crlEntryExtensions__item__extnValue,
        ____TBSCertList_revokedCertificates__item__crlEntryExtensions__item_,
        ___TBSCertList_revokedCertificates__item__crlEntryExtensions,
        __TBSCertList_revokedCertificates__item_,
        _TBSCertList_revokedCertificates,
        ____TBSCertList_crlExtensions__item__extnID_tab,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_0,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_1,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_2,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_3,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_4,
        _____TBSCertList_crlExtensions__item__extnID_tab_val_ExtnType_5,
        ___TBSCertList_crlExtensions__item__extnID,
        ___TBSCertList_crlExtensions__item__critical,
        ____TBSCertList_crlExtensions__item__extnValue_contain,
        ___TBSCertList_crlExtensions__item__extnValue,
        __TBSCertList_crlExtensions__item_,
        _TBSCertList_crlExtensions,
        TBSCertList,
        SignatureAlgorithms,
        _SignatureAlgorithms_val_Params_0,
        _SignatureAlgorithms_val_Params_1,
        _SignatureAlgorithms_val_Params_2,
        _SignatureAlgorithms_val_Value_3,
        _SignatureAlgorithms_val_Params_3,
        _SignatureAlgorithms_val_Value_4,
        _SignatureAlgorithms_val_Params_4,
        _SignatureAlgorithms_val_Value_5,
        _SignatureAlgorithms_val_Params_5,
        _SignatureAlgorithms_val_Value_6,
        _SignatureAlgorithms_val_Params_6,
        _SignatureAlgorithms_val_Value_7,
        _SignatureAlgorithms_val_Params_7,
        _SignatureAlgorithms_val_Value_8,
        _SignatureAlgorithms_val_Params_8,
        _SignatureAlgorithms_val_Value_9,
        _SignatureAlgorithms_val_Params_9,
        _SignatureAlgorithms_val_Value_10,
        _SignatureAlgorithms_val_Params_10,
        _SignatureAlgorithms_val_Params_11,
        PublicKeyAlgorithms,
        _PublicKeyAlgorithms_val_KeyValue_0,
        _PublicKeyAlgorithms_val_Params_0,
        _PublicKeyAlgorithms_val_KeyValue_1,
        _PublicKeyAlgorithms_val_Params_1,
        _PublicKeyAlgorithms_val_KeyValue_2,
        _PublicKeyAlgorithms_val_Params_2,
        _PublicKeyAlgorithms_val_Params_3,
        _PublicKeyAlgorithms_val_KeyValue_4,
        _PublicKeyAlgorithms_val_Params_4,
        _PublicKeyAlgorithms_val_KeyValue_5,
        _PublicKeyAlgorithms_val_Params_5,
        _PublicKeyAlgorithms_val_KeyValue_6,
        _PublicKeyAlgorithms_val_Params_6,
        _PublicKeyAlgorithms_val_KeyValue_7,
        _PublicKeyAlgorithms_val_Params_7,
        _PublicKeyAlgorithms_val_KeyValue_8,
        _PublicKeyAlgorithms_val_Params_8,
        ub_state_name,
        ub_organization_name,
        ub_organizational_unit_name,
        ub_title,
        ub_serial_number,
        ub_pseudonym,
        ub_emailaddress_length,
        ub_locality_name,
        ub_common_name,
        ub_name,
    ]

class PKIX1Implicit_2009:

    _name_  = u'PKIX1Implicit-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 59]
    
    _obj_ = [
        u'CertExtensions',
        u'CrlExtensions',
        u'CrlEntryExtensions',
        u'id-ce',
        u'ext-AuthorityKeyIdentifier',
        u'id-ce-authorityKeyIdentifier',
        u'AuthorityKeyIdentifier',
        u'KeyIdentifier',
        u'ext-SubjectKeyIdentifier',
        u'id-ce-subjectKeyIdentifier',
        u'ext-KeyUsage',
        u'id-ce-keyUsage',
        u'KeyUsage',
        u'ext-PrivateKeyUsagePeriod',
        u'id-ce-privateKeyUsagePeriod',
        u'PrivateKeyUsagePeriod',
        u'ext-CertificatePolicies',
        u'id-ce-certificatePolicies',
        u'CertificatePolicies',
        u'PolicyInformation',
        u'CertPolicyId',
        u'CERT-POLICY-QUALIFIER',
        u'PolicyQualifierInfo',
        u'PolicyQualifierId',
        u'pqid-cps',
        u'pqid-unotice',
        u'CPSuri',
        u'UserNotice',
        u'NoticeReference',
        u'DisplayText',
        u'ext-PolicyMappings',
        u'id-ce-policyMappings',
        u'PolicyMappings',
        u'ext-SubjectAltName',
        u'id-ce-subjectAltName',
        u'GeneralNames',
        u'GeneralName',
        u'OTHER-NAME',
        u'EDIPartyName',
        u'ext-IssuerAltName',
        u'id-ce-issuerAltName',
        u'ext-SubjectDirectoryAttributes',
        u'id-ce-subjectDirectoryAttributes',
        u'SubjectDirectoryAttributes',
        u'ext-BasicConstraints',
        u'id-ce-basicConstraints',
        u'BasicConstraints',
        u'ext-NameConstraints',
        u'id-ce-nameConstraints',
        u'NameConstraints',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'ext-PolicyConstraints',
        u'id-ce-policyConstraints',
        u'PolicyConstraints',
        u'SkipCerts',
        u'ext-CRLDistributionPoints',
        u'id-ce-cRLDistributionPoints',
        u'CRLDistributionPoints',
        u'DistributionPoint',
        u'DistributionPointName',
        u'ReasonFlags',
        u'ext-ExtKeyUsage',
        u'id-ce-extKeyUsage',
        u'ExtKeyUsageSyntax',
        u'KeyPurposeId',
        u'anyExtendedKeyUsage',
        u'id-kp-serverAuth',
        u'id-kp-clientAuth',
        u'id-kp-codeSigning',
        u'id-kp-emailProtection',
        u'id-kp-timeStamping',
        u'id-kp-OCSPSigning',
        u'ext-InhibitAnyPolicy',
        u'id-ce-inhibitAnyPolicy',
        u'ext-FreshestCRL',
        u'id-ce-freshestCRL',
        u'ext-AuthorityInfoAccess',
        u'id-pe-authorityInfoAccess',
        u'AuthorityInfoAccessSyntax',
        u'AccessDescription',
        u'ext-SubjectInfoAccessSyntax',
        u'id-pe-subjectInfoAccess',
        u'SubjectInfoAccessSyntax',
        u'ext-CRLNumber',
        u'id-ce-cRLNumber',
        u'CRLNumber',
        u'ext-IssuingDistributionPoint',
        u'id-ce-issuingDistributionPoint',
        u'IssuingDistributionPoint',
        u'ext-DeltaCRLIndicator',
        u'id-ce-deltaCRLIndicator',
        u'ext-CRLReason',
        u'id-ce-cRLReasons',
        u'CRLReason',
        u'ext-CertificateIssuer',
        u'id-ce-certificateIssuer',
        u'ext-HoldInstructionCode',
        u'id-ce-holdInstructionCode',
        u'holdInstruction',
        u'id-holdinstruction-none',
        u'id-holdinstruction-callissuer',
        u'id-holdinstruction-reject',
        u'ext-InvalidityDate',
        u'id-ce-invalidityDate',
        u'ubMax',
        ]
    _type_ = [
        u'AuthorityKeyIdentifier',
        u'KeyIdentifier',
        u'KeyUsage',
        u'PrivateKeyUsagePeriod',
        u'CertificatePolicies',
        u'PolicyInformation',
        u'CertPolicyId',
        u'CERT-POLICY-QUALIFIER',
        u'PolicyQualifierInfo',
        u'CPSuri',
        u'UserNotice',
        u'NoticeReference',
        u'DisplayText',
        u'PolicyMappings',
        u'GeneralNames',
        u'GeneralName',
        u'OTHER-NAME',
        u'EDIPartyName',
        u'SubjectDirectoryAttributes',
        u'BasicConstraints',
        u'NameConstraints',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'PolicyConstraints',
        u'SkipCerts',
        u'CRLDistributionPoints',
        u'DistributionPoint',
        u'DistributionPointName',
        u'ReasonFlags',
        u'ExtKeyUsageSyntax',
        u'KeyPurposeId',
        u'AuthorityInfoAccessSyntax',
        u'AccessDescription',
        u'SubjectInfoAccessSyntax',
        u'CRLNumber',
        u'IssuingDistributionPoint',
        u'CRLReason',
        ]
    _set_ = [
        u'CertExtensions',
        u'CrlExtensions',
        u'CrlEntryExtensions',
        u'PolicyQualifierId',
        ]
    _val_ = [
        u'id-ce',
        u'ext-AuthorityKeyIdentifier',
        u'id-ce-authorityKeyIdentifier',
        u'ext-SubjectKeyIdentifier',
        u'id-ce-subjectKeyIdentifier',
        u'ext-KeyUsage',
        u'id-ce-keyUsage',
        u'ext-PrivateKeyUsagePeriod',
        u'id-ce-privateKeyUsagePeriod',
        u'ext-CertificatePolicies',
        u'id-ce-certificatePolicies',
        u'pqid-cps',
        u'pqid-unotice',
        u'ext-PolicyMappings',
        u'id-ce-policyMappings',
        u'ext-SubjectAltName',
        u'id-ce-subjectAltName',
        u'ext-IssuerAltName',
        u'id-ce-issuerAltName',
        u'ext-SubjectDirectoryAttributes',
        u'id-ce-subjectDirectoryAttributes',
        u'ext-BasicConstraints',
        u'id-ce-basicConstraints',
        u'ext-NameConstraints',
        u'id-ce-nameConstraints',
        u'ext-PolicyConstraints',
        u'id-ce-policyConstraints',
        u'ext-CRLDistributionPoints',
        u'id-ce-cRLDistributionPoints',
        u'ext-ExtKeyUsage',
        u'id-ce-extKeyUsage',
        u'anyExtendedKeyUsage',
        u'id-kp-serverAuth',
        u'id-kp-clientAuth',
        u'id-kp-codeSigning',
        u'id-kp-emailProtection',
        u'id-kp-timeStamping',
        u'id-kp-OCSPSigning',
        u'ext-InhibitAnyPolicy',
        u'id-ce-inhibitAnyPolicy',
        u'ext-FreshestCRL',
        u'id-ce-freshestCRL',
        u'ext-AuthorityInfoAccess',
        u'id-pe-authorityInfoAccess',
        u'ext-SubjectInfoAccessSyntax',
        u'id-pe-subjectInfoAccess',
        u'ext-CRLNumber',
        u'id-ce-cRLNumber',
        u'ext-IssuingDistributionPoint',
        u'id-ce-issuingDistributionPoint',
        u'ext-DeltaCRLIndicator',
        u'id-ce-deltaCRLIndicator',
        u'ext-CRLReason',
        u'id-ce-cRLReasons',
        u'ext-CertificateIssuer',
        u'id-ce-certificateIssuer',
        u'ext-HoldInstructionCode',
        u'id-ce-holdInstructionCode',
        u'holdInstruction',
        u'id-holdinstruction-none',
        u'id-holdinstruction-callissuer',
        u'id-holdinstruction-reject',
        u'ext-InvalidityDate',
        u'id-ce-invalidityDate',
        u'ubMax',
        ]
    _class_ = [
        u'CertExtensions',
        u'CrlExtensions',
        u'CrlEntryExtensions',
        u'ext-AuthorityKeyIdentifier',
        u'ext-SubjectKeyIdentifier',
        u'ext-KeyUsage',
        u'ext-PrivateKeyUsagePeriod',
        u'ext-CertificatePolicies',
        u'CERT-POLICY-QUALIFIER',
        u'PolicyQualifierId',
        u'pqid-cps',
        u'pqid-unotice',
        u'ext-PolicyMappings',
        u'ext-SubjectAltName',
        u'OTHER-NAME',
        u'ext-IssuerAltName',
        u'ext-SubjectDirectoryAttributes',
        u'ext-BasicConstraints',
        u'ext-NameConstraints',
        u'ext-PolicyConstraints',
        u'ext-CRLDistributionPoints',
        u'ext-ExtKeyUsage',
        u'ext-InhibitAnyPolicy',
        u'ext-FreshestCRL',
        u'ext-AuthorityInfoAccess',
        u'ext-SubjectInfoAccessSyntax',
        u'ext-CRLNumber',
        u'ext-IssuingDistributionPoint',
        u'ext-DeltaCRLIndicator',
        u'ext-CRLReason',
        u'ext-CertificateIssuer',
        u'ext-HoldInstructionCode',
        u'ext-InvalidityDate',
        ]
    _param_ = [
        ]
    
    #-----< CertExtensions >-----#
    CertExtensions = CLASS(name=u'CertExtensions', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _CertExtensions_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _CertExtensions_val_ExtnType_1 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')))
    _CertExtensions_val_ExtnType_2 = BIT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyUsage')))
    _CertExtensions_val_ExtnType_3 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PrivateKeyUsagePeriod')))
    _CertExtensions_val_ExtnType_4 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertificatePolicies')))
    _CertExtensions_val_ExtnType_5 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyMappings')))
    _CertExtensions_val_ExtnType_6 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _CertExtensions_val_ExtnType_7 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _CertExtensions_val_ExtnType_8 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectDirectoryAttributes')))
    _CertExtensions_val_ExtnType_9 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'BasicConstraints')))
    _CertExtensions_val_ExtnType_10 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'NameConstraints')))
    _CertExtensions_val_ExtnType_11 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyConstraints')))
    _CertExtensions_val_ExtnType_12 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'ExtKeyUsageSyntax')))
    _CertExtensions_val_ExtnType_13 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _CertExtensions_val_ExtnType_14 = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')))
    _CertExtensions_val_ExtnType_15 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _CertExtensions_val_ExtnType_16 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    _CertExtensions_val_ExtnType_17 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectInfoAccessSyntax')))
    CertExtensions._val = ASN1Set(rv=[dict([(u'ExtnType', _CertExtensions_val_ExtnType_0), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_1), (u'id', (2, 5, 29, 14))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_2), (u'id', (2, 5, 29, 15))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_3), (u'id', (2, 5, 29, 16))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_4), (u'id', (2, 5, 29, 32))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_5), (u'id', (2, 5, 29, 33))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_6), (u'id', (2, 5, 29, 17))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_7), (u'id', (2, 5, 29, 18))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_8), (u'id', (2, 5, 29, 9))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_9), (u'id', (2, 5, 29, 19))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_10), (u'id', (2, 5, 29, 30))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_11), (u'id', (2, 5, 29, 36))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_12), (u'id', (2, 5, 29, 37))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_13), (u'id', (2, 5, 29, 31))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_14), (u'id', (2, 5, 29, 54))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_15), (u'id', (2, 5, 29, 46))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_16), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))]), dict([(u'ExtnType', _CertExtensions_val_ExtnType_17), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 11))])], rr=[], ev=[], er=[])
    
    #-----< CrlExtensions >-----#
    CrlExtensions = CLASS(name=u'CrlExtensions', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _CrlExtensions_val_ExtnType_0 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _CrlExtensions_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _CrlExtensions_val_ExtnType_2 = INT(name=u'ExtnType', mode=MODE_TYPE)
    _CrlExtensions_val_ExtnType_2._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _CrlExtensions_val_ExtnType_3 = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLNumber')))
    _CrlExtensions_val_ExtnType_4 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'IssuingDistributionPoint')))
    _CrlExtensions_val_ExtnType_5 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    CrlExtensions._val = ASN1Set(rv=[dict([(u'ExtnType', _CrlExtensions_val_ExtnType_0), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _CrlExtensions_val_ExtnType_1), (u'id', (2, 5, 29, 18))]), dict([(u'ExtnType', _CrlExtensions_val_ExtnType_2), (u'id', (2, 5, 29, 20))]), dict([(u'ExtnType', _CrlExtensions_val_ExtnType_3), (u'id', (2, 5, 29, 27))]), dict([(u'ExtnType', _CrlExtensions_val_ExtnType_4), (u'id', (2, 5, 29, 28))]), dict([(u'ExtnType', _CrlExtensions_val_ExtnType_5), (u'id', (2, 5, 29, 46))])], rr=[], ev=[], er=[])
    
    #-----< CrlEntryExtensions >-----#
    CrlEntryExtensions = CLASS(name=u'CrlEntryExtensions', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _CrlEntryExtensions_val_ExtnType_0 = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLReason')))
    _CrlEntryExtensions_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _CrlEntryExtensions_val_ExtnType_2 = OID(name=u'ExtnType', mode=MODE_TYPE)
    _CrlEntryExtensions_val_ExtnType_3 = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    CrlEntryExtensions._val = ASN1Set(rv=[dict([(u'ExtnType', _CrlEntryExtensions_val_ExtnType_0), (u'id', (2, 5, 29, 21))]), dict([(u'ExtnType', _CrlEntryExtensions_val_ExtnType_1), (u'id', (2, 5, 29, 29))]), dict([(u'ExtnType', _CrlEntryExtensions_val_ExtnType_2), (u'id', (2, 5, 29, 23))]), dict([(u'ExtnType', _CrlEntryExtensions_val_ExtnType_3), (u'id', (2, 5, 29, 24))])], rr=[], ev=[], er=[])
    
    #-----< id-ce >-----#
    id_ce = OID(name=u'id-ce', mode=MODE_VALUE)
    id_ce._val = (2, 5, 29)
    
    #-----< ext-AuthorityKeyIdentifier >-----#
    ext_AuthorityKeyIdentifier = CLASS(name=u'ext-AuthorityKeyIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_AuthorityKeyIdentifier_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    ext_AuthorityKeyIdentifier._val = dict([(u'ExtnType', _ext_AuthorityKeyIdentifier_val_ExtnType), (u'id', (2, 5, 29, 35))])
    
    #-----< id-ce-authorityKeyIdentifier >-----#
    id_ce_authorityKeyIdentifier = OID(name=u'id-ce-authorityKeyIdentifier', mode=MODE_VALUE)
    id_ce_authorityKeyIdentifier._val = (2, 5, 29, 35)
    
    #-----< AuthorityKeyIdentifier >-----#
    AuthorityKeyIdentifier = SEQ(name=u'AuthorityKeyIdentifier', mode=MODE_TYPE)
    _AuthorityKeyIdentifier_keyIdentifier = OCT_STR(name=u'keyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')), opt=True)
    _AuthorityKeyIdentifier_authorityCertIssuer = SEQ_OF(name=u'authorityCertIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    _AuthorityKeyIdentifier_authorityCertSerialNumber = INT(name=u'authorityCertSerialNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')), opt=True)
    AuthorityKeyIdentifier._cont = ASN1Dict([
        (u'keyIdentifier', _AuthorityKeyIdentifier_keyIdentifier),
        (u'authorityCertIssuer', _AuthorityKeyIdentifier_authorityCertIssuer),
        (u'authorityCertSerialNumber', _AuthorityKeyIdentifier_authorityCertSerialNumber),
        ])
    AuthorityKeyIdentifier._ext = None
    
    #-----< KeyIdentifier >-----#
    KeyIdentifier = OCT_STR(name=u'KeyIdentifier', mode=MODE_TYPE)
    
    #-----< ext-SubjectKeyIdentifier >-----#
    ext_SubjectKeyIdentifier = CLASS(name=u'ext-SubjectKeyIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_SubjectKeyIdentifier_val_ExtnType = OCT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')))
    ext_SubjectKeyIdentifier._val = dict([(u'ExtnType', _ext_SubjectKeyIdentifier_val_ExtnType), (u'id', (2, 5, 29, 14))])
    
    #-----< id-ce-subjectKeyIdentifier >-----#
    id_ce_subjectKeyIdentifier = OID(name=u'id-ce-subjectKeyIdentifier', mode=MODE_VALUE)
    id_ce_subjectKeyIdentifier._val = (2, 5, 29, 14)
    
    #-----< ext-KeyUsage >-----#
    ext_KeyUsage = CLASS(name=u'ext-KeyUsage', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_KeyUsage_val_ExtnType = BIT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyUsage')))
    ext_KeyUsage._val = dict([(u'ExtnType', _ext_KeyUsage_val_ExtnType), (u'id', (2, 5, 29, 15))])
    
    #-----< id-ce-keyUsage >-----#
    id_ce_keyUsage = OID(name=u'id-ce-keyUsage', mode=MODE_VALUE)
    id_ce_keyUsage._val = (2, 5, 29, 15)
    
    #-----< KeyUsage >-----#
    KeyUsage = BIT_STR(name=u'KeyUsage', mode=MODE_TYPE)
    KeyUsage._cont = ASN1Dict([(u'digitalSignature', 0), (u'nonRepudiation', 1), (u'keyEncipherment', 2), (u'dataEncipherment', 3), (u'keyAgreement', 4), (u'keyCertSign', 5), (u'cRLSign', 6), (u'encipherOnly', 7), (u'decipherOnly', 8)])
    
    #-----< ext-PrivateKeyUsagePeriod >-----#
    ext_PrivateKeyUsagePeriod = CLASS(name=u'ext-PrivateKeyUsagePeriod', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_PrivateKeyUsagePeriod_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PrivateKeyUsagePeriod')))
    ext_PrivateKeyUsagePeriod._val = dict([(u'ExtnType', _ext_PrivateKeyUsagePeriod_val_ExtnType), (u'id', (2, 5, 29, 16))])
    
    #-----< id-ce-privateKeyUsagePeriod >-----#
    id_ce_privateKeyUsagePeriod = OID(name=u'id-ce-privateKeyUsagePeriod', mode=MODE_VALUE)
    id_ce_privateKeyUsagePeriod._val = (2, 5, 29, 16)
    
    #-----< PrivateKeyUsagePeriod >-----#
    PrivateKeyUsagePeriod = SEQ(name=u'PrivateKeyUsagePeriod', mode=MODE_TYPE)
    _PrivateKeyUsagePeriod_notBefore = TIME_GEN(name=u'notBefore', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PrivateKeyUsagePeriod_notAfter = TIME_GEN(name=u'notAfter', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PrivateKeyUsagePeriod._cont = ASN1Dict([
        (u'notBefore', _PrivateKeyUsagePeriod_notBefore),
        (u'notAfter', _PrivateKeyUsagePeriod_notAfter),
        ])
    PrivateKeyUsagePeriod._ext = None
    
    #-----< ext-CertificatePolicies >-----#
    ext_CertificatePolicies = CLASS(name=u'ext-CertificatePolicies', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_CertificatePolicies_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertificatePolicies')))
    ext_CertificatePolicies._val = dict([(u'ExtnType', _ext_CertificatePolicies_val_ExtnType), (u'id', (2, 5, 29, 32))])
    
    #-----< id-ce-certificatePolicies >-----#
    id_ce_certificatePolicies = OID(name=u'id-ce-certificatePolicies', mode=MODE_VALUE)
    id_ce_certificatePolicies._val = (2, 5, 29, 32)
    
    #-----< CertificatePolicies >-----#
    CertificatePolicies = SEQ_OF(name=u'CertificatePolicies', mode=MODE_TYPE)
    _CertificatePolicies__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyInformation')))
    CertificatePolicies._cont = _CertificatePolicies__item_
    CertificatePolicies._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PolicyInformation >-----#
    PolicyInformation = SEQ(name=u'PolicyInformation', mode=MODE_TYPE)
    _PolicyInformation_policyIdentifier = OID(name=u'policyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertPolicyId')))
    _PolicyInformation_policyQualifiers = SEQ_OF(name=u'policyQualifiers', mode=MODE_TYPE, opt=True)
    __PolicyInformation_policyQualifiers__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyQualifierInfo')))
    _PolicyInformation_policyQualifiers._cont = __PolicyInformation_policyQualifiers__item_
    _PolicyInformation_policyQualifiers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PolicyInformation._cont = ASN1Dict([
        (u'policyIdentifier', _PolicyInformation_policyIdentifier),
        (u'policyQualifiers', _PolicyInformation_policyQualifiers),
        ])
    PolicyInformation._ext = None
    
    #-----< CertPolicyId >-----#
    CertPolicyId = OID(name=u'CertPolicyId', mode=MODE_TYPE)
    
    #-----< CERT-POLICY-QUALIFIER >-----#
    CERT_POLICY_QUALIFIER = CLASS(name=u'CERT-POLICY-QUALIFIER', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< PolicyQualifierInfo >-----#
    PolicyQualifierInfo = SEQ(name=u'PolicyQualifierInfo', mode=MODE_TYPE)
    _PolicyQualifierInfo_policyQualifierId = OID(name=u'policyQualifierId', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER'), [u'id']))
    __PolicyQualifierInfo_policyQualifierId_tab = CLASS(name='_tab_CERT-POLICY-QUALIFIER', mode=MODE_SET, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER')))
    ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_0 = STR_IA5(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CPSuri')))
    ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'UserNotice')))
    __PolicyQualifierInfo_policyQualifierId_tab._val = ASN1Set(rv=[dict([('Type', ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_0), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 1))]), dict([('Type', ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_1), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 2))])], rr=[], ev=None, er=[])
    _PolicyQualifierInfo_policyQualifierId._const_tab = __PolicyQualifierInfo_policyQualifierId_tab
    _PolicyQualifierInfo_policyQualifierId._const_tab_at = None
    _PolicyQualifierInfo_policyQualifierId._const_tab_id = u'id'
    _PolicyQualifierInfo_qualifier = OPEN(name=u'qualifier', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER'), [u'Type']))
    _PolicyQualifierInfo_qualifier._const_tab = __PolicyQualifierInfo_policyQualifierId_tab
    _PolicyQualifierInfo_qualifier._const_tab_at = ('..', u'policyQualifierId')
    _PolicyQualifierInfo_qualifier._const_tab_id = u'Type'
    PolicyQualifierInfo._cont = ASN1Dict([
        (u'policyQualifierId', _PolicyQualifierInfo_policyQualifierId),
        (u'qualifier', _PolicyQualifierInfo_qualifier),
        ])
    PolicyQualifierInfo._ext = None
    
    #-----< PolicyQualifierId >-----#
    PolicyQualifierId = CLASS(name=u'PolicyQualifierId', mode=MODE_SET, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER')))
    _PolicyQualifierId_val_Type_0 = STR_IA5(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CPSuri')))
    _PolicyQualifierId_val_Type_1 = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'UserNotice')))
    PolicyQualifierId._val = ASN1Set(rv=[dict([('Type', _PolicyQualifierId_val_Type_0), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 1))]), dict([('Type', _PolicyQualifierId_val_Type_1), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 2))])], rr=[], ev=[], er=[])
    
    #-----< pqid-cps >-----#
    pqid_cps = CLASS(name=u'pqid-cps', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER')))
    _pqid_cps_val_Type = STR_IA5(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CPSuri')))
    pqid_cps._val = dict([('Type', _pqid_cps_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 1))])
    
    #-----< pqid-unotice >-----#
    pqid_unotice = CLASS(name=u'pqid-unotice', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CERT-POLICY-QUALIFIER')))
    _pqid_unotice_val_Type = SEQ(name='Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'UserNotice')))
    pqid_unotice._val = dict([('Type', _pqid_unotice_val_Type), ('id', (1, 3, 6, 1, 5, 5, 7, 2, 2))])
    
    #-----< CPSuri >-----#
    CPSuri = STR_IA5(name=u'CPSuri', mode=MODE_TYPE)
    
    #-----< UserNotice >-----#
    UserNotice = SEQ(name=u'UserNotice', mode=MODE_TYPE)
    _UserNotice_noticeRef = SEQ(name=u'noticeRef', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'NoticeReference')), opt=True)
    _UserNotice_explicitText = CHOICE(name=u'explicitText', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'DisplayText')), opt=True)
    UserNotice._cont = ASN1Dict([
        (u'noticeRef', _UserNotice_noticeRef),
        (u'explicitText', _UserNotice_explicitText),
        ])
    UserNotice._ext = None
    
    #-----< NoticeReference >-----#
    NoticeReference = SEQ(name=u'NoticeReference', mode=MODE_TYPE)
    _NoticeReference_organization = CHOICE(name=u'organization', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'DisplayText')))
    _NoticeReference_noticeNumbers = SEQ_OF(name=u'noticeNumbers', mode=MODE_TYPE)
    __NoticeReference_noticeNumbers__item_ = INT(name='_item_', mode=MODE_TYPE)
    _NoticeReference_noticeNumbers._cont = __NoticeReference_noticeNumbers__item_
    NoticeReference._cont = ASN1Dict([
        (u'organization', _NoticeReference_organization),
        (u'noticeNumbers', _NoticeReference_noticeNumbers),
        ])
    NoticeReference._ext = None
    
    #-----< DisplayText >-----#
    DisplayText = CHOICE(name=u'DisplayText', mode=MODE_TYPE)
    _DisplayText_ia5String = STR_IA5(name=u'ia5String', mode=MODE_TYPE)
    _DisplayText_ia5String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    _DisplayText_visibleString = STR_VIS(name=u'visibleString', mode=MODE_TYPE)
    _DisplayText_visibleString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    _DisplayText_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _DisplayText_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    _DisplayText_utf8String = STR_UTF8(name=u'utf8String', mode=MODE_TYPE)
    _DisplayText_utf8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=200)], ev=None, er=[])
    DisplayText._cont = ASN1Dict([
        (u'ia5String', _DisplayText_ia5String),
        (u'visibleString', _DisplayText_visibleString),
        (u'bmpString', _DisplayText_bmpString),
        (u'utf8String', _DisplayText_utf8String),
        ])
    DisplayText._ext = None
    
    #-----< ext-PolicyMappings >-----#
    ext_PolicyMappings = CLASS(name=u'ext-PolicyMappings', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_PolicyMappings_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyMappings')))
    ext_PolicyMappings._val = dict([(u'ExtnType', _ext_PolicyMappings_val_ExtnType), (u'id', (2, 5, 29, 33))])
    
    #-----< id-ce-policyMappings >-----#
    id_ce_policyMappings = OID(name=u'id-ce-policyMappings', mode=MODE_VALUE)
    id_ce_policyMappings._val = (2, 5, 29, 33)
    
    #-----< PolicyMappings >-----#
    PolicyMappings = SEQ_OF(name=u'PolicyMappings', mode=MODE_TYPE)
    _PolicyMappings__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __PolicyMappings__item__issuerDomainPolicy = OID(name=u'issuerDomainPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertPolicyId')))
    __PolicyMappings__item__subjectDomainPolicy = OID(name=u'subjectDomainPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CertPolicyId')))
    _PolicyMappings__item_._cont = ASN1Dict([
        (u'issuerDomainPolicy', __PolicyMappings__item__issuerDomainPolicy),
        (u'subjectDomainPolicy', __PolicyMappings__item__subjectDomainPolicy),
        ])
    _PolicyMappings__item_._ext = None
    PolicyMappings._cont = _PolicyMappings__item_
    PolicyMappings._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< ext-SubjectAltName >-----#
    ext_SubjectAltName = CLASS(name=u'ext-SubjectAltName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_SubjectAltName_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    ext_SubjectAltName._val = dict([(u'ExtnType', _ext_SubjectAltName_val_ExtnType), (u'id', (2, 5, 29, 17))])
    
    #-----< id-ce-subjectAltName >-----#
    id_ce_subjectAltName = OID(name=u'id-ce-subjectAltName', mode=MODE_VALUE)
    id_ce_subjectAltName._val = (2, 5, 29, 17)
    
    #-----< GeneralNames >-----#
    GeneralNames = SEQ_OF(name=u'GeneralNames', mode=MODE_TYPE)
    _GeneralNames__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    GeneralNames._cont = _GeneralNames__item_
    GeneralNames._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralName >-----#
    GeneralName = CHOICE(name=u'GeneralName', mode=MODE_TYPE)
    _GeneralName_otherName = SEQ(name=u'otherName', mode=MODE_TYPE)
    __GeneralName_otherName_type_id = OID(name='type-id', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX1Implicit-2009', 'OTHER-NAME'), ['id']))
    __GeneralName_otherName_value = OPEN(name='value', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PKIX1Implicit-2009', 'OTHER-NAME'), ['Type']))
    _GeneralName_otherName._cont = ASN1Dict([
        ('type-id', __GeneralName_otherName_type_id),
        ('value', __GeneralName_otherName_value),
        ])
    _GeneralName_otherName._ext = None
    _GeneralName_otherName.TAG = 8
    _GeneralName_rfc822Name = STR_IA5(name=u'rfc822Name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_dNSName = STR_IA5(name=u'dNSName', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_x400Address = SEQ(name=u'x400Address', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX-X400Address-2009', 'ORAddress')))
    _GeneralName_directoryName = CHOICE(name=u'directoryName', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'Name')))
    _GeneralName_ediPartyName = SEQ(name=u'ediPartyName', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'EDIPartyName')))
    _GeneralName_uniformResourceIdentifier = STR_IA5(name=u'uniformResourceIdentifier', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_iPAddress = OCT_STR(name=u'iPAddress', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_registeredID = OID(name=u'registeredID', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GeneralName._cont = ASN1Dict([
        (u'otherName', _GeneralName_otherName),
        (u'rfc822Name', _GeneralName_rfc822Name),
        (u'dNSName', _GeneralName_dNSName),
        (u'x400Address', _GeneralName_x400Address),
        (u'directoryName', _GeneralName_directoryName),
        (u'ediPartyName', _GeneralName_ediPartyName),
        (u'uniformResourceIdentifier', _GeneralName_uniformResourceIdentifier),
        (u'iPAddress', _GeneralName_iPAddress),
        (u'registeredID', _GeneralName_registeredID),
        ])
    GeneralName._ext = None
    
    #-----< OTHER-NAME >-----#
    OTHER_NAME = CLASS(name=u'OTHER-NAME', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< EDIPartyName >-----#
    EDIPartyName = SEQ(name=u'EDIPartyName', mode=MODE_TYPE)
    _EDIPartyName_nameAssigner = CHOICE(name=u'nameAssigner', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')), opt=True)
    __EDIPartyName_nameAssigner_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __EDIPartyName_nameAssigner_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_nameAssigner_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __EDIPartyName_nameAssigner_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_nameAssigner_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __EDIPartyName_nameAssigner_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_nameAssigner_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __EDIPartyName_nameAssigner_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_nameAssigner_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __EDIPartyName_nameAssigner_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _EDIPartyName_nameAssigner._cont = ASN1Dict([
        (u'teletexString', __EDIPartyName_nameAssigner_teletexString),
        (u'printableString', __EDIPartyName_nameAssigner_printableString),
        (u'bmpString', __EDIPartyName_nameAssigner_bmpString),
        (u'universalString', __EDIPartyName_nameAssigner_universalString),
        (u'uTF8String', __EDIPartyName_nameAssigner_uTF8String),
        ])
    _EDIPartyName_nameAssigner._ext = None
    _EDIPartyName_partyName = CHOICE(name=u'partyName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    __EDIPartyName_partyName_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __EDIPartyName_partyName_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_partyName_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __EDIPartyName_partyName_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_partyName_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __EDIPartyName_partyName_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_partyName_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __EDIPartyName_partyName_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    __EDIPartyName_partyName_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __EDIPartyName_partyName_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=32768)], ev=None, er=[])
    _EDIPartyName_partyName._cont = ASN1Dict([
        (u'teletexString', __EDIPartyName_partyName_teletexString),
        (u'printableString', __EDIPartyName_partyName_printableString),
        (u'bmpString', __EDIPartyName_partyName_bmpString),
        (u'universalString', __EDIPartyName_partyName_universalString),
        (u'uTF8String', __EDIPartyName_partyName_uTF8String),
        ])
    _EDIPartyName_partyName._ext = None
    EDIPartyName._cont = ASN1Dict([
        (u'nameAssigner', _EDIPartyName_nameAssigner),
        (u'partyName', _EDIPartyName_partyName),
        ])
    EDIPartyName._ext = None
    
    #-----< ext-IssuerAltName >-----#
    ext_IssuerAltName = CLASS(name=u'ext-IssuerAltName', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_IssuerAltName_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    ext_IssuerAltName._val = dict([(u'ExtnType', _ext_IssuerAltName_val_ExtnType), (u'id', (2, 5, 29, 18))])
    
    #-----< id-ce-issuerAltName >-----#
    id_ce_issuerAltName = OID(name=u'id-ce-issuerAltName', mode=MODE_VALUE)
    id_ce_issuerAltName._val = (2, 5, 29, 18)
    
    #-----< ext-SubjectDirectoryAttributes >-----#
    ext_SubjectDirectoryAttributes = CLASS(name=u'ext-SubjectDirectoryAttributes', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_SubjectDirectoryAttributes_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectDirectoryAttributes')))
    ext_SubjectDirectoryAttributes._val = dict([(u'ExtnType', _ext_SubjectDirectoryAttributes_val_ExtnType), (u'id', (2, 5, 29, 9))])
    
    #-----< id-ce-subjectDirectoryAttributes >-----#
    id_ce_subjectDirectoryAttributes = OID(name=u'id-ce-subjectDirectoryAttributes', mode=MODE_VALUE)
    id_ce_subjectDirectoryAttributes._val = (2, 5, 29, 9)
    
    #-----< SubjectDirectoryAttributes >-----#
    SubjectDirectoryAttributes = SEQ_OF(name=u'SubjectDirectoryAttributes', mode=MODE_TYPE)
    _SubjectDirectoryAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'AttributeSet')))
    __SubjectDirectoryAttributes__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ___SubjectDirectoryAttributes__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_1 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_2 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_3 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_4 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520name')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_5 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520CommonName')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_6 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'X520LocalityName')))
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_7 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_7._cont = ASN1Dict([
        (u'teletexString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_teletexString),
        (u'printableString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_printableString),
        (u'bmpString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_bmpString),
        (u'universalString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_universalString),
        (u'uTF8String', _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_uTF8String),
        ])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_7._ext = None
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_8 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_8._cont = ASN1Dict([
        (u'teletexString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_teletexString),
        (u'printableString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_printableString),
        (u'bmpString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_bmpString),
        (u'universalString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_universalString),
        (u'uTF8String', _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_uTF8String),
        ])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_8._ext = None
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_9 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_9._cont = ASN1Dict([
        (u'teletexString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_teletexString),
        (u'printableString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_printableString),
        (u'bmpString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_bmpString),
        (u'universalString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_universalString),
        (u'uTF8String', _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_uTF8String),
        ])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_9._ext = None
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_10 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_10._cont = ASN1Dict([
        (u'teletexString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_teletexString),
        (u'printableString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_printableString),
        (u'bmpString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_bmpString),
        (u'universalString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_universalString),
        (u'uTF8String', _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_uTF8String),
        ])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_10._ext = None
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_11 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_12 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_12._const_sz = ASN1Set(rv=[2], rr=[], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_13 = STR_PRINT(name=u'Type', mode=MODE_TYPE)
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_13._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=64)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_14 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'DirectoryString')))
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=128)], ev=None, er=[])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_14._cont = ASN1Dict([
        (u'teletexString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_teletexString),
        (u'printableString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_printableString),
        (u'bmpString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_bmpString),
        (u'universalString', _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_universalString),
        (u'uTF8String', _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_uTF8String),
        ])
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_14._ext = None
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_15 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_16 = STR_IA5(name=u'Type', mode=MODE_TYPE)
    ____SubjectDirectoryAttributes__item__type_tab_val_Type_16._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=255)], ev=None, er=[])
    ___SubjectDirectoryAttributes__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_0), (u'id', (2, 5, 4, 41))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_1), (u'id', (2, 5, 4, 4))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_2), (u'id', (2, 5, 4, 42))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_3), (u'id', (2, 5, 4, 43))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_4), (u'id', (2, 5, 4, 44))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_5), (u'id', (2, 5, 4, 3))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_6), (u'id', (2, 5, 4, 7))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_7), (u'id', (2, 5, 4, 8))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_8), (u'id', (2, 5, 4, 10))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_9), (u'id', (2, 5, 4, 11))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_10), (u'id', (2, 5, 4, 12))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_11), (u'id', (2, 5, 4, 46))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_12), (u'id', (2, 5, 4, 6))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_13), (u'id', (2, 5, 4, 5))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_14), (u'id', (2, 5, 4, 65))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_15), (u'id', (0, 9, 2342, 19200300, 100, 1, 25))]), dict([(u'Type', ____SubjectDirectoryAttributes__item__type_tab_val_Type_16), (u'id', (1, 2, 840, 113549, 1, 9, 1))])], rr=[], ev=None, er=[])
    __SubjectDirectoryAttributes__item__type._const_tab = ___SubjectDirectoryAttributes__item__type_tab
    __SubjectDirectoryAttributes__item__type._const_tab_at = None
    __SubjectDirectoryAttributes__item__type._const_tab_id = u'id'
    __SubjectDirectoryAttributes__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ___SubjectDirectoryAttributes__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ___SubjectDirectoryAttributes__item__values__item_._const_tab = ___SubjectDirectoryAttributes__item__type_tab
    ___SubjectDirectoryAttributes__item__values__item_._const_tab_at = ('..', '..', u'type')
    ___SubjectDirectoryAttributes__item__values__item_._const_tab_id = u'Type'
    __SubjectDirectoryAttributes__item__values._cont = ___SubjectDirectoryAttributes__item__values__item_
    __SubjectDirectoryAttributes__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _SubjectDirectoryAttributes__item_._cont = ASN1Dict([
        (u'type', __SubjectDirectoryAttributes__item__type),
        (u'values', __SubjectDirectoryAttributes__item__values),
        ])
    _SubjectDirectoryAttributes__item_._ext = None
    SubjectDirectoryAttributes._cont = _SubjectDirectoryAttributes__item_
    SubjectDirectoryAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< ext-BasicConstraints >-----#
    ext_BasicConstraints = CLASS(name=u'ext-BasicConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_BasicConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'BasicConstraints')))
    ext_BasicConstraints._val = dict([(u'ExtnType', _ext_BasicConstraints_val_ExtnType), (u'id', (2, 5, 29, 19))])
    
    #-----< id-ce-basicConstraints >-----#
    id_ce_basicConstraints = OID(name=u'id-ce-basicConstraints', mode=MODE_VALUE)
    id_ce_basicConstraints._val = (2, 5, 29, 19)
    
    #-----< BasicConstraints >-----#
    BasicConstraints = SEQ(name=u'BasicConstraints', mode=MODE_TYPE)
    _BasicConstraints_cA = BOOL(name=u'cA', mode=MODE_TYPE, default=False)
    _BasicConstraints_pathLenConstraint = INT(name=u'pathLenConstraint', mode=MODE_TYPE, opt=True)
    _BasicConstraints_pathLenConstraint._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    BasicConstraints._cont = ASN1Dict([
        (u'cA', _BasicConstraints_cA),
        (u'pathLenConstraint', _BasicConstraints_pathLenConstraint),
        ])
    BasicConstraints._ext = None
    
    #-----< ext-NameConstraints >-----#
    ext_NameConstraints = CLASS(name=u'ext-NameConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_NameConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'NameConstraints')))
    ext_NameConstraints._val = dict([(u'ExtnType', _ext_NameConstraints_val_ExtnType), (u'id', (2, 5, 29, 30))])
    
    #-----< id-ce-nameConstraints >-----#
    id_ce_nameConstraints = OID(name=u'id-ce-nameConstraints', mode=MODE_VALUE)
    id_ce_nameConstraints._val = (2, 5, 29, 30)
    
    #-----< NameConstraints >-----#
    NameConstraints = SEQ(name=u'NameConstraints', mode=MODE_TYPE)
    _NameConstraints_permittedSubtrees = SEQ_OF(name=u'permittedSubtrees', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralSubtrees')), opt=True)
    _NameConstraints_excludedSubtrees = SEQ_OF(name=u'excludedSubtrees', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralSubtrees')), opt=True)
    NameConstraints._cont = ASN1Dict([
        (u'permittedSubtrees', _NameConstraints_permittedSubtrees),
        (u'excludedSubtrees', _NameConstraints_excludedSubtrees),
        ])
    NameConstraints._ext = None
    
    #-----< GeneralSubtrees >-----#
    GeneralSubtrees = SEQ_OF(name=u'GeneralSubtrees', mode=MODE_TYPE)
    _GeneralSubtrees__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralSubtree')))
    GeneralSubtrees._cont = _GeneralSubtrees__item_
    GeneralSubtrees._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralSubtree >-----#
    GeneralSubtree = SEQ(name=u'GeneralSubtree', mode=MODE_TYPE)
    _GeneralSubtree_base = CHOICE(name=u'base', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _GeneralSubtree_minimum = INT(name=u'minimum', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'BaseDistance')), default=0)
    _GeneralSubtree_maximum = INT(name=u'maximum', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'BaseDistance')), opt=True)
    GeneralSubtree._cont = ASN1Dict([
        (u'base', _GeneralSubtree_base),
        (u'minimum', _GeneralSubtree_minimum),
        (u'maximum', _GeneralSubtree_maximum),
        ])
    GeneralSubtree._ext = None
    
    #-----< BaseDistance >-----#
    BaseDistance = INT(name=u'BaseDistance', mode=MODE_TYPE)
    BaseDistance._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< ext-PolicyConstraints >-----#
    ext_PolicyConstraints = CLASS(name=u'ext-PolicyConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_PolicyConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'PolicyConstraints')))
    ext_PolicyConstraints._val = dict([(u'ExtnType', _ext_PolicyConstraints_val_ExtnType), (u'id', (2, 5, 29, 36))])
    
    #-----< id-ce-policyConstraints >-----#
    id_ce_policyConstraints = OID(name=u'id-ce-policyConstraints', mode=MODE_VALUE)
    id_ce_policyConstraints._val = (2, 5, 29, 36)
    
    #-----< PolicyConstraints >-----#
    PolicyConstraints = SEQ(name=u'PolicyConstraints', mode=MODE_TYPE)
    _PolicyConstraints_requireExplicitPolicy = INT(name=u'requireExplicitPolicy', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')), opt=True)
    _PolicyConstraints_inhibitPolicyMapping = INT(name=u'inhibitPolicyMapping', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')), opt=True)
    PolicyConstraints._cont = ASN1Dict([
        (u'requireExplicitPolicy', _PolicyConstraints_requireExplicitPolicy),
        (u'inhibitPolicyMapping', _PolicyConstraints_inhibitPolicyMapping),
        ])
    PolicyConstraints._ext = None
    
    #-----< SkipCerts >-----#
    SkipCerts = INT(name=u'SkipCerts', mode=MODE_TYPE)
    SkipCerts._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< ext-CRLDistributionPoints >-----#
    ext_CRLDistributionPoints = CLASS(name=u'ext-CRLDistributionPoints', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_CRLDistributionPoints_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    ext_CRLDistributionPoints._val = dict([(u'ExtnType', _ext_CRLDistributionPoints_val_ExtnType), (u'id', (2, 5, 29, 31))])
    
    #-----< id-ce-cRLDistributionPoints >-----#
    id_ce_cRLDistributionPoints = OID(name=u'id-ce-cRLDistributionPoints', mode=MODE_VALUE)
    id_ce_cRLDistributionPoints._val = (2, 5, 29, 31)
    
    #-----< CRLDistributionPoints >-----#
    CRLDistributionPoints = SEQ_OF(name=u'CRLDistributionPoints', mode=MODE_TYPE)
    _CRLDistributionPoints__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'DistributionPoint')))
    CRLDistributionPoints._cont = _CRLDistributionPoints__item_
    CRLDistributionPoints._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< DistributionPoint >-----#
    DistributionPoint = SEQ(name=u'DistributionPoint', mode=MODE_TYPE)
    _DistributionPoint_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'DistributionPointName')), opt=True)
    _DistributionPoint_reasons = BIT_STR(name=u'reasons', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'ReasonFlags')), opt=True)
    _DistributionPoint_cRLIssuer = SEQ_OF(name=u'cRLIssuer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    DistributionPoint._cont = ASN1Dict([
        (u'distributionPoint', _DistributionPoint_distributionPoint),
        (u'reasons', _DistributionPoint_reasons),
        (u'cRLIssuer', _DistributionPoint_cRLIssuer),
        ])
    DistributionPoint._ext = None
    
    #-----< DistributionPointName >-----#
    DistributionPointName = CHOICE(name=u'DistributionPointName', mode=MODE_TYPE)
    _DistributionPointName_fullName = SEQ_OF(name=u'fullName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _DistributionPointName_nameRelativeToCRLIssuer = SET_OF(name=u'nameRelativeToCRLIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'RelativeDistinguishedName')))
    DistributionPointName._cont = ASN1Dict([
        (u'fullName', _DistributionPointName_fullName),
        (u'nameRelativeToCRLIssuer', _DistributionPointName_nameRelativeToCRLIssuer),
        ])
    DistributionPointName._ext = None
    
    #-----< ReasonFlags >-----#
    ReasonFlags = BIT_STR(name=u'ReasonFlags', mode=MODE_TYPE)
    ReasonFlags._cont = ASN1Dict([(u'unused', 0), (u'keyCompromise', 1), (u'cACompromise', 2), (u'affiliationChanged', 3), (u'superseded', 4), (u'cessationOfOperation', 5), (u'certificateHold', 6), (u'privilegeWithdrawn', 7), (u'aACompromise', 8)])
    
    #-----< ext-ExtKeyUsage >-----#
    ext_ExtKeyUsage = CLASS(name=u'ext-ExtKeyUsage', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_ExtKeyUsage_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'ExtKeyUsageSyntax')))
    ext_ExtKeyUsage._val = dict([(u'ExtnType', _ext_ExtKeyUsage_val_ExtnType), (u'id', (2, 5, 29, 37))])
    
    #-----< id-ce-extKeyUsage >-----#
    id_ce_extKeyUsage = OID(name=u'id-ce-extKeyUsage', mode=MODE_VALUE)
    id_ce_extKeyUsage._val = (2, 5, 29, 37)
    
    #-----< ExtKeyUsageSyntax >-----#
    ExtKeyUsageSyntax = SEQ_OF(name=u'ExtKeyUsageSyntax', mode=MODE_TYPE)
    _ExtKeyUsageSyntax__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyPurposeId')))
    ExtKeyUsageSyntax._cont = _ExtKeyUsageSyntax__item_
    ExtKeyUsageSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< KeyPurposeId >-----#
    KeyPurposeId = OID(name=u'KeyPurposeId', mode=MODE_TYPE)
    
    #-----< anyExtendedKeyUsage >-----#
    anyExtendedKeyUsage = OID(name=u'anyExtendedKeyUsage', mode=MODE_VALUE)
    anyExtendedKeyUsage._val = (2, 5, 29, 37, 0)
    
    #-----< id-kp-serverAuth >-----#
    id_kp_serverAuth = OID(name=u'id-kp-serverAuth', mode=MODE_VALUE)
    id_kp_serverAuth._val = (1, 3, 6, 1, 5, 5, 7, 3, 1)
    
    #-----< id-kp-clientAuth >-----#
    id_kp_clientAuth = OID(name=u'id-kp-clientAuth', mode=MODE_VALUE)
    id_kp_clientAuth._val = (1, 3, 6, 1, 5, 5, 7, 3, 2)
    
    #-----< id-kp-codeSigning >-----#
    id_kp_codeSigning = OID(name=u'id-kp-codeSigning', mode=MODE_VALUE)
    id_kp_codeSigning._val = (1, 3, 6, 1, 5, 5, 7, 3, 3)
    
    #-----< id-kp-emailProtection >-----#
    id_kp_emailProtection = OID(name=u'id-kp-emailProtection', mode=MODE_VALUE)
    id_kp_emailProtection._val = (1, 3, 6, 1, 5, 5, 7, 3, 4)
    
    #-----< id-kp-timeStamping >-----#
    id_kp_timeStamping = OID(name=u'id-kp-timeStamping', mode=MODE_VALUE)
    id_kp_timeStamping._val = (1, 3, 6, 1, 5, 5, 7, 3, 8)
    
    #-----< id-kp-OCSPSigning >-----#
    id_kp_OCSPSigning = OID(name=u'id-kp-OCSPSigning', mode=MODE_VALUE)
    id_kp_OCSPSigning._val = (1, 3, 6, 1, 5, 5, 7, 3, 9)
    
    #-----< ext-InhibitAnyPolicy >-----#
    ext_InhibitAnyPolicy = CLASS(name=u'ext-InhibitAnyPolicy', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_InhibitAnyPolicy_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SkipCerts')))
    ext_InhibitAnyPolicy._val = dict([(u'ExtnType', _ext_InhibitAnyPolicy_val_ExtnType), (u'id', (2, 5, 29, 54))])
    
    #-----< id-ce-inhibitAnyPolicy >-----#
    id_ce_inhibitAnyPolicy = OID(name=u'id-ce-inhibitAnyPolicy', mode=MODE_VALUE)
    id_ce_inhibitAnyPolicy._val = (2, 5, 29, 54)
    
    #-----< ext-FreshestCRL >-----#
    ext_FreshestCRL = CLASS(name=u'ext-FreshestCRL', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_FreshestCRL_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    ext_FreshestCRL._val = dict([(u'ExtnType', _ext_FreshestCRL_val_ExtnType), (u'id', (2, 5, 29, 46))])
    
    #-----< id-ce-freshestCRL >-----#
    id_ce_freshestCRL = OID(name=u'id-ce-freshestCRL', mode=MODE_VALUE)
    id_ce_freshestCRL._val = (2, 5, 29, 46)
    
    #-----< ext-AuthorityInfoAccess >-----#
    ext_AuthorityInfoAccess = CLASS(name=u'ext-AuthorityInfoAccess', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_AuthorityInfoAccess_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    ext_AuthorityInfoAccess._val = dict([(u'ExtnType', _ext_AuthorityInfoAccess_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))])
    
    #-----< id-pe-authorityInfoAccess >-----#
    id_pe_authorityInfoAccess = OID(name=u'id-pe-authorityInfoAccess', mode=MODE_VALUE)
    id_pe_authorityInfoAccess._val = (1, 3, 6, 1, 5, 5, 7, 1, 1)
    
    #-----< AuthorityInfoAccessSyntax >-----#
    AuthorityInfoAccessSyntax = SEQ_OF(name=u'AuthorityInfoAccessSyntax', mode=MODE_TYPE)
    _AuthorityInfoAccessSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AccessDescription')))
    AuthorityInfoAccessSyntax._cont = _AuthorityInfoAccessSyntax__item_
    AuthorityInfoAccessSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< AccessDescription >-----#
    AccessDescription = SEQ(name=u'AccessDescription', mode=MODE_TYPE)
    _AccessDescription_accessMethod = OID(name=u'accessMethod', mode=MODE_TYPE)
    _AccessDescription_accessLocation = CHOICE(name=u'accessLocation', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    AccessDescription._cont = ASN1Dict([
        (u'accessMethod', _AccessDescription_accessMethod),
        (u'accessLocation', _AccessDescription_accessLocation),
        ])
    AccessDescription._ext = None
    
    #-----< ext-SubjectInfoAccessSyntax >-----#
    ext_SubjectInfoAccessSyntax = CLASS(name=u'ext-SubjectInfoAccessSyntax', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_SubjectInfoAccessSyntax_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'SubjectInfoAccessSyntax')))
    ext_SubjectInfoAccessSyntax._val = dict([(u'ExtnType', _ext_SubjectInfoAccessSyntax_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 11))])
    
    #-----< id-pe-subjectInfoAccess >-----#
    id_pe_subjectInfoAccess = OID(name=u'id-pe-subjectInfoAccess', mode=MODE_VALUE)
    id_pe_subjectInfoAccess._val = (1, 3, 6, 1, 5, 5, 7, 1, 11)
    
    #-----< SubjectInfoAccessSyntax >-----#
    SubjectInfoAccessSyntax = SEQ_OF(name=u'SubjectInfoAccessSyntax', mode=MODE_TYPE)
    _SubjectInfoAccessSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AccessDescription')))
    SubjectInfoAccessSyntax._cont = _SubjectInfoAccessSyntax__item_
    SubjectInfoAccessSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< ext-CRLNumber >-----#
    ext_CRLNumber = CLASS(name=u'ext-CRLNumber', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_CRLNumber_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE)
    _ext_CRLNumber_val_ExtnType._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ext_CRLNumber._val = dict([(u'ExtnType', _ext_CRLNumber_val_ExtnType), (u'id', (2, 5, 29, 20))])
    
    #-----< id-ce-cRLNumber >-----#
    id_ce_cRLNumber = OID(name=u'id-ce-cRLNumber', mode=MODE_VALUE)
    id_ce_cRLNumber._val = (2, 5, 29, 20)
    
    #-----< CRLNumber >-----#
    CRLNumber = INT(name=u'CRLNumber', mode=MODE_TYPE)
    CRLNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< ext-IssuingDistributionPoint >-----#
    ext_IssuingDistributionPoint = CLASS(name=u'ext-IssuingDistributionPoint', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_IssuingDistributionPoint_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'IssuingDistributionPoint')))
    ext_IssuingDistributionPoint._val = dict([(u'ExtnType', _ext_IssuingDistributionPoint_val_ExtnType), (u'id', (2, 5, 29, 28))])
    
    #-----< id-ce-issuingDistributionPoint >-----#
    id_ce_issuingDistributionPoint = OID(name=u'id-ce-issuingDistributionPoint', mode=MODE_VALUE)
    id_ce_issuingDistributionPoint._val = (2, 5, 29, 28)
    
    #-----< IssuingDistributionPoint >-----#
    IssuingDistributionPoint = SEQ(name=u'IssuingDistributionPoint', mode=MODE_TYPE)
    _IssuingDistributionPoint_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'DistributionPointName')), opt=True)
    _IssuingDistributionPoint_onlyContainsUserCerts = BOOL(name=u'onlyContainsUserCerts', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistributionPoint_onlyContainsCACerts = BOOL(name=u'onlyContainsCACerts', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistributionPoint_onlySomeReasons = BIT_STR(name=u'onlySomeReasons', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'ReasonFlags')), opt=True)
    _IssuingDistributionPoint_indirectCRL = BOOL(name=u'indirectCRL', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistributionPoint_onlyContainsAttributeCerts = BOOL(name=u'onlyContainsAttributeCerts', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    IssuingDistributionPoint._cont = ASN1Dict([
        (u'distributionPoint', _IssuingDistributionPoint_distributionPoint),
        (u'onlyContainsUserCerts', _IssuingDistributionPoint_onlyContainsUserCerts),
        (u'onlyContainsCACerts', _IssuingDistributionPoint_onlyContainsCACerts),
        (u'onlySomeReasons', _IssuingDistributionPoint_onlySomeReasons),
        (u'indirectCRL', _IssuingDistributionPoint_indirectCRL),
        (u'onlyContainsAttributeCerts', _IssuingDistributionPoint_onlyContainsAttributeCerts),
        ])
    IssuingDistributionPoint._ext = None
    
    #-----< ext-DeltaCRLIndicator >-----#
    ext_DeltaCRLIndicator = CLASS(name=u'ext-DeltaCRLIndicator', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_DeltaCRLIndicator_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLNumber')))
    ext_DeltaCRLIndicator._val = dict([(u'ExtnType', _ext_DeltaCRLIndicator_val_ExtnType), (u'id', (2, 5, 29, 27))])
    
    #-----< id-ce-deltaCRLIndicator >-----#
    id_ce_deltaCRLIndicator = OID(name=u'id-ce-deltaCRLIndicator', mode=MODE_VALUE)
    id_ce_deltaCRLIndicator._val = (2, 5, 29, 27)
    
    #-----< ext-CRLReason >-----#
    ext_CRLReason = CLASS(name=u'ext-CRLReason', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_CRLReason_val_ExtnType = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLReason')))
    ext_CRLReason._val = dict([(u'ExtnType', _ext_CRLReason_val_ExtnType), (u'id', (2, 5, 29, 21))])
    
    #-----< id-ce-cRLReasons >-----#
    id_ce_cRLReasons = OID(name=u'id-ce-cRLReasons', mode=MODE_VALUE)
    id_ce_cRLReasons._val = (2, 5, 29, 21)
    
    #-----< CRLReason >-----#
    CRLReason = ENUM(name=u'CRLReason', mode=MODE_TYPE)
    CRLReason._cont = ASN1Dict([(u'unspecified', 0), (u'keyCompromise', 1), (u'cACompromise', 2), (u'affiliationChanged', 3), (u'superseded', 4), (u'cessationOfOperation', 5), (u'certificateHold', 6), (u'removeFromCRL', 8), (u'privilegeWithdrawn', 9), (u'aACompromise', 10)])
    CRLReason._ext = None
    
    #-----< ext-CertificateIssuer >-----#
    ext_CertificateIssuer = CLASS(name=u'ext-CertificateIssuer', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_CertificateIssuer_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    ext_CertificateIssuer._val = dict([(u'ExtnType', _ext_CertificateIssuer_val_ExtnType), (u'id', (2, 5, 29, 29))])
    
    #-----< id-ce-certificateIssuer >-----#
    id_ce_certificateIssuer = OID(name=u'id-ce-certificateIssuer', mode=MODE_VALUE)
    id_ce_certificateIssuer._val = (2, 5, 29, 29)
    
    #-----< ext-HoldInstructionCode >-----#
    ext_HoldInstructionCode = CLASS(name=u'ext-HoldInstructionCode', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_HoldInstructionCode_val_ExtnType = OID(name=u'ExtnType', mode=MODE_TYPE)
    ext_HoldInstructionCode._val = dict([(u'ExtnType', _ext_HoldInstructionCode_val_ExtnType), (u'id', (2, 5, 29, 23))])
    
    #-----< id-ce-holdInstructionCode >-----#
    id_ce_holdInstructionCode = OID(name=u'id-ce-holdInstructionCode', mode=MODE_VALUE)
    id_ce_holdInstructionCode._val = (2, 5, 29, 23)
    
    #-----< holdInstruction >-----#
    holdInstruction = OID(name=u'holdInstruction', mode=MODE_VALUE)
    holdInstruction._val = (2, 2, 840, 10040, 2)
    
    #-----< id-holdinstruction-none >-----#
    id_holdinstruction_none = OID(name=u'id-holdinstruction-none', mode=MODE_VALUE)
    id_holdinstruction_none._val = (2, 2, 840, 10040, 2, 1)
    
    #-----< id-holdinstruction-callissuer >-----#
    id_holdinstruction_callissuer = OID(name=u'id-holdinstruction-callissuer', mode=MODE_VALUE)
    id_holdinstruction_callissuer._val = (2, 2, 840, 10040, 2, 2)
    
    #-----< id-holdinstruction-reject >-----#
    id_holdinstruction_reject = OID(name=u'id-holdinstruction-reject', mode=MODE_VALUE)
    id_holdinstruction_reject._val = (2, 2, 840, 10040, 2, 3)
    
    #-----< ext-InvalidityDate >-----#
    ext_InvalidityDate = CLASS(name=u'ext-InvalidityDate', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_InvalidityDate_val_ExtnType = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    ext_InvalidityDate._val = dict([(u'ExtnType', _ext_InvalidityDate_val_ExtnType), (u'id', (2, 5, 29, 24))])
    
    #-----< id-ce-invalidityDate >-----#
    id_ce_invalidityDate = OID(name=u'id-ce-invalidityDate', mode=MODE_VALUE)
    id_ce_invalidityDate._val = (2, 5, 29, 24)
    
    #-----< ubMax >-----#
    ubMax = INT(name=u'ubMax', mode=MODE_VALUE)
    ubMax._val = 32768
    
    _all_ = [
        CertExtensions,
        _CertExtensions_val_ExtnType_0,
        _CertExtensions_val_ExtnType_1,
        _CertExtensions_val_ExtnType_2,
        _CertExtensions_val_ExtnType_3,
        _CertExtensions_val_ExtnType_4,
        _CertExtensions_val_ExtnType_5,
        _CertExtensions_val_ExtnType_6,
        _CertExtensions_val_ExtnType_7,
        _CertExtensions_val_ExtnType_8,
        _CertExtensions_val_ExtnType_9,
        _CertExtensions_val_ExtnType_10,
        _CertExtensions_val_ExtnType_11,
        _CertExtensions_val_ExtnType_12,
        _CertExtensions_val_ExtnType_13,
        _CertExtensions_val_ExtnType_14,
        _CertExtensions_val_ExtnType_15,
        _CertExtensions_val_ExtnType_16,
        _CertExtensions_val_ExtnType_17,
        CrlExtensions,
        _CrlExtensions_val_ExtnType_0,
        _CrlExtensions_val_ExtnType_1,
        _CrlExtensions_val_ExtnType_2,
        _CrlExtensions_val_ExtnType_3,
        _CrlExtensions_val_ExtnType_4,
        _CrlExtensions_val_ExtnType_5,
        CrlEntryExtensions,
        _CrlEntryExtensions_val_ExtnType_0,
        _CrlEntryExtensions_val_ExtnType_1,
        _CrlEntryExtensions_val_ExtnType_2,
        _CrlEntryExtensions_val_ExtnType_3,
        id_ce,
        ext_AuthorityKeyIdentifier,
        _ext_AuthorityKeyIdentifier_val_ExtnType,
        id_ce_authorityKeyIdentifier,
        _AuthorityKeyIdentifier_keyIdentifier,
        _AuthorityKeyIdentifier_authorityCertIssuer,
        _AuthorityKeyIdentifier_authorityCertSerialNumber,
        AuthorityKeyIdentifier,
        KeyIdentifier,
        ext_SubjectKeyIdentifier,
        _ext_SubjectKeyIdentifier_val_ExtnType,
        id_ce_subjectKeyIdentifier,
        ext_KeyUsage,
        _ext_KeyUsage_val_ExtnType,
        id_ce_keyUsage,
        KeyUsage,
        ext_PrivateKeyUsagePeriod,
        _ext_PrivateKeyUsagePeriod_val_ExtnType,
        id_ce_privateKeyUsagePeriod,
        _PrivateKeyUsagePeriod_notBefore,
        _PrivateKeyUsagePeriod_notAfter,
        PrivateKeyUsagePeriod,
        ext_CertificatePolicies,
        _ext_CertificatePolicies_val_ExtnType,
        id_ce_certificatePolicies,
        _CertificatePolicies__item_,
        CertificatePolicies,
        _PolicyInformation_policyIdentifier,
        __PolicyInformation_policyQualifiers__item_,
        _PolicyInformation_policyQualifiers,
        PolicyInformation,
        CertPolicyId,
        CERT_POLICY_QUALIFIER,
        __PolicyQualifierInfo_policyQualifierId_tab,
        ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_0,
        ___PolicyQualifierInfo_policyQualifierId_tab_val_Type_1,
        _PolicyQualifierInfo_policyQualifierId,
        _PolicyQualifierInfo_qualifier,
        PolicyQualifierInfo,
        PolicyQualifierId,
        _PolicyQualifierId_val_Type_0,
        _PolicyQualifierId_val_Type_1,
        pqid_cps,
        _pqid_cps_val_Type,
        pqid_unotice,
        _pqid_unotice_val_Type,
        CPSuri,
        _UserNotice_noticeRef,
        _UserNotice_explicitText,
        UserNotice,
        _NoticeReference_organization,
        __NoticeReference_noticeNumbers__item_,
        _NoticeReference_noticeNumbers,
        NoticeReference,
        _DisplayText_ia5String,
        _DisplayText_visibleString,
        _DisplayText_bmpString,
        _DisplayText_utf8String,
        DisplayText,
        ext_PolicyMappings,
        _ext_PolicyMappings_val_ExtnType,
        id_ce_policyMappings,
        __PolicyMappings__item__issuerDomainPolicy,
        __PolicyMappings__item__subjectDomainPolicy,
        _PolicyMappings__item_,
        PolicyMappings,
        ext_SubjectAltName,
        _ext_SubjectAltName_val_ExtnType,
        id_ce_subjectAltName,
        _GeneralNames__item_,
        GeneralNames,
        __GeneralName_otherName_type_id,
        __GeneralName_otherName_value,
        _GeneralName_otherName,
        _GeneralName_otherName,
        _GeneralName_rfc822Name,
        _GeneralName_dNSName,
        _GeneralName_x400Address,
        _GeneralName_directoryName,
        _GeneralName_ediPartyName,
        _GeneralName_uniformResourceIdentifier,
        _GeneralName_iPAddress,
        _GeneralName_registeredID,
        GeneralName,
        OTHER_NAME,
        __EDIPartyName_nameAssigner_teletexString,
        __EDIPartyName_nameAssigner_printableString,
        __EDIPartyName_nameAssigner_bmpString,
        __EDIPartyName_nameAssigner_universalString,
        __EDIPartyName_nameAssigner_uTF8String,
        _EDIPartyName_nameAssigner,
        __EDIPartyName_partyName_teletexString,
        __EDIPartyName_partyName_printableString,
        __EDIPartyName_partyName_bmpString,
        __EDIPartyName_partyName_universalString,
        __EDIPartyName_partyName_uTF8String,
        _EDIPartyName_partyName,
        EDIPartyName,
        ext_IssuerAltName,
        _ext_IssuerAltName_val_ExtnType,
        id_ce_issuerAltName,
        ext_SubjectDirectoryAttributes,
        _ext_SubjectDirectoryAttributes_val_ExtnType,
        id_ce_subjectDirectoryAttributes,
        ___SubjectDirectoryAttributes__item__type_tab,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_0,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_1,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_2,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_3,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_4,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_5,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_6,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_teletexString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_printableString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_bmpString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_universalString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_7_uTF8String,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_7,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_teletexString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_printableString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_bmpString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_universalString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_8_uTF8String,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_8,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_teletexString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_printableString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_bmpString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_universalString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_9_uTF8String,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_9,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_teletexString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_printableString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_bmpString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_universalString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_10_uTF8String,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_10,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_11,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_12,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_13,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_teletexString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_printableString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_bmpString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_universalString,
        _____SubjectDirectoryAttributes__item__type_tab_val_Type_14_uTF8String,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_14,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_15,
        ____SubjectDirectoryAttributes__item__type_tab_val_Type_16,
        __SubjectDirectoryAttributes__item__type,
        ___SubjectDirectoryAttributes__item__values__item_,
        __SubjectDirectoryAttributes__item__values,
        _SubjectDirectoryAttributes__item_,
        SubjectDirectoryAttributes,
        ext_BasicConstraints,
        _ext_BasicConstraints_val_ExtnType,
        id_ce_basicConstraints,
        _BasicConstraints_cA,
        _BasicConstraints_pathLenConstraint,
        BasicConstraints,
        ext_NameConstraints,
        _ext_NameConstraints_val_ExtnType,
        id_ce_nameConstraints,
        _NameConstraints_permittedSubtrees,
        _NameConstraints_excludedSubtrees,
        NameConstraints,
        _GeneralSubtrees__item_,
        GeneralSubtrees,
        _GeneralSubtree_base,
        _GeneralSubtree_minimum,
        _GeneralSubtree_maximum,
        GeneralSubtree,
        BaseDistance,
        ext_PolicyConstraints,
        _ext_PolicyConstraints_val_ExtnType,
        id_ce_policyConstraints,
        _PolicyConstraints_requireExplicitPolicy,
        _PolicyConstraints_inhibitPolicyMapping,
        PolicyConstraints,
        SkipCerts,
        ext_CRLDistributionPoints,
        _ext_CRLDistributionPoints_val_ExtnType,
        id_ce_cRLDistributionPoints,
        _CRLDistributionPoints__item_,
        CRLDistributionPoints,
        _DistributionPoint_distributionPoint,
        _DistributionPoint_reasons,
        _DistributionPoint_cRLIssuer,
        DistributionPoint,
        _DistributionPointName_fullName,
        _DistributionPointName_nameRelativeToCRLIssuer,
        DistributionPointName,
        ReasonFlags,
        ext_ExtKeyUsage,
        _ext_ExtKeyUsage_val_ExtnType,
        id_ce_extKeyUsage,
        _ExtKeyUsageSyntax__item_,
        ExtKeyUsageSyntax,
        KeyPurposeId,
        anyExtendedKeyUsage,
        id_kp_serverAuth,
        id_kp_clientAuth,
        id_kp_codeSigning,
        id_kp_emailProtection,
        id_kp_timeStamping,
        id_kp_OCSPSigning,
        ext_InhibitAnyPolicy,
        _ext_InhibitAnyPolicy_val_ExtnType,
        id_ce_inhibitAnyPolicy,
        ext_FreshestCRL,
        _ext_FreshestCRL_val_ExtnType,
        id_ce_freshestCRL,
        ext_AuthorityInfoAccess,
        _ext_AuthorityInfoAccess_val_ExtnType,
        id_pe_authorityInfoAccess,
        _AuthorityInfoAccessSyntax__item_,
        AuthorityInfoAccessSyntax,
        _AccessDescription_accessMethod,
        _AccessDescription_accessLocation,
        AccessDescription,
        ext_SubjectInfoAccessSyntax,
        _ext_SubjectInfoAccessSyntax_val_ExtnType,
        id_pe_subjectInfoAccess,
        _SubjectInfoAccessSyntax__item_,
        SubjectInfoAccessSyntax,
        ext_CRLNumber,
        _ext_CRLNumber_val_ExtnType,
        id_ce_cRLNumber,
        CRLNumber,
        ext_IssuingDistributionPoint,
        _ext_IssuingDistributionPoint_val_ExtnType,
        id_ce_issuingDistributionPoint,
        _IssuingDistributionPoint_distributionPoint,
        _IssuingDistributionPoint_onlyContainsUserCerts,
        _IssuingDistributionPoint_onlyContainsCACerts,
        _IssuingDistributionPoint_onlySomeReasons,
        _IssuingDistributionPoint_indirectCRL,
        _IssuingDistributionPoint_onlyContainsAttributeCerts,
        IssuingDistributionPoint,
        ext_DeltaCRLIndicator,
        _ext_DeltaCRLIndicator_val_ExtnType,
        id_ce_deltaCRLIndicator,
        ext_CRLReason,
        _ext_CRLReason_val_ExtnType,
        id_ce_cRLReasons,
        CRLReason,
        ext_CertificateIssuer,
        _ext_CertificateIssuer_val_ExtnType,
        id_ce_certificateIssuer,
        ext_HoldInstructionCode,
        _ext_HoldInstructionCode_val_ExtnType,
        id_ce_holdInstructionCode,
        holdInstruction,
        id_holdinstruction_none,
        id_holdinstruction_callissuer,
        id_holdinstruction_reject,
        ext_InvalidityDate,
        _ext_InvalidityDate_val_ExtnType,
        id_ce_invalidityDate,
        ubMax,
    ]

class PKIX1_PSS_OAEP_Algorithms_2009:

    _name_  = u'PKIX1-PSS-OAEP-Algorithms-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 54]
    
    _obj_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'KeyTransportAlgs',
        u'HashAlgs',
        u'SMimeCaps',
        u'pk-rsaSSA-PSS',
        u'sa-rsaSSA-PSS',
        u'sa-sha224WithRSAEncryption',
        u'sha224WithRSAEncryption',
        u'sa-sha256WithRSAEncryption',
        u'sha256WithRSAEncryption',
        u'sa-sha384WithRSAEncryption',
        u'sha384WithRSAEncryption',
        u'sa-sha512WithRSAEncryption',
        u'sha512WithRSAEncryption',
        u'pk-rsaES-OAEP',
        u'kta-rsaES-OAEP',
        u'pkcs-1',
        u'id-RSAES-OAEP',
        u'id-mgf1',
        u'id-pSpecified',
        u'id-RSASSA-PSS',
        u'id-sha224',
        u'mda-sha224',
        u'id-sha256',
        u'mda-sha256',
        u'id-sha384',
        u'mda-sha384',
        u'id-sha512',
        u'mda-sha512',
        u'EncodingParameters',
        u'nullOctetString',
        u'nullParameters',
        u'HashAlgorithm',
        u'HashAlgorithms',
        u'sha1Identifier',
        u'MaskGenAlgorithm',
        u'mgf1SHA1',
        u'PKCS1MGFAlgorithms',
        u'PSourceAlgorithm',
        u'PSS-SourceAlgorithms',
        u'pSpecifiedEmpty',
        u'RSASSA-PSS-params',
        u'RSAES-OAEP-params',
        ]
    _type_ = [
        u'EncodingParameters',
        u'HashAlgorithm',
        u'MaskGenAlgorithm',
        u'PSourceAlgorithm',
        u'RSASSA-PSS-params',
        u'RSAES-OAEP-params',
        ]
    _set_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'KeyTransportAlgs',
        u'HashAlgs',
        u'SMimeCaps',
        u'HashAlgorithms',
        u'PKCS1MGFAlgorithms',
        u'PSS-SourceAlgorithms',
        ]
    _val_ = [
        u'pk-rsaSSA-PSS',
        u'sa-rsaSSA-PSS',
        u'sa-sha224WithRSAEncryption',
        u'sha224WithRSAEncryption',
        u'sa-sha256WithRSAEncryption',
        u'sha256WithRSAEncryption',
        u'sa-sha384WithRSAEncryption',
        u'sha384WithRSAEncryption',
        u'sa-sha512WithRSAEncryption',
        u'sha512WithRSAEncryption',
        u'pk-rsaES-OAEP',
        u'kta-rsaES-OAEP',
        u'pkcs-1',
        u'id-RSAES-OAEP',
        u'id-mgf1',
        u'id-pSpecified',
        u'id-RSASSA-PSS',
        u'id-sha224',
        u'mda-sha224',
        u'id-sha256',
        u'mda-sha256',
        u'id-sha384',
        u'mda-sha384',
        u'id-sha512',
        u'mda-sha512',
        u'nullOctetString',
        u'nullParameters',
        u'sha1Identifier',
        u'mgf1SHA1',
        u'pSpecifiedEmpty',
        ]
    _class_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'KeyTransportAlgs',
        u'HashAlgs',
        u'SMimeCaps',
        u'pk-rsaSSA-PSS',
        u'sa-rsaSSA-PSS',
        u'sa-sha224WithRSAEncryption',
        u'sa-sha256WithRSAEncryption',
        u'sa-sha384WithRSAEncryption',
        u'sa-sha512WithRSAEncryption',
        u'pk-rsaES-OAEP',
        u'kta-rsaES-OAEP',
        u'mda-sha224',
        u'mda-sha256',
        u'mda-sha384',
        u'mda-sha512',
        u'HashAlgorithms',
        u'PKCS1MGFAlgorithms',
        u'PSS-SourceAlgorithms',
        ]
    _param_ = [
        ]
    
    #-----< PublicKeys >-----#
    PublicKeys = CLASS(name=u'PublicKeys', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _PublicKeys_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeys_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    _PublicKeys_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeys_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    PublicKeys._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', _PublicKeys_val_KeyValue_0), (u'Params', _PublicKeys_val_Params_0), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', _PublicKeys_val_KeyValue_1), (u'Params', _PublicKeys_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], rr=[], ev=[], er=[])
    
    #-----< SignatureAlgs >-----#
    SignatureAlgs = CLASS(name=u'SignatureAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _SignatureAlgs_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    SignatureAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', _SignatureAlgs_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], rr=[], ev=[], er=[])
    
    #-----< KeyTransportAlgs >-----#
    KeyTransportAlgs = CLASS(name=u'KeyTransportAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    _KeyTransportAlgs_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __KEY_TRANSPORT_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __KEY_TRANSPORT_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __KEY_TRANSPORT_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    __KEY_TRANSPORT_smimeCaps_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    KeyTransportAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'Params', _KeyTransportAlgs_val_Params_0), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_1), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'Type', __KEY_TRANSPORT_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 7))]))])], rr=[], ev=[], er=[])
    
    #-----< HashAlgs >-----#
    HashAlgs = CLASS(name=u'HashAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _HashAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgs_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgs_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgs_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    HashAlgs._val = ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', _HashAlgs_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', _HashAlgs_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', _HashAlgs_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', _HashAlgs_val_Params_3), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=[], er=[])
    
    #-----< SMimeCaps >-----#
    SMimeCaps = CLASS(name=u'SMimeCaps', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    _SMimeCaps_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    SMimeCaps._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]), dict([(u'Type', _SMimeCaps_val_Type_1), (u'id', (1, 2, 840, 113549, 1, 1, 7))])], rr=[], ev=[], er=[])
    
    #-----< pk-rsaSSA-PSS >-----#
    pk_rsaSSA_PSS = CLASS(name=u'pk-rsaSSA-PSS', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_rsaSSA_PSS_val_KeyValue = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _pk_rsaSSA_PSS_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    pk_rsaSSA_PSS._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', _pk_rsaSSA_PSS_val_KeyValue), (u'Params', _pk_rsaSSA_PSS_val_Params), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])
    
    #-----< sa-rsaSSA-PSS >-----#
    sa_rsaSSA_PSS = CLASS(name=u'sa-rsaSSA-PSS', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_rsaSSA_PSS_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    sa_rsaSSA_PSS._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', _sa_rsaSSA_PSS_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])
    
    #-----< sa-sha224WithRSAEncryption >-----#
    sa_sha224WithRSAEncryption = CLASS(name=u'sa-sha224WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_sha224WithRSAEncryption_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_sha224WithRSAEncryption._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 14)), (u'Params', _sa_sha224WithRSAEncryption_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 14))]))])
    
    #-----< sha224WithRSAEncryption >-----#
    sha224WithRSAEncryption = OID(name=u'sha224WithRSAEncryption', mode=MODE_VALUE)
    sha224WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 14)
    
    #-----< sa-sha256WithRSAEncryption >-----#
    sa_sha256WithRSAEncryption = CLASS(name=u'sa-sha256WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_sha256WithRSAEncryption_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_sha256WithRSAEncryption._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 11)), (u'Params', _sa_sha256WithRSAEncryption_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 11))]))])
    
    #-----< sha256WithRSAEncryption >-----#
    sha256WithRSAEncryption = OID(name=u'sha256WithRSAEncryption', mode=MODE_VALUE)
    sha256WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 11)
    
    #-----< sa-sha384WithRSAEncryption >-----#
    sa_sha384WithRSAEncryption = CLASS(name=u'sa-sha384WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_sha384WithRSAEncryption_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_sha384WithRSAEncryption._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 12)), (u'Params', _sa_sha384WithRSAEncryption_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 12))]))])
    
    #-----< sha384WithRSAEncryption >-----#
    sha384WithRSAEncryption = OID(name=u'sha384WithRSAEncryption', mode=MODE_VALUE)
    sha384WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 12)
    
    #-----< sa-sha512WithRSAEncryption >-----#
    sa_sha512WithRSAEncryption = CLASS(name=u'sa-sha512WithRSAEncryption', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_sha512WithRSAEncryption_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_sha512WithRSAEncryption._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 13)), (u'Params', _sa_sha512WithRSAEncryption_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 13))]))])
    
    #-----< sha512WithRSAEncryption >-----#
    sha512WithRSAEncryption = OID(name=u'sha512WithRSAEncryption', mode=MODE_VALUE)
    sha512WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 13)
    
    #-----< pk-rsaES-OAEP >-----#
    pk_rsaES_OAEP = CLASS(name=u'pk-rsaES-OAEP', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_rsaES_OAEP_val_KeyValue = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _pk_rsaES_OAEP_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    pk_rsaES_OAEP._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', _pk_rsaES_OAEP_val_KeyValue), (u'Params', _pk_rsaES_OAEP_val_Params), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])
    
    #-----< kta-rsaES-OAEP >-----#
    kta_rsaES_OAEP = CLASS(name=u'kta-rsaES-OAEP', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'KEY-TRANSPORT')))
    _kta_rsaES_OAEP_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSAES-OAEP-params')))
    kta_rsaES_OAEP._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'Params', _kta_rsaES_OAEP_val_Params), (u'paramPresence', u'required'), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 7)), (u'KeyValue', __KEY_TRANSPORT_PublicKeySet_val_KeyValue_1), (u'Params', __KEY_TRANSPORT_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (3, 4))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'Type', __KEY_TRANSPORT_smimeCaps_val_Type), (u'id', (1, 2, 840, 113549, 1, 1, 7))]))])
    
    #-----< pkcs-1 >-----#
    pkcs_1 = OID(name=u'pkcs-1', mode=MODE_VALUE)
    pkcs_1._val = (1, 2, 840, 113549, 1, 1)
    
    #-----< id-RSAES-OAEP >-----#
    id_RSAES_OAEP = OID(name=u'id-RSAES-OAEP', mode=MODE_VALUE)
    id_RSAES_OAEP._val = (1, 2, 840, 113549, 1, 1, 7)
    
    #-----< id-mgf1 >-----#
    id_mgf1 = OID(name=u'id-mgf1', mode=MODE_VALUE)
    id_mgf1._val = (1, 2, 840, 113549, 1, 1, 8)
    
    #-----< id-pSpecified >-----#
    id_pSpecified = OID(name=u'id-pSpecified', mode=MODE_VALUE)
    id_pSpecified._val = (1, 2, 840, 113549, 1, 1, 9)
    
    #-----< id-RSASSA-PSS >-----#
    id_RSASSA_PSS = OID(name=u'id-RSASSA-PSS', mode=MODE_VALUE)
    id_RSASSA_PSS._val = (1, 2, 840, 113549, 1, 1, 10)
    
    #-----< id-sha224 >-----#
    id_sha224 = OID(name=u'id-sha224', mode=MODE_VALUE)
    id_sha224._val = (2, 16, 840, 1, 101, 3, 4, 2, 4)
    
    #-----< mda-sha224 >-----#
    mda_sha224 = CLASS(name=u'mda-sha224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_sha224_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_sha224._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', _mda_sha224_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-sha256 >-----#
    id_sha256 = OID(name=u'id-sha256', mode=MODE_VALUE)
    id_sha256._val = (2, 16, 840, 1, 101, 3, 4, 2, 1)
    
    #-----< mda-sha256 >-----#
    mda_sha256 = CLASS(name=u'mda-sha256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_sha256_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_sha256._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', _mda_sha256_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-sha384 >-----#
    id_sha384 = OID(name=u'id-sha384', mode=MODE_VALUE)
    id_sha384._val = (2, 16, 840, 1, 101, 3, 4, 2, 2)
    
    #-----< mda-sha384 >-----#
    mda_sha384 = CLASS(name=u'mda-sha384', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_sha384_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_sha384._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', _mda_sha384_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-sha512 >-----#
    id_sha512 = OID(name=u'id-sha512', mode=MODE_VALUE)
    id_sha512._val = (2, 16, 840, 1, 101, 3, 4, 2, 3)
    
    #-----< mda-sha512 >-----#
    mda_sha512 = CLASS(name=u'mda-sha512', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_sha512_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_sha512._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', _mda_sha512_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< EncodingParameters >-----#
    EncodingParameters = OCT_STR(name=u'EncodingParameters', mode=MODE_TYPE)
    EncodingParameters._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< nullOctetString >-----#
    nullOctetString = OCT_STR(name=u'nullOctetString', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'EncodingParameters')))
    nullOctetString._val = b''
    
    #-----< nullParameters >-----#
    nullParameters = NULL(name=u'nullParameters', mode=MODE_VALUE)
    nullParameters._val = 0
    
    #-----< HashAlgorithm >-----#
    HashAlgorithm = SEQ(name=u'HashAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _HashAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    __HashAlgorithm_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___HashAlgorithm_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ___HashAlgorithm_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ___HashAlgorithm_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ___HashAlgorithm_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ___HashAlgorithm_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __HashAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', ___HashAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', ___HashAlgorithm_algorithm_tab_val_Params_1), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', ___HashAlgorithm_algorithm_tab_val_Params_2), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', ___HashAlgorithm_algorithm_tab_val_Params_3), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', ___HashAlgorithm_algorithm_tab_val_Params_4), (u'paramPresence', u'preferredPresent')])], rr=[], ev=None, er=[])
    _HashAlgorithm_algorithm._const_tab = __HashAlgorithm_algorithm_tab
    _HashAlgorithm_algorithm._const_tab_at = None
    _HashAlgorithm_algorithm._const_tab_id = u'id'
    _HashAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    _HashAlgorithm_parameters._const_tab = __HashAlgorithm_algorithm_tab
    _HashAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _HashAlgorithm_parameters._const_tab_id = u'Params'
    HashAlgorithm._cont = ASN1Dict([
        (u'algorithm', _HashAlgorithm_algorithm),
        (u'parameters', _HashAlgorithm_parameters),
        ])
    HashAlgorithm._ext = None
    
    #-----< HashAlgorithms >-----#
    HashAlgorithms = CLASS(name=u'HashAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _HashAlgorithms_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgorithms_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgorithms_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgorithms_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgorithms_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    HashAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', _HashAlgorithms_val_Params_0), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', _HashAlgorithms_val_Params_1), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', _HashAlgorithms_val_Params_2), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', _HashAlgorithms_val_Params_3), (u'paramPresence', u'preferredPresent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', _HashAlgorithms_val_Params_4), (u'paramPresence', u'preferredPresent')])], rr=[], ev=None, er=[])
    
    #-----< sha1Identifier >-----#
    sha1Identifier = SEQ(name=u'sha1Identifier', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')))
    _parameters_val = NULL(name=u'parameters', mode=MODE_TYPE)
    sha1Identifier._val = dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))])
    
    #-----< MaskGenAlgorithm >-----#
    MaskGenAlgorithm = SEQ(name=u'MaskGenAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _MaskGenAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'id']))
    __MaskGenAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    ___MaskGenAlgorithm_algorithm_tab_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')))
    __MaskGenAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 8)), (u'Params', ___MaskGenAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=None, er=[])
    _MaskGenAlgorithm_algorithm._const_tab = __MaskGenAlgorithm_algorithm_tab
    _MaskGenAlgorithm_algorithm._const_tab_at = None
    _MaskGenAlgorithm_algorithm._const_tab_id = u'id'
    _MaskGenAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'Params']), opt=True)
    _MaskGenAlgorithm_parameters._const_tab = __MaskGenAlgorithm_algorithm_tab
    _MaskGenAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _MaskGenAlgorithm_parameters._const_tab_id = u'Params'
    MaskGenAlgorithm._cont = ASN1Dict([
        (u'algorithm', _MaskGenAlgorithm_algorithm),
        (u'parameters', _MaskGenAlgorithm_parameters),
        ])
    MaskGenAlgorithm._ext = None
    
    #-----< mgf1SHA1 >-----#
    mgf1SHA1 = SEQ(name=u'mgf1SHA1', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'MaskGenAlgorithm')))
    _parameters_val_0 = SEQ(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')))
    mgf1SHA1._val = dict([(u'algorithm', (1, 2, 840, 113549, 1, 1, 8)), (u'parameters', (_parameters_val_0, dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))])))])
    
    #-----< PKCS1MGFAlgorithms >-----#
    PKCS1MGFAlgorithms = CLASS(name=u'PKCS1MGFAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    _PKCS1MGFAlgorithms_val_Params_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')))
    PKCS1MGFAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 8)), (u'Params', _PKCS1MGFAlgorithms_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=[], er=[])
    
    #-----< PSourceAlgorithm >-----#
    PSourceAlgorithm = SEQ(name=u'PSourceAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    _PSourceAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'id']))
    __PSourceAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    ___PSourceAlgorithm_algorithm_tab_val_Params_0 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'EncodingParameters')))
    __PSourceAlgorithm_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 9)), (u'Params', ___PSourceAlgorithm_algorithm_tab_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=None, er=[])
    _PSourceAlgorithm_algorithm._const_tab = __PSourceAlgorithm_algorithm_tab
    _PSourceAlgorithm_algorithm._const_tab_at = None
    _PSourceAlgorithm_algorithm._const_tab_id = u'id'
    _PSourceAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'Params']), opt=True)
    _PSourceAlgorithm_parameters._const_tab = __PSourceAlgorithm_algorithm_tab
    _PSourceAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    _PSourceAlgorithm_parameters._const_tab_id = u'Params'
    PSourceAlgorithm._cont = ASN1Dict([
        (u'algorithm', _PSourceAlgorithm_algorithm),
        (u'parameters', _PSourceAlgorithm_parameters),
        ])
    PSourceAlgorithm._ext = None
    
    #-----< PSS-SourceAlgorithms >-----#
    PSS_SourceAlgorithms = CLASS(name=u'PSS-SourceAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    _PSS_SourceAlgorithms_val_Params_0 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'EncodingParameters')))
    PSS_SourceAlgorithms._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 9)), (u'Params', _PSS_SourceAlgorithms_val_Params_0), (u'paramPresence', u'required')])], rr=[], ev=[], er=[])
    
    #-----< pSpecifiedEmpty >-----#
    pSpecifiedEmpty = SEQ(name=u'pSpecifiedEmpty', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'PSourceAlgorithm')))
    _parameters_val_1 = OCT_STR(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'EncodingParameters')))
    pSpecifiedEmpty._val = dict([(u'algorithm', (1, 2, 840, 113549, 1, 1, 9)), (u'parameters', (_parameters_val_1, b''))])
    
    #-----< RSASSA-PSS-params >-----#
    RSASSA_PSS_params = SEQ(name=u'RSASSA-PSS-params', mode=MODE_TYPE)
    _RSASSA_PSS_params_hashAlgorithm = SEQ(name=u'hashAlgorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')), default=dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))]))
    _RSASSA_PSS_params_maskGenAlgorithm = SEQ(name=u'maskGenAlgorithm', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'MaskGenAlgorithm')), default=dict([(u'algorithm', (1, 2, 840, 113549, 1, 1, 8)), (u'parameters', (_parameters_val_0, dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))])))]))
    _RSASSA_PSS_params_saltLength = INT(name=u'saltLength', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=20)
    _RSASSA_PSS_params_trailerField = INT(name=u'trailerField', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    RSASSA_PSS_params._cont = ASN1Dict([
        (u'hashAlgorithm', _RSASSA_PSS_params_hashAlgorithm),
        (u'maskGenAlgorithm', _RSASSA_PSS_params_maskGenAlgorithm),
        (u'saltLength', _RSASSA_PSS_params_saltLength),
        (u'trailerField', _RSASSA_PSS_params_trailerField),
        ])
    RSASSA_PSS_params._ext = None
    
    #-----< RSAES-OAEP-params >-----#
    RSAES_OAEP_params = SEQ(name=u'RSAES-OAEP-params', mode=MODE_TYPE)
    _RSAES_OAEP_params_hashFunc = SEQ(name=u'hashFunc', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'HashAlgorithm')), default=dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))]))
    _RSAES_OAEP_params_maskGenFunc = SEQ(name=u'maskGenFunc', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'MaskGenAlgorithm')), default=dict([(u'algorithm', (1, 2, 840, 113549, 1, 1, 8)), (u'parameters', (_parameters_val_0, dict([(u'algorithm', (1, 3, 14, 3, 2, 26)), (u'parameters', (_parameters_val, 0))])))]))
    _RSAES_OAEP_params_pSourceFunc = SEQ(name=u'pSourceFunc', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'PSourceAlgorithm')), default=dict([(u'algorithm', (1, 2, 840, 113549, 1, 1, 9)), (u'parameters', (_parameters_val_1, b''))]))
    RSAES_OAEP_params._cont = ASN1Dict([
        (u'hashFunc', _RSAES_OAEP_params_hashFunc),
        (u'maskGenFunc', _RSAES_OAEP_params_maskGenFunc),
        (u'pSourceFunc', _RSAES_OAEP_params_pSourceFunc),
        ])
    RSAES_OAEP_params._ext = None
    
    _all_ = [
        PublicKeys,
        _PublicKeys_val_KeyValue_0,
        _PublicKeys_val_Params_0,
        _PublicKeys_val_KeyValue_1,
        _PublicKeys_val_Params_1,
        SignatureAlgs,
        _SignatureAlgs_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_1,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_2,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_3,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1,
        KeyTransportAlgs,
        _KeyTransportAlgs_val_Params_0,
        __KEY_TRANSPORT_PublicKeySet_val_KeyValue_0,
        __KEY_TRANSPORT_PublicKeySet_val_Params_0,
        __KEY_TRANSPORT_PublicKeySet_val_KeyValue_1,
        __KEY_TRANSPORT_PublicKeySet_val_Params_1,
        __KEY_TRANSPORT_smimeCaps_val_Type,
        HashAlgs,
        _HashAlgs_val_Params_0,
        _HashAlgs_val_Params_1,
        _HashAlgs_val_Params_2,
        _HashAlgs_val_Params_3,
        SMimeCaps,
        _SMimeCaps_val_Type_1,
        pk_rsaSSA_PSS,
        _pk_rsaSSA_PSS_val_KeyValue,
        _pk_rsaSSA_PSS_val_Params,
        sa_rsaSSA_PSS,
        _sa_rsaSSA_PSS_val_Params,
        sa_sha224WithRSAEncryption,
        _sa_sha224WithRSAEncryption_val_Params,
        sha224WithRSAEncryption,
        sa_sha256WithRSAEncryption,
        _sa_sha256WithRSAEncryption_val_Params,
        sha256WithRSAEncryption,
        sa_sha384WithRSAEncryption,
        _sa_sha384WithRSAEncryption_val_Params,
        sha384WithRSAEncryption,
        sa_sha512WithRSAEncryption,
        _sa_sha512WithRSAEncryption_val_Params,
        sha512WithRSAEncryption,
        pk_rsaES_OAEP,
        _pk_rsaES_OAEP_val_KeyValue,
        _pk_rsaES_OAEP_val_Params,
        kta_rsaES_OAEP,
        _kta_rsaES_OAEP_val_Params,
        pkcs_1,
        id_RSAES_OAEP,
        id_mgf1,
        id_pSpecified,
        id_RSASSA_PSS,
        id_sha224,
        mda_sha224,
        _mda_sha224_val_Params,
        id_sha256,
        mda_sha256,
        _mda_sha256_val_Params,
        id_sha384,
        mda_sha384,
        _mda_sha384_val_Params,
        id_sha512,
        mda_sha512,
        _mda_sha512_val_Params,
        EncodingParameters,
        nullOctetString,
        nullParameters,
        __HashAlgorithm_algorithm_tab,
        ___HashAlgorithm_algorithm_tab_val_Params_0,
        ___HashAlgorithm_algorithm_tab_val_Params_1,
        ___HashAlgorithm_algorithm_tab_val_Params_2,
        ___HashAlgorithm_algorithm_tab_val_Params_3,
        ___HashAlgorithm_algorithm_tab_val_Params_4,
        _HashAlgorithm_algorithm,
        _HashAlgorithm_parameters,
        HashAlgorithm,
        HashAlgorithms,
        _HashAlgorithms_val_Params_0,
        _HashAlgorithms_val_Params_1,
        _HashAlgorithms_val_Params_2,
        _HashAlgorithms_val_Params_3,
        _HashAlgorithms_val_Params_4,
        sha1Identifier,
        _parameters_val,
        __MaskGenAlgorithm_algorithm_tab,
        ___MaskGenAlgorithm_algorithm_tab_val_Params_0,
        _MaskGenAlgorithm_algorithm,
        _MaskGenAlgorithm_parameters,
        MaskGenAlgorithm,
        mgf1SHA1,
        _parameters_val_0,
        PKCS1MGFAlgorithms,
        _PKCS1MGFAlgorithms_val_Params_0,
        __PSourceAlgorithm_algorithm_tab,
        ___PSourceAlgorithm_algorithm_tab_val_Params_0,
        _PSourceAlgorithm_algorithm,
        _PSourceAlgorithm_parameters,
        PSourceAlgorithm,
        PSS_SourceAlgorithms,
        _PSS_SourceAlgorithms_val_Params_0,
        pSpecifiedEmpty,
        _parameters_val_1,
        _RSASSA_PSS_params_hashAlgorithm,
        _RSASSA_PSS_params_maskGenAlgorithm,
        _RSASSA_PSS_params_saltLength,
        _RSASSA_PSS_params_trailerField,
        RSASSA_PSS_params,
        _RSAES_OAEP_params_hashFunc,
        _RSAES_OAEP_params_maskGenFunc,
        _RSAES_OAEP_params_pSourceFunc,
        RSAES_OAEP_params,
    ]

class PKIXAlgs_2009:

    _name_  = u'PKIXAlgs-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 56]
    
    _obj_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'SMimeCaps',
        u'pk-rsa',
        u'rsaEncryption',
        u'RSAPublicKey',
        u'pk-dsa',
        u'id-dsa',
        u'DSA-Params',
        u'DSAPublicKey',
        u'pk-dh',
        u'dhpublicnumber',
        u'DomainParameters',
        u'ValidationParams',
        u'DHPublicKey',
        u'pk-kea',
        u'id-keyExchangeAlgorithm',
        u'KEA-Params-Id',
        u'pk-ec',
        u'ECPoint',
        u'id-ecPublicKey',
        u'pk-ecDH',
        u'id-ecDH',
        u'pk-ecMQV',
        u'id-ecMQV',
        u'ECParameters',
        u'CURVE',
        u'NamedCurve',
        u'secp192r1',
        u'sect163k1',
        u'sect163r2',
        u'secp224r1',
        u'sect233k1',
        u'sect233r1',
        u'secp256r1',
        u'sect283k1',
        u'sect283r1',
        u'secp384r1',
        u'sect409k1',
        u'sect409r1',
        u'secp521r1',
        u'sect571k1',
        u'sect571r1',
        u'sa-rsaWithMD2',
        u'md2WithRSAEncryption',
        u'sa-rsaWithMD5',
        u'md5WithRSAEncryption',
        u'sa-rsaWithSHA1',
        u'sha1WithRSAEncryption',
        u'sa-dsaWithSHA1',
        u'dsa-with-sha1',
        u'sa-dsaWithSHA224',
        u'dsa-with-sha224',
        u'sa-dsaWithSHA256',
        u'dsa-with-sha256',
        u'sa-ecdsaWithSHA1',
        u'ecdsa-with-SHA1',
        u'sa-ecdsaWithSHA224',
        u'ecdsa-with-SHA224',
        u'sa-ecdsaWithSHA256',
        u'ecdsa-with-SHA256',
        u'sa-ecdsaWithSHA384',
        u'ecdsa-with-SHA384',
        u'sa-ecdsaWithSHA512',
        u'ecdsa-with-SHA512',
        u'DSA-Sig-Value',
        u'ECDSA-Sig-Value',
        u'HashAlgs',
        u'mda-md2',
        u'id-md2',
        u'mda-md5',
        u'id-md5',
        u'mda-sha1',
        u'id-sha1',
        ]
    _type_ = [
        u'RSAPublicKey',
        u'DSA-Params',
        u'DSAPublicKey',
        u'DomainParameters',
        u'ValidationParams',
        u'DHPublicKey',
        u'KEA-Params-Id',
        u'ECPoint',
        u'ECParameters',
        u'CURVE',
        u'DSA-Sig-Value',
        u'ECDSA-Sig-Value',
        ]
    _set_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'SMimeCaps',
        u'NamedCurve',
        u'HashAlgs',
        ]
    _val_ = [
        u'pk-rsa',
        u'rsaEncryption',
        u'pk-dsa',
        u'id-dsa',
        u'pk-dh',
        u'dhpublicnumber',
        u'pk-kea',
        u'id-keyExchangeAlgorithm',
        u'pk-ec',
        u'id-ecPublicKey',
        u'pk-ecDH',
        u'id-ecDH',
        u'pk-ecMQV',
        u'id-ecMQV',
        u'secp192r1',
        u'sect163k1',
        u'sect163r2',
        u'secp224r1',
        u'sect233k1',
        u'sect233r1',
        u'secp256r1',
        u'sect283k1',
        u'sect283r1',
        u'secp384r1',
        u'sect409k1',
        u'sect409r1',
        u'secp521r1',
        u'sect571k1',
        u'sect571r1',
        u'sa-rsaWithMD2',
        u'md2WithRSAEncryption',
        u'sa-rsaWithMD5',
        u'md5WithRSAEncryption',
        u'sa-rsaWithSHA1',
        u'sha1WithRSAEncryption',
        u'sa-dsaWithSHA1',
        u'dsa-with-sha1',
        u'sa-dsaWithSHA224',
        u'dsa-with-sha224',
        u'sa-dsaWithSHA256',
        u'dsa-with-sha256',
        u'sa-ecdsaWithSHA1',
        u'ecdsa-with-SHA1',
        u'sa-ecdsaWithSHA224',
        u'ecdsa-with-SHA224',
        u'sa-ecdsaWithSHA256',
        u'ecdsa-with-SHA256',
        u'sa-ecdsaWithSHA384',
        u'ecdsa-with-SHA384',
        u'sa-ecdsaWithSHA512',
        u'ecdsa-with-SHA512',
        u'mda-md2',
        u'id-md2',
        u'mda-md5',
        u'id-md5',
        u'mda-sha1',
        u'id-sha1',
        ]
    _class_ = [
        u'PublicKeys',
        u'SignatureAlgs',
        u'SMimeCaps',
        u'pk-rsa',
        u'pk-dsa',
        u'pk-dh',
        u'pk-kea',
        u'pk-ec',
        u'pk-ecDH',
        u'pk-ecMQV',
        u'CURVE',
        u'NamedCurve',
        u'sa-rsaWithMD2',
        u'sa-rsaWithMD5',
        u'sa-rsaWithSHA1',
        u'sa-dsaWithSHA1',
        u'sa-dsaWithSHA224',
        u'sa-dsaWithSHA256',
        u'sa-ecdsaWithSHA1',
        u'sa-ecdsaWithSHA224',
        u'sa-ecdsaWithSHA256',
        u'sa-ecdsaWithSHA384',
        u'sa-ecdsaWithSHA512',
        u'HashAlgs',
        u'mda-md2',
        u'mda-md5',
        u'mda-sha1',
        ]
    _param_ = [
        ]
    
    #-----< PublicKeys >-----#
    PublicKeys = CLASS(name=u'PublicKeys', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _PublicKeys_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _PublicKeys_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _PublicKeys_val_KeyValue_1 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    _PublicKeys_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    _PublicKeys_val_KeyValue_2 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _PublicKeys_val_Params_2 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    _PublicKeys_val_Params_3 = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'KEA-Params-Id')))
    _PublicKeys_val_KeyValue_4 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeys_val_Params_4 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _PublicKeys_val_KeyValue_5 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeys_val_Params_5 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _PublicKeys_val_KeyValue_6 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _PublicKeys_val_Params_6 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    PublicKeys._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', _PublicKeys_val_KeyValue_0), (u'Params', _PublicKeys_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', _PublicKeys_val_KeyValue_1), (u'Params', _PublicKeys_val_Params_1), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))]), dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _PublicKeys_val_KeyValue_2), (u'Params', _PublicKeys_val_Params_2), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))]), dict([(u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22)), (u'Params', _PublicKeys_val_Params_3), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])], rr=[], ev=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', _PublicKeys_val_KeyValue_4), (u'Params', _PublicKeys_val_Params_4), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))]), dict([(u'id', (1, 3, 132, 1, 12)), (u'KeyValue', _PublicKeys_val_KeyValue_5), (u'Params', _PublicKeys_val_Params_5), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))]), dict([(u'id', (1, 3, 132, 1, 13)), (u'KeyValue', _PublicKeys_val_KeyValue_6), (u'Params', _PublicKeys_val_Params_6), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])], er=[])
    
    #-----< SignatureAlgs >-----#
    SignatureAlgs = CLASS(name=u'SignatureAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _SignatureAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgs_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    _SignatureAlgs_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgs_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    _SignatureAlgs_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgs_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _SignatureAlgs_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgs_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgs_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgs_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    _SignatureAlgs_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _SignatureAlgs_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    SignatureAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', _SignatureAlgs_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', _SignatureAlgs_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', _SignatureAlgs_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', _SignatureAlgs_val_Value_3), (u'Params', _SignatureAlgs_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', _SignatureAlgs_val_Value_4), (u'Params', _SignatureAlgs_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', _SignatureAlgs_val_Value_5), (u'Params', _SignatureAlgs_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', _SignatureAlgs_val_Value_6), (u'Params', _SignatureAlgs_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', _SignatureAlgs_val_Value_7), (u'Params', _SignatureAlgs_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', _SignatureAlgs_val_Value_8), (u'Params', _SignatureAlgs_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', _SignatureAlgs_val_Value_9), (u'Params', _SignatureAlgs_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', _SignatureAlgs_val_Value_10), (u'Params', _SignatureAlgs_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))])], er=[])
    
    #-----< SMimeCaps >-----#
    SMimeCaps = CLASS(name=u'SMimeCaps', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SMIME-CAPS')))
    SMimeCaps._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]), dict([(u'id', (1, 2, 840, 10040, 4, 3))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))])], rr=[], ev=[], er=[])
    
    #-----< pk-rsa >-----#
    pk_rsa = CLASS(name=u'pk-rsa', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_rsa_val_KeyValue = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    _pk_rsa_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    pk_rsa._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', _pk_rsa_val_KeyValue), (u'Params', _pk_rsa_val_Params), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])
    
    #-----< rsaEncryption >-----#
    rsaEncryption = OID(name=u'rsaEncryption', mode=MODE_VALUE)
    rsaEncryption._val = (1, 2, 840, 113549, 1, 1, 1)
    
    #-----< RSAPublicKey >-----#
    RSAPublicKey = SEQ(name=u'RSAPublicKey', mode=MODE_TYPE)
    _RSAPublicKey_modulus = INT(name=u'modulus', mode=MODE_TYPE)
    _RSAPublicKey_publicExponent = INT(name=u'publicExponent', mode=MODE_TYPE)
    RSAPublicKey._cont = ASN1Dict([
        (u'modulus', _RSAPublicKey_modulus),
        (u'publicExponent', _RSAPublicKey_publicExponent),
        ])
    RSAPublicKey._ext = None
    
    #-----< pk-dsa >-----#
    pk_dsa = CLASS(name=u'pk-dsa', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_dsa_val_KeyValue = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    _pk_dsa_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    pk_dsa._val = dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', _pk_dsa_val_KeyValue), (u'Params', _pk_dsa_val_Params), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])
    
    #-----< id-dsa >-----#
    id_dsa = OID(name=u'id-dsa', mode=MODE_VALUE)
    id_dsa._val = (1, 2, 840, 10040, 4, 1)
    
    #-----< DSA-Params >-----#
    DSA_Params = SEQ(name=u'DSA-Params', mode=MODE_TYPE)
    _DSA_Params_p = INT(name=u'p', mode=MODE_TYPE)
    _DSA_Params_q = INT(name=u'q', mode=MODE_TYPE)
    _DSA_Params_g = INT(name=u'g', mode=MODE_TYPE)
    DSA_Params._cont = ASN1Dict([
        (u'p', _DSA_Params_p),
        (u'q', _DSA_Params_q),
        (u'g', _DSA_Params_g),
        ])
    DSA_Params._ext = None
    
    #-----< DSAPublicKey >-----#
    DSAPublicKey = INT(name=u'DSAPublicKey', mode=MODE_TYPE)
    
    #-----< pk-dh >-----#
    pk_dh = CLASS(name=u'pk-dh', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_dh_val_KeyValue = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DHPublicKey')))
    _pk_dh_val_Params = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DomainParameters')))
    pk_dh._val = dict([(u'id', (1, 2, 840, 10046, 2, 1)), (u'KeyValue', _pk_dh_val_KeyValue), (u'Params', _pk_dh_val_Params), (u'paramPresence', u'inheritable'), (u'keyUsage', (19, 9))])
    
    #-----< dhpublicnumber >-----#
    dhpublicnumber = OID(name=u'dhpublicnumber', mode=MODE_VALUE)
    dhpublicnumber._val = (1, 2, 840, 10046, 2, 1)
    
    #-----< DomainParameters >-----#
    DomainParameters = SEQ(name=u'DomainParameters', mode=MODE_TYPE)
    _DomainParameters_p = INT(name=u'p', mode=MODE_TYPE)
    _DomainParameters_g = INT(name=u'g', mode=MODE_TYPE)
    _DomainParameters_q = INT(name=u'q', mode=MODE_TYPE)
    _DomainParameters_j = INT(name=u'j', mode=MODE_TYPE, opt=True)
    _DomainParameters_validationParams = SEQ(name=u'validationParams', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ValidationParams')), opt=True)
    DomainParameters._cont = ASN1Dict([
        (u'p', _DomainParameters_p),
        (u'g', _DomainParameters_g),
        (u'q', _DomainParameters_q),
        (u'j', _DomainParameters_j),
        (u'validationParams', _DomainParameters_validationParams),
        ])
    DomainParameters._ext = None
    
    #-----< ValidationParams >-----#
    ValidationParams = SEQ(name=u'ValidationParams', mode=MODE_TYPE)
    _ValidationParams_seed = BIT_STR(name=u'seed', mode=MODE_TYPE)
    _ValidationParams_pgenCounter = INT(name=u'pgenCounter', mode=MODE_TYPE)
    ValidationParams._cont = ASN1Dict([
        (u'seed', _ValidationParams_seed),
        (u'pgenCounter', _ValidationParams_pgenCounter),
        ])
    ValidationParams._ext = None
    
    #-----< DHPublicKey >-----#
    DHPublicKey = INT(name=u'DHPublicKey', mode=MODE_TYPE)
    
    #-----< pk-kea >-----#
    pk_kea = CLASS(name=u'pk-kea', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_kea_val_Params = OCT_STR(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'KEA-Params-Id')))
    pk_kea._val = dict([(u'id', (2, 16, 840, 1, 101, 2, 1, 1, 22)), (u'Params', _pk_kea_val_Params), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])
    
    #-----< id-keyExchangeAlgorithm >-----#
    id_keyExchangeAlgorithm = OID(name=u'id-keyExchangeAlgorithm', mode=MODE_VALUE)
    id_keyExchangeAlgorithm._val = (2, 16, 840, 1, 101, 2, 1, 1, 22)
    
    #-----< KEA-Params-Id >-----#
    KEA_Params_Id = OCT_STR(name=u'KEA-Params-Id', mode=MODE_TYPE)
    
    #-----< pk-ec >-----#
    pk_ec = CLASS(name=u'pk-ec', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_ec_val_KeyValue = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _pk_ec_val_Params = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    pk_ec._val = dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', _pk_ec_val_KeyValue), (u'Params', _pk_ec_val_Params), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])
    
    #-----< ECPoint >-----#
    ECPoint = OCT_STR(name=u'ECPoint', mode=MODE_TYPE)
    
    #-----< id-ecPublicKey >-----#
    id_ecPublicKey = OID(name=u'id-ecPublicKey', mode=MODE_VALUE)
    id_ecPublicKey._val = (1, 2, 840, 10045, 2, 1)
    
    #-----< pk-ecDH >-----#
    pk_ecDH = CLASS(name=u'pk-ecDH', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_ecDH_val_KeyValue = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _pk_ecDH_val_Params = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    pk_ecDH._val = dict([(u'id', (1, 3, 132, 1, 12)), (u'KeyValue', _pk_ecDH_val_KeyValue), (u'Params', _pk_ecDH_val_Params), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])
    
    #-----< id-ecDH >-----#
    id_ecDH = OID(name=u'id-ecDH', mode=MODE_VALUE)
    id_ecDH._val = (1, 3, 132, 1, 12)
    
    #-----< pk-ecMQV >-----#
    pk_ecMQV = CLASS(name=u'pk-ecMQV', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'PUBLIC-KEY')))
    _pk_ecMQV_val_KeyValue = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    _pk_ecMQV_val_Params = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    pk_ecMQV._val = dict([(u'id', (1, 3, 132, 1, 13)), (u'KeyValue', _pk_ecMQV_val_KeyValue), (u'Params', _pk_ecMQV_val_Params), (u'paramPresence', u'required'), (u'keyUsage', (19, 9))])
    
    #-----< id-ecMQV >-----#
    id_ecMQV = OID(name=u'id-ecMQV', mode=MODE_VALUE)
    id_ecMQV._val = (1, 3, 132, 1, 13)
    
    #-----< ECParameters >-----#
    ECParameters = CHOICE(name=u'ECParameters', mode=MODE_TYPE)
    _ECParameters_namedCurve = OID(name=u'namedCurve', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIXAlgs-2009', 'CURVE'), [u'id']))
    __ECParameters_namedCurve_tab = CLASS(name='_tab_CURVE', mode=MODE_SET, typeref=ASN1RefType(('PKIXAlgs-2009', 'CURVE')))
    __ECParameters_namedCurve_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 3, 1, 1))]), dict([(u'id', (1, 3, 132, 0, 1))]), dict([(u'id', (1, 3, 132, 0, 15))]), dict([(u'id', (1, 3, 132, 0, 33))]), dict([(u'id', (1, 3, 132, 0, 26))]), dict([(u'id', (1, 3, 132, 0, 27))]), dict([(u'id', (1, 2, 840, 10045, 3, 1, 7))]), dict([(u'id', (1, 3, 132, 0, 16))]), dict([(u'id', (1, 3, 132, 0, 17))]), dict([(u'id', (1, 3, 132, 0, 34))]), dict([(u'id', (1, 3, 132, 0, 36))]), dict([(u'id', (1, 3, 132, 0, 37))]), dict([(u'id', (1, 3, 132, 0, 35))]), dict([(u'id', (1, 3, 132, 0, 38))]), dict([(u'id', (1, 3, 132, 0, 39))])], rr=[], ev=None, er=[])
    _ECParameters_namedCurve._const_tab = __ECParameters_namedCurve_tab
    _ECParameters_namedCurve._const_tab_at = None
    _ECParameters_namedCurve._const_tab_id = u'id'
    ECParameters._cont = ASN1Dict([
        (u'namedCurve', _ECParameters_namedCurve),
        ])
    ECParameters._ext = None
    
    #-----< CURVE >-----#
    CURVE = CLASS(name=u'CURVE', mode=MODE_TYPE)
    _CURVE_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    CURVE._cont = ASN1Dict([
        (u'id', _CURVE_id),
        ])
    
    #-----< NamedCurve >-----#
    NamedCurve = CLASS(name=u'NamedCurve', mode=MODE_SET, typeref=ASN1RefType(('PKIXAlgs-2009', 'CURVE')))
    NamedCurve._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 3, 1, 1))]), dict([(u'id', (1, 3, 132, 0, 1))]), dict([(u'id', (1, 3, 132, 0, 15))]), dict([(u'id', (1, 3, 132, 0, 33))]), dict([(u'id', (1, 3, 132, 0, 26))]), dict([(u'id', (1, 3, 132, 0, 27))]), dict([(u'id', (1, 2, 840, 10045, 3, 1, 7))]), dict([(u'id', (1, 3, 132, 0, 16))]), dict([(u'id', (1, 3, 132, 0, 17))]), dict([(u'id', (1, 3, 132, 0, 34))]), dict([(u'id', (1, 3, 132, 0, 36))]), dict([(u'id', (1, 3, 132, 0, 37))]), dict([(u'id', (1, 3, 132, 0, 35))]), dict([(u'id', (1, 3, 132, 0, 38))]), dict([(u'id', (1, 3, 132, 0, 39))])], rr=[], ev=[], er=[])
    
    #-----< secp192r1 >-----#
    secp192r1 = OID(name=u'secp192r1', mode=MODE_VALUE)
    secp192r1._val = (1, 2, 840, 10045, 3, 1, 1)
    
    #-----< sect163k1 >-----#
    sect163k1 = OID(name=u'sect163k1', mode=MODE_VALUE)
    sect163k1._val = (1, 3, 132, 0, 1)
    
    #-----< sect163r2 >-----#
    sect163r2 = OID(name=u'sect163r2', mode=MODE_VALUE)
    sect163r2._val = (1, 3, 132, 0, 15)
    
    #-----< secp224r1 >-----#
    secp224r1 = OID(name=u'secp224r1', mode=MODE_VALUE)
    secp224r1._val = (1, 3, 132, 0, 33)
    
    #-----< sect233k1 >-----#
    sect233k1 = OID(name=u'sect233k1', mode=MODE_VALUE)
    sect233k1._val = (1, 3, 132, 0, 26)
    
    #-----< sect233r1 >-----#
    sect233r1 = OID(name=u'sect233r1', mode=MODE_VALUE)
    sect233r1._val = (1, 3, 132, 0, 27)
    
    #-----< secp256r1 >-----#
    secp256r1 = OID(name=u'secp256r1', mode=MODE_VALUE)
    secp256r1._val = (1, 2, 840, 10045, 3, 1, 7)
    
    #-----< sect283k1 >-----#
    sect283k1 = OID(name=u'sect283k1', mode=MODE_VALUE)
    sect283k1._val = (1, 3, 132, 0, 16)
    
    #-----< sect283r1 >-----#
    sect283r1 = OID(name=u'sect283r1', mode=MODE_VALUE)
    sect283r1._val = (1, 3, 132, 0, 17)
    
    #-----< secp384r1 >-----#
    secp384r1 = OID(name=u'secp384r1', mode=MODE_VALUE)
    secp384r1._val = (1, 3, 132, 0, 34)
    
    #-----< sect409k1 >-----#
    sect409k1 = OID(name=u'sect409k1', mode=MODE_VALUE)
    sect409k1._val = (1, 3, 132, 0, 36)
    
    #-----< sect409r1 >-----#
    sect409r1 = OID(name=u'sect409r1', mode=MODE_VALUE)
    sect409r1._val = (1, 3, 132, 0, 37)
    
    #-----< secp521r1 >-----#
    secp521r1 = OID(name=u'secp521r1', mode=MODE_VALUE)
    secp521r1._val = (1, 3, 132, 0, 35)
    
    #-----< sect571k1 >-----#
    sect571k1 = OID(name=u'sect571k1', mode=MODE_VALUE)
    sect571k1._val = (1, 3, 132, 0, 38)
    
    #-----< sect571r1 >-----#
    sect571r1 = OID(name=u'sect571r1', mode=MODE_VALUE)
    sect571r1._val = (1, 3, 132, 0, 39)
    
    #-----< sa-rsaWithMD2 >-----#
    sa_rsaWithMD2 = CLASS(name=u'sa-rsaWithMD2', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_rsaWithMD2_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_rsaWithMD2._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', _sa_rsaWithMD2_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))])
    
    #-----< md2WithRSAEncryption >-----#
    md2WithRSAEncryption = OID(name=u'md2WithRSAEncryption', mode=MODE_VALUE)
    md2WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 2)
    
    #-----< sa-rsaWithMD5 >-----#
    sa_rsaWithMD5 = CLASS(name=u'sa-rsaWithMD5', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_rsaWithMD5_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_rsaWithMD5._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', _sa_rsaWithMD5_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))])
    
    #-----< md5WithRSAEncryption >-----#
    md5WithRSAEncryption = OID(name=u'md5WithRSAEncryption', mode=MODE_VALUE)
    md5WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 4)
    
    #-----< sa-rsaWithSHA1 >-----#
    sa_rsaWithSHA1 = CLASS(name=u'sa-rsaWithSHA1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_rsaWithSHA1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_rsaWithSHA1._val = dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', _sa_rsaWithSHA1_val_Params), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))])
    
    #-----< sha1WithRSAEncryption >-----#
    sha1WithRSAEncryption = OID(name=u'sha1WithRSAEncryption', mode=MODE_VALUE)
    sha1WithRSAEncryption._val = (1, 2, 840, 113549, 1, 1, 5)
    
    #-----< sa-dsaWithSHA1 >-----#
    sa_dsaWithSHA1 = CLASS(name=u'sa-dsaWithSHA1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_dsaWithSHA1_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _sa_dsaWithSHA1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_dsaWithSHA1._val = dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', _sa_dsaWithSHA1_val_Value), (u'Params', _sa_dsaWithSHA1_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))])
    
    #-----< dsa-with-sha1 >-----#
    dsa_with_sha1 = OID(name=u'dsa-with-sha1', mode=MODE_VALUE)
    dsa_with_sha1._val = (1, 2, 840, 10040, 4, 3)
    
    #-----< sa-dsaWithSHA224 >-----#
    sa_dsaWithSHA224 = CLASS(name=u'sa-dsaWithSHA224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_dsaWithSHA224_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _sa_dsaWithSHA224_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_dsaWithSHA224._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', _sa_dsaWithSHA224_val_Value), (u'Params', _sa_dsaWithSHA224_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))])
    
    #-----< dsa-with-sha224 >-----#
    dsa_with_sha224 = OID(name=u'dsa-with-sha224', mode=MODE_VALUE)
    dsa_with_sha224._val = (2, 16, 840, 1, 101, 3, 4, 3, 1)
    
    #-----< sa-dsaWithSHA256 >-----#
    sa_dsaWithSHA256 = CLASS(name=u'sa-dsaWithSHA256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_dsaWithSHA256_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    _sa_dsaWithSHA256_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_dsaWithSHA256._val = dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', _sa_dsaWithSHA256_val_Value), (u'Params', _sa_dsaWithSHA256_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))])
    
    #-----< dsa-with-sha256 >-----#
    dsa_with_sha256 = OID(name=u'dsa-with-sha256', mode=MODE_VALUE)
    dsa_with_sha256._val = (2, 16, 840, 1, 101, 3, 4, 3, 2)
    
    #-----< sa-ecdsaWithSHA1 >-----#
    sa_ecdsaWithSHA1 = CLASS(name=u'sa-ecdsaWithSHA1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_ecdsaWithSHA1_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _sa_ecdsaWithSHA1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_ecdsaWithSHA1._val = dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', _sa_ecdsaWithSHA1_val_Value), (u'Params', _sa_ecdsaWithSHA1_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])
    
    #-----< ecdsa-with-SHA1 >-----#
    ecdsa_with_SHA1 = OID(name=u'ecdsa-with-SHA1', mode=MODE_VALUE)
    ecdsa_with_SHA1._val = (1, 2, 840, 10045, 4, 1)
    
    #-----< sa-ecdsaWithSHA224 >-----#
    sa_ecdsaWithSHA224 = CLASS(name=u'sa-ecdsaWithSHA224', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_ecdsaWithSHA224_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _sa_ecdsaWithSHA224_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_ecdsaWithSHA224._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', _sa_ecdsaWithSHA224_val_Value), (u'Params', _sa_ecdsaWithSHA224_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))])
    
    #-----< ecdsa-with-SHA224 >-----#
    ecdsa_with_SHA224 = OID(name=u'ecdsa-with-SHA224', mode=MODE_VALUE)
    ecdsa_with_SHA224._val = (1, 2, 840, 10045, 4, 3, 1)
    
    #-----< sa-ecdsaWithSHA256 >-----#
    sa_ecdsaWithSHA256 = CLASS(name=u'sa-ecdsaWithSHA256', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_ecdsaWithSHA256_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _sa_ecdsaWithSHA256_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_ecdsaWithSHA256._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', _sa_ecdsaWithSHA256_val_Value), (u'Params', _sa_ecdsaWithSHA256_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))])
    
    #-----< ecdsa-with-SHA256 >-----#
    ecdsa_with_SHA256 = OID(name=u'ecdsa-with-SHA256', mode=MODE_VALUE)
    ecdsa_with_SHA256._val = (1, 2, 840, 10045, 4, 3, 2)
    
    #-----< sa-ecdsaWithSHA384 >-----#
    sa_ecdsaWithSHA384 = CLASS(name=u'sa-ecdsaWithSHA384', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_ecdsaWithSHA384_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _sa_ecdsaWithSHA384_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_ecdsaWithSHA384._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', _sa_ecdsaWithSHA384_val_Value), (u'Params', _sa_ecdsaWithSHA384_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))])
    
    #-----< ecdsa-with-SHA384 >-----#
    ecdsa_with_SHA384 = OID(name=u'ecdsa-with-SHA384', mode=MODE_VALUE)
    ecdsa_with_SHA384._val = (1, 2, 840, 10045, 4, 3, 3)
    
    #-----< sa-ecdsaWithSHA512 >-----#
    sa_ecdsaWithSHA512 = CLASS(name=u'sa-ecdsaWithSHA512', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    _sa_ecdsaWithSHA512_val_Value = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    _sa_ecdsaWithSHA512_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    sa_ecdsaWithSHA512._val = dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', _sa_ecdsaWithSHA512_val_Value), (u'Params', _sa_ecdsaWithSHA512_val_Params), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))])
    
    #-----< ecdsa-with-SHA512 >-----#
    ecdsa_with_SHA512 = OID(name=u'ecdsa-with-SHA512', mode=MODE_VALUE)
    ecdsa_with_SHA512._val = (1, 2, 840, 10045, 4, 3, 4)
    
    #-----< DSA-Sig-Value >-----#
    DSA_Sig_Value = SEQ(name=u'DSA-Sig-Value', mode=MODE_TYPE)
    _DSA_Sig_Value_r = INT(name=u'r', mode=MODE_TYPE)
    _DSA_Sig_Value_s = INT(name=u's', mode=MODE_TYPE)
    DSA_Sig_Value._cont = ASN1Dict([
        (u'r', _DSA_Sig_Value_r),
        (u's', _DSA_Sig_Value_s),
        ])
    DSA_Sig_Value._ext = None
    
    #-----< ECDSA-Sig-Value >-----#
    ECDSA_Sig_Value = SEQ(name=u'ECDSA-Sig-Value', mode=MODE_TYPE)
    _ECDSA_Sig_Value_r = INT(name=u'r', mode=MODE_TYPE)
    _ECDSA_Sig_Value_s = INT(name=u's', mode=MODE_TYPE)
    ECDSA_Sig_Value._cont = ASN1Dict([
        (u'r', _ECDSA_Sig_Value_r),
        (u's', _ECDSA_Sig_Value_s),
        ])
    ECDSA_Sig_Value._ext = None
    
    #-----< HashAlgs >-----#
    HashAlgs = CLASS(name=u'HashAlgs', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _HashAlgs_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgs_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    _HashAlgs_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    HashAlgs._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', _HashAlgs_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', _HashAlgs_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', _HashAlgs_val_Params_2), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=[], er=[])
    
    #-----< mda-md2 >-----#
    mda_md2 = CLASS(name=u'mda-md2', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_md2_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_md2._val = dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', _mda_md2_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-md2 >-----#
    id_md2 = OID(name=u'id-md2', mode=MODE_VALUE)
    id_md2._val = (1, 2, 840, 113549, 2, 2)
    
    #-----< mda-md5 >-----#
    mda_md5 = CLASS(name=u'mda-md5', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_md5_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_md5._val = dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', _mda_md5_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-md5 >-----#
    id_md5 = OID(name=u'id-md5', mode=MODE_VALUE)
    id_md5._val = (1, 2, 840, 113549, 2, 5)
    
    #-----< mda-sha1 >-----#
    mda_sha1 = CLASS(name=u'mda-sha1', mode=MODE_VALUE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    _mda_sha1_val_Params = NULL(name=u'Params', mode=MODE_TYPE)
    mda_sha1._val = dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', _mda_sha1_val_Params), (u'paramPresence', u'preferredAbsent')])
    
    #-----< id-sha1 >-----#
    id_sha1 = OID(name=u'id-sha1', mode=MODE_VALUE)
    id_sha1._val = (1, 3, 14, 3, 2, 26)
    
    _all_ = [
        PublicKeys,
        _PublicKeys_val_KeyValue_0,
        _PublicKeys_val_Params_0,
        _PublicKeys_val_KeyValue_1,
        _PublicKeys_val_Params_1,
        _PublicKeys_val_KeyValue_2,
        _PublicKeys_val_Params_2,
        _PublicKeys_val_Params_3,
        _PublicKeys_val_KeyValue_4,
        _PublicKeys_val_Params_4,
        _PublicKeys_val_KeyValue_5,
        _PublicKeys_val_Params_5,
        _PublicKeys_val_KeyValue_6,
        _PublicKeys_val_Params_6,
        SignatureAlgs,
        _SignatureAlgs_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        _SignatureAlgs_val_Params_1,
        _SignatureAlgs_val_Params_2,
        _SignatureAlgs_val_Value_3,
        _SignatureAlgs_val_Params_3,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0,
        _SignatureAlgs_val_Value_4,
        _SignatureAlgs_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1,
        _SignatureAlgs_val_Value_5,
        _SignatureAlgs_val_Params_5,
        _SignatureAlgs_val_Value_6,
        _SignatureAlgs_val_Params_6,
        _SignatureAlgs_val_Value_7,
        _SignatureAlgs_val_Params_7,
        _SignatureAlgs_val_Value_8,
        _SignatureAlgs_val_Params_8,
        _SignatureAlgs_val_Value_9,
        _SignatureAlgs_val_Params_9,
        _SignatureAlgs_val_Value_10,
        _SignatureAlgs_val_Params_10,
        SMimeCaps,
        pk_rsa,
        _pk_rsa_val_KeyValue,
        _pk_rsa_val_Params,
        rsaEncryption,
        _RSAPublicKey_modulus,
        _RSAPublicKey_publicExponent,
        RSAPublicKey,
        pk_dsa,
        _pk_dsa_val_KeyValue,
        _pk_dsa_val_Params,
        id_dsa,
        _DSA_Params_p,
        _DSA_Params_q,
        _DSA_Params_g,
        DSA_Params,
        DSAPublicKey,
        pk_dh,
        _pk_dh_val_KeyValue,
        _pk_dh_val_Params,
        dhpublicnumber,
        _DomainParameters_p,
        _DomainParameters_g,
        _DomainParameters_q,
        _DomainParameters_j,
        _DomainParameters_validationParams,
        DomainParameters,
        _ValidationParams_seed,
        _ValidationParams_pgenCounter,
        ValidationParams,
        DHPublicKey,
        pk_kea,
        _pk_kea_val_Params,
        id_keyExchangeAlgorithm,
        KEA_Params_Id,
        pk_ec,
        _pk_ec_val_KeyValue,
        _pk_ec_val_Params,
        ECPoint,
        id_ecPublicKey,
        pk_ecDH,
        _pk_ecDH_val_KeyValue,
        _pk_ecDH_val_Params,
        id_ecDH,
        pk_ecMQV,
        _pk_ecMQV_val_KeyValue,
        _pk_ecMQV_val_Params,
        id_ecMQV,
        __ECParameters_namedCurve_tab,
        _ECParameters_namedCurve,
        ECParameters,
        _CURVE_id,
        CURVE,
        NamedCurve,
        secp192r1,
        sect163k1,
        sect163r2,
        secp224r1,
        sect233k1,
        sect233r1,
        secp256r1,
        sect283k1,
        sect283r1,
        secp384r1,
        sect409k1,
        sect409r1,
        secp521r1,
        sect571k1,
        sect571r1,
        sa_rsaWithMD2,
        _sa_rsaWithMD2_val_Params,
        md2WithRSAEncryption,
        sa_rsaWithMD5,
        _sa_rsaWithMD5_val_Params,
        md5WithRSAEncryption,
        sa_rsaWithSHA1,
        _sa_rsaWithSHA1_val_Params,
        sha1WithRSAEncryption,
        sa_dsaWithSHA1,
        _sa_dsaWithSHA1_val_Value,
        _sa_dsaWithSHA1_val_Params,
        dsa_with_sha1,
        sa_dsaWithSHA224,
        _sa_dsaWithSHA224_val_Value,
        _sa_dsaWithSHA224_val_Params,
        dsa_with_sha224,
        sa_dsaWithSHA256,
        _sa_dsaWithSHA256_val_Value,
        _sa_dsaWithSHA256_val_Params,
        dsa_with_sha256,
        sa_ecdsaWithSHA1,
        _sa_ecdsaWithSHA1_val_Value,
        _sa_ecdsaWithSHA1_val_Params,
        ecdsa_with_SHA1,
        sa_ecdsaWithSHA224,
        _sa_ecdsaWithSHA224_val_Value,
        _sa_ecdsaWithSHA224_val_Params,
        ecdsa_with_SHA224,
        sa_ecdsaWithSHA256,
        _sa_ecdsaWithSHA256_val_Value,
        _sa_ecdsaWithSHA256_val_Params,
        ecdsa_with_SHA256,
        sa_ecdsaWithSHA384,
        _sa_ecdsaWithSHA384_val_Value,
        _sa_ecdsaWithSHA384_val_Params,
        ecdsa_with_SHA384,
        sa_ecdsaWithSHA512,
        _sa_ecdsaWithSHA512_val_Value,
        _sa_ecdsaWithSHA512_val_Params,
        ecdsa_with_SHA512,
        _DSA_Sig_Value_r,
        _DSA_Sig_Value_s,
        DSA_Sig_Value,
        _ECDSA_Sig_Value_r,
        _ECDSA_Sig_Value_s,
        ECDSA_Sig_Value,
        HashAlgs,
        _HashAlgs_val_Params_0,
        _HashAlgs_val_Params_1,
        _HashAlgs_val_Params_2,
        mda_md2,
        _mda_md2_val_Params,
        id_md2,
        mda_md5,
        _mda_md5_val_Params,
        id_md5,
        mda_sha1,
        _mda_sha1_val_Params,
        id_sha1,
    ]

class PKIXAttributeCertificate_2009:

    _name_  = u'PKIXAttributeCertificate-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 47]
    
    _obj_ = [
        u'AttributeCertExtensions',
        u'ext-auditIdentity',
        u'ext-targetInformation',
        u'ext-noRevAvail',
        u'ext-ac-proxying',
        u'ext-aaControls',
        u'AttributesDefined',
        u'at-authenticationInfo',
        u'at-accesIdentity',
        u'at-chargingIdentity',
        u'at-group',
        u'at-role',
        u'at-clearance',
        u'at-clearance-RFC3281',
        u'at-encAttrs',
        u'id-pe-ac-auditIdentity',
        u'id-pe-aaControls',
        u'id-pe-ac-proxying',
        u'id-ce-targetInformation',
        u'id-ce-noRevAvail',
        u'id-aca',
        u'id-aca-authenticationInfo',
        u'id-aca-accessIdentity',
        u'id-aca-chargingIdentity',
        u'id-aca-group',
        u'id-aca-encAttrs',
        u'id-at-role',
        u'id-at-clearance',
        u'id-at-clearance-rfc3281',
        u'AttributeCertificate',
        u'AttributeCertificateInfo',
        u'AttCertVersion',
        u'Holder',
        u'ObjectDigestInfo',
        u'AttCertIssuer',
        u'V2Form',
        u'IssuerSerial',
        u'AttCertValidityPeriod',
        u'Targets',
        u'Target',
        u'TargetCert',
        u'AAControls',
        u'AttrSpec',
        u'ProxyInfo',
        u'IetfAttrSyntax',
        u'SvceAuthInfo',
        u'RoleSyntax',
        u'Clearance',
        u'Clearance-rfc3281',
        u'ClassList',
        u'SupportedSecurityCategories',
        u'SecurityCategory-rfc3281',
        u'ACClearAttrs',
        ]
    _type_ = [
        u'AttributeCertificate',
        u'AttributeCertificateInfo',
        u'AttCertVersion',
        u'Holder',
        u'ObjectDigestInfo',
        u'AttCertIssuer',
        u'V2Form',
        u'IssuerSerial',
        u'AttCertValidityPeriod',
        u'Targets',
        u'Target',
        u'TargetCert',
        u'AAControls',
        u'AttrSpec',
        u'ProxyInfo',
        u'IetfAttrSyntax',
        u'SvceAuthInfo',
        u'RoleSyntax',
        u'Clearance',
        u'Clearance-rfc3281',
        u'ClassList',
        u'SecurityCategory-rfc3281',
        u'ACClearAttrs',
        ]
    _set_ = [
        u'AttributeCertExtensions',
        u'AttributesDefined',
        u'SupportedSecurityCategories',
        ]
    _val_ = [
        u'ext-auditIdentity',
        u'ext-targetInformation',
        u'ext-noRevAvail',
        u'ext-ac-proxying',
        u'ext-aaControls',
        u'at-authenticationInfo',
        u'at-accesIdentity',
        u'at-chargingIdentity',
        u'at-group',
        u'at-role',
        u'at-clearance',
        u'at-clearance-RFC3281',
        u'at-encAttrs',
        u'id-pe-ac-auditIdentity',
        u'id-pe-aaControls',
        u'id-pe-ac-proxying',
        u'id-ce-targetInformation',
        u'id-ce-noRevAvail',
        u'id-aca',
        u'id-aca-authenticationInfo',
        u'id-aca-accessIdentity',
        u'id-aca-chargingIdentity',
        u'id-aca-group',
        u'id-aca-encAttrs',
        u'id-at-role',
        u'id-at-clearance',
        u'id-at-clearance-rfc3281',
        ]
    _class_ = [
        u'AttributeCertExtensions',
        u'ext-auditIdentity',
        u'ext-targetInformation',
        u'ext-noRevAvail',
        u'ext-ac-proxying',
        u'ext-aaControls',
        u'AttributesDefined',
        u'at-authenticationInfo',
        u'at-accesIdentity',
        u'at-chargingIdentity',
        u'at-group',
        u'at-role',
        u'at-clearance',
        u'at-clearance-RFC3281',
        u'at-encAttrs',
        u'SupportedSecurityCategories',
        ]
    _param_ = [
        u'SecurityCategory-rfc3281',
        ]
    
    #-----< AttributeCertExtensions >-----#
    AttributeCertExtensions = CLASS(name=u'AttributeCertExtensions', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _AttributeCertExtensions_val_ExtnType_0 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE)
    _AttributeCertExtensions_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Targets')))
    _AttributeCertExtensions_val_ExtnType_2 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _AttributeCertExtensions_val_ExtnType_3 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    _AttributeCertExtensions_val_ExtnType_4 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _AttributeCertExtensions_val_ExtnType_5 = NULL(name=u'ExtnType', mode=MODE_TYPE)
    _AttributeCertExtensions_val_ExtnType_6 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ProxyInfo')))
    _AttributeCertExtensions_val_ExtnType_7 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AAControls')))
    AttributeCertExtensions._val = ASN1Set(rv=[dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 4))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_1), (u'id', (2, 5, 29, 55))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_2), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_3), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_4), (u'id', (2, 5, 29, 31))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_5), (u'id', (2, 5, 29, 56))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_6), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 10))]), dict([(u'ExtnType', _AttributeCertExtensions_val_ExtnType_7), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 6))])], rr=[], ev=[], er=[])
    
    #-----< ext-auditIdentity >-----#
    ext_auditIdentity = CLASS(name=u'ext-auditIdentity', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_auditIdentity_val_ExtnType = OCT_STR(name=u'ExtnType', mode=MODE_TYPE)
    ext_auditIdentity._val = dict([(u'ExtnType', _ext_auditIdentity_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 4))])
    
    #-----< ext-targetInformation >-----#
    ext_targetInformation = CLASS(name=u'ext-targetInformation', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_targetInformation_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Targets')))
    ext_targetInformation._val = dict([(u'ExtnType', _ext_targetInformation_val_ExtnType), (u'id', (2, 5, 29, 55))])
    
    #-----< ext-noRevAvail >-----#
    ext_noRevAvail = CLASS(name=u'ext-noRevAvail', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_noRevAvail_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    ext_noRevAvail._val = dict([(u'ExtnType', _ext_noRevAvail_val_ExtnType), (u'id', (2, 5, 29, 56))])
    
    #-----< ext-ac-proxying >-----#
    ext_ac_proxying = CLASS(name=u'ext-ac-proxying', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_ac_proxying_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ProxyInfo')))
    ext_ac_proxying._val = dict([(u'ExtnType', _ext_ac_proxying_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 10))])
    
    #-----< ext-aaControls >-----#
    ext_aaControls = CLASS(name=u'ext-aaControls', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _ext_aaControls_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AAControls')))
    ext_aaControls._val = dict([(u'ExtnType', _ext_aaControls_val_ExtnType), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 6))])
    
    #-----< AttributesDefined >-----#
    AttributesDefined = CLASS(name=u'AttributesDefined', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _AttributesDefined_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _AttributesDefined_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _AttributesDefined_val_Type_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _AttributesDefined_val_Type_3 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _AttributesDefined_val_Type_4 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'RoleSyntax')))
    _AttributesDefined_val_Type_5 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Clearance')))
    _AttributesDefined_val_Type_6 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentInfo')))
    AttributesDefined._val = ASN1Set(rv=[dict([(u'Type', _AttributesDefined_val_Type_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 1))]), dict([(u'Type', _AttributesDefined_val_Type_1), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 2))]), dict([(u'Type', _AttributesDefined_val_Type_2), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 3))]), dict([(u'Type', _AttributesDefined_val_Type_3), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 4))]), dict([(u'Type', _AttributesDefined_val_Type_4), (u'id', (2, 5, 4, 72))]), dict([(u'Type', _AttributesDefined_val_Type_5), (u'id', (2, 5, 4, 55))]), dict([(u'Type', _AttributesDefined_val_Type_6), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 6))])], rr=[], ev=[], er=[])
    
    #-----< at-authenticationInfo >-----#
    at_authenticationInfo = CLASS(name=u'at-authenticationInfo', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_authenticationInfo_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    at_authenticationInfo._val = dict([(u'Type', _at_authenticationInfo_val_Type), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 1))])
    
    #-----< at-accesIdentity >-----#
    at_accesIdentity = CLASS(name=u'at-accesIdentity', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_accesIdentity_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    at_accesIdentity._val = dict([(u'Type', _at_accesIdentity_val_Type), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 2))])
    
    #-----< at-chargingIdentity >-----#
    at_chargingIdentity = CLASS(name=u'at-chargingIdentity', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_chargingIdentity_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    at_chargingIdentity._val = dict([(u'Type', _at_chargingIdentity_val_Type), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 3))])
    
    #-----< at-group >-----#
    at_group = CLASS(name=u'at-group', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_group_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    at_group._val = dict([(u'Type', _at_group_val_Type), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 4))])
    
    #-----< at-role >-----#
    at_role = CLASS(name=u'at-role', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_role_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'RoleSyntax')))
    at_role._val = dict([(u'Type', _at_role_val_Type), (u'id', (2, 5, 4, 72))])
    
    #-----< at-clearance >-----#
    at_clearance = CLASS(name=u'at-clearance', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_clearance_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Clearance')))
    at_clearance._val = dict([(u'Type', _at_clearance_val_Type), (u'id', (2, 5, 4, 55))])
    
    #-----< at-clearance-RFC3281 >-----#
    at_clearance_RFC3281 = CLASS(name=u'at-clearance-RFC3281', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_clearance_RFC3281_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Clearance-rfc3281')))
    at_clearance_RFC3281._val = dict([(u'Type', _at_clearance_RFC3281_val_Type), (u'id', (2, 5, 1, 5, 55))])
    
    #-----< at-encAttrs >-----#
    at_encAttrs = CLASS(name=u'at-encAttrs', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _at_encAttrs_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentInfo')))
    at_encAttrs._val = dict([(u'Type', _at_encAttrs_val_Type), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 6))])
    
    #-----< id-pe-ac-auditIdentity >-----#
    id_pe_ac_auditIdentity = OID(name=u'id-pe-ac-auditIdentity', mode=MODE_VALUE)
    id_pe_ac_auditIdentity._val = (1, 3, 6, 1, 5, 5, 7, 1, 4)
    
    #-----< id-pe-aaControls >-----#
    id_pe_aaControls = OID(name=u'id-pe-aaControls', mode=MODE_VALUE)
    id_pe_aaControls._val = (1, 3, 6, 1, 5, 5, 7, 1, 6)
    
    #-----< id-pe-ac-proxying >-----#
    id_pe_ac_proxying = OID(name=u'id-pe-ac-proxying', mode=MODE_VALUE)
    id_pe_ac_proxying._val = (1, 3, 6, 1, 5, 5, 7, 1, 10)
    
    #-----< id-ce-targetInformation >-----#
    id_ce_targetInformation = OID(name=u'id-ce-targetInformation', mode=MODE_VALUE)
    id_ce_targetInformation._val = (2, 5, 29, 55)
    
    #-----< id-ce-noRevAvail >-----#
    id_ce_noRevAvail = OID(name=u'id-ce-noRevAvail', mode=MODE_VALUE)
    id_ce_noRevAvail._val = (2, 5, 29, 56)
    
    #-----< id-aca >-----#
    id_aca = OID(name=u'id-aca', mode=MODE_VALUE)
    id_aca._val = (1, 3, 6, 1, 5, 5, 7, 10)
    
    #-----< id-aca-authenticationInfo >-----#
    id_aca_authenticationInfo = OID(name=u'id-aca-authenticationInfo', mode=MODE_VALUE)
    id_aca_authenticationInfo._val = (1, 3, 6, 1, 5, 5, 7, 10, 1)
    
    #-----< id-aca-accessIdentity >-----#
    id_aca_accessIdentity = OID(name=u'id-aca-accessIdentity', mode=MODE_VALUE)
    id_aca_accessIdentity._val = (1, 3, 6, 1, 5, 5, 7, 10, 2)
    
    #-----< id-aca-chargingIdentity >-----#
    id_aca_chargingIdentity = OID(name=u'id-aca-chargingIdentity', mode=MODE_VALUE)
    id_aca_chargingIdentity._val = (1, 3, 6, 1, 5, 5, 7, 10, 3)
    
    #-----< id-aca-group >-----#
    id_aca_group = OID(name=u'id-aca-group', mode=MODE_VALUE)
    id_aca_group._val = (1, 3, 6, 1, 5, 5, 7, 10, 4)
    
    #-----< id-aca-encAttrs >-----#
    id_aca_encAttrs = OID(name=u'id-aca-encAttrs', mode=MODE_VALUE)
    id_aca_encAttrs._val = (1, 3, 6, 1, 5, 5, 7, 10, 6)
    
    #-----< id-at-role >-----#
    id_at_role = OID(name=u'id-at-role', mode=MODE_VALUE)
    id_at_role._val = (2, 5, 4, 72)
    
    #-----< id-at-clearance >-----#
    id_at_clearance = OID(name=u'id-at-clearance', mode=MODE_VALUE)
    id_at_clearance._val = (2, 5, 4, 55)
    
    #-----< id-at-clearance-rfc3281 >-----#
    id_at_clearance_rfc3281 = OID(name=u'id-at-clearance-rfc3281', mode=MODE_VALUE)
    id_at_clearance_rfc3281._val = (2, 5, 1, 5, 55)
    
    #-----< AttributeCertificate >-----#
    AttributeCertificate = SEQ(name=u'AttributeCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'SIGNED')))
    _AttributeCertificate_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttributeCertificateInfo')))
    _AttributeCertificate_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE)
    __AttributeCertificate_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___AttributeCertificate_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    __SIGNATURE_ALGORITHM_HashSet_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___AttributeCertificate_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_3), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_4), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_5), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_6), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_7), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_8), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_9), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_10), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab = ___AttributeCertificate_algorithmIdentifier_algorithm_tab
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab_at = None
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __AttributeCertificate_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab = ___AttributeCertificate_algorithmIdentifier_algorithm_tab
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab_at = ('..', '..', u'algorithmIdentifier', u'algorithm')
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab_id = u'Params'
    _AttributeCertificate_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificate_algorithmIdentifier_algorithm),
        (u'parameters', __AttributeCertificate_algorithmIdentifier_parameters),
        ])
    _AttributeCertificate_algorithmIdentifier._ext = None
    _AttributeCertificate_signature = BIT_STR(name=u'signature', mode=MODE_TYPE)
    __AttributeCertificate_signature_contain = OPEN(name='_cont_signature', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Value']))
    __AttributeCertificate_signature_contain._const_tab = ___AttributeCertificate_algorithmIdentifier_algorithm_tab
    __AttributeCertificate_signature_contain._const_tab_at = ('..', u'algorithmIdentifier', u'algorithm')
    __AttributeCertificate_signature_contain._const_tab_id = u'Value'
    _AttributeCertificate_signature._const_cont = __AttributeCertificate_signature_contain
    AttributeCertificate._cont = ASN1Dict([
        (u'toBeSigned', _AttributeCertificate_toBeSigned),
        (u'algorithmIdentifier', _AttributeCertificate_algorithmIdentifier),
        (u'signature', _AttributeCertificate_signature),
        ])
    AttributeCertificate._ext = None
    
    #-----< AttributeCertificateInfo >-----#
    AttributeCertificateInfo = SEQ(name=u'AttributeCertificateInfo', mode=MODE_TYPE)
    _AttributeCertificateInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttCertVersion')))
    _AttributeCertificateInfo_holder = SEQ(name=u'holder', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Holder')))
    _AttributeCertificateInfo_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttCertIssuer')))
    _AttributeCertificateInfo_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __AttributeCertificateInfo_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___AttributeCertificateInfo_signature_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___AttributeCertificateInfo_signature_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_3), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_4), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_5), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_6), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 1)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_7), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_7), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 1))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 2)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_8), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_8), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 2))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 3)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_9), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_9), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 3, 4)), (u'Value', ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_10), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_10), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 3, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'Params', ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_11), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_1), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_2), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_3), (u'paramPresence', u'preferredAbsent')]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 3)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_4), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 10)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1), (u'paramPresence', u'optional'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 10))]))])], er=[])
    __AttributeCertificateInfo_signature_algorithm._const_tab = ___AttributeCertificateInfo_signature_algorithm_tab
    __AttributeCertificateInfo_signature_algorithm._const_tab_at = None
    __AttributeCertificateInfo_signature_algorithm._const_tab_id = u'id'
    __AttributeCertificateInfo_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'Params']), opt=True)
    __AttributeCertificateInfo_signature_parameters._const_tab = ___AttributeCertificateInfo_signature_algorithm_tab
    __AttributeCertificateInfo_signature_parameters._const_tab_at = ('..', u'algorithm')
    __AttributeCertificateInfo_signature_parameters._const_tab_id = u'Params'
    _AttributeCertificateInfo_signature._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificateInfo_signature_algorithm),
        (u'parameters', __AttributeCertificateInfo_signature_parameters),
        ])
    _AttributeCertificateInfo_signature._ext = None
    _AttributeCertificateInfo_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    _AttributeCertificateInfo_attrCertValidityPeriod = SEQ(name=u'attrCertValidityPeriod', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttCertValidityPeriod')))
    _AttributeCertificateInfo_attributes = SEQ_OF(name=u'attributes', mode=MODE_TYPE)
    __AttributeCertificateInfo_attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'AttributeSet')))
    ___AttributeCertificateInfo_attributes__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____AttributeCertificateInfo_attributes__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_3 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_4 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'RoleSyntax')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_5 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Clearance')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_6 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentInfo')))
    ____AttributeCertificateInfo_attributes__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 1))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_1), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 2))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_2), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 3))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_3), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 4))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_4), (u'id', (2, 5, 4, 72))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_5), (u'id', (2, 5, 4, 55))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_6), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 6))])], rr=[], ev=None, er=[])
    ___AttributeCertificateInfo_attributes__item__type._const_tab = ____AttributeCertificateInfo_attributes__item__type_tab
    ___AttributeCertificateInfo_attributes__item__type._const_tab_at = None
    ___AttributeCertificateInfo_attributes__item__type._const_tab_id = u'id'
    ___AttributeCertificateInfo_attributes__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AttributeCertificateInfo_attributes__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ____AttributeCertificateInfo_attributes__item__values__item_._const_tab = ____AttributeCertificateInfo_attributes__item__type_tab
    ____AttributeCertificateInfo_attributes__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AttributeCertificateInfo_attributes__item__values__item_._const_tab_id = u'Type'
    ___AttributeCertificateInfo_attributes__item__values._cont = ____AttributeCertificateInfo_attributes__item__values__item_
    ___AttributeCertificateInfo_attributes__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AttributeCertificateInfo_attributes__item_._cont = ASN1Dict([
        (u'type', ___AttributeCertificateInfo_attributes__item__type),
        (u'values', ___AttributeCertificateInfo_attributes__item__values),
        ])
    __AttributeCertificateInfo_attributes__item_._ext = None
    _AttributeCertificateInfo_attributes._cont = __AttributeCertificateInfo_attributes__item_
    _AttributeCertificateInfo_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'UniqueIdentifier')), opt=True)
    _AttributeCertificateInfo_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True)
    __AttributeCertificateInfo_extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___AttributeCertificateInfo_extensions__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____AttributeCertificateInfo_extensions__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_0 = OCT_STR(name=u'ExtnType', mode=MODE_TYPE)
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_1 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Targets')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_2 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityKeyIdentifier')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_3 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'AuthorityInfoAccessSyntax')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_4 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'CRLDistributionPoints')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_5 = NULL(name=u'ExtnType', mode=MODE_TYPE)
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_6 = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ProxyInfo')))
    _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_7 = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AAControls')))
    ____AttributeCertificateInfo_extensions__item__extnID_tab._val = ASN1Set(rv=[dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 4))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_1), (u'id', (2, 5, 29, 55))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_2), (u'id', (2, 5, 29, 35))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_3), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 1))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_4), (u'id', (2, 5, 29, 31))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_5), (u'id', (2, 5, 29, 56))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_6), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 10))]), dict([(u'ExtnType', _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_7), (u'id', (1, 3, 6, 1, 5, 5, 7, 1, 6))])], rr=[], ev=None, er=[])
    ___AttributeCertificateInfo_extensions__item__extnID._const_tab = ____AttributeCertificateInfo_extensions__item__extnID_tab
    ___AttributeCertificateInfo_extensions__item__extnID._const_tab_at = None
    ___AttributeCertificateInfo_extensions__item__extnID._const_tab_id = u'id'
    ___AttributeCertificateInfo_extensions__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___AttributeCertificateInfo_extensions__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____AttributeCertificateInfo_extensions__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    ____AttributeCertificateInfo_extensions__item__extnValue_contain._const_tab = ____AttributeCertificateInfo_extensions__item__extnID_tab
    ____AttributeCertificateInfo_extensions__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____AttributeCertificateInfo_extensions__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___AttributeCertificateInfo_extensions__item__extnValue._const_cont = ____AttributeCertificateInfo_extensions__item__extnValue_contain
    __AttributeCertificateInfo_extensions__item_._cont = ASN1Dict([
        (u'extnID', ___AttributeCertificateInfo_extensions__item__extnID),
        (u'critical', ___AttributeCertificateInfo_extensions__item__critical),
        (u'extnValue', ___AttributeCertificateInfo_extensions__item__extnValue),
        ])
    __AttributeCertificateInfo_extensions__item_._ext = None
    _AttributeCertificateInfo_extensions._cont = __AttributeCertificateInfo_extensions__item_
    _AttributeCertificateInfo_extensions._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    AttributeCertificateInfo._cont = ASN1Dict([
        (u'version', _AttributeCertificateInfo_version),
        (u'holder', _AttributeCertificateInfo_holder),
        (u'issuer', _AttributeCertificateInfo_issuer),
        (u'signature', _AttributeCertificateInfo_signature),
        (u'serialNumber', _AttributeCertificateInfo_serialNumber),
        (u'attrCertValidityPeriod', _AttributeCertificateInfo_attrCertValidityPeriod),
        (u'attributes', _AttributeCertificateInfo_attributes),
        (u'issuerUniqueID', _AttributeCertificateInfo_issuerUniqueID),
        (u'extensions', _AttributeCertificateInfo_extensions),
        ])
    AttributeCertificateInfo._ext = None
    
    #-----< AttCertVersion >-----#
    AttCertVersion = INT(name=u'AttCertVersion', mode=MODE_TYPE)
    AttCertVersion._cont = ASN1Dict([(u'v2', 1)])
    
    #-----< Holder >-----#
    Holder = SEQ(name=u'Holder', mode=MODE_TYPE)
    _Holder_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IssuerSerial')), opt=True)
    _Holder_entityName = SEQ_OF(name=u'entityName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    _Holder_objectDigestInfo = SEQ(name=u'objectDigestInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ObjectDigestInfo')), opt=True)
    Holder._cont = ASN1Dict([
        (u'baseCertificateID', _Holder_baseCertificateID),
        (u'entityName', _Holder_entityName),
        (u'objectDigestInfo', _Holder_objectDigestInfo),
        ])
    Holder._ext = None
    
    #-----< ObjectDigestInfo >-----#
    ObjectDigestInfo = SEQ(name=u'ObjectDigestInfo', mode=MODE_TYPE)
    _ObjectDigestInfo_digestedObjectType = ENUM(name=u'digestedObjectType', mode=MODE_TYPE)
    _ObjectDigestInfo_digestedObjectType._cont = ASN1Dict([(u'publicKey', 0), (u'publicKeyCert', 1), (u'otherObjectTypes', 2)])
    _ObjectDigestInfo_digestedObjectType._ext = None
    _ObjectDigestInfo_otherObjectTypeID = OID(name=u'otherObjectTypeID', mode=MODE_TYPE, opt=True)
    _ObjectDigestInfo_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __ObjectDigestInfo_digestAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___ObjectDigestInfo_digestAlgorithm_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___ObjectDigestInfo_digestAlgorithm_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab = ___ObjectDigestInfo_digestAlgorithm_algorithm_tab
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab_at = None
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab_id = u'id'
    __ObjectDigestInfo_digestAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    ___ObjectDigestInfo_digestAlgorithm_parameters_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___ObjectDigestInfo_digestAlgorithm_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab = ___ObjectDigestInfo_digestAlgorithm_parameters_tab
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab_id = u'Params'
    _ObjectDigestInfo_digestAlgorithm._cont = ASN1Dict([
        (u'algorithm', __ObjectDigestInfo_digestAlgorithm_algorithm),
        (u'parameters', __ObjectDigestInfo_digestAlgorithm_parameters),
        ])
    _ObjectDigestInfo_digestAlgorithm._ext = None
    _ObjectDigestInfo_objectDigest = BIT_STR(name=u'objectDigest', mode=MODE_TYPE)
    ObjectDigestInfo._cont = ASN1Dict([
        (u'digestedObjectType', _ObjectDigestInfo_digestedObjectType),
        (u'otherObjectTypeID', _ObjectDigestInfo_otherObjectTypeID),
        (u'digestAlgorithm', _ObjectDigestInfo_digestAlgorithm),
        (u'objectDigest', _ObjectDigestInfo_objectDigest),
        ])
    ObjectDigestInfo._ext = None
    
    #-----< AttCertIssuer >-----#
    AttCertIssuer = CHOICE(name=u'AttCertIssuer', mode=MODE_TYPE)
    _AttCertIssuer_v1Form = SEQ_OF(name=u'v1Form', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _AttCertIssuer_v2Form = SEQ(name=u'v2Form', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'V2Form')))
    AttCertIssuer._cont = ASN1Dict([
        (u'v1Form', _AttCertIssuer_v1Form),
        (u'v2Form', _AttCertIssuer_v2Form),
        ])
    AttCertIssuer._ext = None
    
    #-----< V2Form >-----#
    V2Form = SEQ(name=u'V2Form', mode=MODE_TYPE)
    _V2Form_issuerName = SEQ_OF(name=u'issuerName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    _V2Form_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IssuerSerial')), opt=True)
    _V2Form_objectDigestInfo = SEQ(name=u'objectDigestInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ObjectDigestInfo')), opt=True)
    V2Form._cont = ASN1Dict([
        (u'issuerName', _V2Form_issuerName),
        (u'baseCertificateID', _V2Form_baseCertificateID),
        (u'objectDigestInfo', _V2Form_objectDigestInfo),
        ])
    V2Form._ext = None
    
    #-----< IssuerSerial >-----#
    IssuerSerial = SEQ(name=u'IssuerSerial', mode=MODE_TYPE)
    _IssuerSerial_issuer = SEQ_OF(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')))
    _IssuerSerial_serial = INT(name=u'serial', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateSerialNumber')))
    _IssuerSerial_issuerUID = BIT_STR(name=u'issuerUID', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'UniqueIdentifier')), opt=True)
    IssuerSerial._cont = ASN1Dict([
        (u'issuer', _IssuerSerial_issuer),
        (u'serial', _IssuerSerial_serial),
        (u'issuerUID', _IssuerSerial_issuerUID),
        ])
    IssuerSerial._ext = None
    
    #-----< AttCertValidityPeriod >-----#
    AttCertValidityPeriod = SEQ(name=u'AttCertValidityPeriod', mode=MODE_TYPE)
    _AttCertValidityPeriod_notBeforeTime = TIME_GEN(name=u'notBeforeTime', mode=MODE_TYPE)
    _AttCertValidityPeriod_notAfterTime = TIME_GEN(name=u'notAfterTime', mode=MODE_TYPE)
    AttCertValidityPeriod._cont = ASN1Dict([
        (u'notBeforeTime', _AttCertValidityPeriod_notBeforeTime),
        (u'notAfterTime', _AttCertValidityPeriod_notAfterTime),
        ])
    AttCertValidityPeriod._ext = None
    
    #-----< Targets >-----#
    Targets = SEQ_OF(name=u'Targets', mode=MODE_TYPE)
    _Targets__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Target')))
    Targets._cont = _Targets__item_
    
    #-----< Target >-----#
    Target = CHOICE(name=u'Target', mode=MODE_TYPE)
    _Target_targetName = CHOICE(name=u'targetName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _Target_targetGroup = CHOICE(name=u'targetGroup', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _Target_targetCert = SEQ(name=u'targetCert', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'TargetCert')))
    Target._cont = ASN1Dict([
        (u'targetName', _Target_targetName),
        (u'targetGroup', _Target_targetGroup),
        (u'targetCert', _Target_targetCert),
        ])
    Target._ext = None
    
    #-----< TargetCert >-----#
    TargetCert = SEQ(name=u'TargetCert', mode=MODE_TYPE)
    _TargetCert_targetCertificate = SEQ(name=u'targetCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IssuerSerial')))
    _TargetCert_targetName = CHOICE(name=u'targetName', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')), opt=True)
    _TargetCert_certDigestInfo = SEQ(name=u'certDigestInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ObjectDigestInfo')), opt=True)
    TargetCert._cont = ASN1Dict([
        (u'targetCertificate', _TargetCert_targetCertificate),
        (u'targetName', _TargetCert_targetName),
        (u'certDigestInfo', _TargetCert_certDigestInfo),
        ])
    TargetCert._ext = None
    
    #-----< AAControls >-----#
    AAControls = SEQ(name=u'AAControls', mode=MODE_TYPE)
    _AAControls_pathLenConstraint = INT(name=u'pathLenConstraint', mode=MODE_TYPE, opt=True)
    _AAControls_pathLenConstraint._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _AAControls_permittedAttrs = SEQ_OF(name=u'permittedAttrs', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttrSpec')), opt=True)
    _AAControls_excludedAttrs = SEQ_OF(name=u'excludedAttrs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'AttrSpec')), opt=True)
    _AAControls_permitUnSpecified = BOOL(name=u'permitUnSpecified', mode=MODE_TYPE, default=True)
    AAControls._cont = ASN1Dict([
        (u'pathLenConstraint', _AAControls_pathLenConstraint),
        (u'permittedAttrs', _AAControls_permittedAttrs),
        (u'excludedAttrs', _AAControls_excludedAttrs),
        (u'permitUnSpecified', _AAControls_permitUnSpecified),
        ])
    AAControls._ext = None
    
    #-----< AttrSpec >-----#
    AttrSpec = SEQ_OF(name=u'AttrSpec', mode=MODE_TYPE)
    _AttrSpec__item_ = OID(name='_item_', mode=MODE_TYPE)
    AttrSpec._cont = _AttrSpec__item_
    
    #-----< ProxyInfo >-----#
    ProxyInfo = SEQ_OF(name=u'ProxyInfo', mode=MODE_TYPE)
    _ProxyInfo__item_ = SEQ_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Targets')))
    ProxyInfo._cont = _ProxyInfo__item_
    
    #-----< IetfAttrSyntax >-----#
    IetfAttrSyntax = SEQ(name=u'IetfAttrSyntax', mode=MODE_TYPE)
    _IetfAttrSyntax_policyAuthority = SEQ_OF(name=u'policyAuthority', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    _IetfAttrSyntax_values = SEQ_OF(name=u'values', mode=MODE_TYPE)
    __IetfAttrSyntax_values__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ___IetfAttrSyntax_values__item__octets = OCT_STR(name=u'octets', mode=MODE_TYPE)
    ___IetfAttrSyntax_values__item__oid = OID(name=u'oid', mode=MODE_TYPE)
    ___IetfAttrSyntax_values__item__string = STR_UTF8(name=u'string', mode=MODE_TYPE)
    __IetfAttrSyntax_values__item_._cont = ASN1Dict([
        (u'octets', ___IetfAttrSyntax_values__item__octets),
        (u'oid', ___IetfAttrSyntax_values__item__oid),
        (u'string', ___IetfAttrSyntax_values__item__string),
        ])
    __IetfAttrSyntax_values__item_._ext = None
    _IetfAttrSyntax_values._cont = __IetfAttrSyntax_values__item_
    IetfAttrSyntax._cont = ASN1Dict([
        (u'policyAuthority', _IetfAttrSyntax_policyAuthority),
        (u'values', _IetfAttrSyntax_values),
        ])
    IetfAttrSyntax._ext = None
    
    #-----< SvceAuthInfo >-----#
    SvceAuthInfo = SEQ(name=u'SvceAuthInfo', mode=MODE_TYPE)
    _SvceAuthInfo_service = CHOICE(name=u'service', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _SvceAuthInfo_ident = CHOICE(name=u'ident', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _SvceAuthInfo_authInfo = OCT_STR(name=u'authInfo', mode=MODE_TYPE, opt=True)
    SvceAuthInfo._cont = ASN1Dict([
        (u'service', _SvceAuthInfo_service),
        (u'ident', _SvceAuthInfo_ident),
        (u'authInfo', _SvceAuthInfo_authInfo),
        ])
    SvceAuthInfo._ext = None
    
    #-----< RoleSyntax >-----#
    RoleSyntax = SEQ(name=u'RoleSyntax', mode=MODE_TYPE)
    _RoleSyntax_roleAuthority = SEQ_OF(name=u'roleAuthority', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralNames')), opt=True)
    _RoleSyntax_roleName = CHOICE(name=u'roleName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    RoleSyntax._cont = ASN1Dict([
        (u'roleAuthority', _RoleSyntax_roleAuthority),
        (u'roleName', _RoleSyntax_roleName),
        ])
    RoleSyntax._ext = None
    
    #-----< Clearance >-----#
    Clearance = SEQ(name=u'Clearance', mode=MODE_TYPE)
    _Clearance_policyId = OID(name=u'policyId', mode=MODE_TYPE)
    _Clearance_classList = BIT_STR(name=u'classList', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ClassList')), default=(1, 2))
    _Clearance_securityCategories = SET_OF(name=u'securityCategories', mode=MODE_TYPE, opt=True)
    __Clearance_securityCategories__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SecurityCategory')))
    ___Clearance_securityCategories__item__type = OID(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY'), [u'id']))
    ____Clearance_securityCategories__item__type_tab = CLASS(name='_tab_SECURITY-CATEGORY', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY')))
    ____Clearance_securityCategories__item__type_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Clearance_securityCategories__item__type._const_tab = ____Clearance_securityCategories__item__type_tab
    ___Clearance_securityCategories__item__type._const_tab_at = None
    ___Clearance_securityCategories__item__type._const_tab_id = u'id'
    ___Clearance_securityCategories__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY'), [u'Type']))
    ____Clearance_securityCategories__item__value_tab = CLASS(name='_tab_SECURITY-CATEGORY', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY')))
    ____Clearance_securityCategories__item__value_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Clearance_securityCategories__item__value._const_tab = ____Clearance_securityCategories__item__value_tab
    ___Clearance_securityCategories__item__value._const_tab_at = ('..', u'type')
    ___Clearance_securityCategories__item__value._const_tab_id = u'Type'
    __Clearance_securityCategories__item_._cont = ASN1Dict([
        (u'type', ___Clearance_securityCategories__item__type),
        (u'value', ___Clearance_securityCategories__item__value),
        ])
    __Clearance_securityCategories__item_._ext = None
    _Clearance_securityCategories._cont = __Clearance_securityCategories__item_
    Clearance._cont = ASN1Dict([
        (u'policyId', _Clearance_policyId),
        (u'classList', _Clearance_classList),
        (u'securityCategories', _Clearance_securityCategories),
        ])
    Clearance._ext = None
    
    #-----< Clearance-rfc3281 >-----#
    Clearance_rfc3281 = SEQ(name=u'Clearance-rfc3281', mode=MODE_TYPE)
    _Clearance_rfc3281_policyId = OID(name=u'policyId', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Clearance_rfc3281_classList = BIT_STR(name=u'classList', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'ClassList')), default=(1, 2))
    _Clearance_rfc3281_securityCategories = SET_OF(name=u'securityCategories', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __Clearance_rfc3281_securityCategories__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SecurityCategory-rfc3281')))
    ___Clearance_rfc3281_securityCategories__item__type = OID(name=u'type', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY'), [u'id']))
    ____Clearance_rfc3281_securityCategories__item__type_tab = CLASS(name='_tab_SECURITY-CATEGORY', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY')))
    ____Clearance_rfc3281_securityCategories__item__type_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Clearance_rfc3281_securityCategories__item__type._const_tab = ____Clearance_rfc3281_securityCategories__item__type_tab
    ___Clearance_rfc3281_securityCategories__item__type._const_tab_at = None
    ___Clearance_rfc3281_securityCategories__item__type._const_tab_id = u'id'
    ___Clearance_rfc3281_securityCategories__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY'), [u'Type']))
    ____Clearance_rfc3281_securityCategories__item__value_tab = CLASS(name='_tab_SECURITY-CATEGORY', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY')))
    ____Clearance_rfc3281_securityCategories__item__value_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___Clearance_rfc3281_securityCategories__item__value._const_tab = ____Clearance_rfc3281_securityCategories__item__value_tab
    ___Clearance_rfc3281_securityCategories__item__value._const_tab_at = ('..', u'type')
    ___Clearance_rfc3281_securityCategories__item__value._const_tab_id = u'Type'
    __Clearance_rfc3281_securityCategories__item_._cont = ASN1Dict([
        (u'type', ___Clearance_rfc3281_securityCategories__item__type),
        (u'value', ___Clearance_rfc3281_securityCategories__item__value),
        ])
    __Clearance_rfc3281_securityCategories__item_._ext = None
    _Clearance_rfc3281_securityCategories._cont = __Clearance_rfc3281_securityCategories__item_
    Clearance_rfc3281._cont = ASN1Dict([
        (u'policyId', _Clearance_rfc3281_policyId),
        (u'classList', _Clearance_rfc3281_classList),
        (u'securityCategories', _Clearance_rfc3281_securityCategories),
        ])
    Clearance_rfc3281._ext = None
    
    #-----< ClassList >-----#
    ClassList = BIT_STR(name=u'ClassList', mode=MODE_TYPE)
    ClassList._cont = ASN1Dict([(u'unmarked', 0), (u'unclassified', 1), (u'restricted', 2), (u'confidential', 3), (u'secret', 4), (u'topSecret', 5)])
    
    #-----< SupportedSecurityCategories >-----#
    SupportedSecurityCategories = CLASS(name=u'SupportedSecurityCategories', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SECURITY-CATEGORY')))
    SupportedSecurityCategories._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< SecurityCategory-rfc3281 >-----#
    SecurityCategory_rfc3281 = SEQ(name=u'SecurityCategory-rfc3281', mode=MODE_TYPE, param=True)
    
    #-----< ACClearAttrs >-----#
    ACClearAttrs = SEQ(name=u'ACClearAttrs', mode=MODE_TYPE)
    _ACClearAttrs_acIssuer = CHOICE(name=u'acIssuer', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _ACClearAttrs_acSerial = INT(name=u'acSerial', mode=MODE_TYPE)
    _ACClearAttrs_attrs = SEQ_OF(name=u'attrs', mode=MODE_TYPE)
    __ACClearAttrs_attrs__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'AttributeSet')))
    ___ACClearAttrs_attrs__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____ACClearAttrs_attrs__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'SvceAuthInfo')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_3 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'IetfAttrSyntax')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_4 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'RoleSyntax')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_5 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAttributeCertificate-2009', 'Clearance')))
    _____ACClearAttrs_attrs__item__type_tab_val_Type_6 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CryptographicMessageSyntax-2009', 'ContentInfo')))
    ____ACClearAttrs_attrs__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 1))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_1), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 2))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_2), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 3))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_3), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 4))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_4), (u'id', (2, 5, 4, 72))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_5), (u'id', (2, 5, 4, 55))]), dict([(u'Type', _____ACClearAttrs_attrs__item__type_tab_val_Type_6), (u'id', (1, 3, 6, 1, 5, 5, 7, 10, 6))])], rr=[], ev=None, er=[])
    ___ACClearAttrs_attrs__item__type._const_tab = ____ACClearAttrs_attrs__item__type_tab
    ___ACClearAttrs_attrs__item__type._const_tab_at = None
    ___ACClearAttrs_attrs__item__type._const_tab_id = u'id'
    ___ACClearAttrs_attrs__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____ACClearAttrs_attrs__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ____ACClearAttrs_attrs__item__values__item_._const_tab = ____ACClearAttrs_attrs__item__type_tab
    ____ACClearAttrs_attrs__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____ACClearAttrs_attrs__item__values__item_._const_tab_id = u'Type'
    ___ACClearAttrs_attrs__item__values._cont = ____ACClearAttrs_attrs__item__values__item_
    ___ACClearAttrs_attrs__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __ACClearAttrs_attrs__item_._cont = ASN1Dict([
        (u'type', ___ACClearAttrs_attrs__item__type),
        (u'values', ___ACClearAttrs_attrs__item__values),
        ])
    __ACClearAttrs_attrs__item_._ext = None
    _ACClearAttrs_attrs._cont = __ACClearAttrs_attrs__item_
    ACClearAttrs._cont = ASN1Dict([
        (u'acIssuer', _ACClearAttrs_acIssuer),
        (u'acSerial', _ACClearAttrs_acSerial),
        (u'attrs', _ACClearAttrs_attrs),
        ])
    ACClearAttrs._ext = None
    
    _all_ = [
        AttributeCertExtensions,
        _AttributeCertExtensions_val_ExtnType_0,
        _AttributeCertExtensions_val_ExtnType_1,
        _AttributeCertExtensions_val_ExtnType_2,
        _AttributeCertExtensions_val_ExtnType_3,
        _AttributeCertExtensions_val_ExtnType_4,
        _AttributeCertExtensions_val_ExtnType_5,
        _AttributeCertExtensions_val_ExtnType_6,
        _AttributeCertExtensions_val_ExtnType_7,
        ext_auditIdentity,
        _ext_auditIdentity_val_ExtnType,
        ext_targetInformation,
        _ext_targetInformation_val_ExtnType,
        ext_noRevAvail,
        _ext_noRevAvail_val_ExtnType,
        ext_ac_proxying,
        _ext_ac_proxying_val_ExtnType,
        ext_aaControls,
        _ext_aaControls_val_ExtnType,
        AttributesDefined,
        _AttributesDefined_val_Type_0,
        _AttributesDefined_val_Type_1,
        _AttributesDefined_val_Type_2,
        _AttributesDefined_val_Type_3,
        _AttributesDefined_val_Type_4,
        _AttributesDefined_val_Type_5,
        _AttributesDefined_val_Type_6,
        at_authenticationInfo,
        _at_authenticationInfo_val_Type,
        at_accesIdentity,
        _at_accesIdentity_val_Type,
        at_chargingIdentity,
        _at_chargingIdentity_val_Type,
        at_group,
        _at_group_val_Type,
        at_role,
        _at_role_val_Type,
        at_clearance,
        _at_clearance_val_Type,
        at_clearance_RFC3281,
        _at_clearance_RFC3281_val_Type,
        at_encAttrs,
        _at_encAttrs_val_Type,
        id_pe_ac_auditIdentity,
        id_pe_aaControls,
        id_pe_ac_proxying,
        id_ce_targetInformation,
        id_ce_noRevAvail,
        id_aca,
        id_aca_authenticationInfo,
        id_aca_accessIdentity,
        id_aca_chargingIdentity,
        id_aca_group,
        id_aca_encAttrs,
        id_at_role,
        id_at_clearance,
        id_at_clearance_rfc3281,
        _AttributeCertificate_toBeSigned,
        ___AttributeCertificate_algorithmIdentifier_algorithm_tab,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_0,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_1,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_2,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_3,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_3,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_4,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_5,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_5,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_6,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_6,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_7,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_7,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_8,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_8,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_9,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_9,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Value_10,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_10,
        ____AttributeCertificate_algorithmIdentifier_algorithm_tab_val_Params_11,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_1,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_2,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_3,
        __SIGNATURE_ALGORITHM_HashSet_val_Params_4,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1,
        __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1,
        __AttributeCertificate_algorithmIdentifier_algorithm,
        __AttributeCertificate_algorithmIdentifier_parameters,
        _AttributeCertificate_algorithmIdentifier,
        __AttributeCertificate_signature_contain,
        _AttributeCertificate_signature,
        AttributeCertificate,
        _AttributeCertificateInfo_version,
        _AttributeCertificateInfo_holder,
        _AttributeCertificateInfo_issuer,
        ___AttributeCertificateInfo_signature_algorithm_tab,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_0,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_1,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_2,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_3,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_3,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_4,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_4,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_5,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_5,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_6,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_6,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_7,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_7,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_8,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_8,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_9,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_9,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Value_10,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_10,
        ____AttributeCertificateInfo_signature_algorithm_tab_val_Params_11,
        __AttributeCertificateInfo_signature_algorithm,
        __AttributeCertificateInfo_signature_parameters,
        _AttributeCertificateInfo_signature,
        _AttributeCertificateInfo_serialNumber,
        _AttributeCertificateInfo_attrCertValidityPeriod,
        ____AttributeCertificateInfo_attributes__item__type_tab,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_0,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_1,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_2,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_3,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_4,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_5,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_6,
        ___AttributeCertificateInfo_attributes__item__type,
        ____AttributeCertificateInfo_attributes__item__values__item_,
        ___AttributeCertificateInfo_attributes__item__values,
        __AttributeCertificateInfo_attributes__item_,
        _AttributeCertificateInfo_attributes,
        _AttributeCertificateInfo_issuerUniqueID,
        ____AttributeCertificateInfo_extensions__item__extnID_tab,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_0,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_1,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_2,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_3,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_4,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_5,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_6,
        _____AttributeCertificateInfo_extensions__item__extnID_tab_val_ExtnType_7,
        ___AttributeCertificateInfo_extensions__item__extnID,
        ___AttributeCertificateInfo_extensions__item__critical,
        ____AttributeCertificateInfo_extensions__item__extnValue_contain,
        ___AttributeCertificateInfo_extensions__item__extnValue,
        __AttributeCertificateInfo_extensions__item_,
        _AttributeCertificateInfo_extensions,
        AttributeCertificateInfo,
        AttCertVersion,
        _Holder_baseCertificateID,
        _Holder_entityName,
        _Holder_objectDigestInfo,
        Holder,
        _ObjectDigestInfo_digestedObjectType,
        _ObjectDigestInfo_otherObjectTypeID,
        ___ObjectDigestInfo_digestAlgorithm_algorithm_tab,
        __ObjectDigestInfo_digestAlgorithm_algorithm,
        ___ObjectDigestInfo_digestAlgorithm_parameters_tab,
        __ObjectDigestInfo_digestAlgorithm_parameters,
        _ObjectDigestInfo_digestAlgorithm,
        _ObjectDigestInfo_objectDigest,
        ObjectDigestInfo,
        _AttCertIssuer_v1Form,
        _AttCertIssuer_v2Form,
        AttCertIssuer,
        _V2Form_issuerName,
        _V2Form_baseCertificateID,
        _V2Form_objectDigestInfo,
        V2Form,
        _IssuerSerial_issuer,
        _IssuerSerial_serial,
        _IssuerSerial_issuerUID,
        IssuerSerial,
        _AttCertValidityPeriod_notBeforeTime,
        _AttCertValidityPeriod_notAfterTime,
        AttCertValidityPeriod,
        _Targets__item_,
        Targets,
        _Target_targetName,
        _Target_targetGroup,
        _Target_targetCert,
        Target,
        _TargetCert_targetCertificate,
        _TargetCert_targetName,
        _TargetCert_certDigestInfo,
        TargetCert,
        _AAControls_pathLenConstraint,
        _AAControls_permittedAttrs,
        _AAControls_excludedAttrs,
        _AAControls_permitUnSpecified,
        AAControls,
        _AttrSpec__item_,
        AttrSpec,
        _ProxyInfo__item_,
        ProxyInfo,
        _IetfAttrSyntax_policyAuthority,
        ___IetfAttrSyntax_values__item__octets,
        ___IetfAttrSyntax_values__item__oid,
        ___IetfAttrSyntax_values__item__string,
        __IetfAttrSyntax_values__item_,
        _IetfAttrSyntax_values,
        IetfAttrSyntax,
        _SvceAuthInfo_service,
        _SvceAuthInfo_ident,
        _SvceAuthInfo_authInfo,
        SvceAuthInfo,
        _RoleSyntax_roleAuthority,
        _RoleSyntax_roleName,
        RoleSyntax,
        _Clearance_policyId,
        _Clearance_classList,
        ____Clearance_securityCategories__item__type_tab,
        ___Clearance_securityCategories__item__type,
        ____Clearance_securityCategories__item__value_tab,
        ___Clearance_securityCategories__item__value,
        __Clearance_securityCategories__item_,
        _Clearance_securityCategories,
        Clearance,
        _Clearance_rfc3281_policyId,
        _Clearance_rfc3281_classList,
        ____Clearance_rfc3281_securityCategories__item__type_tab,
        ___Clearance_rfc3281_securityCategories__item__type,
        ____Clearance_rfc3281_securityCategories__item__value_tab,
        ___Clearance_rfc3281_securityCategories__item__value,
        __Clearance_rfc3281_securityCategories__item_,
        _Clearance_rfc3281_securityCategories,
        Clearance_rfc3281,
        ClassList,
        SupportedSecurityCategories,
        _ACClearAttrs_acIssuer,
        _ACClearAttrs_acSerial,
        ____ACClearAttrs_attrs__item__type_tab,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_0,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_1,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_2,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_3,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_4,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_5,
        _____ACClearAttrs_attrs__item__type_tab_val_Type_6,
        ___ACClearAttrs_attrs__item__type,
        ____ACClearAttrs_attrs__item__values__item_,
        ___ACClearAttrs_attrs__item__values,
        __ACClearAttrs_attrs__item_,
        _ACClearAttrs_attrs,
        ACClearAttrs,
    ]

class PKIXCMP_2009:

    _name_  = u'PKIXCMP-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 50]
    
    _obj_ = [
        u'CMPCertificate',
        u'PKIMessage',
        u'PKIMessages',
        u'PKIHeader',
        u'PKIFreeText',
        u'PKIBody',
        u'PKIProtection',
        u'ProtectedPart',
        u'id-PasswordBasedMac',
        u'PBMParameter',
        u'id-DHBasedMac',
        u'DHBMParameter',
        u'PKIStatus',
        u'PKIFailureInfo',
        u'PKIStatusInfo',
        u'OOBCert',
        u'OOBCertHash',
        u'POPODecKeyChallContent',
        u'Challenge',
        u'POPODecKeyRespContent',
        u'CertRepMessage',
        u'CertResponse',
        u'CertifiedKeyPair',
        u'CertOrEncCert',
        u'KeyRecRepContent',
        u'RevReqContent',
        u'RevDetails',
        u'RevRepContent',
        u'CAKeyUpdAnnContent',
        u'CertAnnContent',
        u'RevAnnContent',
        u'CRLAnnContent',
        u'PKIConfirmContent',
        u'NestedMessageContent',
        u'INFO-TYPE-AND-VALUE',
        u'InfoTypeAndValue',
        u'SupportedInfoSet',
        u'GenMsgContent',
        u'GenRepContent',
        u'ErrorMsgContent',
        u'CertConfirmContent',
        u'CertStatus',
        u'PollReqContent',
        u'PollRepContent',
        ]
    _type_ = [
        u'CMPCertificate',
        u'PKIMessage',
        u'PKIMessages',
        u'PKIHeader',
        u'PKIFreeText',
        u'PKIBody',
        u'PKIProtection',
        u'ProtectedPart',
        u'PBMParameter',
        u'DHBMParameter',
        u'PKIStatus',
        u'PKIFailureInfo',
        u'PKIStatusInfo',
        u'OOBCert',
        u'OOBCertHash',
        u'POPODecKeyChallContent',
        u'Challenge',
        u'POPODecKeyRespContent',
        u'CertRepMessage',
        u'CertResponse',
        u'CertifiedKeyPair',
        u'CertOrEncCert',
        u'KeyRecRepContent',
        u'RevReqContent',
        u'RevDetails',
        u'RevRepContent',
        u'CAKeyUpdAnnContent',
        u'CertAnnContent',
        u'RevAnnContent',
        u'CRLAnnContent',
        u'PKIConfirmContent',
        u'NestedMessageContent',
        u'INFO-TYPE-AND-VALUE',
        u'InfoTypeAndValue',
        u'GenMsgContent',
        u'GenRepContent',
        u'ErrorMsgContent',
        u'CertConfirmContent',
        u'CertStatus',
        u'PollReqContent',
        u'PollRepContent',
        ]
    _set_ = [
        u'SupportedInfoSet',
        ]
    _val_ = [
        u'id-PasswordBasedMac',
        u'id-DHBasedMac',
        ]
    _class_ = [
        u'INFO-TYPE-AND-VALUE',
        u'SupportedInfoSet',
        ]
    _param_ = [
        ]
    
    #-----< CMPCertificate >-----#
    CMPCertificate = CHOICE(name=u'CMPCertificate', mode=MODE_TYPE)
    _CMPCertificate_x509v3PKCert = SEQ(name=u'x509v3PKCert', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'Certificate')))
    CMPCertificate._cont = ASN1Dict([
        (u'x509v3PKCert', _CMPCertificate_x509v3PKCert),
        ])
    CMPCertificate._ext = []
    
    #-----< PKIMessage >-----#
    PKIMessage = SEQ(name=u'PKIMessage', mode=MODE_TYPE)
    _PKIMessage_header = SEQ(name=u'header', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIHeader')))
    _PKIMessage_body = CHOICE(name=u'body', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIBody')))
    _PKIMessage_protection = BIT_STR(name=u'protection', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'PKIProtection')), opt=True)
    _PKIMessage_extraCerts = SEQ_OF(name=u'extraCerts', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __PKIMessage_extraCerts__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CMPCertificate')))
    _PKIMessage_extraCerts._cont = __PKIMessage_extraCerts__item_
    _PKIMessage_extraCerts._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PKIMessage._cont = ASN1Dict([
        (u'header', _PKIMessage_header),
        (u'body', _PKIMessage_body),
        (u'protection', _PKIMessage_protection),
        (u'extraCerts', _PKIMessage_extraCerts),
        ])
    PKIMessage._ext = None
    
    #-----< PKIMessages >-----#
    PKIMessages = SEQ_OF(name=u'PKIMessages', mode=MODE_TYPE)
    _PKIMessages__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIMessage')))
    PKIMessages._cont = _PKIMessages__item_
    PKIMessages._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PKIHeader >-----#
    PKIHeader = SEQ(name=u'PKIHeader', mode=MODE_TYPE)
    _PKIHeader_pvno = INT(name=u'pvno', mode=MODE_TYPE)
    _PKIHeader_pvno._cont = ASN1Dict([(u'cmp1999', 1), (u'cmp2000', 2)])
    _PKIHeader_sender = CHOICE(name=u'sender', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _PKIHeader_recipient = CHOICE(name=u'recipient', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit-2009', 'GeneralName')))
    _PKIHeader_messageTime = TIME_GEN(name=u'messageTime', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PKIHeader_protectionAlg = SEQ(name=u'protectionAlg', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')), opt=True)
    __PKIHeader_protectionAlg_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'id']))
    ___PKIHeader_protectionAlg_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    ___PKIHeader_protectionAlg_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __PKIHeader_protectionAlg_algorithm._const_tab = ___PKIHeader_protectionAlg_algorithm_tab
    __PKIHeader_protectionAlg_algorithm._const_tab_at = None
    __PKIHeader_protectionAlg_algorithm._const_tab_id = u'id'
    __PKIHeader_protectionAlg_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'ALGORITHM'), [u'Params']), opt=True)
    ___PKIHeader_protectionAlg_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'ALGORITHM')))
    ___PKIHeader_protectionAlg_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __PKIHeader_protectionAlg_parameters._const_tab = ___PKIHeader_protectionAlg_parameters_tab
    __PKIHeader_protectionAlg_parameters._const_tab_at = ('..', u'algorithm')
    __PKIHeader_protectionAlg_parameters._const_tab_id = u'Params'
    _PKIHeader_protectionAlg._cont = ASN1Dict([
        (u'algorithm', __PKIHeader_protectionAlg_algorithm),
        (u'parameters', __PKIHeader_protectionAlg_parameters),
        ])
    _PKIHeader_protectionAlg._ext = None
    _PKIHeader_senderKID = OCT_STR(name=u'senderKID', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')), opt=True)
    _PKIHeader_recipKID = OCT_STR(name=u'recipKID', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIX1Implicit-2009', 'KeyIdentifier')), opt=True)
    _PKIHeader_transactionID = OCT_STR(name=u'transactionID', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PKIHeader_senderNonce = OCT_STR(name=u'senderNonce', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PKIHeader_recipNonce = OCT_STR(name=u'recipNonce', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PKIHeader_freeText = SEQ_OF(name=u'freeText', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'PKIFreeText')), opt=True)
    _PKIHeader_generalInfo = SEQ_OF(name=u'generalInfo', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __PKIHeader_generalInfo__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'InfoTypeAndValue')))
    _PKIHeader_generalInfo._cont = __PKIHeader_generalInfo__item_
    _PKIHeader_generalInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PKIHeader._cont = ASN1Dict([
        (u'pvno', _PKIHeader_pvno),
        (u'sender', _PKIHeader_sender),
        (u'recipient', _PKIHeader_recipient),
        (u'messageTime', _PKIHeader_messageTime),
        (u'protectionAlg', _PKIHeader_protectionAlg),
        (u'senderKID', _PKIHeader_senderKID),
        (u'recipKID', _PKIHeader_recipKID),
        (u'transactionID', _PKIHeader_transactionID),
        (u'senderNonce', _PKIHeader_senderNonce),
        (u'recipNonce', _PKIHeader_recipNonce),
        (u'freeText', _PKIHeader_freeText),
        (u'generalInfo', _PKIHeader_generalInfo),
        ])
    PKIHeader._ext = None
    
    #-----< PKIFreeText >-----#
    PKIFreeText = SEQ_OF(name=u'PKIFreeText', mode=MODE_TYPE)
    _PKIFreeText__item_ = STR_UTF8(name='_item_', mode=MODE_TYPE)
    PKIFreeText._cont = _PKIFreeText__item_
    PKIFreeText._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PKIBody >-----#
    PKIBody = CHOICE(name=u'PKIBody', mode=MODE_TYPE)
    _PKIBody_ir = SEQ_OF(name=u'ir', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCRMF-2009', 'CertReqMessages')))
    _PKIBody_ip = SEQ(name=u'ip', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'CertRepMessage')))
    _PKIBody_cr = SEQ_OF(name=u'cr', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCRMF-2009', 'CertReqMessages')))
    _PKIBody_cp = SEQ(name=u'cp', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'CertRepMessage')))
    _PKIBody_p10cr = SEQ(name=u'p10cr', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKCS-10', 'CertificationRequest')))
    _PKIBody_popdecc = SEQ_OF(name=u'popdecc', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'POPODecKeyChallContent')))
    _PKIBody_popdecr = SEQ_OF(name=u'popdecr', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'POPODecKeyRespContent')))
    _PKIBody_kur = SEQ_OF(name=u'kur', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCRMF-2009', 'CertReqMessages')))
    _PKIBody_kup = SEQ(name=u'kup', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'CertRepMessage')))
    _PKIBody_krr = SEQ_OF(name=u'krr', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCRMF-2009', 'CertReqMessages')))
    _PKIBody_krp = SEQ(name=u'krp', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'KeyRecRepContent')))
    _PKIBody_rr = SEQ_OF(name=u'rr', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'RevReqContent')))
    _PKIBody_rp = SEQ(name=u'rp', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'RevRepContent')))
    _PKIBody_ccr = SEQ_OF(name=u'ccr', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCRMF-2009', 'CertReqMessages')))
    _PKIBody_ccp = SEQ(name=u'ccp', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'CertRepMessage')))
    _PKIBody_ckuann = SEQ(name=u'ckuann', mode=MODE_TYPE, tag=(15, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'CAKeyUpdAnnContent')))
    _PKIBody_cann = CHOICE(name=u'cann', mode=MODE_TYPE, tag=(16, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'CertAnnContent')))
    _PKIBody_rann = SEQ(name=u'rann', mode=MODE_TYPE, tag=(17, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'RevAnnContent')))
    _PKIBody_crlann = SEQ_OF(name=u'crlann', mode=MODE_TYPE, tag=(18, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'CRLAnnContent')))
    _PKIBody_pkiconf = NULL(name=u'pkiconf', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'PKIConfirmContent')))
    _PKIBody_nested = SEQ_OF(name=u'nested', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'NestedMessageContent')))
    _PKIBody_genm = SEQ_OF(name=u'genm', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'GenMsgContent')))
    _PKIBody_genp = SEQ_OF(name=u'genp', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'GenRepContent')))
    _PKIBody_error = SEQ(name=u'error', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'ErrorMsgContent')))
    _PKIBody_certConf = SEQ_OF(name=u'certConf', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'CertConfirmContent')))
    _PKIBody_pollReq = SEQ_OF(name=u'pollReq', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'PollReqContent')))
    _PKIBody_pollRep = SEQ_OF(name=u'pollRep', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'PollRepContent')))
    PKIBody._cont = ASN1Dict([
        (u'ir', _PKIBody_ir),
        (u'ip', _PKIBody_ip),
        (u'cr', _PKIBody_cr),
        (u'cp', _PKIBody_cp),
        (u'p10cr', _PKIBody_p10cr),
        (u'popdecc', _PKIBody_popdecc),
        (u'popdecr', _PKIBody_popdecr),
        (u'kur', _PKIBody_kur),
        (u'kup', _PKIBody_kup),
        (u'krr', _PKIBody_krr),
        (u'krp', _PKIBody_krp),
        (u'rr', _PKIBody_rr),
        (u'rp', _PKIBody_rp),
        (u'ccr', _PKIBody_ccr),
        (u'ccp', _PKIBody_ccp),
        (u'ckuann', _PKIBody_ckuann),
        (u'cann', _PKIBody_cann),
        (u'rann', _PKIBody_rann),
        (u'crlann', _PKIBody_crlann),
        (u'pkiconf', _PKIBody_pkiconf),
        (u'nested', _PKIBody_nested),
        (u'genm', _PKIBody_genm),
        (u'genp', _PKIBody_genp),
        (u'error', _PKIBody_error),
        (u'certConf', _PKIBody_certConf),
        (u'pollReq', _PKIBody_pollReq),
        (u'pollRep', _PKIBody_pollRep),
        ])
    PKIBody._ext = None
    
    #-----< PKIProtection >-----#
    PKIProtection = BIT_STR(name=u'PKIProtection', mode=MODE_TYPE)
    
    #-----< ProtectedPart >-----#
    ProtectedPart = SEQ(name=u'ProtectedPart', mode=MODE_TYPE)
    _ProtectedPart_header = SEQ(name=u'header', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIHeader')))
    _ProtectedPart_body = CHOICE(name=u'body', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIBody')))
    ProtectedPart._cont = ASN1Dict([
        (u'header', _ProtectedPart_header),
        (u'body', _ProtectedPart_body),
        ])
    ProtectedPart._ext = None
    
    #-----< id-PasswordBasedMac >-----#
    id_PasswordBasedMac = OID(name=u'id-PasswordBasedMac', mode=MODE_VALUE)
    id_PasswordBasedMac._val = (1, 2, 840, 113533, 7, 66, 13)
    
    #-----< PBMParameter >-----#
    PBMParameter = SEQ(name=u'PBMParameter', mode=MODE_TYPE)
    _PBMParameter_salt = OCT_STR(name=u'salt', mode=MODE_TYPE)
    _PBMParameter_owf = SEQ(name=u'owf', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __PBMParameter_owf_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___PBMParameter_owf_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___PBMParameter_owf_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __PBMParameter_owf_algorithm._const_tab = ___PBMParameter_owf_algorithm_tab
    __PBMParameter_owf_algorithm._const_tab_at = None
    __PBMParameter_owf_algorithm._const_tab_id = u'id'
    __PBMParameter_owf_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    ___PBMParameter_owf_parameters_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___PBMParameter_owf_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __PBMParameter_owf_parameters._const_tab = ___PBMParameter_owf_parameters_tab
    __PBMParameter_owf_parameters._const_tab_at = ('..', u'algorithm')
    __PBMParameter_owf_parameters._const_tab_id = u'Params'
    _PBMParameter_owf._cont = ASN1Dict([
        (u'algorithm', __PBMParameter_owf_algorithm),
        (u'parameters', __PBMParameter_owf_parameters),
        ])
    _PBMParameter_owf._ext = None
    _PBMParameter_iterationCount = INT(name=u'iterationCount', mode=MODE_TYPE)
    _PBMParameter_mac = SEQ(name=u'mac', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __PBMParameter_mac_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'id']))
    ___PBMParameter_mac_algorithm_tab = CLASS(name='_tab_MAC-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    ___PBMParameter_mac_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __PBMParameter_mac_algorithm._const_tab = ___PBMParameter_mac_algorithm_tab
    __PBMParameter_mac_algorithm._const_tab_at = None
    __PBMParameter_mac_algorithm._const_tab_id = u'id'
    __PBMParameter_mac_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'Params']), opt=True)
    ___PBMParameter_mac_parameters_tab = CLASS(name='_tab_MAC-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    ___PBMParameter_mac_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __PBMParameter_mac_parameters._const_tab = ___PBMParameter_mac_parameters_tab
    __PBMParameter_mac_parameters._const_tab_at = ('..', u'algorithm')
    __PBMParameter_mac_parameters._const_tab_id = u'Params'
    _PBMParameter_mac._cont = ASN1Dict([
        (u'algorithm', __PBMParameter_mac_algorithm),
        (u'parameters', __PBMParameter_mac_parameters),
        ])
    _PBMParameter_mac._ext = None
    PBMParameter._cont = ASN1Dict([
        (u'salt', _PBMParameter_salt),
        (u'owf', _PBMParameter_owf),
        (u'iterationCount', _PBMParameter_iterationCount),
        (u'mac', _PBMParameter_mac),
        ])
    PBMParameter._ext = None
    
    #-----< id-DHBasedMac >-----#
    id_DHBasedMac = OID(name=u'id-DHBasedMac', mode=MODE_VALUE)
    id_DHBasedMac._val = (1, 2, 840, 113533, 7, 66, 30)
    
    #-----< DHBMParameter >-----#
    DHBMParameter = SEQ(name=u'DHBMParameter', mode=MODE_TYPE)
    _DHBMParameter_owf = SEQ(name=u'owf', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __DHBMParameter_owf_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___DHBMParameter_owf_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___DHBMParameter_owf_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __DHBMParameter_owf_algorithm._const_tab = ___DHBMParameter_owf_algorithm_tab
    __DHBMParameter_owf_algorithm._const_tab_at = None
    __DHBMParameter_owf_algorithm._const_tab_id = u'id'
    __DHBMParameter_owf_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    ___DHBMParameter_owf_parameters_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___DHBMParameter_owf_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __DHBMParameter_owf_parameters._const_tab = ___DHBMParameter_owf_parameters_tab
    __DHBMParameter_owf_parameters._const_tab_at = ('..', u'algorithm')
    __DHBMParameter_owf_parameters._const_tab_id = u'Params'
    _DHBMParameter_owf._cont = ASN1Dict([
        (u'algorithm', __DHBMParameter_owf_algorithm),
        (u'parameters', __DHBMParameter_owf_parameters),
        ])
    _DHBMParameter_owf._ext = None
    _DHBMParameter_mac = SEQ(name=u'mac', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')))
    __DHBMParameter_mac_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'id']))
    ___DHBMParameter_mac_algorithm_tab = CLASS(name='_tab_MAC-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    ___DHBMParameter_mac_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __DHBMParameter_mac_algorithm._const_tab = ___DHBMParameter_mac_algorithm_tab
    __DHBMParameter_mac_algorithm._const_tab_at = None
    __DHBMParameter_mac_algorithm._const_tab_id = u'id'
    __DHBMParameter_mac_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'MAC-ALGORITHM'), [u'Params']), opt=True)
    ___DHBMParameter_mac_parameters_tab = CLASS(name='_tab_MAC-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'MAC-ALGORITHM')))
    ___DHBMParameter_mac_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __DHBMParameter_mac_parameters._const_tab = ___DHBMParameter_mac_parameters_tab
    __DHBMParameter_mac_parameters._const_tab_at = ('..', u'algorithm')
    __DHBMParameter_mac_parameters._const_tab_id = u'Params'
    _DHBMParameter_mac._cont = ASN1Dict([
        (u'algorithm', __DHBMParameter_mac_algorithm),
        (u'parameters', __DHBMParameter_mac_parameters),
        ])
    _DHBMParameter_mac._ext = None
    DHBMParameter._cont = ASN1Dict([
        (u'owf', _DHBMParameter_owf),
        (u'mac', _DHBMParameter_mac),
        ])
    DHBMParameter._ext = None
    
    #-----< PKIStatus >-----#
    PKIStatus = INT(name=u'PKIStatus', mode=MODE_TYPE)
    PKIStatus._cont = ASN1Dict([(u'accepted', 0), (u'grantedWithMods', 1), (u'rejection', 2), (u'waiting', 3), (u'revocationWarning', 4), (u'revocationNotification', 5), (u'keyUpdateWarning', 6)])
    
    #-----< PKIFailureInfo >-----#
    PKIFailureInfo = BIT_STR(name=u'PKIFailureInfo', mode=MODE_TYPE)
    PKIFailureInfo._cont = ASN1Dict([(u'badAlg', 0), (u'badMessageCheck', 1), (u'badRequest', 2), (u'badTime', 3), (u'badCertId', 4), (u'badDataFormat', 5), (u'wrongAuthority', 6), (u'incorrectData', 7), (u'missingTimeStamp', 8), (u'badPOP', 9), (u'certRevoked', 10), (u'certConfirmed', 11), (u'wrongIntegrity', 12), (u'badRecipientNonce', 13), (u'timeNotAvailable', 14), (u'unacceptedPolicy', 15), (u'unacceptedExtension', 16), (u'addInfoNotAvailable', 17), (u'badSenderNonce', 18), (u'badCertTemplate', 19), (u'signerNotTrusted', 20), (u'transactionIdInUse', 21), (u'unsupportedVersion', 22), (u'notAuthorized', 23), (u'systemUnavail', 24), (u'systemFailure', 25), (u'duplicateCertReq', 26)])
    
    #-----< PKIStatusInfo >-----#
    PKIStatusInfo = SEQ(name=u'PKIStatusInfo', mode=MODE_TYPE)
    _PKIStatusInfo_status = INT(name=u'status', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIStatus')))
    _PKIStatusInfo_statusString = SEQ_OF(name=u'statusString', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIFreeText')), opt=True)
    _PKIStatusInfo_failInfo = BIT_STR(name=u'failInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIFailureInfo')), opt=True)
    PKIStatusInfo._cont = ASN1Dict([
        (u'status', _PKIStatusInfo_status),
        (u'statusString', _PKIStatusInfo_statusString),
        (u'failInfo', _PKIStatusInfo_failInfo),
        ])
    PKIStatusInfo._ext = None
    
    #-----< OOBCert >-----#
    OOBCert = CHOICE(name=u'OOBCert', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CMPCertificate')))
    
    #-----< OOBCertHash >-----#
    OOBCertHash = SEQ(name=u'OOBCertHash', mode=MODE_TYPE)
    _OOBCertHash_hashAlg = SEQ(name=u'hashAlg', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')), opt=True)
    __OOBCertHash_hashAlg_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___OOBCertHash_hashAlg_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___OOBCertHash_hashAlg_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __OOBCertHash_hashAlg_algorithm._const_tab = ___OOBCertHash_hashAlg_algorithm_tab
    __OOBCertHash_hashAlg_algorithm._const_tab_at = None
    __OOBCertHash_hashAlg_algorithm._const_tab_id = u'id'
    __OOBCertHash_hashAlg_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    ___OOBCertHash_hashAlg_parameters_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___OOBCertHash_hashAlg_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __OOBCertHash_hashAlg_parameters._const_tab = ___OOBCertHash_hashAlg_parameters_tab
    __OOBCertHash_hashAlg_parameters._const_tab_at = ('..', u'algorithm')
    __OOBCertHash_hashAlg_parameters._const_tab_id = u'Params'
    _OOBCertHash_hashAlg._cont = ASN1Dict([
        (u'algorithm', __OOBCertHash_hashAlg_algorithm),
        (u'parameters', __OOBCertHash_hashAlg_parameters),
        ])
    _OOBCertHash_hashAlg._ext = None
    _OOBCertHash_certId = SEQ(name=u'certId', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCRMF-2009', 'CertId')), opt=True)
    _OOBCertHash_hashVal = BIT_STR(name=u'hashVal', mode=MODE_TYPE)
    OOBCertHash._cont = ASN1Dict([
        (u'hashAlg', _OOBCertHash_hashAlg),
        (u'certId', _OOBCertHash_certId),
        (u'hashVal', _OOBCertHash_hashVal),
        ])
    OOBCertHash._ext = None
    
    #-----< POPODecKeyChallContent >-----#
    POPODecKeyChallContent = SEQ_OF(name=u'POPODecKeyChallContent', mode=MODE_TYPE)
    _POPODecKeyChallContent__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'Challenge')))
    POPODecKeyChallContent._cont = _POPODecKeyChallContent__item_
    
    #-----< Challenge >-----#
    Challenge = SEQ(name=u'Challenge', mode=MODE_TYPE)
    _Challenge_owf = SEQ(name=u'owf', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')), opt=True)
    __Challenge_owf_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'id']))
    ___Challenge_owf_algorithm_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___Challenge_owf_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __Challenge_owf_algorithm._const_tab = ___Challenge_owf_algorithm_tab
    __Challenge_owf_algorithm._const_tab_at = None
    __Challenge_owf_algorithm._const_tab_id = u'id'
    __Challenge_owf_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM'), [u'Params']), opt=True)
    ___Challenge_owf_parameters_tab = CLASS(name='_tab_DIGEST-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'DIGEST-ALGORITHM')))
    ___Challenge_owf_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    __Challenge_owf_parameters._const_tab = ___Challenge_owf_parameters_tab
    __Challenge_owf_parameters._const_tab_at = ('..', u'algorithm')
    __Challenge_owf_parameters._const_tab_id = u'Params'
    _Challenge_owf._cont = ASN1Dict([
        (u'algorithm', __Challenge_owf_algorithm),
        (u'parameters', __Challenge_owf_parameters),
        ])
    _Challenge_owf._ext = None
    _Challenge_witness = OCT_STR(name=u'witness', mode=MODE_TYPE)
    _Challenge_challenge = OCT_STR(name=u'challenge', mode=MODE_TYPE)
    Challenge._cont = ASN1Dict([
        (u'owf', _Challenge_owf),
        (u'witness', _Challenge_witness),
        (u'challenge', _Challenge_challenge),
        ])
    Challenge._ext = None
    
    #-----< POPODecKeyRespContent >-----#
    POPODecKeyRespContent = SEQ_OF(name=u'POPODecKeyRespContent', mode=MODE_TYPE)
    _POPODecKeyRespContent__item_ = INT(name='_item_', mode=MODE_TYPE)
    POPODecKeyRespContent._cont = _POPODecKeyRespContent__item_
    
    #-----< CertRepMessage >-----#
    CertRepMessage = SEQ(name=u'CertRepMessage', mode=MODE_TYPE)
    _CertRepMessage_caPubs = SEQ_OF(name=u'caPubs', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __CertRepMessage_caPubs__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CMPCertificate')))
    _CertRepMessage_caPubs._cont = __CertRepMessage_caPubs__item_
    _CertRepMessage_caPubs._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _CertRepMessage_response = SEQ_OF(name=u'response', mode=MODE_TYPE)
    __CertRepMessage_response__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CertResponse')))
    _CertRepMessage_response._cont = __CertRepMessage_response__item_
    CertRepMessage._cont = ASN1Dict([
        (u'caPubs', _CertRepMessage_caPubs),
        (u'response', _CertRepMessage_response),
        ])
    CertRepMessage._ext = None
    
    #-----< CertResponse >-----#
    CertResponse = SEQ(name=u'CertResponse', mode=MODE_TYPE)
    _CertResponse_certReqId = INT(name=u'certReqId', mode=MODE_TYPE)
    _CertResponse_status = SEQ(name=u'status', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIStatusInfo')))
    _CertResponse_certifiedKeyPair = SEQ(name=u'certifiedKeyPair', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CertifiedKeyPair')), opt=True)
    _CertResponse_rspInfo = OCT_STR(name=u'rspInfo', mode=MODE_TYPE, opt=True)
    CertResponse._cont = ASN1Dict([
        (u'certReqId', _CertResponse_certReqId),
        (u'status', _CertResponse_status),
        (u'certifiedKeyPair', _CertResponse_certifiedKeyPair),
        (u'rspInfo', _CertResponse_rspInfo),
        ])
    CertResponse._ext = None
    
    #-----< CertifiedKeyPair >-----#
    CertifiedKeyPair = SEQ(name=u'CertifiedKeyPair', mode=MODE_TYPE)
    _CertifiedKeyPair_certOrEncCert = CHOICE(name=u'certOrEncCert', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CertOrEncCert')))
    _CertifiedKeyPair_privateKey = SEQ(name=u'privateKey', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCRMF-2009', 'EncryptedValue')), opt=True)
    _CertifiedKeyPair_publicationInfo = SEQ(name=u'publicationInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCRMF-2009', 'PKIPublicationInfo')), opt=True)
    CertifiedKeyPair._cont = ASN1Dict([
        (u'certOrEncCert', _CertifiedKeyPair_certOrEncCert),
        (u'privateKey', _CertifiedKeyPair_privateKey),
        (u'publicationInfo', _CertifiedKeyPair_publicationInfo),
        ])
    CertifiedKeyPair._ext = None
    
    #-----< CertOrEncCert >-----#
    CertOrEncCert = CHOICE(name=u'CertOrEncCert', mode=MODE_TYPE)
    _CertOrEncCert_certificate = CHOICE(name=u'certificate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'CMPCertificate')))
    _CertOrEncCert_encryptedCert = SEQ(name=u'encryptedCert', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCRMF-2009', 'EncryptedValue')))
    CertOrEncCert._cont = ASN1Dict([
        (u'certificate', _CertOrEncCert_certificate),
        (u'encryptedCert', _CertOrEncCert_encryptedCert),
        ])
    CertOrEncCert._ext = None
    
    #-----< KeyRecRepContent >-----#
    KeyRecRepContent = SEQ(name=u'KeyRecRepContent', mode=MODE_TYPE)
    _KeyRecRepContent_status = SEQ(name=u'status', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIStatusInfo')))
    _KeyRecRepContent_newSigCert = CHOICE(name=u'newSigCert', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('PKIXCMP-2009', 'CMPCertificate')), opt=True)
    _KeyRecRepContent_caCerts = SEQ_OF(name=u'caCerts', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __KeyRecRepContent_caCerts__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CMPCertificate')))
    _KeyRecRepContent_caCerts._cont = __KeyRecRepContent_caCerts__item_
    _KeyRecRepContent_caCerts._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _KeyRecRepContent_keyPairHist = SEQ_OF(name=u'keyPairHist', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __KeyRecRepContent_keyPairHist__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CertifiedKeyPair')))
    _KeyRecRepContent_keyPairHist._cont = __KeyRecRepContent_keyPairHist__item_
    _KeyRecRepContent_keyPairHist._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    KeyRecRepContent._cont = ASN1Dict([
        (u'status', _KeyRecRepContent_status),
        (u'newSigCert', _KeyRecRepContent_newSigCert),
        (u'caCerts', _KeyRecRepContent_caCerts),
        (u'keyPairHist', _KeyRecRepContent_keyPairHist),
        ])
    KeyRecRepContent._ext = None
    
    #-----< RevReqContent >-----#
    RevReqContent = SEQ_OF(name=u'RevReqContent', mode=MODE_TYPE)
    _RevReqContent__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'RevDetails')))
    RevReqContent._cont = _RevReqContent__item_
    
    #-----< RevDetails >-----#
    RevDetails = SEQ(name=u'RevDetails', mode=MODE_TYPE)
    _RevDetails_certDetails = SEQ(name=u'certDetails', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'CertTemplate')))
    _RevDetails_crlEntryDetails = SEQ_OF(name=u'crlEntryDetails', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True)
    __RevDetails_crlEntryDetails__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___RevDetails_crlEntryDetails__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____RevDetails_crlEntryDetails__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    ____RevDetails_crlEntryDetails__item__extnID_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    ___RevDetails_crlEntryDetails__item__extnID._const_tab = ____RevDetails_crlEntryDetails__item__extnID_tab
    ___RevDetails_crlEntryDetails__item__extnID._const_tab_at = None
    ___RevDetails_crlEntryDetails__item__extnID._const_tab_id = u'id'
    ___RevDetails_crlEntryDetails__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___RevDetails_crlEntryDetails__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____RevDetails_crlEntryDetails__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    _____RevDetails_crlEntryDetails__item__extnValue_contain_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____RevDetails_crlEntryDetails__item__extnValue_contain_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    ____RevDetails_crlEntryDetails__item__extnValue_contain._const_tab = _____RevDetails_crlEntryDetails__item__extnValue_contain_tab
    ____RevDetails_crlEntryDetails__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____RevDetails_crlEntryDetails__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___RevDetails_crlEntryDetails__item__extnValue._const_cont = ____RevDetails_crlEntryDetails__item__extnValue_contain
    __RevDetails_crlEntryDetails__item_._cont = ASN1Dict([
        (u'extnID', ___RevDetails_crlEntryDetails__item__extnID),
        (u'critical', ___RevDetails_crlEntryDetails__item__critical),
        (u'extnValue', ___RevDetails_crlEntryDetails__item__extnValue),
        ])
    __RevDetails_crlEntryDetails__item_._ext = None
    _RevDetails_crlEntryDetails._cont = __RevDetails_crlEntryDetails__item_
    _RevDetails_crlEntryDetails._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    RevDetails._cont = ASN1Dict([
        (u'certDetails', _RevDetails_certDetails),
        (u'crlEntryDetails', _RevDetails_crlEntryDetails),
        ])
    RevDetails._ext = None
    
    #-----< RevRepContent >-----#
    RevRepContent = SEQ(name=u'RevRepContent', mode=MODE_TYPE)
    _RevRepContent_status = SEQ_OF(name=u'status', mode=MODE_TYPE)
    __RevRepContent_status__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIStatusInfo')))
    _RevRepContent_status._cont = __RevRepContent_status__item_
    _RevRepContent_status._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _RevRepContent_revCerts = SEQ_OF(name=u'revCerts', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __RevRepContent_revCerts__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'CertId')))
    _RevRepContent_revCerts._cont = __RevRepContent_revCerts__item_
    _RevRepContent_revCerts._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _RevRepContent_crls = SEQ_OF(name=u'crls', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __RevRepContent_crls__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateList')))
    _RevRepContent_crls._cont = __RevRepContent_crls__item_
    _RevRepContent_crls._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    RevRepContent._cont = ASN1Dict([
        (u'status', _RevRepContent_status),
        (u'revCerts', _RevRepContent_revCerts),
        (u'crls', _RevRepContent_crls),
        ])
    RevRepContent._ext = None
    
    #-----< CAKeyUpdAnnContent >-----#
    CAKeyUpdAnnContent = SEQ(name=u'CAKeyUpdAnnContent', mode=MODE_TYPE)
    _CAKeyUpdAnnContent_oldWithNew = CHOICE(name=u'oldWithNew', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CMPCertificate')))
    _CAKeyUpdAnnContent_newWithOld = CHOICE(name=u'newWithOld', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CMPCertificate')))
    _CAKeyUpdAnnContent_newWithNew = CHOICE(name=u'newWithNew', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CMPCertificate')))
    CAKeyUpdAnnContent._cont = ASN1Dict([
        (u'oldWithNew', _CAKeyUpdAnnContent_oldWithNew),
        (u'newWithOld', _CAKeyUpdAnnContent_newWithOld),
        (u'newWithNew', _CAKeyUpdAnnContent_newWithNew),
        ])
    CAKeyUpdAnnContent._ext = None
    
    #-----< CertAnnContent >-----#
    CertAnnContent = CHOICE(name=u'CertAnnContent', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CMPCertificate')))
    
    #-----< RevAnnContent >-----#
    RevAnnContent = SEQ(name=u'RevAnnContent', mode=MODE_TYPE)
    _RevAnnContent_status = INT(name=u'status', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIStatus')))
    _RevAnnContent_certId = SEQ(name=u'certId', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'CertId')))
    _RevAnnContent_willBeRevokedAt = TIME_GEN(name=u'willBeRevokedAt', mode=MODE_TYPE)
    _RevAnnContent_badSinceDate = TIME_GEN(name=u'badSinceDate', mode=MODE_TYPE)
    _RevAnnContent_crlDetails = SEQ_OF(name=u'crlDetails', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extensions')), opt=True)
    __RevAnnContent_crlDetails__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'Extension')))
    ___RevAnnContent_crlDetails__item__extnID = OID(name=u'extnID', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'id']))
    ____RevAnnContent_crlDetails__item__extnID_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    ____RevAnnContent_crlDetails__item__extnID_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    ___RevAnnContent_crlDetails__item__extnID._const_tab = ____RevAnnContent_crlDetails__item__extnID_tab
    ___RevAnnContent_crlDetails__item__extnID._const_tab_at = None
    ___RevAnnContent_crlDetails__item__extnID._const_tab_id = u'id'
    ___RevAnnContent_crlDetails__item__critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    ___RevAnnContent_crlDetails__item__extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    ____RevAnnContent_crlDetails__item__extnValue_contain = OPEN(name='_cont_extnValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'EXTENSION'), [u'ExtnType']))
    _____RevAnnContent_crlDetails__item__extnValue_contain_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'EXTENSION')))
    _____RevAnnContent_crlDetails__item__extnValue_contain_tab._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    ____RevAnnContent_crlDetails__item__extnValue_contain._const_tab = _____RevAnnContent_crlDetails__item__extnValue_contain_tab
    ____RevAnnContent_crlDetails__item__extnValue_contain._const_tab_at = ('..', u'extnID')
    ____RevAnnContent_crlDetails__item__extnValue_contain._const_tab_id = u'ExtnType'
    ___RevAnnContent_crlDetails__item__extnValue._const_cont = ____RevAnnContent_crlDetails__item__extnValue_contain
    __RevAnnContent_crlDetails__item_._cont = ASN1Dict([
        (u'extnID', ___RevAnnContent_crlDetails__item__extnID),
        (u'critical', ___RevAnnContent_crlDetails__item__critical),
        (u'extnValue', ___RevAnnContent_crlDetails__item__extnValue),
        ])
    __RevAnnContent_crlDetails__item_._ext = None
    _RevAnnContent_crlDetails._cont = __RevAnnContent_crlDetails__item_
    _RevAnnContent_crlDetails._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    RevAnnContent._cont = ASN1Dict([
        (u'status', _RevAnnContent_status),
        (u'certId', _RevAnnContent_certId),
        (u'willBeRevokedAt', _RevAnnContent_willBeRevokedAt),
        (u'badSinceDate', _RevAnnContent_badSinceDate),
        (u'crlDetails', _RevAnnContent_crlDetails),
        ])
    RevAnnContent._ext = None
    
    #-----< CRLAnnContent >-----#
    CRLAnnContent = SEQ_OF(name=u'CRLAnnContent', mode=MODE_TYPE)
    _CRLAnnContent__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Explicit-2009', 'CertificateList')))
    CRLAnnContent._cont = _CRLAnnContent__item_
    
    #-----< PKIConfirmContent >-----#
    PKIConfirmContent = NULL(name=u'PKIConfirmContent', mode=MODE_TYPE)
    
    #-----< NestedMessageContent >-----#
    NestedMessageContent = SEQ_OF(name=u'NestedMessageContent', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIMessages')))
    
    #-----< INFO-TYPE-AND-VALUE >-----#
    INFO_TYPE_AND_VALUE = CLASS(name=u'INFO-TYPE-AND-VALUE', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< InfoTypeAndValue >-----#
    InfoTypeAndValue = SEQ(name=u'InfoTypeAndValue', mode=MODE_TYPE)
    _InfoTypeAndValue_infoType = OID(name=u'infoType', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIXCMP-2009', 'INFO-TYPE-AND-VALUE'), [u'id']))
    __InfoTypeAndValue_infoType_tab = CLASS(name='_tab_INFO-TYPE-AND-VALUE', mode=MODE_SET, typeref=ASN1RefType(('PKIXCMP-2009', 'INFO-TYPE-AND-VALUE')))
    __InfoTypeAndValue_infoType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _InfoTypeAndValue_infoType._const_tab = __InfoTypeAndValue_infoType_tab
    _InfoTypeAndValue_infoType._const_tab_at = None
    _InfoTypeAndValue_infoType._const_tab_id = u'id'
    _InfoTypeAndValue_infoValue = OPEN(name=u'infoValue', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIXCMP-2009', 'INFO-TYPE-AND-VALUE'), [u'Type']))
    __InfoTypeAndValue_infoValue_tab = CLASS(name='_tab_INFO-TYPE-AND-VALUE', mode=MODE_SET, typeref=ASN1RefType(('PKIXCMP-2009', 'INFO-TYPE-AND-VALUE')))
    __InfoTypeAndValue_infoValue_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _InfoTypeAndValue_infoValue._const_tab = __InfoTypeAndValue_infoValue_tab
    _InfoTypeAndValue_infoValue._const_tab_at = ('..', u'infoType')
    _InfoTypeAndValue_infoValue._const_tab_id = u'Type'
    InfoTypeAndValue._cont = ASN1Dict([
        (u'infoType', _InfoTypeAndValue_infoType),
        (u'infoValue', _InfoTypeAndValue_infoValue),
        ])
    InfoTypeAndValue._ext = None
    
    #-----< SupportedInfoSet >-----#
    SupportedInfoSet = CLASS(name=u'SupportedInfoSet', mode=MODE_SET, typeref=ASN1RefType(('PKIXCMP-2009', 'INFO-TYPE-AND-VALUE')))
    SupportedInfoSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< GenMsgContent >-----#
    GenMsgContent = SEQ_OF(name=u'GenMsgContent', mode=MODE_TYPE)
    _GenMsgContent__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'InfoTypeAndValue')))
    GenMsgContent._cont = _GenMsgContent__item_
    
    #-----< GenRepContent >-----#
    GenRepContent = SEQ_OF(name=u'GenRepContent', mode=MODE_TYPE)
    _GenRepContent__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'InfoTypeAndValue')))
    GenRepContent._cont = _GenRepContent__item_
    
    #-----< ErrorMsgContent >-----#
    ErrorMsgContent = SEQ(name=u'ErrorMsgContent', mode=MODE_TYPE)
    _ErrorMsgContent_pKIStatusInfo = SEQ(name=u'pKIStatusInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIStatusInfo')))
    _ErrorMsgContent_errorCode = INT(name=u'errorCode', mode=MODE_TYPE, opt=True)
    _ErrorMsgContent_errorDetails = SEQ_OF(name=u'errorDetails', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIFreeText')), opt=True)
    ErrorMsgContent._cont = ASN1Dict([
        (u'pKIStatusInfo', _ErrorMsgContent_pKIStatusInfo),
        (u'errorCode', _ErrorMsgContent_errorCode),
        (u'errorDetails', _ErrorMsgContent_errorDetails),
        ])
    ErrorMsgContent._ext = None
    
    #-----< CertConfirmContent >-----#
    CertConfirmContent = SEQ_OF(name=u'CertConfirmContent', mode=MODE_TYPE)
    _CertConfirmContent__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'CertStatus')))
    CertConfirmContent._cont = _CertConfirmContent__item_
    
    #-----< CertStatus >-----#
    CertStatus = SEQ(name=u'CertStatus', mode=MODE_TYPE)
    _CertStatus_certHash = OCT_STR(name=u'certHash', mode=MODE_TYPE)
    _CertStatus_certReqId = INT(name=u'certReqId', mode=MODE_TYPE)
    _CertStatus_statusInfo = SEQ(name=u'statusInfo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIStatusInfo')), opt=True)
    CertStatus._cont = ASN1Dict([
        (u'certHash', _CertStatus_certHash),
        (u'certReqId', _CertStatus_certReqId),
        (u'statusInfo', _CertStatus_statusInfo),
        ])
    CertStatus._ext = None
    
    #-----< PollReqContent >-----#
    PollReqContent = SEQ_OF(name=u'PollReqContent', mode=MODE_TYPE)
    _PollReqContent__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __PollReqContent__item__certReqId = INT(name=u'certReqId', mode=MODE_TYPE)
    _PollReqContent__item_._cont = ASN1Dict([
        (u'certReqId', __PollReqContent__item__certReqId),
        ])
    _PollReqContent__item_._ext = None
    PollReqContent._cont = _PollReqContent__item_
    
    #-----< PollRepContent >-----#
    PollRepContent = SEQ_OF(name=u'PollRepContent', mode=MODE_TYPE)
    _PollRepContent__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __PollRepContent__item__certReqId = INT(name=u'certReqId', mode=MODE_TYPE)
    __PollRepContent__item__checkAfter = INT(name=u'checkAfter', mode=MODE_TYPE)
    __PollRepContent__item__reason = SEQ_OF(name=u'reason', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCMP-2009', 'PKIFreeText')), opt=True)
    _PollRepContent__item_._cont = ASN1Dict([
        (u'certReqId', __PollRepContent__item__certReqId),
        (u'checkAfter', __PollRepContent__item__checkAfter),
        (u'reason', __PollRepContent__item__reason),
        ])
    _PollRepContent__item_._ext = None
    PollRepContent._cont = _PollRepContent__item_
    
    _all_ = [
        _CMPCertificate_x509v3PKCert,
        CMPCertificate,
        _PKIMessage_header,
        _PKIMessage_body,
        _PKIMessage_protection,
        __PKIMessage_extraCerts__item_,
        _PKIMessage_extraCerts,
        PKIMessage,
        _PKIMessages__item_,
        PKIMessages,
        _PKIHeader_pvno,
        _PKIHeader_sender,
        _PKIHeader_recipient,
        _PKIHeader_messageTime,
        ___PKIHeader_protectionAlg_algorithm_tab,
        __PKIHeader_protectionAlg_algorithm,
        ___PKIHeader_protectionAlg_parameters_tab,
        __PKIHeader_protectionAlg_parameters,
        _PKIHeader_protectionAlg,
        _PKIHeader_senderKID,
        _PKIHeader_recipKID,
        _PKIHeader_transactionID,
        _PKIHeader_senderNonce,
        _PKIHeader_recipNonce,
        _PKIHeader_freeText,
        __PKIHeader_generalInfo__item_,
        _PKIHeader_generalInfo,
        PKIHeader,
        _PKIFreeText__item_,
        PKIFreeText,
        _PKIBody_ir,
        _PKIBody_ip,
        _PKIBody_cr,
        _PKIBody_cp,
        _PKIBody_p10cr,
        _PKIBody_popdecc,
        _PKIBody_popdecr,
        _PKIBody_kur,
        _PKIBody_kup,
        _PKIBody_krr,
        _PKIBody_krp,
        _PKIBody_rr,
        _PKIBody_rp,
        _PKIBody_ccr,
        _PKIBody_ccp,
        _PKIBody_ckuann,
        _PKIBody_cann,
        _PKIBody_rann,
        _PKIBody_crlann,
        _PKIBody_pkiconf,
        _PKIBody_nested,
        _PKIBody_genm,
        _PKIBody_genp,
        _PKIBody_error,
        _PKIBody_certConf,
        _PKIBody_pollReq,
        _PKIBody_pollRep,
        PKIBody,
        PKIProtection,
        _ProtectedPart_header,
        _ProtectedPart_body,
        ProtectedPart,
        id_PasswordBasedMac,
        _PBMParameter_salt,
        ___PBMParameter_owf_algorithm_tab,
        __PBMParameter_owf_algorithm,
        ___PBMParameter_owf_parameters_tab,
        __PBMParameter_owf_parameters,
        _PBMParameter_owf,
        _PBMParameter_iterationCount,
        ___PBMParameter_mac_algorithm_tab,
        __PBMParameter_mac_algorithm,
        ___PBMParameter_mac_parameters_tab,
        __PBMParameter_mac_parameters,
        _PBMParameter_mac,
        PBMParameter,
        id_DHBasedMac,
        ___DHBMParameter_owf_algorithm_tab,
        __DHBMParameter_owf_algorithm,
        ___DHBMParameter_owf_parameters_tab,
        __DHBMParameter_owf_parameters,
        _DHBMParameter_owf,
        ___DHBMParameter_mac_algorithm_tab,
        __DHBMParameter_mac_algorithm,
        ___DHBMParameter_mac_parameters_tab,
        __DHBMParameter_mac_parameters,
        _DHBMParameter_mac,
        DHBMParameter,
        PKIStatus,
        PKIFailureInfo,
        _PKIStatusInfo_status,
        _PKIStatusInfo_statusString,
        _PKIStatusInfo_failInfo,
        PKIStatusInfo,
        OOBCert,
        ___OOBCertHash_hashAlg_algorithm_tab,
        __OOBCertHash_hashAlg_algorithm,
        ___OOBCertHash_hashAlg_parameters_tab,
        __OOBCertHash_hashAlg_parameters,
        _OOBCertHash_hashAlg,
        _OOBCertHash_certId,
        _OOBCertHash_hashVal,
        OOBCertHash,
        _POPODecKeyChallContent__item_,
        POPODecKeyChallContent,
        ___Challenge_owf_algorithm_tab,
        __Challenge_owf_algorithm,
        ___Challenge_owf_parameters_tab,
        __Challenge_owf_parameters,
        _Challenge_owf,
        _Challenge_witness,
        _Challenge_challenge,
        Challenge,
        _POPODecKeyRespContent__item_,
        POPODecKeyRespContent,
        __CertRepMessage_caPubs__item_,
        _CertRepMessage_caPubs,
        __CertRepMessage_response__item_,
        _CertRepMessage_response,
        CertRepMessage,
        _CertResponse_certReqId,
        _CertResponse_status,
        _CertResponse_certifiedKeyPair,
        _CertResponse_rspInfo,
        CertResponse,
        _CertifiedKeyPair_certOrEncCert,
        _CertifiedKeyPair_privateKey,
        _CertifiedKeyPair_publicationInfo,
        CertifiedKeyPair,
        _CertOrEncCert_certificate,
        _CertOrEncCert_encryptedCert,
        CertOrEncCert,
        _KeyRecRepContent_status,
        _KeyRecRepContent_newSigCert,
        __KeyRecRepContent_caCerts__item_,
        _KeyRecRepContent_caCerts,
        __KeyRecRepContent_keyPairHist__item_,
        _KeyRecRepContent_keyPairHist,
        KeyRecRepContent,
        _RevReqContent__item_,
        RevReqContent,
        _RevDetails_certDetails,
        ____RevDetails_crlEntryDetails__item__extnID_tab,
        ___RevDetails_crlEntryDetails__item__extnID,
        ___RevDetails_crlEntryDetails__item__critical,
        _____RevDetails_crlEntryDetails__item__extnValue_contain_tab,
        ____RevDetails_crlEntryDetails__item__extnValue_contain,
        ___RevDetails_crlEntryDetails__item__extnValue,
        __RevDetails_crlEntryDetails__item_,
        _RevDetails_crlEntryDetails,
        RevDetails,
        __RevRepContent_status__item_,
        _RevRepContent_status,
        __RevRepContent_revCerts__item_,
        _RevRepContent_revCerts,
        __RevRepContent_crls__item_,
        _RevRepContent_crls,
        RevRepContent,
        _CAKeyUpdAnnContent_oldWithNew,
        _CAKeyUpdAnnContent_newWithOld,
        _CAKeyUpdAnnContent_newWithNew,
        CAKeyUpdAnnContent,
        CertAnnContent,
        _RevAnnContent_status,
        _RevAnnContent_certId,
        _RevAnnContent_willBeRevokedAt,
        _RevAnnContent_badSinceDate,
        ____RevAnnContent_crlDetails__item__extnID_tab,
        ___RevAnnContent_crlDetails__item__extnID,
        ___RevAnnContent_crlDetails__item__critical,
        _____RevAnnContent_crlDetails__item__extnValue_contain_tab,
        ____RevAnnContent_crlDetails__item__extnValue_contain,
        ___RevAnnContent_crlDetails__item__extnValue,
        __RevAnnContent_crlDetails__item_,
        _RevAnnContent_crlDetails,
        RevAnnContent,
        _CRLAnnContent__item_,
        CRLAnnContent,
        PKIConfirmContent,
        NestedMessageContent,
        INFO_TYPE_AND_VALUE,
        __InfoTypeAndValue_infoType_tab,
        _InfoTypeAndValue_infoType,
        __InfoTypeAndValue_infoValue_tab,
        _InfoTypeAndValue_infoValue,
        InfoTypeAndValue,
        SupportedInfoSet,
        _GenMsgContent__item_,
        GenMsgContent,
        _GenRepContent__item_,
        GenRepContent,
        _ErrorMsgContent_pKIStatusInfo,
        _ErrorMsgContent_errorCode,
        _ErrorMsgContent_errorDetails,
        ErrorMsgContent,
        _CertConfirmContent__item_,
        CertConfirmContent,
        _CertStatus_certHash,
        _CertStatus_certReqId,
        _CertStatus_statusInfo,
        CertStatus,
        __PollReqContent__item__certReqId,
        _PollReqContent__item_,
        PollReqContent,
        __PollRepContent__item__certReqId,
        __PollRepContent__item__checkAfter,
        __PollRepContent__item__reason,
        _PollRepContent__item_,
        PollRepContent,
    ]

class PKIX_CommonTypes_2009:

    _name_  = u'PKIX-CommonTypes-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 57]
    
    _obj_ = [
        u'ATTRIBUTE',
        u'MATCHING-RULE',
        u'AttributeSet',
        u'SingleAttribute',
        u'EXTENSION',
        u'Extensions',
        u'Extension',
        u'SECURITY-CATEGORY',
        u'SecurityCategory',
        ]
    _type_ = [
        u'ATTRIBUTE',
        u'MATCHING-RULE',
        u'AttributeSet',
        u'SingleAttribute',
        u'EXTENSION',
        u'Extensions',
        u'Extension',
        u'SECURITY-CATEGORY',
        u'SecurityCategory',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        u'ATTRIBUTE',
        u'MATCHING-RULE',
        u'EXTENSION',
        u'SECURITY-CATEGORY',
        ]
    _param_ = [
        u'AttributeSet',
        u'SingleAttribute',
        u'Extensions',
        u'Extension',
        u'SecurityCategory',
        ]
    
    #-----< ATTRIBUTE >-----#
    ATTRIBUTE = CLASS(name=u'ATTRIBUTE', mode=MODE_TYPE)
    _ATTRIBUTE_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _ATTRIBUTE_Type = OPEN(name=u'Type', mode=MODE_TYPE, opt=True)
    _ATTRIBUTE_equality_match = CLASS(name=u'equality-match', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'MATCHING-RULE')), opt=True)
    _ATTRIBUTE_minCount = INT(name=u'minCount', mode=MODE_VALUE, default=1)
    _ATTRIBUTE_maxCount = INT(name=u'maxCount', mode=MODE_VALUE, opt=True)
    ATTRIBUTE._cont = ASN1Dict([
        (u'id', _ATTRIBUTE_id),
        (u'Type', _ATTRIBUTE_Type),
        (u'equality-match', _ATTRIBUTE_equality_match),
        (u'minCount', _ATTRIBUTE_minCount),
        (u'maxCount', _ATTRIBUTE_maxCount),
        ])
    
    #-----< MATCHING-RULE >-----#
    MATCHING_RULE = CLASS(name=u'MATCHING-RULE', mode=MODE_TYPE)
    _MATCHING_RULE_ParentMatchingRules = CLASS(name=u'ParentMatchingRules', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'MATCHING-RULE')), opt=True)
    _MATCHING_RULE_AssertionType = OPEN(name=u'AssertionType', mode=MODE_TYPE, opt=True)
    _MATCHING_RULE_uniqueMatchIndicator = CLASS(name=u'uniqueMatchIndicator', mode=MODE_VALUE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')), opt=True)
    _MATCHING_RULE_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    MATCHING_RULE._cont = ASN1Dict([
        (u'ParentMatchingRules', _MATCHING_RULE_ParentMatchingRules),
        (u'AssertionType', _MATCHING_RULE_AssertionType),
        (u'uniqueMatchIndicator', _MATCHING_RULE_uniqueMatchIndicator),
        (u'id', _MATCHING_RULE_id),
        ])
    
    #-----< AttributeSet >-----#
    AttributeSet = SEQ(name=u'AttributeSet', mode=MODE_TYPE, param=True)
    
    #-----< SingleAttribute >-----#
    SingleAttribute = SEQ(name=u'SingleAttribute', mode=MODE_TYPE, param=True)
    
    #-----< EXTENSION >-----#
    EXTENSION = CLASS(name=u'EXTENSION', mode=MODE_TYPE)
    _EXTENSION_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _EXTENSION_ExtnType = OPEN(name=u'ExtnType', mode=MODE_TYPE)
    _EXTENSION_Critical = BOOL(name=u'Critical', mode=MODE_SET, default=ASN1Set(rv=[True, False], rr=[], ev=None, er=[]))
    EXTENSION._cont = ASN1Dict([
        (u'id', _EXTENSION_id),
        (u'ExtnType', _EXTENSION_ExtnType),
        (u'Critical', _EXTENSION_Critical),
        ])
    
    #-----< Extensions >-----#
    Extensions = SEQ_OF(name=u'Extensions', mode=MODE_TYPE, param=True)
    
    #-----< Extension >-----#
    Extension = SEQ(name=u'Extension', mode=MODE_TYPE, param=True)
    
    #-----< SECURITY-CATEGORY >-----#
    SECURITY_CATEGORY = CLASS(name=u'SECURITY-CATEGORY', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< SecurityCategory >-----#
    SecurityCategory = SEQ(name=u'SecurityCategory', mode=MODE_TYPE, param=True)
    
    _all_ = [
        _ATTRIBUTE_id,
        _ATTRIBUTE_Type,
        _ATTRIBUTE_equality_match,
        _ATTRIBUTE_minCount,
        _ATTRIBUTE_maxCount,
        ATTRIBUTE,
        _MATCHING_RULE_ParentMatchingRules,
        _MATCHING_RULE_AssertionType,
        _MATCHING_RULE_uniqueMatchIndicator,
        _MATCHING_RULE_id,
        MATCHING_RULE,
        _EXTENSION_id,
        _EXTENSION_ExtnType,
        _EXTENSION_Critical,
        EXTENSION,
        SECURITY_CATEGORY,
    ]

class PKIXCRMF_2009:

    _name_  = u'PKIXCRMF-2009'
    _oid_   = [1, 3, 6, 1, 5, 5, 7, 0, 55]
    
    _obj_ = [
        u'id-pkip',
        u'id-smime',
        u'id-ct',
        u'CertReqMessages',
        u'CertReqMsg',
        u'CertRequest',
        u'CertTemplate',
        u'OptionalValidity',
        u'Controls',
        u'ProofOfPossession',
        u'POPOSigningKey',
        u'POPOSigningKeyInput',
        u'PKMACValue',
        u'id-PasswordBasedMac',
        u'Password-MACAlgorithms',
        u'PBMParameter',
        u'DigestAlgorithms',
        u'MACAlgorithms',
        u'POPOPrivKey',
        u'SubsequentMessage',
        u'ct-encKeyWithID',
        u'id-ct-encKeyWithID',
        u'EncKeyWithID',
        u'PrivateKeyInfo',
        u'Attributes',
        u'PrivateKeyAttributes',
        u'id-regCtrl',
        u'RegControlSet',
        u'regCtrl-regToken',
        u'id-regCtrl-regToken',
        u'RegToken',
        u'regCtrl-authenticator',
        u'id-regCtrl-authenticator',
        u'Authenticator',
        u'regCtrl-pkiPublicationInfo',
        u'id-regCtrl-pkiPublicationInfo',
        u'PKIPublicationInfo',
        u'SinglePubInfo',
        u'regCtrl-pkiArchiveOptions',
        u'id-regCtrl-pkiArchiveOptions',
        u'PKIArchiveOptions',
        u'EncryptedKey',
        u'EncryptedValue',
        u'KeyGenParameters',
        u'regCtrl-oldCertID',
        u'id-regCtrl-oldCertID',
        u'OldCertId',
        u'CertId',
        u'regCtrl-protocolEncrKey',
        u'id-regCtrl-protocolEncrKey',
        u'ProtocolEncrKey',
        u'id-regInfo',
        u'RegInfoSet',
        u'regInfo-utf8Pairs',
        u'id-regInfo-utf8Pairs',
        u'UTF8Pairs',
        u'regInfo-certReq',
        u'id-regInfo-certReq',
        u'CertReq',
        ]
    _type_ = [
        u'CertReqMessages',
        u'CertReqMsg',
        u'CertRequest',
        u'CertTemplate',
        u'OptionalValidity',
        u'Controls',
        u'ProofOfPossession',
        u'POPOSigningKey',
        u'POPOSigningKeyInput',
        u'PKMACValue',
        u'PBMParameter',
        u'POPOPrivKey',
        u'SubsequentMessage',
        u'EncKeyWithID',
        u'PrivateKeyInfo',
        u'Attributes',
        u'RegToken',
        u'Authenticator',
        u'PKIPublicationInfo',
        u'SinglePubInfo',
        u'PKIArchiveOptions',
        u'EncryptedKey',
        u'EncryptedValue',
        u'KeyGenParameters',
        u'OldCertId',
        u'CertId',
        u'ProtocolEncrKey',
        u'UTF8Pairs',
        u'CertReq',
        ]
    _set_ = [
        u'Password-MACAlgorithms',
        u'DigestAlgorithms',
        u'MACAlgorithms',
        u'PrivateKeyAttributes',
        u'RegControlSet',
        u'RegInfoSet',
        ]
    _val_ = [
        u'id-pkip',
        u'id-smime',
        u'id-ct',
        u'id-PasswordBasedMac',
        u'ct-encKeyWithID',
        u'id-ct-encKeyWithID',
        u'id-regCtrl',
        u'regCtrl-regToken',
        u'id-regCtrl-regToken',
        u'regCtrl-authenticator',
        u'id-regCtrl-authenticator',
        u'regCtrl-pkiPublicationInfo',
        u'id-regCtrl-pkiPublicationInfo',
        u'regCtrl-pkiArchiveOptions',
        u'id-regCtrl-pkiArchiveOptions',
        u'regCtrl-oldCertID',
        u'id-regCtrl-oldCertID',
        u'regCtrl-protocolEncrKey',
        u'id-regCtrl-protocolEncrKey',
        u'id-regInfo',
        u'regInfo-utf8Pairs',
        u'id-regInfo-utf8Pairs',
        u'regInfo-certReq',
        u'id-regInfo-certReq',
        ]
    _class_ = [
        u'Password-MACAlgorithms',
        u'DigestAlgorithms',
        u'MACAlgorithms',
        u'ct-encKeyWithID',
        u'PrivateKeyAttributes',
        u'RegControlSet',
        u'regCtrl-regToken',
        u'regCtrl-authenticator',
        u'regCtrl-pkiPublicationInfo',
        u'regCtrl-pkiArchiveOptions',
        u'regCtrl-oldCertID',
        u'regCtrl-protocolEncrKey',
        u'RegInfoSet',
        u'regInfo-utf8Pairs',
        u'regInfo-certReq',
        ]
    _param_ = [
        ]
    
    #-----< id-pkip >-----#
    id_pkip = OID(name=u'id-pkip', mode=MODE_VALUE)
    id_pkip._val = (1, 3, 6, 1, 5, 5, 7, 5)
    
    #-----< id-smime >-----#
    id_smime = OID(name=u'id-smime', mode=MODE_VALUE)
    id_smime._val = (1, 2, 840, 113549, 1, 9, 16)
    
    #-----< id-ct >-----#
    id_ct = OID(name=u'id-ct', mode=MODE_VALUE)
    id_ct._val = (1, 2, 840, 113549, 1, 9, 16, 1)
    
    #-----< CertReqMessages >-----#
    CertReqMessages = SEQ_OF(name=u'CertReqMessages', mode=MODE_TYPE)
    _CertReqMessages__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'CertReqMsg')))
    CertReqMessages._cont = _CertReqMessages__item_
    CertReqMessages._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< CertReqMsg >-----#
    CertReqMsg = SEQ(name=u'CertReqMsg', mode=MODE_TYPE)
    _CertReqMsg_certReq = SEQ(name=u'certReq', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'CertRequest')))
    _CertReqMsg_popo = CHOICE(name=u'popo', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'ProofOfPossession')), opt=True)
    _CertReqMsg_regInfo = SEQ_OF(name=u'regInfo', mode=MODE_TYPE, opt=True)
    __CertReqMsg_regInfo__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'SingleAttribute')))
    ___CertReqMsg_regInfo__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'id']))
    ____CertReqMsg_regInfo__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('PKIX-CommonTypes-2009', 'ATTRIBUTE')))
    _____CertReqMsg_regInfo__item__type_tab_val_Type_0 = STR_UTF8(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'UTF8Pairs')))
    _____CertReqMsg_regInfo__item__type_tab_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'CertReq')))
    ____CertReqMsg_regInfo__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____CertReqMsg_regInfo__item__type_tab_val_Type_0), (u'id', (1, 3, 6, 1, 5, 5, 7, 5, 2, 1))]), dict([(u'Type', _____CertReqMsg_regInfo__item__type_tab_val_Type_1), (u'id', (1, 3, 6, 1, 5, 5, 7, 5, 2, 2))])], rr=[], ev=None, er=[])
    ___CertReqMsg_regInfo__item__type._const_tab = ____CertReqMsg_regInfo__item__type_tab
    ___CertReqMsg_regInfo__item__type._const_tab_at = None
    ___CertReqMsg_regInfo__item__type._const_tab_id = u'id'
    ___CertReqMsg_regInfo__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('PKIX-CommonTypes-2009', 'ATTRIBUTE'), [u'Type']))
    ___CertReqMsg_regInfo__item__value._const_tab = ____CertReqMsg_regInfo__item__type_tab
    ___CertReqMsg_regInfo__item__value._const_tab_at = ('..', u'type')
    ___CertReqMsg_regInfo__item__value._const_tab_id = u'Type'
    __CertReqMsg_regInfo__item_._cont = ASN1Dict([
        (u'type', ___CertReqMsg_regInfo__item__type),
        (u'value', ___CertReqMsg_regInfo__item__value),
        ])
    __CertReqMsg_regInfo__item_._ext = None
    _CertReqMsg_regInfo._cont = __CertReqMsg_regInfo__item_
    _CertReqMsg_regInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    CertReqMsg._cont = ASN1Dict([
        (u'certReq', _CertReqMsg_certReq),
        (u'popo', _CertReqMsg_popo),
        (u'regInfo', _CertReqMsg_regInfo),
        ])
    CertReqMsg._ext = None
    
    #-----< CertRequest >-----#
    CertRequest = SEQ(name=u'CertRequest', mode=MODE_TYPE)
    _CertRequest_certReqId = INT(name=u'certReqId', mode=MODE_TYPE)
    _CertRequest_certTemplate = SEQ(name=u'certTemplate', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'CertTemplate')))
    _CertRequest_controls = SEQ_OF(name=u'controls', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXCRMF-2009', 'Controls')), opt=True)
    CertRequest._cont = ASN1Dict([
        (u'certReqId', _CertRequest_certReqId),
        (u'certTemplate', _CertRequest_certTemplate),
        (u'controls', _CertRequest_controls),
        ])
    CertRequest._ext = None
    
    #-----< CertTemplate >-----#
    CertTemplate = SEQ(name=u'CertTemplate', mode=MODE_TYPE)
    _CertTemplate_version = INT(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('PKIX1Explicit-2009', 'Version')), opt=True)
    _CertTemplate_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CertTemplate_signingAlg = SEQ(name=u'signingAlg', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AlgorithmInformation-2009', 'AlgorithmIdentifier')), opt=True)
    __CertTemplate_signingAlg_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM'), [u'id']))
    ___CertTemplate_signingAlg_algorithm_tab = CLASS(name='_tab_SIGNATURE-ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AlgorithmInformation-2009', 'SIGNATURE-ALGORITHM')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertTemplate_signingAlg_algorithm_tab_val_Value_3 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0 = INT(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Params')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Value_4 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1 = OCT_STR(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECPoint')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1 = CHOICE(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECParameters')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Value_5 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_5 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertTemplate_signingAlg_algorithm_tab_val_Value_6 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'DSA-Sig-Value')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_6 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertTemplate_signingAlg_algorithm_tab_val_Value_7 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_7 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertTemplate_signingAlg_algorithm_tab_val_Value_8 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_8 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertTemplate_signingAlg_algorithm_tab_val_Value_9 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_9 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertTemplate_signingAlg_algorithm_tab_val_Value_10 = SEQ(name=u'Value', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'ECDSA-Sig-Value')))
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_10 = NULL(name=u'Params', mode=MODE_TYPE)
    ____CertTemplate_signingAlg_algorithm_tab_val_Params_11 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    __SIGNATURE_ALGORITHM_HashSet_val_Params_1 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_2 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_3 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_HashSet_val_Params_4 = NULL(name=u'Params', mode=MODE_TYPE)
    __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_1 = SEQ(name=u'KeyValue', mode=MODE_TYPE, typeref=ASN1RefType(('PKIXAlgs-2009', 'RSAPublicKey')))
    __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_1 = SEQ(name=u'Params', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1-PSS-OAEP-Algorithms-2009', 'RSASSA-PSS-params')))
    ___CertTemplate_signingAlg_algorithm_tab._val = ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 2)), (u'Params', ____CertTemplate_signingAlg_algorithm_tab_val_Params_0), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 2)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 2))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 4)), (u'Params', ____CertTemplate_signingAlg_algorithm_tab_val_Params_1), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 2, 5)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 4))]))]), dict([(u'id', (1, 2, 840, 113549, 1, 1, 5)), (u'Params', ____CertTemplate_signingAlg_algorithm_tab_val_Params_2), (u'paramPresence', u'required'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 113549, 1, 1, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0), (u'paramPresence', u'absent'), (u'keyUsage', (123, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 113549, 1, 1, 5))]))]), dict([(u'id', (1, 2, 840, 10040, 4, 3)), (u'Value', ____CertTemplate_signingAlg_algorithm_tab_val_Value_3), (u'Params', ____CertTemplate_signingAlg_algorithm_tab_val_Params_3), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10040, 4, 3))]))]), dict([(u'id', (1, 2, 840, 10045, 4, 1)), (u'Value', ____CertTemplate_signingAlg_algorithm_tab_val_Value_4), (u'Params', ____CertTemplate_signingAlg_algorithm_tab_val_Params_4), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (1, 3, 14, 3, 2, 26)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10045, 2, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_1), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_1), (u'paramPresence', u'required'), (u'keyUsage', (103, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (1, 2, 840, 10045, 4, 1))]))])], rr=[], ev=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1)), (u'Value', ____CertTemplate_signingAlg_algorithm_tab_val_Value_5), (u'Params', ____CertTemplate_signingAlg_algorithm_tab_val_Params_5), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 4)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', (1, 2, 840, 10040, 4, 1)), (u'KeyValue', __SIGNATURE_ALGORITHM_PublicKeySet_val_KeyValue_0_0), (u'Params', __SIGNATURE_ALGORITHM_PublicKeySet_val_Params_0_0), (u'paramPresence', u'inheritable'), (u'keyUsage', (99, 7))])], rr=[], ev=None, er=[])), (u'smimeCaps', dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 1))]))]), dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 3, 2)), (u'Value', ____CertTemplate_signingAlg_algorithm_tab_val_Value_6), (u'Params', ____CertTemplate_signingAlg_algorithm_tab_val_Params_6), (u'paramPresence', u'absent'), (u'HashSet', ASN1Set(rv=[dict([(u'id', (2, 16, 840, 1, 101, 3, 4, 2, 1)), (u'Params', __SIGNATURE_ALGORITHM_HashSet_val_Params_0), (u'paramPresence', u'preferredAbsent')])], rr=[], ev=None, er=[])), (u'PublicKeySet', ASN1Set(rv=[dict([(u'id', 