# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class RFC1155_SMI:

    _name_  = u'RFC1155-SMI'
    _oid_   = []
    
    _obj_ = [
        u'internet',
        u'directory',
        u'mgmt',
        u'experimental',
        u'private',
        u'enterprises',
        u'ObjectName',
        u'ObjectSyntax',
        u'SimpleSyntax',
        u'ApplicationSyntax',
        u'NetworkAddress',
        u'IpAddress',
        u'Counter',
        u'Gauge',
        u'TimeTicks',
        u'Opaque',
        ]
    _type_ = [
        u'ObjectName',
        u'ObjectSyntax',
        u'SimpleSyntax',
        u'ApplicationSyntax',
        u'NetworkAddress',
        u'IpAddress',
        u'Counter',
        u'Gauge',
        u'TimeTicks',
        u'Opaque',
        ]
    _set_ = [
        ]
    _val_ = [
        u'internet',
        u'directory',
        u'mgmt',
        u'experimental',
        u'private',
        u'enterprises',
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< internet >-----#
    internet = OID(name=u'internet', mode=MODE_VALUE)
    internet._val = (1, 3, 6, 1)
    
    #-----< directory >-----#
    directory = OID(name=u'directory', mode=MODE_VALUE)
    directory._val = (1, 3, 6, 1, 1)
    
    #-----< mgmt >-----#
    mgmt = OID(name=u'mgmt', mode=MODE_VALUE)
    mgmt._val = (1, 3, 6, 1, 2)
    
    #-----< experimental >-----#
    experimental = OID(name=u'experimental', mode=MODE_VALUE)
    experimental._val = (1, 3, 6, 1, 3)
    
    #-----< private >-----#
    private = OID(name=u'private', mode=MODE_VALUE)
    private._val = (1, 3, 6, 1, 4)
    
    #-----< enterprises >-----#
    enterprises = OID(name=u'enterprises', mode=MODE_VALUE)
    enterprises._val = (1, 3, 6, 1, 4, 1)
    
    #-----< ObjectName >-----#
    ObjectName = OID(name=u'ObjectName', mode=MODE_TYPE)
    
    #-----< ObjectSyntax >-----#
    ObjectSyntax = CHOICE(name=u'ObjectSyntax', mode=MODE_TYPE)
    _ObjectSyntax_simple = CHOICE(name=u'simple', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'SimpleSyntax')))
    _ObjectSyntax_application_wide = CHOICE(name=u'application-wide', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'ApplicationSyntax')))
    ObjectSyntax._cont = ASN1Dict([
        (u'simple', _ObjectSyntax_simple),
        (u'application-wide', _ObjectSyntax_application_wide),
        ])
    ObjectSyntax._ext = None
    
    #-----< SimpleSyntax >-----#
    SimpleSyntax = CHOICE(name=u'SimpleSyntax', mode=MODE_TYPE)
    _SimpleSyntax_number = INT(name=u'number', mode=MODE_TYPE)
    _SimpleSyntax_string = OCT_STR(name=u'string', mode=MODE_TYPE)
    _SimpleSyntax_object = OID(name=u'object', mode=MODE_TYPE)
    _SimpleSyntax_empty = NULL(name=u'empty', mode=MODE_TYPE)
    SimpleSyntax._cont = ASN1Dict([
        (u'number', _SimpleSyntax_number),
        (u'string', _SimpleSyntax_string),
        (u'object', _SimpleSyntax_object),
        (u'empty', _SimpleSyntax_empty),
        ])
    SimpleSyntax._ext = None
    
    #-----< ApplicationSyntax >-----#
    ApplicationSyntax = CHOICE(name=u'ApplicationSyntax', mode=MODE_TYPE)
    _ApplicationSyntax_address = CHOICE(name=u'address', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'NetworkAddress')))
    _ApplicationSyntax_counter = INT(name=u'counter', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'Counter')))
    _ApplicationSyntax_gauge = INT(name=u'gauge', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'Gauge')))
    _ApplicationSyntax_ticks = INT(name=u'ticks', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'TimeTicks')))
    _ApplicationSyntax_arbitrary = OCT_STR(name=u'arbitrary', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'Opaque')))
    ApplicationSyntax._cont = ASN1Dict([
        (u'address', _ApplicationSyntax_address),
        (u'counter', _ApplicationSyntax_counter),
        (u'gauge', _ApplicationSyntax_gauge),
        (u'ticks', _ApplicationSyntax_ticks),
        (u'arbitrary', _ApplicationSyntax_arbitrary),
        ])
    ApplicationSyntax._ext = None
    
    #-----< NetworkAddress >-----#
    NetworkAddress = CHOICE(name=u'NetworkAddress', mode=MODE_TYPE)
    _NetworkAddress_internet = OCT_STR(name=u'internet', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'IpAddress')))
    NetworkAddress._cont = ASN1Dict([
        (u'internet', _NetworkAddress_internet),
        ])
    NetworkAddress._ext = None
    
    #-----< IpAddress >-----#
    IpAddress = OCT_STR(name=u'IpAddress', mode=MODE_TYPE, tag=(0, TAG_APPLICATION, TAG_IMPLICIT))
    IpAddress._const_sz = ASN1Set(rv=[4], rr=[], ev=None, er=[])
    
    #-----< Counter >-----#
    Counter = INT(name=u'Counter', mode=MODE_TYPE, tag=(1, TAG_APPLICATION, TAG_IMPLICIT))
    Counter._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    
    #-----< Gauge >-----#
    Gauge = INT(name=u'Gauge', mode=MODE_TYPE, tag=(2, TAG_APPLICATION, TAG_IMPLICIT))
    Gauge._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    
    #-----< TimeTicks >-----#
    TimeTicks = INT(name=u'TimeTicks', mode=MODE_TYPE, tag=(3, TAG_APPLICATION, TAG_IMPLICIT))
    TimeTicks._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=4294967295)], ev=None, er=[])
    
    #-----< Opaque >-----#
    Opaque = OCT_STR(name=u'Opaque', mode=MODE_TYPE, tag=(4, TAG_APPLICATION, TAG_IMPLICIT))
    
    _all_ = [
        internet,
        directory,
        mgmt,
        experimental,
        private,
        enterprises,
        ObjectName,
        _ObjectSyntax_simple,
        _ObjectSyntax_application_wide,
        ObjectSyntax,
        _SimpleSyntax_number,
        _SimpleSyntax_string,
        _SimpleSyntax_object,
        _SimpleSyntax_empty,
        SimpleSyntax,
        _ApplicationSyntax_address,
        _ApplicationSyntax_counter,
        _ApplicationSyntax_gauge,
        _ApplicationSyntax_ticks,
        _ApplicationSyntax_arbitrary,
        ApplicationSyntax,
        _NetworkAddress_internet,
        NetworkAddress,
        IpAddress,
        Counter,
        Gauge,
        TimeTicks,
        Opaque,
    ]

class RFC1157_SNMP:

    _name_  = u'RFC1157-SNMP'
    _oid_   = []
    
    _obj_ = [
        u'Message',
        u'PDUs',
        u'GetRequest-PDU',
        u'GetNextRequest-PDU',
        u'GetResponse-PDU',
        u'SetRequest-PDU',
        u'PDU',
        u'Trap-PDU',
        u'VarBind',
        u'VarBindList',
        ]
    _type_ = [
        u'Message',
        u'PDUs',
        u'GetRequest-PDU',
        u'GetNextRequest-PDU',
        u'GetResponse-PDU',
        u'SetRequest-PDU',
        u'PDU',
        u'Trap-PDU',
        u'VarBind',
        u'VarBindList',
        ]
    _set_ = [
        ]
    _val_ = [
        ]
    _class_ = [
        ]
    _param_ = [
        ]
    
    #-----< Message >-----#
    Message = SEQ(name=u'Message', mode=MODE_TYPE)
    _Message_version = INT(name=u'version', mode=MODE_TYPE)
    _Message_version._cont = ASN1Dict([(u'version-1', 0)])
    _Message_community = OCT_STR(name=u'community', mode=MODE_TYPE)
    _Message_data = ANY(name=u'data', mode=MODE_TYPE)
    Message._cont = ASN1Dict([
        (u'version', _Message_version),
        (u'community', _Message_community),
        (u'data', _Message_data),
        ])
    Message._ext = None
    
    #-----< PDUs >-----#
    PDUs = CHOICE(name=u'PDUs', mode=MODE_TYPE)
    _PDUs_get_request = SEQ(name=u'get-request', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1157-SNMP', 'GetRequest-PDU')))
    _PDUs_get_next_request = SEQ(name=u'get-next-request', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1157-SNMP', 'GetNextRequest-PDU')))
    _PDUs_get_response = SEQ(name=u'get-response', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1157-SNMP', 'GetResponse-PDU')))
    _PDUs_set_request = SEQ(name=u'set-request', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1157-SNMP', 'SetRequest-PDU')))
    _PDUs_trap = SEQ(name=u'trap', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1157-SNMP', 'Trap-PDU')))
    PDUs._cont = ASN1Dict([
        (u'get-request', _PDUs_get_request),
        (u'get-next-request', _PDUs_get_next_request),
        (u'get-response', _PDUs_get_response),
        (u'set-request', _PDUs_set_request),
        (u'trap', _PDUs_trap),
        ])
    PDUs._ext = None
    
    #-----< GetRequest-PDU >-----#
    GetRequest_PDU = SEQ(name=u'GetRequest-PDU', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RFC1157-SNMP', 'PDU')))
    
    #-----< GetNextRequest-PDU >-----#
    GetNextRequest_PDU = SEQ(name=u'GetNextRequest-PDU', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RFC1157-SNMP', 'PDU')))
    
    #-----< GetResponse-PDU >-----#
    GetResponse_PDU = SEQ(name=u'GetResponse-PDU', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RFC1157-SNMP', 'PDU')))
    
    #-----< SetRequest-PDU >-----#
    SetRequest_PDU = SEQ(name=u'SetRequest-PDU', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('RFC1157-SNMP', 'PDU')))
    
    #-----< PDU >-----#
    PDU = SEQ(name=u'PDU', mode=MODE_TYPE)
    _PDU_request_id = INT(name=u'request-id', mode=MODE_TYPE)
    _PDU_error_status = INT(name=u'error-status', mode=MODE_TYPE)
    _PDU_error_status._cont = ASN1Dict([(u'noError', 0), (u'tooBig', 1), (u'noSuchName', 2), (u'badValue', 3), (u'readOnly', 4), (u'genErr', 5)])
    _PDU_error_index = INT(name=u'error-index', mode=MODE_TYPE)
    _PDU_variable_bindings = SEQ_OF(name=u'variable-bindings', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1157-SNMP', 'VarBindList')))
    PDU._cont = ASN1Dict([
        (u'request-id', _PDU_request_id),
        (u'error-status', _PDU_error_status),
        (u'error-index', _PDU_error_index),
        (u'variable-bindings', _PDU_variable_bindings),
        ])
    PDU._ext = None
    
    #-----< Trap-PDU >-----#
    Trap_PDU = SEQ(name=u'Trap-PDU', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _Trap_PDU_enterprise = OID(name=u'enterprise', mode=MODE_TYPE)
    _Trap_PDU_agent_addr = CHOICE(name=u'agent-addr', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'NetworkAddress')))
    _Trap_PDU_generic_trap = INT(name=u'generic-trap', mode=MODE_TYPE)
    _Trap_PDU_generic_trap._cont = ASN1Dict([(u'coldStart', 0), (u'warmStart', 1), (u'linkDown', 2), (u'linkUp', 3), (u'authenticationFailure', 4), (u'egpNeighborLoss', 5), (u'enterpriseSpecific', 6)])
    _Trap_PDU_specific_trap = INT(name=u'specific-trap', mode=MODE_TYPE)
    _Trap_PDU_time_stamp = INT(name=u'time-stamp', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'TimeTicks')))
    _Trap_PDU_variable_bindings = SEQ_OF(name=u'variable-bindings', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1157-SNMP', 'VarBindList')))
    Trap_PDU._cont = ASN1Dict([
        (u'enterprise', _Trap_PDU_enterprise),
        (u'agent-addr', _Trap_PDU_agent_addr),
        (u'generic-trap', _Trap_PDU_generic_trap),
        (u'specific-trap', _Trap_PDU_specific_trap),
        (u'time-stamp', _Trap_PDU_time_stamp),
        (u'variable-bindings', _Trap_PDU_variable_bindings),
        ])
    Trap_PDU._ext = None
    
    #-----< VarBind >-----#
    VarBind = SEQ(name=u'VarBind', mode=MODE_TYPE)
    _VarBind_name = OID(name=u'name', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'ObjectName')))
    _VarBind_value = CHOICE(name=u'value', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1155-SMI', 'ObjectSyntax')))
    VarBind._cont = ASN1Dict([
        (u'name', _VarBind_name),
        (u'value', _VarBind_value),
        ])
    VarBind._ext = None
    
    #-----< VarBindList >-----#
    VarBindList = SEQ_OF(name=u'VarBindList', mode=MODE_TYPE)
    _VarBindList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('RFC1157-SNMP', 'VarBind')))
    VarBindList._cont = _VarBindList__item_
    
    _all_ = [
        _Message_version,
        _Message_community,
        _Message_data,
        Message,
        _PDUs_get_request,
        _PDUs_get_next_request,
        _PDUs_get_response,
        _PDUs_set_request,
        _PDUs_trap,
        PDUs,
        GetRequest_PDU,
        GetNextRequest_PDU,
        GetResponse_PDU,
        SetRequest_PDU,
        _PDU_request_id,
        _PDU_error_status,
        _PDU_error_index,
        _PDU_variable_bindings,
        PDU,
        _Trap_PDU_enterprise,
        _Trap_PDU_agent_addr,
        _Trap_PDU_generic_trap,
        _Trap_PDU_specific_trap,
        _Trap_PDU_time_stamp,
        _Trap_PDU_variable_bindings,
        Trap_PDU,
        _VarBind_name,
        _VarBind_value,
        VarBind,
        _VarBindList__item_,
        VarBindList,
    ]

init_modules(RFC1155_SMI, RFC1157_SNMP)
