# -*- coding: UTF-8 -*-
# Code automatically generated by pycrate_asn1c

from pycrate_asn1rt.utils            import *
from pycrate_asn1rt.err              import *
from pycrate_asn1rt.glob             import make_GLOBAL, GLOBAL
from pycrate_asn1rt.dictobj          import ASN1Dict
from pycrate_asn1rt.refobj           import *
from pycrate_asn1rt.setobj           import *
from pycrate_asn1rt.asnobj_basic     import *
from pycrate_asn1rt.asnobj_str       import *
from pycrate_asn1rt.asnobj_construct import *
from pycrate_asn1rt.asnobj_class     import *
from pycrate_asn1rt.asnobj_ext       import *
from pycrate_asn1rt.init             import init_modules

class AlgorithmObjectIdentifiers:

    _name_  = u'AlgorithmObjectIdentifiers'
    _oid_   = [2, 5, 1, 8, 7]
    
    _obj_ = [
        u'nullAlgorithm',
        u'encryptionAlgorithm',
        u'hashAlgorithm',
        u'signatureAlgorithm',
        u'id-ea',
        u'id-ha',
        u'id-sa',
        u'rsa',
        u'KeySize',
        u'id-ea-rsa',
        u'id-ha-sqMod-n',
        u'id-sa-sqMod-nWithRSA',
        u'mD5Algorithm',
        u'sha1Algorithm',
        ]
    _type_ = [
        u'KeySize',
        ]
    _set_ = [
        ]
    _val_ = [
        u'nullAlgorithm',
        u'encryptionAlgorithm',
        u'hashAlgorithm',
        u'signatureAlgorithm',
        u'id-ea',
        u'id-ha',
        u'id-sa',
        u'rsa',
        u'id-ea-rsa',
        u'id-ha-sqMod-n',
        u'id-sa-sqMod-nWithRSA',
        u'mD5Algorithm',
        u'sha1Algorithm',
        ]
    _class_ = [
        u'rsa',
        u'mD5Algorithm',
        u'sha1Algorithm',
        ]
    _param_ = [
        ]
    
    #-----< nullAlgorithm >-----#
    nullAlgorithm = OID(name=u'nullAlgorithm', mode=MODE_VALUE)
    nullAlgorithm._val = (2, 5, 8, 0)
    
    #-----< encryptionAlgorithm >-----#
    encryptionAlgorithm = OID(name=u'encryptionAlgorithm', mode=MODE_VALUE)
    encryptionAlgorithm._val = (2, 5, 8, 1)
    
    #-----< hashAlgorithm >-----#
    hashAlgorithm = OID(name=u'hashAlgorithm', mode=MODE_VALUE)
    hashAlgorithm._val = (2, 5, 8, 2)
    
    #-----< signatureAlgorithm >-----#
    signatureAlgorithm = OID(name=u'signatureAlgorithm', mode=MODE_VALUE)
    signatureAlgorithm._val = (2, 5, 8, 3)
    
    #-----< id-ea >-----#
    id_ea = OID(name=u'id-ea', mode=MODE_VALUE)
    id_ea._val = (2, 5, 8, 1)
    
    #-----< id-ha >-----#
    id_ha = OID(name=u'id-ha', mode=MODE_VALUE)
    id_ha._val = (2, 5, 8, 2)
    
    #-----< id-sa >-----#
    id_sa = OID(name=u'id-sa', mode=MODE_VALUE)
    id_sa._val = (2, 5, 8, 3)
    
    #-----< rsa >-----#
    rsa = CLASS(name=u'rsa', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _rsa_val_Type = INT(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AlgorithmObjectIdentifiers', 'KeySize')))
    rsa._val = dict([(u'Type', _rsa_val_Type), (u'id', (2, 5, 8, 1, 1))])
    
    #-----< KeySize >-----#
    KeySize = INT(name=u'KeySize', mode=MODE_TYPE)
    
    #-----< id-ea-rsa >-----#
    id_ea_rsa = OID(name=u'id-ea-rsa', mode=MODE_VALUE)
    id_ea_rsa._val = (2, 5, 8, 1, 1)
    
    #-----< id-ha-sqMod-n >-----#
    id_ha_sqMod_n = OID(name=u'id-ha-sqMod-n', mode=MODE_VALUE)
    id_ha_sqMod_n._val = (2, 5, 8, 2, 1)
    
    #-----< id-sa-sqMod-nWithRSA >-----#
    id_sa_sqMod_nWithRSA = OID(name=u'id-sa-sqMod-nWithRSA', mode=MODE_VALUE)
    id_sa_sqMod_nWithRSA._val = (2, 5, 8, 3, 1)
    
    #-----< mD5Algorithm >-----#
    mD5Algorithm = CLASS(name=u'mD5Algorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _mD5Algorithm_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    mD5Algorithm._val = dict([(u'Type', _mD5Algorithm_val_Type), (u'id', (1, 2, 840, 113549, 2, 5))])
    
    #-----< sha1Algorithm >-----#
    sha1Algorithm = CLASS(name=u'sha1Algorithm', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _sha1Algorithm_val_Type = NULL(name=u'Type', mode=MODE_TYPE)
    sha1Algorithm._val = dict([(u'Type', _sha1Algorithm_val_Type), (u'id', (1, 3, 14, 3, 2, 26))])
    
    _all_ = [
        nullAlgorithm,
        encryptionAlgorithm,
        hashAlgorithm,
        signatureAlgorithm,
        id_ea,
        id_ha,
        id_sa,
        rsa,
        _rsa_val_Type,
        KeySize,
        id_ea_rsa,
        id_ha_sqMod_n,
        id_sa_sqMod_nWithRSA,
        mD5Algorithm,
        _mD5Algorithm_val_Type,
        sha1Algorithm,
        _sha1Algorithm_val_Type,
    ]

class AttributeCertificateDefinitions:

    _name_  = u'AttributeCertificateDefinitions'
    _oid_   = [2, 5, 1, 32, 7]
    
    _obj_ = [
        u'AttributeCertificate',
        u'AttributeCertificateInfo',
        u'AttCertVersion',
        u'Holder',
        u'IssuerSerial',
        u'ObjectDigestInfo',
        u'AttCertIssuer',
        u'AttCertValidityPeriod',
        u'AttributeCertificationPath',
        u'ACPathData',
        u'PrivilegePolicy',
        u'role',
        u'RoleSyntax',
        u'xmlPrivilegeInfo',
        u'permission',
        u'DualStringSyntax',
        u'dualStringMatch',
        u'timeSpecification',
        u'timeSpecificationMatch',
        u'targetingInformation',
        u'Targets',
        u'Target',
        u'TargetCert',
        u'userNotice',
        u'acceptablePrivilegePolicies',
        u'AcceptablePrivilegePoliciesSyntax',
        u'singleUse',
        u'groupAC',
        u'noRevAvail',
        u'sOAIdentifier',
        u'sOAIdentifierMatch',
        u'attributeDescriptor',
        u'AttributeDescriptorSyntax',
        u'AttributeIdentifier',
        u'AttributeIDs',
        u'AttributeName',
        u'AttributeDescription',
        u'PrivilegePolicyIdentifier',
        u'attDescriptor',
        u'roleSpecCertIdentifier',
        u'RoleSpecCertIdentifierSyntax',
        u'RoleSpecCertIdentifier',
        u'roleSpecCertIdMatch',
        u'basicAttConstraints',
        u'BasicAttConstraintsSyntax',
        u'basicAttConstraintsMatch',
        u'delegatedNameConstraints',
        u'delegatedNameConstraintsMatch',
        u'acceptableCertPolicies',
        u'AcceptableCertPoliciesSyntax',
        u'CertPolicyId',
        u'acceptableCertPoliciesMatch',
        u'authorityAttributeIdentifier',
        u'AuthorityAttributeIdentifierSyntax',
        u'AuthAttId',
        u'authAttIdMatch',
        u'indirectIssuer',
        u'issuedOnBehalfOf',
        u'noAssertion',
        u'allowedAttributeAssignments',
        u'AllowedAttributeAssignments',
        u'attributeMappings',
        u'AttributeMappings',
        u'holderNameConstraints',
        u'HolderNameConstraintsSyntax',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'pmiUser',
        u'pmiAA',
        u'pmiSOA',
        u'attCertCRLDistributionPt',
        u'pmiDelegationPath',
        u'privilegePolicy',
        u'protectedPrivilegePolicy',
        u'attributeCertificateAttribute',
        u'aACertificate',
        u'attributeDescriptorCertificate',
        u'attributeCertificateRevocationList',
        u'attributeAuthorityRevocationList',
        u'delegationPath',
        u'AttCertPath',
        u'privPolicy',
        u'protPrivPolicy',
        u'xmlPrivPolicy',
        u'attributeCertificateExactMatch',
        u'AttributeCertificateExactAssertion',
        u'attributeCertificateMatch',
        u'AttributeCertificateAssertion',
        u'holderIssuerMatch',
        u'HolderIssuerAssertion',
        u'delegationPathMatch',
        u'DelMatchSyntax',
        u'extensionPresenceMatch',
        u'id-oc-pmiUser',
        u'id-oc-pmiAA',
        u'id-oc-pmiSOA',
        u'id-oc-attCertCRLDistributionPts',
        u'id-oc-privilegePolicy',
        u'id-oc-pmiDelegationPath',
        u'id-oc-protectedPrivilegePolicy',
        u'id-at-attributeCertificate',
        u'id-at-attributeCertificateRevocationList',
        u'id-at-aACertificate',
        u'id-at-attributeDescriptorCertificate',
        u'id-at-attributeAuthorityRevocationList',
        u'id-at-privPolicy',
        u'id-at-role',
        u'id-at-delegationPath',
        u'id-at-protPrivPolicy',
        u'id-at-xMLPrivilegeInfo',
        u'id-at-xmlPrivPolicy',
        u'id-at-permission',
        u'id-ce-authorityAttributeIdentifier',
        u'id-ce-roleSpecCertIdentifier',
        u'id-ce-basicAttConstraints',
        u'id-ce-delegatedNameConstraints',
        u'id-ce-timeSpecification',
        u'id-ce-attributeDescriptor',
        u'id-ce-userNotice',
        u'id-ce-sOAIdentifier',
        u'id-ce-acceptableCertPolicies',
        u'id-ce-targetInformation',
        u'id-ce-noRevAvail',
        u'id-ce-acceptablePrivilegePolicies',
        u'id-ce-indirectIssuer',
        u'id-ce-noAssertion',
        u'id-ce-issuedOnBehalfOf',
        u'id-ce-singleUse',
        u'id-ce-groupAC',
        u'id-ce-allowedAttAss',
        u'id-ce-attributeMappings',
        u'id-ce-holderNameConstraints',
        u'id-mr-attributeCertificateMatch',
        u'id-mr-attributeCertificateExactMatch',
        u'id-mr-holderIssuerMatch',
        u'id-mr-authAttIdMatch',
        u'id-mr-roleSpecCertIdMatch',
        u'id-mr-basicAttConstraintsMatch',
        u'id-mr-delegatedNameConstraintsMatch',
        u'id-mr-timeSpecMatch',
        u'id-mr-attDescriptorMatch',
        u'id-mr-acceptableCertPoliciesMatch',
        u'id-mr-delegationPathMatch',
        u'id-mr-sOAIdentifierMatch',
        u'id-mr-extensionPresenceMatch',
        u'id-mr-dualStringMatch',
        ]
    _type_ = [
        u'AttributeCertificate',
        u'AttributeCertificateInfo',
        u'AttCertVersion',
        u'Holder',
        u'IssuerSerial',
        u'ObjectDigestInfo',
        u'AttCertIssuer',
        u'AttCertValidityPeriod',
        u'AttributeCertificationPath',
        u'ACPathData',
        u'PrivilegePolicy',
        u'RoleSyntax',
        u'DualStringSyntax',
        u'Targets',
        u'Target',
        u'TargetCert',
        u'AcceptablePrivilegePoliciesSyntax',
        u'AttributeDescriptorSyntax',
        u'AttributeIdentifier',
        u'AttributeName',
        u'AttributeDescription',
        u'PrivilegePolicyIdentifier',
        u'RoleSpecCertIdentifierSyntax',
        u'RoleSpecCertIdentifier',
        u'BasicAttConstraintsSyntax',
        u'AcceptableCertPoliciesSyntax',
        u'CertPolicyId',
        u'AuthorityAttributeIdentifierSyntax',
        u'AuthAttId',
        u'AllowedAttributeAssignments',
        u'AttributeMappings',
        u'HolderNameConstraintsSyntax',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'AttCertPath',
        u'AttributeCertificateExactAssertion',
        u'AttributeCertificateAssertion',
        u'HolderIssuerAssertion',
        u'DelMatchSyntax',
        ]
    _set_ = [
        u'AttributeIDs',
        ]
    _val_ = [
        u'role',
        u'xmlPrivilegeInfo',
        u'permission',
        u'dualStringMatch',
        u'timeSpecification',
        u'timeSpecificationMatch',
        u'targetingInformation',
        u'userNotice',
        u'acceptablePrivilegePolicies',
        u'singleUse',
        u'groupAC',
        u'noRevAvail',
        u'sOAIdentifier',
        u'sOAIdentifierMatch',
        u'attributeDescriptor',
        u'attDescriptor',
        u'roleSpecCertIdentifier',
        u'roleSpecCertIdMatch',
        u'basicAttConstraints',
        u'basicAttConstraintsMatch',
        u'delegatedNameConstraints',
        u'delegatedNameConstraintsMatch',
        u'acceptableCertPolicies',
        u'acceptableCertPoliciesMatch',
        u'authorityAttributeIdentifier',
        u'authAttIdMatch',
        u'indirectIssuer',
        u'issuedOnBehalfOf',
        u'noAssertion',
        u'allowedAttributeAssignments',
        u'attributeMappings',
        u'holderNameConstraints',
        u'pmiUser',
        u'pmiAA',
        u'pmiSOA',
        u'attCertCRLDistributionPt',
        u'pmiDelegationPath',
        u'privilegePolicy',
        u'protectedPrivilegePolicy',
        u'attributeCertificateAttribute',
        u'aACertificate',
        u'attributeDescriptorCertificate',
        u'attributeCertificateRevocationList',
        u'attributeAuthorityRevocationList',
        u'delegationPath',
        u'privPolicy',
        u'protPrivPolicy',
        u'xmlPrivPolicy',
        u'attributeCertificateExactMatch',
        u'attributeCertificateMatch',
        u'holderIssuerMatch',
        u'delegationPathMatch',
        u'extensionPresenceMatch',
        u'id-oc-pmiUser',
        u'id-oc-pmiAA',
        u'id-oc-pmiSOA',
        u'id-oc-attCertCRLDistributionPts',
        u'id-oc-privilegePolicy',
        u'id-oc-pmiDelegationPath',
        u'id-oc-protectedPrivilegePolicy',
        u'id-at-attributeCertificate',
        u'id-at-attributeCertificateRevocationList',
        u'id-at-aACertificate',
        u'id-at-attributeDescriptorCertificate',
        u'id-at-attributeAuthorityRevocationList',
        u'id-at-privPolicy',
        u'id-at-role',
        u'id-at-delegationPath',
        u'id-at-protPrivPolicy',
        u'id-at-xMLPrivilegeInfo',
        u'id-at-xmlPrivPolicy',
        u'id-at-permission',
        u'id-ce-authorityAttributeIdentifier',
        u'id-ce-roleSpecCertIdentifier',
        u'id-ce-basicAttConstraints',
        u'id-ce-delegatedNameConstraints',
        u'id-ce-timeSpecification',
        u'id-ce-attributeDescriptor',
        u'id-ce-userNotice',
        u'id-ce-sOAIdentifier',
        u'id-ce-acceptableCertPolicies',
        u'id-ce-targetInformation',
        u'id-ce-noRevAvail',
        u'id-ce-acceptablePrivilegePolicies',
        u'id-ce-indirectIssuer',
        u'id-ce-noAssertion',
        u'id-ce-issuedOnBehalfOf',
        u'id-ce-singleUse',
        u'id-ce-groupAC',
        u'id-ce-allowedAttAss',
        u'id-ce-attributeMappings',
        u'id-ce-holderNameConstraints',
        u'id-mr-attributeCertificateMatch',
        u'id-mr-attributeCertificateExactMatch',
        u'id-mr-holderIssuerMatch',
        u'id-mr-authAttIdMatch',
        u'id-mr-roleSpecCertIdMatch',
        u'id-mr-basicAttConstraintsMatch',
        u'id-mr-delegatedNameConstraintsMatch',
        u'id-mr-timeSpecMatch',
        u'id-mr-attDescriptorMatch',
        u'id-mr-acceptableCertPoliciesMatch',
        u'id-mr-delegationPathMatch',
        u'id-mr-sOAIdentifierMatch',
        u'id-mr-extensionPresenceMatch',
        u'id-mr-dualStringMatch',
        ]
    _class_ = [
        u'role',
        u'xmlPrivilegeInfo',
        u'permission',
        u'dualStringMatch',
        u'timeSpecification',
        u'timeSpecificationMatch',
        u'targetingInformation',
        u'userNotice',
        u'acceptablePrivilegePolicies',
        u'singleUse',
        u'groupAC',
        u'noRevAvail',
        u'sOAIdentifier',
        u'sOAIdentifierMatch',
        u'attributeDescriptor',
        u'AttributeIDs',
        u'attDescriptor',
        u'roleSpecCertIdentifier',
        u'roleSpecCertIdMatch',
        u'basicAttConstraints',
        u'basicAttConstraintsMatch',
        u'delegatedNameConstraints',
        u'delegatedNameConstraintsMatch',
        u'acceptableCertPolicies',
        u'acceptableCertPoliciesMatch',
        u'authorityAttributeIdentifier',
        u'authAttIdMatch',
        u'indirectIssuer',
        u'issuedOnBehalfOf',
        u'noAssertion',
        u'allowedAttributeAssignments',
        u'attributeMappings',
        u'holderNameConstraints',
        u'pmiUser',
        u'pmiAA',
        u'pmiSOA',
        u'attCertCRLDistributionPt',
        u'pmiDelegationPath',
        u'privilegePolicy',
        u'protectedPrivilegePolicy',
        u'attributeCertificateAttribute',
        u'aACertificate',
        u'attributeDescriptorCertificate',
        u'attributeCertificateRevocationList',
        u'attributeAuthorityRevocationList',
        u'delegationPath',
        u'privPolicy',
        u'protPrivPolicy',
        u'xmlPrivPolicy',
        u'attributeCertificateExactMatch',
        u'attributeCertificateMatch',
        u'holderIssuerMatch',
        u'delegationPathMatch',
        u'extensionPresenceMatch',
        ]
    _param_ = [
        ]
    
    #-----< AttributeCertificate >-----#
    AttributeCertificate = SEQ(name=u'AttributeCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    _AttributeCertificate_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificateInfo')))
    _AttributeCertificate_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __AttributeCertificate_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___AttributeCertificate_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___AttributeCertificate_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab = ___AttributeCertificate_algorithmIdentifier_algorithm_tab
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab_at = None
    __AttributeCertificate_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __AttributeCertificate_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___AttributeCertificate_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___AttributeCertificate_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab = ___AttributeCertificate_algorithmIdentifier_parameters_tab
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __AttributeCertificate_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _AttributeCertificate_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificate_algorithmIdentifier_algorithm),
        (u'parameters', __AttributeCertificate_algorithmIdentifier_parameters),
        ])
    _AttributeCertificate_algorithmIdentifier._ext = []
    _AttributeCertificate_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    AttributeCertificate._cont = ASN1Dict([
        (u'toBeSigned', _AttributeCertificate_toBeSigned),
        (u'algorithmIdentifier', _AttributeCertificate_algorithmIdentifier),
        (u'encrypted', _AttributeCertificate_encrypted),
        ])
    AttributeCertificate._ext = []
    
    #-----< AttributeCertificateInfo >-----#
    AttributeCertificateInfo = SEQ(name=u'AttributeCertificateInfo', mode=MODE_TYPE)
    _AttributeCertificateInfo_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertVersion')))
    _AttributeCertificateInfo_holder = SEQ(name=u'holder', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'Holder')))
    _AttributeCertificateInfo_issuer = SEQ(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertIssuer')))
    _AttributeCertificateInfo_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __AttributeCertificateInfo_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___AttributeCertificateInfo_signature_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___AttributeCertificateInfo_signature_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __AttributeCertificateInfo_signature_algorithm._const_tab = ___AttributeCertificateInfo_signature_algorithm_tab
    __AttributeCertificateInfo_signature_algorithm._const_tab_at = None
    __AttributeCertificateInfo_signature_algorithm._const_tab_id = u'id'
    __AttributeCertificateInfo_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___AttributeCertificateInfo_signature_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___AttributeCertificateInfo_signature_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __AttributeCertificateInfo_signature_parameters._const_tab = ___AttributeCertificateInfo_signature_parameters_tab
    __AttributeCertificateInfo_signature_parameters._const_tab_at = ('..', u'algorithm')
    __AttributeCertificateInfo_signature_parameters._const_tab_id = u'Type'
    _AttributeCertificateInfo_signature._cont = ASN1Dict([
        (u'algorithm', __AttributeCertificateInfo_signature_algorithm),
        (u'parameters', __AttributeCertificateInfo_signature_parameters),
        ])
    _AttributeCertificateInfo_signature._ext = []
    _AttributeCertificateInfo_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    _AttributeCertificateInfo_attrCertValidityPeriod = SEQ(name=u'attrCertValidityPeriod', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertValidityPeriod')))
    _AttributeCertificateInfo_attributes = SEQ_OF(name=u'attributes', mode=MODE_TYPE)
    __AttributeCertificateInfo_attributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___AttributeCertificateInfo_attributes__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____AttributeCertificateInfo_attributes__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE)
    _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0 = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____AttributeCertificateInfo_attributes__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___AttributeCertificateInfo_attributes__item__type._const_tab = ____AttributeCertificateInfo_attributes__item__type_tab
    ___AttributeCertificateInfo_attributes__item__type._const_tab_at = None
    ___AttributeCertificateInfo_attributes__item__type._const_tab_id = u'id'
    ___AttributeCertificateInfo_attributes__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AttributeCertificateInfo_attributes__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____AttributeCertificateInfo_attributes__item__values__item_._const_tab = ____AttributeCertificateInfo_attributes__item__type_tab
    ____AttributeCertificateInfo_attributes__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AttributeCertificateInfo_attributes__item__values__item_._const_tab_id = u'Type'
    ___AttributeCertificateInfo_attributes__item__values._cont = ____AttributeCertificateInfo_attributes__item__values__item_
    ___AttributeCertificateInfo_attributes__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___AttributeCertificateInfo_attributes__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____AttributeCertificateInfo_attributes__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__value._const_tab = ____AttributeCertificateInfo_attributes__item__type_tab
    _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______AttributeCertificateInfo_attributes__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__contextList._cont = ______AttributeCertificateInfo_attributes__item__valuesWithContext__item__contextList__item_
    _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____AttributeCertificateInfo_attributes__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__value),
        (u'contextList', _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__contextList),
        ])
    ____AttributeCertificateInfo_attributes__item__valuesWithContext__item_._ext = []
    ___AttributeCertificateInfo_attributes__item__valuesWithContext._cont = ____AttributeCertificateInfo_attributes__item__valuesWithContext__item_
    ___AttributeCertificateInfo_attributes__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AttributeCertificateInfo_attributes__item_._cont = ASN1Dict([
        (u'type', ___AttributeCertificateInfo_attributes__item__type),
        (u'values', ___AttributeCertificateInfo_attributes__item__values),
        (u'valuesWithContext', ___AttributeCertificateInfo_attributes__item__valuesWithContext),
        ])
    __AttributeCertificateInfo_attributes__item_._ext = []
    _AttributeCertificateInfo_attributes._cont = __AttributeCertificateInfo_attributes__item_
    _AttributeCertificateInfo_issuerUniqueID = BIT_STR(name=u'issuerUniqueID', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UniqueIdentifier')), opt=True)
    _AttributeCertificateInfo_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Extensions')), opt=True)
    AttributeCertificateInfo._cont = ASN1Dict([
        (u'version', _AttributeCertificateInfo_version),
        (u'holder', _AttributeCertificateInfo_holder),
        (u'issuer', _AttributeCertificateInfo_issuer),
        (u'signature', _AttributeCertificateInfo_signature),
        (u'serialNumber', _AttributeCertificateInfo_serialNumber),
        (u'attrCertValidityPeriod', _AttributeCertificateInfo_attrCertValidityPeriod),
        (u'attributes', _AttributeCertificateInfo_attributes),
        (u'issuerUniqueID', _AttributeCertificateInfo_issuerUniqueID),
        (u'extensions', _AttributeCertificateInfo_extensions),
        ])
    AttributeCertificateInfo._ext = [u'extensions']
    
    #-----< AttCertVersion >-----#
    AttCertVersion = INT(name=u'AttCertVersion', mode=MODE_TYPE)
    AttCertVersion._cont = ASN1Dict([(u'v2', 1)])
    
    #-----< Holder >-----#
    Holder = SEQ(name=u'Holder', mode=MODE_TYPE)
    _Holder_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'IssuerSerial')), opt=True)
    _Holder_entityName = SEQ_OF(name=u'entityName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _Holder_objectDigestInfo = SEQ(name=u'objectDigestInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'ObjectDigestInfo')), opt=True)
    Holder._cont = ASN1Dict([
        (u'baseCertificateID', _Holder_baseCertificateID),
        (u'entityName', _Holder_entityName),
        (u'objectDigestInfo', _Holder_objectDigestInfo),
        ])
    Holder._ext = None
    
    #-----< IssuerSerial >-----#
    IssuerSerial = SEQ(name=u'IssuerSerial', mode=MODE_TYPE)
    _IssuerSerial_issuer = SEQ_OF(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    _IssuerSerial_serial = INT(name=u'serial', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    _IssuerSerial_issuerUID = BIT_STR(name=u'issuerUID', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UniqueIdentifier')), opt=True)
    IssuerSerial._cont = ASN1Dict([
        (u'issuer', _IssuerSerial_issuer),
        (u'serial', _IssuerSerial_serial),
        (u'issuerUID', _IssuerSerial_issuerUID),
        ])
    IssuerSerial._ext = []
    
    #-----< ObjectDigestInfo >-----#
    ObjectDigestInfo = SEQ(name=u'ObjectDigestInfo', mode=MODE_TYPE)
    _ObjectDigestInfo_digestedObjectType = ENUM(name=u'digestedObjectType', mode=MODE_TYPE)
    _ObjectDigestInfo_digestedObjectType._cont = ASN1Dict([(u'publicKey', 0), (u'publicKeyCert', 1), (u'otherObjectTypes', 2)])
    _ObjectDigestInfo_digestedObjectType._ext = None
    _ObjectDigestInfo_otherObjectTypeID = OID(name=u'otherObjectTypeID', mode=MODE_TYPE, opt=True)
    _ObjectDigestInfo_digestAlgorithm = SEQ(name=u'digestAlgorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __ObjectDigestInfo_digestAlgorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___ObjectDigestInfo_digestAlgorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___ObjectDigestInfo_digestAlgorithm_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab = ___ObjectDigestInfo_digestAlgorithm_algorithm_tab
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab_at = None
    __ObjectDigestInfo_digestAlgorithm_algorithm._const_tab_id = u'id'
    __ObjectDigestInfo_digestAlgorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___ObjectDigestInfo_digestAlgorithm_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___ObjectDigestInfo_digestAlgorithm_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab = ___ObjectDigestInfo_digestAlgorithm_parameters_tab
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab_at = ('..', u'algorithm')
    __ObjectDigestInfo_digestAlgorithm_parameters._const_tab_id = u'Type'
    _ObjectDigestInfo_digestAlgorithm._cont = ASN1Dict([
        (u'algorithm', __ObjectDigestInfo_digestAlgorithm_algorithm),
        (u'parameters', __ObjectDigestInfo_digestAlgorithm_parameters),
        ])
    _ObjectDigestInfo_digestAlgorithm._ext = []
    _ObjectDigestInfo_objectDigest = BIT_STR(name=u'objectDigest', mode=MODE_TYPE)
    ObjectDigestInfo._cont = ASN1Dict([
        (u'digestedObjectType', _ObjectDigestInfo_digestedObjectType),
        (u'otherObjectTypeID', _ObjectDigestInfo_otherObjectTypeID),
        (u'digestAlgorithm', _ObjectDigestInfo_digestAlgorithm),
        (u'objectDigest', _ObjectDigestInfo_objectDigest),
        ])
    ObjectDigestInfo._ext = []
    
    #-----< AttCertIssuer >-----#
    AttCertIssuer = SEQ(name=u'AttCertIssuer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _AttCertIssuer_issuerName = SEQ_OF(name=u'issuerName', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _AttCertIssuer_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'IssuerSerial')), opt=True)
    _AttCertIssuer_objectDigestInfo = SEQ(name=u'objectDigestInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'ObjectDigestInfo')), opt=True)
    AttCertIssuer._cont = ASN1Dict([
        (u'issuerName', _AttCertIssuer_issuerName),
        (u'baseCertificateID', _AttCertIssuer_baseCertificateID),
        (u'objectDigestInfo', _AttCertIssuer_objectDigestInfo),
        ])
    AttCertIssuer._ext = []
    
    #-----< AttCertValidityPeriod >-----#
    AttCertValidityPeriod = SEQ(name=u'AttCertValidityPeriod', mode=MODE_TYPE)
    _AttCertValidityPeriod_notBeforeTime = TIME_GEN(name=u'notBeforeTime', mode=MODE_TYPE)
    _AttCertValidityPeriod_notAfterTime = TIME_GEN(name=u'notAfterTime', mode=MODE_TYPE)
    AttCertValidityPeriod._cont = ASN1Dict([
        (u'notBeforeTime', _AttCertValidityPeriod_notBeforeTime),
        (u'notAfterTime', _AttCertValidityPeriod_notAfterTime),
        ])
    AttCertValidityPeriod._ext = []
    
    #-----< AttributeCertificationPath >-----#
    AttributeCertificationPath = SEQ(name=u'AttributeCertificationPath', mode=MODE_TYPE)
    _AttributeCertificationPath_attributeCertificate = SEQ(name=u'attributeCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    _AttributeCertificationPath_acPath = SEQ_OF(name=u'acPath', mode=MODE_TYPE, opt=True)
    __AttributeCertificationPath_acPath__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'ACPathData')))
    _AttributeCertificationPath_acPath._cont = __AttributeCertificationPath_acPath__item_
    AttributeCertificationPath._cont = ASN1Dict([
        (u'attributeCertificate', _AttributeCertificationPath_attributeCertificate),
        (u'acPath', _AttributeCertificationPath_acPath),
        ])
    AttributeCertificationPath._ext = []
    
    #-----< ACPathData >-----#
    ACPathData = SEQ(name=u'ACPathData', mode=MODE_TYPE)
    _ACPathData_certificate = SEQ(name=u'certificate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')), opt=True)
    _ACPathData_attributeCertificate = SEQ(name=u'attributeCertificate', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')), opt=True)
    ACPathData._cont = ASN1Dict([
        (u'certificate', _ACPathData_certificate),
        (u'attributeCertificate', _ACPathData_attributeCertificate),
        ])
    ACPathData._ext = []
    
    #-----< PrivilegePolicy >-----#
    PrivilegePolicy = OID(name=u'PrivilegePolicy', mode=MODE_TYPE)
    
    #-----< role >-----#
    role = CLASS(name=u'role', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _role_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'RoleSyntax')))
    role._val = dict([(u'Type', _role_val_Type), (u'id', (2, 5, 4, 72))])
    
    #-----< RoleSyntax >-----#
    RoleSyntax = SEQ(name=u'RoleSyntax', mode=MODE_TYPE)
    _RoleSyntax_roleAuthority = SEQ_OF(name=u'roleAuthority', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _RoleSyntax_roleName = CHOICE(name=u'roleName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    RoleSyntax._cont = ASN1Dict([
        (u'roleAuthority', _RoleSyntax_roleAuthority),
        (u'roleName', _RoleSyntax_roleName),
        ])
    RoleSyntax._ext = []
    
    #-----< xmlPrivilegeInfo >-----#
    xmlPrivilegeInfo = CLASS(name=u'xmlPrivilegeInfo', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _xmlPrivilegeInfo_val_Type = STR_UTF8(name=u'Type', mode=MODE_TYPE)
    xmlPrivilegeInfo._val = dict([(u'Type', _xmlPrivilegeInfo_val_Type), (u'id', (2, 5, 4, 75))])
    
    #-----< permission >-----#
    permission = CLASS(name=u'permission', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _permission_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'DualStringSyntax')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'DualStringSyntax')))
    permission._val = dict([(u'Type', _permission_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'id', (2, 5, 13, 69))])), (u'id', (2, 5, 4, 82))])
    
    #-----< DualStringSyntax >-----#
    DualStringSyntax = SEQ(name=u'DualStringSyntax', mode=MODE_TYPE)
    _DualStringSyntax_operation = CHOICE(name=u'operation', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    _DualStringSyntax_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    DualStringSyntax._cont = ASN1Dict([
        (u'operation', _DualStringSyntax_operation),
        (u'object', _DualStringSyntax_object),
        ])
    DualStringSyntax._ext = []
    
    #-----< dualStringMatch >-----#
    dualStringMatch = CLASS(name=u'dualStringMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _dualStringMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'DualStringSyntax')))
    dualStringMatch._val = dict([(u'AssertionType', _dualStringMatch_val_AssertionType), (u'id', (2, 5, 13, 69))])
    
    #-----< timeSpecification >-----#
    timeSpecification = CLASS(name=u'timeSpecification', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _timeSpecification_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'TimeSpecification')))
    timeSpecification._val = dict([(u'ExtnType', _timeSpecification_val_ExtnType), (u'id', (2, 5, 29, 43))])
    
    #-----< timeSpecificationMatch >-----#
    timeSpecificationMatch = CLASS(name=u'timeSpecificationMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _timeSpecificationMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'TimeSpecification')))
    timeSpecificationMatch._val = dict([(u'AssertionType', _timeSpecificationMatch_val_AssertionType), (u'id', (2, 5, 13, 57))])
    
    #-----< targetingInformation >-----#
    targetingInformation = CLASS(name=u'targetingInformation', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _targetingInformation_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE)
    __targetingInformation_val_ExtnType__item_ = SEQ_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'Targets')))
    _targetingInformation_val_ExtnType._cont = __targetingInformation_val_ExtnType__item_
    _targetingInformation_val_ExtnType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    targetingInformation._val = dict([(u'ExtnType', _targetingInformation_val_ExtnType), (u'id', (2, 5, 29, 55))])
    
    #-----< Targets >-----#
    Targets = SEQ_OF(name=u'Targets', mode=MODE_TYPE)
    _Targets__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'Target')))
    Targets._cont = _Targets__item_
    Targets._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< Target >-----#
    Target = CHOICE(name=u'Target', mode=MODE_TYPE)
    _Target_targetName = CHOICE(name=u'targetName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _Target_targetGroup = CHOICE(name=u'targetGroup', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _Target_targetCert = SEQ(name=u'targetCert', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'TargetCert')))
    Target._cont = ASN1Dict([
        (u'targetName', _Target_targetName),
        (u'targetGroup', _Target_targetGroup),
        (u'targetCert', _Target_targetCert),
        ])
    Target._ext = []
    
    #-----< TargetCert >-----#
    TargetCert = SEQ(name=u'TargetCert', mode=MODE_TYPE)
    _TargetCert_targetCertificate = SEQ(name=u'targetCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'IssuerSerial')))
    _TargetCert_targetName = CHOICE(name=u'targetName', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _TargetCert_certDigestInfo = SEQ(name=u'certDigestInfo', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'ObjectDigestInfo')), opt=True)
    TargetCert._cont = ASN1Dict([
        (u'targetCertificate', _TargetCert_targetCertificate),
        (u'targetName', _TargetCert_targetName),
        (u'certDigestInfo', _TargetCert_certDigestInfo),
        ])
    TargetCert._ext = None
    
    #-----< userNotice >-----#
    userNotice = CLASS(name=u'userNotice', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _userNotice_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE)
    __userNotice_val_ExtnType__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('PKIX1Implicit93', 'UserNotice')))
    _userNotice_val_ExtnType._cont = __userNotice_val_ExtnType__item_
    _userNotice_val_ExtnType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    userNotice._val = dict([(u'ExtnType', _userNotice_val_ExtnType), (u'id', (2, 5, 29, 49))])
    
    #-----< acceptablePrivilegePolicies >-----#
    acceptablePrivilegePolicies = CLASS(name=u'acceptablePrivilegePolicies', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _acceptablePrivilegePolicies_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AcceptablePrivilegePoliciesSyntax')))
    acceptablePrivilegePolicies._val = dict([(u'ExtnType', _acceptablePrivilegePolicies_val_ExtnType), (u'id', (2, 5, 29, 57))])
    
    #-----< AcceptablePrivilegePoliciesSyntax >-----#
    AcceptablePrivilegePoliciesSyntax = SEQ_OF(name=u'AcceptablePrivilegePoliciesSyntax', mode=MODE_TYPE)
    _AcceptablePrivilegePoliciesSyntax__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'PrivilegePolicy')))
    AcceptablePrivilegePoliciesSyntax._cont = _AcceptablePrivilegePoliciesSyntax__item_
    AcceptablePrivilegePoliciesSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< singleUse >-----#
    singleUse = CLASS(name=u'singleUse', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _singleUse_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    singleUse._val = dict([(u'ExtnType', _singleUse_val_ExtnType), (u'id', (2, 5, 29, 65))])
    
    #-----< groupAC >-----#
    groupAC = CLASS(name=u'groupAC', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _groupAC_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    groupAC._val = dict([(u'ExtnType', _groupAC_val_ExtnType), (u'id', (2, 5, 29, 66))])
    
    #-----< noRevAvail >-----#
    noRevAvail = CLASS(name=u'noRevAvail', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _noRevAvail_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    noRevAvail._val = dict([(u'ExtnType', _noRevAvail_val_ExtnType), (u'id', (2, 5, 29, 56))])
    
    #-----< sOAIdentifier >-----#
    sOAIdentifier = CLASS(name=u'sOAIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _sOAIdentifier_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    sOAIdentifier._val = dict([(u'ExtnType', _sOAIdentifier_val_ExtnType), (u'id', (2, 5, 29, 50))])
    
    #-----< sOAIdentifierMatch >-----#
    sOAIdentifierMatch = CLASS(name=u'sOAIdentifierMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _sOAIdentifierMatch_val_AssertionType = NULL(name=u'AssertionType', mode=MODE_TYPE)
    sOAIdentifierMatch._val = dict([(u'AssertionType', _sOAIdentifierMatch_val_AssertionType), (u'id', (2, 5, 13, 66))])
    
    #-----< attributeDescriptor >-----#
    attributeDescriptor = CLASS(name=u'attributeDescriptor', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _attributeDescriptor_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeDescriptorSyntax')))
    attributeDescriptor._val = dict([(u'ExtnType', _attributeDescriptor_val_ExtnType), (u'id', (2, 5, 29, 48))])
    
    #-----< AttributeDescriptorSyntax >-----#
    AttributeDescriptorSyntax = SEQ(name=u'AttributeDescriptorSyntax', mode=MODE_TYPE)
    _AttributeDescriptorSyntax_identifier = OID(name=u'identifier', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeIdentifier')))
    _AttributeDescriptorSyntax_attributeSyntax = OCT_STR(name=u'attributeSyntax', mode=MODE_TYPE)
    _AttributeDescriptorSyntax_attributeSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _AttributeDescriptorSyntax_name = STR_UTF8(name=u'name', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeName')), opt=True)
    _AttributeDescriptorSyntax_description = STR_UTF8(name=u'description', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeDescription')), opt=True)
    _AttributeDescriptorSyntax_dominationRule = SEQ(name=u'dominationRule', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'PrivilegePolicyIdentifier')))
    AttributeDescriptorSyntax._cont = ASN1Dict([
        (u'identifier', _AttributeDescriptorSyntax_identifier),
        (u'attributeSyntax', _AttributeDescriptorSyntax_attributeSyntax),
        (u'name', _AttributeDescriptorSyntax_name),
        (u'description', _AttributeDescriptorSyntax_description),
        (u'dominationRule', _AttributeDescriptorSyntax_dominationRule),
        ])
    AttributeDescriptorSyntax._ext = []
    
    #-----< AttributeIdentifier >-----#
    AttributeIdentifier = OID(name=u'AttributeIdentifier', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _AttributeIdentifier_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _AttributeIdentifier_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    AttributeIdentifier._const_tab = _AttributeIdentifier_tab
    AttributeIdentifier._const_tab_at = None
    AttributeIdentifier._const_tab_id = u'id'
    
    #-----< AttributeIDs >-----#
    AttributeIDs = CLASS(name=u'AttributeIDs', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    AttributeIDs._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< AttributeName >-----#
    AttributeName = STR_UTF8(name=u'AttributeName', mode=MODE_TYPE)
    AttributeName._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< AttributeDescription >-----#
    AttributeDescription = STR_UTF8(name=u'AttributeDescription', mode=MODE_TYPE)
    AttributeDescription._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PrivilegePolicyIdentifier >-----#
    PrivilegePolicyIdentifier = SEQ(name=u'PrivilegePolicyIdentifier', mode=MODE_TYPE)
    _PrivilegePolicyIdentifier_privilegePolicy = OID(name=u'privilegePolicy', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'PrivilegePolicy')))
    _PrivilegePolicyIdentifier_privPolSyntax = CHOICE(name=u'privPolSyntax', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'InfoSyntax')))
    PrivilegePolicyIdentifier._cont = ASN1Dict([
        (u'privilegePolicy', _PrivilegePolicyIdentifier_privilegePolicy),
        (u'privPolSyntax', _PrivilegePolicyIdentifier_privPolSyntax),
        ])
    PrivilegePolicyIdentifier._ext = []
    
    #-----< attDescriptor >-----#
    attDescriptor = CLASS(name=u'attDescriptor', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _attDescriptor_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeDescriptorSyntax')))
    attDescriptor._val = dict([(u'AssertionType', _attDescriptor_val_AssertionType), (u'id', (2, 5, 13, 58))])
    
    #-----< roleSpecCertIdentifier >-----#
    roleSpecCertIdentifier = CLASS(name=u'roleSpecCertIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _roleSpecCertIdentifier_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'RoleSpecCertIdentifierSyntax')))
    roleSpecCertIdentifier._val = dict([(u'ExtnType', _roleSpecCertIdentifier_val_ExtnType), (u'id', (2, 5, 29, 39))])
    
    #-----< RoleSpecCertIdentifierSyntax >-----#
    RoleSpecCertIdentifierSyntax = SEQ_OF(name=u'RoleSpecCertIdentifierSyntax', mode=MODE_TYPE)
    _RoleSpecCertIdentifierSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'RoleSpecCertIdentifier')))
    RoleSpecCertIdentifierSyntax._cont = _RoleSpecCertIdentifierSyntax__item_
    RoleSpecCertIdentifierSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< RoleSpecCertIdentifier >-----#
    RoleSpecCertIdentifier = SEQ(name=u'RoleSpecCertIdentifier', mode=MODE_TYPE)
    _RoleSpecCertIdentifier_roleName = CHOICE(name=u'roleName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _RoleSpecCertIdentifier_roleCertIssuer = CHOICE(name=u'roleCertIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _RoleSpecCertIdentifier_roleCertSerialNumber = INT(name=u'roleCertSerialNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')), opt=True)
    _RoleSpecCertIdentifier_roleCertLocator = SEQ_OF(name=u'roleCertLocator', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    RoleSpecCertIdentifier._cont = ASN1Dict([
        (u'roleName', _RoleSpecCertIdentifier_roleName),
        (u'roleCertIssuer', _RoleSpecCertIdentifier_roleCertIssuer),
        (u'roleCertSerialNumber', _RoleSpecCertIdentifier_roleCertSerialNumber),
        (u'roleCertLocator', _RoleSpecCertIdentifier_roleCertLocator),
        ])
    RoleSpecCertIdentifier._ext = []
    
    #-----< roleSpecCertIdMatch >-----#
    roleSpecCertIdMatch = CLASS(name=u'roleSpecCertIdMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _roleSpecCertIdMatch_val_AssertionType = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'RoleSpecCertIdentifierSyntax')))
    roleSpecCertIdMatch._val = dict([(u'AssertionType', _roleSpecCertIdMatch_val_AssertionType), (u'id', (2, 5, 13, 54))])
    
    #-----< basicAttConstraints >-----#
    basicAttConstraints = CLASS(name=u'basicAttConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _basicAttConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'BasicAttConstraintsSyntax')))
    basicAttConstraints._val = dict([(u'ExtnType', _basicAttConstraints_val_ExtnType), (u'id', (2, 5, 29, 41))])
    
    #-----< BasicAttConstraintsSyntax >-----#
    BasicAttConstraintsSyntax = SEQ(name=u'BasicAttConstraintsSyntax', mode=MODE_TYPE)
    _BasicAttConstraintsSyntax_authority = BOOL(name=u'authority', mode=MODE_TYPE, default=False)
    _BasicAttConstraintsSyntax_pathLenConstraint = INT(name=u'pathLenConstraint', mode=MODE_TYPE, opt=True)
    _BasicAttConstraintsSyntax_pathLenConstraint._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    BasicAttConstraintsSyntax._cont = ASN1Dict([
        (u'authority', _BasicAttConstraintsSyntax_authority),
        (u'pathLenConstraint', _BasicAttConstraintsSyntax_pathLenConstraint),
        ])
    BasicAttConstraintsSyntax._ext = []
    
    #-----< basicAttConstraintsMatch >-----#
    basicAttConstraintsMatch = CLASS(name=u'basicAttConstraintsMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _basicAttConstraintsMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'BasicAttConstraintsSyntax')))
    basicAttConstraintsMatch._val = dict([(u'AssertionType', _basicAttConstraintsMatch_val_AssertionType), (u'id', (2, 5, 13, 55))])
    
    #-----< delegatedNameConstraints >-----#
    delegatedNameConstraints = CLASS(name=u'delegatedNameConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _delegatedNameConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'NameConstraintsSyntax')))
    delegatedNameConstraints._val = dict([(u'ExtnType', _delegatedNameConstraints_val_ExtnType), (u'id', (2, 5, 29, 42))])
    
    #-----< delegatedNameConstraintsMatch >-----#
    delegatedNameConstraintsMatch = CLASS(name=u'delegatedNameConstraintsMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _delegatedNameConstraintsMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'NameConstraintsSyntax')))
    delegatedNameConstraintsMatch._val = dict([(u'AssertionType', _delegatedNameConstraintsMatch_val_AssertionType), (u'id', (2, 5, 13, 56))])
    
    #-----< acceptableCertPolicies >-----#
    acceptableCertPolicies = CLASS(name=u'acceptableCertPolicies', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _acceptableCertPolicies_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AcceptableCertPoliciesSyntax')))
    acceptableCertPolicies._val = dict([(u'ExtnType', _acceptableCertPolicies_val_ExtnType), (u'id', (2, 5, 29, 52))])
    
    #-----< AcceptableCertPoliciesSyntax >-----#
    AcceptableCertPoliciesSyntax = SEQ_OF(name=u'AcceptableCertPoliciesSyntax', mode=MODE_TYPE)
    _AcceptableCertPoliciesSyntax__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'CertPolicyId')))
    AcceptableCertPoliciesSyntax._cont = _AcceptableCertPoliciesSyntax__item_
    AcceptableCertPoliciesSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< CertPolicyId >-----#
    CertPolicyId = OID(name=u'CertPolicyId', mode=MODE_TYPE)
    
    #-----< acceptableCertPoliciesMatch >-----#
    acceptableCertPoliciesMatch = CLASS(name=u'acceptableCertPoliciesMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _acceptableCertPoliciesMatch_val_AssertionType = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AcceptableCertPoliciesSyntax')))
    acceptableCertPoliciesMatch._val = dict([(u'AssertionType', _acceptableCertPoliciesMatch_val_AssertionType), (u'id', (2, 5, 13, 59))])
    
    #-----< authorityAttributeIdentifier >-----#
    authorityAttributeIdentifier = CLASS(name=u'authorityAttributeIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _authorityAttributeIdentifier_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AuthorityAttributeIdentifierSyntax')))
    authorityAttributeIdentifier._val = dict([(u'ExtnType', _authorityAttributeIdentifier_val_ExtnType), (u'id', (2, 5, 29, 38))])
    
    #-----< AuthorityAttributeIdentifierSyntax >-----#
    AuthorityAttributeIdentifierSyntax = SEQ_OF(name=u'AuthorityAttributeIdentifierSyntax', mode=MODE_TYPE)
    _AuthorityAttributeIdentifierSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AuthAttId')))
    AuthorityAttributeIdentifierSyntax._cont = _AuthorityAttributeIdentifierSyntax__item_
    AuthorityAttributeIdentifierSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< AuthAttId >-----#
    AuthAttId = SEQ(name=u'AuthAttId', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'IssuerSerial')))
    
    #-----< authAttIdMatch >-----#
    authAttIdMatch = CLASS(name=u'authAttIdMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _authAttIdMatch_val_AssertionType = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AuthorityAttributeIdentifierSyntax')))
    authAttIdMatch._val = dict([(u'AssertionType', _authAttIdMatch_val_AssertionType), (u'id', (2, 5, 13, 53))])
    
    #-----< indirectIssuer >-----#
    indirectIssuer = CLASS(name=u'indirectIssuer', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _indirectIssuer_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    indirectIssuer._val = dict([(u'ExtnType', _indirectIssuer_val_ExtnType), (u'id', (2, 5, 29, 61))])
    
    #-----< issuedOnBehalfOf >-----#
    issuedOnBehalfOf = CLASS(name=u'issuedOnBehalfOf', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _issuedOnBehalfOf_val_ExtnType = CHOICE(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    issuedOnBehalfOf._val = dict([(u'ExtnType', _issuedOnBehalfOf_val_ExtnType), (u'id', (2, 5, 29, 64))])
    
    #-----< noAssertion >-----#
    noAssertion = CLASS(name=u'noAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _noAssertion_val_ExtnType = NULL(name=u'ExtnType', mode=MODE_TYPE)
    noAssertion._val = dict([(u'ExtnType', _noAssertion_val_ExtnType), (u'id', (2, 5, 29, 62))])
    
    #-----< allowedAttributeAssignments >-----#
    allowedAttributeAssignments = CLASS(name=u'allowedAttributeAssignments', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _allowedAttributeAssignments_val_ExtnType = SET_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AllowedAttributeAssignments')))
    allowedAttributeAssignments._val = dict([(u'ExtnType', _allowedAttributeAssignments_val_ExtnType), (u'id', (2, 5, 29, 67))])
    
    #-----< AllowedAttributeAssignments >-----#
    AllowedAttributeAssignments = SET_OF(name=u'AllowedAttributeAssignments', mode=MODE_TYPE)
    _AllowedAttributeAssignments__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __AllowedAttributeAssignments__item__attributes = SET_OF(name=u'attributes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___AllowedAttributeAssignments__item__attributes__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ____AllowedAttributeAssignments__item__attributes__item__attributeType = OID(name=u'attributeType', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues = SEQ(name=u'attributeTypeandValues', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab._val = ASN1Set(rv=[dict([(u'Type', _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type._const_tab = ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type._const_tab_at = None
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type._const_tab_id = u'id'
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values = SET_OF(name=u'values', mode=MODE_TYPE)
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_._const_tab = ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_._const_tab_at = ('..', '..', u'type')
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_._const_tab_id = u'Type'
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values._cont = ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value._const_tab = ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value._const_tab_id = u'Type'
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ________AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList._cont = ________AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList__item_
    _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value),
        (u'contextList', _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList),
        ])
    ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item_._ext = []
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext._cont = ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item_
    _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues._cont = ASN1Dict([
        (u'type', _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type),
        (u'values', _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values),
        (u'valuesWithContext', _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext),
        ])
    ____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues._ext = []
    ___AllowedAttributeAssignments__item__attributes__item_._cont = ASN1Dict([
        (u'attributeType', ____AllowedAttributeAssignments__item__attributes__item__attributeType),
        (u'attributeTypeandValues', ____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues),
        ])
    ___AllowedAttributeAssignments__item__attributes__item_._ext = []
    __AllowedAttributeAssignments__item__attributes._cont = ___AllowedAttributeAssignments__item__attributes__item_
    __AllowedAttributeAssignments__item__holderDomain = CHOICE(name=u'holderDomain', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _AllowedAttributeAssignments__item_._cont = ASN1Dict([
        (u'attributes', __AllowedAttributeAssignments__item__attributes),
        (u'holderDomain', __AllowedAttributeAssignments__item__holderDomain),
        ])
    _AllowedAttributeAssignments__item_._ext = []
    AllowedAttributeAssignments._cont = _AllowedAttributeAssignments__item_
    
    #-----< attributeMappings >-----#
    attributeMappings = CLASS(name=u'attributeMappings', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _attributeMappings_val_ExtnType = SET_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeMappings')))
    attributeMappings._val = dict([(u'ExtnType', _attributeMappings_val_ExtnType), (u'id', (2, 5, 29, 68))])
    
    #-----< AttributeMappings >-----#
    AttributeMappings = SET_OF(name=u'AttributeMappings', mode=MODE_TYPE)
    _AttributeMappings__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    __AttributeMappings__item__typeMappings = SEQ(name=u'typeMappings', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___AttributeMappings__item__typeMappings_local = OID(name=u'local', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ___AttributeMappings__item__typeMappings_remote = OID(name=u'remote', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    __AttributeMappings__item__typeMappings._cont = ASN1Dict([
        (u'local', ___AttributeMappings__item__typeMappings_local),
        (u'remote', ___AttributeMappings__item__typeMappings_remote),
        ])
    __AttributeMappings__item__typeMappings._ext = []
    __AttributeMappings__item__typeValueMappings = SEQ(name=u'typeValueMappings', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    ___AttributeMappings__item__typeValueMappings_local = SEQ(name=u'local', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeTypeAndValue')))
    ___AttributeMappings__item__typeValueMappings_remote = SEQ(name=u'remote', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeTypeAndValue')))
    __AttributeMappings__item__typeValueMappings._cont = ASN1Dict([
        (u'local', ___AttributeMappings__item__typeValueMappings_local),
        (u'remote', ___AttributeMappings__item__typeValueMappings_remote),
        ])
    __AttributeMappings__item__typeValueMappings._ext = []
    _AttributeMappings__item_._cont = ASN1Dict([
        (u'typeMappings', __AttributeMappings__item__typeMappings),
        (u'typeValueMappings', __AttributeMappings__item__typeValueMappings),
        ])
    _AttributeMappings__item_._ext = None
    AttributeMappings._cont = _AttributeMappings__item_
    
    #-----< holderNameConstraints >-----#
    holderNameConstraints = CLASS(name=u'holderNameConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _holderNameConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'HolderNameConstraintsSyntax')))
    holderNameConstraints._val = dict([(u'ExtnType', _holderNameConstraints_val_ExtnType), (u'id', (2, 5, 29, 69))])
    
    #-----< HolderNameConstraintsSyntax >-----#
    HolderNameConstraintsSyntax = SEQ(name=u'HolderNameConstraintsSyntax', mode=MODE_TYPE)
    _HolderNameConstraintsSyntax_permittedSubtrees = SEQ_OF(name=u'permittedSubtrees', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'GeneralSubtrees')))
    _HolderNameConstraintsSyntax_excludedSubtrees = SEQ_OF(name=u'excludedSubtrees', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'GeneralSubtrees')), opt=True)
    HolderNameConstraintsSyntax._cont = ASN1Dict([
        (u'permittedSubtrees', _HolderNameConstraintsSyntax_permittedSubtrees),
        (u'excludedSubtrees', _HolderNameConstraintsSyntax_excludedSubtrees),
        ])
    HolderNameConstraintsSyntax._ext = []
    
    #-----< GeneralSubtrees >-----#
    GeneralSubtrees = SEQ_OF(name=u'GeneralSubtrees', mode=MODE_TYPE)
    _GeneralSubtrees__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'GeneralSubtree')))
    GeneralSubtrees._cont = _GeneralSubtrees__item_
    GeneralSubtrees._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralSubtree >-----#
    GeneralSubtree = SEQ(name=u'GeneralSubtree', mode=MODE_TYPE)
    _GeneralSubtree_base = CHOICE(name=u'base', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _GeneralSubtree_minimum = INT(name=u'minimum', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'BaseDistance')), default=0)
    _GeneralSubtree_maximum = INT(name=u'maximum', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'BaseDistance')), opt=True)
    GeneralSubtree._cont = ASN1Dict([
        (u'base', _GeneralSubtree_base),
        (u'minimum', _GeneralSubtree_minimum),
        (u'maximum', _GeneralSubtree_maximum),
        ])
    GeneralSubtree._ext = []
    
    #-----< BaseDistance >-----#
    BaseDistance = INT(name=u'BaseDistance', mode=MODE_TYPE)
    BaseDistance._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< pmiUser >-----#
    pmiUser = CLASS(name=u'pmiUser', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    __pmiUser_OptionalAttributes_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificateExactAssertion')))
    pmiUser._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 58))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 24))])
    
    #-----< pmiAA >-----#
    pmiAA = CLASS(name=u'pmiAA', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListExactAssertion')))
    __pmiUser_OptionalAttributes_val_Type_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    pmiAA._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 61))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'id', (2, 5, 4, 59))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_2), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'id', (2, 5, 4, 63))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 25))])
    
    #-----< pmiSOA >-----#
    pmiSOA = CLASS(name=u'pmiSOA', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_0_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    __pmiUser_OptionalAttributes_val_Type_2_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    pmiSOA._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'id', (2, 5, 4, 59))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'id', (2, 5, 4, 63))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_2_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 62))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 26))])
    
    #-----< attCertCRLDistributionPt >-----#
    attCertCRLDistributionPt = CLASS(name=u'attCertCRLDistributionPt', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    attCertCRLDistributionPt._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'id', (2, 5, 4, 59))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'id', (2, 5, 4, 63))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 27))])
    
    #-----< pmiDelegationPath >-----#
    pmiDelegationPath = CLASS(name=u'pmiDelegationPath', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_0_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertPath')))
    pmiDelegationPath._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_1), (u'id', (2, 5, 4, 73))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 33))])
    
    #-----< privilegePolicy >-----#
    privilegePolicy = CLASS(name=u'privilegePolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_0_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicySyntax')))
    privilegePolicy._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_2), (u'id', (2, 5, 4, 71))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 32))])
    
    #-----< protectedPrivilegePolicy >-----#
    protectedPrivilegePolicy = CLASS(name=u'protectedPrivilegePolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    protectedPrivilegePolicy._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 74))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 34))])
    
    #-----< attributeCertificateAttribute >-----#
    attributeCertificateAttribute = CLASS(name=u'attributeCertificateAttribute', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _attributeCertificateAttribute_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    attributeCertificateAttribute._val = dict([(u'Type', _attributeCertificateAttribute_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 58))])
    
    #-----< aACertificate >-----#
    aACertificate = CLASS(name=u'aACertificate', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _aACertificate_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    aACertificate._val = dict([(u'Type', _aACertificate_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 61))])
    
    #-----< attributeDescriptorCertificate >-----#
    attributeDescriptorCertificate = CLASS(name=u'attributeDescriptorCertificate', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _attributeDescriptorCertificate_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    attributeDescriptorCertificate._val = dict([(u'Type', _attributeDescriptorCertificate_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 62))])
    
    #-----< attributeCertificateRevocationList >-----#
    attributeCertificateRevocationList = CLASS(name=u'attributeCertificateRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _attributeCertificateRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    attributeCertificateRevocationList._val = dict([(u'Type', _attributeCertificateRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'id', (2, 5, 4, 59))])
    
    #-----< attributeAuthorityRevocationList >-----#
    attributeAuthorityRevocationList = CLASS(name=u'attributeAuthorityRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _attributeAuthorityRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    attributeAuthorityRevocationList._val = dict([(u'Type', _attributeAuthorityRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'id', (2, 5, 4, 63))])
    
    #-----< delegationPath >-----#
    delegationPath = CLASS(name=u'delegationPath', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _delegationPath_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertPath')))
    delegationPath._val = dict([(u'Type', _delegationPath_val_Type), (u'id', (2, 5, 4, 73))])
    
    #-----< AttCertPath >-----#
    AttCertPath = SEQ_OF(name=u'AttCertPath', mode=MODE_TYPE)
    _AttCertPath__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    AttCertPath._cont = _AttCertPath__item_
    
    #-----< privPolicy >-----#
    privPolicy = CLASS(name=u'privPolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _privPolicy_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicySyntax')))
    privPolicy._val = dict([(u'Type', _privPolicy_val_Type), (u'id', (2, 5, 4, 71))])
    
    #-----< protPrivPolicy >-----#
    protPrivPolicy = CLASS(name=u'protPrivPolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _protPrivPolicy_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificate')))
    protPrivPolicy._val = dict([(u'Type', _protPrivPolicy_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'id', (2, 5, 13, 45))])), (u'id', (2, 5, 4, 74))])
    
    #-----< xmlPrivPolicy >-----#
    xmlPrivPolicy = CLASS(name=u'xmlPrivPolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _xmlPrivPolicy_val_Type = STR_UTF8(name=u'Type', mode=MODE_TYPE)
    xmlPrivPolicy._val = dict([(u'Type', _xmlPrivPolicy_val_Type), (u'id', (2, 5, 4, 76))])
    
    #-----< attributeCertificateExactMatch >-----#
    attributeCertificateExactMatch = CLASS(name=u'attributeCertificateExactMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _attributeCertificateExactMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificateExactAssertion')))
    attributeCertificateExactMatch._val = dict([(u'AssertionType', _attributeCertificateExactMatch_val_AssertionType), (u'id', (2, 5, 13, 45))])
    
    #-----< AttributeCertificateExactAssertion >-----#
    AttributeCertificateExactAssertion = SEQ(name=u'AttributeCertificateExactAssertion', mode=MODE_TYPE)
    _AttributeCertificateExactAssertion_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    _AttributeCertificateExactAssertion_issuer = SEQ(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertIssuer')))
    AttributeCertificateExactAssertion._cont = ASN1Dict([
        (u'serialNumber', _AttributeCertificateExactAssertion_serialNumber),
        (u'issuer', _AttributeCertificateExactAssertion_issuer),
        ])
    AttributeCertificateExactAssertion._ext = []
    
    #-----< attributeCertificateMatch >-----#
    attributeCertificateMatch = CLASS(name=u'attributeCertificateMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _attributeCertificateMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificateAssertion')))
    attributeCertificateMatch._val = dict([(u'AssertionType', _attributeCertificateMatch_val_AssertionType), (u'id', (2, 5, 13, 42))])
    
    #-----< AttributeCertificateAssertion >-----#
    AttributeCertificateAssertion = SEQ(name=u'AttributeCertificateAssertion', mode=MODE_TYPE)
    _AttributeCertificateAssertion_holder = CHOICE(name=u'holder', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __AttributeCertificateAssertion_holder_baseCertificateID = SEQ(name=u'baseCertificateID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'IssuerSerial')))
    __AttributeCertificateAssertion_holder_holderName = SEQ_OF(name=u'holderName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    _AttributeCertificateAssertion_holder._cont = ASN1Dict([
        (u'baseCertificateID', __AttributeCertificateAssertion_holder_baseCertificateID),
        (u'holderName', __AttributeCertificateAssertion_holder_holderName),
        ])
    _AttributeCertificateAssertion_holder._ext = []
    _AttributeCertificateAssertion_issuer = SEQ_OF(name=u'issuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _AttributeCertificateAssertion_attCertValidity = TIME_GEN(name=u'attCertValidity', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _AttributeCertificateAssertion_attType = SET_OF(name=u'attType', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    __AttributeCertificateAssertion_attType__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _AttributeCertificateAssertion_attType._cont = __AttributeCertificateAssertion_attType__item_
    AttributeCertificateAssertion._cont = ASN1Dict([
        (u'holder', _AttributeCertificateAssertion_holder),
        (u'issuer', _AttributeCertificateAssertion_issuer),
        (u'attCertValidity', _AttributeCertificateAssertion_attCertValidity),
        (u'attType', _AttributeCertificateAssertion_attType),
        ])
    AttributeCertificateAssertion._ext = []
    
    #-----< holderIssuerMatch >-----#
    holderIssuerMatch = CLASS(name=u'holderIssuerMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _holderIssuerMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'HolderIssuerAssertion')))
    holderIssuerMatch._val = dict([(u'AssertionType', _holderIssuerMatch_val_AssertionType), (u'id', (2, 5, 13, 46))])
    
    #-----< HolderIssuerAssertion >-----#
    HolderIssuerAssertion = SEQ(name=u'HolderIssuerAssertion', mode=MODE_TYPE)
    _HolderIssuerAssertion_holder = SEQ(name=u'holder', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'Holder')), opt=True)
    _HolderIssuerAssertion_issuer = SEQ(name=u'issuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertIssuer')), opt=True)
    HolderIssuerAssertion._cont = ASN1Dict([
        (u'holder', _HolderIssuerAssertion_holder),
        (u'issuer', _HolderIssuerAssertion_issuer),
        ])
    HolderIssuerAssertion._ext = []
    
    #-----< delegationPathMatch >-----#
    delegationPathMatch = CLASS(name=u'delegationPathMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _delegationPathMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'DelMatchSyntax')))
    delegationPathMatch._val = dict([(u'AssertionType', _delegationPathMatch_val_AssertionType), (u'id', (2, 5, 13, 61))])
    
    #-----< DelMatchSyntax >-----#
    DelMatchSyntax = SEQ(name=u'DelMatchSyntax', mode=MODE_TYPE)
    _DelMatchSyntax_firstIssuer = SEQ(name=u'firstIssuer', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttCertIssuer')))
    _DelMatchSyntax_lastHolder = SEQ(name=u'lastHolder', mode=MODE_TYPE, typeref=ASN1RefType(('AttributeCertificateDefinitions', 'Holder')))
    DelMatchSyntax._cont = ASN1Dict([
        (u'firstIssuer', _DelMatchSyntax_firstIssuer),
        (u'lastHolder', _DelMatchSyntax_lastHolder),
        ])
    DelMatchSyntax._ext = []
    
    #-----< extensionPresenceMatch >-----#
    extensionPresenceMatch = CLASS(name=u'extensionPresenceMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _extensionPresenceMatch_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'EXTENSION'), [u'id']))
    extensionPresenceMatch._val = dict([(u'AssertionType', _extensionPresenceMatch_val_AssertionType), (u'id', (2, 5, 13, 67))])
    
    #-----< id-oc-pmiUser >-----#
    id_oc_pmiUser = OID(name=u'id-oc-pmiUser', mode=MODE_VALUE)
    id_oc_pmiUser._val = (2, 5, 6, 24)
    
    #-----< id-oc-pmiAA >-----#
    id_oc_pmiAA = OID(name=u'id-oc-pmiAA', mode=MODE_VALUE)
    id_oc_pmiAA._val = (2, 5, 6, 25)
    
    #-----< id-oc-pmiSOA >-----#
    id_oc_pmiSOA = OID(name=u'id-oc-pmiSOA', mode=MODE_VALUE)
    id_oc_pmiSOA._val = (2, 5, 6, 26)
    
    #-----< id-oc-attCertCRLDistributionPts >-----#
    id_oc_attCertCRLDistributionPts = OID(name=u'id-oc-attCertCRLDistributionPts', mode=MODE_VALUE)
    id_oc_attCertCRLDistributionPts._val = (2, 5, 6, 27)
    
    #-----< id-oc-privilegePolicy >-----#
    id_oc_privilegePolicy = OID(name=u'id-oc-privilegePolicy', mode=MODE_VALUE)
    id_oc_privilegePolicy._val = (2, 5, 6, 32)
    
    #-----< id-oc-pmiDelegationPath >-----#
    id_oc_pmiDelegationPath = OID(name=u'id-oc-pmiDelegationPath', mode=MODE_VALUE)
    id_oc_pmiDelegationPath._val = (2, 5, 6, 33)
    
    #-----< id-oc-protectedPrivilegePolicy >-----#
    id_oc_protectedPrivilegePolicy = OID(name=u'id-oc-protectedPrivilegePolicy', mode=MODE_VALUE)
    id_oc_protectedPrivilegePolicy._val = (2, 5, 6, 34)
    
    #-----< id-at-attributeCertificate >-----#
    id_at_attributeCertificate = OID(name=u'id-at-attributeCertificate', mode=MODE_VALUE)
    id_at_attributeCertificate._val = (2, 5, 4, 58)
    
    #-----< id-at-attributeCertificateRevocationList >-----#
    id_at_attributeCertificateRevocationList = OID(name=u'id-at-attributeCertificateRevocationList', mode=MODE_VALUE)
    id_at_attributeCertificateRevocationList._val = (2, 5, 4, 59)
    
    #-----< id-at-aACertificate >-----#
    id_at_aACertificate = OID(name=u'id-at-aACertificate', mode=MODE_VALUE)
    id_at_aACertificate._val = (2, 5, 4, 61)
    
    #-----< id-at-attributeDescriptorCertificate >-----#
    id_at_attributeDescriptorCertificate = OID(name=u'id-at-attributeDescriptorCertificate', mode=MODE_VALUE)
    id_at_attributeDescriptorCertificate._val = (2, 5, 4, 62)
    
    #-----< id-at-attributeAuthorityRevocationList >-----#
    id_at_attributeAuthorityRevocationList = OID(name=u'id-at-attributeAuthorityRevocationList', mode=MODE_VALUE)
    id_at_attributeAuthorityRevocationList._val = (2, 5, 4, 63)
    
    #-----< id-at-privPolicy >-----#
    id_at_privPolicy = OID(name=u'id-at-privPolicy', mode=MODE_VALUE)
    id_at_privPolicy._val = (2, 5, 4, 71)
    
    #-----< id-at-role >-----#
    id_at_role = OID(name=u'id-at-role', mode=MODE_VALUE)
    id_at_role._val = (2, 5, 4, 72)
    
    #-----< id-at-delegationPath >-----#
    id_at_delegationPath = OID(name=u'id-at-delegationPath', mode=MODE_VALUE)
    id_at_delegationPath._val = (2, 5, 4, 73)
    
    #-----< id-at-protPrivPolicy >-----#
    id_at_protPrivPolicy = OID(name=u'id-at-protPrivPolicy', mode=MODE_VALUE)
    id_at_protPrivPolicy._val = (2, 5, 4, 74)
    
    #-----< id-at-xMLPrivilegeInfo >-----#
    id_at_xMLPrivilegeInfo = OID(name=u'id-at-xMLPrivilegeInfo', mode=MODE_VALUE)
    id_at_xMLPrivilegeInfo._val = (2, 5, 4, 75)
    
    #-----< id-at-xmlPrivPolicy >-----#
    id_at_xmlPrivPolicy = OID(name=u'id-at-xmlPrivPolicy', mode=MODE_VALUE)
    id_at_xmlPrivPolicy._val = (2, 5, 4, 76)
    
    #-----< id-at-permission >-----#
    id_at_permission = OID(name=u'id-at-permission', mode=MODE_VALUE)
    id_at_permission._val = (2, 5, 4, 82)
    
    #-----< id-ce-authorityAttributeIdentifier >-----#
    id_ce_authorityAttributeIdentifier = OID(name=u'id-ce-authorityAttributeIdentifier', mode=MODE_VALUE)
    id_ce_authorityAttributeIdentifier._val = (2, 5, 29, 38)
    
    #-----< id-ce-roleSpecCertIdentifier >-----#
    id_ce_roleSpecCertIdentifier = OID(name=u'id-ce-roleSpecCertIdentifier', mode=MODE_VALUE)
    id_ce_roleSpecCertIdentifier._val = (2, 5, 29, 39)
    
    #-----< id-ce-basicAttConstraints >-----#
    id_ce_basicAttConstraints = OID(name=u'id-ce-basicAttConstraints', mode=MODE_VALUE)
    id_ce_basicAttConstraints._val = (2, 5, 29, 41)
    
    #-----< id-ce-delegatedNameConstraints >-----#
    id_ce_delegatedNameConstraints = OID(name=u'id-ce-delegatedNameConstraints', mode=MODE_VALUE)
    id_ce_delegatedNameConstraints._val = (2, 5, 29, 42)
    
    #-----< id-ce-timeSpecification >-----#
    id_ce_timeSpecification = OID(name=u'id-ce-timeSpecification', mode=MODE_VALUE)
    id_ce_timeSpecification._val = (2, 5, 29, 43)
    
    #-----< id-ce-attributeDescriptor >-----#
    id_ce_attributeDescriptor = OID(name=u'id-ce-attributeDescriptor', mode=MODE_VALUE)
    id_ce_attributeDescriptor._val = (2, 5, 29, 48)
    
    #-----< id-ce-userNotice >-----#
    id_ce_userNotice = OID(name=u'id-ce-userNotice', mode=MODE_VALUE)
    id_ce_userNotice._val = (2, 5, 29, 49)
    
    #-----< id-ce-sOAIdentifier >-----#
    id_ce_sOAIdentifier = OID(name=u'id-ce-sOAIdentifier', mode=MODE_VALUE)
    id_ce_sOAIdentifier._val = (2, 5, 29, 50)
    
    #-----< id-ce-acceptableCertPolicies >-----#
    id_ce_acceptableCertPolicies = OID(name=u'id-ce-acceptableCertPolicies', mode=MODE_VALUE)
    id_ce_acceptableCertPolicies._val = (2, 5, 29, 52)
    
    #-----< id-ce-targetInformation >-----#
    id_ce_targetInformation = OID(name=u'id-ce-targetInformation', mode=MODE_VALUE)
    id_ce_targetInformation._val = (2, 5, 29, 55)
    
    #-----< id-ce-noRevAvail >-----#
    id_ce_noRevAvail = OID(name=u'id-ce-noRevAvail', mode=MODE_VALUE)
    id_ce_noRevAvail._val = (2, 5, 29, 56)
    
    #-----< id-ce-acceptablePrivilegePolicies >-----#
    id_ce_acceptablePrivilegePolicies = OID(name=u'id-ce-acceptablePrivilegePolicies', mode=MODE_VALUE)
    id_ce_acceptablePrivilegePolicies._val = (2, 5, 29, 57)
    
    #-----< id-ce-indirectIssuer >-----#
    id_ce_indirectIssuer = OID(name=u'id-ce-indirectIssuer', mode=MODE_VALUE)
    id_ce_indirectIssuer._val = (2, 5, 29, 61)
    
    #-----< id-ce-noAssertion >-----#
    id_ce_noAssertion = OID(name=u'id-ce-noAssertion', mode=MODE_VALUE)
    id_ce_noAssertion._val = (2, 5, 29, 62)
    
    #-----< id-ce-issuedOnBehalfOf >-----#
    id_ce_issuedOnBehalfOf = OID(name=u'id-ce-issuedOnBehalfOf', mode=MODE_VALUE)
    id_ce_issuedOnBehalfOf._val = (2, 5, 29, 64)
    
    #-----< id-ce-singleUse >-----#
    id_ce_singleUse = OID(name=u'id-ce-singleUse', mode=MODE_VALUE)
    id_ce_singleUse._val = (2, 5, 29, 65)
    
    #-----< id-ce-groupAC >-----#
    id_ce_groupAC = OID(name=u'id-ce-groupAC', mode=MODE_VALUE)
    id_ce_groupAC._val = (2, 5, 29, 66)
    
    #-----< id-ce-allowedAttAss >-----#
    id_ce_allowedAttAss = OID(name=u'id-ce-allowedAttAss', mode=MODE_VALUE)
    id_ce_allowedAttAss._val = (2, 5, 29, 67)
    
    #-----< id-ce-attributeMappings >-----#
    id_ce_attributeMappings = OID(name=u'id-ce-attributeMappings', mode=MODE_VALUE)
    id_ce_attributeMappings._val = (2, 5, 29, 68)
    
    #-----< id-ce-holderNameConstraints >-----#
    id_ce_holderNameConstraints = OID(name=u'id-ce-holderNameConstraints', mode=MODE_VALUE)
    id_ce_holderNameConstraints._val = (2, 5, 29, 69)
    
    #-----< id-mr-attributeCertificateMatch >-----#
    id_mr_attributeCertificateMatch = OID(name=u'id-mr-attributeCertificateMatch', mode=MODE_VALUE)
    id_mr_attributeCertificateMatch._val = (2, 5, 13, 42)
    
    #-----< id-mr-attributeCertificateExactMatch >-----#
    id_mr_attributeCertificateExactMatch = OID(name=u'id-mr-attributeCertificateExactMatch', mode=MODE_VALUE)
    id_mr_attributeCertificateExactMatch._val = (2, 5, 13, 45)
    
    #-----< id-mr-holderIssuerMatch >-----#
    id_mr_holderIssuerMatch = OID(name=u'id-mr-holderIssuerMatch', mode=MODE_VALUE)
    id_mr_holderIssuerMatch._val = (2, 5, 13, 46)
    
    #-----< id-mr-authAttIdMatch >-----#
    id_mr_authAttIdMatch = OID(name=u'id-mr-authAttIdMatch', mode=MODE_VALUE)
    id_mr_authAttIdMatch._val = (2, 5, 13, 53)
    
    #-----< id-mr-roleSpecCertIdMatch >-----#
    id_mr_roleSpecCertIdMatch = OID(name=u'id-mr-roleSpecCertIdMatch', mode=MODE_VALUE)
    id_mr_roleSpecCertIdMatch._val = (2, 5, 13, 54)
    
    #-----< id-mr-basicAttConstraintsMatch >-----#
    id_mr_basicAttConstraintsMatch = OID(name=u'id-mr-basicAttConstraintsMatch', mode=MODE_VALUE)
    id_mr_basicAttConstraintsMatch._val = (2, 5, 13, 55)
    
    #-----< id-mr-delegatedNameConstraintsMatch >-----#
    id_mr_delegatedNameConstraintsMatch = OID(name=u'id-mr-delegatedNameConstraintsMatch', mode=MODE_VALUE)
    id_mr_delegatedNameConstraintsMatch._val = (2, 5, 13, 56)
    
    #-----< id-mr-timeSpecMatch >-----#
    id_mr_timeSpecMatch = OID(name=u'id-mr-timeSpecMatch', mode=MODE_VALUE)
    id_mr_timeSpecMatch._val = (2, 5, 13, 57)
    
    #-----< id-mr-attDescriptorMatch >-----#
    id_mr_attDescriptorMatch = OID(name=u'id-mr-attDescriptorMatch', mode=MODE_VALUE)
    id_mr_attDescriptorMatch._val = (2, 5, 13, 58)
    
    #-----< id-mr-acceptableCertPoliciesMatch >-----#
    id_mr_acceptableCertPoliciesMatch = OID(name=u'id-mr-acceptableCertPoliciesMatch', mode=MODE_VALUE)
    id_mr_acceptableCertPoliciesMatch._val = (2, 5, 13, 59)
    
    #-----< id-mr-delegationPathMatch >-----#
    id_mr_delegationPathMatch = OID(name=u'id-mr-delegationPathMatch', mode=MODE_VALUE)
    id_mr_delegationPathMatch._val = (2, 5, 13, 61)
    
    #-----< id-mr-sOAIdentifierMatch >-----#
    id_mr_sOAIdentifierMatch = OID(name=u'id-mr-sOAIdentifierMatch', mode=MODE_VALUE)
    id_mr_sOAIdentifierMatch._val = (2, 5, 13, 66)
    
    #-----< id-mr-extensionPresenceMatch >-----#
    id_mr_extensionPresenceMatch = OID(name=u'id-mr-extensionPresenceMatch', mode=MODE_VALUE)
    id_mr_extensionPresenceMatch._val = (2, 5, 13, 67)
    
    #-----< id-mr-dualStringMatch >-----#
    id_mr_dualStringMatch = OID(name=u'id-mr-dualStringMatch', mode=MODE_VALUE)
    id_mr_dualStringMatch._val = (2, 5, 13, 69)
    
    _all_ = [
        _AttributeCertificate_toBeSigned,
        ___AttributeCertificate_algorithmIdentifier_algorithm_tab,
        __AttributeCertificate_algorithmIdentifier_algorithm,
        ___AttributeCertificate_algorithmIdentifier_parameters_tab,
        __AttributeCertificate_algorithmIdentifier_parameters,
        _AttributeCertificate_algorithmIdentifier,
        _AttributeCertificate_encrypted,
        AttributeCertificate,
        _AttributeCertificateInfo_version,
        _AttributeCertificateInfo_holder,
        _AttributeCertificateInfo_issuer,
        ___AttributeCertificateInfo_signature_algorithm_tab,
        __AttributeCertificateInfo_signature_algorithm,
        ___AttributeCertificateInfo_signature_parameters_tab,
        __AttributeCertificateInfo_signature_parameters,
        _AttributeCertificateInfo_signature,
        _AttributeCertificateInfo_serialNumber,
        _AttributeCertificateInfo_attrCertValidityPeriod,
        ____AttributeCertificateInfo_attributes__item__type_tab,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_0,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType,
        _____AttributeCertificateInfo_attributes__item__type_tab_val_Type_1,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0,
        ___AttributeCertificateInfo_attributes__item__type,
        ____AttributeCertificateInfo_attributes__item__values__item_,
        ___AttributeCertificateInfo_attributes__item__values,
        _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__value,
        ______AttributeCertificateInfo_attributes__item__valuesWithContext__item__contextList__item_,
        _____AttributeCertificateInfo_attributes__item__valuesWithContext__item__contextList,
        ____AttributeCertificateInfo_attributes__item__valuesWithContext__item_,
        ___AttributeCertificateInfo_attributes__item__valuesWithContext,
        __AttributeCertificateInfo_attributes__item_,
        _AttributeCertificateInfo_attributes,
        _AttributeCertificateInfo_issuerUniqueID,
        _AttributeCertificateInfo_extensions,
        AttributeCertificateInfo,
        AttCertVersion,
        _Holder_baseCertificateID,
        _Holder_entityName,
        _Holder_objectDigestInfo,
        Holder,
        _IssuerSerial_issuer,
        _IssuerSerial_serial,
        _IssuerSerial_issuerUID,
        IssuerSerial,
        _ObjectDigestInfo_digestedObjectType,
        _ObjectDigestInfo_otherObjectTypeID,
        ___ObjectDigestInfo_digestAlgorithm_algorithm_tab,
        __ObjectDigestInfo_digestAlgorithm_algorithm,
        ___ObjectDigestInfo_digestAlgorithm_parameters_tab,
        __ObjectDigestInfo_digestAlgorithm_parameters,
        _ObjectDigestInfo_digestAlgorithm,
        _ObjectDigestInfo_objectDigest,
        ObjectDigestInfo,
        _AttCertIssuer_issuerName,
        _AttCertIssuer_baseCertificateID,
        _AttCertIssuer_objectDigestInfo,
        AttCertIssuer,
        _AttCertValidityPeriod_notBeforeTime,
        _AttCertValidityPeriod_notAfterTime,
        AttCertValidityPeriod,
        _AttributeCertificationPath_attributeCertificate,
        __AttributeCertificationPath_acPath__item_,
        _AttributeCertificationPath_acPath,
        AttributeCertificationPath,
        _ACPathData_certificate,
        _ACPathData_attributeCertificate,
        ACPathData,
        PrivilegePolicy,
        role,
        _role_val_Type,
        _RoleSyntax_roleAuthority,
        _RoleSyntax_roleName,
        RoleSyntax,
        xmlPrivilegeInfo,
        _xmlPrivilegeInfo_val_Type,
        permission,
        _permission_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1,
        _DualStringSyntax_operation,
        _DualStringSyntax_object,
        DualStringSyntax,
        dualStringMatch,
        _dualStringMatch_val_AssertionType,
        timeSpecification,
        _timeSpecification_val_ExtnType,
        timeSpecificationMatch,
        _timeSpecificationMatch_val_AssertionType,
        targetingInformation,
        __targetingInformation_val_ExtnType__item_,
        _targetingInformation_val_ExtnType,
        _Targets__item_,
        Targets,
        _Target_targetName,
        _Target_targetGroup,
        _Target_targetCert,
        Target,
        _TargetCert_targetCertificate,
        _TargetCert_targetName,
        _TargetCert_certDigestInfo,
        TargetCert,
        userNotice,
        __userNotice_val_ExtnType__item_,
        _userNotice_val_ExtnType,
        acceptablePrivilegePolicies,
        _acceptablePrivilegePolicies_val_ExtnType,
        _AcceptablePrivilegePoliciesSyntax__item_,
        AcceptablePrivilegePoliciesSyntax,
        singleUse,
        _singleUse_val_ExtnType,
        groupAC,
        _groupAC_val_ExtnType,
        noRevAvail,
        _noRevAvail_val_ExtnType,
        sOAIdentifier,
        _sOAIdentifier_val_ExtnType,
        sOAIdentifierMatch,
        _sOAIdentifierMatch_val_AssertionType,
        attributeDescriptor,
        _attributeDescriptor_val_ExtnType,
        _AttributeDescriptorSyntax_identifier,
        _AttributeDescriptorSyntax_attributeSyntax,
        _AttributeDescriptorSyntax_name,
        _AttributeDescriptorSyntax_description,
        _AttributeDescriptorSyntax_dominationRule,
        AttributeDescriptorSyntax,
        _AttributeIdentifier_tab,
        AttributeIdentifier,
        AttributeIDs,
        AttributeName,
        AttributeDescription,
        _PrivilegePolicyIdentifier_privilegePolicy,
        _PrivilegePolicyIdentifier_privPolSyntax,
        PrivilegePolicyIdentifier,
        attDescriptor,
        _attDescriptor_val_AssertionType,
        roleSpecCertIdentifier,
        _roleSpecCertIdentifier_val_ExtnType,
        _RoleSpecCertIdentifierSyntax__item_,
        RoleSpecCertIdentifierSyntax,
        _RoleSpecCertIdentifier_roleName,
        _RoleSpecCertIdentifier_roleCertIssuer,
        _RoleSpecCertIdentifier_roleCertSerialNumber,
        _RoleSpecCertIdentifier_roleCertLocator,
        RoleSpecCertIdentifier,
        roleSpecCertIdMatch,
        _roleSpecCertIdMatch_val_AssertionType,
        basicAttConstraints,
        _basicAttConstraints_val_ExtnType,
        _BasicAttConstraintsSyntax_authority,
        _BasicAttConstraintsSyntax_pathLenConstraint,
        BasicAttConstraintsSyntax,
        basicAttConstraintsMatch,
        _basicAttConstraintsMatch_val_AssertionType,
        delegatedNameConstraints,
        _delegatedNameConstraints_val_ExtnType,
        delegatedNameConstraintsMatch,
        _delegatedNameConstraintsMatch_val_AssertionType,
        acceptableCertPolicies,
        _acceptableCertPolicies_val_ExtnType,
        _AcceptableCertPoliciesSyntax__item_,
        AcceptableCertPoliciesSyntax,
        CertPolicyId,
        acceptableCertPoliciesMatch,
        _acceptableCertPoliciesMatch_val_AssertionType,
        authorityAttributeIdentifier,
        _authorityAttributeIdentifier_val_ExtnType,
        _AuthorityAttributeIdentifierSyntax__item_,
        AuthorityAttributeIdentifierSyntax,
        AuthAttId,
        authAttIdMatch,
        _authAttIdMatch_val_AssertionType,
        indirectIssuer,
        _indirectIssuer_val_ExtnType,
        issuedOnBehalfOf,
        _issuedOnBehalfOf_val_ExtnType,
        noAssertion,
        _noAssertion_val_ExtnType,
        allowedAttributeAssignments,
        _allowedAttributeAssignments_val_ExtnType,
        ____AllowedAttributeAssignments__item__attributes__item__attributeType,
        ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab,
        _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_0,
        _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type_tab_val_Type_1,
        _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_type,
        ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values__item_,
        _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_values,
        _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__value,
        ________AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList__item_,
        _______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item__contextList,
        ______AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext__item_,
        _____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues_valuesWithContext,
        ____AllowedAttributeAssignments__item__attributes__item__attributeTypeandValues,
        ___AllowedAttributeAssignments__item__attributes__item_,
        __AllowedAttributeAssignments__item__attributes,
        __AllowedAttributeAssignments__item__holderDomain,
        _AllowedAttributeAssignments__item_,
        AllowedAttributeAssignments,
        attributeMappings,
        _attributeMappings_val_ExtnType,
        ___AttributeMappings__item__typeMappings_local,
        ___AttributeMappings__item__typeMappings_remote,
        __AttributeMappings__item__typeMappings,
        ___AttributeMappings__item__typeValueMappings_local,
        ___AttributeMappings__item__typeValueMappings_remote,
        __AttributeMappings__item__typeValueMappings,
        _AttributeMappings__item_,
        AttributeMappings,
        holderNameConstraints,
        _holderNameConstraints_val_ExtnType,
        _HolderNameConstraintsSyntax_permittedSubtrees,
        _HolderNameConstraintsSyntax_excludedSubtrees,
        HolderNameConstraintsSyntax,
        _GeneralSubtrees__item_,
        GeneralSubtrees,
        _GeneralSubtree_base,
        _GeneralSubtree_minimum,
        _GeneralSubtree_maximum,
        GeneralSubtree,
        BaseDistance,
        pmiUser,
        ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0,
        __pmiUser_OptionalAttributes_val_Type_0,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2,
        pmiAA,
        __pmiUser_OptionalAttributes_val_Type_1,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3,
        __pmiUser_OptionalAttributes_val_Type_2,
        pmiSOA,
        __pmiUser_OptionalAttributes_val_Type_0_0,
        __pmiUser_OptionalAttributes_val_Type_2_0,
        attCertCRLDistributionPt,
        pmiDelegationPath,
        __pmiUser_OptionalAttributes_val_Type_0_1,
        privilegePolicy,
        __pmiUser_OptionalAttributes_val_Type_0_2,
        protectedPrivilegePolicy,
        attributeCertificateAttribute,
        _attributeCertificateAttribute_val_Type,
        aACertificate,
        _aACertificate_val_Type,
        attributeDescriptorCertificate,
        _attributeDescriptorCertificate_val_Type,
        attributeCertificateRevocationList,
        _attributeCertificateRevocationList_val_Type,
        attributeAuthorityRevocationList,
        _attributeAuthorityRevocationList_val_Type,
        delegationPath,
        _delegationPath_val_Type,
        _AttCertPath__item_,
        AttCertPath,
        privPolicy,
        _privPolicy_val_Type,
        protPrivPolicy,
        _protPrivPolicy_val_Type,
        xmlPrivPolicy,
        _xmlPrivPolicy_val_Type,
        attributeCertificateExactMatch,
        _attributeCertificateExactMatch_val_AssertionType,
        _AttributeCertificateExactAssertion_serialNumber,
        _AttributeCertificateExactAssertion_issuer,
        AttributeCertificateExactAssertion,
        attributeCertificateMatch,
        _attributeCertificateMatch_val_AssertionType,
        __AttributeCertificateAssertion_holder_baseCertificateID,
        __AttributeCertificateAssertion_holder_holderName,
        _AttributeCertificateAssertion_holder,
        _AttributeCertificateAssertion_issuer,
        _AttributeCertificateAssertion_attCertValidity,
        __AttributeCertificateAssertion_attType__item_,
        _AttributeCertificateAssertion_attType,
        AttributeCertificateAssertion,
        holderIssuerMatch,
        _holderIssuerMatch_val_AssertionType,
        _HolderIssuerAssertion_holder,
        _HolderIssuerAssertion_issuer,
        HolderIssuerAssertion,
        delegationPathMatch,
        _delegationPathMatch_val_AssertionType,
        _DelMatchSyntax_firstIssuer,
        _DelMatchSyntax_lastHolder,
        DelMatchSyntax,
        extensionPresenceMatch,
        _extensionPresenceMatch_val_AssertionType,
        id_oc_pmiUser,
        id_oc_pmiAA,
        id_oc_pmiSOA,
        id_oc_attCertCRLDistributionPts,
        id_oc_privilegePolicy,
        id_oc_pmiDelegationPath,
        id_oc_protectedPrivilegePolicy,
        id_at_attributeCertificate,
        id_at_attributeCertificateRevocationList,
        id_at_aACertificate,
        id_at_attributeDescriptorCertificate,
        id_at_attributeAuthorityRevocationList,
        id_at_privPolicy,
        id_at_role,
        id_at_delegationPath,
        id_at_protPrivPolicy,
        id_at_xMLPrivilegeInfo,
        id_at_xmlPrivPolicy,
        id_at_permission,
        id_ce_authorityAttributeIdentifier,
        id_ce_roleSpecCertIdentifier,
        id_ce_basicAttConstraints,
        id_ce_delegatedNameConstraints,
        id_ce_timeSpecification,
        id_ce_attributeDescriptor,
        id_ce_userNotice,
        id_ce_sOAIdentifier,
        id_ce_acceptableCertPolicies,
        id_ce_targetInformation,
        id_ce_noRevAvail,
        id_ce_acceptablePrivilegePolicies,
        id_ce_indirectIssuer,
        id_ce_noAssertion,
        id_ce_issuedOnBehalfOf,
        id_ce_singleUse,
        id_ce_groupAC,
        id_ce_allowedAttAss,
        id_ce_attributeMappings,
        id_ce_holderNameConstraints,
        id_mr_attributeCertificateMatch,
        id_mr_attributeCertificateExactMatch,
        id_mr_holderIssuerMatch,
        id_mr_authAttIdMatch,
        id_mr_roleSpecCertIdMatch,
        id_mr_basicAttConstraintsMatch,
        id_mr_delegatedNameConstraintsMatch,
        id_mr_timeSpecMatch,
        id_mr_attDescriptorMatch,
        id_mr_acceptableCertPoliciesMatch,
        id_mr_delegationPathMatch,
        id_mr_sOAIdentifierMatch,
        id_mr_extensionPresenceMatch,
        id_mr_dualStringMatch,
    ]

class AuthenticationFramework:

    _name_  = u'AuthenticationFramework'
    _oid_   = [2, 5, 1, 7, 7]
    
    _obj_ = [
        u'ENCRYPTED',
        u'HASH',
        u'ENCRYPTED-HASH',
        u'SIGNATURE',
        u'SIGNED',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'AlgorithmIdentifier',
        u'SupportedAlgorithms',
        u'ALGORITHM',
        u'ecPublicKey',
        u'SupportedCurves',
        u'dummyCurv',
        u'Validity',
        u'SubjectPublicKeyInfo',
        u'Time',
        u'Extensions',
        u'Extension',
        u'der',
        u'ExtensionSet',
        u'EXTENSION',
        u'Certificates',
        u'ForwardCertificationPath',
        u'CrossCertificates',
        u'CertificationPath',
        u'PkiPath',
        u'CertificateList',
        u'CertificateListContent',
        u'pkiUser',
        u'pkiCA',
        u'cRLDistributionPoint',
        u'cRLDistPtNameForm',
        u'deltaCRL',
        u'cpCps',
        u'pkiCertPath',
        u'userCertificate',
        u'cACertificate',
        u'crossCertificatePair',
        u'CertificatePair',
        u'certificateRevocationList',
        u'authorityRevocationList',
        u'deltaRevocationList',
        u'supportedAlgorithms',
        u'SupportedAlgorithm',
        u'certificationPracticeStmt',
        u'InfoSyntax',
        u'POLICY',
        u'HashedPolicyInfo',
        u'Policies',
        u'certificatePolicy',
        u'PolicySyntax',
        u'PolicyID',
        u'pkiPath',
        u'userPassword',
        u'userPwd',
        u'UserPwd',
        u'pwdStartTime',
        u'pwdExpiryTime',
        u'pwdEndTime',
        u'pwdFails',
        u'pwdFailureTime',
        u'pwdGracesUsed',
        u'userPwdHistory',
        u'userPwdRecentlyExpired',
        u'pwdModifyEntryAllowed',
        u'pwdChangeAllowed',
        u'pwdMaxAge',
        u'pwdExpiryAge',
        u'pwdMinLength',
        u'pwdVocabulary',
        u'PwdVocabulary',
        u'pwdAlphabet',
        u'PwdAlphabet',
        u'pwdDictionaries',
        u'pwdExpiryWarning',
        u'pwdGraces',
        u'pwdFailureDuration',
        u'pwdLockoutDuration',
        u'pwdMaxFailures',
        u'pwdMaxTimeInHistory',
        u'pwdMinTimeInHistory',
        u'pwdHistorySlots',
        u'pwdRecentlyExpiredDuration',
        u'pwdEncAlg',
        u'PwdEncAlg',
        u'userPwdMatch',
        u'pwdEncAlgMatch',
        u'userPwdHistoryMatch',
        u'userPwdDescription',
        u'pwdVocabularyDescription',
        u'pwdAlphabetDescription',
        u'pwdEncAlgDescription',
        u'x509Certificate',
        u'x509CertificateList',
        u'x509CertificatePair',
        u'x509SupportedAlgorithm',
        u'id-oc-cRLDistributionPoint',
        u'id-oc-pkiUser',
        u'id-oc-pkiCA',
        u'id-oc-deltaCRL',
        u'id-oc-cpCps',
        u'id-oc-pkiCertPath',
        u'id-nf-cRLDistPtNameForm',
        u'id-at-userPassword',
        u'id-at-userCertificate',
        u'id-at-cAcertificate',
        u'id-at-authorityRevocationList',
        u'id-at-certificateRevocationList',
        u'id-at-crossCertificatePair',
        u'id-at-supportedAlgorithms',
        u'id-at-deltaRevocationList',
        u'id-at-certificationPracticeStmt',
        u'id-at-certificatePolicy',
        u'id-at-pkiPath',
        u'id-at-userPwd',
        u'id-oa-pwdStartTime',
        u'id-oa-pwdExpiryTime',
        u'id-oa-pwdEndTime',
        u'id-oa-pwdFails',
        u'id-oa-pwdFailureTime',
        u'id-oa-pwdGracesUsed',
        u'id-oa-userPwdHistory',
        u'id-oa-userPwdRecentlyExpired',
        u'id-oa-pwdModifyEntryAllowed',
        u'id-oa-pwdChangeAllowed',
        u'id-oa-pwdMaxAge',
        u'id-oa-pwdExpiryAge',
        u'id-oa-pwdMinLength',
        u'id-oa-pwdVocabulary',
        u'id-oa-pwdAlphabet',
        u'id-oa-pwdDictionaries',
        u'id-oa-pwdExpiryWarning',
        u'id-oa-pwdGraces',
        u'id-oa-pwdFailureDuration',
        u'id-oa-pwdLockoutDuration',
        u'id-oa-pwdMaxFailures',
        u'id-oa-pwdMaxTimeInHistory',
        u'id-oa-pwdMinTimeInHistory',
        u'id-oa-pwdHistorySlots',
        u'id-oa-pwdRecentlyExpiredDuration',
        u'id-oa-pwdEncAlg',
        u'id-mr-userPwdMatch',
        u'id-mr-userPwdHistoryMatch',
        u'id-mr-pwdEncAlgMatch',
        u'id-asx-userPwdDescription',
        u'id-asx-pwdVocabularyDescription',
        u'id-asx-pwdAlphabetDescription',
        u'id-asx-pwdEncAlgDescription',
        u'id-lsx-x509Certificate',
        u'id-lsx-x509CertificateList',
        u'id-lsx-x509CertificatePair',
        u'id-lsx-x509SupportedAlgorithm',
        u'id-ecPublicKey',
        ]
    _type_ = [
        u'ENCRYPTED',
        u'HASH',
        u'ENCRYPTED-HASH',
        u'SIGNATURE',
        u'SIGNED',
        u'Certificate',
        u'TBSCertificate',
        u'Version',
        u'CertificateSerialNumber',
        u'AlgorithmIdentifier',
        u'ALGORITHM',
        u'Validity',
        u'SubjectPublicKeyInfo',
        u'Time',
        u'Extensions',
        u'Extension',
        u'EXTENSION',
        u'Certificates',
        u'ForwardCertificationPath',
        u'CrossCertificates',
        u'CertificationPath',
        u'PkiPath',
        u'CertificateList',
        u'CertificateListContent',
        u'CertificatePair',
        u'SupportedAlgorithm',
        u'InfoSyntax',
        u'POLICY',
        u'HashedPolicyInfo',
        u'PolicySyntax',
        u'PolicyID',
        u'UserPwd',
        u'PwdVocabulary',
        u'PwdAlphabet',
        u'PwdEncAlg',
        ]
    _set_ = [
        u'SupportedAlgorithms',
        u'SupportedCurves',
        u'ExtensionSet',
        u'Policies',
        ]
    _val_ = [
        u'ecPublicKey',
        u'dummyCurv',
        u'der',
        u'pkiUser',
        u'pkiCA',
        u'cRLDistributionPoint',
        u'cRLDistPtNameForm',
        u'deltaCRL',
        u'cpCps',
        u'pkiCertPath',
        u'userCertificate',
        u'cACertificate',
        u'crossCertificatePair',
        u'certificateRevocationList',
        u'authorityRevocationList',
        u'deltaRevocationList',
        u'supportedAlgorithms',
        u'certificationPracticeStmt',
        u'certificatePolicy',
        u'pkiPath',
        u'userPassword',
        u'userPwd',
        u'pwdStartTime',
        u'pwdExpiryTime',
        u'pwdEndTime',
        u'pwdFails',
        u'pwdFailureTime',
        u'pwdGracesUsed',
        u'userPwdHistory',
        u'userPwdRecentlyExpired',
        u'pwdModifyEntryAllowed',
        u'pwdChangeAllowed',
        u'pwdMaxAge',
        u'pwdExpiryAge',
        u'pwdMinLength',
        u'pwdVocabulary',
        u'pwdAlphabet',
        u'pwdDictionaries',
        u'pwdExpiryWarning',
        u'pwdGraces',
        u'pwdFailureDuration',
        u'pwdLockoutDuration',
        u'pwdMaxFailures',
        u'pwdMaxTimeInHistory',
        u'pwdMinTimeInHistory',
        u'pwdHistorySlots',
        u'pwdRecentlyExpiredDuration',
        u'pwdEncAlg',
        u'userPwdMatch',
        u'pwdEncAlgMatch',
        u'userPwdHistoryMatch',
        u'userPwdDescription',
        u'pwdVocabularyDescription',
        u'pwdAlphabetDescription',
        u'pwdEncAlgDescription',
        u'x509Certificate',
        u'x509CertificateList',
        u'x509CertificatePair',
        u'x509SupportedAlgorithm',
        u'id-oc-cRLDistributionPoint',
        u'id-oc-pkiUser',
        u'id-oc-pkiCA',
        u'id-oc-deltaCRL',
        u'id-oc-cpCps',
        u'id-oc-pkiCertPath',
        u'id-nf-cRLDistPtNameForm',
        u'id-at-userPassword',
        u'id-at-userCertificate',
        u'id-at-cAcertificate',
        u'id-at-authorityRevocationList',
        u'id-at-certificateRevocationList',
        u'id-at-crossCertificatePair',
        u'id-at-supportedAlgorithms',
        u'id-at-deltaRevocationList',
        u'id-at-certificationPracticeStmt',
        u'id-at-certificatePolicy',
        u'id-at-pkiPath',
        u'id-at-userPwd',
        u'id-oa-pwdStartTime',
        u'id-oa-pwdExpiryTime',
        u'id-oa-pwdEndTime',
        u'id-oa-pwdFails',
        u'id-oa-pwdFailureTime',
        u'id-oa-pwdGracesUsed',
        u'id-oa-userPwdHistory',
        u'id-oa-userPwdRecentlyExpired',
        u'id-oa-pwdModifyEntryAllowed',
        u'id-oa-pwdChangeAllowed',
        u'id-oa-pwdMaxAge',
        u'id-oa-pwdExpiryAge',
        u'id-oa-pwdMinLength',
        u'id-oa-pwdVocabulary',
        u'id-oa-pwdAlphabet',
        u'id-oa-pwdDictionaries',
        u'id-oa-pwdExpiryWarning',
        u'id-oa-pwdGraces',
        u'id-oa-pwdFailureDuration',
        u'id-oa-pwdLockoutDuration',
        u'id-oa-pwdMaxFailures',
        u'id-oa-pwdMaxTimeInHistory',
        u'id-oa-pwdMinTimeInHistory',
        u'id-oa-pwdHistorySlots',
        u'id-oa-pwdRecentlyExpiredDuration',
        u'id-oa-pwdEncAlg',
        u'id-mr-userPwdMatch',
        u'id-mr-userPwdHistoryMatch',
        u'id-mr-pwdEncAlgMatch',
        u'id-asx-userPwdDescription',
        u'id-asx-pwdVocabularyDescription',
        u'id-asx-pwdAlphabetDescription',
        u'id-asx-pwdEncAlgDescription',
        u'id-lsx-x509Certificate',
        u'id-lsx-x509CertificateList',
        u'id-lsx-x509CertificatePair',
        u'id-lsx-x509SupportedAlgorithm',
        u'id-ecPublicKey',
        ]
    _class_ = [
        u'SupportedAlgorithms',
        u'ALGORITHM',
        u'ecPublicKey',
        u'ExtensionSet',
        u'EXTENSION',
        u'pkiUser',
        u'pkiCA',
        u'cRLDistributionPoint',
        u'cRLDistPtNameForm',
        u'deltaCRL',
        u'cpCps',
        u'pkiCertPath',
        u'userCertificate',
        u'cACertificate',
        u'crossCertificatePair',
        u'certificateRevocationList',
        u'authorityRevocationList',
        u'deltaRevocationList',
        u'supportedAlgorithms',
        u'certificationPracticeStmt',
        u'POLICY',
        u'Policies',
        u'certificatePolicy',
        u'pkiPath',
        u'userPassword',
        u'userPwd',
        u'pwdStartTime',
        u'pwdExpiryTime',
        u'pwdEndTime',
        u'pwdFails',
        u'pwdFailureTime',
        u'pwdGracesUsed',
        u'userPwdHistory',
        u'userPwdRecentlyExpired',
        u'pwdModifyEntryAllowed',
        u'pwdChangeAllowed',
        u'pwdMaxAge',
        u'pwdExpiryAge',
        u'pwdMinLength',
        u'pwdVocabulary',
        u'pwdAlphabet',
        u'pwdDictionaries',
        u'pwdExpiryWarning',
        u'pwdGraces',
        u'pwdFailureDuration',
        u'pwdLockoutDuration',
        u'pwdMaxFailures',
        u'pwdMaxTimeInHistory',
        u'pwdMinTimeInHistory',
        u'pwdHistorySlots',
        u'pwdRecentlyExpiredDuration',
        u'pwdEncAlg',
        u'userPwdMatch',
        u'pwdEncAlgMatch',
        u'userPwdHistoryMatch',
        u'userPwdDescription',
        u'pwdVocabularyDescription',
        u'pwdAlphabetDescription',
        u'pwdEncAlgDescription',
        u'x509Certificate',
        u'x509CertificateList',
        u'x509CertificatePair',
        u'x509SupportedAlgorithm',
        ]
    _param_ = [
        u'ENCRYPTED',
        u'HASH',
        u'ENCRYPTED-HASH',
        u'SIGNATURE',
        u'SIGNED',
        u'AlgorithmIdentifier',
        ]
    
    #-----< ENCRYPTED >-----#
    ENCRYPTED = BIT_STR(name=u'ENCRYPTED', mode=MODE_TYPE)
    
    #-----< HASH >-----#
    HASH = SEQ(name=u'HASH', mode=MODE_TYPE)
    _HASH_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __HASH_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___HASH_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___HASH_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __HASH_algorithmIdentifier_algorithm._const_tab = ___HASH_algorithmIdentifier_algorithm_tab
    __HASH_algorithmIdentifier_algorithm._const_tab_at = None
    __HASH_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __HASH_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___HASH_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___HASH_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __HASH_algorithmIdentifier_parameters._const_tab = ___HASH_algorithmIdentifier_parameters_tab
    __HASH_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __HASH_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _HASH_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __HASH_algorithmIdentifier_algorithm),
        (u'parameters', __HASH_algorithmIdentifier_parameters),
        ])
    _HASH_algorithmIdentifier._ext = []
    _HASH_hashValue = BIT_STR(name=u'hashValue', mode=MODE_TYPE)
    HASH._cont = ASN1Dict([
        (u'algorithmIdentifier', _HASH_algorithmIdentifier),
        (u'hashValue', _HASH_hashValue),
        ])
    HASH._ext = []
    
    #-----< ENCRYPTED-HASH >-----#
    ENCRYPTED_HASH = BIT_STR(name=u'ENCRYPTED-HASH', mode=MODE_TYPE)
    
    #-----< SIGNATURE >-----#
    SIGNATURE = SEQ(name=u'SIGNATURE', mode=MODE_TYPE)
    _SIGNATURE_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __SIGNATURE_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___SIGNATURE_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___SIGNATURE_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __SIGNATURE_algorithmIdentifier_algorithm._const_tab = ___SIGNATURE_algorithmIdentifier_algorithm_tab
    __SIGNATURE_algorithmIdentifier_algorithm._const_tab_at = None
    __SIGNATURE_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __SIGNATURE_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___SIGNATURE_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___SIGNATURE_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __SIGNATURE_algorithmIdentifier_parameters._const_tab = ___SIGNATURE_algorithmIdentifier_parameters_tab
    __SIGNATURE_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __SIGNATURE_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _SIGNATURE_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __SIGNATURE_algorithmIdentifier_algorithm),
        (u'parameters', __SIGNATURE_algorithmIdentifier_parameters),
        ])
    _SIGNATURE_algorithmIdentifier._ext = []
    _SIGNATURE_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    SIGNATURE._cont = ASN1Dict([
        (u'algorithmIdentifier', _SIGNATURE_algorithmIdentifier),
        (u'encrypted', _SIGNATURE_encrypted),
        ])
    SIGNATURE._ext = []
    
    #-----< SIGNED >-----#
    SIGNED = SEQ(name=u'SIGNED', mode=MODE_TYPE, param=True)
    
    #-----< Certificate >-----#
    Certificate = SEQ(name=u'Certificate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    _Certificate_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'TBSCertificate')))
    _Certificate_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __Certificate_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___Certificate_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___Certificate_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __Certificate_algorithmIdentifier_algorithm._const_tab = ___Certificate_algorithmIdentifier_algorithm_tab
    __Certificate_algorithmIdentifier_algorithm._const_tab_at = None
    __Certificate_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __Certificate_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___Certificate_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___Certificate_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __Certificate_algorithmIdentifier_parameters._const_tab = ___Certificate_algorithmIdentifier_parameters_tab
    __Certificate_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __Certificate_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _Certificate_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __Certificate_algorithmIdentifier_algorithm),
        (u'parameters', __Certificate_algorithmIdentifier_parameters),
        ])
    _Certificate_algorithmIdentifier._ext = []
    _Certificate_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    Certificate._cont = ASN1Dict([
        (u'toBeSigned', _Certificate_toBeSigned),
        (u'algorithmIdentifier', _Certificate_algorithmIdentifier),
        (u'encrypted', _Certificate_encrypted),
        ])
    Certificate._ext = []
    
    #-----< TBSCertificate >-----#
    TBSCertificate = SEQ(name=u'TBSCertificate', mode=MODE_TYPE)
    _TBSCertificate_version = INT(name=u'version', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Version')), default=0)
    _TBSCertificate_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    _TBSCertificate_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __TBSCertificate_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___TBSCertificate_signature_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___TBSCertificate_signature_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __TBSCertificate_signature_algorithm._const_tab = ___TBSCertificate_signature_algorithm_tab
    __TBSCertificate_signature_algorithm._const_tab_at = None
    __TBSCertificate_signature_algorithm._const_tab_id = u'id'
    __TBSCertificate_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___TBSCertificate_signature_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___TBSCertificate_signature_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __TBSCertificate_signature_parameters._const_tab = ___TBSCertificate_signature_parameters_tab
    __TBSCertificate_signature_parameters._const_tab_at = ('..', u'algorithm')
    __TBSCertificate_signature_parameters._const_tab_id = u'Type'
    _TBSCertificate_signature._cont = ASN1Dict([
        (u'algorithm', __TBSCertificate_signature_algorithm),
        (u'parameters', __TBSCertificate_signature_parameters),
        ])
    _TBSCertificate_signature._ext = []
    _TBSCertificate_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _TBSCertificate_validity = SEQ(name=u'validity', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Validity')))
    _TBSCertificate_subject = CHOICE(name=u'subject', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _TBSCertificate_subjectPublicKeyInfo = SEQ(name=u'subjectPublicKeyInfo', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SubjectPublicKeyInfo')))
    _TBSCertificate_issuerUniqueIdentifier = BIT_STR(name=u'issuerUniqueIdentifier', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UniqueIdentifier')), opt=True)
    _TBSCertificate_subjectUniqueIdentifier = BIT_STR(name=u'subjectUniqueIdentifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UniqueIdentifier')), opt=True, group=0)
    _TBSCertificate_extensions = SEQ_OF(name=u'extensions', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Extensions')), opt=True, group=1)
    TBSCertificate._cont = ASN1Dict([
        (u'version', _TBSCertificate_version),
        (u'serialNumber', _TBSCertificate_serialNumber),
        (u'signature', _TBSCertificate_signature),
        (u'issuer', _TBSCertificate_issuer),
        (u'validity', _TBSCertificate_validity),
        (u'subject', _TBSCertificate_subject),
        (u'subjectPublicKeyInfo', _TBSCertificate_subjectPublicKeyInfo),
        (u'issuerUniqueIdentifier', _TBSCertificate_issuerUniqueIdentifier),
        (u'subjectUniqueIdentifier', _TBSCertificate_subjectUniqueIdentifier),
        (u'extensions', _TBSCertificate_extensions),
        ])
    TBSCertificate._ext = [u'subjectUniqueIdentifier', u'extensions']
    
    #-----< Version >-----#
    Version = INT(name=u'Version', mode=MODE_TYPE)
    Version._cont = ASN1Dict([(u'v1', 0), (u'v2', 1), (u'v3', 2)])
    
    #-----< CertificateSerialNumber >-----#
    CertificateSerialNumber = INT(name=u'CertificateSerialNumber', mode=MODE_TYPE)
    
    #-----< AlgorithmIdentifier >-----#
    AlgorithmIdentifier = SEQ(name=u'AlgorithmIdentifier', mode=MODE_TYPE, param=True)
    
    #-----< SupportedAlgorithms >-----#
    SupportedAlgorithms = CLASS(name=u'SupportedAlgorithms', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    SupportedAlgorithms._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< ALGORITHM >-----#
    ALGORITHM = CLASS(name=u'ALGORITHM', mode=MODE_TYPE)
    _ALGORITHM_Type = OPEN(name=u'Type', mode=MODE_TYPE, opt=True)
    _ALGORITHM_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    ALGORITHM._cont = ASN1Dict([
        (u'Type', _ALGORITHM_Type),
        (u'id', _ALGORITHM_id),
        ])
    
    #-----< ecPublicKey >-----#
    ecPublicKey = CLASS(name=u'ecPublicKey', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _ecPublicKey_val_Type = OID(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SupportedCurves')))
    ecPublicKey._val = dict([(u'Type', _ecPublicKey_val_Type), (u'id', (1, 2, 840, 10045, 2, 1))])
    
    #-----< SupportedCurves >-----#
    SupportedCurves = OID(name=u'SupportedCurves', mode=MODE_SET)
    SupportedCurves._val = ASN1Set(rv=[(2, 5, 5)], rr=[], ev=[], er=[])
    
    #-----< dummyCurv >-----#
    dummyCurv = OID(name=u'dummyCurv', mode=MODE_VALUE)
    dummyCurv._val = (2, 5, 5)
    
    #-----< Validity >-----#
    Validity = SEQ(name=u'Validity', mode=MODE_TYPE)
    _Validity_notBefore = CHOICE(name=u'notBefore', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')))
    _Validity_notAfter = CHOICE(name=u'notAfter', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')))
    Validity._cont = ASN1Dict([
        (u'notBefore', _Validity_notBefore),
        (u'notAfter', _Validity_notAfter),
        ])
    Validity._ext = []
    
    #-----< SubjectPublicKeyInfo >-----#
    SubjectPublicKeyInfo = SEQ(name=u'SubjectPublicKeyInfo', mode=MODE_TYPE)
    _SubjectPublicKeyInfo_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __SubjectPublicKeyInfo_algorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___SubjectPublicKeyInfo_algorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___SubjectPublicKeyInfo_algorithm_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab = ___SubjectPublicKeyInfo_algorithm_algorithm_tab
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab_at = None
    __SubjectPublicKeyInfo_algorithm_algorithm._const_tab_id = u'id'
    __SubjectPublicKeyInfo_algorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___SubjectPublicKeyInfo_algorithm_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___SubjectPublicKeyInfo_algorithm_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab = ___SubjectPublicKeyInfo_algorithm_parameters_tab
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab_at = ('..', u'algorithm')
    __SubjectPublicKeyInfo_algorithm_parameters._const_tab_id = u'Type'
    _SubjectPublicKeyInfo_algorithm._cont = ASN1Dict([
        (u'algorithm', __SubjectPublicKeyInfo_algorithm_algorithm),
        (u'parameters', __SubjectPublicKeyInfo_algorithm_parameters),
        ])
    _SubjectPublicKeyInfo_algorithm._ext = []
    _SubjectPublicKeyInfo_subjectPublicKey = BIT_STR(name=u'subjectPublicKey', mode=MODE_TYPE)
    SubjectPublicKeyInfo._cont = ASN1Dict([
        (u'algorithm', _SubjectPublicKeyInfo_algorithm),
        (u'subjectPublicKey', _SubjectPublicKeyInfo_subjectPublicKey),
        ])
    SubjectPublicKeyInfo._ext = []
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalizedTime = TIME_GEN(name=u'generalizedTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalizedTime', _Time_generalizedTime),
        ])
    Time._ext = None
    
    #-----< Extensions >-----#
    Extensions = SEQ_OF(name=u'Extensions', mode=MODE_TYPE)
    _Extensions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Extension')))
    Extensions._cont = _Extensions__item_
    
    #-----< Extension >-----#
    Extension = SEQ(name=u'Extension', mode=MODE_TYPE)
    _Extension_extnId = OID(name=u'extnId', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'EXTENSION'), [u'id']))
    __Extension_extnId_tab = CLASS(name='_tab_EXTENSION', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    __Extension_extnId_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _Extension_extnId._const_tab = __Extension_extnId_tab
    _Extension_extnId._const_tab_at = None
    _Extension_extnId._const_tab_id = u'id'
    _Extension_critical = BOOL(name=u'critical', mode=MODE_TYPE, default=False)
    _Extension_extnValue = OCT_STR(name=u'extnValue', mode=MODE_TYPE)
    _Extension_extnValue._const_cont_enc = (2, 1, 2, 1)
    Extension._cont = ASN1Dict([
        (u'extnId', _Extension_extnId),
        (u'critical', _Extension_critical),
        (u'extnValue', _Extension_extnValue),
        ])
    Extension._ext = []
    
    #-----< der >-----#
    der = OID(name=u'der', mode=MODE_VALUE)
    der._val = (2, 1, 2, 1)
    
    #-----< ExtensionSet >-----#
    ExtensionSet = CLASS(name=u'ExtensionSet', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    ExtensionSet._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< EXTENSION >-----#
    EXTENSION = CLASS(name=u'EXTENSION', mode=MODE_TYPE)
    _EXTENSION_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _EXTENSION_ExtnType = OPEN(name=u'ExtnType', mode=MODE_TYPE)
    EXTENSION._cont = ASN1Dict([
        (u'id', _EXTENSION_id),
        (u'ExtnType', _EXTENSION_ExtnType),
        ])
    
    #-----< Certificates >-----#
    Certificates = SEQ(name=u'Certificates', mode=MODE_TYPE)
    _Certificates_userCertificate = SEQ(name=u'userCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    _Certificates_certificationPath = SEQ_OF(name=u'certificationPath', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ForwardCertificationPath')), opt=True)
    Certificates._cont = ASN1Dict([
        (u'userCertificate', _Certificates_userCertificate),
        (u'certificationPath', _Certificates_certificationPath),
        ])
    Certificates._ext = []
    
    #-----< ForwardCertificationPath >-----#
    ForwardCertificationPath = SEQ_OF(name=u'ForwardCertificationPath', mode=MODE_TYPE)
    _ForwardCertificationPath__item_ = SET_OF(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CrossCertificates')))
    ForwardCertificationPath._cont = _ForwardCertificationPath__item_
    ForwardCertificationPath._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< CrossCertificates >-----#
    CrossCertificates = SET_OF(name=u'CrossCertificates', mode=MODE_TYPE)
    _CrossCertificates__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    CrossCertificates._cont = _CrossCertificates__item_
    CrossCertificates._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< CertificationPath >-----#
    CertificationPath = SEQ(name=u'CertificationPath', mode=MODE_TYPE)
    _CertificationPath_userCertificate = SEQ(name=u'userCertificate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    _CertificationPath_theCACertificates = SEQ_OF(name=u'theCACertificates', mode=MODE_TYPE, opt=True)
    __CertificationPath_theCACertificates__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificatePair')))
    _CertificationPath_theCACertificates._cont = __CertificationPath_theCACertificates__item_
    _CertificationPath_theCACertificates._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    CertificationPath._cont = ASN1Dict([
        (u'userCertificate', _CertificationPath_userCertificate),
        (u'theCACertificates', _CertificationPath_theCACertificates),
        ])
    CertificationPath._ext = []
    
    #-----< PkiPath >-----#
    PkiPath = SEQ_OF(name=u'PkiPath', mode=MODE_TYPE)
    _PkiPath__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    PkiPath._cont = _PkiPath__item_
    PkiPath._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< CertificateList >-----#
    CertificateList = SEQ(name=u'CertificateList', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    _CertificateList_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateListContent')))
    _CertificateList_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __CertificateList_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___CertificateList_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___CertificateList_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __CertificateList_algorithmIdentifier_algorithm._const_tab = ___CertificateList_algorithmIdentifier_algorithm_tab
    __CertificateList_algorithmIdentifier_algorithm._const_tab_at = None
    __CertificateList_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __CertificateList_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___CertificateList_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___CertificateList_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __CertificateList_algorithmIdentifier_parameters._const_tab = ___CertificateList_algorithmIdentifier_parameters_tab
    __CertificateList_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __CertificateList_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _CertificateList_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __CertificateList_algorithmIdentifier_algorithm),
        (u'parameters', __CertificateList_algorithmIdentifier_parameters),
        ])
    _CertificateList_algorithmIdentifier._ext = []
    _CertificateList_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    CertificateList._cont = ASN1Dict([
        (u'toBeSigned', _CertificateList_toBeSigned),
        (u'algorithmIdentifier', _CertificateList_algorithmIdentifier),
        (u'encrypted', _CertificateList_encrypted),
        ])
    CertificateList._ext = []
    
    #-----< CertificateListContent >-----#
    CertificateListContent = SEQ(name=u'CertificateListContent', mode=MODE_TYPE)
    _CertificateListContent_version = INT(name=u'version', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Version')), opt=True)
    _CertificateListContent_signature = SEQ(name=u'signature', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __CertificateListContent_signature_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___CertificateListContent_signature_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___CertificateListContent_signature_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __CertificateListContent_signature_algorithm._const_tab = ___CertificateListContent_signature_algorithm_tab
    __CertificateListContent_signature_algorithm._const_tab_at = None
    __CertificateListContent_signature_algorithm._const_tab_id = u'id'
    __CertificateListContent_signature_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___CertificateListContent_signature_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___CertificateListContent_signature_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __CertificateListContent_signature_parameters._const_tab = ___CertificateListContent_signature_parameters_tab
    __CertificateListContent_signature_parameters._const_tab_at = ('..', u'algorithm')
    __CertificateListContent_signature_parameters._const_tab_id = u'Type'
    _CertificateListContent_signature._cont = ASN1Dict([
        (u'algorithm', __CertificateListContent_signature_algorithm),
        (u'parameters', __CertificateListContent_signature_parameters),
        ])
    _CertificateListContent_signature._ext = []
    _CertificateListContent_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _CertificateListContent_thisUpdate = CHOICE(name=u'thisUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')))
    _CertificateListContent_nextUpdate = CHOICE(name=u'nextUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')), opt=True)
    _CertificateListContent_revokedCertificates = SEQ_OF(name=u'revokedCertificates', mode=MODE_TYPE, opt=True)
    __CertificateListContent_revokedCertificates__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ___CertificateListContent_revokedCertificates__item__serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    ___CertificateListContent_revokedCertificates__item__revocationDate = CHOICE(name=u'revocationDate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')))
    ___CertificateListContent_revokedCertificates__item__crlEntryExtensions = SEQ_OF(name=u'crlEntryExtensions', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Extensions')), opt=True)
    __CertificateListContent_revokedCertificates__item_._cont = ASN1Dict([
        (u'serialNumber', ___CertificateListContent_revokedCertificates__item__serialNumber),
        (u'revocationDate', ___CertificateListContent_revokedCertificates__item__revocationDate),
        (u'crlEntryExtensions', ___CertificateListContent_revokedCertificates__item__crlEntryExtensions),
        ])
    __CertificateListContent_revokedCertificates__item_._ext = []
    _CertificateListContent_revokedCertificates._cont = __CertificateListContent_revokedCertificates__item_
    _CertificateListContent_crlExtensions = SEQ_OF(name=u'crlExtensions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Extensions')), opt=True)
    CertificateListContent._cont = ASN1Dict([
        (u'version', _CertificateListContent_version),
        (u'signature', _CertificateListContent_signature),
        (u'issuer', _CertificateListContent_issuer),
        (u'thisUpdate', _CertificateListContent_thisUpdate),
        (u'nextUpdate', _CertificateListContent_nextUpdate),
        (u'revokedCertificates', _CertificateListContent_revokedCertificates),
        (u'crlExtensions', _CertificateListContent_crlExtensions),
        ])
    CertificateListContent._ext = [u'crlExtensions']
    
    #-----< pkiUser >-----#
    pkiUser = CLASS(name=u'pkiUser', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE)
    __pmiUser_OptionalAttributes_val_Type_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateExactAssertion')))
    pkiUser._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 1)), (u'ldapName', [u'certificateExactMatch']), (u'ldapDesc', u'X.509 Certificate Exact Match'), (u'id', (2, 5, 13, 34))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8)), (u'ldapName', [u'userCertificate']), (u'ldapDesc', u'X.509 user certificate'), (u'id', (2, 5, 4, 36))])], rr=[], ev=None, er=[])), (u'ldapName', [u'pkiUser']), (u'ldapDesc', u'X.509 PKI User'), (u'id', (2, 5, 6, 21))])
    
    #-----< pkiCA >-----#
    pkiCA = CLASS(name=u'pkiCA', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListExactAssertion')))
    __pmiUser_OptionalAttributes_val_Type_2 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    __pmiUser_OptionalAttributes_val_Type_3 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificatePair')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePairExactAssertion')))
    pkiCA._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 1)), (u'ldapName', [u'certificateExactMatch']), (u'ldapDesc', u'X.509 Certificate Exact Match'), (u'id', (2, 5, 13, 34))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8)), (u'ldapName', [u'cACertificate']), (u'ldapDesc', u'X.509 CA certificate'), (u'id', (2, 5, 4, 37))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 certificate revocation list'), (u'id', (2, 5, 4, 39))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_2), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'authorityRevocationList']), (u'ldapDesc', u'X.509 authority revocation list'), (u'id', (2, 5, 4, 38))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_3), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 3)), (u'ldapName', [u'certificatePairExactMatch']), (u'ldapDesc', u'X.509 Certificate Pair Exact Match'), (u'id', (2, 5, 13, 36))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 10)), (u'ldapName', [u'crossCertificatePair']), (u'ldapDesc', u'X.509 cross certificate pair'), (u'id', (2, 5, 4, 40))])], rr=[], ev=None, er=[])), (u'ldapName', [u'pkiCA']), (u'ldapDesc', u'X.509 PKI Certificate Authority'), (u'id', (2, 5, 6, 22))])
    
    #-----< cRLDistributionPoint >-----#
    cRLDistributionPoint = CLASS(name=u'cRLDistributionPoint', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3 = CHOICE(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    _____pmiUser_Superclasses_MandatoryAttributes_derivation_substrings_match_val_AssertionType = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'SubstringAssertion')))
    ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    __pmiUser_OptionalAttributes_val_Type_0_0 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    cRLDistributionPoint._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'structural'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'derivation', dict([(u'Type', ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'caseIgnoreMatch']), (u'id', (2, 5, 13, 2))])), (u'substrings-match', dict([(u'AssertionType', _____pmiUser_Superclasses_MandatoryAttributes_derivation_substrings_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 58)), (u'ldapName', [u'caseIgnoreSubstringsMatch']), (u'id', (2, 5, 13, 4))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'name']), (u'id', (2, 5, 4, 41))])), (u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'cn', u'commonName']), (u'id', (2, 5, 4, 3))])], rr=[], ev=None, er=[])), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 certificate revocation list'), (u'id', (2, 5, 4, 39))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'authorityRevocationList']), (u'ldapDesc', u'X.509 authority revocation list'), (u'id', (2, 5, 4, 38))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_2), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'deltaRevocationList']), (u'ldapDesc', u'X.509 delta revocation list'), (u'id', (2, 5, 4, 53))])], rr=[], ev=None, er=[])), (u'ldapName', [u'cRLDistributionPoint']), (u'ldapDesc', u'X.509 CRL distribution point'), (u'id', (2, 5, 6, 19))])
    
    #-----< cRLDistPtNameForm >-----#
    cRLDistPtNameForm = CLASS(name=u'cRLDistPtNameForm', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'NAME-FORM')))
    __cRLDistPtNameForm_MandatoryAttributes_val_Type_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    cRLDistPtNameForm._val = dict([(u'namedObjectClass', dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'structural'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'derivation', dict([(u'Type', ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'caseIgnoreMatch']), (u'id', (2, 5, 13, 2))])), (u'substrings-match', dict([(u'AssertionType', _____pmiUser_Superclasses_MandatoryAttributes_derivation_substrings_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 58)), (u'ldapName', [u'caseIgnoreSubstringsMatch']), (u'id', (2, 5, 13, 4))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'name']), (u'id', (2, 5, 4, 41))])), (u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'cn', u'commonName']), (u'id', (2, 5, 4, 3))])], rr=[], ev=None, er=[])), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 certificate revocation list'), (u'id', (2, 5, 4, 39))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'authorityRevocationList']), (u'ldapDesc', u'X.509 authority revocation list'), (u'id', (2, 5, 4, 38))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_2), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'deltaRevocationList']), (u'ldapDesc', u'X.509 delta revocation list'), (u'id', (2, 5, 4, 53))])], rr=[], ev=None, er=[])), (u'ldapName', [u'cRLDistributionPoint']), (u'ldapDesc', u'X.509 CRL distribution point'), (u'id', (2, 5, 6, 19))])), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'derivation', dict([(u'Type', ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'caseIgnoreMatch']), (u'id', (2, 5, 13, 2))])), (u'substrings-match', dict([(u'AssertionType', _____pmiUser_Superclasses_MandatoryAttributes_derivation_substrings_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 58)), (u'ldapName', [u'caseIgnoreSubstringsMatch']), (u'id', (2, 5, 13, 4))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'name']), (u'id', (2, 5, 4, 41))])), (u'Type', __cRLDistPtNameForm_MandatoryAttributes_val_Type_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'cn', u'commonName']), (u'id', (2, 5, 4, 3))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 15, 14))])
    
    #-----< deltaCRL >-----#
    deltaCRL = CLASS(name=u'deltaCRL', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    deltaCRL._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'deltaRevocationList']), (u'ldapDesc', u'X.509 delta revocation list'), (u'id', (2, 5, 4, 53))])], rr=[], ev=None, er=[])), (u'ldapName', [u'deltaCRL']), (u'ldapDesc', u'X.509 delta CRL'), (u'id', (2, 5, 6, 23))])
    
    #-----< cpCps >-----#
    cpCps = CLASS(name=u'cpCps', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_0_1 = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicySyntax')))
    __pmiUser_OptionalAttributes_val_Type_1_0 = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'InfoSyntax')))
    cpCps._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_1), (u'id', (2, 5, 4, 69))]), dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_1_0), (u'id', (2, 5, 4, 68))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 30))])
    
    #-----< pkiCertPath >-----#
    pkiCertPath = CLASS(name=u'pkiCertPath', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'OBJECT-CLASS')))
    __pmiUser_OptionalAttributes_val_Type_0_2 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PkiPath')))
    pkiCertPath._val = dict([(u'Superclasses', ASN1Set(rv=[dict([(u'kind', u'abstract'), (u'MandatoryAttributes', ASN1Set(rv=[dict([(u'Type', ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))])], rr=[], ev=None, er=[])), (u'ldapName', [u'top']), (u'id', (2, 5, 6, 0))])], rr=[], ev=None, er=[])), (u'kind', u'auxiliary'), (u'OptionalAttributes', ASN1Set(rv=[dict([(u'Type', __pmiUser_OptionalAttributes_val_Type_0_2), (u'id', (2, 5, 4, 70))])], rr=[], ev=None, er=[])), (u'id', (2, 5, 6, 31))])
    
    #-----< userCertificate >-----#
    userCertificate = CLASS(name=u'userCertificate', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _userCertificate_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    userCertificate._val = dict([(u'Type', _userCertificate_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 1)), (u'ldapName', [u'certificateExactMatch']), (u'ldapDesc', u'X.509 Certificate Exact Match'), (u'id', (2, 5, 13, 34))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8)), (u'ldapName', [u'userCertificate']), (u'ldapDesc', u'X.509 user certificate'), (u'id', (2, 5, 4, 36))])
    
    #-----< cACertificate >-----#
    cACertificate = CLASS(name=u'cACertificate', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _cACertificate_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    cACertificate._val = dict([(u'Type', _cACertificate_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 1)), (u'ldapName', [u'certificateExactMatch']), (u'ldapDesc', u'X.509 Certificate Exact Match'), (u'id', (2, 5, 13, 34))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8)), (u'ldapName', [u'cACertificate']), (u'ldapDesc', u'X.509 CA certificate'), (u'id', (2, 5, 4, 37))])
    
    #-----< crossCertificatePair >-----#
    crossCertificatePair = CLASS(name=u'crossCertificatePair', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _crossCertificatePair_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificatePair')))
    crossCertificatePair._val = dict([(u'Type', _crossCertificatePair_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 3)), (u'ldapName', [u'certificatePairExactMatch']), (u'ldapDesc', u'X.509 Certificate Pair Exact Match'), (u'id', (2, 5, 13, 36))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 10)), (u'ldapName', [u'crossCertificatePair']), (u'ldapDesc', u'X.509 cross certificate pair'), (u'id', (2, 5, 4, 40))])
    
    #-----< CertificatePair >-----#
    CertificatePair = SEQ(name=u'CertificatePair', mode=MODE_TYPE)
    _CertificatePair_issuedToThisCA = SEQ(name=u'issuedToThisCA', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')), opt=True)
    _CertificatePair_issuedByThisCA = SEQ(name=u'issuedByThisCA', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')), opt=True)
    CertificatePair._cont = ASN1Dict([
        (u'issuedToThisCA', _CertificatePair_issuedToThisCA),
        (u'issuedByThisCA', _CertificatePair_issuedByThisCA),
        ])
    CertificatePair._ext = []
    
    #-----< certificateRevocationList >-----#
    certificateRevocationList = CLASS(name=u'certificateRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _certificateRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    certificateRevocationList._val = dict([(u'Type', _certificateRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'certificateRevocationList']), (u'ldapDesc', u'X.509 certificate revocation list'), (u'id', (2, 5, 4, 39))])
    
    #-----< authorityRevocationList >-----#
    authorityRevocationList = CLASS(name=u'authorityRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _authorityRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    authorityRevocationList._val = dict([(u'Type', _authorityRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'authorityRevocationList']), (u'ldapDesc', u'X.509 authority revocation list'), (u'id', (2, 5, 4, 38))])
    
    #-----< deltaRevocationList >-----#
    deltaRevocationList = CLASS(name=u'deltaRevocationList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _deltaRevocationList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    deltaRevocationList._val = dict([(u'Type', _deltaRevocationList_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)), (u'ldapName', [u'deltaRevocationList']), (u'ldapDesc', u'X.509 delta revocation list'), (u'id', (2, 5, 4, 53))])
    
    #-----< supportedAlgorithms >-----#
    supportedAlgorithms = CLASS(name=u'supportedAlgorithms', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _supportedAlgorithms_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SupportedAlgorithm')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ________AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm._const_tab = ________AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab
    _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm._const_tab_at = None
    _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm._const_tab_id = u'id'
    _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ________AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ________AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters._const_tab = ________AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters_tab
    _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters._const_tab_at = ('..', u'algorithm')
    _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters._const_tab_id = u'Type'
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4._cont = ASN1Dict([
        (u'algorithm', _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm),
        (u'parameters', _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters),
        ])
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4._ext = []
    supportedAlgorithms._val = dict([(u'Type', _supportedAlgorithms_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 7)), (u'ldapName', [u'algorithmIdentifierMatch']), (u'ldapDesc', u'X.509 Algorithm Identifier Match'), (u'id', (2, 5, 13, 40))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 49)), (u'ldapName', [u'supportedAlgorithms']), (u'ldapDesc', u'X.509 support algorithms'), (u'id', (2, 5, 4, 52))])
    
    #-----< SupportedAlgorithm >-----#
    SupportedAlgorithm = SEQ(name=u'SupportedAlgorithm', mode=MODE_TYPE)
    _SupportedAlgorithm_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __SupportedAlgorithm_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___SupportedAlgorithm_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___SupportedAlgorithm_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __SupportedAlgorithm_algorithmIdentifier_algorithm._const_tab = ___SupportedAlgorithm_algorithmIdentifier_algorithm_tab
    __SupportedAlgorithm_algorithmIdentifier_algorithm._const_tab_at = None
    __SupportedAlgorithm_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __SupportedAlgorithm_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___SupportedAlgorithm_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___SupportedAlgorithm_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __SupportedAlgorithm_algorithmIdentifier_parameters._const_tab = ___SupportedAlgorithm_algorithmIdentifier_parameters_tab
    __SupportedAlgorithm_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __SupportedAlgorithm_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _SupportedAlgorithm_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __SupportedAlgorithm_algorithmIdentifier_algorithm),
        (u'parameters', __SupportedAlgorithm_algorithmIdentifier_parameters),
        ])
    _SupportedAlgorithm_algorithmIdentifier._ext = []
    _SupportedAlgorithm_intendedUsage = BIT_STR(name=u'intendedUsage', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'KeyUsage')), opt=True)
    _SupportedAlgorithm_intendedCertificatePolicies = SEQ_OF(name=u'intendedCertificatePolicies', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificatePoliciesSyntax')), opt=True)
    SupportedAlgorithm._cont = ASN1Dict([
        (u'algorithmIdentifier', _SupportedAlgorithm_algorithmIdentifier),
        (u'intendedUsage', _SupportedAlgorithm_intendedUsage),
        (u'intendedCertificatePolicies', _SupportedAlgorithm_intendedCertificatePolicies),
        ])
    SupportedAlgorithm._ext = []
    
    #-----< certificationPracticeStmt >-----#
    certificationPracticeStmt = CLASS(name=u'certificationPracticeStmt', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _certificationPracticeStmt_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'InfoSyntax')))
    certificationPracticeStmt._val = dict([(u'Type', _certificationPracticeStmt_val_Type), (u'id', (2, 5, 4, 68))])
    
    #-----< InfoSyntax >-----#
    InfoSyntax = CHOICE(name=u'InfoSyntax', mode=MODE_TYPE)
    _InfoSyntax_content = CHOICE(name=u'content', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    _InfoSyntax_pointer = SEQ(name=u'pointer', mode=MODE_TYPE)
    __InfoSyntax_pointer_name = SEQ_OF(name=u'name', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    __InfoSyntax_pointer_hash = SEQ(name=u'hash', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'HASH')), opt=True)
    ___InfoSyntax_pointer_hash_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm._const_tab = _____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab
    ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm._const_tab_at = None
    ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____InfoSyntax_pointer_hash_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____InfoSyntax_pointer_hash_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters._const_tab = _____InfoSyntax_pointer_hash_algorithmIdentifier_parameters_tab
    ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___InfoSyntax_pointer_hash_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm),
        (u'parameters', ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters),
        ])
    ___InfoSyntax_pointer_hash_algorithmIdentifier._ext = []
    ___InfoSyntax_pointer_hash_hashValue = BIT_STR(name=u'hashValue', mode=MODE_TYPE)
    __InfoSyntax_pointer_hash._cont = ASN1Dict([
        (u'algorithmIdentifier', ___InfoSyntax_pointer_hash_algorithmIdentifier),
        (u'hashValue', ___InfoSyntax_pointer_hash_hashValue),
        ])
    __InfoSyntax_pointer_hash._ext = []
    _InfoSyntax_pointer._cont = ASN1Dict([
        (u'name', __InfoSyntax_pointer_name),
        (u'hash', __InfoSyntax_pointer_hash),
        ])
    _InfoSyntax_pointer._ext = []
    InfoSyntax._cont = ASN1Dict([
        (u'content', _InfoSyntax_content),
        (u'pointer', _InfoSyntax_pointer),
        ])
    InfoSyntax._ext = []
    
    #-----< POLICY >-----#
    POLICY = CLASS(name=u'POLICY', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< HashedPolicyInfo >-----#
    HashedPolicyInfo = OPEN(name=u'HashedPolicyInfo', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'POLICY'), [u'Type']))
    _HashedPolicyInfo_tab = CLASS(name='_tab_POLICY', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'POLICY')))
    _HashedPolicyInfo_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    HashedPolicyInfo._const_tab = _HashedPolicyInfo_tab
    HashedPolicyInfo._const_tab_at = None
    HashedPolicyInfo._const_tab_id = u'Type'
    
    #-----< Policies >-----#
    Policies = CLASS(name=u'Policies', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'POLICY')))
    Policies._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< certificatePolicy >-----#
    certificatePolicy = CLASS(name=u'certificatePolicy', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _certificatePolicy_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicySyntax')))
    certificatePolicy._val = dict([(u'Type', _certificatePolicy_val_Type), (u'id', (2, 5, 4, 69))])
    
    #-----< PolicySyntax >-----#
    PolicySyntax = SEQ(name=u'PolicySyntax', mode=MODE_TYPE)
    _PolicySyntax_policyIdentifier = OID(name=u'policyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicyID')))
    _PolicySyntax_policySyntax = CHOICE(name=u'policySyntax', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'InfoSyntax')))
    PolicySyntax._cont = ASN1Dict([
        (u'policyIdentifier', _PolicySyntax_policyIdentifier),
        (u'policySyntax', _PolicySyntax_policySyntax),
        ])
    PolicySyntax._ext = []
    
    #-----< PolicyID >-----#
    PolicyID = OID(name=u'PolicyID', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertPolicyId')))
    
    #-----< pkiPath >-----#
    pkiPath = CLASS(name=u'pkiPath', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pkiPath_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PkiPath')))
    pkiPath._val = dict([(u'Type', _pkiPath_val_Type), (u'id', (2, 5, 4, 70))])
    
    #-----< userPassword >-----#
    userPassword = CLASS(name=u'userPassword', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _userPassword_val_Type = OCT_STR(name=u'Type', mode=MODE_TYPE)
    _userPassword_val_Type._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_5 = OCT_STR(name=u'AssertionType', mode=MODE_TYPE)
    userPassword._val = dict([(u'Type', _userPassword_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_5), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 40)), (u'ldapName', [u'octetStringMatch']), (u'id', (2, 5, 13, 17))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 40)), (u'ldapName', [u'userPassword']), (u'id', (2, 5, 4, 35))])
    
    #-----< userPwd >-----#
    userPwd = CLASS(name=u'userPwd', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _userPwd_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_6 = CHOICE(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    userPwd._val = dict([(u'Type', _userPwd_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_6), (u'ldapSyntax', (2, 5, 40, 0)), (u'ldapName', [u'userPwdMatch']), (u'id', (2, 5, 13, 71))])), (u'single-valued', True), (u'ldapSyntax', (2, 5, 40, 0)), (u'ldapName', [u'userPwd']), (u'id', (2, 5, 4, 85))])
    
    #-----< UserPwd >-----#
    UserPwd = CHOICE(name=u'UserPwd', mode=MODE_TYPE)
    _UserPwd_clear = STR_UTF8(name=u'clear', mode=MODE_TYPE)
    _UserPwd_encrypted = SEQ(name=u'encrypted', mode=MODE_TYPE)
    __UserPwd_encrypted_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___UserPwd_encrypted_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____UserPwd_encrypted_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____UserPwd_encrypted_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UserPwd_encrypted_algorithmIdentifier_algorithm._const_tab = ____UserPwd_encrypted_algorithmIdentifier_algorithm_tab
    ___UserPwd_encrypted_algorithmIdentifier_algorithm._const_tab_at = None
    ___UserPwd_encrypted_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___UserPwd_encrypted_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____UserPwd_encrypted_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____UserPwd_encrypted_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___UserPwd_encrypted_algorithmIdentifier_parameters._const_tab = ____UserPwd_encrypted_algorithmIdentifier_parameters_tab
    ___UserPwd_encrypted_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___UserPwd_encrypted_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __UserPwd_encrypted_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___UserPwd_encrypted_algorithmIdentifier_algorithm),
        (u'parameters', ___UserPwd_encrypted_algorithmIdentifier_parameters),
        ])
    __UserPwd_encrypted_algorithmIdentifier._ext = []
    __UserPwd_encrypted_encryptedString = OCT_STR(name=u'encryptedString', mode=MODE_TYPE)
    _UserPwd_encrypted._cont = ASN1Dict([
        (u'algorithmIdentifier', __UserPwd_encrypted_algorithmIdentifier),
        (u'encryptedString', __UserPwd_encrypted_encryptedString),
        ])
    _UserPwd_encrypted._ext = []
    UserPwd._cont = ASN1Dict([
        (u'clear', _UserPwd_clear),
        (u'encrypted', _UserPwd_encrypted),
        ])
    UserPwd._ext = []
    
    #-----< pwdStartTime >-----#
    pwdStartTime = CLASS(name=u'pwdStartTime', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdStartTime_val_Type = TIME_GEN(name=u'Type', mode=MODE_TYPE)
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_7 = TIME_GEN(name=u'AssertionType', mode=MODE_TYPE)
    __pwdStartTime_ordering_match_val_AssertionType = TIME_GEN(name=u'AssertionType', mode=MODE_TYPE)
    pwdStartTime._val = dict([(u'Type', _pwdStartTime_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_7), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'generalizedTimeMatch']), (u'id', (2, 5, 13, 27))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'generalizedTimeOrderingMatch']), (u'id', (2, 5, 13, 28))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'pwdStartTime']), (u'id', (2, 5, 18, 22))])
    
    #-----< pwdExpiryTime >-----#
    pwdExpiryTime = CLASS(name=u'pwdExpiryTime', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdExpiryTime_val_Type = TIME_GEN(name=u'Type', mode=MODE_TYPE)
    pwdExpiryTime._val = dict([(u'Type', _pwdExpiryTime_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_7), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'generalizedTimeMatch']), (u'id', (2, 5, 13, 27))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'generalizedTimeOrderingMatch']), (u'id', (2, 5, 13, 28))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'pwdExpiryTime']), (u'id', (2, 5, 18, 23))])
    
    #-----< pwdEndTime >-----#
    pwdEndTime = CLASS(name=u'pwdEndTime', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdEndTime_val_Type = TIME_GEN(name=u'Type', mode=MODE_TYPE)
    pwdEndTime._val = dict([(u'Type', _pwdEndTime_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_7), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'generalizedTimeMatch']), (u'id', (2, 5, 13, 27))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'generalizedTimeOrderingMatch']), (u'id', (2, 5, 13, 28))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'pwdEndTime']), (u'id', (2, 5, 18, 24))])
    
    #-----< pwdFails >-----#
    pwdFails = CLASS(name=u'pwdFails', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdFails_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdFails_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8 = INT(name=u'AssertionType', mode=MODE_TYPE)
    __pwdStartTime_ordering_match_val_AssertionType_0 = INT(name=u'AssertionType', mode=MODE_TYPE)
    pwdFails._val = dict([(u'Type', _pwdFails_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'dSAOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdFails']), (u'id', (2, 5, 18, 25))])
    
    #-----< pwdFailureTime >-----#
    pwdFailureTime = CLASS(name=u'pwdFailureTime', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdFailureTime_val_Type = TIME_GEN(name=u'Type', mode=MODE_TYPE)
    pwdFailureTime._val = dict([(u'Type', _pwdFailureTime_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_7), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'generalizedTimeMatch']), (u'id', (2, 5, 13, 27))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'generalizedTimeOrderingMatch']), (u'id', (2, 5, 13, 28))])), (u'single-valued', True), (u'usage', u'dSAOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 24)), (u'ldapName', [u'pwdFailureTime']), (u'id', (2, 5, 18, 26))])
    
    #-----< pwdGracesUsed >-----#
    pwdGracesUsed = CLASS(name=u'pwdGracesUsed', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdGracesUsed_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdGracesUsed_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    pwdGracesUsed._val = dict([(u'Type', _pwdGracesUsed_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'dSAOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdGracesUsed']), (u'id', (2, 5, 18, 27))])
    
    #-----< userPwdHistory >-----#
    userPwdHistory = CLASS(name=u'userPwdHistory', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _userPwdHistory_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'PwdHistory')))
    __userPwdHistory_val_Type_time = TIME_GEN(name=u'time', mode=MODE_TYPE)
    __userPwdHistory_val_Type_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    _userPwdHistory_val_Type._cont = ASN1Dict([
        (u'time', __userPwdHistory_val_Type_time),
        (u'password', __userPwdHistory_val_Type_Type),
        ])
    _userPwdHistory_val_Type._ext = []
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    userPwdHistory._val = dict([(u'Type', _userPwdHistory_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_Type), (u'id', (2, 5, 13, 72))])), (u'usage', u'directoryOperation'), (u'id', (2, 5, 18, 28))])
    
    #-----< userPwdRecentlyExpired >-----#
    userPwdRecentlyExpired = CLASS(name=u'userPwdRecentlyExpired', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _userPwdRecentlyExpired_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    userPwdRecentlyExpired._val = dict([(u'Type', _userPwdRecentlyExpired_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_6), (u'ldapSyntax', (2, 5, 40, 0)), (u'ldapName', [u'userPwdMatch']), (u'id', (2, 5, 13, 71))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'id', (2, 5, 18, 29))])
    
    #-----< pwdModifyEntryAllowed >-----#
    pwdModifyEntryAllowed = CLASS(name=u'pwdModifyEntryAllowed', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdModifyEntryAllowed_val_Type = BOOL(name=u'Type', mode=MODE_TYPE)
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_9 = BOOL(name=u'AssertionType', mode=MODE_TYPE)
    pwdModifyEntryAllowed._val = dict([(u'Type', _pwdModifyEntryAllowed_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_9), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 6)), (u'ldapName', [u'booleanMatch']), (u'id', (2, 5, 13, 13))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 7)), (u'ldapName', [u'pwdModifyEntryAllowed']), (u'id', (2, 5, 18, 30))])
    
    #-----< pwdChangeAllowed >-----#
    pwdChangeAllowed = CLASS(name=u'pwdChangeAllowed', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdChangeAllowed_val_Type = BOOL(name=u'Type', mode=MODE_TYPE)
    pwdChangeAllowed._val = dict([(u'Type', _pwdChangeAllowed_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_9), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 6)), (u'ldapName', [u'booleanMatch']), (u'id', (2, 5, 13, 13))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 7)), (u'ldapName', [u'pwdChangeAllowed']), (u'id', (2, 5, 18, 31))])
    
    #-----< pwdMaxAge >-----#
    pwdMaxAge = CLASS(name=u'pwdMaxAge', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdMaxAge_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdMaxAge_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    pwdMaxAge._val = dict([(u'Type', _pwdMaxAge_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdMaxAge']), (u'id', (2, 5, 18, 32))])
    
    #-----< pwdExpiryAge >-----#
    pwdExpiryAge = CLASS(name=u'pwdExpiryAge', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdExpiryAge_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdExpiryAge_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    pwdExpiryAge._val = dict([(u'Type', _pwdExpiryAge_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdExpiryAge']), (u'id', (2, 5, 18, 33))])
    
    #-----< pwdMinLength >-----#
    pwdMinLength = CLASS(name=u'pwdMinLength', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdMinLength_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdMinLength_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    pwdMinLength._val = dict([(u'Type', _pwdMinLength_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdMinLength']), (u'id', (2, 5, 18, 34))])
    
    #-----< pwdVocabulary >-----#
    pwdVocabulary = CLASS(name=u'pwdVocabulary', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdVocabulary_val_Type = BIT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PwdVocabulary')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_10 = BIT_STR(name=u'AssertionType', mode=MODE_TYPE)
    pwdVocabulary._val = dict([(u'Type', _pwdVocabulary_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_10), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 6)), (u'ldapName', [u'bitStringMatch']), (u'id', (2, 5, 13, 16))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (2, 5, 40, 1)), (u'ldapName', [u'pwdVocabulary']), (u'id', (2, 5, 18, 35))])
    
    #-----< PwdVocabulary >-----#
    PwdVocabulary = BIT_STR(name=u'PwdVocabulary', mode=MODE_TYPE)
    PwdVocabulary._cont = ASN1Dict([(u'noDictionaryWords', 0), (u'noPersonNames', 1), (u'noGeographicalNames', 2)])
    
    #-----< pwdAlphabet >-----#
    pwdAlphabet = CLASS(name=u'pwdAlphabet', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdAlphabet_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PwdAlphabet')))
    pwdAlphabet._val = dict([(u'Type', _pwdAlphabet_val_Type), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (2, 5, 40, 2)), (u'ldapName', [u'pwdAlphabet']), (u'id', (2, 5, 18, 36))])
    
    #-----< PwdAlphabet >-----#
    PwdAlphabet = SEQ_OF(name=u'PwdAlphabet', mode=MODE_TYPE)
    _PwdAlphabet__item_ = STR_UTF8(name='_item_', mode=MODE_TYPE)
    PwdAlphabet._cont = _PwdAlphabet__item_
    
    #-----< pwdDictionaries >-----#
    pwdDictionaries = CLASS(name=u'pwdDictionaries', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type_0 = STR_UTF8(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'URI')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType__11 = STR_UTF8(name=u'AssertionType', mode=MODE_TYPE)
    pwdDictionaries._val = dict([(u'derivation', dict([(u'Type', ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType__11), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'uriMatch']), (u'id', (2, 5, 13, 70))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'uri']), (u'id', (2, 5, 4, 83))])), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'pwdDictionaries']), (u'id', (2, 5, 18, 37))])
    
    #-----< pwdExpiryWarning >-----#
    pwdExpiryWarning = CLASS(name=u'pwdExpiryWarning', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdExpiryWarning_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdExpiryWarning_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    pwdExpiryWarning._val = dict([(u'Type', _pwdExpiryWarning_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdExpiryWarning']), (u'id', (2, 5, 18, 38))])
    
    #-----< pwdGraces >-----#
    pwdGraces = CLASS(name=u'pwdGraces', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdGraces_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdGraces_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    pwdGraces._val = dict([(u'Type', _pwdGraces_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdGraces']), (u'id', (2, 5, 18, 39))])
    
    #-----< pwdFailureDuration >-----#
    pwdFailureDuration = CLASS(name=u'pwdFailureDuration', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdFailureDuration_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdFailureDuration_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    pwdFailureDuration._val = dict([(u'Type', _pwdFailureDuration_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdFailureDuration']), (u'id', (2, 5, 18, 40))])
    
    #-----< pwdLockoutDuration >-----#
    pwdLockoutDuration = CLASS(name=u'pwdLockoutDuration', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdLockoutDuration_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdLockoutDuration_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    pwdLockoutDuration._val = dict([(u'Type', _pwdLockoutDuration_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdLockoutDuration']), (u'id', (2, 5, 18, 41))])
    
    #-----< pwdMaxFailures >-----#
    pwdMaxFailures = CLASS(name=u'pwdMaxFailures', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdMaxFailures_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdMaxFailures_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    pwdMaxFailures._val = dict([(u'Type', _pwdMaxFailures_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdMaxFailures']), (u'id', (2, 5, 18, 42))])
    
    #-----< pwdMaxTimeInHistory >-----#
    pwdMaxTimeInHistory = CLASS(name=u'pwdMaxTimeInHistory', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdMaxTimeInHistory_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdMaxTimeInHistory_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    pwdMaxTimeInHistory._val = dict([(u'Type', _pwdMaxTimeInHistory_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdMaxTimeInHistory']), (u'id', (2, 5, 18, 43))])
    
    #-----< pwdMinTimeInHistory >-----#
    pwdMinTimeInHistory = CLASS(name=u'pwdMinTimeInHistory', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdMinTimeInHistory_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdMinTimeInHistory_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    pwdMinTimeInHistory._val = dict([(u'Type', _pwdMinTimeInHistory_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdMinTimeInHistory']), (u'id', (2, 5, 18, 44))])
    
    #-----< pwdHistorySlots >-----#
    pwdHistorySlots = CLASS(name=u'pwdHistorySlots', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdHistorySlots_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdHistorySlots_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=2, ub=None)], ev=None, er=[])
    pwdHistorySlots._val = dict([(u'Type', _pwdHistorySlots_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdHistorySlots']), (u'id', (2, 5, 18, 45))])
    
    #-----< pwdRecentlyExpiredDuration >-----#
    pwdRecentlyExpiredDuration = CLASS(name=u'pwdRecentlyExpiredDuration', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdRecentlyExpiredDuration_val_Type = INT(name=u'Type', mode=MODE_TYPE)
    _pwdRecentlyExpiredDuration_val_Type._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    pwdRecentlyExpiredDuration._val = dict([(u'Type', _pwdRecentlyExpiredDuration_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerMatch']), (u'id', (2, 5, 13, 14))])), (u'ordering-match', dict([(u'AssertionType', __pwdStartTime_ordering_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'integerOrderingMatch']), (u'id', (2, 5, 13, 15))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 27)), (u'ldapName', [u'pwdRecentlyExpiredDuration']), (u'id', (2, 5, 18, 46))])
    
    #-----< pwdEncAlg >-----#
    pwdEncAlg = CLASS(name=u'pwdEncAlg', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _pwdEncAlg_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PwdEncAlg')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType___12 = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PwdEncAlg')))
    pwdEncAlg._val = dict([(u'Type', _pwdEncAlg_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType___12), (u'ldapSyntax', (2, 5, 40, 3)), (u'ldapName', [u'pwdEncAlgMatch']), (u'id', (2, 5, 13, 73))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'ldapSyntax', (2, 5, 40, 3)), (u'ldapName', [u'pwdEncAlg']), (u'id', (2, 5, 18, 47))])
    
    #-----< PwdEncAlg >-----#
    PwdEncAlg = SEQ(name=u'PwdEncAlg', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _PwdEncAlg_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    __PwdEncAlg_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    __PwdEncAlg_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PwdEncAlg_algorithm._const_tab = __PwdEncAlg_algorithm_tab
    _PwdEncAlg_algorithm._const_tab_at = None
    _PwdEncAlg_algorithm._const_tab_id = u'id'
    _PwdEncAlg_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    __PwdEncAlg_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    __PwdEncAlg_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PwdEncAlg_parameters._const_tab = __PwdEncAlg_parameters_tab
    _PwdEncAlg_parameters._const_tab_at = ('..', u'algorithm')
    _PwdEncAlg_parameters._const_tab_id = u'Type'
    PwdEncAlg._cont = ASN1Dict([
        (u'algorithm', _PwdEncAlg_algorithm),
        (u'parameters', _PwdEncAlg_parameters),
        ])
    PwdEncAlg._ext = []
    
    #-----< userPwdMatch >-----#
    userPwdMatch = CLASS(name=u'userPwdMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _userPwdMatch_val_AssertionType = CHOICE(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    userPwdMatch._val = dict([(u'AssertionType', _userPwdMatch_val_AssertionType), (u'ldapSyntax', (2, 5, 40, 0)), (u'ldapName', [u'userPwdMatch']), (u'id', (2, 5, 13, 71))])
    
    #-----< pwdEncAlgMatch >-----#
    pwdEncAlgMatch = CLASS(name=u'pwdEncAlgMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _pwdEncAlgMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PwdEncAlg')))
    pwdEncAlgMatch._val = dict([(u'AssertionType', _pwdEncAlgMatch_val_AssertionType), (u'ldapSyntax', (2, 5, 40, 3)), (u'ldapName', [u'pwdEncAlgMatch']), (u'id', (2, 5, 13, 73))])
    
    #-----< userPwdHistoryMatch >-----#
    userPwdHistoryMatch = CLASS(name=u'userPwdHistoryMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _userPwdHistoryMatch_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    userPwdHistoryMatch._val = dict([(u'AssertionType', _userPwdHistoryMatch_val_Type), (u'id', (2, 5, 13, 72))])
    
    #-----< userPwdDescription >-----#
    userPwdDescription = CLASS(name=u'userPwdDescription', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _userPwdDescription_val_Type = CHOICE(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    userPwdDescription._val = dict([(u'ldapDesc', u'User Password Description'), (u'Type', _userPwdDescription_val_Type), (u'id', (2, 5, 40, 0))])
    
    #-----< pwdVocabularyDescription >-----#
    pwdVocabularyDescription = CLASS(name=u'pwdVocabularyDescription', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _pwdVocabularyDescription_val_Type = BIT_STR(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PwdVocabulary')))
    pwdVocabularyDescription._val = dict([(u'ldapDesc', u'Password Vocabulary Description'), (u'Type', _pwdVocabularyDescription_val_Type), (u'id', (2, 5, 40, 1))])
    
    #-----< pwdAlphabetDescription >-----#
    pwdAlphabetDescription = CLASS(name=u'pwdAlphabetDescription', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _pwdAlphabetDescription_val_Type = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PwdAlphabet')))
    pwdAlphabetDescription._val = dict([(u'ldapDesc', u'Password Alphabet Description'), (u'Type', _pwdAlphabetDescription_val_Type), (u'id', (2, 5, 40, 2))])
    
    #-----< pwdEncAlgDescription >-----#
    pwdEncAlgDescription = CLASS(name=u'pwdEncAlgDescription', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _pwdEncAlgDescription_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PwdEncAlg')))
    pwdEncAlgDescription._val = dict([(u'ldapDesc', u'Password Alphabet Description'), (u'Type', _pwdEncAlgDescription_val_Type), (u'id', (2, 5, 40, 3))])
    
    #-----< x509Certificate >-----#
    x509Certificate = CLASS(name=u'x509Certificate', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _x509Certificate_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Certificate')))
    x509Certificate._val = dict([(u'ldapDesc', u'X.509 Certificate'), (u'Type', _x509Certificate_val_Type), (u'id', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8))])
    
    #-----< x509CertificateList >-----#
    x509CertificateList = CLASS(name=u'x509CertificateList', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _x509CertificateList_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateList')))
    x509CertificateList._val = dict([(u'ldapDesc', u'X.509 Certificate List'), (u'Type', _x509CertificateList_val_Type), (u'id', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9))])
    
    #-----< x509CertificatePair >-----#
    x509CertificatePair = CLASS(name=u'x509CertificatePair', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _x509CertificatePair_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificatePair')))
    x509CertificatePair._val = dict([(u'ldapDesc', u'X.509 Certificate Pair'), (u'Type', _x509CertificatePair_val_Type), (u'id', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 10))])
    
    #-----< x509SupportedAlgorithm >-----#
    x509SupportedAlgorithm = CLASS(name=u'x509SupportedAlgorithm', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _x509SupportedAlgorithm_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SupportedAlgorithm')))
    x509SupportedAlgorithm._val = dict([(u'ldapDesc', u'X.509 Supported Algorithm'), (u'Type', _x509SupportedAlgorithm_val_Type), (u'id', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 49))])
    
    #-----< id-oc-cRLDistributionPoint >-----#
    id_oc_cRLDistributionPoint = OID(name=u'id-oc-cRLDistributionPoint', mode=MODE_VALUE)
    id_oc_cRLDistributionPoint._val = (2, 5, 6, 19)
    
    #-----< id-oc-pkiUser >-----#
    id_oc_pkiUser = OID(name=u'id-oc-pkiUser', mode=MODE_VALUE)
    id_oc_pkiUser._val = (2, 5, 6, 21)
    
    #-----< id-oc-pkiCA >-----#
    id_oc_pkiCA = OID(name=u'id-oc-pkiCA', mode=MODE_VALUE)
    id_oc_pkiCA._val = (2, 5, 6, 22)
    
    #-----< id-oc-deltaCRL >-----#
    id_oc_deltaCRL = OID(name=u'id-oc-deltaCRL', mode=MODE_VALUE)
    id_oc_deltaCRL._val = (2, 5, 6, 23)
    
    #-----< id-oc-cpCps >-----#
    id_oc_cpCps = OID(name=u'id-oc-cpCps', mode=MODE_VALUE)
    id_oc_cpCps._val = (2, 5, 6, 30)
    
    #-----< id-oc-pkiCertPath >-----#
    id_oc_pkiCertPath = OID(name=u'id-oc-pkiCertPath', mode=MODE_VALUE)
    id_oc_pkiCertPath._val = (2, 5, 6, 31)
    
    #-----< id-nf-cRLDistPtNameForm >-----#
    id_nf_cRLDistPtNameForm = OID(name=u'id-nf-cRLDistPtNameForm', mode=MODE_VALUE)
    id_nf_cRLDistPtNameForm._val = (2, 5, 15, 14)
    
    #-----< id-at-userPassword >-----#
    id_at_userPassword = OID(name=u'id-at-userPassword', mode=MODE_VALUE)
    id_at_userPassword._val = (2, 5, 4, 35)
    
    #-----< id-at-userCertificate >-----#
    id_at_userCertificate = OID(name=u'id-at-userCertificate', mode=MODE_VALUE)
    id_at_userCertificate._val = (2, 5, 4, 36)
    
    #-----< id-at-cAcertificate >-----#
    id_at_cAcertificate = OID(name=u'id-at-cAcertificate', mode=MODE_VALUE)
    id_at_cAcertificate._val = (2, 5, 4, 37)
    
    #-----< id-at-authorityRevocationList >-----#
    id_at_authorityRevocationList = OID(name=u'id-at-authorityRevocationList', mode=MODE_VALUE)
    id_at_authorityRevocationList._val = (2, 5, 4, 38)
    
    #-----< id-at-certificateRevocationList >-----#
    id_at_certificateRevocationList = OID(name=u'id-at-certificateRevocationList', mode=MODE_VALUE)
    id_at_certificateRevocationList._val = (2, 5, 4, 39)
    
    #-----< id-at-crossCertificatePair >-----#
    id_at_crossCertificatePair = OID(name=u'id-at-crossCertificatePair', mode=MODE_VALUE)
    id_at_crossCertificatePair._val = (2, 5, 4, 40)
    
    #-----< id-at-supportedAlgorithms >-----#
    id_at_supportedAlgorithms = OID(name=u'id-at-supportedAlgorithms', mode=MODE_VALUE)
    id_at_supportedAlgorithms._val = (2, 5, 4, 52)
    
    #-----< id-at-deltaRevocationList >-----#
    id_at_deltaRevocationList = OID(name=u'id-at-deltaRevocationList', mode=MODE_VALUE)
    id_at_deltaRevocationList._val = (2, 5, 4, 53)
    
    #-----< id-at-certificationPracticeStmt >-----#
    id_at_certificationPracticeStmt = OID(name=u'id-at-certificationPracticeStmt', mode=MODE_VALUE)
    id_at_certificationPracticeStmt._val = (2, 5, 4, 68)
    
    #-----< id-at-certificatePolicy >-----#
    id_at_certificatePolicy = OID(name=u'id-at-certificatePolicy', mode=MODE_VALUE)
    id_at_certificatePolicy._val = (2, 5, 4, 69)
    
    #-----< id-at-pkiPath >-----#
    id_at_pkiPath = OID(name=u'id-at-pkiPath', mode=MODE_VALUE)
    id_at_pkiPath._val = (2, 5, 4, 70)
    
    #-----< id-at-userPwd >-----#
    id_at_userPwd = OID(name=u'id-at-userPwd', mode=MODE_VALUE)
    id_at_userPwd._val = (2, 5, 4, 85)
    
    #-----< id-oa-pwdStartTime >-----#
    id_oa_pwdStartTime = OID(name=u'id-oa-pwdStartTime', mode=MODE_VALUE)
    id_oa_pwdStartTime._val = (2, 5, 18, 22)
    
    #-----< id-oa-pwdExpiryTime >-----#
    id_oa_pwdExpiryTime = OID(name=u'id-oa-pwdExpiryTime', mode=MODE_VALUE)
    id_oa_pwdExpiryTime._val = (2, 5, 18, 23)
    
    #-----< id-oa-pwdEndTime >-----#
    id_oa_pwdEndTime = OID(name=u'id-oa-pwdEndTime', mode=MODE_VALUE)
    id_oa_pwdEndTime._val = (2, 5, 18, 24)
    
    #-----< id-oa-pwdFails >-----#
    id_oa_pwdFails = OID(name=u'id-oa-pwdFails', mode=MODE_VALUE)
    id_oa_pwdFails._val = (2, 5, 18, 25)
    
    #-----< id-oa-pwdFailureTime >-----#
    id_oa_pwdFailureTime = OID(name=u'id-oa-pwdFailureTime', mode=MODE_VALUE)
    id_oa_pwdFailureTime._val = (2, 5, 18, 26)
    
    #-----< id-oa-pwdGracesUsed >-----#
    id_oa_pwdGracesUsed = OID(name=u'id-oa-pwdGracesUsed', mode=MODE_VALUE)
    id_oa_pwdGracesUsed._val = (2, 5, 18, 27)
    
    #-----< id-oa-userPwdHistory >-----#
    id_oa_userPwdHistory = OID(name=u'id-oa-userPwdHistory', mode=MODE_VALUE)
    id_oa_userPwdHistory._val = (2, 5, 18, 28)
    
    #-----< id-oa-userPwdRecentlyExpired >-----#
    id_oa_userPwdRecentlyExpired = OID(name=u'id-oa-userPwdRecentlyExpired', mode=MODE_VALUE)
    id_oa_userPwdRecentlyExpired._val = (2, 5, 18, 29)
    
    #-----< id-oa-pwdModifyEntryAllowed >-----#
    id_oa_pwdModifyEntryAllowed = OID(name=u'id-oa-pwdModifyEntryAllowed', mode=MODE_VALUE)
    id_oa_pwdModifyEntryAllowed._val = (2, 5, 18, 30)
    
    #-----< id-oa-pwdChangeAllowed >-----#
    id_oa_pwdChangeAllowed = OID(name=u'id-oa-pwdChangeAllowed', mode=MODE_VALUE)
    id_oa_pwdChangeAllowed._val = (2, 5, 18, 31)
    
    #-----< id-oa-pwdMaxAge >-----#
    id_oa_pwdMaxAge = OID(name=u'id-oa-pwdMaxAge', mode=MODE_VALUE)
    id_oa_pwdMaxAge._val = (2, 5, 18, 32)
    
    #-----< id-oa-pwdExpiryAge >-----#
    id_oa_pwdExpiryAge = OID(name=u'id-oa-pwdExpiryAge', mode=MODE_VALUE)
    id_oa_pwdExpiryAge._val = (2, 5, 18, 33)
    
    #-----< id-oa-pwdMinLength >-----#
    id_oa_pwdMinLength = OID(name=u'id-oa-pwdMinLength', mode=MODE_VALUE)
    id_oa_pwdMinLength._val = (2, 5, 18, 34)
    
    #-----< id-oa-pwdVocabulary >-----#
    id_oa_pwdVocabulary = OID(name=u'id-oa-pwdVocabulary', mode=MODE_VALUE)
    id_oa_pwdVocabulary._val = (2, 5, 18, 35)
    
    #-----< id-oa-pwdAlphabet >-----#
    id_oa_pwdAlphabet = OID(name=u'id-oa-pwdAlphabet', mode=MODE_VALUE)
    id_oa_pwdAlphabet._val = (2, 5, 18, 36)
    
    #-----< id-oa-pwdDictionaries >-----#
    id_oa_pwdDictionaries = OID(name=u'id-oa-pwdDictionaries', mode=MODE_VALUE)
    id_oa_pwdDictionaries._val = (2, 5, 18, 37)
    
    #-----< id-oa-pwdExpiryWarning >-----#
    id_oa_pwdExpiryWarning = OID(name=u'id-oa-pwdExpiryWarning', mode=MODE_VALUE)
    id_oa_pwdExpiryWarning._val = (2, 5, 18, 38)
    
    #-----< id-oa-pwdGraces >-----#
    id_oa_pwdGraces = OID(name=u'id-oa-pwdGraces', mode=MODE_VALUE)
    id_oa_pwdGraces._val = (2, 5, 18, 39)
    
    #-----< id-oa-pwdFailureDuration >-----#
    id_oa_pwdFailureDuration = OID(name=u'id-oa-pwdFailureDuration', mode=MODE_VALUE)
    id_oa_pwdFailureDuration._val = (2, 5, 18, 40)
    
    #-----< id-oa-pwdLockoutDuration >-----#
    id_oa_pwdLockoutDuration = OID(name=u'id-oa-pwdLockoutDuration', mode=MODE_VALUE)
    id_oa_pwdLockoutDuration._val = (2, 5, 18, 41)
    
    #-----< id-oa-pwdMaxFailures >-----#
    id_oa_pwdMaxFailures = OID(name=u'id-oa-pwdMaxFailures', mode=MODE_VALUE)
    id_oa_pwdMaxFailures._val = (2, 5, 18, 42)
    
    #-----< id-oa-pwdMaxTimeInHistory >-----#
    id_oa_pwdMaxTimeInHistory = OID(name=u'id-oa-pwdMaxTimeInHistory', mode=MODE_VALUE)
    id_oa_pwdMaxTimeInHistory._val = (2, 5, 18, 43)
    
    #-----< id-oa-pwdMinTimeInHistory >-----#
    id_oa_pwdMinTimeInHistory = OID(name=u'id-oa-pwdMinTimeInHistory', mode=MODE_VALUE)
    id_oa_pwdMinTimeInHistory._val = (2, 5, 18, 44)
    
    #-----< id-oa-pwdHistorySlots >-----#
    id_oa_pwdHistorySlots = OID(name=u'id-oa-pwdHistorySlots', mode=MODE_VALUE)
    id_oa_pwdHistorySlots._val = (2, 5, 18, 45)
    
    #-----< id-oa-pwdRecentlyExpiredDuration >-----#
    id_oa_pwdRecentlyExpiredDuration = OID(name=u'id-oa-pwdRecentlyExpiredDuration', mode=MODE_VALUE)
    id_oa_pwdRecentlyExpiredDuration._val = (2, 5, 18, 46)
    
    #-----< id-oa-pwdEncAlg >-----#
    id_oa_pwdEncAlg = OID(name=u'id-oa-pwdEncAlg', mode=MODE_VALUE)
    id_oa_pwdEncAlg._val = (2, 5, 18, 47)
    
    #-----< id-mr-userPwdMatch >-----#
    id_mr_userPwdMatch = OID(name=u'id-mr-userPwdMatch', mode=MODE_VALUE)
    id_mr_userPwdMatch._val = (2, 5, 13, 71)
    
    #-----< id-mr-userPwdHistoryMatch >-----#
    id_mr_userPwdHistoryMatch = OID(name=u'id-mr-userPwdHistoryMatch', mode=MODE_VALUE)
    id_mr_userPwdHistoryMatch._val = (2, 5, 13, 72)
    
    #-----< id-mr-pwdEncAlgMatch >-----#
    id_mr_pwdEncAlgMatch = OID(name=u'id-mr-pwdEncAlgMatch', mode=MODE_VALUE)
    id_mr_pwdEncAlgMatch._val = (2, 5, 13, 73)
    
    #-----< id-asx-userPwdDescription >-----#
    id_asx_userPwdDescription = OID(name=u'id-asx-userPwdDescription', mode=MODE_VALUE)
    id_asx_userPwdDescription._val = (2, 5, 40, 0)
    
    #-----< id-asx-pwdVocabularyDescription >-----#
    id_asx_pwdVocabularyDescription = OID(name=u'id-asx-pwdVocabularyDescription', mode=MODE_VALUE)
    id_asx_pwdVocabularyDescription._val = (2, 5, 40, 1)
    
    #-----< id-asx-pwdAlphabetDescription >-----#
    id_asx_pwdAlphabetDescription = OID(name=u'id-asx-pwdAlphabetDescription', mode=MODE_VALUE)
    id_asx_pwdAlphabetDescription._val = (2, 5, 40, 2)
    
    #-----< id-asx-pwdEncAlgDescription >-----#
    id_asx_pwdEncAlgDescription = OID(name=u'id-asx-pwdEncAlgDescription', mode=MODE_VALUE)
    id_asx_pwdEncAlgDescription._val = (2, 5, 40, 3)
    
    #-----< id-lsx-x509Certificate >-----#
    id_lsx_x509Certificate = OID(name=u'id-lsx-x509Certificate', mode=MODE_VALUE)
    id_lsx_x509Certificate._val = (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 8)
    
    #-----< id-lsx-x509CertificateList >-----#
    id_lsx_x509CertificateList = OID(name=u'id-lsx-x509CertificateList', mode=MODE_VALUE)
    id_lsx_x509CertificateList._val = (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 9)
    
    #-----< id-lsx-x509CertificatePair >-----#
    id_lsx_x509CertificatePair = OID(name=u'id-lsx-x509CertificatePair', mode=MODE_VALUE)
    id_lsx_x509CertificatePair._val = (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 10)
    
    #-----< id-lsx-x509SupportedAlgorithm >-----#
    id_lsx_x509SupportedAlgorithm = OID(name=u'id-lsx-x509SupportedAlgorithm', mode=MODE_VALUE)
    id_lsx_x509SupportedAlgorithm._val = (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 49)
    
    #-----< id-ecPublicKey >-----#
    id_ecPublicKey = OID(name=u'id-ecPublicKey', mode=MODE_VALUE)
    id_ecPublicKey._val = (1, 2, 840, 10045, 2, 1)
    
    _all_ = [
        ENCRYPTED,
        ___HASH_algorithmIdentifier_algorithm_tab,
        __HASH_algorithmIdentifier_algorithm,
        ___HASH_algorithmIdentifier_parameters_tab,
        __HASH_algorithmIdentifier_parameters,
        _HASH_algorithmIdentifier,
        _HASH_hashValue,
        HASH,
        ENCRYPTED_HASH,
        ___SIGNATURE_algorithmIdentifier_algorithm_tab,
        __SIGNATURE_algorithmIdentifier_algorithm,
        ___SIGNATURE_algorithmIdentifier_parameters_tab,
        __SIGNATURE_algorithmIdentifier_parameters,
        _SIGNATURE_algorithmIdentifier,
        _SIGNATURE_encrypted,
        SIGNATURE,
        _Certificate_toBeSigned,
        ___Certificate_algorithmIdentifier_algorithm_tab,
        __Certificate_algorithmIdentifier_algorithm,
        ___Certificate_algorithmIdentifier_parameters_tab,
        __Certificate_algorithmIdentifier_parameters,
        _Certificate_algorithmIdentifier,
        _Certificate_encrypted,
        Certificate,
        _TBSCertificate_version,
        _TBSCertificate_serialNumber,
        ___TBSCertificate_signature_algorithm_tab,
        __TBSCertificate_signature_algorithm,
        ___TBSCertificate_signature_parameters_tab,
        __TBSCertificate_signature_parameters,
        _TBSCertificate_signature,
        _TBSCertificate_issuer,
        _TBSCertificate_validity,
        _TBSCertificate_subject,
        _TBSCertificate_subjectPublicKeyInfo,
        _TBSCertificate_issuerUniqueIdentifier,
        _TBSCertificate_subjectUniqueIdentifier,
        _TBSCertificate_extensions,
        TBSCertificate,
        Version,
        CertificateSerialNumber,
        SupportedAlgorithms,
        _ALGORITHM_Type,
        _ALGORITHM_id,
        ALGORITHM,
        ecPublicKey,
        _ecPublicKey_val_Type,
        SupportedCurves,
        dummyCurv,
        _Validity_notBefore,
        _Validity_notAfter,
        Validity,
        ___SubjectPublicKeyInfo_algorithm_algorithm_tab,
        __SubjectPublicKeyInfo_algorithm_algorithm,
        ___SubjectPublicKeyInfo_algorithm_parameters_tab,
        __SubjectPublicKeyInfo_algorithm_parameters,
        _SubjectPublicKeyInfo_algorithm,
        _SubjectPublicKeyInfo_subjectPublicKey,
        SubjectPublicKeyInfo,
        _Time_utcTime,
        _Time_generalizedTime,
        Time,
        _Extensions__item_,
        Extensions,
        __Extension_extnId_tab,
        _Extension_extnId,
        _Extension_critical,
        _Extension_extnValue,
        Extension,
        der,
        ExtensionSet,
        _EXTENSION_id,
        _EXTENSION_ExtnType,
        EXTENSION,
        _Certificates_userCertificate,
        _Certificates_certificationPath,
        Certificates,
        _ForwardCertificationPath__item_,
        ForwardCertificationPath,
        _CrossCertificates__item_,
        CrossCertificates,
        _CertificationPath_userCertificate,
        __CertificationPath_theCACertificates__item_,
        _CertificationPath_theCACertificates,
        CertificationPath,
        _PkiPath__item_,
        PkiPath,
        _CertificateList_toBeSigned,
        ___CertificateList_algorithmIdentifier_algorithm_tab,
        __CertificateList_algorithmIdentifier_algorithm,
        ___CertificateList_algorithmIdentifier_parameters_tab,
        __CertificateList_algorithmIdentifier_parameters,
        _CertificateList_algorithmIdentifier,
        _CertificateList_encrypted,
        CertificateList,
        _CertificateListContent_version,
        ___CertificateListContent_signature_algorithm_tab,
        __CertificateListContent_signature_algorithm,
        ___CertificateListContent_signature_parameters_tab,
        __CertificateListContent_signature_parameters,
        _CertificateListContent_signature,
        _CertificateListContent_issuer,
        _CertificateListContent_thisUpdate,
        _CertificateListContent_nextUpdate,
        ___CertificateListContent_revokedCertificates__item__serialNumber,
        ___CertificateListContent_revokedCertificates__item__revocationDate,
        ___CertificateListContent_revokedCertificates__item__crlEntryExtensions,
        __CertificateListContent_revokedCertificates__item_,
        _CertificateListContent_revokedCertificates,
        _CertificateListContent_crlExtensions,
        CertificateListContent,
        pkiUser,
        ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType,
        __pmiUser_OptionalAttributes_val_Type_0,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0,
        pkiCA,
        __pmiUser_OptionalAttributes_val_Type_1,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_1,
        __pmiUser_OptionalAttributes_val_Type_2,
        __pmiUser_OptionalAttributes_val_Type_3,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_2,
        cRLDistributionPoint,
        ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_3,
        _____pmiUser_Superclasses_MandatoryAttributes_derivation_substrings_match_val_AssertionType,
        ___pmiUser_Superclasses_MandatoryAttributes_val_Type_0_0,
        __pmiUser_OptionalAttributes_val_Type_0_0,
        cRLDistPtNameForm,
        __cRLDistPtNameForm_MandatoryAttributes_val_Type_0,
        deltaCRL,
        cpCps,
        __pmiUser_OptionalAttributes_val_Type_0_1,
        __pmiUser_OptionalAttributes_val_Type_1_0,
        pkiCertPath,
        __pmiUser_OptionalAttributes_val_Type_0_2,
        userCertificate,
        _userCertificate_val_Type,
        cACertificate,
        _cACertificate_val_Type,
        crossCertificatePair,
        _crossCertificatePair_val_Type,
        _CertificatePair_issuedToThisCA,
        _CertificatePair_issuedByThisCA,
        CertificatePair,
        certificateRevocationList,
        _certificateRevocationList_val_Type,
        authorityRevocationList,
        _authorityRevocationList_val_Type,
        deltaRevocationList,
        _deltaRevocationList_val_Type,
        supportedAlgorithms,
        _supportedAlgorithms_val_Type,
        ________AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm_tab,
        _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_algorithm,
        ________AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters_tab,
        _______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4_parameters,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_4,
        ___SupportedAlgorithm_algorithmIdentifier_algorithm_tab,
        __SupportedAlgorithm_algorithmIdentifier_algorithm,
        ___SupportedAlgorithm_algorithmIdentifier_parameters_tab,
        __SupportedAlgorithm_algorithmIdentifier_parameters,
        _SupportedAlgorithm_algorithmIdentifier,
        _SupportedAlgorithm_intendedUsage,
        _SupportedAlgorithm_intendedCertificatePolicies,
        SupportedAlgorithm,
        certificationPracticeStmt,
        _certificationPracticeStmt_val_Type,
        _InfoSyntax_content,
        __InfoSyntax_pointer_name,
        _____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm_tab,
        ____InfoSyntax_pointer_hash_algorithmIdentifier_algorithm,
        _____InfoSyntax_pointer_hash_algorithmIdentifier_parameters_tab,
        ____InfoSyntax_pointer_hash_algorithmIdentifier_parameters,
        ___InfoSyntax_pointer_hash_algorithmIdentifier,
        ___InfoSyntax_pointer_hash_hashValue,
        __InfoSyntax_pointer_hash,
        _InfoSyntax_pointer,
        InfoSyntax,
        POLICY,
        _HashedPolicyInfo_tab,
        HashedPolicyInfo,
        Policies,
        certificatePolicy,
        _certificatePolicy_val_Type,
        _PolicySyntax_policyIdentifier,
        _PolicySyntax_policySyntax,
        PolicySyntax,
        PolicyID,
        pkiPath,
        _pkiPath_val_Type,
        userPassword,
        _userPassword_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_5,
        userPwd,
        _userPwd_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_6,
        _UserPwd_clear,
        ____UserPwd_encrypted_algorithmIdentifier_algorithm_tab,
        ___UserPwd_encrypted_algorithmIdentifier_algorithm,
        ____UserPwd_encrypted_algorithmIdentifier_parameters_tab,
        ___UserPwd_encrypted_algorithmIdentifier_parameters,
        __UserPwd_encrypted_algorithmIdentifier,
        __UserPwd_encrypted_encryptedString,
        _UserPwd_encrypted,
        UserPwd,
        pwdStartTime,
        _pwdStartTime_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_7,
        __pwdStartTime_ordering_match_val_AssertionType,
        pwdExpiryTime,
        _pwdExpiryTime_val_Type,
        pwdEndTime,
        _pwdEndTime_val_Type,
        pwdFails,
        _pwdFails_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_8,
        __pwdStartTime_ordering_match_val_AssertionType_0,
        pwdFailureTime,
        _pwdFailureTime_val_Type,
        pwdGracesUsed,
        _pwdGracesUsed_val_Type,
        userPwdHistory,
        __userPwdHistory_val_Type_time,
        __userPwdHistory_val_Type_Type,
        _userPwdHistory_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_Type,
        userPwdRecentlyExpired,
        _userPwdRecentlyExpired_val_Type,
        pwdModifyEntryAllowed,
        _pwdModifyEntryAllowed_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_9,
        pwdChangeAllowed,
        _pwdChangeAllowed_val_Type,
        pwdMaxAge,
        _pwdMaxAge_val_Type,
        pwdExpiryAge,
        _pwdExpiryAge_val_Type,
        pwdMinLength,
        _pwdMinLength_val_Type,
        pwdVocabulary,
        _pwdVocabulary_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_10,
        PwdVocabulary,
        pwdAlphabet,
        _pwdAlphabet_val_Type,
        _PwdAlphabet__item_,
        PwdAlphabet,
        pwdDictionaries,
        ____pmiUser_Superclasses_MandatoryAttributes_derivation_val_Type_0,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType__11,
        pwdExpiryWarning,
        _pwdExpiryWarning_val_Type,
        pwdGraces,
        _pwdGraces_val_Type,
        pwdFailureDuration,
        _pwdFailureDuration_val_Type,
        pwdLockoutDuration,
        _pwdLockoutDuration_val_Type,
        pwdMaxFailures,
        _pwdMaxFailures_val_Type,
        pwdMaxTimeInHistory,
        _pwdMaxTimeInHistory_val_Type,
        pwdMinTimeInHistory,
        _pwdMinTimeInHistory_val_Type,
        pwdHistorySlots,
        _pwdHistorySlots_val_Type,
        pwdRecentlyExpiredDuration,
        _pwdRecentlyExpiredDuration_val_Type,
        pwdEncAlg,
        _pwdEncAlg_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType___12,
        __PwdEncAlg_algorithm_tab,
        _PwdEncAlg_algorithm,
        __PwdEncAlg_parameters_tab,
        _PwdEncAlg_parameters,
        PwdEncAlg,
        userPwdMatch,
        _userPwdMatch_val_AssertionType,
        pwdEncAlgMatch,
        _pwdEncAlgMatch_val_AssertionType,
        userPwdHistoryMatch,
        _userPwdHistoryMatch_val_Type,
        userPwdDescription,
        _userPwdDescription_val_Type,
        pwdVocabularyDescription,
        _pwdVocabularyDescription_val_Type,
        pwdAlphabetDescription,
        _pwdAlphabetDescription_val_Type,
        pwdEncAlgDescription,
        _pwdEncAlgDescription_val_Type,
        x509Certificate,
        _x509Certificate_val_Type,
        x509CertificateList,
        _x509CertificateList_val_Type,
        x509CertificatePair,
        _x509CertificatePair_val_Type,
        x509SupportedAlgorithm,
        _x509SupportedAlgorithm_val_Type,
        id_oc_cRLDistributionPoint,
        id_oc_pkiUser,
        id_oc_pkiCA,
        id_oc_deltaCRL,
        id_oc_cpCps,
        id_oc_pkiCertPath,
        id_nf_cRLDistPtNameForm,
        id_at_userPassword,
        id_at_userCertificate,
        id_at_cAcertificate,
        id_at_authorityRevocationList,
        id_at_certificateRevocationList,
        id_at_crossCertificatePair,
        id_at_supportedAlgorithms,
        id_at_deltaRevocationList,
        id_at_certificationPracticeStmt,
        id_at_certificatePolicy,
        id_at_pkiPath,
        id_at_userPwd,
        id_oa_pwdStartTime,
        id_oa_pwdExpiryTime,
        id_oa_pwdEndTime,
        id_oa_pwdFails,
        id_oa_pwdFailureTime,
        id_oa_pwdGracesUsed,
        id_oa_userPwdHistory,
        id_oa_userPwdRecentlyExpired,
        id_oa_pwdModifyEntryAllowed,
        id_oa_pwdChangeAllowed,
        id_oa_pwdMaxAge,
        id_oa_pwdExpiryAge,
        id_oa_pwdMinLength,
        id_oa_pwdVocabulary,
        id_oa_pwdAlphabet,
        id_oa_pwdDictionaries,
        id_oa_pwdExpiryWarning,
        id_oa_pwdGraces,
        id_oa_pwdFailureDuration,
        id_oa_pwdLockoutDuration,
        id_oa_pwdMaxFailures,
        id_oa_pwdMaxTimeInHistory,
        id_oa_pwdMinTimeInHistory,
        id_oa_pwdHistorySlots,
        id_oa_pwdRecentlyExpiredDuration,
        id_oa_pwdEncAlg,
        id_mr_userPwdMatch,
        id_mr_userPwdHistoryMatch,
        id_mr_pwdEncAlgMatch,
        id_asx_userPwdDescription,
        id_asx_pwdVocabularyDescription,
        id_asx_pwdAlphabetDescription,
        id_asx_pwdEncAlgDescription,
        id_lsx_x509Certificate,
        id_lsx_x509CertificateList,
        id_lsx_x509CertificatePair,
        id_lsx_x509SupportedAlgorithm,
        id_ecPublicKey,
    ]

class BasicAccessControl:

    _name_  = u'BasicAccessControl'
    _oid_   = [2, 5, 1, 24, 7]
    
    _obj_ = [
        u'accessControlScheme',
        u'ACIItem',
        u'Precedence',
        u'ProtectedItems',
        u'MaxValueCount',
        u'RestrictedValue',
        u'UserClasses',
        u'ItemPermission',
        u'UserPermission',
        u'AuthenticationLevel',
        u'GrantsAndDenials',
        u'prescriptiveACI',
        u'entryACI',
        u'subentryACI',
        u'id-aca-accessControlScheme',
        u'id-aca-prescriptiveACI',
        u'id-aca-entryACI',
        u'id-aca-subentryACI',
        u'basicAccessControlScheme',
        u'simplifiedAccessControlScheme',
        u'rule-based-access-control',
        u'rule-and-basic-access-control',
        u'rule-and-simple-access-control',
        ]
    _type_ = [
        u'ACIItem',
        u'Precedence',
        u'ProtectedItems',
        u'MaxValueCount',
        u'RestrictedValue',
        u'UserClasses',
        u'ItemPermission',
        u'UserPermission',
        u'AuthenticationLevel',
        u'GrantsAndDenials',
        ]
    _set_ = [
        ]
    _val_ = [
        u'accessControlScheme',
        u'prescriptiveACI',
        u'entryACI',
        u'subentryACI',
        u'id-aca-accessControlScheme',
        u'id-aca-prescriptiveACI',
        u'id-aca-entryACI',
        u'id-aca-subentryACI',
        u'basicAccessControlScheme',
        u'simplifiedAccessControlScheme',
        u'rule-based-access-control',
        u'rule-and-basic-access-control',
        u'rule-and-simple-access-control',
        ]
    _class_ = [
        u'accessControlScheme',
        u'prescriptiveACI',
        u'entryACI',
        u'subentryACI',
        ]
    _param_ = [
        ]
    
    #-----< accessControlScheme >-----#
    accessControlScheme = CLASS(name=u'accessControlScheme', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _accessControlScheme_val_Type = OID(name=u'Type', mode=MODE_TYPE)
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE)
    accessControlScheme._val = dict([(u'Type', _accessControlScheme_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'single-valued', True), (u'usage', u'directoryOperation'), (u'id', (2, 5, 24, 1))])
    
    #-----< ACIItem >-----#
    ACIItem = SEQ(name=u'ACIItem', mode=MODE_TYPE)
    _ACIItem_identificationTag = CHOICE(name=u'identificationTag', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    _ACIItem_precedence = INT(name=u'precedence', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'Precedence')))
    _ACIItem_authenticationLevel = CHOICE(name=u'authenticationLevel', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'AuthenticationLevel')))
    _ACIItem_itemOrUserFirst = CHOICE(name=u'itemOrUserFirst', mode=MODE_TYPE)
    __ACIItem_itemOrUserFirst_itemFirst = SEQ(name=u'itemFirst', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___ACIItem_itemOrUserFirst_itemFirst_protectedItems = SEQ(name=u'protectedItems', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ProtectedItems')))
    ___ACIItem_itemOrUserFirst_itemFirst_itemPermissions = SET_OF(name=u'itemPermissions', mode=MODE_TYPE)
    ____ACIItem_itemOrUserFirst_itemFirst_itemPermissions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ItemPermission')))
    ___ACIItem_itemOrUserFirst_itemFirst_itemPermissions._cont = ____ACIItem_itemOrUserFirst_itemFirst_itemPermissions__item_
    __ACIItem_itemOrUserFirst_itemFirst._cont = ASN1Dict([
        (u'protectedItems', ___ACIItem_itemOrUserFirst_itemFirst_protectedItems),
        (u'itemPermissions', ___ACIItem_itemOrUserFirst_itemFirst_itemPermissions),
        ])
    __ACIItem_itemOrUserFirst_itemFirst._ext = []
    __ACIItem_itemOrUserFirst_userFirst = SEQ(name=u'userFirst', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___ACIItem_itemOrUserFirst_userFirst_userClasses = SEQ(name=u'userClasses', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'UserClasses')))
    ___ACIItem_itemOrUserFirst_userFirst_userPermissions = SET_OF(name=u'userPermissions', mode=MODE_TYPE)
    ____ACIItem_itemOrUserFirst_userFirst_userPermissions__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'UserPermission')))
    ___ACIItem_itemOrUserFirst_userFirst_userPermissions._cont = ____ACIItem_itemOrUserFirst_userFirst_userPermissions__item_
    __ACIItem_itemOrUserFirst_userFirst._cont = ASN1Dict([
        (u'userClasses', ___ACIItem_itemOrUserFirst_userFirst_userClasses),
        (u'userPermissions', ___ACIItem_itemOrUserFirst_userFirst_userPermissions),
        ])
    __ACIItem_itemOrUserFirst_userFirst._ext = []
    _ACIItem_itemOrUserFirst._cont = ASN1Dict([
        (u'itemFirst', __ACIItem_itemOrUserFirst_itemFirst),
        (u'userFirst', __ACIItem_itemOrUserFirst_userFirst),
        ])
    _ACIItem_itemOrUserFirst._ext = []
    ACIItem._cont = ASN1Dict([
        (u'identificationTag', _ACIItem_identificationTag),
        (u'precedence', _ACIItem_precedence),
        (u'authenticationLevel', _ACIItem_authenticationLevel),
        (u'itemOrUserFirst', _ACIItem_itemOrUserFirst),
        ])
    ACIItem._ext = []
    
    #-----< Precedence >-----#
    Precedence = INT(name=u'Precedence', mode=MODE_TYPE)
    Precedence._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=255)], ev=[], er=[])
    
    #-----< ProtectedItems >-----#
    ProtectedItems = SEQ(name=u'ProtectedItems', mode=MODE_TYPE)
    _ProtectedItems_entry = NULL(name=u'entry', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ProtectedItems_allUserAttributeTypes = NULL(name=u'allUserAttributeTypes', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ProtectedItems_attributeType = SET_OF(name=u'attributeType', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_attributeType__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _ProtectedItems_attributeType._cont = __ProtectedItems_attributeType__item_
    _ProtectedItems_attributeType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_allAttributeValues = SET_OF(name=u'allAttributeValues', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_allAttributeValues__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _ProtectedItems_allAttributeValues._cont = __ProtectedItems_allAttributeValues__item_
    _ProtectedItems_allAttributeValues._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_allUserAttributeTypesAndValues = NULL(name=u'allUserAttributeTypesAndValues', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ProtectedItems_attributeValue = SET_OF(name=u'attributeValue', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_attributeValue__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeTypeAndValue')))
    _ProtectedItems_attributeValue._cont = __ProtectedItems_attributeValue__item_
    _ProtectedItems_attributeValue._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_selfValue = SET_OF(name=u'selfValue', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_selfValue__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _ProtectedItems_selfValue._cont = __ProtectedItems_selfValue__item_
    _ProtectedItems_selfValue._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_rangeOfValues = CHOICE(name=u'rangeOfValues', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')), opt=True)
    _ProtectedItems_maxValueCount = SET_OF(name=u'maxValueCount', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_maxValueCount__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'MaxValueCount')))
    _ProtectedItems_maxValueCount._cont = __ProtectedItems_maxValueCount__item_
    _ProtectedItems_maxValueCount._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_maxImmSub = INT(name=u'maxImmSub', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ProtectedItems_restrictedBy = SET_OF(name=u'restrictedBy', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_restrictedBy__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'RestrictedValue')))
    _ProtectedItems_restrictedBy._cont = __ProtectedItems_restrictedBy__item_
    _ProtectedItems_restrictedBy._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_contexts = SET_OF(name=u'contexts', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ProtectedItems_contexts__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'ContextAssertion')))
    _ProtectedItems_contexts._cont = __ProtectedItems_contexts__item_
    _ProtectedItems_contexts._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _ProtectedItems_classes = CHOICE(name=u'classes', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Refinement')), opt=True)
    ProtectedItems._cont = ASN1Dict([
        (u'entry', _ProtectedItems_entry),
        (u'allUserAttributeTypes', _ProtectedItems_allUserAttributeTypes),
        (u'attributeType', _ProtectedItems_attributeType),
        (u'allAttributeValues', _ProtectedItems_allAttributeValues),
        (u'allUserAttributeTypesAndValues', _ProtectedItems_allUserAttributeTypesAndValues),
        (u'attributeValue', _ProtectedItems_attributeValue),
        (u'selfValue', _ProtectedItems_selfValue),
        (u'rangeOfValues', _ProtectedItems_rangeOfValues),
        (u'maxValueCount', _ProtectedItems_maxValueCount),
        (u'maxImmSub', _ProtectedItems_maxImmSub),
        (u'restrictedBy', _ProtectedItems_restrictedBy),
        (u'contexts', _ProtectedItems_contexts),
        (u'classes', _ProtectedItems_classes),
        ])
    ProtectedItems._ext = []
    
    #-----< MaxValueCount >-----#
    MaxValueCount = SEQ(name=u'MaxValueCount', mode=MODE_TYPE)
    _MaxValueCount_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _MaxValueCount_maxCount = INT(name=u'maxCount', mode=MODE_TYPE)
    MaxValueCount._cont = ASN1Dict([
        (u'type', _MaxValueCount_type),
        (u'maxCount', _MaxValueCount_maxCount),
        ])
    MaxValueCount._ext = []
    
    #-----< RestrictedValue >-----#
    RestrictedValue = SEQ(name=u'RestrictedValue', mode=MODE_TYPE)
    _RestrictedValue_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _RestrictedValue_valuesIn = OID(name=u'valuesIn', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    RestrictedValue._cont = ASN1Dict([
        (u'type', _RestrictedValue_type),
        (u'valuesIn', _RestrictedValue_valuesIn),
        ])
    RestrictedValue._ext = []
    
    #-----< UserClasses >-----#
    UserClasses = SEQ(name=u'UserClasses', mode=MODE_TYPE)
    _UserClasses_allUsers = NULL(name=u'allUsers', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _UserClasses_thisEntry = NULL(name=u'thisEntry', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _UserClasses_name = SET_OF(name=u'name', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __UserClasses_name__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'NameAndOptionalUID')))
    _UserClasses_name._cont = __UserClasses_name__item_
    _UserClasses_name._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _UserClasses_userGroup = SET_OF(name=u'userGroup', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __UserClasses_userGroup__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'NameAndOptionalUID')))
    _UserClasses_userGroup._cont = __UserClasses_userGroup__item_
    _UserClasses_userGroup._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _UserClasses_subtree = SET_OF(name=u'subtree', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __UserClasses_subtree__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'SubtreeSpecification')))
    _UserClasses_subtree._cont = __UserClasses_subtree__item_
    _UserClasses_subtree._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    UserClasses._cont = ASN1Dict([
        (u'allUsers', _UserClasses_allUsers),
        (u'thisEntry', _UserClasses_thisEntry),
        (u'name', _UserClasses_name),
        (u'userGroup', _UserClasses_userGroup),
        (u'subtree', _UserClasses_subtree),
        ])
    UserClasses._ext = []
    
    #-----< ItemPermission >-----#
    ItemPermission = SEQ(name=u'ItemPermission', mode=MODE_TYPE)
    _ItemPermission_precedence = INT(name=u'precedence', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'Precedence')), opt=True)
    _ItemPermission_userClasses = SEQ(name=u'userClasses', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'UserClasses')))
    _ItemPermission_grantsAndDenials = BIT_STR(name=u'grantsAndDenials', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'GrantsAndDenials')))
    ItemPermission._cont = ASN1Dict([
        (u'precedence', _ItemPermission_precedence),
        (u'userClasses', _ItemPermission_userClasses),
        (u'grantsAndDenials', _ItemPermission_grantsAndDenials),
        ])
    ItemPermission._ext = []
    
    #-----< UserPermission >-----#
    UserPermission = SEQ(name=u'UserPermission', mode=MODE_TYPE)
    _UserPermission_precedence = INT(name=u'precedence', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'Precedence')), opt=True)
    _UserPermission_protectedItems = SEQ(name=u'protectedItems', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ProtectedItems')))
    _UserPermission_grantsAndDenials = BIT_STR(name=u'grantsAndDenials', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'GrantsAndDenials')))
    UserPermission._cont = ASN1Dict([
        (u'precedence', _UserPermission_precedence),
        (u'protectedItems', _UserPermission_protectedItems),
        (u'grantsAndDenials', _UserPermission_grantsAndDenials),
        ])
    UserPermission._ext = []
    
    #-----< AuthenticationLevel >-----#
    AuthenticationLevel = CHOICE(name=u'AuthenticationLevel', mode=MODE_TYPE)
    _AuthenticationLevel_basicLevels = SEQ(name=u'basicLevels', mode=MODE_TYPE)
    __AuthenticationLevel_basicLevels_level = ENUM(name=u'level', mode=MODE_TYPE)
    __AuthenticationLevel_basicLevels_level._cont = ASN1Dict([(u'none', 0), (u'simple', 1), (u'strong', 2)])
    __AuthenticationLevel_basicLevels_level._ext = []
    __AuthenticationLevel_basicLevels_localQualifier = INT(name=u'localQualifier', mode=MODE_TYPE, opt=True)
    __AuthenticationLevel_basicLevels_signed = BOOL(name=u'signed', mode=MODE_TYPE, default=False)
    _AuthenticationLevel_basicLevels._cont = ASN1Dict([
        (u'level', __AuthenticationLevel_basicLevels_level),
        (u'localQualifier', __AuthenticationLevel_basicLevels_localQualifier),
        (u'signed', __AuthenticationLevel_basicLevels_signed),
        ])
    _AuthenticationLevel_basicLevels._ext = []
    _AuthenticationLevel_other = EXT(name=u'other', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    AuthenticationLevel._cont = ASN1Dict([
        (u'basicLevels', _AuthenticationLevel_basicLevels),
        (u'other', _AuthenticationLevel_other),
        ])
    AuthenticationLevel._ext = []
    
    #-----< GrantsAndDenials >-----#
    GrantsAndDenials = BIT_STR(name=u'GrantsAndDenials', mode=MODE_TYPE)
    GrantsAndDenials._cont = ASN1Dict([(u'grantAdd', 0), (u'denyAdd', 1), (u'grantDiscloseOnError', 2), (u'denyDiscloseOnError', 3), (u'grantRead', 4), (u'denyRead', 5), (u'grantRemove', 6), (u'denyRemove', 7), (u'grantBrowse', 8), (u'denyBrowse', 9), (u'grantExport', 10), (u'denyExport', 11), (u'grantImport', 12), (u'denyImport', 13), (u'grantModify', 14), (u'denyModify', 15), (u'grantRename', 16), (u'denyRename', 17), (u'grantReturnDN', 18), (u'denyReturnDN', 19), (u'grantCompare', 20), (u'denyCompare', 21), (u'grantFilterMatch', 22), (u'denyFilterMatch', 23), (u'grantInvoke', 24), (u'denyInvoke', 25)])
    
    #-----< prescriptiveACI >-----#
    prescriptiveACI = CLASS(name=u'prescriptiveACI', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _prescriptiveACI_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ACIItem')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0 = CHOICE(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    prescriptiveACI._val = dict([(u'Type', _prescriptiveACI_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'directoryStringFirstComponentMatch']), (u'id', (2, 5, 13, 31))])), (u'usage', u'directoryOperation'), (u'id', (2, 5, 24, 4))])
    
    #-----< entryACI >-----#
    entryACI = CLASS(name=u'entryACI', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _entryACI_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ACIItem')))
    entryACI._val = dict([(u'Type', _entryACI_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'directoryStringFirstComponentMatch']), (u'id', (2, 5, 13, 31))])), (u'usage', u'directoryOperation'), (u'id', (2, 5, 24, 5))])
    
    #-----< subentryACI >-----#
    subentryACI = CLASS(name=u'subentryACI', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _subentryACI_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('BasicAccessControl', 'ACIItem')))
    subentryACI._val = dict([(u'Type', _subentryACI_val_Type), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 15)), (u'ldapName', [u'directoryStringFirstComponentMatch']), (u'id', (2, 5, 13, 31))])), (u'usage', u'directoryOperation'), (u'id', (2, 5, 24, 6))])
    
    #-----< id-aca-accessControlScheme >-----#
    id_aca_accessControlScheme = OID(name=u'id-aca-accessControlScheme', mode=MODE_VALUE)
    id_aca_accessControlScheme._val = (2, 5, 24, 1)
    
    #-----< id-aca-prescriptiveACI >-----#
    id_aca_prescriptiveACI = OID(name=u'id-aca-prescriptiveACI', mode=MODE_VALUE)
    id_aca_prescriptiveACI._val = (2, 5, 24, 4)
    
    #-----< id-aca-entryACI >-----#
    id_aca_entryACI = OID(name=u'id-aca-entryACI', mode=MODE_VALUE)
    id_aca_entryACI._val = (2, 5, 24, 5)
    
    #-----< id-aca-subentryACI >-----#
    id_aca_subentryACI = OID(name=u'id-aca-subentryACI', mode=MODE_VALUE)
    id_aca_subentryACI._val = (2, 5, 24, 6)
    
    #-----< basicAccessControlScheme >-----#
    basicAccessControlScheme = OID(name=u'basicAccessControlScheme', mode=MODE_VALUE)
    basicAccessControlScheme._val = (2, 5, 28, 1)
    
    #-----< simplifiedAccessControlScheme >-----#
    simplifiedAccessControlScheme = OID(name=u'simplifiedAccessControlScheme', mode=MODE_VALUE)
    simplifiedAccessControlScheme._val = (2, 5, 28, 2)
    
    #-----< rule-based-access-control >-----#
    rule_based_access_control = OID(name=u'rule-based-access-control', mode=MODE_VALUE)
    rule_based_access_control._val = (2, 5, 28, 3)
    
    #-----< rule-and-basic-access-control >-----#
    rule_and_basic_access_control = OID(name=u'rule-and-basic-access-control', mode=MODE_VALUE)
    rule_and_basic_access_control._val = (2, 5, 28, 4)
    
    #-----< rule-and-simple-access-control >-----#
    rule_and_simple_access_control = OID(name=u'rule-and-simple-access-control', mode=MODE_VALUE)
    rule_and_simple_access_control._val = (2, 5, 28, 5)
    
    _all_ = [
        accessControlScheme,
        _accessControlScheme_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType,
        _ACIItem_identificationTag,
        _ACIItem_precedence,
        _ACIItem_authenticationLevel,
        ___ACIItem_itemOrUserFirst_itemFirst_protectedItems,
        ____ACIItem_itemOrUserFirst_itemFirst_itemPermissions__item_,
        ___ACIItem_itemOrUserFirst_itemFirst_itemPermissions,
        __ACIItem_itemOrUserFirst_itemFirst,
        ___ACIItem_itemOrUserFirst_userFirst_userClasses,
        ____ACIItem_itemOrUserFirst_userFirst_userPermissions__item_,
        ___ACIItem_itemOrUserFirst_userFirst_userPermissions,
        __ACIItem_itemOrUserFirst_userFirst,
        _ACIItem_itemOrUserFirst,
        ACIItem,
        Precedence,
        _ProtectedItems_entry,
        _ProtectedItems_allUserAttributeTypes,
        __ProtectedItems_attributeType__item_,
        _ProtectedItems_attributeType,
        __ProtectedItems_allAttributeValues__item_,
        _ProtectedItems_allAttributeValues,
        _ProtectedItems_allUserAttributeTypesAndValues,
        __ProtectedItems_attributeValue__item_,
        _ProtectedItems_attributeValue,
        __ProtectedItems_selfValue__item_,
        _ProtectedItems_selfValue,
        _ProtectedItems_rangeOfValues,
        __ProtectedItems_maxValueCount__item_,
        _ProtectedItems_maxValueCount,
        _ProtectedItems_maxImmSub,
        __ProtectedItems_restrictedBy__item_,
        _ProtectedItems_restrictedBy,
        __ProtectedItems_contexts__item_,
        _ProtectedItems_contexts,
        _ProtectedItems_classes,
        ProtectedItems,
        _MaxValueCount_type,
        _MaxValueCount_maxCount,
        MaxValueCount,
        _RestrictedValue_type,
        _RestrictedValue_valuesIn,
        RestrictedValue,
        _UserClasses_allUsers,
        _UserClasses_thisEntry,
        __UserClasses_name__item_,
        _UserClasses_name,
        __UserClasses_userGroup__item_,
        _UserClasses_userGroup,
        __UserClasses_subtree__item_,
        _UserClasses_subtree,
        UserClasses,
        _ItemPermission_precedence,
        _ItemPermission_userClasses,
        _ItemPermission_grantsAndDenials,
        ItemPermission,
        _UserPermission_precedence,
        _UserPermission_protectedItems,
        _UserPermission_grantsAndDenials,
        UserPermission,
        __AuthenticationLevel_basicLevels_level,
        __AuthenticationLevel_basicLevels_localQualifier,
        __AuthenticationLevel_basicLevels_signed,
        _AuthenticationLevel_basicLevels,
        _AuthenticationLevel_other,
        AuthenticationLevel,
        GrantsAndDenials,
        prescriptiveACI,
        _prescriptiveACI_val_Type,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0,
        entryACI,
        _entryACI_val_Type,
        subentryACI,
        _subentryACI_val_Type,
        id_aca_accessControlScheme,
        id_aca_prescriptiveACI,
        id_aca_entryACI,
        id_aca_subentryACI,
        basicAccessControlScheme,
        simplifiedAccessControlScheme,
        rule_based_access_control,
        rule_and_basic_access_control,
        rule_and_simple_access_control,
    ]

class CertificateExtensions:

    _name_  = u'CertificateExtensions'
    _oid_   = [2, 5, 1, 26, 7]
    
    _obj_ = [
        u'authorityKeyIdentifier',
        u'AuthorityKeyIdentifier',
        u'KeyIdentifier',
        u'subjectKeyIdentifier',
        u'SubjectKeyIdentifier',
        u'keyUsage',
        u'KeyUsage',
        u'extKeyUsage',
        u'KeyPurposeId',
        u'privateKeyUsagePeriod',
        u'PrivateKeyUsagePeriod',
        u'certificatePolicies',
        u'CertificatePoliciesSyntax',
        u'PolicyInformation',
        u'CertPolicyId',
        u'PolicyQualifierInfo',
        u'SupportedPolicyQualifiers',
        u'anyPolicy',
        u'CERT-POLICY-QUALIFIER',
        u'policyMappings',
        u'PolicyMappingsSyntax',
        u'subjectAltName',
        u'GeneralNames',
        u'GeneralName',
        u'OTHER-NAME',
        u'EDIPartyName',
        u'issuerAltName',
        u'subjectDirectoryAttributes',
        u'AttributesSyntax',
        u'basicConstraints',
        u'BasicConstraintsSyntax',
        u'nameConstraints',
        u'NameConstraintsSyntax',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'policyConstraints',
        u'PolicyConstraintsSyntax',
        u'SkipCerts',
        u'inhibitAnyPolicy',
        u'cRLNumber',
        u'CRLNumber',
        u'crlScope',
        u'CRLScopeSyntax',
        u'PerAuthorityScope',
        u'OnlyCertificateTypes',
        u'NumberRange',
        u'BaseRevocationInfo',
        u'statusReferrals',
        u'StatusReferrals',
        u'StatusReferral',
        u'CRLReferral',
        u'DeltaRefInfo',
        u'OTHER-REFERRAL',
        u'cRLStreamIdentifier',
        u'CRLStreamIdentifier',
        u'orderedList',
        u'OrderedListSyntax',
        u'deltaInfo',
        u'DeltaInformation',
        u'toBeRevoked',
        u'ToBeRevokedSyntax',
        u'ToBeRevokedGroup',
        u'ReasonInfo',
        u'CertificateGroup',
        u'CertificateGroupNumberRange',
        u'CertificateSerialNumbers',
        u'revokedGroups',
        u'RevokedGroupsSyntax',
        u'RevokedGroup',
        u'RevokedCertificateGroup',
        u'expiredCertsOnCRL',
        u'ExpiredCertsOnCRL',
        u'reasonCode',
        u'CRLReason',
        u'holdInstructionCode',
        u'HoldInstruction',
        u'invalidityDate',
        u'cRLDistributionPoints',
        u'CRLDistPointsSyntax',
        u'DistributionPoint',
        u'DistributionPointName',
        u'ReasonFlags',
        u'issuingDistributionPoint',
        u'IssuingDistPointSyntax',
        u'certificateIssuer',
        u'deltaCRLIndicator',
        u'BaseCRLNumber',
        u'baseUpdateTime',
        u'freshestCRL',
        u'aAissuingDistributionPoint',
        u'AAIssuingDistPointSyntax',
        u'certificateExactMatch',
        u'CertificateExactAssertion',
        u'certificateMatch',
        u'CertificateAssertion',
        u'AltNameType',
        u'CertPolicySet',
        u'certificatePairExactMatch',
        u'CertificatePairExactAssertion',
        u'certificatePairMatch',
        u'CertificatePairAssertion',
        u'certificateListExactMatch',
        u'CertificateListExactAssertion',
        u'certificateListMatch',
        u'CertificateListAssertion',
        u'algorithmIdentifierMatch',
        u'policyMatch',
        u'pkiPathMatch',
        u'PkiPathMatchSyntax',
        u'enhancedCertificateMatch',
        u'EnhancedCertificateAssertion',
        u'AltName',
        u'certExactAssertion',
        u'certAssertion',
        u'certPairExactAssertion',
        u'certPairAssertion',
        u'certListExactAssertion',
        u'certListAssertion',
        u'algorithmIdentifier',
        u'id-ce-subjectDirectoryAttributes',
        u'id-ce-subjectKeyIdentifier',
        u'id-ce-keyUsage',
        u'id-ce-privateKeyUsagePeriod',
        u'id-ce-subjectAltName',
        u'id-ce-issuerAltName',
        u'id-ce-basicConstraints',
        u'id-ce-cRLNumber',
        u'id-ce-reasonCode',
        u'id-ce-instructionCode',
        u'id-ce-invalidityDate',
        u'id-ce-deltaCRLIndicator',
        u'id-ce-issuingDistributionPoint',
        u'id-ce-certificateIssuer',
        u'id-ce-nameConstraints',
        u'id-ce-cRLDistributionPoints',
        u'id-ce-certificatePolicies',
        u'id-ce-policyMappings',
        u'id-ce-authorityKeyIdentifier',
        u'id-ce-policyConstraints',
        u'id-ce-extKeyUsage',
        u'id-ce-cRLStreamIdentifier',
        u'id-ce-cRLScope',
        u'id-ce-statusReferrals',
        u'id-ce-freshestCRL',
        u'id-ce-orderedList',
        u'id-ce-baseUpdateTime',
        u'id-ce-deltaInfo',
        u'id-ce-inhibitAnyPolicy',
        u'id-ce-toBeRevoked',
        u'id-ce-RevokedGroups',
        u'id-ce-expiredCertsOnCRL',
        u'id-ce-aAissuingDistributionPoint',
        u'id-mr-certificateExactMatch',
        u'id-mr-certificateMatch',
        u'id-mr-certificatePairExactMatch',
        u'id-mr-certificatePairMatch',
        u'id-mr-certificateListExactMatch',
        u'id-mr-certificateListMatch',
        u'id-mr-algorithmIdentifierMatch',
        u'id-mr-policyMatch',
        u'id-mr-pkiPathMatch',
        u'id-mr-enhancedCertificateMatch',
        u'id-ldx-certExactAssertion',
        u'id-ldx-certAssertion',
        u'id-ldx-certPairExactAssertion',
        u'id-ldx-certPairAssertion',
        u'id-ldx-certListExactAssertion',
        u'id-ldx-certListAssertion',
        u'id-ldx-algorithmIdentifier',
        ]
    _type_ = [
        u'AuthorityKeyIdentifier',
        u'KeyIdentifier',
        u'SubjectKeyIdentifier',
        u'KeyUsage',
        u'KeyPurposeId',
        u'PrivateKeyUsagePeriod',
        u'CertificatePoliciesSyntax',
        u'PolicyInformation',
        u'CertPolicyId',
        u'PolicyQualifierInfo',
        u'CERT-POLICY-QUALIFIER',
        u'PolicyMappingsSyntax',
        u'GeneralNames',
        u'GeneralName',
        u'OTHER-NAME',
        u'EDIPartyName',
        u'AttributesSyntax',
        u'BasicConstraintsSyntax',
        u'NameConstraintsSyntax',
        u'GeneralSubtrees',
        u'GeneralSubtree',
        u'BaseDistance',
        u'PolicyConstraintsSyntax',
        u'SkipCerts',
        u'CRLNumber',
        u'CRLScopeSyntax',
        u'PerAuthorityScope',
        u'OnlyCertificateTypes',
        u'NumberRange',
        u'BaseRevocationInfo',
        u'StatusReferrals',
        u'StatusReferral',
        u'CRLReferral',
        u'DeltaRefInfo',
        u'OTHER-REFERRAL',
        u'CRLStreamIdentifier',
        u'OrderedListSyntax',
        u'DeltaInformation',
        u'ToBeRevokedSyntax',
        u'ToBeRevokedGroup',
        u'ReasonInfo',
        u'CertificateGroup',
        u'CertificateGroupNumberRange',
        u'CertificateSerialNumbers',
        u'RevokedGroupsSyntax',
        u'RevokedGroup',
        u'RevokedCertificateGroup',
        u'ExpiredCertsOnCRL',
        u'CRLReason',
        u'HoldInstruction',
        u'CRLDistPointsSyntax',
        u'DistributionPoint',
        u'DistributionPointName',
        u'ReasonFlags',
        u'IssuingDistPointSyntax',
        u'BaseCRLNumber',
        u'AAIssuingDistPointSyntax',
        u'CertificateExactAssertion',
        u'CertificateAssertion',
        u'AltNameType',
        u'CertPolicySet',
        u'CertificatePairExactAssertion',
        u'CertificatePairAssertion',
        u'CertificateListExactAssertion',
        u'CertificateListAssertion',
        u'PkiPathMatchSyntax',
        u'EnhancedCertificateAssertion',
        u'AltName',
        ]
    _set_ = [
        u'SupportedPolicyQualifiers',
        ]
    _val_ = [
        u'authorityKeyIdentifier',
        u'subjectKeyIdentifier',
        u'keyUsage',
        u'extKeyUsage',
        u'privateKeyUsagePeriod',
        u'certificatePolicies',
        u'anyPolicy',
        u'policyMappings',
        u'subjectAltName',
        u'issuerAltName',
        u'subjectDirectoryAttributes',
        u'basicConstraints',
        u'nameConstraints',
        u'policyConstraints',
        u'inhibitAnyPolicy',
        u'cRLNumber',
        u'crlScope',
        u'statusReferrals',
        u'cRLStreamIdentifier',
        u'orderedList',
        u'deltaInfo',
        u'toBeRevoked',
        u'revokedGroups',
        u'expiredCertsOnCRL',
        u'reasonCode',
        u'holdInstructionCode',
        u'invalidityDate',
        u'cRLDistributionPoints',
        u'issuingDistributionPoint',
        u'certificateIssuer',
        u'deltaCRLIndicator',
        u'baseUpdateTime',
        u'freshestCRL',
        u'aAissuingDistributionPoint',
        u'certificateExactMatch',
        u'certificateMatch',
        u'certificatePairExactMatch',
        u'certificatePairMatch',
        u'certificateListExactMatch',
        u'certificateListMatch',
        u'algorithmIdentifierMatch',
        u'policyMatch',
        u'pkiPathMatch',
        u'enhancedCertificateMatch',
        u'certExactAssertion',
        u'certAssertion',
        u'certPairExactAssertion',
        u'certPairAssertion',
        u'certListExactAssertion',
        u'certListAssertion',
        u'algorithmIdentifier',
        u'id-ce-subjectDirectoryAttributes',
        u'id-ce-subjectKeyIdentifier',
        u'id-ce-keyUsage',
        u'id-ce-privateKeyUsagePeriod',
        u'id-ce-subjectAltName',
        u'id-ce-issuerAltName',
        u'id-ce-basicConstraints',
        u'id-ce-cRLNumber',
        u'id-ce-reasonCode',
        u'id-ce-instructionCode',
        u'id-ce-invalidityDate',
        u'id-ce-deltaCRLIndicator',
        u'id-ce-issuingDistributionPoint',
        u'id-ce-certificateIssuer',
        u'id-ce-nameConstraints',
        u'id-ce-cRLDistributionPoints',
        u'id-ce-certificatePolicies',
        u'id-ce-policyMappings',
        u'id-ce-authorityKeyIdentifier',
        u'id-ce-policyConstraints',
        u'id-ce-extKeyUsage',
        u'id-ce-cRLStreamIdentifier',
        u'id-ce-cRLScope',
        u'id-ce-statusReferrals',
        u'id-ce-freshestCRL',
        u'id-ce-orderedList',
        u'id-ce-baseUpdateTime',
        u'id-ce-deltaInfo',
        u'id-ce-inhibitAnyPolicy',
        u'id-ce-toBeRevoked',
        u'id-ce-RevokedGroups',
        u'id-ce-expiredCertsOnCRL',
        u'id-ce-aAissuingDistributionPoint',
        u'id-mr-certificateExactMatch',
        u'id-mr-certificateMatch',
        u'id-mr-certificatePairExactMatch',
        u'id-mr-certificatePairMatch',
        u'id-mr-certificateListExactMatch',
        u'id-mr-certificateListMatch',
        u'id-mr-algorithmIdentifierMatch',
        u'id-mr-policyMatch',
        u'id-mr-pkiPathMatch',
        u'id-mr-enhancedCertificateMatch',
        u'id-ldx-certExactAssertion',
        u'id-ldx-certAssertion',
        u'id-ldx-certPairExactAssertion',
        u'id-ldx-certPairAssertion',
        u'id-ldx-certListExactAssertion',
        u'id-ldx-certListAssertion',
        u'id-ldx-algorithmIdentifier',
        ]
    _class_ = [
        u'authorityKeyIdentifier',
        u'subjectKeyIdentifier',
        u'keyUsage',
        u'extKeyUsage',
        u'privateKeyUsagePeriod',
        u'certificatePolicies',
        u'SupportedPolicyQualifiers',
        u'CERT-POLICY-QUALIFIER',
        u'policyMappings',
        u'subjectAltName',
        u'OTHER-NAME',
        u'issuerAltName',
        u'subjectDirectoryAttributes',
        u'basicConstraints',
        u'nameConstraints',
        u'policyConstraints',
        u'inhibitAnyPolicy',
        u'cRLNumber',
        u'crlScope',
        u'statusReferrals',
        u'OTHER-REFERRAL',
        u'cRLStreamIdentifier',
        u'orderedList',
        u'deltaInfo',
        u'toBeRevoked',
        u'revokedGroups',
        u'expiredCertsOnCRL',
        u'reasonCode',
        u'holdInstructionCode',
        u'invalidityDate',
        u'cRLDistributionPoints',
        u'issuingDistributionPoint',
        u'certificateIssuer',
        u'deltaCRLIndicator',
        u'baseUpdateTime',
        u'freshestCRL',
        u'aAissuingDistributionPoint',
        u'certificateExactMatch',
        u'certificateMatch',
        u'certificatePairExactMatch',
        u'certificatePairMatch',
        u'certificateListExactMatch',
        u'certificateListMatch',
        u'algorithmIdentifierMatch',
        u'policyMatch',
        u'pkiPathMatch',
        u'enhancedCertificateMatch',
        u'certExactAssertion',
        u'certAssertion',
        u'certPairExactAssertion',
        u'certPairAssertion',
        u'certListExactAssertion',
        u'certListAssertion',
        u'algorithmIdentifier',
        ]
    _param_ = [
        ]
    
    #-----< authorityKeyIdentifier >-----#
    authorityKeyIdentifier = CLASS(name=u'authorityKeyIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _authorityKeyIdentifier_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'AuthorityKeyIdentifier')))
    authorityKeyIdentifier._val = dict([(u'ExtnType', _authorityKeyIdentifier_val_ExtnType), (u'id', (2, 5, 29, 35))])
    
    #-----< AuthorityKeyIdentifier >-----#
    AuthorityKeyIdentifier = SEQ(name=u'AuthorityKeyIdentifier', mode=MODE_TYPE)
    _AuthorityKeyIdentifier_keyIdentifier = OCT_STR(name=u'keyIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'KeyIdentifier')), opt=True)
    _AuthorityKeyIdentifier_authorityCertIssuer = SEQ_OF(name=u'authorityCertIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _AuthorityKeyIdentifier_authorityCertSerialNumber = INT(name=u'authorityCertSerialNumber', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')), opt=True)
    AuthorityKeyIdentifier._cont = ASN1Dict([
        (u'keyIdentifier', _AuthorityKeyIdentifier_keyIdentifier),
        (u'authorityCertIssuer', _AuthorityKeyIdentifier_authorityCertIssuer),
        (u'authorityCertSerialNumber', _AuthorityKeyIdentifier_authorityCertSerialNumber),
        ])
    AuthorityKeyIdentifier._ext = []
    
    #-----< KeyIdentifier >-----#
    KeyIdentifier = OCT_STR(name=u'KeyIdentifier', mode=MODE_TYPE)
    
    #-----< subjectKeyIdentifier >-----#
    subjectKeyIdentifier = CLASS(name=u'subjectKeyIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _subjectKeyIdentifier_val_ExtnType = OCT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'SubjectKeyIdentifier')))
    subjectKeyIdentifier._val = dict([(u'ExtnType', _subjectKeyIdentifier_val_ExtnType), (u'id', (2, 5, 29, 14))])
    
    #-----< SubjectKeyIdentifier >-----#
    SubjectKeyIdentifier = OCT_STR(name=u'SubjectKeyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'KeyIdentifier')))
    
    #-----< keyUsage >-----#
    keyUsage = CLASS(name=u'keyUsage', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _keyUsage_val_ExtnType = BIT_STR(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'KeyUsage')))
    keyUsage._val = dict([(u'ExtnType', _keyUsage_val_ExtnType), (u'id', (2, 5, 29, 15))])
    
    #-----< KeyUsage >-----#
    KeyUsage = BIT_STR(name=u'KeyUsage', mode=MODE_TYPE)
    KeyUsage._cont = ASN1Dict([(u'digitalSignature', 0), (u'contentCommitment', 1), (u'keyEncipherment', 2), (u'dataEncipherment', 3), (u'keyAgreement', 4), (u'keyCertSign', 5), (u'cRLSign', 6), (u'encipherOnly', 7), (u'decipherOnly', 8)])
    
    #-----< extKeyUsage >-----#
    extKeyUsage = CLASS(name=u'extKeyUsage', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _extKeyUsage_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE)
    __extKeyUsage_val_ExtnType__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'KeyPurposeId')))
    _extKeyUsage_val_ExtnType._cont = __extKeyUsage_val_ExtnType__item_
    _extKeyUsage_val_ExtnType._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    extKeyUsage._val = dict([(u'ExtnType', _extKeyUsage_val_ExtnType), (u'id', (2, 5, 29, 37))])
    
    #-----< KeyPurposeId >-----#
    KeyPurposeId = OID(name=u'KeyPurposeId', mode=MODE_TYPE)
    
    #-----< privateKeyUsagePeriod >-----#
    privateKeyUsagePeriod = CLASS(name=u'privateKeyUsagePeriod', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _privateKeyUsagePeriod_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PrivateKeyUsagePeriod')))
    privateKeyUsagePeriod._val = dict([(u'ExtnType', _privateKeyUsagePeriod_val_ExtnType), (u'id', (2, 5, 29, 16))])
    
    #-----< PrivateKeyUsagePeriod >-----#
    PrivateKeyUsagePeriod = SEQ(name=u'PrivateKeyUsagePeriod', mode=MODE_TYPE)
    _PrivateKeyUsagePeriod_notBefore = TIME_GEN(name=u'notBefore', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _PrivateKeyUsagePeriod_notAfter = TIME_GEN(name=u'notAfter', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    PrivateKeyUsagePeriod._cont = ASN1Dict([
        (u'notBefore', _PrivateKeyUsagePeriod_notBefore),
        (u'notAfter', _PrivateKeyUsagePeriod_notAfter),
        ])
    PrivateKeyUsagePeriod._ext = []
    
    #-----< certificatePolicies >-----#
    certificatePolicies = CLASS(name=u'certificatePolicies', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _certificatePolicies_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePoliciesSyntax')))
    certificatePolicies._val = dict([(u'ExtnType', _certificatePolicies_val_ExtnType), (u'id', (2, 5, 29, 32))])
    
    #-----< CertificatePoliciesSyntax >-----#
    CertificatePoliciesSyntax = SEQ_OF(name=u'CertificatePoliciesSyntax', mode=MODE_TYPE)
    _CertificatePoliciesSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PolicyInformation')))
    CertificatePoliciesSyntax._cont = _CertificatePoliciesSyntax__item_
    CertificatePoliciesSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PolicyInformation >-----#
    PolicyInformation = SEQ(name=u'PolicyInformation', mode=MODE_TYPE)
    _PolicyInformation_policyIdentifier = OID(name=u'policyIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertPolicyId')))
    _PolicyInformation_policyQualifiers = SEQ_OF(name=u'policyQualifiers', mode=MODE_TYPE, opt=True)
    __PolicyInformation_policyQualifiers__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PolicyQualifierInfo')))
    _PolicyInformation_policyQualifiers._cont = __PolicyInformation_policyQualifiers__item_
    _PolicyInformation_policyQualifiers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    PolicyInformation._cont = ASN1Dict([
        (u'policyIdentifier', _PolicyInformation_policyIdentifier),
        (u'policyQualifiers', _PolicyInformation_policyQualifiers),
        ])
    PolicyInformation._ext = []
    
    #-----< CertPolicyId >-----#
    CertPolicyId = OID(name=u'CertPolicyId', mode=MODE_TYPE)
    
    #-----< PolicyQualifierInfo >-----#
    PolicyQualifierInfo = SEQ(name=u'PolicyQualifierInfo', mode=MODE_TYPE)
    _PolicyQualifierInfo_policyQualifierId = OID(name=u'policyQualifierId', mode=MODE_TYPE, typeref=ASN1RefClassField(('CertificateExtensions', 'CERT-POLICY-QUALIFIER'), [u'id']))
    __PolicyQualifierInfo_policyQualifierId_tab = CLASS(name='_tab_CERT-POLICY-QUALIFIER', mode=MODE_SET, typeref=ASN1RefType(('CertificateExtensions', 'CERT-POLICY-QUALIFIER')))
    __PolicyQualifierInfo_policyQualifierId_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PolicyQualifierInfo_policyQualifierId._const_tab = __PolicyQualifierInfo_policyQualifierId_tab
    _PolicyQualifierInfo_policyQualifierId._const_tab_at = None
    _PolicyQualifierInfo_policyQualifierId._const_tab_id = u'id'
    _PolicyQualifierInfo_qualifier = OPEN(name=u'qualifier', mode=MODE_TYPE, typeref=ASN1RefClassField(('CertificateExtensions', 'CERT-POLICY-QUALIFIER'), [u'Qualifier']), opt=True)
    __PolicyQualifierInfo_qualifier_tab = CLASS(name='_tab_CERT-POLICY-QUALIFIER', mode=MODE_SET, typeref=ASN1RefType(('CertificateExtensions', 'CERT-POLICY-QUALIFIER')))
    __PolicyQualifierInfo_qualifier_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _PolicyQualifierInfo_qualifier._const_tab = __PolicyQualifierInfo_qualifier_tab
    _PolicyQualifierInfo_qualifier._const_tab_at = ('..', u'policyQualifierId')
    _PolicyQualifierInfo_qualifier._const_tab_id = u'Qualifier'
    PolicyQualifierInfo._cont = ASN1Dict([
        (u'policyQualifierId', _PolicyQualifierInfo_policyQualifierId),
        (u'qualifier', _PolicyQualifierInfo_qualifier),
        ])
    PolicyQualifierInfo._ext = []
    
    #-----< SupportedPolicyQualifiers >-----#
    SupportedPolicyQualifiers = CLASS(name=u'SupportedPolicyQualifiers', mode=MODE_SET, typeref=ASN1RefType(('CertificateExtensions', 'CERT-POLICY-QUALIFIER')))
    SupportedPolicyQualifiers._val = ASN1Set(rv=[], rr=[], ev=[], er=[])
    
    #-----< anyPolicy >-----#
    anyPolicy = OID(name=u'anyPolicy', mode=MODE_VALUE)
    anyPolicy._val = (2, 5, 29, 32, 0)
    
    #-----< CERT-POLICY-QUALIFIER >-----#
    CERT_POLICY_QUALIFIER = CLASS(name=u'CERT-POLICY-QUALIFIER', mode=MODE_TYPE)
    _CERT_POLICY_QUALIFIER_id = OID(name=u'id', mode=MODE_VALUE, uniq=True)
    _CERT_POLICY_QUALIFIER_Qualifier = OPEN(name=u'Qualifier', mode=MODE_TYPE, opt=True)
    CERT_POLICY_QUALIFIER._cont = ASN1Dict([
        (u'id', _CERT_POLICY_QUALIFIER_id),
        (u'Qualifier', _CERT_POLICY_QUALIFIER_Qualifier),
        ])
    
    #-----< policyMappings >-----#
    policyMappings = CLASS(name=u'policyMappings', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _policyMappings_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PolicyMappingsSyntax')))
    policyMappings._val = dict([(u'ExtnType', _policyMappings_val_ExtnType), (u'id', (2, 5, 29, 33))])
    
    #-----< PolicyMappingsSyntax >-----#
    PolicyMappingsSyntax = SEQ_OF(name=u'PolicyMappingsSyntax', mode=MODE_TYPE)
    _PolicyMappingsSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __PolicyMappingsSyntax__item__issuerDomainPolicy = OID(name=u'issuerDomainPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertPolicyId')))
    __PolicyMappingsSyntax__item__subjectDomainPolicy = OID(name=u'subjectDomainPolicy', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertPolicyId')))
    _PolicyMappingsSyntax__item_._cont = ASN1Dict([
        (u'issuerDomainPolicy', __PolicyMappingsSyntax__item__issuerDomainPolicy),
        (u'subjectDomainPolicy', __PolicyMappingsSyntax__item__subjectDomainPolicy),
        ])
    _PolicyMappingsSyntax__item_._ext = []
    PolicyMappingsSyntax._cont = _PolicyMappingsSyntax__item_
    PolicyMappingsSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< subjectAltName >-----#
    subjectAltName = CLASS(name=u'subjectAltName', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _subjectAltName_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    subjectAltName._val = dict([(u'ExtnType', _subjectAltName_val_ExtnType), (u'id', (2, 5, 29, 17))])
    
    #-----< GeneralNames >-----#
    GeneralNames = SEQ_OF(name=u'GeneralNames', mode=MODE_TYPE)
    _GeneralNames__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    GeneralNames._cont = _GeneralNames__item_
    GeneralNames._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralName >-----#
    GeneralName = CHOICE(name=u'GeneralName', mode=MODE_TYPE)
    _GeneralName_otherName = SEQ(name=u'otherName', mode=MODE_TYPE)
    __GeneralName_otherName_type_id = OID(name='type-id', mode=MODE_TYPE, typeref=ASN1RefClassField(('CertificateExtensions', 'OTHER-NAME'), ['id']))
    __GeneralName_otherName_value = OPEN(name='value', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('CertificateExtensions', 'OTHER-NAME'), ['Type']))
    _GeneralName_otherName._cont = ASN1Dict([
        ('type-id', __GeneralName_otherName_type_id),
        ('value', __GeneralName_otherName_value),
        ])
    _GeneralName_otherName._ext = None
    _GeneralName_otherName.TAG = 8
    _GeneralName_rfc822Name = STR_IA5(name=u'rfc822Name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_dNSName = STR_IA5(name=u'dNSName', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_x400Address = SEQ(name=u'x400Address', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('MTSAbstractService', 'ORAddress')))
    _GeneralName_directoryName = CHOICE(name=u'directoryName', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _GeneralName_ediPartyName = SEQ(name=u'ediPartyName', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'EDIPartyName')))
    _GeneralName_uniformResourceIdentifier = STR_IA5(name=u'uniformResourceIdentifier', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_iPAddress = OCT_STR(name=u'iPAddress', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _GeneralName_registeredID = OID(name=u'registeredID', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    GeneralName._cont = ASN1Dict([
        (u'otherName', _GeneralName_otherName),
        (u'rfc822Name', _GeneralName_rfc822Name),
        (u'dNSName', _GeneralName_dNSName),
        (u'x400Address', _GeneralName_x400Address),
        (u'directoryName', _GeneralName_directoryName),
        (u'ediPartyName', _GeneralName_ediPartyName),
        (u'uniformResourceIdentifier', _GeneralName_uniformResourceIdentifier),
        (u'iPAddress', _GeneralName_iPAddress),
        (u'registeredID', _GeneralName_registeredID),
        ])
    GeneralName._ext = []
    
    #-----< OTHER-NAME >-----#
    OTHER_NAME = CLASS(name=u'OTHER-NAME', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< EDIPartyName >-----#
    EDIPartyName = SEQ(name=u'EDIPartyName', mode=MODE_TYPE)
    _EDIPartyName_nameAssigner = CHOICE(name=u'nameAssigner', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')), opt=True)
    _EDIPartyName_partyName = CHOICE(name=u'partyName', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    EDIPartyName._cont = ASN1Dict([
        (u'nameAssigner', _EDIPartyName_nameAssigner),
        (u'partyName', _EDIPartyName_partyName),
        ])
    EDIPartyName._ext = []
    
    #-----< issuerAltName >-----#
    issuerAltName = CLASS(name=u'issuerAltName', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _issuerAltName_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    issuerAltName._val = dict([(u'ExtnType', _issuerAltName_val_ExtnType), (u'id', (2, 5, 29, 18))])
    
    #-----< subjectDirectoryAttributes >-----#
    subjectDirectoryAttributes = CLASS(name=u'subjectDirectoryAttributes', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _subjectDirectoryAttributes_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'AttributesSyntax')))
    subjectDirectoryAttributes._val = dict([(u'ExtnType', _subjectDirectoryAttributes_val_ExtnType), (u'id', (2, 5, 29, 9))])
    
    #-----< AttributesSyntax >-----#
    AttributesSyntax = SEQ_OF(name=u'AttributesSyntax', mode=MODE_TYPE)
    _AttributesSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    __AttributesSyntax__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ___AttributesSyntax__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ____AttributesSyntax__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE)
    ____AttributesSyntax__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0 = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ___AttributesSyntax__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', ____AttributesSyntax__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ____AttributesSyntax__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    __AttributesSyntax__item__type._const_tab = ___AttributesSyntax__item__type_tab
    __AttributesSyntax__item__type._const_tab_at = None
    __AttributesSyntax__item__type._const_tab_id = u'id'
    __AttributesSyntax__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ___AttributesSyntax__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ___AttributesSyntax__item__values__item_._const_tab = ___AttributesSyntax__item__type_tab
    ___AttributesSyntax__item__values__item_._const_tab_at = ('..', '..', u'type')
    ___AttributesSyntax__item__values__item_._const_tab_id = u'Type'
    __AttributesSyntax__item__values._cont = ___AttributesSyntax__item__values__item_
    __AttributesSyntax__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    __AttributesSyntax__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ___AttributesSyntax__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ____AttributesSyntax__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____AttributesSyntax__item__valuesWithContext__item__value._const_tab = ___AttributesSyntax__item__type_tab
    ____AttributesSyntax__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ____AttributesSyntax__item__valuesWithContext__item__value._const_tab_id = u'Type'
    ____AttributesSyntax__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _____AttributesSyntax__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ____AttributesSyntax__item__valuesWithContext__item__contextList._cont = _____AttributesSyntax__item__valuesWithContext__item__contextList__item_
    ____AttributesSyntax__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___AttributesSyntax__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ____AttributesSyntax__item__valuesWithContext__item__value),
        (u'contextList', ____AttributesSyntax__item__valuesWithContext__item__contextList),
        ])
    ___AttributesSyntax__item__valuesWithContext__item_._ext = []
    __AttributesSyntax__item__valuesWithContext._cont = ___AttributesSyntax__item__valuesWithContext__item_
    __AttributesSyntax__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _AttributesSyntax__item_._cont = ASN1Dict([
        (u'type', __AttributesSyntax__item__type),
        (u'values', __AttributesSyntax__item__values),
        (u'valuesWithContext', __AttributesSyntax__item__valuesWithContext),
        ])
    _AttributesSyntax__item_._ext = []
    AttributesSyntax._cont = _AttributesSyntax__item_
    AttributesSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< basicConstraints >-----#
    basicConstraints = CLASS(name=u'basicConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _basicConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'BasicConstraintsSyntax')))
    basicConstraints._val = dict([(u'ExtnType', _basicConstraints_val_ExtnType), (u'id', (2, 5, 29, 19))])
    
    #-----< BasicConstraintsSyntax >-----#
    BasicConstraintsSyntax = SEQ(name=u'BasicConstraintsSyntax', mode=MODE_TYPE)
    _BasicConstraintsSyntax_cA = BOOL(name=u'cA', mode=MODE_TYPE, default=False)
    _BasicConstraintsSyntax_pathLenConstraint = INT(name=u'pathLenConstraint', mode=MODE_TYPE, opt=True)
    _BasicConstraintsSyntax_pathLenConstraint._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    BasicConstraintsSyntax._cont = ASN1Dict([
        (u'cA', _BasicConstraintsSyntax_cA),
        (u'pathLenConstraint', _BasicConstraintsSyntax_pathLenConstraint),
        ])
    BasicConstraintsSyntax._ext = []
    
    #-----< nameConstraints >-----#
    nameConstraints = CLASS(name=u'nameConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _nameConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'NameConstraintsSyntax')))
    nameConstraints._val = dict([(u'ExtnType', _nameConstraints_val_ExtnType), (u'id', (2, 5, 29, 30))])
    
    #-----< NameConstraintsSyntax >-----#
    NameConstraintsSyntax = SEQ(name=u'NameConstraintsSyntax', mode=MODE_TYPE)
    _NameConstraintsSyntax_permittedSubtrees = SEQ_OF(name=u'permittedSubtrees', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralSubtrees')), opt=True)
    _NameConstraintsSyntax_excludedSubtrees = SEQ_OF(name=u'excludedSubtrees', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralSubtrees')), opt=True)
    NameConstraintsSyntax._cont = ASN1Dict([
        (u'permittedSubtrees', _NameConstraintsSyntax_permittedSubtrees),
        (u'excludedSubtrees', _NameConstraintsSyntax_excludedSubtrees),
        ])
    NameConstraintsSyntax._ext = []
    
    #-----< GeneralSubtrees >-----#
    GeneralSubtrees = SEQ_OF(name=u'GeneralSubtrees', mode=MODE_TYPE)
    _GeneralSubtrees__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralSubtree')))
    GeneralSubtrees._cont = _GeneralSubtrees__item_
    GeneralSubtrees._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< GeneralSubtree >-----#
    GeneralSubtree = SEQ(name=u'GeneralSubtree', mode=MODE_TYPE)
    _GeneralSubtree_base = CHOICE(name=u'base', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _GeneralSubtree_minimum = INT(name=u'minimum', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'BaseDistance')), default=0)
    _GeneralSubtree_maximum = INT(name=u'maximum', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'BaseDistance')), opt=True)
    GeneralSubtree._cont = ASN1Dict([
        (u'base', _GeneralSubtree_base),
        (u'minimum', _GeneralSubtree_minimum),
        (u'maximum', _GeneralSubtree_maximum),
        ])
    GeneralSubtree._ext = []
    
    #-----< BaseDistance >-----#
    BaseDistance = INT(name=u'BaseDistance', mode=MODE_TYPE)
    BaseDistance._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< policyConstraints >-----#
    policyConstraints = CLASS(name=u'policyConstraints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _policyConstraints_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PolicyConstraintsSyntax')))
    policyConstraints._val = dict([(u'ExtnType', _policyConstraints_val_ExtnType), (u'id', (2, 5, 29, 36))])
    
    #-----< PolicyConstraintsSyntax >-----#
    PolicyConstraintsSyntax = SEQ(name=u'PolicyConstraintsSyntax', mode=MODE_TYPE)
    _PolicyConstraintsSyntax_requireExplicitPolicy = INT(name=u'requireExplicitPolicy', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'SkipCerts')), opt=True)
    _PolicyConstraintsSyntax_inhibitPolicyMapping = INT(name=u'inhibitPolicyMapping', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'SkipCerts')), opt=True)
    PolicyConstraintsSyntax._cont = ASN1Dict([
        (u'requireExplicitPolicy', _PolicyConstraintsSyntax_requireExplicitPolicy),
        (u'inhibitPolicyMapping', _PolicyConstraintsSyntax_inhibitPolicyMapping),
        ])
    PolicyConstraintsSyntax._ext = []
    
    #-----< SkipCerts >-----#
    SkipCerts = INT(name=u'SkipCerts', mode=MODE_TYPE)
    SkipCerts._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< inhibitAnyPolicy >-----#
    inhibitAnyPolicy = CLASS(name=u'inhibitAnyPolicy', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _inhibitAnyPolicy_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'SkipCerts')))
    inhibitAnyPolicy._val = dict([(u'ExtnType', _inhibitAnyPolicy_val_ExtnType), (u'id', (2, 5, 29, 54))])
    
    #-----< cRLNumber >-----#
    cRLNumber = CLASS(name=u'cRLNumber', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _cRLNumber_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLNumber')))
    cRLNumber._val = dict([(u'ExtnType', _cRLNumber_val_ExtnType), (u'id', (2, 5, 29, 20))])
    
    #-----< CRLNumber >-----#
    CRLNumber = INT(name=u'CRLNumber', mode=MODE_TYPE)
    CRLNumber._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< crlScope >-----#
    crlScope = CLASS(name=u'crlScope', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _crlScope_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLScopeSyntax')))
    crlScope._val = dict([(u'ExtnType', _crlScope_val_ExtnType), (u'id', (2, 5, 29, 44))])
    
    #-----< CRLScopeSyntax >-----#
    CRLScopeSyntax = SEQ_OF(name=u'CRLScopeSyntax', mode=MODE_TYPE)
    _CRLScopeSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PerAuthorityScope')))
    CRLScopeSyntax._cont = _CRLScopeSyntax__item_
    CRLScopeSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< PerAuthorityScope >-----#
    PerAuthorityScope = SEQ(name=u'PerAuthorityScope', mode=MODE_TYPE)
    _PerAuthorityScope_authorityName = CHOICE(name=u'authorityName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _PerAuthorityScope_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    _PerAuthorityScope_onlyContains = BIT_STR(name=u'onlyContains', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'OnlyCertificateTypes')), opt=True)
    _PerAuthorityScope_onlySomeReasons = BIT_STR(name=u'onlySomeReasons', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonFlags')), opt=True)
    _PerAuthorityScope_serialNumberRange = SEQ(name=u'serialNumberRange', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'NumberRange')), opt=True)
    _PerAuthorityScope_subjectKeyIdRange = SEQ(name=u'subjectKeyIdRange', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'NumberRange')), opt=True)
    _PerAuthorityScope_nameSubtrees = SEQ_OF(name=u'nameSubtrees', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _PerAuthorityScope_baseRevocationInfo = SEQ(name=u'baseRevocationInfo', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'BaseRevocationInfo')), opt=True)
    PerAuthorityScope._cont = ASN1Dict([
        (u'authorityName', _PerAuthorityScope_authorityName),
        (u'distributionPoint', _PerAuthorityScope_distributionPoint),
        (u'onlyContains', _PerAuthorityScope_onlyContains),
        (u'onlySomeReasons', _PerAuthorityScope_onlySomeReasons),
        (u'serialNumberRange', _PerAuthorityScope_serialNumberRange),
        (u'subjectKeyIdRange', _PerAuthorityScope_subjectKeyIdRange),
        (u'nameSubtrees', _PerAuthorityScope_nameSubtrees),
        (u'baseRevocationInfo', _PerAuthorityScope_baseRevocationInfo),
        ])
    PerAuthorityScope._ext = []
    
    #-----< OnlyCertificateTypes >-----#
    OnlyCertificateTypes = BIT_STR(name=u'OnlyCertificateTypes', mode=MODE_TYPE)
    OnlyCertificateTypes._cont = ASN1Dict([(u'user', 0), (u'authority', 1), (u'attribute', 2)])
    
    #-----< NumberRange >-----#
    NumberRange = SEQ(name=u'NumberRange', mode=MODE_TYPE)
    _NumberRange_startingNumber = INT(name=u'startingNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NumberRange_endingNumber = INT(name=u'endingNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _NumberRange_modulus = INT(name=u'modulus', mode=MODE_TYPE, opt=True)
    NumberRange._cont = ASN1Dict([
        (u'startingNumber', _NumberRange_startingNumber),
        (u'endingNumber', _NumberRange_endingNumber),
        (u'modulus', _NumberRange_modulus),
        ])
    NumberRange._ext = []
    
    #-----< BaseRevocationInfo >-----#
    BaseRevocationInfo = SEQ(name=u'BaseRevocationInfo', mode=MODE_TYPE)
    _BaseRevocationInfo_cRLStreamIdentifier = INT(name=u'cRLStreamIdentifier', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CRLStreamIdentifier')), opt=True)
    _BaseRevocationInfo_cRLNumber = INT(name=u'cRLNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CRLNumber')))
    _BaseRevocationInfo_baseThisUpdate = TIME_GEN(name=u'baseThisUpdate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    BaseRevocationInfo._cont = ASN1Dict([
        (u'cRLStreamIdentifier', _BaseRevocationInfo_cRLStreamIdentifier),
        (u'cRLNumber', _BaseRevocationInfo_cRLNumber),
        (u'baseThisUpdate', _BaseRevocationInfo_baseThisUpdate),
        ])
    BaseRevocationInfo._ext = []
    
    #-----< statusReferrals >-----#
    statusReferrals = CLASS(name=u'statusReferrals', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _statusReferrals_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'StatusReferrals')))
    statusReferrals._val = dict([(u'ExtnType', _statusReferrals_val_ExtnType), (u'id', (2, 5, 29, 45))])
    
    #-----< StatusReferrals >-----#
    StatusReferrals = SEQ_OF(name=u'StatusReferrals', mode=MODE_TYPE)
    _StatusReferrals__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'StatusReferral')))
    StatusReferrals._cont = _StatusReferrals__item_
    StatusReferrals._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< StatusReferral >-----#
    StatusReferral = CHOICE(name=u'StatusReferral', mode=MODE_TYPE)
    _StatusReferral_cRLReferral = SEQ(name=u'cRLReferral', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CRLReferral')))
    _StatusReferral_otherReferral = SEQ(name=u'otherReferral', mode=MODE_TYPE)
    __StatusReferral_otherReferral_type_id = OID(name='type-id', mode=MODE_TYPE, typeref=ASN1RefClassField(('CertificateExtensions', 'OTHER-REFERRAL'), ['id']))
    __StatusReferral_otherReferral_value = OPEN(name='value', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('CertificateExtensions', 'OTHER-REFERRAL'), ['Type']))
    _StatusReferral_otherReferral._cont = ASN1Dict([
        ('type-id', __StatusReferral_otherReferral_type_id),
        ('value', __StatusReferral_otherReferral_value),
        ])
    _StatusReferral_otherReferral._ext = None
    _StatusReferral_otherReferral.TAG = 8
    StatusReferral._cont = ASN1Dict([
        (u'cRLReferral', _StatusReferral_cRLReferral),
        (u'otherReferral', _StatusReferral_otherReferral),
        ])
    StatusReferral._ext = []
    
    #-----< CRLReferral >-----#
    CRLReferral = SEQ(name=u'CRLReferral', mode=MODE_TYPE)
    _CRLReferral_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _CRLReferral_location = CHOICE(name=u'location', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _CRLReferral_deltaRefInfo = SEQ(name=u'deltaRefInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DeltaRefInfo')), opt=True)
    _CRLReferral_cRLScope = SEQ_OF(name=u'cRLScope', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLScopeSyntax')))
    _CRLReferral_lastUpdate = TIME_GEN(name=u'lastUpdate', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CRLReferral_lastChangedCRL = TIME_GEN(name=u'lastChangedCRL', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    CRLReferral._cont = ASN1Dict([
        (u'issuer', _CRLReferral_issuer),
        (u'location', _CRLReferral_location),
        (u'deltaRefInfo', _CRLReferral_deltaRefInfo),
        (u'cRLScope', _CRLReferral_cRLScope),
        (u'lastUpdate', _CRLReferral_lastUpdate),
        (u'lastChangedCRL', _CRLReferral_lastChangedCRL),
        ])
    CRLReferral._ext = []
    
    #-----< DeltaRefInfo >-----#
    DeltaRefInfo = SEQ(name=u'DeltaRefInfo', mode=MODE_TYPE)
    _DeltaRefInfo_deltaLocation = CHOICE(name=u'deltaLocation', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _DeltaRefInfo_lastDelta = TIME_GEN(name=u'lastDelta', mode=MODE_TYPE, opt=True)
    DeltaRefInfo._cont = ASN1Dict([
        (u'deltaLocation', _DeltaRefInfo_deltaLocation),
        (u'lastDelta', _DeltaRefInfo_lastDelta),
        ])
    DeltaRefInfo._ext = []
    
    #-----< OTHER-REFERRAL >-----#
    OTHER_REFERRAL = CLASS(name=u'OTHER-REFERRAL', mode=MODE_TYPE, typeref=ASN1RefType(('_IMPL_', u'TYPE-IDENTIFIER'), []))
    
    #-----< cRLStreamIdentifier >-----#
    cRLStreamIdentifier = CLASS(name=u'cRLStreamIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _cRLStreamIdentifier_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLStreamIdentifier')))
    cRLStreamIdentifier._val = dict([(u'ExtnType', _cRLStreamIdentifier_val_ExtnType), (u'id', (2, 5, 29, 40))])
    
    #-----< CRLStreamIdentifier >-----#
    CRLStreamIdentifier = INT(name=u'CRLStreamIdentifier', mode=MODE_TYPE)
    CRLStreamIdentifier._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    
    #-----< orderedList >-----#
    orderedList = CLASS(name=u'orderedList', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _orderedList_val_ExtnType = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'OrderedListSyntax')))
    orderedList._val = dict([(u'ExtnType', _orderedList_val_ExtnType), (u'id', (2, 5, 29, 47))])
    
    #-----< OrderedListSyntax >-----#
    OrderedListSyntax = ENUM(name=u'OrderedListSyntax', mode=MODE_TYPE)
    OrderedListSyntax._cont = ASN1Dict([(u'ascSerialNum', 0), (u'ascRevDate', 1)])
    OrderedListSyntax._ext = []
    
    #-----< deltaInfo >-----#
    deltaInfo = CLASS(name=u'deltaInfo', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _deltaInfo_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'DeltaInformation')))
    deltaInfo._val = dict([(u'ExtnType', _deltaInfo_val_ExtnType), (u'id', (2, 5, 29, 53))])
    
    #-----< DeltaInformation >-----#
    DeltaInformation = SEQ(name=u'DeltaInformation', mode=MODE_TYPE)
    _DeltaInformation_deltaLocation = CHOICE(name=u'deltaLocation', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    _DeltaInformation_nextDelta = TIME_GEN(name=u'nextDelta', mode=MODE_TYPE, opt=True)
    DeltaInformation._cont = ASN1Dict([
        (u'deltaLocation', _DeltaInformation_deltaLocation),
        (u'nextDelta', _DeltaInformation_nextDelta),
        ])
    DeltaInformation._ext = []
    
    #-----< toBeRevoked >-----#
    toBeRevoked = CLASS(name=u'toBeRevoked', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _toBeRevoked_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'ToBeRevokedSyntax')))
    toBeRevoked._val = dict([(u'ExtnType', _toBeRevoked_val_ExtnType), (u'id', (2, 5, 29, 58))])
    
    #-----< ToBeRevokedSyntax >-----#
    ToBeRevokedSyntax = SEQ_OF(name=u'ToBeRevokedSyntax', mode=MODE_TYPE)
    _ToBeRevokedSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'ToBeRevokedGroup')))
    ToBeRevokedSyntax._cont = _ToBeRevokedSyntax__item_
    ToBeRevokedSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< ToBeRevokedGroup >-----#
    ToBeRevokedGroup = SEQ(name=u'ToBeRevokedGroup', mode=MODE_TYPE)
    _ToBeRevokedGroup_certificateIssuer = CHOICE(name=u'certificateIssuer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _ToBeRevokedGroup_reasonInfo = SEQ(name=u'reasonInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonInfo')), opt=True)
    _ToBeRevokedGroup_revocationTime = TIME_GEN(name=u'revocationTime', mode=MODE_TYPE)
    _ToBeRevokedGroup_certificateGroup = CHOICE(name=u'certificateGroup', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateGroup')))
    ToBeRevokedGroup._cont = ASN1Dict([
        (u'certificateIssuer', _ToBeRevokedGroup_certificateIssuer),
        (u'reasonInfo', _ToBeRevokedGroup_reasonInfo),
        (u'revocationTime', _ToBeRevokedGroup_revocationTime),
        (u'certificateGroup', _ToBeRevokedGroup_certificateGroup),
        ])
    ToBeRevokedGroup._ext = []
    
    #-----< ReasonInfo >-----#
    ReasonInfo = SEQ(name=u'ReasonInfo', mode=MODE_TYPE)
    _ReasonInfo_reasonCode = ENUM(name=u'reasonCode', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLReason')))
    _ReasonInfo_holdInstructionCode = OID(name=u'holdInstructionCode', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'HoldInstruction')), opt=True)
    ReasonInfo._cont = ASN1Dict([
        (u'reasonCode', _ReasonInfo_reasonCode),
        (u'holdInstructionCode', _ReasonInfo_holdInstructionCode),
        ])
    ReasonInfo._ext = []
    
    #-----< CertificateGroup >-----#
    CertificateGroup = CHOICE(name=u'CertificateGroup', mode=MODE_TYPE)
    _CertificateGroup_serialNumbers = SEQ_OF(name=u'serialNumbers', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateSerialNumbers')))
    _CertificateGroup_serialNumberRange = SEQ(name=u'serialNumberRange', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateGroupNumberRange')))
    _CertificateGroup_nameSubtree = CHOICE(name=u'nameSubtree', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    CertificateGroup._cont = ASN1Dict([
        (u'serialNumbers', _CertificateGroup_serialNumbers),
        (u'serialNumberRange', _CertificateGroup_serialNumberRange),
        (u'nameSubtree', _CertificateGroup_nameSubtree),
        ])
    CertificateGroup._ext = []
    
    #-----< CertificateGroupNumberRange >-----#
    CertificateGroupNumberRange = SEQ(name=u'CertificateGroupNumberRange', mode=MODE_TYPE)
    _CertificateGroupNumberRange_startingNumber = INT(name=u'startingNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    _CertificateGroupNumberRange_endingNumber = INT(name=u'endingNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT))
    CertificateGroupNumberRange._cont = ASN1Dict([
        (u'startingNumber', _CertificateGroupNumberRange_startingNumber),
        (u'endingNumber', _CertificateGroupNumberRange_endingNumber),
        ])
    CertificateGroupNumberRange._ext = []
    
    #-----< CertificateSerialNumbers >-----#
    CertificateSerialNumbers = SEQ_OF(name=u'CertificateSerialNumbers', mode=MODE_TYPE)
    _CertificateSerialNumbers__item_ = INT(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    CertificateSerialNumbers._cont = _CertificateSerialNumbers__item_
    CertificateSerialNumbers._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< revokedGroups >-----#
    revokedGroups = CLASS(name=u'revokedGroups', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _revokedGroups_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'RevokedGroupsSyntax')))
    revokedGroups._val = dict([(u'ExtnType', _revokedGroups_val_ExtnType), (u'id', (2, 5, 29, 59))])
    
    #-----< RevokedGroupsSyntax >-----#
    RevokedGroupsSyntax = SEQ_OF(name=u'RevokedGroupsSyntax', mode=MODE_TYPE)
    _RevokedGroupsSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'RevokedGroup')))
    RevokedGroupsSyntax._cont = _RevokedGroupsSyntax__item_
    RevokedGroupsSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< RevokedGroup >-----#
    RevokedGroup = SEQ(name=u'RevokedGroup', mode=MODE_TYPE)
    _RevokedGroup_certificateIssuer = CHOICE(name=u'certificateIssuer', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    _RevokedGroup_reasonInfo = SEQ(name=u'reasonInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonInfo')), opt=True)
    _RevokedGroup_invalidityDate = TIME_GEN(name=u'invalidityDate', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _RevokedGroup_revokedcertificateGroup = CHOICE(name=u'revokedcertificateGroup', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'RevokedCertificateGroup')))
    RevokedGroup._cont = ASN1Dict([
        (u'certificateIssuer', _RevokedGroup_certificateIssuer),
        (u'reasonInfo', _RevokedGroup_reasonInfo),
        (u'invalidityDate', _RevokedGroup_invalidityDate),
        (u'revokedcertificateGroup', _RevokedGroup_revokedcertificateGroup),
        ])
    RevokedGroup._ext = []
    
    #-----< RevokedCertificateGroup >-----#
    RevokedCertificateGroup = CHOICE(name=u'RevokedCertificateGroup', mode=MODE_TYPE)
    _RevokedCertificateGroup_serialNumberRange = SEQ(name=u'serialNumberRange', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'NumberRange')))
    _RevokedCertificateGroup_nameSubtree = CHOICE(name=u'nameSubtree', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')))
    RevokedCertificateGroup._cont = ASN1Dict([
        (u'serialNumberRange', _RevokedCertificateGroup_serialNumberRange),
        (u'nameSubtree', _RevokedCertificateGroup_nameSubtree),
        ])
    RevokedCertificateGroup._ext = None
    
    #-----< expiredCertsOnCRL >-----#
    expiredCertsOnCRL = CLASS(name=u'expiredCertsOnCRL', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _expiredCertsOnCRL_val_ExtnType = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'ExpiredCertsOnCRL')))
    expiredCertsOnCRL._val = dict([(u'ExtnType', _expiredCertsOnCRL_val_ExtnType), (u'id', (2, 5, 29, 60))])
    
    #-----< ExpiredCertsOnCRL >-----#
    ExpiredCertsOnCRL = TIME_GEN(name=u'ExpiredCertsOnCRL', mode=MODE_TYPE)
    
    #-----< reasonCode >-----#
    reasonCode = CLASS(name=u'reasonCode', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _reasonCode_val_ExtnType = ENUM(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLReason')))
    reasonCode._val = dict([(u'ExtnType', _reasonCode_val_ExtnType), (u'id', (2, 5, 29, 21))])
    
    #-----< CRLReason >-----#
    CRLReason = ENUM(name=u'CRLReason', mode=MODE_TYPE)
    CRLReason._cont = ASN1Dict([(u'unspecified', 0), (u'keyCompromise', 1), (u'cACompromise', 2), (u'affiliationChanged', 3), (u'superseded', 4), (u'cessationOfOperation', 5), (u'certificateHold', 6), (u'removeFromCRL', 8), (u'privilegeWithdrawn', 9), (u'aACompromise', 10), (u'weakAlgorithmOrKey', 11)])
    CRLReason._ext = [u'weakAlgorithmOrKey']
    
    #-----< holdInstructionCode >-----#
    holdInstructionCode = CLASS(name=u'holdInstructionCode', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _holdInstructionCode_val_ExtnType = OID(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'HoldInstruction')))
    holdInstructionCode._val = dict([(u'ExtnType', _holdInstructionCode_val_ExtnType), (u'id', (2, 5, 29, 23))])
    
    #-----< HoldInstruction >-----#
    HoldInstruction = OID(name=u'HoldInstruction', mode=MODE_TYPE)
    
    #-----< invalidityDate >-----#
    invalidityDate = CLASS(name=u'invalidityDate', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _invalidityDate_val_ExtnType = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    invalidityDate._val = dict([(u'ExtnType', _invalidityDate_val_ExtnType), (u'id', (2, 5, 29, 24))])
    
    #-----< cRLDistributionPoints >-----#
    cRLDistributionPoints = CLASS(name=u'cRLDistributionPoints', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _cRLDistributionPoints_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLDistPointsSyntax')))
    cRLDistributionPoints._val = dict([(u'ExtnType', _cRLDistributionPoints_val_ExtnType), (u'id', (2, 5, 29, 31))])
    
    #-----< CRLDistPointsSyntax >-----#
    CRLDistPointsSyntax = SEQ_OF(name=u'CRLDistPointsSyntax', mode=MODE_TYPE)
    _CRLDistPointsSyntax__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'DistributionPoint')))
    CRLDistPointsSyntax._cont = _CRLDistPointsSyntax__item_
    CRLDistPointsSyntax._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< DistributionPoint >-----#
    DistributionPoint = SEQ(name=u'DistributionPoint', mode=MODE_TYPE)
    _DistributionPoint_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    _DistributionPoint_reasons = BIT_STR(name=u'reasons', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonFlags')), opt=True)
    _DistributionPoint_cRLIssuer = SEQ_OF(name=u'cRLIssuer', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    DistributionPoint._cont = ASN1Dict([
        (u'distributionPoint', _DistributionPoint_distributionPoint),
        (u'reasons', _DistributionPoint_reasons),
        (u'cRLIssuer', _DistributionPoint_cRLIssuer),
        ])
    DistributionPoint._ext = []
    
    #-----< DistributionPointName >-----#
    DistributionPointName = CHOICE(name=u'DistributionPointName', mode=MODE_TYPE)
    _DistributionPointName_fullName = SEQ_OF(name=u'fullName', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    _DistributionPointName_nameRelativeToCRLIssuer = SET_OF(name=u'nameRelativeToCRLIssuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'RelativeDistinguishedName')))
    DistributionPointName._cont = ASN1Dict([
        (u'fullName', _DistributionPointName_fullName),
        (u'nameRelativeToCRLIssuer', _DistributionPointName_nameRelativeToCRLIssuer),
        ])
    DistributionPointName._ext = []
    
    #-----< ReasonFlags >-----#
    ReasonFlags = BIT_STR(name=u'ReasonFlags', mode=MODE_TYPE)
    ReasonFlags._cont = ASN1Dict([(u'unused', 0), (u'keyCompromise', 1), (u'cACompromise', 2), (u'affiliationChanged', 3), (u'superseded', 4), (u'cessationOfOperation', 5), (u'certificateHold', 6), (u'privilegeWithdrawn', 7), (u'aACompromise', 8), (u'weakAlgorithmOrKey', 9)])
    ReasonFlags._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=9)], ev=[10], er=[])
    
    #-----< issuingDistributionPoint >-----#
    issuingDistributionPoint = CLASS(name=u'issuingDistributionPoint', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _issuingDistributionPoint_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'IssuingDistPointSyntax')))
    issuingDistributionPoint._val = dict([(u'ExtnType', _issuingDistributionPoint_val_ExtnType), (u'id', (2, 5, 29, 28))])
    
    #-----< IssuingDistPointSyntax >-----#
    IssuingDistPointSyntax = SEQ(name=u'IssuingDistPointSyntax', mode=MODE_TYPE)
    _IssuingDistPointSyntax_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    _IssuingDistPointSyntax_onlyContainsUserPublicKeyCerts = BOOL(name=u'onlyContainsUserPublicKeyCerts', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistPointSyntax_onlyContainsCACerts = BOOL(name=u'onlyContainsCACerts', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _IssuingDistPointSyntax_onlySomeReasons = BIT_STR(name=u'onlySomeReasons', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonFlags')), opt=True)
    _IssuingDistPointSyntax_indirectCRL = BOOL(name=u'indirectCRL', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    IssuingDistPointSyntax._cont = ASN1Dict([
        (u'distributionPoint', _IssuingDistPointSyntax_distributionPoint),
        (u'onlyContainsUserPublicKeyCerts', _IssuingDistPointSyntax_onlyContainsUserPublicKeyCerts),
        (u'onlyContainsCACerts', _IssuingDistPointSyntax_onlyContainsCACerts),
        (u'onlySomeReasons', _IssuingDistPointSyntax_onlySomeReasons),
        (u'indirectCRL', _IssuingDistPointSyntax_indirectCRL),
        ])
    IssuingDistPointSyntax._ext = []
    
    #-----< certificateIssuer >-----#
    certificateIssuer = CLASS(name=u'certificateIssuer', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _certificateIssuer_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')))
    certificateIssuer._val = dict([(u'ExtnType', _certificateIssuer_val_ExtnType), (u'id', (2, 5, 29, 29))])
    
    #-----< deltaCRLIndicator >-----#
    deltaCRLIndicator = CLASS(name=u'deltaCRLIndicator', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _deltaCRLIndicator_val_ExtnType = INT(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'BaseCRLNumber')))
    deltaCRLIndicator._val = dict([(u'ExtnType', _deltaCRLIndicator_val_ExtnType), (u'id', (2, 5, 29, 27))])
    
    #-----< BaseCRLNumber >-----#
    BaseCRLNumber = INT(name=u'BaseCRLNumber', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLNumber')))
    
    #-----< baseUpdateTime >-----#
    baseUpdateTime = CLASS(name=u'baseUpdateTime', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _baseUpdateTime_val_ExtnType = TIME_GEN(name=u'ExtnType', mode=MODE_TYPE)
    baseUpdateTime._val = dict([(u'ExtnType', _baseUpdateTime_val_ExtnType), (u'id', (2, 5, 29, 51))])
    
    #-----< freshestCRL >-----#
    freshestCRL = CLASS(name=u'freshestCRL', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _freshestCRL_val_ExtnType = SEQ_OF(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CRLDistPointsSyntax')))
    freshestCRL._val = dict([(u'ExtnType', _freshestCRL_val_ExtnType), (u'id', (2, 5, 29, 46))])
    
    #-----< aAissuingDistributionPoint >-----#
    aAissuingDistributionPoint = CLASS(name=u'aAissuingDistributionPoint', mode=MODE_VALUE, typeref=ASN1RefType(('AuthenticationFramework', 'EXTENSION')))
    _aAissuingDistributionPoint_val_ExtnType = SEQ(name=u'ExtnType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'AAIssuingDistPointSyntax')))
    aAissuingDistributionPoint._val = dict([(u'ExtnType', _aAissuingDistributionPoint_val_ExtnType), (u'id', (2, 5, 29, 63))])
    
    #-----< AAIssuingDistPointSyntax >-----#
    AAIssuingDistPointSyntax = SEQ(name=u'AAIssuingDistPointSyntax', mode=MODE_TYPE)
    _AAIssuingDistPointSyntax_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    _AAIssuingDistPointSyntax_onlySomeReasons = BIT_STR(name=u'onlySomeReasons', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'ReasonFlags')), opt=True)
    _AAIssuingDistPointSyntax_indirectCRL = BOOL(name=u'indirectCRL', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=False)
    _AAIssuingDistPointSyntax_containsUserAttributeCerts = BOOL(name=u'containsUserAttributeCerts', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=True)
    _AAIssuingDistPointSyntax_containsAACerts = BOOL(name=u'containsAACerts', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=True)
    _AAIssuingDistPointSyntax_containsSOAPublicKeyCerts = BOOL(name=u'containsSOAPublicKeyCerts', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), default=True)
    AAIssuingDistPointSyntax._cont = ASN1Dict([
        (u'distributionPoint', _AAIssuingDistPointSyntax_distributionPoint),
        (u'onlySomeReasons', _AAIssuingDistPointSyntax_onlySomeReasons),
        (u'indirectCRL', _AAIssuingDistPointSyntax_indirectCRL),
        (u'containsUserAttributeCerts', _AAIssuingDistPointSyntax_containsUserAttributeCerts),
        (u'containsAACerts', _AAIssuingDistPointSyntax_containsAACerts),
        (u'containsSOAPublicKeyCerts', _AAIssuingDistPointSyntax_containsSOAPublicKeyCerts),
        ])
    AAIssuingDistPointSyntax._ext = []
    
    #-----< certificateExactMatch >-----#
    certificateExactMatch = CLASS(name=u'certificateExactMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificateExactMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateExactAssertion')))
    certificateExactMatch._val = dict([(u'AssertionType', _certificateExactMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 1)), (u'ldapName', [u'certificateExactMatch']), (u'ldapDesc', u'X.509 Certificate Exact Match'), (u'id', (2, 5, 13, 34))])
    
    #-----< CertificateExactAssertion >-----#
    CertificateExactAssertion = SEQ(name=u'CertificateExactAssertion', mode=MODE_TYPE)
    _CertificateExactAssertion_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')))
    _CertificateExactAssertion_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    CertificateExactAssertion._cont = ASN1Dict([
        (u'serialNumber', _CertificateExactAssertion_serialNumber),
        (u'issuer', _CertificateExactAssertion_issuer),
        ])
    CertificateExactAssertion._ext = []
    
    #-----< certificateMatch >-----#
    certificateMatch = CLASS(name=u'certificateMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificateMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateAssertion')))
    certificateMatch._val = dict([(u'AssertionType', _certificateMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 2)), (u'ldapName', [u'certificateMatch']), (u'ldapDesc', u'X.509 Certificate Match'), (u'id', (2, 5, 13, 35))])
    
    #-----< CertificateAssertion >-----#
    CertificateAssertion = SEQ(name=u'CertificateAssertion', mode=MODE_TYPE)
    _CertificateAssertion_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')), opt=True)
    _CertificateAssertion_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _CertificateAssertion_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'SubjectKeyIdentifier')), opt=True)
    _CertificateAssertion_authorityKeyIdentifier = SEQ(name=u'authorityKeyIdentifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'AuthorityKeyIdentifier')), opt=True)
    _CertificateAssertion_certificateValid = CHOICE(name=u'certificateValid', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Time')), opt=True)
    _CertificateAssertion_privateKeyValid = TIME_GEN(name=u'privateKeyValid', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CertificateAssertion_subjectPublicKeyAlgID = OID(name=u'subjectPublicKeyAlgID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _CertificateAssertion_keyUsage = BIT_STR(name=u'keyUsage', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'KeyUsage')), opt=True)
    _CertificateAssertion_subjectAltName = CHOICE(name=u'subjectAltName', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'AltNameType')), opt=True)
    _CertificateAssertion_policy = SEQ_OF(name=u'policy', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertPolicySet')), opt=True)
    _CertificateAssertion_pathToName = CHOICE(name=u'pathToName', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _CertificateAssertion_subject = CHOICE(name=u'subject', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _CertificateAssertion_nameConstraints = SEQ(name=u'nameConstraints', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'NameConstraintsSyntax')), opt=True)
    CertificateAssertion._cont = ASN1Dict([
        (u'serialNumber', _CertificateAssertion_serialNumber),
        (u'issuer', _CertificateAssertion_issuer),
        (u'subjectKeyIdentifier', _CertificateAssertion_subjectKeyIdentifier),
        (u'authorityKeyIdentifier', _CertificateAssertion_authorityKeyIdentifier),
        (u'certificateValid', _CertificateAssertion_certificateValid),
        (u'privateKeyValid', _CertificateAssertion_privateKeyValid),
        (u'subjectPublicKeyAlgID', _CertificateAssertion_subjectPublicKeyAlgID),
        (u'keyUsage', _CertificateAssertion_keyUsage),
        (u'subjectAltName', _CertificateAssertion_subjectAltName),
        (u'policy', _CertificateAssertion_policy),
        (u'pathToName', _CertificateAssertion_pathToName),
        (u'subject', _CertificateAssertion_subject),
        (u'nameConstraints', _CertificateAssertion_nameConstraints),
        ])
    CertificateAssertion._ext = []
    
    #-----< AltNameType >-----#
    AltNameType = CHOICE(name=u'AltNameType', mode=MODE_TYPE)
    _AltNameType_builtinNameForm = ENUM(name=u'builtinNameForm', mode=MODE_TYPE)
    _AltNameType_builtinNameForm._cont = ASN1Dict([(u'rfc822Name', 1), (u'dNSName', 2), (u'x400Address', 3), (u'directoryName', 4), (u'ediPartyName', 5), (u'uniformResourceIdentifier', 6), (u'iPAddress', 7), (u'registeredId', 8)])
    _AltNameType_builtinNameForm._ext = []
    _AltNameType_otherNameForm = OID(name=u'otherNameForm', mode=MODE_TYPE)
    AltNameType._cont = ASN1Dict([
        (u'builtinNameForm', _AltNameType_builtinNameForm),
        (u'otherNameForm', _AltNameType_otherNameForm),
        ])
    AltNameType._ext = []
    
    #-----< CertPolicySet >-----#
    CertPolicySet = SEQ_OF(name=u'CertPolicySet', mode=MODE_TYPE)
    _CertPolicySet__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertPolicyId')))
    CertPolicySet._cont = _CertPolicySet__item_
    CertPolicySet._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    
    #-----< certificatePairExactMatch >-----#
    certificatePairExactMatch = CLASS(name=u'certificatePairExactMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificatePairExactMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePairExactAssertion')))
    certificatePairExactMatch._val = dict([(u'AssertionType', _certificatePairExactMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 3)), (u'ldapName', [u'certificatePairExactMatch']), (u'ldapDesc', u'X.509 Certificate Pair Exact Match'), (u'id', (2, 5, 13, 36))])
    
    #-----< CertificatePairExactAssertion >-----#
    CertificatePairExactAssertion = SEQ(name=u'CertificatePairExactAssertion', mode=MODE_TYPE)
    _CertificatePairExactAssertion_issuedToThisCAAssertion = SEQ(name=u'issuedToThisCAAssertion', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateExactAssertion')), opt=True)
    _CertificatePairExactAssertion_issuedByThisCAAssertion = SEQ(name=u'issuedByThisCAAssertion', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateExactAssertion')), opt=True)
    CertificatePairExactAssertion._cont = ASN1Dict([
        (u'issuedToThisCAAssertion', _CertificatePairExactAssertion_issuedToThisCAAssertion),
        (u'issuedByThisCAAssertion', _CertificatePairExactAssertion_issuedByThisCAAssertion),
        ])
    CertificatePairExactAssertion._ext = []
    
    #-----< certificatePairMatch >-----#
    certificatePairMatch = CLASS(name=u'certificatePairMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificatePairMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePairAssertion')))
    certificatePairMatch._val = dict([(u'AssertionType', _certificatePairMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 4)), (u'ldapName', [u'certificatePairMatch']), (u'ldapDesc', u'X.509 Certificate Pair Match'), (u'id', (2, 5, 13, 37))])
    
    #-----< CertificatePairAssertion >-----#
    CertificatePairAssertion = SEQ(name=u'CertificatePairAssertion', mode=MODE_TYPE)
    _CertificatePairAssertion_issuedToThisCAAssertion = SEQ(name=u'issuedToThisCAAssertion', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateAssertion')), opt=True)
    _CertificatePairAssertion_issuedByThisCAAssertion = SEQ(name=u'issuedByThisCAAssertion', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertificateAssertion')), opt=True)
    CertificatePairAssertion._cont = ASN1Dict([
        (u'issuedToThisCAAssertion', _CertificatePairAssertion_issuedToThisCAAssertion),
        (u'issuedByThisCAAssertion', _CertificatePairAssertion_issuedByThisCAAssertion),
        ])
    CertificatePairAssertion._ext = []
    
    #-----< certificateListExactMatch >-----#
    certificateListExactMatch = CLASS(name=u'certificateListExactMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificateListExactMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListExactAssertion')))
    certificateListExactMatch._val = dict([(u'AssertionType', _certificateListExactMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 5)), (u'ldapName', [u'certificateListExactMatch']), (u'ldapDesc', u'X.509 Certificate List Exact Match'), (u'id', (2, 5, 13, 38))])
    
    #-----< CertificateListExactAssertion >-----#
    CertificateListExactAssertion = SEQ(name=u'CertificateListExactAssertion', mode=MODE_TYPE)
    _CertificateListExactAssertion_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _CertificateListExactAssertion_thisUpdate = CHOICE(name=u'thisUpdate', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')))
    _CertificateListExactAssertion_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    CertificateListExactAssertion._cont = ASN1Dict([
        (u'issuer', _CertificateListExactAssertion_issuer),
        (u'thisUpdate', _CertificateListExactAssertion_thisUpdate),
        (u'distributionPoint', _CertificateListExactAssertion_distributionPoint),
        ])
    CertificateListExactAssertion._ext = None
    
    #-----< certificateListMatch >-----#
    certificateListMatch = CLASS(name=u'certificateListMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _certificateListMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListAssertion')))
    certificateListMatch._val = dict([(u'AssertionType', _certificateListMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 6)), (u'ldapName', [u'certificateListMatch']), (u'ldapDesc', u'X.509 Certificate List Match'), (u'id', (2, 5, 13, 39))])
    
    #-----< CertificateListAssertion >-----#
    CertificateListAssertion = SEQ(name=u'CertificateListAssertion', mode=MODE_TYPE)
    _CertificateListAssertion_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _CertificateListAssertion_minCRLNumber = INT(name=u'minCRLNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CRLNumber')), opt=True)
    _CertificateListAssertion_maxCRLNumber = INT(name=u'maxCRLNumber', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CRLNumber')), opt=True)
    _CertificateListAssertion_reasonFlags = BIT_STR(name=u'reasonFlags', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'ReasonFlags')), opt=True)
    _CertificateListAssertion_dateAndTime = CHOICE(name=u'dateAndTime', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'Time')), opt=True)
    _CertificateListAssertion_distributionPoint = CHOICE(name=u'distributionPoint', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'DistributionPointName')), opt=True)
    _CertificateListAssertion_authorityKeyIdentifier = SEQ(name=u'authorityKeyIdentifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'AuthorityKeyIdentifier')), opt=True)
    CertificateListAssertion._cont = ASN1Dict([
        (u'issuer', _CertificateListAssertion_issuer),
        (u'minCRLNumber', _CertificateListAssertion_minCRLNumber),
        (u'maxCRLNumber', _CertificateListAssertion_maxCRLNumber),
        (u'reasonFlags', _CertificateListAssertion_reasonFlags),
        (u'dateAndTime', _CertificateListAssertion_dateAndTime),
        (u'distributionPoint', _CertificateListAssertion_distributionPoint),
        (u'authorityKeyIdentifier', _CertificateListAssertion_authorityKeyIdentifier),
        ])
    CertificateListAssertion._ext = []
    
    #-----< algorithmIdentifierMatch >-----#
    algorithmIdentifierMatch = CLASS(name=u'algorithmIdentifierMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _algorithmIdentifierMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __algorithmIdentifierMatch_val_AssertionType_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___algorithmIdentifierMatch_val_AssertionType_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___algorithmIdentifierMatch_val_AssertionType_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __algorithmIdentifierMatch_val_AssertionType_algorithm._const_tab = ___algorithmIdentifierMatch_val_AssertionType_algorithm_tab
    __algorithmIdentifierMatch_val_AssertionType_algorithm._const_tab_at = None
    __algorithmIdentifierMatch_val_AssertionType_algorithm._const_tab_id = u'id'
    __algorithmIdentifierMatch_val_AssertionType_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___algorithmIdentifierMatch_val_AssertionType_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___algorithmIdentifierMatch_val_AssertionType_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __algorithmIdentifierMatch_val_AssertionType_parameters._const_tab = ___algorithmIdentifierMatch_val_AssertionType_parameters_tab
    __algorithmIdentifierMatch_val_AssertionType_parameters._const_tab_at = ('..', u'algorithm')
    __algorithmIdentifierMatch_val_AssertionType_parameters._const_tab_id = u'Type'
    _algorithmIdentifierMatch_val_AssertionType._cont = ASN1Dict([
        (u'algorithm', __algorithmIdentifierMatch_val_AssertionType_algorithm),
        (u'parameters', __algorithmIdentifierMatch_val_AssertionType_parameters),
        ])
    _algorithmIdentifierMatch_val_AssertionType._ext = []
    algorithmIdentifierMatch._val = dict([(u'AssertionType', _algorithmIdentifierMatch_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 1, 15, 7)), (u'ldapName', [u'algorithmIdentifierMatch']), (u'ldapDesc', u'X.509 Algorithm Identifier Match'), (u'id', (2, 5, 13, 40))])
    
    #-----< policyMatch >-----#
    policyMatch = CLASS(name=u'policyMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _policyMatch_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'PolicyID')))
    policyMatch._val = dict([(u'AssertionType', _policyMatch_val_AssertionType), (u'id', (2, 5, 13, 60))])
    
    #-----< pkiPathMatch >-----#
    pkiPathMatch = CLASS(name=u'pkiPathMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _pkiPathMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'PkiPathMatchSyntax')))
    pkiPathMatch._val = dict([(u'AssertionType', _pkiPathMatch_val_AssertionType), (u'id', (2, 5, 13, 62))])
    
    #-----< PkiPathMatchSyntax >-----#
    PkiPathMatchSyntax = SEQ(name=u'PkiPathMatchSyntax', mode=MODE_TYPE)
    _PkiPathMatchSyntax_firstIssuer = CHOICE(name=u'firstIssuer', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _PkiPathMatchSyntax_lastSubject = CHOICE(name=u'lastSubject', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    PkiPathMatchSyntax._cont = ASN1Dict([
        (u'firstIssuer', _PkiPathMatchSyntax_firstIssuer),
        (u'lastSubject', _PkiPathMatchSyntax_lastSubject),
        ])
    PkiPathMatchSyntax._ext = []
    
    #-----< enhancedCertificateMatch >-----#
    enhancedCertificateMatch = CLASS(name=u'enhancedCertificateMatch', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'MATCHING-RULE')))
    _enhancedCertificateMatch_val_AssertionType = SEQ(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'EnhancedCertificateAssertion')))
    enhancedCertificateMatch._val = dict([(u'AssertionType', _enhancedCertificateMatch_val_AssertionType), (u'id', (2, 5, 13, 65))])
    
    #-----< EnhancedCertificateAssertion >-----#
    EnhancedCertificateAssertion = SEQ(name=u'EnhancedCertificateAssertion', mode=MODE_TYPE)
    _EnhancedCertificateAssertion_serialNumber = INT(name=u'serialNumber', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificateSerialNumber')), opt=True)
    _EnhancedCertificateAssertion_issuer = CHOICE(name=u'issuer', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _EnhancedCertificateAssertion_subjectKeyIdentifier = OCT_STR(name=u'subjectKeyIdentifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'SubjectKeyIdentifier')), opt=True)
    _EnhancedCertificateAssertion_authorityKeyIdentifier = SEQ(name=u'authorityKeyIdentifier', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'AuthorityKeyIdentifier')), opt=True)
    _EnhancedCertificateAssertion_certificateValid = CHOICE(name=u'certificateValid', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'Time')), opt=True)
    _EnhancedCertificateAssertion_privateKeyValid = TIME_GEN(name=u'privateKeyValid', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancedCertificateAssertion_subjectPublicKeyAlgID = OID(name=u'subjectPublicKeyAlgID', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_IMPLICIT), opt=True)
    _EnhancedCertificateAssertion_keyUsage = BIT_STR(name=u'keyUsage', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'KeyUsage')), opt=True)
    _EnhancedCertificateAssertion_subjectAltName = SEQ(name=u'subjectAltName', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'AltName')), opt=True)
    _EnhancedCertificateAssertion_policy = SEQ_OF(name=u'policy', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'CertPolicySet')), opt=True)
    _EnhancedCertificateAssertion_pathToName = SEQ_OF(name=u'pathToName', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'GeneralNames')), opt=True)
    _EnhancedCertificateAssertion_subject = CHOICE(name=u'subject', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _EnhancedCertificateAssertion_nameConstraints = SEQ(name=u'nameConstraints', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('CertificateExtensions', 'NameConstraintsSyntax')), opt=True)
    EnhancedCertificateAssertion._cont = ASN1Dict([
        (u'serialNumber', _EnhancedCertificateAssertion_serialNumber),
        (u'issuer', _EnhancedCertificateAssertion_issuer),
        (u'subjectKeyIdentifier', _EnhancedCertificateAssertion_subjectKeyIdentifier),
        (u'authorityKeyIdentifier', _EnhancedCertificateAssertion_authorityKeyIdentifier),
        (u'certificateValid', _EnhancedCertificateAssertion_certificateValid),
        (u'privateKeyValid', _EnhancedCertificateAssertion_privateKeyValid),
        (u'subjectPublicKeyAlgID', _EnhancedCertificateAssertion_subjectPublicKeyAlgID),
        (u'keyUsage', _EnhancedCertificateAssertion_keyUsage),
        (u'subjectAltName', _EnhancedCertificateAssertion_subjectAltName),
        (u'policy', _EnhancedCertificateAssertion_policy),
        (u'pathToName', _EnhancedCertificateAssertion_pathToName),
        (u'subject', _EnhancedCertificateAssertion_subject),
        (u'nameConstraints', _EnhancedCertificateAssertion_nameConstraints),
        ])
    EnhancedCertificateAssertion._ext = []
    
    #-----< AltName >-----#
    AltName = SEQ(name=u'AltName', mode=MODE_TYPE)
    _AltName_altnameType = CHOICE(name=u'altnameType', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'AltNameType')))
    _AltName_altNameValue = CHOICE(name=u'altNameValue', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'GeneralName')), opt=True)
    AltName._cont = ASN1Dict([
        (u'altnameType', _AltName_altnameType),
        (u'altNameValue', _AltName_altNameValue),
        ])
    AltName._ext = None
    
    #-----< certExactAssertion >-----#
    certExactAssertion = CLASS(name=u'certExactAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certExactAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateExactAssertion')))
    certExactAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate Exact Assertion'), (u'Type', _certExactAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 1))])
    
    #-----< certAssertion >-----#
    certAssertion = CLASS(name=u'certAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateAssertion')))
    certAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate Assertion'), (u'Type', _certAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 2))])
    
    #-----< certPairExactAssertion >-----#
    certPairExactAssertion = CLASS(name=u'certPairExactAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certPairExactAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePairExactAssertion')))
    certPairExactAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate Pair Exact Assertion'), (u'Type', _certPairExactAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 3))])
    
    #-----< certPairAssertion >-----#
    certPairAssertion = CLASS(name=u'certPairAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certPairAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificatePairAssertion')))
    certPairAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate Pair Assertion'), (u'Type', _certPairAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 4))])
    
    #-----< certListExactAssertion >-----#
    certListExactAssertion = CLASS(name=u'certListExactAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certListExactAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListExactAssertion')))
    certListExactAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate List Exact Assertion'), (u'Type', _certListExactAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 5))])
    
    #-----< certListAssertion >-----#
    certListAssertion = CLASS(name=u'certListAssertion', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _certListAssertion_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('CertificateExtensions', 'CertificateListAssertion')))
    certListAssertion._val = dict([(u'ldapDesc', u'X.509 Certificate List Assertion'), (u'Type', _certListAssertion_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 6))])
    
    #-----< algorithmIdentifier >-----#
    algorithmIdentifier = CLASS(name=u'algorithmIdentifier', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'SYNTAX-NAME')))
    _algorithmIdentifier_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __algorithmIdentifier_val_Type_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___algorithmIdentifier_val_Type_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___algorithmIdentifier_val_Type_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __algorithmIdentifier_val_Type_algorithm._const_tab = ___algorithmIdentifier_val_Type_algorithm_tab
    __algorithmIdentifier_val_Type_algorithm._const_tab_at = None
    __algorithmIdentifier_val_Type_algorithm._const_tab_id = u'id'
    __algorithmIdentifier_val_Type_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___algorithmIdentifier_val_Type_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___algorithmIdentifier_val_Type_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __algorithmIdentifier_val_Type_parameters._const_tab = ___algorithmIdentifier_val_Type_parameters_tab
    __algorithmIdentifier_val_Type_parameters._const_tab_at = ('..', u'algorithm')
    __algorithmIdentifier_val_Type_parameters._const_tab_id = u'Type'
    _algorithmIdentifier_val_Type._cont = ASN1Dict([
        (u'algorithm', __algorithmIdentifier_val_Type_algorithm),
        (u'parameters', __algorithmIdentifier_val_Type_parameters),
        ])
    _algorithmIdentifier_val_Type._ext = []
    algorithmIdentifier._val = dict([(u'ldapDesc', u'X.509 Algorithm Identifier'), (u'Type', _algorithmIdentifier_val_Type), (u'id', (1, 3, 6, 1, 1, 15, 7))])
    
    #-----< id-ce-subjectDirectoryAttributes >-----#
    id_ce_subjectDirectoryAttributes = OID(name=u'id-ce-subjectDirectoryAttributes', mode=MODE_VALUE)
    id_ce_subjectDirectoryAttributes._val = (2, 5, 29, 9)
    
    #-----< id-ce-subjectKeyIdentifier >-----#
    id_ce_subjectKeyIdentifier = OID(name=u'id-ce-subjectKeyIdentifier', mode=MODE_VALUE)
    id_ce_subjectKeyIdentifier._val = (2, 5, 29, 14)
    
    #-----< id-ce-keyUsage >-----#
    id_ce_keyUsage = OID(name=u'id-ce-keyUsage', mode=MODE_VALUE)
    id_ce_keyUsage._val = (2, 5, 29, 15)
    
    #-----< id-ce-privateKeyUsagePeriod >-----#
    id_ce_privateKeyUsagePeriod = OID(name=u'id-ce-privateKeyUsagePeriod', mode=MODE_VALUE)
    id_ce_privateKeyUsagePeriod._val = (2, 5, 29, 16)
    
    #-----< id-ce-subjectAltName >-----#
    id_ce_subjectAltName = OID(name=u'id-ce-subjectAltName', mode=MODE_VALUE)
    id_ce_subjectAltName._val = (2, 5, 29, 17)
    
    #-----< id-ce-issuerAltName >-----#
    id_ce_issuerAltName = OID(name=u'id-ce-issuerAltName', mode=MODE_VALUE)
    id_ce_issuerAltName._val = (2, 5, 29, 18)
    
    #-----< id-ce-basicConstraints >-----#
    id_ce_basicConstraints = OID(name=u'id-ce-basicConstraints', mode=MODE_VALUE)
    id_ce_basicConstraints._val = (2, 5, 29, 19)
    
    #-----< id-ce-cRLNumber >-----#
    id_ce_cRLNumber = OID(name=u'id-ce-cRLNumber', mode=MODE_VALUE)
    id_ce_cRLNumber._val = (2, 5, 29, 20)
    
    #-----< id-ce-reasonCode >-----#
    id_ce_reasonCode = OID(name=u'id-ce-reasonCode', mode=MODE_VALUE)
    id_ce_reasonCode._val = (2, 5, 29, 21)
    
    #-----< id-ce-instructionCode >-----#
    id_ce_instructionCode = OID(name=u'id-ce-instructionCode', mode=MODE_VALUE)
    id_ce_instructionCode._val = (2, 5, 29, 23)
    
    #-----< id-ce-invalidityDate >-----#
    id_ce_invalidityDate = OID(name=u'id-ce-invalidityDate', mode=MODE_VALUE)
    id_ce_invalidityDate._val = (2, 5, 29, 24)
    
    #-----< id-ce-deltaCRLIndicator >-----#
    id_ce_deltaCRLIndicator = OID(name=u'id-ce-deltaCRLIndicator', mode=MODE_VALUE)
    id_ce_deltaCRLIndicator._val = (2, 5, 29, 27)
    
    #-----< id-ce-issuingDistributionPoint >-----#
    id_ce_issuingDistributionPoint = OID(name=u'id-ce-issuingDistributionPoint', mode=MODE_VALUE)
    id_ce_issuingDistributionPoint._val = (2, 5, 29, 28)
    
    #-----< id-ce-certificateIssuer >-----#
    id_ce_certificateIssuer = OID(name=u'id-ce-certificateIssuer', mode=MODE_VALUE)
    id_ce_certificateIssuer._val = (2, 5, 29, 29)
    
    #-----< id-ce-nameConstraints >-----#
    id_ce_nameConstraints = OID(name=u'id-ce-nameConstraints', mode=MODE_VALUE)
    id_ce_nameConstraints._val = (2, 5, 29, 30)
    
    #-----< id-ce-cRLDistributionPoints >-----#
    id_ce_cRLDistributionPoints = OID(name=u'id-ce-cRLDistributionPoints', mode=MODE_VALUE)
    id_ce_cRLDistributionPoints._val = (2, 5, 29, 31)
    
    #-----< id-ce-certificatePolicies >-----#
    id_ce_certificatePolicies = OID(name=u'id-ce-certificatePolicies', mode=MODE_VALUE)
    id_ce_certificatePolicies._val = (2, 5, 29, 32)
    
    #-----< id-ce-policyMappings >-----#
    id_ce_policyMappings = OID(name=u'id-ce-policyMappings', mode=MODE_VALUE)
    id_ce_policyMappings._val = (2, 5, 29, 33)
    
    #-----< id-ce-authorityKeyIdentifier >-----#
    id_ce_authorityKeyIdentifier = OID(name=u'id-ce-authorityKeyIdentifier', mode=MODE_VALUE)
    id_ce_authorityKeyIdentifier._val = (2, 5, 29, 35)
    
    #-----< id-ce-policyConstraints >-----#
    id_ce_policyConstraints = OID(name=u'id-ce-policyConstraints', mode=MODE_VALUE)
    id_ce_policyConstraints._val = (2, 5, 29, 36)
    
    #-----< id-ce-extKeyUsage >-----#
    id_ce_extKeyUsage = OID(name=u'id-ce-extKeyUsage', mode=MODE_VALUE)
    id_ce_extKeyUsage._val = (2, 5, 29, 37)
    
    #-----< id-ce-cRLStreamIdentifier >-----#
    id_ce_cRLStreamIdentifier = OID(name=u'id-ce-cRLStreamIdentifier', mode=MODE_VALUE)
    id_ce_cRLStreamIdentifier._val = (2, 5, 29, 40)
    
    #-----< id-ce-cRLScope >-----#
    id_ce_cRLScope = OID(name=u'id-ce-cRLScope', mode=MODE_VALUE)
    id_ce_cRLScope._val = (2, 5, 29, 44)
    
    #-----< id-ce-statusReferrals >-----#
    id_ce_statusReferrals = OID(name=u'id-ce-statusReferrals', mode=MODE_VALUE)
    id_ce_statusReferrals._val = (2, 5, 29, 45)
    
    #-----< id-ce-freshestCRL >-----#
    id_ce_freshestCRL = OID(name=u'id-ce-freshestCRL', mode=MODE_VALUE)
    id_ce_freshestCRL._val = (2, 5, 29, 46)
    
    #-----< id-ce-orderedList >-----#
    id_ce_orderedList = OID(name=u'id-ce-orderedList', mode=MODE_VALUE)
    id_ce_orderedList._val = (2, 5, 29, 47)
    
    #-----< id-ce-baseUpdateTime >-----#
    id_ce_baseUpdateTime = OID(name=u'id-ce-baseUpdateTime', mode=MODE_VALUE)
    id_ce_baseUpdateTime._val = (2, 5, 29, 51)
    
    #-----< id-ce-deltaInfo >-----#
    id_ce_deltaInfo = OID(name=u'id-ce-deltaInfo', mode=MODE_VALUE)
    id_ce_deltaInfo._val = (2, 5, 29, 53)
    
    #-----< id-ce-inhibitAnyPolicy >-----#
    id_ce_inhibitAnyPolicy = OID(name=u'id-ce-inhibitAnyPolicy', mode=MODE_VALUE)
    id_ce_inhibitAnyPolicy._val = (2, 5, 29, 54)
    
    #-----< id-ce-toBeRevoked >-----#
    id_ce_toBeRevoked = OID(name=u'id-ce-toBeRevoked', mode=MODE_VALUE)
    id_ce_toBeRevoked._val = (2, 5, 29, 58)
    
    #-----< id-ce-RevokedGroups >-----#
    id_ce_RevokedGroups = OID(name=u'id-ce-RevokedGroups', mode=MODE_VALUE)
    id_ce_RevokedGroups._val = (2, 5, 29, 59)
    
    #-----< id-ce-expiredCertsOnCRL >-----#
    id_ce_expiredCertsOnCRL = OID(name=u'id-ce-expiredCertsOnCRL', mode=MODE_VALUE)
    id_ce_expiredCertsOnCRL._val = (2, 5, 29, 60)
    
    #-----< id-ce-aAissuingDistributionPoint >-----#
    id_ce_aAissuingDistributionPoint = OID(name=u'id-ce-aAissuingDistributionPoint', mode=MODE_VALUE)
    id_ce_aAissuingDistributionPoint._val = (2, 5, 29, 63)
    
    #-----< id-mr-certificateExactMatch >-----#
    id_mr_certificateExactMatch = OID(name=u'id-mr-certificateExactMatch', mode=MODE_VALUE)
    id_mr_certificateExactMatch._val = (2, 5, 13, 34)
    
    #-----< id-mr-certificateMatch >-----#
    id_mr_certificateMatch = OID(name=u'id-mr-certificateMatch', mode=MODE_VALUE)
    id_mr_certificateMatch._val = (2, 5, 13, 35)
    
    #-----< id-mr-certificatePairExactMatch >-----#
    id_mr_certificatePairExactMatch = OID(name=u'id-mr-certificatePairExactMatch', mode=MODE_VALUE)
    id_mr_certificatePairExactMatch._val = (2, 5, 13, 36)
    
    #-----< id-mr-certificatePairMatch >-----#
    id_mr_certificatePairMatch = OID(name=u'id-mr-certificatePairMatch', mode=MODE_VALUE)
    id_mr_certificatePairMatch._val = (2, 5, 13, 37)
    
    #-----< id-mr-certificateListExactMatch >-----#
    id_mr_certificateListExactMatch = OID(name=u'id-mr-certificateListExactMatch', mode=MODE_VALUE)
    id_mr_certificateListExactMatch._val = (2, 5, 13, 38)
    
    #-----< id-mr-certificateListMatch >-----#
    id_mr_certificateListMatch = OID(name=u'id-mr-certificateListMatch', mode=MODE_VALUE)
    id_mr_certificateListMatch._val = (2, 5, 13, 39)
    
    #-----< id-mr-algorithmIdentifierMatch >-----#
    id_mr_algorithmIdentifierMatch = OID(name=u'id-mr-algorithmIdentifierMatch', mode=MODE_VALUE)
    id_mr_algorithmIdentifierMatch._val = (2, 5, 13, 40)
    
    #-----< id-mr-policyMatch >-----#
    id_mr_policyMatch = OID(name=u'id-mr-policyMatch', mode=MODE_VALUE)
    id_mr_policyMatch._val = (2, 5, 13, 60)
    
    #-----< id-mr-pkiPathMatch >-----#
    id_mr_pkiPathMatch = OID(name=u'id-mr-pkiPathMatch', mode=MODE_VALUE)
    id_mr_pkiPathMatch._val = (2, 5, 13, 62)
    
    #-----< id-mr-enhancedCertificateMatch >-----#
    id_mr_enhancedCertificateMatch = OID(name=u'id-mr-enhancedCertificateMatch', mode=MODE_VALUE)
    id_mr_enhancedCertificateMatch._val = (2, 5, 13, 65)
    
    #-----< id-ldx-certExactAssertion >-----#
    id_ldx_certExactAssertion = OID(name=u'id-ldx-certExactAssertion', mode=MODE_VALUE)
    id_ldx_certExactAssertion._val = (1, 3, 6, 1, 1, 15, 1)
    
    #-----< id-ldx-certAssertion >-----#
    id_ldx_certAssertion = OID(name=u'id-ldx-certAssertion', mode=MODE_VALUE)
    id_ldx_certAssertion._val = (1, 3, 6, 1, 1, 15, 2)
    
    #-----< id-ldx-certPairExactAssertion >-----#
    id_ldx_certPairExactAssertion = OID(name=u'id-ldx-certPairExactAssertion', mode=MODE_VALUE)
    id_ldx_certPairExactAssertion._val = (1, 3, 6, 1, 1, 15, 3)
    
    #-----< id-ldx-certPairAssertion >-----#
    id_ldx_certPairAssertion = OID(name=u'id-ldx-certPairAssertion', mode=MODE_VALUE)
    id_ldx_certPairAssertion._val = (1, 3, 6, 1, 1, 15, 4)
    
    #-----< id-ldx-certListExactAssertion >-----#
    id_ldx_certListExactAssertion = OID(name=u'id-ldx-certListExactAssertion', mode=MODE_VALUE)
    id_ldx_certListExactAssertion._val = (1, 3, 6, 1, 1, 15, 5)
    
    #-----< id-ldx-certListAssertion >-----#
    id_ldx_certListAssertion = OID(name=u'id-ldx-certListAssertion', mode=MODE_VALUE)
    id_ldx_certListAssertion._val = (1, 3, 6, 1, 1, 15, 6)
    
    #-----< id-ldx-algorithmIdentifier >-----#
    id_ldx_algorithmIdentifier = OID(name=u'id-ldx-algorithmIdentifier', mode=MODE_VALUE)
    id_ldx_algorithmIdentifier._val = (1, 3, 6, 1, 1, 15, 7)
    
    _all_ = [
        authorityKeyIdentifier,
        _authorityKeyIdentifier_val_ExtnType,
        _AuthorityKeyIdentifier_keyIdentifier,
        _AuthorityKeyIdentifier_authorityCertIssuer,
        _AuthorityKeyIdentifier_authorityCertSerialNumber,
        AuthorityKeyIdentifier,
        KeyIdentifier,
        subjectKeyIdentifier,
        _subjectKeyIdentifier_val_ExtnType,
        SubjectKeyIdentifier,
        keyUsage,
        _keyUsage_val_ExtnType,
        KeyUsage,
        extKeyUsage,
        __extKeyUsage_val_ExtnType__item_,
        _extKeyUsage_val_ExtnType,
        KeyPurposeId,
        privateKeyUsagePeriod,
        _privateKeyUsagePeriod_val_ExtnType,
        _PrivateKeyUsagePeriod_notBefore,
        _PrivateKeyUsagePeriod_notAfter,
        PrivateKeyUsagePeriod,
        certificatePolicies,
        _certificatePolicies_val_ExtnType,
        _CertificatePoliciesSyntax__item_,
        CertificatePoliciesSyntax,
        _PolicyInformation_policyIdentifier,
        __PolicyInformation_policyQualifiers__item_,
        _PolicyInformation_policyQualifiers,
        PolicyInformation,
        CertPolicyId,
        __PolicyQualifierInfo_policyQualifierId_tab,
        _PolicyQualifierInfo_policyQualifierId,
        __PolicyQualifierInfo_qualifier_tab,
        _PolicyQualifierInfo_qualifier,
        PolicyQualifierInfo,
        SupportedPolicyQualifiers,
        anyPolicy,
        _CERT_POLICY_QUALIFIER_id,
        _CERT_POLICY_QUALIFIER_Qualifier,
        CERT_POLICY_QUALIFIER,
        policyMappings,
        _policyMappings_val_ExtnType,
        __PolicyMappingsSyntax__item__issuerDomainPolicy,
        __PolicyMappingsSyntax__item__subjectDomainPolicy,
        _PolicyMappingsSyntax__item_,
        PolicyMappingsSyntax,
        subjectAltName,
        _subjectAltName_val_ExtnType,
        _GeneralNames__item_,
        GeneralNames,
        __GeneralName_otherName_type_id,
        __GeneralName_otherName_value,
        _GeneralName_otherName,
        _GeneralName_otherName,
        _GeneralName_rfc822Name,
        _GeneralName_dNSName,
        _GeneralName_x400Address,
        _GeneralName_directoryName,
        _GeneralName_ediPartyName,
        _GeneralName_uniformResourceIdentifier,
        _GeneralName_iPAddress,
        _GeneralName_registeredID,
        GeneralName,
        OTHER_NAME,
        _EDIPartyName_nameAssigner,
        _EDIPartyName_partyName,
        EDIPartyName,
        issuerAltName,
        _issuerAltName_val_ExtnType,
        subjectDirectoryAttributes,
        _subjectDirectoryAttributes_val_ExtnType,
        ___AttributesSyntax__item__type_tab,
        ____AttributesSyntax__item__type_tab_val_Type_0,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType,
        ____AttributesSyntax__item__type_tab_val_Type_1,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0,
        __AttributesSyntax__item__type,
        ___AttributesSyntax__item__values__item_,
        __AttributesSyntax__item__values,
        ____AttributesSyntax__item__valuesWithContext__item__value,
        _____AttributesSyntax__item__valuesWithContext__item__contextList__item_,
        ____AttributesSyntax__item__valuesWithContext__item__contextList,
        ___AttributesSyntax__item__valuesWithContext__item_,
        __AttributesSyntax__item__valuesWithContext,
        _AttributesSyntax__item_,
        AttributesSyntax,
        basicConstraints,
        _basicConstraints_val_ExtnType,
        _BasicConstraintsSyntax_cA,
        _BasicConstraintsSyntax_pathLenConstraint,
        BasicConstraintsSyntax,
        nameConstraints,
        _nameConstraints_val_ExtnType,
        _NameConstraintsSyntax_permittedSubtrees,
        _NameConstraintsSyntax_excludedSubtrees,
        NameConstraintsSyntax,
        _GeneralSubtrees__item_,
        GeneralSubtrees,
        _GeneralSubtree_base,
        _GeneralSubtree_minimum,
        _GeneralSubtree_maximum,
        GeneralSubtree,
        BaseDistance,
        policyConstraints,
        _policyConstraints_val_ExtnType,
        _PolicyConstraintsSyntax_requireExplicitPolicy,
        _PolicyConstraintsSyntax_inhibitPolicyMapping,
        PolicyConstraintsSyntax,
        SkipCerts,
        inhibitAnyPolicy,
        _inhibitAnyPolicy_val_ExtnType,
        cRLNumber,
        _cRLNumber_val_ExtnType,
        CRLNumber,
        crlScope,
        _crlScope_val_ExtnType,
        _CRLScopeSyntax__item_,
        CRLScopeSyntax,
        _PerAuthorityScope_authorityName,
        _PerAuthorityScope_distributionPoint,
        _PerAuthorityScope_onlyContains,
        _PerAuthorityScope_onlySomeReasons,
        _PerAuthorityScope_serialNumberRange,
        _PerAuthorityScope_subjectKeyIdRange,
        _PerAuthorityScope_nameSubtrees,
        _PerAuthorityScope_baseRevocationInfo,
        PerAuthorityScope,
        OnlyCertificateTypes,
        _NumberRange_startingNumber,
        _NumberRange_endingNumber,
        _NumberRange_modulus,
        NumberRange,
        _BaseRevocationInfo_cRLStreamIdentifier,
        _BaseRevocationInfo_cRLNumber,
        _BaseRevocationInfo_baseThisUpdate,
        BaseRevocationInfo,
        statusReferrals,
        _statusReferrals_val_ExtnType,
        _StatusReferrals__item_,
        StatusReferrals,
        _StatusReferral_cRLReferral,
        __StatusReferral_otherReferral_type_id,
        __StatusReferral_otherReferral_value,
        _StatusReferral_otherReferral,
        _StatusReferral_otherReferral,
        StatusReferral,
        _CRLReferral_issuer,
        _CRLReferral_location,
        _CRLReferral_deltaRefInfo,
        _CRLReferral_cRLScope,
        _CRLReferral_lastUpdate,
        _CRLReferral_lastChangedCRL,
        CRLReferral,
        _DeltaRefInfo_deltaLocation,
        _DeltaRefInfo_lastDelta,
        DeltaRefInfo,
        OTHER_REFERRAL,
        cRLStreamIdentifier,
        _cRLStreamIdentifier_val_ExtnType,
        CRLStreamIdentifier,
        orderedList,
        _orderedList_val_ExtnType,
        OrderedListSyntax,
        deltaInfo,
        _deltaInfo_val_ExtnType,
        _DeltaInformation_deltaLocation,
        _DeltaInformation_nextDelta,
        DeltaInformation,
        toBeRevoked,
        _toBeRevoked_val_ExtnType,
        _ToBeRevokedSyntax__item_,
        ToBeRevokedSyntax,
        _ToBeRevokedGroup_certificateIssuer,
        _ToBeRevokedGroup_reasonInfo,
        _ToBeRevokedGroup_revocationTime,
        _ToBeRevokedGroup_certificateGroup,
        ToBeRevokedGroup,
        _ReasonInfo_reasonCode,
        _ReasonInfo_holdInstructionCode,
        ReasonInfo,
        _CertificateGroup_serialNumbers,
        _CertificateGroup_serialNumberRange,
        _CertificateGroup_nameSubtree,
        CertificateGroup,
        _CertificateGroupNumberRange_startingNumber,
        _CertificateGroupNumberRange_endingNumber,
        CertificateGroupNumberRange,
        _CertificateSerialNumbers__item_,
        CertificateSerialNumbers,
        revokedGroups,
        _revokedGroups_val_ExtnType,
        _RevokedGroupsSyntax__item_,
        RevokedGroupsSyntax,
        _RevokedGroup_certificateIssuer,
        _RevokedGroup_reasonInfo,
        _RevokedGroup_invalidityDate,
        _RevokedGroup_revokedcertificateGroup,
        RevokedGroup,
        _RevokedCertificateGroup_serialNumberRange,
        _RevokedCertificateGroup_nameSubtree,
        RevokedCertificateGroup,
        expiredCertsOnCRL,
        _expiredCertsOnCRL_val_ExtnType,
        ExpiredCertsOnCRL,
        reasonCode,
        _reasonCode_val_ExtnType,
        CRLReason,
        holdInstructionCode,
        _holdInstructionCode_val_ExtnType,
        HoldInstruction,
        invalidityDate,
        _invalidityDate_val_ExtnType,
        cRLDistributionPoints,
        _cRLDistributionPoints_val_ExtnType,
        _CRLDistPointsSyntax__item_,
        CRLDistPointsSyntax,
        _DistributionPoint_distributionPoint,
        _DistributionPoint_reasons,
        _DistributionPoint_cRLIssuer,
        DistributionPoint,
        _DistributionPointName_fullName,
        _DistributionPointName_nameRelativeToCRLIssuer,
        DistributionPointName,
        ReasonFlags,
        issuingDistributionPoint,
        _issuingDistributionPoint_val_ExtnType,
        _IssuingDistPointSyntax_distributionPoint,
        _IssuingDistPointSyntax_onlyContainsUserPublicKeyCerts,
        _IssuingDistPointSyntax_onlyContainsCACerts,
        _IssuingDistPointSyntax_onlySomeReasons,
        _IssuingDistPointSyntax_indirectCRL,
        IssuingDistPointSyntax,
        certificateIssuer,
        _certificateIssuer_val_ExtnType,
        deltaCRLIndicator,
        _deltaCRLIndicator_val_ExtnType,
        BaseCRLNumber,
        baseUpdateTime,
        _baseUpdateTime_val_ExtnType,
        freshestCRL,
        _freshestCRL_val_ExtnType,
        aAissuingDistributionPoint,
        _aAissuingDistributionPoint_val_ExtnType,
        _AAIssuingDistPointSyntax_distributionPoint,
        _AAIssuingDistPointSyntax_onlySomeReasons,
        _AAIssuingDistPointSyntax_indirectCRL,
        _AAIssuingDistPointSyntax_containsUserAttributeCerts,
        _AAIssuingDistPointSyntax_containsAACerts,
        _AAIssuingDistPointSyntax_containsSOAPublicKeyCerts,
        AAIssuingDistPointSyntax,
        certificateExactMatch,
        _certificateExactMatch_val_AssertionType,
        _CertificateExactAssertion_serialNumber,
        _CertificateExactAssertion_issuer,
        CertificateExactAssertion,
        certificateMatch,
        _certificateMatch_val_AssertionType,
        _CertificateAssertion_serialNumber,
        _CertificateAssertion_issuer,
        _CertificateAssertion_subjectKeyIdentifier,
        _CertificateAssertion_authorityKeyIdentifier,
        _CertificateAssertion_certificateValid,
        _CertificateAssertion_privateKeyValid,
        _CertificateAssertion_subjectPublicKeyAlgID,
        _CertificateAssertion_keyUsage,
        _CertificateAssertion_subjectAltName,
        _CertificateAssertion_policy,
        _CertificateAssertion_pathToName,
        _CertificateAssertion_subject,
        _CertificateAssertion_nameConstraints,
        CertificateAssertion,
        _AltNameType_builtinNameForm,
        _AltNameType_otherNameForm,
        AltNameType,
        _CertPolicySet__item_,
        CertPolicySet,
        certificatePairExactMatch,
        _certificatePairExactMatch_val_AssertionType,
        _CertificatePairExactAssertion_issuedToThisCAAssertion,
        _CertificatePairExactAssertion_issuedByThisCAAssertion,
        CertificatePairExactAssertion,
        certificatePairMatch,
        _certificatePairMatch_val_AssertionType,
        _CertificatePairAssertion_issuedToThisCAAssertion,
        _CertificatePairAssertion_issuedByThisCAAssertion,
        CertificatePairAssertion,
        certificateListExactMatch,
        _certificateListExactMatch_val_AssertionType,
        _CertificateListExactAssertion_issuer,
        _CertificateListExactAssertion_thisUpdate,
        _CertificateListExactAssertion_distributionPoint,
        CertificateListExactAssertion,
        certificateListMatch,
        _certificateListMatch_val_AssertionType,
        _CertificateListAssertion_issuer,
        _CertificateListAssertion_minCRLNumber,
        _CertificateListAssertion_maxCRLNumber,
        _CertificateListAssertion_reasonFlags,
        _CertificateListAssertion_dateAndTime,
        _CertificateListAssertion_distributionPoint,
        _CertificateListAssertion_authorityKeyIdentifier,
        CertificateListAssertion,
        algorithmIdentifierMatch,
        ___algorithmIdentifierMatch_val_AssertionType_algorithm_tab,
        __algorithmIdentifierMatch_val_AssertionType_algorithm,
        ___algorithmIdentifierMatch_val_AssertionType_parameters_tab,
        __algorithmIdentifierMatch_val_AssertionType_parameters,
        _algorithmIdentifierMatch_val_AssertionType,
        policyMatch,
        _policyMatch_val_AssertionType,
        pkiPathMatch,
        _pkiPathMatch_val_AssertionType,
        _PkiPathMatchSyntax_firstIssuer,
        _PkiPathMatchSyntax_lastSubject,
        PkiPathMatchSyntax,
        enhancedCertificateMatch,
        _enhancedCertificateMatch_val_AssertionType,
        _EnhancedCertificateAssertion_serialNumber,
        _EnhancedCertificateAssertion_issuer,
        _EnhancedCertificateAssertion_subjectKeyIdentifier,
        _EnhancedCertificateAssertion_authorityKeyIdentifier,
        _EnhancedCertificateAssertion_certificateValid,
        _EnhancedCertificateAssertion_privateKeyValid,
        _EnhancedCertificateAssertion_subjectPublicKeyAlgID,
        _EnhancedCertificateAssertion_keyUsage,
        _EnhancedCertificateAssertion_subjectAltName,
        _EnhancedCertificateAssertion_policy,
        _EnhancedCertificateAssertion_pathToName,
        _EnhancedCertificateAssertion_subject,
        _EnhancedCertificateAssertion_nameConstraints,
        EnhancedCertificateAssertion,
        _AltName_altnameType,
        _AltName_altNameValue,
        AltName,
        certExactAssertion,
        _certExactAssertion_val_Type,
        certAssertion,
        _certAssertion_val_Type,
        certPairExactAssertion,
        _certPairExactAssertion_val_Type,
        certPairAssertion,
        _certPairAssertion_val_Type,
        certListExactAssertion,
        _certListExactAssertion_val_Type,
        certListAssertion,
        _certListAssertion_val_Type,
        algorithmIdentifier,
        ___algorithmIdentifier_val_Type_algorithm_tab,
        __algorithmIdentifier_val_Type_algorithm,
        ___algorithmIdentifier_val_Type_parameters_tab,
        __algorithmIdentifier_val_Type_parameters,
        _algorithmIdentifier_val_Type,
        id_ce_subjectDirectoryAttributes,
        id_ce_subjectKeyIdentifier,
        id_ce_keyUsage,
        id_ce_privateKeyUsagePeriod,
        id_ce_subjectAltName,
        id_ce_issuerAltName,
        id_ce_basicConstraints,
        id_ce_cRLNumber,
        id_ce_reasonCode,
        id_ce_instructionCode,
        id_ce_invalidityDate,
        id_ce_deltaCRLIndicator,
        id_ce_issuingDistributionPoint,
        id_ce_certificateIssuer,
        id_ce_nameConstraints,
        id_ce_cRLDistributionPoints,
        id_ce_certificatePolicies,
        id_ce_policyMappings,
        id_ce_authorityKeyIdentifier,
        id_ce_policyConstraints,
        id_ce_extKeyUsage,
        id_ce_cRLStreamIdentifier,
        id_ce_cRLScope,
        id_ce_statusReferrals,
        id_ce_freshestCRL,
        id_ce_orderedList,
        id_ce_baseUpdateTime,
        id_ce_deltaInfo,
        id_ce_inhibitAnyPolicy,
        id_ce_toBeRevoked,
        id_ce_RevokedGroups,
        id_ce_expiredCertsOnCRL,
        id_ce_aAissuingDistributionPoint,
        id_mr_certificateExactMatch,
        id_mr_certificateMatch,
        id_mr_certificatePairExactMatch,
        id_mr_certificatePairMatch,
        id_mr_certificateListExactMatch,
        id_mr_certificateListMatch,
        id_mr_algorithmIdentifierMatch,
        id_mr_policyMatch,
        id_mr_pkiPathMatch,
        id_mr_enhancedCertificateMatch,
        id_ldx_certExactAssertion,
        id_ldx_certAssertion,
        id_ldx_certPairExactAssertion,
        id_ldx_certPairAssertion,
        id_ldx_certListExactAssertion,
        id_ldx_certListAssertion,
        id_ldx_algorithmIdentifier,
    ]

class CommonProtocolSpecification:

    _name_  = u'CommonProtocolSpecification'
    _oid_   = [2, 5, 1, 35, 7]
    
    _obj_ = [
        u'OPERATION',
        u'ERROR',
        u'Code',
        u'InvokeId',
        u'id-opcode-read',
        u'id-opcode-compare',
        u'id-opcode-abandon',
        u'id-opcode-list',
        u'id-opcode-search',
        u'id-opcode-addEntry',
        u'id-opcode-removeEntry',
        u'id-opcode-modifyEntry',
        u'id-opcode-modifyDN',
        u'id-opcode-changePassword',
        u'id-opcode-administerPassword',
        u'id-opcode-ldapTransport',
        u'id-opcode-linkedLDAP',
        u'id-opcode-requestShadowUpdate',
        u'id-opcode-updateShadow',
        u'id-opcode-coordinateShadowUpdate',
        u'id-op-establishOperationalBinding',
        u'id-op-modifyOperationalBinding',
        u'id-op-terminateOperationalBinding',
        u'id-errcode-attributeError',
        u'id-errcode-nameError',
        u'id-errcode-serviceError',
        u'id-errcode-referral',
        u'id-errcode-abandoned',
        u'id-errcode-securityError',
        u'id-errcode-abandonFailed',
        u'id-errcode-updateError',
        u'id-errcode-dsaReferral',
        u'id-errcode-shadowError',
        u'id-err-operationalBindingError',
        u'DOP-Invokable',
        u'DOP-Returnable',
        ]
    _type_ = [
        u'OPERATION',
        u'ERROR',
        u'Code',
        u'InvokeId',
        ]
    _set_ = [
        u'DOP-Invokable',
        u'DOP-Returnable',
        ]
    _val_ = [
        u'id-opcode-read',
        u'id-opcode-compare',
        u'id-opcode-abandon',
        u'id-opcode-list',
        u'id-opcode-search',
        u'id-opcode-addEntry',
        u'id-opcode-removeEntry',
        u'id-opcode-modifyEntry',
        u'id-opcode-modifyDN',
        u'id-opcode-changePassword',
        u'id-opcode-administerPassword',
        u'id-opcode-ldapTransport',
        u'id-opcode-linkedLDAP',
        u'id-opcode-requestShadowUpdate',
        u'id-opcode-updateShadow',
        u'id-opcode-coordinateShadowUpdate',
        u'id-op-establishOperationalBinding',
        u'id-op-modifyOperationalBinding',
        u'id-op-terminateOperationalBinding',
        u'id-errcode-attributeError',
        u'id-errcode-nameError',
        u'id-errcode-serviceError',
        u'id-errcode-referral',
        u'id-errcode-abandoned',
        u'id-errcode-securityError',
        u'id-errcode-abandonFailed',
        u'id-errcode-updateError',
        u'id-errcode-dsaReferral',
        u'id-errcode-shadowError',
        u'id-err-operationalBindingError',
        ]
    _class_ = [
        u'OPERATION',
        u'ERROR',
        u'DOP-Invokable',
        u'DOP-Returnable',
        ]
    _param_ = [
        ]
    
    #-----< OPERATION >-----#
    OPERATION = CLASS(name=u'OPERATION', mode=MODE_TYPE)
    _OPERATION_ArgumentType = OPEN(name=u'ArgumentType', mode=MODE_TYPE, opt=True)
    _OPERATION_ResultType = OPEN(name=u'ResultType', mode=MODE_TYPE, opt=True)
    _OPERATION_Errors = CLASS(name=u'Errors', mode=MODE_SET, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')), opt=True)
    _OPERATION_operationCode = CHOICE(name=u'operationCode', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')), opt=True, uniq=True)
    OPERATION._cont = ASN1Dict([
        (u'ArgumentType', _OPERATION_ArgumentType),
        (u'ResultType', _OPERATION_ResultType),
        (u'Errors', _OPERATION_Errors),
        (u'operationCode', _OPERATION_operationCode),
        ])
    
    #-----< ERROR >-----#
    ERROR = CLASS(name=u'ERROR', mode=MODE_TYPE)
    _ERROR_ParameterType = OPEN(name=u'ParameterType', mode=MODE_TYPE)
    _ERROR_errorCode = CHOICE(name=u'errorCode', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')), opt=True, uniq=True)
    ERROR._cont = ASN1Dict([
        (u'ParameterType', _ERROR_ParameterType),
        (u'errorCode', _ERROR_errorCode),
        ])
    
    #-----< Code >-----#
    Code = CHOICE(name=u'Code', mode=MODE_TYPE)
    _Code_local = INT(name=u'local', mode=MODE_TYPE)
    _Code_global_ = OID(name=u'global', mode=MODE_TYPE)
    Code._cont = ASN1Dict([
        (u'local', _Code_local),
        (u'global', _Code_global_),
        ])
    Code._ext = []
    
    #-----< InvokeId >-----#
    InvokeId = CHOICE(name=u'InvokeId', mode=MODE_TYPE)
    _InvokeId_present = INT(name=u'present', mode=MODE_TYPE)
    _InvokeId_absent = NULL(name=u'absent', mode=MODE_TYPE)
    InvokeId._cont = ASN1Dict([
        (u'present', _InvokeId_present),
        (u'absent', _InvokeId_absent),
        ])
    InvokeId._ext = []
    
    #-----< id-opcode-read >-----#
    id_opcode_read = CHOICE(name=u'id-opcode-read', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_read._val = (u'local', 1)
    
    #-----< id-opcode-compare >-----#
    id_opcode_compare = CHOICE(name=u'id-opcode-compare', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_compare._val = (u'local', 2)
    
    #-----< id-opcode-abandon >-----#
    id_opcode_abandon = CHOICE(name=u'id-opcode-abandon', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_abandon._val = (u'local', 3)
    
    #-----< id-opcode-list >-----#
    id_opcode_list = CHOICE(name=u'id-opcode-list', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_list._val = (u'local', 4)
    
    #-----< id-opcode-search >-----#
    id_opcode_search = CHOICE(name=u'id-opcode-search', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_search._val = (u'local', 5)
    
    #-----< id-opcode-addEntry >-----#
    id_opcode_addEntry = CHOICE(name=u'id-opcode-addEntry', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_addEntry._val = (u'local', 6)
    
    #-----< id-opcode-removeEntry >-----#
    id_opcode_removeEntry = CHOICE(name=u'id-opcode-removeEntry', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_removeEntry._val = (u'local', 7)
    
    #-----< id-opcode-modifyEntry >-----#
    id_opcode_modifyEntry = CHOICE(name=u'id-opcode-modifyEntry', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_modifyEntry._val = (u'local', 8)
    
    #-----< id-opcode-modifyDN >-----#
    id_opcode_modifyDN = CHOICE(name=u'id-opcode-modifyDN', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_modifyDN._val = (u'local', 9)
    
    #-----< id-opcode-changePassword >-----#
    id_opcode_changePassword = CHOICE(name=u'id-opcode-changePassword', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_changePassword._val = (u'local', 10)
    
    #-----< id-opcode-administerPassword >-----#
    id_opcode_administerPassword = CHOICE(name=u'id-opcode-administerPassword', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_administerPassword._val = (u'local', 11)
    
    #-----< id-opcode-ldapTransport >-----#
    id_opcode_ldapTransport = CHOICE(name=u'id-opcode-ldapTransport', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_ldapTransport._val = (u'local', 12)
    
    #-----< id-opcode-linkedLDAP >-----#
    id_opcode_linkedLDAP = CHOICE(name=u'id-opcode-linkedLDAP', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_linkedLDAP._val = (u'local', 13)
    
    #-----< id-opcode-requestShadowUpdate >-----#
    id_opcode_requestShadowUpdate = CHOICE(name=u'id-opcode-requestShadowUpdate', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_requestShadowUpdate._val = (u'local', 1)
    
    #-----< id-opcode-updateShadow >-----#
    id_opcode_updateShadow = CHOICE(name=u'id-opcode-updateShadow', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_updateShadow._val = (u'local', 2)
    
    #-----< id-opcode-coordinateShadowUpdate >-----#
    id_opcode_coordinateShadowUpdate = CHOICE(name=u'id-opcode-coordinateShadowUpdate', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_opcode_coordinateShadowUpdate._val = (u'local', 3)
    
    #-----< id-op-establishOperationalBinding >-----#
    id_op_establishOperationalBinding = CHOICE(name=u'id-op-establishOperationalBinding', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_op_establishOperationalBinding._val = (u'local', 100)
    
    #-----< id-op-modifyOperationalBinding >-----#
    id_op_modifyOperationalBinding = CHOICE(name=u'id-op-modifyOperationalBinding', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_op_modifyOperationalBinding._val = (u'local', 102)
    
    #-----< id-op-terminateOperationalBinding >-----#
    id_op_terminateOperationalBinding = CHOICE(name=u'id-op-terminateOperationalBinding', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_op_terminateOperationalBinding._val = (u'local', 101)
    
    #-----< id-errcode-attributeError >-----#
    id_errcode_attributeError = CHOICE(name=u'id-errcode-attributeError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_attributeError._val = (u'local', 1)
    
    #-----< id-errcode-nameError >-----#
    id_errcode_nameError = CHOICE(name=u'id-errcode-nameError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_nameError._val = (u'local', 2)
    
    #-----< id-errcode-serviceError >-----#
    id_errcode_serviceError = CHOICE(name=u'id-errcode-serviceError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_serviceError._val = (u'local', 3)
    
    #-----< id-errcode-referral >-----#
    id_errcode_referral = CHOICE(name=u'id-errcode-referral', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_referral._val = (u'local', 4)
    
    #-----< id-errcode-abandoned >-----#
    id_errcode_abandoned = CHOICE(name=u'id-errcode-abandoned', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_abandoned._val = (u'local', 5)
    
    #-----< id-errcode-securityError >-----#
    id_errcode_securityError = CHOICE(name=u'id-errcode-securityError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_securityError._val = (u'local', 6)
    
    #-----< id-errcode-abandonFailed >-----#
    id_errcode_abandonFailed = CHOICE(name=u'id-errcode-abandonFailed', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_abandonFailed._val = (u'local', 7)
    
    #-----< id-errcode-updateError >-----#
    id_errcode_updateError = CHOICE(name=u'id-errcode-updateError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_updateError._val = (u'local', 8)
    
    #-----< id-errcode-dsaReferral >-----#
    id_errcode_dsaReferral = CHOICE(name=u'id-errcode-dsaReferral', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_dsaReferral._val = (u'local', 9)
    
    #-----< id-errcode-shadowError >-----#
    id_errcode_shadowError = CHOICE(name=u'id-errcode-shadowError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_errcode_shadowError._val = (u'local', 1)
    
    #-----< id-err-operationalBindingError >-----#
    id_err_operationalBindingError = CHOICE(name=u'id-err-operationalBindingError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')))
    id_err_operationalBindingError._val = (u'local', 100)
    
    #-----< DOP-Invokable >-----#
    DOP_Invokable = CLASS(name=u'DOP-Invokable', mode=MODE_SET, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _DOP_Invokable_val_ArgumentType_0 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'EstablishOperationalBindingArgument')))
    _DOP_Invokable_val_ResultType_0 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'EstablishOperationalBindingResult')))
    __OPERATION_Errors_val_ParameterType_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    ___OPERATION_Errors_val_ParameterType_0_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'OpBindingErrorParam')))
    ___OPERATION_Errors_val_ParameterType_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'OpBindingErrorParam')))
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_0_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_0_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_0._ext = None
    __OPERATION_Errors_val_ParameterType_1 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_1_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ___OPERATION_Errors_val_ParameterType_1_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_1_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_1_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_1_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_1_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_1_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_1_signed._ext = []
    __OPERATION_Errors_val_ParameterType_1._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_1_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_1_signed),
        ])
    __OPERATION_Errors_val_ParameterType_1._ext = None
    _DOP_Invokable_val_ArgumentType_1 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'ModifyOperationalBindingArgument')))
    _DOP_Invokable_val_ResultType_1 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'ModifyOperationalBindingResult')))
    _DOP_Invokable_val_ArgumentType_2 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'TerminateOperationalBindingArgument')))
    _DOP_Invokable_val_ResultType_2 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'TerminateOperationalBindingResult')))
    DOP_Invokable._val = ASN1Set(rv=[dict([(u'ArgumentType', _DOP_Invokable_val_ArgumentType_0), (u'ResultType', _DOP_Invokable_val_ResultType_0), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 100))]), dict([(u'ArgumentType', _DOP_Invokable_val_ArgumentType_1), (u'ResultType', _DOP_Invokable_val_ResultType_1), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 102))]), dict([(u'ArgumentType', _DOP_Invokable_val_ArgumentType_2), (u'ResultType', _DOP_Invokable_val_ResultType_2), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 101))])], rr=[], ev=None, er=[])
    
    #-----< DOP-Returnable >-----#
    DOP_Returnable = CLASS(name=u'DOP-Returnable', mode=MODE_SET, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _DOP_Returnable_val_ArgumentType_0 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'EstablishOperationalBindingArgument')))
    _DOP_Returnable_val_ResultType_0 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'EstablishOperationalBindingResult')))
    _DOP_Returnable_val_ArgumentType_1 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'ModifyOperationalBindingArgument')))
    _DOP_Returnable_val_ResultType_1 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'ModifyOperationalBindingResult')))
    _DOP_Returnable_val_ArgumentType_2 = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'TerminateOperationalBindingArgument')))
    _DOP_Returnable_val_ResultType_2 = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('OperationalBindingManagement', 'TerminateOperationalBindingResult')))
    DOP_Returnable._val = ASN1Set(rv=[dict([(u'ArgumentType', _DOP_Returnable_val_ArgumentType_0), (u'ResultType', _DOP_Returnable_val_ResultType_0), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 100))]), dict([(u'ArgumentType', _DOP_Returnable_val_ArgumentType_1), (u'ResultType', _DOP_Returnable_val_ResultType_1), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 102))]), dict([(u'ArgumentType', _DOP_Returnable_val_ArgumentType_2), (u'ResultType', _DOP_Returnable_val_ResultType_2), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0), (u'errorCode', (u'local', 100))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 101))])], rr=[], ev=None, er=[])
    
    _all_ = [
        _OPERATION_ArgumentType,
        _OPERATION_ResultType,
        _OPERATION_Errors,
        _OPERATION_operationCode,
        OPERATION,
        _ERROR_ParameterType,
        _ERROR_errorCode,
        ERROR,
        _Code_local,
        _Code_global_,
        Code,
        _InvokeId_present,
        _InvokeId_absent,
        InvokeId,
        id_opcode_read,
        id_opcode_compare,
        id_opcode_abandon,
        id_opcode_list,
        id_opcode_search,
        id_opcode_addEntry,
        id_opcode_removeEntry,
        id_opcode_modifyEntry,
        id_opcode_modifyDN,
        id_opcode_changePassword,
        id_opcode_administerPassword,
        id_opcode_ldapTransport,
        id_opcode_linkedLDAP,
        id_opcode_requestShadowUpdate,
        id_opcode_updateShadow,
        id_opcode_coordinateShadowUpdate,
        id_op_establishOperationalBinding,
        id_op_modifyOperationalBinding,
        id_op_terminateOperationalBinding,
        id_errcode_attributeError,
        id_errcode_nameError,
        id_errcode_serviceError,
        id_errcode_referral,
        id_errcode_abandoned,
        id_errcode_securityError,
        id_errcode_abandonFailed,
        id_errcode_updateError,
        id_errcode_dsaReferral,
        id_errcode_shadowError,
        id_err_operationalBindingError,
        DOP_Invokable,
        _DOP_Invokable_val_ArgumentType_0,
        _DOP_Invokable_val_ResultType_0,
        ___OPERATION_Errors_val_ParameterType_0_unsigned,
        ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned,
        ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab,
        _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm,
        ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters_tab,
        _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters,
        ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier,
        ____OPERATION_Errors_val_ParameterType_0_signed_encrypted,
        ___OPERATION_Errors_val_ParameterType_0_signed,
        __OPERATION_Errors_val_ParameterType_0,
        ___OPERATION_Errors_val_ParameterType_1_unsigned,
        ____OPERATION_Errors_val_ParameterType_1_signed_toBeSigned,
        ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm_tab,
        _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm,
        ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters_tab,
        _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters,
        ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier,
        ____OPERATION_Errors_val_ParameterType_1_signed_encrypted,
        ___OPERATION_Errors_val_ParameterType_1_signed,
        __OPERATION_Errors_val_ParameterType_1,
        _DOP_Invokable_val_ArgumentType_1,
        _DOP_Invokable_val_ResultType_1,
        _DOP_Invokable_val_ArgumentType_2,
        _DOP_Invokable_val_ResultType_2,
        DOP_Returnable,
        _DOP_Returnable_val_ArgumentType_0,
        _DOP_Returnable_val_ResultType_0,
        _DOP_Returnable_val_ArgumentType_1,
        _DOP_Returnable_val_ResultType_1,
        _DOP_Returnable_val_ArgumentType_2,
        _DOP_Returnable_val_ResultType_2,
    ]

class DirectoryAbstractService:

    _name_  = u'DirectoryAbstractService'
    _oid_   = [2, 5, 1, 2, 7]
    
    _obj_ = [
        u'CommonArguments',
        u'CommonArgumentsSeq',
        u'FamilyGrouping',
        u'CommonResults',
        u'CommonResultsSeq',
        u'ServiceControls',
        u'ServiceControlOptions',
        u'EntryInformationSelection',
        u'ContextSelection',
        u'TypeAndContextAssertion',
        u'FamilyReturn',
        u'EntryInformation',
        u'family-information',
        u'FamilyEntries',
        u'FamilyEntry',
        u'Filter',
        u'FilterItem',
        u'MatchingRuleAssertion',
        u'PagedResultsRequest',
        u'SortKey',
        u'SecurityParameters',
        u'ProtectionRequest',
        u'Time',
        u'ErrorProtectionRequest',
        u'directoryBind',
        u'DirectoryBindArgument',
        u'Credentials',
        u'SimpleCredentials',
        u'StrongCredentials',
        u'SpkmCredentials',
        u'SaslCredentials',
        u'ub-saslMechanism',
        u'Token',
        u'TokenContent',
        u'Versions',
        u'DirectoryBindResult',
        u'PwdResponseValue',
        u'directoryBindError',
        u'BindKeyInfo',
        u'read',
        u'ReadArgument',
        u'ReadArgumentData',
        u'ReadResult',
        u'ReadResultData',
        u'ModifyRights',
        u'compare',
        u'CompareArgument',
        u'CompareArgumentData',
        u'CompareResult',
        u'CompareResultData',
        u'abandon',
        u'AbandonArgument',
        u'AbandonArgumentData',
        u'AbandonResult',
        u'AbandonResultData',
        u'list',
        u'ListArgument',
        u'ListArgumentData',
        u'ListResult',
        u'ListResultData',
        u'PartialOutcomeQualifier',
        u'LimitProblem',
        u'search',
        u'SearchArgument',
        u'SearchArgumentData',
        u'HierarchySelections',
        u'SearchControlOptions',
        u'JoinArgument',
        u'DomainLocalID',
        u'JoinAttPair',
        u'JoinContextType',
        u'SearchResult',
        u'SearchResultData',
        u'addEntry',
        u'AddEntryArgument',
        u'AddEntryArgumentData',
        u'AddEntryResult',
        u'AddEntryResultData',
        u'removeEntry',
        u'RemoveEntryArgument',
        u'RemoveEntryArgumentData',
        u'RemoveEntryResult',
        u'RemoveEntryResultData',
        u'modifyEntry',
        u'ModifyEntryArgument',
        u'ModifyEntryArgumentData',
        u'ModifyEntryResult',
        u'ModifyEntryResultData',
        u'EntryModification',
        u'modifyDN',
        u'ModifyDNArgument',
        u'ModifyDNArgumentData',
        u'ModifyDNResult',
        u'ModifyDNResultData',
        u'changePassword',
        u'ChangePasswordArgument',
        u'ChangePasswordArgumentData',
        u'ChangePasswordResult',
        u'ChangePasswordResultData',
        u'administerPassword',
        u'AdministerPasswordArgument',
        u'AdministerPasswordArgumentData',
        u'AdministerPasswordResult',
        u'AdministerPasswordResultData',
        u'ldapTransport',
        u'LdapArgument',
        u'LdapArgumentData',
        u'LinkId',
        u'LdapResult',
        u'LdapResultData',
        u'linkedLDAP',
        u'LinkedArgument',
        u'LinkedArgumentData',
        u'LinkedResult',
        u'abandoned',
        u'AbandonedData',
        u'AbandonedProblem',
        u'abandonFailed',
        u'AbandonFailedData',
        u'AbandonProblem',
        u'attributeError',
        u'AttributeErrorData',
        u'AttributeProblem',
        u'nameError',
        u'NameErrorData',
        u'NameProblem',
        u'referral',
        u'ReferralData',
        u'securityError',
        u'SecurityErrorData',
        u'SecurityProblem',
        u'EncPwdInfo',
        u'serviceError',
        u'ServiceErrorData',
        u'ServiceProblem',
        u'updateError',
        u'UpdateErrorData',
        u'UpdateProblem',
        u'id-at-family-information',
        ]
    _type_ = [
        u'CommonArguments',
        u'CommonArgumentsSeq',
        u'FamilyGrouping',
        u'CommonResults',
        u'CommonResultsSeq',
        u'ServiceControls',
        u'ServiceControlOptions',
        u'EntryInformationSelection',
        u'ContextSelection',
        u'TypeAndContextAssertion',
        u'FamilyReturn',
        u'EntryInformation',
        u'FamilyEntries',
        u'FamilyEntry',
        u'Filter',
        u'FilterItem',
        u'MatchingRuleAssertion',
        u'PagedResultsRequest',
        u'SortKey',
        u'SecurityParameters',
        u'ProtectionRequest',
        u'Time',
        u'ErrorProtectionRequest',
        u'DirectoryBindArgument',
        u'Credentials',
        u'SimpleCredentials',
        u'StrongCredentials',
        u'SpkmCredentials',
        u'SaslCredentials',
        u'Token',
        u'TokenContent',
        u'Versions',
        u'DirectoryBindResult',
        u'PwdResponseValue',
        u'BindKeyInfo',
        u'ReadArgument',
        u'ReadArgumentData',
        u'ReadResult',
        u'ReadResultData',
        u'ModifyRights',
        u'CompareArgument',
        u'CompareArgumentData',
        u'CompareResult',
        u'CompareResultData',
        u'AbandonArgument',
        u'AbandonArgumentData',
        u'AbandonResult',
        u'AbandonResultData',
        u'ListArgument',
        u'ListArgumentData',
        u'ListResult',
        u'ListResultData',
        u'PartialOutcomeQualifier',
        u'LimitProblem',
        u'SearchArgument',
        u'SearchArgumentData',
        u'HierarchySelections',
        u'SearchControlOptions',
        u'JoinArgument',
        u'DomainLocalID',
        u'JoinAttPair',
        u'JoinContextType',
        u'SearchResult',
        u'SearchResultData',
        u'AddEntryArgument',
        u'AddEntryArgumentData',
        u'AddEntryResult',
        u'AddEntryResultData',
        u'RemoveEntryArgument',
        u'RemoveEntryArgumentData',
        u'RemoveEntryResult',
        u'RemoveEntryResultData',
        u'ModifyEntryArgument',
        u'ModifyEntryArgumentData',
        u'ModifyEntryResult',
        u'ModifyEntryResultData',
        u'EntryModification',
        u'ModifyDNArgument',
        u'ModifyDNArgumentData',
        u'ModifyDNResult',
        u'ModifyDNResultData',
        u'ChangePasswordArgument',
        u'ChangePasswordArgumentData',
        u'ChangePasswordResult',
        u'ChangePasswordResultData',
        u'AdministerPasswordArgument',
        u'AdministerPasswordArgumentData',
        u'AdministerPasswordResult',
        u'AdministerPasswordResultData',
        u'LdapArgument',
        u'LdapArgumentData',
        u'LinkId',
        u'LdapResult',
        u'LdapResultData',
        u'LinkedArgument',
        u'LinkedArgumentData',
        u'LinkedResult',
        u'AbandonedData',
        u'AbandonedProblem',
        u'AbandonFailedData',
        u'AbandonProblem',
        u'AttributeErrorData',
        u'AttributeProblem',
        u'NameErrorData',
        u'NameProblem',
        u'ReferralData',
        u'SecurityErrorData',
        u'SecurityProblem',
        u'EncPwdInfo',
        u'ServiceErrorData',
        u'ServiceProblem',
        u'UpdateErrorData',
        u'UpdateProblem',
        ]
    _set_ = [
        ]
    _val_ = [
        u'family-information',
        u'directoryBind',
        u'ub-saslMechanism',
        u'directoryBindError',
        u'read',
        u'compare',
        u'abandon',
        u'list',
        u'search',
        u'addEntry',
        u'removeEntry',
        u'modifyEntry',
        u'modifyDN',
        u'changePassword',
        u'administerPassword',
        u'ldapTransport',
        u'linkedLDAP',
        u'abandoned',
        u'abandonFailed',
        u'attributeError',
        u'nameError',
        u'referral',
        u'securityError',
        u'serviceError',
        u'updateError',
        u'id-at-family-information',
        ]
    _class_ = [
        u'family-information',
        u'directoryBind',
        u'directoryBindError',
        u'read',
        u'compare',
        u'abandon',
        u'list',
        u'search',
        u'addEntry',
        u'removeEntry',
        u'modifyEntry',
        u'modifyDN',
        u'changePassword',
        u'administerPassword',
        u'ldapTransport',
        u'linkedLDAP',
        u'abandoned',
        u'abandonFailed',
        u'attributeError',
        u'nameError',
        u'referral',
        u'securityError',
        u'serviceError',
        u'updateError',
        ]
    _param_ = [
        ]
    
    #-----< CommonArguments >-----#
    CommonArguments = SET(name=u'CommonArguments', mode=MODE_TYPE)
    _CommonArguments_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _CommonArguments_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CommonArguments_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CommonArguments_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _CommonArguments_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CommonArguments_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CommonArguments_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _CommonArguments_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _CommonArguments_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _CommonArguments_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CommonArguments_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _CommonArguments_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    CommonArguments._cont = ASN1Dict([
        (u'serviceControls', _CommonArguments_serviceControls),
        (u'securityParameters', _CommonArguments_securityParameters),
        (u'requestor', _CommonArguments_requestor),
        (u'operationProgress', _CommonArguments_operationProgress),
        (u'aliasedRDNs', _CommonArguments_aliasedRDNs),
        (u'criticalExtensions', _CommonArguments_criticalExtensions),
        (u'referenceType', _CommonArguments_referenceType),
        (u'entryOnly', _CommonArguments_entryOnly),
        (u'exclusions', _CommonArguments_exclusions),
        (u'nameResolveOnMaster', _CommonArguments_nameResolveOnMaster),
        (u'operationContexts', _CommonArguments_operationContexts),
        (u'familyGrouping', _CommonArguments_familyGrouping),
        ])
    CommonArguments._ext = []
    
    #-----< CommonArgumentsSeq >-----#
    CommonArgumentsSeq = SEQ(name=u'CommonArgumentsSeq', mode=MODE_TYPE)
    _CommonArgumentsSeq_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _CommonArgumentsSeq_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CommonArgumentsSeq_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CommonArgumentsSeq_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _CommonArgumentsSeq_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CommonArgumentsSeq_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CommonArgumentsSeq_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _CommonArgumentsSeq_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _CommonArgumentsSeq_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _CommonArgumentsSeq_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CommonArgumentsSeq_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _CommonArgumentsSeq_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    CommonArgumentsSeq._cont = ASN1Dict([
        (u'serviceControls', _CommonArgumentsSeq_serviceControls),
        (u'securityParameters', _CommonArgumentsSeq_securityParameters),
        (u'requestor', _CommonArgumentsSeq_requestor),
        (u'operationProgress', _CommonArgumentsSeq_operationProgress),
        (u'aliasedRDNs', _CommonArgumentsSeq_aliasedRDNs),
        (u'criticalExtensions', _CommonArgumentsSeq_criticalExtensions),
        (u'referenceType', _CommonArgumentsSeq_referenceType),
        (u'entryOnly', _CommonArgumentsSeq_entryOnly),
        (u'exclusions', _CommonArgumentsSeq_exclusions),
        (u'nameResolveOnMaster', _CommonArgumentsSeq_nameResolveOnMaster),
        (u'operationContexts', _CommonArgumentsSeq_operationContexts),
        (u'familyGrouping', _CommonArgumentsSeq_familyGrouping),
        ])
    CommonArgumentsSeq._ext = []
    
    #-----< FamilyGrouping >-----#
    FamilyGrouping = ENUM(name=u'FamilyGrouping', mode=MODE_TYPE)
    FamilyGrouping._cont = ASN1Dict([(u'entryOnly', 1), (u'compoundEntry', 2), (u'strands', 3), (u'multiStrand', 4)])
    FamilyGrouping._ext = []
    
    #-----< CommonResults >-----#
    CommonResults = SET(name=u'CommonResults', mode=MODE_TYPE)
    _CommonResults_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CommonResults_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CommonResults_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CommonResults_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __CommonResults_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___CommonResults_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____CommonResults_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____CommonResults_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType = OID(name=u'AssertionType', mode=MODE_TYPE)
    _____CommonResults_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0 = SEQ_OF(name=u'AssertionType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____CommonResults_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____CommonResults_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____CommonResults_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___CommonResults_notification__item__type._const_tab = ____CommonResults_notification__item__type_tab
    ___CommonResults_notification__item__type._const_tab_at = None
    ___CommonResults_notification__item__type._const_tab_id = u'id'
    ___CommonResults_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____CommonResults_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____CommonResults_notification__item__values__item_._const_tab = ____CommonResults_notification__item__type_tab
    ____CommonResults_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____CommonResults_notification__item__values__item_._const_tab_id = u'Type'
    ___CommonResults_notification__item__values._cont = ____CommonResults_notification__item__values__item_
    ___CommonResults_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___CommonResults_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____CommonResults_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____CommonResults_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____CommonResults_notification__item__valuesWithContext__item__value._const_tab = ____CommonResults_notification__item__type_tab
    _____CommonResults_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____CommonResults_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____CommonResults_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______CommonResults_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____CommonResults_notification__item__valuesWithContext__item__contextList._cont = ______CommonResults_notification__item__valuesWithContext__item__contextList__item_
    _____CommonResults_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____CommonResults_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____CommonResults_notification__item__valuesWithContext__item__value),
        (u'contextList', _____CommonResults_notification__item__valuesWithContext__item__contextList),
        ])
    ____CommonResults_notification__item__valuesWithContext__item_._ext = []
    ___CommonResults_notification__item__valuesWithContext._cont = ____CommonResults_notification__item__valuesWithContext__item_
    ___CommonResults_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __CommonResults_notification__item_._cont = ASN1Dict([
        (u'type', ___CommonResults_notification__item__type),
        (u'values', ___CommonResults_notification__item__values),
        (u'valuesWithContext', ___CommonResults_notification__item__valuesWithContext),
        ])
    __CommonResults_notification__item_._ext = []
    _CommonResults_notification._cont = __CommonResults_notification__item_
    _CommonResults_notification._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    CommonResults._cont = ASN1Dict([
        (u'securityParameters', _CommonResults_securityParameters),
        (u'performer', _CommonResults_performer),
        (u'aliasDereferenced', _CommonResults_aliasDereferenced),
        (u'notification', _CommonResults_notification),
        ])
    CommonResults._ext = []
    
    #-----< CommonResultsSeq >-----#
    CommonResultsSeq = SEQ(name=u'CommonResultsSeq', mode=MODE_TYPE)
    _CommonResultsSeq_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CommonResultsSeq_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CommonResultsSeq_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CommonResultsSeq_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __CommonResultsSeq_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___CommonResultsSeq_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____CommonResultsSeq_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____CommonResultsSeq_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____CommonResultsSeq_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____CommonResultsSeq_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____CommonResultsSeq_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____CommonResultsSeq_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___CommonResultsSeq_notification__item__type._const_tab = ____CommonResultsSeq_notification__item__type_tab
    ___CommonResultsSeq_notification__item__type._const_tab_at = None
    ___CommonResultsSeq_notification__item__type._const_tab_id = u'id'
    ___CommonResultsSeq_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____CommonResultsSeq_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____CommonResultsSeq_notification__item__values__item_._const_tab = ____CommonResultsSeq_notification__item__type_tab
    ____CommonResultsSeq_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____CommonResultsSeq_notification__item__values__item_._const_tab_id = u'Type'
    ___CommonResultsSeq_notification__item__values._cont = ____CommonResultsSeq_notification__item__values__item_
    ___CommonResultsSeq_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___CommonResultsSeq_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____CommonResultsSeq_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____CommonResultsSeq_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____CommonResultsSeq_notification__item__valuesWithContext__item__value._const_tab = ____CommonResultsSeq_notification__item__type_tab
    _____CommonResultsSeq_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____CommonResultsSeq_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____CommonResultsSeq_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______CommonResultsSeq_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____CommonResultsSeq_notification__item__valuesWithContext__item__contextList._cont = ______CommonResultsSeq_notification__item__valuesWithContext__item__contextList__item_
    _____CommonResultsSeq_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____CommonResultsSeq_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____CommonResultsSeq_notification__item__valuesWithContext__item__value),
        (u'contextList', _____CommonResultsSeq_notification__item__valuesWithContext__item__contextList),
        ])
    ____CommonResultsSeq_notification__item__valuesWithContext__item_._ext = []
    ___CommonResultsSeq_notification__item__valuesWithContext._cont = ____CommonResultsSeq_notification__item__valuesWithContext__item_
    ___CommonResultsSeq_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __CommonResultsSeq_notification__item_._cont = ASN1Dict([
        (u'type', ___CommonResultsSeq_notification__item__type),
        (u'values', ___CommonResultsSeq_notification__item__values),
        (u'valuesWithContext', ___CommonResultsSeq_notification__item__valuesWithContext),
        ])
    __CommonResultsSeq_notification__item_._ext = []
    _CommonResultsSeq_notification._cont = __CommonResultsSeq_notification__item_
    _CommonResultsSeq_notification._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    CommonResultsSeq._cont = ASN1Dict([
        (u'securityParameters', _CommonResultsSeq_securityParameters),
        (u'performer', _CommonResultsSeq_performer),
        (u'aliasDereferenced', _CommonResultsSeq_aliasDereferenced),
        (u'notification', _CommonResultsSeq_notification),
        ])
    CommonResultsSeq._ext = []
    
    #-----< ServiceControls >-----#
    ServiceControls = SET(name=u'ServiceControls', mode=MODE_TYPE)
    _ServiceControls_options = BIT_STR(name=u'options', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControlOptions')), default=(0, 0))
    _ServiceControls_priority = INT(name=u'priority', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _ServiceControls_priority._cont = ASN1Dict([(u'low', 0), (u'medium', 1), (u'high', 2)])
    _ServiceControls_timeLimit = INT(name=u'timeLimit', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ServiceControls_sizeLimit = INT(name=u'sizeLimit', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ServiceControls_scopeOfReferral = INT(name=u'scopeOfReferral', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ServiceControls_scopeOfReferral._cont = ASN1Dict([(u'dmd', 0), (u'country', 1)])
    _ServiceControls_attributeSizeLimit = INT(name=u'attributeSizeLimit', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ServiceControls_manageDSAITPlaneRef = SEQ(name=u'manageDSAITPlaneRef', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ServiceControls_manageDSAITPlaneRef_dsaName = CHOICE(name=u'dsaName', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    __ServiceControls_manageDSAITPlaneRef_agreementID = SEQ(name=u'agreementID', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryShadowAbstractService', 'AgreementID')))
    _ServiceControls_manageDSAITPlaneRef._cont = ASN1Dict([
        (u'dsaName', __ServiceControls_manageDSAITPlaneRef_dsaName),
        (u'agreementID', __ServiceControls_manageDSAITPlaneRef_agreementID),
        ])
    _ServiceControls_manageDSAITPlaneRef._ext = []
    _ServiceControls_serviceType = OID(name=u'serviceType', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ServiceControls_userClass = INT(name=u'userClass', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ServiceControls._cont = ASN1Dict([
        (u'options', _ServiceControls_options),
        (u'priority', _ServiceControls_priority),
        (u'timeLimit', _ServiceControls_timeLimit),
        (u'sizeLimit', _ServiceControls_sizeLimit),
        (u'scopeOfReferral', _ServiceControls_scopeOfReferral),
        (u'attributeSizeLimit', _ServiceControls_attributeSizeLimit),
        (u'manageDSAITPlaneRef', _ServiceControls_manageDSAITPlaneRef),
        (u'serviceType', _ServiceControls_serviceType),
        (u'userClass', _ServiceControls_userClass),
        ])
    ServiceControls._ext = []
    
    #-----< ServiceControlOptions >-----#
    ServiceControlOptions = BIT_STR(name=u'ServiceControlOptions', mode=MODE_TYPE)
    ServiceControlOptions._cont = ASN1Dict([(u'preferChaining', 0), (u'chainingProhibited', 1), (u'localScope', 2), (u'dontUseCopy', 3), (u'dontDereferenceAliases', 4), (u'subentries', 5), (u'copyShallDo', 6), (u'partialNameResolution', 7), (u'manageDSAIT', 8), (u'noSubtypeMatch', 9), (u'noSubtypeSelection', 10), (u'countFamily', 11), (u'dontSelectFriends', 12), (u'dontMatchFriends', 13), (u'allowWriteableCopy', 14)])
    
    #-----< EntryInformationSelection >-----#
    EntryInformationSelection = SET(name=u'EntryInformationSelection', mode=MODE_TYPE)
    _EntryInformationSelection_attributes = CHOICE(name=u'attributes', mode=MODE_TYPE, default=(u'allUserAttributes', 0))
    __EntryInformationSelection_attributes_allUserAttributes = NULL(name=u'allUserAttributes', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EntryInformationSelection_attributes_select = SET_OF(name=u'select', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EntryInformationSelection_attributes_select__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    __EntryInformationSelection_attributes_select._cont = ___EntryInformationSelection_attributes_select__item_
    _EntryInformationSelection_attributes._cont = ASN1Dict([
        (u'allUserAttributes', __EntryInformationSelection_attributes_allUserAttributes),
        (u'select', __EntryInformationSelection_attributes_select),
        ])
    _EntryInformationSelection_attributes._ext = None
    _EntryInformationSelection_infoTypes = INT(name=u'infoTypes', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=1)
    _EntryInformationSelection_infoTypes._cont = ASN1Dict([(u'attributeTypesOnly', 0), (u'attributeTypesAndValues', 1)])
    _EntryInformationSelection_extraAttributes = CHOICE(name=u'extraAttributes', mode=MODE_TYPE, opt=True)
    __EntryInformationSelection_extraAttributes_allOperationalAttributes = NULL(name=u'allOperationalAttributes', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __EntryInformationSelection_extraAttributes_select = SET_OF(name=u'select', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___EntryInformationSelection_extraAttributes_select__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    __EntryInformationSelection_extraAttributes_select._cont = ___EntryInformationSelection_extraAttributes_select__item_
    __EntryInformationSelection_extraAttributes_select._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _EntryInformationSelection_extraAttributes._cont = ASN1Dict([
        (u'allOperationalAttributes', __EntryInformationSelection_extraAttributes_allOperationalAttributes),
        (u'select', __EntryInformationSelection_extraAttributes_select),
        ])
    _EntryInformationSelection_extraAttributes._ext = None
    _EntryInformationSelection_contextSelection = CHOICE(name=u'contextSelection', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _EntryInformationSelection_returnContexts = BOOL(name=u'returnContexts', mode=MODE_TYPE, default=False)
    _EntryInformationSelection_familyReturn = SEQ(name=u'familyReturn', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyReturn')), default=dict([(u'memberSelect', u'contributingEntriesOnly')]))
    EntryInformationSelection._cont = ASN1Dict([
        (u'attributes', _EntryInformationSelection_attributes),
        (u'infoTypes', _EntryInformationSelection_infoTypes),
        (u'extraAttributes', _EntryInformationSelection_extraAttributes),
        (u'contextSelection', _EntryInformationSelection_contextSelection),
        (u'returnContexts', _EntryInformationSelection_returnContexts),
        (u'familyReturn', _EntryInformationSelection_familyReturn),
        ])
    EntryInformationSelection._ext = None
    
    #-----< ContextSelection >-----#
    ContextSelection = CHOICE(name=u'ContextSelection', mode=MODE_TYPE)
    _ContextSelection_allContexts = NULL(name=u'allContexts', mode=MODE_TYPE)
    _ContextSelection_selectedContexts = SET_OF(name=u'selectedContexts', mode=MODE_TYPE)
    __ContextSelection_selectedContexts__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'TypeAndContextAssertion')))
    _ContextSelection_selectedContexts._cont = __ContextSelection_selectedContexts__item_
    _ContextSelection_selectedContexts._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ContextSelection._cont = ASN1Dict([
        (u'allContexts', _ContextSelection_allContexts),
        (u'selectedContexts', _ContextSelection_selectedContexts),
        ])
    ContextSelection._ext = []
    
    #-----< TypeAndContextAssertion >-----#
    TypeAndContextAssertion = SEQ(name=u'TypeAndContextAssertion', mode=MODE_TYPE)
    _TypeAndContextAssertion_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _TypeAndContextAssertion_contextAssertions = CHOICE(name=u'contextAssertions', mode=MODE_TYPE)
    __TypeAndContextAssertion_contextAssertions_preference = SEQ_OF(name=u'preference', mode=MODE_TYPE)
    ___TypeAndContextAssertion_contextAssertions_preference__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'ContextAssertion')))
    __TypeAndContextAssertion_contextAssertions_preference._cont = ___TypeAndContextAssertion_contextAssertions_preference__item_
    __TypeAndContextAssertion_contextAssertions_all = SET_OF(name=u'all', mode=MODE_TYPE)
    ___TypeAndContextAssertion_contextAssertions_all__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'ContextAssertion')))
    __TypeAndContextAssertion_contextAssertions_all._cont = ___TypeAndContextAssertion_contextAssertions_all__item_
    _TypeAndContextAssertion_contextAssertions._cont = ASN1Dict([
        (u'preference', __TypeAndContextAssertion_contextAssertions_preference),
        (u'all', __TypeAndContextAssertion_contextAssertions_all),
        ])
    _TypeAndContextAssertion_contextAssertions._ext = []
    TypeAndContextAssertion._cont = ASN1Dict([
        (u'type', _TypeAndContextAssertion_type),
        (u'contextAssertions', _TypeAndContextAssertion_contextAssertions),
        ])
    TypeAndContextAssertion._ext = []
    
    #-----< FamilyReturn >-----#
    FamilyReturn = SEQ(name=u'FamilyReturn', mode=MODE_TYPE)
    _FamilyReturn_memberSelect = ENUM(name=u'memberSelect', mode=MODE_TYPE)
    _FamilyReturn_memberSelect._cont = ASN1Dict([(u'contributingEntriesOnly', 1), (u'participatingEntriesOnly', 2), (u'compoundEntry', 3)])
    _FamilyReturn_memberSelect._ext = []
    _FamilyReturn_familySelect = SEQ_OF(name=u'familySelect', mode=MODE_TYPE, opt=True)
    __FamilyReturn_familySelect__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'OBJECT-CLASS'), [u'id']))
    _FamilyReturn_familySelect._cont = __FamilyReturn_familySelect__item_
    _FamilyReturn_familySelect._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    FamilyReturn._cont = ASN1Dict([
        (u'memberSelect', _FamilyReturn_memberSelect),
        (u'familySelect', _FamilyReturn_familySelect),
        ])
    FamilyReturn._ext = []
    
    #-----< EntryInformation >-----#
    EntryInformation = SEQ(name=u'EntryInformation', mode=MODE_TYPE)
    _EntryInformation_name = CHOICE(name=u'name', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')))
    _EntryInformation_fromEntry = BOOL(name=u'fromEntry', mode=MODE_TYPE, default=True)
    _EntryInformation_information = SET_OF(name=u'information', mode=MODE_TYPE, opt=True)
    __EntryInformation_information__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ___EntryInformation_information__item__attributeType = OID(name=u'attributeType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ___EntryInformation_information__item__attribute = SEQ(name=u'attribute', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ____EntryInformation_information__item__attribute_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _____EntryInformation_information__item__attribute_type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ______EntryInformation_information__item__attribute_type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______EntryInformation_information__item__attribute_type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _____EntryInformation_information__item__attribute_type_tab._val = ASN1Set(rv=[dict([(u'Type', ______EntryInformation_information__item__attribute_type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ______EntryInformation_information__item__attribute_type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ____EntryInformation_information__item__attribute_type._const_tab = _____EntryInformation_information__item__attribute_type_tab
    ____EntryInformation_information__item__attribute_type._const_tab_at = None
    ____EntryInformation_information__item__attribute_type._const_tab_id = u'id'
    ____EntryInformation_information__item__attribute_values = SET_OF(name=u'values', mode=MODE_TYPE)
    _____EntryInformation_information__item__attribute_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____EntryInformation_information__item__attribute_values__item_._const_tab = _____EntryInformation_information__item__attribute_type_tab
    _____EntryInformation_information__item__attribute_values__item_._const_tab_at = ('..', '..', u'type')
    _____EntryInformation_information__item__attribute_values__item_._const_tab_id = u'Type'
    ____EntryInformation_information__item__attribute_values._cont = _____EntryInformation_information__item__attribute_values__item_
    ____EntryInformation_information__item__attribute_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ____EntryInformation_information__item__attribute_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    _____EntryInformation_information__item__attribute_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ______EntryInformation_information__item__attribute_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______EntryInformation_information__item__attribute_valuesWithContext__item__value._const_tab = _____EntryInformation_information__item__attribute_type_tab
    ______EntryInformation_information__item__attribute_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ______EntryInformation_information__item__attribute_valuesWithContext__item__value._const_tab_id = u'Type'
    ______EntryInformation_information__item__attribute_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _______EntryInformation_information__item__attribute_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ______EntryInformation_information__item__attribute_valuesWithContext__item__contextList._cont = _______EntryInformation_information__item__attribute_valuesWithContext__item__contextList__item_
    ______EntryInformation_information__item__attribute_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _____EntryInformation_information__item__attribute_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ______EntryInformation_information__item__attribute_valuesWithContext__item__value),
        (u'contextList', ______EntryInformation_information__item__attribute_valuesWithContext__item__contextList),
        ])
    _____EntryInformation_information__item__attribute_valuesWithContext__item_._ext = []
    ____EntryInformation_information__item__attribute_valuesWithContext._cont = _____EntryInformation_information__item__attribute_valuesWithContext__item_
    ____EntryInformation_information__item__attribute_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___EntryInformation_information__item__attribute._cont = ASN1Dict([
        (u'type', ____EntryInformation_information__item__attribute_type),
        (u'values', ____EntryInformation_information__item__attribute_values),
        (u'valuesWithContext', ____EntryInformation_information__item__attribute_valuesWithContext),
        ])
    ___EntryInformation_information__item__attribute._ext = []
    __EntryInformation_information__item_._cont = ASN1Dict([
        (u'attributeType', ___EntryInformation_information__item__attributeType),
        (u'attribute', ___EntryInformation_information__item__attribute),
        ])
    __EntryInformation_information__item_._ext = []
    _EntryInformation_information._cont = __EntryInformation_information__item_
    _EntryInformation_information._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _EntryInformation_incompleteEntry = BOOL(name=u'incompleteEntry', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _EntryInformation_partialName = BOOL(name=u'partialName', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _EntryInformation_derivedEntry = BOOL(name=u'derivedEntry', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    EntryInformation._cont = ASN1Dict([
        (u'name', _EntryInformation_name),
        (u'fromEntry', _EntryInformation_fromEntry),
        (u'information', _EntryInformation_information),
        (u'incompleteEntry', _EntryInformation_incompleteEntry),
        (u'partialName', _EntryInformation_partialName),
        (u'derivedEntry', _EntryInformation_derivedEntry),
        ])
    EntryInformation._ext = []
    
    #-----< family-information >-----#
    family_information = CLASS(name=u'family-information', mode=MODE_VALUE, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _family_information_val_Type = SEQ(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyEntries')))
    family_information._val = dict([(u'Type', _family_information_val_Type), (u'usage', u'directoryOperation'), (u'id', (2, 5, 4, 64))])
    
    #-----< FamilyEntries >-----#
    FamilyEntries = SEQ(name=u'FamilyEntries', mode=MODE_TYPE)
    _FamilyEntries_family_class = OID(name=u'family-class', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'OBJECT-CLASS'), [u'id']))
    _FamilyEntries_familyEntries = SEQ_OF(name=u'familyEntries', mode=MODE_TYPE)
    __FamilyEntries_familyEntries__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyEntry')))
    _FamilyEntries_familyEntries._cont = __FamilyEntries_familyEntries__item_
    FamilyEntries._cont = ASN1Dict([
        (u'family-class', _FamilyEntries_family_class),
        (u'familyEntries', _FamilyEntries_familyEntries),
        ])
    FamilyEntries._ext = []
    
    #-----< FamilyEntry >-----#
    FamilyEntry = SEQ(name=u'FamilyEntry', mode=MODE_TYPE)
    _FamilyEntry_rdn = SET_OF(name=u'rdn', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'RelativeDistinguishedName')))
    _FamilyEntry_information = SEQ_OF(name=u'information', mode=MODE_TYPE)
    __FamilyEntry_information__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ___FamilyEntry_information__item__attributeType = OID(name=u'attributeType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ___FamilyEntry_information__item__attribute = SEQ(name=u'attribute', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ____FamilyEntry_information__item__attribute_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _____FamilyEntry_information__item__attribute_type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ______FamilyEntry_information__item__attribute_type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______FamilyEntry_information__item__attribute_type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _____FamilyEntry_information__item__attribute_type_tab._val = ASN1Set(rv=[dict([(u'Type', ______FamilyEntry_information__item__attribute_type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ______FamilyEntry_information__item__attribute_type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ____FamilyEntry_information__item__attribute_type._const_tab = _____FamilyEntry_information__item__attribute_type_tab
    ____FamilyEntry_information__item__attribute_type._const_tab_at = None
    ____FamilyEntry_information__item__attribute_type._const_tab_id = u'id'
    ____FamilyEntry_information__item__attribute_values = SET_OF(name=u'values', mode=MODE_TYPE)
    _____FamilyEntry_information__item__attribute_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____FamilyEntry_information__item__attribute_values__item_._const_tab = _____FamilyEntry_information__item__attribute_type_tab
    _____FamilyEntry_information__item__attribute_values__item_._const_tab_at = ('..', '..', u'type')
    _____FamilyEntry_information__item__attribute_values__item_._const_tab_id = u'Type'
    ____FamilyEntry_information__item__attribute_values._cont = _____FamilyEntry_information__item__attribute_values__item_
    ____FamilyEntry_information__item__attribute_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ____FamilyEntry_information__item__attribute_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    _____FamilyEntry_information__item__attribute_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__value._const_tab = _____FamilyEntry_information__item__attribute_type_tab
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__value._const_tab_id = u'Type'
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList._cont = _______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList__item_
    ______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _____FamilyEntry_information__item__attribute_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ______FamilyEntry_information__item__attribute_valuesWithContext__item__value),
        (u'contextList', ______FamilyEntry_information__item__attribute_valuesWithContext__item__contextList),
        ])
    _____FamilyEntry_information__item__attribute_valuesWithContext__item_._ext = []
    ____FamilyEntry_information__item__attribute_valuesWithContext._cont = _____FamilyEntry_information__item__attribute_valuesWithContext__item_
    ____FamilyEntry_information__item__attribute_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___FamilyEntry_information__item__attribute._cont = ASN1Dict([
        (u'type', ____FamilyEntry_information__item__attribute_type),
        (u'values', ____FamilyEntry_information__item__attribute_values),
        (u'valuesWithContext', ____FamilyEntry_information__item__attribute_valuesWithContext),
        ])
    ___FamilyEntry_information__item__attribute._ext = []
    __FamilyEntry_information__item_._cont = ASN1Dict([
        (u'attributeType', ___FamilyEntry_information__item__attributeType),
        (u'attribute', ___FamilyEntry_information__item__attribute),
        ])
    __FamilyEntry_information__item_._ext = []
    _FamilyEntry_information._cont = __FamilyEntry_information__item_
    _FamilyEntry_family_info = SEQ_OF(name=u'family-info', mode=MODE_TYPE, opt=True)
    __FamilyEntry_family_info__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyEntries')))
    _FamilyEntry_family_info._cont = __FamilyEntry_family_info__item_
    _FamilyEntry_family_info._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    FamilyEntry._cont = ASN1Dict([
        (u'rdn', _FamilyEntry_rdn),
        (u'information', _FamilyEntry_information),
        (u'family-info', _FamilyEntry_family_info),
        ])
    FamilyEntry._ext = []
    
    #-----< Filter >-----#
    Filter = CHOICE(name=u'Filter', mode=MODE_TYPE)
    _Filter_item = CHOICE(name=u'item', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FilterItem')))
    _Filter_and_ = SET_OF(name=u'and', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __Filter_and___item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')))
    _Filter_and_._cont = __Filter_and___item_
    _Filter_or_ = SET_OF(name=u'or', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __Filter_or___item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')))
    _Filter_or_._cont = __Filter_or___item_
    _Filter_not_ = CHOICE(name=u'not', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')))
    Filter._cont = ASN1Dict([
        (u'item', _Filter_item),
        (u'and', _Filter_and_),
        (u'or', _Filter_or_),
        (u'not', _Filter_not_),
        ])
    Filter._ext = []
    
    #-----< FilterItem >-----#
    FilterItem = CHOICE(name=u'FilterItem', mode=MODE_TYPE)
    _FilterItem_equality = SEQ(name=u'equality', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    _FilterItem_substrings = SEQ(name=u'substrings', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __FilterItem_substrings_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ___FilterItem_substrings_type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ____FilterItem_substrings_type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ____FilterItem_substrings_type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ___FilterItem_substrings_type_tab._val = ASN1Set(rv=[dict([(u'Type', ____FilterItem_substrings_type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ____FilterItem_substrings_type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    __FilterItem_substrings_type._const_tab = ___FilterItem_substrings_type_tab
    __FilterItem_substrings_type._const_tab_at = None
    __FilterItem_substrings_type._const_tab_id = u'id'
    __FilterItem_substrings_strings = SEQ_OF(name=u'strings', mode=MODE_TYPE)
    ___FilterItem_substrings_strings__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ____FilterItem_substrings_strings__item__initial = OPEN(name=u'initial', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____FilterItem_substrings_strings__item__initial._const_tab = ___FilterItem_substrings_type_tab
    ____FilterItem_substrings_strings__item__initial._const_tab_at = ('..', '..', '..', '..', u'substrings', u'type')
    ____FilterItem_substrings_strings__item__initial._const_tab_id = u'Type'
    ____FilterItem_substrings_strings__item__any = OPEN(name=u'any', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____FilterItem_substrings_strings__item__any._const_tab = ___FilterItem_substrings_type_tab
    ____FilterItem_substrings_strings__item__any._const_tab_at = ('..', '..', '..', '..', u'substrings', u'type')
    ____FilterItem_substrings_strings__item__any._const_tab_id = u'Type'
    ____FilterItem_substrings_strings__item__final = OPEN(name=u'final', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____FilterItem_substrings_strings__item__final._const_tab = ___FilterItem_substrings_type_tab
    ____FilterItem_substrings_strings__item__final._const_tab_at = ('..', '..', '..', '..', u'substrings', u'type')
    ____FilterItem_substrings_strings__item__final._const_tab_id = u'Type'
    ____FilterItem_substrings_strings__item__control = SEQ(name=u'control', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    _____FilterItem_substrings_strings__item__control_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _____FilterItem_substrings_strings__item__control_type._const_tab = ___FilterItem_substrings_type_tab
    _____FilterItem_substrings_strings__item__control_type._const_tab_at = None
    _____FilterItem_substrings_strings__item__control_type._const_tab_id = u'id'
    _____FilterItem_substrings_strings__item__control_values = SET_OF(name=u'values', mode=MODE_TYPE)
    ______FilterItem_substrings_strings__item__control_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______FilterItem_substrings_strings__item__control_values__item_._const_tab = ___FilterItem_substrings_type_tab
    ______FilterItem_substrings_strings__item__control_values__item_._const_tab_at = ('..', '..', u'type')
    ______FilterItem_substrings_strings__item__control_values__item_._const_tab_id = u'Type'
    _____FilterItem_substrings_strings__item__control_values._cont = ______FilterItem_substrings_strings__item__control_values__item_
    _____FilterItem_substrings_strings__item__control_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _____FilterItem_substrings_strings__item__control_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ______FilterItem_substrings_strings__item__control_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__value._const_tab = ___FilterItem_substrings_type_tab
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__value._const_tab_id = u'Type'
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ________FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList._cont = ________FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList__item_
    _______FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ______FilterItem_substrings_strings__item__control_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _______FilterItem_substrings_strings__item__control_valuesWithContext__item__value),
        (u'contextList', _______FilterItem_substrings_strings__item__control_valuesWithContext__item__contextList),
        ])
    ______FilterItem_substrings_strings__item__control_valuesWithContext__item_._ext = []
    _____FilterItem_substrings_strings__item__control_valuesWithContext._cont = ______FilterItem_substrings_strings__item__control_valuesWithContext__item_
    _____FilterItem_substrings_strings__item__control_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____FilterItem_substrings_strings__item__control._cont = ASN1Dict([
        (u'type', _____FilterItem_substrings_strings__item__control_type),
        (u'values', _____FilterItem_substrings_strings__item__control_values),
        (u'valuesWithContext', _____FilterItem_substrings_strings__item__control_valuesWithContext),
        ])
    ____FilterItem_substrings_strings__item__control._ext = []
    ___FilterItem_substrings_strings__item_._cont = ASN1Dict([
        (u'initial', ____FilterItem_substrings_strings__item__initial),
        (u'any', ____FilterItem_substrings_strings__item__any),
        (u'final', ____FilterItem_substrings_strings__item__final),
        (u'control', ____FilterItem_substrings_strings__item__control),
        ])
    ___FilterItem_substrings_strings__item_._ext = []
    __FilterItem_substrings_strings._cont = ___FilterItem_substrings_strings__item_
    _FilterItem_substrings._cont = ASN1Dict([
        (u'type', __FilterItem_substrings_type),
        (u'strings', __FilterItem_substrings_strings),
        ])
    _FilterItem_substrings._ext = []
    _FilterItem_greaterOrEqual = SEQ(name=u'greaterOrEqual', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    _FilterItem_lessOrEqual = SEQ(name=u'lessOrEqual', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    _FilterItem_present = OID(name=u'present', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _FilterItem_approximateMatch = SEQ(name=u'approximateMatch', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    _FilterItem_extensibleMatch = SEQ(name=u'extensibleMatch', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'MatchingRuleAssertion')))
    _FilterItem_contextPresent = SEQ(name=u'contextPresent', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeTypeAssertion')))
    FilterItem._cont = ASN1Dict([
        (u'equality', _FilterItem_equality),
        (u'substrings', _FilterItem_substrings),
        (u'greaterOrEqual', _FilterItem_greaterOrEqual),
        (u'lessOrEqual', _FilterItem_lessOrEqual),
        (u'present', _FilterItem_present),
        (u'approximateMatch', _FilterItem_approximateMatch),
        (u'extensibleMatch', _FilterItem_extensibleMatch),
        (u'contextPresent', _FilterItem_contextPresent),
        ])
    FilterItem._ext = []
    
    #-----< MatchingRuleAssertion >-----#
    MatchingRuleAssertion = SEQ(name=u'MatchingRuleAssertion', mode=MODE_TYPE)
    _MatchingRuleAssertion_matchingRule = SET_OF(name=u'matchingRule', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __MatchingRuleAssertion_matchingRule__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'MATCHING-RULE'), [u'id']))
    _MatchingRuleAssertion_matchingRule._cont = __MatchingRuleAssertion_matchingRule__item_
    _MatchingRuleAssertion_matchingRule._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _MatchingRuleAssertion_type = OID(name=u'type', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')), opt=True)
    _MatchingRuleAssertion_matchValue = OPEN(name=u'matchValue', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefClassField(('InformationFramework', 'MATCHING-RULE'), [u'AssertionType']))
    _MatchingRuleAssertion_dnAttributes = BOOL(name=u'dnAttributes', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    MatchingRuleAssertion._cont = ASN1Dict([
        (u'matchingRule', _MatchingRuleAssertion_matchingRule),
        (u'type', _MatchingRuleAssertion_type),
        (u'matchValue', _MatchingRuleAssertion_matchValue),
        (u'dnAttributes', _MatchingRuleAssertion_dnAttributes),
        ])
    MatchingRuleAssertion._ext = []
    
    #-----< PagedResultsRequest >-----#
    PagedResultsRequest = CHOICE(name=u'PagedResultsRequest', mode=MODE_TYPE)
    _PagedResultsRequest_newRequest = SEQ(name=u'newRequest', mode=MODE_TYPE)
    __PagedResultsRequest_newRequest_pageSize = INT(name=u'pageSize', mode=MODE_TYPE)
    __PagedResultsRequest_newRequest_sortKeys = SEQ_OF(name=u'sortKeys', mode=MODE_TYPE, opt=True)
    ___PagedResultsRequest_newRequest_sortKeys__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SortKey')))
    __PagedResultsRequest_newRequest_sortKeys._cont = ___PagedResultsRequest_newRequest_sortKeys__item_
    __PagedResultsRequest_newRequest_sortKeys._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __PagedResultsRequest_newRequest_reverse = BOOL(name=u'reverse', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    __PagedResultsRequest_newRequest_unmerged = BOOL(name=u'unmerged', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    __PagedResultsRequest_newRequest_pageNumber = INT(name=u'pageNumber', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PagedResultsRequest_newRequest._cont = ASN1Dict([
        (u'pageSize', __PagedResultsRequest_newRequest_pageSize),
        (u'sortKeys', __PagedResultsRequest_newRequest_sortKeys),
        (u'reverse', __PagedResultsRequest_newRequest_reverse),
        (u'unmerged', __PagedResultsRequest_newRequest_unmerged),
        (u'pageNumber', __PagedResultsRequest_newRequest_pageNumber),
        ])
    _PagedResultsRequest_newRequest._ext = []
    _PagedResultsRequest_queryReference = OCT_STR(name=u'queryReference', mode=MODE_TYPE)
    _PagedResultsRequest_abandonQuery = OCT_STR(name=u'abandonQuery', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    PagedResultsRequest._cont = ASN1Dict([
        (u'newRequest', _PagedResultsRequest_newRequest),
        (u'queryReference', _PagedResultsRequest_queryReference),
        (u'abandonQuery', _PagedResultsRequest_abandonQuery),
        ])
    PagedResultsRequest._ext = []
    
    #-----< SortKey >-----#
    SortKey = SEQ(name=u'SortKey', mode=MODE_TYPE)
    _SortKey_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _SortKey_orderingRule = OID(name=u'orderingRule', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'MATCHING-RULE'), [u'id']), opt=True)
    SortKey._cont = ASN1Dict([
        (u'type', _SortKey_type),
        (u'orderingRule', _SortKey_orderingRule),
        ])
    SortKey._ext = []
    
    #-----< SecurityParameters >-----#
    SecurityParameters = SET(name=u'SecurityParameters', mode=MODE_TYPE)
    _SecurityParameters_certification_path = SEQ(name=u'certification-path', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificationPath')), opt=True)
    _SecurityParameters_name = SEQ_OF(name=u'name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _SecurityParameters_time = CHOICE(name=u'time', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Time')), opt=True)
    _SecurityParameters_random = BIT_STR(name=u'random', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _SecurityParameters_target = INT(name=u'target', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ProtectionRequest')), opt=True)
    _SecurityParameters_operationCode = CHOICE(name=u'operationCode', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')), opt=True)
    _SecurityParameters_errorProtection = INT(name=u'errorProtection', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ErrorProtectionRequest')), opt=True)
    _SecurityParameters_errorCode = CHOICE(name=u'errorCode', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CommonProtocolSpecification', 'Code')), opt=True)
    SecurityParameters._cont = ASN1Dict([
        (u'certification-path', _SecurityParameters_certification_path),
        (u'name', _SecurityParameters_name),
        (u'time', _SecurityParameters_time),
        (u'random', _SecurityParameters_random),
        (u'target', _SecurityParameters_target),
        (u'operationCode', _SecurityParameters_operationCode),
        (u'errorProtection', _SecurityParameters_errorProtection),
        (u'errorCode', _SecurityParameters_errorCode),
        ])
    SecurityParameters._ext = []
    
    #-----< ProtectionRequest >-----#
    ProtectionRequest = INT(name=u'ProtectionRequest', mode=MODE_TYPE)
    ProtectionRequest._cont = ASN1Dict([(u'none', 0), (u'signed', 1)])
    
    #-----< Time >-----#
    Time = CHOICE(name=u'Time', mode=MODE_TYPE)
    _Time_utcTime = TIME_UTC(name=u'utcTime', mode=MODE_TYPE)
    _Time_generalizedTime = TIME_GEN(name=u'generalizedTime', mode=MODE_TYPE)
    Time._cont = ASN1Dict([
        (u'utcTime', _Time_utcTime),
        (u'generalizedTime', _Time_generalizedTime),
        ])
    Time._ext = []
    
    #-----< ErrorProtectionRequest >-----#
    ErrorProtectionRequest = INT(name=u'ErrorProtectionRequest', mode=MODE_TYPE)
    ErrorProtectionRequest._cont = ASN1Dict([(u'none', 0), (u'signed', 1)])
    
    #-----< directoryBind >-----#
    directoryBind = CLASS(name=u'directoryBind', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _directoryBind_val_ArgumentType = SET(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'DirectoryBindArgument')))
    _directoryBind_val_ResultType = SET(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'DirectoryBindResult')))
    __OPERATION_Errors_val_ParameterType_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_0_unsigned = SET(name=u'unsigned', mode=MODE_TYPE)
    ____OPERATION_Errors_val_ParameterType_0_unsigned_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    ____OPERATION_Errors_val_ParameterType_0_unsigned_error = CHOICE(name=u'error', mode=MODE_TYPE)
    _____OPERATION_Errors_val_ParameterType_0_unsigned_error_serviceError = INT(name=u'serviceError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceProblem')))
    _____OPERATION_Errors_val_ParameterType_0_unsigned_error_securityError = INT(name=u'securityError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityProblem')))
    ____OPERATION_Errors_val_ParameterType_0_unsigned_error._cont = ASN1Dict([
        (u'serviceError', _____OPERATION_Errors_val_ParameterType_0_unsigned_error_serviceError),
        (u'securityError', _____OPERATION_Errors_val_ParameterType_0_unsigned_error_securityError),
        ])
    ____OPERATION_Errors_val_ParameterType_0_unsigned_error._ext = []
    ____OPERATION_Errors_val_ParameterType_0_unsigned_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    ___OPERATION_Errors_val_ParameterType_0_unsigned._cont = ASN1Dict([
        (u'versions', ____OPERATION_Errors_val_ParameterType_0_unsigned_versions),
        (u'error', ____OPERATION_Errors_val_ParameterType_0_unsigned_error),
        (u'securityParameters', ____OPERATION_Errors_val_ParameterType_0_unsigned_securityParameters),
        ])
    ___OPERATION_Errors_val_ParameterType_0_unsigned._ext = None
    ___OPERATION_Errors_val_ParameterType_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE)
    _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error = CHOICE(name=u'error', mode=MODE_TYPE)
    ______OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error_serviceError = INT(name=u'serviceError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceProblem')))
    ______OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error_securityError = INT(name=u'securityError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityProblem')))
    _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error._cont = ASN1Dict([
        (u'serviceError', ______OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error_serviceError),
        (u'securityError', ______OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error_securityError),
        ])
    _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error._ext = []
    _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned._cont = ASN1Dict([
        (u'versions', _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_versions),
        (u'error', _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_error),
        (u'securityParameters', _____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned_securityParameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned._ext = None
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_0_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_0_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_0_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_0._ext = None
    directoryBind._val = dict([(u'ArgumentType', _directoryBind_val_ArgumentType), (u'ResultType', _directoryBind_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0)])], rr=[], ev=None, er=[]))])
    
    #-----< DirectoryBindArgument >-----#
    DirectoryBindArgument = SET(name=u'DirectoryBindArgument', mode=MODE_TYPE)
    _DirectoryBindArgument_credentials = CHOICE(name=u'credentials', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Credentials')), opt=True)
    _DirectoryBindArgument_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    DirectoryBindArgument._cont = ASN1Dict([
        (u'credentials', _DirectoryBindArgument_credentials),
        (u'versions', _DirectoryBindArgument_versions),
        ])
    DirectoryBindArgument._ext = []
    
    #-----< Credentials >-----#
    Credentials = CHOICE(name=u'Credentials', mode=MODE_TYPE)
    _Credentials_simple = SEQ(name=u'simple', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SimpleCredentials')))
    _Credentials_strong = SET(name=u'strong', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'StrongCredentials')))
    _Credentials_externalProcedure = EXT(name=u'externalProcedure', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('_IMPL_', 'EXTERNAL')))
    _Credentials_spkm = CHOICE(name=u'spkm', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SpkmCredentials')))
    _Credentials_sasl = SEQ(name=u'sasl', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SaslCredentials')))
    Credentials._cont = ASN1Dict([
        (u'simple', _Credentials_simple),
        (u'strong', _Credentials_strong),
        (u'externalProcedure', _Credentials_externalProcedure),
        (u'spkm', _Credentials_spkm),
        (u'sasl', _Credentials_sasl),
        ])
    Credentials._ext = []
    
    #-----< SimpleCredentials >-----#
    SimpleCredentials = SEQ(name=u'SimpleCredentials', mode=MODE_TYPE)
    _SimpleCredentials_name = SEQ_OF(name=u'name', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _SimpleCredentials_validity = SET(name=u'validity', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __SimpleCredentials_validity_time1 = CHOICE(name=u'time1', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ___SimpleCredentials_validity_time1_utc = TIME_UTC(name=u'utc', mode=MODE_TYPE)
    ___SimpleCredentials_validity_time1_gt = TIME_GEN(name=u'gt', mode=MODE_TYPE)
    __SimpleCredentials_validity_time1._cont = ASN1Dict([
        (u'utc', ___SimpleCredentials_validity_time1_utc),
        (u'gt', ___SimpleCredentials_validity_time1_gt),
        ])
    __SimpleCredentials_validity_time1._ext = None
    __SimpleCredentials_validity_time2 = CHOICE(name=u'time2', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ___SimpleCredentials_validity_time2_utc = TIME_UTC(name=u'utc', mode=MODE_TYPE)
    ___SimpleCredentials_validity_time2_gt = TIME_GEN(name=u'gt', mode=MODE_TYPE)
    __SimpleCredentials_validity_time2._cont = ASN1Dict([
        (u'utc', ___SimpleCredentials_validity_time2_utc),
        (u'gt', ___SimpleCredentials_validity_time2_gt),
        ])
    __SimpleCredentials_validity_time2._ext = None
    __SimpleCredentials_validity_random1 = BIT_STR(name=u'random1', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __SimpleCredentials_validity_random2 = BIT_STR(name=u'random2', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _SimpleCredentials_validity._cont = ASN1Dict([
        (u'time1', __SimpleCredentials_validity_time1),
        (u'time2', __SimpleCredentials_validity_time2),
        (u'random1', __SimpleCredentials_validity_random1),
        (u'random2', __SimpleCredentials_validity_random2),
        ])
    _SimpleCredentials_validity._ext = None
    _SimpleCredentials_password = CHOICE(name=u'password', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __SimpleCredentials_password_unprotected = OCT_STR(name=u'unprotected', mode=MODE_TYPE)
    __SimpleCredentials_password_protected = SEQ(name=u'protected', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'HASH')))
    ___SimpleCredentials_password_protected_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____SimpleCredentials_password_protected_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____SimpleCredentials_password_protected_algorithmIdentifier_algorithm._const_tab = _____SimpleCredentials_password_protected_algorithmIdentifier_algorithm_tab
    ____SimpleCredentials_password_protected_algorithmIdentifier_algorithm._const_tab_at = None
    ____SimpleCredentials_password_protected_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____SimpleCredentials_password_protected_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____SimpleCredentials_password_protected_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____SimpleCredentials_password_protected_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____SimpleCredentials_password_protected_algorithmIdentifier_parameters._const_tab = _____SimpleCredentials_password_protected_algorithmIdentifier_parameters_tab
    ____SimpleCredentials_password_protected_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____SimpleCredentials_password_protected_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___SimpleCredentials_password_protected_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____SimpleCredentials_password_protected_algorithmIdentifier_algorithm),
        (u'parameters', ____SimpleCredentials_password_protected_algorithmIdentifier_parameters),
        ])
    ___SimpleCredentials_password_protected_algorithmIdentifier._ext = []
    ___SimpleCredentials_password_protected_hashValue = BIT_STR(name=u'hashValue', mode=MODE_TYPE)
    __SimpleCredentials_password_protected._cont = ASN1Dict([
        (u'algorithmIdentifier', ___SimpleCredentials_password_protected_algorithmIdentifier),
        (u'hashValue', ___SimpleCredentials_password_protected_hashValue),
        ])
    __SimpleCredentials_password_protected._ext = []
    __SimpleCredentials_password_userPwd = CHOICE(name=u'userPwd', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    _SimpleCredentials_password._cont = ASN1Dict([
        (u'unprotected', __SimpleCredentials_password_unprotected),
        (u'protected', __SimpleCredentials_password_protected),
        (u'userPwd', __SimpleCredentials_password_userPwd),
        ])
    _SimpleCredentials_password._ext = [u'userPwd']
    SimpleCredentials._cont = ASN1Dict([
        (u'name', _SimpleCredentials_name),
        (u'validity', _SimpleCredentials_validity),
        (u'password', _SimpleCredentials_password),
        ])
    SimpleCredentials._ext = None
    
    #-----< StrongCredentials >-----#
    StrongCredentials = SET(name=u'StrongCredentials', mode=MODE_TYPE)
    _StrongCredentials_certification_path = SEQ(name=u'certification-path', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'CertificationPath')), opt=True)
    _StrongCredentials_bind_token = SEQ(name=u'bind-token', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Token')))
    _StrongCredentials_name = SEQ_OF(name=u'name', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _StrongCredentials_attributeCertificationPath = SEQ(name=u'attributeCertificationPath', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AttributeCertificateDefinitions', 'AttributeCertificationPath')), opt=True)
    StrongCredentials._cont = ASN1Dict([
        (u'certification-path', _StrongCredentials_certification_path),
        (u'bind-token', _StrongCredentials_bind_token),
        (u'name', _StrongCredentials_name),
        (u'attributeCertificationPath', _StrongCredentials_attributeCertificationPath),
        ])
    StrongCredentials._ext = []
    
    #-----< SpkmCredentials >-----#
    SpkmCredentials = CHOICE(name=u'SpkmCredentials', mode=MODE_TYPE)
    _SpkmCredentials_req = SEQ(name=u'req', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('SpkmGssTokens', 'SPKM-REQ')))
    _SpkmCredentials_rep = SEQ(name=u'rep', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('SpkmGssTokens', 'SPKM-REP-TI')))
    SpkmCredentials._cont = ASN1Dict([
        (u'req', _SpkmCredentials_req),
        (u'rep', _SpkmCredentials_rep),
        ])
    SpkmCredentials._ext = []
    
    #-----< SaslCredentials >-----#
    SaslCredentials = SEQ(name=u'SaslCredentials', mode=MODE_TYPE)
    _SaslCredentials_mechanism = CHOICE(name=u'mechanism', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('SelectedAttributeTypes', 'DirectoryString')))
    __SaslCredentials_mechanism_teletexString = STR_TELE(name=u'teletexString', mode=MODE_TYPE)
    __SaslCredentials_mechanism_teletexString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=[], er=[])
    __SaslCredentials_mechanism_printableString = STR_PRINT(name=u'printableString', mode=MODE_TYPE)
    __SaslCredentials_mechanism_printableString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=[], er=[])
    __SaslCredentials_mechanism_bmpString = STR_BMP(name=u'bmpString', mode=MODE_TYPE)
    __SaslCredentials_mechanism_bmpString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=[], er=[])
    __SaslCredentials_mechanism_universalString = STR_UNIV(name=u'universalString', mode=MODE_TYPE)
    __SaslCredentials_mechanism_universalString._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=[], er=[])
    __SaslCredentials_mechanism_uTF8String = STR_UTF8(name=u'uTF8String', mode=MODE_TYPE)
    __SaslCredentials_mechanism_uTF8String._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=20)], ev=[], er=[])
    _SaslCredentials_mechanism._cont = ASN1Dict([
        (u'teletexString', __SaslCredentials_mechanism_teletexString),
        (u'printableString', __SaslCredentials_mechanism_printableString),
        (u'bmpString', __SaslCredentials_mechanism_bmpString),
        (u'universalString', __SaslCredentials_mechanism_universalString),
        (u'uTF8String', __SaslCredentials_mechanism_uTF8String),
        ])
    _SaslCredentials_mechanism._ext = None
    _SaslCredentials_credentials = OCT_STR(name=u'credentials', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _SaslCredentials_saslAbort = BOOL(name=u'saslAbort', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    SaslCredentials._cont = ASN1Dict([
        (u'mechanism', _SaslCredentials_mechanism),
        (u'credentials', _SaslCredentials_credentials),
        (u'saslAbort', _SaslCredentials_saslAbort),
        ])
    SaslCredentials._ext = []
    
    #-----< ub-saslMechanism >-----#
    ub_saslMechanism = INT(name=u'ub-saslMechanism', mode=MODE_VALUE)
    ub_saslMechanism._val = 20
    
    #-----< Token >-----#
    Token = SEQ(name=u'Token', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    _Token_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'TokenContent')))
    _Token_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __Token_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___Token_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___Token_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __Token_algorithmIdentifier_algorithm._const_tab = ___Token_algorithmIdentifier_algorithm_tab
    __Token_algorithmIdentifier_algorithm._const_tab_at = None
    __Token_algorithmIdentifier_algorithm._const_tab_id = u'id'
    __Token_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___Token_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___Token_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __Token_algorithmIdentifier_parameters._const_tab = ___Token_algorithmIdentifier_parameters_tab
    __Token_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    __Token_algorithmIdentifier_parameters._const_tab_id = u'Type'
    _Token_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', __Token_algorithmIdentifier_algorithm),
        (u'parameters', __Token_algorithmIdentifier_parameters),
        ])
    _Token_algorithmIdentifier._ext = []
    _Token_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    Token._cont = ASN1Dict([
        (u'toBeSigned', _Token_toBeSigned),
        (u'algorithmIdentifier', _Token_algorithmIdentifier),
        (u'encrypted', _Token_encrypted),
        ])
    Token._ext = []
    
    #-----< TokenContent >-----#
    TokenContent = SEQ(name=u'TokenContent', mode=MODE_TYPE)
    _TokenContent_algorithm = SEQ(name=u'algorithm', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    __TokenContent_algorithm_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ___TokenContent_algorithm_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___TokenContent_algorithm_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __TokenContent_algorithm_algorithm._const_tab = ___TokenContent_algorithm_algorithm_tab
    __TokenContent_algorithm_algorithm._const_tab_at = None
    __TokenContent_algorithm_algorithm._const_tab_id = u'id'
    __TokenContent_algorithm_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ___TokenContent_algorithm_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ___TokenContent_algorithm_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    __TokenContent_algorithm_parameters._const_tab = ___TokenContent_algorithm_parameters_tab
    __TokenContent_algorithm_parameters._const_tab_at = ('..', u'algorithm')
    __TokenContent_algorithm_parameters._const_tab_id = u'Type'
    _TokenContent_algorithm._cont = ASN1Dict([
        (u'algorithm', __TokenContent_algorithm_algorithm),
        (u'parameters', __TokenContent_algorithm_parameters),
        ])
    _TokenContent_algorithm._ext = []
    _TokenContent_name = SEQ_OF(name=u'name', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _TokenContent_time = CHOICE(name=u'time', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Time')))
    _TokenContent_random = BIT_STR(name=u'random', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _TokenContent_response = BIT_STR(name=u'response', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    TokenContent._cont = ASN1Dict([
        (u'algorithm', _TokenContent_algorithm),
        (u'name', _TokenContent_name),
        (u'time', _TokenContent_time),
        (u'random', _TokenContent_random),
        (u'response', _TokenContent_response),
        ])
    TokenContent._ext = []
    
    #-----< Versions >-----#
    Versions = BIT_STR(name=u'Versions', mode=MODE_TYPE)
    Versions._cont = ASN1Dict([(u'v1', 0), (u'v2', 1)])
    
    #-----< DirectoryBindResult >-----#
    DirectoryBindResult = SET(name=u'DirectoryBindResult', mode=MODE_TYPE)
    _DirectoryBindResult_credentials = CHOICE(name=u'credentials', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Credentials')), opt=True)
    _DirectoryBindResult_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    _DirectoryBindResult_pwdResponseValue = SEQ(name=u'pwdResponseValue', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'PwdResponseValue')), opt=True)
    DirectoryBindResult._cont = ASN1Dict([
        (u'credentials', _DirectoryBindResult_credentials),
        (u'versions', _DirectoryBindResult_versions),
        (u'pwdResponseValue', _DirectoryBindResult_pwdResponseValue),
        ])
    DirectoryBindResult._ext = [u'pwdResponseValue']
    
    #-----< PwdResponseValue >-----#
    PwdResponseValue = SEQ(name=u'PwdResponseValue', mode=MODE_TYPE)
    _PwdResponseValue_warning = CHOICE(name=u'warning', mode=MODE_TYPE, opt=True)
    __PwdResponseValue_warning_timeLeft = INT(name=u'timeLeft', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __PwdResponseValue_warning_timeLeft._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    __PwdResponseValue_warning_graceRemaining = INT(name=u'graceRemaining', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __PwdResponseValue_warning_graceRemaining._const_val = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    _PwdResponseValue_warning._cont = ASN1Dict([
        (u'timeLeft', __PwdResponseValue_warning_timeLeft),
        (u'graceRemaining', __PwdResponseValue_warning_graceRemaining),
        ])
    _PwdResponseValue_warning._ext = []
    _PwdResponseValue_error = ENUM(name=u'error', mode=MODE_TYPE, opt=True)
    _PwdResponseValue_error._cont = ASN1Dict([(u'passwordExpired', 0), (u'changeAfterReset', 1)])
    _PwdResponseValue_error._ext = []
    PwdResponseValue._cont = ASN1Dict([
        (u'warning', _PwdResponseValue_warning),
        (u'error', _PwdResponseValue_error),
        ])
    PwdResponseValue._ext = None
    
    #-----< directoryBindError >-----#
    directoryBindError = CLASS(name=u'directoryBindError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')))
    _directoryBindError_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    __directoryBindError_val_ParameterType_unsigned = SET(name=u'unsigned', mode=MODE_TYPE)
    ___directoryBindError_val_ParameterType_unsigned_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    ___directoryBindError_val_ParameterType_unsigned_error = CHOICE(name=u'error', mode=MODE_TYPE)
    ____directoryBindError_val_ParameterType_unsigned_error_serviceError = INT(name=u'serviceError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceProblem')))
    ____directoryBindError_val_ParameterType_unsigned_error_securityError = INT(name=u'securityError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityProblem')))
    ___directoryBindError_val_ParameterType_unsigned_error._cont = ASN1Dict([
        (u'serviceError', ____directoryBindError_val_ParameterType_unsigned_error_serviceError),
        (u'securityError', ____directoryBindError_val_ParameterType_unsigned_error_securityError),
        ])
    ___directoryBindError_val_ParameterType_unsigned_error._ext = []
    ___directoryBindError_val_ParameterType_unsigned_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    __directoryBindError_val_ParameterType_unsigned._cont = ASN1Dict([
        (u'versions', ___directoryBindError_val_ParameterType_unsigned_versions),
        (u'error', ___directoryBindError_val_ParameterType_unsigned_error),
        (u'securityParameters', ___directoryBindError_val_ParameterType_unsigned_securityParameters),
        ])
    __directoryBindError_val_ParameterType_unsigned._ext = None
    __directoryBindError_val_ParameterType_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___directoryBindError_val_ParameterType_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE)
    ____directoryBindError_val_ParameterType_signed_toBeSigned_versions = BIT_STR(name=u'versions', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Versions')), default=(1, 1))
    ____directoryBindError_val_ParameterType_signed_toBeSigned_error = CHOICE(name=u'error', mode=MODE_TYPE)
    _____directoryBindError_val_ParameterType_signed_toBeSigned_error_serviceError = INT(name=u'serviceError', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceProblem')))
    _____directoryBindError_val_ParameterType_signed_toBeSigned_error_securityError = INT(name=u'securityError', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityProblem')))
    ____directoryBindError_val_ParameterType_signed_toBeSigned_error._cont = ASN1Dict([
        (u'serviceError', _____directoryBindError_val_ParameterType_signed_toBeSigned_error_serviceError),
        (u'securityError', _____directoryBindError_val_ParameterType_signed_toBeSigned_error_securityError),
        ])
    ____directoryBindError_val_ParameterType_signed_toBeSigned_error._ext = []
    ____directoryBindError_val_ParameterType_signed_toBeSigned_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    ___directoryBindError_val_ParameterType_signed_toBeSigned._cont = ASN1Dict([
        (u'versions', ____directoryBindError_val_ParameterType_signed_toBeSigned_versions),
        (u'error', ____directoryBindError_val_ParameterType_signed_toBeSigned_error),
        (u'securityParameters', ____directoryBindError_val_ParameterType_signed_toBeSigned_securityParameters),
        ])
    ___directoryBindError_val_ParameterType_signed_toBeSigned._ext = None
    ___directoryBindError_val_ParameterType_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab = _____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab = _____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters_tab
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___directoryBindError_val_ParameterType_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____directoryBindError_val_ParameterType_signed_algorithmIdentifier_parameters),
        ])
    ___directoryBindError_val_ParameterType_signed_algorithmIdentifier._ext = []
    ___directoryBindError_val_ParameterType_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __directoryBindError_val_ParameterType_signed._cont = ASN1Dict([
        (u'toBeSigned', ___directoryBindError_val_ParameterType_signed_toBeSigned),
        (u'algorithmIdentifier', ___directoryBindError_val_ParameterType_signed_algorithmIdentifier),
        (u'encrypted', ___directoryBindError_val_ParameterType_signed_encrypted),
        ])
    __directoryBindError_val_ParameterType_signed._ext = []
    _directoryBindError_val_ParameterType._cont = ASN1Dict([
        (u'unsigned', __directoryBindError_val_ParameterType_unsigned),
        (u'signed', __directoryBindError_val_ParameterType_signed),
        ])
    _directoryBindError_val_ParameterType._ext = None
    directoryBindError._val = dict([(u'ParameterType', _directoryBindError_val_ParameterType)])
    
    #-----< BindKeyInfo >-----#
    BindKeyInfo = BIT_STR(name=u'BindKeyInfo', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED')))
    
    #-----< read >-----#
    read = CLASS(name=u'read', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _read_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadArgument')))
    _read_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadResult')))
    __OPERATION_Errors_val_ParameterType_0_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_0_0_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AttributeErrorData')))
    ___OPERATION_Errors_val_ParameterType_0_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_0_0_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AttributeErrorData')))
    ____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_0_0_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_0_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_0_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_0_0_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_0_0_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_0_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_0_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_0_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_0_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_0_0._ext = None
    __OPERATION_Errors_val_ParameterType_1 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_1_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'NameErrorData')))
    ___OPERATION_Errors_val_ParameterType_1_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_1_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'NameErrorData')))
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_1_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_1_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_1_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_1_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_1_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_1_signed._ext = []
    __OPERATION_Errors_val_ParameterType_1._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_1_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_1_signed),
        ])
    __OPERATION_Errors_val_ParameterType_1._ext = None
    __OPERATION_Errors_val_ParameterType_2 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_2_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceErrorData')))
    ___OPERATION_Errors_val_ParameterType_2_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_2_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceErrorData')))
    ____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_2_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_2_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_2_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_2_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_2_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_2_signed._ext = []
    __OPERATION_Errors_val_ParameterType_2._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_2_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_2_signed),
        ])
    __OPERATION_Errors_val_ParameterType_2._ext = None
    __OPERATION_Errors_val_ParameterType_3 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_3_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReferralData')))
    ___OPERATION_Errors_val_ParameterType_3_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_3_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReferralData')))
    ____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_3_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_3_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_3_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_3_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_3_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_3_signed._ext = []
    __OPERATION_Errors_val_ParameterType_3._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_3_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_3_signed),
        ])
    __OPERATION_Errors_val_ParameterType_3._ext = None
    __OPERATION_Errors_val_ParameterType_4 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_4_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedData')))
    ___OPERATION_Errors_val_ParameterType_4_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_4_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedData')))
    ____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_4_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_4_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_4_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_4_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_4_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_4_signed._ext = []
    __OPERATION_Errors_val_ParameterType_4._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_4_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_4_signed),
        ])
    __OPERATION_Errors_val_ParameterType_4._ext = None
    __OPERATION_Errors_val_ParameterType_5 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_5_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ___OPERATION_Errors_val_ParameterType_5_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_5_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_5_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_5_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_5_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_5_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_5_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_5_signed._ext = []
    __OPERATION_Errors_val_ParameterType_5._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_5_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_5_signed),
        ])
    __OPERATION_Errors_val_ParameterType_5._ext = None
    read._val = dict([(u'ArgumentType', _read_val_ArgumentType), (u'ResultType', _read_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_0), (u'errorCode', (u'local', 1))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 2))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_2), (u'errorCode', (u'local', 3))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 4))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4), (u'errorCode', (u'local', 5))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_5), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 1))])
    
    #-----< ReadArgument >-----#
    ReadArgument = CHOICE(name=u'ReadArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _ReadArgument_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadArgumentData')))
    _ReadArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __ReadArgument_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadArgumentData')))
    __ReadArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___ReadArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____ReadArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ReadArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ReadArgument_signed_algorithmIdentifier_algorithm._const_tab = ____ReadArgument_signed_algorithmIdentifier_algorithm_tab
    ___ReadArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___ReadArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___ReadArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____ReadArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ReadArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ReadArgument_signed_algorithmIdentifier_parameters._const_tab = ____ReadArgument_signed_algorithmIdentifier_parameters_tab
    ___ReadArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___ReadArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __ReadArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___ReadArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___ReadArgument_signed_algorithmIdentifier_parameters),
        ])
    __ReadArgument_signed_algorithmIdentifier._ext = []
    __ReadArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _ReadArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __ReadArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __ReadArgument_signed_algorithmIdentifier),
        (u'encrypted', __ReadArgument_signed_encrypted),
        ])
    _ReadArgument_signed._ext = []
    ReadArgument._cont = ASN1Dict([
        (u'unsigned', _ReadArgument_unsigned),
        (u'signed', _ReadArgument_signed),
        ])
    ReadArgument._ext = None
    
    #-----< ReadArgumentData >-----#
    ReadArgumentData = SET(name=u'ReadArgumentData', mode=MODE_TYPE)
    _ReadArgumentData_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _ReadArgumentData_selection = SET(name=u'selection', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'EntryInformationSelection')), default=dict([]))
    _ReadArgumentData_modifyRightsRequest = BOOL(name=u'modifyRightsRequest', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ReadArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _ReadArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ReadArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ReadArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _ReadArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ReadArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ReadArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _ReadArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _ReadArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _ReadArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ReadArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _ReadArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    ReadArgumentData._cont = ASN1Dict([
        (u'object', _ReadArgumentData_object),
        (u'selection', _ReadArgumentData_selection),
        (u'modifyRightsRequest', _ReadArgumentData_modifyRightsRequest),
        (u'serviceControls', _ReadArgumentData_serviceControls),
        (u'securityParameters', _ReadArgumentData_securityParameters),
        (u'requestor', _ReadArgumentData_requestor),
        (u'operationProgress', _ReadArgumentData_operationProgress),
        (u'aliasedRDNs', _ReadArgumentData_aliasedRDNs),
        (u'criticalExtensions', _ReadArgumentData_criticalExtensions),
        (u'referenceType', _ReadArgumentData_referenceType),
        (u'entryOnly', _ReadArgumentData_entryOnly),
        (u'exclusions', _ReadArgumentData_exclusions),
        (u'nameResolveOnMaster', _ReadArgumentData_nameResolveOnMaster),
        (u'operationContexts', _ReadArgumentData_operationContexts),
        (u'familyGrouping', _ReadArgumentData_familyGrouping),
        ])
    ReadArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< ReadResult >-----#
    ReadResult = CHOICE(name=u'ReadResult', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _ReadResult_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadResultData')))
    _ReadResult_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __ReadResult_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReadResultData')))
    __ReadResult_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___ReadResult_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____ReadResult_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ReadResult_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ReadResult_signed_algorithmIdentifier_algorithm._const_tab = ____ReadResult_signed_algorithmIdentifier_algorithm_tab
    ___ReadResult_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___ReadResult_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___ReadResult_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____ReadResult_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ReadResult_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ReadResult_signed_algorithmIdentifier_parameters._const_tab = ____ReadResult_signed_algorithmIdentifier_parameters_tab
    ___ReadResult_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___ReadResult_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __ReadResult_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___ReadResult_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___ReadResult_signed_algorithmIdentifier_parameters),
        ])
    __ReadResult_signed_algorithmIdentifier._ext = []
    __ReadResult_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _ReadResult_signed._cont = ASN1Dict([
        (u'toBeSigned', __ReadResult_signed_toBeSigned),
        (u'algorithmIdentifier', __ReadResult_signed_algorithmIdentifier),
        (u'encrypted', __ReadResult_signed_encrypted),
        ])
    _ReadResult_signed._ext = []
    ReadResult._cont = ASN1Dict([
        (u'unsigned', _ReadResult_unsigned),
        (u'signed', _ReadResult_signed),
        ])
    ReadResult._ext = None
    
    #-----< ReadResultData >-----#
    ReadResultData = SET(name=u'ReadResultData', mode=MODE_TYPE)
    _ReadResultData_entry = SEQ(name=u'entry', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'EntryInformation')))
    _ReadResultData_modifyRights = SET_OF(name=u'modifyRights', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyRights')), opt=True)
    _ReadResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ReadResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ReadResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ReadResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ReadResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___ReadResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____ReadResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____ReadResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____ReadResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____ReadResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____ReadResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____ReadResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___ReadResultData_notification__item__type._const_tab = ____ReadResultData_notification__item__type_tab
    ___ReadResultData_notification__item__type._const_tab_at = None
    ___ReadResultData_notification__item__type._const_tab_id = u'id'
    ___ReadResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____ReadResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____ReadResultData_notification__item__values__item_._const_tab = ____ReadResultData_notification__item__type_tab
    ____ReadResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____ReadResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___ReadResultData_notification__item__values._cont = ____ReadResultData_notification__item__values__item_
    ___ReadResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___ReadResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____ReadResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____ReadResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____ReadResultData_notification__item__valuesWithContext__item__value._const_tab = ____ReadResultData_notification__item__type_tab
    _____ReadResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____ReadResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____ReadResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______ReadResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____ReadResultData_notification__item__valuesWithContext__item__contextList._cont = ______ReadResultData_notification__item__valuesWithContext__item__contextList__item_
    _____ReadResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____ReadResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____ReadResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____ReadResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____ReadResultData_notification__item__valuesWithContext__item_._ext = []
    ___ReadResultData_notification__item__valuesWithContext._cont = ____ReadResultData_notification__item__valuesWithContext__item_
    ___ReadResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __ReadResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___ReadResultData_notification__item__type),
        (u'values', ___ReadResultData_notification__item__values),
        (u'valuesWithContext', ___ReadResultData_notification__item__valuesWithContext),
        ])
    __ReadResultData_notification__item_._ext = []
    _ReadResultData_notification._cont = __ReadResultData_notification__item_
    ReadResultData._cont = ASN1Dict([
        (u'entry', _ReadResultData_entry),
        (u'modifyRights', _ReadResultData_modifyRights),
        (u'securityParameters', _ReadResultData_securityParameters),
        (u'performer', _ReadResultData_performer),
        (u'aliasDereferenced', _ReadResultData_aliasDereferenced),
        (u'notification', _ReadResultData_notification),
        ])
    ReadResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< ModifyRights >-----#
    ModifyRights = SET_OF(name=u'ModifyRights', mode=MODE_TYPE)
    _ModifyRights__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    __ModifyRights__item__item = CHOICE(name=u'item', mode=MODE_TYPE)
    ___ModifyRights__item__item_entry = NULL(name=u'entry', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___ModifyRights__item__item_attribute = OID(name=u'attribute', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ___ModifyRights__item__item_value = SEQ(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    __ModifyRights__item__item._cont = ASN1Dict([
        (u'entry', ___ModifyRights__item__item_entry),
        (u'attribute', ___ModifyRights__item__item_attribute),
        (u'value', ___ModifyRights__item__item_value),
        ])
    __ModifyRights__item__item._ext = []
    __ModifyRights__item__permission = BIT_STR(name=u'permission', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ModifyRights__item__permission._cont = ASN1Dict([(u'add', 0), (u'remove', 1), (u'rename', 2), (u'move', 3)])
    _ModifyRights__item_._cont = ASN1Dict([
        (u'item', __ModifyRights__item__item),
        (u'permission', __ModifyRights__item__permission),
        ])
    _ModifyRights__item_._ext = []
    ModifyRights._cont = _ModifyRights__item_
    
    #-----< compare >-----#
    compare = CLASS(name=u'compare', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _compare_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareArgument')))
    _compare_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareResult')))
    compare._val = dict([(u'ArgumentType', _compare_val_ArgumentType), (u'ResultType', _compare_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_0), (u'errorCode', (u'local', 1))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 2))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_2), (u'errorCode', (u'local', 3))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 4))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4), (u'errorCode', (u'local', 5))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_5), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 2))])
    
    #-----< CompareArgument >-----#
    CompareArgument = CHOICE(name=u'CompareArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _CompareArgument_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareArgumentData')))
    _CompareArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __CompareArgument_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareArgumentData')))
    __CompareArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___CompareArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____CompareArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____CompareArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CompareArgument_signed_algorithmIdentifier_algorithm._const_tab = ____CompareArgument_signed_algorithmIdentifier_algorithm_tab
    ___CompareArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___CompareArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___CompareArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____CompareArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____CompareArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CompareArgument_signed_algorithmIdentifier_parameters._const_tab = ____CompareArgument_signed_algorithmIdentifier_parameters_tab
    ___CompareArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___CompareArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __CompareArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___CompareArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___CompareArgument_signed_algorithmIdentifier_parameters),
        ])
    __CompareArgument_signed_algorithmIdentifier._ext = []
    __CompareArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _CompareArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __CompareArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __CompareArgument_signed_algorithmIdentifier),
        (u'encrypted', __CompareArgument_signed_encrypted),
        ])
    _CompareArgument_signed._ext = []
    CompareArgument._cont = ASN1Dict([
        (u'unsigned', _CompareArgument_unsigned),
        (u'signed', _CompareArgument_signed),
        ])
    CompareArgument._ext = None
    
    #-----< CompareArgumentData >-----#
    CompareArgumentData = SET(name=u'CompareArgumentData', mode=MODE_TYPE)
    _CompareArgumentData_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _CompareArgumentData_purported = SEQ(name=u'purported', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValueAssertion')))
    _CompareArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _CompareArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CompareArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CompareArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _CompareArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CompareArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _CompareArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _CompareArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _CompareArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _CompareArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CompareArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _CompareArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    CompareArgumentData._cont = ASN1Dict([
        (u'object', _CompareArgumentData_object),
        (u'purported', _CompareArgumentData_purported),
        (u'serviceControls', _CompareArgumentData_serviceControls),
        (u'securityParameters', _CompareArgumentData_securityParameters),
        (u'requestor', _CompareArgumentData_requestor),
        (u'operationProgress', _CompareArgumentData_operationProgress),
        (u'aliasedRDNs', _CompareArgumentData_aliasedRDNs),
        (u'criticalExtensions', _CompareArgumentData_criticalExtensions),
        (u'referenceType', _CompareArgumentData_referenceType),
        (u'entryOnly', _CompareArgumentData_entryOnly),
        (u'exclusions', _CompareArgumentData_exclusions),
        (u'nameResolveOnMaster', _CompareArgumentData_nameResolveOnMaster),
        (u'operationContexts', _CompareArgumentData_operationContexts),
        (u'familyGrouping', _CompareArgumentData_familyGrouping),
        ])
    CompareArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< CompareResult >-----#
    CompareResult = CHOICE(name=u'CompareResult', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _CompareResult_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareResultData')))
    _CompareResult_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __CompareResult_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'CompareResultData')))
    __CompareResult_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___CompareResult_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____CompareResult_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____CompareResult_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CompareResult_signed_algorithmIdentifier_algorithm._const_tab = ____CompareResult_signed_algorithmIdentifier_algorithm_tab
    ___CompareResult_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___CompareResult_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___CompareResult_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____CompareResult_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____CompareResult_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___CompareResult_signed_algorithmIdentifier_parameters._const_tab = ____CompareResult_signed_algorithmIdentifier_parameters_tab
    ___CompareResult_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___CompareResult_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __CompareResult_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___CompareResult_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___CompareResult_signed_algorithmIdentifier_parameters),
        ])
    __CompareResult_signed_algorithmIdentifier._ext = []
    __CompareResult_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _CompareResult_signed._cont = ASN1Dict([
        (u'toBeSigned', __CompareResult_signed_toBeSigned),
        (u'algorithmIdentifier', __CompareResult_signed_algorithmIdentifier),
        (u'encrypted', __CompareResult_signed_encrypted),
        ])
    _CompareResult_signed._ext = []
    CompareResult._cont = ASN1Dict([
        (u'unsigned', _CompareResult_unsigned),
        (u'signed', _CompareResult_signed),
        ])
    CompareResult._ext = None
    
    #-----< CompareResultData >-----#
    CompareResultData = SET(name=u'CompareResultData', mode=MODE_TYPE)
    _CompareResultData_name = CHOICE(name=u'name', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    _CompareResultData_matched = BOOL(name=u'matched', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _CompareResultData_fromEntry = BOOL(name=u'fromEntry', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _CompareResultData_matchedSubtype = OID(name=u'matchedSubtype', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')), opt=True)
    _CompareResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _CompareResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _CompareResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _CompareResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __CompareResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___CompareResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____CompareResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____CompareResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____CompareResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____CompareResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____CompareResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____CompareResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___CompareResultData_notification__item__type._const_tab = ____CompareResultData_notification__item__type_tab
    ___CompareResultData_notification__item__type._const_tab_at = None
    ___CompareResultData_notification__item__type._const_tab_id = u'id'
    ___CompareResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____CompareResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____CompareResultData_notification__item__values__item_._const_tab = ____CompareResultData_notification__item__type_tab
    ____CompareResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____CompareResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___CompareResultData_notification__item__values._cont = ____CompareResultData_notification__item__values__item_
    ___CompareResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___CompareResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____CompareResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____CompareResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____CompareResultData_notification__item__valuesWithContext__item__value._const_tab = ____CompareResultData_notification__item__type_tab
    _____CompareResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____CompareResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____CompareResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______CompareResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____CompareResultData_notification__item__valuesWithContext__item__contextList._cont = ______CompareResultData_notification__item__valuesWithContext__item__contextList__item_
    _____CompareResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____CompareResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____CompareResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____CompareResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____CompareResultData_notification__item__valuesWithContext__item_._ext = []
    ___CompareResultData_notification__item__valuesWithContext._cont = ____CompareResultData_notification__item__valuesWithContext__item_
    ___CompareResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __CompareResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___CompareResultData_notification__item__type),
        (u'values', ___CompareResultData_notification__item__values),
        (u'valuesWithContext', ___CompareResultData_notification__item__valuesWithContext),
        ])
    __CompareResultData_notification__item_._ext = []
    _CompareResultData_notification._cont = __CompareResultData_notification__item_
    CompareResultData._cont = ASN1Dict([
        (u'name', _CompareResultData_name),
        (u'matched', _CompareResultData_matched),
        (u'fromEntry', _CompareResultData_fromEntry),
        (u'matchedSubtype', _CompareResultData_matchedSubtype),
        (u'securityParameters', _CompareResultData_securityParameters),
        (u'performer', _CompareResultData_performer),
        (u'aliasDereferenced', _CompareResultData_aliasDereferenced),
        (u'notification', _CompareResultData_notification),
        ])
    CompareResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< abandon >-----#
    abandon = CLASS(name=u'abandon', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _abandon_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonArgument')))
    _abandon_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonResult')))
    __OPERATION_Errors_val_ParameterType_0_1 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_0_1_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonFailedData')))
    ___OPERATION_Errors_val_ParameterType_0_1_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_0_1_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonFailedData')))
    ____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_0_1_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_0_1_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_0_1_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_0_1_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_0_1_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_0_1_signed._ext = []
    __OPERATION_Errors_val_ParameterType_0_1._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_0_1_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_0_1_signed),
        ])
    __OPERATION_Errors_val_ParameterType_0_1._ext = None
    abandon._val = dict([(u'ArgumentType', _abandon_val_ArgumentType), (u'ResultType', _abandon_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_1), (u'errorCode', (u'local', 7))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 3))])
    
    #-----< AbandonArgument >-----#
    AbandonArgument = CHOICE(name=u'AbandonArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    _AbandonArgument_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonArgumentData')))
    _AbandonArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __AbandonArgument_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonArgumentData')))
    __AbandonArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___AbandonArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____AbandonArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____AbandonArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AbandonArgument_signed_algorithmIdentifier_algorithm._const_tab = ____AbandonArgument_signed_algorithmIdentifier_algorithm_tab
    ___AbandonArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___AbandonArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___AbandonArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____AbandonArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____AbandonArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AbandonArgument_signed_algorithmIdentifier_parameters._const_tab = ____AbandonArgument_signed_algorithmIdentifier_parameters_tab
    ___AbandonArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___AbandonArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __AbandonArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___AbandonArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___AbandonArgument_signed_algorithmIdentifier_parameters),
        ])
    __AbandonArgument_signed_algorithmIdentifier._ext = []
    __AbandonArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _AbandonArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __AbandonArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __AbandonArgument_signed_algorithmIdentifier),
        (u'encrypted', __AbandonArgument_signed_encrypted),
        ])
    _AbandonArgument_signed._ext = []
    AbandonArgument._cont = ASN1Dict([
        (u'unsigned', _AbandonArgument_unsigned),
        (u'signed', _AbandonArgument_signed),
        ])
    AbandonArgument._ext = None
    
    #-----< AbandonArgumentData >-----#
    AbandonArgumentData = SEQ(name=u'AbandonArgumentData', mode=MODE_TYPE)
    _AbandonArgumentData_invokeID = CHOICE(name=u'invokeID', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CommonProtocolSpecification', 'InvokeId')))
    AbandonArgumentData._cont = ASN1Dict([
        (u'invokeID', _AbandonArgumentData_invokeID),
        ])
    AbandonArgumentData._ext = []
    
    #-----< AbandonResult >-----#
    AbandonResult = CHOICE(name=u'AbandonResult', mode=MODE_TYPE)
    _AbandonResult_null = NULL(name=u'null', mode=MODE_TYPE)
    _AbandonResult_information = CHOICE(name=u'information', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    __AbandonResult_information_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonResultData')))
    __AbandonResult_information_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___AbandonResult_information_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonResultData')))
    ___AbandonResult_information_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____AbandonResult_information_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____AbandonResult_information_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____AbandonResult_information_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____AbandonResult_information_signed_algorithmIdentifier_algorithm._const_tab = _____AbandonResult_information_signed_algorithmIdentifier_algorithm_tab
    ____AbandonResult_information_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____AbandonResult_information_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____AbandonResult_information_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____AbandonResult_information_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____AbandonResult_information_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____AbandonResult_information_signed_algorithmIdentifier_parameters._const_tab = _____AbandonResult_information_signed_algorithmIdentifier_parameters_tab
    ____AbandonResult_information_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____AbandonResult_information_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___AbandonResult_information_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____AbandonResult_information_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____AbandonResult_information_signed_algorithmIdentifier_parameters),
        ])
    ___AbandonResult_information_signed_algorithmIdentifier._ext = []
    ___AbandonResult_information_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __AbandonResult_information_signed._cont = ASN1Dict([
        (u'toBeSigned', ___AbandonResult_information_signed_toBeSigned),
        (u'algorithmIdentifier', ___AbandonResult_information_signed_algorithmIdentifier),
        (u'encrypted', ___AbandonResult_information_signed_encrypted),
        ])
    __AbandonResult_information_signed._ext = []
    _AbandonResult_information._cont = ASN1Dict([
        (u'unsigned', __AbandonResult_information_unsigned),
        (u'signed', __AbandonResult_information_signed),
        ])
    _AbandonResult_information._ext = None
    AbandonResult._cont = ASN1Dict([
        (u'null', _AbandonResult_null),
        (u'information', _AbandonResult_information),
        ])
    AbandonResult._ext = []
    
    #-----< AbandonResultData >-----#
    AbandonResultData = SEQ(name=u'AbandonResultData', mode=MODE_TYPE)
    _AbandonResultData_invokeID = CHOICE(name=u'invokeID', mode=MODE_TYPE, typeref=ASN1RefType(('CommonProtocolSpecification', 'InvokeId')))
    _AbandonResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _AbandonResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _AbandonResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _AbandonResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __AbandonResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___AbandonResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____AbandonResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____AbandonResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____AbandonResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____AbandonResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____AbandonResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____AbandonResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___AbandonResultData_notification__item__type._const_tab = ____AbandonResultData_notification__item__type_tab
    ___AbandonResultData_notification__item__type._const_tab_at = None
    ___AbandonResultData_notification__item__type._const_tab_id = u'id'
    ___AbandonResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AbandonResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____AbandonResultData_notification__item__values__item_._const_tab = ____AbandonResultData_notification__item__type_tab
    ____AbandonResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AbandonResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___AbandonResultData_notification__item__values._cont = ____AbandonResultData_notification__item__values__item_
    ___AbandonResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___AbandonResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____AbandonResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____AbandonResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____AbandonResultData_notification__item__valuesWithContext__item__value._const_tab = ____AbandonResultData_notification__item__type_tab
    _____AbandonResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____AbandonResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____AbandonResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______AbandonResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____AbandonResultData_notification__item__valuesWithContext__item__contextList._cont = ______AbandonResultData_notification__item__valuesWithContext__item__contextList__item_
    _____AbandonResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____AbandonResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____AbandonResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____AbandonResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____AbandonResultData_notification__item__valuesWithContext__item_._ext = []
    ___AbandonResultData_notification__item__valuesWithContext._cont = ____AbandonResultData_notification__item__valuesWithContext__item_
    ___AbandonResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AbandonResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___AbandonResultData_notification__item__type),
        (u'values', ___AbandonResultData_notification__item__values),
        (u'valuesWithContext', ___AbandonResultData_notification__item__valuesWithContext),
        ])
    __AbandonResultData_notification__item_._ext = []
    _AbandonResultData_notification._cont = __AbandonResultData_notification__item_
    AbandonResultData._cont = ASN1Dict([
        (u'invokeID', _AbandonResultData_invokeID),
        (u'securityParameters', _AbandonResultData_securityParameters),
        (u'performer', _AbandonResultData_performer),
        (u'aliasDereferenced', _AbandonResultData_aliasDereferenced),
        (u'notification', _AbandonResultData_notification),
        ])
    AbandonResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< list >-----#
    list = CLASS(name=u'list', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _list_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ListArgument')))
    _list_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ListResult')))
    __OPERATION_Errors_val_ParameterType_0_2 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_0_2_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'NameErrorData')))
    ___OPERATION_Errors_val_ParameterType_0_2_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_0_2_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'NameErrorData')))
    ____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_0_2_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_0_2_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_0_2_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_0_2_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_0_2_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_0_2_signed._ext = []
    __OPERATION_Errors_val_ParameterType_0_2._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_0_2_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_0_2_signed),
        ])
    __OPERATION_Errors_val_ParameterType_0_2._ext = None
    __OPERATION_Errors_val_ParameterType_1_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_1_0_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceErrorData')))
    ___OPERATION_Errors_val_ParameterType_1_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_1_0_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceErrorData')))
    ____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_1_0_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_1_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_1_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_1_0_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_1_0_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_1_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_1_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_1_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_1_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_1_0._ext = None
    __OPERATION_Errors_val_ParameterType_2_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_2_0_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReferralData')))
    ___OPERATION_Errors_val_ParameterType_2_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_2_0_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReferralData')))
    ____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_2_0_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_2_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_2_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_2_0_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_2_0_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_2_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_2_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_2_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_2_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_2_0._ext = None
    __OPERATION_Errors_val_ParameterType_3_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_3_0_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedData')))
    ___OPERATION_Errors_val_ParameterType_3_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_3_0_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedData')))
    ____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_3_0_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_3_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_3_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_3_0_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_3_0_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_3_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_3_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_3_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_3_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_3_0._ext = None
    __OPERATION_Errors_val_ParameterType_4_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_4_0_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ___OPERATION_Errors_val_ParameterType_4_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_4_0_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_4_0_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_4_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_4_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_4_0_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_4_0_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_4_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_4_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_4_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_4_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_4_0._ext = None
    list._val = dict([(u'ArgumentType', _list_val_ArgumentType), (u'ResultType', _list_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_2), (u'errorCode', (u'local', 2))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1_0), (u'errorCode', (u'local', 3))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_2_0), (u'errorCode', (u'local', 4))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3_0), (u'errorCode', (u'local', 5))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4_0), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 4))])
    
    #-----< ListArgument >-----#
    ListArgument = CHOICE(name=u'ListArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _ListArgument_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ListArgumentData')))
    _ListArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __ListArgument_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ListArgumentData')))
    __ListArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___ListArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____ListArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ListArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ListArgument_signed_algorithmIdentifier_algorithm._const_tab = ____ListArgument_signed_algorithmIdentifier_algorithm_tab
    ___ListArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___ListArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___ListArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____ListArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ListArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ListArgument_signed_algorithmIdentifier_parameters._const_tab = ____ListArgument_signed_algorithmIdentifier_parameters_tab
    ___ListArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___ListArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __ListArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___ListArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___ListArgument_signed_algorithmIdentifier_parameters),
        ])
    __ListArgument_signed_algorithmIdentifier._ext = []
    __ListArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _ListArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __ListArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __ListArgument_signed_algorithmIdentifier),
        (u'encrypted', __ListArgument_signed_encrypted),
        ])
    _ListArgument_signed._ext = []
    ListArgument._cont = ASN1Dict([
        (u'unsigned', _ListArgument_unsigned),
        (u'signed', _ListArgument_signed),
        ])
    ListArgument._ext = None
    
    #-----< ListArgumentData >-----#
    ListArgumentData = SET(name=u'ListArgumentData', mode=MODE_TYPE)
    _ListArgumentData_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _ListArgumentData_pagedResults = CHOICE(name=u'pagedResults', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'PagedResultsRequest')), opt=True)
    _ListArgumentData_listFamily = BOOL(name=u'listFamily', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ListArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _ListArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ListArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ListArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _ListArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ListArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ListArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _ListArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _ListArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _ListArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ListArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _ListArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    ListArgumentData._cont = ASN1Dict([
        (u'object', _ListArgumentData_object),
        (u'pagedResults', _ListArgumentData_pagedResults),
        (u'listFamily', _ListArgumentData_listFamily),
        (u'serviceControls', _ListArgumentData_serviceControls),
        (u'securityParameters', _ListArgumentData_securityParameters),
        (u'requestor', _ListArgumentData_requestor),
        (u'operationProgress', _ListArgumentData_operationProgress),
        (u'aliasedRDNs', _ListArgumentData_aliasedRDNs),
        (u'criticalExtensions', _ListArgumentData_criticalExtensions),
        (u'referenceType', _ListArgumentData_referenceType),
        (u'entryOnly', _ListArgumentData_entryOnly),
        (u'exclusions', _ListArgumentData_exclusions),
        (u'nameResolveOnMaster', _ListArgumentData_nameResolveOnMaster),
        (u'operationContexts', _ListArgumentData_operationContexts),
        (u'familyGrouping', _ListArgumentData_familyGrouping),
        ])
    ListArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< ListResult >-----#
    ListResult = CHOICE(name=u'ListResult', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _ListResult_unsigned = CHOICE(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ListResultData')))
    _ListResult_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __ListResult_signed_toBeSigned = CHOICE(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ListResultData')))
    __ListResult_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___ListResult_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____ListResult_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ListResult_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ListResult_signed_algorithmIdentifier_algorithm._const_tab = ____ListResult_signed_algorithmIdentifier_algorithm_tab
    ___ListResult_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___ListResult_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___ListResult_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____ListResult_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ListResult_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ListResult_signed_algorithmIdentifier_parameters._const_tab = ____ListResult_signed_algorithmIdentifier_parameters_tab
    ___ListResult_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___ListResult_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __ListResult_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___ListResult_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___ListResult_signed_algorithmIdentifier_parameters),
        ])
    __ListResult_signed_algorithmIdentifier._ext = []
    __ListResult_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _ListResult_signed._cont = ASN1Dict([
        (u'toBeSigned', __ListResult_signed_toBeSigned),
        (u'algorithmIdentifier', __ListResult_signed_algorithmIdentifier),
        (u'encrypted', __ListResult_signed_encrypted),
        ])
    _ListResult_signed._ext = []
    ListResult._cont = ASN1Dict([
        (u'unsigned', _ListResult_unsigned),
        (u'signed', _ListResult_signed),
        ])
    ListResult._ext = None
    
    #-----< ListResultData >-----#
    ListResultData = CHOICE(name=u'ListResultData', mode=MODE_TYPE)
    _ListResultData_listInfo = SET(name=u'listInfo', mode=MODE_TYPE)
    __ListResultData_listInfo_name = CHOICE(name=u'name', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    __ListResultData_listInfo_subordinates = SET_OF(name=u'subordinates', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___ListResultData_listInfo_subordinates__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ____ListResultData_listInfo_subordinates__item__rdn = SET_OF(name=u'rdn', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'RelativeDistinguishedName')))
    ____ListResultData_listInfo_subordinates__item__aliasEntry = BOOL(name=u'aliasEntry', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    ____ListResultData_listInfo_subordinates__item__fromEntry = BOOL(name=u'fromEntry', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    ___ListResultData_listInfo_subordinates__item_._cont = ASN1Dict([
        (u'rdn', ____ListResultData_listInfo_subordinates__item__rdn),
        (u'aliasEntry', ____ListResultData_listInfo_subordinates__item__aliasEntry),
        (u'fromEntry', ____ListResultData_listInfo_subordinates__item__fromEntry),
        ])
    ___ListResultData_listInfo_subordinates__item_._ext = []
    __ListResultData_listInfo_subordinates._cont = ___ListResultData_listInfo_subordinates__item_
    __ListResultData_listInfo_partialOutcomeQualifier = SET(name=u'partialOutcomeQualifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'PartialOutcomeQualifier')), opt=True)
    __ListResultData_listInfo_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    __ListResultData_listInfo_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    __ListResultData_listInfo_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    __ListResultData_listInfo_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ___ListResultData_listInfo_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ____ListResultData_listInfo_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _____ListResultData_listInfo_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ______ListResultData_listInfo_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______ListResultData_listInfo_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _____ListResultData_listInfo_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', ______ListResultData_listInfo_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ______ListResultData_listInfo_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ____ListResultData_listInfo_notification__item__type._const_tab = _____ListResultData_listInfo_notification__item__type_tab
    ____ListResultData_listInfo_notification__item__type._const_tab_at = None
    ____ListResultData_listInfo_notification__item__type._const_tab_id = u'id'
    ____ListResultData_listInfo_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    _____ListResultData_listInfo_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____ListResultData_listInfo_notification__item__values__item_._const_tab = _____ListResultData_listInfo_notification__item__type_tab
    _____ListResultData_listInfo_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    _____ListResultData_listInfo_notification__item__values__item_._const_tab_id = u'Type'
    ____ListResultData_listInfo_notification__item__values._cont = _____ListResultData_listInfo_notification__item__values__item_
    ____ListResultData_listInfo_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ____ListResultData_listInfo_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    _____ListResultData_listInfo_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ______ListResultData_listInfo_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______ListResultData_listInfo_notification__item__valuesWithContext__item__value._const_tab = _____ListResultData_listInfo_notification__item__type_tab
    ______ListResultData_listInfo_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ______ListResultData_listInfo_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    ______ListResultData_listInfo_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _______ListResultData_listInfo_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ______ListResultData_listInfo_notification__item__valuesWithContext__item__contextList._cont = _______ListResultData_listInfo_notification__item__valuesWithContext__item__contextList__item_
    ______ListResultData_listInfo_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _____ListResultData_listInfo_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ______ListResultData_listInfo_notification__item__valuesWithContext__item__value),
        (u'contextList', ______ListResultData_listInfo_notification__item__valuesWithContext__item__contextList),
        ])
    _____ListResultData_listInfo_notification__item__valuesWithContext__item_._ext = []
    ____ListResultData_listInfo_notification__item__valuesWithContext._cont = _____ListResultData_listInfo_notification__item__valuesWithContext__item_
    ____ListResultData_listInfo_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___ListResultData_listInfo_notification__item_._cont = ASN1Dict([
        (u'type', ____ListResultData_listInfo_notification__item__type),
        (u'values', ____ListResultData_listInfo_notification__item__values),
        (u'valuesWithContext', ____ListResultData_listInfo_notification__item__valuesWithContext),
        ])
    ___ListResultData_listInfo_notification__item_._ext = []
    __ListResultData_listInfo_notification._cont = ___ListResultData_listInfo_notification__item_
    _ListResultData_listInfo._cont = ASN1Dict([
        (u'name', __ListResultData_listInfo_name),
        (u'subordinates', __ListResultData_listInfo_subordinates),
        (u'partialOutcomeQualifier', __ListResultData_listInfo_partialOutcomeQualifier),
        (u'securityParameters', __ListResultData_listInfo_securityParameters),
        (u'performer', __ListResultData_listInfo_performer),
        (u'aliasDereferenced', __ListResultData_listInfo_aliasDereferenced),
        (u'notification', __ListResultData_listInfo_notification),
        ])
    _ListResultData_listInfo._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    _ListResultData_uncorrelatedListInfo = SET_OF(name=u'uncorrelatedListInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ListResultData_uncorrelatedListInfo__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ListResult')))
    _ListResultData_uncorrelatedListInfo._cont = __ListResultData_uncorrelatedListInfo__item_
    ListResultData._cont = ASN1Dict([
        (u'listInfo', _ListResultData_listInfo),
        (u'uncorrelatedListInfo', _ListResultData_uncorrelatedListInfo),
        ])
    ListResultData._ext = []
    
    #-----< PartialOutcomeQualifier >-----#
    PartialOutcomeQualifier = SET(name=u'PartialOutcomeQualifier', mode=MODE_TYPE)
    _PartialOutcomeQualifier_limitProblem = INT(name=u'limitProblem', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'LimitProblem')), opt=True)
    _PartialOutcomeQualifier_unexplored = SET_OF(name=u'unexplored', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __PartialOutcomeQualifier_unexplored__item_ = SET(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DistributedOperations', 'ContinuationReference')))
    _PartialOutcomeQualifier_unexplored._cont = __PartialOutcomeQualifier_unexplored__item_
    _PartialOutcomeQualifier_unexplored._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _PartialOutcomeQualifier_unavailableCriticalExtensions = BOOL(name=u'unavailableCriticalExtensions', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _PartialOutcomeQualifier_unknownErrors = SET_OF(name=u'unknownErrors', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __PartialOutcomeQualifier_unknownErrors__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('_IMPL_', u'ABSTRACT-SYNTAX'), [u'Type']))
    _PartialOutcomeQualifier_unknownErrors._cont = __PartialOutcomeQualifier_unknownErrors__item_
    _PartialOutcomeQualifier_unknownErrors._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _PartialOutcomeQualifier_queryReference = OCT_STR(name=u'queryReference', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _PartialOutcomeQualifier_overspecFilter = CHOICE(name=u'overspecFilter', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')), opt=True)
    _PartialOutcomeQualifier_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __PartialOutcomeQualifier_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___PartialOutcomeQualifier_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____PartialOutcomeQualifier_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____PartialOutcomeQualifier_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____PartialOutcomeQualifier_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____PartialOutcomeQualifier_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____PartialOutcomeQualifier_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____PartialOutcomeQualifier_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___PartialOutcomeQualifier_notification__item__type._const_tab = ____PartialOutcomeQualifier_notification__item__type_tab
    ___PartialOutcomeQualifier_notification__item__type._const_tab_at = None
    ___PartialOutcomeQualifier_notification__item__type._const_tab_id = u'id'
    ___PartialOutcomeQualifier_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____PartialOutcomeQualifier_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____PartialOutcomeQualifier_notification__item__values__item_._const_tab = ____PartialOutcomeQualifier_notification__item__type_tab
    ____PartialOutcomeQualifier_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____PartialOutcomeQualifier_notification__item__values__item_._const_tab_id = u'Type'
    ___PartialOutcomeQualifier_notification__item__values._cont = ____PartialOutcomeQualifier_notification__item__values__item_
    ___PartialOutcomeQualifier_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___PartialOutcomeQualifier_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____PartialOutcomeQualifier_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____PartialOutcomeQualifier_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____PartialOutcomeQualifier_notification__item__valuesWithContext__item__value._const_tab = ____PartialOutcomeQualifier_notification__item__type_tab
    _____PartialOutcomeQualifier_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____PartialOutcomeQualifier_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____PartialOutcomeQualifier_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______PartialOutcomeQualifier_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____PartialOutcomeQualifier_notification__item__valuesWithContext__item__contextList._cont = ______PartialOutcomeQualifier_notification__item__valuesWithContext__item__contextList__item_
    _____PartialOutcomeQualifier_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____PartialOutcomeQualifier_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____PartialOutcomeQualifier_notification__item__valuesWithContext__item__value),
        (u'contextList', _____PartialOutcomeQualifier_notification__item__valuesWithContext__item__contextList),
        ])
    ____PartialOutcomeQualifier_notification__item__valuesWithContext__item_._ext = []
    ___PartialOutcomeQualifier_notification__item__valuesWithContext._cont = ____PartialOutcomeQualifier_notification__item__valuesWithContext__item_
    ___PartialOutcomeQualifier_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __PartialOutcomeQualifier_notification__item_._cont = ASN1Dict([
        (u'type', ___PartialOutcomeQualifier_notification__item__type),
        (u'values', ___PartialOutcomeQualifier_notification__item__values),
        (u'valuesWithContext', ___PartialOutcomeQualifier_notification__item__valuesWithContext),
        ])
    __PartialOutcomeQualifier_notification__item_._ext = []
    _PartialOutcomeQualifier_notification._cont = __PartialOutcomeQualifier_notification__item_
    _PartialOutcomeQualifier_notification._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _PartialOutcomeQualifier_entryCount = CHOICE(name=u'entryCount', mode=MODE_TYPE, opt=True)
    __PartialOutcomeQualifier_entryCount_bestEstimate = INT(name=u'bestEstimate', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __PartialOutcomeQualifier_entryCount_lowEstimate = INT(name=u'lowEstimate', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __PartialOutcomeQualifier_entryCount_exact = INT(name=u'exact', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    _PartialOutcomeQualifier_entryCount._cont = ASN1Dict([
        (u'bestEstimate', __PartialOutcomeQualifier_entryCount_bestEstimate),
        (u'lowEstimate', __PartialOutcomeQualifier_entryCount_lowEstimate),
        (u'exact', __PartialOutcomeQualifier_entryCount_exact),
        ])
    _PartialOutcomeQualifier_entryCount._ext = []
    PartialOutcomeQualifier._cont = ASN1Dict([
        (u'limitProblem', _PartialOutcomeQualifier_limitProblem),
        (u'unexplored', _PartialOutcomeQualifier_unexplored),
        (u'unavailableCriticalExtensions', _PartialOutcomeQualifier_unavailableCriticalExtensions),
        (u'unknownErrors', _PartialOutcomeQualifier_unknownErrors),
        (u'queryReference', _PartialOutcomeQualifier_queryReference),
        (u'overspecFilter', _PartialOutcomeQualifier_overspecFilter),
        (u'notification', _PartialOutcomeQualifier_notification),
        (u'entryCount', _PartialOutcomeQualifier_entryCount),
        ])
    PartialOutcomeQualifier._ext = None
    
    #-----< LimitProblem >-----#
    LimitProblem = INT(name=u'LimitProblem', mode=MODE_TYPE)
    LimitProblem._cont = ASN1Dict([(u'timeLimitExceeded', 0), (u'sizeLimitExceeded', 1), (u'administrativeLimitExceeded', 2)])
    
    #-----< search >-----#
    search = CLASS(name=u'search', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _search_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SearchArgument')))
    _search_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SearchResult')))
    search._val = dict([(u'ArgumentType', _search_val_ArgumentType), (u'ResultType', _search_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_0), (u'errorCode', (u'local', 1))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 2))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_2), (u'errorCode', (u'local', 3))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 4))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4), (u'errorCode', (u'local', 5))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_5), (u'errorCode', (u'local', 6))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 5))])
    
    #-----< SearchArgument >-----#
    SearchArgument = CHOICE(name=u'SearchArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _SearchArgument_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SearchArgumentData')))
    _SearchArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __SearchArgument_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SearchArgumentData')))
    __SearchArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___SearchArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____SearchArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____SearchArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___SearchArgument_signed_algorithmIdentifier_algorithm._const_tab = ____SearchArgument_signed_algorithmIdentifier_algorithm_tab
    ___SearchArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___SearchArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___SearchArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____SearchArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____SearchArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___SearchArgument_signed_algorithmIdentifier_parameters._const_tab = ____SearchArgument_signed_algorithmIdentifier_parameters_tab
    ___SearchArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___SearchArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __SearchArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___SearchArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___SearchArgument_signed_algorithmIdentifier_parameters),
        ])
    __SearchArgument_signed_algorithmIdentifier._ext = []
    __SearchArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _SearchArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __SearchArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __SearchArgument_signed_algorithmIdentifier),
        (u'encrypted', __SearchArgument_signed_encrypted),
        ])
    _SearchArgument_signed._ext = []
    SearchArgument._cont = ASN1Dict([
        (u'unsigned', _SearchArgument_unsigned),
        (u'signed', _SearchArgument_signed),
        ])
    SearchArgument._ext = None
    
    #-----< SearchArgumentData >-----#
    SearchArgumentData = SET(name=u'SearchArgumentData', mode=MODE_TYPE)
    _SearchArgumentData_baseObject = CHOICE(name=u'baseObject', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _SearchArgumentData_subset = INT(name=u'subset', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=0)
    _SearchArgumentData_subset._cont = ASN1Dict([(u'baseObject', 0), (u'oneLevel', 1), (u'wholeSubtree', 2)])
    _SearchArgumentData_filter = CHOICE(name=u'filter', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')), default=(u'and', []))
    _SearchArgumentData_searchAliases = BOOL(name=u'searchAliases', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _SearchArgumentData_selection = SET(name=u'selection', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'EntryInformationSelection')), default=dict([]))
    _SearchArgumentData_pagedResults = CHOICE(name=u'pagedResults', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'PagedResultsRequest')), opt=True)
    _SearchArgumentData_matchedValuesOnly = BOOL(name=u'matchedValuesOnly', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _SearchArgumentData_extendedFilter = CHOICE(name=u'extendedFilter', mode=MODE_TYPE, tag=(7, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')), opt=True)
    _SearchArgumentData_checkOverspecified = BOOL(name=u'checkOverspecified', mode=MODE_TYPE, tag=(8, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _SearchArgumentData_relaxation = SEQ(name=u'relaxation', mode=MODE_TYPE, tag=(9, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('ServiceAdministration', 'RelaxationPolicy')), opt=True)
    _SearchArgumentData_extendedArea = INT(name=u'extendedArea', mode=MODE_TYPE, tag=(10, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _SearchArgumentData_hierarchySelections = BIT_STR(name=u'hierarchySelections', mode=MODE_TYPE, tag=(11, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'HierarchySelections')), default=(1, 1))
    _SearchArgumentData_searchControlOptions = BIT_STR(name=u'searchControlOptions', mode=MODE_TYPE, tag=(12, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SearchControlOptions')), default=(1, 1))
    _SearchArgumentData_joinArguments = SEQ_OF(name=u'joinArguments', mode=MODE_TYPE, tag=(13, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __SearchArgumentData_joinArguments__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'JoinArgument')))
    _SearchArgumentData_joinArguments._cont = __SearchArgumentData_joinArguments__item_
    _SearchArgumentData_joinArguments._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _SearchArgumentData_joinType = ENUM(name=u'joinType', mode=MODE_TYPE, tag=(14, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=u'leftOuterJoin')
    _SearchArgumentData_joinType._cont = ASN1Dict([(u'innerJoin', 0), (u'leftOuterJoin', 1), (u'fullOuterJoin', 2)])
    _SearchArgumentData_joinType._ext = None
    _SearchArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _SearchArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _SearchArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _SearchArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _SearchArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _SearchArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _SearchArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _SearchArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _SearchArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _SearchArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _SearchArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _SearchArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    SearchArgumentData._cont = ASN1Dict([
        (u'baseObject', _SearchArgumentData_baseObject),
        (u'subset', _SearchArgumentData_subset),
        (u'filter', _SearchArgumentData_filter),
        (u'searchAliases', _SearchArgumentData_searchAliases),
        (u'selection', _SearchArgumentData_selection),
        (u'pagedResults', _SearchArgumentData_pagedResults),
        (u'matchedValuesOnly', _SearchArgumentData_matchedValuesOnly),
        (u'extendedFilter', _SearchArgumentData_extendedFilter),
        (u'checkOverspecified', _SearchArgumentData_checkOverspecified),
        (u'relaxation', _SearchArgumentData_relaxation),
        (u'extendedArea', _SearchArgumentData_extendedArea),
        (u'hierarchySelections', _SearchArgumentData_hierarchySelections),
        (u'searchControlOptions', _SearchArgumentData_searchControlOptions),
        (u'joinArguments', _SearchArgumentData_joinArguments),
        (u'joinType', _SearchArgumentData_joinType),
        (u'serviceControls', _SearchArgumentData_serviceControls),
        (u'securityParameters', _SearchArgumentData_securityParameters),
        (u'requestor', _SearchArgumentData_requestor),
        (u'operationProgress', _SearchArgumentData_operationProgress),
        (u'aliasedRDNs', _SearchArgumentData_aliasedRDNs),
        (u'criticalExtensions', _SearchArgumentData_criticalExtensions),
        (u'referenceType', _SearchArgumentData_referenceType),
        (u'entryOnly', _SearchArgumentData_entryOnly),
        (u'exclusions', _SearchArgumentData_exclusions),
        (u'nameResolveOnMaster', _SearchArgumentData_nameResolveOnMaster),
        (u'operationContexts', _SearchArgumentData_operationContexts),
        (u'familyGrouping', _SearchArgumentData_familyGrouping),
        ])
    SearchArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< HierarchySelections >-----#
    HierarchySelections = BIT_STR(name=u'HierarchySelections', mode=MODE_TYPE)
    HierarchySelections._cont = ASN1Dict([(u'self', 0), (u'children', 1), (u'parent', 2), (u'hierarchy', 3), (u'top', 4), (u'subtree', 5), (u'siblings', 6), (u'siblingChildren', 7), (u'siblingSubtree', 8), (u'all', 9)])
    
    #-----< SearchControlOptions >-----#
    SearchControlOptions = BIT_STR(name=u'SearchControlOptions', mode=MODE_TYPE)
    SearchControlOptions._cont = ASN1Dict([(u'searchAliases', 0), (u'matchedValuesOnly', 1), (u'checkOverspecified', 2), (u'performExactly', 3), (u'includeAllAreas', 4), (u'noSystemRelaxation', 5), (u'dnAttribute', 6), (u'matchOnResidualName', 7), (u'entryCount', 8), (u'useSubset', 9), (u'separateFamilyMembers', 10), (u'searchFamily', 11)])
    
    #-----< JoinArgument >-----#
    JoinArgument = SEQ(name=u'JoinArgument', mode=MODE_TYPE)
    _JoinArgument_joinBaseObject = CHOICE(name=u'joinBaseObject', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _JoinArgument_domainLocalID = CHOICE(name=u'domainLocalID', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'DomainLocalID')), opt=True)
    _JoinArgument_joinSubset = ENUM(name=u'joinSubset', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=u'baseObject')
    _JoinArgument_joinSubset._cont = ASN1Dict([(u'baseObject', 0), (u'oneLevel', 1), (u'wholeSubtree', 2)])
    _JoinArgument_joinSubset._ext = []
    _JoinArgument_joinFilter = CHOICE(name=u'joinFilter', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'Filter')), opt=True)
    _JoinArgument_joinAttributes = SEQ_OF(name=u'joinAttributes', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __JoinArgument_joinAttributes__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'JoinAttPair')))
    _JoinArgument_joinAttributes._cont = __JoinArgument_joinAttributes__item_
    _JoinArgument_joinAttributes._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _JoinArgument_joinSelection = SET(name=u'joinSelection', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'EntryInformationSelection')))
    JoinArgument._cont = ASN1Dict([
        (u'joinBaseObject', _JoinArgument_joinBaseObject),
        (u'domainLocalID', _JoinArgument_domainLocalID),
        (u'joinSubset', _JoinArgument_joinSubset),
        (u'joinFilter', _JoinArgument_joinFilter),
        (u'joinAttributes', _JoinArgument_joinAttributes),
        (u'joinSelection', _JoinArgument_joinSelection),
        ])
    JoinArgument._ext = []
    
    #-----< DomainLocalID >-----#
    DomainLocalID = CHOICE(name=u'DomainLocalID', mode=MODE_TYPE, typeref=ASN1RefType(('SelectedAttributeTypes', 'UnboundedDirectoryString')))
    
    #-----< JoinAttPair >-----#
    JoinAttPair = SEQ(name=u'JoinAttPair', mode=MODE_TYPE)
    _JoinAttPair_baseAtt = OID(name=u'baseAtt', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _JoinAttPair_joinAtt = OID(name=u'joinAtt', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _JoinAttPair_joinContext = SEQ_OF(name=u'joinContext', mode=MODE_TYPE, opt=True)
    __JoinAttPair_joinContext__item_ = OID(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'JoinContextType')))
    _JoinAttPair_joinContext._cont = __JoinAttPair_joinContext__item_
    _JoinAttPair_joinContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    JoinAttPair._cont = ASN1Dict([
        (u'baseAtt', _JoinAttPair_baseAtt),
        (u'joinAtt', _JoinAttPair_joinAtt),
        (u'joinContext', _JoinAttPair_joinContext),
        ])
    JoinAttPair._ext = []
    
    #-----< JoinContextType >-----#
    JoinContextType = OID(name=u'JoinContextType', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'CONTEXT'), [u'id']))
    _JoinContextType_tab = CLASS(name='_tab_CONTEXT', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'CONTEXT')))
    _JoinContextType_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    JoinContextType._const_tab = _JoinContextType_tab
    JoinContextType._const_tab_at = None
    JoinContextType._const_tab_id = u'id'
    
    #-----< SearchResult >-----#
    SearchResult = CHOICE(name=u'SearchResult', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _SearchResult_unsigned = CHOICE(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SearchResultData')))
    _SearchResult_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __SearchResult_signed_toBeSigned = CHOICE(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SearchResultData')))
    __SearchResult_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___SearchResult_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____SearchResult_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____SearchResult_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___SearchResult_signed_algorithmIdentifier_algorithm._const_tab = ____SearchResult_signed_algorithmIdentifier_algorithm_tab
    ___SearchResult_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___SearchResult_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___SearchResult_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____SearchResult_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____SearchResult_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___SearchResult_signed_algorithmIdentifier_parameters._const_tab = ____SearchResult_signed_algorithmIdentifier_parameters_tab
    ___SearchResult_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___SearchResult_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __SearchResult_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___SearchResult_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___SearchResult_signed_algorithmIdentifier_parameters),
        ])
    __SearchResult_signed_algorithmIdentifier._ext = []
    __SearchResult_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _SearchResult_signed._cont = ASN1Dict([
        (u'toBeSigned', __SearchResult_signed_toBeSigned),
        (u'algorithmIdentifier', __SearchResult_signed_algorithmIdentifier),
        (u'encrypted', __SearchResult_signed_encrypted),
        ])
    _SearchResult_signed._ext = []
    SearchResult._cont = ASN1Dict([
        (u'unsigned', _SearchResult_unsigned),
        (u'signed', _SearchResult_signed),
        ])
    SearchResult._ext = None
    
    #-----< SearchResultData >-----#
    SearchResultData = CHOICE(name=u'SearchResultData', mode=MODE_TYPE)
    _SearchResultData_searchInfo = SET(name=u'searchInfo', mode=MODE_TYPE)
    __SearchResultData_searchInfo_name = CHOICE(name=u'name', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Name')), opt=True)
    __SearchResultData_searchInfo_entries = SET_OF(name=u'entries', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    ___SearchResultData_searchInfo_entries__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'EntryInformation')))
    __SearchResultData_searchInfo_entries._cont = ___SearchResultData_searchInfo_entries__item_
    __SearchResultData_searchInfo_partialOutcomeQualifier = SET(name=u'partialOutcomeQualifier', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'PartialOutcomeQualifier')), opt=True)
    __SearchResultData_searchInfo_altMatching = BOOL(name=u'altMatching', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    __SearchResultData_searchInfo_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    __SearchResultData_searchInfo_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    __SearchResultData_searchInfo_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    __SearchResultData_searchInfo_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    ___SearchResultData_searchInfo_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ____SearchResultData_searchInfo_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _____SearchResultData_searchInfo_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ______SearchResultData_searchInfo_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______SearchResultData_searchInfo_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _____SearchResultData_searchInfo_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', ______SearchResultData_searchInfo_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ______SearchResultData_searchInfo_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ____SearchResultData_searchInfo_notification__item__type._const_tab = _____SearchResultData_searchInfo_notification__item__type_tab
    ____SearchResultData_searchInfo_notification__item__type._const_tab_at = None
    ____SearchResultData_searchInfo_notification__item__type._const_tab_id = u'id'
    ____SearchResultData_searchInfo_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    _____SearchResultData_searchInfo_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____SearchResultData_searchInfo_notification__item__values__item_._const_tab = _____SearchResultData_searchInfo_notification__item__type_tab
    _____SearchResultData_searchInfo_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    _____SearchResultData_searchInfo_notification__item__values__item_._const_tab_id = u'Type'
    ____SearchResultData_searchInfo_notification__item__values._cont = _____SearchResultData_searchInfo_notification__item__values__item_
    ____SearchResultData_searchInfo_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ____SearchResultData_searchInfo_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    _____SearchResultData_searchInfo_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ______SearchResultData_searchInfo_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______SearchResultData_searchInfo_notification__item__valuesWithContext__item__value._const_tab = _____SearchResultData_searchInfo_notification__item__type_tab
    ______SearchResultData_searchInfo_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ______SearchResultData_searchInfo_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    ______SearchResultData_searchInfo_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _______SearchResultData_searchInfo_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ______SearchResultData_searchInfo_notification__item__valuesWithContext__item__contextList._cont = _______SearchResultData_searchInfo_notification__item__valuesWithContext__item__contextList__item_
    ______SearchResultData_searchInfo_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _____SearchResultData_searchInfo_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ______SearchResultData_searchInfo_notification__item__valuesWithContext__item__value),
        (u'contextList', ______SearchResultData_searchInfo_notification__item__valuesWithContext__item__contextList),
        ])
    _____SearchResultData_searchInfo_notification__item__valuesWithContext__item_._ext = []
    ____SearchResultData_searchInfo_notification__item__valuesWithContext._cont = _____SearchResultData_searchInfo_notification__item__valuesWithContext__item_
    ____SearchResultData_searchInfo_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___SearchResultData_searchInfo_notification__item_._cont = ASN1Dict([
        (u'type', ____SearchResultData_searchInfo_notification__item__type),
        (u'values', ____SearchResultData_searchInfo_notification__item__values),
        (u'valuesWithContext', ____SearchResultData_searchInfo_notification__item__valuesWithContext),
        ])
    ___SearchResultData_searchInfo_notification__item_._ext = []
    __SearchResultData_searchInfo_notification._cont = ___SearchResultData_searchInfo_notification__item_
    _SearchResultData_searchInfo._cont = ASN1Dict([
        (u'name', __SearchResultData_searchInfo_name),
        (u'entries', __SearchResultData_searchInfo_entries),
        (u'partialOutcomeQualifier', __SearchResultData_searchInfo_partialOutcomeQualifier),
        (u'altMatching', __SearchResultData_searchInfo_altMatching),
        (u'securityParameters', __SearchResultData_searchInfo_securityParameters),
        (u'performer', __SearchResultData_searchInfo_performer),
        (u'aliasDereferenced', __SearchResultData_searchInfo_aliasDereferenced),
        (u'notification', __SearchResultData_searchInfo_notification),
        ])
    _SearchResultData_searchInfo._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    _SearchResultData_uncorrelatedSearchInfo = SET_OF(name=u'uncorrelatedSearchInfo', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __SearchResultData_uncorrelatedSearchInfo__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SearchResult')))
    _SearchResultData_uncorrelatedSearchInfo._cont = __SearchResultData_uncorrelatedSearchInfo__item_
    SearchResultData._cont = ASN1Dict([
        (u'searchInfo', _SearchResultData_searchInfo),
        (u'uncorrelatedSearchInfo', _SearchResultData_uncorrelatedSearchInfo),
        ])
    SearchResultData._ext = []
    
    #-----< addEntry >-----#
    addEntry = CLASS(name=u'addEntry', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _addEntry_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AddEntryArgument')))
    _addEntry_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AddEntryResult')))
    __OPERATION_Errors_val_ParameterType_5_0 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_5_0_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'UpdateErrorData')))
    ___OPERATION_Errors_val_ParameterType_5_0_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_5_0_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'UpdateErrorData')))
    ____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_5_0_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_5_0_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_5_0_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_5_0_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_5_0_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_5_0_signed._ext = []
    __OPERATION_Errors_val_ParameterType_5_0._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_5_0_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_5_0_signed),
        ])
    __OPERATION_Errors_val_ParameterType_5_0._ext = None
    addEntry._val = dict([(u'ArgumentType', _addEntry_val_ArgumentType), (u'ResultType', _addEntry_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_0), (u'errorCode', (u'local', 1))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 2))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_2), (u'errorCode', (u'local', 3))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 4))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4_0), (u'errorCode', (u'local', 6))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_5_0), (u'errorCode', (u'local', 8))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 6))])
    
    #-----< AddEntryArgument >-----#
    AddEntryArgument = CHOICE(name=u'AddEntryArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _AddEntryArgument_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AddEntryArgumentData')))
    _AddEntryArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __AddEntryArgument_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AddEntryArgumentData')))
    __AddEntryArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___AddEntryArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____AddEntryArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____AddEntryArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AddEntryArgument_signed_algorithmIdentifier_algorithm._const_tab = ____AddEntryArgument_signed_algorithmIdentifier_algorithm_tab
    ___AddEntryArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___AddEntryArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___AddEntryArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____AddEntryArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____AddEntryArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AddEntryArgument_signed_algorithmIdentifier_parameters._const_tab = ____AddEntryArgument_signed_algorithmIdentifier_parameters_tab
    ___AddEntryArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___AddEntryArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __AddEntryArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___AddEntryArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___AddEntryArgument_signed_algorithmIdentifier_parameters),
        ])
    __AddEntryArgument_signed_algorithmIdentifier._ext = []
    __AddEntryArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _AddEntryArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __AddEntryArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __AddEntryArgument_signed_algorithmIdentifier),
        (u'encrypted', __AddEntryArgument_signed_encrypted),
        ])
    _AddEntryArgument_signed._ext = []
    AddEntryArgument._cont = ASN1Dict([
        (u'unsigned', _AddEntryArgument_unsigned),
        (u'signed', _AddEntryArgument_signed),
        ])
    AddEntryArgument._ext = None
    
    #-----< AddEntryArgumentData >-----#
    AddEntryArgumentData = SET(name=u'AddEntryArgumentData', mode=MODE_TYPE)
    _AddEntryArgumentData_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _AddEntryArgumentData_entry = SET_OF(name=u'entry', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __AddEntryArgumentData_entry__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___AddEntryArgumentData_entry__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____AddEntryArgumentData_entry__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____AddEntryArgumentData_entry__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____AddEntryArgumentData_entry__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____AddEntryArgumentData_entry__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____AddEntryArgumentData_entry__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____AddEntryArgumentData_entry__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___AddEntryArgumentData_entry__item__type._const_tab = ____AddEntryArgumentData_entry__item__type_tab
    ___AddEntryArgumentData_entry__item__type._const_tab_at = None
    ___AddEntryArgumentData_entry__item__type._const_tab_id = u'id'
    ___AddEntryArgumentData_entry__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AddEntryArgumentData_entry__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____AddEntryArgumentData_entry__item__values__item_._const_tab = ____AddEntryArgumentData_entry__item__type_tab
    ____AddEntryArgumentData_entry__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AddEntryArgumentData_entry__item__values__item_._const_tab_id = u'Type'
    ___AddEntryArgumentData_entry__item__values._cont = ____AddEntryArgumentData_entry__item__values__item_
    ___AddEntryArgumentData_entry__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___AddEntryArgumentData_entry__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____AddEntryArgumentData_entry__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____AddEntryArgumentData_entry__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____AddEntryArgumentData_entry__item__valuesWithContext__item__value._const_tab = ____AddEntryArgumentData_entry__item__type_tab
    _____AddEntryArgumentData_entry__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____AddEntryArgumentData_entry__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____AddEntryArgumentData_entry__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______AddEntryArgumentData_entry__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____AddEntryArgumentData_entry__item__valuesWithContext__item__contextList._cont = ______AddEntryArgumentData_entry__item__valuesWithContext__item__contextList__item_
    _____AddEntryArgumentData_entry__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____AddEntryArgumentData_entry__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____AddEntryArgumentData_entry__item__valuesWithContext__item__value),
        (u'contextList', _____AddEntryArgumentData_entry__item__valuesWithContext__item__contextList),
        ])
    ____AddEntryArgumentData_entry__item__valuesWithContext__item_._ext = []
    ___AddEntryArgumentData_entry__item__valuesWithContext._cont = ____AddEntryArgumentData_entry__item__valuesWithContext__item_
    ___AddEntryArgumentData_entry__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AddEntryArgumentData_entry__item_._cont = ASN1Dict([
        (u'type', ___AddEntryArgumentData_entry__item__type),
        (u'values', ___AddEntryArgumentData_entry__item__values),
        (u'valuesWithContext', ___AddEntryArgumentData_entry__item__valuesWithContext),
        ])
    __AddEntryArgumentData_entry__item_._ext = []
    _AddEntryArgumentData_entry._cont = __AddEntryArgumentData_entry__item_
    _AddEntryArgumentData_targetSystem = SET(name=u'targetSystem', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'AccessPoint')), opt=True)
    _AddEntryArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _AddEntryArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _AddEntryArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _AddEntryArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _AddEntryArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _AddEntryArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _AddEntryArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _AddEntryArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _AddEntryArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _AddEntryArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _AddEntryArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _AddEntryArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    AddEntryArgumentData._cont = ASN1Dict([
        (u'object', _AddEntryArgumentData_object),
        (u'entry', _AddEntryArgumentData_entry),
        (u'targetSystem', _AddEntryArgumentData_targetSystem),
        (u'serviceControls', _AddEntryArgumentData_serviceControls),
        (u'securityParameters', _AddEntryArgumentData_securityParameters),
        (u'requestor', _AddEntryArgumentData_requestor),
        (u'operationProgress', _AddEntryArgumentData_operationProgress),
        (u'aliasedRDNs', _AddEntryArgumentData_aliasedRDNs),
        (u'criticalExtensions', _AddEntryArgumentData_criticalExtensions),
        (u'referenceType', _AddEntryArgumentData_referenceType),
        (u'entryOnly', _AddEntryArgumentData_entryOnly),
        (u'exclusions', _AddEntryArgumentData_exclusions),
        (u'nameResolveOnMaster', _AddEntryArgumentData_nameResolveOnMaster),
        (u'operationContexts', _AddEntryArgumentData_operationContexts),
        (u'familyGrouping', _AddEntryArgumentData_familyGrouping),
        ])
    AddEntryArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< AddEntryResult >-----#
    AddEntryResult = CHOICE(name=u'AddEntryResult', mode=MODE_TYPE)
    _AddEntryResult_null = NULL(name=u'null', mode=MODE_TYPE)
    _AddEntryResult_information = CHOICE(name=u'information', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    __AddEntryResult_information_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AddEntryResultData')))
    __AddEntryResult_information_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___AddEntryResult_information_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AddEntryResultData')))
    ___AddEntryResult_information_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____AddEntryResult_information_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____AddEntryResult_information_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____AddEntryResult_information_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____AddEntryResult_information_signed_algorithmIdentifier_algorithm._const_tab = _____AddEntryResult_information_signed_algorithmIdentifier_algorithm_tab
    ____AddEntryResult_information_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____AddEntryResult_information_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____AddEntryResult_information_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____AddEntryResult_information_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____AddEntryResult_information_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____AddEntryResult_information_signed_algorithmIdentifier_parameters._const_tab = _____AddEntryResult_information_signed_algorithmIdentifier_parameters_tab
    ____AddEntryResult_information_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____AddEntryResult_information_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___AddEntryResult_information_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____AddEntryResult_information_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____AddEntryResult_information_signed_algorithmIdentifier_parameters),
        ])
    ___AddEntryResult_information_signed_algorithmIdentifier._ext = []
    ___AddEntryResult_information_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __AddEntryResult_information_signed._cont = ASN1Dict([
        (u'toBeSigned', ___AddEntryResult_information_signed_toBeSigned),
        (u'algorithmIdentifier', ___AddEntryResult_information_signed_algorithmIdentifier),
        (u'encrypted', ___AddEntryResult_information_signed_encrypted),
        ])
    __AddEntryResult_information_signed._ext = []
    _AddEntryResult_information._cont = ASN1Dict([
        (u'unsigned', __AddEntryResult_information_unsigned),
        (u'signed', __AddEntryResult_information_signed),
        ])
    _AddEntryResult_information._ext = None
    AddEntryResult._cont = ASN1Dict([
        (u'null', _AddEntryResult_null),
        (u'information', _AddEntryResult_information),
        ])
    AddEntryResult._ext = []
    
    #-----< AddEntryResultData >-----#
    AddEntryResultData = SEQ(name=u'AddEntryResultData', mode=MODE_TYPE)
    _AddEntryResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _AddEntryResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _AddEntryResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _AddEntryResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __AddEntryResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___AddEntryResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____AddEntryResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____AddEntryResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____AddEntryResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____AddEntryResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____AddEntryResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____AddEntryResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___AddEntryResultData_notification__item__type._const_tab = ____AddEntryResultData_notification__item__type_tab
    ___AddEntryResultData_notification__item__type._const_tab_at = None
    ___AddEntryResultData_notification__item__type._const_tab_id = u'id'
    ___AddEntryResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AddEntryResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____AddEntryResultData_notification__item__values__item_._const_tab = ____AddEntryResultData_notification__item__type_tab
    ____AddEntryResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AddEntryResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___AddEntryResultData_notification__item__values._cont = ____AddEntryResultData_notification__item__values__item_
    ___AddEntryResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___AddEntryResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____AddEntryResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____AddEntryResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____AddEntryResultData_notification__item__valuesWithContext__item__value._const_tab = ____AddEntryResultData_notification__item__type_tab
    _____AddEntryResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____AddEntryResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____AddEntryResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______AddEntryResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____AddEntryResultData_notification__item__valuesWithContext__item__contextList._cont = ______AddEntryResultData_notification__item__valuesWithContext__item__contextList__item_
    _____AddEntryResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____AddEntryResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____AddEntryResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____AddEntryResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____AddEntryResultData_notification__item__valuesWithContext__item_._ext = []
    ___AddEntryResultData_notification__item__valuesWithContext._cont = ____AddEntryResultData_notification__item__valuesWithContext__item_
    ___AddEntryResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AddEntryResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___AddEntryResultData_notification__item__type),
        (u'values', ___AddEntryResultData_notification__item__values),
        (u'valuesWithContext', ___AddEntryResultData_notification__item__valuesWithContext),
        ])
    __AddEntryResultData_notification__item_._ext = []
    _AddEntryResultData_notification._cont = __AddEntryResultData_notification__item_
    AddEntryResultData._cont = ASN1Dict([
        (u'securityParameters', _AddEntryResultData_securityParameters),
        (u'performer', _AddEntryResultData_performer),
        (u'aliasDereferenced', _AddEntryResultData_aliasDereferenced),
        (u'notification', _AddEntryResultData_notification),
        ])
    AddEntryResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< removeEntry >-----#
    removeEntry = CLASS(name=u'removeEntry', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _removeEntry_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'RemoveEntryArgument')))
    _removeEntry_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'RemoveEntryResult')))
    __OPERATION_Errors_val_ParameterType_3_1 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_3_1_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ___OPERATION_Errors_val_ParameterType_3_1_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_3_1_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_3_1_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_3_1_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_3_1_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_3_1_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_3_1_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_3_1_signed._ext = []
    __OPERATION_Errors_val_ParameterType_3_1._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_3_1_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_3_1_signed),
        ])
    __OPERATION_Errors_val_ParameterType_3_1._ext = None
    __OPERATION_Errors_val_ParameterType_4_1 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_4_1_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'UpdateErrorData')))
    ___OPERATION_Errors_val_ParameterType_4_1_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_4_1_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'UpdateErrorData')))
    ____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_4_1_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_4_1_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_4_1_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_4_1_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_4_1_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_4_1_signed._ext = []
    __OPERATION_Errors_val_ParameterType_4_1._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_4_1_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_4_1_signed),
        ])
    __OPERATION_Errors_val_ParameterType_4_1._ext = None
    removeEntry._val = dict([(u'ArgumentType', _removeEntry_val_ArgumentType), (u'ResultType', _removeEntry_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_2), (u'errorCode', (u'local', 2))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1_0), (u'errorCode', (u'local', 3))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_2_0), (u'errorCode', (u'local', 4))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3_1), (u'errorCode', (u'local', 6))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4_1), (u'errorCode', (u'local', 8))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 7))])
    
    #-----< RemoveEntryArgument >-----#
    RemoveEntryArgument = CHOICE(name=u'RemoveEntryArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _RemoveEntryArgument_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'RemoveEntryArgumentData')))
    _RemoveEntryArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __RemoveEntryArgument_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'RemoveEntryArgumentData')))
    __RemoveEntryArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___RemoveEntryArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____RemoveEntryArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____RemoveEntryArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RemoveEntryArgument_signed_algorithmIdentifier_algorithm._const_tab = ____RemoveEntryArgument_signed_algorithmIdentifier_algorithm_tab
    ___RemoveEntryArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___RemoveEntryArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___RemoveEntryArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____RemoveEntryArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____RemoveEntryArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___RemoveEntryArgument_signed_algorithmIdentifier_parameters._const_tab = ____RemoveEntryArgument_signed_algorithmIdentifier_parameters_tab
    ___RemoveEntryArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___RemoveEntryArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __RemoveEntryArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___RemoveEntryArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___RemoveEntryArgument_signed_algorithmIdentifier_parameters),
        ])
    __RemoveEntryArgument_signed_algorithmIdentifier._ext = []
    __RemoveEntryArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _RemoveEntryArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __RemoveEntryArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __RemoveEntryArgument_signed_algorithmIdentifier),
        (u'encrypted', __RemoveEntryArgument_signed_encrypted),
        ])
    _RemoveEntryArgument_signed._ext = []
    RemoveEntryArgument._cont = ASN1Dict([
        (u'unsigned', _RemoveEntryArgument_unsigned),
        (u'signed', _RemoveEntryArgument_signed),
        ])
    RemoveEntryArgument._ext = None
    
    #-----< RemoveEntryArgumentData >-----#
    RemoveEntryArgumentData = SET(name=u'RemoveEntryArgumentData', mode=MODE_TYPE)
    _RemoveEntryArgumentData_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _RemoveEntryArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _RemoveEntryArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _RemoveEntryArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _RemoveEntryArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _RemoveEntryArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _RemoveEntryArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _RemoveEntryArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _RemoveEntryArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _RemoveEntryArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _RemoveEntryArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _RemoveEntryArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _RemoveEntryArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    RemoveEntryArgumentData._cont = ASN1Dict([
        (u'object', _RemoveEntryArgumentData_object),
        (u'serviceControls', _RemoveEntryArgumentData_serviceControls),
        (u'securityParameters', _RemoveEntryArgumentData_securityParameters),
        (u'requestor', _RemoveEntryArgumentData_requestor),
        (u'operationProgress', _RemoveEntryArgumentData_operationProgress),
        (u'aliasedRDNs', _RemoveEntryArgumentData_aliasedRDNs),
        (u'criticalExtensions', _RemoveEntryArgumentData_criticalExtensions),
        (u'referenceType', _RemoveEntryArgumentData_referenceType),
        (u'entryOnly', _RemoveEntryArgumentData_entryOnly),
        (u'exclusions', _RemoveEntryArgumentData_exclusions),
        (u'nameResolveOnMaster', _RemoveEntryArgumentData_nameResolveOnMaster),
        (u'operationContexts', _RemoveEntryArgumentData_operationContexts),
        (u'familyGrouping', _RemoveEntryArgumentData_familyGrouping),
        ])
    RemoveEntryArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< RemoveEntryResult >-----#
    RemoveEntryResult = CHOICE(name=u'RemoveEntryResult', mode=MODE_TYPE)
    _RemoveEntryResult_null = NULL(name=u'null', mode=MODE_TYPE)
    _RemoveEntryResult_information = CHOICE(name=u'information', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    __RemoveEntryResult_information_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'RemoveEntryResultData')))
    __RemoveEntryResult_information_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___RemoveEntryResult_information_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'RemoveEntryResultData')))
    ___RemoveEntryResult_information_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____RemoveEntryResult_information_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____RemoveEntryResult_information_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____RemoveEntryResult_information_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____RemoveEntryResult_information_signed_algorithmIdentifier_algorithm._const_tab = _____RemoveEntryResult_information_signed_algorithmIdentifier_algorithm_tab
    ____RemoveEntryResult_information_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____RemoveEntryResult_information_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____RemoveEntryResult_information_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____RemoveEntryResult_information_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____RemoveEntryResult_information_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____RemoveEntryResult_information_signed_algorithmIdentifier_parameters._const_tab = _____RemoveEntryResult_information_signed_algorithmIdentifier_parameters_tab
    ____RemoveEntryResult_information_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____RemoveEntryResult_information_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___RemoveEntryResult_information_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____RemoveEntryResult_information_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____RemoveEntryResult_information_signed_algorithmIdentifier_parameters),
        ])
    ___RemoveEntryResult_information_signed_algorithmIdentifier._ext = []
    ___RemoveEntryResult_information_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __RemoveEntryResult_information_signed._cont = ASN1Dict([
        (u'toBeSigned', ___RemoveEntryResult_information_signed_toBeSigned),
        (u'algorithmIdentifier', ___RemoveEntryResult_information_signed_algorithmIdentifier),
        (u'encrypted', ___RemoveEntryResult_information_signed_encrypted),
        ])
    __RemoveEntryResult_information_signed._ext = []
    _RemoveEntryResult_information._cont = ASN1Dict([
        (u'unsigned', __RemoveEntryResult_information_unsigned),
        (u'signed', __RemoveEntryResult_information_signed),
        ])
    _RemoveEntryResult_information._ext = None
    RemoveEntryResult._cont = ASN1Dict([
        (u'null', _RemoveEntryResult_null),
        (u'information', _RemoveEntryResult_information),
        ])
    RemoveEntryResult._ext = []
    
    #-----< RemoveEntryResultData >-----#
    RemoveEntryResultData = SEQ(name=u'RemoveEntryResultData', mode=MODE_TYPE)
    _RemoveEntryResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _RemoveEntryResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _RemoveEntryResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _RemoveEntryResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __RemoveEntryResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___RemoveEntryResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____RemoveEntryResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____RemoveEntryResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____RemoveEntryResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____RemoveEntryResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____RemoveEntryResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____RemoveEntryResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___RemoveEntryResultData_notification__item__type._const_tab = ____RemoveEntryResultData_notification__item__type_tab
    ___RemoveEntryResultData_notification__item__type._const_tab_at = None
    ___RemoveEntryResultData_notification__item__type._const_tab_id = u'id'
    ___RemoveEntryResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____RemoveEntryResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____RemoveEntryResultData_notification__item__values__item_._const_tab = ____RemoveEntryResultData_notification__item__type_tab
    ____RemoveEntryResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____RemoveEntryResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___RemoveEntryResultData_notification__item__values._cont = ____RemoveEntryResultData_notification__item__values__item_
    ___RemoveEntryResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___RemoveEntryResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____RemoveEntryResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____RemoveEntryResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____RemoveEntryResultData_notification__item__valuesWithContext__item__value._const_tab = ____RemoveEntryResultData_notification__item__type_tab
    _____RemoveEntryResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____RemoveEntryResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____RemoveEntryResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______RemoveEntryResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____RemoveEntryResultData_notification__item__valuesWithContext__item__contextList._cont = ______RemoveEntryResultData_notification__item__valuesWithContext__item__contextList__item_
    _____RemoveEntryResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____RemoveEntryResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____RemoveEntryResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____RemoveEntryResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____RemoveEntryResultData_notification__item__valuesWithContext__item_._ext = []
    ___RemoveEntryResultData_notification__item__valuesWithContext._cont = ____RemoveEntryResultData_notification__item__valuesWithContext__item_
    ___RemoveEntryResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __RemoveEntryResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___RemoveEntryResultData_notification__item__type),
        (u'values', ___RemoveEntryResultData_notification__item__values),
        (u'valuesWithContext', ___RemoveEntryResultData_notification__item__valuesWithContext),
        ])
    __RemoveEntryResultData_notification__item_._ext = []
    _RemoveEntryResultData_notification._cont = __RemoveEntryResultData_notification__item_
    RemoveEntryResultData._cont = ASN1Dict([
        (u'securityParameters', _RemoveEntryResultData_securityParameters),
        (u'performer', _RemoveEntryResultData_performer),
        (u'aliasDereferenced', _RemoveEntryResultData_aliasDereferenced),
        (u'notification', _RemoveEntryResultData_notification),
        ])
    RemoveEntryResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< modifyEntry >-----#
    modifyEntry = CLASS(name=u'modifyEntry', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _modifyEntry_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyEntryArgument')))
    _modifyEntry_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyEntryResult')))
    modifyEntry._val = dict([(u'ArgumentType', _modifyEntry_val_ArgumentType), (u'ResultType', _modifyEntry_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_0), (u'errorCode', (u'local', 1))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1), (u'errorCode', (u'local', 2))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_2), (u'errorCode', (u'local', 3))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3), (u'errorCode', (u'local', 4))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4_0), (u'errorCode', (u'local', 6))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_5_0), (u'errorCode', (u'local', 8))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 8))])
    
    #-----< ModifyEntryArgument >-----#
    ModifyEntryArgument = CHOICE(name=u'ModifyEntryArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _ModifyEntryArgument_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyEntryArgumentData')))
    _ModifyEntryArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __ModifyEntryArgument_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyEntryArgumentData')))
    __ModifyEntryArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___ModifyEntryArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____ModifyEntryArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ModifyEntryArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ModifyEntryArgument_signed_algorithmIdentifier_algorithm._const_tab = ____ModifyEntryArgument_signed_algorithmIdentifier_algorithm_tab
    ___ModifyEntryArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___ModifyEntryArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___ModifyEntryArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____ModifyEntryArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ModifyEntryArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ModifyEntryArgument_signed_algorithmIdentifier_parameters._const_tab = ____ModifyEntryArgument_signed_algorithmIdentifier_parameters_tab
    ___ModifyEntryArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___ModifyEntryArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __ModifyEntryArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___ModifyEntryArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___ModifyEntryArgument_signed_algorithmIdentifier_parameters),
        ])
    __ModifyEntryArgument_signed_algorithmIdentifier._ext = []
    __ModifyEntryArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _ModifyEntryArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __ModifyEntryArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __ModifyEntryArgument_signed_algorithmIdentifier),
        (u'encrypted', __ModifyEntryArgument_signed_encrypted),
        ])
    _ModifyEntryArgument_signed._ext = []
    ModifyEntryArgument._cont = ASN1Dict([
        (u'unsigned', _ModifyEntryArgument_unsigned),
        (u'signed', _ModifyEntryArgument_signed),
        ])
    ModifyEntryArgument._ext = None
    
    #-----< ModifyEntryArgumentData >-----#
    ModifyEntryArgumentData = SET(name=u'ModifyEntryArgumentData', mode=MODE_TYPE)
    _ModifyEntryArgumentData_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _ModifyEntryArgumentData_changes = SEQ_OF(name=u'changes', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __ModifyEntryArgumentData_changes__item_ = CHOICE(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'EntryModification')))
    _ModifyEntryArgumentData_changes._cont = __ModifyEntryArgumentData_changes__item_
    _ModifyEntryArgumentData_selection = SET(name=u'selection', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'EntryInformationSelection')), opt=True)
    _ModifyEntryArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _ModifyEntryArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ModifyEntryArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ModifyEntryArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _ModifyEntryArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ModifyEntryArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ModifyEntryArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _ModifyEntryArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _ModifyEntryArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _ModifyEntryArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ModifyEntryArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _ModifyEntryArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    ModifyEntryArgumentData._cont = ASN1Dict([
        (u'object', _ModifyEntryArgumentData_object),
        (u'changes', _ModifyEntryArgumentData_changes),
        (u'selection', _ModifyEntryArgumentData_selection),
        (u'serviceControls', _ModifyEntryArgumentData_serviceControls),
        (u'securityParameters', _ModifyEntryArgumentData_securityParameters),
        (u'requestor', _ModifyEntryArgumentData_requestor),
        (u'operationProgress', _ModifyEntryArgumentData_operationProgress),
        (u'aliasedRDNs', _ModifyEntryArgumentData_aliasedRDNs),
        (u'criticalExtensions', _ModifyEntryArgumentData_criticalExtensions),
        (u'referenceType', _ModifyEntryArgumentData_referenceType),
        (u'entryOnly', _ModifyEntryArgumentData_entryOnly),
        (u'exclusions', _ModifyEntryArgumentData_exclusions),
        (u'nameResolveOnMaster', _ModifyEntryArgumentData_nameResolveOnMaster),
        (u'operationContexts', _ModifyEntryArgumentData_operationContexts),
        (u'familyGrouping', _ModifyEntryArgumentData_familyGrouping),
        ])
    ModifyEntryArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< ModifyEntryResult >-----#
    ModifyEntryResult = CHOICE(name=u'ModifyEntryResult', mode=MODE_TYPE)
    _ModifyEntryResult_null = NULL(name=u'null', mode=MODE_TYPE)
    _ModifyEntryResult_information = CHOICE(name=u'information', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    __ModifyEntryResult_information_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyEntryResultData')))
    __ModifyEntryResult_information_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___ModifyEntryResult_information_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyEntryResultData')))
    ___ModifyEntryResult_information_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____ModifyEntryResult_information_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____ModifyEntryResult_information_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____ModifyEntryResult_information_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____ModifyEntryResult_information_signed_algorithmIdentifier_algorithm._const_tab = _____ModifyEntryResult_information_signed_algorithmIdentifier_algorithm_tab
    ____ModifyEntryResult_information_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____ModifyEntryResult_information_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____ModifyEntryResult_information_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____ModifyEntryResult_information_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____ModifyEntryResult_information_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____ModifyEntryResult_information_signed_algorithmIdentifier_parameters._const_tab = _____ModifyEntryResult_information_signed_algorithmIdentifier_parameters_tab
    ____ModifyEntryResult_information_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____ModifyEntryResult_information_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___ModifyEntryResult_information_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____ModifyEntryResult_information_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____ModifyEntryResult_information_signed_algorithmIdentifier_parameters),
        ])
    ___ModifyEntryResult_information_signed_algorithmIdentifier._ext = []
    ___ModifyEntryResult_information_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __ModifyEntryResult_information_signed._cont = ASN1Dict([
        (u'toBeSigned', ___ModifyEntryResult_information_signed_toBeSigned),
        (u'algorithmIdentifier', ___ModifyEntryResult_information_signed_algorithmIdentifier),
        (u'encrypted', ___ModifyEntryResult_information_signed_encrypted),
        ])
    __ModifyEntryResult_information_signed._ext = []
    _ModifyEntryResult_information._cont = ASN1Dict([
        (u'unsigned', __ModifyEntryResult_information_unsigned),
        (u'signed', __ModifyEntryResult_information_signed),
        ])
    _ModifyEntryResult_information._ext = None
    ModifyEntryResult._cont = ASN1Dict([
        (u'null', _ModifyEntryResult_null),
        (u'information', _ModifyEntryResult_information),
        ])
    ModifyEntryResult._ext = []
    
    #-----< ModifyEntryResultData >-----#
    ModifyEntryResultData = SEQ(name=u'ModifyEntryResultData', mode=MODE_TYPE)
    _ModifyEntryResultData_entry = SEQ(name=u'entry', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'EntryInformation')), opt=True)
    _ModifyEntryResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ModifyEntryResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ModifyEntryResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ModifyEntryResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ModifyEntryResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___ModifyEntryResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____ModifyEntryResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____ModifyEntryResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____ModifyEntryResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____ModifyEntryResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____ModifyEntryResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____ModifyEntryResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___ModifyEntryResultData_notification__item__type._const_tab = ____ModifyEntryResultData_notification__item__type_tab
    ___ModifyEntryResultData_notification__item__type._const_tab_at = None
    ___ModifyEntryResultData_notification__item__type._const_tab_id = u'id'
    ___ModifyEntryResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____ModifyEntryResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____ModifyEntryResultData_notification__item__values__item_._const_tab = ____ModifyEntryResultData_notification__item__type_tab
    ____ModifyEntryResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____ModifyEntryResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___ModifyEntryResultData_notification__item__values._cont = ____ModifyEntryResultData_notification__item__values__item_
    ___ModifyEntryResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___ModifyEntryResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____ModifyEntryResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____ModifyEntryResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____ModifyEntryResultData_notification__item__valuesWithContext__item__value._const_tab = ____ModifyEntryResultData_notification__item__type_tab
    _____ModifyEntryResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____ModifyEntryResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____ModifyEntryResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______ModifyEntryResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____ModifyEntryResultData_notification__item__valuesWithContext__item__contextList._cont = ______ModifyEntryResultData_notification__item__valuesWithContext__item__contextList__item_
    _____ModifyEntryResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____ModifyEntryResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____ModifyEntryResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____ModifyEntryResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____ModifyEntryResultData_notification__item__valuesWithContext__item_._ext = []
    ___ModifyEntryResultData_notification__item__valuesWithContext._cont = ____ModifyEntryResultData_notification__item__valuesWithContext__item_
    ___ModifyEntryResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __ModifyEntryResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___ModifyEntryResultData_notification__item__type),
        (u'values', ___ModifyEntryResultData_notification__item__values),
        (u'valuesWithContext', ___ModifyEntryResultData_notification__item__valuesWithContext),
        ])
    __ModifyEntryResultData_notification__item_._ext = []
    _ModifyEntryResultData_notification._cont = __ModifyEntryResultData_notification__item_
    ModifyEntryResultData._cont = ASN1Dict([
        (u'entry', _ModifyEntryResultData_entry),
        (u'securityParameters', _ModifyEntryResultData_securityParameters),
        (u'performer', _ModifyEntryResultData_performer),
        (u'aliasDereferenced', _ModifyEntryResultData_aliasDereferenced),
        (u'notification', _ModifyEntryResultData_notification),
        ])
    ModifyEntryResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< EntryModification >-----#
    EntryModification = CHOICE(name=u'EntryModification', mode=MODE_TYPE)
    _EntryModification_addAttribute = SEQ(name=u'addAttribute', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    __EntryModification_addAttribute_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ___EntryModification_addAttribute_type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ____EntryModification_addAttribute_type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ____EntryModification_addAttribute_type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ___EntryModification_addAttribute_type_tab._val = ASN1Set(rv=[dict([(u'Type', ____EntryModification_addAttribute_type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ____EntryModification_addAttribute_type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    __EntryModification_addAttribute_type._const_tab = ___EntryModification_addAttribute_type_tab
    __EntryModification_addAttribute_type._const_tab_at = None
    __EntryModification_addAttribute_type._const_tab_id = u'id'
    __EntryModification_addAttribute_values = SET_OF(name=u'values', mode=MODE_TYPE)
    ___EntryModification_addAttribute_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ___EntryModification_addAttribute_values__item_._const_tab = ___EntryModification_addAttribute_type_tab
    ___EntryModification_addAttribute_values__item_._const_tab_at = ('..', '..', u'type')
    ___EntryModification_addAttribute_values__item_._const_tab_id = u'Type'
    __EntryModification_addAttribute_values._cont = ___EntryModification_addAttribute_values__item_
    __EntryModification_addAttribute_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    __EntryModification_addAttribute_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ___EntryModification_addAttribute_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ____EntryModification_addAttribute_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____EntryModification_addAttribute_valuesWithContext__item__value._const_tab = ___EntryModification_addAttribute_type_tab
    ____EntryModification_addAttribute_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ____EntryModification_addAttribute_valuesWithContext__item__value._const_tab_id = u'Type'
    ____EntryModification_addAttribute_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _____EntryModification_addAttribute_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ____EntryModification_addAttribute_valuesWithContext__item__contextList._cont = _____EntryModification_addAttribute_valuesWithContext__item__contextList__item_
    ____EntryModification_addAttribute_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___EntryModification_addAttribute_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ____EntryModification_addAttribute_valuesWithContext__item__value),
        (u'contextList', ____EntryModification_addAttribute_valuesWithContext__item__contextList),
        ])
    ___EntryModification_addAttribute_valuesWithContext__item_._ext = []
    __EntryModification_addAttribute_valuesWithContext._cont = ___EntryModification_addAttribute_valuesWithContext__item_
    __EntryModification_addAttribute_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _EntryModification_addAttribute._cont = ASN1Dict([
        (u'type', __EntryModification_addAttribute_type),
        (u'values', __EntryModification_addAttribute_values),
        (u'valuesWithContext', __EntryModification_addAttribute_valuesWithContext),
        ])
    _EntryModification_addAttribute._ext = []
    _EntryModification_removeAttribute = OID(name=u'removeAttribute', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _EntryModification_addValues = SEQ(name=u'addValues', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    __EntryModification_addValues_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    __EntryModification_addValues_type._const_tab = ___EntryModification_addAttribute_type_tab
    __EntryModification_addValues_type._const_tab_at = None
    __EntryModification_addValues_type._const_tab_id = u'id'
    __EntryModification_addValues_values = SET_OF(name=u'values', mode=MODE_TYPE)
    ___EntryModification_addValues_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ___EntryModification_addValues_values__item_._const_tab = ___EntryModification_addAttribute_type_tab
    ___EntryModification_addValues_values__item_._const_tab_at = ('..', '..', u'type')
    ___EntryModification_addValues_values__item_._const_tab_id = u'Type'
    __EntryModification_addValues_values._cont = ___EntryModification_addValues_values__item_
    __EntryModification_addValues_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    __EntryModification_addValues_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ___EntryModification_addValues_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ____EntryModification_addValues_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____EntryModification_addValues_valuesWithContext__item__value._const_tab = ___EntryModification_addAttribute_type_tab
    ____EntryModification_addValues_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ____EntryModification_addValues_valuesWithContext__item__value._const_tab_id = u'Type'
    ____EntryModification_addValues_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _____EntryModification_addValues_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ____EntryModification_addValues_valuesWithContext__item__contextList._cont = _____EntryModification_addValues_valuesWithContext__item__contextList__item_
    ____EntryModification_addValues_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___EntryModification_addValues_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ____EntryModification_addValues_valuesWithContext__item__value),
        (u'contextList', ____EntryModification_addValues_valuesWithContext__item__contextList),
        ])
    ___EntryModification_addValues_valuesWithContext__item_._ext = []
    __EntryModification_addValues_valuesWithContext._cont = ___EntryModification_addValues_valuesWithContext__item_
    __EntryModification_addValues_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _EntryModification_addValues._cont = ASN1Dict([
        (u'type', __EntryModification_addValues_type),
        (u'values', __EntryModification_addValues_values),
        (u'valuesWithContext', __EntryModification_addValues_valuesWithContext),
        ])
    _EntryModification_addValues._ext = []
    _EntryModification_removeValues = SEQ(name=u'removeValues', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    __EntryModification_removeValues_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    __EntryModification_removeValues_type._const_tab = ___EntryModification_addAttribute_type_tab
    __EntryModification_removeValues_type._const_tab_at = None
    __EntryModification_removeValues_type._const_tab_id = u'id'
    __EntryModification_removeValues_values = SET_OF(name=u'values', mode=MODE_TYPE)
    ___EntryModification_removeValues_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ___EntryModification_removeValues_values__item_._const_tab = ___EntryModification_addAttribute_type_tab
    ___EntryModification_removeValues_values__item_._const_tab_at = ('..', '..', u'type')
    ___EntryModification_removeValues_values__item_._const_tab_id = u'Type'
    __EntryModification_removeValues_values._cont = ___EntryModification_removeValues_values__item_
    __EntryModification_removeValues_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    __EntryModification_removeValues_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ___EntryModification_removeValues_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ____EntryModification_removeValues_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____EntryModification_removeValues_valuesWithContext__item__value._const_tab = ___EntryModification_addAttribute_type_tab
    ____EntryModification_removeValues_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ____EntryModification_removeValues_valuesWithContext__item__value._const_tab_id = u'Type'
    ____EntryModification_removeValues_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _____EntryModification_removeValues_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ____EntryModification_removeValues_valuesWithContext__item__contextList._cont = _____EntryModification_removeValues_valuesWithContext__item__contextList__item_
    ____EntryModification_removeValues_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___EntryModification_removeValues_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ____EntryModification_removeValues_valuesWithContext__item__value),
        (u'contextList', ____EntryModification_removeValues_valuesWithContext__item__contextList),
        ])
    ___EntryModification_removeValues_valuesWithContext__item_._ext = []
    __EntryModification_removeValues_valuesWithContext._cont = ___EntryModification_removeValues_valuesWithContext__item_
    __EntryModification_removeValues_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _EntryModification_removeValues._cont = ASN1Dict([
        (u'type', __EntryModification_removeValues_type),
        (u'values', __EntryModification_removeValues_values),
        (u'valuesWithContext', __EntryModification_removeValues_valuesWithContext),
        ])
    _EntryModification_removeValues._ext = []
    _EntryModification_alterValues = SEQ(name=u'alterValues', mode=MODE_TYPE, tag=(4, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeTypeAndValue')))
    _EntryModification_resetValue = OID(name=u'resetValue', mode=MODE_TYPE, tag=(5, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    _EntryModification_replaceValues = SEQ(name=u'replaceValues', mode=MODE_TYPE, tag=(6, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    __EntryModification_replaceValues_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    __EntryModification_replaceValues_type._const_tab = ___EntryModification_addAttribute_type_tab
    __EntryModification_replaceValues_type._const_tab_at = None
    __EntryModification_replaceValues_type._const_tab_id = u'id'
    __EntryModification_replaceValues_values = SET_OF(name=u'values', mode=MODE_TYPE)
    ___EntryModification_replaceValues_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ___EntryModification_replaceValues_values__item_._const_tab = ___EntryModification_addAttribute_type_tab
    ___EntryModification_replaceValues_values__item_._const_tab_at = ('..', '..', u'type')
    ___EntryModification_replaceValues_values__item_._const_tab_id = u'Type'
    __EntryModification_replaceValues_values._cont = ___EntryModification_replaceValues_values__item_
    __EntryModification_replaceValues_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    __EntryModification_replaceValues_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ___EntryModification_replaceValues_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ____EntryModification_replaceValues_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____EntryModification_replaceValues_valuesWithContext__item__value._const_tab = ___EntryModification_addAttribute_type_tab
    ____EntryModification_replaceValues_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ____EntryModification_replaceValues_valuesWithContext__item__value._const_tab_id = u'Type'
    ____EntryModification_replaceValues_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _____EntryModification_replaceValues_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ____EntryModification_replaceValues_valuesWithContext__item__contextList._cont = _____EntryModification_replaceValues_valuesWithContext__item__contextList__item_
    ____EntryModification_replaceValues_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___EntryModification_replaceValues_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ____EntryModification_replaceValues_valuesWithContext__item__value),
        (u'contextList', ____EntryModification_replaceValues_valuesWithContext__item__contextList),
        ])
    ___EntryModification_replaceValues_valuesWithContext__item_._ext = []
    __EntryModification_replaceValues_valuesWithContext._cont = ___EntryModification_replaceValues_valuesWithContext__item_
    __EntryModification_replaceValues_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _EntryModification_replaceValues._cont = ASN1Dict([
        (u'type', __EntryModification_replaceValues_type),
        (u'values', __EntryModification_replaceValues_values),
        (u'valuesWithContext', __EntryModification_replaceValues_valuesWithContext),
        ])
    _EntryModification_replaceValues._ext = []
    EntryModification._cont = ASN1Dict([
        (u'addAttribute', _EntryModification_addAttribute),
        (u'removeAttribute', _EntryModification_removeAttribute),
        (u'addValues', _EntryModification_addValues),
        (u'removeValues', _EntryModification_removeValues),
        (u'alterValues', _EntryModification_alterValues),
        (u'resetValue', _EntryModification_resetValue),
        (u'replaceValues', _EntryModification_replaceValues),
        ])
    EntryModification._ext = []
    
    #-----< modifyDN >-----#
    modifyDN = CLASS(name=u'modifyDN', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _modifyDN_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyDNArgument')))
    _modifyDN_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyDNResult')))
    modifyDN._val = dict([(u'ArgumentType', _modifyDN_val_ArgumentType), (u'ResultType', _modifyDN_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_2), (u'errorCode', (u'local', 2))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1_0), (u'errorCode', (u'local', 3))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_2_0), (u'errorCode', (u'local', 4))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_3_1), (u'errorCode', (u'local', 6))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_4_1), (u'errorCode', (u'local', 8))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 9))])
    
    #-----< ModifyDNArgument >-----#
    ModifyDNArgument = CHOICE(name=u'ModifyDNArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    _ModifyDNArgument_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyDNArgumentData')))
    _ModifyDNArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __ModifyDNArgument_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyDNArgumentData')))
    __ModifyDNArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___ModifyDNArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____ModifyDNArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ModifyDNArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ModifyDNArgument_signed_algorithmIdentifier_algorithm._const_tab = ____ModifyDNArgument_signed_algorithmIdentifier_algorithm_tab
    ___ModifyDNArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___ModifyDNArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___ModifyDNArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____ModifyDNArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ModifyDNArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ModifyDNArgument_signed_algorithmIdentifier_parameters._const_tab = ____ModifyDNArgument_signed_algorithmIdentifier_parameters_tab
    ___ModifyDNArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___ModifyDNArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __ModifyDNArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___ModifyDNArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___ModifyDNArgument_signed_algorithmIdentifier_parameters),
        ])
    __ModifyDNArgument_signed_algorithmIdentifier._ext = []
    __ModifyDNArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _ModifyDNArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __ModifyDNArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __ModifyDNArgument_signed_algorithmIdentifier),
        (u'encrypted', __ModifyDNArgument_signed_encrypted),
        ])
    _ModifyDNArgument_signed._ext = []
    ModifyDNArgument._cont = ASN1Dict([
        (u'unsigned', _ModifyDNArgument_unsigned),
        (u'signed', _ModifyDNArgument_signed),
        ])
    ModifyDNArgument._ext = None
    
    #-----< ModifyDNArgumentData >-----#
    ModifyDNArgumentData = SET(name=u'ModifyDNArgumentData', mode=MODE_TYPE)
    _ModifyDNArgumentData_object = SEQ_OF(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _ModifyDNArgumentData_newRDN = SET_OF(name=u'newRDN', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'RelativeDistinguishedName')))
    _ModifyDNArgumentData_deleteOldRDN = BOOL(name=u'deleteOldRDN', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ModifyDNArgumentData_newSuperior = SEQ_OF(name=u'newSuperior', mode=MODE_TYPE, tag=(3, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ModifyDNArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _ModifyDNArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ModifyDNArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ModifyDNArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _ModifyDNArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ModifyDNArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _ModifyDNArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _ModifyDNArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _ModifyDNArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _ModifyDNArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ModifyDNArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _ModifyDNArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    ModifyDNArgumentData._cont = ASN1Dict([
        (u'object', _ModifyDNArgumentData_object),
        (u'newRDN', _ModifyDNArgumentData_newRDN),
        (u'deleteOldRDN', _ModifyDNArgumentData_deleteOldRDN),
        (u'newSuperior', _ModifyDNArgumentData_newSuperior),
        (u'serviceControls', _ModifyDNArgumentData_serviceControls),
        (u'securityParameters', _ModifyDNArgumentData_securityParameters),
        (u'requestor', _ModifyDNArgumentData_requestor),
        (u'operationProgress', _ModifyDNArgumentData_operationProgress),
        (u'aliasedRDNs', _ModifyDNArgumentData_aliasedRDNs),
        (u'criticalExtensions', _ModifyDNArgumentData_criticalExtensions),
        (u'referenceType', _ModifyDNArgumentData_referenceType),
        (u'entryOnly', _ModifyDNArgumentData_entryOnly),
        (u'exclusions', _ModifyDNArgumentData_exclusions),
        (u'nameResolveOnMaster', _ModifyDNArgumentData_nameResolveOnMaster),
        (u'operationContexts', _ModifyDNArgumentData_operationContexts),
        (u'familyGrouping', _ModifyDNArgumentData_familyGrouping),
        ])
    ModifyDNArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< ModifyDNResult >-----#
    ModifyDNResult = CHOICE(name=u'ModifyDNResult', mode=MODE_TYPE)
    _ModifyDNResult_null = NULL(name=u'null', mode=MODE_TYPE)
    _ModifyDNResult_information = CHOICE(name=u'information', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    __ModifyDNResult_information_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyDNResultData')))
    __ModifyDNResult_information_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___ModifyDNResult_information_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ModifyDNResultData')))
    ___ModifyDNResult_information_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____ModifyDNResult_information_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____ModifyDNResult_information_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____ModifyDNResult_information_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____ModifyDNResult_information_signed_algorithmIdentifier_algorithm._const_tab = _____ModifyDNResult_information_signed_algorithmIdentifier_algorithm_tab
    ____ModifyDNResult_information_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____ModifyDNResult_information_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____ModifyDNResult_information_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____ModifyDNResult_information_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____ModifyDNResult_information_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____ModifyDNResult_information_signed_algorithmIdentifier_parameters._const_tab = _____ModifyDNResult_information_signed_algorithmIdentifier_parameters_tab
    ____ModifyDNResult_information_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____ModifyDNResult_information_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___ModifyDNResult_information_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____ModifyDNResult_information_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____ModifyDNResult_information_signed_algorithmIdentifier_parameters),
        ])
    ___ModifyDNResult_information_signed_algorithmIdentifier._ext = []
    ___ModifyDNResult_information_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __ModifyDNResult_information_signed._cont = ASN1Dict([
        (u'toBeSigned', ___ModifyDNResult_information_signed_toBeSigned),
        (u'algorithmIdentifier', ___ModifyDNResult_information_signed_algorithmIdentifier),
        (u'encrypted', ___ModifyDNResult_information_signed_encrypted),
        ])
    __ModifyDNResult_information_signed._ext = []
    _ModifyDNResult_information._cont = ASN1Dict([
        (u'unsigned', __ModifyDNResult_information_unsigned),
        (u'signed', __ModifyDNResult_information_signed),
        ])
    _ModifyDNResult_information._ext = None
    ModifyDNResult._cont = ASN1Dict([
        (u'null', _ModifyDNResult_null),
        (u'information', _ModifyDNResult_information),
        ])
    ModifyDNResult._ext = []
    
    #-----< ModifyDNResultData >-----#
    ModifyDNResultData = SEQ(name=u'ModifyDNResultData', mode=MODE_TYPE)
    _ModifyDNResultData_newRDN = SET_OF(name=u'newRDN', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'RelativeDistinguishedName')))
    _ModifyDNResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ModifyDNResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ModifyDNResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ModifyDNResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ModifyDNResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___ModifyDNResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____ModifyDNResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____ModifyDNResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____ModifyDNResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____ModifyDNResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____ModifyDNResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____ModifyDNResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___ModifyDNResultData_notification__item__type._const_tab = ____ModifyDNResultData_notification__item__type_tab
    ___ModifyDNResultData_notification__item__type._const_tab_at = None
    ___ModifyDNResultData_notification__item__type._const_tab_id = u'id'
    ___ModifyDNResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____ModifyDNResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____ModifyDNResultData_notification__item__values__item_._const_tab = ____ModifyDNResultData_notification__item__type_tab
    ____ModifyDNResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____ModifyDNResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___ModifyDNResultData_notification__item__values._cont = ____ModifyDNResultData_notification__item__values__item_
    ___ModifyDNResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___ModifyDNResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____ModifyDNResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____ModifyDNResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____ModifyDNResultData_notification__item__valuesWithContext__item__value._const_tab = ____ModifyDNResultData_notification__item__type_tab
    _____ModifyDNResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____ModifyDNResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____ModifyDNResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______ModifyDNResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____ModifyDNResultData_notification__item__valuesWithContext__item__contextList._cont = ______ModifyDNResultData_notification__item__valuesWithContext__item__contextList__item_
    _____ModifyDNResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____ModifyDNResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____ModifyDNResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____ModifyDNResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____ModifyDNResultData_notification__item__valuesWithContext__item_._ext = []
    ___ModifyDNResultData_notification__item__valuesWithContext._cont = ____ModifyDNResultData_notification__item__valuesWithContext__item_
    ___ModifyDNResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __ModifyDNResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___ModifyDNResultData_notification__item__type),
        (u'values', ___ModifyDNResultData_notification__item__values),
        (u'valuesWithContext', ___ModifyDNResultData_notification__item__valuesWithContext),
        ])
    __ModifyDNResultData_notification__item_._ext = []
    _ModifyDNResultData_notification._cont = __ModifyDNResultData_notification__item_
    ModifyDNResultData._cont = ASN1Dict([
        (u'newRDN', _ModifyDNResultData_newRDN),
        (u'securityParameters', _ModifyDNResultData_securityParameters),
        (u'performer', _ModifyDNResultData_performer),
        (u'aliasDereferenced', _ModifyDNResultData_aliasDereferenced),
        (u'notification', _ModifyDNResultData_notification),
        ])
    ModifyDNResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< changePassword >-----#
    changePassword = CLASS(name=u'changePassword', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _changePassword_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ChangePasswordArgument')))
    _changePassword_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ChangePasswordResult')))
    __OPERATION_Errors_val_ParameterType_0_3 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_0_3_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ___OPERATION_Errors_val_ParameterType_0_3_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_0_3_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_0_3_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_0_3_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_0_3_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_0_3_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_0_3_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_0_3_signed._ext = []
    __OPERATION_Errors_val_ParameterType_0_3._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_0_3_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_0_3_signed),
        ])
    __OPERATION_Errors_val_ParameterType_0_3._ext = None
    __OPERATION_Errors_val_ParameterType_1_1 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_1_1_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'UpdateErrorData')))
    ___OPERATION_Errors_val_ParameterType_1_1_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_1_1_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'UpdateErrorData')))
    ____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_1_1_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_1_1_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_1_1_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_1_1_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_1_1_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_1_1_signed._ext = []
    __OPERATION_Errors_val_ParameterType_1_1._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_1_1_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_1_1_signed),
        ])
    __OPERATION_Errors_val_ParameterType_1_1._ext = None
    changePassword._val = dict([(u'ArgumentType', _changePassword_val_ArgumentType), (u'ResultType', _changePassword_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_3), (u'errorCode', (u'local', 6))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1_1), (u'errorCode', (u'local', 8))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 10))])
    
    #-----< ChangePasswordArgument >-----#
    ChangePasswordArgument = CHOICE(name=u'ChangePasswordArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    _ChangePasswordArgument_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ChangePasswordArgumentData')))
    _ChangePasswordArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __ChangePasswordArgument_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ChangePasswordArgumentData')))
    __ChangePasswordArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___ChangePasswordArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____ChangePasswordArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ChangePasswordArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ChangePasswordArgument_signed_algorithmIdentifier_algorithm._const_tab = ____ChangePasswordArgument_signed_algorithmIdentifier_algorithm_tab
    ___ChangePasswordArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___ChangePasswordArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___ChangePasswordArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____ChangePasswordArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____ChangePasswordArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___ChangePasswordArgument_signed_algorithmIdentifier_parameters._const_tab = ____ChangePasswordArgument_signed_algorithmIdentifier_parameters_tab
    ___ChangePasswordArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___ChangePasswordArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __ChangePasswordArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___ChangePasswordArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___ChangePasswordArgument_signed_algorithmIdentifier_parameters),
        ])
    __ChangePasswordArgument_signed_algorithmIdentifier._ext = []
    __ChangePasswordArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _ChangePasswordArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __ChangePasswordArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __ChangePasswordArgument_signed_algorithmIdentifier),
        (u'encrypted', __ChangePasswordArgument_signed_encrypted),
        ])
    _ChangePasswordArgument_signed._ext = []
    ChangePasswordArgument._cont = ASN1Dict([
        (u'unsigned', _ChangePasswordArgument_unsigned),
        (u'signed', _ChangePasswordArgument_signed),
        ])
    ChangePasswordArgument._ext = None
    
    #-----< ChangePasswordArgumentData >-----#
    ChangePasswordArgumentData = SEQ(name=u'ChangePasswordArgumentData', mode=MODE_TYPE)
    _ChangePasswordArgumentData_object = SEQ_OF(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _ChangePasswordArgumentData_oldPwd = CHOICE(name=u'oldPwd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    _ChangePasswordArgumentData_newPwd = CHOICE(name=u'newPwd', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    ChangePasswordArgumentData._cont = ASN1Dict([
        (u'object', _ChangePasswordArgumentData_object),
        (u'oldPwd', _ChangePasswordArgumentData_oldPwd),
        (u'newPwd', _ChangePasswordArgumentData_newPwd),
        ])
    ChangePasswordArgumentData._ext = []
    
    #-----< ChangePasswordResult >-----#
    ChangePasswordResult = CHOICE(name=u'ChangePasswordResult', mode=MODE_TYPE)
    _ChangePasswordResult_null = NULL(name=u'null', mode=MODE_TYPE)
    _ChangePasswordResult_information = CHOICE(name=u'information', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    __ChangePasswordResult_information_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ChangePasswordResultData')))
    __ChangePasswordResult_information_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___ChangePasswordResult_information_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ChangePasswordResultData')))
    ___ChangePasswordResult_information_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____ChangePasswordResult_information_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____ChangePasswordResult_information_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____ChangePasswordResult_information_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____ChangePasswordResult_information_signed_algorithmIdentifier_algorithm._const_tab = _____ChangePasswordResult_information_signed_algorithmIdentifier_algorithm_tab
    ____ChangePasswordResult_information_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____ChangePasswordResult_information_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____ChangePasswordResult_information_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____ChangePasswordResult_information_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____ChangePasswordResult_information_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____ChangePasswordResult_information_signed_algorithmIdentifier_parameters._const_tab = _____ChangePasswordResult_information_signed_algorithmIdentifier_parameters_tab
    ____ChangePasswordResult_information_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____ChangePasswordResult_information_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___ChangePasswordResult_information_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____ChangePasswordResult_information_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____ChangePasswordResult_information_signed_algorithmIdentifier_parameters),
        ])
    ___ChangePasswordResult_information_signed_algorithmIdentifier._ext = []
    ___ChangePasswordResult_information_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __ChangePasswordResult_information_signed._cont = ASN1Dict([
        (u'toBeSigned', ___ChangePasswordResult_information_signed_toBeSigned),
        (u'algorithmIdentifier', ___ChangePasswordResult_information_signed_algorithmIdentifier),
        (u'encrypted', ___ChangePasswordResult_information_signed_encrypted),
        ])
    __ChangePasswordResult_information_signed._ext = []
    _ChangePasswordResult_information._cont = ASN1Dict([
        (u'unsigned', __ChangePasswordResult_information_unsigned),
        (u'signed', __ChangePasswordResult_information_signed),
        ])
    _ChangePasswordResult_information._ext = None
    ChangePasswordResult._cont = ASN1Dict([
        (u'null', _ChangePasswordResult_null),
        (u'information', _ChangePasswordResult_information),
        ])
    ChangePasswordResult._ext = []
    
    #-----< ChangePasswordResultData >-----#
    ChangePasswordResultData = SEQ(name=u'ChangePasswordResultData', mode=MODE_TYPE)
    _ChangePasswordResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ChangePasswordResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ChangePasswordResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ChangePasswordResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ChangePasswordResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___ChangePasswordResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____ChangePasswordResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____ChangePasswordResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____ChangePasswordResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____ChangePasswordResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____ChangePasswordResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____ChangePasswordResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___ChangePasswordResultData_notification__item__type._const_tab = ____ChangePasswordResultData_notification__item__type_tab
    ___ChangePasswordResultData_notification__item__type._const_tab_at = None
    ___ChangePasswordResultData_notification__item__type._const_tab_id = u'id'
    ___ChangePasswordResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____ChangePasswordResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____ChangePasswordResultData_notification__item__values__item_._const_tab = ____ChangePasswordResultData_notification__item__type_tab
    ____ChangePasswordResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____ChangePasswordResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___ChangePasswordResultData_notification__item__values._cont = ____ChangePasswordResultData_notification__item__values__item_
    ___ChangePasswordResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___ChangePasswordResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____ChangePasswordResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____ChangePasswordResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____ChangePasswordResultData_notification__item__valuesWithContext__item__value._const_tab = ____ChangePasswordResultData_notification__item__type_tab
    _____ChangePasswordResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____ChangePasswordResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____ChangePasswordResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______ChangePasswordResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____ChangePasswordResultData_notification__item__valuesWithContext__item__contextList._cont = ______ChangePasswordResultData_notification__item__valuesWithContext__item__contextList__item_
    _____ChangePasswordResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____ChangePasswordResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____ChangePasswordResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____ChangePasswordResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____ChangePasswordResultData_notification__item__valuesWithContext__item_._ext = []
    ___ChangePasswordResultData_notification__item__valuesWithContext._cont = ____ChangePasswordResultData_notification__item__valuesWithContext__item_
    ___ChangePasswordResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __ChangePasswordResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___ChangePasswordResultData_notification__item__type),
        (u'values', ___ChangePasswordResultData_notification__item__values),
        (u'valuesWithContext', ___ChangePasswordResultData_notification__item__valuesWithContext),
        ])
    __ChangePasswordResultData_notification__item_._ext = []
    _ChangePasswordResultData_notification._cont = __ChangePasswordResultData_notification__item_
    ChangePasswordResultData._cont = ASN1Dict([
        (u'securityParameters', _ChangePasswordResultData_securityParameters),
        (u'performer', _ChangePasswordResultData_performer),
        (u'aliasDereferenced', _ChangePasswordResultData_aliasDereferenced),
        (u'notification', _ChangePasswordResultData_notification),
        ])
    ChangePasswordResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< administerPassword >-----#
    administerPassword = CLASS(name=u'administerPassword', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _administerPassword_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AdministerPasswordArgument')))
    _administerPassword_val_ResultType = CHOICE(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AdministerPasswordResult')))
    administerPassword._val = dict([(u'ArgumentType', _administerPassword_val_ArgumentType), (u'ResultType', _administerPassword_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_3), (u'errorCode', (u'local', 6))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1_1), (u'errorCode', (u'local', 8))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 11))])
    
    #-----< AdministerPasswordArgument >-----#
    AdministerPasswordArgument = CHOICE(name=u'AdministerPasswordArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    _AdministerPasswordArgument_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AdministerPasswordArgumentData')))
    _AdministerPasswordArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __AdministerPasswordArgument_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AdministerPasswordArgumentData')))
    __AdministerPasswordArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___AdministerPasswordArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____AdministerPasswordArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____AdministerPasswordArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AdministerPasswordArgument_signed_algorithmIdentifier_algorithm._const_tab = ____AdministerPasswordArgument_signed_algorithmIdentifier_algorithm_tab
    ___AdministerPasswordArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___AdministerPasswordArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___AdministerPasswordArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____AdministerPasswordArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____AdministerPasswordArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___AdministerPasswordArgument_signed_algorithmIdentifier_parameters._const_tab = ____AdministerPasswordArgument_signed_algorithmIdentifier_parameters_tab
    ___AdministerPasswordArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___AdministerPasswordArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __AdministerPasswordArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___AdministerPasswordArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___AdministerPasswordArgument_signed_algorithmIdentifier_parameters),
        ])
    __AdministerPasswordArgument_signed_algorithmIdentifier._ext = []
    __AdministerPasswordArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _AdministerPasswordArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __AdministerPasswordArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __AdministerPasswordArgument_signed_algorithmIdentifier),
        (u'encrypted', __AdministerPasswordArgument_signed_encrypted),
        ])
    _AdministerPasswordArgument_signed._ext = []
    AdministerPasswordArgument._cont = ASN1Dict([
        (u'unsigned', _AdministerPasswordArgument_unsigned),
        (u'signed', _AdministerPasswordArgument_signed),
        ])
    AdministerPasswordArgument._ext = None
    
    #-----< AdministerPasswordArgumentData >-----#
    AdministerPasswordArgumentData = SEQ(name=u'AdministerPasswordArgumentData', mode=MODE_TYPE)
    _AdministerPasswordArgumentData_object = SEQ_OF(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _AdministerPasswordArgumentData_newPwd = CHOICE(name=u'newPwd', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'UserPwd')))
    AdministerPasswordArgumentData._cont = ASN1Dict([
        (u'object', _AdministerPasswordArgumentData_object),
        (u'newPwd', _AdministerPasswordArgumentData_newPwd),
        ])
    AdministerPasswordArgumentData._ext = []
    
    #-----< AdministerPasswordResult >-----#
    AdministerPasswordResult = CHOICE(name=u'AdministerPasswordResult', mode=MODE_TYPE)
    _AdministerPasswordResult_null = NULL(name=u'null', mode=MODE_TYPE)
    _AdministerPasswordResult_information = CHOICE(name=u'information', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    __AdministerPasswordResult_information_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AdministerPasswordResultData')))
    __AdministerPasswordResult_information_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___AdministerPasswordResult_information_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AdministerPasswordResultData')))
    ___AdministerPasswordResult_information_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____AdministerPasswordResult_information_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____AdministerPasswordResult_information_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____AdministerPasswordResult_information_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____AdministerPasswordResult_information_signed_algorithmIdentifier_algorithm._const_tab = _____AdministerPasswordResult_information_signed_algorithmIdentifier_algorithm_tab
    ____AdministerPasswordResult_information_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____AdministerPasswordResult_information_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____AdministerPasswordResult_information_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____AdministerPasswordResult_information_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____AdministerPasswordResult_information_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____AdministerPasswordResult_information_signed_algorithmIdentifier_parameters._const_tab = _____AdministerPasswordResult_information_signed_algorithmIdentifier_parameters_tab
    ____AdministerPasswordResult_information_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____AdministerPasswordResult_information_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___AdministerPasswordResult_information_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____AdministerPasswordResult_information_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____AdministerPasswordResult_information_signed_algorithmIdentifier_parameters),
        ])
    ___AdministerPasswordResult_information_signed_algorithmIdentifier._ext = []
    ___AdministerPasswordResult_information_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __AdministerPasswordResult_information_signed._cont = ASN1Dict([
        (u'toBeSigned', ___AdministerPasswordResult_information_signed_toBeSigned),
        (u'algorithmIdentifier', ___AdministerPasswordResult_information_signed_algorithmIdentifier),
        (u'encrypted', ___AdministerPasswordResult_information_signed_encrypted),
        ])
    __AdministerPasswordResult_information_signed._ext = []
    _AdministerPasswordResult_information._cont = ASN1Dict([
        (u'unsigned', __AdministerPasswordResult_information_unsigned),
        (u'signed', __AdministerPasswordResult_information_signed),
        ])
    _AdministerPasswordResult_information._ext = None
    AdministerPasswordResult._cont = ASN1Dict([
        (u'null', _AdministerPasswordResult_null),
        (u'information', _AdministerPasswordResult_information),
        ])
    AdministerPasswordResult._ext = []
    
    #-----< AdministerPasswordResultData >-----#
    AdministerPasswordResultData = SEQ(name=u'AdministerPasswordResultData', mode=MODE_TYPE)
    _AdministerPasswordResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _AdministerPasswordResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _AdministerPasswordResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _AdministerPasswordResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __AdministerPasswordResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___AdministerPasswordResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____AdministerPasswordResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____AdministerPasswordResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____AdministerPasswordResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____AdministerPasswordResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____AdministerPasswordResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____AdministerPasswordResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___AdministerPasswordResultData_notification__item__type._const_tab = ____AdministerPasswordResultData_notification__item__type_tab
    ___AdministerPasswordResultData_notification__item__type._const_tab_at = None
    ___AdministerPasswordResultData_notification__item__type._const_tab_id = u'id'
    ___AdministerPasswordResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AdministerPasswordResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____AdministerPasswordResultData_notification__item__values__item_._const_tab = ____AdministerPasswordResultData_notification__item__type_tab
    ____AdministerPasswordResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AdministerPasswordResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___AdministerPasswordResultData_notification__item__values._cont = ____AdministerPasswordResultData_notification__item__values__item_
    ___AdministerPasswordResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___AdministerPasswordResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____AdministerPasswordResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____AdministerPasswordResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____AdministerPasswordResultData_notification__item__valuesWithContext__item__value._const_tab = ____AdministerPasswordResultData_notification__item__type_tab
    _____AdministerPasswordResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____AdministerPasswordResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____AdministerPasswordResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______AdministerPasswordResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____AdministerPasswordResultData_notification__item__valuesWithContext__item__contextList._cont = ______AdministerPasswordResultData_notification__item__valuesWithContext__item__contextList__item_
    _____AdministerPasswordResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____AdministerPasswordResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____AdministerPasswordResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____AdministerPasswordResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____AdministerPasswordResultData_notification__item__valuesWithContext__item_._ext = []
    ___AdministerPasswordResultData_notification__item__valuesWithContext._cont = ____AdministerPasswordResultData_notification__item__valuesWithContext__item_
    ___AdministerPasswordResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AdministerPasswordResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___AdministerPasswordResultData_notification__item__type),
        (u'values', ___AdministerPasswordResultData_notification__item__values),
        (u'valuesWithContext', ___AdministerPasswordResultData_notification__item__valuesWithContext),
        ])
    __AdministerPasswordResultData_notification__item_._ext = []
    _AdministerPasswordResultData_notification._cont = __AdministerPasswordResultData_notification__item_
    AdministerPasswordResultData._cont = ASN1Dict([
        (u'securityParameters', _AdministerPasswordResultData_securityParameters),
        (u'performer', _AdministerPasswordResultData_performer),
        (u'aliasDereferenced', _AdministerPasswordResultData_aliasDereferenced),
        (u'notification', _AdministerPasswordResultData_notification),
        ])
    AdministerPasswordResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< ldapTransport >-----#
    ldapTransport = CLASS(name=u'ldapTransport', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _ldapTransport_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LdapArgument')))
    _ldapTransport_val_ResultType = SEQ_OF(name=u'ResultType', mode=MODE_TYPE)
    __ldapTransport_val_ResultType__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('Lightweight-Directory-Access-Protocol-V3', 'LDAPMessage')))
    _ldapTransport_val_ResultType._cont = __ldapTransport_val_ResultType__item_
    __OPERATION_Errors_val_ParameterType_1_2 = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    ___OPERATION_Errors_val_ParameterType_1_2_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedData')))
    ___OPERATION_Errors_val_ParameterType_1_2_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ____OPERATION_Errors_val_ParameterType_1_2_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedData')))
    ____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    _____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ______OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_algorithm._const_tab = ______OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_algorithm_tab
    _____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_algorithm._const_tab_at = None
    _____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    _____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ______OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ______OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    _____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_parameters._const_tab = ______OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_parameters_tab
    _____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    _____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', _____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_algorithm),
        (u'parameters', _____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier_parameters),
        ])
    ____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier._ext = []
    ____OPERATION_Errors_val_ParameterType_1_2_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    ___OPERATION_Errors_val_ParameterType_1_2_signed._cont = ASN1Dict([
        (u'toBeSigned', ____OPERATION_Errors_val_ParameterType_1_2_signed_toBeSigned),
        (u'algorithmIdentifier', ____OPERATION_Errors_val_ParameterType_1_2_signed_algorithmIdentifier),
        (u'encrypted', ____OPERATION_Errors_val_ParameterType_1_2_signed_encrypted),
        ])
    ___OPERATION_Errors_val_ParameterType_1_2_signed._ext = []
    __OPERATION_Errors_val_ParameterType_1_2._cont = ASN1Dict([
        (u'unsigned', ___OPERATION_Errors_val_ParameterType_1_2_unsigned),
        (u'signed', ___OPERATION_Errors_val_ParameterType_1_2_signed),
        ])
    __OPERATION_Errors_val_ParameterType_1_2._ext = None
    ldapTransport._val = dict([(u'ArgumentType', _ldapTransport_val_ArgumentType), (u'ResultType', _ldapTransport_val_ResultType), (u'Errors', ASN1Set(rv=[dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_0_1), (u'errorCode', (u'local', 7))]), dict([(u'ParameterType', __OPERATION_Errors_val_ParameterType_1_2), (u'errorCode', (u'local', 5))])], rr=[], ev=None, er=[])), (u'operationCode', (u'local', 12))])
    
    #-----< LdapArgument >-----#
    LdapArgument = CHOICE(name=u'LdapArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    _LdapArgument_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LdapArgumentData')))
    _LdapArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __LdapArgument_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LdapArgumentData')))
    __LdapArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___LdapArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____LdapArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____LdapArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___LdapArgument_signed_algorithmIdentifier_algorithm._const_tab = ____LdapArgument_signed_algorithmIdentifier_algorithm_tab
    ___LdapArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___LdapArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___LdapArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____LdapArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____LdapArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___LdapArgument_signed_algorithmIdentifier_parameters._const_tab = ____LdapArgument_signed_algorithmIdentifier_parameters_tab
    ___LdapArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___LdapArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __LdapArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___LdapArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___LdapArgument_signed_algorithmIdentifier_parameters),
        ])
    __LdapArgument_signed_algorithmIdentifier._ext = []
    __LdapArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _LdapArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __LdapArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __LdapArgument_signed_algorithmIdentifier),
        (u'encrypted', __LdapArgument_signed_encrypted),
        ])
    _LdapArgument_signed._ext = []
    LdapArgument._cont = ASN1Dict([
        (u'unsigned', _LdapArgument_unsigned),
        (u'signed', _LdapArgument_signed),
        ])
    LdapArgument._ext = None
    
    #-----< LdapArgumentData >-----#
    LdapArgumentData = SEQ(name=u'LdapArgumentData', mode=MODE_TYPE)
    _LdapArgumentData_object = SEQ_OF(name=u'object', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _LdapArgumentData_ldapMessage = SEQ(name=u'ldapMessage', mode=MODE_TYPE, typeref=ASN1RefType(('Lightweight-Directory-Access-Protocol-V3', 'LDAPMessage')))
    _LdapArgumentData_linkId = INT(name=u'linkId', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LinkId')), opt=True)
    _LdapArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _LdapArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _LdapArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _LdapArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _LdapArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _LdapArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _LdapArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _LdapArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _LdapArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _LdapArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _LdapArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _LdapArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    LdapArgumentData._cont = ASN1Dict([
        (u'object', _LdapArgumentData_object),
        (u'ldapMessage', _LdapArgumentData_ldapMessage),
        (u'linkId', _LdapArgumentData_linkId),
        (u'serviceControls', _LdapArgumentData_serviceControls),
        (u'securityParameters', _LdapArgumentData_securityParameters),
        (u'requestor', _LdapArgumentData_requestor),
        (u'operationProgress', _LdapArgumentData_operationProgress),
        (u'aliasedRDNs', _LdapArgumentData_aliasedRDNs),
        (u'criticalExtensions', _LdapArgumentData_criticalExtensions),
        (u'referenceType', _LdapArgumentData_referenceType),
        (u'entryOnly', _LdapArgumentData_entryOnly),
        (u'exclusions', _LdapArgumentData_exclusions),
        (u'nameResolveOnMaster', _LdapArgumentData_nameResolveOnMaster),
        (u'operationContexts', _LdapArgumentData_operationContexts),
        (u'familyGrouping', _LdapArgumentData_familyGrouping),
        ])
    LdapArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< LinkId >-----#
    LinkId = INT(name=u'LinkId', mode=MODE_TYPE)
    
    #-----< LdapResult >-----#
    LdapResult = CHOICE(name=u'LdapResult', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    _LdapResult_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LdapResultData')))
    _LdapResult_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __LdapResult_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LdapResultData')))
    __LdapResult_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___LdapResult_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____LdapResult_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____LdapResult_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___LdapResult_signed_algorithmIdentifier_algorithm._const_tab = ____LdapResult_signed_algorithmIdentifier_algorithm_tab
    ___LdapResult_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___LdapResult_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___LdapResult_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____LdapResult_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____LdapResult_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___LdapResult_signed_algorithmIdentifier_parameters._const_tab = ____LdapResult_signed_algorithmIdentifier_parameters_tab
    ___LdapResult_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___LdapResult_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __LdapResult_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___LdapResult_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___LdapResult_signed_algorithmIdentifier_parameters),
        ])
    __LdapResult_signed_algorithmIdentifier._ext = []
    __LdapResult_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _LdapResult_signed._cont = ASN1Dict([
        (u'toBeSigned', __LdapResult_signed_toBeSigned),
        (u'algorithmIdentifier', __LdapResult_signed_algorithmIdentifier),
        (u'encrypted', __LdapResult_signed_encrypted),
        ])
    _LdapResult_signed._ext = []
    LdapResult._cont = ASN1Dict([
        (u'unsigned', _LdapResult_unsigned),
        (u'signed', _LdapResult_signed),
        ])
    LdapResult._ext = None
    
    #-----< LdapResultData >-----#
    LdapResultData = SEQ(name=u'LdapResultData', mode=MODE_TYPE)
    _LdapResultData_ldapMessages = SEQ_OF(name=u'ldapMessages', mode=MODE_TYPE, opt=True)
    __LdapResultData_ldapMessages__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('Lightweight-Directory-Access-Protocol-V3', 'LDAPMessage')))
    _LdapResultData_ldapMessages._cont = __LdapResultData_ldapMessages__item_
    _LdapResultData_ldapMessages._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _LdapResultData_returnToClient = BOOL(name=u'returnToClient', mode=MODE_TYPE, default=False)
    _LdapResultData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _LdapResultData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _LdapResultData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _LdapResultData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __LdapResultData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___LdapResultData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____LdapResultData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____LdapResultData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____LdapResultData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____LdapResultData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____LdapResultData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____LdapResultData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___LdapResultData_notification__item__type._const_tab = ____LdapResultData_notification__item__type_tab
    ___LdapResultData_notification__item__type._const_tab_at = None
    ___LdapResultData_notification__item__type._const_tab_id = u'id'
    ___LdapResultData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____LdapResultData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____LdapResultData_notification__item__values__item_._const_tab = ____LdapResultData_notification__item__type_tab
    ____LdapResultData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____LdapResultData_notification__item__values__item_._const_tab_id = u'Type'
    ___LdapResultData_notification__item__values._cont = ____LdapResultData_notification__item__values__item_
    ___LdapResultData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___LdapResultData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____LdapResultData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____LdapResultData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____LdapResultData_notification__item__valuesWithContext__item__value._const_tab = ____LdapResultData_notification__item__type_tab
    _____LdapResultData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____LdapResultData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____LdapResultData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______LdapResultData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____LdapResultData_notification__item__valuesWithContext__item__contextList._cont = ______LdapResultData_notification__item__valuesWithContext__item__contextList__item_
    _____LdapResultData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____LdapResultData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____LdapResultData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____LdapResultData_notification__item__valuesWithContext__item__contextList),
        ])
    ____LdapResultData_notification__item__valuesWithContext__item_._ext = []
    ___LdapResultData_notification__item__valuesWithContext._cont = ____LdapResultData_notification__item__valuesWithContext__item_
    ___LdapResultData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __LdapResultData_notification__item_._cont = ASN1Dict([
        (u'type', ___LdapResultData_notification__item__type),
        (u'values', ___LdapResultData_notification__item__values),
        (u'valuesWithContext', ___LdapResultData_notification__item__valuesWithContext),
        ])
    __LdapResultData_notification__item_._ext = []
    _LdapResultData_notification._cont = __LdapResultData_notification__item_
    LdapResultData._cont = ASN1Dict([
        (u'ldapMessages', _LdapResultData_ldapMessages),
        (u'returnToClient', _LdapResultData_returnToClient),
        (u'securityParameters', _LdapResultData_securityParameters),
        (u'performer', _LdapResultData_performer),
        (u'aliasDereferenced', _LdapResultData_aliasDereferenced),
        (u'notification', _LdapResultData_notification),
        ])
    LdapResultData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< linkedLDAP >-----#
    linkedLDAP = CLASS(name=u'linkedLDAP', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'OPERATION')))
    _linkedLDAP_val_ArgumentType = CHOICE(name=u'ArgumentType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LinkedArgument')))
    _linkedLDAP_val_ResultType = NULL(name=u'ResultType', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LinkedResult')))
    linkedLDAP._val = dict([(u'ArgumentType', _linkedLDAP_val_ArgumentType), (u'ResultType', _linkedLDAP_val_ResultType), (u'operationCode', (u'local', 13))])
    
    #-----< LinkedArgument >-----#
    LinkedArgument = CHOICE(name=u'LinkedArgument', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED-SEQ')))
    _LinkedArgument_unsigned = SEQ(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LinkedArgumentData')))
    _LinkedArgument_signed = SEQ(name=u'signed', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_IMPLICIT), typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    __LinkedArgument_signed_toBeSigned = SEQ(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LinkedArgumentData')))
    __LinkedArgument_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___LinkedArgument_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____LinkedArgument_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____LinkedArgument_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___LinkedArgument_signed_algorithmIdentifier_algorithm._const_tab = ____LinkedArgument_signed_algorithmIdentifier_algorithm_tab
    ___LinkedArgument_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ___LinkedArgument_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ___LinkedArgument_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____LinkedArgument_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____LinkedArgument_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___LinkedArgument_signed_algorithmIdentifier_parameters._const_tab = ____LinkedArgument_signed_algorithmIdentifier_parameters_tab
    ___LinkedArgument_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ___LinkedArgument_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    __LinkedArgument_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ___LinkedArgument_signed_algorithmIdentifier_algorithm),
        (u'parameters', ___LinkedArgument_signed_algorithmIdentifier_parameters),
        ])
    __LinkedArgument_signed_algorithmIdentifier._ext = []
    __LinkedArgument_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    _LinkedArgument_signed._cont = ASN1Dict([
        (u'toBeSigned', __LinkedArgument_signed_toBeSigned),
        (u'algorithmIdentifier', __LinkedArgument_signed_algorithmIdentifier),
        (u'encrypted', __LinkedArgument_signed_encrypted),
        ])
    _LinkedArgument_signed._ext = []
    LinkedArgument._cont = ASN1Dict([
        (u'unsigned', _LinkedArgument_unsigned),
        (u'signed', _LinkedArgument_signed),
        ])
    LinkedArgument._ext = None
    
    #-----< LinkedArgumentData >-----#
    LinkedArgumentData = SEQ(name=u'LinkedArgumentData', mode=MODE_TYPE)
    _LinkedArgumentData_object = SEQ_OF(name=u'object', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _LinkedArgumentData_ldapMessage = SEQ(name=u'ldapMessage', mode=MODE_TYPE, typeref=ASN1RefType(('Lightweight-Directory-Access-Protocol-V3', 'LDAPMessage')))
    _LinkedArgumentData_linkId = INT(name=u'linkId', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'LinkId')))
    _LinkedArgumentData_returnToClient = BOOL(name=u'returnToClient', mode=MODE_TYPE, default=False)
    _LinkedArgumentData_serviceControls = SET(name=u'serviceControls', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceControls')), default=dict([]))
    _LinkedArgumentData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _LinkedArgumentData_requestor = SEQ_OF(name=u'requestor', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _LinkedArgumentData_operationProgress = SET(name=u'operationProgress', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'OperationProgress')), default=dict([(u'nameResolutionPhase', u'notStarted')]))
    _LinkedArgumentData_aliasedRDNs = INT(name=u'aliasedRDNs', mode=MODE_TYPE, tag=(26, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _LinkedArgumentData_criticalExtensions = BIT_STR(name=u'criticalExtensions', mode=MODE_TYPE, tag=(25, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    _LinkedArgumentData_referenceType = ENUM(name=u'referenceType', mode=MODE_TYPE, tag=(24, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ReferenceType')), opt=True)
    _LinkedArgumentData_entryOnly = BOOL(name=u'entryOnly', mode=MODE_TYPE, tag=(23, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=True)
    _LinkedArgumentData_exclusions = SET_OF(name=u'exclusions', mode=MODE_TYPE, tag=(22, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'Exclusions')), opt=True)
    _LinkedArgumentData_nameResolveOnMaster = BOOL(name=u'nameResolveOnMaster', mode=MODE_TYPE, tag=(21, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _LinkedArgumentData_operationContexts = CHOICE(name=u'operationContexts', mode=MODE_TYPE, tag=(20, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ContextSelection')), opt=True)
    _LinkedArgumentData_familyGrouping = ENUM(name=u'familyGrouping', mode=MODE_TYPE, tag=(19, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'FamilyGrouping')), default=u'entryOnly')
    LinkedArgumentData._cont = ASN1Dict([
        (u'object', _LinkedArgumentData_object),
        (u'ldapMessage', _LinkedArgumentData_ldapMessage),
        (u'linkId', _LinkedArgumentData_linkId),
        (u'returnToClient', _LinkedArgumentData_returnToClient),
        (u'serviceControls', _LinkedArgumentData_serviceControls),
        (u'securityParameters', _LinkedArgumentData_securityParameters),
        (u'requestor', _LinkedArgumentData_requestor),
        (u'operationProgress', _LinkedArgumentData_operationProgress),
        (u'aliasedRDNs', _LinkedArgumentData_aliasedRDNs),
        (u'criticalExtensions', _LinkedArgumentData_criticalExtensions),
        (u'referenceType', _LinkedArgumentData_referenceType),
        (u'entryOnly', _LinkedArgumentData_entryOnly),
        (u'exclusions', _LinkedArgumentData_exclusions),
        (u'nameResolveOnMaster', _LinkedArgumentData_nameResolveOnMaster),
        (u'operationContexts', _LinkedArgumentData_operationContexts),
        (u'familyGrouping', _LinkedArgumentData_familyGrouping),
        ])
    LinkedArgumentData._ext = [u'serviceControls', u'securityParameters', u'requestor', u'operationProgress', u'aliasedRDNs', u'criticalExtensions', u'referenceType', u'entryOnly', u'exclusions', u'nameResolveOnMaster', u'operationContexts', u'familyGrouping']
    
    #-----< LinkedResult >-----#
    LinkedResult = NULL(name=u'LinkedResult', mode=MODE_TYPE)
    
    #-----< abandoned >-----#
    abandoned = CLASS(name=u'abandoned', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')))
    _abandoned_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    __abandoned_val_ParameterType_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedData')))
    __abandoned_val_ParameterType_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___abandoned_val_ParameterType_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedData')))
    ___abandoned_val_ParameterType_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____abandoned_val_ParameterType_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____abandoned_val_ParameterType_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____abandoned_val_ParameterType_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____abandoned_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab = _____abandoned_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____abandoned_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____abandoned_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____abandoned_val_ParameterType_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____abandoned_val_ParameterType_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____abandoned_val_ParameterType_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____abandoned_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab = _____abandoned_val_ParameterType_signed_algorithmIdentifier_parameters_tab
    ____abandoned_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____abandoned_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___abandoned_val_ParameterType_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____abandoned_val_ParameterType_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____abandoned_val_ParameterType_signed_algorithmIdentifier_parameters),
        ])
    ___abandoned_val_ParameterType_signed_algorithmIdentifier._ext = []
    ___abandoned_val_ParameterType_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __abandoned_val_ParameterType_signed._cont = ASN1Dict([
        (u'toBeSigned', ___abandoned_val_ParameterType_signed_toBeSigned),
        (u'algorithmIdentifier', ___abandoned_val_ParameterType_signed_algorithmIdentifier),
        (u'encrypted', ___abandoned_val_ParameterType_signed_encrypted),
        ])
    __abandoned_val_ParameterType_signed._ext = []
    _abandoned_val_ParameterType._cont = ASN1Dict([
        (u'unsigned', __abandoned_val_ParameterType_unsigned),
        (u'signed', __abandoned_val_ParameterType_signed),
        ])
    _abandoned_val_ParameterType._ext = None
    abandoned._val = dict([(u'ParameterType', _abandoned_val_ParameterType), (u'errorCode', (u'local', 5))])
    
    #-----< AbandonedData >-----#
    AbandonedData = SET(name=u'AbandonedData', mode=MODE_TYPE)
    _AbandonedData_problem = ENUM(name=u'problem', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonedProblem')), opt=True)
    _AbandonedData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _AbandonedData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _AbandonedData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _AbandonedData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __AbandonedData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___AbandonedData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____AbandonedData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____AbandonedData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____AbandonedData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____AbandonedData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____AbandonedData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____AbandonedData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___AbandonedData_notification__item__type._const_tab = ____AbandonedData_notification__item__type_tab
    ___AbandonedData_notification__item__type._const_tab_at = None
    ___AbandonedData_notification__item__type._const_tab_id = u'id'
    ___AbandonedData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AbandonedData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____AbandonedData_notification__item__values__item_._const_tab = ____AbandonedData_notification__item__type_tab
    ____AbandonedData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AbandonedData_notification__item__values__item_._const_tab_id = u'Type'
    ___AbandonedData_notification__item__values._cont = ____AbandonedData_notification__item__values__item_
    ___AbandonedData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___AbandonedData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____AbandonedData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____AbandonedData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____AbandonedData_notification__item__valuesWithContext__item__value._const_tab = ____AbandonedData_notification__item__type_tab
    _____AbandonedData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____AbandonedData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____AbandonedData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______AbandonedData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____AbandonedData_notification__item__valuesWithContext__item__contextList._cont = ______AbandonedData_notification__item__valuesWithContext__item__contextList__item_
    _____AbandonedData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____AbandonedData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____AbandonedData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____AbandonedData_notification__item__valuesWithContext__item__contextList),
        ])
    ____AbandonedData_notification__item__valuesWithContext__item_._ext = []
    ___AbandonedData_notification__item__valuesWithContext._cont = ____AbandonedData_notification__item__valuesWithContext__item_
    ___AbandonedData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AbandonedData_notification__item_._cont = ASN1Dict([
        (u'type', ___AbandonedData_notification__item__type),
        (u'values', ___AbandonedData_notification__item__values),
        (u'valuesWithContext', ___AbandonedData_notification__item__valuesWithContext),
        ])
    __AbandonedData_notification__item_._ext = []
    _AbandonedData_notification._cont = __AbandonedData_notification__item_
    AbandonedData._cont = ASN1Dict([
        (u'problem', _AbandonedData_problem),
        (u'securityParameters', _AbandonedData_securityParameters),
        (u'performer', _AbandonedData_performer),
        (u'aliasDereferenced', _AbandonedData_aliasDereferenced),
        (u'notification', _AbandonedData_notification),
        ])
    AbandonedData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< AbandonedProblem >-----#
    AbandonedProblem = ENUM(name=u'AbandonedProblem', mode=MODE_TYPE)
    AbandonedProblem._cont = ASN1Dict([(u'pagingAbandoned', 0)])
    AbandonedProblem._ext = None
    
    #-----< abandonFailed >-----#
    abandonFailed = CLASS(name=u'abandonFailed', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')))
    _abandonFailed_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    __abandonFailed_val_ParameterType_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonFailedData')))
    __abandonFailed_val_ParameterType_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___abandonFailed_val_ParameterType_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonFailedData')))
    ___abandonFailed_val_ParameterType_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____abandonFailed_val_ParameterType_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____abandonFailed_val_ParameterType_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____abandonFailed_val_ParameterType_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____abandonFailed_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab = _____abandonFailed_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____abandonFailed_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____abandonFailed_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____abandonFailed_val_ParameterType_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____abandonFailed_val_ParameterType_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____abandonFailed_val_ParameterType_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____abandonFailed_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab = _____abandonFailed_val_ParameterType_signed_algorithmIdentifier_parameters_tab
    ____abandonFailed_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____abandonFailed_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___abandonFailed_val_ParameterType_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____abandonFailed_val_ParameterType_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____abandonFailed_val_ParameterType_signed_algorithmIdentifier_parameters),
        ])
    ___abandonFailed_val_ParameterType_signed_algorithmIdentifier._ext = []
    ___abandonFailed_val_ParameterType_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __abandonFailed_val_ParameterType_signed._cont = ASN1Dict([
        (u'toBeSigned', ___abandonFailed_val_ParameterType_signed_toBeSigned),
        (u'algorithmIdentifier', ___abandonFailed_val_ParameterType_signed_algorithmIdentifier),
        (u'encrypted', ___abandonFailed_val_ParameterType_signed_encrypted),
        ])
    __abandonFailed_val_ParameterType_signed._ext = []
    _abandonFailed_val_ParameterType._cont = ASN1Dict([
        (u'unsigned', __abandonFailed_val_ParameterType_unsigned),
        (u'signed', __abandonFailed_val_ParameterType_signed),
        ])
    _abandonFailed_val_ParameterType._ext = None
    abandonFailed._val = dict([(u'ParameterType', _abandonFailed_val_ParameterType), (u'errorCode', (u'local', 7))])
    
    #-----< AbandonFailedData >-----#
    AbandonFailedData = SET(name=u'AbandonFailedData', mode=MODE_TYPE)
    _AbandonFailedData_problem = INT(name=u'problem', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'AbandonProblem')))
    _AbandonFailedData_operation = CHOICE(name=u'operation', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('CommonProtocolSpecification', 'InvokeId')))
    _AbandonFailedData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _AbandonFailedData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _AbandonFailedData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _AbandonFailedData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __AbandonFailedData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___AbandonFailedData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____AbandonFailedData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____AbandonFailedData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____AbandonFailedData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____AbandonFailedData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____AbandonFailedData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____AbandonFailedData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___AbandonFailedData_notification__item__type._const_tab = ____AbandonFailedData_notification__item__type_tab
    ___AbandonFailedData_notification__item__type._const_tab_at = None
    ___AbandonFailedData_notification__item__type._const_tab_id = u'id'
    ___AbandonFailedData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AbandonFailedData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____AbandonFailedData_notification__item__values__item_._const_tab = ____AbandonFailedData_notification__item__type_tab
    ____AbandonFailedData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AbandonFailedData_notification__item__values__item_._const_tab_id = u'Type'
    ___AbandonFailedData_notification__item__values._cont = ____AbandonFailedData_notification__item__values__item_
    ___AbandonFailedData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___AbandonFailedData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____AbandonFailedData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____AbandonFailedData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____AbandonFailedData_notification__item__valuesWithContext__item__value._const_tab = ____AbandonFailedData_notification__item__type_tab
    _____AbandonFailedData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____AbandonFailedData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____AbandonFailedData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______AbandonFailedData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____AbandonFailedData_notification__item__valuesWithContext__item__contextList._cont = ______AbandonFailedData_notification__item__valuesWithContext__item__contextList__item_
    _____AbandonFailedData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____AbandonFailedData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____AbandonFailedData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____AbandonFailedData_notification__item__valuesWithContext__item__contextList),
        ])
    ____AbandonFailedData_notification__item__valuesWithContext__item_._ext = []
    ___AbandonFailedData_notification__item__valuesWithContext._cont = ____AbandonFailedData_notification__item__valuesWithContext__item_
    ___AbandonFailedData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AbandonFailedData_notification__item_._cont = ASN1Dict([
        (u'type', ___AbandonFailedData_notification__item__type),
        (u'values', ___AbandonFailedData_notification__item__values),
        (u'valuesWithContext', ___AbandonFailedData_notification__item__valuesWithContext),
        ])
    __AbandonFailedData_notification__item_._ext = []
    _AbandonFailedData_notification._cont = __AbandonFailedData_notification__item_
    AbandonFailedData._cont = ASN1Dict([
        (u'problem', _AbandonFailedData_problem),
        (u'operation', _AbandonFailedData_operation),
        (u'securityParameters', _AbandonFailedData_securityParameters),
        (u'performer', _AbandonFailedData_performer),
        (u'aliasDereferenced', _AbandonFailedData_aliasDereferenced),
        (u'notification', _AbandonFailedData_notification),
        ])
    AbandonFailedData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< AbandonProblem >-----#
    AbandonProblem = INT(name=u'AbandonProblem', mode=MODE_TYPE)
    AbandonProblem._cont = ASN1Dict([(u'noSuchOperation', 1), (u'tooLate', 2), (u'cannotAbandon', 3)])
    
    #-----< attributeError >-----#
    attributeError = CLASS(name=u'attributeError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')))
    _attributeError_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    __attributeError_val_ParameterType_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AttributeErrorData')))
    __attributeError_val_ParameterType_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___attributeError_val_ParameterType_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'AttributeErrorData')))
    ___attributeError_val_ParameterType_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____attributeError_val_ParameterType_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____attributeError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____attributeError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____attributeError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab = _____attributeError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____attributeError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____attributeError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____attributeError_val_ParameterType_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____attributeError_val_ParameterType_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____attributeError_val_ParameterType_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____attributeError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab = _____attributeError_val_ParameterType_signed_algorithmIdentifier_parameters_tab
    ____attributeError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____attributeError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___attributeError_val_ParameterType_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____attributeError_val_ParameterType_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____attributeError_val_ParameterType_signed_algorithmIdentifier_parameters),
        ])
    ___attributeError_val_ParameterType_signed_algorithmIdentifier._ext = []
    ___attributeError_val_ParameterType_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __attributeError_val_ParameterType_signed._cont = ASN1Dict([
        (u'toBeSigned', ___attributeError_val_ParameterType_signed_toBeSigned),
        (u'algorithmIdentifier', ___attributeError_val_ParameterType_signed_algorithmIdentifier),
        (u'encrypted', ___attributeError_val_ParameterType_signed_encrypted),
        ])
    __attributeError_val_ParameterType_signed._ext = []
    _attributeError_val_ParameterType._cont = ASN1Dict([
        (u'unsigned', __attributeError_val_ParameterType_unsigned),
        (u'signed', __attributeError_val_ParameterType_signed),
        ])
    _attributeError_val_ParameterType._ext = None
    attributeError._val = dict([(u'ParameterType', _attributeError_val_ParameterType), (u'errorCode', (u'local', 1))])
    
    #-----< AttributeErrorData >-----#
    AttributeErrorData = SET(name=u'AttributeErrorData', mode=MODE_TYPE)
    _AttributeErrorData_object = CHOICE(name=u'object', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _AttributeErrorData_problems = SET_OF(name=u'problems', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT))
    __AttributeErrorData_problems__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ___AttributeErrorData_problems__item__problem = INT(name=u'problem', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'AttributeProblem')))
    ___AttributeErrorData_problems__item__type = OID(name=u'type', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ___AttributeErrorData_problems__item__value = OPEN(name=u'value', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'AttributeValue')), opt=True)
    __AttributeErrorData_problems__item_._cont = ASN1Dict([
        (u'problem', ___AttributeErrorData_problems__item__problem),
        (u'type', ___AttributeErrorData_problems__item__type),
        (u'value', ___AttributeErrorData_problems__item__value),
        ])
    __AttributeErrorData_problems__item_._ext = []
    _AttributeErrorData_problems._cont = __AttributeErrorData_problems__item_
    _AttributeErrorData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _AttributeErrorData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _AttributeErrorData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _AttributeErrorData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __AttributeErrorData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___AttributeErrorData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____AttributeErrorData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____AttributeErrorData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____AttributeErrorData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____AttributeErrorData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____AttributeErrorData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____AttributeErrorData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___AttributeErrorData_notification__item__type._const_tab = ____AttributeErrorData_notification__item__type_tab
    ___AttributeErrorData_notification__item__type._const_tab_at = None
    ___AttributeErrorData_notification__item__type._const_tab_id = u'id'
    ___AttributeErrorData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____AttributeErrorData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____AttributeErrorData_notification__item__values__item_._const_tab = ____AttributeErrorData_notification__item__type_tab
    ____AttributeErrorData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____AttributeErrorData_notification__item__values__item_._const_tab_id = u'Type'
    ___AttributeErrorData_notification__item__values._cont = ____AttributeErrorData_notification__item__values__item_
    ___AttributeErrorData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___AttributeErrorData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____AttributeErrorData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____AttributeErrorData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____AttributeErrorData_notification__item__valuesWithContext__item__value._const_tab = ____AttributeErrorData_notification__item__type_tab
    _____AttributeErrorData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____AttributeErrorData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____AttributeErrorData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______AttributeErrorData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____AttributeErrorData_notification__item__valuesWithContext__item__contextList._cont = ______AttributeErrorData_notification__item__valuesWithContext__item__contextList__item_
    _____AttributeErrorData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____AttributeErrorData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____AttributeErrorData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____AttributeErrorData_notification__item__valuesWithContext__item__contextList),
        ])
    ____AttributeErrorData_notification__item__valuesWithContext__item_._ext = []
    ___AttributeErrorData_notification__item__valuesWithContext._cont = ____AttributeErrorData_notification__item__valuesWithContext__item_
    ___AttributeErrorData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __AttributeErrorData_notification__item_._cont = ASN1Dict([
        (u'type', ___AttributeErrorData_notification__item__type),
        (u'values', ___AttributeErrorData_notification__item__values),
        (u'valuesWithContext', ___AttributeErrorData_notification__item__valuesWithContext),
        ])
    __AttributeErrorData_notification__item_._ext = []
    _AttributeErrorData_notification._cont = __AttributeErrorData_notification__item_
    AttributeErrorData._cont = ASN1Dict([
        (u'object', _AttributeErrorData_object),
        (u'problems', _AttributeErrorData_problems),
        (u'securityParameters', _AttributeErrorData_securityParameters),
        (u'performer', _AttributeErrorData_performer),
        (u'aliasDereferenced', _AttributeErrorData_aliasDereferenced),
        (u'notification', _AttributeErrorData_notification),
        ])
    AttributeErrorData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< AttributeProblem >-----#
    AttributeProblem = INT(name=u'AttributeProblem', mode=MODE_TYPE)
    AttributeProblem._cont = ASN1Dict([(u'noSuchAttributeOrValue', 1), (u'invalidAttributeSyntax', 2), (u'undefinedAttributeType', 3), (u'inappropriateMatching', 4), (u'constraintViolation', 5), (u'attributeOrValueAlreadyExists', 6), (u'contextViolation', 7)])
    
    #-----< nameError >-----#
    nameError = CLASS(name=u'nameError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')))
    _nameError_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    __nameError_val_ParameterType_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'NameErrorData')))
    __nameError_val_ParameterType_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___nameError_val_ParameterType_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'NameErrorData')))
    ___nameError_val_ParameterType_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____nameError_val_ParameterType_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____nameError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____nameError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____nameError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab = _____nameError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____nameError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____nameError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____nameError_val_ParameterType_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____nameError_val_ParameterType_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____nameError_val_ParameterType_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____nameError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab = _____nameError_val_ParameterType_signed_algorithmIdentifier_parameters_tab
    ____nameError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____nameError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___nameError_val_ParameterType_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____nameError_val_ParameterType_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____nameError_val_ParameterType_signed_algorithmIdentifier_parameters),
        ])
    ___nameError_val_ParameterType_signed_algorithmIdentifier._ext = []
    ___nameError_val_ParameterType_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __nameError_val_ParameterType_signed._cont = ASN1Dict([
        (u'toBeSigned', ___nameError_val_ParameterType_signed_toBeSigned),
        (u'algorithmIdentifier', ___nameError_val_ParameterType_signed_algorithmIdentifier),
        (u'encrypted', ___nameError_val_ParameterType_signed_encrypted),
        ])
    __nameError_val_ParameterType_signed._ext = []
    _nameError_val_ParameterType._cont = ASN1Dict([
        (u'unsigned', __nameError_val_ParameterType_unsigned),
        (u'signed', __nameError_val_ParameterType_signed),
        ])
    _nameError_val_ParameterType._ext = None
    nameError._val = dict([(u'ParameterType', _nameError_val_ParameterType), (u'errorCode', (u'local', 2))])
    
    #-----< NameErrorData >-----#
    NameErrorData = SET(name=u'NameErrorData', mode=MODE_TYPE)
    _NameErrorData_problem = INT(name=u'problem', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'NameProblem')))
    _NameErrorData_matched = CHOICE(name=u'matched', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'Name')))
    _NameErrorData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _NameErrorData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _NameErrorData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _NameErrorData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __NameErrorData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___NameErrorData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____NameErrorData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____NameErrorData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____NameErrorData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____NameErrorData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____NameErrorData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____NameErrorData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___NameErrorData_notification__item__type._const_tab = ____NameErrorData_notification__item__type_tab
    ___NameErrorData_notification__item__type._const_tab_at = None
    ___NameErrorData_notification__item__type._const_tab_id = u'id'
    ___NameErrorData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____NameErrorData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____NameErrorData_notification__item__values__item_._const_tab = ____NameErrorData_notification__item__type_tab
    ____NameErrorData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____NameErrorData_notification__item__values__item_._const_tab_id = u'Type'
    ___NameErrorData_notification__item__values._cont = ____NameErrorData_notification__item__values__item_
    ___NameErrorData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___NameErrorData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____NameErrorData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____NameErrorData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____NameErrorData_notification__item__valuesWithContext__item__value._const_tab = ____NameErrorData_notification__item__type_tab
    _____NameErrorData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____NameErrorData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____NameErrorData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______NameErrorData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____NameErrorData_notification__item__valuesWithContext__item__contextList._cont = ______NameErrorData_notification__item__valuesWithContext__item__contextList__item_
    _____NameErrorData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____NameErrorData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____NameErrorData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____NameErrorData_notification__item__valuesWithContext__item__contextList),
        ])
    ____NameErrorData_notification__item__valuesWithContext__item_._ext = []
    ___NameErrorData_notification__item__valuesWithContext._cont = ____NameErrorData_notification__item__valuesWithContext__item_
    ___NameErrorData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __NameErrorData_notification__item_._cont = ASN1Dict([
        (u'type', ___NameErrorData_notification__item__type),
        (u'values', ___NameErrorData_notification__item__values),
        (u'valuesWithContext', ___NameErrorData_notification__item__valuesWithContext),
        ])
    __NameErrorData_notification__item_._ext = []
    _NameErrorData_notification._cont = __NameErrorData_notification__item_
    NameErrorData._cont = ASN1Dict([
        (u'problem', _NameErrorData_problem),
        (u'matched', _NameErrorData_matched),
        (u'securityParameters', _NameErrorData_securityParameters),
        (u'performer', _NameErrorData_performer),
        (u'aliasDereferenced', _NameErrorData_aliasDereferenced),
        (u'notification', _NameErrorData_notification),
        ])
    NameErrorData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< NameProblem >-----#
    NameProblem = INT(name=u'NameProblem', mode=MODE_TYPE)
    NameProblem._cont = ASN1Dict([(u'noSuchObject', 1), (u'aliasProblem', 2), (u'invalidAttributeSyntax', 3), (u'aliasDereferencingProblem', 4)])
    
    #-----< referral >-----#
    referral = CLASS(name=u'referral', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')))
    _referral_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    __referral_val_ParameterType_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReferralData')))
    __referral_val_ParameterType_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___referral_val_ParameterType_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ReferralData')))
    ___referral_val_ParameterType_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____referral_val_ParameterType_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____referral_val_ParameterType_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____referral_val_ParameterType_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____referral_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab = _____referral_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____referral_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____referral_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____referral_val_ParameterType_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____referral_val_ParameterType_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____referral_val_ParameterType_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____referral_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab = _____referral_val_ParameterType_signed_algorithmIdentifier_parameters_tab
    ____referral_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____referral_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___referral_val_ParameterType_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____referral_val_ParameterType_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____referral_val_ParameterType_signed_algorithmIdentifier_parameters),
        ])
    ___referral_val_ParameterType_signed_algorithmIdentifier._ext = []
    ___referral_val_ParameterType_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __referral_val_ParameterType_signed._cont = ASN1Dict([
        (u'toBeSigned', ___referral_val_ParameterType_signed_toBeSigned),
        (u'algorithmIdentifier', ___referral_val_ParameterType_signed_algorithmIdentifier),
        (u'encrypted', ___referral_val_ParameterType_signed_encrypted),
        ])
    __referral_val_ParameterType_signed._ext = []
    _referral_val_ParameterType._cont = ASN1Dict([
        (u'unsigned', __referral_val_ParameterType_unsigned),
        (u'signed', __referral_val_ParameterType_signed),
        ])
    _referral_val_ParameterType._ext = None
    referral._val = dict([(u'ParameterType', _referral_val_ParameterType), (u'errorCode', (u'local', 4))])
    
    #-----< ReferralData >-----#
    ReferralData = SET(name=u'ReferralData', mode=MODE_TYPE)
    _ReferralData_candidate = SET(name=u'candidate', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DistributedOperations', 'ContinuationReference')))
    _ReferralData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ReferralData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ReferralData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ReferralData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ReferralData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___ReferralData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____ReferralData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____ReferralData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____ReferralData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____ReferralData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____ReferralData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____ReferralData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___ReferralData_notification__item__type._const_tab = ____ReferralData_notification__item__type_tab
    ___ReferralData_notification__item__type._const_tab_at = None
    ___ReferralData_notification__item__type._const_tab_id = u'id'
    ___ReferralData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____ReferralData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____ReferralData_notification__item__values__item_._const_tab = ____ReferralData_notification__item__type_tab
    ____ReferralData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____ReferralData_notification__item__values__item_._const_tab_id = u'Type'
    ___ReferralData_notification__item__values._cont = ____ReferralData_notification__item__values__item_
    ___ReferralData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___ReferralData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____ReferralData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____ReferralData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____ReferralData_notification__item__valuesWithContext__item__value._const_tab = ____ReferralData_notification__item__type_tab
    _____ReferralData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____ReferralData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____ReferralData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______ReferralData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____ReferralData_notification__item__valuesWithContext__item__contextList._cont = ______ReferralData_notification__item__valuesWithContext__item__contextList__item_
    _____ReferralData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____ReferralData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____ReferralData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____ReferralData_notification__item__valuesWithContext__item__contextList),
        ])
    ____ReferralData_notification__item__valuesWithContext__item_._ext = []
    ___ReferralData_notification__item__valuesWithContext._cont = ____ReferralData_notification__item__valuesWithContext__item_
    ___ReferralData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __ReferralData_notification__item_._cont = ASN1Dict([
        (u'type', ___ReferralData_notification__item__type),
        (u'values', ___ReferralData_notification__item__values),
        (u'valuesWithContext', ___ReferralData_notification__item__valuesWithContext),
        ])
    __ReferralData_notification__item_._ext = []
    _ReferralData_notification._cont = __ReferralData_notification__item_
    ReferralData._cont = ASN1Dict([
        (u'candidate', _ReferralData_candidate),
        (u'securityParameters', _ReferralData_securityParameters),
        (u'performer', _ReferralData_performer),
        (u'aliasDereferenced', _ReferralData_aliasDereferenced),
        (u'notification', _ReferralData_notification),
        ])
    ReferralData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< securityError >-----#
    securityError = CLASS(name=u'securityError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')))
    _securityError_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    __securityError_val_ParameterType_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    __securityError_val_ParameterType_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___securityError_val_ParameterType_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityErrorData')))
    ___securityError_val_ParameterType_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____securityError_val_ParameterType_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____securityError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____securityError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____securityError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab = _____securityError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____securityError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____securityError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____securityError_val_ParameterType_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____securityError_val_ParameterType_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____securityError_val_ParameterType_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____securityError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab = _____securityError_val_ParameterType_signed_algorithmIdentifier_parameters_tab
    ____securityError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____securityError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___securityError_val_ParameterType_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____securityError_val_ParameterType_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____securityError_val_ParameterType_signed_algorithmIdentifier_parameters),
        ])
    ___securityError_val_ParameterType_signed_algorithmIdentifier._ext = []
    ___securityError_val_ParameterType_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __securityError_val_ParameterType_signed._cont = ASN1Dict([
        (u'toBeSigned', ___securityError_val_ParameterType_signed_toBeSigned),
        (u'algorithmIdentifier', ___securityError_val_ParameterType_signed_algorithmIdentifier),
        (u'encrypted', ___securityError_val_ParameterType_signed_encrypted),
        ])
    __securityError_val_ParameterType_signed._ext = []
    _securityError_val_ParameterType._cont = ASN1Dict([
        (u'unsigned', __securityError_val_ParameterType_unsigned),
        (u'signed', __securityError_val_ParameterType_signed),
        ])
    _securityError_val_ParameterType._ext = None
    securityError._val = dict([(u'ParameterType', _securityError_val_ParameterType), (u'errorCode', (u'local', 6))])
    
    #-----< SecurityErrorData >-----#
    SecurityErrorData = SET(name=u'SecurityErrorData', mode=MODE_TYPE)
    _SecurityErrorData_problem = INT(name=u'problem', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityProblem')))
    _SecurityErrorData_spkmInfo = SEQ(name=u'spkmInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('SpkmGssTokens', 'SPKM-ERROR')), opt=True)
    _SecurityErrorData_encPwdInfo = SEQ(name=u'encPwdInfo', mode=MODE_TYPE, tag=(2, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'EncPwdInfo')), opt=True)
    _SecurityErrorData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _SecurityErrorData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _SecurityErrorData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _SecurityErrorData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __SecurityErrorData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___SecurityErrorData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____SecurityErrorData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____SecurityErrorData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____SecurityErrorData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____SecurityErrorData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____SecurityErrorData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____SecurityErrorData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___SecurityErrorData_notification__item__type._const_tab = ____SecurityErrorData_notification__item__type_tab
    ___SecurityErrorData_notification__item__type._const_tab_at = None
    ___SecurityErrorData_notification__item__type._const_tab_id = u'id'
    ___SecurityErrorData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____SecurityErrorData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____SecurityErrorData_notification__item__values__item_._const_tab = ____SecurityErrorData_notification__item__type_tab
    ____SecurityErrorData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____SecurityErrorData_notification__item__values__item_._const_tab_id = u'Type'
    ___SecurityErrorData_notification__item__values._cont = ____SecurityErrorData_notification__item__values__item_
    ___SecurityErrorData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___SecurityErrorData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____SecurityErrorData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____SecurityErrorData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____SecurityErrorData_notification__item__valuesWithContext__item__value._const_tab = ____SecurityErrorData_notification__item__type_tab
    _____SecurityErrorData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____SecurityErrorData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____SecurityErrorData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______SecurityErrorData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____SecurityErrorData_notification__item__valuesWithContext__item__contextList._cont = ______SecurityErrorData_notification__item__valuesWithContext__item__contextList__item_
    _____SecurityErrorData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____SecurityErrorData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____SecurityErrorData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____SecurityErrorData_notification__item__valuesWithContext__item__contextList),
        ])
    ____SecurityErrorData_notification__item__valuesWithContext__item_._ext = []
    ___SecurityErrorData_notification__item__valuesWithContext._cont = ____SecurityErrorData_notification__item__valuesWithContext__item_
    ___SecurityErrorData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __SecurityErrorData_notification__item_._cont = ASN1Dict([
        (u'type', ___SecurityErrorData_notification__item__type),
        (u'values', ___SecurityErrorData_notification__item__values),
        (u'valuesWithContext', ___SecurityErrorData_notification__item__valuesWithContext),
        ])
    __SecurityErrorData_notification__item_._ext = []
    _SecurityErrorData_notification._cont = __SecurityErrorData_notification__item_
    SecurityErrorData._cont = ASN1Dict([
        (u'problem', _SecurityErrorData_problem),
        (u'spkmInfo', _SecurityErrorData_spkmInfo),
        (u'encPwdInfo', _SecurityErrorData_encPwdInfo),
        (u'securityParameters', _SecurityErrorData_securityParameters),
        (u'performer', _SecurityErrorData_performer),
        (u'aliasDereferenced', _SecurityErrorData_aliasDereferenced),
        (u'notification', _SecurityErrorData_notification),
        ])
    SecurityErrorData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< SecurityProblem >-----#
    SecurityProblem = INT(name=u'SecurityProblem', mode=MODE_TYPE)
    SecurityProblem._cont = ASN1Dict([(u'inappropriateAuthentication', 1), (u'invalidCredentials', 2), (u'insufficientAccessRights', 3), (u'invalidSignature', 4), (u'protectionRequired', 5), (u'noInformation', 6), (u'blockedCredentials', 7), (u'spkmError', 9), (u'unsupportedAuthenticationMethod', 10), (u'passwordExpired', 11), (u'inappropriateAlgorithms', 12)])
    
    #-----< EncPwdInfo >-----#
    EncPwdInfo = SEQ(name=u'EncPwdInfo', mode=MODE_TYPE)
    _EncPwdInfo_algorithms = SEQ_OF(name=u'algorithms', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __EncPwdInfo_algorithms__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ___EncPwdInfo_algorithms__item__algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    ____EncPwdInfo_algorithms__item__algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____EncPwdInfo_algorithms__item__algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___EncPwdInfo_algorithms__item__algorithm._const_tab = ____EncPwdInfo_algorithms__item__algorithm_tab
    ___EncPwdInfo_algorithms__item__algorithm._const_tab_at = None
    ___EncPwdInfo_algorithms__item__algorithm._const_tab_id = u'id'
    ___EncPwdInfo_algorithms__item__parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    ____EncPwdInfo_algorithms__item__parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    ____EncPwdInfo_algorithms__item__parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ___EncPwdInfo_algorithms__item__parameters._const_tab = ____EncPwdInfo_algorithms__item__parameters_tab
    ___EncPwdInfo_algorithms__item__parameters._const_tab_at = ('..', u'algorithm')
    ___EncPwdInfo_algorithms__item__parameters._const_tab_id = u'Type'
    __EncPwdInfo_algorithms__item_._cont = ASN1Dict([
        (u'algorithm', ___EncPwdInfo_algorithms__item__algorithm),
        (u'parameters', ___EncPwdInfo_algorithms__item__parameters),
        ])
    __EncPwdInfo_algorithms__item_._ext = []
    _EncPwdInfo_algorithms._cont = __EncPwdInfo_algorithms__item_
    _EncPwdInfo_pwdQualityRule = SEQ_OF(name=u'pwdQualityRule', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __EncPwdInfo_pwdQualityRule__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeTypeAndValue')))
    _EncPwdInfo_pwdQualityRule._cont = __EncPwdInfo_pwdQualityRule__item_
    EncPwdInfo._cont = ASN1Dict([
        (u'algorithms', _EncPwdInfo_algorithms),
        (u'pwdQualityRule', _EncPwdInfo_pwdQualityRule),
        ])
    EncPwdInfo._ext = []
    
    #-----< serviceError >-----#
    serviceError = CLASS(name=u'serviceError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')))
    _serviceError_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    __serviceError_val_ParameterType_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceErrorData')))
    __serviceError_val_ParameterType_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___serviceError_val_ParameterType_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceErrorData')))
    ___serviceError_val_ParameterType_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____serviceError_val_ParameterType_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____serviceError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____serviceError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____serviceError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab = _____serviceError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____serviceError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____serviceError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____serviceError_val_ParameterType_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____serviceError_val_ParameterType_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____serviceError_val_ParameterType_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____serviceError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab = _____serviceError_val_ParameterType_signed_algorithmIdentifier_parameters_tab
    ____serviceError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____serviceError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___serviceError_val_ParameterType_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____serviceError_val_ParameterType_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____serviceError_val_ParameterType_signed_algorithmIdentifier_parameters),
        ])
    ___serviceError_val_ParameterType_signed_algorithmIdentifier._ext = []
    ___serviceError_val_ParameterType_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __serviceError_val_ParameterType_signed._cont = ASN1Dict([
        (u'toBeSigned', ___serviceError_val_ParameterType_signed_toBeSigned),
        (u'algorithmIdentifier', ___serviceError_val_ParameterType_signed_algorithmIdentifier),
        (u'encrypted', ___serviceError_val_ParameterType_signed_encrypted),
        ])
    __serviceError_val_ParameterType_signed._ext = []
    _serviceError_val_ParameterType._cont = ASN1Dict([
        (u'unsigned', __serviceError_val_ParameterType_unsigned),
        (u'signed', __serviceError_val_ParameterType_signed),
        ])
    _serviceError_val_ParameterType._ext = None
    serviceError._val = dict([(u'ParameterType', _serviceError_val_ParameterType), (u'errorCode', (u'local', 3))])
    
    #-----< ServiceErrorData >-----#
    ServiceErrorData = SET(name=u'ServiceErrorData', mode=MODE_TYPE)
    _ServiceErrorData_problem = INT(name=u'problem', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'ServiceProblem')))
    _ServiceErrorData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _ServiceErrorData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _ServiceErrorData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _ServiceErrorData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __ServiceErrorData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___ServiceErrorData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ____ServiceErrorData_notification__item__type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    _____ServiceErrorData_notification__item__type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    _____ServiceErrorData_notification__item__type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    ____ServiceErrorData_notification__item__type_tab._val = ASN1Set(rv=[dict([(u'Type', _____ServiceErrorData_notification__item__type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', _____ServiceErrorData_notification__item__type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ___ServiceErrorData_notification__item__type._const_tab = ____ServiceErrorData_notification__item__type_tab
    ___ServiceErrorData_notification__item__type._const_tab_at = None
    ___ServiceErrorData_notification__item__type._const_tab_id = u'id'
    ___ServiceErrorData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____ServiceErrorData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____ServiceErrorData_notification__item__values__item_._const_tab = ____ServiceErrorData_notification__item__type_tab
    ____ServiceErrorData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____ServiceErrorData_notification__item__values__item_._const_tab_id = u'Type'
    ___ServiceErrorData_notification__item__values._cont = ____ServiceErrorData_notification__item__values__item_
    ___ServiceErrorData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___ServiceErrorData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____ServiceErrorData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____ServiceErrorData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____ServiceErrorData_notification__item__valuesWithContext__item__value._const_tab = ____ServiceErrorData_notification__item__type_tab
    _____ServiceErrorData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____ServiceErrorData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____ServiceErrorData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______ServiceErrorData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____ServiceErrorData_notification__item__valuesWithContext__item__contextList._cont = ______ServiceErrorData_notification__item__valuesWithContext__item__contextList__item_
    _____ServiceErrorData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____ServiceErrorData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____ServiceErrorData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____ServiceErrorData_notification__item__valuesWithContext__item__contextList),
        ])
    ____ServiceErrorData_notification__item__valuesWithContext__item_._ext = []
    ___ServiceErrorData_notification__item__valuesWithContext._cont = ____ServiceErrorData_notification__item__valuesWithContext__item_
    ___ServiceErrorData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __ServiceErrorData_notification__item_._cont = ASN1Dict([
        (u'type', ___ServiceErrorData_notification__item__type),
        (u'values', ___ServiceErrorData_notification__item__values),
        (u'valuesWithContext', ___ServiceErrorData_notification__item__valuesWithContext),
        ])
    __ServiceErrorData_notification__item_._ext = []
    _ServiceErrorData_notification._cont = __ServiceErrorData_notification__item_
    ServiceErrorData._cont = ASN1Dict([
        (u'problem', _ServiceErrorData_problem),
        (u'securityParameters', _ServiceErrorData_securityParameters),
        (u'performer', _ServiceErrorData_performer),
        (u'aliasDereferenced', _ServiceErrorData_aliasDereferenced),
        (u'notification', _ServiceErrorData_notification),
        ])
    ServiceErrorData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< ServiceProblem >-----#
    ServiceProblem = INT(name=u'ServiceProblem', mode=MODE_TYPE)
    ServiceProblem._cont = ASN1Dict([(u'busy', 1), (u'unavailable', 2), (u'unwillingToPerform', 3), (u'chainingRequired', 4), (u'unableToProceed', 5), (u'invalidReference', 6), (u'timeLimitExceeded', 7), (u'administrativeLimitExceeded', 8), (u'loopDetected', 9), (u'unavailableCriticalExtension', 10), (u'outOfScope', 11), (u'ditError', 12), (u'invalidQueryReference', 13), (u'requestedServiceNotAvailable', 14), (u'unsupportedMatchingUse', 15), (u'ambiguousKeyAttributes', 16), (u'saslBindInProgress', 17), (u'notSupportedByLDAP', 18)])
    
    #-----< updateError >-----#
    updateError = CLASS(name=u'updateError', mode=MODE_VALUE, typeref=ASN1RefType(('CommonProtocolSpecification', 'ERROR')))
    _updateError_val_ParameterType = CHOICE(name=u'ParameterType', mode=MODE_TYPE, typeref=ASN1RefType(('EnhancedSecurity', 'OPTIONALLY-PROTECTED')))
    __updateError_val_ParameterType_unsigned = SET(name=u'unsigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'UpdateErrorData')))
    __updateError_val_ParameterType_signed = SEQ(name=u'signed', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'SIGNED')))
    ___updateError_val_ParameterType_signed_toBeSigned = SET(name=u'toBeSigned', mode=MODE_TYPE, typeref=ASN1RefType(('DirectoryAbstractService', 'UpdateErrorData')))
    ___updateError_val_ParameterType_signed_algorithmIdentifier = SEQ(name=u'algorithmIdentifier', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'AlgorithmIdentifier')))
    ____updateError_val_ParameterType_signed_algorithmIdentifier_algorithm = OID(name=u'algorithm', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'id']))
    _____updateError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____updateError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____updateError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab = _____updateError_val_ParameterType_signed_algorithmIdentifier_algorithm_tab
    ____updateError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_at = None
    ____updateError_val_ParameterType_signed_algorithmIdentifier_algorithm._const_tab_id = u'id'
    ____updateError_val_ParameterType_signed_algorithmIdentifier_parameters = OPEN(name=u'parameters', mode=MODE_TYPE, typeref=ASN1RefClassField(('AuthenticationFramework', 'ALGORITHM'), [u'Type']), opt=True)
    _____updateError_val_ParameterType_signed_algorithmIdentifier_parameters_tab = CLASS(name='_tab_ALGORITHM', mode=MODE_SET, typeref=ASN1RefType(('AuthenticationFramework', 'ALGORITHM')))
    _____updateError_val_ParameterType_signed_algorithmIdentifier_parameters_tab._val = ASN1Set(rv=[], rr=[], ev=None, er=[])
    ____updateError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab = _____updateError_val_ParameterType_signed_algorithmIdentifier_parameters_tab
    ____updateError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_at = ('..', u'algorithm')
    ____updateError_val_ParameterType_signed_algorithmIdentifier_parameters._const_tab_id = u'Type'
    ___updateError_val_ParameterType_signed_algorithmIdentifier._cont = ASN1Dict([
        (u'algorithm', ____updateError_val_ParameterType_signed_algorithmIdentifier_algorithm),
        (u'parameters', ____updateError_val_ParameterType_signed_algorithmIdentifier_parameters),
        ])
    ___updateError_val_ParameterType_signed_algorithmIdentifier._ext = []
    ___updateError_val_ParameterType_signed_encrypted = BIT_STR(name=u'encrypted', mode=MODE_TYPE, typeref=ASN1RefType(('AuthenticationFramework', 'ENCRYPTED-HASH')))
    __updateError_val_ParameterType_signed._cont = ASN1Dict([
        (u'toBeSigned', ___updateError_val_ParameterType_signed_toBeSigned),
        (u'algorithmIdentifier', ___updateError_val_ParameterType_signed_algorithmIdentifier),
        (u'encrypted', ___updateError_val_ParameterType_signed_encrypted),
        ])
    __updateError_val_ParameterType_signed._ext = []
    _updateError_val_ParameterType._cont = ASN1Dict([
        (u'unsigned', __updateError_val_ParameterType_unsigned),
        (u'signed', __updateError_val_ParameterType_signed),
        ])
    _updateError_val_ParameterType._ext = None
    updateError._val = dict([(u'ParameterType', _updateError_val_ParameterType), (u'errorCode', (u'local', 8))])
    
    #-----< UpdateErrorData >-----#
    UpdateErrorData = SET(name=u'UpdateErrorData', mode=MODE_TYPE)
    _UpdateErrorData_problem = INT(name=u'problem', mode=MODE_TYPE, tag=(0, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'UpdateProblem')))
    _UpdateErrorData_attributeInfo = SET_OF(name=u'attributeInfo', mode=MODE_TYPE, tag=(1, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __UpdateErrorData_attributeInfo__item_ = CHOICE(name='_item_', mode=MODE_TYPE)
    ___UpdateErrorData_attributeInfo__item__attributeType = OID(name=u'attributeType', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'AttributeType')))
    ___UpdateErrorData_attributeInfo__item__attribute = SEQ(name=u'attribute', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ____UpdateErrorData_attributeInfo__item__attribute_type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    _____UpdateErrorData_attributeInfo__item__attribute_type_tab = CLASS(name='_tab_ATTRIBUTE', mode=MODE_SET, typeref=ASN1RefType(('InformationFramework', 'ATTRIBUTE')))
    ______UpdateErrorData_attributeInfo__item__attribute_type_tab_val_Type_0 = OID(name=u'Type', mode=MODE_TYPE)
    ______UpdateErrorData_attributeInfo__item__attribute_type_tab_val_Type_1 = SEQ_OF(name=u'Type', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')))
    _____UpdateErrorData_attributeInfo__item__attribute_type_tab._val = ASN1Set(rv=[dict([(u'Type', ______UpdateErrorData_attributeInfo__item__attribute_type_tab_val_Type_0), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectIdentifierMatch']), (u'id', (2, 5, 13, 0))])), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 38)), (u'ldapName', [u'objectClass']), (u'id', (2, 5, 4, 0))]), dict([(u'Type', ______UpdateErrorData_attributeInfo__item__attribute_type_tab_val_Type_1), (u'equality-match', dict([(u'AssertionType', ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'distinguishedNameMatch']), (u'id', (2, 5, 13, 1))])), (u'single-valued', True), (u'ldapSyntax', (1, 3, 6, 1, 4, 1, 1466, 115, 121, 1, 12)), (u'ldapName', [u'aliasedObjectName']), (u'id', (2, 5, 4, 1))])], rr=[], ev=None, er=[])
    ____UpdateErrorData_attributeInfo__item__attribute_type._const_tab = _____UpdateErrorData_attributeInfo__item__attribute_type_tab
    ____UpdateErrorData_attributeInfo__item__attribute_type._const_tab_at = None
    ____UpdateErrorData_attributeInfo__item__attribute_type._const_tab_id = u'id'
    ____UpdateErrorData_attributeInfo__item__attribute_values = SET_OF(name=u'values', mode=MODE_TYPE)
    _____UpdateErrorData_attributeInfo__item__attribute_values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____UpdateErrorData_attributeInfo__item__attribute_values__item_._const_tab = _____UpdateErrorData_attributeInfo__item__attribute_type_tab
    _____UpdateErrorData_attributeInfo__item__attribute_values__item_._const_tab_at = ('..', '..', u'type')
    _____UpdateErrorData_attributeInfo__item__attribute_values__item_._const_tab_id = u'Type'
    ____UpdateErrorData_attributeInfo__item__attribute_values._cont = _____UpdateErrorData_attributeInfo__item__attribute_values__item_
    ____UpdateErrorData_attributeInfo__item__attribute_values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ____UpdateErrorData_attributeInfo__item__attribute_valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    _____UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    ______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__value._const_tab = _____UpdateErrorData_attributeInfo__item__attribute_type_tab
    ______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    ______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__value._const_tab_id = u'Type'
    ______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    _______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    ______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__contextList._cont = _______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__contextList__item_
    ______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _____UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item_._cont = ASN1Dict([
        (u'value', ______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__value),
        (u'contextList', ______UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item__contextList),
        ])
    _____UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item_._ext = []
    ____UpdateErrorData_attributeInfo__item__attribute_valuesWithContext._cont = _____UpdateErrorData_attributeInfo__item__attribute_valuesWithContext__item_
    ____UpdateErrorData_attributeInfo__item__attribute_valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ___UpdateErrorData_attributeInfo__item__attribute._cont = ASN1Dict([
        (u'type', ____UpdateErrorData_attributeInfo__item__attribute_type),
        (u'values', ____UpdateErrorData_attributeInfo__item__attribute_values),
        (u'valuesWithContext', ____UpdateErrorData_attributeInfo__item__attribute_valuesWithContext),
        ])
    ___UpdateErrorData_attributeInfo__item__attribute._ext = []
    __UpdateErrorData_attributeInfo__item_._cont = ASN1Dict([
        (u'attributeType', ___UpdateErrorData_attributeInfo__item__attributeType),
        (u'attribute', ___UpdateErrorData_attributeInfo__item__attribute),
        ])
    __UpdateErrorData_attributeInfo__item_._ext = []
    _UpdateErrorData_attributeInfo._cont = __UpdateErrorData_attributeInfo__item_
    _UpdateErrorData_attributeInfo._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    _UpdateErrorData_securityParameters = SET(name=u'securityParameters', mode=MODE_TYPE, tag=(30, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('DirectoryAbstractService', 'SecurityParameters')), opt=True)
    _UpdateErrorData_performer = SEQ_OF(name=u'performer', mode=MODE_TYPE, tag=(29, TAG_CONTEXT_SPEC, TAG_EXPLICIT), typeref=ASN1RefType(('InformationFramework', 'DistinguishedName')), opt=True)
    _UpdateErrorData_aliasDereferenced = BOOL(name=u'aliasDereferenced', mode=MODE_TYPE, tag=(28, TAG_CONTEXT_SPEC, TAG_EXPLICIT), default=False)
    _UpdateErrorData_notification = SEQ_OF(name=u'notification', mode=MODE_TYPE, tag=(27, TAG_CONTEXT_SPEC, TAG_EXPLICIT), opt=True)
    __UpdateErrorData_notification__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Attribute')))
    ___UpdateErrorData_notification__item__type = OID(name=u'type', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'id']))
    ___UpdateErrorData_notification__item__type._const_tab = _____UpdateErrorData_attributeInfo__item__attribute_type_tab
    ___UpdateErrorData_notification__item__type._const_tab_at = None
    ___UpdateErrorData_notification__item__type._const_tab_id = u'id'
    ___UpdateErrorData_notification__item__values = SET_OF(name=u'values', mode=MODE_TYPE)
    ____UpdateErrorData_notification__item__values__item_ = OPEN(name='_item_', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    ____UpdateErrorData_notification__item__values__item_._const_tab = _____UpdateErrorData_attributeInfo__item__attribute_type_tab
    ____UpdateErrorData_notification__item__values__item_._const_tab_at = ('..', '..', u'type')
    ____UpdateErrorData_notification__item__values__item_._const_tab_id = u'Type'
    ___UpdateErrorData_notification__item__values._cont = ____UpdateErrorData_notification__item__values__item_
    ___UpdateErrorData_notification__item__values._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=0, ub=None)], ev=None, er=[])
    ___UpdateErrorData_notification__item__valuesWithContext = SET_OF(name=u'valuesWithContext', mode=MODE_TYPE, opt=True)
    ____UpdateErrorData_notification__item__valuesWithContext__item_ = SEQ(name='_item_', mode=MODE_TYPE)
    _____UpdateErrorData_notification__item__valuesWithContext__item__value = OPEN(name=u'value', mode=MODE_TYPE, typeref=ASN1RefClassField(('InformationFramework', 'ATTRIBUTE'), [u'Type']))
    _____UpdateErrorData_notification__item__valuesWithContext__item__value._const_tab = _____UpdateErrorData_attributeInfo__item__attribute_type_tab
    _____UpdateErrorData_notification__item__valuesWithContext__item__value._const_tab_at = ('..', '..', '..', u'type')
    _____UpdateErrorData_notification__item__valuesWithContext__item__value._const_tab_id = u'Type'
    _____UpdateErrorData_notification__item__valuesWithContext__item__contextList = SET_OF(name=u'contextList', mode=MODE_TYPE)
    ______UpdateErrorData_notification__item__valuesWithContext__item__contextList__item_ = SEQ(name='_item_', mode=MODE_TYPE, typeref=ASN1RefType(('InformationFramework', 'Context')))
    _____UpdateErrorData_notification__item__valuesWithContext__item__contextList._cont = ______UpdateErrorData_notification__item__valuesWithContext__item__contextList__item_
    _____UpdateErrorData_notification__item__valuesWithContext__item__contextList._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    ____UpdateErrorData_notification__item__valuesWithContext__item_._cont = ASN1Dict([
        (u'value', _____UpdateErrorData_notification__item__valuesWithContext__item__value),
        (u'contextList', _____UpdateErrorData_notification__item__valuesWithContext__item__contextList),
        ])
    ____UpdateErrorData_notification__item__valuesWithContext__item_._ext = []
    ___UpdateErrorData_notification__item__valuesWithContext._cont = ____UpdateErrorData_notification__item__valuesWithContext__item_
    ___UpdateErrorData_notification__item__valuesWithContext._const_sz = ASN1Set(rv=[], rr=[ASN1RangeInt(lb=1, ub=None)], ev=None, er=[])
    __UpdateErrorData_notification__item_._cont = ASN1Dict([
        (u'type', ___UpdateErrorData_notification__item__type),
        (u'values', ___UpdateErrorData_notification__item__values),
        (u'valuesWithContext', ___UpdateErrorData_notification__item__valuesWithContext),
        ])
    __UpdateErrorData_notification__item_._ext = []
    _UpdateErrorData_notification._cont = __UpdateErrorData_notification__item_
    UpdateErrorData._cont = ASN1Dict([
        (u'problem', _UpdateErrorData_problem),
        (u'attributeInfo', _UpdateErrorData_attributeInfo),
        (u'securityParameters', _UpdateErrorData_securityParameters),
        (u'performer', _UpdateErrorData_performer),
        (u'aliasDereferenced', _UpdateErrorData_aliasDereferenced),
        (u'notification', _UpdateErrorData_notification),
        ])
    UpdateErrorData._ext = [u'securityParameters', u'performer', u'aliasDereferenced', u'notification']
    
    #-----< UpdateProblem >-----#
    UpdateProblem = INT(name=u'UpdateProblem', mode=MODE_TYPE)
    UpdateProblem._cont = ASN1Dict([(u'namingViolation', 1), (u'objectClassViolation', 2), (u'notAllowedOnNonLeaf', 3), (u'notAllowedOnRDN', 4), (u'entryAlreadyExists', 5), (u'affectsMultipleDSAs', 6), (u'objectClassModificationProhibited', 7), (u'noSuchSuperior', 8), (u'notAncestor', 9), (u'parentNotAncestor', 10), (u'hierarchyRuleViolation', 11), (u'familyRuleViolation', 12), (u'insufficientPasswordQuality', 13), (u'passwordInHistory', 14), (u'noPasswordSlot', 15)])
    
    #-----< id-at-family-information >-----#
    id_at_family_information = OID(name=u'id-at-family-information', mode=MODE_VALUE)
    id_at_family_information._val = (2, 5, 4, 64)
    
    _all_ = [
        _CommonArguments_serviceControls,
        _CommonArguments_securityParameters,
        _CommonArguments_requestor,
        _CommonArguments_operationProgress,
        _CommonArguments_aliasedRDNs,
        _CommonArguments_criticalExtensions,
        _CommonArguments_referenceType,
        _CommonArguments_entryOnly,
        _CommonArguments_exclusions,
        _CommonArguments_nameResolveOnMaster,
        _CommonArguments_operationContexts,
        _CommonArguments_familyGrouping,
        CommonArguments,
        _CommonArgumentsSeq_serviceControls,
        _CommonArgumentsSeq_securityParameters,
        _CommonArgumentsSeq_requestor,
        _CommonArgumentsSeq_operationProgress,
        _CommonArgumentsSeq_aliasedRDNs,
        _CommonArgumentsSeq_criticalExtensions,
        _CommonArgumentsSeq_referenceType,
        _CommonArgumentsSeq_entryOnly,
        _CommonArgumentsSeq_exclusions,
        _CommonArgumentsSeq_nameResolveOnMaster,
        _CommonArgumentsSeq_operationContexts,
        _CommonArgumentsSeq_familyGrouping,
        CommonArgumentsSeq,
        FamilyGrouping,
        _CommonResults_securityParameters,
        _CommonResults_performer,
        _CommonResults_aliasDereferenced,
        ____CommonResults_notification__item__type_tab,
        _____CommonResults_notification__item__type_tab_val_Type_0,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType,
        _____CommonResults_notification__item__type_tab_val_Type_1,
        ______AttributeCertificateInfo_attributes__item__type_tab_equality_match_val_AssertionType_0,
        ___CommonResults_notification__item__type,
        ____CommonResults_notification__item__values__item_,
        ___CommonResults_notification__item__values,
        _____CommonResults_notification__item__valuesWithContext__item__value,
        ______CommonResults_notification__item__valuesWithContext__item__contextList__item_,
        _____CommonResults_notification__item__valuesWithContext__item__contextList,
        ____CommonResults_notification__item__valuesWithContext__item_,
        ___CommonResults_notification__item__valuesWithContext,
        __CommonResults_notification__item_,
        _CommonResults_notification,
        CommonResults,
        _CommonResultsSeq_securityParameters,
        _CommonResultsSeq_performer,
        _CommonResultsSeq_aliasDereferenced,
        ____CommonResultsSeq_notification__item__type_tab,
        _____CommonResultsSeq_notification__item__type_tab_val_Type_0,
        _____CommonResultsSeq_notification__item__type_tab_val_Type_1,
        ___CommonResultsSeq_notification__item__type,
        ____CommonResultsSeq_notification__item__values__item_,
        ___CommonResultsSeq_notification__item__values,
        _____CommonResultsSeq_notification__item__valuesWithContext__item__value,
        ______CommonResultsSeq_notification__item__valuesWithContext__item__contextList__item_,
        _____CommonResultsSeq_notification__item__valuesWithContext__item__contextList,
        ____CommonResultsSeq_notification__item__valuesWithContext__item_,
        ___CommonResultsSeq_notification__item__valuesWithContext,
        __CommonResultsSeq_notification__item_,
        _CommonResultsSeq_notification,
        CommonResultsSeq,
        _Se