# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/ec_packet_access_reject_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.49 EC Packet Access Reject
# top-level object: EC Packet Access Reject message content

# external references
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.used_dl_coverage_class_ie import used_dl_coverage_class_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

ec_reject_struct = CSN1List(name='ec_reject_struct', list=[
  CSN1Bit(name='downlink_tfi', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='wait_indication', bit=8),
    CSN1Bit(name='wait__indication_size')])})])

ec_packet_access_reject_message_content = CSN1List(name='ec_packet_access_reject_message_content', trunc=True, list=[
  CSN1Ref(name='used_dl_coverage_class', obj=used_dl_coverage_class_ie),
  CSN1Ref(name='reject', obj=ec_reject_struct),
  CSN1List(list=[
    CSN1List(num=-1, list=[
      CSN1Val(name='', val='1'),
      CSN1Ref(name='additional_reject', obj=ec_reject_struct)]),
    CSN1Val(name='', val='0'),
    CSN1Ref(obj=padding_bits)])])

