# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/gprs_cell_options_ie.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 12.24 GPRS Cell Options
# top-level object: GPRS Cell Options IE



# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_bit = CSN1Bit(name='spare_bit')
Spare_bit = spare_bit
Spare_Bit = spare_bit

extension_information = CSN1List(name='extension_information', trunc=True, list=[
  CSN1List(list=[
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='egprs_packet_channel_request'),
      CSN1Bit(name='bep_period', bit=4)])}),
    CSN1Bit(name='pfc_feature_mode'),
    CSN1Bit(name='dtm_support'),
    CSN1Bit(name='bss_paging_coordination')]),
  CSN1List(list=[
    CSN1Bit(name='ccn_active'),
    CSN1Bit(name='nw_ext_utbf')]),
  CSN1List(list=[
    CSN1Bit(name='multiple_tbf_capability'),
    CSN1Bit(name='ext_utbf_nodata'),
    CSN1Bit(name='dtm_enhancements_capability'),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='dedicated_mode_mbms_notification_support'),
      CSN1Bit(name='mnci_support')])})]),
  CSN1Bit(name='reduced_latency_access'),
  CSN1Bit(name='nmo_i_alternate'),
  CSN1Ref(obj=spare_bit, num=-1)])

gprs_cell_options_ie = CSN1List(name='gprs_cell_options_ie', list=[
  CSN1Bit(name='nmo', bit=2),
  CSN1Bit(name='t3168', bit=3),
  CSN1Bit(name='t3192', bit=3),
  CSN1Bit(name='drx_timer_max', bit=3),
  CSN1Bit(name='access_burst_type'),
  CSN1Bit(name='control_ack_type'),
  CSN1Bit(name='bs_cv_max', bit=4),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='pan_dec', bit=3),
    CSN1Bit(name='pan_inc', bit=3),
    CSN1Bit(name='pan_max', bit=3)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='extension_length', bit=6),
    CSN1Ref(obj=extension_information, lref=([1], lambda x: x + 1))])})])

