# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/ps_handover_command_message_content.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.060 - d60
# section: 11.2.43 PS Handover Command
# top-level object: PS Handover Command message content

# external references
from pycrate_csn1dir.padding_bits import padding_bits
from pycrate_csn1dir.rrc_container_ie import rrc_container_ie
from pycrate_csn1dir.nas_container_for_ps_handover_ie import nas_container_for_ps_handover_ie
from pycrate_csn1dir.ps_handover_radio_resources_3_ie import ps_handover_radio_resources_3_ie
from pycrate_csn1dir.egprs_window_size_ie import egprs_window_size_ie
from pycrate_csn1dir.measurement_control_parameters_description import measurement_control_parameters_description
from pycrate_csn1dir.global_tfi_ie import global_tfi_ie
from pycrate_csn1dir.ps_handover_radio_resources_ie import ps_handover_radio_resources_ie
from pycrate_csn1dir.ps_handover_radio_resources_2_ie import ps_handover_radio_resources_2_ie

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

rlc_entity_struct = CSN1List(name='rlc_entity_struct', list=[
  CSN1Bit(name='tfi', bit=5),
  CSN1Bit(name='rlc_mode'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Ref(name='egprs_window_size', obj=egprs_window_size_ie)])}),
  CSN1Bit(name='pfi', bit=7)])

additional_pfcs_struct = CSN1List(name='additional_pfcs_struct', list=[
  CSN1Bit(name='tfi', bit=5),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='npm_transfer_time', bit=5)])}),
  CSN1Bit(name='pfi', bit=7)])

ps_handover_command_message_content = CSN1List(name='ps_handover_command_message_content', list=[
  CSN1Bit(name='page_mode', bit=2),
  CSN1List(list=[
    CSN1Val(name='', val='0'),
    CSN1Ref(name='global_tfi', obj=global_tfi_ie),
    CSN1List(list=[
      CSN1Bit(name='container_id', bit=2),
      CSN1Alt(alt={
        '00': ('', [
        CSN1Alt(name='ps_handover_to_a_gb_mode_payload', alt={
          '00': ('', [
          CSN1Ref(name='ps_handover_rr_info', obj=ps_handover_radio_resources_ie)]),
          '01': ('', [
          CSN1Ref(name='ps_handover_rr_2_info', obj=ps_handover_radio_resources_2_ie)]),
          '10': ('', [
          CSN1Ref(name='ps_handover_rr_3_info', obj=ps_handover_radio_resources_3_ie)])}),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Ref(obj=nas_container_for_ps_handover_ie)])})]),
        '01': ('', [
        CSN1Ref(name='ps_handover_to_utran_payload', obj=rrc_container_ie)]),
        '10': ('', [
        CSN1Ref(name='ps_handover_to_e_utran_payload', obj=rrc_container_ie)])}),
      CSN1Alt(alt={
        '0': ('', [
        CSN1Bit(bit=-1)]),
        '1': ('', [
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Bit(name='e_utran_ccn_active')])}),
        CSN1Alt(alt={
          '0': ('', []),
          '1': ('', [
          CSN1Ref(name='measurement_control_parameters_description', obj=measurement_control_parameters_description)])}),
        CSN1Alt(alt={
          '0': ('', [
          CSN1Bit(bit=-1)]),
          '1': ('', [
          CSN1Bit(name='enhanced_flexible_timeslot_assignment'),
          CSN1Alt(alt={
            '0': ('', [
            CSN1Bit(name='emst_nw_capability')]),
            '1': ('', [
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Ref(name='downlink_rlc_entity_2', obj=rlc_entity_struct),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Ref(name='downlink_rlc_entity_3', obj=rlc_entity_struct)])})])}),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1Ref(name='uplink_rlc_entity_2', obj=rlc_entity_struct),
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Ref(name='uplink_rlc_entity_3', obj=rlc_entity_struct)])})])})])}),
          CSN1Alt(alt={
            '0': ('', [
            CSN1Bit(bit=-1)]),
            '1': ('', [
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1List(num=-1, list=[
                CSN1Val(name='', val='1'),
                CSN1Ref(name='emsr_additional_pfcs_1', obj=additional_pfcs_struct)]),
              CSN1Val(name='', val='0'),
              CSN1List(num=-1, list=[
                CSN1Val(name='', val='1'),
                CSN1Ref(name='emsr_additional_pfcs_2', obj=additional_pfcs_struct)]),
              CSN1Val(name='', val='0'),
              CSN1List(num=-1, list=[
                CSN1Val(name='', val='1'),
                CSN1Ref(name='emsr_additional_pfcs_3', obj=additional_pfcs_struct)]),
              CSN1Val(name='', val='0')])}),
            CSN1Alt(alt={
              '0': ('', []),
              '1': ('', [
              CSN1List(num=-1, list=[
                CSN1Val(name='', val='1'),
                CSN1Ref(name='emsr_additional_pfcs_1', obj=additional_pfcs_struct)]),
              CSN1Val(name='', val='0'),
              CSN1List(num=-1, list=[
                CSN1Val(name='', val='1'),
                CSN1Ref(name='emsr_additional_pfcs_2', obj=additional_pfcs_struct)]),
              CSN1Val(name='', val='0'),
              CSN1List(num=-1, list=[
                CSN1Val(name='', val='1'),
                CSN1Ref(name='emsr_additional_pfcs_3', obj=additional_pfcs_struct)]),
              CSN1Val(name='', val='0')])}),
            CSN1Alt(alt={
              '0': ('', [
              CSN1Bit(bit=-1)]),
              '1': ('', [
              CSN1Alt(alt={
                '0': ('', []),
                '1': ('', [
                CSN1Bit(name='selected_plmn_index', bit=3)])}),
              CSN1Alt(alt={
                '0': ('', [
                CSN1Bit(bit=-1)]),
                '1': ('', [
                CSN1Bit(name='primary_tsc_set'),
                CSN1Alt(alt={
                  '0': ('', []),
                  '1': ('', [
                  CSN1Bit(name='secondary_dl_tsc_set'),
                  CSN1Bit(name='secondary_dl_tsc_value', bit=3)])}),
                CSN1Ref(obj=padding_bits)]),
                None: ('', [])})]),
              None: ('', [])})]),
            None: ('', [])})]),
          None: ('', [])})]),
        None: ('', [])})])])])

