# -*- coding: UTF-8 -*-
#/**
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2018. Benoit Michau. ANSSI. P1sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_csn1dir/si10bis_rest_octets.py
# * Created : 2018-11-21
# * Authors : Benoit Michau
# *--------------------------------------------------------
#*/
# specification: TS 44.018 - d80
# section: 10.5.2.70 SI10bis Rest Octets
# top-level object: SI10bis Rest Octets

# external references
from pycrate_csn1dir.notification_facch import group_channel_description

# code automatically generated by pycrate_csn1
# change object type with type=CSN1T_BSTR (default type is CSN1T_UINT) in init
# add dict for value interpretation with dic={...} in CSN1Bit init
# add dict for key interpretation with kdic={...} in CSN1Alt init

from pycrate_csn1.csnobj import *

spare_padding = CSN1Val(name='spare_padding', val='L', num=-1)
Spare_padding = spare_padding
Spare_Padding = spare_padding 

si10ter_rest_octets = CSN1List(name='si10ter_rest_octets', list=[
  CSN1Bit(name='si10bis_sequence', bit=2),
  CSN1Alt(alt={
    '0': ('', [
    CSN1Bit(name='position_in_si5_list', bit=5)]),
    '1': ('', [
    CSN1Bit(name='bcch_arfcn', bit=10)])}),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Bit(name='bsic', bit=6)])}),
  CSN1Bit(name='nch_position', bit=5),
  CSN1Ref(obj=spare_padding)])

nas_type4_lv = CSN1List(name='nas_type4_lv', list=[
  CSN1Bit(name='length', bit=8),
  CSN1Bit(name='value', bit=([0], lambda x: 8 * x))])

si10bis_neighbour_cell_info = CSN1List(name='si10bis_neighbour_cell_info', list=[
  CSN1Ref(obj=group_channel_description),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Alt(alt={
      '0': ('', [
      CSN1Bit(name='frequency_short_list', bit=64)]),
      '1': ('', [
      CSN1Ref(name='frequency_list', obj=nas_type4_lv)])})])}),
  CSN1Bit(name='cell_global_count', bit=2),
  CSN1Bit(name='b22_count'),
  CSN1Alt(alt={
    '0': ('', []),
    '1': ('', [
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='priority_uplink_access')])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='fr_amr_config', bit=4)])}),
      CSN1Alt(alt={
        '0': ('', []),
        '1': ('', [
        CSN1Bit(name='hr_amr_config', bit=4)])})])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='sms_data_confidentiality_ind'),
      CSN1Bit(name='sms_guaranteed_privacy_ind')])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='max_retrans', bit=2),
      CSN1Bit(name='tx_integer', bit=4)])})])})])

si10bis_rest_octets = CSN1List(name='si10bis_rest_octets', list=[
  CSN1Bit(name='si10bis_sequence', bit=2),
  CSN1List(num=-1, list=[
    CSN1Val(name='', val='H'),
    CSN1Bit(name='position_in_si5_list', bit=5),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='bcch_arfcn', bit=10)])}),
    CSN1Alt(alt={
      '0': ('', []),
      '1': ('', [
      CSN1Bit(name='bsic', bit=6)])}),
    CSN1Ref(obj=si10bis_neighbour_cell_info)]),
  CSN1Val(name='', val='L'),
  CSN1Ref(obj=spare_padding)])

