# -*- coding: UTF-8 -*-
#/*
# * Software Name : pycrate
# * Version : 0.4
# *
# * Copyright 2020. Benoit Michau. P1Sec.
# *
# * This library is free software; you can redistribute it and/or
# * modify it under the terms of the GNU Lesser General Public
# * License as published by the Free Software Foundation; either
# * version 2.1 of the License, or (at your option) any later version.
# *
# * This library is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# * Lesser General Public License for more details.
# *
# * You should have received a copy of the GNU Lesser General Public
# * License along with this library; if not, write to the Free Software
# * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# * MA 02110-1301  USA
# *
# *--------------------------------------------------------
# * File Name : pycrate_diameter/iana_diameter_dicts.py
# * Created : 2020-12-10
# * Authors : Benoit Michau
# *--------------------------------------------------------
# */

AVPRadCodes_dict  = \
{ 1: 'User-Name',
  2: 'User-Password',
  3: 'CHAP-Password',
  4: 'NAS-IP-Address',
  5: 'NAS-Port',
  6: 'Service-Type',
  7: 'Framed-Protocol',
  8: 'Framed-IP-Address',
  9: 'Framed-IP-Netmask',
  10: 'Framed-Routing',
  11: 'Filter-Id',
  12: 'Framed-MTU',
  13: 'Framed-Compression',
  14: 'Login-IP-Host',
  15: 'Login-Service',
  16: 'Login-TCP-Port',
  17: 'Unassigned',
  18: 'Reply-Message',
  19: 'Callback-Number',
  20: 'Callback-Id',
  21: 'Unassigned',
  22: 'Framed-Route',
  23: 'Framed-IPX-Network',
  24: 'State',
  25: 'Class',
  26: 'Vendor-Specific',
  27: 'Session-Timeout',
  28: 'Idle-Timeout',
  29: 'Termination-Action',
  30: 'Called-Station-Id',
  31: 'Calling-Station-Id',
  32: 'NAS-Identifier',
  33: 'Proxy-State',
  34: 'Login-LAT-Service',
  35: 'Login-LAT-Node',
  36: 'Login-LAT-Group',
  37: 'Framed-AppleTalk-Link',
  38: 'Framed-AppleTalk-Network',
  39: 'Framed-AppleTalk-Zone',
  40: 'Acct-Status-Type',
  41: 'Acct-Delay-Time',
  42: 'Acct-Input-Octets',
  43: 'Acct-Output-Octets',
  44: 'Acct-Session-Id',
  45: 'Acct-Authentic',
  46: 'Acct-Session-Time',
  47: 'Acct-Input-Packets',
  48: 'Acct-Output-Packets',
  49: 'Acct-Terminate-Cause',
  50: 'Acct-Multi-Session-Id',
  51: 'Acct-Link-Count',
  52: 'Acct-Input-Gigawords',
  53: 'Acct-Output-Gigawords',
  54: 'Unassigned',
  55: 'Event-Timestamp',
  56: 'Egress-VLANID',
  57: 'Ingress-Filters',
  58: 'Egress-VLAN-Name',
  59: 'User-Priority-Table',
  60: 'CHAP-Challenge',
  61: 'NAS-Port-Type',
  62: 'Port-Limit',
  63: 'Login-LAT-Port',
  64: 'Tunnel-Type',
  65: 'Tunnel-Medium-Type',
  66: 'Tunnel-Client-Endpoint',
  67: 'Tunnel-Server-Endpoint',
  68: 'Acct-Tunnel-Connection',
  69: 'Tunnel-Password',
  70: 'ARAP-Password',
  71: 'ARAP-Features',
  72: 'ARAP-Zone-Access',
  73: 'ARAP-Security',
  74: 'ARAP-Security-Data',
  75: 'Password-Retry',
  76: 'Prompt',
  77: 'Connect-Info',
  78: 'Configuration-Token',
  79: 'EAP-Message',
  80: 'Message-Authenticator',
  81: 'Tunnel-Private-Group-ID',
  82: 'Tunnel-Assignment-ID',
  83: 'Tunnel-Preference',
  84: 'ARAP-Challenge-Response',
  85: 'Acct-Interim-Interval',
  86: 'Acct-Tunnel-Packets-Lost',
  87: 'NAS-Port-Id',
  88: 'Framed-Pool',
  89: 'CUI',
  90: 'Tunnel-Client-Auth-ID',
  91: 'Tunnel-Server-Auth-ID',
  92: 'NAS-Filter-Rule',
  93: 'Unassigned',
  94: 'Originating-Line-Info',
  95: 'NAS-IPv6-Address',
  96: 'Framed-Interface-Id',
  97: 'Framed-IPv6-Prefix',
  98: 'Login-IPv6-Host',
  99: 'Framed-IPv6-Route',
  100: 'Framed-IPv6-Pool',
  101: 'Error-Cause Attribute',
  102: 'EAP-Key-Name',
  103: 'Digest-Response',
  104: 'Digest-Realm',
  105: 'Digest-Nonce',
  106: 'Digest-Response-Auth',
  107: 'Digest-Nextnonce',
  108: 'Digest-Method',
  109: 'Digest-URI',
  110: 'Digest-Qop',
  111: 'Digest-Algorithm',
  112: 'Digest-Entity-Body-Hash',
  113: 'Digest-CNonce',
  114: 'Digest-Nonce-Count',
  115: 'Digest-Username',
  116: 'Digest-Opaque',
  117: 'Digest-Auth-Param',
  118: 'Digest-AKA-Auts',
  119: 'Digest-Domain',
  120: 'Digest-Stale',
  121: 'Digest-HA1',
  122: 'SIP-AOR',
  123: 'Delegated-IPv6-Prefix',
  124: 'MIP6-Feature-Vector',
  125: 'MIP6-Home-Link-Prefix',
  126: 'Operator-Name',
  127: 'Location-Information',
  128: 'Location-Data',
  129: 'Basic-Location-Policy-Rules',
  130: 'Extended-Location-Policy-Rules',
  131: 'Location-Capable',
  132: 'Requested-Location-Info',
  133: 'Framed-Management-Protocol',
  134: 'Management-Transport-Protection',
  135: 'Management-Policy-Id',
  136: 'Management-Privilege-Level',
  137: 'PKM-SS-Cert',
  138: 'PKM-CA-Cert',
  139: 'PKM-Config-Settings',
  140: 'PKM-Cryptosuite-List',
  141: 'PKM-SAID',
  142: 'PKM-SA-Descriptor',
  143: 'PKM-Auth-Key',
  144: 'DS-Lite-Tunnel-Name',
  145: 'Mobile-Node-Identifier',
  146: 'Service-Selection',
  147: 'PMIP6-Home-LMA-IPv6-Address',
  148: 'PMIP6-Visited-LMA-IPv6-Address',
  149: 'PMIP6-Home-LMA-IPv4-Address',
  150: 'PMIP6-Visited-LMA-IPv4-Address',
  151: 'PMIP6-Home-HN-Prefix',
  152: 'PMIP6-Visited-HN-Prefix',
  153: 'PMIP6-Home-Interface-ID',
  154: 'PMIP6-Visited-Interface-ID',
  155: 'PMIP6-Home-IPv4-HoA',
  156: 'PMIP6-Visited-IPv4-HoA',
  157: 'PMIP6-Home-DHCP4-Server-Address',
  158: 'PMIP6-Visited-DHCP4-Server-Address',
  159: 'PMIP6-Home-DHCP6-Server-Address',
  160: 'PMIP6-Visited-DHCP6-Server-Address',
  161: 'PMIP6-Home-IPv4-Gateway',
  162: 'PMIP6-Visited-IPv4-Gateway',
  163: 'EAP-Lower-Layer',
  164: 'GSS-Acceptor-Service-Name',
  165: 'GSS-Acceptor-Host-Name',
  166: 'GSS-Acceptor-Service-Specifics',
  167: 'GSS-Acceptor-Realm-Name',
  168: 'Framed-IPv6-Address',
  169: 'DNS-Server-IPv6-Address',
  170: 'Route-IPv6-Information',
  171: 'Delegated-IPv6-Prefix-Pool',
  172: 'Stateful-IPv6-Address-Pool',
  173: 'IPv6-6rd-Configuration',
  174: 'Allowed-Called-Station-Id',
  175: 'EAP-Peer-Id',
  176: 'EAP-Server-Id',
  177: 'Mobility-Domain-Id',
  178: 'Preauth-Timeout',
  179: 'Network-Id-Name',
  180: 'EAPoL-Announcement',
  181: 'WLAN-HESSID',
  182: 'WLAN-Venue-Info',
  183: 'WLAN-Venue-Language',
  184: 'WLAN-Venue-Name',
  185: 'WLAN-Reason-Code',
  186: 'WLAN-Pairwise-Cipher',
  187: 'WLAN-Group-Cipher',
  188: 'WLAN-AKM-Suite',
  189: 'WLAN-Group-Mgmt-Cipher',
  190: 'WLAN-RF-Band',
  191: 'Unassigned',
  241: 'Extended-Attribute-1',
  242: 'Extended-Attribute-2',
  243: 'Extended-Attribute-3',
  244: 'Extended-Attribute-4',
  245: 'Extended-Attribute-5',
  246: 'Extended-Attribute-6'}

AppID_dict        = \
{ 1: 'NASREQ',
  2: 'Mobile IPv4',
  3: 'Diameter base accounting',
  4: 'Diameter Credit Control',
  5: 'Diameter EAP',
  6: 'Diameter Session Initiation Protocol (SIP) Application',
  7: 'Diameter Mobile IPv6 IKE (MIP6I)',
  8: 'Diameter Mobile IPv6 Auth (MIP6A)',
  9: 'Diameter QoS application',
  10: 'Diameter Capabilities Update',
  11: 'Diameter IKE SK (IKESK)',
  12: 'Diameter NAT Control Application',
  13: 'Diameter ERP',
  16777216: '3GPP Cx',
  16777217: '3GPP Sh',
  16777218: '3GPP Re',
  16777219: '3GPP Wx',
  16777220: '3GPP Zn',
  16777221: '3GPP Zh',
  16777222: '3GPP Gq',
  16777223: '3GPP Gmb',
  16777224: '3GPP Gx',
  16777225: '3GPP Gx over Gy',
  16777226: '3GPP MM10',
  16777227: 'Ericsson MSI',
  16777228: 'Ericsson Zx',
  16777229: '3GPP Rx',
  16777230: '3GPP Pr',
  16777231: 'ETSI e4',
  16777232: 'Ericsson Charging-CIP',
  16777233: 'Ericsson Mm',
  16777234: 'Vodafone Gx+',
  16777235: 'ITU-T Rs',
  16777236: '3GPP Rx',
  16777237: '3GPP2 Ty',
  16777238: '3GPP Gx',
  16777239: 'Juniper Cluster',
  16777240: 'Juniper Policy-Control-AAA',
  16777241: 'iptego USPI',
  16777242: 'Covergence-specific SIP routing',
  16777243: 'Policy Processing',
  16777244: 'Juniper Policy-Control-JSRC',
  16777245: 'ITU-T S-TC1',
  16777246: 'NSN Unified Charging Trigger Function (UCTF)',
  16777247: '3GPP2 CAN Access Authentication and Authorization',
  16777248: '3GPP2 WLAN Interworking Access Authentication and Authorization',
  16777249: '3GPP2 WLAN Interworking Accounting',
  16777250: '3GPP Sta',
  16777251: '3GPP S6a',
  16777252: '3GPP S13',
  16777253: 'ETSI Re',
  16777254: 'ETSI GOCAP',
  16777255: 'SLg',
  16777256: 'ITU-T Rw',
  16777257: 'ETSI a4',
  16777258: 'ITU-T Rt',
  16777259: 'CARA',
  16777260: 'CAMA',
  16777261: 'Femtocell extension to Diameter EAP Application',
  16777262: 'ITU-T Ru',
  16777263: 'ITU-T Ng',
  16777264: '3GPP SWm',
  16777265: '3GPP SWx',
  16777266: '3GPP Gxx',
  16777267: '3GPP S9',
  16777268: '3GPP Zpn',
  16777269: 'Ericsson HSI',
  16777270: 'Juniper-Example',
  16777271: 'ITU-T Ri',
  16777272: '3GPP S6b',
  16777273: 'Juniper JGx',
  16777274: 'ITU-T Rd',
  16777275: 'ADMI Notification Application',
  16777276: 'ADMI Messaging Interface Application',
  16777277: 'Peter-Service VSI',
  16777278: 'ETSI Rr request model',
  16777279: 'ETSI Rr delegated model',
  16777280: 'WIMAX HRPD Interworking',
  16777281: 'WiMAX Network Access Authentication and Authorization Diameter '
            'Application (WNAAADA)',
  16777282: 'WiMAX Network Accounting Diameter Application (WNADA)',
  16777283: 'WiMAX MIP4 Diameter Application (WM4DA)',
  16777284: 'WiMAX MIP6 Diameter Application (WM6DA)',
  16777285: 'WiMAX DHCP Diameter Application (WDDA)',
  16777286: 'WiMAX-Location-Authentication-Authorization Diameter Application '
            '(WLAADA)',
  16777287: 'WiMAX-Policy-and-Charging-Control-R3-Policies Diameter '
            'Application (WiMAX PCC-R3-P)',
  16777288: 'WiMAX-Policy-and-Charging-Control-R3-OFfline-Charging Diameter '
            'Application (WiMAX PCC-R3-OFC)',
  16777289: 'WiMAX-Policy-and-Charging-Control-R3-Offline-Charging-Prime '
            'Diameter Application (WiMAX PCC-R3-OFC-PRIME)',
  16777290: 'WiMAX-Policy-and-Charging-Control-R3-Online-Charging Diameter '
            'Application (WiMAX PCC-R3-OC)',
  16777291: '3GPP SLh',
  16777292: '3GPP SGmb',
  16777293: 'CMDI - Cloudmark Diameter Interface',
  16777294: 'Camiant DRMA',
  16777295: 'PiLTE Interworking Diameter Application',
  16777296: 'Juniper-Sessions-Recovery (JSR)',
  16777297: 'Vedicis LiveProxy',
  16777298: 'Pi*3GPP2 Diameter Application',
  16777299: 'Sandvine Rf+',
  16777300: 'Subscription Information Application',
  16777301: 'Ericsson Charging-DCIP',
  16777302: '3GPP Sy',
  16777303: '3GPP Sd',
  16777304: 'Ericsson Sy',
  16777305: 'HP DTD',
  16777306: 'M9 interface between MLM-PE(P) and MLM-PE(C)',
  16777307: 'ITU-T M13',
  16777308: '3GPP S7a',
  16777309: '3GPP Tsp',
  16777310: '3GPP S6m',
  16777311: '3GPP T4',
  16777312: '3GPP S6c',
  16777313: '3GPP SGd',
  16777314: 'Intrado-SLg',
  16777315: 'Ericsson Diameter Signalling Controller Application (DSC)',
  16777316: 'Verizon-Femto-Loc',
  16777317: 'Nokia Siemens Networks (NSN) Hd Application',
  16777318: '3GPP S15',
  16777319: '3GPP S9a',
  16777320: '3GPP S9a*',
  16777321: 'Gateway Location Application',
  16777322: 'Verizon Session Recovery',
  16777323: '3GPP2 M1 Interface',
  16777324: 'MAGIC Client Interface Protocol (CIP)',
  16777325: 'ITU-T Nc',
  16777326: 'ITU-T Ne',
  16777327: 'Ericsson Sx',
  16777328: 'Nokia Service Extension, NSE',
  16777329: 'Rivada Xd',
  16777330: 'Rivada Xm',
  16777331: 'Rivada Xh',
  16777332: 'Rivada Xf',
  16777333: 'Rivada Xp',
  16777334: 'Rivada Xa',
  16777335: '3GPP MB2-C',
  16777336: '3GPP PC4a',
  16777337: '3GPP PC2',
  16777338: 'Juniper Domain Policy',
  16777339: 'Host Observer',
  16777340: '3GPP PC6/PC7',
  16777341: 'Nokia Sdr Application',
  16777342: '3GPP Np',
  16777343: 'Sandvine Location Relay Service',
  16777344: 'Sandvine Fairshare Traffic Management Service',
  16777345: '3GPP S6t',
  16777346: '3GPP T6a/T6b',
  16777347: '3GPP Ns',
  16777348: '3GPP Nt',
  16777349: '3GPP St',
  16777350: '3GPP PC2',
  16777351: '3GPP Diameter Data Management',
  16777352: 'ITU-T M1',
  16777353: 'ITU-T M2',
  16777354: 'Verizon-NLS-WDS',
  16777355: '3GPP V4',
  16777356: '3GPP V6',
  16777357: 'OMN Adapt Application',
  16777358: '3GPP Nta',
  16777359: 'Ericsson Charging - SBI Policy',
  16777360: 'GSMA-DESS',
  4294967295: 'Relay'}

Cmd_dict          = \
{ 256: 'Unassigned',
  257: 'CER / CEA',
  258: 'RAR / RAA',
  259: 'Unassigned',
  260: 'AMR / AMA',
  261: 'Unassigned',
  262: 'HAR / HAA',
  265: 'AAR / AAA',
  268: 'DER / DEA',
  271: 'ACR / ACA',
  272: 'CCR / CCA',
  273: 'Unassigned',
  274: 'ASR / ASA',
  275: 'STR / STA',
  280: 'DWR / DWA',
  281: 'Unassigned',
  282: 'DPR / DPA',
  283: 'UAR / UAA',
  284: 'SAR / SAA',
  285: 'LIR / LIA',
  286: 'MAR / MAA',
  287: 'RTR / RTA',
  288: 'PPR / PPA',
  314: 'PDR / PDA',
  315: 'Policy-Install-Request (PIR)/Policy-Install-Answer (PIA)',
  316: '3GPP-Update-Location-Request/Answer (ULR/ULA)',
  317: '3GPP-Cancel-Location-Request/Answer (CLR/CLA)',
  318: '3GPP-Authentication-Information-Request/Answer (AIR/AIA)',
  319: '3GPP-Insert-Subscriber-Data-Request/Answer (IDR/IDA)',
  320: '3GPP-Delete-Subscriber-Data-Request/Answer (DSR/DSA)',
  321: '3GPP-Purge-UE-Request/Answer (PUR/PUA)',
  322: '3GPP-Reset-Request/Answer (RSR/RSA)',
  323: '3GPP-Notify-Request/Answer (NOR/NOA)',
  324: '3GPP-ME-Identity-Check-Request/Answer (ECR/ECA)',
  325: 'MIP6-Request/Answer (MIR/MIA)',
  326: 'QoS-Authorization-Request/QoS-Authorization-Answer (QAR/QAA)',
  327: 'QoS-Install-Request/QoS-Install-Answer (QIR/QIA)',
  328: 'Capabilities-Update-Request/Capabilities-Update-Answer (CUR/CUA)',
  329: 'IKEv2-SK-Request/Answer (ISR/ISA)',
  330: 'NAT-Control-Request/Answer (NCR/NCA)',
  8388608: 'WIMAX-HRPD-SFF Request/Answer',
  8388609: 'WiMAX-Diameter-EAP-Request/Answer (WDER/WDEA) WDE',
  8388610: 'WiMAX-Change-of-Authorization-Request/Answer (WCAR/WCAA) WCA',
  8388611: 'WiMAX-Reauthentication-Request/Answer (WRAR/WRAA) WRA',
  8388612: 'WiMAX-Session-Termination-Request/Answer (WSTR/WSTA) WST',
  8388613: 'WiMAX-Abort-Session-Request/Answer (WASR/WASA) WAS',
  8388614: 'WiMAX-Home-Agent-IPv4-Request/Answer (WHA4R/WHA4A) WHA4',
  8388615: 'WiMAX-Home-Agent-IPv6-Request/Answer (WHA6R/WHA6A) WHA6',
  8388616: 'WiMAX-DHCP-Request/Answer (WDHCPR/WDHCPA) WDHCP',
  8388617: 'WiMAX-LAA-Request/Answer (WLAAR/WLAA) WLAA',
  8388618: 'WiMAX-Location-Accounting-Request/Answer (WLACR/WLACA) WLAC',
  8388619: 'WiMAX-Location-Measurement-Query-Request/Answer (WLMQR/WLMQA) WLMQ',
  8388620: '3GPP-Provide-Location-Request/Answer (PLR/PLA)',
  8388621: '3GPP-Location-Report-Request/Answer (LRR/LRA)',
  8388622: '3GPP-LCS-Routing-Info-Request/Answer (RIR/RIA)',
  8388623: 'Notif-Request/Answer (NFR/NFA)',
  8388624: 'Msg-Interface-Request/Answer (MIFR/MIFA)',
  8388625: 'Mobile-Application-Request/Answer (MAPR/MAPA)',
  8388626: 'Update Location Request/Answer (ULR / ULA)',
  8388627: 'Cancel Location Request/Answer (CLR CLA)',
  8388628: 'Juniper-Sync-Event (JSE)',
  8388629: 'Juniper-Session-Discovery (JSD)',
  8388630: 'Query Profile Request Answer (QPR/QPA)',
  8388631: 'Subscription Information Application (SIR/SIA)',
  8388632: 'Distributed Charging Request/Diameter Charging Answer (DCR/DCA)',
  8388633: 'Ericsson Spending Limit Request/Answer (SLR/SLA)',
  8388634: 'Ericsson Spending Status Notification Request/Answer (SNR/SNA)',
  8388635: 'Spending-Limit-Request/Answer (SLR/SLA)',
  8388636: 'Spending-Status-Notification-Request/Answer (SNR/SNA)',
  8388637: 'TDF-Session-Request/Answer (TSR/TSA)',
  8388638: '3GPP-Update-VCSG-Location-Request/Answer (UVR/UVA)',
  8388639: 'Device-Action-Request/Answer (DAR/DAA)',
  8388640: 'Device-Notification-Request/Answer (DNR/DNA)',
  8388641: 'Subscriber-Information-Request/Answer (SIR/SIA)',
  8388642: 'Cancel-VCSG-Location-Request/Answer (CVR/CVA)',
  8388643: 'Device-Trigger-Request/Answer (DTR/DTA)',
  8388644: 'Delivery-Report-Request/Answer (DRR/DRA)',
  8388645: 'MO-Forward-Short-Message Request/Answer (OFR/OFA)',
  8388646: 'MT-Forward-Short-Message Request/Answer (TFR/TFA)',
  8388647: 'Send-Routing-Info-for-SM-Request/Answer (SRR/SRA)',
  8388648: 'Alert-Service-Centre-Request/Answer (ALR/ALA)',
  8388649: 'Report-SM-Delivery-Status-Request/Answer (RDR/RDA)',
  8388650: 'NSN Cancel-LocationMS-Request/Answer (CLR/CLA)',
  8388651: 'NSN User-DataMS-Request/Answer (UDR/UDA)',
  8388652: 'NSN Profile-UpdateMS-Request/Answer (PUR/PUA)',
  8388653: 'NSN Subscribe-NotificationsMS-Request/Answer (SNR/SNA)',
  8388654: 'NSN Push-NotificationMS-Request/Answer (PNR/PNA)',
  8388655: 'Get Gateway Request/Answer (GGR/GGA)',
  8388656: 'Trigger-Establishment-Request/Answer (TER/TEA)',
  8388657: 'Ericsson Binding-Data-Request/Answer (BDR/BDA)',
  8388658: '3GPP2 Subscriber-Information-Request/Answer (SIR/SIA)',
  8388659: 'Verizon Session Data Recovery Request/Answer (SDR/SDA)',
  8388660: 'Nokia Core Service Request/Answer (CSR/CSA)',
  8388661: 'Nokia Extended Command Request/Answer (ECR/ECA)',
  8388662: 'GCS-Action-Request/Answer (GAR/GAA)',
  8388663: 'GCS-Notification-Request/Answer (GNR/GNA)',
  8388664: 'ProSe-Subscriber-Information-Request/Answer (PIR/PIA)',
  8388665: 'Update-ProSe-Subscriber-Data-Request/Answer (UPR/UPA)',
  8388666: 'ProSe-Notify-Request/Answer (PNR/PNA)',
  8388667: 'Reset-Request/Answer (RSR/RSA)',
  8388668: 'ProSe-Authorization-Request/Answer (PAR/PAA)',
  8388669: 'ProSe-Discovery-Request/Answer (PDR/PDA)',
  8388670: 'ProSe-Match-Request/Answer (PMR/PMA)',
  8388671: 'ProSe-Match-Report-Info-Request/Answer (PIR/PIA)',
  8388672: 'ProSe-Proximity-Request/Answer (PRR/PRA)',
  8388673: 'ProSe-Location-Update-Request (PLR/PLA)',
  8388674: 'ProSe-Alert-Request/Answer (ALR/ALA)',
  8388675: 'ProSe-Cancellation-Request/Answer (RPR/RPA)',
  8388676: 'ProXimity-Action-Request/Answer (PXR/PXA)',
  8388677: 'Rivada Xd DSC-Registration-Request/Answer (DDRR/DDRA)',
  8388678: 'Rivada Xd Heart-Beat-Request/Answer (DHBR/DHBA)',
  8388679: 'Rivada Xd Cell-Info-Transfer-Request/Answer (DCTR/DCTA)',
  8388680: 'Rivada Xd Cell-Info-Notification-Request/Answer (DCNR/DCNA)',
  8388681: 'Rivada Xd Cell-Info-Modification-Request/Answer (DIMR/DIMA)',
  8388682: 'Rivada Xd Cell-Info-Modification-Notification-Request/Answer '
           '(DINR/DINA)',
  8388683: 'Rivada Xd Resource-Allocation-Request/Answer (DRAR/DRAA)',
  8388684: 'Rivada Xd Resource-Allocation-Notification-Request/Answer '
           '(DANR/DANA)',
  8388685: 'Rivada Xd Resource-Modification-Request/Answer (DRMR/DRMA)',
  8388686: 'Rivada Xd Resource-Modification-Notification-Request/Answer '
           '(DMNR/DMNA)',
  8388687: 'Rivada Xd Resource-Hold-Request/Answer (DRHR/DRHA)',
  8388688: 'Rivada Xd Resource-Hold-Notification-Request/Answer (DHNR/DHNA)',
  8388689: 'Rivada Xd Resource-Resume-Request/Answer (DRSR/DRSA)',
  8388690: 'Rivada Xd Resource-Resume-Notification-Request/Answer (DSNR/DSNA)',
  8388691: 'Rivada Xd Resource-Usage-Update-Request/Answer (DRUR/DRUA)',
  8388692: 'Rivada Xd Resource-Usage-Notification-Request/Answer (DUNR/DUNA)',
  8388693: 'Rivada Xd Resource-Release-Request/Answer (DRRR/DRRA)',
  8388694: 'Rivada Xd Resource-Release-Notification-Request/Answer (DRNR/DRNA)',
  8388695: 'Rivada Xm Resource-Allocation-Request/Answer (MRAR/MRAA)',
  8388696: 'Rivada Xm Resource-Hold-Request/Answer (MRHR/MRHA)',
  8388697: 'Rivada Xm Resource-Release-Request/Answer (MRRR/MRRA)',
  8388698: 'Rivada Xm Resource-Modify-Request/Answer (MRMR/MRMA)',
  8388699: 'Rivada Xm Resource-Allocation-Notify-Request/Answer (MANR/MANA)',
  8388700: 'Rivada Xm Resource-Resume-Request/Answer (MRSR/MRSA)',
  8388701: 'Rivada Xm Add-UE-Context-Request/Answer (MAUR/MAUA)',
  8388702: 'Rivada Xm Update-UE-Context-Request/Answer (MUUR/MUUA)',
  8388703: 'Rivada Xm Delete-UE-Context-Request/Answer (MDUR/MDUA)',
  8388704: 'Rivada Xm Detach-UE-Request/Answer (MDTR/MDTA)',
  8388705: 'Rivada Xm Page-UE-Request/Answer (MPUR/MPUA)',
  8388706: 'Rivada Xm Heart-Beat-Request/Answer (MHBR/MHBA)',
  8388707: 'Rivada Xa DPC-Registration-Request/Answer (ADRR/ADRA)',
  8388708: 'Rivada Xa Heart-Beat-Request/Answer (AHBR/AHBA)',
  8388709: 'Rivada Xa Resource-Allocation-Request/Answer (ARAR/ARAA)',
  8388710: 'Rivada Xa Resource-Release-Request/Answer (ARRR/ARRA)',
  8388711: 'Rivada Xa Resource-Release-Notification-Request/Answer (ARNR/ARNA)',
  8388712: 'Rivada Xh User-Data-Request/Answer (HUDR/HUDA)',
  8388713: 'ProSe-Initial-Location-Information-Request/Answer (PSR/PSA)',
  8388714: 'Nokia Session-Sync-Request/Answer (SSR/SSA)',
  8388715: 'Nokia Session-Mass-Sync-Request/Answer (SMR/SMA)',
  8388716: 'Nokia Fetch-Session-Request/Answer (FSR/FSA)',
  8388717: 'Ericsson Trace-Report-Request/Answer (TRR/TRA)',
  8388718: 'Configuration-Information-Request/Answer (CIR/CIA)',
  8388719: 'Reporting-Information-Request/Answer (RIR/RIA)',
  8388720: 'Non-Aggregated-RUCI-Report-Request/Answer (NRR/NRA)',
  8388721: 'Aggregated-RUCI-Report-Request/Answer (ARR/ARA)',
  8388722: 'Modify-Uecontext-Request/Answer (MUR/MUA)',
  8388723: 'Background-Data-Transfer-Request/Answer (BTR/BTA)',
  8388724: 'Network-Status-Request/Answer (NSR/NSA)',
  8388725: 'Network-Status-Continuous-Report-Request/Answer (NCR/NCA)',
  8388726: 'NIDD-Information-Request/Answer (NIR/NIA)',
  8388727: 'ProXimity-Application-Request/Answer (XAR/XAA)',
  8388728: 'Data-Pull-Request/Answer (DPR/DPA)',
  8388729: 'Data-Update-Request/Answer (DMR/DMA)',
  8388730: 'Notification-Data-Request/Answer (NDR/NDA)',
  8388731: 'TSSF-Notification-Request/Answer (TNR/TNA)',
  8388732: 'Connection-Management-Request/Answer (CMR/CMA)',
  8388733: 'MO-Data-Request/Answer (ODR/ODA)',
  8388734: 'MT-Data-Request/Answer (TDR/TDA)',
  8388735: 'Event-Configuration-Request/Answer (ECR/ECA)',
  8388736: 'Event-Reporting-Request/Answer (ERR/ERA)',
  8388737: 'DESS-DTLS-Handshake-Client-Request/Response',
  8388738: 'DESS-DTLS-Handshake-Server-Request/Response',
  16777214: 'Experimental code',
  16777215: 'Experimental code'}

AVPDiamCodes_dict = \
{ 256: 'Unassigned',
  257: 'Host-IP-Address',
  258: 'Auth-Application-Id',
  259: 'Acct-Application-Id',
  260: 'Vendor-Specific-Application-Id',
  261: 'Redirect-Host-Usage',
  262: 'Redirect-Max-Cache-Time',
  263: 'Session-Id',
  264: 'Origin-Host',
  265: 'Supported-Vendor-Id',
  266: 'Vendor-Id',
  267: 'Firmware-Version',
  268: 'Result-Code',
  269: 'Product-Name',
  270: 'Session-Binding',
  271: 'Session-Server-Failover',
  272: 'Multi-Round-Time-Out',
  273: 'Disconnect-Cause',
  274: 'Auth-Request-Type',
  276: 'Auth-Grace-Period',
  277: 'Auth-Session-State',
  278: 'Origin-State-Id',
  279: 'Failed-AVP',
  280: 'Proxy-Host',
  281: 'Error-Message',
  282: 'Route-Record',
  283: 'Destination-Realm',
  284: 'Proxy-Info',
  285: 'Re-Auth-Request-Type',
  286: 'Unassigned',
  287: 'Accounting-Sub-Session-Id',
  291: 'Authorization-Lifetime',
  292: 'Redirect-Host',
  293: 'Destination-Host',
  294: 'Error-Reporting-Host',
  295: 'Termination-Cause',
  296: 'Origin-Realm',
  297: 'Experimental-Result',
  298: 'Experimental-Result-Code',
  299: 'Inband-Security-Id',
  300: 'E2E-Sequence',
  301: 'DRMP',
  318: 'MIP-FA-to-HA-SPI',
  319: 'MIP-FA-to-MN-SPI',
  320: 'MIP-Reg-Request',
  321: 'MIP-Reg-Reply',
  322: 'MIP-MN-AAA-Auth',
  323: 'MIP-HA-to-FA-SPI',
  324: 'Unassigned',
  325: 'MIP-MN-to-FA-MSA',
  326: 'MIP-FA-to-MN-MSA',
  327: 'Unassigned',
  328: 'MIP-FA-to-HA-MSA',
  329: 'MIP-HA-to-FA-MSA',
  331: 'MIP-MN-to-HA-MSA',
  332: 'MIP-HA-to-MN-MSA',
  333: 'MIP-Mobile-Node-Address',
  334: 'MIP-Home-Agent-Address',
  335: 'MIP-Nonce',
  336: 'MIP-Candidate-Home-Agent-Host',
  337: 'MIP-Feature-Vector',
  338: 'MIP-Auth-Input-Data-Length',
  339: 'MIP-Authenticator-Length',
  340: 'MIP-Authenticator-Offset',
  341: 'MIP-MN-AAA-SPI',
  342: 'MIP-Filter-Rule',
  343: 'MIP-Session-Key',
  344: 'MIP-FA-Challenge',
  345: 'MIP-Algorithm-Type',
  346: 'MIP-Replay-Mode',
  347: 'MIP-Originating-Foreign-AAA',
  348: 'MIP-Home-Agent-Host',
  363: 'Accounting-Input-Octets',
  364: 'Accounting-Output-Octets',
  365: 'Accounting-Input-Packets',
  366: 'Accounting-Output-Packets',
  367: 'MIP-MSA-Lifetime',
  368: 'SIP-Accounting-Information',
  369: 'SIP-Accounting-Server-URI',
  370: 'SIP-Credit-Control-Server-URI',
  371: 'SIP-Server-URI',
  372: 'SIP-Server-Capabilities',
  373: 'SIP-Mandatory-Capability',
  374: 'SIP-Optional-Capability',
  375: 'SIP-Server-Assignment-Type',
  376: 'SIP-Auth-Data-Item',
  377: 'SIP-Authentication-Scheme',
  378: 'SIP-Item-Number',
  379: 'SIP-Authenticate',
  380: 'SIP-Authorization',
  381: 'SIP-Authentication-Info',
  382: 'SIP-Number-Auth-Items',
  383: 'SIP-Deregistration-Reason',
  384: 'SIP-Reason-Code',
  385: 'SIP-Reason-Info',
  386: 'SIP-Visited-Network-Id',
  387: 'SIP-User-Authorization-Type',
  388: 'SIP-Supported-User-Data-Type',
  389: 'SIP-User-Data',
  390: 'SIP-User-Data-Type',
  391: 'SIP-User-Data-Contents',
  392: 'SIP-User-Data-Already-Available',
  393: 'SIP-Method',
  400: 'NAS-Filter-Rule',
  401: 'Tunneling',
  402: 'CHAP-Auth',
  403: 'CHAP-Algorithm',
  404: 'CHAP-Ident',
  405: 'CHAP-Response',
  406: 'Accounting-Auth-Method',
  407: 'QoS-Filter-Rule',
  408: 'Origin-AAA-Protocol',
  411: 'CC-Correlation-Id',
  412: 'CC-Input-Octets',
  413: 'CC-Money',
  414: 'CC-Output-Octets',
  415: 'CC-Request-Number',
  416: 'CC-Request-Type',
  417: 'CC-Service-Specific-Units',
  418: 'CC-Session-Failover',
  419: 'CC-Sub-Session-Id',
  420: 'CC-Time',
  421: 'CC-Total-Octets',
  422: 'Check-Balance-Result',
  423: 'Cost-Information',
  424: 'Cost-Unit',
  425: 'Currency-Code',
  426: 'Credit-Control',
  427: 'Credit-Control-Failure-Handling',
  428: 'Direct-Debiting-Failure-Handling',
  429: 'Exponent',
  430: 'Final-Unit-Indication',
  431: 'Granted-Service-Unit',
  432: 'Rating-Group',
  433: 'Redirect-Address-Type',
  434: 'Redirect-Server',
  435: 'Redirect-Server-Address',
  436: 'Requested-Action',
  437: 'Requested-Service-Unit',
  438: 'Restriction-Filter-Rule',
  439: 'Service-Identifier',
  440: 'Service-Parameter-Info',
  441: 'Service-Parameter-Type',
  442: 'Service-Parameter-Value',
  443: 'Subscription-Id',
  444: 'Subscription-Id-Data',
  445: 'Unit-Value',
  446: 'Used-Service-Unit',
  447: 'Value-Digits',
  448: 'Validity-Time',
  449: 'Final-Unit-Action',
  450: 'Subscription-Id-Type',
  451: 'Tariff-Time-Change',
  452: 'Tariff-Change-Usage',
  453: 'G-S-U-Pool-Identifier',
  454: 'CC-Unit-Type',
  455: 'Multiple-Services-Indicator',
  456: 'Multiple-Services-Credit-Control',
  457: 'G-S-U-Pool-Reference',
  458: 'User-Equipment-Info',
  459: 'User-Equipment-Info-Type',
  460: 'User-Equipment-Info-Value',
  461: 'Service-Context-Id',
  462: 'EAP-Payload',
  463: 'EAP-Reissued-Payload',
  464: 'EAP-Master-Session-Key',
  465: 'Accounting-EAP-Auth-Method',
  480: 'Accounting-Record-Type',
  483: 'Accounting-Realtime-Required',
  484: 'Unassigned',
  485: 'Accounting-Record-Number',
  486: 'MIP6-Agent-Info',
  487: 'MIP-Careof-Address',
  488: 'MIP-Authenticator',
  489: 'MIP-MAC-Mobility-Data',
  490: 'MIP-Timestamp',
  491: 'MIP-MN-HA-SPI',
  492: 'MIP-MN-HA-MSA',
  493: 'Service-Selection',
  494: 'MIP6-Auth-Mode',
  495: 'TMOD-1',
  496: 'Token-Rate',
  497: 'Bucket-Depth',
  498: 'Peak-Traffic-Rate',
  499: 'Minimum-Policed-Unit',
  500: 'Maximum-Packet-Size',
  501: 'TMOD-2',
  502: 'Bandwidth',
  503: 'PHB-Class',
  504: 'PMIP6-DHCP-Server-Address',
  505: 'PMIP6-IPv4-Home-Address',
  506: 'Mobile-Node-Identifier',
  507: 'Service-Configuration',
  508: 'QoS-Resources',
  509: 'Filter-Rule',
  510: 'Filter-Rule-Precedence',
  511: 'Classifier',
  512: 'Classifier-ID',
  513: 'Protocol',
  514: 'Direction',
  515: 'From-Spec',
  516: 'To-Spec',
  517: 'Negated',
  518: 'IP-Address',
  519: 'IP-Address-Range',
  520: 'IP-Address-Start',
  521: 'IP-Address-End',
  522: 'IP-Address-Mask',
  523: 'IP-Mask-Bit-Mask-Width',
  524: 'MAC-Address',
  525: 'MAC-Address-Mask',
  526: 'MAC-Address-Mask-Pattern',
  527: 'EUI64-Address',
  528: 'EUI64-Address-Mask',
  529: 'EUI64-Address-Mask-Pattern',
  530: 'Port',
  531: 'Port-Range',
  532: 'Port-Start',
  533: 'Port-End',
  534: 'Use-Assigned-Address',
  535: 'Diffserv-Code-Point',
  536: 'Fragmentation-Flag',
  537: 'IP-Option',
  538: 'IP-Option-Type',
  539: 'IP-Option-Value',
  540: 'TCP-Option',
  541: 'TCP-Option-Type',
  542: 'TCP-Option-Value',
  543: 'TCP-Flags',
  544: 'TCP-Flag-Type',
  545: 'ICMP-Type',
  546: 'ICMP-Type-Number',
  547: 'ICMP-Code',
  548: 'ETH-Option',
  549: 'ETH-Proto-Type',
  550: 'ETH-Ether-Type',
  551: 'ETH-SAP',
  552: 'VLAN-ID-Range',
  553: 'S-VID-Start',
  554: 'S-VID-End',
  555: 'C-VID-Start',
  556: 'C-VID-End',
  557: 'User-Priority-Range',
  558: 'Low-User-Priority',
  559: 'High-User-Priority',
  560: 'Time-Of-Day-Condition',
  561: 'Time-Of-Day-Start',
  562: 'Time-Of-Day-End',
  563: 'Day-Of-Week-Mask',
  564: 'Day-Of-Month-Mask',
  565: 'Month-Of-Year-Mask',
  566: 'Absolute-Start-Time',
  567: 'Absolute-Start-Fractional-Seconds',
  568: 'Absolute-End-Time',
  569: 'Absolute-End-Fractional-Seconds',
  570: 'Timezone-Flag',
  571: 'Timezone-Offset',
  572: 'Treatment-Action',
  573: 'QoS-Profile-Id',
  574: 'QoS-Profile-Template',
  575: 'QoS-Semantics',
  576: 'QoS-Parameters',
  577: 'Excess-Treatment',
  578: 'QoS-Capability',
  579: 'QoS-Authorization-Data',
  580: 'Bound-Auth-Session-Id',
  581: 'Key',
  582: 'Key-Type',
  583: 'Keying-Material',
  584: 'Key-Lifetime',
  585: 'Key-SPI',
  586: 'Key-Name',
  587: 'IKEv2-Nonces',
  588: 'Ni',
  589: 'Nr',
  590: 'IKEv2-Identity',
  591: 'Initiator-Identity',
  592: 'ID-Type',
  593: 'Identification-Data',
  594: 'Responder-Identity',
  595: 'NC-Request-Type',
  596: 'NAT-Control-Install',
  597: 'NAT-Control-Remove',
  598: 'NAT-Control-Definition',
  599: 'NAT-Internal-Address',
  600: 'NAT-External-Address',
  601: 'Max-NAT-Bindings',
  602: 'NAT-Control-Binding-Template',
  603: 'Duplicate-Session-Id',
  604: 'NAT-External-Port-Style',
  605: 'NAT-Control-Record',
  606: 'NAT-Control-Binding-Status',
  607: 'Current-NAT-Bindings',
  608: 'Dual-Priority',
  609: 'Preemption-Priority',
  610: 'Defending-Priority',
  611: 'Admission-Priority',
  612: 'SIP-Resource-Priority',
  613: 'SIP-Resource-Priority-Namespace',
  614: 'SIP-Resource-Priority-Value',
  615: 'Application-Level-Resource-Priority',
  616: 'ALRP-Namespace',
  617: 'ALRP-Value',
  618: 'ERP-RK-Request',
  619: 'ERP-Realm',
  620: 'Redirect-Realm',
  621: 'OC-Supported-Features',
  622: 'OC-Feature-Vector',
  623: 'OC-OLR',
  624: 'OC-Sequence-Number',
  625: 'OC-Validity-Duration',
  626: 'OC-Report-Type',
  627: 'OC-Reduction-Percentage',
  628: 'ECN-IP-Codepoint',
  629: 'Congestion-Treatment',
  630: 'Flow-Count',
  631: 'Packet-Count',
  632: 'IP-Prefix-Length',
  633: 'Border-Router-Name',
  634: '64-Multicast-Attributes',
  635: 'ASM-mPrefix64',
  636: 'SSM-mPrefix64',
  637: 'Tunnel-Source-Pref-Or-Addr',
  638: 'Tunnel-Source-IPv6-Address',
  639: 'Port-Set-Identifier',
  640: 'Lw4o6-Binding',
  641: 'Lw4o6-External-IPv4-Addr',
  642: 'MAP-E-Attributes',
  643: 'MAP-Mesh-Mode',
  644: 'MAP-Mapping-Rule',
  645: 'Rule-IPv4-Addr-Or-Prefix',
  646: 'Rule-IPv6-Prefix',
  647: 'EA-Field-Length',
  648: 'OC-Peer-Algo',
  649: 'SourceID',
  650: 'Load',
  651: 'Load-Type',
  652: 'Load-Value',
  653: 'User-Equipment-Info-Extension',
  654: 'User-Equipment-Info-IMEISV',
  655: 'User-Equipment-Info-MAC',
  656: 'User-Equipment-Info-EUI64',
  657: 'User-Equipment-Info-ModifiedEUI64',
  658: 'User-Equipment-Info-IMEI',
  659: 'Subscription-Id-Extension',
  660: 'Subscription-Id-E164',
  661: 'Subscription-Id-IMSI',
  662: 'Subscription-Id-SIP-URI',
  663: 'Subscription-Id-NAI',
  664: 'Subscription-Id-Private',
  665: 'Redirect-Server-Extension',
  666: 'Redirect-Address-IPAddress',
  667: 'Redirect-Address-URL',
  668: 'Redirect-Address-SIP-URI',
  669: 'QoS-Final-Unit-Indication',
  670: 'OC-Maximum-Rate'}

AVPSpecVal_dict   = \
{ 261: { 1: 'ALL_SESSION',
         2: 'ALL_REALM',
         3: 'REALM_AND_APPLICATION',
         4: 'ALL_APPLICATION',
         5: 'ALL_HOST',
         6: 'ALL_USER'},
  268: { 1000: 'Reserved',
         1001: 'DIAMETER_MULTI_ROUND_AUTH',
         2000: 'Reserved',
         2001: 'DIAMETER_SUCCESS',
         2002: 'DIAMETER_LIMITED_SUCCESS',
         2003: 'DIAMETER_FIRST_REGISTRATION',
         2004: 'DIAMETER_SUBSEQUENT_REGISTRATION',
         2005: 'DIAMETER_UNREGISTERED_SERVICE',
         2006: 'DIAMETER_SUCCESS_SERVER_NAME_NOT_STORED',
         2007: 'DIAMETER_SERVER_SELECTION',
         2008: 'DIAMETER_SUCCESS_AUTH_SENT_SERVER_NOT_STORED',
         2009: 'DIAMETER_SUCCESS_RELOCATE_HA',
         3000: 'Reserved',
         3001: 'DIAMETER_COMMAND_UNSUPPORTED',
         3002: 'DIAMETER_UNABLE_TO_DELIVER',
         3003: 'DIAMETER_REALM_NOT_SERVED',
         3004: 'DIAMETER_TOO_BUSY',
         3005: 'DIAMETER_LOOP_DETECTED',
         3006: 'DIAMETER_REDIRECT_INDICATION',
         3007: 'DIAMETER_APPLICATION_UNSUPPORTED',
         3008: 'DIAMETER_INVALID_HDR_BITS',
         3009: 'DIAMETER_INVALID_AVP_BITS',
         3010: 'DIAMETER_UNKNOWN_PEER',
         3011: 'DIAMETER_REALM_REDIRECT_INDICATION',
         4000: 'Reserved',
         4001: 'DIAMETER_AUTHENTICATION_REJECTED',
         4002: 'DIAMETER_OUT_OF_SPACE',
         4003: 'ELECTION_LOST',
         4004: 'Unassigned',
         4005: 'DIAMETER_ERROR_MIP_REPLY_FAILURE',
         4006: 'DIAMETER_ERROR_HA_NOT_AVAILABLE',
         4007: 'DIAMETER_ERROR_BAD_KEY',
         4008: 'DIAMETER_ERROR_MIP_FILTER_NOT_SUPPORTED',
         4009: 'Unassigned',
         4010: 'DIAMETER_END_USER_SERVICE_DENIED',
         4011: 'DIAMETER_CREDIT_CONTROL_NOT_APPLICABLE',
         4012: 'DIAMETER_CREDIT_LIMIT_REACHED',
         4013: 'DIAMETER_USER_NAME_REQUIRED',
         4014: 'RESOURCE_FAILURE',
         5000: 'Reserved',
         5001: 'DIAMETER_AVP_UNSUPPORTED',
         5002: 'DIAMETER_UNKNOWN_SESSION_ID',
         5003: 'DIAMETER_AUTHORIZATION_REJECTED',
         5004: 'DIAMETER_INVALID_AVP_VALUE',
         5005: 'DIAMETER_MISSING_AVP',
         5006: 'DIAMETER_RESOURCES_EXCEEDED',
         5007: 'DIAMETER_CONTRADICTING_AVPS',
         5008: 'DIAMETER_AVP_NOT_ALLOWED',
         5009: 'DIAMETER_AVP_OCCURS_TOO_MANY_TIMES',
         5010: 'DIAMETER_NO_COMMON_APPLICATION',
         5011: 'DIAMETER_UNSUPPORTED_VERSION',
         5012: 'DIAMETER_UNABLE_TO_COMPLY',
         5013: 'DIAMETER_INVALID_BIT_IN_HEADER',
         5014: 'DIAMETER_INVALID_AVP_LENGTH',
         5015: 'DIAMETER_INVALID_MESSAGE_LENGTH',
         5016: 'DIAMETER_INVALID_AVP_BIT_COMBO',
         5017: 'DIAMETER_NO_COMMON_SECURITY',
         5018: 'DIAMETER_RADIUS_AVP_UNTRANSLATABLE',
         5024: 'DIAMETER_ERROR_NO_FOREIGN_HA_SERVICE',
         5025: 'DIAMETER_ERROR_END_TO_END_MIP_KEY_ENCRYPTION',
         5030: 'DIAMETER_USER_UNKNOWN',
         5031: 'DIAMETER_RATING_FAILED',
         5032: 'DIAMETER_ERROR_USER_UNKNOWN',
         5033: 'DIAMETER_ERROR_IDENTITIES_DONT_MATCH',
         5034: 'DIAMETER_ERROR_IDENTITY_NOT_REGISTERED',
         5035: 'DIAMETER_ERROR_ROAMING_NOT_ALLOWED',
         5036: 'DIAMETER_ERROR_IDENTITY_ALREADY_REGISTERED',
         5037: 'DIAMETER_ERROR_AUTH_SCHEME_NOT_SUPPORTED',
         5038: 'DIAMETER_ERROR_IN_ASSIGNMENT_TYPE',
         5039: 'DIAMETER_ERROR_TOO_MUCH_DATA',
         5040: 'DIAMETER_ERROR_NOT SUPPORTED_USER_DATA',
         5041: 'DIAMETER_ERROR_MIP6_AUTH_MODE',
         5042: 'UNKNOWN_BINDING_TEMPLATE_NAME',
         5043: 'BINDING_FAILURE',
         5044: 'MAX_BINDINGS_SET_FAILURE',
         5045: 'MAXIMUM_BINDINGS_REACHED_FOR_ENDPOINT',
         5046: 'SESSION_EXISTS',
         5047: 'INSUFFICIENT_CLASSIFIERS',
         5048: 'DIAMETER_ERROR_EAP_CODE_UNKNOWN'},
  270: {1: 'RE_AUTH', 2: 'STR', 3: 'Unassigned', 4: 'ACCOUNTING'},
  271: {1: 'TRY_AGAIN', 2: 'ALLOW_SERVICE', 3: 'TRY_AGAIN_ALLOW_SERVICE'},
  273: {1: 'BUSY', 2: 'DO_NOT_WANT_TO_TALK_TO_YOU'},
  274: { 1: 'AUTHENTICATE_ONLY',
         2: 'AUTHORIZE_ONLY',
         3: 'AUTHORIZE_AUTHENTICATE'},
  277: {1: 'NO_STATE_MAINTAINED'},
  285: {1: 'AUTHORIZE_AUTHENTICATE'},
  295: { 1: 'DIAMETER_LOGOUT',
         2: 'DIAMETER_SERVICE_NOT_PROVIDED',
         3: 'DIAMETER_BAD_ANSWER',
         4: 'DIAMETER_ADMINISTRATIVE',
         5: 'DIAMETER_LINK_BROKEN',
         6: 'DIAMETER_AUTH_EXPIRED',
         7: 'DIAMETER_USER_MOVED',
         8: 'DIAMETER_SESSION_TIMEOUT',
         11: 'User Request',
         12: 'Lost Carrier',
         13: 'Lost Service',
         14: 'Idle Timeout',
         15: 'Session Timeout',
         16: 'Admin Reset',
         17: 'Admin Reboot',
         18: 'Port Error',
         19: 'NAS Error',
         20: 'NAS Request',
         21: 'NAS Reboot',
         22: 'Port Unneeded',
         23: 'Port Preempted',
         24: 'Port Suspended',
         25: 'Service Unavailable',
         26: 'Callback',
         27: 'User Error',
         28: 'Host Request',
         29: 'Supplicant Restart',
         30: 'Reauthentication Failure',
         31: 'Port Reinitialized',
         32: 'Port Administratively Disabled'},
  299: {1: 'TLS'},
  337: { 1: 'Mobile-Node-Home-Address-Requested',
         2: 'Home-Address-Allocatable-Only-in-Home-Realm',
         3: 'Unassigned',
         4: 'Home-Agent-Requested',
         8: 'Foreign-Home-Agent-Available',
         16: 'MN-HA-Key-Request',
         32: 'MN-FA-Key-Request',
         64: 'FA-HA-Key-Request',
         128: 'Home-Agent-In-Foreign-Network',
         256: 'Co-Located-Mobile-Node'},
  345: {2: 'HMAC-SHA-1'},
  346: {1: 'None', 2: 'Timestamps', 3: 'Nonces'},
  406: { 1: 'PAP',
         2: 'CHAP',
         3: 'MS-CHAP-1',
         4: 'MS-CHAP-2',
         5: 'EAP',
         7: 'None'},
  408: {1: 'RADIUS'},
  416: { 1: 'INITIAL_REQUEST',
         2: 'UPDATE_REQUEST',
         3: 'TERMINATION_REQUEST',
         4: 'EVENT_REQUEST'},
  418: {1: 'FAILOVER_SUPPORTED'},
  422: {1: 'NO_CREDIT'},
  426: {1: 'RE_AUTHORIZATION'},
  427: {1: 'CONTINUE', 2: 'RETRY_AND_TERMINATE'},
  428: {1: 'CONTINUE'},
  433: {1: 'IPv6 Address', 2: 'URL', 3: 'SIP URI'},
  449: {1: 'REDIRECT', 2: 'RESTRICT_ACCESS'},
  450: { 1: 'END_USER_IMSI',
         2: 'END_USER_SIP_URI',
         3: 'END_USER_NAI',
         4: 'END_USER_PRIVATE'},
  452: {1: 'UNIT_AFTER_TARIFF_CHANGE', 2: 'UNIT_INDETERMINATE'},
  454: { 1: 'MONEY',
         2: 'TOTAL-OCTETS',
         3: 'INPUT-OCTETS',
         4: 'OUTPUT-OCTETS',
         5: 'SERVICE-SPECIFIC-UNITS'},
  455: {1: 'MULTIPLE_SERVICES_SUPPORTED'},
  459: {1: 'MAC', 2: 'EUI64', 3: 'MODIFIED_EUI64'},
  480: { 1: 'EVENT_RECORD',
         2: 'START_RECORD',
         3: 'INTERIM_RECORD',
         4: 'STOP_RECORD'},
  483: {1: 'DELIVER_AND_GRANT', 2: 'GRANT_AND_STORE', 3: 'GRANT_AND_LOSE'},
  572: {1: 'shape', 2: 'mark', 3: 'permit'},
  575: { 1: 'QoS-Available',
         2: 'QoS-Delivered',
         3: 'Minimum-QoS',
         4: 'QoS-Authorized'},
  582: {1: 'rRK', 2: 'rMSK', 3: 'IKEv2 SK'},
  595: {1: 'INITIAL_REQUEST', 2: 'UPDATE_REQUEST', 3: 'QUERY_REQUEST'},
  604: {1: 'FOLLOW_INTERNAL_PORT_STYLE'},
  606: {1: 'INITIAL_REQUEST', 2: 'UPDATE_REQUEST', 3: 'QUERY_REQUEST'},
  622: {},
  626: {1: 'REALM_REPORT', 2: 'PEER_REPORT'}}

AddrFamNums_dict  = \
{ 1: 'IP (IP version 4)',
  2: 'IP6 (IP version 6)',
  3: 'NSAP',
  4: 'HDLC (8-bit multidrop)',
  5: 'BBN 1822',
  6: '802 (includes all 802 media plus Ethernet "canonical format")',
  7: 'E.163',
  8: 'E.164 (SMDS, Frame Relay, ATM)',
  9: 'F.69 (Telex)',
  10: 'X.121 (X.25, Frame Relay)',
  11: 'IPX',
  12: 'Appletalk',
  13: 'Decnet IV',
  14: 'Banyan Vines',
  15: 'E.164 with NSAP format subaddress',
  16: 'DNS (Domain Name System)',
  17: 'Distinguished Name',
  18: 'AS Number',
  19: 'XTP over IP version 4',
  20: 'XTP over IP version 6',
  21: 'XTP native mode XTP',
  22: 'Fibre Channel World-Wide Port Name',
  23: 'Fibre Channel World-Wide Node Name',
  24: 'GWID',
  25: 'AFI for L2VPN information',
  26: 'MPLS-TP Section Endpoint Identifier',
  27: 'MPLS-TP LSP Endpoint Identifier',
  28: 'MPLS-TP Pseudowire Endpoint Identifier',
  29: 'MT IP: Multi-Topology IP version 4',
  30: 'MT IPv6: Multi-Topology IP version 6',
  16384: 'EIGRP Common Service Family',
  16385: 'EIGRP IPv4 Service Family',
  16386: 'EIGRP IPv6 Service Family',
  16387: 'LISP Canonical Address Format (LCAF)',
  16388: 'BGP-LS',
  16389: '48-bit MAC',
  16390: '64-bit MAC',
  16391: 'OUI',
  16392: 'MAC/24',
  16393: 'MAC/40',
  16394: 'IPv6/64',
  16395: 'RBridge Port ID',
  16396: 'TRILL Nickname',
  16397: 'Universally Unique Identifier (UUID)',
  16398: 'Routing Policy AFI',
  65535: 'Reserved'}

AVPCodes_dict     = \
{ 1: 'User-Name',
  2: 'User-Password',
  3: 'CHAP-Password',
  4: 'NAS-IP-Address',
  5: 'NAS-Port',
  6: 'Service-Type',
  7: 'Framed-Protocol',
  8: 'Framed-IP-Address',
  9: 'Framed-IP-Netmask',
  10: 'Framed-Routing',
  11: 'Filter-Id',
  12: 'Framed-MTU',
  13: 'Framed-Compression',
  14: 'Login-IP-Host',
  15: 'Login-Service',
  16: 'Login-TCP-Port',
  17: 'Unassigned',
  18: 'Reply-Message',
  19: 'Callback-Number',
  20: 'Callback-Id',
  21: 'Unassigned',
  22: 'Framed-Route',
  23: 'Framed-IPX-Network',
  24: 'State',
  25: 'Class',
  26: 'Vendor-Specific',
  27: 'Session-Timeout',
  28: 'Idle-Timeout',
  29: 'Termination-Action',
  30: 'Called-Station-Id',
  31: 'Calling-Station-Id',
  32: 'NAS-Identifier',
  33: 'Proxy-State',
  34: 'Login-LAT-Service',
  35: 'Login-LAT-Node',
  36: 'Login-LAT-Group',
  37: 'Framed-AppleTalk-Link',
  38: 'Framed-AppleTalk-Network',
  39: 'Framed-AppleTalk-Zone',
  40: 'Acct-Status-Type',
  41: 'Acct-Delay-Time',
  42: 'Acct-Input-Octets',
  43: 'Acct-Output-Octets',
  44: 'Acct-Session-Id',
  45: 'Acct-Authentic',
  46: 'Acct-Session-Time',
  47: 'Acct-Input-Packets',
  48: 'Acct-Output-Packets',
  49: 'Acct-Terminate-Cause',
  50: 'Acct-Multi-Session-Id',
  51: 'Acct-Link-Count',
  52: 'Acct-Input-Gigawords',
  53: 'Acct-Output-Gigawords',
  54: 'Unassigned',
  55: 'Event-Timestamp',
  56: 'Egress-VLANID',
  57: 'Ingress-Filters',
  58: 'Egress-VLAN-Name',
  59: 'User-Priority-Table',
  60: 'CHAP-Challenge',
  61: 'NAS-Port-Type',
  62: 'Port-Limit',
  63: 'Login-LAT-Port',
  64: 'Tunnel-Type',
  65: 'Tunnel-Medium-Type',
  66: 'Tunnel-Client-Endpoint',
  67: 'Tunnel-Server-Endpoint',
  68: 'Acct-Tunnel-Connection',
  69: 'Tunnel-Password',
  70: 'ARAP-Password',
  71: 'ARAP-Features',
  72: 'ARAP-Zone-Access',
  73: 'ARAP-Security',
  74: 'ARAP-Security-Data',
  75: 'Password-Retry',
  76: 'Prompt',
  77: 'Connect-Info',
  78: 'Configuration-Token',
  79: 'EAP-Message',
  80: 'Message-Authenticator',
  81: 'Tunnel-Private-Group-ID',
  82: 'Tunnel-Assignment-ID',
  83: 'Tunnel-Preference',
  84: 'ARAP-Challenge-Response',
  85: 'Acct-Interim-Interval',
  86: 'Acct-Tunnel-Packets-Lost',
  87: 'NAS-Port-Id',
  88: 'Framed-Pool',
  89: 'CUI',
  90: 'Tunnel-Client-Auth-ID',
  91: 'Tunnel-Server-Auth-ID',
  92: 'NAS-Filter-Rule',
  93: 'Unassigned',
  94: 'Originating-Line-Info',
  95: 'NAS-IPv6-Address',
  96: 'Framed-Interface-Id',
  97: 'Framed-IPv6-Prefix',
  98: 'Login-IPv6-Host',
  99: 'Framed-IPv6-Route',
  100: 'Framed-IPv6-Pool',
  101: 'Error-Cause Attribute',
  102: 'EAP-Key-Name',
  103: 'Digest-Response',
  104: 'Digest-Realm',
  105: 'Digest-Nonce',
  106: 'Digest-Response-Auth',
  107: 'Digest-Nextnonce',
  108: 'Digest-Method',
  109: 'Digest-URI',
  110: 'Digest-Qop',
  111: 'Digest-Algorithm',
  112: 'Digest-Entity-Body-Hash',
  113: 'Digest-CNonce',
  114: 'Digest-Nonce-Count',
  115: 'Digest-Username',
  116: 'Digest-Opaque',
  117: 'Digest-Auth-Param',
  118: 'Digest-AKA-Auts',
  119: 'Digest-Domain',
  120: 'Digest-Stale',
  121: 'Digest-HA1',
  122: 'SIP-AOR',
  123: 'Delegated-IPv6-Prefix',
  124: 'MIP6-Feature-Vector',
  125: 'MIP6-Home-Link-Prefix',
  126: 'Operator-Name',
  127: 'Location-Information',
  128: 'Location-Data',
  129: 'Basic-Location-Policy-Rules',
  130: 'Extended-Location-Policy-Rules',
  131: 'Location-Capable',
  132: 'Requested-Location-Info',
  133: 'Framed-Management-Protocol',
  134: 'Management-Transport-Protection',
  135: 'Management-Policy-Id',
  136: 'Management-Privilege-Level',
  137: 'PKM-SS-Cert',
  138: 'PKM-CA-Cert',
  139: 'PKM-Config-Settings',
  140: 'PKM-Cryptosuite-List',
  141: 'PKM-SAID',
  142: 'PKM-SA-Descriptor',
  143: 'PKM-Auth-Key',
  144: 'DS-Lite-Tunnel-Name',
  145: 'Mobile-Node-Identifier',
  146: 'Service-Selection',
  147: 'PMIP6-Home-LMA-IPv6-Address',
  148: 'PMIP6-Visited-LMA-IPv6-Address',
  149: 'PMIP6-Home-LMA-IPv4-Address',
  150: 'PMIP6-Visited-LMA-IPv4-Address',
  151: 'PMIP6-Home-HN-Prefix',
  152: 'PMIP6-Visited-HN-Prefix',
  153: 'PMIP6-Home-Interface-ID',
  154: 'PMIP6-Visited-Interface-ID',
  155: 'PMIP6-Home-IPv4-HoA',
  156: 'PMIP6-Visited-IPv4-HoA',
  157: 'PMIP6-Home-DHCP4-Server-Address',
  158: 'PMIP6-Visited-DHCP4-Server-Address',
  159: 'PMIP6-Home-DHCP6-Server-Address',
  160: 'PMIP6-Visited-DHCP6-Server-Address',
  161: 'PMIP6-Home-IPv4-Gateway',
  162: 'PMIP6-Visited-IPv4-Gateway',
  163: 'EAP-Lower-Layer',
  164: 'GSS-Acceptor-Service-Name',
  165: 'GSS-Acceptor-Host-Name',
  166: 'GSS-Acceptor-Service-Specifics',
  167: 'GSS-Acceptor-Realm-Name',
  168: 'Framed-IPv6-Address',
  169: 'DNS-Server-IPv6-Address',
  170: 'Route-IPv6-Information',
  171: 'Delegated-IPv6-Prefix-Pool',
  172: 'Stateful-IPv6-Address-Pool',
  173: 'IPv6-6rd-Configuration',
  174: 'Allowed-Called-Station-Id',
  175: 'EAP-Peer-Id',
  176: 'EAP-Server-Id',
  177: 'Mobility-Domain-Id',
  178: 'Preauth-Timeout',
  179: 'Network-Id-Name',
  180: 'EAPoL-Announcement',
  181: 'WLAN-HESSID',
  182: 'WLAN-Venue-Info',
  183: 'WLAN-Venue-Language',
  184: 'WLAN-Venue-Name',
  185: 'WLAN-Reason-Code',
  186: 'WLAN-Pairwise-Cipher',
  187: 'WLAN-Group-Cipher',
  188: 'WLAN-AKM-Suite',
  189: 'WLAN-Group-Mgmt-Cipher',
  190: 'WLAN-RF-Band',
  191: 'Unassigned',
  241: 'Extended-Attribute-1',
  242: 'Extended-Attribute-2',
  243: 'Extended-Attribute-3',
  244: 'Extended-Attribute-4',
  245: 'Extended-Attribute-5',
  246: 'Extended-Attribute-6',
  256: 'Unassigned',
  257: 'Host-IP-Address',
  258: 'Auth-Application-Id',
  259: 'Acct-Application-Id',
  260: 'Vendor-Specific-Application-Id',
  261: 'Redirect-Host-Usage',
  262: 'Redirect-Max-Cache-Time',
  263: 'Session-Id',
  264: 'Origin-Host',
  265: 'Supported-Vendor-Id',
  266: 'Vendor-Id',
  267: 'Firmware-Version',
  268: 'Result-Code',
  269: 'Product-Name',
  270: 'Session-Binding',
  271: 'Session-Server-Failover',
  272: 'Multi-Round-Time-Out',
  273: 'Disconnect-Cause',
  274: 'Auth-Request-Type',
  276: 'Auth-Grace-Period',
  277: 'Auth-Session-State',
  278: 'Origin-State-Id',
  279: 'Failed-AVP',
  280: 'Proxy-Host',
  281: 'Error-Message',
  282: 'Route-Record',
  283: 'Destination-Realm',
  284: 'Proxy-Info',
  285: 'Re-Auth-Request-Type',
  286: 'Unassigned',
  287: 'Accounting-Sub-Session-Id',
  291: 'Authorization-Lifetime',
  292: 'Redirect-Host',
  293: 'Destination-Host',
  294: 'Error-Reporting-Host',
  295: 'Termination-Cause',
  296: 'Origin-Realm',
  297: 'Experimental-Result',
  298: 'Experimental-Result-Code',
  299: 'Inband-Security-Id',
  300: 'E2E-Sequence',
  301: 'DRMP',
  318: 'MIP-FA-to-HA-SPI',
  319: 'MIP-FA-to-MN-SPI',
  320: 'MIP-Reg-Request',
  321: 'MIP-Reg-Reply',
  322: 'MIP-MN-AAA-Auth',
  323: 'MIP-HA-to-FA-SPI',
  324: 'Unassigned',
  325: 'MIP-MN-to-FA-MSA',
  326: 'MIP-FA-to-MN-MSA',
  327: 'Unassigned',
  328: 'MIP-FA-to-HA-MSA',
  329: 'MIP-HA-to-FA-MSA',
  331: 'MIP-MN-to-HA-MSA',
  332: 'MIP-HA-to-MN-MSA',
  333: 'MIP-Mobile-Node-Address',
  334: 'MIP-Home-Agent-Address',
  335: 'MIP-Nonce',
  336: 'MIP-Candidate-Home-Agent-Host',
  337: 'MIP-Feature-Vector',
  338: 'MIP-Auth-Input-Data-Length',
  339: 'MIP-Authenticator-Length',
  340: 'MIP-Authenticator-Offset',
  341: 'MIP-MN-AAA-SPI',
  342: 'MIP-Filter-Rule',
  343: 'MIP-Session-Key',
  344: 'MIP-FA-Challenge',
  345: 'MIP-Algorithm-Type',
  346: 'MIP-Replay-Mode',
  347: 'MIP-Originating-Foreign-AAA',
  348: 'MIP-Home-Agent-Host',
  363: 'Accounting-Input-Octets',
  364: 'Accounting-Output-Octets',
  365: 'Accounting-Input-Packets',
  366: 'Accounting-Output-Packets',
  367: 'MIP-MSA-Lifetime',
  368: 'SIP-Accounting-Information',
  369: 'SIP-Accounting-Server-URI',
  370: 'SIP-Credit-Control-Server-URI',
  371: 'SIP-Server-URI',
  372: 'SIP-Server-Capabilities',
  373: 'SIP-Mandatory-Capability',
  374: 'SIP-Optional-Capability',
  375: 'SIP-Server-Assignment-Type',
  376: 'SIP-Auth-Data-Item',
  377: 'SIP-Authentication-Scheme',
  378: 'SIP-Item-Number',
  379: 'SIP-Authenticate',
  380: 'SIP-Authorization',
  381: 'SIP-Authentication-Info',
  382: 'SIP-Number-Auth-Items',
  383: 'SIP-Deregistration-Reason',
  384: 'SIP-Reason-Code',
  385: 'SIP-Reason-Info',
  386: 'SIP-Visited-Network-Id',
  387: 'SIP-User-Authorization-Type',
  388: 'SIP-Supported-User-Data-Type',
  389: 'SIP-User-Data',
  390: 'SIP-User-Data-Type',
  391: 'SIP-User-Data-Contents',
  392: 'SIP-User-Data-Already-Available',
  393: 'SIP-Method',
  400: 'NAS-Filter-Rule',
  401: 'Tunneling',
  402: 'CHAP-Auth',
  403: 'CHAP-Algorithm',
  404: 'CHAP-Ident',
  405: 'CHAP-Response',
  406: 'Accounting-Auth-Method',
  407: 'QoS-Filter-Rule',
  408: 'Origin-AAA-Protocol',
  411: 'CC-Correlation-Id',
  412: 'CC-Input-Octets',
  413: 'CC-Money',
  414: 'CC-Output-Octets',
  415: 'CC-Request-Number',
  416: 'CC-Request-Type',
  417: 'CC-Service-Specific-Units',
  418: 'CC-Session-Failover',
  419: 'CC-Sub-Session-Id',
  420: 'CC-Time',
  421: 'CC-Total-Octets',
  422: 'Check-Balance-Result',
  423: 'Cost-Information',
  424: 'Cost-Unit',
  425: 'Currency-Code',
  426: 'Credit-Control',
  427: 'Credit-Control-Failure-Handling',
  428: 'Direct-Debiting-Failure-Handling',
  429: 'Exponent',
  430: 'Final-Unit-Indication',
  431: 'Granted-Service-Unit',
  432: 'Rating-Group',
  433: 'Redirect-Address-Type',
  434: 'Redirect-Server',
  435: 'Redirect-Server-Address',
  436: 'Requested-Action',
  437: 'Requested-Service-Unit',
  438: 'Restriction-Filter-Rule',
  439: 'Service-Identifier',
  440: 'Service-Parameter-Info',
  441: 'Service-Parameter-Type',
  442: 'Service-Parameter-Value',
  443: 'Subscription-Id',
  444: 'Subscription-Id-Data',
  445: 'Unit-Value',
  446: 'Used-Service-Unit',
  447: 'Value-Digits',
  448: 'Validity-Time',
  449: 'Final-Unit-Action',
  450: 'Subscription-Id-Type',
  451: 'Tariff-Time-Change',
  452: 'Tariff-Change-Usage',
  453: 'G-S-U-Pool-Identifier',
  454: 'CC-Unit-Type',
  455: 'Multiple-Services-Indicator',
  456: 'Multiple-Services-Credit-Control',
  457: 'G-S-U-Pool-Reference',
  458: 'User-Equipment-Info',
  459: 'User-Equipment-Info-Type',
  460: 'User-Equipment-Info-Value',
  461: 'Service-Context-Id',
  462: 'EAP-Payload',
  463: 'EAP-Reissued-Payload',
  464: 'EAP-Master-Session-Key',
  465: 'Accounting-EAP-Auth-Method',
  480: 'Accounting-Record-Type',
  483: 'Accounting-Realtime-Required',
  484: 'Unassigned',
  485: 'Accounting-Record-Number',
  486: 'MIP6-Agent-Info',
  487: 'MIP-Careof-Address',
  488: 'MIP-Authenticator',
  489: 'MIP-MAC-Mobility-Data',
  490: 'MIP-Timestamp',
  491: 'MIP-MN-HA-SPI',
  492: 'MIP-MN-HA-MSA',
  493: 'Service-Selection',
  494: 'MIP6-Auth-Mode',
  495: 'TMOD-1',
  496: 'Token-Rate',
  497: 'Bucket-Depth',
  498: 'Peak-Traffic-Rate',
  499: 'Minimum-Policed-Unit',
  500: 'Maximum-Packet-Size',
  501: 'TMOD-2',
  502: 'Bandwidth',
  503: 'PHB-Class',
  504: 'PMIP6-DHCP-Server-Address',
  505: 'PMIP6-IPv4-Home-Address',
  506: 'Mobile-Node-Identifier',
  507: 'Service-Configuration',
  508: 'QoS-Resources',
  509: 'Filter-Rule',
  510: 'Filter-Rule-Precedence',
  511: 'Classifier',
  512: 'Classifier-ID',
  513: 'Protocol',
  514: 'Direction',
  515: 'From-Spec',
  516: 'To-Spec',
  517: 'Negated',
  518: 'IP-Address',
  519: 'IP-Address-Range',
  520: 'IP-Address-Start',
  521: 'IP-Address-End',
  522: 'IP-Address-Mask',
  523: 'IP-Mask-Bit-Mask-Width',
  524: 'MAC-Address',
  525: 'MAC-Address-Mask',
  526: 'MAC-Address-Mask-Pattern',
  527: 'EUI64-Address',
  528: 'EUI64-Address-Mask',
  529: 'EUI64-Address-Mask-Pattern',
  530: 'Port',
  531: 'Port-Range',
  532: 'Port-Start',
  533: 'Port-End',
  534: 'Use-Assigned-Address',
  535: 'Diffserv-Code-Point',
  536: 'Fragmentation-Flag',
  537: 'IP-Option',
  538: 'IP-Option-Type',
  539: 'IP-Option-Value',
  540: 'TCP-Option',
  541: 'TCP-Option-Type',
  542: 'TCP-Option-Value',
  543: 'TCP-Flags',
  544: 'TCP-Flag-Type',
  545: 'ICMP-Type',
  546: 'ICMP-Type-Number',
  547: 'ICMP-Code',
  548: 'ETH-Option',
  549: 'ETH-Proto-Type',
  550: 'ETH-Ether-Type',
  551: 'ETH-SAP',
  552: 'VLAN-ID-Range',
  553: 'S-VID-Start',
  554: 'S-VID-End',
  555: 'C-VID-Start',
  556: 'C-VID-End',
  557: 'User-Priority-Range',
  558: 'Low-User-Priority',
  559: 'High-User-Priority',
  560: 'Time-Of-Day-Condition',
  561: 'Time-Of-Day-Start',
  562: 'Time-Of-Day-End',
  563: 'Day-Of-Week-Mask',
  564: 'Day-Of-Month-Mask',
  565: 'Month-Of-Year-Mask',
  566: 'Absolute-Start-Time',
  567: 'Absolute-Start-Fractional-Seconds',
  568: 'Absolute-End-Time',
  569: 'Absolute-End-Fractional-Seconds',
  570: 'Timezone-Flag',
  571: 'Timezone-Offset',
  572: 'Treatment-Action',
  573: 'QoS-Profile-Id',
  574: 'QoS-Profile-Template',
  575: 'QoS-Semantics',
  576: 'QoS-Parameters',
  577: 'Excess-Treatment',
  578: 'QoS-Capability',
  579: 'QoS-Authorization-Data',
  580: 'Bound-Auth-Session-Id',
  581: 'Key',
  582: 'Key-Type',
  583: 'Keying-Material',
  584: 'Key-Lifetime',
  585: 'Key-SPI',
  586: 'Key-Name',
  587: 'IKEv2-Nonces',
  588: 'Ni',
  589: 'Nr',
  590: 'IKEv2-Identity',
  591: 'Initiator-Identity',
  592: 'ID-Type',
  593: 'Identification-Data',
  594: 'Responder-Identity',
  595: 'NC-Request-Type',
  596: 'NAT-Control-Install',
  597: 'NAT-Control-Remove',
  598: 'NAT-Control-Definition',
  599: 'NAT-Internal-Address',
  600: 'NAT-External-Address',
  601: 'Max-NAT-Bindings',
  602: 'NAT-Control-Binding-Template',
  603: 'Duplicate-Session-Id',
  604: 'NAT-External-Port-Style',
  605: 'NAT-Control-Record',
  606: 'NAT-Control-Binding-Status',
  607: 'Current-NAT-Bindings',
  608: 'Dual-Priority',
  609: 'Preemption-Priority',
  610: 'Defending-Priority',
  611: 'Admission-Priority',
  612: 'SIP-Resource-Priority',
  613: 'SIP-Resource-Priority-Namespace',
  614: 'SIP-Resource-Priority-Value',
  615: 'Application-Level-Resource-Priority',
  616: 'ALRP-Namespace',
  617: 'ALRP-Value',
  618: 'ERP-RK-Request',
  619: 'ERP-Realm',
  620: 'Redirect-Realm',
  621: 'OC-Supported-Features',
  622: 'OC-Feature-Vector',
  623: 'OC-OLR',
  624: 'OC-Sequence-Number',
  625: 'OC-Validity-Duration',
  626: 'OC-Report-Type',
  627: 'OC-Reduction-Percentage',
  628: 'ECN-IP-Codepoint',
  629: 'Congestion-Treatment',
  630: 'Flow-Count',
  631: 'Packet-Count',
  632: 'IP-Prefix-Length',
  633: 'Border-Router-Name',
  634: '64-Multicast-Attributes',
  635: 'ASM-mPrefix64',
  636: 'SSM-mPrefix64',
  637: 'Tunnel-Source-Pref-Or-Addr',
  638: 'Tunnel-Source-IPv6-Address',
  639: 'Port-Set-Identifier',
  640: 'Lw4o6-Binding',
  641: 'Lw4o6-External-IPv4-Addr',
  642: 'MAP-E-Attributes',
  643: 'MAP-Mesh-Mode',
  644: 'MAP-Mapping-Rule',
  645: 'Rule-IPv4-Addr-Or-Prefix',
  646: 'Rule-IPv6-Prefix',
  647: 'EA-Field-Length',
  648: 'OC-Peer-Algo',
  649: 'SourceID',
  650: 'Load',
  651: 'Load-Type',
  652: 'Load-Value',
  653: 'User-Equipment-Info-Extension',
  654: 'User-Equipment-Info-IMEISV',
  655: 'User-Equipment-Info-MAC',
  656: 'User-Equipment-Info-EUI64',
  657: 'User-Equipment-Info-ModifiedEUI64',
  658: 'User-Equipment-Info-IMEI',
  659: 'Subscription-Id-Extension',
  660: 'Subscription-Id-E164',
  661: 'Subscription-Id-IMSI',
  662: 'Subscription-Id-SIP-URI',
  663: 'Subscription-Id-NAI',
  664: 'Subscription-Id-Private',
  665: 'Redirect-Server-Extension',
  666: 'Redirect-Address-IPAddress',
  667: 'Redirect-Address-URL',
  668: 'Redirect-Address-SIP-URI',
  669: 'QoS-Final-Unit-Indication',
  670: 'OC-Maximum-Rate'}

