import re
from pathlib import Path

import click

# The default templates have been copied from the "Create New Algorithm" feature in the Algorithm Lab

DEFAULT_PYTHON_MAIN = """
class $NAME$(QCAlgorithm):

    def Initialize(self):
        self.SetStartDate(2020, 8, 2)  # Set Start Date
        self.SetCash(100000)  # Set Strategy Cash
        # self.AddEquity("SPY", Resolution.Minute)


    def OnData(self, data):
        '''OnData event is the primary entry point for your algorithm. Each new data point will be pumped in here.
            Arguments:
                data: Slice object keyed by symbol containing the stock data
        '''

        # if not self.Portfolio.Invested:
        #    self.SetHoldings("SPY", 1)
""".strip() + "\n"

DEFAULT_PYTHON_NOTEBOOK = """
{
 "cells": [
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "![QuantConnect Logo](https://cdn.quantconnect.com/web/i/icon.png)\n",
    "<hr>"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 22,
   "metadata": {},
   "outputs": [
    {
     "data": {
      "text/plain": [
       "<matplotlib.axes._subplots.AxesSubplot at 0x7ff0d5d81128>"
      ]
     },
     "execution_count": 22,
     "metadata": {},
     "output_type": "execute_result"
    },
    {
     "data": {
      "image/png": "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\n",
      "text/plain": [
       "<Figure size 432x288 with 1 Axes>"
      ]
     },
     "metadata": {
      "needs_background": "light"
     },
     "output_type": "display_data"
    }
   ],
   "source": [
    "# QuantBook Analysis Tool \n",
    "# For more information see [https://www.quantconnect.com/docs/research/overview]\n",
    "qb = QuantBook()\n",
    "spy = qb.AddEquity(\"SPY\")\n",
    "history = qb.History(qb.Securities.Keys, 360, Resolution.Daily)\n",
    "\n",
    "# Indicator Analysis\n",
    "bbdf = qb.Indicator(BollingerBands(30, 2), spy.Symbol, 360, Resolution.Daily)\n",
    "bbdf.drop('standarddeviation', 1).plot()"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": null,
   "metadata": {},
   "outputs": [],
   "source": []
  }
 ],
 "metadata": {
  "kernelspec": {
   "display_name": "Python 3",
   "language": "python",
   "name": "python3"
  },
  "language_info": {
   "codemirror_mode": {
    "name": "ipython",
    "version": 3
   },
   "file_extension": ".py",
   "mimetype": "text/x-python",
   "name": "python",
   "nbconvert_exporter": "python",
   "pygments_lexer": "ipython3",
   "version": "3.6.8"
  }
 },
 "nbformat": 4,
 "nbformat_minor": 2
}
""".strip() + "\n"

DEFAULT_CSHARP_MAIN = """
namespace QuantConnect.Algorithm.CSharp
{
    public class $NAME$ : QCAlgorithm
    {

        public override void Initialize()
        {
            SetStartDate(2020, 8, 2);  //Set Start Date
            SetCash(100000);             //Set Strategy Cash
            
            // AddEquity("SPY", Resolution.Minute);


        }

        /// OnData event is the primary entry point for your algorithm. Each new data point will be pumped in here.
        /// Slice object keyed by symbol containing the stock data
        public override void OnData(Slice data)
        {
            // if (!Portfolio.Invested)
            // {
            //    SetHoldings("SPY", 1);
            //    Debug("Purchased Stock");
            //}
        }

    }
}
""".strip() + "\n"

DEFAULT_CSHARP_NOTEBOOK = """
{
 "cells": [
  {
   "cell_type": "markdown",
   "metadata": {},
   "source": [
    "![QuantConnect Logo](https://cdn.quantconnect.com/web/i/icon.png)\n",
    "<hr>"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 19,
   "metadata": {},
   "outputs": [],
   "source": [
    "// QuantBook C# Research Environment\n",
    "// For more information see https://www.quantconnect.com/docs/research/overview\n",
    "#load \"../QuantConnect.csx\"\n",
    "var qb = new QuantBook();\n",
    "var spy = qb.AddEquity(\"SPY\");\n",
    "var history = qb.History(qb.Securities.Keys, 360, Resolution.Daily);"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": 20,
   "metadata": {},
   "outputs": [],
   "source": [
    "foreach(var slice in history.Take(5)) {\n",
    "    Console.WriteLine(slice.Bars[spy.Symbol].ToString());\n",
    "}"
   ]
  },
  {
   "cell_type": "code",
   "execution_count": null,
   "metadata": {},
   "outputs": [],
   "source": []
  }
 ],
 "metadata": {
  "kernelspec": {
   "display_name": "C#",
   "language": "csharp",
   "name": "csharp"
  },
  "language_info": {
   "file_extension": ".cs",
   "mimetype": "text/x-csharp",
   "name": "C#",
   "pygments_lexer": "c#",
   "version": "4.0.30319"
  },
  "pycharm": {
   "stem_cell": {
    "cell_type": "raw",
    "source": [],
    "metadata": {
     "collapsed": false
    }
   }
  }
 },
 "nbformat": 4,
 "nbformat_minor": 2
}
""".strip() + "\n"


@click.command()
@click.argument("name", type=str)
@click.option("--language", "-l",
              type=click.Choice(["python", "csharp"], case_sensitive=False),
              help="The language of the project to create")
def create_project(name: str, language: str) -> None:
    """Create a new project containing starter code.

    If NAME is a path containing subdirectories those will be created automatically.
    """
    full_path = Path.cwd() / name

    if full_path.exists():
        raise click.ClickException(f"A project named '{name}' already exists")

    if not full_path.exists():
        full_path.mkdir(parents=True)

    # Convert the project name into a valid class name by removing all non-alphanumeric characters
    class_name = re.sub(f"[^a-zA-Z0-9]", "", full_path.name)

    if language == "python":
        with open(full_path / "main.py", "w+") as file:
            file.write(DEFAULT_PYTHON_MAIN.replace("$NAME$", class_name))
    else:
        with open(full_path / "Main.cs", "w+") as file:
            file.write(DEFAULT_CSHARP_MAIN.replace("$NAME$", class_name))

    with open(full_path / "research.ipynb", "w+") as file:
        file.write(DEFAULT_PYTHON_NOTEBOOK if language == "python" else DEFAULT_CSHARP_NOTEBOOK)

    click.echo(f"Successfully created project '{name}'")
