# -*- coding: utf-8 -*-

"""Data containing emoji mapper retrieved from https://emojiterra.com
   and https://unicode.org/Public/emoji/14.0/emoji-test.txt"""

__all__ = ["EMOJI_DATA"]

EMOJI_DATA = {
    "\U0001F600": {
        "en": "grinning_face",
        "id": "wajah_gembira",
        "alias": "wajah_gembira_bahagia_muka_senang",
    },
    "\U0001F603": {
        "en": "grinning_face_with_big_eyes",
        "id": "wajah_tersenyum_lebar",
        "alias": "wajah_tersenyum_lebar_muka_mulut_senyum_terbuka",
    },
    "\U0001F604": {
        "en": "grinning_face_with_smiling_eyes",
        "id": "wajah_tersenyum_lebar_dan_mata_tertutup",
        "alias": "wajah_tersenyum_lebar_dan_mata_tertutup_muka_mulut_senyum_terbuka",
    },
    "\U0001F601": {
        "en": "beaming_face_with_smiling_eyes",
        "id": "wajah_gembira_dengan_mata_bahagia",
        "alias": "wajah_gembira_dengan_mata_bahagia_cengiran_muka_senyum_tersenyum_lebar",
    },
    "\U0001F606": {
        "en": "grinning_squinting_face",
        "id": "wajah_tersenyum_lebar_dan_memejamkan_mata",
        "alias": "wajah_tersenyum_lebar_dan_memejamkan_mata_mulut_puas_senyum_tertawa",
    },
    "\U0001F605": {
        "en": "grinning_face_with_sweat",
        "id": "wajah_tersenyum_lebar_dan_berkeringat",
        "alias": "wajah_tersenyum_lebar_dan_berkeringat_dingin_keringat_muka_senyum_terbuka",
    },
    "\U0001F923": {
        "en": "rolling_on_the_floor_laughing",
        "id": "tertawa_terbahak-bahak",
        "alias": "tertawa_terbahak-bahak_kocak_lucu_ngakak",
    },
    "\U0001F602": {
        "en": "face_with_tears_of_joy",
        "id": "wajah_gembira_berurai_air_mata",
        "alias": "wajah_gembira_berurai_air_mata_bahagia_tertawa_dengan",
    },
    "\U0001F642": {
        "en": "slightly_smiling_face",
        "id": "wajah_agak_tersenyum",
        "alias": "wajah_agak_tersenyum_muka_senyum",
    },
    "\U0001F643": {
        "en": "upside-down_face",
        "id": "wajah_terbalik",
        "alias": "wajah_terbalik_muka",
    },
    "\U0001F609": {
        "en": "winking_face",
        "id": "wajah_berkedip",
        "alias": "wajah_berkedip_kedip_muka",
    },
    "\U0001F60A": {
        "en": "smiling_face_with_smiling_eyes",
        "id": "wajah_tersenyum_dengan_mata_bahagia",
        "alias": "wajah_tersenyum_dengan_mata_bahagia_muka_senyum_tersipu",
    },
    "\U0001F607": {
        "en": "smiling_face_with_halo",
        "id": "wajah_malaikat",
        "alias": "wajah_malaikat_fantasi_halo_lugu_tersenyum",
    },
    "\U0001F970": {
        "en": "smiling_face_with_hearts",
        "id": "wajah_tersenyum_dengan_3_hati",
        "alias": "wajah_tersenyum_dengan_3_hati_jatuh_cinta_memuja_naksir",
    },
    "\U0001F60D": {
        "en": "smiling_face_with_heart-eyes",
        "id": "wajah_tersenyum_lebar_bermata_hati",
        "alias": "wajah_tersenyum_lebar_bermata_hati_cinta_mata_senyum",
    },
    "\U0001F929": {
        "en": "star-struck",
        "id": "wajah_dengan_mata_berbentuk_bintang",
        "alias": "wajah_dengan_mata_berbentuk_bintang_menyeringai",
    },
    "\U0001F618": {
        "en": "face_blowing_a_kiss",
        "id": "wajah_memberikan_ciuman_jauh",
        "alias": "wajah_memberikan_ciuman_jauh_cium_hati_muka",
    },
    "\U0001F617": {
        "en": "kissing_face",
        "id": "wajah_memberikan_ciuman",
        "alias": "wajah_memberikan_ciuman_cium_muka",
    },
    "\U0000263A\U0000FE0F": {
        "en": "smiling_face",
        "id": "wajah_tersenyum",
        "alias": "wajah_tersenyum_muka_rileks_santai_senyum_tersipu",
    },
    "\U0001F61A": {
        "en": "kissing_face_with_closed_eyes",
        "id": "wajah_memberikan_ciuman_dengan_mata_tertutup",
        "alias": "wajah_memberikan_ciuman_dengan_mata_tertutup_cium_muka_tutup",
    },
    "\U0001F619": {
        "en": "kissing_face_with_smiling_eyes",
        "id": "wajah_memberikan_ciuman_dengan_mata_bahagia",
        "alias": "wajah_memberikan_ciuman_dengan_mata_bahagia_cium_muka_senyum",
    },
    "\U0001F972": {
        "en": "smiling_face_with_tear",
        "id": "wajah_tersenyum_dengan_air_mata",
        "alias": "wajah_tersenyum_dengan_air_mata_bangga_bersyukur_lega_tersentuh",
    },
    "\U0001F60B": {
        "en": "face_savoring_food",
        "id": "wajah_menikmati",
        "alias": "wajah_menikmati_lezat_nyam_senyum_makanan",
    },
    "\U0001F61B": {
        "en": "face_with_tongue",
        "id": "wajah_menjulurkan_lidah",
        "alias": "wajah_menjulurkan_lidah_muka",
    },
    "\U0001F61C": {
        "en": "winking_face_with_tongue",
        "id": "wajah_menjulurkan_lidah_dan_mengedipkan_mata",
        "alias": "wajah_menjulurkan_lidah_dan_mengedipkan_mata_kedip_lelucon_mengedip_dengan",
    },
    "\U0001F92A": {
        "en": "zany_face",
        "id": "wajah_konyol",
        "alias": "wajah_konyol_besar_bodoh_kecil_mata",
    },
    "\U0001F61D": {
        "en": "squinting_face_with_tongue",
        "id": "wajah_menjulurkan_lidah_dan_memejamkan_mata",
        "alias": "wajah_menjulurkan_lidah_dan_memejamkan_mata_menjijikan_rasa",
    },
    "\U0001F911": {
        "en": "money-mouth_face",
        "id": "wajah_materialistis",
        "alias": "wajah_materialistis_matre_muka_mulut_uang",
    },
    "\U0001F917": {
        "en": "hugging_face",
        "id": "wajah_memeluk",
        "alias": "wajah_memeluk_muka_peluk",
    },
    "\U0001F92D": {
        "en": "face_with_hand_over_mouth",
        "id": "wajah_dengan_tangan_menutup_mulut",
        "alias": "wajah_dengan_tangan_menutup_mulut_ups",
    },
    "\U0001F92B": {
        "en": "shushing_face",
        "id": "wajah_menyuruh_diam",
        "alias": "wajah_menyuruh_diam_jangan_berisik_ssst_sst",
    },
    "\U0001F914": {
        "en": "thinking_face",
        "id": "wajah_berpikir",
        "alias": "wajah_berpikir_mikir_muka_pikir",
    },
    "\U0001F910": {
        "en": "zipper-mouth_face",
        "id": "wajah_dengan_mulut_tertutup_rapat",
        "alias": "wajah_dengan_mulut_tertutup_rapat_muka",
    },
    "\U0001F928": {
        "en": "face_with_raised_eyebrow",
        "id": "wajah_dengan_alis_terangkat",
        "alias": "wajah_dengan_alis_terangkat_ragu_skeptis_tidak_percaya",
    },
    "\U0001F610": {"en": "neutral_face", "id": "wajah_netral", "alias": "wajah_netral_datar_muka"},
    "\U0001F611": {
        "en": "expressionless_face",
        "id": "wajah_tanpa_ekspresi",
        "alias": "wajah_tanpa_ekspresi_datar_lempeng_muka",
    },
    "\U0001F636": {
        "en": "face_without_mouth",
        "id": "wajah_tanpa_mulut",
        "alias": "wajah_tanpa_mulut_diam_muka_tenang",
    },
    "\U0001F636\U0000200D\U0001F32B\U0000FE0F": {
        "en": "face_in_clouds",
        "id": "wajah_dikelilingi_awan",
    },
    "\U0001F60F": {
        "en": "smirking_face",
        "id": "wajah_tersenyum_sombong",
        "alias": "wajah_tersenyum_sombong_seringai_menyeringai",
    },
    "\U0001F612": {"en": "unamused_face", "id": "wajah_bosan", "alias": "wajah_bosan_muka"},
    "\U0001F644": {
        "en": "face_with_rolling_eyes",
        "id": "wajah_dengan_mata_ke_atas",
        "alias": "wajah_dengan_mata_ke_atas_berputar_muka",
    },
    "\U0001F62C": {
        "en": "grimacing_face",
        "id": "wajah_menyeringai",
        "alias": "wajah_menyeringai_muka_seringai",
    },
    "\U0001F62E\U0000200D\U0001F4A8": {"en": "face_exhaling", "id": "wajah_mengembuskan_napas"},
    "\U0001F925": {"en": "lying_face", "id": "bohong", "alias": "bohong_muka_pinokio_wajah"},
    "\U0001F60C": {"en": "relieved_face", "id": "wajah_lega", "alias": "wajah_lega_muka"},
    "\U0001F614": {
        "en": "pensive_face",
        "id": "wajah_merenung",
        "alias": "wajah_merenung_muka_murung_sedih_termenung",
    },
    "\U0001F62A": {
        "en": "sleepy_face",
        "id": "wajah_mengantuk",
        "alias": "wajah_mengantuk_muka_ngantuk",
    },
    "\U0001F924": {"en": "drooling_face", "id": "ngiler", "alias": "ngiler_pengen_wajah"},
    "\U0001F634": {"en": "sleeping_face", "id": "wajah_tidur", "alias": "wajah_tidur_muka_zzz"},
    "\U0001F637": {
        "en": "face_with_medical_mask",
        "id": "wajah_bermasker",
        "alias": "wajah_bermasker_dokter_flu_masker_sakit",
    },
    "\U0001F912": {
        "en": "face_with_thermometer",
        "id": "wajah_bertermometer",
        "alias": "wajah_bertermometer_muka_sakit_termometer",
    },
    "\U0001F915": {
        "en": "face_with_head-bandage",
        "id": "wajah_diperban_di_kepala",
        "alias": "wajah_diperban_di_kepala_cedera_luka_muka_perban",
    },
    "\U0001F922": {"en": "nauseated_face", "id": "mual", "alias": "mual_muka_muntah_wajah"},
    "\U0001F92E": {"en": "face_vomiting", "id": "wajah_muntah", "alias": "wajah_muntah_sakit"},
    "\U0001F927": {"en": "sneezing_face", "id": "bersin", "alias": "bersin_muka_wajah"},
    "\U0001F975": {
        "en": "hot_face",
        "id": "wajah_kepanasan",
        "alias": "wajah_kepanasan_berkeringat_demam_muka_merah_panas",
    },
    "\U0001F976": {
        "en": "cold_face",
        "id": "wajah_kedinginan",
        "alias": "wajah_kedinginan_es_menggigil_radang_dingin_biru",
    },
    "\U0001F974": {
        "en": "woozy_face",
        "id": "wajah_pusing_karena_mabuk",
        "alias": "wajah_pusing_karena_mabuk_agak_mata_miring_mulut_keriting",
    },
    "\U0001f635": {"en": "knocked-out_face", "id": "wajah_pusing", "alias": "wajah_pusing_muka"},
    "\U0001F635\U0000200D\U0001F4AB": {
        "en": "face_with_spiral_eyes",
        "id": "wajah_dengan_mata_berputar",
    },
    "\U0001F92F": {
        "en": "exploding_head",
        "id": "kepala_meledak",
        "alias": "kepala_meledak_kaget_takjub_terkejut",
    },
    "\U0001F920": {
        "en": "cowboy_hat_face",
        "id": "wajah_koboi",
        "alias": "wajah_koboi_cowboy_cowgirl_topi",
    },
    "\U0001F973": {
        "en": "partying_face",
        "id": "wajah_pesta",
        "alias": "wajah_pesta_perayaan_terompet_topi",
    },
    "\U0001F978": {
        "en": "disguised_face",
        "id": "wajah_menyamar",
        "alias": "wajah_menyamar_hidung_kacamata_penyamaran",
    },
    "\U0001F60E": {
        "en": "smiling_face_with_sunglasses",
        "id": "wajah_berkacamata_hitam",
        "alias": "wajah_berkacamata_hitam_kacamata_keren_matahari_pintar_tersenyum_memakai",
    },
    "\U0001F913": {"en": "nerd_face", "id": "wajah_kutu_buku", "alias": "wajah_kutu_buku_muka"},
    "\U0001F9D0": {
        "en": "face_with_monocle",
        "id": "wajah_dengan_monokel",
        "alias": "wajah_dengan_monokel_pengap_sesak",
    },
    "\U0001F615": {"en": "confused_face", "id": "wajah_bingung", "alias": "wajah_bingung_muka"},
    "\U0001F61F": {
        "en": "worried_face",
        "id": "wajah_cemas",
        "alias": "wajah_cemas_khawatir_kuatir_muka",
    },
    "\U0001F641": {
        "en": "slightly_frowning_face",
        "id": "wajah_agak_cemberut",
        "alias": "wajah_agak_cemberut_muka",
    },
    "\U00002639\U0000FE0F": {
        "en": "frowning_face",
        "id": "wajah_cemberut",
        "alias": "wajah_cemberut_muka",
    },
    "\U0001F62E": {
        "en": "face_with_open_mouth",
        "id": "wajah_dengan_mulut_terbuka",
        "alias": "wajah_dengan_mulut_terbuka_muka_simpati",
    },
    "\U0001F62F": {
        "en": "hushed_face",
        "id": "wajah_hening",
        "alias": "wajah_hening_kaget_muka_terdiam_terkejut",
    },
    "\U0001F632": {
        "en": "astonished_face",
        "id": "wajah_terpukau",
        "alias": "wajah_terpukau_kaget_muka_takjub_terkejut",
    },
    "\U0001F633": {"en": "flushed_face", "id": "wajah_tersipu", "alias": "wajah_tersipu_muka"},
    "\U0001F97A": {
        "en": "pleading_face",
        "id": "wajah_memelas",
        "alias": "wajah_memelas_kasihan_mata_memohon",
    },
    "\U0001F626": {
        "en": "frowning_face_with_open_mouth",
        "id": "wajah_mengerutkan_kening_dengan_mulut_terbuka",
        "alias": "wajah_mengerutkan_kening_dengan_mulut_terbuka_cemberut_muka_nganga",
    },
    "\U0001F627": {
        "en": "anguished_face",
        "id": "wajah_menderita",
        "alias": "wajah_menderita_merana_muka_sengsara",
    },
    "\U0001F628": {
        "en": "fearful_face",
        "id": "wajah_ketakutan",
        "alias": "wajah_ketakutan_muka_ngeri_seram_takut",
    },
    "\U0001F630": {
        "en": "anxious_face_with_sweat",
        "id": "wajah_ketakutan_berkeringat",
        "alias": "wajah_ketakutan_berkeringat_biru_buru-buru_dingin_keringat_dengan",
    },
    "\U0001F625": {
        "en": "sad_but_relieved_face",
        "id": "wajah_kecewa_namun_lega",
        "alias": "wajah_kecewa_namun_lega_fiuh_muka",
    },
    "\U0001F622": {
        "en": "crying_face",
        "id": "wajah_menangis",
        "alias": "wajah_menangis_air_mata_muka_nangis_sedih",
    },
    "\U0001F62D": {
        "en": "loudly_crying_face",
        "id": "wajah_menangis_keras",
        "alias": "wajah_menangis_keras_bombay_muka_nangis_sedih_tersedu-sedu",
    },
    "\U0001F631": {
        "en": "face_screaming_in_fear",
        "id": "wajah_sangat_ketakutan",
        "alias": "wajah_sangat_ketakutan_berteriak_mengunyah_takut",
    },
    "\U0001F616": {
        "en": "confounded_face",
        "id": "wajah_stres",
        "alias": "wajah_stres_gelisah_muka_pusing",
    },
    "\U0001F623": {
        "en": "persevering_face",
        "id": "wajah_tidak_setuju",
        "alias": "wajah_tidak_setuju_muka_ngotot",
    },
    "\U0001F61E": {"en": "disappointed_face", "id": "wajah_kecewa"},
    "\U0001F613": {
        "en": "downcast_face_with_sweat",
        "id": "wajah_berkeringat",
        "alias": "wajah_berkeringat_dingin_keringat_muka",
    },
    "\U0001F629": {
        "en": "weary_face",
        "id": "wajah_terlalu_lelah",
        "alias": "wajah_terlalu_lelah_capek_muka",
    },
    "\U0001F62B": {
        "en": "tired_face",
        "id": "wajah_kelelahan",
        "alias": "wajah_kelelahan_capek_lelah_muka",
    },
    "\U0001F971": {
        "en": "yawning_face",
        "id": "wajah_menguap",
        "alias": "wajah_menguap_bosan_lelah",
    },
    "\U0001F624": {
        "en": "face_with_steam_from_nose",
        "id": "wajah_bersungguh-sungguh",
        "alias": "wajah_bersungguh-sungguh_menang_muka_niat",
    },
    "\U0001F621": {
        "en": "pouting_face",
        "id": "wajah_sangat_marah",
        "alias": "wajah_sangat_marah_merah_muka_ngamuk",
    },
    "\U0001F620": {"en": "angry_face", "id": "wajah_marah", "alias": "wajah_marah_muka"},
    "\U0001F92C": {
        "en": "face_with_symbols_on_mouth",
        "id": "wajah_dengan_simbol_pada_mulut",
        "alias": "wajah_dengan_simbol_pada_mulut_mengumpat_ngamuk",
    },
    "\U0001F608": {
        "en": "smiling_face_with_horns",
        "id": "wajah_tersenyum_bertanduk",
        "alias": "wajah_tersenyum_bertanduk_dongeng_fantasi_muka_senyum_tanduk",
    },
    "\U0001F47F": {
        "en": "angry_face_with_horns",
        "id": "wajah_marah_dengan_tanduk",
        "alias": "wajah_marah_dengan_tanduk_belis_fantasi_iblis_muka_setan_bertanduk",
    },
    "\U0001F480": {
        "en": "skull",
        "id": "tengkorak",
        "alias": "tengkorak_dongeng_mati_mayat_monster_muka_wajah",
    },
    "\U00002620\U0000FE0F": {
        "en": "skull_and_crossbones",
        "id": "tengkorak_dan_tulang",
        "alias": "tengkorak_dan_tulang_kematian_monster_wajah",
    },
    "\U0001F4A9": {"en": "pile_of_poo", "id": "kotoran", "alias": "kotoran_muka_tahi_tinja_wajah"},
    "\U0001F921": {"en": "clown_face", "id": "badut", "alias": "badut_konyol_lucu_muka_wajah"},
    "\U0001F479": {
        "en": "ogre",
        "id": "wajah_monster",
        "alias": "wajah_monster_dongeng_fantasi_makhluk",
    },
    "\U0001F47A": {
        "en": "goblin",
        "id": "topeng_hidung_panjang",
        "alias": "topeng_hidung_panjang_fantasi_khayalan_makhluk_monster_wajah",
    },
    "\U0001F47B": {
        "en": "ghost",
        "id": "hantu",
        "alias": "hantu_arwah_dongeng_fantasi_monster_muka_wajah",
    },
    "\U0001F47D": {
        "en": "alien",
        "id": "alien",
        "alias": "alien_ekstraterestrial_fantasi_makhluk_ufo_wajah",
    },
    "\U0001F47E": {
        "en": "alien_monster",
        "id": "monster_alien",
        "alias": "monster_alien_ekstraterestrial_makhluk_ufo_wajah",
    },
    "\U0001F916": {"en": "robot", "id": "robot", "alias": "robot_monster_muka_wajah"},
    "\U0001F63A": {
        "en": "grinning_cat",
        "id": "wajah_kucing_tersenyum_lebar",
        "alias": "wajah_kucing_tersenyum_lebar_muka_mulut_senyum_terbuka",
    },
    "\U0001F638": {
        "en": "grinning_cat_with_smiling_eyes",
        "id": "wajah_kucing_gembira_dengan_mata_bahagia",
        "alias": "wajah_kucing_gembira_dengan_mata_bahagia_muka_senyum_seringai",
    },
    "\U0001F639": {
        "en": "cat_with_tears_of_joy",
        "id": "wajah_kucing_gembira_berurai_air_mata",
        "alias": "wajah_kucing_gembira_berurai_air_mata_bahagia_muka_senang",
    },
    "\U0001F63B": {
        "en": "smiling_cat_with_heart-eyes",
        "id": "wajah_kucing_gembira_bermata_hati",
        "alias": "wajah_kucing_gembira_bermata_hati_cinta_mata_muka_senyum",
    },
    "\U0001F63C": {
        "en": "cat_with_wry_smile",
        "id": "wajah_kucing_tersenyum_sombong",
        "alias": "wajah_kucing_tersenyum_sombong_ejek_muka_senyum_sinis",
    },
    "\U0001F63D": {
        "en": "kissing_cat",
        "id": "wajah_kucing_memberikan_ciuman_dengan_mata_tertutup",
        "alias": "wajah_kucing_memberikan_ciuman_dengan_mata_tertutup_cium_muka",
    },
    "\U0001F640": {
        "en": "weary_cat",
        "id": "wajah_kucing_ketakutan",
        "alias": "wajah_kucing_ketakutan_kaget_lelah_muka_oh_takut",
    },
    "\U0001F63F": {
        "en": "crying_cat",
        "id": "wajah_kucing_menangis",
        "alias": "wajah_kucing_menangis_air_mata_muka_nangis_sedih",
    },
    "\U0001F63E": {
        "en": "pouting_cat",
        "id": "wajah_kucing_marah",
        "alias": "wajah_kucing_marah_muka",
    },
    "\U0001F648": {
        "en": "see-no-evil_monkey",
        "id": "tidak_melihat",
        "alias": "tidak_melihat_dilarang_jahat_lihat_monyet_wajah",
    },
    "\U0001F649": {
        "en": "hear-no-evil_monkey",
        "id": "tidak_mendengar",
        "alias": "tidak_mendengar_dengar_dilarang_jahat_monyet_wajah",
    },
    "\U0001F64A": {
        "en": "speak-no-evil_monkey",
        "id": "tidak_bicara",
        "alias": "tidak_bicara_dilarang_jahat_monyet_berbicara_wajah",
    },
    "\U0001F48B": {
        "en": "kiss_mark",
        "id": "tanda_ciuman",
        "alias": "tanda_ciuman_bibir_cium_hati_romantis",
    },
    "\U0001F48C": {"en": "love_letter", "id": "surat_cinta", "alias": "surat_cinta_hati_romantis"},
    "\U0001F498": {
        "en": "heart_with_arrow",
        "id": "hati_terpanah",
        "alias": "hati_terpanah_asmara_panah_romantis",
    },
    "\U0001F49D": {
        "en": "heart_with_ribbon",
        "id": "hati_berpita",
        "alias": "hati_berpita_pita_valentine",
    },
    "\U0001F496": {
        "en": "sparkling_heart",
        "id": "hati_bersinar",
        "alias": "hati_bersinar_bahagia",
    },
    "\U0001F497": {
        "en": "growing_heart",
        "id": "hati_membesar",
        "alias": "hati_membesar_deg_detak_gembira_gugup_jantung",
    },
    "\U0001F493": {
        "en": "beating_heart",
        "id": "hati_berdetak",
        "alias": "hati_berdetak_denyut_detak_jantung",
    },
    "\U0001F49E": {"en": "revolving_hearts", "id": "hati_berputar"},
    "\U0001F495": {"en": "two_hearts", "id": "dua_hati", "alias": "dua_hati_cinta"},
    "\U0001F49F": {"en": "heart_decoration", "id": "dekorasi_hati"},
    "\U00002763\U0000FE0F": {"en": "heart_exclamation", "id": "tanda_seru_berbentuk_hati"},
    "\U0001F494": {"en": "broken_heart", "id": "patah_hati", "alias": "patah_hati_putus"},
    "\U00002764\U0000FE0F\U0000200D\U0001F525": {"en": "heart_on_fire", "id": "hati_berapi-api"},
    "\U00002764\U0000FE0F\U0000200D\U0001FA79": {
        "en": "mending_heart",
        "id": "mengobati_hati_terluka",
    },
    "\U00002764\U0000FE0F": {"en": "red_heart", "id": "hati_merah"},
    "\U0001F9E1": {"en": "orange_heart", "id": "hati_oranye"},
    "\U0001F49B": {"en": "yellow_heart", "id": "hati_kuning"},
    "\U0001F49A": {"en": "green_heart", "id": "hati_hijau"},
    "\U0001F499": {"en": "blue_heart", "id": "hati_biru"},
    "\U0001F49C": {"en": "purple_heart", "id": "hati_ungu"},
    "\U0001F90E": {"en": "brown_heart", "id": "hati_cokelat"},
    "\U0001F5A4": {"en": "black_heart", "id": "hati_hitam", "alias": "hati_hitam_jahat_kejam"},
    "\U0001F90D": {"en": "white_heart", "id": "hati_putih"},
    "\U0001F4AF": {
        "en": "hundred_points",
        "id": "nilai_seratus",
        "alias": "nilai_seratus_100_lengkap_skor",
    },
    "\U0001F4A2": {"en": "anger_symbol", "id": "marah", "alias": "marah_komik"},
    "\U0001F4A5": {"en": "collision", "id": "tabrakan", "alias": "tabrakan_komik_nabrak"},
    "\U0001F4AB": {"en": "dizzy", "id": "pusing", "alias": "pusing_bintang_komik"},
    "\U0001F4A6": {"en": "sweat_droplets", "id": "keringat", "alias": "keringat_ciprat_komik"},
    "\U0001F4A8": {"en": "dashing_away", "id": "berlari", "alias": "berlari_kabur_komik_lari"},
    "\U0001F573\U0000FE0F": {"en": "hole", "id": "lubang", "alias": "lubang_lobang"},
    "\U0001F4A3": {"en": "bomb", "id": "bom", "alias": "bom_komik"},
    "\U0001F4AC": {
        "en": "speech_balloon",
        "id": "balon_ucapan",
        "alias": "balon_ucapan_dialog_gelembung_komik",
    },
    "\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F": {
        "en": "eye_in_speech_bubble",
        "id": "mata_di_dalam_gelembung_ucapan",
    },
    "\U0001F5E8\U0000FE0F": {
        "en": "left_speech_bubble",
        "id": "gelembung_ucapan_kiri",
        "alias": "gelembung_ucapan_kiri_dialog",
    },
    "\U0001F5EF\U0000FE0F": {
        "en": "right_anger_bubble",
        "id": "gelembung_marah_kanan",
        "alias": "gelembung_marah_kanan_balon",
    },
    "\U0001F4AD": {
        "en": "thought_balloon",
        "id": "gelembung_pikiran",
        "alias": "gelembung_pikiran_balon_komik_mikir_pikir",
    },
    "\U0001F4A4": {"en": "zzz", "id": "zzz", "alias": "zzz_komik_tidur"},
    "\U0001F44B": {
        "en": "waving_hand",
        "id": "tangan_melambai",
        "alias": "tangan_melambai_badan_lambai_tubuh",
    },
    "\U0001F91A": {
        "en": "raised_back_of_hand",
        "id": "angkat_tangan",
        "alias": "angkat_tangan_berhenti_jangan_stop",
    },
    "\U0001F590\U0000FE0F": {
        "en": "hand_with_fingers_splayed",
        "id": "telapak_tangan_terbuka",
        "alias": "telapak_tangan_terbuka_badan_jari_tos_tubuh",
    },
    "\U0000270B": {
        "en": "raised_hand",
        "id": "telapak_tangan_terbuka_dengan_jari_rapat",
        "alias": "telapak_tangan_terbuka_dengan_jari_rapat_badan_tubuh",
    },
    "\U0001F596": {
        "en": "vulcan_salute",
        "id": "salam_vulcan",
        "alias": "salam_vulcan_badan_jari_spock_tangan_tubuh",
    },
    "\U0001F44C": {"en": "ok_hand", "id": "oke", "alias": "oke_badan_tangan_tubuh"},
    "\U0001F90C": {
        "en": "pinched_fingers",
        "id": "jari_terkuncup",
        "alias": "jari_terkuncup_interogasi_isyarat_tangan_sarkastik",
    },
    "\U0001F90F": {
        "en": "pinching_hand",
        "id": "tangan_menjepit",
        "alias": "tangan_menjepit_sejumlah_kecil",
    },
    "\U0000270C\U0000FE0F": {
        "en": "victory_hand",
        "id": "isyarat_kemenangan",
        "alias": "isyarat_kemenangan_badan_jari_menang_tangan_tubuh",
    },
    "\U0001F91E": {
        "en": "crossed_fingers",
        "id": "jari_menyilang",
        "alias": "jari_menyilang_beruntung_semoga_hoki_silang",
    },
    "\U0001F91F": {
        "en": "love-you_gesture",
        "id": "gerakan_sayang_kamu",
        "alias": "gerakan_sayang_kamu_ilu_ily_tangan",
    },
    "\U0001F918": {
        "en": "sign_of_the_horns",
        "id": "lambang_tanduk",
        "alias": "lambang_tanduk_badan_jari_tangan_tubuh",
    },
    "\U0001F919": {
        "en": "call_me_hand",
        "id": "panggil_saya",
        "alias": "panggil_saya_telepon_aku",
    },
    "\U0001F448": {
        "en": "backhand_index_pointing_left",
        "id": "menunjuk_ke_arah_kiri",
        "alias": "menunjuk_ke_arah_kiri_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F449": {
        "en": "backhand_index_pointing_right",
        "id": "menunjuk_ke_arah_kanan",
        "alias": "menunjuk_ke_arah_kanan_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F446": {
        "en": "backhand_index_pointing_up",
        "id": "menunjuk_ke_atas_(dibalik)",
        "alias": "menunjuk_ke_atas_dibalik_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F595": {"en": "middle_finger", "id": "jari_tengah", "alias": "jari_tengah_tangan"},
    "\U0001F447": {
        "en": "backhand_index_pointing_down",
        "id": "menunjuk_ke_bawah",
        "alias": "menunjuk_ke_bawah_badan_jari_tangan_tengah_tubuh_tunjuk",
    },
    "\U0000261D\U0000FE0F": {
        "en": "index_pointing_up",
        "id": "menunjuk_ke_atas",
        "alias": "menunjuk_ke_atas_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F44D": {
        "en": "thumbs_up",
        "id": "jempol_ke_atas",
        "alias": "jempol_ke_atas_+1_badan_tangan_tubuh",
    },
    "\U0001F44E": {
        "en": "thumbs_down",
        "id": "jempol_ke_bawah",
        "alias": "jempol_ke_bawah_-1_badan_tangan_tubuh",
    },
    "\U0000270A": {
        "en": "raised_fist",
        "id": "tangan_terkepal_ke_atas",
        "alias": "tangan_terkepal_ke_atas_badan_kepal_tinju_tubuh",
    },
    "\U0001F44A": {
        "en": "oncoming_fist",
        "id": "tangan_terkepal_ke_depan",
        "alias": "tangan_terkepal_ke_depan_badan_kepal_tinju_tonjok_tubuh",
    },
    "\U0001F91B": {
        "en": "left-facing_fist",
        "id": "tinju_kiri",
        "alias": "tinju_kiri_kepalan_tangan_tonjok",
    },
    "\U0001F91C": {
        "en": "right-facing_fist",
        "id": "tinju_kanan",
        "alias": "tinju_kanan_kepalan_tangan_tonjok",
    },
    "\U0001F44F": {
        "en": "clapping_hands",
        "id": "tepuk_tangan",
        "alias": "tepuk_tangan_badan_tubuh",
    },
    "\U0001F64C": {
        "en": "raising_hands",
        "id": "mengangkat_tangan",
        "alias": "mengangkat_tangan_angkat_gerakan_hore_perayaan",
    },
    "\U0001F450": {
        "en": "open_hands",
        "id": "tangan_terbuka",
        "alias": "tangan_terbuka_badan_tubuh",
    },
    "\U0001F932": {
        "en": "palms_up_together",
        "id": "tangan_diangkat_dan_dirapatkan_bersama",
        "alias": "tangan_diangkat_dan_dirapatkan_bersama_berdoa_doa",
    },
    "\U0001F91D": {
        "en": "handshake",
        "id": "jabat_tangan",
        "alias": "jabat_tangan_salaman_sepakat_setuju",
    },
    "\U0001F64F": {
        "en": "folded_hands",
        "id": "melipat_tangan",
        "alias": "melipat_tangan_berdoa_bungkuk_gerakan_lipat_makasih_mohon_tolong_tubuh",
    },
    "\U0000270D\U0000FE0F": {
        "en": "writing_hand",
        "id": "tangan_menulis",
        "alias": "tangan_menulis_badan_nulis_tubuh_tulis",
    },
    "\U0001F485": {
        "en": "nail_polish",
        "id": "poles_kuku",
        "alias": "poles_kuku_cat_kosmetik_manikur_perawatan",
    },
    "\U0001F933": {"en": "selfie", "id": "selfie", "alias": "selfie_foto_kamera_ponsel_selfi"},
    "\U0001F4AA": {
        "en": "flexed_biceps",
        "id": "lengan_berotot",
        "alias": "lengan_berotot_badan_biseps_otot_tubuh",
    },
    "\U0001F9BE": {
        "en": "mechanical_arm",
        "id": "lengan_robot",
        "alias": "lengan_robot_aksesibilitas_prostetik",
    },
    "\U0001F9BF": {
        "en": "mechanical_leg",
        "id": "tungkai_robot",
        "alias": "tungkai_robot_aksesibilitas_prostetik",
    },
    "\U0001F9B5": {"en": "leg", "id": "tungkai", "alias": "tungkai_bagian_tubuh_tendang"},
    "\U0001F9B6": {"en": "foot", "id": "telapak_kaki", "alias": "telapak_kaki_injak_tendang"},
    "\U0001F442": {"en": "ear", "id": "telinga", "alias": "telinga_badan_tubuh"},
    "\U0001F9BB": {
        "en": "ear_with_hearing_aid",
        "id": "telinga_dengan_alat_bantu_dengar",
        "alias": "telinga_dengan_alat_bantu_dengar_aksesibilitas_sulit_mendengar_tuli_tunarungu",
    },
    "\U0001F443": {"en": "nose", "id": "hidung", "alias": "hidung_badan_tubuh"},
    "\U0001F9E0": {"en": "brain", "id": "otak", "alias": "otak_cerdas_genius_kecerdasan_pintar"},
    "\U0001FAC0": {
        "en": "anatomical_heart",
        "id": "organ_jantung",
        "alias": "organ_jantung_detak_kardiologi_nadi_tengah",
    },
    "\U0001FAC1": {
        "en": "lungs",
        "id": "paru-paru",
        "alias": "paru-paru_ekshalasi_inhalasi_napas_organ_respirasi",
    },
    "\U0001F9B7": {"en": "tooth", "id": "gigi", "alias": "gigi_dokter"},
    "\U0001F9B4": {"en": "bone", "id": "tulang", "alias": "tulang_belulang"},
    "\U0001F440": {"en": "eyes", "id": "dua_mata", "alias": "dua_mata_badan_muka_tubuh_wajah"},
    "\U0001F441\U0000FE0F": {"en": "eye", "id": "satu_mata", "alias": "satu_mata_badan_tubuh"},
    "\U0001F445": {"en": "tongue", "id": "lidah", "alias": "lidah_badan_tubuh"},
    "\U0001F444": {"en": "mouth", "id": "mulut", "alias": "mulut_badan_bibir_tubuh"},
    "\U0001F476": {"en": "baby", "id": "bayi", "alias": "bayi_muda"},
    "\U0001F9D2": {"en": "child", "id": "anak", "alias": "anak_gender_tak_tentu_muda_netral"},
    "\U0001F466": {"en": "boy", "id": "anak_laki-laki", "alias": "anak_laki-laki_muda"},
    "\U0001F467": {
        "en": "girl",
        "id": "anak_perempuan",
        "alias": "anak_perempuan_muda_virgo_zodiak",
    },
    "\U0001F9D1": {
        "en": "person",
        "id": "dewasa",
        "alias": "dewasa_gender_tak_tentu_netral_orang",
    },
    "\U0001F471": {
        "en": "person_blond_hair",
        "id": "orang_rambut_pirang",
        "alias": "orang_rambut_pirang_berambut",
    },
    "\U0001F468": {"en": "man", "id": "pria", "alias": "pria_orang_dewasa"},
    "\U0001F9D4": {"en": "person_beard", "id": "orang_janggut"},
    "\U0001F9D4\U0000200D\U00002642\U0000FE0F": {"en": "man_beard", "id": "pria_janggut"},
    "\U0001F9D4\U0000200D\U00002640\U0000FE0F": {"en": "woman_beard", "id": "wanita_janggut"},
    "\U0001F468\U0000200D\U0001F9B0": {
        "en": "man_red_hair",
        "id": "pria_rambut_merah",
        "alias": "pria_rambut_merah_orang_dewasa",
    },
    "\U0001F468\U0000200D\U0001F9B1": {
        "en": "man_curly_hair",
        "id": "pria_rambut_keriting",
        "alias": "pria_rambut_keriting_orang_dewasa",
    },
    "\U0001F468\U0000200D\U0001F9B3": {
        "en": "man_white_hair",
        "id": "pria_rambut_putih",
        "alias": "pria_rambut_putih_orang_dewasa",
    },
    "\U0001F468\U0000200D\U0001F9B2": {
        "en": "man_bald",
        "id": "pria_gundul",
        "alias": "pria_gundul_orang_dewasa",
    },
    "\U0001F469": {"en": "woman", "id": "wanita", "alias": "wanita_ibu_perempuan"},
    "\U0001F469\U0000200D\U0001F9B0": {
        "en": "woman_red_hair",
        "id": "wanita_rambut_merah",
        "alias": "wanita_rambut_merah_ibu_perempuan",
    },
    "\U0001F9D1\U0000200D\U0001F9B0": {
        "en": "person_red_hair",
        "id": "dewasa_rambut_merah",
        "alias": "dewasa_rambut_merah_gender_tak_tentu_netral_orang",
    },
    "\U0001F469\U0000200D\U0001F9B1": {
        "en": "woman_curly_hair",
        "id": "wanita_rambut_keriting",
        "alias": "wanita_rambut_keriting_ibu_perempuan",
    },
    "\U0001F9D1\U0000200D\U0001F9B1": {
        "en": "person_curly_hair",
        "id": "dewasa_rambut_keriting",
        "alias": "dewasa_rambut_keriting_gender_tak_tentu_netral_orang",
    },
    "\U0001F469\U0000200D\U0001F9B3": {
        "en": "woman_white_hair",
        "id": "wanita_rambut_putih",
        "alias": "wanita_rambut_putih_ibu_perempuan",
    },
    "\U0001F9D1\U0000200D\U0001F9B3": {
        "en": "person_white_hair",
        "id": "dewasa_rambut_putih",
        "alias": "dewasa_rambut_putih_gender_tak_tentu_netral_orang",
    },
    "\U0001F469\U0000200D\U0001F9B2": {
        "en": "woman_bald",
        "id": "wanita_gundul",
        "alias": "wanita_gundul_ibu_perempuan",
    },
    "\U0001F9D1\U0000200D\U0001F9B2": {
        "en": "person_bald",
        "id": "dewasa_gundul",
        "alias": "dewasa_gundul_gender_tak_tentu_netral_orang",
    },
    "\U0001F471\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_blond_hair",
        "id": "wanita_berambut_pirang",
        "alias": "wanita_berambut_pirang_perempuan_rambut",
    },
    "\U0001F471\U0000200D\U00002642\U0000FE0F": {
        "en": "man_blond_hair",
        "id": "pria_berambut_pirang",
        "alias": "pria_berambut_pirang_laki-laki_rambut",
    },
    "\U0001F9D3": {
        "en": "older_person",
        "id": "lanjut_usia",
        "alias": "lanjut_usia_netral_gender_tua",
    },
    "\U0001F474": {"en": "old_man", "id": "pria_tua", "alias": "pria_tua_kakek_laki-laki"},
    "\U0001F475": {"en": "old_woman", "id": "wanita_tua", "alias": "wanita_tua_nenek_perempuan"},
    "\U0001F64D": {"en": "person_frowning", "id": "orang_marah", "alias": "orang_marah_gerakan"},
    "\U0001F64D\U0000200D\U00002642\U0000FE0F": {
        "en": "man_frowning",
        "id": "pria_muka_tidak_senang",
        "alias": "pria_muka_tidak_senang_laki-laki",
    },
    "\U0001F64D\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_frowning",
        "id": "wanita_muka_tidak_senang",
        "alias": "wanita_muka_tidak_senang_perempuan",
    },
    "\U0001F64E": {
        "en": "person_pouting",
        "id": "orang_tidak_senang",
        "alias": "orang_tidak_senang_cemberut_gerakan",
    },
    "\U0001F64E\U0000200D\U00002642\U0000FE0F": {
        "en": "man_pouting",
        "id": "pria_tidak_senang",
        "alias": "pria_tidak_senang_bibir_laki-laki",
    },
    "\U0001F64E\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_pouting",
        "id": "wanita_tidak_senang",
        "alias": "wanita_tidak_senang_bibir_perempuan",
    },
    "\U0001F645": {
        "en": "person_gesturing_no",
        "id": "orang_mengisyaratkan_tidak",
        "alias": "orang_mengisyaratkan_tidak_dilarang_gerakan_nggak_tangan_terlarang",
    },
    "\U0001F645\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_no",
        "id": "pria_mengisyaratkan_tidak",
        "alias": "pria_mengisyaratkan_tidak_isyarat_laki-laki",
    },
    "\U0001F645\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_no",
        "id": "wanita_mengisyaratkan_tidak",
        "alias": "wanita_mengisyaratkan_tidak_isyarat_perempuan_tangan",
    },
    "\U0001F646": {
        "en": "person_gesturing_ok",
        "id": "orang_mengisyaratkan_oke",
        "alias": "orang_mengisyaratkan_oke_gerakan_tangan",
    },
    "\U0001F646\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_ok",
        "id": "pria_mengisyaratkan_oke",
        "alias": "pria_mengisyaratkan_oke_isyarat_laki-laki_tangan",
    },
    "\U0001F646\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_ok",
        "id": "wanita_mengisyaratkan_oke",
        "alias": "wanita_mengisyaratkan_oke_isyarat_perempuan_tangan",
    },
    "\U0001F481": {
        "en": "person_tipping_hand",
        "id": "orang_menengadahkan_tangan",
        "alias": "orang_menengadahkan_tangan_bantuan_informasi_resepsionis",
    },
    "\U0001F481\U0000200D\U00002642\U0000FE0F": {
        "en": "man_tipping_hand",
        "id": "pria_menengadahkan_tangan",
        "alias": "pria_menengadahkan_tangan_bantuan_isyarat_laki-laki",
    },
    "\U0001F481\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_tipping_hand",
        "id": "wanita_menengadahkan_tangan",
        "alias": "wanita_menengadahkan_tangan_bantuan_isyarat_perempuan",
    },
    "\U0001F64B": {
        "en": "person_raising_hand",
        "id": "orang_mengangkat_tangan",
        "alias": "orang_mengangkat_tangan_angkat_gerakan_senang",
    },
    "\U0001F64B\U0000200D\U00002642\U0000FE0F": {
        "en": "man_raising_hand",
        "id": "pria_mengangkat_tangan",
        "alias": "pria_mengangkat_tangan_angkat_isyarat_laki-laki",
    },
    "\U0001F64B\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_raising_hand",
        "id": "wanita_mengangkat_tangan",
        "alias": "wanita_mengangkat_tangan_angkat_isyarat_perempuan",
    },
    "\U0001F9CF": {
        "en": "deaf_person",
        "id": "orang_tuli",
        "alias": "orang_tuli_aksesibilitas_dengar_kuping_telinga_tunarungu",
    },
    "\U0001F9CF\U0000200D\U00002642\U0000FE0F": {
        "en": "deaf_man",
        "id": "pria_tuli",
        "alias": "pria_tuli_lelaki_tunarungu",
    },
    "\U0001F9CF\U0000200D\U00002640\U0000FE0F": {
        "en": "deaf_woman",
        "id": "wanita_tuli",
        "alias": "wanita_tuli_perempuan_tunarungu",
    },
    "\U0001F647": {
        "en": "person_bowing",
        "id": "orang_membungkuk",
        "alias": "orang_membungkuk_bungkuk_gerakan_maaf_nunduk_sori_tunduk",
    },
    "\U0001F647\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bowing",
        "id": "pria_membungkuk",
        "alias": "pria_membungkuk_isyarat_laki-laki_maaf",
    },
    "\U0001F647\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bowing",
        "id": "wanita_membungkuk",
        "alias": "wanita_membungkuk_isyarat_maaf_perempuan",
    },
    "\U0001F926": {
        "en": "person_facepalming",
        "id": "orang_tepuk_jidat",
        "alias": "orang_tepuk_jidat_cape_deh_capedeh_capek_yah",
    },
    "\U0001F926\U0000200D\U00002642\U0000FE0F": {
        "en": "man_facepalming",
        "id": "pria_tepuk_jidat",
        "alias": "pria_tepuk_jidat_isyarat_laki-laki_tangan",
    },
    "\U0001F926\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_facepalming",
        "id": "wanita_tepuk_jidat",
        "alias": "wanita_tepuk_jidat_isyarat_perempuan_tangan",
    },
    "\U0001F937": {
        "en": "person_shrugging",
        "id": "orang_mengangkat_bahu",
        "alias": "orang_mengangkat_bahu_bingung_entah_nggak_tahu_tidak",
    },
    "\U0001F937\U0000200D\U00002642\U0000FE0F": {
        "en": "man_shrugging",
        "id": "pria_mengangkat_bahu",
        "alias": "pria_mengangkat_bahu_angkat_isyarat_laki-laki",
    },
    "\U0001F937\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_shrugging",
        "id": "wanita_mengangkat_bahu",
        "alias": "wanita_mengangkat_bahu_angkat_isyarat_perempuan",
    },
    "\U0001F9D1\U0000200D\U00002695\U0000FE0F": {
        "en": "health_worker",
        "id": "petugas_kesehatan",
        "alias": "petugas_kesehatan_dokter_perawat_perawatan_terapis",
    },
    "\U0001F468\U0000200D\U00002695\U0000FE0F": {
        "en": "man_health_worker",
        "id": "pekerja_kesehatan_pria",
        "alias": "pekerja_kesehatan_pria_dokter_laki-laki_perawatan",
    },
    "\U0001F469\U0000200D\U00002695\U0000FE0F": {
        "en": "woman_health_worker",
        "id": "pekerja_kesehatan_wanita",
        "alias": "pekerja_kesehatan_wanita_dokter_perawatan_perempuan",
    },
    "\U0001F9D1\U0000200D\U0001F393": {"en": "student", "id": "murid", "alias": "murid_kelulusan"},
    "\U0001F468\U0000200D\U0001F393": {
        "en": "man_student",
        "id": "sarjana_pria",
        "alias": "sarjana_pria_laki-laki_toga_universitas_wisuda",
    },
    "\U0001F469\U0000200D\U0001F393": {
        "en": "woman_student",
        "id": "sarjana_wanita",
        "alias": "sarjana_wanita_perempuan_toga_universitas_wisuda",
    },
    "\U0001F9D1\U0000200D\U0001F3EB": {
        "en": "teacher",
        "id": "guru",
        "alias": "guru_dosen_instruktur",
    },
    "\U0001F468\U0000200D\U0001F3EB": {
        "en": "man_teacher",
        "id": "pengajar_pria",
        "alias": "pengajar_pria_laki-laki_sekolah",
    },
    "\U0001F469\U0000200D\U0001F3EB": {
        "en": "woman_teacher",
        "id": "pengajar_wanita",
        "alias": "pengajar_wanita_perempuan_sekolah",
    },
    "\U0001F9D1\U0000200D\U00002696\U0000FE0F": {
        "en": "judge",
        "id": "hakim",
        "alias": "hakim_timbangan",
    },
    "\U0001F468\U0000200D\U00002696\U0000FE0F": {
        "en": "man_judge",
        "id": "hakim_pria",
        "alias": "hakim_pria_hukum_laki-laki_pengadilan",
    },
    "\U0001F469\U0000200D\U00002696\U0000FE0F": {
        "en": "woman_judge",
        "id": "hakim_wanita",
        "alias": "hakim_wanita_hukum_pengadilan_perempuan",
    },
    "\U0001F9D1\U0000200D\U0001F33E": {
        "en": "farmer",
        "id": "petani",
        "alias": "petani_pekebun_peternak",
    },
    "\U0001F468\U0000200D\U0001F33E": {
        "en": "man_farmer",
        "id": "petani_pria",
        "alias": "petani_pria_laki-laki_padi_sawah",
    },
    "\U0001F469\U0000200D\U0001F33E": {
        "en": "woman_farmer",
        "id": "petani_wanita",
        "alias": "petani_wanita_padi_perempuan_sawah",
    },
    "\U0001F9D1\U0000200D\U0001F373": {"en": "cook", "id": "koki", "alias": "koki_chef"},
    "\U0001F468\U0000200D\U0001F373": {
        "en": "man_cook",
        "id": "koki_pria",
        "alias": "koki_pria_dapur_laki-laki_memasak",
    },
    "\U0001F469\U0000200D\U0001F373": {
        "en": "woman_cook",
        "id": "koki_wanita",
        "alias": "koki_wanita_dapur_memasak_perempuan",
    },
    "\U0001F9D1\U0000200D\U0001F527": {
        "en": "mechanic",
        "id": "mekanik",
        "alias": "mekanik_pekerja_terlatih_tukang_ledeng_listrik",
    },
    "\U0001F468\U0000200D\U0001F527": {
        "en": "man_mechanic",
        "id": "montir_pria",
        "alias": "montir_pria_laki-laki_perbaikan_tukang",
    },
    "\U0001F469\U0000200D\U0001F527": {
        "en": "woman_mechanic",
        "id": "montir_wanita",
        "alias": "montir_wanita_perbaikan_perempuan_tukang",
    },
    "\U0001F9D1\U0000200D\U0001F3ED": {
        "en": "factory_worker",
        "id": "pekerja_pabrik",
        "alias": "pekerja_pabrik_industri_perakitan",
    },
    "\U0001F468\U0000200D\U0001F3ED": {
        "en": "man_factory_worker",
        "id": "pekerja_pabrik_pria",
        "alias": "pekerja_pabrik_pria_laki-laki",
    },
    "\U0001F469\U0000200D\U0001F3ED": {
        "en": "woman_factory_worker",
        "id": "pekerja_pabrik_wanita",
        "alias": "pekerja_pabrik_wanita_perempuan",
    },
    "\U0001F9D1\U0000200D\U0001F4BC": {
        "en": "office_worker",
        "id": "pekerja_kantoran",
        "alias": "pekerja_kantoran_arsitek_bisnis_kerah_putih_manajer",
    },
    "\U0001F468\U0000200D\U0001F4BC": {
        "en": "man_office_worker",
        "id": "pekerja_kantor_pria",
        "alias": "pekerja_kantor_pria_karyawan_laki-laki",
    },
    "\U0001F469\U0000200D\U0001F4BC": {
        "en": "woman_office_worker",
        "id": "pekerja_kantor_wanita",
        "alias": "pekerja_kantor_wanita_karyawan_perempuan",
    },
    "\U0001F9D1\U0000200D\U0001F52C": {
        "en": "scientist",
        "id": "ilmuwan",
        "alias": "ilmuwan_ahli_biologi_fisika_kimia_insinyur",
    },
    "\U0001F468\U0000200D\U0001F52C": {
        "en": "man_scientist",
        "id": "ilmuwan_pria",
        "alias": "ilmuwan_pria_laboratorium_laki-laki_sains",
    },
    "\U0001F469\U0000200D\U0001F52C": {
        "en": "woman_scientist",
        "id": "ilmuwan_wanita",
        "alias": "ilmuwan_wanita_laboratorium_perempuan_sains",
    },
    "\U0001F9D1\U0000200D\U0001F4BB": {
        "en": "technologist",
        "id": "ahli_teknologi",
        "alias": "ahli_teknologi_pemrogram_penemu_pengembang_perangkat_lunak",
    },
    "\U0001F468\U0000200D\U0001F4BB": {
        "en": "man_technologist",
        "id": "ahli_teknologi_pria",
        "alias": "ahli_teknologi_pria_komputer_laki-laki",
    },
    "\U0001F469\U0000200D\U0001F4BB": {
        "en": "woman_technologist",
        "id": "ahli_teknologi_wanita",
        "alias": "ahli_teknologi_wanita_komputer_perempuan",
    },
    "\U0001F9D1\U0000200D\U0001F3A4": {
        "en": "singer",
        "id": "penyanyi",
        "alias": "penyanyi_aktor_bintang_penghibur_rock",
    },
    "\U0001F468\U0000200D\U0001F3A4": {
        "en": "man_singer",
        "id": "penyanyi_pria",
        "alias": "penyanyi_pria_aktor_bintang_penghibur_rock",
    },
    "\U0001F469\U0000200D\U0001F3A4": {
        "en": "woman_singer",
        "id": "penyanyi_wanita",
        "alias": "penyanyi_wanita_aktor_bintang_penghibur_rock",
    },
    "\U0001F9D1\U0000200D\U0001F3A8": {"en": "artist", "id": "seniman", "alias": "seniman_palet"},
    "\U0001F468\U0000200D\U0001F3A8": {
        "en": "man_artist",
        "id": "seniman_pria",
        "alias": "seniman_pria_laki-laki_lukisan_seni",
    },
    "\U0001F469\U0000200D\U0001F3A8": {
        "en": "woman_artist",
        "id": "seniman_wanita",
        "alias": "seniman_wanita_lukisan_perempuan_seni",
    },
    "\U0001F9D1\U0000200D\U00002708\U0000FE0F": {
        "en": "pilot",
        "id": "pilot",
        "alias": "pilot_pesawat",
    },
    "\U0001F468\U0000200D\U00002708\U0000FE0F": {
        "en": "man_pilot",
        "id": "pilot_pria",
        "alias": "pilot_pria_laki-laki_pesawat",
    },
    "\U0001F469\U0000200D\U00002708\U0000FE0F": {
        "en": "woman_pilot",
        "id": "pilot_wanita",
        "alias": "pilot_wanita_perempuan_pesawat",
    },
    "\U0001F9D1\U0000200D\U0001F680": {
        "en": "astronaut",
        "id": "astronaut",
        "alias": "astronaut_roket",
    },
    "\U0001F468\U0000200D\U0001F680": {
        "en": "man_astronaut",
        "id": "antariksawan_pria",
        "alias": "antariksawan_pria_angkasa_luar_laki-laki_roket",
    },
    "\U0001F469\U0000200D\U0001F680": {
        "en": "woman_astronaut",
        "id": "antariksawan_wanita",
        "alias": "antariksawan_wanita_angkasa_luar_perempuan_roket",
    },
    "\U0001F9D1\U0000200D\U0001F692": {
        "en": "firefighter",
        "id": "pemadam_kebakaran",
        "alias": "pemadam_kebakaran_truk",
    },
    "\U0001F468\U0000200D\U0001F692": {
        "en": "man_firefighter",
        "id": "pemadam_kebakaran_pria",
        "alias": "pemadam_kebakaran_pria_api_laki-laki",
    },
    "\U0001F469\U0000200D\U0001F692": {
        "en": "woman_firefighter",
        "id": "pemadam_kebakaran_wanita",
        "alias": "pemadam_kebakaran_wanita_api_perempuan",
    },
    "\U0001F46E": {"en": "police_officer", "id": "polisi", "alias": "polisi_penegak_hukum"},
    "\U0001F46E\U0000200D\U00002642\U0000FE0F": {
        "en": "man_police_officer",
        "id": "polisi_pria",
        "alias": "polisi_pria_laki-laki_penegak_hukum",
    },
    "\U0001F46E\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_police_officer",
        "id": "polisi_wanita",
        "alias": "polisi_wanita_penegak_hukum_perempuan",
    },
    "\U0001F575\U0000FE0F": {"en": "detective", "id": "detektif", "alias": "detektif_mata-mata"},
    "\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F": {
        "en": "man_detective",
        "id": "detektif_pria",
        "alias": "detektif_pria_laki-laki_penyelidikan_rahasia",
    },
    "\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_detective",
        "id": "detektif_wanita",
        "alias": "detektif_wanita_penyelidikan_perempuan_rahasia",
    },
    "\U0001F482": {"en": "guard", "id": "penjaga", "alias": "penjaga_pengawal"},
    "\U0001F482\U0000200D\U00002642\U0000FE0F": {
        "en": "man_guard",
        "id": "penjaga_pria",
        "alias": "penjaga_pria_keamanan_laki-laki",
    },
    "\U0001F482\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_guard",
        "id": "penjaga_wanita",
        "alias": "penjaga_wanita_keamanan_perempuan",
    },
    "\U0001F977": {
        "en": "ninja",
        "id": "ninja",
        "alias": "ninja_petarung_sembunyi-sembunyi_tersembunyi",
    },
    "\U0001F477": {
        "en": "construction_worker",
        "id": "pekerja_konstruksi",
        "alias": "pekerja_konstruksi_kontraktor_topi",
    },
    "\U0001F477\U0000200D\U00002642\U0000FE0F": {
        "en": "man_construction_worker",
        "id": "pekerja_konstruksi_pria",
        "alias": "pekerja_konstruksi_pria_kontraktor_laki-laki",
    },
    "\U0001F477\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_construction_worker",
        "id": "pekerja_konstruksi_wanita",
        "alias": "pekerja_konstruksi_wanita_kontraktor",
    },
    "\U0001F934": {"en": "prince", "id": "pangeran"},
    "\U0001F478": {"en": "princess", "id": "putri", "alias": "putri_dongeng_fantasi_puteri"},
    "\U0001F473": {
        "en": "person_wearing_turban",
        "id": "orang_mengenakan_serban",
        "alias": "orang_mengenakan_serban_laki-laki_pria_surban",
    },
    "\U0001F473\U0000200D\U00002642\U0000FE0F": {
        "en": "man_wearing_turban",
        "id": "pria_mengenakan_serban",
        "alias": "pria_mengenakan_serban_laki-laki",
    },
    "\U0001F473\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_wearing_turban",
        "id": "wanita_mengenakan_serban",
        "alias": "wanita_mengenakan_serban_perempuan",
    },
    "\U0001F472": {
        "en": "person_with_skullcap",
        "id": "orang_dengan_topi_tionghoa",
        "alias": "orang_dengan_topi_tionghoa_gua_pi_mao_pria",
    },
    "\U0001F9D5": {
        "en": "woman_with_headscarf",
        "id": "wanita_dengan_kerudung",
        "alias": "wanita_dengan_kerudung_hijab_mantilla_tichel",
    },
    "\U0001F935": {
        "en": "person_in_tuxedo",
        "id": "orang_bertuksedo",
        "alias": "orang_bertuksedo_mempelai_pria_tuksedo",
    },
    "\U0001F935\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_tuxedo",
        "id": "pria_dewasa_bertuksedo",
        "alias": "pria_dewasa_bertuksedo_tuksedo_tuxedo",
    },
    "\U0001F935\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_tuxedo",
        "id": "wanita_bertuksedo",
        "alias": "wanita_bertuksedo_tuksedo",
    },
    "\U0001F470": {
        "en": "person_with_veil",
        "id": "orang_berpenutup_kepala",
        "alias": "orang_berpenutup_kepala_cadar_mempelai_wanita_nikah_pengantin",
    },
    "\U0001F470\U0000200D\U00002642\U0000FE0F": {
        "en": "man_with_veil",
        "id": "pria_berpenutup_kepala",
        "alias": "pria_berpenutup_kepala_penutup",
    },
    "\U0001F470\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_with_veil",
        "id": "wanita_berpenutup_kepala",
        "alias": "wanita_berpenutup_kepala_penutup",
    },
    "\U0001F930": {
        "en": "pregnant_woman",
        "id": "wanita_hamil",
        "alias": "wanita_hamil_ibu_perempuan",
    },
    "\U0001F931": {"en": "breast-feeding", "id": "menyusui", "alias": "menyusui_bayi_payudara"},
    "\U0001F469\U0000200D\U0001F37C": {
        "en": "woman_feeding_baby",
        "id": "wanita_menyusui_bayi",
        "alias": "wanita_menyusui_bayi_mengasuh",
    },
    "\U0001F468\U0000200D\U0001F37C": {
        "en": "man_feeding_baby",
        "id": "pria_menyusui_bayi",
        "alias": "pria_menyusui_bayi_mengasuh",
    },
    "\U0001F9D1\U0000200D\U0001F37C": {
        "en": "person_feeding_baby",
        "id": "orang_menyusui_bayi",
        "alias": "orang_menyusui_bayi_mengasuh",
    },
    "\U0001F47C": {
        "en": "baby_angel",
        "id": "malaikat_bayi",
        "alias": "malaikat_bayi_dongeng_fantasi_muka_wajah",
    },
    "\U0001F385": {
        "en": "santa_claus",
        "id": "sinterklas",
        "alias": "sinterklas_dongeng_fantasi_natal_perayaan_santa",
    },
    "\U0001F936": {
        "en": "mrs._claus",
        "id": "nyonya_sinterklas",
        "alias": "nyonya_sinterklas_ibu_nenek_oma",
    },
    "\U0001F9D1\U0000200D\U0001F384": {
        "en": "mx_claus",
        "id": "manusia_sinterklas",
        "alias": "manusia_sinterklas_natal",
    },
    "\U0001F9B8": {
        "en": "superhero",
        "id": "pahlawan_super",
        "alias": "pahlawan_super_baik_kekuatan_wanita",
    },
    "\U0001F9B8\U0000200D\U00002642\U0000FE0F": {
        "en": "man_superhero",
        "id": "pahlawan_super_pria",
        "alias": "pahlawan_super_pria_baik_kekuatan",
    },
    "\U0001F9B8\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_superhero",
        "id": "pahlawan_super_wanita",
        "alias": "pahlawan_super_wanita_baik_kekuatan",
    },
    "\U0001F9B9": {
        "en": "supervillain",
        "id": "penjahat_super",
        "alias": "penjahat_super_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0000200D\U00002642\U0000FE0F": {
        "en": "man_supervillain",
        "id": "penjahat_super_pria",
        "alias": "penjahat_super_pria_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_supervillain",
        "id": "penjahat_super_wanita",
        "alias": "penjahat_super_wanita_jahat_kekuatan_kriminal",
    },
    "\U0001F9D9": {"en": "mage", "id": "magi", "alias": "magi_penyihir_tukang_sihir"},
    "\U0001F9D9\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mage",
        "id": "magi_pria",
        "alias": "magi_pria_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mage",
        "id": "magi_wanita",
        "alias": "magi_wanita_penyihir_tukang_sihir",
    },
    "\U0001F9DA": {"en": "fairy", "id": "peri", "alias": "peri_oberon_puck_titania"},
    "\U0001F9DA\U0000200D\U00002642\U0000FE0F": {
        "en": "man_fairy",
        "id": "peri_pria",
        "alias": "peri_pria_oberon_puck",
    },
    "\U0001F9DA\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_fairy",
        "id": "peri_wanita",
        "alias": "peri_wanita_titania",
    },
    "\U0001F9DB": {"en": "vampire", "id": "vampir", "alias": "vampir_drakula_mayat_hidup"},
    "\U0001F9DB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_vampire",
        "id": "vampir_pria",
        "alias": "vampir_pria_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_vampire",
        "id": "vampir_wanita",
        "alias": "vampir_wanita_mayat_hidup",
    },
    "\U0001F9DC": {
        "en": "merperson",
        "id": "orang_duyung",
        "alias": "orang_duyung_pria_putri_wanita",
    },
    "\U0001F9DC\U0000200D\U00002642\U0000FE0F": {
        "en": "merman",
        "id": "pria_duyung",
        "alias": "pria_duyung_triton",
    },
    "\U0001F9DC\U0000200D\U00002640\U0000FE0F": {
        "en": "mermaid",
        "id": "putri_duyung",
        "alias": "putri_duyung_wanita",
    },
    "\U0001F9DD": {"en": "elf", "id": "kurcaci", "alias": "kurcaci_ajaib"},
    "\U0001F9DD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_elf",
        "id": "kurcaci_pria",
        "alias": "kurcaci_pria_ajaib",
    },
    "\U0001F9DD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_elf",
        "id": "kurcaci_wanita",
        "alias": "kurcaci_wanita_ajaib",
    },
    "\U0001F9DE": {"en": "genie", "id": "jin"},
    "\U0001F9DE\U0000200D\U00002642\U0000FE0F": {"en": "man_genie", "id": "jin_pria"},
    "\U0001F9DE\U0000200D\U00002640\U0000FE0F": {"en": "woman_genie", "id": "jin_wanita"},
    "\U0001F9DF": {"en": "zombie", "id": "zombi", "alias": "zombi_mayat_berjalan_hidup"},
    "\U0001F9DF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_zombie",
        "id": "zombi_pria",
        "alias": "zombi_pria_mayat_berjalan_hidup",
    },
    "\U0001F9DF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_zombie",
        "id": "zombi_wanita",
        "alias": "zombi_wanita_mayat_berjalan_hidup",
    },
    "\U0001F486": {
        "en": "person_getting_massage",
        "id": "pria_dipijat",
        "alias": "pria_dipijat_pijat_pijit_salon",
    },
    "\U0001F486\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_massage",
        "id": "pria_dipijat_kepalanya",
        "alias": "pria_dipijat_kepalanya_kepala_laki-laki_pijat",
    },
    "\U0001F486\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_massage",
        "id": "wanita_dipijat",
        "alias": "wanita_dipijat_kepala_perempuan_pijat",
    },
    "\U0001F487": {
        "en": "person_getting_haircut",
        "id": "orang_potong_rambut",
        "alias": "orang_potong_rambut_cantik_salon",
    },
    "\U0001F487\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_haircut",
        "id": "pria_potong_rambut",
        "alias": "pria_potong_rambut_laki-laki",
    },
    "\U0001F487\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_haircut",
        "id": "wanita_potong_rambut",
        "alias": "wanita_potong_rambut_perempuan",
    },
    "\U0001F6B6": {
        "en": "person_walking",
        "id": "orang_berjalan_kaki",
        "alias": "orang_berjalan_kaki_jalan",
    },
    "\U0001F6B6\U0000200D\U00002642\U0000FE0F": {
        "en": "man_walking",
        "id": "pria_berjalan_kaki",
        "alias": "pria_berjalan_kaki_jalan_laki-laki",
    },
    "\U0001F6B6\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_walking",
        "id": "wanita_berjalan_kaki",
        "alias": "wanita_berjalan_kaki_jalan_perempuan",
    },
    "\U0001F9CD": {"en": "person_standing", "id": "orang_berdiri", "alias": "orang_berdiri_diri"},
    "\U0001F9CD\U0000200D\U00002642\U0000FE0F": {"en": "man_standing", "id": "pria_berdiri"},
    "\U0001F9CD\U0000200D\U00002640\U0000FE0F": {"en": "woman_standing", "id": "wanita_berdiri"},
    "\U0001F9CE": {
        "en": "person_kneeling",
        "id": "orang_berlutut",
        "alias": "orang_berlutut_lutut",
    },
    "\U0001F9CE\U0000200D\U00002642\U0000FE0F": {"en": "man_kneeling", "id": "pria_berlutut"},
    "\U0001F9CE\U0000200D\U00002640\U0000FE0F": {"en": "woman_kneeling", "id": "wanita_berlutut"},
    "\U0001F9D1\U0000200D\U0001F9AF": {
        "en": "person_with_white_cane",
        "id": "orang_dengan_tongkat",
        "alias": "orang_dengan_tongkat_aksesibilitas_buta",
    },
    "\U0001F468\U0000200D\U0001F9AF": {
        "en": "man_with_white_cane",
        "id": "pria_dengan_tongkat",
        "alias": "pria_dengan_tongkat_aksesiblitas_buta_tunanetra",
    },
    "\U0001F469\U0000200D\U0001F9AF": {
        "en": "woman_with_white_cane",
        "id": "wanita_dengan_tongkat",
        "alias": "wanita_dengan_tongkat_aksesiblitas_buta_tunanetra",
    },
    "\U0001F9D1\U0000200D\U0001F9BC": {
        "en": "person_in_motorized_wheelchair",
        "id": "orang_dengan_kursi_roda_bermotor",
        "alias": "orang_dengan_kursi_roda_bermotor_aksesibilitas",
    },
    "\U0001F468\U0000200D\U0001F9BC": {
        "en": "man_in_motorized_wheelchair",
        "id": "pria_dengan_kursi_roda_bermotor",
        "alias": "pria_dengan_kursi_roda_bermotor_aksesibilitas",
    },
    "\U0001F469\U0000200D\U0001F9BC": {
        "en": "woman_in_motorized_wheelchair",
        "id": "wanita_dengan_kursi_roda_bermotor",
        "alias": "wanita_dengan_kursi_roda_bermotor_aksesibilitas",
    },
    "\U0001F9D1\U0000200D\U0001F9BD": {
        "en": "person_in_manual_wheelchair",
        "id": "orang_dengan_kursi_roda_manual",
        "alias": "orang_dengan_kursi_roda_manual_aksesibilitas",
    },
    "\U0001F468\U0000200D\U0001F9BD": {
        "en": "man_in_manual_wheelchair",
        "id": "pria_dengan_kursi_roda_manual",
        "alias": "pria_dengan_kursi_roda_manual_aksesibilitas",
    },
    "\U0001F469\U0000200D\U0001F9BD": {
        "en": "woman_in_manual_wheelchair",
        "id": "wanita_dengan_kursi_roda_manual",
        "alias": "wanita_dengan_kursi_roda_manual_aksesibilitas",
    },
    "\U0001F3C3": {
        "en": "person_running",
        "id": "orang_berlari",
        "alias": "orang_berlari_lari_marathon_maraton",
    },
    "\U0001F3C3\U0000200D\U00002642\U0000FE0F": {
        "en": "man_running",
        "id": "pria_berlari",
        "alias": "pria_berlari_kaki_laki-laki_lari",
    },
    "\U0001F3C3\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_running",
        "id": "wanita_berlari",
        "alias": "wanita_berlari_kaki_lari_perempuan",
    },
    "\U0001F483": {
        "en": "woman_dancing",
        "id": "wanita_menari",
        "alias": "wanita_menari_dansa_perempuan_pesta_tari",
    },
    "\U0001F57A": {
        "en": "man_dancing",
        "id": "pria_menari",
        "alias": "pria_menari_berdansa_dansa",
    },
    "\U0001F574\U0000FE0F": {
        "en": "person_in_suit_levitating",
        "id": "pria_melayang_mengenakan_jas",
        "alias": "pria_melayang_mengenakan_jas_bisnis_laki-laki",
    },
    "\U0001F46F": {
        "en": "people_with_bunny_ears",
        "id": "orang_dengan_telinga_kelinci",
        "alias": "orang_dengan_telinga_kelinci_berpesta_penari",
    },
    "\U0001F46F\U0000200D\U00002642\U0000FE0F": {
        "en": "men_with_bunny_ears",
        "id": "pria_dengan_telinga_kelinci",
        "alias": "pria_dengan_telinga_kelinci_kostum_laki-laki_pesta_tari",
    },
    "\U0001F46F\U0000200D\U00002640\U0000FE0F": {
        "en": "women_with_bunny_ears",
        "id": "wanita_dengan_telinga_kelinci",
        "alias": "wanita_dengan_telinga_kelinci_kostum_perempuan_pesta_tari",
    },
    "\U0001F9D6": {
        "en": "person_in_steamy_room",
        "id": "orang_di_ruangan_beruap",
        "alias": "orang_di_ruangan_beruap_ruang_uap_sauna",
    },
    "\U0001F9D6\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_steamy_room",
        "id": "pria_di_ruangan_beruap",
        "alias": "pria_di_ruangan_beruap_ruang_uap_sauna",
    },
    "\U0001F9D6\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_steamy_room",
        "id": "wanita_di_ruangan_beruap",
        "alias": "wanita_di_ruangan_beruap_ruang_uap_sauna",
    },
    "\U0001F9D7": {
        "en": "person_climbing",
        "id": "orang_memanjat",
        "alias": "orang_memanjat_pemanjat",
    },
    "\U0001F9D7\U0000200D\U00002642\U0000FE0F": {
        "en": "man_climbing",
        "id": "pria_memanjat",
        "alias": "pria_memanjat_pemanjat",
    },
    "\U0001F9D7\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_climbing",
        "id": "wanita_memanjat",
        "alias": "wanita_memanjat_pemanjat",
    },
    "\U0001F93A": {
        "en": "person_fencing",
        "id": "orang_berolahraga_anggar",
        "alias": "orang_berolahraga_anggar_atlet_olahraga_pedang",
    },
    "\U0001F3C7": {
        "en": "horse_racing",
        "id": "balap_kuda",
        "alias": "balap_kuda_balapan_joki_pacuan",
    },
    "\U000026F7\U0000FE0F": {"en": "skier", "id": "pemain_ski", "alias": "pemain_ski_salju"},
    "\U0001F3C2": {
        "en": "snowboarder",
        "id": "peselancar_salju",
        "alias": "peselancar_salju_papan_seluncur_ski",
    },
    "\U0001F3CC\U0000FE0F": {
        "en": "person_golfing",
        "id": "orang_bermain_golf",
        "alias": "orang_bermain_golf_bola",
    },
    "\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F": {
        "en": "man_golfing",
        "id": "pria_bermain_golf",
        "alias": "pria_bermain_golf_bola_laki-laki",
    },
    "\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_golfing",
        "id": "wanita_bermain_golf",
        "alias": "wanita_bermain_golf_bola_perempuan",
    },
    "\U0001F3C4": {
        "en": "person_surfing",
        "id": "orang_berselancar",
        "alias": "orang_berselancar_seluncur",
    },
    "\U0001F3C4\U0000200D\U00002642\U0000FE0F": {
        "en": "man_surfing",
        "id": "pria_berselancar",
        "alias": "pria_berselancar_laki-laki_ombak_selancar",
    },
    "\U0001F3C4\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_surfing",
        "id": "wanita_berselancar",
        "alias": "wanita_berselancar_ombak_perempuan_selancar",
    },
    "\U0001F6A3": {
        "en": "person_rowing_boat",
        "id": "orang_mendayung_perahu",
        "alias": "orang_mendayung_perahu_kendaraan",
    },
    "\U0001F6A3\U0000200D\U00002642\U0000FE0F": {
        "en": "man_rowing_boat",
        "id": "pria_mendayung_perahu",
        "alias": "pria_mendayung_perahu_dayung_laki-laki",
    },
    "\U0001F6A3\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_rowing_boat",
        "id": "wanita_mendayung_perahu",
        "alias": "wanita_mendayung_perahu_dayung_perempuan",
    },
    "\U0001F3CA": {
        "en": "person_swimming",
        "id": "orang_berenang",
        "alias": "orang_berenang_renang",
    },
    "\U0001F3CA\U0000200D\U00002642\U0000FE0F": {
        "en": "man_swimming",
        "id": "pria_berenang",
        "alias": "pria_berenang_laki-laki_renang",
    },
    "\U0001F3CA\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_swimming",
        "id": "wanita_berenang",
        "alias": "wanita_berenang_perempuan_renang",
    },
    "\U000026F9\U0000FE0F": {"en": "person_bouncing_ball", "id": "orang_memantulkan_bola"},
    "\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bouncing_ball",
        "id": "pria_memantulkan_bola",
        "alias": "pria_memantulkan_bola_laki-laki_membawa",
    },
    "\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bouncing_ball",
        "id": "wanita_memantulkan_bola",
        "alias": "wanita_memantulkan_bola_membawa_perempuan",
    },
    "\U0001F3CB\U0000FE0F": {
        "en": "person_lifting_weights",
        "id": "orang_mengangkat_beban",
        "alias": "orang_mengangkat_beban_angkat",
    },
    "\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F": {
        "en": "man_lifting_weights",
        "id": "pria_mengangkat_beban",
        "alias": "pria_mengangkat_beban_angkat_laki-laki",
    },
    "\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_lifting_weights",
        "id": "wanita_mengangkat_beban",
        "alias": "wanita_mengangkat_beban_angkat_perempuan",
    },
    "\U0001F6B4": {
        "en": "person_biking",
        "id": "orang_bersepeda",
        "alias": "orang_bersepeda_sepeda",
    },
    "\U0001F6B4\U0000200D\U00002642\U0000FE0F": {
        "en": "man_biking",
        "id": "pria_bersepeda",
        "alias": "pria_bersepeda_laki-laki_sepeda",
    },
    "\U0001F6B4\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_biking",
        "id": "wanita_bersepeda",
        "alias": "wanita_bersepeda_perempuan_sepeda",
    },
    "\U0001F6B5": {
        "en": "person_mountain_biking",
        "id": "orang_bersepeda_gunung",
        "alias": "orang_bersepeda_gunung_pesepeda_sepeda",
    },
    "\U0001F6B5\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mountain_biking",
        "id": "pria_bersepeda_gunung",
        "alias": "pria_bersepeda_gunung_laki-laki_sepeda",
    },
    "\U0001F6B5\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mountain_biking",
        "id": "wanita_bersepeda_gunung",
        "alias": "wanita_bersepeda_gunung_perempuan_sepeda",
    },
    "\U0001F938": {
        "en": "person_cartwheeling",
        "id": "orang_melakukan_gerakan_meroda",
        "alias": "orang_melakukan_gerakan_meroda_gimnastik_olahraga_salto_senam",
    },
    "\U0001F938\U0000200D\U00002642\U0000FE0F": {
        "en": "man_cartwheeling",
        "id": "pria_melakukan_gerakan_meroda",
        "alias": "pria_melakukan_gerakan_meroda_balik_jungkir_laki-laki",
    },
    "\U0001F938\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_cartwheeling",
        "id": "wanita_melakukan_gerakan_meroda",
        "alias": "wanita_melakukan_gerakan_meroda_balik_jungkir_perempuan",
    },
    "\U0001F93C": {
        "en": "people_wrestling",
        "id": "orang_bergulat",
        "alias": "orang_bergulat_gulat_olahraga_pegulat",
    },
    "\U0001F93C\U0000200D\U00002642\U0000FE0F": {
        "en": "men_wrestling",
        "id": "pria_bergulat",
        "alias": "pria_bergulat_gulat_laki-laki",
    },
    "\U0001F93C\U0000200D\U00002640\U0000FE0F": {
        "en": "women_wrestling",
        "id": "wanita_bergulat",
        "alias": "wanita_bergulat_gulat_perempuan",
    },
    "\U0001F93D": {
        "en": "person_playing_water_polo",
        "id": "orang_bermain_polo_air",
        "alias": "orang_bermain_polo_air_olahraga",
    },
    "\U0001F93D\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_water_polo",
        "id": "pria_bermain_polo_air",
        "alias": "pria_bermain_polo_air_laki-laki",
    },
    "\U0001F93D\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_water_polo",
        "id": "wanita_bermain_polo_air",
        "alias": "wanita_bermain_polo_air_perempuan",
    },
    "\U0001F93E": {
        "en": "person_playing_handball",
        "id": "orang_bermain_bola_tangan",
        "alias": "orang_bermain_bola_tangan_olahraga",
    },
    "\U0001F93E\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_handball",
        "id": "pria_bermain_bola_tangan",
        "alias": "pria_bermain_bola_tangan_laki-laki",
    },
    "\U0001F93E\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_handball",
        "id": "wanita_bermain_bola_tangan",
        "alias": "wanita_bermain_bola_tangan_perempuan",
    },
    "\U0001F939": {
        "en": "person_juggling",
        "id": "orang_melempar",
        "alias": "orang_melempar_juggling_multitasking_repot_sibuk",
    },
    "\U0001F939\U0000200D\U00002642\U0000FE0F": {
        "en": "man_juggling",
        "id": "pria_melempar",
        "alias": "pria_melempar_atraksi_laki-laki",
    },
    "\U0001F939\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_juggling",
        "id": "wanita_melempar",
        "alias": "wanita_melempar_atraksi_perempuan",
    },
    "\U0001F9D8": {
        "en": "person_in_lotus_position",
        "id": "orang_dalam_posisi_teratai",
        "alias": "orang_dalam_posisi_teratai_meditasi_yoga",
    },
    "\U0001F9D8\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_lotus_position",
        "id": "pria_dalam_posisi_teratai",
        "alias": "pria_dalam_posisi_teratai_meditasi_yoga",
    },
    "\U0001F9D8\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_lotus_position",
        "id": "wanita_dalam_posisi_teratai",
        "alias": "wanita_dalam_posisi_teratai_meditasi_yoga",
    },
    "\U0001F6C0": {"en": "person_taking_bath", "id": "orang_di_bak_mandi"},
    "\U0001F6CC": {
        "en": "person_in_bed",
        "id": "orang_di_tempat_tidur",
        "alias": "orang_di_tempat_tidur_hotel",
    },
    "\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1": {
        "en": "people_holding_hands",
        "id": "orang_bergandengan",
        "alias": "orang_bergandengan_pasangan_tangan",
    },
    "\U0001F46D": {
        "en": "women_holding_hands",
        "id": "dua_wanita_bergandengan",
        "alias": "dua_wanita_bergandengan_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F46B": {
        "en": "woman_and_man_holding_hands",
        "id": "pria_dan_wanita_bergandengan",
        "alias": "pria_dan_wanita_bergandengan_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F46C": {
        "en": "men_holding_hands",
        "id": "dua_pria_bergandengan",
        "alias": "dua_pria_bergandengan_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F48F": {"en": "kiss", "id": "berciuman", "alias": "berciuman_cium_pasangan_romantis"},
    "\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468": {
        "en": "kiss_woman_man",
        "id": "berciuman_wanita_pria",
        "alias": "berciuman_wanita_pria_cium_pasangan_romantis",
    },
    "\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468": {
        "en": "kiss_man_man",
        "id": "berciuman_pria_pria",
        "alias": "berciuman_pria_cium_pasangan_romantis",
    },
    "\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469": {
        "en": "kiss_woman_woman",
        "id": "berciuman_wanita_wanita",
        "alias": "berciuman_wanita_cium_pasangan_romantis",
    },
    "\U0001F491": {
        "en": "couple_with_heart",
        "id": "pasangan_dengan_hati",
        "alias": "pasangan_dengan_hati_cinta_romantis",
    },
    "\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468": {
        "en": "couple_with_heart_woman_man",
        "id": "pasangan_dengan_hati_wanita_pria",
        "alias": "pasangan_dengan_hati_wanita_pria_cinta_romantis",
    },
    "\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468": {
        "en": "couple_with_heart_man_man",
        "id": "pasangan_dengan_hati_pria_pria",
        "alias": "pasangan_dengan_hati_pria_cinta_romantis",
    },
    "\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469": {
        "en": "couple_with_heart_woman_woman",
        "id": "pasangan_dengan_hati_wanita_wanita",
        "alias": "pasangan_dengan_hati_wanita_cinta_romantis",
    },
    "\U0001F46A": {
        "en": "family",
        "id": "keluarga",
        "alias": "keluarga_anak_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466": {
        "en": "family_man_woman_boy",
        "id": "keluarga_pria_wanita_anak_laki-laki",
        "alias": "keluarga_pria_wanita_anak_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467": {
        "en": "family_man_woman_girl",
        "id": "keluarga_pria_wanita_anak_perempuan",
        "alias": "keluarga_pria_wanita_anak_perempuan_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466": {
        "en": "family_man_woman_girl_boy",
        "id": "keluarga_pria_wanita_anak_perempuan_anak_laki-laki",
        "alias": "keluarga_pria_wanita_anak_perempuan_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466": {
        "en": "family_man_woman_boy_boy",
        "id": "keluarga_pria_wanita_anak_laki-laki_anak_laki-laki",
        "alias": "keluarga_pria_wanita_anak_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467": {
        "en": "family_man_woman_girl_girl",
        "id": "keluarga_pria_wanita_anak_perempuan_anak_perempuan",
        "alias": "keluarga_pria_wanita_anak_perempuan_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466": {
        "en": "family_man_man_boy",
        "id": "keluarga_pria_pria_anak_laki-laki",
        "alias": "keluarga_pria_anak_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467": {
        "en": "family_man_man_girl",
        "id": "keluarga_pria_pria_anak_perempuan",
        "alias": "keluarga_pria_anak_perempuan_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466": {
        "en": "family_man_man_girl_boy",
        "id": "keluarga_pria_pria_anak_perempuan_anak_laki-laki",
        "alias": "keluarga_pria_anak_perempuan_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466": {
        "en": "family_man_man_boy_boy",
        "id": "keluarga_pria_pria_anak_laki-laki_anak_laki-laki",
        "alias": "keluarga_pria_anak_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467": {
        "en": "family_man_man_girl_girl",
        "id": "keluarga_pria_pria_anak_perempuan_anak_perempuan",
        "alias": "keluarga_pria_anak_perempuan_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466": {
        "en": "family_woman_woman_boy",
        "id": "keluarga_wanita_wanita_anak_laki-laki",
        "alias": "keluarga_wanita_anak_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467": {
        "en": "family_woman_woman_girl",
        "id": "keluarga_wanita_wanita_anak_perempuan",
        "alias": "keluarga_wanita_anak_perempuan_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466": {
        "en": "family_woman_woman_girl_boy",
        "id": "keluarga_wanita_wanita_anak_perempuan_anak_laki-laki",
        "alias": "keluarga_wanita_anak_perempuan_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466": {
        "en": "family_woman_woman_boy_boy",
        "id": "keluarga_wanita_wanita_anak_laki-laki_anak_laki-laki",
        "alias": "keluarga_wanita_anak_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467": {
        "en": "family_woman_woman_girl_girl",
        "id": "keluarga_wanita_wanita_anak_perempuan_anak_perempuan",
        "alias": "keluarga_wanita_anak_perempuan_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F466": {
        "en": "family_man_boy",
        "id": "keluarga_pria_anak_laki-laki",
        "alias": "keluarga_pria_anak_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466": {
        "en": "family_man_boy_boy",
        "id": "keluarga_pria_anak_laki-laki_anak_laki-laki",
        "alias": "keluarga_pria_anak_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F467": {
        "en": "family_man_girl",
        "id": "keluarga_pria_anak_perempuan",
        "alias": "keluarga_pria_anak_perempuan_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466": {
        "en": "family_man_girl_boy",
        "id": "keluarga_pria_anak_perempuan_anak_laki-laki",
        "alias": "keluarga_pria_anak_perempuan_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467": {
        "en": "family_man_girl_girl",
        "id": "keluarga_pria_anak_perempuan_anak_perempuan",
        "alias": "keluarga_pria_anak_perempuan_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F469\U0000200D\U0001F466": {
        "en": "family_woman_boy",
        "id": "keluarga_wanita_anak_laki-laki",
        "alias": "keluarga_wanita_anak_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466": {
        "en": "family_woman_boy_boy",
        "id": "keluarga_wanita_anak_laki-laki_anak_laki-laki",
        "alias": "keluarga_wanita_anak_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F469\U0000200D\U0001F467": {
        "en": "family_woman_girl",
        "id": "keluarga_wanita_anak_perempuan",
        "alias": "keluarga_wanita_anak_perempuan_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466": {
        "en": "family_woman_girl_boy",
        "id": "keluarga_wanita_anak_perempuan_anak_laki-laki",
        "alias": "keluarga_wanita_anak_perempuan_laki-laki_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467": {
        "en": "family_woman_girl_girl",
        "id": "keluarga_wanita_anak_perempuan_anak_perempuan",
        "alias": "keluarga_wanita_anak_perempuan_ayah_bapak_ibu_mama_papa",
    },
    "\U0001F5E3\U0000FE0F": {
        "en": "speaking_head",
        "id": "kepala_berbicara",
        "alias": "kepala_berbicara_bicara_siluet_wajah",
    },
    "\U0001F464": {
        "en": "bust_in_silhouette",
        "id": "siluet_foto_setengah_badan",
        "alias": "siluet_foto_setengah_badan_bayangan",
    },
    "\U0001F465": {
        "en": "busts_in_silhouette",
        "id": "beberapa_siluet_foto_setengah_badan",
        "alias": "beberapa_siluet_foto_setengah_badan_bayangan",
    },
    "\U0001FAC2": {
        "en": "people_hugging",
        "id": "orang_berpelukan",
        "alias": "orang_berpelukan_halo_peluk_selamat_tinggal_terima_kasih",
    },
    "\U0001F463": {"en": "footprints", "id": "jejak_kaki", "alias": "jejak_kaki_badan_tubuh"},
    "\U0001F9B0": {
        "en": "red_hair",
        "id": "rambut_merah",
        "alias": "rambut_merah_cokelat_kemerahan",
    },
    "\U0001F9B1": {
        "en": "curly_hair",
        "id": "rambut_keriting",
        "alias": "rambut_keriting_afro_ikal",
    },
    "\U0001F9B3": {"en": "white_hair", "id": "rambut_putih", "alias": "rambut_putih_abu-abu_tua"},
    "\U0001F9B2": {"en": "bald", "id": "gundul", "alias": "gundul_botak_kemoterapi_tak_berambut"},
    "\U0001F435": {"en": "monkey_face", "id": "wajah_monyet", "alias": "wajah_monyet_muka"},
    "\U0001F412": {"en": "monkey", "id": "monyet"},
    "\U0001F98D": {"en": "gorilla", "id": "gorila", "alias": "gorila_binatang_kingkong"},
    "\U0001F9A7": {"en": "orangutan", "id": "orangutan", "alias": "orangutan_kera"},
    "\U0001F436": {"en": "dog_face", "id": "wajah_anjing", "alias": "wajah_anjing_hewan_muka"},
    "\U0001F415": {"en": "dog", "id": "anjing", "alias": "anjing_hewan"},
    "\U0001F9AE": {
        "en": "guide_dog",
        "id": "anjing_pemandu",
        "alias": "anjing_pemandu_aksesibilitas_buta_panduan_tunanetra",
    },
    "\U0001F415\U0000200D\U0001F9BA": {
        "en": "service_dog",
        "id": "anjing_pembimbing",
        "alias": "anjing_pembimbing_aksesibilitas_bantuan_bimbingan",
    },
    "\U0001F429": {"en": "poodle", "id": "pudel", "alias": "pudel_anjing"},
    "\U0001F43A": {"en": "wolf", "id": "serigala", "alias": "serigala_muka_wajah"},
    "\U0001F98A": {"en": "fox", "id": "rubah", "alias": "rubah_muka_wajah"},
    "\U0001F99D": {"en": "raccoon", "id": "rakun", "alias": "rakun_licik_penasaran"},
    "\U0001F431": {"en": "cat_face", "id": "wajah_kucing", "alias": "wajah_kucing_hewan_muka"},
    "\U0001F408": {"en": "cat", "id": "kucing", "alias": "kucing_hewan"},
    "\U0001F408\U0000200D\U00002B1B": {
        "en": "black_cat",
        "id": "kucing_hitam",
        "alias": "kucing_hitam_kesialan",
    },
    "\U0001F981": {"en": "lion", "id": "singa", "alias": "singa_leo_muka_wajah_zodiak"},
    "\U0001F42F": {"en": "tiger_face", "id": "wajah_harimau", "alias": "wajah_harimau_macan_muka"},
    "\U0001F405": {"en": "tiger", "id": "harimau"},
    "\U0001F406": {"en": "leopard", "id": "macan_tutul"},
    "\U0001F434": {"en": "horse_face", "id": "wajah_kuda", "alias": "wajah_kuda_muka"},
    "\U0001F40E": {"en": "horse", "id": "kuda", "alias": "kuda_balap_pacuan"},
    "\U0001F984": {"en": "unicorn", "id": "unicorn", "alias": "unicorn_muka_wajah"},
    "\U0001F993": {"en": "zebra", "id": "zebra", "alias": "zebra_belang"},
    "\U0001F98C": {"en": "deer", "id": "rusa", "alias": "rusa_binatang"},
    "\U0001F9AC": {"en": "bison", "id": "bison", "alias": "bison_eropa_kawanan_kerbau"},
    "\U0001F42E": {"en": "cow_face", "id": "wajah_sapi", "alias": "wajah_sapi_muka"},
    "\U0001F402": {"en": "ox", "id": "lembu", "alias": "lembu_taurus_zodiak"},
    "\U0001F403": {"en": "water_buffalo", "id": "kerbau", "alias": "kerbau_air"},
    "\U0001F404": {"en": "cow", "id": "sapi"},
    "\U0001F437": {"en": "pig_face", "id": "wajah_babi", "alias": "wajah_babi_muka"},
    "\U0001F416": {"en": "pig", "id": "babi"},
    "\U0001F417": {"en": "boar", "id": "babi_hutan"},
    "\U0001F43D": {"en": "pig_nose", "id": "hidung_babi", "alias": "hidung_babi_muka_wajah"},
    "\U0001F40F": {"en": "ram", "id": "domba_jantan", "alias": "domba_jantan_aries_zodiak"},
    "\U0001F411": {"en": "ewe", "id": "domba_betina"},
    "\U0001F410": {"en": "goat", "id": "kambing", "alias": "kambing_capricorn_zodiak"},
    "\U0001F42A": {"en": "camel", "id": "unta", "alias": "unta_dromedari_punuk"},
    "\U0001F42B": {
        "en": "two-hump_camel",
        "id": "unta_berpunuk_dua",
        "alias": "unta_berpunuk_dua_baktrian_punuk",
    },
    "\U0001F999": {"en": "llama", "id": "llama", "alias": "llama_alpaka_guanako_vikuna_wol"},
    "\U0001F992": {"en": "giraffe", "id": "jerapah", "alias": "jerapah_bintik"},
    "\U0001F418": {"en": "elephant", "id": "gajah"},
    "\U0001F9A3": {
        "en": "mammoth",
        "id": "mamut",
        "alias": "mamut_berbulu_tebal_besar_gading_kepunahan",
    },
    "\U0001F98F": {"en": "rhinoceros", "id": "badak", "alias": "badak_binatang"},
    "\U0001F99B": {"en": "hippopotamus", "id": "kuda_nil"},
    "\U0001F42D": {"en": "mouse_face", "id": "wajah_tikus", "alias": "wajah_tikus_muka"},
    "\U0001F401": {"en": "mouse", "id": "tikus_putih"},
    "\U0001F400": {"en": "rat", "id": "tikus"},
    "\U0001F439": {"en": "hamster", "id": "hamster", "alias": "hamster_hewan_peliharaan_wajah"},
    "\U0001F430": {
        "en": "rabbit_face",
        "id": "wajah_kelinci",
        "alias": "wajah_kelinci_hewan_peliharaan",
    },
    "\U0001F407": {"en": "rabbit", "id": "kelinci", "alias": "kelinci_hewan_peliharaan"},
    "\U0001F43F\U0000FE0F": {"en": "chipmunk", "id": "tupai"},
    "\U0001F9AB": {"en": "beaver", "id": "biwara", "alias": "biwara_bendungan"},
    "\U0001F994": {"en": "hedgehog", "id": "landak", "alias": "landak_berduri"},
    "\U0001F987": {"en": "bat", "id": "kelelawar", "alias": "kelelawar_binatang_vampir"},
    "\U0001F43B": {"en": "bear", "id": "beruang", "alias": "beruang_muka_wajah"},
    "\U0001F43B\U0000200D\U00002744\U0000FE0F": {
        "en": "polar_bear",
        "id": "beruang_kutub",
        "alias": "beruang_kutub_arktika_putih",
    },
    "\U0001F428": {"en": "koala", "id": "koala", "alias": "koala_beruang"},
    "\U0001F43C": {"en": "panda", "id": "panda", "alias": "panda_muka_wajah"},
    "\U0001F9A5": {"en": "sloth", "id": "kungkang", "alias": "kungkang_lambat_malas"},
    "\U0001F9A6": {
        "en": "otter",
        "id": "berang-berang",
        "alias": "berang-berang_ceria_gembira_menangkap_ikan",
    },
    "\U0001F9A8": {"en": "skunk", "id": "sigung", "alias": "sigung_bau_busuk"},
    "\U0001F998": {
        "en": "kangaroo",
        "id": "kanguru",
        "alias": "kanguru_australia_joey_lompat_marsupialia",
    },
    "\U0001F9A1": {"en": "badger", "id": "musang", "alias": "musang_hewan_pengganggu_ratel"},
    "\U0001F43E": {
        "en": "paw_prints",
        "id": "jejak_kaki_hewan",
        "alias": "jejak_kaki_hewan_cakar",
    },
    "\U0001F983": {"en": "turkey", "id": "kalkun", "alias": "kalkun_burung"},
    "\U0001F414": {"en": "chicken", "id": "ayam", "alias": "ayam_burung"},
    "\U0001F413": {"en": "rooster", "id": "ayam_jago", "alias": "ayam_jago_burung"},
    "\U0001F423": {
        "en": "hatching_chick",
        "id": "itik_menetas",
        "alias": "itik_menetas_ayam_bayi",
    },
    "\U0001F424": {"en": "baby_chick", "id": "itik_bayi", "alias": "itik_bayi_ayam"},
    "\U0001F425": {
        "en": "front-facing_baby_chick",
        "id": "itik_bayi_menghadap_ke_depan",
        "alias": "itik_bayi_menghadap_ke_depan_ayam",
    },
    "\U0001F426": {"en": "bird", "id": "burung"},
    "\U0001F427": {"en": "penguin", "id": "pinguin", "alias": "pinguin_burung"},
    "\U0001F54A\U0000FE0F": {
        "en": "dove",
        "id": "merpati",
        "alias": "merpati_burung_damai_terbang",
    },
    "\U0001F985": {"en": "eagle", "id": "elang", "alias": "elang_burung"},
    "\U0001F986": {"en": "duck", "id": "bebek", "alias": "bebek_unggas"},
    "\U0001F9A2": {"en": "swan", "id": "angsa", "alias": "angsa_muda_burung_itik_buruk_rupa"},
    "\U0001F989": {"en": "owl", "id": "burung_hantu", "alias": "burung_hantu_bijaksana"},
    "\U0001F9A4": {"en": "dodo", "id": "dodo", "alias": "dodo_besar_mauritius_punah"},
    "\U0001FAB6": {"en": "feather", "id": "bulu", "alias": "bulu_burung_penerbangan_ringan"},
    "\U0001F9A9": {
        "en": "flamingo",
        "id": "flamingo",
        "alias": "flamingo_flamboyan_tropikal_tropis",
    },
    "\U0001F99A": {"en": "peacock", "id": "merak", "alias": "merak_angkuh_burung_betina_mewah"},
    "\U0001F99C": {"en": "parrot", "id": "nuri", "alias": "nuri_bajak_laut_bicara_burung"},
    "\U0001F438": {"en": "frog", "id": "katak", "alias": "katak_muka_wajah"},
    "\U0001F40A": {"en": "crocodile", "id": "buaya"},
    "\U0001F422": {"en": "turtle", "id": "kura-kura", "alias": "kura-kura_penyu_terrapin"},
    "\U0001F98E": {"en": "lizard", "id": "kadal", "alias": "kadal_reptil"},
    "\U0001F40D": {"en": "snake", "id": "ular", "alias": "ular_ofiukus_pembawa_zodiak"},
    "\U0001F432": {"en": "dragon_face", "id": "wajah_naga", "alias": "wajah_naga_dongeng_muka"},
    "\U0001F409": {"en": "dragon", "id": "naga", "alias": "naga_dongeng"},
    "\U0001F995": {
        "en": "sauropod",
        "id": "sauropod",
        "alias": "sauropod_brachiosaurus_brontosaurus_diplodocus",
    },
    "\U0001F996": {"en": "t-rex", "id": "t-rex", "alias": "t-rex_tyrannosaurus_rex"},
    "\U0001F433": {
        "en": "spouting_whale",
        "id": "ikan_paus_menyembur",
        "alias": "ikan_paus_menyembur_muka_sembur_wajah",
    },
    "\U0001F40B": {"en": "whale", "id": "ikan_paus"},
    "\U0001F42C": {"en": "dolphin", "id": "lumba-lumba"},
    "\U0001F9AD": {"en": "seal", "id": "anjing_laut", "alias": "anjing_laut_singa"},
    "\U0001F41F": {"en": "fish", "id": "ikan", "alias": "ikan_pisces_zodiak"},
    "\U0001F420": {"en": "tropical_fish", "id": "ikan_tropis"},
    "\U0001F421": {"en": "blowfish", "id": "ikan_gembung"},
    "\U0001F988": {"en": "shark", "id": "hiu", "alias": "hiu_ikan"},
    "\U0001F419": {"en": "octopus", "id": "gurita"},
    "\U0001F41A": {"en": "spiral_shell", "id": "cangkang_spiral"},
    "\U0001F40C": {"en": "snail", "id": "siput", "alias": "siput_keong"},
    "\U0001F98B": {"en": "butterfly", "id": "kupu-kupu", "alias": "kupu-kupu_cantik_serangga"},
    "\U0001F41B": {"en": "bug", "id": "serangga_kecil"},
    "\U0001F41C": {"en": "ant", "id": "semut", "alias": "semut_serangga"},
    "\U0001F41D": {"en": "honeybee", "id": "lebah_madu", "alias": "lebah_madu_serangga"},
    "\U0001FAB2": {"en": "beetle", "id": "kumbang", "alias": "kumbang_hama_serangga"},
    "\U0001F41E": {
        "en": "lady_beetle",
        "id": "kumbang_betina",
        "alias": "kumbang_betina_serangga",
    },
    "\U0001F997": {"en": "cricket", "id": "jangkrik", "alias": "jangkrik_belalang"},
    "\U0001FAB3": {"en": "cockroach", "id": "kecoak", "alias": "kecoak_coro_hama_serangga"},
    "\U0001F577\U0000FE0F": {"en": "spider", "id": "laba-laba", "alias": "laba-laba_serangga"},
    "\U0001F578\U0000FE0F": {
        "en": "spider_web",
        "id": "jaring_laba-laba",
        "alias": "jaring_laba-laba_sarang",
    },
    "\U0001F982": {"en": "scorpion", "id": "kalajengking", "alias": "kalajengking_scorpio_zodiak"},
    "\U0001F99F": {
        "en": "mosquito",
        "id": "nyamuk",
        "alias": "nyamuk_demam_malaria_penyakit_serangga_virus",
    },
    "\U0001FAB0": {"en": "fly", "id": "lalat", "alias": "lalat_belatung_hama_membusuk_penyakit"},
    "\U0001FAB1": {"en": "worm", "id": "cacing", "alias": "cacing_annelida_tanah_parasit"},
    "\U0001F9A0": {"en": "microbe", "id": "mikroba", "alias": "mikroba_amuba_bakteri_virus"},
    "\U0001F490": {
        "en": "bouquet",
        "id": "karangan_bunga",
        "alias": "karangan_bunga_romantis_tanaman",
    },
    "\U0001F338": {"en": "cherry_blossom", "id": "sakura", "alias": "sakura_bunga_mekar_tanaman"},
    "\U0001F4AE": {"en": "white_flower", "id": "bunga_putih"},
    "\U0001F3F5\U0000FE0F": {
        "en": "rosette",
        "id": "hiasan_mawar",
        "alias": "hiasan_mawar_tanaman",
    },
    "\U0001F339": {"en": "rose", "id": "mawar", "alias": "mawar_bunga_tanaman"},
    "\U0001F940": {"en": "wilted_flower", "id": "bunga_layu", "alias": "bunga_layu_kecewa"},
    "\U0001F33A": {
        "en": "hibiscus",
        "id": "kembang_sepatu",
        "alias": "kembang_sepatu_bunga_tanaman",
    },
    "\U0001F33B": {"en": "sunflower", "id": "bunga_matahari", "alias": "bunga_matahari_tanaman"},
    "\U0001F33C": {"en": "blossom", "id": "mekar", "alias": "mekar_bunga_tanaman"},
    "\U0001F337": {"en": "tulip", "id": "tulip", "alias": "tulip_bunga_tanaman"},
    "\U0001F331": {"en": "seedling", "id": "semai", "alias": "semai_muda_tanaman"},
    "\U0001FAB4": {
        "en": "potted_plant",
        "id": "tanaman_pot",
        "alias": "tanaman_pot_membosankan_merawat_rumah_tumbuh",
    },
    "\U0001F332": {
        "en": "evergreen_tree",
        "id": "pohon_hijau_abadi",
        "alias": "pohon_hijau_abadi_tanaman",
    },
    "\U0001F333": {
        "en": "deciduous_tree",
        "id": "pohon_meranggas",
        "alias": "pohon_meranggas_gugur_tanaman",
    },
    "\U0001F334": {"en": "palm_tree", "id": "pohon_palem", "alias": "pohon_palem_tanaman"},
    "\U0001F335": {"en": "cactus", "id": "kaktus", "alias": "kaktus_tanaman"},
    "\U0001F33E": {
        "en": "sheaf_of_rice",
        "id": "seikat_padi",
        "alias": "seikat_padi_bulir_nasi_tanaman",
    },
    "\U0001F33F": {"en": "herb", "id": "herba", "alias": "herba_daun_tanaman"},
    "\U00002618\U0000FE0F": {"en": "shamrock", "id": "shamrock", "alias": "shamrock_tanaman"},
    "\U0001F340": {
        "en": "four_leaf_clover",
        "id": "empat_daun_semanggi",
        "alias": "empat_daun_semanggi_4_tanaman",
    },
    "\U0001F341": {"en": "maple_leaf", "id": "daun_maple", "alias": "daun_maple_gugur_tanaman"},
    "\U0001F342": {
        "en": "fallen_leaf",
        "id": "daun_berguguran",
        "alias": "daun_berguguran_gugur_tanaman",
    },
    "\U0001F343": {
        "en": "leaf_fluttering_in_wind",
        "id": "daun_tertiup_angin",
        "alias": "daun_tertiup_angin_tanaman_terbang_tiup",
    },
    "\U0001F347": {"en": "grapes", "id": "anggur", "alias": "anggur_buah_tanaman"},
    "\U0001F348": {"en": "melon", "id": "melon", "alias": "melon_buah_tanaman"},
    "\U0001F349": {"en": "watermelon", "id": "semangka", "alias": "semangka_buah_tanaman"},
    "\U0001F34A": {"en": "tangerine", "id": "buah_jeruk", "alias": "buah_jeruk_tanaman"},
    "\U0001F34B": {"en": "lemon", "id": "lemon", "alias": "lemon_buah_tanaman"},
    "\U0001F34C": {"en": "banana", "id": "pisang", "alias": "pisang_buah_tanaman"},
    "\U0001F34D": {"en": "pineapple", "id": "nanas", "alias": "nanas_buah_tanaman"},
    "\U0001F96D": {"en": "mango", "id": "mangga", "alias": "mangga_buah_tropis"},
    "\U0001F34E": {"en": "red_apple", "id": "apel_merah", "alias": "apel_merah_buah_tanaman"},
    "\U0001F34F": {"en": "green_apple", "id": "apel_hijau", "alias": "apel_hijau_buah_tanaman"},
    "\U0001F350": {"en": "pear", "id": "pir", "alias": "pir_buah_tanaman"},
    "\U0001F351": {"en": "peach", "id": "persik", "alias": "persik_buah_tanaman"},
    "\U0001F352": {"en": "cherries", "id": "ceri", "alias": "ceri_buah_tanaman"},
    "\U0001F353": {"en": "strawberry", "id": "stroberi", "alias": "stroberi_beri_buah_tanaman"},
    "\U0001FAD0": {
        "en": "blueberries",
        "id": "blueberry",
        "alias": "blueberry_beri_bilberry_biru_bluberi",
    },
    "\U0001F95D": {"en": "kiwi_fruit", "id": "buah_kiwi", "alias": "buah_kiwi_makanan"},
    "\U0001F345": {"en": "tomato", "id": "tomat", "alias": "tomat_sayur_tanaman"},
    "\U0001FAD2": {"en": "olive", "id": "zaitun", "alias": "zaitun_makanan"},
    "\U0001F965": {"en": "coconut", "id": "kelapa", "alias": "kelapa_palem_pina_colada"},
    "\U0001F951": {
        "en": "avocado",
        "id": "alpukat",
        "alias": "alpukat_alpuket_avokad_avokado_buah_makanan",
    },
    "\U0001F346": {"en": "eggplant", "id": "terung", "alias": "terung_sayur_tanaman"},
    "\U0001F954": {"en": "potato", "id": "kentang", "alias": "kentang_makanan_sayur_sayuran"},
    "\U0001F955": {"en": "carrot", "id": "wortel", "alias": "wortel_makanan_sayur"},
    "\U0001F33D": {
        "en": "ear_of_corn",
        "id": "bonggol_jagung",
        "alias": "bonggol_jagung_bulir_tanaman",
    },
    "\U0001F336\U0000FE0F": {
        "en": "hot_pepper",
        "id": "cabai_pedas",
        "alias": "cabai_pedas_lada_tanaman",
    },
    "\U0001FAD1": {"en": "bell_pepper", "id": "paprika", "alias": "paprika_capsicum_sayuran"},
    "\U0001F952": {
        "en": "cucumber",
        "id": "ketimun",
        "alias": "ketimun_acar_makanan_sayuran_timun",
    },
    "\U0001F96C": {
        "en": "leafy_green",
        "id": "selada_hijau",
        "alias": "selada_hijau_bokcoy_kale_kubis",
    },
    "\U0001F966": {"en": "broccoli", "id": "brokoli", "alias": "brokoli_kubis"},
    "\U0001F9C4": {"en": "garlic", "id": "bawang_putih", "alias": "bawang_putih_bumbu_dapur"},
    "\U0001F9C5": {"en": "onion", "id": "bawang_bombay", "alias": "bawang_bombay_bumbu_dapur"},
    "\U0001F344": {"en": "mushroom", "id": "jamur", "alias": "jamur_tanaman"},
    "\U0001F95C": {
        "en": "peanuts",
        "id": "kacang_tanah",
        "alias": "kacang_tanah_makanan_sayur_sayuran",
    },
    "\U0001F330": {"en": "chestnut", "id": "kastanye", "alias": "kastanye_tanaman"},
    "\U0001F35E": {"en": "bread", "id": "roti"},
    "\U0001F950": {"en": "croissant", "id": "croissant", "alias": "croissant_roti_prancis"},
    "\U0001F956": {
        "en": "baguette_bread",
        "id": "roti_baguette",
        "alias": "roti_baguette_baget_panjang_prancis",
    },
    "\U0001FAD3": {
        "en": "flatbread",
        "id": "roti_pipih",
        "alias": "roti_pipih_areva_lavash_pita_naan",
    },
    "\U0001F968": {"en": "pretzel", "id": "pretzel", "alias": "pretzel_berkeluk"},
    "\U0001F96F": {"en": "bagel", "id": "bagel", "alias": "bagel_roti_schmear"},
    "\U0001F95E": {"en": "pancakes", "id": "panekuk", "alias": "panekuk_pancake_serabi"},
    "\U0001F9C7": {"en": "waffle", "id": "wafel", "alias": "wafel_makanan_waffle"},
    "\U0001F9C0": {"en": "cheese_wedge", "id": "irisan_keju"},
    "\U0001F356": {"en": "meat_on_bone", "id": "daging_pada_tulang"},
    "\U0001F357": {
        "en": "poultry_leg",
        "id": "kaki_ayam",
        "alias": "kaki_ayam_paha_tulang_unggas",
    },
    "\U0001F969": {
        "en": "cut_of_meat",
        "id": "potongan_daging",
        "alias": "potongan_daging_babi_domba_irisan_kambing_steak",
    },
    "\U0001F953": {
        "en": "bacon",
        "id": "babi_asap",
        "alias": "babi_asap_bacon_bakon_daging_makanan",
    },
    "\U0001F354": {"en": "hamburger", "id": "hamburger", "alias": "hamburger_burger"},
    "\U0001F35F": {"en": "french_fries", "id": "kentang_goreng"},
    "\U0001F355": {"en": "pizza", "id": "pizza", "alias": "pizza_keju_potongan"},
    "\U0001F32D": {"en": "hot_dog", "id": "hot_dog", "alias": "hot_dog_hotdog_sosis"},
    "\U0001F96A": {"en": "sandwich", "id": "roti_lapis"},
    "\U0001F32E": {"en": "taco", "id": "taco", "alias": "taco_meksiko"},
    "\U0001F32F": {"en": "burrito", "id": "burrito", "alias": "burrito_meksiko"},
    "\U0001FAD4": {"en": "tamale", "id": "tamale", "alias": "tamale_makanan_meksiko_terbungkus"},
    "\U0001F959": {
        "en": "stuffed_flatbread",
        "id": "roti_tawar_isi",
        "alias": "roti_tawar_isi_falafel_kebab_makanan",
    },
    "\U0001F9C6": {"en": "falafel", "id": "falafel", "alias": "falafel_bebola_kacang_arab"},
    "\U0001F95A": {"en": "egg", "id": "telur", "alias": "telur_makanan"},
    "\U0001F373": {"en": "cooking", "id": "memasak", "alias": "memasak_menggoreng_telur_wajan"},
    "\U0001F958": {
        "en": "shallow_pan_of_food",
        "id": "wajan_dangkal",
        "alias": "wajan_dangkal_kaserol_makanan_seafood",
    },
    "\U0001F372": {
        "en": "pot_of_food",
        "id": "panci_makanan",
        "alias": "panci_makanan_mangkuk_rebusan",
    },
    "\U0001FAD5": {
        "en": "fondue",
        "id": "fondue",
        "alias": "fondue_cokelat_keju_meleleh_periuk_swiss",
    },
    "\U0001F963": {
        "en": "bowl_with_spoon",
        "id": "mangkuk_dengan_sendok",
        "alias": "mangkuk_dengan_sendok_bubur_sarapan_sereal",
    },
    "\U0001F957": {
        "en": "green_salad",
        "id": "salad_hijau",
        "alias": "salad_hijau_makanan_sayuran",
    },
    "\U0001F37F": {"en": "popcorn", "id": "popcorn", "alias": "popcorn_berondong_jagung"},
    "\U0001F9C8": {"en": "butter", "id": "mentega", "alias": "mentega_produk_susu"},
    "\U0001F9C2": {"en": "salt", "id": "garam", "alias": "garam_bumbu_wadah"},
    "\U0001F96B": {"en": "canned_food", "id": "makanan_kaleng"},
    "\U0001F371": {"en": "bento_box", "id": "kotak_bento"},
    "\U0001F358": {"en": "rice_cracker", "id": "kerupuk_beras", "alias": "kerupuk_beras_biskuit"},
    "\U0001F359": {"en": "rice_ball", "id": "nasi_kepal", "alias": "nasi_kepal_bola_jepang"},
    "\U0001F35A": {"en": "cooked_rice", "id": "nasi_matang", "alias": "nasi_matang_masak"},
    "\U0001F35B": {"en": "curry_rice", "id": "nasi_kari"},
    "\U0001F35C": {
        "en": "steaming_bowl",
        "id": "mangkuk_mengepul",
        "alias": "mangkuk_mengepul_mie_ramen_rebusan",
    },
    "\U0001F35D": {"en": "spaghetti", "id": "spageti", "alias": "spageti_pasta"},
    "\U0001F360": {
        "en": "roasted_sweet_potato",
        "id": "ubi_panggang",
        "alias": "ubi_panggang_kentang_manis",
    },
    "\U0001F362": {"en": "oden", "id": "oden", "alias": "oden_kebab_laut_makanan_tempura_udang"},
    "\U0001F363": {"en": "sushi", "id": "sushi"},
    "\U0001F364": {"en": "fried_shrimp", "id": "udang_goreng", "alias": "udang_goreng_tempura"},
    "\U0001F365": {
        "en": "fish_cake_with_swirl",
        "id": "kue_ikan_dengan_desain_pusaran",
        "alias": "kue_ikan_dengan_desain_pusaran_pastri",
    },
    "\U0001F96E": {
        "en": "moon_cake",
        "id": "kue_bulan",
        "alias": "kue_bulan_festival_musim_gugur_yuebing",
    },
    "\U0001F361": {
        "en": "dango",
        "id": "dango",
        "alias": "dango_jepang_makanan_manis_penutup_sate_stik",
    },
    "\U0001F95F": {
        "en": "dumpling",
        "id": "dumpling",
        "alias": "dumpling_empanada_gyoza_jiaozi_pierogi",
    },
    "\U0001F960": {
        "en": "fortune_cookie",
        "id": "kue_keberuntungan",
        "alias": "kue_keberuntungan_ramalan",
    },
    "\U0001F961": {
        "en": "takeout_box",
        "id": "kotak_makanan",
        "alias": "kotak_makanan_wadah_tionghoa",
    },
    "\U0001F980": {"en": "crab", "id": "kepiting", "alias": "kepiting_cancer_zodiak"},
    "\U0001F99E": {"en": "lobster", "id": "lobster", "alias": "lobster_capit_hidangan_laut_sup"},
    "\U0001F990": {"en": "shrimp", "id": "udang", "alias": "udang_makanan_seafood"},
    "\U0001F991": {
        "en": "squid",
        "id": "cumi-cumi",
        "alias": "cumi-cumi_cumi_makanan_moluska_seafood",
    },
    "\U0001F9AA": {"en": "oyster", "id": "tiram", "alias": "tiram_menyelam_mutiara"},
    "\U0001F366": {
        "en": "soft_ice_cream",
        "id": "es_krim_lembut",
        "alias": "es_krim_lembut_makanan_manis_penutup",
    },
    "\U0001F367": {
        "en": "shaved_ice",
        "id": "es_serut",
        "alias": "es_serut_makanan_manis_penutup",
    },
    "\U0001F368": {"en": "ice_cream", "id": "es_krim", "alias": "es_krim_makanan_manis_penutup"},
    "\U0001F369": {"en": "doughnut", "id": "donat", "alias": "donat_makanan_manis_penutup"},
    "\U0001F36A": {"en": "cookie", "id": "biskuit", "alias": "biskuit_makanan_manis_penutup"},
    "\U0001F382": {
        "en": "birthday_cake",
        "id": "kue_ulang_tahun",
        "alias": "kue_ulang_tahun_hidangan_penutup_manis_pastri_perayaan",
    },
    "\U0001F370": {
        "en": "shortcake",
        "id": "kue",
        "alias": "kue_makanan_manis_pastri_penutup_potongan",
    },
    "\U0001F9C1": {"en": "cupcake", "id": "kue_mangkuk", "alias": "kue_mangkuk_manis_roti"},
    "\U0001F967": {"en": "pie", "id": "pai", "alias": "pai_isi_kue_kering_pastri"},
    "\U0001F36B": {
        "en": "chocolate_bar",
        "id": "sebatang_cokelat",
        "alias": "sebatang_cokelat_batangan_makanan_manis_penutup",
    },
    "\U0001F36C": {"en": "candy", "id": "permen", "alias": "permen_makanan_manis_penutup"},
    "\U0001F36D": {
        "en": "lollipop",
        "id": "permen_lolipop",
        "alias": "permen_lolipop_makanan_manis_penutup",
    },
    "\U0001F36E": {
        "en": "custard",
        "id": "puding_susu",
        "alias": "puding_susu_makanan_manis_penutup",
    },
    "\U0001F36F": {"en": "honey_pot", "id": "toples_madu", "alias": "toples_madu_kendi_manis"},
    "\U0001F37C": {"en": "baby_bottle", "id": "botol_bayi", "alias": "botol_bayi_minuman_susu"},
    "\U0001F95B": {"en": "glass_of_milk", "id": "gelas_susu", "alias": "gelas_susu_minum"},
    "\U00002615": {
        "en": "hot_beverage",
        "id": "minuman_hangat",
        "alias": "minuman_hangat_kopi_mengepul_panas_teh",
    },
    "\U0001FAD6": {"en": "teapot", "id": "teko", "alias": "teko_minum_poci_teh"},
    "\U0001F375": {
        "en": "teacup_without_handle",
        "id": "cangkir_teh_tanpa_gagang",
        "alias": "cangkir_teh_tanpa_gagang_minuman",
    },
    "\U0001F376": {"en": "sake", "id": "sake", "alias": "sake_bar_botol_cangkir_minuman"},
    "\U0001F37E": {
        "en": "bottle_with_popping_cork",
        "id": "botol_dengan_penyumbat_terlepas",
        "alias": "botol_dengan_penyumbat_terlepas_bar_gabus_menyembul_minuman",
    },
    "\U0001F377": {"en": "wine_glass", "id": "gelas_anggur", "alias": "gelas_anggur_bar_minuman"},
    "\U0001F378": {
        "en": "cocktail_glass",
        "id": "gelas_cocktail",
        "alias": "gelas_cocktail_bar_koktail_minuman",
    },
    "\U0001F379": {"en": "tropical_drink", "id": "minuman_tropis", "alias": "minuman_tropis_bar"},
    "\U0001F37A": {"en": "beer_mug", "id": "mug_bir", "alias": "mug_bir_bar_minuman"},
    "\U0001F37B": {
        "en": "clinking_beer_mugs",
        "id": "mug_bir_berdenting",
        "alias": "mug_bir_berdenting_bar_berbenturan_minuman_tos",
    },
    "\U0001F942": {
        "en": "clinking_glasses",
        "id": "mendentingkan_gelas",
        "alias": "mendentingkan_gelas_cling_hore_perayaan_pesta_selamat",
    },
    "\U0001F943": {
        "en": "tumbler_glass",
        "id": "gelas_tumbler",
        "alias": "gelas_tumbler_alkohol_minum-minum_whisky_wiski",
    },
    "\U0001F964": {
        "en": "cup_with_straw",
        "id": "cangkir_dengan_sedotan",
        "alias": "cangkir_dengan_sedotan_jus_soda",
    },
    "\U0001F9CB": {"en": "bubble_tea", "id": "teh_bubble", "alias": "teh_bubble_pearl_susu"},
    "\U0001F9C3": {"en": "beverage_box", "id": "kotak_minuman", "alias": "kotak_minuman_jus"},
    "\U0001F9C9": {"en": "mate", "id": "teh_mate", "alias": "teh_mate_minuman"},
    "\U0001F9CA": {"en": "ice", "id": "es_batu", "alias": "es_batu_dingin_gunung"},
    "\U0001F962": {"en": "chopsticks", "id": "sumpit", "alias": "sumpit_hashi"},
    "\U0001F37D\U0000FE0F": {
        "en": "fork_and_knife_with_plate",
        "id": "garpu_dan_pisau_dengan_piring",
        "alias": "garpu_dan_pisau_dengan_piring_masak",
    },
    "\U0001F374": {
        "en": "fork_and_knife",
        "id": "garpu_dan_pisau",
        "alias": "garpu_dan_pisau_masak",
    },
    "\U0001F944": {"en": "spoon", "id": "sendok", "alias": "sendok_alat_makan_peralatan"},
    "\U0001F52A": {
        "en": "kitchen_knife",
        "id": "pisau_dapur",
        "alias": "pisau_dapur_alat_hocho_masak_senjata",
    },
    "\U0001F3FA": {
        "en": "amphora",
        "id": "amphora",
        "alias": "amphora_aquarius_kendi_memasak_minuman_zodiak",
    },
    "\U0001F30D": {
        "en": "globe_showing_europe-africa",
        "id": "bola_dunia_eropa-afrika",
        "alias": "bola_dunia_eropa-afrika_afrika_bumi_eropa_globe",
    },
    "\U0001F30E": {
        "en": "globe_showing_americas",
        "id": "bola_dunia_amerika",
        "alias": "bola_dunia_amerika_bumi_globe",
    },
    "\U0001F30F": {
        "en": "globe_showing_asia-australia",
        "id": "bola_dunia_asia-australia",
        "alias": "bola_dunia_asia-australia_asia_australia_bumi_globe",
    },
    "\U0001F310": {
        "en": "globe_with_meridians",
        "id": "bola_dunia_dengan_garis_meridian",
        "alias": "bola_dunia_dengan_garis_meridian_asia_globe_meridien",
    },
    "\U0001F5FA\U0000FE0F": {"en": "world_map", "id": "peta_dunia"},
    "\U0001F5FE": {"en": "map_of_japan", "id": "peta_jepang"},
    "\U0001F9ED": {"en": "compass", "id": "kompas", "alias": "kompas_magnetis_navigasi_orientasi"},
    "\U0001F3D4\U0000FE0F": {
        "en": "snow-capped_mountain",
        "id": "gunung_dengan_puncak_bersalju",
        "alias": "gunung_dengan_puncak_bersalju_dingin_salju",
    },
    "\U000026F0\U0000FE0F": {"en": "mountain", "id": "gunung"},
    "\U0001F30B": {"en": "volcano", "id": "gunung_berapi", "alias": "gunung_berapi_cuaca_erupsi"},
    "\U0001F5FB": {"en": "mount_fuji", "id": "gunung_fuji"},
    "\U0001F3D5\U0000FE0F": {"en": "camping", "id": "berkemah", "alias": "berkemah_kemah_tenda"},
    "\U0001F3D6\U0000FE0F": {"en": "beach_with_umbrella", "id": "pantai_dan_payung"},
    "\U0001F3DC\U0000FE0F": {"en": "desert", "id": "gurun"},
    "\U0001F3DD\U0000FE0F": {
        "en": "desert_island",
        "id": "pulau_terpencil",
        "alias": "pulau_terpencil_gurun",
    },
    "\U0001F3DE\U0000FE0F": {"en": "national_park", "id": "taman_nasional"},
    "\U0001F3DF\U0000FE0F": {"en": "stadium", "id": "stadion"},
    "\U0001F3DB\U0000FE0F": {"en": "classical_building", "id": "bangunan_klasik"},
    "\U0001F3D7\U0000FE0F": {"en": "building_construction", "id": "konstruksi_bangunan"},
    "\U0001F9F1": {
        "en": "brick",
        "id": "batu_bata",
        "alias": "batu_bata_adukan_semen_tanah_liat_tembok",
    },
    "\U0001FAA8": {"en": "rock", "id": "batu", "alias": "batu_besar_berat_cadas_padat"},
    "\U0001FAB5": {"en": "wood", "id": "kayu", "alias": "kayu_gelondong"},
    "\U0001F6D6": {"en": "hut", "id": "pondok", "alias": "pondok_rumah_bundar_yurt"},
    "\U0001F3D8\U0000FE0F": {
        "en": "houses",
        "id": "perumahan",
        "alias": "perumahan_bangunan_rumah",
    },
    "\U0001F3DA\U0000FE0F": {
        "en": "derelict_house",
        "id": "rumah_terlantar",
        "alias": "rumah_terlantar_bangunan",
    },
    "\U0001F3E0": {"en": "house", "id": "rumah", "alias": "rumah_bangunan"},
    "\U0001F3E1": {
        "en": "house_with_garden",
        "id": "rumah_dengan_taman",
        "alias": "rumah_dengan_taman_bangunan_kebun",
    },
    "\U0001F3E2": {"en": "office_building", "id": "gedung_perkantoran"},
    "\U0001F3E3": {
        "en": "japanese_post_office",
        "id": "kantor_pos_jepang",
        "alias": "kantor_pos_jepang_gedung",
    },
    "\U0001F3E4": {"en": "post_office", "id": "kantor_pos", "alias": "kantor_pos_eropa_gedung"},
    "\U0001F3E5": {
        "en": "hospital",
        "id": "rumah_sakit",
        "alias": "rumah_sakit_bangunan_dokter_obat",
    },
    "\U0001F3E6": {"en": "bank", "id": "bank", "alias": "bank_bangunan"},
    "\U0001F3E8": {"en": "hotel", "id": "hotel", "alias": "hotel_bangunan"},
    "\U0001F3E9": {"en": "love_hotel", "id": "hotel_cinta", "alias": "hotel_cinta_bangunan"},
    "\U0001F3EA": {
        "en": "convenience_store",
        "id": "minimarket",
        "alias": "minimarket_bangunan_toko",
    },
    "\U0001F3EB": {"en": "school", "id": "sekolah", "alias": "sekolah_bangunan"},
    "\U0001F3EC": {"en": "department_store", "id": "toserba", "alias": "toserba_bangunan"},
    "\U0001F3ED": {"en": "factory", "id": "pabrik", "alias": "pabrik_bangunan"},
    "\U0001F3EF": {
        "en": "japanese_castle",
        "id": "kastel_jepang",
        "alias": "kastel_jepang_bangunan",
    },
    "\U0001F3F0": {"en": "castle", "id": "kastel", "alias": "kastel_bangunan_eropa"},
    "\U0001F492": {"en": "wedding", "id": "pernikahan", "alias": "pernikahan_kapel_romantis"},
    "\U0001F5FC": {"en": "tokyo_tower", "id": "menara_tokyo"},
    "\U0001F5FD": {"en": "statue_of_liberty", "id": "patung_liberty"},
    "\U000026EA": {"en": "church", "id": "gereja", "alias": "gereja_agama_bangunan_kristen_salib"},
    "\U0001F54C": {"en": "mosque", "id": "masjid", "alias": "masjid_agama_islam_muslim"},
    "\U0001F6D5": {"en": "hindu_temple", "id": "pura", "alias": "pura_hindu"},
    "\U0001F54D": {"en": "synagogue", "id": "sinagog", "alias": "sinagog_agama_kuil_yahudi"},
    "\U000026E9\U0000FE0F": {
        "en": "shinto_shrine",
        "id": "kuil_shinto",
        "alias": "kuil_shinto_agama",
    },
    "\U0001F54B": {"en": "kaaba", "id": "kabah", "alias": "kabah_agama_islam_muslim"},
    "\U000026F2": {"en": "fountain", "id": "air_mancur", "alias": "air_mancur_pancuran"},
    "\U000026FA": {"en": "tent", "id": "tenda", "alias": "tenda_berkemah"},
    "\U0001F301": {"en": "foggy", "id": "berkabut", "alias": "berkabut_cuaca_kabut"},
    "\U0001F303": {
        "en": "night_with_stars",
        "id": "malam_berbintang",
        "alias": "malam_berbintang_bintang_cuaca",
    },
    "\U0001F3D9\U0000FE0F": {
        "en": "cityscape",
        "id": "panorama_kota",
        "alias": "panorama_kota_bangunan",
    },
    "\U0001F304": {
        "en": "sunrise_over_mountains",
        "id": "matahari_terbit_di_antara_gunung",
        "alias": "matahari_terbit_di_antara_gunung_cuaca_pagi",
    },
    "\U0001F305": {
        "en": "sunrise",
        "id": "matahari_terbit",
        "alias": "matahari_terbit_cuaca_pagi",
    },
    "\U0001F306": {
        "en": "cityscape_at_dusk",
        "id": "panorama_kota_di_sore_hari",
        "alias": "panorama_kota_di_sore_hari_matahari_terbenam_pemandangan_senja",
    },
    "\U0001F307": {
        "en": "sunset",
        "id": "matahari_terbenam",
        "alias": "matahari_terbenam_bangunan_cuaca_senja",
    },
    "\U0001F309": {
        "en": "bridge_at_night",
        "id": "jembatan_di_malam_hari",
        "alias": "jembatan_di_malam_hari_cuaca",
    },
    "\U00002668\U0000FE0F": {
        "en": "hot_springs",
        "id": "sumber_air_panas",
        "alias": "sumber_air_panas_mata_mengepul",
    },
    "\U0001F3A0": {
        "en": "carousel_horse",
        "id": "komidi_putar",
        "alias": "komidi_putar_karosel_kuda",
    },
    "\U0001F3A1": {
        "en": "ferris_wheel",
        "id": "kincir_ria",
        "alias": "kincir_ria_hiburan_roda_taman",
    },
    "\U0001F3A2": {
        "en": "roller_coaster",
        "id": "roller_coaster",
        "alias": "roller_coaster_hiburan_taman",
    },
    "\U0001F488": {
        "en": "barber_pole",
        "id": "tanda_salon",
        "alias": "tanda_salon_potong_rambut_tiang",
    },
    "\U0001F3AA": {"en": "circus_tent", "id": "tenda_sirkus"},
    "\U0001F682": {
        "en": "locomotive",
        "id": "lokomotif",
        "alias": "lokomotif_kendaraan_kereta_mesin_rel_uap",
    },
    "\U0001F683": {
        "en": "railway_car",
        "id": "gerbong",
        "alias": "gerbong_bus_listrik_kereta_api_mobil_rel_trem",
    },
    "\U0001F684": {
        "en": "high-speed_train",
        "id": "kereta_ekspres",
        "alias": "kereta_ekspres_cepat_kendaraan_rel_shinkansen",
    },
    "\U0001F685": {
        "en": "bullet_train",
        "id": "kereta_ekspres_peluru",
        "alias": "kereta_ekspres_peluru_cepat_kendaraan_rel_shinkansen",
    },
    "\U0001F686": {"en": "train", "id": "kereta", "alias": "kereta_kendaraan_rel"},
    "\U0001F687": {
        "en": "metro",
        "id": "kereta_bawah_tanah",
        "alias": "kereta_bawah_tanah_kendaraan",
    },
    "\U0001F688": {"en": "light_rail", "id": "light_rail", "alias": "light_rail_kendaraan_rel"},
    "\U0001F689": {"en": "station", "id": "stasiun", "alias": "stasiun_kendaraan_kereta_rel"},
    "\U0001F68A": {"en": "tram", "id": "trem", "alias": "trem_kendaraan_kereta_listrik"},
    "\U0001F69D": {"en": "monorail", "id": "monorel", "alias": "monorel_kendaraan"},
    "\U0001F69E": {
        "en": "mountain_railway",
        "id": "jalur_kereta_pegunungan",
        "alias": "jalur_kereta_pegunungan_gunung_kendaraan_mobil_rel",
    },
    "\U0001F68B": {
        "en": "tram_car",
        "id": "gerbong_trem",
        "alias": "gerbong_trem_kendaraan_kereta_mobil",
    },
    "\U0001F68C": {"en": "bus", "id": "bus", "alias": "bus_kendaraan"},
    "\U0001F68D": {"en": "oncoming_bus", "id": "bus_datang", "alias": "bus_datang_kendaraan"},
    "\U0001F68E": {"en": "trolleybus", "id": "bus_listrik", "alias": "bus_listrik_kendaraan_trem"},
    "\U0001F690": {"en": "minibus", "id": "minibus", "alias": "minibus_bus_kendaraan"},
    "\U0001F691": {"en": "ambulance", "id": "ambulans", "alias": "ambulans_kendaraan"},
    "\U0001F692": {
        "en": "fire_engine",
        "id": "mobil_pemadam_kebakaran",
        "alias": "mobil_pemadam_kebakaran_api_kendaraan_mesin_truk",
    },
    "\U0001F693": {
        "en": "police_car",
        "id": "mobil_polisi",
        "alias": "mobil_polisi_kendaraan_patroli",
    },
    "\U0001F694": {
        "en": "oncoming_police_car",
        "id": "mobil_polisi_datang",
        "alias": "mobil_polisi_datang_kendaraan",
    },
    "\U0001F695": {"en": "taxi", "id": "taksi", "alias": "taksi_kendaraan"},
    "\U0001F696": {"en": "oncoming_taxi", "id": "taksi_datang", "alias": "taksi_datang_kendaraan"},
    "\U0001F697": {"en": "automobile", "id": "mobil", "alias": "mobil_kendaraan"},
    "\U0001F698": {
        "en": "oncoming_automobile",
        "id": "mobil_datang",
        "alias": "mobil_datang_kendaraan",
    },
    "\U0001F699": {
        "en": "sport_utility_vehicle",
        "id": "kendaraan_rekreasi",
        "alias": "kendaraan_rekreasi_rv",
    },
    "\U0001F6FB": {"en": "pickup_truck", "id": "truk_pikap", "alias": "truk_pikap_pick-up"},
    "\U0001F69A": {
        "en": "delivery_truck",
        "id": "truk_pengiriman",
        "alias": "truk_pengiriman_kendaraan",
    },
    "\U0001F69B": {
        "en": "articulated_lorry",
        "id": "lori_gandeng",
        "alias": "lori_gandeng_kendaraan_semi_truk",
    },
    "\U0001F69C": {"en": "tractor", "id": "traktor", "alias": "traktor_kendaraan"},
    "\U0001F3CE\U0000FE0F": {
        "en": "racing_car",
        "id": "mobil_balap",
        "alias": "mobil_balap_balapan",
    },
    "\U0001F3CD\U0000FE0F": {
        "en": "motorcycle",
        "id": "sepeda_motor",
        "alias": "sepeda_motor_balapan",
    },
    "\U0001F6F5": {"en": "motor_scooter", "id": "motor_skuter", "alias": "motor_skuter_vespa"},
    "\U0001F9BD": {
        "en": "manual_wheelchair",
        "id": "kursi_roda_manual",
        "alias": "kursi_roda_manual_aksesibilitas",
    },
    "\U0001F9BC": {
        "en": "motorized_wheelchair",
        "id": "kursi_roda_bermotor",
        "alias": "kursi_roda_bermotor_aksesibilitas",
    },
    "\U0001F6FA": {"en": "auto_rickshaw", "id": "bajaj", "alias": "bajaj_tuk"},
    "\U0001F6B2": {"en": "bicycle", "id": "sepeda", "alias": "sepeda_kendaraan"},
    "\U0001F6F4": {"en": "kick_scooter", "id": "otoped", "alias": "otoped_skuter"},
    "\U0001F6F9": {"en": "skateboard", "id": "papan_luncur"},
    "\U0001F6FC": {"en": "roller_skate", "id": "sepatu_roda"},
    "\U0001F68F": {"en": "bus_stop", "id": "halte_bus", "alias": "halte_bus_perhentian"},
    "\U0001F6E3\U0000FE0F": {"en": "motorway", "id": "jalan_raya"},
    "\U0001F6E4\U0000FE0F": {
        "en": "railway_track",
        "id": "rel_kereta",
        "alias": "rel_kereta_jalan",
    },
    "\U0001F6E2\U0000FE0F": {"en": "oil_drum", "id": "drum_minyak"},
    "\U000026FD": {
        "en": "fuel_pump",
        "id": "pompa_bahan_bakar",
        "alias": "pompa_bahan_bakar_bensin_spbu_stasiun",
    },
    "\U0001F6A8": {
        "en": "police_car_light",
        "id": "lampu_mobil_polisi",
        "alias": "lampu_mobil_polisi_berputar_kendaraan_suar",
    },
    "\U0001F6A5": {
        "en": "horizontal_traffic_light",
        "id": "lampu_lalu_lintas_horizontal",
        "alias": "lampu_lalu_lintas_horizontal_sinyal",
    },
    "\U0001F6A6": {
        "en": "vertical_traffic_light",
        "id": "lampu_lalu_lintas_vertikal",
        "alias": "lampu_lalu_lintas_vertikal_sinyal",
    },
    "\U0001F6D1": {
        "en": "stop_sign",
        "id": "rambu_stop",
        "alias": "rambu_stop_heksagon_segi_enam_tanda",
    },
    "\U0001F6A7": {"en": "construction", "id": "konstruksi", "alias": "konstruksi_pembatas"},
    "\U00002693": {"en": "anchor", "id": "jangkar", "alias": "jangkar_alat_kapal"},
    "\U000026F5": {
        "en": "sailboat",
        "id": "perahu_layar",
        "alias": "perahu_layar_kapal_kendaraan_laut_pesiar_resor",
    },
    "\U0001F6F6": {"en": "canoe", "id": "kano", "alias": "kano_getek_perahu_sampan"},
    "\U0001F6A4": {"en": "speedboat", "id": "perahu_cepat", "alias": "perahu_cepat_kendaraan"},
    "\U0001F6F3\U0000FE0F": {
        "en": "passenger_ship",
        "id": "kapal_penumpang",
        "alias": "kapal_penumpang_kendaraan",
    },
    "\U000026F4\U0000FE0F": {"en": "ferry", "id": "kapal_feri", "alias": "kapal_feri_perahu"},
    "\U0001F6E5\U0000FE0F": {
        "en": "motor_boat",
        "id": "perahu_bermotor",
        "alias": "perahu_bermotor_kapal_kendaraan",
    },
    "\U0001F6A2": {"en": "ship", "id": "kapal", "alias": "kapal_kendaraan"},
    "\U00002708\U0000FE0F": {"en": "airplane", "id": "pesawat", "alias": "pesawat_kendaraan"},
    "\U0001F6E9\U0000FE0F": {
        "en": "small_airplane",
        "id": "pesawat_kecil",
        "alias": "pesawat_kecil_kendaraan",
    },
    "\U0001F6EB": {
        "en": "airplane_departure",
        "id": "pesawat_lepas_landas",
        "alias": "pesawat_lepas_landas_check-in_keberangkatan_kedatangan_kendaraan",
    },
    "\U0001F6EC": {
        "en": "airplane_arrival",
        "id": "pesawat_mendarat",
        "alias": "pesawat_mendarat_datang_kedatangan_kendaraan",
    },
    "\U0001FA82": {
        "en": "parachute",
        "id": "parasut",
        "alias": "parasut_hang-glide_parasail_terjun_payung",
    },
    "\U0001F4BA": {"en": "seat", "id": "kursi", "alias": "kursi_duduk"},
    "\U0001F681": {"en": "helicopter", "id": "helikopter", "alias": "helikopter_kendaraan"},
    "\U0001F69F": {
        "en": "suspension_railway",
        "id": "kereta_suspensi",
        "alias": "kereta_suspensi_kendaraan_rel",
    },
    "\U0001F6A0": {
        "en": "mountain_cableway",
        "id": "kereta_gantung",
        "alias": "kereta_gantung_gondola_gunung_kabel_kendaraan",
    },
    "\U0001F6A1": {
        "en": "aerial_tramway",
        "id": "trem_gantung",
        "alias": "trem_gantung_gondola_jalur_kabel",
    },
    "\U0001F6F0\U0000FE0F": {
        "en": "satellite",
        "id": "satelit",
        "alias": "satelit_angkasa_kendaraan",
    },
    "\U0001F680": {"en": "rocket", "id": "roket", "alias": "roket_angkasa_kendaraan"},
    "\U0001F6F8": {"en": "flying_saucer", "id": "piring_terbang", "alias": "piring_terbang_ufo"},
    "\U0001F6CE\U0000FE0F": {
        "en": "bellhop_bell",
        "id": "bel_meja",
        "alias": "bel_meja_hotel_lonceng_pelayan",
    },
    "\U0001F9F3": {"en": "luggage", "id": "koper", "alias": "koper_bepergian_berkemas"},
    "\U0000231B": {"en": "hourglass_done", "id": "jam_pasir", "alias": "jam_pasir_pewaktu"},
    "\U000023F3": {
        "en": "hourglass_not_done",
        "id": "jam_pasir_yang_bergerak",
        "alias": "jam_pasir_yang_bergerak_pewaktu",
    },
    "\U0000231A": {"en": "watch", "id": "jam_tangan"},
    "\U000023F0": {"en": "alarm_clock", "id": "jam_weker", "alias": "jam_weker_alarm"},
    "\U000023F1\U0000FE0F": {"en": "stopwatch", "id": "stopwatch", "alias": "stopwatch_jam"},
    "\U000023F2\U0000FE0F": {
        "en": "timer_clock",
        "id": "penghitung_waktu",
        "alias": "penghitung_waktu_jam_pewaktu",
    },
    "\U0001F570\U0000FE0F": {"en": "mantelpiece_clock", "id": "jam_perapian"},
    "\U0001F55B": {
        "en": "twelve_oclock",
        "id": "jam_dua_belas_tepat",
        "alias": "jam_dua_belas_tepat_00_12_12.00",
    },
    "\U0001F567": {
        "en": "twelve-thirty",
        "id": "jam_setengah_satu",
        "alias": "jam_setengah_satu_12_12.30_30_dua_belas_tiga_puluh",
    },
    "\U0001F550": {
        "en": "one_oclock",
        "id": "jam_satu_tepat",
        "alias": "jam_satu_tepat_00_1_1.00",
    },
    "\U0001F55C": {
        "en": "one-thirty",
        "id": "jam_setengah_dua",
        "alias": "jam_setengah_dua_1_1.30_30_satu_tiga_puluh",
    },
    "\U0001F551": {"en": "two_oclock", "id": "jam_dua_tepat", "alias": "jam_dua_tepat_00_2_2.00"},
    "\U0001F55D": {
        "en": "two-thirty",
        "id": "jam_setengah_tiga",
        "alias": "jam_setengah_tiga_2_2.30_30_dua_puluh",
    },
    "\U0001F552": {
        "en": "three_oclock",
        "id": "jam_tiga_tepat",
        "alias": "jam_tiga_tepat_00_3_3.00",
    },
    "\U0001F55E": {
        "en": "three-thirty",
        "id": "jam_setengah_empat",
        "alias": "jam_setengah_empat_3_3.30_30_tiga_puluh",
    },
    "\U0001F553": {
        "en": "four_oclock",
        "id": "jam_empat_tepat",
        "alias": "jam_empat_tepat_00_4_4.00",
    },
    "\U0001F55F": {
        "en": "four-thirty",
        "id": "jam_setengah_lima",
        "alias": "jam_setengah_lima_30_4_4.30_empat_tiga_puluh",
    },
    "\U0001F554": {
        "en": "five_oclock",
        "id": "jam_lima_tepat",
        "alias": "jam_lima_tepat_00_5_5.00",
    },
    "\U0001F560": {
        "en": "five-thirty",
        "id": "jam_setengah_enam",
        "alias": "jam_setengah_enam_30_5_5.30_lima_tiga_puluh",
    },
    "\U0001F555": {
        "en": "six_oclock",
        "id": "jam_enam_tepat",
        "alias": "jam_enam_tepat_00_6_6.00",
    },
    "\U0001F561": {
        "en": "six-thirty",
        "id": "jam_setengah_tujuh",
        "alias": "jam_setengah_tujuh_30_6_6.30_enam_tiga_puluh",
    },
    "\U0001F556": {
        "en": "seven_oclock",
        "id": "jam_tujuh_tepat",
        "alias": "jam_tujuh_tepat_00_7_7.00",
    },
    "\U0001F562": {
        "en": "seven-thirty",
        "id": "jam_setengah_delapan",
        "alias": "jam_setengah_delapan_30_7_7.30_tiga_puluh_tujuh",
    },
    "\U0001F557": {
        "en": "eight_oclock",
        "id": "jam_delapan_tepat",
        "alias": "jam_delapan_tepat_00_8_8.00",
    },
    "\U0001F563": {
        "en": "eight-thirty",
        "id": "jam_setengah_sembilan",
        "alias": "jam_setengah_sembilan_30_8_8.30_delapan_tiga_puluh",
    },
    "\U0001F558": {
        "en": "nine_oclock",
        "id": "jam_sembilan_tepat",
        "alias": "jam_sembilan_tepat_00_9_9.00",
    },
    "\U0001F564": {
        "en": "nine-thirty",
        "id": "jam_setengah_sepuluh",
        "alias": "jam_setengah_sepuluh_30_9_9.30_sembilan_tiga_puluh",
    },
    "\U0001F559": {
        "en": "ten_oclock",
        "id": "jam_sepuluh_tepat",
        "alias": "jam_sepuluh_tepat_00_10_10.00",
    },
    "\U0001F565": {
        "en": "ten-thirty",
        "id": "jam_setengah_sebelas",
        "alias": "jam_setengah_sebelas_10_10.30_30_sepuluh_tiga_puluh",
    },
    "\U0001F55A": {
        "en": "eleven_oclock",
        "id": "jam_sebelas_tepat",
        "alias": "jam_sebelas_tepat_00_11_11.00",
    },
    "\U0001F566": {
        "en": "eleven-thirty",
        "id": "jam_setengah_dua_belas",
        "alias": "jam_setengah_dua_belas_11_11.30_30_sebelas_tiga_puluh",
    },
    "\U0001F311": {
        "en": "new_moon",
        "id": "bulan_baru",
        "alias": "bulan_baru_angkasa_cuaca_gelap",
    },
    "\U0001F312": {
        "en": "waxing_crescent_moon",
        "id": "bulan_sabit_awal",
        "alias": "bulan_sabit_awal_angkasa_cuaca_membesar",
    },
    "\U0001F313": {
        "en": "first_quarter_moon",
        "id": "bulan_perbani_awal",
        "alias": "bulan_perbani_awal_angkasa_cuaca_seperempat",
    },
    "\U0001F314": {
        "en": "waxing_gibbous_moon",
        "id": "bulan_cembung_awal",
        "alias": "bulan_cembung_awal_angkasa_cuaca_membesar",
    },
    "\U0001F315": {
        "en": "full_moon",
        "id": "bulan_purnama",
        "alias": "bulan_purnama_angkasa_cuaca",
    },
    "\U0001F316": {
        "en": "waning_gibbous_moon",
        "id": "bulan_cembung_akhir",
        "alias": "bulan_cembung_akhir_angkasa_cuaca_mengecil",
    },
    "\U0001F317": {
        "en": "last_quarter_moon",
        "id": "bulan_perbani_akhir",
        "alias": "bulan_perbani_akhir_angkasa_cuaca_seperempat",
    },
    "\U0001F318": {
        "en": "waning_crescent_moon",
        "id": "bulan_sabit_akhir",
        "alias": "bulan_sabit_akhir_angkasa_cuaca_mengecil",
    },
    "\U0001F319": {
        "en": "crescent_moon",
        "id": "bulan_sabit",
        "alias": "bulan_sabit_angkasa_cuaca",
    },
    "\U0001F31A": {
        "en": "new_moon_face",
        "id": "wajah_bulan_baru",
        "alias": "wajah_bulan_baru_angkasa_cuaca",
    },
    "\U0001F31B": {
        "en": "first_quarter_moon_face",
        "id": "wajah_bulan_perbani_awal",
        "alias": "wajah_bulan_perbani_awal_angkasa_cuaca_seperempat",
    },
    "\U0001F31C": {
        "en": "last_quarter_moon_face",
        "id": "wajah_bulan_perbani_akhir",
        "alias": "wajah_bulan_perbani_akhir_angkasa_cuaca_seperempat",
    },
    "\U0001F321\U0000FE0F": {"en": "thermometer", "id": "termometer", "alias": "termometer_cuaca"},
    "\U00002600\U0000FE0F": {
        "en": "sun",
        "id": "matahari",
        "alias": "matahari_angkasa_cerah_cuaca_sinar_terang",
    },
    "\U0001F31D": {
        "en": "full_moon_face",
        "id": "wajah_bulan_purnama",
        "alias": "wajah_bulan_purnama_angkasa_cuaca_terang",
    },
    "\U0001F31E": {
        "en": "sun_with_face",
        "id": "wajah_matahari",
        "alias": "wajah_matahari_angkasa_cuaca_terang",
    },
    "\U0001FA90": {
        "en": "ringed_planet",
        "id": "planet_bercincin",
        "alias": "planet_bercincin_saturnus",
    },
    "\U00002B50": {"en": "star", "id": "bintang_medium_putih"},
    "\U0001F31F": {
        "en": "glowing_star",
        "id": "bintang_bersinar",
        "alias": "bintang_bersinar_berkilau_cemerlang",
    },
    "\U0001F320": {"en": "shooting_star", "id": "bintang_jatuh", "alias": "bintang_jatuh_angkasa"},
    "\U0001F30C": {"en": "milky_way", "id": "bima_sakti", "alias": "bima_sakti_cuaca_ruang"},
    "\U00002601\U0000FE0F": {"en": "cloud", "id": "awan", "alias": "awan_cuaca"},
    "\U000026C5": {
        "en": "sun_behind_cloud",
        "id": "matahari_di_balik_awan",
        "alias": "matahari_di_balik_awan_cuaca",
    },
    "\U000026C8\U0000FE0F": {
        "en": "cloud_with_lightning_and_rain",
        "id": "awan_dengan_petir_dan_hujan",
        "alias": "awan_dengan_petir_dan_hujan_cuaca",
    },
    "\U0001F324\U0000FE0F": {
        "en": "sun_behind_small_cloud",
        "id": "matahari_di_balik_awan_kecil",
        "alias": "matahari_di_balik_awan_kecil_cuaca",
    },
    "\U0001F325\U0000FE0F": {
        "en": "sun_behind_large_cloud",
        "id": "matahari_di_balik_awan_besar",
        "alias": "matahari_di_balik_awan_besar_cuaca",
    },
    "\U0001F326\U0000FE0F": {
        "en": "sun_behind_rain_cloud",
        "id": "matahari_di_balik_awan_hujan",
        "alias": "matahari_di_balik_awan_hujan_cuaca",
    },
    "\U0001F327\U0000FE0F": {
        "en": "cloud_with_rain",
        "id": "awan_hujan",
        "alias": "awan_hujan_cuaca",
    },
    "\U0001F328\U0000FE0F": {
        "en": "cloud_with_snow",
        "id": "awan_salju",
        "alias": "awan_salju_cuaca_dingin",
    },
    "\U0001F329\U0000FE0F": {
        "en": "cloud_with_lightning",
        "id": "awan_petir",
        "alias": "awan_petir_cuaca_kilat",
    },
    "\U0001F32A\U0000FE0F": {
        "en": "tornado",
        "id": "tornado",
        "alias": "tornado_angin_awan_cuaca_pusaran",
    },
    "\U0001F32B\U0000FE0F": {"en": "fog", "id": "kabut", "alias": "kabut_awan_cuaca"},
    "\U0001F32C\U0000FE0F": {
        "en": "wind_face",
        "id": "wajah_tertiup_angin",
        "alias": "wajah_tertiup_angin_awan_cuaca_hembusan",
    },
    "\U0001F300": {"en": "cyclone", "id": "topan", "alias": "topan_berputar-putar_cuaca_pusaran"},
    "\U0001F308": {"en": "rainbow", "id": "pelangi", "alias": "pelangi_cuaca_hujan"},
    "\U0001F302": {
        "en": "closed_umbrella",
        "id": "payung_tertutup",
        "alias": "payung_tertutup_cuaca_hujan_pakaian",
    },
    "\U00002602\U0000FE0F": {
        "en": "umbrella",
        "id": "payung",
        "alias": "payung_cuaca_hujan_pakaian",
    },
    "\U00002614": {
        "en": "umbrella_with_rain_drops",
        "id": "payung_dengan_tetesan_hujan",
        "alias": "payung_dengan_tetesan_hujan_cuaca_pakaian",
    },
    "\U000026F1\U0000FE0F": {
        "en": "umbrella_on_ground",
        "id": "payung_di_tanah",
        "alias": "payung_di_tanah_cuaca_hujan_matahari",
    },
    "\U000026A1": {
        "en": "high_voltage",
        "id": "tegangan_tinggi",
        "alias": "tegangan_tinggi_bahaya_kilat_listrik_sambaran",
    },
    "\U00002744\U0000FE0F": {
        "en": "snowflake",
        "id": "serpihan_salju",
        "alias": "serpihan_salju_cuaca_dingin",
    },
    "\U00002603\U0000FE0F": {
        "en": "snowman",
        "id": "boneka_salju_dengan_hujan_salju",
        "alias": "boneka_salju_dengan_hujan_cuaca_dingin",
    },
    "\U000026C4": {
        "en": "snowman_without_snow",
        "id": "boneka_salju_tanpa_salju",
        "alias": "boneka_salju_tanpa_cuaca_dingin",
    },
    "\U00002604\U0000FE0F": {"en": "comet", "id": "komet", "alias": "komet_angkasa"},
    "\U0001F525": {"en": "fire", "id": "api", "alias": "api_alat_kobaran"},
    "\U0001F4A7": {
        "en": "droplet",
        "id": "tetesan_air",
        "alias": "tetesan_air_cuaca_dingin_keringat_komik",
    },
    "\U0001F30A": {"en": "water_wave", "id": "ombak", "alias": "ombak_air_cuaca_lautan"},
    "\U0001F383": {
        "en": "jack-o-lantern",
        "id": "jack-o-lantern",
        "alias": "jack-o-lantern_halloween_jack_lentera_perayaan",
    },
    "\U0001F384": {"en": "christmas_tree", "id": "pohon_natal", "alias": "pohon_natal_perayaan"},
    "\U0001F386": {"en": "fireworks", "id": "kembang_api", "alias": "kembang_api_perayaan"},
    "\U0001F387": {
        "en": "sparkler",
        "id": "kembang_api_batang",
        "alias": "kembang_api_batang_berkilau_perayaan",
    },
    "\U0001F9E8": {
        "en": "firecracker",
        "id": "petasan",
        "alias": "petasan_bahan_peledak_dinamit_kembang_api",
    },
    "\U00002728": {"en": "sparkles", "id": "berkilau", "alias": "berkilau_*_bintang_kilauan"},
    "\U0001F388": {"en": "balloon", "id": "balon", "alias": "balon_perayaan"},
    "\U0001F389": {
        "en": "party_popper",
        "id": "party_popper",
        "alias": "party_popper_jreng_perayaan",
    },
    "\U0001F38A": {
        "en": "confetti_ball",
        "id": "bola_konfeti",
        "alias": "bola_konfeti_confetti_perayaan",
    },
    "\U0001F38B": {
        "en": "tanabata_tree",
        "id": "pohon_tanabata",
        "alias": "pohon_tanabata_jepang_perayaan_spanduk",
    },
    "\U0001F38D": {
        "en": "pine_decoration",
        "id": "dekorasi_pinus",
        "alias": "dekorasi_pinus_bambu_jepang_perayaan_tanaman",
    },
    "\U0001F38E": {
        "en": "japanese_dolls",
        "id": "boneka_jepang",
        "alias": "boneka_jepang_festival_perayaan",
    },
    "\U0001F38F": {
        "en": "carp_streamer",
        "id": "bendera_ikan_koi",
        "alias": "bendera_ikan_koi_panji_perayaan",
    },
    "\U0001F390": {
        "en": "wind_chime",
        "id": "lonceng_angin",
        "alias": "lonceng_angin_gemerincing_perayaan",
    },
    "\U0001F391": {
        "en": "moon_viewing_ceremony",
        "id": "perayaan_bulan",
        "alias": "perayaan_bulan_upacara",
    },
    "\U0001F9E7": {
        "en": "red_envelope",
        "id": "amplop_merah",
        "alias": "amplop_merah_hadiah_hongbao_lai_see_semoga_beruntung_uang",
    },
    "\U0001F380": {"en": "ribbon", "id": "pita", "alias": "pita_perayaan"},
    "\U0001F381": {
        "en": "wrapped_gift",
        "id": "kado",
        "alias": "kado_bungkusan_hadiah_kotak_perayaan",
    },
    "\U0001F397\U0000FE0F": {
        "en": "reminder_ribbon",
        "id": "pita_pengingat",
        "alias": "pita_pengingat_perayaan",
    },
    "\U0001F39F\U0000FE0F": {"en": "admission_tickets", "id": "tiket_masuk"},
    "\U0001F3AB": {"en": "ticket", "id": "tiket", "alias": "tiket_masuk"},
    "\U0001F396\U0000FE0F": {
        "en": "military_medal",
        "id": "medali_militer",
        "alias": "medali_militer_perayaan",
    },
    "\U0001F3C6": {"en": "trophy", "id": "piala", "alias": "piala_hadiah"},
    "\U0001F3C5": {"en": "sports_medal", "id": "medali_olahraga"},
    "\U0001F947": {
        "en": "1st_place_medal",
        "id": "medali_emas",
        "alias": "medali_emas_juara_pertama",
    },
    "\U0001F948": {
        "en": "2nd_place_medal",
        "id": "medali_perak",
        "alias": "medali_perak_juara_kedua",
    },
    "\U0001F949": {
        "en": "3rd_place_medal",
        "id": "medali_perunggu",
        "alias": "medali_perunggu_juara_ketiga",
    },
    "\U000026BD": {"en": "soccer_ball", "id": "bola_sepak"},
    "\U000026BE": {"en": "baseball", "id": "bisbol", "alias": "bisbol_bola"},
    "\U0001F94E": {"en": "softball", "id": "sofbol", "alias": "sofbol_bola_sarung_tangan"},
    "\U0001F3C0": {"en": "basketball", "id": "bola_basket", "alias": "bola_basket_loncat"},
    "\U0001F3D0": {"en": "volleyball", "id": "bola_voli", "alias": "bola_voli_permainan"},
    "\U0001F3C8": {
        "en": "american_football",
        "id": "american_football",
        "alias": "american_football_amerika_bola",
    },
    "\U0001F3C9": {
        "en": "rugby_football",
        "id": "sepak_bola_rugbi",
        "alias": "sepak_bola_rugbi_football_rugby",
    },
    "\U0001F3BE": {"en": "tennis", "id": "tenis", "alias": "tenis_bola_raket"},
    "\U0001F94F": {"en": "flying_disc", "id": "lempar_cakram"},
    "\U0001F3B3": {"en": "bowling", "id": "bowling", "alias": "bowling_bola_game"},
    "\U0001F3CF": {"en": "cricket_game", "id": "kriket", "alias": "kriket_bola_pemukul_permainan"},
    "\U0001F3D1": {
        "en": "field_hockey",
        "id": "hoki_lapangan",
        "alias": "hoki_lapangan_bola_permainan_stik",
    },
    "\U0001F3D2": {
        "en": "ice_hockey",
        "id": "hoki_es",
        "alias": "hoki_es_bola_karet_permainan_stik",
    },
    "\U0001F94D": {"en": "lacrosse", "id": "lacrosse", "alias": "lacrosse_bola_gawang_tongkat"},
    "\U0001F3D3": {
        "en": "ping_pong",
        "id": "ping_pong",
        "alias": "ping_pong_bet_bola_pemukul_permainan_tenis_meja",
    },
    "\U0001F3F8": {
        "en": "badminton",
        "id": "bulu_tangkis",
        "alias": "bulu_tangkis_game_kok_raket",
    },
    "\U0001F94A": {
        "en": "boxing_glove",
        "id": "sarung_tinju",
        "alias": "sarung_tinju_olahraga_tangan",
    },
    "\U0001F94B": {
        "en": "martial_arts_uniform",
        "id": "seragam_beladiri",
        "alias": "seragam_beladiri_bela_diri_judo_karate_taekwondo",
    },
    "\U0001F945": {"en": "goal_net", "id": "gawang", "alias": "gawang_gol_jaring_olahraga"},
    "\U000026F3": {"en": "flag_in_hole", "id": "bendera_di_lubang_golf"},
    "\U000026F8\U0000FE0F": {"en": "ice_skate", "id": "seluncur_es"},
    "\U0001F3A3": {"en": "fishing_pole", "id": "tongkat_pancing", "alias": "tongkat_pancing_ikan"},
    "\U0001F93F": {
        "en": "diving_mask",
        "id": "kacamata_selam",
        "alias": "kacamata_selam_menyelam_scuba_snorkel_snorkeling",
    },
    "\U0001F3BD": {"en": "running_shirt", "id": "kaos_lari", "alias": "kaos_lari_selempang"},
    "\U0001F3BF": {"en": "skis", "id": "ski", "alias": "ski_salju"},
    "\U0001F6F7": {"en": "sled", "id": "kereta_luncur"},
    "\U0001F94C": {"en": "curling_stone", "id": "batu_curling", "alias": "batu_curling_permainan"},
    "\U0001F3AF": {
        "en": "bullseye",
        "id": "dart",
        "alias": "dart_anak_panah_lempar_mata_papan_sasaran_permainan_target",
    },
    "\U0001FA80": {"en": "yo-yo", "id": "yo-yo", "alias": "yo-yo_mainan_naik-turun"},
    "\U0001FA81": {"en": "kite", "id": "layang-layang", "alias": "layang-layang_melayang_terbang"},
    "\U0001F3B1": {
        "en": "pool_8_ball",
        "id": "biliar_8_bola",
        "alias": "biliar_8_bola_delapan_game",
    },
    "\U0001F52E": {
        "en": "crystal_ball",
        "id": "bola_kristal",
        "alias": "bola_kristal_alat_dongeng_fantasi_ramalan",
    },
    "\U0001FA84": {
        "en": "magic_wand",
        "id": "tongkat_ajaib",
        "alias": "tongkat_ajaib_penyihir_pria_wanita_sihir",
    },
    "\U0001F9FF": {
        "en": "nazar_amulet",
        "id": "jimat_nazar",
        "alias": "jimat_nazar_manik-manik_mantra_mata_setan",
    },
    "\U0001F3AE": {"en": "video_game", "id": "video_game", "alias": "video_game_pengontrol"},
    "\U0001F579\U0000FE0F": {"en": "joystick", "id": "joystick", "alias": "joystick_game_video"},
    "\U0001F3B0": {"en": "slot_machine", "id": "mesin_slot", "alias": "mesin_slot_game"},
    "\U0001F3B2": {"en": "game_die", "id": "dadu", "alias": "dadu_permainan"},
    "\U0001F9E9": {
        "en": "puzzle_piece",
        "id": "keping_puzzle",
        "alias": "keping_puzzle_kepingan_petunjuk_saling_terkait",
    },
    "\U0001F9F8": {"en": "teddy_bear", "id": "boneka_beruang", "alias": "boneka_beruang_mainan"},
    "\U0001FA85": {"en": "pinata", "id": "pinata", "alias": "pinata_perayaan_pesta"},
    "\U0001FA86": {
        "en": "nesting_dolls",
        "id": "boneka_bersarang",
        "alias": "boneka_bersarang_rusia",
    },
    "\U00002660\U0000FE0F": {"en": "spade_suit", "id": "sekop", "alias": "sekop_kartu_permainan"},
    "\U00002665\U0000FE0F": {"en": "heart_suit", "id": "hati", "alias": "hati_kartu_permainan"},
    "\U00002666\U0000FE0F": {
        "en": "diamond_suit",
        "id": "wajik",
        "alias": "wajik_kartu_permainan",
    },
    "\U00002663\U0000FE0F": {
        "en": "club_suit",
        "id": "keriting",
        "alias": "keriting_kartu_klub_permainan",
    },
    "\U0000265F\U0000FE0F": {
        "en": "chess_pawn",
        "id": "pion_catur",
        "alias": "pion_catur_anak_buah",
    },
    "\U0001F0CF": {"en": "joker", "id": "joker", "alias": "joker_kartu_permainan"},
    "\U0001F004": {
        "en": "mahjong_red_dragon",
        "id": "naga_merah_mahyong",
        "alias": "naga_merah_mahyong_game",
    },
    "\U0001F3B4": {
        "en": "flower_playing_cards",
        "id": "kartu_bunga",
        "alias": "kartu_bunga_game_jepang_permainan",
    },
    "\U0001F3AD": {
        "en": "performing_arts",
        "id": "seni_drama",
        "alias": "seni_drama_tampil_teater_topeng",
    },
    "\U0001F5BC\U0000FE0F": {
        "en": "framed_picture",
        "id": "bingkai_bergambar",
        "alias": "bingkai_bergambar_gambar_lukisan_museum_seni",
    },
    "\U0001F3A8": {
        "en": "artist_palette",
        "id": "palet_pelukis",
        "alias": "palet_pelukis_lukisan_museum_seni",
    },
    "\U0001F9F5": {"en": "thread", "id": "benang", "alias": "benang_gulungan_jahit_jarum"},
    "\U0001FAA1": {
        "en": "sewing_needle",
        "id": "jarum_jahit",
        "alias": "jarum_jahit_jahitan_menjahit_penjahit_sulaman",
    },
    "\U0001F9F6": {
        "en": "yarn",
        "id": "gulungan_benang",
        "alias": "gulungan_benang_bola_rajut_sulam",
    },
    "\U0001FAA2": {
        "en": "knot",
        "id": "simpul",
        "alias": "simpul_belitan_ikatan_kusut_puntiran_tali",
    },
    "\U0001F453": {"en": "glasses", "id": "kacamata", "alias": "kacamata_kaca_mata_pakaian"},
    "\U0001F576\U0000FE0F": {
        "en": "sunglasses",
        "id": "kacamata_hitam",
        "alias": "kacamata_hitam_kaca_mata",
    },
    "\U0001F97D": {
        "en": "goggles",
        "id": "kacamata_renang",
        "alias": "kacamata_renang_berenang_mengelas_pelindung_mata",
    },
    "\U0001F97C": {
        "en": "lab_coat",
        "id": "jas_laboratorium",
        "alias": "jas_laboratorium_dokter_ilmuwan_percobaan",
    },
    "\U0001F9BA": {
        "en": "safety_vest",
        "id": "rompi_pengaman",
        "alias": "rompi_pengaman_darurat_keselamatan",
    },
    "\U0001F454": {"en": "necktie", "id": "dasi", "alias": "dasi_pakaian"},
    "\U0001F455": {"en": "t-shirt", "id": "kaos", "alias": "kaos_kaus_pakaian_polo"},
    "\U0001F456": {"en": "jeans", "id": "celana_jeans", "alias": "celana_jeans_pakaian_panjang"},
    "\U0001F9E3": {"en": "scarf", "id": "syal", "alias": "syal_leher"},
    "\U0001F9E4": {"en": "gloves", "id": "sarung_tangan"},
    "\U0001F9E5": {"en": "coat", "id": "mantel", "alias": "mantel_jaket"},
    "\U0001F9E6": {"en": "socks", "id": "kaus_kaki", "alias": "kaus_kaki_kaos_stocking_stoking"},
    "\U0001F457": {"en": "dress", "id": "gaun", "alias": "gaun_pakaian"},
    "\U0001F458": {"en": "kimono", "id": "kimono", "alias": "kimono_pakaian"},
    "\U0001F97B": {"en": "sari", "id": "sari", "alias": "sari_gaun_pakaian_terusan"},
    "\U0001FA71": {"en": "one-piece_swimsuit", "id": "pakaian_renang_one-piece"},
    "\U0001FA72": {
        "en": "briefs",
        "id": "celana_renang",
        "alias": "celana_renang_baju_one-piece_pakaian_dalam",
    },
    "\U0001FA73": {
        "en": "shorts",
        "id": "celana_pendek",
        "alias": "celana_pendek_baju_renang_pakaian_dalam",
    },
    "\U0001F459": {"en": "bikini", "id": "bikini", "alias": "bikini_pakaian_renang"},
    "\U0001F45A": {"en": "womans_clothes", "id": "pakaian_wanita"},
    "\U0001F45B": {"en": "purse", "id": "dompet", "alias": "dompet_koin_pakaian"},
    "\U0001F45C": {"en": "handbag", "id": "tas_jinjing", "alias": "tas_jinjing_pakaian"},
    "\U0001F45D": {"en": "clutch_bag", "id": "kantung", "alias": "kantung_pakaian_tas"},
    "\U0001F6CD\U0000FE0F": {
        "en": "shopping_bags",
        "id": "tas_belanja",
        "alias": "tas_belanja_hotel",
    },
    "\U0001F392": {"en": "backpack", "id": "tas_sekolah", "alias": "tas_sekolah_ransel"},
    "\U0001FA74": {
        "en": "thong_sandal",
        "id": "sandal_jepit",
        "alias": "sandal_jepit_pantai_zori",
    },
    "\U0001F45E": {"en": "mans_shoe", "id": "sepatu_pria", "alias": "sepatu_pria_pakaian"},
    "\U0001F45F": {
        "en": "running_shoe",
        "id": "sepatu_lari",
        "alias": "sepatu_lari_atletik_kets_pakaian",
    },
    "\U0001F97E": {
        "en": "hiking_boot",
        "id": "sepatu_boot_untuk_mendaki",
        "alias": "sepatu_boot_untuk_mendaki_backpacking_kemping",
    },
    "\U0001F97F": {
        "en": "flat_shoe",
        "id": "sepatu_flat",
        "alias": "sepatu_flat_sandal_selop_balet",
    },
    "\U0001F460": {
        "en": "high-heeled_shoe",
        "id": "sepatu_hak_tinggi",
        "alias": "sepatu_hak_tinggi_pakaian_wanita",
    },
    "\U0001F461": {
        "en": "womans_sandal",
        "id": "sandal_wanita",
        "alias": "sandal_wanita_pakaian_sepatu",
    },
    "\U0001FA70": {
        "en": "ballet_shoes",
        "id": "sepatu_balet",
        "alias": "sepatu_balet_menari_tari_tarian",
    },
    "\U0001F462": {
        "en": "womans_boot",
        "id": "sepatu_bot_wanita",
        "alias": "sepatu_bot_wanita_pakaian",
    },
    "\U0001F451": {"en": "crown", "id": "mahkota", "alias": "mahkota_pakaian_raja_ratu"},
    "\U0001F452": {"en": "womans_hat", "id": "topi_wanita", "alias": "topi_wanita_pakaian"},
    "\U0001F3A9": {"en": "top_hat", "id": "topi_tinggi", "alias": "topi_tinggi_pakaian_sulap"},
    "\U0001F393": {
        "en": "graduation_cap",
        "id": "topi_wisuda",
        "alias": "topi_wisuda_pakaian_perayaan_toga",
    },
    "\U0001F9E2": {"en": "billed_cap", "id": "topi_berlidah", "alias": "topi_berlidah_bisbol"},
    "\U0001FA96": {
        "en": "military_helmet",
        "id": "helm_tentara",
        "alias": "helm_tentara_angkatan_darat_militer_pejuang_prajurit",
    },
    "\U000026D1\U0000FE0F": {
        "en": "rescue_workers_helmet",
        "id": "helm_dengan_palang_putih",
        "alias": "helm_dengan_palang_putih_muka_p3k_topi_wajah",
    },
    "\U0001F4FF": {
        "en": "prayer_beads",
        "id": "tasbih",
        "alias": "tasbih_agama_doa_kalung_pakaian",
    },
    "\U0001F484": {"en": "lipstick", "id": "lipstik", "alias": "lipstik_dandan_kosmetik"},
    "\U0001F48D": {"en": "ring", "id": "cincin", "alias": "cincin_berlian_romantis"},
    "\U0001F48E": {
        "en": "gem_stone",
        "id": "batu_permata",
        "alias": "batu_permata_berlian_romantis",
    },
    "\U0001F507": {
        "en": "muted_speaker",
        "id": "speaker_mati",
        "alias": "speaker_mati_bisu_diam_senyap",
    },
    "\U0001F508": {
        "en": "speaker_low_volume",
        "id": "volume_speaker_rendah",
        "alias": "volume_speaker_rendah_lembut",
    },
    "\U0001F509": {"en": "speaker_medium_volume", "id": "volume_speaker_medium"},
    "\U0001F50A": {
        "en": "speaker_high_volume",
        "id": "volume_speaker_tinggi",
        "alias": "volume_speaker_tinggi_keras",
    },
    "\U0001F4E2": {
        "en": "loudspeaker",
        "id": "pengeras_suara",
        "alias": "pengeras_suara_keras_pengumuman",
    },
    "\U0001F4E3": {"en": "megaphone", "id": "megafon", "alias": "megafon_bersorak"},
    "\U0001F4EF": {"en": "postal_horn", "id": "trompet_pos"},
    "\U0001F514": {"en": "bell", "id": "lonceng"},
    "\U0001F515": {
        "en": "bell_with_slash",
        "id": "lonceng_dicoret",
        "alias": "lonceng_dicoret_bisu_diam_senyap_terlarang",
    },
    "\U0001F3BC": {"en": "musical_score", "id": "naskah_musik", "alias": "naskah_musik_skor"},
    "\U0001F3B5": {"en": "musical_note", "id": "not_musik"},
    "\U0001F3B6": {"en": "musical_notes", "id": "not-not_musik", "alias": "not-not_musik_not"},
    "\U0001F399\U0000FE0F": {
        "en": "studio_microphone",
        "id": "mikrofon_studio",
        "alias": "mikrofon_studio_mik_musik",
    },
    "\U0001F39A\U0000FE0F": {
        "en": "level_slider",
        "id": "penggeser_tingkat",
        "alias": "penggeser_tingkat_level_musik",
    },
    "\U0001F39B\U0000FE0F": {
        "en": "control_knobs",
        "id": "kenop_kontrol",
        "alias": "kenop_kontrol_musik",
    },
    "\U0001F3A4": {"en": "microphone", "id": "mikrofon", "alias": "mikrofon_karaoke_mik"},
    "\U0001F3A7": {"en": "headphone", "id": "headphone", "alias": "headphone_earbud"},
    "\U0001F4FB": {"en": "radio", "id": "radio", "alias": "radio_video"},
    "\U0001F3B7": {"en": "saxophone", "id": "saksofon", "alias": "saksofon_instrumen_musik"},
    "\U0001FA97": {
        "en": "accordion",
        "id": "akordeon",
        "alias": "akordeon_concertina_kotak_remas",
    },
    "\U0001F3B8": {"en": "guitar", "id": "gitar", "alias": "gitar_instrumen_musik"},
    "\U0001F3B9": {
        "en": "musical_keyboard",
        "id": "keyboard_musik",
        "alias": "keyboard_musik_instrumen_piano",
    },
    "\U0001F3BA": {"en": "trumpet", "id": "trompet", "alias": "trompet_instrumen_musik"},
    "\U0001F3BB": {"en": "violin", "id": "biola", "alias": "biola_instrumen_musik"},
    "\U0001FA95": {"en": "banjo", "id": "banjo", "alias": "banjo_musik_senar"},
    "\U0001F941": {"en": "drum", "id": "drum", "alias": "drum_musik_stik"},
    "\U0001FA98": {"en": "long_drum", "id": "gendang", "alias": "gendang_conga_dentum_irama"},
    "\U0001F4F1": {"en": "mobile_phone", "id": "ponsel", "alias": "ponsel_seluler_telepon"},
    "\U0001F4F2": {
        "en": "mobile_phone_with_arrow",
        "id": "telepon_masuk",
        "alias": "telepon_masuk_panah_panggilan_ponsel_seluler_terima",
    },
    "\U0000260E\U0000FE0F": {"en": "telephone", "id": "telepon"},
    "\U0001F4DE": {
        "en": "telephone_receiver",
        "id": "gagang_telepon",
        "alias": "gagang_telepon_penerima",
    },
    "\U0001F4DF": {"en": "pager", "id": "pager"},
    "\U0001F4E0": {"en": "fax_machine", "id": "mesin_faks", "alias": "mesin_faks_faksimili"},
    "\U0001F50B": {"en": "battery", "id": "baterai"},
    "\U0001F50C": {"en": "electric_plug", "id": "steker", "alias": "steker_listrik"},
    "\U0001F4BB": {
        "en": "laptop",
        "id": "komputer_laptop",
        "alias": "komputer_laptop_pc_personal",
    },
    "\U0001F5A5\U0000FE0F": {"en": "desktop_computer", "id": "komputer_desktop"},
    "\U0001F5A8\U0000FE0F": {"en": "printer", "id": "printer", "alias": "printer_komputer"},
    "\U00002328\U0000FE0F": {"en": "keyboard", "id": "keyboard", "alias": "keyboard_komputer"},
    "\U0001F5B1\U0000FE0F": {"en": "computer_mouse", "id": "mouse_komputer"},
    "\U0001F5B2\U0000FE0F": {"en": "trackball", "id": "trackball", "alias": "trackball_komputer"},
    "\U0001F4BD": {
        "en": "computer_disk",
        "id": "disk_komputer",
        "alias": "disk_komputer_mini_optik",
    },
    "\U0001F4BE": {"en": "floppy_disk", "id": "disket", "alias": "disket_disk_komputer"},
    "\U0001F4BF": {"en": "optical_disk", "id": "disk_optik", "alias": "disk_optik_cd_komputer"},
    "\U0001F4C0": {"en": "dvd", "id": "dvd", "alias": "dvd_blu-ray_disk_komputer_optik"},
    "\U0001F9EE": {"en": "abacus", "id": "sempoa", "alias": "sempoa_kalkulasi"},
    "\U0001F3A5": {"en": "movie_camera", "id": "kamera_film", "alias": "kamera_film_sinema"},
    "\U0001F39E\U0000FE0F": {
        "en": "film_frames",
        "id": "frame_film",
        "alias": "frame_film_sinema",
    },
    "\U0001F4FD\U0000FE0F": {
        "en": "film_projector",
        "id": "proyektor_film",
        "alias": "proyektor_film_sinema_video",
    },
    "\U0001F3AC": {
        "en": "clapper_board",
        "id": "papan_sutradara",
        "alias": "papan_sutradara_film",
    },
    "\U0001F4FA": {"en": "television", "id": "televisi", "alias": "televisi_tv_video"},
    "\U0001F4F7": {"en": "camera", "id": "kamera", "alias": "kamera_video"},
    "\U0001F4F8": {
        "en": "camera_with_flash",
        "id": "kamera_dengan_flash",
        "alias": "kamera_dengan_flash_video",
    },
    "\U0001F4F9": {"en": "video_camera", "id": "kamera_video"},
    "\U0001F4FC": {"en": "videocassette", "id": "kaset_video", "alias": "kaset_video_pita_vhs"},
    "\U0001F50D": {
        "en": "magnifying_glass_tilted_left",
        "id": "kaca_pembesar_arah_kiri",
        "alias": "kaca_pembesar_arah_kiri_alat_penelusuran",
    },
    "\U0001F50E": {
        "en": "magnifying_glass_tilted_right",
        "id": "kaca_pembesar_arah_kanan",
        "alias": "kaca_pembesar_arah_kanan_alat_penelusuran",
    },
    "\U0001F56F\U0000FE0F": {"en": "candle", "id": "lilin", "alias": "lilin_cahaya"},
    "\U0001F4A1": {"en": "light_bulb", "id": "bohlam", "alias": "bohlam_elektrik_ide_komik_lampu"},
    "\U0001F526": {
        "en": "flashlight",
        "id": "lampu_senter",
        "alias": "lampu_senter_alat_cahaya_listrik",
    },
    "\U0001F3EE": {
        "en": "red_paper_lantern",
        "id": "lampion_merah",
        "alias": "lampion_merah_bar_cahaya_lentera",
    },
    "\U0001FA94": {"en": "diya_lamp", "id": "lampu_diya", "alias": "lampu_diya_lentera_minyak"},
    "\U0001F4D4": {
        "en": "notebook_with_decorative_cover",
        "id": "buku_catatan_bersampul",
        "alias": "buku_catatan_bersampul_dekorasi_sampul",
    },
    "\U0001F4D5": {"en": "closed_book", "id": "buku_tertutup"},
    "\U0001F4D6": {"en": "open_book", "id": "buku_terbuka"},
    "\U0001F4D7": {"en": "green_book", "id": "buku_hijau"},
    "\U0001F4D8": {"en": "blue_book", "id": "buku_biru"},
    "\U0001F4D9": {"en": "orange_book", "id": "buku_oranye"},
    "\U0001F4DA": {"en": "books", "id": "buku"},
    "\U0001F4D3": {"en": "notebook", "id": "buku_catatan"},
    "\U0001F4D2": {"en": "ledger", "id": "buku_besar", "alias": "buku_besar_catatan"},
    "\U0001F4C3": {
        "en": "page_with_curl",
        "id": "halaman_tergulung",
        "alias": "halaman_tergulung_dokumen_gulung",
    },
    "\U0001F4DC": {"en": "scroll", "id": "gulungan", "alias": "gulungan_kertas"},
    "\U0001F4C4": {
        "en": "page_facing_up",
        "id": "halaman_tampak_depan",
        "alias": "halaman_tampak_depan_dokumen",
    },
    "\U0001F4F0": {"en": "newspaper", "id": "koran", "alias": "koran_berita_kertas"},
    "\U0001F5DE\U0000FE0F": {
        "en": "rolled-up_newspaper",
        "id": "gulungan_koran",
        "alias": "gulungan_koran_berita_kertas_tergulung",
    },
    "\U0001F4D1": {
        "en": "bookmark_tabs",
        "id": "penanda_halaman_buku",
        "alias": "penanda_halaman_buku_tab_tanda",
    },
    "\U0001F516": {"en": "bookmark", "id": "pembatas_buku", "alias": "pembatas_buku_tanda"},
    "\U0001F3F7\U0000FE0F": {"en": "label", "id": "label"},
    "\U0001F4B0": {"en": "money_bag", "id": "kantung_uang", "alias": "kantung_uang_dolar_kantong"},
    "\U0001FA99": {"en": "coin", "id": "koin", "alias": "koin_emas_harta_karun_logam_perak_uang"},
    "\U0001F4B4": {"en": "yen_banknote", "id": "uang_kertas_yen", "alias": "uang_kertas_yen_mata"},
    "\U0001F4B5": {
        "en": "dollar_banknote",
        "id": "uang_kertas_dolar",
        "alias": "uang_kertas_dolar_mata",
    },
    "\U0001F4B6": {
        "en": "euro_banknote",
        "id": "uang_kertas_euro",
        "alias": "uang_kertas_euro_mata",
    },
    "\U0001F4B7": {
        "en": "pound_banknote",
        "id": "uang_kertas_pound",
        "alias": "uang_kertas_pound_mata",
    },
    "\U0001F4B8": {
        "en": "money_with_wings",
        "id": "uang_bersayap",
        "alias": "uang_bersayap_sayap_terbang_kertas",
    },
    "\U0001F4B3": {"en": "credit_card", "id": "kartu_kredit", "alias": "kartu_kredit_uang"},
    "\U0001F9FE": {
        "en": "receipt",
        "id": "kuitansi",
        "alias": "kuitansi_akuntansi_bukti_pembukuan",
    },
    "\U0001F4B9": {
        "en": "chart_increasing_with_yen",
        "id": "bagan_meningkat_dengan_yen",
        "alias": "bagan_meningkat_dengan_yen_grafik_pertumbuhan_uang",
    },
    "\U00002709\U0000FE0F": {"en": "envelope", "id": "amplop", "alias": "amplop_email_surat"},
    "\U0001F4E7": {"en": "e-mail", "id": "email", "alias": "email_surat"},
    "\U0001F4E8": {
        "en": "incoming_envelope",
        "id": "amplop_datang",
        "alias": "amplop_datang_email_masuk_surat_terima",
    },
    "\U0001F4E9": {
        "en": "envelope_with_arrow",
        "id": "amplop_dengan_panah",
        "alias": "amplop_dengan_panah_email_keluar",
    },
    "\U0001F4E4": {
        "en": "outbox_tray",
        "id": "baki_kotak_keluar",
        "alias": "baki_kotak_keluar_surat_terkirim",
    },
    "\U0001F4E5": {
        "en": "inbox_tray",
        "id": "baki_kotak_masuk",
        "alias": "baki_kotak_masuk_surat_terima",
    },
    "\U0001F4E6": {"en": "package", "id": "paket", "alias": "paket_kotak_parsel"},
    "\U0001F4EB": {
        "en": "closed_mailbox_with_raised_flag",
        "id": "kotak_surat_tertutup_dengan_bendera_terangkat",
    },
    "\U0001F4EA": {
        "en": "closed_mailbox_with_lowered_flag",
        "id": "kotak_surat_tertutup_dengan_bendera_turun",
    },
    "\U0001F4EC": {
        "en": "open_mailbox_with_raised_flag",
        "id": "kotak_surat_terbuka_dengan_bendera_terangkat",
    },
    "\U0001F4ED": {
        "en": "open_mailbox_with_lowered_flag",
        "id": "kotak_surat_terbuka_dengan_bendera_turun",
    },
    "\U0001F4EE": {"en": "postbox", "id": "kotak_pos", "alias": "kotak_pos_surat"},
    "\U0001F5F3\U0000FE0F": {"en": "ballot_box_with_ballot", "id": "kotak_dengan_surat_suara"},
    "\U0000270F\U0000FE0F": {"en": "pencil", "id": "pensil"},
    "\U00002712\U0000FE0F": {"en": "black_nib", "id": "ujung_pena"},
    "\U0001F58B\U0000FE0F": {"en": "fountain_pen", "id": "pena_tinta"},
    "\U0001F58A\U0000FE0F": {"en": "pen", "id": "pena", "alias": "pena_bolpoin"},
    "\U0001F58C\U0000FE0F": {"en": "paintbrush", "id": "kuas", "alias": "kuas_lukisan"},
    "\U0001F58D\U0000FE0F": {"en": "crayon", "id": "krayon"},
    "\U0001F4DD": {"en": "memo", "id": "memo", "alias": "memo_pensil"},
    "\U0001F4BC": {"en": "briefcase", "id": "tas_kantor"},
    "\U0001F4C1": {"en": "file_folder", "id": "folder_file"},
    "\U0001F4C2": {"en": "open_file_folder", "id": "folder_file_terbuka"},
    "\U0001F5C2\U0000FE0F": {"en": "card_index_dividers", "id": "pembagi_indeks_kartu"},
    "\U0001F4C5": {"en": "calendar", "id": "kalender", "alias": "kalender_tanggal"},
    "\U0001F4C6": {"en": "tear-off_calendar", "id": "kalender_sobek"},
    "\U0001F5D2\U0000FE0F": {
        "en": "spiral_notepad",
        "id": "catatan_spiral",
        "alias": "catatan_spiral_kertas",
    },
    "\U0001F5D3\U0000FE0F": {
        "en": "spiral_calendar",
        "id": "kalender_spiral",
        "alias": "kalender_spiral_kertas",
    },
    "\U0001F4C7": {"en": "card_index", "id": "indeks_kartu", "alias": "indeks_kartu_rolodex"},
    "\U0001F4C8": {
        "en": "chart_increasing",
        "id": "bagan_meningkat",
        "alias": "bagan_meningkat_grafik_naik_pertumbuhan_tren",
    },
    "\U0001F4C9": {
        "en": "chart_decreasing",
        "id": "bagan_menurun",
        "alias": "bagan_menurun_grafik_tren_turun",
    },
    "\U0001F4CA": {
        "en": "bar_chart",
        "id": "diagram_batang",
        "alias": "diagram_batang_bagan_grafik",
    },
    "\U0001F4CB": {"en": "clipboard", "id": "papan_klip"},
    "\U0001F4CC": {"en": "pushpin", "id": "paku_penanda", "alias": "paku_penanda_pin"},
    "\U0001F4CD": {
        "en": "round_pushpin",
        "id": "paku_penanda_bulat",
        "alias": "paku_penanda_bulat_pin",
    },
    "\U0001F4CE": {"en": "paperclip", "id": "klip_kertas"},
    "\U0001F587\U0000FE0F": {
        "en": "linked_paperclips",
        "id": "klip_kertas_tertaut",
        "alias": "klip_kertas_tertaut_tautan",
    },
    "\U0001F4CF": {
        "en": "straight_ruler",
        "id": "penggaris_lurus",
        "alias": "penggaris_lurus_ujung",
    },
    "\U0001F4D0": {
        "en": "triangular_ruler",
        "id": "penggaris_segitiga",
        "alias": "penggaris_segitiga_rangkaian",
    },
    "\U00002702\U0000FE0F": {"en": "scissors", "id": "gunting", "alias": "gunting_alat_potong"},
    "\U0001F5C3\U0000FE0F": {"en": "card_file_box", "id": "kotak_file_kartu"},
    "\U0001F5C4\U0000FE0F": {
        "en": "file_cabinet",
        "id": "lemari_file",
        "alias": "lemari_file_pemberkasan",
    },
    "\U0001F5D1\U0000FE0F": {"en": "wastebasket", "id": "keranjang_sampah"},
    "\U0001F512": {"en": "locked", "id": "gembok", "alias": "gembok_tutup"},
    "\U0001F513": {
        "en": "unlocked",
        "id": "gembok_terbuka",
        "alias": "gembok_terbuka_buka_tidak_digembok",
    },
    "\U0001F50F": {
        "en": "locked_with_pen",
        "id": "gembok_terkunci_dengan_pena",
        "alias": "gembok_terkunci_dengan_pena_privasi_tinta_ujung",
    },
    "\U0001F510": {
        "en": "locked_with_key",
        "id": "gembok_terkunci_dengan_kunci",
        "alias": "gembok_terkunci_dengan_kunci_aman_tutup",
    },
    "\U0001F511": {"en": "key", "id": "kunci", "alias": "kunci_sandi"},
    "\U0001F5DD\U0000FE0F": {
        "en": "old_key",
        "id": "kunci_antik",
        "alias": "kunci_antik_gembok_petunjuk",
    },
    "\U0001F528": {"en": "hammer", "id": "palu", "alias": "palu_alat"},
    "\U0001FA93": {"en": "axe", "id": "kapak", "alias": "kapak_belah_kayu_potong"},
    "\U000026CF\U0000FE0F": {"en": "pick", "id": "beliung", "alias": "beliung_alat_tambang"},
    "\U00002692\U0000FE0F": {
        "en": "hammer_and_pick",
        "id": "palu_dan_beliung",
        "alias": "palu_dan_beliung_alat",
    },
    "\U0001F6E0\U0000FE0F": {
        "en": "hammer_and_wrench",
        "id": "palu_dan_kunci_inggris",
        "alias": "palu_dan_kunci_inggris_alat",
    },
    "\U0001F5E1\U0000FE0F": {"en": "dagger", "id": "belati", "alias": "belati_pisau_senjata"},
    "\U00002694\U0000FE0F": {
        "en": "crossed_swords",
        "id": "pedang_bersilang",
        "alias": "pedang_bersilang_senjata_silang",
    },
    "\U0001F52B": {
        "en": "water_pistol",
        "id": "pistol_air",
        "alias": "pistol_air_alat_revolver_senjata",
    },
    "\U0001FA83": {
        "en": "boomerang",
        "id": "bumerang",
        "alias": "bumerang_australia_berbalik_melambung",
    },
    "\U0001F3F9": {
        "en": "bow_and_arrow",
        "id": "busur_dan_panah",
        "alias": "busur_dan_panah_pemanah_sagitarius_zodiak",
    },
    "\U0001F6E1\U0000FE0F": {"en": "shield", "id": "perisai", "alias": "perisai_senjata"},
    "\U0001FA9A": {
        "en": "carpentry_saw",
        "id": "gergaji_kayu",
        "alias": "gergaji_kayu_perkakas_tukang",
    },
    "\U0001F527": {"en": "wrench", "id": "kunci_inggris", "alias": "kunci_inggris_alat"},
    "\U0001FA9B": {"en": "screwdriver", "id": "obeng", "alias": "obeng_alat"},
    "\U0001F529": {"en": "nut_and_bolt", "id": "mur_dan_baut", "alias": "mur_dan_baut_alat"},
    "\U00002699\U0000FE0F": {"en": "gear", "id": "roda_gigi", "alias": "roda_gigi_alat"},
    "\U0001F5DC\U0000FE0F": {"en": "clamp", "id": "klem", "alias": "klem_alat_pengompres"},
    "\U00002696\U0000FE0F": {
        "en": "balance_scale",
        "id": "timbangan_gantung",
        "alias": "timbangan_gantung_imbang_keadilan_libra_zodiak",
    },
    "\U0001F9AF": {
        "en": "white_cane",
        "id": "tongkat_tunanetra",
        "alias": "tongkat_tunanetra_aksesibilitas_buta",
    },
    "\U0001F517": {"en": "link", "id": "tautan"},
    "\U000026D3\U0000FE0F": {"en": "chains", "id": "rantai"},
    "\U0001FA9D": {"en": "hook", "id": "kait", "alias": "kait_kail_kurva_titik_jual"},
    "\U0001F9F0": {
        "en": "toolbox",
        "id": "kotak_perkakas",
        "alias": "kotak_perkakas_mekanik_peti",
    },
    "\U0001F9F2": {"en": "magnet", "id": "magnet", "alias": "magnet_ladam_magnetik_tarikan"},
    "\U0001FA9C": {"en": "ladder", "id": "tangga", "alias": "tangga_anak_panjat"},
    "\U00002697\U0000FE0F": {"en": "alembic", "id": "alembic", "alias": "alembic_alat_kimia"},
    "\U0001F9EA": {
        "en": "test_tube",
        "id": "tabung_uji",
        "alias": "tabung_uji_ahli_kimia_lab_percobaan_sains",
    },
    "\U0001F9EB": {
        "en": "petri_dish",
        "id": "cawan_petri",
        "alias": "cawan_petri_ahli_biologi_bakteri_kultur_lab",
    },
    "\U0001F9EC": {
        "en": "dna",
        "id": "dna",
        "alias": "dna_ahli_biologi_evolusi_gen_genetik_kehidupan",
    },
    "\U0001F52C": {"en": "microscope", "id": "mikroskop", "alias": "mikroskop_alat_sains"},
    "\U0001F52D": {"en": "telescope", "id": "teleskop", "alias": "teleskop_alat_sains"},
    "\U0001F4E1": {
        "en": "satellite_antenna",
        "id": "antena_satelit",
        "alias": "antena_satelit_piring",
    },
    "\U0001F489": {"en": "syringe", "id": "suntikan", "alias": "suntikan_jarum_obat_sakit"},
    "\U0001FA78": {
        "en": "drop_of_blood",
        "id": "tetesan_darah",
        "alias": "tetesan_darah_donor_menstruasi_obat",
    },
    "\U0001F48A": {"en": "pill", "id": "pil", "alias": "pil_dokter_obat_sakit"},
    "\U0001FA79": {"en": "adhesive_bandage", "id": "plester_luka"},
    "\U0001FA7A": {
        "en": "stethoscope",
        "id": "stetoskop",
        "alias": "stetoskop_dokter_jantung_obat",
    },
    "\U0001F6AA": {"en": "door", "id": "pintu"},
    "\U0001F6D7": {
        "en": "elevator",
        "id": "elevator",
        "alias": "elevator_aksesibilitas_kerekan_lift",
    },
    "\U0001FA9E": {"en": "mirror", "id": "cermin", "alias": "cermin_pantulan_reflektor_spekulum"},
    "\U0001FA9F": {
        "en": "window",
        "id": "jendela",
        "alias": "jendela_bingkai_bukaan_pemadangan_transparan_udara_segar",
    },
    "\U0001F6CF\U0000FE0F": {"en": "bed", "id": "tempat_tidur", "alias": "tempat_tidur_hotel"},
    "\U0001F6CB\U0000FE0F": {
        "en": "couch_and_lamp",
        "id": "sofa_dan_lampu",
        "alias": "sofa_dan_lampu_hotel",
    },
    "\U0001FA91": {"en": "chair", "id": "bangku", "alias": "bangku_duduk_kursi"},
    "\U0001F6BD": {"en": "toilet", "id": "toilet"},
    "\U0001FAA0": {
        "en": "plunger",
        "id": "penyedot_wc",
        "alias": "penyedot_wc_toilet_tukang_ledeng",
    },
    "\U0001F6BF": {"en": "shower", "id": "shower", "alias": "shower_air"},
    "\U0001F6C1": {"en": "bathtub", "id": "bathtub", "alias": "bathtub_mandi"},
    "\U0001FAA4": {
        "en": "mouse_trap",
        "id": "perangkap_tikus",
        "alias": "perangkap_tikus_jebakan_jerat_umpan",
    },
    "\U0001FA92": {"en": "razor", "id": "pisau_cukur", "alias": "pisau_cukur_tajam"},
    "\U0001F9F4": {
        "en": "lotion_bottle",
        "id": "botol_losion",
        "alias": "botol_losion_moisturizer_sampo_tabir_surya",
    },
    "\U0001F9F7": {"en": "safety_pin", "id": "peniti", "alias": "peniti_popok_punk_rock"},
    "\U0001F9F9": {"en": "broom", "id": "sapu", "alias": "sapu_membersihkan_menyapu_penyihir"},
    "\U0001F9FA": {"en": "basket", "id": "keranjang", "alias": "keranjang_berkebun_cucian_piknik"},
    "\U0001F9FB": {
        "en": "roll_of_paper",
        "id": "gulungan_kertas",
        "alias": "gulungan_kertas_tisu_toilet",
    },
    "\U0001FAA3": {"en": "bucket", "id": "ember", "alias": "ember_tong_wadah"},
    "\U0001F9FC": {
        "en": "soap",
        "id": "sabun",
        "alias": "sabun_batang_busa_mandi_membersihkan_wadah",
    },
    "\U0001FAA5": {
        "en": "toothbrush",
        "id": "sikat_gigi",
        "alias": "sikat_gigi_bersih_dan_mulut_higienis_kamar_mandi",
    },
    "\U0001F9FD": {"en": "sponge", "id": "spons", "alias": "spons_berpori_membersihkan_menyerap"},
    "\U0001F9EF": {
        "en": "fire_extinguisher",
        "id": "alat_pemadam_api_ringan",
        "alias": "alat_pemadam_api_ringan_padam",
    },
    "\U0001F6D2": {"en": "shopping_cart", "id": "troli_belanja"},
    "\U0001F6AC": {"en": "cigarette", "id": "rokok", "alias": "rokok_merokok"},
    "\U000026B0\U0000FE0F": {"en": "coffin", "id": "peti_mati", "alias": "peti_mati_kematian"},
    "\U0001FAA6": {
        "en": "headstone",
        "id": "batu_nisan",
        "alias": "batu_nisan_kuburan_pekuburan_pemakaman",
    },
    "\U000026B1\U0000FE0F": {
        "en": "funeral_urn",
        "id": "guci_abu",
        "alias": "guci_abu_kematian_penguburan",
    },
    "\U0001F5FF": {"en": "moai", "id": "moai", "alias": "moai_moyai_patung_wajah"},
    "\U0001FAA7": {
        "en": "placard",
        "id": "plakat",
        "alias": "plakat_demonstrasi_papan_penanda_protes",
    },
    "\U0001F3E7": {"en": "atm_sign", "id": "tanda_atm", "alias": "tanda_atm_bank_otomatis_teller"},
    "\U0001F6AE": {
        "en": "litter_in_bin_sign",
        "id": "tanda_membuang_sampah",
        "alias": "tanda_membuang_sampah_keranjang",
    },
    "\U0001F6B0": {
        "en": "potable_water",
        "id": "air_dapat_diminum",
        "alias": "air_dapat_diminum_minum",
    },
    "\U0000267F": {
        "en": "wheelchair_symbol",
        "id": "simbol_kursi_roda",
        "alias": "simbol_kursi_roda_akses",
    },
    "\U0001F6B9": {"en": "mens_room", "id": "toilet_pria", "alias": "toilet_pria_kamar_kecil_wc"},
    "\U0001F6BA": {
        "en": "womens_room",
        "id": "toilet_wanita",
        "alias": "toilet_wanita_kamar_kecil_wc",
    },
    "\U0001F6BB": {"en": "restroom", "id": "kamar_kecil", "alias": "kamar_kecil_toilet_wc"},
    "\U0001F6BC": {"en": "baby_symbol", "id": "simbol_bayi", "alias": "simbol_bayi_ganti"},
    "\U0001F6BE": {
        "en": "water_closet",
        "id": "kloset_air",
        "alias": "kloset_air_kamar_kecil_toilet_wc",
    },
    "\U0001F6C2": {"en": "passport_control", "id": "kontrol_paspor"},
    "\U0001F6C3": {"en": "customs", "id": "bea_cukai"},
    "\U0001F6C4": {"en": "baggage_claim", "id": "pengambilan_bagasi"},
    "\U0001F6C5": {
        "en": "left_luggage",
        "id": "koper_tertinggal",
        "alias": "koper_tertinggal_bagasi_barang_loker",
    },
    "\U000026A0\U0000FE0F": {"en": "warning", "id": "peringatan"},
    "\U0001F6B8": {
        "en": "children_crossing",
        "id": "anak-anak_menyeberang",
        "alias": "anak-anak_menyeberang_anak_lalu_lintas_trotoar",
    },
    "\U000026D4": {
        "en": "no_entry",
        "id": "dilarang_masuk",
        "alias": "dilarang_masuk_lalu_lintas_terlarang_tidak",
    },
    "\U0001F6AB": {
        "en": "prohibited",
        "id": "dilarang",
        "alias": "dilarang_masuk_terlarang_tidak",
    },
    "\U0001F6B3": {
        "en": "no_bicycles",
        "id": "dilarang_bersepeda",
        "alias": "dilarang_bersepeda_kendaraan_sepeda_terlarang_tidak",
    },
    "\U0001F6AD": {
        "en": "no_smoking",
        "id": "dilarang_merokok",
        "alias": "dilarang_merokok_terlarang_tidak",
    },
    "\U0001F6AF": {
        "en": "no_littering",
        "id": "dilarang_membuang_sampah_sembarangan",
        "alias": "dilarang_membuang_sampah_sembarangan_terlarang_tidak",
    },
    "\U0001F6B1": {"en": "non-potable_water", "id": "air_tidak_dapat_diminum"},
    "\U0001F6B7": {
        "en": "no_pedestrians",
        "id": "pejalan_kaki_dilarang_masuk",
        "alias": "pejalan_kaki_dilarang_masuk_terlarang_tidak",
    },
    "\U0001F4F5": {
        "en": "no_mobile_phones",
        "id": "dilarang_menggunakan_ponsel",
        "alias": "dilarang_menggunakan_ponsel_mobile_seluler_telepon_terlarang_tidak",
    },
    "\U0001F51E": {
        "en": "no_one_under_eighteen",
        "id": "di_bawah_18_tahun_dilarang",
        "alias": "di_bawah_18_tahun_dilarang_batasan_usia_delapan_belas_umur",
    },
    "\U00002622\U0000FE0F": {"en": "radioactive", "id": "radioaktif", "alias": "radioaktif_tanda"},
    "\U00002623\U0000FE0F": {"en": "biohazard", "id": "biohazard", "alias": "biohazard_tanda"},
    "\U00002B06\U0000FE0F": {
        "en": "up_arrow",
        "id": "tanda_panah_atas",
        "alias": "tanda_panah_atas_arah_kardinal_utara",
    },
    "\U00002197\U0000FE0F": {
        "en": "up-right_arrow",
        "id": "tanda_panah_kanan_atas",
        "alias": "tanda_panah_kanan_atas_arah_interkardinal_timur_laut",
    },
    "\U000027A1\U0000FE0F": {
        "en": "right_arrow",
        "id": "tanda_panah_kanan",
        "alias": "tanda_panah_kanan_arah_kardinal_timur",
    },
    "\U00002198\U0000FE0F": {
        "en": "down-right_arrow",
        "id": "tanda_panah_kanan_bawah",
        "alias": "tanda_panah_kanan_bawah_arah_interkardinal_tenggara",
    },
    "\U00002B07\U0000FE0F": {
        "en": "down_arrow",
        "id": "tanda_panah_bawah",
        "alias": "tanda_panah_bawah_arah_kardinal_selatan",
    },
    "\U00002199\U0000FE0F": {
        "en": "down-left_arrow",
        "id": "tanda_panah_kiri_bawah",
        "alias": "tanda_panah_kiri_bawah_arah_barat_daya_interkardinal",
    },
    "\U00002B05\U0000FE0F": {
        "en": "left_arrow",
        "id": "tanda_panah_kiri",
        "alias": "tanda_panah_kiri_arah_barat_kardinal",
    },
    "\U00002196\U0000FE0F": {
        "en": "up-left_arrow",
        "id": "tanda_panah_kiri_atas",
        "alias": "tanda_panah_kiri_atas_arah_barat_laut_interkardinal",
    },
    "\U00002195\U0000FE0F": {"en": "up-down_arrow", "id": "tanda_panah_atas_bawah"},
    "\u2194\uFE0F": {"en": "left_right_arrow_stroke", "id": "panah_arah_kanan_kiri"},
    "\U000021A9\U0000FE0F": {
        "en": "right_arrow_curving_left",
        "id": "tanda_panah_kanan_melengkung_ke_kiri",
    },
    "\U000021AA\U0000FE0F": {
        "en": "left_arrow_curving_right",
        "id": "tanda_panah_kanan_melengkung_ke_kanan",
        "alias": "tanda_panah_kanan_melengkung_ke",
    },
    "\U00002934\U0000FE0F": {
        "en": "right_arrow_curving_up",
        "id": "tanda_panah_kanan_melengkung_ke_atas",
    },
    "\U00002935\U0000FE0F": {
        "en": "right_arrow_curving_down",
        "id": "tanda_panah_kanan_melengkung_ke_bawah",
    },
    "\U0001F503": {
        "en": "clockwise_vertical_arrows",
        "id": "tanda_panah_searah_jarum_jam",
        "alias": "tanda_panah_searah_jarum_jam_muat_ulang",
    },
    "\U0001F504": {
        "en": "counterclockwise_arrows_button",
        "id": "tanda_panah_berlawanan_arah_jarum_jam",
        "alias": "tanda_panah_berlawanan_arah_jarum_jam_berlawan_matahari_kebalikan",
    },
    "\U0001F519": {
        "en": "back_arrow",
        "id": "tanda_panah_back",
        "alias": "tanda_panah_back_kembali",
    },
    "\U0001F51A": {
        "en": "end_arrow",
        "id": "tanda_panah_end",
        "alias": "tanda_panah_end_berakhir",
    },
    "\U0001F51B": {"en": "on!_arrow", "id": "tanda_panah_on!", "alias": "tanda_panah_on!_aktif"},
    "\U0001F51C": {
        "en": "soon_arrow",
        "id": "tanda_panah_soon",
        "alias": "tanda_panah_soon_segera",
    },
    "\U0001F51D": {"en": "top_arrow", "id": "tanda_panah_top", "alias": "tanda_panah_top_ke_atas"},
    "\U0001F6D0": {
        "en": "place_of_worship",
        "id": "tempat_ibadah",
        "alias": "tempat_ibadah_agama_pemujaan",
    },
    "\U0000269B\U0000FE0F": {
        "en": "atom_symbol",
        "id": "simbol_atom",
        "alias": "simbol_atom_ateis",
    },
    "\U0001F549\U0000FE0F": {"en": "om", "id": "om", "alias": "om_agama_hindu"},
    "\U00002721\U0000FE0F": {
        "en": "star_of_david",
        "id": "bintang_daud",
        "alias": "bintang_daud_agama_yahudi",
    },
    "\U00002638\U0000FE0F": {
        "en": "wheel_of_dharma",
        "id": "roda_dharma",
        "alias": "roda_dharma_agama_budha",
    },
    "\U0000262F\U0000FE0F": {
        "en": "yin_yang",
        "id": "yin_yang",
        "alias": "yin_yang_agama_tao_taoisme",
    },
    "\U0000271D\U0000FE0F": {
        "en": "latin_cross",
        "id": "salib_latin",
        "alias": "salib_latin_agama_kristen",
    },
    "\U00002626\U0000FE0F": {
        "en": "orthodox_cross",
        "id": "salib_ortodoks",
        "alias": "salib_ortodoks_agama_kristen",
    },
    "\U0000262A\U0000FE0F": {
        "en": "star_and_crescent",
        "id": "bintang_dan_bulan",
        "alias": "bintang_dan_bulan_agama_islam_muslim",
    },
    "\U0000262E\U0000FE0F": {"en": "peace_symbol", "id": "simbol_damai"},
    "\U0001F54E": {
        "en": "menorah",
        "id": "menorah",
        "alias": "menorah_agama_candelabra_tempat_lilin",
    },
    "\U0001F52F": {
        "en": "dotted_six-pointed_star",
        "id": "bintang_sudut_enam_bertitik",
        "alias": "bintang_sudut_enam_bertitik_ramalan",
    },
    "\U00002648": {"en": "aries", "id": "aries", "alias": "aries_domba_zodiak"},
    "\U00002649": {"en": "taurus", "id": "taurus", "alias": "taurus_banteng_zodiak"},
    "\U0000264A": {"en": "gemini", "id": "gemini", "alias": "gemini_kembar_zodiak"},
    "\U0000264B": {"en": "cancer", "id": "cancer", "alias": "cancer_kepiting_zodiak"},
    "\U0000264C": {"en": "leo", "id": "leo", "alias": "leo_singa_zodiak"},
    "\U0000264D": {"en": "virgo", "id": "virgo", "alias": "virgo_zodiak"},
    "\U0000264E": {"en": "libra", "id": "libra", "alias": "libra_adil_seimbang_timbangan_zodiak"},
    "\U0000264F": {"en": "scorpio", "id": "scorpio", "alias": "scorpio_kalajengking_zodiak"},
    "\U00002650": {"en": "sagittarius", "id": "sagitarius", "alias": "sagitarius_pemanah_zodiak"},
    "\U00002651": {"en": "capricorn", "id": "capricorn", "alias": "capricorn_kambing_zodiak"},
    "\U00002652": {"en": "aquarius", "id": "aquarius", "alias": "aquarius_air_pembawa_zodiak"},
    "\U00002653": {"en": "pisces", "id": "pisces", "alias": "pisces_ikan_zodiak"},
    "\U000026CE": {"en": "ophiuchus", "id": "ophiuchus", "alias": "ophiuchus_pembawa_ular_zodiak"},
    "\U0001F500": {
        "en": "shuffle_tracks_button",
        "id": "tombol_acak_lagu",
        "alias": "tombol_acak_lagu_bersilangan_panah",
    },
    "\U0001F501": {
        "en": "repeat_button",
        "id": "tombol_ulangi",
        "alias": "tombol_ulangi_panah_searah_jarum_jam",
    },
    "\U0001F502": {
        "en": "repeat_single_button",
        "id": "tombol_ulangi_satu_lagu",
        "alias": "tombol_ulangi_satu_lagu_panah_searah_jarum_jam_sekali",
    },
    "\U000025B6\U0000FE0F": {
        "en": "play_button",
        "id": "tombol_putar",
        "alias": "tombol_putar_kanan_panah_segitiga",
    },
    "\U000023E9": {
        "en": "fast-forward_button",
        "id": "tombol_maju_cepat",
        "alias": "tombol_maju_cepat_dobel_panah",
    },
    "\U000023ED\U0000FE0F": {
        "en": "next_track_button",
        "id": "tombol_lagu_berikutnya",
        "alias": "tombol_lagu_berikutnya_adegan_selanjutnya_panah_segitiga",
    },
    "\U000023EF\U0000FE0F": {
        "en": "play_or_pause_button",
        "id": "tombol_putar_atau_jeda",
        "alias": "tombol_putar_atau_jeda_kanan_panah_segitiga",
    },
    "\U000025C0\U0000FE0F": {
        "en": "reverse_button",
        "id": "tombol_mundur",
        "alias": "tombol_mundur_balik_kiri_panah_segitiga",
    },
    "\U000023EA": {
        "en": "fast_reverse_button",
        "id": "tombol_mundur_cepat",
        "alias": "tombol_mundur_cepat_dobel_panah_putar_balik",
    },
    "\U000023EE\U0000FE0F": {
        "en": "last_track_button",
        "id": "tombol_lagu_terakhir",
        "alias": "tombol_lagu_terakhir_adegan_sebelumnya_panah_segitiga",
    },
    "\U0001F53C": {
        "en": "upwards_button",
        "id": "tombol_naik",
        "alias": "tombol_naik_merah_panah",
    },
    "\U000023EB": {
        "en": "fast_up_button",
        "id": "tombol_naik_cepat",
        "alias": "tombol_naik_cepat_dobel_panah",
    },
    "\U0001F53D": {
        "en": "downwards_button",
        "id": "tombol_turun",
        "alias": "tombol_turun_bawah_merah_panah",
    },
    "\U000023EC": {
        "en": "fast_down_button",
        "id": "tombol_turun_cepat",
        "alias": "tombol_turun_cepat_bawah_dobel_panah",
    },
    "\U000023F8\U0000FE0F": {
        "en": "pause_button",
        "id": "tombol_jeda",
        "alias": "tombol_jeda_batang_dobel_vertikal",
    },
    "\U000023F9\U0000FE0F": {
        "en": "stop_button",
        "id": "tombol_berhenti",
        "alias": "tombol_berhenti_kotak",
    },
    "\U000023FA\U0000FE0F": {
        "en": "record_button",
        "id": "tombol_rekam",
        "alias": "tombol_rekam_lingkaran",
    },
    "\U000023CF\U0000FE0F": {"en": "eject_button", "id": "tombol_keluarkan"},
    "\U0001F3A6": {"en": "cinema", "id": "film", "alias": "film_kamera"},
    "\U0001F505": {
        "en": "dim_button",
        "id": "tombol_redupkan",
        "alias": "tombol_redupkan_kecerahan_redup_rendah",
    },
    "\U0001F506": {
        "en": "bright_button",
        "id": "tombol_cerahkan",
        "alias": "tombol_cerahkan_cerah_kecerahan",
    },
    "\U0001F4F6": {
        "en": "antenna_bars",
        "id": "batang_antena",
        "alias": "batang_antena_ponsel_seluler_sinyal_telepon",
    },
    "\U0001F4F3": {
        "en": "vibration_mode",
        "id": "mode_getar",
        "alias": "mode_getar_ponsel_seluler_telepon",
    },
    "\U0001F4F4": {
        "en": "mobile_phone_off",
        "id": "ponsel_nonaktif",
        "alias": "ponsel_nonaktif_mati_seluler_telepon",
    },
    "\U00002640\U0000FE0F": {
        "en": "female_sign",
        "id": "simbol_wanita",
        "alias": "simbol_wanita_perempuan",
    },
    "\U00002642\U0000FE0F": {
        "en": "male_sign",
        "id": "simbol_pria",
        "alias": "simbol_pria_laki-laki",
    },
    "\U000026A7\U0000FE0F": {"en": "transgender_symbol", "id": "simbol_transgender"},
    "\U00002716\U0000FE0F": {
        "en": "multiply",
        "id": "kali",
        "alias": "kali_batal_perkalian_tanda_x",
    },
    "\U00002795": {"en": "plus", "id": "tambah", "alias": "tambah_+_matematika_plus_tanda"},
    "\U00002796": {"en": "minus", "id": "kurang", "alias": "kurang_-__matematika_minus_tanda"},
    "\U00002797": {"en": "divide", "id": "bagi", "alias": "bagi__matematika_pembagian_tanda"},
    "\U0000267E\U0000FE0F": {
        "en": "infinity",
        "id": "tak_terhingga",
        "alias": "tak_terhingga_selamanya_terbatas_universal",
    },
    "\U0000203C\U0000FE0F": {
        "en": "double_exclamation_mark",
        "id": "tanda_seru_ganda",
        "alias": "tanda_seru_ganda_bangbang_baca",
    },
    "\U00002049\U0000FE0F": {
        "en": "exclamation_question_mark",
        "id": "tanda_seru_dan_tanya",
        "alias": "tanda_seru_dan_tanya_pertanyaan_baca",
    },
    "\U00002753": {
        "en": "red_question_mark",
        "id": "tanda_tanya_merah",
        "alias": "tanda_tanya_merah_pertanyaan_baca",
    },
    "\U00002754": {
        "en": "white_question_mark",
        "id": "tanda_tanya_putih",
        "alias": "tanda_tanya_putih_garis_luar_pertanyaan_baca",
    },
    "\U00002755": {
        "en": "white_exclamation_mark",
        "id": "tanda_seru_putih",
        "alias": "tanda_seru_putih_garis_luar_baca",
    },
    "\U00002757": {
        "en": "red_exclamation_mark",
        "id": "tanda_seru_merah",
        "alias": "tanda_seru_merah_baca",
    },
    "\U00003030\U0000FE0F": {
        "en": "wavy_dash",
        "id": "garis_bergelombang",
        "alias": "garis_bergelombang_gelombang_tanda_baca_pisah",
    },
    "\U0001F4B1": {"en": "currency_exchange", "id": "kurs", "alias": "kurs_bank_mata_uang"},
    "\U0001F4B2": {
        "en": "heavy_dollar_sign",
        "id": "tanda_dolar_tebal",
        "alias": "tanda_dolar_tebal_mata_uang_dollar",
    },
    "\U00002695\U0000FE0F": {
        "en": "medical_symbol",
        "id": "simbol_kedokteran",
        "alias": "simbol_kedokteran_aesculapius_tongkat",
    },
    "\U0000267B\U0000FE0F": {"en": "recycling_symbol", "id": "simbol_daur_ulang"},
    "\U0000269C\U0000FE0F": {
        "en": "fleur-de-lis",
        "id": "fleur-de-lis",
        "alias": "fleur-de-lis_tanda",
    },
    "\U0001F531": {
        "en": "trident_emblem",
        "id": "emblem_trisula",
        "alias": "emblem_trisula_alat_jangkar_kapal",
    },
    "\U0001F4DB": {"en": "name_badge", "id": "lencana_nama"},
    "\U0001F530": {
        "en": "japanese_symbol_for_beginner",
        "id": "simbol_jepang_untuk_pemula",
        "alias": "simbol_jepang_untuk_pemula_daun_tanda_pangkat",
    },
    "\U00002B55": {
        "en": "hollow_red_circle",
        "id": "lingkaran_besar_tebal",
        "alias": "lingkaran_besar_tebal_o",
    },
    "\U00002705": {"en": "check_mark_button", "id": "tanda_centang_putih_tebal"},
    "\U00002611\U0000FE0F": {
        "en": "check_box_with_check",
        "id": "kotak_bercentang",
        "alias": "kotak_bercentang_centang",
    },
    "\U00002714\U0000FE0F": {"en": "check_mark", "id": "tanda_centang_tebal"},
    "\U0000274C": {
        "en": "cross_mark",
        "id": "tanda_silang",
        "alias": "tanda_silang_batal_kali_perkalian_x",
    },
    "\U0000274E": {
        "en": "cross_mark_button",
        "id": "tombol_tanda_silang",
        "alias": "tombol_tanda_silang_kotak",
    },
    "\U000027B0": {
        "en": "curly_loop",
        "id": "untaian_bergelombang",
        "alias": "untaian_bergelombang_gelombang_putaran",
    },
    "\U000027BF": {
        "en": "double_curly_loop",
        "id": "untaian_bergelombang_ganda",
        "alias": "untaian_bergelombang_ganda_dobel_gelombang_putaran",
    },
    "\U0000303D\U0000FE0F": {"en": "part_alternation_mark", "id": "tanda_alternasi_bagian"},
    "\U00002733\U0000FE0F": {
        "en": "eight-spoked_asterisk",
        "id": "bintang_berujung_lancip_delapan",
        "alias": "bintang_berujung_lancip_delapan_tanda",
    },
    "\U00002734\U0000FE0F": {"en": "eight-pointed_star", "id": "bintang_berujung_delapan"},
    "\U00002747\U0000FE0F": {"en": "sparkle", "id": "kilauan", "alias": "kilauan_*"},
    "\U000000A9\U0000FE0F": {"en": "copyright", "id": "hak_cipta"},
    "\U000000AE\U0000FE0F": {"en": "registered", "id": "terdaftar"},
    "\U00002122\U0000FE0F": {
        "en": "trade_mark",
        "id": "merek_dagang",
        "alias": "merek_dagang_tanda_tm",
    },
    "\U00000023\U0000FE0F\U000020E3": {"en": "keycap_#", "id": "keycap_#"},
    # can't compile re pattern
    # u"\U0000002A\U0000FE0F\U000020E3": {"en": "keycap_*", "id": "keycap_*"},
    "\U00000030\U0000FE0F\U000020E3": {"en": "keycap_0", "id": "keycap_0"},
    "\U00000031\U0000FE0F\U000020E3": {"en": "keycap_1", "id": "keycap_1"},
    "\U00000032\U0000FE0F\U000020E3": {"en": "keycap_2", "id": "keycap_2"},
    "\U00000033\U0000FE0F\U000020E3": {"en": "keycap_3", "id": "keycap_3"},
    "\U00000034\U0000FE0F\U000020E3": {"en": "keycap_4", "id": "keycap_4"},
    "\U00000035\U0000FE0F\U000020E3": {"en": "keycap_5", "id": "keycap_5"},
    "\U00000036\U0000FE0F\U000020E3": {"en": "keycap_6", "id": "keycap_6"},
    "\U00000037\U0000FE0F\U000020E3": {"en": "keycap_7", "id": "keycap_7"},
    "\U00000038\U0000FE0F\U000020E3": {"en": "keycap_8", "id": "keycap_8"},
    "\U00000039\U0000FE0F\U000020E3": {"en": "keycap_9", "id": "keycap_9"},
    "\U0001F51F": {"en": "keycap_10", "id": "keycap_10"},
    "\U0001F520": {
        "en": "input_latin_uppercase",
        "id": "masukan_huruf_kapital_latin",
        "alias": "masukan_huruf_kapital_latin_abcd",
    },
    "\U0001F521": {
        "en": "input_latin_lowercase",
        "id": "masukan_huruf_kecil_latin",
        "alias": "masukan_huruf_kecil_latin_abcd",
    },
    "\U0001F522": {"en": "input_numbers", "id": "masukan_angka", "alias": "masukan_angka_1234"},
    "\U0001F523": {"en": "input_symbols", "id": "masukan_simbol", "alias": "masukan_simbol_&%"},
    "\U0001F524": {
        "en": "input_latin_letters",
        "id": "masukan_huruf_latin",
        "alias": "masukan_huruf_latin_abc_alfabet",
    },
    "\U0001F170\U0000FE0F": {
        "en": "a_button_(blood_type)",
        "id": "tombol_a_(golongan_darah)",
        "alias": "tombol_a_golongan_darah",
    },
    "\U0001F18E": {
        "en": "ab_button_(blood_type)",
        "id": "tombol_ab_(golongan_darah)",
        "alias": "tombol_ab_golongan_darah",
    },
    "\U0001F171\U0000FE0F": {
        "en": "b_button_(blood_type)",
        "id": "tombol_b_(golongan_darah)",
        "alias": "tombol_b_golongan_darah",
    },
    "\U0001F191": {"en": "cl_button", "id": "tombol_cl"},
    "\U0001F192": {"en": "cool_button", "id": "tombol_cool"},
    "\U0001F193": {
        "en": "free_button",
        "id": "tombol_free",
        "alias": "tombol_free_bebas_dalam_kotak",
    },
    "\U00002139\U0000FE0F": {"en": "information", "id": "informasi", "alias": "informasi_i"},
    "\U0001F194": {"en": "id_button", "id": "tombol_id", "alias": "tombol_id_identitas"},
    "\U000024C2\U0000FE0F": {"en": "circled_m", "id": "huruf_m_dalam_lingkaran"},
    "\U0001F195": {"en": "new_button", "id": "tombol_new", "alias": "tombol_new_baru"},
    "\U0001F196": {"en": "ng_button", "id": "tombol_ng"},
    "\U0001F17E\U0000FE0F": {
        "en": "o_button_(blood_type)",
        "id": "tombol_o_(golongan_darah)",
        "alias": "tombol_o_golongan_darah",
    },
    "\U0001F197": {"en": "ok_button", "id": "tombol_ok", "alias": "tombol_ok_oke"},
    "\U0001F17F\U0000FE0F": {"en": "p_button", "id": "tombol_p", "alias": "tombol_p_parkir"},
    "\U0001F198": {"en": "sos_button", "id": "tombol_sos", "alias": "tombol_sos_bantuan"},
    "\U0001F199": {"en": "up!_button", "id": "tombol_up!", "alias": "tombol_up!_ke_atas_tanda"},
    "\U0001F19A": {"en": "vs_button", "id": "tombol_vs", "alias": "tombol_vs_versus"},
    "\U0001F201": {
        "en": "japanese_here_button",
        "id": 'tombol_jepang_"di_sini"',
        "alias": 'tombol_jepang_"di_sini"_katakana',
    },
    "\U0001F202\U0000FE0F": {
        "en": "japanese_service_charge_button",
        "id": 'tombol_jepang_"biaya_layanan"',
        "alias": 'tombol_jepang_"biaya_layanan"_katakana',
    },
    "\U0001F237\U0000FE0F": {
        "en": "japanese_monthly_amount_button",
        "id": 'tombol_jepang_"jumlah_bulanan"',
        "alias": 'tombol_jepang_"jumlah_bulanan"_ideograf',
    },
    "\U0001F236": {
        "en": "japanese_not_free_of_charge_button",
        "id": 'tombol_jepang_"tidak_gratis"',
        "alias": 'tombol_jepang_"tidak_gratis"_ideograf',
    },
    "\U0001F22F": {
        "en": "japanese_reserved_button",
        "id": 'tombol_jepang_"sudah_dipesan"',
        "alias": 'tombol_jepang_"sudah_dipesan"_ideograf',
    },
    "\U0001F250": {
        "en": "japanese_bargain_button",
        "id": "karakter_keunggulan_dalam_lingkaran",
        "alias": "karakter_keunggulan_dalam_lingkaran_jepang",
    },
    "\U0001F239": {
        "en": "japanese_discount_button",
        "id": 'tombol_jepang_"diskon"',
        "alias": 'tombol_jepang_"diskon"_ideograf',
    },
    "\U0001F21A": {
        "en": "japanese_free_of_charge_button",
        "id": 'tombol_jepang_"gratis"',
        "alias": 'tombol_jepang_"gratis"_ideograf',
    },
    "\U0001F232": {
        "en": "japanese_prohibited_button",
        "id": 'tombol_jepang_"dilarang"',
        "alias": 'tombol_jepang_"dilarang"_ideograf',
    },
    "\U0001F251": {
        "en": "japanese_acceptable_button",
        "id": 'tombol_jepang_"dapat_diterima"',
        "alias": 'tombol_jepang_"dapat_diterima"_ideograf_diterima',
    },
    "\U0001F238": {
        "en": "japanese_application_button",
        "id": 'tombol_jepang_"lamaran_kerja"',
        "alias": 'tombol_jepang_"lamaran_kerja"_china_cina_karakter_terapkan_dalam_kotak',
    },
    "\U0001F234": {
        "en": "japanese_passing_grade_button",
        "id": 'tombol_jepang_"nilai_kelulusan"',
        "alias": 'tombol_jepang_"nilai_kelulusan"_ideograf',
    },
    "\U0001F233": {
        "en": "japanese_vacancy_button",
        "id": 'tombol_jepang_"ada_lowongan"',
        "alias": 'tombol_jepang_"ada_lowongan"_ideograf',
    },
    "\U00003297\U0000FE0F": {
        "en": "japanese_congratulations_button",
        "id": 'tombol_jepang_"selamat"',
        "alias": 'tombol_jepang_"selamat"_ideograf',
    },
    "\U00003299\U0000FE0F": {
        "en": "japanese_secret_button",
        "id": 'tombol_jepang_"rahasia"',
        "alias": 'tombol_jepang_"rahasia"_ideograf',
    },
    "\U0001F23A": {
        "en": "japanese_open_for_business_button",
        "id": 'tombol_jepang_"siap_berbisnis"',
        "alias": 'tombol_jepang_"siap_berbisnis"_ideograf',
    },
    "\U0001F235": {
        "en": "japanese_no_vacancy_button",
        "id": 'tombol_jepang_"tidak_ada_lowongan"',
        "alias": 'tombol_jepang_"tidak_ada_lowongan"_ideograf',
    },
    "\U0001F534": {
        "en": "red_circle",
        "id": "lingkaran_merah",
        "alias": "lingkaran_merah_geometri",
    },
    "\U0001F7E0": {"en": "orange_circle", "id": "lingkaran_oranye"},
    "\U0001F7E1": {"en": "yellow_circle", "id": "lingkaran_kuning"},
    "\U0001F7E2": {"en": "green_circle", "id": "lingkaran_hijau"},
    "\U0001F535": {
        "en": "blue_circle",
        "id": "lingkaran_biru",
        "alias": "lingkaran_biru_geometri",
    },
    "\U0001F7E3": {"en": "purple_circle", "id": "lingkaran_ungu"},
    "\U0001F7E4": {"en": "brown_circle", "id": "lingkaran_cokelat"},
    "\U000026AB": {
        "en": "black_circle",
        "id": "lingkaran_hitam",
        "alias": "lingkaran_hitam_geometri",
    },
    "\U000026AA": {
        "en": "white_circle",
        "id": "lingkaran_putih",
        "alias": "lingkaran_putih_geometri",
    },
    "\U0001F7E5": {"en": "red_square", "id": "persegi_merah"},
    "\U0001F7E7": {"en": "orange_square", "id": "persegi_oranye"},
    "\U0001F7E8": {"en": "yellow_square", "id": "persegi_kuning"},
    "\U0001F7E9": {"en": "green_square", "id": "persegi_hijau"},
    "\U0001F7E6": {"en": "blue_square", "id": "persegi_biru"},
    "\U0001F7EA": {"en": "purple_square", "id": "persegi_ungu"},
    "\U0001F7EB": {"en": "brown_square", "id": "persegi_cokelat"},
    "\U00002B1B": {
        "en": "black_large_square",
        "id": "persegi_besar_hitam",
        "alias": "persegi_besar_hitam_geometri",
    },
    "\U00002B1C": {
        "en": "white_large_square",
        "id": "persegi_besar_putih",
        "alias": "persegi_besar_putih_geometri",
    },
    "\U000025FC\U0000FE0F": {
        "en": "black_medium_square",
        "id": "persegi_medium_hitam",
        "alias": "persegi_medium_hitam_geometri",
    },
    "\U000025FB\U0000FE0F": {
        "en": "white_medium_square",
        "id": "persegi_medium_putih",
        "alias": "persegi_medium_putih_geometri",
    },
    "\U000025FE": {
        "en": "black_medium-small_square",
        "id": "persegi_kecil_medium_hitam",
        "alias": "persegi_kecil_medium_hitam_geometri",
    },
    "\U000025FD": {
        "en": "white_medium-small_square",
        "id": "persegi_kecil_medium_putih",
        "alias": "persegi_kecil_medium_putih_geometri",
    },
    "\U000025AA\U0000FE0F": {
        "en": "black_small_square",
        "id": "persegi_kecil_hitam",
        "alias": "persegi_kecil_hitam_geometri",
    },
    "\U000025AB\U0000FE0F": {
        "en": "white_small_square",
        "id": "persegi_kecil_putih",
        "alias": "persegi_kecil_putih_geometri",
    },
    "\U0001F536": {
        "en": "large_orange_diamond",
        "id": "wajik_oranye_besar",
        "alias": "wajik_oranye_besar_geometri",
    },
    "\U0001F537": {
        "en": "large_blue_diamond",
        "id": "wajik_biru_besar",
        "alias": "wajik_biru_besar_geometri",
    },
    "\U0001F538": {
        "en": "small_orange_diamond",
        "id": "wajik_oranye_kecil",
        "alias": "wajik_oranye_kecil_geometri",
    },
    "\U0001F539": {
        "en": "small_blue_diamond",
        "id": "wajik_biru_kecil",
        "alias": "wajik_biru_kecil_geometri",
    },
    "\U0001F53A": {
        "en": "red_triangle_pointed_up",
        "id": "segitiga_merah_mengarah_ke_atas",
        "alias": "segitiga_merah_mengarah_ke_atas_geometri",
    },
    "\U0001F53B": {
        "en": "red_triangle_pointed_down",
        "id": "segitiga_merah_mengarah_ke_bawah",
        "alias": "segitiga_merah_mengarah_ke_bawah_geometri_turun",
    },
    "\U0001F4A0": {
        "en": "diamond_with_a_dot",
        "id": "wajik_bertitik",
        "alias": "wajik_bertitik_di_dalam_geometri_komik",
    },
    "\U0001F518": {"en": "radio_button", "id": "tombol_radio", "alias": "tombol_radio_geometri"},
    "\U0001F533": {
        "en": "white_square_button",
        "id": "tombol_persegi_putih",
        "alias": "tombol_persegi_putih_garis_luar_geometri",
    },
    "\U0001F532": {
        "en": "black_square_button",
        "id": "tombol_persegi_hitam",
        "alias": "tombol_persegi_hitam_geometri",
    },
    "\U0001F3C1": {
        "en": "chequered_flag",
        "id": "bendera_kotak-kotak",
        "alias": "bendera_kotak-kotak_balapan_petak-petak",
    },
    "\U0001F6A9": {
        "en": "triangular_flag",
        "id": "bendera_segitiga",
        "alias": "bendera_segitiga_tiang",
    },
    "\U0001F38C": {
        "en": "crossed_flags",
        "id": "bendera_menyilang",
        "alias": "bendera_menyilang_jepang_perayaan_silang",
    },
    "\U0001F3F4": {"en": "black_flag", "id": "bendera_hitam", "alias": "bendera_hitam_berkibar"},
    "\U0001F3F3\U0000FE0F": {
        "en": "white_flag",
        "id": "bendera_putih",
        "alias": "bendera_putih_berkibar",
    },
    "\U0001F3F3\U0000FE0F\U0000200D\U0001F308": {"en": "rainbow_flag", "id": "bendera_pelangi"},
    "\U0001F3F3\U0000FE0F\U0000200D\U000026A7\U0000FE0F": {
        "en": "transgender_flag",
        "id": "bendera_transgender",
        "alias": "bendera_transgender_biru_muda_merah_putih",
    },
    "\U0001F3F4\U0000200D\U00002620\U0000FE0F": {
        "en": "pirate_flag",
        "id": "bendera_bajak_laut",
        "alias": "bendera_bajak_laut_harta_karun_jolly_roger",
    },
    "\U0001F1E6\U0001F1E8": {"en": "flag_ascension_island", "id": "bendera_pulau_ascension"},
    "\U0001F1E6\U0001F1E9": {"en": "flag_andorra", "id": "bendera_andorra"},
    "\U0001F1E6\U0001F1EA": {"en": "flag_united_arab_emirates", "id": "bendera_uni_emirat_arab"},
    "\U0001F1E6\U0001F1EB": {"en": "flag_afghanistan", "id": "bendera_afganistan"},
    "\U0001F1E6\U0001F1EC": {"en": "flag_antigua_&_barbuda", "id": "bendera_antigua_dan_barbuda"},
    "\U0001F1E6\U0001F1EE": {"en": "flag_anguilla", "id": "bendera_anguilla"},
    "\U0001F1E6\U0001F1F1": {"en": "flag_albania", "id": "bendera_albania"},
    "\U0001F1E6\U0001F1F2": {"en": "flag_armenia", "id": "bendera_armenia"},
    "\U0001F1E6\U0001F1F4": {"en": "flag_angola", "id": "bendera_angola"},
    "\U0001F1E6\U0001F1F6": {"en": "flag_antarctica", "id": "bendera_antarktika"},
    "\U0001F1E6\U0001F1F7": {"en": "flag_argentina", "id": "bendera_argentina"},
    "\U0001F1E6\U0001F1F8": {"en": "flag_american_samoa", "id": "bendera_samoa_amerika"},
    "\U0001F1E6\U0001F1F9": {"en": "flag_austria", "id": "bendera_austria"},
    "\U0001F1E6\U0001F1FA": {"en": "flag_australia", "id": "bendera_australia"},
    "\U0001F1E6\U0001F1FC": {"en": "flag_aruba", "id": "bendera_aruba"},
    "\U0001F1E6\U0001F1FD": {"en": "flag_aland_islands", "id": "bendera_kepulauan_aland"},
    "\U0001F1E6\U0001F1FF": {"en": "flag_azerbaijan", "id": "bendera_azerbaijan"},
    "\U0001F1E7\U0001F1E6": {
        "en": "flag_bosnia_&_herzegovina",
        "id": "bendera_bosnia_dan_herzegovina",
    },
    "\U0001F1E7\U0001F1E7": {"en": "flag_barbados", "id": "bendera_barbados"},
    "\U0001F1E7\U0001F1E9": {"en": "flag_bangladesh", "id": "bendera_bangladesh"},
    "\U0001F1E7\U0001F1EA": {"en": "flag_belgium", "id": "bendera_belgia"},
    "\U0001F1E7\U0001F1EB": {"en": "flag_burkina_faso", "id": "bendera_burkina_faso"},
    "\U0001F1E7\U0001F1EC": {"en": "flag_bulgaria", "id": "bendera_bulgaria"},
    "\U0001F1E7\U0001F1ED": {"en": "flag_bahrain", "id": "bendera_bahrain"},
    "\U0001F1E7\U0001F1EE": {"en": "flag_burundi", "id": "bendera_burundi"},
    "\U0001F1E7\U0001F1EF": {"en": "flag_benin", "id": "bendera_benin"},
    "\U0001F1E7\U0001F1F1": {
        "en": "flag_st._barthelemy",
        "id": "bendera_saint_barthelemy",
        "alias": "bendera_saint_barthelemy_barthelemy",
    },
    "\U0001F1E7\U0001F1F2": {"en": "flag_bermuda", "id": "bendera_bermuda"},
    "\U0001F1E7\U0001F1F3": {"en": "flag_brunei", "id": "bendera_brunei"},
    "\U0001F1E7\U0001F1F4": {"en": "flag_bolivia", "id": "bendera_bolivia"},
    "\U0001F1E7\U0001F1F6": {"en": "flag_caribbean_netherlands", "id": "bendera_belanda_karibia"},
    "\U0001F1E7\U0001F1F7": {"en": "flag_brazil", "id": "bendera_brasil"},
    "\U0001F1E7\U0001F1F8": {"en": "flag_bahamas", "id": "bendera_bahama"},
    "\U0001F1E7\U0001F1F9": {"en": "flag_bhutan", "id": "bendera_bhutan"},
    "\U0001F1E7\U0001F1FB": {"en": "flag_bouvet_island", "id": "bendera_pulau_bouvet"},
    "\U0001F1E7\U0001F1FC": {"en": "flag_botswana", "id": "bendera_botswana"},
    "\U0001F1E7\U0001F1FE": {"en": "flag_belarus", "id": "bendera_belarus"},
    "\U0001F1E7\U0001F1FF": {"en": "flag_belize", "id": "bendera_belize"},
    "\U0001F1E8\U0001F1E6": {"en": "flag_canada", "id": "bendera_kanada"},
    "\U0001F1E8\U0001F1E8": {
        "en": "flag_cocos_(keeling)_islands",
        "id": "bendera_kepulauan_cocos_(keeling)",
        "alias": "bendera_kepulauan_cocos_keeling",
    },
    "\U0001F1E8\U0001F1E9": {"en": "flag_congo_-_kinshasa", "id": "bendera_kongo_-_kinshasa"},
    "\U0001F1E8\U0001F1EB": {
        "en": "flag_central_african_republic",
        "id": "bendera_republik_afrika_tengah",
    },
    "\U0001F1E8\U0001F1EC": {
        "en": "flag_congo_-_brazzaville",
        "id": "bendera_kongo_-_brazzaville",
    },
    "\U0001F1E8\U0001F1ED": {"en": "flag_switzerland", "id": "bendera_swiss"},
    "\U0001F1E8\U0001F1EE": {
        "en": "flag_cote_divoire",
        "id": "bendera_cote_divoire",
        "alias": "bendera_cote_divoire_cote",
    },
    "\U0001F1E8\U0001F1F0": {"en": "flag_cook_islands", "id": "bendera_kepulauan_cook"},
    "\U0001F1E8\U0001F1F1": {"en": "flag_chile", "id": "bendera_cile"},
    "\U0001F1E8\U0001F1F2": {"en": "flag_cameroon", "id": "bendera_kamerun"},
    "\U0001F1E8\U0001F1F3": {"en": "flag_china", "id": "bendera_tiongkok"},
    "\U0001F1E8\U0001F1F4": {"en": "flag_colombia", "id": "bendera_kolombia"},
    "\U0001F1E8\U0001F1F5": {"en": "flag_clipperton_island", "id": "bendera_pulau_clipperton"},
    "\U0001F1E8\U0001F1F7": {"en": "flag_costa_rica", "id": "bendera_kosta_rika"},
    "\U0001F1E8\U0001F1FA": {"en": "flag_cuba", "id": "bendera_kuba"},
    "\U0001F1E8\U0001F1FB": {"en": "flag_cape_verde", "id": "bendera_tanjung_verde"},
    "\U0001F1E8\U0001F1FC": {
        "en": "flag_curacao",
        "id": "bendera_curacao",
        "alias": "bendera_curacao_curacao",
    },
    "\U0001F1E8\U0001F1FD": {"en": "flag_christmas_island", "id": "bendera_pulau_natal"},
    "\U0001F1E8\U0001F1FE": {"en": "flag_cyprus", "id": "bendera_siprus"},
    "\U0001F1E8\U0001F1FF": {"en": "flag_czechia", "id": "bendera_ceko"},
    "\U0001F1E9\U0001F1EA": {"en": "flag_germany", "id": "bendera_jerman"},
    "\U0001F1E9\U0001F1EC": {"en": "flag_diego_garcia", "id": "bendera_diego_garcia"},
    "\U0001F1E9\U0001F1EF": {"en": "flag_djibouti", "id": "bendera_jibuti"},
    "\U0001F1E9\U0001F1F0": {"en": "flag_denmark", "id": "bendera_denmark"},
    "\U0001F1E9\U0001F1F2": {"en": "flag_dominica", "id": "bendera_dominika"},
    "\U0001F1E9\U0001F1F4": {"en": "flag_dominican_republic", "id": "bendera_republik_dominika"},
    "\U0001F1E9\U0001F1FF": {"en": "flag_algeria", "id": "bendera_aljazair"},
    "\U0001F1EA\U0001F1E6": {"en": "flag_ceuta_&_melilla", "id": "bendera_ceuta_dan_melilla"},
    "\U0001F1EA\U0001F1E8": {"en": "flag_ecuador", "id": "bendera_ekuador"},
    "\U0001F1EA\U0001F1EA": {"en": "flag_estonia", "id": "bendera_estonia"},
    "\U0001F1EA\U0001F1EC": {"en": "flag_egypt", "id": "bendera_mesir"},
    "\U0001F1EA\U0001F1ED": {"en": "flag_western_sahara", "id": "bendera_sahara_barat"},
    "\U0001F1EA\U0001F1F7": {"en": "flag_eritrea", "id": "bendera_eritrea"},
    "\U0001F1EA\U0001F1F8": {"en": "flag_spain", "id": "bendera_spanyol"},
    "\U0001F1EA\U0001F1F9": {"en": "flag_ethiopia", "id": "bendera_etiopia"},
    "\U0001F1EA\U0001F1FA": {"en": "flag_european_union", "id": "bendera_uni_eropa"},
    "\U0001F1EB\U0001F1EE": {"en": "flag_finland", "id": "bendera_finlandia"},
    "\U0001F1EB\U0001F1EF": {"en": "flag_fiji", "id": "bendera_fiji"},
    "\U0001F1EB\U0001F1F0": {"en": "flag_falkland_islands", "id": "bendera_kepulauan_falkland"},
    "\U0001F1EB\U0001F1F2": {"en": "flag_micronesia", "id": "bendera_mikronesia"},
    "\U0001F1EB\U0001F1F4": {"en": "flag_faroe_islands", "id": "bendera_kepulauan_faroe"},
    "\U0001F1EB\U0001F1F7": {"en": "flag_france", "id": "bendera_prancis"},
    "\U0001F1EC\U0001F1E6": {"en": "flag_gabon", "id": "bendera_gabon"},
    "\U0001F1EC\U0001F1E7": {"en": "flag_united_kingdom", "id": "bendera_inggris_raya"},
    "\U0001F1EC\U0001F1E9": {"en": "flag_grenada", "id": "bendera_grenada"},
    "\U0001F1EC\U0001F1EA": {"en": "flag_georgia", "id": "bendera_georgia"},
    "\U0001F1EC\U0001F1EB": {"en": "flag_french_guiana", "id": "bendera_guyana_prancis"},
    "\U0001F1EC\U0001F1EC": {"en": "flag_guernsey", "id": "bendera_guernsey"},
    "\U0001F1EC\U0001F1ED": {"en": "flag_ghana", "id": "bendera_ghana"},
    "\U0001F1EC\U0001F1EE": {"en": "flag_gibraltar", "id": "bendera_gibraltar"},
    "\U0001F1EC\U0001F1F1": {"en": "flag_greenland", "id": "bendera_greenland"},
    "\U0001F1EC\U0001F1F2": {"en": "flag_gambia", "id": "bendera_gambia"},
    "\U0001F1EC\U0001F1F3": {"en": "flag_guinea", "id": "bendera_guinea"},
    "\U0001F1EC\U0001F1F5": {"en": "flag_guadeloupe", "id": "bendera_guadeloupe"},
    "\U0001F1EC\U0001F1F6": {"en": "flag_equatorial_guinea", "id": "bendera_guinea_ekuatorial"},
    "\U0001F1EC\U0001F1F7": {"en": "flag_greece", "id": "bendera_yunani"},
    "\U0001F1EC\U0001F1F8": {
        "en": "flag_south_georgia_&_south_sandwich_islands",
        "id": "bendera_georgia_selatan_&_kep._sandwich_selatan",
        "alias": "bendera_georgia_selatan_&_kep._sandwich",
    },
    "\U0001F1EC\U0001F1F9": {"en": "flag_guatemala", "id": "bendera_guatemala"},
    "\U0001F1EC\U0001F1FA": {"en": "flag_guam", "id": "bendera_guam"},
    "\U0001F1EC\U0001F1FC": {"en": "flag_guinea-bissau", "id": "bendera_guinea-bissau"},
    "\U0001F1EC\U0001F1FE": {"en": "flag_guyana", "id": "bendera_guyana"},
    "\U0001F1ED\U0001F1F0": {
        "en": "flag_hong_kong_sar_china",
        "id": "bendera_hong_kong_dak_tiongkok",
    },
    "\U0001F1ED\U0001F1F2": {
        "en": "flag_heard_&_mcdonald_islands",
        "id": "bendera_pulau_heard_dan_kepulauan_mcdonald",
    },
    "\U0001F1ED\U0001F1F3": {"en": "flag_honduras", "id": "bendera_honduras"},
    "\U0001F1ED\U0001F1F7": {"en": "flag_croatia", "id": "bendera_kroasia"},
    "\U0001F1ED\U0001F1F9": {"en": "flag_haiti", "id": "bendera_haiti"},
    "\U0001F1ED\U0001F1FA": {"en": "flag_hungary", "id": "bendera_hungaria"},
    "\U0001F1EE\U0001F1E8": {"en": "flag_canary_islands", "id": "bendera_kepulauan_canaria"},
    "\U0001F1EE\U0001F1E9": {"en": "flag_indonesia", "id": "bendera_indonesia"},
    "\U0001F1EE\U0001F1EA": {"en": "flag_ireland", "id": "bendera_irlandia"},
    "\U0001F1EE\U0001F1F1": {"en": "flag_israel", "id": "bendera_israel"},
    "\U0001F1EE\U0001F1F2": {"en": "flag_isle_of_man", "id": "bendera_pulau_man"},
    "\U0001F1EE\U0001F1F3": {"en": "flag_india", "id": "bendera_india"},
    "\U0001F1EE\U0001F1F4": {
        "en": "flag_british_indian_ocean_territory",
        "id": "bendera_wilayah_inggris_di_samudra_hindia",
    },
    "\U0001F1EE\U0001F1F6": {"en": "flag_iraq", "id": "bendera_irak"},
    "\U0001F1EE\U0001F1F7": {"en": "flag_iran", "id": "bendera_iran"},
    "\U0001F1EE\U0001F1F8": {"en": "flag_iceland", "id": "bendera_islandia"},
    "\U0001F1EE\U0001F1F9": {"en": "flag_italy", "id": "bendera_italia"},
    "\U0001F1EF\U0001F1EA": {"en": "flag_jersey", "id": "bendera_jersey"},
    "\U0001F1EF\U0001F1F2": {"en": "flag_jamaica", "id": "bendera_jamaika"},
    "\U0001F1EF\U0001F1F4": {"en": "flag_jordan", "id": "bendera_yordania"},
    "\U0001F1EF\U0001F1F5": {"en": "flag_japan", "id": "bendera_jepang"},
    "\U0001F1F0\U0001F1EA": {"en": "flag_kenya", "id": "bendera_kenya"},
    "\U0001F1F0\U0001F1EC": {"en": "flag_kyrgyzstan", "id": "bendera_kirgizstan"},
    "\U0001F1F0\U0001F1ED": {"en": "flag_cambodia", "id": "bendera_kamboja"},
    "\U0001F1F0\U0001F1EE": {"en": "flag_kiribati", "id": "bendera_kiribati"},
    "\U0001F1F0\U0001F1F2": {"en": "flag_comoros", "id": "bendera_komoro"},
    "\U0001F1F0\U0001F1F3": {
        "en": "flag_st._kitts_&_nevis",
        "id": "bendera_saint_kitts_dan_nevis",
    },
    "\U0001F1F0\U0001F1F5": {"en": "flag_north_korea", "id": "bendera_korea_utara"},
    "\U0001F1F0\U0001F1F7": {"en": "flag_south_korea", "id": "bendera_korea_selatan"},
    "\U0001F1F0\U0001F1FC": {"en": "flag_kuwait", "id": "bendera_kuwait"},
    "\U0001F1F0\U0001F1FE": {"en": "flag_cayman_islands", "id": "bendera_kepulauan_cayman"},
    "\U0001F1F0\U0001F1FF": {"en": "flag_kazakhstan", "id": "bendera_kazakhstan"},
    "\U0001F1F1\U0001F1E6": {"en": "flag_laos", "id": "bendera_laos"},
    "\U0001F1F1\U0001F1E7": {"en": "flag_lebanon", "id": "bendera_lebanon"},
    "\U0001F1F1\U0001F1E8": {"en": "flag_st._lucia", "id": "bendera_saint_lucia"},
    "\U0001F1F1\U0001F1EE": {"en": "flag_liechtenstein", "id": "bendera_liechtenstein"},
    "\U0001F1F1\U0001F1F0": {"en": "flag_sri_lanka", "id": "bendera_sri_lanka"},
    "\U0001F1F1\U0001F1F7": {"en": "flag_liberia", "id": "bendera_liberia"},
    "\U0001F1F1\U0001F1F8": {"en": "flag_lesotho", "id": "bendera_lesotho"},
    "\U0001F1F1\U0001F1F9": {"en": "flag_lithuania", "id": "bendera_lituania"},
    "\U0001F1F1\U0001F1FA": {"en": "flag_luxembourg", "id": "bendera_luksemburg"},
    "\U0001F1F1\U0001F1FB": {"en": "flag_latvia", "id": "bendera_latvia"},
    "\U0001F1F1\U0001F1FE": {"en": "flag_libya", "id": "bendera_libya"},
    "\U0001F1F2\U0001F1E6": {"en": "flag_morocco", "id": "bendera_maroko"},
    "\U0001F1F2\U0001F1E8": {"en": "flag_monaco", "id": "bendera_monako"},
    "\U0001F1F2\U0001F1E9": {"en": "flag_moldova", "id": "bendera_moldova"},
    "\U0001F1F2\U0001F1EA": {"en": "flag_montenegro", "id": "bendera_montenegro"},
    "\U0001F1F2\U0001F1EB": {"en": "flag_st._martin", "id": "bendera_saint_martin"},
    "\U0001F1F2\U0001F1EC": {"en": "flag_madagascar", "id": "bendera_madagaskar"},
    "\U0001F1F2\U0001F1ED": {"en": "flag_marshall_islands", "id": "bendera_kepulauan_marshall"},
    "\U0001F1F2\U0001F1F0": {"en": "flag_north_macedonia", "id": "bendera_makedonia_utara"},
    "\U0001F1F2\U0001F1F1": {"en": "flag_mali", "id": "bendera_mali"},
    "\U0001F1F2\U0001F1F2": {
        "en": "flag_myanmar_(burma)",
        "id": "bendera_myanmar_(burma)",
        "alias": "bendera_myanmar_burma",
    },
    "\U0001F1F2\U0001F1F3": {"en": "flag_mongolia", "id": "bendera_mongolia"},
    "\U0001F1F2\U0001F1F4": {"en": "flag_macao_sar_china", "id": "bendera_makau_dak_tiongkok"},
    "\U0001F1F2\U0001F1F5": {
        "en": "flag_northern_mariana_islands",
        "id": "bendera_kepulauan_mariana_utara",
    },
    "\U0001F1F2\U0001F1F6": {"en": "flag_martinique", "id": "bendera_martinik"},
    "\U0001F1F2\U0001F1F7": {"en": "flag_mauritania", "id": "bendera_mauritania"},
    "\U0001F1F2\U0001F1F8": {"en": "flag_montserrat", "id": "bendera_montserrat"},
    "\U0001F1F2\U0001F1F9": {"en": "flag_malta", "id": "bendera_malta"},
    "\U0001F1F2\U0001F1FA": {"en": "flag_mauritius", "id": "bendera_mauritius"},
    "\U0001F1F2\U0001F1FB": {"en": "flag_maldives", "id": "bendera_maladewa"},
    "\U0001F1F2\U0001F1FC": {"en": "flag_malawi", "id": "bendera_malawi"},
    "\U0001F1F2\U0001F1FD": {"en": "flag_mexico", "id": "bendera_meksiko"},
    "\U0001F1F2\U0001F1FE": {"en": "flag_malaysia", "id": "bendera_malaysia"},
    "\U0001F1F2\U0001F1FF": {"en": "flag_mozambique", "id": "bendera_mozambik"},
    "\U0001F1F3\U0001F1E6": {"en": "flag_namibia", "id": "bendera_namibia"},
    "\U0001F1F3\U0001F1E8": {"en": "flag_new_caledonia", "id": "bendera_kaledonia_baru"},
    "\U0001F1F3\U0001F1EA": {"en": "flag_niger", "id": "bendera_niger"},
    "\U0001F1F3\U0001F1EB": {"en": "flag_norfolk_island", "id": "bendera_kepulauan_norfolk"},
    "\U0001F1F3\U0001F1EC": {"en": "flag_nigeria", "id": "bendera_nigeria"},
    "\U0001F1F3\U0001F1EE": {"en": "flag_nicaragua", "id": "bendera_nikaragua"},
    "\U0001F1F3\U0001F1F1": {"en": "flag_netherlands", "id": "bendera_belanda"},
    "\U0001F1F3\U0001F1F4": {"en": "flag_norway", "id": "bendera_norwegia"},
    "\U0001F1F3\U0001F1F5": {"en": "flag_nepal", "id": "bendera_nepal"},
    "\U0001F1F3\U0001F1F7": {"en": "flag_nauru", "id": "bendera_nauru"},
    "\U0001F1F3\U0001F1FA": {"en": "flag_niue", "id": "bendera_niue"},
    "\U0001F1F3\U0001F1FF": {"en": "flag_new_zealand", "id": "bendera_selandia_baru"},
    "\U0001F1F4\U0001F1F2": {"en": "flag_oman", "id": "bendera_oman"},
    "\U0001F1F5\U0001F1E6": {"en": "flag_panama", "id": "bendera_panama"},
    "\U0001F1F5\U0001F1EA": {"en": "flag_peru", "id": "bendera_peru"},
    "\U0001F1F5\U0001F1EB": {"en": "flag_french_polynesia", "id": "bendera_polinesia_prancis"},
    "\U0001F1F5\U0001F1EC": {"en": "flag_papua_new_guinea", "id": "bendera_papua_nugini"},
    "\U0001F1F5\U0001F1ED": {"en": "flag_philippines", "id": "bendera_filipina"},
    "\U0001F1F5\U0001F1F0": {"en": "flag_pakistan", "id": "bendera_pakistan"},
    "\U0001F1F5\U0001F1F1": {"en": "flag_poland", "id": "bendera_polandia"},
    "\U0001F1F5\U0001F1F2": {
        "en": "flag_st._pierre_&_miquelon",
        "id": "bendera_saint_pierre_dan_miquelon",
    },
    "\U0001F1F5\U0001F1F3": {"en": "flag_pitcairn_islands", "id": "bendera_kepulauan_pitcairn"},
    "\U0001F1F5\U0001F1F7": {"en": "flag_puerto_rico", "id": "bendera_puerto_riko"},
    "\U0001F1F5\U0001F1F8": {
        "en": "flag_palestinian_territories",
        "id": "bendera_wilayah_palestina",
    },
    "\U0001F1F5\U0001F1F9": {"en": "flag_portugal", "id": "bendera_portugal"},
    "\U0001F1F5\U0001F1FC": {"en": "flag_palau", "id": "bendera_palau"},
    "\U0001F1F5\U0001F1FE": {"en": "flag_paraguay", "id": "bendera_paraguay"},
    "\U0001F1F6\U0001F1E6": {"en": "flag_qatar", "id": "bendera_qatar"},
    "\U0001F1F7\U0001F1EA": {
        "en": "flag_reunion",
        "id": "bendera_reunion",
        "alias": "bendera_reunion_reunion",
    },
    "\U0001F1F7\U0001F1F4": {"en": "flag_romania", "id": "bendera_rumania"},
    "\U0001F1F7\U0001F1F8": {"en": "flag_serbia", "id": "bendera_serbia"},
    "\U0001F1F7\U0001F1FA": {"en": "flag_russia", "id": "bendera_rusia"},
    "\U0001F1F7\U0001F1FC": {"en": "flag_rwanda", "id": "bendera_rwanda"},
    "\U0001F1F8\U0001F1E6": {"en": "flag_saudi_arabia", "id": "bendera_arab_saudi"},
    "\U0001F1F8\U0001F1E7": {"en": "flag_solomon_islands", "id": "bendera_kepulauan_solomon"},
    "\U0001F1F8\U0001F1E8": {"en": "flag_seychelles", "id": "bendera_seychelles"},
    "\U0001F1F8\U0001F1E9": {"en": "flag_sudan", "id": "bendera_sudan"},
    "\U0001F1F8\U0001F1EA": {"en": "flag_sweden", "id": "bendera_swedia"},
    "\U0001F1F8\U0001F1EC": {"en": "flag_singapore", "id": "bendera_singapura"},
    "\U0001F1F8\U0001F1ED": {"en": "flag_st._helena", "id": "bendera_saint_helena"},
    "\U0001F1F8\U0001F1EE": {"en": "flag_slovenia", "id": "bendera_slovenia"},
    "\U0001F1F8\U0001F1EF": {
        "en": "flag_svalbard_&_jan_mayen",
        "id": "bendera_kepulauan_svalbard_dan_jan_mayen",
    },
    "\U0001F1F8\U0001F1F0": {"en": "flag_slovakia", "id": "bendera_slovakia"},
    "\U0001F1F8\U0001F1F1": {"en": "flag_sierra_leone", "id": "bendera_sierra_leone"},
    "\U0001F1F8\U0001F1F2": {"en": "flag_san_marino", "id": "bendera_san_marino"},
    "\U0001F1F8\U0001F1F3": {"en": "flag_senegal", "id": "bendera_senegal"},
    "\U0001F1F8\U0001F1F4": {"en": "flag_somalia", "id": "bendera_somalia"},
    "\U0001F1F8\U0001F1F7": {"en": "flag_suriname", "id": "bendera_suriname"},
    "\U0001F1F8\U0001F1F8": {"en": "flag_south_sudan", "id": "bendera_sudan_selatan"},
    "\U0001F1F8\U0001F1F9": {
        "en": "flag_sao_tome_&_principe",
        "id": "bendera_sao_tome_dan_principe",
    },
    "\U0001F1F8\U0001F1FB": {"en": "flag_el_salvador", "id": "bendera_el_salvador"},
    "\U0001F1F8\U0001F1FD": {"en": "flag_sint_maarten", "id": "bendera_sint_maarten"},
    "\U0001F1F8\U0001F1FE": {"en": "flag_syria", "id": "bendera_suriah"},
    "\U0001F1F8\U0001F1FF": {"en": "flag_eswatini", "id": "bendera_eswatini"},
    "\U0001F1F9\U0001F1E6": {"en": "flag_tristan_da_cunha", "id": "bendera_tristan_da_cunha"},
    "\U0001F1F9\U0001F1E8": {
        "en": "flag_turks_&_caicos_islands",
        "id": "bendera_kepulauan_turks_dan_caicos",
    },
    "\U0001F1F9\U0001F1E9": {"en": "flag_chad", "id": "bendera_chad"},
    "\U0001F1F9\U0001F1EB": {
        "en": "flag_french_southern_territories",
        "id": "bendera_wilayah_selatan_prancis",
    },
    "\U0001F1F9\U0001F1EC": {"en": "flag_togo", "id": "bendera_togo"},
    "\U0001F1F9\U0001F1ED": {"en": "flag_thailand", "id": "bendera_thailand"},
    "\U0001F1F9\U0001F1EF": {"en": "flag_tajikistan", "id": "bendera_tajikistan"},
    "\U0001F1F9\U0001F1F0": {"en": "flag_tokelau", "id": "bendera_tokelau"},
    "\U0001F1F9\U0001F1F1": {"en": "flag_timor-leste", "id": "bendera_timor_leste"},
    "\U0001F1F9\U0001F1F2": {"en": "flag_turkmenistan", "id": "bendera_turkmenistan"},
    "\U0001F1F9\U0001F1F3": {"en": "flag_tunisia", "id": "bendera_tunisia"},
    "\U0001F1F9\U0001F1F4": {"en": "flag_tonga", "id": "bendera_tonga"},
    "\U0001F1F9\U0001F1F7": {"en": "flag_turkey", "id": "bendera_turki"},
    "\U0001F1F9\U0001F1F9": {"en": "flag_trinidad_&_tobago", "id": "bendera_trinidad_dan_tobago"},
    "\U0001F1F9\U0001F1FB": {"en": "flag_tuvalu", "id": "bendera_tuvalu"},
    "\U0001F1F9\U0001F1FC": {"en": "flag_taiwan", "id": "bendera_taiwan"},
    "\U0001F1F9\U0001F1FF": {"en": "flag_tanzania", "id": "bendera_tanzania"},
    "\U0001F1FA\U0001F1E6": {"en": "flag_ukraine", "id": "bendera_ukraina"},
    "\U0001F1FA\U0001F1EC": {"en": "flag_uganda", "id": "bendera_uganda"},
    "\U0001F1FA\U0001F1F2": {
        "en": "flag_u.s._outlying_islands",
        "id": "bendera_kepulauan_terluar_as",
    },
    "\U0001F1FA\U0001F1F3": {
        "en": "flag_united_nations",
        "id": "bendera_perserikatan_bangsa-bangsa",
    },
    "\U0001F1FA\U0001F1F8": {"en": "flag_united_states", "id": "bendera_amerika_serikat"},
    "\U0001F1FA\U0001F1FE": {"en": "flag_uruguay", "id": "bendera_uruguay"},
    "\U0001F1FA\U0001F1FF": {"en": "flag_uzbekistan", "id": "bendera_uzbekistan"},
    "\U0001F1FB\U0001F1E6": {"en": "flag_vatican_city", "id": "bendera_vatikan"},
    "\U0001F1FB\U0001F1E8": {
        "en": "flag_st._vincent_&_grenadines",
        "id": "bendera_saint_vincent_dan_grenadine",
    },
    "\U0001F1FB\U0001F1EA": {"en": "flag_venezuela", "id": "bendera_venezuela"},
    "\U0001F1FB\U0001F1EC": {
        "en": "flag_british_virgin_islands",
        "id": "bendera_kepulauan_virgin_britania_raya",
    },
    "\U0001F1FB\U0001F1EE": {
        "en": "flag_u.s._virgin_islands",
        "id": "bendera_kepulauan_virgin_amerika_serikat",
    },
    "\U0001F1FB\U0001F1F3": {"en": "flag_vietnam", "id": "bendera_vietnam"},
    "\U0001F1FB\U0001F1FA": {"en": "flag_vanuatu", "id": "bendera_vanuatu"},
    "\U0001F1FC\U0001F1EB": {
        "en": "flag_wallis_&_futuna",
        "id": "bendera_kepulauan_wallis_dan_futuna",
    },
    "\U0001F1FC\U0001F1F8": {"en": "flag_samoa", "id": "bendera_samoa"},
    "\U0001F1FD\U0001F1F0": {"en": "flag_kosovo", "id": "bendera_kosovo"},
    "\U0001F1FE\U0001F1EA": {"en": "flag_yemen", "id": "bendera_yaman"},
    "\U0001F1FE\U0001F1F9": {"en": "flag_mayotte", "id": "bendera_mayotte"},
    "\U0001F1FF\U0001F1E6": {"en": "flag_south_africa", "id": "bendera_afrika_selatan"},
    "\U0001F1FF\U0001F1F2": {"en": "flag_zambia", "id": "bendera_zambia"},
    "\U0001F1FF\U0001F1FC": {"en": "flag_zimbabwe", "id": "bendera_zimbabwe"},
    "\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F": {
        "en": "flag_england",
        "id": "bendera_inggris",
    },
    "\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F": {
        "en": "flag_scotland",
        "id": "bendera_skotlandia",
    },
    "\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F": {
        "en": "flag_wales",
        "id": "bendera_wales",
    },
    "\U0001F44B\U0001F3FB": {
        "en": "waving_hand_light_skin_tone",
        "id": "tangan_melambai_warna_kulit_cerah",
        "alias": "tangan_melambai_warna_kulit_cerah_badan_lambai_tubuh",
    },
    "\U0001F44B\U0001F3FC": {
        "en": "waving_hand_medium-light_skin_tone",
        "id": "tangan_melambai_warna_kulit_cerah-sedang",
        "alias": "tangan_melambai_warna_kulit_cerah-sedang_badan_lambai_tubuh",
    },
    "\U0001F44B\U0001F3FD": {
        "en": "waving_hand_medium_skin_tone",
        "id": "tangan_melambai_warna_kulit_sedang",
        "alias": "tangan_melambai_warna_kulit_sedang_badan_lambai_tubuh",
    },
    "\U0001F44B\U0001F3FE": {
        "en": "waving_hand_medium-dark_skin_tone",
        "id": "tangan_melambai_warna_kulit_gelap-sedang",
        "alias": "tangan_melambai_warna_kulit_gelap-sedang_badan_lambai_tubuh",
    },
    "\U0001F44B\U0001F3FF": {
        "en": "waving_hand_dark_skin_tone",
        "id": "tangan_melambai_warna_kulit_gelap",
        "alias": "tangan_melambai_warna_kulit_gelap_badan_lambai_tubuh",
    },
    "\U0001F91A\U0001F3FB": {
        "en": "raised_back_of_hand_light_skin_tone",
        "id": "angkat_tangan_warna_kulit_cerah",
        "alias": "angkat_tangan_warna_kulit_cerah_berhenti_jangan_stop",
    },
    "\U0001F91A\U0001F3FC": {
        "en": "raised_back_of_hand_medium-light_skin_tone",
        "id": "angkat_tangan_warna_kulit_cerah-sedang",
        "alias": "angkat_tangan_warna_kulit_cerah-sedang_berhenti_jangan_stop",
    },
    "\U0001F91A\U0001F3FD": {
        "en": "raised_back_of_hand_medium_skin_tone",
        "id": "angkat_tangan_warna_kulit_sedang",
        "alias": "angkat_tangan_warna_kulit_sedang_berhenti_jangan_stop",
    },
    "\U0001F91A\U0001F3FE": {
        "en": "raised_back_of_hand_medium-dark_skin_tone",
        "id": "angkat_tangan_warna_kulit_gelap-sedang",
        "alias": "angkat_tangan_warna_kulit_gelap-sedang_berhenti_jangan_stop",
    },
    "\U0001F91A\U0001F3FF": {
        "en": "raised_back_of_hand_dark_skin_tone",
        "id": "angkat_tangan_warna_kulit_gelap",
        "alias": "angkat_tangan_warna_kulit_gelap_berhenti_jangan_stop",
    },
    "\U0001F590\U0001F3FB": {
        "en": "hand_with_fingers_splayed_light_skin_tone",
        "id": "telapak_tangan_terbuka_warna_kulit_cerah",
        "alias": "telapak_tangan_terbuka_warna_kulit_cerah_badan_jari_tos_tubuh",
    },
    "\U0001F590\U0001F3FC": {
        "en": "hand_with_fingers_splayed_medium-light_skin_tone",
        "id": "telapak_tangan_terbuka_warna_kulit_cerah-sedang",
        "alias": "telapak_tangan_terbuka_warna_kulit_cerah-sedang_badan_jari_tos_tubuh",
    },
    "\U0001F590\U0001F3FD": {
        "en": "hand_with_fingers_splayed_medium_skin_tone",
        "id": "telapak_tangan_terbuka_warna_kulit_sedang",
        "alias": "telapak_tangan_terbuka_warna_kulit_sedang_badan_jari_tos_tubuh",
    },
    "\U0001F590\U0001F3FE": {
        "en": "hand_with_fingers_splayed_medium-dark_skin_tone",
        "id": "telapak_tangan_terbuka_warna_kulit_gelap-sedang",
        "alias": "telapak_tangan_terbuka_warna_kulit_gelap-sedang_badan_jari_tos_tubuh",
    },
    "\U0001F590\U0001F3FF": {
        "en": "hand_with_fingers_splayed_dark_skin_tone",
        "id": "telapak_tangan_terbuka_warna_kulit_gelap",
        "alias": "telapak_tangan_terbuka_warna_kulit_gelap_badan_jari_tos_tubuh",
    },
    "\U0000270B\U0001F3FB": {
        "en": "raised_hand_light_skin_tone",
        "id": "telapak_tangan_terbuka_dengan_jari_rapat_warna_kulit_cerah",
        "alias": "telapak_tangan_terbuka_dengan_jari_rapat_warna_kulit_cerah_badan_tubuh",
    },
    "\U0000270B\U0001F3FC": {
        "en": "raised_hand_medium-light_skin_tone",
        "id": "telapak_tangan_terbuka_dengan_jari_rapat_warna_kulit_cerah-sedang",
        "alias": "telapak_tangan_terbuka_dengan_jari_rapat_warna_kulit_cerah-sedang_badan_tubuh",
    },
    "\U0000270B\U0001F3FD": {
        "en": "raised_hand_medium_skin_tone",
        "id": "telapak_tangan_terbuka_dengan_jari_rapat_warna_kulit_sedang",
        "alias": "telapak_tangan_terbuka_dengan_jari_rapat_warna_kulit_sedang_badan_tubuh",
    },
    "\U0000270B\U0001F3FE": {
        "en": "raised_hand_medium-dark_skin_tone",
        "id": "telapak_tangan_terbuka_dengan_jari_rapat_warna_kulit_gelap-sedang",
        "alias": "telapak_tangan_terbuka_dengan_jari_rapat_warna_kulit_gelap-sedang_badan_tubuh",
    },
    "\U0000270B\U0001F3FF": {
        "en": "raised_hand_dark_skin_tone",
        "id": "telapak_tangan_terbuka_dengan_jari_rapat_warna_kulit_gelap",
        "alias": "telapak_tangan_terbuka_dengan_jari_rapat_warna_kulit_gelap_badan_tubuh",
    },
    "\U0001F596\U0001F3FB": {
        "en": "vulcan_salute_light_skin_tone",
        "id": "salam_vulcan_warna_kulit_cerah",
        "alias": "salam_vulcan_warna_kulit_cerah_badan_jari_spock_tangan_tubuh",
    },
    "\U0001F596\U0001F3FC": {
        "en": "vulcan_salute_medium-light_skin_tone",
        "id": "salam_vulcan_warna_kulit_cerah-sedang",
        "alias": "salam_vulcan_warna_kulit_cerah-sedang_badan_jari_spock_tangan_tubuh",
    },
    "\U0001F596\U0001F3FD": {
        "en": "vulcan_salute_medium_skin_tone",
        "id": "salam_vulcan_warna_kulit_sedang",
        "alias": "salam_vulcan_warna_kulit_sedang_badan_jari_spock_tangan_tubuh",
    },
    "\U0001F596\U0001F3FE": {
        "en": "vulcan_salute_medium-dark_skin_tone",
        "id": "salam_vulcan_warna_kulit_gelap-sedang",
        "alias": "salam_vulcan_warna_kulit_gelap-sedang_badan_jari_spock_tangan_tubuh",
    },
    "\U0001F596\U0001F3FF": {
        "en": "vulcan_salute_dark_skin_tone",
        "id": "salam_vulcan_warna_kulit_gelap",
        "alias": "salam_vulcan_warna_kulit_gelap_badan_jari_spock_tangan_tubuh",
    },
    "\U0001F44C\U0001F3FB": {
        "en": "ok_hand_light_skin_tone",
        "id": "oke_warna_kulit_cerah",
        "alias": "oke_warna_kulit_cerah_badan_tangan_tubuh",
    },
    "\U0001F44C\U0001F3FC": {
        "en": "ok_hand_medium-light_skin_tone",
        "id": "oke_warna_kulit_cerah-sedang",
        "alias": "oke_warna_kulit_cerah-sedang_badan_tangan_tubuh",
    },
    "\U0001F44C\U0001F3FD": {
        "en": "ok_hand_medium_skin_tone",
        "id": "oke_warna_kulit_sedang",
        "alias": "oke_warna_kulit_sedang_badan_tangan_tubuh",
    },
    "\U0001F44C\U0001F3FE": {
        "en": "ok_hand_medium-dark_skin_tone",
        "id": "oke_warna_kulit_gelap-sedang",
        "alias": "oke_warna_kulit_gelap-sedang_badan_tangan_tubuh",
    },
    "\U0001F44C\U0001F3FF": {
        "en": "ok_hand_dark_skin_tone",
        "id": "oke_warna_kulit_gelap",
        "alias": "oke_warna_kulit_gelap_badan_tangan_tubuh",
    },
    "\U0001F90C\U0001F3FB": {
        "en": "pinched_fingers_light_skin_tone",
        "id": "jari_terkuncup_warna_kulit_cerah",
        "alias": "jari_terkuncup_warna_kulit_cerah_interogasi_isyarat_tangan_sarkastik",
    },
    "\U0001F90C\U0001F3FC": {
        "en": "pinched_fingers_medium-light_skin_tone",
        "id": "jari_terkuncup_warna_kulit_cerah-sedang",
        "alias": "jari_terkuncup_warna_kulit_cerah-sedang_interogasi_isyarat_tangan_sarkastik",
    },
    "\U0001F90C\U0001F3FD": {
        "en": "pinched_fingers_medium_skin_tone",
        "id": "jari_terkuncup_warna_kulit_sedang",
        "alias": "jari_terkuncup_warna_kulit_sedang_interogasi_isyarat_tangan_sarkastik",
    },
    "\U0001F90C\U0001F3FE": {
        "en": "pinched_fingers_medium-dark_skin_tone",
        "id": "jari_terkuncup_warna_kulit_gelap-sedang",
        "alias": "jari_terkuncup_warna_kulit_gelap-sedang_interogasi_isyarat_tangan_sarkastik",
    },
    "\U0001F90C\U0001F3FF": {
        "en": "pinched_fingers_dark_skin_tone",
        "id": "jari_terkuncup_warna_kulit_gelap",
        "alias": "jari_terkuncup_warna_kulit_gelap_interogasi_isyarat_tangan_sarkastik",
    },
    "\U0001F90F\U0001F3FB": {
        "en": "pinching_hand_light_skin_tone",
        "id": "tangan_menjepit_warna_kulit_cerah",
        "alias": "tangan_menjepit_warna_kulit_cerah_sejumlah_kecil",
    },
    "\U0001F90F\U0001F3FC": {
        "en": "pinching_hand_medium-light_skin_tone",
        "id": "tangan_menjepit_warna_kulit_cerah-sedang",
        "alias": "tangan_menjepit_warna_kulit_cerah-sedang_sejumlah_kecil",
    },
    "\U0001F90F\U0001F3FD": {
        "en": "pinching_hand_medium_skin_tone",
        "id": "tangan_menjepit_warna_kulit_sedang",
        "alias": "tangan_menjepit_warna_kulit_sedang_sejumlah_kecil",
    },
    "\U0001F90F\U0001F3FE": {
        "en": "pinching_hand_medium-dark_skin_tone",
        "id": "tangan_menjepit_warna_kulit_gelap-sedang",
        "alias": "tangan_menjepit_warna_kulit_gelap-sedang_sejumlah_kecil",
    },
    "\U0001F90F\U0001F3FF": {
        "en": "pinching_hand_dark_skin_tone",
        "id": "tangan_menjepit_warna_kulit_gelap",
        "alias": "tangan_menjepit_warna_kulit_gelap_sejumlah_kecil",
    },
    "\U0000270C\U0001F3FB": {
        "en": "victory_hand_light_skin_tone",
        "id": "isyarat_kemenangan_warna_kulit_cerah",
        "alias": "isyarat_kemenangan_warna_kulit_cerah_badan_jari_menang_tangan_tubuh",
    },
    "\U0000270C\U0001F3FC": {
        "en": "victory_hand_medium-light_skin_tone",
        "id": "isyarat_kemenangan_warna_kulit_cerah-sedang",
        "alias": "isyarat_kemenangan_warna_kulit_cerah-sedang_badan_jari_menang_tangan_tubuh",
    },
    "\U0000270C\U0001F3FD": {
        "en": "victory_hand_medium_skin_tone",
        "id": "isyarat_kemenangan_warna_kulit_sedang",
        "alias": "isyarat_kemenangan_warna_kulit_sedang_badan_jari_menang_tangan_tubuh",
    },
    "\U0000270C\U0001F3FE": {
        "en": "victory_hand_medium-dark_skin_tone",
        "id": "isyarat_kemenangan_warna_kulit_gelap-sedang",
        "alias": "isyarat_kemenangan_warna_kulit_gelap-sedang_badan_jari_menang_tangan_tubuh",
    },
    "\U0000270C\U0001F3FF": {
        "en": "victory_hand_dark_skin_tone",
        "id": "isyarat_kemenangan_warna_kulit_gelap",
        "alias": "isyarat_kemenangan_warna_kulit_gelap_badan_jari_menang_tangan_tubuh",
    },
    "\U0001F91E\U0001F3FB": {
        "en": "crossed_fingers_light_skin_tone",
        "id": "jari_menyilang_warna_kulit_cerah",
        "alias": "jari_menyilang_warna_kulit_cerah_beruntung_semoga_hoki_silang",
    },
    "\U0001F91E\U0001F3FC": {
        "en": "crossed_fingers_medium-light_skin_tone",
        "id": "jari_menyilang_warna_kulit_cerah-sedang",
        "alias": "jari_menyilang_warna_kulit_cerah-sedang_beruntung_semoga_hoki_silang",
    },
    "\U0001F91E\U0001F3FD": {
        "en": "crossed_fingers_medium_skin_tone",
        "id": "jari_menyilang_warna_kulit_sedang",
        "alias": "jari_menyilang_warna_kulit_sedang_beruntung_semoga_hoki_silang",
    },
    "\U0001F91E\U0001F3FE": {
        "en": "crossed_fingers_medium-dark_skin_tone",
        "id": "jari_menyilang_warna_kulit_gelap-sedang",
        "alias": "jari_menyilang_warna_kulit_gelap-sedang_beruntung_semoga_hoki_silang",
    },
    "\U0001F91E\U0001F3FF": {
        "en": "crossed_fingers_dark_skin_tone",
        "id": "jari_menyilang_warna_kulit_gelap",
        "alias": "jari_menyilang_warna_kulit_gelap_beruntung_semoga_hoki_silang",
    },
    "\U0001F91F\U0001F3FB": {
        "en": "love-you_gesture_light_skin_tone",
        "id": "gerakan_sayang_kamu_warna_kulit_cerah",
        "alias": "gerakan_sayang_kamu_warna_kulit_cerah_ilu_ily_tangan",
    },
    "\U0001F91F\U0001F3FC": {
        "en": "love-you_gesture_medium-light_skin_tone",
        "id": "gerakan_sayang_kamu_warna_kulit_cerah-sedang",
        "alias": "gerakan_sayang_kamu_warna_kulit_cerah-sedang_ilu_ily_tangan",
    },
    "\U0001F91F\U0001F3FD": {
        "en": "love-you_gesture_medium_skin_tone",
        "id": "gerakan_sayang_kamu_warna_kulit_sedang",
        "alias": "gerakan_sayang_kamu_warna_kulit_sedang_ilu_ily_tangan",
    },
    "\U0001F91F\U0001F3FE": {
        "en": "love-you_gesture_medium-dark_skin_tone",
        "id": "gerakan_sayang_kamu_warna_kulit_gelap-sedang",
        "alias": "gerakan_sayang_kamu_warna_kulit_gelap-sedang_ilu_ily_tangan",
    },
    "\U0001F91F\U0001F3FF": {
        "en": "love-you_gesture_dark_skin_tone",
        "id": "gerakan_sayang_kamu_warna_kulit_gelap",
        "alias": "gerakan_sayang_kamu_warna_kulit_gelap_ilu_ily_tangan",
    },
    "\U0001F918\U0001F3FB": {
        "en": "sign_of_the_horns_light_skin_tone",
        "id": "lambang_tanduk_warna_kulit_cerah",
        "alias": "lambang_tanduk_warna_kulit_cerah_badan_jari_tangan_tubuh",
    },
    "\U0001F918\U0001F3FC": {
        "en": "sign_of_the_horns_medium-light_skin_tone",
        "id": "lambang_tanduk_warna_kulit_cerah-sedang",
        "alias": "lambang_tanduk_warna_kulit_cerah-sedang_badan_jari_tangan_tubuh",
    },
    "\U0001F918\U0001F3FD": {
        "en": "sign_of_the_horns_medium_skin_tone",
        "id": "lambang_tanduk_warna_kulit_sedang",
        "alias": "lambang_tanduk_warna_kulit_sedang_badan_jari_tangan_tubuh",
    },
    "\U0001F918\U0001F3FE": {
        "en": "sign_of_the_horns_medium-dark_skin_tone",
        "id": "lambang_tanduk_warna_kulit_gelap-sedang",
        "alias": "lambang_tanduk_warna_kulit_gelap-sedang_badan_jari_tangan_tubuh",
    },
    "\U0001F918\U0001F3FF": {
        "en": "sign_of_the_horns_dark_skin_tone",
        "id": "lambang_tanduk_warna_kulit_gelap",
        "alias": "lambang_tanduk_warna_kulit_gelap_badan_jari_tangan_tubuh",
    },
    "\U0001F919\U0001F3FB": {
        "en": "call_me_hand_light_skin_tone",
        "id": "panggil_saya_warna_kulit_cerah",
        "alias": "panggil_saya_warna_kulit_cerah_telepon_aku",
    },
    "\U0001F919\U0001F3FC": {
        "en": "call_me_hand_medium-light_skin_tone",
        "id": "panggil_saya_warna_kulit_cerah-sedang",
        "alias": "panggil_saya_warna_kulit_cerah-sedang_telepon_aku",
    },
    "\U0001F919\U0001F3FD": {
        "en": "call_me_hand_medium_skin_tone",
        "id": "panggil_saya_warna_kulit_sedang",
        "alias": "panggil_saya_warna_kulit_sedang_telepon_aku",
    },
    "\U0001F919\U0001F3FE": {
        "en": "call_me_hand_medium-dark_skin_tone",
        "id": "panggil_saya_warna_kulit_gelap-sedang",
        "alias": "panggil_saya_warna_kulit_gelap-sedang_telepon_aku",
    },
    "\U0001F919\U0001F3FF": {
        "en": "call_me_hand_dark_skin_tone",
        "id": "panggil_saya_warna_kulit_gelap",
        "alias": "panggil_saya_warna_kulit_gelap_telepon_aku",
    },
    "\U0001F448\U0001F3FB": {
        "en": "backhand_index_pointing_left_light_skin_tone",
        "id": "menunjuk_ke_arah_kiri_warna_kulit_cerah",
        "alias": "menunjuk_ke_arah_kiri_warna_kulit_cerah_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F448\U0001F3FC": {
        "en": "backhand_index_pointing_left_medium-light_skin_tone",
        "id": "menunjuk_ke_arah_kiri_warna_kulit_cerah-sedang",
        "alias": "menunjuk_ke_arah_kiri_warna_kulit_cerah-sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F448\U0001F3FD": {
        "en": "backhand_index_pointing_left_medium_skin_tone",
        "id": "menunjuk_ke_arah_kiri_warna_kulit_sedang",
        "alias": "menunjuk_ke_arah_kiri_warna_kulit_sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F448\U0001F3FE": {
        "en": "backhand_index_pointing_left_medium-dark_skin_tone",
        "id": "menunjuk_ke_arah_kiri_warna_kulit_gelap-sedang",
        "alias": "menunjuk_ke_arah_kiri_warna_kulit_gelap-sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F448\U0001F3FF": {
        "en": "backhand_index_pointing_left_dark_skin_tone",
        "id": "menunjuk_ke_arah_kiri_warna_kulit_gelap",
        "alias": "menunjuk_ke_arah_kiri_warna_kulit_gelap_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F449\U0001F3FB": {
        "en": "backhand_index_pointing_right_light_skin_tone",
        "id": "menunjuk_ke_arah_kanan_warna_kulit_cerah",
        "alias": "menunjuk_ke_arah_kanan_warna_kulit_cerah_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F449\U0001F3FC": {
        "en": "backhand_index_pointing_right_medium-light_skin_tone",
        "id": "menunjuk_ke_arah_kanan_warna_kulit_cerah-sedang",
        "alias": "menunjuk_ke_arah_kanan_warna_kulit_cerah-sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F449\U0001F3FD": {
        "en": "backhand_index_pointing_right_medium_skin_tone",
        "id": "menunjuk_ke_arah_kanan_warna_kulit_sedang",
        "alias": "menunjuk_ke_arah_kanan_warna_kulit_sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F449\U0001F3FE": {
        "en": "backhand_index_pointing_right_medium-dark_skin_tone",
        "id": "menunjuk_ke_arah_kanan_warna_kulit_gelap-sedang",
        "alias": "menunjuk_ke_arah_kanan_warna_kulit_gelap-sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F449\U0001F3FF": {
        "en": "backhand_index_pointing_right_dark_skin_tone",
        "id": "menunjuk_ke_arah_kanan_warna_kulit_gelap",
        "alias": "menunjuk_ke_arah_kanan_warna_kulit_gelap_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F446\U0001F3FB": {
        "en": "backhand_index_pointing_up_light_skin_tone",
        "id": "menunjuk_ke_atas_(dibalik)_warna_kulit_cerah",
        "alias": "menunjuk_ke_atas_dibalik_warna_kulit_cerah_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F446\U0001F3FC": {
        "en": "backhand_index_pointing_up_medium-light_skin_tone",
        "id": "menunjuk_ke_atas_(dibalik)_warna_kulit_cerah-sedang",
        "alias": "menunjuk_ke_atas_dibalik_warna_kulit_cerah-sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F446\U0001F3FD": {
        "en": "backhand_index_pointing_up_medium_skin_tone",
        "id": "menunjuk_ke_atas_(dibalik)_warna_kulit_sedang",
        "alias": "menunjuk_ke_atas_dibalik_warna_kulit_sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F446\U0001F3FE": {
        "en": "backhand_index_pointing_up_medium-dark_skin_tone",
        "id": "menunjuk_ke_atas_(dibalik)_warna_kulit_gelap-sedang",
        "alias": "menunjuk_ke_atas_dibalik_warna_kulit_gelap-sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F446\U0001F3FF": {
        "en": "backhand_index_pointing_up_dark_skin_tone",
        "id": "menunjuk_ke_atas_(dibalik)_warna_kulit_gelap",
        "alias": "menunjuk_ke_atas_dibalik_warna_kulit_gelap_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F595\U0001F3FB": {
        "en": "middle_finger_light_skin_tone",
        "id": "jari_tengah_warna_kulit_cerah",
        "alias": "jari_tengah_warna_kulit_cerah_tangan",
    },
    "\U0001F595\U0001F3FC": {
        "en": "middle_finger_medium-light_skin_tone",
        "id": "jari_tengah_warna_kulit_cerah-sedang",
        "alias": "jari_tengah_warna_kulit_cerah-sedang_tangan",
    },
    "\U0001F595\U0001F3FD": {
        "en": "middle_finger_medium_skin_tone",
        "id": "jari_tengah_warna_kulit_sedang",
        "alias": "jari_tengah_warna_kulit_sedang_tangan",
    },
    "\U0001F595\U0001F3FE": {
        "en": "middle_finger_medium-dark_skin_tone",
        "id": "jari_tengah_warna_kulit_gelap-sedang",
        "alias": "jari_tengah_warna_kulit_gelap-sedang_tangan",
    },
    "\U0001F595\U0001F3FF": {
        "en": "middle_finger_dark_skin_tone",
        "id": "jari_tengah_warna_kulit_gelap",
        "alias": "jari_tengah_warna_kulit_gelap_tangan",
    },
    "\U0001F447\U0001F3FB": {
        "en": "backhand_index_pointing_down_light_skin_tone",
        "id": "menunjuk_ke_bawah_warna_kulit_cerah",
        "alias": "menunjuk_ke_bawah_warna_kulit_cerah_badan_jari_tangan_tengah_tubuh_tunjuk",
    },
    "\U0001F447\U0001F3FC": {
        "en": "backhand_index_pointing_down_medium-light_skin_tone",
        "id": "menunjuk_ke_bawah_warna_kulit_cerah-sedang",
        "alias": "menunjuk_ke_bawah_warna_kulit_cerah-sedang_badan_jari_tangan_tengah_tubuh_tunjuk",
    },
    "\U0001F447\U0001F3FD": {
        "en": "backhand_index_pointing_down_medium_skin_tone",
        "id": "menunjuk_ke_bawah_warna_kulit_sedang",
        "alias": "menunjuk_ke_bawah_warna_kulit_sedang_badan_jari_tangan_tengah_tubuh_tunjuk",
    },
    "\U0001F447\U0001F3FE": {
        "en": "backhand_index_pointing_down_medium-dark_skin_tone",
        "id": "menunjuk_ke_bawah_warna_kulit_gelap-sedang",
        "alias": "menunjuk_ke_bawah_warna_kulit_gelap-sedang_badan_jari_tangan_tengah_tubuh_tunjuk",
    },
    "\U0001F447\U0001F3FF": {
        "en": "backhand_index_pointing_down_dark_skin_tone",
        "id": "menunjuk_ke_bawah_warna_kulit_gelap",
        "alias": "menunjuk_ke_bawah_warna_kulit_gelap_badan_jari_tangan_tengah_tubuh_tunjuk",
    },
    "\U0000261D\U0001F3FB": {
        "en": "index_pointing_up_light_skin_tone",
        "id": "menunjuk_ke_atas_warna_kulit_cerah",
        "alias": "menunjuk_ke_atas_warna_kulit_cerah_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0000261D\U0001F3FC": {
        "en": "index_pointing_up_medium-light_skin_tone",
        "id": "menunjuk_ke_atas_warna_kulit_cerah-sedang",
        "alias": "menunjuk_ke_atas_warna_kulit_cerah-sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0000261D\U0001F3FD": {
        "en": "index_pointing_up_medium_skin_tone",
        "id": "menunjuk_ke_atas_warna_kulit_sedang",
        "alias": "menunjuk_ke_atas_warna_kulit_sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0000261D\U0001F3FE": {
        "en": "index_pointing_up_medium-dark_skin_tone",
        "id": "menunjuk_ke_atas_warna_kulit_gelap-sedang",
        "alias": "menunjuk_ke_atas_warna_kulit_gelap-sedang_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0000261D\U0001F3FF": {
        "en": "index_pointing_up_dark_skin_tone",
        "id": "menunjuk_ke_atas_warna_kulit_gelap",
        "alias": "menunjuk_ke_atas_warna_kulit_gelap_badan_jari_tangan_telunjuk_tubuh_tunjuk",
    },
    "\U0001F44D\U0001F3FB": {
        "en": "thumbs_up_light_skin_tone",
        "id": "jempol_ke_atas_warna_kulit_cerah",
        "alias": "jempol_ke_atas_warna_kulit_cerah_+1_badan_tangan_tubuh",
    },
    "\U0001F44D\U0001F3FC": {
        "en": "thumbs_up_medium-light_skin_tone",
        "id": "jempol_ke_atas_warna_kulit_cerah-sedang",
        "alias": "jempol_ke_atas_warna_kulit_cerah-sedang_+1_badan_tangan_tubuh",
    },
    "\U0001F44D\U0001F3FD": {
        "en": "thumbs_up_medium_skin_tone",
        "id": "jempol_ke_atas_warna_kulit_sedang",
        "alias": "jempol_ke_atas_warna_kulit_sedang_+1_badan_tangan_tubuh",
    },
    "\U0001F44D\U0001F3FE": {
        "en": "thumbs_up_medium-dark_skin_tone",
        "id": "jempol_ke_atas_warna_kulit_gelap-sedang",
        "alias": "jempol_ke_atas_warna_kulit_gelap-sedang_+1_badan_tangan_tubuh",
    },
    "\U0001F44D\U0001F3FF": {
        "en": "thumbs_up_dark_skin_tone",
        "id": "jempol_ke_atas_warna_kulit_gelap",
        "alias": "jempol_ke_atas_warna_kulit_gelap_+1_badan_tangan_tubuh",
    },
    "\U0001F44E\U0001F3FB": {
        "en": "thumbs_down_light_skin_tone",
        "id": "jempol_ke_bawah_warna_kulit_cerah",
        "alias": "jempol_ke_bawah_warna_kulit_cerah_-1_badan_tangan_tubuh",
    },
    "\U0001F44E\U0001F3FC": {
        "en": "thumbs_down_medium-light_skin_tone",
        "id": "jempol_ke_bawah_warna_kulit_cerah-sedang",
        "alias": "jempol_ke_bawah_warna_kulit_cerah-sedang_-1_badan_tangan_tubuh",
    },
    "\U0001F44E\U0001F3FD": {
        "en": "thumbs_down_medium_skin_tone",
        "id": "jempol_ke_bawah_warna_kulit_sedang",
        "alias": "jempol_ke_bawah_warna_kulit_sedang_-1_badan_tangan_tubuh",
    },
    "\U0001F44E\U0001F3FE": {
        "en": "thumbs_down_medium-dark_skin_tone",
        "id": "jempol_ke_bawah_warna_kulit_gelap-sedang",
        "alias": "jempol_ke_bawah_warna_kulit_gelap-sedang_-1_badan_tangan_tubuh",
    },
    "\U0001F44E\U0001F3FF": {
        "en": "thumbs_down_dark_skin_tone",
        "id": "jempol_ke_bawah_warna_kulit_gelap",
        "alias": "jempol_ke_bawah_warna_kulit_gelap_-1_badan_tangan_tubuh",
    },
    "\U0000270A\U0001F3FB": {
        "en": "raised_fist_light_skin_tone",
        "id": "tangan_terkepal_ke_atas_warna_kulit_cerah",
        "alias": "tangan_terkepal_ke_atas_warna_kulit_cerah_badan_kepal_tinju_tubuh",
    },
    "\U0000270A\U0001F3FC": {
        "en": "raised_fist_medium-light_skin_tone",
        "id": "tangan_terkepal_ke_atas_warna_kulit_cerah-sedang",
        "alias": "tangan_terkepal_ke_atas_warna_kulit_cerah-sedang_badan_kepal_tinju_tubuh",
    },
    "\U0000270A\U0001F3FD": {
        "en": "raised_fist_medium_skin_tone",
        "id": "tangan_terkepal_ke_atas_warna_kulit_sedang",
        "alias": "tangan_terkepal_ke_atas_warna_kulit_sedang_badan_kepal_tinju_tubuh",
    },
    "\U0000270A\U0001F3FE": {
        "en": "raised_fist_medium-dark_skin_tone",
        "id": "tangan_terkepal_ke_atas_warna_kulit_gelap-sedang",
        "alias": "tangan_terkepal_ke_atas_warna_kulit_gelap-sedang_badan_kepal_tinju_tubuh",
    },
    "\U0000270A\U0001F3FF": {
        "en": "raised_fist_dark_skin_tone",
        "id": "tangan_terkepal_ke_atas_warna_kulit_gelap",
        "alias": "tangan_terkepal_ke_atas_warna_kulit_gelap_badan_kepal_tinju_tubuh",
    },
    "\U0001F44A\U0001F3FB": {
        "en": "oncoming_fist_light_skin_tone",
        "id": "tangan_terkepal_ke_depan_warna_kulit_cerah",
        "alias": "tangan_terkepal_ke_depan_warna_kulit_cerah_badan_kepal_tinju_tonjok_tubuh",
    },
    "\U0001F44A\U0001F3FC": {
        "en": "oncoming_fist_medium-light_skin_tone",
        "id": "tangan_terkepal_ke_depan_warna_kulit_cerah-sedang",
        "alias": "tangan_terkepal_ke_depan_warna_kulit_cerah-sedang_badan_kepal_tinju_tonjok_tubuh",
    },
    "\U0001F44A\U0001F3FD": {
        "en": "oncoming_fist_medium_skin_tone",
        "id": "tangan_terkepal_ke_depan_warna_kulit_sedang",
        "alias": "tangan_terkepal_ke_depan_warna_kulit_sedang_badan_kepal_tinju_tonjok_tubuh",
    },
    "\U0001F44A\U0001F3FE": {
        "en": "oncoming_fist_medium-dark_skin_tone",
        "id": "tangan_terkepal_ke_depan_warna_kulit_gelap-sedang",
        "alias": "tangan_terkepal_ke_depan_warna_kulit_gelap-sedang_badan_kepal_tinju_tonjok_tubuh",
    },
    "\U0001F44A\U0001F3FF": {
        "en": "oncoming_fist_dark_skin_tone",
        "id": "tangan_terkepal_ke_depan_warna_kulit_gelap",
        "alias": "tangan_terkepal_ke_depan_warna_kulit_gelap_badan_kepal_tinju_tonjok_tubuh",
    },
    "\U0001F91B\U0001F3FB": {
        "en": "left-facing_fist_light_skin_tone",
        "id": "tinju_kiri_warna_kulit_cerah",
        "alias": "tinju_kiri_warna_kulit_cerah_kepalan_tangan_tonjok",
    },
    "\U0001F91B\U0001F3FC": {
        "en": "left-facing_fist_medium-light_skin_tone",
        "id": "tinju_kiri_warna_kulit_cerah-sedang",
        "alias": "tinju_kiri_warna_kulit_cerah-sedang_kepalan_tangan_tonjok",
    },
    "\U0001F91B\U0001F3FD": {
        "en": "left-facing_fist_medium_skin_tone",
        "id": "tinju_kiri_warna_kulit_sedang",
        "alias": "tinju_kiri_warna_kulit_sedang_kepalan_tangan_tonjok",
    },
    "\U0001F91B\U0001F3FE": {
        "en": "left-facing_fist_medium-dark_skin_tone",
        "id": "tinju_kiri_warna_kulit_gelap-sedang",
        "alias": "tinju_kiri_warna_kulit_gelap-sedang_kepalan_tangan_tonjok",
    },
    "\U0001F91B\U0001F3FF": {
        "en": "left-facing_fist_dark_skin_tone",
        "id": "tinju_kiri_warna_kulit_gelap",
        "alias": "tinju_kiri_warna_kulit_gelap_kepalan_tangan_tonjok",
    },
    "\U0001F91C\U0001F3FB": {
        "en": "right-facing_fist_light_skin_tone",
        "id": "tinju_kanan_warna_kulit_cerah",
        "alias": "tinju_kanan_warna_kulit_cerah_kepalan_tangan_tonjok",
    },
    "\U0001F91C\U0001F3FC": {
        "en": "right-facing_fist_medium-light_skin_tone",
        "id": "tinju_kanan_warna_kulit_cerah-sedang",
        "alias": "tinju_kanan_warna_kulit_cerah-sedang_kepalan_tangan_tonjok",
    },
    "\U0001F91C\U0001F3FD": {
        "en": "right-facing_fist_medium_skin_tone",
        "id": "tinju_kanan_warna_kulit_sedang",
        "alias": "tinju_kanan_warna_kulit_sedang_kepalan_tangan_tonjok",
    },
    "\U0001F91C\U0001F3FE": {
        "en": "right-facing_fist_medium-dark_skin_tone",
        "id": "tinju_kanan_warna_kulit_gelap-sedang",
        "alias": "tinju_kanan_warna_kulit_gelap-sedang_kepalan_tangan_tonjok",
    },
    "\U0001F91C\U0001F3FF": {
        "en": "right-facing_fist_dark_skin_tone",
        "id": "tinju_kanan_warna_kulit_gelap",
        "alias": "tinju_kanan_warna_kulit_gelap_kepalan_tangan_tonjok",
    },
    "\U0001F44F\U0001F3FB": {
        "en": "clapping_hands_light_skin_tone",
        "id": "tepuk_tangan_warna_kulit_cerah",
        "alias": "tepuk_tangan_warna_kulit_cerah_badan_tubuh",
    },
    "\U0001F44F\U0001F3FC": {
        "en": "clapping_hands_medium-light_skin_tone",
        "id": "tepuk_tangan_warna_kulit_cerah-sedang",
        "alias": "tepuk_tangan_warna_kulit_cerah-sedang_badan_tubuh",
    },
    "\U0001F44F\U0001F3FD": {
        "en": "clapping_hands_medium_skin_tone",
        "id": "tepuk_tangan_warna_kulit_sedang",
        "alias": "tepuk_tangan_warna_kulit_sedang_badan_tubuh",
    },
    "\U0001F44F\U0001F3FE": {
        "en": "clapping_hands_medium-dark_skin_tone",
        "id": "tepuk_tangan_warna_kulit_gelap-sedang",
        "alias": "tepuk_tangan_warna_kulit_gelap-sedang_badan_tubuh",
    },
    "\U0001F44F\U0001F3FF": {
        "en": "clapping_hands_dark_skin_tone",
        "id": "tepuk_tangan_warna_kulit_gelap",
        "alias": "tepuk_tangan_warna_kulit_gelap_badan_tubuh",
    },
    "\U0001F64C\U0001F3FB": {
        "en": "raising_hands_light_skin_tone",
        "id": "mengangkat_tangan_warna_kulit_cerah",
        "alias": "mengangkat_tangan_warna_kulit_cerah_angkat_gerakan_hore_perayaan",
    },
    "\U0001F64C\U0001F3FC": {
        "en": "raising_hands_medium-light_skin_tone",
        "id": "mengangkat_tangan_warna_kulit_cerah-sedang",
        "alias": "mengangkat_tangan_warna_kulit_cerah-sedang_angkat_gerakan_hore_perayaan",
    },
    "\U0001F64C\U0001F3FD": {
        "en": "raising_hands_medium_skin_tone",
        "id": "mengangkat_tangan_warna_kulit_sedang",
        "alias": "mengangkat_tangan_warna_kulit_sedang_angkat_gerakan_hore_perayaan",
    },
    "\U0001F64C\U0001F3FE": {
        "en": "raising_hands_medium-dark_skin_tone",
        "id": "mengangkat_tangan_warna_kulit_gelap-sedang",
        "alias": "mengangkat_tangan_warna_kulit_gelap-sedang_angkat_gerakan_hore_perayaan",
    },
    "\U0001F64C\U0001F3FF": {
        "en": "raising_hands_dark_skin_tone",
        "id": "mengangkat_tangan_warna_kulit_gelap",
        "alias": "mengangkat_tangan_warna_kulit_gelap_angkat_gerakan_hore_perayaan",
    },
    "\U0001F450\U0001F3FB": {
        "en": "open_hands_light_skin_tone",
        "id": "tangan_terbuka_warna_kulit_cerah",
        "alias": "tangan_terbuka_warna_kulit_cerah_badan_tubuh",
    },
    "\U0001F450\U0001F3FC": {
        "en": "open_hands_medium-light_skin_tone",
        "id": "tangan_terbuka_warna_kulit_cerah-sedang",
        "alias": "tangan_terbuka_warna_kulit_cerah-sedang_badan_tubuh",
    },
    "\U0001F450\U0001F3FD": {
        "en": "open_hands_medium_skin_tone",
        "id": "tangan_terbuka_warna_kulit_sedang",
        "alias": "tangan_terbuka_warna_kulit_sedang_badan_tubuh",
    },
    "\U0001F450\U0001F3FE": {
        "en": "open_hands_medium-dark_skin_tone",
        "id": "tangan_terbuka_warna_kulit_gelap-sedang",
        "alias": "tangan_terbuka_warna_kulit_gelap-sedang_badan_tubuh",
    },
    "\U0001F450\U0001F3FF": {
        "en": "open_hands_dark_skin_tone",
        "id": "tangan_terbuka_warna_kulit_gelap",
        "alias": "tangan_terbuka_warna_kulit_gelap_badan_tubuh",
    },
    "\U0001F932\U0001F3FB": {
        "en": "palms_up_together_light_skin_tone",
        "id": "tangan_diangkat_dan_dirapatkan_bersama_warna_kulit_cerah",
        "alias": "tangan_diangkat_dan_dirapatkan_bersama_warna_kulit_cerah_berdoa_doa",
    },
    "\U0001F932\U0001F3FC": {
        "en": "palms_up_together_medium-light_skin_tone",
        "id": "tangan_diangkat_dan_dirapatkan_bersama_warna_kulit_cerah-sedang",
        "alias": "tangan_diangkat_dan_dirapatkan_bersama_warna_kulit_cerah-sedang_berdoa_doa",
    },
    "\U0001F932\U0001F3FD": {
        "en": "palms_up_together_medium_skin_tone",
        "id": "tangan_diangkat_dan_dirapatkan_bersama_warna_kulit_sedang",
        "alias": "tangan_diangkat_dan_dirapatkan_bersama_warna_kulit_sedang_berdoa_doa",
    },
    "\U0001F932\U0001F3FE": {
        "en": "palms_up_together_medium-dark_skin_tone",
        "id": "tangan_diangkat_dan_dirapatkan_bersama_warna_kulit_gelap-sedang",
        "alias": "tangan_diangkat_dan_dirapatkan_bersama_warna_kulit_gelap-sedang_berdoa_doa",
    },
    "\U0001F932\U0001F3FF": {
        "en": "palms_up_together_dark_skin_tone",
        "id": "tangan_diangkat_dan_dirapatkan_bersama_warna_kulit_gelap",
        "alias": "tangan_diangkat_dan_dirapatkan_bersama_warna_kulit_gelap_berdoa_doa",
    },
    "\U0001F64F\U0001F3FB": {
        "en": "folded_hands_light_skin_tone",
        "id": "melipat_tangan_warna_kulit_cerah",
        "alias": "melipat_tangan_warna_kulit_cerah_berdoa_bungkuk_gerakan_lipat_makasih_mohon_tolong_tubuh",
    },
    "\U0001F64F\U0001F3FC": {
        "en": "folded_hands_medium-light_skin_tone",
        "id": "melipat_tangan_warna_kulit_cerah-sedang",
        "alias": "melipat_tangan_warna_kulit_cerah-sedang_berdoa_bungkuk_gerakan_lipat_makasih_mohon_tolong_tubuh",
    },
    "\U0001F64F\U0001F3FD": {
        "en": "folded_hands_medium_skin_tone",
        "id": "melipat_tangan_warna_kulit_sedang",
        "alias": "melipat_tangan_warna_kulit_sedang_berdoa_bungkuk_gerakan_lipat_makasih_mohon_tolong_tubuh",
    },
    "\U0001F64F\U0001F3FE": {
        "en": "folded_hands_medium-dark_skin_tone",
        "id": "melipat_tangan_warna_kulit_gelap-sedang",
        "alias": "melipat_tangan_warna_kulit_gelap-sedang_berdoa_bungkuk_gerakan_lipat_makasih_mohon_tolong_tubuh",
    },
    "\U0001F64F\U0001F3FF": {
        "en": "folded_hands_dark_skin_tone",
        "id": "melipat_tangan_warna_kulit_gelap",
        "alias": "melipat_tangan_warna_kulit_gelap_berdoa_bungkuk_gerakan_lipat_makasih_mohon_tolong_tubuh",
    },
    "\U0000270D\U0001F3FB": {
        "en": "writing_hand_light_skin_tone",
        "id": "tangan_menulis_warna_kulit_cerah",
        "alias": "tangan_menulis_warna_kulit_cerah_badan_nulis_tubuh_tulis",
    },
    "\U0000270D\U0001F3FC": {
        "en": "writing_hand_medium-light_skin_tone",
        "id": "tangan_menulis_warna_kulit_cerah-sedang",
        "alias": "tangan_menulis_warna_kulit_cerah-sedang_badan_nulis_tubuh_tulis",
    },
    "\U0000270D\U0001F3FD": {
        "en": "writing_hand_medium_skin_tone",
        "id": "tangan_menulis_warna_kulit_sedang",
        "alias": "tangan_menulis_warna_kulit_sedang_badan_nulis_tubuh_tulis",
    },
    "\U0000270D\U0001F3FE": {
        "en": "writing_hand_medium-dark_skin_tone",
        "id": "tangan_menulis_warna_kulit_gelap-sedang",
        "alias": "tangan_menulis_warna_kulit_gelap-sedang_badan_nulis_tubuh_tulis",
    },
    "\U0000270D\U0001F3FF": {
        "en": "writing_hand_dark_skin_tone",
        "id": "tangan_menulis_warna_kulit_gelap",
        "alias": "tangan_menulis_warna_kulit_gelap_badan_nulis_tubuh_tulis",
    },
    "\U0001F485\U0001F3FB": {
        "en": "nail_polish_light_skin_tone",
        "id": "poles_kuku_warna_kulit_cerah",
        "alias": "poles_kuku_warna_kulit_cerah_cat_kosmetik_manikur_perawatan",
    },
    "\U0001F485\U0001F3FC": {
        "en": "nail_polish_medium-light_skin_tone",
        "id": "poles_kuku_warna_kulit_cerah-sedang",
        "alias": "poles_kuku_warna_kulit_cerah-sedang_cat_kosmetik_manikur_perawatan",
    },
    "\U0001F485\U0001F3FD": {
        "en": "nail_polish_medium_skin_tone",
        "id": "poles_kuku_warna_kulit_sedang",
        "alias": "poles_kuku_warna_kulit_sedang_cat_kosmetik_manikur_perawatan",
    },
    "\U0001F485\U0001F3FE": {
        "en": "nail_polish_medium-dark_skin_tone",
        "id": "poles_kuku_warna_kulit_gelap-sedang",
        "alias": "poles_kuku_warna_kulit_gelap-sedang_cat_kosmetik_manikur_perawatan",
    },
    "\U0001F485\U0001F3FF": {
        "en": "nail_polish_dark_skin_tone",
        "id": "poles_kuku_warna_kulit_gelap",
        "alias": "poles_kuku_warna_kulit_gelap_cat_kosmetik_manikur_perawatan",
    },
    "\U0001F933\U0001F3FB": {
        "en": "selfie_light_skin_tone",
        "id": "selfie_warna_kulit_cerah",
        "alias": "selfie_warna_kulit_cerah_foto_kamera_ponsel_selfi",
    },
    "\U0001F933\U0001F3FC": {
        "en": "selfie_medium-light_skin_tone",
        "id": "selfie_warna_kulit_cerah-sedang",
        "alias": "selfie_warna_kulit_cerah-sedang_foto_kamera_ponsel_selfi",
    },
    "\U0001F933\U0001F3FD": {
        "en": "selfie_medium_skin_tone",
        "id": "selfie_warna_kulit_sedang",
        "alias": "selfie_warna_kulit_sedang_foto_kamera_ponsel_selfi",
    },
    "\U0001F933\U0001F3FE": {
        "en": "selfie_medium-dark_skin_tone",
        "id": "selfie_warna_kulit_gelap-sedang",
        "alias": "selfie_warna_kulit_gelap-sedang_foto_kamera_ponsel_selfi",
    },
    "\U0001F933\U0001F3FF": {
        "en": "selfie_dark_skin_tone",
        "id": "selfie_warna_kulit_gelap",
        "alias": "selfie_warna_kulit_gelap_foto_kamera_ponsel_selfi",
    },
    "\U0001F4AA\U0001F3FB": {
        "en": "flexed_biceps_light_skin_tone",
        "id": "lengan_berotot_warna_kulit_cerah",
        "alias": "lengan_berotot_warna_kulit_cerah_badan_biseps_otot_tubuh",
    },
    "\U0001F4AA\U0001F3FC": {
        "en": "flexed_biceps_medium-light_skin_tone",
        "id": "lengan_berotot_warna_kulit_cerah-sedang",
        "alias": "lengan_berotot_warna_kulit_cerah-sedang_badan_biseps_otot_tubuh",
    },
    "\U0001F4AA\U0001F3FD": {
        "en": "flexed_biceps_medium_skin_tone",
        "id": "lengan_berotot_warna_kulit_sedang",
        "alias": "lengan_berotot_warna_kulit_sedang_badan_biseps_otot_tubuh",
    },
    "\U0001F4AA\U0001F3FE": {
        "en": "flexed_biceps_medium-dark_skin_tone",
        "id": "lengan_berotot_warna_kulit_gelap-sedang",
        "alias": "lengan_berotot_warna_kulit_gelap-sedang_badan_biseps_otot_tubuh",
    },
    "\U0001F4AA\U0001F3FF": {
        "en": "flexed_biceps_dark_skin_tone",
        "id": "lengan_berotot_warna_kulit_gelap",
        "alias": "lengan_berotot_warna_kulit_gelap_badan_biseps_otot_tubuh",
    },
    "\U0001F9B5\U0001F3FB": {
        "en": "leg_light_skin_tone",
        "id": "tungkai_warna_kulit_cerah",
        "alias": "tungkai_warna_kulit_cerah_bagian_tubuh_tendang",
    },
    "\U0001F9B5\U0001F3FC": {
        "en": "leg_medium-light_skin_tone",
        "id": "tungkai_warna_kulit_cerah-sedang",
        "alias": "tungkai_warna_kulit_cerah-sedang_bagian_tubuh_tendang",
    },
    "\U0001F9B5\U0001F3FD": {
        "en": "leg_medium_skin_tone",
        "id": "tungkai_warna_kulit_sedang",
        "alias": "tungkai_warna_kulit_sedang_bagian_tubuh_tendang",
    },
    "\U0001F9B5\U0001F3FE": {
        "en": "leg_medium-dark_skin_tone",
        "id": "tungkai_warna_kulit_gelap-sedang",
        "alias": "tungkai_warna_kulit_gelap-sedang_bagian_tubuh_tendang",
    },
    "\U0001F9B5\U0001F3FF": {
        "en": "leg_dark_skin_tone",
        "id": "tungkai_warna_kulit_gelap",
        "alias": "tungkai_warna_kulit_gelap_bagian_tubuh_tendang",
    },
    "\U0001F9B6\U0001F3FB": {
        "en": "foot_light_skin_tone",
        "id": "telapak_kaki_warna_kulit_cerah",
        "alias": "telapak_kaki_warna_kulit_cerah_injak_tendang",
    },
    "\U0001F9B6\U0001F3FC": {
        "en": "foot_medium-light_skin_tone",
        "id": "telapak_kaki_warna_kulit_cerah-sedang",
        "alias": "telapak_kaki_warna_kulit_cerah-sedang_injak_tendang",
    },
    "\U0001F9B6\U0001F3FD": {
        "en": "foot_medium_skin_tone",
        "id": "telapak_kaki_warna_kulit_sedang",
        "alias": "telapak_kaki_warna_kulit_sedang_injak_tendang",
    },
    "\U0001F9B6\U0001F3FE": {
        "en": "foot_medium-dark_skin_tone",
        "id": "telapak_kaki_warna_kulit_gelap-sedang",
        "alias": "telapak_kaki_warna_kulit_gelap-sedang_injak_tendang",
    },
    "\U0001F9B6\U0001F3FF": {
        "en": "foot_dark_skin_tone",
        "id": "telapak_kaki_warna_kulit_gelap",
        "alias": "telapak_kaki_warna_kulit_gelap_injak_tendang",
    },
    "\U0001F442\U0001F3FB": {
        "en": "ear_light_skin_tone",
        "id": "telinga_warna_kulit_cerah",
        "alias": "telinga_warna_kulit_cerah_badan_tubuh",
    },
    "\U0001F442\U0001F3FC": {
        "en": "ear_medium-light_skin_tone",
        "id": "telinga_warna_kulit_cerah-sedang",
        "alias": "telinga_warna_kulit_cerah-sedang_badan_tubuh",
    },
    "\U0001F442\U0001F3FD": {
        "en": "ear_medium_skin_tone",
        "id": "telinga_warna_kulit_sedang",
        "alias": "telinga_warna_kulit_sedang_badan_tubuh",
    },
    "\U0001F442\U0001F3FE": {
        "en": "ear_medium-dark_skin_tone",
        "id": "telinga_warna_kulit_gelap-sedang",
        "alias": "telinga_warna_kulit_gelap-sedang_badan_tubuh",
    },
    "\U0001F442\U0001F3FF": {
        "en": "ear_dark_skin_tone",
        "id": "telinga_warna_kulit_gelap",
        "alias": "telinga_warna_kulit_gelap_badan_tubuh",
    },
    "\U0001F9BB\U0001F3FB": {
        "en": "ear_with_hearing_aid_light_skin_tone",
        "id": "telinga_dengan_alat_bantu_dengar_warna_kulit_cerah",
        "alias": "telinga_dengan_alat_bantu_dengar_warna_kulit_cerah_aksesibilitas_sulit_mendengar_tuli_tunarungu",
    },
    "\U0001F9BB\U0001F3FC": {
        "en": "ear_with_hearing_aid_medium-light_skin_tone",
        "id": "telinga_dengan_alat_bantu_dengar_warna_kulit_cerah-sedang",
        "alias": "telinga_dengan_alat_bantu_dengar_warna_kulit_cerah-sedang_aksesibilitas_sulit_mendengar_tuli_tunarungu",
    },
    "\U0001F9BB\U0001F3FD": {
        "en": "ear_with_hearing_aid_medium_skin_tone",
        "id": "telinga_dengan_alat_bantu_dengar_warna_kulit_sedang",
        "alias": "telinga_dengan_alat_bantu_dengar_warna_kulit_sedang_aksesibilitas_sulit_mendengar_tuli_tunarungu",
    },
    "\U0001F9BB\U0001F3FE": {
        "en": "ear_with_hearing_aid_medium-dark_skin_tone",
        "id": "telinga_dengan_alat_bantu_dengar_warna_kulit_gelap-sedang",
        "alias": "telinga_dengan_alat_bantu_dengar_warna_kulit_gelap-sedang_aksesibilitas_sulit_mendengar_tuli_tunarungu",
    },
    "\U0001F9BB\U0001F3FF": {
        "en": "ear_with_hearing_aid_dark_skin_tone",
        "id": "telinga_dengan_alat_bantu_dengar_warna_kulit_gelap",
        "alias": "telinga_dengan_alat_bantu_dengar_warna_kulit_gelap_aksesibilitas_sulit_mendengar_tuli_tunarungu",
    },
    "\U0001F443\U0001F3FB": {
        "en": "nose_light_skin_tone",
        "id": "hidung_warna_kulit_cerah",
        "alias": "hidung_warna_kulit_cerah_badan_tubuh",
    },
    "\U0001F443\U0001F3FC": {
        "en": "nose_medium-light_skin_tone",
        "id": "hidung_warna_kulit_cerah-sedang",
        "alias": "hidung_warna_kulit_cerah-sedang_badan_tubuh",
    },
    "\U0001F443\U0001F3FD": {
        "en": "nose_medium_skin_tone",
        "id": "hidung_warna_kulit_sedang",
        "alias": "hidung_warna_kulit_sedang_badan_tubuh",
    },
    "\U0001F443\U0001F3FE": {
        "en": "nose_medium-dark_skin_tone",
        "id": "hidung_warna_kulit_gelap-sedang",
        "alias": "hidung_warna_kulit_gelap-sedang_badan_tubuh",
    },
    "\U0001F443\U0001F3FF": {
        "en": "nose_dark_skin_tone",
        "id": "hidung_warna_kulit_gelap",
        "alias": "hidung_warna_kulit_gelap_badan_tubuh",
    },
    "\U0001F476\U0001F3FB": {
        "en": "baby_light_skin_tone",
        "id": "bayi_warna_kulit_cerah",
        "alias": "bayi_warna_kulit_cerah_muda",
    },
    "\U0001F476\U0001F3FC": {
        "en": "baby_medium-light_skin_tone",
        "id": "bayi_warna_kulit_cerah-sedang",
        "alias": "bayi_warna_kulit_cerah-sedang_muda",
    },
    "\U0001F476\U0001F3FD": {
        "en": "baby_medium_skin_tone",
        "id": "bayi_warna_kulit_sedang",
        "alias": "bayi_warna_kulit_sedang_muda",
    },
    "\U0001F476\U0001F3FE": {
        "en": "baby_medium-dark_skin_tone",
        "id": "bayi_warna_kulit_gelap-sedang",
        "alias": "bayi_warna_kulit_gelap-sedang_muda",
    },
    "\U0001F476\U0001F3FF": {
        "en": "baby_dark_skin_tone",
        "id": "bayi_warna_kulit_gelap",
        "alias": "bayi_warna_kulit_gelap_muda",
    },
    "\U0001F9D2\U0001F3FB": {
        "en": "child_light_skin_tone",
        "id": "anak_warna_kulit_cerah",
        "alias": "anak_warna_kulit_cerah_gender_tak_tentu_muda_netral",
    },
    "\U0001F9D2\U0001F3FC": {
        "en": "child_medium-light_skin_tone",
        "id": "anak_warna_kulit_cerah-sedang",
        "alias": "anak_warna_kulit_cerah-sedang_gender_tak_tentu_muda_netral",
    },
    "\U0001F9D2\U0001F3FD": {
        "en": "child_medium_skin_tone",
        "id": "anak_warna_kulit_sedang",
        "alias": "anak_warna_kulit_sedang_gender_tak_tentu_muda_netral",
    },
    "\U0001F9D2\U0001F3FE": {
        "en": "child_medium-dark_skin_tone",
        "id": "anak_warna_kulit_gelap-sedang",
        "alias": "anak_warna_kulit_gelap-sedang_gender_tak_tentu_muda_netral",
    },
    "\U0001F9D2\U0001F3FF": {
        "en": "child_dark_skin_tone",
        "id": "anak_warna_kulit_gelap",
        "alias": "anak_warna_kulit_gelap_gender_tak_tentu_muda_netral",
    },
    "\U0001F466\U0001F3FB": {
        "en": "boy_light_skin_tone",
        "id": "anak_laki-laki_warna_kulit_cerah",
        "alias": "anak_laki-laki_warna_kulit_cerah_muda",
    },
    "\U0001F466\U0001F3FC": {
        "en": "boy_medium-light_skin_tone",
        "id": "anak_laki-laki_warna_kulit_cerah-sedang",
        "alias": "anak_laki-laki_warna_kulit_cerah-sedang_muda",
    },
    "\U0001F466\U0001F3FD": {
        "en": "boy_medium_skin_tone",
        "id": "anak_laki-laki_warna_kulit_sedang",
        "alias": "anak_laki-laki_warna_kulit_sedang_muda",
    },
    "\U0001F466\U0001F3FE": {
        "en": "boy_medium-dark_skin_tone",
        "id": "anak_laki-laki_warna_kulit_gelap-sedang",
        "alias": "anak_laki-laki_warna_kulit_gelap-sedang_muda",
    },
    "\U0001F466\U0001F3FF": {
        "en": "boy_dark_skin_tone",
        "id": "anak_laki-laki_warna_kulit_gelap",
        "alias": "anak_laki-laki_warna_kulit_gelap_muda",
    },
    "\U0001F467\U0001F3FB": {
        "en": "girl_light_skin_tone",
        "id": "anak_perempuan_warna_kulit_cerah",
        "alias": "anak_perempuan_warna_kulit_cerah_muda_virgo_zodiak",
    },
    "\U0001F467\U0001F3FC": {
        "en": "girl_medium-light_skin_tone",
        "id": "anak_perempuan_warna_kulit_cerah-sedang",
        "alias": "anak_perempuan_warna_kulit_cerah-sedang_muda_virgo_zodiak",
    },
    "\U0001F467\U0001F3FD": {
        "en": "girl_medium_skin_tone",
        "id": "anak_perempuan_warna_kulit_sedang",
        "alias": "anak_perempuan_warna_kulit_sedang_muda_virgo_zodiak",
    },
    "\U0001F467\U0001F3FE": {
        "en": "girl_medium-dark_skin_tone",
        "id": "anak_perempuan_warna_kulit_gelap-sedang",
        "alias": "anak_perempuan_warna_kulit_gelap-sedang_muda_virgo_zodiak",
    },
    "\U0001F467\U0001F3FF": {
        "en": "girl_dark_skin_tone",
        "id": "anak_perempuan_warna_kulit_gelap",
        "alias": "anak_perempuan_warna_kulit_gelap_muda_virgo_zodiak",
    },
    "\U0001F9D1\U0001F3FB": {
        "en": "person_light_skin_tone",
        "id": "dewasa_warna_kulit_cerah",
        "alias": "dewasa_warna_kulit_cerah_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FC": {
        "en": "person_medium-light_skin_tone",
        "id": "dewasa_warna_kulit_cerah-sedang",
        "alias": "dewasa_warna_kulit_cerah-sedang_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FD": {
        "en": "person_medium_skin_tone",
        "id": "dewasa_warna_kulit_sedang",
        "alias": "dewasa_warna_kulit_sedang_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FE": {
        "en": "person_medium-dark_skin_tone",
        "id": "dewasa_warna_kulit_gelap-sedang",
        "alias": "dewasa_warna_kulit_gelap-sedang_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FF": {
        "en": "person_dark_skin_tone",
        "id": "dewasa_warna_kulit_gelap",
        "alias": "dewasa_warna_kulit_gelap_gender_tak_tentu_netral_orang",
    },
    "\U0001F471\U0001F3FB": {
        "en": "person_light_skin_tone_blond_hair",
        "id": "orang_warna_kulit_cerah_rambut_pirang",
        "alias": "orang_warna_kulit_cerah_rambut_pirang_berambut",
    },
    "\U0001F471\U0001F3FC": {
        "en": "person_medium-light_skin_tone_blond_hair",
        "id": "orang_warna_kulit_cerah-sedang_rambut_pirang",
        "alias": "orang_warna_kulit_cerah-sedang_rambut_pirang_berambut",
    },
    "\U0001F471\U0001F3FD": {
        "en": "person_medium_skin_tone_blond_hair",
        "id": "orang_warna_kulit_sedang_rambut_pirang",
        "alias": "orang_warna_kulit_sedang_rambut_pirang_berambut",
    },
    "\U0001F471\U0001F3FE": {
        "en": "person_medium-dark_skin_tone_blond_hair",
        "id": "orang_warna_kulit_gelap-sedang_rambut_pirang",
        "alias": "orang_warna_kulit_gelap-sedang_rambut_pirang_berambut",
    },
    "\U0001F471\U0001F3FF": {
        "en": "person_dark_skin_tone_blond_hair",
        "id": "orang_warna_kulit_gelap_rambut_pirang",
        "alias": "orang_warna_kulit_gelap_rambut_pirang_berambut",
    },
    "\U0001F468\U0001F3FB": {
        "en": "man_light_skin_tone",
        "id": "pria_warna_kulit_cerah",
        "alias": "pria_warna_kulit_cerah_orang_dewasa",
    },
    "\U0001F468\U0001F3FC": {
        "en": "man_medium-light_skin_tone",
        "id": "pria_warna_kulit_cerah-sedang",
        "alias": "pria_warna_kulit_cerah-sedang_orang_dewasa",
    },
    "\U0001F468\U0001F3FD": {
        "en": "man_medium_skin_tone",
        "id": "pria_warna_kulit_sedang",
        "alias": "pria_warna_kulit_sedang_orang_dewasa",
    },
    "\U0001F468\U0001F3FE": {
        "en": "man_medium-dark_skin_tone",
        "id": "pria_warna_kulit_gelap-sedang",
        "alias": "pria_warna_kulit_gelap-sedang_orang_dewasa",
    },
    "\U0001F468\U0001F3FF": {
        "en": "man_dark_skin_tone",
        "id": "pria_warna_kulit_gelap",
        "alias": "pria_warna_kulit_gelap_orang_dewasa",
    },
    "\U0001F9D4\U0001F3FB": {
        "en": "person_light_skin_tone_beard",
        "id": "orang_warna_kulit_cerah_janggut",
    },
    "\U0001F9D4\U0001F3FC": {
        "en": "person_medium-light_skin_tone_beard",
        "id": "orang_warna_kulit_cerah-sedang_janggut",
    },
    "\U0001F9D4\U0001F3FD": {
        "en": "person_medium_skin_tone_beard",
        "id": "orang_warna_kulit_sedang_janggut",
    },
    "\U0001F9D4\U0001F3FE": {
        "en": "person_medium-dark_skin_tone_beard",
        "id": "orang_warna_kulit_gelap-sedang_janggut",
    },
    "\U0001F9D4\U0001F3FF": {
        "en": "person_dark_skin_tone_beard",
        "id": "orang_warna_kulit_gelap_janggut",
    },
    "\U0001F9D4\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_light_skin_tone_beard",
        "id": "pria_warna_kulit_cerah_janggut",
    },
    "\U0001F9D4\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_medium-light_skin_tone_beard",
        "id": "pria_warna_kulit_cerah-sedang_janggut",
    },
    "\U0001F9D4\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_medium_skin_tone_beard",
        "id": "pria_warna_kulit_sedang_janggut",
    },
    "\U0001F9D4\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_medium-dark_skin_tone_beard",
        "id": "pria_warna_kulit_gelap-sedang_janggut",
    },
    "\U0001F9D4\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_dark_skin_tone_beard",
        "id": "pria_warna_kulit_gelap_janggut",
    },
    "\U0001F9D4\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_light_skin_tone_beard",
        "id": "wanita_warna_kulit_cerah_janggut",
    },
    "\U0001F9D4\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_medium-light_skin_tone_beard",
        "id": "wanita_warna_kulit_cerah-sedang_janggut",
    },
    "\U0001F9D4\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_medium_skin_tone_beard",
        "id": "wanita_warna_kulit_sedang_janggut",
    },
    "\U0001F9D4\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_medium-dark_skin_tone_beard",
        "id": "wanita_warna_kulit_gelap-sedang_janggut",
    },
    "\U0001F9D4\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_dark_skin_tone_beard",
        "id": "wanita_warna_kulit_gelap_janggut",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F9B0": {
        "en": "man_light_skin_tone_red_hair",
        "id": "pria_warna_kulit_cerah_rambut_merah",
        "alias": "pria_warna_kulit_cerah_rambut_merah_orang_dewasa",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F9B0": {
        "en": "man_medium-light_skin_tone_red_hair",
        "id": "pria_warna_kulit_cerah-sedang_rambut_merah",
        "alias": "pria_warna_kulit_cerah-sedang_rambut_merah_orang_dewasa",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F9B0": {
        "en": "man_medium_skin_tone_red_hair",
        "id": "pria_warna_kulit_sedang_rambut_merah",
        "alias": "pria_warna_kulit_sedang_rambut_merah_orang_dewasa",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F9B0": {
        "en": "man_medium-dark_skin_tone_red_hair",
        "id": "pria_warna_kulit_gelap-sedang_rambut_merah",
        "alias": "pria_warna_kulit_gelap-sedang_rambut_merah_orang_dewasa",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F9B0": {
        "en": "man_dark_skin_tone_red_hair",
        "id": "pria_warna_kulit_gelap_rambut_merah",
        "alias": "pria_warna_kulit_gelap_rambut_merah_orang_dewasa",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F9B1": {
        "en": "man_light_skin_tone_curly_hair",
        "id": "pria_warna_kulit_cerah_rambut_keriting",
        "alias": "pria_warna_kulit_cerah_rambut_keriting_orang_dewasa",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F9B1": {
        "en": "man_medium-light_skin_tone_curly_hair",
        "id": "pria_warna_kulit_cerah-sedang_rambut_keriting",
        "alias": "pria_warna_kulit_cerah-sedang_rambut_keriting_orang_dewasa",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F9B1": {
        "en": "man_medium_skin_tone_curly_hair",
        "id": "pria_warna_kulit_sedang_rambut_keriting",
        "alias": "pria_warna_kulit_sedang_rambut_keriting_orang_dewasa",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F9B1": {
        "en": "man_medium-dark_skin_tone_curly_hair",
        "id": "pria_warna_kulit_gelap-sedang_rambut_keriting",
        "alias": "pria_warna_kulit_gelap-sedang_rambut_keriting_orang_dewasa",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F9B1": {
        "en": "man_dark_skin_tone_curly_hair",
        "id": "pria_warna_kulit_gelap_rambut_keriting",
        "alias": "pria_warna_kulit_gelap_rambut_keriting_orang_dewasa",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F9B3": {
        "en": "man_light_skin_tone_white_hair",
        "id": "pria_warna_kulit_cerah_rambut_putih",
        "alias": "pria_warna_kulit_cerah_rambut_putih_orang_dewasa",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F9B3": {
        "en": "man_medium-light_skin_tone_white_hair",
        "id": "pria_warna_kulit_cerah-sedang_rambut_putih",
        "alias": "pria_warna_kulit_cerah-sedang_rambut_putih_orang_dewasa",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F9B3": {
        "en": "man_medium_skin_tone_white_hair",
        "id": "pria_warna_kulit_sedang_rambut_putih",
        "alias": "pria_warna_kulit_sedang_rambut_putih_orang_dewasa",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F9B3": {
        "en": "man_medium-dark_skin_tone_white_hair",
        "id": "pria_warna_kulit_gelap-sedang_rambut_putih",
        "alias": "pria_warna_kulit_gelap-sedang_rambut_putih_orang_dewasa",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F9B3": {
        "en": "man_dark_skin_tone_white_hair",
        "id": "pria_warna_kulit_gelap_rambut_putih",
        "alias": "pria_warna_kulit_gelap_rambut_putih_orang_dewasa",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F9B2": {
        "en": "man_light_skin_tone_bald",
        "id": "pria_warna_kulit_cerah_gundul",
        "alias": "pria_warna_kulit_cerah_gundul_orang_dewasa",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F9B2": {
        "en": "man_medium-light_skin_tone_bald",
        "id": "pria_warna_kulit_cerah-sedang_gundul",
        "alias": "pria_warna_kulit_cerah-sedang_gundul_orang_dewasa",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F9B2": {
        "en": "man_medium_skin_tone_bald",
        "id": "pria_warna_kulit_sedang_gundul",
        "alias": "pria_warna_kulit_sedang_gundul_orang_dewasa",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F9B2": {
        "en": "man_medium-dark_skin_tone_bald",
        "id": "pria_warna_kulit_gelap-sedang_gundul",
        "alias": "pria_warna_kulit_gelap-sedang_gundul_orang_dewasa",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F9B2": {
        "en": "man_dark_skin_tone_bald",
        "id": "pria_warna_kulit_gelap_gundul",
        "alias": "pria_warna_kulit_gelap_gundul_orang_dewasa",
    },
    "\U0001F469\U0001F3FB": {
        "en": "woman_light_skin_tone",
        "id": "wanita_warna_kulit_cerah",
        "alias": "wanita_warna_kulit_cerah_ibu_perempuan",
    },
    "\U0001F469\U0001F3FC": {
        "en": "woman_medium-light_skin_tone",
        "id": "wanita_warna_kulit_cerah-sedang",
        "alias": "wanita_warna_kulit_cerah-sedang_ibu_perempuan",
    },
    "\U0001F469\U0001F3FD": {
        "en": "woman_medium_skin_tone",
        "id": "wanita_warna_kulit_sedang",
        "alias": "wanita_warna_kulit_sedang_ibu_perempuan",
    },
    "\U0001F469\U0001F3FE": {
        "en": "woman_medium-dark_skin_tone",
        "id": "wanita_warna_kulit_gelap-sedang",
        "alias": "wanita_warna_kulit_gelap-sedang_ibu_perempuan",
    },
    "\U0001F469\U0001F3FF": {
        "en": "woman_dark_skin_tone",
        "id": "wanita_warna_kulit_gelap",
        "alias": "wanita_warna_kulit_gelap_ibu_perempuan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F9B0": {
        "en": "woman_light_skin_tone_red_hair",
        "id": "wanita_warna_kulit_cerah_rambut_merah",
        "alias": "wanita_warna_kulit_cerah_rambut_merah_ibu_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F9B0": {
        "en": "woman_medium-light_skin_tone_red_hair",
        "id": "wanita_warna_kulit_cerah-sedang_rambut_merah",
        "alias": "wanita_warna_kulit_cerah-sedang_rambut_merah_ibu_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F9B0": {
        "en": "woman_medium_skin_tone_red_hair",
        "id": "wanita_warna_kulit_sedang_rambut_merah",
        "alias": "wanita_warna_kulit_sedang_rambut_merah_ibu_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F9B0": {
        "en": "woman_medium-dark_skin_tone_red_hair",
        "id": "wanita_warna_kulit_gelap-sedang_rambut_merah",
        "alias": "wanita_warna_kulit_gelap-sedang_rambut_merah_ibu_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F9B0": {
        "en": "woman_dark_skin_tone_red_hair",
        "id": "wanita_warna_kulit_gelap_rambut_merah",
        "alias": "wanita_warna_kulit_gelap_rambut_merah_ibu_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F9B0": {
        "en": "person_light_skin_tone_red_hair",
        "id": "dewasa_warna_kulit_cerah_rambut_merah",
        "alias": "dewasa_warna_kulit_cerah_rambut_merah_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F9B0": {
        "en": "person_medium-light_skin_tone_red_hair",
        "id": "dewasa_warna_kulit_cerah-sedang_rambut_merah",
        "alias": "dewasa_warna_kulit_cerah-sedang_rambut_merah_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F9B0": {
        "en": "person_medium_skin_tone_red_hair",
        "id": "dewasa_warna_kulit_sedang_rambut_merah",
        "alias": "dewasa_warna_kulit_sedang_rambut_merah_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F9B0": {
        "en": "person_medium-dark_skin_tone_red_hair",
        "id": "dewasa_warna_kulit_gelap-sedang_rambut_merah",
        "alias": "dewasa_warna_kulit_gelap-sedang_rambut_merah_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F9B0": {
        "en": "person_dark_skin_tone_red_hair",
        "id": "dewasa_warna_kulit_gelap_rambut_merah",
        "alias": "dewasa_warna_kulit_gelap_rambut_merah_gender_tak_tentu_netral_orang",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F9B1": {
        "en": "woman_light_skin_tone_curly_hair",
        "id": "wanita_warna_kulit_cerah_rambut_keriting",
        "alias": "wanita_warna_kulit_cerah_rambut_keriting_ibu_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F9B1": {
        "en": "woman_medium-light_skin_tone_curly_hair",
        "id": "wanita_warna_kulit_cerah-sedang_rambut_keriting",
        "alias": "wanita_warna_kulit_cerah-sedang_rambut_keriting_ibu_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F9B1": {
        "en": "woman_medium_skin_tone_curly_hair",
        "id": "wanita_warna_kulit_sedang_rambut_keriting",
        "alias": "wanita_warna_kulit_sedang_rambut_keriting_ibu_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F9B1": {
        "en": "woman_medium-dark_skin_tone_curly_hair",
        "id": "wanita_warna_kulit_gelap-sedang_rambut_keriting",
        "alias": "wanita_warna_kulit_gelap-sedang_rambut_keriting_ibu_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F9B1": {
        "en": "woman_dark_skin_tone_curly_hair",
        "id": "wanita_warna_kulit_gelap_rambut_keriting",
        "alias": "wanita_warna_kulit_gelap_rambut_keriting_ibu_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F9B1": {
        "en": "person_light_skin_tone_curly_hair",
        "id": "dewasa_warna_kulit_cerah_rambut_keriting",
        "alias": "dewasa_warna_kulit_cerah_rambut_keriting_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F9B1": {
        "en": "person_medium-light_skin_tone_curly_hair",
        "id": "dewasa_warna_kulit_cerah-sedang_rambut_keriting",
        "alias": "dewasa_warna_kulit_cerah-sedang_rambut_keriting_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F9B1": {
        "en": "person_medium_skin_tone_curly_hair",
        "id": "dewasa_warna_kulit_sedang_rambut_keriting",
        "alias": "dewasa_warna_kulit_sedang_rambut_keriting_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F9B1": {
        "en": "person_medium-dark_skin_tone_curly_hair",
        "id": "dewasa_warna_kulit_gelap-sedang_rambut_keriting",
        "alias": "dewasa_warna_kulit_gelap-sedang_rambut_keriting_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F9B1": {
        "en": "person_dark_skin_tone_curly_hair",
        "id": "dewasa_warna_kulit_gelap_rambut_keriting",
        "alias": "dewasa_warna_kulit_gelap_rambut_keriting_gender_tak_tentu_netral_orang",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F9B3": {
        "en": "woman_light_skin_tone_white_hair",
        "id": "wanita_warna_kulit_cerah_rambut_putih",
        "alias": "wanita_warna_kulit_cerah_rambut_putih_ibu_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F9B3": {
        "en": "woman_medium-light_skin_tone_white_hair",
        "id": "wanita_warna_kulit_cerah-sedang_rambut_putih",
        "alias": "wanita_warna_kulit_cerah-sedang_rambut_putih_ibu_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F9B3": {
        "en": "woman_medium_skin_tone_white_hair",
        "id": "wanita_warna_kulit_sedang_rambut_putih",
        "alias": "wanita_warna_kulit_sedang_rambut_putih_ibu_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F9B3": {
        "en": "woman_medium-dark_skin_tone_white_hair",
        "id": "wanita_warna_kulit_gelap-sedang_rambut_putih",
        "alias": "wanita_warna_kulit_gelap-sedang_rambut_putih_ibu_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F9B3": {
        "en": "woman_dark_skin_tone_white_hair",
        "id": "wanita_warna_kulit_gelap_rambut_putih",
        "alias": "wanita_warna_kulit_gelap_rambut_putih_ibu_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F9B3": {
        "en": "person_light_skin_tone_white_hair",
        "id": "dewasa_warna_kulit_cerah_rambut_putih",
        "alias": "dewasa_warna_kulit_cerah_rambut_putih_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F9B3": {
        "en": "person_medium-light_skin_tone_white_hair",
        "id": "dewasa_warna_kulit_cerah-sedang_rambut_putih",
        "alias": "dewasa_warna_kulit_cerah-sedang_rambut_putih_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F9B3": {
        "en": "person_medium_skin_tone_white_hair",
        "id": "dewasa_warna_kulit_sedang_rambut_putih",
        "alias": "dewasa_warna_kulit_sedang_rambut_putih_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F9B3": {
        "en": "person_medium-dark_skin_tone_white_hair",
        "id": "dewasa_warna_kulit_gelap-sedang_rambut_putih",
        "alias": "dewasa_warna_kulit_gelap-sedang_rambut_putih_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F9B3": {
        "en": "person_dark_skin_tone_white_hair",
        "id": "dewasa_warna_kulit_gelap_rambut_putih",
        "alias": "dewasa_warna_kulit_gelap_rambut_putih_gender_tak_tentu_netral_orang",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F9B2": {
        "en": "woman_light_skin_tone_bald",
        "id": "wanita_warna_kulit_cerah_gundul",
        "alias": "wanita_warna_kulit_cerah_gundul_ibu_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F9B2": {
        "en": "woman_medium-light_skin_tone_bald",
        "id": "wanita_warna_kulit_cerah-sedang_gundul",
        "alias": "wanita_warna_kulit_cerah-sedang_gundul_ibu_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F9B2": {
        "en": "woman_medium_skin_tone_bald",
        "id": "wanita_warna_kulit_sedang_gundul",
        "alias": "wanita_warna_kulit_sedang_gundul_ibu_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F9B2": {
        "en": "woman_medium-dark_skin_tone_bald",
        "id": "wanita_warna_kulit_gelap-sedang_gundul",
        "alias": "wanita_warna_kulit_gelap-sedang_gundul_ibu_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F9B2": {
        "en": "woman_dark_skin_tone_bald",
        "id": "wanita_warna_kulit_gelap_gundul",
        "alias": "wanita_warna_kulit_gelap_gundul_ibu_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F9B2": {
        "en": "person_light_skin_tone_bald",
        "id": "dewasa_warna_kulit_cerah_gundul",
        "alias": "dewasa_warna_kulit_cerah_gundul_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F9B2": {
        "en": "person_medium-light_skin_tone_bald",
        "id": "dewasa_warna_kulit_cerah-sedang_gundul",
        "alias": "dewasa_warna_kulit_cerah-sedang_gundul_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F9B2": {
        "en": "person_medium_skin_tone_bald",
        "id": "dewasa_warna_kulit_sedang_gundul",
        "alias": "dewasa_warna_kulit_sedang_gundul_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F9B2": {
        "en": "person_medium-dark_skin_tone_bald",
        "id": "dewasa_warna_kulit_gelap-sedang_gundul",
        "alias": "dewasa_warna_kulit_gelap-sedang_gundul_gender_tak_tentu_netral_orang",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F9B2": {
        "en": "person_dark_skin_tone_bald",
        "id": "dewasa_warna_kulit_gelap_gundul",
        "alias": "dewasa_warna_kulit_gelap_gundul_gender_tak_tentu_netral_orang",
    },
    "\U0001F471\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_light_skin_tone_blond_hair",
        "id": "wanita_berambut_pirang_warna_kulit_cerah",
        "alias": "wanita_berambut_pirang_warna_kulit_cerah_perempuan_rambut",
    },
    "\U0001F471\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_medium-light_skin_tone_blond_hair",
        "id": "wanita_berambut_pirang_warna_kulit_cerah-sedang",
        "alias": "wanita_berambut_pirang_warna_kulit_cerah-sedang_perempuan_rambut",
    },
    "\U0001F471\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_medium_skin_tone_blond_hair",
        "id": "wanita_berambut_pirang_warna_kulit_sedang",
        "alias": "wanita_berambut_pirang_warna_kulit_sedang_perempuan_rambut",
    },
    "\U0001F471\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_medium-dark_skin_tone_blond_hair",
        "id": "wanita_berambut_pirang_warna_kulit_gelap-sedang",
        "alias": "wanita_berambut_pirang_warna_kulit_gelap-sedang_perempuan_rambut",
    },
    "\U0001F471\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_dark_skin_tone_blond_hair",
        "id": "wanita_berambut_pirang_warna_kulit_gelap",
        "alias": "wanita_berambut_pirang_warna_kulit_gelap_perempuan_rambut",
    },
    "\U0001F471\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_light_skin_tone_blond_hair",
        "id": "pria_berambut_pirang_warna_kulit_cerah",
        "alias": "pria_berambut_pirang_warna_kulit_cerah_laki-laki_rambut",
    },
    "\U0001F471\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_medium-light_skin_tone_blond_hair",
        "id": "pria_berambut_pirang_warna_kulit_cerah-sedang",
        "alias": "pria_berambut_pirang_warna_kulit_cerah-sedang_laki-laki_rambut",
    },
    "\U0001F471\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_medium_skin_tone_blond_hair",
        "id": "pria_berambut_pirang_warna_kulit_sedang",
        "alias": "pria_berambut_pirang_warna_kulit_sedang_laki-laki_rambut",
    },
    "\U0001F471\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_medium-dark_skin_tone_blond_hair",
        "id": "pria_berambut_pirang_warna_kulit_gelap-sedang",
        "alias": "pria_berambut_pirang_warna_kulit_gelap-sedang_laki-laki_rambut",
    },
    "\U0001F471\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_dark_skin_tone_blond_hair",
        "id": "pria_berambut_pirang_warna_kulit_gelap",
        "alias": "pria_berambut_pirang_warna_kulit_gelap_laki-laki_rambut",
    },
    "\U0001F9D3\U0001F3FB": {
        "en": "older_person_light_skin_tone",
        "id": "lanjut_usia_warna_kulit_cerah",
        "alias": "lanjut_usia_warna_kulit_cerah_netral_gender_tua",
    },
    "\U0001F9D3\U0001F3FC": {
        "en": "older_person_medium-light_skin_tone",
        "id": "lanjut_usia_warna_kulit_cerah-sedang",
        "alias": "lanjut_usia_warna_kulit_cerah-sedang_netral_gender_tua",
    },
    "\U0001F9D3\U0001F3FD": {
        "en": "older_person_medium_skin_tone",
        "id": "lanjut_usia_warna_kulit_sedang",
        "alias": "lanjut_usia_warna_kulit_sedang_netral_gender_tua",
    },
    "\U0001F9D3\U0001F3FE": {
        "en": "older_person_medium-dark_skin_tone",
        "id": "lanjut_usia_warna_kulit_gelap-sedang",
        "alias": "lanjut_usia_warna_kulit_gelap-sedang_netral_gender_tua",
    },
    "\U0001F9D3\U0001F3FF": {
        "en": "older_person_dark_skin_tone",
        "id": "lanjut_usia_warna_kulit_gelap",
        "alias": "lanjut_usia_warna_kulit_gelap_netral_gender_tua",
    },
    "\U0001F474\U0001F3FB": {
        "en": "old_man_light_skin_tone",
        "id": "pria_tua_warna_kulit_cerah",
        "alias": "pria_tua_warna_kulit_cerah_kakek_laki-laki",
    },
    "\U0001F474\U0001F3FC": {
        "en": "old_man_medium-light_skin_tone",
        "id": "pria_tua_warna_kulit_cerah-sedang",
        "alias": "pria_tua_warna_kulit_cerah-sedang_kakek_laki-laki",
    },
    "\U0001F474\U0001F3FD": {
        "en": "old_man_medium_skin_tone",
        "id": "pria_tua_warna_kulit_sedang",
        "alias": "pria_tua_warna_kulit_sedang_kakek_laki-laki",
    },
    "\U0001F474\U0001F3FE": {
        "en": "old_man_medium-dark_skin_tone",
        "id": "pria_tua_warna_kulit_gelap-sedang",
        "alias": "pria_tua_warna_kulit_gelap-sedang_kakek_laki-laki",
    },
    "\U0001F474\U0001F3FF": {
        "en": "old_man_dark_skin_tone",
        "id": "pria_tua_warna_kulit_gelap",
        "alias": "pria_tua_warna_kulit_gelap_kakek_laki-laki",
    },
    "\U0001F475\U0001F3FB": {
        "en": "old_woman_light_skin_tone",
        "id": "wanita_tua_warna_kulit_cerah",
        "alias": "wanita_tua_warna_kulit_cerah_nenek_perempuan",
    },
    "\U0001F475\U0001F3FC": {
        "en": "old_woman_medium-light_skin_tone",
        "id": "wanita_tua_warna_kulit_cerah-sedang",
        "alias": "wanita_tua_warna_kulit_cerah-sedang_nenek_perempuan",
    },
    "\U0001F475\U0001F3FD": {
        "en": "old_woman_medium_skin_tone",
        "id": "wanita_tua_warna_kulit_sedang",
        "alias": "wanita_tua_warna_kulit_sedang_nenek_perempuan",
    },
    "\U0001F475\U0001F3FE": {
        "en": "old_woman_medium-dark_skin_tone",
        "id": "wanita_tua_warna_kulit_gelap-sedang",
        "alias": "wanita_tua_warna_kulit_gelap-sedang_nenek_perempuan",
    },
    "\U0001F475\U0001F3FF": {
        "en": "old_woman_dark_skin_tone",
        "id": "wanita_tua_warna_kulit_gelap",
        "alias": "wanita_tua_warna_kulit_gelap_nenek_perempuan",
    },
    "\U0001F64D\U0001F3FB": {
        "en": "person_frowning_light_skin_tone",
        "id": "orang_marah_warna_kulit_cerah",
        "alias": "orang_marah_warna_kulit_cerah_gerakan",
    },
    "\U0001F64D\U0001F3FC": {
        "en": "person_frowning_medium-light_skin_tone",
        "id": "orang_marah_warna_kulit_cerah-sedang",
        "alias": "orang_marah_warna_kulit_cerah-sedang_gerakan",
    },
    "\U0001F64D\U0001F3FD": {
        "en": "person_frowning_medium_skin_tone",
        "id": "orang_marah_warna_kulit_sedang",
        "alias": "orang_marah_warna_kulit_sedang_gerakan",
    },
    "\U0001F64D\U0001F3FE": {
        "en": "person_frowning_medium-dark_skin_tone",
        "id": "orang_marah_warna_kulit_gelap-sedang",
        "alias": "orang_marah_warna_kulit_gelap-sedang_gerakan",
    },
    "\U0001F64D\U0001F3FF": {
        "en": "person_frowning_dark_skin_tone",
        "id": "orang_marah_warna_kulit_gelap",
        "alias": "orang_marah_warna_kulit_gelap_gerakan",
    },
    "\U0001F64D\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_frowning_light_skin_tone",
        "id": "pria_muka_tidak_senang_warna_kulit_cerah",
        "alias": "pria_muka_tidak_senang_warna_kulit_cerah_laki-laki",
    },
    "\U0001F64D\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_frowning_medium-light_skin_tone",
        "id": "pria_muka_tidak_senang_warna_kulit_cerah-sedang",
        "alias": "pria_muka_tidak_senang_warna_kulit_cerah-sedang_laki-laki",
    },
    "\U0001F64D\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_frowning_medium_skin_tone",
        "id": "pria_muka_tidak_senang_warna_kulit_sedang",
        "alias": "pria_muka_tidak_senang_warna_kulit_sedang_laki-laki",
    },
    "\U0001F64D\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_frowning_medium-dark_skin_tone",
        "id": "pria_muka_tidak_senang_warna_kulit_gelap-sedang",
        "alias": "pria_muka_tidak_senang_warna_kulit_gelap-sedang_laki-laki",
    },
    "\U0001F64D\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_frowning_dark_skin_tone",
        "id": "pria_muka_tidak_senang_warna_kulit_gelap",
        "alias": "pria_muka_tidak_senang_warna_kulit_gelap_laki-laki",
    },
    "\U0001F64D\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_frowning_light_skin_tone",
        "id": "wanita_muka_tidak_senang_warna_kulit_cerah",
        "alias": "wanita_muka_tidak_senang_warna_kulit_cerah_perempuan",
    },
    "\U0001F64D\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_frowning_medium-light_skin_tone",
        "id": "wanita_muka_tidak_senang_warna_kulit_cerah-sedang",
        "alias": "wanita_muka_tidak_senang_warna_kulit_cerah-sedang_perempuan",
    },
    "\U0001F64D\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_frowning_medium_skin_tone",
        "id": "wanita_muka_tidak_senang_warna_kulit_sedang",
        "alias": "wanita_muka_tidak_senang_warna_kulit_sedang_perempuan",
    },
    "\U0001F64D\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_frowning_medium-dark_skin_tone",
        "id": "wanita_muka_tidak_senang_warna_kulit_gelap-sedang",
        "alias": "wanita_muka_tidak_senang_warna_kulit_gelap-sedang_perempuan",
    },
    "\U0001F64D\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_frowning_dark_skin_tone",
        "id": "wanita_muka_tidak_senang_warna_kulit_gelap",
        "alias": "wanita_muka_tidak_senang_warna_kulit_gelap_perempuan",
    },
    "\U0001F64E\U0001F3FB": {
        "en": "person_pouting_light_skin_tone",
        "id": "orang_tidak_senang_warna_kulit_cerah",
        "alias": "orang_tidak_senang_warna_kulit_cerah_cemberut_gerakan",
    },
    "\U0001F64E\U0001F3FC": {
        "en": "person_pouting_medium-light_skin_tone",
        "id": "orang_tidak_senang_warna_kulit_cerah-sedang",
        "alias": "orang_tidak_senang_warna_kulit_cerah-sedang_cemberut_gerakan",
    },
    "\U0001F64E\U0001F3FD": {
        "en": "person_pouting_medium_skin_tone",
        "id": "orang_tidak_senang_warna_kulit_sedang",
        "alias": "orang_tidak_senang_warna_kulit_sedang_cemberut_gerakan",
    },
    "\U0001F64E\U0001F3FE": {
        "en": "person_pouting_medium-dark_skin_tone",
        "id": "orang_tidak_senang_warna_kulit_gelap-sedang",
        "alias": "orang_tidak_senang_warna_kulit_gelap-sedang_cemberut_gerakan",
    },
    "\U0001F64E\U0001F3FF": {
        "en": "person_pouting_dark_skin_tone",
        "id": "orang_tidak_senang_warna_kulit_gelap",
        "alias": "orang_tidak_senang_warna_kulit_gelap_cemberut_gerakan",
    },
    "\U0001F64E\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_pouting_light_skin_tone",
        "id": "pria_tidak_senang_warna_kulit_cerah",
        "alias": "pria_tidak_senang_warna_kulit_cerah_bibir_laki-laki",
    },
    "\U0001F64E\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_pouting_medium-light_skin_tone",
        "id": "pria_tidak_senang_warna_kulit_cerah-sedang",
        "alias": "pria_tidak_senang_warna_kulit_cerah-sedang_bibir_laki-laki",
    },
    "\U0001F64E\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_pouting_medium_skin_tone",
        "id": "pria_tidak_senang_warna_kulit_sedang",
        "alias": "pria_tidak_senang_warna_kulit_sedang_bibir_laki-laki",
    },
    "\U0001F64E\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_pouting_medium-dark_skin_tone",
        "id": "pria_tidak_senang_warna_kulit_gelap-sedang",
        "alias": "pria_tidak_senang_warna_kulit_gelap-sedang_bibir_laki-laki",
    },
    "\U0001F64E\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_pouting_dark_skin_tone",
        "id": "pria_tidak_senang_warna_kulit_gelap",
        "alias": "pria_tidak_senang_warna_kulit_gelap_bibir_laki-laki",
    },
    "\U0001F64E\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_pouting_light_skin_tone",
        "id": "wanita_tidak_senang_warna_kulit_cerah",
        "alias": "wanita_tidak_senang_warna_kulit_cerah_bibir_perempuan",
    },
    "\U0001F64E\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_pouting_medium-light_skin_tone",
        "id": "wanita_tidak_senang_warna_kulit_cerah-sedang",
        "alias": "wanita_tidak_senang_warna_kulit_cerah-sedang_bibir_perempuan",
    },
    "\U0001F64E\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_pouting_medium_skin_tone",
        "id": "wanita_tidak_senang_warna_kulit_sedang",
        "alias": "wanita_tidak_senang_warna_kulit_sedang_bibir_perempuan",
    },
    "\U0001F64E\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_pouting_medium-dark_skin_tone",
        "id": "wanita_tidak_senang_warna_kulit_gelap-sedang",
        "alias": "wanita_tidak_senang_warna_kulit_gelap-sedang_bibir_perempuan",
    },
    "\U0001F64E\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_pouting_dark_skin_tone",
        "id": "wanita_tidak_senang_warna_kulit_gelap",
        "alias": "wanita_tidak_senang_warna_kulit_gelap_bibir_perempuan",
    },
    "\U0001F645\U0001F3FB": {
        "en": "person_gesturing_no_light_skin_tone",
        "id": "orang_mengisyaratkan_tidak_warna_kulit_cerah",
        "alias": "orang_mengisyaratkan_tidak_warna_kulit_cerah_dilarang_gerakan_nggak_tangan_terlarang",
    },
    "\U0001F645\U0001F3FC": {
        "en": "person_gesturing_no_medium-light_skin_tone",
        "id": "orang_mengisyaratkan_tidak_warna_kulit_cerah-sedang",
        "alias": "orang_mengisyaratkan_tidak_warna_kulit_cerah-sedang_dilarang_gerakan_nggak_tangan_terlarang",
    },
    "\U0001F645\U0001F3FD": {
        "en": "person_gesturing_no_medium_skin_tone",
        "id": "orang_mengisyaratkan_tidak_warna_kulit_sedang",
        "alias": "orang_mengisyaratkan_tidak_warna_kulit_sedang_dilarang_gerakan_nggak_tangan_terlarang",
    },
    "\U0001F645\U0001F3FE": {
        "en": "person_gesturing_no_medium-dark_skin_tone",
        "id": "orang_mengisyaratkan_tidak_warna_kulit_gelap-sedang",
        "alias": "orang_mengisyaratkan_tidak_warna_kulit_gelap-sedang_dilarang_gerakan_nggak_tangan_terlarang",
    },
    "\U0001F645\U0001F3FF": {
        "en": "person_gesturing_no_dark_skin_tone",
        "id": "orang_mengisyaratkan_tidak_warna_kulit_gelap",
        "alias": "orang_mengisyaratkan_tidak_warna_kulit_gelap_dilarang_gerakan_nggak_tangan_terlarang",
    },
    "\U0001F645\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_no_light_skin_tone",
        "id": "pria_mengisyaratkan_tidak_warna_kulit_cerah",
        "alias": "pria_mengisyaratkan_tidak_warna_kulit_cerah_isyarat_laki-laki",
    },
    "\U0001F645\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_no_medium-light_skin_tone",
        "id": "pria_mengisyaratkan_tidak_warna_kulit_cerah-sedang",
        "alias": "pria_mengisyaratkan_tidak_warna_kulit_cerah-sedang_isyarat_laki-laki",
    },
    "\U0001F645\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_no_medium_skin_tone",
        "id": "pria_mengisyaratkan_tidak_warna_kulit_sedang",
        "alias": "pria_mengisyaratkan_tidak_warna_kulit_sedang_isyarat_laki-laki",
    },
    "\U0001F645\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_no_medium-dark_skin_tone",
        "id": "pria_mengisyaratkan_tidak_warna_kulit_gelap-sedang",
        "alias": "pria_mengisyaratkan_tidak_warna_kulit_gelap-sedang_isyarat_laki-laki",
    },
    "\U0001F645\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_no_dark_skin_tone",
        "id": "pria_mengisyaratkan_tidak_warna_kulit_gelap",
        "alias": "pria_mengisyaratkan_tidak_warna_kulit_gelap_isyarat_laki-laki",
    },
    "\U0001F645\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_no_light_skin_tone",
        "id": "wanita_mengisyaratkan_tidak_warna_kulit_cerah",
        "alias": "wanita_mengisyaratkan_tidak_warna_kulit_cerah_isyarat_perempuan_tangan",
    },
    "\U0001F645\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_no_medium-light_skin_tone",
        "id": "wanita_mengisyaratkan_tidak_warna_kulit_cerah-sedang",
        "alias": "wanita_mengisyaratkan_tidak_warna_kulit_cerah-sedang_isyarat_perempuan_tangan",
    },
    "\U0001F645\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_no_medium_skin_tone",
        "id": "wanita_mengisyaratkan_tidak_warna_kulit_sedang",
        "alias": "wanita_mengisyaratkan_tidak_warna_kulit_sedang_isyarat_perempuan_tangan",
    },
    "\U0001F645\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_no_medium-dark_skin_tone",
        "id": "wanita_mengisyaratkan_tidak_warna_kulit_gelap-sedang",
        "alias": "wanita_mengisyaratkan_tidak_warna_kulit_gelap-sedang_isyarat_perempuan_tangan",
    },
    "\U0001F645\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_no_dark_skin_tone",
        "id": "wanita_mengisyaratkan_tidak_warna_kulit_gelap",
        "alias": "wanita_mengisyaratkan_tidak_warna_kulit_gelap_isyarat_perempuan_tangan",
    },
    "\U0001F646\U0001F3FB": {
        "en": "person_gesturing_ok_light_skin_tone",
        "id": "orang_mengisyaratkan_oke_warna_kulit_cerah",
        "alias": "orang_mengisyaratkan_oke_warna_kulit_cerah_gerakan_tangan",
    },
    "\U0001F646\U0001F3FC": {
        "en": "person_gesturing_ok_medium-light_skin_tone",
        "id": "orang_mengisyaratkan_oke_warna_kulit_cerah-sedang",
        "alias": "orang_mengisyaratkan_oke_warna_kulit_cerah-sedang_gerakan_tangan",
    },
    "\U0001F646\U0001F3FD": {
        "en": "person_gesturing_ok_medium_skin_tone",
        "id": "orang_mengisyaratkan_oke_warna_kulit_sedang",
        "alias": "orang_mengisyaratkan_oke_warna_kulit_sedang_gerakan_tangan",
    },
    "\U0001F646\U0001F3FE": {
        "en": "person_gesturing_ok_medium-dark_skin_tone",
        "id": "orang_mengisyaratkan_oke_warna_kulit_gelap-sedang",
        "alias": "orang_mengisyaratkan_oke_warna_kulit_gelap-sedang_gerakan_tangan",
    },
    "\U0001F646\U0001F3FF": {
        "en": "person_gesturing_ok_dark_skin_tone",
        "id": "orang_mengisyaratkan_oke_warna_kulit_gelap",
        "alias": "orang_mengisyaratkan_oke_warna_kulit_gelap_gerakan_tangan",
    },
    "\U0001F646\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_ok_light_skin_tone",
        "id": "pria_mengisyaratkan_oke_warna_kulit_cerah",
        "alias": "pria_mengisyaratkan_oke_warna_kulit_cerah_isyarat_laki-laki_tangan",
    },
    "\U0001F646\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_ok_medium-light_skin_tone",
        "id": "pria_mengisyaratkan_oke_warna_kulit_cerah-sedang",
        "alias": "pria_mengisyaratkan_oke_warna_kulit_cerah-sedang_isyarat_laki-laki_tangan",
    },
    "\U0001F646\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_ok_medium_skin_tone",
        "id": "pria_mengisyaratkan_oke_warna_kulit_sedang",
        "alias": "pria_mengisyaratkan_oke_warna_kulit_sedang_isyarat_laki-laki_tangan",
    },
    "\U0001F646\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_ok_medium-dark_skin_tone",
        "id": "pria_mengisyaratkan_oke_warna_kulit_gelap-sedang",
        "alias": "pria_mengisyaratkan_oke_warna_kulit_gelap-sedang_isyarat_laki-laki_tangan",
    },
    "\U0001F646\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_gesturing_ok_dark_skin_tone",
        "id": "pria_mengisyaratkan_oke_warna_kulit_gelap",
        "alias": "pria_mengisyaratkan_oke_warna_kulit_gelap_isyarat_laki-laki_tangan",
    },
    "\U0001F646\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_ok_light_skin_tone",
        "id": "wanita_mengisyaratkan_oke_warna_kulit_cerah",
        "alias": "wanita_mengisyaratkan_oke_warna_kulit_cerah_isyarat_perempuan_tangan",
    },
    "\U0001F646\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_ok_medium-light_skin_tone",
        "id": "wanita_mengisyaratkan_oke_warna_kulit_cerah-sedang",
        "alias": "wanita_mengisyaratkan_oke_warna_kulit_cerah-sedang_isyarat_perempuan_tangan",
    },
    "\U0001F646\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_ok_medium_skin_tone",
        "id": "wanita_mengisyaratkan_oke_warna_kulit_sedang",
        "alias": "wanita_mengisyaratkan_oke_warna_kulit_sedang_isyarat_perempuan_tangan",
    },
    "\U0001F646\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_ok_medium-dark_skin_tone",
        "id": "wanita_mengisyaratkan_oke_warna_kulit_gelap-sedang",
        "alias": "wanita_mengisyaratkan_oke_warna_kulit_gelap-sedang_isyarat_perempuan_tangan",
    },
    "\U0001F646\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_gesturing_ok_dark_skin_tone",
        "id": "wanita_mengisyaratkan_oke_warna_kulit_gelap",
        "alias": "wanita_mengisyaratkan_oke_warna_kulit_gelap_isyarat_perempuan_tangan",
    },
    "\U0001F481\U0001F3FB": {
        "en": "person_tipping_hand_light_skin_tone",
        "id": "orang_menengadahkan_tangan_warna_kulit_cerah",
        "alias": "orang_menengadahkan_tangan_warna_kulit_cerah_bantuan_informasi_resepsionis",
    },
    "\U0001F481\U0001F3FC": {
        "en": "person_tipping_hand_medium-light_skin_tone",
        "id": "orang_menengadahkan_tangan_warna_kulit_cerah-sedang",
        "alias": "orang_menengadahkan_tangan_warna_kulit_cerah-sedang_bantuan_informasi_resepsionis",
    },
    "\U0001F481\U0001F3FD": {
        "en": "person_tipping_hand_medium_skin_tone",
        "id": "orang_menengadahkan_tangan_warna_kulit_sedang",
        "alias": "orang_menengadahkan_tangan_warna_kulit_sedang_bantuan_informasi_resepsionis",
    },
    "\U0001F481\U0001F3FE": {
        "en": "person_tipping_hand_medium-dark_skin_tone",
        "id": "orang_menengadahkan_tangan_warna_kulit_gelap-sedang",
        "alias": "orang_menengadahkan_tangan_warna_kulit_gelap-sedang_bantuan_informasi_resepsionis",
    },
    "\U0001F481\U0001F3FF": {
        "en": "person_tipping_hand_dark_skin_tone",
        "id": "orang_menengadahkan_tangan_warna_kulit_gelap",
        "alias": "orang_menengadahkan_tangan_warna_kulit_gelap_bantuan_informasi_resepsionis",
    },
    "\U0001F481\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_tipping_hand_light_skin_tone",
        "id": "pria_menengadahkan_tangan_warna_kulit_cerah",
        "alias": "pria_menengadahkan_tangan_warna_kulit_cerah_bantuan_isyarat_laki-laki",
    },
    "\U0001F481\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_tipping_hand_medium-light_skin_tone",
        "id": "pria_menengadahkan_tangan_warna_kulit_cerah-sedang",
        "alias": "pria_menengadahkan_tangan_warna_kulit_cerah-sedang_bantuan_isyarat_laki-laki",
    },
    "\U0001F481\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_tipping_hand_medium_skin_tone",
        "id": "pria_menengadahkan_tangan_warna_kulit_sedang",
        "alias": "pria_menengadahkan_tangan_warna_kulit_sedang_bantuan_isyarat_laki-laki",
    },
    "\U0001F481\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_tipping_hand_medium-dark_skin_tone",
        "id": "pria_menengadahkan_tangan_warna_kulit_gelap-sedang",
        "alias": "pria_menengadahkan_tangan_warna_kulit_gelap-sedang_bantuan_isyarat_laki-laki",
    },
    "\U0001F481\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_tipping_hand_dark_skin_tone",
        "id": "pria_menengadahkan_tangan_warna_kulit_gelap",
        "alias": "pria_menengadahkan_tangan_warna_kulit_gelap_bantuan_isyarat_laki-laki",
    },
    "\U0001F481\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_tipping_hand_light_skin_tone",
        "id": "wanita_menengadahkan_tangan_warna_kulit_cerah",
        "alias": "wanita_menengadahkan_tangan_warna_kulit_cerah_bantuan_isyarat_perempuan",
    },
    "\U0001F481\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_tipping_hand_medium-light_skin_tone",
        "id": "wanita_menengadahkan_tangan_warna_kulit_cerah-sedang",
        "alias": "wanita_menengadahkan_tangan_warna_kulit_cerah-sedang_bantuan_isyarat_perempuan",
    },
    "\U0001F481\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_tipping_hand_medium_skin_tone",
        "id": "wanita_menengadahkan_tangan_warna_kulit_sedang",
        "alias": "wanita_menengadahkan_tangan_warna_kulit_sedang_bantuan_isyarat_perempuan",
    },
    "\U0001F481\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_tipping_hand_medium-dark_skin_tone",
        "id": "wanita_menengadahkan_tangan_warna_kulit_gelap-sedang",
        "alias": "wanita_menengadahkan_tangan_warna_kulit_gelap-sedang_bantuan_isyarat_perempuan",
    },
    "\U0001F481\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_tipping_hand_dark_skin_tone",
        "id": "wanita_menengadahkan_tangan_warna_kulit_gelap",
        "alias": "wanita_menengadahkan_tangan_warna_kulit_gelap_bantuan_isyarat_perempuan",
    },
    "\U0001F64B\U0001F3FB": {
        "en": "person_raising_hand_light_skin_tone",
        "id": "orang_mengangkat_tangan_warna_kulit_cerah",
        "alias": "orang_mengangkat_tangan_warna_kulit_cerah_angkat_gerakan_senang",
    },
    "\U0001F64B\U0001F3FC": {
        "en": "person_raising_hand_medium-light_skin_tone",
        "id": "orang_mengangkat_tangan_warna_kulit_cerah-sedang",
        "alias": "orang_mengangkat_tangan_warna_kulit_cerah-sedang_angkat_gerakan_senang",
    },
    "\U0001F64B\U0001F3FD": {
        "en": "person_raising_hand_medium_skin_tone",
        "id": "orang_mengangkat_tangan_warna_kulit_sedang",
        "alias": "orang_mengangkat_tangan_warna_kulit_sedang_angkat_gerakan_senang",
    },
    "\U0001F64B\U0001F3FE": {
        "en": "person_raising_hand_medium-dark_skin_tone",
        "id": "orang_mengangkat_tangan_warna_kulit_gelap-sedang",
        "alias": "orang_mengangkat_tangan_warna_kulit_gelap-sedang_angkat_gerakan_senang",
    },
    "\U0001F64B\U0001F3FF": {
        "en": "person_raising_hand_dark_skin_tone",
        "id": "orang_mengangkat_tangan_warna_kulit_gelap",
        "alias": "orang_mengangkat_tangan_warna_kulit_gelap_angkat_gerakan_senang",
    },
    "\U0001F64B\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_raising_hand_light_skin_tone",
        "id": "pria_mengangkat_tangan_warna_kulit_cerah",
        "alias": "pria_mengangkat_tangan_warna_kulit_cerah_angkat_isyarat_laki-laki",
    },
    "\U0001F64B\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_raising_hand_medium-light_skin_tone",
        "id": "pria_mengangkat_tangan_warna_kulit_cerah-sedang",
        "alias": "pria_mengangkat_tangan_warna_kulit_cerah-sedang_angkat_isyarat_laki-laki",
    },
    "\U0001F64B\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_raising_hand_medium_skin_tone",
        "id": "pria_mengangkat_tangan_warna_kulit_sedang",
        "alias": "pria_mengangkat_tangan_warna_kulit_sedang_angkat_isyarat_laki-laki",
    },
    "\U0001F64B\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_raising_hand_medium-dark_skin_tone",
        "id": "pria_mengangkat_tangan_warna_kulit_gelap-sedang",
        "alias": "pria_mengangkat_tangan_warna_kulit_gelap-sedang_angkat_isyarat_laki-laki",
    },
    "\U0001F64B\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_raising_hand_dark_skin_tone",
        "id": "pria_mengangkat_tangan_warna_kulit_gelap",
        "alias": "pria_mengangkat_tangan_warna_kulit_gelap_angkat_isyarat_laki-laki",
    },
    "\U0001F64B\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_raising_hand_light_skin_tone",
        "id": "wanita_mengangkat_tangan_warna_kulit_cerah",
        "alias": "wanita_mengangkat_tangan_warna_kulit_cerah_angkat_isyarat_perempuan",
    },
    "\U0001F64B\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_raising_hand_medium-light_skin_tone",
        "id": "wanita_mengangkat_tangan_warna_kulit_cerah-sedang",
        "alias": "wanita_mengangkat_tangan_warna_kulit_cerah-sedang_angkat_isyarat_perempuan",
    },
    "\U0001F64B\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_raising_hand_medium_skin_tone",
        "id": "wanita_mengangkat_tangan_warna_kulit_sedang",
        "alias": "wanita_mengangkat_tangan_warna_kulit_sedang_angkat_isyarat_perempuan",
    },
    "\U0001F64B\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_raising_hand_medium-dark_skin_tone",
        "id": "wanita_mengangkat_tangan_warna_kulit_gelap-sedang",
        "alias": "wanita_mengangkat_tangan_warna_kulit_gelap-sedang_angkat_isyarat_perempuan",
    },
    "\U0001F64B\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_raising_hand_dark_skin_tone",
        "id": "wanita_mengangkat_tangan_warna_kulit_gelap",
        "alias": "wanita_mengangkat_tangan_warna_kulit_gelap_angkat_isyarat_perempuan",
    },
    "\U0001F9CF\U0001F3FB": {
        "en": "deaf_person_light_skin_tone",
        "id": "orang_tuli_warna_kulit_cerah",
        "alias": "orang_tuli_warna_kulit_cerah_aksesibilitas_dengar_kuping_telinga_tunarungu",
    },
    "\U0001F9CF\U0001F3FC": {
        "en": "deaf_person_medium-light_skin_tone",
        "id": "orang_tuli_warna_kulit_cerah-sedang",
        "alias": "orang_tuli_warna_kulit_cerah-sedang_aksesibilitas_dengar_kuping_telinga_tunarungu",
    },
    "\U0001F9CF\U0001F3FD": {
        "en": "deaf_person_medium_skin_tone",
        "id": "orang_tuli_warna_kulit_sedang",
        "alias": "orang_tuli_warna_kulit_sedang_aksesibilitas_dengar_kuping_telinga_tunarungu",
    },
    "\U0001F9CF\U0001F3FE": {
        "en": "deaf_person_medium-dark_skin_tone",
        "id": "orang_tuli_warna_kulit_gelap-sedang",
        "alias": "orang_tuli_warna_kulit_gelap-sedang_aksesibilitas_dengar_kuping_telinga_tunarungu",
    },
    "\U0001F9CF\U0001F3FF": {
        "en": "deaf_person_dark_skin_tone",
        "id": "orang_tuli_warna_kulit_gelap",
        "alias": "orang_tuli_warna_kulit_gelap_aksesibilitas_dengar_kuping_telinga_tunarungu",
    },
    "\U0001F9CF\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "deaf_man_light_skin_tone",
        "id": "pria_tuli_warna_kulit_cerah",
        "alias": "pria_tuli_warna_kulit_cerah_lelaki_tunarungu",
    },
    "\U0001F9CF\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "deaf_man_medium-light_skin_tone",
        "id": "pria_tuli_warna_kulit_cerah-sedang",
        "alias": "pria_tuli_warna_kulit_cerah-sedang_lelaki_tunarungu",
    },
    "\U0001F9CF\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "deaf_man_medium_skin_tone",
        "id": "pria_tuli_warna_kulit_sedang",
        "alias": "pria_tuli_warna_kulit_sedang_lelaki_tunarungu",
    },
    "\U0001F9CF\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "deaf_man_medium-dark_skin_tone",
        "id": "pria_tuli_warna_kulit_gelap-sedang",
        "alias": "pria_tuli_warna_kulit_gelap-sedang_lelaki_tunarungu",
    },
    "\U0001F9CF\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "deaf_man_dark_skin_tone",
        "id": "pria_tuli_warna_kulit_gelap",
        "alias": "pria_tuli_warna_kulit_gelap_lelaki_tunarungu",
    },
    "\U0001F9CF\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "deaf_woman_light_skin_tone",
        "id": "wanita_tuli_warna_kulit_cerah",
        "alias": "wanita_tuli_warna_kulit_cerah_perempuan_tunarungu",
    },
    "\U0001F9CF\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "deaf_woman_medium-light_skin_tone",
        "id": "wanita_tuli_warna_kulit_cerah-sedang",
        "alias": "wanita_tuli_warna_kulit_cerah-sedang_perempuan_tunarungu",
    },
    "\U0001F9CF\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "deaf_woman_medium_skin_tone",
        "id": "wanita_tuli_warna_kulit_sedang",
        "alias": "wanita_tuli_warna_kulit_sedang_perempuan_tunarungu",
    },
    "\U0001F9CF\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "deaf_woman_medium-dark_skin_tone",
        "id": "wanita_tuli_warna_kulit_gelap-sedang",
        "alias": "wanita_tuli_warna_kulit_gelap-sedang_perempuan_tunarungu",
    },
    "\U0001F9CF\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "deaf_woman_dark_skin_tone",
        "id": "wanita_tuli_warna_kulit_gelap",
        "alias": "wanita_tuli_warna_kulit_gelap_perempuan_tunarungu",
    },
    "\U0001F647\U0001F3FB": {
        "en": "person_bowing_light_skin_tone",
        "id": "orang_membungkuk_warna_kulit_cerah",
        "alias": "orang_membungkuk_warna_kulit_cerah_bungkuk_gerakan_maaf_nunduk_sori_tunduk",
    },
    "\U0001F647\U0001F3FC": {
        "en": "person_bowing_medium-light_skin_tone",
        "id": "orang_membungkuk_warna_kulit_cerah-sedang",
        "alias": "orang_membungkuk_warna_kulit_cerah-sedang_bungkuk_gerakan_maaf_nunduk_sori_tunduk",
    },
    "\U0001F647\U0001F3FD": {
        "en": "person_bowing_medium_skin_tone",
        "id": "orang_membungkuk_warna_kulit_sedang",
        "alias": "orang_membungkuk_warna_kulit_sedang_bungkuk_gerakan_maaf_nunduk_sori_tunduk",
    },
    "\U0001F647\U0001F3FE": {
        "en": "person_bowing_medium-dark_skin_tone",
        "id": "orang_membungkuk_warna_kulit_gelap-sedang",
        "alias": "orang_membungkuk_warna_kulit_gelap-sedang_bungkuk_gerakan_maaf_nunduk_sori_tunduk",
    },
    "\U0001F647\U0001F3FF": {
        "en": "person_bowing_dark_skin_tone",
        "id": "orang_membungkuk_warna_kulit_gelap",
        "alias": "orang_membungkuk_warna_kulit_gelap_bungkuk_gerakan_maaf_nunduk_sori_tunduk",
    },
    "\U0001F647\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bowing_light_skin_tone",
        "id": "pria_membungkuk_warna_kulit_cerah",
        "alias": "pria_membungkuk_warna_kulit_cerah_isyarat_laki-laki_maaf",
    },
    "\U0001F647\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bowing_medium-light_skin_tone",
        "id": "pria_membungkuk_warna_kulit_cerah-sedang",
        "alias": "pria_membungkuk_warna_kulit_cerah-sedang_isyarat_laki-laki_maaf",
    },
    "\U0001F647\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bowing_medium_skin_tone",
        "id": "pria_membungkuk_warna_kulit_sedang",
        "alias": "pria_membungkuk_warna_kulit_sedang_isyarat_laki-laki_maaf",
    },
    "\U0001F647\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bowing_medium-dark_skin_tone",
        "id": "pria_membungkuk_warna_kulit_gelap-sedang",
        "alias": "pria_membungkuk_warna_kulit_gelap-sedang_isyarat_laki-laki_maaf",
    },
    "\U0001F647\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bowing_dark_skin_tone",
        "id": "pria_membungkuk_warna_kulit_gelap",
        "alias": "pria_membungkuk_warna_kulit_gelap_isyarat_laki-laki_maaf",
    },
    "\U0001F647\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bowing_light_skin_tone",
        "id": "wanita_membungkuk_warna_kulit_cerah",
        "alias": "wanita_membungkuk_warna_kulit_cerah_isyarat_maaf_perempuan",
    },
    "\U0001F647\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bowing_medium-light_skin_tone",
        "id": "wanita_membungkuk_warna_kulit_cerah-sedang",
        "alias": "wanita_membungkuk_warna_kulit_cerah-sedang_isyarat_maaf_perempuan",
    },
    "\U0001F647\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bowing_medium_skin_tone",
        "id": "wanita_membungkuk_warna_kulit_sedang",
        "alias": "wanita_membungkuk_warna_kulit_sedang_isyarat_maaf_perempuan",
    },
    "\U0001F647\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bowing_medium-dark_skin_tone",
        "id": "wanita_membungkuk_warna_kulit_gelap-sedang",
        "alias": "wanita_membungkuk_warna_kulit_gelap-sedang_isyarat_maaf_perempuan",
    },
    "\U0001F647\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bowing_dark_skin_tone",
        "id": "wanita_membungkuk_warna_kulit_gelap",
        "alias": "wanita_membungkuk_warna_kulit_gelap_isyarat_maaf_perempuan",
    },
    "\U0001F926\U0001F3FB": {
        "en": "person_facepalming_light_skin_tone",
        "id": "orang_tepuk_jidat_warna_kulit_cerah",
        "alias": "orang_tepuk_jidat_warna_kulit_cerah_cape_deh_capedeh_capek_yah",
    },
    "\U0001F926\U0001F3FC": {
        "en": "person_facepalming_medium-light_skin_tone",
        "id": "orang_tepuk_jidat_warna_kulit_cerah-sedang",
        "alias": "orang_tepuk_jidat_warna_kulit_cerah-sedang_cape_deh_capedeh_capek_yah",
    },
    "\U0001F926\U0001F3FD": {
        "en": "person_facepalming_medium_skin_tone",
        "id": "orang_tepuk_jidat_warna_kulit_sedang",
        "alias": "orang_tepuk_jidat_warna_kulit_sedang_cape_deh_capedeh_capek_yah",
    },
    "\U0001F926\U0001F3FE": {
        "en": "person_facepalming_medium-dark_skin_tone",
        "id": "orang_tepuk_jidat_warna_kulit_gelap-sedang",
        "alias": "orang_tepuk_jidat_warna_kulit_gelap-sedang_cape_deh_capedeh_capek_yah",
    },
    "\U0001F926\U0001F3FF": {
        "en": "person_facepalming_dark_skin_tone",
        "id": "orang_tepuk_jidat_warna_kulit_gelap",
        "alias": "orang_tepuk_jidat_warna_kulit_gelap_cape_deh_capedeh_capek_yah",
    },
    "\U0001F926\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_facepalming_light_skin_tone",
        "id": "pria_tepuk_jidat_warna_kulit_cerah",
        "alias": "pria_tepuk_jidat_warna_kulit_cerah_isyarat_laki-laki_tangan",
    },
    "\U0001F926\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_facepalming_medium-light_skin_tone",
        "id": "pria_tepuk_jidat_warna_kulit_cerah-sedang",
        "alias": "pria_tepuk_jidat_warna_kulit_cerah-sedang_isyarat_laki-laki_tangan",
    },
    "\U0001F926\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_facepalming_medium_skin_tone",
        "id": "pria_tepuk_jidat_warna_kulit_sedang",
        "alias": "pria_tepuk_jidat_warna_kulit_sedang_isyarat_laki-laki_tangan",
    },
    "\U0001F926\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_facepalming_medium-dark_skin_tone",
        "id": "pria_tepuk_jidat_warna_kulit_gelap-sedang",
        "alias": "pria_tepuk_jidat_warna_kulit_gelap-sedang_isyarat_laki-laki_tangan",
    },
    "\U0001F926\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_facepalming_dark_skin_tone",
        "id": "pria_tepuk_jidat_warna_kulit_gelap",
        "alias": "pria_tepuk_jidat_warna_kulit_gelap_isyarat_laki-laki_tangan",
    },
    "\U0001F926\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_facepalming_light_skin_tone",
        "id": "wanita_tepuk_jidat_warna_kulit_cerah",
        "alias": "wanita_tepuk_jidat_warna_kulit_cerah_isyarat_perempuan_tangan",
    },
    "\U0001F926\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_facepalming_medium-light_skin_tone",
        "id": "wanita_tepuk_jidat_warna_kulit_cerah-sedang",
        "alias": "wanita_tepuk_jidat_warna_kulit_cerah-sedang_isyarat_perempuan_tangan",
    },
    "\U0001F926\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_facepalming_medium_skin_tone",
        "id": "wanita_tepuk_jidat_warna_kulit_sedang",
        "alias": "wanita_tepuk_jidat_warna_kulit_sedang_isyarat_perempuan_tangan",
    },
    "\U0001F926\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_facepalming_medium-dark_skin_tone",
        "id": "wanita_tepuk_jidat_warna_kulit_gelap-sedang",
        "alias": "wanita_tepuk_jidat_warna_kulit_gelap-sedang_isyarat_perempuan_tangan",
    },
    "\U0001F926\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_facepalming_dark_skin_tone",
        "id": "wanita_tepuk_jidat_warna_kulit_gelap",
        "alias": "wanita_tepuk_jidat_warna_kulit_gelap_isyarat_perempuan_tangan",
    },
    "\U0001F937\U0001F3FB": {
        "en": "person_shrugging_light_skin_tone",
        "id": "orang_mengangkat_bahu_warna_kulit_cerah",
        "alias": "orang_mengangkat_bahu_warna_kulit_cerah_bingung_entah_nggak_tahu_tidak",
    },
    "\U0001F937\U0001F3FC": {
        "en": "person_shrugging_medium-light_skin_tone",
        "id": "orang_mengangkat_bahu_warna_kulit_cerah-sedang",
        "alias": "orang_mengangkat_bahu_warna_kulit_cerah-sedang_bingung_entah_nggak_tahu_tidak",
    },
    "\U0001F937\U0001F3FD": {
        "en": "person_shrugging_medium_skin_tone",
        "id": "orang_mengangkat_bahu_warna_kulit_sedang",
        "alias": "orang_mengangkat_bahu_warna_kulit_sedang_bingung_entah_nggak_tahu_tidak",
    },
    "\U0001F937\U0001F3FE": {
        "en": "person_shrugging_medium-dark_skin_tone",
        "id": "orang_mengangkat_bahu_warna_kulit_gelap-sedang",
        "alias": "orang_mengangkat_bahu_warna_kulit_gelap-sedang_bingung_entah_nggak_tahu_tidak",
    },
    "\U0001F937\U0001F3FF": {
        "en": "person_shrugging_dark_skin_tone",
        "id": "orang_mengangkat_bahu_warna_kulit_gelap",
        "alias": "orang_mengangkat_bahu_warna_kulit_gelap_bingung_entah_nggak_tahu_tidak",
    },
    "\U0001F937\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_shrugging_light_skin_tone",
        "id": "pria_mengangkat_bahu_warna_kulit_cerah",
        "alias": "pria_mengangkat_bahu_warna_kulit_cerah_angkat_isyarat_laki-laki",
    },
    "\U0001F937\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_shrugging_medium-light_skin_tone",
        "id": "pria_mengangkat_bahu_warna_kulit_cerah-sedang",
        "alias": "pria_mengangkat_bahu_warna_kulit_cerah-sedang_angkat_isyarat_laki-laki",
    },
    "\U0001F937\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_shrugging_medium_skin_tone",
        "id": "pria_mengangkat_bahu_warna_kulit_sedang",
        "alias": "pria_mengangkat_bahu_warna_kulit_sedang_angkat_isyarat_laki-laki",
    },
    "\U0001F937\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_shrugging_medium-dark_skin_tone",
        "id": "pria_mengangkat_bahu_warna_kulit_gelap-sedang",
        "alias": "pria_mengangkat_bahu_warna_kulit_gelap-sedang_angkat_isyarat_laki-laki",
    },
    "\U0001F937\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_shrugging_dark_skin_tone",
        "id": "pria_mengangkat_bahu_warna_kulit_gelap",
        "alias": "pria_mengangkat_bahu_warna_kulit_gelap_angkat_isyarat_laki-laki",
    },
    "\U0001F937\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_shrugging_light_skin_tone",
        "id": "wanita_mengangkat_bahu_warna_kulit_cerah",
        "alias": "wanita_mengangkat_bahu_warna_kulit_cerah_angkat_isyarat_perempuan",
    },
    "\U0001F937\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_shrugging_medium-light_skin_tone",
        "id": "wanita_mengangkat_bahu_warna_kulit_cerah-sedang",
        "alias": "wanita_mengangkat_bahu_warna_kulit_cerah-sedang_angkat_isyarat_perempuan",
    },
    "\U0001F937\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_shrugging_medium_skin_tone",
        "id": "wanita_mengangkat_bahu_warna_kulit_sedang",
        "alias": "wanita_mengangkat_bahu_warna_kulit_sedang_angkat_isyarat_perempuan",
    },
    "\U0001F937\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_shrugging_medium-dark_skin_tone",
        "id": "wanita_mengangkat_bahu_warna_kulit_gelap-sedang",
        "alias": "wanita_mengangkat_bahu_warna_kulit_gelap-sedang_angkat_isyarat_perempuan",
    },
    "\U0001F937\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_shrugging_dark_skin_tone",
        "id": "wanita_mengangkat_bahu_warna_kulit_gelap",
        "alias": "wanita_mengangkat_bahu_warna_kulit_gelap_angkat_isyarat_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U00002695\U0000FE0F": {
        "en": "health_worker_light_skin_tone",
        "id": "petugas_kesehatan_warna_kulit_cerah",
        "alias": "petugas_kesehatan_warna_kulit_cerah_dokter_perawat_perawatan_terapis",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002695\U0000FE0F": {
        "en": "health_worker_medium-light_skin_tone",
        "id": "petugas_kesehatan_warna_kulit_cerah-sedang",
        "alias": "petugas_kesehatan_warna_kulit_cerah-sedang_dokter_perawat_perawatan_terapis",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002695\U0000FE0F": {
        "en": "health_worker_medium_skin_tone",
        "id": "petugas_kesehatan_warna_kulit_sedang",
        "alias": "petugas_kesehatan_warna_kulit_sedang_dokter_perawat_perawatan_terapis",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002695\U0000FE0F": {
        "en": "health_worker_medium-dark_skin_tone",
        "id": "petugas_kesehatan_warna_kulit_gelap-sedang",
        "alias": "petugas_kesehatan_warna_kulit_gelap-sedang_dokter_perawat_perawatan_terapis",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002695\U0000FE0F": {
        "en": "health_worker_dark_skin_tone",
        "id": "petugas_kesehatan_warna_kulit_gelap",
        "alias": "petugas_kesehatan_warna_kulit_gelap_dokter_perawat_perawatan_terapis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002695\U0000FE0F": {
        "en": "man_health_worker_light_skin_tone",
        "id": "pekerja_kesehatan_pria_warna_kulit_cerah",
        "alias": "pekerja_kesehatan_pria_warna_kulit_cerah_dokter_laki-laki_perawatan",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002695\U0000FE0F": {
        "en": "man_health_worker_medium-light_skin_tone",
        "id": "pekerja_kesehatan_pria_warna_kulit_cerah-sedang",
        "alias": "pekerja_kesehatan_pria_warna_kulit_cerah-sedang_dokter_laki-laki_perawatan",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002695\U0000FE0F": {
        "en": "man_health_worker_medium_skin_tone",
        "id": "pekerja_kesehatan_pria_warna_kulit_sedang",
        "alias": "pekerja_kesehatan_pria_warna_kulit_sedang_dokter_laki-laki_perawatan",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002695\U0000FE0F": {
        "en": "man_health_worker_medium-dark_skin_tone",
        "id": "pekerja_kesehatan_pria_warna_kulit_gelap-sedang",
        "alias": "pekerja_kesehatan_pria_warna_kulit_gelap-sedang_dokter_laki-laki_perawatan",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002695\U0000FE0F": {
        "en": "man_health_worker_dark_skin_tone",
        "id": "pekerja_kesehatan_pria_warna_kulit_gelap",
        "alias": "pekerja_kesehatan_pria_warna_kulit_gelap_dokter_laki-laki_perawatan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002695\U0000FE0F": {
        "en": "woman_health_worker_light_skin_tone",
        "id": "pekerja_kesehatan_wanita_warna_kulit_cerah",
        "alias": "pekerja_kesehatan_wanita_warna_kulit_cerah_dokter_perawatan_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002695\U0000FE0F": {
        "en": "woman_health_worker_medium-light_skin_tone",
        "id": "pekerja_kesehatan_wanita_warna_kulit_cerah-sedang",
        "alias": "pekerja_kesehatan_wanita_warna_kulit_cerah-sedang_dokter_perawatan_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002695\U0000FE0F": {
        "en": "woman_health_worker_medium_skin_tone",
        "id": "pekerja_kesehatan_wanita_warna_kulit_sedang",
        "alias": "pekerja_kesehatan_wanita_warna_kulit_sedang_dokter_perawatan_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002695\U0000FE0F": {
        "en": "woman_health_worker_medium-dark_skin_tone",
        "id": "pekerja_kesehatan_wanita_warna_kulit_gelap-sedang",
        "alias": "pekerja_kesehatan_wanita_warna_kulit_gelap-sedang_dokter_perawatan_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002695\U0000FE0F": {
        "en": "woman_health_worker_dark_skin_tone",
        "id": "pekerja_kesehatan_wanita_warna_kulit_gelap",
        "alias": "pekerja_kesehatan_wanita_warna_kulit_gelap_dokter_perawatan_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F393": {
        "en": "student_light_skin_tone",
        "id": "murid_warna_kulit_cerah",
        "alias": "murid_warna_kulit_cerah_kelulusan",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F393": {
        "en": "student_medium-light_skin_tone",
        "id": "murid_warna_kulit_cerah-sedang",
        "alias": "murid_warna_kulit_cerah-sedang_kelulusan",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F393": {
        "en": "student_medium_skin_tone",
        "id": "murid_warna_kulit_sedang",
        "alias": "murid_warna_kulit_sedang_kelulusan",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F393": {
        "en": "student_medium-dark_skin_tone",
        "id": "murid_warna_kulit_gelap-sedang",
        "alias": "murid_warna_kulit_gelap-sedang_kelulusan",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F393": {
        "en": "student_dark_skin_tone",
        "id": "murid_warna_kulit_gelap",
        "alias": "murid_warna_kulit_gelap_kelulusan",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F393": {
        "en": "man_student_light_skin_tone",
        "id": "sarjana_pria_warna_kulit_cerah",
        "alias": "sarjana_pria_warna_kulit_cerah_laki-laki_toga_universitas_wisuda",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F393": {
        "en": "man_student_medium-light_skin_tone",
        "id": "sarjana_pria_warna_kulit_cerah-sedang",
        "alias": "sarjana_pria_warna_kulit_cerah-sedang_laki-laki_toga_universitas_wisuda",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F393": {
        "en": "man_student_medium_skin_tone",
        "id": "sarjana_pria_warna_kulit_sedang",
        "alias": "sarjana_pria_warna_kulit_sedang_laki-laki_toga_universitas_wisuda",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F393": {
        "en": "man_student_medium-dark_skin_tone",
        "id": "sarjana_pria_warna_kulit_gelap-sedang",
        "alias": "sarjana_pria_warna_kulit_gelap-sedang_laki-laki_toga_universitas_wisuda",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F393": {
        "en": "man_student_dark_skin_tone",
        "id": "sarjana_pria_warna_kulit_gelap",
        "alias": "sarjana_pria_warna_kulit_gelap_laki-laki_toga_universitas_wisuda",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F393": {
        "en": "woman_student_light_skin_tone",
        "id": "sarjana_wanita_warna_kulit_cerah",
        "alias": "sarjana_wanita_warna_kulit_cerah_perempuan_toga_universitas_wisuda",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F393": {
        "en": "woman_student_medium-light_skin_tone",
        "id": "sarjana_wanita_warna_kulit_cerah-sedang",
        "alias": "sarjana_wanita_warna_kulit_cerah-sedang_perempuan_toga_universitas_wisuda",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F393": {
        "en": "woman_student_medium_skin_tone",
        "id": "sarjana_wanita_warna_kulit_sedang",
        "alias": "sarjana_wanita_warna_kulit_sedang_perempuan_toga_universitas_wisuda",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F393": {
        "en": "woman_student_medium-dark_skin_tone",
        "id": "sarjana_wanita_warna_kulit_gelap-sedang",
        "alias": "sarjana_wanita_warna_kulit_gelap-sedang_perempuan_toga_universitas_wisuda",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F393": {
        "en": "woman_student_dark_skin_tone",
        "id": "sarjana_wanita_warna_kulit_gelap",
        "alias": "sarjana_wanita_warna_kulit_gelap_perempuan_toga_universitas_wisuda",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F3EB": {
        "en": "teacher_light_skin_tone",
        "id": "guru_warna_kulit_cerah",
        "alias": "guru_warna_kulit_cerah_dosen_instruktur",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F3EB": {
        "en": "teacher_medium-light_skin_tone",
        "id": "guru_warna_kulit_cerah-sedang",
        "alias": "guru_warna_kulit_cerah-sedang_dosen_instruktur",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F3EB": {
        "en": "teacher_medium_skin_tone",
        "id": "guru_warna_kulit_sedang",
        "alias": "guru_warna_kulit_sedang_dosen_instruktur",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F3EB": {
        "en": "teacher_medium-dark_skin_tone",
        "id": "guru_warna_kulit_gelap-sedang",
        "alias": "guru_warna_kulit_gelap-sedang_dosen_instruktur",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F3EB": {
        "en": "teacher_dark_skin_tone",
        "id": "guru_warna_kulit_gelap",
        "alias": "guru_warna_kulit_gelap_dosen_instruktur",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F3EB": {
        "en": "man_teacher_light_skin_tone",
        "id": "pengajar_pria_warna_kulit_cerah",
        "alias": "pengajar_pria_warna_kulit_cerah_laki-laki_sekolah",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F3EB": {
        "en": "man_teacher_medium-light_skin_tone",
        "id": "pengajar_pria_warna_kulit_cerah-sedang",
        "alias": "pengajar_pria_warna_kulit_cerah-sedang_laki-laki_sekolah",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F3EB": {
        "en": "man_teacher_medium_skin_tone",
        "id": "pengajar_pria_warna_kulit_sedang",
        "alias": "pengajar_pria_warna_kulit_sedang_laki-laki_sekolah",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F3EB": {
        "en": "man_teacher_medium-dark_skin_tone",
        "id": "pengajar_pria_warna_kulit_gelap-sedang",
        "alias": "pengajar_pria_warna_kulit_gelap-sedang_laki-laki_sekolah",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F3EB": {
        "en": "man_teacher_dark_skin_tone",
        "id": "pengajar_pria_warna_kulit_gelap",
        "alias": "pengajar_pria_warna_kulit_gelap_laki-laki_sekolah",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F3EB": {
        "en": "woman_teacher_light_skin_tone",
        "id": "pengajar_wanita_warna_kulit_cerah",
        "alias": "pengajar_wanita_warna_kulit_cerah_perempuan_sekolah",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F3EB": {
        "en": "woman_teacher_medium-light_skin_tone",
        "id": "pengajar_wanita_warna_kulit_cerah-sedang",
        "alias": "pengajar_wanita_warna_kulit_cerah-sedang_perempuan_sekolah",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F3EB": {
        "en": "woman_teacher_medium_skin_tone",
        "id": "pengajar_wanita_warna_kulit_sedang",
        "alias": "pengajar_wanita_warna_kulit_sedang_perempuan_sekolah",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F3EB": {
        "en": "woman_teacher_medium-dark_skin_tone",
        "id": "pengajar_wanita_warna_kulit_gelap-sedang",
        "alias": "pengajar_wanita_warna_kulit_gelap-sedang_perempuan_sekolah",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F3EB": {
        "en": "woman_teacher_dark_skin_tone",
        "id": "pengajar_wanita_warna_kulit_gelap",
        "alias": "pengajar_wanita_warna_kulit_gelap_perempuan_sekolah",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U00002696\U0000FE0F": {
        "en": "judge_light_skin_tone",
        "id": "hakim_warna_kulit_cerah",
        "alias": "hakim_warna_kulit_cerah_timbangan",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002696\U0000FE0F": {
        "en": "judge_medium-light_skin_tone",
        "id": "hakim_warna_kulit_cerah-sedang",
        "alias": "hakim_warna_kulit_cerah-sedang_timbangan",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002696\U0000FE0F": {
        "en": "judge_medium_skin_tone",
        "id": "hakim_warna_kulit_sedang",
        "alias": "hakim_warna_kulit_sedang_timbangan",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002696\U0000FE0F": {
        "en": "judge_medium-dark_skin_tone",
        "id": "hakim_warna_kulit_gelap-sedang",
        "alias": "hakim_warna_kulit_gelap-sedang_timbangan",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002696\U0000FE0F": {
        "en": "judge_dark_skin_tone",
        "id": "hakim_warna_kulit_gelap",
        "alias": "hakim_warna_kulit_gelap_timbangan",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002696\U0000FE0F": {
        "en": "man_judge_light_skin_tone",
        "id": "hakim_pria_warna_kulit_cerah",
        "alias": "hakim_pria_warna_kulit_cerah_hukum_laki-laki_pengadilan",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002696\U0000FE0F": {
        "en": "man_judge_medium-light_skin_tone",
        "id": "hakim_pria_warna_kulit_cerah-sedang",
        "alias": "hakim_pria_warna_kulit_cerah-sedang_hukum_laki-laki_pengadilan",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002696\U0000FE0F": {
        "en": "man_judge_medium_skin_tone",
        "id": "hakim_pria_warna_kulit_sedang",
        "alias": "hakim_pria_warna_kulit_sedang_hukum_laki-laki_pengadilan",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002696\U0000FE0F": {
        "en": "man_judge_medium-dark_skin_tone",
        "id": "hakim_pria_warna_kulit_gelap-sedang",
        "alias": "hakim_pria_warna_kulit_gelap-sedang_hukum_laki-laki_pengadilan",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002696\U0000FE0F": {
        "en": "man_judge_dark_skin_tone",
        "id": "hakim_pria_warna_kulit_gelap",
        "alias": "hakim_pria_warna_kulit_gelap_hukum_laki-laki_pengadilan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002696\U0000FE0F": {
        "en": "woman_judge_light_skin_tone",
        "id": "hakim_wanita_warna_kulit_cerah",
        "alias": "hakim_wanita_warna_kulit_cerah_hukum_pengadilan_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002696\U0000FE0F": {
        "en": "woman_judge_medium-light_skin_tone",
        "id": "hakim_wanita_warna_kulit_cerah-sedang",
        "alias": "hakim_wanita_warna_kulit_cerah-sedang_hukum_pengadilan_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002696\U0000FE0F": {
        "en": "woman_judge_medium_skin_tone",
        "id": "hakim_wanita_warna_kulit_sedang",
        "alias": "hakim_wanita_warna_kulit_sedang_hukum_pengadilan_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002696\U0000FE0F": {
        "en": "woman_judge_medium-dark_skin_tone",
        "id": "hakim_wanita_warna_kulit_gelap-sedang",
        "alias": "hakim_wanita_warna_kulit_gelap-sedang_hukum_pengadilan_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002696\U0000FE0F": {
        "en": "woman_judge_dark_skin_tone",
        "id": "hakim_wanita_warna_kulit_gelap",
        "alias": "hakim_wanita_warna_kulit_gelap_hukum_pengadilan_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F33E": {
        "en": "farmer_light_skin_tone",
        "id": "petani_warna_kulit_cerah",
        "alias": "petani_warna_kulit_cerah_pekebun_peternak",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F33E": {
        "en": "farmer_medium-light_skin_tone",
        "id": "petani_warna_kulit_cerah-sedang",
        "alias": "petani_warna_kulit_cerah-sedang_pekebun_peternak",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F33E": {
        "en": "farmer_medium_skin_tone",
        "id": "petani_warna_kulit_sedang",
        "alias": "petani_warna_kulit_sedang_pekebun_peternak",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F33E": {
        "en": "farmer_medium-dark_skin_tone",
        "id": "petani_warna_kulit_gelap-sedang",
        "alias": "petani_warna_kulit_gelap-sedang_pekebun_peternak",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F33E": {
        "en": "farmer_dark_skin_tone",
        "id": "petani_warna_kulit_gelap",
        "alias": "petani_warna_kulit_gelap_pekebun_peternak",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F33E": {
        "en": "man_farmer_light_skin_tone",
        "id": "petani_pria_warna_kulit_cerah",
        "alias": "petani_pria_warna_kulit_cerah_laki-laki_padi_sawah",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F33E": {
        "en": "man_farmer_medium-light_skin_tone",
        "id": "petani_pria_warna_kulit_cerah-sedang",
        "alias": "petani_pria_warna_kulit_cerah-sedang_laki-laki_padi_sawah",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F33E": {
        "en": "man_farmer_medium_skin_tone",
        "id": "petani_pria_warna_kulit_sedang",
        "alias": "petani_pria_warna_kulit_sedang_laki-laki_padi_sawah",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F33E": {
        "en": "man_farmer_medium-dark_skin_tone",
        "id": "petani_pria_warna_kulit_gelap-sedang",
        "alias": "petani_pria_warna_kulit_gelap-sedang_laki-laki_padi_sawah",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F33E": {
        "en": "man_farmer_dark_skin_tone",
        "id": "petani_pria_warna_kulit_gelap",
        "alias": "petani_pria_warna_kulit_gelap_laki-laki_padi_sawah",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F33E": {
        "en": "woman_farmer_light_skin_tone",
        "id": "petani_wanita_warna_kulit_cerah",
        "alias": "petani_wanita_warna_kulit_cerah_padi_perempuan_sawah",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F33E": {
        "en": "woman_farmer_medium-light_skin_tone",
        "id": "petani_wanita_warna_kulit_cerah-sedang",
        "alias": "petani_wanita_warna_kulit_cerah-sedang_padi_perempuan_sawah",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F33E": {
        "en": "woman_farmer_medium_skin_tone",
        "id": "petani_wanita_warna_kulit_sedang",
        "alias": "petani_wanita_warna_kulit_sedang_padi_perempuan_sawah",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F33E": {
        "en": "woman_farmer_medium-dark_skin_tone",
        "id": "petani_wanita_warna_kulit_gelap-sedang",
        "alias": "petani_wanita_warna_kulit_gelap-sedang_padi_perempuan_sawah",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F33E": {
        "en": "woman_farmer_dark_skin_tone",
        "id": "petani_wanita_warna_kulit_gelap",
        "alias": "petani_wanita_warna_kulit_gelap_padi_perempuan_sawah",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F373": {
        "en": "cook_light_skin_tone",
        "id": "koki_warna_kulit_cerah",
        "alias": "koki_warna_kulit_cerah_chef",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F373": {
        "en": "cook_medium-light_skin_tone",
        "id": "koki_warna_kulit_cerah-sedang",
        "alias": "koki_warna_kulit_cerah-sedang_chef",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F373": {
        "en": "cook_medium_skin_tone",
        "id": "koki_warna_kulit_sedang",
        "alias": "koki_warna_kulit_sedang_chef",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F373": {
        "en": "cook_medium-dark_skin_tone",
        "id": "koki_warna_kulit_gelap-sedang",
        "alias": "koki_warna_kulit_gelap-sedang_chef",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F373": {
        "en": "cook_dark_skin_tone",
        "id": "koki_warna_kulit_gelap",
        "alias": "koki_warna_kulit_gelap_chef",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F373": {
        "en": "man_cook_light_skin_tone",
        "id": "koki_pria_warna_kulit_cerah",
        "alias": "koki_pria_warna_kulit_cerah_dapur_laki-laki_memasak",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F373": {
        "en": "man_cook_medium-light_skin_tone",
        "id": "koki_pria_warna_kulit_cerah-sedang",
        "alias": "koki_pria_warna_kulit_cerah-sedang_dapur_laki-laki_memasak",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F373": {
        "en": "man_cook_medium_skin_tone",
        "id": "koki_pria_warna_kulit_sedang",
        "alias": "koki_pria_warna_kulit_sedang_dapur_laki-laki_memasak",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F373": {
        "en": "man_cook_medium-dark_skin_tone",
        "id": "koki_pria_warna_kulit_gelap-sedang",
        "alias": "koki_pria_warna_kulit_gelap-sedang_dapur_laki-laki_memasak",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F373": {
        "en": "man_cook_dark_skin_tone",
        "id": "koki_pria_warna_kulit_gelap",
        "alias": "koki_pria_warna_kulit_gelap_dapur_laki-laki_memasak",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F373": {
        "en": "woman_cook_light_skin_tone",
        "id": "koki_wanita_warna_kulit_cerah",
        "alias": "koki_wanita_warna_kulit_cerah_dapur_memasak_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F373": {
        "en": "woman_cook_medium-light_skin_tone",
        "id": "koki_wanita_warna_kulit_cerah-sedang",
        "alias": "koki_wanita_warna_kulit_cerah-sedang_dapur_memasak_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F373": {
        "en": "woman_cook_medium_skin_tone",
        "id": "koki_wanita_warna_kulit_sedang",
        "alias": "koki_wanita_warna_kulit_sedang_dapur_memasak_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F373": {
        "en": "woman_cook_medium-dark_skin_tone",
        "id": "koki_wanita_warna_kulit_gelap-sedang",
        "alias": "koki_wanita_warna_kulit_gelap-sedang_dapur_memasak_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F373": {
        "en": "woman_cook_dark_skin_tone",
        "id": "koki_wanita_warna_kulit_gelap",
        "alias": "koki_wanita_warna_kulit_gelap_dapur_memasak_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F527": {
        "en": "mechanic_light_skin_tone",
        "id": "mekanik_warna_kulit_cerah",
        "alias": "mekanik_warna_kulit_cerah_pekerja_terlatih_tukang_ledeng_listrik",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F527": {
        "en": "mechanic_medium-light_skin_tone",
        "id": "mekanik_warna_kulit_cerah-sedang",
        "alias": "mekanik_warna_kulit_cerah-sedang_pekerja_terlatih_tukang_ledeng_listrik",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F527": {
        "en": "mechanic_medium_skin_tone",
        "id": "mekanik_warna_kulit_sedang",
        "alias": "mekanik_warna_kulit_sedang_pekerja_terlatih_tukang_ledeng_listrik",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F527": {
        "en": "mechanic_medium-dark_skin_tone",
        "id": "mekanik_warna_kulit_gelap-sedang",
        "alias": "mekanik_warna_kulit_gelap-sedang_pekerja_terlatih_tukang_ledeng_listrik",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F527": {
        "en": "mechanic_dark_skin_tone",
        "id": "mekanik_warna_kulit_gelap",
        "alias": "mekanik_warna_kulit_gelap_pekerja_terlatih_tukang_ledeng_listrik",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F527": {
        "en": "man_mechanic_light_skin_tone",
        "id": "montir_pria_warna_kulit_cerah",
        "alias": "montir_pria_warna_kulit_cerah_laki-laki_perbaikan_tukang",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F527": {
        "en": "man_mechanic_medium-light_skin_tone",
        "id": "montir_pria_warna_kulit_cerah-sedang",
        "alias": "montir_pria_warna_kulit_cerah-sedang_laki-laki_perbaikan_tukang",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F527": {
        "en": "man_mechanic_medium_skin_tone",
        "id": "montir_pria_warna_kulit_sedang",
        "alias": "montir_pria_warna_kulit_sedang_laki-laki_perbaikan_tukang",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F527": {
        "en": "man_mechanic_medium-dark_skin_tone",
        "id": "montir_pria_warna_kulit_gelap-sedang",
        "alias": "montir_pria_warna_kulit_gelap-sedang_laki-laki_perbaikan_tukang",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F527": {
        "en": "man_mechanic_dark_skin_tone",
        "id": "montir_pria_warna_kulit_gelap",
        "alias": "montir_pria_warna_kulit_gelap_laki-laki_perbaikan_tukang",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F527": {
        "en": "woman_mechanic_light_skin_tone",
        "id": "montir_wanita_warna_kulit_cerah",
        "alias": "montir_wanita_warna_kulit_cerah_perbaikan_perempuan_tukang",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F527": {
        "en": "woman_mechanic_medium-light_skin_tone",
        "id": "montir_wanita_warna_kulit_cerah-sedang",
        "alias": "montir_wanita_warna_kulit_cerah-sedang_perbaikan_perempuan_tukang",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F527": {
        "en": "woman_mechanic_medium_skin_tone",
        "id": "montir_wanita_warna_kulit_sedang",
        "alias": "montir_wanita_warna_kulit_sedang_perbaikan_perempuan_tukang",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F527": {
        "en": "woman_mechanic_medium-dark_skin_tone",
        "id": "montir_wanita_warna_kulit_gelap-sedang",
        "alias": "montir_wanita_warna_kulit_gelap-sedang_perbaikan_perempuan_tukang",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F527": {
        "en": "woman_mechanic_dark_skin_tone",
        "id": "montir_wanita_warna_kulit_gelap",
        "alias": "montir_wanita_warna_kulit_gelap_perbaikan_perempuan_tukang",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F3ED": {
        "en": "factory_worker_light_skin_tone",
        "id": "pekerja_pabrik_warna_kulit_cerah",
        "alias": "pekerja_pabrik_warna_kulit_cerah_industri_perakitan",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F3ED": {
        "en": "factory_worker_medium-light_skin_tone",
        "id": "pekerja_pabrik_warna_kulit_cerah-sedang",
        "alias": "pekerja_pabrik_warna_kulit_cerah-sedang_industri_perakitan",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F3ED": {
        "en": "factory_worker_medium_skin_tone",
        "id": "pekerja_pabrik_warna_kulit_sedang",
        "alias": "pekerja_pabrik_warna_kulit_sedang_industri_perakitan",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F3ED": {
        "en": "factory_worker_medium-dark_skin_tone",
        "id": "pekerja_pabrik_warna_kulit_gelap-sedang",
        "alias": "pekerja_pabrik_warna_kulit_gelap-sedang_industri_perakitan",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F3ED": {
        "en": "factory_worker_dark_skin_tone",
        "id": "pekerja_pabrik_warna_kulit_gelap",
        "alias": "pekerja_pabrik_warna_kulit_gelap_industri_perakitan",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F3ED": {
        "en": "man_factory_worker_light_skin_tone",
        "id": "pekerja_pabrik_pria_warna_kulit_cerah",
        "alias": "pekerja_pabrik_pria_warna_kulit_cerah_laki-laki",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F3ED": {
        "en": "man_factory_worker_medium-light_skin_tone",
        "id": "pekerja_pabrik_pria_warna_kulit_cerah-sedang",
        "alias": "pekerja_pabrik_pria_warna_kulit_cerah-sedang_laki-laki",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F3ED": {
        "en": "man_factory_worker_medium_skin_tone",
        "id": "pekerja_pabrik_pria_warna_kulit_sedang",
        "alias": "pekerja_pabrik_pria_warna_kulit_sedang_laki-laki",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F3ED": {
        "en": "man_factory_worker_medium-dark_skin_tone",
        "id": "pekerja_pabrik_pria_warna_kulit_gelap-sedang",
        "alias": "pekerja_pabrik_pria_warna_kulit_gelap-sedang_laki-laki",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F3ED": {
        "en": "man_factory_worker_dark_skin_tone",
        "id": "pekerja_pabrik_pria_warna_kulit_gelap",
        "alias": "pekerja_pabrik_pria_warna_kulit_gelap_laki-laki",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F3ED": {
        "en": "woman_factory_worker_light_skin_tone",
        "id": "pekerja_pabrik_wanita_warna_kulit_cerah",
        "alias": "pekerja_pabrik_wanita_warna_kulit_cerah_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F3ED": {
        "en": "woman_factory_worker_medium-light_skin_tone",
        "id": "pekerja_pabrik_wanita_warna_kulit_cerah-sedang",
        "alias": "pekerja_pabrik_wanita_warna_kulit_cerah-sedang_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F3ED": {
        "en": "woman_factory_worker_medium_skin_tone",
        "id": "pekerja_pabrik_wanita_warna_kulit_sedang",
        "alias": "pekerja_pabrik_wanita_warna_kulit_sedang_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F3ED": {
        "en": "woman_factory_worker_medium-dark_skin_tone",
        "id": "pekerja_pabrik_wanita_warna_kulit_gelap-sedang",
        "alias": "pekerja_pabrik_wanita_warna_kulit_gelap-sedang_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F3ED": {
        "en": "woman_factory_worker_dark_skin_tone",
        "id": "pekerja_pabrik_wanita_warna_kulit_gelap",
        "alias": "pekerja_pabrik_wanita_warna_kulit_gelap_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F4BC": {
        "en": "office_worker_light_skin_tone",
        "id": "pekerja_kantoran_warna_kulit_cerah",
        "alias": "pekerja_kantoran_warna_kulit_cerah_arsitek_bisnis_kerah_putih_manajer",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F4BC": {
        "en": "office_worker_medium-light_skin_tone",
        "id": "pekerja_kantoran_warna_kulit_cerah-sedang",
        "alias": "pekerja_kantoran_warna_kulit_cerah-sedang_arsitek_bisnis_kerah_putih_manajer",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F4BC": {
        "en": "office_worker_medium_skin_tone",
        "id": "pekerja_kantoran_warna_kulit_sedang",
        "alias": "pekerja_kantoran_warna_kulit_sedang_arsitek_bisnis_kerah_putih_manajer",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F4BC": {
        "en": "office_worker_medium-dark_skin_tone",
        "id": "pekerja_kantoran_warna_kulit_gelap-sedang",
        "alias": "pekerja_kantoran_warna_kulit_gelap-sedang_arsitek_bisnis_kerah_putih_manajer",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F4BC": {
        "en": "office_worker_dark_skin_tone",
        "id": "pekerja_kantoran_warna_kulit_gelap",
        "alias": "pekerja_kantoran_warna_kulit_gelap_arsitek_bisnis_kerah_putih_manajer",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F4BC": {
        "en": "man_office_worker_light_skin_tone",
        "id": "pekerja_kantor_pria_warna_kulit_cerah",
        "alias": "pekerja_kantor_pria_warna_kulit_cerah_karyawan_laki-laki",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F4BC": {
        "en": "man_office_worker_medium-light_skin_tone",
        "id": "pekerja_kantor_pria_warna_kulit_cerah-sedang",
        "alias": "pekerja_kantor_pria_warna_kulit_cerah-sedang_karyawan_laki-laki",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F4BC": {
        "en": "man_office_worker_medium_skin_tone",
        "id": "pekerja_kantor_pria_warna_kulit_sedang",
        "alias": "pekerja_kantor_pria_warna_kulit_sedang_karyawan_laki-laki",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F4BC": {
        "en": "man_office_worker_medium-dark_skin_tone",
        "id": "pekerja_kantor_pria_warna_kulit_gelap-sedang",
        "alias": "pekerja_kantor_pria_warna_kulit_gelap-sedang_karyawan_laki-laki",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F4BC": {
        "en": "man_office_worker_dark_skin_tone",
        "id": "pekerja_kantor_pria_warna_kulit_gelap",
        "alias": "pekerja_kantor_pria_warna_kulit_gelap_karyawan_laki-laki",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F4BC": {
        "en": "woman_office_worker_light_skin_tone",
        "id": "pekerja_kantor_wanita_warna_kulit_cerah",
        "alias": "pekerja_kantor_wanita_warna_kulit_cerah_karyawan_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F4BC": {
        "en": "woman_office_worker_medium-light_skin_tone",
        "id": "pekerja_kantor_wanita_warna_kulit_cerah-sedang",
        "alias": "pekerja_kantor_wanita_warna_kulit_cerah-sedang_karyawan_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F4BC": {
        "en": "woman_office_worker_medium_skin_tone",
        "id": "pekerja_kantor_wanita_warna_kulit_sedang",
        "alias": "pekerja_kantor_wanita_warna_kulit_sedang_karyawan_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F4BC": {
        "en": "woman_office_worker_medium-dark_skin_tone",
        "id": "pekerja_kantor_wanita_warna_kulit_gelap-sedang",
        "alias": "pekerja_kantor_wanita_warna_kulit_gelap-sedang_karyawan_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F4BC": {
        "en": "woman_office_worker_dark_skin_tone",
        "id": "pekerja_kantor_wanita_warna_kulit_gelap",
        "alias": "pekerja_kantor_wanita_warna_kulit_gelap_karyawan_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F52C": {
        "en": "scientist_light_skin_tone",
        "id": "ilmuwan_warna_kulit_cerah",
        "alias": "ilmuwan_warna_kulit_cerah_ahli_biologi_fisika_kimia_insinyur",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F52C": {
        "en": "scientist_medium-light_skin_tone",
        "id": "ilmuwan_warna_kulit_cerah-sedang",
        "alias": "ilmuwan_warna_kulit_cerah-sedang_ahli_biologi_fisika_kimia_insinyur",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F52C": {
        "en": "scientist_medium_skin_tone",
        "id": "ilmuwan_warna_kulit_sedang",
        "alias": "ilmuwan_warna_kulit_sedang_ahli_biologi_fisika_kimia_insinyur",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F52C": {
        "en": "scientist_medium-dark_skin_tone",
        "id": "ilmuwan_warna_kulit_gelap-sedang",
        "alias": "ilmuwan_warna_kulit_gelap-sedang_ahli_biologi_fisika_kimia_insinyur",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F52C": {
        "en": "scientist_dark_skin_tone",
        "id": "ilmuwan_warna_kulit_gelap",
        "alias": "ilmuwan_warna_kulit_gelap_ahli_biologi_fisika_kimia_insinyur",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F52C": {
        "en": "man_scientist_light_skin_tone",
        "id": "ilmuwan_pria_warna_kulit_cerah",
        "alias": "ilmuwan_pria_warna_kulit_cerah_laboratorium_laki-laki_sains",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F52C": {
        "en": "man_scientist_medium-light_skin_tone",
        "id": "ilmuwan_pria_warna_kulit_cerah-sedang",
        "alias": "ilmuwan_pria_warna_kulit_cerah-sedang_laboratorium_laki-laki_sains",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F52C": {
        "en": "man_scientist_medium_skin_tone",
        "id": "ilmuwan_pria_warna_kulit_sedang",
        "alias": "ilmuwan_pria_warna_kulit_sedang_laboratorium_laki-laki_sains",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F52C": {
        "en": "man_scientist_medium-dark_skin_tone",
        "id": "ilmuwan_pria_warna_kulit_gelap-sedang",
        "alias": "ilmuwan_pria_warna_kulit_gelap-sedang_laboratorium_laki-laki_sains",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F52C": {
        "en": "man_scientist_dark_skin_tone",
        "id": "ilmuwan_pria_warna_kulit_gelap",
        "alias": "ilmuwan_pria_warna_kulit_gelap_laboratorium_laki-laki_sains",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F52C": {
        "en": "woman_scientist_light_skin_tone",
        "id": "ilmuwan_wanita_warna_kulit_cerah",
        "alias": "ilmuwan_wanita_warna_kulit_cerah_laboratorium_perempuan_sains",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F52C": {
        "en": "woman_scientist_medium-light_skin_tone",
        "id": "ilmuwan_wanita_warna_kulit_cerah-sedang",
        "alias": "ilmuwan_wanita_warna_kulit_cerah-sedang_laboratorium_perempuan_sains",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F52C": {
        "en": "woman_scientist_medium_skin_tone",
        "id": "ilmuwan_wanita_warna_kulit_sedang",
        "alias": "ilmuwan_wanita_warna_kulit_sedang_laboratorium_perempuan_sains",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F52C": {
        "en": "woman_scientist_medium-dark_skin_tone",
        "id": "ilmuwan_wanita_warna_kulit_gelap-sedang",
        "alias": "ilmuwan_wanita_warna_kulit_gelap-sedang_laboratorium_perempuan_sains",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F52C": {
        "en": "woman_scientist_dark_skin_tone",
        "id": "ilmuwan_wanita_warna_kulit_gelap",
        "alias": "ilmuwan_wanita_warna_kulit_gelap_laboratorium_perempuan_sains",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F4BB": {
        "en": "technologist_light_skin_tone",
        "id": "ahli_teknologi_warna_kulit_cerah",
        "alias": "ahli_teknologi_warna_kulit_cerah_pemrogram_penemu_pengembang_perangkat_lunak",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F4BB": {
        "en": "technologist_medium-light_skin_tone",
        "id": "ahli_teknologi_warna_kulit_cerah-sedang",
        "alias": "ahli_teknologi_warna_kulit_cerah-sedang_pemrogram_penemu_pengembang_perangkat_lunak",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F4BB": {
        "en": "technologist_medium_skin_tone",
        "id": "ahli_teknologi_warna_kulit_sedang",
        "alias": "ahli_teknologi_warna_kulit_sedang_pemrogram_penemu_pengembang_perangkat_lunak",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F4BB": {
        "en": "technologist_medium-dark_skin_tone",
        "id": "ahli_teknologi_warna_kulit_gelap-sedang",
        "alias": "ahli_teknologi_warna_kulit_gelap-sedang_pemrogram_penemu_pengembang_perangkat_lunak",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F4BB": {
        "en": "technologist_dark_skin_tone",
        "id": "ahli_teknologi_warna_kulit_gelap",
        "alias": "ahli_teknologi_warna_kulit_gelap_pemrogram_penemu_pengembang_perangkat_lunak",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F4BB": {
        "en": "man_technologist_light_skin_tone",
        "id": "ahli_teknologi_pria_warna_kulit_cerah",
        "alias": "ahli_teknologi_pria_warna_kulit_cerah_komputer_laki-laki",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F4BB": {
        "en": "man_technologist_medium-light_skin_tone",
        "id": "ahli_teknologi_pria_warna_kulit_cerah-sedang",
        "alias": "ahli_teknologi_pria_warna_kulit_cerah-sedang_komputer_laki-laki",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F4BB": {
        "en": "man_technologist_medium_skin_tone",
        "id": "ahli_teknologi_pria_warna_kulit_sedang",
        "alias": "ahli_teknologi_pria_warna_kulit_sedang_komputer_laki-laki",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F4BB": {
        "en": "man_technologist_medium-dark_skin_tone",
        "id": "ahli_teknologi_pria_warna_kulit_gelap-sedang",
        "alias": "ahli_teknologi_pria_warna_kulit_gelap-sedang_komputer_laki-laki",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F4BB": {
        "en": "man_technologist_dark_skin_tone",
        "id": "ahli_teknologi_pria_warna_kulit_gelap",
        "alias": "ahli_teknologi_pria_warna_kulit_gelap_komputer_laki-laki",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F4BB": {
        "en": "woman_technologist_light_skin_tone",
        "id": "ahli_teknologi_wanita_warna_kulit_cerah",
        "alias": "ahli_teknologi_wanita_warna_kulit_cerah_komputer_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F4BB": {
        "en": "woman_technologist_medium-light_skin_tone",
        "id": "ahli_teknologi_wanita_warna_kulit_cerah-sedang",
        "alias": "ahli_teknologi_wanita_warna_kulit_cerah-sedang_komputer_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F4BB": {
        "en": "woman_technologist_medium_skin_tone",
        "id": "ahli_teknologi_wanita_warna_kulit_sedang",
        "alias": "ahli_teknologi_wanita_warna_kulit_sedang_komputer_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F4BB": {
        "en": "woman_technologist_medium-dark_skin_tone",
        "id": "ahli_teknologi_wanita_warna_kulit_gelap-sedang",
        "alias": "ahli_teknologi_wanita_warna_kulit_gelap-sedang_komputer_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F4BB": {
        "en": "woman_technologist_dark_skin_tone",
        "id": "ahli_teknologi_wanita_warna_kulit_gelap",
        "alias": "ahli_teknologi_wanita_warna_kulit_gelap_komputer_perempuan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F3A4": {
        "en": "singer_light_skin_tone",
        "id": "penyanyi_warna_kulit_cerah",
        "alias": "penyanyi_warna_kulit_cerah_aktor_bintang_penghibur_rock",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F3A4": {
        "en": "singer_medium-light_skin_tone",
        "id": "penyanyi_warna_kulit_cerah-sedang",
        "alias": "penyanyi_warna_kulit_cerah-sedang_aktor_bintang_penghibur_rock",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F3A4": {
        "en": "singer_medium_skin_tone",
        "id": "penyanyi_warna_kulit_sedang",
        "alias": "penyanyi_warna_kulit_sedang_aktor_bintang_penghibur_rock",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F3A4": {
        "en": "singer_medium-dark_skin_tone",
        "id": "penyanyi_warna_kulit_gelap-sedang",
        "alias": "penyanyi_warna_kulit_gelap-sedang_aktor_bintang_penghibur_rock",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F3A4": {
        "en": "singer_dark_skin_tone",
        "id": "penyanyi_warna_kulit_gelap",
        "alias": "penyanyi_warna_kulit_gelap_aktor_bintang_penghibur_rock",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F3A4": {
        "en": "man_singer_light_skin_tone",
        "id": "penyanyi_pria_warna_kulit_cerah",
        "alias": "penyanyi_pria_warna_kulit_cerah_aktor_bintang_penghibur_rock",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F3A4": {
        "en": "man_singer_medium-light_skin_tone",
        "id": "penyanyi_pria_warna_kulit_cerah-sedang",
        "alias": "penyanyi_pria_warna_kulit_cerah-sedang_aktor_bintang_penghibur_rock",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F3A4": {
        "en": "man_singer_medium_skin_tone",
        "id": "penyanyi_pria_warna_kulit_sedang",
        "alias": "penyanyi_pria_warna_kulit_sedang_aktor_bintang_penghibur_rock",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F3A4": {
        "en": "man_singer_medium-dark_skin_tone",
        "id": "penyanyi_pria_warna_kulit_gelap-sedang",
        "alias": "penyanyi_pria_warna_kulit_gelap-sedang_aktor_bintang_penghibur_rock",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F3A4": {
        "en": "man_singer_dark_skin_tone",
        "id": "penyanyi_pria_warna_kulit_gelap",
        "alias": "penyanyi_pria_warna_kulit_gelap_aktor_bintang_penghibur_rock",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F3A4": {
        "en": "woman_singer_light_skin_tone",
        "id": "penyanyi_wanita_warna_kulit_cerah",
        "alias": "penyanyi_wanita_warna_kulit_cerah_aktor_bintang_penghibur_rock",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F3A4": {
        "en": "woman_singer_medium-light_skin_tone",
        "id": "penyanyi_wanita_warna_kulit_cerah-sedang",
        "alias": "penyanyi_wanita_warna_kulit_cerah-sedang_aktor_bintang_penghibur_rock",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F3A4": {
        "en": "woman_singer_medium_skin_tone",
        "id": "penyanyi_wanita_warna_kulit_sedang",
        "alias": "penyanyi_wanita_warna_kulit_sedang_aktor_bintang_penghibur_rock",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F3A4": {
        "en": "woman_singer_medium-dark_skin_tone",
        "id": "penyanyi_wanita_warna_kulit_gelap-sedang",
        "alias": "penyanyi_wanita_warna_kulit_gelap-sedang_aktor_bintang_penghibur_rock",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F3A4": {
        "en": "woman_singer_dark_skin_tone",
        "id": "penyanyi_wanita_warna_kulit_gelap",
        "alias": "penyanyi_wanita_warna_kulit_gelap_aktor_bintang_penghibur_rock",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F3A8": {
        "en": "artist_light_skin_tone",
        "id": "seniman_warna_kulit_cerah",
        "alias": "seniman_warna_kulit_cerah_palet",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F3A8": {
        "en": "artist_medium-light_skin_tone",
        "id": "seniman_warna_kulit_cerah-sedang",
        "alias": "seniman_warna_kulit_cerah-sedang_palet",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F3A8": {
        "en": "artist_medium_skin_tone",
        "id": "seniman_warna_kulit_sedang",
        "alias": "seniman_warna_kulit_sedang_palet",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F3A8": {
        "en": "artist_medium-dark_skin_tone",
        "id": "seniman_warna_kulit_gelap-sedang",
        "alias": "seniman_warna_kulit_gelap-sedang_palet",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F3A8": {
        "en": "artist_dark_skin_tone",
        "id": "seniman_warna_kulit_gelap",
        "alias": "seniman_warna_kulit_gelap_palet",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F3A8": {
        "en": "man_artist_light_skin_tone",
        "id": "seniman_pria_warna_kulit_cerah",
        "alias": "seniman_pria_warna_kulit_cerah_laki-laki_lukisan_seni",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F3A8": {
        "en": "man_artist_medium-light_skin_tone",
        "id": "seniman_pria_warna_kulit_cerah-sedang",
        "alias": "seniman_pria_warna_kulit_cerah-sedang_laki-laki_lukisan_seni",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F3A8": {
        "en": "man_artist_medium_skin_tone",
        "id": "seniman_pria_warna_kulit_sedang",
        "alias": "seniman_pria_warna_kulit_sedang_laki-laki_lukisan_seni",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F3A8": {
        "en": "man_artist_medium-dark_skin_tone",
        "id": "seniman_pria_warna_kulit_gelap-sedang",
        "alias": "seniman_pria_warna_kulit_gelap-sedang_laki-laki_lukisan_seni",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F3A8": {
        "en": "man_artist_dark_skin_tone",
        "id": "seniman_pria_warna_kulit_gelap",
        "alias": "seniman_pria_warna_kulit_gelap_laki-laki_lukisan_seni",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F3A8": {
        "en": "woman_artist_light_skin_tone",
        "id": "seniman_wanita_warna_kulit_cerah",
        "alias": "seniman_wanita_warna_kulit_cerah_lukisan_perempuan_seni",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F3A8": {
        "en": "woman_artist_medium-light_skin_tone",
        "id": "seniman_wanita_warna_kulit_cerah-sedang",
        "alias": "seniman_wanita_warna_kulit_cerah-sedang_lukisan_perempuan_seni",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F3A8": {
        "en": "woman_artist_medium_skin_tone",
        "id": "seniman_wanita_warna_kulit_sedang",
        "alias": "seniman_wanita_warna_kulit_sedang_lukisan_perempuan_seni",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F3A8": {
        "en": "woman_artist_medium-dark_skin_tone",
        "id": "seniman_wanita_warna_kulit_gelap-sedang",
        "alias": "seniman_wanita_warna_kulit_gelap-sedang_lukisan_perempuan_seni",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F3A8": {
        "en": "woman_artist_dark_skin_tone",
        "id": "seniman_wanita_warna_kulit_gelap",
        "alias": "seniman_wanita_warna_kulit_gelap_lukisan_perempuan_seni",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U00002708\U0000FE0F": {
        "en": "pilot_light_skin_tone",
        "id": "pilot_warna_kulit_cerah",
        "alias": "pilot_warna_kulit_cerah_pesawat",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002708\U0000FE0F": {
        "en": "pilot_medium-light_skin_tone",
        "id": "pilot_warna_kulit_cerah-sedang",
        "alias": "pilot_warna_kulit_cerah-sedang_pesawat",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002708\U0000FE0F": {
        "en": "pilot_medium_skin_tone",
        "id": "pilot_warna_kulit_sedang",
        "alias": "pilot_warna_kulit_sedang_pesawat",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002708\U0000FE0F": {
        "en": "pilot_medium-dark_skin_tone",
        "id": "pilot_warna_kulit_gelap-sedang",
        "alias": "pilot_warna_kulit_gelap-sedang_pesawat",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002708\U0000FE0F": {
        "en": "pilot_dark_skin_tone",
        "id": "pilot_warna_kulit_gelap",
        "alias": "pilot_warna_kulit_gelap_pesawat",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002708\U0000FE0F": {
        "en": "man_pilot_light_skin_tone",
        "id": "pilot_pria_warna_kulit_cerah",
        "alias": "pilot_pria_warna_kulit_cerah_laki-laki_pesawat",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002708\U0000FE0F": {
        "en": "man_pilot_medium-light_skin_tone",
        "id": "pilot_pria_warna_kulit_cerah-sedang",
        "alias": "pilot_pria_warna_kulit_cerah-sedang_laki-laki_pesawat",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002708\U0000FE0F": {
        "en": "man_pilot_medium_skin_tone",
        "id": "pilot_pria_warna_kulit_sedang",
        "alias": "pilot_pria_warna_kulit_sedang_laki-laki_pesawat",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002708\U0000FE0F": {
        "en": "man_pilot_medium-dark_skin_tone",
        "id": "pilot_pria_warna_kulit_gelap-sedang",
        "alias": "pilot_pria_warna_kulit_gelap-sedang_laki-laki_pesawat",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002708\U0000FE0F": {
        "en": "man_pilot_dark_skin_tone",
        "id": "pilot_pria_warna_kulit_gelap",
        "alias": "pilot_pria_warna_kulit_gelap_laki-laki_pesawat",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002708\U0000FE0F": {
        "en": "woman_pilot_light_skin_tone",
        "id": "pilot_wanita_warna_kulit_cerah",
        "alias": "pilot_wanita_warna_kulit_cerah_perempuan_pesawat",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002708\U0000FE0F": {
        "en": "woman_pilot_medium-light_skin_tone",
        "id": "pilot_wanita_warna_kulit_cerah-sedang",
        "alias": "pilot_wanita_warna_kulit_cerah-sedang_perempuan_pesawat",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002708\U0000FE0F": {
        "en": "woman_pilot_medium_skin_tone",
        "id": "pilot_wanita_warna_kulit_sedang",
        "alias": "pilot_wanita_warna_kulit_sedang_perempuan_pesawat",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002708\U0000FE0F": {
        "en": "woman_pilot_medium-dark_skin_tone",
        "id": "pilot_wanita_warna_kulit_gelap-sedang",
        "alias": "pilot_wanita_warna_kulit_gelap-sedang_perempuan_pesawat",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002708\U0000FE0F": {
        "en": "woman_pilot_dark_skin_tone",
        "id": "pilot_wanita_warna_kulit_gelap",
        "alias": "pilot_wanita_warna_kulit_gelap_perempuan_pesawat",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F680": {
        "en": "astronaut_light_skin_tone",
        "id": "astronaut_warna_kulit_cerah",
        "alias": "astronaut_warna_kulit_cerah_roket",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F680": {
        "en": "astronaut_medium-light_skin_tone",
        "id": "astronaut_warna_kulit_cerah-sedang",
        "alias": "astronaut_warna_kulit_cerah-sedang_roket",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F680": {
        "en": "astronaut_medium_skin_tone",
        "id": "astronaut_warna_kulit_sedang",
        "alias": "astronaut_warna_kulit_sedang_roket",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F680": {
        "en": "astronaut_medium-dark_skin_tone",
        "id": "astronaut_warna_kulit_gelap-sedang",
        "alias": "astronaut_warna_kulit_gelap-sedang_roket",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F680": {
        "en": "astronaut_dark_skin_tone",
        "id": "astronaut_warna_kulit_gelap",
        "alias": "astronaut_warna_kulit_gelap_roket",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F680": {
        "en": "man_astronaut_light_skin_tone",
        "id": "antariksawan_pria_warna_kulit_cerah",
        "alias": "antariksawan_pria_warna_kulit_cerah_angkasa_luar_laki-laki_roket",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F680": {
        "en": "man_astronaut_medium-light_skin_tone",
        "id": "antariksawan_pria_warna_kulit_cerah-sedang",
        "alias": "antariksawan_pria_warna_kulit_cerah-sedang_angkasa_luar_laki-laki_roket",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F680": {
        "en": "man_astronaut_medium_skin_tone",
        "id": "antariksawan_pria_warna_kulit_sedang",
        "alias": "antariksawan_pria_warna_kulit_sedang_angkasa_luar_laki-laki_roket",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F680": {
        "en": "man_astronaut_medium-dark_skin_tone",
        "id": "antariksawan_pria_warna_kulit_gelap-sedang",
        "alias": "antariksawan_pria_warna_kulit_gelap-sedang_angkasa_luar_laki-laki_roket",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F680": {
        "en": "man_astronaut_dark_skin_tone",
        "id": "antariksawan_pria_warna_kulit_gelap",
        "alias": "antariksawan_pria_warna_kulit_gelap_angkasa_luar_laki-laki_roket",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F680": {
        "en": "woman_astronaut_light_skin_tone",
        "id": "antariksawan_wanita_warna_kulit_cerah",
        "alias": "antariksawan_wanita_warna_kulit_cerah_angkasa_luar_perempuan_roket",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F680": {
        "en": "woman_astronaut_medium-light_skin_tone",
        "id": "antariksawan_wanita_warna_kulit_cerah-sedang",
        "alias": "antariksawan_wanita_warna_kulit_cerah-sedang_angkasa_luar_perempuan_roket",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F680": {
        "en": "woman_astronaut_medium_skin_tone",
        "id": "antariksawan_wanita_warna_kulit_sedang",
        "alias": "antariksawan_wanita_warna_kulit_sedang_angkasa_luar_perempuan_roket",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F680": {
        "en": "woman_astronaut_medium-dark_skin_tone",
        "id": "antariksawan_wanita_warna_kulit_gelap-sedang",
        "alias": "antariksawan_wanita_warna_kulit_gelap-sedang_angkasa_luar_perempuan_roket",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F680": {
        "en": "woman_astronaut_dark_skin_tone",
        "id": "antariksawan_wanita_warna_kulit_gelap",
        "alias": "antariksawan_wanita_warna_kulit_gelap_angkasa_luar_perempuan_roket",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F692": {
        "en": "firefighter_light_skin_tone",
        "id": "pemadam_kebakaran_warna_kulit_cerah",
        "alias": "pemadam_kebakaran_warna_kulit_cerah_truk",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F692": {
        "en": "firefighter_medium-light_skin_tone",
        "id": "pemadam_kebakaran_warna_kulit_cerah-sedang",
        "alias": "pemadam_kebakaran_warna_kulit_cerah-sedang_truk",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F692": {
        "en": "firefighter_medium_skin_tone",
        "id": "pemadam_kebakaran_warna_kulit_sedang",
        "alias": "pemadam_kebakaran_warna_kulit_sedang_truk",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F692": {
        "en": "firefighter_medium-dark_skin_tone",
        "id": "pemadam_kebakaran_warna_kulit_gelap-sedang",
        "alias": "pemadam_kebakaran_warna_kulit_gelap-sedang_truk",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F692": {
        "en": "firefighter_dark_skin_tone",
        "id": "pemadam_kebakaran_warna_kulit_gelap",
        "alias": "pemadam_kebakaran_warna_kulit_gelap_truk",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F692": {
        "en": "man_firefighter_light_skin_tone",
        "id": "pemadam_kebakaran_pria_warna_kulit_cerah",
        "alias": "pemadam_kebakaran_pria_warna_kulit_cerah_api_laki-laki",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F692": {
        "en": "man_firefighter_medium-light_skin_tone",
        "id": "pemadam_kebakaran_pria_warna_kulit_cerah-sedang",
        "alias": "pemadam_kebakaran_pria_warna_kulit_cerah-sedang_api_laki-laki",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F692": {
        "en": "man_firefighter_medium_skin_tone",
        "id": "pemadam_kebakaran_pria_warna_kulit_sedang",
        "alias": "pemadam_kebakaran_pria_warna_kulit_sedang_api_laki-laki",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F692": {
        "en": "man_firefighter_medium-dark_skin_tone",
        "id": "pemadam_kebakaran_pria_warna_kulit_gelap-sedang",
        "alias": "pemadam_kebakaran_pria_warna_kulit_gelap-sedang_api_laki-laki",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F692": {
        "en": "man_firefighter_dark_skin_tone",
        "id": "pemadam_kebakaran_pria_warna_kulit_gelap",
        "alias": "pemadam_kebakaran_pria_warna_kulit_gelap_api_laki-laki",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F692": {
        "en": "woman_firefighter_light_skin_tone",
        "id": "pemadam_kebakaran_wanita_warna_kulit_cerah",
        "alias": "pemadam_kebakaran_wanita_warna_kulit_cerah_api_perempuan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F692": {
        "en": "woman_firefighter_medium-light_skin_tone",
        "id": "pemadam_kebakaran_wanita_warna_kulit_cerah-sedang",
        "alias": "pemadam_kebakaran_wanita_warna_kulit_cerah-sedang_api_perempuan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F692": {
        "en": "woman_firefighter_medium_skin_tone",
        "id": "pemadam_kebakaran_wanita_warna_kulit_sedang",
        "alias": "pemadam_kebakaran_wanita_warna_kulit_sedang_api_perempuan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F692": {
        "en": "woman_firefighter_medium-dark_skin_tone",
        "id": "pemadam_kebakaran_wanita_warna_kulit_gelap-sedang",
        "alias": "pemadam_kebakaran_wanita_warna_kulit_gelap-sedang_api_perempuan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F692": {
        "en": "woman_firefighter_dark_skin_tone",
        "id": "pemadam_kebakaran_wanita_warna_kulit_gelap",
        "alias": "pemadam_kebakaran_wanita_warna_kulit_gelap_api_perempuan",
    },
    "\U0001F46E\U0001F3FB": {
        "en": "police_officer_light_skin_tone",
        "id": "polisi_warna_kulit_cerah",
        "alias": "polisi_warna_kulit_cerah_penegak_hukum",
    },
    "\U0001F46E\U0001F3FC": {
        "en": "police_officer_medium-light_skin_tone",
        "id": "polisi_warna_kulit_cerah-sedang",
        "alias": "polisi_warna_kulit_cerah-sedang_penegak_hukum",
    },
    "\U0001F46E\U0001F3FD": {
        "en": "police_officer_medium_skin_tone",
        "id": "polisi_warna_kulit_sedang",
        "alias": "polisi_warna_kulit_sedang_penegak_hukum",
    },
    "\U0001F46E\U0001F3FE": {
        "en": "police_officer_medium-dark_skin_tone",
        "id": "polisi_warna_kulit_gelap-sedang",
        "alias": "polisi_warna_kulit_gelap-sedang_penegak_hukum",
    },
    "\U0001F46E\U0001F3FF": {
        "en": "police_officer_dark_skin_tone",
        "id": "polisi_warna_kulit_gelap",
        "alias": "polisi_warna_kulit_gelap_penegak_hukum",
    },
    "\U0001F46E\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_police_officer_light_skin_tone",
        "id": "polisi_pria_warna_kulit_cerah",
        "alias": "polisi_pria_warna_kulit_cerah_laki-laki_penegak_hukum",
    },
    "\U0001F46E\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_police_officer_medium-light_skin_tone",
        "id": "polisi_pria_warna_kulit_cerah-sedang",
        "alias": "polisi_pria_warna_kulit_cerah-sedang_laki-laki_penegak_hukum",
    },
    "\U0001F46E\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_police_officer_medium_skin_tone",
        "id": "polisi_pria_warna_kulit_sedang",
        "alias": "polisi_pria_warna_kulit_sedang_laki-laki_penegak_hukum",
    },
    "\U0001F46E\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_police_officer_medium-dark_skin_tone",
        "id": "polisi_pria_warna_kulit_gelap-sedang",
        "alias": "polisi_pria_warna_kulit_gelap-sedang_laki-laki_penegak_hukum",
    },
    "\U0001F46E\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_police_officer_dark_skin_tone",
        "id": "polisi_pria_warna_kulit_gelap",
        "alias": "polisi_pria_warna_kulit_gelap_laki-laki_penegak_hukum",
    },
    "\U0001F46E\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_police_officer_light_skin_tone",
        "id": "polisi_wanita_warna_kulit_cerah",
        "alias": "polisi_wanita_warna_kulit_cerah_penegak_hukum_perempuan",
    },
    "\U0001F46E\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_police_officer_medium-light_skin_tone",
        "id": "polisi_wanita_warna_kulit_cerah-sedang",
        "alias": "polisi_wanita_warna_kulit_cerah-sedang_penegak_hukum_perempuan",
    },
    "\U0001F46E\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_police_officer_medium_skin_tone",
        "id": "polisi_wanita_warna_kulit_sedang",
        "alias": "polisi_wanita_warna_kulit_sedang_penegak_hukum_perempuan",
    },
    "\U0001F46E\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_police_officer_medium-dark_skin_tone",
        "id": "polisi_wanita_warna_kulit_gelap-sedang",
        "alias": "polisi_wanita_warna_kulit_gelap-sedang_penegak_hukum_perempuan",
    },
    "\U0001F46E\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_police_officer_dark_skin_tone",
        "id": "polisi_wanita_warna_kulit_gelap",
        "alias": "polisi_wanita_warna_kulit_gelap_penegak_hukum_perempuan",
    },
    "\U0001F575\U0001F3FB": {
        "en": "detective_light_skin_tone",
        "id": "detektif_warna_kulit_cerah",
        "alias": "detektif_warna_kulit_cerah_mata-mata",
    },
    "\U0001F575\U0001F3FC": {
        "en": "detective_medium-light_skin_tone",
        "id": "detektif_warna_kulit_cerah-sedang",
        "alias": "detektif_warna_kulit_cerah-sedang_mata-mata",
    },
    "\U0001F575\U0001F3FD": {
        "en": "detective_medium_skin_tone",
        "id": "detektif_warna_kulit_sedang",
        "alias": "detektif_warna_kulit_sedang_mata-mata",
    },
    "\U0001F575\U0001F3FE": {
        "en": "detective_medium-dark_skin_tone",
        "id": "detektif_warna_kulit_gelap-sedang",
        "alias": "detektif_warna_kulit_gelap-sedang_mata-mata",
    },
    "\U0001F575\U0001F3FF": {
        "en": "detective_dark_skin_tone",
        "id": "detektif_warna_kulit_gelap",
        "alias": "detektif_warna_kulit_gelap_mata-mata",
    },
    "\U0001F575\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_detective_light_skin_tone",
        "id": "detektif_pria_warna_kulit_cerah",
        "alias": "detektif_pria_warna_kulit_cerah_laki-laki_penyelidikan_rahasia",
    },
    "\U0001F575\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_detective_medium-light_skin_tone",
        "id": "detektif_pria_warna_kulit_cerah-sedang",
        "alias": "detektif_pria_warna_kulit_cerah-sedang_laki-laki_penyelidikan_rahasia",
    },
    "\U0001F575\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_detective_medium_skin_tone",
        "id": "detektif_pria_warna_kulit_sedang",
        "alias": "detektif_pria_warna_kulit_sedang_laki-laki_penyelidikan_rahasia",
    },
    "\U0001F575\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_detective_medium-dark_skin_tone",
        "id": "detektif_pria_warna_kulit_gelap-sedang",
        "alias": "detektif_pria_warna_kulit_gelap-sedang_laki-laki_penyelidikan_rahasia",
    },
    "\U0001F575\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_detective_dark_skin_tone",
        "id": "detektif_pria_warna_kulit_gelap",
        "alias": "detektif_pria_warna_kulit_gelap_laki-laki_penyelidikan_rahasia",
    },
    "\U0001F575\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_detective_light_skin_tone",
        "id": "detektif_wanita_warna_kulit_cerah",
        "alias": "detektif_wanita_warna_kulit_cerah_penyelidikan_perempuan_rahasia",
    },
    "\U0001F575\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_detective_medium-light_skin_tone",
        "id": "detektif_wanita_warna_kulit_cerah-sedang",
        "alias": "detektif_wanita_warna_kulit_cerah-sedang_penyelidikan_perempuan_rahasia",
    },
    "\U0001F575\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_detective_medium_skin_tone",
        "id": "detektif_wanita_warna_kulit_sedang",
        "alias": "detektif_wanita_warna_kulit_sedang_penyelidikan_perempuan_rahasia",
    },
    "\U0001F575\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_detective_medium-dark_skin_tone",
        "id": "detektif_wanita_warna_kulit_gelap-sedang",
        "alias": "detektif_wanita_warna_kulit_gelap-sedang_penyelidikan_perempuan_rahasia",
    },
    "\U0001F575\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_detective_dark_skin_tone",
        "id": "detektif_wanita_warna_kulit_gelap",
        "alias": "detektif_wanita_warna_kulit_gelap_penyelidikan_perempuan_rahasia",
    },
    "\U0001F482\U0001F3FB": {
        "en": "guard_light_skin_tone",
        "id": "penjaga_warna_kulit_cerah",
        "alias": "penjaga_warna_kulit_cerah_pengawal",
    },
    "\U0001F482\U0001F3FC": {
        "en": "guard_medium-light_skin_tone",
        "id": "penjaga_warna_kulit_cerah-sedang",
        "alias": "penjaga_warna_kulit_cerah-sedang_pengawal",
    },
    "\U0001F482\U0001F3FD": {
        "en": "guard_medium_skin_tone",
        "id": "penjaga_warna_kulit_sedang",
        "alias": "penjaga_warna_kulit_sedang_pengawal",
    },
    "\U0001F482\U0001F3FE": {
        "en": "guard_medium-dark_skin_tone",
        "id": "penjaga_warna_kulit_gelap-sedang",
        "alias": "penjaga_warna_kulit_gelap-sedang_pengawal",
    },
    "\U0001F482\U0001F3FF": {
        "en": "guard_dark_skin_tone",
        "id": "penjaga_warna_kulit_gelap",
        "alias": "penjaga_warna_kulit_gelap_pengawal",
    },
    "\U0001F482\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_guard_light_skin_tone",
        "id": "penjaga_pria_warna_kulit_cerah",
        "alias": "penjaga_pria_warna_kulit_cerah_keamanan_laki-laki",
    },
    "\U0001F482\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_guard_medium-light_skin_tone",
        "id": "penjaga_pria_warna_kulit_cerah-sedang",
        "alias": "penjaga_pria_warna_kulit_cerah-sedang_keamanan_laki-laki",
    },
    "\U0001F482\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_guard_medium_skin_tone",
        "id": "penjaga_pria_warna_kulit_sedang",
        "alias": "penjaga_pria_warna_kulit_sedang_keamanan_laki-laki",
    },
    "\U0001F482\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_guard_medium-dark_skin_tone",
        "id": "penjaga_pria_warna_kulit_gelap-sedang",
        "alias": "penjaga_pria_warna_kulit_gelap-sedang_keamanan_laki-laki",
    },
    "\U0001F482\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_guard_dark_skin_tone",
        "id": "penjaga_pria_warna_kulit_gelap",
        "alias": "penjaga_pria_warna_kulit_gelap_keamanan_laki-laki",
    },
    "\U0001F482\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_guard_light_skin_tone",
        "id": "penjaga_wanita_warna_kulit_cerah",
        "alias": "penjaga_wanita_warna_kulit_cerah_keamanan_perempuan",
    },
    "\U0001F482\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_guard_medium-light_skin_tone",
        "id": "penjaga_wanita_warna_kulit_cerah-sedang",
        "alias": "penjaga_wanita_warna_kulit_cerah-sedang_keamanan_perempuan",
    },
    "\U0001F482\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_guard_medium_skin_tone",
        "id": "penjaga_wanita_warna_kulit_sedang",
        "alias": "penjaga_wanita_warna_kulit_sedang_keamanan_perempuan",
    },
    "\U0001F482\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_guard_medium-dark_skin_tone",
        "id": "penjaga_wanita_warna_kulit_gelap-sedang",
        "alias": "penjaga_wanita_warna_kulit_gelap-sedang_keamanan_perempuan",
    },
    "\U0001F482\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_guard_dark_skin_tone",
        "id": "penjaga_wanita_warna_kulit_gelap",
        "alias": "penjaga_wanita_warna_kulit_gelap_keamanan_perempuan",
    },
    "\U0001F977\U0001F3FB": {
        "en": "ninja_light_skin_tone",
        "id": "ninja_warna_kulit_cerah",
        "alias": "ninja_warna_kulit_cerah_petarung_sembunyi-sembunyi_tersembunyi",
    },
    "\U0001F977\U0001F3FC": {
        "en": "ninja_medium-light_skin_tone",
        "id": "ninja_warna_kulit_cerah-sedang",
        "alias": "ninja_warna_kulit_cerah-sedang_petarung_sembunyi-sembunyi_tersembunyi",
    },
    "\U0001F977\U0001F3FD": {
        "en": "ninja_medium_skin_tone",
        "id": "ninja_warna_kulit_sedang",
        "alias": "ninja_warna_kulit_sedang_petarung_sembunyi-sembunyi_tersembunyi",
    },
    "\U0001F977\U0001F3FE": {
        "en": "ninja_medium-dark_skin_tone",
        "id": "ninja_warna_kulit_gelap-sedang",
        "alias": "ninja_warna_kulit_gelap-sedang_petarung_sembunyi-sembunyi_tersembunyi",
    },
    "\U0001F977\U0001F3FF": {
        "en": "ninja_dark_skin_tone",
        "id": "ninja_warna_kulit_gelap",
        "alias": "ninja_warna_kulit_gelap_petarung_sembunyi-sembunyi_tersembunyi",
    },
    "\U0001F477\U0001F3FB": {
        "en": "construction_worker_light_skin_tone",
        "id": "pekerja_konstruksi_warna_kulit_cerah",
        "alias": "pekerja_konstruksi_warna_kulit_cerah_kontraktor_topi",
    },
    "\U0001F477\U0001F3FC": {
        "en": "construction_worker_medium-light_skin_tone",
        "id": "pekerja_konstruksi_warna_kulit_cerah-sedang",
        "alias": "pekerja_konstruksi_warna_kulit_cerah-sedang_kontraktor_topi",
    },
    "\U0001F477\U0001F3FD": {
        "en": "construction_worker_medium_skin_tone",
        "id": "pekerja_konstruksi_warna_kulit_sedang",
        "alias": "pekerja_konstruksi_warna_kulit_sedang_kontraktor_topi",
    },
    "\U0001F477\U0001F3FE": {
        "en": "construction_worker_medium-dark_skin_tone",
        "id": "pekerja_konstruksi_warna_kulit_gelap-sedang",
        "alias": "pekerja_konstruksi_warna_kulit_gelap-sedang_kontraktor_topi",
    },
    "\U0001F477\U0001F3FF": {
        "en": "construction_worker_dark_skin_tone",
        "id": "pekerja_konstruksi_warna_kulit_gelap",
        "alias": "pekerja_konstruksi_warna_kulit_gelap_kontraktor_topi",
    },
    "\U0001F477\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_construction_worker_light_skin_tone",
        "id": "pekerja_konstruksi_pria_warna_kulit_cerah",
        "alias": "pekerja_konstruksi_pria_warna_kulit_cerah_kontraktor_laki-laki",
    },
    "\U0001F477\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_construction_worker_medium-light_skin_tone",
        "id": "pekerja_konstruksi_pria_warna_kulit_cerah-sedang",
        "alias": "pekerja_konstruksi_pria_warna_kulit_cerah-sedang_kontraktor_laki-laki",
    },
    "\U0001F477\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_construction_worker_medium_skin_tone",
        "id": "pekerja_konstruksi_pria_warna_kulit_sedang",
        "alias": "pekerja_konstruksi_pria_warna_kulit_sedang_kontraktor_laki-laki",
    },
    "\U0001F477\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_construction_worker_medium-dark_skin_tone",
        "id": "pekerja_konstruksi_pria_warna_kulit_gelap-sedang",
        "alias": "pekerja_konstruksi_pria_warna_kulit_gelap-sedang_kontraktor_laki-laki",
    },
    "\U0001F477\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_construction_worker_dark_skin_tone",
        "id": "pekerja_konstruksi_pria_warna_kulit_gelap",
        "alias": "pekerja_konstruksi_pria_warna_kulit_gelap_kontraktor_laki-laki",
    },
    "\U0001F477\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_construction_worker_light_skin_tone",
        "id": "pekerja_konstruksi_wanita_warna_kulit_cerah",
        "alias": "pekerja_konstruksi_wanita_warna_kulit_cerah_kontraktor",
    },
    "\U0001F477\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_construction_worker_medium-light_skin_tone",
        "id": "pekerja_konstruksi_wanita_warna_kulit_cerah-sedang",
        "alias": "pekerja_konstruksi_wanita_warna_kulit_cerah-sedang_kontraktor",
    },
    "\U0001F477\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_construction_worker_medium_skin_tone",
        "id": "pekerja_konstruksi_wanita_warna_kulit_sedang",
        "alias": "pekerja_konstruksi_wanita_warna_kulit_sedang_kontraktor",
    },
    "\U0001F477\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_construction_worker_medium-dark_skin_tone",
        "id": "pekerja_konstruksi_wanita_warna_kulit_gelap-sedang",
        "alias": "pekerja_konstruksi_wanita_warna_kulit_gelap-sedang_kontraktor",
    },
    "\U0001F477\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_construction_worker_dark_skin_tone",
        "id": "pekerja_konstruksi_wanita_warna_kulit_gelap",
        "alias": "pekerja_konstruksi_wanita_warna_kulit_gelap_kontraktor",
    },
    "\U0001F934\U0001F3FB": {"en": "prince_light_skin_tone", "id": "pangeran_warna_kulit_cerah"},
    "\U0001F934\U0001F3FC": {
        "en": "prince_medium-light_skin_tone",
        "id": "pangeran_warna_kulit_cerah-sedang",
    },
    "\U0001F934\U0001F3FD": {"en": "prince_medium_skin_tone", "id": "pangeran_warna_kulit_sedang"},
    "\U0001F934\U0001F3FE": {
        "en": "prince_medium-dark_skin_tone",
        "id": "pangeran_warna_kulit_gelap-sedang",
    },
    "\U0001F934\U0001F3FF": {"en": "prince_dark_skin_tone", "id": "pangeran_warna_kulit_gelap"},
    "\U0001F478\U0001F3FB": {
        "en": "princess_light_skin_tone",
        "id": "putri_warna_kulit_cerah",
        "alias": "putri_warna_kulit_cerah_dongeng_fantasi_puteri",
    },
    "\U0001F478\U0001F3FC": {
        "en": "princess_medium-light_skin_tone",
        "id": "putri_warna_kulit_cerah-sedang",
        "alias": "putri_warna_kulit_cerah-sedang_dongeng_fantasi_puteri",
    },
    "\U0001F478\U0001F3FD": {
        "en": "princess_medium_skin_tone",
        "id": "putri_warna_kulit_sedang",
        "alias": "putri_warna_kulit_sedang_dongeng_fantasi_puteri",
    },
    "\U0001F478\U0001F3FE": {
        "en": "princess_medium-dark_skin_tone",
        "id": "putri_warna_kulit_gelap-sedang",
        "alias": "putri_warna_kulit_gelap-sedang_dongeng_fantasi_puteri",
    },
    "\U0001F478\U0001F3FF": {
        "en": "princess_dark_skin_tone",
        "id": "putri_warna_kulit_gelap",
        "alias": "putri_warna_kulit_gelap_dongeng_fantasi_puteri",
    },
    "\U0001F473\U0001F3FB": {
        "en": "person_wearing_turban_light_skin_tone",
        "id": "orang_mengenakan_serban_warna_kulit_cerah",
        "alias": "orang_mengenakan_serban_warna_kulit_cerah_laki-laki_pria_surban",
    },
    "\U0001F473\U0001F3FC": {
        "en": "person_wearing_turban_medium-light_skin_tone",
        "id": "orang_mengenakan_serban_warna_kulit_cerah-sedang",
        "alias": "orang_mengenakan_serban_warna_kulit_cerah-sedang_laki-laki_pria_surban",
    },
    "\U0001F473\U0001F3FD": {
        "en": "person_wearing_turban_medium_skin_tone",
        "id": "orang_mengenakan_serban_warna_kulit_sedang",
        "alias": "orang_mengenakan_serban_warna_kulit_sedang_laki-laki_pria_surban",
    },
    "\U0001F473\U0001F3FE": {
        "en": "person_wearing_turban_medium-dark_skin_tone",
        "id": "orang_mengenakan_serban_warna_kulit_gelap-sedang",
        "alias": "orang_mengenakan_serban_warna_kulit_gelap-sedang_laki-laki_pria_surban",
    },
    "\U0001F473\U0001F3FF": {
        "en": "person_wearing_turban_dark_skin_tone",
        "id": "orang_mengenakan_serban_warna_kulit_gelap",
        "alias": "orang_mengenakan_serban_warna_kulit_gelap_laki-laki_pria_surban",
    },
    "\U0001F473\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_wearing_turban_light_skin_tone",
        "id": "pria_mengenakan_serban_warna_kulit_cerah",
        "alias": "pria_mengenakan_serban_warna_kulit_cerah_laki-laki",
    },
    "\U0001F473\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_wearing_turban_medium-light_skin_tone",
        "id": "pria_mengenakan_serban_warna_kulit_cerah-sedang",
        "alias": "pria_mengenakan_serban_warna_kulit_cerah-sedang_laki-laki",
    },
    "\U0001F473\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_wearing_turban_medium_skin_tone",
        "id": "pria_mengenakan_serban_warna_kulit_sedang",
        "alias": "pria_mengenakan_serban_warna_kulit_sedang_laki-laki",
    },
    "\U0001F473\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_wearing_turban_medium-dark_skin_tone",
        "id": "pria_mengenakan_serban_warna_kulit_gelap-sedang",
        "alias": "pria_mengenakan_serban_warna_kulit_gelap-sedang_laki-laki",
    },
    "\U0001F473\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_wearing_turban_dark_skin_tone",
        "id": "pria_mengenakan_serban_warna_kulit_gelap",
        "alias": "pria_mengenakan_serban_warna_kulit_gelap_laki-laki",
    },
    "\U0001F473\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_wearing_turban_light_skin_tone",
        "id": "wanita_mengenakan_serban_warna_kulit_cerah",
        "alias": "wanita_mengenakan_serban_warna_kulit_cerah_perempuan",
    },
    "\U0001F473\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_wearing_turban_medium-light_skin_tone",
        "id": "wanita_mengenakan_serban_warna_kulit_cerah-sedang",
        "alias": "wanita_mengenakan_serban_warna_kulit_cerah-sedang_perempuan",
    },
    "\U0001F473\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_wearing_turban_medium_skin_tone",
        "id": "wanita_mengenakan_serban_warna_kulit_sedang",
        "alias": "wanita_mengenakan_serban_warna_kulit_sedang_perempuan",
    },
    "\U0001F473\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_wearing_turban_medium-dark_skin_tone",
        "id": "wanita_mengenakan_serban_warna_kulit_gelap-sedang",
        "alias": "wanita_mengenakan_serban_warna_kulit_gelap-sedang_perempuan",
    },
    "\U0001F473\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_wearing_turban_dark_skin_tone",
        "id": "wanita_mengenakan_serban_warna_kulit_gelap",
        "alias": "wanita_mengenakan_serban_warna_kulit_gelap_perempuan",
    },
    "\U0001F472\U0001F3FB": {
        "en": "person_with_skullcap_light_skin_tone",
        "id": "orang_dengan_topi_tionghoa_warna_kulit_cerah",
        "alias": "orang_dengan_topi_tionghoa_warna_kulit_cerah_gua_pi_mao_pria",
    },
    "\U0001F472\U0001F3FC": {
        "en": "person_with_skullcap_medium-light_skin_tone",
        "id": "orang_dengan_topi_tionghoa_warna_kulit_cerah-sedang",
        "alias": "orang_dengan_topi_tionghoa_warna_kulit_cerah-sedang_gua_pi_mao_pria",
    },
    "\U0001F472\U0001F3FD": {
        "en": "person_with_skullcap_medium_skin_tone",
        "id": "orang_dengan_topi_tionghoa_warna_kulit_sedang",
        "alias": "orang_dengan_topi_tionghoa_warna_kulit_sedang_gua_pi_mao_pria",
    },
    "\U0001F472\U0001F3FE": {
        "en": "person_with_skullcap_medium-dark_skin_tone",
        "id": "orang_dengan_topi_tionghoa_warna_kulit_gelap-sedang",
        "alias": "orang_dengan_topi_tionghoa_warna_kulit_gelap-sedang_gua_pi_mao_pria",
    },
    "\U0001F472\U0001F3FF": {
        "en": "person_with_skullcap_dark_skin_tone",
        "id": "orang_dengan_topi_tionghoa_warna_kulit_gelap",
        "alias": "orang_dengan_topi_tionghoa_warna_kulit_gelap_gua_pi_mao_pria",
    },
    "\U0001F9D5\U0001F3FB": {
        "en": "woman_with_headscarf_light_skin_tone",
        "id": "wanita_dengan_kerudung_warna_kulit_cerah",
        "alias": "wanita_dengan_kerudung_warna_kulit_cerah_hijab_mantilla_tichel",
    },
    "\U0001F9D5\U0001F3FC": {
        "en": "woman_with_headscarf_medium-light_skin_tone",
        "id": "wanita_dengan_kerudung_warna_kulit_cerah-sedang",
        "alias": "wanita_dengan_kerudung_warna_kulit_cerah-sedang_hijab_mantilla_tichel",
    },
    "\U0001F9D5\U0001F3FD": {
        "en": "woman_with_headscarf_medium_skin_tone",
        "id": "wanita_dengan_kerudung_warna_kulit_sedang",
        "alias": "wanita_dengan_kerudung_warna_kulit_sedang_hijab_mantilla_tichel",
    },
    "\U0001F9D5\U0001F3FE": {
        "en": "woman_with_headscarf_medium-dark_skin_tone",
        "id": "wanita_dengan_kerudung_warna_kulit_gelap-sedang",
        "alias": "wanita_dengan_kerudung_warna_kulit_gelap-sedang_hijab_mantilla_tichel",
    },
    "\U0001F9D5\U0001F3FF": {
        "en": "woman_with_headscarf_dark_skin_tone",
        "id": "wanita_dengan_kerudung_warna_kulit_gelap",
        "alias": "wanita_dengan_kerudung_warna_kulit_gelap_hijab_mantilla_tichel",
    },
    "\U0001F935\U0001F3FB": {
        "en": "person_in_tuxedo_light_skin_tone",
        "id": "orang_bertuksedo_warna_kulit_cerah",
        "alias": "orang_bertuksedo_warna_kulit_cerah_mempelai_pria_tuksedo",
    },
    "\U0001F935\U0001F3FC": {
        "en": "person_in_tuxedo_medium-light_skin_tone",
        "id": "orang_bertuksedo_warna_kulit_cerah-sedang",
        "alias": "orang_bertuksedo_warna_kulit_cerah-sedang_mempelai_pria_tuksedo",
    },
    "\U0001F935\U0001F3FD": {
        "en": "person_in_tuxedo_medium_skin_tone",
        "id": "orang_bertuksedo_warna_kulit_sedang",
        "alias": "orang_bertuksedo_warna_kulit_sedang_mempelai_pria_tuksedo",
    },
    "\U0001F935\U0001F3FE": {
        "en": "person_in_tuxedo_medium-dark_skin_tone",
        "id": "orang_bertuksedo_warna_kulit_gelap-sedang",
        "alias": "orang_bertuksedo_warna_kulit_gelap-sedang_mempelai_pria_tuksedo",
    },
    "\U0001F935\U0001F3FF": {
        "en": "person_in_tuxedo_dark_skin_tone",
        "id": "orang_bertuksedo_warna_kulit_gelap",
        "alias": "orang_bertuksedo_warna_kulit_gelap_mempelai_pria_tuksedo",
    },
    "\U0001F935\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_tuxedo_light_skin_tone",
        "id": "pria_dewasa_bertuksedo_warna_kulit_cerah",
        "alias": "pria_dewasa_bertuksedo_warna_kulit_cerah_tuksedo_tuxedo",
    },
    "\U0001F935\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_tuxedo_medium-light_skin_tone",
        "id": "pria_dewasa_bertuksedo_warna_kulit_cerah-sedang",
        "alias": "pria_dewasa_bertuksedo_warna_kulit_cerah-sedang_tuksedo_tuxedo",
    },
    "\U0001F935\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_tuxedo_medium_skin_tone",
        "id": "pria_dewasa_bertuksedo_warna_kulit_sedang",
        "alias": "pria_dewasa_bertuksedo_warna_kulit_sedang_tuksedo_tuxedo",
    },
    "\U0001F935\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_tuxedo_medium-dark_skin_tone",
        "id": "pria_dewasa_bertuksedo_warna_kulit_gelap-sedang",
        "alias": "pria_dewasa_bertuksedo_warna_kulit_gelap-sedang_tuksedo_tuxedo",
    },
    "\U0001F935\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_tuxedo_dark_skin_tone",
        "id": "pria_dewasa_bertuksedo_warna_kulit_gelap",
        "alias": "pria_dewasa_bertuksedo_warna_kulit_gelap_tuksedo_tuxedo",
    },
    "\U0001F935\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_tuxedo_light_skin_tone",
        "id": "wanita_bertuksedo_warna_kulit_cerah",
        "alias": "wanita_bertuksedo_warna_kulit_cerah_tuksedo",
    },
    "\U0001F935\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_tuxedo_medium-light_skin_tone",
        "id": "wanita_bertuksedo_warna_kulit_cerah-sedang",
        "alias": "wanita_bertuksedo_warna_kulit_cerah-sedang_tuksedo",
    },
    "\U0001F935\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_tuxedo_medium_skin_tone",
        "id": "wanita_bertuksedo_warna_kulit_sedang",
        "alias": "wanita_bertuksedo_warna_kulit_sedang_tuksedo",
    },
    "\U0001F935\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_tuxedo_medium-dark_skin_tone",
        "id": "wanita_bertuksedo_warna_kulit_gelap-sedang",
        "alias": "wanita_bertuksedo_warna_kulit_gelap-sedang_tuksedo",
    },
    "\U0001F935\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_tuxedo_dark_skin_tone",
        "id": "wanita_bertuksedo_warna_kulit_gelap",
        "alias": "wanita_bertuksedo_warna_kulit_gelap_tuksedo",
    },
    "\U0001F470\U0001F3FB": {
        "en": "person_with_veil_light_skin_tone",
        "id": "orang_berpenutup_kepala_warna_kulit_cerah",
        "alias": "orang_berpenutup_kepala_warna_kulit_cerah_cadar_mempelai_wanita_nikah_pengantin",
    },
    "\U0001F470\U0001F3FC": {
        "en": "person_with_veil_medium-light_skin_tone",
        "id": "orang_berpenutup_kepala_warna_kulit_cerah-sedang",
        "alias": "orang_berpenutup_kepala_warna_kulit_cerah-sedang_cadar_mempelai_wanita_nikah_pengantin",
    },
    "\U0001F470\U0001F3FD": {
        "en": "person_with_veil_medium_skin_tone",
        "id": "orang_berpenutup_kepala_warna_kulit_sedang",
        "alias": "orang_berpenutup_kepala_warna_kulit_sedang_cadar_mempelai_wanita_nikah_pengantin",
    },
    "\U0001F470\U0001F3FE": {
        "en": "person_with_veil_medium-dark_skin_tone",
        "id": "orang_berpenutup_kepala_warna_kulit_gelap-sedang",
        "alias": "orang_berpenutup_kepala_warna_kulit_gelap-sedang_cadar_mempelai_wanita_nikah_pengantin",
    },
    "\U0001F470\U0001F3FF": {
        "en": "person_with_veil_dark_skin_tone",
        "id": "orang_berpenutup_kepala_warna_kulit_gelap",
        "alias": "orang_berpenutup_kepala_warna_kulit_gelap_cadar_mempelai_wanita_nikah_pengantin",
    },
    "\U0001F470\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_with_veil_light_skin_tone",
        "id": "pria_berpenutup_kepala_warna_kulit_cerah",
        "alias": "pria_berpenutup_kepala_warna_kulit_cerah_penutup",
    },
    "\U0001F470\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_with_veil_medium-light_skin_tone",
        "id": "pria_berpenutup_kepala_warna_kulit_cerah-sedang",
        "alias": "pria_berpenutup_kepala_warna_kulit_cerah-sedang_penutup",
    },
    "\U0001F470\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_with_veil_medium_skin_tone",
        "id": "pria_berpenutup_kepala_warna_kulit_sedang",
        "alias": "pria_berpenutup_kepala_warna_kulit_sedang_penutup",
    },
    "\U0001F470\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_with_veil_medium-dark_skin_tone",
        "id": "pria_berpenutup_kepala_warna_kulit_gelap-sedang",
        "alias": "pria_berpenutup_kepala_warna_kulit_gelap-sedang_penutup",
    },
    "\U0001F470\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_with_veil_dark_skin_tone",
        "id": "pria_berpenutup_kepala_warna_kulit_gelap",
        "alias": "pria_berpenutup_kepala_warna_kulit_gelap_penutup",
    },
    "\U0001F470\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_with_veil_light_skin_tone",
        "id": "wanita_berpenutup_kepala_warna_kulit_cerah",
        "alias": "wanita_berpenutup_kepala_warna_kulit_cerah_penutup",
    },
    "\U0001F470\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_with_veil_medium-light_skin_tone",
        "id": "wanita_berpenutup_kepala_warna_kulit_cerah-sedang",
        "alias": "wanita_berpenutup_kepala_warna_kulit_cerah-sedang_penutup",
    },
    "\U0001F470\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_with_veil_medium_skin_tone",
        "id": "wanita_berpenutup_kepala_warna_kulit_sedang",
        "alias": "wanita_berpenutup_kepala_warna_kulit_sedang_penutup",
    },
    "\U0001F470\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_with_veil_medium-dark_skin_tone",
        "id": "wanita_berpenutup_kepala_warna_kulit_gelap-sedang",
        "alias": "wanita_berpenutup_kepala_warna_kulit_gelap-sedang_penutup",
    },
    "\U0001F470\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_with_veil_dark_skin_tone",
        "id": "wanita_berpenutup_kepala_warna_kulit_gelap",
        "alias": "wanita_berpenutup_kepala_warna_kulit_gelap_penutup",
    },
    "\U0001F930\U0001F3FB": {
        "en": "pregnant_woman_light_skin_tone",
        "id": "wanita_hamil_warna_kulit_cerah",
        "alias": "wanita_hamil_warna_kulit_cerah_ibu_perempuan",
    },
    "\U0001F930\U0001F3FC": {
        "en": "pregnant_woman_medium-light_skin_tone",
        "id": "wanita_hamil_warna_kulit_cerah-sedang",
        "alias": "wanita_hamil_warna_kulit_cerah-sedang_ibu_perempuan",
    },
    "\U0001F930\U0001F3FD": {
        "en": "pregnant_woman_medium_skin_tone",
        "id": "wanita_hamil_warna_kulit_sedang",
        "alias": "wanita_hamil_warna_kulit_sedang_ibu_perempuan",
    },
    "\U0001F930\U0001F3FE": {
        "en": "pregnant_woman_medium-dark_skin_tone",
        "id": "wanita_hamil_warna_kulit_gelap-sedang",
        "alias": "wanita_hamil_warna_kulit_gelap-sedang_ibu_perempuan",
    },
    "\U0001F930\U0001F3FF": {
        "en": "pregnant_woman_dark_skin_tone",
        "id": "wanita_hamil_warna_kulit_gelap",
        "alias": "wanita_hamil_warna_kulit_gelap_ibu_perempuan",
    },
    "\U0001F931\U0001F3FB": {
        "en": "breast-feeding_light_skin_tone",
        "id": "menyusui_warna_kulit_cerah",
        "alias": "menyusui_warna_kulit_cerah_bayi_payudara",
    },
    "\U0001F931\U0001F3FC": {
        "en": "breast-feeding_medium-light_skin_tone",
        "id": "menyusui_warna_kulit_cerah-sedang",
        "alias": "menyusui_warna_kulit_cerah-sedang_bayi_payudara",
    },
    "\U0001F931\U0001F3FD": {
        "en": "breast-feeding_medium_skin_tone",
        "id": "menyusui_warna_kulit_sedang",
        "alias": "menyusui_warna_kulit_sedang_bayi_payudara",
    },
    "\U0001F931\U0001F3FE": {
        "en": "breast-feeding_medium-dark_skin_tone",
        "id": "menyusui_warna_kulit_gelap-sedang",
        "alias": "menyusui_warna_kulit_gelap-sedang_bayi_payudara",
    },
    "\U0001F931\U0001F3FF": {
        "en": "breast-feeding_dark_skin_tone",
        "id": "menyusui_warna_kulit_gelap",
        "alias": "menyusui_warna_kulit_gelap_bayi_payudara",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F37C": {
        "en": "woman_feeding_baby_light_skin_tone",
        "id": "wanita_menyusui_bayi_warna_kulit_cerah",
        "alias": "wanita_menyusui_bayi_warna_kulit_cerah_mengasuh",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F37C": {
        "en": "woman_feeding_baby_medium-light_skin_tone",
        "id": "wanita_menyusui_bayi_warna_kulit_cerah-sedang",
        "alias": "wanita_menyusui_bayi_warna_kulit_cerah-sedang_mengasuh",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F37C": {
        "en": "woman_feeding_baby_medium_skin_tone",
        "id": "wanita_menyusui_bayi_warna_kulit_sedang",
        "alias": "wanita_menyusui_bayi_warna_kulit_sedang_mengasuh",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F37C": {
        "en": "woman_feeding_baby_medium-dark_skin_tone",
        "id": "wanita_menyusui_bayi_warna_kulit_gelap-sedang",
        "alias": "wanita_menyusui_bayi_warna_kulit_gelap-sedang_mengasuh",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F37C": {
        "en": "woman_feeding_baby_dark_skin_tone",
        "id": "wanita_menyusui_bayi_warna_kulit_gelap",
        "alias": "wanita_menyusui_bayi_warna_kulit_gelap_mengasuh",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F37C": {
        "en": "man_feeding_baby_light_skin_tone",
        "id": "pria_menyusui_bayi_warna_kulit_cerah",
        "alias": "pria_menyusui_bayi_warna_kulit_cerah_mengasuh",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F37C": {
        "en": "man_feeding_baby_medium-light_skin_tone",
        "id": "pria_menyusui_bayi_warna_kulit_cerah-sedang",
        "alias": "pria_menyusui_bayi_warna_kulit_cerah-sedang_mengasuh",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F37C": {
        "en": "man_feeding_baby_medium_skin_tone",
        "id": "pria_menyusui_bayi_warna_kulit_sedang",
        "alias": "pria_menyusui_bayi_warna_kulit_sedang_mengasuh",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F37C": {
        "en": "man_feeding_baby_medium-dark_skin_tone",
        "id": "pria_menyusui_bayi_warna_kulit_gelap-sedang",
        "alias": "pria_menyusui_bayi_warna_kulit_gelap-sedang_mengasuh",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F37C": {
        "en": "man_feeding_baby_dark_skin_tone",
        "id": "pria_menyusui_bayi_warna_kulit_gelap",
        "alias": "pria_menyusui_bayi_warna_kulit_gelap_mengasuh",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F37C": {
        "en": "person_feeding_baby_light_skin_tone",
        "id": "orang_menyusui_bayi_warna_kulit_cerah",
        "alias": "orang_menyusui_bayi_warna_kulit_cerah_mengasuh",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F37C": {
        "en": "person_feeding_baby_medium-light_skin_tone",
        "id": "orang_menyusui_bayi_warna_kulit_cerah-sedang",
        "alias": "orang_menyusui_bayi_warna_kulit_cerah-sedang_mengasuh",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F37C": {
        "en": "person_feeding_baby_medium_skin_tone",
        "id": "orang_menyusui_bayi_warna_kulit_sedang",
        "alias": "orang_menyusui_bayi_warna_kulit_sedang_mengasuh",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F37C": {
        "en": "person_feeding_baby_medium-dark_skin_tone",
        "id": "orang_menyusui_bayi_warna_kulit_gelap-sedang",
        "alias": "orang_menyusui_bayi_warna_kulit_gelap-sedang_mengasuh",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F37C": {
        "en": "person_feeding_baby_dark_skin_tone",
        "id": "orang_menyusui_bayi_warna_kulit_gelap",
        "alias": "orang_menyusui_bayi_warna_kulit_gelap_mengasuh",
    },
    "\U0001F47C\U0001F3FB": {
        "en": "baby_angel_light_skin_tone",
        "id": "malaikat_bayi_warna_kulit_cerah",
        "alias": "malaikat_bayi_warna_kulit_cerah_dongeng_fantasi_muka_wajah",
    },
    "\U0001F47C\U0001F3FC": {
        "en": "baby_angel_medium-light_skin_tone",
        "id": "malaikat_bayi_warna_kulit_cerah-sedang",
        "alias": "malaikat_bayi_warna_kulit_cerah-sedang_dongeng_fantasi_muka_wajah",
    },
    "\U0001F47C\U0001F3FD": {
        "en": "baby_angel_medium_skin_tone",
        "id": "malaikat_bayi_warna_kulit_sedang",
        "alias": "malaikat_bayi_warna_kulit_sedang_dongeng_fantasi_muka_wajah",
    },
    "\U0001F47C\U0001F3FE": {
        "en": "baby_angel_medium-dark_skin_tone",
        "id": "malaikat_bayi_warna_kulit_gelap-sedang",
        "alias": "malaikat_bayi_warna_kulit_gelap-sedang_dongeng_fantasi_muka_wajah",
    },
    "\U0001F47C\U0001F3FF": {
        "en": "baby_angel_dark_skin_tone",
        "id": "malaikat_bayi_warna_kulit_gelap",
        "alias": "malaikat_bayi_warna_kulit_gelap_dongeng_fantasi_muka_wajah",
    },
    "\U0001F385\U0001F3FB": {
        "en": "santa_claus_light_skin_tone",
        "id": "sinterklas_warna_kulit_cerah",
        "alias": "sinterklas_warna_kulit_cerah_dongeng_fantasi_natal_perayaan_santa",
    },
    "\U0001F385\U0001F3FC": {
        "en": "santa_claus_medium-light_skin_tone",
        "id": "sinterklas_warna_kulit_cerah-sedang",
        "alias": "sinterklas_warna_kulit_cerah-sedang_dongeng_fantasi_natal_perayaan_santa",
    },
    "\U0001F385\U0001F3FD": {
        "en": "santa_claus_medium_skin_tone",
        "id": "sinterklas_warna_kulit_sedang",
        "alias": "sinterklas_warna_kulit_sedang_dongeng_fantasi_natal_perayaan_santa",
    },
    "\U0001F385\U0001F3FE": {
        "en": "santa_claus_medium-dark_skin_tone",
        "id": "sinterklas_warna_kulit_gelap-sedang",
        "alias": "sinterklas_warna_kulit_gelap-sedang_dongeng_fantasi_natal_perayaan_santa",
    },
    "\U0001F385\U0001F3FF": {
        "en": "santa_claus_dark_skin_tone",
        "id": "sinterklas_warna_kulit_gelap",
        "alias": "sinterklas_warna_kulit_gelap_dongeng_fantasi_natal_perayaan_santa",
    },
    "\U0001F936\U0001F3FB": {
        "en": "mrs._claus_light_skin_tone",
        "id": "nyonya_sinterklas_warna_kulit_cerah",
        "alias": "nyonya_sinterklas_warna_kulit_cerah_ibu_nenek_oma",
    },
    "\U0001F936\U0001F3FC": {
        "en": "mrs._claus_medium-light_skin_tone",
        "id": "nyonya_sinterklas_warna_kulit_cerah-sedang",
        "alias": "nyonya_sinterklas_warna_kulit_cerah-sedang_ibu_nenek_oma",
    },
    "\U0001F936\U0001F3FD": {
        "en": "mrs._claus_medium_skin_tone",
        "id": "nyonya_sinterklas_warna_kulit_sedang",
        "alias": "nyonya_sinterklas_warna_kulit_sedang_ibu_nenek_oma",
    },
    "\U0001F936\U0001F3FE": {
        "en": "mrs._claus_medium-dark_skin_tone",
        "id": "nyonya_sinterklas_warna_kulit_gelap-sedang",
        "alias": "nyonya_sinterklas_warna_kulit_gelap-sedang_ibu_nenek_oma",
    },
    "\U0001F936\U0001F3FF": {
        "en": "mrs._claus_dark_skin_tone",
        "id": "nyonya_sinterklas_warna_kulit_gelap",
        "alias": "nyonya_sinterklas_warna_kulit_gelap_ibu_nenek_oma",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F384": {
        "en": "mx_claus_light_skin_tone",
        "id": "manusia_sinterklas_warna_kulit_cerah",
        "alias": "manusia_sinterklas_warna_kulit_cerah_natal",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F384": {
        "en": "mx_claus_medium-light_skin_tone",
        "id": "manusia_sinterklas_warna_kulit_cerah-sedang",
        "alias": "manusia_sinterklas_warna_kulit_cerah-sedang_natal",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F384": {
        "en": "mx_claus_medium_skin_tone",
        "id": "manusia_sinterklas_warna_kulit_sedang",
        "alias": "manusia_sinterklas_warna_kulit_sedang_natal",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F384": {
        "en": "mx_claus_medium-dark_skin_tone",
        "id": "manusia_sinterklas_warna_kulit_gelap-sedang",
        "alias": "manusia_sinterklas_warna_kulit_gelap-sedang_natal",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F384": {
        "en": "mx_claus_dark_skin_tone",
        "id": "manusia_sinterklas_warna_kulit_gelap",
        "alias": "manusia_sinterklas_warna_kulit_gelap_natal",
    },
    "\U0001F9B8\U0001F3FB": {
        "en": "superhero_light_skin_tone",
        "id": "pahlawan_super_warna_kulit_cerah",
        "alias": "pahlawan_super_warna_kulit_cerah_baik_kekuatan_wanita",
    },
    "\U0001F9B8\U0001F3FC": {
        "en": "superhero_medium-light_skin_tone",
        "id": "pahlawan_super_warna_kulit_cerah-sedang",
        "alias": "pahlawan_super_warna_kulit_cerah-sedang_baik_kekuatan_wanita",
    },
    "\U0001F9B8\U0001F3FD": {
        "en": "superhero_medium_skin_tone",
        "id": "pahlawan_super_warna_kulit_sedang",
        "alias": "pahlawan_super_warna_kulit_sedang_baik_kekuatan_wanita",
    },
    "\U0001F9B8\U0001F3FE": {
        "en": "superhero_medium-dark_skin_tone",
        "id": "pahlawan_super_warna_kulit_gelap-sedang",
        "alias": "pahlawan_super_warna_kulit_gelap-sedang_baik_kekuatan_wanita",
    },
    "\U0001F9B8\U0001F3FF": {
        "en": "superhero_dark_skin_tone",
        "id": "pahlawan_super_warna_kulit_gelap",
        "alias": "pahlawan_super_warna_kulit_gelap_baik_kekuatan_wanita",
    },
    "\U0001F9B8\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_superhero_light_skin_tone",
        "id": "pahlawan_super_pria_warna_kulit_cerah",
        "alias": "pahlawan_super_pria_warna_kulit_cerah_baik_kekuatan",
    },
    "\U0001F9B8\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_superhero_medium-light_skin_tone",
        "id": "pahlawan_super_pria_warna_kulit_cerah-sedang",
        "alias": "pahlawan_super_pria_warna_kulit_cerah-sedang_baik_kekuatan",
    },
    "\U0001F9B8\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_superhero_medium_skin_tone",
        "id": "pahlawan_super_pria_warna_kulit_sedang",
        "alias": "pahlawan_super_pria_warna_kulit_sedang_baik_kekuatan",
    },
    "\U0001F9B8\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_superhero_medium-dark_skin_tone",
        "id": "pahlawan_super_pria_warna_kulit_gelap-sedang",
        "alias": "pahlawan_super_pria_warna_kulit_gelap-sedang_baik_kekuatan",
    },
    "\U0001F9B8\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_superhero_dark_skin_tone",
        "id": "pahlawan_super_pria_warna_kulit_gelap",
        "alias": "pahlawan_super_pria_warna_kulit_gelap_baik_kekuatan",
    },
    "\U0001F9B8\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_superhero_light_skin_tone",
        "id": "pahlawan_super_wanita_warna_kulit_cerah",
        "alias": "pahlawan_super_wanita_warna_kulit_cerah_baik_kekuatan",
    },
    "\U0001F9B8\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_superhero_medium-light_skin_tone",
        "id": "pahlawan_super_wanita_warna_kulit_cerah-sedang",
        "alias": "pahlawan_super_wanita_warna_kulit_cerah-sedang_baik_kekuatan",
    },
    "\U0001F9B8\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_superhero_medium_skin_tone",
        "id": "pahlawan_super_wanita_warna_kulit_sedang",
        "alias": "pahlawan_super_wanita_warna_kulit_sedang_baik_kekuatan",
    },
    "\U0001F9B8\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_superhero_medium-dark_skin_tone",
        "id": "pahlawan_super_wanita_warna_kulit_gelap-sedang",
        "alias": "pahlawan_super_wanita_warna_kulit_gelap-sedang_baik_kekuatan",
    },
    "\U0001F9B8\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_superhero_dark_skin_tone",
        "id": "pahlawan_super_wanita_warna_kulit_gelap",
        "alias": "pahlawan_super_wanita_warna_kulit_gelap_baik_kekuatan",
    },
    "\U0001F9B9\U0001F3FB": {
        "en": "supervillain_light_skin_tone",
        "id": "penjahat_super_warna_kulit_cerah",
        "alias": "penjahat_super_warna_kulit_cerah_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FC": {
        "en": "supervillain_medium-light_skin_tone",
        "id": "penjahat_super_warna_kulit_cerah-sedang",
        "alias": "penjahat_super_warna_kulit_cerah-sedang_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FD": {
        "en": "supervillain_medium_skin_tone",
        "id": "penjahat_super_warna_kulit_sedang",
        "alias": "penjahat_super_warna_kulit_sedang_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FE": {
        "en": "supervillain_medium-dark_skin_tone",
        "id": "penjahat_super_warna_kulit_gelap-sedang",
        "alias": "penjahat_super_warna_kulit_gelap-sedang_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FF": {
        "en": "supervillain_dark_skin_tone",
        "id": "penjahat_super_warna_kulit_gelap",
        "alias": "penjahat_super_warna_kulit_gelap_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_supervillain_light_skin_tone",
        "id": "penjahat_super_pria_warna_kulit_cerah",
        "alias": "penjahat_super_pria_warna_kulit_cerah_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_supervillain_medium-light_skin_tone",
        "id": "penjahat_super_pria_warna_kulit_cerah-sedang",
        "alias": "penjahat_super_pria_warna_kulit_cerah-sedang_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_supervillain_medium_skin_tone",
        "id": "penjahat_super_pria_warna_kulit_sedang",
        "alias": "penjahat_super_pria_warna_kulit_sedang_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_supervillain_medium-dark_skin_tone",
        "id": "penjahat_super_pria_warna_kulit_gelap-sedang",
        "alias": "penjahat_super_pria_warna_kulit_gelap-sedang_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_supervillain_dark_skin_tone",
        "id": "penjahat_super_pria_warna_kulit_gelap",
        "alias": "penjahat_super_pria_warna_kulit_gelap_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_supervillain_light_skin_tone",
        "id": "penjahat_super_wanita_warna_kulit_cerah",
        "alias": "penjahat_super_wanita_warna_kulit_cerah_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_supervillain_medium-light_skin_tone",
        "id": "penjahat_super_wanita_warna_kulit_cerah-sedang",
        "alias": "penjahat_super_wanita_warna_kulit_cerah-sedang_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_supervillain_medium_skin_tone",
        "id": "penjahat_super_wanita_warna_kulit_sedang",
        "alias": "penjahat_super_wanita_warna_kulit_sedang_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_supervillain_medium-dark_skin_tone",
        "id": "penjahat_super_wanita_warna_kulit_gelap-sedang",
        "alias": "penjahat_super_wanita_warna_kulit_gelap-sedang_jahat_kekuatan_kriminal",
    },
    "\U0001F9B9\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_supervillain_dark_skin_tone",
        "id": "penjahat_super_wanita_warna_kulit_gelap",
        "alias": "penjahat_super_wanita_warna_kulit_gelap_jahat_kekuatan_kriminal",
    },
    "\U0001F9D9\U0001F3FB": {
        "en": "mage_light_skin_tone",
        "id": "magi_warna_kulit_cerah",
        "alias": "magi_warna_kulit_cerah_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FC": {
        "en": "mage_medium-light_skin_tone",
        "id": "magi_warna_kulit_cerah-sedang",
        "alias": "magi_warna_kulit_cerah-sedang_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FD": {
        "en": "mage_medium_skin_tone",
        "id": "magi_warna_kulit_sedang",
        "alias": "magi_warna_kulit_sedang_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FE": {
        "en": "mage_medium-dark_skin_tone",
        "id": "magi_warna_kulit_gelap-sedang",
        "alias": "magi_warna_kulit_gelap-sedang_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FF": {
        "en": "mage_dark_skin_tone",
        "id": "magi_warna_kulit_gelap",
        "alias": "magi_warna_kulit_gelap_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mage_light_skin_tone",
        "id": "magi_pria_warna_kulit_cerah",
        "alias": "magi_pria_warna_kulit_cerah_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mage_medium-light_skin_tone",
        "id": "magi_pria_warna_kulit_cerah-sedang",
        "alias": "magi_pria_warna_kulit_cerah-sedang_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mage_medium_skin_tone",
        "id": "magi_pria_warna_kulit_sedang",
        "alias": "magi_pria_warna_kulit_sedang_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mage_medium-dark_skin_tone",
        "id": "magi_pria_warna_kulit_gelap-sedang",
        "alias": "magi_pria_warna_kulit_gelap-sedang_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mage_dark_skin_tone",
        "id": "magi_pria_warna_kulit_gelap",
        "alias": "magi_pria_warna_kulit_gelap_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mage_light_skin_tone",
        "id": "magi_wanita_warna_kulit_cerah",
        "alias": "magi_wanita_warna_kulit_cerah_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mage_medium-light_skin_tone",
        "id": "magi_wanita_warna_kulit_cerah-sedang",
        "alias": "magi_wanita_warna_kulit_cerah-sedang_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mage_medium_skin_tone",
        "id": "magi_wanita_warna_kulit_sedang",
        "alias": "magi_wanita_warna_kulit_sedang_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mage_medium-dark_skin_tone",
        "id": "magi_wanita_warna_kulit_gelap-sedang",
        "alias": "magi_wanita_warna_kulit_gelap-sedang_penyihir_tukang_sihir",
    },
    "\U0001F9D9\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mage_dark_skin_tone",
        "id": "magi_wanita_warna_kulit_gelap",
        "alias": "magi_wanita_warna_kulit_gelap_penyihir_tukang_sihir",
    },
    "\U0001F9DA\U0001F3FB": {
        "en": "fairy_light_skin_tone",
        "id": "peri_warna_kulit_cerah",
        "alias": "peri_warna_kulit_cerah_oberon_puck_titania",
    },
    "\U0001F9DA\U0001F3FC": {
        "en": "fairy_medium-light_skin_tone",
        "id": "peri_warna_kulit_cerah-sedang",
        "alias": "peri_warna_kulit_cerah-sedang_oberon_puck_titania",
    },
    "\U0001F9DA\U0001F3FD": {
        "en": "fairy_medium_skin_tone",
        "id": "peri_warna_kulit_sedang",
        "alias": "peri_warna_kulit_sedang_oberon_puck_titania",
    },
    "\U0001F9DA\U0001F3FE": {
        "en": "fairy_medium-dark_skin_tone",
        "id": "peri_warna_kulit_gelap-sedang",
        "alias": "peri_warna_kulit_gelap-sedang_oberon_puck_titania",
    },
    "\U0001F9DA\U0001F3FF": {
        "en": "fairy_dark_skin_tone",
        "id": "peri_warna_kulit_gelap",
        "alias": "peri_warna_kulit_gelap_oberon_puck_titania",
    },
    "\U0001F9DA\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_fairy_light_skin_tone",
        "id": "peri_pria_warna_kulit_cerah",
        "alias": "peri_pria_warna_kulit_cerah_oberon_puck",
    },
    "\U0001F9DA\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_fairy_medium-light_skin_tone",
        "id": "peri_pria_warna_kulit_cerah-sedang",
        "alias": "peri_pria_warna_kulit_cerah-sedang_oberon_puck",
    },
    "\U0001F9DA\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_fairy_medium_skin_tone",
        "id": "peri_pria_warna_kulit_sedang",
        "alias": "peri_pria_warna_kulit_sedang_oberon_puck",
    },
    "\U0001F9DA\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_fairy_medium-dark_skin_tone",
        "id": "peri_pria_warna_kulit_gelap-sedang",
        "alias": "peri_pria_warna_kulit_gelap-sedang_oberon_puck",
    },
    "\U0001F9DA\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_fairy_dark_skin_tone",
        "id": "peri_pria_warna_kulit_gelap",
        "alias": "peri_pria_warna_kulit_gelap_oberon_puck",
    },
    "\U0001F9DA\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_fairy_light_skin_tone",
        "id": "peri_wanita_warna_kulit_cerah",
        "alias": "peri_wanita_warna_kulit_cerah_titania",
    },
    "\U0001F9DA\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_fairy_medium-light_skin_tone",
        "id": "peri_wanita_warna_kulit_cerah-sedang",
        "alias": "peri_wanita_warna_kulit_cerah-sedang_titania",
    },
    "\U0001F9DA\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_fairy_medium_skin_tone",
        "id": "peri_wanita_warna_kulit_sedang",
        "alias": "peri_wanita_warna_kulit_sedang_titania",
    },
    "\U0001F9DA\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_fairy_medium-dark_skin_tone",
        "id": "peri_wanita_warna_kulit_gelap-sedang",
        "alias": "peri_wanita_warna_kulit_gelap-sedang_titania",
    },
    "\U0001F9DA\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_fairy_dark_skin_tone",
        "id": "peri_wanita_warna_kulit_gelap",
        "alias": "peri_wanita_warna_kulit_gelap_titania",
    },
    "\U0001F9DB\U0001F3FB": {
        "en": "vampire_light_skin_tone",
        "id": "vampir_warna_kulit_cerah",
        "alias": "vampir_warna_kulit_cerah_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FC": {
        "en": "vampire_medium-light_skin_tone",
        "id": "vampir_warna_kulit_cerah-sedang",
        "alias": "vampir_warna_kulit_cerah-sedang_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FD": {
        "en": "vampire_medium_skin_tone",
        "id": "vampir_warna_kulit_sedang",
        "alias": "vampir_warna_kulit_sedang_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FE": {
        "en": "vampire_medium-dark_skin_tone",
        "id": "vampir_warna_kulit_gelap-sedang",
        "alias": "vampir_warna_kulit_gelap-sedang_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FF": {
        "en": "vampire_dark_skin_tone",
        "id": "vampir_warna_kulit_gelap",
        "alias": "vampir_warna_kulit_gelap_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_vampire_light_skin_tone",
        "id": "vampir_pria_warna_kulit_cerah",
        "alias": "vampir_pria_warna_kulit_cerah_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_vampire_medium-light_skin_tone",
        "id": "vampir_pria_warna_kulit_cerah-sedang",
        "alias": "vampir_pria_warna_kulit_cerah-sedang_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_vampire_medium_skin_tone",
        "id": "vampir_pria_warna_kulit_sedang",
        "alias": "vampir_pria_warna_kulit_sedang_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_vampire_medium-dark_skin_tone",
        "id": "vampir_pria_warna_kulit_gelap-sedang",
        "alias": "vampir_pria_warna_kulit_gelap-sedang_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_vampire_dark_skin_tone",
        "id": "vampir_pria_warna_kulit_gelap",
        "alias": "vampir_pria_warna_kulit_gelap_drakula_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_vampire_light_skin_tone",
        "id": "vampir_wanita_warna_kulit_cerah",
        "alias": "vampir_wanita_warna_kulit_cerah_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_vampire_medium-light_skin_tone",
        "id": "vampir_wanita_warna_kulit_cerah-sedang",
        "alias": "vampir_wanita_warna_kulit_cerah-sedang_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_vampire_medium_skin_tone",
        "id": "vampir_wanita_warna_kulit_sedang",
        "alias": "vampir_wanita_warna_kulit_sedang_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_vampire_medium-dark_skin_tone",
        "id": "vampir_wanita_warna_kulit_gelap-sedang",
        "alias": "vampir_wanita_warna_kulit_gelap-sedang_mayat_hidup",
    },
    "\U0001F9DB\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_vampire_dark_skin_tone",
        "id": "vampir_wanita_warna_kulit_gelap",
        "alias": "vampir_wanita_warna_kulit_gelap_mayat_hidup",
    },
    "\U0001F9DC\U0001F3FB": {
        "en": "merperson_light_skin_tone",
        "id": "orang_duyung_warna_kulit_cerah",
        "alias": "orang_duyung_warna_kulit_cerah_pria_putri_wanita",
    },
    "\U0001F9DC\U0001F3FC": {
        "en": "merperson_medium-light_skin_tone",
        "id": "orang_duyung_warna_kulit_cerah-sedang",
        "alias": "orang_duyung_warna_kulit_cerah-sedang_pria_putri_wanita",
    },
    "\U0001F9DC\U0001F3FD": {
        "en": "merperson_medium_skin_tone",
        "id": "orang_duyung_warna_kulit_sedang",
        "alias": "orang_duyung_warna_kulit_sedang_pria_putri_wanita",
    },
    "\U0001F9DC\U0001F3FE": {
        "en": "merperson_medium-dark_skin_tone",
        "id": "orang_duyung_warna_kulit_gelap-sedang",
        "alias": "orang_duyung_warna_kulit_gelap-sedang_pria_putri_wanita",
    },
    "\U0001F9DC\U0001F3FF": {
        "en": "merperson_dark_skin_tone",
        "id": "orang_duyung_warna_kulit_gelap",
        "alias": "orang_duyung_warna_kulit_gelap_pria_putri_wanita",
    },
    "\U0001F9DC\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "merman_light_skin_tone",
        "id": "pria_duyung_warna_kulit_cerah",
        "alias": "pria_duyung_warna_kulit_cerah_triton",
    },
    "\U0001F9DC\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "merman_medium-light_skin_tone",
        "id": "pria_duyung_warna_kulit_cerah-sedang",
        "alias": "pria_duyung_warna_kulit_cerah-sedang_triton",
    },
    "\U0001F9DC\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "merman_medium_skin_tone",
        "id": "pria_duyung_warna_kulit_sedang",
        "alias": "pria_duyung_warna_kulit_sedang_triton",
    },
    "\U0001F9DC\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "merman_medium-dark_skin_tone",
        "id": "pria_duyung_warna_kulit_gelap-sedang",
        "alias": "pria_duyung_warna_kulit_gelap-sedang_triton",
    },
    "\U0001F9DC\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "merman_dark_skin_tone",
        "id": "pria_duyung_warna_kulit_gelap",
        "alias": "pria_duyung_warna_kulit_gelap_triton",
    },
    "\U0001F9DC\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "mermaid_light_skin_tone",
        "id": "putri_duyung_warna_kulit_cerah",
        "alias": "putri_duyung_warna_kulit_cerah_wanita",
    },
    "\U0001F9DC\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "mermaid_medium-light_skin_tone",
        "id": "putri_duyung_warna_kulit_cerah-sedang",
        "alias": "putri_duyung_warna_kulit_cerah-sedang_wanita",
    },
    "\U0001F9DC\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "mermaid_medium_skin_tone",
        "id": "putri_duyung_warna_kulit_sedang",
        "alias": "putri_duyung_warna_kulit_sedang_wanita",
    },
    "\U0001F9DC\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "mermaid_medium-dark_skin_tone",
        "id": "putri_duyung_warna_kulit_gelap-sedang",
        "alias": "putri_duyung_warna_kulit_gelap-sedang_wanita",
    },
    "\U0001F9DC\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "mermaid_dark_skin_tone",
        "id": "putri_duyung_warna_kulit_gelap",
        "alias": "putri_duyung_warna_kulit_gelap_wanita",
    },
    "\U0001F9DD\U0001F3FB": {
        "en": "elf_light_skin_tone",
        "id": "kurcaci_warna_kulit_cerah",
        "alias": "kurcaci_warna_kulit_cerah_ajaib",
    },
    "\U0001F9DD\U0001F3FC": {
        "en": "elf_medium-light_skin_tone",
        "id": "kurcaci_warna_kulit_cerah-sedang",
        "alias": "kurcaci_warna_kulit_cerah-sedang_ajaib",
    },
    "\U0001F9DD\U0001F3FD": {
        "en": "elf_medium_skin_tone",
        "id": "kurcaci_warna_kulit_sedang",
        "alias": "kurcaci_warna_kulit_sedang_ajaib",
    },
    "\U0001F9DD\U0001F3FE": {
        "en": "elf_medium-dark_skin_tone",
        "id": "kurcaci_warna_kulit_gelap-sedang",
        "alias": "kurcaci_warna_kulit_gelap-sedang_ajaib",
    },
    "\U0001F9DD\U0001F3FF": {
        "en": "elf_dark_skin_tone",
        "id": "kurcaci_warna_kulit_gelap",
        "alias": "kurcaci_warna_kulit_gelap_ajaib",
    },
    "\U0001F9DD\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_elf_light_skin_tone",
        "id": "kurcaci_pria_warna_kulit_cerah",
        "alias": "kurcaci_pria_warna_kulit_cerah_ajaib",
    },
    "\U0001F9DD\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_elf_medium-light_skin_tone",
        "id": "kurcaci_pria_warna_kulit_cerah-sedang",
        "alias": "kurcaci_pria_warna_kulit_cerah-sedang_ajaib",
    },
    "\U0001F9DD\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_elf_medium_skin_tone",
        "id": "kurcaci_pria_warna_kulit_sedang",
        "alias": "kurcaci_pria_warna_kulit_sedang_ajaib",
    },
    "\U0001F9DD\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_elf_medium-dark_skin_tone",
        "id": "kurcaci_pria_warna_kulit_gelap-sedang",
        "alias": "kurcaci_pria_warna_kulit_gelap-sedang_ajaib",
    },
    "\U0001F9DD\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_elf_dark_skin_tone",
        "id": "kurcaci_pria_warna_kulit_gelap",
        "alias": "kurcaci_pria_warna_kulit_gelap_ajaib",
    },
    "\U0001F9DD\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_elf_light_skin_tone",
        "id": "kurcaci_wanita_warna_kulit_cerah",
        "alias": "kurcaci_wanita_warna_kulit_cerah_ajaib",
    },
    "\U0001F9DD\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_elf_medium-light_skin_tone",
        "id": "kurcaci_wanita_warna_kulit_cerah-sedang",
        "alias": "kurcaci_wanita_warna_kulit_cerah-sedang_ajaib",
    },
    "\U0001F9DD\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_elf_medium_skin_tone",
        "id": "kurcaci_wanita_warna_kulit_sedang",
        "alias": "kurcaci_wanita_warna_kulit_sedang_ajaib",
    },
    "\U0001F9DD\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_elf_medium-dark_skin_tone",
        "id": "kurcaci_wanita_warna_kulit_gelap-sedang",
        "alias": "kurcaci_wanita_warna_kulit_gelap-sedang_ajaib",
    },
    "\U0001F9DD\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_elf_dark_skin_tone",
        "id": "kurcaci_wanita_warna_kulit_gelap",
        "alias": "kurcaci_wanita_warna_kulit_gelap_ajaib",
    },
    "\U0001F486\U0001F3FB": {
        "en": "person_getting_massage_light_skin_tone",
        "id": "pria_dipijat_warna_kulit_cerah",
        "alias": "pria_dipijat_warna_kulit_cerah_pijat_pijit_salon",
    },
    "\U0001F486\U0001F3FC": {
        "en": "person_getting_massage_medium-light_skin_tone",
        "id": "pria_dipijat_warna_kulit_cerah-sedang",
        "alias": "pria_dipijat_warna_kulit_cerah-sedang_pijat_pijit_salon",
    },
    "\U0001F486\U0001F3FD": {
        "en": "person_getting_massage_medium_skin_tone",
        "id": "pria_dipijat_warna_kulit_sedang",
        "alias": "pria_dipijat_warna_kulit_sedang_pijat_pijit_salon",
    },
    "\U0001F486\U0001F3FE": {
        "en": "person_getting_massage_medium-dark_skin_tone",
        "id": "pria_dipijat_warna_kulit_gelap-sedang",
        "alias": "pria_dipijat_warna_kulit_gelap-sedang_pijat_pijit_salon",
    },
    "\U0001F486\U0001F3FF": {
        "en": "person_getting_massage_dark_skin_tone",
        "id": "pria_dipijat_warna_kulit_gelap",
        "alias": "pria_dipijat_warna_kulit_gelap_pijat_pijit_salon",
    },
    "\U0001F486\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_massage_light_skin_tone",
        "id": "pria_dipijat_kepalanya_warna_kulit_cerah",
        "alias": "pria_dipijat_kepalanya_warna_kulit_cerah_kepala_laki-laki_pijat",
    },
    "\U0001F486\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_massage_medium-light_skin_tone",
        "id": "pria_dipijat_kepalanya_warna_kulit_cerah-sedang",
        "alias": "pria_dipijat_kepalanya_warna_kulit_cerah-sedang_kepala_laki-laki_pijat",
    },
    "\U0001F486\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_massage_medium_skin_tone",
        "id": "pria_dipijat_kepalanya_warna_kulit_sedang",
        "alias": "pria_dipijat_kepalanya_warna_kulit_sedang_kepala_laki-laki_pijat",
    },
    "\U0001F486\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_massage_medium-dark_skin_tone",
        "id": "pria_dipijat_kepalanya_warna_kulit_gelap-sedang",
        "alias": "pria_dipijat_kepalanya_warna_kulit_gelap-sedang_kepala_laki-laki_pijat",
    },
    "\U0001F486\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_massage_dark_skin_tone",
        "id": "pria_dipijat_kepalanya_warna_kulit_gelap",
        "alias": "pria_dipijat_kepalanya_warna_kulit_gelap_kepala_laki-laki_pijat",
    },
    "\U0001F486\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_massage_light_skin_tone",
        "id": "wanita_dipijat_warna_kulit_cerah",
        "alias": "wanita_dipijat_warna_kulit_cerah_kepala_perempuan_pijat",
    },
    "\U0001F486\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_massage_medium-light_skin_tone",
        "id": "wanita_dipijat_warna_kulit_cerah-sedang",
        "alias": "wanita_dipijat_warna_kulit_cerah-sedang_kepala_perempuan_pijat",
    },
    "\U0001F486\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_massage_medium_skin_tone",
        "id": "wanita_dipijat_warna_kulit_sedang",
        "alias": "wanita_dipijat_warna_kulit_sedang_kepala_perempuan_pijat",
    },
    "\U0001F486\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_massage_medium-dark_skin_tone",
        "id": "wanita_dipijat_warna_kulit_gelap-sedang",
        "alias": "wanita_dipijat_warna_kulit_gelap-sedang_kepala_perempuan_pijat",
    },
    "\U0001F486\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_massage_dark_skin_tone",
        "id": "wanita_dipijat_warna_kulit_gelap",
        "alias": "wanita_dipijat_warna_kulit_gelap_kepala_perempuan_pijat",
    },
    "\U0001F487\U0001F3FB": {
        "en": "person_getting_haircut_light_skin_tone",
        "id": "orang_potong_rambut_warna_kulit_cerah",
        "alias": "orang_potong_rambut_warna_kulit_cerah_cantik_salon",
    },
    "\U0001F487\U0001F3FC": {
        "en": "person_getting_haircut_medium-light_skin_tone",
        "id": "orang_potong_rambut_warna_kulit_cerah-sedang",
        "alias": "orang_potong_rambut_warna_kulit_cerah-sedang_cantik_salon",
    },
    "\U0001F487\U0001F3FD": {
        "en": "person_getting_haircut_medium_skin_tone",
        "id": "orang_potong_rambut_warna_kulit_sedang",
        "alias": "orang_potong_rambut_warna_kulit_sedang_cantik_salon",
    },
    "\U0001F487\U0001F3FE": {
        "en": "person_getting_haircut_medium-dark_skin_tone",
        "id": "orang_potong_rambut_warna_kulit_gelap-sedang",
        "alias": "orang_potong_rambut_warna_kulit_gelap-sedang_cantik_salon",
    },
    "\U0001F487\U0001F3FF": {
        "en": "person_getting_haircut_dark_skin_tone",
        "id": "orang_potong_rambut_warna_kulit_gelap",
        "alias": "orang_potong_rambut_warna_kulit_gelap_cantik_salon",
    },
    "\U0001F487\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_haircut_light_skin_tone",
        "id": "pria_potong_rambut_warna_kulit_cerah",
        "alias": "pria_potong_rambut_warna_kulit_cerah_laki-laki",
    },
    "\U0001F487\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_haircut_medium-light_skin_tone",
        "id": "pria_potong_rambut_warna_kulit_cerah-sedang",
        "alias": "pria_potong_rambut_warna_kulit_cerah-sedang_laki-laki",
    },
    "\U0001F487\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_haircut_medium_skin_tone",
        "id": "pria_potong_rambut_warna_kulit_sedang",
        "alias": "pria_potong_rambut_warna_kulit_sedang_laki-laki",
    },
    "\U0001F487\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_haircut_medium-dark_skin_tone",
        "id": "pria_potong_rambut_warna_kulit_gelap-sedang",
        "alias": "pria_potong_rambut_warna_kulit_gelap-sedang_laki-laki",
    },
    "\U0001F487\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_getting_haircut_dark_skin_tone",
        "id": "pria_potong_rambut_warna_kulit_gelap",
        "alias": "pria_potong_rambut_warna_kulit_gelap_laki-laki",
    },
    "\U0001F487\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_haircut_light_skin_tone",
        "id": "wanita_potong_rambut_warna_kulit_cerah",
        "alias": "wanita_potong_rambut_warna_kulit_cerah_perempuan",
    },
    "\U0001F487\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_haircut_medium-light_skin_tone",
        "id": "wanita_potong_rambut_warna_kulit_cerah-sedang",
        "alias": "wanita_potong_rambut_warna_kulit_cerah-sedang_perempuan",
    },
    "\U0001F487\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_haircut_medium_skin_tone",
        "id": "wanita_potong_rambut_warna_kulit_sedang",
        "alias": "wanita_potong_rambut_warna_kulit_sedang_perempuan",
    },
    "\U0001F487\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_haircut_medium-dark_skin_tone",
        "id": "wanita_potong_rambut_warna_kulit_gelap-sedang",
        "alias": "wanita_potong_rambut_warna_kulit_gelap-sedang_perempuan",
    },
    "\U0001F487\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_getting_haircut_dark_skin_tone",
        "id": "wanita_potong_rambut_warna_kulit_gelap",
        "alias": "wanita_potong_rambut_warna_kulit_gelap_perempuan",
    },
    "\U0001F6B6\U0001F3FB": {
        "en": "person_walking_light_skin_tone",
        "id": "orang_berjalan_kaki_warna_kulit_cerah",
        "alias": "orang_berjalan_kaki_warna_kulit_cerah_jalan",
    },
    "\U0001F6B6\U0001F3FC": {
        "en": "person_walking_medium-light_skin_tone",
        "id": "orang_berjalan_kaki_warna_kulit_cerah-sedang",
        "alias": "orang_berjalan_kaki_warna_kulit_cerah-sedang_jalan",
    },
    "\U0001F6B6\U0001F3FD": {
        "en": "person_walking_medium_skin_tone",
        "id": "orang_berjalan_kaki_warna_kulit_sedang",
        "alias": "orang_berjalan_kaki_warna_kulit_sedang_jalan",
    },
    "\U0001F6B6\U0001F3FE": {
        "en": "person_walking_medium-dark_skin_tone",
        "id": "orang_berjalan_kaki_warna_kulit_gelap-sedang",
        "alias": "orang_berjalan_kaki_warna_kulit_gelap-sedang_jalan",
    },
    "\U0001F6B6\U0001F3FF": {
        "en": "person_walking_dark_skin_tone",
        "id": "orang_berjalan_kaki_warna_kulit_gelap",
        "alias": "orang_berjalan_kaki_warna_kulit_gelap_jalan",
    },
    "\U0001F6B6\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_walking_light_skin_tone",
        "id": "pria_berjalan_kaki_warna_kulit_cerah",
        "alias": "pria_berjalan_kaki_warna_kulit_cerah_jalan_laki-laki",
    },
    "\U0001F6B6\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_walking_medium-light_skin_tone",
        "id": "pria_berjalan_kaki_warna_kulit_cerah-sedang",
        "alias": "pria_berjalan_kaki_warna_kulit_cerah-sedang_jalan_laki-laki",
    },
    "\U0001F6B6\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_walking_medium_skin_tone",
        "id": "pria_berjalan_kaki_warna_kulit_sedang",
        "alias": "pria_berjalan_kaki_warna_kulit_sedang_jalan_laki-laki",
    },
    "\U0001F6B6\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_walking_medium-dark_skin_tone",
        "id": "pria_berjalan_kaki_warna_kulit_gelap-sedang",
        "alias": "pria_berjalan_kaki_warna_kulit_gelap-sedang_jalan_laki-laki",
    },
    "\U0001F6B6\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_walking_dark_skin_tone",
        "id": "pria_berjalan_kaki_warna_kulit_gelap",
        "alias": "pria_berjalan_kaki_warna_kulit_gelap_jalan_laki-laki",
    },
    "\U0001F6B6\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_walking_light_skin_tone",
        "id": "wanita_berjalan_kaki_warna_kulit_cerah",
        "alias": "wanita_berjalan_kaki_warna_kulit_cerah_jalan_perempuan",
    },
    "\U0001F6B6\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_walking_medium-light_skin_tone",
        "id": "wanita_berjalan_kaki_warna_kulit_cerah-sedang",
        "alias": "wanita_berjalan_kaki_warna_kulit_cerah-sedang_jalan_perempuan",
    },
    "\U0001F6B6\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_walking_medium_skin_tone",
        "id": "wanita_berjalan_kaki_warna_kulit_sedang",
        "alias": "wanita_berjalan_kaki_warna_kulit_sedang_jalan_perempuan",
    },
    "\U0001F6B6\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_walking_medium-dark_skin_tone",
        "id": "wanita_berjalan_kaki_warna_kulit_gelap-sedang",
        "alias": "wanita_berjalan_kaki_warna_kulit_gelap-sedang_jalan_perempuan",
    },
    "\U0001F6B6\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_walking_dark_skin_tone",
        "id": "wanita_berjalan_kaki_warna_kulit_gelap",
        "alias": "wanita_berjalan_kaki_warna_kulit_gelap_jalan_perempuan",
    },
    "\U0001F9CD\U0001F3FB": {
        "en": "person_standing_light_skin_tone",
        "id": "orang_berdiri_warna_kulit_cerah",
        "alias": "orang_berdiri_warna_kulit_cerah_diri",
    },
    "\U0001F9CD\U0001F3FC": {
        "en": "person_standing_medium-light_skin_tone",
        "id": "orang_berdiri_warna_kulit_cerah-sedang",
        "alias": "orang_berdiri_warna_kulit_cerah-sedang_diri",
    },
    "\U0001F9CD\U0001F3FD": {
        "en": "person_standing_medium_skin_tone",
        "id": "orang_berdiri_warna_kulit_sedang",
        "alias": "orang_berdiri_warna_kulit_sedang_diri",
    },
    "\U0001F9CD\U0001F3FE": {
        "en": "person_standing_medium-dark_skin_tone",
        "id": "orang_berdiri_warna_kulit_gelap-sedang",
        "alias": "orang_berdiri_warna_kulit_gelap-sedang_diri",
    },
    "\U0001F9CD\U0001F3FF": {
        "en": "person_standing_dark_skin_tone",
        "id": "orang_berdiri_warna_kulit_gelap",
        "alias": "orang_berdiri_warna_kulit_gelap_diri",
    },
    "\U0001F9CD\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_standing_light_skin_tone",
        "id": "pria_berdiri_warna_kulit_cerah",
    },
    "\U0001F9CD\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_standing_medium-light_skin_tone",
        "id": "pria_berdiri_warna_kulit_cerah-sedang",
    },
    "\U0001F9CD\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_standing_medium_skin_tone",
        "id": "pria_berdiri_warna_kulit_sedang",
    },
    "\U0001F9CD\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_standing_medium-dark_skin_tone",
        "id": "pria_berdiri_warna_kulit_gelap-sedang",
    },
    "\U0001F9CD\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_standing_dark_skin_tone",
        "id": "pria_berdiri_warna_kulit_gelap",
    },
    "\U0001F9CD\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_standing_light_skin_tone",
        "id": "wanita_berdiri_warna_kulit_cerah",
    },
    "\U0001F9CD\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_standing_medium-light_skin_tone",
        "id": "wanita_berdiri_warna_kulit_cerah-sedang",
    },
    "\U0001F9CD\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_standing_medium_skin_tone",
        "id": "wanita_berdiri_warna_kulit_sedang",
    },
    "\U0001F9CD\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_standing_medium-dark_skin_tone",
        "id": "wanita_berdiri_warna_kulit_gelap-sedang",
    },
    "\U0001F9CD\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_standing_dark_skin_tone",
        "id": "wanita_berdiri_warna_kulit_gelap",
    },
    "\U0001F9CE\U0001F3FB": {
        "en": "person_kneeling_light_skin_tone",
        "id": "orang_berlutut_warna_kulit_cerah",
        "alias": "orang_berlutut_warna_kulit_cerah_lutut",
    },
    "\U0001F9CE\U0001F3FC": {
        "en": "person_kneeling_medium-light_skin_tone",
        "id": "orang_berlutut_warna_kulit_cerah-sedang",
        "alias": "orang_berlutut_warna_kulit_cerah-sedang_lutut",
    },
    "\U0001F9CE\U0001F3FD": {
        "en": "person_kneeling_medium_skin_tone",
        "id": "orang_berlutut_warna_kulit_sedang",
        "alias": "orang_berlutut_warna_kulit_sedang_lutut",
    },
    "\U0001F9CE\U0001F3FE": {
        "en": "person_kneeling_medium-dark_skin_tone",
        "id": "orang_berlutut_warna_kulit_gelap-sedang",
        "alias": "orang_berlutut_warna_kulit_gelap-sedang_lutut",
    },
    "\U0001F9CE\U0001F3FF": {
        "en": "person_kneeling_dark_skin_tone",
        "id": "orang_berlutut_warna_kulit_gelap",
        "alias": "orang_berlutut_warna_kulit_gelap_lutut",
    },
    "\U0001F9CE\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_kneeling_light_skin_tone",
        "id": "pria_berlutut_warna_kulit_cerah",
    },
    "\U0001F9CE\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_kneeling_medium-light_skin_tone",
        "id": "pria_berlutut_warna_kulit_cerah-sedang",
    },
    "\U0001F9CE\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_kneeling_medium_skin_tone",
        "id": "pria_berlutut_warna_kulit_sedang",
    },
    "\U0001F9CE\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_kneeling_medium-dark_skin_tone",
        "id": "pria_berlutut_warna_kulit_gelap-sedang",
    },
    "\U0001F9CE\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_kneeling_dark_skin_tone",
        "id": "pria_berlutut_warna_kulit_gelap",
    },
    "\U0001F9CE\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_kneeling_light_skin_tone",
        "id": "wanita_berlutut_warna_kulit_cerah",
    },
    "\U0001F9CE\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_kneeling_medium-light_skin_tone",
        "id": "wanita_berlutut_warna_kulit_cerah-sedang",
    },
    "\U0001F9CE\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_kneeling_medium_skin_tone",
        "id": "wanita_berlutut_warna_kulit_sedang",
    },
    "\U0001F9CE\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_kneeling_medium-dark_skin_tone",
        "id": "wanita_berlutut_warna_kulit_gelap-sedang",
    },
    "\U0001F9CE\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_kneeling_dark_skin_tone",
        "id": "wanita_berlutut_warna_kulit_gelap",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F9AF": {
        "en": "person_with_white_cane_light_skin_tone",
        "id": "orang_dengan_tongkat_warna_kulit_cerah",
        "alias": "orang_dengan_tongkat_warna_kulit_cerah_aksesibilitas_buta",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F9AF": {
        "en": "person_with_white_cane_medium-light_skin_tone",
        "id": "orang_dengan_tongkat_warna_kulit_cerah-sedang",
        "alias": "orang_dengan_tongkat_warna_kulit_cerah-sedang_aksesibilitas_buta",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F9AF": {
        "en": "person_with_white_cane_medium_skin_tone",
        "id": "orang_dengan_tongkat_warna_kulit_sedang",
        "alias": "orang_dengan_tongkat_warna_kulit_sedang_aksesibilitas_buta",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F9AF": {
        "en": "person_with_white_cane_medium-dark_skin_tone",
        "id": "orang_dengan_tongkat_warna_kulit_gelap-sedang",
        "alias": "orang_dengan_tongkat_warna_kulit_gelap-sedang_aksesibilitas_buta",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F9AF": {
        "en": "person_with_white_cane_dark_skin_tone",
        "id": "orang_dengan_tongkat_warna_kulit_gelap",
        "alias": "orang_dengan_tongkat_warna_kulit_gelap_aksesibilitas_buta",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F9AF": {
        "en": "man_with_white_cane_light_skin_tone",
        "id": "pria_dengan_tongkat_warna_kulit_cerah",
        "alias": "pria_dengan_tongkat_warna_kulit_cerah_aksesiblitas_buta_tunanetra",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F9AF": {
        "en": "man_with_white_cane_medium-light_skin_tone",
        "id": "pria_dengan_tongkat_warna_kulit_cerah-sedang",
        "alias": "pria_dengan_tongkat_warna_kulit_cerah-sedang_aksesiblitas_buta_tunanetra",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F9AF": {
        "en": "man_with_white_cane_medium_skin_tone",
        "id": "pria_dengan_tongkat_warna_kulit_sedang",
        "alias": "pria_dengan_tongkat_warna_kulit_sedang_aksesiblitas_buta_tunanetra",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F9AF": {
        "en": "man_with_white_cane_medium-dark_skin_tone",
        "id": "pria_dengan_tongkat_warna_kulit_gelap-sedang",
        "alias": "pria_dengan_tongkat_warna_kulit_gelap-sedang_aksesiblitas_buta_tunanetra",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F9AF": {
        "en": "man_with_white_cane_dark_skin_tone",
        "id": "pria_dengan_tongkat_warna_kulit_gelap",
        "alias": "pria_dengan_tongkat_warna_kulit_gelap_aksesiblitas_buta_tunanetra",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F9AF": {
        "en": "woman_with_white_cane_light_skin_tone",
        "id": "wanita_dengan_tongkat_warna_kulit_cerah",
        "alias": "wanita_dengan_tongkat_warna_kulit_cerah_aksesiblitas_buta_tunanetra",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F9AF": {
        "en": "woman_with_white_cane_medium-light_skin_tone",
        "id": "wanita_dengan_tongkat_warna_kulit_cerah-sedang",
        "alias": "wanita_dengan_tongkat_warna_kulit_cerah-sedang_aksesiblitas_buta_tunanetra",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F9AF": {
        "en": "woman_with_white_cane_medium_skin_tone",
        "id": "wanita_dengan_tongkat_warna_kulit_sedang",
        "alias": "wanita_dengan_tongkat_warna_kulit_sedang_aksesiblitas_buta_tunanetra",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F9AF": {
        "en": "woman_with_white_cane_medium-dark_skin_tone",
        "id": "wanita_dengan_tongkat_warna_kulit_gelap-sedang",
        "alias": "wanita_dengan_tongkat_warna_kulit_gelap-sedang_aksesiblitas_buta_tunanetra",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F9AF": {
        "en": "woman_with_white_cane_dark_skin_tone",
        "id": "wanita_dengan_tongkat_warna_kulit_gelap",
        "alias": "wanita_dengan_tongkat_warna_kulit_gelap_aksesiblitas_buta_tunanetra",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F9BC": {
        "en": "person_in_motorized_wheelchair_light_skin_tone",
        "id": "orang_dengan_kursi_roda_bermotor_warna_kulit_cerah",
        "alias": "orang_dengan_kursi_roda_bermotor_warna_kulit_cerah_aksesibilitas",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F9BC": {
        "en": "person_in_motorized_wheelchair_medium-light_skin_tone",
        "id": "orang_dengan_kursi_roda_bermotor_warna_kulit_cerah-sedang",
        "alias": "orang_dengan_kursi_roda_bermotor_warna_kulit_cerah-sedang_aksesibilitas",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F9BC": {
        "en": "person_in_motorized_wheelchair_medium_skin_tone",
        "id": "orang_dengan_kursi_roda_bermotor_warna_kulit_sedang",
        "alias": "orang_dengan_kursi_roda_bermotor_warna_kulit_sedang_aksesibilitas",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F9BC": {
        "en": "person_in_motorized_wheelchair_medium-dark_skin_tone",
        "id": "orang_dengan_kursi_roda_bermotor_warna_kulit_gelap-sedang",
        "alias": "orang_dengan_kursi_roda_bermotor_warna_kulit_gelap-sedang_aksesibilitas",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F9BC": {
        "en": "person_in_motorized_wheelchair_dark_skin_tone",
        "id": "orang_dengan_kursi_roda_bermotor_warna_kulit_gelap",
        "alias": "orang_dengan_kursi_roda_bermotor_warna_kulit_gelap_aksesibilitas",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F9BC": {
        "en": "man_in_motorized_wheelchair_light_skin_tone",
        "id": "pria_dengan_kursi_roda_bermotor_warna_kulit_cerah",
        "alias": "pria_dengan_kursi_roda_bermotor_warna_kulit_cerah_aksesibilitas",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F9BC": {
        "en": "man_in_motorized_wheelchair_medium-light_skin_tone",
        "id": "pria_dengan_kursi_roda_bermotor_warna_kulit_cerah-sedang",
        "alias": "pria_dengan_kursi_roda_bermotor_warna_kulit_cerah-sedang_aksesibilitas",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F9BC": {
        "en": "man_in_motorized_wheelchair_medium_skin_tone",
        "id": "pria_dengan_kursi_roda_bermotor_warna_kulit_sedang",
        "alias": "pria_dengan_kursi_roda_bermotor_warna_kulit_sedang_aksesibilitas",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F9BC": {
        "en": "man_in_motorized_wheelchair_medium-dark_skin_tone",
        "id": "pria_dengan_kursi_roda_bermotor_warna_kulit_gelap-sedang",
        "alias": "pria_dengan_kursi_roda_bermotor_warna_kulit_gelap-sedang_aksesibilitas",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F9BC": {
        "en": "man_in_motorized_wheelchair_dark_skin_tone",
        "id": "pria_dengan_kursi_roda_bermotor_warna_kulit_gelap",
        "alias": "pria_dengan_kursi_roda_bermotor_warna_kulit_gelap_aksesibilitas",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F9BC": {
        "en": "woman_in_motorized_wheelchair_light_skin_tone",
        "id": "wanita_dengan_kursi_roda_bermotor_warna_kulit_cerah",
        "alias": "wanita_dengan_kursi_roda_bermotor_warna_kulit_cerah_aksesibilitas",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F9BC": {
        "en": "woman_in_motorized_wheelchair_medium-light_skin_tone",
        "id": "wanita_dengan_kursi_roda_bermotor_warna_kulit_cerah-sedang",
        "alias": "wanita_dengan_kursi_roda_bermotor_warna_kulit_cerah-sedang_aksesibilitas",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F9BC": {
        "en": "woman_in_motorized_wheelchair_medium_skin_tone",
        "id": "wanita_dengan_kursi_roda_bermotor_warna_kulit_sedang",
        "alias": "wanita_dengan_kursi_roda_bermotor_warna_kulit_sedang_aksesibilitas",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F9BC": {
        "en": "woman_in_motorized_wheelchair_medium-dark_skin_tone",
        "id": "wanita_dengan_kursi_roda_bermotor_warna_kulit_gelap-sedang",
        "alias": "wanita_dengan_kursi_roda_bermotor_warna_kulit_gelap-sedang_aksesibilitas",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F9BC": {
        "en": "woman_in_motorized_wheelchair_dark_skin_tone",
        "id": "wanita_dengan_kursi_roda_bermotor_warna_kulit_gelap",
        "alias": "wanita_dengan_kursi_roda_bermotor_warna_kulit_gelap_aksesibilitas",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F9BD": {
        "en": "person_in_manual_wheelchair_light_skin_tone",
        "id": "orang_dengan_kursi_roda_manual_warna_kulit_cerah",
        "alias": "orang_dengan_kursi_roda_manual_warna_kulit_cerah_aksesibilitas",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F9BD": {
        "en": "person_in_manual_wheelchair_medium-light_skin_tone",
        "id": "orang_dengan_kursi_roda_manual_warna_kulit_cerah-sedang",
        "alias": "orang_dengan_kursi_roda_manual_warna_kulit_cerah-sedang_aksesibilitas",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F9BD": {
        "en": "person_in_manual_wheelchair_medium_skin_tone",
        "id": "orang_dengan_kursi_roda_manual_warna_kulit_sedang",
        "alias": "orang_dengan_kursi_roda_manual_warna_kulit_sedang_aksesibilitas",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F9BD": {
        "en": "person_in_manual_wheelchair_medium-dark_skin_tone",
        "id": "orang_dengan_kursi_roda_manual_warna_kulit_gelap-sedang",
        "alias": "orang_dengan_kursi_roda_manual_warna_kulit_gelap-sedang_aksesibilitas",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F9BD": {
        "en": "person_in_manual_wheelchair_dark_skin_tone",
        "id": "orang_dengan_kursi_roda_manual_warna_kulit_gelap",
        "alias": "orang_dengan_kursi_roda_manual_warna_kulit_gelap_aksesibilitas",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F9BD": {
        "en": "man_in_manual_wheelchair_light_skin_tone",
        "id": "pria_dengan_kursi_roda_manual_warna_kulit_cerah",
        "alias": "pria_dengan_kursi_roda_manual_warna_kulit_cerah_aksesibilitas",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F9BD": {
        "en": "man_in_manual_wheelchair_medium-light_skin_tone",
        "id": "pria_dengan_kursi_roda_manual_warna_kulit_cerah-sedang",
        "alias": "pria_dengan_kursi_roda_manual_warna_kulit_cerah-sedang_aksesibilitas",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F9BD": {
        "en": "man_in_manual_wheelchair_medium_skin_tone",
        "id": "pria_dengan_kursi_roda_manual_warna_kulit_sedang",
        "alias": "pria_dengan_kursi_roda_manual_warna_kulit_sedang_aksesibilitas",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F9BD": {
        "en": "man_in_manual_wheelchair_medium-dark_skin_tone",
        "id": "pria_dengan_kursi_roda_manual_warna_kulit_gelap-sedang",
        "alias": "pria_dengan_kursi_roda_manual_warna_kulit_gelap-sedang_aksesibilitas",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F9BD": {
        "en": "man_in_manual_wheelchair_dark_skin_tone",
        "id": "pria_dengan_kursi_roda_manual_warna_kulit_gelap",
        "alias": "pria_dengan_kursi_roda_manual_warna_kulit_gelap_aksesibilitas",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F9BD": {
        "en": "woman_in_manual_wheelchair_light_skin_tone",
        "id": "wanita_dengan_kursi_roda_manual_warna_kulit_cerah",
        "alias": "wanita_dengan_kursi_roda_manual_warna_kulit_cerah_aksesibilitas",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F9BD": {
        "en": "woman_in_manual_wheelchair_medium-light_skin_tone",
        "id": "wanita_dengan_kursi_roda_manual_warna_kulit_cerah-sedang",
        "alias": "wanita_dengan_kursi_roda_manual_warna_kulit_cerah-sedang_aksesibilitas",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F9BD": {
        "en": "woman_in_manual_wheelchair_medium_skin_tone",
        "id": "wanita_dengan_kursi_roda_manual_warna_kulit_sedang",
        "alias": "wanita_dengan_kursi_roda_manual_warna_kulit_sedang_aksesibilitas",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F9BD": {
        "en": "woman_in_manual_wheelchair_medium-dark_skin_tone",
        "id": "wanita_dengan_kursi_roda_manual_warna_kulit_gelap-sedang",
        "alias": "wanita_dengan_kursi_roda_manual_warna_kulit_gelap-sedang_aksesibilitas",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F9BD": {
        "en": "woman_in_manual_wheelchair_dark_skin_tone",
        "id": "wanita_dengan_kursi_roda_manual_warna_kulit_gelap",
        "alias": "wanita_dengan_kursi_roda_manual_warna_kulit_gelap_aksesibilitas",
    },
    "\U0001F3C3\U0001F3FB": {
        "en": "person_running_light_skin_tone",
        "id": "orang_berlari_warna_kulit_cerah",
        "alias": "orang_berlari_warna_kulit_cerah_lari_marathon_maraton",
    },
    "\U0001F3C3\U0001F3FC": {
        "en": "person_running_medium-light_skin_tone",
        "id": "orang_berlari_warna_kulit_cerah-sedang",
        "alias": "orang_berlari_warna_kulit_cerah-sedang_lari_marathon_maraton",
    },
    "\U0001F3C3\U0001F3FD": {
        "en": "person_running_medium_skin_tone",
        "id": "orang_berlari_warna_kulit_sedang",
        "alias": "orang_berlari_warna_kulit_sedang_lari_marathon_maraton",
    },
    "\U0001F3C3\U0001F3FE": {
        "en": "person_running_medium-dark_skin_tone",
        "id": "orang_berlari_warna_kulit_gelap-sedang",
        "alias": "orang_berlari_warna_kulit_gelap-sedang_lari_marathon_maraton",
    },
    "\U0001F3C3\U0001F3FF": {
        "en": "person_running_dark_skin_tone",
        "id": "orang_berlari_warna_kulit_gelap",
        "alias": "orang_berlari_warna_kulit_gelap_lari_marathon_maraton",
    },
    "\U0001F3C3\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_running_light_skin_tone",
        "id": "pria_berlari_warna_kulit_cerah",
        "alias": "pria_berlari_warna_kulit_cerah_kaki_laki-laki_lari",
    },
    "\U0001F3C3\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_running_medium-light_skin_tone",
        "id": "pria_berlari_warna_kulit_cerah-sedang",
        "alias": "pria_berlari_warna_kulit_cerah-sedang_kaki_laki-laki_lari",
    },
    "\U0001F3C3\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_running_medium_skin_tone",
        "id": "pria_berlari_warna_kulit_sedang",
        "alias": "pria_berlari_warna_kulit_sedang_kaki_laki-laki_lari",
    },
    "\U0001F3C3\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_running_medium-dark_skin_tone",
        "id": "pria_berlari_warna_kulit_gelap-sedang",
        "alias": "pria_berlari_warna_kulit_gelap-sedang_kaki_laki-laki_lari",
    },
    "\U0001F3C3\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_running_dark_skin_tone",
        "id": "pria_berlari_warna_kulit_gelap",
        "alias": "pria_berlari_warna_kulit_gelap_kaki_laki-laki_lari",
    },
    "\U0001F3C3\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_running_light_skin_tone",
        "id": "wanita_berlari_warna_kulit_cerah",
        "alias": "wanita_berlari_warna_kulit_cerah_kaki_lari_perempuan",
    },
    "\U0001F3C3\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_running_medium-light_skin_tone",
        "id": "wanita_berlari_warna_kulit_cerah-sedang",
        "alias": "wanita_berlari_warna_kulit_cerah-sedang_kaki_lari_perempuan",
    },
    "\U0001F3C3\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_running_medium_skin_tone",
        "id": "wanita_berlari_warna_kulit_sedang",
        "alias": "wanita_berlari_warna_kulit_sedang_kaki_lari_perempuan",
    },
    "\U0001F3C3\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_running_medium-dark_skin_tone",
        "id": "wanita_berlari_warna_kulit_gelap-sedang",
        "alias": "wanita_berlari_warna_kulit_gelap-sedang_kaki_lari_perempuan",
    },
    "\U0001F3C3\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_running_dark_skin_tone",
        "id": "wanita_berlari_warna_kulit_gelap",
        "alias": "wanita_berlari_warna_kulit_gelap_kaki_lari_perempuan",
    },
    "\U0001F483\U0001F3FB": {
        "en": "woman_dancing_light_skin_tone",
        "id": "wanita_menari_warna_kulit_cerah",
        "alias": "wanita_menari_warna_kulit_cerah_dansa_perempuan_pesta_tari",
    },
    "\U0001F483\U0001F3FC": {
        "en": "woman_dancing_medium-light_skin_tone",
        "id": "wanita_menari_warna_kulit_cerah-sedang",
        "alias": "wanita_menari_warna_kulit_cerah-sedang_dansa_perempuan_pesta_tari",
    },
    "\U0001F483\U0001F3FD": {
        "en": "woman_dancing_medium_skin_tone",
        "id": "wanita_menari_warna_kulit_sedang",
        "alias": "wanita_menari_warna_kulit_sedang_dansa_perempuan_pesta_tari",
    },
    "\U0001F483\U0001F3FE": {
        "en": "woman_dancing_medium-dark_skin_tone",
        "id": "wanita_menari_warna_kulit_gelap-sedang",
        "alias": "wanita_menari_warna_kulit_gelap-sedang_dansa_perempuan_pesta_tari",
    },
    "\U0001F483\U0001F3FF": {
        "en": "woman_dancing_dark_skin_tone",
        "id": "wanita_menari_warna_kulit_gelap",
        "alias": "wanita_menari_warna_kulit_gelap_dansa_perempuan_pesta_tari",
    },
    "\U0001F57A\U0001F3FB": {
        "en": "man_dancing_light_skin_tone",
        "id": "pria_menari_warna_kulit_cerah",
        "alias": "pria_menari_warna_kulit_cerah_berdansa_dansa",
    },
    "\U0001F57A\U0001F3FC": {
        "en": "man_dancing_medium-light_skin_tone",
        "id": "pria_menari_warna_kulit_cerah-sedang",
        "alias": "pria_menari_warna_kulit_cerah-sedang_berdansa_dansa",
    },
    "\U0001F57A\U0001F3FD": {
        "en": "man_dancing_medium_skin_tone",
        "id": "pria_menari_warna_kulit_sedang",
        "alias": "pria_menari_warna_kulit_sedang_berdansa_dansa",
    },
    "\U0001F57A\U0001F3FE": {
        "en": "man_dancing_medium-dark_skin_tone",
        "id": "pria_menari_warna_kulit_gelap-sedang",
        "alias": "pria_menari_warna_kulit_gelap-sedang_berdansa_dansa",
    },
    "\U0001F57A\U0001F3FF": {
        "en": "man_dancing_dark_skin_tone",
        "id": "pria_menari_warna_kulit_gelap",
        "alias": "pria_menari_warna_kulit_gelap_berdansa_dansa",
    },
    "\U0001F574\U0001F3FB": {
        "en": "person_in_suit_levitating_light_skin_tone",
        "id": "pria_melayang_mengenakan_jas_warna_kulit_cerah",
        "alias": "pria_melayang_mengenakan_jas_warna_kulit_cerah_bisnis_laki-laki",
    },
    "\U0001F574\U0001F3FC": {
        "en": "person_in_suit_levitating_medium-light_skin_tone",
        "id": "pria_melayang_mengenakan_jas_warna_kulit_cerah-sedang",
        "alias": "pria_melayang_mengenakan_jas_warna_kulit_cerah-sedang_bisnis_laki-laki",
    },
    "\U0001F574\U0001F3FD": {
        "en": "person_in_suit_levitating_medium_skin_tone",
        "id": "pria_melayang_mengenakan_jas_warna_kulit_sedang",
        "alias": "pria_melayang_mengenakan_jas_warna_kulit_sedang_bisnis_laki-laki",
    },
    "\U0001F574\U0001F3FE": {
        "en": "person_in_suit_levitating_medium-dark_skin_tone",
        "id": "pria_melayang_mengenakan_jas_warna_kulit_gelap-sedang",
        "alias": "pria_melayang_mengenakan_jas_warna_kulit_gelap-sedang_bisnis_laki-laki",
    },
    "\U0001F574\U0001F3FF": {
        "en": "person_in_suit_levitating_dark_skin_tone",
        "id": "pria_melayang_mengenakan_jas_warna_kulit_gelap",
        "alias": "pria_melayang_mengenakan_jas_warna_kulit_gelap_bisnis_laki-laki",
    },
    "\U0001F9D6\U0001F3FB": {
        "en": "person_in_steamy_room_light_skin_tone",
        "id": "orang_di_ruangan_beruap_warna_kulit_cerah",
        "alias": "orang_di_ruangan_beruap_warna_kulit_cerah_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FC": {
        "en": "person_in_steamy_room_medium-light_skin_tone",
        "id": "orang_di_ruangan_beruap_warna_kulit_cerah-sedang",
        "alias": "orang_di_ruangan_beruap_warna_kulit_cerah-sedang_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FD": {
        "en": "person_in_steamy_room_medium_skin_tone",
        "id": "orang_di_ruangan_beruap_warna_kulit_sedang",
        "alias": "orang_di_ruangan_beruap_warna_kulit_sedang_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FE": {
        "en": "person_in_steamy_room_medium-dark_skin_tone",
        "id": "orang_di_ruangan_beruap_warna_kulit_gelap-sedang",
        "alias": "orang_di_ruangan_beruap_warna_kulit_gelap-sedang_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FF": {
        "en": "person_in_steamy_room_dark_skin_tone",
        "id": "orang_di_ruangan_beruap_warna_kulit_gelap",
        "alias": "orang_di_ruangan_beruap_warna_kulit_gelap_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_steamy_room_light_skin_tone",
        "id": "pria_di_ruangan_beruap_warna_kulit_cerah",
        "alias": "pria_di_ruangan_beruap_warna_kulit_cerah_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_steamy_room_medium-light_skin_tone",
        "id": "pria_di_ruangan_beruap_warna_kulit_cerah-sedang",
        "alias": "pria_di_ruangan_beruap_warna_kulit_cerah-sedang_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_steamy_room_medium_skin_tone",
        "id": "pria_di_ruangan_beruap_warna_kulit_sedang",
        "alias": "pria_di_ruangan_beruap_warna_kulit_sedang_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_steamy_room_medium-dark_skin_tone",
        "id": "pria_di_ruangan_beruap_warna_kulit_gelap-sedang",
        "alias": "pria_di_ruangan_beruap_warna_kulit_gelap-sedang_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_steamy_room_dark_skin_tone",
        "id": "pria_di_ruangan_beruap_warna_kulit_gelap",
        "alias": "pria_di_ruangan_beruap_warna_kulit_gelap_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_steamy_room_light_skin_tone",
        "id": "wanita_di_ruangan_beruap_warna_kulit_cerah",
        "alias": "wanita_di_ruangan_beruap_warna_kulit_cerah_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_steamy_room_medium-light_skin_tone",
        "id": "wanita_di_ruangan_beruap_warna_kulit_cerah-sedang",
        "alias": "wanita_di_ruangan_beruap_warna_kulit_cerah-sedang_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_steamy_room_medium_skin_tone",
        "id": "wanita_di_ruangan_beruap_warna_kulit_sedang",
        "alias": "wanita_di_ruangan_beruap_warna_kulit_sedang_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_steamy_room_medium-dark_skin_tone",
        "id": "wanita_di_ruangan_beruap_warna_kulit_gelap-sedang",
        "alias": "wanita_di_ruangan_beruap_warna_kulit_gelap-sedang_ruang_uap_sauna",
    },
    "\U0001F9D6\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_steamy_room_dark_skin_tone",
        "id": "wanita_di_ruangan_beruap_warna_kulit_gelap",
        "alias": "wanita_di_ruangan_beruap_warna_kulit_gelap_ruang_uap_sauna",
    },
    "\U0001F9D7\U0001F3FB": {
        "en": "person_climbing_light_skin_tone",
        "id": "orang_memanjat_warna_kulit_cerah",
        "alias": "orang_memanjat_warna_kulit_cerah_pemanjat",
    },
    "\U0001F9D7\U0001F3FC": {
        "en": "person_climbing_medium-light_skin_tone",
        "id": "orang_memanjat_warna_kulit_cerah-sedang",
        "alias": "orang_memanjat_warna_kulit_cerah-sedang_pemanjat",
    },
    "\U0001F9D7\U0001F3FD": {
        "en": "person_climbing_medium_skin_tone",
        "id": "orang_memanjat_warna_kulit_sedang",
        "alias": "orang_memanjat_warna_kulit_sedang_pemanjat",
    },
    "\U0001F9D7\U0001F3FE": {
        "en": "person_climbing_medium-dark_skin_tone",
        "id": "orang_memanjat_warna_kulit_gelap-sedang",
        "alias": "orang_memanjat_warna_kulit_gelap-sedang_pemanjat",
    },
    "\U0001F9D7\U0001F3FF": {
        "en": "person_climbing_dark_skin_tone",
        "id": "orang_memanjat_warna_kulit_gelap",
        "alias": "orang_memanjat_warna_kulit_gelap_pemanjat",
    },
    "\U0001F9D7\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_climbing_light_skin_tone",
        "id": "pria_memanjat_warna_kulit_cerah",
        "alias": "pria_memanjat_warna_kulit_cerah_pemanjat",
    },
    "\U0001F9D7\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_climbing_medium-light_skin_tone",
        "id": "pria_memanjat_warna_kulit_cerah-sedang",
        "alias": "pria_memanjat_warna_kulit_cerah-sedang_pemanjat",
    },
    "\U0001F9D7\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_climbing_medium_skin_tone",
        "id": "pria_memanjat_warna_kulit_sedang",
        "alias": "pria_memanjat_warna_kulit_sedang_pemanjat",
    },
    "\U0001F9D7\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_climbing_medium-dark_skin_tone",
        "id": "pria_memanjat_warna_kulit_gelap-sedang",
        "alias": "pria_memanjat_warna_kulit_gelap-sedang_pemanjat",
    },
    "\U0001F9D7\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_climbing_dark_skin_tone",
        "id": "pria_memanjat_warna_kulit_gelap",
        "alias": "pria_memanjat_warna_kulit_gelap_pemanjat",
    },
    "\U0001F9D7\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_climbing_light_skin_tone",
        "id": "wanita_memanjat_warna_kulit_cerah",
        "alias": "wanita_memanjat_warna_kulit_cerah_pemanjat",
    },
    "\U0001F9D7\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_climbing_medium-light_skin_tone",
        "id": "wanita_memanjat_warna_kulit_cerah-sedang",
        "alias": "wanita_memanjat_warna_kulit_cerah-sedang_pemanjat",
    },
    "\U0001F9D7\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_climbing_medium_skin_tone",
        "id": "wanita_memanjat_warna_kulit_sedang",
        "alias": "wanita_memanjat_warna_kulit_sedang_pemanjat",
    },
    "\U0001F9D7\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_climbing_medium-dark_skin_tone",
        "id": "wanita_memanjat_warna_kulit_gelap-sedang",
        "alias": "wanita_memanjat_warna_kulit_gelap-sedang_pemanjat",
    },
    "\U0001F9D7\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_climbing_dark_skin_tone",
        "id": "wanita_memanjat_warna_kulit_gelap",
        "alias": "wanita_memanjat_warna_kulit_gelap_pemanjat",
    },
    "\U0001F3C7\U0001F3FB": {
        "en": "horse_racing_light_skin_tone",
        "id": "balap_kuda_warna_kulit_cerah",
        "alias": "balap_kuda_warna_kulit_cerah_balapan_joki_pacuan",
    },
    "\U0001F3C7\U0001F3FC": {
        "en": "horse_racing_medium-light_skin_tone",
        "id": "balap_kuda_warna_kulit_cerah-sedang",
        "alias": "balap_kuda_warna_kulit_cerah-sedang_balapan_joki_pacuan",
    },
    "\U0001F3C7\U0001F3FD": {
        "en": "horse_racing_medium_skin_tone",
        "id": "balap_kuda_warna_kulit_sedang",
        "alias": "balap_kuda_warna_kulit_sedang_balapan_joki_pacuan",
    },
    "\U0001F3C7\U0001F3FE": {
        "en": "horse_racing_medium-dark_skin_tone",
        "id": "balap_kuda_warna_kulit_gelap-sedang",
        "alias": "balap_kuda_warna_kulit_gelap-sedang_balapan_joki_pacuan",
    },
    "\U0001F3C7\U0001F3FF": {
        "en": "horse_racing_dark_skin_tone",
        "id": "balap_kuda_warna_kulit_gelap",
        "alias": "balap_kuda_warna_kulit_gelap_balapan_joki_pacuan",
    },
    "\U0001F3C2\U0001F3FB": {
        "en": "snowboarder_light_skin_tone",
        "id": "peselancar_salju_warna_kulit_cerah",
        "alias": "peselancar_salju_warna_kulit_cerah_papan_seluncur_ski",
    },
    "\U0001F3C2\U0001F3FC": {
        "en": "snowboarder_medium-light_skin_tone",
        "id": "peselancar_salju_warna_kulit_cerah-sedang",
        "alias": "peselancar_salju_warna_kulit_cerah-sedang_papan_seluncur_ski",
    },
    "\U0001F3C2\U0001F3FD": {
        "en": "snowboarder_medium_skin_tone",
        "id": "peselancar_salju_warna_kulit_sedang",
        "alias": "peselancar_salju_warna_kulit_sedang_papan_seluncur_ski",
    },
    "\U0001F3C2\U0001F3FE": {
        "en": "snowboarder_medium-dark_skin_tone",
        "id": "peselancar_salju_warna_kulit_gelap-sedang",
        "alias": "peselancar_salju_warna_kulit_gelap-sedang_papan_seluncur_ski",
    },
    "\U0001F3C2\U0001F3FF": {
        "en": "snowboarder_dark_skin_tone",
        "id": "peselancar_salju_warna_kulit_gelap",
        "alias": "peselancar_salju_warna_kulit_gelap_papan_seluncur_ski",
    },
    "\U0001F3CC\U0001F3FB": {
        "en": "person_golfing_light_skin_tone",
        "id": "orang_bermain_golf_warna_kulit_cerah",
        "alias": "orang_bermain_golf_warna_kulit_cerah_bola",
    },
    "\U0001F3CC\U0001F3FC": {
        "en": "person_golfing_medium-light_skin_tone",
        "id": "orang_bermain_golf_warna_kulit_cerah-sedang",
        "alias": "orang_bermain_golf_warna_kulit_cerah-sedang_bola",
    },
    "\U0001F3CC\U0001F3FD": {
        "en": "person_golfing_medium_skin_tone",
        "id": "orang_bermain_golf_warna_kulit_sedang",
        "alias": "orang_bermain_golf_warna_kulit_sedang_bola",
    },
    "\U0001F3CC\U0001F3FE": {
        "en": "person_golfing_medium-dark_skin_tone",
        "id": "orang_bermain_golf_warna_kulit_gelap-sedang",
        "alias": "orang_bermain_golf_warna_kulit_gelap-sedang_bola",
    },
    "\U0001F3CC\U0001F3FF": {
        "en": "person_golfing_dark_skin_tone",
        "id": "orang_bermain_golf_warna_kulit_gelap",
        "alias": "orang_bermain_golf_warna_kulit_gelap_bola",
    },
    "\U0001F3CC\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_golfing_light_skin_tone",
        "id": "pria_bermain_golf_warna_kulit_cerah",
        "alias": "pria_bermain_golf_warna_kulit_cerah_bola_laki-laki",
    },
    "\U0001F3CC\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_golfing_medium-light_skin_tone",
        "id": "pria_bermain_golf_warna_kulit_cerah-sedang",
        "alias": "pria_bermain_golf_warna_kulit_cerah-sedang_bola_laki-laki",
    },
    "\U0001F3CC\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_golfing_medium_skin_tone",
        "id": "pria_bermain_golf_warna_kulit_sedang",
        "alias": "pria_bermain_golf_warna_kulit_sedang_bola_laki-laki",
    },
    "\U0001F3CC\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_golfing_medium-dark_skin_tone",
        "id": "pria_bermain_golf_warna_kulit_gelap-sedang",
        "alias": "pria_bermain_golf_warna_kulit_gelap-sedang_bola_laki-laki",
    },
    "\U0001F3CC\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_golfing_dark_skin_tone",
        "id": "pria_bermain_golf_warna_kulit_gelap",
        "alias": "pria_bermain_golf_warna_kulit_gelap_bola_laki-laki",
    },
    "\U0001F3CC\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_golfing_light_skin_tone",
        "id": "wanita_bermain_golf_warna_kulit_cerah",
        "alias": "wanita_bermain_golf_warna_kulit_cerah_bola_perempuan",
    },
    "\U0001F3CC\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_golfing_medium-light_skin_tone",
        "id": "wanita_bermain_golf_warna_kulit_cerah-sedang",
        "alias": "wanita_bermain_golf_warna_kulit_cerah-sedang_bola_perempuan",
    },
    "\U0001F3CC\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_golfing_medium_skin_tone",
        "id": "wanita_bermain_golf_warna_kulit_sedang",
        "alias": "wanita_bermain_golf_warna_kulit_sedang_bola_perempuan",
    },
    "\U0001F3CC\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_golfing_medium-dark_skin_tone",
        "id": "wanita_bermain_golf_warna_kulit_gelap-sedang",
        "alias": "wanita_bermain_golf_warna_kulit_gelap-sedang_bola_perempuan",
    },
    "\U0001F3CC\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_golfing_dark_skin_tone",
        "id": "wanita_bermain_golf_warna_kulit_gelap",
        "alias": "wanita_bermain_golf_warna_kulit_gelap_bola_perempuan",
    },
    "\U0001F3C4\U0001F3FB": {
        "en": "person_surfing_light_skin_tone",
        "id": "orang_berselancar_warna_kulit_cerah",
        "alias": "orang_berselancar_warna_kulit_cerah_seluncur",
    },
    "\U0001F3C4\U0001F3FC": {
        "en": "person_surfing_medium-light_skin_tone",
        "id": "orang_berselancar_warna_kulit_cerah-sedang",
        "alias": "orang_berselancar_warna_kulit_cerah-sedang_seluncur",
    },
    "\U0001F3C4\U0001F3FD": {
        "en": "person_surfing_medium_skin_tone",
        "id": "orang_berselancar_warna_kulit_sedang",
        "alias": "orang_berselancar_warna_kulit_sedang_seluncur",
    },
    "\U0001F3C4\U0001F3FE": {
        "en": "person_surfing_medium-dark_skin_tone",
        "id": "orang_berselancar_warna_kulit_gelap-sedang",
        "alias": "orang_berselancar_warna_kulit_gelap-sedang_seluncur",
    },
    "\U0001F3C4\U0001F3FF": {
        "en": "person_surfing_dark_skin_tone",
        "id": "orang_berselancar_warna_kulit_gelap",
        "alias": "orang_berselancar_warna_kulit_gelap_seluncur",
    },
    "\U0001F3C4\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_surfing_light_skin_tone",
        "id": "pria_berselancar_warna_kulit_cerah",
        "alias": "pria_berselancar_warna_kulit_cerah_laki-laki_ombak_selancar",
    },
    "\U0001F3C4\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_surfing_medium-light_skin_tone",
        "id": "pria_berselancar_warna_kulit_cerah-sedang",
        "alias": "pria_berselancar_warna_kulit_cerah-sedang_laki-laki_ombak_selancar",
    },
    "\U0001F3C4\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_surfing_medium_skin_tone",
        "id": "pria_berselancar_warna_kulit_sedang",
        "alias": "pria_berselancar_warna_kulit_sedang_laki-laki_ombak_selancar",
    },
    "\U0001F3C4\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_surfing_medium-dark_skin_tone",
        "id": "pria_berselancar_warna_kulit_gelap-sedang",
        "alias": "pria_berselancar_warna_kulit_gelap-sedang_laki-laki_ombak_selancar",
    },
    "\U0001F3C4\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_surfing_dark_skin_tone",
        "id": "pria_berselancar_warna_kulit_gelap",
        "alias": "pria_berselancar_warna_kulit_gelap_laki-laki_ombak_selancar",
    },
    "\U0001F3C4\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_surfing_light_skin_tone",
        "id": "wanita_berselancar_warna_kulit_cerah",
        "alias": "wanita_berselancar_warna_kulit_cerah_ombak_perempuan_selancar",
    },
    "\U0001F3C4\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_surfing_medium-light_skin_tone",
        "id": "wanita_berselancar_warna_kulit_cerah-sedang",
        "alias": "wanita_berselancar_warna_kulit_cerah-sedang_ombak_perempuan_selancar",
    },
    "\U0001F3C4\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_surfing_medium_skin_tone",
        "id": "wanita_berselancar_warna_kulit_sedang",
        "alias": "wanita_berselancar_warna_kulit_sedang_ombak_perempuan_selancar",
    },
    "\U0001F3C4\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_surfing_medium-dark_skin_tone",
        "id": "wanita_berselancar_warna_kulit_gelap-sedang",
        "alias": "wanita_berselancar_warna_kulit_gelap-sedang_ombak_perempuan_selancar",
    },
    "\U0001F3C4\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_surfing_dark_skin_tone",
        "id": "wanita_berselancar_warna_kulit_gelap",
        "alias": "wanita_berselancar_warna_kulit_gelap_ombak_perempuan_selancar",
    },
    "\U0001F6A3\U0001F3FB": {
        "en": "person_rowing_boat_light_skin_tone",
        "id": "orang_mendayung_perahu_warna_kulit_cerah",
        "alias": "orang_mendayung_perahu_warna_kulit_cerah_kendaraan",
    },
    "\U0001F6A3\U0001F3FC": {
        "en": "person_rowing_boat_medium-light_skin_tone",
        "id": "orang_mendayung_perahu_warna_kulit_cerah-sedang",
        "alias": "orang_mendayung_perahu_warna_kulit_cerah-sedang_kendaraan",
    },
    "\U0001F6A3\U0001F3FD": {
        "en": "person_rowing_boat_medium_skin_tone",
        "id": "orang_mendayung_perahu_warna_kulit_sedang",
        "alias": "orang_mendayung_perahu_warna_kulit_sedang_kendaraan",
    },
    "\U0001F6A3\U0001F3FE": {
        "en": "person_rowing_boat_medium-dark_skin_tone",
        "id": "orang_mendayung_perahu_warna_kulit_gelap-sedang",
        "alias": "orang_mendayung_perahu_warna_kulit_gelap-sedang_kendaraan",
    },
    "\U0001F6A3\U0001F3FF": {
        "en": "person_rowing_boat_dark_skin_tone",
        "id": "orang_mendayung_perahu_warna_kulit_gelap",
        "alias": "orang_mendayung_perahu_warna_kulit_gelap_kendaraan",
    },
    "\U0001F6A3\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_rowing_boat_light_skin_tone",
        "id": "pria_mendayung_perahu_warna_kulit_cerah",
        "alias": "pria_mendayung_perahu_warna_kulit_cerah_dayung_laki-laki",
    },
    "\U0001F6A3\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_rowing_boat_medium-light_skin_tone",
        "id": "pria_mendayung_perahu_warna_kulit_cerah-sedang",
        "alias": "pria_mendayung_perahu_warna_kulit_cerah-sedang_dayung_laki-laki",
    },
    "\U0001F6A3\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_rowing_boat_medium_skin_tone",
        "id": "pria_mendayung_perahu_warna_kulit_sedang",
        "alias": "pria_mendayung_perahu_warna_kulit_sedang_dayung_laki-laki",
    },
    "\U0001F6A3\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_rowing_boat_medium-dark_skin_tone",
        "id": "pria_mendayung_perahu_warna_kulit_gelap-sedang",
        "alias": "pria_mendayung_perahu_warna_kulit_gelap-sedang_dayung_laki-laki",
    },
    "\U0001F6A3\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_rowing_boat_dark_skin_tone",
        "id": "pria_mendayung_perahu_warna_kulit_gelap",
        "alias": "pria_mendayung_perahu_warna_kulit_gelap_dayung_laki-laki",
    },
    "\U0001F6A3\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_rowing_boat_light_skin_tone",
        "id": "wanita_mendayung_perahu_warna_kulit_cerah",
        "alias": "wanita_mendayung_perahu_warna_kulit_cerah_dayung_perempuan",
    },
    "\U0001F6A3\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_rowing_boat_medium-light_skin_tone",
        "id": "wanita_mendayung_perahu_warna_kulit_cerah-sedang",
        "alias": "wanita_mendayung_perahu_warna_kulit_cerah-sedang_dayung_perempuan",
    },
    "\U0001F6A3\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_rowing_boat_medium_skin_tone",
        "id": "wanita_mendayung_perahu_warna_kulit_sedang",
        "alias": "wanita_mendayung_perahu_warna_kulit_sedang_dayung_perempuan",
    },
    "\U0001F6A3\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_rowing_boat_medium-dark_skin_tone",
        "id": "wanita_mendayung_perahu_warna_kulit_gelap-sedang",
        "alias": "wanita_mendayung_perahu_warna_kulit_gelap-sedang_dayung_perempuan",
    },
    "\U0001F6A3\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_rowing_boat_dark_skin_tone",
        "id": "wanita_mendayung_perahu_warna_kulit_gelap",
        "alias": "wanita_mendayung_perahu_warna_kulit_gelap_dayung_perempuan",
    },
    "\U0001F3CA\U0001F3FB": {
        "en": "person_swimming_light_skin_tone",
        "id": "orang_berenang_warna_kulit_cerah",
        "alias": "orang_berenang_warna_kulit_cerah_renang",
    },
    "\U0001F3CA\U0001F3FC": {
        "en": "person_swimming_medium-light_skin_tone",
        "id": "orang_berenang_warna_kulit_cerah-sedang",
        "alias": "orang_berenang_warna_kulit_cerah-sedang_renang",
    },
    "\U0001F3CA\U0001F3FD": {
        "en": "person_swimming_medium_skin_tone",
        "id": "orang_berenang_warna_kulit_sedang",
        "alias": "orang_berenang_warna_kulit_sedang_renang",
    },
    "\U0001F3CA\U0001F3FE": {
        "en": "person_swimming_medium-dark_skin_tone",
        "id": "orang_berenang_warna_kulit_gelap-sedang",
        "alias": "orang_berenang_warna_kulit_gelap-sedang_renang",
    },
    "\U0001F3CA\U0001F3FF": {
        "en": "person_swimming_dark_skin_tone",
        "id": "orang_berenang_warna_kulit_gelap",
        "alias": "orang_berenang_warna_kulit_gelap_renang",
    },
    "\U0001F3CA\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_swimming_light_skin_tone",
        "id": "pria_berenang_warna_kulit_cerah",
        "alias": "pria_berenang_warna_kulit_cerah_laki-laki_renang",
    },
    "\U0001F3CA\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_swimming_medium-light_skin_tone",
        "id": "pria_berenang_warna_kulit_cerah-sedang",
        "alias": "pria_berenang_warna_kulit_cerah-sedang_laki-laki_renang",
    },
    "\U0001F3CA\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_swimming_medium_skin_tone",
        "id": "pria_berenang_warna_kulit_sedang",
        "alias": "pria_berenang_warna_kulit_sedang_laki-laki_renang",
    },
    "\U0001F3CA\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_swimming_medium-dark_skin_tone",
        "id": "pria_berenang_warna_kulit_gelap-sedang",
        "alias": "pria_berenang_warna_kulit_gelap-sedang_laki-laki_renang",
    },
    "\U0001F3CA\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_swimming_dark_skin_tone",
        "id": "pria_berenang_warna_kulit_gelap",
        "alias": "pria_berenang_warna_kulit_gelap_laki-laki_renang",
    },
    "\U0001F3CA\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_swimming_light_skin_tone",
        "id": "wanita_berenang_warna_kulit_cerah",
        "alias": "wanita_berenang_warna_kulit_cerah_perempuan_renang",
    },
    "\U0001F3CA\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_swimming_medium-light_skin_tone",
        "id": "wanita_berenang_warna_kulit_cerah-sedang",
        "alias": "wanita_berenang_warna_kulit_cerah-sedang_perempuan_renang",
    },
    "\U0001F3CA\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_swimming_medium_skin_tone",
        "id": "wanita_berenang_warna_kulit_sedang",
        "alias": "wanita_berenang_warna_kulit_sedang_perempuan_renang",
    },
    "\U0001F3CA\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_swimming_medium-dark_skin_tone",
        "id": "wanita_berenang_warna_kulit_gelap-sedang",
        "alias": "wanita_berenang_warna_kulit_gelap-sedang_perempuan_renang",
    },
    "\U0001F3CA\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_swimming_dark_skin_tone",
        "id": "wanita_berenang_warna_kulit_gelap",
        "alias": "wanita_berenang_warna_kulit_gelap_perempuan_renang",
    },
    "\U000026F9\U0001F3FB": {
        "en": "person_bouncing_ball_light_skin_tone",
        "id": "orang_memantulkan_bola_warna_kulit_cerah",
    },
    "\U000026F9\U0001F3FC": {
        "en": "person_bouncing_ball_medium-light_skin_tone",
        "id": "orang_memantulkan_bola_warna_kulit_cerah-sedang",
    },
    "\U000026F9\U0001F3FD": {
        "en": "person_bouncing_ball_medium_skin_tone",
        "id": "orang_memantulkan_bola_warna_kulit_sedang",
    },
    "\U000026F9\U0001F3FE": {
        "en": "person_bouncing_ball_medium-dark_skin_tone",
        "id": "orang_memantulkan_bola_warna_kulit_gelap-sedang",
    },
    "\U000026F9\U0001F3FF": {
        "en": "person_bouncing_ball_dark_skin_tone",
        "id": "orang_memantulkan_bola_warna_kulit_gelap",
    },
    "\U000026F9\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bouncing_ball_light_skin_tone",
        "id": "pria_memantulkan_bola_warna_kulit_cerah",
        "alias": "pria_memantulkan_bola_warna_kulit_cerah_laki-laki_membawa",
    },
    "\U000026F9\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bouncing_ball_medium-light_skin_tone",
        "id": "pria_memantulkan_bola_warna_kulit_cerah-sedang",
        "alias": "pria_memantulkan_bola_warna_kulit_cerah-sedang_laki-laki_membawa",
    },
    "\U000026F9\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bouncing_ball_medium_skin_tone",
        "id": "pria_memantulkan_bola_warna_kulit_sedang",
        "alias": "pria_memantulkan_bola_warna_kulit_sedang_laki-laki_membawa",
    },
    "\U000026F9\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bouncing_ball_medium-dark_skin_tone",
        "id": "pria_memantulkan_bola_warna_kulit_gelap-sedang",
        "alias": "pria_memantulkan_bola_warna_kulit_gelap-sedang_laki-laki_membawa",
    },
    "\U000026F9\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_bouncing_ball_dark_skin_tone",
        "id": "pria_memantulkan_bola_warna_kulit_gelap",
        "alias": "pria_memantulkan_bola_warna_kulit_gelap_laki-laki_membawa",
    },
    "\U000026F9\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bouncing_ball_light_skin_tone",
        "id": "wanita_memantulkan_bola_warna_kulit_cerah",
        "alias": "wanita_memantulkan_bola_warna_kulit_cerah_membawa_perempuan",
    },
    "\U000026F9\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bouncing_ball_medium-light_skin_tone",
        "id": "wanita_memantulkan_bola_warna_kulit_cerah-sedang",
        "alias": "wanita_memantulkan_bola_warna_kulit_cerah-sedang_membawa_perempuan",
    },
    "\U000026F9\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bouncing_ball_medium_skin_tone",
        "id": "wanita_memantulkan_bola_warna_kulit_sedang",
        "alias": "wanita_memantulkan_bola_warna_kulit_sedang_membawa_perempuan",
    },
    "\U000026F9\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bouncing_ball_medium-dark_skin_tone",
        "id": "wanita_memantulkan_bola_warna_kulit_gelap-sedang",
        "alias": "wanita_memantulkan_bola_warna_kulit_gelap-sedang_membawa_perempuan",
    },
    "\U000026F9\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_bouncing_ball_dark_skin_tone",
        "id": "wanita_memantulkan_bola_warna_kulit_gelap",
        "alias": "wanita_memantulkan_bola_warna_kulit_gelap_membawa_perempuan",
    },
    "\U0001F3CB\U0001F3FB": {
        "en": "person_lifting_weights_light_skin_tone",
        "id": "orang_mengangkat_beban_warna_kulit_cerah",
        "alias": "orang_mengangkat_beban_warna_kulit_cerah_angkat",
    },
    "\U0001F3CB\U0001F3FC": {
        "en": "person_lifting_weights_medium-light_skin_tone",
        "id": "orang_mengangkat_beban_warna_kulit_cerah-sedang",
        "alias": "orang_mengangkat_beban_warna_kulit_cerah-sedang_angkat",
    },
    "\U0001F3CB\U0001F3FD": {
        "en": "person_lifting_weights_medium_skin_tone",
        "id": "orang_mengangkat_beban_warna_kulit_sedang",
        "alias": "orang_mengangkat_beban_warna_kulit_sedang_angkat",
    },
    "\U0001F3CB\U0001F3FE": {
        "en": "person_lifting_weights_medium-dark_skin_tone",
        "id": "orang_mengangkat_beban_warna_kulit_gelap-sedang",
        "alias": "orang_mengangkat_beban_warna_kulit_gelap-sedang_angkat",
    },
    "\U0001F3CB\U0001F3FF": {
        "en": "person_lifting_weights_dark_skin_tone",
        "id": "orang_mengangkat_beban_warna_kulit_gelap",
        "alias": "orang_mengangkat_beban_warna_kulit_gelap_angkat",
    },
    "\U0001F3CB\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_lifting_weights_light_skin_tone",
        "id": "pria_mengangkat_beban_warna_kulit_cerah",
        "alias": "pria_mengangkat_beban_warna_kulit_cerah_angkat_laki-laki",
    },
    "\U0001F3CB\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_lifting_weights_medium-light_skin_tone",
        "id": "pria_mengangkat_beban_warna_kulit_cerah-sedang",
        "alias": "pria_mengangkat_beban_warna_kulit_cerah-sedang_angkat_laki-laki",
    },
    "\U0001F3CB\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_lifting_weights_medium_skin_tone",
        "id": "pria_mengangkat_beban_warna_kulit_sedang",
        "alias": "pria_mengangkat_beban_warna_kulit_sedang_angkat_laki-laki",
    },
    "\U0001F3CB\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_lifting_weights_medium-dark_skin_tone",
        "id": "pria_mengangkat_beban_warna_kulit_gelap-sedang",
        "alias": "pria_mengangkat_beban_warna_kulit_gelap-sedang_angkat_laki-laki",
    },
    "\U0001F3CB\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_lifting_weights_dark_skin_tone",
        "id": "pria_mengangkat_beban_warna_kulit_gelap",
        "alias": "pria_mengangkat_beban_warna_kulit_gelap_angkat_laki-laki",
    },
    "\U0001F3CB\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_lifting_weights_light_skin_tone",
        "id": "wanita_mengangkat_beban_warna_kulit_cerah",
        "alias": "wanita_mengangkat_beban_warna_kulit_cerah_angkat_perempuan",
    },
    "\U0001F3CB\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_lifting_weights_medium-light_skin_tone",
        "id": "wanita_mengangkat_beban_warna_kulit_cerah-sedang",
        "alias": "wanita_mengangkat_beban_warna_kulit_cerah-sedang_angkat_perempuan",
    },
    "\U0001F3CB\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_lifting_weights_medium_skin_tone",
        "id": "wanita_mengangkat_beban_warna_kulit_sedang",
        "alias": "wanita_mengangkat_beban_warna_kulit_sedang_angkat_perempuan",
    },
    "\U0001F3CB\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_lifting_weights_medium-dark_skin_tone",
        "id": "wanita_mengangkat_beban_warna_kulit_gelap-sedang",
        "alias": "wanita_mengangkat_beban_warna_kulit_gelap-sedang_angkat_perempuan",
    },
    "\U0001F3CB\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_lifting_weights_dark_skin_tone",
        "id": "wanita_mengangkat_beban_warna_kulit_gelap",
        "alias": "wanita_mengangkat_beban_warna_kulit_gelap_angkat_perempuan",
    },
    "\U0001F6B4\U0001F3FB": {
        "en": "person_biking_light_skin_tone",
        "id": "orang_bersepeda_warna_kulit_cerah",
        "alias": "orang_bersepeda_warna_kulit_cerah_sepeda",
    },
    "\U0001F6B4\U0001F3FC": {
        "en": "person_biking_medium-light_skin_tone",
        "id": "orang_bersepeda_warna_kulit_cerah-sedang",
        "alias": "orang_bersepeda_warna_kulit_cerah-sedang_sepeda",
    },
    "\U0001F6B4\U0001F3FD": {
        "en": "person_biking_medium_skin_tone",
        "id": "orang_bersepeda_warna_kulit_sedang",
        "alias": "orang_bersepeda_warna_kulit_sedang_sepeda",
    },
    "\U0001F6B4\U0001F3FE": {
        "en": "person_biking_medium-dark_skin_tone",
        "id": "orang_bersepeda_warna_kulit_gelap-sedang",
        "alias": "orang_bersepeda_warna_kulit_gelap-sedang_sepeda",
    },
    "\U0001F6B4\U0001F3FF": {
        "en": "person_biking_dark_skin_tone",
        "id": "orang_bersepeda_warna_kulit_gelap",
        "alias": "orang_bersepeda_warna_kulit_gelap_sepeda",
    },
    "\U0001F6B4\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_biking_light_skin_tone",
        "id": "pria_bersepeda_warna_kulit_cerah",
        "alias": "pria_bersepeda_warna_kulit_cerah_laki-laki_sepeda",
    },
    "\U0001F6B4\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_biking_medium-light_skin_tone",
        "id": "pria_bersepeda_warna_kulit_cerah-sedang",
        "alias": "pria_bersepeda_warna_kulit_cerah-sedang_laki-laki_sepeda",
    },
    "\U0001F6B4\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_biking_medium_skin_tone",
        "id": "pria_bersepeda_warna_kulit_sedang",
        "alias": "pria_bersepeda_warna_kulit_sedang_laki-laki_sepeda",
    },
    "\U0001F6B4\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_biking_medium-dark_skin_tone",
        "id": "pria_bersepeda_warna_kulit_gelap-sedang",
        "alias": "pria_bersepeda_warna_kulit_gelap-sedang_laki-laki_sepeda",
    },
    "\U0001F6B4\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_biking_dark_skin_tone",
        "id": "pria_bersepeda_warna_kulit_gelap",
        "alias": "pria_bersepeda_warna_kulit_gelap_laki-laki_sepeda",
    },
    "\U0001F6B4\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_biking_light_skin_tone",
        "id": "wanita_bersepeda_warna_kulit_cerah",
        "alias": "wanita_bersepeda_warna_kulit_cerah_perempuan_sepeda",
    },
    "\U0001F6B4\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_biking_medium-light_skin_tone",
        "id": "wanita_bersepeda_warna_kulit_cerah-sedang",
        "alias": "wanita_bersepeda_warna_kulit_cerah-sedang_perempuan_sepeda",
    },
    "\U0001F6B4\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_biking_medium_skin_tone",
        "id": "wanita_bersepeda_warna_kulit_sedang",
        "alias": "wanita_bersepeda_warna_kulit_sedang_perempuan_sepeda",
    },
    "\U0001F6B4\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_biking_medium-dark_skin_tone",
        "id": "wanita_bersepeda_warna_kulit_gelap-sedang",
        "alias": "wanita_bersepeda_warna_kulit_gelap-sedang_perempuan_sepeda",
    },
    "\U0001F6B4\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_biking_dark_skin_tone",
        "id": "wanita_bersepeda_warna_kulit_gelap",
        "alias": "wanita_bersepeda_warna_kulit_gelap_perempuan_sepeda",
    },
    "\U0001F6B5\U0001F3FB": {
        "en": "person_mountain_biking_light_skin_tone",
        "id": "orang_bersepeda_gunung_warna_kulit_cerah",
        "alias": "orang_bersepeda_gunung_warna_kulit_cerah_pesepeda_sepeda",
    },
    "\U0001F6B5\U0001F3FC": {
        "en": "person_mountain_biking_medium-light_skin_tone",
        "id": "orang_bersepeda_gunung_warna_kulit_cerah-sedang",
        "alias": "orang_bersepeda_gunung_warna_kulit_cerah-sedang_pesepeda_sepeda",
    },
    "\U0001F6B5\U0001F3FD": {
        "en": "person_mountain_biking_medium_skin_tone",
        "id": "orang_bersepeda_gunung_warna_kulit_sedang",
        "alias": "orang_bersepeda_gunung_warna_kulit_sedang_pesepeda_sepeda",
    },
    "\U0001F6B5\U0001F3FE": {
        "en": "person_mountain_biking_medium-dark_skin_tone",
        "id": "orang_bersepeda_gunung_warna_kulit_gelap-sedang",
        "alias": "orang_bersepeda_gunung_warna_kulit_gelap-sedang_pesepeda_sepeda",
    },
    "\U0001F6B5\U0001F3FF": {
        "en": "person_mountain_biking_dark_skin_tone",
        "id": "orang_bersepeda_gunung_warna_kulit_gelap",
        "alias": "orang_bersepeda_gunung_warna_kulit_gelap_pesepeda_sepeda",
    },
    "\U0001F6B5\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mountain_biking_light_skin_tone",
        "id": "pria_bersepeda_gunung_warna_kulit_cerah",
        "alias": "pria_bersepeda_gunung_warna_kulit_cerah_laki-laki_sepeda",
    },
    "\U0001F6B5\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mountain_biking_medium-light_skin_tone",
        "id": "pria_bersepeda_gunung_warna_kulit_cerah-sedang",
        "alias": "pria_bersepeda_gunung_warna_kulit_cerah-sedang_laki-laki_sepeda",
    },
    "\U0001F6B5\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mountain_biking_medium_skin_tone",
        "id": "pria_bersepeda_gunung_warna_kulit_sedang",
        "alias": "pria_bersepeda_gunung_warna_kulit_sedang_laki-laki_sepeda",
    },
    "\U0001F6B5\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mountain_biking_medium-dark_skin_tone",
        "id": "pria_bersepeda_gunung_warna_kulit_gelap-sedang",
        "alias": "pria_bersepeda_gunung_warna_kulit_gelap-sedang_laki-laki_sepeda",
    },
    "\U0001F6B5\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_mountain_biking_dark_skin_tone",
        "id": "pria_bersepeda_gunung_warna_kulit_gelap",
        "alias": "pria_bersepeda_gunung_warna_kulit_gelap_laki-laki_sepeda",
    },
    "\U0001F6B5\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mountain_biking_light_skin_tone",
        "id": "wanita_bersepeda_gunung_warna_kulit_cerah",
        "alias": "wanita_bersepeda_gunung_warna_kulit_cerah_perempuan_sepeda",
    },
    "\U0001F6B5\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mountain_biking_medium-light_skin_tone",
        "id": "wanita_bersepeda_gunung_warna_kulit_cerah-sedang",
        "alias": "wanita_bersepeda_gunung_warna_kulit_cerah-sedang_perempuan_sepeda",
    },
    "\U0001F6B5\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mountain_biking_medium_skin_tone",
        "id": "wanita_bersepeda_gunung_warna_kulit_sedang",
        "alias": "wanita_bersepeda_gunung_warna_kulit_sedang_perempuan_sepeda",
    },
    "\U0001F6B5\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mountain_biking_medium-dark_skin_tone",
        "id": "wanita_bersepeda_gunung_warna_kulit_gelap-sedang",
        "alias": "wanita_bersepeda_gunung_warna_kulit_gelap-sedang_perempuan_sepeda",
    },
    "\U0001F6B5\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_mountain_biking_dark_skin_tone",
        "id": "wanita_bersepeda_gunung_warna_kulit_gelap",
        "alias": "wanita_bersepeda_gunung_warna_kulit_gelap_perempuan_sepeda",
    },
    "\U0001F938\U0001F3FB": {
        "en": "person_cartwheeling_light_skin_tone",
        "id": "orang_melakukan_gerakan_meroda_warna_kulit_cerah",
        "alias": "orang_melakukan_gerakan_meroda_warna_kulit_cerah_gimnastik_olahraga_salto_senam",
    },
    "\U0001F938\U0001F3FC": {
        "en": "person_cartwheeling_medium-light_skin_tone",
        "id": "orang_melakukan_gerakan_meroda_warna_kulit_cerah-sedang",
        "alias": "orang_melakukan_gerakan_meroda_warna_kulit_cerah-sedang_gimnastik_olahraga_salto_senam",
    },
    "\U0001F938\U0001F3FD": {
        "en": "person_cartwheeling_medium_skin_tone",
        "id": "orang_melakukan_gerakan_meroda_warna_kulit_sedang",
        "alias": "orang_melakukan_gerakan_meroda_warna_kulit_sedang_gimnastik_olahraga_salto_senam",
    },
    "\U0001F938\U0001F3FE": {
        "en": "person_cartwheeling_medium-dark_skin_tone",
        "id": "orang_melakukan_gerakan_meroda_warna_kulit_gelap-sedang",
        "alias": "orang_melakukan_gerakan_meroda_warna_kulit_gelap-sedang_gimnastik_olahraga_salto_senam",
    },
    "\U0001F938\U0001F3FF": {
        "en": "person_cartwheeling_dark_skin_tone",
        "id": "orang_melakukan_gerakan_meroda_warna_kulit_gelap",
        "alias": "orang_melakukan_gerakan_meroda_warna_kulit_gelap_gimnastik_olahraga_salto_senam",
    },
    "\U0001F938\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_cartwheeling_light_skin_tone",
        "id": "pria_melakukan_gerakan_meroda_warna_kulit_cerah",
        "alias": "pria_melakukan_gerakan_meroda_warna_kulit_cerah_balik_jungkir_laki-laki",
    },
    "\U0001F938\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_cartwheeling_medium-light_skin_tone",
        "id": "pria_melakukan_gerakan_meroda_warna_kulit_cerah-sedang",
        "alias": "pria_melakukan_gerakan_meroda_warna_kulit_cerah-sedang_balik_jungkir_laki-laki",
    },
    "\U0001F938\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_cartwheeling_medium_skin_tone",
        "id": "pria_melakukan_gerakan_meroda_warna_kulit_sedang",
        "alias": "pria_melakukan_gerakan_meroda_warna_kulit_sedang_balik_jungkir_laki-laki",
    },
    "\U0001F938\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_cartwheeling_medium-dark_skin_tone",
        "id": "pria_melakukan_gerakan_meroda_warna_kulit_gelap-sedang",
        "alias": "pria_melakukan_gerakan_meroda_warna_kulit_gelap-sedang_balik_jungkir_laki-laki",
    },
    "\U0001F938\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_cartwheeling_dark_skin_tone",
        "id": "pria_melakukan_gerakan_meroda_warna_kulit_gelap",
        "alias": "pria_melakukan_gerakan_meroda_warna_kulit_gelap_balik_jungkir_laki-laki",
    },
    "\U0001F938\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_cartwheeling_light_skin_tone",
        "id": "wanita_melakukan_gerakan_meroda_warna_kulit_cerah",
        "alias": "wanita_melakukan_gerakan_meroda_warna_kulit_cerah_balik_jungkir_perempuan",
    },
    "\U0001F938\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_cartwheeling_medium-light_skin_tone",
        "id": "wanita_melakukan_gerakan_meroda_warna_kulit_cerah-sedang",
        "alias": "wanita_melakukan_gerakan_meroda_warna_kulit_cerah-sedang_balik_jungkir_perempuan",
    },
    "\U0001F938\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_cartwheeling_medium_skin_tone",
        "id": "wanita_melakukan_gerakan_meroda_warna_kulit_sedang",
        "alias": "wanita_melakukan_gerakan_meroda_warna_kulit_sedang_balik_jungkir_perempuan",
    },
    "\U0001F938\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_cartwheeling_medium-dark_skin_tone",
        "id": "wanita_melakukan_gerakan_meroda_warna_kulit_gelap-sedang",
        "alias": "wanita_melakukan_gerakan_meroda_warna_kulit_gelap-sedang_balik_jungkir_perempuan",
    },
    "\U0001F938\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_cartwheeling_dark_skin_tone",
        "id": "wanita_melakukan_gerakan_meroda_warna_kulit_gelap",
        "alias": "wanita_melakukan_gerakan_meroda_warna_kulit_gelap_balik_jungkir_perempuan",
    },
    "\U0001F93D\U0001F3FB": {
        "en": "person_playing_water_polo_light_skin_tone",
        "id": "orang_bermain_polo_air_warna_kulit_cerah",
        "alias": "orang_bermain_polo_air_warna_kulit_cerah_olahraga",
    },
    "\U0001F93D\U0001F3FC": {
        "en": "person_playing_water_polo_medium-light_skin_tone",
        "id": "orang_bermain_polo_air_warna_kulit_cerah-sedang",
        "alias": "orang_bermain_polo_air_warna_kulit_cerah-sedang_olahraga",
    },
    "\U0001F93D\U0001F3FD": {
        "en": "person_playing_water_polo_medium_skin_tone",
        "id": "orang_bermain_polo_air_warna_kulit_sedang",
        "alias": "orang_bermain_polo_air_warna_kulit_sedang_olahraga",
    },
    "\U0001F93D\U0001F3FE": {
        "en": "person_playing_water_polo_medium-dark_skin_tone",
        "id": "orang_bermain_polo_air_warna_kulit_gelap-sedang",
        "alias": "orang_bermain_polo_air_warna_kulit_gelap-sedang_olahraga",
    },
    "\U0001F93D\U0001F3FF": {
        "en": "person_playing_water_polo_dark_skin_tone",
        "id": "orang_bermain_polo_air_warna_kulit_gelap",
        "alias": "orang_bermain_polo_air_warna_kulit_gelap_olahraga",
    },
    "\U0001F93D\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_water_polo_light_skin_tone",
        "id": "pria_bermain_polo_air_warna_kulit_cerah",
        "alias": "pria_bermain_polo_air_warna_kulit_cerah_laki-laki",
    },
    "\U0001F93D\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_water_polo_medium-light_skin_tone",
        "id": "pria_bermain_polo_air_warna_kulit_cerah-sedang",
        "alias": "pria_bermain_polo_air_warna_kulit_cerah-sedang_laki-laki",
    },
    "\U0001F93D\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_water_polo_medium_skin_tone",
        "id": "pria_bermain_polo_air_warna_kulit_sedang",
        "alias": "pria_bermain_polo_air_warna_kulit_sedang_laki-laki",
    },
    "\U0001F93D\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_water_polo_medium-dark_skin_tone",
        "id": "pria_bermain_polo_air_warna_kulit_gelap-sedang",
        "alias": "pria_bermain_polo_air_warna_kulit_gelap-sedang_laki-laki",
    },
    "\U0001F93D\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_water_polo_dark_skin_tone",
        "id": "pria_bermain_polo_air_warna_kulit_gelap",
        "alias": "pria_bermain_polo_air_warna_kulit_gelap_laki-laki",
    },
    "\U0001F93D\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_water_polo_light_skin_tone",
        "id": "wanita_bermain_polo_air_warna_kulit_cerah",
        "alias": "wanita_bermain_polo_air_warna_kulit_cerah_perempuan",
    },
    "\U0001F93D\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_water_polo_medium-light_skin_tone",
        "id": "wanita_bermain_polo_air_warna_kulit_cerah-sedang",
        "alias": "wanita_bermain_polo_air_warna_kulit_cerah-sedang_perempuan",
    },
    "\U0001F93D\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_water_polo_medium_skin_tone",
        "id": "wanita_bermain_polo_air_warna_kulit_sedang",
        "alias": "wanita_bermain_polo_air_warna_kulit_sedang_perempuan",
    },
    "\U0001F93D\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_water_polo_medium-dark_skin_tone",
        "id": "wanita_bermain_polo_air_warna_kulit_gelap-sedang",
        "alias": "wanita_bermain_polo_air_warna_kulit_gelap-sedang_perempuan",
    },
    "\U0001F93D\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_water_polo_dark_skin_tone",
        "id": "wanita_bermain_polo_air_warna_kulit_gelap",
        "alias": "wanita_bermain_polo_air_warna_kulit_gelap_perempuan",
    },
    "\U0001F93E\U0001F3FB": {
        "en": "person_playing_handball_light_skin_tone",
        "id": "orang_bermain_bola_tangan_warna_kulit_cerah",
        "alias": "orang_bermain_bola_tangan_warna_kulit_cerah_olahraga",
    },
    "\U0001F93E\U0001F3FC": {
        "en": "person_playing_handball_medium-light_skin_tone",
        "id": "orang_bermain_bola_tangan_warna_kulit_cerah-sedang",
        "alias": "orang_bermain_bola_tangan_warna_kulit_cerah-sedang_olahraga",
    },
    "\U0001F93E\U0001F3FD": {
        "en": "person_playing_handball_medium_skin_tone",
        "id": "orang_bermain_bola_tangan_warna_kulit_sedang",
        "alias": "orang_bermain_bola_tangan_warna_kulit_sedang_olahraga",
    },
    "\U0001F93E\U0001F3FE": {
        "en": "person_playing_handball_medium-dark_skin_tone",
        "id": "orang_bermain_bola_tangan_warna_kulit_gelap-sedang",
        "alias": "orang_bermain_bola_tangan_warna_kulit_gelap-sedang_olahraga",
    },
    "\U0001F93E\U0001F3FF": {
        "en": "person_playing_handball_dark_skin_tone",
        "id": "orang_bermain_bola_tangan_warna_kulit_gelap",
        "alias": "orang_bermain_bola_tangan_warna_kulit_gelap_olahraga",
    },
    "\U0001F93E\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_handball_light_skin_tone",
        "id": "pria_bermain_bola_tangan_warna_kulit_cerah",
        "alias": "pria_bermain_bola_tangan_warna_kulit_cerah_laki-laki",
    },
    "\U0001F93E\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_handball_medium-light_skin_tone",
        "id": "pria_bermain_bola_tangan_warna_kulit_cerah-sedang",
        "alias": "pria_bermain_bola_tangan_warna_kulit_cerah-sedang_laki-laki",
    },
    "\U0001F93E\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_handball_medium_skin_tone",
        "id": "pria_bermain_bola_tangan_warna_kulit_sedang",
        "alias": "pria_bermain_bola_tangan_warna_kulit_sedang_laki-laki",
    },
    "\U0001F93E\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_handball_medium-dark_skin_tone",
        "id": "pria_bermain_bola_tangan_warna_kulit_gelap-sedang",
        "alias": "pria_bermain_bola_tangan_warna_kulit_gelap-sedang_laki-laki",
    },
    "\U0001F93E\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_playing_handball_dark_skin_tone",
        "id": "pria_bermain_bola_tangan_warna_kulit_gelap",
        "alias": "pria_bermain_bola_tangan_warna_kulit_gelap_laki-laki",
    },
    "\U0001F93E\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_handball_light_skin_tone",
        "id": "wanita_bermain_bola_tangan_warna_kulit_cerah",
        "alias": "wanita_bermain_bola_tangan_warna_kulit_cerah_perempuan",
    },
    "\U0001F93E\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_handball_medium-light_skin_tone",
        "id": "wanita_bermain_bola_tangan_warna_kulit_cerah-sedang",
        "alias": "wanita_bermain_bola_tangan_warna_kulit_cerah-sedang_perempuan",
    },
    "\U0001F93E\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_handball_medium_skin_tone",
        "id": "wanita_bermain_bola_tangan_warna_kulit_sedang",
        "alias": "wanita_bermain_bola_tangan_warna_kulit_sedang_perempuan",
    },
    "\U0001F93E\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_handball_medium-dark_skin_tone",
        "id": "wanita_bermain_bola_tangan_warna_kulit_gelap-sedang",
        "alias": "wanita_bermain_bola_tangan_warna_kulit_gelap-sedang_perempuan",
    },
    "\U0001F93E\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_playing_handball_dark_skin_tone",
        "id": "wanita_bermain_bola_tangan_warna_kulit_gelap",
        "alias": "wanita_bermain_bola_tangan_warna_kulit_gelap_perempuan",
    },
    "\U0001F939\U0001F3FB": {
        "en": "person_juggling_light_skin_tone",
        "id": "orang_melempar_warna_kulit_cerah",
        "alias": "orang_melempar_warna_kulit_cerah_juggling_multitasking_repot_sibuk",
    },
    "\U0001F939\U0001F3FC": {
        "en": "person_juggling_medium-light_skin_tone",
        "id": "orang_melempar_warna_kulit_cerah-sedang",
        "alias": "orang_melempar_warna_kulit_cerah-sedang_juggling_multitasking_repot_sibuk",
    },
    "\U0001F939\U0001F3FD": {
        "en": "person_juggling_medium_skin_tone",
        "id": "orang_melempar_warna_kulit_sedang",
        "alias": "orang_melempar_warna_kulit_sedang_juggling_multitasking_repot_sibuk",
    },
    "\U0001F939\U0001F3FE": {
        "en": "person_juggling_medium-dark_skin_tone",
        "id": "orang_melempar_warna_kulit_gelap-sedang",
        "alias": "orang_melempar_warna_kulit_gelap-sedang_juggling_multitasking_repot_sibuk",
    },
    "\U0001F939\U0001F3FF": {
        "en": "person_juggling_dark_skin_tone",
        "id": "orang_melempar_warna_kulit_gelap",
        "alias": "orang_melempar_warna_kulit_gelap_juggling_multitasking_repot_sibuk",
    },
    "\U0001F939\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_juggling_light_skin_tone",
        "id": "pria_melempar_warna_kulit_cerah",
        "alias": "pria_melempar_warna_kulit_cerah_atraksi_laki-laki",
    },
    "\U0001F939\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_juggling_medium-light_skin_tone",
        "id": "pria_melempar_warna_kulit_cerah-sedang",
        "alias": "pria_melempar_warna_kulit_cerah-sedang_atraksi_laki-laki",
    },
    "\U0001F939\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_juggling_medium_skin_tone",
        "id": "pria_melempar_warna_kulit_sedang",
        "alias": "pria_melempar_warna_kulit_sedang_atraksi_laki-laki",
    },
    "\U0001F939\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_juggling_medium-dark_skin_tone",
        "id": "pria_melempar_warna_kulit_gelap-sedang",
        "alias": "pria_melempar_warna_kulit_gelap-sedang_atraksi_laki-laki",
    },
    "\U0001F939\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_juggling_dark_skin_tone",
        "id": "pria_melempar_warna_kulit_gelap",
        "alias": "pria_melempar_warna_kulit_gelap_atraksi_laki-laki",
    },
    "\U0001F939\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_juggling_light_skin_tone",
        "id": "wanita_melempar_warna_kulit_cerah",
        "alias": "wanita_melempar_warna_kulit_cerah_atraksi_perempuan",
    },
    "\U0001F939\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_juggling_medium-light_skin_tone",
        "id": "wanita_melempar_warna_kulit_cerah-sedang",
        "alias": "wanita_melempar_warna_kulit_cerah-sedang_atraksi_perempuan",
    },
    "\U0001F939\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_juggling_medium_skin_tone",
        "id": "wanita_melempar_warna_kulit_sedang",
        "alias": "wanita_melempar_warna_kulit_sedang_atraksi_perempuan",
    },
    "\U0001F939\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_juggling_medium-dark_skin_tone",
        "id": "wanita_melempar_warna_kulit_gelap-sedang",
        "alias": "wanita_melempar_warna_kulit_gelap-sedang_atraksi_perempuan",
    },
    "\U0001F939\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_juggling_dark_skin_tone",
        "id": "wanita_melempar_warna_kulit_gelap",
        "alias": "wanita_melempar_warna_kulit_gelap_atraksi_perempuan",
    },
    "\U0001F9D8\U0001F3FB": {
        "en": "person_in_lotus_position_light_skin_tone",
        "id": "orang_dalam_posisi_teratai_warna_kulit_cerah",
        "alias": "orang_dalam_posisi_teratai_warna_kulit_cerah_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FC": {
        "en": "person_in_lotus_position_medium-light_skin_tone",
        "id": "orang_dalam_posisi_teratai_warna_kulit_cerah-sedang",
        "alias": "orang_dalam_posisi_teratai_warna_kulit_cerah-sedang_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FD": {
        "en": "person_in_lotus_position_medium_skin_tone",
        "id": "orang_dalam_posisi_teratai_warna_kulit_sedang",
        "alias": "orang_dalam_posisi_teratai_warna_kulit_sedang_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FE": {
        "en": "person_in_lotus_position_medium-dark_skin_tone",
        "id": "orang_dalam_posisi_teratai_warna_kulit_gelap-sedang",
        "alias": "orang_dalam_posisi_teratai_warna_kulit_gelap-sedang_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FF": {
        "en": "person_in_lotus_position_dark_skin_tone",
        "id": "orang_dalam_posisi_teratai_warna_kulit_gelap",
        "alias": "orang_dalam_posisi_teratai_warna_kulit_gelap_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FB\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_lotus_position_light_skin_tone",
        "id": "pria_dalam_posisi_teratai_warna_kulit_cerah",
        "alias": "pria_dalam_posisi_teratai_warna_kulit_cerah_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FC\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_lotus_position_medium-light_skin_tone",
        "id": "pria_dalam_posisi_teratai_warna_kulit_cerah-sedang",
        "alias": "pria_dalam_posisi_teratai_warna_kulit_cerah-sedang_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FD\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_lotus_position_medium_skin_tone",
        "id": "pria_dalam_posisi_teratai_warna_kulit_sedang",
        "alias": "pria_dalam_posisi_teratai_warna_kulit_sedang_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FE\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_lotus_position_medium-dark_skin_tone",
        "id": "pria_dalam_posisi_teratai_warna_kulit_gelap-sedang",
        "alias": "pria_dalam_posisi_teratai_warna_kulit_gelap-sedang_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FF\U0000200D\U00002642\U0000FE0F": {
        "en": "man_in_lotus_position_dark_skin_tone",
        "id": "pria_dalam_posisi_teratai_warna_kulit_gelap",
        "alias": "pria_dalam_posisi_teratai_warna_kulit_gelap_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FB\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_lotus_position_light_skin_tone",
        "id": "wanita_dalam_posisi_teratai_warna_kulit_cerah",
        "alias": "wanita_dalam_posisi_teratai_warna_kulit_cerah_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FC\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_lotus_position_medium-light_skin_tone",
        "id": "wanita_dalam_posisi_teratai_warna_kulit_cerah-sedang",
        "alias": "wanita_dalam_posisi_teratai_warna_kulit_cerah-sedang_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FD\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_lotus_position_medium_skin_tone",
        "id": "wanita_dalam_posisi_teratai_warna_kulit_sedang",
        "alias": "wanita_dalam_posisi_teratai_warna_kulit_sedang_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FE\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_lotus_position_medium-dark_skin_tone",
        "id": "wanita_dalam_posisi_teratai_warna_kulit_gelap-sedang",
        "alias": "wanita_dalam_posisi_teratai_warna_kulit_gelap-sedang_meditasi_yoga",
    },
    "\U0001F9D8\U0001F3FF\U0000200D\U00002640\U0000FE0F": {
        "en": "woman_in_lotus_position_dark_skin_tone",
        "id": "wanita_dalam_posisi_teratai_warna_kulit_gelap",
        "alias": "wanita_dalam_posisi_teratai_warna_kulit_gelap_meditasi_yoga",
    },
    "\U0001F6C0\U0001F3FB": {
        "en": "person_taking_bath_light_skin_tone",
        "id": "orang_di_bak_mandi_warna_kulit_cerah",
    },
    "\U0001F6C0\U0001F3FC": {
        "en": "person_taking_bath_medium-light_skin_tone",
        "id": "orang_di_bak_mandi_warna_kulit_cerah-sedang",
    },
    "\U0001F6C0\U0001F3FD": {
        "en": "person_taking_bath_medium_skin_tone",
        "id": "orang_di_bak_mandi_warna_kulit_sedang",
    },
    "\U0001F6C0\U0001F3FE": {
        "en": "person_taking_bath_medium-dark_skin_tone",
        "id": "orang_di_bak_mandi_warna_kulit_gelap-sedang",
    },
    "\U0001F6C0\U0001F3FF": {
        "en": "person_taking_bath_dark_skin_tone",
        "id": "orang_di_bak_mandi_warna_kulit_gelap",
    },
    "\U0001F6CC\U0001F3FB": {
        "en": "person_in_bed_light_skin_tone",
        "id": "orang_di_tempat_tidur_warna_kulit_cerah",
        "alias": "orang_di_tempat_tidur_warna_kulit_cerah_hotel",
    },
    "\U0001F6CC\U0001F3FC": {
        "en": "person_in_bed_medium-light_skin_tone",
        "id": "orang_di_tempat_tidur_warna_kulit_cerah-sedang",
        "alias": "orang_di_tempat_tidur_warna_kulit_cerah-sedang_hotel",
    },
    "\U0001F6CC\U0001F3FD": {
        "en": "person_in_bed_medium_skin_tone",
        "id": "orang_di_tempat_tidur_warna_kulit_sedang",
        "alias": "orang_di_tempat_tidur_warna_kulit_sedang_hotel",
    },
    "\U0001F6CC\U0001F3FE": {
        "en": "person_in_bed_medium-dark_skin_tone",
        "id": "orang_di_tempat_tidur_warna_kulit_gelap-sedang",
        "alias": "orang_di_tempat_tidur_warna_kulit_gelap-sedang_hotel",
    },
    "\U0001F6CC\U0001F3FF": {
        "en": "person_in_bed_dark_skin_tone",
        "id": "orang_di_tempat_tidur_warna_kulit_gelap",
        "alias": "orang_di_tempat_tidur_warna_kulit_gelap_hotel",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "people_holding_hands_light_skin_tone",
        "id": "orang_bergandengan_warna_kulit_cerah",
        "alias": "orang_bergandengan_warna_kulit_cerah_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "people_holding_hands_light_skin_tone_medium-light_skin_tone",
        "id": "orang_bergandengan_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "orang_bergandengan_warna_kulit_cerah_cerah-sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "people_holding_hands_light_skin_tone_medium_skin_tone",
        "id": "orang_bergandengan_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "orang_bergandengan_warna_kulit_cerah_sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "people_holding_hands_light_skin_tone_medium-dark_skin_tone",
        "id": "orang_bergandengan_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "orang_bergandengan_warna_kulit_cerah_gelap-sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "people_holding_hands_light_skin_tone_dark_skin_tone",
        "id": "orang_bergandengan_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "orang_bergandengan_warna_kulit_cerah_gelap_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "people_holding_hands_medium-light_skin_tone_light_skin_tone",
        "id": "orang_bergandengan_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "orang_bergandengan_warna_kulit_cerah-sedang_cerah_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "people_holding_hands_medium-light_skin_tone",
        "id": "orang_bergandengan_warna_kulit_cerah-sedang",
        "alias": "orang_bergandengan_warna_kulit_cerah-sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "people_holding_hands_medium-light_skin_tone_medium_skin_tone",
        "id": "orang_bergandengan_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "orang_bergandengan_warna_kulit_cerah-sedang_sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "people_holding_hands_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "orang_bergandengan_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "orang_bergandengan_warna_kulit_cerah-sedang_gelap-sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "people_holding_hands_medium-light_skin_tone_dark_skin_tone",
        "id": "orang_bergandengan_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "orang_bergandengan_warna_kulit_cerah-sedang_gelap_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "people_holding_hands_medium_skin_tone_light_skin_tone",
        "id": "orang_bergandengan_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "orang_bergandengan_warna_kulit_sedang_cerah_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "people_holding_hands_medium_skin_tone_medium-light_skin_tone",
        "id": "orang_bergandengan_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "orang_bergandengan_warna_kulit_sedang_cerah-sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "people_holding_hands_medium_skin_tone",
        "id": "orang_bergandengan_warna_kulit_sedang",
        "alias": "orang_bergandengan_warna_kulit_sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "people_holding_hands_medium_skin_tone_medium-dark_skin_tone",
        "id": "orang_bergandengan_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "orang_bergandengan_warna_kulit_sedang_gelap-sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "people_holding_hands_medium_skin_tone_dark_skin_tone",
        "id": "orang_bergandengan_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "orang_bergandengan_warna_kulit_sedang_gelap_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "people_holding_hands_medium-dark_skin_tone_light_skin_tone",
        "id": "orang_bergandengan_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "orang_bergandengan_warna_kulit_gelap-sedang_cerah_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "people_holding_hands_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "orang_bergandengan_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "orang_bergandengan_warna_kulit_gelap-sedang_cerah-sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "people_holding_hands_medium-dark_skin_tone_medium_skin_tone",
        "id": "orang_bergandengan_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "orang_bergandengan_warna_kulit_gelap-sedang_sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "people_holding_hands_medium-dark_skin_tone",
        "id": "orang_bergandengan_warna_kulit_gelap-sedang",
        "alias": "orang_bergandengan_warna_kulit_gelap-sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "people_holding_hands_medium-dark_skin_tone_dark_skin_tone",
        "id": "orang_bergandengan_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "orang_bergandengan_warna_kulit_gelap-sedang_gelap_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "people_holding_hands_dark_skin_tone_light_skin_tone",
        "id": "orang_bergandengan_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "orang_bergandengan_warna_kulit_gelap_cerah_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "people_holding_hands_dark_skin_tone_medium-light_skin_tone",
        "id": "orang_bergandengan_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "orang_bergandengan_warna_kulit_gelap_cerah-sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "people_holding_hands_dark_skin_tone_medium_skin_tone",
        "id": "orang_bergandengan_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "orang_bergandengan_warna_kulit_gelap_sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "people_holding_hands_dark_skin_tone_medium-dark_skin_tone",
        "id": "orang_bergandengan_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "orang_bergandengan_warna_kulit_gelap_gelap-sedang_pasangan_tangan",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "people_holding_hands_dark_skin_tone",
        "id": "orang_bergandengan_warna_kulit_gelap",
        "alias": "orang_bergandengan_warna_kulit_gelap_pasangan_tangan",
    },
    "\U0001F46D\U0001F3FB": {
        "en": "women_holding_hands_light_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_cerah",
        "alias": "dua_wanita_bergandengan_warna_kulit_cerah_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC": {
        "en": "women_holding_hands_light_skin_tone_medium-light_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_cerah_cerah-sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD": {
        "en": "women_holding_hands_light_skin_tone_medium_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_cerah_sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE": {
        "en": "women_holding_hands_light_skin_tone_medium-dark_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_cerah_gelap-sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF": {
        "en": "women_holding_hands_light_skin_tone_dark_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "dua_wanita_bergandengan_warna_kulit_cerah_gelap_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB": {
        "en": "women_holding_hands_medium-light_skin_tone_light_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "dua_wanita_bergandengan_warna_kulit_cerah-sedang_cerah_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F46D\U0001F3FC": {
        "en": "women_holding_hands_medium-light_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_cerah-sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_cerah-sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD": {
        "en": "women_holding_hands_medium-light_skin_tone_medium_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_cerah-sedang_sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE": {
        "en": "women_holding_hands_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_cerah-sedang_gelap-sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF": {
        "en": "women_holding_hands_medium-light_skin_tone_dark_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "dua_wanita_bergandengan_warna_kulit_cerah-sedang_gelap_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB": {
        "en": "women_holding_hands_medium_skin_tone_light_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "dua_wanita_bergandengan_warna_kulit_sedang_cerah_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC": {
        "en": "women_holding_hands_medium_skin_tone_medium-light_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_sedang_cerah-sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F46D\U0001F3FD": {
        "en": "women_holding_hands_medium_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE": {
        "en": "women_holding_hands_medium_skin_tone_medium-dark_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_sedang_gelap-sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF": {
        "en": "women_holding_hands_medium_skin_tone_dark_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "dua_wanita_bergandengan_warna_kulit_sedang_gelap_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB": {
        "en": "women_holding_hands_medium-dark_skin_tone_light_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "dua_wanita_bergandengan_warna_kulit_gelap-sedang_cerah_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC": {
        "en": "women_holding_hands_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_gelap-sedang_cerah-sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD": {
        "en": "women_holding_hands_medium-dark_skin_tone_medium_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_gelap-sedang_sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F46D\U0001F3FE": {
        "en": "women_holding_hands_medium-dark_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_gelap-sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_gelap-sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FF": {
        "en": "women_holding_hands_medium-dark_skin_tone_dark_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "dua_wanita_bergandengan_warna_kulit_gelap-sedang_gelap_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FB": {
        "en": "women_holding_hands_dark_skin_tone_light_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "dua_wanita_bergandengan_warna_kulit_gelap_cerah_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FC": {
        "en": "women_holding_hands_dark_skin_tone_medium-light_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_gelap_cerah-sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FD": {
        "en": "women_holding_hands_dark_skin_tone_medium_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_gelap_sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F469\U0001F3FE": {
        "en": "women_holding_hands_dark_skin_tone_medium-dark_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "dua_wanita_bergandengan_warna_kulit_gelap_gelap-sedang_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F46D\U0001F3FF": {
        "en": "women_holding_hands_dark_skin_tone",
        "id": "dua_wanita_bergandengan_warna_kulit_gelap",
        "alias": "dua_wanita_bergandengan_warna_kulit_gelap_cewek_gandeng_pasangan_pegangan_tangan",
    },
    "\U0001F46B\U0001F3FB": {
        "en": "woman_and_man_holding_hands_light_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_cerah",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_cerah_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": {
        "en": "woman_and_man_holding_hands_light_skin_tone_medium-light_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_cerah_cerah-sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": {
        "en": "woman_and_man_holding_hands_light_skin_tone_medium_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_cerah_sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": {
        "en": "woman_and_man_holding_hands_light_skin_tone_medium-dark_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_cerah_gelap-sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": {
        "en": "woman_and_man_holding_hands_light_skin_tone_dark_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_cerah_gelap_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": {
        "en": "woman_and_man_holding_hands_medium-light_skin_tone_light_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_cerah-sedang_cerah_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F46B\U0001F3FC": {
        "en": "woman_and_man_holding_hands_medium-light_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_cerah-sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_cerah-sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": {
        "en": "woman_and_man_holding_hands_medium-light_skin_tone_medium_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_cerah-sedang_sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": {
        "en": "woman_and_man_holding_hands_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_cerah-sedang_gelap-sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": {
        "en": "woman_and_man_holding_hands_medium-light_skin_tone_dark_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_cerah-sedang_gelap_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": {
        "en": "woman_and_man_holding_hands_medium_skin_tone_light_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_sedang_cerah_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": {
        "en": "woman_and_man_holding_hands_medium_skin_tone_medium-light_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_sedang_cerah-sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F46B\U0001F3FD": {
        "en": "woman_and_man_holding_hands_medium_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": {
        "en": "woman_and_man_holding_hands_medium_skin_tone_medium-dark_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_sedang_gelap-sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": {
        "en": "woman_and_man_holding_hands_medium_skin_tone_dark_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_sedang_gelap_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": {
        "en": "woman_and_man_holding_hands_medium-dark_skin_tone_light_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_gelap-sedang_cerah_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": {
        "en": "woman_and_man_holding_hands_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_gelap-sedang_cerah-sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": {
        "en": "woman_and_man_holding_hands_medium-dark_skin_tone_medium_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_gelap-sedang_sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F46B\U0001F3FE": {
        "en": "woman_and_man_holding_hands_medium-dark_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_gelap-sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_gelap-sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": {
        "en": "woman_and_man_holding_hands_medium-dark_skin_tone_dark_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_gelap-sedang_gelap_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": {
        "en": "woman_and_man_holding_hands_dark_skin_tone_light_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_gelap_cerah_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": {
        "en": "woman_and_man_holding_hands_dark_skin_tone_medium-light_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_gelap_cerah-sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": {
        "en": "woman_and_man_holding_hands_dark_skin_tone_medium_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_gelap_sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F469\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": {
        "en": "woman_and_man_holding_hands_dark_skin_tone_medium-dark_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_gelap_gelap-sedang_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F46B\U0001F3FF": {
        "en": "woman_and_man_holding_hands_dark_skin_tone",
        "id": "pria_dan_wanita_bergandengan_warna_kulit_gelap",
        "alias": "pria_dan_wanita_bergandengan_warna_kulit_gelap_pasangan_pegangan_berpegangan_tangan",
    },
    "\U0001F46C\U0001F3FB": {
        "en": "men_holding_hands_light_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_cerah",
        "alias": "dua_pria_bergandengan_warna_kulit_cerah_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": {
        "en": "men_holding_hands_light_skin_tone_medium-light_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_cerah_cerah-sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": {
        "en": "men_holding_hands_light_skin_tone_medium_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_cerah_sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": {
        "en": "men_holding_hands_light_skin_tone_medium-dark_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_cerah_gelap-sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FB\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": {
        "en": "men_holding_hands_light_skin_tone_dark_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "dua_pria_bergandengan_warna_kulit_cerah_gelap_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": {
        "en": "men_holding_hands_medium-light_skin_tone_light_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "dua_pria_bergandengan_warna_kulit_cerah-sedang_cerah_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F46C\U0001F3FC": {
        "en": "men_holding_hands_medium-light_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_cerah-sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_cerah-sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": {
        "en": "men_holding_hands_medium-light_skin_tone_medium_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_cerah-sedang_sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": {
        "en": "men_holding_hands_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_cerah-sedang_gelap-sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FC\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": {
        "en": "men_holding_hands_medium-light_skin_tone_dark_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "dua_pria_bergandengan_warna_kulit_cerah-sedang_gelap_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": {
        "en": "men_holding_hands_medium_skin_tone_light_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "dua_pria_bergandengan_warna_kulit_sedang_cerah_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": {
        "en": "men_holding_hands_medium_skin_tone_medium-light_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_sedang_cerah-sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F46C\U0001F3FD": {
        "en": "men_holding_hands_medium_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": {
        "en": "men_holding_hands_medium_skin_tone_medium-dark_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_sedang_gelap-sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FD\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": {
        "en": "men_holding_hands_medium_skin_tone_dark_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "dua_pria_bergandengan_warna_kulit_sedang_gelap_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": {
        "en": "men_holding_hands_medium-dark_skin_tone_light_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "dua_pria_bergandengan_warna_kulit_gelap-sedang_cerah_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": {
        "en": "men_holding_hands_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_gelap-sedang_cerah-sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": {
        "en": "men_holding_hands_medium-dark_skin_tone_medium_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_gelap-sedang_sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F46C\U0001F3FE": {
        "en": "men_holding_hands_medium-dark_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_gelap-sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_gelap-sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FE\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FF": {
        "en": "men_holding_hands_medium-dark_skin_tone_dark_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "dua_pria_bergandengan_warna_kulit_gelap-sedang_gelap_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FB": {
        "en": "men_holding_hands_dark_skin_tone_light_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "dua_pria_bergandengan_warna_kulit_gelap_cerah_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FC": {
        "en": "men_holding_hands_dark_skin_tone_medium-light_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_gelap_cerah-sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FD": {
        "en": "men_holding_hands_dark_skin_tone_medium_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_gelap_sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F468\U0001F3FF\U0000200D\U0001F91D\U0000200D\U0001F468\U0001F3FE": {
        "en": "men_holding_hands_dark_skin_tone_medium-dark_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "dua_pria_bergandengan_warna_kulit_gelap_gelap-sedang_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001F46C\U0001F3FF": {
        "en": "men_holding_hands_dark_skin_tone",
        "id": "dua_pria_bergandengan_warna_kulit_gelap",
        "alias": "dua_pria_bergandengan_warna_kulit_gelap_cowok_gandeng_gemini_kembar_pasangan_pegangan_tangan_zodiak",
    },
    "\U0001f48f\U0001f3fb": {"en": "kiss_light_skin_tone", "id": "ciuman_warna_kulit_cerah"},
    "\U0001f48f\U0001f3fc": {
        "en": "kiss_medium-light_skin_tone",
        "id": "ciuman_warna_kulit_cerah-sedang",
    },
    "\U0001f48f\U0001f3fd": {"en": "kiss_medium_skin_tone", "id": "ciuman_warna_kulit_sedang"},
    "\U0001f48f\U0001f3fe": {
        "en": "kiss_medium-dark_skin_tone",
        "id": "ciuman_warna_kulit_gelap-sedang",
    },
    "\U0001f48f\U0001f3ff": {"en": "kiss_dark_skin_tone", "id": "ciuman_warna_kulit_gelap"},
    "\U0001F9D1\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "kiss_person_person_light_skin_tone_medium-light_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "berciuman_dewasa_warna_kulit_cerah_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "kiss_person_person_light_skin_tone_medium_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "berciuman_dewasa_warna_kulit_cerah_sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "kiss_person_person_light_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "berciuman_dewasa_warna_kulit_cerah_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "kiss_person_person_light_skin_tone_dark_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "berciuman_dewasa_warna_kulit_cerah_gelap_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "kiss_person_person_medium-light_skin_tone_light_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "berciuman_dewasa_warna_kulit_cerah-sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "kiss_person_person_medium-light_skin_tone_medium_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "berciuman_dewasa_warna_kulit_cerah-sedang_sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "kiss_person_person_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "berciuman_dewasa_warna_kulit_cerah-sedang_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "kiss_person_person_medium-light_skin_tone_dark_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "berciuman_dewasa_warna_kulit_cerah-sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "kiss_person_person_medium_skin_tone_light_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "berciuman_dewasa_warna_kulit_sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "kiss_person_person_medium_skin_tone_medium-light_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "berciuman_dewasa_warna_kulit_sedang_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "kiss_person_person_medium_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "berciuman_dewasa_warna_kulit_sedang_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "kiss_person_person_medium_skin_tone_dark_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "berciuman_dewasa_warna_kulit_sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "kiss_person_person_medium-dark_skin_tone_light_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "berciuman_dewasa_warna_kulit_gelap-sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "kiss_person_person_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "berciuman_dewasa_warna_kulit_gelap-sedang_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "kiss_person_person_medium-dark_skin_tone_medium_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "berciuman_dewasa_warna_kulit_gelap-sedang_sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "kiss_person_person_medium-dark_skin_tone_dark_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "berciuman_dewasa_warna_kulit_gelap-sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "kiss_person_person_dark_skin_tone_light_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "berciuman_dewasa_warna_kulit_gelap_cerah_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "kiss_person_person_dark_skin_tone_medium-light_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "berciuman_dewasa_warna_kulit_gelap_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "kiss_person_person_dark_skin_tone_medium_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "berciuman_dewasa_warna_kulit_gelap_sedang_cium_pasangan_romantis",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "kiss_person_person_dark_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_dewasa_dewasa_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "berciuman_dewasa_warna_kulit_gelap_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FB": {
        "en": "kiss_woman_man_light_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_cerah",
        "alias": "berciuman_wanita_pria_warna_kulit_cerah_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FC": {
        "en": "kiss_woman_man_light_skin_tone_medium-light_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_cerah_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FD": {
        "en": "kiss_woman_man_light_skin_tone_medium_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_cerah_sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FE": {
        "en": "kiss_woman_man_light_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_cerah_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FF": {
        "en": "kiss_woman_man_light_skin_tone_dark_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "berciuman_wanita_pria_warna_kulit_cerah_gelap_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FB": {
        "en": "kiss_woman_man_medium-light_skin_tone_light_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "berciuman_wanita_pria_warna_kulit_cerah-sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FC": {
        "en": "kiss_woman_man_medium-light_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_cerah-sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FD": {
        "en": "kiss_woman_man_medium-light_skin_tone_medium_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_cerah-sedang_sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FE": {
        "en": "kiss_woman_man_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_cerah-sedang_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FF": {
        "en": "kiss_woman_man_medium-light_skin_tone_dark_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "berciuman_wanita_pria_warna_kulit_cerah-sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FB": {
        "en": "kiss_woman_man_medium_skin_tone_light_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "berciuman_wanita_pria_warna_kulit_sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FC": {
        "en": "kiss_woman_man_medium_skin_tone_medium-light_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_sedang_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FD": {
        "en": "kiss_woman_man_medium_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FE": {
        "en": "kiss_woman_man_medium_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_sedang_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FF": {
        "en": "kiss_woman_man_medium_skin_tone_dark_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "berciuman_wanita_pria_warna_kulit_sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FB": {
        "en": "kiss_woman_man_medium-dark_skin_tone_light_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "berciuman_wanita_pria_warna_kulit_gelap-sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FC": {
        "en": "kiss_woman_man_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_gelap-sedang_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FD": {
        "en": "kiss_woman_man_medium-dark_skin_tone_medium_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_gelap-sedang_sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FE": {
        "en": "kiss_woman_man_medium-dark_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_gelap-sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FF": {
        "en": "kiss_woman_man_medium-dark_skin_tone_dark_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "berciuman_wanita_pria_warna_kulit_gelap-sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FB": {
        "en": "kiss_woman_man_dark_skin_tone_light_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "berciuman_wanita_pria_warna_kulit_gelap_cerah_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FC": {
        "en": "kiss_woman_man_dark_skin_tone_medium-light_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_gelap_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FD": {
        "en": "kiss_woman_man_dark_skin_tone_medium_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_gelap_sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FE": {
        "en": "kiss_woman_man_dark_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "berciuman_wanita_pria_warna_kulit_gelap_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FF": {
        "en": "kiss_woman_man_dark_skin_tone",
        "id": "berciuman_wanita_pria_warna_kulit_gelap",
        "alias": "berciuman_wanita_pria_warna_kulit_gelap_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FB": {
        "en": "kiss_man_man_light_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_cerah",
        "alias": "berciuman_pria_warna_kulit_cerah_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FC": {
        "en": "kiss_man_man_light_skin_tone_medium-light_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "berciuman_pria_warna_kulit_cerah_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FD": {
        "en": "kiss_man_man_light_skin_tone_medium_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "berciuman_pria_warna_kulit_cerah_sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FE": {
        "en": "kiss_man_man_light_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "berciuman_pria_warna_kulit_cerah_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FF": {
        "en": "kiss_man_man_light_skin_tone_dark_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "berciuman_pria_warna_kulit_cerah_gelap_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FB": {
        "en": "kiss_man_man_medium-light_skin_tone_light_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "berciuman_pria_warna_kulit_cerah-sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FC": {
        "en": "kiss_man_man_medium-light_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_cerah-sedang",
        "alias": "berciuman_pria_warna_kulit_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FD": {
        "en": "kiss_man_man_medium-light_skin_tone_medium_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "berciuman_pria_warna_kulit_cerah-sedang_sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FE": {
        "en": "kiss_man_man_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "berciuman_pria_warna_kulit_cerah-sedang_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FF": {
        "en": "kiss_man_man_medium-light_skin_tone_dark_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "berciuman_pria_warna_kulit_cerah-sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FB": {
        "en": "kiss_man_man_medium_skin_tone_light_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "berciuman_pria_warna_kulit_sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FC": {
        "en": "kiss_man_man_medium_skin_tone_medium-light_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "berciuman_pria_warna_kulit_sedang_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FD": {
        "en": "kiss_man_man_medium_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_sedang",
        "alias": "berciuman_pria_warna_kulit_sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FE": {
        "en": "kiss_man_man_medium_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "berciuman_pria_warna_kulit_sedang_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FF": {
        "en": "kiss_man_man_medium_skin_tone_dark_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "berciuman_pria_warna_kulit_sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FB": {
        "en": "kiss_man_man_medium-dark_skin_tone_light_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "berciuman_pria_warna_kulit_gelap-sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FC": {
        "en": "kiss_man_man_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "berciuman_pria_warna_kulit_gelap-sedang_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FD": {
        "en": "kiss_man_man_medium-dark_skin_tone_medium_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "berciuman_pria_warna_kulit_gelap-sedang_sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FE": {
        "en": "kiss_man_man_medium-dark_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_gelap-sedang",
        "alias": "berciuman_pria_warna_kulit_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FF": {
        "en": "kiss_man_man_medium-dark_skin_tone_dark_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "berciuman_pria_warna_kulit_gelap-sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FB": {
        "en": "kiss_man_man_dark_skin_tone_light_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "berciuman_pria_warna_kulit_gelap_cerah_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FC": {
        "en": "kiss_man_man_dark_skin_tone_medium-light_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "berciuman_pria_warna_kulit_gelap_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FD": {
        "en": "kiss_man_man_dark_skin_tone_medium_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "berciuman_pria_warna_kulit_gelap_sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FE": {
        "en": "kiss_man_man_dark_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "berciuman_pria_warna_kulit_gelap_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468\U0001F3FF": {
        "en": "kiss_man_man_dark_skin_tone",
        "id": "berciuman_pria_pria_warna_kulit_gelap",
        "alias": "berciuman_pria_warna_kulit_gelap_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FB": {
        "en": "kiss_woman_woman_light_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_cerah",
        "alias": "berciuman_wanita_warna_kulit_cerah_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FC": {
        "en": "kiss_woman_woman_light_skin_tone_medium-light_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "berciuman_wanita_warna_kulit_cerah_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FD": {
        "en": "kiss_woman_woman_light_skin_tone_medium_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "berciuman_wanita_warna_kulit_cerah_sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FE": {
        "en": "kiss_woman_woman_light_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "berciuman_wanita_warna_kulit_cerah_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FF": {
        "en": "kiss_woman_woman_light_skin_tone_dark_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "berciuman_wanita_warna_kulit_cerah_gelap_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FB": {
        "en": "kiss_woman_woman_medium-light_skin_tone_light_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "berciuman_wanita_warna_kulit_cerah-sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FC": {
        "en": "kiss_woman_woman_medium-light_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_cerah-sedang",
        "alias": "berciuman_wanita_warna_kulit_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FD": {
        "en": "kiss_woman_woman_medium-light_skin_tone_medium_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "berciuman_wanita_warna_kulit_cerah-sedang_sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FE": {
        "en": "kiss_woman_woman_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "berciuman_wanita_warna_kulit_cerah-sedang_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FF": {
        "en": "kiss_woman_woman_medium-light_skin_tone_dark_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "berciuman_wanita_warna_kulit_cerah-sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FB": {
        "en": "kiss_woman_woman_medium_skin_tone_light_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "berciuman_wanita_warna_kulit_sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FC": {
        "en": "kiss_woman_woman_medium_skin_tone_medium-light_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "berciuman_wanita_warna_kulit_sedang_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FD": {
        "en": "kiss_woman_woman_medium_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_sedang",
        "alias": "berciuman_wanita_warna_kulit_sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FE": {
        "en": "kiss_woman_woman_medium_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "berciuman_wanita_warna_kulit_sedang_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FF": {
        "en": "kiss_woman_woman_medium_skin_tone_dark_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "berciuman_wanita_warna_kulit_sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FB": {
        "en": "kiss_woman_woman_medium-dark_skin_tone_light_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "berciuman_wanita_warna_kulit_gelap-sedang_cerah_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FC": {
        "en": "kiss_woman_woman_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "berciuman_wanita_warna_kulit_gelap-sedang_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FD": {
        "en": "kiss_woman_woman_medium-dark_skin_tone_medium_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "berciuman_wanita_warna_kulit_gelap-sedang_sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FE": {
        "en": "kiss_woman_woman_medium-dark_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_gelap-sedang",
        "alias": "berciuman_wanita_warna_kulit_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FF": {
        "en": "kiss_woman_woman_medium-dark_skin_tone_dark_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "berciuman_wanita_warna_kulit_gelap-sedang_gelap_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FB": {
        "en": "kiss_woman_woman_dark_skin_tone_light_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "berciuman_wanita_warna_kulit_gelap_cerah_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FC": {
        "en": "kiss_woman_woman_dark_skin_tone_medium-light_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "berciuman_wanita_warna_kulit_gelap_cerah-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FD": {
        "en": "kiss_woman_woman_dark_skin_tone_medium_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "berciuman_wanita_warna_kulit_gelap_sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FE": {
        "en": "kiss_woman_woman_dark_skin_tone_medium-dark_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "berciuman_wanita_warna_kulit_gelap_gelap-sedang_cium_pasangan_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469\U0001F3FF": {
        "en": "kiss_woman_woman_dark_skin_tone",
        "id": "berciuman_wanita_wanita_warna_kulit_gelap",
        "alias": "berciuman_wanita_warna_kulit_gelap_cium_pasangan_romantis",
    },
    "\U0001f491\U0001f3fb": {
        "en": "couple_with_heart_light_skin_tone",
        "id": "pasangan_dengan_hati_warna_kulit_cerah",
    },
    "\U0001f491\U0001f3fc": {
        "en": "couple_with_heart_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_warna_kulit_cerah-sedang",
    },
    "\U0001f491\U0001f3fd": {
        "en": "couple_with_heart_medium_skin_tone",
        "id": "pasangan_dengan_hati_warna_kulit_sedang",
    },
    "\U0001f491\U0001f3fe": {
        "en": "couple_with_heart_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_warna_kulit_gelap-sedang",
    },
    "\U0001f491\U0001f3ff": {
        "en": "couple_with_heart_dark_skin_tone",
        "id": "pasangan_dengan_hati_warna_kulit_gelap",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "couple_with_heart_person_person_light_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_cerah_cerah-sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "couple_with_heart_person_person_light_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_cerah_sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "couple_with_heart_person_person_light_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_cerah_gelap-sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "couple_with_heart_person_person_light_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_cerah_gelap_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "couple_with_heart_person_person_medium-light_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_cerah-sedang_cerah_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "couple_with_heart_person_person_medium-light_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_cerah-sedang_sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "couple_with_heart_person_person_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_cerah-sedang_gelap-sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "couple_with_heart_person_person_medium-light_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_cerah-sedang_gelap_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "couple_with_heart_person_person_medium_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_sedang_cerah_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "couple_with_heart_person_person_medium_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_sedang_cerah-sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "couple_with_heart_person_person_medium_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_sedang_gelap-sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "couple_with_heart_person_person_medium_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_sedang_gelap_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "couple_with_heart_person_person_medium-dark_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_gelap-sedang_cerah_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "couple_with_heart_person_person_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_gelap-sedang_cerah-sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "couple_with_heart_person_person_medium-dark_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_gelap-sedang_sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FF": {
        "en": "couple_with_heart_person_person_medium-dark_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_gelap-sedang_gelap_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FB": {
        "en": "couple_with_heart_person_person_dark_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_gelap_cerah_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FC": {
        "en": "couple_with_heart_person_person_dark_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_gelap_cerah-sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FD": {
        "en": "couple_with_heart_person_person_dark_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_gelap_sedang_cinta_romantis",
    },
    "\U0001F9D1\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F9D1\U0001F3FE": {
        "en": "couple_with_heart_person_person_dark_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_dewasa_dewasa_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_dewasa_warna_kulit_gelap_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FB": {
        "en": "couple_with_heart_woman_man_light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah_cinta_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FC": {
        "en": "couple_with_heart_woman_man_light_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah_cerah-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FD": {
        "en": "couple_with_heart_woman_man_light_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah_sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FE": {
        "en": "couple_with_heart_woman_man_light_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FF": {
        "en": "couple_with_heart_woman_man_light_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah_gelap_cinta_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FB": {
        "en": "couple_with_heart_woman_man_medium-light_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah-sedang_cerah_cinta_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FC": {
        "en": "couple_with_heart_woman_man_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FD": {
        "en": "couple_with_heart_woman_man_medium-light_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah-sedang_sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FE": {
        "en": "couple_with_heart_woman_man_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah-sedang_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FF": {
        "en": "couple_with_heart_woman_man_medium-light_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_cerah-sedang_gelap_cinta_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FB": {
        "en": "couple_with_heart_woman_man_medium_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_sedang_cerah_cinta_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FC": {
        "en": "couple_with_heart_woman_man_medium_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_sedang_cerah-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FD": {
        "en": "couple_with_heart_woman_man_medium_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FE": {
        "en": "couple_with_heart_woman_man_medium_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_sedang_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FF": {
        "en": "couple_with_heart_woman_man_medium_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_sedang_gelap_cinta_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FB": {
        "en": "couple_with_heart_woman_man_medium-dark_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap-sedang_cerah_cinta_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FC": {
        "en": "couple_with_heart_woman_man_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap-sedang_cerah-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FD": {
        "en": "couple_with_heart_woman_man_medium-dark_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap-sedang_sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FE": {
        "en": "couple_with_heart_woman_man_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FF": {
        "en": "couple_with_heart_woman_man_medium-dark_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap-sedang_gelap_cinta_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FB": {
        "en": "couple_with_heart_woman_man_dark_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap_cerah_cinta_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FC": {
        "en": "couple_with_heart_woman_man_dark_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap_cerah-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FD": {
        "en": "couple_with_heart_woman_man_dark_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap_sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FE": {
        "en": "couple_with_heart_woman_man_dark_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FF": {
        "en": "couple_with_heart_woman_man_dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_wanita_pria_warna_kulit_gelap_cinta_romantis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FB": {
        "en": "couple_with_heart_man_man_light_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_cerah_cinta_romantis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FC": {
        "en": "couple_with_heart_man_man_light_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_cerah_cerah-sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FD": {
        "en": "couple_with_heart_man_man_light_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_cerah_sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FE": {
        "en": "couple_with_heart_man_man_light_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_cerah_gelap-sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FF": {
        "en": "couple_with_heart_man_man_light_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_cerah_gelap_cinta_romantis",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FB": {
        "en": "couple_with_heart_man_man_medium-light_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_cerah-sedang_cerah_cinta_romantis",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FC": {
        "en": "couple_with_heart_man_man_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_cerah-sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FD": {
        "en": "couple_with_heart_man_man_medium-light_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_cerah-sedang_sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FE": {
        "en": "couple_with_heart_man_man_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_cerah-sedang_gelap-sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FF": {
        "en": "couple_with_heart_man_man_medium-light_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_cerah-sedang_gelap_cinta_romantis",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FB": {
        "en": "couple_with_heart_man_man_medium_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_sedang_cerah_cinta_romantis",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FC": {
        "en": "couple_with_heart_man_man_medium_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_sedang_cerah-sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FD": {
        "en": "couple_with_heart_man_man_medium_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FE": {
        "en": "couple_with_heart_man_man_medium_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_sedang_gelap-sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FF": {
        "en": "couple_with_heart_man_man_medium_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_sedang_gelap_cinta_romantis",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FB": {
        "en": "couple_with_heart_man_man_medium-dark_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_gelap-sedang_cerah_cinta_romantis",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FC": {
        "en": "couple_with_heart_man_man_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_gelap-sedang_cerah-sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FD": {
        "en": "couple_with_heart_man_man_medium-dark_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_gelap-sedang_sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FE": {
        "en": "couple_with_heart_man_man_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_gelap-sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FF": {
        "en": "couple_with_heart_man_man_medium-dark_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_gelap-sedang_gelap_cinta_romantis",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FB": {
        "en": "couple_with_heart_man_man_dark_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_gelap_cerah_cinta_romantis",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FC": {
        "en": "couple_with_heart_man_man_dark_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_gelap_cerah-sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FD": {
        "en": "couple_with_heart_man_man_dark_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_gelap_sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FE": {
        "en": "couple_with_heart_man_man_dark_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_gelap_gelap-sedang_cinta_romantis",
    },
    "\U0001F468\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468\U0001F3FF": {
        "en": "couple_with_heart_man_man_dark_skin_tone",
        "id": "pasangan_dengan_hati_pria_pria_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_pria_warna_kulit_gelap_cinta_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FB": {
        "en": "couple_with_heart_woman_woman_light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_cerah_cinta_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FC": {
        "en": "couple_with_heart_woman_woman_light_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_cerah_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_cerah_cerah-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FD": {
        "en": "couple_with_heart_woman_woman_light_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_cerah_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_cerah_sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FE": {
        "en": "couple_with_heart_woman_woman_light_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_cerah_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_cerah_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FB\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FF": {
        "en": "couple_with_heart_woman_woman_light_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_cerah_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_cerah_gelap_cinta_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FB": {
        "en": "couple_with_heart_woman_woman_medium-light_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_cerah-sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_cerah-sedang_cerah_cinta_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FC": {
        "en": "couple_with_heart_woman_woman_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_cerah-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FD": {
        "en": "couple_with_heart_woman_woman_medium-light_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_cerah-sedang_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_cerah-sedang_sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FE": {
        "en": "couple_with_heart_woman_woman_medium-light_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_cerah-sedang_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_cerah-sedang_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FC\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FF": {
        "en": "couple_with_heart_woman_woman_medium-light_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_cerah-sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_cerah-sedang_gelap_cinta_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FB": {
        "en": "couple_with_heart_woman_woman_medium_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_sedang_cerah_cinta_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FC": {
        "en": "couple_with_heart_woman_woman_medium_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_sedang_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_sedang_cerah-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FD": {
        "en": "couple_with_heart_woman_woman_medium_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FE": {
        "en": "couple_with_heart_woman_woman_medium_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_sedang_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_sedang_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FD\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FF": {
        "en": "couple_with_heart_woman_woman_medium_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_sedang_gelap_cinta_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FB": {
        "en": "couple_with_heart_woman_woman_medium-dark_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_gelap-sedang_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_gelap-sedang_cerah_cinta_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FC": {
        "en": "couple_with_heart_woman_woman_medium-dark_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_gelap-sedang_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_gelap-sedang_cerah-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FD": {
        "en": "couple_with_heart_woman_woman_medium-dark_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_gelap-sedang_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_gelap-sedang_sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FE": {
        "en": "couple_with_heart_woman_woman_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FE\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FF": {
        "en": "couple_with_heart_woman_woman_medium-dark_skin_tone_dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_gelap-sedang_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_gelap-sedang_gelap_cinta_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FB": {
        "en": "couple_with_heart_woman_woman_dark_skin_tone_light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_gelap_warna_kulit_cerah",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_gelap_cerah_cinta_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FC": {
        "en": "couple_with_heart_woman_woman_dark_skin_tone_medium-light_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_gelap_warna_kulit_cerah-sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_gelap_cerah-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FD": {
        "en": "couple_with_heart_woman_woman_dark_skin_tone_medium_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_gelap_warna_kulit_sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_gelap_sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FE": {
        "en": "couple_with_heart_woman_woman_dark_skin_tone_medium-dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_gelap_warna_kulit_gelap-sedang",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_gelap_gelap-sedang_cinta_romantis",
    },
    "\U0001F469\U0001F3FF\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469\U0001F3FF": {
        "en": "couple_with_heart_woman_woman_dark_skin_tone",
        "id": "pasangan_dengan_hati_wanita_wanita_warna_kulit_gelap",
        "alias": "pasangan_dengan_hati_wanita_warna_kulit_gelap_cinta_romantis",
    },
    "\U0001F3FB": {
        "en": "light_skin_tone",
        "id": "warna_kulit_cerah",
        "alias": "warna_kulit_cerah_tipe_12",
    },
    "\U0001F3FC": {
        "en": "medium-light_skin_tone",
        "id": "warna_kulit_cerah-sedang",
        "alias": "warna_kulit_cerah-sedang_tipe_3",
    },
    "\U0001F3FD": {
        "en": "medium_skin_tone",
        "id": "warna_kulit_sedang",
        "alias": "warna_kulit_sedang_tipe_4",
    },
    "\U0001F3FE": {
        "en": "medium-dark_skin_tone",
        "id": "warna_kulit_gelap-sedang",
        "alias": "warna_kulit_gelap-sedang_tipe_5_wana",
    },
    "\U0001F3FF": {
        "en": "dark_skin_tone",
        "id": "warna_kulit_gelap",
        "alias": "warna_kulit_gelap_tipe_6",
    },
}
