"""Data containing Indonesian slang words
   based on: Kamus Alay - Colloquial Indonesian Lexicon by Salsabila, Ali, Yosef, and Ade
   https://github.com/nasalsabila/kamus-alay
"""

__all__ = ["SLANG_DATA"]

SLANG_DATA = {
    "woww": "wow",
    "aminn": "amin",
    "met": "selamat",
    "netaas": "menetas",
    "keberpa": "keberapa",
    "eeeehhhh": "eh",
    "kata2nyaaa": "kata-katanya",
    "hallo": "halo",
    "kaka": "kakak",
    "ka": "kak",
    "daah": "dah",
    "aaaaahhhh": "ah",
    "yaa": "ya",
    "smga": "semoga",
    "slalu": "selalu",
    "amiin": "amin",
    "kk": "kakak",
    "trus": "terus",
    "sii": "sih",
    "nyenengin": "menyenangkan",
    "bgt": "banget",
    "gemess": "gemas",
    "akuuu": "aku",
    "jgn": "jangan",
    "udah": "sudah",
    "gitu": "begitu",
    "aja": "saja",
    "gemesiin": "menggemaskan",
    "menyenangkn": "menyenangkan",
    "rb": "ribu",
    "akau": "aku",
    "saranin": "menyarankan",
    "nemuin": "menemukan",
    "yah": "ya",
    "mnis2nya": "manis-manisnya",
    "gtu": "begitu",
    "tu": "itu",
    "idolaa": "idola",
    "bangett": "banget",
    "kaakk": "kak",
    "baaiikkk": "baik",
    "telaatt": "telat",
    "kaak": "kak",
    "yg": "yang",
    "lg": "lagi",
    "skarang": "sekarang",
    "sempet": "sempat",
    "karna": "karena",
    "ngga": "enggak",
    "mantep": "mantap",
    "loohhh": "loh",
    "yeee": "ya",
    "baguuuuus": "bagus",
    "sampe": "sampai",
    "ngikutin": "mengikuti",
    "gayany": "gayanya",
    "bnk": "bang",
    "awaas": "awas",
    "siip": "sip",
    "abizzzz": "habis",
    "kerrrrennnn": "keren",
    "sayaa": "saya",
    "pengen": "pengin",
    "kpan": "kapan",
    "sma": "sama",
    "sdkit": "sedikit",
    "bngt": "banget",
    "lgu": "lagu",
    "bener2": "benar-benar",
    "kharismanya": "karismanya",
    "aq": "aku",
    "jdi": "jadi",
    "lgi": "lagi",
    "gk": "enggak",
    "kek": "kayak",
    "lgunya": "lagunya",
    "kereeeeennnn": "keren",
    "nyamain": "menyamakan",
    "lakik": "laki",
    "siippp": "sip",
    "bkn": "bukan",
    "nyangka": "menyangka",
    "bangettt": "banget",
    "kereeen": "keren",
    "wihhhhhh": "wih",
    "tp": "tapi",
    "inget": "ingat",
    "bingitsss": "banget",
    "dmn": "dimana",
    "bird": "biru",
    "kaloo": "kalo",
    "gimna": "bagaimana",
    "tuuh": "tuh",
    "nyebur": "mencebur",
    "yng": "yang",
    "dbuat": "dibuat",
    "kn": "kan",
    "org": "orang",
    "pingin": "pengin",
    "bangcat": "bangsat",
    "yha": "ya",
    "waoohhh": "wah",
    "pngn": "pengin",
    "tmpt": "tempat",
    "dhe": "deh",
    "indahhh": "indah",
    "bgttt": "banget",
    "tuhh": "tuh",
    "berarto": "berarti",
    "ga": "enggak",
    "aamiin": "amin",
    "amiiinn": "amin",
    "dgn": "dengan",
    "aminnnn2": "amin-amin",
    "amiiiin": "amin",
    "aminnn": "amin",
    "amiend": "amien",
    "yaaa": "ya",
    "ameen": "amin",
    "aminnnn": "amin",
    "amiiinnn": "amin",
    "ngomong": "mengomong",
    "mamer": "memamerkan",
    "keles": "kali",
    "jelase": "jelas",
    "liat": "lihat",
    "uwakk": "uwak",
    "ntar": "entar",
    "bs": "bisa",
    "gini": "begini",
    "salfok": "salah fokus",
    "njir": "anjir",
    "piiink": "pink",
    "astgfrullah": "astagfirullah",
    "ko": "kok",
    "cd": "celana dalam",
    "gbs": "enggak bisa",
    "bhs": "bahasa",
    "yaaaaaa": "ya",
    "gak": "enggak",
    "bangshad": "bangsat",
    "stagahhhh": "astaga",
    "kpn": "kapan",
    "iooo": "lo",
    "dy": "dia",
    "d": "di",
    "mslh": "masalah",
    "qt": "kita",
    "plampiasannn": "pelampiasan",
    "masalahh": "masalah",
    "tohh": "toh",
    "inghinn": "ingin",
    "dhi": "di",
    "mengherthii": "mengerti",
    "yanckh": "yang",
    "chelalyyu": "selalu",
    "therchakitty": "tersakiti",
    "mauuuuu": "mau",
    "kaliii": "kali",
    "bangat": "banget",
    "bkin": "bikin",
    "dongg": "dong",
    "yokkk": "yuk",
    "yu": "yuk",
    "sweger": "segar",
    "gantengg": "ganteng",
    "bingiit": "banget",
    "kebukaaa": "terbuka",
    "tpi": "tapi",
    "keliatan": "kelihatan",
    "yakk": "ya",
    "kayakk": "kayak",
    "asliii": "asli",
    "kyk": "kayak",
    "cntiknya": "cantiknya",
    "bat": "banget",
    "ngeliatnya": "melihatnya",
    "sll": "selalu",
    "bet": "banget",
    "njerr": "anjir",
    "bingiiittttzzzz": "banget",
    "k": "ke",
    "klo": "kalo",
    "dooong": "dong",
    "masi": "masih",
    "gni": "begini",
    "hdk": "hendak",
    "jugaa": "juga",
    "mksud": "maksud",
    "aj": "saja",
    "tetep": "tetap",
    "mbakx": "mbaknya",
    "syantik": "cantik",
    "kite": "kita",
    "pa": "apa",
    "mksd": "maksud",
    "bejilbbnya": "berjilbabnya",
    "masio": "masih",
    "yahhh": "ya",
    "makasih": "terima kasih",
    "leh": "boleh",
    "ugaaa": "juga",
    "jerewi": "jerawat",
    "ilang": "hilang",
    "jilbabnyaah": "jilbabnya",
    "yuuuk": "yuk",
    "warnaaa": "warna",
    "punyaaa": "punya",
    "cantiik": "cantik",
    "sukaaak": "suka",
    "kebayanyaa": "kebayanya",
    "mantes": "memantas",
    "merekaaaa": "mereka",
    "jugaaa": "juga",
    "gilaaaa": "gila",
    "tiga2nya": "tiga-tiganya",
    "lucuu": "lucu",
    "emessss": "gemas",
    "ucullllll": "lucu",
    "males": "malas",
    "bangeettt": "banget",
    "gemesshh": "gemas",
    "apaaa": "apa",
    "ampuunn": "ampun",
    "ciuuuummmm": "cium",
    "mbil": "sambil",
    "ngmng": "mengomong",
    "ngemeng": "mengomong",
    "epe": "apa",
    "seehh": "sih",
    "yank": "sayang",
    "ucul": "lucu",
    "yahh": "ya",
    "gw": "gue",
    "ngakak": "mengakak",
    "astagfirrullah": "astagfirullah",
    "suerrr": "suer",
    "mnta": "minta",
    "syg": "sayang",
    "ntik": "cantik",
    "pny": "punya",
    "dapet": "dapat",
    "suru": "suruh",
    "lucuuuu": "lucu",
    "ketawakkkk": "ketawa",
    "kyanya": "kayanya",
    "bnget": "banget",
    "nakutin": "menakutkan",
    "malingg": "maling",
    "cocokk": "cocok",
    "niihh": "nih",
    "imutttttt": "imut",
    "satuuuuu": "satu",
    "sesekk": "sesak",
    "nafass": "nafas",
    "bgtt": "banget",
    "cintaaaaaaa": "cinta",
    "lucuk": "lucu",
    "ma": "sama",
    "duluu": "dulu",
    "megang": "memegang",
    "kawinin": "mengawini",
    "liatin": "perlihatkan",
    "ny": "nya",
    "bdan": "badan",
    "nyaaa": "nya",
    "gemesin": "menggemaskan",
    "fotoin": "memfoto",
    "ngaku": "mengaku",
    "kaaa": "kak",
    "ganteng2": "ganteng-ganteng",
    "pcarny": "pacarnya",
    "kri": "kiri",
    "knpa": "kenapa",
    "pda": "pada",
    "cmn": "cuman",
    "gara2": "gara-gara",
    "garuk2": "garuk-garuk",
    "tembokk": "tembok",
    "namax": "namanya",
    "kiriii": "kiri",
    "bungkusin": "bungkuskan",
    "atu": "satu",
    "dehhhh": "deh",
    "kakk": "kak",
    "ngegantiin": "menggantikan",
    "alloh": "allah",
    "smpe": "sampai",
    "msh": "masih",
    "trsa": "terasa",
    "khadirannya": "kehadirannya",
    "fikiran": "pikiran",
    "hayalanku": "khayalanku",
    "bru": "baru",
    "nton": "menonton",
    "ngapain": "mengapai",
    "surgaa": "surga",
    "kangenn": "kangen",
    "kgn": "kangen",
    "kakkkkk": "kak",
    "rinduuuuuuuuu": "rindu",
    "ninggalin": "meninggalkan",
    "smg": "semoga",
    "terangkhn": "terangkan",
    "bgtttt": "banget",
    "knp": "kenapa",
    "tuk": "untuk",
    "slama": "selama",
    "orng": "orang",
    "bngunlah": "bangunlah",
    "bngun": "bangun",
    "ea": "ya",
    "qu": "ku",
    "hiri": "hari",
    'teman"ny': "teman-temannya",
    "aza": "saja",
    "dr": "dari",
    "alm": "almarhum",
    "skrg": "sekarang",
    "sie": "sih",
    "benet": "benar",
    "bangetttt": "banget",
    "tuu": "tuh",
    "skrang": "sekarang",
    "gda": "enggak ada",
    "gantiin": "menggantikan",
    "kta": "kita",
    "kklau": "kalau",
    "acra": "acara",
    "kasian": "kasihan",
    "yaaa ": "ya",
    "bnerr": "benar",
    "emk": "emak",
    "temenn": "teman",
    "pngenn": "pengin",
    "terkenall": "terkenal",
    "ajhh": "saja",
    "sungguh2": "sungguh-sungguh",
    "mnjadi": "menjadi",
    "shbt": "sahabat",
    "bner": "benar",
    "ktny": "katanya",
    "dimusiumin": "dimuseumkan",
    "bntu": "bantu",
    "dlu": "dulu",
    "udh": "sudah",
    "kangem": "kangen",
    "amiiin": "amin",
    "smua": "semua",
    "slmt": "selamat",
    "jln": "jalan",
    'mudh"an': "mudah-mudahan",
    "tenny": "tenang",
    "sdh": "sudah",
    "tnya": "tanya",
    "blm": "belum",
    "td": "tadi",
    "sblm": "sebelum",
    "bole": "boleh",
    "lahhh": "lah",
    "maap": "maaf",
    "cm": "cuma",
    "kmrn": "kemarin",
    "wkt": "waktu",
    "ama": "sama",
    "ak": "aku",
    "lht": "lihat",
    "biasa2": "biasa-biasa",
    "mnrtkuu": "menurutku",
    "trs": "terus",
    "ikutin": "mengikuti",
    "jdwl": "jadwal",
    "wajiiib": "wajib",
    "aaaammmiiiinnnn": "amin",
    "dtnggu": "ditunggu",
    "jan": "jangan",
    "kunjungin": "kunjungi",
    "lagiiii": "lagi",
    "waktunyaaa": "waktunya",
    "diluangin": "diluangkan",
    "jga": "juga",
    "mimin": "admin",
    "istimewaaa": "istimewa",
    "blom": "belum",
    "nangis": "menangis",
    'ngaku"': "mengaku-ngaku",
    "diaa": "dia",
    "donkk": "dong",
    "kejawab": "terjawab",
    "yaaaa": "ya",
    "seru2an": "seru-seruan",
    "mohom": "mohon",
    "kebalas": "terbalas",
    "nyempetin": "menyempatkan",
    "wktunya": "waktunya",
    "kaaaa": "kak",
    "ngobrol": "mengobrol",
    "namain": "namai",
    "bls": "balas",
    "ijap": "ijab",
    "kobul": "kabul",
    "co": "cowok",
    "pst": "pasti",
    "inggat": "ingat",
    "brdua": "berdua",
    "masing2": "masing-masing",
    "sanggat": "sangat",
    "siipp": "sip",
    "laa": "lah",
    "dlm": "dalam",
    "hdup": "hidup",
    "hdp": "hidup",
    "kedpan": "kedepan",
    "smoga": "semoga",
    "mndaptkan": "mendapatkan",
    'nutup"in': "menutup-nutupi",
    "iyah": "iya",
    "sja": "saja",
    "kakkk": "kak",
    "za": "saja",
    "mulut2": "mulut-mulut",
    "peengn": "pengin",
    "tuch": "tuh",
    "muantteepp": "mantap",
    "cpt": "cepat",
    "mrit": "merit",
    "y": "ya",
    "ngapasih": "mengapa sih",
    "ni": "nih",
    "segitunya": "sebegitunya",
    "fto": "foto",
    "pke": "pakai",
    "sisain": "menyisakan",
    "slamt": "selamat",
    "nantiii": "nanti",
    "edaaan": "edan",
    "emg": "memang",
    "tunggu2": "tunggu-tunggu",
    "sehat2": "sehat-sehat",
    "ciyeeeeeee": "cie",
    "pantes": "pantas",
    "lairannya": "kelahirannya",
    "jmnya": "jamnya",
    "ajha": "saja",
    "nyaaaa": "nya",
    "nyari": "mencari",
    "amiien": "amien",
    "terbaikkk": "terbaik",
    "ayahh": "ayah",
    "ae": "saja",
    "ndak": "indak",
    "ngerti": "mengerti",
    "mrekaaaa": "mereka",
    "yaampuuuunnnn": "ya ampun",
    "nyanyiin": "menyanyikan",
    "ahhh": "ah",
    "pgen": "pengin",
    "tempt": "tempat",
    "kh": "kah",
    "bgini": "begini",
    "brani": "berani",
    "km": "kamu",
    "jalan2": "jalan-jalan",
    "asyikkkkk": "asyik",
    "iriiiii": "iri",
    "ngajak": "mengajak",
    "naaaaahh": "nah",
    "kka": "kakak",
    "yak": "ya",
    "ttep": "tetap",
    "sperti": "seperti",
    "jrang": "jarang",
    "msuk": "masuk",
    "gossip2.an": "gosip-gosipan",
    "makkk": "mak",
    "guee": "gue",
    "pengennn": "pengin",
    "gilzz": "gila",
    "nyaru": "menyaru",
    "gilaaa": "gila",
    "jd": "jadi",
    "kebarat2an": "kebarat-baratan",
    "ohh": "oh",
    "mantabs": "mantab",
    "jgan": "jangan",
    "mlu": "melulu",
    "payahh": "payah",
    "ntaf": "mantap",
    "beneran": "benaran",
    'mudah"n': "mudah-mudahan",
    "gada": "enggak ada",
    "milikin": "memiliki",
    "kamo": "kamu",
    "inih": "ini",
    "sukaaaa": "suka",
    "sukaaaaaa": "suka",
    "kirain": "mengira",
    "mehoonggggg": "mahal",
    "apikkkk": "apik",
    "yach": "ya",
    "kereenn": "keren",
    "ginii": "begini",
    "ayoook": "ayo",
    "yoiii": "yoi",
    "gituuu": "begitu",
    "iyaaa": "iya",
    "pgn": "pengin",
    "liptsk": "lipstik",
    "nyeplak": "menjiplak",
    "cw": "cewek",
    "kmarin": "kemarin",
    "mengncang": "mengencang",
    "tauu": "tau",
    "ksh": "kasih",
    "skrng": "sekarang",
    "mksh": "terima kasih",
    "ank": "anak",
    "skitar": "sekitar",
    "ktmu": "ketemu",
    "tmen": "teman",
    "ats": "atas",
    "donk": "dong",
    "heii": "hai",
    "diputusin": "diputuskan",
    "pcrnya": "pacarnya",
    "mnjual": "menjual",
    "ngadain": "mengadakan",
    "kkak": "kakak",
    "rekomendasiin": "rekomendasikan",
    "sihhh": "sih",
    "cooocok": "cocok",
    "mrip": "mirip",
    "mama.nyy": "mamanya",
    "bosenin": "membosankan",
    "kmu": "kamu",
    "bukn": "bukan",
    "sey": "sih",
    "cantikkk": "cantik",
    "banger": "banget",
    "kaa": "kak",
    "eakyu": "waktu",
    "cntik": "cantik",
    "kakanya": "kakaknya",
    "doeloe": "dulu",
    "cantikkkk": "cantik",
    "bngtt": "banget",
    "iyak": "iya",
    "malh": "malah",
    "mlah": "malah",
    "ngak": "enggak",
    "laki2": "laki-laki",
    "gag": "enggak",
    "fhotonya": "fotonya",
    "bleh": "boleh",
    "brp": "berapa",
    "tnggl": "tanggal",
    "tanteny": "tantenya",
    "ky": "kaya",
    "sklinyaa": "sekalinya",
    "ayoo": "ayo",
    "w": "gue",
    "dramaa": "drama",
    "niiih": "nih",
    "bisaa": "bisa",
    "lha": "lah",
    "dunk": "dong",
    "lihaat": "lihat",
    "yuwkkk": "yuk",
    "nnti": "nanti",
    "editannn": "editan",
    "mw": "mau",
    "thu": "itu",
    "mai": "mau",
    "kamuu": "kamu",
    "pastii": "pasti",
    "bisaaa": "bisa",
    "kejuu": "keju",
    "kereen": "keren",
    "nama.a": "namanya",
    "kmauan": "kemauan",
    "ahhhh": "ah",
    "yuuuuk": "yuk",
    "dmana": "dimana",
    "disiniii": "disini",
    "cobaa": "coba",
    "bayangin": "bayangkan",
    "yaudh": "ya sudah",
    "dl": "dulu",
    "ajaaa": "saja",
    "tuhhh": "tuh",
    "amploppp": "amplop",
    "mo": "mau",
    "sayangg''": "sayang-sayang",
    "nantii": "nanti",
    "aminnnnn": "amin",
    "gakuat": "enggak kuat",
    "yukkkk": "yuk",
    "nged": "banget",
    "nantik": "nanti",
    "ksitu": "kesitu",
    "bangeett": "banget",
    "liad": "lihat",
    "kluarga": "keluarga",
    "biasahhh": "biasa",
    "tutorialx": "tutorialnya",
    "dpke": "dipakai",
    "fhoto": "foto",
    "kerenn": "keren",
    "binggo": "banget",
    "rekomndd": "rekomendasi",
    "bli2n": "beli-belikan",
    "bwt": "buat",
    "wado": "waduh",
    "guaa": "gua",
    "yaakkk": "ya",
    "bangetttttyt": "banget",
    "bangettttt": "banget",
    "bangg": "bang",
    "kangeeeeeeeeennnnnnnn": "kangen",
    "kaliannnnnn": "kalian",
    "rinduuuuuuuuuu": "rindu",
    "kangennnnnmnnnnnnnnnnnnnnnnn": "kangen",
    "kaliannnnnm": "kalian",
    "kangeeeeeeeeeeennnnn": "kangen",
    "kangennnnnnnnnnnnnnnn": "kangen",
    "kangennn": "kangen",
    "kaliannnnnnn": "kalian",
    "th2": "tahun-tahun",
    "smpt": "sempat",
    "blg": "bilang",
    "trserah": "terserah",
    "ad": "ada",
    "cwo": "cowok",
    "prnah": "pernah",
    "wlwpun": "walaupun",
    "trpsah": "terpisah",
    "klw": "kalau",
    "mmg": "memang",
    "prsatukn": "persatukan",
    "g": "enggak",
    "slh": "salah",
    "ngomng": "mengomong",
    "mdh2an": "mudah-mudahan",
    "sm": "sama",
    "skedar": "sekadar",
    "kangeeerrn": "kangen",
    "pulak": "pula",
    "terrrrbaik": "terbaik",
    "jorookknya": "joroknya",
    "ihhhhh": "ih",
    "padahall": "padahal",
    "jorokkkk": "jorok",
    "mualll": "mual",
    "klow": "kalau",
    "muke": "muka",
    "ajh": "saja",
    "taiiii": "tahi",
    "seneeeeeng": "senang",
    "nyesel": "menyesal",
    "besarin": "membesarkan",
    "tanyang": "tayang",
    "ber2": "berdua",
    "jngan": "jangan",
    "ngelarang": "melarang",
    "kerreeen": "keren",
    "pantess": "pantas",
    "bngettt": "banget",
    "baperr": "bawa perasaan",
    "sudh": "sudah",
    "sbr": "sabar",
    "pngen": "pengin",
    "nntn": "menonton",
    "ht": "hati",
    "pemainy": "pemainnya",
    "jg": "juga",
    "aqu": "aku",
    "ngeliat": "melihat",
    "baper": "bawa perasaan",
    "akn": "akan",
    "nyampe": "sampai",
    "kbawa": "terbawa",
    "bradegan": "beradegan",
    "amiiinnnn": "amin",
    "mlm": "malam",
    "nikahin": "menikahi",
    "hadeuh": "aduh",
    "nyambung": "menyambung",
    "liyat": "lihat",
    "krn": "karena",
    "sk": "suka",
    "adengan": "adegan",
    "engga": "enggak",
    "bingit": "banget",
    "dapetin": "mendapatkan",
    "model2": "model-model",
    "sitayngin": "ditayangkan",
    "cocokkk": "cocok",
    "mahhhh": "mah",
    "cocokny": "cocoknya",
    "iniw": "ini",
    "q": "ku",
    "setju": "setuju",
    "bnern": "benaran",
    "pcrn": "pacaran",
    "klian": "kalian",
    "cocokkkk": "cocok",
    "bngett": "banget",
    "abes": "habis",
    "br": "baru",
    "mksdny": "maksudnya",
    "brpa": "berapa",
    "ihh": "ih",
    "kesampean": "kesampaian",
    "beginiiii": "begini",
    "ntr": "entar",
    "beliin": "belikan",
    "kya": "kaya",
    "keq": "kayak",
    "ngerasa": "merasa",
    "sygkuu": "sayangku",
    "ngeselin": "mengesalkan",
    "baju'a": "bajunya",
    "gara''": "gara-gara",
    "teruss": "terus",
    "pokok'a": "pokoknya",
    "bg": "bang",
    "ubur2": "ubur-ubur",
    "kuyy": "yuk",
    "bentarr": "bentar",
    "dureen": "duren",
    "ajibb": "ajib",
    "mahall": "mahal",
    "yukk": "yuk",
    "niiihh": "nih",
    "imuuttt": "imut",
    "imuttzz": "imut",
    "nha": "nya",
    "konten2": "konten-konten",
    "rasain": "merasai",
    "daaaah": "deh",
    "asliiii": "asli",
    "cantiknnnnyaaaaaaa": "cantiknya",
    "yuuk": "yuk",
    "ngelihatnya": "melihatnya",
    "bdn": "badan",
    "na": "nya",
    "ibu2": "ibu-ibu",
    "lau": "kau",
    "cantikk": "cantik",
    "sexxi": "seksi",
    "bulet": "bulat",
    "ituu": "itu",
    "ngocok": "mengocok",
    "nyoba": "mencoba",
    "gn": "begini",
    "yaahhh": "ya",
    "kencqng": "kencang",
    "kra": "kira",
    "diginikan": "dibeginikan",
    'coret"': "coret-coret",
    "lahh": "lah",
    "gambarin": "gambarkan",
    "ngerii": "ngeri",
    "digambarin": "digambarkan",
    "klen": "kalian",
    "bangke": "bangkai",
    "kog": "kok",
    "liatnya": "lihatnya",
    "bedanyaaa": "bedanya",
    "negri": "negeri",
    "mbk": "mbak",
    "pgin": "pengin",
    "krudungan": "kerudungan",
    "ajaa": "saja",
    "maksutku": "maksudku",
    "kerennnnn": "keren",
    "njirr": "anjir",
    "jd'y": "jadinya",
    "manisnyaaaa": "manisnya",
    "thun": "tahun",
    "mbg": "mbak",
    "bangeet": "banget",
    "ngaco": "mengaco",
    "ngomen": "mengomentari",
    "kaaakk": "kak",
    "gituh": "begitu",
    "tenggah": "tengah",
    "uuuuuaaaaaaaaaappppppppppiiiiiiiiiiiiiiiiiikkkkkkkkkkkkkkkk": "apik",
    "kocakkkkkkkkkkkkkk": "kocak",
    "ksukaanmuuu": "kesukaanmu",
    "bagiii": "bagi",
    "ayooo": "ayo",
    "nontonx": "menontonnya",
    "dpn": "depan",
    "pi": "tapi",
    "penasarannnn": "penasaran",
    "gilakkkkkk": "gila",
    "mauuu": "mau",
    "nontoonnn": "menonton",
    "cepet2": "cepat-cepat",
    "kepingin": "pengin",
    "nontonnnn": "menonton",
    "deeek": "dek",
    "ntappp": "mantap",
    "deg2an": "deg-degan",
    "cyiiin": "cinta",
    "iyha": "iya",
    "kureeeen": "keren",
    "muantaap": "mantap",
    "pake": "pakai",
    "ngantri": "mengantri",
    "bli": "beli",
    "nraktir": "mentraktir",
    "nonton": "menonton",
    "sbnyak": "sebanyak",
    "penasaraaann": "penasaran",
    "ayoooo": "ayo",
    "nii": "ini",
    "nontonya": "menontonnya",
    "kl": "kalo",
    "nunggu": "menunggu",
    "dpt": "dapat",
    "qta": "kita",
    "peen": "pengin",
    "lw": "kalau",
    "gga": "enggak",
    "yaah": "ya",
    "asikkk": "asik",
    "gilak": "gila",
    "mcm": "macam",
    "ceritax": "ceritanya",
    "yoooiii": "yoi",
    "kuy": "yuk",
    "udahh": "sudah",
    "tauuuuu": "tau",
    "sabarrrrr": "sabar",
    "kqmu": "kamu",
    "banggain": "banggakan",
    "thn": "tahun",
    "pengan": "pengin",
    "sendeng": "senang",
    "simpen": "simpan",
    "gakk": "enggak",
    "bagiin": "membagikan",
    "nanggepin": "menanggapi",
    "kapn": "kapan",
    "barang2": "barang-barang",
    "kirimin": "mengirimi",
    "senengin": "senangi",
    "ngasih": "mengasih",
    "ampunnnn": "ampun",
    "bln": "bulan",
    "senengg": "senang",
    "teruzzz": "terus",
    "mantabb": "mantab",
    "sumpahh": "sumpah",
    "diluarann": "diluaran",
    "trbaik": "terbaik",
    "dlam": "dalam",
    "anjirrrr": "anjir",
    "jendess": "janda",
    "dh": "dah",
    "sichh": "sih",
    "namnya": "namanya",
    "geh": "gih",
    "nggak": "enggak",
    "22nya": "dua-duanya",
    "aduuhhh": "aduh",
    "miripp": "mirip",
    "silauuu": "silau",
    "waww": "wow",
    "uga": "juga",
    "njiirr": "anjir",
    "bgs": "bagus",
    "kesinii": "kesini",
    "gemay": "gemas",
    "dstu": "disitu",
    "wiiiihhhh": "wih",
    "samoga": "semoga",
    "kereennn": "keren",
    "wahh": "wah",
    "nyangkaa": "menyangka",
    "hasilnyaaa": "hasilnya",
    "dahhhh": "dah",
    "mudah2": "mudah-mudah",
    "jugaakk": "juga",
    "prnh": "pernah",
    "diapa2in": "diapa-apai",
    "yaak": "ya",
    "lhoo": "loh",
    "donx": "dong",
    "gthu": "begitu",
    "nda": "indak",
    "maauuu": "mau",
    "pacarrr": "pacar",
    "idamann": "idaman",
    "naturalllll": "natural",
    "bnyak": "banyak",
    "berntung": "beruntung",
    "merka": "mereka",
    "jln2": "jalan-jalan",
    "romntis": "romantis",
    "slamat": "selamat",
    "ulan": "ulang",
    "th": "tahu",
    "mngkin": "mungkin",
    "klau": "kalau",
    "diksi": "dikasih",
    "sipp": "sip",
    "taun": "tahun",
    "jugak": "juga",
    "nungguin": "menunggu",
    "ngeluarin": "mengeluarkan",
    "keciill": "kecil",
    "ughaa": "juga",
    'tante"': "tante-tante",
    "banged": "banget",
    "abeees": "habis",
    "kapan2": "kapan-kapan",
    "adain": "mengadakan",
    "bsa": "bisa",
    "bosen2": "bosan-bosan",
    "sempurnaaaaa": "sempurna",
    "kaan": "kan",
    "kece2": "kece-kece",
    "badaaiii": "badai",
    "beneraan": "benaran",
    "cantiiik": "cantik",
    "kuatttt": "kuat",
    "cantiiiiiiik": "cantik",
    "cantiknyaaa": "cantiknya",
    "bae2": "baik-baik",
    "bgd": "banget",
    "mb": "mbak",
    "catiiiiik": "cantik",
    "subahanallah": "subhanallah",
    "jaman2nya": "jaman-jamannya",
    "padet": "padat",
    "buktiin": "membuktikan",
    "cantiq": "cantik",
    'pasien"nya': "pasien-pasiennya",
    "lohh": "loh",
    "utk": "untuk",
    "keeeerrrreeeennnnnnnnn": "keren",
    "woow": "wow",
    "choker2": "choker-choker",
    "hadirrr": "hadir",
    "hadirr": "hadir",
    "jelashh": "jelas",
    "sekali2": "sekali-kali",
    "mbaaa": "mbak",
    "temen": "teman",
    "hidupppp": "hidup",
    "nyebelin": "menyebalkan",
    "diliatnya": "dilihatnya",
    "abis2": "habis-habis",
    "gpp": "enggak apa-apa",
    "para2": "parah-parah",
    "bangeeet": "banget",
    "allahhhhhhh": "allah",
    "gemesnya": "gemasnya",
    "ilang2": "hilang-hilang",
    "kmi": "kami",
    "ngilangin": "menghilangkan",
    "tbuh": "tubuh",
    "itungan": "hitungan",
    "ledekin": "ledeki",
    "tmn2": "teman-teman",
    "repot2": "repot-repot",
    "oles2": "oles-oles",
    "ckup": "cukup",
    "dptkan": "dapatkan",
    "artis2": "artis-artis",
    "kalii": "kali",
    "ninggiin": "meninggikan",
    "baget": "banget",
    "dri": "dari",
    "kira2": "kira-kira",
    "lgsg": "langsung",
    "ngk": "enggak",
    "ahh": "ah",
    "pas2an": "pas-pasan",
    "balesin": "membalas",
    "gausah": "enggak usah",
    "sukaaa": "suka",
    "lutuna": "lucunya",
    "ciapa": "siapa",
    "gemesss": "gemas",
    "duhh": "duh",
    "terharuuu": "terharu",
    "alamii": "alami",
    "sampek": "sampai",
    "ckrng": "sekarang",
    "ngegemesin": "menggemaskan",
    "imoet": "imut",
    "imut2": "imut-imut",
    "jagain": "menjaga",
    "yahbh": "ya",
    "msih": "masih",
    "macem2": "macam-macam",
    "neko2": "neko-neko",
    "sktika": "seketika",
    "lutu": "lucu",
    "wowwww": "wow",
    "massss": "mas",
    "kesiniii": "kesini",
    'keren"': "keren-keren",
    'jalan"nya': "jalan-jalannya",
    "masyaallahhh": "masyaallah",
    "kerennn": "keren",
    "ksni": "kesini",
    "begok": "bego",
    "bkan": "bukan",
    "jgk": "juga",
    "bawak": "bawa",
    "it": "itu",
    "nti": "nanti",
    "pgi": "pagi",
    "keeeeeren": "keren",
    "baguusss": "bagus",
    "mna": "mana",
    "nahannnn": "tahan",
    "bagaatt": "banget",
    "gayannxa": "gayanya",
    "kereeeen": "keren",
    "uda": "sudah",
    "ngekeh": "kekeh",
    "xlian": "kalian",
    "b3": "bertiga",
    "ihhh": "ih",
    "lcu": "lucu",
    "pait": "pahit",
    "koplakkk": "koplak",
    "kerass": "keras",
    "yachhh": "ya",
    "gokil": "gila",
    "ngelihat": "melihat",
    "ngelawak": "melawak",
    "iiihhhhh": "ih",
    "nyolotinnnn": "menyolot",
    "beratttttttt": "berat",
    "cantiikkkk": "cantik",
    "hijaabbb": "hijab",
    "sekalii": "sekali",
    "smnagatin": "menyemangati",
    "pakek": "pakai",
    "kanapa": "kenapa",
    "cans": "cantik",
    "banhet": "banget",
    "bgttttttt": "banget",
    "blng": "bilang",
    "mngasi": "mengasih",
    "kmbang": "kembang",
    "pg": "pagi",
    "nie": "ini",
    "pla": "pula",
    "kw": "kau",
    "blakon": "berlakon",
    "sy": "saya",
    "nmpk": "nampak",
    "bngtzt": "banget",
    "lucukkkkk": "lucu",
    "sbelah": "sebelah",
    "baek": "baik",
    "ciusss": "serius",
    "palinf": "paling",
    "fav": "favorit",
    "maak": "mak",
    "ngakaaaakkk": "mengakak",
    "gokill": "gila",
    "kocakkkkkk": "kocak",
    "ngekek": "mengekek",
    "capee": "cape",
    "pegangin": "memegang",
    "nyender": "menyandar",
    "bener": "benar",
    "manjain": "memanjakan",
    "peleotin": "meleot",
    "bng": "bang",
    "termurahhhh": "termurah",
    "nyatakan": "menyatakan",
    "graaatiiiis": "gratis",
    "meriahh": "meriah",
    "cantikkkm": "cantik",
    "parahh": "parah",
    "bingits": "banget",
    "yuppss": "ya",
    "nyindir": "menyindir",
    "onoh": "sono",
    "bnyk": "banyak",
    "anakny": "anaknya",
    "staf2nya": "staf-stafnya",
    "begete": "banget",
    "aduhh": "aduh",
    "manteppp": "mantap",
    "hati2": "hati-hati",
    "jangan2": "jangan-jangan",
    "kata2nya": "kata-katanya",
    "ynk": "sayang",
    'nangis"': "menangis-nangis",
    'hati"': "hati-hati",
    'jangan"': "jangan-jangan",
    "emank": "memang",
    "cr": "cara",
    "diemin": "diamkan",
    "hancurin": "menghancurkan",
    "ckp": "cukup",
    "mgkn": "mungkin",
    "ato": "atau",
    "diapain": "diapakan",
    "ms": "masih",
    "haragain": "menghargai",
    "cb": "coba",
    "nyakitin": "menyakiti",
    "jgn2": "jangan-jangan",
    "sbaiknya": "sebaiknya",
    "mngerti": "mengerti",
    "blajar": "belajar",
    "fakta2": "fakta-fakta",
    "spt": "seperti",
    "mnding": "mending",
    "nilai2": "nilai-nilai",
    "buka2": "buka-buka",
    "nyinyirin": "nyinyir",
    "pdhl": "padahal",
    "pd": "pada",
    "nyerang": "menyerang",
    "hrs": "harus",
    "mrk": "mereka",
    "trima": "terima",
    "ngomomg": "mengomong",
    "mang": "memang",
    "kbetulan": "kebetulan",
    "orgtuanya": "orang tuanya",
    "sbelum": "sebelum",
    "ngamatin": "mengamati",
    "ngintip": "mengintip",
    "stelah": "setelah",
    "sndiri": "sendiri",
    "ngintilin": "mengintil",
    "smnjak": "semenjak",
    "trbukti": "terbukti",
    "nyambet": "menyambat",
    "msk": "masuk",
    "krmh": "ke rumah",
    "rmh": "rumah",
    "bo'ong": "bohong",
    "eloo": "lo",
    "apa2nya": "apa-apanya",
    "goblokkk": "goblok",
    "sesatt": "sesat",
    "ibliss": "iblis",
    "elo": "lo",
    "kbiasaan": "kebiasaan",
    "hdpnya": "hidupnya",
    "lbh": "lebih",
    "byk": "banyak",
    "anknya": "anaknya",
    "tdr": "tidur",
    "sbuah": "sebuah",
    "anak2nya": "anak-anaknya",
    "tdnya": "tadinya",
    "ank2nya": "anak-anaknya",
    "milih": "memilih",
    "branjak": "beranjak",
    "ank2": "anak-anak",
    "masyarakay": "masyarakat",
    "mudah2an": "mudah-mudahan",
    "menegerti": "mengerti",
    "apa2": "apa-apa",
    "sok2": "sok-sok",
    "nasehatin": "menasihati",
    "ngaca": "mengaca",
    "ajah": "saja",
    "kakkkk": "kak",
    "slamet": "selamat",
    "ampe": "sampai",
    "nari": "menari",
    "ehh": "eh",
    "mf": "maaf",
    "ngcpin": "mengucapkan",
    "woowwww": "wow",
    "iaa": "iya",
    "kdg": "kadang",
    "kebagi": "terbagi",
    "nerusin": "meneruskan",
    "indo": "indonesia",
    "univ": "universitas",
    "maen": "main",
    "wihh": "wih",
    "tetapppp": "tetap",
    "gantenggg": "ganteng",
    "jakety": "jaketnya",
    "nggk": "enggak",
    "skli": "sekali",
    "kli": "kali",
    "ttp": "tetap",
    "pala": "kepala",
    "pusingggg": "pusing",
    "pucing": "pusing",
    "ihhhh": "ih",
    "maho": "manusia homo",
    "gantng": "ganteng",
    "alak": "kepala",
    "hilangv": "hilang",
    "bungggg": "bung",
    "gapap": "enggak apa-apa",
    "kyak": "kayak",
    "pling": "paling",
    "gokiiill": "gila",
    "busedh": "buset",
    "gokilnya": "gilanya",
    "duluuu": "dulu",
    "keceee": "kece",
    "nyaa": "nya",
    "klu": "kalau",
    "gilaa": "gila",
    "duuhhh": "duh",
    "amiiiiinnnnn": "amin",
    "dg": "dengan",
    "tullus": "tulus",
    "tw": "tau",
    "pluk": "peluk",
    "durhaka2": "durhaka-durhaka",
    "kpada": "kepada",
    'seburuk"': "seburuk-buruk",
    "ortu": "orang tua",
    "ktaa": "kita",
    "yup": "ya",
    "tdk": "tidak",
    "tetaplaah": "tetaplah",
    "ajja": "saja",
    "dech": "deh",
    "oprasi": "operasi",
    "gya": "gaya",
    "kndung": "kandung",
    "sbg": "sebagai",
    "u": "lu",
    "ksenangan": "kesenangan",
    "ddpt": "didapat",
    "jwab": "jawab",
    "mmbodohkan": "membodohkan",
    "orlaen": "orang lain",
    "bgtu": "begitu",
    "drpd": "daripada",
    "malem": "malam",
    "aplikasiin": "mengaplikasikan",
    "berangat": "berangkat",
    "praktekin": "mempraktikkan",
    "dahh": "dah",
    "gmn": "bagaimana",
    "omdo": "omong doang",
    "kate": "kata",
    "cabe2": "cabe-cabe",
    "prjuangan": "perjuangan",
    "kmewahan": "kemewahan",
    "stimpal": "setimpal",
    "ddpat": "didapat",
    "sprt": "seperti",
    "bc": "baca",
    "mnilai": "menilai",
    "kata2": "kata-kata",
    "usahh": "usah",
    "segala2nya": "segala-galanya",
    "sekarng": "sekarang",
    "sprti": "seperti",
    "mkanya": "makanya",
    "hay": "hai",
    "mreka": "mereka",
    "bhagia": "bahagia",
    "korek2": "korek-korek",
    "ngebales": "membalas",
    "krna": "karena",
    "sihh": "sih",
    "sasama": "sesama",
    "dehh": "deh",
    "cabe2an": "cabe-cabean",
    "terong2an": "terong-terongan",
    "seklian": "sekalian",
    "kluar": "keluar",
    "tuuu": "itu",
    "ngurusan": "mengurusi",
    "campurin": "mencampuri",
    "emnknya": "memangnya",
    "py": "punya",
    "unyuu": "unyu",
    "mrangkul": "merangkul",
    "adlh": "adalah",
    "wlo": "walau",
    "lh": "boleh",
    "manusiy": "manusia",
    "tx": "tak",
    "samara": "sakinah mawadah rahman",
    "teringt": "teringat",
    "trmsuk": "termasuk",
    "dn": "dan",
    "pilihnmu": "pilihanmu",
    "swmntara": "sementara",
    "trmasuk": "termasuk",
    "orang2": "orang-orang",
    "sgt": "sangat",
    "liht": "lihat",
    "suaminy": "suaminya",
    "jadulnya": "jaman dulunya",
    "mantaff": "mantap",
    "ngata2in": "mengatai-ngatai",
    "bagaimna": "bagaimana",
    "mulusssss": "mulus",
    "bgus": "bagus",
    "gmana": "bagaimana",
    "kpleset": "kepleset",
    "yawlah": "ya allah",
    "kepeleset": "kepleset",
    "kayanye": "kayanya",
    "amiinnnn": "amin",
    "komen2an": "komen-komenan",
    "wewww": "wow",
    "dumsss": "dong",
    "tar": "entar",
    "perbaikin": "memperbaiki",
    "permasalhkan": "permasalahkan",
    "betul2": "betul-betul",
    "jauhin": "jauhi",
    "dateng": "datang",
    "adiik": "adik",
    "manisss": "manis",
    'besar"': "besar-besar",
    'masing"': "masing-masing",
    "ddlm": "di dalam",
    "kmbali": "kembali",
    "dkuburnya": "dikuburnya",
    "fi": "di",
    "ttg": "tentang",
    "rata2": "rata-rata",
    "lbih": "lebih",
    "critamu": "ceritamu",
    "ja": "saja",
    "bres": "beres",
    "cmkn": "camkan",
    "diurusin": "diurusi",
    "biarin": "biarkan",
    "kale": "kali",
    "donks": "dong",
    'membanding"': "membanding-banding",
    "mengperbolehkan": "memperbolehkan",
    "krena": "karena",
    "ngri": "negeri",
    'dingin"': "dingin-dingin",
    "lma": "lama",
    "dibangga'in": "dibangga-banggakan",
    "ngebolehin": "membolehkan",
    "denger": "dengar",
    'jelek"in': "menjelek-jelekkan",
    "stiap": "setiap",
    "gausa": "enggak usah",
    "maksain": "memaksakan",
    "smog": "semoga",
    "mnerima": "menerima",
    "baikxa": "baiknya",
    "aaamin": "amin",
    "amienn": "amien",
    "sekangen2": "sekangen-kangen",
    "kt": "kita",
    "amiiiiiiiiiinnnnnnn": "amin",
    "nolongin": "menolong",
    "amiiiiiiiiiiin": "amin",
    "seluru": "seluruh",
    "amiennn": "amien",
    "tebir": "ribet",
    "doangam": "doang",
    'tebir"': "ribet-ribet",
    "amad": "amat",
    "mkst": "maksud",
    "wong2": "wong-wong",
    "rempong": "repot",
    "ngurusin": "mengurusi",
    "kerjaan": "pekerjaan",
    "bingittzz": "banget",
    "bangets": "banget",
    "ikh": "ih",
    "dwh": "deh",
    "nengok": "menengok",
    "bante": "bantai",
    "la": "lah",
    "komenannya": "komentarnya",
    "hadapin": "menghadapi",
    "dengarin": "mendengarkan",
    "ush": "usah",
    "cock": "cocok",
    "widihh": "idih",
    "mantepp": "mantap",
    "cita2": "cita-cita",
    "temen-temen": "teman-teman",
    "stu": "satu",
    "syratnya": "syaratnya",
    "pnjang": "panjang",
    "shat": "sehat",
    "inginkn": "inginkan",
    "belanjaa": "belanja",
    "burem": "buram",
    "tlp": "telepon",
    "dngan": "dengan",
    "ngerasain": "merasai",
    "kancang": "kencang",
    "tmbh": "tambah",
    "mansyoallah": "masyaallah",
    "skali": "sekali",
    "canttttikkk": "cantik",
    "subhanalloh": "subhanallah",
    "lkuin": "lakukan",
    "langgenh": "langgeng",
    "foto2nya": "foto-fotonya",
    "tanggung2": "tanggung-tanggung",
    "salluutt": "salut",
    "pkai": "pakai",
    "org2": "orang-orang",
    "mkn": "makin",
    "seneng": "senang",
    "pdng": "padang",
    "warbiyasah": "luar biasa",
    "pk": "pakai",
    "keedaannya": "keadaannya",
    "lagu2": "lagu-lagu",
    "saya2": "saya-saya",
    "sekrng": "sekarang",
    "lagu2nya": "lagu-lagunya",
    "ttap": "tetap",
    "spertinya": "sepertinya",
    "mrah": "marah",
    "gra2": "gara-gara",
    "sngaja": "sengaja",
    "jlek": "jelek",
    "udah2": "sudah-sudah",
    "ungkit2": "ungkit-ungkit",
    "pura2": "pura-pura",
    "gatau": "enggak tau",
    "curhat2": "curhat-curhat",
    "matany": "matanya",
    "dteng": "datang",
    "mata'y": "matanya",
    "baju2": "baju-baju",
    "buruannn": "buruan",
    "emng": "memang",
    "perubut": "perebut",
    "sumai": "suami",
    "tk": "tak",
    "urusin": "urus",
    "apah": "apa",
    "bagus2": "bagus-bagus",
    "say": "sayang",
    "mmbela": "membela",
    "mslhnya": "masalahnya",
    "hnya": "hanya",
    "sndri": "sendiri",
    "sj": "saja",
    "llki": "lelaki",
    "dluar": "diluar",
    "sna": "sana",
    "boleh2": "boleh-boleh",
    "dya": "dia",
    "maluuuu": "malu",
    "beda2": "beda-beda",
    "nyaranin": "menyarankan",
    "x": "kali",
    "tongolin": "menongol",
    "cabol": "cabul",
    "ape": "apa",
    "nyet": "monyet",
    "muna": "munafik",
    "jing": "anjing",
    "tot": "entot",
    "nihh": "nih",
    "hidiyah": "hidayah",
    "percya": "percaya",
    "bgi": "bagi",
    "tlg": "tolong",
    "sya": "saya",
    "sdri": "sendiri",
    "tdi": "tadi",
    "mgkin": "mungkin",
    "bhwa": "bahwa",
    "skaligus": "sekaligus",
    "cek2": "cek-cek",
    "spti": "seperti",
    "smakin": "semakin",
    "sbgai": "sebagai",
    "mgk": "mungkin",
    "bgmn": "bagaimana",
    "sapa2": "sapa-sapa",
    "sama2": "sama-sama",
    "kyknya": "kayaknya",
    "pnya": "punya",
    "dng": "dengan",
    "termurahhh": "termurah",
    "bbrp": "beberapa",
    "bhw": "bahwa",
    "banyaaaaaak": "banyak",
    "baik2nya": "baik-baiknya",
    "tunjukan": "tunjukkan",
    "anak2mu": "anak-anakmu",
    "anak2": "anak-anak",
    "ngasih2": "mengasih-ngasih",
    "berfikir": "berpikir",
    "amit2": "amit-amit",
    "mba": "mbak",
    "elu": "lu",
    "ngajuin": "mengajukan",
    "tiba2": "tiba-tiba",
    "jkt": "jakarta",
    "terbaeq": "terbaik",
    "namany": "namanya",
    "jels": "jelas",
    "diakibtkn": "diakibatkan",
    "suk": "suka",
    "jelek2": "jelek-jelek",
    "dsrny": "dasarnya",
    "jkrta": "jakarta",
    "mantaap": "mantap",
    "benar2": "benar-benar",
    "main2": "main-main",
    "lanjutkaaaaan": "lanjutkan",
    "hiduppp": "hidup",
    "ncek": "encek",
    "majuuu": "maju",
    "teruuss": "terus",
    "kdg2": "kadang-kadang",
    "looohh": "loh",
    "sebelumbya": "sebelumnya",
    "tunjukin": "tunjukkan",
    'tahun"': "tahun-tahun",
    "koment": "komentar",
    "nyampein": "menyampaikan",
    "hokiii": "hoki",
    "naksir": "menaksir",
    'bangt"': "banget-banget",
    "nafkahin": "menafkahi",
    "ngitem": "menghitam",
    "banyaaaak": "banyak",
    'sama"': "sama-sama",
    "gx": "enggak",
    "lhat": "lihat",
    "cantika": "cantik",
    "cwek": "cewek",
    "kngen": "kangen",
    "fillm": "film",
    "sinet": "sinetron",
    "jendral": "jenderal",
    "nanya": "bertanya",
    "maenya": "mainnya",
    "cantiks": "cantik",
    "wktu": "waktu",
    "pilm": "film",
    "taon": "tahun",
    "nd": "indak",
    "slah": "salah",
    "cini": "sini",
    "jaaangan": "jangan",
    "nambah": "menambah",
    "naek": "naik",
    "terimaksih": "terima kasih",
    "inii": "ini",
    "kaannnn": "kan",
    "tidakkkk": "tidak",
    "kemuh": "kamu",
    "da": "dah",
    "keren2": "keren-keren",
    "sby": "surabaya",
    "tgl": "tanggal",
    "pinginnn": "pengin",
    "buanget": "banget",
    "ketemuuu": "ketemu",
    "kebawa": "terbawa",
    "mimpiii": "mimpi",
    "wanjerrr": "anjir",
    "satupunn": "satupun",
    "motret": "memotret",
    "temen2": "teman-teman",
    "lapakk": "lapak",
    "nyeniii": "menyeni",
    "bget": "banget",
    "seeh": "sih",
    "abis": "habis",
    "deuhh": "duh",
    "b2an": "berduaan",
    "dihargain": "dihargai",
    'engga"': "enggak-enggak",
    "tahun2": "tahun-tahun",
    "lebayy": "lebay",
    "gilsss": "gila",
    "nganbek": "mengambek",
    "sukaa": "suka",
    "enk": "enak",
    "mendam": "memendam",
    "manta": "mantan",
    "relaaaa": "rela",
    "bgun": "bangun",
    "tdur": "tidur",
    "cntk": "cantik",
    "knl": "kenal",
    "anugrah": "anugerah",
    "slm": "salam",
    "kliatan": "kelihatan",
    "awoohhh": "allah",
    "cantiikk": "cantik",
    "gt": "begitu",
    "sbbyak": "sebanyak",
    "apun": "apapun",
    "nyangkutnya": "menyangkutnya",
    "untk": "untuk",
    "ampunnnnn": "ampun",
    "hy": "hai",
    "wadaaw": "waduh",
    "paraah": "parah",
    "sampw": "sampai",
    "dijelekin": "dijelekkan",
    "napa": "kenapa",
    "azeeeek": "asik",
    "ntikk": "cantik",
    "uhh": "uh",
    "mayan": "lumayan",
    "mnisss": "manis",
    "tambahim": "tambahkan",
    "tambahin": "tambahkan",
    'bener"': "benar-benar",
    "make": "memakai",
    "canttikkk": "cantik",
    "baanggeettt": "banget",
    "ap": "apa",
    "siiihh": "sih",
    "krpoooo": "kepo",
    "pengn": "pengin",
    "nyusul": "menyusul",
    "nyok": "yuk",
    "dekkk": "dek",
    "ngiri": "mengiri",
    "mmang": "memang",
    "nentuin": "menentukan",
    "mnjmput": "menjemput",
    "ygs": "sayang",
    "mblooo": "jomblo",
    "ber'expresi": "berekspresi",
    "jdulnya": "judulnya",
    "ciumman": "ciuman",
    "aurot": "aurat",
    "laginy": "laginya",
    "nyaaaaaaaaaaaaa": "nya",
    "alkhamdulilah": "alhamdulillah",
    "ktnya": "katanya",
    "selaluu": "selalu",
    "anjirrr": "anjir",
    "ngeh": "engah",
    "amen": "amin",
    "qm": "kamu",
    "nahhh": "nah",
    "ngmngnya": "mengomongnya",
    "sampai2": "sampai-sampai",
    "hal2": "hal-hal",
    "komunitas2": "komunitas-komunitas",
    "fotony": "fotonya",
    "halllo": "halo",
    "ngiritya": "mengiritnya",
    "hematt": "hemat",
    "ciyeeee": "cie",
    "yeeee": "ya",
    "nget": "banget",
    "kususnya": "khususnya",
    "krm": "kirim",
    "sam": "sama",
    "ajaaahhhhh": "saja",
    "syediiihhh": "sedih",
    "malangg": "malang",
    "belooomm": "belum",
    "yaakk": "ya",
    "kebukti": "terbukti",
    "anak2e": "anak-anaknya",
    "tuwanya": "tuanya",
    "comen2nya": "komen-komennya",
    "pedesssss": "pedas",
    "jelas2": "jelas-jelas",
    "skg": "sekarang",
    "nyebut2": "menyebut-nyebut",
    "plg": "pulang",
    "smbil": "sambil",
    "hellooooooo": "halo",
    "ngrebut": "merebut",
    "mnjdi": "menjadi",
    "taek": "tahi",
    "lupain": "melupakan",
    "bangkret": "bangkrut",
    "taekk": "tahi",
    "lahhhhhh": "lah",
    "kedokk": "kedok",
    'mati"an': "mati-matian",
    "nyimak": "menyimak",
    "komenx": "komennya",
    "serem2": "seram-seram",
    'ngumpet"': "mengumpet-ngumpet",
    "blim": "belum",
    "sekrang": "sekarang",
    "ngerebut": "merebut",
    "mnjijikaaaaaan": "menjijikkan",
    "astgfrlh": "astagfirullah",
    "sahabatt": "sahabat",
    "gnyngka": "enggak menyangka",
    "sendirir": "sendiri",
    "brengsekk": "brengsek",
    "ngomentnya": "mengomentarinya",
    "nusuk": "menusuk",
    "skr": "sekarang",
    "dpotong": "dipotong",
    "helo": "halo",
    "kmrin": "kemarin",
    "ngmgin": "mengomongkan",
    "bilangg": "bilang",
    "gkhianati": "mengkhianati",
    "kpd": "kepada",
    "hr": "hari",
    "sp": "sapa",
    "pljaran": "pelajaran",
    "spy": "supaya",
    "mngikuti": "mengikuti",
    "klkuan": "kelakuan",
    "dibikin2": "dibikin-bikin",
    "gimana": "bagaimana",
    "nnt": "nanti",
    "cew": "cewek",
    "cow": "cowok",
    "kasiannn": "kasihan",
    "syekaliii": "sekali",
    "hgga": "hingga",
    "cieeeee": "cie",
    "sholihah": "salihah",
    "adeuh": "aduh",
    "halahh": "alah",
    "luu": "lu",
    "yuuks": "yuk",
    "yoo": "ya",
    "ginian": "beginian",
    "judulnyaa": "judulnya",
    "ayoookkkkkk": "ayo",
    "artix": "artinya",
    "cewe": "cewek",
    "cowo": "cowok",
    "lt": "lantai",
    'nama"': "nama-nama",
    "cwe": "cewek",
    "serem": "seram",
    "kepoin": "kepo",
    "keluarin": "keluarkan",
    "gajelas": "enggak jelas",
    "mbak2": "mbak-mbak",
    "pedes": "pedas",
    "komentnya": "komentarnya",
    "omongin": "omongkan",
    "ngalirrrrr": "mengalir",
    "idup": "hidup",
    "nmbah": "menambah",
    "terossss": "terus",
    "ngehujat": "menghujat",
    "dosaa": "dosa",
    "ngebela": "membela",
    "seindonesiyah": "seindonesia",
    "seh": "sih",
    "senyumin": "senyumi",
    "mh": "mah",
    "ngalir": "mengalir",
    "ngrusak": "merusak",
    "px": "punya",
    "kslhn": "kesalahan",
    "skrngnya": "sekarangnya",
    "emang": "memang",
    "kalik": "kali",
    "bilangin": "bilang",
    "nyambungin": "menyambung",
    "sllu": "selalu",
    "scra": "secara",
    "nggali": "menggali",
    "cmpur": "campur",
    "dgr": "dengar",
    "kurng": "kurang",
    "nangiiiiis": "menangis",
    "nangiiis": "menangis",
    "ngomentarin": "mengomentari",
    "idupnya": "hidupnya",
    "ortunya": "orang tuanya",
    "woey": "woy",
    "bloghhh": "goblok",
    "ngomongin": "mengomongkan",
    "doank": "doang",
    'abal"': "abal-abal",
    "dikata2in": "dikata-katai",
    "ngehina": "menghina",
    "gmna": "bagaimana",
    "kebanggan": "kebanggaan",
    "dah": "deh",
    "jngn": "jangan",
    "mnjawab": "menjawab",
    "woooiiiiiiii": "woy",
    "dosaaaaaaaaaa": "dosa",
    "ingt": "ingat",
    "karmaaa": "karma",
    "woooiiiii": "woy",
    "ngkkkkkk": "mengakak",
    "makny": "maknya",
    "wdooohhh": "waduh",
    "kasihn": "kasihan",
    "lhirr": "lahir",
    "hujatann": "hujatan",
    "palgi": "apalagi",
    "wihhh": "wih",
    "kakakkk": "kakak",
    "bagusss": "bagus",
    "jt": "juta",
    "ngets": "banget",
    "stp": "setiap",
    "penbelian": "pembelian",
    "cuaantik": "cantik",
    "sukakkk": "suka",
    "m": "sama",
    "cucokkk": "cocok",
    "lyt": "lihat",
    "expresi": "ekspresi",
    "natap": "menatap",
    "ccok": "cocok",
    "helloo": "halo",
    "dripada": "daripada",
    "difotoin": "difoto",
    "psangan": "pasangan",
    "cakepp": "cakep",
    "ngiriii": "mengiri",
    "coxok": "cocok",
    "buatin": "membuat",
    "nihhh": "nih",
    "statusx": "statusnya",
    "cem": "macam",
    "yee": "ya",
    "sunggu": "sungguh",
    "lagiii": "lagi",
    "ammiiin": "amin",
    "haddeh": "aduh",
    "maaasss": "mas",
    "segerrrr": "segar",
    "kemn": "kemana",
    "suipit": "sipit",
    "sipiit": "sipit",
    "kedengeran": "kedengaran",
    "semangaatt": "semangat",
    "promil": "program hamil",
    "lancr": "lancar",
    "keputihn": "keputihan",
    "gratisss": "gratis",
    "kebayang": "terbayang",
    'mdh"': "mudah-mudah",
    "bz": "bisa",
    "amiinn": "amin",
    "ammin": "amin",
    "mendapatkn": "mendapatkan",
    "lucuuuk": "lucu",
    "amaattt": "amat",
    "aje": "saja",
    "yaoloh": "yaallah",
    "ngerayain": "merayakan",
    "sotoy": "sok tau",
    "yok": "yuk",
    "d.bikinin": "dibikin",
    "mmz": "mas",
    "bikinin": "membikin",
    "bapeeeer": "bawa perasaan",
    "keliatannya": "kelihatannya",
    "siih": "sih",
    "diginiin": "dibeginikan",
    "hadeehh": "aduh",
    "pu": "punya",
    "suamiiiii": "suami",
    "krenn": "keren",
    "kebykan": "kebanyakan",
    "tingal": "tinggal",
    "pernikahn": "pernikahan",
    "ngtain": "mengatai",
    "macem": "macam",
    "bagusnyeee": "bagusnya",
    "kemaren": "kemarin",
    "hmpir": "hampir",
    "liatnyaaa": "lihatnya",
    "waw": "wow",
    "mbuh": "embuh",
    "bsk": "besok",
    "waaa": "wah",
    "berbiiiiiihhh": "barbie",
    "canteek": "cantik",
    "teru": "terus",
    "nyatok": "mencatok",
    "nyampenya": "sampainya",
    "goncengin": "boncengkan",
    "kasi": "kasih",
    "dianterin": "diantar",
    "gebleg": "geblek",
    "bosen": "bosan",
    "anterin": "antarkan",
    "ngantar": "mengantar",
    "nganterin": "mengantarkan",
    "mz": "mas",
    "nerima": "menerima",
    "ati2": "hati-hati",
    "yeuh": "ya",
    "kmn": "kemana",
    "dianter": "diantar",
    "disupirin": "disopiri",
    "jidad": "jidat",
    "ciee": "cie",
    "novembr": "november",
    "hri": "hari",
    "bedain": "membedakan",
    "genduut": "gendut",
    "ehhh": "eh",
    "bertatto": "bertato",
    "brrt": "berarti",
    "kana": "kanan",
    "dtg": "datang",
    "doong": "dong",
    "sblah": "sebelah",
    "tauuu": "tau",
    "tengaj": "tengah",
    "ps": "pas",
    "gmpg": "gampang",
    "engk": "enggak",
    "apal": "hapal",
    "dak": "indak",
    "rupa2nya": "rupa-rupanya",
    "kembaq": "kembar",
    "tngh": "tengah",
    "mknya": "makanya",
    "prmpuan": "perempuan",
    "ketuker": "tertukar",
    "drimnanya": "darimananya",
    "cntikan": "cantikan",
    "edaaaan": "edan",
    "syp": "siapa",
    "bcnda": "bercanda",
    "uhhh": "uh",
    "bazengg": "bajingan",
    "haiii": "hai",
    "bosaan": "bosan",
    "gitu2": "begitu-gitu",
    "kmana2": "kemana-mana",
    "hrsnya": "harusnya",
    "sdg": "sedang",
    "komentar2": "komentar-komentar",
    "kenyataan2": "kenyataan-kenyataan",
    "silahkan": "silakan",
    "lwt": "lewat",
    "sukur2": "sukur-sukur",
    "baek2": "baik-baik",
    "cma": "cuma",
    "berbeda2": "berbeda-beda",
    "dibkatakan": "dikatakan",
    "doonk": "dong",
    "pengikuy": "pengikut",
    "ngmngin": "mengomongkan",
    "sblmnya": "sebelumnya",
    "maksd": "maksud",
    "adkah": "adakah",
    "menbelah": "membelah",
    "ayuk": "ayo",
    "mngira": "mengira",
    "bertolernsi": "bertoleransi",
    "slahkan": "salahkan",
    "tolernsi": "toleransi",
    "sbnarnya": "sebenarnya",
    "ingi": "ingin",
    "oalaaaa": "walah",
    "menjelekan": "menjelekkan",
    "hadeuuh": "aduh",
    "dikemanain": "dikemanakan",
    "aneh2": "aneh-aneh",
    "bpknya": "bapaknya",
    "baca2": "baca-baca",
    "jwb": "jawab",
    "komen2": "komen-komen",
    "sebelum2nya": "sebelum-sebelumnya",
    "sbagai": "sebagai",
    "sedihh": "sedih",
    "kangennnn": "kangen",
    "gndakan": "gandakan",
    "kangeeeeeeeenya": "kangen",
    "gaa": "enggak",
    "ganti'kn": "menggantikan",
    "tnang": "tenang",
    "amiiiiiiiiiiiiiiiiin": "amin",
    "kgeeeen": "kangen",
    "kangeenn": "kangen",
    "bangeeeet": "banget",
    "bsok": "besok",
    "hbis": "habis",
    "mti": "mati",
    "bngetttt": "banget",
    "kangeen": "kangen",
    "bgect": "banget",
    'kebaikan"y': "kebaikannya",
    "dssi": "disisi",
    "kngenn": "kangen",
    "kangeeeeennn": "kangen",
    "lagii": "lagi",
    "dasyat": "dahsyat",
    "aer": "air",
    "bgni": "begini",
    "skalii": "sekali",
    "gg": "enggak",
    "dtinggl": "ditinggal",
    "terbaiiikkkkk": "terbaik",
    "murahhh": "murah",
    "pecahhg": "pecah",
    "kakakgh": "kakak",
    "terbaeeeek": "terbaik",
    "prempuan": "perempuan",
    "manteep": "mantap",
    "nggeh": "engah",
    "indonesiaaa": "indonesia",
    "inia": "ini",
    "maluu": "malu",
    "cobaaaa": "coba",
    "dehhh": "deh",
    "cepetan": "cepatan",
    "ntapsss": "mantap",
    "kamiiii": "kami",
    "smangat": "semangat",
    "qmu": "kamu",
    "sdkit2": "sedikit-sedikit",
    "tntg": "tentang",
    "penyakitny": "penyakitnya",
    "ngajarin": "mengajari",
    "laenny": "lainnya",
    "amiinnn": "amin",
    "scpatny": "secepatnya",
    "sampein": "sampaikan",
    "tuany": "tuanya",
    "doa2": "doa-doa",
    "pjg": "panjang",
    "adeeek": "adek",
    "bca": "baca",
    "netes": "menetes",
    "mataq": "mataku",
    "byangin": "membayangkan",
    "trjadi": "terjadi",
    "dposisi": "diposisi",
    "tanda2nya": "tanda-tandanya",
    "dijwb": "dijawab",
    "tmn2nya": "teman-temannya",
    "sayy": "sayang",
    "salaam": "salam",
    "ngajar": "mengajar",
    "fto2": "foto-foto",
    "laen": "lain",
    "dallam": "dalam",
    "tentanh": "tentang",
    "nangiss": "menangis",
    "nnton": "menonton",
    "kejadianny": "kejadiannya",
    "klg": "keluarga",
    "sayaang": "sayang",
    "msg2": "masing-masing",
    "pgnnya": "penginnya",
    "meluk": "memeluk",
    "siiihhh": "sih",
    "mupeng": "muka pengin",
    "caya": "percaya",
    "aduhhhhhhhhh": "aduh",
    "buseett": "buset",
    "mblo": "jomblo",
    "lucuuu": "lucu",
    "gagahx": "gagahnya",
    "miriiiip": "mirip",
    "kaliiii": "kali",
    "niru": "meniru",
    "bpkmu": "bapakmu",
    "sangt": "sangat",
    "baang": "bang",
    "gasih": "enggak sih",
    "yuu": "yuk",
    "yuuu": "yuk",
    "samaa": "sama",
    "ngademin": "mengademkan",
    "aahh": "ah",
    "makasi": "terima kasih",
    "looo": "loh",
    "yokk": "yuk",
    "gils": "gila",
    "ono": "sono",
    "weeeh": "wih",
    "suksea": "sukses",
    "temenan": "berteman",
    "sehh": "sih",
    "deket": "dekat",
    "dekt": "dekat",
    "genggg": "geng",
    "yawloh": "ya allah",
    "bhnya": "bahannya",
    "loo": "lo",
    "samaaaa": "sama",
    "abanggku": "abangku",
    "sayanggg": "sayang",
    "dsni": "disini",
    "ciieeeeeee": "cie",
    "kokohh": "engkoh",
    "pdhal": "padahal",
    "takuttt": "takut",
    "yuks": "yuk",
    "pnjual": "penjual",
    "yh": "ya",
    "dung": "dong",
    "latian": "latihan",
    "aaaaaaakkk": "ah",
    "mauuuu": "mau",
    "soga": "moga",
    "tteh": "teteh",
    "sintron": "sinetron",
    "astagaa": "astaga",
    "ancurrr": "hancur",
    "dblkang": "dibelakang",
    "yayang": "sayang",
    "gokillllll": "gila",
    "aplks": "aplikasi",
    "ska": "suka",
    "ktawa": "ketawa",
    "baguuus": "bagus",
    "kaaan": "kan",
    "ngepoin": "mengepoi",
    "uuhh": "uh",
    "beut": "banget",
    "njirrr": "anjir",
    "pengeeenn": "pengin",
    "dongggg": "dong",
    "hatii": "hati",
    "besook": "besok",
    "mauu": "mau",
    "gtuu": "begitu",
    "njayyy": "anjay",
    "maacih": "terima kasih",
    "tokayyy": "tahi",
    "to": "tapi",
    "mksdku": "maksudku",
    "gituin": "begitukan",
    "lgsung": "langsung",
    "cba": "coba",
    "nh": "nih",
    'ilang"': "hilang-hilang",
    "giniin": "beginikan",
    "ksini": "kesini",
    "kubarikan": "kuberikan",
    "ayank": "sayang",
    "anyeng": "anjing",
    "yankkk": "sayang",
    "cukurrr": "cukur",
    "gilaaaaaa": "gila",
    "yhaaa": "ya",
    "qaqaaaa": "kakak",
    "sayangkuuuuu": "sayangku",
    "kakakuuu": "kakakku",
    "banx": "bang",
    "edannn": "edan",
    "bape": "bawa perasaan",
    'artis"': "artis-artis",
    "ngelahirin": "melahirkan",
    "paksain": "memaksa",
    "biasaa": "biasa",
    "hub": "hubungan",
    "hubunggi": "hubungi",
    "loooh": "loh",
    "telimakacih": "terima kasih",
    "nerawang": "menerawang",
    "cantiiiik": "cantik",
    "didapet": "didapat",
    "tanya2": "tanya-tanya",
    "pede": "percaya diri",
    "kuningggg": "kuning",
    "nyolot": "menyolot",
    "elahh": "alah",
    "pnting": "penting",
    "bela2in": "membela-bela",
    "marah2an": "marah-marahan",
    "wlaupun": "walaupun",
    "syantiiiiikkkkkkkkkkkk": "cantik",
    'bwa"': "bawa-bawa",
    "agma": "agama",
    "hijabb": "hijab",
    "kerrennn": "keren",
    "ngetik": "mengetik",
    "ntah": "entah",
    "pan": "kapan",
    "mateeeek": "mati",
    "geetoo": "begitu",
    "sewain": "menyewa",
    "kokkk": "kok",
    "muluuu": "melulu",
    "yaaang": "yang",
    "iyaa": "iya",
    "gituu": "begitu",
    "yappp": "ya",
    "uwahhhhh": "wah",
    "bnr2": "benar-benar",
    "psgn": "pasangan",
    "ujg": "ujung",
    "rmbut": "rambut",
    "smp": "sampai",
    "kki": "kaki",
    "hayukk": "hayo",
    "ntab": "mantab",
    "atuhhh": "atuh",
    "yukss": "yuk",
    "lihaatttt": "lihat",
    "niiiihh": "nih",
    "liattt": "lihat",
    "cuyyy": "cuy",
    "gapernah": "enggak pernah",
    "liatiii": "lihat",
    "jombsss": "jomblo",
    "emesshhh": "gemas",
    "gemeessss": "gemas",
    "poollll": "pol",
    "gemesyak": "gemas ya",
    "bngttt": "banget",
    "ngegmesin": "menggemaskan",
    "hndak": "hendak",
    "hndk": "hendak",
    "iiih": "ih",
    "lutunaa": "lucunya",
    "abiz": "habis",
    "gemes": "gemas",
    "ngareppppp": "mengharap",
    "aamiinin": "amin",
    "imuutt": "imut",
    "abizzz": "habis",
    "tay": "tahi",
    "toketnya": "teteknya",
    "tumpe2": "tumpah-tumpah",
    "lenje": "lenjeh",
    "tuuuuh": "tuh",
    "cantinya": "cantiknya",
    "macam2": "macam-macam",
    'mbak"': "mbak-mbak",
    "ngatain": "mengatai",
    "mbaknyaahh": "mbaknya",
    "pyudara": "payudara",
    "ditutupin": "ditutupi",
    "bgitu": "begitu",
    "ngomongnya": "mengomongnya",
    "sich": "sih",
    "cantiik2": "cantik-cantik",
    "hati.a": "hatinya",
    "mk.a": "makanya",
    "mlt.a": "mulutnya",
    "nyerocooooos": "mencerocos",
    "kyk.a": "kayaknya",
    "sklh": "sekolah",
    "pljrn": "pelajaran",
    "srng": "sering",
    "ngilang": "menghilang",
    "dikatain": "dikatai",
    "maluuu": "malu",
    "ngalahin": "mengalahkan",
    "brisi": "berisi",
    "pkoknya": "pokoknya",
    "canti": "cantik",
    "astagfirullh": "astagfirullah",
    "nutupin": "menutupi",
    "ori": "orisinal",
    "kakakaaaaaaaaaaaaaa": "kakak",
    "cantikkkkkkkk": "cantik",
    "batwc": "banget",
    "kamyuhhh": "kamu",
    "dbwh": "dibawah",
    "bukti2": "bukti-bukti",
    "senenggg": "senang",
    "mao": "mau",
    "murhan": "murahan",
    "prwtn": "perawatan",
    "wjh": "wajah",
    "bgettt": "banget",
    "mereka2": "mereka-mereka",
    "pakke": "pakai",
    "dipake": "dipakai",
    "ktergantungan": "ketergantungan",
    "prwatn": "perawatan",
    "ngebuktiin": "membuktikan",
    "hslnya": "hasilnya",
    "awal2": "awal-awal",
    "setabil": "stabil",
    "maksih": "terima kasih",
    "gratiss": "gratis",
    "bbrpa": "beberapa",
    'gara"': "gara-gara",
    'benar"': "benar-benar",
    "ajaibb": "ajaib",
    "pokonya": "pokoknya",
    "setujuuu": "setuju",
    "digituin": "dibegitukan",
    "sekolahin": "sekolahkan",
    "ajarin": "ajarkan",
    "sendirii": "sendiri",
    "mrnghadapi": "menghadapi",
    "apalg": "apalagi",
    "naka": "nakal",
    "sdkt": "sedikit",
    "besar2in": "besar-besarkan",
    "bgmana": "bagaimana",
    "s*inetr*n": "sinetron",
    "mrusak": "merusak",
    "mndpt": "mendapat",
    "skt": "sakit",
    "sebnyak": "sebanyak",
    "terburu2": "terburu-buru",
    "baik2": "baik-baik",
    "ngumpat2": "mengumpat-ngumpat",
    "nantangin": "menantang",
    "ngegampar": "menggampar",
    "ngelaporin": "melaporkan",
    "salahin": "salahkan",
    "gabisa": "enggak bisa",
    "konsekwensi": "konsekuensi",
    "muliany": "mulianya",
    "mungki": "mungkin",
    "lngsung": "langsung",
    "tsb": "tersebut",
    "t4": "tempat",
    "bacahalah": "bacalah",
    "dikerasin": "dikerasi",
    "gkkan": "enggak akan",
    "ngulangin": "mengulangi",
    "bedaa": "beda",
    "pnyaa": "punya",
    "bol3h": "boleh",
    "ngadu": "mengadu",
    "ketauan": "ketahuan",
    "dimarahin": "dimarahi",
    "nyelesain": "menyelesaikan",
    "troma": "trauma",
    "kerasin": "kerasi",
    "kamu2": "kamu-kamu",
    "cewer": "jewer",
    "bilanh": "bilang",
    "jwban": "jawaban",
    "nuduh": "menuduh",
    "ngatur": "mengatur",
    "rajin2": "rajin-rajin",
    "bacaaaa": "baca",
    "kekk": "kayak",
    "jungkiir": "jungkir",
    "gunaa": "guna",
    "bales2in": "balas-membalas",
    "orangg": "orang",
    "tauuuu": "tau",
    "byak": "banyak",
    "kepad": "kepada",
    "bantuanny": "bantuannya",
    "ttinggi": "tinggi",
    "perna": "pernah",
    "grgr": "gara-gara",
    "jari2": "jari-jari",
    "pukulin": "pukuli",
    "bengkak2": "bengkak-bengkak",
    "komentarin": "mengomentari",
    "bijak2": "bijak-bijak",
    "lama2": "lama-lama",
    "menurur": "menurut",
    "tipe2": "tipe-tipe",
    "diliat": "dilihat",
    "liatlah": "lihatlah",
    "teguran2": "teguran-teguran",
    "gr2": "gara-gara",
    "gamau": "enggak mau",
    "skolah": "sekolah",
    "pdahal": "padahal",
    "klas": "kelas",
    "tkut": "takut",
    "grunya": "gurunya",
    "pndah": "pindah",
    "liat2": "lihat-lihat",
    "masukin": "memasuki",
    "dilindungin": "dilindungi",
    "kasiaannn": "kasihan",
    "miring2": "miring-miring",
    "tinggalin": "tinggalkan",
    "kaitannha": "kaitannya",
    "sud": "sudah",
    "pinter": "pintar",
    "rana": "ranah",
    "thdp": "terhadap",
    "scr": "secara",
    "bhkn": "bahkan",
    "justeru": "justru",
    "ngatai": "mengatai",
    "kln": "kalian",
    "sukak": "suka",
    "termuraaahhhh": "termurah",
    "brkunjun": "berkunjung",
    "suarranya": "suaranya",
    'bner"': "benar-benar",
    "iu": "itu",
    "bgussss": "bagus",
    "kmaren": "kemarin",
    "ambilin": "mengambil",
    "biasaaaa": "biasa",
    "luuuaar": "luar",
    "redho": "ridho",
    "rezki": "rezeki",
    "kepd": "kepada",
    "luaarrr": "luar",
    "biasaaa": "biasa",
    "jadilh": "jadilah",
    "bnr": "benar",
    "terhaaru": "terharu",
    "orrunya": "orang tuanya",
    "flm": "film",
    "kalok": "kalo",
    "adek2": "adek-adek",
    "loncatt": "loncat",
    "hampasss": "hempas",
    "tehh": "teh",
    "bunga2": "bunga-bunga",
    "apaaan": "apaan",
    "ampuuunn": "ampun",
    "daaah": "dah",
    "bangetttttt": "banget",
    "ituh": "itu",
    "cantiiikk": "cantik",
    "suaranyaaaaaa": "suaranya",
    "idoolaaa": "idola",
    "pulaa": "pula",
    "penyanyi2": "penyanyi-penyanyi",
    "wiih": "wih",
    "apaa": "apa",
    "miriip": "mirip",
    "allaahh": "allah",
    "ajahhh": "saja",
    "trims": "terima kasih",
    "dehat": "sehat",
    "salammmm": "salam",
    "hari2": "hari-hari",
    "sihat": "sehat",
    "buruann": "buruan",
    "rekomendain": "rekomendasikan",
    "trussss": "terus",
    "bangt": "banget",
    "cepet": "cepat",
    "pesen": "pesan",
    "boong": "bohong",
    "prawatan": "perawatan",
    "mkin": "makin",
    "dimao": "dimau",
    "dijadiin": "dijadikan",
    "silahkn": "silakan",
    "kasiatnya": "khasiatnya",
    'minyak"an': "minyak-minyakan",
    "suksess": "sukses",
    "prodak": "produk",
    "trasa": "terasa",
    "minpi": "mimpi",
    "bner2": "benar-benar",
    "mutihin": "memutihkan",
    "smster": "semester",
    "kmren": "kemarin",
    "ucull": "lucu",
    'ngomong"': "ngomong-ngomong",
    "udehh": "sudah",
    "syngnya": "sayangnya",
    "dipermainin": "dipermainkan",
    "kocakkk": "kocak",
    "dasarrr": "dasar",
    "waaaaw": "wow",
    "cannnnntikkkkkkk": "cantik",
    "mukax": "mukanya",
    "cantikx": "cantiknya",
    "fatanik": "fanatik",
    "protestin": "protestan",
    "kakau": "kalau",
    "marh": "marah",
    "emngnya": "memangnya",
    "cantiknyaa": "cantiknya",
    "darpada": "daripada",
    "cooooooocok": "cocok",
    "pkk": "pakai",
    "sling": "saling",
    "agama'ny": "agamanya",
    "bilng": "bilang",
    "prcy": "percaya",
    "lurusin": "meluruskan",
    "biri": "biru",
    "luco": "lucu",
    "ultha": "ultah",
    "batikk": "batik",
    "arab2": "arab-arab",
    "luchu": "lucu",
    "baguss": "bagus",
    "sedihhh": "sedih",
    "syang": "sayang",
    "ngasi": "mengasih",
    "naaaak": "nak",
    "astafirullah": "astagfirullah",
    "peragain": "peragakan",
    "shayyy": "say",
    "anjaayy": "anjay",
    "shay": "say",
    "ngilerrrr": "mengiler",
    "woyyy": "woy",
    "shaaaay": "say",
    "hempaass": "hempas",
    "sayyy": "say",
    "shayy": "say",
    "syantiek": "cantik",
    "njay": "anjay",
    "hehh": "eh",
    "cantik2": "cantik-cantik",
    "kam": "kamu",
    "ingeet": "ingat",
    "sblh": "sebelah",
    "nawarin": "menawari",
    "amiiiiin": "amin",
    "jauhhh": "jauh",
    "waaahhh": "wah",
    "ajakin": "mengajak",
    "mntn": "mantan",
    "ade": "adek",
    "luhhh": "lu",
    "yooookkk": "yuk",
    "jrnk": "jarang",
    'jelas"': "jelas-jelas",
    "kayax": "kayak",
    "dblkng": "dibelakang",
    "anjirr": "anjir",
    "mirippp": "mirip",
    "sangattt": "sangat",
    "iyap": "iya",
    "mayann": "lumayan",
    "autuhh": "tau tuh",
    "atutt": "takut",
    "ketara": "tertara",
    "giniii": "begini",
    "mbaaass": "mbak",
    "bund": "bunda",
    "bangeeettt": "banget",
    "almh": "almarhumah",
    "temenkuuh": "temanku",
    "suami'y": "suaminya",
    "bngeeeetttt": "banget",
    "entr": "entar",
    "kyax": "kayak",
    "cuantikkk": "cantik",
    "mksdnya": "maksudnya",
    "kaaaaaaaaaakkkkkkkkkkk": "kak",
    "kucing'y": "kucingnya",
    "nama'in": "namai",
    "panggilan'ya": "panggilannya",
    "panggilan'y": "panggilannya",
    "z": "saja",
    "kalw": "kalau",
    "tips2": "tips-tips",
    "alu": "aku",
    "ngerrrriiii": "ngeri",
    "ngriii": "mengiri",
    "amatt": "amat",
    "smpai": "sampai",
    "kox": "kok",
    "tmbah": "tambah",
    "cntikk": "cantik",
    "pkee": "pakai",
    "smkin": "semakin",
    "amiiiiinnn": "amin",
    "bgmna": "bagaimana",
    "ssorg": "seseorang",
    "hdpn": "hadapan",
    "foto2": "foto-foto",
    "mnambh": "menambah",
    "ktaatan": "ketaatan",
    "stju": "setuju",
    "cantikkkkkk": "cantik",
    "dilepas2": "dilepas-lepas",
    "tehhh": "teh",
    "istiqomahhh": "istikamah",
    "tehhhh": "teh",
    "prodaknya": "produknya",
    "imutt": "imut",
    "amu": "kamu",
    "nahh": "nah",
    "mauuuuuuu": "mau",
    "jilbb": "jilbab",
    "tmn": "teman",
    "ndut": "gendut",
    "ngecek": "mengecek",
    "psti": "pasti",
    "penasarn": "penasaran",
    "cuyy": "cuy",
    "astauviruloh": "astagfirullah",
    "paaak": "pak",
    "diajarin": "diajari",
    "gawl": "gaul",
    "kecr": "kece",
    "iih": "ih",
    "laaaah": "lah",
    "aned": "banget",
    "gingsungny": "gingsulnya",
    "blh": "boleh",
    "cariin": "carikan",
    "kenceng": "kencang",
    "cuanti": "cantik",
    "mbanya": "mbaknya",
    "knlan": "kenalan",
    "mbaakk": "mbak",
    "mrka": "mereka",
    "nyusahhin": "menyusahkan",
    "byaran": "bayaran",
    "wlawpun": "walaupun",
    "sedangkn": "sedangkan",
    "tnpa": "tanpa",
    "bnggain": "banggakan",
    "nyusahin": "menyusahkan",
    "malu2in": "malu-malui",
    "dibanggain": "dibanggakan",
    "wlau": "walau",
    "komenan": "komentar",
    'bangga"in': "membangga-banggakan",
    "krya": "karya",
    'bilang"': "bilang-bilang",
    "tinggall": "tinggal",
    "dmna": "dimana",
    "dripda": "daripada",
    "bangga2in": "membangga-banggakan",
    "dibnggain": "dibanggakan",
    "karya2": "karya-karya",
    "drimana": "darimana",
    "ngepake'": "memakai",
    "gksalah": "enggak salah",
    "nuntut": "menuntut",
    "ngebiarin": "membiarkan",
    "bhas": "bahas",
    "lagu'y": "lagunya",
    "jadiin": "jadikan",
    "diem": "diam",
    "nyampah": "menyampah",
    'mba"': "mbak-mbak",
    "bukan'a": "bukannya",
    "tappi": "tapi",
    "kalli": "kali",
    "pacara": "pacaran",
    'ngerebut"': "merebut-rebut",
    "lluu": "lu",
    "mbaa": "mbak",
    "ngerussak": "merusak",
    'bela"in': "membela-bela",
    "bellain": "membela",
    "kallo": "kalo",
    "coment": "komentar",
    "dewassa": "dewasa",
    "comnet": "komen",
    'pikir"': "pikir-pikir",
    "kaya'a": "kayanya",
    "kuyyy": "yuk",
    "kitaa": "kita",
    "sgtu'y": "sebegitunya",
    "ngebelain": "membela",
    "tpii": "tapi",
    'karya"': "karya-karya",
    "do": "di",
    "cali": "caci",
    "penghrgaan": "penghargaan",
    "ajjh": "saja",
    "lbihh": "lebih",
    "baikk": "baik",
    "drii": "dari",
    'artist"': "artis-artis",
    'maki"': "maki-maki",
    "sendirinnya": "sendirinya",
    "stidaknya": "setidaknya",
    "may": "mau",
    "trbaikk": "terbaik",
    "punn": "pun",
    "mengikutii": "mengikuti",
    "atassan": "atasan",
    "klauu": "kalau",
    "jngnn": "jangan",
    "so": "sok",
    "sendirinyya": "sendirinya",
    "frestasiii": "prestasi",
    "mst": "mesti",
    "add": "ada",
    "see": "sih",
    "sibukx": "sibuknya",
    "in": "ini",
    "katanyaa": "katanya",
    "lawaaaas": "lawas",
    "kocaaaak": "kocak",
    "syng": "sayang",
    "adenya": "adeknya",
    "pkoknyaa": "pokoknya",
    "dsana": "disana",
    "dua2nya": "dua-duanya",
    "sichhhhhhhhhh": "sih",
    "nampak": "menampak",
    "tetehh": "teteh",
    "wooowww": "wow",
    "cobain": "mencoba",
    "muga": "moga",
    "kenalin": "memperkenalkan",
    "janka": "jangka",
    "wawwwww": "wow",
    "waaaww": "wow",
    "waaawwww": "wow",
    "mantapp": "mantap",
    "cobaaa": "coba",
    "kageet": "kaget",
    "bangettttttt": "banget",
    "oplas": "operasi plastik",
    "nambahh": "bertambah",
    "paripurnahh": "paripurna",
    "wanitah": "wanita",
    "indonesiaah": "indonesia",
    "cumn": "cuman",
    "gegra": "gegara",
    "brita": "berita",
    "fotbar": "foto bareng",
    "wajarrr": "wajar",
    "sngt": "sangat",
    "wk": "waktu",
    "bingiittt": "banget",
    "nampar": "menampar",
    "tukan": "tukang",
    "jatoh": "jatuh",
    'muka"': "muka-muka",
    "cantik2nya": "cantik-cantiknya",
    "sdgkn": "sedangkan",
    'apa"': "apa-apa",
    "mancungin": "memancungkan",
    "idung": "hidung",
    "kusem": "kusam",
    "drpada": "daripada",
    "kmar": "kamar",
    "diemm": "diam",
    "tnggu": "tunggu",
    "ketawain": "mentertawakan",
    "yaelahhh": "alah",
    'sikap"': "sikap-sikap",
    "bales": "balas",
    "ampuun": "ampun",
    "ngejatuhin": "manjatuhkan",
    "ngelakuin": "melakukan",
    "gedeg": "gedek",
    "muka2": "muka-muka",
    "eey": "eh",
    "kslahan": "kesalahan",
    "perhatiam": "perhatian",
    "dibiarin": "dibiarkan",
    "sbnrny": "sebenarnya",
    "trjd": "terjadi",
    "mkir": "memikir",
    "hny": "hanya",
    "apalai": "apalagi",
    "bkal": "bakal",
    "saat2": "saat-saat",
    "nyadar": "menyadar",
    "bka": "buka",
    "berani2": "berani-berani",
    "lucuuuuu": "lucu",
    "pipi'y": "pipinya",
    "gemmeeezzz": "gemas",
    "sukam": "suka",
    "menghilangkn": "menghilangkan",
    "mnjdkan": "menjadikan",
    "mudah2n": "mudah-mudahan",
    "stlh": "setelah",
    "soalx": "soalnya",
    "keche": "kece",
    "badaii": "badai",
    "btuh": "butuh",
    "ktanya": "katanya",
    "bebrp": "beberapa",
    "sblum": "sebelum",
    "santab": "santap",
    "salehah": "salihah",
    "mikirin": "memikirkan",
    "subhannallah": "subhanallah",
    "konsul": "konsultasi",
    "pengalam": "pengalaman",
    "poko": "pokok",
    "trun": "turun",
    "kuninggg": "kuning",
    "pinkkkk": "pink",
    "warnany": "warnanya",
    "seger": "segar",
    "senangat": "semangat",
    "msknya": "masaknya",
    "kerennnn": "keren",
    "ciptain": "menciptakan",
    "bagussss": "bagus",
    "sayangkuh": "sayangku",
    "gans": "ganteng",
    "kren": "keren",
    "babget": "banget",
    "dihh": "dih",
    "jadu": "jadi",
    "ksyngn": "kesayangan",
    "haru": "harus",
    "ngingetin": "mengingatkan",
    "narik": "menarik",
    'orang"': "orang-orang",
    "gokilll": "gila",
    "astagaaaa": "astaga",
    "hancuuuuuy": "hancur",
    "mattihhh": "mati",
    "beudd": "banget",
    "termiribkan": "termiripkan",
    "dngerin": "mendengarkan",
    "brrti": "berarti",
    "wenakk": "enak",
    "nganteng": "ganteng",
    "abanggg": "abang",
    "seksii": "seksi",
    "gtuh": "begitu",
    "jadii": "jadi",
    "emeezzz": "gemas",
    "amohhh": "kamu",
    "maau": "mau",
    "eyke": "aku",
    "gilakkkkk": "gila",
    "awk": "awak",
    "duhhhhh": "duh",
    "wowww": "wow",
    "liaatt": "lihat",
    "iniiiii": "ini",
    "aloh": "allah",
    "ngettt": "banget",
    "maso": "masa",
    "brubah": "berubah",
    "pelastik": "plastik",
    "keak": "kayak",
    "dengerin": "mendengarkan",
    "beud": "banget",
    "pahamin": "memahami",
    "takuuuuut": "takut",
    "ahahahanjirrr": "anjir",
    "jogetin": "berjoget",
    "shaay": "say",
    "boker": "berak",
    "pacarnyaa": "pacarnya",
    "siapaa": "siapa",
    "matii": "mati",
    "ketawaa": "ketawa",
    "wanjiir": "anjir",
    "bw": "bawa",
    "minta": "meminta",
    "bnran": "benaran",
    "sgla": "segala",
    "uitnya": "duitnya",
    "beliiin": "belikan",
    "yaaah": "ya",
    "sekaeang": "sekarang",
    "tgk": "tengok",
    "tanyain": "tanyakan",
    "jatuhnyaa": "jatuhnya",
    "banyakin": "membanyaki",
    "tipu2nya": "tipu-tipunya",
    "doaang": "doang",
    "gituan": "begituan",
    "kaj": "kak",
    "wahhhhhh": "wah",
    "iiiiiiiii": "ih",
    "kaliiiiiii": "kali",
    "melebihin": "melebihi",
    "gakpapa": "enggak apa-apa",
    "kalogak": "kalo enggak",
    "sm2": "sama-sama",
    "ndukung": "mendukung",
    "kaaaaa": "kak",
    "aamiinnn": "amin",
    "skluarga": "sekeluarga",
    "suaminga": "suaminya",
    "berhijap": "berhijab",
    "smgaa": "semoga",
    "istiqamah": "istikamah",
    "cuaaantikk": "cantik",
    "muraaaaah": "murah",
    "baraang": "barang",
    "aamiiin": "amin",
    "bets": "banget",
    "alhamdulillaaaaah": "alhamdulillah",
    "sembuhin": "menyembuhkan",
    "pengrusak": "perusak",
    "ngoceh": "mengoceh",
    "aduhhh": "aduh",
    "hpus": "hapus",
    "pjang": "pajang",
    "bdampingan": "berdampingan",
    "kaga": "kagak",
    "uih": "uh",
    'serem"': "seram-seram",
    'happi"': "hepi-hepi",
    "bgtuu": "begitu",
    "mff": "maaf",
    "ktwa": "ketawa",
    "trlalu": "terlalu",
    "jjur": "jujur",
    "ngmg": "mengomong",
    "semogaa": "semoga",
    "kepelesett": "terpeleset",
    "geeelaakk": "gila",
    "bolang": "bocah petualang",
    "pkek": "pakai",
    "lagihh": "lagi",
    "hedeuuhh": "aduh",
    "stress": "stres",
    "saltummmm": "salah kostum",
    "mboizzz": "bois",
    "suda": "sudah",
    "kayaq": "kayak",
    "ema": "emak",
    "dirumahny": "dirumahnya",
    "yuh": "tuh",
    "rmbt": "rambut",
    "apus": "hapus",
    "siapayahh": "siapa ya",
    "kostom": "kostum",
    "gnii": "begini",
    "atuu": "satu",
    "pipinyaaa": "pipinya",
    "bungkuuuuuuuuusss": "bungkus",
    "iiiihhhhhj": "ih",
    "emeessss": "gemas",
    "pipine": "pipinya",
    "glembeeeer": "gelambir",
    "lucunaaa": "lucunya",
    "cubanget": "lucu banget",
    "pengenn": "pengin",
    "unyuuk": "unyu",
    "dedek": "adek",
    "lucunyah": "lucunya",
    "mantaaap": "mantap",
    "keduaa": "kedua",
    "trsrh": "terserah",
    "ksih": "kasih",
    "seterong": "setrong",
    "teyuss": "terus",
    "dimasukin": "dimasuki",
    "jelekin": "menjelekkan",
    "jahatin": "menjahati",
    "tai": "tahi",
    "gtw": "enggak tau",
    "qo": "kok",
    "nulis": "menulis",
    "nyebutin": "menyebutkan",
    "ngertiin": "mengerti",
    "rasaiin": "rasai",
    "gakusah": "enggak usah",
    "disni": "disini",
    "sabarrr": "sabar",
    "semangaatttt": "semangat",
    "nyalahin": "menyalahkan",
    "bedainnya": "membedakannya",
    "keknya": "kayaknya",
    "krus": "kurus",
    "elaaaahhhh": "alah",
    "cogan": "cowok ganteng",
    "tap8": "tapi",
    "pandanginya": "memandanginya",
    "kenaliiin": "kenalkan",
    "banyak2": "banyak-banyak",
    "yo": "ya",
    "suko": "suka",
    "niih": "nih",
    "sihhhh": "sih",
    'sebaik"': "sebaik-baik",
    "segtu": "sebegitu",
    "ngebenci": "membenci",
    "bakar2in": "bakar-bakari",
    "padhe": "pakde",
    "yya": "ya",
    "atw": "atau",
    "dosa2mu": "dosa-dosamu",
    "maafin": "memaafi",
    "gile": "gila",
    "ujung2": "ujung-ujung",
    "dalem2": "dalam-dalam",
    "kgak": "kagak",
    "bahas2": "bahas-bahas",
    "ud": "sudah",
    "woles": "selow",
    "hianatin": "khianati",
    "halangin": "halangi",
    "iyuh": "ih",
    "iyuuuhhhh": "ih",
    "gaje": "enggak jelas",
    "gabakal": "enggak bakal",
    "adapin": "menghadapi",
    "ngehakimi": "menghakimi",
    "ngejuangin": "memperjuangkan",
    "dipojokin": "dipojokkan",
    "bacotin": "bacoti",
    "berati": "berarti",
    "kebangetak": "kebangetan",
    "tangkep": "tangkap",
    "bt": "buat",
    "sadis2": "sadis-sadis",
    "maksir": "menaksir",
    "hebatt": "hebat",
    "pndang": "pandang",
    "pmbelajaran": "pembelajaran",
    "ngejelek": "menjelekkan",
    "maslah": "masalah",
    "mmperbaiki": "memperbaiki",
    "nahan": "menahan",
    "kafeh": "kafe",
    "remang2": "remang-remang",
    "mlh": "malah",
    "tinggl": "tinggal",
    "dirmh": "dirumah",
    "iyuuhhh": "ih",
    "ktika": "ketika",
    "dipuja2": "dipuja-puja",
    "ngrasain": "merasai",
    "ityl": "itil",
    "hbs": "habis",
    "marah2": "marah-marah",
    "wenak": "enak",
    "ngarang": "mengarang",
    "kelas'a": "kelasnya",
    "hadeeehhh": "aduh",
    'kecil"': "kecil-kecil",
    'gtu"an': "begitu-gituan",
    "gmanapun": "bagaimanapun",
    "kr": "kira",
    "nenek2": "nenek-nenek",
    "taux": "taunya",
    "urat2nya": "urat-uratnya",
    "ketarik": "tertarik",
    "ngorbanin": "mengorbankan",
    "eksprsi": "ekspresi",
    "gitulah": "begitulah",
    'foto"': "foto-foto",
    "mamas": "mas",
    "bandingin": "bandingkan",
    "tua2": "tua-tua",
    "terus2an": "terus-terusan",
    "waduhh": "waduh",
    'bawa"': "bawa-bawa",
    "badingkan": "membandingkan",
    "ngurus": "mengurus",
    "lanjutin": "lanjutkan",
    "ributin": "meributkan",
    "brantem": "berantem",
    "belain": "membela",
    "lipetan": "lipatan",
    'nenek"': "nenek-nenek",
    "bneraan": "benaran",
    "kageeet": "kaget",
    "sangaaattt": "sangat",
    "rmbuut": "rambut",
    "nt": "nanti",
    "walik": "balik",
    "oma2": "oma-oma",
    "kellen": "kalian",
    "nyerocos": "mencerocos",
    "ibuk2": "ibu-ibu",
    "ngomenin": "mengomentari",
    "iseng2": "iseng-iseng",
    "niyyyyhhhh": "nih",
    "sexi2": "seksi-seksi",
    "blik": "balik",
    "kenape": "kenapa",
    "ladenin": "meladeni",
    "skit": "sakit",
    "hat": "hati",
    "jilbabnye": "jilbabnya",
    "ledkin": "meledeki",
    "digabtikan": "digantikan",
    "jng": "jangan",
    "ngumung": "mengomong",
    "ilang-in": "hilangkan",
    "prinadi": "pribadi",
    "luh": "lu",
    "yep": "ya",
    "helooooo": "halo",
    "loe": "lo",
    "palingann": "palingan",
    "berjinah": "berzina",
    "munaafikk": "munafik",
    "urusn": "urusan",
    "saudra": "saudara",
    "trganggu": "terganggu",
    "bhijab": "berhijab",
    "lepasin": "melepas",
    "smentara": "sementara",
    "waduhhh": "waduh",
    "ursan": "urusan",
    "sudab": "sudah",
    "dwsa": "dewasa",
    "rpt2": "repot-repot",
    "ngaji": "mengaji",
    "nmr": "nomor",
    "romantiz": "romantis",
    "murmer": "murah meriah",
    "pensaran": "penasaran",
    "baru2": "baru-baru",
    "yuukk": "yuk",
    "kitaaa": "kita",
    "lainnyaa": "lainnya",
    "perbulannn": "perbulan",
    "penyebab2": "penyebab-penyebab",
    "nyupir": "menyopir",
    "steess": "stres",
    "kwatir": "kawatir",
    "tengah2": "tengah-tengah",
    "duetin": "duet",
    "mudaa": "muda",
    "sebenernya": "sebenarnya",
    "silsturahmi": "silaturahmi",
    "dijkt": "dijakarta",
    "cums": "cuma",
    "undangan2": "undangan-undangan",
    "past": "pasti",
    "ayukk": "yuk",
    "ngucapin": "mengucapkan",
    "filmny": "filmnya",
    "ntn": "menonton",
    "nobar": "menonton bareng",
    "kemariin": "kemarin",
    "knpp": "kenapa",
    "lggi": "lagi",
    "gaprgi": "enggak pergi",
    "aaahh": "ah",
    "pa2": "apa-apa",
    "dtunggu": "ditunggu",
    "masa2": "masa-masa",
    "kepikir": "terpikir",
    "seruuu": "seru",
    "emeshh": "gemas",
    "kaya": "kayak",
    "astagaaaaaa": "astaga",
    "pacarn": "pacaran",
    "ktg": "kita",
    "pacaranya": "pacarannya",
    "mbaak": "mbak",
    "ngalah": "mengalah",
    "de": "deh",
    "pacarane": "pacarannya",
    "rusakkk": "rusak",
    "yaaampunnn": "ya ampun",
    "tuwek": "tua",
    "mukae": "mukanya",
    "ultahe": "ultahnya",
    "kliatanya": "kelihatannya",
    "pcaranya": "pacarannya",
    "bermaksut": "bermaksud",
    "tampialannya": "tampilannya",
    "nikaah": "nikah",
    'anak"': "anak-anak",
    "pankapan": "kapan-kapan",
    "ngumbar": "mengumbar",
    "dhpusin": "dihapuskan",
    "istiqomah": "istikamah",
    "mnutup": "menutup",
    "bngatt": "banget",
    "dii": "di",
    "ooh": "oh",
    "hapusin": "hapuskan",
    "lohhh": "loh",
    "ngeuh": "engah",
    "sneng": "senang",
    "mutusin": "memutuskan",
    "ngapus": "menghapus",
    "awl": "awal",
    "hrus": "harus",
    "bngkit": "bangkit",
    "mncoba": "mencoba",
    "wahhh": "wah",
    "mutuain": "memutuskan",
    "smw": "semua",
    "geuliiiiiiis": "geulis",
    "euyyyyy": "euy",
    "uuh": "uh",
    "ngirim": "mengirim",
    "ngidam": "mengidam",
    "waah": "wah",
    "sampis": "sampah habis",
    "maapin": "maafi",
    "ngebala": "bala",
    "mampuussss": "mampus",
    "diihhhh": "dih",
    "hrusnya": "harusnya",
    "sabal": "sabar",
    "udahlah": "sudahlah",
    "kauuuu": "kau",
    "sabaro": "sabar",
    "eehhh": "eh",
    "iiii": "ih",
    "kreative": "kreatif",
    "bangrt": "banget",
    "azekkkk": "asik",
    "kuaaatt": "kuat",
    "bhet": "banget",
    "inggrisny": "inggrisnya",
    "dsna": "disana",
    "iyaap": "iya",
    "mksih": "terima kasih",
    "nga": "enggak",
    "canyk": "cantik",
    "prodac": "produk",
    "nyesell": "menyesal",
    "ciyusss": "serius",
    "cyin": "cinta",
    "bangetttttttt": "banget",
    "sexi": "seksi",
    "bundaaaa": "bunda",
    "bangget": "banget",
    "bettt": "banget",
    "cantiiillx": "cantik",
    "brapa": "berapa",
    "alaami": "alami",
    "sabaarrr": "sabar",
    "cantiiiikk": "cantik",
    "bangeeeeetttt": "banget",
    "cannntikk": "cantik",
    "banggett": "banget",
    "thnan": "tahunan",
    "cuantik": "cantik",
    "segerr": "segar",
    "wouww": "wow",
    "cantiiikkk": "cantik",
    "pen": "pengin",
    "catokin": "catok",
    "ikut2an": "ikut-ikutan",
    "comment2nya": "komentar-komentarnya",
    "teman2": "teman-teman",
    "besar2an": "besar-besaran",
    "knsul": "konsultasi",
    "brhasil": "berhasil",
    "hilangin": "menghilangkan",
    "kontak2": "kontak-kontak",
    "dptnya": "dapatnya",
    "applikasi": "aplikasi",
    "kereeeeen": "keren",
    "bngeet": "banget",
    "gemesinnnnn": "menggemaskan",
    "ongkiir": "ongkir",
    "ajaibbbbb": "ajaib",
    "saayyyyy": "say",
    "lohhhh": "loh",
    "ganteung": "ganteng",
    "bhgia": "bahagia",
    "iiiiiiiiii": "ih",
    "lucuukk": "lucu",
    "keciil": "kecil",
    "yakinn": "yakin",
    "pentass": "pentas",
    "ngarep": "mengharap",
    "lucu2": "lucu-lucu",
    "testinya": "testimoninya",
    "mengirusi": "mengurusi",
    "khdpn": "kehidupan",
    "ngelawan": "melawan",
    "betuuuuulllllllllllllllll": "betul",
    "bisax": "bisanya",
    "klmbutan": "kelembutan",
    "seburuk2": "seburuk-buruk",
    "diingetin": "diingatkan",
    "ngeriiiiii": "ngeri",
    "nich": "nih",
    "akhlah": "akhlak",
    "elo2": "lo-lo",
    "mandiin": "memandikan",
    "nguburin": "menguburkan",
    "ngebedain": "membedakan",
    "urusanny": "urusannya",
    "tuhanny": "tuhannya",
    "brtngkar": "bertengkar",
    "pndapat": "pendapat",
    "looh": "loh",
    "sharusnya": "seharusnya",
    "mngkannya": "mangkanya",
    "nyia2in": "menyia-nyiakan",
    "brarti": "berarti",
    "mndpat": "mendapat",
    "kpuasan": "kepuasan",
    "sgampang": "segampang",
    "mlepaskan": "melepaskan",
    "trll": "terlalu",
    "sndr": "sendiri",
    "sellow": "selow",
    "sbbrnya": "sebenarnya",
    "kasar2": "kasar-kasar",
    "semangattt": "semangat",
    "testi": "testimoni",
    "banyaak": "banyak",
    "bujukk": "bujuk",
    "d.apa": "diapa",
    "apain": "apai",
    "dsar": "dasar",
    "benetaran": "benaran",
    "bneran": "benaran",
    "si": "sih",
    "kraya": "karya",
    "brg": "bareng",
    "ngebantu": "membantu",
    "janjutin": "lanjutkan",
    "kepppoin": "kepoi",
    "recommendasi": "rekomendasi",
    "btulan": "betulan",
    "kha": "kah",
    "s": "si",
    "tutupin": "menutupi",
    "wik": "wig",
    "ithu": "itu",
    "botakin": "botaki",
    "botakkkk": "botak",
    "bnrn": "benaran",
    "week": "wig",
    "gawul": "gaul",
    "modes": "modis",
    "brayyy": "bray",
    "kcantikan": "kecantikan",
    "bronis": "brondong manis",
    "gapunya": "enggak punya",
    "bkln": "bakalan",
    "kecantikanga": "kecantikannya",
    "hiii": "hai",
    "piiiilih": "pilih",
    "deeh": "deh",
    "zama": "zaman",
    "gnti": "ganti",
    "nmnya": "namanya",
    "tapo": "tapi",
    "gkk": "enggak",
    "petinggi2": "petinggi-petinggi",
    "wota2": "wota-wota",
    "indefendet": "independen",
    "tempat2": "tempat-tempat",
    "taik": "tahi",
    "yuuuukkk": "yuk",
    "dituutup": "ditutup",
    "ngayal": "mengkhayal",
    "smvk": "sempak",
    "knyataan": "kenyataan",
    "njrittt": "anjir",
    "selmt": "selamat",
    "taz": "atas",
    "klhran": "kelahiran",
    "pertma": "pertama",
    "kelahuran": "kelahiran",
    "pertamany": "pertamanya",
    "mamax": "mamanya",
    "ankx": "anaknya",
    "cantip": "cantik",
    "klahiran": "kelahiran",
    "slmat": "selamat",
    "mmbanggakan": "membanggakan",
    "ortuny": "orang tuanya",
    "selmat": "selamat",
    "bnda": "bunda",
    "nyah": "nya",
    "prtamax": "pertamanya",
    "moqa": "moga",
    "yq": "yang",
    "brbakti": "berbakti",
    "gewlaaaaa": "gila",
    "basodaraa": "bersaudara",
    "hargs": "harga",
    "perhatiin": "perhatikan",
    "abal2": "abal-abal",
    "bantuim": "bantu",
    "adl": "adalah",
    "pelwak": "pelawak",
    "suces": "sukses",
    "sucses": "sukses",
    "garemin": "garami",
    "gapake": "enggak pakai",
    "ngiringan": "mengiringi",
    "karir.a": "karirnya",
    "aamin": "amin",
    "teruz": "terus",
    "kemarn": "kemarin",
    "recomendasinya": "rekomendasinya",
    "promoo": "promo",
    "ongkirr": "ongkir",
    "mskasih": "terima kasih",
    "wowwwww": "wow",
    "seeeemua": "semua",
    "batesin": "batasi",
    "bijin": "bikin",
    "ngeidealin": "mengidealkan",
    "bhn": "bahan",
    "gasalah": "enggak salah",
    "brsma": "bersama",
    "le": "boleh",
    "ugha": "juga",
    "semuaaa": "semua",
    "heeee": "hai",
    "rame2": "rame-rame",
    "yam": "ya",
    "kartunin": "kartun",
    "kyaknya": "kayaknya",
    "abez": "habis",
    "baaaaaang": "bang",
    "ganteeeeng": "ganteng",
    "entahhh": "entah",
    "gimanaaaa": "bagaimana",
    "duuhh": "duh",
    "gantengnyaaaa": "gantengnya",
    "kpn2": "kapan-kapan",
    "pans": "fan",
    "kuliyh": "kuliah",
    "gantengkuuuuuu": "gantengku",
    "atassss": "atas",
    "orgny": "orangnya",
    "owalaah": "walah",
    "aslinyo": "aslinya",
    "alissnyaa": "alisnya",
    "masaaaa": "masa",
    "komuk": "muka",
    "kalahnye": "kalahnya",
    "iyaaaa": "iya",
    "fakultass": "fakultas",
    "smrg": "semarang",
    "unyu2": "unyu-unyu",
    "koq": "kok",
    "yyaaa": "ya",
    "insonniaaa": "insomnia",
    "adekx": "adeknya",
    "azaab": "azab",
    "gksi": "enggak sih",
    "greged": "greget",
    "alamiii": "alami",
    "ktemu": "ketemu",
    "ditayangin": "ditayangkan",
    'ms"': "masa-masa",
    "meranin": "memerankan",
    "nontonny": "menontonnya",
    "rekomendasiiin": "merekomendasikan",
    "sista2": "sista-sista",
    "agan2": "agan-agan",
    "ngg": "enggak",
    "nanget": "banget",
    "ngeditnya": "mengeditnya",
    "himana": "bagaimana",
    "kekgini": "kayak begini",
    "subhanaallahh": "subhanallah",
    "sangat2": "sangat-sangat",
    "terharuuuu": "terharu",
    'kata"': "kata-kata",
    "subhanallahhh": "subhanallah",
    "tlsn": "tulisan",
    "nagiss": "menangis",
    "aneut": "banget",
    "trrharu": "terharu",
    "subhnallah": "subhanallah",
    "allahh": "allah",
    "suamiii": "suami",
    "dcintai": "dicintai",
    "klrga": "keluarga",
    "liat'y": "lihatnya",
    "lggeng": "langgeng",
    "romantisny": "romatisnya",
    "duhhh": "duh",
    "pcar": "pacar",
    "kakanga": "kakaknya",
    "slw": "selow",
    "cpa": "siapa",
    "akuu": "aku",
    "aelah": "alah",
    "orabg": "orang",
    "mukanyaa": "mukanya",
    "kakakny": "kakaknya",
    "woooyy": "woy",
    "ngelucu": "melucu",
    "bukak": "buka",
    "mato": "mata",
    "kareno": "karena",
    "cino": "cina",
    "munafikk": "munafik",
    "meker": "mikir",
    "indoneaia": "indonesia",
    "benarin": "membenarkan",
    "jaadii": "jadi",
    "apo": "apa",
    "nyo": "nya",
    "miara": "memiara",
    "jalanani": "menjalani",
    "dalil2": "dalil-dalil",
    "sunah2": "sunah-sunah",
    "sdah": "sudah",
    "benda2": "benda-benda",
    "bilang2": "bilang-bilang",
    "emangnya": "memangnya",
    "rumpiin": "rumpi",
    "hotak": "botak",
    "ikut2": "ikut-ikut",
    "jawabanny": "jawabannya",
    "ajj": "saja",
    "mikir2": "memikir-mikir",
    "melihara": "memelihara",
    "oooh": "oh",
    "hidupx": "hidupnya",
    "ngefans": "fan",
    "lsg": "langsung",
    "uztad": "ustad",
    "anjingnyaa": "anjingnya",
    "pegang2": "pegang-pegang",
    "ilmh": "ilmu",
    "menasehati": "menasihati",
    "suka2": "suka-suka",
    "kelus": "kali",
    "hubngan": "hubungan",
    "koclak": "kocak",
    "bju": "baju",
    "cinggirnyaaaa": "cinggirnya",
    "yahhhh": "ya",
    "miripppp": "mirip",
    "sedikitlaahh": "sedikitlah",
    "miriplahhhhhh": "miriplah",
    "syediih": "sedih",
    "mirp": "mirip",
    "baju.a": "bajunya",
    "wiiiihhhhhhhhh": "wih",
    "gantheng": "ganteng",
    "synk": "sayang",
    "ngfans": "fan",
    "miriiippp": "mirip",
    "idungnya": "hidungnya",
    "wooow": "wow",
    "panglingg": "pangling",
    "artisnyaa": "artisnya",
    "dtggu": "ditunggu",
    "trnyata": "ternyata",
    "bgtttttttt": "banget",
    "rapih": "rapi",
    "buuun": "bun",
    "iyaappps": "iya",
    "sukse": "sukses",
    "nih2": "nih-nih",
    "baruu": "baru",
    "kecptan": "kecepatan",
    "rmbutnya": "rambutnya",
    "giti": "begitu",
    "penganten": "pengantin",
    "wrn": "warna",
    "ne": "ini",
    "cantikkkkk": "cantik",
    "fans": "fan",
    "loksyut": "lokasi syuting",
    "amfun": "ampun",
    "k'": "kak",
    "asuuu": "asu",
    "kuu": "ku",
    "dsini": "disini",
    "dibls": "dibalas",
    "ceklist": "ceklis",
    "terusss": "terus",
    "tlvn": "telepon",
    "trkrim": "terkirim",
    "kelaluan": "kelakuan",
    "guanteng": "ganteng",
    "cucok": "cocok",
    "c": "sih",
    "gueee": "gue",
    "semangatt": "semangat",
    "haduh": "aduh",
    "mlz": "malas",
    "emak2": "emak-emak",
    "tante2": "tante-tante",
    "kepoh": "kepo",
    "jalanin": "menjalani",
    "repong": "repot",
    "ngrusin": "mengurusi",
    "iy": "iya",
    "dnk": "dong",
    "senyumna": "senyumnya",
    "ngejelek2in": "menjelek-jelekkan",
    "hotx": "hotnya",
    "cwnya": "ceweknya",
    "mbaaahhh": "mbah",
    "pasangn": "pasangan",
    "sttus": "status",
    "aama": "sama",
    "hadeuuhhhh": "aduh",
    "lebar2": "lebar-lebar",
    "sstu": "sesuatu",
    "serasiii": "serasi",
    "cocokx": "cocoknya",
    "emakx": "emaknya",
    "iniiiiiiiiiiiiiii": "ini",
    "cocookk": "cocok",
    "kll": "kalo",
    "arghhh": "ah",
    "ungkapin": "ungkapkan",
    "merrid": "merit",
    "neh": "nih",
    "cocokkkkk": "cocok",
    "yaolohh": "ya allah",
    "aee": "saja",
    "naggung": "menanggung",
    "battt": "banget",
    "am": "sama",
    "tah": "teh",
    "luthuna": "lucunya",
    "astagaaa": "astaga",
    "suaraynyaa": "suaranya",
    "duanyaa": "duanya",
    "anjayyyy": "anjay",
    "coeggg": "coeg",
    "ancur": "hancur",
    "koplak": "kocak",
    "uaaasssiiiik": "asik",
    "boss": "bos",
    "nyubit": "mencubit",
    "dede": "adek",
    "gemez": "gemas",
    "tium": "cium",
    "gemeeezzzz": "gemas",
    "ppa": "papa",
    "papahhhnya": "papahnya",
    "duuuhh": "duh",
    "ginting": "ganteng",
    "bingiiittzz": "banget",
    "iiihh": "ih",
    "dedeknya": "adeknya",
    "hadeeuh": "aduh",
    "geneeee": "begini",
    "yooow": "ya",
    "gemezz": "gemas",
    "gayax": "gayanya",
    "infpyunnnn": "ampun",
    "paraaah": "parah",
    "papiii": "papi",
    "kamunyaa": "kamunya",
    "ngambek": "mengambek",
    "haduuuh": "aduh",
    "kapaan": "kapan",
    "nginjek": "menginjak",
    "putihnyaa": "putihnya",
    "ituuuu": "itu",
    "omaaaaaaakk": "oma",
    "loncattt": "loncat",
    "didatengin": "didatangi",
    "abg": "abang",
    "kmariiin": "kemarin",
    "ayoklaa": "ayolah",
    "jelasssss": "jelas",
    "kaliiin": "kalian",
    "ujunggg": "ujung",
    "kaakaaaa": "kakak",
    "srruu": "seru",
    "kannn": "kan",
    "jmpaaaa": "jumpa",
    "yukkk": "yuk",
    "haii": "hai",
    "syukaaakkk": "suka",
    "dengeeriin": "dengarkan",
    "yakaliiiii": "yakali",
    "atuhh": "atuh",
    "ngertii": "mengerti",
    "apalgi": "apalagi",
    "akuh": "aku",
    "mesrany": "mesranya",
    "jendes": "janda",
    "ngggk": "enggak",
    "coccokk": "cocok",
    "msa": "masa",
    "jendesss": "janda",
    "klepek2": "klepek-klepek",
    "bngtttt": "banget",
    "ponakn": "ponakan",
    "tantee": "tante",
    "gadiss": "gadis",
    "tpy": "tapi",
    "jnda": "janda",
    "bngy": "banget",
    "bujngn": "bujangan",
    "ngp": "mengapa",
    "padetan": "padatan",
    "bawa2": "bawa-bawa",
    "nyobain": "mencoba",
    "pcaran": "pacaran",
    "or": "orang",
    "tdak": "tidak",
    "prcuma": "percuma",
    "langgengggg": "langgeng",
    "sekaliiiii": "sekali",
    "anehhh": "aneh",
    "hayal": "khayal",
    "bedua": "berdua",
    "bapeerr": "bawa perasaan",
    "keinget": "teringat",
    "merekak": "mereka",
    "kreeenn": "keren",
    "abisss": "habis",
    "kocaaaakkk": "kocak",
    "abiiiss": "habis",
    "pass": "pas",
    "personill": "personil",
    "lengkapp": "lengkap",
    "ampuuun": "ampun",
    "iiihhhh": "ih",
    "flim.a": "filmnya",
    "trusan.a": "terusannya",
    "tdung": "tudung",
    "gangguin": "mengganggu",
    "lgkah2": "langkah-langkah",
    "taw": "tau",
    "cntiiikkk": "cantik",
    "tegaar": "tegar",
    "sktlrang": "sekarang",
    "kangeeeennnnn": "kangen",
    "sjk": "sejak",
    "tambh": "tambah",
    "nangiis": "menangis",
    "nyaaaaaaaaa": "nya",
    "bundaa": "bunda",
    "duuhhhhh": "duh",
    "gaada": "enggak ada",
    "malsudnya": "maksudnya",
    "lluuccuu": "lucu",
    "siappa": "siapa",
    "martabakk": "martabak",
    "skali2": "sekali-kali",
    "kueren2": "keren-keren",
    "abgnya": "abangnya",
    "warkop": "warung kopi",
    "hayuu": "hayo",
    "kenapaa": "kenapa",
    "ilang2an": "hilang-hilangan",
    "ayooook": "ayo",
    "astagaaaaaaaa": "astaga",
    "inihhh": "ini",
    "oom": "om",
    "mansetan": "bermanset",
    "cadasss": "cadas",
    "kereeeeennn": "keren",
    'temen"': "teman-teman",
    "telefisi": "televisi",
    "nikmatin": "menikmati",
    "mantappp": "mantap",
    "mbahh": "mbah",
    "giitu": "begitu",
    "mtanya": "matanya",
    "cpit": "sipit",
    "dee": "dek",
    "sumvahh": "sumpah",
    "tamvann": "tampan",
    "yap": "ya",
    "guaaaaaaa": "gua",
    "capa": "sapa",
    "ngakakkk": "mengakak",
    "liaat": "lihat",
    "gantweng": "ganteng",
    "anjjjjjjjj": "anjing",
    "gakwad": "enggak kuat",
    "seru2": "seru-seru",
    "iniii": "ini",
    "favoriteeee": "favorit",
    "adaa": "ada",
    "dinyanyiin": "dinyanyikan",
    "seruu": "seru",
    "nyengir": "menyengir",
    "temennya": "temannya",
    "klk": "kelak",
    "brjdh": "berjodoh",
    "akhrt": "akhirat",
    "kangennnnn": "kangen",
    "kanggen": "kangen",
    "kangennnnnnn": "kangen",
    "ysh": "ya",
    "sypa": "siapa",
    "nangisss": "menangis",
    "brjodoh": "berjodoh",
    "kaliann": "kalian",
    "barengg": "bareng",
    "kpnpun": "kapanpun",
    "mendj": "menjadi",
    "allahhhh": "allah",
    "merindinggg": "merinding",
    "amiennnn": "amien",
    "iihh": "ih",
    "lhir": "lahir",
    "udeh": "sudah",
    "menjdi": "menjadi",
    "debay": "adek bayi",
    "bangeer": "banget",
    "lafazd": "lafaz",
    "pmbyran": "pembayaran",
    "plsa": "pulsa",
    'dimana"': "dimana-mana",
    "sokk": "sok",
    "ngambekan": "ambekan",
    "sma2": "sama-sama",
    "ngom": "mengomong",
    "toloollll": "tolol",
    "bodhooo": "bodoh",
    "peliharaaaa": "pelihara",
    "makanyaa": "makanya",
    'ati"': "hati-hati",
    "kemakan": "termakan",
    "bodhoo": "bodoh",
    "siihhh": "sih",
    "andaaa": "anda",
    "buktinyaaa": "buktinya",
    "smuaaa": "semua",
    "ngambeknya": "mengambeknya",
    "kebongkar": "terbongkar",
    "tapii": "tapi",
    "kasiian": "kasihan",
    "diladenin": "diladeni",
    "comen": "komen",
    "ngtif": "negatif",
    "comntr": "komentar",
    "kaliannn": "kalian",
    "brdiri": "berdiri",
    "mulutny": "mulutnya",
    "msalah": "masalah",
    "trserh": "terserah",
    "waduuuuh": "waduh",
    "ngedukung": "mendukung",
    "dihpus": "dihapus",
    "mrekaa": "mereka",
    "cakeeeeppp": "cakep",
    "benerr": "benar",
    'brg"': "bareng-bareng",
    "baanget": "banget",
    "anjaaaayyyyyy": "anjay",
    "ngetsz": "banget",
    "utkmu": "untukmu",
    "anj": "anjing",
    "merekaa": "mereka",
    "kann": "kan",
    "dieee": "dia",
    "yaahh": "ya",
    "hijap": "hijab",
    "ternodain": "ternodai",
    "ngeri2": "ngeri-ngeri",
    "mn": "mana",
    "kt2": "kata-kata",
    "agk": "agak",
    "slhkan": "salahkan",
    "jilbabny": "jilbabnya",
    "perilakuny": "perilakunya",
    "ketaatanny": "ketaatannya",
    "kepda": "kepada",
    "sblmny": "sebelumnya",
    "bljr": "belajar",
    "pedulilaaaah": "pedulilah",
    "ingetin": "mengingatkan",
    "terjrumus": "terjerumus",
    "stuju": "setuju",
    "sbb": "sebab",
    "igtlah": "ingatlah",
    "dtgkan": "datangkan",
    "benahin": "membenahi",
    "ohhhh": "oh",
    "yapp": "ya",
    "jauhh": "jauh",
    "bingitt": "banget",
    "buka2an": "buka-bukaan",
    "ngembali": "kembali",
    "semngat": "semangat",
    "lekong": "laki",
    "kacauuuu": "kacau",
    "ngimpi": "mimpi",
    "owh": "oh",
    "ngerampas": "merampas",
    "ngehancurin": "menghancurkan",
    "ngungkit2": "mengungkit-ungkit",
    "kaleee": "kali",
    "caranga": "caranya",
    "usa": "usah",
    "dipikirin": "dipikirkan",
    "nunduk": "menunduk",
    "tembemmm": "tembem",
    "lucuuuuuuuuuu": "lucu",
    "bundaaa": "bunda",
    "nyubitt": "mencubit",
    "jls2": "jelas-jelas",
    "supeer": "super",
    "inni": "ini",
    "appa": "apa",
    "hayooo": "hayo",
    "adyem": "adem",
    "mitnah": "memfitnah",
    "cantiknyaaaaa": "cantiknya",
    "tmbm": "tembam",
    "cantix": "cantik",
    "kriput": "keriput",
    "jelex": "jelek",
    "drmn": "darimana",
    'laku"': "laku-laku",
    'orang"nya': "orang-orangnya",
    "kacian": "kasihan",
    "cape": "capek",
    "mancing2": "memancing-mancing",
    "eeeeh": "eh",
    "kpancing": "terpancing",
    "lakuin": "melakukan",
    "cri": "cari",
    "sbenernya": "sebenarnya",
    "mikirinnn": "memikirkan",
    'diam"': "diam-diam",
    "mengalahkn": "mengalahkan",
    "nyindirin": "menyindir",
    "nee": "ini",
    "klakuan": "kelakuan",
    "mksdx": "maksudnya",
    "shabat": "sahabat",
    "jk": "jika",
    "brbuat": "berbuat",
    "mmberi": "memberi",
    "nm": "nama",
    "sbhabat": "sahabat",
    "pnjerumus": "penjerumus",
    "tman": "teman",
    "shbat": "sahabat",
    "melakukn": "melakukan",
    "seorg": "seorang",
    "berkluarga": "berkeluarga",
    "siapa2": "siapa-siapa",
    "ketipu": "tertipu",
    'laki"': "laki-laki",
    "mengait2kan": "mengait-ngaitkan",
    "nyir2": "nyinyir",
    "gosipin": "menggosipkan",
    "sendri": "sendiri",
    "bntar": "bentar",
    "duuuhhh": "duh",
    "nmbk": "menembak",
    "gakkk": "enggak",
    "abiiiiisssss": "habis",
    "tikung2": "tikung-tikung",
    "cwok": "cowok",
    "bangedd": "banget",
    "wuastagah": "astaga",
    "bedaaa": "beda",
    "jaoooh": "jauh",
    "mateeeeeeeeeeee": "mati",
    "parsis": "persis",
    "sumpeh": "sumpah",
    "iyh": "iya",
    "kmana": "kemana",
    "cantiqs": "cantik",
    "kecik": "kecil",
    "brasa": "berasa",
    "trlihat": "terlihat",
    "mmberikan": "memberikan",
    "khidupan": "kehidupan",
    "srpti": "seperti",
    "dinamakn": "dinamakan",
    "sgtu": "sebegitu",
    "paati": "pasti",
    "kutuu": "kutu",
    "setelur2nya": "setelur-telurnya",
    "khadiran": "kehadiran",
    "kel": "keluarga",
    "srta": "serta",
    "kcil": "kecil",
    "kberkahn": "keberkahan",
    "kbahagiaan": "kebahagiaan",
    "tntram": "tentram",
    "brsama": "bersama",
    "hngga": "hingga",
    "brpndapat": "berpendapat",
    "trutama": "terutama",
    "hiraukn": "hiraukan",
    "diamkn": "diamkan",
    "hrsny": "harusny",
    "brsyukur": "bersyukur",
    "mmberikn": "memberikan",
    "rasakn": "rasakan",
    "cari2": "cari-cari",
    "kesalahanny": "kesalahannya",
    "kekuranganny": "kekurangannya",
    "seandainy": "seandainya",
    "perasaanny": "perasaannya",
    "diindonesis": "diindonesia",
    "liyatnya": "lihatnya",
    "kayahhh": "kaya",
    "ala2": "ala-ala",
    "yook": "yuk",
    "yoookkkk": "yuk",
    "siihh": "sih",
    "elus2": "elus-elus",
    "asliiiii": "asli",
    "aduuhhhh": "aduh",
    "belom": "belum",
    "padahl": "padahal",
    "btul": "betul",
    "kejahatn": "kejahatan",
    "slam": "salam",
    "ngelewati": "melewati",
    "kalu": "kalau",
    "ngerendahin": "merendahkan",
    "apaalahh": "apalah",
    "tnp": "tanpa",
    "menyebut2": "menyebut-nyebut",
    "mnt": "minta",
    "kiya": "kita",
    "miriiiiip": "mirip",
    "dirimuuu": "dirimu",
    "yoiiu": "yoi",
    "semuanyaaaa": "semuanya",
    "suka.a": "sukanya",
    "jdii": "jadi",
    "blnja": "belanja",
    "brangnya": "barangnya",
    "ada2": "ada-ada",
    "nimpuk": "menimpuk",
    "abiss": "habis",
    "prlu": "perlu",
    "coyyy": "coy",
    "suaranyaa": "suaranya",
    "jnagn": "jangan",
    "kcwa": "kecewa",
    "jaman2": "jaman-jaman",
    "sok2an": "sok-sokan",
    "dket2in": "dekat-dekati",
    "cobak": "coba",
    "britanya": "beritanya",
    "tau2": "tau-tau",
    "mahh": "mah",
    "jamam": "jaman",
    "paraa": "para",
    "seharusny": "seharusnya",
    "dasaar": "dasar",
    "bergunaa": "berguna",
    "mulutnyaaa": "mulutnya",
    "blkng": "belakang",
    "kcewa": "kecewa",
    "mnusuk": "menusuk",
    "blkang": "belakang",
    "nembak": "menembak",
    "trmanis": "termanis",
    "krng": "kurang",
    "kaciiaann": "kasihan",
    "nyela": "mencela",
    "ngejilat": "menjilat",
    "hallooo": "halo",
    "deketin": "dekati",
    "tayik": "tahi",
    "halooo": "halo",
    "ustzah": "ustazah",
    "halow": "halo",
    "poooolllll": "pol",
    "tahannn": "tahan",
    "aduuh": "aduh",
    "nyimpen": "menyimpan",
    "ngarsipin": "mengarsipkan",
    "cman": "cuman",
    "gituuuuu": "begitu",
    "kyy": "kaya",
    "kngn": "kangen",
    "kq": "kok",
    "nyesek": "menyesak",
    "rinduuuuuuu": "rindu",
    "b2": "berdua",
    "kangeeeennn": "kangen",
    "mg": "moga",
    "aamiiiiinnn": "amin",
    "gemezzzz": "gemas",
    "kangennnnnn": "kangen",
    "prh": "parah",
    "bakattt": "bakat",
    "napsuu": "napsu",
    "gmau": "enggak mau",
    "luccu": "lucu",
    "prasaan": "perasaan",
    "lahirr": "lahir",
    "setujuuuu": "setuju",
    "sering2": "sering-sering",
    "ceemen": "cemen",
    'sembunyi""': "sembunyi-sembunyi",
    "skrnh": "sekarang",
    "cerdiik": "cerdik",
    "jeniuss": "jenius",
    "kurangin": "kurangi",
    "kreen": "keren",
    "s'lalu": "selalu",
    "mauuuuuu": "mau",
    "mintk": "minta",
    "nyolong": "mencolong",
    "pnjng": "panjang",
    "slaluuuuu": "selalu",
    "kanggggg": "kang",
    "rezeqinya": "rezekinya",
    "pintr": "pintar",
    "dekk": "dek",
    "maw": "mau",
    "kura2": "kura-kura",
    "edaaann": "edan",
    "nempel": "menempel",
    "hatiiii": "hati",
    "sukkaa": "suka",
    "luuuucuuu": "lucu",
    "caantiiik": "cantik",
    "luucuuu": "lucu",
    "putihh": "putih",
    'terus"an': "terus-terusan",
    "siiih": "sih",
    "ternyataa": "ternyata",
    "pollll": "pol",
    "sekaliiii": "sekali",
    "peduliin": "mempedulikan",
    "komntr": "komentar",
    "smngat": "semangat",
    "dosax": "dosanya",
    "pahalax": "pahalanya",
    "akhirt": "akhirat",
    "tinggalkn": "tinggalkan",
    "rumh": "rumah",
    "mk": "maka",
    "trhtung": "terhitung",
    "naaaa": "nya",
    "ademmm": "adem",
    "cerdass": "cerdas",
    "tambahh": "tambah",
    "polll": "pol",
    "didengerin": "didengarkan",
    "mantapppppp": "mantap",
    "ngerespon": "merespons",
    "dulurrr": "dulur",
    "brusaha": "berusaha",
    "lebh": "lebih",
    "amin2": "amin-amin",
    "positippp": "positif",
    "jauuhhh": "jauh",
    "brhjb": "berhijab",
    "mdh2n": "mudah-mudahan",
    "slmnya": "salamnya",
    "jlbb": "jilbab",
    "dempga": "semoga",
    "selmnya": "selamanya",
    "tth": "teteh",
    "otot2": "otot-otot",
    "lengkeeett": "lengket",
    "caaannnttiikkk": "cantik",
    "trusss": "terus",
    "ademm": "adem",
    "apalagiii": "apalagi",
    "passs": "pas",
    "beginii": "begini",
    "satuu": "satu",
    "cuantek": "cantik",
    "akuuuur": "akur",
    "iniehh": "ini",
    "sayangx": "sayangnya",
    "jodohx": "jodohnya",
    "kaliaan": "kalian",
    "haslnya": "hasilnya",
    "kencng": "kencang",
    "pmbantu": "pembantu",
    "kmbl": "kembali",
    "cuchook": "cocok",
    "kloop": "klop",
    "sempurnaa": "sempurna",
    "klihatan": "kelihatan",
    "cintax": "cintanya",
    "pnuh": "penuh",
    "ngrti": "mengerti",
    'mudah"an': "mudah-mudahan",
    'segala"ny': "segala-galanya",
    "mantanny": "mantannya",
    "jodohny": "jodohnya",
    "cantk": "cantik",
    "ituuu": "itu",
    "kaasian": "kasihan",
    "padhl": "padahal",
    'ank"': "anak-anak",
    "pkrin": "pikirkan",
    "anakx": "anaknya",
    "sia2kan": "sia-siakan",
    "naaahhh": "nah",
    "beluumm": "belum",
    "sayangggq": "sayangku",
    "kreean": "keren",
    "ciiieee": "cie",
    "cieee": "cie",
    "cieeee": "cie",
    "berenanh": "berenang",
    "pacarr": "pacar",
    "bingitss": "banget",
    "besokkk": "besok",
    "annnnjjjjjjrrrr": "anjir",
    "ngeliatin": "melihati",
    "ngumbar2": "mengumbar-umbar",
    "romantiss": "romantis",
    "cocook": "cocok",
    "lucuuuuuuuu": "lucu",
    "kaaaaaann": "kan",
    "nyaaaaaaa": "nya",
    "lgs": "langsung",
    "yaang": "yang",
    "bangedt": "banget",
    "gde": "gede",
    "lutunaaa": "lucunya",
    "bikinnn": "bikin",
    "keee": "ke",
    "bungkuuussss": "bungkus",
    "lucux": "lucunya",
    "bntr": "bentar",
    "buanyaaak": "banyak",
    "aaamiiinnn": "amin",
    "aaamiiin": "amin",
    "ntap": "mantap",
    "abgnyaah": "abangnya",
    "mungkiin": "mungkin",
    "akuhh": "aku",
    "manteb": "mantap",
    "hiduupppp": "hidup",
    "tebel": "tebal",
    "nganggepin": "menanggapi",
    'mentang"': "mentang-mentang",
    "najiss": "najis",
    "perjabatt": "pejabat",
    "makany": "makanya",
    "benneeeeeerr": "benar",
    "krjaan": "pekerjaan",
    "kdng": "kadang",
    "kdang": "kadang",
    "knan": "kanan",
    "anak'y": "anaknya",
    "trknal": "terkenal",
    'gtu"': "begitu-gitu",
    "klok": "kalo",
    "aamiiiinnnnn": "amin",
    "pengennnn": "pengin",
    "guw": "gue",
    "siiiiiiippppppppp": "sip",
    "selaloe": "selalu",
    "donggg": "dong",
    "beruntungnyaaaa": "beruntungnya",
    "soal'y": "soalnya",
    "prhatian": "perhatian",
    "hebaat": "hebat",
    "ampunn": "ampun",
    "gueeeee": "gue",
    "liatt": "lihat",
    "gehh": "gih",
    "ankknyaaa": "anaknya",
    "centilnyaaaaaa": "centilnya",
    "gemesshzzzzhzzhzhzhsjssjs": "gemas",
    "ngacaaa": "mengaca",
    "diaaa": "dia",
    "jirr": "anjir",
    "kayaa": "kaya",
    "cempreeng": "cempreng",
    "centillll": "centil",
    "pcran": "pacaran",
    "anedh": "banget",
    "ampyunnnn": "ampun",
    "boro2": "boro-boro",
    "nyta": "nyata",
    "kampungn": "kampungan",
    "j": "saja",
    "mnghina": "menghina",
    "ngolokin": "mengolok",
    "blum": "belum",
    'syirik"': "syirik-syirik",
    "than": "tahan",
    "dsr": "dasar",
    "siriik": "sirik",
    "mampuuu": "mampu",
    "khan": "kan",
    "aduuhh": "aduh",
    "cemburuu": "cemburu",
    "bingitzzzz": "banget",
    "tlog": "tolong",
    "apasihhh": "apasih",
    "sirikk": "sirik",
    "dbnding": "dibanding",
    "nrka": "neraka",
    "s3ndiri": "sendiri",
    "bhgiain": "membahagiakan",
    "kdua": "kedua",
    "prcya": "percaya",
    "bhagaia": "bahagia",
    "cuco": "cocok",
    "genittt": "genit",
    "kx": "kak",
    "mlikk": "milik",
    'mentah"': "mentah-mentah",
    "canci": "cantik",
    "aneed": "banget",
    "gimanaa": "bagaimana",
    "lainnn": "lain",
    "pentingg": "penting",
    "bagaimanaaa": "bagaimana",
    "krudung": "kerudung",
    "enakkkkk": "enak",
    "poool": "pol",
    "jirrrr": "anjir",
    "oprasiya": "operasinya",
    "uwee": "gue",
    "pilihannny": "pilihannya",
    "itumahh": "itumah",
    "muuuu": "mu",
    "uuhhh": "uh",
    "berbakiti": "berbakti",
    "alhamd": "alhamdulillah",
    "slmttt": "selamat",
    "ucapin": "mengucapkan",
    "tetp": "tetap",
    "ditengah2": "ditengah-tengah",
    "semuanyaa": "semuanya",
    "semuannyaaa": "semuanya",
    "aminn2": "amin-amin",
    "abs": "habis",
    "kebnyak'an": "kebanyakan",
    "melahirin": "melahirkan",
    "aduuuh": "aduh",
    "cakeep": "cakep",
    "lhooo": "loh",
    "kamuuuu": "kamu",
    "bagi2": "bagi-bagi",
    "gimn": "bagaimana",
    "smogaaa": "semoga",
    "biza": "bisa",
    "aamien": "amien",
    "lngsing": "langsing",
    "wowoooww": "wow",
    "smulla": "semula",
    "pdhall": "padahal",
    "blln": "bulan",
    "senang2": "senang-senang",
    "jh": "saja",
    "kereeennnn": "keren",
    "gilakkk": "gila",
    "gtu2": "begitu-gitu",
    "cpet": "cepat",
    "gataunya": "enggak taunya",
    "gtau": "enggak tau",
    "fans2": "fan-fan",
    "gaharus": "enggak harus",
}
