# JLua - Basic - Package

## Description

This package enables Json-like Lua usement for Python3.  
It enables converting python Objects into Lua.  
For evaluation, the package uses its defined requirement 'lupa'.  

## Functions

### Help Functions

#### Sumstring(table : list) -> str
Connects all the strings in the list to a single string, optimal for the output of JLua.GetLuaString()  
__Params:__
 - table : list :: A string list like generated by readlines() or GetLuaString()
```.py
from JLua import SumString, GetLuaString

print(GetLuaString({ "test" : [10, 20, 30], "var" : "string" })
# Output >>> ['{\n', '    test = { 10, 20, 30, },\n', '    var = "string",\n', '}'])

print(SumString(GetLuaString({ "nice" : [10, 20, 30], "var" : "string" })))
""" Output:
{
    test = { 10, 20, 30, },
    var = "string",
}
"""
```

### Python to Lua

#### GetLuaString( obj ) -> list
The main converting function. Can convert the basic types, if the type(obj) is not one of the basic python types, the function tries to get the repr of the obj  
( In future times there will be a universal Lua-Repr funktion to easily convert user-defined classes to Lua )  
__Params:__
 - obj :: Can be any object, but stick to the convertion rules
```.py
from JLua import GetLuaString, SumString

objInt = 1
objString = "objString"
objList = [ objInt, objString ]
objDict = { "objInt" : objInt, "objString" : objString, "objList" : objList }

print(SumString(GetLuaString(objInt))) 
# Output >>> 1
print(SumString(GetLuaString(objString))) 
# Output >>> "objString"
print(SumString(GetLuaString(objList))) 
# Output >>> { 1, "objString", }
print(SumString(GetLuaString(objDict))) 
""" Output
{
    objInt = 1,
    objString = "objString",
    objList = { 1, "objString", },
}
"""
```

### Lua to Python

#### DecodeToDict( luaString : str = "", useDecoded : bool = False, decoded = None ) -> dict
Decode a Lua-Table to a python-Dict  
__Params:__
 - luastring : str = "" :: The LuaCode to eval to a Lua-Table and edit the return dictionary
 - useDecoded : bool = False :: True if a pre-evaluated Lua-table 
 - decoded = None :: The already decoded table, mostly used for the algroythm itself
    
```.lua
-- ./example.lua 
{
    objInt = 10,
    objString = "string",
    objList = { 10, "string" },
}
```
```.py
# ./main.py
from JLua import DecodeToDict

print(DecodeToDict(open("example.py").read()))
# Output >>> {'objList': {0: 10, 1: 'string'}, 'objInt': 10, 'objString': 'string'}  or in other order
```

#### DecodeToClass( luaString : str, configClass = JLua.LuaCreatedClass(), useDecoded : bool = False, decoded = None) -> JLua.LuaCreatedClass   ! WIP !
Decode a Lua-Table to a python-Class  
AutoClass: JLua.LuaCreatedClass  
__Params:__
 - luastring : str = "" :: The LuaCode to eval to a Lua-Table and edit the return dictionary
 - configClass = JLua.LuaCreatedClass() :: The class to set the in the table given args to
 - useDecoded : bool = False :: True if a pre-evaluated Lua-table should be used
 - decoded = None :: The already decoded table, mostly used for the algroythm itself

```.lua
-- ./example.lua 
{
    objInt = 10,
    objString = "string",
    objList = { "string" : 10 },
}
```
```.py
# ./main.py
from JLua import DecodeToClass

print( DecodeToClass(open("example.py").read()).objInt, DecodeToClass(open("example.py").read()).objString )
# Output >>> 10  string
```