from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.1'
DESCRIPTION = 'Classifies senteces as logs or not'

# Setting up
setup(
    name="logsclassifier",
    version=VERSION,
    author="madhav47",
    author_email="madhav.vats@codenation.co.in",
    description=DESCRIPTION,
    packages=find_packages(),
    install_requires=['numpy', 'pandas','boto3',  'typing'],
    keywords=['python', 'logs', 'parsing'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)
