# generated by update to not change manually
import typing as t

from bungieapi.base import AppClient, clean_query_value
from bungieapi.forge import forge
from bungieapi.generated.components.responses import (
    IEnumerableOfApplicationClientResponse,
)
from bungieapi.generated.components.responses.applications import ApiUsageClientResponse


class Client(AppClient):
    async def get_application_api_usage(
        self,
        application_id: int,
        end: t.Optional[str] = None,
        start: t.Optional[str] = None,
    ) -> ApiUsageClientResponse:
        """Get API usage by application for time frame specified.

        You can go as far back as 30 days ago, and can ask for up to a 48 hour window of time in a single request. You must be authenticated with at least the ReadUserData permission to access this endpoint.
        Parameters:
            application_id: ID of the application to get usage statistics.
            end: End time for query. Goes to now if not specified.
            start: Start time for query. Goes to 24 hours ago if not specified.
        """
        query = {"end": end, "start": start}
        result = await self.get(
            path=f"/App/ApiUsage/{clean_query_value(application_id)}/",
            query=query,
        )
        return forge(ApiUsageClientResponse, result)

    async def get_bungie_applications(
        self,
    ) -> IEnumerableOfApplicationClientResponse:
        """Get list of applications created by Bungie."""
        query = None
        result = await self.get(
            path="/App/FirstParty/",
            query=query,
        )
        return forge(IEnumerableOfApplicationClientResponse, result)
