# generated by update to not change manually
from bungieapi.base import BaseClient, clean_query_value
from bungieapi.forge import forge
from bungieapi.generated.components.responses.forum import PostSearchClientResponse
from bungieapi.generated.components.schemas.forum import (
    CommunityContentSortMode,
    ForumTopicsCategoryFiltersEnum,
)


class Client(BaseClient):
    async def get_community_content(
        self,
        media_filter: "ForumTopicsCategoryFiltersEnum",
        page: int,
        sort: "CommunityContentSortMode",
    ) -> PostSearchClientResponse:
        """Returns community content.

        Parameters:
            media_filter: The type of media to get
            page: Zero based page
            sort: The sort mode.
        """
        query = None
        result = await self.get(
            path=f"/CommunityContent/Get/{clean_query_value(sort)}/{clean_query_value(media_filter)}/{clean_query_value(page)}/",
            query=query,
        )
        return forge(PostSearchClientResponse, result)
