# generated by update to not change manually
import typing as t

from bungieapi.base import BaseClient, clean_query_value
from bungieapi.forge import forge
from bungieapi.generated.components.responses import (
    DictionaryOfuint32AndDestinyPublicMilestoneClientResponse,
    IEnumerableOfUserInfoCardClientResponse,
    ListOfDestinyClanAggregateStatClientResponse,
    ReadOnlyDictionaryOfstringAndDestinyHistoricalStatsDefinitionClientResponse,
    int32ClientResponse,
)
from bungieapi.generated.components.responses.config.clan_banner import (
    ClanBannerSourceClientResponse,
)
from bungieapi.generated.components.responses.destiny import (
    DestinyEquipItemResultsClientResponse,
)
from bungieapi.generated.components.responses.destiny.advanced import (
    AwaAuthorizationResultClientResponse,
    AwaInitializeClientResponse,
)
from bungieapi.generated.components.responses.destiny.config import (
    DestinyManifestClientResponse,
)
from bungieapi.generated.components.responses.destiny.definitions import (
    DestinyDefinitionClientResponse,
    DestinyEntitySearchResultClientResponse,
)
from bungieapi.generated.components.responses.destiny.historical_stats import (
    DestinyActivityHistoryResultsClientResponse,
    DestinyAggregateActivityResultsClientResponse,
    DestinyHistoricalStatsAccountResultClientResponse,
    DestinyHistoricalStatsResultsClientResponse,
    DestinyHistoricalWeaponStatsDataClientResponse,
    DestinyLeaderboardResultsClientResponse,
    DestinyPostGameCarnageReportDataClientResponse,
)
from bungieapi.generated.components.responses.destiny.milestones import (
    DestinyMilestoneClientResponse,
    DestinyMilestoneContentClientResponse,
)
from bungieapi.generated.components.responses.destiny.responses import (
    DestinyCharacterClientResponse,
    DestinyCollectibleNodeDetailClientResponse,
    DestinyItemChangeClientResponse,
    DestinyItemClientResponse,
    DestinyLinkedProfilesClientResponse,
    DestinyProfileClientResponse,
    DestinyPublicVendorsClientResponse,
    DestinyVendorClientResponse,
    DestinyVendorsClientResponse,
)
from bungieapi.generated.components.schemas import BungieMembershipType
from bungieapi.generated.components.schemas.destiny import (
    DestinyComponentType,
    DestinyVendorFilter,
)
from bungieapi.generated.components.schemas.destiny.advanced import (
    AwaPermissionRequested,
    AwaUserResponse,
)
from bungieapi.generated.components.schemas.destiny.historical_stats.definitions import (
    DestinyActivityModeType,
    DestinyStatsGroupType,
    PeriodType,
)
from bungieapi.generated.components.schemas.destiny.reporting.requests import (
    DestinyReportOffensePgcrRequest,
)
from bungieapi.generated.components.schemas.destiny.requests import (
    DestinyItemTransferRequest,
)
from bungieapi.generated.components.schemas.destiny.requests.actions import (
    DestinyInsertPlugsActionRequest,
    DestinyInsertPlugsFreeActionRequest,
    DestinyItemActionRequest,
    DestinyItemSetActionRequest,
    DestinyItemStateRequest,
    DestinyPostmasterTransferRequest,
)
from bungieapi.generated.components.schemas.user import ExactSearchRequest


class Client(BaseClient):
    async def get_destiny_manifest(
        self,
    ) -> DestinyManifestClientResponse:
        """Returns the current version of the manifest as a json object."""
        query = None
        result = await self.get(
            path="/Destiny2/Manifest/",
            query=query,
        )
        return forge(DestinyManifestClientResponse, result)

    async def get_destiny_entity_definition(
        self,
        entity_type: str,
        hash_identifier: int,
    ) -> DestinyDefinitionClientResponse:
        """Returns the static definition of an entity of the given Type and
        hash identifier.

        Examine the API Documentation for the Type Names of entities that have their own definitions. Note that the return type will always *inherit from* DestinyDefinition, but the specific type returned will be the requested entity type if it can be found. Please don't use this as a chatty alternative to the Manifest database if you require large sets of data, but for simple and one-off accesses this should be handy.
        Parameters:
            entity_type: The type of entity for whom you would like results. These correspond to the entity's definition contract name. For instance, if you are looking for items, this property should be 'DestinyInventoryItemDefinition'. PREVIEW: This endpoint is still in beta, and may experience rough edges. The schema is tentatively in final form, but there may be bugs that prevent desirable operation.
            hash_identifier: The hash identifier for the specific Entity you want returned.
        """
        query = None
        result = await self.get(
            path=f"/Destiny2/Manifest/{clean_query_value(entity_type)}/{clean_query_value(hash_identifier)}/",
            query=query,
        )
        return forge(DestinyDefinitionClientResponse, result)

    async def search_destiny_player_by_bungie_name(
        self,
        request: "ExactSearchRequest",
        membership_type: "BungieMembershipType",
    ) -> IEnumerableOfUserInfoCardClientResponse:
        """Returns a list of Destiny memberships given a global Bungie Display
        Name.

        This method will hide overridden memberships due to cross save.
        Parameters:
            membership_type: A valid non-BungieNet membership type, or All. Indicates which memberships to return. You probably want this set to All.
        """
        query = None
        result = await self.post(
            path=f"/Destiny2/SearchDestinyPlayerByBungieName/{clean_query_value(membership_type)}/",
            query=query,
            request=request,
        )
        return forge(IEnumerableOfUserInfoCardClientResponse, result)

    async def get_linked_profiles(
        self,
        membership_id: int,
        membership_type: "BungieMembershipType",
        get_all_memberships: t.Optional[bool] = None,
    ) -> DestinyLinkedProfilesClientResponse:
        """Returns a summary information about all profiles linked to the
        requesting membership type/membership ID that have valid Destiny
        information.

        The passed-in Membership Type/Membership ID may be a Bungie.Net membership or a Destiny membership. It only returns the minimal amount of data to begin making more substantive requests, but will hopefully serve as a useful alternative to UserServices for people who just care about Destiny data. Note that it will only return linked accounts whose linkages you are allowed to view.
        Parameters:
            get_all_memberships: (optional) if set to 'true', all memberships regardless of whether they're obscured by overrides will be returned. Normal privacy restrictions on account linking will still apply no matter what.
            membership_id: The ID of the membership whose linked Destiny accounts you want returned. Make sure your membership ID matches its Membership Type: don't pass us a PSN membership ID and the XBox membership type, it's not going to work!
            membership_type: The type for the membership whose linked Destiny accounts you want returned.
        """
        query = {"getAllMemberships": get_all_memberships}
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Profile/{clean_query_value(membership_id)}/LinkedProfiles/",
            query=query,
        )
        return forge(DestinyLinkedProfilesClientResponse, result)

    async def get_profile(
        self,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
        components: t.Optional[t.Sequence["DestinyComponentType"]] = None,
    ) -> DestinyProfileClientResponse:
        """Returns Destiny Profile information for the supplied membership.

        Parameters:
            components: A comma separated list of components to return (as strings or numeric values). See the DestinyComponentType enum for valid components to request. You must request at least one component to receive results.
            destiny_membership_id: Destiny membership ID.
            membership_type: A valid non-BungieNet membership type.
        """
        query = {"components": components}
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Profile/{clean_query_value(destiny_membership_id)}/",
            query=query,
        )
        return forge(DestinyProfileClientResponse, result)

    async def get_character(
        self,
        character_id: int,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
        components: t.Optional[t.Sequence["DestinyComponentType"]] = None,
    ) -> DestinyCharacterClientResponse:
        """Returns character information for the supplied character.

        Parameters:
            character_id: ID of the character.
            components: A comma separated list of components to return (as strings or numeric values). See the DestinyComponentType enum for valid components to request. You must request at least one component to receive results.
            destiny_membership_id: Destiny membership ID.
            membership_type: A valid non-BungieNet membership type.
        """
        query = {"components": components}
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Profile/{clean_query_value(destiny_membership_id)}/Character/{clean_query_value(character_id)}/",
            query=query,
        )
        return forge(DestinyCharacterClientResponse, result)

    async def get_clan_weekly_reward_state(
        self,
        group_id: int,
    ) -> DestinyMilestoneClientResponse:
        """Returns information on the weekly clan rewards and if the clan has
        earned them or not.

        Note that this will always report rewards as not redeemed.
        Parameters:
            group_id: A valid group id of clan.
        """
        query = None
        result = await self.get(
            path=f"/Destiny2/Clan/{clean_query_value(group_id)}/WeeklyRewardState/",
            query=query,
        )
        return forge(DestinyMilestoneClientResponse, result)

    async def get_clan_banner_source(
        self,
    ) -> ClanBannerSourceClientResponse:
        """Returns the dictionary of values for the Clan Banner."""
        query = None
        result = await self.get(
            path="/Destiny2/Clan/ClanBannerDictionary/",
            query=query,
        )
        return forge(ClanBannerSourceClientResponse, result)

    async def get_item(
        self,
        destiny_membership_id: int,
        item_instance_id: int,
        membership_type: "BungieMembershipType",
        components: t.Optional[t.Sequence["DestinyComponentType"]] = None,
    ) -> DestinyItemClientResponse:
        """Retrieve the details of an instanced Destiny Item.

        An instanced Destiny item is one with an ItemInstanceId. Non-instanced items, such as materials, have no useful instance-specific details and thus are not queryable here.
        Parameters:
            components: A comma separated list of components to return (as strings or numeric values). See the DestinyComponentType enum for valid components to request. You must request at least one component to receive results.
            destiny_membership_id: The membership ID of the destiny profile.
            item_instance_id: The Instance ID of the destiny item.
            membership_type: A valid non-BungieNet membership type.
        """
        query = {"components": components}
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Profile/{clean_query_value(destiny_membership_id)}/Item/{clean_query_value(item_instance_id)}/",
            query=query,
        )
        return forge(DestinyItemClientResponse, result)

    async def get_vendors(
        self,
        character_id: int,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
        components: t.Optional[t.Sequence["DestinyComponentType"]] = None,
        filter: t.Optional["DestinyVendorFilter"] = None,
    ) -> DestinyVendorsClientResponse:
        """Get currently available vendors from the list of vendors that can
        possibly have rotating inventory.

        Note that this does not include things like preview vendors and vendors-as-kiosks, neither of whom have rotating/dynamic inventories. Use their definitions as-is for those.
        Parameters:
            character_id: The Destiny Character ID of the character for whom we're getting vendor info.
            components: A comma separated list of components to return (as strings or numeric values). See the DestinyComponentType enum for valid components to request. You must request at least one component to receive results.
            destiny_membership_id: Destiny membership ID of another user. You may be denied.
            filter: The filter of what vendors and items to return, if any.
            membership_type: A valid non-BungieNet membership type.
        """
        query = {"components": components, "filter": filter}
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Profile/{clean_query_value(destiny_membership_id)}/Character/{clean_query_value(character_id)}/Vendors/",
            query=query,
        )
        return forge(DestinyVendorsClientResponse, result)

    async def get_vendor(
        self,
        character_id: int,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
        vendor_hash: int,
        components: t.Optional[t.Sequence["DestinyComponentType"]] = None,
    ) -> DestinyVendorClientResponse:
        """Get the details of a specific Vendor.

        Parameters:
            character_id: The Destiny Character ID of the character for whom we're getting vendor info.
            components: A comma separated list of components to return (as strings or numeric values). See the DestinyComponentType enum for valid components to request. You must request at least one component to receive results.
            destiny_membership_id: Destiny membership ID of another user. You may be denied.
            membership_type: A valid non-BungieNet membership type.
            vendor_hash: The Hash identifier of the Vendor to be returned.
        """
        query = {"components": components}
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Profile/{clean_query_value(destiny_membership_id)}/Character/{clean_query_value(character_id)}/Vendors/{clean_query_value(vendor_hash)}/",
            query=query,
        )
        return forge(DestinyVendorClientResponse, result)

    async def get_public_vendors(
        self,
        components: t.Optional[t.Sequence["DestinyComponentType"]] = None,
    ) -> DestinyPublicVendorsClientResponse:
        """Get items available from vendors where the vendors have items for
        sale that are common for everyone.

        If any portion of the Vendor's available inventory is character or account specific, we will be unable to return their data from this endpoint due to the way that available inventory is computed. As I am often guilty of saying: 'It's a long story...'
        Parameters:
            components: A comma separated list of components to return (as strings or numeric values). See the DestinyComponentType enum for valid components to request. You must request at least one component to receive results.
        """
        query = {"components": components}
        result = await self.get(
            path="/Destiny2/Vendors/",
            query=query,
        )
        return forge(DestinyPublicVendorsClientResponse, result)

    async def get_collectible_node_details(
        self,
        character_id: int,
        collectible_presentation_node_hash: int,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
        components: t.Optional[t.Sequence["DestinyComponentType"]] = None,
    ) -> DestinyCollectibleNodeDetailClientResponse:
        """Given a Presentation Node that has Collectibles as direct
        descendants, this will return item details about those descendants in
        the context of the requesting character.

        Parameters:
            character_id: The Destiny Character ID of the character for whom we're getting collectible detail info.
            collectible_presentation_node_hash: The hash identifier of the Presentation Node for whom we should return collectible details. Details will only be returned for collectibles that are direct descendants of this node.
            components: A comma separated list of components to return (as strings or numeric values). See the DestinyComponentType enum for valid components to request. You must request at least one component to receive results.
            destiny_membership_id: Destiny membership ID of another user. You may be denied.
            membership_type: A valid non-BungieNet membership type.
        """
        query = {"components": components}
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Profile/{clean_query_value(destiny_membership_id)}/Character/{clean_query_value(character_id)}/Collectibles/{clean_query_value(collectible_presentation_node_hash)}/",
            query=query,
        )
        return forge(DestinyCollectibleNodeDetailClientResponse, result)

    async def transfer_item(
        self,
        request: "DestinyItemTransferRequest",
    ) -> int32ClientResponse:
        """Transfer an item to/from your vault.

        You must have a valid Destiny account. You must also pass BOTH a
        reference AND an instance ID if it's an instanced item.
        itshappening.gif
        """
        query = None
        result = await self.post(
            path="/Destiny2/Actions/Items/TransferItem/", query=query, request=request
        )
        return forge(int32ClientResponse, result)

    async def pull_from_postmaster(
        self,
        request: "DestinyPostmasterTransferRequest",
    ) -> int32ClientResponse:
        """Extract an item from the Postmaster, with whatever implications that
        may entail.

        You must have a valid Destiny account. You must also pass BOTH a
        reference AND an instance ID if it's an instanced item.
        """
        query = None
        result = await self.post(
            path="/Destiny2/Actions/Items/PullFromPostmaster/",
            query=query,
            request=request,
        )
        return forge(int32ClientResponse, result)

    async def equip_item(
        self,
        request: "DestinyItemActionRequest",
    ) -> int32ClientResponse:
        """Equip an item.

        You must have a valid Destiny Account, and either be in a social
        space, in orbit, or offline.
        """
        query = None
        result = await self.post(
            path="/Destiny2/Actions/Items/EquipItem/", query=query, request=request
        )
        return forge(int32ClientResponse, result)

    async def equip_items(
        self,
        request: "DestinyItemSetActionRequest",
    ) -> DestinyEquipItemResultsClientResponse:
        """Equip a list of items by itemInstanceIds.

        You must have a valid Destiny Account, and either be in a social
        space, in orbit, or offline. Any items not found on your
        character will be ignored.
        """
        query = None
        result = await self.post(
            path="/Destiny2/Actions/Items/EquipItems/", query=query, request=request
        )
        return forge(DestinyEquipItemResultsClientResponse, result)

    async def set_item_lock_state(
        self,
        request: "DestinyItemStateRequest",
    ) -> int32ClientResponse:
        """Set the Lock State for an instanced item.

        You must have a valid Destiny Account.
        """
        query = None
        result = await self.post(
            path="/Destiny2/Actions/Items/SetLockState/", query=query, request=request
        )
        return forge(int32ClientResponse, result)

    async def set_quest_tracked_state(
        self,
        request: "DestinyItemStateRequest",
    ) -> int32ClientResponse:
        """Set the Tracking State for an instanced item, if that item is a
        Quest or Bounty.

        You must have a valid Destiny Account. Yeah, it's an item.
        """
        query = None
        result = await self.post(
            path="/Destiny2/Actions/Items/SetTrackedState/",
            query=query,
            request=request,
        )
        return forge(int32ClientResponse, result)

    async def insert_socket_plug(
        self,
        request: "DestinyInsertPlugsActionRequest",
    ) -> DestinyItemChangeClientResponse:
        """Insert a plug into a socketed item.

        I know how it sounds, but I assure you it's much more G-rated
        than you might be guessing. We haven't decided yet whether this
        will be able to insert plugs that have side effects, but if we
        do it will require special scope permission for an application
        attempting to do so. You must have a valid Destiny Account, and
        either be in a social space, in orbit, or offline. Request must
        include proof of permission for 'InsertPlugs' from the account
        owner.
        """
        query = None
        result = await self.post(
            path="/Destiny2/Actions/Items/InsertSocketPlug/",
            query=query,
            request=request,
        )
        return forge(DestinyItemChangeClientResponse, result)

    async def insert_socket_plug_free(
        self,
        request: "DestinyInsertPlugsFreeActionRequest",
    ) -> DestinyItemChangeClientResponse:
        """Insert a 'free' plug into an item's socket.

        This does not require 'Advanced Write Action' authorization and
        is available to 3rd-party apps, but will only work on 'free and
        reversible' socket actions (Perks, Armor Mods, Shaders,
        Ornaments, etc.). You must have a valid Destiny Account, and the
        character must either be in a social space, in orbit, or
        offline.
        """
        query = None
        result = await self.post(
            path="/Destiny2/Actions/Items/InsertSocketPlugFree/",
            query=query,
            request=request,
        )
        return forge(DestinyItemChangeClientResponse, result)

    async def get_post_game_carnage_report(
        self,
        activity_id: int,
    ) -> DestinyPostGameCarnageReportDataClientResponse:
        """Gets the available post game carnage report for the activity ID.

        Parameters:
            activity_id: The ID of the activity whose PGCR is requested.
        """
        query = None
        result = await self.get(
            path=f"/Destiny2/Stats/PostGameCarnageReport/{clean_query_value(activity_id)}/",
            query=query,
        )
        return forge(DestinyPostGameCarnageReportDataClientResponse, result)

    async def report_offensive_post_game_carnage_report_player(
        self,
        request: "DestinyReportOffensePgcrRequest",
        activity_id: int,
    ) -> int32ClientResponse:
        """Report a player that you met in an activity that was engaging in
        ToS-violating activities.

        Both you and the offending player must have played in the activityId passed in. Please use this judiciously and only when you have strong suspicions of violation, pretty please.
        Parameters:
            activity_id: The ID of the activity where you ran into the brigand that you're reporting.
        """
        query = None
        result = await self.post(
            path=f"/Destiny2/Stats/PostGameCarnageReport/{clean_query_value(activity_id)}/Report/",
            query=query,
            request=request,
        )
        return forge(int32ClientResponse, result)

    async def get_historical_stats_definition(
        self,
    ) -> ReadOnlyDictionaryOfstringAndDestinyHistoricalStatsDefinitionClientResponse:
        """Gets historical stats definitions."""
        query = None
        result = await self.get(
            path="/Destiny2/Stats/Definition/",
            query=query,
        )
        return forge(
            ReadOnlyDictionaryOfstringAndDestinyHistoricalStatsDefinitionClientResponse,
            result,
        )

    async def get_clan_leaderboards(
        self,
        group_id: int,
        maxtop: t.Optional[int] = None,
        modes: t.Optional[str] = None,
        statid: t.Optional[str] = None,
    ) -> DestinyLeaderboardResultsClientResponse:
        """Gets leaderboards with the signed in user's friends and the supplied
        destinyMembershipId as the focus.

        PREVIEW: This endpoint is still in beta, and may experience rough edges. The schema is in final form, but there may be bugs that prevent desirable operation.
        Parameters:
            group_id: Group ID of the clan whose leaderboards you wish to fetch.
            maxtop: Maximum number of top players to return. Use a large number to get entire leaderboard.
            modes: List of game modes for which to get leaderboards. See the documentation for DestinyActivityModeType for valid values, and pass in string representation, comma delimited.
            statid: ID of stat to return rather than returning all Leaderboard stats.
        """
        query = {"maxtop": maxtop, "modes": modes, "statid": statid}
        result = await self.get(
            path=f"/Destiny2/Stats/Leaderboards/Clans/{clean_query_value(group_id)}/",
            query=query,
        )
        return forge(DestinyLeaderboardResultsClientResponse, result)

    async def get_clan_aggregate_stats(
        self,
        group_id: int,
        modes: t.Optional[str] = None,
    ) -> ListOfDestinyClanAggregateStatClientResponse:
        """Gets aggregated stats for a clan using the same categories as the
        clan leaderboards.

        PREVIEW: This endpoint is still in beta, and may experience rough edges. The schema is in final form, but there may be bugs that prevent desirable operation.
        Parameters:
            group_id: Group ID of the clan whose leaderboards you wish to fetch.
            modes: List of game modes for which to get leaderboards. See the documentation for DestinyActivityModeType for valid values, and pass in string representation, comma delimited.
        """
        query = {"modes": modes}
        result = await self.get(
            path=f"/Destiny2/Stats/AggregateClanStats/{clean_query_value(group_id)}/",
            query=query,
        )
        return forge(ListOfDestinyClanAggregateStatClientResponse, result)

    async def get_leaderboards(
        self,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
        maxtop: t.Optional[int] = None,
        modes: t.Optional[str] = None,
        statid: t.Optional[str] = None,
    ) -> DestinyLeaderboardResultsClientResponse:
        """Gets leaderboards with the signed in user's friends and the supplied
        destinyMembershipId as the focus.

        PREVIEW: This endpoint has not yet been implemented. It is being returned for a preview of future functionality, and for public comment/suggestion/preparation.
        Parameters:
            destiny_membership_id: The Destiny membershipId of the user to retrieve.
            maxtop: Maximum number of top players to return. Use a large number to get entire leaderboard.
            membership_type: A valid non-BungieNet membership type.
            modes: List of game modes for which to get leaderboards. See the documentation for DestinyActivityModeType for valid values, and pass in string representation, comma delimited.
            statid: ID of stat to return rather than returning all Leaderboard stats.
        """
        query = {"maxtop": maxtop, "modes": modes, "statid": statid}
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Account/{clean_query_value(destiny_membership_id)}/Stats/Leaderboards/",
            query=query,
        )
        return forge(DestinyLeaderboardResultsClientResponse, result)

    async def get_leaderboards_for_character(
        self,
        character_id: int,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
        maxtop: t.Optional[int] = None,
        modes: t.Optional[str] = None,
        statid: t.Optional[str] = None,
    ) -> DestinyLeaderboardResultsClientResponse:
        """Gets leaderboards with the signed in user's friends and the supplied
        destinyMembershipId as the focus.

        PREVIEW: This endpoint is still in beta, and may experience rough edges. The schema is in final form, but there may be bugs that prevent desirable operation.
        Parameters:
            character_id: The specific character to build the leaderboard around for the provided Destiny Membership.
            destiny_membership_id: The Destiny membershipId of the user to retrieve.
            maxtop: Maximum number of top players to return. Use a large number to get entire leaderboard.
            membership_type: A valid non-BungieNet membership type.
            modes: List of game modes for which to get leaderboards. See the documentation for DestinyActivityModeType for valid values, and pass in string representation, comma delimited.
            statid: ID of stat to return rather than returning all Leaderboard stats.
        """
        query = {"maxtop": maxtop, "modes": modes, "statid": statid}
        result = await self.get(
            path=f"/Destiny2/Stats/Leaderboards/{clean_query_value(membership_type)}/{clean_query_value(destiny_membership_id)}/{clean_query_value(character_id)}/",
            query=query,
        )
        return forge(DestinyLeaderboardResultsClientResponse, result)

    async def search_destiny_entities(
        self,
        search_term: str,
        type: str,
        page: t.Optional[int] = None,
    ) -> DestinyEntitySearchResultClientResponse:
        """Gets a page list of Destiny items.

        Parameters:
            page: Page number to return, starting with 0.
            search_term: The string to use when searching for Destiny entities.
            type: The type of entity for whom you would like results. These correspond to the entity's definition contract name. For instance, if you are looking for items, this property should be 'DestinyInventoryItemDefinition'.
        """
        query = {"page": page}
        result = await self.get(
            path=f"/Destiny2/Armory/Search/{clean_query_value(type)}/{clean_query_value(search_term)}/",
            query=query,
        )
        return forge(DestinyEntitySearchResultClientResponse, result)

    async def get_historical_stats(
        self,
        character_id: int,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
        dayend: t.Optional[str] = None,
        daystart: t.Optional[str] = None,
        groups: t.Optional[t.Sequence["DestinyStatsGroupType"]] = None,
        modes: t.Optional[t.Sequence["DestinyActivityModeType"]] = None,
        period_type: t.Optional["PeriodType"] = None,
    ) -> DestinyHistoricalStatsResultsClientResponse:
        """Gets historical stats for indicated character.

        Parameters:
            character_id: The id of the character to retrieve. You can omit this character ID or set it to 0 to get aggregate stats across all characters.
            dayend: Last day to return when daily stats are requested. Use the format YYYY-MM-DD. Currently, we cannot allow more than 31 days of daily data to be requested in a single request.
            daystart: First day to return when daily stats are requested. Use the format YYYY-MM-DD. Currently, we cannot allow more than 31 days of daily data to be requested in a single request.
            destiny_membership_id: The Destiny membershipId of the user to retrieve.
            groups: Group of stats to include, otherwise only general stats are returned. Comma separated list is allowed. Values: General, Weapons, Medals
            membership_type: A valid non-BungieNet membership type.
            modes: Game modes to return. See the documentation for DestinyActivityModeType for valid values, and pass in string representation, comma delimited.
            period_type: Indicates a specific period type to return. Optional. May be: Daily, AllTime, or Activity
        """
        query = {
            "dayend": dayend,
            "daystart": daystart,
            "groups": groups,
            "modes": modes,
            "periodType": period_type,
        }
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Account/{clean_query_value(destiny_membership_id)}/Character/{clean_query_value(character_id)}/Stats/",
            query=query,
        )
        return forge(DestinyHistoricalStatsResultsClientResponse, result)

    async def get_historical_stats_for_account(
        self,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
        groups: t.Optional[t.Sequence["DestinyStatsGroupType"]] = None,
    ) -> DestinyHistoricalStatsAccountResultClientResponse:
        """Gets aggregate historical stats organized around each character for
        a given account.

        Parameters:
            destiny_membership_id: The Destiny membershipId of the user to retrieve.
            groups: Groups of stats to include, otherwise only general stats are returned. Comma separated list is allowed. Values: General, Weapons, Medals.
            membership_type: A valid non-BungieNet membership type.
        """
        query = {"groups": groups}
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Account/{clean_query_value(destiny_membership_id)}/Stats/",
            query=query,
        )
        return forge(DestinyHistoricalStatsAccountResultClientResponse, result)

    async def get_activity_history(
        self,
        character_id: int,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
        count: t.Optional[int] = None,
        mode: t.Optional["DestinyActivityModeType"] = None,
        page: t.Optional[int] = None,
    ) -> DestinyActivityHistoryResultsClientResponse:
        """Gets activity history stats for indicated character.

        Parameters:
            character_id: The id of the character to retrieve.
            count: Number of rows to return
            destiny_membership_id: The Destiny membershipId of the user to retrieve.
            membership_type: A valid non-BungieNet membership type.
            mode: A filter for the activity mode to be returned. None returns all activities. See the documentation for DestinyActivityModeType for valid values, and pass in string representation.
            page: Page number to return, starting with 0.
        """
        query = {"count": count, "mode": mode, "page": page}
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Account/{clean_query_value(destiny_membership_id)}/Character/{clean_query_value(character_id)}/Stats/Activities/",
            query=query,
        )
        return forge(DestinyActivityHistoryResultsClientResponse, result)

    async def get_unique_weapon_history(
        self,
        character_id: int,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> DestinyHistoricalWeaponStatsDataClientResponse:
        """Gets details about unique weapon usage, including all exotic
        weapons.

        Parameters:
            character_id: The id of the character to retrieve.
            destiny_membership_id: The Destiny membershipId of the user to retrieve.
            membership_type: A valid non-BungieNet membership type.
        """
        query = None
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Account/{clean_query_value(destiny_membership_id)}/Character/{clean_query_value(character_id)}/Stats/UniqueWeapons/",
            query=query,
        )
        return forge(DestinyHistoricalWeaponStatsDataClientResponse, result)

    async def get_destiny_aggregate_activity_stats(
        self,
        character_id: int,
        destiny_membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> DestinyAggregateActivityResultsClientResponse:
        """Gets all activities the character has participated in together with
        aggregate statistics for those activities.

        Parameters:
            character_id: The specific character whose activities should be returned.
            destiny_membership_id: The Destiny membershipId of the user to retrieve.
            membership_type: A valid non-BungieNet membership type.
        """
        query = None
        result = await self.get(
            path=f"/Destiny2/{clean_query_value(membership_type)}/Account/{clean_query_value(destiny_membership_id)}/Character/{clean_query_value(character_id)}/Stats/AggregateActivityStats/",
            query=query,
        )
        return forge(DestinyAggregateActivityResultsClientResponse, result)

    async def get_public_milestone_content(
        self,
        milestone_hash: int,
    ) -> DestinyMilestoneContentClientResponse:
        """Gets custom localized content for the milestone of the given hash,
        if it exists.

        Parameters:
            milestone_hash: The identifier for the milestone to be returned.
        """
        query = None
        result = await self.get(
            path=f"/Destiny2/Milestones/{clean_query_value(milestone_hash)}/Content/",
            query=query,
        )
        return forge(DestinyMilestoneContentClientResponse, result)

    async def get_public_milestones(
        self,
    ) -> DictionaryOfuint32AndDestinyPublicMilestoneClientResponse:
        """Gets public information about currently available Milestones."""
        query = None
        result = await self.get(
            path="/Destiny2/Milestones/",
            query=query,
        )
        return forge(DictionaryOfuint32AndDestinyPublicMilestoneClientResponse, result)

    async def awa_initialize_request(
        self,
        request: "AwaPermissionRequested",
    ) -> AwaInitializeClientResponse:
        """Initialize a request to perform an advanced write action."""
        query = None
        result = await self.post(
            path="/Destiny2/Awa/Initialize/", query=query, request=request
        )
        return forge(AwaInitializeClientResponse, result)

    async def awa_provide_authorization_result(
        self,
        request: "AwaUserResponse",
    ) -> int32ClientResponse:
        """Provide the result of the user interaction.

        Called by the Bungie Destiny App to approve or reject a request.
        """
        query = None
        result = await self.post(
            path="/Destiny2/Awa/AwaProvideAuthorizationResult/",
            query=query,
            request=request,
        )
        return forge(int32ClientResponse, result)

    async def awa_get_action_token(
        self,
        correlation_id: str,
    ) -> AwaAuthorizationResultClientResponse:
        """Returns the action token if user approves the request.

        Parameters:
            correlation_id: The identifier for the advanced write action request.
        """
        query = None
        result = await self.get(
            path=f"/Destiny2/Awa/GetActionToken/{clean_query_value(correlation_id)}/",
            query=query,
        )
        return forge(AwaAuthorizationResultClientResponse, result)
