# generated by update to not change manually
import typing as t

from bungieapi.base import BaseClient, clean_query_value
from bungieapi.forge import forge
from bungieapi.generated.components.responses import (
    SearchResultOfFireteamClientResponse,
    SearchResultOfFireteamSummaryClientResponse,
    int32ClientResponse,
)
from bungieapi.generated.components.responses.fireteam import FireteamClientResponse
from bungieapi.generated.components.schemas.fireteam import (
    FireteamDateRange,
    FireteamPlatform,
    FireteamPublicSearchOption,
    FireteamSlotSearch,
)


class Client(BaseClient):
    async def get_active_private_clan_fireteam_count(
        self,
        group_id: int,
    ) -> int32ClientResponse:
        """Gets a count of all active non-public fireteams for the specified
        clan.

        Maximum value returned is 25.
        Parameters:
            group_id: The group id of the clan.
        """
        query = None
        result = await self.get(
            path=f"/Fireteam/Clan/{clean_query_value(group_id)}/ActiveCount/",
            query=query,
        )
        return forge(int32ClientResponse, result)

    async def get_available_clan_fireteams(
        self,
        activity_type: int,
        date_range: "FireteamDateRange",
        group_id: int,
        page: int,
        platform: "FireteamPlatform",
        public_only: "FireteamPublicSearchOption",
        slot_filter: "FireteamSlotSearch",
        lang_filter: t.Optional[str] = None,
    ) -> SearchResultOfFireteamSummaryClientResponse:
        """Gets a listing of all of this clan's fireteams that are have
        available slots.

        Caller is not checked for join criteria so caching is maximized.
        Parameters:
            activity_type: The activity type to filter by.
            date_range: The date range to grab available fireteams.
            group_id: The group id of the clan.
            lang_filter: An optional language filter.
            page: Zero based page
            platform: The platform filter.
            public_only: Determines public/private filtering.
            slot_filter: Filters based on available slots
        """
        query = {"langFilter": lang_filter}
        result = await self.get(
            path=f"/Fireteam/Clan/{clean_query_value(group_id)}/Available/{clean_query_value(platform)}/{clean_query_value(activity_type)}/{clean_query_value(date_range)}/{clean_query_value(slot_filter)}/{clean_query_value(public_only)}/{clean_query_value(page)}/",
            query=query,
        )
        return forge(SearchResultOfFireteamSummaryClientResponse, result)

    async def search_public_available_clan_fireteams(
        self,
        activity_type: int,
        date_range: "FireteamDateRange",
        page: int,
        platform: "FireteamPlatform",
        slot_filter: "FireteamSlotSearch",
        lang_filter: t.Optional[str] = None,
    ) -> SearchResultOfFireteamSummaryClientResponse:
        """Gets a listing of all public fireteams starting now with open slots.

        Caller is not checked for join criteria so caching is maximized.
        Parameters:
            activity_type: The activity type to filter by.
            date_range: The date range to grab available fireteams.
            lang_filter: An optional language filter.
            page: Zero based page
            platform: The platform filter.
            slot_filter: Filters based on available slots
        """
        query = {"langFilter": lang_filter}
        result = await self.get(
            path=f"/Fireteam/Search/Available/{clean_query_value(platform)}/{clean_query_value(activity_type)}/{clean_query_value(date_range)}/{clean_query_value(slot_filter)}/{clean_query_value(page)}/",
            query=query,
        )
        return forge(SearchResultOfFireteamSummaryClientResponse, result)

    async def get_my_clan_fireteams(
        self,
        group_id: int,
        include_closed: bool,
        page: int,
        platform: "FireteamPlatform",
        group_filter: t.Optional[bool] = None,
        lang_filter: t.Optional[str] = None,
    ) -> SearchResultOfFireteamClientResponse:
        """Gets a listing of all fireteams that caller is an applicant, a
        member, or an alternate of.

        Parameters:
            group_filter: If true, filter by clan. Otherwise, ignore the clan and show all of the user's fireteams.
            group_id: The group id of the clan. (This parameter is ignored unless the optional query parameter groupFilter is true).
            include_closed: If true, return fireteams that have been closed.
            lang_filter: An optional language filter.
            page: Deprecated parameter, ignored.
            platform: The platform filter.
        """
        query = {"groupFilter": group_filter, "langFilter": lang_filter}
        result = await self.get(
            path=f"/Fireteam/Clan/{clean_query_value(group_id)}/My/{clean_query_value(platform)}/{clean_query_value(include_closed)}/{clean_query_value(page)}/",
            query=query,
        )
        return forge(SearchResultOfFireteamClientResponse, result)

    async def get_clan_fireteam(
        self,
        fireteam_id: int,
        group_id: int,
    ) -> FireteamClientResponse:
        """Gets a specific fireteam.

        Parameters:
            fireteam_id: The unique id of the fireteam.
            group_id: The group id of the clan.
        """
        query = None
        result = await self.get(
            path=f"/Fireteam/Clan/{clean_query_value(group_id)}/Summary/{clean_query_value(fireteam_id)}/",
            query=query,
        )
        return forge(FireteamClientResponse, result)
