# generated by update to not change manually
import typing as t

from bungieapi.base import BaseClient, clean_query_value
from bungieapi.forge import forge
from bungieapi.generated.components.responses import (
    CEListOfGroupOptionalConversationClientResponse,
    DictionaryOfint32AndstringClientResponse,
    ListOfEntityActionResultClientResponse,
    ListOfGroupThemeClientResponse,
    ListOfGroupV2CardClientResponse,
    SearchResultOfGroupBanClientResponse,
    SearchResultOfGroupMemberApplicationClientResponse,
    SearchResultOfGroupMemberClientResponse,
    booleanClientResponse,
    int32ClientResponse,
    int64ClientResponse,
)
from bungieapi.generated.components.responses.groups_v2 import (
    GetGroupsForMemberClientResponse,
    GroupApplicationClientResponse,
    GroupClientResponse,
    GroupMemberLeaveResultClientResponse,
    GroupMembershipSearchClientResponse,
    GroupPotentialMembershipSearchClientResponse,
    GroupSearchClientResponse,
)
from bungieapi.generated.components.schemas import BungieMembershipType
from bungieapi.generated.components.schemas.groups_v2 import (
    ClanBanner,
    GroupApplicationListRequest,
    GroupApplicationRequest,
    GroupBanRequest,
    GroupDateRange,
    GroupEditAction,
    GroupNameSearchRequest,
    GroupOptionalConversationAddRequest,
    GroupOptionalConversationEditRequest,
    GroupOptionsEditAction,
    GroupPotentialMemberStatus,
    GroupQuery,
    GroupsForMemberFilter,
    GroupType,
    RuntimeGroupMemberType,
)


class Client(BaseClient):
    async def get_available_avatars(
        self,
    ) -> DictionaryOfint32AndstringClientResponse:
        """Returns a list of all available group avatars for the signed-in
        user."""
        query = None
        result = await self.get(
            path="/GroupV2/GetAvailableAvatars/",
            query=query,
        )
        return forge(DictionaryOfint32AndstringClientResponse, result)

    async def get_available_themes(
        self,
    ) -> ListOfGroupThemeClientResponse:
        """Returns a list of all available group themes."""
        query = None
        result = await self.get(
            path="/GroupV2/GetAvailableThemes/",
            query=query,
        )
        return forge(ListOfGroupThemeClientResponse, result)

    async def get_user_clan_invite_setting(
        self,
        m_type: "BungieMembershipType",
    ) -> booleanClientResponse:
        """Gets the state of the user's clan invite preferences for a particular membership type - true if they wish to be invited to clans, false otherwise.
        Parameters:
            m_type: The Destiny membership type of the account we wish to access settings."""
        query = None
        result = await self.get(
            path=f"/GroupV2/GetUserClanInviteSetting/{clean_query_value(m_type)}/",
            query=query,
        )
        return forge(booleanClientResponse, result)

    async def get_recommended_groups(
        self,
        create_date_range: "GroupDateRange",
        group_type: "GroupType",
    ) -> ListOfGroupV2CardClientResponse:
        """Gets groups recommended for you based on the groups to whom those
        you follow belong.

        Parameters:
            create_date_range: Requested range in which to pull recommended groups
            group_type: Type of groups requested
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/Recommended/{clean_query_value(group_type)}/{clean_query_value(create_date_range)}/",
            query=query,
        )
        return forge(ListOfGroupV2CardClientResponse, result)

    async def group_search(
        self,
        request: "GroupQuery",
    ) -> GroupSearchClientResponse:
        """Search for Groups."""
        query = None
        result = await self.post(path="/GroupV2/Search/", query=query, request=request)
        return forge(GroupSearchClientResponse, result)

    async def get_group(
        self,
        group_id: int,
    ) -> GroupClientResponse:
        """Get information about a specific group of the given ID.

        Parameters:
            group_id: Requested group's id.
        """
        query = None
        result = await self.get(
            path=f"/GroupV2/{clean_query_value(group_id)}/",
            query=query,
        )
        return forge(GroupClientResponse, result)

    async def get_group_by_name(
        self,
        group_name: str,
        group_type: "GroupType",
    ) -> GroupClientResponse:
        """Get information about a specific group with the given name and type.

        Parameters:
            group_name: Exact name of the group to find.
            group_type: Type of group to find.
        """
        query = None
        result = await self.get(
            path=f"/GroupV2/Name/{clean_query_value(group_name)}/{clean_query_value(group_type)}/",
            query=query,
        )
        return forge(GroupClientResponse, result)

    async def get_group_by_name_v2(
        self,
        request: "GroupNameSearchRequest",
    ) -> GroupClientResponse:
        """Get information about a specific group with the given name and type.

        The POST version.
        """
        query = None
        result = await self.post(path="/GroupV2/NameV2/", query=query, request=request)
        return forge(GroupClientResponse, result)

    async def get_group_optional_conversations(
        self,
        group_id: int,
    ) -> CEListOfGroupOptionalConversationClientResponse:
        """Gets a list of available optional conversation channels and their
        settings.

        Parameters:
            group_id: Requested group's id.
        """
        query = None
        result = await self.get(
            path=f"/GroupV2/{clean_query_value(group_id)}/OptionalConversations/",
            query=query,
        )
        return forge(CEListOfGroupOptionalConversationClientResponse, result)

    async def edit_group(
        self,
        request: "GroupEditAction",
        group_id: int,
    ) -> int32ClientResponse:
        """Edit an existing group.

        You must have suitable permissions in the group to perform this operation. This latest revision will only edit the fields you pass in - pass null for properties you want to leave unaltered.
        Parameters:
            group_id: Group ID of the group to edit.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Edit/",
            query=query,
            request=request,
        )
        return forge(int32ClientResponse, result)

    async def edit_clan_banner(
        self,
        request: "ClanBanner",
        group_id: int,
    ) -> int32ClientResponse:
        """Edit an existing group's clan banner.

        You must have suitable permissions in the group to perform this operation. All fields are required.
        Parameters:
            group_id: Group ID of the group to edit.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/EditClanBanner/",
            query=query,
            request=request,
        )
        return forge(int32ClientResponse, result)

    async def edit_founder_options(
        self,
        request: "GroupOptionsEditAction",
        group_id: int,
    ) -> int32ClientResponse:
        """Edit group options only available to a founder.

        You must have suitable permissions in the group to perform this operation.
        Parameters:
            group_id: Group ID of the group to edit.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/EditFounderOptions/",
            query=query,
            request=request,
        )
        return forge(int32ClientResponse, result)

    async def add_optional_conversation(
        self,
        request: "GroupOptionalConversationAddRequest",
        group_id: int,
    ) -> int64ClientResponse:
        """Add a new optional conversation/chat channel.

        Requires admin permissions to the group.
        Parameters:
            group_id: Group ID of the group to edit.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/OptionalConversations/Add/",
            query=query,
            request=request,
        )
        return forge(int64ClientResponse, result)

    async def edit_optional_conversation(
        self,
        request: "GroupOptionalConversationEditRequest",
        conversation_id: int,
        group_id: int,
    ) -> int64ClientResponse:
        """Edit the settings of an optional conversation/chat channel.

        Requires admin permissions to the group.
        Parameters:
            conversation_id: Conversation Id of the channel being edited.
            group_id: Group ID of the group to edit.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/OptionalConversations/Edit/{clean_query_value(conversation_id)}/",
            query=query,
            request=request,
        )
        return forge(int64ClientResponse, result)

    async def get_members_of_group(
        self,
        currentpage: int,
        group_id: int,
        member_type: t.Optional["RuntimeGroupMemberType"] = None,
        name_search: t.Optional[str] = None,
    ) -> SearchResultOfGroupMemberClientResponse:
        """Get the list of members in a given group.

        Parameters:
            currentpage: Page number (starting with 1). Each page has a fixed size of 50 items per page.
            group_id: The ID of the group.
            member_type: Filter out other member types. Use None for all members.
            name_search: The name fragment upon which a search should be executed for members with matching display or unique names.
        """
        query = {"memberType": member_type, "nameSearch": name_search}
        result = await self.get(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/",
            query=query,
        )
        return forge(SearchResultOfGroupMemberClientResponse, result)

    async def get_admins_and_founder_of_group(
        self,
        currentpage: int,
        group_id: int,
    ) -> SearchResultOfGroupMemberClientResponse:
        """Get the list of members in a given group who are of admin level or
        higher.

        Parameters:
            currentpage: Page number (starting with 1). Each page has a fixed size of 50 items per page.
            group_id: The ID of the group.
        """
        query = None
        result = await self.get(
            path=f"/GroupV2/{clean_query_value(group_id)}/AdminsAndFounder/",
            query=query,
        )
        return forge(SearchResultOfGroupMemberClientResponse, result)

    async def edit_group_membership(
        self,
        group_id: int,
        membership_id: int,
        membership_type: "BungieMembershipType",
        member_type: "RuntimeGroupMemberType",
    ) -> int32ClientResponse:
        """Edit the membership type of a given member.

        You must have suitable permissions in the group to perform this operation.
        Parameters:
            group_id: ID of the group to which the member belongs.
            membership_id: Membership ID to modify.
            membership_type: Membership type of the provide membership ID.
            member_type: New membertype for the specified member.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/{clean_query_value(membership_type)}/{clean_query_value(membership_id)}/SetMembershipType/{clean_query_value(member_type)}/",
            query=query,
        )
        return forge(int32ClientResponse, result)

    async def kick_member(
        self,
        group_id: int,
        membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> GroupMemberLeaveResultClientResponse:
        """Kick a member from the given group, forcing them to reapply if they
        wish to re-join the group.

        You must have suitable permissions in the group to perform this operation.
        Parameters:
            group_id: Group ID to kick the user from.
            membership_id: Membership ID to kick.
            membership_type: Membership type of the provided membership ID.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/{clean_query_value(membership_type)}/{clean_query_value(membership_id)}/Kick/",
            query=query,
        )
        return forge(GroupMemberLeaveResultClientResponse, result)

    async def ban_member(
        self,
        request: "GroupBanRequest",
        group_id: int,
        membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> int32ClientResponse:
        """Bans the requested member from the requested group for the specified
        period of time.

        Parameters:
            group_id: Group ID that has the member to ban.
            membership_id: Membership ID of the member to ban from the group.
            membership_type: Membership type of the provided membership ID.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/{clean_query_value(membership_type)}/{clean_query_value(membership_id)}/Ban/",
            query=query,
            request=request,
        )
        return forge(int32ClientResponse, result)

    async def unban_member(
        self,
        group_id: int,
        membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> int32ClientResponse:
        """Unbans the requested member, allowing them to re-apply for
        membership.

        Parameters:
            membership_id: Membership ID of the member to unban from the group
            membership_type: Membership type of the provided membership ID.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/{clean_query_value(membership_type)}/{clean_query_value(membership_id)}/Unban/",
            query=query,
        )
        return forge(int32ClientResponse, result)

    async def get_banned_members_of_group(
        self,
        currentpage: int,
        group_id: int,
    ) -> SearchResultOfGroupBanClientResponse:
        """Get the list of banned members in a given group.

        Only accessible to group Admins and above. Not applicable to all groups. Check group features.
        Parameters:
            currentpage: Page number (starting with 1). Each page has a fixed size of 50 entries.
            group_id: Group ID whose banned members you are fetching
        """
        query = None
        result = await self.get(
            path=f"/GroupV2/{clean_query_value(group_id)}/Banned/",
            query=query,
        )
        return forge(SearchResultOfGroupBanClientResponse, result)

    async def abdicate_foundership(
        self,
        founder_id_new: int,
        group_id: int,
        membership_type: "BungieMembershipType",
    ) -> booleanClientResponse:
        """An administrative method to allow the founder of a group or clan to
        give up their position to another admin permanently.

        Parameters:
            founder_id_new: The new founder for this group. Must already be a group admin.
            group_id: The target group id.
            membership_type: Membership type of the provided founderIdNew.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Admin/AbdicateFoundership/{clean_query_value(membership_type)}/{clean_query_value(founder_id_new)}/",
            query=query,
        )
        return forge(booleanClientResponse, result)

    async def get_pending_memberships(
        self,
        currentpage: int,
        group_id: int,
    ) -> SearchResultOfGroupMemberApplicationClientResponse:
        """Get the list of users who are awaiting a decision on their
        application to join a given group.

        Modified to include application info.
        Parameters:
            currentpage: Page number (starting with 1). Each page has a fixed size of 50 items per page.
            group_id: ID of the group.
        """
        query = None
        result = await self.get(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/Pending/",
            query=query,
        )
        return forge(SearchResultOfGroupMemberApplicationClientResponse, result)

    async def get_invited_individuals(
        self,
        currentpage: int,
        group_id: int,
    ) -> SearchResultOfGroupMemberApplicationClientResponse:
        """Get the list of users who have been invited into the group.

        Parameters:
            currentpage: Page number (starting with 1). Each page has a fixed size of 50 items per page.
            group_id: ID of the group.
        """
        query = None
        result = await self.get(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/InvitedIndividuals/",
            query=query,
        )
        return forge(SearchResultOfGroupMemberApplicationClientResponse, result)

    async def approve_all_pending(
        self,
        request: "GroupApplicationRequest",
        group_id: int,
    ) -> ListOfEntityActionResultClientResponse:
        """Approve all of the pending users for the given group.

        Parameters:
            group_id: ID of the group.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/ApproveAll/",
            query=query,
            request=request,
        )
        return forge(ListOfEntityActionResultClientResponse, result)

    async def deny_all_pending(
        self,
        request: "GroupApplicationRequest",
        group_id: int,
    ) -> ListOfEntityActionResultClientResponse:
        """Deny all of the pending users for the given group.

        Parameters:
            group_id: ID of the group.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/DenyAll/",
            query=query,
            request=request,
        )
        return forge(ListOfEntityActionResultClientResponse, result)

    async def approve_pending_for_list(
        self,
        request: "GroupApplicationListRequest",
        group_id: int,
    ) -> ListOfEntityActionResultClientResponse:
        """Approve all of the pending users for the given group.

        Parameters:
            group_id: ID of the group.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/ApproveList/",
            query=query,
            request=request,
        )
        return forge(ListOfEntityActionResultClientResponse, result)

    async def approve_pending(
        self,
        request: "GroupApplicationRequest",
        group_id: int,
        membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> booleanClientResponse:
        """Approve the given membershipId to join the group/clan as long as
        they have applied.

        Parameters:
            group_id: ID of the group.
            membership_id: The membership id being approved.
            membership_type: Membership type of the supplied membership ID.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/Approve/{clean_query_value(membership_type)}/{clean_query_value(membership_id)}/",
            query=query,
            request=request,
        )
        return forge(booleanClientResponse, result)

    async def deny_pending_for_list(
        self,
        request: "GroupApplicationListRequest",
        group_id: int,
    ) -> ListOfEntityActionResultClientResponse:
        """Deny all of the pending users for the given group that match the
        passed-in .

        Parameters:
            group_id: ID of the group.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/DenyList/",
            query=query,
            request=request,
        )
        return forge(ListOfEntityActionResultClientResponse, result)

    async def get_groups_for_member(
        self,
        filter: "GroupsForMemberFilter",
        group_type: "GroupType",
        membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> GetGroupsForMemberClientResponse:
        """Get information about the groups that a given member has joined.

        Parameters:
            filter: Filter apply to list of joined groups.
            group_type: Type of group the supplied member founded.
            membership_id: Membership ID to for which to find founded groups.
            membership_type: Membership type of the supplied membership ID.
        """
        query = None
        result = await self.get(
            path=f"/GroupV2/User/{clean_query_value(membership_type)}/{clean_query_value(membership_id)}/{clean_query_value(filter)}/{clean_query_value(group_type)}/",
            query=query,
        )
        return forge(GetGroupsForMemberClientResponse, result)

    async def recover_group_for_founder(
        self,
        group_type: "GroupType",
        membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> GroupMembershipSearchClientResponse:
        """Allows a founder to manually recover a group they can see in game but not on bungie.net
        Parameters:
            group_type: Type of group the supplied member founded.
            membership_id: Membership ID to for which to find founded groups.
            membership_type: Membership type of the supplied membership ID."""
        query = None
        result = await self.get(
            path=f"/GroupV2/Recover/{clean_query_value(membership_type)}/{clean_query_value(membership_id)}/{clean_query_value(group_type)}/",
            query=query,
        )
        return forge(GroupMembershipSearchClientResponse, result)

    async def get_potential_groups_for_member(
        self,
        filter: "GroupPotentialMemberStatus",
        group_type: "GroupType",
        membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> GroupPotentialMembershipSearchClientResponse:
        """Get information about the groups that a given member has applied to
        or been invited to.

        Parameters:
            filter: Filter apply to list of potential joined groups.
            group_type: Type of group the supplied member applied.
            membership_id: Membership ID to for which to find applied groups.
            membership_type: Membership type of the supplied membership ID.
        """
        query = None
        result = await self.get(
            path=f"/GroupV2/User/Potential/{clean_query_value(membership_type)}/{clean_query_value(membership_id)}/{clean_query_value(filter)}/{clean_query_value(group_type)}/",
            query=query,
        )
        return forge(GroupPotentialMembershipSearchClientResponse, result)

    async def individual_group_invite(
        self,
        request: "GroupApplicationRequest",
        group_id: int,
        membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> GroupApplicationClientResponse:
        """Invite a user to join this group.

        Parameters:
            group_id: ID of the group you would like to join.
            membership_id: Membership id of the account being invited.
            membership_type: MembershipType of the account being invited.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/IndividualInvite/{clean_query_value(membership_type)}/{clean_query_value(membership_id)}/",
            query=query,
            request=request,
        )
        return forge(GroupApplicationClientResponse, result)

    async def individual_group_invite_cancel(
        self,
        group_id: int,
        membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> GroupApplicationClientResponse:
        """Cancels a pending invitation to join a group.

        Parameters:
            group_id: ID of the group you would like to join.
            membership_id: Membership id of the account being cancelled.
            membership_type: MembershipType of the account being cancelled.
        """
        query = None
        result = await self.post(
            path=f"/GroupV2/{clean_query_value(group_id)}/Members/IndividualInviteCancel/{clean_query_value(membership_type)}/{clean_query_value(membership_id)}/",
            query=query,
        )
        return forge(GroupApplicationClientResponse, result)
