# generated by update to not change manually
from bungieapi.base import BaseClient, clean_query_value
from bungieapi.forge import forge
from bungieapi.generated.components.responses import (
    ListOfGetCredentialTypesForAccountClientResponse,
    ListOfUserThemeClientResponse,
)
from bungieapi.generated.components.responses.user import (
    GeneralUserClientResponse,
    HardLinkedUserMembershipClientResponse,
    UserMembershipDataClientResponse,
    UserSearchClientResponse,
)
from bungieapi.generated.components.schemas import (
    BungieCredentialType,
    BungieMembershipType,
)
from bungieapi.generated.components.schemas.user import UserSearchPrefixRequest


class Client(BaseClient):
    async def get_bungie_net_user_by_id(
        self,
        id: int,
    ) -> GeneralUserClientResponse:
        """Loads a bungienet user by membership id.

        Parameters:
            id: The requested Bungie.net membership id.
        """
        query = None
        result = await self.get(
            path=f"/User/GetBungieNetUserById/{clean_query_value(id)}/",
            query=query,
        )
        return forge(GeneralUserClientResponse, result)

    async def get_credential_types_for_target_account(
        self,
        membership_id: int,
    ) -> ListOfGetCredentialTypesForAccountClientResponse:
        """Returns a list of credential types attached to the requested account
        Parameters:
            membership_id: The user's membership id"""
        query = None
        result = await self.get(
            path=f"/User/GetCredentialTypesForTargetAccount/{clean_query_value(membership_id)}/",
            query=query,
        )
        return forge(ListOfGetCredentialTypesForAccountClientResponse, result)

    async def get_available_themes(
        self,
    ) -> ListOfUserThemeClientResponse:
        """Returns a list of all available user themes."""
        query = None
        result = await self.get(
            path="/User/GetAvailableThemes/",
            query=query,
        )
        return forge(ListOfUserThemeClientResponse, result)

    async def get_membership_data_by_id(
        self,
        membership_id: int,
        membership_type: "BungieMembershipType",
    ) -> UserMembershipDataClientResponse:
        """Returns a list of accounts associated with the supplied membership
        ID and membership type.

        This will include all linked accounts (even when hidden) if supplied credentials permit it.
        Parameters:
            membership_id: The membership ID of the target user.
            membership_type: Type of the supplied membership ID.
        """
        query = None
        result = await self.get(
            path=f"/User/GetMembershipsById/{clean_query_value(membership_id)}/{clean_query_value(membership_type)}/",
            query=query,
        )
        return forge(UserMembershipDataClientResponse, result)

    async def get_membership_data_for_current_user(
        self,
    ) -> UserMembershipDataClientResponse:
        """Returns a list of accounts associated with signed in user.

        This is useful for OAuth implementations that do not give you
        access to the token response.
        """
        query = None
        result = await self.get(
            path="/User/GetMembershipsForCurrentUser/",
            query=query,
        )
        return forge(UserMembershipDataClientResponse, result)

    async def get_membership_from_hard_linked_credential(
        self,
        credential: str,
        cr_type: "BungieCredentialType",
    ) -> HardLinkedUserMembershipClientResponse:
        """Gets any hard linked membership given a credential.

        Only works for credentials that are public (just SteamID64 right now). Cross Save aware.
        Parameters:
            credential: The credential to look up. Must be a valid SteamID64.
            cr_type: The credential type. 'SteamId' is the only valid value at present.
        """
        query = None
        result = await self.get(
            path=f"/User/GetMembershipFromHardLinkedCredential/{clean_query_value(cr_type)}/{clean_query_value(credential)}/",
            query=query,
        )
        return forge(HardLinkedUserMembershipClientResponse, result)

    async def search_by_global_name_prefix(
        self,
        display_name_prefix: str,
        page: int,
    ) -> UserSearchClientResponse:
        """[OBSOLETE] Do not use this to search users, use
        SearchByGlobalNamePost instead.

        Parameters:
            display_name_prefix: The display name prefix you're looking for.
            page: The zero-based page of results you desire.
        """
        query = None
        result = await self.get(
            path=f"/User/Search/Prefix/{clean_query_value(display_name_prefix)}/{clean_query_value(page)}/",
            query=query,
        )
        return forge(UserSearchClientResponse, result)

    async def search_by_global_name_post(
        self,
        request: "UserSearchPrefixRequest",
        page: int,
    ) -> UserSearchClientResponse:
        """Given the prefix of a global display name, returns all users who
        share that name.

        Parameters:
            page: The zero-based page of results you desire.
        """
        query = None
        result = await self.post(
            path=f"/User/Search/GlobalName/{clean_query_value(page)}/",
            query=query,
            request=request,
        )
        return forge(UserSearchClientResponse, result)
