# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json


@dt.dataclass(frozen=True)
class DestinyLinkedProfilesClientResponse:
    detailed_error_trace: str
    error_code: "PlatformErrorCodes"
    error_status: str
    message: str
    message_data: t.Mapping[str, str]
    response: "DestinyLinkedProfilesResponse"
    throttle_seconds: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "Response": to_json(self.response),
            "ErrorCode": to_json(self.error_code),
            "ThrottleSeconds": to_json(self.throttle_seconds),
            "ErrorStatus": to_json(self.error_status),
            "Message": to_json(self.message),
            "MessageData": to_json(self.message_data),
            "DetailedErrorTrace": to_json(self.detailed_error_trace),
        }


@dt.dataclass(frozen=True)
class DestinyProfileClientResponse:
    detailed_error_trace: str
    error_code: "PlatformErrorCodes"
    error_status: str
    message: str
    message_data: t.Mapping[str, str]
    response: "DestinyProfileResponse"
    throttle_seconds: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "Response": to_json(self.response),
            "ErrorCode": to_json(self.error_code),
            "ThrottleSeconds": to_json(self.throttle_seconds),
            "ErrorStatus": to_json(self.error_status),
            "Message": to_json(self.message),
            "MessageData": to_json(self.message_data),
            "DetailedErrorTrace": to_json(self.detailed_error_trace),
        }


@dt.dataclass(frozen=True)
class DestinyCharacterClientResponse:
    detailed_error_trace: str
    error_code: "PlatformErrorCodes"
    error_status: str
    message: str
    message_data: t.Mapping[str, str]
    response: "DestinyCharacterResponse"
    throttle_seconds: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "Response": to_json(self.response),
            "ErrorCode": to_json(self.error_code),
            "ThrottleSeconds": to_json(self.throttle_seconds),
            "ErrorStatus": to_json(self.error_status),
            "Message": to_json(self.message),
            "MessageData": to_json(self.message_data),
            "DetailedErrorTrace": to_json(self.detailed_error_trace),
        }


@dt.dataclass(frozen=True)
class DestinyItemClientResponse:
    detailed_error_trace: str
    error_code: "PlatformErrorCodes"
    error_status: str
    message: str
    message_data: t.Mapping[str, str]
    response: "DestinyItemResponse"
    throttle_seconds: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "Response": to_json(self.response),
            "ErrorCode": to_json(self.error_code),
            "ThrottleSeconds": to_json(self.throttle_seconds),
            "ErrorStatus": to_json(self.error_status),
            "Message": to_json(self.message),
            "MessageData": to_json(self.message_data),
            "DetailedErrorTrace": to_json(self.detailed_error_trace),
        }


@dt.dataclass(frozen=True)
class DestinyVendorsClientResponse:
    detailed_error_trace: str
    error_code: "PlatformErrorCodes"
    error_status: str
    message: str
    message_data: t.Mapping[str, str]
    response: "DestinyVendorsResponse"
    throttle_seconds: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "Response": to_json(self.response),
            "ErrorCode": to_json(self.error_code),
            "ThrottleSeconds": to_json(self.throttle_seconds),
            "ErrorStatus": to_json(self.error_status),
            "Message": to_json(self.message),
            "MessageData": to_json(self.message_data),
            "DetailedErrorTrace": to_json(self.detailed_error_trace),
        }


@dt.dataclass(frozen=True)
class DestinyVendorClientResponse:
    detailed_error_trace: str
    error_code: "PlatformErrorCodes"
    error_status: str
    message: str
    message_data: t.Mapping[str, str]
    response: "DestinyVendorResponse"
    throttle_seconds: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "Response": to_json(self.response),
            "ErrorCode": to_json(self.error_code),
            "ThrottleSeconds": to_json(self.throttle_seconds),
            "ErrorStatus": to_json(self.error_status),
            "Message": to_json(self.message),
            "MessageData": to_json(self.message_data),
            "DetailedErrorTrace": to_json(self.detailed_error_trace),
        }


@dt.dataclass(frozen=True)
class DestinyPublicVendorsClientResponse:
    detailed_error_trace: str
    error_code: "PlatformErrorCodes"
    error_status: str
    message: str
    message_data: t.Mapping[str, str]
    response: "DestinyPublicVendorsResponse"
    throttle_seconds: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "Response": to_json(self.response),
            "ErrorCode": to_json(self.error_code),
            "ThrottleSeconds": to_json(self.throttle_seconds),
            "ErrorStatus": to_json(self.error_status),
            "Message": to_json(self.message),
            "MessageData": to_json(self.message_data),
            "DetailedErrorTrace": to_json(self.detailed_error_trace),
        }


@dt.dataclass(frozen=True)
class DestinyCollectibleNodeDetailClientResponse:
    detailed_error_trace: str
    error_code: "PlatformErrorCodes"
    error_status: str
    message: str
    message_data: t.Mapping[str, str]
    response: "DestinyCollectibleNodeDetailResponse"
    throttle_seconds: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "Response": to_json(self.response),
            "ErrorCode": to_json(self.error_code),
            "ThrottleSeconds": to_json(self.throttle_seconds),
            "ErrorStatus": to_json(self.error_status),
            "Message": to_json(self.message),
            "MessageData": to_json(self.message_data),
            "DetailedErrorTrace": to_json(self.detailed_error_trace),
        }


@dt.dataclass(frozen=True)
class DestinyItemChangeClientResponse:
    detailed_error_trace: str
    error_code: "PlatformErrorCodes"
    error_status: str
    message: str
    message_data: t.Mapping[str, str]
    response: "DestinyItemChangeResponse"
    throttle_seconds: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "Response": to_json(self.response),
            "ErrorCode": to_json(self.error_code),
            "ThrottleSeconds": to_json(self.throttle_seconds),
            "ErrorStatus": to_json(self.error_status),
            "Message": to_json(self.message),
            "MessageData": to_json(self.message_data),
            "DetailedErrorTrace": to_json(self.detailed_error_trace),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.responses import (  # noqa: E402
    DestinyCharacterResponse,
    DestinyCollectibleNodeDetailResponse,
    DestinyItemChangeResponse,
    DestinyItemResponse,
    DestinyLinkedProfilesResponse,
    DestinyProfileResponse,
    DestinyPublicVendorsResponse,
    DestinyVendorResponse,
    DestinyVendorsResponse,
)
from bungieapi.generated.components.schemas.exceptions import (  # noqa: E402
    PlatformErrorCodes,
)
