# generated by update to not change manually
import dataclasses as dt
import typing as t
from enum import Enum

from bungieapi.json import to_json


class BungieMembershipType(Enum):
    """The types of membership the Accounts system supports.

    This is the external facing enum used in place of the internal-only
    Bungie.SharedDefinitions.MembershipType.
    """

    NONE = 0
    TIGER_XBOX = 1
    TIGER_PSN = 2
    TIGER_STEAM = 3
    TIGER_BLIZZARD = 4
    TIGER_STADIA = 5
    TIGER_DEMON = 10
    BUNGIE_NEXT = 254
    ALL = (
        -1
    )  # "All" is only valid for searching capabilities: you need to pass the actual matching BungieMembershipType for any query where you pass a known membershipId.


class BungieCredentialType(Enum):
    """The types of credentials the Accounts system supports.

    This is the external facing enum used in place of the internal-only
    Bungie.SharedDefinitions.CredentialType.
    """

    NONE = 0
    XUID = 1
    PSNID = 2
    WLID = 3
    FAKE = 4
    FACEBOOK = 5
    GOOGLE = 8
    WINDOWS = 9
    DEMON_ID = 10
    STEAM_ID = 12
    BATTLE_NET_ID = 14
    STADIA_ID = 16
    TWITCH_ID = 18


@dt.dataclass(frozen=True)
class SearchResultOfContentItemPublicContract:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["ContentItemPublicContract"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class SearchResultOfPostResponse:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["PostResponse"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


BungieMembershipTypeArray = t.Sequence["BungieMembershipType"]


@dt.dataclass(frozen=True)
class SearchResultOfGroupV2Card:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["GroupV2Card"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class SearchResultOfGroupMember:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["GroupMember"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class SearchResultOfGroupBan:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["GroupBan"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class SearchResultOfGroupMemberApplication:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["GroupMemberApplication"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class SearchResultOfGroupMembership:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["GroupMembership"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class SearchResultOfGroupPotentialMembership:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["GroupPotentialMembership"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyVendorReceiptsComponent:
    data: "DestinyVendorReceiptsComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyInventoryComponent:
    data: "DestinyInventoryComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyProfileComponent:
    data: "DestinyProfileComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyPlatformSilverComponent:
    data: "DestinyPlatformSilverComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyKiosksComponent:
    data: "DestinyKiosksComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyPlugSetsComponent:
    data: "DestinyPlugSetsComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyProfileProgressionComponent:
    data: "DestinyProfileProgressionComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyPresentationNodesComponent:
    data: "DestinyPresentationNodesComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyProfileRecordsComponent:
    data: "DestinyProfileRecordsComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyProfileCollectiblesComponent:
    data: "DestinyProfileCollectiblesComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyProfileTransitoryComponent:
    data: "DestinyProfileTransitoryComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyMetricsComponent:
    data: "DestinyMetricsComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyStringVariablesComponent:
    data: "DestinyStringVariablesComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyCharacterComponent:
    data: t.Mapping[str, "DestinyCharacterComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyInventoryComponent:
    data: t.Mapping[str, "DestinyInventoryComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyCharacterProgressionComponent:
    data: t.Mapping[str, "DestinyCharacterProgressionComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyCharacterRenderComponent:
    data: t.Mapping[str, "DestinyCharacterRenderComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyCharacterActivitiesComponent:
    data: t.Mapping[str, "DestinyCharacterActivitiesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyKiosksComponent:
    data: t.Mapping[str, "DestinyKiosksComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyPlugSetsComponent:
    data: t.Mapping[str, "DestinyPlugSetsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DestinyBaseItemComponentSetOfuint32:
    objectives: "DictionaryComponentResponseOfuint32AndDestinyItemObjectivesComponent"
    perks: "DictionaryComponentResponseOfuint32AndDestinyItemPerksComponent"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "objectives": to_json(self.objectives),
            "perks": to_json(self.perks),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyItemObjectivesComponent:
    data: t.Mapping[str, "DestinyItemObjectivesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyItemPerksComponent:
    data: t.Mapping[str, "DestinyItemPerksComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyPresentationNodesComponent:
    data: t.Mapping[str, "DestinyPresentationNodesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyCharacterRecordsComponent:
    data: t.Mapping[str, "DestinyCharacterRecordsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyCollectiblesComponent:
    data: t.Mapping[str, "DestinyCollectiblesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyStringVariablesComponent:
    data: t.Mapping[str, "DestinyStringVariablesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyCraftablesComponent:
    data: t.Mapping[str, "DestinyCraftablesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DestinyBaseItemComponentSetOfint64:
    objectives: "DictionaryComponentResponseOfint64AndDestinyItemObjectivesComponent"
    perks: "DictionaryComponentResponseOfint64AndDestinyItemPerksComponent"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "objectives": to_json(self.objectives),
            "perks": to_json(self.perks),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyItemObjectivesComponent:
    data: t.Mapping[str, "DestinyItemObjectivesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyItemPerksComponent:
    data: t.Mapping[str, "DestinyItemPerksComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DestinyItemComponentSetOfint64:
    instances: "DictionaryComponentResponseOfint64AndDestinyItemInstanceComponent"
    objectives: "DictionaryComponentResponseOfint64AndDestinyItemObjectivesComponent"
    perks: "DictionaryComponentResponseOfint64AndDestinyItemPerksComponent"
    plug_objectives: "DictionaryComponentResponseOfint64AndDestinyItemPlugObjectivesComponent"
    plug_states: "DictionaryComponentResponseOfuint32AndDestinyItemPlugComponent"
    render_data: "DictionaryComponentResponseOfint64AndDestinyItemRenderComponent"
    reusable_plugs: "DictionaryComponentResponseOfint64AndDestinyItemReusablePlugsComponent"
    sockets: "DictionaryComponentResponseOfint64AndDestinyItemSocketsComponent"
    stats: "DictionaryComponentResponseOfint64AndDestinyItemStatsComponent"
    talent_grids: "DictionaryComponentResponseOfint64AndDestinyItemTalentGridComponent"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "instances": to_json(self.instances),
            "renderData": to_json(self.render_data),
            "stats": to_json(self.stats),
            "sockets": to_json(self.sockets),
            "reusablePlugs": to_json(self.reusable_plugs),
            "plugObjectives": to_json(self.plug_objectives),
            "talentGrids": to_json(self.talent_grids),
            "plugStates": to_json(self.plug_states),
            "objectives": to_json(self.objectives),
            "perks": to_json(self.perks),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyItemInstanceComponent:
    data: t.Mapping[str, "DestinyItemInstanceComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyItemRenderComponent:
    data: t.Mapping[str, "DestinyItemRenderComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyItemStatsComponent:
    data: t.Mapping[str, "DestinyItemStatsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyItemSocketsComponent:
    data: t.Mapping[str, "DestinyItemSocketsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyItemReusablePlugsComponent:
    data: t.Mapping[str, "DestinyItemReusablePlugsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyItemPlugObjectivesComponent:
    data: t.Mapping[str, "DestinyItemPlugObjectivesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyItemTalentGridComponent:
    data: t.Mapping[str, "DestinyItemTalentGridComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyItemPlugComponent:
    data: t.Mapping[str, "DestinyItemPlugComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint64AndDestinyCurrenciesComponent:
    data: t.Mapping[str, "DestinyCurrenciesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyCharacterComponent:
    data: "DestinyCharacterComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyCharacterProgressionComponent:
    data: "DestinyCharacterProgressionComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyCharacterRenderComponent:
    data: "DestinyCharacterRenderComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyCharacterActivitiesComponent:
    data: "DestinyCharacterActivitiesComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyCharacterRecordsComponent:
    data: "DestinyCharacterRecordsComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyCollectiblesComponent:
    data: "DestinyCollectiblesComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyCurrenciesComponent:
    data: "DestinyCurrenciesComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyItemComponent:
    data: "DestinyItemComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyItemInstanceComponent:
    data: "DestinyItemInstanceComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyItemObjectivesComponent:
    data: "DestinyItemObjectivesComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyItemPerksComponent:
    data: "DestinyItemPerksComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyItemRenderComponent:
    data: "DestinyItemRenderComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyItemStatsComponent:
    data: "DestinyItemStatsComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyItemTalentGridComponent:
    data: "DestinyItemTalentGridComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyItemSocketsComponent:
    data: "DestinyItemSocketsComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyItemReusablePlugsComponent:
    data: "DestinyItemReusablePlugsComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyItemPlugObjectivesComponent:
    data: "DestinyItemPlugObjectivesComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyVendorGroupComponent:
    data: "DestinyVendorGroupComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyVendorComponent:
    data: t.Mapping[str, "DestinyVendorComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyVendorCategoriesComponent:
    data: t.Mapping[str, "DestinyVendorCategoriesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DestinyVendorSaleItemSetComponentOfDestinyVendorSaleItemComponent:
    sale_items: t.Mapping[str, "DestinyVendorSaleItemComponent"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "saleItems": to_json(self.sale_items),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndPersonalDestinyVendorSaleItemSetComponent:
    data: t.Mapping[str, "PersonalDestinyVendorSaleItemSetComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DestinyBaseItemComponentSetOfint32:
    objectives: "DictionaryComponentResponseOfint32AndDestinyItemObjectivesComponent"
    perks: "DictionaryComponentResponseOfint32AndDestinyItemPerksComponent"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "objectives": to_json(self.objectives),
            "perks": to_json(self.perks),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint32AndDestinyItemObjectivesComponent:
    data: t.Mapping[str, "DestinyItemObjectivesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint32AndDestinyItemPerksComponent:
    data: t.Mapping[str, "DestinyItemPerksComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DestinyItemComponentSetOfint32:
    instances: "DictionaryComponentResponseOfint32AndDestinyItemInstanceComponent"
    objectives: "DictionaryComponentResponseOfint32AndDestinyItemObjectivesComponent"
    perks: "DictionaryComponentResponseOfint32AndDestinyItemPerksComponent"
    plug_objectives: "DictionaryComponentResponseOfint32AndDestinyItemPlugObjectivesComponent"
    plug_states: "DictionaryComponentResponseOfuint32AndDestinyItemPlugComponent"
    render_data: "DictionaryComponentResponseOfint32AndDestinyItemRenderComponent"
    reusable_plugs: "DictionaryComponentResponseOfint32AndDestinyItemReusablePlugsComponent"
    sockets: "DictionaryComponentResponseOfint32AndDestinyItemSocketsComponent"
    stats: "DictionaryComponentResponseOfint32AndDestinyItemStatsComponent"
    talent_grids: "DictionaryComponentResponseOfint32AndDestinyItemTalentGridComponent"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "instances": to_json(self.instances),
            "renderData": to_json(self.render_data),
            "stats": to_json(self.stats),
            "sockets": to_json(self.sockets),
            "reusablePlugs": to_json(self.reusable_plugs),
            "plugObjectives": to_json(self.plug_objectives),
            "talentGrids": to_json(self.talent_grids),
            "plugStates": to_json(self.plug_states),
            "objectives": to_json(self.objectives),
            "perks": to_json(self.perks),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint32AndDestinyItemInstanceComponent:
    data: t.Mapping[str, "DestinyItemInstanceComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint32AndDestinyItemRenderComponent:
    data: t.Mapping[str, "DestinyItemRenderComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint32AndDestinyItemStatsComponent:
    data: t.Mapping[str, "DestinyItemStatsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint32AndDestinyItemSocketsComponent:
    data: t.Mapping[str, "DestinyItemSocketsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint32AndDestinyItemReusablePlugsComponent:
    data: t.Mapping[str, "DestinyItemReusablePlugsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint32AndDestinyItemPlugObjectivesComponent:
    data: t.Mapping[str, "DestinyItemPlugObjectivesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint32AndDestinyItemTalentGridComponent:
    data: t.Mapping[str, "DestinyItemTalentGridComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyVendorComponent:
    data: "DestinyVendorComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SingleComponentResponseOfDestinyVendorCategoriesComponent:
    data: "DestinyVendorCategoriesComponent"
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfint32AndDestinyVendorSaleItemComponent:
    data: t.Mapping[str, "DestinyVendorSaleItemComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyPublicVendorComponent:
    data: t.Mapping[str, "DestinyPublicVendorComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DestinyVendorSaleItemSetComponentOfDestinyPublicVendorSaleItemComponent:
    sale_items: t.Mapping[str, "DestinyPublicVendorSaleItemComponent"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "saleItems": to_json(self.sale_items),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndPublicDestinyVendorSaleItemSetComponent:
    data: t.Mapping[str, "PublicDestinyVendorSaleItemSetComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DestinyItemComponentSetOfuint32:
    instances: "DictionaryComponentResponseOfuint32AndDestinyItemInstanceComponent"
    objectives: "DictionaryComponentResponseOfuint32AndDestinyItemObjectivesComponent"
    perks: "DictionaryComponentResponseOfuint32AndDestinyItemPerksComponent"
    plug_objectives: "DictionaryComponentResponseOfuint32AndDestinyItemPlugObjectivesComponent"
    plug_states: "DictionaryComponentResponseOfuint32AndDestinyItemPlugComponent"
    render_data: "DictionaryComponentResponseOfuint32AndDestinyItemRenderComponent"
    reusable_plugs: "DictionaryComponentResponseOfuint32AndDestinyItemReusablePlugsComponent"
    sockets: "DictionaryComponentResponseOfuint32AndDestinyItemSocketsComponent"
    stats: "DictionaryComponentResponseOfuint32AndDestinyItemStatsComponent"
    talent_grids: "DictionaryComponentResponseOfuint32AndDestinyItemTalentGridComponent"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "instances": to_json(self.instances),
            "renderData": to_json(self.render_data),
            "stats": to_json(self.stats),
            "sockets": to_json(self.sockets),
            "reusablePlugs": to_json(self.reusable_plugs),
            "plugObjectives": to_json(self.plug_objectives),
            "talentGrids": to_json(self.talent_grids),
            "plugStates": to_json(self.plug_states),
            "objectives": to_json(self.objectives),
            "perks": to_json(self.perks),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyItemInstanceComponent:
    data: t.Mapping[str, "DestinyItemInstanceComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyItemRenderComponent:
    data: t.Mapping[str, "DestinyItemRenderComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyItemStatsComponent:
    data: t.Mapping[str, "DestinyItemStatsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyItemSocketsComponent:
    data: t.Mapping[str, "DestinyItemSocketsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyItemReusablePlugsComponent:
    data: t.Mapping[str, "DestinyItemReusablePlugsComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyItemPlugObjectivesComponent:
    data: t.Mapping[str, "DestinyItemPlugObjectivesComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class DictionaryComponentResponseOfuint32AndDestinyItemTalentGridComponent:
    data: t.Mapping[str, "DestinyItemTalentGridComponent"]
    privacy: "ComponentPrivacySetting"
    disabled: t.Optional[bool] = dt.field(
        default=None, metadata={"description": "If true, this component is disabled."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "data": to_json(self.data),
            "privacy": to_json(self.privacy),
            "disabled": to_json(self.disabled),
        }


@dt.dataclass(frozen=True)
class SearchResultOfDestinyEntitySearchResultItem:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["DestinyEntitySearchResultItem"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class SearchResultOfTrendingEntry:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["TrendingEntry"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class SearchResultOfFireteamSummary:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["FireteamSummary"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class SearchResultOfFireteamResponse:
    has_more: bool
    query: "PagedQuery"
    replacement_continuation_token: str
    results: t.Sequence["FireteamResponse"]
    total_results: int
    use_total_results: bool = dt.field(
        metadata={
            "description": """If useTotalResults is true, then totalResults represents an accurate count.
If False, it does not, and may be estimated/only the size of the current page.
Either way, you should probably always only trust hasMore.
This is a long-held historical throwback to when we used to do paging with known total results. Those queries toasted our database, and we were left to hastily alter our endpoints and create backward- compatible shims, of which useTotalResults is one."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "results": to_json(self.results),
            "totalResults": to_json(self.total_results),
            "hasMore": to_json(self.has_more),
            "query": to_json(self.query),
            "replacementContinuationToken": to_json(
                self.replacement_continuation_token
            ),
            "useTotalResults": to_json(self.use_total_results),
        }


@dt.dataclass(frozen=True)
class GlobalAlert:
    alert_html: str
    alert_key: str
    alert_level: "GlobalAlertLevel"
    alert_link: str
    alert_timestamp: str
    alert_type: "GlobalAlertType"
    stream_info: "StreamInfo"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "AlertKey": to_json(self.alert_key),
            "AlertHtml": to_json(self.alert_html),
            "AlertTimestamp": to_json(self.alert_timestamp),
            "AlertLink": to_json(self.alert_link),
            "AlertLevel": to_json(self.alert_level),
            "AlertType": to_json(self.alert_type),
            "StreamInfo": to_json(self.stream_info),
        }


class GlobalAlertLevel(Enum):
    UNKNOWN = 0
    BLUE = 1
    YELLOW = 2
    RED = 3


class GlobalAlertType(Enum):
    GLOBAL_ALERT = 0
    STREAMING_ALERT = 1


@dt.dataclass(frozen=True)
class StreamInfo:
    channel_name: str

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "ChannelName": to_json(self.channel_name),
        }


from bungieapi.generated.components.schemas.components import (  # noqa: E402
    ComponentPrivacySetting,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.content import (  # noqa: E402
    ContentItemPublicContract,
)
from bungieapi.generated.components.schemas.destiny.components.collectibles import (  # noqa: E402
    DestinyCollectiblesComponent,
    DestinyProfileCollectiblesComponent,
)
from bungieapi.generated.components.schemas.destiny.components.craftables import (  # noqa: E402
    DestinyCraftablesComponent,
)
from bungieapi.generated.components.schemas.destiny.components.inventory import (  # noqa: E402
    DestinyCurrenciesComponent,
    DestinyPlatformSilverComponent,
)
from bungieapi.generated.components.schemas.destiny.components.items import (  # noqa: E402
    DestinyItemPlugComponent,
    DestinyItemPlugObjectivesComponent,
    DestinyItemReusablePlugsComponent,
)
from bungieapi.generated.components.schemas.destiny.components.kiosks import (  # noqa: E402
    DestinyKiosksComponent,
)
from bungieapi.generated.components.schemas.destiny.components.metrics import (  # noqa: E402
    DestinyMetricsComponent,
)
from bungieapi.generated.components.schemas.destiny.components.plug_sets import (  # noqa: E402
    DestinyPlugSetsComponent,
)
from bungieapi.generated.components.schemas.destiny.components.presentation import (  # noqa: E402
    DestinyPresentationNodesComponent,
)
from bungieapi.generated.components.schemas.destiny.components.profiles import (  # noqa: E402
    DestinyProfileProgressionComponent,
    DestinyProfileTransitoryComponent,
)
from bungieapi.generated.components.schemas.destiny.components.records import (  # noqa: E402
    DestinyCharacterRecordsComponent,
    DestinyProfileRecordsComponent,
)
from bungieapi.generated.components.schemas.destiny.components.string_variables import (  # noqa: E402
    DestinyStringVariablesComponent,
)
from bungieapi.generated.components.schemas.destiny.components.vendors import (  # noqa: E402
    DestinyPublicVendorComponent,
    DestinyPublicVendorSaleItemComponent,
    DestinyVendorGroupComponent,
)
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyEntitySearchResultItem,
)
from bungieapi.generated.components.schemas.destiny.entities.characters import (  # noqa: E402
    DestinyCharacterActivitiesComponent,
    DestinyCharacterComponent,
    DestinyCharacterProgressionComponent,
    DestinyCharacterRenderComponent,
)
from bungieapi.generated.components.schemas.destiny.entities.inventory import (  # noqa: E402
    DestinyInventoryComponent,
)
from bungieapi.generated.components.schemas.destiny.entities.items import (  # noqa: E402
    DestinyItemComponent,
    DestinyItemInstanceComponent,
    DestinyItemObjectivesComponent,
    DestinyItemPerksComponent,
    DestinyItemRenderComponent,
    DestinyItemSocketsComponent,
    DestinyItemStatsComponent,
    DestinyItemTalentGridComponent,
)
from bungieapi.generated.components.schemas.destiny.entities.profiles import (  # noqa: E402
    DestinyProfileComponent,
    DestinyVendorReceiptsComponent,
)
from bungieapi.generated.components.schemas.destiny.entities.vendors import (  # noqa: E402
    DestinyVendorCategoriesComponent,
    DestinyVendorComponent,
    DestinyVendorSaleItemComponent,
)
from bungieapi.generated.components.schemas.destiny.responses import (  # noqa: E402
    PersonalDestinyVendorSaleItemSetComponent,
    PublicDestinyVendorSaleItemSetComponent,
)
from bungieapi.generated.components.schemas.fireteam import (  # noqa: E402
    FireteamResponse,
    FireteamSummary,
)
from bungieapi.generated.components.schemas.forum import PostResponse  # noqa: E402
from bungieapi.generated.components.schemas.groups_v2 import GroupBan  # noqa: E402
from bungieapi.generated.components.schemas.groups_v2 import GroupMember  # noqa: E402
from bungieapi.generated.components.schemas.groups_v2 import GroupV2Card  # noqa: E402
from bungieapi.generated.components.schemas.groups_v2 import (  # noqa: E402
    GroupMemberApplication,
    GroupMembership,
    GroupPotentialMembership,
)
from bungieapi.generated.components.schemas.queries import PagedQuery  # noqa: E402
from bungieapi.generated.components.schemas.trending import TrendingEntry  # noqa: E402
