# generated by update to not change manually
import dataclasses as dt
import typing as t
from enum import Enum, Flag

from bungieapi.json import to_json


class ApplicationScopes(Flag):
    READ_BASIC_USER_PROFILE = 1  # Read basic user profile information such as the user's handle, avatar icon, etc.
    READ_GROUPS = 2  # Read Group/Clan Forums, Wall, and Members for groups and clans that the user has joined.
    WRITE_GROUPS = 4  # Write Group/Clan Forums, Wall, and Members for groups and clans that the user has joined.
    ADMIN_GROUPS = 8  # Administer Group/Clan Forums, Wall, and Members for groups and clans that the user is a founder or an administrator.
    BNET_WRITE = 16  # Create new groups, clans, and forum posts, along with other actions that are reserved for Bungie.net elevated scope: not meant to be used by third party applications.
    MOVE_EQUIP_DESTINY_ITEMS = 32  # Move or equip Destiny items
    READ_DESTINY_INVENTORY_AND_VAULT = 64  # Read Destiny 1 Inventory and Vault contents. For Destiny 2, this scope is needed to read anything regarded as private. This is the only scope a Destiny 2 app needs for read operations against Destiny 2 data such as inventory, vault, currency, vendors, milestones, progression, etc.
    READ_USER_DATA = 128  # Read user data such as who they are web notifications, clan/group memberships, recent activity, muted users.
    EDIT_USER_DATA = 256  # Edit user data such as preferred language, status, motto, avatar selection and theme.
    READ_DESTINY_VENDORS_AND_ADVISORS = 512  # Access vendor and advisor data specific to a user. OBSOLETE. This scope is only used on the Destiny 1 API.
    READ_AND_APPLY_TOKENS = (
        1024  # Read offer history and claim and apply tokens for the user.
    )
    ADVANCED_WRITE_ACTIONS = 2048  # Can perform actions that will result in a prompt to the user via the Destiny app.
    PARTNER_OFFER_GRANT = (
        4096  # Can user the partner offer api to claim rewards defined for a partner
    )
    DESTINY_UNLOCK_VALUE_QUERY = 8192  # Allows an app to query sensitive information like unlock flags and values not available through normal methods.
    USER_PII_READ = 16384  # Allows an app to query sensitive user PII, most notably email information.


@dt.dataclass(frozen=True)
class ApiUsage:
    api_calls: t.Sequence["Series"] = dt.field(
        metadata={"description": "Counts for on API calls made for the time range."}
    )
    throttled_requests: t.Sequence["Series"] = dt.field(
        metadata={
            "description": "Instances of blocked requests or requests that crossed the warn threshold during the time range."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "apiCalls": to_json(self.api_calls),
            "throttledRequests": to_json(self.throttled_requests),
        }


@dt.dataclass(frozen=True)
class Series:
    datapoints: t.Sequence["Datapoint"] = dt.field(
        metadata={"description": "Collection of samples with time and value."}
    )
    target: str = dt.field(
        metadata={"description": "Target to which to datapoints apply."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "datapoints": to_json(self.datapoints),
            "target": to_json(self.target),
        }


@dt.dataclass(frozen=True)
class Datapoint:
    time: str = dt.field(metadata={"description": "Timestamp for the related count."})
    count: t.Optional[float] = dt.field(
        default=None, metadata={"description": "Count associated with timestamp"}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "time": to_json(self.time),
            "count": to_json(self.count),
        }


@dt.dataclass(frozen=True)
class Application:
    application_id: int = dt.field(
        metadata={"description": "Unique ID assigned to the application"}
    )
    creation_date: str = dt.field(
        metadata={
            "description": "Date the application was first added to our database."
        }
    )
    first_published: str = dt.field(
        metadata={
            "description": "Date the first time the application status entered the 'Public' status."
        }
    )
    link: str = dt.field(
        metadata={
            "description": "Link to website for the application where a user can learn more about the app."
        }
    )
    name: str = dt.field(metadata={"description": "Name of the application"})
    origin: str = dt.field(
        metadata={
            "description": "Value of the Origin header sent in requests generated by this application."
        }
    )
    override_authorize_view_name: str = dt.field(
        metadata={"description": "An optional override for the Authorize view name."}
    )
    redirect_url: str = dt.field(
        metadata={
            "description": "URL used to pass the user's authorization code to the application"
        }
    )
    scope: int = dt.field(
        metadata={"description": "Permissions the application needs to work"}
    )
    status: "ApplicationStatus" = dt.field(
        metadata={"description": "Current status of the application."}
    )
    status_changed: str = dt.field(
        metadata={"description": "Date the application status last changed."}
    )
    team: t.Sequence["ApplicationDeveloper"] = dt.field(
        metadata={
            "description": "List of team members who manage this application on Bungie.net. Will always consist of at least the application owner."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "applicationId": to_json(self.application_id),
            "name": to_json(self.name),
            "redirectUrl": to_json(self.redirect_url),
            "link": to_json(self.link),
            "scope": to_json(self.scope),
            "origin": to_json(self.origin),
            "status": to_json(self.status),
            "creationDate": to_json(self.creation_date),
            "statusChanged": to_json(self.status_changed),
            "firstPublished": to_json(self.first_published),
            "team": to_json(self.team),
            "overrideAuthorizeViewName": to_json(self.override_authorize_view_name),
        }


class ApplicationStatus(Enum):
    NONE = 0  # No value assigned
    PRIVATE = 1  # Application exists and works but will not appear in any public catalog. New applications start in this state, test applications will remain in this state.
    PUBLIC = 2  # Active applications that can appear in an catalog.
    DISABLED = 3  # Application disabled by the owner. All authorizations will be treated as terminated while in this state. Owner can move back to private or public state.
    BLOCKED = 4  # Application has been blocked by Bungie. It cannot be transitioned out of this state by the owner. Authorizations are terminated when an application is in this state.


@dt.dataclass(frozen=True)
class ApplicationDeveloper:
    api_eula_version: int
    role: "DeveloperRole"
    user: "UserInfoCard"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "role": to_json(self.role),
            "apiEulaVersion": to_json(self.api_eula_version),
            "user": to_json(self.user),
        }


class DeveloperRole(Enum):
    NONE = 0
    OWNER = 1
    TEAM_MEMBER = 2


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.user import UserInfoCard  # noqa: E402
