# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class CoreSettingsConfiguration:
    clan_banner_decal_colors: t.Sequence["CoreSetting"]
    clan_banner_decals: t.Sequence["CoreSetting"]
    clan_banner_gonfalon_colors: t.Sequence["CoreSetting"]
    clan_banner_gonfalon_detail_colors: t.Sequence["CoreSetting"]
    clan_banner_gonfalon_details: t.Sequence["CoreSetting"]
    clan_banner_gonfalons: t.Sequence["CoreSetting"]
    clan_banner_standards: t.Sequence["CoreSetting"]
    destiny2_core_settings: "Destiny2CoreSettings"
    destiny_membership_types: t.Sequence["CoreSetting"]
    email_settings: "EmailSettings"
    environment: str
    fireteam_activities: t.Sequence["CoreSetting"]
    forum_categories: t.Sequence["CoreSetting"]
    group_avatars: t.Sequence["CoreSetting"]
    ignore_reasons: t.Sequence["CoreSetting"]
    recruitment_activities: t.Sequence["CoreSetting"]
    recruitment_misc_tags: t.Sequence["CoreSetting"]
    recruitment_platform_tags: t.Sequence["CoreSetting"]
    system_content_locales: t.Sequence["CoreSetting"]
    systems: t.Mapping[str, "CoreSystem"]
    user_content_locales: t.Sequence["CoreSetting"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "environment": to_json(self.environment),
            "systems": to_json(self.systems),
            "ignoreReasons": to_json(self.ignore_reasons),
            "forumCategories": to_json(self.forum_categories),
            "groupAvatars": to_json(self.group_avatars),
            "destinyMembershipTypes": to_json(self.destiny_membership_types),
            "recruitmentPlatformTags": to_json(self.recruitment_platform_tags),
            "recruitmentMiscTags": to_json(self.recruitment_misc_tags),
            "recruitmentActivities": to_json(self.recruitment_activities),
            "userContentLocales": to_json(self.user_content_locales),
            "systemContentLocales": to_json(self.system_content_locales),
            "clanBannerDecals": to_json(self.clan_banner_decals),
            "clanBannerDecalColors": to_json(self.clan_banner_decal_colors),
            "clanBannerGonfalons": to_json(self.clan_banner_gonfalons),
            "clanBannerGonfalonColors": to_json(self.clan_banner_gonfalon_colors),
            "clanBannerGonfalonDetails": to_json(self.clan_banner_gonfalon_details),
            "clanBannerGonfalonDetailColors": to_json(
                self.clan_banner_gonfalon_detail_colors
            ),
            "clanBannerStandards": to_json(self.clan_banner_standards),
            "destiny2CoreSettings": to_json(self.destiny2_core_settings),
            "emailSettings": to_json(self.email_settings),
            "fireteamActivities": to_json(self.fireteam_activities),
        }


@dt.dataclass(frozen=True)
class CoreSystem:
    enabled: bool
    parameters: t.Mapping[str, str]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "enabled": to_json(self.enabled),
            "parameters": to_json(self.parameters),
        }


@dt.dataclass(frozen=True)
class CoreSetting:
    child_settings: t.Sequence["CoreSetting"]
    display_name: str
    identifier: str
    image_path: str
    is_default: bool
    summary: str

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "identifier": to_json(self.identifier),
            "isDefault": to_json(self.is_default),
            "displayName": to_json(self.display_name),
            "summary": to_json(self.summary),
            "imagePath": to_json(self.image_path),
            "childSettings": to_json(self.child_settings),
        }


@dt.dataclass(frozen=True)
class Destiny2CoreSettings:
    active_seals_root_node_hash: ManifestReference["DestinyPresentationNodeDefinition"]
    active_triumphs_root_node_hash: ManifestReference[
        "DestinyPresentationNodeDefinition"
    ]
    ammo_type_heavy_icon: str
    ammo_type_primary_icon: str
    ammo_type_special_icon: str
    badges_root_node: ManifestReference["DestinyPresentationNodeDefinition"]
    collection_root_node: ManifestReference["DestinyPresentationNodeDefinition"]
    crafting_root_node_hash: ManifestReference["DestinyPresentationNodeDefinition"]
    current_rank_progression_hashes: t.Sequence[int]
    current_seasonal_artifact_hash: ManifestReference["DestinyVendorDefinition"]
    exotic_catalysts_root_node_hash: ManifestReference[
        "DestinyPresentationNodeDefinition"
    ]
    future_season_hashes: t.Sequence[int]
    insert_plug_free_blocked_socket_type_hashes: t.Sequence[int]
    insert_plug_free_protected_plug_item_hashes: t.Sequence[int]
    legacy_seals_root_node_hash: ManifestReference["DestinyPresentationNodeDefinition"]
    legacy_triumphs_root_node_hash: ManifestReference[
        "DestinyPresentationNodeDefinition"
    ]
    lore_root_node_hash: ManifestReference["DestinyPresentationNodeDefinition"]
    medals_root_node: ManifestReference["DestinyPresentationNodeDefinition"]
    medals_root_node_hash: ManifestReference["DestinyPresentationNodeDefinition"]
    metrics_root_node: ManifestReference["DestinyPresentationNodeDefinition"]
    past_season_hashes: t.Sequence[int]
    records_root_node: ManifestReference["DestinyPresentationNodeDefinition"]
    undiscovered_collectible_image: str
    current_season_hash: t.Optional[ManifestReference["DestinySeasonDefinition"]] = None
    seasonal_challenges_presentation_node_hash: t.Optional[
        ManifestReference["DestinyPresentationNodeDefinition"]
    ] = None

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "collectionRootNode": to_json(self.collection_root_node),
            "badgesRootNode": to_json(self.badges_root_node),
            "recordsRootNode": to_json(self.records_root_node),
            "medalsRootNode": to_json(self.medals_root_node),
            "metricsRootNode": to_json(self.metrics_root_node),
            "activeTriumphsRootNodeHash": to_json(self.active_triumphs_root_node_hash),
            "activeSealsRootNodeHash": to_json(self.active_seals_root_node_hash),
            "legacyTriumphsRootNodeHash": to_json(self.legacy_triumphs_root_node_hash),
            "legacySealsRootNodeHash": to_json(self.legacy_seals_root_node_hash),
            "medalsRootNodeHash": to_json(self.medals_root_node_hash),
            "exoticCatalystsRootNodeHash": to_json(
                self.exotic_catalysts_root_node_hash
            ),
            "loreRootNodeHash": to_json(self.lore_root_node_hash),
            "craftingRootNodeHash": to_json(self.crafting_root_node_hash),
            "currentRankProgressionHashes": to_json(
                self.current_rank_progression_hashes
            ),
            "insertPlugFreeProtectedPlugItemHashes": to_json(
                self.insert_plug_free_protected_plug_item_hashes
            ),
            "insertPlugFreeBlockedSocketTypeHashes": to_json(
                self.insert_plug_free_blocked_socket_type_hashes
            ),
            "undiscoveredCollectibleImage": to_json(
                self.undiscovered_collectible_image
            ),
            "ammoTypeHeavyIcon": to_json(self.ammo_type_heavy_icon),
            "ammoTypeSpecialIcon": to_json(self.ammo_type_special_icon),
            "ammoTypePrimaryIcon": to_json(self.ammo_type_primary_icon),
            "currentSeasonalArtifactHash": to_json(self.current_seasonal_artifact_hash),
            "currentSeasonHash": to_json(self.current_season_hash),
            "seasonalChallengesPresentationNodeHash": to_json(
                self.seasonal_challenges_presentation_node_hash
            ),
            "futureSeasonHashes": to_json(self.future_season_hashes),
            "pastSeasonHashes": to_json(self.past_season_hashes),
        }


from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyVendorDefinition,
)
from bungieapi.generated.components.schemas.destiny.definitions.presentation import (  # noqa: E402
    DestinyPresentationNodeDefinition,
)
from bungieapi.generated.components.schemas.destiny.definitions.seasons import (  # noqa: E402
    DestinySeasonDefinition,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.user import EmailSettings  # noqa: E402
