# generated by update to not change manually
import dataclasses as dt
import typing as t
from enum import Enum

from bungieapi.json import to_json


@dt.dataclass(frozen=True)
class AwaInitializeResponse:
    correlation_id: str = dt.field(
        metadata={
            "description": "ID used to get the token. Present this ID to the user as it will identify this specific request on their device."
        }
    )
    sent_to_self: bool = dt.field(
        metadata={
            "description": "True if the PUSH message will only be sent to the device that made this request."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "correlationId": to_json(self.correlation_id),
            "sentToSelf": to_json(self.sent_to_self),
        }


@dt.dataclass(frozen=True)
class AwaPermissionRequested:
    membership_type: "BungieMembershipType" = dt.field(
        metadata={"description": "Destiny membership type of the account to modify."}
    )
    type: "AwaType" = dt.field(
        metadata={"description": "Type of advanced write action."}
    )
    affected_item_id: t.Optional[int] = dt.field(
        default=None,
        metadata={
            "description": "Item instance ID the action shall be applied to. This is optional for all but a new AwaType values. Rule of thumb is to provide the item instance ID if one is available."
        },
    )
    character_id: t.Optional[int] = dt.field(
        default=None,
        metadata={
            "description": "Destiny character ID, if applicable, that will be affected by the action."
        },
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "type": to_json(self.type),
            "affectedItemId": to_json(self.affected_item_id),
            "membershipType": to_json(self.membership_type),
            "characterId": to_json(self.character_id),
        }


class AwaType(Enum):
    NONE = 0
    INSERT_PLUGS = 1  # Insert plugs into sockets.


@dt.dataclass(frozen=True)
class AwaUserResponse:
    correlation_id: str = dt.field(
        metadata={"description": "Correlation ID of the request"}
    )
    nonce: t.Sequence[str] = dt.field(
        metadata={"description": "Secret nonce received via the PUSH notification."}
    )
    selection: "AwaUserSelection" = dt.field(
        metadata={
            "description": "Indication of the selection the user has made (Approving or rejecting the action)"
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "selection": to_json(self.selection),
            "correlationId": to_json(self.correlation_id),
            "nonce": to_json(self.nonce),
        }


class AwaUserSelection(Enum):
    NONE = 0
    REJECTED = 1
    APPROVED = 2


@dt.dataclass(frozen=True)
class AwaAuthorizationResult:
    action_token: str = dt.field(
        metadata={
            "description": "Credential used to prove the user authorized an advanced write action."
        }
    )
    developer_note: str = dt.field(
        metadata={
            "description": "Message to the app developer to help understand the response."
        }
    )
    maximum_number_of_uses: int = dt.field(
        metadata={
            "description": "This token may be used to perform the requested action this number of times, at a maximum. If this value is 0, then there is no limit."
        }
    )
    membership_type: "BungieMembershipType" = dt.field(
        metadata={"description": "MembershipType from the permission request."}
    )
    response_reason: "AwaResponseReason"
    type: "AwaType" = dt.field(
        metadata={
            "description": "Advanced Write Action Type from the permission request."
        }
    )
    user_selection: "AwaUserSelection" = dt.field(
        metadata={
            "description": 'Indication of how the user responded to the request. If the value is "Approved" the actionToken will contain the token that can be presented when performing the advanced write action.'
        }
    )
    valid_until: t.Optional[str] = dt.field(
        default=None, metadata={"description": "Time, UTC, when token expires."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "userSelection": to_json(self.user_selection),
            "responseReason": to_json(self.response_reason),
            "developerNote": to_json(self.developer_note),
            "actionToken": to_json(self.action_token),
            "maximumNumberOfUses": to_json(self.maximum_number_of_uses),
            "validUntil": to_json(self.valid_until),
            "type": to_json(self.type),
            "membershipType": to_json(self.membership_type),
        }


class AwaResponseReason(Enum):
    NONE = 0
    ANSWERED = 1  # User provided an answer
    TIMED_OUT = 2  # The HTTP request timed out, a new request may be made and an answer may still be provided.
    REPLACED = 3  # This request was replaced by another request.


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas import BungieMembershipType  # noqa: E402
