# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyArtifactProfileScoped:
    """Represents a Seasonal Artifact and all data related to it for the
    requested Account.

    It can be combined with Character-scoped data for a full picture of
    what a character has available/has chosen, or just these settings
    can be used for overview information.
    """

    artifact_hash: ManifestReference["DestinyArtifactDefinition"]
    point_progression: "DestinyProgression"
    points_acquired: int
    power_bonus: int
    power_bonus_progression: "DestinyProgression"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "artifactHash": to_json(self.artifact_hash),
            "pointProgression": to_json(self.point_progression),
            "pointsAcquired": to_json(self.points_acquired),
            "powerBonusProgression": to_json(self.power_bonus_progression),
            "powerBonus": to_json(self.power_bonus),
        }


@dt.dataclass(frozen=True)
class DestinyArtifactCharacterScoped:
    artifact_hash: ManifestReference["DestinyArtifactDefinition"]
    points_used: int
    reset_count: int
    tiers: t.Sequence["DestinyArtifactTier"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "artifactHash": to_json(self.artifact_hash),
            "pointsUsed": to_json(self.points_used),
            "resetCount": to_json(self.reset_count),
            "tiers": to_json(self.tiers),
        }


@dt.dataclass(frozen=True)
class DestinyArtifactTier:
    is_unlocked: bool
    items: t.Sequence["DestinyArtifactTierItem"]
    points_to_unlock: int
    tier_hash: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "tierHash": to_json(self.tier_hash),
            "isUnlocked": to_json(self.is_unlocked),
            "pointsToUnlock": to_json(self.points_to_unlock),
            "items": to_json(self.items),
        }


@dt.dataclass(frozen=True)
class DestinyArtifactTierItem:
    is_active: bool
    item_hash: ManifestReference["DestinyInventoryItemDefinition"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "itemHash": to_json(self.item_hash),
            "isActive": to_json(self.is_active),
        }


from bungieapi.generated.components.schemas.destiny import (  # noqa: E402
    DestinyProgression,
)
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyInventoryItemDefinition,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions.artifacts import (  # noqa: E402
    DestinyArtifactDefinition,
)
