# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyCharacterCustomization:
    """Raw data about the customization options chosen for a character's face
    and appearance.

    You can look up the relevant class/race/gender combo in
    DestinyCharacterCustomizationOptionDefinition for the character, and
    then look up these values within the CustomizationOptions found to
    pull some data about their choices. Warning: not all of that data is
    meaningful. Some data has useful icons. Others have nothing, and are
    only meant for 3D rendering purposes (which we sadly do not expose
    yet)
    """

    decal_color: int
    decal_index: int
    eye_color: int
    face: int
    feature_colors: t.Sequence[int]
    feature_index: int
    hair_colors: t.Sequence[int]
    hair_index: int
    lip_color: int
    personality: int
    skin_color: int
    wear_helmet: bool

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "personality": to_json(self.personality),
            "face": to_json(self.face),
            "skinColor": to_json(self.skin_color),
            "lipColor": to_json(self.lip_color),
            "eyeColor": to_json(self.eye_color),
            "hairColors": to_json(self.hair_colors),
            "featureColors": to_json(self.feature_colors),
            "decalColor": to_json(self.decal_color),
            "wearHelmet": to_json(self.wear_helmet),
            "hairIndex": to_json(self.hair_index),
            "featureIndex": to_json(self.feature_index),
            "decalIndex": to_json(self.decal_index),
        }


@dt.dataclass(frozen=True)
class DestinyCharacterPeerView:
    """A minimal view of a character's equipped items, for the purpose of
    rendering a summary screen or showing the character in 3D."""

    equipment: t.Sequence["DestinyItemPeerView"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "equipment": to_json(self.equipment),
        }


@dt.dataclass(frozen=True)
class DestinyItemPeerView:
    """Bare minimum summary information for an item, for the sake of 3D
    rendering the item."""

    dyes: t.Sequence["DyeReference"] = dt.field(
        metadata={
            "description": "The list of dyes that have been applied to this item."
        }
    )
    item_hash: ManifestReference["DestinyInventoryItemDefinition"] = dt.field(
        metadata={
            "description": "The hash identifier of the item in question. Use it to look up the DestinyInventoryItemDefinition of the item for static rendering data."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "itemHash": to_json(self.item_hash),
            "dyes": to_json(self.dyes),
        }


from bungieapi.generated.components.schemas.destiny import DyeReference  # noqa: E402

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyInventoryItemDefinition,
)
