# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyCraftablesComponent:
    craftables: t.Mapping[str, "DestinyCraftableComponent"] = dt.field(
        metadata={
            "description": "A map of craftable item hashes to craftable item state components."
        }
    )
    crafting_root_node_hash: ManifestReference[
        "DestinyPresentationNodeDefinition"
    ] = dt.field(
        metadata={
            "description": "The hash for the root presentation node definition of craftable item categories."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "craftables": to_json(self.craftables),
            "craftingRootNodeHash": to_json(self.crafting_root_node_hash),
        }


@dt.dataclass(frozen=True)
class DestinyCraftableComponent:
    failed_requirement_indexes: t.Sequence[int] = dt.field(
        metadata={
            "description": "If the requirements are not met for crafting this item, these will index into the list of failure strings."
        }
    )
    sockets: t.Sequence["DestinyCraftableSocketComponent"] = dt.field(
        metadata={"description": "Plug item state for the crafting sockets."}
    )
    visible: bool

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "visible": to_json(self.visible),
            "failedRequirementIndexes": to_json(self.failed_requirement_indexes),
            "sockets": to_json(self.sockets),
        }


@dt.dataclass(frozen=True)
class DestinyCraftableSocketComponent:
    plug_set_hash: ManifestReference["DestinyPlugSetDefinition"]
    plugs: t.Sequence["DestinyCraftableSocketPlugComponent"] = dt.field(
        metadata={
            "description": "Unlock state for plugs in the socket plug set definition"
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "plugSetHash": to_json(self.plug_set_hash),
            "plugs": to_json(self.plugs),
        }


@dt.dataclass(frozen=True)
class DestinyCraftableSocketPlugComponent:
    failed_requirement_indexes: t.Sequence[int] = dt.field(
        metadata={
            "description": "Index into the unlock requirements to display failure descriptions"
        }
    )
    plug_item_hash: ManifestReference["DestinyInventoryItemDefinition"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "plugItemHash": to_json(self.plug_item_hash),
            "failedRequirementIndexes": to_json(self.failed_requirement_indexes),
        }


from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyInventoryItemDefinition,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions.presentation import (  # noqa: E402
    DestinyPresentationNodeDefinition,
)
from bungieapi.generated.components.schemas.destiny.definitions.sockets import (  # noqa: E402
    DestinyPlugSetDefinition,
)
