# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json


@dt.dataclass(frozen=True)
class DestinyKiosksComponent:
    """A Kiosk is a Vendor (DestinyVendorDefinition) that sells items based on
    whether you have already acquired that item before.

    This component returns information about what Kiosk items are
    available to you on a *Profile* level. It is theoretically possible
    for Kiosks to have items gated by specific Character as well. If you
    ever have those, you will find them on the individual character's
    DestinyCharacterKiosksComponent. Note that, because this component
    returns vendorItemIndexes (that is to say, indexes into the Kiosk
    Vendor's itemList property), these results are necessarily content
    version dependent. Make sure that you have the latest version of the
    content manifest databases before using this data.
    """

    kiosk_items: t.Mapping[str, t.Sequence["DestinyKioskItem"]] = dt.field(
        metadata={
            "description": 'A dictionary keyed by the Kiosk Vendor\'s hash identifier (use it to look up the DestinyVendorDefinition for the relevant kiosk vendor), and whose value is a list of all the items that the user can "see" in the Kiosk, and any other interesting metadata.'
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "kioskItems": to_json(self.kiosk_items),
        }


@dt.dataclass(frozen=True)
class DestinyKioskItem:
    can_acquire: bool = dt.field(
        metadata={
            "description": "If true, the user can not only see the item, but they can acquire it. It is possible that a user can see a kiosk item and not be able to acquire it."
        }
    )
    failure_indexes: t.Sequence[int] = dt.field(
        metadata={
            "description": "Indexes into failureStrings for the Vendor, indicating the reasons why it failed if any."
        }
    )
    flavor_objective: "DestinyObjectiveProgress" = dt.field(
        metadata={
            "description": 'I may regret naming it this way - but this represents when an item has an objective that doesn\'t serve a beneficial purpose, but rather is used for "flavor" or additional information. For instance, when Emblems track specific stats, those stats are represented as Objectives on the item.'
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the item in the related DestinyVendorDefintion's itemList property, representing the sale."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "index": to_json(self.index),
            "canAcquire": to_json(self.can_acquire),
            "failureIndexes": to_json(self.failure_indexes),
            "flavorObjective": to_json(self.flavor_objective),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.quests import (  # noqa: E402
    DestinyObjectiveProgress,
)
