# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyMetricsComponent:
    metrics: t.Mapping[str, "DestinyMetricComponent"]
    metrics_root_node_hash: ManifestReference["DestinyPresentationNodeDefinition"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "metrics": to_json(self.metrics),
            "metricsRootNodeHash": to_json(self.metrics_root_node_hash),
        }


@dt.dataclass(frozen=True)
class DestinyMetricComponent:
    invisible: bool
    objective_progress: "DestinyObjectiveProgress"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "invisible": to_json(self.invisible),
            "objectiveProgress": to_json(self.objective_progress),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions.presentation import (  # noqa: E402
    DestinyPresentationNodeDefinition,
)
from bungieapi.generated.components.schemas.destiny.quests import (  # noqa: E402
    DestinyObjectiveProgress,
)
