# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyProfileProgressionComponent:
    """The set of progression-related information that applies at a Profile-
    wide level for your Destiny experience.

    This differs from the Jimi Hendrix Experience because there's less
    guitars on fire. Yet. #spoileralert? This will include information
    such as Checklist info.
    """

    checklists: t.Mapping[str, t.Mapping[str, bool]] = dt.field(
        metadata={
            "description": """The set of checklists that can be examined on a profile-wide basis, keyed by the hash identifier of the Checklist (DestinyChecklistDefinition)
For each checklist returned, its value is itself a Dictionary keyed by the checklist's hash identifier with the value being a boolean indicating if it's been discovered yet."""
        }
    )
    seasonal_artifact: "DestinyArtifactProfileScoped" = dt.field(
        metadata={
            "description": "Data related to your progress on the current season's artifact that is the same across characters."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "checklists": to_json(self.checklists),
            "seasonalArtifact": to_json(self.seasonal_artifact),
        }


@dt.dataclass(frozen=True)
class DestinyProfileTransitoryComponent:
    """This is an experimental set of data that Bungie considers to be "transitory" - information that may be useful for API users, but that is coming from a non-authoritative data source about information that could potentially change at a more frequent pace than Bungie.net will receive updates about it.
    This information is provided exclusively for convenience should any of it be useful to users: we provide no guarantees to the accuracy or timeliness of data that comes from this source. Know that this data can potentially be out-of-date or even wrong entirely if the user disconnected from the game or suddenly changed their status before we can receive refreshed data."""

    current_activity: "DestinyProfileTransitoryCurrentActivity" = dt.field(
        metadata={
            "description": "If you are in an activity, this is some transitory info about the activity currently being played."
        }
    )
    joinability: "DestinyProfileTransitoryJoinability" = dt.field(
        metadata={
            "description": "Information about whether and what might prevent you from joining this person on a fireteam."
        }
    )
    party_members: t.Sequence["DestinyProfileTransitoryPartyMember"] = dt.field(
        metadata={
            "description": "If you have any members currently in your party, this is some (very) bare-bones information about those members."
        }
    )
    tracking: t.Sequence["DestinyProfileTransitoryTrackingEntry"] = dt.field(
        metadata={"description": "Information about tracked entities."}
    )
    last_orbited_destination_hash: t.Optional[
        ManifestReference["DestinyDestinationDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "The hash identifier for the DestinyDestinationDefinition of the last location you were orbiting when in orbit."
        },
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "partyMembers": to_json(self.party_members),
            "currentActivity": to_json(self.current_activity),
            "joinability": to_json(self.joinability),
            "tracking": to_json(self.tracking),
            "lastOrbitedDestinationHash": to_json(self.last_orbited_destination_hash),
        }


@dt.dataclass(frozen=True)
class DestinyProfileTransitoryPartyMember:
    """This is some bare minimum information about a party member in a
    Fireteam.

    Unfortunately, without great computational expense on our side we
    can only get at the data contained here. I'd like to give you a
    character ID for example, but we don't have it. But we do have these
    three pieces of information. May they help you on your quest to show
    meaningful data about current Fireteams. Notably, we don't and can't
    feasibly return info on characters. If you can, try to use just the
    data below for your UI and purposes. Only hit us with further
    queries if you absolutely must know the character ID of the
    currently playing character. Pretty please with sugar on top.
    """

    display_name: str = dt.field(
        metadata={"description": "The player's last known display name."}
    )
    emblem_hash: ManifestReference["DestinyInventoryItemDefinition"] = dt.field(
        metadata={
            "description": "The identifier for the DestinyInventoryItemDefinition of the player's emblem."
        }
    )
    membership_id: int = dt.field(
        metadata={"description": "The Membership ID that matches the party member."}
    )
    status: "DestinyPartyMemberStates" = dt.field(
        metadata={
            "description": "A Flags Enumeration value indicating the states that the player is in relevant to being on a fireteam."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "membershipId": to_json(self.membership_id),
            "emblemHash": to_json(self.emblem_hash),
            "displayName": to_json(self.display_name),
            "status": to_json(self.status),
        }


@dt.dataclass(frozen=True)
class DestinyProfileTransitoryCurrentActivity:
    """If you are playing in an activity, this is some information about it.

    Note that we cannot guarantee any of this resembles what ends up in
    the PGCR in any way. They are sourced by two entirely separate
    systems with their own logic, and the one we source this data from
    should be considered non-authoritative in comparison.
    """

    highest_opposing_faction_score: float = dt.field(
        metadata={
            "description": "If you have human opponents, this is the highest opposing team's score."
        }
    )
    number_of_opponents: int = dt.field(
        metadata={
            "description": "This is how many human or poorly crafted aimbot opponents you have."
        }
    )
    number_of_players: int = dt.field(
        metadata={
            "description": "This is how many human or poorly crafted aimbots are on your team."
        }
    )
    score: float = dt.field(
        metadata={
            "description": "This is what our non-authoritative source thought the score was."
        }
    )
    end_time: t.Optional[str] = dt.field(
        default=None,
        metadata={
            "description": 'If you\'re still in it but it "ended" (like when folks are dancing around the loot after they beat a boss), this is when the activity ended.'
        },
    )
    start_time: t.Optional[str] = dt.field(
        default=None, metadata={"description": "When the activity started."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "startTime": to_json(self.start_time),
            "endTime": to_json(self.end_time),
            "score": to_json(self.score),
            "highestOpposingFactionScore": to_json(self.highest_opposing_faction_score),
            "numberOfOpponents": to_json(self.number_of_opponents),
            "numberOfPlayers": to_json(self.number_of_players),
        }


@dt.dataclass(frozen=True)
class DestinyProfileTransitoryJoinability:
    """Some basic information about whether you can be joined, how many slots
    are left etc.

    Note that this can change quickly, so it may not actually be useful.
    But perhaps it will be in some use cases?
    """

    closed_reasons: "DestinyJoinClosedReasons" = dt.field(
        metadata={
            "description": "Reasons why a person can't join this person's fireteam."
        }
    )
    open_slots: int = dt.field(
        metadata={
            "description": "The number of slots still available on this person's fireteam."
        }
    )
    privacy_setting: "DestinyGamePrivacySetting" = dt.field(
        metadata={"description": "Who the person is currently allowing invites from."}
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "openSlots": to_json(self.open_slots),
            "privacySetting": to_json(self.privacy_setting),
            "closedReasons": to_json(self.closed_reasons),
        }


@dt.dataclass(frozen=True)
class DestinyProfileTransitoryTrackingEntry:
    """This represents a single "thing" being tracked by the player.

    This can point to many types of entities, but only a subset of them
    will actually have a valid hash identifier for whatever it is being
    pointed to. It's up to you to interpret what it means when various
    combinations of these entries have values being tracked.
    """

    activity_hash: t.Optional[
        ManifestReference["DestinyActivityDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "OPTIONAL - If this is tracking the status of a DestinyActivityDefinition, this is the identifier for that activity."
        },
    )
    item_hash: t.Optional[
        ManifestReference["DestinyInventoryItemDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "OPTIONAL - If this is tracking the status of a DestinyInventoryItemDefinition, this is the identifier for that item."
        },
    )
    location_hash: t.Optional[
        ManifestReference["DestinyLocationDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "OPTIONAL - If this is tracking a DestinyLocationDefinition, this is the identifier for that location."
        },
    )
    objective_hash: t.Optional[
        ManifestReference["DestinyObjectiveDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "OPTIONAL - If this is tracking the status of a DestinyObjectiveDefinition, this is the identifier for that objective."
        },
    )
    questline_item_hash: t.Optional[
        ManifestReference["DestinyInventoryItemDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "OPTIONAL - If this is tracking the status of a quest, this is the identifier for the DestinyInventoryItemDefinition that containst that questline data."
        },
    )
    tracked_date: t.Optional[str] = dt.field(
        default=None,
        metadata={
            "description": """OPTIONAL - I've got to level with you, I don't really know what this is. Is it when you started tracking it? Is it only populated for tracked items that have time limits?
I don't know, but we can get at it - when I get time to actually test what it is, I'll update this. In the meantime, bask in the mysterious data."""
        },
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "locationHash": to_json(self.location_hash),
            "itemHash": to_json(self.item_hash),
            "objectiveHash": to_json(self.objective_hash),
            "activityHash": to_json(self.activity_hash),
            "questlineItemHash": to_json(self.questline_item_hash),
            "trackedDate": to_json(self.tracked_date),
        }


from bungieapi.generated.components.schemas.destiny import (  # noqa: E402
    DestinyGamePrivacySetting,
    DestinyJoinClosedReasons,
    DestinyPartyMemberStates,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.artifacts import (  # noqa: E402
    DestinyArtifactProfileScoped,
)
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyActivityDefinition,
    DestinyDestinationDefinition,
    DestinyInventoryItemDefinition,
    DestinyLocationDefinition,
    DestinyObjectiveDefinition,
)
