# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyEnvironmentLocationMapping:
    activation_source: str = dt.field(
        metadata={
            "description": "A hint that the UI uses to figure out how this location is activated by the player."
        }
    )
    location_hash: ManifestReference["DestinyLocationDefinition"] = dt.field(
        metadata={
            "description": "The location that is revealed on the director by this mapping."
        }
    )
    activity_hash: t.Optional[
        ManifestReference["DestinyActivityDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "If this is populated, this is the activity you have to be playing in order to see this location appear because of this mapping. (theoretically, a location can have multiple mappings, and some might require you to be in a specific activity when others don't)"
        },
    )
    item_hash: t.Optional[
        ManifestReference["DestinyInventoryItemDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "If this is populated, it is the item that you must possess for this location to be active because of this mapping. (theoretically, a location can have multiple mappings, and some might require an item while others don't)"
        },
    )
    objective_hash: t.Optional[
        ManifestReference["DestinyObjectiveDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "If this is populated, this is an objective related to the location."
        },
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "locationHash": to_json(self.location_hash),
            "activationSource": to_json(self.activation_source),
            "itemHash": to_json(self.item_hash),
            "objectiveHash": to_json(self.objective_hash),
            "activityHash": to_json(self.activity_hash),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyActivityDefinition,
    DestinyInventoryItemDefinition,
    DestinyLocationDefinition,
    DestinyObjectiveDefinition,
)
