# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyArtifactDefinition:
    """Represents known info about a Destiny Artifact.

    We cannot guarantee that artifact definitions will be immutable between seasons - in fact, we've been told that they will be replaced between seasons. But this definition is built both to minimize the amount of lookups for related data that have to occur, and is built in hope that, if this plan changes, we will be able to accommodate it more easily.
    """

    display_properties: "DestinyDisplayPropertiesDefinition" = dt.field(
        metadata={
            "description": "Any basic display info we know about the Artifact. Currently sourced from a related inventory item, but the source of this data is subject to change."
        }
    )
    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    tiers: t.Sequence["DestinyArtifactTierDefinition"] = dt.field(
        metadata={
            "description": "Any Tier/Rank data related to this artifact, listed in display order.  Currently sourced from a Vendor, but this source is subject to change."
        }
    )
    translation_block: "DestinyItemTranslationBlockDefinition" = dt.field(
        metadata={
            "description": "Any Geometry/3D info we know about the Artifact. Currently sourced from a related inventory item's gearset information, but the source of this data is subject to change."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "displayProperties": to_json(self.display_properties),
            "translationBlock": to_json(self.translation_block),
            "tiers": to_json(self.tiers),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


@dt.dataclass(frozen=True)
class DestinyArtifactTierDefinition:
    display_title: str = dt.field(
        metadata={"description": "The human readable title of this tier, if any."}
    )
    items: t.Sequence["DestinyArtifactTierItemDefinition"] = dt.field(
        metadata={"description": "The items that can be earned within this tier."}
    )
    minimum_unlock_points_used_requirement: int = dt.field(
        metadata={
            "description": 'The minimum number of "unlock points" that you must have used before you can unlock items from this tier.'
        }
    )
    progress_requirement_message: str = dt.field(
        metadata={
            "description": "A string representing the localized minimum requirement text for this Tier, if any."
        }
    )
    tier_hash: int = dt.field(
        metadata={
            "description": "An identifier, unique within the Artifact, for this specific tier."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "tierHash": to_json(self.tier_hash),
            "displayTitle": to_json(self.display_title),
            "progressRequirementMessage": to_json(self.progress_requirement_message),
            "items": to_json(self.items),
            "minimumUnlockPointsUsedRequirement": to_json(
                self.minimum_unlock_points_used_requirement
            ),
        }


@dt.dataclass(frozen=True)
class DestinyArtifactTierItemDefinition:
    item_hash: ManifestReference["DestinyInventoryItemDefinition"] = dt.field(
        metadata={
            "description": "The identifier of the Plug Item unlocked by activating this item in the Artifact."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "itemHash": to_json(self.item_hash),
        }


from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyInventoryItemDefinition,
    DestinyItemTranslationBlockDefinition,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions.common import (  # noqa: E402
    DestinyDisplayPropertiesDefinition,
)
