# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyChecklistDefinition:
    """By public demand, Checklists are loose sets of "things to do/things you
    have done" in Destiny that we were actually able to track.

    They include easter eggs you find in the world, unique chests you
    unlock, and other such data where the first time you do it is
    significant enough to be tracked, and you have the potential to "get
    them all". These may be account-wide, or may be per character. The
    status of these will be returned in related "Checklist" data coming
    down from API requests such as GetProfile or GetCharacter. Generally
    speaking, the items in a checklist can be completed in any order: we
    return an ordered list which only implies the way we are showing
    them in our own UI, and you can feel free to alter it as you wish.
    Note that, in the future, there will be something resembling the old
    D1 Record Books in at least some vague form. When that is created,
    it may be that it will supercede much or all of this Checklist data.
    It remains to be seen if that will be the case, so for now assume
    that the Checklists will still exist even after the release of D2:
    Forsaken.
    """

    display_properties: "DestinyDisplayPropertiesDefinition"
    entries: t.Sequence["DestinyChecklistEntryDefinition"] = dt.field(
        metadata={"description": "The individual checklist items. Gotta catch 'em all."}
    )
    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    scope: "DestinyScope" = dt.field(
        metadata={
            "description": "Indicates whether you will find this checklist on the Profile or Character components."
        }
    )
    view_action_string: str = dt.field(
        metadata={
            "description": "A localized string prompting you to view the checklist."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "displayProperties": to_json(self.display_properties),
            "viewActionString": to_json(self.view_action_string),
            "scope": to_json(self.scope),
            "entries": to_json(self.entries),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


@dt.dataclass(frozen=True)
class DestinyChecklistEntryDefinition:
    """The properties of an individual checklist item.

    Note that almost everything is optional: it is *highly* variable
    what kind of data we'll actually be able to return: at times we may
    have no other relationships to entities at all. Whatever UI you
    build, do it with the knowledge that any given entry might not
    actually be able to be associated with some other Destiny entity.
    """

    display_properties: "DestinyDisplayPropertiesDefinition" = dt.field(
        metadata={
            "description": "Even if no other associations exist, we will give you *something* for display properties. In cases where we have no associated entities, it may be as simple as a numerical identifier."
        }
    )
    hash: int = dt.field(
        metadata={
            "description": "The identifier for this Checklist entry. Guaranteed unique only within this Checklist Definition, and not globally/for all checklists."
        }
    )
    scope: "DestinyScope" = dt.field(
        metadata={
            "description": "The scope at which this specific entry can be computed."
        }
    )
    activity_hash: t.Optional[ManifestReference["DestinyActivityDefinition"]] = None
    bubble_hash: t.Optional[int] = dt.field(
        default=None,
        metadata={
            "description": """Note that a Bubble's hash doesn't uniquely identify a "top level" entity in Destiny. Only the combination of location and bubble can uniquely identify a place in the world of Destiny: so if bubbleHash is populated, locationHash must too be populated for it to have any meaning.
You can use this property if it is populated to look up the DestinyLocationDefinition's associated .locationReleases[].activityBubbleName property."""
        },
    )
    destination_hash: t.Optional[
        ManifestReference["DestinyDestinationDefinition"]
    ] = None
    item_hash: t.Optional[ManifestReference["DestinyInventoryItemDefinition"]] = None
    location_hash: t.Optional[ManifestReference["DestinyLocationDefinition"]] = None
    vendor_hash: t.Optional[ManifestReference["DestinyVendorDefinition"]] = None
    vendor_interaction_index: t.Optional[int] = None

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "hash": to_json(self.hash),
            "displayProperties": to_json(self.display_properties),
            "destinationHash": to_json(self.destination_hash),
            "locationHash": to_json(self.location_hash),
            "bubbleHash": to_json(self.bubble_hash),
            "activityHash": to_json(self.activity_hash),
            "itemHash": to_json(self.item_hash),
            "vendorHash": to_json(self.vendor_hash),
            "vendorInteractionIndex": to_json(self.vendor_interaction_index),
            "scope": to_json(self.scope),
        }


from bungieapi.generated.components.schemas.destiny import DestinyScope  # noqa: E402
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyActivityDefinition,
    DestinyDestinationDefinition,
    DestinyInventoryItemDefinition,
    DestinyLocationDefinition,
    DestinyVendorDefinition,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions.common import (  # noqa: E402
    DestinyDisplayPropertiesDefinition,
)
