# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyEnergyTypeDefinition:
    """Represents types of Energy that can be used for costs and payments
    related to Armor 2.0 mods."""

    cost_stat_hash: ManifestReference["DestinyStatDefinition"] = dt.field(
        metadata={
            "description": "If this Energy Type can be used as a cost to pay for socketing Armor 2.0 items, this is the hash for the DestinyInvestmentStatDefinition that stores the plug's raw cost."
        }
    )
    display_properties: "DestinyDisplayPropertiesDefinition" = dt.field(
        metadata={"description": "The description of the energy type, icon etc..."}
    )
    enum_value: "DestinyEnergyType" = dt.field(
        metadata={
            "description": "We have an enumeration for Energy types for quick reference. This is the current definition's Energy type enum value."
        }
    )
    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    show_icon: bool = dt.field(
        metadata={
            "description": "If TRUE, the game shows this Energy type's icon. Otherwise, it doesn't. Whether you show it or not is up to you."
        }
    )
    transparent_icon_path: str = dt.field(
        metadata={
            "description": "A variant of the icon that is transparent and colorless."
        }
    )
    capacity_stat_hash: t.Optional[
        ManifestReference["DestinyStatDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": 'If this Energy Type can be used for determining the Type of Energy that an item can consume, this is the hash for the DestinyInvestmentStatDefinition that represents the stat which holds the Capacity for that energy type. (Note that this is optional because "Any" is a valid cost, but not valid for Capacity - an Armor must have a specific Energy Type for determining the energy type that the Armor is restricted to use)'
        },
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "displayProperties": to_json(self.display_properties),
            "transparentIconPath": to_json(self.transparent_icon_path),
            "showIcon": to_json(self.show_icon),
            "enumValue": to_json(self.enum_value),
            "capacityStatHash": to_json(self.capacity_stat_hash),
            "costStatHash": to_json(self.cost_stat_hash),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


from bungieapi.generated.components.schemas.destiny import (  # noqa: E402
    DestinyEnergyType,
)
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyStatDefinition,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions.common import (  # noqa: E402
    DestinyDisplayPropertiesDefinition,
)
