# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyMetricDefinition:
    display_properties: "DestinyDisplayPropertiesDefinition"
    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    lower_value_is_better: bool
    parent_node_hashes: t.Sequence[int] = dt.field(
        metadata={
            "description": "A quick reference to presentation nodes that have this node as a child. Presentation nodes can be parented under multiple parents."
        }
    )
    presentation_node_type: "DestinyPresentationNodeType"
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    tracking_objective_hash: ManifestReference["DestinyObjectiveDefinition"]
    trait_hashes: t.Sequence[int]
    trait_ids: t.Sequence[str]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "displayProperties": to_json(self.display_properties),
            "trackingObjectiveHash": to_json(self.tracking_objective_hash),
            "lowerValueIsBetter": to_json(self.lower_value_is_better),
            "presentationNodeType": to_json(self.presentation_node_type),
            "traitIds": to_json(self.trait_ids),
            "traitHashes": to_json(self.trait_hashes),
            "parentNodeHashes": to_json(self.parent_node_hashes),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


from bungieapi.generated.components.schemas.destiny import (  # noqa: E402
    DestinyPresentationNodeType,
)
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyObjectiveDefinition,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions.common import (  # noqa: E402
    DestinyDisplayPropertiesDefinition,
)
