# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyPresentationNodeBaseDefinition:
    """This is the base class for all presentation system children.

    Presentation Nodes, Records, Collectibles, and Metrics.
    """

    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    parent_node_hashes: t.Sequence[int] = dt.field(
        metadata={
            "description": "A quick reference to presentation nodes that have this node as a child. Presentation nodes can be parented under multiple parents."
        }
    )
    presentation_node_type: "DestinyPresentationNodeType"
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    trait_hashes: t.Sequence[int]
    trait_ids: t.Sequence[str]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "presentationNodeType": to_json(self.presentation_node_type),
            "traitIds": to_json(self.trait_ids),
            "traitHashes": to_json(self.trait_hashes),
            "parentNodeHashes": to_json(self.parent_node_hashes),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


@dt.dataclass(frozen=True)
class DestinyScoredPresentationNodeBaseDefinition:
    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    max_category_record_score: int
    parent_node_hashes: t.Sequence[int] = dt.field(
        metadata={
            "description": "A quick reference to presentation nodes that have this node as a child. Presentation nodes can be parented under multiple parents."
        }
    )
    presentation_node_type: "DestinyPresentationNodeType"
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    trait_hashes: t.Sequence[int]
    trait_ids: t.Sequence[str]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "maxCategoryRecordScore": to_json(self.max_category_record_score),
            "presentationNodeType": to_json(self.presentation_node_type),
            "traitIds": to_json(self.trait_ids),
            "traitHashes": to_json(self.trait_hashes),
            "parentNodeHashes": to_json(self.parent_node_hashes),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


@dt.dataclass(frozen=True)
class DestinyPresentationNodeDefinition:
    """A PresentationNode is an entity that represents a logical grouping of
    other entities visually/organizationally. For now, Presentation Nodes may
    contain the following... but it may be used for more in the future:

    - Collectibles - Records (Or, as the public will call them, "Triumphs." Don't ask me why we're overloading the term "Triumph", it still hurts me to think about it) - Metrics (aka Stat Trackers) - Other Presentation Nodes, allowing a tree of Presentation Nodes to be created
    Part of me wants to break these into conceptual definitions per entity being collected, but the possibility of these different types being mixed in the same UI and the possibility that it could actually be more useful to return the "bare metal" presentation node concept has resulted in me deciding against that for the time being.
    We'll see if I come to regret this as well.
    """

    children: "DestinyPresentationNodeChildrenBlock" = dt.field(
        metadata={
            "description": "The child entities contained by this presentation node."
        }
    )
    disable_child_subscreen_navigation: bool = dt.field(
        metadata={
            "description": "If this presentation node has children, but the game doesn't let you inspect the details of those children, that is indicated here."
        }
    )
    display_properties: "DestinyDisplayPropertiesDefinition"
    display_style: "DestinyPresentationDisplayStyle" = dt.field(
        metadata={
            "description": "A hint for how to display this presentation node when it's shown in a list."
        }
    )
    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    max_category_record_score: int
    node_type: "DestinyPresentationNodeType"
    original_icon: str = dt.field(
        metadata={
            "description": "The original icon for this presentation node, before we futzed with it."
        }
    )
    parent_node_hashes: t.Sequence[int] = dt.field(
        metadata={
            "description": "A quick reference to presentation nodes that have this node as a child. Presentation nodes can be parented under multiple parents."
        }
    )
    presentation_node_type: "DestinyPresentationNodeType"
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    requirements: "DestinyPresentationNodeRequirementsBlock" = dt.field(
        metadata={
            "description": "The requirements for being able to interact with this presentation node and its children."
        }
    )
    root_view_icon: str = dt.field(
        metadata={
            "description": 'Some presentation nodes are meant to be explicitly shown on the "root" or "entry" screens for the feature to which they are related. You should use this icon when showing them on such a view, if you have a similar "entry point" view in your UI. If you don\'t have a UI, then I guess it doesn\'t matter either way does it?'
        }
    )
    scope: "DestinyScope" = dt.field(
        metadata={
            "description": "Indicates whether this presentation node's state is determined on a per-character or on an account-wide basis."
        }
    )
    screen_style: "DestinyPresentationScreenStyle" = dt.field(
        metadata={
            "description": "A hint for how to display this presentation node when it's shown in its own detail screen."
        }
    )
    trait_hashes: t.Sequence[int]
    trait_ids: t.Sequence[str]
    completion_record_hash: t.Optional[
        ManifestReference["DestinyRecordDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": 'If this presentation node has an associated "Record" that you can accomplish for completing its children, this is the identifier of that Record.'
        },
    )
    objective_hash: t.Optional[
        ManifestReference["DestinyObjectiveDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "If this presentation node shows a related objective (for instance, if it tracks the progress of its children), the objective being tracked is indicated here."
        },
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "displayProperties": to_json(self.display_properties),
            "originalIcon": to_json(self.original_icon),
            "rootViewIcon": to_json(self.root_view_icon),
            "nodeType": to_json(self.node_type),
            "scope": to_json(self.scope),
            "objectiveHash": to_json(self.objective_hash),
            "completionRecordHash": to_json(self.completion_record_hash),
            "children": to_json(self.children),
            "displayStyle": to_json(self.display_style),
            "screenStyle": to_json(self.screen_style),
            "requirements": to_json(self.requirements),
            "disableChildSubscreenNavigation": to_json(
                self.disable_child_subscreen_navigation
            ),
            "maxCategoryRecordScore": to_json(self.max_category_record_score),
            "presentationNodeType": to_json(self.presentation_node_type),
            "traitIds": to_json(self.trait_ids),
            "traitHashes": to_json(self.trait_hashes),
            "parentNodeHashes": to_json(self.parent_node_hashes),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


@dt.dataclass(frozen=True)
class DestinyPresentationNodeChildrenBlock:
    """As/if presentation nodes begin to host more entities as children, these
    lists will be added to.

    One list property exists per type of entity that can be treated as a
    child of this presentation node, and each holds the identifier of
    the entity and any associated information needed to display the UI
    for that entity (if anything)
    """

    collectibles: t.Sequence["DestinyPresentationNodeCollectibleChildEntry"]
    craftables: t.Sequence["DestinyPresentationNodeCraftableChildEntry"]
    metrics: t.Sequence["DestinyPresentationNodeMetricChildEntry"]
    presentation_nodes: t.Sequence["DestinyPresentationNodeChildEntry"]
    records: t.Sequence["DestinyPresentationNodeRecordChildEntry"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "presentationNodes": to_json(self.presentation_nodes),
            "collectibles": to_json(self.collectibles),
            "records": to_json(self.records),
            "metrics": to_json(self.metrics),
            "craftables": to_json(self.craftables),
        }


@dt.dataclass(frozen=True)
class DestinyPresentationNodeChildEntryBase:
    node_display_priority: int = dt.field(
        metadata={
            "description": "Use this value to sort the presentation node children in ascending order."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "nodeDisplayPriority": to_json(self.node_display_priority),
        }


@dt.dataclass(frozen=True)
class DestinyPresentationNodeChildEntry:
    node_display_priority: int = dt.field(
        metadata={
            "description": "Use this value to sort the presentation node children in ascending order."
        }
    )
    presentation_node_hash: ManifestReference["DestinyPresentationNodeDefinition"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "presentationNodeHash": to_json(self.presentation_node_hash),
            "nodeDisplayPriority": to_json(self.node_display_priority),
        }


@dt.dataclass(frozen=True)
class DestinyPresentationNodeCollectibleChildEntry:
    collectible_hash: ManifestReference["DestinyCollectibleDefinition"]
    node_display_priority: int = dt.field(
        metadata={
            "description": "Use this value to sort the presentation node children in ascending order."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "collectibleHash": to_json(self.collectible_hash),
            "nodeDisplayPriority": to_json(self.node_display_priority),
        }


@dt.dataclass(frozen=True)
class DestinyPresentationNodeRequirementsBlock:
    """Presentation nodes can be restricted by various requirements.

    This defines the rules of those requirements, and the message(s) to
    be shown if these requirements aren't met.
    """

    entitlement_unavailable_message: str = dt.field(
        metadata={
            "description": "If this node is not accessible due to Entitlements (for instance, you don't own the required game expansion), this is the message to show."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "entitlementUnavailableMessage": to_json(
                self.entitlement_unavailable_message
            ),
        }


@dt.dataclass(frozen=True)
class DestinyPresentationChildBlock:
    display_style: "DestinyPresentationDisplayStyle"
    parent_presentation_node_hashes: t.Sequence[int]
    presentation_node_type: "DestinyPresentationNodeType"

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "presentationNodeType": to_json(self.presentation_node_type),
            "parentPresentationNodeHashes": to_json(
                self.parent_presentation_node_hashes
            ),
            "displayStyle": to_json(self.display_style),
        }


@dt.dataclass(frozen=True)
class DestinyPresentationNodeRecordChildEntry:
    node_display_priority: int = dt.field(
        metadata={
            "description": "Use this value to sort the presentation node children in ascending order."
        }
    )
    record_hash: ManifestReference["DestinyRecordDefinition"]

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "recordHash": to_json(self.record_hash),
            "nodeDisplayPriority": to_json(self.node_display_priority),
        }


@dt.dataclass(frozen=True)
class DestinyPresentationNodeMetricChildEntry:
    metric_hash: ManifestReference["DestinyMetricDefinition"]
    node_display_priority: int = dt.field(
        metadata={
            "description": "Use this value to sort the presentation node children in ascending order."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "metricHash": to_json(self.metric_hash),
            "nodeDisplayPriority": to_json(self.node_display_priority),
        }


@dt.dataclass(frozen=True)
class DestinyPresentationNodeCraftableChildEntry:
    craftable_item_hash: ManifestReference["DestinyInventoryItemDefinition"]
    node_display_priority: int = dt.field(
        metadata={
            "description": "Use this value to sort the presentation node children in ascending order."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "craftableItemHash": to_json(self.craftable_item_hash),
            "nodeDisplayPriority": to_json(self.node_display_priority),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny import DestinyScope  # noqa: E402
from bungieapi.generated.components.schemas.destiny import (  # noqa: E402
    DestinyPresentationDisplayStyle,
    DestinyPresentationNodeType,
    DestinyPresentationScreenStyle,
)
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyInventoryItemDefinition,
    DestinyObjectiveDefinition,
)
from bungieapi.generated.components.schemas.destiny.definitions.collectibles import (  # noqa: E402
    DestinyCollectibleDefinition,
)
from bungieapi.generated.components.schemas.destiny.definitions.common import (  # noqa: E402
    DestinyDisplayPropertiesDefinition,
)
from bungieapi.generated.components.schemas.destiny.definitions.metrics import (  # noqa: E402
    DestinyMetricDefinition,
)
from bungieapi.generated.components.schemas.destiny.definitions.records import (  # noqa: E402
    DestinyRecordDefinition,
)
