# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyProgressionLevelRequirementDefinition:
    """These are pre-constructed collections of data that can be used to
    determine the Level Requirement for an item given a Progression to be
    tested (such as the Character's level).

    For instance, say a character receives a new Auto Rifle, and that Auto Rifle's DestinyInventoryItemDefinition.quality.progressionLevelRequirementHash property is pointing at one of these DestinyProgressionLevelRequirementDefinitions. Let's pretend also that the progressionHash it is pointing at is the Character Level progression. In that situation, the character's level will be used to interpolate a value in the requirementCurve property. The value picked up from that interpolation will be the required level for the item.
    """

    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    progression_hash: ManifestReference["DestinyProgressionDefinition"] = dt.field(
        metadata={
            "description": """The progression whose level should be used to determine the level requirement.
Look up the DestinyProgressionDefinition with this hash for more information about the progression in question."""
        }
    )
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    requirement_curve: t.Sequence["InterpolationPointFloat"] = dt.field(
        metadata={
            "description": """A curve of level requirements, weighted by the related progressions' level.
Interpolate against this curve with the character's progression level to determine what the level requirement of the generated item that is using this data will be."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "requirementCurve": to_json(self.requirement_curve),
            "progressionHash": to_json(self.progression_hash),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyProgressionDefinition,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.interpolation import (  # noqa: E402
    InterpolationPointFloat,
)
