# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinySocketTypeDefinition:
    """All Sockets have a "Type": a set of common properties that determine
    when the socket allows Plugs to be inserted, what Categories of Plugs can
    be inserted, and whether the socket is even visible at all given the
    current game/character/account state.

    See DestinyInventoryItemDefinition for more information about
    Socketed items and Plugs.
    """

    always_randomize_sockets: bool
    avoid_duplicates_on_initialization: bool
    currency_scalars: t.Sequence["DestinySocketTypeScalarMaterialRequirementEntry"]
    display_properties: "DestinyDisplayPropertiesDefinition" = dt.field(
        metadata={
            "description": "There are fields for this display data, but they appear to be unpopulated as of now. I am not sure where in the UI these would show if they even were populated, but I will continue to return this data in case it becomes useful."
        }
    )
    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    hide_duplicate_reusable_plugs: bool
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    insert_action: "DestinyInsertPlugActionDefinition" = dt.field(
        metadata={
            "description": "Defines what happens when a plug is inserted into sockets of this type."
        }
    )
    is_preview_enabled: bool
    overrides_ui_appearance: bool = dt.field(
        metadata={
            "description": "This property indicates if the socket type determines whether Emblem icons and nameplates should be overridden by the inserted plug item's icon and nameplate."
        }
    )
    plug_whitelist: t.Sequence["DestinyPlugWhitelistEntryDefinition"] = dt.field(
        metadata={
            "description": """A list of Plug "Categories" that are allowed to be plugged into sockets of this type.
These should be compared against a given plug item's DestinyInventoryItemDefinition.plug.plugCategoryHash, which indicates the plug item's category.
If the plug's category matches any whitelisted plug, or if the whitelist is empty, it is allowed to be inserted."""
        }
    )
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    socket_category_hash: ManifestReference["DestinySocketCategoryDefinition"]
    visibility: "DestinySocketVisibility" = dt.field(
        metadata={
            "description": "Sometimes a socket isn't visible. These are some of the conditions under which sockets of this type are not visible. Unfortunately, the truth of visibility is much, much more complex. Best to rely on the live data for whether the socket is visible and enabled."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "displayProperties": to_json(self.display_properties),
            "insertAction": to_json(self.insert_action),
            "plugWhitelist": to_json(self.plug_whitelist),
            "socketCategoryHash": to_json(self.socket_category_hash),
            "visibility": to_json(self.visibility),
            "alwaysRandomizeSockets": to_json(self.always_randomize_sockets),
            "isPreviewEnabled": to_json(self.is_preview_enabled),
            "hideDuplicateReusablePlugs": to_json(self.hide_duplicate_reusable_plugs),
            "overridesUiAppearance": to_json(self.overrides_ui_appearance),
            "avoidDuplicatesOnInitialization": to_json(
                self.avoid_duplicates_on_initialization
            ),
            "currencyScalars": to_json(self.currency_scalars),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


@dt.dataclass(frozen=True)
class DestinyInsertPlugActionDefinition:
    """Data related to what happens while a plug is being inserted, mostly for
    UI purposes."""

    action_execute_seconds: int = dt.field(
        metadata={
            "description": "How long it takes for the Plugging of the item to be completed once it is initiated, if you care."
        }
    )
    action_type: "SocketTypeActionType" = dt.field(
        metadata={
            "description": 'The type of action being performed when you act on this Socket Type. The most common value is "insert plug", but there are others as well (for instance, a "Masterwork" socket may allow for Re-initialization, and an Infusion socket allows for items to be consumed to upgrade the item)'
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "actionExecuteSeconds": to_json(self.action_execute_seconds),
            "actionType": to_json(self.action_type),
        }


@dt.dataclass(frozen=True)
class DestinyPlugWhitelistEntryDefinition:
    """Defines a plug "Category" that is allowed to be plugged into a socket of
    this type.

    This should be compared against a given plug item's DestinyInventoryItemDefinition.plug.plugCategoryHash, which indicates the plug item's category.
    """

    category_hash: int = dt.field(
        metadata={
            "description": """The hash identifier of the Plug Category to compare against the plug item's plug.plugCategoryHash.
Note that this does NOT relate to any Definition in itself, it is only used for comparison purposes."""
        }
    )
    category_identifier: str = dt.field(
        metadata={
            "description": "The string identifier for the category, which is here mostly for debug purposes."
        }
    )
    reinitialization_possible_plug_hashes: t.Sequence[int] = dt.field(
        metadata={
            "description": """The list of all plug items (DestinyInventoryItemDefinition) that the socket may randomly be populated with when reinitialized.
Which ones you should actually show are determined by the plug being inserted into the socket, and the socket’s type.
When you inspect the plug that could go into a Masterwork Socket, look up the socket type of the socket being inspected and find the DestinySocketTypeDefinition.
Then, look at the Plugs that can fit in that socket. Find the Whitelist in the DestinySocketTypeDefinition that matches the plug item’s categoryhash.
That whitelist entry will potentially have a new “reinitializationPossiblePlugHashes” property.If it does, that means we know what it will roll if you try to insert this plug into this socket."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "categoryHash": to_json(self.category_hash),
            "categoryIdentifier": to_json(self.category_identifier),
            "reinitializationPossiblePlugHashes": to_json(
                self.reinitialization_possible_plug_hashes
            ),
        }


@dt.dataclass(frozen=True)
class DestinySocketTypeScalarMaterialRequirementEntry:
    currency_item_hash: ManifestReference["DestinyInventoryItemDefinition"]
    scalar_value: int

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "currencyItemHash": to_json(self.currency_item_hash),
            "scalarValue": to_json(self.scalar_value),
        }


@dt.dataclass(frozen=True)
class DestinySocketCategoryDefinition:
    """Sockets on an item are organized into Categories visually.

    You can find references to the socket category defined on an item's DestinyInventoryItemDefinition.sockets.socketCategories property.
    This has the display information for rendering the categories' header, and a hint for how the UI should handle showing this category.
    The shitty thing about this, however, is that the socket categories' UI style can be overridden by the item's UI style. For instance, the Socket Category used by Emote Sockets says it's "consumable," but that's a lie: they're all reusable, and overridden by the detail UI pages in ways that we can't easily account for in the API.
    As a result, I will try to compile these rules into the individual sockets on items, and provide the best hint possible there through the plugSources property. In the future, I may attempt to use this information in conjunction with the item to provide a more usable UI hint on the socket layer, but for now improving the consistency of plugSources is the best I have time to provide. (See https://github.com/Bungie-net/api/issues/522 for more info)
    """

    category_style: "DestinySocketCategoryStyle" = dt.field(
        metadata={
            "description": "Same as uiCategoryStyle, but in a more usable enumeration form."
        }
    )
    display_properties: "DestinyDisplayPropertiesDefinition"
    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    ui_category_style: int = dt.field(
        metadata={
            "description": """A string hinting to the game's UI system about how the sockets in this category should be displayed.
BNet doesn't use it: it's up to you to find valid values and make your own special UI if you want to honor this category style."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "displayProperties": to_json(self.display_properties),
            "uiCategoryStyle": to_json(self.ui_category_style),
            "categoryStyle": to_json(self.category_style),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


@dt.dataclass(frozen=True)
class DestinyPlugSetDefinition:
    """Sometimes, we have large sets of reusable plugs that are defined
    identically and thus can (and in some cases, are so large that they *must*)
    be shared across the places where they are used. These are the definitions
    for those reusable sets of plugs. See
    DestinyItemSocketEntryDefinition.plugSource and reusablePlugSetHash for the
    relationship between these reusable plug sets and the sockets that leverage
    them (for starters, Emotes).

    As of the release of Shadowkeep (Late 2019), these will begin to be sourced from game content directly - which means there will be many more of them, but it also means we may not get all data that we used to get for them.
    DisplayProperties, in particular, will no longer be guaranteed to contain valid information. We will make a best effort to guess what ought to be populated there where possible, but it will be invalid for many/most plug sets.
    """

    display_properties: "DestinyDisplayPropertiesDefinition" = dt.field(
        metadata={
            "description": "If you want to show these plugs in isolation, these are the display properties for them."
        }
    )
    hash: int = dt.field(
        metadata={
            "description": """The unique identifier for this entity. Guaranteed to be unique for the type of entity, but not globally.
When entities refer to each other in Destiny content, it is this hash that they are referring to."""
        }
    )
    index: int = dt.field(
        metadata={
            "description": "The index of the entity as it was found in the investment tables."
        }
    )
    is_fake_plug_set: bool = dt.field(
        metadata={
            "description": """Mostly for our debugging or reporting bugs, BNet is making "fake" plug sets in a desperate effort to reduce socket sizes.
 If this is true, the plug set was generated by BNet: if it looks wrong, that's a good indicator that it's bungie.net that fucked this up."""
        }
    )
    redacted: bool = dt.field(
        metadata={
            "description": "If this is true, then there is an entity with this identifier/type combination, but BNet is not yet allowed to show it. Sorry!"
        }
    )
    reusable_plug_items: t.Sequence[
        "DestinyItemSocketEntryPlugItemRandomizedDefinition"
    ] = dt.field(
        metadata={
            "description": """This is a list of pre-determined plugs that can be plugged into this socket, without the character having the plug in their inventory.
If this list is populated, you will not be allowed to plug an arbitrary item in the socket: you will only be able to choose from one of these reusable plugs."""
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "displayProperties": to_json(self.display_properties),
            "reusablePlugItems": to_json(self.reusable_plug_items),
            "isFakePlugSet": to_json(self.is_fake_plug_set),
            "hash": to_json(self.hash),
            "index": to_json(self.index),
            "redacted": to_json(self.redacted),
        }


from bungieapi.generated.components.schemas.destiny import (  # noqa: E402
    DestinySocketCategoryStyle,
    DestinySocketVisibility,
    SocketTypeActionType,
)
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyInventoryItemDefinition,
    DestinyItemSocketEntryPlugItemRandomizedDefinition,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions.common import (  # noqa: E402
    DestinyDisplayPropertiesDefinition,
)
