# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json


@dt.dataclass(frozen=True)
class DestinyItemSourceDefinition:
    """Properties of a DestinyInventoryItemDefinition that store all of the
    information we were able to discern about how the item spawns, and where
    you can find the item.

    Items will have many of these sources, one per level at which it
    spawns, to try and give more granular data about where items spawn
    for specific level ranges.
    """

    computed_stats: t.Mapping[str, "DestinyInventoryItemStatDefinition"] = dt.field(
        metadata={"description": "The stats computed for this level/quality range."}
    )
    level: int = dt.field(
        metadata={
            "description": "The level at which the item spawns. Essentially the Primary Key for this source data: there will be multiple of these source entries per item that has source data, grouped by the level at which the item spawns."
        }
    )
    max_level_required: int = dt.field(
        metadata={
            "description": "The maximum Character Level required for equipping the item when the item spawns at the item level defined on this DestinyItemSourceDefinition, as far as we saw in our processing."
        }
    )
    max_quality: int = dt.field(
        metadata={
            "description": "The maximum quality at which the item spawns for this level."
        }
    )
    min_level_required: int = dt.field(
        metadata={
            "description": "The minimum Character Level required for equipping the item when the item spawns at the item level defined on this DestinyItemSourceDefinition, as far as we saw in our processing."
        }
    )
    min_quality: int = dt.field(
        metadata={
            "description": "The minimum Quality at which the item spawns for this level. Examine DestinyInventoryItemDefinition for more information about what Quality means. Just don't ask Phaedrus about it, he'll never stop talking and you'll have to write a book about it."
        }
    )
    source_hashes: t.Sequence[int] = dt.field(
        metadata={
            "description": "The DestinyRewardSourceDefinitions found that can spawn the item at this level."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "level": to_json(self.level),
            "minQuality": to_json(self.min_quality),
            "maxQuality": to_json(self.max_quality),
            "minLevelRequired": to_json(self.min_level_required),
            "maxLevelRequired": to_json(self.max_level_required),
            "computedStats": to_json(self.computed_stats),
            "sourceHashes": to_json(self.source_hashes),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyInventoryItemStatDefinition,
)
