# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json


@dt.dataclass(frozen=True)
class DestinyInventoryComponent:
    """A list of minimal information for items in an inventory: be it a
    character's inventory, or a Profile's inventory.

    (Note that the Vault is a collection of inventory buckets in the
    Profile's inventory) Inventory Items returned here are in a flat
    list, but importantly they have a bucketHash property that indicates
    the specific inventory bucket that is holding them. These buckets
    constitute things like the separate sections of the Vault, the
    user's inventory slots, etc. See DestinyInventoryBucketDefinition
    for more info.
    """

    items: t.Sequence["DestinyItemComponent"] = dt.field(
        metadata={
            "description": "The items in this inventory. If you care to bucket them, use the item's bucketHash property to group them."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "items": to_json(self.items),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.entities.items import (  # noqa: E402
    DestinyItemComponent,
)
