# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyVendorReceiptsComponent:
    """For now, this isn't used for much: it's a record of the recent
    refundable purchases that the user has made.

    In the future, it could be used for providing refunds/buyback via
    the API. Wouldn't that be fun?
    """

    receipts: t.Sequence["DestinyVendorReceipt"] = dt.field(
        metadata={
            "description": "The receipts for refundable purchases made at a vendor."
        }
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "receipts": to_json(self.receipts),
        }


@dt.dataclass(frozen=True)
class DestinyProfileComponent:
    """The most essential summary information about a Profile (in Destiny 1, we
    called these "Accounts")."""

    character_ids: t.Sequence[int] = dt.field(
        metadata={
            "description": "A list of the character IDs, for further querying on your part."
        }
    )
    date_last_played: str = dt.field(
        metadata={
            "description": "The last time the user played with any character on this Profile."
        }
    )
    season_hashes: t.Sequence[int] = dt.field(
        metadata={
            "description": """A list of seasons that this profile owns. Unlike versionsOwned, these stay with the profile across Platforms, and thus will be valid.
 It turns out that Stadia Pro subscriptions will give access to seasons but only while playing on Stadia and with an active subscription. So some users (users who have Stadia Pro but choose to play on some other platform) won't see these as available: it will be whatever seasons are available for the platform on which they last played."""
        }
    )
    user_info: "UserInfoCard" = dt.field(
        metadata={
            "description": "If you need to render the Profile (their platform name, icon, etc...) somewhere, this property contains that information."
        }
    )
    versions_owned: "DestinyGameVersions" = dt.field(
        metadata={
            "description": """If you want to know what expansions they own, this will contain that data.
 IMPORTANT: This field may not return the data you're interested in for Cross-Saved users. It returns the last ownership data we saw for this account - which is to say, what they've purchased on the platform on which they last played, which now could be a different platform.
 If you don't care about per-platform ownership and only care about whatever platform it seems they are playing on most recently, then this should be "good enough." Otherwise, this should be considered deprecated. We do not have a good alternative to provide at this time with platform specific ownership data for DLC."""
        }
    )
    current_season_hash: t.Optional[
        ManifestReference["DestinySeasonDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "If populated, this is a reference to the season that is currently active."
        },
    )
    current_season_reward_power_cap: t.Optional[int] = dt.field(
        default=None,
        metadata={
            "description": "If populated, this is the reward power cap for the current season."
        },
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "userInfo": to_json(self.user_info),
            "dateLastPlayed": to_json(self.date_last_played),
            "versionsOwned": to_json(self.versions_owned),
            "characterIds": to_json(self.character_ids),
            "seasonHashes": to_json(self.season_hashes),
            "currentSeasonHash": to_json(self.current_season_hash),
            "currentSeasonRewardPowerCap": to_json(
                self.current_season_reward_power_cap
            ),
        }


from bungieapi.generated.components.schemas.destiny import (  # noqa: E402
    DestinyGameVersions,
)
from bungieapi.generated.components.schemas.destiny.definitions.seasons import (  # noqa: E402
    DestinySeasonDefinition,
)

# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.vendors import (  # noqa: E402
    DestinyVendorReceipt,
)
from bungieapi.generated.components.schemas.user import UserInfoCard  # noqa: E402
