# generated by update to not change manually
import dataclasses as dt
import typing as t

from bungieapi.json import to_json
from bungieapi.types import ManifestReference


@dt.dataclass(frozen=True)
class DestinyObjectiveProgress:
    """Returns data about a character's status with a given Objective.

    Combine with DestinyObjectiveDefinition static data for display
    purposes.
    """

    complete: bool = dt.field(
        metadata={"description": "Whether or not the Objective is completed."}
    )
    completion_value: int = dt.field(
        metadata={
            "description": """As of Forsaken, objectives' completion value is determined dynamically at runtime.
This value represents the threshold of progress you need to surpass in order for this objective to be considered "complete".
If you were using objective data, switch from using the DestinyObjectiveDefinition's "completionValue" to this value."""
        }
    )
    objective_hash: ManifestReference["DestinyObjectiveDefinition"] = dt.field(
        metadata={
            "description": "The unique identifier of the Objective being referred to. Use to look up the DestinyObjectiveDefinition in static data."
        }
    )
    visible: bool = dt.field(
        metadata={
            "description": "If this is true, the objective is visible in-game. Otherwise, it's not yet visible to the player. Up to you if you want to honor this property."
        }
    )
    activity_hash: t.Optional[
        ManifestReference["DestinyActivityDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "If the Objective has an Activity associated with it, this is the unique identifier of the Activity being referred to. Use to look up the DestinyActivityDefinition in static data. This will give localized data about *what* you should be playing for the objective to be achieved."
        },
    )
    destination_hash: t.Optional[
        ManifestReference["DestinyDestinationDefinition"]
    ] = dt.field(
        default=None,
        metadata={
            "description": "If the Objective has a Destination associated with it, this is the unique identifier of the Destination being referred to. Use to look up the DestinyDestinationDefinition in static data. This will give localized data about *where* in the universe the objective should be achieved."
        },
    )
    progress: t.Optional[int] = dt.field(
        default=None,
        metadata={
            "description": "If progress has been made, and the progress can be measured numerically, this will be the value of that progress. You can compare it to the DestinyObjectiveDefinition.completionValue property for current vs. upper bounds, and use DestinyObjectiveDefinition.valueStyle to determine how this should be rendered. Note that progress, in Destiny 2, need not be a literal numeric progression. It could be one of a number of possible values, even a Timestamp. Always examine DestinyObjectiveDefinition.valueStyle before rendering progress."
        },
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "objectiveHash": to_json(self.objective_hash),
            "destinationHash": to_json(self.destination_hash),
            "activityHash": to_json(self.activity_hash),
            "progress": to_json(self.progress),
            "completionValue": to_json(self.completion_value),
            "complete": to_json(self.complete),
            "visible": to_json(self.visible),
        }


@dt.dataclass(frozen=True)
class DestinyQuestStatus:
    """Data regarding the progress of a Quest for a specific character.

    Quests are composed of multiple steps, each with potentially
    multiple objectives: this QuestStatus will return Objective data for
    the *currently active* step in this quest.
    """

    completed: bool = dt.field(
        metadata={
            "description": "Whether or not the whole quest has been completed, regardless of whether or not you have redeemed the rewards for the quest."
        }
    )
    item_instance_id: int = dt.field(
        metadata={
            "description": "The current Quest Step will be an instanced item in the player's inventory. If you care about that, this is the instance ID of that item."
        }
    )
    quest_hash: ManifestReference["DestinyInventoryItemDefinition"] = dt.field(
        metadata={
            "description": "The hash identifier for the Quest Item. (Note: Quests are defined as Items, and thus you would use this to look up the quest's DestinyInventoryItemDefinition). For information on all steps in the quest, you can then examine its DestinyInventoryItemDefinition.setData property for Quest Steps (which are *also* items). You can use the Item Definition to display human readable data about the overall quest."
        }
    )
    redeemed: bool = dt.field(
        metadata={
            "description": "Whether or not you have redeemed rewards for this quest."
        }
    )
    started: bool = dt.field(
        metadata={"description": "Whether or not you have started this quest."}
    )
    step_hash: ManifestReference["DestinyInventoryItemDefinition"] = dt.field(
        metadata={
            "description": "The hash identifier of the current Quest Step, which is also a DestinyInventoryItemDefinition. You can use this to get human readable data about the current step and what to do in that step."
        }
    )
    step_objectives: t.Sequence["DestinyObjectiveProgress"] = dt.field(
        metadata={
            "description": "A step can have multiple objectives. This will give you the progress for each objective in the current step, in the order in which they are rendered in-game."
        }
    )
    tracked: bool = dt.field(
        metadata={"description": "Whether or not the quest is tracked"}
    )
    vendor_hash: t.Optional[int] = dt.field(
        default=None,
        metadata={
            "description": "If the quest has a related Vendor that you should talk to in order to initiate the quest/earn rewards/continue the quest, this will be the hash identifier of that Vendor. Look it up its DestinyVendorDefinition."
        },
    )

    def to_json(self) -> t.Mapping[str, t.Any]:
        return {
            "questHash": to_json(self.quest_hash),
            "stepHash": to_json(self.step_hash),
            "stepObjectives": to_json(self.step_objectives),
            "tracked": to_json(self.tracked),
            "itemInstanceId": to_json(self.item_instance_id),
            "completed": to_json(self.completed),
            "redeemed": to_json(self.redeemed),
            "started": to_json(self.started),
            "vendorHash": to_json(self.vendor_hash),
        }


# imported at the end to do not case circular imports for type annotations
from bungieapi.generated.components.schemas.destiny.definitions import (  # noqa: E402
    DestinyActivityDefinition,
    DestinyDestinationDefinition,
    DestinyInventoryItemDefinition,
    DestinyObjectiveDefinition,
)
